// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45728_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45728_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__45732 = coll;
var vec__45733 = G__45732;
var seq__45734 = cljs.core.seq(vec__45733);
var first__45735 = cljs.core.first(seq__45734);
var seq__45734__$1 = cljs.core.next(seq__45734);
var clause = first__45735;
var r = seq__45734__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__45732__$1 = G__45732;
var res__$1 = res;
while(true){
var vec__45739 = G__45732__$1;
var seq__45740 = cljs.core.seq(vec__45739);
var first__45741 = cljs.core.first(seq__45740);
var seq__45740__$1 = cljs.core.next(seq__45740);
var clause__$1 = first__45741;
var r__$1 = seq__45740__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__45742 = r__$1;
var G__45743 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__45732__$1 = G__45742;
res__$1 = G__45743;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__45744){
var map__45745 = p__45744;
var map__45745__$1 = cljs.core.__destructure_map(map__45745);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45745__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__45749 = coll;
var vec__45750 = G__45749;
var seq__45751 = cljs.core.seq(vec__45750);
var first__45752 = cljs.core.first(seq__45751);
var seq__45751__$1 = cljs.core.next(seq__45751);
var clause = first__45752;
var r = seq__45751__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__45749__$1 = G__45749;
var res__$1 = res;
while(true){
var vec__45756 = G__45749__$1;
var seq__45757 = cljs.core.seq(vec__45756);
var first__45758 = cljs.core.first(seq__45757);
var seq__45757__$1 = cljs.core.next(seq__45757);
var clause__$1 = first__45758;
var r__$1 = seq__45757__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__45759 = r__$1;
var G__45760 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__45749__$1 = G__45759;
res__$1 = G__45760;
continue;
} else {
var G__45761 = r__$1;
var G__45762 = res__$2;
G__45749__$1 = G__45761;
res__$1 = G__45762;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__45766 = coll;
var vec__45767 = G__45766;
var seq__45768 = cljs.core.seq(vec__45767);
var first__45769 = cljs.core.first(seq__45768);
var seq__45768__$1 = cljs.core.next(seq__45768);
var clause = first__45769;
var r = seq__45768__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__45766__$1 = G__45766;
var res__$1 = res;
while(true){
var vec__45773 = G__45766__$1;
var seq__45774 = cljs.core.seq(vec__45773);
var first__45775 = cljs.core.first(seq__45774);
var seq__45774__$1 = cljs.core.next(seq__45774);
var clause__$1 = first__45775;
var r__$1 = seq__45774__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__45776 = r__$1;
var G__45777 = res__$2;
G__45766__$1 = G__45776;
res__$1 = G__45777;
continue;
} else {
var G__45778 = r__$1;
var G__45779 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__45766__$1 = G__45778;
res__$1 = G__45779;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4210__auto__ = typeof string === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4210__auto__;
}
})())){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__45782 = clause;
var G__45782__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__45782):G__45782);
var G__45782__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__45782__$1)
;
var G__45782__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__45782__$2)
;
var G__45782__$4 = (function (){var fexpr__45783 = (function (p1__45780_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45780_SHARP_)," ."].join('');
});
return fexpr__45783(G__45782__$3);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__45784 = (function (p1__45781_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45781_SHARP_),"}"].join('');
});
return fexpr__45784(G__45782__$4);
} else {
return G__45782__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__45788 = opts;
var map__45788__$1 = cljs.core.__destructure_map(map__45788);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45788__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45788__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45788__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45788__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45788__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45785_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45785_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__45786_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__45786_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__45787_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__45787_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4212__auto__ = language;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_45802){
var state_val_45803 = (state_45802[(1)]);
if((state_val_45803 === (1))){
var inst_45789 = fluree.db.util.core.url_encode(query);
var inst_45790 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45789)].join('');
var inst_45791 = ["User-Agent","Accept"];
var inst_45792 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_45793 = cljs.core.PersistentHashMap.fromArrays(inst_45791,inst_45792);
var inst_45794 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_45795 = [inst_45793,(30000),cljs.core.cst$kw$wikidata];
var inst_45796 = cljs.core.PersistentHashMap.fromArrays(inst_45794,inst_45795);
var inst_45797 = fluree.db.util.xhttp.get(inst_45790,inst_45796);
var state_45802__$1 = state_45802;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45802__$1,(2),inst_45797);
} else {
if((state_val_45803 === (2))){
var inst_45799 = (state_45802[(2)]);
var inst_45800 = fluree.db.util.async.throw_err(inst_45799);
var state_45802__$1 = state_45802;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45802__$1,inst_45800);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto____0 = (function (){
var statearr_45804 = [null,null,null,null,null,null,null];
(statearr_45804[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto__);

(statearr_45804[(1)] = (1));

return statearr_45804;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto____1 = (function (state_45802){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_45802);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e45805){var ex__24301__auto__ = e45805;
var statearr_45806_45809 = state_45802;
(statearr_45806_45809[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_45802[(4)]))){
var statearr_45807_45810 = state_45802;
(statearr_45807_45810[(1)] = cljs.core.first((state_45802[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__45811 = state_45802;
state_45802 = G__45811;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto__ = function(state_45802){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto____1.call(this,state_45802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_45808 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_45808[(6)] = c__24424__auto__);

return statearr_45808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_45829){
var state_val_45830 = (state_45829[(1)]);
if((state_val_45830 === (1))){
var inst_45812 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_45829__$1 = state_45829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45829__$1,(2),inst_45812);
} else {
if((state_val_45830 === (2))){
var inst_45815 = (state_45829[(7)]);
var inst_45814 = (state_45829[(2)]);
var inst_45815__$1 = fluree.db.util.async.throw_err(inst_45814);
var inst_45816 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_45815__$1);
var inst_45817 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_45816);
var state_45829__$1 = (function (){var statearr_45831 = state_45829;
(statearr_45831[(7)] = inst_45815__$1);

return statearr_45831;
})();
if(inst_45817){
var statearr_45832_45841 = state_45829__$1;
(statearr_45832_45841[(1)] = (3));

} else {
var statearr_45833_45842 = state_45829__$1;
(statearr_45833_45842[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45830 === (3))){
var inst_45815 = (state_45829[(7)]);
var state_45829__$1 = state_45829;
var statearr_45834_45843 = state_45829__$1;
(statearr_45834_45843[(2)] = inst_45815);

(statearr_45834_45843[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45830 === (4))){
var inst_45815 = (state_45829[(7)]);
var inst_45820 = (function (){var body = inst_45815;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_45821 = cljs.core.second(inst_45815);
var inst_45822 = cljs.core.second(inst_45821);
var inst_45823 = cljs.core.first(inst_45822);
var inst_45824 = cljs.core.second(inst_45823);
var inst_45825 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_45820,inst_45824);
var state_45829__$1 = state_45829;
var statearr_45835_45844 = state_45829__$1;
(statearr_45835_45844[(2)] = inst_45825);

(statearr_45835_45844[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45830 === (5))){
var inst_45827 = (state_45829[(2)]);
var state_45829__$1 = state_45829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45829__$1,inst_45827);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto____0 = (function (){
var statearr_45836 = [null,null,null,null,null,null,null,null];
(statearr_45836[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto__);

(statearr_45836[(1)] = (1));

return statearr_45836;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto____1 = (function (state_45829){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_45829);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e45837){var ex__24301__auto__ = e45837;
var statearr_45838_45845 = state_45829;
(statearr_45838_45845[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_45829[(4)]))){
var statearr_45839_45846 = state_45829;
(statearr_45839_45846[(1)] = cljs.core.first((state_45829[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__45847 = state_45829;
state_45829 = G__45847;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto__ = function(state_45829){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto____1.call(this,state_45829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_45840 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_45840[(6)] = c__24424__auto__);

return statearr_45840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45848_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45848_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45849_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45849_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45850_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__45850_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__45850_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__45850_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_45896){
var state_val_45897 = (state_45896[(1)]);
if((state_val_45897 === (7))){
var inst_45861 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_45896__$1 = state_45896;
var statearr_45898_45926 = state_45896__$1;
(statearr_45898_45926[(2)] = inst_45861);

(statearr_45898_45926[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (1))){
var state_45896__$1 = state_45896;
var statearr_45899_45927 = state_45896__$1;
(statearr_45899_45927[(2)] = null);

(statearr_45899_45927[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (4))){
var inst_45851 = (state_45896[(2)]);
var state_45896__$1 = state_45896;
var statearr_45900_45928 = state_45896__$1;
(statearr_45900_45928[(2)] = inst_45851);

(statearr_45900_45928[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (15))){
var inst_45870 = (state_45896[(7)]);
var inst_45869 = (state_45896[(8)]);
var inst_45875 = (state_45896[(9)]);
var inst_45880 = (state_45896[(2)]);
var inst_45881 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_45875,(0),inst_45880);
var inst_45882 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45883 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_45869);
var inst_45884 = [inst_45870,inst_45883];
var inst_45885 = cljs.core.PersistentHashMap.fromArrays(inst_45882,inst_45884);
var inst_45886 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45881,inst_45885);
var inst_45887 = (function(){throw inst_45886})();
var state_45896__$1 = state_45896;
var statearr_45901_45929 = state_45896__$1;
(statearr_45901_45929[(2)] = inst_45887);

(statearr_45901_45929[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (13))){
var inst_45874 = (state_45896[(10)]);
var state_45896__$1 = state_45896;
var statearr_45902_45930 = state_45896__$1;
(statearr_45902_45930[(2)] = inst_45874);

(statearr_45902_45930[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (6))){
var state_45896__$1 = state_45896;
var statearr_45903_45931 = state_45896__$1;
(statearr_45903_45931[(2)] = null);

(statearr_45903_45931[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (3))){
var inst_45894 = (state_45896[(2)]);
var state_45896__$1 = state_45896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45896__$1,inst_45894);
} else {
if((state_val_45897 === (12))){
var inst_45891 = (state_45896[(2)]);
var _ = (function (){var statearr_45904 = state_45896;
(statearr_45904[(4)] = cljs.core.rest((state_45896[(4)])));

return statearr_45904;
})();
var state_45896__$1 = state_45896;
var statearr_45905_45932 = state_45896__$1;
(statearr_45905_45932[(2)] = inst_45891);

(statearr_45905_45932[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (2))){
var _ = (function (){var statearr_45906 = state_45896;
(statearr_45906[(4)] = cljs.core.cons((5),(state_45896[(4)])));

return statearr_45906;
})();
var inst_45858 = cljs.core.empty_QMARK_(matching_vars);
var state_45896__$1 = state_45896;
if(inst_45858){
var statearr_45907_45933 = state_45896__$1;
(statearr_45907_45933[(1)] = (6));

} else {
var statearr_45908_45934 = state_45896__$1;
(statearr_45908_45934[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (11))){
var inst_45869 = (state_45896[(8)]);
var inst_45889 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_45869,all_vars);
var state_45896__$1 = state_45896;
var statearr_45910_45935 = state_45896__$1;
(statearr_45910_45935[(2)] = inst_45889);

(statearr_45910_45935[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (9))){
var inst_45870 = (state_45896[(7)]);
var inst_45869 = (state_45896[(8)]);
var inst_45867 = (state_45896[(2)]);
var inst_45868 = fluree.db.util.async.throw_err(inst_45867);
var inst_45869__$1 = cljs.core.__destructure_map(inst_45868);
var inst_45870__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45869__$1,cljs.core.cst$kw$status);
var inst_45871 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45869__$1,cljs.core.cst$kw$message);
var inst_45872 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_45870__$1);
var state_45896__$1 = (function (){var statearr_45911 = state_45896;
(statearr_45911[(7)] = inst_45870__$1);

(statearr_45911[(8)] = inst_45869__$1);

(statearr_45911[(11)] = inst_45871);

return statearr_45911;
})();
if(inst_45872){
var statearr_45912_45936 = state_45896__$1;
(statearr_45912_45936[(1)] = (10));

} else {
var statearr_45913_45937 = state_45896__$1;
(statearr_45913_45937[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (5))){
var _ = (function (){var statearr_45914 = state_45896;
(statearr_45914[(4)] = cljs.core.rest((state_45896[(4)])));

return statearr_45914;
})();
var state_45896__$1 = state_45896;
var ex45909 = (state_45896__$1[(2)]);
var statearr_45915_45938 = state_45896__$1;
(statearr_45915_45938[(5)] = ex45909);


if((ex45909 instanceof Error)){
var statearr_45916_45939 = state_45896__$1;
(statearr_45916_45939[(1)] = (4));

(statearr_45916_45939[(5)] = null);

} else {
throw ex45909;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (14))){
var state_45896__$1 = state_45896;
var statearr_45917_45940 = state_45896__$1;
(statearr_45917_45940[(2)] = (1000));

(statearr_45917_45940[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (10))){
var inst_45874 = (state_45896[(10)]);
var inst_45869 = (state_45896[(8)]);
var inst_45871 = (state_45896[(11)]);
var inst_45874__$1 = cljs.core.count(inst_45871);
var inst_45875 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_45869);
var inst_45876 = (inst_45874__$1 < (1000));
var state_45896__$1 = (function (){var statearr_45918 = state_45896;
(statearr_45918[(10)] = inst_45874__$1);

(statearr_45918[(9)] = inst_45875);

return statearr_45918;
})();
if(cljs.core.truth_(inst_45876)){
var statearr_45919_45941 = state_45896__$1;
(statearr_45919_45941[(1)] = (13));

} else {
var statearr_45920_45942 = state_45896__$1;
(statearr_45920_45942[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45897 === (8))){
var inst_45863 = (state_45896[(2)]);
var inst_45864 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_45863,optional_clauses);
var inst_45865 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_45864);
var state_45896__$1 = state_45896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45896__$1,(9),inst_45865);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto____0 = (function (){
var statearr_45921 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45921[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto__);

(statearr_45921[(1)] = (1));

return statearr_45921;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto____1 = (function (state_45896){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_45896);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e45922){var ex__24301__auto__ = e45922;
var statearr_45923_45943 = state_45896;
(statearr_45923_45943[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_45896[(4)]))){
var statearr_45924_45944 = state_45896;
(statearr_45924_45944[(1)] = cljs.core.first((state_45896[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__45945 = state_45896;
state_45896 = G__45945;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto__ = function(state_45896){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto____1.call(this,state_45896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_45925 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_45925[(6)] = c__24424__auto__);

return statearr_45925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
