// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e45948){var e = e45948;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__45949_SHARP_){
var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__45949_SHARP_);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__45949_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__45949_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__45949_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__45950_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__45950_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__45951_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__45951_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4210__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4212__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__45956 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45956,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45956,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__45952_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__45952_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4210__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4210__auto__;
}
})())){
var vec__45959 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45959,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45959,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4212__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__45953_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__45953_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__45954_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__45954_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__45955_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__45955_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45962_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__45962_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (add_amount > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fuel;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4210__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__45963 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__45963) : intersecting_vars.call(null,G__45963));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__45966,optional_QMARK_,fuel,max_fuel){
var map__45967 = p__45966;
var map__45967__$1 = cljs.core.__destructure_map(map__45967);
var res = map__45967__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45967__$1,cljs.core.cst$kw$vars);
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_46033){
var state_val_46034 = (state_46033[(1)]);
if((state_val_46034 === (7))){
var inst_46022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46023 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_46024 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_46023,clause);
var inst_46025 = [null,inst_46024];
var inst_46026 = (new cljs.core.PersistentVector(null,2,(5),inst_46022,inst_46025,null));
var state_46033__$1 = state_46033;
var statearr_46035_46063 = state_46033__$1;
(statearr_46035_46063[(2)] = inst_46026);

(statearr_46035_46063[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (1))){
var state_46033__$1 = state_46033;
var statearr_46036_46064 = state_46033__$1;
(statearr_46036_46064[(2)] = null);

(statearr_46036_46064[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (4))){
var inst_45968 = (state_46033[(2)]);
var state_46033__$1 = state_46033;
var statearr_46037_46065 = state_46033__$1;
(statearr_46037_46065[(2)] = inst_45968);

(statearr_46037_46065[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (15))){
var inst_46011 = (state_46033[(2)]);
var inst_46012 = fluree.db.util.async.throw_err(inst_46011);
var inst_46013 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_46012);
var inst_46014 = cljs.core.count(inst_46013);
var inst_46015 = fluree.db.query.analytical.add_fuel(inst_46014,fuel,max_fuel);
var inst_46016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46017 = [inst_46012,r];
var inst_46018 = (new cljs.core.PersistentVector(null,2,(5),inst_46016,inst_46017,null));
var state_46033__$1 = (function (){var statearr_46038 = state_46033;
(statearr_46038[(7)] = inst_46015);

return statearr_46038;
})();
var statearr_46039_46066 = state_46033__$1;
(statearr_46039_46066[(2)] = inst_46018);

(statearr_46039_46066[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (13))){
var inst_45977 = (state_46033[(8)]);
var inst_45990 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_45991 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_45990);
var inst_45992 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_45977);
var inst_45993 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_45992);
var inst_45994 = cljs.core.set(inst_45993);
var inst_45995 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_45991);
var inst_45996 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_45995);
var inst_45997 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45994,inst_45996);
var inst_45998 = (function (){var all_wd = inst_45977;
var optional = inst_45991;
var all_wd_vars = inst_45994;
var all_vars = inst_45997;
return (function (p1__45964_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__45964_SHARP_) : all_vars.call(null,p1__45964_SHARP_));
});
})();
var inst_45999 = cljs.core.keys(vars);
var inst_46000 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_45998,inst_45999);
var inst_46001 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_46000);
var inst_46002 = cljs.core.set(inst_46001);
var inst_46003 = (function (){var all_wd = inst_45977;
var optional = inst_45991;
var all_wd_vars = inst_45994;
var all_vars = inst_45997;
var intersecting_vars = inst_46002;
return (function (p1__45965_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__45965_SHARP_);
});
})();
var inst_46004 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_46003,inst_45977);
var inst_46005 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_46004);
var inst_46006 = fluree.db.query.analytical.select_from_tuples(inst_46005,res);
var inst_46007 = fluree.db.query.analytical.replace_vars_wikidata(inst_45977,inst_46002,vars);
var inst_46008 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_46002,inst_45997);
var inst_46009 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_46007,inst_46005,inst_46006,inst_46008,inst_45991);
var state_46033__$1 = state_46033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46033__$1,(15),inst_46009);
} else {
if((state_val_46034 === (6))){
var inst_45978 = (state_46033[(9)]);
var inst_45976 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_45977 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_45976);
var inst_45978__$1 = optional_QMARK_;
var state_46033__$1 = (function (){var statearr_46040 = state_46033;
(statearr_46040[(9)] = inst_45978__$1);

(statearr_46040[(8)] = inst_45977);

return statearr_46040;
})();
if(cljs.core.truth_(inst_45978__$1)){
var statearr_46041_46067 = state_46033__$1;
(statearr_46041_46067[(1)] = (9));

} else {
var statearr_46042_46068 = state_46033__$1;
(statearr_46042_46068[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (3))){
var inst_46031 = (state_46033[(2)]);
var state_46033__$1 = state_46033;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46033__$1,inst_46031);
} else {
if((state_val_46034 === (12))){
var inst_45986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45987 = [null,r];
var inst_45988 = (new cljs.core.PersistentVector(null,2,(5),inst_45986,inst_45987,null));
var state_46033__$1 = state_46033;
var statearr_46043_46069 = state_46033__$1;
(statearr_46043_46069[(2)] = inst_45988);

(statearr_46043_46069[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (2))){
var _ = (function (){var statearr_46044 = state_46033;
(statearr_46044[(4)] = cljs.core.cons((5),(state_46033[(4)])));

return statearr_46044;
})();
var inst_45974 = (r == null);
var state_46033__$1 = state_46033;
if(cljs.core.truth_(inst_45974)){
var statearr_46045_46070 = state_46033__$1;
(statearr_46045_46070[(1)] = (6));

} else {
var statearr_46046_46071 = state_46033__$1;
(statearr_46046_46071[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (11))){
var inst_45984 = (state_46033[(2)]);
var state_46033__$1 = state_46033;
if(cljs.core.truth_(inst_45984)){
var statearr_46048_46072 = state_46033__$1;
(statearr_46048_46072[(1)] = (12));

} else {
var statearr_46049_46073 = state_46033__$1;
(statearr_46049_46073[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (9))){
var inst_45977 = (state_46033[(8)]);
var inst_45980 = cljs.core.empty_QMARK_(inst_45977);
var inst_45981 = (!(inst_45980));
var state_46033__$1 = state_46033;
var statearr_46050_46074 = state_46033__$1;
(statearr_46050_46074[(2)] = inst_45981);

(statearr_46050_46074[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (5))){
var _ = (function (){var statearr_46051 = state_46033;
(statearr_46051[(4)] = cljs.core.rest((state_46033[(4)])));

return statearr_46051;
})();
var state_46033__$1 = state_46033;
var ex46047 = (state_46033__$1[(2)]);
var statearr_46052_46075 = state_46033__$1;
(statearr_46052_46075[(5)] = ex46047);


if((ex46047 instanceof Error)){
var statearr_46053_46076 = state_46033__$1;
(statearr_46053_46076[(1)] = (4));

(statearr_46053_46076[(5)] = null);

} else {
throw ex46047;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (14))){
var inst_46020 = (state_46033[(2)]);
var state_46033__$1 = state_46033;
var statearr_46054_46077 = state_46033__$1;
(statearr_46054_46077[(2)] = inst_46020);

(statearr_46054_46077[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (10))){
var inst_45978 = (state_46033[(9)]);
var state_46033__$1 = state_46033;
var statearr_46055_46078 = state_46033__$1;
(statearr_46055_46078[(2)] = inst_45978);

(statearr_46055_46078[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46034 === (8))){
var inst_46028 = (state_46033[(2)]);
var _ = (function (){var statearr_46056 = state_46033;
(statearr_46056[(4)] = cljs.core.rest((state_46033[(4)])));

return statearr_46056;
})();
var state_46033__$1 = state_46033;
var statearr_46057_46079 = state_46033__$1;
(statearr_46057_46079[(2)] = inst_46028);

(statearr_46057_46079[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto____0 = (function (){
var statearr_46058 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46058[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto__);

(statearr_46058[(1)] = (1));

return statearr_46058;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto____1 = (function (state_46033){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_46033);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e46059){var ex__24301__auto__ = e46059;
var statearr_46060_46080 = state_46033;
(statearr_46060_46080[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_46033[(4)]))){
var statearr_46061_46081 = state_46033;
(statearr_46061_46081[(1)] = cljs.core.first((state_46033[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__46082 = state_46033;
state_46033 = G__46082;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto__ = function(state_46033){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto____1.call(this,state_46033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_46062 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_46062[(6)] = c__24424__auto__);

return statearr_46062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__46084 = arguments.length;
switch (G__46084) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_46178){
var state_val_46179 = (state_46178[(1)]);
if((state_val_46179 === (7))){
var inst_46091 = (state_46178[(7)]);
var inst_46101 = clojure.string.starts_with_QMARK_(inst_46091,"$fdb");
var state_46178__$1 = state_46178;
if(inst_46101){
var statearr_46180_46229 = state_46178__$1;
(statearr_46180_46229[(1)] = (9));

} else {
var statearr_46181_46230 = state_46178__$1;
(statearr_46181_46230[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (20))){
var state_46178__$1 = state_46178;
var statearr_46182_46231 = state_46178__$1;
(statearr_46182_46231[(2)] = null);

(statearr_46182_46231[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (27))){
var inst_46141 = (state_46178[(8)]);
var state_46178__$1 = state_46178;
var statearr_46183_46232 = state_46178__$1;
(statearr_46183_46232[(2)] = inst_46141);

(statearr_46183_46232[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (1))){
var state_46178__$1 = state_46178;
var statearr_46184_46233 = state_46178__$1;
(statearr_46184_46233[(2)] = null);

(statearr_46184_46233[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (24))){
var inst_46164 = (state_46178[(2)]);
var state_46178__$1 = state_46178;
var statearr_46185_46234 = state_46178__$1;
(statearr_46185_46234[(2)] = inst_46164);

(statearr_46185_46234[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (4))){
var inst_46085 = (state_46178[(2)]);
var state_46178__$1 = state_46178;
var statearr_46186_46235 = state_46178__$1;
(statearr_46186_46235[(2)] = inst_46085);

(statearr_46186_46235[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (15))){
var inst_46108 = (state_46178[(9)]);
var inst_46114 = (state_46178[(2)]);
var inst_46115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46116 = cljs.core.PersistentVector.EMPTY;
var inst_46117 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_46118 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_46116,inst_46117);
var inst_46119 = [inst_46108,inst_46118];
var inst_46120 = (new cljs.core.PersistentVector(null,2,(5),inst_46115,inst_46119,null));
var state_46178__$1 = (function (){var statearr_46187 = state_46178;
(statearr_46187[(10)] = inst_46114);

return statearr_46187;
})();
var statearr_46188_46236 = state_46178__$1;
(statearr_46188_46236[(2)] = inst_46120);

(statearr_46188_46236[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (21))){
var inst_46167 = (state_46178[(2)]);
var state_46178__$1 = state_46178;
var statearr_46189_46237 = state_46178__$1;
(statearr_46189_46237[(2)] = inst_46167);

(statearr_46189_46237[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (13))){
var inst_46108 = (state_46178[(9)]);
var inst_46111 = (function(){throw inst_46108})();
var state_46178__$1 = state_46178;
var statearr_46190_46238 = state_46178__$1;
(statearr_46190_46238[(2)] = inst_46111);

(statearr_46190_46238[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (22))){
var inst_46130 = (state_46178[(11)]);
var inst_46132 = (state_46178[(12)]);
var inst_46134 = fluree.db.query.analytical.parse_block_from_source(inst_46130);
var inst_46135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46136 = [cljs.core.cst$kw$sources,inst_46132];
var inst_46137 = (new cljs.core.PersistentVector(null,2,(5),inst_46135,inst_46136,null));
var inst_46138 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_46137);
var state_46178__$1 = (function (){var statearr_46191 = state_46178;
(statearr_46191[(13)] = inst_46134);

return statearr_46191;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46178__$1,(25),inst_46138);
} else {
if((state_val_46179 === (29))){
var inst_46145 = (state_46178[(2)]);
var inst_46146 = fluree.db.util.async.throw_err(inst_46145);
var state_46178__$1 = state_46178;
var statearr_46192_46239 = state_46178__$1;
(statearr_46192_46239[(2)] = inst_46146);

(statearr_46192_46239[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (6))){
var inst_46094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46095 = cljs.core.PersistentVector.EMPTY;
var inst_46096 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_46097 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_46095,inst_46096);
var inst_46098 = [db,inst_46097];
var inst_46099 = (new cljs.core.PersistentVector(null,2,(5),inst_46094,inst_46098,null));
var state_46178__$1 = state_46178;
var statearr_46193_46240 = state_46178__$1;
(statearr_46193_46240[(2)] = inst_46099);

(statearr_46193_46240[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (28))){
var inst_46149 = (state_46178[(2)]);
var inst_46150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46151 = cljs.core.PersistentVector.EMPTY;
var inst_46152 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_46153 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_46151,inst_46152);
var inst_46154 = [inst_46149,inst_46153];
var inst_46155 = (new cljs.core.PersistentVector(null,2,(5),inst_46150,inst_46154,null));
var state_46178__$1 = state_46178;
var statearr_46194_46241 = state_46178__$1;
(statearr_46194_46241[(2)] = inst_46155);

(statearr_46194_46241[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (25))){
var inst_46134 = (state_46178[(13)]);
var inst_46140 = (state_46178[(2)]);
var inst_46141 = fluree.db.util.async.throw_err(inst_46140);
var state_46178__$1 = (function (){var statearr_46195 = state_46178;
(statearr_46195[(8)] = inst_46141);

return statearr_46195;
})();
if(cljs.core.truth_(inst_46134)){
var statearr_46196_46242 = state_46178__$1;
(statearr_46196_46242[(1)] = (26));

} else {
var statearr_46197_46243 = state_46178__$1;
(statearr_46197_46243[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (17))){
var state_46178__$1 = state_46178;
var statearr_46198_46244 = state_46178__$1;
(statearr_46198_46244[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (3))){
var inst_46176 = (state_46178[(2)]);
var state_46178__$1 = state_46178;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46178__$1,inst_46176);
} else {
if((state_val_46179 === (12))){
var inst_46108 = (state_46178[(9)]);
var inst_46107 = (state_46178[(2)]);
var inst_46108__$1 = fluree.db.util.async.throw_err(inst_46107);
var inst_46109 = fluree.db.util.core.exception_QMARK_(inst_46108__$1);
var state_46178__$1 = (function (){var statearr_46200 = state_46178;
(statearr_46200[(9)] = inst_46108__$1);

return statearr_46200;
})();
if(inst_46109){
var statearr_46201_46245 = state_46178__$1;
(statearr_46201_46245[(1)] = (13));

} else {
var statearr_46202_46246 = state_46178__$1;
(statearr_46202_46246[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (2))){
var inst_46091 = (state_46178[(7)]);
var _ = (function (){var statearr_46203 = state_46178;
(statearr_46203[(4)] = cljs.core.cons((5),(state_46178[(4)])));

return statearr_46203;
})();
var inst_46091__$1 = cljs.core.first(clause);
var inst_46092 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_46091__$1);
var state_46178__$1 = (function (){var statearr_46204 = state_46178;
(statearr_46204[(7)] = inst_46091__$1);

return statearr_46204;
})();
if(inst_46092){
var statearr_46205_46247 = state_46178__$1;
(statearr_46205_46247[(1)] = (6));

} else {
var statearr_46206_46248 = state_46178__$1;
(statearr_46206_46248[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (23))){
var inst_46091 = (state_46178[(7)]);
var inst_46157 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46091)," is not supported in Fluree"].join('');
var inst_46158 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_46159 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_46160 = cljs.core.PersistentHashMap.fromArrays(inst_46158,inst_46159);
var inst_46161 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_46157,inst_46160);
var inst_46162 = (function(){throw inst_46161})();
var state_46178__$1 = state_46178;
var statearr_46207_46249 = state_46178__$1;
(statearr_46207_46249[(2)] = inst_46162);

(statearr_46207_46249[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (19))){
var inst_46132 = (state_46178[(12)]);
var inst_46091 = (state_46178[(7)]);
var inst_46129 = fluree.db.query.analytical.isolate_source_name(inst_46091);
var inst_46130 = fluree.db.query.analytical.isolate_source_block(inst_46091);
var inst_46131 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_46129);
var inst_46132__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_46131);
var state_46178__$1 = (function (){var statearr_46208 = state_46178;
(statearr_46208[(11)] = inst_46130);

(statearr_46208[(12)] = inst_46132__$1);

return statearr_46208;
})();
if(cljs.core.truth_(inst_46132__$1)){
var statearr_46209_46250 = state_46178__$1;
(statearr_46209_46250[(1)] = (22));

} else {
var statearr_46210_46251 = state_46178__$1;
(statearr_46210_46251[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (11))){
var inst_46171 = (state_46178[(2)]);
var state_46178__$1 = state_46178;
var statearr_46212_46252 = state_46178__$1;
(statearr_46212_46252[(2)] = inst_46171);

(statearr_46212_46252[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (9))){
var inst_46091 = (state_46178[(7)]);
var inst_46103 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_46091,(4));
var inst_46104 = fluree.db.query.analytical.parse_block_from_source(inst_46103);
var inst_46105 = fluree.db.time_travel.as_of_block(db,inst_46104);
var state_46178__$1 = state_46178;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46178__$1,(12),inst_46105);
} else {
if((state_val_46179 === (5))){
var _ = (function (){var statearr_46213 = state_46178;
(statearr_46213[(4)] = cljs.core.rest((state_46178[(4)])));

return statearr_46213;
})();
var state_46178__$1 = state_46178;
var ex46211 = (state_46178__$1[(2)]);
var statearr_46214_46253 = state_46178__$1;
(statearr_46214_46253[(5)] = ex46211);


if((ex46211 instanceof Error)){
var statearr_46215_46254 = state_46178__$1;
(statearr_46215_46254[(1)] = (4));

(statearr_46215_46254[(5)] = null);

} else {
throw ex46211;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (14))){
var state_46178__$1 = state_46178;
var statearr_46216_46255 = state_46178__$1;
(statearr_46216_46255[(2)] = null);

(statearr_46216_46255[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (26))){
var inst_46141 = (state_46178[(8)]);
var inst_46134 = (state_46178[(13)]);
var inst_46143 = fluree.db.time_travel.as_of_block(inst_46141,inst_46134);
var state_46178__$1 = state_46178;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46178__$1,(29),inst_46143);
} else {
if((state_val_46179 === (16))){
var inst_46124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46125 = ["$wd",clause];
var inst_46126 = (new cljs.core.PersistentVector(null,2,(5),inst_46124,inst_46125,null));
var state_46178__$1 = state_46178;
var statearr_46217_46256 = state_46178__$1;
(statearr_46217_46256[(2)] = inst_46126);

(statearr_46217_46256[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (10))){
var inst_46091 = (state_46178[(7)]);
var inst_46122 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_46091);
var state_46178__$1 = state_46178;
if(inst_46122){
var statearr_46218_46257 = state_46178__$1;
(statearr_46218_46257[(1)] = (16));

} else {
var statearr_46219_46258 = state_46178__$1;
(statearr_46219_46258[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (18))){
var inst_46169 = (state_46178[(2)]);
var state_46178__$1 = state_46178;
var statearr_46220_46259 = state_46178__$1;
(statearr_46220_46259[(2)] = inst_46169);

(statearr_46220_46259[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46179 === (8))){
var inst_46173 = (state_46178[(2)]);
var _ = (function (){var statearr_46221 = state_46178;
(statearr_46221[(4)] = cljs.core.rest((state_46178[(4)])));

return statearr_46221;
})();
var state_46178__$1 = state_46178;
var statearr_46222_46260 = state_46178__$1;
(statearr_46222_46260[(2)] = inst_46173);

(statearr_46222_46260[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__24298__auto__ = null;
var fluree$db$query$analytical$state_machine__24298__auto____0 = (function (){
var statearr_46223 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46223[(0)] = fluree$db$query$analytical$state_machine__24298__auto__);

(statearr_46223[(1)] = (1));

return statearr_46223;
});
var fluree$db$query$analytical$state_machine__24298__auto____1 = (function (state_46178){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_46178);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e46224){var ex__24301__auto__ = e46224;
var statearr_46225_46261 = state_46178;
(statearr_46225_46261[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_46178[(4)]))){
var statearr_46226_46262 = state_46178;
(statearr_46226_46262[(1)] = cljs.core.first((state_46178[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__46263 = state_46178;
state_46178 = G__46263;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__24298__auto__ = function(state_46178){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__24298__auto____1.call(this,state_46178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__24298__auto____0;
fluree$db$query$analytical$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__24298__auto____1;
return fluree$db$query$analytical$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_46227 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_46227[(6)] = c__24424__auto__);

return statearr_46227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__46264){
var vec__46265 = p__46264;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46265,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46265,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46268_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__46268_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__46272 = subjects;
var vec__46273 = G__46272;
var seq__46274 = cljs.core.seq(vec__46273);
var first__46275 = cljs.core.first(seq__46274);
var seq__46274__$1 = cljs.core.next(seq__46274);
var subject = first__46275;
var r = seq__46274__$1;
var acc = expanded_map;
var G__46272__$1 = G__46272;
var acc__$1 = acc;
while(true){
var vec__46279 = G__46272__$1;
var seq__46280 = cljs.core.seq(vec__46279);
var first__46281 = cljs.core.first(seq__46280);
var seq__46280__$1 = cljs.core.next(seq__46280);
var subject__$1 = first__46281;
var r__$1 = seq__46280__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__46282 = r__$1;
var G__46283 = acc__$2;
G__46272__$1 = G__46282;
acc__$1 = G__46283;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__46272__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__46279,seq__46280,first__46281,seq__46280__$1,subject__$1,r__$1,acc__$2,G__46272,vec__46273,seq__46274,first__46275,seq__46274__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4212__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__46272__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__46279,seq__46280,first__46281,seq__46280__$1,subject__$1,r__$1,acc__$2,G__46272,vec__46273,seq__46274,first__46275,seq__46274__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__46272__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__46279,seq__46280,first__46281,seq__46280__$1,subject__$1,r__$1,acc__$2,G__46272,vec__46273,seq__46274,first__46275,seq__46274__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__46272__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__46279,seq__46280,first__46281,seq__46280__$1,subject__$1,r__$1,acc__$2,G__46272,vec__46273,seq__46274,first__46275,seq__46274__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__46272__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__46279,seq__46280,first__46281,seq__46280__$1,subject__$1,r__$1,acc__$2,G__46272,vec__46273,seq__46274,first__46275,seq__46274__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__46272__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__46279,seq__46280,first__46281,seq__46280__$1,subject__$1,r__$1,acc__$2,G__46272,vec__46273,seq__46274,first__46275,seq__46274__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__46284 = r__$1;
var G__46285 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__46272__$1 = G__46284;
acc__$1 = G__46285;
continue;
} else {
var G__46286 = subjects;
var G__46287 = acc_STAR_;
G__46272__$1 = G__46286;
acc__$1 = G__46287;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46288_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__46288_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_46379){
var state_val_46380 = (state_46379[(1)]);
if((state_val_46380 === (7))){
var state_46379__$1 = state_46379;
var statearr_46381_46427 = state_46379__$1;
(statearr_46381_46427[(2)] = (100));

(statearr_46381_46427[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (20))){
var inst_46328 = (state_46379[(7)]);
var state_46379__$1 = state_46379;
var statearr_46382_46428 = state_46379__$1;
(statearr_46382_46428[(2)] = inst_46328);

(statearr_46382_46428[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (1))){
var state_46379__$1 = state_46379;
var statearr_46383_46429 = state_46379__$1;
(statearr_46383_46429[(2)] = null);

(statearr_46383_46429[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (24))){
var inst_46300 = (state_46379[(8)]);
var inst_46366 = (state_46379[(9)]);
var inst_46365 = (state_46379[(10)]);
var inst_46367 = (state_46379[(11)]);
var inst_46370 = (function (){var max_depth = inst_46300;
var recur_map__$1 = inst_46366;
var subjects = inst_46365;
var tuples = inst_46367;
return (function (p1__46289_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__46289_SHARP_)],null));
});
})();
var inst_46371 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_46370,inst_46367);
var inst_46372 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_46371);
var state_46379__$1 = state_46379;
var statearr_46384_46430 = state_46379__$1;
(statearr_46384_46430[(2)] = inst_46372);

(statearr_46384_46430[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (4))){
var inst_46290 = (state_46379[(2)]);
var state_46379__$1 = state_46379;
var statearr_46385_46431 = state_46379__$1;
(statearr_46385_46431[(2)] = inst_46290);

(statearr_46385_46431[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (15))){
var inst_46313 = (state_46379[(12)]);
var inst_46324 = cljs.core.PersistentVector.EMPTY;
var inst_46325 = cljs.core.seq(inst_46313);
var inst_46326 = cljs.core.first(inst_46325);
var inst_46327 = cljs.core.next(inst_46325);
var inst_46328 = inst_46324;
var inst_46329 = inst_46313;
var state_46379__$1 = (function (){var statearr_46386 = state_46379;
(statearr_46386[(7)] = inst_46328);

(statearr_46386[(13)] = inst_46327);

(statearr_46386[(14)] = inst_46329);

(statearr_46386[(15)] = inst_46326);

return statearr_46386;
})();
var statearr_46387_46432 = state_46379__$1;
(statearr_46387_46432[(2)] = null);

(statearr_46387_46432[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (21))){
var inst_46349 = (state_46379[(2)]);
var state_46379__$1 = state_46379;
var statearr_46388_46433 = state_46379__$1;
(statearr_46388_46433[(2)] = inst_46349);

(statearr_46388_46433[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (13))){
var inst_46362 = (state_46379[(2)]);
var state_46379__$1 = state_46379;
var statearr_46389_46434 = state_46379__$1;
(statearr_46389_46434[(2)] = inst_46362);

(statearr_46389_46434[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (22))){
var inst_46336 = (state_46379[(16)]);
var inst_46328 = (state_46379[(7)]);
var inst_46343 = (state_46379[(2)]);
var inst_46344 = fluree.db.util.async.throw_err(inst_46343);
var inst_46345 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_46328,inst_46344);
var inst_46328__$1 = inst_46345;
var inst_46329 = inst_46336;
var state_46379__$1 = (function (){var statearr_46390 = state_46379;
(statearr_46390[(7)] = inst_46328__$1);

(statearr_46390[(14)] = inst_46329);

return statearr_46390;
})();
var statearr_46391_46435 = state_46379__$1;
(statearr_46391_46435[(2)] = null);

(statearr_46391_46435[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (6))){
var inst_46296 = (state_46379[(17)]);
var state_46379__$1 = state_46379;
var statearr_46392_46436 = state_46379__$1;
(statearr_46392_46436[(2)] = inst_46296);

(statearr_46392_46436[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (25))){
var inst_46374 = (state_46379[(2)]);
var _ = (function (){var statearr_46393 = state_46379;
(statearr_46393[(4)] = cljs.core.rest((state_46379[(4)])));

return statearr_46393;
})();
var state_46379__$1 = state_46379;
var statearr_46394_46437 = state_46379__$1;
(statearr_46394_46437[(2)] = inst_46374);

(statearr_46394_46437[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (17))){
var inst_46335 = (state_46379[(18)]);
var inst_46329 = (state_46379[(14)]);
var inst_46334 = cljs.core.seq(inst_46329);
var inst_46335__$1 = cljs.core.first(inst_46334);
var inst_46336 = cljs.core.next(inst_46334);
var state_46379__$1 = (function (){var statearr_46395 = state_46379;
(statearr_46395[(16)] = inst_46336);

(statearr_46395[(18)] = inst_46335__$1);

return statearr_46395;
})();
if(cljs.core.truth_(inst_46335__$1)){
var statearr_46396_46438 = state_46379__$1;
(statearr_46396_46438[(1)] = (19));

} else {
var statearr_46397_46439 = state_46379__$1;
(statearr_46397_46439[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (3))){
var inst_46377 = (state_46379[(2)]);
var state_46379__$1 = state_46379;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46379__$1,inst_46377);
} else {
if((state_val_46380 === (12))){
var inst_46302 = (state_46379[(19)]);
var inst_46313 = (state_46379[(12)]);
var inst_46308 = cljs.core.vals(inst_46302);
var inst_46309 = cljs.core.flatten(inst_46308);
var inst_46310 = cljs.core.set(inst_46309);
var inst_46311 = cljs.core.keys(inst_46302);
var inst_46312 = cljs.core.set(inst_46311);
var inst_46313__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_46310,inst_46312);
var inst_46314 = cljs.core.empty_QMARK_(inst_46313__$1);
var state_46379__$1 = (function (){var statearr_46398 = state_46379;
(statearr_46398[(12)] = inst_46313__$1);

return statearr_46398;
})();
if(inst_46314){
var statearr_46399_46440 = state_46379__$1;
(statearr_46399_46440[(1)] = (14));

} else {
var statearr_46400_46441 = state_46379__$1;
(statearr_46400_46441[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (2))){
var inst_46296 = (state_46379[(17)]);
var _ = (function (){var statearr_46401 = state_46379;
(statearr_46401[(4)] = cljs.core.cons((5),(state_46379[(4)])));

return statearr_46401;
})();
var inst_46296__$1 = depth;
var state_46379__$1 = (function (){var statearr_46402 = state_46379;
(statearr_46402[(17)] = inst_46296__$1);

return statearr_46402;
})();
if(cljs.core.truth_(inst_46296__$1)){
var statearr_46403_46442 = state_46379__$1;
(statearr_46403_46442[(1)] = (6));

} else {
var statearr_46404_46443 = state_46379__$1;
(statearr_46404_46443[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (23))){
var inst_46367 = (state_46379[(11)]);
var state_46379__$1 = state_46379;
var statearr_46405_46444 = state_46379__$1;
(statearr_46405_46444[(2)] = inst_46367);

(statearr_46405_46444[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (19))){
var inst_46335 = (state_46379[(18)]);
var inst_46338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46339 = [inst_46335,predicate];
var inst_46340 = (new cljs.core.PersistentVector(null,2,(5),inst_46338,inst_46339,null));
var inst_46341 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_46340);
var state_46379__$1 = state_46379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46379__$1,(22),inst_46341);
} else {
if((state_val_46380 === (11))){
var inst_46302 = (state_46379[(19)]);
var state_46379__$1 = state_46379;
var statearr_46407_46445 = state_46379__$1;
(statearr_46407_46445[(2)] = inst_46302);

(statearr_46407_46445[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (9))){
var inst_46303 = (state_46379[(20)]);
var inst_46300 = (state_46379[(8)]);
var inst_46305 = (inst_46303 >= inst_46300);
var state_46379__$1 = state_46379;
if(cljs.core.truth_(inst_46305)){
var statearr_46408_46446 = state_46379__$1;
(statearr_46408_46446[(1)] = (11));

} else {
var statearr_46409_46447 = state_46379__$1;
(statearr_46409_46447[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (5))){
var _ = (function (){var statearr_46410 = state_46379;
(statearr_46410[(4)] = cljs.core.rest((state_46379[(4)])));

return statearr_46410;
})();
var state_46379__$1 = state_46379;
var ex46406 = (state_46379__$1[(2)]);
var statearr_46411_46448 = state_46379__$1;
(statearr_46411_46448[(5)] = ex46406);


if((ex46406 instanceof Error)){
var statearr_46412_46449 = state_46379__$1;
(statearr_46412_46449[(1)] = (4));

(statearr_46412_46449[(5)] = null);

} else {
throw ex46406;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (14))){
var inst_46302 = (state_46379[(19)]);
var state_46379__$1 = state_46379;
var statearr_46413_46450 = state_46379__$1;
(statearr_46413_46450[(2)] = inst_46302);

(statearr_46413_46450[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (16))){
var inst_46360 = (state_46379[(2)]);
var state_46379__$1 = state_46379;
var statearr_46414_46451 = state_46379__$1;
(statearr_46414_46451[(2)] = inst_46360);

(statearr_46414_46451[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (10))){
var inst_46366 = (state_46379[(9)]);
var inst_46365 = (state_46379[(10)]);
var inst_46364 = (state_46379[(2)]);
var inst_46365__$1 = cljs.core.keys(inst_46364);
var inst_46366__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_46365__$1,inst_46364);
var inst_46367 = fluree.db.query.analytical.recur_map__GT_tuples(inst_46365__$1,inst_46366__$1);
var state_46379__$1 = (function (){var statearr_46415 = state_46379;
(statearr_46415[(9)] = inst_46366__$1);

(statearr_46415[(10)] = inst_46365__$1);

(statearr_46415[(11)] = inst_46367);

return statearr_46415;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_46416_46452 = state_46379__$1;
(statearr_46416_46452[(1)] = (23));

} else {
var statearr_46417_46453 = state_46379__$1;
(statearr_46417_46453[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (18))){
var inst_46303 = (state_46379[(20)]);
var inst_46302 = (state_46379[(19)]);
var inst_46351 = (state_46379[(2)]);
var inst_46352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46353 = [(0),(2)];
var inst_46354 = (new cljs.core.PersistentVector(null,2,(5),inst_46352,inst_46353,null));
var inst_46355 = fluree.db.query.analytical.get_ns_arrays(inst_46354,inst_46351);
var inst_46356 = fluree.db.query.analytical.tuples__GT_map(inst_46302,inst_46355);
var inst_46357 = (inst_46303 + (1));
var inst_46302__$1 = inst_46356;
var inst_46303__$1 = inst_46357;
var state_46379__$1 = (function (){var statearr_46418 = state_46379;
(statearr_46418[(20)] = inst_46303__$1);

(statearr_46418[(19)] = inst_46302__$1);

return statearr_46418;
})();
var statearr_46419_46454 = state_46379__$1;
(statearr_46419_46454[(2)] = null);

(statearr_46419_46454[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46380 === (8))){
var inst_46300 = (state_46379[(2)]);
var inst_46301 = recur_map;
var inst_46302 = inst_46301;
var inst_46303 = (1);
var state_46379__$1 = (function (){var statearr_46420 = state_46379;
(statearr_46420[(20)] = inst_46303);

(statearr_46420[(8)] = inst_46300);

(statearr_46420[(19)] = inst_46302);

return statearr_46420;
})();
var statearr_46421_46455 = state_46379__$1;
(statearr_46421_46455[(2)] = null);

(statearr_46421_46455[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto____0 = (function (){
var statearr_46422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46422[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto__);

(statearr_46422[(1)] = (1));

return statearr_46422;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto____1 = (function (state_46379){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_46379);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e46423){var ex__24301__auto__ = e46423;
var statearr_46424_46456 = state_46379;
(statearr_46424_46456[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_46379[(4)]))){
var statearr_46425_46457 = state_46379;
(statearr_46425_46457[(1)] = cljs.core.first((state_46379[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__46458 = state_46379;
state_46379 = G__46458;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto__ = function(state_46379){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto____1.call(this,state_46379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_46426 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_46426[(6)] = c__24424__auto__);

return statearr_46426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__46459,clause,fuel,max_fuel){
var map__46460 = p__46459;
var map__46460__$1 = cljs.core.__destructure_map(map__46460);
var res = map__46460__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46460__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46460__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46460__$1,cljs.core.cst$kw$vars);
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_46571){
var state_val_46572 = (state_46571[(1)]);
if((state_val_46572 === (7))){
var inst_46477 = (state_46571[(7)]);
var state_46571__$1 = state_46571;
var statearr_46573_46626 = state_46571__$1;
(statearr_46573_46626[(2)] = inst_46477);

(statearr_46573_46626[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (20))){
var inst_46505 = (state_46571[(8)]);
var inst_46536 = typeof inst_46505 === 'number';
var state_46571__$1 = state_46571;
if(cljs.core.truth_(inst_46536)){
var statearr_46574_46627 = state_46571__$1;
(statearr_46574_46627[(1)] = (22));

} else {
var statearr_46575_46628 = state_46571__$1;
(statearr_46575_46628[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (27))){
var inst_46551 = (state_46571[(2)]);
var state_46571__$1 = state_46571;
var statearr_46576_46629 = state_46571__$1;
(statearr_46576_46629[(2)] = inst_46551);

(statearr_46576_46629[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (1))){
var state_46571__$1 = state_46571;
var statearr_46577_46630 = state_46571__$1;
(statearr_46577_46630[(2)] = null);

(statearr_46577_46630[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (24))){
var inst_46553 = (state_46571[(2)]);
var state_46571__$1 = state_46571;
var statearr_46578_46631 = state_46571__$1;
(statearr_46578_46631[(2)] = inst_46553);

(statearr_46578_46631[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (4))){
var inst_46461 = (state_46571[(2)]);
var state_46571__$1 = state_46571;
var statearr_46579_46632 = state_46571__$1;
(statearr_46579_46632[(2)] = inst_46461);

(statearr_46579_46632[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (15))){
var inst_46519 = (state_46571[(2)]);
var inst_46520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_46521 = fluree.db.query.analytical.variable_QMARK_(inst_46520);
var state_46571__$1 = (function (){var statearr_46580 = state_46571;
(statearr_46580[(9)] = inst_46519);

return statearr_46580;
})();
if(cljs.core.truth_(inst_46521)){
var statearr_46581_46633 = state_46571__$1;
(statearr_46581_46633[(1)] = (16));

} else {
var statearr_46582_46634 = state_46571__$1;
(statearr_46582_46634[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (21))){
var inst_46507 = (state_46571[(10)]);
var inst_46508 = (state_46571[(11)]);
var inst_46478 = (state_46571[(12)]);
var inst_46555 = (state_46571[(2)]);
var inst_46556 = fluree.db.query.analytical.tuples__GT_recur(db,inst_46508,inst_46555,inst_46478,inst_46507);
var state_46571__$1 = state_46571;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46571__$1,(28),inst_46556);
} else {
if((state_val_46572 === (13))){
var inst_46487 = (state_46571[(13)]);
var inst_46511 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46487)].join('');
var inst_46512 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_46513 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_46514 = cljs.core.PersistentHashMap.fromArrays(inst_46512,inst_46513);
var inst_46515 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_46511,inst_46514);
var inst_46516 = (function(){throw inst_46515})();
var state_46571__$1 = state_46571;
var statearr_46583_46635 = state_46571__$1;
(statearr_46583_46635[(2)] = inst_46516);

(statearr_46583_46635[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (22))){
var inst_46505 = (state_46571[(8)]);
var inst_46503 = (state_46571[(14)]);
var inst_46538 = cljs.core.PersistentHashMap.EMPTY;
var inst_46539 = cljs.core.flatten(inst_46503);
var inst_46540 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_46538,inst_46505,inst_46539);
var state_46571__$1 = state_46571;
var statearr_46584_46636 = state_46571__$1;
(statearr_46584_46636[(2)] = inst_46540);

(statearr_46584_46636[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (6))){
var inst_46489 = (state_46571[(15)]);
var state_46571__$1 = state_46571;
var statearr_46585_46637 = state_46571__$1;
(statearr_46585_46637[(2)] = inst_46489);

(statearr_46585_46637[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (28))){
var inst_46558 = (state_46571[(2)]);
var inst_46559 = fluree.db.util.async.throw_err(inst_46558);
var state_46571__$1 = state_46571;
var statearr_46586_46638 = state_46571__$1;
(statearr_46586_46638[(2)] = inst_46559);

(statearr_46586_46638[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (25))){
var inst_46499 = (state_46571[(16)]);
var inst_46503 = (state_46571[(14)]);
var inst_46544 = cljs.core.PersistentHashMap.EMPTY;
var inst_46545 = cljs.core.first(inst_46499);
var inst_46546 = cljs.core.first(inst_46545);
var inst_46547 = cljs.core.flatten(inst_46503);
var inst_46548 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_46544,inst_46546,inst_46547);
var state_46571__$1 = state_46571;
var statearr_46587_46639 = state_46571__$1;
(statearr_46587_46639[(2)] = inst_46548);

(statearr_46587_46639[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (17))){
var inst_46487 = (state_46571[(13)]);
var inst_46524 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46487)].join('');
var inst_46525 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_46526 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_46527 = cljs.core.PersistentHashMap.fromArrays(inst_46525,inst_46526);
var inst_46528 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_46524,inst_46527);
var inst_46529 = (function(){throw inst_46528})();
var state_46571__$1 = state_46571;
var statearr_46588_46640 = state_46571__$1;
(statearr_46588_46640[(2)] = inst_46529);

(statearr_46588_46640[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (3))){
var inst_46569 = (state_46571[(2)]);
var state_46571__$1 = state_46571;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46571__$1,inst_46569);
} else {
if((state_val_46572 === (12))){
var inst_46474 = (state_46571[(17)]);
var inst_46562 = (state_46571[(2)]);
var inst_46563 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_46564 = cljs.core.keys(inst_46474);
var inst_46565 = [inst_46564,vars,inst_46562];
var inst_46566 = cljs.core.PersistentHashMap.fromArrays(inst_46563,inst_46565);
var _ = (function (){var statearr_46589 = state_46571;
(statearr_46589[(4)] = cljs.core.rest((state_46571[(4)])));

return statearr_46589;
})();
var state_46571__$1 = state_46571;
var statearr_46590_46641 = state_46571__$1;
(statearr_46590_46641[(2)] = inst_46566);

(statearr_46590_46641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (2))){
var inst_46477 = (state_46571[(7)]);
var inst_46478 = (state_46571[(12)]);
var inst_46474 = (state_46571[(17)]);
var inst_46489 = (state_46571[(15)]);
var _ = (function (){var statearr_46591 = state_46571;
(statearr_46591[(4)] = cljs.core.cons((5),(state_46571[(4)])));

return statearr_46591;
})();
var inst_46471 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_46472 = cljs.core.__destructure_map(inst_46471);
var inst_46473 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46472,cljs.core.cst$kw$search);
var inst_46474__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46472,cljs.core.cst$kw$rel);
var inst_46475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46472,cljs.core.cst$kw$opts);
var inst_46476 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_46477__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_46475);
var inst_46478__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_46475);
var inst_46480 = (function (){var map__46467 = inst_46472;
var search = inst_46473;
var rel = inst_46474__$1;
var opts = inst_46475;
var common_keys = inst_46476;
var object_fn = inst_46477__$1;
var recur_depth = inst_46478__$1;
return (function (p__46479,common_key){
var vec__46592 = p__46479;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46592,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46592,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__46595 = cljs.core._EQ_;
var expr__46596 = idx_of;
if(cljs.core.truth_((pred__46595.cljs$core$IFn$_invoke$arity$2 ? pred__46595.cljs$core$IFn$_invoke$arity$2((0),expr__46596) : pred__46595.call(null,(0),expr__46596)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__46595.cljs$core$IFn$_invoke$arity$2 ? pred__46595.cljs$core$IFn$_invoke$arity$2((1),expr__46596) : pred__46595.call(null,(1),expr__46596)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__46595.cljs$core$IFn$_invoke$arity$2 ? pred__46595.cljs$core$IFn$_invoke$arity$2((2),expr__46596) : pred__46595.call(null,(2),expr__46596)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__46596)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4210__auto__ = (!(single_v_QMARK_));
if(and__4210__auto__){
var and__4210__auto____$1 = object_fn;
if(cljs.core.truth_(and__4210__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_46481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46482 = cljs.core.PersistentHashMap.EMPTY;
var inst_46483 = [inst_46482,inst_46473];
var inst_46484 = (new cljs.core.PersistentVector(null,2,(5),inst_46481,inst_46483,null));
var inst_46485 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_46480,inst_46484,inst_46476);
var inst_46486 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46485,(0),null);
var inst_46487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46485,(1),null);
var inst_46488 = [cljs.core.cst$kw$object_DASH_fn];
var inst_46489__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_46486);
var state_46571__$1 = (function (){var statearr_46598 = state_46571;
(statearr_46598[(18)] = inst_46488);

(statearr_46598[(7)] = inst_46477__$1);

(statearr_46598[(12)] = inst_46478__$1);

(statearr_46598[(17)] = inst_46474__$1);

(statearr_46598[(15)] = inst_46489__$1);

(statearr_46598[(13)] = inst_46487);

return statearr_46598;
})();
if(cljs.core.truth_(inst_46489__$1)){
var statearr_46599_46642 = state_46571__$1;
(statearr_46599_46642[(1)] = (6));

} else {
var statearr_46600_46643 = state_46571__$1;
(statearr_46600_46643[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (23))){
var inst_46505 = (state_46571[(8)]);
var inst_46542 = cljs.core.coll_QMARK_(inst_46505);
var state_46571__$1 = state_46571;
if(inst_46542){
var statearr_46601_46644 = state_46571__$1;
(statearr_46601_46644[(1)] = (25));

} else {
var statearr_46602_46645 = state_46571__$1;
(statearr_46602_46645[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (19))){
var inst_46503 = (state_46571[(14)]);
var inst_46533 = cljs.core.PersistentHashMap.EMPTY;
var inst_46534 = fluree.db.query.analytical.tuples__GT_map(inst_46533,inst_46503);
var state_46571__$1 = state_46571;
var statearr_46603_46646 = state_46571__$1;
(statearr_46603_46646[(2)] = inst_46534);

(statearr_46603_46646[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (11))){
var inst_46503 = (state_46571[(14)]);
var state_46571__$1 = state_46571;
var statearr_46605_46647 = state_46571__$1;
(statearr_46605_46647[(2)] = inst_46503);

(statearr_46605_46647[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (9))){
var inst_46499 = (state_46571[(16)]);
var inst_46478 = (state_46571[(12)]);
var inst_46474 = (state_46571[(17)]);
var inst_46498 = (state_46571[(2)]);
var inst_46499__$1 = fluree.db.util.async.throw_err(inst_46498);
var inst_46500 = cljs.core.count(inst_46499__$1);
var inst_46501 = fluree.db.query.analytical.add_fuel(inst_46500,fuel,max_fuel);
var inst_46502 = cljs.core.vals(inst_46474);
var inst_46503 = fluree.db.query.analytical.get_ns_arrays(inst_46502,inst_46499__$1);
var state_46571__$1 = (function (){var statearr_46606 = state_46571;
(statearr_46606[(16)] = inst_46499__$1);

(statearr_46606[(14)] = inst_46503);

(statearr_46606[(19)] = inst_46501);

return statearr_46606;
})();
if(cljs.core.truth_(inst_46478)){
var statearr_46607_46648 = state_46571__$1;
(statearr_46607_46648[(1)] = (10));

} else {
var statearr_46608_46649 = state_46571__$1;
(statearr_46608_46649[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (5))){
var _ = (function (){var statearr_46609 = state_46571;
(statearr_46609[(4)] = cljs.core.rest((state_46571[(4)])));

return statearr_46609;
})();
var state_46571__$1 = state_46571;
var ex46604 = (state_46571__$1[(2)]);
var statearr_46610_46650 = state_46571__$1;
(statearr_46610_46650[(5)] = ex46604);


if((ex46604 instanceof Error)){
var statearr_46611_46651 = state_46571__$1;
(statearr_46611_46651[(1)] = (4));

(statearr_46611_46651[(5)] = null);

} else {
throw ex46604;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (14))){
var state_46571__$1 = state_46571;
var statearr_46612_46652 = state_46571__$1;
(statearr_46612_46652[(2)] = null);

(statearr_46612_46652[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (26))){
var state_46571__$1 = state_46571;
var statearr_46613_46653 = state_46571__$1;
(statearr_46613_46653[(2)] = null);

(statearr_46613_46653[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (16))){
var state_46571__$1 = state_46571;
var statearr_46614_46654 = state_46571__$1;
(statearr_46614_46654[(2)] = null);

(statearr_46614_46654[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (10))){
var inst_46508 = (state_46571[(11)]);
var inst_46487 = (state_46571[(13)]);
var inst_46505 = cljs.core.first(inst_46487);
var inst_46506 = cljs.core.first(clause);
var inst_46507 = fluree.db.query.analytical.variable_QMARK_(inst_46506);
var inst_46508__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_46487,(1));
var inst_46509 = fluree.db.query.analytical.variable_QMARK_(inst_46508__$1);
var state_46571__$1 = (function (){var statearr_46615 = state_46571;
(statearr_46615[(8)] = inst_46505);

(statearr_46615[(10)] = inst_46507);

(statearr_46615[(11)] = inst_46508__$1);

return statearr_46615;
})();
if(cljs.core.truth_(inst_46509)){
var statearr_46616_46655 = state_46571__$1;
(statearr_46616_46655[(1)] = (13));

} else {
var statearr_46617_46656 = state_46571__$1;
(statearr_46617_46656[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (18))){
var inst_46507 = (state_46571[(10)]);
var inst_46531 = (state_46571[(2)]);
var state_46571__$1 = (function (){var statearr_46618 = state_46571;
(statearr_46618[(20)] = inst_46531);

return statearr_46618;
})();
if(cljs.core.truth_(inst_46507)){
var statearr_46619_46657 = state_46571__$1;
(statearr_46619_46657[(1)] = (19));

} else {
var statearr_46620_46658 = state_46571__$1;
(statearr_46620_46658[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46572 === (8))){
var inst_46488 = (state_46571[(18)]);
var inst_46487 = (state_46571[(13)]);
var inst_46493 = (state_46571[(2)]);
var inst_46494 = [inst_46493];
var inst_46495 = cljs.core.PersistentHashMap.fromArrays(inst_46488,inst_46494);
var inst_46496 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_46487,inst_46495);
var state_46571__$1 = state_46571;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46571__$1,(9),inst_46496);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto____0 = (function (){
var statearr_46621 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46621[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto__);

(statearr_46621[(1)] = (1));

return statearr_46621;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto____1 = (function (state_46571){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_46571);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e46622){var ex__24301__auto__ = e46622;
var statearr_46623_46659 = state_46571;
(statearr_46623_46659[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_46571[(4)]))){
var statearr_46624_46660 = state_46571;
(statearr_46624_46660[(1)] = cljs.core.first((state_46571[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__46661 = state_46571;
state_46571 = G__46661;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto__ = function(state_46571){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto____1.call(this,state_46571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_46625 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_46625[(6)] = c__24424__auto__);

return statearr_46625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__46662,res,clause){
var map__46663 = p__46662;
var map__46663__$1 = cljs.core.__destructure_map(map__46663);
var db = map__46663__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46663__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46663__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46663__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_46762){
var state_val_46763 = (state_46762[(1)]);
if((state_val_46763 === (7))){
var inst_46673 = (state_46762[(7)]);
var state_46762__$1 = state_46762;
var statearr_46764_46804 = state_46762__$1;
(statearr_46764_46804[(2)] = inst_46673);

(statearr_46764_46804[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (20))){
var inst_46753 = (state_46762[(2)]);
var state_46762__$1 = state_46762;
var statearr_46765_46805 = state_46762__$1;
(statearr_46765_46805[(2)] = inst_46753);

(statearr_46765_46805[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (1))){
var state_46762__$1 = state_46762;
var statearr_46766_46806 = state_46762__$1;
(statearr_46766_46806[(2)] = null);

(statearr_46766_46806[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (24))){
var inst_46732 = (state_46762[(2)]);
var inst_46733 = fluree.db.util.async.throw_err(inst_46732);
var state_46762__$1 = state_46762;
var statearr_46767_46807 = state_46762__$1;
(statearr_46767_46807[(2)] = inst_46733);

(statearr_46767_46807[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (4))){
var inst_46666 = (state_46762[(2)]);
var state_46762__$1 = state_46762;
var statearr_46768_46808 = state_46762__$1;
(statearr_46768_46808[(2)] = inst_46666);

(statearr_46768_46808[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (15))){
var inst_46673 = (state_46762[(7)]);
var inst_46675 = (state_46762[(8)]);
var inst_46694 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_46695 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_46696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46697 = [inst_46673];
var inst_46698 = (new cljs.core.PersistentVector(null,1,(5),inst_46696,inst_46697,null));
var inst_46699 = (function (){var subject_var = inst_46673;
var object_var = inst_46675;
var min_sid = inst_46694;
var max_sid = (0);
return (function (p1__46664_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__46664_SHARP_);
});
})();
var inst_46700 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_46694,(0));
var inst_46701 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_46699,inst_46700);
var inst_46702 = cljs.core.PersistentHashMap.EMPTY;
var inst_46703 = [inst_46698,inst_46701,inst_46702];
var inst_46704 = cljs.core.PersistentHashMap.fromArrays(inst_46695,inst_46703);
var state_46762__$1 = state_46762;
var statearr_46769_46809 = state_46762__$1;
(statearr_46769_46809[(2)] = inst_46704);

(statearr_46769_46809[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (21))){
var inst_46726 = (state_46762[(9)]);
var state_46762__$1 = state_46762;
var statearr_46770_46810 = state_46762__$1;
(statearr_46770_46810[(2)] = inst_46726);

(statearr_46770_46810[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (13))){
var inst_46675 = (state_46762[(8)]);
var state_46762__$1 = state_46762;
if(cljs.core.truth_(inst_46675)){
var statearr_46771_46811 = state_46762__$1;
(statearr_46771_46811[(1)] = (18));

} else {
var statearr_46772_46812 = state_46762__$1;
(statearr_46772_46812[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (22))){
var inst_46726 = (state_46762[(9)]);
var inst_46730 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_46726);
var state_46762__$1 = state_46762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46762__$1,(24),inst_46730);
} else {
if((state_val_46763 === (6))){
var inst_46675 = (state_46762[(8)]);
var state_46762__$1 = state_46762;
var statearr_46773_46813 = state_46762__$1;
(statearr_46773_46813[(2)] = inst_46675);

(statearr_46773_46813[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (17))){
var inst_46723 = (state_46762[(2)]);
var state_46762__$1 = state_46762;
var statearr_46774_46814 = state_46762__$1;
(statearr_46774_46814[(2)] = inst_46723);

(statearr_46774_46814[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (3))){
var inst_46760 = (state_46762[(2)]);
var state_46762__$1 = state_46762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46762__$1,inst_46760);
} else {
if((state_val_46763 === (12))){
var inst_46688 = ["_tx",null,"_block",null];
var inst_46689 = (new cljs.core.PersistentArrayMap(null,2,inst_46688,null));
var inst_46690 = (new cljs.core.PersistentHashSet(null,inst_46689,null));
var inst_46691 = cljs.core.last(clause);
var inst_46692 = (inst_46690.cljs$core$IFn$_invoke$arity$1 ? inst_46690.cljs$core$IFn$_invoke$arity$1(inst_46691) : inst_46690.call(null,inst_46691));
var state_46762__$1 = state_46762;
if(cljs.core.truth_(inst_46692)){
var statearr_46775_46815 = state_46762__$1;
(statearr_46775_46815[(1)] = (15));

} else {
var statearr_46776_46816 = state_46762__$1;
(statearr_46776_46816[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (2))){
var inst_46673 = (state_46762[(7)]);
var _ = (function (){var statearr_46777 = state_46762;
(statearr_46777[(4)] = cljs.core.cons((5),(state_46762[(4)])));

return statearr_46777;
})();
var inst_46672 = cljs.core.first(clause);
var inst_46673__$1 = fluree.db.query.analytical.variable_QMARK_(inst_46672);
var inst_46674 = cljs.core.last(clause);
var inst_46675 = fluree.db.query.analytical.variable_QMARK_(inst_46674);
var state_46762__$1 = (function (){var statearr_46778 = state_46762;
(statearr_46778[(7)] = inst_46673__$1);

(statearr_46778[(8)] = inst_46675);

return statearr_46778;
})();
if(cljs.core.truth_(inst_46673__$1)){
var statearr_46779_46817 = state_46762__$1;
(statearr_46779_46817[(1)] = (6));

} else {
var statearr_46780_46818 = state_46762__$1;
(statearr_46780_46818[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (23))){
var inst_46675 = (state_46762[(8)]);
var inst_46735 = (state_46762[(2)]);
var inst_46736 = fluree.db.flake.sid__GT_cid(inst_46735);
var inst_46737 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_46736);
var inst_46738 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_46739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46740 = [inst_46675];
var inst_46741 = (new cljs.core.PersistentVector(null,1,(5),inst_46739,inst_46740,null));
var inst_46742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46744 = [inst_46737];
var inst_46745 = (new cljs.core.PersistentVector(null,1,(5),inst_46743,inst_46744,null));
var inst_46746 = [inst_46745];
var inst_46747 = (new cljs.core.PersistentVector(null,1,(5),inst_46742,inst_46746,null));
var inst_46748 = cljs.core.PersistentHashMap.EMPTY;
var inst_46749 = [inst_46741,inst_46747,inst_46748];
var inst_46750 = cljs.core.PersistentHashMap.fromArrays(inst_46738,inst_46749);
var state_46762__$1 = state_46762;
var statearr_46781_46819 = state_46762__$1;
(statearr_46781_46819[(2)] = inst_46750);

(statearr_46781_46819[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (19))){
var state_46762__$1 = state_46762;
var statearr_46782_46820 = state_46762__$1;
(statearr_46782_46820[(2)] = null);

(statearr_46782_46820[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (11))){
var inst_46757 = (state_46762[(2)]);
var _ = (function (){var statearr_46784 = state_46762;
(statearr_46784[(4)] = cljs.core.rest((state_46762[(4)])));

return statearr_46784;
})();
var state_46762__$1 = state_46762;
var statearr_46785_46821 = state_46762__$1;
(statearr_46785_46821[(2)] = inst_46757);

(statearr_46785_46821[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (9))){
var inst_46681 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_46682 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_46683 = cljs.core.PersistentHashMap.fromArrays(inst_46681,inst_46682);
var inst_46684 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_46683);
var inst_46685 = (function(){throw inst_46684})();
var state_46762__$1 = state_46762;
var statearr_46786_46822 = state_46762__$1;
(statearr_46786_46822[(2)] = inst_46685);

(statearr_46786_46822[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (5))){
var _ = (function (){var statearr_46787 = state_46762;
(statearr_46787[(4)] = cljs.core.rest((state_46762[(4)])));

return statearr_46787;
})();
var state_46762__$1 = state_46762;
var ex46783 = (state_46762__$1[(2)]);
var statearr_46788_46823 = state_46762__$1;
(statearr_46788_46823[(5)] = ex46783);


if((ex46783 instanceof Error)){
var statearr_46789_46824 = state_46762__$1;
(statearr_46789_46824[(1)] = (4));

(statearr_46789_46824[(5)] = null);

} else {
throw ex46783;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (14))){
var inst_46755 = (state_46762[(2)]);
var state_46762__$1 = state_46762;
var statearr_46790_46825 = state_46762__$1;
(statearr_46790_46825[(2)] = inst_46755);

(statearr_46790_46825[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (16))){
var inst_46673 = (state_46762[(7)]);
var inst_46675 = (state_46762[(8)]);
var inst_46706 = cljs.core.last(clause);
var inst_46707 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_46706);
var inst_46708 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_46709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46708,inst_46707);
var inst_46710 = fluree.db.flake.min_subject_id(inst_46707);
var inst_46711 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_46712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46713 = [inst_46673];
var inst_46714 = (new cljs.core.PersistentVector(null,1,(5),inst_46712,inst_46713,null));
var inst_46715 = (function (){var subject_var = inst_46673;
var object_var = inst_46675;
var partition = inst_46707;
var max_sid = inst_46709;
var min_sid = inst_46710;
return (function (p1__46665_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__46665_SHARP_);
});
})();
var inst_46716 = (inst_46709 + (1));
var inst_46717 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_46710,inst_46716);
var inst_46718 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_46715,inst_46717);
var inst_46719 = cljs.core.PersistentHashMap.EMPTY;
var inst_46720 = [inst_46714,inst_46718,inst_46719];
var inst_46721 = cljs.core.PersistentHashMap.fromArrays(inst_46711,inst_46720);
var state_46762__$1 = state_46762;
var statearr_46791_46826 = state_46762__$1;
(statearr_46791_46826[(2)] = inst_46721);

(statearr_46791_46826[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (10))){
var inst_46673 = (state_46762[(7)]);
var state_46762__$1 = state_46762;
if(cljs.core.truth_(inst_46673)){
var statearr_46792_46827 = state_46762__$1;
(statearr_46792_46827[(1)] = (12));

} else {
var statearr_46793_46828 = state_46762__$1;
(statearr_46793_46828[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (18))){
var inst_46726 = (state_46762[(9)]);
var inst_46726__$1 = cljs.core.first(clause);
var inst_46727 = typeof inst_46726__$1 === 'number';
var state_46762__$1 = (function (){var statearr_46794 = state_46762;
(statearr_46794[(9)] = inst_46726__$1);

return statearr_46794;
})();
if(cljs.core.truth_(inst_46727)){
var statearr_46795_46829 = state_46762__$1;
(statearr_46795_46829[(1)] = (21));

} else {
var statearr_46796_46830 = state_46762__$1;
(statearr_46796_46830[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46763 === (8))){
var inst_46679 = (state_46762[(2)]);
var state_46762__$1 = state_46762;
if(cljs.core.truth_(inst_46679)){
var statearr_46797_46831 = state_46762__$1;
(statearr_46797_46831[(1)] = (9));

} else {
var statearr_46798_46832 = state_46762__$1;
(statearr_46798_46832[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto____0 = (function (){
var statearr_46799 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46799[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto__);

(statearr_46799[(1)] = (1));

return statearr_46799;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto____1 = (function (state_46762){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_46762);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e46800){var ex__24301__auto__ = e46800;
var statearr_46801_46833 = state_46762;
(statearr_46801_46833[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_46762[(4)]))){
var statearr_46802_46834 = state_46762;
(statearr_46802_46834[(1)] = cljs.core.first((state_46762[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__46835 = state_46762;
state_46762 = G__46835;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto__ = function(state_46762){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto____1.call(this,state_46762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_46803 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_46803[(6)] = c__24424__auto__);

return statearr_46803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__46842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__46842 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__46842;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4611__auto__ = (function fluree$db$query$analytical$variance_$_iter__46843(s__46844){
return (new cljs.core.LazySeq(null,(function (){
var s__46844__$1 = s__46844;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__46844__$1);
if(temp__5753__auto__){
var s__46844__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__46844__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__46844__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__46846 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__46845 = (0);
while(true){
if((i__46845 < size__4610__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__46845);
var delta = (x - mean);
cljs.core.chunk_append(b__46846,(delta * delta));

var G__46848 = (i__46845 + (1));
i__46845 = G__46848;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__46846),fluree$db$query$analytical$variance_$_iter__46843(cljs.core.chunk_rest(s__46844__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__46846),null);
}
} else {
var x = cljs.core.first(s__46844__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__46843(cljs.core.rest(s__46844__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__46847 = variance(coll);
return Math.sqrt(G__46847);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4295__auto__ = n;
var y__4296__auto__ = (- n);
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
}),(function() {
var G__46849 = null;
var G__46849__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__46849__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__46849 = function(n,coll){
switch(arguments.length){
case 1:
return G__46849__1.call(this,n);
case 2:
return G__46849__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46849.cljs$core$IFn$_invoke$arity$1 = G__46849__1;
G__46849.cljs$core$IFn$_invoke$arity$2 = G__46849__2;
return G__46849;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__46850 = null;
var G__46850__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__46850__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__46850 = function(n,coll){
switch(arguments.length){
case 1:
return G__46850__1.call(this,n);
case 2:
return G__46850__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46850.cljs$core$IFn$_invoke$arity$1 = G__46850__1;
G__46850.cljs$core$IFn$_invoke$arity$2 = G__46850__2;
return G__46850;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__46851 = null;
var G__46851__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__46851__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__46851 = function(n,coll){
switch(arguments.length){
case 1:
return G__46851__1.call(this,n);
case 2:
return G__46851__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46851.cljs$core$IFn$_invoke$arity$1 = G__46851__1;
G__46851.cljs$core$IFn$_invoke$arity$2 = G__46851__2;
return G__46851;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__46852 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46852,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46852,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46852,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__46855 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__46858 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__46858) : agg_fn.call(null,G__46858));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46855,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46855,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__46859 = agg;
var map__46859__$1 = cljs.core.__destructure_map(map__46859);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46859__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46859__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46859__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__46861 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46861,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46861,(1),null);
var map__46864 = res__$1;
var map__46864__$1 = cljs.core.__destructure_map(map__46864);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46864__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46864__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46860_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__46860_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46865_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__46865_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46866_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__46866_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__46867_SHARP_,p2__46868_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__46867_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__46868_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46869_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__46869_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__46872,row,b_tuple){
var vec__46873 = p__46872;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46873,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46873,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46870_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__46870_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = acc;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46871_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__46871_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46876_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__46876_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46877_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__46877_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__46882 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__46884 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__46883 = (function (p1__46878_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__46878_SHARP_);
});
return fexpr__46883(G__46884);
})()),cljs.core.set(b_idxs));
var fexpr__46881 = (function (p1__46879_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__46879_SHARP_);
});
return fexpr__46881(G__46882);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46880_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__46880_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46885_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__46885_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46886_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__46886_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__46891 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__46893 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__46892 = (function (p1__46887_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__46887_SHARP_);
});
return fexpr__46892(G__46893);
})()),cljs.core.set(b_idxs));
var fexpr__46890 = (function (p1__46888_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__46888_SHARP_);
});
return fexpr__46890(G__46891);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46889_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__46889_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__46895 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46895,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46895,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__46894_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__46894_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__46900 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46900,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46900,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46898_SHARP_){
return fluree.db.util.core.index_of(headers,p1__46898_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__46899_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__46899_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__46903,filters,optional_QMARK_){
var map__46904 = p__46903;
var map__46904__$1 = cljs.core.__destructure_map(map__46904);
var tuple_map = map__46904__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46904__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46904__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46904__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__46905 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46905,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46905,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__46908 = res;
var map__46908__$1 = cljs.core.__destructure_map(map__46908);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46908__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46908__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_46964){
var state_val_46965 = (state_46964[(1)]);
if((state_val_46965 === (7))){
var inst_46938 = (state_46964[(7)]);
var inst_46936 = (state_46964[(2)]);
var inst_46937 = fluree.db.util.async.throw_err(inst_46936);
var inst_46938__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46937,(0),null);
var inst_46939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46937,(1),null);
var inst_46940 = (inst_46938__$1 == null);
var state_46964__$1 = (function (){var statearr_46966 = state_46964;
(statearr_46966[(8)] = inst_46939);

(statearr_46966[(7)] = inst_46938__$1);

return statearr_46966;
})();
if(cljs.core.truth_(inst_46940)){
var statearr_46967_46996 = state_46964__$1;
(statearr_46967_46996[(1)] = (8));

} else {
var statearr_46968_46997 = state_46964__$1;
(statearr_46968_46997[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (1))){
var inst_46916 = optional_clauses;
var inst_46917 = cljs.core.seq(inst_46916);
var inst_46918 = cljs.core.first(inst_46917);
var inst_46919 = cljs.core.next(inst_46917);
var inst_46920 = where_tuples;
var inst_46921 = inst_46916;
var inst_46922 = inst_46920;
var state_46964__$1 = (function (){var statearr_46969 = state_46964;
(statearr_46969[(9)] = inst_46919);

(statearr_46969[(10)] = inst_46918);

(statearr_46969[(11)] = inst_46921);

(statearr_46969[(12)] = inst_46922);

return statearr_46969;
})();
var statearr_46970_46998 = state_46964__$1;
(statearr_46970_46998[(2)] = null);

(statearr_46970_46998[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (4))){
var inst_46928 = (state_46964[(13)]);
var inst_46929 = (state_46964[(14)]);
var inst_46922 = (state_46964[(12)]);
var inst_46934 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_46922,inst_46928,inst_46929,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_46922,inst_46928,inst_46929,true,fuel,max_fuel,opts));
var state_46964__$1 = state_46964;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46964__$1,(7),inst_46934);
} else {
if((state_val_46965 === (15))){
var state_46964__$1 = state_46964;
var statearr_46971_46999 = state_46964__$1;
(statearr_46971_46999[(2)] = null);

(statearr_46971_46999[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (13))){
var inst_46955 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
var statearr_46972_47000 = state_46964__$1;
(statearr_46972_47000[(2)] = inst_46955);

(statearr_46972_47000[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (6))){
var inst_46960 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
var statearr_46973_47001 = state_46964__$1;
(statearr_46973_47001[(2)] = inst_46960);

(statearr_46973_47001[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (3))){
var inst_46962 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46964__$1,inst_46962);
} else {
if((state_val_46965 === (12))){
var state_46964__$1 = state_46964;
var statearr_46974_47002 = state_46964__$1;
(statearr_46974_47002[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (2))){
var inst_46928 = (state_46964[(13)]);
var inst_46921 = (state_46964[(11)]);
var inst_46927 = cljs.core.seq(inst_46921);
var inst_46928__$1 = cljs.core.first(inst_46927);
var inst_46929 = cljs.core.next(inst_46927);
var state_46964__$1 = (function (){var statearr_46976 = state_46964;
(statearr_46976[(13)] = inst_46928__$1);

(statearr_46976[(14)] = inst_46929);

return statearr_46976;
})();
if(cljs.core.truth_(inst_46928__$1)){
var statearr_46977_47003 = state_46964__$1;
(statearr_46977_47003[(1)] = (4));

} else {
var statearr_46978_47004 = state_46964__$1;
(statearr_46978_47004[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (11))){
var inst_46939 = (state_46964[(8)]);
var inst_46938 = (state_46964[(7)]);
var inst_46921 = inst_46939;
var inst_46922 = inst_46938;
var state_46964__$1 = (function (){var statearr_46979 = state_46964;
(statearr_46979[(11)] = inst_46921);

(statearr_46979[(12)] = inst_46922);

return statearr_46979;
})();
var statearr_46980_47005 = state_46964__$1;
(statearr_46980_47005[(2)] = null);

(statearr_46980_47005[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (9))){
var inst_46928 = (state_46964[(13)]);
var inst_46944 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_46928);
var state_46964__$1 = state_46964;
if(cljs.core.truth_(inst_46944)){
var statearr_46981_47006 = state_46964__$1;
(statearr_46981_47006[(1)] = (11));

} else {
var statearr_46982_47007 = state_46964__$1;
(statearr_46982_47007[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (5))){
var inst_46922 = (state_46964[(12)]);
var state_46964__$1 = state_46964;
var statearr_46983_47008 = state_46964__$1;
(statearr_46983_47008[(2)] = inst_46922);

(statearr_46983_47008[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (14))){
var inst_46939 = (state_46964[(8)]);
var inst_46922 = (state_46964[(12)]);
var inst_46938 = (state_46964[(7)]);
var inst_46949 = fluree.db.query.analytical.left_outer_join(inst_46922,inst_46938);
var inst_46921 = inst_46939;
var inst_46922__$1 = inst_46949;
var state_46964__$1 = (function (){var statearr_46984 = state_46964;
(statearr_46984[(11)] = inst_46921);

(statearr_46984[(12)] = inst_46922__$1);

return statearr_46984;
})();
var statearr_46985_47009 = state_46964__$1;
(statearr_46985_47009[(2)] = null);

(statearr_46985_47009[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (16))){
var inst_46953 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
var statearr_46987_47010 = state_46964__$1;
(statearr_46987_47010[(2)] = inst_46953);

(statearr_46987_47010[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (10))){
var inst_46957 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
var statearr_46988_47011 = state_46964__$1;
(statearr_46988_47011[(2)] = inst_46957);

(statearr_46988_47011[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46965 === (8))){
var inst_46939 = (state_46964[(8)]);
var inst_46922 = (state_46964[(12)]);
var tmp46986 = inst_46922;
var inst_46921 = inst_46939;
var inst_46922__$1 = tmp46986;
var state_46964__$1 = (function (){var statearr_46989 = state_46964;
(statearr_46989[(11)] = inst_46921);

(statearr_46989[(12)] = inst_46922__$1);

return statearr_46989;
})();
var statearr_46990_47012 = state_46964__$1;
(statearr_46990_47012[(2)] = null);

(statearr_46990_47012[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto____0 = (function (){
var statearr_46991 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46991[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto__);

(statearr_46991[(1)] = (1));

return statearr_46991;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto____1 = (function (state_46964){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_46964);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e46992){var ex__24301__auto__ = e46992;
var statearr_46993_47013 = state_46964;
(statearr_46993_47013[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_46964[(4)]))){
var statearr_46994_47014 = state_46964;
(statearr_46994_47014[(1)] = cljs.core.first((state_46964[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__47015 = state_46964;
state_46964 = G__47015;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto__ = function(state_46964){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto____1.call(this,state_46964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_46995 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_46995[(6)] = c__24424__auto__);

return statearr_46995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__47017){
var vec__47018 = p__47017;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47018,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47018,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__47016_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__47016_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__47022,p__47023,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__47024 = p__47022;
var map__47024__$1 = cljs.core.__destructure_map(map__47024);
var q_map = map__47024__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47024__$1,cljs.core.cst$kw$prefixes);
var map__47025 = p__47023;
var map__47025__$1 = cljs.core.__destructure_map(map__47025);
var res = map__47025__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47025__$1,cljs.core.cst$kw$vars);
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_47262){
var state_val_47263 = (state_47262[(1)]);
if((state_val_47263 === (65))){
var inst_47211 = (state_47262[(7)]);
var inst_47212 = (state_47262[(8)]);
var inst_47223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47224 = fluree.db.query.analytical.full_text__GT_tuples(inst_47211,res,inst_47212);
var inst_47225 = [inst_47224,r];
var inst_47226 = (new cljs.core.PersistentVector(null,2,(5),inst_47223,inst_47225,null));
var state_47262__$1 = state_47262;
var statearr_47264_47377 = state_47262__$1;
(statearr_47264_47377[(2)] = inst_47226);

(statearr_47264_47377[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (70))){
var inst_47238 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47265_47378 = state_47262__$1;
(statearr_47265_47378[(2)] = inst_47238);

(statearr_47265_47378[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (62))){
var inst_47212 = (state_47262[(8)]);
var inst_47220 = cljs.core.second(inst_47212);
var inst_47221 = clojure.string.starts_with_QMARK_(inst_47220,"fullText:");
var state_47262__$1 = state_47262;
if(inst_47221){
var statearr_47266_47379 = state_47262__$1;
(statearr_47266_47379[(1)] = (65));

} else {
var statearr_47267_47380 = state_47262__$1;
(statearr_47267_47380[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (7))){
var inst_47131 = (state_47262[(9)]);
var inst_47130 = cljs.core.count(clause);
var inst_47131__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_47130);
var state_47262__$1 = (function (){var statearr_47268 = state_47262;
(statearr_47268[(9)] = inst_47131__$1);

return statearr_47268;
})();
if(inst_47131__$1){
var statearr_47269_47381 = state_47262__$1;
(statearr_47269_47381[(1)] = (31));

} else {
var statearr_47270_47382 = state_47262__$1;
(statearr_47270_47382[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (59))){
var inst_47245 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47271_47383 = state_47262__$1;
(statearr_47271_47383[(2)] = inst_47245);

(statearr_47271_47383[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (20))){
var inst_47094 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47272_47384 = state_47262__$1;
(statearr_47272_47384[(2)] = inst_47094);

(statearr_47272_47384[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (58))){
var state_47262__$1 = state_47262;
var statearr_47273_47385 = state_47262__$1;
(statearr_47273_47385[(2)] = null);

(statearr_47273_47385[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (60))){
var inst_47211 = (state_47262[(7)]);
var inst_47209 = (state_47262[(2)]);
var inst_47210 = fluree.db.util.async.throw_err(inst_47209);
var inst_47211__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47210,(0),null);
var inst_47212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47210,(1),null);
var inst_47213 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_47211__$1);
var state_47262__$1 = (function (){var statearr_47274 = state_47262;
(statearr_47274[(7)] = inst_47211__$1);

(statearr_47274[(8)] = inst_47212);

return statearr_47274;
})();
if(inst_47213){
var statearr_47275_47386 = state_47262__$1;
(statearr_47275_47386[(1)] = (61));

} else {
var statearr_47276_47387 = state_47262__$1;
(statearr_47276_47387[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (27))){
var inst_47124 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47277_47388 = state_47262__$1;
(statearr_47277_47388[(2)] = inst_47124);

(statearr_47277_47388[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (1))){
var state_47262__$1 = state_47262;
var statearr_47278_47389 = state_47262__$1;
(statearr_47278_47389[(2)] = null);

(statearr_47278_47389[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (69))){
var state_47262__$1 = state_47262;
var statearr_47279_47390 = state_47262__$1;
(statearr_47279_47390[(2)] = null);

(statearr_47279_47390[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (24))){
var inst_47088 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47280_47391 = state_47262__$1;
(statearr_47280_47391[(2)] = inst_47088);

(statearr_47280_47391[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (55))){
var inst_47194 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_47195 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47196 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_47197 = cljs.core.PersistentHashMap.fromArrays(inst_47195,inst_47196);
var inst_47198 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47194,inst_47197);
var inst_47199 = (function(){throw inst_47198})();
var state_47262__$1 = state_47262;
var statearr_47281_47392 = state_47262__$1;
(statearr_47281_47392[(2)] = inst_47199);

(statearr_47281_47392[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (39))){
var inst_47151 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
if(cljs.core.truth_(inst_47151)){
var statearr_47282_47393 = state_47262__$1;
(statearr_47282_47393[(1)] = (40));

} else {
var statearr_47283_47394 = state_47262__$1;
(statearr_47283_47394[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (46))){
var inst_47251 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47284_47395 = state_47262__$1;
(statearr_47284_47395[(2)] = inst_47251);

(statearr_47284_47395[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (4))){
var inst_47026 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47285_47396 = state_47262__$1;
(statearr_47285_47396[(2)] = inst_47026);

(statearr_47285_47396[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (54))){
var inst_47187 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_47188 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47189 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_47190 = cljs.core.PersistentHashMap.fromArrays(inst_47188,inst_47189);
var inst_47191 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47187,inst_47190);
var inst_47192 = (function(){throw inst_47191})();
var state_47262__$1 = state_47262;
var statearr_47286_47397 = state_47262__$1;
(statearr_47286_47397[(2)] = inst_47192);

(statearr_47286_47397[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (15))){
var inst_47126 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47287_47398 = state_47262__$1;
(statearr_47287_47398[(2)] = inst_47126);

(statearr_47287_47398[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (48))){
var inst_47175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47176 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_47177 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_47176);
var inst_47178 = [inst_47177,r];
var inst_47179 = (new cljs.core.PersistentVector(null,2,(5),inst_47175,inst_47178,null));
var state_47262__$1 = state_47262;
var statearr_47288_47399 = state_47262__$1;
(statearr_47288_47399[(2)] = inst_47179);

(statearr_47288_47399[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (50))){
var inst_47249 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47289_47400 = state_47262__$1;
(statearr_47289_47400[(2)] = inst_47249);

(statearr_47289_47400[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (21))){
var inst_47064 = (state_47262[(10)]);
var inst_47062 = (state_47262[(11)]);
var inst_47060 = (state_47262[(12)]);
var inst_47035 = (state_47262[(13)]);
var inst_47063 = (state_47262[(14)]);
var inst_47039 = (state_47262[(15)]);
var inst_47072 = (state_47262[(16)]);
var inst_47065 = (state_47262[(17)]);
var inst_47071 = (state_47262[(18)]);
var inst_47076 = (state_47262[(2)]);
var inst_47077 = fluree.db.util.async.throw_err(inst_47076);
var inst_47078 = (function (){var vec__47067 = inst_47064;
var first__47059 = inst_47062;
var new_res = inst_47077;
var G__47056 = inst_47064;
var rest = inst_47072;
var pred__47036 = inst_47039;
var expr__47037 = inst_47035;
var tuples = inst_47065;
var seq__47058 = inst_47063;
var seq__47068 = inst_47072;
var segment_type = inst_47035;
var first__47069 = inst_47071;
var clause_group = inst_47071;
var vec__47057 = inst_47060;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_47079 = cljs.core.keys(vars);
var inst_47080 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_47078,inst_47077,inst_47079);
var inst_47081 = fluree.db.query.analytical.res_absorb_vars(inst_47080);
var state_47262__$1 = (function (){var statearr_47290 = state_47262;
(statearr_47290[(19)] = inst_47081);

return statearr_47290;
})();
if(cljs.core.truth_(inst_47065)){
var statearr_47291_47401 = state_47262__$1;
(statearr_47291_47401[(1)] = (22));

} else {
var statearr_47292_47402 = state_47262__$1;
(statearr_47292_47402[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (31))){
var inst_47133 = cljs.core.second(clause);
var inst_47134 = clojure.string.starts_with_QMARK_(inst_47133,"fullText:");
var state_47262__$1 = state_47262;
var statearr_47293_47403 = state_47262__$1;
(statearr_47293_47403[(2)] = inst_47134);

(statearr_47293_47403[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (32))){
var inst_47131 = (state_47262[(9)]);
var state_47262__$1 = state_47262;
var statearr_47294_47404 = state_47262__$1;
(statearr_47294_47404[(2)] = inst_47131);

(statearr_47294_47404[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (40))){
var inst_47153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47154 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_47262__$1 = (function (){var statearr_47295 = state_47262;
(statearr_47295[(20)] = inst_47153);

return statearr_47295;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47262__$1,(43),inst_47154);
} else {
if((state_val_47263 === (56))){
var inst_47201 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47296_47405 = state_47262__$1;
(statearr_47296_47405[(2)] = inst_47201);

(statearr_47296_47405[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (33))){
var inst_47137 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
if(cljs.core.truth_(inst_47137)){
var statearr_47297_47406 = state_47262__$1;
(statearr_47297_47406[(1)] = (34));

} else {
var statearr_47298_47407 = state_47262__$1;
(statearr_47298_47407[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (13))){
var inst_47060 = (state_47262[(12)]);
var inst_47060__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_47061 = cljs.core.seq(inst_47060__$1);
var inst_47062 = cljs.core.first(inst_47061);
var inst_47063 = cljs.core.next(inst_47061);
var inst_47064 = inst_47060__$1;
var inst_47065 = null;
var state_47262__$1 = (function (){var statearr_47299 = state_47262;
(statearr_47299[(10)] = inst_47064);

(statearr_47299[(11)] = inst_47062);

(statearr_47299[(12)] = inst_47060__$1);

(statearr_47299[(14)] = inst_47063);

(statearr_47299[(17)] = inst_47065);

return statearr_47299;
})();
var statearr_47300_47408 = state_47262__$1;
(statearr_47300_47408[(2)] = null);

(statearr_47300_47408[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (22))){
var inst_47081 = (state_47262[(19)]);
var inst_47072 = (state_47262[(16)]);
var inst_47065 = (state_47262[(17)]);
var inst_47083 = fluree.db.query.union.results(inst_47065,inst_47081);
var inst_47064 = inst_47072;
var inst_47065__$1 = inst_47083;
var state_47262__$1 = (function (){var statearr_47301 = state_47262;
(statearr_47301[(10)] = inst_47064);

(statearr_47301[(17)] = inst_47065__$1);

return statearr_47301;
})();
var statearr_47302_47409 = state_47262__$1;
(statearr_47302_47409[(2)] = null);

(statearr_47302_47409[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (36))){
var inst_47255 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47303_47410 = state_47262__$1;
(statearr_47303_47410[(2)] = inst_47255);

(statearr_47303_47410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (41))){
var inst_47161 = cljs.core.count(clause);
var inst_47162 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_47161);
var state_47262__$1 = state_47262;
if(inst_47162){
var statearr_47304_47411 = state_47262__$1;
(statearr_47304_47411[(1)] = (44));

} else {
var statearr_47305_47412 = state_47262__$1;
(statearr_47305_47412[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (43))){
var inst_47153 = (state_47262[(20)]);
var inst_47156 = (state_47262[(2)]);
var inst_47157 = fluree.db.util.async.throw_err(inst_47156);
var inst_47158 = [inst_47157,r];
var inst_47159 = (new cljs.core.PersistentVector(null,2,(5),inst_47153,inst_47158,null));
var state_47262__$1 = state_47262;
var statearr_47306_47413 = state_47262__$1;
(statearr_47306_47413[(2)] = inst_47159);

(statearr_47306_47413[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (61))){
var inst_47212 = (state_47262[(8)]);
var inst_47215 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_47212,r,res,optional_QMARK_,fuel,max_fuel);
var state_47262__$1 = state_47262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47262__$1,(64),inst_47215);
} else {
if((state_val_47263 === (29))){
var inst_47035 = (state_47262[(13)]);
var inst_47118 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47035)].join('');
var inst_47119 = (new Error(inst_47118));
var inst_47120 = (function(){throw inst_47119})();
var state_47262__$1 = state_47262;
var statearr_47307_47414 = state_47262__$1;
(statearr_47307_47414[(2)] = inst_47120);

(statearr_47307_47414[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (44))){
var inst_47164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47165 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_47262__$1 = (function (){var statearr_47308 = state_47262;
(statearr_47308[(21)] = inst_47164);

return statearr_47308;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47262__$1,(47),inst_47165);
} else {
if((state_val_47263 === (6))){
var inst_47035 = (state_47262[(13)]);
var inst_47039 = (state_47262[(15)]);
var inst_47034 = cljs.core.keys(clause);
var inst_47035__$1 = cljs.core.first(inst_47034);
var inst_47039__$1 = cljs.core._EQ_;
var inst_47040 = (function (){var G__47309 = cljs.core.cst$kw$optional;
var G__47310 = inst_47035__$1;
return (inst_47039__$1.cljs$core$IFn$_invoke$arity$2 ? inst_47039__$1.cljs$core$IFn$_invoke$arity$2(G__47309,G__47310) : inst_47039__$1.call(null,G__47309,G__47310));
})();
var state_47262__$1 = (function (){var statearr_47311 = state_47262;
(statearr_47311[(13)] = inst_47035__$1);

(statearr_47311[(15)] = inst_47039__$1);

return statearr_47311;
})();
if(cljs.core.truth_(inst_47040)){
var statearr_47312_47415 = state_47262__$1;
(statearr_47312_47415[(1)] = (9));

} else {
var statearr_47313_47416 = state_47262__$1;
(statearr_47313_47416[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (28))){
var inst_47112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47113 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_47114 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_47113,optional_QMARK_);
var inst_47115 = [inst_47114,r];
var inst_47116 = (new cljs.core.PersistentVector(null,2,(5),inst_47112,inst_47115,null));
var state_47262__$1 = state_47262;
var statearr_47314_47417 = state_47262__$1;
(statearr_47314_47417[(2)] = inst_47116);

(statearr_47314_47417[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (64))){
var inst_47217 = (state_47262[(2)]);
var inst_47218 = fluree.db.util.async.throw_err(inst_47217);
var state_47262__$1 = state_47262;
var statearr_47315_47418 = state_47262__$1;
(statearr_47315_47418[(2)] = inst_47218);

(statearr_47315_47418[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (51))){
var inst_47184 = cljs.core.first(clause);
var inst_47185 = cljs.core.sequential_QMARK_(inst_47184);
var state_47262__$1 = state_47262;
if(inst_47185){
var statearr_47316_47419 = state_47262__$1;
(statearr_47316_47419[(1)] = (54));

} else {
var statearr_47317_47420 = state_47262__$1;
(statearr_47317_47420[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (25))){
var inst_47035 = (state_47262[(13)]);
var inst_47039 = (state_47262[(15)]);
var inst_47100 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_47101 = (function (){var segment_type = inst_47035;
var pred__47036 = inst_47039;
var expr__47037 = inst_47035;
var bindings = inst_47100;
return (function (p1__47021_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__47021_SHARP_);
});
})();
var inst_47102 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_47101,inst_47100);
var inst_47103 = cljs.core.PersistentHashMap.EMPTY;
var inst_47104 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_47103,inst_47102);
var inst_47105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47106 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_47104);
var inst_47107 = [inst_47106,r];
var inst_47108 = (new cljs.core.PersistentVector(null,2,(5),inst_47105,inst_47107,null));
var state_47262__$1 = state_47262;
var statearr_47318_47421 = state_47262__$1;
(statearr_47318_47421[(2)] = inst_47108);

(statearr_47318_47421[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (34))){
var inst_47139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47140 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_47141 = [inst_47140,r];
var inst_47142 = (new cljs.core.PersistentVector(null,2,(5),inst_47139,inst_47141,null));
var state_47262__$1 = state_47262;
var statearr_47319_47422 = state_47262__$1;
(statearr_47319_47422[(2)] = inst_47142);

(statearr_47319_47422[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (17))){
var inst_47096 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47320_47423 = state_47262__$1;
(statearr_47320_47423[(2)] = inst_47096);

(statearr_47320_47423[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (3))){
var inst_47260 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47262__$1,inst_47260);
} else {
if((state_val_47263 === (12))){
var inst_47042 = (state_47262[(22)]);
var inst_47046 = (state_47262[(2)]);
var inst_47047 = fluree.db.util.async.throw_err(inst_47046);
var inst_47048 = [inst_47047,r];
var inst_47049 = (new cljs.core.PersistentVector(null,2,(5),inst_47042,inst_47048,null));
var state_47262__$1 = state_47262;
var statearr_47321_47424 = state_47262__$1;
(statearr_47321_47424[(2)] = inst_47049);

(statearr_47321_47424[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (2))){
var _ = (function (){var statearr_47322 = state_47262;
(statearr_47322[(4)] = cljs.core.cons((5),(state_47262[(4)])));

return statearr_47322;
})();
var inst_47032 = cljs.core.map_QMARK_(clause);
var state_47262__$1 = state_47262;
if(inst_47032){
var statearr_47323_47425 = state_47262__$1;
(statearr_47323_47425[(1)] = (6));

} else {
var statearr_47324_47426 = state_47262__$1;
(statearr_47324_47426[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (66))){
var state_47262__$1 = state_47262;
var statearr_47325_47427 = state_47262__$1;
(statearr_47325_47427[(1)] = (68));



return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (23))){
var inst_47081 = (state_47262[(19)]);
var inst_47072 = (state_47262[(16)]);
var inst_47064 = inst_47072;
var inst_47065 = inst_47081;
var state_47262__$1 = (function (){var statearr_47327 = state_47262;
(statearr_47327[(10)] = inst_47064);

(statearr_47327[(17)] = inst_47065);

return statearr_47327;
})();
var statearr_47328_47428 = state_47262__$1;
(statearr_47328_47428[(2)] = null);

(statearr_47328_47428[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (47))){
var inst_47164 = (state_47262[(21)]);
var inst_47167 = (state_47262[(2)]);
var inst_47168 = fluree.db.util.async.throw_err(inst_47167);
var inst_47169 = [inst_47168,r];
var inst_47170 = (new cljs.core.PersistentVector(null,2,(5),inst_47164,inst_47169,null));
var state_47262__$1 = state_47262;
var statearr_47329_47429 = state_47262__$1;
(statearr_47329_47429[(2)] = inst_47170);

(statearr_47329_47429[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (35))){
var inst_47145 = (state_47262[(23)]);
var inst_47144 = cljs.core.count(clause);
var inst_47145__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_47144);
var state_47262__$1 = (function (){var statearr_47330 = state_47262;
(statearr_47330[(23)] = inst_47145__$1);

return statearr_47330;
})();
if(inst_47145__$1){
var statearr_47331_47430 = state_47262__$1;
(statearr_47331_47430[(1)] = (37));

} else {
var statearr_47332_47431 = state_47262__$1;
(statearr_47332_47431[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (19))){
var inst_47065 = (state_47262[(17)]);
var inst_47090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47091 = [inst_47065,r];
var inst_47092 = (new cljs.core.PersistentVector(null,2,(5),inst_47090,inst_47091,null));
var state_47262__$1 = state_47262;
var statearr_47333_47432 = state_47262__$1;
(statearr_47333_47432[(2)] = inst_47092);

(statearr_47333_47432[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (57))){
var inst_47207 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_47262__$1 = state_47262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47262__$1,(60),inst_47207);
} else {
if((state_val_47263 === (68))){
var inst_47211 = (state_47262[(7)]);
var inst_47212 = (state_47262[(8)]);
var inst_47229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47230 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_47211,res,inst_47212,fuel,max_fuel);
var state_47262__$1 = (function (){var statearr_47334 = state_47262;
(statearr_47334[(24)] = inst_47229);

return statearr_47334;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47262__$1,(71),inst_47230);
} else {
if((state_val_47263 === (11))){
var inst_47128 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47336_47433 = state_47262__$1;
(statearr_47336_47433[(2)] = inst_47128);

(statearr_47336_47433[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (9))){
var inst_47042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47043 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_47044 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_47043,res,fuel,max_fuel,opts);
var state_47262__$1 = (function (){var statearr_47337 = state_47262;
(statearr_47337[(22)] = inst_47042);

return statearr_47337;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47262__$1,(12),inst_47044);
} else {
if((state_val_47263 === (5))){
var _ = (function (){var statearr_47338 = state_47262;
(statearr_47338[(4)] = cljs.core.rest((state_47262[(4)])));

return statearr_47338;
})();
var state_47262__$1 = state_47262;
var ex47335 = (state_47262__$1[(2)]);
var statearr_47339_47434 = state_47262__$1;
(statearr_47339_47434[(5)] = ex47335);


if((ex47335 instanceof Error)){
var statearr_47340_47435 = state_47262__$1;
(statearr_47340_47435[(1)] = (4));

(statearr_47340_47435[(5)] = null);

} else {
throw ex47335;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (14))){
var inst_47035 = (state_47262[(13)]);
var inst_47039 = (state_47262[(15)]);
var inst_47098 = (function (){var G__47341 = cljs.core.cst$kw$bind;
var G__47342 = inst_47035;
return (inst_47039.cljs$core$IFn$_invoke$arity$2 ? inst_47039.cljs$core$IFn$_invoke$arity$2(G__47341,G__47342) : inst_47039.call(null,G__47341,G__47342));
})();
var state_47262__$1 = state_47262;
if(cljs.core.truth_(inst_47098)){
var statearr_47343_47436 = state_47262__$1;
(statearr_47343_47436[(1)] = (25));

} else {
var statearr_47344_47437 = state_47262__$1;
(statearr_47344_47437[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (45))){
var inst_47172 = cljs.core.count(clause);
var inst_47173 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_47172);
var state_47262__$1 = state_47262;
if(inst_47173){
var statearr_47345_47438 = state_47262__$1;
(statearr_47345_47438[(1)] = (48));

} else {
var statearr_47346_47439 = state_47262__$1;
(statearr_47346_47439[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (53))){
var inst_47247 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47347_47440 = state_47262__$1;
(statearr_47347_47440[(2)] = inst_47247);

(statearr_47347_47440[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (26))){
var inst_47035 = (state_47262[(13)]);
var inst_47039 = (state_47262[(15)]);
var inst_47110 = (function (){var G__47348 = cljs.core.cst$kw$filter;
var G__47349 = inst_47035;
return (inst_47039.cljs$core$IFn$_invoke$arity$2 ? inst_47039.cljs$core$IFn$_invoke$arity$2(G__47348,G__47349) : inst_47039.call(null,G__47348,G__47349));
})();
var state_47262__$1 = state_47262;
if(cljs.core.truth_(inst_47110)){
var statearr_47350_47441 = state_47262__$1;
(statearr_47350_47441[(1)] = (28));

} else {
var statearr_47351_47442 = state_47262__$1;
(statearr_47351_47442[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (16))){
var inst_47064 = (state_47262[(10)]);
var inst_47071 = (state_47262[(18)]);
var inst_47070 = cljs.core.seq(inst_47064);
var inst_47071__$1 = cljs.core.first(inst_47070);
var inst_47072 = cljs.core.next(inst_47070);
var state_47262__$1 = (function (){var statearr_47352 = state_47262;
(statearr_47352[(16)] = inst_47072);

(statearr_47352[(18)] = inst_47071__$1);

return statearr_47352;
})();
if(cljs.core.truth_(inst_47071__$1)){
var statearr_47353_47443 = state_47262__$1;
(statearr_47353_47443[(1)] = (18));

} else {
var statearr_47354_47444 = state_47262__$1;
(statearr_47354_47444[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (38))){
var inst_47145 = (state_47262[(23)]);
var state_47262__$1 = state_47262;
var statearr_47355_47445 = state_47262__$1;
(statearr_47355_47445[(2)] = inst_47145);

(statearr_47355_47445[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (30))){
var inst_47122 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47356_47446 = state_47262__$1;
(statearr_47356_47446[(2)] = inst_47122);

(statearr_47356_47446[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (10))){
var inst_47035 = (state_47262[(13)]);
var inst_47039 = (state_47262[(15)]);
var inst_47051 = (function (){var G__47357 = cljs.core.cst$kw$union;
var G__47358 = inst_47035;
return (inst_47039.cljs$core$IFn$_invoke$arity$2 ? inst_47039.cljs$core$IFn$_invoke$arity$2(G__47357,G__47358) : inst_47039.call(null,G__47357,G__47358));
})();
var state_47262__$1 = state_47262;
if(cljs.core.truth_(inst_47051)){
var statearr_47359_47447 = state_47262__$1;
(statearr_47359_47447[(1)] = (13));

} else {
var statearr_47360_47448 = state_47262__$1;
(statearr_47360_47448[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (18))){
var inst_47071 = (state_47262[(18)]);
var inst_47074 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_47071,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_47071,q_map,vars,fuel,max_fuel,opts));
var state_47262__$1 = state_47262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47262__$1,(21),inst_47074);
} else {
if((state_val_47263 === (52))){
var state_47262__$1 = state_47262;
var statearr_47361_47449 = state_47262__$1;
(statearr_47361_47449[(1)] = (57));



return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (67))){
var inst_47240 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47363_47450 = state_47262__$1;
(statearr_47363_47450[(2)] = inst_47240);

(statearr_47363_47450[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (71))){
var inst_47229 = (state_47262[(24)]);
var inst_47232 = (state_47262[(2)]);
var inst_47233 = fluree.db.util.async.throw_err(inst_47232);
var inst_47234 = [inst_47233,r];
var inst_47235 = (new cljs.core.PersistentVector(null,2,(5),inst_47229,inst_47234,null));
var state_47262__$1 = state_47262;
var statearr_47364_47451 = state_47262__$1;
(statearr_47364_47451[(2)] = inst_47235);

(statearr_47364_47451[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (42))){
var inst_47253 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47365_47452 = state_47262__$1;
(statearr_47365_47452[(2)] = inst_47253);

(statearr_47365_47452[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (37))){
var inst_47147 = cljs.core.second(clause);
var inst_47148 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47147,"rdf:type");
var state_47262__$1 = state_47262;
var statearr_47366_47453 = state_47262__$1;
(statearr_47366_47453[(2)] = inst_47148);

(statearr_47366_47453[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (63))){
var inst_47242 = (state_47262[(2)]);
var state_47262__$1 = state_47262;
var statearr_47367_47454 = state_47262__$1;
(statearr_47367_47454[(2)] = inst_47242);

(statearr_47367_47454[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (8))){
var inst_47257 = (state_47262[(2)]);
var _ = (function (){var statearr_47368 = state_47262;
(statearr_47368[(4)] = cljs.core.rest((state_47262[(4)])));

return statearr_47368;
})();
var state_47262__$1 = state_47262;
var statearr_47369_47455 = state_47262__$1;
(statearr_47369_47455[(2)] = inst_47257);

(statearr_47369_47455[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47263 === (49))){
var inst_47181 = cljs.core.count(clause);
var inst_47182 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_47181);
var state_47262__$1 = state_47262;
if(inst_47182){
var statearr_47370_47456 = state_47262__$1;
(statearr_47370_47456[(1)] = (51));

} else {
var statearr_47371_47457 = state_47262__$1;
(statearr_47371_47457[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto____0 = (function (){
var statearr_47372 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47372[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto__);

(statearr_47372[(1)] = (1));

return statearr_47372;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto____1 = (function (state_47262){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_47262);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e47373){var ex__24301__auto__ = e47373;
var statearr_47374_47458 = state_47262;
(statearr_47374_47458[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_47262[(4)]))){
var statearr_47375_47459 = state_47262;
(statearr_47375_47459[(1)] = cljs.core.first((state_47262[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__47460 = state_47262;
state_47262 = G__47460;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto__ = function(state_47262){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto____1.call(this,state_47262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_47376 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_47376[(6)] = c__24424__auto__);

return statearr_47376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__47462 = arguments.length;
switch (G__47462) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_47542){
var state_val_47543 = (state_47542[(1)]);
if((state_val_47543 === (7))){
var inst_47537 = (state_47542[(2)]);
var _ = (function (){var statearr_47544 = state_47542;
(statearr_47544[(4)] = cljs.core.rest((state_47542[(4)])));

return statearr_47544;
})();
var state_47542__$1 = state_47542;
var statearr_47545_47593 = state_47542__$1;
(statearr_47545_47593[(2)] = inst_47537);

(statearr_47545_47593[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (20))){
var inst_47502 = (state_47542[(7)]);
var inst_47514 = (state_47542[(2)]);
var inst_47484 = inst_47502;
var inst_47485 = inst_47514;
var state_47542__$1 = (function (){var statearr_47546 = state_47542;
(statearr_47546[(8)] = inst_47485);

(statearr_47546[(9)] = inst_47484);

return statearr_47546;
})();
var statearr_47547_47594 = state_47542__$1;
(statearr_47547_47594[(2)] = null);

(statearr_47547_47594[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (1))){
var state_47542__$1 = state_47542;
var statearr_47548_47595 = state_47542__$1;
(statearr_47548_47595[(2)] = null);

(statearr_47548_47595[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (24))){
var inst_47485 = (state_47542[(8)]);
var inst_47502 = (state_47542[(7)]);
var inst_47501 = (state_47542[(10)]);
var inst_47522 = fluree.db.query.analytical.inner_join(inst_47485,inst_47501);
var inst_47484 = inst_47502;
var inst_47485__$1 = inst_47522;
var state_47542__$1 = (function (){var statearr_47549 = state_47542;
(statearr_47549[(8)] = inst_47485__$1);

(statearr_47549[(9)] = inst_47484);

return statearr_47549;
})();
var statearr_47550_47596 = state_47542__$1;
(statearr_47550_47596[(2)] = null);

(statearr_47550_47596[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (4))){
var inst_47463 = (state_47542[(2)]);
var state_47542__$1 = state_47542;
var statearr_47552_47597 = state_47542__$1;
(statearr_47552_47597[(2)] = inst_47463);

(statearr_47552_47597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (15))){
var inst_47501 = (state_47542[(10)]);
var state_47542__$1 = state_47542;
if(cljs.core.truth_(inst_47501)){
var statearr_47553_47598 = state_47542__$1;
(statearr_47553_47598[(1)] = (18));

} else {
var statearr_47554_47599 = state_47542__$1;
(statearr_47554_47599[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (21))){
var inst_47485 = (state_47542[(8)]);
var inst_47502 = (state_47542[(7)]);
var tmp47551 = inst_47485;
var inst_47484 = inst_47502;
var inst_47485__$1 = tmp47551;
var state_47542__$1 = (function (){var statearr_47555 = state_47542;
(statearr_47555[(8)] = inst_47485__$1);

(statearr_47555[(9)] = inst_47484);

return statearr_47555;
})();
var statearr_47556_47600 = state_47542__$1;
(statearr_47556_47600[(2)] = null);

(statearr_47556_47600[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (13))){
var inst_47485 = (state_47542[(8)]);
var inst_47508 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_47485,cljs.core.cst$kw$vars);
var inst_47509 = cljs.core.empty_QMARK_(inst_47508);
var state_47542__$1 = state_47542;
if(inst_47509){
var statearr_47557_47601 = state_47542__$1;
(statearr_47557_47601[(1)] = (15));

} else {
var statearr_47558_47602 = state_47542__$1;
(statearr_47558_47602[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (22))){
var state_47542__$1 = state_47542;
var statearr_47559_47603 = state_47542__$1;
(statearr_47559_47603[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (6))){
var inst_47491 = (state_47542[(11)]);
var inst_47484 = (state_47542[(9)]);
var inst_47490 = cljs.core.seq(inst_47484);
var inst_47491__$1 = cljs.core.first(inst_47490);
var inst_47492 = cljs.core.next(inst_47490);
var state_47542__$1 = (function (){var statearr_47561 = state_47542;
(statearr_47561[(12)] = inst_47492);

(statearr_47561[(11)] = inst_47491__$1);

return statearr_47561;
})();
if(cljs.core.truth_(inst_47491__$1)){
var statearr_47562_47604 = state_47542__$1;
(statearr_47562_47604[(1)] = (8));

} else {
var statearr_47563_47605 = state_47542__$1;
(statearr_47563_47605[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (25))){
var state_47542__$1 = state_47542;
var statearr_47564_47606 = state_47542__$1;
(statearr_47564_47606[(2)] = null);

(statearr_47564_47606[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (17))){
var inst_47530 = (state_47542[(2)]);
var state_47542__$1 = state_47542;
var statearr_47565_47607 = state_47542__$1;
(statearr_47565_47607[(2)] = inst_47530);

(statearr_47565_47607[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (3))){
var inst_47540 = (state_47542[(2)]);
var state_47542__$1 = state_47542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47542__$1,inst_47540);
} else {
if((state_val_47543 === (12))){
var inst_47502 = (state_47542[(7)]);
var inst_47501 = (state_47542[(10)]);
var inst_47484 = inst_47502;
var inst_47485 = inst_47501;
var state_47542__$1 = (function (){var statearr_47566 = state_47542;
(statearr_47566[(8)] = inst_47485);

(statearr_47566[(9)] = inst_47484);

return statearr_47566;
})();
var statearr_47567_47608 = state_47542__$1;
(statearr_47567_47608[(2)] = null);

(statearr_47567_47608[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (2))){
var _ = (function (){var statearr_47568 = state_47542;
(statearr_47568[(4)] = cljs.core.cons((5),(state_47542[(4)])));

return statearr_47568;
})();
var inst_47476 = where;
var inst_47477 = cljs.core.seq(inst_47476);
var inst_47478 = cljs.core.first(inst_47477);
var inst_47479 = cljs.core.next(inst_47477);
var inst_47480 = [cljs.core.cst$kw$vars];
var inst_47481 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_47482 = [inst_47481];
var inst_47483 = cljs.core.PersistentHashMap.fromArrays(inst_47480,inst_47482);
var inst_47484 = inst_47476;
var inst_47485 = inst_47483;
var state_47542__$1 = (function (){var statearr_47569 = state_47542;
(statearr_47569[(13)] = inst_47479);

(statearr_47569[(8)] = inst_47485);

(statearr_47569[(14)] = inst_47478);

(statearr_47569[(9)] = inst_47484);

return statearr_47569;
})();
var statearr_47570_47609 = state_47542__$1;
(statearr_47570_47609[(2)] = null);

(statearr_47570_47609[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (23))){
var inst_47528 = (state_47542[(2)]);
var state_47542__$1 = state_47542;
var statearr_47571_47610 = state_47542__$1;
(statearr_47571_47610[(2)] = inst_47528);

(statearr_47571_47610[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (19))){
var inst_47485 = (state_47542[(8)]);
var state_47542__$1 = state_47542;
var statearr_47572_47611 = state_47542__$1;
(statearr_47572_47611[(2)] = inst_47485);

(statearr_47572_47611[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (11))){
var inst_47491 = (state_47542[(11)]);
var inst_47499 = (state_47542[(2)]);
var inst_47500 = fluree.db.util.async.throw_err(inst_47499);
var inst_47501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47500,(0),null);
var inst_47502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47500,(1),null);
var inst_47503 = cljs.core.count(inst_47491);
var inst_47504 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_47503);
var state_47542__$1 = (function (){var statearr_47574 = state_47542;
(statearr_47574[(7)] = inst_47502);

(statearr_47574[(10)] = inst_47501);

return statearr_47574;
})();
if(inst_47504){
var statearr_47575_47612 = state_47542__$1;
(statearr_47575_47612[(1)] = (12));

} else {
var statearr_47576_47613 = state_47542__$1;
(statearr_47576_47613[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (9))){
var inst_47485 = (state_47542[(8)]);
var state_47542__$1 = state_47542;
var statearr_47577_47614 = state_47542__$1;
(statearr_47577_47614[(2)] = inst_47485);

(statearr_47577_47614[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (5))){
var _ = (function (){var statearr_47578 = state_47542;
(statearr_47578[(4)] = cljs.core.rest((state_47542[(4)])));

return statearr_47578;
})();
var state_47542__$1 = state_47542;
var ex47573 = (state_47542__$1[(2)]);
var statearr_47579_47615 = state_47542__$1;
(statearr_47579_47615[(5)] = ex47573);


if((ex47573 instanceof Error)){
var statearr_47580_47616 = state_47542__$1;
(statearr_47580_47616[(1)] = (4));

(statearr_47580_47616[(5)] = null);

} else {
throw ex47573;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (14))){
var inst_47532 = (state_47542[(2)]);
var state_47542__$1 = state_47542;
var statearr_47581_47617 = state_47542__$1;
(statearr_47581_47617[(2)] = inst_47532);

(statearr_47581_47617[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (26))){
var inst_47526 = (state_47542[(2)]);
var state_47542__$1 = state_47542;
var statearr_47582_47618 = state_47542__$1;
(statearr_47582_47618[(2)] = inst_47526);

(statearr_47582_47618[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (16))){
var inst_47501 = (state_47542[(10)]);
var inst_47517 = (inst_47501 == null);
var state_47542__$1 = state_47542;
if(cljs.core.truth_(inst_47517)){
var statearr_47583_47619 = state_47542__$1;
(statearr_47583_47619[(1)] = (21));

} else {
var statearr_47584_47620 = state_47542__$1;
(statearr_47584_47620[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (10))){
var inst_47535 = (state_47542[(2)]);
var state_47542__$1 = state_47542;
var statearr_47585_47621 = state_47542__$1;
(statearr_47585_47621[(2)] = inst_47535);

(statearr_47585_47621[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (18))){
var inst_47501 = (state_47542[(10)]);
var state_47542__$1 = state_47542;
var statearr_47586_47622 = state_47542__$1;
(statearr_47586_47622[(2)] = inst_47501);

(statearr_47586_47622[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47543 === (8))){
var inst_47492 = (state_47542[(12)]);
var inst_47485 = (state_47542[(8)]);
var inst_47491 = (state_47542[(11)]);
var inst_47497 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_47485,inst_47491,inst_47492,false,fuel,max_fuel,opts);
var state_47542__$1 = state_47542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47542__$1,(11),inst_47497);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__24298__auto__ = null;
var fluree$db$query$analytical$state_machine__24298__auto____0 = (function (){
var statearr_47587 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47587[(0)] = fluree$db$query$analytical$state_machine__24298__auto__);

(statearr_47587[(1)] = (1));

return statearr_47587;
});
var fluree$db$query$analytical$state_machine__24298__auto____1 = (function (state_47542){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_47542);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e47588){var ex__24301__auto__ = e47588;
var statearr_47589_47623 = state_47542;
(statearr_47589_47623[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_47542[(4)]))){
var statearr_47590_47624 = state_47542;
(statearr_47590_47624[(1)] = cljs.core.first((state_47542[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__47625 = state_47542;
state_47542 = G__47625;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__24298__auto__ = function(state_47542){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__24298__auto____1.call(this,state_47542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__24298__auto____0;
fluree$db$query$analytical$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__24298__auto____1;
return fluree$db$query$analytical$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_47591 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_47591[(6)] = c__24424__auto__);

return statearr_47591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_47660){
var state_val_47661 = (state_47660[(1)]);
if((state_val_47661 === (7))){
var inst_47637 = (state_47660[(7)]);
var inst_47642 = (state_47660[(8)]);
var inst_47644 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_47637,inst_47642,fuel,max_fuel,opts);
var state_47660__$1 = state_47660;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47660__$1,(10),inst_47644);
} else {
if((state_val_47661 === (1))){
var state_47660__$1 = state_47660;
var statearr_47662_47687 = state_47660__$1;
(statearr_47662_47687[(2)] = null);

(statearr_47662_47687[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47661 === (4))){
var inst_47626 = (state_47660[(2)]);
var state_47660__$1 = state_47660;
var statearr_47663_47688 = state_47660__$1;
(statearr_47663_47688[(2)] = inst_47626);

(statearr_47663_47688[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47661 === (13))){
var inst_47655 = (state_47660[(2)]);
var _ = (function (){var statearr_47664 = state_47660;
(statearr_47664[(4)] = cljs.core.rest((state_47660[(4)])));

return statearr_47664;
})();
var state_47660__$1 = state_47660;
var statearr_47665_47689 = state_47660__$1;
(statearr_47665_47689[(2)] = inst_47655);

(statearr_47665_47689[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47661 === (6))){
var inst_47637 = (state_47660[(7)]);
var inst_47641 = (state_47660[(2)]);
var inst_47642 = fluree.db.util.async.throw_err(inst_47641);
var state_47660__$1 = (function (){var statearr_47666 = state_47660;
(statearr_47666[(8)] = inst_47642);

return statearr_47666;
})();
if(cljs.core.truth_(inst_47637)){
var statearr_47667_47690 = state_47660__$1;
(statearr_47667_47690[(1)] = (7));

} else {
var statearr_47668_47691 = state_47660__$1;
(statearr_47668_47691[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47661 === (3))){
var inst_47658 = (state_47660[(2)]);
var state_47660__$1 = state_47660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47660__$1,inst_47658);
} else {
if((state_val_47661 === (12))){
var inst_47650 = (state_47660[(9)]);
var state_47660__$1 = state_47660;
var statearr_47669_47692 = state_47660__$1;
(statearr_47669_47692[(2)] = inst_47650);

(statearr_47669_47692[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47661 === (2))){
var _ = (function (){var statearr_47670 = state_47660;
(statearr_47670[(4)] = cljs.core.cons((5),(state_47660[(4)])));

return statearr_47670;
})();
var inst_47633 = q_map;
var inst_47634 = cljs.core.__destructure_map(inst_47633);
var inst_47635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47634,cljs.core.cst$kw$vars);
var inst_47636 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47634,cljs.core.cst$kw$where);
var inst_47637 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47634,cljs.core.cst$kw$optional);
var inst_47638 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47634,cljs.core.cst$kw$filter);
var inst_47639 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_47636,q_map,inst_47635,fuel,max_fuel,opts);
var state_47660__$1 = (function (){var statearr_47671 = state_47660;
(statearr_47671[(7)] = inst_47637);

(statearr_47671[(10)] = inst_47638);

return statearr_47671;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47660__$1,(6),inst_47639);
} else {
if((state_val_47661 === (11))){
var inst_47650 = (state_47660[(9)]);
var inst_47638 = (state_47660[(10)]);
var inst_47652 = fluree.db.query.analytical.tuples__GT_filtered(inst_47650,inst_47638,null);
var state_47660__$1 = state_47660;
var statearr_47673_47693 = state_47660__$1;
(statearr_47673_47693[(2)] = inst_47652);

(statearr_47673_47693[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47661 === (9))){
var inst_47638 = (state_47660[(10)]);
var inst_47650 = (state_47660[(2)]);
var state_47660__$1 = (function (){var statearr_47674 = state_47660;
(statearr_47674[(9)] = inst_47650);

return statearr_47674;
})();
if(cljs.core.truth_(inst_47638)){
var statearr_47675_47694 = state_47660__$1;
(statearr_47675_47694[(1)] = (11));

} else {
var statearr_47676_47695 = state_47660__$1;
(statearr_47676_47695[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47661 === (5))){
var _ = (function (){var statearr_47677 = state_47660;
(statearr_47677[(4)] = cljs.core.rest((state_47660[(4)])));

return statearr_47677;
})();
var state_47660__$1 = state_47660;
var ex47672 = (state_47660__$1[(2)]);
var statearr_47678_47696 = state_47660__$1;
(statearr_47678_47696[(5)] = ex47672);


if((ex47672 instanceof Error)){
var statearr_47679_47697 = state_47660__$1;
(statearr_47679_47697[(1)] = (4));

(statearr_47679_47697[(5)] = null);

} else {
throw ex47672;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47661 === (10))){
var inst_47646 = (state_47660[(2)]);
var inst_47647 = fluree.db.util.async.throw_err(inst_47646);
var state_47660__$1 = state_47660;
var statearr_47680_47698 = state_47660__$1;
(statearr_47680_47698[(2)] = inst_47647);

(statearr_47680_47698[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47661 === (8))){
var inst_47642 = (state_47660[(8)]);
var state_47660__$1 = state_47660;
var statearr_47681_47699 = state_47660__$1;
(statearr_47681_47699[(2)] = inst_47642);

(statearr_47681_47699[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__24298__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__24298__auto____0 = (function (){
var statearr_47682 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47682[(0)] = fluree$db$query$analytical$q_$_state_machine__24298__auto__);

(statearr_47682[(1)] = (1));

return statearr_47682;
});
var fluree$db$query$analytical$q_$_state_machine__24298__auto____1 = (function (state_47660){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_47660);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e47683){var ex__24301__auto__ = e47683;
var statearr_47684_47700 = state_47660;
(statearr_47684_47700[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_47660[(4)]))){
var statearr_47685_47701 = state_47660;
(statearr_47685_47701[(1)] = cljs.core.first((state_47660[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__47702 = state_47660;
state_47660 = G__47702;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__24298__auto__ = function(state_47660){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__24298__auto____1.call(this,state_47660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__24298__auto____0;
fluree$db$query$analytical$q_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__24298__auto____1;
return fluree$db$query$analytical$q_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_47686 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_47686[(6)] = c__24424__auto__);

return statearr_47686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
