// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__44537 = arguments.length;
switch (G__44537) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__44540 = arguments.length;
switch (G__44540) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__24424__auto___44593 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_44571){
var state_val_44572 = (state_44571[(1)]);
if((state_val_44572 === (1))){
var state_44571__$1 = state_44571;
var statearr_44573_44594 = state_44571__$1;
(statearr_44573_44594[(2)] = null);

(statearr_44573_44594[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44572 === (2))){
var _ = (function (){var statearr_44574 = state_44571;
(statearr_44574[(4)] = cljs.core.cons((5),(state_44571[(4)])));

return statearr_44574;
})();
var inst_44548 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_44571__$1 = state_44571;
if(cljs.core.truth_(inst_44548)){
var statearr_44575_44595 = state_44571__$1;
(statearr_44575_44595[(1)] = (6));

} else {
var statearr_44576_44596 = state_44571__$1;
(statearr_44576_44596[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44572 === (3))){
var inst_44569 = (state_44571[(2)]);
var state_44571__$1 = state_44571;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44571__$1,inst_44569);
} else {
if((state_val_44572 === (4))){
var inst_44541 = (state_44571[(2)]);
var inst_44542 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_44541);
var state_44571__$1 = state_44571;
var statearr_44578_44597 = state_44571__$1;
(statearr_44578_44597[(2)] = inst_44542);

(statearr_44578_44597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44572 === (5))){
var _ = (function (){var statearr_44579 = state_44571;
(statearr_44579[(4)] = cljs.core.rest((state_44571[(4)])));

return statearr_44579;
})();
var state_44571__$1 = state_44571;
var ex44577 = (state_44571__$1[(2)]);
var statearr_44580_44598 = state_44571__$1;
(statearr_44580_44598[(5)] = ex44577);


var statearr_44581_44599 = state_44571__$1;
(statearr_44581_44599[(1)] = (4));

(statearr_44581_44599[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44572 === (6))){
var inst_44550 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_44551 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_44552 = cljs.core.PersistentHashMap.fromArrays(inst_44550,inst_44551);
var inst_44553 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_44552);
var inst_44554 = (function(){throw inst_44553})();
var state_44571__$1 = state_44571;
var statearr_44582_44600 = state_44571__$1;
(statearr_44582_44600[(2)] = inst_44554);

(statearr_44582_44600[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44572 === (7))){
var inst_44556 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_44557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44558 = [operation,data,pc,opts];
var inst_44559 = (new cljs.core.PersistentVector(null,4,(5),inst_44557,inst_44558,null));
var inst_44560 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_44556,inst_44559);
var inst_44561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44562 = [operation,data,pc,opts];
var inst_44563 = (new cljs.core.PersistentVector(null,4,(5),inst_44561,inst_44562,null));
var inst_44564 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_44563], 0));
var state_44571__$1 = (function (){var statearr_44583 = state_44571;
(statearr_44583[(7)] = inst_44560);

return statearr_44583;
})();
var statearr_44584_44601 = state_44571__$1;
(statearr_44584_44601[(2)] = inst_44564);

(statearr_44584_44601[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44572 === (8))){
var inst_44566 = (state_44571[(2)]);
var _ = (function (){var statearr_44585 = state_44571;
(statearr_44585[(4)] = cljs.core.rest((state_44571[(4)])));

return statearr_44585;
})();
var state_44571__$1 = state_44571;
var statearr_44586_44602 = state_44571__$1;
(statearr_44586_44602[(2)] = inst_44566);

(statearr_44586_44602[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__24298__auto__ = null;
var fluree$db$operations$state_machine__24298__auto____0 = (function (){
var statearr_44587 = [null,null,null,null,null,null,null,null];
(statearr_44587[(0)] = fluree$db$operations$state_machine__24298__auto__);

(statearr_44587[(1)] = (1));

return statearr_44587;
});
var fluree$db$operations$state_machine__24298__auto____1 = (function (state_44571){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_44571);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e44588){var ex__24301__auto__ = e44588;
var statearr_44589_44603 = state_44571;
(statearr_44589_44603[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_44571[(4)]))){
var statearr_44590_44604 = state_44571;
(statearr_44590_44604[(1)] = cljs.core.first((state_44571[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__44605 = state_44571;
state_44571 = G__44605;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$operations$state_machine__24298__auto__ = function(state_44571){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__24298__auto____1.call(this,state_44571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__24298__auto____0;
fluree$db$operations$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__24298__auto____1;
return fluree$db$operations$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_44591 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_44591[(6)] = c__24424__auto___44593);

return statearr_44591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__44607 = arguments.length;
switch (G__44607) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__44608){
var map__44609 = p__44608;
var map__44609__$1 = cljs.core.__destructure_map(map__44609);
var opts = map__44609__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44609__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__44610 = session;
var map__44610__$1 = cljs.core.__destructure_map(map__44610);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44610__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44610__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44610__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44637 = arguments.length;
var i__4819__auto___44638 = (0);
while(true){
if((i__4819__auto___44638 < len__4818__auto___44637)){
args__4824__auto__.push((arguments[i__4819__auto___44638]));

var G__44639 = (i__4819__auto___44638 + (1));
i__4819__auto___44638 = G__44639;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__44614){
var vec__44615 = p__44614;
var map__44618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44615,(0),null);
var map__44618__$1 = cljs.core.__destructure_map(map__44618);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44618__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44618__$1,cljs.core.cst$kw$toTime);
var opts = vec__44615;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_44630){
var state_val_44631 = (state_44630[(1)]);
if((state_val_44631 === (1))){
var inst_44620 = session;
var inst_44621 = cljs.core.__destructure_map(inst_44620);
var inst_44622 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44621,cljs.core.cst$kw$network);
var inst_44623 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44621,cljs.core.cst$kw$dbid);
var inst_44624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44621,cljs.core.cst$kw$conn);
var inst_44625 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_44626 = [inst_44622,inst_44623,toBlock,toTime];
var inst_44627 = cljs.core.PersistentHashMap.fromArrays(inst_44625,inst_44626);
var inst_44628 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_44624,cljs.core.cst$kw$garbage,inst_44627);
var state_44630__$1 = state_44630;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44630__$1,inst_44628);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__24298__auto__ = null;
var fluree$db$operations$state_machine__24298__auto____0 = (function (){
var statearr_44632 = [null,null,null,null,null,null,null];
(statearr_44632[(0)] = fluree$db$operations$state_machine__24298__auto__);

(statearr_44632[(1)] = (1));

return statearr_44632;
});
var fluree$db$operations$state_machine__24298__auto____1 = (function (state_44630){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_44630);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e44633){var ex__24301__auto__ = e44633;
var statearr_44634_44640 = state_44630;
(statearr_44634_44640[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_44630[(4)]))){
var statearr_44635_44641 = state_44630;
(statearr_44635_44641[(1)] = cljs.core.first((state_44630[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__44642 = state_44630;
state_44630 = G__44642;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$operations$state_machine__24298__auto__ = function(state_44630){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__24298__auto____1.call(this,state_44630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__24298__auto____0;
fluree$db$operations$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__24298__auto____1;
return fluree$db$operations$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_44636 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_44636[(6)] = c__24424__auto__);

return statearr_44636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq44612){
var G__44613 = cljs.core.first(seq44612);
var seq44612__$1 = cljs.core.next(seq44612);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44613,seq44612__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__44643 = session;
var map__44643__$1 = cljs.core.__destructure_map(map__44643);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44643__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44643__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44643__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__44645 = arguments.length;
switch (G__44645) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__44646 = opts;
var map__44646__$1 = cljs.core.__destructure_map(map__44646);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44646__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44646__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4212__auto__ = auth;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
