// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k42745,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__42749 = k42745;
var G__42749__$1 = (((G__42749 instanceof cljs.core.Keyword))?G__42749.fqn:null);
switch (G__42749__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k42745,else__4464__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__42750){
var vec__42751 = p__42750;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42751,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42751,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__42744){
var self__ = this;
var G__42744__$1 = this;
return (new cljs.core.RecordIter((0),G__42744__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__42754 = (function (coll__4458__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__42754(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this42746,other42747){
var self__ = this;
var this42746__$1 = this;
return (((!((other42747 == null)))) && ((((this42746__$1.constructor === other42747.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42746__$1.index_type,other42747.index_type)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42746__$1.comparator,other42747.comparator)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42746__$1.historyComparator,other42747.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42746__$1.__extmap,other42747.__extmap)))))))))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k42745){
var self__ = this;
var this__4468__auto____$1 = this;
var G__42755 = k42745;
var G__42755__$1 = (((G__42755 instanceof cljs.core.Keyword))?G__42755.fqn:null);
switch (G__42755__$1) {
case "index-type":
case "comparator":
case "historyComparator":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k42745);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__42744){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__42756 = cljs.core.keyword_identical_QMARK_;
var expr__42757 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__42759 = cljs.core.cst$kw$index_DASH_type;
var G__42760 = expr__42757;
return (pred__42756.cljs$core$IFn$_invoke$arity$2 ? pred__42756.cljs$core$IFn$_invoke$arity$2(G__42759,G__42760) : pred__42756.call(null,G__42759,G__42760));
})())){
return (new fluree.db.index.IndexConfig(G__42744,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42761 = cljs.core.cst$kw$comparator;
var G__42762 = expr__42757;
return (pred__42756.cljs$core$IFn$_invoke$arity$2 ? pred__42756.cljs$core$IFn$_invoke$arity$2(G__42761,G__42762) : pred__42756.call(null,G__42761,G__42762));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__42744,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42763 = cljs.core.cst$kw$historyComparator;
var G__42764 = expr__42757;
return (pred__42756.cljs$core$IFn$_invoke$arity$2 ? pred__42756.cljs$core$IFn$_invoke$arity$2(G__42763,G__42764) : pred__42756.call(null,G__42763,G__42764));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__42744,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__42744),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__42744){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__42744,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__42748){
var extmap__4501__auto__ = (function (){var G__42765 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__42748,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__42748)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__42765);
} else {
return G__42765;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__42748),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__42748),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__42748),null,cljs.core.not_empty(extmap__4501__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k42769,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__42773 = k42769;
var G__42773__$1 = (((G__42773 instanceof cljs.core.Keyword))?G__42773.fqn:null);
switch (G__42773__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k42769,else__4464__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__42774){
var vec__42775 = p__42774;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42775,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42775,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__42768){
var self__ = this;
var G__42768__$1 = this;
return (new cljs.core.RecordIter((0),G__42768__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_42779){
var state_val_42780 = (state_42779[(1)]);
if((state_val_42780 === (1))){
var state_42779__$1 = state_42779;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42779__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__24298__auto__ = null;
var fluree$db$index$state_machine__24298__auto____0 = (function (){
var statearr_42781 = [null,null,null,null,null,null,null];
(statearr_42781[(0)] = fluree$db$index$state_machine__24298__auto__);

(statearr_42781[(1)] = (1));

return statearr_42781;
});
var fluree$db$index$state_machine__24298__auto____1 = (function (state_42779){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_42779);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e42782){var ex__24301__auto__ = e42782;
var statearr_42783_42895 = state_42779;
(statearr_42783_42895[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_42779[(4)]))){
var statearr_42784_42896 = state_42779;
(statearr_42784_42896[(1)] = cljs.core.first((state_42779[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__42897 = state_42779;
state_42779 = G__42897;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$index$state_machine__24298__auto__ = function(state_42779){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__24298__auto____1.call(this,state_42779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__24298__auto____0;
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__24298__auto____1;
return fluree$db$index$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_42785 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_42785[(6)] = c__24424__auto__);

return statearr_42785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4212__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4212__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_42810){
var state_val_42811 = (state_42810[(1)]);
if((state_val_42811 === (7))){
var inst_42792 = (state_42810[(7)]);
var inst_42796 = fluree.db.dbproto._resolve(inst_42792);
var state_42810__$1 = state_42810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42810__$1,(10),inst_42796);
} else {
if((state_val_42811 === (1))){
var state_42810__$1 = state_42810;
var statearr_42812_42898 = state_42810__$1;
(statearr_42812_42898[(2)] = null);

(statearr_42812_42898[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42811 === (4))){
var inst_42786 = (state_42810[(2)]);
var state_42810__$1 = state_42810;
var statearr_42813_42899 = state_42810__$1;
(statearr_42813_42899[(2)] = inst_42786);

(statearr_42813_42899[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42811 === (6))){
var inst_42792 = (state_42810[(7)]);
var state_42810__$1 = state_42810;
var statearr_42814_42900 = state_42810__$1;
(statearr_42814_42900[(2)] = inst_42792);

(statearr_42814_42900[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42811 === (3))){
var inst_42808 = (state_42810[(2)]);
var state_42810__$1 = state_42810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42810__$1,inst_42808);
} else {
if((state_val_42811 === (2))){
var inst_42792 = (state_42810[(7)]);
var _ = (function (){var statearr_42816 = state_42810;
(statearr_42816[(4)] = cljs.core.cons((5),(state_42810[(4)])));

return statearr_42816;
})();
var inst_42792__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_42793 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_42792__$1);
var state_42810__$1 = (function (){var statearr_42817 = state_42810;
(statearr_42817[(7)] = inst_42792__$1);

return statearr_42817;
})();
if(cljs.core.truth_(inst_42793)){
var statearr_42818_42901 = state_42810__$1;
(statearr_42818_42901[(1)] = (6));

} else {
var statearr_42819_42902 = state_42810__$1;
(statearr_42819_42902[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42811 === (9))){
var inst_42802 = (state_42810[(2)]);
var inst_42803 = fluree.db.util.async.throw_err(inst_42802);
var state_42810__$1 = state_42810;
var statearr_42820_42903 = state_42810__$1;
(statearr_42820_42903[(2)] = inst_42803);

(statearr_42820_42903[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42811 === (5))){
var _ = (function (){var statearr_42821 = state_42810;
(statearr_42821[(4)] = cljs.core.rest((state_42810[(4)])));

return statearr_42821;
})();
var state_42810__$1 = state_42810;
var ex42815 = (state_42810__$1[(2)]);
var statearr_42822_42904 = state_42810__$1;
(statearr_42822_42904[(5)] = ex42815);


if((ex42815 instanceof Error)){
var statearr_42823_42905 = state_42810__$1;
(statearr_42823_42905[(1)] = (4));

(statearr_42823_42905[(5)] = null);

} else {
throw ex42815;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42811 === (10))){
var inst_42798 = (state_42810[(2)]);
var inst_42799 = fluree.db.util.async.throw_err(inst_42798);
var inst_42800 = fluree.db.dbproto._lookup_leaf(inst_42799,flake);
var state_42810__$1 = state_42810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42810__$1,(9),inst_42800);
} else {
if((state_val_42811 === (8))){
var inst_42805 = (state_42810[(2)]);
var _ = (function (){var statearr_42824 = state_42810;
(statearr_42824[(4)] = cljs.core.rest((state_42810[(4)])));

return statearr_42824;
})();
var state_42810__$1 = state_42810;
var statearr_42825_42906 = state_42810__$1;
(statearr_42825_42906[(2)] = inst_42805);

(statearr_42825_42906[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__24298__auto__ = null;
var fluree$db$index$state_machine__24298__auto____0 = (function (){
var statearr_42826 = [null,null,null,null,null,null,null,null];
(statearr_42826[(0)] = fluree$db$index$state_machine__24298__auto__);

(statearr_42826[(1)] = (1));

return statearr_42826;
});
var fluree$db$index$state_machine__24298__auto____1 = (function (state_42810){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_42810);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e42827){var ex__24301__auto__ = e42827;
var statearr_42828_42907 = state_42810;
(statearr_42828_42907[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_42810[(4)]))){
var statearr_42829_42908 = state_42810;
(statearr_42829_42908[(1)] = cljs.core.first((state_42810[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__42909 = state_42810;
state_42810 = G__42909;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$index$state_machine__24298__auto__ = function(state_42810){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__24298__auto____1.call(this,state_42810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__24298__auto____0;
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__24298__auto____1;
return fluree$db$index$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_42830 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_42830[(6)] = c__24424__auto__);

return statearr_42830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_42855){
var state_val_42856 = (state_42855[(1)]);
if((state_val_42856 === (7))){
var inst_42837 = (state_42855[(7)]);
var inst_42841 = fluree.db.dbproto._resolve(inst_42837);
var state_42855__$1 = state_42855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42855__$1,(10),inst_42841);
} else {
if((state_val_42856 === (1))){
var state_42855__$1 = state_42855;
var statearr_42857_42910 = state_42855__$1;
(statearr_42857_42910[(2)] = null);

(statearr_42857_42910[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42856 === (4))){
var inst_42831 = (state_42855[(2)]);
var state_42855__$1 = state_42855;
var statearr_42858_42911 = state_42855__$1;
(statearr_42858_42911[(2)] = inst_42831);

(statearr_42858_42911[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42856 === (6))){
var inst_42837 = (state_42855[(7)]);
var state_42855__$1 = state_42855;
var statearr_42859_42912 = state_42855__$1;
(statearr_42859_42912[(2)] = inst_42837);

(statearr_42859_42912[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42856 === (3))){
var inst_42853 = (state_42855[(2)]);
var state_42855__$1 = state_42855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42855__$1,inst_42853);
} else {
if((state_val_42856 === (2))){
var inst_42837 = (state_42855[(7)]);
var _ = (function (){var statearr_42861 = state_42855;
(statearr_42861[(4)] = cljs.core.cons((5),(state_42855[(4)])));

return statearr_42861;
})();
var inst_42837__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_42838 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_42837__$1);
var state_42855__$1 = (function (){var statearr_42862 = state_42855;
(statearr_42862[(7)] = inst_42837__$1);

return statearr_42862;
})();
if(cljs.core.truth_(inst_42838)){
var statearr_42863_42913 = state_42855__$1;
(statearr_42863_42913[(1)] = (6));

} else {
var statearr_42864_42914 = state_42855__$1;
(statearr_42864_42914[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42856 === (9))){
var inst_42847 = (state_42855[(2)]);
var inst_42848 = fluree.db.util.async.throw_err(inst_42847);
var state_42855__$1 = state_42855;
var statearr_42865_42915 = state_42855__$1;
(statearr_42865_42915[(2)] = inst_42848);

(statearr_42865_42915[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42856 === (5))){
var _ = (function (){var statearr_42866 = state_42855;
(statearr_42866[(4)] = cljs.core.rest((state_42855[(4)])));

return statearr_42866;
})();
var state_42855__$1 = state_42855;
var ex42860 = (state_42855__$1[(2)]);
var statearr_42867_42916 = state_42855__$1;
(statearr_42867_42916[(5)] = ex42860);


if((ex42860 instanceof Error)){
var statearr_42868_42917 = state_42855__$1;
(statearr_42868_42917[(1)] = (4));

(statearr_42868_42917[(5)] = null);

} else {
throw ex42860;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42856 === (10))){
var inst_42843 = (state_42855[(2)]);
var inst_42844 = fluree.db.util.async.throw_err(inst_42843);
var inst_42845 = fluree.db.dbproto._lookup_leaf_after(inst_42844,flake);
var state_42855__$1 = state_42855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42855__$1,(9),inst_42845);
} else {
if((state_val_42856 === (8))){
var inst_42850 = (state_42855[(2)]);
var _ = (function (){var statearr_42869 = state_42855;
(statearr_42869[(4)] = cljs.core.rest((state_42855[(4)])));

return statearr_42869;
})();
var state_42855__$1 = state_42855;
var statearr_42870_42918 = state_42855__$1;
(statearr_42870_42918[(2)] = inst_42850);

(statearr_42870_42918[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__24298__auto__ = null;
var fluree$db$index$state_machine__24298__auto____0 = (function (){
var statearr_42871 = [null,null,null,null,null,null,null,null];
(statearr_42871[(0)] = fluree$db$index$state_machine__24298__auto__);

(statearr_42871[(1)] = (1));

return statearr_42871;
});
var fluree$db$index$state_machine__24298__auto____1 = (function (state_42855){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_42855);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e42872){var ex__24301__auto__ = e42872;
var statearr_42873_42919 = state_42855;
(statearr_42873_42919[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_42855[(4)]))){
var statearr_42874_42920 = state_42855;
(statearr_42874_42920[(1)] = cljs.core.first((state_42855[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__42921 = state_42855;
state_42855 = G__42921;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$index$state_machine__24298__auto__ = function(state_42855){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__24298__auto____1.call(this,state_42855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__24298__auto____0;
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__24298__auto____1;
return fluree$db$index$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_42875 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_42875[(6)] = c__24424__auto__);

return statearr_42875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__42876 = (function (coll__4458__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__42876(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this42770,other42771){
var self__ = this;
var this42770__$1 = this;
return (((!((other42771 == null)))) && ((((this42770__$1.constructor === other42771.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42770__$1.block,other42771.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42770__$1.t,other42771.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42770__$1.rhs,other42771.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42770__$1.children,other42771.children)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42770__$1.config,other42771.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42770__$1.leftmost_QMARK_,other42771.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42770__$1.__extmap,other42771.__extmap)))))))))))))))));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k42769){
var self__ = this;
var this__4468__auto____$1 = this;
var G__42877 = k42769;
var G__42877__$1 = (((G__42877 instanceof cljs.core.Keyword))?G__42877.fqn:null);
switch (G__42877__$1) {
case "block":
case "t":
case "rhs":
case "children":
case "config":
case "leftmost?":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k42769);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__42768){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__42878 = cljs.core.keyword_identical_QMARK_;
var expr__42879 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__42881 = cljs.core.cst$kw$block;
var G__42882 = expr__42879;
return (pred__42878.cljs$core$IFn$_invoke$arity$2 ? pred__42878.cljs$core$IFn$_invoke$arity$2(G__42881,G__42882) : pred__42878.call(null,G__42881,G__42882));
})())){
return (new fluree.db.index.IndexNode(G__42768,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42883 = cljs.core.cst$kw$t;
var G__42884 = expr__42879;
return (pred__42878.cljs$core$IFn$_invoke$arity$2 ? pred__42878.cljs$core$IFn$_invoke$arity$2(G__42883,G__42884) : pred__42878.call(null,G__42883,G__42884));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__42768,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42885 = cljs.core.cst$kw$rhs;
var G__42886 = expr__42879;
return (pred__42878.cljs$core$IFn$_invoke$arity$2 ? pred__42878.cljs$core$IFn$_invoke$arity$2(G__42885,G__42886) : pred__42878.call(null,G__42885,G__42886));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__42768,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42887 = cljs.core.cst$kw$children;
var G__42888 = expr__42879;
return (pred__42878.cljs$core$IFn$_invoke$arity$2 ? pred__42878.cljs$core$IFn$_invoke$arity$2(G__42887,G__42888) : pred__42878.call(null,G__42887,G__42888));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__42768,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42889 = cljs.core.cst$kw$config;
var G__42890 = expr__42879;
return (pred__42878.cljs$core$IFn$_invoke$arity$2 ? pred__42878.cljs$core$IFn$_invoke$arity$2(G__42889,G__42890) : pred__42878.call(null,G__42889,G__42890));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__42768,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42891 = cljs.core.cst$kw$leftmost_QMARK_;
var G__42892 = expr__42879;
return (pred__42878.cljs$core$IFn$_invoke$arity$2 ? pred__42878.cljs$core$IFn$_invoke$arity$2(G__42891,G__42892) : pred__42878.call(null,G__42891,G__42892));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__42768,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__42768),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__42768){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__42768,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__42772){
var extmap__4501__auto__ = (function (){var G__42893 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__42772,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__42772)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__42893);
} else {
return G__42893;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__42772),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__42772),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__42772),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__42772),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__42772),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__42772),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k42924,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__42928 = k42924;
var G__42928__$1 = (((G__42928 instanceof cljs.core.Keyword))?G__42928.fqn:null);
switch (G__42928__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k42924,else__4464__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__42929){
var vec__42930 = p__42929;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42930,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42930,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__42923){
var self__ = this;
var G__42923__$1 = this;
return (new cljs.core.RecordIter((0),G__42923__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_42934){
var state_val_42935 = (state_42934[(1)]);
if((state_val_42935 === (1))){
var state_42934__$1 = state_42934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42934__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__24298__auto__ = null;
var fluree$db$index$state_machine__24298__auto____0 = (function (){
var statearr_42936 = [null,null,null,null,null,null,null];
(statearr_42936[(0)] = fluree$db$index$state_machine__24298__auto__);

(statearr_42936[(1)] = (1));

return statearr_42936;
});
var fluree$db$index$state_machine__24298__auto____1 = (function (state_42934){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_42934);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e42937){var ex__24301__auto__ = e42937;
var statearr_42938_42970 = state_42934;
(statearr_42938_42970[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_42934[(4)]))){
var statearr_42939_42971 = state_42934;
(statearr_42939_42971[(1)] = cljs.core.first((state_42934[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__42972 = state_42934;
state_42934 = G__42972;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$index$state_machine__24298__auto__ = function(state_42934){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__24298__auto____1.call(this,state_42934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__24298__auto____0;
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__24298__auto____1;
return fluree$db$index$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_42940 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_42940[(6)] = c__24424__auto__);

return statearr_42940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_42946){
var state_val_42947 = (state_42946[(1)]);
if((state_val_42947 === (1))){
var inst_42941 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42942 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_42943 = cljs.core.PersistentHashMap.fromArrays(inst_42941,inst_42942);
var inst_42944 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_42943);
var state_42946__$1 = state_42946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42946__$1,inst_42944);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__24298__auto__ = null;
var fluree$db$index$state_machine__24298__auto____0 = (function (){
var statearr_42948 = [null,null,null,null,null,null,null];
(statearr_42948[(0)] = fluree$db$index$state_machine__24298__auto__);

(statearr_42948[(1)] = (1));

return statearr_42948;
});
var fluree$db$index$state_machine__24298__auto____1 = (function (state_42946){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_42946);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e42949){var ex__24301__auto__ = e42949;
var statearr_42950_42973 = state_42946;
(statearr_42950_42973[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_42946[(4)]))){
var statearr_42951_42974 = state_42946;
(statearr_42951_42974[(1)] = cljs.core.first((state_42946[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__42975 = state_42946;
state_42946 = G__42975;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$index$state_machine__24298__auto__ = function(state_42946){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__24298__auto____1.call(this,state_42946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__24298__auto____0;
fluree$db$index$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__24298__auto____1;
return fluree$db$index$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_42952 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_42952[(6)] = c__24424__auto__);

return statearr_42952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__42953 = (function (coll__4458__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__42953(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this42925,other42926){
var self__ = this;
var this42925__$1 = this;
return (((!((other42926 == null)))) && ((((this42925__$1.constructor === other42926.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42925__$1.block,other42926.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42925__$1.t,other42926.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42925__$1.flakes,other42926.flakes)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42925__$1.rhs,other42926.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42925__$1.config,other42926.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42925__$1.__extmap,other42926.__extmap)))))))))))))));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k42924){
var self__ = this;
var this__4468__auto____$1 = this;
var G__42954 = k42924;
var G__42954__$1 = (((G__42954 instanceof cljs.core.Keyword))?G__42954.fqn:null);
switch (G__42954__$1) {
case "block":
case "t":
case "flakes":
case "rhs":
case "config":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k42924);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__42923){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__42955 = cljs.core.keyword_identical_QMARK_;
var expr__42956 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__42958 = cljs.core.cst$kw$block;
var G__42959 = expr__42956;
return (pred__42955.cljs$core$IFn$_invoke$arity$2 ? pred__42955.cljs$core$IFn$_invoke$arity$2(G__42958,G__42959) : pred__42955.call(null,G__42958,G__42959));
})())){
return (new fluree.db.index.DataNode(G__42923,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42960 = cljs.core.cst$kw$t;
var G__42961 = expr__42956;
return (pred__42955.cljs$core$IFn$_invoke$arity$2 ? pred__42955.cljs$core$IFn$_invoke$arity$2(G__42960,G__42961) : pred__42955.call(null,G__42960,G__42961));
})())){
return (new fluree.db.index.DataNode(self__.block,G__42923,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42962 = cljs.core.cst$kw$flakes;
var G__42963 = expr__42956;
return (pred__42955.cljs$core$IFn$_invoke$arity$2 ? pred__42955.cljs$core$IFn$_invoke$arity$2(G__42962,G__42963) : pred__42955.call(null,G__42962,G__42963));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__42923,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42964 = cljs.core.cst$kw$rhs;
var G__42965 = expr__42956;
return (pred__42955.cljs$core$IFn$_invoke$arity$2 ? pred__42955.cljs$core$IFn$_invoke$arity$2(G__42964,G__42965) : pred__42955.call(null,G__42964,G__42965));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__42923,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42966 = cljs.core.cst$kw$config;
var G__42967 = expr__42956;
return (pred__42955.cljs$core$IFn$_invoke$arity$2 ? pred__42955.cljs$core$IFn$_invoke$arity$2(G__42966,G__42967) : pred__42955.call(null,G__42966,G__42967));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__42923,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__42923),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__42923){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__42923,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__42927){
var extmap__4501__auto__ = (function (){var G__42968 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__42927,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__42927)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__42968);
} else {
return G__42968;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__42927),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__42927),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__42927),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__42927),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__42927),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
