// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55339 = arguments.length;
var i__4819__auto___55340 = (0);
while(true){
if((i__4819__auto___55340 < len__4818__auto___55339)){
args__4824__auto__.push((arguments[i__4819__auto___55340]));

var G__55341 = (i__4819__auto___55340 + (1));
i__4819__auto___55340 = G__55341;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq55336){
var G__55337 = cljs.core.first(seq55336);
var seq55336__$1 = cljs.core.next(seq55336);
var G__55338 = cljs.core.first(seq55336__$1);
var seq55336__$2 = cljs.core.next(seq55336__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55337,G__55338,seq55336__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e55342){var e = e55342;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e55343){var e = e55343;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e55344){var e = e55344;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e55345){var e = e55345;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e55346){var e = e55346;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55349 = arguments.length;
var i__4819__auto___55350 = (0);
while(true){
if((i__4819__auto___55350 < len__4818__auto___55349)){
args__4824__auto__.push((arguments[i__4819__auto___55350]));

var G__55351 = (i__4819__auto___55350 + (1));
i__4819__auto___55350 = G__55351;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e55348){var e = e55348;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq55347){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55347));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55354 = arguments.length;
var i__4819__auto___55355 = (0);
while(true){
if((i__4819__auto___55355 < len__4818__auto___55354)){
args__4824__auto__.push((arguments[i__4819__auto___55355]));

var G__55356 = (i__4819__auto___55355 + (1));
i__4819__auto___55355 = G__55356;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e55353){var e = e55353;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq55352){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55352));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e55357){var e = e55357;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55360 = arguments.length;
var i__4819__auto___55361 = (0);
while(true){
if((i__4819__auto___55361 < len__4818__auto___55360)){
args__4824__auto__.push((arguments[i__4819__auto___55361]));

var G__55362 = (i__4819__auto___55361 + (1));
i__4819__auto___55361 = G__55362;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e55359){var e = e55359;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq55358){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55358));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55365 = arguments.length;
var i__4819__auto___55366 = (0);
while(true){
if((i__4819__auto___55366 < len__4818__auto___55365)){
args__4824__auto__.push((arguments[i__4819__auto___55366]));

var G__55367 = (i__4819__auto___55366 + (1));
i__4819__auto___55366 = G__55367;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e55364){var e = e55364;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq55363){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55363));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e55368){var e = e55368;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e55369){var e = e55369;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55372 = arguments.length;
var i__4819__auto___55373 = (0);
while(true){
if((i__4819__auto___55373 < len__4818__auto___55372)){
args__4824__auto__.push((arguments[i__4819__auto___55373]));

var G__55374 = (i__4819__auto___55373 + (1));
i__4819__auto___55373 = G__55374;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e55371){var e = e55371;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq55370){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55370));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55377 = arguments.length;
var i__4819__auto___55378 = (0);
while(true){
if((i__4819__auto___55378 < len__4818__auto___55377)){
args__4824__auto__.push((arguments[i__4819__auto___55378]));

var G__55379 = (i__4819__auto___55378 + (1));
i__4819__auto___55378 = G__55379;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e55376){var e = e55376;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq55375){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55375));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55382 = arguments.length;
var i__4819__auto___55383 = (0);
while(true){
if((i__4819__auto___55383 < len__4818__auto___55382)){
args__4824__auto__.push((arguments[i__4819__auto___55383]));

var G__55384 = (i__4819__auto___55383 + (1));
i__4819__auto___55383 = G__55384;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e55381){var e = e55381;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq55380){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55380));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55387 = arguments.length;
var i__4819__auto___55388 = (0);
while(true){
if((i__4819__auto___55388 < len__4818__auto___55387)){
args__4824__auto__.push((arguments[i__4819__auto___55388]));

var G__55389 = (i__4819__auto___55388 + (1));
i__4819__auto___55388 = G__55389;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e55386){var e = e55386;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq55385){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55385));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55392 = arguments.length;
var i__4819__auto___55393 = (0);
while(true){
if((i__4819__auto___55393 < len__4818__auto___55392)){
args__4824__auto__.push((arguments[i__4819__auto___55393]));

var G__55394 = (i__4819__auto___55393 + (1));
i__4819__auto___55393 = G__55394;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e55391){var e = e55391;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq55390){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55390));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55397 = arguments.length;
var i__4819__auto___55398 = (0);
while(true){
if((i__4819__auto___55398 < len__4818__auto___55397)){
args__4824__auto__.push((arguments[i__4819__auto___55398]));

var G__55399 = (i__4819__auto___55398 + (1));
i__4819__auto___55398 = G__55399;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e55396){var e = e55396;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq55395){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55395));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55402 = arguments.length;
var i__4819__auto___55403 = (0);
while(true){
if((i__4819__auto___55403 < len__4818__auto___55402)){
args__4824__auto__.push((arguments[i__4819__auto___55403]));

var G__55404 = (i__4819__auto___55403 + (1));
i__4819__auto___55403 = G__55404;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e55401){var e = e55401;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq55400){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55400));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__55406 = arguments.length;
switch (G__55406) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_55434){
var state_val_55435 = (state_55434[(1)]);
if((state_val_55435 === (7))){
var inst_55419 = (state_55434[(7)]);
var inst_55422 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_55419,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_55434__$1 = state_55434;
var statearr_55436_55522 = state_55434__$1;
(statearr_55436_55522[(2)] = inst_55422);

(statearr_55436_55522[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55435 === (1))){
var state_55434__$1 = state_55434;
var statearr_55437_55523 = state_55434__$1;
(statearr_55437_55523[(2)] = null);

(statearr_55437_55523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55435 === (4))){
var inst_55407 = (state_55434[(2)]);
var state_55434__$1 = state_55434;
var statearr_55438_55524 = state_55434__$1;
(statearr_55438_55524[(2)] = inst_55407);

(statearr_55438_55524[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55435 === (6))){
var inst_55419 = (state_55434[(7)]);
var inst_55419__$1 = (state_55434[(2)]);
var inst_55420 = fluree.db.util.core.exception_QMARK_(inst_55419__$1);
var state_55434__$1 = (function (){var statearr_55439 = state_55434;
(statearr_55439[(7)] = inst_55419__$1);

return statearr_55439;
})();
if(inst_55420){
var statearr_55440_55525 = state_55434__$1;
(statearr_55440_55525[(1)] = (7));

} else {
var statearr_55441_55526 = state_55434__$1;
(statearr_55441_55526[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55435 === (3))){
var inst_55432 = (state_55434[(2)]);
var state_55434__$1 = state_55434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55434__$1,inst_55432);
} else {
if((state_val_55435 === (2))){
var inst_55413 = (state_55434[(8)]);
var _ = (function (){var statearr_55443 = state_55434;
(statearr_55443[(4)] = cljs.core.cons((5),(state_55434[(4)])));

return statearr_55443;
})();
var inst_55413__$1 = cljs.core.volatile_BANG_((0));
var inst_55414 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_55415 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_55414,cljs.core.cst$kw$fuel,inst_55413__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_55416 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_55415);
var inst_55417 = fluree.db.query.fql.query(db,inst_55416);
var state_55434__$1 = (function (){var statearr_55444 = state_55434;
(statearr_55444[(8)] = inst_55413__$1);

return statearr_55444;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55434__$1,(6),inst_55417);
} else {
if((state_val_55435 === (9))){
var inst_55429 = (state_55434[(2)]);
var _ = (function (){var statearr_55445 = state_55434;
(statearr_55445[(4)] = cljs.core.rest((state_55434[(4)])));

return statearr_55445;
})();
var state_55434__$1 = state_55434;
var statearr_55446_55527 = state_55434__$1;
(statearr_55446_55527[(2)] = inst_55429);

(statearr_55446_55527[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55435 === (5))){
var _ = (function (){var statearr_55447 = state_55434;
(statearr_55447[(4)] = cljs.core.rest((state_55434[(4)])));

return statearr_55447;
})();
var state_55434__$1 = state_55434;
var ex55442 = (state_55434__$1[(2)]);
var statearr_55448_55528 = state_55434__$1;
(statearr_55448_55528[(5)] = ex55442);


if((ex55442 instanceof Error)){
var statearr_55449_55529 = state_55434__$1;
(statearr_55449_55529[(1)] = (4));

(statearr_55449_55529[(5)] = null);

} else {
throw ex55442;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55435 === (8))){
var inst_55413 = (state_55434[(8)]);
var inst_55419 = (state_55434[(7)]);
var inst_55424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55425 = cljs.core.deref(inst_55413);
var inst_55426 = [inst_55419,inst_55425];
var inst_55427 = (new cljs.core.PersistentVector(null,2,(5),inst_55424,inst_55426,null));
var state_55434__$1 = state_55434;
var statearr_55450_55530 = state_55434__$1;
(statearr_55450_55530[(2)] = inst_55427);

(statearr_55450_55530[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__24298__auto____0 = (function (){
var statearr_55451 = [null,null,null,null,null,null,null,null,null];
(statearr_55451[(0)] = fluree$db$dbfunctions$internal$state_machine__24298__auto__);

(statearr_55451[(1)] = (1));

return statearr_55451;
});
var fluree$db$dbfunctions$internal$state_machine__24298__auto____1 = (function (state_55434){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_55434);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e55452){var ex__24301__auto__ = e55452;
var statearr_55453_55531 = state_55434;
(statearr_55453_55531[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_55434[(4)]))){
var statearr_55454_55532 = state_55434;
(statearr_55454_55532[(1)] = cljs.core.first((state_55434[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__55533 = state_55434;
state_55434 = G__55533;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__24298__auto__ = function(state_55434){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__24298__auto____1.call(this,state_55434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_55455 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_55455[(6)] = c__24424__auto__);

return statearr_55455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_55500){
var state_val_55501 = (state_55500[(1)]);
if((state_val_55501 === (7))){
var inst_55486 = (state_55500[(2)]);
var inst_55487 = fluree.db.query.fql.query(db,inst_55486);
var state_55500__$1 = state_55500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55500__$1,(8),inst_55487);
} else {
if((state_val_55501 === (1))){
var inst_55456 = typeof select === 'string';
var state_55500__$1 = state_55500;
if(cljs.core.truth_(inst_55456)){
var statearr_55502_55534 = state_55500__$1;
(statearr_55502_55534[(1)] = (2));

} else {
var statearr_55503_55535 = state_55500__$1;
(statearr_55503_55535[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55501 === (4))){
var inst_55462 = (state_55500[(7)]);
var inst_55469 = (state_55500[(8)]);
var inst_55461 = (state_55500[(2)]);
var inst_55462__$1 = cljs.core.volatile_BANG_((0));
var inst_55463 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_55464 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_55465 = [inst_55462__$1,(100000)];
var inst_55466 = cljs.core.PersistentHashMap.fromArrays(inst_55464,inst_55465);
var inst_55467 = [inst_55461,from,where,block,limit,inst_55466];
var inst_55468 = cljs.core.PersistentHashMap.fromArrays(inst_55463,inst_55467);
var inst_55469__$1 = fluree.db.util.core.without_nils(inst_55468);
var inst_55470 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_55469__$1);
var inst_55471 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_55469__$1);
var inst_55472 = cljs.core.first(inst_55471);
var inst_55473 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_55472], 0));
var inst_55474 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_55473);
var inst_55475 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_55469__$1);
var inst_55476 = cljs.core.last(inst_55475);
var inst_55477 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_55476], 0));
var inst_55478 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_55477);
var inst_55479 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_55470,inst_55474,inst_55478], 0));
var state_55500__$1 = (function (){var statearr_55504 = state_55500;
(statearr_55504[(7)] = inst_55462__$1);

(statearr_55504[(8)] = inst_55469__$1);

return statearr_55504;
})();
if(cljs.core.truth_(inst_55479)){
var statearr_55505_55536 = state_55500__$1;
(statearr_55505_55536[(1)] = (5));

} else {
var statearr_55506_55537 = state_55500__$1;
(statearr_55506_55537[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55501 === (6))){
var inst_55469 = (state_55500[(8)]);
var state_55500__$1 = state_55500;
var statearr_55507_55538 = state_55500__$1;
(statearr_55507_55538[(2)] = inst_55469);

(statearr_55507_55538[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55501 === (3))){
var state_55500__$1 = state_55500;
var statearr_55508_55539 = state_55500__$1;
(statearr_55508_55539[(2)] = select);

(statearr_55508_55539[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55501 === (2))){
var inst_55458 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_55500__$1 = state_55500;
var statearr_55509_55540 = state_55500__$1;
(statearr_55509_55540[(2)] = inst_55458);

(statearr_55509_55540[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55501 === (11))){
var inst_55498 = (state_55500[(2)]);
var state_55500__$1 = state_55500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55500__$1,inst_55498);
} else {
if((state_val_55501 === (9))){
var inst_55489 = (state_55500[(9)]);
var state_55500__$1 = state_55500;
var statearr_55510_55541 = state_55500__$1;
(statearr_55510_55541[(2)] = inst_55489);

(statearr_55510_55541[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55501 === (5))){
var inst_55469 = (state_55500[(8)]);
var inst_55481 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_55469);
var inst_55482 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_55481);
var inst_55483 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_55469,cljs.core.cst$kw$where,inst_55482);
var state_55500__$1 = state_55500;
var statearr_55511_55542 = state_55500__$1;
(statearr_55511_55542[(2)] = inst_55483);

(statearr_55511_55542[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55501 === (10))){
var inst_55462 = (state_55500[(7)]);
var inst_55489 = (state_55500[(9)]);
var inst_55493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55494 = cljs.core.deref(inst_55462);
var inst_55495 = [inst_55489,inst_55494];
var inst_55496 = (new cljs.core.PersistentVector(null,2,(5),inst_55493,inst_55495,null));
var state_55500__$1 = state_55500;
var statearr_55512_55543 = state_55500__$1;
(statearr_55512_55543[(2)] = inst_55496);

(statearr_55512_55543[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55501 === (8))){
var inst_55489 = (state_55500[(9)]);
var inst_55489__$1 = (state_55500[(2)]);
var inst_55490 = fluree.db.util.core.exception_QMARK_(inst_55489__$1);
var state_55500__$1 = (function (){var statearr_55513 = state_55500;
(statearr_55513[(9)] = inst_55489__$1);

return statearr_55513;
})();
if(inst_55490){
var statearr_55514_55544 = state_55500__$1;
(statearr_55514_55544[(1)] = (9));

} else {
var statearr_55515_55545 = state_55500__$1;
(statearr_55515_55545[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__24298__auto____0 = (function (){
var statearr_55516 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55516[(0)] = fluree$db$dbfunctions$internal$state_machine__24298__auto__);

(statearr_55516[(1)] = (1));

return statearr_55516;
});
var fluree$db$dbfunctions$internal$state_machine__24298__auto____1 = (function (state_55500){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_55500);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e55517){var ex__24301__auto__ = e55517;
var statearr_55518_55546 = state_55500;
(statearr_55518_55546[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_55500[(4)]))){
var statearr_55519_55547 = state_55500;
(statearr_55519_55547[(1)] = cljs.core.first((state_55500[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__55548 = state_55500;
state_55500 = G__55548;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__24298__auto__ = function(state_55500){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__24298__auto____1.call(this,state_55500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_55520 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_55520[(6)] = c__24424__auto__);

return statearr_55520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__55552 = path;
var vec__55553 = G__55552;
var seq__55554 = cljs.core.seq(vec__55553);
var first__55555 = cljs.core.first(seq__55554);
var seq__55554__$1 = cljs.core.next(seq__55554);
var var$ = first__55555;
var r = seq__55554__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__55552__$1 = G__55552;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__55559 = G__55552__$1;
var seq__55560 = cljs.core.seq(vec__55559);
var first__55561 = cljs.core.first(seq__55560);
var seq__55560__$1 = cljs.core.next(seq__55560);
var var$__$1 = first__55561;
var r__$1 = seq__55560__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__55562 = r__$1;
var G__55563 = n__$2;
var G__55564 = next_clauses;
G__55552__$1 = G__55562;
n__$1 = G__55563;
where_clauses__$1 = G__55564;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__55565 = r__$1;
var G__55566 = next_n;
var G__55567 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__55552__$1 = G__55565;
n__$1 = G__55566;
where_clauses__$1 = G__55567;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_55604){
var state_val_55605 = (state_55604[(1)]);
if((state_val_55605 === (7))){
var inst_55577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55578 = [path];
var inst_55579 = (new cljs.core.PersistentVector(null,1,(5),inst_55577,inst_55578,null));
var state_55604__$1 = state_55604;
var statearr_55606_55634 = state_55604__$1;
(statearr_55606_55634[(2)] = inst_55579);

(statearr_55606_55634[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (1))){
var state_55604__$1 = state_55604;
var statearr_55607_55635 = state_55604__$1;
(statearr_55607_55635[(2)] = null);

(statearr_55607_55635[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (4))){
var inst_55568 = (state_55604[(2)]);
var state_55604__$1 = state_55604;
var statearr_55608_55636 = state_55604__$1;
(statearr_55608_55636[(2)] = inst_55568);

(statearr_55608_55636[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (13))){
var inst_55595 = (state_55604[(2)]);
var inst_55596 = fluree.db.util.async.throw_err(inst_55595);
var _ = (function (){var statearr_55609 = state_55604;
(statearr_55609[(4)] = cljs.core.rest((state_55604[(4)])));

return statearr_55609;
})();
var state_55604__$1 = state_55604;
var statearr_55610_55637 = state_55604__$1;
(statearr_55610_55637[(2)] = inst_55596);

(statearr_55610_55637[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (6))){
var state_55604__$1 = state_55604;
var statearr_55612_55638 = state_55604__$1;
(statearr_55612_55638[(2)] = path);

(statearr_55612_55638[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (3))){
var inst_55602 = (state_55604[(2)]);
var state_55604__$1 = state_55604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55604__$1,inst_55602);
} else {
if((state_val_55605 === (12))){
var _ = (function (){var statearr_55613 = state_55604;
(statearr_55613[(4)] = cljs.core.rest((state_55604[(4)])));

return statearr_55613;
})();
var state_55604__$1 = state_55604;
var ex55611 = (state_55604__$1[(2)]);
var statearr_55614_55639 = state_55604__$1;
(statearr_55614_55639[(5)] = ex55611);


var statearr_55615_55640 = state_55604__$1;
(statearr_55615_55640[(1)] = (11));

(statearr_55615_55640[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (2))){
var _ = (function (){var statearr_55616 = state_55604;
(statearr_55616[(4)] = cljs.core.cons((5),(state_55604[(4)])));

return statearr_55616;
})();
var inst_55574 = cljs.core.vector_QMARK_(path);
var state_55604__$1 = state_55604;
if(inst_55574){
var statearr_55617_55641 = state_55604__$1;
(statearr_55617_55641[(1)] = (6));

} else {
var statearr_55618_55642 = state_55604__$1;
(statearr_55618_55642[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (11))){
var inst_55581 = (state_55604[(7)]);
var inst_55586 = (state_55604[(2)]);
var inst_55587 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_55586,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_55581,endSubject], 0));
var state_55604__$1 = state_55604;
var statearr_55620_55643 = state_55604__$1;
(statearr_55620_55643[(2)] = inst_55587);

(statearr_55620_55643[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (9))){
var inst_55585 = (state_55604[(8)]);
var _ = (function (){var statearr_55621 = state_55604;
(statearr_55621[(4)] = cljs.core.cons((12),(state_55604[(4)])));

return statearr_55621;
})();
var inst_55593 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_55585);
var state_55604__$1 = state_55604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55604__$1,(13),inst_55593);
} else {
if((state_val_55605 === (5))){
var _ = (function (){var statearr_55622 = state_55604;
(statearr_55622[(4)] = cljs.core.rest((state_55604[(4)])));

return statearr_55622;
})();
var state_55604__$1 = state_55604;
var ex55619 = (state_55604__$1[(2)]);
var statearr_55623_55644 = state_55604__$1;
(statearr_55623_55644[(5)] = ex55619);


if((ex55619 instanceof Error)){
var statearr_55624_55645 = state_55604__$1;
(statearr_55624_55645[(1)] = (4));

(statearr_55624_55645[(5)] = null);

} else {
throw ex55619;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (10))){
var inst_55599 = (state_55604[(2)]);
var _ = (function (){var statearr_55625 = state_55604;
(statearr_55625[(4)] = cljs.core.rest((state_55604[(4)])));

return statearr_55625;
})();
var state_55604__$1 = state_55604;
var statearr_55626_55646 = state_55604__$1;
(statearr_55626_55646[(2)] = inst_55599);

(statearr_55626_55646[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55605 === (8))){
var inst_55581 = (state_55604[(7)]);
var inst_55581__$1 = (state_55604[(2)]);
var inst_55582 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_55581__$1,endSubject);
var inst_55583 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_55584 = ["?var1",inst_55582];
var inst_55585 = cljs.core.PersistentHashMap.fromArrays(inst_55583,inst_55584);
var state_55604__$1 = (function (){var statearr_55627 = state_55604;
(statearr_55627[(8)] = inst_55585);

(statearr_55627[(7)] = inst_55581__$1);

return statearr_55627;
})();
var statearr_55628_55647 = state_55604__$1;
(statearr_55628_55647[(2)] = null);

(statearr_55628_55647[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto____0 = (function (){
var statearr_55629 = [null,null,null,null,null,null,null,null,null];
(statearr_55629[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto__);

(statearr_55629[(1)] = (1));

return statearr_55629;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto____1 = (function (state_55604){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_55604);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e55630){var ex__24301__auto__ = e55630;
var statearr_55631_55648 = state_55604;
(statearr_55631_55648[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_55604[(4)]))){
var statearr_55632_55649 = state_55604;
(statearr_55632_55649[(1)] = cljs.core.first((state_55604[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__55650 = state_55604;
state_55604 = G__55650;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto__ = function(state_55604){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto____1.call(this,state_55604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_55633 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_55633[(6)] = c__24424__auto__);

return statearr_55633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e55651){var e = e55651;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e55652){var e = e55652;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e55653){var e = e55653;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e55654){var e = e55654;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55657 = arguments.length;
var i__4819__auto___55658 = (0);
while(true){
if((i__4819__auto___55658 < len__4818__auto___55657)){
args__4824__auto__.push((arguments[i__4819__auto___55658]));

var G__55659 = (i__4819__auto___55658 + (1));
i__4819__auto___55658 = G__55659;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e55656){var e = e55656;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq55655){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55655));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55662 = arguments.length;
var i__4819__auto___55663 = (0);
while(true){
if((i__4819__auto___55663 < len__4818__auto___55662)){
args__4824__auto__.push((arguments[i__4819__auto___55663]));

var G__55664 = (i__4819__auto___55663 + (1));
i__4819__auto___55663 = G__55664;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e55661){var e = e55661;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq55660){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55660));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55667 = arguments.length;
var i__4819__auto___55668 = (0);
while(true){
if((i__4819__auto___55668 < len__4818__auto___55667)){
args__4824__auto__.push((arguments[i__4819__auto___55668]));

var G__55669 = (i__4819__auto___55668 + (1));
i__4819__auto___55668 = G__55669;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4212__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e55666){var e = e55666;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq55665){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55665));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55672 = arguments.length;
var i__4819__auto___55673 = (0);
while(true){
if((i__4819__auto___55673 < len__4818__auto___55672)){
args__4824__auto__.push((arguments[i__4819__auto___55673]));

var G__55674 = (i__4819__auto___55673 + (1));
i__4819__auto___55673 = G__55674;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e55671){var e = e55671;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq55670){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55670));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e55675){var e = e55675;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e55676){var e = e55676;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e55677){var e = e55677;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e55678){var e = e55678;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e55679){var e = e55679;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__55685 = path;
var vec__55686 = G__55685;
var seq__55687 = cljs.core.seq(vec__55686);
var first__55688 = cljs.core.first(seq__55687);
var seq__55687__$1 = cljs.core.next(seq__55687);
var pred = first__55688;
var r = seq__55687__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__55685__$1 = G__55685;
var subjects__$1 = subjects;
while(true){
var vec__55692 = G__55685__$1;
var seq__55693 = cljs.core.seq(vec__55692);
var first__55694 = cljs.core.first(seq__55693);
var seq__55693__$1 = cljs.core.next(seq__55693);
var pred__$1 = first__55694;
var r__$1 = seq__55693__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__55685__$1,subjects__$1,vec__55692,seq__55693,first__55694,seq__55693__$1,pred__$1,r__$1,subjects__$2,G__55685,vec__55686,seq__55687,first__55688,seq__55687__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__55685__$1,subjects__$1,vec__55692,seq__55693,first__55694,seq__55693__$1,pred__$1,r__$1,subjects__$2,G__55685,vec__55686,seq__55687,first__55688,seq__55687__$1,pred,r,subjects){
return (function (p1__55680_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__55680_SHARP_,pred__$1);
});})(G__55685__$1,subjects__$1,vec__55692,seq__55693,first__55694,seq__55693__$1,pred__$1,r__$1,subjects__$2,G__55685,vec__55686,seq__55687,first__55688,seq__55687__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__55685__$1,subjects__$1,vec__55692,seq__55693,first__55694,seq__55693__$1,pred__$1,r__$1,subjects__$2,G__55685,vec__55686,seq__55687,first__55688,seq__55687__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4210__auto__ = r__$1;
if(and__4210__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4210__auto__;
}
})())){
var G__55695 = r__$1;
var G__55696 = next_subjects;
G__55685__$1 = G__55695;
subjects__$1 = G__55696;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e55681){var e = e55681;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e55697){var e = e55697;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e55698){var e = e55698;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55701 = arguments.length;
var i__4819__auto___55702 = (0);
while(true){
if((i__4819__auto___55702 < len__4818__auto___55701)){
args__4824__auto__.push((arguments[i__4819__auto___55702]));

var G__55703 = (i__4819__auto___55702 + (1));
i__4819__auto___55702 = G__55703;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e55700){var e = e55700;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq55699){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55699));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e55704){var e = e55704;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55707 = arguments.length;
var i__4819__auto___55708 = (0);
while(true){
if((i__4819__auto___55708 < len__4818__auto___55707)){
args__4824__auto__.push((arguments[i__4819__auto___55708]));

var G__55709 = (i__4819__auto___55708 + (1));
i__4819__auto___55708 = G__55709;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e55706){var e = e55706;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq55705){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55705));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e55710){var e = e55710;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_55767){
var state_val_55768 = (state_55767[(1)]);
if((state_val_55768 === (7))){
var inst_55713 = (state_55767[(2)]);
var state_55767__$1 = state_55767;
var statearr_55769_55803 = state_55767__$1;
(statearr_55769_55803[(2)] = inst_55713);

(statearr_55769_55803[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (1))){
var state_55767__$1 = state_55767;
var statearr_55770_55804 = state_55767__$1;
(statearr_55770_55804[(2)] = null);

(statearr_55770_55804[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (4))){
var inst_55712 = (state_55767[(2)]);
var state_55767__$1 = (function (){var statearr_55771 = state_55767;
(statearr_55771[(7)] = inst_55712);

return statearr_55771;
})();
var statearr_55772_55805 = state_55767__$1;
(statearr_55772_55805[(2)] = null);

(statearr_55772_55805[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (15))){
var inst_55737 = (state_55767[(8)]);
var inst_55750 = (state_55767[(9)]);
var inst_55735 = (state_55767[(10)]);
var inst_55738 = (state_55767[(11)]);
var inst_55747 = (state_55767[(12)]);
var inst_55748 = (state_55767[(13)]);
var inst_55754 = (function (){var db = inst_55735;
var prevT = inst_55737;
var db_SINGLEQUOTE_ = inst_55738;
var prev_vals = inst_55747;
var fuel = inst_55748;
var G__55749 = inst_55750;
return (function (p1__55711_SHARP_){
var f = p1__55711_SHARP_;
return f.o;
});
})();
var inst_55755 = (inst_55754.cljs$core$IFn$_invoke$arity$1 ? inst_55754.cljs$core$IFn$_invoke$arity$1(inst_55750) : inst_55754.call(null,inst_55750));
var state_55767__$1 = state_55767;
var statearr_55773_55806 = state_55767__$1;
(statearr_55773_55806[(2)] = inst_55755);

(statearr_55773_55806[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (13))){
var inst_55750 = (state_55767[(9)]);
var inst_55747 = (state_55767[(12)]);
var inst_55746 = (state_55767[(2)]);
var inst_55747__$1 = fluree.db.util.async.throw_err(inst_55746);
var inst_55748 = fluree.db.dbfunctions.internal.count(inst_55747__$1);
var inst_55750__$1 = cljs.core.first(inst_55747__$1);
var inst_55751 = (inst_55750__$1 == null);
var state_55767__$1 = (function (){var statearr_55774 = state_55767;
(statearr_55774[(9)] = inst_55750__$1);

(statearr_55774[(12)] = inst_55747__$1);

(statearr_55774[(13)] = inst_55748);

return statearr_55774;
})();
if(cljs.core.truth_(inst_55751)){
var statearr_55775_55807 = state_55767__$1;
(statearr_55775_55807[(1)] = (14));

} else {
var statearr_55776_55808 = state_55767__$1;
(statearr_55776_55808[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (6))){
var inst_55722 = (state_55767[(2)]);
var state_55767__$1 = state_55767;
var statearr_55777_55809 = state_55767__$1;
(statearr_55777_55809[(2)] = inst_55722);

(statearr_55777_55809[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (3))){
var inst_55765 = (state_55767[(2)]);
var state_55767__$1 = state_55767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55767__$1,inst_55765);
} else {
if((state_val_55768 === (12))){
var inst_55762 = (state_55767[(2)]);
var _ = (function (){var statearr_55778 = state_55767;
(statearr_55778[(4)] = cljs.core.rest((state_55767[(4)])));

return statearr_55778;
})();
var state_55767__$1 = state_55767;
var statearr_55779_55810 = state_55767__$1;
(statearr_55779_55810[(2)] = inst_55762);

(statearr_55779_55810[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (2))){
var _ = (function (){var statearr_55781 = state_55767;
(statearr_55781[(4)] = cljs.core.cons((9),(state_55767[(4)])));

return statearr_55781;
})();
var inst_55728 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55729 = typeof inst_55728 === 'string';
var state_55767__$1 = state_55767;
if(cljs.core.truth_(inst_55729)){
var statearr_55782_55811 = state_55767__$1;
(statearr_55782_55811[(1)] = (10));

} else {
var statearr_55783_55812 = state_55767__$1;
(statearr_55783_55812[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (11))){
var inst_55737 = (state_55767[(8)]);
var inst_55735 = (state_55767[(10)]);
var inst_55738 = (state_55767[(11)]);
var inst_55735__$1 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55736 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_55735__$1);
var inst_55737__$1 = fluree.db.dbfunctions.internal.inc(inst_55736);
var inst_55738__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_55735__$1,cljs.core.cst$kw$t,inst_55737__$1);
var inst_55739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55740 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55741 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55742 = [inst_55740,inst_55741];
var inst_55743 = (new cljs.core.PersistentVector(null,2,(5),inst_55739,inst_55742,null));
var inst_55744 = fluree.db.dbproto._search(inst_55738__$1,inst_55743);
var state_55767__$1 = (function (){var statearr_55784 = state_55767;
(statearr_55784[(8)] = inst_55737__$1);

(statearr_55784[(10)] = inst_55735__$1);

(statearr_55784[(11)] = inst_55738__$1);

return statearr_55784;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55767__$1,(13),inst_55744);
} else {
if((state_val_55768 === (9))){
var _ = (function (){var statearr_55785 = state_55767;
(statearr_55785[(4)] = cljs.core.rest((state_55767[(4)])));

return statearr_55785;
})();
var state_55767__$1 = state_55767;
var ex55780 = (state_55767__$1[(2)]);
var statearr_55786_55813 = state_55767__$1;
(statearr_55786_55813[(5)] = ex55780);


var statearr_55787_55814 = state_55767__$1;
(statearr_55787_55814[(1)] = (4));

(statearr_55787_55814[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (5))){
var inst_55712 = (state_55767[(7)]);
var _ = (function (){var statearr_55788 = state_55767;
(statearr_55788[(4)] = cljs.core.cons((8),(state_55767[(4)])));

return statearr_55788;
})();
var inst_55719 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_55712,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_55789 = state_55767;
(statearr_55789[(4)] = cljs.core.rest((state_55767[(4)])));

return statearr_55789;
})();
var state_55767__$1 = state_55767;
var statearr_55790_55815 = state_55767__$1;
(statearr_55790_55815[(2)] = inst_55719);

(statearr_55790_55815[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (14))){
var state_55767__$1 = state_55767;
var statearr_55791_55816 = state_55767__$1;
(statearr_55791_55816[(2)] = null);

(statearr_55791_55816[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (16))){
var inst_55748 = (state_55767[(13)]);
var inst_55757 = (state_55767[(2)]);
var inst_55758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55759 = [inst_55757,inst_55748];
var inst_55760 = (new cljs.core.PersistentVector(null,2,(5),inst_55758,inst_55759,null));
var state_55767__$1 = state_55767;
var statearr_55793_55817 = state_55767__$1;
(statearr_55793_55817[(2)] = inst_55760);

(statearr_55793_55817[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (10))){
var inst_55731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55732 = [null,(0)];
var inst_55733 = (new cljs.core.PersistentVector(null,2,(5),inst_55731,inst_55732,null));
var state_55767__$1 = state_55767;
var statearr_55794_55818 = state_55767__$1;
(statearr_55794_55818[(2)] = inst_55733);

(statearr_55794_55818[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55768 === (8))){
var _ = (function (){var statearr_55795 = state_55767;
(statearr_55795[(4)] = cljs.core.rest((state_55767[(4)])));

return statearr_55795;
})();
var state_55767__$1 = state_55767;
var ex55792 = (state_55767__$1[(2)]);
var statearr_55796_55819 = state_55767__$1;
(statearr_55796_55819[(5)] = ex55792);


var statearr_55797_55820 = state_55767__$1;
(statearr_55797_55820[(1)] = (7));

(statearr_55797_55820[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto____0 = (function (){
var statearr_55798 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55798[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto__);

(statearr_55798[(1)] = (1));

return statearr_55798;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto____1 = (function (state_55767){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_55767);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e55799){var ex__24301__auto__ = e55799;
var statearr_55800_55821 = state_55767;
(statearr_55800_55821[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_55767[(4)]))){
var statearr_55801_55822 = state_55767;
(statearr_55801_55822[(1)] = cljs.core.first((state_55767[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__55823 = state_55767;
state_55767 = G__55823;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto__ = function(state_55767){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto____1.call(this,state_55767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_55802 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_55802[(6)] = c__24424__auto__);

return statearr_55802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_55875){
var state_val_55876 = (state_55875[(1)]);
if((state_val_55876 === (7))){
var inst_55825 = (state_55875[(2)]);
var state_55875__$1 = state_55875;
var statearr_55877_55906 = state_55875__$1;
(statearr_55877_55906[(2)] = inst_55825);

(statearr_55877_55906[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (1))){
var state_55875__$1 = state_55875;
var statearr_55878_55907 = state_55875__$1;
(statearr_55878_55907[(2)] = null);

(statearr_55878_55907[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (4))){
var inst_55824 = (state_55875[(2)]);
var state_55875__$1 = (function (){var statearr_55879 = state_55875;
(statearr_55879[(7)] = inst_55824);

return statearr_55879;
})();
var statearr_55880_55908 = state_55875__$1;
(statearr_55880_55908[(2)] = null);

(statearr_55880_55908[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (13))){
var inst_55870 = (state_55875[(2)]);
var _ = (function (){var statearr_55881 = state_55875;
(statearr_55881[(4)] = cljs.core.rest((state_55875[(4)])));

return statearr_55881;
})();
var state_55875__$1 = state_55875;
var statearr_55882_55909 = state_55875__$1;
(statearr_55882_55909[(2)] = inst_55870);

(statearr_55882_55909[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (6))){
var inst_55834 = (state_55875[(2)]);
var state_55875__$1 = state_55875;
var statearr_55883_55910 = state_55875__$1;
(statearr_55883_55910[(2)] = inst_55834);

(statearr_55883_55910[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (3))){
var inst_55873 = (state_55875[(2)]);
var state_55875__$1 = state_55875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55875__$1,inst_55873);
} else {
if((state_val_55876 === (12))){
var inst_55857 = (state_55875[(8)]);
var inst_55866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55867 = [null,inst_55857];
var inst_55868 = (new cljs.core.PersistentVector(null,2,(5),inst_55866,inst_55867,null));
var state_55875__$1 = state_55875;
var statearr_55884_55911 = state_55875__$1;
(statearr_55884_55911[(2)] = inst_55868);

(statearr_55884_55911[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (2))){
var _ = (function (){var statearr_55886 = state_55875;
(statearr_55886[(4)] = cljs.core.cons((9),(state_55875[(4)])));

return statearr_55886;
})();
var inst_55843 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_55844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55846 = [null,pred_name,"?o"];
var inst_55847 = (new cljs.core.PersistentVector(null,3,(5),inst_55845,inst_55846,null));
var inst_55848 = [inst_55847];
var inst_55849 = (new cljs.core.PersistentVector(null,1,(5),inst_55844,inst_55848,null));
var inst_55850 = ["?o",inst_55849,opts];
var inst_55851 = cljs.core.PersistentHashMap.fromArrays(inst_55843,inst_55850);
var inst_55852 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_55851);
var state_55875__$1 = state_55875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55875__$1,(10),inst_55852);
} else {
if((state_val_55876 === (11))){
var inst_55857 = (state_55875[(8)]);
var inst_55856 = (state_55875[(9)]);
var inst_55861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55862 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_55856);
var inst_55863 = [inst_55862,inst_55857];
var inst_55864 = (new cljs.core.PersistentVector(null,2,(5),inst_55861,inst_55863,null));
var state_55875__$1 = state_55875;
var statearr_55887_55912 = state_55875__$1;
(statearr_55887_55912[(2)] = inst_55864);

(statearr_55887_55912[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (9))){
var _ = (function (){var statearr_55888 = state_55875;
(statearr_55888[(4)] = cljs.core.rest((state_55875[(4)])));

return statearr_55888;
})();
var state_55875__$1 = state_55875;
var ex55885 = (state_55875__$1[(2)]);
var statearr_55889_55913 = state_55875__$1;
(statearr_55889_55913[(5)] = ex55885);


var statearr_55890_55914 = state_55875__$1;
(statearr_55890_55914[(1)] = (4));

(statearr_55890_55914[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (5))){
var inst_55824 = (state_55875[(7)]);
var _ = (function (){var statearr_55892 = state_55875;
(statearr_55892[(4)] = cljs.core.cons((8),(state_55875[(4)])));

return statearr_55892;
})();
var inst_55831 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_55824,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_55893 = state_55875;
(statearr_55893[(4)] = cljs.core.rest((state_55875[(4)])));

return statearr_55893;
})();
var state_55875__$1 = state_55875;
var statearr_55894_55915 = state_55875__$1;
(statearr_55894_55915[(2)] = inst_55831);

(statearr_55894_55915[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (10))){
var inst_55856 = (state_55875[(9)]);
var inst_55854 = (state_55875[(2)]);
var inst_55855 = fluree.db.util.async.throw_err(inst_55854);
var inst_55856__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55855,(0),null);
var inst_55857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55855,(1),null);
var inst_55858 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_55856__$1);
var inst_55859 = cljs.core.not(inst_55858);
var state_55875__$1 = (function (){var statearr_55895 = state_55875;
(statearr_55895[(8)] = inst_55857);

(statearr_55895[(9)] = inst_55856__$1);

return statearr_55895;
})();
if(inst_55859){
var statearr_55896_55916 = state_55875__$1;
(statearr_55896_55916[(1)] = (11));

} else {
var statearr_55897_55917 = state_55875__$1;
(statearr_55897_55917[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55876 === (8))){
var _ = (function (){var statearr_55898 = state_55875;
(statearr_55898[(4)] = cljs.core.rest((state_55875[(4)])));

return statearr_55898;
})();
var state_55875__$1 = state_55875;
var ex55891 = (state_55875__$1[(2)]);
var statearr_55899_55918 = state_55875__$1;
(statearr_55899_55918[(5)] = ex55891);


var statearr_55900_55919 = state_55875__$1;
(statearr_55900_55919[(1)] = (7));

(statearr_55900_55919[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto____0 = (function (){
var statearr_55901 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55901[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto__);

(statearr_55901[(1)] = (1));

return statearr_55901;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto____1 = (function (state_55875){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_55875);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e55902){var ex__24301__auto__ = e55902;
var statearr_55903_55920 = state_55875;
(statearr_55903_55920[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_55875[(4)]))){
var statearr_55904_55921 = state_55875;
(statearr_55904_55921[(1)] = cljs.core.first((state_55875[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__55922 = state_55875;
state_55875 = G__55922;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto__ = function(state_55875){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto____1.call(this,state_55875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_55905 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_55905[(6)] = c__24424__auto__);

return statearr_55905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4210__auto__ = typeof email === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4210__auto__;
}
})());
}catch (e55923){var e = e55923;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__55925 = arguments.length;
switch (G__55925) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_55995){
var state_val_55996 = (state_55995[(1)]);
if((state_val_55996 === (7))){
var inst_55927 = (state_55995[(2)]);
var state_55995__$1 = state_55995;
var statearr_55997_56041 = state_55995__$1;
(statearr_55997_56041[(2)] = inst_55927);

(statearr_55997_56041[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (20))){
var inst_55971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55972 = ["*"];
var inst_55973 = (new cljs.core.PersistentVector(null,1,(5),inst_55971,inst_55972,null));
var state_55995__$1 = state_55995;
var statearr_55998_56042 = state_55995__$1;
(statearr_55998_56042[(2)] = inst_55973);

(statearr_55998_56042[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (1))){
var state_55995__$1 = state_55995;
var statearr_55999_56043 = state_55995__$1;
(statearr_55999_56043[(2)] = null);

(statearr_55999_56043[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (4))){
var inst_55926 = (state_55995[(2)]);
var state_55995__$1 = (function (){var statearr_56000 = state_55995;
(statearr_56000[(7)] = inst_55926);

return statearr_56000;
})();
var statearr_56001_56044 = state_55995__$1;
(statearr_56001_56044[(2)] = null);

(statearr_56001_56044[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (15))){
var inst_55990 = (state_55995[(2)]);
var _ = (function (){var statearr_56002 = state_55995;
(statearr_56002[(4)] = cljs.core.rest((state_55995[(4)])));

return statearr_56002;
})();
var state_55995__$1 = state_55995;
var statearr_56003_56045 = state_55995__$1;
(statearr_56003_56045[(2)] = inst_55990);

(statearr_56003_56045[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (21))){
var inst_55961 = (state_55995[(8)]);
var inst_55954 = (state_55995[(9)]);
var inst_55975 = (state_55995[(2)]);
var inst_55976 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_55977 = cljs.core.PersistentHashMap.EMPTY;
var inst_55978 = [inst_55975,inst_55961,inst_55977];
var inst_55979 = cljs.core.PersistentHashMap.fromArrays(inst_55976,inst_55978);
var inst_55980 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_55954,inst_55979);
var state_55995__$1 = state_55995;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55995__$1,(22),inst_55980);
} else {
if((state_val_55996 === (13))){
var inst_55949 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55995__$1 = state_55995;
var statearr_56004_56046 = state_55995__$1;
(statearr_56004_56046[(2)] = inst_55949);

(statearr_56004_56046[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (22))){
var inst_55982 = (state_55995[(2)]);
var inst_55983 = fluree.db.util.async.throw_err(inst_55982);
var inst_55984 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55983,(0),null);
var inst_55985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55983,(1),null);
var inst_55986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55987 = [inst_55984,inst_55985];
var inst_55988 = (new cljs.core.PersistentVector(null,2,(5),inst_55986,inst_55987,null));
var state_55995__$1 = state_55995;
var statearr_56005_56047 = state_55995__$1;
(statearr_56005_56047[(2)] = inst_55988);

(statearr_56005_56047[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (6))){
var inst_55936 = (state_55995[(2)]);
var state_55995__$1 = state_55995;
var statearr_56006_56048 = state_55995__$1;
(statearr_56006_56048[(2)] = inst_55936);

(statearr_56006_56048[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (17))){
var inst_55958 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55959 = fluree.db.dbfunctions.internal.get(inst_55958,cljs.core.cst$kw$_id);
var state_55995__$1 = state_55995;
var statearr_56007_56049 = state_55995__$1;
(statearr_56007_56049[(2)] = inst_55959);

(statearr_56007_56049[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (3))){
var inst_55993 = (state_55995[(2)]);
var state_55995__$1 = state_55995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55995__$1,inst_55993);
} else {
if((state_val_55996 === (12))){
var inst_55947 = (state_55995[(2)]);
var state_55995__$1 = state_55995;
if(cljs.core.truth_(inst_55947)){
var statearr_56008_56050 = state_55995__$1;
(statearr_56008_56050[(1)] = (13));

} else {
var statearr_56009_56051 = state_55995__$1;
(statearr_56009_56051[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (2))){
var inst_55942 = (state_55995[(10)]);
var _ = (function (){var statearr_56010 = state_55995;
(statearr_56010[(4)] = cljs.core.cons((9),(state_55995[(4)])));

return statearr_56010;
})();
var inst_55942__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55995__$1 = (function (){var statearr_56011 = state_55995;
(statearr_56011[(10)] = inst_55942__$1);

return statearr_56011;
})();
if(cljs.core.truth_(inst_55942__$1)){
var statearr_56012_56052 = state_55995__$1;
(statearr_56012_56052[(1)] = (10));

} else {
var statearr_56013_56053 = state_55995__$1;
(statearr_56013_56053[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (19))){
var inst_55963 = cljs.core.PersistentVector.EMPTY;
var inst_55964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55965 = ["*"];
var inst_55966 = (new cljs.core.PersistentVector(null,1,(5),inst_55964,inst_55965,null));
var inst_55967 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_55968 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_55966,inst_55967);
var inst_55969 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_55963,inst_55968);
var state_55995__$1 = state_55995;
var statearr_56015_56054 = state_55995__$1;
(statearr_56015_56054[(2)] = inst_55969);

(statearr_56015_56054[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (11))){
var inst_55942 = (state_55995[(10)]);
var state_55995__$1 = state_55995;
var statearr_56016_56055 = state_55995__$1;
(statearr_56016_56055[(2)] = inst_55942);

(statearr_56016_56055[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (9))){
var _ = (function (){var statearr_56017 = state_55995;
(statearr_56017[(4)] = cljs.core.rest((state_55995[(4)])));

return statearr_56017;
})();
var state_55995__$1 = state_55995;
var ex56014 = (state_55995__$1[(2)]);
var statearr_56018_56056 = state_55995__$1;
(statearr_56018_56056[(5)] = ex56014);


var statearr_56019_56057 = state_55995__$1;
(statearr_56019_56057[(1)] = (4));

(statearr_56019_56057[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (5))){
var inst_55926 = (state_55995[(7)]);
var _ = (function (){var statearr_56020 = state_55995;
(statearr_56020[(4)] = cljs.core.cons((8),(state_55995[(4)])));

return statearr_56020;
})();
var inst_55933 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_55926,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_56021 = state_55995;
(statearr_56021[(4)] = cljs.core.rest((state_55995[(4)])));

return statearr_56021;
})();
var state_55995__$1 = state_55995;
var statearr_56022_56058 = state_55995__$1;
(statearr_56022_56058[(2)] = inst_55933);

(statearr_56022_56058[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (14))){
var inst_55955 = (state_55995[(11)]);
var inst_55954 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55955__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55995__$1 = (function (){var statearr_56023 = state_55995;
(statearr_56023[(11)] = inst_55955__$1);

(statearr_56023[(9)] = inst_55954);

return statearr_56023;
})();
if(cljs.core.truth_(inst_55955__$1)){
var statearr_56024_56059 = state_55995__$1;
(statearr_56024_56059[(1)] = (16));

} else {
var statearr_56025_56060 = state_55995__$1;
(statearr_56025_56060[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (16))){
var inst_55955 = (state_55995[(11)]);
var state_55995__$1 = state_55995;
var statearr_56026_56061 = state_55995__$1;
(statearr_56026_56061[(2)] = inst_55955);

(statearr_56026_56061[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (10))){
var inst_55944 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_55995__$1 = state_55995;
var statearr_56028_56062 = state_55995__$1;
(statearr_56028_56062[(2)] = inst_55944);

(statearr_56028_56062[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (18))){
var inst_55961 = (state_55995[(2)]);
var state_55995__$1 = (function (){var statearr_56029 = state_55995;
(statearr_56029[(8)] = inst_55961);

return statearr_56029;
})();
if(cljs.core.truth_(additional_params)){
var statearr_56030_56063 = state_55995__$1;
(statearr_56030_56063[(1)] = (19));

} else {
var statearr_56031_56064 = state_55995__$1;
(statearr_56031_56064[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_55996 === (8))){
var _ = (function (){var statearr_56032 = state_55995;
(statearr_56032[(4)] = cljs.core.rest((state_55995[(4)])));

return statearr_56032;
})();
var state_55995__$1 = state_55995;
var ex56027 = (state_55995__$1[(2)]);
var statearr_56033_56065 = state_55995__$1;
(statearr_56033_56065[(5)] = ex56027);


var statearr_56034_56066 = state_55995__$1;
(statearr_56034_56066[(1)] = (7));

(statearr_56034_56066[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__24298__auto____0 = (function (){
var statearr_56035 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56035[(0)] = fluree$db$dbfunctions$internal$state_machine__24298__auto__);

(statearr_56035[(1)] = (1));

return statearr_56035;
});
var fluree$db$dbfunctions$internal$state_machine__24298__auto____1 = (function (state_55995){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_55995);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e56036){var ex__24301__auto__ = e56036;
var statearr_56037_56067 = state_55995;
(statearr_56037_56067[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_55995[(4)]))){
var statearr_56038_56068 = state_55995;
(statearr_56038_56068[(1)] = cljs.core.first((state_55995[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__56069 = state_55995;
state_55995 = G__56069;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__24298__auto__ = function(state_55995){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__24298__auto____1.call(this,state_55995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_56039 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_56039[(6)] = c__24424__auto__);

return statearr_56039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__56071 = arguments.length;
switch (G__56071) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_56115){
var state_val_56116 = (state_56115[(1)]);
if((state_val_56116 === (7))){
var inst_56093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56094 = ["*"];
var inst_56095 = (new cljs.core.PersistentVector(null,1,(5),inst_56093,inst_56094,null));
var state_56115__$1 = state_56115;
var statearr_56117_56137 = state_56115__$1;
(statearr_56117_56137[(2)] = inst_56095);

(statearr_56117_56137[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56116 === (1))){
var state_56115__$1 = state_56115;
var statearr_56118_56138 = state_56115__$1;
(statearr_56118_56138[(2)] = null);

(statearr_56118_56138[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56116 === (4))){
var inst_56072 = (state_56115[(2)]);
var inst_56073 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_56072,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_56115__$1 = state_56115;
var statearr_56119_56139 = state_56115__$1;
(statearr_56119_56139[(2)] = inst_56073);

(statearr_56119_56139[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56116 === (6))){
var inst_56085 = cljs.core.PersistentVector.EMPTY;
var inst_56086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56087 = ["*"];
var inst_56088 = (new cljs.core.PersistentVector(null,1,(5),inst_56086,inst_56087,null));
var inst_56089 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_56090 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_56088,inst_56089);
var inst_56091 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_56085,inst_56090);
var state_56115__$1 = state_56115;
var statearr_56120_56140 = state_56115__$1;
(statearr_56120_56140[(2)] = inst_56091);

(statearr_56120_56140[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56116 === (3))){
var inst_56113 = (state_56115[(2)]);
var state_56115__$1 = state_56115;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56115__$1,inst_56113);
} else {
if((state_val_56116 === (2))){
var _ = (function (){var statearr_56122 = state_56115;
(statearr_56122[(4)] = cljs.core.cons((5),(state_56115[(4)])));

return statearr_56122;
})();
var inst_56082 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56083 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56115__$1 = (function (){var statearr_56123 = state_56115;
(statearr_56123[(7)] = inst_56083);

(statearr_56123[(8)] = inst_56082);

return statearr_56123;
})();
if(cljs.core.truth_(additional_params)){
var statearr_56124_56141 = state_56115__$1;
(statearr_56124_56141[(1)] = (6));

} else {
var statearr_56125_56142 = state_56115__$1;
(statearr_56125_56142[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56116 === (9))){
var inst_56104 = (state_56115[(2)]);
var inst_56105 = fluree.db.util.async.throw_err(inst_56104);
var inst_56106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56105,(0),null);
var inst_56107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56105,(1),null);
var inst_56108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56109 = [inst_56106,inst_56107];
var inst_56110 = (new cljs.core.PersistentVector(null,2,(5),inst_56108,inst_56109,null));
var _ = (function (){var statearr_56126 = state_56115;
(statearr_56126[(4)] = cljs.core.rest((state_56115[(4)])));

return statearr_56126;
})();
var state_56115__$1 = state_56115;
var statearr_56127_56143 = state_56115__$1;
(statearr_56127_56143[(2)] = inst_56110);

(statearr_56127_56143[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56116 === (5))){
var _ = (function (){var statearr_56128 = state_56115;
(statearr_56128[(4)] = cljs.core.rest((state_56115[(4)])));

return statearr_56128;
})();
var state_56115__$1 = state_56115;
var ex56121 = (state_56115__$1[(2)]);
var statearr_56129_56144 = state_56115__$1;
(statearr_56129_56144[(5)] = ex56121);


var statearr_56130_56145 = state_56115__$1;
(statearr_56130_56145[(1)] = (4));

(statearr_56130_56145[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_56116 === (8))){
var inst_56083 = (state_56115[(7)]);
var inst_56082 = (state_56115[(8)]);
var inst_56097 = (state_56115[(2)]);
var inst_56098 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_56099 = cljs.core.PersistentHashMap.EMPTY;
var inst_56100 = [inst_56097,inst_56083,inst_56099];
var inst_56101 = cljs.core.PersistentHashMap.fromArrays(inst_56098,inst_56100);
var inst_56102 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56082,inst_56101);
var state_56115__$1 = state_56115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56115__$1,(9),inst_56102);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__24298__auto____0 = (function (){
var statearr_56131 = [null,null,null,null,null,null,null,null,null];
(statearr_56131[(0)] = fluree$db$dbfunctions$internal$state_machine__24298__auto__);

(statearr_56131[(1)] = (1));

return statearr_56131;
});
var fluree$db$dbfunctions$internal$state_machine__24298__auto____1 = (function (state_56115){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_56115);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e56132){var ex__24301__auto__ = e56132;
var statearr_56133_56146 = state_56115;
(statearr_56133_56146[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_56115[(4)]))){
var statearr_56134_56147 = state_56115;
(statearr_56134_56147[(1)] = cljs.core.first((state_56115[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__56148 = state_56115;
state_56115 = G__56148;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__24298__auto__ = function(state_56115){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__24298__auto____1.call(this,state_56115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_56135 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_56135[(6)] = c__24424__auto__);

return statearr_56135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_56192){
var state_val_56193 = (state_56192[(1)]);
if((state_val_56193 === (1))){
var state_56192__$1 = state_56192;
var statearr_56194_56208 = state_56192__$1;
(statearr_56194_56208[(2)] = null);

(statearr_56194_56208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56193 === (2))){
var _ = (function (){var statearr_56195 = state_56192;
(statearr_56195[(4)] = cljs.core.cons((5),(state_56192[(4)])));

return statearr_56195;
})();
var inst_56159 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_56160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56161 = ["_user/_auth"];
var inst_56162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56163 = ["*"];
var inst_56164 = (new cljs.core.PersistentVector(null,1,(5),inst_56162,inst_56163,null));
var inst_56165 = [inst_56164];
var inst_56166 = cljs.core.PersistentHashMap.fromArrays(inst_56161,inst_56165);
var inst_56167 = [inst_56166];
var inst_56168 = (new cljs.core.PersistentVector(null,1,(5),inst_56160,inst_56167,null));
var inst_56169 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56170 = cljs.core.PersistentHashMap.EMPTY;
var inst_56171 = [inst_56168,inst_56169,inst_56170];
var inst_56172 = cljs.core.PersistentHashMap.fromArrays(inst_56159,inst_56171);
var inst_56173 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56174 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56173,inst_56172);
var state_56192__$1 = state_56192;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56192__$1,(6),inst_56174);
} else {
if((state_val_56193 === (3))){
var inst_56190 = (state_56192[(2)]);
var state_56192__$1 = state_56192;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56192__$1,inst_56190);
} else {
if((state_val_56193 === (4))){
var inst_56149 = (state_56192[(2)]);
var inst_56150 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_56149,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_56192__$1 = state_56192;
var statearr_56197_56209 = state_56192__$1;
(statearr_56197_56209[(2)] = inst_56150);

(statearr_56197_56209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56193 === (5))){
var _ = (function (){var statearr_56198 = state_56192;
(statearr_56198[(4)] = cljs.core.rest((state_56192[(4)])));

return statearr_56198;
})();
var state_56192__$1 = state_56192;
var ex56196 = (state_56192__$1[(2)]);
var statearr_56199_56210 = state_56192__$1;
(statearr_56199_56210[(5)] = ex56196);


var statearr_56200_56211 = state_56192__$1;
(statearr_56200_56211[(1)] = (4));

(statearr_56200_56211[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_56193 === (6))){
var inst_56176 = (state_56192[(2)]);
var inst_56177 = fluree.db.util.async.throw_err(inst_56176);
var inst_56178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56177,(0),null);
var inst_56179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56177,(1),null);
var inst_56180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56181 = ["_user/_auth","_id"];
var inst_56182 = (new cljs.core.PersistentVector(null,2,(5),inst_56180,inst_56181,null));
var inst_56183 = fluree.db.dbfunctions.internal.get_in(inst_56178,inst_56182);
var inst_56184 = cljs.core.first(inst_56183);
var inst_56185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56186 = [inst_56184,inst_56179];
var inst_56187 = (new cljs.core.PersistentVector(null,2,(5),inst_56185,inst_56186,null));
var _ = (function (){var statearr_56201 = state_56192;
(statearr_56201[(4)] = cljs.core.rest((state_56192[(4)])));

return statearr_56201;
})();
var state_56192__$1 = state_56192;
var statearr_56202_56212 = state_56192__$1;
(statearr_56202_56212[(2)] = inst_56187);

(statearr_56202_56212[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto____0 = (function (){
var statearr_56203 = [null,null,null,null,null,null,null];
(statearr_56203[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto__);

(statearr_56203[(1)] = (1));

return statearr_56203;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto____1 = (function (state_56192){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_56192);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e56204){var ex__24301__auto__ = e56204;
var statearr_56205_56213 = state_56192;
(statearr_56205_56213[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_56192[(4)]))){
var statearr_56206_56214 = state_56192;
(statearr_56206_56214[(1)] = cljs.core.first((state_56192[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__56215 = state_56192;
state_56192 = G__56215;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto__ = function(state_56192){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto____1.call(this,state_56192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_56207 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_56207[(6)] = c__24424__auto__);

return statearr_56207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_56232){
var state_val_56233 = (state_56232[(1)]);
if((state_val_56233 === (1))){
var state_56232__$1 = state_56232;
var statearr_56234_56248 = state_56232__$1;
(statearr_56234_56248[(2)] = null);

(statearr_56234_56248[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56233 === (2))){
var _ = (function (){var statearr_56235 = state_56232;
(statearr_56235[(4)] = cljs.core.cons((5),(state_56232[(4)])));

return statearr_56235;
})();
var inst_56222 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56223 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56224 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_56223,inst_56222);
var state_56232__$1 = state_56232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56232__$1,(6),inst_56224);
} else {
if((state_val_56233 === (3))){
var inst_56230 = (state_56232[(2)]);
var state_56232__$1 = state_56232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56232__$1,inst_56230);
} else {
if((state_val_56233 === (4))){
var inst_56216 = (state_56232[(2)]);
var state_56232__$1 = state_56232;
var statearr_56237_56249 = state_56232__$1;
(statearr_56237_56249[(2)] = inst_56216);

(statearr_56237_56249[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56233 === (5))){
var _ = (function (){var statearr_56238 = state_56232;
(statearr_56238[(4)] = cljs.core.rest((state_56232[(4)])));

return statearr_56238;
})();
var state_56232__$1 = state_56232;
var ex56236 = (state_56232__$1[(2)]);
var statearr_56239_56250 = state_56232__$1;
(statearr_56239_56250[(5)] = ex56236);


if((ex56236 instanceof Error)){
var statearr_56240_56251 = state_56232__$1;
(statearr_56240_56251[(1)] = (4));

(statearr_56240_56251[(5)] = null);

} else {
throw ex56236;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56233 === (6))){
var inst_56226 = (state_56232[(2)]);
var inst_56227 = fluree.db.util.async.throw_err(inst_56226);
var _ = (function (){var statearr_56241 = state_56232;
(statearr_56241[(4)] = cljs.core.rest((state_56232[(4)])));

return statearr_56241;
})();
var state_56232__$1 = state_56232;
var statearr_56242_56252 = state_56232__$1;
(statearr_56242_56252[(2)] = inst_56227);

(statearr_56242_56252[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto____0 = (function (){
var statearr_56243 = [null,null,null,null,null,null,null];
(statearr_56243[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto__);

(statearr_56243[(1)] = (1));

return statearr_56243;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto____1 = (function (state_56232){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_56232);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e56244){var ex__24301__auto__ = e56244;
var statearr_56245_56253 = state_56232;
(statearr_56245_56253[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_56232[(4)]))){
var statearr_56246_56254 = state_56232;
(statearr_56246_56254[(1)] = cljs.core.first((state_56232[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__56255 = state_56232;
state_56232 = G__56255;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto__ = function(state_56232){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto____1.call(this,state_56232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_56247 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_56247[(6)] = c__24424__auto__);

return statearr_56247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__56256_SHARP_){
return p1__56256_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56257_SHARP_){
return p1__56257_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e56258){var e = e56258;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__56259_SHARP_){
return p1__56259_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56260_SHARP_){
return p1__56260_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e56261){var e = e56261;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__56263 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__56263);
})() | (0));
return num;
}catch (e56262){var e = e56262;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_56343){
var state_val_56344 = (state_56343[(1)]);
if((state_val_56344 === (7))){
var inst_56282 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_56283 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_56284 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_56285 = cljs.core.PersistentHashMap.fromArrays(inst_56283,inst_56284);
var inst_56286 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_56282,inst_56285);
var inst_56287 = (function(){throw inst_56286})();
var state_56343__$1 = state_56343;
var statearr_56345_56380 = state_56343__$1;
(statearr_56345_56380[(2)] = inst_56287);

(statearr_56345_56380[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (1))){
var state_56343__$1 = state_56343;
var statearr_56346_56381 = state_56343__$1;
(statearr_56346_56381[(2)] = null);

(statearr_56346_56381[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (4))){
var inst_56264 = (state_56343[(2)]);
var state_56343__$1 = state_56343;
var statearr_56347_56382 = state_56343__$1;
(statearr_56347_56382[(2)] = inst_56264);

(statearr_56347_56382[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (15))){
var inst_56327 = (state_56343[(7)]);
var inst_56323 = (state_56343[(2)]);
var inst_56324 = fluree.db.util.async.throw_err(inst_56323);
var inst_56325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56324,(0),null);
var inst_56326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56324,(1),null);
var inst_56327__$1 = cljs.core.first(inst_56325);
var inst_56328 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_56327__$1,compare_val);
var state_56343__$1 = (function (){var statearr_56348 = state_56343;
(statearr_56348[(7)] = inst_56327__$1);

(statearr_56348[(8)] = inst_56326);

return statearr_56348;
})();
if(inst_56328){
var statearr_56349_56383 = state_56343__$1;
(statearr_56349_56383[(1)] = (16));

} else {
var statearr_56350_56384 = state_56343__$1;
(statearr_56350_56384[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (13))){
var state_56343__$1 = state_56343;
var statearr_56351_56385 = state_56343__$1;
(statearr_56351_56385[(2)] = null);

(statearr_56351_56385[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (6))){
var state_56343__$1 = state_56343;
var statearr_56352_56386 = state_56343__$1;
(statearr_56352_56386[(2)] = null);

(statearr_56352_56386[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (17))){
var inst_56327 = (state_56343[(7)]);
var inst_56331 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56327)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_56332 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_56333 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_56334 = cljs.core.PersistentHashMap.fromArrays(inst_56332,inst_56333);
var inst_56335 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_56331,inst_56334);
var inst_56336 = (function(){throw inst_56335})();
var state_56343__$1 = state_56343;
var statearr_56353_56387 = state_56343__$1;
(statearr_56353_56387[(2)] = inst_56336);

(statearr_56353_56387[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (3))){
var inst_56341 = (state_56343[(2)]);
var state_56343__$1 = state_56343;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56343__$1,inst_56341);
} else {
if((state_val_56344 === (12))){
var inst_56279 = (state_56343[(9)]);
var inst_56302 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_56279], 0));
var inst_56303 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_56304 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_56305 = cljs.core.PersistentHashMap.fromArrays(inst_56303,inst_56304);
var inst_56306 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_56302,inst_56305);
var inst_56307 = (function(){throw inst_56306})();
var state_56343__$1 = state_56343;
var statearr_56354_56388 = state_56343__$1;
(statearr_56354_56388[(2)] = inst_56307);

(statearr_56354_56388[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (2))){
var inst_56276 = (state_56343[(10)]);
var inst_56278 = (state_56343[(11)]);
var inst_56277 = (state_56343[(12)]);
var _ = (function (){var statearr_56355 = state_56343;
(statearr_56355[(4)] = cljs.core.cons((5),(state_56343[(4)])));

return statearr_56355;
})();
var inst_56274 = _QMARK_ctx;
var inst_56275 = cljs.core.__destructure_map(inst_56274);
var inst_56276__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56275,cljs.core.cst$kw$sid);
var inst_56277__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56275,cljs.core.cst$kw$pid);
var inst_56278__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56275,cljs.core.cst$kw$db);
var inst_56279 = fluree.db.dbproto._p_prop(inst_56278__$1,cljs.core.cst$kw$name,inst_56277__$1);
var state_56343__$1 = (function (){var statearr_56356 = state_56343;
(statearr_56356[(10)] = inst_56276__$1);

(statearr_56356[(9)] = inst_56279);

(statearr_56356[(11)] = inst_56278__$1);

(statearr_56356[(12)] = inst_56277__$1);

return statearr_56356;
})();
if(cljs.core.truth_(inst_56276__$1)){
var statearr_56357_56389 = state_56343__$1;
(statearr_56357_56389[(1)] = (6));

} else {
var statearr_56358_56390 = state_56343__$1;
(statearr_56358_56390[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (11))){
var inst_56278 = (state_56343[(11)]);
var inst_56277 = (state_56343[(12)]);
var inst_56299 = (state_56343[(2)]);
var inst_56300 = fluree.db.dbproto._p_prop(inst_56278,cljs.core.cst$kw$multi,inst_56277);
var state_56343__$1 = (function (){var statearr_56360 = state_56343;
(statearr_56360[(13)] = inst_56299);

return statearr_56360;
})();
if(cljs.core.truth_(inst_56300)){
var statearr_56361_56391 = state_56343__$1;
(statearr_56361_56391[(1)] = (12));

} else {
var statearr_56362_56392 = state_56343__$1;
(statearr_56362_56392[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (9))){
var state_56343__$1 = state_56343;
var statearr_56363_56393 = state_56343__$1;
(statearr_56363_56393[(2)] = null);

(statearr_56363_56393[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (5))){
var _ = (function (){var statearr_56364 = state_56343;
(statearr_56364[(4)] = cljs.core.rest((state_56343[(4)])));

return statearr_56364;
})();
var state_56343__$1 = state_56343;
var ex56359 = (state_56343__$1[(2)]);
var statearr_56365_56394 = state_56343__$1;
(statearr_56365_56394[(5)] = ex56359);


if((ex56359 instanceof Error)){
var statearr_56366_56395 = state_56343__$1;
(statearr_56366_56395[(1)] = (4));

(statearr_56366_56395[(5)] = null);

} else {
throw ex56359;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (14))){
var inst_56276 = (state_56343[(10)]);
var inst_56279 = (state_56343[(9)]);
var inst_56278 = (state_56343[(11)]);
var inst_56310 = (state_56343[(2)]);
var inst_56311 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_56312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56314 = [inst_56276,inst_56279,"?current-val"];
var inst_56315 = (new cljs.core.PersistentVector(null,3,(5),inst_56313,inst_56314,null));
var inst_56316 = [inst_56315];
var inst_56317 = (new cljs.core.PersistentVector(null,1,(5),inst_56312,inst_56316,null));
var inst_56318 = cljs.core.PersistentHashMap.EMPTY;
var inst_56319 = ["?current-val",inst_56317,inst_56318];
var inst_56320 = cljs.core.PersistentHashMap.fromArrays(inst_56311,inst_56319);
var inst_56321 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56278,inst_56320);
var state_56343__$1 = (function (){var statearr_56367 = state_56343;
(statearr_56367[(14)] = inst_56310);

return statearr_56367;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56343__$1,(15),inst_56321);
} else {
if((state_val_56344 === (16))){
var state_56343__$1 = state_56343;
var statearr_56368_56396 = state_56343__$1;
(statearr_56368_56396[(2)] = new_val);

(statearr_56368_56396[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (10))){
var inst_56292 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_56293 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_56294 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_56295 = cljs.core.PersistentHashMap.fromArrays(inst_56293,inst_56294);
var inst_56296 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_56292,inst_56295);
var inst_56297 = (function(){throw inst_56296})();
var state_56343__$1 = state_56343;
var statearr_56369_56397 = state_56343__$1;
(statearr_56369_56397[(2)] = inst_56297);

(statearr_56369_56397[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (18))){
var inst_56338 = (state_56343[(2)]);
var _ = (function (){var statearr_56370 = state_56343;
(statearr_56370[(4)] = cljs.core.rest((state_56343[(4)])));

return statearr_56370;
})();
var state_56343__$1 = state_56343;
var statearr_56371_56398 = state_56343__$1;
(statearr_56371_56398[(2)] = inst_56338);

(statearr_56371_56398[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56344 === (8))){
var inst_56279 = (state_56343[(9)]);
var inst_56289 = (state_56343[(2)]);
var state_56343__$1 = (function (){var statearr_56372 = state_56343;
(statearr_56372[(15)] = inst_56289);

return statearr_56372;
})();
if(cljs.core.truth_(inst_56279)){
var statearr_56373_56399 = state_56343__$1;
(statearr_56373_56399[(1)] = (9));

} else {
var statearr_56374_56400 = state_56343__$1;
(statearr_56374_56400[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto____0 = (function (){
var statearr_56375 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56375[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto__);

(statearr_56375[(1)] = (1));

return statearr_56375;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto____1 = (function (state_56343){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_56343);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e56376){var ex__24301__auto__ = e56376;
var statearr_56377_56401 = state_56343;
(statearr_56377_56401[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_56343[(4)]))){
var statearr_56378_56402 = state_56343;
(statearr_56378_56402[(1)] = cljs.core.first((state_56343[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__56403 = state_56343;
state_56343 = G__56403;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto__ = function(state_56343){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto____1.call(this,state_56343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_56379 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_56379[(6)] = c__24424__auto__);

return statearr_56379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
