// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.js');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('cljs.env');
goog.require('cljs.spec.alpha');
goog.require('cljs.analyzer');
goog.require('cljs.compiler');
goog.require('cljs.tools.reader');
goog.require('cljs.tools.reader.reader_types');
goog.require('cljs.tagged_literals');
goog.require('goog.crypt.base64');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
goog.require("cljs.core$macros");
cljs.js.debug_prn = (function cljs$js$debug_prn(var_args){
var args__4824__auto__ = [];
var len__4818__auto___21836 = arguments.length;
var i__4819__auto___21837 = (0);
while(true){
if((i__4819__auto___21837 < len__4818__auto___21836)){
args__4824__auto__.push((arguments[i__4819__auto___21837]));

var G__21838 = (i__4819__auto___21837 + (1));
i__4819__auto___21837 = G__21838;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return cljs.js.debug_prn.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(cljs.js.debug_prn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var _STAR_print_fn_STAR__orig_val__21834 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_fn_STAR__temp_val__21835 = cljs.core._STAR_print_err_fn_STAR_;
(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__21835);

try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.println,args);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__21834);
}}));

(cljs.js.debug_prn.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.js.debug_prn.cljs$lang$applyTo = (function (seq21833){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq21833));
}));

/**
 * Given a namespace as a symbol return the relative path sans extension
 */
cljs.js.ns__GT_relpath = (function cljs$js$ns__GT_relpath(ns_sym){
return clojure.string.replace(cljs.analyzer.munge_path(ns_sym),".","/");
});
cljs.js.file__GT_ns = (function cljs$js$file__GT_ns(file){
var lib_name = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.replace(file,"/","."),(0),(cljs.core.count(file) - (5)));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.demunge(lib_name));
});
cljs.js.drop_macros_suffix = (function cljs$js$drop_macros_suffix(ns_name){
if(cljs.core.truth_(ns_name)){
if(clojure.string.ends_with_QMARK_(ns_name,"$macros")){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns_name,(0),(cljs.core.count(ns_name) - (7)));
} else {
return ns_name;
}
} else {
return null;
}
});
cljs.js.elide_macros_suffix = (function cljs$js$elide_macros_suffix(sym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(cljs.js.drop_macros_suffix(cljs.core.namespace(sym)),cljs.core.name(sym));
});
cljs.js.resolve_symbol = (function cljs$js$resolve_symbol(sym){
if(clojure.string.starts_with_QMARK_(cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym),".")){
return sym;
} else {
return cljs.js.elide_macros_suffix(cljs.analyzer.resolve_symbol(sym));
}
});
cljs.js.read = (function cljs$js$read(eof,rdr){
var _STAR_ns_STAR__orig_val__21839 = cljs.core._STAR_ns_STAR_;
var _STAR_ns_STAR__temp_val__21840 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.js.drop_macros_suffix(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._STAR_ns_STAR_)));
(cljs.core._STAR_ns_STAR_ = _STAR_ns_STAR__temp_val__21840);

try{return cljs.tools.reader.read.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$eof,eof,cljs.core.cst$kw$read_DASH_cond,cljs.core.cst$kw$allow,cljs.core.cst$kw$features,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs,null], null), null)], null),rdr);
}finally {(cljs.core._STAR_ns_STAR_ = _STAR_ns_STAR__orig_val__21839);
}});
cljs.js.atom_QMARK_ = (function cljs$js$atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
cljs.js.valid_name_QMARK_ = (function cljs$js$valid_name_QMARK_(x){
return (((x == null)) || ((((x instanceof cljs.core.Symbol)) || (typeof x === 'string'))));
});
cljs.js.valid_opts_QMARK_ = (function cljs$js$valid_opts_QMARK_(x){
return (((x == null)) || (cljs.core.map_QMARK_(x)));
});
if((typeof cljs !== 'undefined') && (typeof cljs.js !== 'undefined') && (typeof cljs.js._STAR_load_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to load a library.
 *   Whatever function *load-fn* is bound to will be passed two arguments - a
 *   map and a callback function: The map will have the following keys:
 * 
 *   :name   - the name of the library (a symbol)
 *   :macros - modifier signaling a macros namespace load
 *   :path   - munged relative library path (a string)
 * 
 *   It is up to the implementor to correctly resolve the corresponding .cljs,
 *   .cljc, or .js resource (the order must be respected). If :macros is true
 *   resolution should only consider .clj or .cljc resources (the order must be
 *   respected). Upon resolution the callback should be invoked with a map
 *   containing the following keys:
 * 
 *   :lang       - the language, :clj or :js
 *   :source     - the source of the library (a string)
 *   :file       - optional, the file path, it will be added to AST's :file keyword
 *              (but not in :meta)
 *   :cache      - optional, if a :clj namespace has been precompiled to :js, can
 *              give an analysis cache for faster loads.
 *   :source-map - optional, if a :clj namespace has been precompiled to :js, can
 *              give a V3 source map JSON
 * 
 *   If the resource could not be resolved, the callback should be invoked with
 *   nil.
 */
cljs.js._STAR_load_fn_STAR_ = (function cljs$js$_STAR_load_fn_STAR_(m,cb){
throw (new Error("No *load-fn* set"));
});
}
if((typeof cljs !== 'undefined') && (typeof cljs.js !== 'undefined') && (typeof cljs.js._STAR_eval_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides various ways to eval JavaScript
 *   source. Whatever function *eval-fn* is bound to will be passed a map
 *   containing the following keys:
 * 
 *   :source - the source of the library (string)
 *   :name   - used to unique identify the script (symbol)
 *   :cache  - if the source was originally ClojureScript, will be given the
 *          analysis cache.
 * 
 *   The result of evaluation should be the return value.
 */
cljs.js._STAR_eval_fn_STAR_ = (function cljs$js$_STAR_eval_fn_STAR_(m){
throw (new Error("No *eval-fn* set"));
});
}
/**
 * A default JavaScript evaluation function.
 */
cljs.js.js_eval = (function cljs$js$js_eval(p__21841){
var map__21842 = p__21841;
var map__21842__$1 = cljs.core.__destructure_map(map__21842);
var resource = map__21842__$1;
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21842__$1,cljs.core.cst$kw$source);
return eval(source);
});
cljs.js.wrap_error = (function cljs$js$wrap_error(ex){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,ex], null);
});
/**
 * Construct an empty compiler state. Required to invoke analyze, compile,
 * eval and eval-str.
 */
cljs.js.empty_state = (function cljs$js$empty_state(var_args){
var G__21844 = arguments.length;
switch (G__21844) {
case 0:
return cljs.js.empty_state.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.js.empty_state.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.js.empty_state.cljs$core$IFn$_invoke$arity$0 = (function (){
var G__21845 = cljs.env.default_compiler_env.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(G__21845,(function (state){
return cljs.core.assoc_in(state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces,cljs.core.cst$sym$cljs$core], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$rename_DASH_macros,cljs.core.cst$kw$renames,cljs.core.cst$kw$externs,cljs.core.cst$kw$use_DASH_macros,cljs.core.cst$kw$excludes,cljs.core.cst$kw$macros,cljs.core.cst$kw$name,cljs.core.cst$kw$imports,cljs.core.cst$kw$requires,cljs.core.cst$kw$uses,cljs.core.cst$kw$defs,cljs.core.cst$kw$require_DASH_macros,cljs.core.cst$kw$cljs$analyzer_SLASH_constants,cljs.core.cst$kw$doc],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$setTimeout,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$sym$process,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$hrtime,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$sym$Java,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$type,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$sym$Object,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$out,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$println,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$sym$error,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$println,cljs.core.PersistentArrayMap.EMPTY], null)], null)], null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentHashSet.EMPTY,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$unsafe_DASH_bit_DASH_and,cljs.core.cst$sym$macroexpand,cljs.core.cst$sym$unchecked_DASH_remainder_DASH_int,cljs.core.cst$sym$when_DASH_first,cljs.core.cst$sym$cond_DASH__GT__GT_,cljs.core.cst$sym$bit_DASH_set,cljs.core.cst$sym$import_DASH_macros,cljs.core.cst$sym$while,cljs.core.cst$sym$satisfies_QMARK_,cljs.core.cst$sym$unchecked_DASH_subtract_DASH_int,cljs.core.cst$sym$ns_DASH_unmap,cljs.core.cst$sym$import,cljs.core.cst$sym$bit_DASH_shift_DASH_right,cljs.core.cst$sym$aget,cljs.core.cst$sym$specify,cljs.core.cst$sym$vswap_BANG_,cljs.core.cst$sym$caching_DASH_hash,cljs.core.cst$sym$bit_DASH_shift_DASH_left,cljs.core.cst$sym$coercive_DASH_not,cljs.core.cst$sym$dec,cljs.core.cst$sym$unchecked_DASH_get,cljs.core.cst$sym$return_DASH_first,cljs.core.cst$sym$ns_DASH_publics,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$js_DASH_fn_QMARK_,cljs.core.cst$sym$this_DASH_as,cljs.core.cst$sym$$$,cljs.core.cst$sym$delay,cljs.core.cst$sym$some_QMARK_,cljs.core.cst$sym$unchecked_DASH_negate,cljs.core.cst$sym$simple_DASH_benchmark,cljs.core.cst$sym$unchecked_DASH_inc_DASH_int,cljs.core.cst$sym$unchecked_DASH_set,cljs.core.cst$sym$js_DASH_str,cljs.core.cst$sym$bit_DASH_shift_DASH_right_DASH_zero_DASH_fill,cljs.core.cst$sym$implements_QMARK_,cljs.core.cst$sym$goog_DASH_define,cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$specify_BANG_,cljs.core.cst$sym$if_DASH_not,cljs.core.cst$sym$alength,cljs.core.cst$sym$bit_DASH_xor,cljs.core.cst$sym$doseq,cljs.core.cst$sym$unsigned_DASH_bit_DASH_shift_DASH_right,cljs.core.cst$sym$neg_QMARK_,cljs.core.cst$sym$unchecked_DASH_float,cljs.core.cst$sym$undefined_QMARK_,cljs.core.cst$sym$deftype,cljs.core.cst$sym$mask,cljs.core.cst$sym$when_DASH_let,cljs.core.cst$sym$divide,cljs.core.cst$sym$coercive_DASH_boolean,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$if_DASH_some,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$min,cljs.core.cst$sym$lazy_DASH_seq,cljs.core.cst$sym$js_DASH_delete,cljs.core.cst$sym$truth_,cljs.core.cst$sym$defcurried,cljs.core.cst$sym$js_DASH_debugger,cljs.core.cst$sym$let,cljs.core.cst$sym$_DASH__GT_,cljs.core.cst$sym$coercive_DASH_not_EQ_,cljs.core.cst$sym$doto,cljs.core.cst$sym$areduce,cljs.core.cst$sym$double,cljs.core.cst$sym$bit_DASH_and_DASH_not,cljs.core.cst$sym$unchecked_DASH_add_DASH_int,cljs.core.cst$sym$fn,cljs.core.cst$sym$short,cljs.core.cst$sym$js_DASH_this,cljs.core.cst$sym$unchecked_DASH_double,cljs.core.cst$sym$string_QMARK_,cljs.core.cst$sym$js_DASH_arguments,cljs.core.cst$sym$unchecked_DASH_multiply_DASH_int,cljs.core.cst$sym$as_DASH__GT_,cljs.core.cst$sym$when_DASH_not,cljs.core.cst$sym$when,cljs.core.cst$sym$int,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$keyword_QMARK_,cljs.core.cst$sym$use_DASH_macros,cljs.core.cst$sym$unchecked_DASH_multiply,cljs.core.cst$sym$gen_DASH_apply_DASH_to,cljs.core.cst$sym$some_DASH__GT__GT_,cljs.core.cst$sym$unchecked_DASH_dec,cljs.core.cst$sym$defn,cljs.core.cst$sym$float,cljs.core.cst$sym$js_DASH_in,cljs.core.cst$sym$es6_DASH_iterable,cljs.core.cst$sym$amap,cljs.core.cst$sym$use,cljs.core.cst$sym$declare,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$or,cljs.core.cst$sym$extend_DASH_type,cljs.core.cst$sym$macroexpand_DASH_1,cljs.core.cst$sym$bit_DASH_test,cljs.core.cst$sym$defmethod,cljs.core.cst$sym$time,cljs.core.cst$sym$zero_QMARK_,cljs.core.cst$sym$require,cljs.core.cst$sym$unchecked_DASH_dec_DASH_int,cljs.core.cst$sym$memfn,cljs.core.cst$sym$js_DASH_obj,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$extend_DASH_protocol,cljs.core.cst$sym$cond_DASH__GT_,cljs.core.cst$sym$dotimes,cljs.core.cst$sym$bit_DASH_and,cljs.core.cst$sym$reify,cljs.core.cst$sym$instance_QMARK_,cljs.core.cst$sym$load_DASH_file_STAR_,cljs.core.cst$sym$defonce,cljs.core.cst$sym$unchecked_DASH_add,cljs.core.cst$sym$rfn,cljs.core.cst$sym$identical_QMARK_,cljs.core.cst$sym$unchecked_DASH_divide_DASH_int,cljs.core.cst$sym$defn_DASH_,cljs.core.cst$sym$defprotocol,cljs.core.cst$sym$ns_DASH_special_DASH_form,cljs.core.cst$sym$unchecked_DASH_subtract,cljs.core.cst$sym$assert,cljs.core.cst$sym$true_QMARK_,cljs.core.cst$sym$array,cljs.core.cst$sym$letfn,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$bitpos,cljs.core.cst$sym$bit_DASH_or,cljs.core.cst$sym$vector,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$loop,cljs.core.cst$sym$bit_DASH_flip,cljs.core.cst$sym$js_DASH_mod,cljs.core.cst$sym$with_DASH_out_DASH_str,cljs.core.cst$sym$condp,cljs.core.cst$sym$cond,cljs.core.cst$sym$some_DASH__GT_,cljs.core.cst$sym$ns_DASH_interns,cljs.core.cst$sym$for,cljs.core.cst$sym$binding,cljs.core.cst$sym$array_DASH_map,cljs.core.cst$sym$unchecked_DASH_byte,cljs.core.cst$sym$ns_DASH_imports,cljs.core.cst$sym$defmacro,cljs.core.cst$sym$unchecked_DASH_short,cljs.core.cst$sym$inc,cljs.core.cst$sym$with_DASH_redefs,cljs.core.cst$sym$bit_DASH_clear,cljs.core.cst$sym$locking,cljs.core.cst$sym$list,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$aset,cljs.core.cst$sym$defmulti,cljs.core.cst$sym$str,cljs.core.cst$sym$coercive_DASH__EQ_,cljs.core.cst$sym$hash_DASH_map,cljs.core.cst$sym$gen_DASH_apply_DASH_to_DASH_simple,cljs.core.cst$sym$if_DASH_let,cljs.core.cst$sym$false_QMARK_,cljs.core.cst$sym$case,cljs.core.cst$sym$exists_QMARK_,cljs.core.cst$sym$bit_DASH_not,cljs.core.cst$sym$byte,cljs.core.cst$sym$max,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$lazy_DASH_cat,cljs.core.cst$sym$comment,cljs.core.cst$sym$copy_DASH_arguments,cljs.core.cst$sym$when_DASH_assert,cljs.core.cst$sym$unsafe_DASH_cast,cljs.core.cst$sym$resolve,cljs.core.cst$sym$defrecord,cljs.core.cst$sym$make_DASH_array,cljs.core.cst$sym$unchecked_DASH_negate_DASH_int,cljs.core.cst$sym$unchecked_DASH_inc,cljs.core.cst$sym$and,cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$js_DASH_comment,cljs.core.cst$sym$symbol_QMARK_,cljs.core.cst$sym$when_DASH_some,cljs.core.cst$sym$unchecked_DASH_char,cljs.core.cst$sym$require_DASH_macros,cljs.core.cst$sym$_DASH__GT__GT_,cljs.core.cst$sym$js_DASH_inline_DASH_comment,cljs.core.cst$sym$refer_DASH_clojure],[new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1193,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unsafe_DASH_bit_DASH_and,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted], null)),cljs.core.cst$kw$doc,"Repeatedly calls macroexpand-1 on form until it no longer\n  represents a macro form, then returns it.  Note neither\n  macroexpand-1 nor macroexpand expand macros in subforms.",cljs.core.cst$kw$line,3078,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_macroexpand,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1100,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_remainder_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"bindings => x xs\n\n  Roughly the same as (when (seq xs) (let [x (first xs)] body)) but xs is evaluated only once",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,4444,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_first,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),cljs.core.cst$kw$doc,"Takes an expression and a set of test/form pairs. Threads expr (via ->>)\n  through each form for which the corresponding test expression\n  is true.  Note that, unlike cond branching, cond->> threading does not short circuit\n  after the first true test expression.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7257,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_cond_DASH__GT__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1233,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_set,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vars], null)], null)),cljs.core.cst$kw$line,64,cljs.core.cst$kw$column,4,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_import_DASH_macros,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Repeatedly executes body while test expression is true. Presumes\n  some side-effect will cause test to become false/nil. Returns nil",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,6087,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_while,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$psym,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Returns true if x satisfies the protocol",cljs.core.cst$kw$line,2188,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_satisfies_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1106,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_subtract_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_ns,cljs.core.cst$sym$quoted_DASH_sym], null)),cljs.core.cst$kw$doc,"Removes the mappings for the symbol from the namespace.",cljs.core.cst$kw$line,2937,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_unmap,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$import_DASH_symbols_DASH_or_DASH_lists], null)),cljs.core.cst$kw$doc,"import-list => (closure-namespace constructor-name-symbols*)\n\n  For each name in constructor-name-symbols, adds a mapping from name to the\n  constructor named by closure-namespace to the current namespace. Use :import in the ns\n  macro in preference to calling this directly.",cljs.core.cst$kw$line,3041,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_import,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1224,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_shift_DASH_right,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),cljs.core.cst$kw$line,1009,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_aget,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"Identical to specify! but does not mutate its first argument. The first\n  argument must be an ICloneable instance.",cljs.core.cst$kw$line,1379,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_specify,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vol,cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Non-atomically swaps the value of the volatile as if:\n   (apply f current-value-of-vol args). Returns the value that\n   was swapped in.",cljs.core.cst$kw$line,2949,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_vswap_BANG_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$hash_DASH_fn,cljs.core.cst$sym$hash_DASH_key], null)),cljs.core.cst$kw$line,1245,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_caching_DASH_hash,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1221,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_shift_DASH_left,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,895,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_coercive_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1155,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_dec,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key], null)),cljs.core.cst$kw$doc,"INTERNAL. Compiles to JavaScript property access using bracket notation. Does\n  not distinguish between object and array types and not subject to compiler\n  static analysis.",cljs.core.cst$kw$line,1036,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_get,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$line,727,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_return_DASH_first,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_ns], null)),cljs.core.cst$kw$doc,"Returns a map of the public intern mappings for the namespace.",cljs.core.cst$kw$line,2893,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_publics,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1130,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__LT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,963,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_fn_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Defines a scope where JavaScript's implicit \"this\" is bound to the name provided.",cljs.core.cst$kw$line,1389,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_this_DASH_as,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$form], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$form,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$doc,"form => fieldName-symbol or (instanceMethodName-symbol args*)\n\n  Expands into a member access (.) of the first member on the first\n  argument, followed by the next member on the result, etc. For\n  instance:\n\n  (.. System (getProperties) (get \"os.name\"))\n\n  expands to:\n\n  (. (. System (getProperties)) (get \"os.name\"))\n\n  but is easier to write, read, and understand.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1568,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_$$,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Takes a body of expressions and yields a Delay object that will\n  invoke the body only the first time it is forced (with force or deref/@), and\n  will cache the result and return it on all subsequent force\n  calls.",cljs.core.cst$kw$line,2228,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_delay,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,892,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_some_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1094,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_negate,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$expr,cljs.core.cst$sym$iterations,cljs.core.cst$sym$_AMPERSAND_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$print_DASH_fn], null),cljs.core.cst$kw$or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$print_DASH_fn,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.cst$sym$println)], null)], null)], null)),cljs.core.cst$kw$doc,"Runs expr iterations times in the context of a let expression with\n  the given bindings, then prints out the bindings and the expr\n  followed by number of iterations and total time. The optional\n  argument print-fn, defaulting to println, sets function used to\n  print the result. expr's string representation will be produced\n  using pr-str in any case.",cljs.core.cst$kw$line,2795,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_simple_DASH_benchmark,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1085,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_inc_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$doc,"INTERNAL. Compiles to JavaScript property access using bracket notation. Does\n  not distinguish between object and array types and not subject to compiler\n  static analysis.",cljs.core.cst$kw$line,1043,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_set,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),cljs.core.cst$kw$line,2884,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_str,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1227,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_shift_DASH_right_DASH_zero_DASH_fill,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$psym,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"EXPERIMENTAL",cljs.core.cst$kw$line,2162,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_implements_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym,cljs.core.cst$sym$default], null)),cljs.core.cst$kw$doc,"Defines a var using `goog.define`. Passed default value must be\n  string, number or boolean.\n\n  Default value can be overridden at compile time using the\n  compiler option `:closure-defines`.\n\n  Example:\n    (ns your-app.core)\n    (goog-define DEBUG! false)\n    ;; can be overridden with\n    :closure-defines {\"your_app.core.DEBUG_BANG_\" true}\n    or\n    :closure-defines {your-app.core/DEBUG! true}",cljs.core.cst$kw$line,733,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_goog_DASH_define,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1164,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_pos_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"Identical to reify but mutates its first argument.",cljs.core.cst$kw$line,1371,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_specify_BANG_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$then], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$then,cljs.core.cst$sym$else], null)),cljs.core.cst$kw$doc,"Evaluates test. If logical false, evaluates and returns then expr, \n  otherwise else expr, if supplied, else nil.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,748,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_if_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a], null)),cljs.core.cst$kw$line,2676,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_alength,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1204,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_xor,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$seq_DASH_exprs,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Repeatedly executes body (presumably for side-effects) with\n  bindings and filtering as provided by \"for\".  Does not retain\n  the head of the sequence. Returns nil.",cljs.core.cst$kw$line,2510,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_doseq,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1230,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unsigned_DASH_bit_DASH_shift_DASH_right,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1167,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_neg_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1064,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_float,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Return true if argument is identical to the JavaScript undefined value.",cljs.core.cst$kw$line,983,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_undefined_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$t,cljs.core.cst$sym$fields,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"(deftype name [fields*]  options* specs*)\n\n  Currently there are no options.\n\n  Each spec consists of a protocol or interface name followed by zero\n  or more method bodies:\n\n  protocol-or-Object\n  (methodName [args*] body)*\n\n  The type will have the (by default, immutable) fields named by\n  fields, which can have type hints. Protocols and methods\n  are optional. The only methods that can be supplied are those\n  declared in the protocols/interfaces.  Note that method bodies are\n  not closures, the local environment includes only the named fields,\n  and those fields can be accessed directly. Fields can be qualified\n  with the metadata :mutable true at which point (set! afield aval) will be\n  supported in method bodies. Note well that mutable fields are extremely\n  difficult to use correctly, and are present only to facilitate the building\n  of higherlevel constructs, such as ClojureScript's reference types, in\n  ClojureScript itself. They are for experts only - if the semantics and\n  implications of :mutable are not immediately apparent to you, you should not\n  be using them.\n\n  Method definitions take the form:\n\n  (methodname [args*] body)\n\n  The argument and return types can be hinted on the arg and\n  methodname symbols. If not supplied, they will be inferred, so type\n  hints should be reserved for disambiguation.\n\n  Methods should be supplied for all methods of the desired\n  protocol(s). You can also define overrides for methods of Object. Note that\n  a parameter must be supplied to correspond to the target object\n  ('this' in JavaScript parlance). Note also that recur calls to the method\n  head should *not* pass the target object, it will be supplied\n  automatically and can not be substituted.\n\n  In the method bodies, the (unqualified) name can be used to name the\n  class (for calls to new, instance? etc).\n\n  One constructor will be defined, taking the designated fields.  Note\n  that the field names __meta and __extmap are currently reserved and\n  should not be used when defining your own types.\n\n  Given (deftype TypeName ...), a factory function called ->TypeName\n  will be defined, taking positional parameters for the fields",cljs.core.cst$kw$line,1718,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_deftype,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash,cljs.core.cst$sym$shift], null)),cljs.core.cst$kw$line,1237,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_mask,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"bindings => binding-form test\n\n  When test is true, evaluates body with binding-form bound to the value of test",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1769,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_let,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1125,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_divide,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,904,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_coercive_DASH_boolean,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1135,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__LT__EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$then], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$then,cljs.core.cst$sym$else,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$oldform], null)),cljs.core.cst$kw$doc,"bindings => binding-form test\n\n   If test is not nil, evaluates then with binding-form bound to the\n   value of test, if not, yields else",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1784,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_if_DASH_some,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1114,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__STAR_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1176,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_min,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Takes a body of expressions that returns an ISeq or nil, and yields\n  a ISeqable object that will invoke the body only the first time seq\n  is called, and will cache the result and return it on all subsequent\n  seq calls.",cljs.core.cst$kw$line,2220,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_lazy_DASH_seq,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key], null)),cljs.core.cst$kw$line,916,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_delete,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,909,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_truth_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$macro,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$cljs$core_SLASH_defcurried,"cljs/core.cljc",1,1263,true,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc,cljs.core.cst$sym$meta,cljs.core.cst$sym$args,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),"Builds another arity of the fn that returns a fn awaiting the last\n  param"]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$doc,"Emit JavaScript \"debugger;\" statement",cljs.core.cst$kw$line,922,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_debugger,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"binding => binding-form init-expr\n\n  Evaluates the exprs in a lexical context in which the symbols in\n  the binding-forms are bound to their respective init-exprs or parts\n  therein.",cljs.core.cst$kw$line,767,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_let,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"Threads the expr through the forms. Inserts x as the\n  second item in the first form, making a list of it if it is not a\n  list already. If there are more forms, inserts the first form as the\n  second item in second form, etc.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1586,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$line,898,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_coercive_DASH_not_EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"Evaluates x then calls all of the methods and functions with the\n  value of x supplied at the front of the given arguments.  The forms\n  are evaluated in order.  Returns x.\n\n  (doto (new js/Map) (.set \"a\" 1) (.set \"b\" 2))",cljs.core.cst$kw$line,178,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_doto,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$idx,cljs.core.cst$sym$ret,cljs.core.cst$sym$init,cljs.core.cst$sym$expr], null)),cljs.core.cst$kw$doc,"Reduces an expression across an array a, using an index named idx,\n  and return value named ret, initialized to init, setting ret to the\n  evaluation of expr at each step, returning ret.",cljs.core.cst$kw$line,2697,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_areduce,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1059,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_double,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1208,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_and_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1070,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_add_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$sigs], null)),cljs.core.cst$kw$doc,"params => positional-params* , or positional-params* & next-param\n  positional-param => binding-form\n  next-param => binding-form\n  name => symbol\n\n  Defines a function",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,4357,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_fn,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1057,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_short,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$line,1386,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_this,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1065,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_double,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,960,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_string_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$line,913,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_arguments,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1091,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_multiply_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$name,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"Binds name to expr, evaluates the first form in the lexical context\n  of that binding, then binds name to that result, repeating for each\n  successive form, returning the result of the last form.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7274,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_as_DASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Evaluates test. If logical false, evaluates body in an implicit do.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,499,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Evaluates test. If logical true, evaluates body in an implicit do.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,493,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1201,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1140,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1006,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_keyword_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Similar to use but only for macros.",cljs.core.cst$kw$line,3036,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_use_DASH_macros,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1088,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_multiply,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$line,2826,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_gen_DASH_apply_DASH_to,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"When expr is not nil, threads it into the first form (via ->>),\n  and when that result is not nil, through the next etc",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7300,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_some_DASH__GT__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1073,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_dec,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$doc,"Same as (def name (core/fn [params* ] exprs*)) or (def\n    name (core/fn ([params* ] exprs*)+)) with any doc-string or attrs added\n    to the var metadata. prepost-map defines a map with optional keys\n    :pre and :post that contain collections of pre or post conditions.",cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc_DASH_string_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$params_STAR_], null),cljs.core.cst$sym$prepost_DASH_map_QMARK_,cljs.core.cst$sym$body], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc_DASH_string_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$params_STAR_], null),cljs.core.cst$sym$prepost_DASH_map_QMARK_,cljs.core.cst$sym$body),cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$attr_DASH_map_QMARK_], null)),cljs.core.cst$kw$line,3277,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defn,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1058,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_float,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$obj], null)),cljs.core.cst$kw$line,919,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_in,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ty], null)),cljs.core.cst$kw$line,2887,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_es6_DASH_iterable,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$idx,cljs.core.cst$sym$ret,cljs.core.cst$sym$expr], null)),cljs.core.cst$kw$doc,"Maps an expression across an array a, using an index named idx, and\n  return value named ret, initialized to a clone of a, then setting\n  each element of ret to the evaluation of expr, returning the new\n  array ret.",cljs.core.cst$kw$line,2681,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_amap,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Like require, but referring vars specified by the mandatory\n  :only option.\n\n  Example:\n\n  The following would load the library clojure.set while referring\n  the intersection var.\n\n  (use '[clojure.set :only [intersection]])",cljs.core.cst$kw$line,3023,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_use,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$names], null)),cljs.core.cst$kw$doc,"defs the supplied var names with no bindings, useful for making forward declarations.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,2667,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_declare,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1109,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__DASH_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,2633,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_hash_DASH_set,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$next], null)),cljs.core.cst$kw$doc,"Evaluates exprs one at a time, from left to right. If a form\n  returns a logical true value, or returns that value and doesn't\n  evaluate any of the other expressions, otherwise it returns the\n  value of the last expression. (or) returns nil.",cljs.core.cst$kw$line,878,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_or,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type_DASH_sym,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"Extend a type to a series of protocols. Useful when you are\n  supplying the definitions explicitly inline. Propagates the\n  type as a type hint on the first argument of all fns.\n\n  type-sym may be\n\n   * default, meaning the definitions will apply for any value,\n     unless an extend-type exists for one of the more specific\n     cases below.\n   * nil, meaning the definitions will apply for the nil value.\n   * any of object, boolean, number, string, array, or function,\n     indicating the definitions will apply for values of the\n     associated base JavaScript types. Note that, for example,\n     string should be used instead of js/String.\n   * a JavaScript type not covered by the previous list, such\n     as js/RegExp.\n   * a type defined by deftype or defrecord.\n\n  (extend-type MyType\n    ICounted\n    (-count [c] ...)\n    Foo\n    (bar [x y] ...)\n    (baz ([x] ...) ([x y] ...) ...)",cljs.core.cst$kw$line,1608,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_extend_DASH_type,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted], null)),cljs.core.cst$kw$doc,"If form represents a macro form, returns its expansion,\n  else returns form.",cljs.core.cst$kw$line,3067,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_macroexpand_DASH_1,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1218,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_test,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fn_DASH_tail], null)),cljs.core.cst$kw$doc,"Creates and installs a new method of multimethod associated with dispatch-value. ",cljs.core.cst$kw$line,2780,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defmethod,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr], null)),cljs.core.cst$kw$doc,"Evaluates expr and prints the time it took. Returns the value of expr.",cljs.core.cst$kw$line,2785,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_time,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1161,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_zero_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Loads libs, skipping any that are already loaded. Each argument is\n  either a libspec that identifies a lib or a flag that modifies how all the identified\n  libs are loaded. Use :require in the ns macro in preference to calling this\n  directly.\n\n  Libs\n\n  A 'lib' is a named set of resources in classpath whose contents define a\n  library of ClojureScript code. Lib names are symbols and each lib is associated\n  with a ClojureScript namespace. A lib's name also locates its root directory\n  within classpath using Java's package name to classpath-relative path mapping.\n  All resources in a lib should be contained in the directory structure under its\n  root directory. All definitions a lib makes should be in its associated namespace.\n\n  'require loads a lib by loading its root resource. The root resource path\n  is derived from the lib name in the following manner:\n  Consider a lib named by the symbol 'x.y.z; it has the root directory\n  <classpath>/x/y/, and its root resource is <classpath>/x/y/z.clj. The root\n  resource should contain code to create the lib's namespace (usually by using\n  the ns macro) and load any additional lib resources.\n\n  Libspecs\n\n  A libspec is a lib name or a vector containing a lib name followed by\n  options expressed as sequential keywords and arguments.\n\n  Recognized options:\n  :as takes a symbol as its argument and makes that symbol an alias to the\n    lib's namespace in the current namespace.\n  :refer takes a list of symbols to refer from the namespace.\n  :refer-macros takes a list of macro symbols to refer from the namespace.\n  :include-macros true causes macros from the namespace to be required.\n  :rename specifies a map from referred var names to different\n    symbols (and can be used to prevent clashes)\n\n\n  Flags\n\n  A flag is a keyword.\n  Recognized flags: :reload, :reload-all, :verbose\n  :reload forces loading of all the identified libs even if they are\n    already loaded\n  :reload-all implies :reload and also forces loading of all libs that the\n    identified libs directly or indirectly load via require or use\n  :verbose triggers printing information about each load, alias, and refer\n\n  Example:\n\n  The following would load the library clojure.string :as string.\n\n  (require '[clojure.string :as string])",cljs.core.cst$kw$line,2963,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_require,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1076,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_dec_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Expands into code that creates a fn that expects to be passed an\n  object and any args and calls the named instance method on the\n  object passing the args. Use when you want to treat a JavaScript\n  method as a first-class fn.",cljs.core.cst$kw$line,378,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_memfn,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$rest], null)),cljs.core.cst$kw$line,2656,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_obj,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,889,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_nil_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$specs], null)),cljs.core.cst$kw$doc,"Useful when you want to provide several implementations of the same\n  protocol all at once. Takes a single protocol and the implementation\n  of that protocol for one or more types. Expands into calls to\n  extend-type:\n\n  (extend-protocol Protocol\n    AType\n      (foo [x] ...)\n      (bar [x y] ...)\n    BType\n      (foo [x] ...)\n      (bar [x y] ...)\n    AClass\n      (foo [x] ...)\n      (bar [x y] ...)\n    nil\n      (foo [x] ...)\n      (bar [x y] ...))\n\n  expands into:\n\n  (do\n   (clojure.core/extend-type AType Protocol \n     (foo [x] ...) \n     (bar [x y] ...))\n   (clojure.core/extend-type BType Protocol \n     (foo [x] ...) \n     (bar [x y] ...))\n   (clojure.core/extend-type AClass Protocol \n     (foo [x] ...) \n     (bar [x y] ...))\n   (clojure.core/extend-type nil Protocol \n     (foo [x] ...) \n     (bar [x y] ...)))",cljs.core.cst$kw$file,"clojure/core_deftype.clj",cljs.core.cst$kw$line,831,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_extend_DASH_protocol,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),cljs.core.cst$kw$doc,"Takes an expression and a set of test/form pairs. Threads expr (via ->)\n  through each form for which the corresponding test\n  expression is true. Note that, unlike cond branching, cond-> threading does\n  not short circuit after the first true test expression.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7240,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_cond_DASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"bindings => name n\n\n  Repeatedly executes body (presumably for side-effects) with name\n  bound to integers from 0 through n-1.",cljs.core.cst$kw$line,2709,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_dotimes,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1188,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_and,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"reify is a macro with the following structure:\n\n (reify options* specs*)\n\n  Currently there are no options.\n\n  Each spec consists of the protocol name followed by zero\n  or more method bodies:\n\n  protocol\n  (methodName [args+] body)*\n\n  Methods should be supplied for all methods of the desired\n  protocol(s). You can also define overrides for Object methods. Note that\n  the first parameter must be supplied to correspond to the target object\n  ('this' in JavaScript parlance). Note also that recur calls\n  to the method head should *not* pass the target object, it will be supplied\n  automatically and can not be substituted.\n\n  recur works to method heads The method bodies of reify are lexical\n  closures, and can refer to the surrounding local scope:\n\n  (str (let [f \"foo\"]\n       (reify Object\n         (toString [this] f))))\n  == \"foo\"\n\n  (seq (let [f \"foo\"]\n       (reify ISeqable\n         (-seq [this] (seq f)))))\n  == (\"f\" \"o\" \"o\"))\n\n  reify always implements IMeta and IWithMeta and transfers meta\n  data of the form to the created object.\n\n  (meta ^{:k :v} (reify Object (toString [this] \"foo\")))\n  == {:k :v}",cljs.core.cst$kw$line,1311,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_reify,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,991,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_instance_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)),cljs.core.cst$kw$line,3064,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_load_DASH_file_STAR_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$init], null)),cljs.core.cst$kw$doc,"defs name to have the root value of init iff the named var has no root value,\n  else init is unevaluated",cljs.core.cst$kw$line,617,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defonce,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1067,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_add,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$macro,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$cljs$core_SLASH_rfn,"cljs/core.cljc",1,1280,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f1,cljs.core.cst$sym$k], null),cljs.core.cst$sym$fkv], null)),"Builds 3-arity reducing fn given names of wrapped fn and key, and k/v impl."]),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b], null)),cljs.core.cst$kw$line,988,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_identical_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1079,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_divide_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$decls], null)),cljs.core.cst$kw$doc,"same as defn, yielding non-public def",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,4743,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defn_DASH_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$psym,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$doc_PLUS_methods], null)),cljs.core.cst$kw$doc,"A protocol is a named set of named methods and their signatures:\n\n  (defprotocol AProtocolName\n    ;optional doc string\n    \"A doc string for AProtocol abstraction\"\n\n  ;method signatures\n    (bar [this a b] \"bar docs\")\n    (baz [this a] [this a b] [this a b c] \"baz docs\"))\n\n  No implementations are provided. Docs can be specified for the\n  protocol overall and for each method. The above yields a set of\n  polymorphic functions and a protocol object. All are\n  namespace-qualified by the ns enclosing the definition The resulting\n  functions dispatch on the type of their first argument, which is\n  required and corresponds to the implicit target object ('this' in\n  JavaScript parlance). defprotocol is dynamic, has no special compile-time\n  effect, and defines no new types.\n\n  (defprotocol P\n    (foo [this])\n    (bar-me [this] [this y]))\n\n  (deftype Foo [a b c]\n    P\n    (foo [this] a)\n    (bar-me [this] b)\n    (bar-me [this y] (+ c y)))\n\n  (bar-me (Foo. 1 2 3) 42)\n  => 45\n\n  (foo\n    (let [x 42]\n      (reify P\n        (foo [this] 17)\n        (bar-me [this] x)\n        (bar-me [this y] x))))\n  => 17",cljs.core.cst$kw$line,1976,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defprotocol,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$line,2961,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_special_DASH_form,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1103,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_subtract,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$message], null)),cljs.core.cst$kw$doc,"Evaluates expr and throws an exception if it does not evaluate to\n  logical true.",cljs.core.cst$kw$line,2410,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_assert,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,954,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_true_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$rest], null)),cljs.core.cst$kw$line,2566,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_array,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$fnspecs,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"fnspec ==> (fname [params*] exprs) or (fname ([params*] exprs)+)\n\n  Takes a vector of function specs and a body, and generates a set of\n  bindings of functions to their names. All of the names are available\n  in all of the definitions of the functions, as well as the body.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,6297,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_letfn,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1120,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__SLASH_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash,cljs.core.cst$sym$shift], null)),cljs.core.cst$kw$line,1241,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bitpos,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1197,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_or,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,2602,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_vector,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1145,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__GT__EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Evaluates the exprs in a lexical context in which the symbols in\n  the binding-forms are bound to their respective init-exprs or parts\n  therein. Acts as a recur target.",cljs.core.cst$kw$line,779,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_loop,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1215,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_flip,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$num,cljs.core.cst$sym$div], null)),cljs.core.cst$kw$line,1182,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_mod,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Evaluates exprs in a context in which *print-fn* is bound to .append\n  on a fresh StringBuffer.  Returns the string created by any nested\n  printing calls.",cljs.core.cst$kw$line,2864,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_with_DASH_out_DASH_str,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$added,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$macro,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["1.0",cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$cljs$core_SLASH_condp,"cljs/core.cljc",1,2273,true,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),"Takes a binary predicate, an expression, and a set of clauses.\n  Each clause can take the form of either:\n\n  test-expr result-expr\n\n  test-expr :>> result-fn\n\n  Note :>> is an ordinary keyword.\n\n  For each clause, (pred test-expr expr) is evaluated. If it returns\n  logical true, the clause is a match. If a binary clause matches, the\n  result-expr is returned, if a ternary clause matches, its result-fn,\n  which must be a unary function, is called with the result of the\n  predicate as its argument, the result of that call being the return\n  value of condp. A single default expression can follow the clauses,\n  and its value will be returned if no clause matches. If no default\n  expression is provided and no clause matches, an Error is thrown."]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),cljs.core.cst$kw$doc,"Takes a set of test/expr pairs. It evaluates each test one at a\n  time.  If a test returns logical true, cond evaluates and returns\n  the value of the corresponding expr and doesn't evaluate any of the\n  other tests or exprs. (cond) returns nil.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,580,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_cond,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"When expr is not nil, threads it into the first form (via ->),\n  and when that result is not nil, through the next etc",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7286,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_some_DASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_ns], null)),cljs.core.cst$kw$doc,"Returns a map of the intern mappings for the namespace.",cljs.core.cst$kw$line,2923,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_interns,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$seq_DASH_exprs,cljs.core.cst$sym$body_DASH_expr], null)),cljs.core.cst$kw$doc,"List comprehension. Takes a vector of one or more\n   binding-form/collection-expr pairs, each followed by zero or more\n   modifiers, and yields a lazy sequence of evaluations of expr.\n   Collections are iterated in a nested fashion, rightmost fastest,\n   and nested coll-exprs can refer to bindings created in prior\n   binding-forms.  Supported modifiers are: :let [binding-form expr ...],\n   :while test, :when test.\n\n  (take 100 (for [x (range 100000000) y (range 1000000) :while (< y x)]  [x y]))",cljs.core.cst$kw$line,2423,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_for,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"binding => var-symbol init-expr\n\n  Creates new bindings for the (already-existing) vars, with the\n  supplied initial values, executes the exprs in an implicit do, then\n  re-establishes the bindings that existed before.  The new bindings\n  are made in parallel (unlike let); all init-exprs are evaluated\n  before the vars are bound to their new values.",cljs.core.cst$kw$line,2260,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_binding,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$kvs], null)),cljs.core.cst$kw$line,2613,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_array_DASH_map,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1061,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_byte,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_ns], null)),cljs.core.cst$kw$doc,"Returns a map of the import mappings for the namespace.",cljs.core.cst$kw$line,2909,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_imports,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc_DASH_string_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$params_STAR_], null),cljs.core.cst$sym$body], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc_DASH_string_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$params_STAR_], null),cljs.core.cst$sym$body),cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$attr_DASH_map_QMARK_], null)),cljs.core.cst$kw$doc,"Like defn, but the resulting function name is declared as a\n  macro and will be used as a macro by the compiler when it is\n  called.",cljs.core.cst$kw$line,3353,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defmacro,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1063,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_short,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1158,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_inc,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"binding => var-symbol temp-value-expr\n\n  Temporarily redefines vars while executing the body.  The\n  temp-value-exprs will be evaluated and each resulting value will\n  replace in parallel the root value of its var.  After the body is\n  executed, the root values of all the vars will be set back to their\n  old values. Useful for mocking out functions during testing.",cljs.core.cst$kw$line,2236,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_with_DASH_redefs,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1212,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_clear,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$line,2956,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_locking,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,2593,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_list,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1050,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__PLUS_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null)),cljs.core.cst$kw$line,1022,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_aset,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$docstring_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,cljs.core.cst$sym$dispatch_DASH_fn,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$options], null)),cljs.core.cst$kw$doc,"Creates a new multimethod with the associated dispatch function.\n  The docstring and attribute-map are optional.\n\n  Options are key-value pairs and may be one of:\n    :default    the default dispatch value, defaults to :default\n    :hierarchy  the isa? hierarchy to use for dispatching\n                defaults to the global hierarchy",cljs.core.cst$kw$line,2733,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defmulti,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ys], null)),cljs.core.cst$kw$line,842,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_str,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$line,901,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_coercive_DASH__EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$kvs], null)),cljs.core.cst$kw$line,2623,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_hash_DASH_map,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$num_DASH_args,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$line,2860,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_gen_DASH_apply_DASH_to_DASH_simple,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$then], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$then,cljs.core.cst$sym$else,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$oldform], null)),cljs.core.cst$kw$doc,"bindings => binding-form test\n\n  If test is true, evaluates then with binding-form bound to the value of \n  test, if not, yields else",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1749,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_if_DASH_let,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,957,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_false_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$e,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),cljs.core.cst$kw$doc,"Takes an expression, and a set of clauses.\n\n  Each clause can take the form of either:\n\n  test-constant result-expr\n\n  (test-constant1 ... test-constantN)  result-expr\n\n  The test-constants are not evaluated. They must be compile-time\n  literals, and need not be quoted.  If the expression is equal to a\n  test-constant, the corresponding result-expr is returned. A single\n  default expression can follow the clauses, and its value will be\n  returned if no clause matches. If no default expression is provided\n  and no clause matches, an Error is thrown.\n\n  Unlike cond and condp, case does a constant-time dispatch, the\n  clauses are not considered sequentially.  All manner of constant\n  expressions are acceptable in case, including numbers, strings,\n  symbols, keywords, and (ClojureScript) composites thereof. Note that since\n  lists are used to group multiple constants that map to the same\n  expression, a vector can be used to match a list if needed. The\n  test-constants need not be all of the same type.",cljs.core.cst$kw$line,2336,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_case,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Return true if argument exists, analogous to usage of typeof operator\n   in JavaScript.",cljs.core.cst$kw$line,966,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_exists_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1185,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1056,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_byte,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1170,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_max,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1150,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__EQ__EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$doc,"Expands to code which yields a lazy sequence of the concatenation\n  of the supplied colls.  Each coll expr is not evaluated until it is\n  needed.\n\n  (lazy-cat xs ys zs) === (concat (lazy-seq xs) (lazy-seq ys) (lazy-seq zs))",cljs.core.cst$kw$line,2875,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_lazy_DASH_cat,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Ignores body, yields nil",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,4555,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_comment,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$dest], null)),cljs.core.cst$kw$line,3137,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_copy_DASH_arguments,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,2407,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_assert,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$t,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"EXPERIMENTAL: Subject to change. Unsafely cast a value to a different type.",cljs.core.cst$kw$line,943,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unsafe_DASH_cast,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_sym], null)),cljs.core.cst$kw$doc,"Returns the var to which a symbol will be resolved in the namespace else nil.",cljs.core.cst$kw$line,3399,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_resolve,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$rsym,cljs.core.cst$sym$fields,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"(defrecord name [fields*]  options* specs*)\n\n  Currently there are no options.\n\n  Each spec consists of a protocol or interface name followed by zero\n  or more method bodies:\n\n  protocol-or-Object\n  (methodName [args*] body)*\n\n  The record will have the (immutable) fields named by\n  fields, which can have type hints. Protocols and methods\n  are optional. The only methods that can be supplied are those\n  declared in the protocols.  Note that method bodies are\n  not closures, the local environment includes only the named fields,\n  and those fields can be accessed directly.\n\n  Method definitions take the form:\n\n  (methodname [args*] body)\n\n  The argument and return types can be hinted on the arg and\n  methodname symbols. If not supplied, they will be inferred, so type\n  hints should be reserved for disambiguation.\n\n  Methods should be supplied for all methods of the desired\n  protocol(s). You can also define overrides for\n  methods of Object. Note that a parameter must be supplied to\n  correspond to the target object ('this' in JavaScript parlance). Note also\n  that recur calls to the method head should *not* pass the target object, it\n  will be supplied automatically and can not be substituted.\n\n  In the method bodies, the (unqualified) name can be used to name the\n  class (for calls to new, instance? etc).\n\n  The type will have implementations of several ClojureScript\n  protocol generated automatically: IMeta/IWithMeta (metadata support) and\n  IMap, etc.\n\n  In addition, defrecord will define type-and-value-based =,\n  and will define ClojureScript IHash and IEquiv.\n\n  Two constructors will be defined, one taking the designated fields\n  followed by a metadata map (nil for none) and an extension field\n  map (nil for none), and one taking only the fields (using nil for\n  meta and extension fields). Note that the field names __meta\n  and __extmap are currently reserved and should not be used when\n  defining your own records.\n\n  Given (defrecord TypeName ...), two factory functions will be\n  defined: ->TypeName, taking positional parameters for the fields,\n  and map->TypeName, taking a map of keywords to field values.",cljs.core.cst$kw$line,1907,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defrecord,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$size], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$size,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more_DASH_sizes], null)),cljs.core.cst$kw$line,2575,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_make_DASH_array,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1097,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_negate_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1082,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_inc,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$next], null)),cljs.core.cst$kw$doc,"Evaluates exprs one at a time, from left to right. If a form\n  returns logical false (nil or false), and returns that value and\n  doesn't evaluate any of the other expressions, otherwise it returns\n  the value of the last expr. (and) returns true.",cljs.core.cst$kw$line,867,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_and,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1000,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_number_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comment], null)),cljs.core.cst$kw$doc,"Emit a top-level JavaScript multi-line comment. New lines will create a\n  new comment line. Comment block will be preceded and followed by a newline",cljs.core.cst$kw$line,929,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_comment,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1003,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_symbol_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"bindings => binding-form test\n\n   When test is not nil, evaluates body with binding-form bound to the\n   value of test",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1804,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_some,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1062,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_char,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Similar to require but only for macros.",cljs.core.cst$kw$line,3018,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_require_DASH_macros,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"Threads the expr through the forms. Inserts x as the\n  last item in the first form, making a list of it if it is not a\n  list already. If there are more forms, inserts the first form as the\n  last item in second form, etc.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1602,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__DASH__GT__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comment], null)),cljs.core.cst$kw$doc,"Emit an inline JavaScript comment.",cljs.core.cst$kw$line,949,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_inline_DASH_comment,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Refers to all the public vars of `cljs.core`, subject to\n  filters.\n  Filters can include at most one each of:\n\n  :exclude list-of-symbols\n  :rename map-of-fromsymbol-tosymbol\n\n  Filters can be used to select a subset, via exclusion, or to provide a mapping\n  to a symbol different from the var's name, in order to prevent clashes.",cljs.core.cst$kw$line,3050,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_refer_DASH_clojure,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null)]),cljs.core.cst$sym$cljs$core,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$StringBuffer,cljs.core.cst$sym$goog$string$StringBuffer], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$gstring,cljs.core.cst$sym$goog$string,cljs.core.cst$sym$goog$Uri,cljs.core.cst$sym$garray,cljs.core.cst$sym$goog$object,cljs.core.cst$sym$goog$math$Integer,cljs.core.cst$sym$StringBuffer,cljs.core.cst$sym$gobject,cljs.core.cst$sym$goog$array,cljs.core.cst$sym$goog$math$Long],[cljs.core.cst$sym$goog$string,cljs.core.cst$sym$goog$string,cljs.core.cst$sym$goog$Uri,cljs.core.cst$sym$goog$array,cljs.core.cst$sym$goog$object,cljs.core.cst$sym$goog$math$Integer,cljs.core.cst$sym$goog$string$StringBuffer,cljs.core.cst$sym$goog$object,cljs.core.cst$sym$goog$array,cljs.core.cst$sym$goog$math$Long]),null,cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentHashSet,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentHashSet."], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH__GT_clj,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null))),cljs.core.cst$kw$doc,"Recursively transforms JavaScript arrays into ClojureScript\n  vectors, and JavaScript objects into ClojureScript maps.  With\n  option ':keywordize-keys true' will convert object fields from\n  strings to keywords.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$sort_DASH_by,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a sorted sequence of the items in coll, where the sort\n   order is determined by comparing (keyfn item).  Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ITransientAssociative,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll with a mapping from key to\n     val added to it."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll with a mapping from key to\n     val added to it."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding associativity to transient collections.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$chunk_DASH_first,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$print_DASH_meta_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts,cljs.core.cst$sym$obj], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$m3_DASH_hash_DASH_int,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$in], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_str_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$obj,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null))], null))),cljs.core.cst$kw$doc,"Support so that collections can implement toString without\n   loading all the printing machinery."], null)),cljs.core.with_meta(cljs.core.cst$sym$eduction,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform_STAR_,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a reducible/iterable application of the transducers\n  to the items in coll. Transducers are applied in order as if\n  combined with comp. Note that these applications will be\n  performed every time reduce/iterator is called.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$xforms)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xforms], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$tree_DASH_seq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$branch_QMARK_,cljs.core.cst$sym$children,cljs.core.cst$sym$root], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the nodes in a tree, via a depth-first walk.\n  branch? must be a fn of one arg that returns true if passed a node\n  that can have children (but may not).  children must be a fn of one\n  arg that returns a sequence of the children. Will only be called on\n  nodes for which branch? returns true. Root is the root node of the\n  tree."], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_remainder_DASH_int,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$seq,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a seq on the collection. If the collection is\n  empty, returns nil.  (seq nil) returns nil. seq also works on\n  Strings."], null)),cljs.core.with_meta(cljs.core.cst$sym$Volatile,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IVolatile,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$reduce,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$IUUID,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$sigs,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$doc,"A marker protocol for UUIDs",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.cst$sym$INIT,cljs.core.with_meta(cljs.core.cst$sym$find_DASH_ns,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns], null))),cljs.core.cst$kw$doc,"Returns the namespace named by the symbol or nil if it doesn't exist.\n  Bootstrap only."], null)),cljs.core.with_meta(cljs.core.cst$sym$contains_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Returns true if key is present in the given collection, otherwise\n  returns false.  Note that for numerically indexed collections like\n  vectors and arrays, this tests if the numeric key is within the\n  range of indexes. 'contains?' operates constant or logarithmic time;\n  it will not perform a linear search for a value.  See also 'some'."], null)),cljs.core.with_meta(cljs.core.cst$sym$every_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns true if (pred x) is logical true for every x in coll, else\n  false."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ES6IteratorSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ES6IteratorSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$Var,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_Fn,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$keep_DASH_indexed,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the non-nil results of (f index item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a stateful transducer when no collection is\n  provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentQueueSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentQueueSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$subs,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null))),cljs.core.cst$kw$doc,"Returns the substring of s beginning at start inclusive, and ending\n  at end (defaults to length of string), exclusive.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is an instance of Symbol"], null)),cljs.core.with_meta(cljs.core.cst$sym$IFind,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the map entry for key, or nil if key not present."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_find,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_find,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),cljs.core.cst$kw$doc,"Returns the map entry for key, or nil if key not present."], null)], null),cljs.core.cst$kw$doc,"Protocol for implementing entry finding in collections.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$set,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a set of the distinct elements of coll."], null)),cljs.core.cst$sym$MODULE_URIS,cljs.core.with_meta(cljs.core.cst$sym$compare_DASH_indexed,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,4,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,4,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Compare indexed collection."], null)),cljs.core.with_meta(cljs.core.cst$sym$take_DASH_last,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a seq of the last n items in coll.  Depending on the type\n  of coll may be no better than linear time.  For vectors, see also subvec."], null)),cljs.core.with_meta(cljs.core.cst$sym$IndexedSeq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_set,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Set bit at index n"], null)),cljs.core.cst$sym$string_DASH_hash_DASH_cache_DASH_count,cljs.core.with_meta(cljs.core.cst$sym$qualified_DASH_keyword_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a keyword with a namespace"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Eduction,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Eduction."], null)),cljs.core.with_meta(cljs.core.cst$sym$tree_DASH_map_DASH_add,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$k,cljs.core.cst$sym$v,cljs.core.cst$sym$found], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ES6SetEntriesIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ES6SetEntriesIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_with_DASH_meta,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$meta], null))),cljs.core.cst$kw$doc,"Returns a new object with value of o and metadata meta added to it."], null)),cljs.core.with_meta(cljs.core.cst$sym$reset_DASH_cache,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$cached_DASH_hierarchy,cljs.core.cst$sym$hierarchy], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentArrayMapIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$cnt], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentArrayMapIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentArrayMapIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$butlast,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Return a seq of all but the last item in coll, in linear time"], null)),cljs.core.with_meta(cljs.core.cst$sym$tail_DASH_off,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_subtract_DASH_int,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"If no ys are supplied, returns the negation of x, else subtracts\n  the ys from x and returns the result."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_iterator,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IIterable,cljs.core.cst$kw$doc,"Returns an iterator for coll.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_namespace_DASH_maps_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"*print-namespace-maps* controls whether the printer will print\n  namespace map literal syntax.\n\n  Defaults to false, but the REPL binds it to true."], null)),cljs.core.with_meta(cljs.core.cst$sym$take_DASH_nth,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$pre,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n)], null)], null)),cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$pre,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n)], null)], null)))),cljs.core.cst$kw$doc,"Returns a lazy seq of every nth item in coll.  Returns a stateful\n  transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$first,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns the first item in the collection. Calls seq on its\n  argument. If coll is nil, returns nil."], null)),cljs.core.with_meta(cljs.core.cst$sym$native_DASH_satisfies_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Internal - do not use!"], null)),cljs.core.with_meta(cljs.core.cst$sym$seq_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Return true if s satisfies ISeq"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_global_DASH_hierarchy,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$UUID,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null",cljs.core.cst$sym$cljs$core_SLASH_IUUID,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_sorted_DASH_seq_DASH_from,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISorted,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$ascending_QMARK_], null))),cljs.core.cst$kw$doc,"Returns a sorted seq from coll in either ascending or descending order.\n     If ascending is true, the result should contain all items which are > or >=\n     than k. If ascending is false, the result should contain all items which\n     are < or <= than k, e.g.\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)"], null)),cljs.core.with_meta(cljs.core.cst$sym$println_DASH_str,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null))),cljs.core.cst$kw$doc,"println to a string, returning it",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$inst_DASH_ms,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inst], null))),cljs.core.cst$kw$doc,"Return the number of milliseconds since January 1, 1970, 00:00:00 GMT"], null)),cljs.core.with_meta(cljs.core.cst$sym$linear_DASH_traversal_DASH_nth,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$iterate,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects",cljs.core.cst$kw$added,"1.0"], null)),cljs.core.with_meta(cljs.core.cst$sym$checked_DASH_aget_SINGLEQUOTE_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$pre,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$or,cljs.core.list(cljs.core.cst$sym$array_QMARK_,cljs.core.cst$sym$array),cljs.core.list(cljs.core.cst$sym$goog_SLASH_isArrayLike,cljs.core.cst$sym$array)),cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$idx),cljs.core.list(cljs.core.cst$sym$not,cljs.core.list(cljs.core.cst$sym$neg_QMARK_,cljs.core.cst$sym$idx)),cljs.core.list(cljs.core.cst$sym$_LT_,cljs.core.cst$sym$idx,cljs.core.list(cljs.core.cst$sym$alength,cljs.core.cst$sym$array))], null)], null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_empty,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,cljs.core.cst$kw$doc,"Returns an empty collection of the same category as coll. Used\n     by cljs.core/empty.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$newline,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null))),cljs.core.cst$kw$doc,"Prints a newline using *print-fn*",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,1,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ILookup,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_lookup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Use k to look up a value in o. If not-found is supplied and k is not\n     a valid value that can be used for look up, not-found is returned."], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_lookup,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_lookup,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$doc,"Use k to look up a value in o. If not-found is supplied and k is not\n     a valid value that can be used for look up, not-found is returned."], null)], null),cljs.core.cst$kw$doc,"Protocol for looking up a value in a data structure.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_chunked_DASH_rest,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,cljs.core.cst$kw$doc,"Return a new collection of coll with the first chunk removed.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$write_DASH_all,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ss], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$writer,cljs.core.cst$sym$ss)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ss], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$fn_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Return true if f is a JavaScript function or satisfies the Fn protocol."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_prefer_DASH_method,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$dispatch_DASH_val_DASH_y], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IAssociative,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Returns a new collection of coll with a mapping from key k to\n     value v added to it."], null)),cljs.core.with_meta(cljs.core.cst$sym$doall,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. doall can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, retains the head and returns it, thus causing the entire\n  seq to reside in memory at one time.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$keyword_DASH_identical_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),cljs.core.cst$kw$doc,"Efficient test to determine that two keywords are identical."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_err_DASH_fn_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$doc,"Each runtime environment provides a different way to print error output.\n  Whatever function *print-err-fn* is bound to will be passed any\n  Strings which should be printed.",cljs.core.cst$kw$dynamic,true], null)),cljs.core.with_meta(cljs.core.cst$sym$pv_DASH_aset,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$prefers,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null))),cljs.core.cst$kw$doc,"Given a multimethod, returns a map of preferred value -> set of other values"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_js_DASH__GT_clj,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IEncodeClojure,cljs.core.cst$kw$doc,"Transforms JavaScript values to Clojure",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$options], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$LazySeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$dedupe,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence removing consecutive duplicates in coll.\n  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,1,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_editable_DASH_array_DASH_for,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tv,cljs.core.cst$sym$i], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ES6Iterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ES6Iterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$VectorNode,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$dissoc,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null))),cljs.core.cst$kw$doc,"dissoc[iate]. Returns a new map of the same (hashed/sorted) type,\n  that does not contain a mapping for key(s).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$atom,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$validator], null)], null)], null))),cljs.core.cst$kw$doc,"Creates and returns an Atom with an initial value of x and zero or\n  more options (in any order):\n\n  :meta metadata-map\n\n  :validator validate-fn\n\n  If metadata-map is supplied, it will become the metadata on the\n  atom. validate-fn must be nil or a side-effect-free fn of one\n  argument, which will be passed the intended new state on any state\n  change. If the new state is unacceptable, the validate-fn should\n  return false or throw an Error.  If either of these error conditions\n  occur, then the value of the atom will not change.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$validator], null)], null)], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_shift_DASH_right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Bitwise shift right"], null)),cljs.core.with_meta(cljs.core.cst$sym$MapEntry,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.cst$sym$_STAR_clojurescript_DASH_version_STAR_,cljs.core.with_meta(cljs.core.cst$sym$_DASH_first,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISeq,cljs.core.cst$kw$doc,"Returns the first item in the collection coll. Used by cljs.core/first.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$peek,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"For a list or queue, same as first, for a vector, same as, but much\n  more efficient than, last. If the collection is empty, returns nil."], null)),cljs.core.with_meta(cljs.core.cst$sym$IKVReduce,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_kv_DASH_reduce,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Reduces an associative collection and returns the result. f should be\n     a function that takes three arguments."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_kv_DASH_reduce,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_kv_DASH_reduce,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)),cljs.core.cst$kw$doc,"Reduces an associative collection and returns the result. f should be\n     a function that takes three arguments."], null)], null),cljs.core.cst$kw$doc,"Protocol for associative types that can reduce themselves\n  via a function of key and val. Called by cljs.core/reduce-kv.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$iter_DASH_reduce,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$aget,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null))),cljs.core.cst$kw$doc,"Returns the value at the index/indices. Works on JavaScript arrays.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentTreeMapSeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_write,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IWriter,cljs.core.cst$kw$doc,"Writes s with writer and returns the result.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$s], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$mk_DASH_bound_DASH_fn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$last,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Return the last item in coll, in linear time"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_default_DASH_dispatch_DASH_val,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$pr,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null))),cljs.core.cst$kw$doc,"Prints the object(s) using string-print.  Prints the\n  object(s), separated by spaces if there is more than one.\n  By default, pr and prn print in a way that objects can be\n  read by the reader",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$tree_DASH_map_DASH_seq_DASH_push,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$stack,cljs.core.with_meta(cljs.core.cst$sym$ascending_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null))], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$namespace,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns the namespace String of a symbol or keyword, or nil if not present."], null)),cljs.core.with_meta(cljs.core.cst$sym$empty_DASH_unordered_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$private,true], null)),cljs.core.with_meta(cljs.core.cst$sym$obj_DASH_map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null))),cljs.core.cst$kw$doc,"keyval => key val\n  Returns a new object map with supplied mappings.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$keyvals)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$Reduced,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_conj,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ICollection,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$o], null))),cljs.core.cst$kw$doc,"Returns a new collection of coll with o added to it. The new item\n     should be added to the most efficient place, e.g.\n     (conj [1 2 3 4] 5) => [1 2 3 4 5]\n     (conj '(2 3 4 5) 1) => '(1 2 3 4 5)"], null)),cljs.core.with_meta(cljs.core.cst$sym$NodeSeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$ITransientMap,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_dissoc_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll without the mapping for key."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_dissoc_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_dissoc_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key], null)),cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll without the mapping for key."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding mapping functionality to transient collections.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$push_DASH_tail,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$level,cljs.core.cst$sym$parent,cljs.core.cst$sym$tailnode], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$take,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$pre,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n)], null)], null)),cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$pre,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n)], null)], null)))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the first n items in coll, or all items if\n  there are fewer than n.  Returns a stateful transducer when\n  no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$vector_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies IVector"], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_equiv_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$bitmap_DASH_indexed_DASH_node_DASH_index,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bitmap,cljs.core.cst$sym$bit], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$IChunk,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_drop_DASH_first,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Return a new chunk of coll with the first item removed."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_drop_DASH_first,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_drop_DASH_first,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Return a new chunk of coll with the first item removed."], null)], null),cljs.core.cst$kw$doc,"Protocol for accessing the items of a chunk.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_shift_DASH_left,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Bitwise shift left"], null)),cljs.core.with_meta(cljs.core.cst$sym$random_DASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.with_meta(cljs.core.cst$sym$any_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if given any argument."], null)),cljs.core.with_meta(cljs.core.cst$sym$rand_DASH_int,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Returns a random integer between 0 (inclusive) and n (exclusive)."], null)),cljs.core.with_meta(cljs.core.cst$sym$aclone,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null))),cljs.core.cst$kw$doc,"Returns a javascript array, cloned from the passed in array"], null)),cljs.core.with_meta(cljs.core.cst$sym$BlackNode,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$vreset_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vol,cljs.core.cst$sym$newval], null))),cljs.core.cst$kw$doc,"Sets the value of volatile to newval without regard for the\n   current value. Returns newval."], null)),cljs.core.with_meta(cljs.core.cst$sym$chunk,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$b], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$t_cljs$core2273,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$anonymous,true,cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$UNREALIZED_DASH_SEED,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$private,true], null)),cljs.core.with_meta(cljs.core.cst$sym$dec,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns a number one less than num."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_TransformerIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buffer,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$completed,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$xf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$sourceIter,cljs.core.cst$sym$multi], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/TransformerIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$APersistentVector,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$sigs,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$doc,"Marker protocol",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$juxt,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null))),cljs.core.cst$kw$doc,"Takes a set of functions and returns a fn that is the juxtaposition\n  of those fns.  The returned fn takes a variable number of args, and\n  returns a vector containing the result of applying each fn to the\n  args (left-to-right).\n  ((juxt a b c) x) => [(a x) (b x) (c x)]",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentQueueIter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$riter], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentQueueIter."], null)),cljs.core.with_meta(cljs.core.cst$sym$_LT_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns non-nil if nums are in monotonically increasing order,\n  otherwise false."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_eval_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$doc,"Runtime environments may provide a way to evaluate ClojureScript\n  forms. Whatever function *eval* is bound to will be passed any forms which\n  should be evaluated.",cljs.core.cst$kw$dynamic,true], null)),cljs.core.with_meta(cljs.core.cst$sym$inode_DASH_kv_DASH_reduce,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$obj_DASH_map_DASH__GT_hash_DASH_map,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$test,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"test [v] finds fn at key :test in var metadata and calls it,\n  presuming failure will throw exception"], null)),cljs.core.with_meta(cljs.core.cst$sym$rest,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a possibly empty seq of the items after the first. Calls seq on its\n  argument."], null)),cljs.core.with_meta(cljs.core.cst$sym$ex_DASH_data,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ex], null))),cljs.core.cst$kw$doc,"Returns exception data (a map) if ex is an ExceptionInfo.\n  Otherwise returns nil."], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentArrayMapSeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_drop_DASH_first,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IChunk,cljs.core.cst$kw$doc,"Return a new chunk of coll with the first item removed.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$isa_QMARK_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null))),cljs.core.cst$kw$doc,"Returns true if (= child parent), or child is directly or indirectly derived from\n  parent, either via a JavaScript type inheritance relationship or a\n  relationship established via derive. h must be a hierarchy obtained\n  from make-hierarchy, if not supplied defaults to the global\n  hierarchy"], null)),cljs.core.with_meta(cljs.core.cst$sym$boolean_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a Boolean"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_clone,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ICloneable,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null))),cljs.core.cst$kw$doc,"Creates a clone of value."], null)),cljs.core.with_meta(cljs.core.cst$sym$munge,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$empty_DASH_ordered_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$private,true], null)),cljs.core.with_meta(cljs.core.cst$sym$DEMUNGE_MAP,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@enum {string}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ES6IteratorSeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_NeverEquiv,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY)),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/NeverEquiv."], null)),cljs.core.with_meta(cljs.core.cst$sym$re_DASH_seq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of successive matches of re in s."], null)),cljs.core.with_meta(cljs.core.cst$sym$char_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is a JavaScript string of length one."], null)),cljs.core.with_meta(cljs.core.cst$sym$make_DASH_hierarchy,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY)),cljs.core.cst$kw$doc,"Creates a hierarchy object for use with derive, isa? etc."], null)),cljs.core.with_meta(cljs.core.cst$sym$Symbol,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.cst$sym$PROTOCOL_SENTINEL,cljs.core.with_meta(cljs.core.cst$sym$tv_DASH_push_DASH_tail,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tv,cljs.core.cst$sym$level,cljs.core.cst$sym$parent,cljs.core.cst$sym$tail_DASH_node], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_reduce,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IReduce,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null))),cljs.core.cst$kw$doc,"f should be a function of 2 arguments. If start is not supplied,\n     returns the result of applying f to the first 2 items in coll, then\n     applying f to that result and the 3rd item, etc."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_count,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ICounted,cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Calculates the count of coll in constant time. Used by cljs.core/count."], null)),cljs.core.with_meta(cljs.core.cst$sym$swap_DASH_vals_BANG_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$added,"1.9",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Atomically swaps the value of atom to be:\n  (apply f current-value-of-atom args). Note that f may be called\n  multiple times, and thus should be free of side effects.\n  Returns [old new], the value of the atom before and after the swap."], null)),cljs.core.with_meta(cljs.core.cst$sym$keep,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the non-nil results of (f item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$char,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Coerce to char"], null)),cljs.core.with_meta(cljs.core.cst$sym$mapcat,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$added,"1.0",cljs.core.cst$kw$static,true,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null))),cljs.core.cst$kw$doc,"Returns the result of applying concat to the result of applying map\n  to f and colls.  Thus function f should return a collection. Returns\n  a transducer when no collections are provided"], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_long,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Coerce to long by stripping decimal places. Identical to `int'."], null)),cljs.core.cst$sym$m3_DASH_seed,cljs.core.with_meta(cljs.core.cst$sym$some_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is not nil, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_negate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$remove_DASH_tap,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Remove f from the tap set."], null)),cljs.core.with_meta(cljs.core.cst$sym$symbol_DASH_identical_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),cljs.core.cst$kw$doc,"Efficient test to determine that two symbols are identical."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_command_DASH_line_DASH_args_STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"A sequence of the supplied command line arguments, or nil if\n  none were supplied"], null)),cljs.core.with_meta(cljs.core.cst$sym$reverse,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a seq of the items in coll in reverse order. Not lazy."], null)),cljs.core.with_meta(cljs.core.cst$sym$inst_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies Inst"], null)),cljs.core.with_meta(cljs.core.cst$sym$range,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null))),cljs.core.cst$kw$doc,"Returns a lazy seq of nums from start (inclusive) to end\n   (exclusive), by step, where start defaults to 0, step to 1,\n   and end to infinity.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_count,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Counts the number of bits set in n"], null)),cljs.core.with_meta(cljs.core.cst$sym$create_DASH_node,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$sort,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a sorted sequence of the items in coll. Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_MetaFn,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_Fn,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/MetaFn."], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_inc_DASH_int,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_compare,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IComparable,cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),cljs.core.cst$kw$doc,"Returns a negative number, zero, or a positive number when x is logically\n     'less than', 'equal to', or 'greater than' y."], null)),cljs.core.with_meta(cljs.core.cst$sym$map_DASH_indexed,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence consisting of the result of applying f to 0\n  and the first item of coll, followed by applying f to 1 and the second\n  item in coll, etc, until coll is exhausted. Thus function f should\n  accept 2 arguments, index and item. Returns a stateful transducer when\n  no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_list,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.with_meta(cljs.core.cst$sym$rand_DASH_nth,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Return a random element of the (sequential) collection. Will have\n  the same performance characteristics as nth for the given\n  collection."], null)),cljs.core.with_meta(cljs.core.cst$sym$comp,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f1,cljs.core.cst$sym$f2,cljs.core.cst$sym$f3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null))),cljs.core.cst$kw$doc,"Takes a set of functions and returns a fn that is the composition\n  of those fns.  The returned fn takes a variable number of args,\n  applies the rightmost of fns to the args, the next\n  fn (right-to-left) to the result, etc.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f1,cljs.core.cst$sym$f2,cljs.core.cst$sym$f3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_chunk,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$dispatch_DASH_fn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null))),cljs.core.cst$kw$doc,"Given a multimethod, return its dispatch-fn."], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_shift_DASH_right_DASH_zero_DASH_fill,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"DEPRECATED: Bitwise shift right with zero fill"], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_reserved_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_as_DASH_transient,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a new, transient version of the collection, in constant time."], null)),cljs.core.with_meta(cljs.core.cst$sym$dorun,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. dorun can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, does not retain the head and returns nil.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_sequential_DASH_writer,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$simple_DASH_symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a symbol without a namespace"], null)),cljs.core.with_meta(cljs.core.cst$sym$accumulating_DASH_seq_DASH_count,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$IIndexed,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the value at the index n in the collection coll.\n     Returns not-found if index n is out of bounds and not-found is supplied."], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_nth,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_nth,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$doc,"Returns the value at the index n in the collection coll.\n     Returns not-found if index n is out of bounds and not-found is supplied."], null)], null),cljs.core.cst$kw$doc,"Protocol for collections to provide indexed-based access to their items.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$disj,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null))),cljs.core.cst$kw$doc,"disj[oin]. Returns a new set of the same (hashed/sorted) type, that\n  does not contain key(s).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$MultiIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$IPrintWithWriter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_pr_DASH_writer,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_pr_DASH_writer,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_pr_DASH_writer,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$doc,null], null)], null),cljs.core.cst$kw$doc,"The old IPrintable protocol's implementation consisted of building a giant\n   list of strings to concatenate.  This involved lots of concat calls,\n   intermediate vectors, and lazy-seqs, and was very slow in some older JS\n   engines.  IPrintWithWriter implements printing via the IWriter protocol, so it\n   be implemented efficiently in terms of e.g. a StringBuffer append.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_UUID,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null",cljs.core.cst$sym$cljs$core_SLASH_IUUID,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$uuid,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/UUID."], null)),cljs.core.with_meta(cljs.core.cst$sym$IVector,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_DASH_n,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new vector with value val added at position n."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$val], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_assoc_DASH_n,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_DASH_n,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$doc,"Returns a new vector with value val added at position n."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding vector functionality to collections.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$IIterable,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_iterator,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns an iterator for coll."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_iterator,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_iterator,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns an iterator for coll."], null)], null),cljs.core.cst$kw$doc,"Protocol for iterating over a collection.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_MultiIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iters], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/MultiIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_2,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"bound in a repl thread to the second most recent value printed"], null)),cljs.core.with_meta(cljs.core.cst$sym$eval,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$form], null))),cljs.core.cst$kw$doc,"Evaluates the form data structure (not text!) and returns the result.\n  Delegates to cljs.core/*eval*. Intended for use in self-hosted ClojureScript,\n  which sets up an implementation of cljs.core/*eval* for that environment."], null)),cljs.core.with_meta(cljs.core.cst$sym$Eduction,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$pv_DASH_clone_DASH_node,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$cons,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentTreeSet,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_HashSetIter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/HashSetIter."], null)),cljs.core.with_meta(cljs.core.cst$sym$ns_DASH_lookup,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns_DASH_obj,cljs.core.cst$sym$k], null))),cljs.core.cst$kw$doc,"Bootstrap only."], null)),cljs.core.with_meta(cljs.core.cst$sym$floats,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$TransientVector,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$pos_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if num is greater than zero, else false"], null)),cljs.core.with_meta(cljs.core.cst$sym$fnil,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null))),cljs.core.cst$kw$doc,"Takes a function f, and returns a function that calls f, replacing\n  a nil first argument to f with the supplied value x. Higher arity\n  versions can replace arguments in the second and third\n  positions (y, z). Note that the function f can take any number of\n  arguments, not just the one(s) being nil-patched.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,4,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,4,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$merge_DASH_with,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$maps], null))),cljs.core.cst$kw$doc,"Returns a map that consists of the rest of the maps conj-ed onto\n  the first.  If a key occurs in more than one map, the mapping(s)\n  from the latter (left-to-right) will be combined with the mapping in\n  the result by calling (f val-in-result val-in-latter).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$f,cljs.core.cst$sym$maps)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$maps], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$nthrest,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Returns the nth rest of coll, coll when n is 0."], null)),cljs.core.cst$sym$_STAR_warn_DASH_on_DASH_infer_STAR_,cljs.core.with_meta(cljs.core.cst$sym$_DASH_find,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IFind,cljs.core.cst$kw$doc,"Returns the map entry for key, or nil if key not present.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$sequential_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if coll satisfies ISequential"], null)),cljs.core.with_meta(cljs.core.cst$sym$tree_DASH_map_DASH_replace,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$checked_DASH_aset_SINGLEQUOTE_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$pre,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$or,cljs.core.list(cljs.core.cst$sym$array_QMARK_,cljs.core.cst$sym$array),cljs.core.list(cljs.core.cst$sym$goog_SLASH_isArrayLike,cljs.core.cst$sym$array)),cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$idx),cljs.core.list(cljs.core.cst$sym$not,cljs.core.list(cljs.core.cst$sym$neg_QMARK_,cljs.core.cst$sym$idx)),cljs.core.list(cljs.core.cst$sym$_LT_,cljs.core.cst$sym$idx,cljs.core.list(cljs.core.cst$sym$alength,cljs.core.cst$sym$array))], null)], null)),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$m3_DASH_mix_DASH_H1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h1,cljs.core.cst$sym$k1], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$RecordIter,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_TransientArrayMap,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$editable_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$len,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$arr], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/TransientArrayMap."], null)),cljs.core.with_meta(cljs.core.cst$sym$re_DASH_seq_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$prim_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_level_STAR_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"*print-level* controls how many levels deep the printer will\n  print nested objects. If it is bound to logical false, there is no\n  limit. Otherwise, it must be bound to an integer indicating the maximum\n  level to print. Each argument to print is at level 0; if an argument is a\n  collection, its items are at level 1; and so on. If an object is a\n  collection and is at a level greater than or equal to the value bound to\n  *print-level*, the printer prints '#' to represent it. The root binding\n  is nil indicating no limit.",cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {null|number}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$shuffle,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Return a random permutation of coll"], null)),cljs.core.with_meta(cljs.core.cst$sym$ChunkedSeq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_keyword,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$find,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null))),cljs.core.cst$kw$doc,"Returns the map entry for key, or nil if key not present."], null)),cljs.core.with_meta(cljs.core.cst$sym$alength,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null))),cljs.core.cst$kw$doc,"Returns the length of the array. Works on arrays of all types."], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_xor,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Bitwise exclusive or",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_IndexedSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/IndexedSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$ObjMap,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$unsigned_DASH_bit_DASH_shift_DASH_right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Bitwise shift right with zero fill"], null)),cljs.core.with_meta(cljs.core.cst$sym$ES6SetEntriesIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$neg_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if num is less than zero, else false"], null)),cljs.core.with_meta(cljs.core.cst$sym$Cons,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_remove_DASH_method,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_StringIter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/StringIter."], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_invoke,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$doc,"Invoke JavaScript object method via string. Needed when the\n  string is not a valid unquoted property name.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_List,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/List."], null)),cljs.core.with_meta(cljs.core.cst$sym$m3_DASH_mix_DASH_K1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k1], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$Iterate,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_float,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$undefined_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x identical to the JavaScript undefined value."], null)),cljs.core.with_meta(cljs.core.cst$sym$IMeta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_meta,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_or_DASH_nil,cljs.core.cst$kw$doc,"Returns the metadata of object o."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_meta,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_meta,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_or_DASH_nil], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)),cljs.core.cst$kw$doc,"Returns the metadata of object o."], null)], null),cljs.core.cst$kw$doc,"Protocol for accessing the metadata of an object.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$reduced_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$r], null))),cljs.core.cst$kw$doc,"Returns true if x is the result of a call to reduced"], null)),cljs.core.with_meta(cljs.core.cst$sym$apply_DASH_to,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$argc,cljs.core.cst$sym$args], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$disj_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null))),cljs.core.cst$kw$doc,"disj[oin]. Returns a transient set of the same (hashed/sorted) type, that\n  does not contain key(s).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_lookup,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ILookup,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null))),cljs.core.cst$kw$doc,"Use k to look up a value in o. If not-found is supplied and k is not\n     a valid value that can be used for look up, not-found is returned."], null)),cljs.core.with_meta(cljs.core.cst$sym$float_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true for JavaScript numbers, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$ICloneable,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_clone,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Creates a clone of value."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_clone,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null)),cljs.core.cst$kw$doc,"Creates a clone of value."], null)], null),cljs.core.cst$kw$doc,"Protocol for cloning a value.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$IEncodeClojure,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_js_DASH__GT_clj,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Transforms JavaScript values to Clojure"], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$options], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_js_DASH__GT_clj,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_js_DASH__GT_clj,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$options], null)),cljs.core.cst$kw$doc,"Transforms JavaScript values to Clojure"], null)], null),cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$booleans,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ArrayList,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ArrayList."], null)),cljs.core.with_meta(cljs.core.cst$sym$RSeq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$mask,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash,cljs.core.cst$sym$shift], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$int_DASH_array,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null))),cljs.core.cst$kw$doc,"Creates an array of ints. Does not coerce array, provided for compatibility\n  with Clojure.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$find_DASH_and_DASH_cache_DASH_best_DASH_method,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$hierarchy,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$prefer_DASH_table,cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$cached_DASH_hierarchy,cljs.core.cst$sym$default_DASH_dispatch_DASH_val], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$set_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x satisfies ISet"], null)),cljs.core.with_meta(cljs.core.cst$sym$iterable_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x implements IIterable protocol."], null)),cljs.core.with_meta(cljs.core.cst$sym$cat,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ES6EntriesIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ES6EntriesIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$divide,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_reserved_DASH_arr,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_pr_DASH_writer,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$flush,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.with_meta(cljs.core.cst$sym$set_DASH_from_DASH_indexed_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iseq], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$maybe_DASH_init_DASH_tapset,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.with_meta(cljs.core.cst$sym$take_DASH_while,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of successive items from coll while\n  (pred item) returns logical true. pred must be free of side-effects.\n  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$vary_DASH_meta,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$doc,"Returns an object of the same type and value as obj, with\n  (apply f (meta obj) args) as its metadata.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(6),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(6),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$INext,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_next,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_or_DASH_nil,cljs.core.cst$kw$doc,"Returns a new collection of coll without the first item. In contrast to\n     rest, it should return nil if there are no more items, e.g.\n     (next []) => nil\n     (next nil) => nil"], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_next,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_or_DASH_nil], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns a new collection of coll without the first item. In contrast to\n     rest, it should return nil if there are no more items, e.g.\n     (next []) => nil\n     (next nil) => nil"], null)], null),cljs.core.cst$kw$doc,"Protocol for accessing the next items of a collection.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$is_proto_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.cst$sym$START,cljs.core.with_meta(cljs.core.cst$sym$ICounted,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_count,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$doc,"Calculates the count of coll in constant time. Used by cljs.core/count."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_count,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Calculates the count of coll in constant time. Used by cljs.core/count."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding the ability to count a collection in constant time.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$IMapEntry,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the key of the map entry."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the value of the map entry."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_key,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_key,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns the key of the map entry."], null),cljs.core.cst$kw$_DASH_val,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_val,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns the value of the map entry."], null)], null),cljs.core.cst$kw$doc,"Protocol for examining a map entry.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$pv_DASH_reduce,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,5,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,5,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_LT__EQ_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns non-nil if nums are in monotonically non-decreasing order,\n  otherwise false."], null)),cljs.core.cst$sym$MODULE_INFOS,cljs.core.with_meta(cljs.core.cst$sym$conj_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null))),cljs.core.cst$kw$doc,"Adds val to the transient collection, and return tcoll. The 'addition'\n  may happen at different 'places' depending on the concrete type.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_pop,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IStack,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a new stack without the item on top of the stack. Is used\n     by cljs.core/pop."], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_identical_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$repeatedly,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Takes a function of no args, presumably with side effects, and\n  returns an infinite (or length n if supplied) lazy sequence of calls\n  to it",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$zipmap,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keys,cljs.core.cst$sym$vals], null))),cljs.core.cst$kw$doc,"Returns a map with the keys mapped to the corresponding vals."], null)),cljs.core.with_meta(cljs.core.cst$sym$reset_DASH_vals_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$new_DASH_value], null))),cljs.core.cst$kw$doc,"Sets the value of atom to newval. Returns [old new], the value of the\n   atom before and after the reset.",cljs.core.cst$kw$added,"1.9"], null)),cljs.core.with_meta(cljs.core.cst$sym$IStack,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_peek,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the item from the top of the stack. Is used by cljs.core/peek."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_pop,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new stack without the item on top of the stack. Is used\n     by cljs.core/pop."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_peek,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_peek,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns the item from the top of the stack. Is used by cljs.core/peek."], null),cljs.core.cst$kw$_DASH_pop,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_pop,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns a new stack without the item on top of the stack. Is used\n     by cljs.core/pop."], null)], null),cljs.core.cst$kw$doc,"Protocol for collections to provide access to their items as stacks. The top\n  of the stack should be accessed in the most efficient way for the different\n  data structures.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_remove_DASH_watch,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IWatchable,cljs.core.cst$kw$doc,"Removes watcher that corresponds to key from this.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$IVolatile,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_vreset_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Sets the value of volatile o to new-value without regard for the\n     current value. Returns new-value."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$new_DASH_value], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_vreset_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_vreset_BANG_,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$new_DASH_value], null)),cljs.core.cst$kw$doc,"Sets the value of volatile o to new-value without regard for the\n     current value. Returns new-value."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding volatile functionality.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$remove,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the items in coll for which\n  (pred item) returns logical false. pred must be free of side-effects.\n  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_BitmapIndexedNode,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$bitmap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/BitmapIndexedNode."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the product of nums. (*) returns 1."], null)),cljs.core.with_meta(cljs.core.cst$sym$re_DASH_pattern,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Returns an instance of RegExp which has compiled the provided string."], null)),cljs.core.with_meta(cljs.core.cst$sym$min,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the least of the nums."], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_persistent_BANG_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null))),cljs.core.cst$kw$doc,"Creates a persistent data structure from tcoll and returns it."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_nth,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IIndexed,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null))),cljs.core.cst$kw$doc,"Returns the value at the index n in the collection coll.\n     Returns not-found if index n is out of bounds and not-found is supplied."], null)),cljs.core.with_meta(cljs.core.cst$sym$pop_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null))),cljs.core.cst$kw$doc,"Removes the last item from a transient vector. If\n  the collection is empty, throws an exception. Returns tcoll"], null)),cljs.core.with_meta(cljs.core.cst$sym$chunk_DASH_append,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$b,cljs.core.cst$sym$x], null)))], null)),cljs.core.cst$sym$_STAR_unchecked_DASH_arrays_STAR_,cljs.core.with_meta(cljs.core.cst$sym$prn_DASH_str,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null))),cljs.core.cst$kw$doc,"Same as pr-str followed by (newline)",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$IReversible,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_rseq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a seq of the items in coll in reversed order."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_rseq,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_rseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns a seq of the items in coll in reversed order."], null)], null),cljs.core.cst$kw$doc,"Protocol for reversing a seq.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$reversible_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns true if coll satisfies? IReversible."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_realized_QMARK_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IPending,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if a value for x has been produced, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_add_DASH_watch,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IWatchable,cljs.core.cst$kw$doc,"Adds a watcher function f to this. Keys must be unique per reference,\n     and can be used to remove the watch with -remove-watch.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key,cljs.core.cst$sym$f], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_deref_DASH_with_DASH_timeout,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IDerefWithTimeout,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$msec,cljs.core.cst$sym$timeout_DASH_val], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$conj,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null))),cljs.core.cst$kw$doc,"conj[oin]. Returns a new collection with the xs\n  'added'. (conj nil item) returns (item).\n  (conj coll) returns coll. (conj) returns [].\n  The 'addition' may happen at different 'places' depending\n  on the concrete type.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_sorted_DASH_seq,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISorted,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$ascending_QMARK_], null))),cljs.core.cst$kw$doc,"Returns a sorted seq from coll in either ascending or descending order."], null)),cljs.core.with_meta(cljs.core.cst$sym$flatten1,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$colls], null))),cljs.core.cst$kw$doc,"Take a collection of collections, and return a lazy seq\n  of items from the inner collection"], null)),cljs.core.with_meta(cljs.core.cst$sym$transduce,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"reduce with a transformation of f (xf). If init is not\n  supplied, (f) will be called to produce it. f should be a reducing\n  step function that accepts both 1 and 2 arguments, if it accepts\n  only 2 you can add the arity-1 with 'completing'. Returns the result\n  of applying (the transformed) xf to init and the first item in coll,\n  then applying xf to that result and the 2nd item, etc. If coll\n  contains no items, returns init and f is not called. Note that\n  certain transforms may inject or skip items.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,4,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,4,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_swap_BANG_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISwap,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,5,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,5,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null))),cljs.core.cst$kw$doc,"Swaps the value of o to be (apply f current-value-of-atom args)."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_length_STAR_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"*print-length* controls how many items of each collection the\n  printer will print. If it is bound to logical false, there is no\n  limit. Otherwise, it must be bound to an integer indicating the maximum\n  number of items of each collection to print. If a collection contains\n  more items, the printer will print items up to the limit followed by\n  '...' to represent the remaining items. The root binding is nil\n  indicating no limit.",cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {null|number}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_delete,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key], null))),cljs.core.cst$kw$doc,"Delete a property from a JavaScript object.\n  Returns true upon success, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$truth_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Internal - do not use!"], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_index_DASH_of,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_MultiFn,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$dispatch_DASH_fn,cljs.core.cst$sym$default_DASH_dispatch_DASH_val,cljs.core.cst$sym$hierarchy,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$prefer_DASH_table,cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$cached_DASH_hierarchy], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/MultiFn."], null)),cljs.core.with_meta(cljs.core.cst$sym$key_DASH__GT_js,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$IEncodeJS,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_clj_DASH__GT_js,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Recursively transforms clj values to JavaScript"], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_key_DASH__GT_js,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Transforms map keys to valid JavaScript keys. Arbitrary keys are\n  encoded to their string representation via (pr-str x)"], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_clj_DASH__GT_js,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_clj_DASH__GT_js,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Recursively transforms clj values to JavaScript"], null),cljs.core.cst$kw$_DASH_key_DASH__GT_js,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_key_DASH__GT_js,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Transforms map keys to valid JavaScript keys. Arbitrary keys are\n  encoded to their string representation via (pr-str x)"], null)], null),cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$new_DASH_path,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$level,cljs.core.cst$sym$node], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$compare_DASH_and_DASH_set_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$oldval,cljs.core.cst$sym$newval], null))),cljs.core.cst$kw$doc,"Atomically sets the value of atom to newval if and only if the\n  current value of the atom is equal to oldval. Returns true if\n  set happened, else false."], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_copy_DASH_downward,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$from,cljs.core.cst$sym$i,cljs.core.cst$sym$to,cljs.core.cst$sym$j,cljs.core.cst$sym$len], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$pack_DASH_array_DASH_node,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array_DASH_node,cljs.core.cst$sym$edit,cljs.core.cst$sym$idx], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$interleave,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null))),cljs.core.cst$kw$doc,"Returns a lazy seq of the first item in each coll, then the second etc.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$print_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$map_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies IMap"], null)),cljs.core.cst$sym$m3_DASH_C1,cljs.core.with_meta(cljs.core.cst$sym$get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$identity,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns its argument."], null)),cljs.core.with_meta(cljs.core.cst$sym$into,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null))),cljs.core.cst$kw$doc,"Returns a new coll consisting of to-coll with all of the items of\n  from-coll conjoined. A transducer may be supplied.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$long,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Coerce to long by stripping decimal places. Identical to `int'."], null)),cljs.core.with_meta(cljs.core.cst$sym$double,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$volatile_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is a volatile."], null)),cljs.core.with_meta(cljs.core.cst$sym$ChunkBuffer,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$HashSetIter,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_key,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,cljs.core.cst$kw$doc,"Returns the key of the map entry.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$nfirst,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Same as (next (first x))"], null)),cljs.core.with_meta(cljs.core.cst$sym$StringBufferWriter,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IWriter,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IWriter,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$meta,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null))),cljs.core.cst$kw$doc,"Returns the metadata of obj, returns nil if there is no metadata."], null)),cljs.core.with_meta(cljs.core.cst$sym$tv_DASH_editable_DASH_tail,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_kv_DASH_reduce,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,cljs.core.cst$kw$doc,"Reduces an associative collection and returns the result. f should be\n     a function that takes three arguments.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$IHash,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the hash code of o."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_hash,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_hash,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)),cljs.core.cst$kw$doc,"Returns the hash code of o."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding hashing functionality to a type.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_and_DASH_not,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Bitwise and with complement",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$var_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Returns true if v is of type cljs.core.Var"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_comparator,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISorted,cljs.core.cst$kw$doc,"Returns the comparator for coll.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_add_DASH_int,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the sum of nums. (+) returns 0."], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_ordered_DASH_coll,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns the hash code, consistent with =, for an external ordered\n   collection implementing Iterable.\n   See http://clojure.org/data_structures#hash for full algorithms."], null)),cljs.core.with_meta(cljs.core.cst$sym$extend_DASH_object_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$fn_DASH_map], null))),cljs.core.cst$kw$doc,"Takes a JavaScript object and a map of names to functions and\n  attaches said functions as methods on the object.  Any references to\n  JavaScript's implicit this (via the this-as macro) will resolve to the\n  object that the function is attached."], null)),cljs.core.with_meta(cljs.core.cst$sym$do_DASH_assoc,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$level,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$val], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$reset_DASH_meta_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iref,cljs.core.cst$sym$m], null))),cljs.core.cst$kw$doc,"Atomically resets the metadata for an atom"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_KeySeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/KeySeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$IEquiv,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_equiv,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$doc,"Returns true if o and other are equal, false otherwise."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$other], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_equiv,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_equiv,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$other], null)),cljs.core.cst$kw$doc,"Returns true if o and other are equal, false otherwise."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding value comparison functionality to a type.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$tree_DASH_map_DASH_kv_DASH_reduce,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$cycle,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy (infinite!) sequence of repetitions of the items in coll."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_deref,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IDeref,cljs.core.cst$kw$doc,"Returns the value of the reference o.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_writer_DASH_ex_DASH_info,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$empty_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns true if coll has no items - same as (not (seq coll)).\n  Please use the idiom (seq x) rather than (not (empty? x))"], null)),cljs.core.with_meta(cljs.core.cst$sym$TaggedLiteral,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$short,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_clj_DASH__GT_js,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IEncodeJS,cljs.core.cst$kw$doc,"Recursively transforms clj values to JavaScript",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_chunked_DASH_first,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,cljs.core.cst$kw$doc,"Returns the first chunk in coll.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$add_DASH_tap,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Adds f, a fn of one argument, to the tap set. This function will be called with\n  anything sent via tap>. Remember f in order to remove-tap"], null)),cljs.core.with_meta(cljs.core.cst$sym$filterv,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a vector of the items in coll for which\n  (pred item) returns logical true. pred must be free of side-effects."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_TaggedLiteral,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag,cljs.core.cst$sym$form], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/TaggedLiteral."], null)),cljs.core.with_meta(cljs.core.cst$sym$tv_DASH_editable_DASH_root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$hash,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null))),cljs.core.cst$kw$doc,"Returns the hash code of its argument. Note this is the hash code\n   consistent with =."], null)),cljs.core.with_meta(cljs.core.cst$sym$quot,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$d], null))),cljs.core.cst$kw$doc,"quot[ient] of dividing numerator by denominator."], null)),cljs.core.with_meta(cljs.core.cst$sym$ns_DASH_interns_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym], null))),cljs.core.cst$kw$doc,"Returns a map of the intern mappings for the namespace.\n  Bootstrap only."], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_double,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$IntegerRange,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_target_STAR_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$declared,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$string,cljs.core.cst$kw$doc,"Var bound to the name value of the compiler build :target option.\n  For example, if the compiler build :target is :nodejs, *target* will be bound\n  to \"nodejs\". *target* is a Google Closure define and can be set by compiler\n  :closure-defines option."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ChunkedCons,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$chunk,cljs.core.cst$sym$more,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ChunkedCons."], null)),cljs.core.with_meta(cljs.core.cst$sym$ranged_DASH_iterator,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ITransientVector,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_DASH_n_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns tcoll with value val added at position n."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$n,cljs.core.cst$sym$val], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_pop_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns tcoll with the last item removed from it."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_assoc_DASH_n_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_DASH_n_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$n,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$doc,"Returns tcoll with value val added at position n."], null),cljs.core.cst$kw$_DASH_pop_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_pop_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null)),cljs.core.cst$kw$doc,"Returns tcoll with the last item removed from it."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding vector functionality to transient collections.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$longs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$not_EQ_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Same as (not (= obj1 obj2))"], null)),cljs.core.with_meta(cljs.core.cst$sym$set_DASH_print_DASH_err_DASH_fn_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Set *print-err-fn* to f."], null)),cljs.core.with_meta(cljs.core.cst$sym$string_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is a JavaScript string."], null)),cljs.core.with_meta(cljs.core.cst$sym$uri_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true x is a goog.Uri instance.",cljs.core.cst$kw$added,"1.9"], null)),cljs.core.with_meta(cljs.core.cst$sym$es6_DASH_iterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"EXPERIMENTAL: Return a ES2015 compatible iterator for coll."], null)),cljs.core.with_meta(cljs.core.cst$sym$Delay,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$munge_DASH_str,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$string,cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_str_DASH_with_DASH_opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$objs,cljs.core.cst$sym$opts], null))),cljs.core.cst$kw$doc,"Prints a sequence of objects to a string, observing all the\n  options given in opts"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_RecordIter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$record,cljs.core.cst$sym$base_DASH_count,cljs.core.cst$sym$fields,cljs.core.cst$sym$ext_DASH_map_DASH_iter], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/RecordIter."], null)),cljs.core.cst$sym$m3_DASH_C2,cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Symbol,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$str,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$_meta], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Symbol."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_newline_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"When set to logical false will drop newlines from printing calls.\n  This is to work around the implicit newlines emitted by standard JavaScript\n  console objects."], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_multiply_DASH_int,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the product of nums. (*) returns 1."], null)),cljs.core.with_meta(cljs.core.cst$sym$tapset,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null),cljs.core.cst$kw$private,true], null)),cljs.core.with_meta(cljs.core.cst$sym$chunk_DASH_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$remove_DASH_all_DASH_methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null))),cljs.core.cst$kw$doc,"Removes all of the methods of multimethod."], null)),cljs.core.with_meta(cljs.core.cst$sym$trampoline,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$doc,"trampoline can be used to convert algorithms requiring mutual\n  recursion without stack consumption. Calls f with supplied args, if\n  any. If f returns a fn, calls that fn with no arguments, and\n  continues to repeat, until the return value is not a fn, then\n  returns that non-fn value. Note that if you want to return a fn as a\n  final value, you must wrap it in some data structure and unpack it\n  after trampoline returns.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$double_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true for JavaScript numbers, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"bound in a repl thread to the most recent value printed"], null)),cljs.core.with_meta(cljs.core.cst$sym$vec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Cycle,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$all,cljs.core.cst$sym$prev,cljs.core.with_meta(cljs.core.cst$sym$current,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Cycle."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_meta_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"If set to logical true, when printing an object, its metadata will also\n  be printed in a form that can be read back by the reader.\n\n  Defaults to false."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_notify_DASH_watches,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IWatchable,cljs.core.cst$kw$doc,"Calls all watchers with this, oldval and newval.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$oldval,cljs.core.cst$sym$newval], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$MultiFn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$NONE,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$private,true], null)),cljs.core.with_meta(cljs.core.cst$sym$int,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Coerce to int by stripping decimal places."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ValSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ValSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$map_DASH_entry_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$second,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Same as (first (next x))"], null)),cljs.core.with_meta(cljs.core.cst$sym$find_DASH_ns_DASH_obj,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns], null))),cljs.core.cst$kw$doc,"Bootstrap only."], null)),cljs.core.with_meta(cljs.core.cst$sym$IEditableCollection,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_as_DASH_transient,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new, transient version of the collection, in constant time."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_as_DASH_transient,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_as_DASH_transient,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns a new, transient version of the collection, in constant time."], null)], null),cljs.core.cst$kw$doc,"Protocol for collections which can transformed to transients.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_combine,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$seed,cljs.core.cst$sym$hash], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_GT_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns non-nil if nums are in monotonically decreasing order,\n  otherwise false."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_name,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_INamed,cljs.core.cst$kw$tag,cljs.core.cst$sym$string,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns the name String of x."], null)),cljs.core.with_meta(cljs.core.cst$sym$replace,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$smap], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$smap,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Given a map of replacement pairs and a vector/collection, returns a\n  vector/seq with any elements = a key in smap replaced with the\n  corresponding val in smap.  Returns a transducer when no collection\n  is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$smap], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$smap,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$smap], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$smap,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$int_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies integer? or is an instance of goog.math.Integer\n   or goog.math.Long."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Subvec,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Subvec."], null)),cljs.core.with_meta(cljs.core.cst$sym$associative_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if coll implements IAssociative"], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_int,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Coerce to int by stripping decimal places."], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_keys,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj], null))),cljs.core.cst$kw$doc,"Return the JavaScript keys for an object."], null)),cljs.core.with_meta(cljs.core.cst$sym$inst_DASH_ms_STAR_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_Inst,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inst], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ES6EntriesIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$keyword_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a Keyword"], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$force,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"If x is a Delay, returns the (possibly cached) value of its expression, else returns x"], null)),cljs.core.with_meta(cljs.core.cst$sym$group_DASH_by,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a map of the elements of coll keyed by the result of\n  f on each element. The value at each key will be a vector of the\n  corresponding elements, in the order they appeared in coll."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_global_STAR_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$declared,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$string,cljs.core.cst$kw$doc,"Manually set the JavaScript global context. Only \"window\", \"self\"\n  , and \"global\" supported. "], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_rseq,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IReversible,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a seq of the items in coll in reversed order."], null)),cljs.core.with_meta(cljs.core.cst$sym$prn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null))),cljs.core.cst$kw$doc,"Same as pr followed by (newline).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$tv_DASH_pop_DASH_tail,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tv,cljs.core.cst$sym$level,cljs.core.cst$sym$node], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$default_DASH_dispatch_DASH_val,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null))),cljs.core.cst$kw$doc,"Given a multimethod, return its default-dispatch-val."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Atom,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_IWatchable,"null",cljs.core.cst$sym$cljs$core_SLASH_IAtom,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$state,cljs.core.cst$sym$meta,cljs.core.cst$sym$validator,cljs.core.cst$sym$watches], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IWatchable,"null",cljs.core.cst$sym$cljs$core_SLASH_IAtom,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Atom."], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_iterable_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x has a JavaScript iterator property"], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentHashMap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_multiply,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the product of nums. (*) returns 1."], null)),cljs.core.with_meta(cljs.core.cst$sym$ArrayNodeSeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$even_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Returns true if n is even, throws an exception if n is not an integer"], null)),cljs.core.with_meta(cljs.core.cst$sym$es6_DASH_iterator_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_dec,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns a number one less than x, an int."], null)),cljs.core.with_meta(cljs.core.cst$sym$Inst,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$inst_DASH_ms_STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inst], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$inst_DASH_ms_STAR_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$inst_DASH_ms_STAR_,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inst], null)),cljs.core.cst$kw$doc,null], null)], null),cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_collision_DASH_node_DASH_find_DASH_index,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$cnt,cljs.core.cst$sym$key], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$persistent_DASH_array_DASH_map_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$_meta], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$RangeIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$tagged_DASH_literal_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null))),cljs.core.cst$kw$doc,"Return true if the value is the data representation of a tagged literal"], null)),cljs.core.with_meta(cljs.core.cst$sym$double_DASH_array,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null))),cljs.core.cst$kw$doc,"Creates an array of doubles. Does not coerce array, provided for compatibility\n  with Clojure.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$create_DASH_ns,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym,cljs.core.cst$sym$ns_DASH_obj], null))),cljs.core.cst$kw$doc,"Create a new namespace named by the symbol. Bootstrap only.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym,cljs.core.cst$sym$ns_DASH_obj], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym,cljs.core.cst$sym$ns_DASH_obj], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_EmptyList,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/EmptyList."], null)),cljs.core.with_meta(cljs.core.cst$sym$seq_DASH_reduce,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$spread,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arglist], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$balance_DASH_left,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$ins,cljs.core.cst$sym$right], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$rseq,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$rev], null))),cljs.core.cst$kw$doc,"Returns, in constant time, a seq of the items in rev (which\n  can be a vector or sorted-map), in reverse order. If rev is empty returns nil"], null)),cljs.core.with_meta(cljs.core.cst$sym$ex_DASH_cause,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ex], null))),cljs.core.cst$kw$doc,"Returns exception cause (an Error / ExceptionInfo) if ex is an\n  ExceptionInfo.\n  Otherwise returns nil."], null)),cljs.core.with_meta(cljs.core.cst$sym$IReset,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_reset_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Sets the value of o to new-value."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$new_DASH_value], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_reset_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_reset_BANG_,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$new_DASH_value], null)),cljs.core.cst$kw$doc,"Sets the value of o to new-value."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding resetting functionality.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$IEmptyableCollection,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_empty,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns an empty collection of the same category as coll. Used\n     by cljs.core/empty."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_empty,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_empty,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns an empty collection of the same category as coll. Used\n     by cljs.core/empty."], null)], null),cljs.core.cst$kw$doc,"Protocol for creating an empty collection.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_map_DASH_index_DASH_of,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ex_DASH_message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ex], null))),cljs.core.cst$kw$doc,"Returns the message attached to the given Error / ExceptionInfo object.\n  For non-Errors returns nil."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_NodeIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_entry,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/NodeIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_fn_DASH_bodies_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"*print-fns-bodies* controls whether functions print their source or\n    only their names."], null)),cljs.core.with_meta(cljs.core.cst$sym$string_DASH_print,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$float,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$IRecord,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$sigs,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$doc,"Marker interface indicating a record object",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$first_DASH_array_DASH_for_DASH_longvec,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$es6_DASH_set_DASH_entries_DASH_iterator,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$concat,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$zs], null))),cljs.core.cst$kw$doc,"Returns a lazy seq representing the concatenation of the elements in the supplied colls.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$zs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_methods,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_reserved,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {null|Object}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$IDerefWithTimeout,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_deref_DASH_with_DASH_timeout,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$msec,cljs.core.cst$sym$timeout_DASH_val], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_deref_DASH_with_DASH_timeout,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_deref_DASH_with_DASH_timeout,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$msec,cljs.core.cst$sym$timeout_DASH_val], null)),cljs.core.cst$kw$doc,null], null)], null),cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$symbol,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name], null))),cljs.core.cst$kw$doc,"Returns a Symbol with the given namespace and name. Arity-1 works\n  on strings, keywords, and vars.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$to_DASH_array_DASH_2d,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a (potentially-ragged) 2-dimensional array\n  containing the contents of coll."], null)),cljs.core.with_meta(cljs.core.cst$sym$Subvec,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ExceptionInfo,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@constructor"], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$message,cljs.core.cst$sym$data,cljs.core.cst$sym$cause], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$ISet,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_disjoin,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new collection of coll that does not contain v."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_disjoin,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_disjoin,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null)),cljs.core.cst$kw$doc,"Returns a new collection of coll that does not contain v."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding set functionality to a collection.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$pop,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"For a list or queue, returns a new list/queue without the first\n  item, for a vector, returns a new vector without the last item.\n  Note - not the same as next/butlast."], null)),cljs.core.with_meta(cljs.core.cst$sym$IPending,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_realized_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$doc,"Returns true if a value for x has been produced, false otherwise."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_realized_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_realized_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Returns true if a value for x has been produced, false otherwise."], null)], null),cljs.core.cst$kw$doc,"Protocol for types which can have a deferred realization. Currently only\n  implemented by Delay and LazySeq.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_entry_DASH_key,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISorted,cljs.core.cst$kw$doc,"Returns the key for entry.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$entry], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$CHAR_MAP,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@enum {string}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$pop_DASH_tail,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$level,cljs.core.cst$sym$node], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$dissoc_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null))),cljs.core.cst$kw$doc,"Returns a transient map that doesn't contain a mapping for key(s).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$reductions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy seq of the intermediate values of the reduction (as\n  per reduce) of coll by f, starting with init.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$indexed_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if coll implements nth in constant time"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"If no ys are supplied, returns the negation of x, else subtracts\n  the ys from x and returns the result."], null)),cljs.core.with_meta(cljs.core.cst$sym$Cycle,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_equiv,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IEquiv,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$other], null))),cljs.core.cst$kw$doc,"Returns true if o and other are equal, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_RangeIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$end,cljs.core.cst$sym$step], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/RangeIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ArrayNode,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ArrayNode."], null)),cljs.core.with_meta(cljs.core.cst$sym$assoc_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$kvs], null))),cljs.core.cst$kw$doc,"When applied to a transient map, adds mapping of key(s) to\n  val(s). When applied to a transient vector, sets the val at index.\n  Note - index must be <= (count vector). Returns coll.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$kvs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_set,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keys], null))),cljs.core.cst$kw$doc,"Returns a new hash set with supplied keys.  Any equal keys are\n  handled as if by repeated uses of conj.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keys], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$reduce_DASH_kv,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Reduces an associative collection. f should be a function of 3\n  arguments. Returns the result of applying f to init, the first key\n  and the first value in coll, then applying f to that result and the\n  2nd key and value, etc. If coll contains no entries, returns init\n  and f is not called. Note that reduce-kv is supported on vectors,\n  where the keys will be the ordinals."], null)),cljs.core.with_meta(cljs.core.cst$sym$reset_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$new_DASH_value], null))),cljs.core.cst$kw$doc,"Sets the value of atom to newval without regard for the\n  current value. Returns new-value."], null)),cljs.core.with_meta(cljs.core.cst$sym$name,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_RedNode,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/RedNode."], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_array_DASH_for,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$i], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$Fn,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$sigs,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$doc,"Marker protocol",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$ffirst,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Same as (first (first x))"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ArrayNodeIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ArrayNodeIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$sorted_DASH_set,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keys], null))),cljs.core.cst$kw$doc,"Returns a new sorted set with supplied keys.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$keys)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keys], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_with_DASH_opts,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$objs,cljs.core.cst$sym$opts], null))),cljs.core.cst$kw$doc,"Prints a sequence of objects using string-print, observing all\n  the options given in opts"], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentTreeMap,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$strip_DASH_ns,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$named], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentTreeMap,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$cnt,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentTreeMap."], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_reduce,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$idx], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,4,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,4,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$idx], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$idx], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$counted_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if coll implements count in constant time"], null)),cljs.core.with_meta(cljs.core.cst$sym$tagged_DASH_literal,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag,cljs.core.cst$sym$form], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$pre,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$symbol_QMARK_,cljs.core.cst$sym$tag)], null)], null)))),cljs.core.cst$kw$doc,"Construct a data representation of a tagged literal from a\n  tag symbol and a form."], null)),cljs.core.with_meta(cljs.core.cst$sym$println,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null))),cljs.core.cst$kw$doc,"Same as print followed by (newline)",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$assoc_DASH_in,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Associates a value in a nested associative structure, where ks is a\n  sequence of keys and v is the new value and returns a new nested structure.\n  If any levels do not exist, hash-maps will be created."], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentHashSet,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_test,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Test bit at index n"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Namespace,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$name], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Namespace."], null)),cljs.core.with_meta(cljs.core.cst$sym$TransientHashMap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentHashMap,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$root,cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$nil_DASH_val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentHashMap."], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_extend_DASH_kv,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ISwap,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_swap_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Swaps the value of o to be (apply f current-value-of-atom args)."], null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_swap_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_swap_BANG_,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$doc,"Swaps the value of o to be (apply f current-value-of-atom args)."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding swapping functionality.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$ChunkedCons,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$memoize,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Returns a memoized version of a referentially transparent function. The\n  memoized version of the function keeps a cache of the mapping from arguments\n  to results and, when calls with the same arguments are repeated often, has\n  higher performance at the expense of higher memory use."], null)),cljs.core.with_meta(cljs.core.cst$sym$alter_DASH_meta_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iref,cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$doc,"Atomically sets the metadata for a namespace/var/ref/agent/atom to be:\n\n  (apply f its-current-meta args)\n\n  f must be free of side-effects",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$iref,cljs.core.cst$sym$f,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iref,cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_StringBufferWriter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IWriter,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sb], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IWriter,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/StringBufferWriter."], null)),cljs.core.with_meta(cljs.core.cst$sym$zero_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if num is zero, else false"], null)),cljs.core.with_meta(cljs.core.cst$sym$tv_DASH_ensure_DASH_editable,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$node], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$simple_DASH_keyword_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a keyword without a namespace"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_indexOf,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$start], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$start], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$start], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_main_DASH_cli_DASH_fn_STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"When compiled for a command-line target, whatever function\n  *main-cli-fn* is set to will be called with the command-line\n  argv as arguments"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_DASH_n,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IVector,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$val], null))),cljs.core.cst$kw$doc,"Returns a new vector with value val added at position n."], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_dec_DASH_int,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns a number one less than x, an int."], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_imap,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$dominates,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$prefer_DASH_table,cljs.core.cst$sym$hierarchy], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$persistent_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null))),cljs.core.cst$kw$doc,"Returns a new, persistent version of the transient collection, in\n  constant time. The transient collection cannot be used after this\n  call, any such use will throw an exception."], null)),cljs.core.with_meta(cljs.core.cst$sym$set_DASH_print_DASH_fn_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Set *print-fn* to f."], null)),cljs.core.with_meta(cljs.core.cst$sym$nnext,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Same as (next (next x))"], null)),cljs.core.with_meta(cljs.core.cst$sym$Box,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$balance_DASH_right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$ins], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$throw_DASH_no_DASH_method_DASH_error,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$dispatch_DASH_val], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$demunge_DASH_str,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$munged_DASH_name], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$add_DASH_watch,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iref,cljs.core.cst$sym$key,cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Adds a watch function to an atom reference. The watch fn must be a\n  fn of 4 args: a key, the reference, its old-state, its\n  new-state. Whenever the reference's state might have been changed,\n  any registered watches will have their functions called. The watch\n  fn will be called synchronously. Note that an atom's state\n  may have changed again prior to the fn call, so use old/new-state\n  rather than derefing the reference. Keys must be unique per\n  reference, and can be used to remove the watch with remove-watch,\n  but are otherwise considered opaque by the watch mechanism.  Bear in\n  mind that regardless of the result or action of the watch fns the\n  atom's value will change.  Example:\n\n      (def a (atom 0))\n      (add-watch a :inc (fn [k r o n] (assert (== 0 n))))\n      (swap! a inc)\n      ;; Assertion Error\n      (deref a)\n      ;=> 1"], null)),cljs.core.with_meta(cljs.core.cst$sym$not_DASH_every_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns false if (pred x) is logical true for every x in\n  coll, else true."], null)),cljs.core.with_meta(cljs.core.cst$sym$rem,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$d], null))),cljs.core.cst$kw$doc,"remainder of dividing numerator by denominator."], null)),cljs.core.with_meta(cljs.core.cst$sym$ifind_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if coll implements IFind"], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_sb_DASH_with_DASH_opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$objs,cljs.core.cst$sym$opts], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_HashMapIter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$nil_DASH_val,cljs.core.cst$sym$root_DASH_iter,cljs.core.with_meta(cljs.core.cst$sym$seen,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/HashMapIter."], null)),cljs.core.with_meta(cljs.core.cst$sym$BitmapIndexedNode,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_NodeSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/NodeSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$some,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns the first logical true value of (pred x) for any x in coll,\n  else nil.  One common idiom is to use a set as pred, for example\n  this will return :fred if :fred is in the sequence, otherwise nil:\n  (some #{:fred} coll)"], null)),cljs.core.with_meta(cljs.core.cst$sym$INamed,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_name,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$string,cljs.core.cst$kw$doc,"Returns the name String of x."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_namespace,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$string,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),cljs.core.cst$kw$doc,"Returns the namespace String of x."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_name,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_name,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$string], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Returns the name String of x."], null),cljs.core.cst$kw$_DASH_namespace,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_namespace,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$string,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Returns the namespace String of x."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding a name.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Box,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Box."], null)),cljs.core.with_meta(cljs.core.cst$sym$IReduce,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_reduce,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"f should be a function of 2 arguments. If start is not supplied,\n     returns the result of applying f to the first 2 items in coll, then\n     applying f to that result and the 3rd item, etc."], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_reduce,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_reduce,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)),cljs.core.cst$kw$doc,"f should be a function of 2 arguments. If start is not supplied,\n     returns the result of applying f to the first 2 items in coll, then\n     applying f to that result and the 3rd item, etc."], null)], null),cljs.core.cst$kw$doc,"Protocol for seq types that can reduce themselves.\n  Called by cljs.core/reduce.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$neg_DASH_int_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies int? and is negative."], null)),cljs.core.with_meta(cljs.core.cst$sym$drop,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$NodeIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_obj,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null))),cljs.core.cst$kw$doc,"Create JavaSript object from an even number arguments representing\n  interleaved keys and values.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ITransientCollection,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_conj_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Adds value val to tcoll and returns tcoll."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_persistent_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Creates a persistent data structure from tcoll and returns it."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_conj_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_conj_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$doc,"Adds value val to tcoll and returns tcoll."], null),cljs.core.cst$kw$_DASH_persistent_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_persistent_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null)),cljs.core.cst$kw$doc,"Creates a persistent data structure from tcoll and returns it."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding basic functionality to transient collections.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$Atom,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_IWatchable,"null",cljs.core.cst$sym$cljs$core_SLASH_IAtom,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IWatchable,"null",cljs.core.cst$sym$cljs$core_SLASH_IAtom,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$sorted_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if coll satisfies ISorted"], null)),cljs.core.with_meta(cljs.core.cst$sym$nil_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is nil, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$split_DASH_at,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a vector of [(take n coll) (drop n coll)]"], null)),cljs.core.with_meta(cljs.core.cst$sym$TransientHashSet,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_e,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"bound in a repl thread to the most recent exception caught by the repl"], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_map_DASH_extend_DASH_kv,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$prn_DASH_str_DASH_with_DASH_opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$objs,cljs.core.cst$sym$opts], null))),cljs.core.cst$kw$doc,"Same as pr-str-with-opts followed by (newline)"], null)),cljs.core.cst$sym$not_DASH_native,cljs.core.with_meta(cljs.core.cst$sym$random_DASH_sample,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prob], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prob,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns items from coll with random probability of prob (0.0 -\n  1.0).  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prob], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prob,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prob], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prob,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$select_DASH_keys,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$map,cljs.core.cst$sym$keyseq], null))),cljs.core.cst$kw$doc,"Returns a map containing only those entries in map whose key is in keys"], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_and,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Bitwise and",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$bounded_DASH_count,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"If coll is counted? returns its count, else will count at most the first n\n   elements of coll using its seq",cljs.core.cst$kw$added,"1.9"], null)),cljs.core.with_meta(cljs.core.cst$sym$update,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"'Updates' a value in an associative structure, where k is a\n  key and f is a function that will take the old value\n  and any supplied args and return the new value, and returns a new\n  structure.  If the key does not exist, nil is passed as the old value.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(6),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(6),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$gensym_counter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$find_DASH_macros_DASH_ns,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns], null))),cljs.core.cst$kw$doc,"Returns the macros namespace named by the symbol or nil if it doesn't exist.\n  Bootstrap only."], null)),cljs.core.with_meta(cljs.core.cst$sym$list_STAR_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Creates a new list containing the items prepended to the rest, the\n  last of which will be treated as a sequence.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$args], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$args], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_keyword_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Keyword,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$fqn,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Keyword."], null)),cljs.core.with_meta(cljs.core.cst$sym$update_DASH_in,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$doc,"'Updates' a value in a nested associative structure, where ks is a\n  sequence of keys and f is a function that will take the old value\n  and any supplied args and return the new value, and returns a new\n  nested structure.  If any levels do not exist, hash-maps will be\n  created.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(6),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(6),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null),cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$prefer_DASH_method,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn,cljs.core.cst$sym$dispatch_DASH_val_DASH_x,cljs.core.cst$sym$dispatch_DASH_val_DASH_y], null))),cljs.core.cst$kw$doc,"Causes the multimethod to prefer matches of dispatch-val-x over dispatch-val-y\n   when there is a conflict"], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_symbol,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ensure_DASH_reduced,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"If x is already reduced?, returns it, else returns (reduced x)"], null)),cljs.core.with_meta(cljs.core.cst$sym$edit_DASH_and_DASH_set,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inode,cljs.core.cst$sym$edit,cljs.core.cst$sym$i,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inode,cljs.core.cst$sym$edit,cljs.core.cst$sym$i,cljs.core.cst$sym$a,cljs.core.cst$sym$j,cljs.core.cst$sym$b], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inode,cljs.core.cst$sym$edit,cljs.core.cst$sym$i,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inode,cljs.core.cst$sym$edit,cljs.core.cst$sym$i,cljs.core.cst$sym$a,cljs.core.cst$sym$j,cljs.core.cst$sym$b], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inode,cljs.core.cst$sym$edit,cljs.core.cst$sym$i,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inode,cljs.core.cst$sym$edit,cljs.core.cst$sym$i,cljs.core.cst$sym$a,cljs.core.cst$sym$j,cljs.core.cst$sym$b], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentArrayMap,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentArrayMap."], null)),cljs.core.with_meta(cljs.core.cst$sym$instance_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_t_cljs$core4194,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$anonymous,true,cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta4195], null))),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/t_cljs$core4194."], null)),cljs.core.with_meta(cljs.core.cst$sym$mix_DASH_collection_DASH_hash,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash_DASH_basis,cljs.core.cst$sym$count], null))),cljs.core.cst$kw$doc,"Mix final collection hash for ordered or unordered collections.\n   hash-basis is the combined collection hash, count is the number\n   of elements included in the basis. Note this is the hash code\n   consistent with =, different from .hashCode.\n   See http://clojure.org/data_structures#hash for full algorithms."], null)),cljs.core.with_meta(cljs.core.cst$sym$re_DASH_find,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Returns the first regex match, if any, of s to re, using\n  re.exec(s). Returns a vector, containing first the matching\n  substring, then any capturing groups if the regular expression contains\n  capturing groups."], null)),cljs.core.with_meta(cljs.core.cst$sym$run_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$proc,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Runs the supplied procedure (via reduce), for purposes of side\n  effects, on successive items in the collection. Returns nil"], null)),cljs.core.with_meta(cljs.core.cst$sym$char_DASH_escapes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$private,true], null)),cljs.core.with_meta(cljs.core.cst$sym$ES6Iterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_add,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the sum of nums. (+) returns 0."], null)),cljs.core.with_meta(cljs.core.cst$sym$transformer_DASH_iterator,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$sourceIter,cljs.core.cst$sym$multi], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_IntegerRange,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step,cljs.core.with_meta(cljs.core.cst$sym$chunk,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$chunk_DASH_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/IntegerRange."], null)),cljs.core.with_meta(cljs.core.cst$sym$not,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is logical false, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_vreset_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IVolatile,cljs.core.cst$kw$doc,"Sets the value of volatile o to new-value without regard for the\n     current value. Returns new-value.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$new_DASH_value], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$fn_DASH__GT_comparator,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Given a fn that might be boolean valued or a comparator,\n   return a fn that is a comparator."], null)),cljs.core.with_meta(cljs.core.cst$sym$with_DASH_meta,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$unreduced,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"If x is reduced?, returns (deref x), else returns x"], null)),cljs.core.with_meta(cljs.core.cst$sym$record_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies IRecord"], null)),cljs.core.with_meta(cljs.core.cst$sym$type,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return x's constructor."], null)),cljs.core.with_meta(cljs.core.cst$sym$identical_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),cljs.core.cst$kw$doc,"Tests if 2 arguments are the same object"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_namespace,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_INamed,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$string,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns the namespace String of x."], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_divide_DASH_int,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"If no denominators are supplied, returns 1/numerator,\n  else returns numerator divided by all of the denominators."], null)),cljs.core.with_meta(cljs.core.cst$sym$ns_DASH_name,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns_DASH_obj], null))),cljs.core.cst$kw$doc,"Returns the name of the namespace, a Namespace object.\n  Bootstrap only."], null)),cljs.core.with_meta(cljs.core.cst$sym$swap_DASH_global_DASH_hierarchy_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$f,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$max_DASH_key,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the x for which (k x), a number, is greatest.\n\n  If there are multiple such xs, the last one is returned.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentTreeSet,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$tree_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentTreeSet."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_out_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ChunkBuffer,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$end,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ChunkBuffer."], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_string,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ValSeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_prefers,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$set_DASH_validator_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iref,cljs.core.cst$sym$val], null))),cljs.core.cst$kw$doc,"Sets the validator-fn for an atom. validator-fn must be nil or a\n  side-effect-free fn of one argument, which will be passed the intended\n  new state on any state change. If the new state is unacceptable, the\n  validator-fn should return false or throw an Error. If the current state\n  is not acceptable to the new validator, an Error will be thrown and the\n  validator will not be changed."], null)),cljs.core.with_meta(cljs.core.cst$sym$ident_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a symbol or keyword"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_t_cljs$core2273,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$anonymous,true,cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta2274], null))),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/t_cljs$core2273."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_meta,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMeta,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_or_DASH_nil,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null))),cljs.core.cst$kw$doc,"Returns the metadata of object o."], null)),cljs.core.with_meta(cljs.core.cst$sym$RedNode,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_dispatch_DASH_fn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_IndexedSeqIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/IndexedSeqIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_add_DASH_method,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$method], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$balance_DASH_left_DASH_del,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$del,cljs.core.cst$sym$right], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$swap_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Atomically swaps the value of atom to be:\n  (apply f current-value-of-atom args). Note that f may be called\n  multiple times, and thus should be free of side effects.  Returns\n  the value that was swapped in.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$vals,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$Repeat,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_chunked_DASH_next,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,cljs.core.cst$kw$doc,"Returns a new collection of coll without the first chunk.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$Single,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_subtract,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"If no ys are supplied, returns the negation of x, else subtracts\n  the ys from x and returns the result."], null)),cljs.core.with_meta(cljs.core.cst$sym$tap_GT_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Sends x to any taps. Returns the result of *exec-tap-fn*, a Boolean value."], null)),cljs.core.with_meta(cljs.core.cst$sym$remove_DASH_pair,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$IMap,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_dissoc,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new collection of coll without the mapping for key k."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_dissoc,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_dissoc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),cljs.core.cst$kw$doc,"Returns a new collection of coll without the mapping for key k."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding mapping functionality to collections.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_SeqIter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/SeqIter."], null)),cljs.core.with_meta(cljs.core.cst$sym$sorted_DASH_set_DASH_by,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comparator,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keys], null))),cljs.core.cst$kw$doc,"Returns a new sorted set with supplied keys, using the supplied comparator.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$comparator,cljs.core.cst$sym$keys)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comparator,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keys], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentVector,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 24, [cljs.core.cst$sym$cljs$core_SLASH_APersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$cloneable_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null))),cljs.core.cst$kw$doc,"Return true if x implements ICloneable protocol."], null)),cljs.core.with_meta(cljs.core.cst$sym$qualified_DASH_ident_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a symbol or keyword with a namespace"], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_string_STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$key_DASH_test,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$other], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_reset,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$true_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is the value true, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$find_DASH_ns_DASH_obj_STAR_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ctxt,cljs.core.cst$sym$xs], null))),cljs.core.cst$kw$doc,"Bootstrap only."], null)),cljs.core.with_meta(cljs.core.cst$sym$array,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$array,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_DASH_args], null))),cljs.core.cst$kw$doc,"Creates a new javascript array.\n@param {...*} var_args"], null)),cljs.core.with_meta(cljs.core.cst$sym$print,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Prints the object(s) using string-print.\n  print and println produce output for human consumption."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_peek,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IStack,cljs.core.cst$kw$doc,"Returns the item from the top of the stack. Is used by cljs.core/peek.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ISeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_first,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the first item in the collection coll. Used by cljs.core/first."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_rest,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new collection of coll without the first item. It should\n     always return a seq, e.g.\n     (rest []) => ()\n     (rest nil) => ()"], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_first,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_first,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns the first item in the collection coll. Used by cljs.core/first."], null),cljs.core.cst$kw$_DASH_rest,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns a new collection of coll without the first item. It should\n     always return a seq, e.g.\n     (rest []) => ()\n     (rest nil) => ()"], null)], null),cljs.core.cst$kw$doc,"Protocol for collections to provide access to their items as sequences.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$empty,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns an empty collection of the same category as coll, or nil"], null)),cljs.core.with_meta(cljs.core.cst$sym$remove_DASH_method,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn,cljs.core.cst$sym$dispatch_DASH_val], null))),cljs.core.cst$kw$doc,"Removes the method of multimethod associated with dispatch-value."], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentQueueSeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$balance_DASH_right_DASH_del,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$del], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$volatile_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_SLASH_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"If no denominators are supplied, returns 1/numerator,\n  else returns numerator divided by all of the denominators.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$bitpos,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash,cljs.core.cst$sym$shift], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$Many,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_or,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Bitwise or",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$m3_DASH_fmix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h1,cljs.core.cst$sym$len], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$vector,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$doc,"Creates a new vector containing the args.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_coll,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$clone_DASH_and_DASH_set,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$a,cljs.core.cst$sym$j,cljs.core.cst$sym$b], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,5,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,5,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$a,cljs.core.cst$sym$j,cljs.core.cst$sym$b], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$a,cljs.core.cst$sym$j,cljs.core.cst$sym$b], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH__GT_transient_DASH_hash_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_GT__EQ_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns non-nil if nums are in monotonically non-increasing order,\n  otherwise false."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_TransientHashSet,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_ITransientSet,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$transient_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_ITransientSet,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/TransientHashSet."], null)),cljs.core.with_meta(cljs.core.cst$sym$drop_DASH_last,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Return a lazy sequence of all but the last n (default 1) items in coll",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$s], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$s], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ArrayIter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ArrayIter."], null)),cljs.core.with_meta(cljs.core.cst$sym$object_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x's constructor is Object"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ArrayNodeSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ArrayNodeSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$lift_DASH_ns,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m], null))),cljs.core.cst$kw$doc,"Returns [lifted-ns lifted-map] or nil if m can't be lifted."], null)),cljs.core.with_meta(cljs.core.cst$sym$tree_DASH_map_DASH_append,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$left,cljs.core.cst$sym$right], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$not_DASH_empty,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"If coll is empty, returns nil, else coll"], null)),cljs.core.with_meta(cljs.core.cst$sym$distinct,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the elements of coll with duplicates removed.\n  Returns a stateful transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,1,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$partition,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$step,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$step,cljs.core.cst$sym$pad,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of lists of n items each, at offsets step\n  apart. If step is not supplied, defaults to n, i.e. the partitions\n  do not overlap. If a pad collection is supplied, use its elements as\n  necessary to complete last partition up to n items. In case there are\n  not enough padding elements, return a partition with less than n items.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,4,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,4,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$step,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$step,cljs.core.cst$sym$pad,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$step,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$step,cljs.core.cst$sym$pad,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$IMultiFn,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(cljs.core.cst$sym$_DASH_prefer_DASH_method,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_default_DASH_dispatch_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_remove_DASH_method,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_prefers,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_dispatch_DASH_fn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_add_DASH_method,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_reset,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_get_DASH_method,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null))],[new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$dispatch_DASH_val_DASH_y], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$method], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val], null)], null)])], null),cljs.core.cst$kw$sigs,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$_DASH_remove_DASH_method,cljs.core.cst$kw$_DASH_methods,cljs.core.cst$kw$_DASH_dispatch_DASH_fn,cljs.core.cst$kw$_DASH_add_DASH_method,cljs.core.cst$kw$_DASH_prefers,cljs.core.cst$kw$_DASH_reset,cljs.core.cst$kw$_DASH_get_DASH_method,cljs.core.cst$kw$_DASH_prefer_DASH_method,cljs.core.cst$kw$_DASH_default_DASH_dispatch_DASH_val],[new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_remove_DASH_method,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val], null)),cljs.core.cst$kw$doc,null], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_methods,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)),cljs.core.cst$kw$doc,null], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_dispatch_DASH_fn,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)),cljs.core.cst$kw$doc,null], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_add_DASH_method,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$method], null)),cljs.core.cst$kw$doc,null], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_prefers,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)),cljs.core.cst$kw$doc,null], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_reset,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)),cljs.core.cst$kw$doc,null], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_get_DASH_method,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val], null)),cljs.core.cst$kw$doc,null], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_prefer_DASH_method,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$dispatch_DASH_val_DASH_y], null)),cljs.core.cst$kw$doc,null], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_default_DASH_dispatch_DASH_val,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)),cljs.core.cst$kw$doc,null], null)]),cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Many,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vals], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Many."], null)),cljs.core.cst$sym$DEMUNGE_PATTERN,cljs.core.with_meta(cljs.core.cst$sym$fix,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$q], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$EmptyList,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$HashMapIter,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$IAssociative,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_contains_DASH_key_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$doc,"Returns true if k is a key in coll."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new collection of coll with a mapping from key k to\n     value v added to it."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_contains_DASH_key_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_contains_DASH_key_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),cljs.core.cst$kw$doc,"Returns true if k is a key in coll."], null),cljs.core.cst$kw$_DASH_assoc,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)),cljs.core.cst$kw$doc,"Returns a new collection of coll with a mapping from key k to\n     value v added to it."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding associativity to collections.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Single,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Single."], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_flip,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Flip bit at index n"], null)),cljs.core.with_meta(cljs.core.cst$sym$long_DASH_array,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null))),cljs.core.cst$kw$doc,"Creates an array of longs. Does not coerce array, provided for compatibility\n  with Clojure.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$descendants,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag], null))),cljs.core.cst$kw$doc,"Returns the immediate and indirect children of tag, through a\n  relationship established via derive. h must be a hierarchy obtained\n  from make-hierarchy, if not supplied defaults to the global\n  hierarchy. Note: does not work on JavaScript type inheritance\n  relationships.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$imul,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Delay,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$f,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$value,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Delay."], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_for,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$i], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$merge,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$maps], null))),cljs.core.cst$kw$doc,"Returns a map that consists of the rest of the maps conj-ed onto\n  the first.  If a key occurs in more than one map, the mapping from\n  the latter (left-to-right) will be the mapping in the result.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$maps)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$maps], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ISeqable,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_seq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_or_DASH_nil,cljs.core.cst$kw$doc,"Returns a seq of o, or nil if o is empty."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_seq,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_or_DASH_nil], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)),cljs.core.cst$kw$doc,"Returns a seq of o, or nil if o is empty."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding the ability to a type to be transformed into a sequence.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_IntegerRangeChunk,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunk,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$step,cljs.core.cst$sym$count], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/IntegerRangeChunk."], null)),cljs.core.with_meta(cljs.core.cst$sym$Empty,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$js_DASH_mod,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$d], null))),cljs.core.cst$kw$doc,"Modulus of num and div with original javascript behavior. i.e. bug for negative numbers"], null)),cljs.core.with_meta(cljs.core.cst$sym$integer_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Returns true if n is a JavaScript number with no decimal part."], null)),cljs.core.with_meta(cljs.core.cst$sym$MetaFn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_Fn,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$NS_CACHE,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$doc,"Bootstrap only.",cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$mapv,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null))),cljs.core.cst$kw$doc,"Returns a vector consisting of the result of applying f to the\n  set of first items of each coll, followed by applying f to the set\n  of second items in each coll, until any one of the colls is\n  exhausted.  Any remaining items in other colls are ignored. Function\n  f should accept number-of-colls arguments.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$infinite_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true for Infinity and -Infinity values."], null)),cljs.core.with_meta(cljs.core.cst$sym$partition_DASH_all,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$step,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of lists like partition, but may include\n  partitions with fewer than n items at the end.  Returns a stateful\n  transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$step,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$step,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$partition_DASH_by,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Applies f to each value in coll, splitting it each time f returns a\n   new value.  Returns a lazy seq of partitions.  Returns a stateful\n   transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ISequential,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$sigs,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$doc,"Marker interface indicating a persistent collection of sequential items",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_LazySeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$fn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/LazySeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$equiv_DASH_map,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),cljs.core.cst$kw$doc,"Test map equivalence. Returns true if x equals y, otherwise returns false."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Volatile,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IVolatile,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Volatile."], null)),cljs.core.with_meta(cljs.core.cst$sym$object_DASH_array,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null))),cljs.core.cst$kw$doc,"Creates an array of objects. Does not coerce array, provided for compatibility\n  with Clojure.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$Keyword,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$derive,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null))),cljs.core.cst$kw$doc,"Establishes a parent/child relationship between parent and\n  tag. Parent must be a namespace-qualified symbol or keyword and\n  child can be either a namespace-qualified symbol or keyword or a\n  class. h must be a hierarchy obtained from make-hierarchy, if not\n  supplied defaults to, and modifies, the global hierarchy.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$seq_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Empty,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY)),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Empty."], null)),cljs.core.with_meta(cljs.core.cst$sym$IChunkedSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_chunked_DASH_first,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the first chunk in coll."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_chunked_DASH_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Return a new collection of coll with the first chunk removed."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_chunked_DASH_first,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_chunked_DASH_first,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns the first chunk in coll."], null),cljs.core.cst$kw$_DASH_chunked_DASH_rest,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_chunked_DASH_rest,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Return a new collection of coll with the first chunk removed."], null)], null),cljs.core.cst$kw$doc,"Protocol for accessing a collection as sequential chunks.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$special_DASH_symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x names a special form"], null)),cljs.core.with_meta(cljs.core.cst$sym$IntegerRangeChunk,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunk,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$compare_DASH_keywords,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ancestors,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag], null))),cljs.core.cst$kw$doc,"Returns the immediate and indirect parents of tag, either via a JavaScript type\n  inheritance relationship or a relationship established via derive. h\n  must be a hierarchy obtained from make-hierarchy, if not supplied\n  defaults to the global hierarchy",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$subseq,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$start_DASH_test,cljs.core.cst$sym$start_DASH_key,cljs.core.cst$sym$end_DASH_test,cljs.core.cst$sym$end_DASH_key], null))),cljs.core.cst$kw$doc,"sc must be a sorted collection, test(s) one of <, <=, > or\n  >=. Returns a seq of those entries with keys ek for\n  which (test (.. sc comparator (compare ek key)) 0) is true",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,5,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,5,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$start_DASH_test,cljs.core.cst$sym$start_DASH_key,cljs.core.cst$sym$end_DASH_test,cljs.core.cst$sym$end_DASH_key], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$start_DASH_test,cljs.core.cst$sym$start_DASH_key,cljs.core.cst$sym$end_DASH_test,cljs.core.cst$sym$end_DASH_key], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$gensym,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prefix_DASH_string], null))),cljs.core.cst$kw$doc,"Returns a new symbol with a unique name. If a prefix string is\n  supplied, the name is prefix# where # is some unique number. If\n  prefix is not supplied, the prefix is 'G__'.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,1,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prefix_DASH_string], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prefix_DASH_string], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_next,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_INext,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_or_DASH_nil,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a new collection of coll without the first item. In contrast to\n     rest, it should return nil if there are no more items, e.g.\n     (next []) => nil\n     (next nil) => nil"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_HashCollisionNode,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$collision_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/HashCollisionNode."], null)),cljs.core.with_meta(cljs.core.cst$sym$delay_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"returns true if x is a Delay created with delay"], null)),cljs.core.with_meta(cljs.core.cst$sym$create_DASH_inode_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$flatten,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Takes any nested combination of sequential things (lists, vectors,\n  etc.) and returns their contents as a single, flat sequence.\n  (flatten nil) returns nil."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_dissoc,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMap,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null))),cljs.core.cst$kw$doc,"Returns a new collection of coll without the mapping for key k."], null)),cljs.core.with_meta(cljs.core.cst$sym$doubles,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$halt_DASH_when,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$added,"1.9",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$retf], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$retf], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$retf], null))),cljs.core.cst$kw$doc,"Returns a transducer that ends transduction when pred returns true\n  for an input. When retf is supplied it must be a fn of 2 arguments -\n  it will be passed the (completed) result so far and the input that\n  triggered the predicate, and its return value (if it does not throw\n  an exception) will be the return value of the transducer. If retf\n  is not supplied, the input that triggered the predicate will be\n  returned. If the predicate never returns true the transduction is\n  unaffected."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_contains_DASH_key_QMARK_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IAssociative,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null))),cljs.core.cst$kw$doc,"Returns true if k is a key in coll."], null)),cljs.core.with_meta(cljs.core.cst$sym$remove_DASH_watch,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iref,cljs.core.cst$sym$key], null))),cljs.core.cst$kw$doc,"Removes a watch (set by add-watch) from a reference"], null)),cljs.core.with_meta(cljs.core.cst$sym$ex_DASH_info,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$msg,cljs.core.cst$sym$data], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$msg,cljs.core.cst$sym$data,cljs.core.cst$sym$cause], null))),cljs.core.cst$kw$doc,"Create an instance of ExceptionInfo, an Error type that carries a\n  map of additional data.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$msg,cljs.core.cst$sym$data], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$msg,cljs.core.cst$sym$data,cljs.core.cst$sym$cause], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$msg,cljs.core.cst$sym$data], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$msg,cljs.core.cst$sym$data,cljs.core.cst$sym$cause], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ifn_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Returns true if f returns true for fn? or satisfies IFn."], null)),cljs.core.with_meta(cljs.core.cst$sym$IAtom,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$sigs,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$doc,"Marker protocol indicating an atom.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentQueue,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentQueue."], null)),cljs.core.with_meta(cljs.core.cst$sym$nat_DASH_int_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies int? and is a natural integer value."], null)),cljs.core.with_meta(cljs.core.cst$sym$IWatchable,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_notify_DASH_watches,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Calls all watchers with this, oldval and newval."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$oldval,cljs.core.cst$sym$newval], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_add_DASH_watch,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Adds a watcher function f to this. Keys must be unique per reference,\n     and can be used to remove the watch with -remove-watch."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key,cljs.core.cst$sym$f], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_remove_DASH_watch,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Removes watcher that corresponds to key from this."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$_DASH_notify_DASH_watches,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_notify_DASH_watches,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$oldval,cljs.core.cst$sym$newval], null)),cljs.core.cst$kw$doc,"Calls all watchers with this, oldval and newval."], null),cljs.core.cst$kw$_DASH_add_DASH_watch,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_add_DASH_watch,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key,cljs.core.cst$sym$f], null)),cljs.core.cst$kw$doc,"Adds a watcher function f to this. Keys must be unique per reference,\n     and can be used to remove the watch with -remove-watch."], null),cljs.core.cst$kw$_DASH_remove_DASH_watch,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_remove_DASH_watch,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key], null)),cljs.core.cst$kw$doc,"Removes watcher that corresponds to key from this."], null)], null),cljs.core.cst$kw$doc,"Protocol for types that can be watched. Currently only implemented by Atom.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$pv_DASH_fresh_DASH_node,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$subvec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_pop_BANG_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ITransientVector,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null))),cljs.core.cst$kw$doc,"Returns tcoll with the last item removed from it."], null)),cljs.core.with_meta(cljs.core.cst$sym$partial,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1,cljs.core.cst$sym$arg2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1,cljs.core.cst$sym$arg2,cljs.core.cst$sym$arg3], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1,cljs.core.cst$sym$arg2,cljs.core.cst$sym$arg3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Takes a function f and fewer than the normal arguments to f, and\n  returns a fn that takes a variable number of additional args. When\n  called, the returned function calls f with args + additional args.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1,cljs.core.cst$sym$arg2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1,cljs.core.cst$sym$arg2,cljs.core.cst$sym$arg3], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1,cljs.core.cst$sym$arg2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1,cljs.core.cst$sym$arg2,cljs.core.cst$sym$arg3], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$arg1,cljs.core.cst$sym$arg2,cljs.core.cst$sym$arg3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$chunked_DASH_seq_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies IChunkedSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$replicate,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"DEPRECATED: Use 'repeat' instead.\n  Returns a lazy seq of n xs."], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentQueue,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$min_DASH_key,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the x for which (k x), a number, is least.\n\n  If there are multiple such xs, the last one is returned.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_iset,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$reduced,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Wraps x in a way such that a reduce will terminate with the value x"], null)),cljs.core.with_meta(cljs.core.cst$sym$re_DASH_matches,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Returns the result of (re-find re s) if re fully matches s."], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_writer_DASH_impl,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null))),cljs.core.cst$kw$doc,"keyval => key val\n  Returns a new array map with supplied mappings.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$keyvals)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ITransientSet,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_disjoin_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns tcoll without v."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$v], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_disjoin_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_disjoin_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$v], null)),cljs.core.cst$kw$doc,"Returns tcoll without v."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding set functionality to a transient collection.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.cst$sym$ITER_SYMBOL,cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_byte,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$checked_DASH_aset,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$ArrayNode,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ChunkedSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vec,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$off,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ChunkedSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$every_DASH_pred,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ps], null))),cljs.core.cst$kw$doc,"Takes a set of predicates and returns a function f that returns true if all of its\n  composing predicates return a logical true value against all of its arguments, else it returns\n  false. Note that f is short-circuiting in that it will stop execution on the first\n  argument that triggers a logical false result against the original predicates.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ps], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$t_cljs$core4194,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$anonymous,true,cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$keys,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$missing_DASH_protocol,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$proto,cljs.core.cst$sym$obj], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$load_DASH_file,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$file], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentArrayMap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$distinct_QMARK_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns true if no two of the arguments are ="], null)),cljs.core.with_meta(cljs.core.cst$sym$pos_DASH_int_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies int? and is positive."], null)),cljs.core.with_meta(cljs.core.cst$sym$never_DASH_equiv,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$private,true], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_short,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Range,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step,cljs.core.with_meta(cljs.core.cst$sym$chunk,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$chunk_DASH_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Range."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_MapEntry,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/MapEntry."], null)),cljs.core.with_meta(cljs.core.cst$sym$apply_DASH_to_DASH_simple,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.cst$sym$a1,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.cst$sym$a1,cljs.core.cst$sym$a2,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.cst$sym$a1,cljs.core.cst$sym$a2,cljs.core.cst$sym$a3,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.cst$sym$a1,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.cst$sym$a1,cljs.core.cst$sym$a2,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.cst$sym$a1,cljs.core.cst$sym$a2,cljs.core.cst$sym$a3,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.cst$sym$a1,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.cst$sym$a1,cljs.core.cst$sym$a2,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$a0,cljs.core.cst$sym$a1,cljs.core.cst$sym$a2,cljs.core.cst$sym$a3,cljs.core.with_meta(cljs.core.cst$sym$args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq], null))], null))),cljs.core.cst$kw$doc,"Internal. DO NOT USE!\n  Assumes args was already called with seq beforehand!"], null)),cljs.core.with_meta(cljs.core.cst$sym$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null))),cljs.core.cst$kw$doc,"Given a multimethod, returns a map of dispatch values -> dispatch fns"], null)),cljs.core.with_meta(cljs.core.cst$sym$odd_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Returns true if n is odd, throws an exception if n is not an integer"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ArrayChunk,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunk,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ArrayChunk."], null)),cljs.core.with_meta(cljs.core.cst$sym$ci_DASH_reduce,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cicoll,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cicoll,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$val], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cicoll,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cicoll,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cicoll,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cicoll,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$val], null))),cljs.core.cst$kw$doc,"Accepts any collection which satisfies the ICount and IIndexed protocols and\nreduces them without incurring seq initialization"], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_3,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"bound in a repl thread to the third most recent value printed"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_get_DASH_method,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Var,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_Fn,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val,cljs.core.cst$sym$sym,cljs.core.cst$sym$_meta], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Var."], null)),cljs.core.with_meta(cljs.core.cst$sym$frequencies,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a map from distinct items in coll to the number of times\n  they appear."], null)),cljs.core.with_meta(cljs.core.cst$sym$reduceable_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if coll satisfies IReduce"], null)),cljs.core.cst$sym$string_DASH_hash_DASH_cache,cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Iterate,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$f,cljs.core.cst$sym$prev_DASH_seed,cljs.core.with_meta(cljs.core.cst$sym$seed,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Iterate."], null)),cljs.core.with_meta(cljs.core.cst$sym$rsubseq,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$start_DASH_test,cljs.core.cst$sym$start_DASH_key,cljs.core.cst$sym$end_DASH_test,cljs.core.cst$sym$end_DASH_key], null))),cljs.core.cst$kw$doc,"sc must be a sorted collection, test(s) one of <, <=, > or\n  >=. Returns a reverse seq of those entries with keys ek for\n  which (test (.. sc comparator (compare ek key)) 0) is true",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,5,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,5,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$start_DASH_test,cljs.core.cst$sym$start_DASH_key,cljs.core.cst$sym$end_DASH_test,cljs.core.cst$sym$end_DASH_key], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$start_DASH_test,cljs.core.cst$sym$start_DASH_key,cljs.core.cst$sym$end_DASH_test,cljs.core.cst$sym$end_DASH_key], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$inc,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns a number one greater than num."], null)),cljs.core.with_meta(cljs.core.cst$sym$type_DASH__GT_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ty], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$obj_DASH_clone,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$ks], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$get_DASH_method,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn,cljs.core.cst$sym$dispatch_DASH_val], null))),cljs.core.cst$kw$doc,"Given a multimethod and a dispatch value, returns the dispatch fn\n  that would apply to that value, or nil if none apply and no default"], null)),cljs.core.with_meta(cljs.core.cst$sym$uuid_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$vector_DASH_index_DASH_out_DASH_of_DASH_bounds,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$i,cljs.core.cst$sym$cnt], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$es6_DASH_entries_DASH_iterator,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_clear,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Clear bit at index n"], null)),cljs.core.with_meta(cljs.core.cst$sym$Range,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$filter,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the items in coll for which\n  (pred item) returns logical true. pred must be free of side-effects.\n  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentTreeMapSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$stack,cljs.core.with_meta(cljs.core.cst$sym$ascending_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$cnt,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentTreeMapSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$create_DASH_array_DASH_node_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_DASH_n_BANG_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ITransientVector,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$n,cljs.core.cst$sym$val], null))),cljs.core.cst$kw$doc,"Returns tcoll with value val added at position n."], null)),cljs.core.with_meta(cljs.core.cst$sym$IWithMeta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_with_DASH_meta,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new object with value of o and metadata meta added to it."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$meta], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_with_DASH_meta,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_with_DASH_meta,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$meta], null)),cljs.core.cst$kw$doc,"Returns a new object with value of o and metadata meta added to it."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding metadata to an object.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$next_STAR_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$seq,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Internal. DO NOT USE! Next without the nil? check."], null)),cljs.core.with_meta(cljs.core.cst$sym$list,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_PLUS_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the sum of nums. (+) returns 0."], null)),cljs.core.with_meta(cljs.core.cst$sym$IndexedSeqIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$split_DASH_with,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a vector of [(take-while pred coll) (drop-while pred coll)]"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_VectorNode,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$arr], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/VectorNode."], null)),cljs.core.with_meta(cljs.core.cst$sym$aset,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null))),cljs.core.cst$kw$doc,"Sets the value at the index/indices. Works on JavaScript arrays.\n  Returns val.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$int_DASH_rotate_DASH_left,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$keyword,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name], null))),cljs.core.cst$kw$doc,"Returns a Keyword with the given namespace and name.  Do not use :\n  in the keyword strings, it will be added automatically.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Cons,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Cons."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_ns_STAR_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"Var bound to the current namespace. Only used for bootstrapping.",cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_assert_STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dynamic,true], null)),cljs.core.with_meta(cljs.core.cst$sym$create_DASH_tree_DASH_map_DASH_seq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tree,cljs.core.cst$sym$ascending_QMARK_,cljs.core.cst$sym$cnt], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ICollection,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_conj,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new collection of coll with o added to it. The new item\n     should be added to the most efficient place, e.g.\n     (conj [1 2 3 4] 5) => [1 2 3 4 5]\n     (conj '(2 3 4 5) 1) => '(1 2 3 4 5)"], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$o], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_conj,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_conj,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$o], null)),cljs.core.cst$kw$doc,"Returns a new collection of coll with o added to it. The new item\n     should be added to the most efficient place, e.g.\n     (conj [1 2 3 4] 5) => [1 2 3 4 5]\n     (conj '(2 3 4 5) 1) => '(1 2 3 4 5)"], null)], null),cljs.core.cst$kw$doc,"Protocol for adding to a collection.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$chars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$str,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ys], null))),cljs.core.cst$kw$doc,"With no args, returns the empty string. With one arg x, returns\n  x.toString().  (str nil) returns the empty string. With more than\n  one arg, returns the concatenation of the str values of the args.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ys], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$next,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$seq,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a seq of the items after the first. Calls seq on its\n  argument.  If there are no more items, returns nil"], null)),cljs.core.with_meta(cljs.core.cst$sym$ASeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$sigs,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$doc,"Marker protocol indicating an array sequence.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_seq_DASH_writer,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$objs,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$SeqIter,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$IFn,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_invoke,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,null], null)),new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i], null),new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j], null),new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l], null),new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o], null),new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q], null),new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r], null),new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s], null),new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t], null),new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t,cljs.core.cst$sym$rest], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_invoke,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_invoke,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i], null),new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j], null),new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l], null),new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o], null),new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q], null),new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r], null),new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s], null),new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t], null),new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t,cljs.core.cst$sym$rest], null)),cljs.core.cst$kw$doc,null], null)], null),cljs.core.cst$kw$doc,"Protocol for adding the ability to invoke an object as a function.\n  For example, a vector can also be used to look up a value:\n  ([1 2 3 4] 1) => 2",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$regexp_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is a JavaScript RegExp instance."], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_exec_DASH_tap_DASH_fn_STAR_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$doc,"Arranges to have tap functions executed via the supplied f, a\n  function of no arguments. Returns true if successful, false otherwise.",cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$underive,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null))),cljs.core.cst$kw$doc,"Removes a parent/child relationship between parent and\n  tag. h must be a hierarchy obtained from make-hierarchy, if not\n  supplied defaults to, and modifies, the global hierarchy.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag,cljs.core.cst$sym$parent], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_copy,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$from,cljs.core.cst$sym$i,cljs.core.cst$sym$to,cljs.core.cst$sym$j,cljs.core.cst$sym$len], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$obj_DASH_map_DASH_compare_DASH_keys,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_reset_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IReset,cljs.core.cst$kw$doc,"Sets the value of o to new-value.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$new_DASH_value], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_rest,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISeq,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a new collection of coll without the first item. It should\n     always return a seq, e.g.\n     (rest []) => ()\n     (rest nil) => ()"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__DASH_destructure_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$nil_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.with_meta(cljs.core.cst$sym$pr_DASH_writer,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$false_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is the value false, false otherwise."], null)),cljs.core.with_meta(cljs.core.cst$sym$RangedIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_readably_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"When set to logical false, strings and characters will be printed with\n  non-alphanumeric characters converted to the appropriate escape sequences.\n\n  Defaults to true"], null)),cljs.core.with_meta(cljs.core.cst$sym$ints,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$some_DASH_fn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ps], null))),cljs.core.cst$kw$doc,"Takes a set of predicates and returns a function f that returns the first logical true value\n  returned by one of its composing predicates against any of its arguments, else it returns\n  logical false. Note that f is short-circuiting in that it will stop execution on the first\n  argument that triggers a logical true result against the original predicates.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1,cljs.core.cst$sym$p2,cljs.core.cst$sym$p3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ps], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$demunge_DASH_pattern,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.with_meta(cljs.core.cst$sym$maybe_DASH_enable_DASH_print_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_flush_DASH_on_DASH_newline_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"When set to true, output will be flushed whenever a newline is printed.\n\n  Defaults to true."], null)),cljs.core.with_meta(cljs.core.cst$sym$to_DASH_array,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$build_DASH_subvec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$maybe_DASH_warn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$e], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$Namespace,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$list_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x implements IList"], null)),cljs.core.with_meta(cljs.core.cst$sym$tree_DASH_map_DASH_remove,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$k,cljs.core.cst$sym$found], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$PersistentQueueIter,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$HashCollisionNode,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$array_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is a JavaScript array."], null)),cljs.core.with_meta(cljs.core.cst$sym$prefers_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$prefer_DASH_table], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$simple_DASH_ident_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a symbol or keyword without a namespace"], null)),cljs.core.with_meta(cljs.core.cst$sym$clone,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null))),cljs.core.cst$kw$doc,"Clone the supplied value which must implement ICloneable."], null)),cljs.core.with_meta(cljs.core.cst$sym$scan_DASH_array,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$incr,cljs.core.cst$sym$k,cljs.core.cst$sym$array], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$demunge,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$bit_DASH_not,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Bitwise complement"], null)),cljs.core.with_meta(cljs.core.cst$sym$quote_DASH_string,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$byte,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$max,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns the greatest of the nums."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Repeat,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$val,cljs.core.with_meta(cljs.core.cst$sym$next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Repeat."], null)),cljs.core.with_meta(cljs.core.cst$sym$IComparable,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_compare,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$doc,"Returns a negative number, zero, or a positive number when x is logically\n     'less than', 'equal to', or 'greater than' y."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_compare,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_compare,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$doc,"Returns a negative number, zero, or a positive number when x is logically\n     'less than', 'equal to', or 'greater than' y."], null)], null),cljs.core.cst$kw$doc,"Protocol for values that can be compared.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$_EQ__EQ_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Returns non-nil if nums all have the equivalent\n  value, otherwise false. Behavior on non nums is\n  undefined."], null)),cljs.core.with_meta(cljs.core.cst$sym$parents,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag], null))),cljs.core.cst$kw$doc,"Returns the immediate parents of tag, either via a JavaScript type\n  inheritance relationship or a relationship established via derive. h\n  must be a hierarchy obtained from make-hierarchy, if not supplied\n  defaults to the global hierarchy",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tag], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$tag], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_disjoin_BANG_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ITransientSet,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Returns tcoll without v."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_loaded_DASH_libs_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$private,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_TransientHashMap,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$edit,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$nil_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/TransientHashMap."], null)),cljs.core.with_meta(cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ArrayChunk,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$sorted_DASH_map_DASH_by,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comparator,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null))),cljs.core.cst$kw$doc,"keyval => key val\n  Returns a new sorted map with supplied mappings, using the supplied comparator.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$comparator,cljs.core.cst$sym$keyvals)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comparator,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$apply,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$get_DASH_global_DASH_hierarchy,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.with_meta(cljs.core.cst$sym$add_DASH_to_DASH_string_DASH_hash_DASH_cache,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$clj_DASH__GT_js,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$TransientArrayMap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_TransientVector,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientVector,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$shift,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$tail,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientVector,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/TransientVector."], null)),cljs.core.with_meta(cljs.core.cst$sym$IChunkedNext,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_chunked_DASH_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns a new collection of coll without the first chunk."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_chunked_DASH_next,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_chunked_DASH_next,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns a new collection of coll without the first chunk."], null)], null),cljs.core.cst$kw$doc,"Protocol for accessing the chunks of a collection.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$interpose,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sep], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sep,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy seq of the elements of coll separated by sep.\n  Returns a stateful transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sep], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sep,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sep], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sep,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$TransformerIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_BlackNode,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/BlackNode."], null)),cljs.core.with_meta(cljs.core.cst$sym$deref,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$pv_DASH_aget,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$idx], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$assoc,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$kvs], null))),cljs.core.cst$kw$doc,"assoc[iate]. When applied to a map, returns a new map of the\n   same (hashed/sorted) type, that contains the mapping of key(s) to\n   val(s). When applied to a vector, returns a new vector that\n   contains val at index. Note - index must be <= (count vector).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$kvs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$transient,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a new, transient version of the collection, in constant time."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_disjoin,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISet,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Returns a new collection of coll that does not contain v."], null)),cljs.core.with_meta(cljs.core.cst$sym$chunk_DASH_cons,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$chunk,cljs.core.cst$sym$rest], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ArrayIter,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$comparator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null))),cljs.core.cst$kw$doc,"Returns an JavaScript compatible comparator based upon pred."], null)),cljs.core.with_meta(cljs.core.cst$sym$print_DASH_prefix_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prefix,cljs.core.cst$sym$m,cljs.core.cst$sym$print_DASH_one,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$sorted_DASH_map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null))),cljs.core.cst$kw$doc,"keyval => key val\n  Returns a new sorted map with supplied mappings.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$keyvals)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$drop_DASH_while,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the items in coll starting from the\n  first item for which (pred item) returns logical false.  Returns a\n  stateful transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$IWriter,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_write,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Writes s with writer and returns the result."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$s], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_flush,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Flush writer."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_DASH_write,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_write,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$s], null)),cljs.core.cst$kw$doc,"Writes s with writer and returns the result."], null),cljs.core.cst$kw$_DASH_flush,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_flush,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer], null)),cljs.core.cst$kw$doc,"Flush writer."], null)], null),cljs.core.cst$kw$doc,"Protocol for writing. Currently only implemented by StringBufferWriter.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$KeySeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$realized_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if a value has been produced for a delay or lazy sequence."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_fn_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$doc,"Each runtime environment provides a different way to print output.\n  Whatever function *print-fn* is bound to will be passed any\n  Strings which should be printed.",cljs.core.cst$kw$dynamic,true], null)),cljs.core.with_meta(cljs.core.cst$sym$compare,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$complement,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Takes a fn f and returns a fn that takes the same arguments as f,\n  has the same effects, if any, and returns the opposite truth value."], null)),cljs.core.with_meta(cljs.core.cst$sym$lookup_DASH_sentinel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$private,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null))),cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll with a mapping from key to\n     val added to it."], null)),cljs.core.with_meta(cljs.core.cst$sym$_STAR_print_DASH_dup_STAR_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"When set to logical true, objects will be printed in a way that preserves\n  their type when read in later.\n\n  Defaults to false."], null)),cljs.core.with_meta(cljs.core.cst$sym$string_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_key_DASH__GT_js,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IEncodeJS,cljs.core.cst$kw$doc,"Transforms map keys to valid JavaScript keys. Arbitrary keys are\n  encoded to their string representation via (pr-str x)",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$IDeref,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_deref,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the value of the reference o."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_deref,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_deref,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)),cljs.core.cst$kw$doc,"Returns the value of the reference o."], null)], null),cljs.core.cst$kw$doc,"Protocol for adding dereference functionality to a reference.",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$sequence,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null))),cljs.core.cst$kw$doc,"Coerces coll to a (possibly empty) sequence, if it is not already\n  one. Will not force a lazy seq. (sequence nil) yields (), When a\n  transducer is supplied, returns a lazy sequence of applications of\n  the transform to the items in coll(s), i.e. to the set of first\n  items of each coll, followed by the set of second\n  items in each coll, until any one of the colls is exhausted.  Any\n  remaining items in other colls are ignored. The transform should accept\n  number-of-colls arguments",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$constantly,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns a function that takes any number of arguments and returns x."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_RangedIterator,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$base,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null,cljs.core.cst$kw$doc,"Positional factory function for cljs.core/RangedIterator."], null)),cljs.core.with_meta(cljs.core.cst$sym$chunked_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$ISorted,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_sorted_DASH_seq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a sorted seq from coll in either ascending or descending order."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$ascending_QMARK_], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_sorted_DASH_seq_DASH_from,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a sorted seq from coll in either ascending or descending order.\n     If ascending is true, the result should contain all items which are > or >=\n     than k. If ascending is false, the result should contain all items which\n     are < or <= than k, e.g.\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)"], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$ascending_QMARK_], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_entry_DASH_key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the key for entry."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$entry], null)], null),cljs.core.with_meta(cljs.core.cst$sym$_DASH_comparator,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$doc,"Returns the comparator for coll."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),cljs.core.cst$kw$sigs,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$_DASH_sorted_DASH_seq,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_sorted_DASH_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$ascending_QMARK_], null)),cljs.core.cst$kw$doc,"Returns a sorted seq from coll in either ascending or descending order."], null),cljs.core.cst$kw$_DASH_sorted_DASH_seq_DASH_from,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_sorted_DASH_seq_DASH_from,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$ascending_QMARK_], null)),cljs.core.cst$kw$doc,"Returns a sorted seq from coll in either ascending or descending order.\n     If ascending is true, the result should contain all items which are > or >=\n     than k. If ascending is false, the result should contain all items which\n     are < or <= than k, e.g.\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)"], null),cljs.core.cst$kw$_DASH_entry_DASH_key,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_entry_DASH_key,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$entry], null)),cljs.core.cst$kw$doc,"Returns the key for entry."], null),cljs.core.cst$kw$_DASH_comparator,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.cst$sym$_DASH_comparator,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$doc,"Returns the comparator for coll."], null)], null),cljs.core.cst$kw$doc,"Protocol for a collection which can represent their items\n  in a sorted manner. ",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$make_DASH_array,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$size], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$size], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$size,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more_DASH_sizes], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$array,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$size], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$size,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more_DASH_sizes], null))),cljs.core.cst$kw$doc,"Construct a JavaScript array of the specified dimensions. Accepts ignored\n  type argument for compatibility with Clojure. Note that there is no efficient\n  way to allocate multi-dimensional arrays in JavaScript; as such, this function\n  will run in polynomial time when called with 3 or more arguments."], null)),cljs.core.with_meta(cljs.core.cst$sym$checked_DASH_aget,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$shorts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.cst$sym$_STAR_unchecked_DASH_if_STAR_,cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_RSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ci,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/RSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$enable_DASH_console_DASH_print_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY)),cljs.core.cst$kw$doc,"Set *print-fn* to console.log"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_flush,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IWriter,cljs.core.cst$kw$doc,"Flush writer.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_lastIndexOf,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$start], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$start], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$start], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$completing,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$cf], null))),cljs.core.cst$kw$doc,"Takes a reducing function f of 2 args and returns a fn suitable for\n  transduce by adding an arity-1 signature that calls cf (default -\n  identity) on the result argument.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$cf], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$cf], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_negate_DASH_int,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentVector,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 24, [cljs.core.cst$sym$cljs$core_SLASH_APersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$shift,cljs.core.cst$sym$root,cljs.core.cst$sym$tail,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentVector."], null)),cljs.core.with_meta(cljs.core.cst$sym$equiv_DASH_sequential,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$hash_DASH_unordered_DASH_coll,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns the hash code, consistent with =, for an external unordered\n   collection implementing Iterable. For maps, the iterator should\n   return map entries whose hash is computed as\n     (hash-ordered-coll [k v]).\n   See http://clojure.org/data_structures#hash for full algorithms."], null)),cljs.core.with_meta(cljs.core.cst$sym$repeat,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns a lazy (infinite!, or length n if supplied) sequence of xs.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$x], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$nthnext,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Returns the nth next of coll, (seq coll) when n is 0."], null)),cljs.core.with_meta(cljs.core.cst$sym$preserving_DASH_reduced,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$rf], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$get_DASH_validator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iref], null))),cljs.core.cst$kw$doc,"Gets the validator-fn for a var/ref/agent/atom."], null)),cljs.core.with_meta(cljs.core.cst$sym$StringIter,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$number_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is a JavaScript number."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_conj_BANG_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null))),cljs.core.cst$kw$doc,"Adds value val to tcoll and returns tcoll."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_PersistentArrayMapSeq,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$_meta], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/PersistentArrayMapSeq."], null)),cljs.core.with_meta(cljs.core.cst$sym$chunk_DASH_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$ArrayList,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$print_DASH_str,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null))),cljs.core.cst$kw$doc,"print to a string, returning it",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null)),cljs.core.with_meta(cljs.core.cst$sym$not_DASH_any_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns false if (pred x) is logical true for any x in coll,\n  else true."], null)),cljs.core.with_meta(cljs.core.cst$sym$into_DASH_array,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_hash,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IHash,cljs.core.cst$kw$doc,"Returns the hash code of o.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$qualified_DASH_symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a symbol with a namespace"], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_dissoc_BANG_,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key], null))),cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll without the mapping for key."], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_Reduced,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/Reduced."], null)),cljs.core.with_meta(cljs.core.cst$sym$chunk_DASH_buffer,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$capacity], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$seqable_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Return true if the seq function is supported for s"], null)),cljs.core.with_meta(cljs.core.cst$sym$symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a Symbol"], null)),cljs.core.with_meta(cljs.core.cst$sym$m3_DASH_hash_DASH_unencoded_DASH_chars,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$in], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$unchecked_DASH_char,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$system_DASH_time,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY)),cljs.core.cst$kw$doc,"Returns highest resolution time offered by host in milliseconds."], null)),cljs.core.with_meta(cljs.core.cst$sym$NeverEquiv,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null"], null), null)], null)),cljs.core.with_meta(cljs.core.cst$sym$chunkIteratorSeq,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_invoke,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IFn,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,22,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,22,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i], null),new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j], null),new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l], null),new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o], null),new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q], null),new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r], null),new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s], null),new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t], null),new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t,cljs.core.cst$sym$rest], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i], null),new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j], null),new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l], null),new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o], null),new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q], null),new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r], null),new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s], null),new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t], null),new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t,cljs.core.cst$sym$rest], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i], null),new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j], null),new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l], null),new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o], null),new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p], null),new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q], null),new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r], null),new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s], null),new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t], null),new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$e,cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$i,cljs.core.cst$sym$j,cljs.core.cst$sym$k,cljs.core.cst$sym$l,cljs.core.cst$sym$m,cljs.core.cst$sym$n,cljs.core.cst$sym$o,cljs.core.cst$sym$p,cljs.core.cst$sym$q,cljs.core.cst$sym$r,cljs.core.cst$sym$s,cljs.core.cst$sym$t,cljs.core.cst$sym$rest], null))),cljs.core.cst$kw$doc,null], null)),cljs.core.with_meta(cljs.core.cst$sym$coll_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x satisfies ICollection"], null)),cljs.core.with_meta(cljs.core.cst$sym$get_DASH_in,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$added,"1.2",cljs.core.cst$kw$static,true,cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$ks], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$ks,cljs.core.cst$sym$not_DASH_found], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$ks], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$ks,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$ks], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$ks,cljs.core.cst$sym$not_DASH_found], null))),cljs.core.cst$kw$doc,"Returns the value in a nested associative structure,\n  where ks is a sequence of keys. Returns nil if the key is not present,\n  or the not-found value if supplied."], null)),cljs.core.with_meta(cljs.core.cst$sym$fnext,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Same as (first (next x))"], null)),cljs.core.with_meta(cljs.core.cst$sym$IList,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$kw$sigs,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$doc,"Marker interface indicating a persistent list",cljs.core.cst$kw$jsdoc,cljs.core.list("@interface")], null)),cljs.core.with_meta(cljs.core.cst$sym$ArrayNodeIterator,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,null], null)),cljs.core.with_meta(cljs.core.cst$sym$List,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$declared,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_val,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,cljs.core.cst$kw$doc,"Returns the value of the map entry.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$bytes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH__GT_ObjMap,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$keys,cljs.core.cst$sym$strobj,cljs.core.cst$sym$update_DASH_count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/ObjMap."], null)),cljs.core.with_meta(cljs.core.cst$sym$compare_DASH_symbols,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b], null)))], null)),cljs.core.with_meta(cljs.core.cst$sym$_DASH_seq,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISeqable,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_or_DASH_nil,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null))),cljs.core.cst$kw$doc,"Returns a seq of o, or nil if o is empty."], null))],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),"cljs/core.cljs",27,10,cljs.core.cst$kw$positional,9183,9183,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),"Positional factory function for cljs.core/PersistentHashSet."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_PersistentHashSet,"cljs/core.cljs",27,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null)),null,cljs.core.list(null,null),1,false,cljs.core.cst$kw$positional,9183,cljs.core.cst$sym$cljs$core_SLASH_PersistentHashSet,9183,3,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),"Positional factory function for cljs.core/PersistentHashSet."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,10903,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,10903,cljs.core.cst$kw$end_DASH_column,14,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null))),cljs.core.cst$kw$doc,"Recursively transforms JavaScript arrays into ClojureScript\n  vectors, and JavaScript objects into ClojureScript maps.  With\n  option ':keywordize-keys true' will convert object fields from\n  strings to keywords.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_js_DASH__GT_clj,"cljs/core.cljs",14,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),null,(1),cljs.core.list(null,null),1,true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,1,cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,"null",cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null"], null), null)], null)], null),10903,10903,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null)),"Recursively transforms JavaScript arrays into ClojureScript\n  vectors, and JavaScript objects into ClojureScript maps.  With\n  option ':keywordize-keys true' will convert object fields from\n  strings to keywords."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,2476,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,2476,cljs.core.cst$kw$end_DASH_column,14,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a sorted sequence of the items in coll, where the sort\n   order is determined by comparing (keyfn item).  Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_sort_DASH_by,"cljs/core.cljs",14,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null)], null),2476,2476,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),"Returns a sorted sequence of the items in coll, where the sort\n   order is determined by comparing (keyfn item).  Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$sigs,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$sigs,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",35,14,808,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll with a mapping from key to\n     val added to it."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)], null)], null)], null),808,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll with a mapping from key to\n     val added to it."], null)], null),"Protocol for adding associativity to transient collections.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"cljs/core.cljs",35,1,808,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj,cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll with a mapping from key to\n     val added to it."], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)], null)], null)], null),null,808,cljs.core.cst$sym$any,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,cljs.core.with_meta(cljs.core.cst$sym$_DASH_assoc_BANG_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$doc,"Returns a new transient collection of tcoll with a mapping from key to\n     val added to it."], null)], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_TransientVector,"null",cljs.core.cst$sym$clojure$core$rrb_DASH_vector$rrbt_SLASH_Transient,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientArrayMap,"null"], null), null),"Protocol for adding associativity to transient collections.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,3658,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,3658,cljs.core.cst$kw$end_DASH_column,18,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_chunk_DASH_first,"cljs/core.cljs",18,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),1,false,3658,cljs.core.cst$sym$any,3658,1,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,10235,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,10235,cljs.core.cst$kw$end_DASH_column,18,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts,cljs.core.cst$sym$obj], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_print_DASH_meta_QMARK_,"cljs/core.cljs",18,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts,cljs.core.cst$sym$obj], null)),null,cljs.core.list(null,null),1,false,10235,cljs.core.cst$sym$boolean,10235,2,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts,cljs.core.cst$sym$obj], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,944,cljs.core.cst$kw$column,15,cljs.core.cst$kw$end_DASH_line,944,cljs.core.cst$kw$end_DASH_column,26,cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$in], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_m3_DASH_hash_DASH_int,"cljs/core.cljs",26,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$in], null)),null,cljs.core.list(null,null),1,false,944,cljs.core.cst$sym$number,944,1,cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$in], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,892,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,892,cljs.core.cst$kw$end_DASH_column,14,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$obj,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null))], null))),cljs.core.cst$kw$doc,"Support so that collections can implement toString without\n   loading all the printing machinery."], null),cljs.core.cst$sym$cljs$core_SLASH_pr_DASH_str_STAR_,"cljs/core.cljs",14,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$obj,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null))], null)),null,cljs.core.list(null,null),1,false,892,cljs.core.cst$sym$string,892,1,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$obj,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null))], null))),"Support so that collections can implement toString without\n   loading all the printing machinery."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,10838,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,10838,cljs.core.cst$kw$end_DASH_column,15,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform_STAR_,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a reducible/iterable application of the transducers\n  to the items in coll. Transducers are applied in order as if\n  combined with comp. Note that these applications will be\n  performed every time reduce/iterator is called.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$xforms)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xforms], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_eduction,"cljs/core.cljs",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$xforms)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xforms], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$xforms)], null),null,(0),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_Eduction], null)], null),10838,cljs.core.cst$sym$any,10838,(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xforms], null)),"Returns a reducible/iterable application of the transducers\n  to the items in coll. Transducers are applied in order as if\n  combined with comp. Note that these applications will be\n  performed every time reduce/iterator is called."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,5219,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,5219,cljs.core.cst$kw$end_DASH_column,15,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$branch_QMARK_,cljs.core.cst$sym$children,cljs.core.cst$sym$root], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the nodes in a tree, via a depth-first walk.\n  branch? must be a fn of one arg that returns true if passed a node\n  that can have children (but may not).  children must be a fn of one\n  arg that returns a sequence of the children. Will only be called on\n  nodes for which branch? returns true. Root is the root node of the\n  tree."], null),cljs.core.cst$sym$cljs$core_SLASH_tree_DASH_seq,"cljs/core.cljs",15,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$branch_QMARK_,cljs.core.cst$sym$children,cljs.core.cst$sym$root], null)),null,cljs.core.list(null,null),1,false,5219,cljs.core.cst$sym$cljs$core_SLASH_LazySeq,5219,3,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$branch_QMARK_,cljs.core.cst$sym$children,cljs.core.cst$sym$root], null))),"Returns a lazy sequence of the nodes in a tree, via a depth-first walk.\n  branch? must be a fn of one arg that returns true if passed a node\n  that can have children (but may not).  children must be a fn of one\n  arg that returns a sequence of the children. Will only be called on\n  nodes for which branch? returns true. Root is the root node of the\n  tree."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,2803,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,2803,cljs.core.cst$kw$end_DASH_column,30,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_remainder_DASH_int,"cljs/core.cljs",30,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),null,cljs.core.list(null,null),1,false,2803,cljs.core.cst$sym$number,2803,2,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,11437,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,11437,cljs.core.cst$kw$end_DASH_column,11,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_uuid,"cljs/core.cljs",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),1,false,11437,cljs.core.cst$sym$cljs$core_SLASH_UUID,11437,1,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,1228,cljs.core.cst$kw$column,12,cljs.core.cst$kw$end_DASH_line,1228,cljs.core.cst$kw$end_DASH_column,15,cljs.core.cst$kw$tag,cljs.core.cst$sym$seq,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a seq on the collection. If the collection is\n  empty, returns nil.  (seq nil) returns nil. seq also works on\n  Strings."], null),cljs.core.cst$sym$cljs$core_SLASH_seq,"cljs/core.cljs",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),1,false,1228,cljs.core.cst$sym$seq,1228,1,cljs.core.cst$sym$seq,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns a seq on the collection. If the collection is\n  empty, returns nil.  (seq nil) returns nil. seq also works on\n  Strings."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[1,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IVolatile,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_Volatile,"cljs/core.cljs",18,true,10,4592,false,4592,cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,2533,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,2533,cljs.core.cst$kw$end_DASH_column,13,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"f should be a function of 2 arguments. If val is not supplied,\n  returns the result of applying f to the first 2 items in coll, then\n  applying f to that result and the 3rd item, etc. If coll contains no\n  items, f must accept no arguments as well, and reduce returns the\n  result of calling f with no arguments.  If coll has only 1 item, it\n  is returned and f is not called.  If val is supplied, returns the\n  result of applying f to val and the first item in coll, then\n  applying f to that result and the 2nd item, etc. If coll contains no\n  items, returns val and f is not called.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_reduce,"cljs/core.cljs",13,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),2533,2533,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)),"f should be a function of 2 arguments. If val is not supplied,\n  returns the result of applying f to the first 2 items in coll, then\n  applying f to that result and the 3rd item, etc. If coll contains no\n  items, f must accept no arguments as well, and reduce returns the\n  result of calling f with no arguments.  If coll has only 1 item, it\n  is returned and f is not called.  If val is supplied, returns the\n  result of applying f to val and the first item in coll, then\n  applying f to that result and the 2nd item, etc. If coll contains no\n  items, returns val and f is not called."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$sigs,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$sigs,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",19,14,11407,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),11407,cljs.core.PersistentArrayMap.EMPTY,"A marker protocol for UUIDs",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IUUID,"cljs/core.cljs",19,1,11407,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),null,11407,cljs.core.cst$sym$any,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_UUID,"null"], null), null),"A marker protocol for UUIDs",cljs.core.list("@interface")]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_INIT,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,4065,cljs.core.cst$kw$column,1,cljs.core.cst$kw$end_DASH_line,4065,cljs.core.cst$kw$end_DASH_column,10,cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,4065,cljs.core.cst$kw$column,6,cljs.core.cst$kw$end_DASH_line,4065,cljs.core.cst$kw$end_DASH_column,10], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$object], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,11802,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,11802,cljs.core.cst$kw$end_DASH_column,14,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns], null))),cljs.core.cst$kw$doc,"Returns the namespace named by the symbol or nil if it doesn't exist.\n  Bootstrap only."], null),cljs.core.cst$sym$cljs$core_SLASH_find_DASH_ns,"cljs/core.cljs",14,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns], null)),null,cljs.core.list(null,null),1,false,11802,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Namespace,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),11802,1,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns], null))),"Returns the namespace named by the symbol or nil if it doesn't exist.\n  Bootstrap only."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,2356,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,2356,cljs.core.cst$kw$end_DASH_column,16,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Returns true if key is present in the given collection, otherwise\n  returns false.  Note that for numerically indexed collections like\n  vectors and arrays, this tests if the numeric key is within the\n  range of indexes. 'contains?' operates constant or logarithmic time;\n  it will not perform a linear search for a value.  See also 'some'."], null),cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,"cljs/core.cljs",16,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null)),null,cljs.core.list(null,null),1,false,2356,cljs.core.cst$sym$boolean,2356,2,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null))),"Returns true if key is present in the given collection, otherwise\n  returns false.  Note that for numerically indexed collections like\n  vectors and arrays, this tests if the numeric key is within the\n  range of indexes. 'contains?' operates constant or logarithmic time;\n  it will not perform a linear search for a value.  See also 'some'."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,4252,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,4252,cljs.core.cst$kw$end_DASH_column,13,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns true if (pred x) is logical true for every x in coll, else\n  false."], null),cljs.core.cst$sym$cljs$core_SLASH_every_QMARK_,"cljs/core.cljs",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),1,false,4252,cljs.core.cst$sym$boolean,4252,2,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),"Returns true if (pred x) is logical true for every x in coll, else\n  false."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),"cljs/core.cljs",24,10,cljs.core.cst$kw$positional,1321,1321,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),"Positional factory function for cljs.core/ES6IteratorSeq."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_ES6IteratorSeq,"cljs/core.cljs",24,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null)),null,cljs.core.list(null,null),1,false,cljs.core.cst$kw$positional,1321,cljs.core.cst$sym$cljs$core_SLASH_ES6IteratorSeq,1321,3,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),"Positional factory function for cljs.core/ES6IteratorSeq."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[3,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_Fn,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_Var,"cljs/core.cljs",13,true,10,1133,false,1133,cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,4614,cljs.core.cst$kw$column,7,cljs.core.cst$kw$end_DASH_line,4614,cljs.core.cst$kw$end_DASH_column,19,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the non-nil results of (f index item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a stateful transducer when no collection is\n  provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_keep_DASH_indexed,"cljs/core.cljs",19,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,1,cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$variadic_QMARK_,false], null)], null),4614,4614,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),"Returns a lazy sequence of the non-nil results of (f index item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a stateful transducer when no collection is\n  provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"cljs/core.cljs",28,10,cljs.core.cst$kw$positional,6228,6228,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"Positional factory function for cljs.core/PersistentQueueSeq."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_PersistentQueueSeq,"cljs/core.cljs",28,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVe