// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('goog.string.format');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__65252 = opts_SINGLEQUOTE_;
var map__65252__$1 = cljs.core.__destructure_map(map__65252);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65252__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__65254 = arguments.length;
switch (G__65254) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__65257 = arguments.length;
switch (G__65257) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__65260 = arguments.length;
switch (G__65260) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__65263 = arguments.length;
switch (G__65263) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__65266 = arguments.length;
switch (G__65266) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__65269 = arguments.length;
switch (G__65269) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65278 = arguments.length;
var i__4830__auto___65279 = (0);
while(true){
if((i__4830__auto___65279 < len__4829__auto___65278)){
args__4835__auto__.push((arguments[i__4830__auto___65279]));

var G__65280 = (i__4830__auto___65279 + (1));
i__4830__auto___65279 = G__65280;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__65274){
var vec__65275 = p__65274;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65275,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq65271){
var G__65272 = cljs.core.first(seq65271);
var seq65271__$1 = cljs.core.next(seq65271);
var G__65273 = cljs.core.first(seq65271__$1);
var seq65271__$2 = cljs.core.next(seq65271__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65272,G__65273,seq65271__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65299){
var state_val_65300 = (state_65299[(1)]);
if((state_val_65300 === (1))){
var state_65299__$1 = state_65299;
var statearr_65301_65316 = state_65299__$1;
(statearr_65301_65316[(2)] = null);

(statearr_65301_65316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65300 === (2))){
var _ = (function (){var statearr_65302 = state_65299;
(statearr_65302[(4)] = cljs.core.cons((5),(state_65299[(4)])));

return statearr_65302;
})();
var state_65299__$1 = state_65299;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65299__$1,(6),db);
} else {
if((state_val_65300 === (3))){
var inst_65297 = (state_65299[(2)]);
var state_65299__$1 = state_65299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65299__$1,inst_65297);
} else {
if((state_val_65300 === (4))){
var inst_65281 = (state_65299[(2)]);
var inst_65282 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65281], 0));
var inst_65283 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65281) : reject.call(null,inst_65281));
var state_65299__$1 = (function (){var statearr_65304 = state_65299;
(statearr_65304[(7)] = inst_65282);

return statearr_65304;
})();
var statearr_65305_65317 = state_65299__$1;
(statearr_65305_65317[(2)] = inst_65283);

(statearr_65305_65317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65300 === (5))){
var _ = (function (){var statearr_65306 = state_65299;
(statearr_65306[(4)] = cljs.core.rest((state_65299[(4)])));

return statearr_65306;
})();
var state_65299__$1 = state_65299;
var ex65303 = (state_65299__$1[(2)]);
var statearr_65307_65318 = state_65299__$1;
(statearr_65307_65318[(5)] = ex65303);


var statearr_65308_65319 = state_65299__$1;
(statearr_65308_65319[(1)] = (4));

(statearr_65308_65319[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65300 === (6))){
var inst_65290 = (state_65299[(2)]);
var inst_65291 = fluree.db.util.async.throw_err(inst_65290);
var inst_65292 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_65291);
var inst_65293 = cljs.core.clj__GT_js(inst_65292);
var inst_65294 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65293) : resolve.call(null,inst_65293));
var _ = (function (){var statearr_65309 = state_65299;
(statearr_65309[(4)] = cljs.core.rest((state_65299[(4)])));

return statearr_65309;
})();
var state_65299__$1 = state_65299;
var statearr_65310_65320 = state_65299__$1;
(statearr_65310_65320[(2)] = inst_65294);

(statearr_65310_65320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2733__auto__ = null;
var flureedb$db_schema_$_state_machine__2733__auto____0 = (function (){
var statearr_65311 = [null,null,null,null,null,null,null,null];
(statearr_65311[(0)] = flureedb$db_schema_$_state_machine__2733__auto__);

(statearr_65311[(1)] = (1));

return statearr_65311;
});
var flureedb$db_schema_$_state_machine__2733__auto____1 = (function (state_65299){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65299);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65312){var ex__2736__auto__ = e65312;
var statearr_65313_65321 = state_65299;
(statearr_65313_65321[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65299[(4)]))){
var statearr_65314_65322 = state_65299;
(statearr_65314_65322[(1)] = cljs.core.first((state_65299[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65323 = state_65299;
state_65299 = G__65323;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2733__auto__ = function(state_65299){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2733__auto____1.call(this,state_65299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2733__auto____0;
flureedb$db_schema_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2733__auto____1;
return flureedb$db_schema_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65315 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65315[(6)] = c__2755__auto__);

return statearr_65315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__65325 = arguments.length;
switch (G__65325) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65395){
var state_val_65396 = (state_65395[(1)]);
if((state_val_65396 === (7))){
var inst_65338 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_65395__$1 = state_65395;
var statearr_65397_65442 = state_65395__$1;
(statearr_65397_65442[(2)] = inst_65338);

(statearr_65397_65442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (20))){
var inst_65346 = (state_65395[(7)]);
var inst_65370 = (state_65395[(2)]);
var state_65395__$1 = (function (){var statearr_65398 = state_65395;
(statearr_65398[(8)] = inst_65370);

return statearr_65398;
})();
if(cljs.core.truth_(inst_65346)){
var statearr_65399_65443 = state_65395__$1;
(statearr_65399_65443[(1)] = (21));

} else {
var statearr_65400_65444 = state_65395__$1;
(statearr_65400_65444[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (1))){
var state_65395__$1 = state_65395;
var statearr_65401_65445 = state_65395__$1;
(statearr_65401_65445[(2)] = null);

(statearr_65401_65445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (24))){
var inst_65377 = (state_65395[(2)]);
var inst_65378 = fluree.db.util.async.throw_err(inst_65377);
var state_65395__$1 = state_65395;
var statearr_65402_65446 = state_65395__$1;
(statearr_65402_65446[(2)] = inst_65378);

(statearr_65402_65446[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (4))){
var inst_65326 = (state_65395[(2)]);
var inst_65327 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65326], 0));
var inst_65328 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65326) : reject.call(null,inst_65326));
var state_65395__$1 = (function (){var statearr_65403 = state_65395;
(statearr_65403[(9)] = inst_65327);

return statearr_65403;
})();
var statearr_65404_65447 = state_65395__$1;
(statearr_65404_65447[(2)] = inst_65328);

(statearr_65404_65447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (15))){
var inst_65359 = (state_65395[(10)]);
var inst_65361 = fluree.db.util.core.without_nils(inst_65359);
var inst_65362 = fluree.db.util.json.stringify(inst_65361);
var state_65395__$1 = state_65395;
var statearr_65405_65448 = state_65395__$1;
(statearr_65405_65448[(2)] = inst_65362);

(statearr_65405_65448[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (21))){
var inst_65370 = (state_65395[(8)]);
var inst_65365 = (state_65395[(11)]);
var inst_65372 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_65373 = [inst_65365,inst_65370];
var inst_65374 = cljs.core.PersistentHashMap.fromArrays(inst_65372,inst_65373);
var inst_65375 = fluree.db.operations.command_async(conn,inst_65374);
var state_65395__$1 = state_65395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65395__$1,(24),inst_65375);
} else {
if((state_val_65396 === (13))){
var inst_65347 = (state_65395[(12)]);
var inst_65354 = (inst_65347 + (30000));
var state_65395__$1 = state_65395;
var statearr_65406_65449 = state_65395__$1;
(statearr_65406_65449[(2)] = inst_65354);

(statearr_65406_65449[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (22))){
var inst_65359 = (state_65395[(10)]);
var inst_65380 = fluree.db.operations.unsigned_command_async(conn,inst_65359);
var state_65395__$1 = state_65395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65395__$1,(25),inst_65380);
} else {
if((state_val_65396 === (6))){
var state_65395__$1 = state_65395;
var statearr_65407_65450 = state_65395__$1;
(statearr_65407_65450[(2)] = null);

(statearr_65407_65450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (25))){
var inst_65382 = (state_65395[(2)]);
var inst_65383 = fluree.db.util.async.throw_err(inst_65382);
var state_65395__$1 = state_65395;
var statearr_65408_65451 = state_65395__$1;
(statearr_65408_65451[(2)] = inst_65383);

(statearr_65408_65451[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (17))){
var inst_65346 = (state_65395[(7)]);
var inst_65365 = (state_65395[(2)]);
var state_65395__$1 = (function (){var statearr_65409 = state_65395;
(statearr_65409[(11)] = inst_65365);

return statearr_65409;
})();
if(cljs.core.truth_(inst_65346)){
var statearr_65410_65452 = state_65395__$1;
(statearr_65410_65452[(1)] = (18));

} else {
var statearr_65411_65453 = state_65395__$1;
(statearr_65411_65453[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (3))){
var inst_65393 = (state_65395[(2)]);
var state_65395__$1 = state_65395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65395__$1,inst_65393);
} else {
if((state_val_65396 === (12))){
var inst_65344 = (state_65395[(13)]);
var state_65395__$1 = state_65395;
var statearr_65412_65454 = state_65395__$1;
(statearr_65412_65454[(2)] = inst_65344);

(statearr_65412_65454[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (2))){
var _ = (function (){var statearr_65413 = state_65395;
(statearr_65413[(4)] = cljs.core.cons((5),(state_65395[(4)])));

return statearr_65413;
})();
var inst_65335 = (opts == null);
var state_65395__$1 = state_65395;
if(cljs.core.truth_(inst_65335)){
var statearr_65414_65455 = state_65395__$1;
(statearr_65414_65455[(1)] = (6));

} else {
var statearr_65415_65456 = state_65395__$1;
(statearr_65415_65456[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (23))){
var inst_65385 = (state_65395[(2)]);
var inst_65386 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65387 = [(200),inst_65385];
var inst_65388 = cljs.core.PersistentHashMap.fromArrays(inst_65386,inst_65387);
var inst_65389 = cljs.core.clj__GT_js(inst_65388);
var inst_65390 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65389) : resolve.call(null,inst_65389));
var _ = (function (){var statearr_65416 = state_65395;
(statearr_65416[(4)] = cljs.core.rest((state_65395[(4)])));

return statearr_65416;
})();
var state_65395__$1 = state_65395;
var statearr_65417_65457 = state_65395__$1;
(statearr_65417_65457[(2)] = inst_65390);

(statearr_65417_65457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (19))){
var state_65395__$1 = state_65395;
var statearr_65418_65458 = state_65395__$1;
(statearr_65418_65458[(2)] = null);

(statearr_65418_65458[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (11))){
var inst_65344 = (state_65395[(13)]);
var inst_65351 = (state_65395[(2)]);
var state_65395__$1 = (function (){var statearr_65420 = state_65395;
(statearr_65420[(14)] = inst_65351);

return statearr_65420;
})();
if(cljs.core.truth_(inst_65344)){
var statearr_65421_65459 = state_65395__$1;
(statearr_65421_65459[(1)] = (12));

} else {
var statearr_65422_65460 = state_65395__$1;
(statearr_65422_65460[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (9))){
var inst_65343 = (state_65395[(15)]);
var state_65395__$1 = state_65395;
var statearr_65423_65461 = state_65395__$1;
(statearr_65423_65461[(2)] = inst_65343);

(statearr_65423_65461[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (5))){
var _ = (function (){var statearr_65424 = state_65395;
(statearr_65424[(4)] = cljs.core.rest((state_65395[(4)])));

return statearr_65424;
})();
var state_65395__$1 = state_65395;
var ex65419 = (state_65395__$1[(2)]);
var statearr_65425_65462 = state_65395__$1;
(statearr_65425_65462[(5)] = ex65419);


var statearr_65426_65463 = state_65395__$1;
(statearr_65426_65463[(1)] = (4));

(statearr_65426_65463[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (14))){
var inst_65351 = (state_65395[(14)]);
var inst_65346 = (state_65395[(7)]);
var inst_65356 = (state_65395[(2)]);
var inst_65357 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_65358 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_65351,inst_65356];
var inst_65359 = cljs.core.PersistentHashMap.fromArrays(inst_65357,inst_65358);
var state_65395__$1 = (function (){var statearr_65427 = state_65395;
(statearr_65427[(10)] = inst_65359);

return statearr_65427;
})();
if(cljs.core.truth_(inst_65346)){
var statearr_65428_65464 = state_65395__$1;
(statearr_65428_65464[(1)] = (15));

} else {
var statearr_65429_65465 = state_65395__$1;
(statearr_65429_65465[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (16))){
var state_65395__$1 = state_65395;
var statearr_65430_65466 = state_65395__$1;
(statearr_65430_65466[(2)] = null);

(statearr_65430_65466[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (10))){
var inst_65347 = (state_65395[(12)]);
var state_65395__$1 = state_65395;
var statearr_65431_65467 = state_65395__$1;
(statearr_65431_65467[(2)] = inst_65347);

(statearr_65431_65467[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (18))){
var inst_65365 = (state_65395[(11)]);
var inst_65346 = (state_65395[(7)]);
var inst_65367 = fluree.crypto.sign_message(inst_65365,inst_65346);
var state_65395__$1 = state_65395;
var statearr_65432_65468 = state_65395__$1;
(statearr_65432_65468[(2)] = inst_65367);

(statearr_65432_65468[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (8))){
var inst_65343 = (state_65395[(15)]);
var inst_65340 = (state_65395[(2)]);
var inst_65341 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_65340);
var inst_65342 = cljs.core.__destructure_map(inst_65340);
var inst_65343__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65342,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_65344 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65342,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_65345 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_65342,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_65346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65342,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_65347 = fluree.db.util.core.current_time_millis();
var state_65395__$1 = (function (){var statearr_65433 = state_65395;
(statearr_65433[(16)] = inst_65345);

(statearr_65433[(17)] = inst_65341);

(statearr_65433[(13)] = inst_65344);

(statearr_65433[(7)] = inst_65346);

(statearr_65433[(12)] = inst_65347);

(statearr_65433[(15)] = inst_65343__$1);

return statearr_65433;
})();
if(cljs.core.truth_(inst_65343__$1)){
var statearr_65434_65469 = state_65395__$1;
(statearr_65434_65469[(1)] = (9));

} else {
var statearr_65435_65470 = state_65395__$1;
(statearr_65435_65470[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_65436 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65436[(0)] = flureedb$state_machine__2733__auto__);

(statearr_65436[(1)] = (1));

return statearr_65436;
});
var flureedb$state_machine__2733__auto____1 = (function (state_65395){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65395);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65437){var ex__2736__auto__ = e65437;
var statearr_65438_65471 = state_65395;
(statearr_65438_65471[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65395[(4)]))){
var statearr_65439_65472 = state_65395;
(statearr_65439_65472[(1)] = cljs.core.first((state_65395[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65473 = state_65395;
state_65395 = G__65473;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_65395){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_65395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65440 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65440[(6)] = c__2755__auto__);

return statearr_65440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65492){
var state_val_65493 = (state_65492[(1)]);
if((state_val_65493 === (1))){
var state_65492__$1 = state_65492;
var statearr_65494_65509 = state_65492__$1;
(statearr_65494_65509[(2)] = null);

(statearr_65494_65509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65493 === (2))){
var _ = (function (){var statearr_65495 = state_65492;
(statearr_65495[(4)] = cljs.core.cons((5),(state_65492[(4)])));

return statearr_65495;
})();
var inst_65482 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_65492__$1 = state_65492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65492__$1,(6),inst_65482);
} else {
if((state_val_65493 === (3))){
var inst_65490 = (state_65492[(2)]);
var state_65492__$1 = state_65492;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65492__$1,inst_65490);
} else {
if((state_val_65493 === (4))){
var inst_65474 = (state_65492[(2)]);
var inst_65475 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65474], 0));
var inst_65476 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65474) : reject.call(null,inst_65474));
var state_65492__$1 = (function (){var statearr_65497 = state_65492;
(statearr_65497[(7)] = inst_65475);

return statearr_65497;
})();
var statearr_65498_65510 = state_65492__$1;
(statearr_65498_65510[(2)] = inst_65476);

(statearr_65498_65510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65493 === (5))){
var _ = (function (){var statearr_65499 = state_65492;
(statearr_65499[(4)] = cljs.core.rest((state_65492[(4)])));

return statearr_65499;
})();
var state_65492__$1 = state_65492;
var ex65496 = (state_65492__$1[(2)]);
var statearr_65500_65511 = state_65492__$1;
(statearr_65500_65511[(5)] = ex65496);


var statearr_65501_65512 = state_65492__$1;
(statearr_65501_65512[(1)] = (4));

(statearr_65501_65512[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65493 === (6))){
var inst_65484 = (state_65492[(2)]);
var inst_65485 = fluree.db.util.async.throw_err(inst_65484);
var inst_65486 = cljs.core.clj__GT_js(inst_65485);
var inst_65487 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65486) : resolve.call(null,inst_65486));
var _ = (function (){var statearr_65502 = state_65492;
(statearr_65502[(4)] = cljs.core.rest((state_65492[(4)])));

return statearr_65502;
})();
var state_65492__$1 = state_65492;
var statearr_65503_65513 = state_65492__$1;
(statearr_65503_65513[(2)] = inst_65487);

(statearr_65503_65513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2733__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2733__auto____0 = (function (){
var statearr_65504 = [null,null,null,null,null,null,null,null];
(statearr_65504[(0)] = flureedb$ledger_stats_$_state_machine__2733__auto__);

(statearr_65504[(1)] = (1));

return statearr_65504;
});
var flureedb$ledger_stats_$_state_machine__2733__auto____1 = (function (state_65492){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65492);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65505){var ex__2736__auto__ = e65505;
var statearr_65506_65514 = state_65492;
(statearr_65506_65514[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65492[(4)]))){
var statearr_65507_65515 = state_65492;
(statearr_65507_65515[(1)] = cljs.core.first((state_65492[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65516 = state_65492;
state_65492 = G__65516;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2733__auto__ = function(state_65492){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2733__auto____1.call(this,state_65492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2733__auto____0;
flureedb$ledger_stats_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2733__auto____1;
return flureedb$ledger_stats_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65508 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65508[(6)] = c__2755__auto__);

return statearr_65508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * - :jwt         - token for Fluree On-Demand access
 * 
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__65518 = arguments.length;
switch (G__65518) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65642){
var state_val_65643 = (state_65642[(1)]);
if((state_val_65643 === (7))){
var inst_65541 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_65642__$1 = state_65642;
var statearr_65644_65714 = state_65642__$1;
(statearr_65644_65714[(2)] = inst_65541);

(statearr_65644_65714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (20))){
var inst_65548 = (state_65642[(7)]);
var inst_65587 = (state_65642[(2)]);
var inst_65588 = fluree.db.util.core.current_time_millis();
var state_65642__$1 = (function (){var statearr_65645 = state_65642;
(statearr_65645[(8)] = inst_65588);

(statearr_65645[(9)] = inst_65587);

return statearr_65645;
})();
if(cljs.core.truth_(inst_65548)){
var statearr_65646_65715 = state_65642__$1;
(statearr_65646_65715[(1)] = (21));

} else {
var statearr_65647_65716 = state_65642__$1;
(statearr_65647_65716[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (27))){
var inst_65601 = (state_65642[(10)]);
var inst_65556 = (state_65642[(11)]);
var inst_65603 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65601,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_65556);
var state_65642__$1 = state_65642;
var statearr_65648_65717 = state_65642__$1;
(statearr_65648_65717[(2)] = inst_65603);

(statearr_65648_65717[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (1))){
var state_65642__$1 = state_65642;
var statearr_65649_65718 = state_65642__$1;
(statearr_65649_65718[(2)] = null);

(statearr_65649_65718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (24))){
var inst_65554 = (state_65642[(12)]);
var state_65642__$1 = state_65642;
var statearr_65650_65719 = state_65642__$1;
(statearr_65650_65719[(2)] = inst_65554);

(statearr_65650_65719[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (39))){
var inst_65624 = (state_65642[(2)]);
var inst_65625 = fluree.db.util.async.throw_err(inst_65624);
var state_65642__$1 = state_65642;
var statearr_65651_65720 = state_65642__$1;
(statearr_65651_65720[(2)] = inst_65625);

(statearr_65651_65720[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (4))){
var inst_65519 = (state_65642[(2)]);
var inst_65520 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65519], 0));
var inst_65521 = cljs.core.ex_data(inst_65519);
var inst_65522 = cljs.core.ex_message(inst_65519);
var inst_65523 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65521,new cljs.core.Keyword(null,"message","message",-406056002),inst_65522);
var inst_65524 = cljs.core.clj__GT_js(inst_65523);
var inst_65525 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65524) : reject.call(null,inst_65524));
var state_65642__$1 = (function (){var statearr_65652 = state_65642;
(statearr_65652[(13)] = inst_65520);

return statearr_65652;
})();
var statearr_65653_65721 = state_65642__$1;
(statearr_65653_65721[(2)] = inst_65525);

(statearr_65653_65721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (15))){
var inst_65577 = (state_65642[(14)]);
var inst_65579 = fluree.db.graphdb.validate_ledger_name(inst_65577,"alias");
var state_65642__$1 = state_65642;
var statearr_65654_65722 = state_65642__$1;
(statearr_65654_65722[(2)] = inst_65579);

(statearr_65654_65722[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (21))){
var inst_65548 = (state_65642[(7)]);
var state_65642__$1 = state_65642;
var statearr_65655_65723 = state_65642__$1;
(statearr_65655_65723[(2)] = inst_65548);

(statearr_65655_65723[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (31))){
var state_65642__$1 = state_65642;
var statearr_65656_65724 = state_65642__$1;
(statearr_65656_65724[(2)] = null);

(statearr_65656_65724[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (32))){
var inst_65550 = (state_65642[(15)]);
var inst_65612 = (state_65642[(2)]);
var state_65642__$1 = (function (){var statearr_65657 = state_65642;
(statearr_65657[(16)] = inst_65612);

return statearr_65657;
})();
if(cljs.core.truth_(inst_65550)){
var statearr_65658_65725 = state_65642__$1;
(statearr_65658_65725[(1)] = (33));

} else {
var statearr_65659_65726 = state_65642__$1;
(statearr_65659_65726[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (40))){
var inst_65629 = (state_65642[(2)]);
var inst_65630 = fluree.db.util.async.throw_err(inst_65629);
var state_65642__$1 = state_65642;
var statearr_65660_65727 = state_65642__$1;
(statearr_65660_65727[(2)] = inst_65630);

(statearr_65660_65727[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (33))){
var inst_65612 = (state_65642[(16)]);
var inst_65550 = (state_65642[(15)]);
var inst_65614 = fluree.crypto.sign_message(inst_65612,inst_65550);
var state_65642__$1 = state_65642;
var statearr_65661_65728 = state_65642__$1;
(statearr_65661_65728[(2)] = inst_65614);

(statearr_65661_65728[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (13))){
var state_65642__$1 = state_65642;
var statearr_65662_65729 = state_65642__$1;
(statearr_65662_65729[(2)] = null);

(statearr_65662_65729[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (22))){
var inst_65588 = (state_65642[(8)]);
var state_65642__$1 = state_65642;
var statearr_65663_65730 = state_65642__$1;
(statearr_65663_65730[(2)] = inst_65588);

(statearr_65663_65730[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (36))){
var inst_65612 = (state_65642[(16)]);
var inst_65617 = (state_65642[(17)]);
var inst_65619 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_65620 = [inst_65612,inst_65617];
var inst_65621 = cljs.core.PersistentHashMap.fromArrays(inst_65619,inst_65620);
var inst_65622 = fluree.db.operations.command_async(conn,inst_65621);
var state_65642__$1 = state_65642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65642__$1,(39),inst_65622);
} else {
if((state_val_65643 === (29))){
var inst_65550 = (state_65642[(15)]);
var inst_65606 = (state_65642[(2)]);
var state_65642__$1 = (function (){var statearr_65664 = state_65642;
(statearr_65664[(18)] = inst_65606);

return statearr_65664;
})();
if(cljs.core.truth_(inst_65550)){
var statearr_65665_65731 = state_65642__$1;
(statearr_65665_65731[(1)] = (30));

} else {
var statearr_65666_65732 = state_65642__$1;
(statearr_65666_65732[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (6))){
var state_65642__$1 = state_65642;
var statearr_65667_65733 = state_65642__$1;
(statearr_65667_65733[(2)] = null);

(statearr_65667_65733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (28))){
var inst_65601 = (state_65642[(10)]);
var state_65642__$1 = state_65642;
var statearr_65668_65734 = state_65642__$1;
(statearr_65668_65734[(2)] = inst_65601);

(statearr_65668_65734[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (25))){
var inst_65588 = (state_65642[(8)]);
var inst_65595 = (inst_65588 + (30000));
var state_65642__$1 = state_65642;
var statearr_65669_65735 = state_65642__$1;
(statearr_65669_65735[(2)] = inst_65595);

(statearr_65669_65735[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (34))){
var state_65642__$1 = state_65642;
var statearr_65670_65736 = state_65642__$1;
(statearr_65670_65736[(2)] = null);

(statearr_65670_65736[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (17))){
var inst_65558 = (state_65642[(19)]);
var inst_65582 = (state_65642[(2)]);
var state_65642__$1 = (function (){var statearr_65671 = state_65642;
(statearr_65671[(20)] = inst_65582);

return statearr_65671;
})();
if(cljs.core.truth_(inst_65558)){
var statearr_65672_65737 = state_65642__$1;
(statearr_65672_65737[(1)] = (18));

} else {
var statearr_65673_65738 = state_65642__$1;
(statearr_65673_65738[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (3))){
var inst_65640 = (state_65642[(2)]);
var state_65642__$1 = state_65642;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65642__$1,inst_65640);
} else {
if((state_val_65643 === (12))){
var inst_65572 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_65642__$1 = state_65642;
var statearr_65674_65739 = state_65642__$1;
(statearr_65674_65739[(2)] = inst_65572);

(statearr_65674_65739[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (2))){
var _ = (function (){var statearr_65675 = state_65642;
(statearr_65675[(4)] = cljs.core.cons((5),(state_65642[(4)])));

return statearr_65675;
})();
var inst_65538 = (opts == null);
var state_65642__$1 = state_65642;
if(cljs.core.truth_(inst_65538)){
var statearr_65676_65740 = state_65642__$1;
(statearr_65676_65740[(1)] = (6));

} else {
var statearr_65677_65741 = state_65642__$1;
(statearr_65677_65741[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (23))){
var inst_65554 = (state_65642[(12)]);
var inst_65592 = (state_65642[(2)]);
var state_65642__$1 = (function (){var statearr_65678 = state_65642;
(statearr_65678[(21)] = inst_65592);

return statearr_65678;
})();
if(cljs.core.truth_(inst_65554)){
var statearr_65679_65742 = state_65642__$1;
(statearr_65679_65742[(1)] = (24));

} else {
var statearr_65680_65743 = state_65642__$1;
(statearr_65680_65743[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (35))){
var inst_65550 = (state_65642[(15)]);
var inst_65617 = (state_65642[(2)]);
var state_65642__$1 = (function (){var statearr_65681 = state_65642;
(statearr_65681[(17)] = inst_65617);

return statearr_65681;
})();
if(cljs.core.truth_(inst_65550)){
var statearr_65682_65744 = state_65642__$1;
(statearr_65682_65744[(1)] = (36));

} else {
var statearr_65683_65745 = state_65642__$1;
(statearr_65683_65745[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (19))){
var state_65642__$1 = state_65642;
var statearr_65684_65746 = state_65642__$1;
(statearr_65684_65746[(2)] = null);

(statearr_65684_65746[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (11))){
var inst_65558 = (state_65642[(19)]);
var inst_65561 = (state_65642[(22)]);
var inst_65568 = (state_65642[(23)]);
var inst_65568__$1 = (state_65642[(2)]);
var inst_65569 = fluree.db.graphdb.validate_ledger_name(inst_65568__$1,"ledger");
var inst_65570 = fluree.db.graphdb.validate_ledger_name(inst_65561,"network");
var state_65642__$1 = (function (){var statearr_65686 = state_65642;
(statearr_65686[(24)] = inst_65570);

(statearr_65686[(25)] = inst_65569);

(statearr_65686[(23)] = inst_65568__$1);

return statearr_65686;
})();
if(cljs.core.truth_(inst_65558)){
var statearr_65687_65747 = state_65642__$1;
(statearr_65687_65747[(1)] = (12));

} else {
var statearr_65688_65748 = state_65642__$1;
(statearr_65688_65748[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (9))){
var inst_65562 = (state_65642[(26)]);
var inst_65565 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_65562,(1));
var state_65642__$1 = state_65642;
var statearr_65689_65749 = state_65642__$1;
(statearr_65689_65749[(2)] = inst_65565);

(statearr_65689_65749[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (5))){
var _ = (function (){var statearr_65690 = state_65642;
(statearr_65690[(4)] = cljs.core.rest((state_65642[(4)])));

return statearr_65690;
})();
var state_65642__$1 = state_65642;
var ex65685 = (state_65642__$1[(2)]);
var statearr_65691_65750 = state_65642__$1;
(statearr_65691_65750[(5)] = ex65685);


var statearr_65692_65751 = state_65642__$1;
(statearr_65692_65751[(1)] = (4));

(statearr_65692_65751[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (14))){
var inst_65558 = (state_65642[(19)]);
var inst_65575 = (state_65642[(2)]);
var inst_65576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65575,(0),null);
var inst_65577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65575,(1),null);
var state_65642__$1 = (function (){var statearr_65693 = state_65642;
(statearr_65693[(27)] = inst_65576);

(statearr_65693[(14)] = inst_65577);

return statearr_65693;
})();
if(cljs.core.truth_(inst_65558)){
var statearr_65694_65752 = state_65642__$1;
(statearr_65694_65752[(1)] = (15));

} else {
var statearr_65695_65753 = state_65642__$1;
(statearr_65695_65753[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (26))){
var inst_65553 = (state_65642[(28)]);
var inst_65552 = (state_65642[(29)]);
var inst_65559 = (state_65642[(30)]);
var inst_65557 = (state_65642[(31)]);
var inst_65547 = (state_65642[(32)]);
var inst_65556 = (state_65642[(11)]);
var inst_65555 = (state_65642[(33)]);
var inst_65592 = (state_65642[(21)]);
var inst_65549 = (state_65642[(34)]);
var inst_65587 = (state_65642[(9)]);
var inst_65561 = (state_65642[(22)]);
var inst_65551 = (state_65642[(35)]);
var inst_65568 = (state_65642[(23)]);
var inst_65597 = (state_65642[(2)]);
var inst_65598 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_65599 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65561),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65568)].join('');
var inst_65600 = [inst_65552,inst_65553,inst_65599,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_65597,inst_65555,inst_65587,inst_65559,inst_65557,inst_65547,inst_65592,inst_65549,inst_65551];
var inst_65601 = cljs.core.PersistentHashMap.fromArrays(inst_65598,inst_65600);
var state_65642__$1 = (function (){var statearr_65696 = state_65642;
(statearr_65696[(10)] = inst_65601);

return statearr_65696;
})();
if(cljs.core.truth_(inst_65556)){
var statearr_65697_65754 = state_65642__$1;
(statearr_65697_65754[(1)] = (27));

} else {
var statearr_65698_65755 = state_65642__$1;
(statearr_65698_65755[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (16))){
var state_65642__$1 = state_65642;
var statearr_65699_65756 = state_65642__$1;
(statearr_65699_65756[(2)] = null);

(statearr_65699_65756[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (38))){
var inst_65632 = (state_65642[(2)]);
var inst_65633 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65634 = [(200),inst_65632];
var inst_65635 = cljs.core.PersistentHashMap.fromArrays(inst_65633,inst_65634);
var inst_65636 = cljs.core.clj__GT_js(inst_65635);
var inst_65637 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65636) : resolve.call(null,inst_65636));
var _ = (function (){var statearr_65700 = state_65642;
(statearr_65700[(4)] = cljs.core.rest((state_65642[(4)])));

return statearr_65700;
})();
var state_65642__$1 = state_65642;
var statearr_65701_65757 = state_65642__$1;
(statearr_65701_65757[(2)] = inst_65637);

(statearr_65701_65757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (30))){
var inst_65606 = (state_65642[(18)]);
var inst_65608 = fluree.db.util.core.without_nils(inst_65606);
var inst_65609 = fluree.db.util.json.stringify(inst_65608);
var state_65642__$1 = state_65642;
var statearr_65702_65758 = state_65642__$1;
(statearr_65702_65758[(2)] = inst_65609);

(statearr_65702_65758[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (10))){
var inst_65562 = (state_65642[(26)]);
var state_65642__$1 = state_65642;
var statearr_65703_65759 = state_65642__$1;
(statearr_65703_65759[(2)] = inst_65562);

(statearr_65703_65759[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (18))){
var inst_65576 = (state_65642[(27)]);
var inst_65577 = (state_65642[(14)]);
var inst_65584 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65576),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65577)].join('');
var state_65642__$1 = state_65642;
var statearr_65704_65760 = state_65642__$1;
(statearr_65704_65760[(2)] = inst_65584);

(statearr_65704_65760[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65643 === (37))){
var inst_65606 = (state_65642[(18)]);
var inst_65627 = fluree.db.operations.unsigned_command_async(conn,inst_65606);
var state_65642__$1 = state_65642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65642__$1,(40),inst_65627);
} else {
if((state_val_65643 === (8))){
var inst_65562 = (state_65642[(26)]);
var inst_65543 = (state_65642[(2)]);
var inst_65544 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_65543);
var inst_65545 = cljs.core.__destructure_map(inst_65543);
var inst_65546 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_65545,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_65547 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_65548 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_65549 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_65550 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_65551 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_65552 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_65553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_65554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_65555 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_65556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_65557 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_65558 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_65559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65545,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_65560 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_65561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65560,(0),null);
var inst_65562__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65560,(1),null);
var inst_65563 = clojure.string.starts_with_QMARK_(inst_65562__$1,"$");
var state_65642__$1 = (function (){var statearr_65705 = state_65642;
(statearr_65705[(26)] = inst_65562__$1);

(statearr_65705[(19)] = inst_65558);

(statearr_65705[(28)] = inst_65553);

(statearr_65705[(29)] = inst_65552);

(statearr_65705[(30)] = inst_65559);

(statearr_65705[(31)] = inst_65557);

(statearr_65705[(32)] = inst_65547);

(statearr_65705[(11)] = inst_65556);

(statearr_65705[(33)] = inst_65555);

(statearr_65705[(15)] = inst_65550);

(statearr_65705[(36)] = inst_65544);

(statearr_65705[(37)] = inst_65546);

(statearr_65705[(12)] = inst_65554);

(statearr_65705[(7)] = inst_65548);

(statearr_65705[(34)] = inst_65549);

(statearr_65705[(22)] = inst_65561);

(statearr_65705[(35)] = inst_65551);

return statearr_65705;
})();
if(inst_65563){
var statearr_65706_65761 = state_65642__$1;
(statearr_65706_65761[(1)] = (9));

} else {
var statearr_65707_65762 = state_65642__$1;
(statearr_65707_65762[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_65708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65708[(0)] = flureedb$state_machine__2733__auto__);

(statearr_65708[(1)] = (1));

return statearr_65708;
});
var flureedb$state_machine__2733__auto____1 = (function (state_65642){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65642);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65709){var ex__2736__auto__ = e65709;
var statearr_65710_65763 = state_65642;
(statearr_65710_65763[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65642[(4)]))){
var statearr_65711_65764 = state_65642;
(statearr_65711_65764[(1)] = cljs.core.first((state_65642[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65765 = state_65642;
state_65642 = G__65765;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_65642){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_65642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65712 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65712[(6)] = c__2755__auto__);

return statearr_65712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65785){
var state_val_65786 = (state_65785[(1)]);
if((state_val_65786 === (1))){
var state_65785__$1 = state_65785;
var statearr_65787_65803 = state_65785__$1;
(statearr_65787_65803[(2)] = null);

(statearr_65787_65803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65786 === (2))){
var _ = (function (){var statearr_65788 = state_65785;
(statearr_65788[(4)] = cljs.core.cons((5),(state_65785[(4)])));

return statearr_65788;
})();
var inst_65775 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_65776 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_65785__$1 = (function (){var statearr_65789 = state_65785;
(statearr_65789[(7)] = inst_65775);

return statearr_65789;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65785__$1,(6),inst_65776);
} else {
if((state_val_65786 === (3))){
var inst_65783 = (state_65785[(2)]);
var state_65785__$1 = state_65785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65785__$1,inst_65783);
} else {
if((state_val_65786 === (4))){
var inst_65766 = (state_65785[(2)]);
var inst_65767 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65766], 0));
var inst_65768 = cljs.core.clj__GT_js(inst_65766);
var inst_65769 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65768) : reject.call(null,inst_65768));
var state_65785__$1 = (function (){var statearr_65791 = state_65785;
(statearr_65791[(8)] = inst_65767);

return statearr_65791;
})();
var statearr_65792_65804 = state_65785__$1;
(statearr_65792_65804[(2)] = inst_65769);

(statearr_65792_65804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65786 === (5))){
var _ = (function (){var statearr_65793 = state_65785;
(statearr_65793[(4)] = cljs.core.rest((state_65785[(4)])));

return statearr_65793;
})();
var state_65785__$1 = state_65785;
var ex65790 = (state_65785__$1[(2)]);
var statearr_65794_65805 = state_65785__$1;
(statearr_65794_65805[(5)] = ex65790);


var statearr_65795_65806 = state_65785__$1;
(statearr_65795_65806[(1)] = (4));

(statearr_65795_65806[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65786 === (6))){
var inst_65778 = (state_65785[(2)]);
var inst_65779 = cljs.core.clj__GT_js(inst_65778);
var inst_65780 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65779) : resolve.call(null,inst_65779));
var _ = (function (){var statearr_65796 = state_65785;
(statearr_65796[(4)] = cljs.core.rest((state_65785[(4)])));

return statearr_65796;
})();
var state_65785__$1 = state_65785;
var statearr_65797_65807 = state_65785__$1;
(statearr_65797_65807[(2)] = inst_65780);

(statearr_65797_65807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2733__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2733__auto____0 = (function (){
var statearr_65798 = [null,null,null,null,null,null,null,null,null];
(statearr_65798[(0)] = flureedb$monitor_tx_$_state_machine__2733__auto__);

(statearr_65798[(1)] = (1));

return statearr_65798;
});
var flureedb$monitor_tx_$_state_machine__2733__auto____1 = (function (state_65785){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65785);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65799){var ex__2736__auto__ = e65799;
var statearr_65800_65808 = state_65785;
(statearr_65800_65808[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65785[(4)]))){
var statearr_65801_65809 = state_65785;
(statearr_65801_65809[(1)] = cljs.core.first((state_65785[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65810 = state_65785;
state_65785 = G__65810;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2733__auto__ = function(state_65785){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2733__auto____1.call(this,state_65785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2733__auto____0;
flureedb$monitor_tx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2733__auto____1;
return flureedb$monitor_tx_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65802 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65802[(6)] = c__2755__auto__);

return statearr_65802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 * - jwt         - token to access Fluree On-Demand
 * 
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__65812 = arguments.length;
switch (G__65812) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65838){
var state_val_65839 = (state_65838[(1)]);
if((state_val_65839 === (7))){
var inst_65824 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_65838__$1 = state_65838;
var statearr_65840_65861 = state_65838__$1;
(statearr_65840_65861[(2)] = inst_65824);

(statearr_65840_65861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65839 === (1))){
var state_65838__$1 = state_65838;
var statearr_65841_65862 = state_65838__$1;
(statearr_65841_65862[(2)] = null);

(statearr_65841_65862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65839 === (4))){
var inst_65813 = (state_65838[(2)]);
var inst_65814 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65813], 0));
var inst_65815 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65813) : reject.call(null,inst_65813));
var state_65838__$1 = (function (){var statearr_65842 = state_65838;
(statearr_65842[(7)] = inst_65814);

return statearr_65842;
})();
var statearr_65843_65863 = state_65838__$1;
(statearr_65843_65863[(2)] = inst_65815);

(statearr_65843_65863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65839 === (6))){
var state_65838__$1 = state_65838;
var statearr_65844_65864 = state_65838__$1;
(statearr_65844_65864[(2)] = null);

(statearr_65844_65864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65839 === (3))){
var inst_65836 = (state_65838[(2)]);
var state_65838__$1 = state_65838;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65838__$1,inst_65836);
} else {
if((state_val_65839 === (2))){
var _ = (function (){var statearr_65846 = state_65838;
(statearr_65846[(4)] = cljs.core.cons((5),(state_65838[(4)])));

return statearr_65846;
})();
var inst_65821 = (opts == null);
var state_65838__$1 = state_65838;
if(cljs.core.truth_(inst_65821)){
var statearr_65847_65865 = state_65838__$1;
(statearr_65847_65865[(1)] = (6));

} else {
var statearr_65848_65866 = state_65838__$1;
(statearr_65848_65866[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65839 === (9))){
var inst_65831 = (state_65838[(2)]);
var inst_65832 = cljs.core.clj__GT_js(inst_65831);
var inst_65833 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65832) : resolve.call(null,inst_65832));
var _ = (function (){var statearr_65849 = state_65838;
(statearr_65849[(4)] = cljs.core.rest((state_65838[(4)])));

return statearr_65849;
})();
var state_65838__$1 = state_65838;
var statearr_65850_65867 = state_65838__$1;
(statearr_65850_65867[(2)] = inst_65833);

(statearr_65850_65867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65839 === (5))){
var _ = (function (){var statearr_65851 = state_65838;
(statearr_65851[(4)] = cljs.core.rest((state_65838[(4)])));

return statearr_65851;
})();
var state_65838__$1 = state_65838;
var ex65845 = (state_65838__$1[(2)]);
var statearr_65852_65868 = state_65838__$1;
(statearr_65852_65868[(5)] = ex65845);


var statearr_65853_65869 = state_65838__$1;
(statearr_65853_65869[(1)] = (4));

(statearr_65853_65869[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65839 === (8))){
var inst_65826 = (state_65838[(2)]);
var inst_65827 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_65826);
var inst_65828 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_65829 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_65828,inst_65826);
var state_65838__$1 = (function (){var statearr_65854 = state_65838;
(statearr_65854[(8)] = inst_65827);

return statearr_65854;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65838__$1,(9),inst_65829);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_65855 = [null,null,null,null,null,null,null,null,null];
(statearr_65855[(0)] = flureedb$state_machine__2733__auto__);

(statearr_65855[(1)] = (1));

return statearr_65855;
});
var flureedb$state_machine__2733__auto____1 = (function (state_65838){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65838);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65856){var ex__2736__auto__ = e65856;
var statearr_65857_65870 = state_65838;
(statearr_65857_65870[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65838[(4)]))){
var statearr_65858_65871 = state_65838;
(statearr_65858_65871[(1)] = cljs.core.first((state_65838[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65872 = state_65838;
state_65838 = G__65872;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_65838){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_65838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65859 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65859[(6)] = c__2755__auto__);

return statearr_65859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__65874 = arguments.length;
switch (G__65874) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65903){
var state_val_65904 = (state_65903[(1)]);
if((state_val_65904 === (7))){
var inst_65886 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_65903__$1 = state_65903;
var statearr_65905_65926 = state_65903__$1;
(statearr_65905_65926[(2)] = inst_65886);

(statearr_65905_65926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (1))){
var state_65903__$1 = state_65903;
var statearr_65906_65927 = state_65903__$1;
(statearr_65906_65927[(2)] = null);

(statearr_65906_65927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (4))){
var inst_65875 = (state_65903[(2)]);
var inst_65876 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65875], 0));
var inst_65877 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65875) : reject.call(null,inst_65875));
var state_65903__$1 = (function (){var statearr_65907 = state_65903;
(statearr_65907[(7)] = inst_65876);

return statearr_65907;
})();
var statearr_65908_65928 = state_65903__$1;
(statearr_65908_65928[(2)] = inst_65877);

(statearr_65908_65928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (6))){
var state_65903__$1 = state_65903;
var statearr_65909_65929 = state_65903__$1;
(statearr_65909_65929[(2)] = null);

(statearr_65909_65929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (3))){
var inst_65901 = (state_65903[(2)]);
var state_65903__$1 = state_65903;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65903__$1,inst_65901);
} else {
if((state_val_65904 === (2))){
var _ = (function (){var statearr_65911 = state_65903;
(statearr_65911[(4)] = cljs.core.cons((5),(state_65903[(4)])));

return statearr_65911;
})();
var inst_65883 = (opts == null);
var state_65903__$1 = state_65903;
if(cljs.core.truth_(inst_65883)){
var statearr_65912_65930 = state_65903__$1;
(statearr_65912_65930[(1)] = (6));

} else {
var statearr_65913_65931 = state_65903__$1;
(statearr_65913_65931[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (9))){
var inst_65888 = (state_65903[(8)]);
var inst_65891 = (state_65903[(2)]);
var inst_65892 = fluree.db.util.async.throw_err(inst_65891);
var inst_65893 = fluree.db.query.block.block_range(inst_65892,start,end,inst_65888);
var state_65903__$1 = state_65903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65903__$1,(10),inst_65893);
} else {
if((state_val_65904 === (5))){
var _ = (function (){var statearr_65914 = state_65903;
(statearr_65914[(4)] = cljs.core.rest((state_65903[(4)])));

return statearr_65914;
})();
var state_65903__$1 = state_65903;
var ex65910 = (state_65903__$1[(2)]);
var statearr_65915_65932 = state_65903__$1;
(statearr_65915_65932[(5)] = ex65910);


var statearr_65916_65933 = state_65903__$1;
(statearr_65916_65933[(1)] = (4));

(statearr_65916_65933[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (10))){
var inst_65895 = (state_65903[(2)]);
var inst_65896 = fluree.db.util.async.throw_err(inst_65895);
var inst_65897 = cljs.core.clj__GT_js(inst_65896);
var inst_65898 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65897) : resolve.call(null,inst_65897));
var _ = (function (){var statearr_65917 = state_65903;
(statearr_65917[(4)] = cljs.core.rest((state_65903[(4)])));

return statearr_65917;
})();
var state_65903__$1 = state_65903;
var statearr_65918_65934 = state_65903__$1;
(statearr_65918_65934[(2)] = inst_65898);

(statearr_65918_65934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (8))){
var inst_65888 = (state_65903[(8)]);
var inst_65888__$1 = (state_65903[(2)]);
var inst_65889 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65888__$1], 0));
var state_65903__$1 = (function (){var statearr_65919 = state_65903;
(statearr_65919[(8)] = inst_65888__$1);

return statearr_65919;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65903__$1,(9),inst_65889);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_65920 = [null,null,null,null,null,null,null,null,null];
(statearr_65920[(0)] = flureedb$state_machine__2733__auto__);

(statearr_65920[(1)] = (1));

return statearr_65920;
});
var flureedb$state_machine__2733__auto____1 = (function (state_65903){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65903);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65921){var ex__2736__auto__ = e65921;
var statearr_65922_65935 = state_65903;
(statearr_65922_65935[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65903[(4)]))){
var statearr_65923_65936 = state_65903;
(statearr_65923_65936[(1)] = cljs.core.first((state_65903[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65937 = state_65903;
state_65903 = G__65937;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_65903){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_65903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65924 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65924[(6)] = c__2755__auto__);

return statearr_65924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__65939 = arguments.length;
switch (G__65939) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65974){
var state_val_65975 = (state_65974[(1)]);
if((state_val_65975 === (7))){
var inst_65952 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_65974__$1 = state_65974;
var statearr_65976_65997 = state_65974__$1;
(statearr_65976_65997[(2)] = inst_65952);

(statearr_65976_65997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65975 === (1))){
var state_65974__$1 = state_65974;
var statearr_65977_65998 = state_65974__$1;
(statearr_65977_65998[(2)] = null);

(statearr_65977_65998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65975 === (4))){
var inst_65940 = (state_65974[(2)]);
var inst_65941 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65940], 0));
var inst_65942 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65940) : reject.call(null,inst_65940));
var state_65974__$1 = (function (){var statearr_65978 = state_65974;
(statearr_65978[(7)] = inst_65941);

return statearr_65978;
})();
var statearr_65979_65999 = state_65974__$1;
(statearr_65979_65999[(2)] = inst_65942);

(statearr_65979_65999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65975 === (6))){
var state_65974__$1 = state_65974;
var statearr_65980_66000 = state_65974__$1;
(statearr_65980_66000[(2)] = null);

(statearr_65980_66000[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65975 === (3))){
var inst_65972 = (state_65974[(2)]);
var state_65974__$1 = state_65974;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65974__$1,inst_65972);
} else {
if((state_val_65975 === (2))){
var _ = (function (){var statearr_65982 = state_65974;
(statearr_65982[(4)] = cljs.core.cons((5),(state_65974[(4)])));

return statearr_65982;
})();
var inst_65949 = (opts == null);
var state_65974__$1 = state_65974;
if(cljs.core.truth_(inst_65949)){
var statearr_65983_66001 = state_65974__$1;
(statearr_65983_66001[(1)] = (6));

} else {
var statearr_65984_66002 = state_65974__$1;
(statearr_65984_66002[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65975 === (9))){
var inst_65957 = (state_65974[(8)]);
var inst_65958 = (state_65974[(9)]);
var inst_65954 = (state_65974[(10)]);
var inst_65961 = (state_65974[(2)]);
var inst_65962 = fluree.db.util.async.throw_err(inst_65961);
var inst_65963 = fluree.db.query.block.block_range(inst_65962,inst_65957,inst_65958,inst_65954);
var state_65974__$1 = state_65974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65974__$1,(10),inst_65963);
} else {
if((state_val_65975 === (5))){
var _ = (function (){var statearr_65985 = state_65974;
(statearr_65985[(4)] = cljs.core.rest((state_65974[(4)])));

return statearr_65985;
})();
var state_65974__$1 = state_65974;
var ex65981 = (state_65974__$1[(2)]);
var statearr_65986_66003 = state_65974__$1;
(statearr_65986_66003[(5)] = ex65981);


var statearr_65987_66004 = state_65974__$1;
(statearr_65987_66004[(1)] = (4));

(statearr_65987_66004[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65975 === (10))){
var inst_65965 = (state_65974[(2)]);
var inst_65966 = fluree.db.util.async.throw_err(inst_65965);
var inst_65967 = fluree.db.query.range.block_with_tx_data(inst_65966);
var inst_65968 = cljs.core.clj__GT_js(inst_65967);
var inst_65969 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65968) : resolve.call(null,inst_65968));
var _ = (function (){var statearr_65988 = state_65974;
(statearr_65988[(4)] = cljs.core.rest((state_65974[(4)])));

return statearr_65988;
})();
var state_65974__$1 = state_65974;
var statearr_65989_66005 = state_65974__$1;
(statearr_65989_66005[(2)] = inst_65969);

(statearr_65989_66005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65975 === (8))){
var inst_65954 = (state_65974[(10)]);
var inst_65954__$1 = (state_65974[(2)]);
var inst_65955 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_65956 = cljs.core.__destructure_map(inst_65955);
var inst_65957 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65956,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_65958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65956,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_65959 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65954__$1], 0));
var state_65974__$1 = (function (){var statearr_65990 = state_65974;
(statearr_65990[(8)] = inst_65957);

(statearr_65990[(9)] = inst_65958);

(statearr_65990[(10)] = inst_65954__$1);

return statearr_65990;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65974__$1,(9),inst_65959);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_65991 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_65991[(0)] = flureedb$state_machine__2733__auto__);

(statearr_65991[(1)] = (1));

return statearr_65991;
});
var flureedb$state_machine__2733__auto____1 = (function (state_65974){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65974);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65992){var ex__2736__auto__ = e65992;
var statearr_65993_66006 = state_65974;
(statearr_65993_66006[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65974[(4)]))){
var statearr_65994_66007 = state_65974;
(statearr_65994_66007[(1)] = cljs.core.first((state_65974[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66008 = state_65974;
state_65974 = G__66008;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_65974){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_65974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65995 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65995[(6)] = c__2755__auto__);

return statearr_65995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__66010 = arguments.length;
switch (G__66010) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66077){
var state_val_66078 = (state_66077[(1)]);
if((state_val_66078 === (7))){
var inst_66023 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66077__$1 = state_66077;
var statearr_66079_66120 = state_66077__$1;
(statearr_66079_66120[(2)] = inst_66023);

(statearr_66079_66120[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (20))){
var inst_66025 = (state_66077[(7)]);
var inst_66019 = (state_66077[(8)]);
var inst_66061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66062 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_66063 = (new cljs.core.PersistentVector(null,1,(5),inst_66061,inst_66062,null));
var inst_66064 = cljs.core.assoc_in(inst_66025,inst_66063,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66065 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_66019,inst_66064);
var state_66077__$1 = state_66077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66077__$1,(23),inst_66065);
} else {
if((state_val_66078 === (1))){
var state_66077__$1 = state_66077;
var statearr_66080_66121 = state_66077__$1;
(statearr_66080_66121[(2)] = null);

(statearr_66080_66121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (4))){
var inst_66011 = (state_66077[(2)]);
var inst_66012 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66011], 0));
var inst_66013 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66011) : reject.call(null,inst_66011));
var state_66077__$1 = (function (){var statearr_66081 = state_66077;
(statearr_66081[(9)] = inst_66012);

return statearr_66081;
})();
var statearr_66082_66122 = state_66077__$1;
(statearr_66082_66122[(2)] = inst_66013);

(statearr_66082_66122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (15))){
var inst_66049 = (state_66077[(2)]);
var inst_66050 = fluree.db.util.async.throw_err(inst_66049);
var state_66077__$1 = state_66077;
var statearr_66083_66123 = state_66077__$1;
(statearr_66083_66123[(2)] = inst_66050);

(statearr_66083_66123[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (21))){
var inst_66070 = (state_66077[(2)]);
var inst_66071 = cljs.core.clj__GT_js(inst_66070);
var inst_66072 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66071) : resolve.call(null,inst_66071));
var _ = (function (){var statearr_66084 = state_66077;
(statearr_66084[(4)] = cljs.core.rest((state_66077[(4)])));

return statearr_66084;
})();
var state_66077__$1 = state_66077;
var statearr_66085_66124 = state_66077__$1;
(statearr_66085_66124[(2)] = inst_66072);

(statearr_66085_66124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (13))){
var state_66077__$1 = state_66077;
var statearr_66086_66125 = state_66077__$1;
(statearr_66086_66125[(2)] = null);

(statearr_66086_66125[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (22))){
var inst_66058 = (state_66077[(2)]);
var inst_66059 = fluree.db.util.async.throw_err(inst_66058);
var state_66077__$1 = state_66077;
var statearr_66087_66126 = state_66077__$1;
(statearr_66087_66126[(2)] = inst_66059);

(statearr_66087_66126[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (6))){
var state_66077__$1 = state_66077;
var statearr_66088_66127 = state_66077__$1;
(statearr_66088_66127[(2)] = null);

(statearr_66088_66127[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (17))){
var state_66077__$1 = state_66077;
var statearr_66089_66128 = state_66077__$1;
(statearr_66089_66128[(2)] = null);

(statearr_66089_66128[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (3))){
var inst_66075 = (state_66077[(2)]);
var state_66077__$1 = state_66077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66077__$1,inst_66075);
} else {
if((state_val_66078 === (12))){
var inst_66033 = (state_66077[(10)]);
var inst_66037 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_66077__$1 = (function (){var statearr_66090 = state_66077;
(statearr_66090[(11)] = inst_66037);

return statearr_66090;
})();
if(cljs.core.truth_(inst_66033)){
var statearr_66091_66129 = state_66077__$1;
(statearr_66091_66129[(1)] = (16));

} else {
var statearr_66092_66130 = state_66077__$1;
(statearr_66092_66130[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (2))){
var _ = (function (){var statearr_66093 = state_66077;
(statearr_66093[(4)] = cljs.core.cons((5),(state_66077[(4)])));

return statearr_66093;
})();
var inst_66019 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66020 = (opts == null);
var state_66077__$1 = (function (){var statearr_66094 = state_66077;
(statearr_66094[(8)] = inst_66019);

return statearr_66094;
})();
if(cljs.core.truth_(inst_66020)){
var statearr_66095_66131 = state_66077__$1;
(statearr_66095_66131[(1)] = (6));

} else {
var statearr_66096_66132 = state_66077__$1;
(statearr_66096_66132[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (23))){
var inst_66067 = (state_66077[(2)]);
var inst_66068 = fluree.db.util.async.throw_err(inst_66067);
var state_66077__$1 = state_66077;
var statearr_66097_66133 = state_66077__$1;
(statearr_66097_66133[(2)] = inst_66068);

(statearr_66097_66133[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (19))){
var inst_66025 = (state_66077[(7)]);
var inst_66053 = (state_66077[(12)]);
var inst_66019 = (state_66077[(8)]);
var inst_66056 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_66053,inst_66019,inst_66025);
var state_66077__$1 = state_66077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66077__$1,(22),inst_66056);
} else {
if((state_val_66078 === (11))){
var inst_66025 = (state_66077[(7)]);
var inst_66027 = (state_66077[(13)]);
var inst_66033 = (state_66077[(2)]);
var inst_66034 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_66025);
var inst_66035 = (inst_66027 == null);
var state_66077__$1 = (function (){var statearr_66099 = state_66077;
(statearr_66099[(10)] = inst_66033);

(statearr_66099[(14)] = inst_66034);

return statearr_66099;
})();
if(cljs.core.truth_(inst_66035)){
var statearr_66100_66134 = state_66077__$1;
(statearr_66100_66134[(1)] = (12));

} else {
var statearr_66101_66135 = state_66077__$1;
(statearr_66101_66135[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (9))){
var inst_66028 = (state_66077[(15)]);
var state_66077__$1 = state_66077;
var statearr_66102_66136 = state_66077__$1;
(statearr_66102_66136[(2)] = inst_66028);

(statearr_66102_66136[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (5))){
var _ = (function (){var statearr_66103 = state_66077;
(statearr_66103[(4)] = cljs.core.rest((state_66077[(4)])));

return statearr_66103;
})();
var state_66077__$1 = state_66077;
var ex66098 = (state_66077__$1[(2)]);
var statearr_66104_66137 = state_66077__$1;
(statearr_66104_66137[(5)] = ex66098);


var statearr_66105_66138 = state_66077__$1;
(statearr_66105_66138[(1)] = (4));

(statearr_66105_66138[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (14))){
var inst_66027 = (state_66077[(13)]);
var inst_66053 = (state_66077[(2)]);
var inst_66054 = (inst_66027 == null);
var state_66077__$1 = (function (){var statearr_66106 = state_66077;
(statearr_66106[(12)] = inst_66053);

return statearr_66106;
})();
if(cljs.core.truth_(inst_66054)){
var statearr_66107_66139 = state_66077__$1;
(statearr_66107_66139[(1)] = (19));

} else {
var statearr_66108_66140 = state_66077__$1;
(statearr_66108_66140[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (16))){
var inst_66033 = (state_66077[(10)]);
var inst_66039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66040 = ["_auth/id",inst_66033];
var inst_66041 = (new cljs.core.PersistentVector(null,2,(5),inst_66039,inst_66040,null));
var state_66077__$1 = state_66077;
var statearr_66109_66141 = state_66077__$1;
(statearr_66109_66141[(2)] = inst_66041);

(statearr_66109_66141[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (10))){
var inst_66025 = (state_66077[(7)]);
var inst_66031 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_66025);
var state_66077__$1 = state_66077;
var statearr_66110_66142 = state_66077__$1;
(statearr_66110_66142[(2)] = inst_66031);

(statearr_66110_66142[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (18))){
var inst_66034 = (state_66077[(14)]);
var inst_66037 = (state_66077[(11)]);
var inst_66044 = (state_66077[(2)]);
var inst_66045 = [inst_66044,inst_66034];
var inst_66046 = cljs.core.PersistentHashMap.fromArrays(inst_66037,inst_66045);
var inst_66047 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66046], 0));
var state_66077__$1 = state_66077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66077__$1,(15),inst_66047);
} else {
if((state_val_66078 === (8))){
var inst_66028 = (state_66077[(15)]);
var inst_66025 = (state_66077[(7)]);
var inst_66025__$1 = (state_66077[(2)]);
var inst_66026 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66025__$1);
var inst_66027 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_66025__$1);
var inst_66028__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_66025__$1);
var state_66077__$1 = (function (){var statearr_66111 = state_66077;
(statearr_66111[(15)] = inst_66028__$1);

(statearr_66111[(16)] = inst_66026);

(statearr_66111[(7)] = inst_66025__$1);

(statearr_66111[(13)] = inst_66027);

return statearr_66111;
})();
if(cljs.core.truth_(inst_66028__$1)){
var statearr_66112_66143 = state_66077__$1;
(statearr_66112_66143[(1)] = (9));

} else {
var statearr_66113_66144 = state_66077__$1;
(statearr_66113_66144[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_66114 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66114[(0)] = flureedb$state_machine__2733__auto__);

(statearr_66114[(1)] = (1));

return statearr_66114;
});
var flureedb$state_machine__2733__auto____1 = (function (state_66077){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66077);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66115){var ex__2736__auto__ = e66115;
var statearr_66116_66145 = state_66077;
(statearr_66116_66145[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66077[(4)]))){
var statearr_66117_66146 = state_66077;
(statearr_66117_66146[(1)] = cljs.core.first((state_66077[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66147 = state_66077;
state_66077 = G__66147;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_66077){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_66077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66118 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66118[(6)] = c__2755__auto__);

return statearr_66118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66167){
var state_val_66168 = (state_66167[(1)]);
if((state_val_66168 === (1))){
var state_66167__$1 = state_66167;
var statearr_66169_66184 = state_66167__$1;
(statearr_66169_66184[(2)] = null);

(statearr_66169_66184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66168 === (2))){
var _ = (function (){var statearr_66170 = state_66167;
(statearr_66170[(4)] = cljs.core.cons((5),(state_66167[(4)])));

return statearr_66170;
})();
var inst_66156 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66157 = fluree.db.api.query.history_query_async(sources,inst_66156);
var state_66167__$1 = state_66167;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66167__$1,(6),inst_66157);
} else {
if((state_val_66168 === (3))){
var inst_66165 = (state_66167[(2)]);
var state_66167__$1 = state_66167;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66167__$1,inst_66165);
} else {
if((state_val_66168 === (4))){
var inst_66148 = (state_66167[(2)]);
var inst_66149 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66148], 0));
var inst_66150 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66148) : reject.call(null,inst_66148));
var state_66167__$1 = (function (){var statearr_66172 = state_66167;
(statearr_66172[(7)] = inst_66149);

return statearr_66172;
})();
var statearr_66173_66185 = state_66167__$1;
(statearr_66173_66185[(2)] = inst_66150);

(statearr_66173_66185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66168 === (5))){
var _ = (function (){var statearr_66174 = state_66167;
(statearr_66174[(4)] = cljs.core.rest((state_66167[(4)])));

return statearr_66174;
})();
var state_66167__$1 = state_66167;
var ex66171 = (state_66167__$1[(2)]);
var statearr_66175_66186 = state_66167__$1;
(statearr_66175_66186[(5)] = ex66171);


var statearr_66176_66187 = state_66167__$1;
(statearr_66176_66187[(1)] = (4));

(statearr_66176_66187[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66168 === (6))){
var inst_66159 = (state_66167[(2)]);
var inst_66160 = fluree.db.util.async.throw_err(inst_66159);
var inst_66161 = cljs.core.clj__GT_js(inst_66160);
var inst_66162 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66161) : resolve.call(null,inst_66161));
var _ = (function (){var statearr_66177 = state_66167;
(statearr_66177[(4)] = cljs.core.rest((state_66167[(4)])));

return statearr_66177;
})();
var state_66167__$1 = state_66167;
var statearr_66178_66188 = state_66167__$1;
(statearr_66178_66188[(2)] = inst_66162);

(statearr_66178_66188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2733__auto__ = null;
var flureedb$history_query_$_state_machine__2733__auto____0 = (function (){
var statearr_66179 = [null,null,null,null,null,null,null,null];
(statearr_66179[(0)] = flureedb$history_query_$_state_machine__2733__auto__);

(statearr_66179[(1)] = (1));

return statearr_66179;
});
var flureedb$history_query_$_state_machine__2733__auto____1 = (function (state_66167){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66167);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66180){var ex__2736__auto__ = e66180;
var statearr_66181_66189 = state_66167;
(statearr_66181_66189[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66167[(4)]))){
var statearr_66182_66190 = state_66167;
(statearr_66182_66190[(1)] = cljs.core.first((state_66167[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66191 = state_66167;
state_66167 = G__66191;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2733__auto__ = function(state_66167){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2733__auto____1.call(this,state_66167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2733__auto____0;
flureedb$history_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2733__auto____1;
return flureedb$history_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66183 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66183[(6)] = c__2755__auto__);

return statearr_66183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66211){
var state_val_66212 = (state_66211[(1)]);
if((state_val_66212 === (1))){
var state_66211__$1 = state_66211;
var statearr_66213_66228 = state_66211__$1;
(statearr_66213_66228[(2)] = null);

(statearr_66213_66228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66212 === (2))){
var _ = (function (){var statearr_66214 = state_66211;
(statearr_66214[(4)] = cljs.core.cons((5),(state_66211[(4)])));

return statearr_66214;
})();
var inst_66200 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66201 = fluree.db.api.query.multi_query_async(sources,inst_66200);
var state_66211__$1 = state_66211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66211__$1,(6),inst_66201);
} else {
if((state_val_66212 === (3))){
var inst_66209 = (state_66211[(2)]);
var state_66211__$1 = state_66211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66211__$1,inst_66209);
} else {
if((state_val_66212 === (4))){
var inst_66192 = (state_66211[(2)]);
var inst_66193 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66192], 0));
var inst_66194 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66192) : reject.call(null,inst_66192));
var state_66211__$1 = (function (){var statearr_66216 = state_66211;
(statearr_66216[(7)] = inst_66193);

return statearr_66216;
})();
var statearr_66217_66229 = state_66211__$1;
(statearr_66217_66229[(2)] = inst_66194);

(statearr_66217_66229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66212 === (5))){
var _ = (function (){var statearr_66218 = state_66211;
(statearr_66218[(4)] = cljs.core.rest((state_66211[(4)])));

return statearr_66218;
})();
var state_66211__$1 = state_66211;
var ex66215 = (state_66211__$1[(2)]);
var statearr_66219_66230 = state_66211__$1;
(statearr_66219_66230[(5)] = ex66215);


var statearr_66220_66231 = state_66211__$1;
(statearr_66220_66231[(1)] = (4));

(statearr_66220_66231[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66212 === (6))){
var inst_66203 = (state_66211[(2)]);
var inst_66204 = fluree.db.util.async.throw_err(inst_66203);
var inst_66205 = cljs.core.clj__GT_js(inst_66204);
var inst_66206 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66205) : resolve.call(null,inst_66205));
var _ = (function (){var statearr_66221 = state_66211;
(statearr_66221[(4)] = cljs.core.rest((state_66211[(4)])));

return statearr_66221;
})();
var state_66211__$1 = state_66211;
var statearr_66222_66232 = state_66211__$1;
(statearr_66222_66232[(2)] = inst_66206);

(statearr_66222_66232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2733__auto__ = null;
var flureedb$multi_query_$_state_machine__2733__auto____0 = (function (){
var statearr_66223 = [null,null,null,null,null,null,null,null];
(statearr_66223[(0)] = flureedb$multi_query_$_state_machine__2733__auto__);

(statearr_66223[(1)] = (1));

return statearr_66223;
});
var flureedb$multi_query_$_state_machine__2733__auto____1 = (function (state_66211){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66211);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66224){var ex__2736__auto__ = e66224;
var statearr_66225_66233 = state_66211;
(statearr_66225_66233[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66211[(4)]))){
var statearr_66226_66234 = state_66211;
(statearr_66226_66234[(1)] = cljs.core.first((state_66211[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66235 = state_66211;
state_66211 = G__66235;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2733__auto__ = function(state_66211){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2733__auto____1.call(this,state_66211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2733__auto____0;
flureedb$multi_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2733__auto____1;
return flureedb$multi_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66227 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66227[(6)] = c__2755__auto__);

return statearr_66227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66255){
var state_val_66256 = (state_66255[(1)]);
if((state_val_66256 === (1))){
var state_66255__$1 = state_66255;
var statearr_66257_66272 = state_66255__$1;
(statearr_66257_66272[(2)] = null);

(statearr_66257_66272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66256 === (2))){
var _ = (function (){var statearr_66258 = state_66255;
(statearr_66258[(4)] = cljs.core.cons((5),(state_66255[(4)])));

return statearr_66258;
})();
var inst_66245 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66246 = fluree.db.api.query.query_async(sources,inst_66245);
var state_66255__$1 = state_66255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66255__$1,(6),inst_66246);
} else {
if((state_val_66256 === (3))){
var inst_66253 = (state_66255[(2)]);
var state_66255__$1 = state_66255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66255__$1,inst_66253);
} else {
if((state_val_66256 === (4))){
var inst_66236 = (state_66255[(2)]);
var inst_66237 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66236], 0));
var inst_66238 = cljs.core.clj__GT_js(inst_66236);
var inst_66239 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66238) : reject.call(null,inst_66238));
var state_66255__$1 = (function (){var statearr_66260 = state_66255;
(statearr_66260[(7)] = inst_66237);

return statearr_66260;
})();
var statearr_66261_66273 = state_66255__$1;
(statearr_66261_66273[(2)] = inst_66239);

(statearr_66261_66273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66256 === (5))){
var _ = (function (){var statearr_66262 = state_66255;
(statearr_66262[(4)] = cljs.core.rest((state_66255[(4)])));

return statearr_66262;
})();
var state_66255__$1 = state_66255;
var ex66259 = (state_66255__$1[(2)]);
var statearr_66263_66274 = state_66255__$1;
(statearr_66263_66274[(5)] = ex66259);


var statearr_66264_66275 = state_66255__$1;
(statearr_66264_66275[(1)] = (4));

(statearr_66264_66275[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66256 === (6))){
var inst_66248 = (state_66255[(2)]);
var inst_66249 = cljs.core.clj__GT_js(inst_66248);
var inst_66250 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66249) : resolve.call(null,inst_66249));
var _ = (function (){var statearr_66265 = state_66255;
(statearr_66265[(4)] = cljs.core.rest((state_66255[(4)])));

return statearr_66265;
})();
var state_66255__$1 = state_66255;
var statearr_66266_66276 = state_66255__$1;
(statearr_66266_66276[(2)] = inst_66250);

(statearr_66266_66276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2733__auto__ = null;
var flureedb$query_$_state_machine__2733__auto____0 = (function (){
var statearr_66267 = [null,null,null,null,null,null,null,null];
(statearr_66267[(0)] = flureedb$query_$_state_machine__2733__auto__);

(statearr_66267[(1)] = (1));

return statearr_66267;
});
var flureedb$query_$_state_machine__2733__auto____1 = (function (state_66255){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66255);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66268){var ex__2736__auto__ = e66268;
var statearr_66269_66277 = state_66255;
(statearr_66269_66277[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66255[(4)]))){
var statearr_66270_66278 = state_66255;
(statearr_66270_66278[(1)] = cljs.core.first((state_66255[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66279 = state_66255;
state_66255 = G__66279;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2733__auto__ = function(state_66255){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2733__auto____1.call(this,state_66255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2733__auto____0;
flureedb$query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2733__auto____1;
return flureedb$query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66271 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66271[(6)] = c__2755__auto__);

return statearr_66271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__66281 = arguments.length;
switch (G__66281) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66308){
var state_val_66309 = (state_66308[(1)]);
if((state_val_66309 === (7))){
var inst_66295 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66308__$1 = state_66308;
var statearr_66310_66331 = state_66308__$1;
(statearr_66310_66331[(2)] = inst_66295);

(statearr_66310_66331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66309 === (1))){
var state_66308__$1 = state_66308;
var statearr_66311_66332 = state_66308__$1;
(statearr_66311_66332[(2)] = null);

(statearr_66311_66332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66309 === (4))){
var inst_66282 = (state_66308[(2)]);
var inst_66283 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66282], 0));
var inst_66284 = cljs.core.clj__GT_js(inst_66282);
var inst_66285 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66284) : reject.call(null,inst_66284));
var state_66308__$1 = (function (){var statearr_66312 = state_66308;
(statearr_66312[(7)] = inst_66283);

return statearr_66312;
})();
var statearr_66313_66333 = state_66308__$1;
(statearr_66313_66333[(2)] = inst_66285);

(statearr_66313_66333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66309 === (6))){
var state_66308__$1 = state_66308;
var statearr_66314_66334 = state_66308__$1;
(statearr_66314_66334[(2)] = null);

(statearr_66314_66334[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66309 === (3))){
var inst_66306 = (state_66308[(2)]);
var state_66308__$1 = state_66308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66308__$1,inst_66306);
} else {
if((state_val_66309 === (2))){
var _ = (function (){var statearr_66316 = state_66308;
(statearr_66316[(4)] = cljs.core.cons((5),(state_66308[(4)])));

return statearr_66316;
})();
var inst_66291 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66292 = (opts == null);
var state_66308__$1 = (function (){var statearr_66317 = state_66308;
(statearr_66317[(8)] = inst_66291);

return statearr_66317;
})();
if(cljs.core.truth_(inst_66292)){
var statearr_66318_66335 = state_66308__$1;
(statearr_66318_66335[(1)] = (6));

} else {
var statearr_66319_66336 = state_66308__$1;
(statearr_66319_66336[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66309 === (9))){
var inst_66300 = (state_66308[(2)]);
var inst_66301 = fluree.db.util.async.throw_err(inst_66300);
var inst_66302 = cljs.core.clj__GT_js(inst_66301);
var inst_66303 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66302) : resolve.call(null,inst_66302));
var _ = (function (){var statearr_66320 = state_66308;
(statearr_66320[(4)] = cljs.core.rest((state_66308[(4)])));

return statearr_66320;
})();
var state_66308__$1 = state_66308;
var statearr_66321_66337 = state_66308__$1;
(statearr_66321_66337[(2)] = inst_66303);

(statearr_66321_66337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66309 === (5))){
var _ = (function (){var statearr_66322 = state_66308;
(statearr_66322[(4)] = cljs.core.rest((state_66308[(4)])));

return statearr_66322;
})();
var state_66308__$1 = state_66308;
var ex66315 = (state_66308__$1[(2)]);
var statearr_66323_66338 = state_66308__$1;
(statearr_66323_66338[(5)] = ex66315);


var statearr_66324_66339 = state_66308__$1;
(statearr_66324_66339[(1)] = (4));

(statearr_66324_66339[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66309 === (8))){
var inst_66291 = (state_66308[(8)]);
var inst_66297 = (state_66308[(2)]);
var inst_66298 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_66291,inst_66297);
var state_66308__$1 = state_66308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66308__$1,(9),inst_66298);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_66325 = [null,null,null,null,null,null,null,null,null];
(statearr_66325[(0)] = flureedb$state_machine__2733__auto__);

(statearr_66325[(1)] = (1));

return statearr_66325;
});
var flureedb$state_machine__2733__auto____1 = (function (state_66308){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66308);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66326){var ex__2736__auto__ = e66326;
var statearr_66327_66340 = state_66308;
(statearr_66327_66340[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66308[(4)]))){
var statearr_66328_66341 = state_66308;
(statearr_66328_66341[(1)] = cljs.core.first((state_66308[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66342 = state_66308;
state_66308 = G__66342;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_66308){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_66308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66329 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66329[(6)] = c__2755__auto__);

return statearr_66329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
