// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17266){
var state_val_17267 = (state_17266[(1)]);
if((state_val_17267 === (7))){
var inst_17255 = (state_17266[(7)]);
var inst_17257 = fluree.db.storage.core.serde(conn);
var inst_17258 = fluree.db.serde.protocol._deserialize_block(inst_17257,inst_17255);
var state_17266__$1 = state_17266;
var statearr_17268_17287 = state_17266__$1;
(statearr_17268_17287[(2)] = inst_17258);

(statearr_17268_17287[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (1))){
var state_17266__$1 = state_17266;
var statearr_17269_17288 = state_17266__$1;
(statearr_17269_17288[(2)] = null);

(statearr_17269_17288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (4))){
var inst_17245 = (state_17266[(2)]);
var state_17266__$1 = state_17266;
var statearr_17270_17289 = state_17266__$1;
(statearr_17270_17289[(2)] = inst_17245);

(statearr_17270_17289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (6))){
var inst_17255 = (state_17266[(7)]);
var inst_17254 = (state_17266[(2)]);
var inst_17255__$1 = fluree.db.util.async.throw_err(inst_17254);
var state_17266__$1 = (function (){var statearr_17271 = state_17266;
(statearr_17271[(7)] = inst_17255__$1);

return statearr_17271;
})();
if(cljs.core.truth_(inst_17255__$1)){
var statearr_17272_17290 = state_17266__$1;
(statearr_17272_17290[(1)] = (7));

} else {
var statearr_17273_17291 = state_17266__$1;
(statearr_17273_17291[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (3))){
var inst_17264 = (state_17266[(2)]);
var state_17266__$1 = state_17266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17266__$1,inst_17264);
} else {
if((state_val_17267 === (2))){
var _ = (function (){var statearr_17275 = state_17266;
(statearr_17275[(4)] = cljs.core.cons((5),(state_17266[(4)])));

return statearr_17275;
})();
var inst_17251 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17252 = fluree.db.storage.core.storage_read(conn,inst_17251);
var state_17266__$1 = state_17266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17266__$1,(6),inst_17252);
} else {
if((state_val_17267 === (9))){
var inst_17261 = (state_17266[(2)]);
var _ = (function (){var statearr_17276 = state_17266;
(statearr_17276[(4)] = cljs.core.rest((state_17266[(4)])));

return statearr_17276;
})();
var state_17266__$1 = state_17266;
var statearr_17277_17292 = state_17266__$1;
(statearr_17277_17292[(2)] = inst_17261);

(statearr_17277_17292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (5))){
var _ = (function (){var statearr_17278 = state_17266;
(statearr_17278[(4)] = cljs.core.rest((state_17266[(4)])));

return statearr_17278;
})();
var state_17266__$1 = state_17266;
var ex17274 = (state_17266__$1[(2)]);
var statearr_17279_17293 = state_17266__$1;
(statearr_17279_17293[(5)] = ex17274);


if((ex17274 instanceof Error)){
var statearr_17280_17294 = state_17266__$1;
(statearr_17280_17294[(1)] = (4));

(statearr_17280_17294[(5)] = null);

} else {
throw ex17274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (8))){
var state_17266__$1 = state_17266;
var statearr_17281_17295 = state_17266__$1;
(statearr_17281_17295[(2)] = null);

(statearr_17281_17295[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2733__auto____0 = (function (){
var statearr_17282 = [null,null,null,null,null,null,null,null];
(statearr_17282[(0)] = fluree$db$storage$core$read_block_$_state_machine__2733__auto__);

(statearr_17282[(1)] = (1));

return statearr_17282;
});
var fluree$db$storage$core$read_block_$_state_machine__2733__auto____1 = (function (state_17266){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17266);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17283){var ex__2736__auto__ = e17283;
var statearr_17284_17296 = state_17266;
(statearr_17284_17296[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17266[(4)]))){
var statearr_17285_17297 = state_17266;
(statearr_17285_17297[(1)] = cljs.core.first((state_17266[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17298 = state_17266;
state_17266 = G__17298;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2733__auto__ = function(state_17266){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2733__auto____1.call(this,state_17266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17286 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17286[(6)] = c__2755__auto__);

return statearr_17286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17321){
var state_val_17322 = (state_17321[(1)]);
if((state_val_17322 === (7))){
var inst_17310 = (state_17321[(7)]);
var inst_17312 = fluree.db.storage.core.serde(conn);
var inst_17313 = fluree.db.serde.protocol._deserialize_block(inst_17312,inst_17310);
var state_17321__$1 = state_17321;
var statearr_17323_17342 = state_17321__$1;
(statearr_17323_17342[(2)] = inst_17313);

(statearr_17323_17342[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17322 === (1))){
var state_17321__$1 = state_17321;
var statearr_17324_17343 = state_17321__$1;
(statearr_17324_17343[(2)] = null);

(statearr_17324_17343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17322 === (4))){
var inst_17299 = (state_17321[(2)]);
var state_17321__$1 = state_17321;
var statearr_17325_17344 = state_17321__$1;
(statearr_17325_17344[(2)] = inst_17299);

(statearr_17325_17344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17322 === (6))){
var inst_17310 = (state_17321[(7)]);
var inst_17309 = (state_17321[(2)]);
var inst_17310__$1 = fluree.db.util.async.throw_err(inst_17309);
var state_17321__$1 = (function (){var statearr_17326 = state_17321;
(statearr_17326[(7)] = inst_17310__$1);

return statearr_17326;
})();
if(cljs.core.truth_(inst_17310__$1)){
var statearr_17327_17345 = state_17321__$1;
(statearr_17327_17345[(1)] = (7));

} else {
var statearr_17328_17346 = state_17321__$1;
(statearr_17328_17346[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17322 === (3))){
var inst_17319 = (state_17321[(2)]);
var state_17321__$1 = state_17321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17321__$1,inst_17319);
} else {
if((state_val_17322 === (2))){
var _ = (function (){var statearr_17330 = state_17321;
(statearr_17330[(4)] = cljs.core.cons((5),(state_17321[(4)])));

return statearr_17330;
})();
var inst_17305 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17306 = [inst_17305,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17307 = fluree.db.storage.core.storage_read(conn,inst_17306);
var state_17321__$1 = state_17321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17321__$1,(6),inst_17307);
} else {
if((state_val_17322 === (9))){
var inst_17316 = (state_17321[(2)]);
var _ = (function (){var statearr_17331 = state_17321;
(statearr_17331[(4)] = cljs.core.rest((state_17321[(4)])));

return statearr_17331;
})();
var state_17321__$1 = state_17321;
var statearr_17332_17347 = state_17321__$1;
(statearr_17332_17347[(2)] = inst_17316);

(statearr_17332_17347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17322 === (5))){
var _ = (function (){var statearr_17333 = state_17321;
(statearr_17333[(4)] = cljs.core.rest((state_17321[(4)])));

return statearr_17333;
})();
var state_17321__$1 = state_17321;
var ex17329 = (state_17321__$1[(2)]);
var statearr_17334_17348 = state_17321__$1;
(statearr_17334_17348[(5)] = ex17329);


if((ex17329 instanceof Error)){
var statearr_17335_17349 = state_17321__$1;
(statearr_17335_17349[(1)] = (4));

(statearr_17335_17349[(5)] = null);

} else {
throw ex17329;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17322 === (8))){
var state_17321__$1 = state_17321;
var statearr_17336_17350 = state_17321__$1;
(statearr_17336_17350[(2)] = null);

(statearr_17336_17350[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____0 = (function (){
var statearr_17337 = [null,null,null,null,null,null,null,null];
(statearr_17337[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__);

(statearr_17337[(1)] = (1));

return statearr_17337;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____1 = (function (state_17321){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17321);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17338){var ex__2736__auto__ = e17338;
var statearr_17339_17351 = state_17321;
(statearr_17339_17351[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17321[(4)]))){
var statearr_17340_17352 = state_17321;
(statearr_17340_17352[(1)] = cljs.core.first((state_17321[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17353 = state_17321;
state_17321 = G__17353;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__ = function(state_17321){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____1.call(this,state_17321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17341 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17341[(6)] = c__2755__auto__);

return statearr_17341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17377){
var state_val_17378 = (state_17377[(1)]);
if((state_val_17378 === (1))){
var state_17377__$1 = state_17377;
var statearr_17379_17393 = state_17377__$1;
(statearr_17379_17393[(2)] = null);

(statearr_17379_17393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (2))){
var _ = (function (){var statearr_17380 = state_17377;
(statearr_17380[(4)] = cljs.core.cons((5),(state_17377[(4)])));

return statearr_17380;
})();
var inst_17360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17361 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17362 = (new cljs.core.PersistentVector(null,3,(5),inst_17360,inst_17361,null));
var inst_17363 = cljs.core.select_keys(block_data,inst_17362);
var inst_17364 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17363);
var inst_17365 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_17364);
var inst_17366 = [inst_17365,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17367 = fluree.db.storage.core.serde(conn);
var inst_17368 = fluree.db.serde.protocol._serialize_block(inst_17367,inst_17363);
var inst_17369 = fluree.db.storage.core.storage_write(conn,inst_17366,inst_17368);
var state_17377__$1 = state_17377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17377__$1,(6),inst_17369);
} else {
if((state_val_17378 === (3))){
var inst_17375 = (state_17377[(2)]);
var state_17377__$1 = state_17377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17377__$1,inst_17375);
} else {
if((state_val_17378 === (4))){
var inst_17354 = (state_17377[(2)]);
var state_17377__$1 = state_17377;
var statearr_17382_17394 = state_17377__$1;
(statearr_17382_17394[(2)] = inst_17354);

(statearr_17382_17394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (5))){
var _ = (function (){var statearr_17383 = state_17377;
(statearr_17383[(4)] = cljs.core.rest((state_17377[(4)])));

return statearr_17383;
})();
var state_17377__$1 = state_17377;
var ex17381 = (state_17377__$1[(2)]);
var statearr_17384_17395 = state_17377__$1;
(statearr_17384_17395[(5)] = ex17381);


if((ex17381 instanceof Error)){
var statearr_17385_17396 = state_17377__$1;
(statearr_17385_17396[(1)] = (4));

(statearr_17385_17396[(5)] = null);

} else {
throw ex17381;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (6))){
var inst_17371 = (state_17377[(2)]);
var inst_17372 = fluree.db.util.async.throw_err(inst_17371);
var _ = (function (){var statearr_17386 = state_17377;
(statearr_17386[(4)] = cljs.core.rest((state_17377[(4)])));

return statearr_17386;
})();
var state_17377__$1 = state_17377;
var statearr_17387_17397 = state_17377__$1;
(statearr_17387_17397[(2)] = inst_17372);

(statearr_17387_17397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____0 = (function (){
var statearr_17388 = [null,null,null,null,null,null,null];
(statearr_17388[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__);

(statearr_17388[(1)] = (1));

return statearr_17388;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____1 = (function (state_17377){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17377);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17389){var ex__2736__auto__ = e17389;
var statearr_17390_17398 = state_17377;
(statearr_17390_17398[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17377[(4)]))){
var statearr_17391_17399 = state_17377;
(statearr_17391_17399[(1)] = cljs.core.first((state_17377[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17400 = state_17377;
state_17377 = G__17400;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__ = function(state_17377){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____1.call(this,state_17377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17392 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17392[(6)] = c__2755__auto__);

return statearr_17392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17423){
var state_val_17424 = (state_17423[(1)]);
if((state_val_17424 === (1))){
var state_17423__$1 = state_17423;
var statearr_17425_17439 = state_17423__$1;
(statearr_17425_17439[(2)] = null);

(statearr_17425_17439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (2))){
var _ = (function (){var statearr_17426 = state_17423;
(statearr_17426[(4)] = cljs.core.cons((5),(state_17423[(4)])));

return statearr_17426;
})();
var inst_17407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17408 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17409 = (new cljs.core.PersistentVector(null,3,(5),inst_17407,inst_17408,null));
var inst_17410 = cljs.core.select_keys(block_data,inst_17409);
var inst_17411 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17410);
var inst_17412 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_17411);
var inst_17413 = fluree.db.storage.core.serde(conn);
var inst_17414 = fluree.db.serde.protocol._serialize_block(inst_17413,inst_17410);
var inst_17415 = fluree.db.storage.core.storage_write(conn,inst_17412,inst_17414);
var state_17423__$1 = state_17423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17423__$1,(6),inst_17415);
} else {
if((state_val_17424 === (3))){
var inst_17421 = (state_17423[(2)]);
var state_17423__$1 = state_17423;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17423__$1,inst_17421);
} else {
if((state_val_17424 === (4))){
var inst_17401 = (state_17423[(2)]);
var state_17423__$1 = state_17423;
var statearr_17428_17440 = state_17423__$1;
(statearr_17428_17440[(2)] = inst_17401);

(statearr_17428_17440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (5))){
var _ = (function (){var statearr_17429 = state_17423;
(statearr_17429[(4)] = cljs.core.rest((state_17423[(4)])));

return statearr_17429;
})();
var state_17423__$1 = state_17423;
var ex17427 = (state_17423__$1[(2)]);
var statearr_17430_17441 = state_17423__$1;
(statearr_17430_17441[(5)] = ex17427);


if((ex17427 instanceof Error)){
var statearr_17431_17442 = state_17423__$1;
(statearr_17431_17442[(1)] = (4));

(statearr_17431_17442[(5)] = null);

} else {
throw ex17427;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (6))){
var inst_17417 = (state_17423[(2)]);
var inst_17418 = fluree.db.util.async.throw_err(inst_17417);
var _ = (function (){var statearr_17432 = state_17423;
(statearr_17432[(4)] = cljs.core.rest((state_17423[(4)])));

return statearr_17432;
})();
var state_17423__$1 = state_17423;
var statearr_17433_17443 = state_17423__$1;
(statearr_17433_17443[(2)] = inst_17418);

(statearr_17433_17443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2733__auto____0 = (function (){
var statearr_17434 = [null,null,null,null,null,null,null];
(statearr_17434[(0)] = fluree$db$storage$core$write_block_$_state_machine__2733__auto__);

(statearr_17434[(1)] = (1));

return statearr_17434;
});
var fluree$db$storage$core$write_block_$_state_machine__2733__auto____1 = (function (state_17423){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17423);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17435){var ex__2736__auto__ = e17435;
var statearr_17436_17444 = state_17423;
(statearr_17436_17444[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17423[(4)]))){
var statearr_17437_17445 = state_17423;
(statearr_17437_17445[(1)] = cljs.core.first((state_17423[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17446 = state_17423;
state_17423 = G__17446;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2733__auto__ = function(state_17423){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2733__auto____1.call(this,state_17423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17438 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17438[(6)] = c__2755__auto__);

return statearr_17438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17466){
var state_val_17467 = (state_17466[(1)]);
if((state_val_17467 === (1))){
var state_17466__$1 = state_17466;
var statearr_17468_17482 = state_17466__$1;
(statearr_17468_17482[(2)] = null);

(statearr_17468_17482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (2))){
var _ = (function (){var statearr_17469 = state_17466;
(statearr_17469[(4)] = cljs.core.cons((5),(state_17466[(4)])));

return statearr_17469;
})();
var inst_17453 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17454 = [history,next_his_key];
var inst_17455 = cljs.core.PersistentHashMap.fromArrays(inst_17453,inst_17454);
var inst_17456 = fluree.db.storage.core.serde(conn);
var inst_17457 = fluree.db.serde.protocol._serialize_leaf(inst_17456,inst_17455);
var inst_17458 = fluree.db.storage.core.storage_write(conn,his_key,inst_17457);
var state_17466__$1 = state_17466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17466__$1,(6),inst_17458);
} else {
if((state_val_17467 === (3))){
var inst_17464 = (state_17466[(2)]);
var state_17466__$1 = state_17466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17466__$1,inst_17464);
} else {
if((state_val_17467 === (4))){
var inst_17447 = (state_17466[(2)]);
var state_17466__$1 = state_17466;
var statearr_17471_17483 = state_17466__$1;
(statearr_17471_17483[(2)] = inst_17447);

(statearr_17471_17483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (5))){
var _ = (function (){var statearr_17472 = state_17466;
(statearr_17472[(4)] = cljs.core.rest((state_17466[(4)])));

return statearr_17472;
})();
var state_17466__$1 = state_17466;
var ex17470 = (state_17466__$1[(2)]);
var statearr_17473_17484 = state_17466__$1;
(statearr_17473_17484[(5)] = ex17470);


if((ex17470 instanceof Error)){
var statearr_17474_17485 = state_17466__$1;
(statearr_17474_17485[(1)] = (4));

(statearr_17474_17485[(5)] = null);

} else {
throw ex17470;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (6))){
var inst_17460 = (state_17466[(2)]);
var inst_17461 = fluree.db.util.async.throw_err(inst_17460);
var _ = (function (){var statearr_17475 = state_17466;
(statearr_17475[(4)] = cljs.core.rest((state_17466[(4)])));

return statearr_17475;
})();
var state_17466__$1 = state_17466;
var statearr_17476_17486 = state_17466__$1;
(statearr_17476_17486[(2)] = inst_17461);

(statearr_17476_17486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2733__auto____0 = (function (){
var statearr_17477 = [null,null,null,null,null,null,null];
(statearr_17477[(0)] = fluree$db$storage$core$write_history_$_state_machine__2733__auto__);

(statearr_17477[(1)] = (1));

return statearr_17477;
});
var fluree$db$storage$core$write_history_$_state_machine__2733__auto____1 = (function (state_17466){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17466);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17478){var ex__2736__auto__ = e17478;
var statearr_17479_17487 = state_17466;
(statearr_17479_17487[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17466[(4)]))){
var statearr_17480_17488 = state_17466;
(statearr_17480_17488[(1)] = cljs.core.first((state_17466[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17489 = state_17466;
state_17466 = G__17489;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2733__auto__ = function(state_17466){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2733__auto____1.call(this,state_17466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17481 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17481[(6)] = c__2755__auto__);

return statearr_17481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17515){
var state_val_17516 = (state_17515[(1)]);
if((state_val_17516 === (1))){
var state_17515__$1 = state_17515;
var statearr_17517_17534 = state_17515__$1;
(statearr_17517_17534[(2)] = null);

(statearr_17517_17534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17516 === (2))){
var inst_17496 = (state_17515[(7)]);
var _ = (function (){var statearr_17518 = state_17515;
(statearr_17518[(4)] = cljs.core.cons((5),(state_17515[(4)])));

return statearr_17518;
})();
var inst_17496__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_17497 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17496__$1),"-his"].join('');
var inst_17498 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17499 = [flakes,inst_17497];
var inst_17500 = cljs.core.PersistentHashMap.fromArrays(inst_17498,inst_17499);
var inst_17501 = fluree.db.storage.core.serde(conn);
var inst_17502 = fluree.db.serde.protocol._serialize_leaf(inst_17501,inst_17500);
var inst_17503 = fluree.db.storage.core.write_history(conn,history,inst_17497,null);
var inst_17504 = fluree.db.storage.core.storage_write(conn,inst_17496__$1,inst_17502);
var state_17515__$1 = (function (){var statearr_17519 = state_17515;
(statearr_17519[(8)] = inst_17504);

(statearr_17519[(7)] = inst_17496__$1);

return statearr_17519;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17515__$1,(6),inst_17503);
} else {
if((state_val_17516 === (3))){
var inst_17513 = (state_17515[(2)]);
var state_17515__$1 = state_17515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17515__$1,inst_17513);
} else {
if((state_val_17516 === (4))){
var inst_17490 = (state_17515[(2)]);
var state_17515__$1 = state_17515;
var statearr_17521_17535 = state_17515__$1;
(statearr_17521_17535[(2)] = inst_17490);

(statearr_17521_17535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17516 === (5))){
var _ = (function (){var statearr_17522 = state_17515;
(statearr_17522[(4)] = cljs.core.rest((state_17515[(4)])));

return statearr_17522;
})();
var state_17515__$1 = state_17515;
var ex17520 = (state_17515__$1[(2)]);
var statearr_17523_17536 = state_17515__$1;
(statearr_17523_17536[(5)] = ex17520);


if((ex17520 instanceof Error)){
var statearr_17524_17537 = state_17515__$1;
(statearr_17524_17537[(1)] = (4));

(statearr_17524_17537[(5)] = null);

} else {
throw ex17520;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17516 === (6))){
var inst_17504 = (state_17515[(8)]);
var inst_17506 = (state_17515[(2)]);
var inst_17507 = fluree.db.util.async.throw_err(inst_17506);
var state_17515__$1 = (function (){var statearr_17525 = state_17515;
(statearr_17525[(9)] = inst_17507);

return statearr_17525;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17515__$1,(7),inst_17504);
} else {
if((state_val_17516 === (7))){
var inst_17496 = (state_17515[(7)]);
var inst_17509 = (state_17515[(2)]);
var inst_17510 = fluree.db.util.async.throw_err(inst_17509);
var _ = (function (){var statearr_17526 = state_17515;
(statearr_17526[(4)] = cljs.core.rest((state_17515[(4)])));

return statearr_17526;
})();
var state_17515__$1 = (function (){var statearr_17527 = state_17515;
(statearr_17527[(10)] = inst_17510);

return statearr_17527;
})();
var statearr_17528_17538 = state_17515__$1;
(statearr_17528_17538[(2)] = inst_17496);

(statearr_17528_17538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____0 = (function (){
var statearr_17529 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17529[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__);

(statearr_17529[(1)] = (1));

return statearr_17529;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____1 = (function (state_17515){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17515);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17530){var ex__2736__auto__ = e17530;
var statearr_17531_17539 = state_17515;
(statearr_17531_17539[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17515[(4)]))){
var statearr_17532_17540 = state_17515;
(statearr_17532_17540[(1)] = cljs.core.first((state_17515[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17541 = state_17515;
state_17515 = G__17541;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__ = function(state_17515){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____1.call(this,state_17515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17533 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17533[(6)] = c__2755__auto__);

return statearr_17533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17558){
var state_val_17559 = (state_17558[(1)]);
if((state_val_17559 === (1))){
var state_17558__$1 = state_17558;
var statearr_17560_17575 = state_17558__$1;
(statearr_17560_17575[(2)] = null);

(statearr_17560_17575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17559 === (2))){
var _ = (function (){var statearr_17561 = state_17558;
(statearr_17561[(4)] = cljs.core.cons((5),(state_17558[(4)])));

return statearr_17561;
})();
var inst_17548 = fluree.db.storage.core.serde(conn);
var inst_17549 = fluree.db.serde.protocol._serialize_branch(inst_17548,data);
var inst_17550 = fluree.db.storage.core.storage_write(conn,key,inst_17549);
var state_17558__$1 = state_17558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17558__$1,(6),inst_17550);
} else {
if((state_val_17559 === (3))){
var inst_17556 = (state_17558[(2)]);
var state_17558__$1 = state_17558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17558__$1,inst_17556);
} else {
if((state_val_17559 === (4))){
var inst_17542 = (state_17558[(2)]);
var state_17558__$1 = state_17558;
var statearr_17563_17576 = state_17558__$1;
(statearr_17563_17576[(2)] = inst_17542);

(statearr_17563_17576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17559 === (5))){
var _ = (function (){var statearr_17564 = state_17558;
(statearr_17564[(4)] = cljs.core.rest((state_17558[(4)])));

return statearr_17564;
})();
var state_17558__$1 = state_17558;
var ex17562 = (state_17558__$1[(2)]);
var statearr_17565_17577 = state_17558__$1;
(statearr_17565_17577[(5)] = ex17562);


if((ex17562 instanceof Error)){
var statearr_17566_17578 = state_17558__$1;
(statearr_17566_17578[(1)] = (4));

(statearr_17566_17578[(5)] = null);

} else {
throw ex17562;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17559 === (6))){
var inst_17552 = (state_17558[(2)]);
var inst_17553 = fluree.db.util.async.throw_err(inst_17552);
var _ = (function (){var statearr_17567 = state_17558;
(statearr_17567[(4)] = cljs.core.rest((state_17558[(4)])));

return statearr_17567;
})();
var state_17558__$1 = (function (){var statearr_17568 = state_17558;
(statearr_17568[(7)] = inst_17553);

return statearr_17568;
})();
var statearr_17569_17579 = state_17558__$1;
(statearr_17569_17579[(2)] = key);

(statearr_17569_17579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____0 = (function (){
var statearr_17570 = [null,null,null,null,null,null,null,null];
(statearr_17570[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__);

(statearr_17570[(1)] = (1));

return statearr_17570;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____1 = (function (state_17558){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17558);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17571){var ex__2736__auto__ = e17571;
var statearr_17572_17580 = state_17558;
(statearr_17572_17580[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17558[(4)]))){
var statearr_17573_17581 = state_17558;
(statearr_17573_17581[(1)] = cljs.core.first((state_17558[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17582 = state_17558;
state_17558 = G__17582;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__ = function(state_17558){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____1.call(this,state_17558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17574 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17574[(6)] = c__2755__auto__);

return statearr_17574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__17583_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__17583_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__17584){
var map__17585 = p__17584;
var map__17585__$1 = cljs.core.__destructure_map(map__17585);
var progress = map__17585__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17585__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17613){
var state_val_17614 = (state_17613[(1)]);
if((state_val_17614 === (1))){
var state_17613__$1 = state_17613;
var statearr_17615_17631 = state_17613__$1;
(statearr_17615_17631[(2)] = null);

(statearr_17615_17631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17614 === (2))){
var inst_17599 = (state_17613[(7)]);
var _ = (function (){var statearr_17616 = state_17613;
(statearr_17616[(4)] = cljs.core.cons((5),(state_17613[(4)])));

return statearr_17616;
})();
var inst_17593 = db;
var inst_17594 = cljs.core.__destructure_map(inst_17593);
var inst_17595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17594,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17594,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17594,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17594,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17599__$1 = fluree.db.storage.core.ledger_garbage_key(inst_17596,inst_17597,inst_17598);
var inst_17600 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17601 = [inst_17597,inst_17598,garbage];
var inst_17602 = cljs.core.PersistentHashMap.fromArrays(inst_17600,inst_17601);
var inst_17603 = fluree.db.storage.core.serde(inst_17595);
var inst_17604 = fluree.db.serde.protocol._serialize_garbage(inst_17603,inst_17602);
var inst_17605 = fluree.db.storage.core.storage_write(inst_17595,inst_17599__$1,inst_17604);
var state_17613__$1 = (function (){var statearr_17617 = state_17613;
(statearr_17617[(7)] = inst_17599__$1);

return statearr_17617;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17613__$1,(6),inst_17605);
} else {
if((state_val_17614 === (3))){
var inst_17611 = (state_17613[(2)]);
var state_17613__$1 = state_17613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17613__$1,inst_17611);
} else {
if((state_val_17614 === (4))){
var inst_17586 = (state_17613[(2)]);
var state_17613__$1 = state_17613;
var statearr_17619_17632 = state_17613__$1;
(statearr_17619_17632[(2)] = inst_17586);

(statearr_17619_17632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17614 === (5))){
var _ = (function (){var statearr_17620 = state_17613;
(statearr_17620[(4)] = cljs.core.rest((state_17613[(4)])));

return statearr_17620;
})();
var state_17613__$1 = state_17613;
var ex17618 = (state_17613__$1[(2)]);
var statearr_17621_17633 = state_17613__$1;
(statearr_17621_17633[(5)] = ex17618);


if((ex17618 instanceof Error)){
var statearr_17622_17634 = state_17613__$1;
(statearr_17622_17634[(1)] = (4));

(statearr_17622_17634[(5)] = null);

} else {
throw ex17618;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17614 === (6))){
var inst_17599 = (state_17613[(7)]);
var inst_17607 = (state_17613[(2)]);
var inst_17608 = fluree.db.util.async.throw_err(inst_17607);
var _ = (function (){var statearr_17623 = state_17613;
(statearr_17623[(4)] = cljs.core.rest((state_17613[(4)])));

return statearr_17623;
})();
var state_17613__$1 = (function (){var statearr_17624 = state_17613;
(statearr_17624[(8)] = inst_17608);

return statearr_17624;
})();
var statearr_17625_17635 = state_17613__$1;
(statearr_17625_17635[(2)] = inst_17599);

(statearr_17625_17635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____0 = (function (){
var statearr_17626 = [null,null,null,null,null,null,null,null,null];
(statearr_17626[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__);

(statearr_17626[(1)] = (1));

return statearr_17626;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____1 = (function (state_17613){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17613);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17627){var ex__2736__auto__ = e17627;
var statearr_17628_17636 = state_17613;
(statearr_17628_17636[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17613[(4)]))){
var statearr_17629_17637 = state_17613;
(statearr_17629_17637[(1)] = cljs.core.first((state_17613[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17638 = state_17613;
state_17613 = G__17638;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__ = function(state_17613){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____1.call(this,state_17613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17630 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17630[(6)] = c__2755__auto__);

return statearr_17630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17640 = arguments.length;
switch (G__17640) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17696){
var state_val_17697 = (state_17696[(1)]);
if((state_val_17697 === (7))){
var state_17696__$1 = state_17696;
var statearr_17698_17724 = state_17696__$1;
(statearr_17698_17724[(2)] = (0));

(statearr_17698_17724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (1))){
var state_17696__$1 = state_17696;
var statearr_17699_17725 = state_17696__$1;
(statearr_17699_17725[(2)] = null);

(statearr_17699_17725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (4))){
var inst_17641 = (state_17696[(2)]);
var state_17696__$1 = state_17696;
var statearr_17700_17726 = state_17696__$1;
(statearr_17700_17726[(2)] = inst_17641);

(statearr_17700_17726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (6))){
var inst_17666 = (state_17696[(7)]);
var state_17696__$1 = state_17696;
var statearr_17701_17727 = state_17696__$1;
(statearr_17701_17727[(2)] = inst_17666);

(statearr_17701_17727[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (3))){
var inst_17694 = (state_17696[(2)]);
var state_17696__$1 = state_17696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17696__$1,inst_17694);
} else {
if((state_val_17697 === (12))){
var inst_17663 = (state_17696[(8)]);
var inst_17690 = (state_17696[(2)]);
var inst_17691 = fluree.db.util.async.throw_err(inst_17690);
var _ = (function (){var statearr_17702 = state_17696;
(statearr_17702[(4)] = cljs.core.rest((state_17696[(4)])));

return statearr_17702;
})();
var state_17696__$1 = (function (){var statearr_17703 = state_17696;
(statearr_17703[(9)] = inst_17691);

return statearr_17703;
})();
var statearr_17704_17728 = state_17696__$1;
(statearr_17704_17728[(2)] = inst_17663);

(statearr_17704_17728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (2))){
var inst_17658 = (state_17696[(10)]);
var inst_17656 = (state_17696[(11)]);
var inst_17654 = (state_17696[(12)]);
var inst_17666 = (state_17696[(7)]);
var _ = (function (){var statearr_17705 = state_17696;
(statearr_17705[(4)] = cljs.core.cons((5),(state_17696[(4)])));

return statearr_17705;
})();
var inst_17648 = db;
var inst_17649 = cljs.core.__destructure_map(inst_17648);
var inst_17650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17653 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17654__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17655 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17656__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17657 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17658__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17661 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17662 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17663 = fluree.db.storage.core.ledger_root_key(inst_17650,inst_17658__$1,inst_17656__$1);
var inst_17664 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17665 = fluree.db.storage.core.child_data(inst_17657);
var inst_17666__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17654__$1);
var state_17696__$1 = (function (){var statearr_17706 = state_17696;
(statearr_17706[(13)] = inst_17653);

(statearr_17706[(14)] = inst_17659);

(statearr_17706[(15)] = inst_17661);

(statearr_17706[(10)] = inst_17658__$1);

(statearr_17706[(16)] = inst_17651);

(statearr_17706[(11)] = inst_17656__$1);

(statearr_17706[(12)] = inst_17654__$1);

(statearr_17706[(7)] = inst_17666__$1);

(statearr_17706[(17)] = inst_17662);

(statearr_17706[(18)] = inst_17665);

(statearr_17706[(19)] = inst_17664);

(statearr_17706[(20)] = inst_17660);

(statearr_17706[(21)] = inst_17655);

(statearr_17706[(8)] = inst_17663);

(statearr_17706[(22)] = inst_17652);

return statearr_17706;
})();
if(cljs.core.truth_(inst_17666__$1)){
var statearr_17707_17729 = state_17696__$1;
(statearr_17707_17729[(1)] = (6));

} else {
var statearr_17708_17730 = state_17696__$1;
(statearr_17708_17730[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (11))){
var inst_17653 = (state_17696[(13)]);
var inst_17670 = (state_17696[(23)]);
var inst_17661 = (state_17696[(15)]);
var inst_17658 = (state_17696[(10)]);
var inst_17651 = (state_17696[(16)]);
var inst_17656 = (state_17696[(11)]);
var inst_17654 = (state_17696[(12)]);
var inst_17662 = (state_17696[(17)]);
var inst_17665 = (state_17696[(18)]);
var inst_17664 = (state_17696[(19)]);
var inst_17660 = (state_17696[(20)]);
var inst_17655 = (state_17696[(21)]);
var inst_17663 = (state_17696[(8)]);
var inst_17652 = (state_17696[(22)]);
var inst_17675 = (state_17696[(2)]);
var inst_17676 = fluree.db.storage.core.child_data(inst_17660);
var inst_17677 = fluree.db.storage.core.child_data(inst_17662);
var inst_17678 = fluree.db.util.core.current_time_millis();
var inst_17679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17680 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17681 = (new cljs.core.PersistentVector(null,2,(5),inst_17679,inst_17680,null));
var inst_17682 = cljs.core.select_keys(inst_17654,inst_17681);
var inst_17683 = fluree.db.storage.core.child_data(inst_17653);
var inst_17684 = [inst_17656,inst_17665,inst_17658,inst_17670,inst_17675,inst_17676,inst_17677,inst_17651,inst_17678,inst_17652,inst_17661,inst_17682,inst_17683];
var inst_17685 = cljs.core.PersistentHashMap.fromArrays(inst_17664,inst_17684);
var inst_17686 = fluree.db.storage.core.serde(inst_17655);
var inst_17687 = fluree.db.serde.protocol._serialize_db_root(inst_17686,inst_17685);
var inst_17688 = fluree.db.storage.core.storage_write(inst_17655,inst_17663,inst_17687);
var state_17696__$1 = state_17696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17696__$1,(12),inst_17688);
} else {
if((state_val_17697 === (9))){
var inst_17671 = (state_17696[(24)]);
var state_17696__$1 = state_17696;
var statearr_17710_17731 = state_17696__$1;
(statearr_17710_17731[(2)] = inst_17671);

(statearr_17710_17731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (5))){
var _ = (function (){var statearr_17711 = state_17696;
(statearr_17711[(4)] = cljs.core.rest((state_17696[(4)])));

return statearr_17711;
})();
var state_17696__$1 = state_17696;
var ex17709 = (state_17696__$1[(2)]);
var statearr_17712_17732 = state_17696__$1;
(statearr_17712_17732[(5)] = ex17709);


if((ex17709 instanceof Error)){
var statearr_17713_17733 = state_17696__$1;
(statearr_17713_17733[(1)] = (4));

(statearr_17713_17733[(5)] = null);

} else {
throw ex17709;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (10))){
var inst_17659 = (state_17696[(14)]);
var state_17696__$1 = state_17696;
var statearr_17714_17734 = state_17696__$1;
(statearr_17714_17734[(2)] = inst_17659);

(statearr_17714_17734[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (8))){
var inst_17671 = (state_17696[(24)]);
var inst_17670 = (state_17696[(2)]);
var inst_17671__$1 = custom_ecount;
var state_17696__$1 = (function (){var statearr_17715 = state_17696;
(statearr_17715[(23)] = inst_17670);

(statearr_17715[(24)] = inst_17671__$1);

return statearr_17715;
})();
if(cljs.core.truth_(inst_17671__$1)){
var statearr_17716_17735 = state_17696__$1;
(statearr_17716_17735[(1)] = (9));

} else {
var statearr_17717_17736 = state_17696__$1;
(statearr_17717_17736[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2733__auto__ = null;
var fluree$db$storage$core$state_machine__2733__auto____0 = (function (){
var statearr_17718 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17718[(0)] = fluree$db$storage$core$state_machine__2733__auto__);

(statearr_17718[(1)] = (1));

return statearr_17718;
});
var fluree$db$storage$core$state_machine__2733__auto____1 = (function (state_17696){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17696);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17719){var ex__2736__auto__ = e17719;
var statearr_17720_17737 = state_17696;
(statearr_17720_17737[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17696[(4)]))){
var statearr_17721_17738 = state_17696;
(statearr_17721_17738[(1)] = cljs.core.first((state_17696[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17739 = state_17696;
state_17696 = G__17739;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2733__auto__ = function(state_17696){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2733__auto____1.call(this,state_17696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2733__auto____0;
fluree$db$storage$core$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2733__auto____1;
return fluree$db$storage$core$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17722 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17722[(6)] = c__2755__auto__);

return statearr_17722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___17798 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17772){
var state_val_17773 = (state_17772[(1)]);
if((state_val_17773 === (7))){
var inst_17752 = (state_17772[(7)]);
var state_17772__$1 = state_17772;
var statearr_17774_17799 = state_17772__$1;
(statearr_17774_17799[(2)] = inst_17752);

(statearr_17774_17799[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17773 === (1))){
var state_17772__$1 = state_17772;
var statearr_17775_17800 = state_17772__$1;
(statearr_17775_17800[(2)] = null);

(statearr_17775_17800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17773 === (4))){
var inst_17740 = (state_17772[(2)]);
var inst_17741 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17742 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17740);
var inst_17743 = cljs.core.async.close_BANG_(return_ch);
var state_17772__$1 = (function (){var statearr_17776 = state_17772;
(statearr_17776[(8)] = inst_17741);

(statearr_17776[(9)] = inst_17742);

return statearr_17776;
})();
var statearr_17777_17801 = state_17772__$1;
(statearr_17777_17801[(2)] = inst_17743);

(statearr_17777_17801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17773 === (6))){
var inst_17752 = (state_17772[(7)]);
var inst_17751 = (state_17772[(10)]);
var inst_17751__$1 = (state_17772[(2)]);
var inst_17752__$1 = (inst_17751__$1 == null);
var state_17772__$1 = (function (){var statearr_17778 = state_17772;
(statearr_17778[(7)] = inst_17752__$1);

(statearr_17778[(10)] = inst_17751__$1);

return statearr_17778;
})();
if(cljs.core.truth_(inst_17752__$1)){
var statearr_17779_17802 = state_17772__$1;
(statearr_17779_17802[(1)] = (7));

} else {
var statearr_17780_17803 = state_17772__$1;
(statearr_17780_17803[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17773 === (3))){
var inst_17770 = (state_17772[(2)]);
var state_17772__$1 = state_17772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17772__$1,inst_17770);
} else {
if((state_val_17773 === (12))){
var inst_17767 = (state_17772[(2)]);
var _ = (function (){var statearr_17781 = state_17772;
(statearr_17781[(4)] = cljs.core.rest((state_17772[(4)])));

return statearr_17781;
})();
var state_17772__$1 = state_17772;
var statearr_17782_17804 = state_17772__$1;
(statearr_17782_17804[(2)] = inst_17767);

(statearr_17782_17804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17773 === (2))){
var _ = (function (){var statearr_17783 = state_17772;
(statearr_17783[(4)] = cljs.core.cons((5),(state_17772[(4)])));

return statearr_17783;
})();
var inst_17749 = fluree.db.storage.core.storage_read(conn,key);
var state_17772__$1 = state_17772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17772__$1,(6),inst_17749);
} else {
if((state_val_17773 === (11))){
var inst_17751 = (state_17772[(10)]);
var inst_17761 = fluree.db.storage.core.serde(conn);
var inst_17762 = fluree.db.serde.protocol._deserialize_leaf(inst_17761,inst_17751);
var inst_17763 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17762);
var inst_17764 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_17763);
var inst_17765 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17764);
var state_17772__$1 = state_17772;
var statearr_17785_17805 = state_17772__$1;
(statearr_17785_17805[(2)] = inst_17765);

(statearr_17785_17805[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17773 === (9))){
var inst_17757 = (state_17772[(2)]);
var state_17772__$1 = state_17772;
if(cljs.core.truth_(inst_17757)){
var statearr_17786_17806 = state_17772__$1;
(statearr_17786_17806[(1)] = (10));

} else {
var statearr_17787_17807 = state_17772__$1;
(statearr_17787_17807[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17773 === (5))){
var _ = (function (){var statearr_17788 = state_17772;
(statearr_17788[(4)] = cljs.core.rest((state_17772[(4)])));

return statearr_17788;
})();
var state_17772__$1 = state_17772;
var ex17784 = (state_17772__$1[(2)]);
var statearr_17789_17808 = state_17772__$1;
(statearr_17789_17808[(5)] = ex17784);


var statearr_17790_17809 = state_17772__$1;
(statearr_17790_17809[(1)] = (4));

(statearr_17790_17809[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17773 === (10))){
var inst_17759 = cljs.core.async.close_BANG_(return_ch);
var state_17772__$1 = state_17772;
var statearr_17791_17810 = state_17772__$1;
(statearr_17791_17810[(2)] = inst_17759);

(statearr_17791_17810[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17773 === (8))){
var inst_17751 = (state_17772[(10)]);
var inst_17755 = (inst_17751 instanceof Error);
var state_17772__$1 = state_17772;
var statearr_17792_17811 = state_17772__$1;
(statearr_17792_17811[(2)] = inst_17755);

(statearr_17792_17811[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2733__auto____0 = (function (){
var statearr_17793 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17793[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2733__auto__);

(statearr_17793[(1)] = (1));

return statearr_17793;
});
var fluree$db$storage$core$reify_history_$_state_machine__2733__auto____1 = (function (state_17772){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17772);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17794){var ex__2736__auto__ = e17794;
var statearr_17795_17812 = state_17772;
(statearr_17795_17812[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17772[(4)]))){
var statearr_17796_17813 = state_17772;
(statearr_17796_17813[(1)] = cljs.core.first((state_17772[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17814 = state_17772;
state_17772 = G__17814;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2733__auto__ = function(state_17772){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2733__auto____1.call(this,state_17772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2733__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2733__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17797 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17797[(6)] = c__2755__auto___17798);

return statearr_17797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__17816 = arguments.length;
switch (G__17816) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4221__auto__ = (rhs == null);
if(and__4221__auto__){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___17928 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17879){
var state_val_17880 = (state_17879[(1)]);
if((state_val_17880 === (7))){
var state_17879__$1 = state_17879;
var statearr_17881_17929 = state_17879__$1;
(statearr_17881_17929[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_17881_17929[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (20))){
var inst_17858 = cljs.core.PersistentVector.EMPTY;
var state_17879__$1 = state_17879;
var statearr_17882_17930 = state_17879__$1;
(statearr_17882_17930[(2)] = inst_17858);

(statearr_17882_17930[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (1))){
var state_17879__$1 = state_17879;
var statearr_17883_17931 = state_17879__$1;
(statearr_17883_17931[(2)] = null);

(statearr_17883_17931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (24))){
var state_17879__$1 = state_17879;
var statearr_17884_17932 = state_17879__$1;
(statearr_17884_17932[(2)] = null);

(statearr_17884_17932[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (4))){
var inst_17819 = (state_17879[(2)]);
var inst_17820 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17821 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17819);
var inst_17822 = cljs.core.async.close_BANG_(result_ch);
var state_17879__$1 = (function (){var statearr_17885 = state_17879;
(statearr_17885[(7)] = inst_17821);

(statearr_17885[(8)] = inst_17820);

return statearr_17885;
})();
var statearr_17886_17933 = state_17879__$1;
(statearr_17886_17933[(2)] = inst_17822);

(statearr_17886_17933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (15))){
var inst_17844 = (state_17879[(2)]);
var state_17879__$1 = state_17879;
var statearr_17887_17934 = state_17879__$1;
(statearr_17887_17934[(2)] = inst_17844);

(statearr_17887_17934[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (21))){
var inst_17848 = (state_17879[(9)]);
var inst_17861 = (state_17879[(10)]);
var inst_17833 = (state_17879[(11)]);
var inst_17832 = (state_17879[(12)]);
var inst_17831 = (state_17879[(13)]);
var inst_17868 = (state_17879[(2)]);
var inst_17869 = (function (){var base_node = inst_17831;
var first_flake = inst_17832;
var node_t = inst_17833;
var source = inst_17848;
var coll = inst_17861;
var conj_QMARK_ = inst_17868;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__17889 = f.p;
var fexpr__17888 = (function (){var or__4223__auto__ = remove_preds;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__17888.cljs$core$IFn$_invoke$arity$1 ? fexpr__17888.cljs$core$IFn$_invoke$arity$1(G__17889) : fexpr__17888.call(null,G__17889));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_17870 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17831);
var inst_17871 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17869,inst_17870,inst_17861);
var inst_17872 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_17871);
var inst_17873 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17831,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_17872);
var inst_17874 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17873);
var _ = (function (){var statearr_17890 = state_17879;
(statearr_17890[(4)] = cljs.core.rest((state_17879[(4)])));

return statearr_17890;
})();
var state_17879__$1 = state_17879;
var statearr_17891_17935 = state_17879__$1;
(statearr_17891_17935[(2)] = inst_17874);

(statearr_17891_17935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (13))){
var state_17879__$1 = state_17879;
var statearr_17892_17936 = state_17879__$1;
(statearr_17892_17936[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_17892_17936[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (22))){
var inst_17848 = (state_17879[(9)]);
var inst_17861 = (state_17879[(10)]);
var inst_17833 = (state_17879[(11)]);
var inst_17832 = (state_17879[(12)]);
var inst_17831 = (state_17879[(13)]);
var inst_17862 = (function (){var base_node = inst_17831;
var first_flake = inst_17832;
var node_t = inst_17833;
var source = inst_17848;
var coll = inst_17861;
return (function (f){
return f.op === true;
});
})();
var state_17879__$1 = state_17879;
var statearr_17893_17937 = state_17879__$1;
(statearr_17893_17937[(2)] = inst_17862);

(statearr_17893_17937[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (6))){
var inst_17833 = (state_17879[(11)]);
var inst_17831 = (state_17879[(13)]);
var inst_17830 = (state_17879[(2)]);
var inst_17831__$1 = fluree.db.util.async.throw_err(inst_17830);
var inst_17832 = fluree.db.dbproto._first_flake(inst_17831__$1);
var inst_17833__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_17831__$1);
var inst_17834 = (inst_17833__$1 > t);
var state_17879__$1 = (function (){var statearr_17894 = state_17879;
(statearr_17894[(11)] = inst_17833__$1);

(statearr_17894[(12)] = inst_17832);

(statearr_17894[(13)] = inst_17831__$1);

return statearr_17894;
})();
if(cljs.core.truth_(inst_17834)){
var statearr_17895_17938 = state_17879__$1;
(statearr_17895_17938[(1)] = (7));

} else {
var statearr_17896_17939 = state_17879__$1;
(statearr_17896_17939[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (17))){
var inst_17832 = (state_17879[(12)]);
var inst_17849 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_17832,rhs,leftmost_QMARK_,t);
var state_17879__$1 = state_17879;
var statearr_17897_17940 = state_17879__$1;
(statearr_17897_17940[(2)] = inst_17849);

(statearr_17897_17940[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (3))){
var inst_17877 = (state_17879[(2)]);
var state_17879__$1 = state_17879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17879__$1,inst_17877);
} else {
if((state_val_17880 === (12))){
var inst_17846 = (state_17879[(2)]);
var state_17879__$1 = state_17879;
var statearr_17898_17941 = state_17879__$1;
(statearr_17898_17941[(2)] = inst_17846);

(statearr_17898_17941[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (2))){
var _ = (function (){var statearr_17899 = state_17879;
(statearr_17899[(4)] = cljs.core.cons((5),(state_17879[(4)])));

return statearr_17899;
})();
var inst_17828 = fluree.db.dbproto._resolve(node);
var state_17879__$1 = state_17879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17879__$1,(6),inst_17828);
} else {
if((state_val_17880 === (23))){
var inst_17848 = (state_17879[(9)]);
var inst_17861 = (state_17879[(10)]);
var inst_17833 = (state_17879[(11)]);
var inst_17832 = (state_17879[(12)]);
var inst_17831 = (state_17879[(13)]);
var inst_17864 = (function (){var base_node = inst_17831;
var first_flake = inst_17832;
var node_t = inst_17833;
var source = inst_17848;
var coll = inst_17861;
return (function (f){
return f.op === false;
});
})();
var state_17879__$1 = state_17879;
var statearr_17900_17942 = state_17879__$1;
(statearr_17900_17942[(2)] = inst_17864);

(statearr_17900_17942[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (19))){
var inst_17851 = (state_17879[(14)]);
var inst_17854 = (state_17879[(2)]);
var inst_17855 = fluree.db.util.async.throw_err(inst_17854);
var inst_17856 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_17851,inst_17855);
var state_17879__$1 = state_17879;
var statearr_17901_17943 = state_17879__$1;
(statearr_17901_17943[(2)] = inst_17856);

(statearr_17901_17943[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (11))){
var inst_17833 = (state_17879[(11)]);
var inst_17840 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17833,t);
var state_17879__$1 = state_17879;
if(inst_17840){
var statearr_17903_17944 = state_17879__$1;
(statearr_17903_17944[(1)] = (13));

} else {
var statearr_17904_17945 = state_17879__$1;
(statearr_17904_17945[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (9))){
var inst_17848 = (state_17879[(9)]);
var inst_17848__$1 = (state_17879[(2)]);
var state_17879__$1 = (function (){var statearr_17905 = state_17879;
(statearr_17905[(9)] = inst_17848__$1);

return statearr_17905;
})();
var G__17906_17946 = inst_17848__$1;
var G__17906_17947__$1 = (((G__17906_17946 instanceof cljs.core.Keyword))?G__17906_17946.fqn:null);
switch (G__17906_17947__$1) {
case "novelty":
var statearr_17907_17949 = state_17879__$1;
(statearr_17907_17949[(1)] = (17));


break;
case "history":
var statearr_17908_17950 = state_17879__$1;
(statearr_17908_17950[(1)] = (18));


break;
case "none":
var statearr_17909_17951 = state_17879__$1;
(statearr_17909_17951[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17906_17947__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (5))){
var _ = (function (){var statearr_17910 = state_17879;
(statearr_17910[(4)] = cljs.core.rest((state_17879[(4)])));

return statearr_17910;
})();
var state_17879__$1 = state_17879;
var ex17902 = (state_17879__$1[(2)]);
var statearr_17911_17952 = state_17879__$1;
(statearr_17911_17952[(5)] = ex17902);


var statearr_17912_17953 = state_17879__$1;
(statearr_17912_17953[(1)] = (4));

(statearr_17912_17953[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (14))){
var state_17879__$1 = state_17879;
var statearr_17913_17954 = state_17879__$1;
(statearr_17913_17954[(2)] = null);

(statearr_17913_17954[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (16))){
var inst_17848 = (state_17879[(9)]);
var inst_17861 = (state_17879[(2)]);
var state_17879__$1 = (function (){var statearr_17914 = state_17879;
(statearr_17914[(10)] = inst_17861);

return statearr_17914;
})();
var G__17915_17955 = inst_17848;
var G__17915_17956__$1 = (((G__17915_17955 instanceof cljs.core.Keyword))?G__17915_17955.fqn:null);
switch (G__17915_17956__$1) {
case "novelty":
var statearr_17916_17958 = state_17879__$1;
(statearr_17916_17958[(1)] = (22));


break;
case "history":
var statearr_17917_17959 = state_17879__$1;
(statearr_17917_17959[(1)] = (23));


break;
case "none":
var statearr_17918_17960 = state_17879__$1;
(statearr_17918_17960[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17915_17956__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (10))){
var state_17879__$1 = state_17879;
var statearr_17919_17961 = state_17879__$1;
(statearr_17919_17961[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_17919_17961[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (18))){
var inst_17848 = (state_17879[(9)]);
var inst_17833 = (state_17879[(11)]);
var inst_17832 = (state_17879[(12)]);
var inst_17831 = (state_17879[(13)]);
var inst_17851 = (function (){var base_node = inst_17831;
var first_flake = inst_17832;
var node_t = inst_17833;
var source = inst_17848;
return (function (p1__17818_SHARP_){
return (p1__17818_SHARP_.t <= t);
});
})();
var inst_17852 = fluree.db.dbproto._resolve_history(node);
var state_17879__$1 = (function (){var statearr_17920 = state_17879;
(statearr_17920[(14)] = inst_17851);

return statearr_17920;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17879__$1,(19),inst_17852);
} else {
if((state_val_17880 === (8))){
var inst_17833 = (state_17879[(11)]);
var inst_17837 = (inst_17833 < t);
var state_17879__$1 = state_17879;
if(cljs.core.truth_(inst_17837)){
var statearr_17921_17962 = state_17879__$1;
(statearr_17921_17962[(1)] = (10));

} else {
var statearr_17922_17963 = state_17879__$1;
(statearr_17922_17963[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____0 = (function (){
var statearr_17923 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17923[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__);

(statearr_17923[(1)] = (1));

return statearr_17923;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____1 = (function (state_17879){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17879);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17924){var ex__2736__auto__ = e17924;
var statearr_17925_17964 = state_17879;
(statearr_17925_17964[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17879[(4)]))){
var statearr_17926_17965 = state_17879;
(statearr_17926_17965[(1)] = cljs.core.first((state_17879[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17966 = state_17879;
state_17879 = G__17966;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__ = function(state_17879){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____1.call(this,state_17879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17927 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17927[(6)] = c__2755__auto___17928);

return statearr_17927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18026){
var state_val_18027 = (state_18026[(1)]);
if((state_val_18027 === (7))){
var inst_17977 = (state_18026[(7)]);
var inst_17981 = (inst_17977 <= from_t);
var state_18026__$1 = state_18026;
var statearr_18028_18068 = state_18026__$1;
(statearr_18028_18068[(2)] = inst_17981);

(statearr_18028_18068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (20))){
var inst_18011 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_18012 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18011)].join('');
var inst_18013 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18014 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_18015 = cljs.core.PersistentHashMap.fromArrays(inst_18013,inst_18014);
var inst_18016 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18012,inst_18015);
var inst_18017 = (function(){throw inst_18016})();
var state_18026__$1 = state_18026;
var statearr_18029_18069 = state_18026__$1;
(statearr_18029_18069[(2)] = inst_18017);

(statearr_18029_18069[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (1))){
var state_18026__$1 = state_18026;
var statearr_18030_18070 = state_18026__$1;
(statearr_18030_18070[(2)] = null);

(statearr_18030_18070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (4))){
var inst_17969 = (state_18026[(2)]);
var inst_17970 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_17969], 0));
var inst_17971 = (function(){throw inst_17969})();
var state_18026__$1 = (function (){var statearr_18031 = state_18026;
(statearr_18031[(8)] = inst_17970);

return statearr_18031;
})();
var statearr_18032_18071 = state_18026__$1;
(statearr_18032_18071[(2)] = inst_17971);

(statearr_18032_18071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (15))){
var inst_17996 = (state_18026[(2)]);
var state_18026__$1 = (function (){var statearr_18033 = state_18026;
(statearr_18033[(9)] = inst_17996);

return statearr_18033;
})();
if(cljs.core.truth_(from_t)){
var statearr_18034_18072 = state_18026__$1;
(statearr_18034_18072[(1)] = (16));

} else {
var statearr_18035_18073 = state_18026__$1;
(statearr_18035_18073[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (21))){
var inst_18005 = (state_18026[(10)]);
var inst_18007 = (state_18026[(11)]);
var inst_18006 = (state_18026[(12)]);
var inst_18019 = (state_18026[(2)]);
var inst_18020 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_18006,inst_18007,leftmost_QMARK_,to_t);
var inst_18021 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18020,inst_18005);
var _ = (function (){var statearr_18036 = state_18026;
(statearr_18036[(4)] = cljs.core.rest((state_18026[(4)])));

return statearr_18036;
})();
var state_18026__$1 = (function (){var statearr_18037 = state_18026;
(statearr_18037[(13)] = inst_18019);

return statearr_18037;
})();
var statearr_18038_18074 = state_18026__$1;
(statearr_18038_18074[(2)] = inst_18021);

(statearr_18038_18074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (13))){
var inst_17977 = (state_18026[(7)]);
var inst_17989 = (state_18026[(14)]);
var inst_17992 = (function (){var node_t = inst_17977;
var G__17985 = inst_17989;
return (function (p1__17967_SHARP_){
return (p1__17967_SHARP_.t < to_t);
});
})();
var inst_17993 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_17992,inst_17989);
var state_18026__$1 = state_18026;
var statearr_18039_18075 = state_18026__$1;
(statearr_18039_18075[(2)] = inst_17993);

(statearr_18039_18075[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (6))){
var inst_17978 = (state_18026[(15)]);
var state_18026__$1 = state_18026;
var statearr_18040_18076 = state_18026__$1;
(statearr_18040_18076[(2)] = inst_17978);

(statearr_18040_18076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (17))){
var inst_17996 = (state_18026[(9)]);
var state_18026__$1 = state_18026;
var statearr_18041_18077 = state_18026__$1;
(statearr_18041_18077[(2)] = inst_17996);

(statearr_18041_18077[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (3))){
var inst_18024 = (state_18026[(2)]);
var state_18026__$1 = state_18026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18026__$1,inst_18024);
} else {
if((state_val_18027 === (12))){
var inst_17977 = (state_18026[(7)]);
var inst_17988 = (state_18026[(2)]);
var inst_17989 = fluree.db.util.async.throw_err(inst_17988);
var inst_17990 = (to_t > inst_17977);
var state_18026__$1 = (function (){var statearr_18042 = state_18026;
(statearr_18042[(14)] = inst_17989);

return statearr_18042;
})();
if(cljs.core.truth_(inst_17990)){
var statearr_18043_18078 = state_18026__$1;
(statearr_18043_18078[(1)] = (13));

} else {
var statearr_18044_18079 = state_18026__$1;
(statearr_18044_18079[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (2))){
var inst_17978 = (state_18026[(15)]);
var _ = (function (){var statearr_18045 = state_18026;
(statearr_18045[(4)] = cljs.core.cons((5),(state_18026[(4)])));

return statearr_18045;
})();
var inst_17977 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_17978__$1 = (from_t == null);
var state_18026__$1 = (function (){var statearr_18046 = state_18026;
(statearr_18046[(15)] = inst_17978__$1);

(statearr_18046[(7)] = inst_17977);

return statearr_18046;
})();
if(cljs.core.truth_(inst_17978__$1)){
var statearr_18047_18080 = state_18026__$1;
(statearr_18047_18080[(1)] = (6));

} else {
var statearr_18048_18081 = state_18026__$1;
(statearr_18048_18081[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (19))){
var state_18026__$1 = state_18026;
var statearr_18049_18082 = state_18026__$1;
(statearr_18049_18082[(2)] = null);

(statearr_18049_18082[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (11))){
var inst_18005 = (state_18026[(2)]);
var inst_18006 = fluree.db.dbproto._first_flake(node);
var inst_18007 = fluree.db.dbproto._rhs(node);
var inst_18008 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_18026__$1 = (function (){var statearr_18051 = state_18026;
(statearr_18051[(10)] = inst_18005);

(statearr_18051[(11)] = inst_18007);

(statearr_18051[(12)] = inst_18006);

return statearr_18051;
})();
if(cljs.core.truth_(inst_18008)){
var statearr_18052_18083 = state_18026__$1;
(statearr_18052_18083[(1)] = (19));

} else {
var statearr_18053_18084 = state_18026__$1;
(statearr_18053_18084[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (9))){
var inst_17986 = fluree.db.dbproto._resolve_history(node);
var state_18026__$1 = state_18026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18026__$1,(12),inst_17986);
} else {
if((state_val_18027 === (5))){
var _ = (function (){var statearr_18054 = state_18026;
(statearr_18054[(4)] = cljs.core.rest((state_18026[(4)])));

return statearr_18054;
})();
var state_18026__$1 = state_18026;
var ex18050 = (state_18026__$1[(2)]);
var statearr_18055_18085 = state_18026__$1;
(statearr_18055_18085[(5)] = ex18050);


var statearr_18056_18086 = state_18026__$1;
(statearr_18056_18086[(1)] = (4));

(statearr_18056_18086[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (14))){
var inst_17989 = (state_18026[(14)]);
var state_18026__$1 = state_18026;
var statearr_18057_18087 = state_18026__$1;
(statearr_18057_18087[(2)] = inst_17989);

(statearr_18057_18087[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (16))){
var inst_17996 = (state_18026[(9)]);
var inst_17977 = (state_18026[(7)]);
var inst_17998 = (function (){var node_t = inst_17977;
var G__17985 = inst_17996;
return (function (p1__17968_SHARP_){
return (p1__17968_SHARP_.t <= from_t);
});
})();
var inst_17999 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_17998,inst_17996);
var state_18026__$1 = state_18026;
var statearr_18058_18088 = state_18026__$1;
(statearr_18058_18088[(2)] = inst_17999);

(statearr_18058_18088[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (10))){
var state_18026__$1 = state_18026;
var statearr_18059_18089 = state_18026__$1;
(statearr_18059_18089[(2)] = null);

(statearr_18059_18089[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (18))){
var inst_18002 = (state_18026[(2)]);
var state_18026__$1 = state_18026;
var statearr_18060_18090 = state_18026__$1;
(statearr_18060_18090[(2)] = inst_18002);

(statearr_18060_18090[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (8))){
var inst_17983 = (state_18026[(2)]);
var state_18026__$1 = state_18026;
if(cljs.core.truth_(inst_17983)){
var statearr_18061_18091 = state_18026__$1;
(statearr_18061_18091[(1)] = (9));

} else {
var statearr_18062_18092 = state_18026__$1;
(statearr_18062_18092[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____0 = (function (){
var statearr_18063 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18063[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__);

(statearr_18063[(1)] = (1));

return statearr_18063;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____1 = (function (state_18026){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18026);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18064){var ex__2736__auto__ = e18064;
var statearr_18065_18093 = state_18026;
(statearr_18065_18093[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18026[(4)]))){
var statearr_18066_18094 = state_18026;
(statearr_18066_18094[(1)] = cljs.core.first((state_18026[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18095 = state_18026;
state_18026 = G__18095;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__ = function(state_18026){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____1.call(this,state_18026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18067 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18067[(6)] = c__2755__auto__);

return statearr_18067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4223__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__18096_18106 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18097_18107 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18096_18106,G__18097_18107) : object_cache.call(null,G__18096_18106,G__18097_18107));

var G__18098 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18099 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18100 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18101 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18100,G__18101) : object_cache.call(null,G__18100,G__18101));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18098,G__18099) : object_cache.call(null,G__18098,G__18099));
} else {
var G__18102 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18103 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18104 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18105 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18104,G__18105) : object_cache.call(null,G__18104,G__18105));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18102,G__18103) : object_cache.call(null,G__18102,G__18103));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18128){
var state_val_18129 = (state_18128[(1)]);
if((state_val_18129 === (7))){
var state_18128__$1 = state_18128;
var statearr_18130_18150 = state_18128__$1;
(statearr_18130_18150[(2)] = null);

(statearr_18130_18150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (1))){
var state_18128__$1 = state_18128;
var statearr_18131_18151 = state_18128__$1;
(statearr_18131_18151[(2)] = null);

(statearr_18131_18151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (4))){
var inst_18108 = (state_18128[(2)]);
var state_18128__$1 = state_18128;
var statearr_18132_18152 = state_18128__$1;
(statearr_18132_18152[(2)] = inst_18108);

(statearr_18132_18152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (6))){
var inst_18114 = (state_18128[(7)]);
var inst_18116 = fluree.db.storage.core.serde(conn);
var state_18128__$1 = (function (){var statearr_18133 = state_18128;
(statearr_18133[(8)] = inst_18116);

return statearr_18133;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18128__$1,(9),inst_18114);
} else {
if((state_val_18129 === (3))){
var inst_18126 = (state_18128[(2)]);
var state_18128__$1 = state_18128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18128__$1,inst_18126);
} else {
if((state_val_18129 === (2))){
var inst_18114 = (state_18128[(7)]);
var _ = (function (){var statearr_18135 = state_18128;
(statearr_18135[(4)] = cljs.core.cons((5),(state_18128[(4)])));

return statearr_18135;
})();
var inst_18114__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_18128__$1 = (function (){var statearr_18136 = state_18128;
(statearr_18136[(7)] = inst_18114__$1);

return statearr_18136;
})();
if(cljs.core.truth_(inst_18114__$1)){
var statearr_18137_18153 = state_18128__$1;
(statearr_18137_18153[(1)] = (6));

} else {
var statearr_18138_18154 = state_18128__$1;
(statearr_18138_18154[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (9))){
var inst_18116 = (state_18128[(8)]);
var inst_18118 = (state_18128[(2)]);
var inst_18119 = fluree.db.util.async.throw_err(inst_18118);
var inst_18120 = fluree.db.serde.protocol._deserialize_branch(inst_18116,inst_18119);
var state_18128__$1 = state_18128;
var statearr_18139_18155 = state_18128__$1;
(statearr_18139_18155[(2)] = inst_18120);

(statearr_18139_18155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (5))){
var _ = (function (){var statearr_18140 = state_18128;
(statearr_18140[(4)] = cljs.core.rest((state_18128[(4)])));

return statearr_18140;
})();
var state_18128__$1 = state_18128;
var ex18134 = (state_18128__$1[(2)]);
var statearr_18141_18156 = state_18128__$1;
(statearr_18141_18156[(5)] = ex18134);


if((ex18134 instanceof Error)){
var statearr_18142_18157 = state_18128__$1;
(statearr_18142_18157[(1)] = (4));

(statearr_18142_18157[(5)] = null);

} else {
throw ex18134;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (8))){
var inst_18123 = (state_18128[(2)]);
var _ = (function (){var statearr_18143 = state_18128;
(statearr_18143[(4)] = cljs.core.rest((state_18128[(4)])));

return statearr_18143;
})();
var state_18128__$1 = state_18128;
var statearr_18144_18158 = state_18128__$1;
(statearr_18144_18158[(2)] = inst_18123);

(statearr_18144_18158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2733__auto____0 = (function (){
var statearr_18145 = [null,null,null,null,null,null,null,null,null];
(statearr_18145[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2733__auto__);

(statearr_18145[(1)] = (1));

return statearr_18145;
});
var fluree$db$storage$core$read_branch_$_state_machine__2733__auto____1 = (function (state_18128){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18128);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18146){var ex__2736__auto__ = e18146;
var statearr_18147_18159 = state_18128;
(statearr_18147_18159[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18128[(4)]))){
var statearr_18148_18160 = state_18128;
(statearr_18148_18160[(1)] = cljs.core.first((state_18128[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18161 = state_18128;
state_18128 = G__18161;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2733__auto__ = function(state_18128){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2733__auto____1.call(this,state_18128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18149 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18149[(6)] = c__2755__auto__);

return statearr_18149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___18240 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18212){
var state_val_18213 = (state_18212[(1)]);
if((state_val_18213 === (7))){
var inst_18179 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18180 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18181 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18182 = cljs.core.PersistentHashMap.fromArrays(inst_18180,inst_18181);
var inst_18183 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18179,inst_18182);
var inst_18184 = (function(){throw inst_18183})();
var state_18212__$1 = state_18212;
var statearr_18214_18241 = state_18212__$1;
(statearr_18214_18241[(2)] = inst_18184);

(statearr_18214_18241[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (1))){
var state_18212__$1 = state_18212;
var statearr_18215_18242 = state_18212__$1;
(statearr_18215_18242[(2)] = null);

(statearr_18215_18242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (4))){
var inst_18162 = (state_18212[(2)]);
var inst_18163 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18164 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18162);
var inst_18165 = cljs.core.async.close_BANG_(return_ch);
var state_18212__$1 = (function (){var statearr_18216 = state_18212;
(statearr_18216[(7)] = inst_18164);

(statearr_18216[(8)] = inst_18163);

return statearr_18216;
})();
var statearr_18217_18243 = state_18212__$1;
(statearr_18217_18243[(2)] = inst_18165);

(statearr_18217_18243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (6))){
var inst_18176 = (state_18212[(9)]);
var inst_18175 = (state_18212[(2)]);
var inst_18176__$1 = fluree.db.util.async.throw_err(inst_18175);
var inst_18177 = (inst_18176__$1 == null);
var state_18212__$1 = (function (){var statearr_18218 = state_18212;
(statearr_18218[(9)] = inst_18176__$1);

return statearr_18218;
})();
if(cljs.core.truth_(inst_18177)){
var statearr_18219_18244 = state_18212__$1;
(statearr_18219_18244[(1)] = (7));

} else {
var statearr_18220_18245 = state_18212__$1;
(statearr_18220_18245[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (3))){
var inst_18210 = (state_18212[(2)]);
var state_18212__$1 = state_18212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18212__$1,inst_18210);
} else {
if((state_val_18213 === (12))){
var inst_18176 = (state_18212[(9)]);
var inst_18193 = (state_18212[(2)]);
var inst_18194 = cljs.core.__destructure_map(inst_18176);
var inst_18195 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18194,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18196 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18194,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_18197 = config;
var inst_18198 = cljs.core.__destructure_map(inst_18197);
var inst_18199 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18198,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18201 = (function (){var data = inst_18176;
var _ = inst_18193;
var map__18171 = inst_18194;
var children = inst_18195;
var rhs = inst_18196;
var map__18172 = inst_18198;
var comparator = inst_18199;
return (function (idx,p__18200){
var map__18221 = p__18200;
var map__18221__$1 = cljs.core.__destructure_map(map__18221);
var child = map__18221__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18221__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18221__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18221__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18221__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18221__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4221__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (idx === (0));
} else {
return and__4221__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_18202 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_18201,inst_18195);
var inst_18203 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_18202);
var inst_18204 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_18203,inst_18202);
var inst_18205 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_18199,inst_18204);
var inst_18206 = fluree.db.index.__GT_IndexNode(block,t,inst_18196,inst_18205,config,leftmost_QMARK_);
var inst_18207 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18206);
var _ = (function (){var statearr_18222 = state_18212;
(statearr_18222[(4)] = cljs.core.rest((state_18212[(4)])));

return statearr_18222;
})();
var state_18212__$1 = state_18212;
var statearr_18223_18246 = state_18212__$1;
(statearr_18223_18246[(2)] = inst_18207);

(statearr_18223_18246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (2))){
var _ = (function (){var statearr_18224 = state_18212;
(statearr_18224[(4)] = cljs.core.cons((5),(state_18212[(4)])));

return statearr_18224;
})();
var inst_18173 = fluree.db.storage.core.read_branch(conn,key);
var state_18212__$1 = state_18212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18212__$1,(6),inst_18173);
} else {
if((state_val_18213 === (11))){
var state_18212__$1 = state_18212;
var statearr_18226_18247 = state_18212__$1;
(statearr_18226_18247[(2)] = null);

(statearr_18226_18247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (9))){
var inst_18176 = (state_18212[(9)]);
var inst_18187 = (state_18212[(2)]);
var inst_18188 = fluree.db.util.core.exception_QMARK_(inst_18176);
var state_18212__$1 = (function (){var statearr_18227 = state_18212;
(statearr_18227[(10)] = inst_18187);

return statearr_18227;
})();
if(inst_18188){
var statearr_18228_18248 = state_18212__$1;
(statearr_18228_18248[(1)] = (10));

} else {
var statearr_18229_18249 = state_18212__$1;
(statearr_18229_18249[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (5))){
var _ = (function (){var statearr_18230 = state_18212;
(statearr_18230[(4)] = cljs.core.rest((state_18212[(4)])));

return statearr_18230;
})();
var state_18212__$1 = state_18212;
var ex18225 = (state_18212__$1[(2)]);
var statearr_18231_18250 = state_18212__$1;
(statearr_18231_18250[(5)] = ex18225);


var statearr_18232_18251 = state_18212__$1;
(statearr_18232_18251[(1)] = (4));

(statearr_18232_18251[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (10))){
var inst_18176 = (state_18212[(9)]);
var inst_18190 = (function(){throw inst_18176})();
var state_18212__$1 = state_18212;
var statearr_18233_18252 = state_18212__$1;
(statearr_18233_18252[(2)] = inst_18190);

(statearr_18233_18252[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (8))){
var state_18212__$1 = state_18212;
var statearr_18234_18253 = state_18212__$1;
(statearr_18234_18253[(2)] = null);

(statearr_18234_18253[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____0 = (function (){
var statearr_18235 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18235[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__);

(statearr_18235[(1)] = (1));

return statearr_18235;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____1 = (function (state_18212){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18212);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18236){var ex__2736__auto__ = e18236;
var statearr_18237_18254 = state_18212;
(statearr_18237_18254[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18212[(4)]))){
var statearr_18238_18255 = state_18212;
(statearr_18238_18255[(1)] = cljs.core.first((state_18212[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18256 = state_18212;
state_18212 = G__18256;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__ = function(state_18212){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____1.call(this,state_18212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18239 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18239[(6)] = c__2755__auto___18240);

return statearr_18239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18277){
var state_val_18278 = (state_18277[(1)]);
if((state_val_18278 === (7))){
var state_18277__$1 = state_18277;
var statearr_18279_18299 = state_18277__$1;
(statearr_18279_18299[(2)] = null);

(statearr_18279_18299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18278 === (1))){
var state_18277__$1 = state_18277;
var statearr_18280_18300 = state_18277__$1;
(statearr_18280_18300[(2)] = null);

(statearr_18280_18300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18278 === (4))){
var inst_18257 = (state_18277[(2)]);
var state_18277__$1 = state_18277;
var statearr_18281_18301 = state_18277__$1;
(statearr_18281_18301[(2)] = inst_18257);

(statearr_18281_18301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18278 === (6))){
var inst_18263 = (state_18277[(7)]);
var inst_18265 = fluree.db.storage.core.serde(conn);
var state_18277__$1 = (function (){var statearr_18282 = state_18277;
(statearr_18282[(8)] = inst_18265);

return statearr_18282;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18277__$1,(9),inst_18263);
} else {
if((state_val_18278 === (3))){
var inst_18275 = (state_18277[(2)]);
var state_18277__$1 = state_18277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18277__$1,inst_18275);
} else {
if((state_val_18278 === (2))){
var inst_18263 = (state_18277[(7)]);
var _ = (function (){var statearr_18284 = state_18277;
(statearr_18284[(4)] = cljs.core.cons((5),(state_18277[(4)])));

return statearr_18284;
})();
var inst_18263__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_18277__$1 = (function (){var statearr_18285 = state_18277;
(statearr_18285[(7)] = inst_18263__$1);

return statearr_18285;
})();
if(cljs.core.truth_(inst_18263__$1)){
var statearr_18286_18302 = state_18277__$1;
(statearr_18286_18302[(1)] = (6));

} else {
var statearr_18287_18303 = state_18277__$1;
(statearr_18287_18303[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18278 === (9))){
var inst_18265 = (state_18277[(8)]);
var inst_18267 = (state_18277[(2)]);
var inst_18268 = fluree.db.util.async.throw_err(inst_18267);
var inst_18269 = fluree.db.serde.protocol._deserialize_leaf(inst_18265,inst_18268);
var state_18277__$1 = state_18277;
var statearr_18288_18304 = state_18277__$1;
(statearr_18288_18304[(2)] = inst_18269);

(statearr_18288_18304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18278 === (5))){
var _ = (function (){var statearr_18289 = state_18277;
(statearr_18289[(4)] = cljs.core.rest((state_18277[(4)])));

return statearr_18289;
})();
var state_18277__$1 = state_18277;
var ex18283 = (state_18277__$1[(2)]);
var statearr_18290_18305 = state_18277__$1;
(statearr_18290_18305[(5)] = ex18283);


if((ex18283 instanceof Error)){
var statearr_18291_18306 = state_18277__$1;
(statearr_18291_18306[(1)] = (4));

(statearr_18291_18306[(5)] = null);

} else {
throw ex18283;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18278 === (8))){
var inst_18272 = (state_18277[(2)]);
var _ = (function (){var statearr_18292 = state_18277;
(statearr_18292[(4)] = cljs.core.rest((state_18277[(4)])));

return statearr_18292;
})();
var state_18277__$1 = state_18277;
var statearr_18293_18307 = state_18277__$1;
(statearr_18293_18307[(2)] = inst_18272);

(statearr_18293_18307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____0 = (function (){
var statearr_18294 = [null,null,null,null,null,null,null,null,null];
(statearr_18294[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__);

(statearr_18294[(1)] = (1));

return statearr_18294;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____1 = (function (state_18277){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18277);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18295){var ex__2736__auto__ = e18295;
var statearr_18296_18308 = state_18277;
(statearr_18296_18308[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18277[(4)]))){
var statearr_18297_18309 = state_18277;
(statearr_18297_18309[(1)] = cljs.core.first((state_18277[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18310 = state_18277;
state_18277 = G__18310;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__ = function(state_18277){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____1.call(this,state_18277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18298 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18298[(6)] = c__2755__auto__);

return statearr_18298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___18383 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18355){
var state_val_18356 = (state_18355[(1)]);
if((state_val_18356 === (7))){
var inst_18327 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18328 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18329 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18330 = cljs.core.PersistentHashMap.fromArrays(inst_18328,inst_18329);
var inst_18331 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18327,inst_18330);
var inst_18332 = (function(){throw inst_18331})();
var state_18355__$1 = state_18355;
var statearr_18357_18384 = state_18355__$1;
(statearr_18357_18384[(2)] = inst_18332);

(statearr_18357_18384[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18356 === (1))){
var state_18355__$1 = state_18355;
var statearr_18358_18385 = state_18355__$1;
(statearr_18358_18385[(2)] = null);

(statearr_18358_18385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18356 === (4))){
var inst_18311 = (state_18355[(2)]);
var inst_18312 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18313 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18311);
var inst_18314 = cljs.core.async.close_BANG_(return_ch);
var state_18355__$1 = (function (){var statearr_18359 = state_18355;
(statearr_18359[(7)] = inst_18312);

(statearr_18359[(8)] = inst_18313);

return statearr_18359;
})();
var statearr_18360_18386 = state_18355__$1;
(statearr_18360_18386[(2)] = inst_18314);

(statearr_18360_18386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18356 === (6))){
var inst_18324 = (state_18355[(9)]);
var inst_18324__$1 = (state_18355[(2)]);
var inst_18325 = (inst_18324__$1 == null);
var state_18355__$1 = (function (){var statearr_18361 = state_18355;
(statearr_18361[(9)] = inst_18324__$1);

return statearr_18361;
})();
if(cljs.core.truth_(inst_18325)){
var statearr_18362_18387 = state_18355__$1;
(statearr_18362_18387[(1)] = (7));

} else {
var statearr_18363_18388 = state_18355__$1;
(statearr_18363_18388[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18356 === (3))){
var inst_18353 = (state_18355[(2)]);
var state_18355__$1 = state_18355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18355__$1,inst_18353);
} else {
if((state_val_18356 === (12))){
var inst_18324 = (state_18355[(9)]);
var inst_18341 = (state_18355[(2)]);
var inst_18342 = cljs.core.__destructure_map(inst_18324);
var inst_18343 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18342,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18344 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18342,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_18345 = config;
var inst_18346 = cljs.core.__destructure_map(inst_18345);
var inst_18347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18346,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18348 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_18347,inst_18343);
var inst_18349 = fluree.db.index.data_node(block,t,inst_18348,rhs,config);
var inst_18350 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18349);
var _ = (function (){var statearr_18364 = state_18355;
(statearr_18364[(4)] = cljs.core.rest((state_18355[(4)])));

return statearr_18364;
})();
var state_18355__$1 = (function (){var statearr_18365 = state_18355;
(statearr_18365[(10)] = inst_18344);

(statearr_18365[(11)] = inst_18341);

return statearr_18365;
})();
var statearr_18366_18389 = state_18355__$1;
(statearr_18366_18389[(2)] = inst_18350);

(statearr_18366_18389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18356 === (2))){
var _ = (function (){var statearr_18367 = state_18355;
(statearr_18367[(4)] = cljs.core.cons((5),(state_18355[(4)])));

return statearr_18367;
})();
var inst_18322 = fluree.db.storage.core.read_leaf(conn,key);
var state_18355__$1 = state_18355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18355__$1,(6),inst_18322);
} else {
if((state_val_18356 === (11))){
var state_18355__$1 = state_18355;
var statearr_18369_18390 = state_18355__$1;
(statearr_18369_18390[(2)] = null);

(statearr_18369_18390[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18356 === (9))){
var inst_18324 = (state_18355[(9)]);
var inst_18335 = (state_18355[(2)]);
var inst_18336 = fluree.db.util.core.exception_QMARK_(inst_18324);
var state_18355__$1 = (function (){var statearr_18370 = state_18355;
(statearr_18370[(12)] = inst_18335);

return statearr_18370;
})();
if(inst_18336){
var statearr_18371_18391 = state_18355__$1;
(statearr_18371_18391[(1)] = (10));

} else {
var statearr_18372_18392 = state_18355__$1;
(statearr_18372_18392[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18356 === (5))){
var _ = (function (){var statearr_18373 = state_18355;
(statearr_18373[(4)] = cljs.core.rest((state_18355[(4)])));

return statearr_18373;
})();
var state_18355__$1 = state_18355;
var ex18368 = (state_18355__$1[(2)]);
var statearr_18374_18393 = state_18355__$1;
(statearr_18374_18393[(5)] = ex18368);


var statearr_18375_18394 = state_18355__$1;
(statearr_18375_18394[(1)] = (4));

(statearr_18375_18394[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18356 === (10))){
var inst_18324 = (state_18355[(9)]);
var inst_18338 = (function(){throw inst_18324})();
var state_18355__$1 = state_18355;
var statearr_18376_18395 = state_18355__$1;
(statearr_18376_18395[(2)] = inst_18338);

(statearr_18376_18395[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18356 === (8))){
var state_18355__$1 = state_18355;
var statearr_18377_18396 = state_18355__$1;
(statearr_18377_18396[(2)] = null);

(statearr_18377_18396[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____0 = (function (){
var statearr_18378 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18378[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__);

(statearr_18378[(1)] = (1));

return statearr_18378;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____1 = (function (state_18355){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18355);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18379){var ex__2736__auto__ = e18379;
var statearr_18380_18397 = state_18355;
(statearr_18380_18397[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18355[(4)]))){
var statearr_18381_18398 = state_18355;
(statearr_18381_18398[(1)] = cljs.core.first((state_18355[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18399 = state_18355;
state_18355 = G__18399;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__ = function(state_18355){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____1.call(this,state_18355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18382 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18382[(6)] = c__2755__auto___18383);

return statearr_18382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k18401,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__18405 = k18401;
var G__18405__$1 = (((G__18405 instanceof cljs.core.Keyword))?G__18405.fqn:null);
switch (G__18405__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k18401,else__4475__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__18406){
var vec__18407 = p__18406;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18407,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18407,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__18400){
var self__ = this;
var G__18400__$1 = this;
return (new cljs.core.RecordIter((0),G__18400__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__18410 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18411 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__18412 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18413 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18412,G__18413) : object_cache.call(null,G__18412,G__18413));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__18414 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18415 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18414,G__18415) : object_cache.call(null,G__18414,G__18415));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18410,G__18411) : object_cache.call(null,G__18410,G__18411));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__18416 = history_id;
var G__18417 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18416,G__18417) : object_cache.call(null,G__18416,G__18417));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__18418 = (function (coll__4469__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__18418(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this18402,other18403){
var self__ = this;
var this18402__$1 = this;
return (((!((other18403 == null)))) && ((((this18402__$1.constructor === other18403.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.conn,other18403.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.config,other18403.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.network,other18403.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.dbid,other18403.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.id,other18403.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.leaf,other18403.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.first,other18403.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.rhs,other18403.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.size,other18403.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.block,other18403.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.t,other18403.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.tt_id,other18403.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.leftmost_QMARK_,other18403.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.tempid,other18403.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18402__$1.__extmap,other18403.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k18401){
var self__ = this;
var this__4479__auto____$1 = this;
var G__18419 = k18401;
var G__18419__$1 = (((G__18419 instanceof cljs.core.Keyword))?G__18419.fqn:null);
switch (G__18419__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k18401);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__18400){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__18420 = cljs.core.keyword_identical_QMARK_;
var expr__18421 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__18423 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__18424 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18423,G__18424) : pred__18420.call(null,G__18423,G__18424));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__18400,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18425 = new cljs.core.Keyword(null,"config","config",994861415);
var G__18426 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18425,G__18426) : pred__18420.call(null,G__18425,G__18426));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__18400,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18427 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__18428 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18427,G__18428) : pred__18420.call(null,G__18427,G__18428));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__18400,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18429 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__18430 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18429,G__18430) : pred__18420.call(null,G__18429,G__18430));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__18400,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18431 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__18432 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18431,G__18432) : pred__18420.call(null,G__18431,G__18432));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__18400,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18433 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__18434 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18433,G__18434) : pred__18420.call(null,G__18433,G__18434));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__18400,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18435 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__18436 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18435,G__18436) : pred__18420.call(null,G__18435,G__18436));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__18400,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18437 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__18438 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18437,G__18438) : pred__18420.call(null,G__18437,G__18438));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__18400,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18439 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__18440 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18439,G__18440) : pred__18420.call(null,G__18439,G__18440));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__18400,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18441 = new cljs.core.Keyword(null,"block","block",664686210);
var G__18442 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18441,G__18442) : pred__18420.call(null,G__18441,G__18442));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__18400,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18443 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__18444 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18443,G__18444) : pred__18420.call(null,G__18443,G__18444));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__18400,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18445 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__18446 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18445,G__18446) : pred__18420.call(null,G__18445,G__18446));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__18400,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18447 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__18448 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18447,G__18448) : pred__18420.call(null,G__18447,G__18448));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__18400,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18449 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__18450 = expr__18421;
return (pred__18420.cljs$core$IFn$_invoke$arity$2 ? pred__18420.cljs$core$IFn$_invoke$arity$2(G__18449,G__18450) : pred__18420.call(null,G__18449,G__18450));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__18400,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__18400),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__18400){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__18400,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__18404){
var extmap__4512__auto__ = (function (){var G__18451 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__18404,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__18404)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__18451);
} else {
return G__18451;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__18404),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__18404),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__18454 = blank_db;
var map__18454__$1 = cljs.core.__destructure_map(map__18454);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18454__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18454__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18454__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__18455 = root_data;
var map__18455__$1 = cljs.core.__destructure_map(map__18455);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18455__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18455__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18455__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18455__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18477){
var state_val_18478 = (state_18477[(1)]);
if((state_val_18478 === (7))){
var state_18477__$1 = state_18477;
var statearr_18479_18499 = state_18477__$1;
(statearr_18479_18499[(2)] = null);

(statearr_18479_18499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18478 === (1))){
var state_18477__$1 = state_18477;
var statearr_18480_18500 = state_18477__$1;
(statearr_18480_18500[(2)] = null);

(statearr_18480_18500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18478 === (4))){
var inst_18456 = (state_18477[(2)]);
var state_18477__$1 = state_18477;
var statearr_18481_18501 = state_18477__$1;
(statearr_18481_18501[(2)] = inst_18456);

(statearr_18481_18501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18478 === (6))){
var inst_18463 = (state_18477[(7)]);
var inst_18465 = fluree.db.storage.core.serde(conn);
var state_18477__$1 = (function (){var statearr_18482 = state_18477;
(statearr_18482[(8)] = inst_18465);

return statearr_18482;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18477__$1,(9),inst_18463);
} else {
if((state_val_18478 === (3))){
var inst_18475 = (state_18477[(2)]);
var state_18477__$1 = state_18477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18477__$1,inst_18475);
} else {
if((state_val_18478 === (2))){
var inst_18463 = (state_18477[(7)]);
var _ = (function (){var statearr_18484 = state_18477;
(statearr_18484[(4)] = cljs.core.cons((5),(state_18477[(4)])));

return statearr_18484;
})();
var inst_18462 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_18463__$1 = fluree.db.storage.core.storage_read(conn,inst_18462);
var state_18477__$1 = (function (){var statearr_18485 = state_18477;
(statearr_18485[(7)] = inst_18463__$1);

return statearr_18485;
})();
if(cljs.core.truth_(inst_18463__$1)){
var statearr_18486_18502 = state_18477__$1;
(statearr_18486_18502[(1)] = (6));

} else {
var statearr_18487_18503 = state_18477__$1;
(statearr_18487_18503[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18478 === (9))){
var inst_18465 = (state_18477[(8)]);
var inst_18467 = (state_18477[(2)]);
var inst_18468 = fluree.db.util.async.throw_err(inst_18467);
var inst_18469 = fluree.db.serde.protocol._deserialize_garbage(inst_18465,inst_18468);
var state_18477__$1 = state_18477;
var statearr_18488_18504 = state_18477__$1;
(statearr_18488_18504[(2)] = inst_18469);

(statearr_18488_18504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18478 === (5))){
var _ = (function (){var statearr_18489 = state_18477;
(statearr_18489[(4)] = cljs.core.rest((state_18477[(4)])));

return statearr_18489;
})();
var state_18477__$1 = state_18477;
var ex18483 = (state_18477__$1[(2)]);
var statearr_18490_18505 = state_18477__$1;
(statearr_18490_18505[(5)] = ex18483);


if((ex18483 instanceof Error)){
var statearr_18491_18506 = state_18477__$1;
(statearr_18491_18506[(1)] = (4));

(statearr_18491_18506[(5)] = null);

} else {
throw ex18483;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18478 === (8))){
var inst_18472 = (state_18477[(2)]);
var _ = (function (){var statearr_18492 = state_18477;
(statearr_18492[(4)] = cljs.core.rest((state_18477[(4)])));

return statearr_18492;
})();
var state_18477__$1 = state_18477;
var statearr_18493_18507 = state_18477__$1;
(statearr_18493_18507[(2)] = inst_18472);

(statearr_18493_18507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____0 = (function (){
var statearr_18494 = [null,null,null,null,null,null,null,null,null];
(statearr_18494[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__);

(statearr_18494[(1)] = (1));

return statearr_18494;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____1 = (function (state_18477){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18477);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18495){var ex__2736__auto__ = e18495;
var statearr_18496_18508 = state_18477;
(statearr_18496_18508[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18477[(4)]))){
var statearr_18497_18509 = state_18477;
(statearr_18497_18509[(1)] = cljs.core.first((state_18477[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18510 = state_18477;
state_18477 = G__18510;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__ = function(state_18477){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____1.call(this,state_18477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18498 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18498[(6)] = c__2755__auto__);

return statearr_18498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18532){
var state_val_18533 = (state_18532[(1)]);
if((state_val_18533 === (7))){
var inst_18521 = (state_18532[(7)]);
var inst_18523 = fluree.db.storage.core.serde(conn);
var inst_18524 = fluree.db.serde.protocol._deserialize_db_root(inst_18523,inst_18521);
var state_18532__$1 = state_18532;
var statearr_18534_18553 = state_18532__$1;
(statearr_18534_18553[(2)] = inst_18524);

(statearr_18534_18553[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18533 === (1))){
var state_18532__$1 = state_18532;
var statearr_18535_18554 = state_18532__$1;
(statearr_18535_18554[(2)] = null);

(statearr_18535_18554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18533 === (4))){
var inst_18511 = (state_18532[(2)]);
var state_18532__$1 = state_18532;
var statearr_18536_18555 = state_18532__$1;
(statearr_18536_18555[(2)] = inst_18511);

(statearr_18536_18555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18533 === (6))){
var inst_18521 = (state_18532[(7)]);
var inst_18520 = (state_18532[(2)]);
var inst_18521__$1 = fluree.db.util.async.throw_err(inst_18520);
var state_18532__$1 = (function (){var statearr_18537 = state_18532;
(statearr_18537[(7)] = inst_18521__$1);

return statearr_18537;
})();
if(cljs.core.truth_(inst_18521__$1)){
var statearr_18538_18556 = state_18532__$1;
(statearr_18538_18556[(1)] = (7));

} else {
var statearr_18539_18557 = state_18532__$1;
(statearr_18539_18557[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18533 === (3))){
var inst_18530 = (state_18532[(2)]);
var state_18532__$1 = state_18532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18532__$1,inst_18530);
} else {
if((state_val_18533 === (2))){
var _ = (function (){var statearr_18541 = state_18532;
(statearr_18541[(4)] = cljs.core.cons((5),(state_18532[(4)])));

return statearr_18541;
})();
var inst_18517 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_18518 = fluree.db.storage.core.storage_read(conn,inst_18517);
var state_18532__$1 = state_18532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18532__$1,(6),inst_18518);
} else {
if((state_val_18533 === (9))){
var inst_18527 = (state_18532[(2)]);
var _ = (function (){var statearr_18542 = state_18532;
(statearr_18542[(4)] = cljs.core.rest((state_18532[(4)])));

return statearr_18542;
})();
var state_18532__$1 = state_18532;
var statearr_18543_18558 = state_18532__$1;
(statearr_18543_18558[(2)] = inst_18527);

(statearr_18543_18558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18533 === (5))){
var _ = (function (){var statearr_18544 = state_18532;
(statearr_18544[(4)] = cljs.core.rest((state_18532[(4)])));

return statearr_18544;
})();
var state_18532__$1 = state_18532;
var ex18540 = (state_18532__$1[(2)]);
var statearr_18545_18559 = state_18532__$1;
(statearr_18545_18559[(5)] = ex18540);


if((ex18540 instanceof Error)){
var statearr_18546_18560 = state_18532__$1;
(statearr_18546_18560[(1)] = (4));

(statearr_18546_18560[(5)] = null);

} else {
throw ex18540;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18533 === (8))){
var state_18532__$1 = state_18532;
var statearr_18547_18561 = state_18532__$1;
(statearr_18547_18561[(2)] = null);

(statearr_18547_18561[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____0 = (function (){
var statearr_18548 = [null,null,null,null,null,null,null,null];
(statearr_18548[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__);

(statearr_18548[(1)] = (1));

return statearr_18548;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____1 = (function (state_18532){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18532);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18549){var ex__2736__auto__ = e18549;
var statearr_18550_18562 = state_18532;
(statearr_18550_18562[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18532[(4)]))){
var statearr_18551_18563 = state_18532;
(statearr_18551_18563[(1)] = cljs.core.first((state_18532[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18564 = state_18532;
state_18532 = G__18564;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__ = function(state_18532){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____1.call(this,state_18532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18552 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18552[(6)] = c__2755__auto__);

return statearr_18552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18600){
var state_val_18601 = (state_18600[(1)]);
if((state_val_18601 === (7))){
var inst_18574 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_18575 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18576 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_18577 = cljs.core.PersistentHashMap.fromArrays(inst_18575,inst_18576);
var inst_18578 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18574,inst_18577);
var inst_18579 = (function(){throw inst_18578})();
var state_18600__$1 = state_18600;
var statearr_18602_18624 = state_18600__$1;
(statearr_18602_18624[(2)] = inst_18579);

(statearr_18602_18624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (1))){
var state_18600__$1 = state_18600;
var statearr_18603_18625 = state_18600__$1;
(statearr_18603_18625[(2)] = null);

(statearr_18603_18625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (4))){
var inst_18565 = (state_18600[(2)]);
var state_18600__$1 = state_18600;
var statearr_18604_18626 = state_18600__$1;
(statearr_18604_18626[(2)] = inst_18565);

(statearr_18604_18626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (6))){
var state_18600__$1 = state_18600;
var statearr_18605_18627 = state_18600__$1;
(statearr_18605_18627[(2)] = null);

(statearr_18605_18627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (3))){
var inst_18598 = (state_18600[(2)]);
var state_18600__$1 = state_18600;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18600__$1,inst_18598);
} else {
if((state_val_18601 === (2))){
var inst_18571 = (state_18600[(7)]);
var _ = (function (){var statearr_18606 = state_18600;
(statearr_18606[(4)] = cljs.core.cons((5),(state_18600[(4)])));

return statearr_18606;
})();
var inst_18571__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_18600__$1 = (function (){var statearr_18607 = state_18600;
(statearr_18607[(7)] = inst_18571__$1);

return statearr_18607;
})();
if(cljs.core.truth_(inst_18571__$1)){
var statearr_18608_18628 = state_18600__$1;
(statearr_18608_18628[(1)] = (6));

} else {
var statearr_18609_18629 = state_18600__$1;
(statearr_18609_18629[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (11))){
var inst_18590 = (state_18600[(8)]);
var inst_18593 = (state_18600[(2)]);
var inst_18594 = fluree.db.util.async.throw_err(inst_18593);
var inst_18595 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18590,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_18594);
var _ = (function (){var statearr_18611 = state_18600;
(statearr_18611[(4)] = cljs.core.rest((state_18600[(4)])));

return statearr_18611;
})();
var state_18600__$1 = state_18600;
var statearr_18612_18630 = state_18600__$1;
(statearr_18612_18630[(2)] = inst_18595);

(statearr_18612_18630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (9))){
var inst_18585 = (state_18600[(9)]);
var inst_18583 = (state_18600[(2)]);
var inst_18584 = fluree.db.util.async.throw_err(inst_18583);
var inst_18585__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_18584);
var inst_18586 = fluree.db.query.schema.schema_map(inst_18585__$1);
var state_18600__$1 = (function (){var statearr_18613 = state_18600;
(statearr_18613[(9)] = inst_18585__$1);

return statearr_18613;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18600__$1,(10),inst_18586);
} else {
if((state_val_18601 === (5))){
var _ = (function (){var statearr_18614 = state_18600;
(statearr_18614[(4)] = cljs.core.rest((state_18600[(4)])));

return statearr_18614;
})();
var state_18600__$1 = state_18600;
var ex18610 = (state_18600__$1[(2)]);
var statearr_18615_18631 = state_18600__$1;
(statearr_18615_18631[(5)] = ex18610);


if((ex18610 instanceof Error)){
var statearr_18616_18632 = state_18600__$1;
(statearr_18616_18632[(1)] = (4));

(statearr_18616_18632[(5)] = null);

} else {
throw ex18610;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (10))){
var inst_18585 = (state_18600[(9)]);
var inst_18590 = (state_18600[(8)]);
var inst_18588 = (state_18600[(2)]);
var inst_18589 = fluree.db.util.async.throw_err(inst_18588);
var inst_18590__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18585,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_18589);
var inst_18591 = fluree.db.query.schema.setting_map(inst_18590__$1);
var state_18600__$1 = (function (){var statearr_18617 = state_18600;
(statearr_18617[(8)] = inst_18590__$1);

return statearr_18617;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18600__$1,(11),inst_18591);
} else {
if((state_val_18601 === (8))){
var inst_18571 = (state_18600[(7)]);
var inst_18581 = (state_18600[(2)]);
var state_18600__$1 = (function (){var statearr_18618 = state_18600;
(statearr_18618[(10)] = inst_18581);

return statearr_18618;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18600__$1,(9),inst_18571);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2733__auto____0 = (function (){
var statearr_18619 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18619[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2733__auto__);

(statearr_18619[(1)] = (1));

return statearr_18619;
});
var fluree$db$storage$core$reify_db_$_state_machine__2733__auto____1 = (function (state_18600){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18600);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18620){var ex__2736__auto__ = e18620;
var statearr_18621_18633 = state_18600;
(statearr_18621_18633[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18600[(4)]))){
var statearr_18622_18634 = state_18600;
(statearr_18622_18634[(1)] = cljs.core.first((state_18600[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18635 = state_18600;
state_18600 = G__18635;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2733__auto__ = function(state_18600){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2733__auto____1.call(this,state_18600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2733__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2733__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18623 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18623[(6)] = c__2755__auto__);

return statearr_18623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__18637 = arguments.length;
switch (G__18637) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18690){
var state_val_18691 = (state_18690[(1)]);
if((state_val_18691 === (7))){
var inst_18647 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_18648 = (new Error(inst_18647));
var inst_18649 = (function(){throw inst_18648})();
var state_18690__$1 = state_18690;
var statearr_18692_18732 = state_18690__$1;
(statearr_18692_18732[(2)] = inst_18649);

(statearr_18692_18732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (20))){
var inst_18681 = (state_18690[(2)]);
var state_18690__$1 = state_18690;
var statearr_18693_18733 = state_18690__$1;
(statearr_18693_18733[(2)] = inst_18681);

(statearr_18693_18733[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (1))){
var state_18690__$1 = state_18690;
var statearr_18694_18734 = state_18690__$1;
(statearr_18694_18734[(2)] = null);

(statearr_18694_18734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (4))){
var inst_18638 = (state_18690[(2)]);
var state_18690__$1 = state_18690;
var statearr_18695_18735 = state_18690__$1;
(statearr_18695_18735[(2)] = inst_18638);

(statearr_18695_18735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (15))){
var inst_18656 = (state_18690[(7)]);
var state_18690__$1 = state_18690;
var statearr_18696_18736 = state_18690__$1;
(statearr_18696_18736[(2)] = inst_18656);

(statearr_18696_18736[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (21))){
var inst_18655 = (state_18690[(8)]);
var inst_18660 = (state_18690[(9)]);
var inst_18656 = (state_18690[(7)]);
var inst_18674 = (inst_18655 + (1));
var inst_18675 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18656,inst_18660);
var inst_18655__$1 = inst_18674;
var inst_18656__$1 = inst_18675;
var state_18690__$1 = (function (){var statearr_18697 = state_18690;
(statearr_18697[(8)] = inst_18655__$1);

(statearr_18697[(7)] = inst_18656__$1);

return statearr_18697;
})();
var statearr_18698_18737 = state_18690__$1;
(statearr_18698_18737[(2)] = null);

(statearr_18698_18737[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (13))){
var inst_18660 = (state_18690[(9)]);
var inst_18664 = (inst_18660 instanceof Error);
var state_18690__$1 = state_18690;
var statearr_18699_18738 = state_18690__$1;
(statearr_18699_18738[(2)] = inst_18664);

(statearr_18699_18738[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (22))){
var state_18690__$1 = state_18690;
var statearr_18700_18739 = state_18690__$1;
(statearr_18700_18739[(2)] = null);

(statearr_18700_18739[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (6))){
var state_18690__$1 = state_18690;
var statearr_18701_18740 = state_18690__$1;
(statearr_18701_18740[(2)] = null);

(statearr_18701_18740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (17))){
var inst_18683 = (state_18690[(2)]);
var state_18690__$1 = state_18690;
var statearr_18702_18741 = state_18690__$1;
(statearr_18702_18741[(2)] = inst_18683);

(statearr_18702_18741[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (3))){
var inst_18688 = (state_18690[(2)]);
var state_18690__$1 = state_18690;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18690__$1,inst_18688);
} else {
if((state_val_18691 === (12))){
var inst_18661 = (state_18690[(10)]);
var state_18690__$1 = state_18690;
var statearr_18703_18742 = state_18690__$1;
(statearr_18703_18742[(2)] = inst_18661);

(statearr_18703_18742[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (2))){
var _ = (function (){var statearr_18704 = state_18690;
(statearr_18704[(4)] = cljs.core.cons((5),(state_18690[(4)])));

return statearr_18704;
})();
var inst_18644 = (end >= start);
var state_18690__$1 = state_18690;
if(cljs.core.truth_(inst_18644)){
var statearr_18705_18743 = state_18690__$1;
(statearr_18705_18743[(1)] = (6));

} else {
var statearr_18706_18744 = state_18690__$1;
(statearr_18706_18744[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (23))){
var inst_18679 = (state_18690[(2)]);
var state_18690__$1 = state_18690;
var statearr_18707_18745 = state_18690__$1;
(statearr_18707_18745[(2)] = inst_18679);

(statearr_18707_18745[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (19))){
var state_18690__$1 = state_18690;
var statearr_18708_18746 = state_18690__$1;
(statearr_18708_18746[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (11))){
var inst_18660 = (state_18690[(9)]);
var inst_18661 = (state_18690[(10)]);
var inst_18660__$1 = (state_18690[(2)]);
var inst_18661__$1 = (inst_18660__$1 == null);
var state_18690__$1 = (function (){var statearr_18711 = state_18690;
(statearr_18711[(9)] = inst_18660__$1);

(statearr_18711[(10)] = inst_18661__$1);

return statearr_18711;
})();
if(cljs.core.truth_(inst_18661__$1)){
var statearr_18712_18747 = state_18690__$1;
(statearr_18712_18747[(1)] = (12));

} else {
var statearr_18713_18748 = state_18690__$1;
(statearr_18713_18748[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (9))){
var inst_18655 = (state_18690[(8)]);
var inst_18658 = fluree.db.storage.core.read_block(conn,network,dbid,inst_18655);
var state_18690__$1 = state_18690;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18690__$1,(11),inst_18658);
} else {
if((state_val_18691 === (5))){
var _ = (function (){var statearr_18714 = state_18690;
(statearr_18714[(4)] = cljs.core.rest((state_18690[(4)])));

return statearr_18714;
})();
var state_18690__$1 = state_18690;
var ex18710 = (state_18690__$1[(2)]);
var statearr_18715_18749 = state_18690__$1;
(statearr_18715_18749[(5)] = ex18710);


if((ex18710 instanceof Error)){
var statearr_18716_18750 = state_18690__$1;
(statearr_18716_18750[(1)] = (4));

(statearr_18716_18750[(5)] = null);

} else {
throw ex18710;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (14))){
var inst_18666 = (state_18690[(2)]);
var state_18690__$1 = state_18690;
if(cljs.core.truth_(inst_18666)){
var statearr_18717_18751 = state_18690__$1;
(statearr_18717_18751[(1)] = (15));

} else {
var statearr_18718_18752 = state_18690__$1;
(statearr_18718_18752[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (16))){
var inst_18655 = (state_18690[(8)]);
var inst_18669 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18655,end);
var state_18690__$1 = state_18690;
if(inst_18669){
var statearr_18719_18753 = state_18690__$1;
(statearr_18719_18753[(1)] = (18));

} else {
var statearr_18720_18754 = state_18690__$1;
(statearr_18720_18754[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (10))){
var inst_18685 = (state_18690[(2)]);
var _ = (function (){var statearr_18721 = state_18690;
(statearr_18721[(4)] = cljs.core.rest((state_18690[(4)])));

return statearr_18721;
})();
var state_18690__$1 = state_18690;
var statearr_18722_18755 = state_18690__$1;
(statearr_18722_18755[(2)] = inst_18685);

(statearr_18722_18755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (18))){
var inst_18660 = (state_18690[(9)]);
var inst_18656 = (state_18690[(7)]);
var inst_18671 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18656,inst_18660);
var state_18690__$1 = state_18690;
var statearr_18723_18756 = state_18690__$1;
(statearr_18723_18756[(2)] = inst_18671);

(statearr_18723_18756[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18691 === (8))){
var inst_18651 = (state_18690[(2)]);
var inst_18652 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18653 = start;
var inst_18654 = cljs.core.PersistentVector.EMPTY;
var inst_18655 = inst_18653;
var inst_18656 = inst_18654;
var state_18690__$1 = (function (){var statearr_18724 = state_18690;
(statearr_18724[(11)] = inst_18652);

(statearr_18724[(8)] = inst_18655);

(statearr_18724[(12)] = inst_18651);

(statearr_18724[(7)] = inst_18656);

return statearr_18724;
})();
var statearr_18725_18757 = state_18690__$1;
(statearr_18725_18757[(2)] = null);

(statearr_18725_18757[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2733__auto__ = null;
var fluree$db$storage$core$state_machine__2733__auto____0 = (function (){
var statearr_18726 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18726[(0)] = fluree$db$storage$core$state_machine__2733__auto__);

(statearr_18726[(1)] = (1));

return statearr_18726;
});
var fluree$db$storage$core$state_machine__2733__auto____1 = (function (state_18690){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18690);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18727){var ex__2736__auto__ = e18727;
var statearr_18728_18758 = state_18690;
(statearr_18728_18758[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18690[(4)]))){
var statearr_18729_18759 = state_18690;
(statearr_18729_18759[(1)] = cljs.core.first((state_18690[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18760 = state_18690;
state_18690 = G__18760;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2733__auto__ = function(state_18690){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2733__auto____1.call(this,state_18690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2733__auto____0;
fluree$db$storage$core$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2733__auto____1;
return fluree$db$storage$core$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18730 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18730[(6)] = c__2755__auto__);

return statearr_18730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18776){
var state_val_18777 = (state_18776[(1)]);
if((state_val_18777 === (1))){
var state_18776__$1 = state_18776;
var statearr_18778_18792 = state_18776__$1;
(statearr_18778_18792[(2)] = null);

(statearr_18778_18792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18777 === (2))){
var _ = (function (){var statearr_18779 = state_18776;
(statearr_18779[(4)] = cljs.core.cons((5),(state_18776[(4)])));

return statearr_18779;
})();
var inst_18767 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_18776__$1 = state_18776;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18776__$1,(6),inst_18767);
} else {
if((state_val_18777 === (3))){
var inst_18774 = (state_18776[(2)]);
var state_18776__$1 = state_18776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18776__$1,inst_18774);
} else {
if((state_val_18777 === (4))){
var inst_18761 = (state_18776[(2)]);
var state_18776__$1 = state_18776;
var statearr_18781_18793 = state_18776__$1;
(statearr_18781_18793[(2)] = inst_18761);

(statearr_18781_18793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18777 === (5))){
var _ = (function (){var statearr_18782 = state_18776;
(statearr_18782[(4)] = cljs.core.rest((state_18776[(4)])));

return statearr_18782;
})();
var state_18776__$1 = state_18776;
var ex18780 = (state_18776__$1[(2)]);
var statearr_18783_18794 = state_18776__$1;
(statearr_18783_18794[(5)] = ex18780);


if((ex18780 instanceof Error)){
var statearr_18784_18795 = state_18776__$1;
(statearr_18784_18795[(1)] = (4));

(statearr_18784_18795[(5)] = null);

} else {
throw ex18780;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18777 === (6))){
var inst_18769 = (state_18776[(2)]);
var inst_18770 = fluree.db.util.async.throw_err(inst_18769);
var inst_18771 = cljs.core.first(inst_18770);
var _ = (function (){var statearr_18785 = state_18776;
(statearr_18785[(4)] = cljs.core.rest((state_18776[(4)])));

return statearr_18785;
})();
var state_18776__$1 = state_18776;
var statearr_18786_18796 = state_18776__$1;
(statearr_18786_18796[(2)] = inst_18771);

(statearr_18786_18796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2733__auto____0 = (function (){
var statearr_18787 = [null,null,null,null,null,null,null];
(statearr_18787[(0)] = fluree$db$storage$core$block_$_state_machine__2733__auto__);

(statearr_18787[(1)] = (1));

return statearr_18787;
});
var fluree$db$storage$core$block_$_state_machine__2733__auto____1 = (function (state_18776){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18776);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18788){var ex__2736__auto__ = e18788;
var statearr_18789_18797 = state_18776;
(statearr_18789_18797[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18776[(4)]))){
var statearr_18790_18798 = state_18776;
(statearr_18790_18798[(1)] = cljs.core.first((state_18776[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18799 = state_18776;
state_18776 = G__18799;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2733__auto__ = function(state_18776){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2733__auto____1.call(this,state_18776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2733__auto____0;
fluree$db$storage$core$block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2733__auto____1;
return fluree$db$storage$core$block_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18791 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18791[(6)] = c__2755__auto__);

return statearr_18791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
