// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k27718,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__27722 = k27718;
var G__27722__$1 = (((G__27722 instanceof cljs.core.Keyword))?G__27722.fqn:null);
switch (G__27722__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27718,else__4475__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__27723){
var vec__27724 = p__27723;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27724,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27724,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27717){
var self__ = this;
var G__27717__$1 = this;
return (new cljs.core.RecordIter((0),G__27717__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__27727 = (function (coll__4469__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__27727(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27719,other27720){
var self__ = this;
var this27719__$1 = this;
return (((!((other27720 == null)))) && ((((this27719__$1.constructor === other27720.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.conn,other27720.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.network,other27720.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.dbid,other27720.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.db_name,other27720.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.update_chan,other27720.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.transact_chan,other27720.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.state,other27720.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.schema_cache,other27720.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.blank_db,other27720.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.close,other27720.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.id,other27720.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27719__$1.__extmap,other27720.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k27718){
var self__ = this;
var this__4479__auto____$1 = this;
var G__27728 = k27718;
var G__27728__$1 = (((G__27728 instanceof cljs.core.Keyword))?G__27728.fqn:null);
switch (G__27728__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27718);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__27717){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__27729 = cljs.core.keyword_identical_QMARK_;
var expr__27730 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__27732 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27733 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27732,G__27733) : pred__27729.call(null,G__27732,G__27733));
})())){
return (new fluree.db.session.DbSession(G__27717,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27734 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27735 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27734,G__27735) : pred__27729.call(null,G__27734,G__27735));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27717,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27736 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27737 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27736,G__27737) : pred__27729.call(null,G__27736,G__27737));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27717,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27738 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__27739 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27738,G__27739) : pred__27729.call(null,G__27738,G__27739));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27717,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27740 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__27741 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27740,G__27741) : pred__27729.call(null,G__27740,G__27741));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27717,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27742 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__27743 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27742,G__27743) : pred__27729.call(null,G__27742,G__27743));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27717,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27744 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__27745 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27744,G__27745) : pred__27729.call(null,G__27744,G__27745));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27717,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27746 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27747 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27746,G__27747) : pred__27729.call(null,G__27746,G__27747));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27717,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27748 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__27749 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27748,G__27749) : pred__27729.call(null,G__27748,G__27749));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27717,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27750 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__27751 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27750,G__27751) : pred__27729.call(null,G__27750,G__27751));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27717,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27752 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__27753 = expr__27730;
return (pred__27729.cljs$core$IFn$_invoke$arity$2 ? pred__27729.cljs$core$IFn$_invoke$arity$2(G__27752,G__27753) : pred__27729.call(null,G__27752,G__27753));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27717,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__27717),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__27717){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27717,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27721){
var extmap__4512__auto__ = (function (){var G__27754 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27721,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27721)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27754);
} else {
return G__27754;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27721),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27721),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27757 = session;
var map__27757__$1 = cljs.core.__destructure_map(map__27757);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27757__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27757__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___27909 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27861){
var state_val_27862 = (state_27861[(1)]);
if((state_val_27862 === (7))){
var inst_27778 = (state_27861[(7)]);
var inst_27783 = cljs.core.empty_QMARK_(inst_27778);
var state_27861__$1 = state_27861;
if(inst_27783){
var statearr_27863_27910 = state_27861__$1;
(statearr_27863_27910[(1)] = (10));

} else {
var statearr_27864_27911 = state_27861__$1;
(statearr_27864_27911[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (20))){
var inst_27770 = (state_27861[(8)]);
var inst_27771 = (state_27861[(9)]);
var inst_27769 = (state_27861[(10)]);
var inst_27809 = (state_27861[(11)]);
var inst_27814 = fluree.db.storage.core.read_block(inst_27769,inst_27770,inst_27771,inst_27809);
var state_27861__$1 = state_27861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27861__$1,(22),inst_27814);
} else {
if((state_val_27862 === (27))){
var inst_27850 = (state_27861[(12)]);
var inst_27845 = (state_27861[(13)]);
var inst_27848 = (state_27861[(2)]);
var inst_27849 = fluree.db.util.async.throw_err(inst_27848);
var inst_27850__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27845,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27849);
var inst_27851 = fluree.db.query.schema.setting_map(inst_27850__$1);
var state_27861__$1 = (function (){var statearr_27865 = state_27861;
(statearr_27865[(12)] = inst_27850__$1);

return statearr_27865;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27861__$1,(28),inst_27851);
} else {
if((state_val_27862 === (1))){
var state_27861__$1 = state_27861;
var statearr_27866_27912 = state_27861__$1;
(statearr_27866_27912[(2)] = null);

(statearr_27866_27912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (24))){
var inst_27770 = (state_27861[(8)]);
var inst_27771 = (state_27861[(9)]);
var inst_27809 = (state_27861[(11)]);
var inst_27831 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27809)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27770),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27771),"."].join('');
var inst_27832 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27833 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27834 = cljs.core.PersistentHashMap.fromArrays(inst_27832,inst_27833);
var inst_27835 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27831,inst_27834);
var inst_27836 = (function(){throw inst_27835})();
var state_27861__$1 = state_27861;
var statearr_27867_27913 = state_27861__$1;
(statearr_27867_27913[(2)] = inst_27836);

(statearr_27867_27913[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (4))){
var inst_27758 = (state_27861[(2)]);
var inst_27759 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27758);
var state_27861__$1 = state_27861;
var statearr_27868_27914 = state_27861__$1;
(statearr_27868_27914[(2)] = inst_27759);

(statearr_27868_27914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (15))){
var state_27861__$1 = state_27861;
var statearr_27869_27915 = state_27861__$1;
(statearr_27869_27915[(2)] = null);

(statearr_27869_27915[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (21))){
var inst_27840 = (state_27861[(2)]);
var state_27861__$1 = state_27861;
var statearr_27870_27916 = state_27861__$1;
(statearr_27870_27916[(2)] = inst_27840);

(statearr_27870_27916[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (13))){
var inst_27778 = (state_27861[(7)]);
var inst_27803 = (state_27861[(14)]);
var inst_27802 = (state_27861[(2)]);
var inst_27803__$1 = fluree.db.util.async.throw_err(inst_27802);
var inst_27804 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27778);
var state_27861__$1 = (function (){var statearr_27871 = state_27861;
(statearr_27871[(15)] = inst_27804);

(statearr_27871[(14)] = inst_27803__$1);

return statearr_27871;
})();
if(cljs.core.truth_(inst_27803__$1)){
var statearr_27872_27917 = state_27861__$1;
(statearr_27872_27917[(1)] = (14));

} else {
var statearr_27873_27918 = state_27861__$1;
(statearr_27873_27918[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (22))){
var inst_27817 = (state_27861[(16)]);
var inst_27816 = (state_27861[(2)]);
var inst_27817__$1 = fluree.db.util.async.throw_err(inst_27816);
var state_27861__$1 = (function (){var statearr_27874 = state_27861;
(statearr_27874[(16)] = inst_27817__$1);

return statearr_27874;
})();
if(cljs.core.truth_(inst_27817__$1)){
var statearr_27875_27919 = state_27861__$1;
(statearr_27875_27919[(1)] = (23));

} else {
var statearr_27876_27920 = state_27861__$1;
(statearr_27876_27920[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (6))){
var inst_27778 = (state_27861[(7)]);
var inst_27777 = (state_27861[(2)]);
var inst_27778__$1 = fluree.db.util.async.throw_err(inst_27777);
var inst_27779 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27778__$1);
var inst_27780 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_27779);
var inst_27781 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27780);
var state_27861__$1 = (function (){var statearr_27877 = state_27861;
(statearr_27877[(7)] = inst_27778__$1);

return statearr_27877;
})();
if(inst_27781){
var statearr_27878_27921 = state_27861__$1;
(statearr_27878_27921[(1)] = (7));

} else {
var statearr_27879_27922 = state_27861__$1;
(statearr_27879_27922[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (28))){
var inst_27850 = (state_27861[(12)]);
var inst_27853 = (state_27861[(2)]);
var inst_27854 = fluree.db.util.async.throw_err(inst_27853);
var inst_27855 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27850,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27854);
var inst_27856 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27855);
var _ = (function (){var statearr_27880 = state_27861;
(statearr_27880[(4)] = cljs.core.rest((state_27861[(4)])));

return statearr_27880;
})();
var state_27861__$1 = state_27861;
var statearr_27881_27923 = state_27861__$1;
(statearr_27881_27923[(2)] = inst_27856);

(statearr_27881_27923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (25))){
var inst_27838 = (state_27861[(2)]);
var state_27861__$1 = state_27861;
var statearr_27882_27924 = state_27861__$1;
(statearr_27882_27924[(2)] = inst_27838);

(statearr_27882_27924[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (17))){
var inst_27804 = (state_27861[(15)]);
var inst_27809 = (state_27861[(11)]);
var inst_27811 = (inst_27809 > inst_27804);
var state_27861__$1 = state_27861;
if(cljs.core.truth_(inst_27811)){
var statearr_27883_27925 = state_27861__$1;
(statearr_27883_27925[(1)] = (19));

} else {
var statearr_27884_27926 = state_27861__$1;
(statearr_27884_27926[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (3))){
var inst_27859 = (state_27861[(2)]);
var state_27861__$1 = state_27861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27861__$1,inst_27859);
} else {
if((state_val_27862 === (12))){
var inst_27790 = (state_27861[(2)]);
var inst_27791 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27792 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27793 = cljs.core.PersistentHashMap.fromArrays(inst_27791,inst_27792);
var inst_27794 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27790,inst_27793);
var inst_27795 = (function(){throw inst_27794})();
var state_27861__$1 = state_27861;
var statearr_27885_27927 = state_27861__$1;
(statearr_27885_27927[(2)] = inst_27795);

(statearr_27885_27927[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (2))){
var inst_27770 = (state_27861[(8)]);
var inst_27771 = (state_27861[(9)]);
var inst_27769 = (state_27861[(10)]);
var _ = (function (){var statearr_27886 = state_27861;
(statearr_27886[(4)] = cljs.core.cons((5),(state_27861[(4)])));

return statearr_27886;
})();
var inst_27766 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27767 = session;
var inst_27768 = cljs.core.__destructure_map(inst_27767);
var inst_27769__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27768,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27770__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27768,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27771__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27768,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27773 = [inst_27770__$1,inst_27771__$1];
var inst_27774 = (new cljs.core.PersistentVector(null,2,(5),inst_27772,inst_27773,null));
var inst_27775 = fluree.db.operations.ledger_info_async(inst_27769__$1,inst_27774);
var state_27861__$1 = (function (){var statearr_27887 = state_27861;
(statearr_27887[(8)] = inst_27770__$1);

(statearr_27887[(9)] = inst_27771__$1);

(statearr_27887[(10)] = inst_27769__$1);

(statearr_27887[(17)] = inst_27766);

return statearr_27887;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27861__$1,(6),inst_27775);
} else {
if((state_val_27862 === (23))){
var inst_27817 = (state_27861[(16)]);
var inst_27808 = (state_27861[(18)]);
var inst_27820 = cljs.core.__destructure_map(inst_27817);
var inst_27821 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27820,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27822 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27820,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27823 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27820,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27824 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27808,inst_27822,inst_27821);
var state_27861__$1 = (function (){var statearr_27888 = state_27861;
(statearr_27888[(19)] = inst_27823);

return statearr_27888;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27861__$1,(26),inst_27824);
} else {
if((state_val_27862 === (19))){
var inst_27808 = (state_27861[(18)]);
var state_27861__$1 = state_27861;
var statearr_27889_27928 = state_27861__$1;
(statearr_27889_27928[(2)] = inst_27808);

(statearr_27889_27928[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (11))){
var inst_27778 = (state_27861[(7)]);
var inst_27770 = (state_27861[(8)]);
var inst_27771 = (state_27861[(9)]);
var inst_27787 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27778);
var inst_27788 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27770),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27771)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27787),"."].join('');
var state_27861__$1 = state_27861;
var statearr_27891_27929 = state_27861__$1;
(statearr_27891_27929[(2)] = inst_27788);

(statearr_27891_27929[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (9))){
var inst_27778 = (state_27861[(7)]);
var inst_27770 = (state_27861[(8)]);
var inst_27771 = (state_27861[(9)]);
var inst_27769 = (state_27861[(10)]);
var inst_27766 = (state_27861[(17)]);
var inst_27798 = (state_27861[(2)]);
var inst_27799 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27778);
var inst_27800 = fluree.db.storage.core.reify_db(inst_27769,inst_27770,inst_27771,inst_27766,inst_27799);
var state_27861__$1 = (function (){var statearr_27892 = state_27861;
(statearr_27892[(20)] = inst_27798);

return statearr_27892;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27861__$1,(13),inst_27800);
} else {
if((state_val_27862 === (5))){
var _ = (function (){var statearr_27893 = state_27861;
(statearr_27893[(4)] = cljs.core.rest((state_27861[(4)])));

return statearr_27893;
})();
var state_27861__$1 = state_27861;
var ex27890 = (state_27861__$1[(2)]);
var statearr_27894_27930 = state_27861__$1;
(statearr_27894_27930[(5)] = ex27890);


var statearr_27895_27931 = state_27861__$1;
(statearr_27895_27931[(1)] = (4));

(statearr_27895_27931[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (14))){
var inst_27803 = (state_27861[(14)]);
var inst_27806 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27803);
var inst_27807 = (inst_27806 + (1));
var inst_27808 = inst_27803;
var inst_27809 = inst_27807;
var state_27861__$1 = (function (){var statearr_27896 = state_27861;
(statearr_27896[(11)] = inst_27809);

(statearr_27896[(18)] = inst_27808);

return statearr_27896;
})();
var statearr_27897_27932 = state_27861__$1;
(statearr_27897_27932[(2)] = null);

(statearr_27897_27932[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (26))){
var inst_27809 = (state_27861[(11)]);
var inst_27826 = (state_27861[(2)]);
var inst_27827 = fluree.db.util.async.throw_err(inst_27826);
var inst_27828 = (inst_27809 + (1));
var inst_27808 = inst_27827;
var inst_27809__$1 = inst_27828;
var state_27861__$1 = (function (){var statearr_27898 = state_27861;
(statearr_27898[(11)] = inst_27809__$1);

(statearr_27898[(18)] = inst_27808);

return statearr_27898;
})();
var statearr_27899_27933 = state_27861__$1;
(statearr_27899_27933[(2)] = null);

(statearr_27899_27933[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (16))){
var inst_27845 = (state_27861[(13)]);
var inst_27845__$1 = (state_27861[(2)]);
var inst_27846 = fluree.db.query.schema.schema_map(inst_27845__$1);
var state_27861__$1 = (function (){var statearr_27900 = state_27861;
(statearr_27900[(13)] = inst_27845__$1);

return statearr_27900;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27861__$1,(27),inst_27846);
} else {
if((state_val_27862 === (10))){
var inst_27770 = (state_27861[(8)]);
var inst_27771 = (state_27861[(9)]);
var inst_27785 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27770),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27771)," is not found on this ledger group."].join('');
var state_27861__$1 = state_27861;
var statearr_27901_27934 = state_27861__$1;
(statearr_27901_27934[(2)] = inst_27785);

(statearr_27901_27934[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (18))){
var inst_27842 = (state_27861[(2)]);
var state_27861__$1 = state_27861;
var statearr_27902_27935 = state_27861__$1;
(statearr_27902_27935[(2)] = inst_27842);

(statearr_27902_27935[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27862 === (8))){
var state_27861__$1 = state_27861;
var statearr_27903_27936 = state_27861__$1;
(statearr_27903_27936[(2)] = null);

(statearr_27903_27936[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____0 = (function (){
var statearr_27904 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27904[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__);

(statearr_27904[(1)] = (1));

return statearr_27904;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____1 = (function (state_27861){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27861);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27905){var ex__2736__auto__ = e27905;
var statearr_27906_27937 = state_27861;
(statearr_27906_27937[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27861[(4)]))){
var statearr_27907_27938 = state_27861;
(statearr_27907_27938[(1)] = cljs.core.first((state_27861[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27939 = state_27861;
state_27861 = G__27939;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__ = function(state_27861){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____1.call(this,state_27861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27908 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27908[(6)] = c__2755__auto___27909);

return statearr_27908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__27940 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__27940,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__27940;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__27941 = cljs.core.get_global_hierarchy;
return (fexpr__27941.cljs$core$IFn$_invoke$arity$0 ? fexpr__27941.cljs$core$IFn$_invoke$arity$0() : fexpr__27941.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27943){
var state_val_27944 = (state_27943[(1)]);
if((state_val_27944 === (1))){
var state_27943__$1 = state_27943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27943__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2733__auto__ = null;
var fluree$db$session$state_machine__2733__auto____0 = (function (){
var statearr_27945 = [null,null,null,null,null,null,null];
(statearr_27945[(0)] = fluree$db$session$state_machine__2733__auto__);

(statearr_27945[(1)] = (1));

return statearr_27945;
});
var fluree$db$session$state_machine__2733__auto____1 = (function (state_27943){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27943);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27946){var ex__2736__auto__ = e27946;
var statearr_27947_27950 = state_27943;
(statearr_27947_27950[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27943[(4)]))){
var statearr_27948_27951 = state_27943;
(statearr_27948_27951[(1)] = cljs.core.first((state_27943[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27952 = state_27943;
state_27943 = G__27952;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$state_machine__2733__auto__ = function(state_27943){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2733__auto____1.call(this,state_27943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2733__auto____0;
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2733__auto____1;
return fluree$db$session$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27949 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27949[(6)] = c__2755__auto__);

return statearr_27949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27954){
var map__27955 = p__27954;
var map__27955__$1 = cljs.core.__destructure_map(map__27955);
var data = map__27955__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27955__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27955__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27955__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28014){
var state_val_28015 = (state_28014[(1)]);
if((state_val_28015 === (7))){
var inst_27969 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27970 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27971 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27969),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27970),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_27972 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27971], 0));
var state_28014__$1 = state_28014;
var statearr_28016_28054 = state_28014__$1;
(statearr_28016_28054[(2)] = inst_27972);

(statearr_28016_28054[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (1))){
var state_28014__$1 = state_28014;
var statearr_28017_28055 = state_28014__$1;
(statearr_28017_28055[(2)] = null);

(statearr_28017_28055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (4))){
var inst_27956 = (state_28014[(2)]);
var state_28014__$1 = state_28014;
var statearr_28018_28056 = state_28014__$1;
(statearr_28018_28056[(2)] = inst_27956);

(statearr_28018_28056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (15))){
var inst_27995 = (state_28014[(2)]);
var state_28014__$1 = state_28014;
var statearr_28019_28057 = state_28014__$1;
(statearr_28019_28057[(2)] = inst_27995);

(statearr_28019_28057[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (13))){
var inst_27986 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27988 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27989 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27990 = [inst_27988,inst_27989];
var inst_27991 = (new cljs.core.PersistentVector(null,2,(5),inst_27987,inst_27990,null));
var inst_27992 = (function (){var G__28020 = inst_27986;
var G__28021 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__28022 = inst_27991;
var G__28023 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__28020,G__28021,G__28022,G__28023) : fluree.db.conn_events.process_event.call(null,G__28020,G__28021,G__28022,G__28023));
})();
var state_28014__$1 = state_28014;
var statearr_28024_28058 = state_28014__$1;
(statearr_28024_28058[(2)] = inst_27992);

(statearr_28024_28058[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (6))){
var inst_27966 = (state_28014[(7)]);
var inst_27965 = (state_28014[(8)]);
var inst_27964 = (state_28014[(2)]);
var inst_27965__$1 = fluree.db.util.async.throw_err(inst_27964);
var inst_27966__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27965__$1);
var inst_27967 = (block <= inst_27966__$1);
var state_28014__$1 = (function (){var statearr_28025 = state_28014;
(statearr_28025[(7)] = inst_27966__$1);

(statearr_28025[(8)] = inst_27965__$1);

return statearr_28025;
})();
if(cljs.core.truth_(inst_27967)){
var statearr_28026_28059 = state_28014__$1;
(statearr_28026_28059[(1)] = (7));

} else {
var statearr_28027_28060 = state_28014__$1;
(statearr_28027_28060[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (17))){
var state_28014__$1 = state_28014;
var statearr_28028_28061 = state_28014__$1;
(statearr_28028_28061[(2)] = null);

(statearr_28028_28061[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (3))){
var inst_28012 = (state_28014[(2)]);
var state_28014__$1 = state_28014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28014__$1,inst_28012);
} else {
if((state_val_28015 === (12))){
var inst_28007 = (state_28014[(2)]);
var state_28014__$1 = state_28014;
var statearr_28029_28062 = state_28014__$1;
(statearr_28029_28062[(2)] = inst_28007);

(statearr_28029_28062[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (2))){
var inst_27962 = (state_28014[(9)]);
var _ = (function (){var statearr_28030 = state_28014;
(statearr_28030[(4)] = cljs.core.cons((5),(state_28014[(4)])));

return statearr_28030;
})();
var inst_27962__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_28014__$1 = (function (){var statearr_28031 = state_28014;
(statearr_28031[(9)] = inst_27962__$1);

return statearr_28031;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28014__$1,(6),inst_27962__$1);
} else {
if((state_val_28015 === (11))){
var state_28014__$1 = state_28014;
var statearr_28033_28063 = state_28014__$1;
(statearr_28033_28063[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (9))){
var inst_28009 = (state_28014[(2)]);
var _ = (function (){var statearr_28035 = state_28014;
(statearr_28035[(4)] = cljs.core.rest((state_28014[(4)])));

return statearr_28035;
})();
var state_28014__$1 = state_28014;
var statearr_28036_28064 = state_28014__$1;
(statearr_28036_28064[(2)] = inst_28009);

(statearr_28036_28064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (5))){
var _ = (function (){var statearr_28037 = state_28014;
(statearr_28037[(4)] = cljs.core.rest((state_28014[(4)])));

return statearr_28037;
})();
var state_28014__$1 = state_28014;
var ex28032 = (state_28014__$1[(2)]);
var statearr_28038_28065 = state_28014__$1;
(statearr_28038_28065[(5)] = ex28032);


if((ex28032 instanceof Error)){
var statearr_28039_28066 = state_28014__$1;
(statearr_28039_28066[(1)] = (4));

(statearr_28039_28066[(5)] = null);

} else {
throw ex28032;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (14))){
var state_28014__$1 = state_28014;
var statearr_28040_28067 = state_28014__$1;
(statearr_28040_28067[(2)] = null);

(statearr_28040_28067[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (16))){
var inst_27966 = (state_28014[(7)]);
var inst_27998 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27999 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28000 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27998),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27999),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27966),". Forcing a db reload."].join('');
var inst_28001 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28000], 0));
var inst_28002 = fluree.db.session.reload_db_BANG_(session);
var state_28014__$1 = (function (){var statearr_28041 = state_28014;
(statearr_28041[(10)] = inst_28001);

return statearr_28041;
})();
var statearr_28042_28068 = state_28014__$1;
(statearr_28042_28068[(2)] = inst_28002);

(statearr_28042_28068[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (10))){
var inst_27966 = (state_28014[(7)]);
var inst_27965 = (state_28014[(8)]);
var inst_27962 = (state_28014[(9)]);
var inst_27977 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27978 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27979 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27977),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27978),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27980 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27979], 0));
var inst_27981 = (function (){var current_db_ch = inst_27962;
var current_db = inst_27965;
var current_block = inst_27966;
return (function (p1__27953_SHARP_){
if((p1__27953_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__27953_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__27953_SHARP_);
}
});
})();
var inst_27982 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27981,flakes);
var inst_27983 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27965,block,inst_27982);
var inst_27984 = fluree.db.session.cas_db_BANG_(session,inst_27962,inst_27983);
var state_28014__$1 = (function (){var statearr_28043 = state_28014;
(statearr_28043[(11)] = inst_27980);

return statearr_28043;
})();
if(inst_27984){
var statearr_28044_28069 = state_28014__$1;
(statearr_28044_28069[(1)] = (13));

} else {
var statearr_28045_28070 = state_28014__$1;
(statearr_28045_28070[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (18))){
var inst_28005 = (state_28014[(2)]);
var state_28014__$1 = state_28014;
var statearr_28046_28071 = state_28014__$1;
(statearr_28046_28071[(2)] = inst_28005);

(statearr_28046_28071[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28015 === (8))){
var inst_27966 = (state_28014[(7)]);
var inst_27974 = ((1) + inst_27966);
var inst_27975 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27974);
var state_28014__$1 = state_28014;
if(inst_27975){
var statearr_28047_28072 = state_28014__$1;
(statearr_28047_28072[(1)] = (10));

} else {
var statearr_28048_28073 = state_28014__$1;
(statearr_28048_28073[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2733__auto__ = null;
var fluree$db$session$state_machine__2733__auto____0 = (function (){
var statearr_28049 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28049[(0)] = fluree$db$session$state_machine__2733__auto__);

(statearr_28049[(1)] = (1));

return statearr_28049;
});
var fluree$db$session$state_machine__2733__auto____1 = (function (state_28014){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28014);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28050){var ex__2736__auto__ = e28050;
var statearr_28051_28074 = state_28014;
(statearr_28051_28074[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28014[(4)]))){
var statearr_28052_28075 = state_28014;
(statearr_28052_28075[(1)] = cljs.core.first((state_28014[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28076 = state_28014;
state_28014 = G__28076;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$state_machine__2733__auto__ = function(state_28014){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2733__auto____1.call(this,state_28014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2733__auto____0;
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2733__auto____1;
return fluree$db$session$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28053 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28053[(6)] = c__2755__auto__);

return statearr_28053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28083){
var state_val_28084 = (state_28083[(1)]);
if((state_val_28084 === (1))){
var inst_28077 = fluree.db.session.clear_db_BANG_(session);
var inst_28078 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28079 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28080 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28078),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28079)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_28081 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28080], 0));
var state_28083__$1 = (function (){var statearr_28085 = state_28083;
(statearr_28085[(7)] = inst_28081);

(statearr_28085[(8)] = inst_28077);

return statearr_28085;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28083__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2733__auto__ = null;
var fluree$db$session$state_machine__2733__auto____0 = (function (){
var statearr_28086 = [null,null,null,null,null,null,null,null,null];
(statearr_28086[(0)] = fluree$db$session$state_machine__2733__auto__);

(statearr_28086[(1)] = (1));

return statearr_28086;
});
var fluree$db$session$state_machine__2733__auto____1 = (function (state_28083){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28083);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28087){var ex__2736__auto__ = e28087;
var statearr_28088_28091 = state_28083;
(statearr_28088_28091[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28083[(4)]))){
var statearr_28089_28092 = state_28083;
(statearr_28089_28092[(1)] = cljs.core.first((state_28083[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28093 = state_28083;
state_28083 = G__28093;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$state_machine__2733__auto__ = function(state_28083){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2733__auto____1.call(this,state_28083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2733__auto____0;
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2733__auto____1;
return fluree$db$session$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28090 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28090[(6)] = c__2755__auto__);

return statearr_28090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__28095 = arguments.length;
switch (G__28095) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__28096 = session;
var map__28096__$1 = cljs.core.__destructure_map(map__28096);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28096__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28096__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28096__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28096__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28096__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28096__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28096__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__28097_28100 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28097_28100.cljs$core$IFn$_invoke$arity$3 ? fexpr__28097_28100.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__28097_28100.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__28098_28101 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__28098_28101.cljs$core$IFn$_invoke$arity$0 ? fexpr__28098_28101.cljs$core$IFn$_invoke$arity$0() : fexpr__28098_28101.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28154){
var state_val_28155 = (state_28154[(1)]);
if((state_val_28155 === (7))){
var inst_28150 = (state_28154[(2)]);
var state_28154__$1 = state_28154;
var statearr_28156_28187 = state_28154__$1;
(statearr_28156_28187[(2)] = inst_28150);

(statearr_28156_28187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (1))){
var state_28154__$1 = state_28154;
var statearr_28157_28188 = state_28154__$1;
(statearr_28157_28188[(2)] = null);

(statearr_28157_28188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (4))){
var inst_28105 = (state_28154[(7)]);
var inst_28104 = (state_28154[(2)]);
var inst_28105__$1 = fluree.db.util.async.throw_err(inst_28104);
var inst_28106 = fluree.db.session.from_cache(network,ledger_id);
var inst_28107 = (inst_28105__$1 == null);
var state_28154__$1 = (function (){var statearr_28158 = state_28154;
(statearr_28158[(8)] = inst_28106);

(statearr_28158[(7)] = inst_28105__$1);

return statearr_28158;
})();
if(cljs.core.truth_(inst_28107)){
var statearr_28159_28189 = state_28154__$1;
(statearr_28159_28189[(1)] = (5));

} else {
var statearr_28160_28190 = state_28154__$1;
(statearr_28160_28190[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (15))){
var inst_28142 = (state_28154[(2)]);
var state_28154__$1 = (function (){var statearr_28161 = state_28154;
(statearr_28161[(9)] = inst_28142);

return statearr_28161;
})();
var statearr_28162_28191 = state_28154__$1;
(statearr_28162_28191[(2)] = null);

(statearr_28162_28191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (13))){
var inst_28146 = (state_28154[(2)]);
var state_28154__$1 = state_28154;
var statearr_28164_28192 = state_28154__$1;
(statearr_28164_28192[(2)] = inst_28146);

(statearr_28164_28192[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (6))){
var inst_28106 = (state_28154[(8)]);
var inst_28112 = (inst_28106 == null);
var state_28154__$1 = state_28154;
if(cljs.core.truth_(inst_28112)){
var statearr_28165_28193 = state_28154__$1;
(statearr_28165_28193[(1)] = (8));

} else {
var statearr_28166_28194 = state_28154__$1;
(statearr_28166_28194[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (17))){
var _ = (function (){var statearr_28167 = state_28154;
(statearr_28167[(4)] = cljs.core.rest((state_28154[(4)])));

return statearr_28167;
})();
var state_28154__$1 = state_28154;
var ex28163 = (state_28154__$1[(2)]);
var statearr_28168_28195 = state_28154__$1;
(statearr_28168_28195[(5)] = ex28163);


var statearr_28169_28196 = state_28154__$1;
(statearr_28169_28196[(1)] = (16));

(statearr_28169_28196[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (3))){
var inst_28152 = (state_28154[(2)]);
var state_28154__$1 = state_28154;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28154__$1,inst_28152);
} else {
if((state_val_28155 === (12))){
var state_28154__$1 = state_28154;
var statearr_28170_28197 = state_28154__$1;
(statearr_28170_28197[(2)] = null);

(statearr_28170_28197[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (2))){
var state_28154__$1 = state_28154;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28154__$1,(4),update_chan);
} else {
if((state_val_28155 === (11))){
var state_28154__$1 = state_28154;
var statearr_28171_28198 = state_28154__$1;
(statearr_28171_28198[(2)] = null);

(statearr_28171_28198[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (9))){
var state_28154__$1 = state_28154;
var statearr_28172_28199 = state_28154__$1;
(statearr_28172_28199[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (5))){
var inst_28109 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_28110 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28109], 0));
var state_28154__$1 = state_28154;
var statearr_28174_28200 = state_28154__$1;
(statearr_28174_28200[(2)] = inst_28110);

(statearr_28174_28200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (14))){
var inst_28106 = (state_28154[(8)]);
var inst_28105 = (state_28154[(7)]);
var _ = (function (){var statearr_28175 = state_28154;
(statearr_28175[(4)] = cljs.core.cons((17),(state_28154[(4)])));

return statearr_28175;
})();
var inst_28130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28105,(0),null);
var inst_28131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28105,(1),null);
var inst_28132 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_28133 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28105], 0));
var inst_28134 = fluree.db.util.core.trunc(inst_28133,(200));
var inst_28135 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28132,inst_28134], 0));
var inst_28136 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_28106,inst_28130,inst_28131) : fluree.db.session.process_ledger_update.call(null,inst_28106,inst_28130,inst_28131));
var state_28154__$1 = (function (){var statearr_28176 = state_28154;
(statearr_28176[(10)] = inst_28135);

return statearr_28176;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28154__$1,(18),inst_28136);
} else {
if((state_val_28155 === (16))){
var inst_28105 = (state_28154[(7)]);
var inst_28120 = (state_28154[(2)]);
var inst_28121 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28120,"Exception processing ledger updates for message: ",inst_28105], 0));
var state_28154__$1 = state_28154;
var statearr_28177_28201 = state_28154__$1;
(statearr_28177_28201[(2)] = inst_28121);

(statearr_28177_28201[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (10))){
var inst_28148 = (state_28154[(2)]);
var state_28154__$1 = state_28154;
var statearr_28178_28202 = state_28154__$1;
(statearr_28178_28202[(2)] = inst_28148);

(statearr_28178_28202[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (18))){
var inst_28138 = (state_28154[(2)]);
var inst_28139 = fluree.db.util.async.throw_err(inst_28138);
var _ = (function (){var statearr_28179 = state_28154;
(statearr_28179[(4)] = cljs.core.rest((state_28154[(4)])));

return statearr_28179;
})();
var state_28154__$1 = state_28154;
var statearr_28180_28203 = state_28154__$1;
(statearr_28180_28203[(2)] = inst_28139);

(statearr_28180_28203[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28155 === (8))){
var inst_28105 = (state_28154[(7)]);
var inst_28114 = cljs.core.first(inst_28105);
var inst_28115 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28114], 0));
var inst_28116 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_28115].join('');
var inst_28117 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28116], 0));
var state_28154__$1 = state_28154;
var statearr_28181_28204 = state_28154__$1;
(statearr_28181_28204[(2)] = inst_28117);

(statearr_28181_28204[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____0 = (function (){
var statearr_28182 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28182[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__);

(statearr_28182[(1)] = (1));

return statearr_28182;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____1 = (function (state_28154){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28154);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28183){var ex__2736__auto__ = e28183;
var statearr_28184_28205 = state_28154;
(statearr_28184_28205[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28154[(4)]))){
var statearr_28185_28206 = state_28154;
(statearr_28185_28206[(1)] = cljs.core.first((state_28154[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28207 = state_28154;
state_28154 = G__28207;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__ = function(state_28154){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____1.call(this,state_28154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28186 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28186[(6)] = c__2755__auto__);

return statearr_28186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__28208){
var map__28209 = p__28208;
var map__28209__$1 = cljs.core.__destructure_map(map__28209);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28209__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28209__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28209__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28209__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28209__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28209__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28209__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28209__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28209__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__28213 = block_result;
var map__28213__$1 = cljs.core.__destructure_map(map__28213);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28213__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28213__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28213__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28213__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28213__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__28214 = tx_result;
var map__28214__$1 = cljs.core.__destructure_map(map__28214);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28214__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28214__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__28210_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__28210_SHARP_.t);
}):(function (p1__28211_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28211_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__28212_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__28212_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28212_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__28215 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28215,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28215,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28215,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28215,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__28219 = arguments.length;
switch (G__28219) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28220){
var map__28221 = p__28220;
var map__28221__$1 = cljs.core.__destructure_map(map__28221);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28221__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28221__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28221__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28221__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28222 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28222,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28222,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28222,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4223__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4223__auto____$1 = state;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__28226_28346 = network;
var G__28227_28347 = ledger_id;
var G__28228_28348 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__28229_28349 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28230 = cljs.core.seq(tids);
var chunk__28231 = null;
var count__28232 = (0);
var i__28233 = (0);
while(true){
if((i__28233 < count__28232)){
var tid = chunk__28231.cljs$core$IIndexed$_nth$arity$2(null,i__28233);
var temp__5753__auto___28351__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28351__$1)){
var keyed_callbacks_28352 = temp__5753__auto___28351__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28353 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28274_28354 = cljs.core.seq(keyed_callbacks_28352);
var chunk__28275_28355 = null;
var count__28276_28356 = (0);
var i__28277_28357 = (0);
while(true){
if((i__28277_28357 < count__28276_28356)){
var vec__28286_28358 = chunk__28275_28355.cljs$core$IIndexed$_nth$arity$2(null,i__28277_28357);
var k_28359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28286_28358,(0),null);
var f_28360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28286_28358,(1),null);
try{(f_28360.cljs$core$IFn$_invoke$arity$1 ? f_28360.cljs$core$IFn$_invoke$arity$1(tx_response_28353) : f_28360.call(null,tx_response_28353));
}catch (e28289){var e_28361 = e28289;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28361,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28362 = seq__28274_28354;
var G__28363 = chunk__28275_28355;
var G__28364 = count__28276_28356;
var G__28365 = (i__28277_28357 + (1));
seq__28274_28354 = G__28362;
chunk__28275_28355 = G__28363;
count__28276_28356 = G__28364;
i__28277_28357 = G__28365;
continue;
} else {
var temp__5753__auto___28366__$2 = cljs.core.seq(seq__28274_28354);
if(temp__5753__auto___28366__$2){
var seq__28274_28367__$1 = temp__5753__auto___28366__$2;
if(cljs.core.chunked_seq_QMARK_(seq__28274_28367__$1)){
var c__4649__auto___28368 = cljs.core.chunk_first(seq__28274_28367__$1);
var G__28369 = cljs.core.chunk_rest(seq__28274_28367__$1);
var G__28370 = c__4649__auto___28368;
var G__28371 = cljs.core.count(c__4649__auto___28368);
var G__28372 = (0);
seq__28274_28354 = G__28369;
chunk__28275_28355 = G__28370;
count__28276_28356 = G__28371;
i__28277_28357 = G__28372;
continue;
} else {
var vec__28290_28373 = cljs.core.first(seq__28274_28367__$1);
var k_28374 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28290_28373,(0),null);
var f_28375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28290_28373,(1),null);
try{(f_28375.cljs$core$IFn$_invoke$arity$1 ? f_28375.cljs$core$IFn$_invoke$arity$1(tx_response_28353) : f_28375.call(null,tx_response_28353));
}catch (e28293){var e_28376 = e28293;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28376,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28377 = cljs.core.next(seq__28274_28367__$1);
var G__28378 = null;
var G__28379 = (0);
var G__28380 = (0);
seq__28274_28354 = G__28377;
chunk__28275_28355 = G__28378;
count__28276_28356 = G__28379;
i__28277_28357 = G__28380;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28381 = seq__28230;
var G__28382 = chunk__28231;
var G__28383 = count__28232;
var G__28384 = (i__28233 + (1));
seq__28230 = G__28381;
chunk__28231 = G__28382;
count__28232 = G__28383;
i__28233 = G__28384;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__28230);
if(temp__5753__auto____$1){
var seq__28230__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__28230__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__28230__$1);
var G__28385 = cljs.core.chunk_rest(seq__28230__$1);
var G__28386 = c__4649__auto__;
var G__28387 = cljs.core.count(c__4649__auto__);
var G__28388 = (0);
seq__28230 = G__28385;
chunk__28231 = G__28386;
count__28232 = G__28387;
i__28233 = G__28388;
continue;
} else {
var tid = cljs.core.first(seq__28230__$1);
var temp__5753__auto___28389__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28389__$2)){
var keyed_callbacks_28390 = temp__5753__auto___28389__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28391 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28294_28392 = cljs.core.seq(keyed_callbacks_28390);
var chunk__28295_28393 = null;
var count__28296_28394 = (0);
var i__28297_28395 = (0);
while(true){
if((i__28297_28395 < count__28296_28394)){
var vec__28306_28396 = chunk__28295_28393.cljs$core$IIndexed$_nth$arity$2(null,i__28297_28395);
var k_28397 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28306_28396,(0),null);
var f_28398 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28306_28396,(1),null);
try{(f_28398.cljs$core$IFn$_invoke$arity$1 ? f_28398.cljs$core$IFn$_invoke$arity$1(tx_response_28391) : f_28398.call(null,tx_response_28391));
}catch (e28309){var e_28399 = e28309;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28399,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28400 = seq__28294_28392;
var G__28401 = chunk__28295_28393;
var G__28402 = count__28296_28394;
var G__28403 = (i__28297_28395 + (1));
seq__28294_28392 = G__28400;
chunk__28295_28393 = G__28401;
count__28296_28394 = G__28402;
i__28297_28395 = G__28403;
continue;
} else {
var temp__5753__auto___28404__$3 = cljs.core.seq(seq__28294_28392);
if(temp__5753__auto___28404__$3){
var seq__28294_28405__$1 = temp__5753__auto___28404__$3;
if(cljs.core.chunked_seq_QMARK_(seq__28294_28405__$1)){
var c__4649__auto___28406 = cljs.core.chunk_first(seq__28294_28405__$1);
var G__28407 = cljs.core.chunk_rest(seq__28294_28405__$1);
var G__28408 = c__4649__auto___28406;
var G__28409 = cljs.core.count(c__4649__auto___28406);
var G__28410 = (0);
seq__28294_28392 = G__28407;
chunk__28295_28393 = G__28408;
count__28296_28394 = G__28409;
i__28297_28395 = G__28410;
continue;
} else {
var vec__28310_28411 = cljs.core.first(seq__28294_28405__$1);
var k_28412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28310_28411,(0),null);
var f_28413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28310_28411,(1),null);
try{(f_28413.cljs$core$IFn$_invoke$arity$1 ? f_28413.cljs$core$IFn$_invoke$arity$1(tx_response_28391) : f_28413.call(null,tx_response_28391));
}catch (e28313){var e_28414 = e28313;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28414,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28415 = cljs.core.next(seq__28294_28405__$1);
var G__28416 = null;
var G__28417 = (0);
var G__28418 = (0);
seq__28294_28392 = G__28415;
chunk__28295_28393 = G__28416;
count__28296_28394 = G__28417;
i__28297_28395 = G__28418;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28419 = cljs.core.next(seq__28230__$1);
var G__28420 = null;
var G__28421 = (0);
var G__28422 = (0);
seq__28230 = G__28419;
chunk__28231 = G__28420;
count__28232 = G__28421;
i__28233 = G__28422;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__28225_28350 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28225_28350.cljs$core$IFn$_invoke$arity$4 ? fexpr__28225_28350.cljs$core$IFn$_invoke$arity$4(G__28226_28346,G__28227_28347,G__28228_28348,G__28229_28349) : fexpr__28225_28350.call(null,G__28226_28346,G__28227_28347,G__28228_28348,G__28229_28349));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28423 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2755__auto___28424 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28330){
var state_val_28331 = (state_28330[(1)]);
if((state_val_28331 === (1))){
var state_28330__$1 = state_28330;
var statearr_28332_28425 = state_28330__$1;
(statearr_28332_28425[(2)] = null);

(statearr_28332_28425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28331 === (2))){
var inst_28315 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28330__$1 = state_28330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28330__$1,(4),inst_28315);
} else {
if((state_val_28331 === (3))){
var inst_28328 = (state_28330[(2)]);
var state_28330__$1 = state_28330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28330__$1,inst_28328);
} else {
if((state_val_28331 === (4))){
var inst_28317 = (state_28330[(7)]);
var inst_28317__$1 = (state_28330[(2)]);
var inst_28318 = (inst_28317__$1 == null);
var state_28330__$1 = (function (){var statearr_28333 = state_28330;
(statearr_28333[(7)] = inst_28317__$1);

return statearr_28333;
})();
if(cljs.core.truth_(inst_28318)){
var statearr_28334_28426 = state_28330__$1;
(statearr_28334_28426[(1)] = (5));

} else {
var statearr_28335_28427 = state_28330__$1;
(statearr_28335_28427[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28331 === (5))){
var inst_28320 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28321 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28320], 0));
var state_28330__$1 = state_28330;
var statearr_28336_28428 = state_28330__$1;
(statearr_28336_28428[(2)] = inst_28321);

(statearr_28336_28428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28331 === (6))){
var inst_28317 = (state_28330[(7)]);
var inst_28323 = (transact_handler_28423.cljs$core$IFn$_invoke$arity$2 ? transact_handler_28423.cljs$core$IFn$_invoke$arity$2(conn,inst_28317) : transact_handler_28423.call(null,conn,inst_28317));
var state_28330__$1 = (function (){var statearr_28337 = state_28330;
(statearr_28337[(8)] = inst_28323);

return statearr_28337;
})();
var statearr_28338_28429 = state_28330__$1;
(statearr_28338_28429[(2)] = null);

(statearr_28338_28429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28331 === (7))){
var inst_28326 = (state_28330[(2)]);
var state_28330__$1 = state_28330;
var statearr_28339_28430 = state_28330__$1;
(statearr_28339_28430[(2)] = inst_28326);

(statearr_28339_28430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2733__auto__ = null;
var fluree$db$session$state_machine__2733__auto____0 = (function (){
var statearr_28340 = [null,null,null,null,null,null,null,null,null];
(statearr_28340[(0)] = fluree$db$session$state_machine__2733__auto__);

(statearr_28340[(1)] = (1));

return statearr_28340;
});
var fluree$db$session$state_machine__2733__auto____1 = (function (state_28330){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28330);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28341){var ex__2736__auto__ = e28341;
var statearr_28342_28431 = state_28330;
(statearr_28342_28431[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28330[(4)]))){
var statearr_28343_28432 = state_28330;
(statearr_28343_28432[(1)] = cljs.core.first((state_28330[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28433 = state_28330;
state_28330 = G__28433;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$state_machine__2733__auto__ = function(state_28330){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2733__auto____1.call(this,state_28330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2733__auto____0;
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2733__auto____1;
return fluree$db$session$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28344 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28344[(6)] = c__2755__auto___28424);

return statearr_28344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28434_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__28434_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28434_SHARP_) + (1))], 0));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28435_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__28435_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28438 = arguments.length;
switch (G__28438) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28439 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28436_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__28436_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28439);
} else {
return G__28439;
}
})();
var seq__28440 = cljs.core.seq(sessions);
var chunk__28441 = null;
var count__28442 = (0);
var i__28443 = (0);
while(true){
if((i__28443 < count__28442)){
var session = chunk__28441.cljs$core$IIndexed$_nth$arity$2(null,i__28443);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28445 = seq__28440;
var G__28446 = chunk__28441;
var G__28447 = count__28442;
var G__28448 = (i__28443 + (1));
seq__28440 = G__28445;
chunk__28441 = G__28446;
count__28442 = G__28447;
i__28443 = G__28448;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__28440);
if(temp__5753__auto__){
var seq__28440__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28440__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__28440__$1);
var G__28449 = cljs.core.chunk_rest(seq__28440__$1);
var G__28450 = c__4649__auto__;
var G__28451 = cljs.core.count(c__4649__auto__);
var G__28452 = (0);
seq__28440 = G__28449;
chunk__28441 = G__28450;
count__28442 = G__28451;
i__28443 = G__28452;
continue;
} else {
var session = cljs.core.first(seq__28440__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28453 = cljs.core.next(seq__28440__$1);
var G__28454 = null;
var G__28455 = (0);
var G__28456 = (0);
seq__28440 = G__28453;
chunk__28441 = G__28454;
count__28442 = G__28455;
i__28443 = G__28456;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
