// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_15831){
var state_val_15832 = (state_15831[(1)]);
if((state_val_15832 === (1))){
var state_15831__$1 = state_15831;
var statearr_15833_15847 = state_15831__$1;
(statearr_15833_15847[(2)] = null);

(statearr_15833_15847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15832 === (2))){
var _ = (function (){var statearr_15834 = state_15831;
(statearr_15834[(4)] = cljs.core.cons((5),(state_15831[(4)])));

return statearr_15834;
})();
var inst_15822 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_15831__$1 = state_15831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15831__$1,(6),inst_15822);
} else {
if((state_val_15832 === (3))){
var inst_15829 = (state_15831[(2)]);
var state_15831__$1 = state_15831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15831__$1,inst_15829);
} else {
if((state_val_15832 === (4))){
var inst_15816 = (state_15831[(2)]);
var state_15831__$1 = state_15831;
var statearr_15836_15848 = state_15831__$1;
(statearr_15836_15848[(2)] = inst_15816);

(statearr_15836_15848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15832 === (5))){
var _ = (function (){var statearr_15837 = state_15831;
(statearr_15837[(4)] = cljs.core.rest((state_15831[(4)])));

return statearr_15837;
})();
var state_15831__$1 = state_15831;
var ex15835 = (state_15831__$1[(2)]);
var statearr_15838_15849 = state_15831__$1;
(statearr_15838_15849[(5)] = ex15835);


if((ex15835 instanceof Error)){
var statearr_15839_15850 = state_15831__$1;
(statearr_15839_15850[(1)] = (4));

(statearr_15839_15850[(5)] = null);

} else {
throw ex15835;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15832 === (6))){
var inst_15824 = (state_15831[(2)]);
var inst_15825 = fluree.db.util.async.throw_err(inst_15824);
var inst_15826 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_15825);
var _ = (function (){var statearr_15840 = state_15831;
(statearr_15840[(4)] = cljs.core.rest((state_15831[(4)])));

return statearr_15840;
})();
var state_15831__$1 = state_15831;
var statearr_15841_15851 = state_15831__$1;
(statearr_15841_15851[(2)] = inst_15826);

(statearr_15841_15851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____0 = (function (){
var statearr_15842 = [null,null,null,null,null,null,null];
(statearr_15842[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__);

(statearr_15842[(1)] = (1));

return statearr_15842;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____1 = (function (state_15831){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_15831);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e15843){var ex__2736__auto__ = e15843;
var statearr_15844_15852 = state_15831;
(statearr_15844_15852[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_15831[(4)]))){
var statearr_15845_15853 = state_15831;
(statearr_15845_15853[(1)] = cljs.core.first((state_15831[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15854 = state_15831;
state_15831 = G__15854;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__ = function(state_15831){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____1.call(this,state_15831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_15846 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_15846[(6)] = c__2755__auto__);

return statearr_15846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_15886){
var state_val_15887 = (state_15886[(1)]);
if((state_val_15887 === (7))){
var inst_15870 = (state_15886[(7)]);
var inst_15872 = cljs.core.empty_QMARK_(inst_15870);
var inst_15873 = (!(inst_15872));
var state_15886__$1 = state_15886;
var statearr_15888_15912 = state_15886__$1;
(statearr_15888_15912[(2)] = inst_15873);

(statearr_15888_15912[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15887 === (1))){
var state_15886__$1 = state_15886;
var statearr_15889_15913 = state_15886__$1;
(statearr_15889_15913[(2)] = null);

(statearr_15889_15913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15887 === (4))){
var inst_15856 = (state_15886[(2)]);
var state_15886__$1 = state_15886;
var statearr_15890_15914 = state_15886__$1;
(statearr_15890_15914[(2)] = inst_15856);

(statearr_15890_15914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15887 === (6))){
var inst_15862 = (state_15886[(8)]);
var inst_15870 = (state_15886[(7)]);
var inst_15868 = (state_15886[(2)]);
var inst_15869 = fluree.db.util.async.throw_err(inst_15868);
var inst_15870__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_15862,inst_15869);
var state_15886__$1 = (function (){var statearr_15891 = state_15886;
(statearr_15891[(7)] = inst_15870__$1);

return statearr_15891;
})();
if(cljs.core.truth_(inst_15870__$1)){
var statearr_15892_15915 = state_15886__$1;
(statearr_15892_15915[(1)] = (7));

} else {
var statearr_15893_15916 = state_15886__$1;
(statearr_15893_15916[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15887 === (3))){
var inst_15884 = (state_15886[(2)]);
var state_15886__$1 = state_15886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15886__$1,inst_15884);
} else {
if((state_val_15887 === (12))){
var inst_15881 = (state_15886[(2)]);
var _ = (function (){var statearr_15894 = state_15886;
(statearr_15894[(4)] = cljs.core.rest((state_15886[(4)])));

return statearr_15894;
})();
var state_15886__$1 = state_15886;
var statearr_15895_15917 = state_15886__$1;
(statearr_15895_15917[(2)] = inst_15881);

(statearr_15895_15917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15887 === (2))){
var _ = (function (){var statearr_15896 = state_15886;
(statearr_15896[(4)] = cljs.core.cons((5),(state_15886[(4)])));

return statearr_15896;
})();
var inst_15862 = (function (){return (function (p1__15855_SHARP_){
return p1__15855_SHARP_.o;
});
})();
var inst_15863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15864 = [pred_id];
var inst_15865 = (new cljs.core.PersistentVector(null,1,(5),inst_15863,inst_15864,null));
var inst_15866 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15865);
var state_15886__$1 = (function (){var statearr_15897 = state_15886;
(statearr_15897[(8)] = inst_15862);

return statearr_15897;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15886__$1,(6),inst_15866);
} else {
if((state_val_15887 === (11))){
var state_15886__$1 = state_15886;
var statearr_15899_15918 = state_15886__$1;
(statearr_15899_15918[(2)] = true);

(statearr_15899_15918[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15887 === (9))){
var inst_15876 = (state_15886[(2)]);
var state_15886__$1 = state_15886;
if(cljs.core.truth_(inst_15876)){
var statearr_15900_15919 = state_15886__$1;
(statearr_15900_15919[(1)] = (10));

} else {
var statearr_15901_15920 = state_15886__$1;
(statearr_15901_15920[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15887 === (5))){
var _ = (function (){var statearr_15902 = state_15886;
(statearr_15902[(4)] = cljs.core.rest((state_15886[(4)])));

return statearr_15902;
})();
var state_15886__$1 = state_15886;
var ex15898 = (state_15886__$1[(2)]);
var statearr_15903_15921 = state_15886__$1;
(statearr_15903_15921[(5)] = ex15898);


if((ex15898 instanceof Error)){
var statearr_15904_15922 = state_15886__$1;
(statearr_15904_15922[(1)] = (4));

(statearr_15904_15922[(5)] = null);

} else {
throw ex15898;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15887 === (10))){
var inst_15870 = (state_15886[(7)]);
var inst_15878 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_15870);
var state_15886__$1 = state_15886;
var statearr_15905_15923 = state_15886__$1;
(statearr_15905_15923[(2)] = inst_15878);

(statearr_15905_15923[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15887 === (8))){
var inst_15870 = (state_15886[(7)]);
var state_15886__$1 = state_15886;
var statearr_15906_15924 = state_15886__$1;
(statearr_15906_15924[(2)] = inst_15870);

(statearr_15906_15924[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_15907 = [null,null,null,null,null,null,null,null,null];
(statearr_15907[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__);

(statearr_15907[(1)] = (1));

return statearr_15907;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____1 = (function (state_15886){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_15886);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e15908){var ex__2736__auto__ = e15908;
var statearr_15909_15925 = state_15886;
(statearr_15909_15925[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_15886[(4)]))){
var statearr_15910_15926 = state_15886;
(statearr_15910_15926[(1)] = cljs.core.first((state_15886[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15927 = state_15886;
state_15886 = G__15927;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__ = function(state_15886){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____1.call(this,state_15886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_15911 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_15911[(6)] = c__2755__auto__);

return statearr_15911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_16008){
var state_val_16009 = (state_16008[(1)]);
if((state_val_16009 === (7))){
var state_16008__$1 = state_16008;
var statearr_16010_16048 = state_16008__$1;
(statearr_16010_16048[(2)] = flakes);

(statearr_16010_16048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (20))){
var inst_15965 = (state_16008[(7)]);
var inst_15998 = (state_16008[(2)]);
var inst_15957 = inst_15965;
var inst_15958 = inst_15998;
var state_16008__$1 = (function (){var statearr_16011 = state_16008;
(statearr_16011[(8)] = inst_15958);

(statearr_16011[(9)] = inst_15957);

return statearr_16011;
})();
var statearr_16012_16049 = state_16008__$1;
(statearr_16012_16049[(2)] = null);

(statearr_16012_16049[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (1))){
var state_16008__$1 = state_16008;
var statearr_16013_16050 = state_16008__$1;
(statearr_16013_16050[(2)] = null);

(statearr_16013_16050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (4))){
var inst_15930 = (state_16008[(2)]);
var state_16008__$1 = state_16008;
var statearr_16014_16051 = state_16008__$1;
(statearr_16014_16051[(2)] = inst_15930);

(statearr_16014_16051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (15))){
var inst_15964 = (state_16008[(10)]);
var inst_15982 = inst_15964.o;
var state_16008__$1 = state_16008;
var statearr_16015_16052 = state_16008__$1;
(statearr_16015_16052[(2)] = inst_15982);

(statearr_16015_16052[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (13))){
var inst_16001 = (state_16008[(2)]);
var state_16008__$1 = state_16008;
var statearr_16016_16053 = state_16008__$1;
(statearr_16016_16053[(2)] = inst_16001);

(statearr_16016_16053[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (6))){
var inst_15937 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16008__$1 = state_16008;
var statearr_16017_16054 = state_16008__$1;
(statearr_16017_16054[(2)] = inst_15937);

(statearr_16017_16054[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (17))){
var inst_15979 = (state_16008[(2)]);
var inst_15980 = fluree.db.util.async.throw_err(inst_15979);
var state_16008__$1 = state_16008;
var statearr_16018_16055 = state_16008__$1;
(statearr_16018_16055[(2)] = inst_15980);

(statearr_16018_16055[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (3))){
var inst_16006 = (state_16008[(2)]);
var state_16008__$1 = state_16008;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16008__$1,inst_16006);
} else {
if((state_val_16009 === (12))){
var inst_15964 = (state_16008[(10)]);
var inst_15971 = (state_16008[(11)]);
var inst_15969 = inst_15964.p;
var inst_15970 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15969);
var inst_15971__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_15970);
var inst_15972 = inst_15964.op;
var inst_15973 = inst_15972 === false;
var inst_15974 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_15971__$1);
var state_16008__$1 = (function (){var statearr_16019 = state_16008;
(statearr_16019[(12)] = inst_15973);

(statearr_16019[(11)] = inst_15971__$1);

return statearr_16019;
})();
if(inst_15974){
var statearr_16020_16056 = state_16008__$1;
(statearr_16020_16056[(1)] = (14));

} else {
var statearr_16021_16057 = state_16008__$1;
(statearr_16021_16057[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (2))){
var _ = (function (){var statearr_16022 = state_16008;
(statearr_16022[(4)] = cljs.core.cons((5),(state_16008[(4)])));

return statearr_16022;
})();
var state_16008__$1 = state_16008;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16023_16058 = state_16008__$1;
(statearr_16023_16058[(1)] = (6));

} else {
var statearr_16024_16059 = state_16008__$1;
(statearr_16024_16059[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (19))){
var inst_15984 = (state_16008[(13)]);
var inst_15958 = (state_16008[(8)]);
var inst_15964 = (state_16008[(10)]);
var inst_15971 = (state_16008[(11)]);
var inst_15992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15993 = inst_15964.s;
var inst_15994 = [inst_15993,inst_15971,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_15995 = (new cljs.core.PersistentVector(null,3,(5),inst_15992,inst_15994,null));
var inst_15996 = cljs.core.assoc_in(inst_15958,inst_15995,inst_15984);
var state_16008__$1 = state_16008;
var statearr_16025_16060 = state_16008__$1;
(statearr_16025_16060[(2)] = inst_15996);

(statearr_16025_16060[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (11))){
var inst_15958 = (state_16008[(8)]);
var state_16008__$1 = state_16008;
var statearr_16027_16061 = state_16008__$1;
(statearr_16027_16061[(2)] = inst_15958);

(statearr_16027_16061[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (9))){
var inst_15964 = (state_16008[(10)]);
var inst_15957 = (state_16008[(9)]);
var inst_15963 = cljs.core.seq(inst_15957);
var inst_15964__$1 = cljs.core.first(inst_15963);
var inst_15965 = cljs.core.next(inst_15963);
var inst_15966 = cljs.core.not(inst_15964__$1);
var state_16008__$1 = (function (){var statearr_16028 = state_16008;
(statearr_16028[(10)] = inst_15964__$1);

(statearr_16028[(7)] = inst_15965);

return statearr_16028;
})();
if(inst_15966){
var statearr_16029_16062 = state_16008__$1;
(statearr_16029_16062[(1)] = (11));

} else {
var statearr_16030_16063 = state_16008__$1;
(statearr_16030_16063[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (5))){
var _ = (function (){var statearr_16031 = state_16008;
(statearr_16031[(4)] = cljs.core.rest((state_16008[(4)])));

return statearr_16031;
})();
var state_16008__$1 = state_16008;
var ex16026 = (state_16008__$1[(2)]);
var statearr_16032_16064 = state_16008__$1;
(statearr_16032_16064[(5)] = ex16026);


if((ex16026 instanceof Error)){
var statearr_16033_16065 = state_16008__$1;
(statearr_16033_16065[(1)] = (4));

(statearr_16033_16065[(5)] = null);

} else {
throw ex16026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (14))){
var inst_15964 = (state_16008[(10)]);
var inst_15976 = inst_15964.o;
var inst_15977 = fluree.db.query.schema.convert_type_to_kw(inst_15976,db);
var state_16008__$1 = state_16008;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16008__$1,(17),inst_15977);
} else {
if((state_val_16009 === (16))){
var inst_15973 = (state_16008[(12)]);
var inst_15984 = (state_16008[(2)]);
var state_16008__$1 = (function (){var statearr_16034 = state_16008;
(statearr_16034[(13)] = inst_15984);

return statearr_16034;
})();
if(cljs.core.truth_(inst_15973)){
var statearr_16035_16066 = state_16008__$1;
(statearr_16035_16066[(1)] = (18));

} else {
var statearr_16036_16067 = state_16008__$1;
(statearr_16036_16067[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (10))){
var inst_16003 = (state_16008[(2)]);
var _ = (function (){var statearr_16037 = state_16008;
(statearr_16037[(4)] = cljs.core.rest((state_16008[(4)])));

return statearr_16037;
})();
var state_16008__$1 = state_16008;
var statearr_16038_16068 = state_16008__$1;
(statearr_16038_16068[(2)] = inst_16003);

(statearr_16038_16068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (18))){
var inst_15984 = (state_16008[(13)]);
var inst_15958 = (state_16008[(8)]);
var inst_15964 = (state_16008[(10)]);
var inst_15971 = (state_16008[(11)]);
var inst_15986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15987 = inst_15964.s;
var inst_15988 = [inst_15987,inst_15971,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_15989 = (new cljs.core.PersistentVector(null,3,(5),inst_15986,inst_15988,null));
var inst_15990 = cljs.core.assoc_in(inst_15958,inst_15989,inst_15984);
var state_16008__$1 = state_16008;
var statearr_16039_16069 = state_16008__$1;
(statearr_16039_16069[(2)] = inst_15990);

(statearr_16039_16069[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16009 === (8))){
var inst_15940 = (state_16008[(2)]);
var inst_15941 = cljs.core.PersistentHashSet.EMPTY;
var inst_15942 = cljs.core.vals(tempids);
var inst_15943 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15941,inst_15942);
var inst_15944 = (function (){var pred_flakes = inst_15940;
var is_new_QMARK_ = inst_15943;
return (function (p1__15929_SHARP_,p2__15928_SHARP_){
var f = p2__15928_SHARP_;
return cljs.core.assoc_in(p1__15929_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__16040 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16040) : is_new_QMARK_.call(null,G__16040));
})()));
});
})();
var inst_15945 = cljs.core.PersistentHashMap.EMPTY;
var inst_15946 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_15944,inst_15945,inst_15940);
var inst_15954 = cljs.core.seq(inst_15940);
var inst_15955 = cljs.core.first(inst_15954);
var inst_15956 = cljs.core.next(inst_15954);
var inst_15957 = inst_15940;
var inst_15958 = inst_15946;
var state_16008__$1 = (function (){var statearr_16041 = state_16008;
(statearr_16041[(14)] = inst_15955);

(statearr_16041[(8)] = inst_15958);

(statearr_16041[(15)] = inst_15956);

(statearr_16041[(9)] = inst_15957);

return statearr_16041;
})();
var statearr_16042_16070 = state_16008__$1;
(statearr_16042_16070[(2)] = null);

(statearr_16042_16070[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____0 = (function (){
var statearr_16043 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16043[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__);

(statearr_16043[(1)] = (1));

return statearr_16043;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____1 = (function (state_16008){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_16008);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e16044){var ex__2736__auto__ = e16044;
var statearr_16045_16071 = state_16008;
(statearr_16045_16071[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_16008[(4)]))){
var statearr_16046_16072 = state_16008;
(statearr_16046_16072[(1)] = cljs.core.first((state_16008[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16073 = state_16008;
state_16008 = G__16073;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__ = function(state_16008){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____1.call(this,state_16008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_16047 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_16047[(6)] = c__2755__auto__);

return statearr_16047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16075 = arguments.length;
switch (G__16075) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16078 = arguments.length;
switch (G__16078) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_16390){
var state_val_16391 = (state_16390[(1)]);
if((state_val_16391 === (121))){
var inst_16345 = (state_16390[(7)]);
var state_16390__$1 = state_16390;
var statearr_16392_16585 = state_16390__$1;
(statearr_16392_16585[(2)] = inst_16345);

(statearr_16392_16585[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (65))){
var inst_16244 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16244)){
var statearr_16393_16586 = state_16390__$1;
(statearr_16393_16586[(1)] = (66));

} else {
var statearr_16394_16587 = state_16390__$1;
(statearr_16394_16587[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (70))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16254 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16255 = (inst_16250.cljs$core$IFn$_invoke$arity$5 ? inst_16250.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16254,null) : inst_16250.call(null,cljs.core.PersistentArrayMap,null,3,inst_16254,null));
var inst_16256 = (inst_16250.cljs$core$IFn$_invoke$arity$4 ? inst_16250.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16255,null) : inst_16250.call(null,cljs.core.PersistentHashSet,null,inst_16255,null));
var inst_16257 = (inst_16256.cljs$core$IFn$_invoke$arity$1 ? inst_16256.cljs$core$IFn$_invoke$arity$1(inst_16249) : inst_16256.call(null,inst_16249));
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16257)){
var statearr_16395_16588 = state_16390__$1;
(statearr_16395_16588[(1)] = (72));

} else {
var statearr_16396_16589 = state_16390__$1;
(statearr_16396_16589[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (62))){
var inst_16234 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16397_16590 = state_16390__$1;
(statearr_16397_16590[(2)] = inst_16234);

(statearr_16397_16590[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (74))){
var inst_16340 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16398_16591 = state_16390__$1;
(statearr_16398_16591[(2)] = inst_16340);

(statearr_16398_16591[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (110))){
var inst_16367 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16367)){
var statearr_16399_16592 = state_16390__$1;
(statearr_16399_16592[(1)] = (117));

} else {
var statearr_16400_16593 = state_16390__$1;
(statearr_16400_16593[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (7))){
var inst_16385 = (state_16390[(2)]);
var _ = (function (){var statearr_16401 = state_16390;
(statearr_16401[(4)] = cljs.core.rest((state_16390[(4)])));

return statearr_16401;
})();
var state_16390__$1 = state_16390;
var statearr_16402_16594 = state_16390__$1;
(statearr_16402_16594[(2)] = inst_16385);

(statearr_16402_16594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (59))){
var inst_16118 = (state_16390[(10)]);
var inst_16238 = (state_16390[(11)]);
var inst_16237 = (state_16390[(2)]);
var inst_16238__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16118);
var state_16390__$1 = (function (){var statearr_16403 = state_16390;
(statearr_16403[(12)] = inst_16237);

(statearr_16403[(11)] = inst_16238__$1);

return statearr_16403;
})();
if(cljs.core.truth_(inst_16238__$1)){
var statearr_16404_16595 = state_16390__$1;
(statearr_16404_16595[(1)] = (63));

} else {
var statearr_16405_16596 = state_16390__$1;
(statearr_16405_16596[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (86))){
var inst_16280 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16406_16597 = state_16390__$1;
(statearr_16406_16597[(2)] = inst_16280);

(statearr_16406_16597[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (20))){
var inst_16118 = (state_16390[(10)]);
var inst_16144 = (state_16390[(13)]);
var inst_16144__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16118);
var state_16390__$1 = (function (){var statearr_16407 = state_16390;
(statearr_16407[(13)] = inst_16144__$1);

return statearr_16407;
})();
if(cljs.core.truth_(inst_16144__$1)){
var statearr_16408_16598 = state_16390__$1;
(statearr_16408_16598[(1)] = (23));

} else {
var statearr_16409_16599 = state_16390__$1;
(statearr_16409_16599[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (72))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16259 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16249,inst_16250,throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16410_16600 = state_16390__$1;
(statearr_16410_16600[(2)] = inst_16259);

(statearr_16410_16600[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (58))){
var inst_16199 = (state_16390[(14)]);
var state_16390__$1 = state_16390;
var statearr_16411_16601 = state_16390__$1;
(statearr_16411_16601[(2)] = inst_16199);

(statearr_16411_16601[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (60))){
var inst_16117 = (state_16390[(15)]);
var inst_16106 = (state_16390[(16)]);
var inst_16225 = fluree.db.dbproto._p_prop(inst_16106,new cljs.core.Keyword(null,"name","name",1843675177),inst_16117);
var inst_16226 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16225)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16227 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16228 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16229 = cljs.core.PersistentHashMap.fromArrays(inst_16227,inst_16228);
var inst_16230 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16226,inst_16229);
var inst_16231 = (function(){throw inst_16230})();
var state_16390__$1 = state_16390;
var statearr_16412_16602 = state_16390__$1;
(statearr_16412_16602[(2)] = inst_16231);

(statearr_16412_16602[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (27))){
var inst_16147 = (state_16390[(17)]);
var state_16390__$1 = state_16390;
var statearr_16413_16603 = state_16390__$1;
(statearr_16413_16603[(2)] = inst_16147);

(statearr_16413_16603[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (1))){
var state_16390__$1 = state_16390;
var statearr_16414_16604 = state_16390__$1;
(statearr_16414_16604[(2)] = null);

(statearr_16414_16604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (69))){
var inst_16237 = (state_16390[(12)]);
var state_16390__$1 = state_16390;
var statearr_16415_16605 = state_16390__$1;
(statearr_16415_16605[(2)] = inst_16237);

(statearr_16415_16605[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (101))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16318 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16249,inst_16250,throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16416_16606 = state_16390__$1;
(statearr_16416_16606[(2)] = inst_16318);

(statearr_16416_16606[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (24))){
var inst_16144 = (state_16390[(13)]);
var state_16390__$1 = state_16390;
var statearr_16417_16607 = state_16390__$1;
(statearr_16417_16607[(2)] = inst_16144);

(statearr_16417_16607[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (102))){
var inst_16320 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16418_16608 = state_16390__$1;
(statearr_16418_16608[(2)] = inst_16320);

(statearr_16418_16608[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (55))){
var inst_16216 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16419_16609 = state_16390__$1;
(statearr_16419_16609[(2)] = inst_16216);

(statearr_16419_16609[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (85))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16278 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16249,inst_16250,throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16420_16610 = state_16390__$1;
(statearr_16420_16610[(2)] = inst_16278);

(statearr_16420_16610[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (39))){
var inst_16181 = (state_16390[(18)]);
var state_16390__$1 = state_16390;
var statearr_16421_16611 = state_16390__$1;
(statearr_16421_16611[(2)] = inst_16181);

(statearr_16421_16611[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (88))){
var inst_16237 = (state_16390[(12)]);
var state_16390__$1 = state_16390;
var statearr_16422_16612 = state_16390__$1;
(statearr_16422_16612[(2)] = inst_16237);

(statearr_16422_16612[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (46))){
var inst_16200 = (state_16390[(19)]);
var inst_16118 = (state_16390[(10)]);
var inst_16199 = (state_16390[(2)]);
var inst_16200__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16118);
var state_16390__$1 = (function (){var statearr_16423 = state_16390;
(statearr_16423[(19)] = inst_16200__$1);

(statearr_16423[(14)] = inst_16199);

return statearr_16423;
})();
if(cljs.core.truth_(inst_16200__$1)){
var statearr_16424_16613 = state_16390__$1;
(statearr_16424_16613[(1)] = (47));

} else {
var statearr_16425_16614 = state_16390__$1;
(statearr_16425_16614[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (4))){
var inst_16079 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16426_16615 = state_16390__$1;
(statearr_16426_16615[(2)] = inst_16079);

(statearr_16426_16615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (77))){
var inst_16338 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16427_16616 = state_16390__$1;
(statearr_16427_16616[(2)] = inst_16338);

(statearr_16427_16616[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (106))){
var inst_16330 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16428_16617 = state_16390__$1;
(statearr_16428_16617[(2)] = inst_16330);

(statearr_16428_16617[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (119))){
var inst_16116 = (state_16390[(20)]);
var inst_16380 = (state_16390[(2)]);
var inst_16105 = inst_16116;
var inst_16106 = inst_16380;
var state_16390__$1 = (function (){var statearr_16429 = state_16390;
(statearr_16429[(16)] = inst_16106);

(statearr_16429[(21)] = inst_16105);

return statearr_16429;
})();
var statearr_16430_16618 = state_16390__$1;
(statearr_16430_16618[(2)] = null);

(statearr_16430_16618[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (95))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16302 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16303 = (inst_16250.cljs$core$IFn$_invoke$arity$5 ? inst_16250.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16302,null) : inst_16250.call(null,cljs.core.PersistentArrayMap,null,5,inst_16302,null));
var inst_16304 = (inst_16250.cljs$core$IFn$_invoke$arity$4 ? inst_16250.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16303,null) : inst_16250.call(null,cljs.core.PersistentHashSet,null,inst_16303,null));
var inst_16305 = (inst_16304.cljs$core$IFn$_invoke$arity$1 ? inst_16304.cljs$core$IFn$_invoke$arity$1(inst_16249) : inst_16304.call(null,inst_16249));
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16305)){
var statearr_16431_16619 = state_16390__$1;
(statearr_16431_16619[(1)] = (96));

} else {
var statearr_16432_16620 = state_16390__$1;
(statearr_16432_16620[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (54))){
var inst_16207 = (state_16390[(22)]);
var state_16390__$1 = state_16390;
var statearr_16433_16621 = state_16390__$1;
(statearr_16433_16621[(2)] = inst_16207);

(statearr_16433_16621[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (92))){
var inst_16237 = (state_16390[(12)]);
var state_16390__$1 = state_16390;
var statearr_16434_16622 = state_16390__$1;
(statearr_16434_16622[(2)] = inst_16237);

(statearr_16434_16622[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (104))){
var inst_16237 = (state_16390[(12)]);
var state_16390__$1 = state_16390;
var statearr_16435_16623 = state_16390__$1;
(statearr_16435_16623[(2)] = inst_16237);

(statearr_16435_16623[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (15))){
var inst_16126 = (state_16390[(23)]);
var state_16390__$1 = state_16390;
var statearr_16436_16624 = state_16390__$1;
(statearr_16436_16624[(2)] = inst_16126);

(statearr_16436_16624[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (48))){
var inst_16200 = (state_16390[(19)]);
var state_16390__$1 = state_16390;
var statearr_16437_16625 = state_16390__$1;
(statearr_16437_16625[(2)] = inst_16200);

(statearr_16437_16625[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (50))){
var inst_16118 = (state_16390[(10)]);
var inst_16207 = (state_16390[(22)]);
var inst_16205 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16206 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16205);
var inst_16207__$1 = inst_16206 === true;
var state_16390__$1 = (function (){var statearr_16438 = state_16390;
(statearr_16438[(22)] = inst_16207__$1);

return statearr_16438;
})();
if(cljs.core.truth_(inst_16207__$1)){
var statearr_16439_16626 = state_16390__$1;
(statearr_16439_16626[(1)] = (53));

} else {
var statearr_16440_16627 = state_16390__$1;
(statearr_16440_16627[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (116))){
var inst_16361 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16441_16628 = state_16390__$1;
(statearr_16441_16628[(2)] = inst_16361);

(statearr_16441_16628[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (75))){
var inst_16250 = (state_16390[(9)]);
var state_16390__$1 = state_16390;
var G__16442_16629 = inst_16250;
var G__16442_16630__$1 = (((G__16442_16629 instanceof cljs.core.Keyword))?G__16442_16629.fqn:null);
switch (G__16442_16630__$1) {
case "long":
var statearr_16443_16632 = state_16390__$1;
(statearr_16443_16632[(1)] = (79));


break;
case "bigint":
var statearr_16444_16633 = state_16390__$1;
(statearr_16444_16633[(1)] = (83));


break;
case "double":
var statearr_16445_16634 = state_16390__$1;
(statearr_16445_16634[(1)] = (87));


break;
case "float":
var statearr_16446_16635 = state_16390__$1;
(statearr_16446_16635[(1)] = (91));


break;
case "bigdec":
var statearr_16447_16636 = state_16390__$1;
(statearr_16447_16636[(1)] = (95));


break;
case "string":
var statearr_16448_16637 = state_16390__$1;
(statearr_16448_16637[(1)] = (99));


break;
case "instant":
var statearr_16449_16638 = state_16390__$1;
(statearr_16449_16638[(1)] = (103));


break;
default:
var statearr_16450_16639 = state_16390__$1;
(statearr_16450_16639[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (99))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16312 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16313 = (inst_16250.cljs$core$IFn$_invoke$arity$5 ? inst_16250.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16312,null) : inst_16250.call(null,cljs.core.PersistentArrayMap,null,5,inst_16312,null));
var inst_16314 = (inst_16250.cljs$core$IFn$_invoke$arity$4 ? inst_16250.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16313,null) : inst_16250.call(null,cljs.core.PersistentHashSet,null,inst_16313,null));
var inst_16315 = (inst_16314.cljs$core$IFn$_invoke$arity$1 ? inst_16314.cljs$core$IFn$_invoke$arity$1(inst_16249) : inst_16314.call(null,inst_16249));
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16315)){
var statearr_16451_16640 = state_16390__$1;
(statearr_16451_16640[(1)] = (100));

} else {
var statearr_16452_16641 = state_16390__$1;
(statearr_16452_16641[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (21))){
var inst_16142 = (state_16390[(24)]);
var state_16390__$1 = state_16390;
var statearr_16453_16642 = state_16390__$1;
(statearr_16453_16642[(2)] = inst_16142);

(statearr_16453_16642[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (31))){
var inst_16158 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16454_16643 = state_16390__$1;
(statearr_16454_16643[(2)] = inst_16158);

(statearr_16454_16643[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (113))){
var inst_16364 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16455_16644 = state_16390__$1;
(statearr_16455_16644[(2)] = inst_16364);

(statearr_16455_16644[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (32))){
var state_16390__$1 = state_16390;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16456_16645 = state_16390__$1;
(statearr_16456_16645[(1)] = (35));

} else {
var statearr_16457_16646 = state_16390__$1;
(statearr_16457_16646[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (40))){
var inst_16194 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16194)){
var statearr_16458_16647 = state_16390__$1;
(statearr_16458_16647[(1)] = (44));

} else {
var statearr_16459_16648 = state_16390__$1;
(statearr_16459_16648[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (91))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16292 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16293 = (inst_16250.cljs$core$IFn$_invoke$arity$5 ? inst_16250.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16292,null) : inst_16250.call(null,cljs.core.PersistentArrayMap,null,3,inst_16292,null));
var inst_16294 = (inst_16250.cljs$core$IFn$_invoke$arity$4 ? inst_16250.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16293,null) : inst_16250.call(null,cljs.core.PersistentHashSet,null,inst_16293,null));
var inst_16295 = (inst_16294.cljs$core$IFn$_invoke$arity$1 ? inst_16294.cljs$core$IFn$_invoke$arity$1(inst_16249) : inst_16294.call(null,inst_16249));
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16295)){
var statearr_16460_16649 = state_16390__$1;
(statearr_16460_16649[(1)] = (92));

} else {
var statearr_16461_16650 = state_16390__$1;
(statearr_16461_16650[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (117))){
var state_16390__$1 = state_16390;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16462_16651 = state_16390__$1;
(statearr_16462_16651[(1)] = (120));

} else {
var statearr_16463_16652 = state_16390__$1;
(statearr_16463_16652[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (108))){
var inst_16349 = (state_16390[(25)]);
var inst_16118 = (state_16390[(10)]);
var inst_16349__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16118);
var state_16390__$1 = (function (){var statearr_16464 = state_16390;
(statearr_16464[(25)] = inst_16349__$1);

return statearr_16464;
})();
if(cljs.core.truth_(inst_16349__$1)){
var statearr_16465_16653 = state_16390__$1;
(statearr_16465_16653[(1)] = (111));

} else {
var statearr_16466_16654 = state_16390__$1;
(statearr_16466_16654[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (56))){
var inst_16211 = (state_16390[(2)]);
var inst_16212 = fluree.db.util.async.throw_err(inst_16211);
var inst_16213 = cljs.core.not(inst_16212);
var state_16390__$1 = state_16390;
var statearr_16467_16655 = state_16390__$1;
(statearr_16467_16655[(2)] = inst_16213);

(statearr_16467_16655[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (33))){
var inst_16141 = (state_16390[(26)]);
var state_16390__$1 = state_16390;
var statearr_16468_16656 = state_16390__$1;
(statearr_16468_16656[(2)] = inst_16141);

(statearr_16468_16656[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (13))){
var inst_16136 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16136)){
var statearr_16469_16657 = state_16390__$1;
(statearr_16469_16657[(1)] = (17));

} else {
var statearr_16470_16658 = state_16390__$1;
(statearr_16470_16658[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (22))){
var inst_16167 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16167)){
var statearr_16471_16659 = state_16390__$1;
(statearr_16471_16659[(1)] = (32));

} else {
var statearr_16472_16660 = state_16390__$1;
(statearr_16472_16660[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (90))){
var inst_16290 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16473_16661 = state_16390__$1;
(statearr_16473_16661[(2)] = inst_16290);

(statearr_16473_16661[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (109))){
var inst_16347 = (state_16390[(27)]);
var state_16390__$1 = state_16390;
var statearr_16474_16662 = state_16390__$1;
(statearr_16474_16662[(2)] = inst_16347);

(statearr_16474_16662[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (36))){
var inst_16141 = (state_16390[(26)]);
var state_16390__$1 = state_16390;
var statearr_16475_16663 = state_16390__$1;
(statearr_16475_16663[(2)] = inst_16141);

(statearr_16475_16663[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (41))){
var inst_16118 = (state_16390[(10)]);
var inst_16186 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16187 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16186);
var inst_16188 = inst_16187 === true;
var state_16390__$1 = state_16390;
var statearr_16476_16664 = state_16390__$1;
(statearr_16476_16664[(2)] = inst_16188);

(statearr_16476_16664[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (118))){
var inst_16345 = (state_16390[(7)]);
var state_16390__$1 = state_16390;
var statearr_16477_16665 = state_16390__$1;
(statearr_16477_16665[(2)] = inst_16345);

(statearr_16477_16665[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (89))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16288 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16249,inst_16250,throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16478_16666 = state_16390__$1;
(statearr_16478_16666[(2)] = inst_16288);

(statearr_16478_16666[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (100))){
var inst_16237 = (state_16390[(12)]);
var state_16390__$1 = state_16390;
var statearr_16479_16667 = state_16390__$1;
(statearr_16479_16667[(2)] = inst_16237);

(statearr_16479_16667[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (122))){
var inst_16377 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16480_16668 = state_16390__$1;
(statearr_16480_16668[(2)] = inst_16377);

(statearr_16480_16668[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (43))){
var inst_16191 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16481_16669 = state_16390__$1;
(statearr_16481_16669[(2)] = inst_16191);

(statearr_16481_16669[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (61))){
var inst_16199 = (state_16390[(14)]);
var state_16390__$1 = state_16390;
var statearr_16482_16670 = state_16390__$1;
(statearr_16482_16670[(2)] = inst_16199);

(statearr_16482_16670[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (29))){
var inst_16118 = (state_16390[(10)]);
var inst_16153 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16154 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16153);
var inst_16155 = inst_16154 === true;
var state_16390__$1 = state_16390;
var statearr_16483_16671 = state_16390__$1;
(statearr_16483_16671[(2)] = inst_16155);

(statearr_16483_16671[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (44))){
var inst_16180 = (state_16390[(28)]);
var inst_16196 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16180,"a component","a non-component",throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16484_16672 = state_16390__$1;
(statearr_16484_16672[(2)] = inst_16196);

(statearr_16484_16672[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (93))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16298 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16249,inst_16250,throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16485_16673 = state_16390__$1;
(statearr_16485_16673[(2)] = inst_16298);

(statearr_16485_16673[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (6))){
var inst_16117 = (state_16390[(15)]);
var inst_16105 = (state_16390[(21)]);
var inst_16114 = cljs.core.seq(inst_16105);
var inst_16115 = cljs.core.first(inst_16114);
var inst_16116 = cljs.core.next(inst_16114);
var inst_16117__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16115,(0),null);
var inst_16118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16115,(1),null);
var inst_16119 = cljs.core.not(inst_16117__$1);
var state_16390__$1 = (function (){var statearr_16486 = state_16390;
(statearr_16486[(15)] = inst_16117__$1);

(statearr_16486[(10)] = inst_16118);

(statearr_16486[(20)] = inst_16116);

return statearr_16486;
})();
if(inst_16119){
var statearr_16487_16674 = state_16390__$1;
(statearr_16487_16674[(1)] = (8));

} else {
var statearr_16488_16675 = state_16390__$1;
(statearr_16488_16675[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (111))){
var inst_16118 = (state_16390[(10)]);
var inst_16353 = (state_16390[(29)]);
var inst_16351 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16352 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16351);
var inst_16353__$1 = inst_16352 === true;
var state_16390__$1 = (function (){var statearr_16489 = state_16390;
(statearr_16489[(29)] = inst_16353__$1);

return statearr_16489;
})();
if(cljs.core.truth_(inst_16353__$1)){
var statearr_16490_16676 = state_16390__$1;
(statearr_16490_16676[(1)] = (114));

} else {
var statearr_16491_16677 = state_16390__$1;
(statearr_16491_16677[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (28))){
var inst_16161 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16492_16678 = state_16390__$1;
(statearr_16492_16678[(2)] = inst_16161);

(statearr_16492_16678[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (64))){
var inst_16238 = (state_16390[(11)]);
var state_16390__$1 = state_16390;
var statearr_16493_16679 = state_16390__$1;
(statearr_16493_16679[(2)] = inst_16238);

(statearr_16493_16679[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (103))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16322 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16323 = (inst_16250.cljs$core$IFn$_invoke$arity$5 ? inst_16250.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16322,null) : inst_16250.call(null,cljs.core.PersistentArrayMap,null,2,inst_16322,null));
var inst_16324 = (inst_16250.cljs$core$IFn$_invoke$arity$4 ? inst_16250.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16323,null) : inst_16250.call(null,cljs.core.PersistentHashSet,null,inst_16323,null));
var inst_16325 = (inst_16324.cljs$core$IFn$_invoke$arity$1 ? inst_16324.cljs$core$IFn$_invoke$arity$1(inst_16249) : inst_16324.call(null,inst_16249));
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16325)){
var statearr_16494_16680 = state_16390__$1;
(statearr_16494_16680[(1)] = (104));

} else {
var statearr_16495_16681 = state_16390__$1;
(statearr_16495_16681[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (51))){
var inst_16203 = (state_16390[(30)]);
var state_16390__$1 = state_16390;
var statearr_16496_16682 = state_16390__$1;
(statearr_16496_16682[(2)] = inst_16203);

(statearr_16496_16682[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (25))){
var inst_16164 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16497_16683 = state_16390__$1;
(statearr_16497_16683[(2)] = inst_16164);

(statearr_16497_16683[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (34))){
var inst_16118 = (state_16390[(10)]);
var inst_16181 = (state_16390[(18)]);
var inst_16180 = (state_16390[(2)]);
var inst_16181__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16118);
var state_16390__$1 = (function (){var statearr_16498 = state_16390;
(statearr_16498[(28)] = inst_16180);

(statearr_16498[(18)] = inst_16181__$1);

return statearr_16498;
})();
if(cljs.core.truth_(inst_16181__$1)){
var statearr_16499_16684 = state_16390__$1;
(statearr_16499_16684[(1)] = (38));

} else {
var statearr_16500_16685 = state_16390__$1;
(statearr_16500_16685[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (17))){
var inst_16106 = (state_16390[(16)]);
var inst_16138 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16106,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16501_16686 = state_16390__$1;
(statearr_16501_16686[(2)] = inst_16138);

(statearr_16501_16686[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (3))){
var inst_16388 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16390__$1,inst_16388);
} else {
if((state_val_16391 === (12))){
var inst_16122 = (state_16390[(31)]);
var state_16390__$1 = state_16390;
var statearr_16502_16687 = state_16390__$1;
(statearr_16502_16687[(2)] = inst_16122);

(statearr_16502_16687[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (2))){
var _ = (function (){var statearr_16503 = state_16390;
(statearr_16503[(4)] = cljs.core.cons((5),(state_16390[(4)])));

return statearr_16503;
})();
var inst_16098 = pred_changes;
var inst_16099 = cljs.core.seq(inst_16098);
var inst_16100 = cljs.core.first(inst_16099);
var inst_16101 = cljs.core.next(inst_16099);
var inst_16102 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16100,(0),null);
var inst_16103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16100,(1),null);
var inst_16104 = db;
var inst_16105 = inst_16098;
var inst_16106 = inst_16104;
var state_16390__$1 = (function (){var statearr_16504 = state_16390;
(statearr_16504[(32)] = inst_16103);

(statearr_16504[(33)] = inst_16102);

(statearr_16504[(16)] = inst_16106);

(statearr_16504[(21)] = inst_16105);

(statearr_16504[(34)] = inst_16101);

return statearr_16504;
})();
var statearr_16505_16688 = state_16390__$1;
(statearr_16505_16688[(2)] = null);

(statearr_16505_16688[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (66))){
var inst_16118 = (state_16390[(10)]);
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16247 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16248 = cljs.core.__destructure_map(inst_16247);
var inst_16249__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16248,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16250__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16248,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16251 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16250__$1,inst_16249__$1);
var state_16390__$1 = (function (){var statearr_16506 = state_16390;
(statearr_16506[(8)] = inst_16249__$1);

(statearr_16506[(9)] = inst_16250__$1);

return statearr_16506;
})();
if(inst_16251){
var statearr_16507_16689 = state_16390__$1;
(statearr_16507_16689[(1)] = (69));

} else {
var statearr_16508_16690 = state_16390__$1;
(statearr_16508_16690[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (107))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16332 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16249,inst_16250,throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16509_16691 = state_16390__$1;
(statearr_16509_16691[(2)] = inst_16332);

(statearr_16509_16691[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (23))){
var inst_16118 = (state_16390[(10)]);
var inst_16147 = (state_16390[(17)]);
var inst_16146 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16147__$1 = inst_16146 === true;
var state_16390__$1 = (function (){var statearr_16510 = state_16390;
(statearr_16510[(17)] = inst_16147__$1);

return statearr_16510;
})();
if(cljs.core.truth_(inst_16147__$1)){
var statearr_16511_16692 = state_16390__$1;
(statearr_16511_16692[(1)] = (26));

} else {
var statearr_16512_16693 = state_16390__$1;
(statearr_16512_16693[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (47))){
var inst_16118 = (state_16390[(10)]);
var inst_16203 = (state_16390[(30)]);
var inst_16202 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16203__$1 = cljs.core.not(inst_16202);
var state_16390__$1 = (function (){var statearr_16513 = state_16390;
(statearr_16513[(30)] = inst_16203__$1);

return statearr_16513;
})();
if(inst_16203__$1){
var statearr_16514_16694 = state_16390__$1;
(statearr_16514_16694[(1)] = (50));

} else {
var statearr_16515_16695 = state_16390__$1;
(statearr_16515_16695[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (35))){
var inst_16170 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16171 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16172 = cljs.core.PersistentHashMap.fromArrays(inst_16170,inst_16171);
var inst_16173 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_16172);
var inst_16174 = (function(){throw inst_16173})();
var state_16390__$1 = state_16390;
var statearr_16516_16696 = state_16390__$1;
(statearr_16516_16696[(2)] = inst_16174);

(statearr_16516_16696[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (82))){
var inst_16270 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16517_16697 = state_16390__$1;
(statearr_16517_16697[(2)] = inst_16270);

(statearr_16517_16697[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (76))){
var state_16390__$1 = state_16390;
var statearr_16518_16698 = state_16390__$1;
(statearr_16518_16698[(2)] = null);

(statearr_16518_16698[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (97))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16308 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16249,inst_16250,throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16519_16699 = state_16390__$1;
(statearr_16519_16699[(2)] = inst_16308);

(statearr_16519_16699[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (19))){
var inst_16118 = (state_16390[(10)]);
var inst_16142 = (state_16390[(24)]);
var inst_16141 = (state_16390[(2)]);
var inst_16142__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16118);
var state_16390__$1 = (function (){var statearr_16520 = state_16390;
(statearr_16520[(24)] = inst_16142__$1);

(statearr_16520[(26)] = inst_16141);

return statearr_16520;
})();
if(cljs.core.truth_(inst_16142__$1)){
var statearr_16521_16700 = state_16390__$1;
(statearr_16521_16700[(1)] = (20));

} else {
var statearr_16522_16701 = state_16390__$1;
(statearr_16522_16701[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (57))){
var state_16390__$1 = state_16390;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16523_16702 = state_16390__$1;
(statearr_16523_16702[(1)] = (60));

} else {
var statearr_16524_16703 = state_16390__$1;
(statearr_16524_16703[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (68))){
var inst_16118 = (state_16390[(10)]);
var inst_16347 = (state_16390[(27)]);
var inst_16345 = (state_16390[(2)]);
var inst_16346 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16347__$1 = inst_16346 === true;
var state_16390__$1 = (function (){var statearr_16525 = state_16390;
(statearr_16525[(7)] = inst_16345);

(statearr_16525[(27)] = inst_16347__$1);

return statearr_16525;
})();
if(cljs.core.truth_(inst_16347__$1)){
var statearr_16526_16704 = state_16390__$1;
(statearr_16526_16704[(1)] = (108));

} else {
var statearr_16527_16705 = state_16390__$1;
(statearr_16527_16705[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (11))){
var inst_16118 = (state_16390[(10)]);
var inst_16126 = (state_16390[(23)]);
var inst_16124 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16125 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16124);
var inst_16126__$1 = inst_16125 === false;
var state_16390__$1 = (function (){var statearr_16528 = state_16390;
(statearr_16528[(23)] = inst_16126__$1);

return statearr_16528;
})();
if(cljs.core.truth_(inst_16126__$1)){
var statearr_16529_16706 = state_16390__$1;
(statearr_16529_16706[(1)] = (14));

} else {
var statearr_16530_16707 = state_16390__$1;
(statearr_16530_16707[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (115))){
var inst_16353 = (state_16390[(29)]);
var state_16390__$1 = state_16390;
var statearr_16532_16708 = state_16390__$1;
(statearr_16532_16708[(2)] = inst_16353);

(statearr_16532_16708[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (9))){
var inst_16122 = (state_16390[(31)]);
var inst_16118 = (state_16390[(10)]);
var inst_16122__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16118);
var state_16390__$1 = (function (){var statearr_16533 = state_16390;
(statearr_16533[(31)] = inst_16122__$1);

return statearr_16533;
})();
if(cljs.core.truth_(inst_16122__$1)){
var statearr_16534_16709 = state_16390__$1;
(statearr_16534_16709[(1)] = (11));

} else {
var statearr_16535_16710 = state_16390__$1;
(statearr_16535_16710[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (5))){
var _ = (function (){var statearr_16536 = state_16390;
(statearr_16536[(4)] = cljs.core.rest((state_16390[(4)])));

return statearr_16536;
})();
var state_16390__$1 = state_16390;
var ex16531 = (state_16390__$1[(2)]);
var statearr_16537_16711 = state_16390__$1;
(statearr_16537_16711[(5)] = ex16531);


if((ex16531 instanceof Error)){
var statearr_16538_16712 = state_16390__$1;
(statearr_16538_16712[(1)] = (4));

(statearr_16538_16712[(5)] = null);

} else {
throw ex16531;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (112))){
var inst_16349 = (state_16390[(25)]);
var state_16390__$1 = state_16390;
var statearr_16539_16713 = state_16390__$1;
(statearr_16539_16713[(2)] = inst_16349);

(statearr_16539_16713[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (83))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16272 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16273 = (inst_16250.cljs$core$IFn$_invoke$arity$5 ? inst_16250.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16272,null) : inst_16250.call(null,cljs.core.PersistentArrayMap,null,3,inst_16272,null));
var inst_16274 = (inst_16250.cljs$core$IFn$_invoke$arity$4 ? inst_16250.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16273,null) : inst_16250.call(null,cljs.core.PersistentHashSet,null,inst_16273,null));
var inst_16275 = (inst_16274.cljs$core$IFn$_invoke$arity$1 ? inst_16274.cljs$core$IFn$_invoke$arity$1(inst_16249) : inst_16274.call(null,inst_16249));
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16275)){
var statearr_16540_16714 = state_16390__$1;
(statearr_16540_16714[(1)] = (84));

} else {
var statearr_16541_16715 = state_16390__$1;
(statearr_16541_16715[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (14))){
var inst_16118 = (state_16390[(10)]);
var inst_16128 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16129 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16128);
var inst_16130 = inst_16129 === true;
var state_16390__$1 = state_16390;
var statearr_16542_16716 = state_16390__$1;
(statearr_16542_16716[(2)] = inst_16130);

(statearr_16542_16716[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (45))){
var inst_16180 = (state_16390[(28)]);
var state_16390__$1 = state_16390;
var statearr_16543_16717 = state_16390__$1;
(statearr_16543_16717[(2)] = inst_16180);

(statearr_16543_16717[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (53))){
var inst_16117 = (state_16390[(15)]);
var inst_16106 = (state_16390[(16)]);
var inst_16209 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_16106,inst_16117);
var state_16390__$1 = state_16390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16390__$1,(56),inst_16209);
} else {
if((state_val_16391 === (78))){
var inst_16335 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16544_16718 = state_16390__$1;
(statearr_16544_16718[(2)] = inst_16335);

(statearr_16544_16718[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (26))){
var inst_16151 = (state_16390[(35)]);
var inst_16118 = (state_16390[(10)]);
var inst_16149 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16150 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16151__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16150);
var state_16390__$1 = (function (){var statearr_16545 = state_16390;
(statearr_16545[(35)] = inst_16151__$1);

return statearr_16545;
})();
if(inst_16151__$1){
var statearr_16546_16719 = state_16390__$1;
(statearr_16546_16719[(1)] = (29));

} else {
var statearr_16547_16720 = state_16390__$1;
(statearr_16547_16720[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (16))){
var inst_16133 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16548_16721 = state_16390__$1;
(statearr_16548_16721[(2)] = inst_16133);

(statearr_16548_16721[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (81))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16268 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16249,inst_16250,throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16549_16722 = state_16390__$1;
(statearr_16549_16722[(2)] = inst_16268);

(statearr_16549_16722[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (120))){
var inst_16370 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16371 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16372 = cljs.core.PersistentHashMap.fromArrays(inst_16370,inst_16371);
var inst_16373 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_16372);
var inst_16374 = (function(){throw inst_16373})();
var state_16390__$1 = state_16390;
var statearr_16550_16723 = state_16390__$1;
(statearr_16550_16723[(2)] = inst_16374);

(statearr_16550_16723[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (79))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16262 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16263 = (inst_16250.cljs$core$IFn$_invoke$arity$5 ? inst_16250.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16262,null) : inst_16250.call(null,cljs.core.PersistentArrayMap,null,2,inst_16262,null));
var inst_16264 = (inst_16250.cljs$core$IFn$_invoke$arity$4 ? inst_16250.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16263,null) : inst_16250.call(null,cljs.core.PersistentHashSet,null,inst_16263,null));
var inst_16265 = (inst_16264.cljs$core$IFn$_invoke$arity$1 ? inst_16264.cljs$core$IFn$_invoke$arity$1(inst_16249) : inst_16264.call(null,inst_16249));
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16265)){
var statearr_16551_16724 = state_16390__$1;
(statearr_16551_16724[(1)] = (80));

} else {
var statearr_16552_16725 = state_16390__$1;
(statearr_16552_16725[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (38))){
var inst_16118 = (state_16390[(10)]);
var inst_16184 = (state_16390[(36)]);
var inst_16183 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16184__$1 = cljs.core.not(inst_16183);
var state_16390__$1 = (function (){var statearr_16553 = state_16390;
(statearr_16553[(36)] = inst_16184__$1);

return statearr_16553;
})();
if(inst_16184__$1){
var statearr_16554_16726 = state_16390__$1;
(statearr_16554_16726[(1)] = (41));

} else {
var statearr_16555_16727 = state_16390__$1;
(statearr_16555_16727[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (98))){
var inst_16310 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16556_16728 = state_16390__$1;
(statearr_16556_16728[(2)] = inst_16310);

(statearr_16556_16728[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (87))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16282 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16283 = (inst_16250.cljs$core$IFn$_invoke$arity$5 ? inst_16250.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16282,null) : inst_16250.call(null,cljs.core.PersistentArrayMap,null,3,inst_16282,null));
var inst_16284 = (inst_16250.cljs$core$IFn$_invoke$arity$4 ? inst_16250.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16283,null) : inst_16250.call(null,cljs.core.PersistentHashSet,null,inst_16283,null));
var inst_16285 = (inst_16284.cljs$core$IFn$_invoke$arity$1 ? inst_16284.cljs$core$IFn$_invoke$arity$1(inst_16249) : inst_16284.call(null,inst_16249));
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16285)){
var statearr_16557_16729 = state_16390__$1;
(statearr_16557_16729[(1)] = (88));

} else {
var statearr_16558_16730 = state_16390__$1;
(statearr_16558_16730[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (30))){
var inst_16151 = (state_16390[(35)]);
var state_16390__$1 = state_16390;
var statearr_16559_16731 = state_16390__$1;
(statearr_16559_16731[(2)] = inst_16151);

(statearr_16559_16731[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (73))){
var state_16390__$1 = state_16390;
var statearr_16560_16732 = state_16390__$1;
(statearr_16560_16732[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (96))){
var inst_16237 = (state_16390[(12)]);
var state_16390__$1 = state_16390;
var statearr_16562_16733 = state_16390__$1;
(statearr_16562_16733[(2)] = inst_16237);

(statearr_16562_16733[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (10))){
var inst_16383 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16563_16734 = state_16390__$1;
(statearr_16563_16734[(2)] = inst_16383);

(statearr_16563_16734[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (18))){
var inst_16106 = (state_16390[(16)]);
var state_16390__$1 = state_16390;
var statearr_16564_16735 = state_16390__$1;
(statearr_16564_16735[(2)] = inst_16106);

(statearr_16564_16735[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (105))){
var inst_16249 = (state_16390[(8)]);
var inst_16250 = (state_16390[(9)]);
var inst_16328 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16249,inst_16250,throw_QMARK_);
var state_16390__$1 = state_16390;
var statearr_16565_16736 = state_16390__$1;
(statearr_16565_16736[(2)] = inst_16328);

(statearr_16565_16736[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (52))){
var inst_16219 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16566_16737 = state_16390__$1;
(statearr_16566_16737[(2)] = inst_16219);

(statearr_16566_16737[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (114))){
var inst_16118 = (state_16390[(10)]);
var inst_16355 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16356 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16355);
var inst_16357 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16356);
var inst_16358 = (!(inst_16357));
var state_16390__$1 = state_16390;
var statearr_16567_16738 = state_16390__$1;
(statearr_16567_16738[(2)] = inst_16358);

(statearr_16567_16738[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (67))){
var inst_16237 = (state_16390[(12)]);
var state_16390__$1 = state_16390;
var statearr_16568_16739 = state_16390__$1;
(statearr_16568_16739[(2)] = inst_16237);

(statearr_16568_16739[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (71))){
var inst_16342 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16569_16740 = state_16390__$1;
(statearr_16569_16740[(2)] = inst_16342);

(statearr_16569_16740[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (42))){
var inst_16184 = (state_16390[(36)]);
var state_16390__$1 = state_16390;
var statearr_16570_16741 = state_16390__$1;
(statearr_16570_16741[(2)] = inst_16184);

(statearr_16570_16741[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (80))){
var inst_16237 = (state_16390[(12)]);
var state_16390__$1 = state_16390;
var statearr_16571_16742 = state_16390__$1;
(statearr_16571_16742[(2)] = inst_16237);

(statearr_16571_16742[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (37))){
var inst_16177 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16572_16743 = state_16390__$1;
(statearr_16572_16743[(2)] = inst_16177);

(statearr_16572_16743[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (63))){
var inst_16118 = (state_16390[(10)]);
var inst_16240 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16241 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16240);
var state_16390__$1 = state_16390;
var statearr_16573_16744 = state_16390__$1;
(statearr_16573_16744[(2)] = inst_16241);

(statearr_16573_16744[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (94))){
var inst_16300 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
var statearr_16574_16745 = state_16390__$1;
(statearr_16574_16745[(2)] = inst_16300);

(statearr_16574_16745[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (8))){
var inst_16106 = (state_16390[(16)]);
var state_16390__$1 = state_16390;
var statearr_16575_16746 = state_16390__$1;
(statearr_16575_16746[(2)] = inst_16106);

(statearr_16575_16746[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (49))){
var inst_16222 = (state_16390[(2)]);
var state_16390__$1 = state_16390;
if(cljs.core.truth_(inst_16222)){
var statearr_16576_16747 = state_16390__$1;
(statearr_16576_16747[(1)] = (57));

} else {
var statearr_16577_16748 = state_16390__$1;
(statearr_16577_16748[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16391 === (84))){
var inst_16237 = (state_16390[(12)]);
var state_16390__$1 = state_16390;
var statearr_16578_16749 = state_16390__$1;
(statearr_16578_16749[(2)] = inst_16237);

(statearr_16578_16749[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2733__auto__ = null;
var fluree$db$query$schema$state_machine__2733__auto____0 = (function (){
var statearr_16579 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16579[(0)] = fluree$db$query$schema$state_machine__2733__auto__);

(statearr_16579[(1)] = (1));

return statearr_16579;
});
var fluree$db$query$schema$state_machine__2733__auto____1 = (function (state_16390){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_16390);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e16580){var ex__2736__auto__ = e16580;
var statearr_16581_16750 = state_16390;
(statearr_16581_16750[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_16390[(4)]))){
var statearr_16582_16751 = state_16390;
(statearr_16582_16751[(1)] = cljs.core.first((state_16390[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16752 = state_16390;
state_16390 = G__16752;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2733__auto__ = function(state_16390){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2733__auto____1.call(this,state_16390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2733__auto____0;
fluree$db$query$schema$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2733__auto____1;
return fluree$db$query$schema$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_16583 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_16583[(6)] = c__2755__auto__);

return statearr_16583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16754 = arguments.length;
switch (G__16754) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_16778){
var state_val_16779 = (state_16778[(1)]);
if((state_val_16779 === (7))){
var state_16778__$1 = state_16778;
var statearr_16780_16800 = state_16778__$1;
(statearr_16780_16800[(2)] = db);

(statearr_16780_16800[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16779 === (1))){
var state_16778__$1 = state_16778;
var statearr_16781_16801 = state_16778__$1;
(statearr_16781_16801[(2)] = null);

(statearr_16781_16801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16779 === (4))){
var inst_16755 = (state_16778[(2)]);
var state_16778__$1 = state_16778;
var statearr_16782_16802 = state_16778__$1;
(statearr_16782_16802[(2)] = inst_16755);

(statearr_16782_16802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16779 === (6))){
var inst_16764 = (state_16778[(7)]);
var inst_16763 = (state_16778[(2)]);
var inst_16764__$1 = fluree.db.util.async.throw_err(inst_16763);
var inst_16765 = cljs.core.empty_QMARK_(inst_16764__$1);
var state_16778__$1 = (function (){var statearr_16783 = state_16778;
(statearr_16783[(7)] = inst_16764__$1);

return statearr_16783;
})();
if(inst_16765){
var statearr_16784_16803 = state_16778__$1;
(statearr_16784_16803[(1)] = (7));

} else {
var statearr_16785_16804 = state_16778__$1;
(statearr_16785_16804[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16779 === (3))){
var inst_16776 = (state_16778[(2)]);
var state_16778__$1 = state_16778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16778__$1,inst_16776);
} else {
if((state_val_16779 === (2))){
var _ = (function (){var statearr_16787 = state_16778;
(statearr_16787[(4)] = cljs.core.cons((5),(state_16778[(4)])));

return statearr_16787;
})();
var inst_16761 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_16778__$1 = state_16778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16778__$1,(6),inst_16761);
} else {
if((state_val_16779 === (9))){
var inst_16773 = (state_16778[(2)]);
var _ = (function (){var statearr_16788 = state_16778;
(statearr_16788[(4)] = cljs.core.rest((state_16778[(4)])));

return statearr_16788;
})();
var state_16778__$1 = state_16778;
var statearr_16789_16805 = state_16778__$1;
(statearr_16789_16805[(2)] = inst_16773);

(statearr_16789_16805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16779 === (5))){
var _ = (function (){var statearr_16790 = state_16778;
(statearr_16790[(4)] = cljs.core.rest((state_16778[(4)])));

return statearr_16790;
})();
var state_16778__$1 = state_16778;
var ex16786 = (state_16778__$1[(2)]);
var statearr_16791_16806 = state_16778__$1;
(statearr_16791_16806[(5)] = ex16786);


if((ex16786 instanceof Error)){
var statearr_16792_16807 = state_16778__$1;
(statearr_16792_16807[(1)] = (4));

(statearr_16792_16807[(5)] = null);

} else {
throw ex16786;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16779 === (10))){
var inst_16770 = (state_16778[(2)]);
var inst_16771 = fluree.db.util.async.throw_err(inst_16770);
var state_16778__$1 = state_16778;
var statearr_16793_16808 = state_16778__$1;
(statearr_16793_16808[(2)] = inst_16771);

(statearr_16793_16808[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16779 === (8))){
var inst_16764 = (state_16778[(7)]);
var inst_16768 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_16764,db,true);
var state_16778__$1 = state_16778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16778__$1,(10),inst_16768);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2733__auto__ = null;
var fluree$db$query$schema$state_machine__2733__auto____0 = (function (){
var statearr_16794 = [null,null,null,null,null,null,null,null];
(statearr_16794[(0)] = fluree$db$query$schema$state_machine__2733__auto__);

(statearr_16794[(1)] = (1));

return statearr_16794;
});
var fluree$db$query$schema$state_machine__2733__auto____1 = (function (state_16778){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_16778);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e16795){var ex__2736__auto__ = e16795;
var statearr_16796_16809 = state_16778;
(statearr_16796_16809[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_16778[(4)]))){
var statearr_16797_16810 = state_16778;
(statearr_16797_16810[(1)] = cljs.core.first((state_16778[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16811 = state_16778;
state_16778 = G__16811;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2733__auto__ = function(state_16778){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2733__auto____1.call(this,state_16778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2733__auto____0;
fluree$db$query$schema$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2733__auto____1;
return fluree$db$query$schema$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_16798 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_16798[(6)] = c__2755__auto__);

return statearr_16798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16813 = arguments.length;
switch (G__16813) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16815 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16815,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16815,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16815,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4221__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4221__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__16818_SHARP_,p2__16819_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16818_SHARP_,p2__16819_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__16820_SHARP_){
var f = p1__16820_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_16886){
var state_val_16887 = (state_16886[(1)]);
if((state_val_16887 === (1))){
var state_16886__$1 = state_16886;
var statearr_16888_16906 = state_16886__$1;
(statearr_16888_16906[(2)] = null);

(statearr_16888_16906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16887 === (2))){
var _ = (function (){var statearr_16889 = state_16886;
(statearr_16889[(4)] = cljs.core.cons((5),(state_16886[(4)])));

return statearr_16889;
})();
var inst_16838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16839 = fluree.db.flake.max_subject_id((1));
var inst_16840 = [inst_16839];
var inst_16841 = (new cljs.core.PersistentVector(null,1,(5),inst_16838,inst_16840,null));
var inst_16842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16843 = [(0)];
var inst_16844 = (new cljs.core.PersistentVector(null,1,(5),inst_16842,inst_16843,null));
var inst_16845 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16841,cljs.core._LT__EQ_,inst_16844);
var state_16886__$1 = state_16886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16886__$1,(6),inst_16845);
} else {
if((state_val_16887 === (3))){
var inst_16884 = (state_16886[(2)]);
var state_16886__$1 = state_16886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16886__$1,inst_16884);
} else {
if((state_val_16887 === (4))){
var inst_16826 = (state_16886[(2)]);
var state_16886__$1 = state_16886;
var statearr_16891_16907 = state_16886__$1;
(statearr_16891_16907[(2)] = inst_16826);

(statearr_16891_16907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16887 === (5))){
var _ = (function (){var statearr_16892 = state_16886;
(statearr_16892[(4)] = cljs.core.rest((state_16886[(4)])));

return statearr_16892;
})();
var state_16886__$1 = state_16886;
var ex16890 = (state_16886__$1[(2)]);
var statearr_16893_16908 = state_16886__$1;
(statearr_16893_16908[(5)] = ex16890);


if((ex16890 instanceof Error)){
var statearr_16894_16909 = state_16886__$1;
(statearr_16894_16909[(1)] = (4));

(statearr_16894_16909[(5)] = null);

} else {
throw ex16890;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16887 === (6))){
var inst_16847 = (state_16886[(2)]);
var inst_16848 = fluree.db.util.async.throw_err(inst_16847);
var inst_16849 = (function (){var schema_flakes = inst_16848;
return (function (p1__16821_SHARP_){
return (p1__16821_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16850 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16849,inst_16848);
var inst_16851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16850,(0),null);
var inst_16852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16850,(1),null);
var inst_16853 = (function (){var schema_flakes = inst_16848;
var vec__16832 = inst_16850;
var collection_flakes = inst_16851;
var predicate_flakes = inst_16852;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__16824_SHARP_,p2__16823_SHARP_){
var f = p2__16823_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16824_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_16854 = [(-1),"_tx"];
var inst_16855 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16856 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16857 = cljs.core.PersistentHashMap.fromArrays(inst_16855,inst_16856);
var inst_16858 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16859 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16860 = cljs.core.PersistentHashMap.fromArrays(inst_16858,inst_16859);
var inst_16861 = [inst_16857,inst_16860];
var inst_16862 = cljs.core.PersistentHashMap.fromArrays(inst_16854,inst_16861);
var inst_16863 = (function (){var schema_flakes = inst_16848;
var vec__16832 = inst_16850;
var collection_flakes = inst_16851;
var predicate_flakes = inst_16852;
return (function (p1__16822_SHARP_){
return p1__16822_SHARP_.s;
});
})();
var inst_16864 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16863,inst_16851);
var inst_16865 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16853,inst_16862,inst_16864);
var inst_16867 = (function (){var schema_flakes = inst_16848;
var vec__16832 = inst_16850;
var collection_flakes = inst_16851;
var predicate_flakes = inst_16852;
var coll = inst_16865;
return (function (p__16866,pred_flakes){
var vec__16895 = p__16866;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16895,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16895,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__16898 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__16898.cljs$core$IFn$_invoke$arity$1 ? fexpr__16898.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__16898.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4223__auto__ = ref_QMARK_;
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_16868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16869 = cljs.core.PersistentHashMap.EMPTY;
var inst_16870 = cljs.core.PersistentHashSet.EMPTY;
var inst_16871 = [inst_16869,inst_16870];
var inst_16872 = (new cljs.core.PersistentVector(null,2,(5),inst_16868,inst_16871,null));
var inst_16873 = (function (){var schema_flakes = inst_16848;
var vec__16832 = inst_16850;
var collection_flakes = inst_16851;
var predicate_flakes = inst_16852;
var coll = inst_16865;
return (function (p1__16825_SHARP_){
return p1__16825_SHARP_.s;
});
})();
var inst_16874 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16873,inst_16852);
var inst_16875 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16867,inst_16872,inst_16874);
var inst_16876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16875,(0),null);
var inst_16877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16875,(1),null);
var inst_16878 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16879 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16880 = [inst_16879,inst_16865,inst_16876,inst_16877];
var inst_16881 = cljs.core.PersistentHashMap.fromArrays(inst_16878,inst_16880);
var _ = (function (){var statearr_16899 = state_16886;
(statearr_16899[(4)] = cljs.core.rest((state_16886[(4)])));

return statearr_16899;
})();
var state_16886__$1 = state_16886;
var statearr_16900_16910 = state_16886__$1;
(statearr_16900_16910[(2)] = inst_16881);

(statearr_16900_16910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2733__auto____0 = (function (){
var statearr_16901 = [null,null,null,null,null,null,null];
(statearr_16901[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2733__auto__);

(statearr_16901[(1)] = (1));

return statearr_16901;
});
var fluree$db$query$schema$schema_map_$_state_machine__2733__auto____1 = (function (state_16886){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_16886);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e16902){var ex__2736__auto__ = e16902;
var statearr_16903_16911 = state_16886;
(statearr_16903_16911[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_16886[(4)]))){
var statearr_16904_16912 = state_16886;
(statearr_16904_16912[(1)] = cljs.core.first((state_16886[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16913 = state_16886;
state_16886 = G__16913;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2733__auto__ = function(state_16886){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2733__auto____1.call(this,state_16886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2733__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2733__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_16905 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_16905[(6)] = c__2755__auto__);

return statearr_16905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_16955){
var state_val_16956 = (state_16955[(1)]);
if((state_val_16956 === (7))){
var inst_16938 = (state_16955[(2)]);
var inst_16939 = fluree.db.query.schema.flake__GT_pred_map(inst_16938);
var inst_16940 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16941 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16939,(114));
var inst_16942 = cljs.core.boolean$(inst_16941);
var inst_16943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16939,(110));
var inst_16944 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16939,(117));
var inst_16945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_16944);
var inst_16946 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16939,(111));
var inst_16947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16939,(115));
var inst_16948 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16939,(112));
var inst_16949 = [inst_16942,inst_16943,inst_16945,inst_16946,inst_16947,inst_16948];
var inst_16950 = cljs.core.PersistentHashMap.fromArrays(inst_16940,inst_16949);
var _ = (function (){var statearr_16957 = state_16955;
(statearr_16957[(4)] = cljs.core.rest((state_16955[(4)])));

return statearr_16957;
})();
var state_16955__$1 = state_16955;
var statearr_16958_16981 = state_16955__$1;
(statearr_16958_16981[(2)] = inst_16950);

(statearr_16958_16981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16956 === (1))){
var state_16955__$1 = state_16955;
var statearr_16959_16982 = state_16955__$1;
(statearr_16959_16982[(2)] = null);

(statearr_16959_16982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16956 === (4))){
var inst_16914 = (state_16955[(2)]);
var state_16955__$1 = state_16955;
var statearr_16960_16983 = state_16955__$1;
(statearr_16960_16983[(2)] = inst_16914);

(statearr_16960_16983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16956 === (6))){
var _ = (function (){var statearr_16961 = state_16955;
(statearr_16961[(4)] = cljs.core.cons((9),(state_16955[(4)])));

return statearr_16961;
})();
var inst_16926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16928 = ["_setting/id","root"];
var inst_16929 = (new cljs.core.PersistentVector(null,2,(5),inst_16927,inst_16928,null));
var inst_16930 = [inst_16929];
var inst_16931 = (new cljs.core.PersistentVector(null,1,(5),inst_16926,inst_16930,null));
var inst_16932 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16931);
var state_16955__$1 = state_16955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16955__$1,(10),inst_16932);
} else {
if((state_val_16956 === (3))){
var inst_16953 = (state_16955[(2)]);
var state_16955__$1 = state_16955;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16955__$1,inst_16953);
} else {
if((state_val_16956 === (2))){
var _ = (function (){var statearr_16964 = state_16955;
(statearr_16964[(4)] = cljs.core.cons((5),(state_16955[(4)])));

return statearr_16964;
})();
var state_16955__$1 = state_16955;
var statearr_16965_16984 = state_16955__$1;
(statearr_16965_16984[(2)] = null);

(statearr_16965_16984[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16956 === (9))){
var _ = (function (){var statearr_16966 = state_16955;
(statearr_16966[(4)] = cljs.core.rest((state_16955[(4)])));

return statearr_16966;
})();
var state_16955__$1 = state_16955;
var ex16962 = (state_16955__$1[(2)]);
var statearr_16967_16985 = state_16955__$1;
(statearr_16967_16985[(5)] = ex16962);


var statearr_16968_16986 = state_16955__$1;
(statearr_16968_16986[(1)] = (8));

(statearr_16968_16986[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16956 === (5))){
var _ = (function (){var statearr_16969 = state_16955;
(statearr_16969[(4)] = cljs.core.rest((state_16955[(4)])));

return statearr_16969;
})();
var state_16955__$1 = state_16955;
var ex16963 = (state_16955__$1[(2)]);
var statearr_16970_16987 = state_16955__$1;
(statearr_16970_16987[(5)] = ex16963);


if((ex16963 instanceof Error)){
var statearr_16971_16988 = state_16955__$1;
(statearr_16971_16988[(1)] = (4));

(statearr_16971_16988[(5)] = null);

} else {
throw ex16963;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16956 === (10))){
var inst_16934 = (state_16955[(2)]);
var inst_16935 = fluree.db.util.async.throw_err(inst_16934);
var _ = (function (){var statearr_16972 = state_16955;
(statearr_16972[(4)] = cljs.core.rest((state_16955[(4)])));

return statearr_16972;
})();
var state_16955__$1 = state_16955;
var statearr_16973_16989 = state_16955__$1;
(statearr_16973_16989[(2)] = inst_16935);

(statearr_16973_16989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16956 === (8))){
var inst_16920 = (state_16955[(2)]);
var state_16955__$1 = (function (){var statearr_16974 = state_16955;
(statearr_16974[(7)] = inst_16920);

return statearr_16974;
})();
var statearr_16975_16990 = state_16955__$1;
(statearr_16975_16990[(2)] = null);

(statearr_16975_16990[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2733__auto____0 = (function (){
var statearr_16976 = [null,null,null,null,null,null,null,null];
(statearr_16976[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2733__auto__);

(statearr_16976[(1)] = (1));

return statearr_16976;
});
var fluree$db$query$schema$setting_map_$_state_machine__2733__auto____1 = (function (state_16955){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_16955);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e16977){var ex__2736__auto__ = e16977;
var statearr_16978_16991 = state_16955;
(statearr_16978_16991[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_16955[(4)]))){
var statearr_16979_16992 = state_16955;
(statearr_16979_16992[(1)] = cljs.core.first((state_16955[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16993 = state_16955;
state_16955 = G__16993;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2733__auto__ = function(state_16955){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2733__auto____1.call(this,state_16955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2733__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2733__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_16980 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_16980[(6)] = c__2755__auto__);

return statearr_16980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
