// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19994_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19994_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19998 = coll;
var vec__19999 = G__19998;
var seq__20000 = cljs.core.seq(vec__19999);
var first__20001 = cljs.core.first(seq__20000);
var seq__20000__$1 = cljs.core.next(seq__20000);
var clause = first__20001;
var r = seq__20000__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19998__$1 = G__19998;
var res__$1 = res;
while(true){
var vec__20005 = G__19998__$1;
var seq__20006 = cljs.core.seq(vec__20005);
var first__20007 = cljs.core.first(seq__20006);
var seq__20006__$1 = cljs.core.next(seq__20006);
var clause__$1 = first__20007;
var r__$1 = seq__20006__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20008 = r__$1;
var G__20009 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19998__$1 = G__20008;
res__$1 = G__20009;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__20010){
var map__20011 = p__20010;
var map__20011__$1 = cljs.core.__destructure_map(map__20011);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20011__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__20015 = coll;
var vec__20016 = G__20015;
var seq__20017 = cljs.core.seq(vec__20016);
var first__20018 = cljs.core.first(seq__20017);
var seq__20017__$1 = cljs.core.next(seq__20017);
var clause = first__20018;
var r = seq__20017__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20015__$1 = G__20015;
var res__$1 = res;
while(true){
var vec__20022 = G__20015__$1;
var seq__20023 = cljs.core.seq(vec__20022);
var first__20024 = cljs.core.first(seq__20023);
var seq__20023__$1 = cljs.core.next(seq__20023);
var clause__$1 = first__20024;
var r__$1 = seq__20023__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20025 = r__$1;
var G__20026 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__20015__$1 = G__20025;
res__$1 = G__20026;
continue;
} else {
var G__20027 = r__$1;
var G__20028 = res__$2;
G__20015__$1 = G__20027;
res__$1 = G__20028;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__20032 = coll;
var vec__20033 = G__20032;
var seq__20034 = cljs.core.seq(vec__20033);
var first__20035 = cljs.core.first(seq__20034);
var seq__20034__$1 = cljs.core.next(seq__20034);
var clause = first__20035;
var r = seq__20034__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20032__$1 = G__20032;
var res__$1 = res;
while(true){
var vec__20039 = G__20032__$1;
var seq__20040 = cljs.core.seq(vec__20039);
var first__20041 = cljs.core.first(seq__20040);
var seq__20040__$1 = cljs.core.next(seq__20040);
var clause__$1 = first__20041;
var r__$1 = seq__20040__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20042 = r__$1;
var G__20043 = res__$2;
G__20032__$1 = G__20042;
res__$1 = G__20043;
continue;
} else {
var G__20044 = r__$1;
var G__20045 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__20032__$1 = G__20044;
res__$1 = G__20045;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4221__auto__ = typeof string === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4221__auto__;
}
})())){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__20046 = clause;
var G__20046__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__20046):G__20046);
var G__20046__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__20046__$1)
;
var G__20046__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__20046__$2)
;
var G__20046__$4 = goog.string.format("%s .",G__20046__$3)
;
if(cljs.core.truth_(optional_QMARK_)){
return goog.string.format("OPTIONAL {%s}",G__20046__$4);
} else {
return G__20046__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__20050 = opts;
var map__20050__$1 = cljs.core.__destructure_map(map__20050);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20050__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20050__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20050__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20050__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20050__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20047_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20047_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20048_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20048_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20049_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20049_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4223__auto__ = language;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20064){
var state_val_20065 = (state_20064[(1)]);
if((state_val_20065 === (1))){
var inst_20051 = fluree.db.util.core.url_encode(query);
var inst_20052 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20051)].join('');
var inst_20053 = ["User-Agent","Accept"];
var inst_20054 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_20055 = cljs.core.PersistentHashMap.fromArrays(inst_20053,inst_20054);
var inst_20056 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_20057 = [inst_20055,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_20058 = cljs.core.PersistentHashMap.fromArrays(inst_20056,inst_20057);
var inst_20059 = fluree.db.util.xhttp.get(inst_20052,inst_20058);
var state_20064__$1 = state_20064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20064__$1,(2),inst_20059);
} else {
if((state_val_20065 === (2))){
var inst_20061 = (state_20064[(2)]);
var inst_20062 = fluree.db.util.async.throw_err(inst_20061);
var state_20064__$1 = state_20064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20064__$1,inst_20062);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____0 = (function (){
var statearr_20066 = [null,null,null,null,null,null,null];
(statearr_20066[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__);

(statearr_20066[(1)] = (1));

return statearr_20066;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____1 = (function (state_20064){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20064);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20067){var ex__2736__auto__ = e20067;
var statearr_20068_20071 = state_20064;
(statearr_20068_20071[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20064[(4)]))){
var statearr_20069_20072 = state_20064;
(statearr_20069_20072[(1)] = cljs.core.first((state_20064[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20073 = state_20064;
state_20064 = G__20073;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__ = function(state_20064){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____1.call(this,state_20064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20070 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20070[(6)] = c__2755__auto__);

return statearr_20070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20091){
var state_val_20092 = (state_20091[(1)]);
if((state_val_20092 === (1))){
var inst_20074 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_20091__$1 = state_20091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20091__$1,(2),inst_20074);
} else {
if((state_val_20092 === (2))){
var inst_20077 = (state_20091[(7)]);
var inst_20076 = (state_20091[(2)]);
var inst_20077__$1 = fluree.db.util.async.throw_err(inst_20076);
var inst_20078 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_20077__$1);
var inst_20079 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_20078);
var state_20091__$1 = (function (){var statearr_20093 = state_20091;
(statearr_20093[(7)] = inst_20077__$1);

return statearr_20093;
})();
if(inst_20079){
var statearr_20094_20103 = state_20091__$1;
(statearr_20094_20103[(1)] = (3));

} else {
var statearr_20095_20104 = state_20091__$1;
(statearr_20095_20104[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (3))){
var inst_20077 = (state_20091[(7)]);
var state_20091__$1 = state_20091;
var statearr_20096_20105 = state_20091__$1;
(statearr_20096_20105[(2)] = inst_20077);

(statearr_20096_20105[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (4))){
var inst_20077 = (state_20091[(7)]);
var inst_20082 = (function (){var body = inst_20077;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_20083 = cljs.core.second(inst_20077);
var inst_20084 = cljs.core.second(inst_20083);
var inst_20085 = cljs.core.first(inst_20084);
var inst_20086 = cljs.core.second(inst_20085);
var inst_20087 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_20082,inst_20086);
var state_20091__$1 = state_20091;
var statearr_20097_20106 = state_20091__$1;
(statearr_20097_20106[(2)] = inst_20087);

(statearr_20097_20106[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20092 === (5))){
var inst_20089 = (state_20091[(2)]);
var state_20091__$1 = state_20091;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20091__$1,inst_20089);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____0 = (function (){
var statearr_20098 = [null,null,null,null,null,null,null,null];
(statearr_20098[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__);

(statearr_20098[(1)] = (1));

return statearr_20098;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____1 = (function (state_20091){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20091);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20099){var ex__2736__auto__ = e20099;
var statearr_20100_20107 = state_20091;
(statearr_20100_20107[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20091[(4)]))){
var statearr_20101_20108 = state_20091;
(statearr_20101_20108[(1)] = cljs.core.first((state_20091[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20109 = state_20091;
state_20091 = G__20109;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__ = function(state_20091){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____1.call(this,state_20091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20102 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20102[(6)] = c__2755__auto__);

return statearr_20102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20110_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20110_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20111_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20111_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20112_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__20112_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__20112_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__20112_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20158){
var state_val_20159 = (state_20158[(1)]);
if((state_val_20159 === (7))){
var inst_20123 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_20158__$1 = state_20158;
var statearr_20160_20188 = state_20158__$1;
(statearr_20160_20188[(2)] = inst_20123);

(statearr_20160_20188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (1))){
var state_20158__$1 = state_20158;
var statearr_20161_20189 = state_20158__$1;
(statearr_20161_20189[(2)] = null);

(statearr_20161_20189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (4))){
var inst_20113 = (state_20158[(2)]);
var state_20158__$1 = state_20158;
var statearr_20162_20190 = state_20158__$1;
(statearr_20162_20190[(2)] = inst_20113);

(statearr_20162_20190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (15))){
var inst_20137 = (state_20158[(7)]);
var inst_20132 = (state_20158[(8)]);
var inst_20131 = (state_20158[(9)]);
var inst_20142 = (state_20158[(2)]);
var inst_20143 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_20137,(0),inst_20142);
var inst_20144 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20145 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20131);
var inst_20146 = [inst_20132,inst_20145];
var inst_20147 = cljs.core.PersistentHashMap.fromArrays(inst_20144,inst_20146);
var inst_20148 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20143,inst_20147);
var inst_20149 = (function(){throw inst_20148})();
var state_20158__$1 = state_20158;
var statearr_20163_20191 = state_20158__$1;
(statearr_20163_20191[(2)] = inst_20149);

(statearr_20163_20191[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (13))){
var inst_20136 = (state_20158[(10)]);
var state_20158__$1 = state_20158;
var statearr_20164_20192 = state_20158__$1;
(statearr_20164_20192[(2)] = inst_20136);

(statearr_20164_20192[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (6))){
var state_20158__$1 = state_20158;
var statearr_20165_20193 = state_20158__$1;
(statearr_20165_20193[(2)] = null);

(statearr_20165_20193[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (3))){
var inst_20156 = (state_20158[(2)]);
var state_20158__$1 = state_20158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20158__$1,inst_20156);
} else {
if((state_val_20159 === (12))){
var inst_20153 = (state_20158[(2)]);
var _ = (function (){var statearr_20166 = state_20158;
(statearr_20166[(4)] = cljs.core.rest((state_20158[(4)])));

return statearr_20166;
})();
var state_20158__$1 = state_20158;
var statearr_20167_20194 = state_20158__$1;
(statearr_20167_20194[(2)] = inst_20153);

(statearr_20167_20194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (2))){
var _ = (function (){var statearr_20168 = state_20158;
(statearr_20168[(4)] = cljs.core.cons((5),(state_20158[(4)])));

return statearr_20168;
})();
var inst_20120 = cljs.core.empty_QMARK_(matching_vars);
var state_20158__$1 = state_20158;
if(inst_20120){
var statearr_20169_20195 = state_20158__$1;
(statearr_20169_20195[(1)] = (6));

} else {
var statearr_20170_20196 = state_20158__$1;
(statearr_20170_20196[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (11))){
var inst_20131 = (state_20158[(9)]);
var inst_20151 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_20131,all_vars);
var state_20158__$1 = state_20158;
var statearr_20172_20197 = state_20158__$1;
(statearr_20172_20197[(2)] = inst_20151);

(statearr_20172_20197[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (9))){
var inst_20132 = (state_20158[(8)]);
var inst_20131 = (state_20158[(9)]);
var inst_20129 = (state_20158[(2)]);
var inst_20130 = fluree.db.util.async.throw_err(inst_20129);
var inst_20131__$1 = cljs.core.__destructure_map(inst_20130);
var inst_20132__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20131__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20133 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20131__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20134 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_20132__$1);
var state_20158__$1 = (function (){var statearr_20173 = state_20158;
(statearr_20173[(11)] = inst_20133);

(statearr_20173[(8)] = inst_20132__$1);

(statearr_20173[(9)] = inst_20131__$1);

return statearr_20173;
})();
if(inst_20134){
var statearr_20174_20198 = state_20158__$1;
(statearr_20174_20198[(1)] = (10));

} else {
var statearr_20175_20199 = state_20158__$1;
(statearr_20175_20199[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (5))){
var _ = (function (){var statearr_20176 = state_20158;
(statearr_20176[(4)] = cljs.core.rest((state_20158[(4)])));

return statearr_20176;
})();
var state_20158__$1 = state_20158;
var ex20171 = (state_20158__$1[(2)]);
var statearr_20177_20200 = state_20158__$1;
(statearr_20177_20200[(5)] = ex20171);


if((ex20171 instanceof Error)){
var statearr_20178_20201 = state_20158__$1;
(statearr_20178_20201[(1)] = (4));

(statearr_20178_20201[(5)] = null);

} else {
throw ex20171;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (14))){
var state_20158__$1 = state_20158;
var statearr_20179_20202 = state_20158__$1;
(statearr_20179_20202[(2)] = (1000));

(statearr_20179_20202[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (10))){
var inst_20133 = (state_20158[(11)]);
var inst_20131 = (state_20158[(9)]);
var inst_20136 = (state_20158[(10)]);
var inst_20136__$1 = cljs.core.count(inst_20133);
var inst_20137 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20131);
var inst_20138 = (inst_20136__$1 < (1000));
var state_20158__$1 = (function (){var statearr_20180 = state_20158;
(statearr_20180[(7)] = inst_20137);

(statearr_20180[(10)] = inst_20136__$1);

return statearr_20180;
})();
if(cljs.core.truth_(inst_20138)){
var statearr_20181_20203 = state_20158__$1;
(statearr_20181_20203[(1)] = (13));

} else {
var statearr_20182_20204 = state_20158__$1;
(statearr_20182_20204[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (8))){
var inst_20125 = (state_20158[(2)]);
var inst_20126 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_20125,optional_clauses);
var inst_20127 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_20126);
var state_20158__$1 = state_20158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20158__$1,(9),inst_20127);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_20183 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20183[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__);

(statearr_20183[(1)] = (1));

return statearr_20183;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____1 = (function (state_20158){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20158);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20184){var ex__2736__auto__ = e20184;
var statearr_20185_20205 = state_20158;
(statearr_20185_20205[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20158[(4)]))){
var statearr_20186_20206 = state_20158;
(statearr_20186_20206[(1)] = cljs.core.first((state_20158[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20207 = state_20158;
state_20158 = G__20207;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__ = function(state_20158){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____1.call(this,state_20158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20187 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20187[(6)] = c__2755__auto__);

return statearr_20187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
