// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e20210){var e = e20210;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__20211_SHARP_){
var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__20211_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__20211_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__20211_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__20211_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20212_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20212_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20213_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20213_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4221__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4223__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20218 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20218,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20218,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20214_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20214_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4221__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4221__auto__;
}
})())){
var vec__20221 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20221,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20221,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4223__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20215_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20215_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20216_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20216_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20217_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20217_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20224_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__20224_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (add_amount > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fuel;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4221__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__20225 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__20225) : intersecting_vars.call(null,G__20225));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20228,optional_QMARK_,fuel,max_fuel){
var map__20229 = p__20228;
var map__20229__$1 = cljs.core.__destructure_map(map__20229);
var res = map__20229__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20229__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20295){
var state_val_20296 = (state_20295[(1)]);
if((state_val_20296 === (7))){
var inst_20284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20285 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_20286 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20285,clause);
var inst_20287 = [null,inst_20286];
var inst_20288 = (new cljs.core.PersistentVector(null,2,(5),inst_20284,inst_20287,null));
var state_20295__$1 = state_20295;
var statearr_20297_20325 = state_20295__$1;
(statearr_20297_20325[(2)] = inst_20288);

(statearr_20297_20325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (1))){
var state_20295__$1 = state_20295;
var statearr_20298_20326 = state_20295__$1;
(statearr_20298_20326[(2)] = null);

(statearr_20298_20326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (4))){
var inst_20230 = (state_20295[(2)]);
var state_20295__$1 = state_20295;
var statearr_20299_20327 = state_20295__$1;
(statearr_20299_20327[(2)] = inst_20230);

(statearr_20299_20327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (15))){
var inst_20273 = (state_20295[(2)]);
var inst_20274 = fluree.db.util.async.throw_err(inst_20273);
var inst_20275 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20274);
var inst_20276 = cljs.core.count(inst_20275);
var inst_20277 = fluree.db.query.analytical.add_fuel(inst_20276,fuel,max_fuel);
var inst_20278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20279 = [inst_20274,r];
var inst_20280 = (new cljs.core.PersistentVector(null,2,(5),inst_20278,inst_20279,null));
var state_20295__$1 = (function (){var statearr_20300 = state_20295;
(statearr_20300[(7)] = inst_20277);

return statearr_20300;
})();
var statearr_20301_20328 = state_20295__$1;
(statearr_20301_20328[(2)] = inst_20280);

(statearr_20301_20328[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (13))){
var inst_20239 = (state_20295[(8)]);
var inst_20252 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20253 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_20252);
var inst_20254 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20239);
var inst_20255 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20254);
var inst_20256 = cljs.core.set(inst_20255);
var inst_20257 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20253);
var inst_20258 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20257);
var inst_20259 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20256,inst_20258);
var inst_20260 = (function (){var all_wd = inst_20239;
var optional = inst_20253;
var all_wd_vars = inst_20256;
var all_vars = inst_20259;
return (function (p1__20226_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__20226_SHARP_) : all_vars.call(null,p1__20226_SHARP_));
});
})();
var inst_20261 = cljs.core.keys(vars);
var inst_20262 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20260,inst_20261);
var inst_20263 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_20262);
var inst_20264 = cljs.core.set(inst_20263);
var inst_20265 = (function (){var all_wd = inst_20239;
var optional = inst_20253;
var all_wd_vars = inst_20256;
var all_vars = inst_20259;
var intersecting_vars = inst_20264;
return (function (p1__20227_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__20227_SHARP_);
});
})();
var inst_20266 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20265,inst_20239);
var inst_20267 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20266);
var inst_20268 = fluree.db.query.analytical.select_from_tuples(inst_20267,res);
var inst_20269 = fluree.db.query.analytical.replace_vars_wikidata(inst_20239,inst_20264,vars);
var inst_20270 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_20264,inst_20259);
var inst_20271 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_20269,inst_20267,inst_20268,inst_20270,inst_20253);
var state_20295__$1 = state_20295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20295__$1,(15),inst_20271);
} else {
if((state_val_20296 === (6))){
var inst_20240 = (state_20295[(9)]);
var inst_20238 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20239 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_20238);
var inst_20240__$1 = optional_QMARK_;
var state_20295__$1 = (function (){var statearr_20302 = state_20295;
(statearr_20302[(9)] = inst_20240__$1);

(statearr_20302[(8)] = inst_20239);

return statearr_20302;
})();
if(cljs.core.truth_(inst_20240__$1)){
var statearr_20303_20329 = state_20295__$1;
(statearr_20303_20329[(1)] = (9));

} else {
var statearr_20304_20330 = state_20295__$1;
(statearr_20304_20330[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (3))){
var inst_20293 = (state_20295[(2)]);
var state_20295__$1 = state_20295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20295__$1,inst_20293);
} else {
if((state_val_20296 === (12))){
var inst_20248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20249 = [null,r];
var inst_20250 = (new cljs.core.PersistentVector(null,2,(5),inst_20248,inst_20249,null));
var state_20295__$1 = state_20295;
var statearr_20305_20331 = state_20295__$1;
(statearr_20305_20331[(2)] = inst_20250);

(statearr_20305_20331[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (2))){
var _ = (function (){var statearr_20306 = state_20295;
(statearr_20306[(4)] = cljs.core.cons((5),(state_20295[(4)])));

return statearr_20306;
})();
var inst_20236 = (r == null);
var state_20295__$1 = state_20295;
if(cljs.core.truth_(inst_20236)){
var statearr_20307_20332 = state_20295__$1;
(statearr_20307_20332[(1)] = (6));

} else {
var statearr_20308_20333 = state_20295__$1;
(statearr_20308_20333[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (11))){
var inst_20246 = (state_20295[(2)]);
var state_20295__$1 = state_20295;
if(cljs.core.truth_(inst_20246)){
var statearr_20310_20334 = state_20295__$1;
(statearr_20310_20334[(1)] = (12));

} else {
var statearr_20311_20335 = state_20295__$1;
(statearr_20311_20335[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (9))){
var inst_20239 = (state_20295[(8)]);
var inst_20242 = cljs.core.empty_QMARK_(inst_20239);
var inst_20243 = (!(inst_20242));
var state_20295__$1 = state_20295;
var statearr_20312_20336 = state_20295__$1;
(statearr_20312_20336[(2)] = inst_20243);

(statearr_20312_20336[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (5))){
var _ = (function (){var statearr_20313 = state_20295;
(statearr_20313[(4)] = cljs.core.rest((state_20295[(4)])));

return statearr_20313;
})();
var state_20295__$1 = state_20295;
var ex20309 = (state_20295__$1[(2)]);
var statearr_20314_20337 = state_20295__$1;
(statearr_20314_20337[(5)] = ex20309);


if((ex20309 instanceof Error)){
var statearr_20315_20338 = state_20295__$1;
(statearr_20315_20338[(1)] = (4));

(statearr_20315_20338[(5)] = null);

} else {
throw ex20309;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (14))){
var inst_20282 = (state_20295[(2)]);
var state_20295__$1 = state_20295;
var statearr_20316_20339 = state_20295__$1;
(statearr_20316_20339[(2)] = inst_20282);

(statearr_20316_20339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (10))){
var inst_20240 = (state_20295[(9)]);
var state_20295__$1 = state_20295;
var statearr_20317_20340 = state_20295__$1;
(statearr_20317_20340[(2)] = inst_20240);

(statearr_20317_20340[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20296 === (8))){
var inst_20290 = (state_20295[(2)]);
var _ = (function (){var statearr_20318 = state_20295;
(statearr_20318[(4)] = cljs.core.rest((state_20295[(4)])));

return statearr_20318;
})();
var state_20295__$1 = state_20295;
var statearr_20319_20341 = state_20295__$1;
(statearr_20319_20341[(2)] = inst_20290);

(statearr_20319_20341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_20320 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20320[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__);

(statearr_20320[(1)] = (1));

return statearr_20320;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____1 = (function (state_20295){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20295);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20321){var ex__2736__auto__ = e20321;
var statearr_20322_20342 = state_20295;
(statearr_20322_20342[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20295[(4)]))){
var statearr_20323_20343 = state_20295;
(statearr_20323_20343[(1)] = cljs.core.first((state_20295[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20344 = state_20295;
state_20295 = G__20344;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__ = function(state_20295){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____1.call(this,state_20295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20324 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20324[(6)] = c__2755__auto__);

return statearr_20324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20346 = arguments.length;
switch (G__20346) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20440){
var state_val_20441 = (state_20440[(1)]);
if((state_val_20441 === (7))){
var inst_20353 = (state_20440[(7)]);
var inst_20363 = clojure.string.starts_with_QMARK_(inst_20353,"$fdb");
var state_20440__$1 = state_20440;
if(inst_20363){
var statearr_20442_20491 = state_20440__$1;
(statearr_20442_20491[(1)] = (9));

} else {
var statearr_20443_20492 = state_20440__$1;
(statearr_20443_20492[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (20))){
var state_20440__$1 = state_20440;
var statearr_20444_20493 = state_20440__$1;
(statearr_20444_20493[(2)] = null);

(statearr_20444_20493[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (27))){
var inst_20403 = (state_20440[(8)]);
var state_20440__$1 = state_20440;
var statearr_20445_20494 = state_20440__$1;
(statearr_20445_20494[(2)] = inst_20403);

(statearr_20445_20494[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (1))){
var state_20440__$1 = state_20440;
var statearr_20446_20495 = state_20440__$1;
(statearr_20446_20495[(2)] = null);

(statearr_20446_20495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (24))){
var inst_20426 = (state_20440[(2)]);
var state_20440__$1 = state_20440;
var statearr_20447_20496 = state_20440__$1;
(statearr_20447_20496[(2)] = inst_20426);

(statearr_20447_20496[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (4))){
var inst_20347 = (state_20440[(2)]);
var state_20440__$1 = state_20440;
var statearr_20448_20497 = state_20440__$1;
(statearr_20448_20497[(2)] = inst_20347);

(statearr_20448_20497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (15))){
var inst_20370 = (state_20440[(9)]);
var inst_20376 = (state_20440[(2)]);
var inst_20377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20378 = cljs.core.PersistentVector.EMPTY;
var inst_20379 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20380 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20378,inst_20379);
var inst_20381 = [inst_20370,inst_20380];
var inst_20382 = (new cljs.core.PersistentVector(null,2,(5),inst_20377,inst_20381,null));
var state_20440__$1 = (function (){var statearr_20449 = state_20440;
(statearr_20449[(10)] = inst_20376);

return statearr_20449;
})();
var statearr_20450_20498 = state_20440__$1;
(statearr_20450_20498[(2)] = inst_20382);

(statearr_20450_20498[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (21))){
var inst_20429 = (state_20440[(2)]);
var state_20440__$1 = state_20440;
var statearr_20451_20499 = state_20440__$1;
(statearr_20451_20499[(2)] = inst_20429);

(statearr_20451_20499[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (13))){
var inst_20370 = (state_20440[(9)]);
var inst_20373 = (function(){throw inst_20370})();
var state_20440__$1 = state_20440;
var statearr_20452_20500 = state_20440__$1;
(statearr_20452_20500[(2)] = inst_20373);

(statearr_20452_20500[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (22))){
var inst_20394 = (state_20440[(11)]);
var inst_20392 = (state_20440[(12)]);
var inst_20396 = fluree.db.query.analytical.parse_block_from_source(inst_20392);
var inst_20397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20398 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20394];
var inst_20399 = (new cljs.core.PersistentVector(null,2,(5),inst_20397,inst_20398,null));
var inst_20400 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_20399);
var state_20440__$1 = (function (){var statearr_20453 = state_20440;
(statearr_20453[(13)] = inst_20396);

return statearr_20453;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20440__$1,(25),inst_20400);
} else {
if((state_val_20441 === (29))){
var inst_20407 = (state_20440[(2)]);
var inst_20408 = fluree.db.util.async.throw_err(inst_20407);
var state_20440__$1 = state_20440;
var statearr_20454_20501 = state_20440__$1;
(statearr_20454_20501[(2)] = inst_20408);

(statearr_20454_20501[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (6))){
var inst_20356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20357 = cljs.core.PersistentVector.EMPTY;
var inst_20358 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20359 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20357,inst_20358);
var inst_20360 = [db,inst_20359];
var inst_20361 = (new cljs.core.PersistentVector(null,2,(5),inst_20356,inst_20360,null));
var state_20440__$1 = state_20440;
var statearr_20455_20502 = state_20440__$1;
(statearr_20455_20502[(2)] = inst_20361);

(statearr_20455_20502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (28))){
var inst_20411 = (state_20440[(2)]);
var inst_20412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20413 = cljs.core.PersistentVector.EMPTY;
var inst_20414 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20415 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20413,inst_20414);
var inst_20416 = [inst_20411,inst_20415];
var inst_20417 = (new cljs.core.PersistentVector(null,2,(5),inst_20412,inst_20416,null));
var state_20440__$1 = state_20440;
var statearr_20456_20503 = state_20440__$1;
(statearr_20456_20503[(2)] = inst_20417);

(statearr_20456_20503[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (25))){
var inst_20396 = (state_20440[(13)]);
var inst_20402 = (state_20440[(2)]);
var inst_20403 = fluree.db.util.async.throw_err(inst_20402);
var state_20440__$1 = (function (){var statearr_20457 = state_20440;
(statearr_20457[(8)] = inst_20403);

return statearr_20457;
})();
if(cljs.core.truth_(inst_20396)){
var statearr_20458_20504 = state_20440__$1;
(statearr_20458_20504[(1)] = (26));

} else {
var statearr_20459_20505 = state_20440__$1;
(statearr_20459_20505[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (17))){
var state_20440__$1 = state_20440;
var statearr_20460_20506 = state_20440__$1;
(statearr_20460_20506[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (3))){
var inst_20438 = (state_20440[(2)]);
var state_20440__$1 = state_20440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20440__$1,inst_20438);
} else {
if((state_val_20441 === (12))){
var inst_20370 = (state_20440[(9)]);
var inst_20369 = (state_20440[(2)]);
var inst_20370__$1 = fluree.db.util.async.throw_err(inst_20369);
var inst_20371 = fluree.db.util.core.exception_QMARK_(inst_20370__$1);
var state_20440__$1 = (function (){var statearr_20462 = state_20440;
(statearr_20462[(9)] = inst_20370__$1);

return statearr_20462;
})();
if(inst_20371){
var statearr_20463_20507 = state_20440__$1;
(statearr_20463_20507[(1)] = (13));

} else {
var statearr_20464_20508 = state_20440__$1;
(statearr_20464_20508[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (2))){
var inst_20353 = (state_20440[(7)]);
var _ = (function (){var statearr_20465 = state_20440;
(statearr_20465[(4)] = cljs.core.cons((5),(state_20440[(4)])));

return statearr_20465;
})();
var inst_20353__$1 = cljs.core.first(clause);
var inst_20354 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_20353__$1);
var state_20440__$1 = (function (){var statearr_20466 = state_20440;
(statearr_20466[(7)] = inst_20353__$1);

return statearr_20466;
})();
if(inst_20354){
var statearr_20467_20509 = state_20440__$1;
(statearr_20467_20509[(1)] = (6));

} else {
var statearr_20468_20510 = state_20440__$1;
(statearr_20468_20510[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (23))){
var inst_20353 = (state_20440[(7)]);
var inst_20419 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20353)," is not supported in Fluree"].join('');
var inst_20420 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20421 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20422 = cljs.core.PersistentHashMap.fromArrays(inst_20420,inst_20421);
var inst_20423 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20419,inst_20422);
var inst_20424 = (function(){throw inst_20423})();
var state_20440__$1 = state_20440;
var statearr_20469_20511 = state_20440__$1;
(statearr_20469_20511[(2)] = inst_20424);

(statearr_20469_20511[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (19))){
var inst_20394 = (state_20440[(11)]);
var inst_20353 = (state_20440[(7)]);
var inst_20391 = fluree.db.query.analytical.isolate_source_name(inst_20353);
var inst_20392 = fluree.db.query.analytical.isolate_source_block(inst_20353);
var inst_20393 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_20391);
var inst_20394__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_20393);
var state_20440__$1 = (function (){var statearr_20470 = state_20440;
(statearr_20470[(11)] = inst_20394__$1);

(statearr_20470[(12)] = inst_20392);

return statearr_20470;
})();
if(cljs.core.truth_(inst_20394__$1)){
var statearr_20471_20512 = state_20440__$1;
(statearr_20471_20512[(1)] = (22));

} else {
var statearr_20472_20513 = state_20440__$1;
(statearr_20472_20513[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (11))){
var inst_20433 = (state_20440[(2)]);
var state_20440__$1 = state_20440;
var statearr_20474_20514 = state_20440__$1;
(statearr_20474_20514[(2)] = inst_20433);

(statearr_20474_20514[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (9))){
var inst_20353 = (state_20440[(7)]);
var inst_20365 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_20353,(4));
var inst_20366 = fluree.db.query.analytical.parse_block_from_source(inst_20365);
var inst_20367 = fluree.db.time_travel.as_of_block(db,inst_20366);
var state_20440__$1 = state_20440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20440__$1,(12),inst_20367);
} else {
if((state_val_20441 === (5))){
var _ = (function (){var statearr_20475 = state_20440;
(statearr_20475[(4)] = cljs.core.rest((state_20440[(4)])));

return statearr_20475;
})();
var state_20440__$1 = state_20440;
var ex20473 = (state_20440__$1[(2)]);
var statearr_20476_20515 = state_20440__$1;
(statearr_20476_20515[(5)] = ex20473);


if((ex20473 instanceof Error)){
var statearr_20477_20516 = state_20440__$1;
(statearr_20477_20516[(1)] = (4));

(statearr_20477_20516[(5)] = null);

} else {
throw ex20473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (14))){
var state_20440__$1 = state_20440;
var statearr_20478_20517 = state_20440__$1;
(statearr_20478_20517[(2)] = null);

(statearr_20478_20517[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (26))){
var inst_20403 = (state_20440[(8)]);
var inst_20396 = (state_20440[(13)]);
var inst_20405 = fluree.db.time_travel.as_of_block(inst_20403,inst_20396);
var state_20440__$1 = state_20440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20440__$1,(29),inst_20405);
} else {
if((state_val_20441 === (16))){
var inst_20386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20387 = ["$wd",clause];
var inst_20388 = (new cljs.core.PersistentVector(null,2,(5),inst_20386,inst_20387,null));
var state_20440__$1 = state_20440;
var statearr_20479_20518 = state_20440__$1;
(statearr_20479_20518[(2)] = inst_20388);

(statearr_20479_20518[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (10))){
var inst_20353 = (state_20440[(7)]);
var inst_20384 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_20353);
var state_20440__$1 = state_20440;
if(inst_20384){
var statearr_20480_20519 = state_20440__$1;
(statearr_20480_20519[(1)] = (16));

} else {
var statearr_20481_20520 = state_20440__$1;
(statearr_20481_20520[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (18))){
var inst_20431 = (state_20440[(2)]);
var state_20440__$1 = state_20440;
var statearr_20482_20521 = state_20440__$1;
(statearr_20482_20521[(2)] = inst_20431);

(statearr_20482_20521[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20441 === (8))){
var inst_20435 = (state_20440[(2)]);
var _ = (function (){var statearr_20483 = state_20440;
(statearr_20483[(4)] = cljs.core.rest((state_20440[(4)])));

return statearr_20483;
})();
var state_20440__$1 = state_20440;
var statearr_20484_20522 = state_20440__$1;
(statearr_20484_20522[(2)] = inst_20435);

(statearr_20484_20522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2733__auto__ = null;
var fluree$db$query$analytical$state_machine__2733__auto____0 = (function (){
var statearr_20485 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20485[(0)] = fluree$db$query$analytical$state_machine__2733__auto__);

(statearr_20485[(1)] = (1));

return statearr_20485;
});
var fluree$db$query$analytical$state_machine__2733__auto____1 = (function (state_20440){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20440);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20486){var ex__2736__auto__ = e20486;
var statearr_20487_20523 = state_20440;
(statearr_20487_20523[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20440[(4)]))){
var statearr_20488_20524 = state_20440;
(statearr_20488_20524[(1)] = cljs.core.first((state_20440[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20525 = state_20440;
state_20440 = G__20525;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2733__auto__ = function(state_20440){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2733__auto____1.call(this,state_20440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2733__auto____0;
fluree$db$query$analytical$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2733__auto____1;
return fluree$db$query$analytical$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20489 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20489[(6)] = c__2755__auto__);

return statearr_20489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__20526){
var vec__20527 = p__20526;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20527,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20527,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20530_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__20530_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__20534 = subjects;
var vec__20535 = G__20534;
var seq__20536 = cljs.core.seq(vec__20535);
var first__20537 = cljs.core.first(seq__20536);
var seq__20536__$1 = cljs.core.next(seq__20536);
var subject = first__20537;
var r = seq__20536__$1;
var acc = expanded_map;
var G__20534__$1 = G__20534;
var acc__$1 = acc;
while(true){
var vec__20541 = G__20534__$1;
var seq__20542 = cljs.core.seq(vec__20541);
var first__20543 = cljs.core.first(seq__20542);
var seq__20542__$1 = cljs.core.next(seq__20542);
var subject__$1 = first__20543;
var r__$1 = seq__20542__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20544 = r__$1;
var G__20545 = acc__$2;
G__20534__$1 = G__20544;
acc__$1 = G__20545;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__20534__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20541,seq__20542,first__20543,seq__20542__$1,subject__$1,r__$1,acc__$2,G__20534,vec__20535,seq__20536,first__20537,seq__20536__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4223__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20534__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20541,seq__20542,first__20543,seq__20542__$1,subject__$1,r__$1,acc__$2,G__20534,vec__20535,seq__20536,first__20537,seq__20536__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20534__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20541,seq__20542,first__20543,seq__20542__$1,subject__$1,r__$1,acc__$2,G__20534,vec__20535,seq__20536,first__20537,seq__20536__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20534__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20541,seq__20542,first__20543,seq__20542__$1,subject__$1,r__$1,acc__$2,G__20534,vec__20535,seq__20536,first__20537,seq__20536__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20534__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20541,seq__20542,first__20543,seq__20542__$1,subject__$1,r__$1,acc__$2,G__20534,vec__20535,seq__20536,first__20537,seq__20536__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20534__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20541,seq__20542,first__20543,seq__20542__$1,subject__$1,r__$1,acc__$2,G__20534,vec__20535,seq__20536,first__20537,seq__20536__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20546 = r__$1;
var G__20547 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20534__$1 = G__20546;
acc__$1 = G__20547;
continue;
} else {
var G__20548 = subjects;
var G__20549 = acc_STAR_;
G__20534__$1 = G__20548;
acc__$1 = G__20549;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20550_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20550_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20641){
var state_val_20642 = (state_20641[(1)]);
if((state_val_20642 === (7))){
var state_20641__$1 = state_20641;
var statearr_20643_20689 = state_20641__$1;
(statearr_20643_20689[(2)] = (100));

(statearr_20643_20689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (20))){
var inst_20590 = (state_20641[(7)]);
var state_20641__$1 = state_20641;
var statearr_20644_20690 = state_20641__$1;
(statearr_20644_20690[(2)] = inst_20590);

(statearr_20644_20690[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (1))){
var state_20641__$1 = state_20641;
var statearr_20645_20691 = state_20641__$1;
(statearr_20645_20691[(2)] = null);

(statearr_20645_20691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (24))){
var inst_20628 = (state_20641[(8)]);
var inst_20629 = (state_20641[(9)]);
var inst_20562 = (state_20641[(10)]);
var inst_20627 = (state_20641[(11)]);
var inst_20632 = (function (){var max_depth = inst_20562;
var recur_map__$1 = inst_20628;
var subjects = inst_20627;
var tuples = inst_20629;
return (function (p1__20551_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__20551_SHARP_)],null));
});
})();
var inst_20633 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20632,inst_20629);
var inst_20634 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_20633);
var state_20641__$1 = state_20641;
var statearr_20646_20692 = state_20641__$1;
(statearr_20646_20692[(2)] = inst_20634);

(statearr_20646_20692[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (4))){
var inst_20552 = (state_20641[(2)]);
var state_20641__$1 = state_20641;
var statearr_20647_20693 = state_20641__$1;
(statearr_20647_20693[(2)] = inst_20552);

(statearr_20647_20693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (15))){
var inst_20575 = (state_20641[(12)]);
var inst_20586 = cljs.core.PersistentVector.EMPTY;
var inst_20587 = cljs.core.seq(inst_20575);
var inst_20588 = cljs.core.first(inst_20587);
var inst_20589 = cljs.core.next(inst_20587);
var inst_20590 = inst_20586;
var inst_20591 = inst_20575;
var state_20641__$1 = (function (){var statearr_20648 = state_20641;
(statearr_20648[(13)] = inst_20589);

(statearr_20648[(14)] = inst_20591);

(statearr_20648[(15)] = inst_20588);

(statearr_20648[(7)] = inst_20590);

return statearr_20648;
})();
var statearr_20649_20694 = state_20641__$1;
(statearr_20649_20694[(2)] = null);

(statearr_20649_20694[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (21))){
var inst_20611 = (state_20641[(2)]);
var state_20641__$1 = state_20641;
var statearr_20650_20695 = state_20641__$1;
(statearr_20650_20695[(2)] = inst_20611);

(statearr_20650_20695[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (13))){
var inst_20624 = (state_20641[(2)]);
var state_20641__$1 = state_20641;
var statearr_20651_20696 = state_20641__$1;
(statearr_20651_20696[(2)] = inst_20624);

(statearr_20651_20696[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (22))){
var inst_20590 = (state_20641[(7)]);
var inst_20598 = (state_20641[(16)]);
var inst_20605 = (state_20641[(2)]);
var inst_20606 = fluree.db.util.async.throw_err(inst_20605);
var inst_20607 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20590,inst_20606);
var inst_20590__$1 = inst_20607;
var inst_20591 = inst_20598;
var state_20641__$1 = (function (){var statearr_20652 = state_20641;
(statearr_20652[(14)] = inst_20591);

(statearr_20652[(7)] = inst_20590__$1);

return statearr_20652;
})();
var statearr_20653_20697 = state_20641__$1;
(statearr_20653_20697[(2)] = null);

(statearr_20653_20697[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (6))){
var inst_20558 = (state_20641[(17)]);
var state_20641__$1 = state_20641;
var statearr_20654_20698 = state_20641__$1;
(statearr_20654_20698[(2)] = inst_20558);

(statearr_20654_20698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (25))){
var inst_20636 = (state_20641[(2)]);
var _ = (function (){var statearr_20655 = state_20641;
(statearr_20655[(4)] = cljs.core.rest((state_20641[(4)])));

return statearr_20655;
})();
var state_20641__$1 = state_20641;
var statearr_20656_20699 = state_20641__$1;
(statearr_20656_20699[(2)] = inst_20636);

(statearr_20656_20699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (17))){
var inst_20591 = (state_20641[(14)]);
var inst_20597 = (state_20641[(18)]);
var inst_20596 = cljs.core.seq(inst_20591);
var inst_20597__$1 = cljs.core.first(inst_20596);
var inst_20598 = cljs.core.next(inst_20596);
var state_20641__$1 = (function (){var statearr_20657 = state_20641;
(statearr_20657[(18)] = inst_20597__$1);

(statearr_20657[(16)] = inst_20598);

return statearr_20657;
})();
if(cljs.core.truth_(inst_20597__$1)){
var statearr_20658_20700 = state_20641__$1;
(statearr_20658_20700[(1)] = (19));

} else {
var statearr_20659_20701 = state_20641__$1;
(statearr_20659_20701[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (3))){
var inst_20639 = (state_20641[(2)]);
var state_20641__$1 = state_20641;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20641__$1,inst_20639);
} else {
if((state_val_20642 === (12))){
var inst_20564 = (state_20641[(19)]);
var inst_20575 = (state_20641[(12)]);
var inst_20570 = cljs.core.vals(inst_20564);
var inst_20571 = cljs.core.flatten(inst_20570);
var inst_20572 = cljs.core.set(inst_20571);
var inst_20573 = cljs.core.keys(inst_20564);
var inst_20574 = cljs.core.set(inst_20573);
var inst_20575__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_20572,inst_20574);
var inst_20576 = cljs.core.empty_QMARK_(inst_20575__$1);
var state_20641__$1 = (function (){var statearr_20660 = state_20641;
(statearr_20660[(12)] = inst_20575__$1);

return statearr_20660;
})();
if(inst_20576){
var statearr_20661_20702 = state_20641__$1;
(statearr_20661_20702[(1)] = (14));

} else {
var statearr_20662_20703 = state_20641__$1;
(statearr_20662_20703[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (2))){
var inst_20558 = (state_20641[(17)]);
var _ = (function (){var statearr_20663 = state_20641;
(statearr_20663[(4)] = cljs.core.cons((5),(state_20641[(4)])));

return statearr_20663;
})();
var inst_20558__$1 = depth;
var state_20641__$1 = (function (){var statearr_20664 = state_20641;
(statearr_20664[(17)] = inst_20558__$1);

return statearr_20664;
})();
if(cljs.core.truth_(inst_20558__$1)){
var statearr_20665_20704 = state_20641__$1;
(statearr_20665_20704[(1)] = (6));

} else {
var statearr_20666_20705 = state_20641__$1;
(statearr_20666_20705[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (23))){
var inst_20629 = (state_20641[(9)]);
var state_20641__$1 = state_20641;
var statearr_20667_20706 = state_20641__$1;
(statearr_20667_20706[(2)] = inst_20629);

(statearr_20667_20706[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (19))){
var inst_20597 = (state_20641[(18)]);
var inst_20600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20601 = [inst_20597,predicate];
var inst_20602 = (new cljs.core.PersistentVector(null,2,(5),inst_20600,inst_20601,null));
var inst_20603 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20602);
var state_20641__$1 = state_20641;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20641__$1,(22),inst_20603);
} else {
if((state_val_20642 === (11))){
var inst_20564 = (state_20641[(19)]);
var state_20641__$1 = state_20641;
var statearr_20669_20707 = state_20641__$1;
(statearr_20669_20707[(2)] = inst_20564);

(statearr_20669_20707[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (9))){
var inst_20565 = (state_20641[(20)]);
var inst_20562 = (state_20641[(10)]);
var inst_20567 = (inst_20565 >= inst_20562);
var state_20641__$1 = state_20641;
if(cljs.core.truth_(inst_20567)){
var statearr_20670_20708 = state_20641__$1;
(statearr_20670_20708[(1)] = (11));

} else {
var statearr_20671_20709 = state_20641__$1;
(statearr_20671_20709[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (5))){
var _ = (function (){var statearr_20672 = state_20641;
(statearr_20672[(4)] = cljs.core.rest((state_20641[(4)])));

return statearr_20672;
})();
var state_20641__$1 = state_20641;
var ex20668 = (state_20641__$1[(2)]);
var statearr_20673_20710 = state_20641__$1;
(statearr_20673_20710[(5)] = ex20668);


if((ex20668 instanceof Error)){
var statearr_20674_20711 = state_20641__$1;
(statearr_20674_20711[(1)] = (4));

(statearr_20674_20711[(5)] = null);

} else {
throw ex20668;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (14))){
var inst_20564 = (state_20641[(19)]);
var state_20641__$1 = state_20641;
var statearr_20675_20712 = state_20641__$1;
(statearr_20675_20712[(2)] = inst_20564);

(statearr_20675_20712[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (16))){
var inst_20622 = (state_20641[(2)]);
var state_20641__$1 = state_20641;
var statearr_20676_20713 = state_20641__$1;
(statearr_20676_20713[(2)] = inst_20622);

(statearr_20676_20713[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (10))){
var inst_20628 = (state_20641[(8)]);
var inst_20627 = (state_20641[(11)]);
var inst_20626 = (state_20641[(2)]);
var inst_20627__$1 = cljs.core.keys(inst_20626);
var inst_20628__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_20627__$1,inst_20626);
var inst_20629 = fluree.db.query.analytical.recur_map__GT_tuples(inst_20627__$1,inst_20628__$1);
var state_20641__$1 = (function (){var statearr_20677 = state_20641;
(statearr_20677[(8)] = inst_20628__$1);

(statearr_20677[(9)] = inst_20629);

(statearr_20677[(11)] = inst_20627__$1);

return statearr_20677;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20678_20714 = state_20641__$1;
(statearr_20678_20714[(1)] = (23));

} else {
var statearr_20679_20715 = state_20641__$1;
(statearr_20679_20715[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (18))){
var inst_20564 = (state_20641[(19)]);
var inst_20565 = (state_20641[(20)]);
var inst_20613 = (state_20641[(2)]);
var inst_20614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20615 = [(0),(2)];
var inst_20616 = (new cljs.core.PersistentVector(null,2,(5),inst_20614,inst_20615,null));
var inst_20617 = fluree.db.query.analytical.get_ns_arrays(inst_20616,inst_20613);
var inst_20618 = fluree.db.query.analytical.tuples__GT_map(inst_20564,inst_20617);
var inst_20619 = (inst_20565 + (1));
var inst_20564__$1 = inst_20618;
var inst_20565__$1 = inst_20619;
var state_20641__$1 = (function (){var statearr_20680 = state_20641;
(statearr_20680[(19)] = inst_20564__$1);

(statearr_20680[(20)] = inst_20565__$1);

return statearr_20680;
})();
var statearr_20681_20716 = state_20641__$1;
(statearr_20681_20716[(2)] = null);

(statearr_20681_20716[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (8))){
var inst_20562 = (state_20641[(2)]);
var inst_20563 = recur_map;
var inst_20564 = inst_20563;
var inst_20565 = (1);
var state_20641__$1 = (function (){var statearr_20682 = state_20641;
(statearr_20682[(19)] = inst_20564);

(statearr_20682[(20)] = inst_20565);

(statearr_20682[(10)] = inst_20562);

return statearr_20682;
})();
var statearr_20683_20717 = state_20641__$1;
(statearr_20683_20717[(2)] = null);

(statearr_20683_20717[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____0 = (function (){
var statearr_20684 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20684[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__);

(statearr_20684[(1)] = (1));

return statearr_20684;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____1 = (function (state_20641){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20641);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20685){var ex__2736__auto__ = e20685;
var statearr_20686_20718 = state_20641;
(statearr_20686_20718[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20641[(4)]))){
var statearr_20687_20719 = state_20641;
(statearr_20687_20719[(1)] = cljs.core.first((state_20641[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20720 = state_20641;
state_20641 = G__20720;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__ = function(state_20641){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____1.call(this,state_20641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20688 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20688[(6)] = c__2755__auto__);

return statearr_20688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20721,clause,fuel,max_fuel){
var map__20722 = p__20721;
var map__20722__$1 = cljs.core.__destructure_map(map__20722);
var res = map__20722__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20722__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20722__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20722__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20833){
var state_val_20834 = (state_20833[(1)]);
if((state_val_20834 === (7))){
var inst_20739 = (state_20833[(7)]);
var state_20833__$1 = state_20833;
var statearr_20835_20888 = state_20833__$1;
(statearr_20835_20888[(2)] = inst_20739);

(statearr_20835_20888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (20))){
var inst_20767 = (state_20833[(8)]);
var inst_20798 = typeof inst_20767 === 'number';
var state_20833__$1 = state_20833;
if(cljs.core.truth_(inst_20798)){
var statearr_20836_20889 = state_20833__$1;
(statearr_20836_20889[(1)] = (22));

} else {
var statearr_20837_20890 = state_20833__$1;
(statearr_20837_20890[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (27))){
var inst_20813 = (state_20833[(2)]);
var state_20833__$1 = state_20833;
var statearr_20838_20891 = state_20833__$1;
(statearr_20838_20891[(2)] = inst_20813);

(statearr_20838_20891[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (1))){
var state_20833__$1 = state_20833;
var statearr_20839_20892 = state_20833__$1;
(statearr_20839_20892[(2)] = null);

(statearr_20839_20892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (24))){
var inst_20815 = (state_20833[(2)]);
var state_20833__$1 = state_20833;
var statearr_20840_20893 = state_20833__$1;
(statearr_20840_20893[(2)] = inst_20815);

(statearr_20840_20893[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (4))){
var inst_20723 = (state_20833[(2)]);
var state_20833__$1 = state_20833;
var statearr_20841_20894 = state_20833__$1;
(statearr_20841_20894[(2)] = inst_20723);

(statearr_20841_20894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (15))){
var inst_20781 = (state_20833[(2)]);
var inst_20782 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_20783 = fluree.db.query.analytical.variable_QMARK_(inst_20782);
var state_20833__$1 = (function (){var statearr_20842 = state_20833;
(statearr_20842[(9)] = inst_20781);

return statearr_20842;
})();
if(cljs.core.truth_(inst_20783)){
var statearr_20843_20895 = state_20833__$1;
(statearr_20843_20895[(1)] = (16));

} else {
var statearr_20844_20896 = state_20833__$1;
(statearr_20844_20896[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (21))){
var inst_20740 = (state_20833[(10)]);
var inst_20770 = (state_20833[(11)]);
var inst_20769 = (state_20833[(12)]);
var inst_20817 = (state_20833[(2)]);
var inst_20818 = fluree.db.query.analytical.tuples__GT_recur(db,inst_20770,inst_20817,inst_20740,inst_20769);
var state_20833__$1 = state_20833;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20833__$1,(28),inst_20818);
} else {
if((state_val_20834 === (13))){
var inst_20749 = (state_20833[(13)]);
var inst_20773 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20749)].join('');
var inst_20774 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20775 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20776 = cljs.core.PersistentHashMap.fromArrays(inst_20774,inst_20775);
var inst_20777 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20773,inst_20776);
var inst_20778 = (function(){throw inst_20777})();
var state_20833__$1 = state_20833;
var statearr_20845_20897 = state_20833__$1;
(statearr_20845_20897[(2)] = inst_20778);

(statearr_20845_20897[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (22))){
var inst_20765 = (state_20833[(14)]);
var inst_20767 = (state_20833[(8)]);
var inst_20800 = cljs.core.PersistentHashMap.EMPTY;
var inst_20801 = cljs.core.flatten(inst_20765);
var inst_20802 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20800,inst_20767,inst_20801);
var state_20833__$1 = state_20833;
var statearr_20846_20898 = state_20833__$1;
(statearr_20846_20898[(2)] = inst_20802);

(statearr_20846_20898[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (6))){
var inst_20751 = (state_20833[(15)]);
var state_20833__$1 = state_20833;
var statearr_20847_20899 = state_20833__$1;
(statearr_20847_20899[(2)] = inst_20751);

(statearr_20847_20899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (28))){
var inst_20820 = (state_20833[(2)]);
var inst_20821 = fluree.db.util.async.throw_err(inst_20820);
var state_20833__$1 = state_20833;
var statearr_20848_20900 = state_20833__$1;
(statearr_20848_20900[(2)] = inst_20821);

(statearr_20848_20900[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (25))){
var inst_20765 = (state_20833[(14)]);
var inst_20761 = (state_20833[(16)]);
var inst_20806 = cljs.core.PersistentHashMap.EMPTY;
var inst_20807 = cljs.core.first(inst_20761);
var inst_20808 = cljs.core.first(inst_20807);
var inst_20809 = cljs.core.flatten(inst_20765);
var inst_20810 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20806,inst_20808,inst_20809);
var state_20833__$1 = state_20833;
var statearr_20849_20901 = state_20833__$1;
(statearr_20849_20901[(2)] = inst_20810);

(statearr_20849_20901[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (17))){
var inst_20749 = (state_20833[(13)]);
var inst_20786 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20749)].join('');
var inst_20787 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20788 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20789 = cljs.core.PersistentHashMap.fromArrays(inst_20787,inst_20788);
var inst_20790 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20786,inst_20789);
var inst_20791 = (function(){throw inst_20790})();
var state_20833__$1 = state_20833;
var statearr_20850_20902 = state_20833__$1;
(statearr_20850_20902[(2)] = inst_20791);

(statearr_20850_20902[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (3))){
var inst_20831 = (state_20833[(2)]);
var state_20833__$1 = state_20833;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20833__$1,inst_20831);
} else {
if((state_val_20834 === (12))){
var inst_20736 = (state_20833[(17)]);
var inst_20824 = (state_20833[(2)]);
var inst_20825 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20826 = cljs.core.keys(inst_20736);
var inst_20827 = [inst_20826,vars,inst_20824];
var inst_20828 = cljs.core.PersistentHashMap.fromArrays(inst_20825,inst_20827);
var _ = (function (){var statearr_20851 = state_20833;
(statearr_20851[(4)] = cljs.core.rest((state_20833[(4)])));

return statearr_20851;
})();
var state_20833__$1 = state_20833;
var statearr_20852_20903 = state_20833__$1;
(statearr_20852_20903[(2)] = inst_20828);

(statearr_20852_20903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (2))){
var inst_20740 = (state_20833[(10)]);
var inst_20739 = (state_20833[(7)]);
var inst_20751 = (state_20833[(15)]);
var inst_20736 = (state_20833[(17)]);
var _ = (function (){var statearr_20853 = state_20833;
(statearr_20853[(4)] = cljs.core.cons((5),(state_20833[(4)])));

return statearr_20853;
})();
var inst_20733 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_20734 = cljs.core.__destructure_map(inst_20733);
var inst_20735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20734,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20736__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20734,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20734,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20738 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_20739__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20737);
var inst_20740__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20737);
var inst_20742 = (function (){var map__20729 = inst_20734;
var search = inst_20735;
var rel = inst_20736__$1;
var opts = inst_20737;
var common_keys = inst_20738;
var object_fn = inst_20739__$1;
var recur_depth = inst_20740__$1;
return (function (p__20741,common_key){
var vec__20854 = p__20741;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20854,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20854,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20857 = cljs.core._EQ_;
var expr__20858 = idx_of;
if(cljs.core.truth_((pred__20857.cljs$core$IFn$_invoke$arity$2 ? pred__20857.cljs$core$IFn$_invoke$arity$2((0),expr__20858) : pred__20857.call(null,(0),expr__20858)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__20857.cljs$core$IFn$_invoke$arity$2 ? pred__20857.cljs$core$IFn$_invoke$arity$2((1),expr__20858) : pred__20857.call(null,(1),expr__20858)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__20857.cljs$core$IFn$_invoke$arity$2 ? pred__20857.cljs$core$IFn$_invoke$arity$2((2),expr__20858) : pred__20857.call(null,(2),expr__20858)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20858)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4221__auto__ = (!(single_v_QMARK_));
if(and__4221__auto__){
var and__4221__auto____$1 = object_fn;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20744 = cljs.core.PersistentHashMap.EMPTY;
var inst_20745 = [inst_20744,inst_20735];
var inst_20746 = (new cljs.core.PersistentVector(null,2,(5),inst_20743,inst_20745,null));
var inst_20747 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20742,inst_20746,inst_20738);
var inst_20748 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20747,(0),null);
var inst_20749 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20747,(1),null);
var inst_20750 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20751__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20748);
var state_20833__$1 = (function (){var statearr_20860 = state_20833;
(statearr_20860[(10)] = inst_20740__$1);

(statearr_20860[(7)] = inst_20739__$1);

(statearr_20860[(15)] = inst_20751__$1);

(statearr_20860[(13)] = inst_20749);

(statearr_20860[(17)] = inst_20736__$1);

(statearr_20860[(18)] = inst_20750);

return statearr_20860;
})();
if(cljs.core.truth_(inst_20751__$1)){
var statearr_20861_20904 = state_20833__$1;
(statearr_20861_20904[(1)] = (6));

} else {
var statearr_20862_20905 = state_20833__$1;
(statearr_20862_20905[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (23))){
var inst_20767 = (state_20833[(8)]);
var inst_20804 = cljs.core.coll_QMARK_(inst_20767);
var state_20833__$1 = state_20833;
if(inst_20804){
var statearr_20863_20906 = state_20833__$1;
(statearr_20863_20906[(1)] = (25));

} else {
var statearr_20864_20907 = state_20833__$1;
(statearr_20864_20907[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (19))){
var inst_20765 = (state_20833[(14)]);
var inst_20795 = cljs.core.PersistentHashMap.EMPTY;
var inst_20796 = fluree.db.query.analytical.tuples__GT_map(inst_20795,inst_20765);
var state_20833__$1 = state_20833;
var statearr_20865_20908 = state_20833__$1;
(statearr_20865_20908[(2)] = inst_20796);

(statearr_20865_20908[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (11))){
var inst_20765 = (state_20833[(14)]);
var state_20833__$1 = state_20833;
var statearr_20867_20909 = state_20833__$1;
(statearr_20867_20909[(2)] = inst_20765);

(statearr_20867_20909[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (9))){
var inst_20740 = (state_20833[(10)]);
var inst_20736 = (state_20833[(17)]);
var inst_20761 = (state_20833[(16)]);
var inst_20760 = (state_20833[(2)]);
var inst_20761__$1 = fluree.db.util.async.throw_err(inst_20760);
var inst_20762 = cljs.core.count(inst_20761__$1);
var inst_20763 = fluree.db.query.analytical.add_fuel(inst_20762,fuel,max_fuel);
var inst_20764 = cljs.core.vals(inst_20736);
var inst_20765 = fluree.db.query.analytical.get_ns_arrays(inst_20764,inst_20761__$1);
var state_20833__$1 = (function (){var statearr_20868 = state_20833;
(statearr_20868[(14)] = inst_20765);

(statearr_20868[(19)] = inst_20763);

(statearr_20868[(16)] = inst_20761__$1);

return statearr_20868;
})();
if(cljs.core.truth_(inst_20740)){
var statearr_20869_20910 = state_20833__$1;
(statearr_20869_20910[(1)] = (10));

} else {
var statearr_20870_20911 = state_20833__$1;
(statearr_20870_20911[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (5))){
var _ = (function (){var statearr_20871 = state_20833;
(statearr_20871[(4)] = cljs.core.rest((state_20833[(4)])));

return statearr_20871;
})();
var state_20833__$1 = state_20833;
var ex20866 = (state_20833__$1[(2)]);
var statearr_20872_20912 = state_20833__$1;
(statearr_20872_20912[(5)] = ex20866);


if((ex20866 instanceof Error)){
var statearr_20873_20913 = state_20833__$1;
(statearr_20873_20913[(1)] = (4));

(statearr_20873_20913[(5)] = null);

} else {
throw ex20866;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (14))){
var state_20833__$1 = state_20833;
var statearr_20874_20914 = state_20833__$1;
(statearr_20874_20914[(2)] = null);

(statearr_20874_20914[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (26))){
var state_20833__$1 = state_20833;
var statearr_20875_20915 = state_20833__$1;
(statearr_20875_20915[(2)] = null);

(statearr_20875_20915[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (16))){
var state_20833__$1 = state_20833;
var statearr_20876_20916 = state_20833__$1;
(statearr_20876_20916[(2)] = null);

(statearr_20876_20916[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (10))){
var inst_20749 = (state_20833[(13)]);
var inst_20770 = (state_20833[(11)]);
var inst_20767 = cljs.core.first(inst_20749);
var inst_20768 = cljs.core.first(clause);
var inst_20769 = fluree.db.query.analytical.variable_QMARK_(inst_20768);
var inst_20770__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_20749,(1));
var inst_20771 = fluree.db.query.analytical.variable_QMARK_(inst_20770__$1);
var state_20833__$1 = (function (){var statearr_20877 = state_20833;
(statearr_20877[(8)] = inst_20767);

(statearr_20877[(11)] = inst_20770__$1);

(statearr_20877[(12)] = inst_20769);

return statearr_20877;
})();
if(cljs.core.truth_(inst_20771)){
var statearr_20878_20917 = state_20833__$1;
(statearr_20878_20917[(1)] = (13));

} else {
var statearr_20879_20918 = state_20833__$1;
(statearr_20879_20918[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (18))){
var inst_20769 = (state_20833[(12)]);
var inst_20793 = (state_20833[(2)]);
var state_20833__$1 = (function (){var statearr_20880 = state_20833;
(statearr_20880[(20)] = inst_20793);

return statearr_20880;
})();
if(cljs.core.truth_(inst_20769)){
var statearr_20881_20919 = state_20833__$1;
(statearr_20881_20919[(1)] = (19));

} else {
var statearr_20882_20920 = state_20833__$1;
(statearr_20882_20920[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20834 === (8))){
var inst_20749 = (state_20833[(13)]);
var inst_20750 = (state_20833[(18)]);
var inst_20755 = (state_20833[(2)]);
var inst_20756 = [inst_20755];
var inst_20757 = cljs.core.PersistentHashMap.fromArrays(inst_20750,inst_20756);
var inst_20758 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_20749,inst_20757);
var state_20833__$1 = state_20833;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20833__$1,(9),inst_20758);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_20883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20883[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__);

(statearr_20883[(1)] = (1));

return statearr_20883;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____1 = (function (state_20833){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20833);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20884){var ex__2736__auto__ = e20884;
var statearr_20885_20921 = state_20833;
(statearr_20885_20921[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20833[(4)]))){
var statearr_20886_20922 = state_20833;
(statearr_20886_20922[(1)] = cljs.core.first((state_20833[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20923 = state_20833;
state_20833 = G__20923;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__ = function(state_20833){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____1.call(this,state_20833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20887 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20887[(6)] = c__2755__auto__);

return statearr_20887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20924,res,clause){
var map__20925 = p__20924;
var map__20925__$1 = cljs.core.__destructure_map(map__20925);
var db = map__20925__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20925__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20925__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20925__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21024){
var state_val_21025 = (state_21024[(1)]);
if((state_val_21025 === (7))){
var inst_20935 = (state_21024[(7)]);
var state_21024__$1 = state_21024;
var statearr_21026_21066 = state_21024__$1;
(statearr_21026_21066[(2)] = inst_20935);

(statearr_21026_21066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (20))){
var inst_21015 = (state_21024[(2)]);
var state_21024__$1 = state_21024;
var statearr_21027_21067 = state_21024__$1;
(statearr_21027_21067[(2)] = inst_21015);

(statearr_21027_21067[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (1))){
var state_21024__$1 = state_21024;
var statearr_21028_21068 = state_21024__$1;
(statearr_21028_21068[(2)] = null);

(statearr_21028_21068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (24))){
var inst_20994 = (state_21024[(2)]);
var inst_20995 = fluree.db.util.async.throw_err(inst_20994);
var state_21024__$1 = state_21024;
var statearr_21029_21069 = state_21024__$1;
(statearr_21029_21069[(2)] = inst_20995);

(statearr_21029_21069[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (4))){
var inst_20928 = (state_21024[(2)]);
var state_21024__$1 = state_21024;
var statearr_21030_21070 = state_21024__$1;
(statearr_21030_21070[(2)] = inst_20928);

(statearr_21030_21070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (15))){
var inst_20935 = (state_21024[(7)]);
var inst_20937 = (state_21024[(8)]);
var inst_20956 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20957 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20959 = [inst_20935];
var inst_20960 = (new cljs.core.PersistentVector(null,1,(5),inst_20958,inst_20959,null));
var inst_20961 = (function (){var subject_var = inst_20935;
var object_var = inst_20937;
var min_sid = inst_20956;
var max_sid = (0);
return (function (p1__20926_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20926_SHARP_);
});
})();
var inst_20962 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20956,(0));
var inst_20963 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20961,inst_20962);
var inst_20964 = cljs.core.PersistentHashMap.EMPTY;
var inst_20965 = [inst_20960,inst_20963,inst_20964];
var inst_20966 = cljs.core.PersistentHashMap.fromArrays(inst_20957,inst_20965);
var state_21024__$1 = state_21024;
var statearr_21031_21071 = state_21024__$1;
(statearr_21031_21071[(2)] = inst_20966);

(statearr_21031_21071[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (21))){
var inst_20988 = (state_21024[(9)]);
var state_21024__$1 = state_21024;
var statearr_21032_21072 = state_21024__$1;
(statearr_21032_21072[(2)] = inst_20988);

(statearr_21032_21072[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (13))){
var inst_20937 = (state_21024[(8)]);
var state_21024__$1 = state_21024;
if(cljs.core.truth_(inst_20937)){
var statearr_21033_21073 = state_21024__$1;
(statearr_21033_21073[(1)] = (18));

} else {
var statearr_21034_21074 = state_21024__$1;
(statearr_21034_21074[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (22))){
var inst_20988 = (state_21024[(9)]);
var inst_20992 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_20988);
var state_21024__$1 = state_21024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21024__$1,(24),inst_20992);
} else {
if((state_val_21025 === (6))){
var inst_20937 = (state_21024[(8)]);
var state_21024__$1 = state_21024;
var statearr_21035_21075 = state_21024__$1;
(statearr_21035_21075[(2)] = inst_20937);

(statearr_21035_21075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (17))){
var inst_20985 = (state_21024[(2)]);
var state_21024__$1 = state_21024;
var statearr_21036_21076 = state_21024__$1;
(statearr_21036_21076[(2)] = inst_20985);

(statearr_21036_21076[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (3))){
var inst_21022 = (state_21024[(2)]);
var state_21024__$1 = state_21024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21024__$1,inst_21022);
} else {
if((state_val_21025 === (12))){
var inst_20950 = ["_tx",null,"_block",null];
var inst_20951 = (new cljs.core.PersistentArrayMap(null,2,inst_20950,null));
var inst_20952 = (new cljs.core.PersistentHashSet(null,inst_20951,null));
var inst_20953 = cljs.core.last(clause);
var inst_20954 = (inst_20952.cljs$core$IFn$_invoke$arity$1 ? inst_20952.cljs$core$IFn$_invoke$arity$1(inst_20953) : inst_20952.call(null,inst_20953));
var state_21024__$1 = state_21024;
if(cljs.core.truth_(inst_20954)){
var statearr_21037_21077 = state_21024__$1;
(statearr_21037_21077[(1)] = (15));

} else {
var statearr_21038_21078 = state_21024__$1;
(statearr_21038_21078[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (2))){
var inst_20935 = (state_21024[(7)]);
var _ = (function (){var statearr_21039 = state_21024;
(statearr_21039[(4)] = cljs.core.cons((5),(state_21024[(4)])));

return statearr_21039;
})();
var inst_20934 = cljs.core.first(clause);
var inst_20935__$1 = fluree.db.query.analytical.variable_QMARK_(inst_20934);
var inst_20936 = cljs.core.last(clause);
var inst_20937 = fluree.db.query.analytical.variable_QMARK_(inst_20936);
var state_21024__$1 = (function (){var statearr_21040 = state_21024;
(statearr_21040[(7)] = inst_20935__$1);

(statearr_21040[(8)] = inst_20937);

return statearr_21040;
})();
if(cljs.core.truth_(inst_20935__$1)){
var statearr_21041_21079 = state_21024__$1;
(statearr_21041_21079[(1)] = (6));

} else {
var statearr_21042_21080 = state_21024__$1;
(statearr_21042_21080[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (23))){
var inst_20937 = (state_21024[(8)]);
var inst_20997 = (state_21024[(2)]);
var inst_20998 = fluree.db.flake.sid__GT_cid(inst_20997);
var inst_20999 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20998);
var inst_21000 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21002 = [inst_20937];
var inst_21003 = (new cljs.core.PersistentVector(null,1,(5),inst_21001,inst_21002,null));
var inst_21004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21006 = [inst_20999];
var inst_21007 = (new cljs.core.PersistentVector(null,1,(5),inst_21005,inst_21006,null));
var inst_21008 = [inst_21007];
var inst_21009 = (new cljs.core.PersistentVector(null,1,(5),inst_21004,inst_21008,null));
var inst_21010 = cljs.core.PersistentHashMap.EMPTY;
var inst_21011 = [inst_21003,inst_21009,inst_21010];
var inst_21012 = cljs.core.PersistentHashMap.fromArrays(inst_21000,inst_21011);
var state_21024__$1 = state_21024;
var statearr_21043_21081 = state_21024__$1;
(statearr_21043_21081[(2)] = inst_21012);

(statearr_21043_21081[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (19))){
var state_21024__$1 = state_21024;
var statearr_21044_21082 = state_21024__$1;
(statearr_21044_21082[(2)] = null);

(statearr_21044_21082[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (11))){
var inst_21019 = (state_21024[(2)]);
var _ = (function (){var statearr_21046 = state_21024;
(statearr_21046[(4)] = cljs.core.rest((state_21024[(4)])));

return statearr_21046;
})();
var state_21024__$1 = state_21024;
var statearr_21047_21083 = state_21024__$1;
(statearr_21047_21083[(2)] = inst_21019);

(statearr_21047_21083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (9))){
var inst_20943 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20944 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20945 = cljs.core.PersistentHashMap.fromArrays(inst_20943,inst_20944);
var inst_20946 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_20945);
var inst_20947 = (function(){throw inst_20946})();
var state_21024__$1 = state_21024;
var statearr_21048_21084 = state_21024__$1;
(statearr_21048_21084[(2)] = inst_20947);

(statearr_21048_21084[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (5))){
var _ = (function (){var statearr_21049 = state_21024;
(statearr_21049[(4)] = cljs.core.rest((state_21024[(4)])));

return statearr_21049;
})();
var state_21024__$1 = state_21024;
var ex21045 = (state_21024__$1[(2)]);
var statearr_21050_21085 = state_21024__$1;
(statearr_21050_21085[(5)] = ex21045);


if((ex21045 instanceof Error)){
var statearr_21051_21086 = state_21024__$1;
(statearr_21051_21086[(1)] = (4));

(statearr_21051_21086[(5)] = null);

} else {
throw ex21045;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (14))){
var inst_21017 = (state_21024[(2)]);
var state_21024__$1 = state_21024;
var statearr_21052_21087 = state_21024__$1;
(statearr_21052_21087[(2)] = inst_21017);

(statearr_21052_21087[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (16))){
var inst_20935 = (state_21024[(7)]);
var inst_20937 = (state_21024[(8)]);
var inst_20968 = cljs.core.last(clause);
var inst_20969 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20968);
var inst_20970 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20971 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20970,inst_20969);
var inst_20972 = fluree.db.flake.min_subject_id(inst_20969);
var inst_20973 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20975 = [inst_20935];
var inst_20976 = (new cljs.core.PersistentVector(null,1,(5),inst_20974,inst_20975,null));
var inst_20977 = (function (){var subject_var = inst_20935;
var object_var = inst_20937;
var partition = inst_20969;
var max_sid = inst_20971;
var min_sid = inst_20972;
return (function (p1__20927_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20927_SHARP_);
});
})();
var inst_20978 = (inst_20971 + (1));
var inst_20979 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20972,inst_20978);
var inst_20980 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20977,inst_20979);
var inst_20981 = cljs.core.PersistentHashMap.EMPTY;
var inst_20982 = [inst_20976,inst_20980,inst_20981];
var inst_20983 = cljs.core.PersistentHashMap.fromArrays(inst_20973,inst_20982);
var state_21024__$1 = state_21024;
var statearr_21053_21088 = state_21024__$1;
(statearr_21053_21088[(2)] = inst_20983);

(statearr_21053_21088[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (10))){
var inst_20935 = (state_21024[(7)]);
var state_21024__$1 = state_21024;
if(cljs.core.truth_(inst_20935)){
var statearr_21054_21089 = state_21024__$1;
(statearr_21054_21089[(1)] = (12));

} else {
var statearr_21055_21090 = state_21024__$1;
(statearr_21055_21090[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (18))){
var inst_20988 = (state_21024[(9)]);
var inst_20988__$1 = cljs.core.first(clause);
var inst_20989 = typeof inst_20988__$1 === 'number';
var state_21024__$1 = (function (){var statearr_21056 = state_21024;
(statearr_21056[(9)] = inst_20988__$1);

return statearr_21056;
})();
if(cljs.core.truth_(inst_20989)){
var statearr_21057_21091 = state_21024__$1;
(statearr_21057_21091[(1)] = (21));

} else {
var statearr_21058_21092 = state_21024__$1;
(statearr_21058_21092[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21025 === (8))){
var inst_20941 = (state_21024[(2)]);
var state_21024__$1 = state_21024;
if(cljs.core.truth_(inst_20941)){
var statearr_21059_21093 = state_21024__$1;
(statearr_21059_21093[(1)] = (9));

} else {
var statearr_21060_21094 = state_21024__$1;
(statearr_21060_21094[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_21061 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21061[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__);

(statearr_21061[(1)] = (1));

return statearr_21061;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____1 = (function (state_21024){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21024);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21062){var ex__2736__auto__ = e21062;
var statearr_21063_21095 = state_21024;
(statearr_21063_21095[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21024[(4)]))){
var statearr_21064_21096 = state_21024;
(statearr_21064_21096[(1)] = cljs.core.first((state_21024[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21097 = state_21024;
state_21024 = G__21097;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__ = function(state_21024){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____1.call(this,state_21024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21065 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21065[(6)] = c__2755__auto__);

return statearr_21065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__21104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__21104 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__21104;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4622__auto__ = (function fluree$db$query$analytical$variance_$_iter__21105(s__21106){
return (new cljs.core.LazySeq(null,(function (){
var s__21106__$1 = s__21106;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__21106__$1);
if(temp__5753__auto__){
var s__21106__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21106__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__21106__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__21108 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__21107 = (0);
while(true){
if((i__21107 < size__4621__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__21107);
var delta = (x - mean);
cljs.core.chunk_append(b__21108,(delta * delta));

var G__21110 = (i__21107 + (1));
i__21107 = G__21110;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21108),fluree$db$query$analytical$variance_$_iter__21105(cljs.core.chunk_rest(s__21106__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21108),null);
}
} else {
var x = cljs.core.first(s__21106__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__21105(cljs.core.rest(s__21106__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__21109 = variance(coll);
return Math.sqrt(G__21109);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4306__auto__ = n;
var y__4307__auto__ = (- n);
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
}),(function() {
var G__21111 = null;
var G__21111__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21111__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21111 = function(n,coll){
switch(arguments.length){
case 1:
return G__21111__1.call(this,n);
case 2:
return G__21111__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21111.cljs$core$IFn$_invoke$arity$1 = G__21111__1;
G__21111.cljs$core$IFn$_invoke$arity$2 = G__21111__2;
return G__21111;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21112 = null;
var G__21112__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21112__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21112 = function(n,coll){
switch(arguments.length){
case 1:
return G__21112__1.call(this,n);
case 2:
return G__21112__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21112.cljs$core$IFn$_invoke$arity$1 = G__21112__1;
G__21112.cljs$core$IFn$_invoke$arity$2 = G__21112__2;
return G__21112;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21113 = null;
var G__21113__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__21113__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__21113 = function(n,coll){
switch(arguments.length){
case 1:
return G__21113__1.call(this,n);
case 2:
return G__21113__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21113.cljs$core$IFn$_invoke$arity$1 = G__21113__1;
G__21113.cljs$core$IFn$_invoke$arity$2 = G__21113__2;
return G__21113;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__21114 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21114,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21114,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21114,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21117 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__21120 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__21120) : agg_fn.call(null,G__21120));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21117,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21117,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__21121 = agg;
var map__21121__$1 = cljs.core.__destructure_map(map__21121);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21121__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21121__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21121__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__21123 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21123,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21123,(1),null);
var map__21126 = res__$1;
var map__21126__$1 = cljs.core.__destructure_map(map__21126);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21126__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21126__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21122_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__21122_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21127_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__21127_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21128_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21128_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21129_SHARP_,p2__21130_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21129_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__21130_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21131_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21131_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__21134,row,b_tuple){
var vec__21135 = p__21134;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21135,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21135,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21132_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21132_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = acc;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21133_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21133_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21138_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21138_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21139_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21139_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21144 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21146 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__21145 = (function (p1__21140_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21140_SHARP_);
});
return fexpr__21145(G__21146);
})()),cljs.core.set(b_idxs));
var fexpr__21143 = (function (p1__21141_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21141_SHARP_);
});
return fexpr__21143(G__21144);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21142_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21142_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21147_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21147_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21148_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21148_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21153 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21155 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__21154 = (function (p1__21149_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21149_SHARP_);
});
return fexpr__21154(G__21155);
})()),cljs.core.set(b_idxs));
var fexpr__21152 = (function (p1__21150_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21150_SHARP_);
});
return fexpr__21152(G__21153);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21151_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21151_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__21157 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21157,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21157,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21156_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__21156_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__21162 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21162,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21162,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21160_SHARP_){
return fluree.db.util.core.index_of(headers,p1__21160_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__21161_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__21161_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21165,filters,optional_QMARK_){
var map__21166 = p__21165;
var map__21166__$1 = cljs.core.__destructure_map(map__21166);
var tuple_map = map__21166__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21166__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21166__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21166__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21167 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21167,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21167,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21170 = res;
var map__21170__$1 = cljs.core.__destructure_map(map__21170);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21170__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21170__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21226){
var state_val_21227 = (state_21226[(1)]);
if((state_val_21227 === (7))){
var inst_21200 = (state_21226[(7)]);
var inst_21198 = (state_21226[(2)]);
var inst_21199 = fluree.db.util.async.throw_err(inst_21198);
var inst_21200__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21199,(0),null);
var inst_21201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21199,(1),null);
var inst_21202 = (inst_21200__$1 == null);
var state_21226__$1 = (function (){var statearr_21228 = state_21226;
(statearr_21228[(8)] = inst_21201);

(statearr_21228[(7)] = inst_21200__$1);

return statearr_21228;
})();
if(cljs.core.truth_(inst_21202)){
var statearr_21229_21258 = state_21226__$1;
(statearr_21229_21258[(1)] = (8));

} else {
var statearr_21230_21259 = state_21226__$1;
(statearr_21230_21259[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (1))){
var inst_21178 = optional_clauses;
var inst_21179 = cljs.core.seq(inst_21178);
var inst_21180 = cljs.core.first(inst_21179);
var inst_21181 = cljs.core.next(inst_21179);
var inst_21182 = where_tuples;
var inst_21183 = inst_21178;
var inst_21184 = inst_21182;
var state_21226__$1 = (function (){var statearr_21231 = state_21226;
(statearr_21231[(9)] = inst_21184);

(statearr_21231[(10)] = inst_21183);

(statearr_21231[(11)] = inst_21180);

(statearr_21231[(12)] = inst_21181);

return statearr_21231;
})();
var statearr_21232_21260 = state_21226__$1;
(statearr_21232_21260[(2)] = null);

(statearr_21232_21260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (4))){
var inst_21184 = (state_21226[(9)]);
var inst_21190 = (state_21226[(13)]);
var inst_21191 = (state_21226[(14)]);
var inst_21196 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_21184,inst_21190,inst_21191,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21184,inst_21190,inst_21191,true,fuel,max_fuel,opts));
var state_21226__$1 = state_21226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21226__$1,(7),inst_21196);
} else {
if((state_val_21227 === (15))){
var state_21226__$1 = state_21226;
var statearr_21233_21261 = state_21226__$1;
(statearr_21233_21261[(2)] = null);

(statearr_21233_21261[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (13))){
var inst_21217 = (state_21226[(2)]);
var state_21226__$1 = state_21226;
var statearr_21234_21262 = state_21226__$1;
(statearr_21234_21262[(2)] = inst_21217);

(statearr_21234_21262[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (6))){
var inst_21222 = (state_21226[(2)]);
var state_21226__$1 = state_21226;
var statearr_21235_21263 = state_21226__$1;
(statearr_21235_21263[(2)] = inst_21222);

(statearr_21235_21263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (3))){
var inst_21224 = (state_21226[(2)]);
var state_21226__$1 = state_21226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21226__$1,inst_21224);
} else {
if((state_val_21227 === (12))){
var state_21226__$1 = state_21226;
var statearr_21236_21264 = state_21226__$1;
(statearr_21236_21264[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (2))){
var inst_21190 = (state_21226[(13)]);
var inst_21183 = (state_21226[(10)]);
var inst_21189 = cljs.core.seq(inst_21183);
var inst_21190__$1 = cljs.core.first(inst_21189);
var inst_21191 = cljs.core.next(inst_21189);
var state_21226__$1 = (function (){var statearr_21238 = state_21226;
(statearr_21238[(13)] = inst_21190__$1);

(statearr_21238[(14)] = inst_21191);

return statearr_21238;
})();
if(cljs.core.truth_(inst_21190__$1)){
var statearr_21239_21265 = state_21226__$1;
(statearr_21239_21265[(1)] = (4));

} else {
var statearr_21240_21266 = state_21226__$1;
(statearr_21240_21266[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (11))){
var inst_21201 = (state_21226[(8)]);
var inst_21200 = (state_21226[(7)]);
var inst_21183 = inst_21201;
var inst_21184 = inst_21200;
var state_21226__$1 = (function (){var statearr_21241 = state_21226;
(statearr_21241[(9)] = inst_21184);

(statearr_21241[(10)] = inst_21183);

return statearr_21241;
})();
var statearr_21242_21267 = state_21226__$1;
(statearr_21242_21267[(2)] = null);

(statearr_21242_21267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (9))){
var inst_21190 = (state_21226[(13)]);
var inst_21206 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21190);
var state_21226__$1 = state_21226;
if(cljs.core.truth_(inst_21206)){
var statearr_21243_21268 = state_21226__$1;
(statearr_21243_21268[(1)] = (11));

} else {
var statearr_21244_21269 = state_21226__$1;
(statearr_21244_21269[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (5))){
var inst_21184 = (state_21226[(9)]);
var state_21226__$1 = state_21226;
var statearr_21245_21270 = state_21226__$1;
(statearr_21245_21270[(2)] = inst_21184);

(statearr_21245_21270[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (14))){
var inst_21184 = (state_21226[(9)]);
var inst_21201 = (state_21226[(8)]);
var inst_21200 = (state_21226[(7)]);
var inst_21211 = fluree.db.query.analytical.left_outer_join(inst_21184,inst_21200);
var inst_21183 = inst_21201;
var inst_21184__$1 = inst_21211;
var state_21226__$1 = (function (){var statearr_21246 = state_21226;
(statearr_21246[(9)] = inst_21184__$1);

(statearr_21246[(10)] = inst_21183);

return statearr_21246;
})();
var statearr_21247_21271 = state_21226__$1;
(statearr_21247_21271[(2)] = null);

(statearr_21247_21271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (16))){
var inst_21215 = (state_21226[(2)]);
var state_21226__$1 = state_21226;
var statearr_21249_21272 = state_21226__$1;
(statearr_21249_21272[(2)] = inst_21215);

(statearr_21249_21272[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (10))){
var inst_21219 = (state_21226[(2)]);
var state_21226__$1 = state_21226;
var statearr_21250_21273 = state_21226__$1;
(statearr_21250_21273[(2)] = inst_21219);

(statearr_21250_21273[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21227 === (8))){
var inst_21184 = (state_21226[(9)]);
var inst_21201 = (state_21226[(8)]);
var tmp21248 = inst_21184;
var inst_21183 = inst_21201;
var inst_21184__$1 = tmp21248;
var state_21226__$1 = (function (){var statearr_21251 = state_21226;
(statearr_21251[(9)] = inst_21184__$1);

(statearr_21251[(10)] = inst_21183);

return statearr_21251;
})();
var statearr_21252_21274 = state_21226__$1;
(statearr_21252_21274[(2)] = null);

(statearr_21252_21274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____0 = (function (){
var statearr_21253 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21253[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__);

(statearr_21253[(1)] = (1));

return statearr_21253;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____1 = (function (state_21226){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21226);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21254){var ex__2736__auto__ = e21254;
var statearr_21255_21275 = state_21226;
(statearr_21255_21275[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21226[(4)]))){
var statearr_21256_21276 = state_21226;
(statearr_21256_21276[(1)] = cljs.core.first((state_21226[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21277 = state_21226;
state_21226 = G__21277;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__ = function(state_21226){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____1.call(this,state_21226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21257 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21257[(6)] = c__2755__auto__);

return statearr_21257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__21279){
var vec__21280 = p__21279;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21280,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21280,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21278_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21278_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21284,p__21285,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21286 = p__21284;
var map__21286__$1 = cljs.core.__destructure_map(map__21286);
var q_map = map__21286__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21286__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21287 = p__21285;
var map__21287__$1 = cljs.core.__destructure_map(map__21287);
var res = map__21287__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21287__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21524){
var state_val_21525 = (state_21524[(1)]);
if((state_val_21525 === (65))){
var inst_21473 = (state_21524[(7)]);
var inst_21474 = (state_21524[(8)]);
var inst_21485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21486 = fluree.db.query.analytical.full_text__GT_tuples(inst_21473,res,inst_21474);
var inst_21487 = [inst_21486,r];
var inst_21488 = (new cljs.core.PersistentVector(null,2,(5),inst_21485,inst_21487,null));
var state_21524__$1 = state_21524;
var statearr_21526_21639 = state_21524__$1;
(statearr_21526_21639[(2)] = inst_21488);

(statearr_21526_21639[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (70))){
var inst_21500 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21527_21640 = state_21524__$1;
(statearr_21527_21640[(2)] = inst_21500);

(statearr_21527_21640[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (62))){
var inst_21474 = (state_21524[(8)]);
var inst_21482 = cljs.core.second(inst_21474);
var inst_21483 = clojure.string.starts_with_QMARK_(inst_21482,"fullText:");
var state_21524__$1 = state_21524;
if(inst_21483){
var statearr_21528_21641 = state_21524__$1;
(statearr_21528_21641[(1)] = (65));

} else {
var statearr_21529_21642 = state_21524__$1;
(statearr_21529_21642[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (7))){
var inst_21393 = (state_21524[(9)]);
var inst_21392 = cljs.core.count(clause);
var inst_21393__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21392);
var state_21524__$1 = (function (){var statearr_21530 = state_21524;
(statearr_21530[(9)] = inst_21393__$1);

return statearr_21530;
})();
if(inst_21393__$1){
var statearr_21531_21643 = state_21524__$1;
(statearr_21531_21643[(1)] = (31));

} else {
var statearr_21532_21644 = state_21524__$1;
(statearr_21532_21644[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (59))){
var inst_21507 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21533_21645 = state_21524__$1;
(statearr_21533_21645[(2)] = inst_21507);

(statearr_21533_21645[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (20))){
var inst_21356 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21534_21646 = state_21524__$1;
(statearr_21534_21646[(2)] = inst_21356);

(statearr_21534_21646[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (58))){
var state_21524__$1 = state_21524;
var statearr_21535_21647 = state_21524__$1;
(statearr_21535_21647[(2)] = null);

(statearr_21535_21647[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (60))){
var inst_21473 = (state_21524[(7)]);
var inst_21471 = (state_21524[(2)]);
var inst_21472 = fluree.db.util.async.throw_err(inst_21471);
var inst_21473__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21472,(0),null);
var inst_21474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21472,(1),null);
var inst_21475 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_21473__$1);
var state_21524__$1 = (function (){var statearr_21536 = state_21524;
(statearr_21536[(7)] = inst_21473__$1);

(statearr_21536[(8)] = inst_21474);

return statearr_21536;
})();
if(inst_21475){
var statearr_21537_21648 = state_21524__$1;
(statearr_21537_21648[(1)] = (61));

} else {
var statearr_21538_21649 = state_21524__$1;
(statearr_21538_21649[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (27))){
var inst_21386 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21539_21650 = state_21524__$1;
(statearr_21539_21650[(2)] = inst_21386);

(statearr_21539_21650[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (1))){
var state_21524__$1 = state_21524;
var statearr_21540_21651 = state_21524__$1;
(statearr_21540_21651[(2)] = null);

(statearr_21540_21651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (69))){
var state_21524__$1 = state_21524;
var statearr_21541_21652 = state_21524__$1;
(statearr_21541_21652[(2)] = null);

(statearr_21541_21652[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (24))){
var inst_21350 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21542_21653 = state_21524__$1;
(statearr_21542_21653[(2)] = inst_21350);

(statearr_21542_21653[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (55))){
var inst_21456 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21457 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21458 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21459 = cljs.core.PersistentHashMap.fromArrays(inst_21457,inst_21458);
var inst_21460 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21456,inst_21459);
var inst_21461 = (function(){throw inst_21460})();
var state_21524__$1 = state_21524;
var statearr_21543_21654 = state_21524__$1;
(statearr_21543_21654[(2)] = inst_21461);

(statearr_21543_21654[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (39))){
var inst_21413 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
if(cljs.core.truth_(inst_21413)){
var statearr_21544_21655 = state_21524__$1;
(statearr_21544_21655[(1)] = (40));

} else {
var statearr_21545_21656 = state_21524__$1;
(statearr_21545_21656[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (46))){
var inst_21513 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21546_21657 = state_21524__$1;
(statearr_21546_21657[(2)] = inst_21513);

(statearr_21546_21657[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (4))){
var inst_21288 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21547_21658 = state_21524__$1;
(statearr_21547_21658[(2)] = inst_21288);

(statearr_21547_21658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (54))){
var inst_21449 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21450 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21451 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21452 = cljs.core.PersistentHashMap.fromArrays(inst_21450,inst_21451);
var inst_21453 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21449,inst_21452);
var inst_21454 = (function(){throw inst_21453})();
var state_21524__$1 = state_21524;
var statearr_21548_21659 = state_21524__$1;
(statearr_21548_21659[(2)] = inst_21454);

(statearr_21548_21659[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (15))){
var inst_21388 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21549_21660 = state_21524__$1;
(statearr_21549_21660[(2)] = inst_21388);

(statearr_21549_21660[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (48))){
var inst_21437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21438 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_21439 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21438);
var inst_21440 = [inst_21439,r];
var inst_21441 = (new cljs.core.PersistentVector(null,2,(5),inst_21437,inst_21440,null));
var state_21524__$1 = state_21524;
var statearr_21550_21661 = state_21524__$1;
(statearr_21550_21661[(2)] = inst_21441);

(statearr_21550_21661[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (50))){
var inst_21511 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21551_21662 = state_21524__$1;
(statearr_21551_21662[(2)] = inst_21511);

(statearr_21551_21662[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (21))){
var inst_21326 = (state_21524[(10)]);
var inst_21327 = (state_21524[(11)]);
var inst_21322 = (state_21524[(12)]);
var inst_21301 = (state_21524[(13)]);
var inst_21297 = (state_21524[(14)]);
var inst_21325 = (state_21524[(15)]);
var inst_21324 = (state_21524[(16)]);
var inst_21334 = (state_21524[(17)]);
var inst_21333 = (state_21524[(18)]);
var inst_21338 = (state_21524[(2)]);
var inst_21339 = fluree.db.util.async.throw_err(inst_21338);
var inst_21340 = (function (){var new_res = inst_21339;
var rest = inst_21334;
var vec__21329 = inst_21326;
var tuples = inst_21327;
var seq__21320 = inst_21325;
var vec__21319 = inst_21322;
var first__21331 = inst_21333;
var first__21321 = inst_21324;
var pred__21298 = inst_21301;
var expr__21299 = inst_21297;
var segment_type = inst_21297;
var G__21318 = inst_21326;
var seq__21330 = inst_21334;
var clause_group = inst_21333;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21341 = cljs.core.keys(vars);
var inst_21342 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21340,inst_21339,inst_21341);
var inst_21343 = fluree.db.query.analytical.res_absorb_vars(inst_21342);
var state_21524__$1 = (function (){var statearr_21552 = state_21524;
(statearr_21552[(19)] = inst_21343);

return statearr_21552;
})();
if(cljs.core.truth_(inst_21327)){
var statearr_21553_21663 = state_21524__$1;
(statearr_21553_21663[(1)] = (22));

} else {
var statearr_21554_21664 = state_21524__$1;
(statearr_21554_21664[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (31))){
var inst_21395 = cljs.core.second(clause);
var inst_21396 = clojure.string.starts_with_QMARK_(inst_21395,"fullText:");
var state_21524__$1 = state_21524;
var statearr_21555_21665 = state_21524__$1;
(statearr_21555_21665[(2)] = inst_21396);

(statearr_21555_21665[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (32))){
var inst_21393 = (state_21524[(9)]);
var state_21524__$1 = state_21524;
var statearr_21556_21666 = state_21524__$1;
(statearr_21556_21666[(2)] = inst_21393);

(statearr_21556_21666[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (40))){
var inst_21415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21416 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_21524__$1 = (function (){var statearr_21557 = state_21524;
(statearr_21557[(20)] = inst_21415);

return statearr_21557;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21524__$1,(43),inst_21416);
} else {
if((state_val_21525 === (56))){
var inst_21463 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21558_21667 = state_21524__$1;
(statearr_21558_21667[(2)] = inst_21463);

(statearr_21558_21667[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (33))){
var inst_21399 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
if(cljs.core.truth_(inst_21399)){
var statearr_21559_21668 = state_21524__$1;
(statearr_21559_21668[(1)] = (34));

} else {
var statearr_21560_21669 = state_21524__$1;
(statearr_21560_21669[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (13))){
var inst_21322 = (state_21524[(12)]);
var inst_21322__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21323 = cljs.core.seq(inst_21322__$1);
var inst_21324 = cljs.core.first(inst_21323);
var inst_21325 = cljs.core.next(inst_21323);
var inst_21326 = inst_21322__$1;
var inst_21327 = null;
var state_21524__$1 = (function (){var statearr_21561 = state_21524;
(statearr_21561[(10)] = inst_21326);

(statearr_21561[(11)] = inst_21327);

(statearr_21561[(12)] = inst_21322__$1);

(statearr_21561[(15)] = inst_21325);

(statearr_21561[(16)] = inst_21324);

return statearr_21561;
})();
var statearr_21562_21670 = state_21524__$1;
(statearr_21562_21670[(2)] = null);

(statearr_21562_21670[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (22))){
var inst_21327 = (state_21524[(11)]);
var inst_21343 = (state_21524[(19)]);
var inst_21334 = (state_21524[(17)]);
var inst_21345 = fluree.db.query.union.results(inst_21327,inst_21343);
var inst_21326 = inst_21334;
var inst_21327__$1 = inst_21345;
var state_21524__$1 = (function (){var statearr_21563 = state_21524;
(statearr_21563[(10)] = inst_21326);

(statearr_21563[(11)] = inst_21327__$1);

return statearr_21563;
})();
var statearr_21564_21671 = state_21524__$1;
(statearr_21564_21671[(2)] = null);

(statearr_21564_21671[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (36))){
var inst_21517 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21565_21672 = state_21524__$1;
(statearr_21565_21672[(2)] = inst_21517);

(statearr_21565_21672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (41))){
var inst_21423 = cljs.core.count(clause);
var inst_21424 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21423);
var state_21524__$1 = state_21524;
if(inst_21424){
var statearr_21566_21673 = state_21524__$1;
(statearr_21566_21673[(1)] = (44));

} else {
var statearr_21567_21674 = state_21524__$1;
(statearr_21567_21674[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (43))){
var inst_21415 = (state_21524[(20)]);
var inst_21418 = (state_21524[(2)]);
var inst_21419 = fluree.db.util.async.throw_err(inst_21418);
var inst_21420 = [inst_21419,r];
var inst_21421 = (new cljs.core.PersistentVector(null,2,(5),inst_21415,inst_21420,null));
var state_21524__$1 = state_21524;
var statearr_21568_21675 = state_21524__$1;
(statearr_21568_21675[(2)] = inst_21421);

(statearr_21568_21675[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (61))){
var inst_21474 = (state_21524[(8)]);
var inst_21477 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_21474,r,res,optional_QMARK_,fuel,max_fuel);
var state_21524__$1 = state_21524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21524__$1,(64),inst_21477);
} else {
if((state_val_21525 === (29))){
var inst_21297 = (state_21524[(14)]);
var inst_21380 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21297)].join('');
var inst_21381 = (new Error(inst_21380));
var inst_21382 = (function(){throw inst_21381})();
var state_21524__$1 = state_21524;
var statearr_21569_21676 = state_21524__$1;
(statearr_21569_21676[(2)] = inst_21382);

(statearr_21569_21676[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (44))){
var inst_21426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21427 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_21524__$1 = (function (){var statearr_21570 = state_21524;
(statearr_21570[(21)] = inst_21426);

return statearr_21570;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21524__$1,(47),inst_21427);
} else {
if((state_val_21525 === (6))){
var inst_21301 = (state_21524[(13)]);
var inst_21297 = (state_21524[(14)]);
var inst_21296 = cljs.core.keys(clause);
var inst_21297__$1 = cljs.core.first(inst_21296);
var inst_21301__$1 = cljs.core._EQ_;
var inst_21302 = (function (){var G__21571 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__21572 = inst_21297__$1;
return (inst_21301__$1.cljs$core$IFn$_invoke$arity$2 ? inst_21301__$1.cljs$core$IFn$_invoke$arity$2(G__21571,G__21572) : inst_21301__$1.call(null,G__21571,G__21572));
})();
var state_21524__$1 = (function (){var statearr_21573 = state_21524;
(statearr_21573[(13)] = inst_21301__$1);

(statearr_21573[(14)] = inst_21297__$1);

return statearr_21573;
})();
if(cljs.core.truth_(inst_21302)){
var statearr_21574_21677 = state_21524__$1;
(statearr_21574_21677[(1)] = (9));

} else {
var statearr_21575_21678 = state_21524__$1;
(statearr_21575_21678[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (28))){
var inst_21374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21375 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21376 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_21375,optional_QMARK_);
var inst_21377 = [inst_21376,r];
var inst_21378 = (new cljs.core.PersistentVector(null,2,(5),inst_21374,inst_21377,null));
var state_21524__$1 = state_21524;
var statearr_21576_21679 = state_21524__$1;
(statearr_21576_21679[(2)] = inst_21378);

(statearr_21576_21679[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (64))){
var inst_21479 = (state_21524[(2)]);
var inst_21480 = fluree.db.util.async.throw_err(inst_21479);
var state_21524__$1 = state_21524;
var statearr_21577_21680 = state_21524__$1;
(statearr_21577_21680[(2)] = inst_21480);

(statearr_21577_21680[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (51))){
var inst_21446 = cljs.core.first(clause);
var inst_21447 = cljs.core.sequential_QMARK_(inst_21446);
var state_21524__$1 = state_21524;
if(inst_21447){
var statearr_21578_21681 = state_21524__$1;
(statearr_21578_21681[(1)] = (54));

} else {
var statearr_21579_21682 = state_21524__$1;
(statearr_21579_21682[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (25))){
var inst_21301 = (state_21524[(13)]);
var inst_21297 = (state_21524[(14)]);
var inst_21362 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21363 = (function (){var segment_type = inst_21297;
var pred__21298 = inst_21301;
var expr__21299 = inst_21297;
var bindings = inst_21362;
return (function (p1__21283_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__21283_SHARP_);
});
})();
var inst_21364 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21363,inst_21362);
var inst_21365 = cljs.core.PersistentHashMap.EMPTY;
var inst_21366 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21365,inst_21364);
var inst_21367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21368 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21366);
var inst_21369 = [inst_21368,r];
var inst_21370 = (new cljs.core.PersistentVector(null,2,(5),inst_21367,inst_21369,null));
var state_21524__$1 = state_21524;
var statearr_21580_21683 = state_21524__$1;
(statearr_21580_21683[(2)] = inst_21370);

(statearr_21580_21683[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (34))){
var inst_21401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21402 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_21403 = [inst_21402,r];
var inst_21404 = (new cljs.core.PersistentVector(null,2,(5),inst_21401,inst_21403,null));
var state_21524__$1 = state_21524;
var statearr_21581_21684 = state_21524__$1;
(statearr_21581_21684[(2)] = inst_21404);

(statearr_21581_21684[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (17))){
var inst_21358 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21582_21685 = state_21524__$1;
(statearr_21582_21685[(2)] = inst_21358);

(statearr_21582_21685[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (3))){
var inst_21522 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21524__$1,inst_21522);
} else {
if((state_val_21525 === (12))){
var inst_21304 = (state_21524[(22)]);
var inst_21308 = (state_21524[(2)]);
var inst_21309 = fluree.db.util.async.throw_err(inst_21308);
var inst_21310 = [inst_21309,r];
var inst_21311 = (new cljs.core.PersistentVector(null,2,(5),inst_21304,inst_21310,null));
var state_21524__$1 = state_21524;
var statearr_21583_21686 = state_21524__$1;
(statearr_21583_21686[(2)] = inst_21311);

(statearr_21583_21686[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (2))){
var _ = (function (){var statearr_21584 = state_21524;
(statearr_21584[(4)] = cljs.core.cons((5),(state_21524[(4)])));

return statearr_21584;
})();
var inst_21294 = cljs.core.map_QMARK_(clause);
var state_21524__$1 = state_21524;
if(inst_21294){
var statearr_21585_21687 = state_21524__$1;
(statearr_21585_21687[(1)] = (6));

} else {
var statearr_21586_21688 = state_21524__$1;
(statearr_21586_21688[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (66))){
var state_21524__$1 = state_21524;
var statearr_21587_21689 = state_21524__$1;
(statearr_21587_21689[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (23))){
var inst_21343 = (state_21524[(19)]);
var inst_21334 = (state_21524[(17)]);
var inst_21326 = inst_21334;
var inst_21327 = inst_21343;
var state_21524__$1 = (function (){var statearr_21589 = state_21524;
(statearr_21589[(10)] = inst_21326);

(statearr_21589[(11)] = inst_21327);

return statearr_21589;
})();
var statearr_21590_21690 = state_21524__$1;
(statearr_21590_21690[(2)] = null);

(statearr_21590_21690[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (47))){
var inst_21426 = (state_21524[(21)]);
var inst_21429 = (state_21524[(2)]);
var inst_21430 = fluree.db.util.async.throw_err(inst_21429);
var inst_21431 = [inst_21430,r];
var inst_21432 = (new cljs.core.PersistentVector(null,2,(5),inst_21426,inst_21431,null));
var state_21524__$1 = state_21524;
var statearr_21591_21691 = state_21524__$1;
(statearr_21591_21691[(2)] = inst_21432);

(statearr_21591_21691[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (35))){
var inst_21407 = (state_21524[(23)]);
var inst_21406 = cljs.core.count(clause);
var inst_21407__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21406);
var state_21524__$1 = (function (){var statearr_21592 = state_21524;
(statearr_21592[(23)] = inst_21407__$1);

return statearr_21592;
})();
if(inst_21407__$1){
var statearr_21593_21692 = state_21524__$1;
(statearr_21593_21692[(1)] = (37));

} else {
var statearr_21594_21693 = state_21524__$1;
(statearr_21594_21693[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (19))){
var inst_21327 = (state_21524[(11)]);
var inst_21352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21353 = [inst_21327,r];
var inst_21354 = (new cljs.core.PersistentVector(null,2,(5),inst_21352,inst_21353,null));
var state_21524__$1 = state_21524;
var statearr_21595_21694 = state_21524__$1;
(statearr_21595_21694[(2)] = inst_21354);

(statearr_21595_21694[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (57))){
var inst_21469 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_21524__$1 = state_21524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21524__$1,(60),inst_21469);
} else {
if((state_val_21525 === (68))){
var inst_21473 = (state_21524[(7)]);
var inst_21474 = (state_21524[(8)]);
var inst_21491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21492 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_21473,res,inst_21474,fuel,max_fuel);
var state_21524__$1 = (function (){var statearr_21596 = state_21524;
(statearr_21596[(24)] = inst_21491);

return statearr_21596;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21524__$1,(71),inst_21492);
} else {
if((state_val_21525 === (11))){
var inst_21390 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21598_21695 = state_21524__$1;
(statearr_21598_21695[(2)] = inst_21390);

(statearr_21598_21695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (9))){
var inst_21304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21305 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21306 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21305,res,fuel,max_fuel,opts);
var state_21524__$1 = (function (){var statearr_21599 = state_21524;
(statearr_21599[(22)] = inst_21304);

return statearr_21599;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21524__$1,(12),inst_21306);
} else {
if((state_val_21525 === (5))){
var _ = (function (){var statearr_21600 = state_21524;
(statearr_21600[(4)] = cljs.core.rest((state_21524[(4)])));

return statearr_21600;
})();
var state_21524__$1 = state_21524;
var ex21597 = (state_21524__$1[(2)]);
var statearr_21601_21696 = state_21524__$1;
(statearr_21601_21696[(5)] = ex21597);


if((ex21597 instanceof Error)){
var statearr_21602_21697 = state_21524__$1;
(statearr_21602_21697[(1)] = (4));

(statearr_21602_21697[(5)] = null);

} else {
throw ex21597;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (14))){
var inst_21301 = (state_21524[(13)]);
var inst_21297 = (state_21524[(14)]);
var inst_21360 = (function (){var G__21603 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__21604 = inst_21297;
return (inst_21301.cljs$core$IFn$_invoke$arity$2 ? inst_21301.cljs$core$IFn$_invoke$arity$2(G__21603,G__21604) : inst_21301.call(null,G__21603,G__21604));
})();
var state_21524__$1 = state_21524;
if(cljs.core.truth_(inst_21360)){
var statearr_21605_21698 = state_21524__$1;
(statearr_21605_21698[(1)] = (25));

} else {
var statearr_21606_21699 = state_21524__$1;
(statearr_21606_21699[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (45))){
var inst_21434 = cljs.core.count(clause);
var inst_21435 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21434);
var state_21524__$1 = state_21524;
if(inst_21435){
var statearr_21607_21700 = state_21524__$1;
(statearr_21607_21700[(1)] = (48));

} else {
var statearr_21608_21701 = state_21524__$1;
(statearr_21608_21701[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (53))){
var inst_21509 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21609_21702 = state_21524__$1;
(statearr_21609_21702[(2)] = inst_21509);

(statearr_21609_21702[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (26))){
var inst_21301 = (state_21524[(13)]);
var inst_21297 = (state_21524[(14)]);
var inst_21372 = (function (){var G__21610 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__21611 = inst_21297;
return (inst_21301.cljs$core$IFn$_invoke$arity$2 ? inst_21301.cljs$core$IFn$_invoke$arity$2(G__21610,G__21611) : inst_21301.call(null,G__21610,G__21611));
})();
var state_21524__$1 = state_21524;
if(cljs.core.truth_(inst_21372)){
var statearr_21612_21703 = state_21524__$1;
(statearr_21612_21703[(1)] = (28));

} else {
var statearr_21613_21704 = state_21524__$1;
(statearr_21613_21704[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (16))){
var inst_21326 = (state_21524[(10)]);
var inst_21333 = (state_21524[(18)]);
var inst_21332 = cljs.core.seq(inst_21326);
var inst_21333__$1 = cljs.core.first(inst_21332);
var inst_21334 = cljs.core.next(inst_21332);
var state_21524__$1 = (function (){var statearr_21614 = state_21524;
(statearr_21614[(17)] = inst_21334);

(statearr_21614[(18)] = inst_21333__$1);

return statearr_21614;
})();
if(cljs.core.truth_(inst_21333__$1)){
var statearr_21615_21705 = state_21524__$1;
(statearr_21615_21705[(1)] = (18));

} else {
var statearr_21616_21706 = state_21524__$1;
(statearr_21616_21706[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (38))){
var inst_21407 = (state_21524[(23)]);
var state_21524__$1 = state_21524;
var statearr_21617_21707 = state_21524__$1;
(statearr_21617_21707[(2)] = inst_21407);

(statearr_21617_21707[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (30))){
var inst_21384 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21618_21708 = state_21524__$1;
(statearr_21618_21708[(2)] = inst_21384);

(statearr_21618_21708[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (10))){
var inst_21301 = (state_21524[(13)]);
var inst_21297 = (state_21524[(14)]);
var inst_21313 = (function (){var G__21619 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__21620 = inst_21297;
return (inst_21301.cljs$core$IFn$_invoke$arity$2 ? inst_21301.cljs$core$IFn$_invoke$arity$2(G__21619,G__21620) : inst_21301.call(null,G__21619,G__21620));
})();
var state_21524__$1 = state_21524;
if(cljs.core.truth_(inst_21313)){
var statearr_21621_21709 = state_21524__$1;
(statearr_21621_21709[(1)] = (13));

} else {
var statearr_21622_21710 = state_21524__$1;
(statearr_21622_21710[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (18))){
var inst_21333 = (state_21524[(18)]);
var inst_21336 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21333,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21333,q_map,vars,fuel,max_fuel,opts));
var state_21524__$1 = state_21524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21524__$1,(21),inst_21336);
} else {
if((state_val_21525 === (52))){
var state_21524__$1 = state_21524;
var statearr_21623_21711 = state_21524__$1;
(statearr_21623_21711[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (67))){
var inst_21502 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21625_21712 = state_21524__$1;
(statearr_21625_21712[(2)] = inst_21502);

(statearr_21625_21712[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (71))){
var inst_21491 = (state_21524[(24)]);
var inst_21494 = (state_21524[(2)]);
var inst_21495 = fluree.db.util.async.throw_err(inst_21494);
var inst_21496 = [inst_21495,r];
var inst_21497 = (new cljs.core.PersistentVector(null,2,(5),inst_21491,inst_21496,null));
var state_21524__$1 = state_21524;
var statearr_21626_21713 = state_21524__$1;
(statearr_21626_21713[(2)] = inst_21497);

(statearr_21626_21713[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (42))){
var inst_21515 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21627_21714 = state_21524__$1;
(statearr_21627_21714[(2)] = inst_21515);

(statearr_21627_21714[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (37))){
var inst_21409 = cljs.core.second(clause);
var inst_21410 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21409,"rdf:type");
var state_21524__$1 = state_21524;
var statearr_21628_21715 = state_21524__$1;
(statearr_21628_21715[(2)] = inst_21410);

(statearr_21628_21715[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (63))){
var inst_21504 = (state_21524[(2)]);
var state_21524__$1 = state_21524;
var statearr_21629_21716 = state_21524__$1;
(statearr_21629_21716[(2)] = inst_21504);

(statearr_21629_21716[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (8))){
var inst_21519 = (state_21524[(2)]);
var _ = (function (){var statearr_21630 = state_21524;
(statearr_21630[(4)] = cljs.core.rest((state_21524[(4)])));

return statearr_21630;
})();
var state_21524__$1 = state_21524;
var statearr_21631_21717 = state_21524__$1;
(statearr_21631_21717[(2)] = inst_21519);

(statearr_21631_21717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21525 === (49))){
var inst_21443 = cljs.core.count(clause);
var inst_21444 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_21443);
var state_21524__$1 = state_21524;
if(inst_21444){
var statearr_21632_21718 = state_21524__$1;
(statearr_21632_21718[(1)] = (51));

} else {
var statearr_21633_21719 = state_21524__$1;
(statearr_21633_21719[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_21634 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21634[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__);

(statearr_21634[(1)] = (1));

return statearr_21634;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____1 = (function (state_21524){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21524);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21635){var ex__2736__auto__ = e21635;
var statearr_21636_21720 = state_21524;
(statearr_21636_21720[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21524[(4)]))){
var statearr_21637_21721 = state_21524;
(statearr_21637_21721[(1)] = cljs.core.first((state_21524[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21722 = state_21524;
state_21524 = G__21722;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__ = function(state_21524){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____1.call(this,state_21524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21638 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21638[(6)] = c__2755__auto__);

return statearr_21638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21724 = arguments.length;
switch (G__21724) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21804){
var state_val_21805 = (state_21804[(1)]);
if((state_val_21805 === (7))){
var inst_21799 = (state_21804[(2)]);
var _ = (function (){var statearr_21806 = state_21804;
(statearr_21806[(4)] = cljs.core.rest((state_21804[(4)])));

return statearr_21806;
})();
var state_21804__$1 = state_21804;
var statearr_21807_21855 = state_21804__$1;
(statearr_21807_21855[(2)] = inst_21799);

(statearr_21807_21855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (20))){
var inst_21764 = (state_21804[(7)]);
var inst_21776 = (state_21804[(2)]);
var inst_21746 = inst_21764;
var inst_21747 = inst_21776;
var state_21804__$1 = (function (){var statearr_21808 = state_21804;
(statearr_21808[(8)] = inst_21746);

(statearr_21808[(9)] = inst_21747);

return statearr_21808;
})();
var statearr_21809_21856 = state_21804__$1;
(statearr_21809_21856[(2)] = null);

(statearr_21809_21856[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (1))){
var state_21804__$1 = state_21804;
var statearr_21810_21857 = state_21804__$1;
(statearr_21810_21857[(2)] = null);

(statearr_21810_21857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (24))){
var inst_21747 = (state_21804[(9)]);
var inst_21764 = (state_21804[(7)]);
var inst_21763 = (state_21804[(10)]);
var inst_21784 = fluree.db.query.analytical.inner_join(inst_21747,inst_21763);
var inst_21746 = inst_21764;
var inst_21747__$1 = inst_21784;
var state_21804__$1 = (function (){var statearr_21811 = state_21804;
(statearr_21811[(8)] = inst_21746);

(statearr_21811[(9)] = inst_21747__$1);

return statearr_21811;
})();
var statearr_21812_21858 = state_21804__$1;
(statearr_21812_21858[(2)] = null);

(statearr_21812_21858[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (4))){
var inst_21725 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
var statearr_21814_21859 = state_21804__$1;
(statearr_21814_21859[(2)] = inst_21725);

(statearr_21814_21859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (15))){
var inst_21763 = (state_21804[(10)]);
var state_21804__$1 = state_21804;
if(cljs.core.truth_(inst_21763)){
var statearr_21815_21860 = state_21804__$1;
(statearr_21815_21860[(1)] = (18));

} else {
var statearr_21816_21861 = state_21804__$1;
(statearr_21816_21861[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (21))){
var inst_21747 = (state_21804[(9)]);
var inst_21764 = (state_21804[(7)]);
var tmp21813 = inst_21747;
var inst_21746 = inst_21764;
var inst_21747__$1 = tmp21813;
var state_21804__$1 = (function (){var statearr_21817 = state_21804;
(statearr_21817[(8)] = inst_21746);

(statearr_21817[(9)] = inst_21747__$1);

return statearr_21817;
})();
var statearr_21818_21862 = state_21804__$1;
(statearr_21818_21862[(2)] = null);

(statearr_21818_21862[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (13))){
var inst_21747 = (state_21804[(9)]);
var inst_21770 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_21747,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21771 = cljs.core.empty_QMARK_(inst_21770);
var state_21804__$1 = state_21804;
if(inst_21771){
var statearr_21819_21863 = state_21804__$1;
(statearr_21819_21863[(1)] = (15));

} else {
var statearr_21820_21864 = state_21804__$1;
(statearr_21820_21864[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (22))){
var state_21804__$1 = state_21804;
var statearr_21821_21865 = state_21804__$1;
(statearr_21821_21865[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (6))){
var inst_21746 = (state_21804[(8)]);
var inst_21753 = (state_21804[(11)]);
var inst_21752 = cljs.core.seq(inst_21746);
var inst_21753__$1 = cljs.core.first(inst_21752);
var inst_21754 = cljs.core.next(inst_21752);
var state_21804__$1 = (function (){var statearr_21823 = state_21804;
(statearr_21823[(11)] = inst_21753__$1);

(statearr_21823[(12)] = inst_21754);

return statearr_21823;
})();
if(cljs.core.truth_(inst_21753__$1)){
var statearr_21824_21866 = state_21804__$1;
(statearr_21824_21866[(1)] = (8));

} else {
var statearr_21825_21867 = state_21804__$1;
(statearr_21825_21867[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (25))){
var state_21804__$1 = state_21804;
var statearr_21826_21868 = state_21804__$1;
(statearr_21826_21868[(2)] = null);

(statearr_21826_21868[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (17))){
var inst_21792 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
var statearr_21827_21869 = state_21804__$1;
(statearr_21827_21869[(2)] = inst_21792);

(statearr_21827_21869[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (3))){
var inst_21802 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21804__$1,inst_21802);
} else {
if((state_val_21805 === (12))){
var inst_21764 = (state_21804[(7)]);
var inst_21763 = (state_21804[(10)]);
var inst_21746 = inst_21764;
var inst_21747 = inst_21763;
var state_21804__$1 = (function (){var statearr_21828 = state_21804;
(statearr_21828[(8)] = inst_21746);

(statearr_21828[(9)] = inst_21747);

return statearr_21828;
})();
var statearr_21829_21870 = state_21804__$1;
(statearr_21829_21870[(2)] = null);

(statearr_21829_21870[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (2))){
var _ = (function (){var statearr_21830 = state_21804;
(statearr_21830[(4)] = cljs.core.cons((5),(state_21804[(4)])));

return statearr_21830;
})();
var inst_21738 = where;
var inst_21739 = cljs.core.seq(inst_21738);
var inst_21740 = cljs.core.first(inst_21739);
var inst_21741 = cljs.core.next(inst_21739);
var inst_21742 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21743 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_21744 = [inst_21743];
var inst_21745 = cljs.core.PersistentHashMap.fromArrays(inst_21742,inst_21744);
var inst_21746 = inst_21738;
var inst_21747 = inst_21745;
var state_21804__$1 = (function (){var statearr_21831 = state_21804;
(statearr_21831[(8)] = inst_21746);

(statearr_21831[(9)] = inst_21747);

(statearr_21831[(13)] = inst_21741);

(statearr_21831[(14)] = inst_21740);

return statearr_21831;
})();
var statearr_21832_21871 = state_21804__$1;
(statearr_21832_21871[(2)] = null);

(statearr_21832_21871[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (23))){
var inst_21790 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
var statearr_21833_21872 = state_21804__$1;
(statearr_21833_21872[(2)] = inst_21790);

(statearr_21833_21872[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (19))){
var inst_21747 = (state_21804[(9)]);
var state_21804__$1 = state_21804;
var statearr_21834_21873 = state_21804__$1;
(statearr_21834_21873[(2)] = inst_21747);

(statearr_21834_21873[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (11))){
var inst_21753 = (state_21804[(11)]);
var inst_21761 = (state_21804[(2)]);
var inst_21762 = fluree.db.util.async.throw_err(inst_21761);
var inst_21763 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21762,(0),null);
var inst_21764 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21762,(1),null);
var inst_21765 = cljs.core.count(inst_21753);
var inst_21766 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21765);
var state_21804__$1 = (function (){var statearr_21836 = state_21804;
(statearr_21836[(7)] = inst_21764);

(statearr_21836[(10)] = inst_21763);

return statearr_21836;
})();
if(inst_21766){
var statearr_21837_21874 = state_21804__$1;
(statearr_21837_21874[(1)] = (12));

} else {
var statearr_21838_21875 = state_21804__$1;
(statearr_21838_21875[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (9))){
var inst_21747 = (state_21804[(9)]);
var state_21804__$1 = state_21804;
var statearr_21839_21876 = state_21804__$1;
(statearr_21839_21876[(2)] = inst_21747);

(statearr_21839_21876[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (5))){
var _ = (function (){var statearr_21840 = state_21804;
(statearr_21840[(4)] = cljs.core.rest((state_21804[(4)])));

return statearr_21840;
})();
var state_21804__$1 = state_21804;
var ex21835 = (state_21804__$1[(2)]);
var statearr_21841_21877 = state_21804__$1;
(statearr_21841_21877[(5)] = ex21835);


if((ex21835 instanceof Error)){
var statearr_21842_21878 = state_21804__$1;
(statearr_21842_21878[(1)] = (4));

(statearr_21842_21878[(5)] = null);

} else {
throw ex21835;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (14))){
var inst_21794 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
var statearr_21843_21879 = state_21804__$1;
(statearr_21843_21879[(2)] = inst_21794);

(statearr_21843_21879[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (26))){
var inst_21788 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
var statearr_21844_21880 = state_21804__$1;
(statearr_21844_21880[(2)] = inst_21788);

(statearr_21844_21880[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (16))){
var inst_21763 = (state_21804[(10)]);
var inst_21779 = (inst_21763 == null);
var state_21804__$1 = state_21804;
if(cljs.core.truth_(inst_21779)){
var statearr_21845_21881 = state_21804__$1;
(statearr_21845_21881[(1)] = (21));

} else {
var statearr_21846_21882 = state_21804__$1;
(statearr_21846_21882[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (10))){
var inst_21797 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
var statearr_21847_21883 = state_21804__$1;
(statearr_21847_21883[(2)] = inst_21797);

(statearr_21847_21883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (18))){
var inst_21763 = (state_21804[(10)]);
var state_21804__$1 = state_21804;
var statearr_21848_21884 = state_21804__$1;
(statearr_21848_21884[(2)] = inst_21763);

(statearr_21848_21884[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (8))){
var inst_21753 = (state_21804[(11)]);
var inst_21747 = (state_21804[(9)]);
var inst_21754 = (state_21804[(12)]);
var inst_21759 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_21747,inst_21753,inst_21754,false,fuel,max_fuel,opts);
var state_21804__$1 = state_21804;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21804__$1,(11),inst_21759);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2733__auto__ = null;
var fluree$db$query$analytical$state_machine__2733__auto____0 = (function (){
var statearr_21849 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21849[(0)] = fluree$db$query$analytical$state_machine__2733__auto__);

(statearr_21849[(1)] = (1));

return statearr_21849;
});
var fluree$db$query$analytical$state_machine__2733__auto____1 = (function (state_21804){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21804);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21850){var ex__2736__auto__ = e21850;
var statearr_21851_21885 = state_21804;
(statearr_21851_21885[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21804[(4)]))){
var statearr_21852_21886 = state_21804;
(statearr_21852_21886[(1)] = cljs.core.first((state_21804[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21887 = state_21804;
state_21804 = G__21887;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2733__auto__ = function(state_21804){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2733__auto____1.call(this,state_21804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2733__auto____0;
fluree$db$query$analytical$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2733__auto____1;
return fluree$db$query$analytical$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21853 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21853[(6)] = c__2755__auto__);

return statearr_21853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21922){
var state_val_21923 = (state_21922[(1)]);
if((state_val_21923 === (7))){
var inst_21904 = (state_21922[(7)]);
var inst_21899 = (state_21922[(8)]);
var inst_21906 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21899,inst_21904,fuel,max_fuel,opts);
var state_21922__$1 = state_21922;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21922__$1,(10),inst_21906);
} else {
if((state_val_21923 === (1))){
var state_21922__$1 = state_21922;
var statearr_21924_21949 = state_21922__$1;
(statearr_21924_21949[(2)] = null);

(statearr_21924_21949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21923 === (4))){
var inst_21888 = (state_21922[(2)]);
var state_21922__$1 = state_21922;
var statearr_21925_21950 = state_21922__$1;
(statearr_21925_21950[(2)] = inst_21888);

(statearr_21925_21950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21923 === (13))){
var inst_21917 = (state_21922[(2)]);
var _ = (function (){var statearr_21926 = state_21922;
(statearr_21926[(4)] = cljs.core.rest((state_21922[(4)])));

return statearr_21926;
})();
var state_21922__$1 = state_21922;
var statearr_21927_21951 = state_21922__$1;
(statearr_21927_21951[(2)] = inst_21917);

(statearr_21927_21951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21923 === (6))){
var inst_21899 = (state_21922[(8)]);
var inst_21903 = (state_21922[(2)]);
var inst_21904 = fluree.db.util.async.throw_err(inst_21903);
var state_21922__$1 = (function (){var statearr_21928 = state_21922;
(statearr_21928[(7)] = inst_21904);

return statearr_21928;
})();
if(cljs.core.truth_(inst_21899)){
var statearr_21929_21952 = state_21922__$1;
(statearr_21929_21952[(1)] = (7));

} else {
var statearr_21930_21953 = state_21922__$1;
(statearr_21930_21953[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21923 === (3))){
var inst_21920 = (state_21922[(2)]);
var state_21922__$1 = state_21922;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21922__$1,inst_21920);
} else {
if((state_val_21923 === (12))){
var inst_21912 = (state_21922[(9)]);
var state_21922__$1 = state_21922;
var statearr_21931_21954 = state_21922__$1;
(statearr_21931_21954[(2)] = inst_21912);

(statearr_21931_21954[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21923 === (2))){
var _ = (function (){var statearr_21932 = state_21922;
(statearr_21932[(4)] = cljs.core.cons((5),(state_21922[(4)])));

return statearr_21932;
})();
var inst_21895 = q_map;
var inst_21896 = cljs.core.__destructure_map(inst_21895);
var inst_21897 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21896,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21896,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21899 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21896,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21900 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21896,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21901 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21898,q_map,inst_21897,fuel,max_fuel,opts);
var state_21922__$1 = (function (){var statearr_21933 = state_21922;
(statearr_21933[(10)] = inst_21900);

(statearr_21933[(8)] = inst_21899);

return statearr_21933;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21922__$1,(6),inst_21901);
} else {
if((state_val_21923 === (11))){
var inst_21900 = (state_21922[(10)]);
var inst_21912 = (state_21922[(9)]);
var inst_21914 = fluree.db.query.analytical.tuples__GT_filtered(inst_21912,inst_21900,null);
var state_21922__$1 = state_21922;
var statearr_21935_21955 = state_21922__$1;
(statearr_21935_21955[(2)] = inst_21914);

(statearr_21935_21955[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21923 === (9))){
var inst_21900 = (state_21922[(10)]);
var inst_21912 = (state_21922[(2)]);
var state_21922__$1 = (function (){var statearr_21936 = state_21922;
(statearr_21936[(9)] = inst_21912);

return statearr_21936;
})();
if(cljs.core.truth_(inst_21900)){
var statearr_21937_21956 = state_21922__$1;
(statearr_21937_21956[(1)] = (11));

} else {
var statearr_21938_21957 = state_21922__$1;
(statearr_21938_21957[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21923 === (5))){
var _ = (function (){var statearr_21939 = state_21922;
(statearr_21939[(4)] = cljs.core.rest((state_21922[(4)])));

return statearr_21939;
})();
var state_21922__$1 = state_21922;
var ex21934 = (state_21922__$1[(2)]);
var statearr_21940_21958 = state_21922__$1;
(statearr_21940_21958[(5)] = ex21934);


if((ex21934 instanceof Error)){
var statearr_21941_21959 = state_21922__$1;
(statearr_21941_21959[(1)] = (4));

(statearr_21941_21959[(5)] = null);

} else {
throw ex21934;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21923 === (10))){
var inst_21908 = (state_21922[(2)]);
var inst_21909 = fluree.db.util.async.throw_err(inst_21908);
var state_21922__$1 = state_21922;
var statearr_21942_21960 = state_21922__$1;
(statearr_21942_21960[(2)] = inst_21909);

(statearr_21942_21960[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21923 === (8))){
var inst_21904 = (state_21922[(7)]);
var state_21922__$1 = state_21922;
var statearr_21943_21961 = state_21922__$1;
(statearr_21943_21961[(2)] = inst_21904);

(statearr_21943_21961[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2733__auto____0 = (function (){
var statearr_21944 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21944[(0)] = fluree$db$query$analytical$q_$_state_machine__2733__auto__);

(statearr_21944[(1)] = (1));

return statearr_21944;
});
var fluree$db$query$analytical$q_$_state_machine__2733__auto____1 = (function (state_21922){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21922);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21945){var ex__2736__auto__ = e21945;
var statearr_21946_21962 = state_21922;
(statearr_21946_21962[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21922[(4)]))){
var statearr_21947_21963 = state_21922;
(statearr_21947_21963[(1)] = cljs.core.first((state_21922[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21964 = state_21922;
state_21922 = G__21964;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2733__auto__ = function(state_21922){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2733__auto____1.call(this,state_21922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2733__auto____0;
fluree$db$query$analytical$q_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21948 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21948[(6)] = c__2755__auto__);

return statearr_21948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
