// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__61115_61284 = cljs.core.seq(servers);
var chunk__61116_61285 = null;
var count__61117_61286 = (0);
var i__61118_61287 = (0);
while(true){
if((i__61118_61287 < count__61117_61286)){
var server_61288 = chunk__61116_61285.cljs$core$IIndexed$_nth$arity$2(null,i__61118_61287);
var healthcheck_uri_61289 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61288),"/fdb/health"].join('');
var resp_chan_61290 = fluree.db.util.xhttp.post_json(healthcheck_uri_61289,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2755__auto___61291 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,c__2755__auto___61291,healthcheck_uri_61289,resp_chan_61290,server_61288){
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = ((function (seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,c__2755__auto___61291,healthcheck_uri_61289,resp_chan_61290,server_61288){
return (function (state_61179){
var state_val_61180 = (state_61179[(1)]);
if((state_val_61180 === (1))){
var state_61179__$1 = state_61179;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61179__$1,(2),resp_chan_61290);
} else {
if((state_val_61180 === (2))){
var inst_61168 = (state_61179[(7)]);
var inst_61168__$1 = (state_61179[(2)]);
var inst_61169 = fluree.db.util.core.exception_QMARK_(inst_61168__$1);
var state_61179__$1 = (function (){var statearr_61181 = state_61179;
(statearr_61181[(7)] = inst_61168__$1);

return statearr_61181;
})();
if(inst_61169){
var statearr_61182_61292 = state_61179__$1;
(statearr_61182_61292[(1)] = (3));

} else {
var statearr_61183_61293 = state_61179__$1;
(statearr_61183_61293[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61180 === (3))){
var inst_61168 = (state_61179[(7)]);
var inst_61171 = cljs.core.ex_message(inst_61168);
var inst_61172 = cljs.core.ex_data(inst_61168);
var inst_61173 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61171,inst_61172], 0));
var state_61179__$1 = state_61179;
var statearr_61184_61294 = state_61179__$1;
(statearr_61184_61294[(2)] = inst_61173);

(statearr_61184_61294[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61180 === (4))){
var inst_61175 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61288);
var state_61179__$1 = state_61179;
var statearr_61185_61295 = state_61179__$1;
(statearr_61185_61295[(2)] = inst_61175);

(statearr_61185_61295[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61180 === (5))){
var inst_61177 = (state_61179[(2)]);
var state_61179__$1 = state_61179;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61179__$1,inst_61177);
} else {
return null;
}
}
}
}
}
});})(seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,c__2755__auto___61291,healthcheck_uri_61289,resp_chan_61290,server_61288))
;
return ((function (seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,switch__2732__auto__,c__2755__auto___61291,healthcheck_uri_61289,resp_chan_61290,server_61288){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0 = (function (){
var statearr_61186 = [null,null,null,null,null,null,null,null];
(statearr_61186[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__);

(statearr_61186[(1)] = (1));

return statearr_61186;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1 = (function (state_61179){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61179);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61187){var ex__2736__auto__ = e61187;
var statearr_61188_61296 = state_61179;
(statearr_61188_61296[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61179[(4)]))){
var statearr_61189_61297 = state_61179;
(statearr_61189_61297[(1)] = cljs.core.first((state_61179[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61298 = state_61179;
state_61179 = G__61298;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = function(state_61179){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1.call(this,state_61179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__;
})()
;})(seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,switch__2732__auto__,c__2755__auto___61291,healthcheck_uri_61289,resp_chan_61290,server_61288))
})();
var state__2757__auto__ = (function (){var statearr_61190 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61190[(6)] = c__2755__auto___61291);

return statearr_61190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});})(seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,c__2755__auto___61291,healthcheck_uri_61289,resp_chan_61290,server_61288))
);



var G__61299 = seq__61115_61284;
var G__61300 = chunk__61116_61285;
var G__61301 = count__61117_61286;
var G__61302 = (i__61118_61287 + (1));
seq__61115_61284 = G__61299;
chunk__61116_61285 = G__61300;
count__61117_61286 = G__61301;
i__61118_61287 = G__61302;
continue;
} else {
var temp__5753__auto___61303 = cljs.core.seq(seq__61115_61284);
if(temp__5753__auto___61303){
var seq__61115_61304__$1 = temp__5753__auto___61303;
if(cljs.core.chunked_seq_QMARK_(seq__61115_61304__$1)){
var c__4649__auto___61305 = cljs.core.chunk_first(seq__61115_61304__$1);
var G__61306 = cljs.core.chunk_rest(seq__61115_61304__$1);
var G__61307 = c__4649__auto___61305;
var G__61308 = cljs.core.count(c__4649__auto___61305);
var G__61309 = (0);
seq__61115_61284 = G__61306;
chunk__61116_61285 = G__61307;
count__61117_61286 = G__61308;
i__61118_61287 = G__61309;
continue;
} else {
var server_61310 = cljs.core.first(seq__61115_61304__$1);
var healthcheck_uri_61311 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61310),"/fdb/health"].join('');
var resp_chan_61312 = fluree.db.util.xhttp.post_json(healthcheck_uri_61311,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2755__auto___61313 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,c__2755__auto___61313,healthcheck_uri_61311,resp_chan_61312,server_61310,seq__61115_61304__$1,temp__5753__auto___61303){
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = ((function (seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,c__2755__auto___61313,healthcheck_uri_61311,resp_chan_61312,server_61310,seq__61115_61304__$1,temp__5753__auto___61303){
return (function (state_61203){
var state_val_61204 = (state_61203[(1)]);
if((state_val_61204 === (1))){
var state_61203__$1 = state_61203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61203__$1,(2),resp_chan_61312);
} else {
if((state_val_61204 === (2))){
var inst_61192 = (state_61203[(7)]);
var inst_61192__$1 = (state_61203[(2)]);
var inst_61193 = fluree.db.util.core.exception_QMARK_(inst_61192__$1);
var state_61203__$1 = (function (){var statearr_61205 = state_61203;
(statearr_61205[(7)] = inst_61192__$1);

return statearr_61205;
})();
if(inst_61193){
var statearr_61206_61314 = state_61203__$1;
(statearr_61206_61314[(1)] = (3));

} else {
var statearr_61207_61315 = state_61203__$1;
(statearr_61207_61315[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61204 === (3))){
var inst_61192 = (state_61203[(7)]);
var inst_61195 = cljs.core.ex_message(inst_61192);
var inst_61196 = cljs.core.ex_data(inst_61192);
var inst_61197 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61195,inst_61196], 0));
var state_61203__$1 = state_61203;
var statearr_61208_61316 = state_61203__$1;
(statearr_61208_61316[(2)] = inst_61197);

(statearr_61208_61316[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61204 === (4))){
var inst_61199 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61310);
var state_61203__$1 = state_61203;
var statearr_61209_61317 = state_61203__$1;
(statearr_61209_61317[(2)] = inst_61199);

(statearr_61209_61317[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61204 === (5))){
var inst_61201 = (state_61203[(2)]);
var state_61203__$1 = state_61203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61203__$1,inst_61201);
} else {
return null;
}
}
}
}
}
});})(seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,c__2755__auto___61313,healthcheck_uri_61311,resp_chan_61312,server_61310,seq__61115_61304__$1,temp__5753__auto___61303))
;
return ((function (seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,switch__2732__auto__,c__2755__auto___61313,healthcheck_uri_61311,resp_chan_61312,server_61310,seq__61115_61304__$1,temp__5753__auto___61303){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0 = (function (){
var statearr_61210 = [null,null,null,null,null,null,null,null];
(statearr_61210[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__);

(statearr_61210[(1)] = (1));

return statearr_61210;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1 = (function (state_61203){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61203);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61211){var ex__2736__auto__ = e61211;
var statearr_61212_61318 = state_61203;
(statearr_61212_61318[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61203[(4)]))){
var statearr_61213_61319 = state_61203;
(statearr_61213_61319[(1)] = cljs.core.first((state_61203[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61320 = state_61203;
state_61203 = G__61320;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = function(state_61203){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1.call(this,state_61203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__;
})()
;})(seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,switch__2732__auto__,c__2755__auto___61313,healthcheck_uri_61311,resp_chan_61312,server_61310,seq__61115_61304__$1,temp__5753__auto___61303))
})();
var state__2757__auto__ = (function (){var statearr_61214 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61214[(6)] = c__2755__auto___61313);

return statearr_61214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});})(seq__61115_61284,chunk__61116_61285,count__61117_61286,i__61118_61287,c__2755__auto___61313,healthcheck_uri_61311,resp_chan_61312,server_61310,seq__61115_61304__$1,temp__5753__auto___61303))
);



var G__61321 = cljs.core.next(seq__61115_61304__$1);
var G__61322 = null;
var G__61323 = (0);
var G__61324 = (0);
seq__61115_61284 = G__61321;
chunk__61116_61285 = G__61322;
count__61117_61286 = G__61323;
i__61118_61287 = G__61324;
continue;
}
} else {
}
}
break;
}

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61258){
var state_val_61259 = (state_61258[(1)]);
if((state_val_61259 === (7))){
var inst_61230 = (state_61258[(7)]);
var inst_61237 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61230,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_61258__$1 = state_61258;
if(inst_61237){
var statearr_61260_61325 = state_61258__$1;
(statearr_61260_61325[(1)] = (9));

} else {
var statearr_61261_61326 = state_61258__$1;
(statearr_61261_61326[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (1))){
var inst_61222 = (state_61258[(8)]);
var inst_61223 = (state_61258[(9)]);
var inst_61222__$1 = promise_chan;
var inst_61223__$1 = cljs.core.async.timeout((60000));
var inst_61224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61225 = [inst_61222__$1,inst_61223__$1];
var inst_61226 = (new cljs.core.PersistentVector(null,2,(5),inst_61224,inst_61225,null));
var state_61258__$1 = (function (){var statearr_61262 = state_61258;
(statearr_61262[(8)] = inst_61222__$1);

(statearr_61262[(9)] = inst_61223__$1);

return statearr_61262;
})();
return cljs.core.async.ioc_alts_BANG_(state_61258__$1,(2),inst_61226);
} else {
if((state_val_61259 === (4))){
var inst_61230 = (state_61258[(7)]);
var inst_61223 = (state_61258[(9)]);
var inst_61234 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61230,inst_61223);
var state_61258__$1 = state_61258;
if(inst_61234){
var statearr_61263_61327 = state_61258__$1;
(statearr_61263_61327[(1)] = (6));

} else {
var statearr_61264_61328 = state_61258__$1;
(statearr_61264_61328[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (13))){
var state_61258__$1 = state_61258;
var statearr_61265_61329 = state_61258__$1;
(statearr_61265_61329[(2)] = null);

(statearr_61265_61329[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (6))){
var state_61258__$1 = state_61258;
var statearr_61266_61330 = state_61258__$1;
(statearr_61266_61330[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_61266_61330[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (3))){
var state_61258__$1 = state_61258;
var statearr_61267_61331 = state_61258__$1;
(statearr_61267_61331[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_61267_61331[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (12))){
var inst_61248 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_61249 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61250 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_61251 = cljs.core.PersistentHashMap.fromArrays(inst_61249,inst_61250);
var inst_61252 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_61251);
var inst_61253 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_61252);
var state_61258__$1 = (function (){var statearr_61268 = state_61258;
(statearr_61268[(10)] = inst_61248);

return statearr_61268;
})();
var statearr_61269_61332 = state_61258__$1;
(statearr_61269_61332[(2)] = inst_61253);

(statearr_61269_61332[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (2))){
var inst_61230 = (state_61258[(7)]);
var inst_61222 = (state_61258[(8)]);
var inst_61228 = (state_61258[(2)]);
var inst_61229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61228,(0),null);
var inst_61230__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61228,(1),null);
var inst_61231 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61230__$1,inst_61222);
var state_61258__$1 = (function (){var statearr_61270 = state_61258;
(statearr_61270[(7)] = inst_61230__$1);

(statearr_61270[(11)] = inst_61229);

return statearr_61270;
})();
if(inst_61231){
var statearr_61271_61333 = state_61258__$1;
(statearr_61271_61333[(1)] = (3));

} else {
var statearr_61272_61334 = state_61258__$1;
(statearr_61272_61334[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (11))){
var inst_61241 = (state_61258[(2)]);
var state_61258__$1 = state_61258;
var statearr_61273_61335 = state_61258__$1;
(statearr_61273_61335[(2)] = inst_61241);

(statearr_61273_61335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (9))){
var inst_61229 = (state_61258[(11)]);
var state_61258__$1 = state_61258;
var statearr_61274_61336 = state_61258__$1;
(statearr_61274_61336[(2)] = inst_61229);

(statearr_61274_61336[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (5))){
var inst_61245 = (state_61258[(2)]);
var inst_61246 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_61245);
var state_61258__$1 = state_61258;
if(inst_61246){
var statearr_61275_61337 = state_61258__$1;
(statearr_61275_61337[(1)] = (12));

} else {
var statearr_61276_61338 = state_61258__$1;
(statearr_61276_61338[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (14))){
var inst_61256 = (state_61258[(2)]);
var state_61258__$1 = state_61258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61258__$1,inst_61256);
} else {
if((state_val_61259 === (10))){
var state_61258__$1 = state_61258;
var statearr_61277_61339 = state_61258__$1;
(statearr_61277_61339[(2)] = null);

(statearr_61277_61339[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61259 === (8))){
var inst_61243 = (state_61258[(2)]);
var state_61258__$1 = state_61258;
var statearr_61278_61340 = state_61258__$1;
(statearr_61278_61340[(2)] = inst_61243);

(statearr_61278_61340[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0 = (function (){
var statearr_61279 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61279[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__);

(statearr_61279[(1)] = (1));

return statearr_61279;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1 = (function (state_61258){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61258);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61280){var ex__2736__auto__ = e61280;
var statearr_61281_61341 = state_61258;
(statearr_61281_61341[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61258[(4)]))){
var statearr_61282_61342 = state_61258;
(statearr_61282_61342[(1)] = cljs.core.first((state_61258[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61343 = state_61258;
state_61258 = G__61343;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = function(state_61258){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1.call(this,state_61258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61283 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61283[(6)] = c__2755__auto__);

return statearr_61283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61387){
var state_val_61388 = (state_61387[(1)]);
if((state_val_61388 === (7))){
var state_61387__$1 = state_61387;
var statearr_61389_61415 = state_61387__$1;
(statearr_61389_61415[(2)] = null);

(statearr_61389_61415[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61388 === (1))){
var state_61387__$1 = state_61387;
var statearr_61390_61416 = state_61387__$1;
(statearr_61390_61416[(2)] = null);

(statearr_61390_61416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61388 === (4))){
var inst_61344 = (state_61387[(2)]);
var state_61387__$1 = state_61387;
var statearr_61391_61417 = state_61387__$1;
(statearr_61391_61417[(2)] = inst_61344);

(statearr_61391_61417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61388 === (6))){
var inst_61366 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_61387__$1 = state_61387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61387__$1,(9),inst_61366);
} else {
if((state_val_61388 === (3))){
var inst_61385 = (state_61387[(2)]);
var state_61387__$1 = state_61387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61387__$1,inst_61385);
} else {
if((state_val_61388 === (12))){
var inst_61379 = (state_61387[(2)]);
var state_61387__$1 = state_61387;
var statearr_61392_61418 = state_61387__$1;
(statearr_61392_61418[(2)] = inst_61379);

(statearr_61392_61418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61388 === (2))){
var inst_61350 = (state_61387[(7)]);
var inst_61360 = (state_61387[(8)]);
var inst_61355 = (state_61387[(9)]);
var _ = (function (){var statearr_61393 = state_61387;
(statearr_61393[(4)] = cljs.core.cons((5),(state_61387[(4)])));

return statearr_61393;
})();
var inst_61350__$1 = fluree.db.util.core.random_uuid();
var inst_61351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61352 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_61353 = (new cljs.core.PersistentVector(null,2,(5),inst_61351,inst_61352,null));
var inst_61354 = (function (){var lock_id = inst_61350__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_61355__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_61353,inst_61354);
var inst_61356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61357 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_61358 = (new cljs.core.PersistentVector(null,3,(5),inst_61356,inst_61357,null));
var inst_61359 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61355__$1,inst_61358);
var inst_61360__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61350__$1,inst_61359);
var inst_61361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61362 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61363 = (new cljs.core.PersistentVector(null,3,(5),inst_61361,inst_61362,null));
var inst_61364 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61355__$1,inst_61363);
var state_61387__$1 = (function (){var statearr_61394 = state_61387;
(statearr_61394[(7)] = inst_61350__$1);

(statearr_61394[(8)] = inst_61360__$1);

(statearr_61394[(9)] = inst_61355__$1);

(statearr_61394[(10)] = inst_61364);

return statearr_61394;
})();
if(inst_61360__$1){
var statearr_61395_61419 = state_61387__$1;
(statearr_61395_61419[(1)] = (6));

} else {
var statearr_61396_61420 = state_61387__$1;
(statearr_61396_61420[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61388 === (11))){
var inst_61370 = (state_61387[(11)]);
var inst_61371 = (state_61387[(12)]);
var inst_61364 = (state_61387[(10)]);
var inst_61377 = fluree.db.util.xhttp.try_socket(inst_61370,sub_chan,pub_chan,inst_61364,(60000),inst_61371);
var state_61387__$1 = state_61387;
var statearr_61398_61421 = state_61387__$1;
(statearr_61398_61421[(2)] = inst_61377);

(statearr_61398_61421[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61388 === (9))){
var inst_61350 = (state_61387[(7)]);
var inst_61370 = (state_61387[(11)]);
var inst_61360 = (state_61387[(8)]);
var inst_61355 = (state_61387[(9)]);
var inst_61364 = (state_61387[(10)]);
var inst_61368 = (state_61387[(13)]);
var inst_61368__$1 = (state_61387[(2)]);
var inst_61369 = clojure.string.replace(inst_61368__$1,"http","ws");
var inst_61370__$1 = [inst_61369,"/fdb/ws"].join('');
var inst_61371 = (function (){var lock_id = inst_61350;
var state = inst_61355;
var have_lock_QMARK_ = inst_61360;
var resp_chan = inst_61364;
var healthy_server = inst_61368__$1;
var ws_url = inst_61370__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_61372 = fluree.db.util.core.exception_QMARK_(inst_61368__$1);
var state_61387__$1 = (function (){var statearr_61399 = state_61387;
(statearr_61399[(11)] = inst_61370__$1);

(statearr_61399[(12)] = inst_61371);

(statearr_61399[(13)] = inst_61368__$1);

return statearr_61399;
})();
if(inst_61372){
var statearr_61400_61422 = state_61387__$1;
(statearr_61400_61422[(1)] = (10));

} else {
var statearr_61401_61423 = state_61387__$1;
(statearr_61401_61423[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61388 === (5))){
var _ = (function (){var statearr_61402 = state_61387;
(statearr_61402[(4)] = cljs.core.rest((state_61387[(4)])));

return statearr_61402;
})();
var state_61387__$1 = state_61387;
var ex61397 = (state_61387__$1[(2)]);
var statearr_61403_61424 = state_61387__$1;
(statearr_61403_61424[(5)] = ex61397);


if((ex61397 instanceof Error)){
var statearr_61404_61425 = state_61387__$1;
(statearr_61404_61425[(1)] = (4));

(statearr_61404_61425[(5)] = null);

} else {
throw ex61397;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61388 === (10))){
var inst_61364 = (state_61387[(10)]);
var inst_61368 = (state_61387[(13)]);
var inst_61374 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_61375 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_61364,inst_61368);
var state_61387__$1 = (function (){var statearr_61405 = state_61387;
(statearr_61405[(14)] = inst_61374);

return statearr_61405;
})();
var statearr_61406_61426 = state_61387__$1;
(statearr_61406_61426[(2)] = inst_61375);

(statearr_61406_61426[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61388 === (8))){
var inst_61364 = (state_61387[(10)]);
var inst_61382 = (state_61387[(2)]);
var _ = (function (){var statearr_61407 = state_61387;
(statearr_61407[(4)] = cljs.core.rest((state_61387[(4)])));

return statearr_61407;
})();
var state_61387__$1 = (function (){var statearr_61408 = state_61387;
(statearr_61408[(15)] = inst_61382);

return statearr_61408;
})();
var statearr_61409_61427 = state_61387__$1;
(statearr_61409_61427[(2)] = inst_61364);

(statearr_61409_61427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2733__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2733__auto____0 = (function (){
var statearr_61410 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61410[(0)] = fluree$db$connection$establish_socket_$_state_machine__2733__auto__);

(statearr_61410[(1)] = (1));

return statearr_61410;
});
var fluree$db$connection$establish_socket_$_state_machine__2733__auto____1 = (function (state_61387){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61387);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61411){var ex__2736__auto__ = e61411;
var statearr_61412_61428 = state_61387;
(statearr_61412_61428[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61387[(4)]))){
var statearr_61413_61429 = state_61387;
(statearr_61413_61429[(1)] = cljs.core.first((state_61387[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61430 = state_61387;
state_61387 = G__61430;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2733__auto__ = function(state_61387){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2733__auto____1.call(this,state_61387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2733__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2733__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61414 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61414[(6)] = c__2755__auto__);

return statearr_61414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k61432,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__61436 = k61432;
var G__61436__$1 = (((G__61436 instanceof cljs.core.Keyword))?G__61436.fqn:null);
switch (G__61436__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k61432,else__4475__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__61437){
var vec__61438 = p__61437;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61438,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61438,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__61431){
var self__ = this;
var G__61431__$1 = this;
return (new cljs.core.RecordIter((0),G__61431__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__61441 = (function (coll__4469__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__61441(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this61433,other61434){
var self__ = this;
var this61433__$1 = this;
return (((!((other61434 == null)))) && ((((this61433__$1.constructor === other61434.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.id,other61434.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.servers,other61434.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.state,other61434.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.req_chan,other61434.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.sub_chan,other61434.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.pub_chan,other61434.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.storage_read,other61434.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.storage_write,other61434.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.object_cache,other61434.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.parallelism,other61434.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.serializer,other61434.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.default_network,other61434.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.transactor_QMARK_,other61434.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.publish,other61434.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.transact_handler,other61434.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.tx_private_key,other61434.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.tx_key_id,other61434.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.meta,other61434.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.add_listener,other61434.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.remove_listener,other61434.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.close,other61434.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61433__$1.__extmap,other61434.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k61432){
var self__ = this;
var this__4479__auto____$1 = this;
var G__61442 = k61432;
var G__61442__$1 = (((G__61442 instanceof cljs.core.Keyword))?G__61442.fqn:null);
switch (G__61442__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k61432);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__61431){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__61443 = cljs.core.keyword_identical_QMARK_;
var expr__61444 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__61446 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__61447 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61446,G__61447) : pred__61443.call(null,G__61446,G__61447));
})())){
return (new fluree.db.connection.Connection(G__61431,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61448 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__61449 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61448,G__61449) : pred__61443.call(null,G__61448,G__61449));
})())){
return (new fluree.db.connection.Connection(self__.id,G__61431,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61450 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__61451 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61450,G__61451) : pred__61443.call(null,G__61450,G__61451));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__61431,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61452 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__61453 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61452,G__61453) : pred__61443.call(null,G__61452,G__61453));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__61431,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61454 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__61455 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61454,G__61455) : pred__61443.call(null,G__61454,G__61455));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__61431,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61456 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__61457 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61456,G__61457) : pred__61443.call(null,G__61456,G__61457));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__61431,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61458 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__61459 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61458,G__61459) : pred__61443.call(null,G__61458,G__61459));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__61431,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61460 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__61461 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61460,G__61461) : pred__61443.call(null,G__61460,G__61461));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__61431,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61462 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__61463 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61462,G__61463) : pred__61443.call(null,G__61462,G__61463));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__61431,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61464 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__61465 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61464,G__61465) : pred__61443.call(null,G__61464,G__61465));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__61431,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61466 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__61467 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61466,G__61467) : pred__61443.call(null,G__61466,G__61467));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__61431,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61468 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__61469 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61468,G__61469) : pred__61443.call(null,G__61468,G__61469));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__61431,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61470 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__61471 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61470,G__61471) : pred__61443.call(null,G__61470,G__61471));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__61431,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61472 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__61473 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61472,G__61473) : pred__61443.call(null,G__61472,G__61473));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__61431,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61474 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__61475 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61474,G__61475) : pred__61443.call(null,G__61474,G__61475));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__61431,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61476 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__61477 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61476,G__61477) : pred__61443.call(null,G__61476,G__61477));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__61431,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61478 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__61479 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61478,G__61479) : pred__61443.call(null,G__61478,G__61479));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__61431,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61480 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__61481 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61480,G__61481) : pred__61443.call(null,G__61480,G__61481));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__61431,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61482 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__61483 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61482,G__61483) : pred__61443.call(null,G__61482,G__61483));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__61431,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61484 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__61485 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61484,G__61485) : pred__61443.call(null,G__61484,G__61485));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__61431,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61486 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__61487 = expr__61444;
return (pred__61443.cljs$core$IFn$_invoke$arity$2 ? pred__61443.cljs$core$IFn$_invoke$arity$2(G__61486,G__61487) : pred__61443.call(null,G__61486,G__61487));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__61431,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__61431),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__61431){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__61431,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__61435){
var extmap__4512__auto__ = (function (){var G__61488 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__61435,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__61435)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__61488);
} else {
return G__61488;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__61435),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__61435),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__61494 = servers_STAR_;
var vec__61495 = G__61494;
var seq__61496 = cljs.core.seq(vec__61495);
var first__61497 = cljs.core.first(seq__61496);
var seq__61496__$1 = cljs.core.next(seq__61496);
var server = first__61497;
var r = seq__61496__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__61494__$1 = G__61494;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__61501 = G__61494__$1;
var seq__61502 = cljs.core.seq(vec__61501);
var first__61503 = cljs.core.first(seq__61502);
var seq__61502__$1 = cljs.core.next(seq__61502);
var server__$1 = first__61503;
var r__$1 = seq__61502__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__61504 = r__$1;
var G__61505 = is_https_QMARK_;
var G__61506 = result_STAR_;
G__61494__$1 = G__61504;
https_QMARK___$1 = G__61505;
result__$1 = G__61506;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__61507 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__61507 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__61507);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61536){
var state_val_61537 = (state_61536[(1)]);
if((state_val_61537 === (7))){
var inst_61522 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61523 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61524 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61525 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61526 = fluree.db.connection.establish_socket(inst_61522,inst_61523,inst_61524,inst_61525);
var state_61536__$1 = state_61536;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61536__$1,(9),inst_61526);
} else {
if((state_val_61537 === (1))){
var state_61536__$1 = state_61536;
var statearr_61538_61557 = state_61536__$1;
(statearr_61538_61557[(2)] = null);

(statearr_61538_61557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61537 === (4))){
var inst_61508 = (state_61536[(2)]);
var state_61536__$1 = state_61536;
var statearr_61539_61558 = state_61536__$1;
(statearr_61539_61558[(2)] = inst_61508);

(statearr_61539_61558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61537 === (6))){
var inst_61519 = (state_61536[(7)]);
var state_61536__$1 = state_61536;
var statearr_61540_61559 = state_61536__$1;
(statearr_61540_61559[(2)] = inst_61519);

(statearr_61540_61559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61537 === (3))){
var inst_61534 = (state_61536[(2)]);
var state_61536__$1 = state_61536;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61536__$1,inst_61534);
} else {
if((state_val_61537 === (2))){
var inst_61519 = (state_61536[(7)]);
var _ = (function (){var statearr_61542 = state_61536;
(statearr_61542[(4)] = cljs.core.cons((5),(state_61536[(4)])));

return statearr_61542;
})();
var inst_61514 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_61515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61516 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61517 = [inst_61516,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61518 = (new cljs.core.PersistentVector(null,3,(5),inst_61515,inst_61517,null));
var inst_61519__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61514,inst_61518);
var state_61536__$1 = (function (){var statearr_61543 = state_61536;
(statearr_61543[(7)] = inst_61519__$1);

return statearr_61543;
})();
if(cljs.core.truth_(inst_61519__$1)){
var statearr_61544_61560 = state_61536__$1;
(statearr_61544_61560[(1)] = (6));

} else {
var statearr_61545_61561 = state_61536__$1;
(statearr_61545_61561[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61537 === (9))){
var inst_61528 = (state_61536[(2)]);
var inst_61529 = fluree.db.util.async.throw_err(inst_61528);
var state_61536__$1 = state_61536;
var statearr_61546_61562 = state_61536__$1;
(statearr_61546_61562[(2)] = inst_61529);

(statearr_61546_61562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61537 === (5))){
var _ = (function (){var statearr_61547 = state_61536;
(statearr_61547[(4)] = cljs.core.rest((state_61536[(4)])));

return statearr_61547;
})();
var state_61536__$1 = state_61536;
var ex61541 = (state_61536__$1[(2)]);
var statearr_61548_61563 = state_61536__$1;
(statearr_61548_61563[(5)] = ex61541);


if((ex61541 instanceof Error)){
var statearr_61549_61564 = state_61536__$1;
(statearr_61549_61564[(1)] = (4));

(statearr_61549_61564[(5)] = null);

} else {
throw ex61541;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61537 === (8))){
var inst_61531 = (state_61536[(2)]);
var _ = (function (){var statearr_61550 = state_61536;
(statearr_61550[(4)] = cljs.core.rest((state_61536[(4)])));

return statearr_61550;
})();
var state_61536__$1 = state_61536;
var statearr_61551_61565 = state_61536__$1;
(statearr_61551_61565[(2)] = inst_61531);

(statearr_61551_61565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2733__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2733__auto____0 = (function (){
var statearr_61552 = [null,null,null,null,null,null,null,null];
(statearr_61552[(0)] = fluree$db$connection$get_socket_$_state_machine__2733__auto__);

(statearr_61552[(1)] = (1));

return statearr_61552;
});
var fluree$db$connection$get_socket_$_state_machine__2733__auto____1 = (function (state_61536){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61536);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61553){var ex__2736__auto__ = e61553;
var statearr_61554_61566 = state_61536;
(statearr_61554_61566[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61536[(4)]))){
var statearr_61555_61567 = state_61536;
(statearr_61555_61567[(1)] = cljs.core.first((state_61536[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61568 = state_61536;
state_61536 = G__61568;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2733__auto__ = function(state_61536){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2733__auto____1.call(this,state_61536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2733__auto____0;
fluree$db$connection$get_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2733__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61556 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61556[(6)] = c__2755__auto__);

return statearr_61556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e61569){var e = e61569;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61696){
var state_val_61697 = (state_61696[(1)]);
if((state_val_61697 === (7))){
var inst_61692 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
var statearr_61699_61769 = state_61696__$1;
(statearr_61699_61769[(2)] = inst_61692);

(statearr_61699_61769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (20))){
var _ = (function (){var statearr_61700 = state_61696;
(statearr_61700[(4)] = cljs.core.rest((state_61696[(4)])));

return statearr_61700;
})();
var state_61696__$1 = state_61696;
var ex61698 = (state_61696__$1[(2)]);
var statearr_61701_61770 = state_61696__$1;
(statearr_61701_61770[(5)] = ex61698);


var statearr_61702_61771 = state_61696__$1;
(statearr_61702_61771[(1)] = (10));

(statearr_61702_61771[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (27))){
var inst_61684 = (state_61696[(2)]);
var _ = (function (){var statearr_61703 = state_61696;
(statearr_61703[(4)] = cljs.core.rest((state_61696[(4)])));

return statearr_61703;
})();
var state_61696__$1 = state_61696;
var statearr_61704_61772 = state_61696__$1;
(statearr_61704_61772[(2)] = inst_61684);

(statearr_61704_61772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (1))){
var inst_61571 = (0);
var state_61696__$1 = (function (){var statearr_61705 = state_61696;
(statearr_61705[(7)] = inst_61571);

return statearr_61705;
})();
var statearr_61706_61773 = state_61696__$1;
(statearr_61706_61773[(2)] = null);

(statearr_61706_61773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (24))){
var inst_61662 = (state_61696[(8)]);
var inst_61662__$1 = (state_61696[(2)]);
var inst_61663 = inst_61662__$1 === true;
var state_61696__$1 = (function (){var statearr_61707 = state_61696;
(statearr_61707[(8)] = inst_61662__$1);

return statearr_61707;
})();
if(cljs.core.truth_(inst_61663)){
var statearr_61708_61774 = state_61696__$1;
(statearr_61708_61774[(1)] = (25));

} else {
var statearr_61709_61775 = state_61696__$1;
(statearr_61709_61775[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (4))){
var inst_61574 = (state_61696[(9)]);
var inst_61574__$1 = (state_61696[(2)]);
var state_61696__$1 = (function (){var statearr_61710 = state_61696;
(statearr_61710[(9)] = inst_61574__$1);

return statearr_61710;
})();
if(cljs.core.truth_(inst_61574__$1)){
var statearr_61711_61776 = state_61696__$1;
(statearr_61711_61776[(1)] = (5));

} else {
var statearr_61712_61777 = state_61696__$1;
(statearr_61712_61777[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (15))){
var inst_61587 = (state_61696[(10)]);
var state_61696__$1 = state_61696;
var statearr_61713_61778 = state_61696__$1;
(statearr_61713_61778[(2)] = inst_61587);

(statearr_61713_61778[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (21))){
var inst_61611 = (state_61696[(11)]);
var inst_61618 = (state_61696[(12)]);
var inst_61571 = (state_61696[(7)]);
var inst_61610 = (state_61696[(13)]);
var inst_61612 = (state_61696[(14)]);
var inst_61574 = (state_61696[(9)]);
var inst_61614 = (state_61696[(15)]);
var inst_61613 = (state_61696[(16)]);
var inst_61615 = (state_61696[(17)]);
var inst_61619 = (state_61696[(18)]);
var inst_61621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61622 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61618];
var inst_61623 = (new cljs.core.PersistentVector(null,2,(5),inst_61621,inst_61622,null));
var inst_61624 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_61623,inst_61613);
var inst_61651 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61652 = (function (){var resp_chan = inst_61613;
var timeout = inst_61619;
var i = inst_61571;
var data = inst_61612;
var vec__61606 = inst_61574;
var map__61609 = inst_61615;
var _ = inst_61610;
var c__2755__auto____$1 = inst_61651;
var req_id = inst_61618;
var operation = inst_61611;
var msg = inst_61574;
var opts = inst_61614;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61649){
var state_val_61650 = (state_61649[(1)]);
if((state_val_61650 === (1))){
var inst_61628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61629 = cljs.core.async.timeout(timeout);
var inst_61630 = [resp_chan,inst_61629];
var inst_61631 = (new cljs.core.PersistentVector(null,2,(5),inst_61628,inst_61630,null));
var state_61649__$1 = state_61649;
return cljs.core.async.ioc_alts_BANG_(state_61649__$1,(2),inst_61631);
} else {
if((state_val_61650 === (2))){
var inst_61634 = (state_61649[(7)]);
var inst_61633 = (state_61649[(2)]);
var inst_61634__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61633,(0),null);
var inst_61635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61633,(1),null);
var inst_61636 = (function (){var vec__61625 = inst_61633;
var resp = inst_61634__$1;
var c = inst_61635;
return (function (p1__61570_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__61570_SHARP_,req_id);
});
})();
var inst_61637 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61636);
var inst_61638 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61635,resp_chan);
var state_61649__$1 = (function (){var statearr_61714 = state_61649;
(statearr_61714[(8)] = inst_61637);

(statearr_61714[(7)] = inst_61634__$1);

return statearr_61714;
})();
if(inst_61638){
var statearr_61715_61779 = state_61649__$1;
(statearr_61715_61779[(1)] = (3));

} else {
var statearr_61716_61780 = state_61649__$1;
(statearr_61716_61780[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61650 === (3))){
var inst_61634 = (state_61649[(7)]);
var state_61649__$1 = state_61649;
var statearr_61717_61781 = state_61649__$1;
(statearr_61717_61781[(2)] = inst_61634);

(statearr_61717_61781[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61650 === (4))){
var inst_61641 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_61642 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61643 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_61644 = cljs.core.PersistentHashMap.fromArrays(inst_61642,inst_61643);
var inst_61645 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61641,inst_61644);
var state_61649__$1 = state_61649;
var statearr_61718_61782 = state_61649__$1;
(statearr_61718_61782[(2)] = inst_61645);

(statearr_61718_61782[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61650 === (5))){
var inst_61647 = (state_61649[(2)]);
var state_61649__$1 = state_61649;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61649__$1,inst_61647);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2733__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2733__auto____0 = (function (){
var statearr_61719 = [null,null,null,null,null,null,null,null,null];
(statearr_61719[(0)] = fluree$db$connection$msg_producer_$_state_machine__2733__auto__);

(statearr_61719[(1)] = (1));

return statearr_61719;
});
var fluree$db$connection$msg_producer_$_state_machine__2733__auto____1 = (function (state_61649){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61649);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61720){var ex__2736__auto__ = e61720;
var statearr_61721_61783 = state_61649;
(statearr_61721_61783[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61649[(4)]))){
var statearr_61722_61784 = state_61649;
(statearr_61722_61784[(1)] = cljs.core.first((state_61649[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61785 = state_61649;
state_61649 = G__61785;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2733__auto__ = function(state_61649){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2733__auto____1.call(this,state_61649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2733__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2733__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61723 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61723[(6)] = c__2755__auto____$1);

return statearr_61723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_61653 = cljs.core.async.impl.dispatch.run(inst_61652);
var state_61696__$1 = (function (){var statearr_61724 = state_61696;
(statearr_61724[(19)] = inst_61653);

(statearr_61724[(20)] = inst_61624);

return statearr_61724;
})();
var statearr_61725_61786 = state_61696__$1;
(statearr_61725_61786[(2)] = inst_61651);

(statearr_61725_61786[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (31))){
var inst_61672 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_61696__$1 = state_61696;
var statearr_61726_61787 = state_61696__$1;
(statearr_61726_61787[(2)] = inst_61672);

(statearr_61726_61787[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (32))){
var state_61696__$1 = state_61696;
var statearr_61727_61788 = state_61696__$1;
(statearr_61727_61788[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (33))){
var inst_61680 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
var statearr_61729_61789 = state_61696__$1;
(statearr_61729_61789[(2)] = inst_61680);

(statearr_61729_61789[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (13))){
var inst_61587 = (state_61696[(10)]);
var inst_61584 = (state_61696[(2)]);
var inst_61585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61584,(0),null);
var inst_61586 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61584,(1),null);
var inst_61587__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61584,(2),null);
var state_61696__$1 = (function (){var statearr_61730 = state_61696;
(statearr_61730[(21)] = inst_61586);

(statearr_61730[(10)] = inst_61587__$1);

(statearr_61730[(22)] = inst_61585);

return statearr_61730;
})();
if(cljs.core.truth_(inst_61587__$1)){
var statearr_61731_61790 = state_61696__$1;
(statearr_61731_61790[(1)] = (14));

} else {
var statearr_61732_61791 = state_61696__$1;
(statearr_61732_61791[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (22))){
var state_61696__$1 = state_61696;
var statearr_61733_61792 = state_61696__$1;
(statearr_61733_61792[(2)] = null);

(statearr_61733_61792[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (36))){
var inst_61678 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
var statearr_61734_61793 = state_61696__$1;
(statearr_61734_61793[(2)] = inst_61678);

(statearr_61734_61793[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (29))){
var inst_61662 = (state_61696[(8)]);
var inst_61670 = (inst_61662 == null);
var state_61696__$1 = state_61696;
if(cljs.core.truth_(inst_61670)){
var statearr_61735_61794 = state_61696__$1;
(statearr_61735_61794[(1)] = (31));

} else {
var statearr_61736_61795 = state_61696__$1;
(statearr_61736_61795[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (6))){
var state_61696__$1 = state_61696;
var statearr_61737_61796 = state_61696__$1;
(statearr_61737_61796[(2)] = null);

(statearr_61737_61796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (28))){
var inst_61662 = (state_61696[(8)]);
var inst_61668 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61662,"Error processing message in producer."], 0));
var state_61696__$1 = state_61696;
var statearr_61738_61797 = state_61696__$1;
(statearr_61738_61797[(2)] = inst_61668);

(statearr_61738_61797[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (25))){
var state_61696__$1 = state_61696;
var statearr_61739_61798 = state_61696__$1;
(statearr_61739_61798[(2)] = null);

(statearr_61739_61798[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (34))){
var inst_61662 = (state_61696[(8)]);
var inst_61675 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_61662], 0));
var state_61696__$1 = state_61696;
var statearr_61740_61799 = state_61696__$1;
(statearr_61740_61799[(2)] = inst_61675);

(statearr_61740_61799[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (17))){
var inst_61576 = (state_61696[(23)]);
var inst_61587 = (state_61696[(10)]);
var inst_61594 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_61587,inst_61576);
var state_61696__$1 = state_61696;
var statearr_61741_61800 = state_61696__$1;
(statearr_61741_61800[(2)] = inst_61594);

(statearr_61741_61800[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (3))){
var inst_61694 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61696__$1,inst_61694);
} else {
if((state_val_61697 === (12))){
var state_61696__$1 = state_61696;
var statearr_61742_61801 = state_61696__$1;
(statearr_61742_61801[(2)] = null);

(statearr_61742_61801[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (2))){
var state_61696__$1 = state_61696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61696__$1,(4),req_chan);
} else {
if((state_val_61697 === (23))){
var inst_61611 = (state_61696[(11)]);
var inst_61618 = (state_61696[(12)]);
var inst_61612 = (state_61696[(14)]);
var inst_61656 = (state_61696[(2)]);
var inst_61657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61658 = [inst_61611,inst_61618,inst_61612];
var inst_61659 = (new cljs.core.PersistentVector(null,3,(5),inst_61657,inst_61658,null));
var inst_61660 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_61659) : publish_fn.call(null,conn,inst_61659));
var state_61696__$1 = (function (){var statearr_61743 = state_61696;
(statearr_61743[(24)] = inst_61656);

return statearr_61743;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61696__$1,(24),inst_61660);
} else {
if((state_val_61697 === (35))){
var state_61696__$1 = state_61696;
var statearr_61744_61802 = state_61696__$1;
(statearr_61744_61802[(2)] = null);

(statearr_61744_61802[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (19))){
var inst_61600 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
var statearr_61745_61803 = state_61696__$1;
(statearr_61745_61803[(2)] = inst_61600);

(statearr_61745_61803[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (11))){
var inst_61574 = (state_61696[(9)]);
var state_61696__$1 = state_61696;
var statearr_61746_61804 = state_61696__$1;
(statearr_61746_61804[(2)] = inst_61574);

(statearr_61746_61804[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (9))){
var inst_61571 = (state_61696[(7)]);
var inst_61687 = (state_61696[(2)]);
var inst_61688 = (inst_61571 + (1));
var inst_61571__$1 = inst_61688;
var state_61696__$1 = (function (){var statearr_61747 = state_61696;
(statearr_61747[(7)] = inst_61571__$1);

(statearr_61747[(25)] = inst_61687);

return statearr_61747;
})();
var statearr_61748_61805 = state_61696__$1;
(statearr_61748_61805[(2)] = null);

(statearr_61748_61805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (5))){
var state_61696__$1 = state_61696;
var statearr_61749_61806 = state_61696__$1;
(statearr_61749_61806[(2)] = null);

(statearr_61749_61806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (14))){
var inst_61587 = (state_61696[(10)]);
var inst_61589 = fluree.db.util.async.channel_QMARK_(inst_61587);
var state_61696__$1 = state_61696;
var statearr_61750_61807 = state_61696__$1;
(statearr_61750_61807[(2)] = inst_61589);

(statearr_61750_61807[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (26))){
var inst_61662 = (state_61696[(8)]);
var inst_61666 = fluree.db.util.core.exception_QMARK_(inst_61662);
var state_61696__$1 = state_61696;
if(inst_61666){
var statearr_61751_61808 = state_61696__$1;
(statearr_61751_61808[(1)] = (28));

} else {
var statearr_61752_61809 = state_61696__$1;
(statearr_61752_61809[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (16))){
var inst_61592 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
if(cljs.core.truth_(inst_61592)){
var statearr_61753_61810 = state_61696__$1;
(statearr_61753_61810[(1)] = (17));

} else {
var statearr_61754_61811 = state_61696__$1;
(statearr_61754_61811[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (30))){
var inst_61682 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
var statearr_61755_61812 = state_61696__$1;
(statearr_61755_61812[(2)] = inst_61682);

(statearr_61755_61812[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (10))){
var inst_61574 = (state_61696[(9)]);
var inst_61576 = (state_61696[(2)]);
var inst_61580 = cljs.core.sequential_QMARK_(inst_61574);
var state_61696__$1 = (function (){var statearr_61756 = state_61696;
(statearr_61756[(23)] = inst_61576);

return statearr_61756;
})();
if(inst_61580){
var statearr_61757_61813 = state_61696__$1;
(statearr_61757_61813[(1)] = (11));

} else {
var statearr_61758_61814 = state_61696__$1;
(statearr_61758_61814[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (18))){
var inst_61576 = (state_61696[(23)]);
var inst_61574 = (state_61696[(9)]);
var inst_61596 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61574], 0));
var inst_61597 = ["Error processing ledger request, no valid return channel: ",inst_61596].join('');
var inst_61598 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61576,inst_61597], 0));
var state_61696__$1 = state_61696;
var statearr_61759_61815 = state_61696__$1;
(statearr_61759_61815[(2)] = inst_61598);

(statearr_61759_61815[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (8))){
var inst_61574 = (state_61696[(9)]);
var inst_61614 = (state_61696[(15)]);
var inst_61613 = (state_61696[(16)]);
var inst_61615 = (state_61696[(17)]);
var _ = (function (){var statearr_61760 = state_61696;
(statearr_61760[(4)] = cljs.core.cons((20),(state_61696[(4)])));

return statearr_61760;
})();
var inst_61610 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_61574], 0));
var inst_61611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61574,(0),null);
var inst_61612 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61574,(1),null);
var inst_61613__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61574,(2),null);
var inst_61614__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61574,(3),null);
var inst_61615__$1 = cljs.core.__destructure_map(inst_61614__$1);
var inst_61616 = fluree.db.util.core.random_uuid();
var inst_61617 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_61616);
var inst_61618 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61615__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_61617);
var inst_61619 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61615__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_61696__$1 = (function (){var statearr_61761 = state_61696;
(statearr_61761[(11)] = inst_61611);

(statearr_61761[(12)] = inst_61618);

(statearr_61761[(13)] = inst_61610);

(statearr_61761[(14)] = inst_61612);

(statearr_61761[(15)] = inst_61614__$1);

(statearr_61761[(16)] = inst_61613__$1);

(statearr_61761[(17)] = inst_61615__$1);

(statearr_61761[(18)] = inst_61619);

return statearr_61761;
})();
if(cljs.core.truth_(inst_61613__$1)){
var statearr_61762_61816 = state_61696__$1;
(statearr_61762_61816[(1)] = (21));

} else {
var statearr_61763_61817 = state_61696__$1;
(statearr_61763_61817[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2733__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2733__auto____0 = (function (){
var statearr_61764 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61764[(0)] = fluree$db$connection$msg_producer_$_state_machine__2733__auto__);

(statearr_61764[(1)] = (1));

return statearr_61764;
});
var fluree$db$connection$msg_producer_$_state_machine__2733__auto____1 = (function (state_61696){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61696);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61765){var ex__2736__auto__ = e61765;
var statearr_61766_61818 = state_61696;
(statearr_61766_61818[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61696[(4)]))){
var statearr_61767_61819 = state_61696;
(statearr_61767_61819[(1)] = cljs.core.first((state_61696[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61820 = state_61696;
state_61696 = G__61820;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2733__auto__ = function(state_61696){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2733__auto____1.call(this,state_61696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2733__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2733__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61768 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61768[(6)] = c__2755__auto__);

return statearr_61768;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__61821 = conn;
var map__61821__$1 = cljs.core.__destructure_map(map__61821);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__61821__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61906){
var state_val_61907 = (state_61906[(1)]);
if((state_val_61907 === (7))){
var inst_61902 = (state_61906[(2)]);
var state_61906__$1 = state_61906;
var statearr_61908_61959 = state_61906__$1;
(statearr_61908_61959[(2)] = inst_61902);

(statearr_61908_61959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (20))){
var inst_61840 = (state_61906[(7)]);
var inst_61854 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_61855 = [inst_61840];
var inst_61856 = cljs.core.PersistentHashMap.fromArrays(inst_61854,inst_61855);
var inst_61857 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_61856], 0));
var state_61906__$1 = state_61906;
var statearr_61909_61960 = state_61906__$1;
(statearr_61909_61960[(2)] = inst_61857);

(statearr_61909_61960[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (27))){
var state_61906__$1 = state_61906;
var statearr_61910_61961 = state_61906__$1;
(statearr_61910_61961[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (1))){
var inst_61822 = (0);
var state_61906__$1 = (function (){var statearr_61912 = state_61906;
(statearr_61912[(8)] = inst_61822);

return statearr_61912;
})();
var statearr_61913_61962 = state_61906__$1;
(statearr_61913_61962[(2)] = null);

(statearr_61913_61962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (24))){
var inst_61833 = (state_61906[(9)]);
var inst_61882 = fluree.db.util.core.exception_QMARK_(inst_61833);
var state_61906__$1 = state_61906;
if(inst_61882){
var statearr_61914_61963 = state_61906__$1;
(statearr_61914_61963[(1)] = (26));

} else {
var statearr_61915_61964 = state_61906__$1;
(statearr_61915_61964[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (4))){
var inst_61827 = (state_61906[(10)]);
var inst_61832 = (state_61906[(2)]);
var inst_61833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61832,(0),null);
var inst_61834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61832,(1),null);
var inst_61835 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61834,inst_61827);
var state_61906__$1 = (function (){var statearr_61916 = state_61906;
(statearr_61916[(9)] = inst_61833);

return statearr_61916;
})();
if(inst_61835){
var statearr_61917_61965 = state_61906__$1;
(statearr_61917_61965[(1)] = (5));

} else {
var statearr_61918_61966 = state_61906__$1;
(statearr_61918_61966[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (15))){
var inst_61840 = (state_61906[(7)]);
var inst_61849 = typeof inst_61840 === 'string';
var state_61906__$1 = state_61906;
if(cljs.core.truth_(inst_61849)){
var statearr_61919_61967 = state_61906__$1;
(statearr_61919_61967[(1)] = (17));

} else {
var statearr_61920_61968 = state_61906__$1;
(statearr_61920_61968[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (21))){
var state_61906__$1 = state_61906;
var statearr_61921_61969 = state_61906__$1;
(statearr_61921_61969[(2)] = null);

(statearr_61921_61969[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (31))){
var inst_61896 = (state_61906[(2)]);
var state_61906__$1 = state_61906;
var statearr_61922_61970 = state_61906__$1;
(statearr_61922_61970[(2)] = inst_61896);

(statearr_61922_61970[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (13))){
var inst_61866 = (state_61906[(2)]);
var inst_61867 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61868 = fluree.db.connection.close_websocket(inst_61867);
var inst_61869 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61870 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_61869);
var state_61906__$1 = (function (){var statearr_61923 = state_61906;
(statearr_61923[(11)] = inst_61866);

(statearr_61923[(12)] = inst_61868);

return statearr_61923;
})();
var statearr_61924_61971 = state_61906__$1;
(statearr_61924_61971[(2)] = inst_61870);

(statearr_61924_61971[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (22))){
var inst_61860 = (state_61906[(2)]);
var state_61906__$1 = state_61906;
var statearr_61925_61972 = state_61906__$1;
(statearr_61925_61972[(2)] = inst_61860);

(statearr_61925_61972[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (29))){
var inst_61833 = (state_61906[(9)]);
var inst_61888 = fluree.db.util.json.parse(inst_61833);
var inst_61889 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61888], 0));
var inst_61890 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_61889], 0));
var inst_61891 = fluree.db.util.json.parse(inst_61833);
var inst_61892 = fluree.db.conn_events.process_events(conn,inst_61891);
var inst_61822 = (0);
var state_61906__$1 = (function (){var statearr_61926 = state_61906;
(statearr_61926[(8)] = inst_61822);

(statearr_61926[(13)] = inst_61892);

(statearr_61926[(14)] = inst_61890);

return statearr_61926;
})();
var statearr_61927_61973 = state_61906__$1;
(statearr_61927_61973[(2)] = null);

(statearr_61927_61973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (6))){
var inst_61833 = (state_61906[(9)]);
var inst_61878 = (inst_61833 == null);
var state_61906__$1 = state_61906;
if(cljs.core.truth_(inst_61878)){
var statearr_61928_61974 = state_61906__$1;
(statearr_61928_61974[(1)] = (23));

} else {
var statearr_61929_61975 = state_61906__$1;
(statearr_61929_61975[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (28))){
var inst_61898 = (state_61906[(2)]);
var state_61906__$1 = state_61906;
var statearr_61930_61976 = state_61906__$1;
(statearr_61930_61976[(2)] = inst_61898);

(statearr_61930_61976[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (25))){
var inst_61900 = (state_61906[(2)]);
var state_61906__$1 = state_61906;
var statearr_61931_61977 = state_61906__$1;
(statearr_61931_61977[(2)] = inst_61900);

(statearr_61931_61977[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (17))){
var inst_61840 = (state_61906[(7)]);
var inst_61851 = cljs.core.eval(inst_61840);
var state_61906__$1 = state_61906;
var statearr_61932_61978 = state_61906__$1;
(statearr_61932_61978[(2)] = inst_61851);

(statearr_61932_61978[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (3))){
var inst_61904 = (state_61906[(2)]);
var state_61906__$1 = state_61906;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61906__$1,inst_61904);
} else {
if((state_val_61907 === (12))){
var inst_61840 = (state_61906[(7)]);
var inst_61845 = cljs.core.fn_QMARK_(inst_61840);
var state_61906__$1 = state_61906;
if(inst_61845){
var statearr_61933_61979 = state_61906__$1;
(statearr_61933_61979[(1)] = (14));

} else {
var statearr_61934_61980 = state_61906__$1;
(statearr_61934_61980[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (2))){
var inst_61827 = (state_61906[(10)]);
var inst_61827__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_61828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61829 = [sub_chan,inst_61827__$1];
var inst_61830 = (new cljs.core.PersistentVector(null,2,(5),inst_61828,inst_61829,null));
var state_61906__$1 = (function (){var statearr_61935 = state_61906;
(statearr_61935[(10)] = inst_61827__$1);

return statearr_61935;
})();
return cljs.core.async.ioc_alts_BANG_(state_61906__$1,(4),inst_61830);
} else {
if((state_val_61907 === (23))){
var inst_61880 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_61906__$1 = state_61906;
var statearr_61936_61981 = state_61906__$1;
(statearr_61936_61981[(2)] = inst_61880);

(statearr_61936_61981[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (19))){
var inst_61862 = (state_61906[(2)]);
var state_61906__$1 = state_61906;
var statearr_61937_61982 = state_61906__$1;
(statearr_61937_61982[(2)] = inst_61862);

(statearr_61937_61982[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (11))){
var inst_61843 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_61906__$1 = state_61906;
var statearr_61938_61983 = state_61906__$1;
(statearr_61938_61983[(2)] = inst_61843);

(statearr_61938_61983[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (9))){
var inst_61822 = (state_61906[(8)]);
var inst_61872 = fluree.db.connection.ping_transactor(conn);
var inst_61873 = (inst_61822 + (1));
var inst_61822__$1 = inst_61873;
var state_61906__$1 = (function (){var statearr_61939 = state_61906;
(statearr_61939[(8)] = inst_61822__$1);

(statearr_61939[(15)] = inst_61872);

return statearr_61939;
})();
var statearr_61940_61984 = state_61906__$1;
(statearr_61940_61984[(2)] = null);

(statearr_61940_61984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (5))){
var inst_61822 = (state_61906[(8)]);
var inst_61837 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_61822);
var state_61906__$1 = state_61906;
if(inst_61837){
var statearr_61941_61985 = state_61906__$1;
(statearr_61941_61985[(1)] = (8));

} else {
var statearr_61942_61986 = state_61906__$1;
(statearr_61942_61986[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (14))){
var inst_61840 = (state_61906[(7)]);
var inst_61847 = (inst_61840.cljs$core$IFn$_invoke$arity$0 ? inst_61840.cljs$core$IFn$_invoke$arity$0() : inst_61840.call(null));
var state_61906__$1 = state_61906;
var statearr_61943_61987 = state_61906__$1;
(statearr_61943_61987[(2)] = inst_61847);

(statearr_61943_61987[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (26))){
var inst_61833 = (state_61906[(9)]);
var inst_61884 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61833], 0));
var inst_61822 = (0);
var state_61906__$1 = (function (){var statearr_61944 = state_61906;
(statearr_61944[(8)] = inst_61822);

(statearr_61944[(16)] = inst_61884);

return statearr_61944;
})();
var statearr_61945_61988 = state_61906__$1;
(statearr_61945_61988[(2)] = null);

(statearr_61945_61988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (16))){
var inst_61864 = (state_61906[(2)]);
var state_61906__$1 = state_61906;
var statearr_61946_61989 = state_61906__$1;
(statearr_61946_61989[(2)] = inst_61864);

(statearr_61946_61989[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (30))){
var state_61906__$1 = state_61906;
var statearr_61947_61990 = state_61906__$1;
(statearr_61947_61990[(2)] = null);

(statearr_61947_61990[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (10))){
var inst_61876 = (state_61906[(2)]);
var state_61906__$1 = state_61906;
var statearr_61948_61991 = state_61906__$1;
(statearr_61948_61991[(2)] = inst_61876);

(statearr_61948_61991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (18))){
var state_61906__$1 = state_61906;
var statearr_61949_61992 = state_61906__$1;
(statearr_61949_61992[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61907 === (8))){
var inst_61840 = (state_61906[(7)]);
var inst_61839 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_61840__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61841 = (inst_61840__$1 == null);
var state_61906__$1 = (function (){var statearr_61951 = state_61906;
(statearr_61951[(7)] = inst_61840__$1);

(statearr_61951[(17)] = inst_61839);

return statearr_61951;
})();
if(cljs.core.truth_(inst_61841)){
var statearr_61952_61993 = state_61906__$1;
(statearr_61952_61993[(1)] = (11));

} else {
var statearr_61953_61994 = state_61906__$1;
(statearr_61953_61994[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2733__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2733__auto____0 = (function (){
var statearr_61954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61954[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2733__auto__);

(statearr_61954[(1)] = (1));

return statearr_61954;
});
var fluree$db$connection$msg_consumer_$_state_machine__2733__auto____1 = (function (state_61906){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61906);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61955){var ex__2736__auto__ = e61955;
var statearr_61956_61995 = state_61906;
(statearr_61956_61995[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61906[(4)]))){
var statearr_61957_61996 = state_61906;
(statearr_61957_61996[(1)] = cljs.core.first((state_61906[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61997 = state_61906;
state_61906 = G__61997;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2733__auto__ = function(state_61906){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2733__auto____1.call(this,state_61906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2733__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2733__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61958 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61958[(6)] = c__2755__auto__);

return statearr_61958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__61999 = arguments.length;
switch (G__61999) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62000 = opts;
var map__62000__$1 = cljs.core.__destructure_map(map__62000);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62000__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62000__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62052){
var state_val_62053 = (state_62052[(1)]);
if((state_val_62053 === (7))){
var inst_62010 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62012 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62013 = (new cljs.core.PersistentVector(null,2,(5),inst_62011,inst_62012,null));
var inst_62014 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62010,inst_62013);
var state_62052__$1 = state_62052;
var statearr_62054_62085 = state_62052__$1;
(statearr_62054_62085[(2)] = inst_62014);

(statearr_62054_62085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (1))){
var state_62052__$1 = state_62052;
var statearr_62055_62086 = state_62052__$1;
(statearr_62055_62086[(2)] = null);

(statearr_62055_62086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (4))){
var inst_62001 = (state_62052[(2)]);
var state_62052__$1 = state_62052;
var statearr_62056_62087 = state_62052__$1;
(statearr_62056_62087[(2)] = inst_62001);

(statearr_62056_62087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (15))){
var inst_62021 = (state_62052[(7)]);
var inst_62040 = (state_62052[(2)]);
var inst_62041 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62042 = [(5000),inst_62040,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_62043 = cljs.core.PersistentHashMap.fromArrays(inst_62041,inst_62042);
var inst_62044 = fluree.db.util.xhttp.get(inst_62021,inst_62043);
var state_62052__$1 = state_62052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62052__$1,(16),inst_62044);
} else {
if((state_val_62053 === (13))){
var inst_62021 = (state_62052[(7)]);
var inst_62031 = (state_62052[(8)]);
var inst_62033 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62034 = [inst_62031];
var inst_62035 = cljs.core.PersistentHashMap.fromArrays(inst_62033,inst_62034);
var inst_62036 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_62021,inst_62035,private$);
var inst_62037 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62036);
var state_62052__$1 = state_62052;
var statearr_62057_62088 = state_62052__$1;
(statearr_62057_62088[(2)] = inst_62037);

(statearr_62057_62088[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (6))){
var inst_62007 = (state_62052[(9)]);
var state_62052__$1 = state_62052;
var statearr_62058_62089 = state_62052__$1;
(statearr_62058_62089[(2)] = inst_62007);

(statearr_62058_62089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (3))){
var inst_62050 = (state_62052[(2)]);
var state_62052__$1 = state_62052;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62052__$1,inst_62050);
} else {
if((state_val_62053 === (12))){
var inst_62031 = (state_62052[(2)]);
var state_62052__$1 = (function (){var statearr_62059 = state_62052;
(statearr_62059[(8)] = inst_62031);

return statearr_62059;
})();
if(cljs.core.truth_(private$)){
var statearr_62060_62090 = state_62052__$1;
(statearr_62060_62090[(1)] = (13));

} else {
var statearr_62061_62091 = state_62052__$1;
(statearr_62061_62091[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (2))){
var inst_62007 = (state_62052[(9)]);
var _ = (function (){var statearr_62062 = state_62052;
(statearr_62062[(4)] = cljs.core.cons((5),(state_62052[(4)])));

return statearr_62062;
})();
var inst_62007__$1 = jwt;
var state_62052__$1 = (function (){var statearr_62063 = state_62052;
(statearr_62063[(9)] = inst_62007__$1);

return statearr_62063;
})();
if(cljs.core.truth_(inst_62007__$1)){
var statearr_62064_62092 = state_62052__$1;
(statearr_62064_62092[(1)] = (6));

} else {
var statearr_62065_62093 = state_62052__$1;
(statearr_62065_62093[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (11))){
var inst_62025 = (state_62052[(10)]);
var state_62052__$1 = state_62052;
var statearr_62067_62094 = state_62052__$1;
(statearr_62067_62094[(2)] = inst_62025);

(statearr_62067_62094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (9))){
var inst_62017 = (state_62052[(11)]);
var inst_62016 = (state_62052[(12)]);
var inst_62020 = (state_62052[(2)]);
var inst_62021 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62020),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62017)].join('');
var inst_62023 = ["Accept"];
var inst_62024 = ["application/json"];
var inst_62025 = cljs.core.PersistentHashMap.fromArrays(inst_62023,inst_62024);
var state_62052__$1 = (function (){var statearr_62068 = state_62052;
(statearr_62068[(10)] = inst_62025);

(statearr_62068[(7)] = inst_62021);

return statearr_62068;
})();
if(cljs.core.truth_(inst_62016)){
var statearr_62069_62095 = state_62052__$1;
(statearr_62069_62095[(1)] = (10));

} else {
var statearr_62070_62096 = state_62052__$1;
(statearr_62070_62096[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (5))){
var _ = (function (){var statearr_62071 = state_62052;
(statearr_62071[(4)] = cljs.core.rest((state_62052[(4)])));

return statearr_62071;
})();
var state_62052__$1 = state_62052;
var ex62066 = (state_62052__$1[(2)]);
var statearr_62072_62097 = state_62052__$1;
(statearr_62072_62097[(5)] = ex62066);


if((ex62066 instanceof Error)){
var statearr_62073_62098 = state_62052__$1;
(statearr_62073_62098[(1)] = (4));

(statearr_62073_62098[(5)] = null);

} else {
throw ex62066;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (14))){
var inst_62031 = (state_62052[(8)]);
var state_62052__$1 = state_62052;
var statearr_62074_62099 = state_62052__$1;
(statearr_62074_62099[(2)] = inst_62031);

(statearr_62074_62099[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (16))){
var inst_62046 = (state_62052[(2)]);
var inst_62047 = fluree.db.util.async.throw_err(inst_62046);
var _ = (function (){var statearr_62075 = state_62052;
(statearr_62075[(4)] = cljs.core.rest((state_62052[(4)])));

return statearr_62075;
})();
var state_62052__$1 = state_62052;
var statearr_62076_62100 = state_62052__$1;
(statearr_62076_62100[(2)] = inst_62047);

(statearr_62076_62100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (10))){
var inst_62025 = (state_62052[(10)]);
var inst_62016 = (state_62052[(12)]);
var inst_62027 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62016)].join('');
var inst_62028 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62025,"Authorization",inst_62027);
var state_62052__$1 = state_62052;
var statearr_62077_62101 = state_62052__$1;
(statearr_62077_62101[(2)] = inst_62028);

(statearr_62077_62101[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62053 === (8))){
var inst_62016 = (state_62052[(2)]);
var inst_62017 = clojure.string.replace(k,"_","/");
var inst_62018 = fluree.db.connection.get_server(conn_id,servers);
var state_62052__$1 = (function (){var statearr_62078 = state_62052;
(statearr_62078[(11)] = inst_62017);

(statearr_62078[(12)] = inst_62016);

return statearr_62078;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62052__$1,(9),inst_62018);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2733__auto__ = null;
var fluree$db$connection$state_machine__2733__auto____0 = (function (){
var statearr_62079 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62079[(0)] = fluree$db$connection$state_machine__2733__auto__);

(statearr_62079[(1)] = (1));

return statearr_62079;
});
var fluree$db$connection$state_machine__2733__auto____1 = (function (state_62052){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62052);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62080){var ex__2736__auto__ = e62080;
var statearr_62081_62102 = state_62052;
(statearr_62081_62102[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62052[(4)]))){
var statearr_62082_62103 = state_62052;
(statearr_62082_62103[(1)] = cljs.core.first((state_62052[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62104 = state_62052;
state_62052 = G__62104;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2733__auto__ = function(state_62052){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2733__auto____1.call(this,state_62052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2733__auto____0;
fluree$db$connection$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2733__auto____1;
return fluree$db$connection$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62083 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62083[(6)] = c__2755__auto__);

return statearr_62083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__62105_SHARP_){
if(cljs.core.truth_(p1__62105_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__62106_SHARP_){
var or__4223__auto__ = p1__62106_SHARP_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return token;
}
}));

return true;
}catch (e62107){var e = e62107;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__62108 = opts;
var map__62108__$1 = cljs.core.__destructure_map(map__62108);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62108__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62108__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4223__auto__ = object_cache;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4223__auto__ = storage_read;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4223__auto__ = storage_exists;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = storage_read;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4221__auto__ = storage_write;
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__62109_62110 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__62109_62110.cljs$core$IFn$_invoke$arity$0 ? fexpr__62109_62110.cljs$core$IFn$_invoke$arity$0() : fexpr__62109_62110.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4835__auto__ = [];
var len__4829__auto___62151 = arguments.length;
var i__4830__auto___62152 = (0);
while(true){
if((i__4830__auto___62152 < len__4829__auto___62151)){
args__4835__auto__.push((arguments[i__4830__auto___62152]));

var G__62153 = (i__4830__auto___62152 + (1));
i__4830__auto___62152 = G__62153;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__62113){
var vec__62114 = p__62113;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62114,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2755__auto___62154 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62134){
var state_val_62135 = (state_62134[(1)]);
if((state_val_62135 === (1))){
var inst_62117 = fluree.db.connection.get_socket(conn);
var state_62134__$1 = state_62134;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62134__$1,(2),inst_62117);
} else {
if((state_val_62135 === (2))){
var inst_62120 = (state_62134[(7)]);
var inst_62119 = (state_62134[(8)]);
var inst_62119__$1 = (state_62134[(2)]);
var inst_62120__$1 = (inst_62119__$1 == null);
var state_62134__$1 = (function (){var statearr_62136 = state_62134;
(statearr_62136[(7)] = inst_62120__$1);

(statearr_62136[(8)] = inst_62119__$1);

return statearr_62136;
})();
if(cljs.core.truth_(inst_62120__$1)){
var statearr_62137_62155 = state_62134__$1;
(statearr_62137_62155[(1)] = (3));

} else {
var statearr_62138_62156 = state_62134__$1;
(statearr_62138_62156[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62135 === (3))){
var inst_62120 = (state_62134[(7)]);
var state_62134__$1 = state_62134;
var statearr_62139_62157 = state_62134__$1;
(statearr_62139_62157[(2)] = inst_62120);

(statearr_62139_62157[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62135 === (4))){
var inst_62119 = (state_62134[(8)]);
var inst_62123 = fluree.db.util.core.exception_QMARK_(inst_62119);
var state_62134__$1 = state_62134;
var statearr_62140_62158 = state_62134__$1;
(statearr_62140_62158[(2)] = inst_62123);

(statearr_62140_62158[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62135 === (5))){
var inst_62125 = (state_62134[(2)]);
var state_62134__$1 = state_62134;
if(cljs.core.truth_(inst_62125)){
var statearr_62141_62159 = state_62134__$1;
(statearr_62141_62159[(1)] = (6));

} else {
var statearr_62142_62160 = state_62134__$1;
(statearr_62142_62160[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62135 === (6))){
var inst_62119 = (state_62134[(8)]);
var inst_62127 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62119,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_62128 = cljs.core.async.close_BANG_(conn);
var state_62134__$1 = (function (){var statearr_62143 = state_62134;
(statearr_62143[(9)] = inst_62127);

return statearr_62143;
})();
var statearr_62144_62161 = state_62134__$1;
(statearr_62144_62161[(2)] = inst_62128);

(statearr_62144_62161[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62135 === (7))){
var inst_62130 = fluree.db.connection.msg_consumer(conn);
var state_62134__$1 = state_62134;
var statearr_62145_62162 = state_62134__$1;
(statearr_62145_62162[(2)] = inst_62130);

(statearr_62145_62162[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62135 === (8))){
var inst_62132 = (state_62134[(2)]);
var state_62134__$1 = state_62134;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62134__$1,inst_62132);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2733__auto__ = null;
var fluree$db$connection$state_machine__2733__auto____0 = (function (){
var statearr_62146 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62146[(0)] = fluree$db$connection$state_machine__2733__auto__);

(statearr_62146[(1)] = (1));

return statearr_62146;
});
var fluree$db$connection$state_machine__2733__auto____1 = (function (state_62134){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62134);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62147){var ex__2736__auto__ = e62147;
var statearr_62148_62163 = state_62134;
(statearr_62148_62163[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62134[(4)]))){
var statearr_62149_62164 = state_62134;
(statearr_62149_62164[(1)] = cljs.core.first((state_62134[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62165 = state_62134;
state_62134 = G__62165;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2733__auto__ = function(state_62134){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2733__auto____1.call(this,state_62134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2733__auto____0;
fluree$db$connection$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2733__auto____1;
return fluree$db$connection$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62150 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62150[(6)] = c__2755__auto___62154);

return statearr_62150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq62111){
var G__62112 = cljs.core.first(seq62111);
var seq62111__$1 = cljs.core.next(seq62111);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62112,seq62111__$1);
}));

