// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('goog.string.format');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4835__auto__ = [];
var len__4829__auto___62793 = arguments.length;
var i__4830__auto___62794 = (0);
while(true){
if((i__4830__auto___62794 < len__4829__auto___62793)){
args__4835__auto__.push((arguments[i__4830__auto___62794]));

var G__62795 = (i__4830__auto___62794 + (1));
i__4830__auto___62794 = G__62795;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__62725){
var vec__62726 = p__62725;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62726,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___62796 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62770){
var state_val_62771 = (state_62770[(1)]);
if((state_val_62771 === (7))){
var inst_62747 = (state_62770[(7)]);
var inst_62756 = (state_62770[(8)]);
var inst_62758 = fluree.db.time_travel.as_of_block(inst_62756,inst_62747);
var state_62770__$1 = state_62770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62770__$1,(10),inst_62758);
} else {
if((state_val_62771 === (1))){
var state_62770__$1 = state_62770;
var statearr_62772_62797 = state_62770__$1;
(statearr_62772_62797[(2)] = null);

(statearr_62772_62797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (4))){
var inst_62729 = (state_62770[(2)]);
var inst_62730 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62729], 0));
var inst_62731 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_62729);
var inst_62732 = cljs.core.async.close_BANG_(pc);
var state_62770__$1 = (function (){var statearr_62773 = state_62770;
(statearr_62773[(9)] = inst_62730);

(statearr_62773[(10)] = inst_62731);

return statearr_62773;
})();
var statearr_62774_62798 = state_62770__$1;
(statearr_62774_62798[(2)] = inst_62732);

(statearr_62774_62798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (6))){
var inst_62747 = (state_62770[(7)]);
var inst_62751 = (state_62770[(11)]);
var inst_62750 = (state_62770[(12)]);
var inst_62754 = (state_62770[(2)]);
var inst_62755 = fluree.db.util.async.throw_err(inst_62754);
var inst_62756 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_62755,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_62750,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_62751], 0));
var state_62770__$1 = (function (){var statearr_62775 = state_62770;
(statearr_62775[(8)] = inst_62756);

return statearr_62775;
})();
if(cljs.core.truth_(inst_62747)){
var statearr_62776_62799 = state_62770__$1;
(statearr_62776_62799[(1)] = (7));

} else {
var statearr_62777_62800 = state_62770__$1;
(statearr_62777_62800[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (3))){
var inst_62768 = (state_62770[(2)]);
var state_62770__$1 = state_62770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62770__$1,inst_62768);
} else {
if((state_val_62771 === (2))){
var _ = (function (){var statearr_62779 = state_62770;
(statearr_62779[(4)] = cljs.core.cons((5),(state_62770[(4)])));

return statearr_62779;
})();
var inst_62742 = opts;
var inst_62743 = cljs.core.__destructure_map(inst_62742);
var inst_62744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62743,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_62745 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62743,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_62746 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62743,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_62747 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62743,new cljs.core.Keyword(null,"block","block",664686210));
var inst_62748 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_62749 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_62750 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62749,(0),null);
var inst_62751 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62749,(1),null);
var inst_62752 = fluree.db.session.db(conn,ledger,opts);
var state_62770__$1 = (function (){var statearr_62780 = state_62770;
(statearr_62780[(13)] = inst_62745);

(statearr_62780[(7)] = inst_62747);

(statearr_62780[(11)] = inst_62751);

(statearr_62780[(14)] = inst_62744);

(statearr_62780[(15)] = inst_62748);

(statearr_62780[(12)] = inst_62750);

(statearr_62780[(16)] = inst_62746);

return statearr_62780;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62770__$1,(6),inst_62752);
} else {
if((state_val_62771 === (9))){
var inst_62764 = (state_62770[(2)]);
var inst_62765 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_62764);
var _ = (function (){var statearr_62781 = state_62770;
(statearr_62781[(4)] = cljs.core.rest((state_62770[(4)])));

return statearr_62781;
})();
var state_62770__$1 = state_62770;
var statearr_62782_62801 = state_62770__$1;
(statearr_62782_62801[(2)] = inst_62765);

(statearr_62782_62801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (5))){
var _ = (function (){var statearr_62783 = state_62770;
(statearr_62783[(4)] = cljs.core.rest((state_62770[(4)])));

return statearr_62783;
})();
var state_62770__$1 = state_62770;
var ex62778 = (state_62770__$1[(2)]);
var statearr_62784_62802 = state_62770__$1;
(statearr_62784_62802[(5)] = ex62778);


var statearr_62785_62803 = state_62770__$1;
(statearr_62785_62803[(1)] = (4));

(statearr_62785_62803[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (10))){
var inst_62760 = (state_62770[(2)]);
var inst_62761 = fluree.db.util.async.throw_err(inst_62760);
var state_62770__$1 = state_62770;
var statearr_62786_62804 = state_62770__$1;
(statearr_62786_62804[(2)] = inst_62761);

(statearr_62786_62804[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (8))){
var inst_62756 = (state_62770[(8)]);
var state_62770__$1 = state_62770;
var statearr_62787_62805 = state_62770__$1;
(statearr_62787_62805[(2)] = inst_62756);

(statearr_62787_62805[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_62788 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62788[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_62788[(1)] = (1));

return statearr_62788;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_62770){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62770);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62789){var ex__2736__auto__ = e62789;
var statearr_62790_62806 = state_62770;
(statearr_62790_62806[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62770[(4)]))){
var statearr_62791_62807 = state_62770;
(statearr_62791_62807[(1)] = cljs.core.first((state_62770[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62808 = state_62770;
state_62770 = G__62808;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_62770){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_62770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62792 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62792[(6)] = c__2755__auto___62796);

return statearr_62792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq62722){
var G__62723 = cljs.core.first(seq62722);
var seq62722__$1 = cljs.core.next(seq62722);
var G__62724 = cljs.core.first(seq62722__$1);
var seq62722__$2 = cljs.core.next(seq62722__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62723,G__62724,seq62722__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4221__auto__){
var and__4221__auto____$1 = open_api;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4221__auto__){
return open_api;
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4221__auto__){
return auth;
} else {
return and__4221__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__62811 = arguments.length;
switch (G__62811) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62941){
var state_val_62942 = (state_62941[(1)]);
if((state_val_62942 === (7))){
var inst_62837 = (state_62941[(7)]);
var inst_62827 = (state_62941[(8)]);
var inst_62839 = fluree.db.time_travel.as_of_block(inst_62837,inst_62827);
var state_62941__$1 = state_62941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62941__$1,(10),inst_62839);
} else {
if((state_val_62942 === (20))){
var inst_62831 = (state_62941[(9)]);
var state_62941__$1 = state_62941;
var statearr_62943_63026 = state_62941__$1;
(statearr_62943_63026[(2)] = inst_62831);

(statearr_62943_63026[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (27))){
var inst_62825 = (state_62941[(10)]);
var state_62941__$1 = state_62941;
var statearr_62944_63027 = state_62941__$1;
(statearr_62944_63027[(2)] = inst_62825);

(statearr_62944_63027[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (1))){
var state_62941__$1 = state_62941;
var statearr_62945_63028 = state_62941__$1;
(statearr_62945_63028[(2)] = null);

(statearr_62945_63028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (24))){
var inst_62834 = (state_62941[(11)]);
var state_62941__$1 = state_62941;
if(cljs.core.truth_(inst_62834)){
var statearr_62946_63029 = state_62941__$1;
(statearr_62946_63029[(1)] = (26));

} else {
var statearr_62947_63030 = state_62941__$1;
(statearr_62947_63030[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (39))){
var inst_62899 = (state_62941[(12)]);
var inst_62902 = cljs.core.ex_data(inst_62899);
var inst_62903 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62904 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_62902);
var inst_62905 = cljs.core.ex_message(inst_62899);
var inst_62906 = [inst_62904,inst_62905,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_62907 = cljs.core.PersistentHashMap.fromArrays(inst_62903,inst_62906);
var state_62941__$1 = state_62941;
var statearr_62948_63031 = state_62941__$1;
(statearr_62948_63031[(2)] = inst_62907);

(statearr_62948_63031[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (46))){
var inst_62899 = (state_62941[(12)]);
var state_62941__$1 = state_62941;
var statearr_62949_63032 = state_62941__$1;
(statearr_62949_63032[(2)] = inst_62899);

(statearr_62949_63032[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (4))){
var inst_62812 = (state_62941[(2)]);
var inst_62813 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62812], 0));
var inst_62814 = cljs.core.ex_data(inst_62812);
var inst_62815 = cljs.core.ex_message(inst_62812);
var inst_62816 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62814,new cljs.core.Keyword(null,"message","message",-406056002),inst_62815);
var state_62941__$1 = (function (){var statearr_62950 = state_62941;
(statearr_62950[(13)] = inst_62813);

return statearr_62950;
})();
var statearr_62951_63033 = state_62941__$1;
(statearr_62951_63033[(2)] = inst_62816);

(statearr_62951_63033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (15))){
var state_62941__$1 = state_62941;
var statearr_62952_63034 = state_62941__$1;
(statearr_62952_63034[(2)] = (1000000));

(statearr_62952_63034[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (48))){
var inst_62899 = (state_62941[(12)]);
var state_62941__$1 = state_62941;
var statearr_62953_63035 = state_62941__$1;
(statearr_62953_63035[(2)] = inst_62899);

(statearr_62953_63035[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (50))){
var inst_62930 = (state_62941[(2)]);
var state_62941__$1 = state_62941;
var statearr_62954_63036 = state_62941__$1;
(statearr_62954_63036[(2)] = inst_62930);

(statearr_62954_63036[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (21))){
var inst_62830 = (state_62941[(14)]);
var state_62941__$1 = state_62941;
if(cljs.core.truth_(inst_62830)){
var statearr_62955_63037 = state_62941__$1;
(statearr_62955_63037[(1)] = (23));

} else {
var statearr_62956_63038 = state_62941__$1;
(statearr_62956_63038[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (31))){
var inst_62888 = (state_62941[(15)]);
var inst_62888__$1 = (state_62941[(2)]);
var inst_62889 = cljs.core.not(inst_62888__$1);
var state_62941__$1 = (function (){var statearr_62957 = state_62941;
(statearr_62957[(15)] = inst_62888__$1);

return statearr_62957;
})();
if(inst_62889){
var statearr_62958_63039 = state_62941__$1;
(statearr_62958_63039[(1)] = (35));

} else {
var statearr_62959_63040 = state_62941__$1;
(statearr_62959_63040[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (32))){
var inst_62832 = (state_62941[(16)]);
var state_62941__$1 = state_62941;
var statearr_62960_63041 = state_62941__$1;
(statearr_62960_63041[(2)] = inst_62832);

(statearr_62960_63041[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (40))){
var inst_62862 = (state_62941[(17)]);
var state_62941__$1 = state_62941;
if(cljs.core.truth_(inst_62862)){
var statearr_62961_63042 = state_62941__$1;
(statearr_62961_63042[(1)] = (42));

} else {
var statearr_62962_63043 = state_62941__$1;
(statearr_62962_63043[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (33))){
var inst_62828 = (state_62941[(18)]);
var state_62941__$1 = state_62941;
var statearr_62963_63044 = state_62941__$1;
(statearr_62963_63044[(2)] = inst_62828);

(statearr_62963_63044[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (13))){
var inst_62833 = (state_62941[(19)]);
var inst_62857 = (state_62941[(20)]);
var inst_62855 = (state_62941[(2)]);
var inst_62856 = cljs.core.volatile_BANG_((0));
var inst_62857__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_62833);
var state_62941__$1 = (function (){var statearr_62964 = state_62941;
(statearr_62964[(20)] = inst_62857__$1);

(statearr_62964[(21)] = inst_62855);

(statearr_62964[(22)] = inst_62856);

return statearr_62964;
})();
if(cljs.core.truth_(inst_62857__$1)){
var statearr_62965_63045 = state_62941__$1;
(statearr_62965_63045[(1)] = (14));

} else {
var statearr_62966_63046 = state_62941__$1;
(statearr_62966_63046[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (22))){
var inst_62878 = (state_62941[(2)]);
var state_62941__$1 = state_62941;
var statearr_62967_63047 = state_62941__$1;
(statearr_62967_63047[(2)] = inst_62878);

(statearr_62967_63047[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (36))){
var inst_62864 = (state_62941[(23)]);
var inst_62845 = (state_62941[(24)]);
var inst_62895 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_62864);
var inst_62896 = fluree.db.query.fql.query(inst_62845,inst_62895);
var state_62941__$1 = state_62941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62941__$1,(38),inst_62896);
} else {
if((state_val_62942 === (41))){
var inst_62934 = (state_62941[(2)]);
var state_62941__$1 = state_62941;
var statearr_62968_63048 = state_62941__$1;
(statearr_62968_63048[(2)] = inst_62934);

(statearr_62968_63048[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (43))){
var state_62941__$1 = state_62941;
var statearr_62969_63049 = state_62941__$1;
(statearr_62969_63049[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (29))){
var inst_62832 = (state_62941[(16)]);
var state_62941__$1 = state_62941;
if(cljs.core.truth_(inst_62832)){
var statearr_62971_63050 = state_62941__$1;
(statearr_62971_63050[(1)] = (32));

} else {
var statearr_62972_63051 = state_62941__$1;
(statearr_62972_63051[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (44))){
var inst_62932 = (state_62941[(2)]);
var state_62941__$1 = state_62941;
var statearr_62973_63052 = state_62941__$1;
(statearr_62973_63052[(2)] = inst_62932);

(statearr_62973_63052[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (6))){
var inst_62827 = (state_62941[(8)]);
var inst_62836 = (state_62941[(2)]);
var inst_62837 = fluree.db.util.async.throw_err(inst_62836);
var state_62941__$1 = (function (){var statearr_62974 = state_62941;
(statearr_62974[(7)] = inst_62837);

return statearr_62974;
})();
if(cljs.core.truth_(inst_62827)){
var statearr_62975_63053 = state_62941__$1;
(statearr_62975_63053[(1)] = (7));

} else {
var statearr_62976_63054 = state_62941__$1;
(statearr_62976_63054[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (28))){
var inst_62874 = (state_62941[(2)]);
var state_62941__$1 = state_62941;
var statearr_62977_63055 = state_62941__$1;
(statearr_62977_63055[(2)] = inst_62874);

(statearr_62977_63055[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (25))){
var inst_62876 = (state_62941[(2)]);
var state_62941__$1 = state_62941;
var statearr_62978_63056 = state_62941__$1;
(statearr_62978_63056[(2)] = inst_62876);

(statearr_62978_63056[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (34))){
var inst_62885 = (state_62941[(2)]);
var state_62941__$1 = state_62941;
var statearr_62979_63057 = state_62941__$1;
(statearr_62979_63057[(2)] = inst_62885);

(statearr_62979_63057[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (17))){
var inst_62826 = (state_62941[(25)]);
var state_62941__$1 = state_62941;
var statearr_62980_63058 = state_62941__$1;
(statearr_62980_63058[(2)] = inst_62826);

(statearr_62980_63058[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (3))){
var inst_62939 = (state_62941[(2)]);
var state_62941__$1 = state_62941;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62941__$1,inst_62939);
} else {
if((state_val_62942 === (12))){
var inst_62853 = cljs.core.PersistentHashMap.EMPTY;
var state_62941__$1 = state_62941;
var statearr_62981_63059 = state_62941__$1;
(statearr_62981_63059[(2)] = inst_62853);

(statearr_62981_63059[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (2))){
var inst_62824 = (state_62941[(26)]);
var _ = (function (){var statearr_62982 = state_62941;
(statearr_62982[(4)] = cljs.core.cons((5),(state_62941[(4)])));

return statearr_62982;
})();
var inst_62823 = query_map;
var inst_62824__$1 = cljs.core.__destructure_map(inst_62823);
var inst_62825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_62826 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_62827 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"block","block",664686210));
var inst_62828 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_62829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_62830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_62831 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_62832 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_62833 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_62834 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62824__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_62941__$1 = (function (){var statearr_62983 = state_62941;
(statearr_62983[(19)] = inst_62833);

(statearr_62983[(8)] = inst_62827);

(statearr_62983[(9)] = inst_62831);

(statearr_62983[(18)] = inst_62828);

(statearr_62983[(16)] = inst_62832);

(statearr_62983[(27)] = inst_62829);

(statearr_62983[(11)] = inst_62834);

(statearr_62983[(25)] = inst_62826);

(statearr_62983[(10)] = inst_62825);

(statearr_62983[(14)] = inst_62830);

(statearr_62983[(26)] = inst_62824__$1);

return statearr_62983;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62941__$1,(6),sources);
} else {
if((state_val_62942 === (23))){
var inst_62830 = (state_62941[(14)]);
var state_62941__$1 = state_62941;
var statearr_62984_63060 = state_62941__$1;
(statearr_62984_63060[(2)] = inst_62830);

(statearr_62984_63060[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (47))){
var inst_62863 = (state_62941[(28)]);
var inst_62888 = (state_62941[(15)]);
var inst_62837 = (state_62941[(7)]);
var inst_62827 = (state_62941[(8)]);
var inst_62831 = (state_62941[(9)]);
var inst_62828 = (state_62941[(18)]);
var inst_62832 = (state_62941[(16)]);
var inst_62846 = (state_62941[(29)]);
var inst_62829 = (state_62941[(27)]);
var inst_62864 = (state_62941[(23)]);
var inst_62855 = (state_62941[(21)]);
var inst_62845 = (state_62941[(24)]);
var inst_62900 = (state_62941[(30)]);
var inst_62862 = (state_62941[(17)]);
var inst_62834 = (state_62941[(11)]);
var inst_62856 = (state_62941[(22)]);
var inst_62826 = (state_62941[(25)]);
var inst_62825 = (state_62941[(10)]);
var inst_62910 = (state_62941[(31)]);
var inst_62830 = (state_62941[(14)]);
var inst_62899 = (state_62941[(12)]);
var inst_62824 = (state_62941[(26)]);
var inst_62861 = (state_62941[(32)]);
var inst_62916 = (state_62941[(2)]);
var inst_62917 = cljs.core.deref(inst_62856);
var inst_62918 = (function (){var error_QMARK_ = inst_62900;
var construct = inst_62825;
var valid_query_QMARK_ = inst_62888;
var conn = inst_62846;
var select = inst_62826;
var block = inst_62827;
var where = inst_62828;
var prefixes = inst_62829;
var db = inst_62837;
var meta_QMARK_ = inst_62862;
var source_opts = inst_62855;
var fuel = inst_62856;
var db_STAR_ = inst_62845;
var selectDistinct = inst_62830;
var map__62822 = inst_62824;
var result = inst_62899;
var start_ms = inst_62863;
var selectOne = inst_62831;
var from = inst_62832;
var max_fuel = inst_62861;
var opts = inst_62864;
var selectReduced = inst_62834;
return (function (p1__62809_SHARP_){
var G__62985 = "%.2fms";
var G__62986 = p1__62809_SHARP_;
return goog.string.format(G__62985,G__62986);
});
})();
var inst_62919 = fluree.db.util.core.current_time_millis();
var inst_62920 = (inst_62919 - inst_62863);
var inst_62921 = (inst_62920 / (1000000));
var inst_62922 = (inst_62918.cljs$core$IFn$_invoke$arity$1 ? inst_62918.cljs$core$IFn$_invoke$arity$1(inst_62921) : inst_62918.call(null,inst_62921));
var inst_62923 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_62845);
var inst_62924 = [(200),inst_62916,inst_62917,inst_62922,inst_62923];
var inst_62925 = cljs.core.PersistentHashMap.fromArrays(inst_62910,inst_62924);
var state_62941__$1 = state_62941;
var statearr_62987_63061 = state_62941__$1;
(statearr_62987_63061[(2)] = inst_62925);

(statearr_62987_63061[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (35))){
var inst_62891 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62892 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_62893 = cljs.core.PersistentHashMap.fromArrays(inst_62891,inst_62892);
var state_62941__$1 = state_62941;
var statearr_62988_63062 = state_62941__$1;
(statearr_62988_63062[(2)] = inst_62893);

(statearr_62988_63062[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (19))){
var inst_62880 = (state_62941[(33)]);
var inst_62880__$1 = (state_62941[(2)]);
var state_62941__$1 = (function (){var statearr_62989 = state_62941;
(statearr_62989[(33)] = inst_62880__$1);

return statearr_62989;
})();
if(cljs.core.truth_(inst_62880__$1)){
var statearr_62990_63063 = state_62941__$1;
(statearr_62990_63063[(1)] = (29));

} else {
var statearr_62991_63064 = state_62941__$1;
(statearr_62991_63064[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (11))){
var inst_62846 = (state_62941[(29)]);
var inst_62829 = (state_62941[(27)]);
var inst_62845 = (state_62941[(24)]);
var inst_62848 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_62845);
var inst_62849 = fluree.db.connection_js.open_api_QMARK_(inst_62846);
var inst_62850 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_62845);
var inst_62851 = fluree.db.api_js.get_sources(inst_62846,inst_62848,inst_62849,inst_62850,inst_62829,db_fn);
var state_62941__$1 = state_62941;
var statearr_62993_63065 = state_62941__$1;
(statearr_62993_63065[(2)] = inst_62851);

(statearr_62993_63065[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (9))){
var inst_62829 = (state_62941[(27)]);
var inst_62845 = (state_62941[(24)]);
var inst_62845__$1 = (state_62941[(2)]);
var inst_62846 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_62845__$1);
var state_62941__$1 = (function (){var statearr_62994 = state_62941;
(statearr_62994[(29)] = inst_62846);

(statearr_62994[(24)] = inst_62845__$1);

return statearr_62994;
})();
if(cljs.core.truth_(inst_62829)){
var statearr_62995_63066 = state_62941__$1;
(statearr_62995_63066[(1)] = (11));

} else {
var statearr_62996_63067 = state_62941__$1;
(statearr_62996_63067[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (5))){
var _ = (function (){var statearr_62997 = state_62941;
(statearr_62997[(4)] = cljs.core.rest((state_62941[(4)])));

return statearr_62997;
})();
var state_62941__$1 = state_62941;
var ex62992 = (state_62941__$1[(2)]);
var statearr_62998_63068 = state_62941__$1;
(statearr_62998_63068[(5)] = ex62992);


var statearr_62999_63069 = state_62941__$1;
(statearr_62999_63069[(1)] = (4));

(statearr_62999_63069[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (14))){
var inst_62857 = (state_62941[(20)]);
var state_62941__$1 = state_62941;
var statearr_63000_63070 = state_62941__$1;
(statearr_63000_63070[(2)] = inst_62857);

(statearr_63000_63070[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (45))){
var inst_62899 = (state_62941[(12)]);
var inst_62913 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_62899);
var state_62941__$1 = state_62941;
var statearr_63001_63071 = state_62941__$1;
(statearr_63001_63071[(2)] = inst_62913);

(statearr_63001_63071[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (26))){
var inst_62834 = (state_62941[(11)]);
var state_62941__$1 = state_62941;
var statearr_63002_63072 = state_62941__$1;
(statearr_63002_63072[(2)] = inst_62834);

(statearr_63002_63072[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (16))){
var inst_62833 = (state_62941[(19)]);
var inst_62855 = (state_62941[(21)]);
var inst_62856 = (state_62941[(22)]);
var inst_62826 = (state_62941[(25)]);
var inst_62861 = (state_62941[(32)]);
var inst_62861__$1 = (state_62941[(2)]);
var inst_62862 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_62833);
var inst_62863 = fluree.db.util.core.current_time_millis();
var inst_62864 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_62833,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_62855,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_62861__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_62856], 0));
var state_62941__$1 = (function (){var statearr_63003 = state_62941;
(statearr_63003[(28)] = inst_62863);

(statearr_63003[(23)] = inst_62864);

(statearr_63003[(17)] = inst_62862);

(statearr_63003[(32)] = inst_62861__$1);

return statearr_63003;
})();
if(cljs.core.truth_(inst_62826)){
var statearr_63004_63073 = state_62941__$1;
(statearr_63004_63073[(1)] = (17));

} else {
var statearr_63005_63074 = state_62941__$1;
(statearr_63005_63074[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (38))){
var inst_62900 = (state_62941[(30)]);
var inst_62899 = (state_62941[(12)]);
var inst_62898 = (state_62941[(2)]);
var inst_62899__$1 = fluree.db.util.async.throw_err(inst_62898);
var inst_62900__$1 = (inst_62899__$1 instanceof cljs.core.ExceptionInfo);
var state_62941__$1 = (function (){var statearr_63006 = state_62941;
(statearr_63006[(30)] = inst_62900__$1);

(statearr_63006[(12)] = inst_62899__$1);

return statearr_63006;
})();
if(cljs.core.truth_(inst_62900__$1)){
var statearr_63007_63075 = state_62941__$1;
(statearr_63007_63075[(1)] = (39));

} else {
var statearr_63008_63076 = state_62941__$1;
(statearr_63008_63076[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (30))){
var inst_62880 = (state_62941[(33)]);
var state_62941__$1 = state_62941;
var statearr_63009_63077 = state_62941__$1;
(statearr_63009_63077[(2)] = inst_62880);

(statearr_63009_63077[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (10))){
var inst_62841 = (state_62941[(2)]);
var inst_62842 = fluree.db.util.async.throw_err(inst_62841);
var state_62941__$1 = state_62941;
var statearr_63010_63078 = state_62941__$1;
(statearr_63010_63078[(2)] = inst_62842);

(statearr_63010_63078[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (18))){
var inst_62831 = (state_62941[(9)]);
var state_62941__$1 = state_62941;
if(cljs.core.truth_(inst_62831)){
var statearr_63011_63079 = state_62941__$1;
(statearr_63011_63079[(1)] = (20));

} else {
var statearr_63012_63080 = state_62941__$1;
(statearr_63012_63080[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (42))){
var inst_62899 = (state_62941[(12)]);
var inst_62910 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_62911 = cljs.core.sequential_QMARK_(inst_62899);
var state_62941__$1 = (function (){var statearr_63013 = state_62941;
(statearr_63013[(31)] = inst_62910);

return statearr_63013;
})();
if(inst_62911){
var statearr_63014_63081 = state_62941__$1;
(statearr_63014_63081[(1)] = (45));

} else {
var statearr_63015_63082 = state_62941__$1;
(statearr_63015_63082[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (37))){
var inst_62936 = (state_62941[(2)]);
var _ = (function (){var statearr_63016 = state_62941;
(statearr_63016[(4)] = cljs.core.rest((state_62941[(4)])));

return statearr_63016;
})();
var state_62941__$1 = state_62941;
var statearr_63017_63083 = state_62941__$1;
(statearr_63017_63083[(2)] = inst_62936);

(statearr_63017_63083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (8))){
var inst_62837 = (state_62941[(7)]);
var state_62941__$1 = state_62941;
var statearr_63018_63084 = state_62941__$1;
(statearr_63018_63084[(2)] = inst_62837);

(statearr_63018_63084[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62942 === (49))){
var state_62941__$1 = state_62941;
var statearr_63019_63085 = state_62941__$1;
(statearr_63019_63085[(2)] = null);

(statearr_63019_63085[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_63020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63020[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_63020[(1)] = (1));

return statearr_63020;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_62941){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62941);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63021){var ex__2736__auto__ = e63021;
var statearr_63022_63086 = state_62941;
(statearr_63022_63086[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62941[(4)]))){
var statearr_63023_63087 = state_62941;
(statearr_63023_63087[(1)] = cljs.core.first((state_62941[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63088 = state_62941;
state_62941 = G__63088;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_62941){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_62941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63024 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63024[(6)] = c__2755__auto__);

return statearr_63024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__63089_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__63089_SHARP_);
}));

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63111){
var state_val_63112 = (state_63111[(1)]);
if((state_val_63112 === (1))){
var inst_63093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63094 = [resp_chan,timeout_chan];
var inst_63095 = (new cljs.core.PersistentVector(null,2,(5),inst_63093,inst_63094,null));
var state_63111__$1 = state_63111;
return cljs.core.async.ioc_alts_BANG_(state_63111__$1,(2),inst_63095);
} else {
if((state_val_63112 === (2))){
var inst_63097 = (state_63111[(2)]);
var inst_63098 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63097,(0),null);
var inst_63099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63097,(1),null);
var inst_63100 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_63099);
var state_63111__$1 = (function (){var statearr_63113 = state_63111;
(statearr_63113[(7)] = inst_63098);

return statearr_63113;
})();
if(inst_63100){
var statearr_63114_63124 = state_63111__$1;
(statearr_63114_63124[(1)] = (3));

} else {
var statearr_63115_63125 = state_63111__$1;
(statearr_63115_63125[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63112 === (3))){
var inst_63102 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_63103 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63104 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_63105 = [tid,(408),inst_63104];
var inst_63106 = cljs.core.PersistentHashMap.fromArrays(inst_63103,inst_63105);
var state_63111__$1 = (function (){var statearr_63116 = state_63111;
(statearr_63116[(8)] = inst_63102);

return statearr_63116;
})();
var statearr_63117_63126 = state_63111__$1;
(statearr_63117_63126[(2)] = inst_63106);

(statearr_63117_63126[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63112 === (4))){
var inst_63098 = (state_63111[(7)]);
var state_63111__$1 = state_63111;
var statearr_63118_63127 = state_63111__$1;
(statearr_63118_63127[(2)] = inst_63098);

(statearr_63118_63127[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63112 === (5))){
var inst_63109 = (state_63111[(2)]);
var state_63111__$1 = state_63111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63111__$1,inst_63109);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____0 = (function (){
var statearr_63119 = [null,null,null,null,null,null,null,null,null];
(statearr_63119[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__);

(statearr_63119[(1)] = (1));

return statearr_63119;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____1 = (function (state_63111){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63111);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63120){var ex__2736__auto__ = e63120;
var statearr_63121_63128 = state_63111;
(statearr_63121_63128[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63111[(4)]))){
var statearr_63122_63129 = state_63111;
(statearr_63122_63129[(1)] = cljs.core.first((state_63111[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63130 = state_63111;
state_63111 = G__63130;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__ = function(state_63111){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____1.call(this,state_63111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63123 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63123[(6)] = c__2755__auto__);

return statearr_63123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__63132 = arguments.length;
switch (G__63132) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__63133 = opts;
var map__63133__$1 = cljs.core.__destructure_map(map__63133);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63133__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63133__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63133__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63133__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__63134 = (cljs.core.truth_((function (){var and__4221__auto__ = auth;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4221__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63134,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63134,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4223__auto__ = nonce;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4223__auto__ = expire;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e63137){var e = e63137;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__63140 = arguments.length;
switch (G__63140) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63206){
var state_val_63207 = (state_63206[(1)]);
if((state_val_63207 === (7))){
var inst_63162 = (state_63206[(7)]);
var inst_63160 = (state_63206[(8)]);
var inst_63159 = (state_63206[(9)]);
var inst_63161 = (state_63206[(10)]);
var inst_63157 = (state_63206[(11)]);
var inst_63175 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_63176 = [ledger,txn,inst_63157,inst_63159,inst_63160,inst_63161,inst_63162];
var inst_63177 = cljs.core.PersistentHashMap.fromArrays(inst_63175,inst_63176);
var inst_63178 = fluree.db.util.core.without_nils(inst_63177);
var inst_63179 = fluree.db.operations.transact_async(conn,inst_63178);
var state_63206__$1 = state_63206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63206__$1,(13),inst_63179);
} else {
if((state_val_63207 === (20))){
var inst_63197 = (state_63206[(2)]);
var state_63206__$1 = state_63206;
var statearr_63208_63244 = state_63206__$1;
(statearr_63208_63244[(2)] = inst_63197);

(statearr_63208_63244[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (1))){
var state_63206__$1 = state_63206;
var statearr_63209_63245 = state_63206__$1;
(statearr_63209_63245[(2)] = null);

(statearr_63209_63245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (4))){
var inst_63141 = (state_63206[(2)]);
var inst_63142 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63141], 0));
var inst_63143 = cljs.core.ex_data(inst_63141);
var inst_63144 = cljs.core.ex_message(inst_63141);
var inst_63145 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63143,new cljs.core.Keyword(null,"message","message",-406056002),inst_63144);
var state_63206__$1 = (function (){var statearr_63210 = state_63206;
(statearr_63210[(12)] = inst_63142);

return statearr_63210;
})();
var statearr_63211_63246 = state_63206__$1;
(statearr_63211_63246[(2)] = inst_63145);

(statearr_63211_63246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (15))){
var inst_63181 = (state_63206[(13)]);
var inst_63156 = (state_63206[(14)]);
var inst_63184 = fluree.db.api_js.monitor_tx(conn,ledger,inst_63181,inst_63156);
var state_63206__$1 = state_63206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63206__$1,(17),inst_63184);
} else {
if((state_val_63207 === (13))){
var inst_63155 = (state_63206[(15)]);
var inst_63181 = (state_63206[(2)]);
var state_63206__$1 = (function (){var statearr_63212 = state_63206;
(statearr_63212[(13)] = inst_63181);

return statearr_63212;
})();
if(cljs.core.truth_(inst_63155)){
var statearr_63213_63247 = state_63206__$1;
(statearr_63213_63247[(1)] = (14));

} else {
var statearr_63214_63248 = state_63206__$1;
(statearr_63214_63248[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (6))){
var inst_63155 = (state_63206[(15)]);
var inst_63154 = (state_63206[(16)]);
var inst_63164 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_63154,opts);
var inst_63165 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_63164);
var inst_63166 = fluree.db.operations.command_async(conn,inst_63164);
var state_63206__$1 = (function (){var statearr_63215 = state_63206;
(statearr_63215[(17)] = inst_63165);

(statearr_63215[(18)] = inst_63166);

return statearr_63215;
})();
if(cljs.core.truth_(inst_63155)){
var statearr_63216_63249 = state_63206__$1;
(statearr_63216_63249[(1)] = (9));

} else {
var statearr_63217_63250 = state_63206__$1;
(statearr_63217_63250[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (17))){
var inst_63186 = (state_63206[(19)]);
var inst_63186__$1 = (state_63206[(2)]);
var inst_63187 = (inst_63186__$1 instanceof cljs.core.ExceptionInfo);
var state_63206__$1 = (function (){var statearr_63218 = state_63206;
(statearr_63218[(19)] = inst_63186__$1);

return statearr_63218;
})();
if(cljs.core.truth_(inst_63187)){
var statearr_63219_63251 = state_63206__$1;
(statearr_63219_63251[(1)] = (18));

} else {
var statearr_63220_63252 = state_63206__$1;
(statearr_63220_63252[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (3))){
var inst_63204 = (state_63206[(2)]);
var state_63206__$1 = state_63206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63206__$1,inst_63204);
} else {
if((state_val_63207 === (12))){
var inst_63171 = (state_63206[(2)]);
var state_63206__$1 = state_63206;
var statearr_63221_63253 = state_63206__$1;
(statearr_63221_63253[(2)] = inst_63171);

(statearr_63221_63253[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (2))){
var inst_63154 = (state_63206[(16)]);
var _ = (function (){var statearr_63222 = state_63206;
(statearr_63222[(4)] = cljs.core.cons((5),(state_63206[(4)])));

return statearr_63222;
})();
var inst_63152 = opts;
var inst_63153 = cljs.core.__destructure_map(inst_63152);
var inst_63154__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63153,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_63155 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63153,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_63156 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_63153,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_63157 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63153,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63158 = fluree.db.util.core.current_time_millis();
var inst_63159 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_63153,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_63158);
var inst_63160 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63153,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_63161 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63153,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_63162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63153,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_63206__$1 = (function (){var statearr_63223 = state_63206;
(statearr_63223[(7)] = inst_63162);

(statearr_63223[(8)] = inst_63160);

(statearr_63223[(9)] = inst_63159);

(statearr_63223[(15)] = inst_63155);

(statearr_63223[(16)] = inst_63154__$1);

(statearr_63223[(10)] = inst_63161);

(statearr_63223[(14)] = inst_63156);

(statearr_63223[(11)] = inst_63157);

return statearr_63223;
})();
if(cljs.core.truth_(inst_63154__$1)){
var statearr_63224_63254 = state_63206__$1;
(statearr_63224_63254[(1)] = (6));

} else {
var statearr_63225_63255 = state_63206__$1;
(statearr_63225_63255[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (19))){
var inst_63186 = (state_63206[(19)]);
var state_63206__$1 = state_63206;
var statearr_63226_63256 = state_63206__$1;
(statearr_63226_63256[(2)] = inst_63186);

(statearr_63226_63256[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (11))){
var inst_63173 = (state_63206[(2)]);
var state_63206__$1 = state_63206;
var statearr_63228_63257 = state_63206__$1;
(statearr_63228_63257[(2)] = inst_63173);

(statearr_63228_63257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (9))){
var inst_63166 = (state_63206[(18)]);
var state_63206__$1 = state_63206;
var statearr_63229_63258 = state_63206__$1;
(statearr_63229_63258[(2)] = inst_63166);

(statearr_63229_63258[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (5))){
var _ = (function (){var statearr_63230 = state_63206;
(statearr_63230[(4)] = cljs.core.rest((state_63206[(4)])));

return statearr_63230;
})();
var state_63206__$1 = state_63206;
var ex63227 = (state_63206__$1[(2)]);
var statearr_63231_63259 = state_63206__$1;
(statearr_63231_63259[(5)] = ex63227);


var statearr_63232_63260 = state_63206__$1;
(statearr_63232_63260[(1)] = (4));

(statearr_63232_63260[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (14))){
var inst_63181 = (state_63206[(13)]);
var state_63206__$1 = state_63206;
var statearr_63233_63261 = state_63206__$1;
(statearr_63233_63261[(2)] = inst_63181);

(statearr_63233_63261[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (16))){
var inst_63199 = (state_63206[(2)]);
var state_63206__$1 = state_63206;
var statearr_63234_63262 = state_63206__$1;
(statearr_63234_63262[(2)] = inst_63199);

(statearr_63234_63262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (10))){
var inst_63165 = (state_63206[(17)]);
var inst_63156 = (state_63206[(14)]);
var inst_63169 = fluree.db.api_js.monitor_tx(conn,ledger,inst_63165,inst_63156);
var state_63206__$1 = state_63206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63206__$1,(12),inst_63169);
} else {
if((state_val_63207 === (18))){
var inst_63186 = (state_63206[(19)]);
var inst_63189 = cljs.core.ex_data(inst_63186);
var inst_63190 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63191 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63189);
var inst_63192 = cljs.core.ex_message(inst_63186);
var inst_63193 = [inst_63191,inst_63192,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_63194 = cljs.core.PersistentHashMap.fromArrays(inst_63190,inst_63193);
var state_63206__$1 = state_63206;
var statearr_63235_63263 = state_63206__$1;
(statearr_63235_63263[(2)] = inst_63194);

(statearr_63235_63263[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63207 === (8))){
var inst_63201 = (state_63206[(2)]);
var _ = (function (){var statearr_63236 = state_63206;
(statearr_63236[(4)] = cljs.core.rest((state_63206[(4)])));

return statearr_63236;
})();
var state_63206__$1 = state_63206;
var statearr_63237_63264 = state_63206__$1;
(statearr_63237_63264[(2)] = inst_63201);

(statearr_63237_63264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_63238 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63238[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_63238[(1)] = (1));

return statearr_63238;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_63206){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63206);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63239){var ex__2736__auto__ = e63239;
var statearr_63240_63265 = state_63206;
(statearr_63240_63265[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63206[(4)]))){
var statearr_63241_63266 = state_63206;
(statearr_63241_63266[(1)] = cljs.core.first((state_63206[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63267 = state_63206;
state_63206 = G__63267;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_63206){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_63206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63242 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63242[(6)] = c__2755__auto__);

return statearr_63242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4835__auto__ = [];
var len__4829__auto___63269 = arguments.length;
var i__4830__auto___63270 = (0);
while(true){
if((i__4830__auto___63270 < len__4829__auto___63269)){
args__4835__auto__.push((arguments[i__4830__auto___63270]));

var G__63271 = (i__4830__auto___63270 + (1));
i__4830__auto___63270 = G__63271;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq63268){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq63268));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63302){
var state_val_63303 = (state_63302[(1)]);
if((state_val_63303 === (1))){
var inst_63272 = cljs.core.first(flakes);
var inst_63273 = cljs.core.rest(flakes);
var inst_63274 = cljs.core.PersistentVector.EMPTY;
var inst_63275 = inst_63272;
var inst_63276 = inst_63273;
var inst_63277 = inst_63274;
var state_63302__$1 = (function (){var statearr_63304 = state_63302;
(statearr_63304[(7)] = inst_63276);

(statearr_63304[(8)] = inst_63275);

(statearr_63304[(9)] = inst_63277);

return statearr_63304;
})();
var statearr_63305_63318 = state_63302__$1;
(statearr_63305_63318[(2)] = null);

(statearr_63305_63318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63303 === (2))){
var inst_63275 = (state_63302[(8)]);
var inst_63279 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_63280 = cljs.core.PersistentHashMap.EMPTY;
var inst_63281 = [true,inst_63280];
var inst_63282 = cljs.core.PersistentHashMap.fromArrays(inst_63279,inst_63281);
var inst_63283 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_63282,inst_63275);
var state_63302__$1 = state_63302;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63302__$1,(4),inst_63283);
} else {
if((state_val_63303 === (3))){
var inst_63300 = (state_63302[(2)]);
var state_63302__$1 = state_63302;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63302__$1,inst_63300);
} else {
if((state_val_63303 === (4))){
var inst_63276 = (state_63302[(7)]);
var inst_63277 = (state_63302[(9)]);
var inst_63285 = (state_63302[(2)]);
var inst_63286 = fluree.db.util.async.throw_err(inst_63285);
var inst_63287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63288 = [inst_63286];
var inst_63289 = (new cljs.core.PersistentVector(null,1,(5),inst_63287,inst_63288,null));
var inst_63290 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_63277,inst_63289);
var inst_63291 = cljs.core.first(inst_63276);
var state_63302__$1 = (function (){var statearr_63306 = state_63302;
(statearr_63306[(10)] = inst_63290);

return statearr_63306;
})();
if(cljs.core.truth_(inst_63291)){
var statearr_63307_63319 = state_63302__$1;
(statearr_63307_63319[(1)] = (5));

} else {
var statearr_63308_63320 = state_63302__$1;
(statearr_63308_63320[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63303 === (5))){
var inst_63276 = (state_63302[(7)]);
var inst_63290 = (state_63302[(10)]);
var inst_63293 = cljs.core.first(inst_63276);
var inst_63294 = cljs.core.rest(inst_63276);
var inst_63275 = inst_63293;
var inst_63276__$1 = inst_63294;
var inst_63277 = inst_63290;
var state_63302__$1 = (function (){var statearr_63309 = state_63302;
(statearr_63309[(7)] = inst_63276__$1);

(statearr_63309[(8)] = inst_63275);

(statearr_63309[(9)] = inst_63277);

return statearr_63309;
})();
var statearr_63310_63321 = state_63302__$1;
(statearr_63310_63321[(2)] = null);

(statearr_63310_63321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63303 === (6))){
var inst_63290 = (state_63302[(10)]);
var state_63302__$1 = state_63302;
var statearr_63311_63322 = state_63302__$1;
(statearr_63311_63322[(2)] = inst_63290);

(statearr_63311_63322[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63303 === (7))){
var inst_63298 = (state_63302[(2)]);
var state_63302__$1 = state_63302;
var statearr_63312_63323 = state_63302__$1;
(statearr_63312_63323[(2)] = inst_63298);

(statearr_63312_63323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____0 = (function (){
var statearr_63313 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63313[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__);

(statearr_63313[(1)] = (1));

return statearr_63313;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____1 = (function (state_63302){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63302);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63314){var ex__2736__auto__ = e63314;
var statearr_63315_63324 = state_63302;
(statearr_63315_63324[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63302[(4)]))){
var statearr_63316_63325 = state_63302;
(statearr_63316_63325[(1)] = cljs.core.first((state_63302[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63326 = state_63302;
state_63302 = G__63326;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__ = function(state_63302){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____1.call(this,state_63302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63317 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63317[(6)] = c__2755__auto__);

return statearr_63317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63394){
var state_val_63395 = (state_63394[(1)]);
if((state_val_63395 === (7))){
var inst_63354 = (state_63394[(2)]);
var inst_63355 = fluree.db.util.async.throw_err(inst_63354);
var state_63394__$1 = state_63394;
var statearr_63396_63422 = state_63394__$1;
(statearr_63396_63422[(2)] = inst_63355);

(statearr_63396_63422[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (1))){
var inst_63331 = cljs.core.volatile_BANG_((0));
var inst_63332 = cljs.core.PersistentHashMap.EMPTY;
var inst_63333 = cljs.core.volatile_BANG_(inst_63332);
var inst_63334 = cljs.core.first(resp);
var inst_63335 = cljs.core.rest(resp);
var inst_63336 = cljs.core.PersistentVector.EMPTY;
var inst_63337 = inst_63331;
var inst_63338 = inst_63333;
var inst_63339 = inst_63334;
var inst_63340 = inst_63335;
var inst_63341 = inst_63336;
var state_63394__$1 = (function (){var statearr_63397 = state_63394;
(statearr_63397[(7)] = inst_63339);

(statearr_63397[(8)] = inst_63341);

(statearr_63397[(9)] = inst_63338);

(statearr_63397[(10)] = inst_63337);

(statearr_63397[(11)] = inst_63340);

return statearr_63397;
})();
var statearr_63398_63423 = state_63394__$1;
(statearr_63398_63423[(2)] = null);

(statearr_63398_63423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (4))){
var inst_63339 = (state_63394[(7)]);
var inst_63341 = (state_63394[(8)]);
var inst_63338 = (state_63394[(9)]);
var inst_63337 = (state_63394[(10)]);
var inst_63345 = (state_63394[(12)]);
var inst_63343 = (state_63394[(13)]);
var inst_63340 = (state_63394[(11)]);
var inst_63349 = (function (){var fuel = inst_63337;
var cache = inst_63338;
var curr_block = inst_63339;
var rest_blocks = inst_63340;
var acc = inst_63341;
var flakes = inst_63343;
var asserted = inst_63345;
return (function (p1__63328_SHARP_){
return p1__63328_SHARP_.s;
});
})();
var inst_63350 = cljs.core.group_by(inst_63349,inst_63345);
var inst_63351 = cljs.core.vals(inst_63350);
var inst_63352 = fluree.db.api_js.format_flake_groups_pretty(db,inst_63338,inst_63337,inst_63351);
var state_63394__$1 = state_63394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63394__$1,(7),inst_63352);
} else {
if((state_val_63395 === (13))){
var inst_63382 = (state_63394[(14)]);
var state_63394__$1 = state_63394;
var statearr_63399_63424 = state_63394__$1;
(statearr_63399_63424[(2)] = inst_63382);

(statearr_63399_63424[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (6))){
var inst_63339 = (state_63394[(7)]);
var inst_63341 = (state_63394[(8)]);
var inst_63338 = (state_63394[(9)]);
var inst_63360 = (state_63394[(15)]);
var inst_63337 = (state_63394[(10)]);
var inst_63358 = (state_63394[(16)]);
var inst_63345 = (state_63394[(12)]);
var inst_63343 = (state_63394[(13)]);
var inst_63340 = (state_63394[(11)]);
var inst_63358__$1 = (state_63394[(2)]);
var inst_63359 = (function (){var fuel = inst_63337;
var cache = inst_63338;
var curr_block = inst_63339;
var rest_blocks = inst_63340;
var acc = inst_63341;
var flakes = inst_63343;
var asserted = inst_63345;
var asserted_SINGLEQUOTE_ = inst_63358__$1;
return (function (p1__63329_SHARP_){
return p1__63329_SHARP_.op === false;
});
})();
var inst_63360__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_63359,inst_63343);
var inst_63361 = cljs.core.empty_QMARK_(inst_63360__$1);
var inst_63362 = (!(inst_63361));
var state_63394__$1 = (function (){var statearr_63402 = state_63394;
(statearr_63402[(15)] = inst_63360__$1);

(statearr_63402[(16)] = inst_63358__$1);

return statearr_63402;
})();
if(inst_63362){
var statearr_63403_63425 = state_63394__$1;
(statearr_63403_63425[(1)] = (8));

} else {
var statearr_63404_63426 = state_63394__$1;
(statearr_63404_63426[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (3))){
var inst_63392 = (state_63394[(2)]);
var state_63394__$1 = state_63394;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63394__$1,inst_63392);
} else {
if((state_val_63395 === (12))){
var inst_63338 = (state_63394[(9)]);
var inst_63337 = (state_63394[(10)]);
var inst_63382 = (state_63394[(14)]);
var inst_63340 = (state_63394[(11)]);
var inst_63385 = cljs.core.first(inst_63340);
var inst_63386 = cljs.core.rest(inst_63340);
var tmp63400 = inst_63338;
var tmp63401 = inst_63337;
var inst_63337__$1 = tmp63401;
var inst_63338__$1 = tmp63400;
var inst_63339 = inst_63385;
var inst_63340__$1 = inst_63386;
var inst_63341 = inst_63382;
var state_63394__$1 = (function (){var statearr_63405 = state_63394;
(statearr_63405[(7)] = inst_63339);

(statearr_63405[(8)] = inst_63341);

(statearr_63405[(9)] = inst_63338__$1);

(statearr_63405[(10)] = inst_63337__$1);

(statearr_63405[(11)] = inst_63340__$1);

return statearr_63405;
})();
var statearr_63406_63427 = state_63394__$1;
(statearr_63406_63427[(2)] = null);

(statearr_63406_63427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (2))){
var inst_63339 = (state_63394[(7)]);
var inst_63341 = (state_63394[(8)]);
var inst_63338 = (state_63394[(9)]);
var inst_63337 = (state_63394[(10)]);
var inst_63345 = (state_63394[(12)]);
var inst_63343 = (state_63394[(13)]);
var inst_63340 = (state_63394[(11)]);
var inst_63343__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_63339);
var inst_63344 = (function (){var fuel = inst_63337;
var cache = inst_63338;
var curr_block = inst_63339;
var rest_blocks = inst_63340;
var acc = inst_63341;
var flakes = inst_63343__$1;
return (function (p1__63327_SHARP_){
return p1__63327_SHARP_.op;
});
})();
var inst_63345__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_63344,inst_63343__$1);
var inst_63346 = cljs.core.empty_QMARK_(inst_63345__$1);
var inst_63347 = (!(inst_63346));
var state_63394__$1 = (function (){var statearr_63407 = state_63394;
(statearr_63407[(12)] = inst_63345__$1);

(statearr_63407[(13)] = inst_63343__$1);

return statearr_63407;
})();
if(inst_63347){
var statearr_63408_63428 = state_63394__$1;
(statearr_63408_63428[(1)] = (4));

} else {
var statearr_63409_63429 = state_63394__$1;
(statearr_63409_63429[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (11))){
var inst_63370 = (state_63394[(2)]);
var inst_63371 = fluree.db.util.async.throw_err(inst_63370);
var state_63394__$1 = state_63394;
var statearr_63410_63430 = state_63394__$1;
(statearr_63410_63430[(2)] = inst_63371);

(statearr_63410_63430[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (9))){
var state_63394__$1 = state_63394;
var statearr_63411_63431 = state_63394__$1;
(statearr_63411_63431[(2)] = null);

(statearr_63411_63431[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (5))){
var state_63394__$1 = state_63394;
var statearr_63412_63432 = state_63394__$1;
(statearr_63412_63432[(2)] = null);

(statearr_63412_63432[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (14))){
var inst_63390 = (state_63394[(2)]);
var state_63394__$1 = state_63394;
var statearr_63413_63433 = state_63394__$1;
(statearr_63413_63433[(2)] = inst_63390);

(statearr_63413_63433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (10))){
var inst_63339 = (state_63394[(7)]);
var inst_63341 = (state_63394[(8)]);
var inst_63358 = (state_63394[(16)]);
var inst_63340 = (state_63394[(11)]);
var inst_63374 = (state_63394[(2)]);
var inst_63375 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_63376 = [inst_63358,inst_63374];
var inst_63377 = cljs.core.PersistentHashMap.fromArrays(inst_63375,inst_63376);
var inst_63378 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63339,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_63377);
var inst_63379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63380 = [inst_63378];
var inst_63381 = (new cljs.core.PersistentVector(null,1,(5),inst_63379,inst_63380,null));
var inst_63382 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_63341,inst_63381);
var inst_63383 = cljs.core.first(inst_63340);
var state_63394__$1 = (function (){var statearr_63414 = state_63394;
(statearr_63414[(14)] = inst_63382);

return statearr_63414;
})();
if(cljs.core.truth_(inst_63383)){
var statearr_63415_63434 = state_63394__$1;
(statearr_63415_63434[(1)] = (12));

} else {
var statearr_63416_63435 = state_63394__$1;
(statearr_63416_63435[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63395 === (8))){
var inst_63339 = (state_63394[(7)]);
var inst_63341 = (state_63394[(8)]);
var inst_63338 = (state_63394[(9)]);
var inst_63360 = (state_63394[(15)]);
var inst_63337 = (state_63394[(10)]);
var inst_63358 = (state_63394[(16)]);
var inst_63345 = (state_63394[(12)]);
var inst_63343 = (state_63394[(13)]);
var inst_63340 = (state_63394[(11)]);
var inst_63364 = (function (){var flakes = inst_63343;
var rest_blocks = inst_63340;
var curr_block = inst_63339;
var asserted_SINGLEQUOTE_ = inst_63358;
var acc = inst_63341;
var fuel = inst_63337;
var cache = inst_63338;
var retracted = inst_63360;
var asserted = inst_63345;
return (function (p1__63330_SHARP_){
return p1__63330_SHARP_.s;
});
})();
var inst_63365 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_63360);
var inst_63366 = cljs.core.group_by(inst_63364,inst_63365);
var inst_63367 = cljs.core.vals(inst_63366);
var inst_63368 = fluree.db.api_js.format_flake_groups_pretty(db,inst_63338,inst_63337,inst_63367);
var state_63394__$1 = state_63394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63394__$1,(11),inst_63368);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____0 = (function (){
var statearr_63417 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63417[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__);

(statearr_63417[(1)] = (1));

return statearr_63417;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____1 = (function (state_63394){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63394);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63418){var ex__2736__auto__ = e63418;
var statearr_63419_63436 = state_63394;
(statearr_63419_63436[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63394[(4)]))){
var statearr_63420_63437 = state_63394;
(statearr_63420_63437[(1)] = cljs.core.first((state_63394[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63438 = state_63394;
state_63394 = G__63438;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__ = function(state_63394){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____1.call(this,state_63394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63421 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63421[(6)] = c__2755__auto__);

return statearr_63421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63538){
var state_val_63539 = (state_63538[(1)]);
if((state_val_63539 === (7))){
var inst_63510 = (state_63538[(7)]);
var inst_63503 = (state_63538[(8)]);
var inst_63509 = cljs.core.seq(inst_63503);
var inst_63510__$1 = cljs.core.first(inst_63509);
var inst_63511 = cljs.core.next(inst_63509);
var state_63538__$1 = (function (){var statearr_63540 = state_63538;
(statearr_63540[(9)] = inst_63511);

(statearr_63540[(7)] = inst_63510__$1);

return statearr_63540;
})();
if(cljs.core.truth_(inst_63510__$1)){
var statearr_63541_63578 = state_63538__$1;
(statearr_63541_63578[(1)] = (9));

} else {
var statearr_63542_63579 = state_63538__$1;
(statearr_63542_63579[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63539 === (1))){
var state_63538__$1 = state_63538;
var statearr_63543_63580 = state_63538__$1;
(statearr_63543_63580[(2)] = null);

(statearr_63543_63580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63539 === (4))){
var inst_63440 = (state_63538[(2)]);
var state_63538__$1 = state_63538;
var statearr_63544_63581 = state_63538__$1;
(statearr_63544_63581[(2)] = inst_63440);

(statearr_63544_63581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63539 === (6))){
var inst_63489 = (state_63538[(2)]);
var inst_63490 = fluree.db.util.async.throw_err(inst_63489);
var inst_63498 = resp;
var inst_63499 = cljs.core.seq(inst_63498);
var inst_63500 = cljs.core.first(inst_63499);
var inst_63501 = cljs.core.next(inst_63499);
var inst_63502 = cljs.core.PersistentHashMap.EMPTY;
var inst_63503 = inst_63498;
var inst_63504 = inst_63502;
var state_63538__$1 = (function (){var statearr_63545 = state_63538;
(statearr_63545[(10)] = inst_63490);

(statearr_63545[(11)] = inst_63504);

(statearr_63545[(12)] = inst_63501);

(statearr_63545[(13)] = inst_63500);

(statearr_63545[(8)] = inst_63503);

return statearr_63545;
})();
var statearr_63546_63582 = state_63538__$1;
(statearr_63546_63582[(2)] = null);

(statearr_63546_63582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63539 === (3))){
var inst_63536 = (state_63538[(2)]);
var state_63538__$1 = state_63538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63538__$1,inst_63536);
} else {
if((state_val_63539 === (2))){
var _ = (function (){var statearr_63547 = state_63538;
(statearr_63547[(4)] = cljs.core.cons((5),(state_63538[(4)])));

return statearr_63547;
})();
var inst_63446 = (function (){return (function (p1__63439_SHARP_){
return p1__63439_SHARP_.t;
});
})();
var inst_63447 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_63446,resp);
var inst_63448 = cljs.core.set(inst_63447);
var inst_63485 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_63486 = (function (){var ts = inst_63448;
var c__2755__auto____$1 = inst_63485;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63483){
var state_val_63484 = (state_63483[(1)]);
if((state_val_63484 === (1))){
var inst_63456 = ts;
var inst_63457 = cljs.core.seq(inst_63456);
var inst_63458 = cljs.core.first(inst_63457);
var inst_63459 = cljs.core.next(inst_63457);
var inst_63460 = cljs.core.PersistentHashMap.EMPTY;
var inst_63461 = inst_63456;
var inst_63462 = inst_63460;
var state_63483__$1 = (function (){var statearr_63548 = state_63483;
(statearr_63548[(7)] = inst_63461);

(statearr_63548[(8)] = inst_63459);

(statearr_63548[(9)] = inst_63462);

(statearr_63548[(10)] = inst_63458);

return statearr_63548;
})();
var statearr_63549_63583 = state_63483__$1;
(statearr_63549_63583[(2)] = null);

(statearr_63549_63583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63484 === (2))){
var inst_63461 = (state_63483[(7)]);
var inst_63468 = (state_63483[(11)]);
var inst_63467 = cljs.core.seq(inst_63461);
var inst_63468__$1 = cljs.core.first(inst_63467);
var inst_63469 = cljs.core.next(inst_63467);
var state_63483__$1 = (function (){var statearr_63550 = state_63483;
(statearr_63550[(11)] = inst_63468__$1);

(statearr_63550[(12)] = inst_63469);

return statearr_63550;
})();
if(cljs.core.truth_(inst_63468__$1)){
var statearr_63551_63584 = state_63483__$1;
(statearr_63551_63584[(1)] = (4));

} else {
var statearr_63552_63585 = state_63483__$1;
(statearr_63552_63585[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63484 === (3))){
var inst_63481 = (state_63483[(2)]);
var state_63483__$1 = state_63483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63483__$1,inst_63481);
} else {
if((state_val_63484 === (4))){
var inst_63468 = (state_63483[(11)]);
var inst_63471 = fluree.db.time_travel.non_border_t_to_block(db,inst_63468);
var state_63483__$1 = state_63483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63483__$1,(7),inst_63471);
} else {
if((state_val_63484 === (5))){
var inst_63462 = (state_63483[(9)]);
var state_63483__$1 = state_63483;
var statearr_63553_63586 = state_63483__$1;
(statearr_63553_63586[(2)] = inst_63462);

(statearr_63553_63586[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63484 === (6))){
var inst_63479 = (state_63483[(2)]);
var state_63483__$1 = state_63483;
var statearr_63554_63587 = state_63483__$1;
(statearr_63554_63587[(2)] = inst_63479);

(statearr_63554_63587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63484 === (7))){
var inst_63468 = (state_63483[(11)]);
var inst_63462 = (state_63483[(9)]);
var inst_63469 = (state_63483[(12)]);
var inst_63473 = (state_63483[(2)]);
var inst_63474 = fluree.db.util.async.throw_err(inst_63473);
var inst_63475 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63462,inst_63468,inst_63474);
var inst_63461 = inst_63469;
var inst_63462__$1 = inst_63475;
var state_63483__$1 = (function (){var statearr_63555 = state_63483;
(statearr_63555[(7)] = inst_63461);

(statearr_63555[(9)] = inst_63462__$1);

return statearr_63555;
})();
var statearr_63556_63588 = state_63483__$1;
(statearr_63556_63588[(2)] = null);

(statearr_63556_63588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_63557 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63557[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__);

(statearr_63557[(1)] = (1));

return statearr_63557;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1 = (function (state_63483){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63483);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63558){var ex__2736__auto__ = e63558;
var statearr_63559_63589 = state_63483;
(statearr_63559_63589[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63483[(4)]))){
var statearr_63560_63590 = state_63483;
(statearr_63560_63590[(1)] = cljs.core.first((state_63483[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63591 = state_63483;
state_63483 = G__63591;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__ = function(state_63483){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1.call(this,state_63483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63561 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63561[(6)] = c__2755__auto____$1);

return statearr_63561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_63487 = cljs.core.async.impl.dispatch.run(inst_63486);
var state_63538__$1 = (function (){var statearr_63562 = state_63538;
(statearr_63562[(14)] = inst_63487);

return statearr_63562;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63538__$1,(6),inst_63485);
} else {
if((state_val_63539 === (11))){
var inst_63530 = (state_63538[(2)]);
var state_63538__$1 = state_63538;
var statearr_63564_63592 = state_63538__$1;
(statearr_63564_63592[(2)] = inst_63530);

(statearr_63564_63592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63539 === (9))){
var inst_63490 = (state_63538[(10)]);
var inst_63504 = (state_63538[(11)]);
var inst_63511 = (state_63538[(9)]);
var inst_63510 = (state_63538[(7)]);
var inst_63513 = inst_63510.t;
var inst_63514 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63490,inst_63513);
var inst_63515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63516 = [inst_63514,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_63517 = (new cljs.core.PersistentVector(null,2,(5),inst_63515,inst_63516,null));
var inst_63518 = cljs.core.assoc_in(inst_63504,inst_63517,inst_63514);
var inst_63519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63520 = [inst_63514,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_63521 = (new cljs.core.PersistentVector(null,2,(5),inst_63519,inst_63520,null));
var inst_63522 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_63518,inst_63521,cljs.core.conj,inst_63510);
var inst_63523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63524 = [inst_63514,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_63525 = (new cljs.core.PersistentVector(null,2,(5),inst_63523,inst_63524,null));
var inst_63526 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_63522,inst_63525,fluree.db.api_js.min_safe,inst_63513);
var inst_63503 = inst_63511;
var inst_63504__$1 = inst_63526;
var state_63538__$1 = (function (){var statearr_63565 = state_63538;
(statearr_63565[(11)] = inst_63504__$1);

(statearr_63565[(8)] = inst_63503);

return statearr_63565;
})();
var statearr_63566_63593 = state_63538__$1;
(statearr_63566_63593[(2)] = null);

(statearr_63566_63593[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63539 === (5))){
var _ = (function (){var statearr_63567 = state_63538;
(statearr_63567[(4)] = cljs.core.rest((state_63538[(4)])));

return statearr_63567;
})();
var state_63538__$1 = state_63538;
var ex63563 = (state_63538__$1[(2)]);
var statearr_63568_63594 = state_63538__$1;
(statearr_63568_63594[(5)] = ex63563);


if((ex63563 instanceof Error)){
var statearr_63569_63595 = state_63538__$1;
(statearr_63569_63595[(1)] = (4));

(statearr_63569_63595[(5)] = null);

} else {
throw ex63563;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63539 === (10))){
var inst_63504 = (state_63538[(11)]);
var state_63538__$1 = state_63538;
var statearr_63570_63596 = state_63538__$1;
(statearr_63570_63596[(2)] = inst_63504);

(statearr_63570_63596[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63539 === (8))){
var inst_63532 = (state_63538[(2)]);
var inst_63533 = cljs.core.vals(inst_63532);
var _ = (function (){var statearr_63571 = state_63538;
(statearr_63571[(4)] = cljs.core.rest((state_63538[(4)])));

return statearr_63571;
})();
var state_63538__$1 = state_63538;
var statearr_63572_63597 = state_63538__$1;
(statearr_63572_63597[(2)] = inst_63533);

(statearr_63572_63597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_63573 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63573[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__);

(statearr_63573[(1)] = (1));

return statearr_63573;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1 = (function (state_63538){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63538);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63574){var ex__2736__auto__ = e63574;
var statearr_63575_63598 = state_63538;
(statearr_63575_63598[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63538[(4)]))){
var statearr_63576_63599 = state_63538;
(statearr_63576_63599[(1)] = cljs.core.first((state_63538[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63600 = state_63538;
state_63538 = G__63600;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__ = function(state_63538){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1.call(this,state_63538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63577 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63577[(6)] = c__2755__auto__);

return statearr_63577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63745){
var state_val_63746 = (state_63745[(1)]);
if((state_val_63746 === (7))){
var inst_63625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63626 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_63627 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_63628 = [inst_63626,inst_63627];
var inst_63629 = (new cljs.core.PersistentVector(null,2,(5),inst_63625,inst_63628,null));
var state_63745__$1 = state_63745;
var statearr_63747_63818 = state_63745__$1;
(statearr_63747_63818[(2)] = inst_63629);

(statearr_63747_63818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (20))){
var inst_63655 = (state_63745[(7)]);
var state_63745__$1 = state_63745;
var statearr_63748_63819 = state_63745__$1;
(statearr_63748_63819[(2)] = inst_63655);

(statearr_63748_63819[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (27))){
var state_63745__$1 = state_63745;
var statearr_63749_63820 = state_63745__$1;
(statearr_63749_63820[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (1))){
var state_63745__$1 = state_63745;
var statearr_63751_63821 = state_63745__$1;
(statearr_63751_63821[(2)] = null);

(statearr_63751_63821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (24))){
var inst_63654 = (state_63745[(8)]);
var state_63745__$1 = state_63745;
if(cljs.core.truth_(inst_63654)){
var statearr_63752_63822 = state_63745__$1;
(statearr_63752_63822[(1)] = (26));

} else {
var statearr_63753_63823 = state_63745__$1;
(statearr_63753_63823[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (39))){
var inst_63700 = (state_63745[(9)]);
var inst_63701 = (state_63745[(10)]);
var inst_63726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63727 = [inst_63700,inst_63701];
var inst_63728 = (new cljs.core.PersistentVector(null,2,(5),inst_63726,inst_63727,null));
var state_63745__$1 = state_63745;
var statearr_63754_63824 = state_63745__$1;
(statearr_63754_63824[(2)] = inst_63728);

(statearr_63754_63824[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (4))){
var inst_63601 = (state_63745[(2)]);
var inst_63602 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63601], 0));
var inst_63603 = cljs.core.ex_data(inst_63601);
var inst_63604 = cljs.core.ex_message(inst_63601);
var inst_63605 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63603,new cljs.core.Keyword(null,"message","message",-406056002),inst_63604);
var state_63745__$1 = (function (){var statearr_63755 = state_63745;
(statearr_63755[(11)] = inst_63602);

return statearr_63755;
})();
var statearr_63756_63825 = state_63745__$1;
(statearr_63756_63825[(2)] = inst_63605);

(statearr_63756_63825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (15))){
var inst_63639 = (state_63745[(12)]);
var inst_63634 = (state_63745[(13)]);
var inst_63648 = (state_63745[(2)]);
var inst_63649 = [inst_63639,inst_63648];
var inst_63650 = (new cljs.core.PersistentVector(null,2,(5),inst_63634,inst_63649,null));
var state_63745__$1 = state_63745;
var statearr_63757_63826 = state_63745__$1;
(statearr_63757_63826[(2)] = inst_63650);

(statearr_63757_63826[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (21))){
var inst_63654 = (state_63745[(8)]);
var state_63745__$1 = state_63745;
var statearr_63758_63827 = state_63745__$1;
(statearr_63758_63827[(2)] = inst_63654);

(statearr_63758_63827[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (31))){
var inst_63695 = (state_63745[(2)]);
var state_63745__$1 = state_63745;
var statearr_63759_63828 = state_63745__$1;
(statearr_63759_63828[(2)] = inst_63695);

(statearr_63759_63828[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (32))){
var inst_63701 = (state_63745[(10)]);
var inst_63704 = cljs.core.pos_int_QMARK_(inst_63701);
var state_63745__$1 = state_63745;
var statearr_63760_63829 = state_63745__$1;
(statearr_63760_63829[(2)] = inst_63704);

(statearr_63760_63829[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (40))){
var inst_63656 = (state_63745[(14)]);
var inst_63732 = (state_63745[(15)]);
var inst_63730 = (state_63745[(2)]);
var inst_63731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63730,(0),null);
var inst_63732__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63730,(1),null);
var inst_63733 = (inst_63732__$1 > inst_63656);
var state_63745__$1 = (function (){var statearr_63761 = state_63745;
(statearr_63761[(15)] = inst_63732__$1);

(statearr_63761[(16)] = inst_63731);

return statearr_63761;
})();
if(cljs.core.truth_(inst_63733)){
var statearr_63762_63830 = state_63745__$1;
(statearr_63762_63830[(1)] = (41));

} else {
var statearr_63763_63831 = state_63745__$1;
(statearr_63763_63831[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (33))){
var inst_63702 = (state_63745[(17)]);
var state_63745__$1 = state_63745;
var statearr_63764_63832 = state_63745__$1;
(statearr_63764_63832[(2)] = inst_63702);

(statearr_63764_63832[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (13))){
var inst_63640 = (state_63745[(18)]);
var inst_63642 = fluree.db.time_travel.block_to_int_format(db,inst_63640);
var state_63745__$1 = state_63745;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63745__$1,(16),inst_63642);
} else {
if((state_val_63746 === (22))){
var inst_63673 = (state_63745[(2)]);
var state_63745__$1 = state_63745;
if(cljs.core.truth_(inst_63673)){
var statearr_63765_63833 = state_63745__$1;
(statearr_63765_63833[(1)] = (23));

} else {
var statearr_63766_63834 = state_63745__$1;
(statearr_63766_63834[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (36))){
var state_63745__$1 = state_63745;
var statearr_63767_63835 = state_63745__$1;
(statearr_63767_63835[(2)] = null);

(statearr_63767_63835[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (41))){
var inst_63656 = (state_63745[(14)]);
var state_63745__$1 = state_63745;
var statearr_63768_63836 = state_63745__$1;
(statearr_63768_63836[(2)] = inst_63656);

(statearr_63768_63836[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (43))){
var inst_63731 = (state_63745[(16)]);
var inst_63737 = (state_63745[(2)]);
var inst_63738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63739 = [inst_63731,inst_63737];
var inst_63740 = (new cljs.core.PersistentVector(null,2,(5),inst_63738,inst_63739,null));
var _ = (function (){var statearr_63769 = state_63745;
(statearr_63769[(4)] = cljs.core.rest((state_63745[(4)])));

return statearr_63769;
})();
var state_63745__$1 = state_63745;
var statearr_63770_63837 = state_63745__$1;
(statearr_63770_63837[(2)] = inst_63740);

(statearr_63770_63837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (29))){
var inst_63631 = (state_63745[(19)]);
var inst_63686 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63631], 0));
var inst_63687 = ["Invalid block range provided: ",inst_63686].join('');
var inst_63688 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63689 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63690 = cljs.core.PersistentHashMap.fromArrays(inst_63688,inst_63689);
var inst_63691 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63687,inst_63690);
var inst_63692 = (function(){throw inst_63691})();
var state_63745__$1 = state_63745;
var statearr_63771_63838 = state_63745__$1;
(statearr_63771_63838[(2)] = inst_63692);

(statearr_63771_63838[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (6))){
var inst_63623 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_63745__$1 = state_63745;
var statearr_63772_63839 = state_63745__$1;
(statearr_63772_63839[(2)] = inst_63623);

(statearr_63772_63839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (28))){
var inst_63697 = (state_63745[(2)]);
var state_63745__$1 = state_63745;
var statearr_63773_63840 = state_63745__$1;
(statearr_63773_63840[(2)] = inst_63697);

(statearr_63773_63840[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (25))){
var inst_63700 = (state_63745[(9)]);
var inst_63702 = (state_63745[(17)]);
var inst_63699 = (state_63745[(2)]);
var inst_63700__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63699,(0),null);
var inst_63701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63699,(1),null);
var inst_63702__$1 = cljs.core.pos_int_QMARK_(inst_63700__$1);
var state_63745__$1 = (function (){var statearr_63774 = state_63745;
(statearr_63774[(9)] = inst_63700__$1);

(statearr_63774[(10)] = inst_63701);

(statearr_63774[(17)] = inst_63702__$1);

return statearr_63774;
})();
if(inst_63702__$1){
var statearr_63775_63841 = state_63745__$1;
(statearr_63775_63841[(1)] = (32));

} else {
var statearr_63776_63842 = state_63745__$1;
(statearr_63776_63842[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (34))){
var inst_63707 = (state_63745[(2)]);
var inst_63708 = cljs.core.not(inst_63707);
var state_63745__$1 = state_63745;
if(inst_63708){
var statearr_63777_63843 = state_63745__$1;
(statearr_63777_63843[(1)] = (35));

} else {
var statearr_63778_63844 = state_63745__$1;
(statearr_63778_63844[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (17))){
var inst_63656 = (state_63745[(14)]);
var inst_63654 = (state_63745[(8)]);
var inst_63659 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63654], 0));
var inst_63660 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63656], 0));
var inst_63661 = ["Start block is out of range for this ledger. Start block provided: ",inst_63659,". Database block: ",inst_63660].join('');
var inst_63662 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63663 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63664 = cljs.core.PersistentHashMap.fromArrays(inst_63662,inst_63663);
var inst_63665 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63661,inst_63664);
var inst_63666 = (function(){throw inst_63665})();
var state_63745__$1 = state_63745;
var statearr_63779_63845 = state_63745__$1;
(statearr_63779_63845[(2)] = inst_63666);

(statearr_63779_63845[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (3))){
var inst_63743 = (state_63745[(2)]);
var state_63745__$1 = state_63745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63745__$1,inst_63743);
} else {
if((state_val_63746 === (12))){
var inst_63640 = (state_63745[(18)]);
var inst_63631 = (state_63745[(19)]);
var inst_63638 = (state_63745[(2)]);
var inst_63639 = fluree.db.util.async.throw_err(inst_63638);
var inst_63640__$1 = cljs.core.second(inst_63631);
var state_63745__$1 = (function (){var statearr_63780 = state_63745;
(statearr_63780[(18)] = inst_63640__$1);

(statearr_63780[(12)] = inst_63639);

return statearr_63780;
})();
if(cljs.core.truth_(inst_63640__$1)){
var statearr_63781_63846 = state_63745__$1;
(statearr_63781_63846[(1)] = (13));

} else {
var statearr_63782_63847 = state_63745__$1;
(statearr_63782_63847[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (2))){
var _ = (function (){var statearr_63783 = state_63745;
(statearr_63783[(4)] = cljs.core.cons((5),(state_63745[(4)])));

return statearr_63783;
})();
var inst_63620 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_63621 = cljs.core.sequential_QMARK_(inst_63620);
var state_63745__$1 = state_63745;
if(inst_63621){
var statearr_63784_63848 = state_63745__$1;
(statearr_63784_63848[(1)] = (6));

} else {
var statearr_63785_63849 = state_63745__$1;
(statearr_63785_63849[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (23))){
var inst_63655 = (state_63745[(7)]);
var inst_63654 = (state_63745[(8)]);
var inst_63675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63676 = [inst_63654,inst_63655];
var inst_63677 = (new cljs.core.PersistentVector(null,2,(5),inst_63675,inst_63676,null));
var state_63745__$1 = state_63745;
var statearr_63786_63850 = state_63745__$1;
(statearr_63786_63850[(2)] = inst_63677);

(statearr_63786_63850[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (35))){
var inst_63631 = (state_63745[(19)]);
var inst_63710 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63631], 0));
var inst_63711 = ["Invalid block range provided: ",inst_63710].join('');
var inst_63712 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63713 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63714 = cljs.core.PersistentHashMap.fromArrays(inst_63712,inst_63713);
var inst_63715 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63711,inst_63714);
var inst_63716 = (function(){throw inst_63715})();
var state_63745__$1 = state_63745;
var statearr_63787_63851 = state_63745__$1;
(statearr_63787_63851[(2)] = inst_63716);

(statearr_63787_63851[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (19))){
var inst_63654 = (state_63745[(8)]);
var inst_63669 = (state_63745[(2)]);
var state_63745__$1 = (function (){var statearr_63788 = state_63745;
(statearr_63788[(20)] = inst_63669);

return statearr_63788;
})();
if(cljs.core.truth_(inst_63654)){
var statearr_63789_63852 = state_63745__$1;
(statearr_63789_63852[(1)] = (20));

} else {
var statearr_63790_63853 = state_63745__$1;
(statearr_63790_63853[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (11))){
var inst_63656 = (state_63745[(14)]);
var inst_63654 = (state_63745[(8)]);
var inst_63653 = (state_63745[(2)]);
var inst_63654__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63653,(0),null);
var inst_63655 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63653,(1),null);
var inst_63656__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_63657 = (inst_63654__$1 > inst_63656__$1);
var state_63745__$1 = (function (){var statearr_63792 = state_63745;
(statearr_63792[(7)] = inst_63655);

(statearr_63792[(14)] = inst_63656__$1);

(statearr_63792[(8)] = inst_63654__$1);

return statearr_63792;
})();
if(cljs.core.truth_(inst_63657)){
var statearr_63793_63854 = state_63745__$1;
(statearr_63793_63854[(1)] = (17));

} else {
var statearr_63794_63855 = state_63745__$1;
(statearr_63794_63855[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (9))){
var inst_63631 = (state_63745[(19)]);
var inst_63634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63635 = cljs.core.first(inst_63631);
var inst_63636 = fluree.db.time_travel.block_to_int_format(db,inst_63635);
var state_63745__$1 = (function (){var statearr_63795 = state_63745;
(statearr_63795[(13)] = inst_63634);

return statearr_63795;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63745__$1,(12),inst_63636);
} else {
if((state_val_63746 === (5))){
var _ = (function (){var statearr_63796 = state_63745;
(statearr_63796[(4)] = cljs.core.rest((state_63745[(4)])));

return statearr_63796;
})();
var state_63745__$1 = state_63745;
var ex63791 = (state_63745__$1[(2)]);
var statearr_63797_63856 = state_63745__$1;
(statearr_63797_63856[(5)] = ex63791);


var statearr_63798_63857 = state_63745__$1;
(statearr_63798_63857[(1)] = (4));

(statearr_63798_63857[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (14))){
var state_63745__$1 = state_63745;
var statearr_63799_63858 = state_63745__$1;
(statearr_63799_63858[(2)] = null);

(statearr_63799_63858[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (26))){
var inst_63654 = (state_63745[(8)]);
var inst_63680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63681 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_63682 = [inst_63654,inst_63681];
var inst_63683 = (new cljs.core.PersistentVector(null,2,(5),inst_63680,inst_63682,null));
var state_63745__$1 = state_63745;
var statearr_63800_63859 = state_63745__$1;
(statearr_63800_63859[(2)] = inst_63683);

(statearr_63800_63859[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (16))){
var inst_63644 = (state_63745[(2)]);
var inst_63645 = fluree.db.util.async.throw_err(inst_63644);
var state_63745__$1 = state_63745;
var statearr_63801_63860 = state_63745__$1;
(statearr_63801_63860[(2)] = inst_63645);

(statearr_63801_63860[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (38))){
var inst_63700 = (state_63745[(9)]);
var inst_63701 = (state_63745[(10)]);
var inst_63722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63723 = [inst_63701,inst_63700];
var inst_63724 = (new cljs.core.PersistentVector(null,2,(5),inst_63722,inst_63723,null));
var state_63745__$1 = state_63745;
var statearr_63802_63861 = state_63745__$1;
(statearr_63802_63861[(2)] = inst_63724);

(statearr_63802_63861[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (30))){
var state_63745__$1 = state_63745;
var statearr_63803_63862 = state_63745__$1;
(statearr_63803_63862[(2)] = null);

(statearr_63803_63862[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (10))){
var inst_63631 = (state_63745[(19)]);
var state_63745__$1 = state_63745;
var statearr_63804_63863 = state_63745__$1;
(statearr_63804_63863[(2)] = inst_63631);

(statearr_63804_63863[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (18))){
var state_63745__$1 = state_63745;
var statearr_63805_63864 = state_63745__$1;
(statearr_63805_63864[(2)] = null);

(statearr_63805_63864[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (42))){
var inst_63732 = (state_63745[(15)]);
var state_63745__$1 = state_63745;
var statearr_63806_63865 = state_63745__$1;
(statearr_63806_63865[(2)] = inst_63732);

(statearr_63806_63865[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (37))){
var inst_63700 = (state_63745[(9)]);
var inst_63701 = (state_63745[(10)]);
var inst_63719 = (state_63745[(2)]);
var inst_63720 = (inst_63701 < inst_63700);
var state_63745__$1 = (function (){var statearr_63807 = state_63745;
(statearr_63807[(21)] = inst_63719);

return statearr_63807;
})();
if(cljs.core.truth_(inst_63720)){
var statearr_63808_63866 = state_63745__$1;
(statearr_63808_63866[(1)] = (38));

} else {
var statearr_63809_63867 = state_63745__$1;
(statearr_63809_63867[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63746 === (8))){
var inst_63631 = (state_63745[(19)]);
var inst_63631__$1 = (state_63745[(2)]);
var inst_63632 = cljs.core.some(cljs.core.string_QMARK_,inst_63631__$1);
var state_63745__$1 = (function (){var statearr_63810 = state_63745;
(statearr_63810[(19)] = inst_63631__$1);

return statearr_63810;
})();
if(cljs.core.truth_(inst_63632)){
var statearr_63811_63868 = state_63745__$1;
(statearr_63811_63868[(1)] = (9));

} else {
var statearr_63812_63869 = state_63745__$1;
(statearr_63812_63869[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____0 = (function (){
var statearr_63813 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63813[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__);

(statearr_63813[(1)] = (1));

return statearr_63813;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____1 = (function (state_63745){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63745);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63814){var ex__2736__auto__ = e63814;
var statearr_63815_63870 = state_63745;
(statearr_63815_63870[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63745[(4)]))){
var statearr_63816_63871 = state_63745;
(statearr_63816_63871[(1)] = cljs.core.first((state_63745[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63872 = state_63745;
state_63745 = G__63872;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__ = function(state_63745){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____1.call(this,state_63745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63817 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63817[(6)] = c__2755__auto__);

return statearr_63817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__63875 = arguments.length;
switch (G__63875) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63970){
var state_val_63971 = (state_63970[(1)]);
if((state_val_63971 === (7))){
var inst_63898 = (state_63970[(7)]);
var inst_63901 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_63898);
var state_63970__$1 = state_63970;
var statearr_63972_64025 = state_63970__$1;
(statearr_63972_64025[(2)] = inst_63901);

(statearr_63972_64025[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (20))){
var inst_63937 = (state_63970[(8)]);
var inst_63940 = fluree.db.api_js.format_block_resp_pretty(db,inst_63937);
var state_63970__$1 = state_63970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63970__$1,(23),inst_63940);
} else {
if((state_val_63971 === (27))){
var inst_63946 = (state_63970[(9)]);
var inst_63952 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_63946);
var state_63970__$1 = state_63970;
var statearr_63973_64026 = state_63970__$1;
(statearr_63973_64026[(2)] = inst_63952);

(statearr_63973_64026[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (1))){
var state_63970__$1 = state_63970;
var statearr_63974_64027 = state_63970__$1;
(statearr_63974_64027[(2)] = null);

(statearr_63974_64027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (24))){
var inst_63946 = (state_63970[(9)]);
var inst_63949 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_63950 = cljs.core.sequential_QMARK_(inst_63946);
var state_63970__$1 = (function (){var statearr_63975 = state_63970;
(statearr_63975[(10)] = inst_63949);

return statearr_63975;
})();
if(inst_63950){
var statearr_63976_64028 = state_63970__$1;
(statearr_63976_64028[(1)] = (27));

} else {
var statearr_63977_64029 = state_63970__$1;
(statearr_63977_64029[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (4))){
var inst_63876 = (state_63970[(2)]);
var inst_63877 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63876], 0));
var inst_63878 = cljs.core.ex_data(inst_63876);
var inst_63879 = cljs.core.ex_message(inst_63876);
var inst_63880 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63878,new cljs.core.Keyword(null,"message","message",-406056002),inst_63879);
var state_63970__$1 = (function (){var statearr_63978 = state_63970;
(statearr_63978[(11)] = inst_63877);

return statearr_63978;
})();
var statearr_63979_64030 = state_63970__$1;
(statearr_63979_64030[(2)] = inst_63880);

(statearr_63979_64030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (15))){
var inst_63898 = (state_63970[(7)]);
var inst_63911 = (state_63970[(2)]);
var inst_63912 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63911,inst_63898);
var inst_63913 = (function(){throw inst_63912})();
var state_63970__$1 = state_63970;
var statearr_63980_64031 = state_63970__$1;
(statearr_63980_64031[(2)] = inst_63913);

(statearr_63980_64031[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (21))){
var inst_63937 = (state_63970[(8)]);
var state_63970__$1 = state_63970;
var statearr_63981_64032 = state_63970__$1;
(statearr_63981_64032[(2)] = inst_63937);

(statearr_63981_64032[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (13))){
var inst_63906 = (state_63970[(12)]);
var state_63970__$1 = state_63970;
var statearr_63982_64033 = state_63970__$1;
(statearr_63982_64033[(2)] = inst_63906);

(statearr_63982_64033[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (22))){
var inst_63946 = (state_63970[(2)]);
var inst_63947 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_63970__$1 = (function (){var statearr_63983 = state_63970;
(statearr_63983[(9)] = inst_63946);

return statearr_63983;
})();
if(cljs.core.truth_(inst_63947)){
var statearr_63984_64034 = state_63970__$1;
(statearr_63984_64034[(1)] = (24));

} else {
var statearr_63985_64035 = state_63970__$1;
(statearr_63985_64035[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (29))){
var inst_63894 = (state_63970[(13)]);
var inst_63918 = (state_63970[(14)]);
var inst_63937 = (state_63970[(8)]);
var inst_63946 = (state_63970[(9)]);
var inst_63949 = (state_63970[(10)]);
var inst_63917 = (state_63970[(15)]);
var inst_63898 = (state_63970[(7)]);
var inst_63893 = (state_63970[(16)]);
var inst_63890 = (state_63970[(17)]);
var inst_63892 = (state_63970[(18)]);
var inst_63916 = (state_63970[(19)]);
var inst_63955 = (state_63970[(2)]);
var inst_63956 = (function (){var network = inst_63893;
var block_start = inst_63917;
var block_end = inst_63918;
var vec__63887 = inst_63898;
var range = inst_63898;
var db_id = inst_63894;
var _ = inst_63916;
var start = inst_63890;
var result_SINGLEQUOTE_ = inst_63946;
var result = inst_63937;
var map__63886 = inst_63892;
return (function (p1__63873_SHARP_){
var G__63986 = "%.2fms";
var G__63987 = p1__63873_SHARP_;
return goog.string.format(G__63986,G__63987);
});
})();
var inst_63957 = fluree.db.util.core.current_time_millis();
var inst_63958 = (inst_63957 - inst_63890);
var inst_63959 = (inst_63958 / (1000000));
var inst_63960 = (inst_63956.cljs$core$IFn$_invoke$arity$1 ? inst_63956.cljs$core$IFn$_invoke$arity$1(inst_63959) : inst_63956.call(null,inst_63959));
var inst_63961 = [(200),inst_63955,(100),inst_63960];
var inst_63962 = cljs.core.PersistentHashMap.fromArrays(inst_63949,inst_63961);
var state_63970__$1 = state_63970;
var statearr_63988_64036 = state_63970__$1;
(statearr_63988_64036[(2)] = inst_63962);

(statearr_63988_64036[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (6))){
var inst_63899 = (state_63970[(20)]);
var inst_63898 = (state_63970[(7)]);
var inst_63897 = (state_63970[(2)]);
var inst_63898__$1 = fluree.db.util.async.throw_err(inst_63897);
var inst_63899__$1 = cljs.core.map_QMARK_(inst_63898__$1);
var state_63970__$1 = (function (){var statearr_63989 = state_63970;
(statearr_63989[(20)] = inst_63899__$1);

(statearr_63989[(7)] = inst_63898__$1);

return statearr_63989;
})();
if(inst_63899__$1){
var statearr_63990_64037 = state_63970__$1;
(statearr_63990_64037[(1)] = (7));

} else {
var statearr_63991_64038 = state_63970__$1;
(statearr_63991_64038[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (28))){
var inst_63946 = (state_63970[(9)]);
var state_63970__$1 = state_63970;
var statearr_63992_64039 = state_63970__$1;
(statearr_63992_64039[(2)] = inst_63946);

(statearr_63992_64039[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (25))){
var inst_63946 = (state_63970[(9)]);
var state_63970__$1 = state_63970;
var statearr_63993_64040 = state_63970__$1;
(statearr_63993_64040[(2)] = inst_63946);

(statearr_63993_64040[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (17))){
var inst_63929 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_63930 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_63929].join('');
var inst_63931 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63932 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63933 = cljs.core.PersistentHashMap.fromArrays(inst_63931,inst_63932);
var inst_63934 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63930,inst_63933);
var inst_63935 = (function(){throw inst_63934})();
var state_63970__$1 = state_63970;
var statearr_63994_64041 = state_63970__$1;
(statearr_63994_64041[(2)] = inst_63935);

(statearr_63994_64041[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (3))){
var inst_63968 = (state_63970[(2)]);
var state_63970__$1 = state_63970;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63970__$1,inst_63968);
} else {
if((state_val_63971 === (12))){
var inst_63898 = (state_63970[(7)]);
var inst_63916 = (state_63970[(2)]);
var inst_63917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63898,(0),null);
var inst_63918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63898,(1),null);
var inst_63919 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_63920 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_63921 = cljs.core.keys(inst_63920);
var inst_63922 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63919,inst_63921);
var state_63970__$1 = (function (){var statearr_63995 = state_63970;
(statearr_63995[(14)] = inst_63918);

(statearr_63995[(15)] = inst_63917);

(statearr_63995[(19)] = inst_63916);

return statearr_63995;
})();
if(inst_63922){
var statearr_63996_64042 = state_63970__$1;
(statearr_63996_64042[(1)] = (16));

} else {
var statearr_63997_64043 = state_63970__$1;
(statearr_63997_64043[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (2))){
var inst_63892 = (state_63970[(18)]);
var _ = (function (){var statearr_63998 = state_63970;
(statearr_63998[(4)] = cljs.core.cons((5),(state_63970[(4)])));

return statearr_63998;
})();
var inst_63890 = fluree.db.util.core.current_time_millis();
var inst_63891 = db;
var inst_63892__$1 = cljs.core.__destructure_map(inst_63891);
var inst_63893 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63892__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_63894 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63892__$1,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_63895 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_63970__$1 = (function (){var statearr_63999 = state_63970;
(statearr_63999[(13)] = inst_63894);

(statearr_63999[(16)] = inst_63893);

(statearr_63999[(17)] = inst_63890);

(statearr_63999[(18)] = inst_63892__$1);

return statearr_63999;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63970__$1,(6),inst_63895);
} else {
if((state_val_63971 === (23))){
var inst_63942 = (state_63970[(2)]);
var inst_63943 = fluree.db.util.async.throw_err(inst_63942);
var state_63970__$1 = state_63970;
var statearr_64000_64044 = state_63970__$1;
(statearr_64000_64044[(2)] = inst_63943);

(statearr_64000_64044[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (19))){
var inst_63926 = (state_63970[(2)]);
var inst_63927 = fluree.db.util.async.throw_err(inst_63926);
var state_63970__$1 = state_63970;
var statearr_64001_64045 = state_63970__$1;
(statearr_64001_64045[(2)] = inst_63927);

(statearr_64001_64045[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (11))){
var state_63970__$1 = state_63970;
var statearr_64003_64046 = state_63970__$1;
(statearr_64003_64046[(2)] = null);

(statearr_64003_64046[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (9))){
var inst_63904 = (state_63970[(2)]);
var state_63970__$1 = state_63970;
if(cljs.core.truth_(inst_63904)){
var statearr_64004_64047 = state_63970__$1;
(statearr_64004_64047[(1)] = (10));

} else {
var statearr_64005_64048 = state_63970__$1;
(statearr_64005_64048[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (5))){
var _ = (function (){var statearr_64006 = state_63970;
(statearr_64006[(4)] = cljs.core.rest((state_63970[(4)])));

return statearr_64006;
})();
var state_63970__$1 = state_63970;
var ex64002 = (state_63970__$1[(2)]);
var statearr_64007_64049 = state_63970__$1;
(statearr_64007_64049[(5)] = ex64002);


var statearr_64008_64050 = state_63970__$1;
(statearr_64008_64050[(1)] = (4));

(statearr_64008_64050[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (14))){
var inst_63894 = (state_63970[(13)]);
var inst_63893 = (state_63970[(16)]);
var inst_63909 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63893),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63894)].join('');
var state_63970__$1 = state_63970;
var statearr_64009_64051 = state_63970__$1;
(statearr_64009_64051[(2)] = inst_63909);

(statearr_64009_64051[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (26))){
var inst_63965 = (state_63970[(2)]);
var _ = (function (){var statearr_64010 = state_63970;
(statearr_64010[(4)] = cljs.core.rest((state_63970[(4)])));

return statearr_64010;
})();
var state_63970__$1 = state_63970;
var statearr_64011_64052 = state_63970__$1;
(statearr_64011_64052[(2)] = inst_63965);

(statearr_64011_64052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (16))){
var inst_63918 = (state_63970[(14)]);
var inst_63917 = (state_63970[(15)]);
var inst_63924 = fluree.db.query.block.block_range(db,inst_63917,inst_63918,opts);
var state_63970__$1 = state_63970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63970__$1,(19),inst_63924);
} else {
if((state_val_63971 === (10))){
var inst_63906 = (state_63970[(12)]);
var inst_63898 = (state_63970[(7)]);
var inst_63906__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_63898);
var state_63970__$1 = (function (){var statearr_64012 = state_63970;
(statearr_64012[(12)] = inst_63906__$1);

return statearr_64012;
})();
if(cljs.core.truth_(inst_63906__$1)){
var statearr_64013_64053 = state_63970__$1;
(statearr_64013_64053[(1)] = (13));

} else {
var statearr_64014_64054 = state_63970__$1;
(statearr_64014_64054[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (18))){
var inst_63937 = (state_63970[(2)]);
var inst_63938 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_63970__$1 = (function (){var statearr_64015 = state_63970;
(statearr_64015[(8)] = inst_63937);

return statearr_64015;
})();
if(cljs.core.truth_(inst_63938)){
var statearr_64016_64055 = state_63970__$1;
(statearr_64016_64055[(1)] = (20));

} else {
var statearr_64017_64056 = state_63970__$1;
(statearr_64017_64056[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63971 === (8))){
var inst_63899 = (state_63970[(20)]);
var state_63970__$1 = state_63970;
var statearr_64018_64057 = state_63970__$1;
(statearr_64018_64057[(2)] = inst_63899);

(statearr_64018_64057[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_64019 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64019[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_64019[(1)] = (1));

return statearr_64019;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_63970){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63970);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64020){var ex__2736__auto__ = e64020;
var statearr_64021_64058 = state_63970;
(statearr_64021_64058[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63970[(4)]))){
var statearr_64022_64059 = state_63970;
(statearr_64022_64059[(1)] = cljs.core.first((state_63970[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64060 = state_63970;
state_63970 = G__64060;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_63970){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_63970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64023 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64023[(6)] = c__2755__auto__);

return statearr_64023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__64062 = arguments.length;
switch (G__64062) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64257){
var state_val_64258 = (state_64257[(1)]);
if((state_val_64258 === (62))){
var inst_64255 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64257__$1,inst_64255);
} else {
if((state_val_64258 === (7))){
var inst_64083 = (state_64257[(7)]);
var inst_64093 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_64083);
var state_64257__$1 = state_64257;
var statearr_64259_64350 = state_64257__$1;
(statearr_64259_64350[(2)] = inst_64093);

(statearr_64259_64350[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (59))){
var inst_64243 = (state_64257[(2)]);
var inst_64244 = fluree.db.util.async.throw_err(inst_64243);
var state_64257__$1 = state_64257;
var statearr_64260_64351 = state_64257__$1;
(statearr_64260_64351[(2)] = inst_64244);

(statearr_64260_64351[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (20))){
var inst_64159 = (state_64257[(8)]);
var inst_64151 = (state_64257[(9)]);
var inst_64151__$1 = (state_64257[(2)]);
var inst_64152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64151__$1,(0));
var inst_64154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64151__$1,(1));
var inst_64155 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64151__$1,(2));
var inst_64156 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64151__$1,(3));
var inst_64157 = [inst_64153,inst_64154,inst_64155,inst_64156];
var inst_64158 = (new cljs.core.PersistentVector(null,4,(5),inst_64152,inst_64157,null));
var inst_64159__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64158,(0),null);
var inst_64160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64158,(1),null);
var inst_64161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64158,(2),null);
var inst_64162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64158,(3),null);
var inst_64163 = (inst_64159__$1 == null);
var inst_64164 = cljs.core.not(inst_64163);
var state_64257__$1 = (function (){var statearr_64261 = state_64257;
(statearr_64261[(10)] = inst_64160);

(statearr_64261[(11)] = inst_64161);

(statearr_64261[(8)] = inst_64159__$1);

(statearr_64261[(9)] = inst_64151__$1);

(statearr_64261[(12)] = inst_64162);

return statearr_64261;
})();
if(inst_64164){
var statearr_64262_64352 = state_64257__$1;
(statearr_64262_64352[(1)] = (30));

} else {
var statearr_64263_64353 = state_64257__$1;
(statearr_64263_64353[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (58))){
var inst_64091 = (state_64257[(13)]);
var inst_64247 = (state_64257[(2)]);
var state_64257__$1 = (function (){var statearr_64264 = state_64257;
(statearr_64264[(14)] = inst_64247);

return statearr_64264;
})();
if(cljs.core.truth_(inst_64091)){
var statearr_64265_64354 = state_64257__$1;
(statearr_64265_64354[(1)] = (60));

} else {
var statearr_64266_64355 = state_64257__$1;
(statearr_64266_64355[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (60))){
var inst_64247 = (state_64257[(14)]);
var inst_64235 = (state_64257[(15)]);
var inst_64249 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_64250 = cljs.core.count(inst_64235);
var inst_64251 = [inst_64247,inst_64250,(200)];
var inst_64252 = cljs.core.PersistentHashMap.fromArrays(inst_64249,inst_64251);
var state_64257__$1 = state_64257;
var statearr_64267_64356 = state_64257__$1;
(statearr_64267_64356[(2)] = inst_64252);

(statearr_64267_64356[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (27))){
var inst_64070 = (state_64257[(16)]);
var inst_64139 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64070)].join('');
var inst_64140 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64141 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64142 = cljs.core.PersistentHashMap.fromArrays(inst_64140,inst_64141);
var inst_64143 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64139,inst_64142);
var inst_64144 = (function(){throw inst_64143})();
var state_64257__$1 = state_64257;
var statearr_64268_64357 = state_64257__$1;
(statearr_64268_64357[(2)] = inst_64144);

(statearr_64268_64357[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (1))){
var inst_64067 = query_map;
var inst_64068 = cljs.core.__destructure_map(inst_64067);
var inst_64069 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64068,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64070 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64068,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_64071 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64068,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_64257__$1 = (function (){var statearr_64269 = state_64257;
(statearr_64269[(17)] = inst_64069);

(statearr_64269[(18)] = inst_64071);

(statearr_64269[(16)] = inst_64070);

return statearr_64269;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64257__$1,(2),sources);
} else {
if((state_val_64258 === (24))){
var inst_64070 = (state_64257[(16)]);
var inst_64128 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64070)].join('');
var inst_64129 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64130 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64131 = cljs.core.PersistentHashMap.fromArrays(inst_64129,inst_64130);
var inst_64132 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64128,inst_64131);
var inst_64133 = (function(){throw inst_64132})();
var state_64257__$1 = state_64257;
var statearr_64270_64358 = state_64257__$1;
(statearr_64270_64358[(2)] = inst_64133);

(statearr_64270_64358[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (55))){
var inst_64071 = (state_64257[(18)]);
var inst_64238 = (state_64257[(2)]);
var inst_64239 = fluree.db.util.async.throw_err(inst_64238);
var state_64257__$1 = (function (){var statearr_64271 = state_64257;
(statearr_64271[(19)] = inst_64239);

return statearr_64271;
})();
if(cljs.core.truth_(inst_64071)){
var statearr_64272_64359 = state_64257__$1;
(statearr_64272_64359[(1)] = (56));

} else {
var statearr_64273_64360 = state_64257__$1;
(statearr_64273_64360[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (39))){
var inst_64160 = (state_64257[(10)]);
var inst_64161 = (state_64257[(11)]);
var inst_64159 = (state_64257[(8)]);
var inst_64162 = (state_64257[(12)]);
var inst_64183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64185 = [inst_64160,inst_64159,inst_64161,inst_64162];
var inst_64186 = (new cljs.core.PersistentVector(null,4,(5),inst_64184,inst_64185,null));
var inst_64187 = [inst_64186,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_64188 = (new cljs.core.PersistentVector(null,2,(5),inst_64183,inst_64187,null));
var state_64257__$1 = state_64257;
var statearr_64274_64361 = state_64257__$1;
(statearr_64274_64361[(2)] = inst_64188);

(statearr_64274_64361[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (46))){
var inst_64193 = (state_64257[(20)]);
var state_64257__$1 = state_64257;
var statearr_64275_64362 = state_64257__$1;
(statearr_64275_64362[(2)] = inst_64193);

(statearr_64275_64362[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (4))){
var state_64257__$1 = state_64257;
var statearr_64276_64363 = state_64257__$1;
(statearr_64276_64363[(2)] = null);

(statearr_64276_64363[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (54))){
var inst_64074 = (state_64257[(21)]);
var inst_64235 = (state_64257[(15)]);
var inst_64234 = (state_64257[(2)]);
var inst_64235__$1 = fluree.db.util.async.throw_err(inst_64234);
var inst_64236 = fluree.db.api_js.format_history_resp(inst_64074,inst_64235__$1);
var state_64257__$1 = (function (){var statearr_64277 = state_64257;
(statearr_64277[(15)] = inst_64235__$1);

return statearr_64277;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64257__$1,(55),inst_64236);
} else {
if((state_val_64258 === (15))){
var inst_64074 = (state_64257[(21)]);
var inst_64115 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64074);
var state_64257__$1 = state_64257;
var statearr_64278_64364 = state_64257__$1;
(statearr_64278_64364[(2)] = inst_64115);

(statearr_64278_64364[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (48))){
var inst_64160 = (state_64257[(10)]);
var inst_64161 = (state_64257[(11)]);
var inst_64159 = (state_64257[(8)]);
var inst_64162 = (state_64257[(12)]);
var inst_64204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64206 = [inst_64160,inst_64161,inst_64159,inst_64162];
var inst_64207 = (new cljs.core.PersistentVector(null,4,(5),inst_64205,inst_64206,null));
var inst_64208 = [inst_64207,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_64209 = (new cljs.core.PersistentVector(null,2,(5),inst_64204,inst_64208,null));
var state_64257__$1 = state_64257;
var statearr_64279_64365 = state_64257__$1;
(statearr_64279_64365[(2)] = inst_64209);

(statearr_64279_64365[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (50))){
var inst_64222 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
var statearr_64280_64366 = state_64257__$1;
(statearr_64280_64366[(2)] = inst_64222);

(statearr_64280_64366[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (21))){
var inst_64070 = (state_64257[(16)]);
var inst_64126 = cljs.core.empty_QMARK_(inst_64070);
var state_64257__$1 = state_64257;
if(inst_64126){
var statearr_64281_64367 = state_64257__$1;
(statearr_64281_64367[(1)] = (24));

} else {
var statearr_64282_64368 = state_64257__$1;
(statearr_64282_64368[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (31))){
var inst_64170 = (state_64257[(22)]);
var inst_64159 = (state_64257[(8)]);
var inst_64170__$1 = (inst_64159 == null);
var state_64257__$1 = (function (){var statearr_64283 = state_64257;
(statearr_64283[(22)] = inst_64170__$1);

return statearr_64283;
})();
if(cljs.core.truth_(inst_64170__$1)){
var statearr_64284_64369 = state_64257__$1;
(statearr_64284_64369[(1)] = (33));

} else {
var statearr_64285_64370 = state_64257__$1;
(statearr_64285_64370[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (32))){
var inst_64074 = (state_64257[(21)]);
var inst_64117 = (state_64257[(23)]);
var inst_64107 = (state_64257[(24)]);
var inst_64226 = (state_64257[(2)]);
var inst_64227 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64226,(0),null);
var inst_64228 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64226,(1),null);
var inst_64229 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_64230 = [inst_64107,inst_64117];
var inst_64231 = cljs.core.PersistentHashMap.fromArrays(inst_64229,inst_64230);
var inst_64232 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_64074,inst_64228,cljs.core._EQ_,inst_64227,inst_64231);
var state_64257__$1 = state_64257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64257__$1,(54),inst_64232);
} else {
if((state_val_64258 === (40))){
var inst_64190 = (state_64257[(25)]);
var inst_64159 = (state_64257[(8)]);
var inst_64190__$1 = (inst_64159 == null);
var state_64257__$1 = (function (){var statearr_64286 = state_64257;
(statearr_64286[(25)] = inst_64190__$1);

return statearr_64286;
})();
if(cljs.core.truth_(inst_64190__$1)){
var statearr_64287_64371 = state_64257__$1;
(statearr_64287_64371[(1)] = (42));

} else {
var statearr_64288_64372 = state_64257__$1;
(statearr_64288_64372[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (56))){
var inst_64074 = (state_64257[(21)]);
var inst_64239 = (state_64257[(19)]);
var inst_64241 = fluree.db.api_js.format_block_resp_pretty(inst_64074,inst_64239);
var state_64257__$1 = state_64257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64257__$1,(59),inst_64241);
} else {
if((state_val_64258 === (33))){
var inst_64160 = (state_64257[(10)]);
var inst_64173 = (state_64257[(26)]);
var inst_64172 = (inst_64160 == null);
var inst_64173__$1 = cljs.core.not(inst_64172);
var state_64257__$1 = (function (){var statearr_64289 = state_64257;
(statearr_64289[(26)] = inst_64173__$1);

return statearr_64289;
})();
if(inst_64173__$1){
var statearr_64290_64373 = state_64257__$1;
(statearr_64290_64373[(1)] = (36));

} else {
var statearr_64291_64374 = state_64257__$1;
(statearr_64291_64374[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (13))){
var inst_64101 = (state_64257[(2)]);
var inst_64102 = fluree.db.util.async.throw_err(inst_64101);
var inst_64103 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64102);
var inst_64104 = (inst_64103 - (1));
var state_64257__$1 = state_64257;
var statearr_64292_64375 = state_64257__$1;
(statearr_64292_64375[(2)] = inst_64104);

(statearr_64292_64375[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (22))){
var state_64257__$1 = state_64257;
var statearr_64293_64376 = state_64257__$1;
(statearr_64293_64376[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (36))){
var inst_64161 = (state_64257[(11)]);
var inst_64175 = (inst_64161 == null);
var state_64257__$1 = state_64257;
var statearr_64295_64377 = state_64257__$1;
(statearr_64295_64377[(2)] = inst_64175);

(statearr_64295_64377[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (41))){
var inst_64224 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
var statearr_64296_64378 = state_64257__$1;
(statearr_64296_64378[(2)] = inst_64224);

(statearr_64296_64378[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (43))){
var inst_64190 = (state_64257[(25)]);
var state_64257__$1 = state_64257;
var statearr_64297_64379 = state_64257__$1;
(statearr_64297_64379[(2)] = inst_64190);

(statearr_64297_64379[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (61))){
var inst_64247 = (state_64257[(14)]);
var state_64257__$1 = state_64257;
var statearr_64298_64380 = state_64257__$1;
(statearr_64298_64380[(2)] = inst_64247);

(statearr_64298_64380[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (29))){
var inst_64147 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
var statearr_64299_64381 = state_64257__$1;
(statearr_64299_64381[(2)] = inst_64147);

(statearr_64299_64381[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (44))){
var inst_64202 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
if(cljs.core.truth_(inst_64202)){
var statearr_64300_64382 = state_64257__$1;
(statearr_64300_64382[(1)] = (48));

} else {
var statearr_64301_64383 = state_64257__$1;
(statearr_64301_64383[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (6))){
var inst_64078 = (state_64257[(2)]);
var inst_64079 = fluree.db.util.async.throw_err(inst_64078);
var state_64257__$1 = state_64257;
var statearr_64302_64384 = state_64257__$1;
(statearr_64302_64384[(2)] = inst_64079);

(statearr_64302_64384[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (28))){
var state_64257__$1 = state_64257;
var statearr_64303_64385 = state_64257__$1;
(statearr_64303_64385[(2)] = null);

(statearr_64303_64385[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (51))){
var inst_64070 = (state_64257[(16)]);
var inst_64212 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64070)].join('');
var inst_64213 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64214 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64215 = cljs.core.PersistentHashMap.fromArrays(inst_64213,inst_64214);
var inst_64216 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64212,inst_64215);
var inst_64217 = (function(){throw inst_64216})();
var state_64257__$1 = state_64257;
var statearr_64304_64386 = state_64257__$1;
(statearr_64304_64386[(2)] = inst_64217);

(statearr_64304_64386[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (25))){
var inst_64070 = (state_64257[(16)]);
var state_64257__$1 = state_64257;
var statearr_64305_64387 = state_64257__$1;
(statearr_64305_64387[(2)] = inst_64070);

(statearr_64305_64387[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (34))){
var inst_64170 = (state_64257[(22)]);
var state_64257__$1 = state_64257;
var statearr_64306_64388 = state_64257__$1;
(statearr_64306_64388[(2)] = inst_64170);

(statearr_64306_64388[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (17))){
var inst_64111 = (state_64257[(2)]);
var inst_64112 = fluree.db.util.async.throw_err(inst_64111);
var inst_64113 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64112);
var state_64257__$1 = state_64257;
var statearr_64307_64389 = state_64257__$1;
(statearr_64307_64389[(2)] = inst_64113);

(statearr_64307_64389[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (3))){
var inst_64074 = (state_64257[(21)]);
var inst_64076 = fluree.db.api_js.resolve_block_range(inst_64074,query_map);
var state_64257__$1 = state_64257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64257__$1,(6),inst_64076);
} else {
if((state_val_64258 === (12))){
var inst_64084 = (state_64257[(27)]);
var inst_64107 = (state_64257[(2)]);
var state_64257__$1 = (function (){var statearr_64308 = state_64257;
(statearr_64308[(24)] = inst_64107);

return statearr_64308;
})();
if(cljs.core.truth_(inst_64084)){
var statearr_64309_64390 = state_64257__$1;
(statearr_64309_64390[(1)] = (14));

} else {
var statearr_64310_64391 = state_64257__$1;
(statearr_64310_64391[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (2))){
var inst_64069 = (state_64257[(17)]);
var inst_64073 = (state_64257[(2)]);
var inst_64074 = fluree.db.util.async.throw_err(inst_64073);
var state_64257__$1 = (function (){var statearr_64311 = state_64257;
(statearr_64311[(21)] = inst_64074);

return statearr_64311;
})();
if(cljs.core.truth_(inst_64069)){
var statearr_64312_64392 = state_64257__$1;
(statearr_64312_64392[(1)] = (3));

} else {
var statearr_64313_64393 = state_64257__$1;
(statearr_64313_64393[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (23))){
var inst_64149 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
var statearr_64314_64394 = state_64257__$1;
(statearr_64314_64394[(2)] = inst_64149);

(statearr_64314_64394[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (47))){
var inst_64199 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
var statearr_64315_64395 = state_64257__$1;
(statearr_64315_64395[(2)] = inst_64199);

(statearr_64315_64395[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (35))){
var inst_64181 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
if(cljs.core.truth_(inst_64181)){
var statearr_64316_64396 = state_64257__$1;
(statearr_64316_64396[(1)] = (39));

} else {
var statearr_64317_64397 = state_64257__$1;
(statearr_64317_64397[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (19))){
var inst_64070 = (state_64257[(16)]);
var inst_64124 = cljs.core.sequential_QMARK_(inst_64070);
var state_64257__$1 = state_64257;
if(inst_64124){
var statearr_64318_64398 = state_64257__$1;
(statearr_64318_64398[(1)] = (21));

} else {
var statearr_64319_64399 = state_64257__$1;
(statearr_64319_64399[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (57))){
var inst_64239 = (state_64257[(19)]);
var state_64257__$1 = state_64257;
var statearr_64320_64400 = state_64257__$1;
(statearr_64320_64400[(2)] = inst_64239);

(statearr_64320_64400[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (11))){
var state_64257__$1 = state_64257;
var statearr_64321_64401 = state_64257__$1;
(statearr_64321_64401[(2)] = (-1));

(statearr_64321_64401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (9))){
var inst_64096 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
if(cljs.core.truth_(inst_64096)){
var statearr_64322_64402 = state_64257__$1;
(statearr_64322_64402[(1)] = (10));

} else {
var statearr_64323_64403 = state_64257__$1;
(statearr_64323_64403[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (5))){
var inst_64083 = (state_64257[(7)]);
var inst_64082 = (state_64257[(2)]);
var inst_64083__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64082,(0),null);
var inst_64084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64082,(1),null);
var inst_64091 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64257__$1 = (function (){var statearr_64324 = state_64257;
(statearr_64324[(27)] = inst_64084);

(statearr_64324[(7)] = inst_64083__$1);

(statearr_64324[(13)] = inst_64091);

return statearr_64324;
})();
if(cljs.core.truth_(inst_64083__$1)){
var statearr_64325_64404 = state_64257__$1;
(statearr_64325_64404[(1)] = (7));

} else {
var statearr_64326_64405 = state_64257__$1;
(statearr_64326_64405[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (14))){
var inst_64074 = (state_64257[(21)]);
var inst_64084 = (state_64257[(27)]);
var inst_64109 = fluree.db.time_travel.as_of_block(inst_64074,inst_64084);
var state_64257__$1 = state_64257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64257__$1,(17),inst_64109);
} else {
if((state_val_64258 === (45))){
var inst_64161 = (state_64257[(11)]);
var inst_64195 = (inst_64161 == null);
var inst_64196 = cljs.core.not(inst_64195);
var state_64257__$1 = state_64257;
var statearr_64327_64406 = state_64257__$1;
(statearr_64327_64406[(2)] = inst_64196);

(statearr_64327_64406[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (53))){
var inst_64220 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
var statearr_64328_64407 = state_64257__$1;
(statearr_64328_64407[(2)] = inst_64220);

(statearr_64328_64407[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (26))){
var inst_64136 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
var statearr_64329_64408 = state_64257__$1;
(statearr_64329_64408[(2)] = inst_64136);

(statearr_64329_64408[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (16))){
var inst_64070 = (state_64257[(16)]);
var inst_64117 = (state_64257[(2)]);
var inst_64118 = fluree.db.util.core.subj_ident_QMARK_(inst_64070);
var state_64257__$1 = (function (){var statearr_64330 = state_64257;
(statearr_64330[(23)] = inst_64117);

return statearr_64330;
})();
if(inst_64118){
var statearr_64331_64409 = state_64257__$1;
(statearr_64331_64409[(1)] = (18));

} else {
var statearr_64332_64410 = state_64257__$1;
(statearr_64332_64410[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (38))){
var inst_64178 = (state_64257[(2)]);
var state_64257__$1 = state_64257;
var statearr_64333_64411 = state_64257__$1;
(statearr_64333_64411[(2)] = inst_64178);

(statearr_64333_64411[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (30))){
var inst_64151 = (state_64257[(9)]);
var inst_64166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64167 = [inst_64151,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_64168 = (new cljs.core.PersistentVector(null,2,(5),inst_64166,inst_64167,null));
var state_64257__$1 = state_64257;
var statearr_64334_64412 = state_64257__$1;
(statearr_64334_64412[(2)] = inst_64168);

(statearr_64334_64412[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (10))){
var inst_64074 = (state_64257[(21)]);
var inst_64083 = (state_64257[(7)]);
var inst_64098 = (inst_64083 - (1));
var inst_64099 = fluree.db.time_travel.as_of_block(inst_64074,inst_64098);
var state_64257__$1 = state_64257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64257__$1,(13),inst_64099);
} else {
if((state_val_64258 === (18))){
var inst_64070 = (state_64257[(16)]);
var inst_64120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64121 = [inst_64070];
var inst_64122 = (new cljs.core.PersistentVector(null,1,(5),inst_64120,inst_64121,null));
var state_64257__$1 = state_64257;
var statearr_64335_64413 = state_64257__$1;
(statearr_64335_64413[(2)] = inst_64122);

(statearr_64335_64413[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (52))){
var state_64257__$1 = state_64257;
var statearr_64336_64414 = state_64257__$1;
(statearr_64336_64414[(2)] = null);

(statearr_64336_64414[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (42))){
var inst_64160 = (state_64257[(10)]);
var inst_64193 = (state_64257[(20)]);
var inst_64192 = (inst_64160 == null);
var inst_64193__$1 = cljs.core.not(inst_64192);
var state_64257__$1 = (function (){var statearr_64337 = state_64257;
(statearr_64337[(20)] = inst_64193__$1);

return statearr_64337;
})();
if(inst_64193__$1){
var statearr_64338_64415 = state_64257__$1;
(statearr_64338_64415[(1)] = (45));

} else {
var statearr_64339_64416 = state_64257__$1;
(statearr_64339_64416[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (37))){
var inst_64173 = (state_64257[(26)]);
var state_64257__$1 = state_64257;
var statearr_64340_64417 = state_64257__$1;
(statearr_64340_64417[(2)] = inst_64173);

(statearr_64340_64417[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (8))){
var inst_64083 = (state_64257[(7)]);
var state_64257__$1 = state_64257;
var statearr_64341_64418 = state_64257__$1;
(statearr_64341_64418[(2)] = inst_64083);

(statearr_64341_64418[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64258 === (49))){
var state_64257__$1 = state_64257;
var statearr_64342_64419 = state_64257__$1;
(statearr_64342_64419[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_64344 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64344[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_64344[(1)] = (1));

return statearr_64344;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_64257){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64257);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64345){var ex__2736__auto__ = e64345;
var statearr_64346_64420 = state_64257;
(statearr_64346_64420[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64257[(4)]))){
var statearr_64347_64421 = state_64257;
(statearr_64347_64421[(1)] = cljs.core.first((state_64257[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64422 = state_64257;
state_64257 = G__64422;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_64257){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_64257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64348 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64348[(6)] = c__2755__auto__);

return statearr_64348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__64430 = arguments.length;
switch (G__64430) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = block;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4221__auto__ = block;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__64423_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__64423_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64519){
var state_val_64520 = (state_64519[(1)]);
if((state_val_64520 === (7))){
var inst_64470 = (state_64519[(7)]);
var inst_64473 = (state_64519[(8)]);
var inst_64480 = (state_64519[(9)]);
var inst_64476 = (state_64519[(10)]);
var inst_64486 = (function (){var responses = inst_64470;
var responses_STAR_ = inst_64473;
var statuses = inst_64476;
var fuel = inst_64480;
return (function (p1__64426_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__64426_SHARP_);
});
})();
var inst_64487 = cljs.core.some(inst_64486,inst_64476);
var state_64519__$1 = state_64519;
if(cljs.core.truth_(inst_64487)){
var statearr_64521_64569 = state_64519__$1;
(statearr_64521_64569[(1)] = (9));

} else {
var statearr_64522_64570 = state_64519__$1;
(statearr_64522_64570[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (20))){
var inst_64514 = (state_64519[(2)]);
var state_64519__$1 = state_64519;
var statearr_64523_64571 = state_64519__$1;
(statearr_64523_64571[(2)] = inst_64514);

(statearr_64523_64571[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (1))){
var inst_64465 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_64466 = (function (){var c__2755__auto____$1 = inst_64465;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64463){
var state_val_64464 = (state_64463[(1)]);
if((state_val_64464 === (1))){
var inst_64431 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_64432 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_64433 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64432,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_64434 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_64435 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_64436 = cljs.core.PersistentHashMap.EMPTY;
var inst_64437 = inst_64431;
var inst_64438 = inst_64433;
var inst_64439 = inst_64434;
var inst_64440 = inst_64435;
var inst_64441 = inst_64436;
var state_64463__$1 = (function (){var statearr_64524 = state_64463;
(statearr_64524[(7)] = inst_64440);

(statearr_64524[(8)] = inst_64441);

(statearr_64524[(9)] = inst_64439);

(statearr_64524[(10)] = inst_64438);

(statearr_64524[(11)] = inst_64437);

return statearr_64524;
})();
var statearr_64525_64572 = state_64463__$1;
(statearr_64525_64572[(2)] = null);

(statearr_64525_64572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64464 === (2))){
var inst_64438 = (state_64463[(10)]);
var inst_64443 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_64438);
var inst_64444 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_64443], 0));
var inst_64445 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64438,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64444);
var inst_64446 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_64445,db_fn);
var state_64463__$1 = state_64463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64463__$1,(4),inst_64446);
} else {
if((state_val_64464 === (3))){
var inst_64461 = (state_64463[(2)]);
var state_64463__$1 = state_64463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64463__$1,inst_64461);
} else {
if((state_val_64464 === (4))){
var inst_64441 = (state_64463[(8)]);
var inst_64439 = (state_64463[(9)]);
var inst_64437 = (state_64463[(11)]);
var inst_64448 = (state_64463[(2)]);
var inst_64449 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64441,inst_64437,inst_64448);
var inst_64450 = cljs.core.first(inst_64439);
var state_64463__$1 = (function (){var statearr_64526 = state_64463;
(statearr_64526[(12)] = inst_64449);

return statearr_64526;
})();
if(cljs.core.truth_(inst_64450)){
var statearr_64527_64573 = state_64463__$1;
(statearr_64527_64573[(1)] = (5));

} else {
var statearr_64528_64574 = state_64463__$1;
(statearr_64528_64574[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64464 === (5))){
var inst_64440 = (state_64463[(7)]);
var inst_64439 = (state_64463[(9)]);
var inst_64449 = (state_64463[(12)]);
var inst_64452 = cljs.core.first(inst_64439);
var inst_64453 = cljs.core.first(inst_64440);
var inst_64454 = cljs.core.rest(inst_64439);
var inst_64455 = cljs.core.rest(inst_64440);
var inst_64437 = inst_64452;
var inst_64438 = inst_64453;
var inst_64439__$1 = inst_64454;
var inst_64440__$1 = inst_64455;
var inst_64441 = inst_64449;
var state_64463__$1 = (function (){var statearr_64529 = state_64463;
(statearr_64529[(7)] = inst_64440__$1);

(statearr_64529[(8)] = inst_64441);

(statearr_64529[(9)] = inst_64439__$1);

(statearr_64529[(10)] = inst_64438);

(statearr_64529[(11)] = inst_64437);

return statearr_64529;
})();
var statearr_64530_64575 = state_64463__$1;
(statearr_64530_64575[(2)] = null);

(statearr_64530_64575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64464 === (6))){
var inst_64449 = (state_64463[(12)]);
var state_64463__$1 = state_64463;
var statearr_64531_64576 = state_64463__$1;
(statearr_64531_64576[(2)] = inst_64449);

(statearr_64531_64576[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64464 === (7))){
var inst_64459 = (state_64463[(2)]);
var state_64463__$1 = state_64463;
var statearr_64532_64577 = state_64463__$1;
(statearr_64532_64577[(2)] = inst_64459);

(statearr_64532_64577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_64533 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64533[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_64533[(1)] = (1));

return statearr_64533;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_64463){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64463);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64534){var ex__2736__auto__ = e64534;
var statearr_64535_64578 = state_64463;
(statearr_64535_64578[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64463[(4)]))){
var statearr_64536_64579 = state_64463;
(statearr_64536_64579[(1)] = cljs.core.first((state_64463[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64580 = state_64463;
state_64463 = G__64580;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_64463){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_64463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64537 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64537[(6)] = c__2755__auto____$1);

return statearr_64537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_64467 = cljs.core.async.impl.dispatch.run(inst_64466);
var state_64519__$1 = (function (){var statearr_64538 = state_64519;
(statearr_64538[(11)] = inst_64467);

return statearr_64538;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64519__$1,(2),inst_64465);
} else {
if((state_val_64520 === (4))){
var inst_64470 = (state_64519[(7)]);
var state_64519__$1 = state_64519;
var statearr_64539_64581 = state_64519__$1;
(statearr_64539_64581[(2)] = inst_64470);

(statearr_64539_64581[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (15))){
var state_64519__$1 = state_64519;
var statearr_64540_64582 = state_64519__$1;
(statearr_64540_64582[(2)] = (400));

(statearr_64540_64582[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (13))){
var state_64519__$1 = state_64519;
var statearr_64541_64583 = state_64519__$1;
(statearr_64541_64583[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (6))){
var inst_64476 = (state_64519[(10)]);
var inst_64484 = cljs.core.first(inst_64476);
var state_64519__$1 = state_64519;
var statearr_64543_64584 = state_64519__$1;
(statearr_64543_64584[(2)] = inst_64484);

(statearr_64543_64584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (17))){
var inst_64497 = (state_64519[(2)]);
var state_64519__$1 = state_64519;
var statearr_64544_64585 = state_64519__$1;
(statearr_64544_64585[(2)] = inst_64497);

(statearr_64544_64585[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (3))){
var inst_64470 = (state_64519[(7)]);
var inst_64473 = (state_64519[(8)]);
var inst_64480 = (state_64519[(9)]);
var inst_64476 = (state_64519[(10)]);
var inst_64475 = cljs.core.vals(inst_64470);
var inst_64476__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_64475);
var inst_64477 = (function (){var responses = inst_64470;
var responses_STAR_ = inst_64473;
var statuses = inst_64476__$1;
return (function (p1__64424_SHARP_){
var or__4223__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__64424_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
});
})();
var inst_64478 = cljs.core.vals(inst_64470);
var inst_64479 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_64477,inst_64478);
var inst_64480__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_64479);
var inst_64481 = (function (){var responses = inst_64470;
var responses_STAR_ = inst_64473;
var statuses = inst_64476__$1;
var fuel = inst_64480__$1;
return (function (p1__64425_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__64425_SHARP_);
});
})();
var inst_64482 = cljs.core.every_QMARK_(inst_64481,inst_64476__$1);
var state_64519__$1 = (function (){var statearr_64545 = state_64519;
(statearr_64545[(9)] = inst_64480__$1);

(statearr_64545[(10)] = inst_64476__$1);

return statearr_64545;
})();
if(inst_64482){
var statearr_64546_64586 = state_64519__$1;
(statearr_64546_64586[(1)] = (6));

} else {
var statearr_64547_64587 = state_64519__$1;
(statearr_64547_64587[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (12))){
var state_64519__$1 = state_64519;
var statearr_64548_64588 = state_64519__$1;
(statearr_64548_64588[(2)] = (500));

(statearr_64548_64588[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (2))){
var inst_64470 = (state_64519[(7)]);
var inst_64469 = (state_64519[(2)]);
var inst_64470__$1 = fluree.db.util.async.throw_err(inst_64469);
var inst_64471 = (function (){var responses = inst_64470__$1;
return (function (acc,index,response){
var resp = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_64472 = cljs.core.PersistentHashMap.EMPTY;
var inst_64473 = cljs.core.reduce_kv(inst_64471,inst_64472,inst_64470__$1);
var state_64519__$1 = (function (){var statearr_64549 = state_64519;
(statearr_64549[(7)] = inst_64470__$1);

(statearr_64549[(8)] = inst_64473);

return statearr_64549;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_64550_64589 = state_64519__$1;
(statearr_64550_64589[(1)] = (3));

} else {
var statearr_64551_64590 = state_64519__$1;
(statearr_64551_64590[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (19))){
var inst_64473 = (state_64519[(8)]);
var inst_64480 = (state_64519[(9)]);
var inst_64503 = (state_64519[(12)]);
var inst_64512 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64473,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64503,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64480], 0));
var state_64519__$1 = state_64519;
var statearr_64552_64591 = state_64519__$1;
(statearr_64552_64591[(2)] = inst_64512);

(statearr_64552_64591[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (11))){
var inst_64501 = (state_64519[(2)]);
var state_64519__$1 = state_64519;
var statearr_64553_64592 = state_64519__$1;
(statearr_64553_64592[(2)] = inst_64501);

(statearr_64553_64592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (9))){
var state_64519__$1 = state_64519;
var statearr_64554_64593 = state_64519__$1;
(statearr_64554_64593[(2)] = (207));

(statearr_64554_64593[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (5))){
var inst_64517 = (state_64519[(2)]);
var state_64519__$1 = state_64519;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64519__$1,inst_64517);
} else {
if((state_val_64520 === (14))){
var inst_64499 = (state_64519[(2)]);
var state_64519__$1 = state_64519;
var statearr_64555_64594 = state_64519__$1;
(statearr_64555_64594[(2)] = inst_64499);

(statearr_64555_64594[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (16))){
var state_64519__$1 = state_64519;
var statearr_64556_64595 = state_64519__$1;
(statearr_64556_64595[(2)] = null);

(statearr_64556_64595[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (10))){
var inst_64470 = (state_64519[(7)]);
var inst_64473 = (state_64519[(8)]);
var inst_64480 = (state_64519[(9)]);
var inst_64476 = (state_64519[(10)]);
var inst_64490 = (function (){var responses = inst_64470;
var responses_STAR_ = inst_64473;
var statuses = inst_64476;
var fuel = inst_64480;
return (function (p1__64427_SHARP_){
return ((499) < p1__64427_SHARP_);
});
})();
var inst_64491 = cljs.core.some(inst_64490,inst_64476);
var state_64519__$1 = state_64519;
if(cljs.core.truth_(inst_64491)){
var statearr_64557_64596 = state_64519__$1;
(statearr_64557_64596[(1)] = (12));

} else {
var statearr_64558_64597 = state_64519__$1;
(statearr_64558_64597[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (18))){
var inst_64473 = (state_64519[(8)]);
var inst_64480 = (state_64519[(9)]);
var inst_64508 = (state_64519[(13)]);
var inst_64503 = (state_64519[(12)]);
var inst_64510 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64473,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64503,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64480,new cljs.core.Keyword(null,"block","block",664686210),inst_64508], 0));
var state_64519__$1 = state_64519;
var statearr_64559_64598 = state_64519__$1;
(statearr_64559_64598[(2)] = inst_64510);

(statearr_64559_64598[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64520 === (8))){
var inst_64470 = (state_64519[(7)]);
var inst_64473 = (state_64519[(8)]);
var inst_64480 = (state_64519[(9)]);
var inst_64508 = (state_64519[(13)]);
var inst_64503 = (state_64519[(12)]);
var inst_64476 = (state_64519[(10)]);
var inst_64503__$1 = (state_64519[(2)]);
var inst_64504 = (function (){var responses = inst_64470;
var responses_STAR_ = inst_64473;
var statuses = inst_64476;
var fuel = inst_64480;
var status = inst_64503__$1;
return (function (p1__64428_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__64428_SHARP_));
});
})();
var inst_64505 = cljs.core.vals(inst_64470);
var inst_64506 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64504,inst_64505);
var inst_64507 = cljs.core.first(inst_64506);
var inst_64508__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64507);
var state_64519__$1 = (function (){var statearr_64560 = state_64519;
(statearr_64560[(13)] = inst_64508__$1);

(statearr_64560[(12)] = inst_64503__$1);

return statearr_64560;
})();
if(cljs.core.truth_(inst_64508__$1)){
var statearr_64561_64599 = state_64519__$1;
(statearr_64561_64599[(1)] = (18));

} else {
var statearr_64562_64600 = state_64519__$1;
(statearr_64562_64600[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_64563 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64563[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_64563[(1)] = (1));

return statearr_64563;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_64519){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64519);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64564){var ex__2736__auto__ = e64564;
var statearr_64565_64601 = state_64519;
(statearr_64565_64601[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64519[(4)]))){
var statearr_64566_64602 = state_64519;
(statearr_64566_64602[(1)] = cljs.core.first((state_64519[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64603 = state_64519;
state_64519 = G__64603;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_64519){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_64519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64567 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64567[(6)] = c__2755__auto__);

return statearr_64567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__64605 = arguments.length;
switch (G__64605) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__64606 = opts;
var map__64606__$1 = cljs.core.__destructure_map(map__64606);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64606__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64606__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64606__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64606__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__64607 = (cljs.core.truth_((function (){var and__4221__auto__ = auth;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4221__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64607,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64607,(1),null);
var action__$1 = (function (){var or__4223__auto__ = action;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4223__auto__ = nonce;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4223__auto__ = expire;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e64610){var e = e64610;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__64613 = arguments.length;
switch (G__64613) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64644){
var state_val_64645 = (state_64644[(1)]);
if((state_val_64645 === (7))){
var state_64644__$1 = state_64644;
var statearr_64646_64667 = state_64644__$1;
(statearr_64646_64667[(2)] = opts);

(statearr_64646_64667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64645 === (1))){
var state_64644__$1 = state_64644;
var statearr_64647_64668 = state_64644__$1;
(statearr_64647_64668[(2)] = null);

(statearr_64647_64668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64645 === (4))){
var inst_64614 = (state_64644[(2)]);
var inst_64615 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64614], 0));
var inst_64616 = cljs.core.ex_data(inst_64614);
var inst_64617 = cljs.core.ex_message(inst_64614);
var inst_64618 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64616,new cljs.core.Keyword(null,"message","message",-406056002),inst_64617);
var state_64644__$1 = (function (){var statearr_64648 = state_64644;
(statearr_64648[(7)] = inst_64615);

return statearr_64648;
})();
var statearr_64649_64669 = state_64644__$1;
(statearr_64649_64669[(2)] = inst_64618);

(statearr_64649_64669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64645 === (6))){
var inst_64628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64629 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_64630 = (new cljs.core.PersistentVector(null,1,(5),inst_64628,inst_64629,null));
var inst_64631 = cljs.core.assoc_in(opts,inst_64630,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_64644__$1 = state_64644;
var statearr_64650_64670 = state_64644__$1;
(statearr_64650_64670[(2)] = inst_64631);

(statearr_64650_64670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64645 === (3))){
var inst_64642 = (state_64644[(2)]);
var state_64644__$1 = state_64644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64644__$1,inst_64642);
} else {
if((state_val_64645 === (2))){
var _ = (function (){var statearr_64652 = state_64644;
(statearr_64652[(4)] = cljs.core.cons((5),(state_64644[(4)])));

return statearr_64652;
})();
var inst_64624 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_64625 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_64626 = (inst_64625 == null);
var state_64644__$1 = (function (){var statearr_64653 = state_64644;
(statearr_64653[(8)] = inst_64624);

return statearr_64653;
})();
if(cljs.core.truth_(inst_64626)){
var statearr_64654_64671 = state_64644__$1;
(statearr_64654_64671[(1)] = (6));

} else {
var statearr_64655_64672 = state_64644__$1;
(statearr_64655_64672[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64645 === (9))){
var inst_64638 = (state_64644[(2)]);
var inst_64639 = fluree.db.util.async.throw_err(inst_64638);
var _ = (function (){var statearr_64656 = state_64644;
(statearr_64656[(4)] = cljs.core.rest((state_64644[(4)])));

return statearr_64656;
})();
var state_64644__$1 = state_64644;
var statearr_64657_64673 = state_64644__$1;
(statearr_64657_64673[(2)] = inst_64639);

(statearr_64657_64673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64645 === (5))){
var _ = (function (){var statearr_64658 = state_64644;
(statearr_64658[(4)] = cljs.core.rest((state_64644[(4)])));

return statearr_64658;
})();
var state_64644__$1 = state_64644;
var ex64651 = (state_64644__$1[(2)]);
var statearr_64659_64674 = state_64644__$1;
(statearr_64659_64674[(5)] = ex64651);


var statearr_64660_64675 = state_64644__$1;
(statearr_64660_64675[(1)] = (4));

(statearr_64660_64675[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64645 === (8))){
var inst_64624 = (state_64644[(8)]);
var inst_64634 = (state_64644[(2)]);
var inst_64635 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_64624,inst_64634);
var inst_64636 = fluree.db.operations.command_async(conn,inst_64635);
var state_64644__$1 = state_64644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64644__$1,(9),inst_64636);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_64661 = [null,null,null,null,null,null,null,null,null];
(statearr_64661[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_64661[(1)] = (1));

return statearr_64661;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_64644){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64644);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64662){var ex__2736__auto__ = e64662;
var statearr_64663_64676 = state_64644;
(statearr_64663_64676[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64644[(4)]))){
var statearr_64664_64677 = state_64644;
(statearr_64664_64677[(1)] = cljs.core.first((state_64644[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64678 = state_64644;
state_64644 = G__64678;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_64644){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_64644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64665 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64665[(6)] = c__2755__auto__);

return statearr_64665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

