// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('alphabase.core');
goog.require('cljs.core');
goog.require('alphabase.base64');
goog.require('alphabase.base58');
goog.require('alphabase.codec');
goog.require('alphabase.hex');
goog.require('goog.crypt');
/**
 * Converts string to UTF-8 bytes
 */
alphabase.core.string__GT_bytes = (function alphabase$core$string__GT_bytes(s){
return goog.crypt.stringToUtf8ByteArray(s);
});
/**
 * Converts UTF-8 byte array to string
 */
alphabase.core.bytes__GT_string = (function alphabase$core$bytes__GT_string(ba){
return goog.crypt.utf8ByteArrayToString(ba);
});
/**
 * Converts string to UTF-16 bytes
 */
alphabase.core.string__GT_bytes_UTF_16 = (function alphabase$core$string__GT_bytes_UTF_16(s){
return goog.crypt.stringToByteArray(s);
});
/**
 * Converts UTF-16 byte array to string
 */
alphabase.core.bytes__GT_string_UTF_16 = (function alphabase$core$bytes__GT_string_UTF_16(ba){
return goog.crypt.byteArrayToString(ba);
});
alphabase.core.biginteger__GT_bytes = (function alphabase$core$biginteger__GT_bytes(bint){
throw (new Error("Biginteger is not supported in cljs."));
});
alphabase.core.bytes__GT_biginteger = (function alphabase$core$bytes__GT_biginteger(ba){
throw (new Error("Biginteger is not supported in cljs."));
});
alphabase.core.encode = (function alphabase$core$encode(alphabet,data){
return alphabase.codec.encode(alphabet,data);
});
alphabase.core.decode = (function alphabase$core$decode(alphabet,tokens){
return alphabase.codec.decode(alphabet,tokens);
});
/**
 * Converts bytes to base-58
 */
alphabase.core.bytes__GT_base58 = (function alphabase$core$bytes__GT_base58(b){
return alphabase.base58.encode(b);
});
/**
 * Converts bytes to base-58
 */
alphabase.core.base58__GT_bytes = (function alphabase$core$base58__GT_bytes(b58){
return alphabase.base58.decode(b58);
});
/**
 * Converts bytes to base-64
 */
alphabase.core.bytes__GT_base64 = (function alphabase$core$bytes__GT_base64(b){
return alphabase.base64.encode(b);
});
/**
 * Converts bytes to base-64
 */
alphabase.core.base64__GT_bytes = (function alphabase$core$base64__GT_bytes(b64){
return alphabase.base64.decode(b64);
});
alphabase.core.hex__GT_bytes = (function alphabase$core$hex__GT_bytes(hex){
return alphabase.hex.decode(hex);
});
alphabase.core.bytes__GT_hex = (function alphabase$core$bytes__GT_hex(b){
return alphabase.hex.encode(b);
});
/**
 * Test if a string is base58
 */
alphabase.core.base58_QMARK_ = (function alphabase$core$base58_QMARK_(x){
return alphabase.base58.base58_QMARK_(x);
});
/**
 * Test if a string is base58
 */
alphabase.core.base64_QMARK_ = (function alphabase$core$base64_QMARK_(x){
return alphabase.base64.base64_QMARK_(x);
});
/**
 * Test if a string is base58
 */
alphabase.core.hex_QMARK_ = (function alphabase$core$hex_QMARK_(x){
return alphabase.hex.hex_QMARK_(x);
});
/**
 * Encodes a base58-string as a hex-string
 */
alphabase.core.base58_to_hex = (function alphabase$core$base58_to_hex(data){
return alphabase.core.bytes__GT_hex(alphabase.core.base58__GT_bytes(data));
});
/**
 * Encodes a hex-string as a base58-string
 */
alphabase.core.hex_to_base58 = (function alphabase$core$hex_to_base58(data){
if(alphabase.core.hex_QMARK_(data)){
} else {
throw (new Error(["Assert failed: ","Input must be hexadecimal","\n","(hex? data)"].join('')));
}

return alphabase.core.bytes__GT_base58(alphabase.core.hex__GT_bytes(data));
});
alphabase.core.byte_array_to_base = (function alphabase$core$byte_array_to_base(data,output_format){
var ba = data;
var G__32767 = output_format;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"hex","hex",41691346),G__32767)){
return alphabase.core.bytes__GT_hex(ba);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"base64","base64",167760174),G__32767)){
return alphabase.core.bytes__GT_base64(ba);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"base58","base58",1785479990),G__32767)){
return alphabase.core.bytes__GT_base58(ba);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"bytes","bytes",1175866680),G__32767)){
return ba;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"biginteger","biginteger",-285422718),G__32767)){
return alphabase.core.bytes__GT_biginteger(ba);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"string","string",-1989541586),G__32767)){
return alphabase.core.bytes__GT_string(ba);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"none","none",1333468478),G__32767)){
return ba;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__32767)){
return ba;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unsupported output-format",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),output_format], null));

}
}
}
}
}
}
}
}
});
/**
 * Convert data of specified base to a byte-array
 */
alphabase.core.base_to_byte_array = (function alphabase$core$base_to_byte_array(var_args){
var G__32769 = arguments.length;
switch (G__32769) {
case 1:
return alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (data){
return alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(data,((typeof data === 'string')?new cljs.core.Keyword(null,"string","string",-1989541586):new cljs.core.Keyword(null,"bytes","bytes",1175866680)));
}));

(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (data,format){
var G__32770 = format;
var G__32770__$1 = (((G__32770 instanceof cljs.core.Keyword))?G__32770.fqn:null);
switch (G__32770__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(data);

break;
case "base64":
return alphabase.core.base64__GT_bytes(data);

break;
case "base58":
return alphabase.core.base58__GT_bytes(data);

break;
case "bytes":
return data;

break;
case "string":
return alphabase.core.string__GT_bytes(data);

break;
case "biginteger":
return alphabase.core.biginteger__GT_bytes(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unsupported format",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"format","format",-1306924766),format], null));

}
}));

(alphabase.core.base_to_byte_array.cljs$lang$maxFixedArity = 2);

/**
 * Convert one base into another
 */
alphabase.core.base_to_base = (function alphabase$core$base_to_base(data,input_format,output_format){
if((data == null)){
return data;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(input_format,output_format)){
return data;
} else {
return alphabase.core.byte_array_to_base(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(data,input_format),output_format);

}
}
});
