// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k34920,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__34924 = k34920;
var G__34924__$1 = (((G__34924 instanceof cljs.core.Keyword))?G__34924.fqn:null);
switch (G__34924__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34920,else__4475__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__34925){
var vec__34926 = p__34925;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34926,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34926,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34919){
var self__ = this;
var G__34919__$1 = this;
return (new cljs.core.RecordIter((0),G__34919__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__34929 = (function (coll__4469__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__34929(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34921,other34922){
var self__ = this;
var this34921__$1 = this;
return (((!((other34922 == null)))) && ((((this34921__$1.constructor === other34922.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.conn,other34922.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.network,other34922.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.dbid,other34922.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.db_name,other34922.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.update_chan,other34922.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.transact_chan,other34922.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.state,other34922.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.schema_cache,other34922.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.blank_db,other34922.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.close,other34922.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.id,other34922.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34921__$1.__extmap,other34922.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k34920){
var self__ = this;
var this__4479__auto____$1 = this;
var G__34930 = k34920;
var G__34930__$1 = (((G__34930 instanceof cljs.core.Keyword))?G__34930.fqn:null);
switch (G__34930__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34920);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__34919){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__34931 = cljs.core.keyword_identical_QMARK_;
var expr__34932 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__34934 = cljs.core.cst$kw$conn;
var G__34935 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34934,G__34935) : pred__34931.call(null,G__34934,G__34935));
})())){
return (new fluree.db.session.DbSession(G__34919,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34936 = cljs.core.cst$kw$network;
var G__34937 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34936,G__34937) : pred__34931.call(null,G__34936,G__34937));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__34919,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34938 = cljs.core.cst$kw$dbid;
var G__34939 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34938,G__34939) : pred__34931.call(null,G__34938,G__34939));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__34919,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34940 = cljs.core.cst$kw$db_DASH_name;
var G__34941 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34940,G__34941) : pred__34931.call(null,G__34940,G__34941));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__34919,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34942 = cljs.core.cst$kw$update_DASH_chan;
var G__34943 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34942,G__34943) : pred__34931.call(null,G__34942,G__34943));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__34919,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34944 = cljs.core.cst$kw$transact_DASH_chan;
var G__34945 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34944,G__34945) : pred__34931.call(null,G__34944,G__34945));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__34919,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34946 = cljs.core.cst$kw$state;
var G__34947 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34946,G__34947) : pred__34931.call(null,G__34946,G__34947));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__34919,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34948 = cljs.core.cst$kw$schema_DASH_cache;
var G__34949 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34948,G__34949) : pred__34931.call(null,G__34948,G__34949));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__34919,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34950 = cljs.core.cst$kw$blank_DASH_db;
var G__34951 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34950,G__34951) : pred__34931.call(null,G__34950,G__34951));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__34919,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34952 = cljs.core.cst$kw$close;
var G__34953 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34952,G__34953) : pred__34931.call(null,G__34952,G__34953));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__34919,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34954 = cljs.core.cst$kw$id;
var G__34955 = expr__34932;
return (pred__34931.cljs$core$IFn$_invoke$arity$2 ? pred__34931.cljs$core$IFn$_invoke$arity$2(G__34954,G__34955) : pred__34931.call(null,G__34954,G__34955));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__34919,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__34919),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__34919){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__34919,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__34923){
var extmap__4512__auto__ = (function (){var G__34956 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34923,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__34923)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34956);
} else {
return G__34956;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__34923),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__34923),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__34959 = session;
var map__34959__$1 = cljs.core.__destructure_map(map__34959);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34959__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34959__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10878__auto___35111 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_35063){
var state_val_35064 = (state_35063[(1)]);
if((state_val_35064 === (7))){
var inst_34980 = (state_35063[(7)]);
var inst_34985 = cljs.core.empty_QMARK_(inst_34980);
var state_35063__$1 = state_35063;
if(inst_34985){
var statearr_35065_35112 = state_35063__$1;
(statearr_35065_35112[(1)] = (10));

} else {
var statearr_35066_35113 = state_35063__$1;
(statearr_35066_35113[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (20))){
var inst_34972 = (state_35063[(8)]);
var inst_34971 = (state_35063[(9)]);
var inst_35011 = (state_35063[(10)]);
var inst_34973 = (state_35063[(11)]);
var inst_35016 = fluree.db.storage.core.read_block(inst_34971,inst_34972,inst_34973,inst_35011);
var state_35063__$1 = state_35063;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35063__$1,(22),inst_35016);
} else {
if((state_val_35064 === (27))){
var inst_35047 = (state_35063[(12)]);
var inst_35052 = (state_35063[(13)]);
var inst_35050 = (state_35063[(2)]);
var inst_35051 = fluree.db.util.async.throw_err(inst_35050);
var inst_35052__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35047,cljs.core.cst$kw$schema,inst_35051);
var inst_35053 = fluree.db.query.schema.setting_map(inst_35052__$1);
var state_35063__$1 = (function (){var statearr_35067 = state_35063;
(statearr_35067[(13)] = inst_35052__$1);

return statearr_35067;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35063__$1,(28),inst_35053);
} else {
if((state_val_35064 === (1))){
var state_35063__$1 = state_35063;
var statearr_35068_35114 = state_35063__$1;
(statearr_35068_35114[(2)] = null);

(statearr_35068_35114[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (24))){
var inst_34972 = (state_35063[(8)]);
var inst_35011 = (state_35063[(10)]);
var inst_34973 = (state_35063[(11)]);
var inst_35033 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35011)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34972),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34973),"."].join('');
var inst_35034 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35035 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_35036 = cljs.core.PersistentHashMap.fromArrays(inst_35034,inst_35035);
var inst_35037 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35033,inst_35036);
var inst_35038 = (function(){throw inst_35037})();
var state_35063__$1 = state_35063;
var statearr_35069_35115 = state_35063__$1;
(statearr_35069_35115[(2)] = inst_35038);

(statearr_35069_35115[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (4))){
var inst_34960 = (state_35063[(2)]);
var inst_34961 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_34960);
var state_35063__$1 = state_35063;
var statearr_35070_35116 = state_35063__$1;
(statearr_35070_35116[(2)] = inst_34961);

(statearr_35070_35116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (15))){
var state_35063__$1 = state_35063;
var statearr_35071_35117 = state_35063__$1;
(statearr_35071_35117[(2)] = null);

(statearr_35071_35117[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (21))){
var inst_35042 = (state_35063[(2)]);
var state_35063__$1 = state_35063;
var statearr_35072_35118 = state_35063__$1;
(statearr_35072_35118[(2)] = inst_35042);

(statearr_35072_35118[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (13))){
var inst_35005 = (state_35063[(14)]);
var inst_34980 = (state_35063[(7)]);
var inst_35004 = (state_35063[(2)]);
var inst_35005__$1 = fluree.db.util.async.throw_err(inst_35004);
var inst_35006 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_34980);
var state_35063__$1 = (function (){var statearr_35073 = state_35063;
(statearr_35073[(14)] = inst_35005__$1);

(statearr_35073[(15)] = inst_35006);

return statearr_35073;
})();
if(cljs.core.truth_(inst_35005__$1)){
var statearr_35074_35119 = state_35063__$1;
(statearr_35074_35119[(1)] = (14));

} else {
var statearr_35075_35120 = state_35063__$1;
(statearr_35075_35120[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (22))){
var inst_35019 = (state_35063[(16)]);
var inst_35018 = (state_35063[(2)]);
var inst_35019__$1 = fluree.db.util.async.throw_err(inst_35018);
var state_35063__$1 = (function (){var statearr_35076 = state_35063;
(statearr_35076[(16)] = inst_35019__$1);

return statearr_35076;
})();
if(cljs.core.truth_(inst_35019__$1)){
var statearr_35077_35121 = state_35063__$1;
(statearr_35077_35121[(1)] = (23));

} else {
var statearr_35078_35122 = state_35063__$1;
(statearr_35078_35122[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (6))){
var inst_34980 = (state_35063[(7)]);
var inst_34979 = (state_35063[(2)]);
var inst_34980__$1 = fluree.db.util.async.throw_err(inst_34979);
var inst_34981 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_34980__$1);
var inst_34982 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_34981);
var inst_34983 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_34982);
var state_35063__$1 = (function (){var statearr_35079 = state_35063;
(statearr_35079[(7)] = inst_34980__$1);

return statearr_35079;
})();
if(inst_34983){
var statearr_35080_35123 = state_35063__$1;
(statearr_35080_35123[(1)] = (7));

} else {
var statearr_35081_35124 = state_35063__$1;
(statearr_35081_35124[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (28))){
var inst_35052 = (state_35063[(13)]);
var inst_35055 = (state_35063[(2)]);
var inst_35056 = fluree.db.util.async.throw_err(inst_35055);
var inst_35057 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35052,cljs.core.cst$kw$settings,inst_35056);
var inst_35058 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_35057);
var _ = (function (){var statearr_35082 = state_35063;
(statearr_35082[(4)] = cljs.core.rest((state_35063[(4)])));

return statearr_35082;
})();
var state_35063__$1 = state_35063;
var statearr_35083_35125 = state_35063__$1;
(statearr_35083_35125[(2)] = inst_35058);

(statearr_35083_35125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (25))){
var inst_35040 = (state_35063[(2)]);
var state_35063__$1 = state_35063;
var statearr_35084_35126 = state_35063__$1;
(statearr_35084_35126[(2)] = inst_35040);

(statearr_35084_35126[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (17))){
var inst_35006 = (state_35063[(15)]);
var inst_35011 = (state_35063[(10)]);
var inst_35013 = (inst_35011 > inst_35006);
var state_35063__$1 = state_35063;
if(cljs.core.truth_(inst_35013)){
var statearr_35085_35127 = state_35063__$1;
(statearr_35085_35127[(1)] = (19));

} else {
var statearr_35086_35128 = state_35063__$1;
(statearr_35086_35128[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (3))){
var inst_35061 = (state_35063[(2)]);
var state_35063__$1 = state_35063;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35063__$1,inst_35061);
} else {
if((state_val_35064 === (12))){
var inst_34992 = (state_35063[(2)]);
var inst_34993 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34994 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_34995 = cljs.core.PersistentHashMap.fromArrays(inst_34993,inst_34994);
var inst_34996 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34992,inst_34995);
var inst_34997 = (function(){throw inst_34996})();
var state_35063__$1 = state_35063;
var statearr_35087_35129 = state_35063__$1;
(statearr_35087_35129[(2)] = inst_34997);

(statearr_35087_35129[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (2))){
var inst_34972 = (state_35063[(8)]);
var inst_34971 = (state_35063[(9)]);
var inst_34973 = (state_35063[(11)]);
var _ = (function (){var statearr_35088 = state_35063;
(statearr_35088[(4)] = cljs.core.cons((5),(state_35063[(4)])));

return statearr_35088;
})();
var inst_34968 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_34969 = session;
var inst_34970 = cljs.core.__destructure_map(inst_34969);
var inst_34971__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34970,cljs.core.cst$kw$conn);
var inst_34972__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34970,cljs.core.cst$kw$network);
var inst_34973__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34970,cljs.core.cst$kw$dbid);
var inst_34974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34975 = [inst_34972__$1,inst_34973__$1];
var inst_34976 = (new cljs.core.PersistentVector(null,2,(5),inst_34974,inst_34975,null));
var inst_34977 = fluree.db.operations.ledger_info_async(inst_34971__$1,inst_34976);
var state_35063__$1 = (function (){var statearr_35089 = state_35063;
(statearr_35089[(8)] = inst_34972__$1);

(statearr_35089[(9)] = inst_34971__$1);

(statearr_35089[(17)] = inst_34968);

(statearr_35089[(11)] = inst_34973__$1);

return statearr_35089;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35063__$1,(6),inst_34977);
} else {
if((state_val_35064 === (23))){
var inst_35010 = (state_35063[(18)]);
var inst_35019 = (state_35063[(16)]);
var inst_35022 = cljs.core.__destructure_map(inst_35019);
var inst_35023 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35022,cljs.core.cst$kw$flakes);
var inst_35024 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35022,cljs.core.cst$kw$block);
var inst_35025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35022,cljs.core.cst$kw$t);
var inst_35026 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_35010,inst_35024,inst_35023);
var state_35063__$1 = (function (){var statearr_35090 = state_35063;
(statearr_35090[(19)] = inst_35025);

return statearr_35090;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35063__$1,(26),inst_35026);
} else {
if((state_val_35064 === (19))){
var inst_35010 = (state_35063[(18)]);
var state_35063__$1 = state_35063;
var statearr_35091_35130 = state_35063__$1;
(statearr_35091_35130[(2)] = inst_35010);

(statearr_35091_35130[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (11))){
var inst_34972 = (state_35063[(8)]);
var inst_34980 = (state_35063[(7)]);
var inst_34973 = (state_35063[(11)]);
var inst_34989 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_34980);
var inst_34990 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34972),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34973)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34989),"."].join('');
var state_35063__$1 = state_35063;
var statearr_35093_35131 = state_35063__$1;
(statearr_35093_35131[(2)] = inst_34990);

(statearr_35093_35131[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (9))){
var inst_34972 = (state_35063[(8)]);
var inst_34971 = (state_35063[(9)]);
var inst_34980 = (state_35063[(7)]);
var inst_34968 = (state_35063[(17)]);
var inst_34973 = (state_35063[(11)]);
var inst_35000 = (state_35063[(2)]);
var inst_35001 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_34980);
var inst_35002 = fluree.db.storage.core.reify_db(inst_34971,inst_34972,inst_34973,inst_34968,inst_35001);
var state_35063__$1 = (function (){var statearr_35094 = state_35063;
(statearr_35094[(20)] = inst_35000);

return statearr_35094;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35063__$1,(13),inst_35002);
} else {
if((state_val_35064 === (5))){
var _ = (function (){var statearr_35095 = state_35063;
(statearr_35095[(4)] = cljs.core.rest((state_35063[(4)])));

return statearr_35095;
})();
var state_35063__$1 = state_35063;
var ex35092 = (state_35063__$1[(2)]);
var statearr_35096_35132 = state_35063__$1;
(statearr_35096_35132[(5)] = ex35092);


var statearr_35097_35133 = state_35063__$1;
(statearr_35097_35133[(1)] = (4));

(statearr_35097_35133[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (14))){
var inst_35005 = (state_35063[(14)]);
var inst_35008 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_35005);
var inst_35009 = (inst_35008 + (1));
var inst_35010 = inst_35005;
var inst_35011 = inst_35009;
var state_35063__$1 = (function (){var statearr_35098 = state_35063;
(statearr_35098[(18)] = inst_35010);

(statearr_35098[(10)] = inst_35011);

return statearr_35098;
})();
var statearr_35099_35134 = state_35063__$1;
(statearr_35099_35134[(2)] = null);

(statearr_35099_35134[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (26))){
var inst_35011 = (state_35063[(10)]);
var inst_35028 = (state_35063[(2)]);
var inst_35029 = fluree.db.util.async.throw_err(inst_35028);
var inst_35030 = (inst_35011 + (1));
var inst_35010 = inst_35029;
var inst_35011__$1 = inst_35030;
var state_35063__$1 = (function (){var statearr_35100 = state_35063;
(statearr_35100[(18)] = inst_35010);

(statearr_35100[(10)] = inst_35011__$1);

return statearr_35100;
})();
var statearr_35101_35135 = state_35063__$1;
(statearr_35101_35135[(2)] = null);

(statearr_35101_35135[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (16))){
var inst_35047 = (state_35063[(12)]);
var inst_35047__$1 = (state_35063[(2)]);
var inst_35048 = fluree.db.query.schema.schema_map(inst_35047__$1);
var state_35063__$1 = (function (){var statearr_35102 = state_35063;
(statearr_35102[(12)] = inst_35047__$1);

return statearr_35102;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35063__$1,(27),inst_35048);
} else {
if((state_val_35064 === (10))){
var inst_34972 = (state_35063[(8)]);
var inst_34973 = (state_35063[(11)]);
var inst_34987 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34972),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34973)," is not found on this ledger group."].join('');
var state_35063__$1 = state_35063;
var statearr_35103_35136 = state_35063__$1;
(statearr_35103_35136[(2)] = inst_34987);

(statearr_35103_35136[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (18))){
var inst_35044 = (state_35063[(2)]);
var state_35063__$1 = state_35063;
var statearr_35104_35137 = state_35063__$1;
(statearr_35104_35137[(2)] = inst_35044);

(statearr_35104_35137[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35064 === (8))){
var state_35063__$1 = state_35063;
var statearr_35105_35138 = state_35063__$1;
(statearr_35105_35138[(2)] = null);

(statearr_35105_35138[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__10841__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__10841__auto____0 = (function (){
var statearr_35106 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35106[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__10841__auto__);

(statearr_35106[(1)] = (1));

return statearr_35106;
});
var fluree$db$session$full_load_existing_db_$_state_machine__10841__auto____1 = (function (state_35063){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_35063);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e35107){var ex__10844__auto__ = e35107;
var statearr_35108_35139 = state_35063;
(statearr_35108_35139[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_35063[(4)]))){
var statearr_35109_35140 = state_35063;
(statearr_35109_35140[(1)] = cljs.core.first((state_35063[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__35141 = state_35063;
state_35063 = G__35141;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__10841__auto__ = function(state_35063){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__10841__auto____1.call(this,state_35063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__10841__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__10841__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_35110 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_35110[(6)] = c__10878__auto___35111);

return statearr_35110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__35142 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__35142,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__35142;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__35143 = cljs.core.get_global_hierarchy;
return (fexpr__35143.cljs$core$IFn$_invoke$arity$0 ? fexpr__35143.cljs$core$IFn$_invoke$arity$0() : fexpr__35143.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_35145){
var state_val_35146 = (state_35145[(1)]);
if((state_val_35146 === (1))){
var state_35145__$1 = state_35145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35145__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10841__auto__ = null;
var fluree$db$session$state_machine__10841__auto____0 = (function (){
var statearr_35147 = [null,null,null,null,null,null,null];
(statearr_35147[(0)] = fluree$db$session$state_machine__10841__auto__);

(statearr_35147[(1)] = (1));

return statearr_35147;
});
var fluree$db$session$state_machine__10841__auto____1 = (function (state_35145){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_35145);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e35148){var ex__10844__auto__ = e35148;
var statearr_35149_35152 = state_35145;
(statearr_35149_35152[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_35145[(4)]))){
var statearr_35150_35153 = state_35145;
(statearr_35150_35153[(1)] = cljs.core.first((state_35145[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__35154 = state_35145;
state_35145 = G__35154;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$session$state_machine__10841__auto__ = function(state_35145){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10841__auto____1.call(this,state_35145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10841__auto____0;
fluree$db$session$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10841__auto____1;
return fluree$db$session$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_35151 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_35151[(6)] = c__10878__auto__);

return statearr_35151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__35156){
var map__35157 = p__35156;
var map__35157__$1 = cljs.core.__destructure_map(map__35157);
var data = map__35157__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35157__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35157__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35157__$1,cljs.core.cst$kw$flakes);
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_35216){
var state_val_35217 = (state_35216[(1)]);
if((state_val_35217 === (7))){
var inst_35171 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_35172 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_35173 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35171),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35172),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_35174 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35173], 0));
var state_35216__$1 = state_35216;
var statearr_35218_35256 = state_35216__$1;
(statearr_35218_35256[(2)] = inst_35174);

(statearr_35218_35256[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (1))){
var state_35216__$1 = state_35216;
var statearr_35219_35257 = state_35216__$1;
(statearr_35219_35257[(2)] = null);

(statearr_35219_35257[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (4))){
var inst_35158 = (state_35216[(2)]);
var state_35216__$1 = state_35216;
var statearr_35220_35258 = state_35216__$1;
(statearr_35220_35258[(2)] = inst_35158);

(statearr_35220_35258[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (15))){
var inst_35197 = (state_35216[(2)]);
var state_35216__$1 = state_35216;
var statearr_35221_35259 = state_35216__$1;
(statearr_35221_35259[(2)] = inst_35197);

(statearr_35221_35259[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (13))){
var inst_35188 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_35189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35190 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_35191 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_35192 = [inst_35190,inst_35191];
var inst_35193 = (new cljs.core.PersistentVector(null,2,(5),inst_35189,inst_35192,null));
var inst_35194 = (function (){var G__35222 = inst_35188;
var G__35223 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__35224 = inst_35193;
var G__35225 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__35222,G__35223,G__35224,G__35225) : fluree.db.conn_events.process_event.call(null,G__35222,G__35223,G__35224,G__35225));
})();
var state_35216__$1 = state_35216;
var statearr_35226_35260 = state_35216__$1;
(statearr_35226_35260[(2)] = inst_35194);

(statearr_35226_35260[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (6))){
var inst_35167 = (state_35216[(7)]);
var inst_35168 = (state_35216[(8)]);
var inst_35166 = (state_35216[(2)]);
var inst_35167__$1 = fluree.db.util.async.throw_err(inst_35166);
var inst_35168__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_35167__$1);
var inst_35169 = (block <= inst_35168__$1);
var state_35216__$1 = (function (){var statearr_35227 = state_35216;
(statearr_35227[(7)] = inst_35167__$1);

(statearr_35227[(8)] = inst_35168__$1);

return statearr_35227;
})();
if(cljs.core.truth_(inst_35169)){
var statearr_35228_35261 = state_35216__$1;
(statearr_35228_35261[(1)] = (7));

} else {
var statearr_35229_35262 = state_35216__$1;
(statearr_35229_35262[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (17))){
var state_35216__$1 = state_35216;
var statearr_35230_35263 = state_35216__$1;
(statearr_35230_35263[(2)] = null);

(statearr_35230_35263[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (3))){
var inst_35214 = (state_35216[(2)]);
var state_35216__$1 = state_35216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35216__$1,inst_35214);
} else {
if((state_val_35217 === (12))){
var inst_35209 = (state_35216[(2)]);
var state_35216__$1 = state_35216;
var statearr_35231_35264 = state_35216__$1;
(statearr_35231_35264[(2)] = inst_35209);

(statearr_35231_35264[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (2))){
var inst_35164 = (state_35216[(9)]);
var _ = (function (){var statearr_35232 = state_35216;
(statearr_35232[(4)] = cljs.core.cons((5),(state_35216[(4)])));

return statearr_35232;
})();
var inst_35164__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_35216__$1 = (function (){var statearr_35233 = state_35216;
(statearr_35233[(9)] = inst_35164__$1);

return statearr_35233;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35216__$1,(6),inst_35164__$1);
} else {
if((state_val_35217 === (11))){
var state_35216__$1 = state_35216;
var statearr_35235_35265 = state_35216__$1;
(statearr_35235_35265[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (9))){
var inst_35211 = (state_35216[(2)]);
var _ = (function (){var statearr_35237 = state_35216;
(statearr_35237[(4)] = cljs.core.rest((state_35216[(4)])));

return statearr_35237;
})();
var state_35216__$1 = state_35216;
var statearr_35238_35266 = state_35216__$1;
(statearr_35238_35266[(2)] = inst_35211);

(statearr_35238_35266[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (5))){
var _ = (function (){var statearr_35239 = state_35216;
(statearr_35239[(4)] = cljs.core.rest((state_35216[(4)])));

return statearr_35239;
})();
var state_35216__$1 = state_35216;
var ex35234 = (state_35216__$1[(2)]);
var statearr_35240_35267 = state_35216__$1;
(statearr_35240_35267[(5)] = ex35234);


if((ex35234 instanceof Error)){
var statearr_35241_35268 = state_35216__$1;
(statearr_35241_35268[(1)] = (4));

(statearr_35241_35268[(5)] = null);

} else {
throw ex35234;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (14))){
var state_35216__$1 = state_35216;
var statearr_35242_35269 = state_35216__$1;
(statearr_35242_35269[(2)] = null);

(statearr_35242_35269[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (16))){
var inst_35168 = (state_35216[(8)]);
var inst_35200 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_35201 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_35202 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35200),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35201),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35168),". Forcing a db reload."].join('');
var inst_35203 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35202], 0));
var inst_35204 = fluree.db.session.reload_db_BANG_(session);
var state_35216__$1 = (function (){var statearr_35243 = state_35216;
(statearr_35243[(10)] = inst_35203);

return statearr_35243;
})();
var statearr_35244_35270 = state_35216__$1;
(statearr_35244_35270[(2)] = inst_35204);

(statearr_35244_35270[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (10))){
var inst_35164 = (state_35216[(9)]);
var inst_35167 = (state_35216[(7)]);
var inst_35168 = (state_35216[(8)]);
var inst_35179 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_35180 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_35181 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35179),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35180),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_35182 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35181], 0));
var inst_35183 = (function (){var current_db_ch = inst_35164;
var current_db = inst_35167;
var current_block = inst_35168;
return (function (p1__35155_SHARP_){
if((p1__35155_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__35155_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__35155_SHARP_);
}
});
})();
var inst_35184 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35183,flakes);
var inst_35185 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_35167,block,inst_35184);
var inst_35186 = fluree.db.session.cas_db_BANG_(session,inst_35164,inst_35185);
var state_35216__$1 = (function (){var statearr_35245 = state_35216;
(statearr_35245[(11)] = inst_35182);

return statearr_35245;
})();
if(inst_35186){
var statearr_35246_35271 = state_35216__$1;
(statearr_35246_35271[(1)] = (13));

} else {
var statearr_35247_35272 = state_35216__$1;
(statearr_35247_35272[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (18))){
var inst_35207 = (state_35216[(2)]);
var state_35216__$1 = state_35216;
var statearr_35248_35273 = state_35216__$1;
(statearr_35248_35273[(2)] = inst_35207);

(statearr_35248_35273[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35217 === (8))){
var inst_35168 = (state_35216[(8)]);
var inst_35176 = ((1) + inst_35168);
var inst_35177 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_35176);
var state_35216__$1 = state_35216;
if(inst_35177){
var statearr_35249_35274 = state_35216__$1;
(statearr_35249_35274[(1)] = (10));

} else {
var statearr_35250_35275 = state_35216__$1;
(statearr_35250_35275[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10841__auto__ = null;
var fluree$db$session$state_machine__10841__auto____0 = (function (){
var statearr_35251 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35251[(0)] = fluree$db$session$state_machine__10841__auto__);

(statearr_35251[(1)] = (1));

return statearr_35251;
});
var fluree$db$session$state_machine__10841__auto____1 = (function (state_35216){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_35216);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e35252){var ex__10844__auto__ = e35252;
var statearr_35253_35276 = state_35216;
(statearr_35253_35276[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_35216[(4)]))){
var statearr_35254_35277 = state_35216;
(statearr_35254_35277[(1)] = cljs.core.first((state_35216[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__35278 = state_35216;
state_35216 = G__35278;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$session$state_machine__10841__auto__ = function(state_35216){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10841__auto____1.call(this,state_35216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10841__auto____0;
fluree$db$session$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10841__auto____1;
return fluree$db$session$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_35255 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_35255[(6)] = c__10878__auto__);

return statearr_35255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_35285){
var state_val_35286 = (state_35285[(1)]);
if((state_val_35286 === (1))){
var inst_35279 = fluree.db.session.clear_db_BANG_(session);
var inst_35280 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_35281 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_35282 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35280),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35281)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_35283 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35282], 0));
var state_35285__$1 = (function (){var statearr_35287 = state_35285;
(statearr_35287[(7)] = inst_35279);

(statearr_35287[(8)] = inst_35283);

return statearr_35287;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35285__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10841__auto__ = null;
var fluree$db$session$state_machine__10841__auto____0 = (function (){
var statearr_35288 = [null,null,null,null,null,null,null,null,null];
(statearr_35288[(0)] = fluree$db$session$state_machine__10841__auto__);

(statearr_35288[(1)] = (1));

return statearr_35288;
});
var fluree$db$session$state_machine__10841__auto____1 = (function (state_35285){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_35285);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e35289){var ex__10844__auto__ = e35289;
var statearr_35290_35293 = state_35285;
(statearr_35290_35293[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_35285[(4)]))){
var statearr_35291_35294 = state_35285;
(statearr_35291_35294[(1)] = cljs.core.first((state_35285[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__35295 = state_35285;
state_35285 = G__35295;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$session$state_machine__10841__auto__ = function(state_35285){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10841__auto____1.call(this,state_35285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10841__auto____0;
fluree$db$session$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10841__auto____1;
return fluree$db$session$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_35292 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_35292[(6)] = c__10878__auto__);

return statearr_35292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__35297 = arguments.length;
switch (G__35297) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__35298 = session;
var map__35298__$1 = cljs.core.__destructure_map(map__35298);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__35299_35302 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__35299_35302.cljs$core$IFn$_invoke$arity$3 ? fexpr__35299_35302.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__35299_35302.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__35300_35303 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__35300_35303.cljs$core$IFn$_invoke$arity$0 ? fexpr__35300_35303.cljs$core$IFn$_invoke$arity$0() : fexpr__35300_35303.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_35356){
var state_val_35357 = (state_35356[(1)]);
if((state_val_35357 === (7))){
var inst_35352 = (state_35356[(2)]);
var state_35356__$1 = state_35356;
var statearr_35358_35389 = state_35356__$1;
(statearr_35358_35389[(2)] = inst_35352);

(statearr_35358_35389[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (1))){
var state_35356__$1 = state_35356;
var statearr_35359_35390 = state_35356__$1;
(statearr_35359_35390[(2)] = null);

(statearr_35359_35390[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (4))){
var inst_35307 = (state_35356[(7)]);
var inst_35306 = (state_35356[(2)]);
var inst_35307__$1 = fluree.db.util.async.throw_err(inst_35306);
var inst_35308 = fluree.db.session.from_cache(network,ledger_id);
var inst_35309 = (inst_35307__$1 == null);
var state_35356__$1 = (function (){var statearr_35360 = state_35356;
(statearr_35360[(7)] = inst_35307__$1);

(statearr_35360[(8)] = inst_35308);

return statearr_35360;
})();
if(cljs.core.truth_(inst_35309)){
var statearr_35361_35391 = state_35356__$1;
(statearr_35361_35391[(1)] = (5));

} else {
var statearr_35362_35392 = state_35356__$1;
(statearr_35362_35392[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (15))){
var inst_35344 = (state_35356[(2)]);
var state_35356__$1 = (function (){var statearr_35363 = state_35356;
(statearr_35363[(9)] = inst_35344);

return statearr_35363;
})();
var statearr_35364_35393 = state_35356__$1;
(statearr_35364_35393[(2)] = null);

(statearr_35364_35393[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (13))){
var inst_35348 = (state_35356[(2)]);
var state_35356__$1 = state_35356;
var statearr_35366_35394 = state_35356__$1;
(statearr_35366_35394[(2)] = inst_35348);

(statearr_35366_35394[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (6))){
var inst_35308 = (state_35356[(8)]);
var inst_35314 = (inst_35308 == null);
var state_35356__$1 = state_35356;
if(cljs.core.truth_(inst_35314)){
var statearr_35367_35395 = state_35356__$1;
(statearr_35367_35395[(1)] = (8));

} else {
var statearr_35368_35396 = state_35356__$1;
(statearr_35368_35396[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (17))){
var _ = (function (){var statearr_35369 = state_35356;
(statearr_35369[(4)] = cljs.core.rest((state_35356[(4)])));

return statearr_35369;
})();
var state_35356__$1 = state_35356;
var ex35365 = (state_35356__$1[(2)]);
var statearr_35370_35397 = state_35356__$1;
(statearr_35370_35397[(5)] = ex35365);


var statearr_35371_35398 = state_35356__$1;
(statearr_35371_35398[(1)] = (16));

(statearr_35371_35398[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (3))){
var inst_35354 = (state_35356[(2)]);
var state_35356__$1 = state_35356;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35356__$1,inst_35354);
} else {
if((state_val_35357 === (12))){
var state_35356__$1 = state_35356;
var statearr_35372_35399 = state_35356__$1;
(statearr_35372_35399[(2)] = null);

(statearr_35372_35399[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (2))){
var state_35356__$1 = state_35356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35356__$1,(4),update_chan);
} else {
if((state_val_35357 === (11))){
var state_35356__$1 = state_35356;
var statearr_35373_35400 = state_35356__$1;
(statearr_35373_35400[(2)] = null);

(statearr_35373_35400[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (9))){
var state_35356__$1 = state_35356;
var statearr_35374_35401 = state_35356__$1;
(statearr_35374_35401[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (5))){
var inst_35311 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_35312 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35311], 0));
var state_35356__$1 = state_35356;
var statearr_35376_35402 = state_35356__$1;
(statearr_35376_35402[(2)] = inst_35312);

(statearr_35376_35402[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (14))){
var inst_35307 = (state_35356[(7)]);
var inst_35308 = (state_35356[(8)]);
var _ = (function (){var statearr_35377 = state_35356;
(statearr_35377[(4)] = cljs.core.cons((17),(state_35356[(4)])));

return statearr_35377;
})();
var inst_35332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35307,(0),null);
var inst_35333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35307,(1),null);
var inst_35334 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_35335 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35307], 0));
var inst_35336 = fluree.db.util.core.trunc(inst_35335,(200));
var inst_35337 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35334,inst_35336], 0));
var inst_35338 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_35308,inst_35332,inst_35333) : fluree.db.session.process_ledger_update.call(null,inst_35308,inst_35332,inst_35333));
var state_35356__$1 = (function (){var statearr_35378 = state_35356;
(statearr_35378[(10)] = inst_35337);

return statearr_35378;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35356__$1,(18),inst_35338);
} else {
if((state_val_35357 === (16))){
var inst_35307 = (state_35356[(7)]);
var inst_35322 = (state_35356[(2)]);
var inst_35323 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35322,"Exception processing ledger updates for message: ",inst_35307], 0));
var state_35356__$1 = state_35356;
var statearr_35379_35403 = state_35356__$1;
(statearr_35379_35403[(2)] = inst_35323);

(statearr_35379_35403[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (10))){
var inst_35350 = (state_35356[(2)]);
var state_35356__$1 = state_35356;
var statearr_35380_35404 = state_35356__$1;
(statearr_35380_35404[(2)] = inst_35350);

(statearr_35380_35404[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (18))){
var inst_35340 = (state_35356[(2)]);
var inst_35341 = fluree.db.util.async.throw_err(inst_35340);
var _ = (function (){var statearr_35381 = state_35356;
(statearr_35381[(4)] = cljs.core.rest((state_35356[(4)])));

return statearr_35381;
})();
var state_35356__$1 = state_35356;
var statearr_35382_35405 = state_35356__$1;
(statearr_35382_35405[(2)] = inst_35341);

(statearr_35382_35405[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35357 === (8))){
var inst_35307 = (state_35356[(7)]);
var inst_35316 = cljs.core.first(inst_35307);
var inst_35317 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35316], 0));
var inst_35318 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_35317].join('');
var inst_35319 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35318], 0));
var state_35356__$1 = state_35356;
var statearr_35383_35406 = state_35356__$1;
(statearr_35383_35406[(2)] = inst_35319);

(statearr_35383_35406[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__10841__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__10841__auto____0 = (function (){
var statearr_35384 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35384[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__10841__auto__);

(statearr_35384[(1)] = (1));

return statearr_35384;
});
var fluree$db$session$process_ledger_updates_$_state_machine__10841__auto____1 = (function (state_35356){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_35356);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e35385){var ex__10844__auto__ = e35385;
var statearr_35386_35407 = state_35356;
(statearr_35386_35407[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_35356[(4)]))){
var statearr_35387_35408 = state_35356;
(statearr_35387_35408[(1)] = cljs.core.first((state_35356[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__35409 = state_35356;
state_35356 = G__35409;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__10841__auto__ = function(state_35356){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__10841__auto____1.call(this,state_35356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__10841__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__10841__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_35388 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_35388[(6)] = c__10878__auto__);

return statearr_35388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__35410){
var map__35411 = p__35410;
var map__35411__$1 = cljs.core.__destructure_map(map__35411);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35411__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35411__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35411__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35411__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35411__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35411__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35411__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35411__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35411__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__35415 = block_result;
var map__35415__$1 = cljs.core.__destructure_map(map__35415);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35415__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35415__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35415__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35415__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35415__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__35416 = tx_result;
var map__35416__$1 = cljs.core.__destructure_map(map__35416);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35416__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35416__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__35412_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__35412_SHARP_.t);
}):(function (p1__35413_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__35413_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__35414_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__35414_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__35414_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__35417 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35417,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35417,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35417,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35417,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__35421 = arguments.length;
switch (G__35421) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__35422){
var map__35423 = p__35422;
var map__35423__$1 = cljs.core.__destructure_map(map__35423);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35423__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35423__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35423__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35423__$1,cljs.core.cst$kw$jwt);
var vec__35424 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35424,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35424,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35424,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4223__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4223__auto____$1 = state;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__35428_35548 = network;
var G__35429_35549 = ledger_id;
var G__35430_35550 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__35431_35551 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__35432 = cljs.core.seq(tids);
var chunk__35433 = null;
var count__35434 = (0);
var i__35435 = (0);
while(true){
if((i__35435 < count__35434)){
var tid = chunk__35433.cljs$core$IIndexed$_nth$arity$2(null,i__35435);
var temp__5753__auto___35553__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___35553__$1)){
var keyed_callbacks_35554 = temp__5753__auto___35553__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_35555 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__35476_35556 = cljs.core.seq(keyed_callbacks_35554);
var chunk__35477_35557 = null;
var count__35478_35558 = (0);
var i__35479_35559 = (0);
while(true){
if((i__35479_35559 < count__35478_35558)){
var vec__35488_35560 = chunk__35477_35557.cljs$core$IIndexed$_nth$arity$2(null,i__35479_35559);
var k_35561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35488_35560,(0),null);
var f_35562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35488_35560,(1),null);
try{(f_35562.cljs$core$IFn$_invoke$arity$1 ? f_35562.cljs$core$IFn$_invoke$arity$1(tx_response_35555) : f_35562.call(null,tx_response_35555));
}catch (e35491){var e_35563 = e35491;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_35563,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__35564 = seq__35476_35556;
var G__35565 = chunk__35477_35557;
var G__35566 = count__35478_35558;
var G__35567 = (i__35479_35559 + (1));
seq__35476_35556 = G__35564;
chunk__35477_35557 = G__35565;
count__35478_35558 = G__35566;
i__35479_35559 = G__35567;
continue;
} else {
var temp__5753__auto___35568__$2 = cljs.core.seq(seq__35476_35556);
if(temp__5753__auto___35568__$2){
var seq__35476_35569__$1 = temp__5753__auto___35568__$2;
if(cljs.core.chunked_seq_QMARK_(seq__35476_35569__$1)){
var c__4649__auto___35570 = cljs.core.chunk_first(seq__35476_35569__$1);
var G__35571 = cljs.core.chunk_rest(seq__35476_35569__$1);
var G__35572 = c__4649__auto___35570;
var G__35573 = cljs.core.count(c__4649__auto___35570);
var G__35574 = (0);
seq__35476_35556 = G__35571;
chunk__35477_35557 = G__35572;
count__35478_35558 = G__35573;
i__35479_35559 = G__35574;
continue;
} else {
var vec__35492_35575 = cljs.core.first(seq__35476_35569__$1);
var k_35576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35492_35575,(0),null);
var f_35577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35492_35575,(1),null);
try{(f_35577.cljs$core$IFn$_invoke$arity$1 ? f_35577.cljs$core$IFn$_invoke$arity$1(tx_response_35555) : f_35577.call(null,tx_response_35555));
}catch (e35495){var e_35578 = e35495;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_35578,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__35579 = cljs.core.next(seq__35476_35569__$1);
var G__35580 = null;
var G__35581 = (0);
var G__35582 = (0);
seq__35476_35556 = G__35579;
chunk__35477_35557 = G__35580;
count__35478_35558 = G__35581;
i__35479_35559 = G__35582;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__35583 = seq__35432;
var G__35584 = chunk__35433;
var G__35585 = count__35434;
var G__35586 = (i__35435 + (1));
seq__35432 = G__35583;
chunk__35433 = G__35584;
count__35434 = G__35585;
i__35435 = G__35586;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__35432);
if(temp__5753__auto____$1){
var seq__35432__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__35432__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__35432__$1);
var G__35587 = cljs.core.chunk_rest(seq__35432__$1);
var G__35588 = c__4649__auto__;
var G__35589 = cljs.core.count(c__4649__auto__);
var G__35590 = (0);
seq__35432 = G__35587;
chunk__35433 = G__35588;
count__35434 = G__35589;
i__35435 = G__35590;
continue;
} else {
var tid = cljs.core.first(seq__35432__$1);
var temp__5753__auto___35591__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___35591__$2)){
var keyed_callbacks_35592 = temp__5753__auto___35591__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_35593 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__35496_35594 = cljs.core.seq(keyed_callbacks_35592);
var chunk__35497_35595 = null;
var count__35498_35596 = (0);
var i__35499_35597 = (0);
while(true){
if((i__35499_35597 < count__35498_35596)){
var vec__35508_35598 = chunk__35497_35595.cljs$core$IIndexed$_nth$arity$2(null,i__35499_35597);
var k_35599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35508_35598,(0),null);
var f_35600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35508_35598,(1),null);
try{(f_35600.cljs$core$IFn$_invoke$arity$1 ? f_35600.cljs$core$IFn$_invoke$arity$1(tx_response_35593) : f_35600.call(null,tx_response_35593));
}catch (e35511){var e_35601 = e35511;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_35601,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__35602 = seq__35496_35594;
var G__35603 = chunk__35497_35595;
var G__35604 = count__35498_35596;
var G__35605 = (i__35499_35597 + (1));
seq__35496_35594 = G__35602;
chunk__35497_35595 = G__35603;
count__35498_35596 = G__35604;
i__35499_35597 = G__35605;
continue;
} else {
var temp__5753__auto___35606__$3 = cljs.core.seq(seq__35496_35594);
if(temp__5753__auto___35606__$3){
var seq__35496_35607__$1 = temp__5753__auto___35606__$3;
if(cljs.core.chunked_seq_QMARK_(seq__35496_35607__$1)){
var c__4649__auto___35608 = cljs.core.chunk_first(seq__35496_35607__$1);
var G__35609 = cljs.core.chunk_rest(seq__35496_35607__$1);
var G__35610 = c__4649__auto___35608;
var G__35611 = cljs.core.count(c__4649__auto___35608);
var G__35612 = (0);
seq__35496_35594 = G__35609;
chunk__35497_35595 = G__35610;
count__35498_35596 = G__35611;
i__35499_35597 = G__35612;
continue;
} else {
var vec__35512_35613 = cljs.core.first(seq__35496_35607__$1);
var k_35614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35512_35613,(0),null);
var f_35615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35512_35613,(1),null);
try{(f_35615.cljs$core$IFn$_invoke$arity$1 ? f_35615.cljs$core$IFn$_invoke$arity$1(tx_response_35593) : f_35615.call(null,tx_response_35593));
}catch (e35515){var e_35616 = e35515;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_35616,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__35617 = cljs.core.next(seq__35496_35607__$1);
var G__35618 = null;
var G__35619 = (0);
var G__35620 = (0);
seq__35496_35594 = G__35617;
chunk__35497_35595 = G__35618;
count__35498_35596 = G__35619;
i__35499_35597 = G__35620;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__35621 = cljs.core.next(seq__35432__$1);
var G__35622 = null;
var G__35623 = (0);
var G__35624 = (0);
seq__35432 = G__35621;
chunk__35433 = G__35622;
count__35434 = G__35623;
i__35435 = G__35624;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__35427_35552 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__35427_35552.cljs$core$IFn$_invoke$arity$4 ? fexpr__35427_35552.cljs$core$IFn$_invoke$arity$4(G__35428_35548,G__35429_35549,G__35430_35550,G__35431_35551) : fexpr__35427_35552.call(null,G__35428_35548,G__35429_35549,G__35430_35550,G__35431_35551));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_35625 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__10878__auto___35626 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_35532){
var state_val_35533 = (state_35532[(1)]);
if((state_val_35533 === (1))){
var state_35532__$1 = state_35532;
var statearr_35534_35627 = state_35532__$1;
(statearr_35534_35627[(2)] = null);

(statearr_35534_35627[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35533 === (2))){
var inst_35517 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_35532__$1 = state_35532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35532__$1,(4),inst_35517);
} else {
if((state_val_35533 === (3))){
var inst_35530 = (state_35532[(2)]);
var state_35532__$1 = state_35532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35532__$1,inst_35530);
} else {
if((state_val_35533 === (4))){
var inst_35519 = (state_35532[(7)]);
var inst_35519__$1 = (state_35532[(2)]);
var inst_35520 = (inst_35519__$1 == null);
var state_35532__$1 = (function (){var statearr_35535 = state_35532;
(statearr_35535[(7)] = inst_35519__$1);

return statearr_35535;
})();
if(cljs.core.truth_(inst_35520)){
var statearr_35536_35628 = state_35532__$1;
(statearr_35536_35628[(1)] = (5));

} else {
var statearr_35537_35629 = state_35532__$1;
(statearr_35537_35629[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35533 === (5))){
var inst_35522 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_35523 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35522], 0));
var state_35532__$1 = state_35532;
var statearr_35538_35630 = state_35532__$1;
(statearr_35538_35630[(2)] = inst_35523);

(statearr_35538_35630[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35533 === (6))){
var inst_35519 = (state_35532[(7)]);
var inst_35525 = (transact_handler_35625.cljs$core$IFn$_invoke$arity$2 ? transact_handler_35625.cljs$core$IFn$_invoke$arity$2(conn,inst_35519) : transact_handler_35625.call(null,conn,inst_35519));
var state_35532__$1 = (function (){var statearr_35539 = state_35532;
(statearr_35539[(8)] = inst_35525);

return statearr_35539;
})();
var statearr_35540_35631 = state_35532__$1;
(statearr_35540_35631[(2)] = null);

(statearr_35540_35631[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35533 === (7))){
var inst_35528 = (state_35532[(2)]);
var state_35532__$1 = state_35532;
var statearr_35541_35632 = state_35532__$1;
(statearr_35541_35632[(2)] = inst_35528);

(statearr_35541_35632[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10841__auto__ = null;
var fluree$db$session$state_machine__10841__auto____0 = (function (){
var statearr_35542 = [null,null,null,null,null,null,null,null,null];
(statearr_35542[(0)] = fluree$db$session$state_machine__10841__auto__);

(statearr_35542[(1)] = (1));

return statearr_35542;
});
var fluree$db$session$state_machine__10841__auto____1 = (function (state_35532){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_35532);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e35543){var ex__10844__auto__ = e35543;
var statearr_35544_35633 = state_35532;
(statearr_35544_35633[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_35532[(4)]))){
var statearr_35545_35634 = state_35532;
(statearr_35545_35634[(1)] = cljs.core.first((state_35532[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__35635 = state_35532;
state_35532 = G__35635;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$session$state_machine__10841__auto__ = function(state_35532){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10841__auto____1.call(this,state_35532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10841__auto____0;
fluree$db$session$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10841__auto____1;
return fluree$db$session$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_35546 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_35546[(6)] = c__10878__auto___35626);

return statearr_35546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__35636_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__35636_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__35636_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__35637_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__35637_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__35640 = arguments.length;
switch (G__35640) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__35641 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35638_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__35638_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__35641);
} else {
return G__35641;
}
})();
var seq__35642 = cljs.core.seq(sessions);
var chunk__35643 = null;
var count__35644 = (0);
var i__35645 = (0);
while(true){
if((i__35645 < count__35644)){
var session = chunk__35643.cljs$core$IIndexed$_nth$arity$2(null,i__35645);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__35647 = seq__35642;
var G__35648 = chunk__35643;
var G__35649 = count__35644;
var G__35650 = (i__35645 + (1));
seq__35642 = G__35647;
chunk__35643 = G__35648;
count__35644 = G__35649;
i__35645 = G__35650;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__35642);
if(temp__5753__auto__){
var seq__35642__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35642__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__35642__$1);
var G__35651 = cljs.core.chunk_rest(seq__35642__$1);
var G__35652 = c__4649__auto__;
var G__35653 = cljs.core.count(c__4649__auto__);
var G__35654 = (0);
seq__35642 = G__35651;
chunk__35643 = G__35652;
count__35644 = G__35653;
i__35645 = G__35654;
continue;
} else {
var session = cljs.core.first(seq__35642__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__35655 = cljs.core.next(seq__35642__$1);
var G__35656 = null;
var G__35657 = (0);
var G__35658 = (0);
seq__35642 = G__35655;
chunk__35643 = G__35656;
count__35644 = G__35657;
i__35645 = G__35658;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
