// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e29401){var e = e29401;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__29402_SHARP_){
var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__29402_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__29402_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__29402_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__29402_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__29403_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__29403_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__29404_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__29404_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4221__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4223__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__29409 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29409,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29409,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__29405_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__29405_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4221__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4221__auto__;
}
})())){
var vec__29412 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29412,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29412,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4223__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__29406_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__29406_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__29407_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__29407_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__29408_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__29408_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29415_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__29415_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (add_amount > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fuel;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4221__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__29416 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__29416) : intersecting_vars.call(null,G__29416));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__29419,optional_QMARK_,fuel,max_fuel){
var map__29420 = p__29419;
var map__29420__$1 = cljs.core.__destructure_map(map__29420);
var res = map__29420__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29420__$1,cljs.core.cst$kw$vars);
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_29486){
var state_val_29487 = (state_29486[(1)]);
if((state_val_29487 === (7))){
var inst_29475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29476 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_29477 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29476,clause);
var inst_29478 = [null,inst_29477];
var inst_29479 = (new cljs.core.PersistentVector(null,2,(5),inst_29475,inst_29478,null));
var state_29486__$1 = state_29486;
var statearr_29488_29516 = state_29486__$1;
(statearr_29488_29516[(2)] = inst_29479);

(statearr_29488_29516[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (1))){
var state_29486__$1 = state_29486;
var statearr_29489_29517 = state_29486__$1;
(statearr_29489_29517[(2)] = null);

(statearr_29489_29517[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (4))){
var inst_29421 = (state_29486[(2)]);
var state_29486__$1 = state_29486;
var statearr_29490_29518 = state_29486__$1;
(statearr_29490_29518[(2)] = inst_29421);

(statearr_29490_29518[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (15))){
var inst_29464 = (state_29486[(2)]);
var inst_29465 = fluree.db.util.async.throw_err(inst_29464);
var inst_29466 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_29465);
var inst_29467 = cljs.core.count(inst_29466);
var inst_29468 = fluree.db.query.analytical.add_fuel(inst_29467,fuel,max_fuel);
var inst_29469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29470 = [inst_29465,r];
var inst_29471 = (new cljs.core.PersistentVector(null,2,(5),inst_29469,inst_29470,null));
var state_29486__$1 = (function (){var statearr_29491 = state_29486;
(statearr_29491[(7)] = inst_29468);

return statearr_29491;
})();
var statearr_29492_29519 = state_29486__$1;
(statearr_29492_29519[(2)] = inst_29471);

(statearr_29492_29519[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (13))){
var inst_29430 = (state_29486[(8)]);
var inst_29443 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_29444 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_29443);
var inst_29445 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_29430);
var inst_29446 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_29445);
var inst_29447 = cljs.core.set(inst_29446);
var inst_29448 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_29444);
var inst_29449 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_29448);
var inst_29450 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29447,inst_29449);
var inst_29451 = (function (){var all_wd = inst_29430;
var optional = inst_29444;
var all_wd_vars = inst_29447;
var all_vars = inst_29450;
return (function (p1__29417_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__29417_SHARP_) : all_vars.call(null,p1__29417_SHARP_));
});
})();
var inst_29452 = cljs.core.keys(vars);
var inst_29453 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_29451,inst_29452);
var inst_29454 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_29453);
var inst_29455 = cljs.core.set(inst_29454);
var inst_29456 = (function (){var all_wd = inst_29430;
var optional = inst_29444;
var all_wd_vars = inst_29447;
var all_vars = inst_29450;
var intersecting_vars = inst_29455;
return (function (p1__29418_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__29418_SHARP_);
});
})();
var inst_29457 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_29456,inst_29430);
var inst_29458 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_29457);
var inst_29459 = fluree.db.query.analytical.select_from_tuples(inst_29458,res);
var inst_29460 = fluree.db.query.analytical.replace_vars_wikidata(inst_29430,inst_29455,vars);
var inst_29461 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_29455,inst_29450);
var inst_29462 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_29460,inst_29458,inst_29459,inst_29461,inst_29444);
var state_29486__$1 = state_29486;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29486__$1,(15),inst_29462);
} else {
if((state_val_29487 === (6))){
var inst_29431 = (state_29486[(9)]);
var inst_29429 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_29430 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_29429);
var inst_29431__$1 = optional_QMARK_;
var state_29486__$1 = (function (){var statearr_29493 = state_29486;
(statearr_29493[(9)] = inst_29431__$1);

(statearr_29493[(8)] = inst_29430);

return statearr_29493;
})();
if(cljs.core.truth_(inst_29431__$1)){
var statearr_29494_29520 = state_29486__$1;
(statearr_29494_29520[(1)] = (9));

} else {
var statearr_29495_29521 = state_29486__$1;
(statearr_29495_29521[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (3))){
var inst_29484 = (state_29486[(2)]);
var state_29486__$1 = state_29486;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29486__$1,inst_29484);
} else {
if((state_val_29487 === (12))){
var inst_29439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29440 = [null,r];
var inst_29441 = (new cljs.core.PersistentVector(null,2,(5),inst_29439,inst_29440,null));
var state_29486__$1 = state_29486;
var statearr_29496_29522 = state_29486__$1;
(statearr_29496_29522[(2)] = inst_29441);

(statearr_29496_29522[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (2))){
var _ = (function (){var statearr_29497 = state_29486;
(statearr_29497[(4)] = cljs.core.cons((5),(state_29486[(4)])));

return statearr_29497;
})();
var inst_29427 = (r == null);
var state_29486__$1 = state_29486;
if(cljs.core.truth_(inst_29427)){
var statearr_29498_29523 = state_29486__$1;
(statearr_29498_29523[(1)] = (6));

} else {
var statearr_29499_29524 = state_29486__$1;
(statearr_29499_29524[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (11))){
var inst_29437 = (state_29486[(2)]);
var state_29486__$1 = state_29486;
if(cljs.core.truth_(inst_29437)){
var statearr_29501_29525 = state_29486__$1;
(statearr_29501_29525[(1)] = (12));

} else {
var statearr_29502_29526 = state_29486__$1;
(statearr_29502_29526[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (9))){
var inst_29430 = (state_29486[(8)]);
var inst_29433 = cljs.core.empty_QMARK_(inst_29430);
var inst_29434 = (!(inst_29433));
var state_29486__$1 = state_29486;
var statearr_29503_29527 = state_29486__$1;
(statearr_29503_29527[(2)] = inst_29434);

(statearr_29503_29527[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (5))){
var _ = (function (){var statearr_29504 = state_29486;
(statearr_29504[(4)] = cljs.core.rest((state_29486[(4)])));

return statearr_29504;
})();
var state_29486__$1 = state_29486;
var ex29500 = (state_29486__$1[(2)]);
var statearr_29505_29528 = state_29486__$1;
(statearr_29505_29528[(5)] = ex29500);


if((ex29500 instanceof Error)){
var statearr_29506_29529 = state_29486__$1;
(statearr_29506_29529[(1)] = (4));

(statearr_29506_29529[(5)] = null);

} else {
throw ex29500;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (14))){
var inst_29473 = (state_29486[(2)]);
var state_29486__$1 = state_29486;
var statearr_29507_29530 = state_29486__$1;
(statearr_29507_29530[(2)] = inst_29473);

(statearr_29507_29530[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (10))){
var inst_29431 = (state_29486[(9)]);
var state_29486__$1 = state_29486;
var statearr_29508_29531 = state_29486__$1;
(statearr_29508_29531[(2)] = inst_29431);

(statearr_29508_29531[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29487 === (8))){
var inst_29481 = (state_29486[(2)]);
var _ = (function (){var statearr_29509 = state_29486;
(statearr_29509[(4)] = cljs.core.rest((state_29486[(4)])));

return statearr_29509;
})();
var state_29486__$1 = state_29486;
var statearr_29510_29532 = state_29486__$1;
(statearr_29510_29532[(2)] = inst_29481);

(statearr_29510_29532[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto____0 = (function (){
var statearr_29511 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29511[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto__);

(statearr_29511[(1)] = (1));

return statearr_29511;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto____1 = (function (state_29486){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_29486);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e29512){var ex__10801__auto__ = e29512;
var statearr_29513_29533 = state_29486;
(statearr_29513_29533[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_29486[(4)]))){
var statearr_29514_29534 = state_29486;
(statearr_29514_29534[(1)] = cljs.core.first((state_29486[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__29535 = state_29486;
state_29486 = G__29535;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto__ = function(state_29486){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto____1.call(this,state_29486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_29515 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_29515[(6)] = c__10835__auto__);

return statearr_29515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__29537 = arguments.length;
switch (G__29537) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_29631){
var state_val_29632 = (state_29631[(1)]);
if((state_val_29632 === (7))){
var inst_29544 = (state_29631[(7)]);
var inst_29554 = clojure.string.starts_with_QMARK_(inst_29544,"$fdb");
var state_29631__$1 = state_29631;
if(inst_29554){
var statearr_29633_29682 = state_29631__$1;
(statearr_29633_29682[(1)] = (9));

} else {
var statearr_29634_29683 = state_29631__$1;
(statearr_29634_29683[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (20))){
var state_29631__$1 = state_29631;
var statearr_29635_29684 = state_29631__$1;
(statearr_29635_29684[(2)] = null);

(statearr_29635_29684[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (27))){
var inst_29594 = (state_29631[(8)]);
var state_29631__$1 = state_29631;
var statearr_29636_29685 = state_29631__$1;
(statearr_29636_29685[(2)] = inst_29594);

(statearr_29636_29685[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (1))){
var state_29631__$1 = state_29631;
var statearr_29637_29686 = state_29631__$1;
(statearr_29637_29686[(2)] = null);

(statearr_29637_29686[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (24))){
var inst_29617 = (state_29631[(2)]);
var state_29631__$1 = state_29631;
var statearr_29638_29687 = state_29631__$1;
(statearr_29638_29687[(2)] = inst_29617);

(statearr_29638_29687[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (4))){
var inst_29538 = (state_29631[(2)]);
var state_29631__$1 = state_29631;
var statearr_29639_29688 = state_29631__$1;
(statearr_29639_29688[(2)] = inst_29538);

(statearr_29639_29688[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (15))){
var inst_29561 = (state_29631[(9)]);
var inst_29567 = (state_29631[(2)]);
var inst_29568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29569 = cljs.core.PersistentVector.EMPTY;
var inst_29570 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_29571 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29569,inst_29570);
var inst_29572 = [inst_29561,inst_29571];
var inst_29573 = (new cljs.core.PersistentVector(null,2,(5),inst_29568,inst_29572,null));
var state_29631__$1 = (function (){var statearr_29640 = state_29631;
(statearr_29640[(10)] = inst_29567);

return statearr_29640;
})();
var statearr_29641_29689 = state_29631__$1;
(statearr_29641_29689[(2)] = inst_29573);

(statearr_29641_29689[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (21))){
var inst_29620 = (state_29631[(2)]);
var state_29631__$1 = state_29631;
var statearr_29642_29690 = state_29631__$1;
(statearr_29642_29690[(2)] = inst_29620);

(statearr_29642_29690[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (13))){
var inst_29561 = (state_29631[(9)]);
var inst_29564 = (function(){throw inst_29561})();
var state_29631__$1 = state_29631;
var statearr_29643_29691 = state_29631__$1;
(statearr_29643_29691[(2)] = inst_29564);

(statearr_29643_29691[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (22))){
var inst_29585 = (state_29631[(11)]);
var inst_29583 = (state_29631[(12)]);
var inst_29587 = fluree.db.query.analytical.parse_block_from_source(inst_29583);
var inst_29588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29589 = [cljs.core.cst$kw$sources,inst_29585];
var inst_29590 = (new cljs.core.PersistentVector(null,2,(5),inst_29588,inst_29589,null));
var inst_29591 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_29590);
var state_29631__$1 = (function (){var statearr_29644 = state_29631;
(statearr_29644[(13)] = inst_29587);

return statearr_29644;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29631__$1,(25),inst_29591);
} else {
if((state_val_29632 === (29))){
var inst_29598 = (state_29631[(2)]);
var inst_29599 = fluree.db.util.async.throw_err(inst_29598);
var state_29631__$1 = state_29631;
var statearr_29645_29692 = state_29631__$1;
(statearr_29645_29692[(2)] = inst_29599);

(statearr_29645_29692[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (6))){
var inst_29547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29548 = cljs.core.PersistentVector.EMPTY;
var inst_29549 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_29550 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29548,inst_29549);
var inst_29551 = [db,inst_29550];
var inst_29552 = (new cljs.core.PersistentVector(null,2,(5),inst_29547,inst_29551,null));
var state_29631__$1 = state_29631;
var statearr_29646_29693 = state_29631__$1;
(statearr_29646_29693[(2)] = inst_29552);

(statearr_29646_29693[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (28))){
var inst_29602 = (state_29631[(2)]);
var inst_29603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29604 = cljs.core.PersistentVector.EMPTY;
var inst_29605 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_29606 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29604,inst_29605);
var inst_29607 = [inst_29602,inst_29606];
var inst_29608 = (new cljs.core.PersistentVector(null,2,(5),inst_29603,inst_29607,null));
var state_29631__$1 = state_29631;
var statearr_29647_29694 = state_29631__$1;
(statearr_29647_29694[(2)] = inst_29608);

(statearr_29647_29694[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (25))){
var inst_29587 = (state_29631[(13)]);
var inst_29593 = (state_29631[(2)]);
var inst_29594 = fluree.db.util.async.throw_err(inst_29593);
var state_29631__$1 = (function (){var statearr_29648 = state_29631;
(statearr_29648[(8)] = inst_29594);

return statearr_29648;
})();
if(cljs.core.truth_(inst_29587)){
var statearr_29649_29695 = state_29631__$1;
(statearr_29649_29695[(1)] = (26));

} else {
var statearr_29650_29696 = state_29631__$1;
(statearr_29650_29696[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (17))){
var state_29631__$1 = state_29631;
var statearr_29651_29697 = state_29631__$1;
(statearr_29651_29697[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (3))){
var inst_29629 = (state_29631[(2)]);
var state_29631__$1 = state_29631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29631__$1,inst_29629);
} else {
if((state_val_29632 === (12))){
var inst_29561 = (state_29631[(9)]);
var inst_29560 = (state_29631[(2)]);
var inst_29561__$1 = fluree.db.util.async.throw_err(inst_29560);
var inst_29562 = fluree.db.util.core.exception_QMARK_(inst_29561__$1);
var state_29631__$1 = (function (){var statearr_29653 = state_29631;
(statearr_29653[(9)] = inst_29561__$1);

return statearr_29653;
})();
if(inst_29562){
var statearr_29654_29698 = state_29631__$1;
(statearr_29654_29698[(1)] = (13));

} else {
var statearr_29655_29699 = state_29631__$1;
(statearr_29655_29699[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (2))){
var inst_29544 = (state_29631[(7)]);
var _ = (function (){var statearr_29656 = state_29631;
(statearr_29656[(4)] = cljs.core.cons((5),(state_29631[(4)])));

return statearr_29656;
})();
var inst_29544__$1 = cljs.core.first(clause);
var inst_29545 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_29544__$1);
var state_29631__$1 = (function (){var statearr_29657 = state_29631;
(statearr_29657[(7)] = inst_29544__$1);

return statearr_29657;
})();
if(inst_29545){
var statearr_29658_29700 = state_29631__$1;
(statearr_29658_29700[(1)] = (6));

} else {
var statearr_29659_29701 = state_29631__$1;
(statearr_29659_29701[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (23))){
var inst_29544 = (state_29631[(7)]);
var inst_29610 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29544)," is not supported in Fluree"].join('');
var inst_29611 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29612 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_29613 = cljs.core.PersistentHashMap.fromArrays(inst_29611,inst_29612);
var inst_29614 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29610,inst_29613);
var inst_29615 = (function(){throw inst_29614})();
var state_29631__$1 = state_29631;
var statearr_29660_29702 = state_29631__$1;
(statearr_29660_29702[(2)] = inst_29615);

(statearr_29660_29702[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (19))){
var inst_29585 = (state_29631[(11)]);
var inst_29544 = (state_29631[(7)]);
var inst_29582 = fluree.db.query.analytical.isolate_source_name(inst_29544);
var inst_29583 = fluree.db.query.analytical.isolate_source_block(inst_29544);
var inst_29584 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_29582);
var inst_29585__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_29584);
var state_29631__$1 = (function (){var statearr_29661 = state_29631;
(statearr_29661[(11)] = inst_29585__$1);

(statearr_29661[(12)] = inst_29583);

return statearr_29661;
})();
if(cljs.core.truth_(inst_29585__$1)){
var statearr_29662_29703 = state_29631__$1;
(statearr_29662_29703[(1)] = (22));

} else {
var statearr_29663_29704 = state_29631__$1;
(statearr_29663_29704[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (11))){
var inst_29624 = (state_29631[(2)]);
var state_29631__$1 = state_29631;
var statearr_29665_29705 = state_29631__$1;
(statearr_29665_29705[(2)] = inst_29624);

(statearr_29665_29705[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (9))){
var inst_29544 = (state_29631[(7)]);
var inst_29556 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_29544,(4));
var inst_29557 = fluree.db.query.analytical.parse_block_from_source(inst_29556);
var inst_29558 = fluree.db.time_travel.as_of_block(db,inst_29557);
var state_29631__$1 = state_29631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29631__$1,(12),inst_29558);
} else {
if((state_val_29632 === (5))){
var _ = (function (){var statearr_29666 = state_29631;
(statearr_29666[(4)] = cljs.core.rest((state_29631[(4)])));

return statearr_29666;
})();
var state_29631__$1 = state_29631;
var ex29664 = (state_29631__$1[(2)]);
var statearr_29667_29706 = state_29631__$1;
(statearr_29667_29706[(5)] = ex29664);


if((ex29664 instanceof Error)){
var statearr_29668_29707 = state_29631__$1;
(statearr_29668_29707[(1)] = (4));

(statearr_29668_29707[(5)] = null);

} else {
throw ex29664;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (14))){
var state_29631__$1 = state_29631;
var statearr_29669_29708 = state_29631__$1;
(statearr_29669_29708[(2)] = null);

(statearr_29669_29708[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (26))){
var inst_29587 = (state_29631[(13)]);
var inst_29594 = (state_29631[(8)]);
var inst_29596 = fluree.db.time_travel.as_of_block(inst_29594,inst_29587);
var state_29631__$1 = state_29631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29631__$1,(29),inst_29596);
} else {
if((state_val_29632 === (16))){
var inst_29577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29578 = ["$wd",clause];
var inst_29579 = (new cljs.core.PersistentVector(null,2,(5),inst_29577,inst_29578,null));
var state_29631__$1 = state_29631;
var statearr_29670_29709 = state_29631__$1;
(statearr_29670_29709[(2)] = inst_29579);

(statearr_29670_29709[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (10))){
var inst_29544 = (state_29631[(7)]);
var inst_29575 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_29544);
var state_29631__$1 = state_29631;
if(inst_29575){
var statearr_29671_29710 = state_29631__$1;
(statearr_29671_29710[(1)] = (16));

} else {
var statearr_29672_29711 = state_29631__$1;
(statearr_29672_29711[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (18))){
var inst_29622 = (state_29631[(2)]);
var state_29631__$1 = state_29631;
var statearr_29673_29712 = state_29631__$1;
(statearr_29673_29712[(2)] = inst_29622);

(statearr_29673_29712[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29632 === (8))){
var inst_29626 = (state_29631[(2)]);
var _ = (function (){var statearr_29674 = state_29631;
(statearr_29674[(4)] = cljs.core.rest((state_29631[(4)])));

return statearr_29674;
})();
var state_29631__$1 = state_29631;
var statearr_29675_29713 = state_29631__$1;
(statearr_29675_29713[(2)] = inst_29626);

(statearr_29675_29713[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__10798__auto__ = null;
var fluree$db$query$analytical$state_machine__10798__auto____0 = (function (){
var statearr_29676 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29676[(0)] = fluree$db$query$analytical$state_machine__10798__auto__);

(statearr_29676[(1)] = (1));

return statearr_29676;
});
var fluree$db$query$analytical$state_machine__10798__auto____1 = (function (state_29631){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_29631);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e29677){var ex__10801__auto__ = e29677;
var statearr_29678_29714 = state_29631;
(statearr_29678_29714[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_29631[(4)]))){
var statearr_29679_29715 = state_29631;
(statearr_29679_29715[(1)] = cljs.core.first((state_29631[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__29716 = state_29631;
state_29631 = G__29716;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__10798__auto__ = function(state_29631){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__10798__auto____1.call(this,state_29631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__10798__auto____0;
fluree$db$query$analytical$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__10798__auto____1;
return fluree$db$query$analytical$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_29680 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_29680[(6)] = c__10835__auto__);

return statearr_29680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__29717){
var vec__29718 = p__29717;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29718,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29718,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29721_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__29721_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__29725 = subjects;
var vec__29726 = G__29725;
var seq__29727 = cljs.core.seq(vec__29726);
var first__29728 = cljs.core.first(seq__29727);
var seq__29727__$1 = cljs.core.next(seq__29727);
var subject = first__29728;
var r = seq__29727__$1;
var acc = expanded_map;
var G__29725__$1 = G__29725;
var acc__$1 = acc;
while(true){
var vec__29732 = G__29725__$1;
var seq__29733 = cljs.core.seq(vec__29732);
var first__29734 = cljs.core.first(seq__29733);
var seq__29733__$1 = cljs.core.next(seq__29733);
var subject__$1 = first__29734;
var r__$1 = seq__29733__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__29735 = r__$1;
var G__29736 = acc__$2;
G__29725__$1 = G__29735;
acc__$1 = G__29736;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__29725__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__29732,seq__29733,first__29734,seq__29733__$1,subject__$1,r__$1,acc__$2,G__29725,vec__29726,seq__29727,first__29728,seq__29727__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4223__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__29725__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__29732,seq__29733,first__29734,seq__29733__$1,subject__$1,r__$1,acc__$2,G__29725,vec__29726,seq__29727,first__29728,seq__29727__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__29725__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__29732,seq__29733,first__29734,seq__29733__$1,subject__$1,r__$1,acc__$2,G__29725,vec__29726,seq__29727,first__29728,seq__29727__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__29725__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__29732,seq__29733,first__29734,seq__29733__$1,subject__$1,r__$1,acc__$2,G__29725,vec__29726,seq__29727,first__29728,seq__29727__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__29725__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__29732,seq__29733,first__29734,seq__29733__$1,subject__$1,r__$1,acc__$2,G__29725,vec__29726,seq__29727,first__29728,seq__29727__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__29725__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__29732,seq__29733,first__29734,seq__29733__$1,subject__$1,r__$1,acc__$2,G__29725,vec__29726,seq__29727,first__29728,seq__29727__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__29737 = r__$1;
var G__29738 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__29725__$1 = G__29737;
acc__$1 = G__29738;
continue;
} else {
var G__29739 = subjects;
var G__29740 = acc_STAR_;
G__29725__$1 = G__29739;
acc__$1 = G__29740;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29741_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__29741_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_29832){
var state_val_29833 = (state_29832[(1)]);
if((state_val_29833 === (7))){
var state_29832__$1 = state_29832;
var statearr_29834_29880 = state_29832__$1;
(statearr_29834_29880[(2)] = (100));

(statearr_29834_29880[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (20))){
var inst_29781 = (state_29832[(7)]);
var state_29832__$1 = state_29832;
var statearr_29835_29881 = state_29832__$1;
(statearr_29835_29881[(2)] = inst_29781);

(statearr_29835_29881[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (1))){
var state_29832__$1 = state_29832;
var statearr_29836_29882 = state_29832__$1;
(statearr_29836_29882[(2)] = null);

(statearr_29836_29882[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (24))){
var inst_29820 = (state_29832[(8)]);
var inst_29818 = (state_29832[(9)]);
var inst_29819 = (state_29832[(10)]);
var inst_29753 = (state_29832[(11)]);
var inst_29823 = (function (){var max_depth = inst_29753;
var recur_map__$1 = inst_29819;
var subjects = inst_29818;
var tuples = inst_29820;
return (function (p1__29742_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__29742_SHARP_)],null));
});
})();
var inst_29824 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_29823,inst_29820);
var inst_29825 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_29824);
var state_29832__$1 = state_29832;
var statearr_29837_29883 = state_29832__$1;
(statearr_29837_29883[(2)] = inst_29825);

(statearr_29837_29883[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (4))){
var inst_29743 = (state_29832[(2)]);
var state_29832__$1 = state_29832;
var statearr_29838_29884 = state_29832__$1;
(statearr_29838_29884[(2)] = inst_29743);

(statearr_29838_29884[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (15))){
var inst_29766 = (state_29832[(12)]);
var inst_29777 = cljs.core.PersistentVector.EMPTY;
var inst_29778 = cljs.core.seq(inst_29766);
var inst_29779 = cljs.core.first(inst_29778);
var inst_29780 = cljs.core.next(inst_29778);
var inst_29781 = inst_29777;
var inst_29782 = inst_29766;
var state_29832__$1 = (function (){var statearr_29839 = state_29832;
(statearr_29839[(13)] = inst_29779);

(statearr_29839[(14)] = inst_29782);

(statearr_29839[(15)] = inst_29780);

(statearr_29839[(7)] = inst_29781);

return statearr_29839;
})();
var statearr_29840_29885 = state_29832__$1;
(statearr_29840_29885[(2)] = null);

(statearr_29840_29885[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (21))){
var inst_29802 = (state_29832[(2)]);
var state_29832__$1 = state_29832;
var statearr_29841_29886 = state_29832__$1;
(statearr_29841_29886[(2)] = inst_29802);

(statearr_29841_29886[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (13))){
var inst_29815 = (state_29832[(2)]);
var state_29832__$1 = state_29832;
var statearr_29842_29887 = state_29832__$1;
(statearr_29842_29887[(2)] = inst_29815);

(statearr_29842_29887[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (22))){
var inst_29781 = (state_29832[(7)]);
var inst_29789 = (state_29832[(16)]);
var inst_29796 = (state_29832[(2)]);
var inst_29797 = fluree.db.util.async.throw_err(inst_29796);
var inst_29798 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29781,inst_29797);
var inst_29781__$1 = inst_29798;
var inst_29782 = inst_29789;
var state_29832__$1 = (function (){var statearr_29843 = state_29832;
(statearr_29843[(14)] = inst_29782);

(statearr_29843[(7)] = inst_29781__$1);

return statearr_29843;
})();
var statearr_29844_29888 = state_29832__$1;
(statearr_29844_29888[(2)] = null);

(statearr_29844_29888[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (6))){
var inst_29749 = (state_29832[(17)]);
var state_29832__$1 = state_29832;
var statearr_29845_29889 = state_29832__$1;
(statearr_29845_29889[(2)] = inst_29749);

(statearr_29845_29889[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (25))){
var inst_29827 = (state_29832[(2)]);
var _ = (function (){var statearr_29846 = state_29832;
(statearr_29846[(4)] = cljs.core.rest((state_29832[(4)])));

return statearr_29846;
})();
var state_29832__$1 = state_29832;
var statearr_29847_29890 = state_29832__$1;
(statearr_29847_29890[(2)] = inst_29827);

(statearr_29847_29890[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (17))){
var inst_29782 = (state_29832[(14)]);
var inst_29788 = (state_29832[(18)]);
var inst_29787 = cljs.core.seq(inst_29782);
var inst_29788__$1 = cljs.core.first(inst_29787);
var inst_29789 = cljs.core.next(inst_29787);
var state_29832__$1 = (function (){var statearr_29848 = state_29832;
(statearr_29848[(18)] = inst_29788__$1);

(statearr_29848[(16)] = inst_29789);

return statearr_29848;
})();
if(cljs.core.truth_(inst_29788__$1)){
var statearr_29849_29891 = state_29832__$1;
(statearr_29849_29891[(1)] = (19));

} else {
var statearr_29850_29892 = state_29832__$1;
(statearr_29850_29892[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (3))){
var inst_29830 = (state_29832[(2)]);
var state_29832__$1 = state_29832;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29832__$1,inst_29830);
} else {
if((state_val_29833 === (12))){
var inst_29755 = (state_29832[(19)]);
var inst_29766 = (state_29832[(12)]);
var inst_29761 = cljs.core.vals(inst_29755);
var inst_29762 = cljs.core.flatten(inst_29761);
var inst_29763 = cljs.core.set(inst_29762);
var inst_29764 = cljs.core.keys(inst_29755);
var inst_29765 = cljs.core.set(inst_29764);
var inst_29766__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_29763,inst_29765);
var inst_29767 = cljs.core.empty_QMARK_(inst_29766__$1);
var state_29832__$1 = (function (){var statearr_29851 = state_29832;
(statearr_29851[(12)] = inst_29766__$1);

return statearr_29851;
})();
if(inst_29767){
var statearr_29852_29893 = state_29832__$1;
(statearr_29852_29893[(1)] = (14));

} else {
var statearr_29853_29894 = state_29832__$1;
(statearr_29853_29894[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (2))){
var inst_29749 = (state_29832[(17)]);
var _ = (function (){var statearr_29854 = state_29832;
(statearr_29854[(4)] = cljs.core.cons((5),(state_29832[(4)])));

return statearr_29854;
})();
var inst_29749__$1 = depth;
var state_29832__$1 = (function (){var statearr_29855 = state_29832;
(statearr_29855[(17)] = inst_29749__$1);

return statearr_29855;
})();
if(cljs.core.truth_(inst_29749__$1)){
var statearr_29856_29895 = state_29832__$1;
(statearr_29856_29895[(1)] = (6));

} else {
var statearr_29857_29896 = state_29832__$1;
(statearr_29857_29896[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (23))){
var inst_29820 = (state_29832[(8)]);
var state_29832__$1 = state_29832;
var statearr_29858_29897 = state_29832__$1;
(statearr_29858_29897[(2)] = inst_29820);

(statearr_29858_29897[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (19))){
var inst_29788 = (state_29832[(18)]);
var inst_29791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29792 = [inst_29788,predicate];
var inst_29793 = (new cljs.core.PersistentVector(null,2,(5),inst_29791,inst_29792,null));
var inst_29794 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_29793);
var state_29832__$1 = state_29832;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29832__$1,(22),inst_29794);
} else {
if((state_val_29833 === (11))){
var inst_29755 = (state_29832[(19)]);
var state_29832__$1 = state_29832;
var statearr_29860_29898 = state_29832__$1;
(statearr_29860_29898[(2)] = inst_29755);

(statearr_29860_29898[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (9))){
var inst_29756 = (state_29832[(20)]);
var inst_29753 = (state_29832[(11)]);
var inst_29758 = (inst_29756 >= inst_29753);
var state_29832__$1 = state_29832;
if(cljs.core.truth_(inst_29758)){
var statearr_29861_29899 = state_29832__$1;
(statearr_29861_29899[(1)] = (11));

} else {
var statearr_29862_29900 = state_29832__$1;
(statearr_29862_29900[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (5))){
var _ = (function (){var statearr_29863 = state_29832;
(statearr_29863[(4)] = cljs.core.rest((state_29832[(4)])));

return statearr_29863;
})();
var state_29832__$1 = state_29832;
var ex29859 = (state_29832__$1[(2)]);
var statearr_29864_29901 = state_29832__$1;
(statearr_29864_29901[(5)] = ex29859);


if((ex29859 instanceof Error)){
var statearr_29865_29902 = state_29832__$1;
(statearr_29865_29902[(1)] = (4));

(statearr_29865_29902[(5)] = null);

} else {
throw ex29859;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (14))){
var inst_29755 = (state_29832[(19)]);
var state_29832__$1 = state_29832;
var statearr_29866_29903 = state_29832__$1;
(statearr_29866_29903[(2)] = inst_29755);

(statearr_29866_29903[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (16))){
var inst_29813 = (state_29832[(2)]);
var state_29832__$1 = state_29832;
var statearr_29867_29904 = state_29832__$1;
(statearr_29867_29904[(2)] = inst_29813);

(statearr_29867_29904[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (10))){
var inst_29818 = (state_29832[(9)]);
var inst_29819 = (state_29832[(10)]);
var inst_29817 = (state_29832[(2)]);
var inst_29818__$1 = cljs.core.keys(inst_29817);
var inst_29819__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_29818__$1,inst_29817);
var inst_29820 = fluree.db.query.analytical.recur_map__GT_tuples(inst_29818__$1,inst_29819__$1);
var state_29832__$1 = (function (){var statearr_29868 = state_29832;
(statearr_29868[(8)] = inst_29820);

(statearr_29868[(9)] = inst_29818__$1);

(statearr_29868[(10)] = inst_29819__$1);

return statearr_29868;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_29869_29905 = state_29832__$1;
(statearr_29869_29905[(1)] = (23));

} else {
var statearr_29870_29906 = state_29832__$1;
(statearr_29870_29906[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (18))){
var inst_29755 = (state_29832[(19)]);
var inst_29756 = (state_29832[(20)]);
var inst_29804 = (state_29832[(2)]);
var inst_29805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29806 = [(0),(2)];
var inst_29807 = (new cljs.core.PersistentVector(null,2,(5),inst_29805,inst_29806,null));
var inst_29808 = fluree.db.query.analytical.get_ns_arrays(inst_29807,inst_29804);
var inst_29809 = fluree.db.query.analytical.tuples__GT_map(inst_29755,inst_29808);
var inst_29810 = (inst_29756 + (1));
var inst_29755__$1 = inst_29809;
var inst_29756__$1 = inst_29810;
var state_29832__$1 = (function (){var statearr_29871 = state_29832;
(statearr_29871[(19)] = inst_29755__$1);

(statearr_29871[(20)] = inst_29756__$1);

return statearr_29871;
})();
var statearr_29872_29907 = state_29832__$1;
(statearr_29872_29907[(2)] = null);

(statearr_29872_29907[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29833 === (8))){
var inst_29753 = (state_29832[(2)]);
var inst_29754 = recur_map;
var inst_29755 = inst_29754;
var inst_29756 = (1);
var state_29832__$1 = (function (){var statearr_29873 = state_29832;
(statearr_29873[(19)] = inst_29755);

(statearr_29873[(20)] = inst_29756);

(statearr_29873[(11)] = inst_29753);

return statearr_29873;
})();
var statearr_29874_29908 = state_29832__$1;
(statearr_29874_29908[(2)] = null);

(statearr_29874_29908[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto____0 = (function (){
var statearr_29875 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29875[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto__);

(statearr_29875[(1)] = (1));

return statearr_29875;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto____1 = (function (state_29832){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_29832);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e29876){var ex__10801__auto__ = e29876;
var statearr_29877_29909 = state_29832;
(statearr_29877_29909[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_29832[(4)]))){
var statearr_29878_29910 = state_29832;
(statearr_29878_29910[(1)] = cljs.core.first((state_29832[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__29911 = state_29832;
state_29832 = G__29911;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto__ = function(state_29832){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto____1.call(this,state_29832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_29879 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_29879[(6)] = c__10835__auto__);

return statearr_29879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__29912,clause,fuel,max_fuel){
var map__29913 = p__29912;
var map__29913__$1 = cljs.core.__destructure_map(map__29913);
var res = map__29913__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29913__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29913__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29913__$1,cljs.core.cst$kw$vars);
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_30024){
var state_val_30025 = (state_30024[(1)]);
if((state_val_30025 === (7))){
var inst_29930 = (state_30024[(7)]);
var state_30024__$1 = state_30024;
var statearr_30026_30079 = state_30024__$1;
(statearr_30026_30079[(2)] = inst_29930);

(statearr_30026_30079[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (20))){
var inst_29958 = (state_30024[(8)]);
var inst_29989 = typeof inst_29958 === 'number';
var state_30024__$1 = state_30024;
if(cljs.core.truth_(inst_29989)){
var statearr_30027_30080 = state_30024__$1;
(statearr_30027_30080[(1)] = (22));

} else {
var statearr_30028_30081 = state_30024__$1;
(statearr_30028_30081[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (27))){
var inst_30004 = (state_30024[(2)]);
var state_30024__$1 = state_30024;
var statearr_30029_30082 = state_30024__$1;
(statearr_30029_30082[(2)] = inst_30004);

(statearr_30029_30082[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (1))){
var state_30024__$1 = state_30024;
var statearr_30030_30083 = state_30024__$1;
(statearr_30030_30083[(2)] = null);

(statearr_30030_30083[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (24))){
var inst_30006 = (state_30024[(2)]);
var state_30024__$1 = state_30024;
var statearr_30031_30084 = state_30024__$1;
(statearr_30031_30084[(2)] = inst_30006);

(statearr_30031_30084[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (4))){
var inst_29914 = (state_30024[(2)]);
var state_30024__$1 = state_30024;
var statearr_30032_30085 = state_30024__$1;
(statearr_30032_30085[(2)] = inst_29914);

(statearr_30032_30085[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (15))){
var inst_29972 = (state_30024[(2)]);
var inst_29973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_29974 = fluree.db.query.analytical.variable_QMARK_(inst_29973);
var state_30024__$1 = (function (){var statearr_30033 = state_30024;
(statearr_30033[(9)] = inst_29972);

return statearr_30033;
})();
if(cljs.core.truth_(inst_29974)){
var statearr_30034_30086 = state_30024__$1;
(statearr_30034_30086[(1)] = (16));

} else {
var statearr_30035_30087 = state_30024__$1;
(statearr_30035_30087[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (21))){
var inst_29960 = (state_30024[(10)]);
var inst_29931 = (state_30024[(11)]);
var inst_29961 = (state_30024[(12)]);
var inst_30008 = (state_30024[(2)]);
var inst_30009 = fluree.db.query.analytical.tuples__GT_recur(db,inst_29961,inst_30008,inst_29931,inst_29960);
var state_30024__$1 = state_30024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30024__$1,(28),inst_30009);
} else {
if((state_val_30025 === (13))){
var inst_29940 = (state_30024[(13)]);
var inst_29964 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29940)].join('');
var inst_29965 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29966 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_29967 = cljs.core.PersistentHashMap.fromArrays(inst_29965,inst_29966);
var inst_29968 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29964,inst_29967);
var inst_29969 = (function(){throw inst_29968})();
var state_30024__$1 = state_30024;
var statearr_30036_30088 = state_30024__$1;
(statearr_30036_30088[(2)] = inst_29969);

(statearr_30036_30088[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (22))){
var inst_29956 = (state_30024[(14)]);
var inst_29958 = (state_30024[(8)]);
var inst_29991 = cljs.core.PersistentHashMap.EMPTY;
var inst_29992 = cljs.core.flatten(inst_29956);
var inst_29993 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29991,inst_29958,inst_29992);
var state_30024__$1 = state_30024;
var statearr_30037_30089 = state_30024__$1;
(statearr_30037_30089[(2)] = inst_29993);

(statearr_30037_30089[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (6))){
var inst_29942 = (state_30024[(15)]);
var state_30024__$1 = state_30024;
var statearr_30038_30090 = state_30024__$1;
(statearr_30038_30090[(2)] = inst_29942);

(statearr_30038_30090[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (28))){
var inst_30011 = (state_30024[(2)]);
var inst_30012 = fluree.db.util.async.throw_err(inst_30011);
var state_30024__$1 = state_30024;
var statearr_30039_30091 = state_30024__$1;
(statearr_30039_30091[(2)] = inst_30012);

(statearr_30039_30091[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (25))){
var inst_29956 = (state_30024[(14)]);
var inst_29952 = (state_30024[(16)]);
var inst_29997 = cljs.core.PersistentHashMap.EMPTY;
var inst_29998 = cljs.core.first(inst_29952);
var inst_29999 = cljs.core.first(inst_29998);
var inst_30000 = cljs.core.flatten(inst_29956);
var inst_30001 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29997,inst_29999,inst_30000);
var state_30024__$1 = state_30024;
var statearr_30040_30092 = state_30024__$1;
(statearr_30040_30092[(2)] = inst_30001);

(statearr_30040_30092[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (17))){
var inst_29940 = (state_30024[(13)]);
var inst_29977 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29940)].join('');
var inst_29978 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29979 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_29980 = cljs.core.PersistentHashMap.fromArrays(inst_29978,inst_29979);
var inst_29981 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29977,inst_29980);
var inst_29982 = (function(){throw inst_29981})();
var state_30024__$1 = state_30024;
var statearr_30041_30093 = state_30024__$1;
(statearr_30041_30093[(2)] = inst_29982);

(statearr_30041_30093[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (3))){
var inst_30022 = (state_30024[(2)]);
var state_30024__$1 = state_30024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30024__$1,inst_30022);
} else {
if((state_val_30025 === (12))){
var inst_29927 = (state_30024[(17)]);
var inst_30015 = (state_30024[(2)]);
var inst_30016 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_30017 = cljs.core.keys(inst_29927);
var inst_30018 = [inst_30017,vars,inst_30015];
var inst_30019 = cljs.core.PersistentHashMap.fromArrays(inst_30016,inst_30018);
var _ = (function (){var statearr_30042 = state_30024;
(statearr_30042[(4)] = cljs.core.rest((state_30024[(4)])));

return statearr_30042;
})();
var state_30024__$1 = state_30024;
var statearr_30043_30094 = state_30024__$1;
(statearr_30043_30094[(2)] = inst_30019);

(statearr_30043_30094[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (2))){
var inst_29927 = (state_30024[(17)]);
var inst_29930 = (state_30024[(7)]);
var inst_29942 = (state_30024[(15)]);
var inst_29931 = (state_30024[(11)]);
var _ = (function (){var statearr_30044 = state_30024;
(statearr_30044[(4)] = cljs.core.cons((5),(state_30024[(4)])));

return statearr_30044;
})();
var inst_29924 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_29925 = cljs.core.__destructure_map(inst_29924);
var inst_29926 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29925,cljs.core.cst$kw$search);
var inst_29927__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29925,cljs.core.cst$kw$rel);
var inst_29928 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29925,cljs.core.cst$kw$opts);
var inst_29929 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_29930__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_29928);
var inst_29931__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_29928);
var inst_29933 = (function (){var map__29920 = inst_29925;
var search = inst_29926;
var rel = inst_29927__$1;
var opts = inst_29928;
var common_keys = inst_29929;
var object_fn = inst_29930__$1;
var recur_depth = inst_29931__$1;
return (function (p__29932,common_key){
var vec__30045 = p__29932;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30045,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30045,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__30048 = cljs.core._EQ_;
var expr__30049 = idx_of;
if(cljs.core.truth_((pred__30048.cljs$core$IFn$_invoke$arity$2 ? pred__30048.cljs$core$IFn$_invoke$arity$2((0),expr__30049) : pred__30048.call(null,(0),expr__30049)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__30048.cljs$core$IFn$_invoke$arity$2 ? pred__30048.cljs$core$IFn$_invoke$arity$2((1),expr__30049) : pred__30048.call(null,(1),expr__30049)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__30048.cljs$core$IFn$_invoke$arity$2 ? pred__30048.cljs$core$IFn$_invoke$arity$2((2),expr__30049) : pred__30048.call(null,(2),expr__30049)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__30049)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4221__auto__ = (!(single_v_QMARK_));
if(and__4221__auto__){
var and__4221__auto____$1 = object_fn;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_29934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29935 = cljs.core.PersistentHashMap.EMPTY;
var inst_29936 = [inst_29935,inst_29926];
var inst_29937 = (new cljs.core.PersistentVector(null,2,(5),inst_29934,inst_29936,null));
var inst_29938 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_29933,inst_29937,inst_29929);
var inst_29939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29938,(0),null);
var inst_29940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29938,(1),null);
var inst_29941 = [cljs.core.cst$kw$object_DASH_fn];
var inst_29942__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_29939);
var state_30024__$1 = (function (){var statearr_30051 = state_30024;
(statearr_30051[(17)] = inst_29927__$1);

(statearr_30051[(7)] = inst_29930__$1);

(statearr_30051[(18)] = inst_29941);

(statearr_30051[(13)] = inst_29940);

(statearr_30051[(15)] = inst_29942__$1);

(statearr_30051[(11)] = inst_29931__$1);

return statearr_30051;
})();
if(cljs.core.truth_(inst_29942__$1)){
var statearr_30052_30095 = state_30024__$1;
(statearr_30052_30095[(1)] = (6));

} else {
var statearr_30053_30096 = state_30024__$1;
(statearr_30053_30096[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (23))){
var inst_29958 = (state_30024[(8)]);
var inst_29995 = cljs.core.coll_QMARK_(inst_29958);
var state_30024__$1 = state_30024;
if(inst_29995){
var statearr_30054_30097 = state_30024__$1;
(statearr_30054_30097[(1)] = (25));

} else {
var statearr_30055_30098 = state_30024__$1;
(statearr_30055_30098[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (19))){
var inst_29956 = (state_30024[(14)]);
var inst_29986 = cljs.core.PersistentHashMap.EMPTY;
var inst_29987 = fluree.db.query.analytical.tuples__GT_map(inst_29986,inst_29956);
var state_30024__$1 = state_30024;
var statearr_30056_30099 = state_30024__$1;
(statearr_30056_30099[(2)] = inst_29987);

(statearr_30056_30099[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (11))){
var inst_29956 = (state_30024[(14)]);
var state_30024__$1 = state_30024;
var statearr_30058_30100 = state_30024__$1;
(statearr_30058_30100[(2)] = inst_29956);

(statearr_30058_30100[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (9))){
var inst_29927 = (state_30024[(17)]);
var inst_29931 = (state_30024[(11)]);
var inst_29952 = (state_30024[(16)]);
var inst_29951 = (state_30024[(2)]);
var inst_29952__$1 = fluree.db.util.async.throw_err(inst_29951);
var inst_29953 = cljs.core.count(inst_29952__$1);
var inst_29954 = fluree.db.query.analytical.add_fuel(inst_29953,fuel,max_fuel);
var inst_29955 = cljs.core.vals(inst_29927);
var inst_29956 = fluree.db.query.analytical.get_ns_arrays(inst_29955,inst_29952__$1);
var state_30024__$1 = (function (){var statearr_30059 = state_30024;
(statearr_30059[(14)] = inst_29956);

(statearr_30059[(19)] = inst_29954);

(statearr_30059[(16)] = inst_29952__$1);

return statearr_30059;
})();
if(cljs.core.truth_(inst_29931)){
var statearr_30060_30101 = state_30024__$1;
(statearr_30060_30101[(1)] = (10));

} else {
var statearr_30061_30102 = state_30024__$1;
(statearr_30061_30102[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (5))){
var _ = (function (){var statearr_30062 = state_30024;
(statearr_30062[(4)] = cljs.core.rest((state_30024[(4)])));

return statearr_30062;
})();
var state_30024__$1 = state_30024;
var ex30057 = (state_30024__$1[(2)]);
var statearr_30063_30103 = state_30024__$1;
(statearr_30063_30103[(5)] = ex30057);


if((ex30057 instanceof Error)){
var statearr_30064_30104 = state_30024__$1;
(statearr_30064_30104[(1)] = (4));

(statearr_30064_30104[(5)] = null);

} else {
throw ex30057;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (14))){
var state_30024__$1 = state_30024;
var statearr_30065_30105 = state_30024__$1;
(statearr_30065_30105[(2)] = null);

(statearr_30065_30105[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (26))){
var state_30024__$1 = state_30024;
var statearr_30066_30106 = state_30024__$1;
(statearr_30066_30106[(2)] = null);

(statearr_30066_30106[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (16))){
var state_30024__$1 = state_30024;
var statearr_30067_30107 = state_30024__$1;
(statearr_30067_30107[(2)] = null);

(statearr_30067_30107[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (10))){
var inst_29940 = (state_30024[(13)]);
var inst_29961 = (state_30024[(12)]);
var inst_29958 = cljs.core.first(inst_29940);
var inst_29959 = cljs.core.first(clause);
var inst_29960 = fluree.db.query.analytical.variable_QMARK_(inst_29959);
var inst_29961__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_29940,(1));
var inst_29962 = fluree.db.query.analytical.variable_QMARK_(inst_29961__$1);
var state_30024__$1 = (function (){var statearr_30068 = state_30024;
(statearr_30068[(10)] = inst_29960);

(statearr_30068[(8)] = inst_29958);

(statearr_30068[(12)] = inst_29961__$1);

return statearr_30068;
})();
if(cljs.core.truth_(inst_29962)){
var statearr_30069_30108 = state_30024__$1;
(statearr_30069_30108[(1)] = (13));

} else {
var statearr_30070_30109 = state_30024__$1;
(statearr_30070_30109[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (18))){
var inst_29960 = (state_30024[(10)]);
var inst_29984 = (state_30024[(2)]);
var state_30024__$1 = (function (){var statearr_30071 = state_30024;
(statearr_30071[(20)] = inst_29984);

return statearr_30071;
})();
if(cljs.core.truth_(inst_29960)){
var statearr_30072_30110 = state_30024__$1;
(statearr_30072_30110[(1)] = (19));

} else {
var statearr_30073_30111 = state_30024__$1;
(statearr_30073_30111[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30025 === (8))){
var inst_29941 = (state_30024[(18)]);
var inst_29940 = (state_30024[(13)]);
var inst_29946 = (state_30024[(2)]);
var inst_29947 = [inst_29946];
var inst_29948 = cljs.core.PersistentHashMap.fromArrays(inst_29941,inst_29947);
var inst_29949 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_29940,inst_29948);
var state_30024__$1 = state_30024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30024__$1,(9),inst_29949);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto____0 = (function (){
var statearr_30074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30074[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto__);

(statearr_30074[(1)] = (1));

return statearr_30074;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto____1 = (function (state_30024){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_30024);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e30075){var ex__10801__auto__ = e30075;
var statearr_30076_30112 = state_30024;
(statearr_30076_30112[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_30024[(4)]))){
var statearr_30077_30113 = state_30024;
(statearr_30077_30113[(1)] = cljs.core.first((state_30024[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__30114 = state_30024;
state_30024 = G__30114;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto__ = function(state_30024){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto____1.call(this,state_30024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_30078 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_30078[(6)] = c__10835__auto__);

return statearr_30078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__30115,res,clause){
var map__30116 = p__30115;
var map__30116__$1 = cljs.core.__destructure_map(map__30116);
var db = map__30116__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30116__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30116__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30116__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_30215){
var state_val_30216 = (state_30215[(1)]);
if((state_val_30216 === (7))){
var inst_30126 = (state_30215[(7)]);
var state_30215__$1 = state_30215;
var statearr_30217_30257 = state_30215__$1;
(statearr_30217_30257[(2)] = inst_30126);

(statearr_30217_30257[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (20))){
var inst_30206 = (state_30215[(2)]);
var state_30215__$1 = state_30215;
var statearr_30218_30258 = state_30215__$1;
(statearr_30218_30258[(2)] = inst_30206);

(statearr_30218_30258[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (1))){
var state_30215__$1 = state_30215;
var statearr_30219_30259 = state_30215__$1;
(statearr_30219_30259[(2)] = null);

(statearr_30219_30259[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (24))){
var inst_30185 = (state_30215[(2)]);
var inst_30186 = fluree.db.util.async.throw_err(inst_30185);
var state_30215__$1 = state_30215;
var statearr_30220_30260 = state_30215__$1;
(statearr_30220_30260[(2)] = inst_30186);

(statearr_30220_30260[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (4))){
var inst_30119 = (state_30215[(2)]);
var state_30215__$1 = state_30215;
var statearr_30221_30261 = state_30215__$1;
(statearr_30221_30261[(2)] = inst_30119);

(statearr_30221_30261[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (15))){
var inst_30128 = (state_30215[(8)]);
var inst_30126 = (state_30215[(7)]);
var inst_30147 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_30148 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_30149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30150 = [inst_30126];
var inst_30151 = (new cljs.core.PersistentVector(null,1,(5),inst_30149,inst_30150,null));
var inst_30152 = (function (){var subject_var = inst_30126;
var object_var = inst_30128;
var min_sid = inst_30147;
var max_sid = (0);
return (function (p1__30117_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__30117_SHARP_);
});
})();
var inst_30153 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_30147,(0));
var inst_30154 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30152,inst_30153);
var inst_30155 = cljs.core.PersistentHashMap.EMPTY;
var inst_30156 = [inst_30151,inst_30154,inst_30155];
var inst_30157 = cljs.core.PersistentHashMap.fromArrays(inst_30148,inst_30156);
var state_30215__$1 = state_30215;
var statearr_30222_30262 = state_30215__$1;
(statearr_30222_30262[(2)] = inst_30157);

(statearr_30222_30262[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (21))){
var inst_30179 = (state_30215[(9)]);
var state_30215__$1 = state_30215;
var statearr_30223_30263 = state_30215__$1;
(statearr_30223_30263[(2)] = inst_30179);

(statearr_30223_30263[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (13))){
var inst_30128 = (state_30215[(8)]);
var state_30215__$1 = state_30215;
if(cljs.core.truth_(inst_30128)){
var statearr_30224_30264 = state_30215__$1;
(statearr_30224_30264[(1)] = (18));

} else {
var statearr_30225_30265 = state_30215__$1;
(statearr_30225_30265[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (22))){
var inst_30179 = (state_30215[(9)]);
var inst_30183 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30179);
var state_30215__$1 = state_30215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30215__$1,(24),inst_30183);
} else {
if((state_val_30216 === (6))){
var inst_30128 = (state_30215[(8)]);
var state_30215__$1 = state_30215;
var statearr_30226_30266 = state_30215__$1;
(statearr_30226_30266[(2)] = inst_30128);

(statearr_30226_30266[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (17))){
var inst_30176 = (state_30215[(2)]);
var state_30215__$1 = state_30215;
var statearr_30227_30267 = state_30215__$1;
(statearr_30227_30267[(2)] = inst_30176);

(statearr_30227_30267[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (3))){
var inst_30213 = (state_30215[(2)]);
var state_30215__$1 = state_30215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30215__$1,inst_30213);
} else {
if((state_val_30216 === (12))){
var inst_30141 = ["_tx",null,"_block",null];
var inst_30142 = (new cljs.core.PersistentArrayMap(null,2,inst_30141,null));
var inst_30143 = (new cljs.core.PersistentHashSet(null,inst_30142,null));
var inst_30144 = cljs.core.last(clause);
var inst_30145 = (inst_30143.cljs$core$IFn$_invoke$arity$1 ? inst_30143.cljs$core$IFn$_invoke$arity$1(inst_30144) : inst_30143.call(null,inst_30144));
var state_30215__$1 = state_30215;
if(cljs.core.truth_(inst_30145)){
var statearr_30228_30268 = state_30215__$1;
(statearr_30228_30268[(1)] = (15));

} else {
var statearr_30229_30269 = state_30215__$1;
(statearr_30229_30269[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (2))){
var inst_30126 = (state_30215[(7)]);
var _ = (function (){var statearr_30230 = state_30215;
(statearr_30230[(4)] = cljs.core.cons((5),(state_30215[(4)])));

return statearr_30230;
})();
var inst_30125 = cljs.core.first(clause);
var inst_30126__$1 = fluree.db.query.analytical.variable_QMARK_(inst_30125);
var inst_30127 = cljs.core.last(clause);
var inst_30128 = fluree.db.query.analytical.variable_QMARK_(inst_30127);
var state_30215__$1 = (function (){var statearr_30231 = state_30215;
(statearr_30231[(8)] = inst_30128);

(statearr_30231[(7)] = inst_30126__$1);

return statearr_30231;
})();
if(cljs.core.truth_(inst_30126__$1)){
var statearr_30232_30270 = state_30215__$1;
(statearr_30232_30270[(1)] = (6));

} else {
var statearr_30233_30271 = state_30215__$1;
(statearr_30233_30271[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (23))){
var inst_30128 = (state_30215[(8)]);
var inst_30188 = (state_30215[(2)]);
var inst_30189 = fluree.db.flake.sid__GT_cid(inst_30188);
var inst_30190 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_30189);
var inst_30191 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_30192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30193 = [inst_30128];
var inst_30194 = (new cljs.core.PersistentVector(null,1,(5),inst_30192,inst_30193,null));
var inst_30195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30197 = [inst_30190];
var inst_30198 = (new cljs.core.PersistentVector(null,1,(5),inst_30196,inst_30197,null));
var inst_30199 = [inst_30198];
var inst_30200 = (new cljs.core.PersistentVector(null,1,(5),inst_30195,inst_30199,null));
var inst_30201 = cljs.core.PersistentHashMap.EMPTY;
var inst_30202 = [inst_30194,inst_30200,inst_30201];
var inst_30203 = cljs.core.PersistentHashMap.fromArrays(inst_30191,inst_30202);
var state_30215__$1 = state_30215;
var statearr_30234_30272 = state_30215__$1;
(statearr_30234_30272[(2)] = inst_30203);

(statearr_30234_30272[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (19))){
var state_30215__$1 = state_30215;
var statearr_30235_30273 = state_30215__$1;
(statearr_30235_30273[(2)] = null);

(statearr_30235_30273[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (11))){
var inst_30210 = (state_30215[(2)]);
var _ = (function (){var statearr_30237 = state_30215;
(statearr_30237[(4)] = cljs.core.rest((state_30215[(4)])));

return statearr_30237;
})();
var state_30215__$1 = state_30215;
var statearr_30238_30274 = state_30215__$1;
(statearr_30238_30274[(2)] = inst_30210);

(statearr_30238_30274[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (9))){
var inst_30134 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30135 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_30136 = cljs.core.PersistentHashMap.fromArrays(inst_30134,inst_30135);
var inst_30137 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_30136);
var inst_30138 = (function(){throw inst_30137})();
var state_30215__$1 = state_30215;
var statearr_30239_30275 = state_30215__$1;
(statearr_30239_30275[(2)] = inst_30138);

(statearr_30239_30275[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (5))){
var _ = (function (){var statearr_30240 = state_30215;
(statearr_30240[(4)] = cljs.core.rest((state_30215[(4)])));

return statearr_30240;
})();
var state_30215__$1 = state_30215;
var ex30236 = (state_30215__$1[(2)]);
var statearr_30241_30276 = state_30215__$1;
(statearr_30241_30276[(5)] = ex30236);


if((ex30236 instanceof Error)){
var statearr_30242_30277 = state_30215__$1;
(statearr_30242_30277[(1)] = (4));

(statearr_30242_30277[(5)] = null);

} else {
throw ex30236;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (14))){
var inst_30208 = (state_30215[(2)]);
var state_30215__$1 = state_30215;
var statearr_30243_30278 = state_30215__$1;
(statearr_30243_30278[(2)] = inst_30208);

(statearr_30243_30278[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (16))){
var inst_30128 = (state_30215[(8)]);
var inst_30126 = (state_30215[(7)]);
var inst_30159 = cljs.core.last(clause);
var inst_30160 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_30159);
var inst_30161 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_30162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30161,inst_30160);
var inst_30163 = fluree.db.flake.min_subject_id(inst_30160);
var inst_30164 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_30165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30166 = [inst_30126];
var inst_30167 = (new cljs.core.PersistentVector(null,1,(5),inst_30165,inst_30166,null));
var inst_30168 = (function (){var subject_var = inst_30126;
var object_var = inst_30128;
var partition = inst_30160;
var max_sid = inst_30162;
var min_sid = inst_30163;
return (function (p1__30118_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__30118_SHARP_);
});
})();
var inst_30169 = (inst_30162 + (1));
var inst_30170 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_30163,inst_30169);
var inst_30171 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30168,inst_30170);
var inst_30172 = cljs.core.PersistentHashMap.EMPTY;
var inst_30173 = [inst_30167,inst_30171,inst_30172];
var inst_30174 = cljs.core.PersistentHashMap.fromArrays(inst_30164,inst_30173);
var state_30215__$1 = state_30215;
var statearr_30244_30279 = state_30215__$1;
(statearr_30244_30279[(2)] = inst_30174);

(statearr_30244_30279[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (10))){
var inst_30126 = (state_30215[(7)]);
var state_30215__$1 = state_30215;
if(cljs.core.truth_(inst_30126)){
var statearr_30245_30280 = state_30215__$1;
(statearr_30245_30280[(1)] = (12));

} else {
var statearr_30246_30281 = state_30215__$1;
(statearr_30246_30281[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (18))){
var inst_30179 = (state_30215[(9)]);
var inst_30179__$1 = cljs.core.first(clause);
var inst_30180 = typeof inst_30179__$1 === 'number';
var state_30215__$1 = (function (){var statearr_30247 = state_30215;
(statearr_30247[(9)] = inst_30179__$1);

return statearr_30247;
})();
if(cljs.core.truth_(inst_30180)){
var statearr_30248_30282 = state_30215__$1;
(statearr_30248_30282[(1)] = (21));

} else {
var statearr_30249_30283 = state_30215__$1;
(statearr_30249_30283[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30216 === (8))){
var inst_30132 = (state_30215[(2)]);
var state_30215__$1 = state_30215;
if(cljs.core.truth_(inst_30132)){
var statearr_30250_30284 = state_30215__$1;
(statearr_30250_30284[(1)] = (9));

} else {
var statearr_30251_30285 = state_30215__$1;
(statearr_30251_30285[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto____0 = (function (){
var statearr_30252 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30252[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto__);

(statearr_30252[(1)] = (1));

return statearr_30252;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto____1 = (function (state_30215){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_30215);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e30253){var ex__10801__auto__ = e30253;
var statearr_30254_30286 = state_30215;
(statearr_30254_30286[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_30215[(4)]))){
var statearr_30255_30287 = state_30215;
(statearr_30255_30287[(1)] = cljs.core.first((state_30215[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__30288 = state_30215;
state_30215 = G__30288;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto__ = function(state_30215){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto____1.call(this,state_30215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_30256 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_30256[(6)] = c__10835__auto__);

return statearr_30256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__30295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__30295 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__30295;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4622__auto__ = (function fluree$db$query$analytical$variance_$_iter__30296(s__30297){
return (new cljs.core.LazySeq(null,(function (){
var s__30297__$1 = s__30297;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__30297__$1);
if(temp__5753__auto__){
var s__30297__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30297__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__30297__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__30299 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__30298 = (0);
while(true){
if((i__30298 < size__4621__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__30298);
var delta = (x - mean);
cljs.core.chunk_append(b__30299,(delta * delta));

var G__30301 = (i__30298 + (1));
i__30298 = G__30301;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30299),fluree$db$query$analytical$variance_$_iter__30296(cljs.core.chunk_rest(s__30297__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30299),null);
}
} else {
var x = cljs.core.first(s__30297__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__30296(cljs.core.rest(s__30297__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__30300 = variance(coll);
return Math.sqrt(G__30300);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4306__auto__ = n;
var y__4307__auto__ = (- n);
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
}),(function() {
var G__30302 = null;
var G__30302__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__30302__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__30302 = function(n,coll){
switch(arguments.length){
case 1:
return G__30302__1.call(this,n);
case 2:
return G__30302__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__30302.cljs$core$IFn$_invoke$arity$1 = G__30302__1;
G__30302.cljs$core$IFn$_invoke$arity$2 = G__30302__2;
return G__30302;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__30303 = null;
var G__30303__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__30303__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__30303 = function(n,coll){
switch(arguments.length){
case 1:
return G__30303__1.call(this,n);
case 2:
return G__30303__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__30303.cljs$core$IFn$_invoke$arity$1 = G__30303__1;
G__30303.cljs$core$IFn$_invoke$arity$2 = G__30303__2;
return G__30303;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__30304 = null;
var G__30304__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__30304__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__30304 = function(n,coll){
switch(arguments.length){
case 1:
return G__30304__1.call(this,n);
case 2:
return G__30304__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__30304.cljs$core$IFn$_invoke$arity$1 = G__30304__1;
G__30304.cljs$core$IFn$_invoke$arity$2 = G__30304__2;
return G__30304;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__30305 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30305,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30305,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30305,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__30308 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__30311 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__30311) : agg_fn.call(null,G__30311));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30308,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30308,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__30312 = agg;
var map__30312__$1 = cljs.core.__destructure_map(map__30312);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30312__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30312__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30312__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__30314 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30314,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30314,(1),null);
var map__30317 = res__$1;
var map__30317__$1 = cljs.core.__destructure_map(map__30317);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30317__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30317__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30313_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__30313_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30318_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__30318_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30319_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__30319_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__30320_SHARP_,p2__30321_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30320_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__30321_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30322_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__30322_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__30325,row,b_tuple){
var vec__30326 = p__30325;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30326,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30326,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30323_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__30323_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = acc;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30324_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__30324_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30329_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__30329_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30330_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__30330_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__30335 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__30337 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__30336 = (function (p1__30331_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__30331_SHARP_);
});
return fexpr__30336(G__30337);
})()),cljs.core.set(b_idxs));
var fexpr__30334 = (function (p1__30332_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__30332_SHARP_);
});
return fexpr__30334(G__30335);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30333_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__30333_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30338_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__30338_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30339_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__30339_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__30344 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__30346 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__30345 = (function (p1__30340_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__30340_SHARP_);
});
return fexpr__30345(G__30346);
})()),cljs.core.set(b_idxs));
var fexpr__30343 = (function (p1__30341_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__30341_SHARP_);
});
return fexpr__30343(G__30344);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30342_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__30342_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30347_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__30347_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30348_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__30348_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__30357 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__30359 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__30358 = (function (p1__30349_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__30349_SHARP_);
});
return fexpr__30358(G__30359);
})()),cljs.core.set(b_idxs));
var fexpr__30356 = (function (p1__30350_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__30350_SHARP_);
});
return fexpr__30356(G__30357);
})();
var vec__30353 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__30360,a_tuple){
var vec__30361 = p__30360;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30361,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30361,(1),null);
var vec__30364 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30364,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30364,(1),null);
var matches__$1 = (function (){var or__4223__auto__ = matches;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(c_tuples),matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30353,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30353,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30351_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__30351_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30352_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__30352_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__30368 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30368,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30368,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__30367_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__30367_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__30373 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30373,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30373,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30371_SHARP_){
return fluree.db.util.core.index_of(headers,p1__30371_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__30372_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__30372_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__30376,filters,optional_QMARK_){
var map__30377 = p__30376;
var map__30377__$1 = cljs.core.__destructure_map(map__30377);
var tuple_map = map__30377__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30377__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30377__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30377__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__30378 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30378,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30378,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__30381 = res;
var map__30381__$1 = cljs.core.__destructure_map(map__30381);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30381__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30381__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_30437){
var state_val_30438 = (state_30437[(1)]);
if((state_val_30438 === (7))){
var inst_30411 = (state_30437[(7)]);
var inst_30409 = (state_30437[(2)]);
var inst_30410 = fluree.db.util.async.throw_err(inst_30409);
var inst_30411__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30410,(0),null);
var inst_30412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30410,(1),null);
var inst_30413 = (inst_30411__$1 == null);
var state_30437__$1 = (function (){var statearr_30439 = state_30437;
(statearr_30439[(7)] = inst_30411__$1);

(statearr_30439[(8)] = inst_30412);

return statearr_30439;
})();
if(cljs.core.truth_(inst_30413)){
var statearr_30440_30469 = state_30437__$1;
(statearr_30440_30469[(1)] = (8));

} else {
var statearr_30441_30470 = state_30437__$1;
(statearr_30441_30470[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (1))){
var inst_30389 = optional_clauses;
var inst_30390 = cljs.core.seq(inst_30389);
var inst_30391 = cljs.core.first(inst_30390);
var inst_30392 = cljs.core.next(inst_30390);
var inst_30393 = where_tuples;
var inst_30394 = inst_30389;
var inst_30395 = inst_30393;
var state_30437__$1 = (function (){var statearr_30442 = state_30437;
(statearr_30442[(9)] = inst_30392);

(statearr_30442[(10)] = inst_30394);

(statearr_30442[(11)] = inst_30391);

(statearr_30442[(12)] = inst_30395);

return statearr_30442;
})();
var statearr_30443_30471 = state_30437__$1;
(statearr_30443_30471[(2)] = null);

(statearr_30443_30471[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (4))){
var inst_30401 = (state_30437[(13)]);
var inst_30402 = (state_30437[(14)]);
var inst_30395 = (state_30437[(12)]);
var inst_30407 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_30395,inst_30401,inst_30402,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_30395,inst_30401,inst_30402,true,fuel,max_fuel,opts));
var state_30437__$1 = state_30437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30437__$1,(7),inst_30407);
} else {
if((state_val_30438 === (15))){
var state_30437__$1 = state_30437;
var statearr_30444_30472 = state_30437__$1;
(statearr_30444_30472[(2)] = null);

(statearr_30444_30472[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (13))){
var inst_30428 = (state_30437[(2)]);
var state_30437__$1 = state_30437;
var statearr_30445_30473 = state_30437__$1;
(statearr_30445_30473[(2)] = inst_30428);

(statearr_30445_30473[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (6))){
var inst_30433 = (state_30437[(2)]);
var state_30437__$1 = state_30437;
var statearr_30446_30474 = state_30437__$1;
(statearr_30446_30474[(2)] = inst_30433);

(statearr_30446_30474[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (3))){
var inst_30435 = (state_30437[(2)]);
var state_30437__$1 = state_30437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30437__$1,inst_30435);
} else {
if((state_val_30438 === (12))){
var state_30437__$1 = state_30437;
var statearr_30447_30475 = state_30437__$1;
(statearr_30447_30475[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (2))){
var inst_30394 = (state_30437[(10)]);
var inst_30401 = (state_30437[(13)]);
var inst_30400 = cljs.core.seq(inst_30394);
var inst_30401__$1 = cljs.core.first(inst_30400);
var inst_30402 = cljs.core.next(inst_30400);
var state_30437__$1 = (function (){var statearr_30449 = state_30437;
(statearr_30449[(13)] = inst_30401__$1);

(statearr_30449[(14)] = inst_30402);

return statearr_30449;
})();
if(cljs.core.truth_(inst_30401__$1)){
var statearr_30450_30476 = state_30437__$1;
(statearr_30450_30476[(1)] = (4));

} else {
var statearr_30451_30477 = state_30437__$1;
(statearr_30451_30477[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (11))){
var inst_30411 = (state_30437[(7)]);
var inst_30412 = (state_30437[(8)]);
var inst_30394 = inst_30412;
var inst_30395 = inst_30411;
var state_30437__$1 = (function (){var statearr_30452 = state_30437;
(statearr_30452[(10)] = inst_30394);

(statearr_30452[(12)] = inst_30395);

return statearr_30452;
})();
var statearr_30453_30478 = state_30437__$1;
(statearr_30453_30478[(2)] = null);

(statearr_30453_30478[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (9))){
var inst_30401 = (state_30437[(13)]);
var inst_30417 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_30401);
var state_30437__$1 = state_30437;
if(cljs.core.truth_(inst_30417)){
var statearr_30454_30479 = state_30437__$1;
(statearr_30454_30479[(1)] = (11));

} else {
var statearr_30455_30480 = state_30437__$1;
(statearr_30455_30480[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (5))){
var inst_30395 = (state_30437[(12)]);
var state_30437__$1 = state_30437;
var statearr_30456_30481 = state_30437__$1;
(statearr_30456_30481[(2)] = inst_30395);

(statearr_30456_30481[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (14))){
var inst_30411 = (state_30437[(7)]);
var inst_30395 = (state_30437[(12)]);
var inst_30412 = (state_30437[(8)]);
var inst_30422 = fluree.db.query.analytical.left_outer_join(inst_30395,inst_30411);
var inst_30394 = inst_30412;
var inst_30395__$1 = inst_30422;
var state_30437__$1 = (function (){var statearr_30457 = state_30437;
(statearr_30457[(10)] = inst_30394);

(statearr_30457[(12)] = inst_30395__$1);

return statearr_30457;
})();
var statearr_30458_30482 = state_30437__$1;
(statearr_30458_30482[(2)] = null);

(statearr_30458_30482[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (16))){
var inst_30426 = (state_30437[(2)]);
var state_30437__$1 = state_30437;
var statearr_30460_30483 = state_30437__$1;
(statearr_30460_30483[(2)] = inst_30426);

(statearr_30460_30483[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (10))){
var inst_30430 = (state_30437[(2)]);
var state_30437__$1 = state_30437;
var statearr_30461_30484 = state_30437__$1;
(statearr_30461_30484[(2)] = inst_30430);

(statearr_30461_30484[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30438 === (8))){
var inst_30395 = (state_30437[(12)]);
var inst_30412 = (state_30437[(8)]);
var tmp30459 = inst_30395;
var inst_30394 = inst_30412;
var inst_30395__$1 = tmp30459;
var state_30437__$1 = (function (){var statearr_30462 = state_30437;
(statearr_30462[(10)] = inst_30394);

(statearr_30462[(12)] = inst_30395__$1);

return statearr_30462;
})();
var statearr_30463_30485 = state_30437__$1;
(statearr_30463_30485[(2)] = null);

(statearr_30463_30485[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto____0 = (function (){
var statearr_30464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30464[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto__);

(statearr_30464[(1)] = (1));

return statearr_30464;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto____1 = (function (state_30437){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_30437);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e30465){var ex__10801__auto__ = e30465;
var statearr_30466_30486 = state_30437;
(statearr_30466_30486[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_30437[(4)]))){
var statearr_30467_30487 = state_30437;
(statearr_30467_30487[(1)] = cljs.core.first((state_30437[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__30488 = state_30437;
state_30437 = G__30488;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto__ = function(state_30437){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto____1.call(this,state_30437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_30468 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_30468[(6)] = c__10835__auto__);

return statearr_30468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__30490){
var vec__30491 = p__30490;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30491,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30491,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30489_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30489_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__30495,p__30496,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__30497 = p__30495;
var map__30497__$1 = cljs.core.__destructure_map(map__30497);
var q_map = map__30497__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30497__$1,cljs.core.cst$kw$prefixes);
var map__30498 = p__30496;
var map__30498__$1 = cljs.core.__destructure_map(map__30498);
var res = map__30498__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30498__$1,cljs.core.cst$kw$vars);
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_30711){
var state_val_30712 = (state_30711[(1)]);
if((state_val_30712 === (65))){
var inst_30680 = (state_30711[(7)]);
var inst_30683 = (state_30711[(2)]);
var inst_30684 = fluree.db.util.async.throw_err(inst_30683);
var inst_30685 = [inst_30684,r];
var inst_30686 = (new cljs.core.PersistentVector(null,2,(5),inst_30680,inst_30685,null));
var state_30711__$1 = state_30711;
var statearr_30713_30818 = state_30711__$1;
(statearr_30713_30818[(2)] = inst_30686);

(statearr_30713_30818[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (62))){
var inst_30663 = (state_30711[(8)]);
var inst_30662 = (state_30711[(9)]);
var inst_30680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30681 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_30662,res,inst_30663,fuel,max_fuel);
var state_30711__$1 = (function (){var statearr_30714 = state_30711;
(statearr_30714[(7)] = inst_30680);

return statearr_30714;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30711__$1,(65),inst_30681);
} else {
if((state_val_30712 === (7))){
var inst_30604 = (state_30711[(10)]);
var inst_30603 = cljs.core.count(clause);
var inst_30604__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_30603);
var state_30711__$1 = (function (){var statearr_30715 = state_30711;
(statearr_30715[(10)] = inst_30604__$1);

return statearr_30715;
})();
if(inst_30604__$1){
var statearr_30716_30819 = state_30711__$1;
(statearr_30716_30819[(1)] = (31));

} else {
var statearr_30717_30820 = state_30711__$1;
(statearr_30717_30820[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (59))){
var inst_30663 = (state_30711[(8)]);
var inst_30662 = (state_30711[(9)]);
var inst_30674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30675 = fluree.db.query.analytical.full_text__GT_tuples(inst_30662,res,inst_30663);
var inst_30676 = [inst_30675,r];
var inst_30677 = (new cljs.core.PersistentVector(null,2,(5),inst_30674,inst_30676,null));
var state_30711__$1 = state_30711;
var statearr_30718_30821 = state_30711__$1;
(statearr_30718_30821[(2)] = inst_30677);

(statearr_30718_30821[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (20))){
var inst_30567 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30719_30822 = state_30711__$1;
(statearr_30719_30822[(2)] = inst_30567);

(statearr_30719_30822[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (58))){
var inst_30668 = (state_30711[(2)]);
var inst_30669 = fluree.db.util.async.throw_err(inst_30668);
var state_30711__$1 = state_30711;
var statearr_30720_30823 = state_30711__$1;
(statearr_30720_30823[(2)] = inst_30669);

(statearr_30720_30823[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (60))){
var state_30711__$1 = state_30711;
var statearr_30721_30824 = state_30711__$1;
(statearr_30721_30824[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (27))){
var inst_30597 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30723_30825 = state_30711__$1;
(statearr_30723_30825[(2)] = inst_30597);

(statearr_30723_30825[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (1))){
var state_30711__$1 = state_30711;
var statearr_30724_30826 = state_30711__$1;
(statearr_30724_30826[(2)] = null);

(statearr_30724_30826[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (24))){
var inst_30561 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30725_30827 = state_30711__$1;
(statearr_30725_30827[(2)] = inst_30561);

(statearr_30725_30827[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (55))){
var inst_30663 = (state_30711[(8)]);
var inst_30666 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_30663,r,res,optional_QMARK_,fuel,max_fuel);
var state_30711__$1 = state_30711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30711__$1,(58),inst_30666);
} else {
if((state_val_30712 === (39))){
var inst_30624 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
if(cljs.core.truth_(inst_30624)){
var statearr_30726_30828 = state_30711__$1;
(statearr_30726_30828[(1)] = (40));

} else {
var statearr_30727_30829 = state_30711__$1;
(statearr_30727_30829[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (46))){
var inst_30700 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30728_30830 = state_30711__$1;
(statearr_30728_30830[(2)] = inst_30700);

(statearr_30728_30830[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (4))){
var inst_30499 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30729_30831 = state_30711__$1;
(statearr_30729_30831[(2)] = inst_30499);

(statearr_30729_30831[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (54))){
var inst_30662 = (state_30711[(9)]);
var inst_30660 = (state_30711[(2)]);
var inst_30661 = fluree.db.util.async.throw_err(inst_30660);
var inst_30662__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30661,(0),null);
var inst_30663 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30661,(1),null);
var inst_30664 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_30662__$1);
var state_30711__$1 = (function (){var statearr_30730 = state_30711;
(statearr_30730[(8)] = inst_30663);

(statearr_30730[(9)] = inst_30662__$1);

return statearr_30730;
})();
if(inst_30664){
var statearr_30731_30832 = state_30711__$1;
(statearr_30731_30832[(1)] = (55));

} else {
var statearr_30732_30833 = state_30711__$1;
(statearr_30732_30833[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (15))){
var inst_30599 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30733_30834 = state_30711__$1;
(statearr_30733_30834[(2)] = inst_30599);

(statearr_30733_30834[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (48))){
var inst_30648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30649 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_30650 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_30649);
var inst_30651 = [inst_30650,r];
var inst_30652 = (new cljs.core.PersistentVector(null,2,(5),inst_30648,inst_30651,null));
var state_30711__$1 = state_30711;
var statearr_30734_30835 = state_30711__$1;
(statearr_30734_30835[(2)] = inst_30652);

(statearr_30734_30835[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (50))){
var inst_30698 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30735_30836 = state_30711__$1;
(statearr_30735_30836[(2)] = inst_30698);

(statearr_30735_30836[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (21))){
var inst_30535 = (state_30711[(11)]);
var inst_30537 = (state_30711[(12)]);
var inst_30544 = (state_30711[(13)]);
var inst_30508 = (state_30711[(14)]);
var inst_30545 = (state_30711[(15)]);
var inst_30512 = (state_30711[(16)]);
var inst_30536 = (state_30711[(17)]);
var inst_30538 = (state_30711[(18)]);
var inst_30533 = (state_30711[(19)]);
var inst_30549 = (state_30711[(2)]);
var inst_30550 = fluree.db.util.async.throw_err(inst_30549);
var inst_30551 = (function (){var new_res = inst_30550;
var rest = inst_30545;
var expr__30510 = inst_30508;
var vec__30540 = inst_30537;
var seq__30541 = inst_30545;
var tuples = inst_30538;
var G__30529 = inst_30537;
var seq__30531 = inst_30536;
var vec__30530 = inst_30533;
var pred__30509 = inst_30512;
var first__30532 = inst_30535;
var segment_type = inst_30508;
var first__30542 = inst_30544;
var clause_group = inst_30544;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_30552 = cljs.core.keys(vars);
var inst_30553 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_30551,inst_30550,inst_30552);
var inst_30554 = fluree.db.query.analytical.res_absorb_vars(inst_30553);
var state_30711__$1 = (function (){var statearr_30736 = state_30711;
(statearr_30736[(20)] = inst_30554);

return statearr_30736;
})();
if(cljs.core.truth_(inst_30538)){
var statearr_30737_30837 = state_30711__$1;
(statearr_30737_30837[(1)] = (22));

} else {
var statearr_30738_30838 = state_30711__$1;
(statearr_30738_30838[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (31))){
var inst_30606 = cljs.core.second(clause);
var inst_30607 = clojure.string.starts_with_QMARK_(inst_30606,"fullText:");
var state_30711__$1 = state_30711;
var statearr_30739_30839 = state_30711__$1;
(statearr_30739_30839[(2)] = inst_30607);

(statearr_30739_30839[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (32))){
var inst_30604 = (state_30711[(10)]);
var state_30711__$1 = state_30711;
var statearr_30740_30840 = state_30711__$1;
(statearr_30740_30840[(2)] = inst_30604);

(statearr_30740_30840[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (40))){
var inst_30626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30627 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_30711__$1 = (function (){var statearr_30741 = state_30711;
(statearr_30741[(21)] = inst_30626);

return statearr_30741;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30711__$1,(43),inst_30627);
} else {
if((state_val_30712 === (56))){
var inst_30663 = (state_30711[(8)]);
var inst_30671 = cljs.core.second(inst_30663);
var inst_30672 = clojure.string.starts_with_QMARK_(inst_30671,"fullText:");
var state_30711__$1 = state_30711;
if(inst_30672){
var statearr_30742_30841 = state_30711__$1;
(statearr_30742_30841[(1)] = (59));

} else {
var statearr_30743_30842 = state_30711__$1;
(statearr_30743_30842[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (33))){
var inst_30610 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
if(cljs.core.truth_(inst_30610)){
var statearr_30744_30843 = state_30711__$1;
(statearr_30744_30843[(1)] = (34));

} else {
var statearr_30745_30844 = state_30711__$1;
(statearr_30745_30844[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (13))){
var inst_30533 = (state_30711[(19)]);
var inst_30533__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_30534 = cljs.core.seq(inst_30533__$1);
var inst_30535 = cljs.core.first(inst_30534);
var inst_30536 = cljs.core.next(inst_30534);
var inst_30537 = inst_30533__$1;
var inst_30538 = null;
var state_30711__$1 = (function (){var statearr_30746 = state_30711;
(statearr_30746[(11)] = inst_30535);

(statearr_30746[(12)] = inst_30537);

(statearr_30746[(17)] = inst_30536);

(statearr_30746[(18)] = inst_30538);

(statearr_30746[(19)] = inst_30533__$1);

return statearr_30746;
})();
var statearr_30747_30845 = state_30711__$1;
(statearr_30747_30845[(2)] = null);

(statearr_30747_30845[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (22))){
var inst_30545 = (state_30711[(15)]);
var inst_30554 = (state_30711[(20)]);
var inst_30538 = (state_30711[(18)]);
var inst_30556 = fluree.db.query.analytical.outer_union(inst_30538,inst_30554);
var inst_30537 = inst_30545;
var inst_30538__$1 = inst_30556;
var state_30711__$1 = (function (){var statearr_30748 = state_30711;
(statearr_30748[(12)] = inst_30537);

(statearr_30748[(18)] = inst_30538__$1);

return statearr_30748;
})();
var statearr_30749_30846 = state_30711__$1;
(statearr_30749_30846[(2)] = null);

(statearr_30749_30846[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (36))){
var inst_30704 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30750_30847 = state_30711__$1;
(statearr_30750_30847[(2)] = inst_30704);

(statearr_30750_30847[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (41))){
var inst_30634 = cljs.core.count(clause);
var inst_30635 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_30634);
var state_30711__$1 = state_30711;
if(inst_30635){
var statearr_30751_30848 = state_30711__$1;
(statearr_30751_30848[(1)] = (44));

} else {
var statearr_30752_30849 = state_30711__$1;
(statearr_30752_30849[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (43))){
var inst_30626 = (state_30711[(21)]);
var inst_30629 = (state_30711[(2)]);
var inst_30630 = fluree.db.util.async.throw_err(inst_30629);
var inst_30631 = [inst_30630,r];
var inst_30632 = (new cljs.core.PersistentVector(null,2,(5),inst_30626,inst_30631,null));
var state_30711__$1 = state_30711;
var statearr_30753_30850 = state_30711__$1;
(statearr_30753_30850[(2)] = inst_30632);

(statearr_30753_30850[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (61))){
var inst_30691 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30754_30851 = state_30711__$1;
(statearr_30754_30851[(2)] = inst_30691);

(statearr_30754_30851[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (29))){
var inst_30508 = (state_30711[(14)]);
var inst_30591 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30508)].join('');
var inst_30592 = (new Error(inst_30591));
var inst_30593 = (function(){throw inst_30592})();
var state_30711__$1 = state_30711;
var statearr_30755_30852 = state_30711__$1;
(statearr_30755_30852[(2)] = inst_30593);

(statearr_30755_30852[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (44))){
var inst_30637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30638 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_30711__$1 = (function (){var statearr_30756 = state_30711;
(statearr_30756[(22)] = inst_30637);

return statearr_30756;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30711__$1,(47),inst_30638);
} else {
if((state_val_30712 === (6))){
var inst_30508 = (state_30711[(14)]);
var inst_30512 = (state_30711[(16)]);
var inst_30507 = cljs.core.keys(clause);
var inst_30508__$1 = cljs.core.first(inst_30507);
var inst_30512__$1 = cljs.core._EQ_;
var inst_30513 = (function (){var G__30757 = cljs.core.cst$kw$optional;
var G__30758 = inst_30508__$1;
return (inst_30512__$1.cljs$core$IFn$_invoke$arity$2 ? inst_30512__$1.cljs$core$IFn$_invoke$arity$2(G__30757,G__30758) : inst_30512__$1.call(null,G__30757,G__30758));
})();
var state_30711__$1 = (function (){var statearr_30759 = state_30711;
(statearr_30759[(14)] = inst_30508__$1);

(statearr_30759[(16)] = inst_30512__$1);

return statearr_30759;
})();
if(cljs.core.truth_(inst_30513)){
var statearr_30760_30853 = state_30711__$1;
(statearr_30760_30853[(1)] = (9));

} else {
var statearr_30761_30854 = state_30711__$1;
(statearr_30761_30854[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (28))){
var inst_30585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30586 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_30587 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_30586,optional_QMARK_);
var inst_30588 = [inst_30587,r];
var inst_30589 = (new cljs.core.PersistentVector(null,2,(5),inst_30585,inst_30588,null));
var state_30711__$1 = state_30711;
var statearr_30762_30855 = state_30711__$1;
(statearr_30762_30855[(2)] = inst_30589);

(statearr_30762_30855[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (64))){
var inst_30689 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30763_30856 = state_30711__$1;
(statearr_30763_30856[(2)] = inst_30689);

(statearr_30763_30856[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (51))){
var inst_30658 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_30711__$1 = state_30711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30711__$1,(54),inst_30658);
} else {
if((state_val_30712 === (25))){
var inst_30508 = (state_30711[(14)]);
var inst_30512 = (state_30711[(16)]);
var inst_30573 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_30574 = (function (){var segment_type = inst_30508;
var pred__30509 = inst_30512;
var expr__30510 = inst_30508;
var bindings = inst_30573;
return (function (p1__30494_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__30494_SHARP_);
});
})();
var inst_30575 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30574,inst_30573);
var inst_30576 = cljs.core.PersistentHashMap.EMPTY;
var inst_30577 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30576,inst_30575);
var inst_30578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30579 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_30577);
var inst_30580 = [inst_30579,r];
var inst_30581 = (new cljs.core.PersistentVector(null,2,(5),inst_30578,inst_30580,null));
var state_30711__$1 = state_30711;
var statearr_30764_30857 = state_30711__$1;
(statearr_30764_30857[(2)] = inst_30581);

(statearr_30764_30857[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (34))){
var inst_30612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30613 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_30614 = [inst_30613,r];
var inst_30615 = (new cljs.core.PersistentVector(null,2,(5),inst_30612,inst_30614,null));
var state_30711__$1 = state_30711;
var statearr_30765_30858 = state_30711__$1;
(statearr_30765_30858[(2)] = inst_30615);

(statearr_30765_30858[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (17))){
var inst_30569 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30766_30859 = state_30711__$1;
(statearr_30766_30859[(2)] = inst_30569);

(statearr_30766_30859[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (3))){
var inst_30709 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30711__$1,inst_30709);
} else {
if((state_val_30712 === (12))){
var inst_30515 = (state_30711[(23)]);
var inst_30519 = (state_30711[(2)]);
var inst_30520 = fluree.db.util.async.throw_err(inst_30519);
var inst_30521 = [inst_30520,r];
var inst_30522 = (new cljs.core.PersistentVector(null,2,(5),inst_30515,inst_30521,null));
var state_30711__$1 = state_30711;
var statearr_30767_30860 = state_30711__$1;
(statearr_30767_30860[(2)] = inst_30522);

(statearr_30767_30860[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (2))){
var _ = (function (){var statearr_30768 = state_30711;
(statearr_30768[(4)] = cljs.core.cons((5),(state_30711[(4)])));

return statearr_30768;
})();
var inst_30505 = cljs.core.map_QMARK_(clause);
var state_30711__$1 = state_30711;
if(inst_30505){
var statearr_30769_30861 = state_30711__$1;
(statearr_30769_30861[(1)] = (6));

} else {
var statearr_30770_30862 = state_30711__$1;
(statearr_30770_30862[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (23))){
var inst_30545 = (state_30711[(15)]);
var inst_30554 = (state_30711[(20)]);
var inst_30537 = inst_30545;
var inst_30538 = inst_30554;
var state_30711__$1 = (function (){var statearr_30771 = state_30711;
(statearr_30771[(12)] = inst_30537);

(statearr_30771[(18)] = inst_30538);

return statearr_30771;
})();
var statearr_30772_30863 = state_30711__$1;
(statearr_30772_30863[(2)] = null);

(statearr_30772_30863[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (47))){
var inst_30637 = (state_30711[(22)]);
var inst_30640 = (state_30711[(2)]);
var inst_30641 = fluree.db.util.async.throw_err(inst_30640);
var inst_30642 = [inst_30641,r];
var inst_30643 = (new cljs.core.PersistentVector(null,2,(5),inst_30637,inst_30642,null));
var state_30711__$1 = state_30711;
var statearr_30773_30864 = state_30711__$1;
(statearr_30773_30864[(2)] = inst_30643);

(statearr_30773_30864[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (35))){
var inst_30618 = (state_30711[(24)]);
var inst_30617 = cljs.core.count(clause);
var inst_30618__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_30617);
var state_30711__$1 = (function (){var statearr_30774 = state_30711;
(statearr_30774[(24)] = inst_30618__$1);

return statearr_30774;
})();
if(inst_30618__$1){
var statearr_30775_30865 = state_30711__$1;
(statearr_30775_30865[(1)] = (37));

} else {
var statearr_30776_30866 = state_30711__$1;
(statearr_30776_30866[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (19))){
var inst_30538 = (state_30711[(18)]);
var inst_30563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30564 = [inst_30538,r];
var inst_30565 = (new cljs.core.PersistentVector(null,2,(5),inst_30563,inst_30564,null));
var state_30711__$1 = state_30711;
var statearr_30777_30867 = state_30711__$1;
(statearr_30777_30867[(2)] = inst_30565);

(statearr_30777_30867[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (57))){
var inst_30693 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30778_30868 = state_30711__$1;
(statearr_30778_30868[(2)] = inst_30693);

(statearr_30778_30868[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (11))){
var inst_30601 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30780_30869 = state_30711__$1;
(statearr_30780_30869[(2)] = inst_30601);

(statearr_30780_30869[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (9))){
var inst_30515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30516 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_30517 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_30516,res,fuel,max_fuel,opts);
var state_30711__$1 = (function (){var statearr_30781 = state_30711;
(statearr_30781[(23)] = inst_30515);

return statearr_30781;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30711__$1,(12),inst_30517);
} else {
if((state_val_30712 === (5))){
var _ = (function (){var statearr_30782 = state_30711;
(statearr_30782[(4)] = cljs.core.rest((state_30711[(4)])));

return statearr_30782;
})();
var state_30711__$1 = state_30711;
var ex30779 = (state_30711__$1[(2)]);
var statearr_30783_30870 = state_30711__$1;
(statearr_30783_30870[(5)] = ex30779);


if((ex30779 instanceof Error)){
var statearr_30784_30871 = state_30711__$1;
(statearr_30784_30871[(1)] = (4));

(statearr_30784_30871[(5)] = null);

} else {
throw ex30779;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (14))){
var inst_30508 = (state_30711[(14)]);
var inst_30512 = (state_30711[(16)]);
var inst_30571 = (function (){var G__30785 = cljs.core.cst$kw$bind;
var G__30786 = inst_30508;
return (inst_30512.cljs$core$IFn$_invoke$arity$2 ? inst_30512.cljs$core$IFn$_invoke$arity$2(G__30785,G__30786) : inst_30512.call(null,G__30785,G__30786));
})();
var state_30711__$1 = state_30711;
if(cljs.core.truth_(inst_30571)){
var statearr_30787_30872 = state_30711__$1;
(statearr_30787_30872[(1)] = (25));

} else {
var statearr_30788_30873 = state_30711__$1;
(statearr_30788_30873[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (45))){
var inst_30645 = cljs.core.count(clause);
var inst_30646 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_30645);
var state_30711__$1 = state_30711;
if(inst_30646){
var statearr_30789_30874 = state_30711__$1;
(statearr_30789_30874[(1)] = (48));

} else {
var statearr_30790_30875 = state_30711__$1;
(statearr_30790_30875[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (53))){
var inst_30696 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30791_30876 = state_30711__$1;
(statearr_30791_30876[(2)] = inst_30696);

(statearr_30791_30876[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (26))){
var inst_30508 = (state_30711[(14)]);
var inst_30512 = (state_30711[(16)]);
var inst_30583 = (function (){var G__30792 = cljs.core.cst$kw$filter;
var G__30793 = inst_30508;
return (inst_30512.cljs$core$IFn$_invoke$arity$2 ? inst_30512.cljs$core$IFn$_invoke$arity$2(G__30792,G__30793) : inst_30512.call(null,G__30792,G__30793));
})();
var state_30711__$1 = state_30711;
if(cljs.core.truth_(inst_30583)){
var statearr_30794_30877 = state_30711__$1;
(statearr_30794_30877[(1)] = (28));

} else {
var statearr_30795_30878 = state_30711__$1;
(statearr_30795_30878[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (16))){
var inst_30537 = (state_30711[(12)]);
var inst_30544 = (state_30711[(13)]);
var inst_30543 = cljs.core.seq(inst_30537);
var inst_30544__$1 = cljs.core.first(inst_30543);
var inst_30545 = cljs.core.next(inst_30543);
var state_30711__$1 = (function (){var statearr_30796 = state_30711;
(statearr_30796[(13)] = inst_30544__$1);

(statearr_30796[(15)] = inst_30545);

return statearr_30796;
})();
if(cljs.core.truth_(inst_30544__$1)){
var statearr_30797_30879 = state_30711__$1;
(statearr_30797_30879[(1)] = (18));

} else {
var statearr_30798_30880 = state_30711__$1;
(statearr_30798_30880[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (38))){
var inst_30618 = (state_30711[(24)]);
var state_30711__$1 = state_30711;
var statearr_30799_30881 = state_30711__$1;
(statearr_30799_30881[(2)] = inst_30618);

(statearr_30799_30881[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (30))){
var inst_30595 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30800_30882 = state_30711__$1;
(statearr_30800_30882[(2)] = inst_30595);

(statearr_30800_30882[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (10))){
var inst_30508 = (state_30711[(14)]);
var inst_30512 = (state_30711[(16)]);
var inst_30524 = (function (){var G__30801 = cljs.core.cst$kw$union;
var G__30802 = inst_30508;
return (inst_30512.cljs$core$IFn$_invoke$arity$2 ? inst_30512.cljs$core$IFn$_invoke$arity$2(G__30801,G__30802) : inst_30512.call(null,G__30801,G__30802));
})();
var state_30711__$1 = state_30711;
if(cljs.core.truth_(inst_30524)){
var statearr_30803_30883 = state_30711__$1;
(statearr_30803_30883[(1)] = (13));

} else {
var statearr_30804_30884 = state_30711__$1;
(statearr_30804_30884[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (18))){
var inst_30544 = (state_30711[(13)]);
var inst_30547 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_30544,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_30544,q_map,vars,fuel,max_fuel,opts));
var state_30711__$1 = state_30711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30711__$1,(21),inst_30547);
} else {
if((state_val_30712 === (52))){
var state_30711__$1 = state_30711;
var statearr_30805_30885 = state_30711__$1;
(statearr_30805_30885[(2)] = null);

(statearr_30805_30885[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (42))){
var inst_30702 = (state_30711[(2)]);
var state_30711__$1 = state_30711;
var statearr_30806_30886 = state_30711__$1;
(statearr_30806_30886[(2)] = inst_30702);

(statearr_30806_30886[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (37))){
var inst_30620 = cljs.core.second(clause);
var inst_30621 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30620,"rdf:type");
var state_30711__$1 = state_30711;
var statearr_30807_30887 = state_30711__$1;
(statearr_30807_30887[(2)] = inst_30621);

(statearr_30807_30887[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (63))){
var state_30711__$1 = state_30711;
var statearr_30808_30888 = state_30711__$1;
(statearr_30808_30888[(2)] = null);

(statearr_30808_30888[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (8))){
var inst_30706 = (state_30711[(2)]);
var _ = (function (){var statearr_30809 = state_30711;
(statearr_30809[(4)] = cljs.core.rest((state_30711[(4)])));

return statearr_30809;
})();
var state_30711__$1 = state_30711;
var statearr_30810_30889 = state_30711__$1;
(statearr_30810_30889[(2)] = inst_30706);

(statearr_30810_30889[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30712 === (49))){
var state_30711__$1 = state_30711;
var statearr_30811_30890 = state_30711__$1;
(statearr_30811_30890[(1)] = (51));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto____0 = (function (){
var statearr_30813 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30813[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto__);

(statearr_30813[(1)] = (1));

return statearr_30813;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto____1 = (function (state_30711){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_30711);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e30814){var ex__10801__auto__ = e30814;
var statearr_30815_30891 = state_30711;
(statearr_30815_30891[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_30711[(4)]))){
var statearr_30816_30892 = state_30711;
(statearr_30816_30892[(1)] = cljs.core.first((state_30711[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__30893 = state_30711;
state_30711 = G__30893;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto__ = function(state_30711){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto____1.call(this,state_30711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_30817 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_30817[(6)] = c__10835__auto__);

return statearr_30817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__30895 = arguments.length;
switch (G__30895) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_30975){
var state_val_30976 = (state_30975[(1)]);
if((state_val_30976 === (7))){
var inst_30970 = (state_30975[(2)]);
var _ = (function (){var statearr_30977 = state_30975;
(statearr_30977[(4)] = cljs.core.rest((state_30975[(4)])));

return statearr_30977;
})();
var state_30975__$1 = state_30975;
var statearr_30978_31026 = state_30975__$1;
(statearr_30978_31026[(2)] = inst_30970);

(statearr_30978_31026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (20))){
var inst_30935 = (state_30975[(7)]);
var inst_30947 = (state_30975[(2)]);
var inst_30917 = inst_30935;
var inst_30918 = inst_30947;
var state_30975__$1 = (function (){var statearr_30979 = state_30975;
(statearr_30979[(8)] = inst_30918);

(statearr_30979[(9)] = inst_30917);

return statearr_30979;
})();
var statearr_30980_31027 = state_30975__$1;
(statearr_30980_31027[(2)] = null);

(statearr_30980_31027[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (1))){
var state_30975__$1 = state_30975;
var statearr_30981_31028 = state_30975__$1;
(statearr_30981_31028[(2)] = null);

(statearr_30981_31028[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (24))){
var inst_30934 = (state_30975[(10)]);
var inst_30918 = (state_30975[(8)]);
var inst_30935 = (state_30975[(7)]);
var inst_30955 = fluree.db.query.analytical.inner_join(inst_30918,inst_30934);
var inst_30917 = inst_30935;
var inst_30918__$1 = inst_30955;
var state_30975__$1 = (function (){var statearr_30982 = state_30975;
(statearr_30982[(8)] = inst_30918__$1);

(statearr_30982[(9)] = inst_30917);

return statearr_30982;
})();
var statearr_30983_31029 = state_30975__$1;
(statearr_30983_31029[(2)] = null);

(statearr_30983_31029[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (4))){
var inst_30896 = (state_30975[(2)]);
var state_30975__$1 = state_30975;
var statearr_30985_31030 = state_30975__$1;
(statearr_30985_31030[(2)] = inst_30896);

(statearr_30985_31030[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (15))){
var inst_30934 = (state_30975[(10)]);
var state_30975__$1 = state_30975;
if(cljs.core.truth_(inst_30934)){
var statearr_30986_31031 = state_30975__$1;
(statearr_30986_31031[(1)] = (18));

} else {
var statearr_30987_31032 = state_30975__$1;
(statearr_30987_31032[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (21))){
var inst_30918 = (state_30975[(8)]);
var inst_30935 = (state_30975[(7)]);
var tmp30984 = inst_30918;
var inst_30917 = inst_30935;
var inst_30918__$1 = tmp30984;
var state_30975__$1 = (function (){var statearr_30988 = state_30975;
(statearr_30988[(8)] = inst_30918__$1);

(statearr_30988[(9)] = inst_30917);

return statearr_30988;
})();
var statearr_30989_31033 = state_30975__$1;
(statearr_30989_31033[(2)] = null);

(statearr_30989_31033[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (13))){
var inst_30918 = (state_30975[(8)]);
var inst_30941 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_30918,cljs.core.cst$kw$vars);
var inst_30942 = cljs.core.empty_QMARK_(inst_30941);
var state_30975__$1 = state_30975;
if(inst_30942){
var statearr_30990_31034 = state_30975__$1;
(statearr_30990_31034[(1)] = (15));

} else {
var statearr_30991_31035 = state_30975__$1;
(statearr_30991_31035[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (22))){
var state_30975__$1 = state_30975;
var statearr_30992_31036 = state_30975__$1;
(statearr_30992_31036[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (6))){
var inst_30924 = (state_30975[(11)]);
var inst_30917 = (state_30975[(9)]);
var inst_30923 = cljs.core.seq(inst_30917);
var inst_30924__$1 = cljs.core.first(inst_30923);
var inst_30925 = cljs.core.next(inst_30923);
var state_30975__$1 = (function (){var statearr_30994 = state_30975;
(statearr_30994[(12)] = inst_30925);

(statearr_30994[(11)] = inst_30924__$1);

return statearr_30994;
})();
if(cljs.core.truth_(inst_30924__$1)){
var statearr_30995_31037 = state_30975__$1;
(statearr_30995_31037[(1)] = (8));

} else {
var statearr_30996_31038 = state_30975__$1;
(statearr_30996_31038[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (25))){
var state_30975__$1 = state_30975;
var statearr_30997_31039 = state_30975__$1;
(statearr_30997_31039[(2)] = null);

(statearr_30997_31039[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (17))){
var inst_30963 = (state_30975[(2)]);
var state_30975__$1 = state_30975;
var statearr_30998_31040 = state_30975__$1;
(statearr_30998_31040[(2)] = inst_30963);

(statearr_30998_31040[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (3))){
var inst_30973 = (state_30975[(2)]);
var state_30975__$1 = state_30975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30975__$1,inst_30973);
} else {
if((state_val_30976 === (12))){
var inst_30934 = (state_30975[(10)]);
var inst_30935 = (state_30975[(7)]);
var inst_30917 = inst_30935;
var inst_30918 = inst_30934;
var state_30975__$1 = (function (){var statearr_30999 = state_30975;
(statearr_30999[(8)] = inst_30918);

(statearr_30999[(9)] = inst_30917);

return statearr_30999;
})();
var statearr_31000_31041 = state_30975__$1;
(statearr_31000_31041[(2)] = null);

(statearr_31000_31041[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (2))){
var _ = (function (){var statearr_31001 = state_30975;
(statearr_31001[(4)] = cljs.core.cons((5),(state_30975[(4)])));

return statearr_31001;
})();
var inst_30909 = where;
var inst_30910 = cljs.core.seq(inst_30909);
var inst_30911 = cljs.core.first(inst_30910);
var inst_30912 = cljs.core.next(inst_30910);
var inst_30913 = [cljs.core.cst$kw$vars];
var inst_30914 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_30915 = [inst_30914];
var inst_30916 = cljs.core.PersistentHashMap.fromArrays(inst_30913,inst_30915);
var inst_30917 = inst_30909;
var inst_30918 = inst_30916;
var state_30975__$1 = (function (){var statearr_31002 = state_30975;
(statearr_31002[(13)] = inst_30911);

(statearr_31002[(14)] = inst_30912);

(statearr_31002[(8)] = inst_30918);

(statearr_31002[(9)] = inst_30917);

return statearr_31002;
})();
var statearr_31003_31042 = state_30975__$1;
(statearr_31003_31042[(2)] = null);

(statearr_31003_31042[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (23))){
var inst_30961 = (state_30975[(2)]);
var state_30975__$1 = state_30975;
var statearr_31004_31043 = state_30975__$1;
(statearr_31004_31043[(2)] = inst_30961);

(statearr_31004_31043[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (19))){
var inst_30918 = (state_30975[(8)]);
var state_30975__$1 = state_30975;
var statearr_31005_31044 = state_30975__$1;
(statearr_31005_31044[(2)] = inst_30918);

(statearr_31005_31044[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (11))){
var inst_30924 = (state_30975[(11)]);
var inst_30932 = (state_30975[(2)]);
var inst_30933 = fluree.db.util.async.throw_err(inst_30932);
var inst_30934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30933,(0),null);
var inst_30935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30933,(1),null);
var inst_30936 = cljs.core.count(inst_30924);
var inst_30937 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_30936);
var state_30975__$1 = (function (){var statearr_31007 = state_30975;
(statearr_31007[(10)] = inst_30934);

(statearr_31007[(7)] = inst_30935);

return statearr_31007;
})();
if(inst_30937){
var statearr_31008_31045 = state_30975__$1;
(statearr_31008_31045[(1)] = (12));

} else {
var statearr_31009_31046 = state_30975__$1;
(statearr_31009_31046[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (9))){
var inst_30918 = (state_30975[(8)]);
var state_30975__$1 = state_30975;
var statearr_31010_31047 = state_30975__$1;
(statearr_31010_31047[(2)] = inst_30918);

(statearr_31010_31047[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (5))){
var _ = (function (){var statearr_31011 = state_30975;
(statearr_31011[(4)] = cljs.core.rest((state_30975[(4)])));

return statearr_31011;
})();
var state_30975__$1 = state_30975;
var ex31006 = (state_30975__$1[(2)]);
var statearr_31012_31048 = state_30975__$1;
(statearr_31012_31048[(5)] = ex31006);


if((ex31006 instanceof Error)){
var statearr_31013_31049 = state_30975__$1;
(statearr_31013_31049[(1)] = (4));

(statearr_31013_31049[(5)] = null);

} else {
throw ex31006;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (14))){
var inst_30965 = (state_30975[(2)]);
var state_30975__$1 = state_30975;
var statearr_31014_31050 = state_30975__$1;
(statearr_31014_31050[(2)] = inst_30965);

(statearr_31014_31050[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (26))){
var inst_30959 = (state_30975[(2)]);
var state_30975__$1 = state_30975;
var statearr_31015_31051 = state_30975__$1;
(statearr_31015_31051[(2)] = inst_30959);

(statearr_31015_31051[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (16))){
var inst_30934 = (state_30975[(10)]);
var inst_30950 = (inst_30934 == null);
var state_30975__$1 = state_30975;
if(cljs.core.truth_(inst_30950)){
var statearr_31016_31052 = state_30975__$1;
(statearr_31016_31052[(1)] = (21));

} else {
var statearr_31017_31053 = state_30975__$1;
(statearr_31017_31053[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (10))){
var inst_30968 = (state_30975[(2)]);
var state_30975__$1 = state_30975;
var statearr_31018_31054 = state_30975__$1;
(statearr_31018_31054[(2)] = inst_30968);

(statearr_31018_31054[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (18))){
var inst_30934 = (state_30975[(10)]);
var state_30975__$1 = state_30975;
var statearr_31019_31055 = state_30975__$1;
(statearr_31019_31055[(2)] = inst_30934);

(statearr_31019_31055[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30976 === (8))){
var inst_30925 = (state_30975[(12)]);
var inst_30924 = (state_30975[(11)]);
var inst_30918 = (state_30975[(8)]);
var inst_30930 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_30918,inst_30924,inst_30925,false,fuel,max_fuel,opts);
var state_30975__$1 = state_30975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30975__$1,(11),inst_30930);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__10798__auto__ = null;
var fluree$db$query$analytical$state_machine__10798__auto____0 = (function (){
var statearr_31020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31020[(0)] = fluree$db$query$analytical$state_machine__10798__auto__);

(statearr_31020[(1)] = (1));

return statearr_31020;
});
var fluree$db$query$analytical$state_machine__10798__auto____1 = (function (state_30975){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_30975);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e31021){var ex__10801__auto__ = e31021;
var statearr_31022_31056 = state_30975;
(statearr_31022_31056[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_30975[(4)]))){
var statearr_31023_31057 = state_30975;
(statearr_31023_31057[(1)] = cljs.core.first((state_30975[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__31058 = state_30975;
state_30975 = G__31058;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__10798__auto__ = function(state_30975){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__10798__auto____1.call(this,state_30975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__10798__auto____0;
fluree$db$query$analytical$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__10798__auto____1;
return fluree$db$query$analytical$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_31024 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_31024[(6)] = c__10835__auto__);

return statearr_31024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_31093){
var state_val_31094 = (state_31093[(1)]);
if((state_val_31094 === (7))){
var inst_31070 = (state_31093[(7)]);
var inst_31075 = (state_31093[(8)]);
var inst_31077 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_31070,inst_31075,fuel,max_fuel,opts);
var state_31093__$1 = state_31093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31093__$1,(10),inst_31077);
} else {
if((state_val_31094 === (1))){
var state_31093__$1 = state_31093;
var statearr_31095_31120 = state_31093__$1;
(statearr_31095_31120[(2)] = null);

(statearr_31095_31120[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31094 === (4))){
var inst_31059 = (state_31093[(2)]);
var state_31093__$1 = state_31093;
var statearr_31096_31121 = state_31093__$1;
(statearr_31096_31121[(2)] = inst_31059);

(statearr_31096_31121[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31094 === (13))){
var inst_31088 = (state_31093[(2)]);
var _ = (function (){var statearr_31097 = state_31093;
(statearr_31097[(4)] = cljs.core.rest((state_31093[(4)])));

return statearr_31097;
})();
var state_31093__$1 = state_31093;
var statearr_31098_31122 = state_31093__$1;
(statearr_31098_31122[(2)] = inst_31088);

(statearr_31098_31122[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31094 === (6))){
var inst_31070 = (state_31093[(7)]);
var inst_31074 = (state_31093[(2)]);
var inst_31075 = fluree.db.util.async.throw_err(inst_31074);
var state_31093__$1 = (function (){var statearr_31099 = state_31093;
(statearr_31099[(8)] = inst_31075);

return statearr_31099;
})();
if(cljs.core.truth_(inst_31070)){
var statearr_31100_31123 = state_31093__$1;
(statearr_31100_31123[(1)] = (7));

} else {
var statearr_31101_31124 = state_31093__$1;
(statearr_31101_31124[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31094 === (3))){
var inst_31091 = (state_31093[(2)]);
var state_31093__$1 = state_31093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31093__$1,inst_31091);
} else {
if((state_val_31094 === (12))){
var inst_31083 = (state_31093[(9)]);
var state_31093__$1 = state_31093;
var statearr_31102_31125 = state_31093__$1;
(statearr_31102_31125[(2)] = inst_31083);

(statearr_31102_31125[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31094 === (2))){
var _ = (function (){var statearr_31103 = state_31093;
(statearr_31103[(4)] = cljs.core.cons((5),(state_31093[(4)])));

return statearr_31103;
})();
var inst_31066 = q_map;
var inst_31067 = cljs.core.__destructure_map(inst_31066);
var inst_31068 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31067,cljs.core.cst$kw$vars);
var inst_31069 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31067,cljs.core.cst$kw$where);
var inst_31070 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31067,cljs.core.cst$kw$optional);
var inst_31071 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31067,cljs.core.cst$kw$filter);
var inst_31072 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_31069,q_map,inst_31068,fuel,max_fuel,opts);
var state_31093__$1 = (function (){var statearr_31104 = state_31093;
(statearr_31104[(10)] = inst_31071);

(statearr_31104[(7)] = inst_31070);

return statearr_31104;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31093__$1,(6),inst_31072);
} else {
if((state_val_31094 === (11))){
var inst_31071 = (state_31093[(10)]);
var inst_31083 = (state_31093[(9)]);
var inst_31085 = fluree.db.query.analytical.tuples__GT_filtered(inst_31083,inst_31071,null);
var state_31093__$1 = state_31093;
var statearr_31106_31126 = state_31093__$1;
(statearr_31106_31126[(2)] = inst_31085);

(statearr_31106_31126[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31094 === (9))){
var inst_31071 = (state_31093[(10)]);
var inst_31083 = (state_31093[(2)]);
var state_31093__$1 = (function (){var statearr_31107 = state_31093;
(statearr_31107[(9)] = inst_31083);

return statearr_31107;
})();
if(cljs.core.truth_(inst_31071)){
var statearr_31108_31127 = state_31093__$1;
(statearr_31108_31127[(1)] = (11));

} else {
var statearr_31109_31128 = state_31093__$1;
(statearr_31109_31128[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31094 === (5))){
var _ = (function (){var statearr_31110 = state_31093;
(statearr_31110[(4)] = cljs.core.rest((state_31093[(4)])));

return statearr_31110;
})();
var state_31093__$1 = state_31093;
var ex31105 = (state_31093__$1[(2)]);
var statearr_31111_31129 = state_31093__$1;
(statearr_31111_31129[(5)] = ex31105);


if((ex31105 instanceof Error)){
var statearr_31112_31130 = state_31093__$1;
(statearr_31112_31130[(1)] = (4));

(statearr_31112_31130[(5)] = null);

} else {
throw ex31105;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31094 === (10))){
var inst_31079 = (state_31093[(2)]);
var inst_31080 = fluree.db.util.async.throw_err(inst_31079);
var state_31093__$1 = state_31093;
var statearr_31113_31131 = state_31093__$1;
(statearr_31113_31131[(2)] = inst_31080);

(statearr_31113_31131[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31094 === (8))){
var inst_31075 = (state_31093[(8)]);
var state_31093__$1 = state_31093;
var statearr_31114_31132 = state_31093__$1;
(statearr_31114_31132[(2)] = inst_31075);

(statearr_31114_31132[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__10798__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__10798__auto____0 = (function (){
var statearr_31115 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31115[(0)] = fluree$db$query$analytical$q_$_state_machine__10798__auto__);

(statearr_31115[(1)] = (1));

return statearr_31115;
});
var fluree$db$query$analytical$q_$_state_machine__10798__auto____1 = (function (state_31093){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_31093);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e31116){var ex__10801__auto__ = e31116;
var statearr_31117_31133 = state_31093;
(statearr_31117_31133[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_31093[(4)]))){
var statearr_31118_31134 = state_31093;
(statearr_31118_31134[(1)] = cljs.core.first((state_31093[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__31135 = state_31093;
state_31093 = G__31135;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__10798__auto__ = function(state_31093){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__10798__auto____1.call(this,state_31093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__10798__auto____0;
fluree$db$query$analytical$q_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__10798__auto____1;
return fluree$db$query$analytical$q_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_31119 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_31119[(6)] = c__10835__auto__);

return statearr_31119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
