// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37430 = arguments.length;
var i__4830__auto___37431 = (0);
while(true){
if((i__4830__auto___37431 < len__4829__auto___37430)){
args__4835__auto__.push((arguments[i__4830__auto___37431]));

var G__37432 = (i__4830__auto___37431 + (1));
i__4830__auto___37431 = G__37432;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq37427){
var G__37428 = cljs.core.first(seq37427);
var seq37427__$1 = cljs.core.next(seq37427);
var G__37429 = cljs.core.first(seq37427__$1);
var seq37427__$2 = cljs.core.next(seq37427__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37428,G__37429,seq37427__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e37433){var e = e37433;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e37434){var e = e37434;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e37435){var e = e37435;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e37436){var e = e37436;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e37437){var e = e37437;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37440 = arguments.length;
var i__4830__auto___37441 = (0);
while(true){
if((i__4830__auto___37441 < len__4829__auto___37440)){
args__4835__auto__.push((arguments[i__4830__auto___37441]));

var G__37442 = (i__4830__auto___37441 + (1));
i__4830__auto___37441 = G__37442;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e37439){var e = e37439;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq37438){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37438));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37445 = arguments.length;
var i__4830__auto___37446 = (0);
while(true){
if((i__4830__auto___37446 < len__4829__auto___37445)){
args__4835__auto__.push((arguments[i__4830__auto___37446]));

var G__37447 = (i__4830__auto___37446 + (1));
i__4830__auto___37446 = G__37447;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e37444){var e = e37444;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq37443){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37443));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e37448){var e = e37448;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37451 = arguments.length;
var i__4830__auto___37452 = (0);
while(true){
if((i__4830__auto___37452 < len__4829__auto___37451)){
args__4835__auto__.push((arguments[i__4830__auto___37452]));

var G__37453 = (i__4830__auto___37452 + (1));
i__4830__auto___37452 = G__37453;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e37450){var e = e37450;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq37449){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37449));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37456 = arguments.length;
var i__4830__auto___37457 = (0);
while(true){
if((i__4830__auto___37457 < len__4829__auto___37456)){
args__4835__auto__.push((arguments[i__4830__auto___37457]));

var G__37458 = (i__4830__auto___37457 + (1));
i__4830__auto___37457 = G__37458;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e37455){var e = e37455;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq37454){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37454));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e37459){var e = e37459;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e37460){var e = e37460;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37463 = arguments.length;
var i__4830__auto___37464 = (0);
while(true){
if((i__4830__auto___37464 < len__4829__auto___37463)){
args__4835__auto__.push((arguments[i__4830__auto___37464]));

var G__37465 = (i__4830__auto___37464 + (1));
i__4830__auto___37464 = G__37465;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e37462){var e = e37462;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq37461){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37461));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37468 = arguments.length;
var i__4830__auto___37469 = (0);
while(true){
if((i__4830__auto___37469 < len__4829__auto___37468)){
args__4835__auto__.push((arguments[i__4830__auto___37469]));

var G__37470 = (i__4830__auto___37469 + (1));
i__4830__auto___37469 = G__37470;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e37467){var e = e37467;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq37466){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37466));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37473 = arguments.length;
var i__4830__auto___37474 = (0);
while(true){
if((i__4830__auto___37474 < len__4829__auto___37473)){
args__4835__auto__.push((arguments[i__4830__auto___37474]));

var G__37475 = (i__4830__auto___37474 + (1));
i__4830__auto___37474 = G__37475;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e37472){var e = e37472;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq37471){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37471));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37478 = arguments.length;
var i__4830__auto___37479 = (0);
while(true){
if((i__4830__auto___37479 < len__4829__auto___37478)){
args__4835__auto__.push((arguments[i__4830__auto___37479]));

var G__37480 = (i__4830__auto___37479 + (1));
i__4830__auto___37479 = G__37480;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e37477){var e = e37477;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq37476){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37476));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37483 = arguments.length;
var i__4830__auto___37484 = (0);
while(true){
if((i__4830__auto___37484 < len__4829__auto___37483)){
args__4835__auto__.push((arguments[i__4830__auto___37484]));

var G__37485 = (i__4830__auto___37484 + (1));
i__4830__auto___37484 = G__37485;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e37482){var e = e37482;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq37481){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37481));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37488 = arguments.length;
var i__4830__auto___37489 = (0);
while(true){
if((i__4830__auto___37489 < len__4829__auto___37488)){
args__4835__auto__.push((arguments[i__4830__auto___37489]));

var G__37490 = (i__4830__auto___37489 + (1));
i__4830__auto___37489 = G__37490;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e37487){var e = e37487;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq37486){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37486));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37493 = arguments.length;
var i__4830__auto___37494 = (0);
while(true){
if((i__4830__auto___37494 < len__4829__auto___37493)){
args__4835__auto__.push((arguments[i__4830__auto___37494]));

var G__37495 = (i__4830__auto___37494 + (1));
i__4830__auto___37494 = G__37495;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e37492){var e = e37492;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq37491){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37491));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__37497 = arguments.length;
switch (G__37497) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_37525){
var state_val_37526 = (state_37525[(1)]);
if((state_val_37526 === (7))){
var inst_37510 = (state_37525[(7)]);
var inst_37513 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_37510,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_37525__$1 = state_37525;
var statearr_37527_37613 = state_37525__$1;
(statearr_37527_37613[(2)] = inst_37513);

(statearr_37527_37613[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37526 === (1))){
var state_37525__$1 = state_37525;
var statearr_37528_37614 = state_37525__$1;
(statearr_37528_37614[(2)] = null);

(statearr_37528_37614[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37526 === (4))){
var inst_37498 = (state_37525[(2)]);
var state_37525__$1 = state_37525;
var statearr_37529_37615 = state_37525__$1;
(statearr_37529_37615[(2)] = inst_37498);

(statearr_37529_37615[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37526 === (6))){
var inst_37510 = (state_37525[(7)]);
var inst_37510__$1 = (state_37525[(2)]);
var inst_37511 = fluree.db.util.core.exception_QMARK_(inst_37510__$1);
var state_37525__$1 = (function (){var statearr_37530 = state_37525;
(statearr_37530[(7)] = inst_37510__$1);

return statearr_37530;
})();
if(inst_37511){
var statearr_37531_37616 = state_37525__$1;
(statearr_37531_37616[(1)] = (7));

} else {
var statearr_37532_37617 = state_37525__$1;
(statearr_37532_37617[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37526 === (3))){
var inst_37523 = (state_37525[(2)]);
var state_37525__$1 = state_37525;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37525__$1,inst_37523);
} else {
if((state_val_37526 === (2))){
var inst_37504 = (state_37525[(8)]);
var _ = (function (){var statearr_37534 = state_37525;
(statearr_37534[(4)] = cljs.core.cons((5),(state_37525[(4)])));

return statearr_37534;
})();
var inst_37504__$1 = cljs.core.volatile_BANG_((0));
var inst_37505 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_37506 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_37505,cljs.core.cst$kw$fuel,inst_37504__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_37507 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_37506);
var inst_37508 = fluree.db.query.fql.query(db,inst_37507);
var state_37525__$1 = (function (){var statearr_37535 = state_37525;
(statearr_37535[(8)] = inst_37504__$1);

return statearr_37535;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37525__$1,(6),inst_37508);
} else {
if((state_val_37526 === (9))){
var inst_37520 = (state_37525[(2)]);
var _ = (function (){var statearr_37536 = state_37525;
(statearr_37536[(4)] = cljs.core.rest((state_37525[(4)])));

return statearr_37536;
})();
var state_37525__$1 = state_37525;
var statearr_37537_37618 = state_37525__$1;
(statearr_37537_37618[(2)] = inst_37520);

(statearr_37537_37618[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37526 === (5))){
var _ = (function (){var statearr_37538 = state_37525;
(statearr_37538[(4)] = cljs.core.rest((state_37525[(4)])));

return statearr_37538;
})();
var state_37525__$1 = state_37525;
var ex37533 = (state_37525__$1[(2)]);
var statearr_37539_37619 = state_37525__$1;
(statearr_37539_37619[(5)] = ex37533);


if((ex37533 instanceof Error)){
var statearr_37540_37620 = state_37525__$1;
(statearr_37540_37620[(1)] = (4));

(statearr_37540_37620[(5)] = null);

} else {
throw ex37533;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37526 === (8))){
var inst_37504 = (state_37525[(8)]);
var inst_37510 = (state_37525[(7)]);
var inst_37515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37516 = cljs.core.deref(inst_37504);
var inst_37517 = [inst_37510,inst_37516];
var inst_37518 = (new cljs.core.PersistentVector(null,2,(5),inst_37515,inst_37517,null));
var state_37525__$1 = state_37525;
var statearr_37541_37621 = state_37525__$1;
(statearr_37541_37621[(2)] = inst_37518);

(statearr_37541_37621[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10841__auto____0 = (function (){
var statearr_37542 = [null,null,null,null,null,null,null,null,null];
(statearr_37542[(0)] = fluree$db$dbfunctions$internal$state_machine__10841__auto__);

(statearr_37542[(1)] = (1));

return statearr_37542;
});
var fluree$db$dbfunctions$internal$state_machine__10841__auto____1 = (function (state_37525){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_37525);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e37543){var ex__10844__auto__ = e37543;
var statearr_37544_37622 = state_37525;
(statearr_37544_37622[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_37525[(4)]))){
var statearr_37545_37623 = state_37525;
(statearr_37545_37623[(1)] = cljs.core.first((state_37525[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__37624 = state_37525;
state_37525 = G__37624;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10841__auto__ = function(state_37525){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10841__auto____1.call(this,state_37525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_37546 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_37546[(6)] = c__10878__auto__);

return statearr_37546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_37591){
var state_val_37592 = (state_37591[(1)]);
if((state_val_37592 === (7))){
var inst_37577 = (state_37591[(2)]);
var inst_37578 = fluree.db.query.fql.query(db,inst_37577);
var state_37591__$1 = state_37591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37591__$1,(8),inst_37578);
} else {
if((state_val_37592 === (1))){
var inst_37547 = typeof select === 'string';
var state_37591__$1 = state_37591;
if(cljs.core.truth_(inst_37547)){
var statearr_37593_37625 = state_37591__$1;
(statearr_37593_37625[(1)] = (2));

} else {
var statearr_37594_37626 = state_37591__$1;
(statearr_37594_37626[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37592 === (4))){
var inst_37560 = (state_37591[(7)]);
var inst_37553 = (state_37591[(8)]);
var inst_37552 = (state_37591[(2)]);
var inst_37553__$1 = cljs.core.volatile_BANG_((0));
var inst_37554 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_37555 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_37556 = [inst_37553__$1,(100000)];
var inst_37557 = cljs.core.PersistentHashMap.fromArrays(inst_37555,inst_37556);
var inst_37558 = [inst_37552,from,where,block,limit,inst_37557];
var inst_37559 = cljs.core.PersistentHashMap.fromArrays(inst_37554,inst_37558);
var inst_37560__$1 = fluree.db.util.core.without_nils(inst_37559);
var inst_37561 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_37560__$1);
var inst_37562 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_37560__$1);
var inst_37563 = cljs.core.first(inst_37562);
var inst_37564 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37563], 0));
var inst_37565 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_37564);
var inst_37566 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_37560__$1);
var inst_37567 = cljs.core.last(inst_37566);
var inst_37568 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37567], 0));
var inst_37569 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_37568);
var inst_37570 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37561,inst_37565,inst_37569], 0));
var state_37591__$1 = (function (){var statearr_37595 = state_37591;
(statearr_37595[(7)] = inst_37560__$1);

(statearr_37595[(8)] = inst_37553__$1);

return statearr_37595;
})();
if(cljs.core.truth_(inst_37570)){
var statearr_37596_37627 = state_37591__$1;
(statearr_37596_37627[(1)] = (5));

} else {
var statearr_37597_37628 = state_37591__$1;
(statearr_37597_37628[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37592 === (6))){
var inst_37560 = (state_37591[(7)]);
var state_37591__$1 = state_37591;
var statearr_37598_37629 = state_37591__$1;
(statearr_37598_37629[(2)] = inst_37560);

(statearr_37598_37629[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37592 === (3))){
var state_37591__$1 = state_37591;
var statearr_37599_37630 = state_37591__$1;
(statearr_37599_37630[(2)] = select);

(statearr_37599_37630[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37592 === (2))){
var inst_37549 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_37591__$1 = state_37591;
var statearr_37600_37631 = state_37591__$1;
(statearr_37600_37631[(2)] = inst_37549);

(statearr_37600_37631[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37592 === (11))){
var inst_37589 = (state_37591[(2)]);
var state_37591__$1 = state_37591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37591__$1,inst_37589);
} else {
if((state_val_37592 === (9))){
var inst_37580 = (state_37591[(9)]);
var state_37591__$1 = state_37591;
var statearr_37601_37632 = state_37591__$1;
(statearr_37601_37632[(2)] = inst_37580);

(statearr_37601_37632[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37592 === (5))){
var inst_37560 = (state_37591[(7)]);
var inst_37572 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_37560);
var inst_37573 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_37572);
var inst_37574 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37560,cljs.core.cst$kw$where,inst_37573);
var state_37591__$1 = state_37591;
var statearr_37602_37633 = state_37591__$1;
(statearr_37602_37633[(2)] = inst_37574);

(statearr_37602_37633[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37592 === (10))){
var inst_37553 = (state_37591[(8)]);
var inst_37580 = (state_37591[(9)]);
var inst_37584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37585 = cljs.core.deref(inst_37553);
var inst_37586 = [inst_37580,inst_37585];
var inst_37587 = (new cljs.core.PersistentVector(null,2,(5),inst_37584,inst_37586,null));
var state_37591__$1 = state_37591;
var statearr_37603_37634 = state_37591__$1;
(statearr_37603_37634[(2)] = inst_37587);

(statearr_37603_37634[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37592 === (8))){
var inst_37580 = (state_37591[(9)]);
var inst_37580__$1 = (state_37591[(2)]);
var inst_37581 = fluree.db.util.core.exception_QMARK_(inst_37580__$1);
var state_37591__$1 = (function (){var statearr_37604 = state_37591;
(statearr_37604[(9)] = inst_37580__$1);

return statearr_37604;
})();
if(inst_37581){
var statearr_37605_37635 = state_37591__$1;
(statearr_37605_37635[(1)] = (9));

} else {
var statearr_37606_37636 = state_37591__$1;
(statearr_37606_37636[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10841__auto____0 = (function (){
var statearr_37607 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37607[(0)] = fluree$db$dbfunctions$internal$state_machine__10841__auto__);

(statearr_37607[(1)] = (1));

return statearr_37607;
});
var fluree$db$dbfunctions$internal$state_machine__10841__auto____1 = (function (state_37591){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_37591);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e37608){var ex__10844__auto__ = e37608;
var statearr_37609_37637 = state_37591;
(statearr_37609_37637[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_37591[(4)]))){
var statearr_37610_37638 = state_37591;
(statearr_37610_37638[(1)] = cljs.core.first((state_37591[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__37639 = state_37591;
state_37591 = G__37639;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10841__auto__ = function(state_37591){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10841__auto____1.call(this,state_37591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_37611 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_37611[(6)] = c__10878__auto__);

return statearr_37611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__37643 = path;
var vec__37644 = G__37643;
var seq__37645 = cljs.core.seq(vec__37644);
var first__37646 = cljs.core.first(seq__37645);
var seq__37645__$1 = cljs.core.next(seq__37645);
var var$ = first__37646;
var r = seq__37645__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__37643__$1 = G__37643;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__37650 = G__37643__$1;
var seq__37651 = cljs.core.seq(vec__37650);
var first__37652 = cljs.core.first(seq__37651);
var seq__37651__$1 = cljs.core.next(seq__37651);
var var$__$1 = first__37652;
var r__$1 = seq__37651__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__37653 = r__$1;
var G__37654 = n__$2;
var G__37655 = next_clauses;
G__37643__$1 = G__37653;
n__$1 = G__37654;
where_clauses__$1 = G__37655;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__37656 = r__$1;
var G__37657 = next_n;
var G__37658 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__37643__$1 = G__37656;
n__$1 = G__37657;
where_clauses__$1 = G__37658;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_37695){
var state_val_37696 = (state_37695[(1)]);
if((state_val_37696 === (7))){
var inst_37668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37669 = [path];
var inst_37670 = (new cljs.core.PersistentVector(null,1,(5),inst_37668,inst_37669,null));
var state_37695__$1 = state_37695;
var statearr_37697_37725 = state_37695__$1;
(statearr_37697_37725[(2)] = inst_37670);

(statearr_37697_37725[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (1))){
var state_37695__$1 = state_37695;
var statearr_37698_37726 = state_37695__$1;
(statearr_37698_37726[(2)] = null);

(statearr_37698_37726[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (4))){
var inst_37659 = (state_37695[(2)]);
var state_37695__$1 = state_37695;
var statearr_37699_37727 = state_37695__$1;
(statearr_37699_37727[(2)] = inst_37659);

(statearr_37699_37727[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (13))){
var inst_37686 = (state_37695[(2)]);
var inst_37687 = fluree.db.util.async.throw_err(inst_37686);
var _ = (function (){var statearr_37700 = state_37695;
(statearr_37700[(4)] = cljs.core.rest((state_37695[(4)])));

return statearr_37700;
})();
var state_37695__$1 = state_37695;
var statearr_37701_37728 = state_37695__$1;
(statearr_37701_37728[(2)] = inst_37687);

(statearr_37701_37728[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (6))){
var state_37695__$1 = state_37695;
var statearr_37703_37729 = state_37695__$1;
(statearr_37703_37729[(2)] = path);

(statearr_37703_37729[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (3))){
var inst_37693 = (state_37695[(2)]);
var state_37695__$1 = state_37695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37695__$1,inst_37693);
} else {
if((state_val_37696 === (12))){
var _ = (function (){var statearr_37704 = state_37695;
(statearr_37704[(4)] = cljs.core.rest((state_37695[(4)])));

return statearr_37704;
})();
var state_37695__$1 = state_37695;
var ex37702 = (state_37695__$1[(2)]);
var statearr_37705_37730 = state_37695__$1;
(statearr_37705_37730[(5)] = ex37702);


var statearr_37706_37731 = state_37695__$1;
(statearr_37706_37731[(1)] = (11));

(statearr_37706_37731[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (2))){
var _ = (function (){var statearr_37707 = state_37695;
(statearr_37707[(4)] = cljs.core.cons((5),(state_37695[(4)])));

return statearr_37707;
})();
var inst_37665 = cljs.core.vector_QMARK_(path);
var state_37695__$1 = state_37695;
if(inst_37665){
var statearr_37708_37732 = state_37695__$1;
(statearr_37708_37732[(1)] = (6));

} else {
var statearr_37709_37733 = state_37695__$1;
(statearr_37709_37733[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (11))){
var inst_37672 = (state_37695[(7)]);
var inst_37677 = (state_37695[(2)]);
var inst_37678 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_37677,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_37672,endSubject], 0));
var state_37695__$1 = state_37695;
var statearr_37711_37734 = state_37695__$1;
(statearr_37711_37734[(2)] = inst_37678);

(statearr_37711_37734[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (9))){
var inst_37676 = (state_37695[(8)]);
var _ = (function (){var statearr_37712 = state_37695;
(statearr_37712[(4)] = cljs.core.cons((12),(state_37695[(4)])));

return statearr_37712;
})();
var inst_37684 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_37676);
var state_37695__$1 = state_37695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37695__$1,(13),inst_37684);
} else {
if((state_val_37696 === (5))){
var _ = (function (){var statearr_37713 = state_37695;
(statearr_37713[(4)] = cljs.core.rest((state_37695[(4)])));

return statearr_37713;
})();
var state_37695__$1 = state_37695;
var ex37710 = (state_37695__$1[(2)]);
var statearr_37714_37735 = state_37695__$1;
(statearr_37714_37735[(5)] = ex37710);


if((ex37710 instanceof Error)){
var statearr_37715_37736 = state_37695__$1;
(statearr_37715_37736[(1)] = (4));

(statearr_37715_37736[(5)] = null);

} else {
throw ex37710;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (10))){
var inst_37690 = (state_37695[(2)]);
var _ = (function (){var statearr_37716 = state_37695;
(statearr_37716[(4)] = cljs.core.rest((state_37695[(4)])));

return statearr_37716;
})();
var state_37695__$1 = state_37695;
var statearr_37717_37737 = state_37695__$1;
(statearr_37717_37737[(2)] = inst_37690);

(statearr_37717_37737[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (8))){
var inst_37672 = (state_37695[(7)]);
var inst_37672__$1 = (state_37695[(2)]);
var inst_37673 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_37672__$1,endSubject);
var inst_37674 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_37675 = ["?var1",inst_37673];
var inst_37676 = cljs.core.PersistentHashMap.fromArrays(inst_37674,inst_37675);
var state_37695__$1 = (function (){var statearr_37718 = state_37695;
(statearr_37718[(7)] = inst_37672__$1);

(statearr_37718[(8)] = inst_37676);

return statearr_37718;
})();
var statearr_37719_37738 = state_37695__$1;
(statearr_37719_37738[(2)] = null);

(statearr_37719_37738[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto____0 = (function (){
var statearr_37720 = [null,null,null,null,null,null,null,null,null];
(statearr_37720[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto__);

(statearr_37720[(1)] = (1));

return statearr_37720;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto____1 = (function (state_37695){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_37695);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e37721){var ex__10844__auto__ = e37721;
var statearr_37722_37739 = state_37695;
(statearr_37722_37739[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_37695[(4)]))){
var statearr_37723_37740 = state_37695;
(statearr_37723_37740[(1)] = cljs.core.first((state_37695[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__37741 = state_37695;
state_37695 = G__37741;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto__ = function(state_37695){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto____1.call(this,state_37695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_37724 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_37724[(6)] = c__10878__auto__);

return statearr_37724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e37742){var e = e37742;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e37743){var e = e37743;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e37744){var e = e37744;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e37745){var e = e37745;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37748 = arguments.length;
var i__4830__auto___37749 = (0);
while(true){
if((i__4830__auto___37749 < len__4829__auto___37748)){
args__4835__auto__.push((arguments[i__4830__auto___37749]));

var G__37750 = (i__4830__auto___37749 + (1));
i__4830__auto___37749 = G__37750;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e37747){var e = e37747;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq37746){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37746));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37753 = arguments.length;
var i__4830__auto___37754 = (0);
while(true){
if((i__4830__auto___37754 < len__4829__auto___37753)){
args__4835__auto__.push((arguments[i__4830__auto___37754]));

var G__37755 = (i__4830__auto___37754 + (1));
i__4830__auto___37754 = G__37755;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e37752){var e = e37752;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq37751){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37751));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37758 = arguments.length;
var i__4830__auto___37759 = (0);
while(true){
if((i__4830__auto___37759 < len__4829__auto___37758)){
args__4835__auto__.push((arguments[i__4830__auto___37759]));

var G__37760 = (i__4830__auto___37759 + (1));
i__4830__auto___37759 = G__37760;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4223__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e37757){var e = e37757;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq37756){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37756));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37763 = arguments.length;
var i__4830__auto___37764 = (0);
while(true){
if((i__4830__auto___37764 < len__4829__auto___37763)){
args__4835__auto__.push((arguments[i__4830__auto___37764]));

var G__37765 = (i__4830__auto___37764 + (1));
i__4830__auto___37764 = G__37765;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e37762){var e = e37762;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq37761){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37761));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e37766){var e = e37766;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e37767){var e = e37767;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e37768){var e = e37768;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e37769){var e = e37769;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e37770){var e = e37770;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__37776 = path;
var vec__37777 = G__37776;
var seq__37778 = cljs.core.seq(vec__37777);
var first__37779 = cljs.core.first(seq__37778);
var seq__37778__$1 = cljs.core.next(seq__37778);
var pred = first__37779;
var r = seq__37778__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__37776__$1 = G__37776;
var subjects__$1 = subjects;
while(true){
var vec__37783 = G__37776__$1;
var seq__37784 = cljs.core.seq(vec__37783);
var first__37785 = cljs.core.first(seq__37784);
var seq__37784__$1 = cljs.core.next(seq__37784);
var pred__$1 = first__37785;
var r__$1 = seq__37784__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__37776__$1,subjects__$1,vec__37783,seq__37784,first__37785,seq__37784__$1,pred__$1,r__$1,subjects__$2,G__37776,vec__37777,seq__37778,first__37779,seq__37778__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__37776__$1,subjects__$1,vec__37783,seq__37784,first__37785,seq__37784__$1,pred__$1,r__$1,subjects__$2,G__37776,vec__37777,seq__37778,first__37779,seq__37778__$1,pred,r,subjects){
return (function (p1__37771_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__37771_SHARP_,pred__$1);
});})(G__37776__$1,subjects__$1,vec__37783,seq__37784,first__37785,seq__37784__$1,pred__$1,r__$1,subjects__$2,G__37776,vec__37777,seq__37778,first__37779,seq__37778__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__37776__$1,subjects__$1,vec__37783,seq__37784,first__37785,seq__37784__$1,pred__$1,r__$1,subjects__$2,G__37776,vec__37777,seq__37778,first__37779,seq__37778__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4221__auto__ = r__$1;
if(and__4221__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4221__auto__;
}
})())){
var G__37786 = r__$1;
var G__37787 = next_subjects;
G__37776__$1 = G__37786;
subjects__$1 = G__37787;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e37772){var e = e37772;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e37788){var e = e37788;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e37789){var e = e37789;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37792 = arguments.length;
var i__4830__auto___37793 = (0);
while(true){
if((i__4830__auto___37793 < len__4829__auto___37792)){
args__4835__auto__.push((arguments[i__4830__auto___37793]));

var G__37794 = (i__4830__auto___37793 + (1));
i__4830__auto___37793 = G__37794;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e37791){var e = e37791;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq37790){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37790));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e37795){var e = e37795;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37798 = arguments.length;
var i__4830__auto___37799 = (0);
while(true){
if((i__4830__auto___37799 < len__4829__auto___37798)){
args__4835__auto__.push((arguments[i__4830__auto___37799]));

var G__37800 = (i__4830__auto___37799 + (1));
i__4830__auto___37799 = G__37800;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e37797){var e = e37797;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq37796){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37796));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e37801){var e = e37801;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_37856){
var state_val_37857 = (state_37856[(1)]);
if((state_val_37857 === (7))){
var inst_37803 = (state_37856[(2)]);
var state_37856__$1 = state_37856;
var statearr_37858_37891 = state_37856__$1;
(statearr_37858_37891[(2)] = inst_37803);

(statearr_37858_37891[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (1))){
var state_37856__$1 = state_37856;
var statearr_37859_37892 = state_37856__$1;
(statearr_37859_37892[(2)] = null);

(statearr_37859_37892[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (4))){
var inst_37802 = (state_37856[(2)]);
var state_37856__$1 = (function (){var statearr_37860 = state_37856;
(statearr_37860[(7)] = inst_37802);

return statearr_37860;
})();
var statearr_37861_37893 = state_37856__$1;
(statearr_37861_37893[(2)] = null);

(statearr_37861_37893[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (15))){
var inst_37840 = (state_37856[(8)]);
var inst_37844 = inst_37840.o;
var state_37856__$1 = state_37856;
var statearr_37862_37894 = state_37856__$1;
(statearr_37862_37894[(2)] = inst_37844);

(statearr_37862_37894[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (13))){
var inst_37840 = (state_37856[(8)]);
var inst_37836 = (state_37856[(2)]);
var inst_37837 = fluree.db.util.async.throw_err(inst_37836);
var inst_37838 = fluree.db.dbfunctions.internal.count(inst_37837);
var inst_37840__$1 = cljs.core.first(inst_37837);
var inst_37841 = (inst_37840__$1 == null);
var state_37856__$1 = (function (){var statearr_37863 = state_37856;
(statearr_37863[(8)] = inst_37840__$1);

(statearr_37863[(9)] = inst_37838);

return statearr_37863;
})();
if(cljs.core.truth_(inst_37841)){
var statearr_37864_37895 = state_37856__$1;
(statearr_37864_37895[(1)] = (14));

} else {
var statearr_37865_37896 = state_37856__$1;
(statearr_37865_37896[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (6))){
var inst_37812 = (state_37856[(2)]);
var state_37856__$1 = state_37856;
var statearr_37866_37897 = state_37856__$1;
(statearr_37866_37897[(2)] = inst_37812);

(statearr_37866_37897[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (3))){
var inst_37854 = (state_37856[(2)]);
var state_37856__$1 = state_37856;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37856__$1,inst_37854);
} else {
if((state_val_37857 === (12))){
var inst_37851 = (state_37856[(2)]);
var _ = (function (){var statearr_37867 = state_37856;
(statearr_37867[(4)] = cljs.core.rest((state_37856[(4)])));

return statearr_37867;
})();
var state_37856__$1 = state_37856;
var statearr_37868_37898 = state_37856__$1;
(statearr_37868_37898[(2)] = inst_37851);

(statearr_37868_37898[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (2))){
var _ = (function (){var statearr_37870 = state_37856;
(statearr_37870[(4)] = cljs.core.cons((9),(state_37856[(4)])));

return statearr_37870;
})();
var inst_37818 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37819 = typeof inst_37818 === 'string';
var state_37856__$1 = state_37856;
if(cljs.core.truth_(inst_37819)){
var statearr_37871_37899 = state_37856__$1;
(statearr_37871_37899[(1)] = (10));

} else {
var statearr_37872_37900 = state_37856__$1;
(statearr_37872_37900[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (11))){
var inst_37825 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37826 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_37825);
var inst_37827 = fluree.db.dbfunctions.internal.inc(inst_37826);
var inst_37828 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37825,cljs.core.cst$kw$t,inst_37827);
var inst_37829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37830 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37831 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37832 = [inst_37830,inst_37831];
var inst_37833 = (new cljs.core.PersistentVector(null,2,(5),inst_37829,inst_37832,null));
var inst_37834 = fluree.db.dbproto._search(inst_37828,inst_37833);
var state_37856__$1 = state_37856;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37856__$1,(13),inst_37834);
} else {
if((state_val_37857 === (9))){
var _ = (function (){var statearr_37873 = state_37856;
(statearr_37873[(4)] = cljs.core.rest((state_37856[(4)])));

return statearr_37873;
})();
var state_37856__$1 = state_37856;
var ex37869 = (state_37856__$1[(2)]);
var statearr_37874_37901 = state_37856__$1;
(statearr_37874_37901[(5)] = ex37869);


var statearr_37875_37902 = state_37856__$1;
(statearr_37875_37902[(1)] = (4));

(statearr_37875_37902[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (5))){
var inst_37802 = (state_37856[(7)]);
var _ = (function (){var statearr_37876 = state_37856;
(statearr_37876[(4)] = cljs.core.cons((8),(state_37856[(4)])));

return statearr_37876;
})();
var inst_37809 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_37802,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_37877 = state_37856;
(statearr_37877[(4)] = cljs.core.rest((state_37856[(4)])));

return statearr_37877;
})();
var state_37856__$1 = state_37856;
var statearr_37878_37903 = state_37856__$1;
(statearr_37878_37903[(2)] = inst_37809);

(statearr_37878_37903[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (14))){
var state_37856__$1 = state_37856;
var statearr_37879_37904 = state_37856__$1;
(statearr_37879_37904[(2)] = null);

(statearr_37879_37904[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (16))){
var inst_37838 = (state_37856[(9)]);
var inst_37846 = (state_37856[(2)]);
var inst_37847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37848 = [inst_37846,inst_37838];
var inst_37849 = (new cljs.core.PersistentVector(null,2,(5),inst_37847,inst_37848,null));
var state_37856__$1 = state_37856;
var statearr_37881_37905 = state_37856__$1;
(statearr_37881_37905[(2)] = inst_37849);

(statearr_37881_37905[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (10))){
var inst_37821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37822 = [null,(0)];
var inst_37823 = (new cljs.core.PersistentVector(null,2,(5),inst_37821,inst_37822,null));
var state_37856__$1 = state_37856;
var statearr_37882_37906 = state_37856__$1;
(statearr_37882_37906[(2)] = inst_37823);

(statearr_37882_37906[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37857 === (8))){
var _ = (function (){var statearr_37883 = state_37856;
(statearr_37883[(4)] = cljs.core.rest((state_37856[(4)])));

return statearr_37883;
})();
var state_37856__$1 = state_37856;
var ex37880 = (state_37856__$1[(2)]);
var statearr_37884_37907 = state_37856__$1;
(statearr_37884_37907[(5)] = ex37880);


var statearr_37885_37908 = state_37856__$1;
(statearr_37885_37908[(1)] = (7));

(statearr_37885_37908[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto____0 = (function (){
var statearr_37886 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37886[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto__);

(statearr_37886[(1)] = (1));

return statearr_37886;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto____1 = (function (state_37856){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_37856);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e37887){var ex__10844__auto__ = e37887;
var statearr_37888_37909 = state_37856;
(statearr_37888_37909[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_37856[(4)]))){
var statearr_37889_37910 = state_37856;
(statearr_37889_37910[(1)] = cljs.core.first((state_37856[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__37911 = state_37856;
state_37856 = G__37911;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto__ = function(state_37856){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto____1.call(this,state_37856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_37890 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_37890[(6)] = c__10878__auto__);

return statearr_37890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_37963){
var state_val_37964 = (state_37963[(1)]);
if((state_val_37964 === (7))){
var inst_37913 = (state_37963[(2)]);
var state_37963__$1 = state_37963;
var statearr_37965_37994 = state_37963__$1;
(statearr_37965_37994[(2)] = inst_37913);

(statearr_37965_37994[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (1))){
var state_37963__$1 = state_37963;
var statearr_37966_37995 = state_37963__$1;
(statearr_37966_37995[(2)] = null);

(statearr_37966_37995[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (4))){
var inst_37912 = (state_37963[(2)]);
var state_37963__$1 = (function (){var statearr_37967 = state_37963;
(statearr_37967[(7)] = inst_37912);

return statearr_37967;
})();
var statearr_37968_37996 = state_37963__$1;
(statearr_37968_37996[(2)] = null);

(statearr_37968_37996[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (13))){
var inst_37958 = (state_37963[(2)]);
var _ = (function (){var statearr_37969 = state_37963;
(statearr_37969[(4)] = cljs.core.rest((state_37963[(4)])));

return statearr_37969;
})();
var state_37963__$1 = state_37963;
var statearr_37970_37997 = state_37963__$1;
(statearr_37970_37997[(2)] = inst_37958);

(statearr_37970_37997[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (6))){
var inst_37922 = (state_37963[(2)]);
var state_37963__$1 = state_37963;
var statearr_37971_37998 = state_37963__$1;
(statearr_37971_37998[(2)] = inst_37922);

(statearr_37971_37998[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (3))){
var inst_37961 = (state_37963[(2)]);
var state_37963__$1 = state_37963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37963__$1,inst_37961);
} else {
if((state_val_37964 === (12))){
var inst_37945 = (state_37963[(8)]);
var inst_37954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37955 = [null,inst_37945];
var inst_37956 = (new cljs.core.PersistentVector(null,2,(5),inst_37954,inst_37955,null));
var state_37963__$1 = state_37963;
var statearr_37972_37999 = state_37963__$1;
(statearr_37972_37999[(2)] = inst_37956);

(statearr_37972_37999[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (2))){
var _ = (function (){var statearr_37974 = state_37963;
(statearr_37974[(4)] = cljs.core.cons((9),(state_37963[(4)])));

return statearr_37974;
})();
var inst_37931 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_37932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37934 = [null,pred_name,"?o"];
var inst_37935 = (new cljs.core.PersistentVector(null,3,(5),inst_37933,inst_37934,null));
var inst_37936 = [inst_37935];
var inst_37937 = (new cljs.core.PersistentVector(null,1,(5),inst_37932,inst_37936,null));
var inst_37938 = ["?o",inst_37937,opts];
var inst_37939 = cljs.core.PersistentHashMap.fromArrays(inst_37931,inst_37938);
var inst_37940 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_37939);
var state_37963__$1 = state_37963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37963__$1,(10),inst_37940);
} else {
if((state_val_37964 === (11))){
var inst_37944 = (state_37963[(9)]);
var inst_37945 = (state_37963[(8)]);
var inst_37949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37950 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_37944);
var inst_37951 = [inst_37950,inst_37945];
var inst_37952 = (new cljs.core.PersistentVector(null,2,(5),inst_37949,inst_37951,null));
var state_37963__$1 = state_37963;
var statearr_37975_38000 = state_37963__$1;
(statearr_37975_38000[(2)] = inst_37952);

(statearr_37975_38000[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (9))){
var _ = (function (){var statearr_37976 = state_37963;
(statearr_37976[(4)] = cljs.core.rest((state_37963[(4)])));

return statearr_37976;
})();
var state_37963__$1 = state_37963;
var ex37973 = (state_37963__$1[(2)]);
var statearr_37977_38001 = state_37963__$1;
(statearr_37977_38001[(5)] = ex37973);


var statearr_37978_38002 = state_37963__$1;
(statearr_37978_38002[(1)] = (4));

(statearr_37978_38002[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (5))){
var inst_37912 = (state_37963[(7)]);
var _ = (function (){var statearr_37980 = state_37963;
(statearr_37980[(4)] = cljs.core.cons((8),(state_37963[(4)])));

return statearr_37980;
})();
var inst_37919 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_37912,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_37981 = state_37963;
(statearr_37981[(4)] = cljs.core.rest((state_37963[(4)])));

return statearr_37981;
})();
var state_37963__$1 = state_37963;
var statearr_37982_38003 = state_37963__$1;
(statearr_37982_38003[(2)] = inst_37919);

(statearr_37982_38003[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (10))){
var inst_37944 = (state_37963[(9)]);
var inst_37942 = (state_37963[(2)]);
var inst_37943 = fluree.db.util.async.throw_err(inst_37942);
var inst_37944__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37943,(0),null);
var inst_37945 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37943,(1),null);
var inst_37946 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_37944__$1);
var inst_37947 = cljs.core.not(inst_37946);
var state_37963__$1 = (function (){var statearr_37983 = state_37963;
(statearr_37983[(9)] = inst_37944__$1);

(statearr_37983[(8)] = inst_37945);

return statearr_37983;
})();
if(inst_37947){
var statearr_37984_38004 = state_37963__$1;
(statearr_37984_38004[(1)] = (11));

} else {
var statearr_37985_38005 = state_37963__$1;
(statearr_37985_38005[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37964 === (8))){
var _ = (function (){var statearr_37986 = state_37963;
(statearr_37986[(4)] = cljs.core.rest((state_37963[(4)])));

return statearr_37986;
})();
var state_37963__$1 = state_37963;
var ex37979 = (state_37963__$1[(2)]);
var statearr_37987_38006 = state_37963__$1;
(statearr_37987_38006[(5)] = ex37979);


var statearr_37988_38007 = state_37963__$1;
(statearr_37988_38007[(1)] = (7));

(statearr_37988_38007[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto____0 = (function (){
var statearr_37989 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37989[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto__);

(statearr_37989[(1)] = (1));

return statearr_37989;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto____1 = (function (state_37963){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_37963);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e37990){var ex__10844__auto__ = e37990;
var statearr_37991_38008 = state_37963;
(statearr_37991_38008[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_37963[(4)]))){
var statearr_37992_38009 = state_37963;
(statearr_37992_38009[(1)] = cljs.core.first((state_37963[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__38010 = state_37963;
state_37963 = G__38010;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto__ = function(state_37963){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto____1.call(this,state_37963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_37993 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_37993[(6)] = c__10878__auto__);

return statearr_37993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4221__auto__ = typeof email === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4221__auto__;
}
})());
}catch (e38011){var e = e38011;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__38013 = arguments.length;
switch (G__38013) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_38083){
var state_val_38084 = (state_38083[(1)]);
if((state_val_38084 === (7))){
var inst_38015 = (state_38083[(2)]);
var state_38083__$1 = state_38083;
var statearr_38085_38129 = state_38083__$1;
(statearr_38085_38129[(2)] = inst_38015);

(statearr_38085_38129[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (20))){
var inst_38059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38060 = ["*"];
var inst_38061 = (new cljs.core.PersistentVector(null,1,(5),inst_38059,inst_38060,null));
var state_38083__$1 = state_38083;
var statearr_38086_38130 = state_38083__$1;
(statearr_38086_38130[(2)] = inst_38061);

(statearr_38086_38130[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (1))){
var state_38083__$1 = state_38083;
var statearr_38087_38131 = state_38083__$1;
(statearr_38087_38131[(2)] = null);

(statearr_38087_38131[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (4))){
var inst_38014 = (state_38083[(2)]);
var state_38083__$1 = (function (){var statearr_38088 = state_38083;
(statearr_38088[(7)] = inst_38014);

return statearr_38088;
})();
var statearr_38089_38132 = state_38083__$1;
(statearr_38089_38132[(2)] = null);

(statearr_38089_38132[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (15))){
var inst_38078 = (state_38083[(2)]);
var _ = (function (){var statearr_38090 = state_38083;
(statearr_38090[(4)] = cljs.core.rest((state_38083[(4)])));

return statearr_38090;
})();
var state_38083__$1 = state_38083;
var statearr_38091_38133 = state_38083__$1;
(statearr_38091_38133[(2)] = inst_38078);

(statearr_38091_38133[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (21))){
var inst_38042 = (state_38083[(8)]);
var inst_38049 = (state_38083[(9)]);
var inst_38063 = (state_38083[(2)]);
var inst_38064 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_38065 = cljs.core.PersistentHashMap.EMPTY;
var inst_38066 = [inst_38063,inst_38049,inst_38065];
var inst_38067 = cljs.core.PersistentHashMap.fromArrays(inst_38064,inst_38066);
var inst_38068 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38042,inst_38067);
var state_38083__$1 = state_38083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38083__$1,(22),inst_38068);
} else {
if((state_val_38084 === (13))){
var inst_38037 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38083__$1 = state_38083;
var statearr_38092_38134 = state_38083__$1;
(statearr_38092_38134[(2)] = inst_38037);

(statearr_38092_38134[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (22))){
var inst_38070 = (state_38083[(2)]);
var inst_38071 = fluree.db.util.async.throw_err(inst_38070);
var inst_38072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38071,(0),null);
var inst_38073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38071,(1),null);
var inst_38074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38075 = [inst_38072,inst_38073];
var inst_38076 = (new cljs.core.PersistentVector(null,2,(5),inst_38074,inst_38075,null));
var state_38083__$1 = state_38083;
var statearr_38093_38135 = state_38083__$1;
(statearr_38093_38135[(2)] = inst_38076);

(statearr_38093_38135[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (6))){
var inst_38024 = (state_38083[(2)]);
var state_38083__$1 = state_38083;
var statearr_38094_38136 = state_38083__$1;
(statearr_38094_38136[(2)] = inst_38024);

(statearr_38094_38136[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (17))){
var inst_38046 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38047 = fluree.db.dbfunctions.internal.get(inst_38046,cljs.core.cst$kw$_id);
var state_38083__$1 = state_38083;
var statearr_38095_38137 = state_38083__$1;
(statearr_38095_38137[(2)] = inst_38047);

(statearr_38095_38137[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (3))){
var inst_38081 = (state_38083[(2)]);
var state_38083__$1 = state_38083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38083__$1,inst_38081);
} else {
if((state_val_38084 === (12))){
var inst_38035 = (state_38083[(2)]);
var state_38083__$1 = state_38083;
if(cljs.core.truth_(inst_38035)){
var statearr_38096_38138 = state_38083__$1;
(statearr_38096_38138[(1)] = (13));

} else {
var statearr_38097_38139 = state_38083__$1;
(statearr_38097_38139[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (2))){
var inst_38030 = (state_38083[(10)]);
var _ = (function (){var statearr_38098 = state_38083;
(statearr_38098[(4)] = cljs.core.cons((9),(state_38083[(4)])));

return statearr_38098;
})();
var inst_38030__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38083__$1 = (function (){var statearr_38099 = state_38083;
(statearr_38099[(10)] = inst_38030__$1);

return statearr_38099;
})();
if(cljs.core.truth_(inst_38030__$1)){
var statearr_38100_38140 = state_38083__$1;
(statearr_38100_38140[(1)] = (10));

} else {
var statearr_38101_38141 = state_38083__$1;
(statearr_38101_38141[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (19))){
var inst_38051 = cljs.core.PersistentVector.EMPTY;
var inst_38052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38053 = ["*"];
var inst_38054 = (new cljs.core.PersistentVector(null,1,(5),inst_38052,inst_38053,null));
var inst_38055 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_38056 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38054,inst_38055);
var inst_38057 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38051,inst_38056);
var state_38083__$1 = state_38083;
var statearr_38103_38142 = state_38083__$1;
(statearr_38103_38142[(2)] = inst_38057);

(statearr_38103_38142[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (11))){
var inst_38030 = (state_38083[(10)]);
var state_38083__$1 = state_38083;
var statearr_38104_38143 = state_38083__$1;
(statearr_38104_38143[(2)] = inst_38030);

(statearr_38104_38143[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (9))){
var _ = (function (){var statearr_38105 = state_38083;
(statearr_38105[(4)] = cljs.core.rest((state_38083[(4)])));

return statearr_38105;
})();
var state_38083__$1 = state_38083;
var ex38102 = (state_38083__$1[(2)]);
var statearr_38106_38144 = state_38083__$1;
(statearr_38106_38144[(5)] = ex38102);


var statearr_38107_38145 = state_38083__$1;
(statearr_38107_38145[(1)] = (4));

(statearr_38107_38145[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (5))){
var inst_38014 = (state_38083[(7)]);
var _ = (function (){var statearr_38108 = state_38083;
(statearr_38108[(4)] = cljs.core.cons((8),(state_38083[(4)])));

return statearr_38108;
})();
var inst_38021 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38014,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_38109 = state_38083;
(statearr_38109[(4)] = cljs.core.rest((state_38083[(4)])));

return statearr_38109;
})();
var state_38083__$1 = state_38083;
var statearr_38110_38146 = state_38083__$1;
(statearr_38110_38146[(2)] = inst_38021);

(statearr_38110_38146[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (14))){
var inst_38043 = (state_38083[(11)]);
var inst_38042 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38043__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38083__$1 = (function (){var statearr_38111 = state_38083;
(statearr_38111[(8)] = inst_38042);

(statearr_38111[(11)] = inst_38043__$1);

return statearr_38111;
})();
if(cljs.core.truth_(inst_38043__$1)){
var statearr_38112_38147 = state_38083__$1;
(statearr_38112_38147[(1)] = (16));

} else {
var statearr_38113_38148 = state_38083__$1;
(statearr_38113_38148[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (16))){
var inst_38043 = (state_38083[(11)]);
var state_38083__$1 = state_38083;
var statearr_38114_38149 = state_38083__$1;
(statearr_38114_38149[(2)] = inst_38043);

(statearr_38114_38149[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (10))){
var inst_38032 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_38083__$1 = state_38083;
var statearr_38116_38150 = state_38083__$1;
(statearr_38116_38150[(2)] = inst_38032);

(statearr_38116_38150[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (18))){
var inst_38049 = (state_38083[(2)]);
var state_38083__$1 = (function (){var statearr_38117 = state_38083;
(statearr_38117[(9)] = inst_38049);

return statearr_38117;
})();
if(cljs.core.truth_(additional_params)){
var statearr_38118_38151 = state_38083__$1;
(statearr_38118_38151[(1)] = (19));

} else {
var statearr_38119_38152 = state_38083__$1;
(statearr_38119_38152[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38084 === (8))){
var _ = (function (){var statearr_38120 = state_38083;
(statearr_38120[(4)] = cljs.core.rest((state_38083[(4)])));

return statearr_38120;
})();
var state_38083__$1 = state_38083;
var ex38115 = (state_38083__$1[(2)]);
var statearr_38121_38153 = state_38083__$1;
(statearr_38121_38153[(5)] = ex38115);


var statearr_38122_38154 = state_38083__$1;
(statearr_38122_38154[(1)] = (7));

(statearr_38122_38154[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10841__auto____0 = (function (){
var statearr_38123 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38123[(0)] = fluree$db$dbfunctions$internal$state_machine__10841__auto__);

(statearr_38123[(1)] = (1));

return statearr_38123;
});
var fluree$db$dbfunctions$internal$state_machine__10841__auto____1 = (function (state_38083){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_38083);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e38124){var ex__10844__auto__ = e38124;
var statearr_38125_38155 = state_38083;
(statearr_38125_38155[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_38083[(4)]))){
var statearr_38126_38156 = state_38083;
(statearr_38126_38156[(1)] = cljs.core.first((state_38083[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__38157 = state_38083;
state_38083 = G__38157;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10841__auto__ = function(state_38083){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10841__auto____1.call(this,state_38083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_38127 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_38127[(6)] = c__10878__auto__);

return statearr_38127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__38159 = arguments.length;
switch (G__38159) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_38203){
var state_val_38204 = (state_38203[(1)]);
if((state_val_38204 === (7))){
var inst_38181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38182 = ["*"];
var inst_38183 = (new cljs.core.PersistentVector(null,1,(5),inst_38181,inst_38182,null));
var state_38203__$1 = state_38203;
var statearr_38205_38225 = state_38203__$1;
(statearr_38205_38225[(2)] = inst_38183);

(statearr_38205_38225[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (1))){
var state_38203__$1 = state_38203;
var statearr_38206_38226 = state_38203__$1;
(statearr_38206_38226[(2)] = null);

(statearr_38206_38226[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (4))){
var inst_38160 = (state_38203[(2)]);
var inst_38161 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38160,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_38203__$1 = state_38203;
var statearr_38207_38227 = state_38203__$1;
(statearr_38207_38227[(2)] = inst_38161);

(statearr_38207_38227[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (6))){
var inst_38173 = cljs.core.PersistentVector.EMPTY;
var inst_38174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38175 = ["*"];
var inst_38176 = (new cljs.core.PersistentVector(null,1,(5),inst_38174,inst_38175,null));
var inst_38177 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_38178 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38176,inst_38177);
var inst_38179 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38173,inst_38178);
var state_38203__$1 = state_38203;
var statearr_38208_38228 = state_38203__$1;
(statearr_38208_38228[(2)] = inst_38179);

(statearr_38208_38228[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (3))){
var inst_38201 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38203__$1,inst_38201);
} else {
if((state_val_38204 === (2))){
var _ = (function (){var statearr_38210 = state_38203;
(statearr_38210[(4)] = cljs.core.cons((5),(state_38203[(4)])));

return statearr_38210;
})();
var inst_38170 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38171 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38203__$1 = (function (){var statearr_38211 = state_38203;
(statearr_38211[(7)] = inst_38171);

(statearr_38211[(8)] = inst_38170);

return statearr_38211;
})();
if(cljs.core.truth_(additional_params)){
var statearr_38212_38229 = state_38203__$1;
(statearr_38212_38229[(1)] = (6));

} else {
var statearr_38213_38230 = state_38203__$1;
(statearr_38213_38230[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (9))){
var inst_38192 = (state_38203[(2)]);
var inst_38193 = fluree.db.util.async.throw_err(inst_38192);
var inst_38194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38193,(0),null);
var inst_38195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38193,(1),null);
var inst_38196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38197 = [inst_38194,inst_38195];
var inst_38198 = (new cljs.core.PersistentVector(null,2,(5),inst_38196,inst_38197,null));
var _ = (function (){var statearr_38214 = state_38203;
(statearr_38214[(4)] = cljs.core.rest((state_38203[(4)])));

return statearr_38214;
})();
var state_38203__$1 = state_38203;
var statearr_38215_38231 = state_38203__$1;
(statearr_38215_38231[(2)] = inst_38198);

(statearr_38215_38231[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (5))){
var _ = (function (){var statearr_38216 = state_38203;
(statearr_38216[(4)] = cljs.core.rest((state_38203[(4)])));

return statearr_38216;
})();
var state_38203__$1 = state_38203;
var ex38209 = (state_38203__$1[(2)]);
var statearr_38217_38232 = state_38203__$1;
(statearr_38217_38232[(5)] = ex38209);


var statearr_38218_38233 = state_38203__$1;
(statearr_38218_38233[(1)] = (4));

(statearr_38218_38233[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (8))){
var inst_38171 = (state_38203[(7)]);
var inst_38170 = (state_38203[(8)]);
var inst_38185 = (state_38203[(2)]);
var inst_38186 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_38187 = cljs.core.PersistentHashMap.EMPTY;
var inst_38188 = [inst_38185,inst_38171,inst_38187];
var inst_38189 = cljs.core.PersistentHashMap.fromArrays(inst_38186,inst_38188);
var inst_38190 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38170,inst_38189);
var state_38203__$1 = state_38203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38203__$1,(9),inst_38190);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10841__auto____0 = (function (){
var statearr_38219 = [null,null,null,null,null,null,null,null,null];
(statearr_38219[(0)] = fluree$db$dbfunctions$internal$state_machine__10841__auto__);

(statearr_38219[(1)] = (1));

return statearr_38219;
});
var fluree$db$dbfunctions$internal$state_machine__10841__auto____1 = (function (state_38203){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_38203);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e38220){var ex__10844__auto__ = e38220;
var statearr_38221_38234 = state_38203;
(statearr_38221_38234[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_38203[(4)]))){
var statearr_38222_38235 = state_38203;
(statearr_38222_38235[(1)] = cljs.core.first((state_38203[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__38236 = state_38203;
state_38203 = G__38236;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10841__auto__ = function(state_38203){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10841__auto____1.call(this,state_38203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_38223 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_38223[(6)] = c__10878__auto__);

return statearr_38223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_38280){
var state_val_38281 = (state_38280[(1)]);
if((state_val_38281 === (1))){
var state_38280__$1 = state_38280;
var statearr_38282_38296 = state_38280__$1;
(statearr_38282_38296[(2)] = null);

(statearr_38282_38296[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38281 === (2))){
var _ = (function (){var statearr_38283 = state_38280;
(statearr_38283[(4)] = cljs.core.cons((5),(state_38280[(4)])));

return statearr_38283;
})();
var inst_38247 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_38248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38249 = ["_user/_auth"];
var inst_38250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38251 = ["*"];
var inst_38252 = (new cljs.core.PersistentVector(null,1,(5),inst_38250,inst_38251,null));
var inst_38253 = [inst_38252];
var inst_38254 = cljs.core.PersistentHashMap.fromArrays(inst_38249,inst_38253);
var inst_38255 = [inst_38254];
var inst_38256 = (new cljs.core.PersistentVector(null,1,(5),inst_38248,inst_38255,null));
var inst_38257 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38258 = cljs.core.PersistentHashMap.EMPTY;
var inst_38259 = [inst_38256,inst_38257,inst_38258];
var inst_38260 = cljs.core.PersistentHashMap.fromArrays(inst_38247,inst_38259);
var inst_38261 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38262 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38261,inst_38260);
var state_38280__$1 = state_38280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38280__$1,(6),inst_38262);
} else {
if((state_val_38281 === (3))){
var inst_38278 = (state_38280[(2)]);
var state_38280__$1 = state_38280;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38280__$1,inst_38278);
} else {
if((state_val_38281 === (4))){
var inst_38237 = (state_38280[(2)]);
var inst_38238 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38237,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_38280__$1 = state_38280;
var statearr_38285_38297 = state_38280__$1;
(statearr_38285_38297[(2)] = inst_38238);

(statearr_38285_38297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38281 === (5))){
var _ = (function (){var statearr_38286 = state_38280;
(statearr_38286[(4)] = cljs.core.rest((state_38280[(4)])));

return statearr_38286;
})();
var state_38280__$1 = state_38280;
var ex38284 = (state_38280__$1[(2)]);
var statearr_38287_38298 = state_38280__$1;
(statearr_38287_38298[(5)] = ex38284);


var statearr_38288_38299 = state_38280__$1;
(statearr_38288_38299[(1)] = (4));

(statearr_38288_38299[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38281 === (6))){
var inst_38264 = (state_38280[(2)]);
var inst_38265 = fluree.db.util.async.throw_err(inst_38264);
var inst_38266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38265,(0),null);
var inst_38267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38265,(1),null);
var inst_38268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38269 = ["_user/_auth","_id"];
var inst_38270 = (new cljs.core.PersistentVector(null,2,(5),inst_38268,inst_38269,null));
var inst_38271 = fluree.db.dbfunctions.internal.get_in(inst_38266,inst_38270);
var inst_38272 = cljs.core.first(inst_38271);
var inst_38273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38274 = [inst_38272,inst_38267];
var inst_38275 = (new cljs.core.PersistentVector(null,2,(5),inst_38273,inst_38274,null));
var _ = (function (){var statearr_38289 = state_38280;
(statearr_38289[(4)] = cljs.core.rest((state_38280[(4)])));

return statearr_38289;
})();
var state_38280__$1 = state_38280;
var statearr_38290_38300 = state_38280__$1;
(statearr_38290_38300[(2)] = inst_38275);

(statearr_38290_38300[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto____0 = (function (){
var statearr_38291 = [null,null,null,null,null,null,null];
(statearr_38291[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto__);

(statearr_38291[(1)] = (1));

return statearr_38291;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto____1 = (function (state_38280){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_38280);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e38292){var ex__10844__auto__ = e38292;
var statearr_38293_38301 = state_38280;
(statearr_38293_38301[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_38280[(4)]))){
var statearr_38294_38302 = state_38280;
(statearr_38294_38302[(1)] = cljs.core.first((state_38280[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__38303 = state_38280;
state_38280 = G__38303;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto__ = function(state_38280){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto____1.call(this,state_38280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_38295 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_38295[(6)] = c__10878__auto__);

return statearr_38295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_38320){
var state_val_38321 = (state_38320[(1)]);
if((state_val_38321 === (1))){
var state_38320__$1 = state_38320;
var statearr_38322_38336 = state_38320__$1;
(statearr_38322_38336[(2)] = null);

(statearr_38322_38336[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38321 === (2))){
var _ = (function (){var statearr_38323 = state_38320;
(statearr_38323[(4)] = cljs.core.cons((5),(state_38320[(4)])));

return statearr_38323;
})();
var inst_38310 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38311 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38312 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_38311,inst_38310);
var state_38320__$1 = state_38320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38320__$1,(6),inst_38312);
} else {
if((state_val_38321 === (3))){
var inst_38318 = (state_38320[(2)]);
var state_38320__$1 = state_38320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38320__$1,inst_38318);
} else {
if((state_val_38321 === (4))){
var inst_38304 = (state_38320[(2)]);
var state_38320__$1 = state_38320;
var statearr_38325_38337 = state_38320__$1;
(statearr_38325_38337[(2)] = inst_38304);

(statearr_38325_38337[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38321 === (5))){
var _ = (function (){var statearr_38326 = state_38320;
(statearr_38326[(4)] = cljs.core.rest((state_38320[(4)])));

return statearr_38326;
})();
var state_38320__$1 = state_38320;
var ex38324 = (state_38320__$1[(2)]);
var statearr_38327_38338 = state_38320__$1;
(statearr_38327_38338[(5)] = ex38324);


if((ex38324 instanceof Error)){
var statearr_38328_38339 = state_38320__$1;
(statearr_38328_38339[(1)] = (4));

(statearr_38328_38339[(5)] = null);

} else {
throw ex38324;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38321 === (6))){
var inst_38314 = (state_38320[(2)]);
var inst_38315 = fluree.db.util.async.throw_err(inst_38314);
var _ = (function (){var statearr_38329 = state_38320;
(statearr_38329[(4)] = cljs.core.rest((state_38320[(4)])));

return statearr_38329;
})();
var state_38320__$1 = state_38320;
var statearr_38330_38340 = state_38320__$1;
(statearr_38330_38340[(2)] = inst_38315);

(statearr_38330_38340[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto____0 = (function (){
var statearr_38331 = [null,null,null,null,null,null,null];
(statearr_38331[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto__);

(statearr_38331[(1)] = (1));

return statearr_38331;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto____1 = (function (state_38320){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_38320);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e38332){var ex__10844__auto__ = e38332;
var statearr_38333_38341 = state_38320;
(statearr_38333_38341[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_38320[(4)]))){
var statearr_38334_38342 = state_38320;
(statearr_38334_38342[(1)] = cljs.core.first((state_38320[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__38343 = state_38320;
state_38320 = G__38343;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto__ = function(state_38320){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto____1.call(this,state_38320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_38335 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_38335[(6)] = c__10878__auto__);

return statearr_38335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__38344_SHARP_){
return p1__38344_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38345_SHARP_){
return p1__38345_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e38346){var e = e38346;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__38347_SHARP_){
return p1__38347_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38348_SHARP_){
return p1__38348_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e38349){var e = e38349;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__38351 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__38351);
})() | (0));
return num;
}catch (e38350){var e = e38350;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_38431){
var state_val_38432 = (state_38431[(1)]);
if((state_val_38432 === (7))){
var inst_38370 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_38371 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38372 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_38373 = cljs.core.PersistentHashMap.fromArrays(inst_38371,inst_38372);
var inst_38374 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38370,inst_38373);
var inst_38375 = (function(){throw inst_38374})();
var state_38431__$1 = state_38431;
var statearr_38433_38468 = state_38431__$1;
(statearr_38433_38468[(2)] = inst_38375);

(statearr_38433_38468[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (1))){
var state_38431__$1 = state_38431;
var statearr_38434_38469 = state_38431__$1;
(statearr_38434_38469[(2)] = null);

(statearr_38434_38469[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (4))){
var inst_38352 = (state_38431[(2)]);
var state_38431__$1 = state_38431;
var statearr_38435_38470 = state_38431__$1;
(statearr_38435_38470[(2)] = inst_38352);

(statearr_38435_38470[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (15))){
var inst_38415 = (state_38431[(7)]);
var inst_38411 = (state_38431[(2)]);
var inst_38412 = fluree.db.util.async.throw_err(inst_38411);
var inst_38413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38412,(0),null);
var inst_38414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38412,(1),null);
var inst_38415__$1 = cljs.core.first(inst_38413);
var inst_38416 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38415__$1,compare_val);
var state_38431__$1 = (function (){var statearr_38436 = state_38431;
(statearr_38436[(8)] = inst_38414);

(statearr_38436[(7)] = inst_38415__$1);

return statearr_38436;
})();
if(inst_38416){
var statearr_38437_38471 = state_38431__$1;
(statearr_38437_38471[(1)] = (16));

} else {
var statearr_38438_38472 = state_38431__$1;
(statearr_38438_38472[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (13))){
var state_38431__$1 = state_38431;
var statearr_38439_38473 = state_38431__$1;
(statearr_38439_38473[(2)] = null);

(statearr_38439_38473[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (6))){
var state_38431__$1 = state_38431;
var statearr_38440_38474 = state_38431__$1;
(statearr_38440_38474[(2)] = null);

(statearr_38440_38474[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (17))){
var inst_38415 = (state_38431[(7)]);
var inst_38419 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38415)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_38420 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38421 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_38422 = cljs.core.PersistentHashMap.fromArrays(inst_38420,inst_38421);
var inst_38423 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38419,inst_38422);
var inst_38424 = (function(){throw inst_38423})();
var state_38431__$1 = state_38431;
var statearr_38441_38475 = state_38431__$1;
(statearr_38441_38475[(2)] = inst_38424);

(statearr_38441_38475[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (3))){
var inst_38429 = (state_38431[(2)]);
var state_38431__$1 = state_38431;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38431__$1,inst_38429);
} else {
if((state_val_38432 === (12))){
var inst_38367 = (state_38431[(9)]);
var inst_38390 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_38367], 0));
var inst_38391 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38392 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_38393 = cljs.core.PersistentHashMap.fromArrays(inst_38391,inst_38392);
var inst_38394 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38390,inst_38393);
var inst_38395 = (function(){throw inst_38394})();
var state_38431__$1 = state_38431;
var statearr_38442_38476 = state_38431__$1;
(statearr_38442_38476[(2)] = inst_38395);

(statearr_38442_38476[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (2))){
var inst_38365 = (state_38431[(10)]);
var inst_38364 = (state_38431[(11)]);
var inst_38366 = (state_38431[(12)]);
var _ = (function (){var statearr_38443 = state_38431;
(statearr_38443[(4)] = cljs.core.cons((5),(state_38431[(4)])));

return statearr_38443;
})();
var inst_38362 = _QMARK_ctx;
var inst_38363 = cljs.core.__destructure_map(inst_38362);
var inst_38364__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38363,cljs.core.cst$kw$sid);
var inst_38365__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38363,cljs.core.cst$kw$pid);
var inst_38366__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38363,cljs.core.cst$kw$db);
var inst_38367 = fluree.db.dbproto._p_prop(inst_38366__$1,cljs.core.cst$kw$name,inst_38365__$1);
var state_38431__$1 = (function (){var statearr_38444 = state_38431;
(statearr_38444[(10)] = inst_38365__$1);

(statearr_38444[(9)] = inst_38367);

(statearr_38444[(11)] = inst_38364__$1);

(statearr_38444[(12)] = inst_38366__$1);

return statearr_38444;
})();
if(cljs.core.truth_(inst_38364__$1)){
var statearr_38445_38477 = state_38431__$1;
(statearr_38445_38477[(1)] = (6));

} else {
var statearr_38446_38478 = state_38431__$1;
(statearr_38446_38478[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (11))){
var inst_38365 = (state_38431[(10)]);
var inst_38366 = (state_38431[(12)]);
var inst_38387 = (state_38431[(2)]);
var inst_38388 = fluree.db.dbproto._p_prop(inst_38366,cljs.core.cst$kw$multi,inst_38365);
var state_38431__$1 = (function (){var statearr_38448 = state_38431;
(statearr_38448[(13)] = inst_38387);

return statearr_38448;
})();
if(cljs.core.truth_(inst_38388)){
var statearr_38449_38479 = state_38431__$1;
(statearr_38449_38479[(1)] = (12));

} else {
var statearr_38450_38480 = state_38431__$1;
(statearr_38450_38480[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (9))){
var state_38431__$1 = state_38431;
var statearr_38451_38481 = state_38431__$1;
(statearr_38451_38481[(2)] = null);

(statearr_38451_38481[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (5))){
var _ = (function (){var statearr_38452 = state_38431;
(statearr_38452[(4)] = cljs.core.rest((state_38431[(4)])));

return statearr_38452;
})();
var state_38431__$1 = state_38431;
var ex38447 = (state_38431__$1[(2)]);
var statearr_38453_38482 = state_38431__$1;
(statearr_38453_38482[(5)] = ex38447);


if((ex38447 instanceof Error)){
var statearr_38454_38483 = state_38431__$1;
(statearr_38454_38483[(1)] = (4));

(statearr_38454_38483[(5)] = null);

} else {
throw ex38447;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (14))){
var inst_38367 = (state_38431[(9)]);
var inst_38364 = (state_38431[(11)]);
var inst_38366 = (state_38431[(12)]);
var inst_38398 = (state_38431[(2)]);
var inst_38399 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_38400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38402 = [inst_38364,inst_38367,"?current-val"];
var inst_38403 = (new cljs.core.PersistentVector(null,3,(5),inst_38401,inst_38402,null));
var inst_38404 = [inst_38403];
var inst_38405 = (new cljs.core.PersistentVector(null,1,(5),inst_38400,inst_38404,null));
var inst_38406 = cljs.core.PersistentHashMap.EMPTY;
var inst_38407 = ["?current-val",inst_38405,inst_38406];
var inst_38408 = cljs.core.PersistentHashMap.fromArrays(inst_38399,inst_38407);
var inst_38409 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38366,inst_38408);
var state_38431__$1 = (function (){var statearr_38455 = state_38431;
(statearr_38455[(14)] = inst_38398);

return statearr_38455;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38431__$1,(15),inst_38409);
} else {
if((state_val_38432 === (16))){
var state_38431__$1 = state_38431;
var statearr_38456_38484 = state_38431__$1;
(statearr_38456_38484[(2)] = new_val);

(statearr_38456_38484[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (10))){
var inst_38380 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_38381 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38382 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_38383 = cljs.core.PersistentHashMap.fromArrays(inst_38381,inst_38382);
var inst_38384 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38380,inst_38383);
var inst_38385 = (function(){throw inst_38384})();
var state_38431__$1 = state_38431;
var statearr_38457_38485 = state_38431__$1;
(statearr_38457_38485[(2)] = inst_38385);

(statearr_38457_38485[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (18))){
var inst_38426 = (state_38431[(2)]);
var _ = (function (){var statearr_38458 = state_38431;
(statearr_38458[(4)] = cljs.core.rest((state_38431[(4)])));

return statearr_38458;
})();
var state_38431__$1 = state_38431;
var statearr_38459_38486 = state_38431__$1;
(statearr_38459_38486[(2)] = inst_38426);

(statearr_38459_38486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38432 === (8))){
var inst_38367 = (state_38431[(9)]);
var inst_38377 = (state_38431[(2)]);
var state_38431__$1 = (function (){var statearr_38460 = state_38431;
(statearr_38460[(15)] = inst_38377);

return statearr_38460;
})();
if(cljs.core.truth_(inst_38367)){
var statearr_38461_38487 = state_38431__$1;
(statearr_38461_38487[(1)] = (9));

} else {
var statearr_38462_38488 = state_38431__$1;
(statearr_38462_38488[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto____0 = (function (){
var statearr_38463 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38463[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto__);

(statearr_38463[(1)] = (1));

return statearr_38463;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto____1 = (function (state_38431){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_38431);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e38464){var ex__10844__auto__ = e38464;
var statearr_38465_38489 = state_38431;
(statearr_38465_38489[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_38431[(4)]))){
var statearr_38466_38490 = state_38431;
(statearr_38466_38490[(1)] = cljs.core.first((state_38431[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__38491 = state_38431;
state_38431 = G__38491;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto__ = function(state_38431){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto____1.call(this,state_38431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_38467 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_38467[(6)] = c__10878__auto__);

return statearr_38467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
