// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__22929 = arguments.length;
switch (G__22929) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22930 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22930 = (function (f,blockable,meta22931){
this.f = f;
this.blockable = blockable;
this.meta22931 = meta22931;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async22930.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22932,meta22931__$1){
var self__ = this;
var _22932__$1 = this;
return (new cljs.core.async.t_cljs$core$async22930(self__.f,self__.blockable,meta22931__$1));
}));

(cljs.core.async.t_cljs$core$async22930.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22932){
var self__ = this;
var _22932__$1 = this;
return self__.meta22931;
}));

(cljs.core.async.t_cljs$core$async22930.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async22930.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async22930.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async22930.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async22930.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta22931], null);
}));

(cljs.core.async.t_cljs$core$async22930.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async22930.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22930");

(cljs.core.async.t_cljs$core$async22930.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async22930");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22930.
 */
cljs.core.async.__GT_t_cljs$core$async22930 = (function cljs$core$async$__GT_t_cljs$core$async22930(f__$1,blockable__$1,meta22931){
return (new cljs.core.async.t_cljs$core$async22930(f__$1,blockable__$1,meta22931));
});

}

return (new cljs.core.async.t_cljs$core$async22930(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__22936 = arguments.length;
switch (G__22936) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__22939 = arguments.length;
switch (G__22939) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__22942 = arguments.length;
switch (G__22942) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_22944 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_22944) : fn1.call(null,val_22944));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_22944) : fn1.call(null,val_22944));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__22946 = arguments.length;
switch (G__22946) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4706__auto___22948 = n;
var x_22949 = (0);
while(true){
if((x_22949 < n__4706__auto___22948)){
(a[x_22949] = x_22949);

var G__22950 = (x_22949 + (1));
x_22949 = G__22950;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22951 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22951 = (function (flag,meta22952){
this.flag = flag;
this.meta22952 = meta22952;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async22951.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22953,meta22952__$1){
var self__ = this;
var _22953__$1 = this;
return (new cljs.core.async.t_cljs$core$async22951(self__.flag,meta22952__$1));
}));

(cljs.core.async.t_cljs$core$async22951.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22953){
var self__ = this;
var _22953__$1 = this;
return self__.meta22952;
}));

(cljs.core.async.t_cljs$core$async22951.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async22951.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async22951.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async22951.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async22951.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta22952], null);
}));

(cljs.core.async.t_cljs$core$async22951.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async22951.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22951");

(cljs.core.async.t_cljs$core$async22951.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async22951");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22951.
 */
cljs.core.async.__GT_t_cljs$core$async22951 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async22951(flag__$1,meta22952){
return (new cljs.core.async.t_cljs$core$async22951(flag__$1,meta22952));
});

}

return (new cljs.core.async.t_cljs$core$async22951(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22954 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22954 = (function (flag,cb,meta22955){
this.flag = flag;
this.cb = cb;
this.meta22955 = meta22955;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async22954.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22956,meta22955__$1){
var self__ = this;
var _22956__$1 = this;
return (new cljs.core.async.t_cljs$core$async22954(self__.flag,self__.cb,meta22955__$1));
}));

(cljs.core.async.t_cljs$core$async22954.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22956){
var self__ = this;
var _22956__$1 = this;
return self__.meta22955;
}));

(cljs.core.async.t_cljs$core$async22954.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async22954.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async22954.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async22954.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async22954.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta22955], null);
}));

(cljs.core.async.t_cljs$core$async22954.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async22954.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22954");

(cljs.core.async.t_cljs$core$async22954.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async22954");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22954.
 */
cljs.core.async.__GT_t_cljs$core$async22954 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async22954(flag__$1,cb__$1,meta22955){
return (new cljs.core.async.t_cljs$core$async22954(flag__$1,cb__$1,meta22955));
});

}

return (new cljs.core.async.t_cljs$core$async22954(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22957_SHARP_){
var G__22959 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22957_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__22959) : fret.call(null,G__22959));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22958_SHARP_){
var G__22960 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22958_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__22960) : fret.call(null,G__22960));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4223__auto__ = wport;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return port;
}
})()], null));
} else {
var G__22961 = (i + (1));
i = G__22961;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4223__auto__ = ret;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5753__auto__ = (function (){var and__4221__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4221__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___22966 = arguments.length;
var i__4830__auto___22967 = (0);
while(true){
if((i__4830__auto___22967 < len__4829__auto___22966)){
args__4835__auto__.push((arguments[i__4830__auto___22967]));

var G__22968 = (i__4830__auto___22967 + (1));
i__4830__auto___22967 = G__22968;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__22964){
var map__22965 = p__22964;
var map__22965__$1 = cljs.core.__destructure_map(map__22965);
var opts = map__22965__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq22962){
var G__22963 = cljs.core.first(seq22962);
var seq22962__$1 = cljs.core.next(seq22962);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22963,seq22962__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__22970 = arguments.length;
switch (G__22970) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20992__auto___23017 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_22994){
var state_val_22995 = (state_22994[(1)]);
if((state_val_22995 === (7))){
var inst_22990 = (state_22994[(2)]);
var state_22994__$1 = state_22994;
var statearr_22996_23018 = state_22994__$1;
(statearr_22996_23018[(2)] = inst_22990);

(statearr_22996_23018[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (1))){
var state_22994__$1 = state_22994;
var statearr_22997_23019 = state_22994__$1;
(statearr_22997_23019[(2)] = null);

(statearr_22997_23019[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (4))){
var inst_22973 = (state_22994[(7)]);
var inst_22973__$1 = (state_22994[(2)]);
var inst_22974 = (inst_22973__$1 == null);
var state_22994__$1 = (function (){var statearr_22998 = state_22994;
(statearr_22998[(7)] = inst_22973__$1);

return statearr_22998;
})();
if(cljs.core.truth_(inst_22974)){
var statearr_22999_23020 = state_22994__$1;
(statearr_22999_23020[(1)] = (5));

} else {
var statearr_23000_23021 = state_22994__$1;
(statearr_23000_23021[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (13))){
var state_22994__$1 = state_22994;
var statearr_23001_23022 = state_22994__$1;
(statearr_23001_23022[(2)] = null);

(statearr_23001_23022[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (6))){
var inst_22973 = (state_22994[(7)]);
var state_22994__$1 = state_22994;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22994__$1,(11),to,inst_22973);
} else {
if((state_val_22995 === (3))){
var inst_22992 = (state_22994[(2)]);
var state_22994__$1 = state_22994;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22994__$1,inst_22992);
} else {
if((state_val_22995 === (12))){
var state_22994__$1 = state_22994;
var statearr_23002_23023 = state_22994__$1;
(statearr_23002_23023[(2)] = null);

(statearr_23002_23023[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (2))){
var state_22994__$1 = state_22994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22994__$1,(4),from);
} else {
if((state_val_22995 === (11))){
var inst_22983 = (state_22994[(2)]);
var state_22994__$1 = state_22994;
if(cljs.core.truth_(inst_22983)){
var statearr_23003_23024 = state_22994__$1;
(statearr_23003_23024[(1)] = (12));

} else {
var statearr_23004_23025 = state_22994__$1;
(statearr_23004_23025[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (9))){
var state_22994__$1 = state_22994;
var statearr_23005_23026 = state_22994__$1;
(statearr_23005_23026[(2)] = null);

(statearr_23005_23026[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (5))){
var state_22994__$1 = state_22994;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23006_23027 = state_22994__$1;
(statearr_23006_23027[(1)] = (8));

} else {
var statearr_23007_23028 = state_22994__$1;
(statearr_23007_23028[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (14))){
var inst_22988 = (state_22994[(2)]);
var state_22994__$1 = state_22994;
var statearr_23008_23029 = state_22994__$1;
(statearr_23008_23029[(2)] = inst_22988);

(statearr_23008_23029[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (10))){
var inst_22980 = (state_22994[(2)]);
var state_22994__$1 = state_22994;
var statearr_23009_23030 = state_22994__$1;
(statearr_23009_23030[(2)] = inst_22980);

(statearr_23009_23030[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22995 === (8))){
var inst_22977 = cljs.core.async.close_BANG_(to);
var state_22994__$1 = state_22994;
var statearr_23010_23031 = state_22994__$1;
(statearr_23010_23031[(2)] = inst_22977);

(statearr_23010_23031[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_23011 = [null,null,null,null,null,null,null,null];
(statearr_23011[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_23011[(1)] = (1));

return statearr_23011;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_22994){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_22994);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23012){var ex__20869__auto__ = e23012;
var statearr_23013_23032 = state_22994;
(statearr_23013_23032[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_22994[(4)]))){
var statearr_23014_23033 = state_22994;
(statearr_23014_23033[(1)] = cljs.core.first((state_22994[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23034 = state_22994;
state_22994 = G__23034;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_22994){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_22994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23015 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23015[(6)] = c__20992__auto___23017);

return statearr_23015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__23035){
var vec__23036 = p__23035;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23036,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23036,(1),null);
var job = vec__23036;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__20992__auto___23212 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_23043){
var state_val_23044 = (state_23043[(1)]);
if((state_val_23044 === (1))){
var state_23043__$1 = state_23043;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23043__$1,(2),res,v);
} else {
if((state_val_23044 === (2))){
var inst_23040 = (state_23043[(2)]);
var inst_23041 = cljs.core.async.close_BANG_(res);
var state_23043__$1 = (function (){var statearr_23045 = state_23043;
(statearr_23045[(7)] = inst_23040);

return statearr_23045;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_23043__$1,inst_23041);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0 = (function (){
var statearr_23046 = [null,null,null,null,null,null,null,null];
(statearr_23046[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__);

(statearr_23046[(1)] = (1));

return statearr_23046;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1 = (function (state_23043){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23043);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23047){var ex__20869__auto__ = e23047;
var statearr_23048_23213 = state_23043;
(statearr_23048_23213[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23043[(4)]))){
var statearr_23049_23214 = state_23043;
(statearr_23049_23214[(1)] = cljs.core.first((state_23043[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23215 = state_23043;
state_23043 = G__23215;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = function(state_23043){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1.call(this,state_23043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23050 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23050[(6)] = c__20992__auto___23212);

return statearr_23050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__23051){
var vec__23052 = p__23051;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23052,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23052,(1),null);
var job = vec__23052;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4706__auto___23216 = n;
var __23217 = (0);
while(true){
if((__23217 < n__4706__auto___23216)){
var G__23055_23218 = type;
var G__23055_23219__$1 = (((G__23055_23218 instanceof cljs.core.Keyword))?G__23055_23218.fqn:null);
switch (G__23055_23219__$1) {
case "compute":
var c__20992__auto___23221 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__23217,c__20992__auto___23221,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async){
return (function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = ((function (__23217,c__20992__auto___23221,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async){
return (function (state_23068){
var state_val_23069 = (state_23068[(1)]);
if((state_val_23069 === (1))){
var state_23068__$1 = state_23068;
var statearr_23070_23222 = state_23068__$1;
(statearr_23070_23222[(2)] = null);

(statearr_23070_23222[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23069 === (2))){
var state_23068__$1 = state_23068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23068__$1,(4),jobs);
} else {
if((state_val_23069 === (3))){
var inst_23066 = (state_23068[(2)]);
var state_23068__$1 = state_23068;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23068__$1,inst_23066);
} else {
if((state_val_23069 === (4))){
var inst_23058 = (state_23068[(2)]);
var inst_23059 = process(inst_23058);
var state_23068__$1 = state_23068;
if(cljs.core.truth_(inst_23059)){
var statearr_23071_23223 = state_23068__$1;
(statearr_23071_23223[(1)] = (5));

} else {
var statearr_23072_23224 = state_23068__$1;
(statearr_23072_23224[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23069 === (5))){
var state_23068__$1 = state_23068;
var statearr_23073_23225 = state_23068__$1;
(statearr_23073_23225[(2)] = null);

(statearr_23073_23225[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23069 === (6))){
var state_23068__$1 = state_23068;
var statearr_23074_23226 = state_23068__$1;
(statearr_23074_23226[(2)] = null);

(statearr_23074_23226[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23069 === (7))){
var inst_23064 = (state_23068[(2)]);
var state_23068__$1 = state_23068;
var statearr_23075_23227 = state_23068__$1;
(statearr_23075_23227[(2)] = inst_23064);

(statearr_23075_23227[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__23217,c__20992__auto___23221,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async))
;
return ((function (__23217,switch__20865__auto__,c__20992__auto___23221,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0 = (function (){
var statearr_23076 = [null,null,null,null,null,null,null];
(statearr_23076[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__);

(statearr_23076[(1)] = (1));

return statearr_23076;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1 = (function (state_23068){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23068);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23077){var ex__20869__auto__ = e23077;
var statearr_23078_23228 = state_23068;
(statearr_23078_23228[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23068[(4)]))){
var statearr_23079_23229 = state_23068;
(statearr_23079_23229[(1)] = cljs.core.first((state_23068[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23230 = state_23068;
state_23068 = G__23230;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = function(state_23068){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1.call(this,state_23068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__;
})()
;})(__23217,switch__20865__auto__,c__20992__auto___23221,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async))
})();
var state__20994__auto__ = (function (){var statearr_23080 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23080[(6)] = c__20992__auto___23221);

return statearr_23080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
});})(__23217,c__20992__auto___23221,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async))
);


break;
case "async":
var c__20992__auto___23231 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__23217,c__20992__auto___23231,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async){
return (function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = ((function (__23217,c__20992__auto___23231,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async){
return (function (state_23093){
var state_val_23094 = (state_23093[(1)]);
if((state_val_23094 === (1))){
var state_23093__$1 = state_23093;
var statearr_23095_23232 = state_23093__$1;
(statearr_23095_23232[(2)] = null);

(statearr_23095_23232[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23094 === (2))){
var state_23093__$1 = state_23093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23093__$1,(4),jobs);
} else {
if((state_val_23094 === (3))){
var inst_23091 = (state_23093[(2)]);
var state_23093__$1 = state_23093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23093__$1,inst_23091);
} else {
if((state_val_23094 === (4))){
var inst_23083 = (state_23093[(2)]);
var inst_23084 = async(inst_23083);
var state_23093__$1 = state_23093;
if(cljs.core.truth_(inst_23084)){
var statearr_23096_23233 = state_23093__$1;
(statearr_23096_23233[(1)] = (5));

} else {
var statearr_23097_23234 = state_23093__$1;
(statearr_23097_23234[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23094 === (5))){
var state_23093__$1 = state_23093;
var statearr_23098_23235 = state_23093__$1;
(statearr_23098_23235[(2)] = null);

(statearr_23098_23235[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23094 === (6))){
var state_23093__$1 = state_23093;
var statearr_23099_23236 = state_23093__$1;
(statearr_23099_23236[(2)] = null);

(statearr_23099_23236[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23094 === (7))){
var inst_23089 = (state_23093[(2)]);
var state_23093__$1 = state_23093;
var statearr_23100_23237 = state_23093__$1;
(statearr_23100_23237[(2)] = inst_23089);

(statearr_23100_23237[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__23217,c__20992__auto___23231,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async))
;
return ((function (__23217,switch__20865__auto__,c__20992__auto___23231,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0 = (function (){
var statearr_23101 = [null,null,null,null,null,null,null];
(statearr_23101[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__);

(statearr_23101[(1)] = (1));

return statearr_23101;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1 = (function (state_23093){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23093);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23102){var ex__20869__auto__ = e23102;
var statearr_23103_23238 = state_23093;
(statearr_23103_23238[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23093[(4)]))){
var statearr_23104_23239 = state_23093;
(statearr_23104_23239[(1)] = cljs.core.first((state_23093[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23240 = state_23093;
state_23093 = G__23240;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = function(state_23093){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1.call(this,state_23093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__;
})()
;})(__23217,switch__20865__auto__,c__20992__auto___23231,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async))
})();
var state__20994__auto__ = (function (){var statearr_23105 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23105[(6)] = c__20992__auto___23231);

return statearr_23105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
});})(__23217,c__20992__auto___23231,G__23055_23218,G__23055_23219__$1,n__4706__auto___23216,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23055_23219__$1)].join('')));

}

var G__23241 = (__23217 + (1));
__23217 = G__23241;
continue;
} else {
}
break;
}

var c__20992__auto___23242 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_23127){
var state_val_23128 = (state_23127[(1)]);
if((state_val_23128 === (7))){
var inst_23123 = (state_23127[(2)]);
var state_23127__$1 = state_23127;
var statearr_23129_23243 = state_23127__$1;
(statearr_23129_23243[(2)] = inst_23123);

(statearr_23129_23243[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23128 === (1))){
var state_23127__$1 = state_23127;
var statearr_23130_23244 = state_23127__$1;
(statearr_23130_23244[(2)] = null);

(statearr_23130_23244[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23128 === (4))){
var inst_23108 = (state_23127[(7)]);
var inst_23108__$1 = (state_23127[(2)]);
var inst_23109 = (inst_23108__$1 == null);
var state_23127__$1 = (function (){var statearr_23131 = state_23127;
(statearr_23131[(7)] = inst_23108__$1);

return statearr_23131;
})();
if(cljs.core.truth_(inst_23109)){
var statearr_23132_23245 = state_23127__$1;
(statearr_23132_23245[(1)] = (5));

} else {
var statearr_23133_23246 = state_23127__$1;
(statearr_23133_23246[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23128 === (6))){
var inst_23113 = (state_23127[(8)]);
var inst_23108 = (state_23127[(7)]);
var inst_23113__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_23114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23115 = [inst_23108,inst_23113__$1];
var inst_23116 = (new cljs.core.PersistentVector(null,2,(5),inst_23114,inst_23115,null));
var state_23127__$1 = (function (){var statearr_23134 = state_23127;
(statearr_23134[(8)] = inst_23113__$1);

return statearr_23134;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23127__$1,(8),jobs,inst_23116);
} else {
if((state_val_23128 === (3))){
var inst_23125 = (state_23127[(2)]);
var state_23127__$1 = state_23127;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23127__$1,inst_23125);
} else {
if((state_val_23128 === (2))){
var state_23127__$1 = state_23127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23127__$1,(4),from);
} else {
if((state_val_23128 === (9))){
var inst_23120 = (state_23127[(2)]);
var state_23127__$1 = (function (){var statearr_23135 = state_23127;
(statearr_23135[(9)] = inst_23120);

return statearr_23135;
})();
var statearr_23136_23247 = state_23127__$1;
(statearr_23136_23247[(2)] = null);

(statearr_23136_23247[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23128 === (5))){
var inst_23111 = cljs.core.async.close_BANG_(jobs);
var state_23127__$1 = state_23127;
var statearr_23137_23248 = state_23127__$1;
(statearr_23137_23248[(2)] = inst_23111);

(statearr_23137_23248[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23128 === (8))){
var inst_23113 = (state_23127[(8)]);
var inst_23118 = (state_23127[(2)]);
var state_23127__$1 = (function (){var statearr_23138 = state_23127;
(statearr_23138[(10)] = inst_23118);

return statearr_23138;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23127__$1,(9),results,inst_23113);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0 = (function (){
var statearr_23139 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23139[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__);

(statearr_23139[(1)] = (1));

return statearr_23139;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1 = (function (state_23127){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23127);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23140){var ex__20869__auto__ = e23140;
var statearr_23141_23249 = state_23127;
(statearr_23141_23249[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23127[(4)]))){
var statearr_23142_23250 = state_23127;
(statearr_23142_23250[(1)] = cljs.core.first((state_23127[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23251 = state_23127;
state_23127 = G__23251;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = function(state_23127){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1.call(this,state_23127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23143 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23143[(6)] = c__20992__auto___23242);

return statearr_23143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


var c__20992__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_23181){
var state_val_23182 = (state_23181[(1)]);
if((state_val_23182 === (7))){
var inst_23177 = (state_23181[(2)]);
var state_23181__$1 = state_23181;
var statearr_23183_23252 = state_23181__$1;
(statearr_23183_23252[(2)] = inst_23177);

(statearr_23183_23252[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (20))){
var state_23181__$1 = state_23181;
var statearr_23184_23253 = state_23181__$1;
(statearr_23184_23253[(2)] = null);

(statearr_23184_23253[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (1))){
var state_23181__$1 = state_23181;
var statearr_23185_23254 = state_23181__$1;
(statearr_23185_23254[(2)] = null);

(statearr_23185_23254[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (4))){
var inst_23146 = (state_23181[(7)]);
var inst_23146__$1 = (state_23181[(2)]);
var inst_23147 = (inst_23146__$1 == null);
var state_23181__$1 = (function (){var statearr_23186 = state_23181;
(statearr_23186[(7)] = inst_23146__$1);

return statearr_23186;
})();
if(cljs.core.truth_(inst_23147)){
var statearr_23187_23255 = state_23181__$1;
(statearr_23187_23255[(1)] = (5));

} else {
var statearr_23188_23256 = state_23181__$1;
(statearr_23188_23256[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (15))){
var inst_23159 = (state_23181[(8)]);
var state_23181__$1 = state_23181;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23181__$1,(18),to,inst_23159);
} else {
if((state_val_23182 === (21))){
var inst_23172 = (state_23181[(2)]);
var state_23181__$1 = state_23181;
var statearr_23189_23257 = state_23181__$1;
(statearr_23189_23257[(2)] = inst_23172);

(statearr_23189_23257[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (13))){
var inst_23174 = (state_23181[(2)]);
var state_23181__$1 = (function (){var statearr_23190 = state_23181;
(statearr_23190[(9)] = inst_23174);

return statearr_23190;
})();
var statearr_23191_23258 = state_23181__$1;
(statearr_23191_23258[(2)] = null);

(statearr_23191_23258[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (6))){
var inst_23146 = (state_23181[(7)]);
var state_23181__$1 = state_23181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23181__$1,(11),inst_23146);
} else {
if((state_val_23182 === (17))){
var inst_23167 = (state_23181[(2)]);
var state_23181__$1 = state_23181;
if(cljs.core.truth_(inst_23167)){
var statearr_23192_23259 = state_23181__$1;
(statearr_23192_23259[(1)] = (19));

} else {
var statearr_23193_23260 = state_23181__$1;
(statearr_23193_23260[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (3))){
var inst_23179 = (state_23181[(2)]);
var state_23181__$1 = state_23181;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23181__$1,inst_23179);
} else {
if((state_val_23182 === (12))){
var inst_23156 = (state_23181[(10)]);
var state_23181__$1 = state_23181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23181__$1,(14),inst_23156);
} else {
if((state_val_23182 === (2))){
var state_23181__$1 = state_23181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23181__$1,(4),results);
} else {
if((state_val_23182 === (19))){
var state_23181__$1 = state_23181;
var statearr_23194_23261 = state_23181__$1;
(statearr_23194_23261[(2)] = null);

(statearr_23194_23261[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (11))){
var inst_23156 = (state_23181[(2)]);
var state_23181__$1 = (function (){var statearr_23195 = state_23181;
(statearr_23195[(10)] = inst_23156);

return statearr_23195;
})();
var statearr_23196_23262 = state_23181__$1;
(statearr_23196_23262[(2)] = null);

(statearr_23196_23262[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (9))){
var state_23181__$1 = state_23181;
var statearr_23197_23263 = state_23181__$1;
(statearr_23197_23263[(2)] = null);

(statearr_23197_23263[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (5))){
var state_23181__$1 = state_23181;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23198_23264 = state_23181__$1;
(statearr_23198_23264[(1)] = (8));

} else {
var statearr_23199_23265 = state_23181__$1;
(statearr_23199_23265[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (14))){
var inst_23159 = (state_23181[(8)]);
var inst_23161 = (state_23181[(11)]);
var inst_23159__$1 = (state_23181[(2)]);
var inst_23160 = (inst_23159__$1 == null);
var inst_23161__$1 = cljs.core.not(inst_23160);
var state_23181__$1 = (function (){var statearr_23200 = state_23181;
(statearr_23200[(8)] = inst_23159__$1);

(statearr_23200[(11)] = inst_23161__$1);

return statearr_23200;
})();
if(inst_23161__$1){
var statearr_23201_23266 = state_23181__$1;
(statearr_23201_23266[(1)] = (15));

} else {
var statearr_23202_23267 = state_23181__$1;
(statearr_23202_23267[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (16))){
var inst_23161 = (state_23181[(11)]);
var state_23181__$1 = state_23181;
var statearr_23203_23268 = state_23181__$1;
(statearr_23203_23268[(2)] = inst_23161);

(statearr_23203_23268[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (10))){
var inst_23153 = (state_23181[(2)]);
var state_23181__$1 = state_23181;
var statearr_23204_23269 = state_23181__$1;
(statearr_23204_23269[(2)] = inst_23153);

(statearr_23204_23269[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (18))){
var inst_23164 = (state_23181[(2)]);
var state_23181__$1 = state_23181;
var statearr_23205_23270 = state_23181__$1;
(statearr_23205_23270[(2)] = inst_23164);

(statearr_23205_23270[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23182 === (8))){
var inst_23150 = cljs.core.async.close_BANG_(to);
var state_23181__$1 = state_23181;
var statearr_23206_23271 = state_23181__$1;
(statearr_23206_23271[(2)] = inst_23150);

(statearr_23206_23271[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0 = (function (){
var statearr_23207 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23207[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__);

(statearr_23207[(1)] = (1));

return statearr_23207;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1 = (function (state_23181){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23181);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23208){var ex__20869__auto__ = e23208;
var statearr_23209_23272 = state_23181;
(statearr_23209_23272[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23181[(4)]))){
var statearr_23210_23273 = state_23181;
(statearr_23210_23273[(1)] = cljs.core.first((state_23181[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23274 = state_23181;
state_23181 = G__23274;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__ = function(state_23181){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1.call(this,state_23181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23211 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23211[(6)] = c__20992__auto__);

return statearr_23211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));

return c__20992__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__23276 = arguments.length;
switch (G__23276) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__23279 = arguments.length;
switch (G__23279) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__23282 = arguments.length;
switch (G__23282) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__20992__auto___23332 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_23308){
var state_val_23309 = (state_23308[(1)]);
if((state_val_23309 === (7))){
var inst_23304 = (state_23308[(2)]);
var state_23308__$1 = state_23308;
var statearr_23310_23333 = state_23308__$1;
(statearr_23310_23333[(2)] = inst_23304);

(statearr_23310_23333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (1))){
var state_23308__$1 = state_23308;
var statearr_23311_23334 = state_23308__$1;
(statearr_23311_23334[(2)] = null);

(statearr_23311_23334[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (4))){
var inst_23285 = (state_23308[(7)]);
var inst_23285__$1 = (state_23308[(2)]);
var inst_23286 = (inst_23285__$1 == null);
var state_23308__$1 = (function (){var statearr_23312 = state_23308;
(statearr_23312[(7)] = inst_23285__$1);

return statearr_23312;
})();
if(cljs.core.truth_(inst_23286)){
var statearr_23313_23335 = state_23308__$1;
(statearr_23313_23335[(1)] = (5));

} else {
var statearr_23314_23336 = state_23308__$1;
(statearr_23314_23336[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (13))){
var state_23308__$1 = state_23308;
var statearr_23315_23337 = state_23308__$1;
(statearr_23315_23337[(2)] = null);

(statearr_23315_23337[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (6))){
var inst_23285 = (state_23308[(7)]);
var inst_23291 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_23285) : p.call(null,inst_23285));
var state_23308__$1 = state_23308;
if(cljs.core.truth_(inst_23291)){
var statearr_23316_23338 = state_23308__$1;
(statearr_23316_23338[(1)] = (9));

} else {
var statearr_23317_23339 = state_23308__$1;
(statearr_23317_23339[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (3))){
var inst_23306 = (state_23308[(2)]);
var state_23308__$1 = state_23308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23308__$1,inst_23306);
} else {
if((state_val_23309 === (12))){
var state_23308__$1 = state_23308;
var statearr_23318_23340 = state_23308__$1;
(statearr_23318_23340[(2)] = null);

(statearr_23318_23340[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (2))){
var state_23308__$1 = state_23308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23308__$1,(4),ch);
} else {
if((state_val_23309 === (11))){
var inst_23285 = (state_23308[(7)]);
var inst_23295 = (state_23308[(2)]);
var state_23308__$1 = state_23308;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23308__$1,(8),inst_23295,inst_23285);
} else {
if((state_val_23309 === (9))){
var state_23308__$1 = state_23308;
var statearr_23319_23341 = state_23308__$1;
(statearr_23319_23341[(2)] = tc);

(statearr_23319_23341[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (5))){
var inst_23288 = cljs.core.async.close_BANG_(tc);
var inst_23289 = cljs.core.async.close_BANG_(fc);
var state_23308__$1 = (function (){var statearr_23320 = state_23308;
(statearr_23320[(8)] = inst_23288);

return statearr_23320;
})();
var statearr_23321_23342 = state_23308__$1;
(statearr_23321_23342[(2)] = inst_23289);

(statearr_23321_23342[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (14))){
var inst_23302 = (state_23308[(2)]);
var state_23308__$1 = state_23308;
var statearr_23322_23343 = state_23308__$1;
(statearr_23322_23343[(2)] = inst_23302);

(statearr_23322_23343[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (10))){
var state_23308__$1 = state_23308;
var statearr_23323_23344 = state_23308__$1;
(statearr_23323_23344[(2)] = fc);

(statearr_23323_23344[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23309 === (8))){
var inst_23297 = (state_23308[(2)]);
var state_23308__$1 = state_23308;
if(cljs.core.truth_(inst_23297)){
var statearr_23324_23345 = state_23308__$1;
(statearr_23324_23345[(1)] = (12));

} else {
var statearr_23325_23346 = state_23308__$1;
(statearr_23325_23346[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_23326 = [null,null,null,null,null,null,null,null,null];
(statearr_23326[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_23326[(1)] = (1));

return statearr_23326;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_23308){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23308);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23327){var ex__20869__auto__ = e23327;
var statearr_23328_23347 = state_23308;
(statearr_23328_23347[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23308[(4)]))){
var statearr_23329_23348 = state_23308;
(statearr_23329_23348[(1)] = cljs.core.first((state_23308[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23349 = state_23308;
state_23308 = G__23349;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_23308){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_23308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23330 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23330[(6)] = c__20992__auto___23332);

return statearr_23330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20992__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_23371){
var state_val_23372 = (state_23371[(1)]);
if((state_val_23372 === (7))){
var inst_23367 = (state_23371[(2)]);
var state_23371__$1 = state_23371;
var statearr_23373_23392 = state_23371__$1;
(statearr_23373_23392[(2)] = inst_23367);

(statearr_23373_23392[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23372 === (1))){
var inst_23350 = init;
var inst_23351 = inst_23350;
var state_23371__$1 = (function (){var statearr_23374 = state_23371;
(statearr_23374[(7)] = inst_23351);

return statearr_23374;
})();
var statearr_23375_23393 = state_23371__$1;
(statearr_23375_23393[(2)] = null);

(statearr_23375_23393[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23372 === (4))){
var inst_23354 = (state_23371[(8)]);
var inst_23354__$1 = (state_23371[(2)]);
var inst_23355 = (inst_23354__$1 == null);
var state_23371__$1 = (function (){var statearr_23376 = state_23371;
(statearr_23376[(8)] = inst_23354__$1);

return statearr_23376;
})();
if(cljs.core.truth_(inst_23355)){
var statearr_23377_23394 = state_23371__$1;
(statearr_23377_23394[(1)] = (5));

} else {
var statearr_23378_23395 = state_23371__$1;
(statearr_23378_23395[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23372 === (6))){
var inst_23351 = (state_23371[(7)]);
var inst_23354 = (state_23371[(8)]);
var inst_23358 = (state_23371[(9)]);
var inst_23358__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_23351,inst_23354) : f.call(null,inst_23351,inst_23354));
var inst_23359 = cljs.core.reduced_QMARK_(inst_23358__$1);
var state_23371__$1 = (function (){var statearr_23379 = state_23371;
(statearr_23379[(9)] = inst_23358__$1);

return statearr_23379;
})();
if(inst_23359){
var statearr_23380_23396 = state_23371__$1;
(statearr_23380_23396[(1)] = (8));

} else {
var statearr_23381_23397 = state_23371__$1;
(statearr_23381_23397[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23372 === (3))){
var inst_23369 = (state_23371[(2)]);
var state_23371__$1 = state_23371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23371__$1,inst_23369);
} else {
if((state_val_23372 === (2))){
var state_23371__$1 = state_23371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23371__$1,(4),ch);
} else {
if((state_val_23372 === (9))){
var inst_23358 = (state_23371[(9)]);
var inst_23351 = inst_23358;
var state_23371__$1 = (function (){var statearr_23382 = state_23371;
(statearr_23382[(7)] = inst_23351);

return statearr_23382;
})();
var statearr_23383_23398 = state_23371__$1;
(statearr_23383_23398[(2)] = null);

(statearr_23383_23398[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23372 === (5))){
var inst_23351 = (state_23371[(7)]);
var state_23371__$1 = state_23371;
var statearr_23384_23399 = state_23371__$1;
(statearr_23384_23399[(2)] = inst_23351);

(statearr_23384_23399[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23372 === (10))){
var inst_23365 = (state_23371[(2)]);
var state_23371__$1 = state_23371;
var statearr_23385_23400 = state_23371__$1;
(statearr_23385_23400[(2)] = inst_23365);

(statearr_23385_23400[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23372 === (8))){
var inst_23358 = (state_23371[(9)]);
var inst_23361 = cljs.core.deref(inst_23358);
var state_23371__$1 = state_23371;
var statearr_23386_23401 = state_23371__$1;
(statearr_23386_23401[(2)] = inst_23361);

(statearr_23386_23401[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__20866__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20866__auto____0 = (function (){
var statearr_23387 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23387[(0)] = cljs$core$async$reduce_$_state_machine__20866__auto__);

(statearr_23387[(1)] = (1));

return statearr_23387;
});
var cljs$core$async$reduce_$_state_machine__20866__auto____1 = (function (state_23371){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23371);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23388){var ex__20869__auto__ = e23388;
var statearr_23389_23402 = state_23371;
(statearr_23389_23402[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23371[(4)]))){
var statearr_23390_23403 = state_23371;
(statearr_23390_23403[(1)] = cljs.core.first((state_23371[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23404 = state_23371;
state_23371 = G__23404;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20866__auto__ = function(state_23371){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20866__auto____1.call(this,state_23371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20866__auto____0;
cljs$core$async$reduce_$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20866__auto____1;
return cljs$core$async$reduce_$_state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23391 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23391[(6)] = c__20992__auto__);

return statearr_23391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));

return c__20992__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__20992__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_23410){
var state_val_23411 = (state_23410[(1)]);
if((state_val_23411 === (1))){
var inst_23405 = cljs.core.async.reduce(f__$1,init,ch);
var state_23410__$1 = state_23410;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23410__$1,(2),inst_23405);
} else {
if((state_val_23411 === (2))){
var inst_23407 = (state_23410[(2)]);
var inst_23408 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_23407) : f__$1.call(null,inst_23407));
var state_23410__$1 = state_23410;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23410__$1,inst_23408);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__20866__auto__ = null;
var cljs$core$async$transduce_$_state_machine__20866__auto____0 = (function (){
var statearr_23412 = [null,null,null,null,null,null,null];
(statearr_23412[(0)] = cljs$core$async$transduce_$_state_machine__20866__auto__);

(statearr_23412[(1)] = (1));

return statearr_23412;
});
var cljs$core$async$transduce_$_state_machine__20866__auto____1 = (function (state_23410){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23410);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23413){var ex__20869__auto__ = e23413;
var statearr_23414_23417 = state_23410;
(statearr_23414_23417[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23410[(4)]))){
var statearr_23415_23418 = state_23410;
(statearr_23415_23418[(1)] = cljs.core.first((state_23410[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23419 = state_23410;
state_23410 = G__23419;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__20866__auto__ = function(state_23410){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__20866__auto____1.call(this,state_23410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__20866__auto____0;
cljs$core$async$transduce_$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__20866__auto____1;
return cljs$core$async$transduce_$_state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23416 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23416[(6)] = c__20992__auto__);

return statearr_23416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));

return c__20992__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__23421 = arguments.length;
switch (G__23421) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20992__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_23446){
var state_val_23447 = (state_23446[(1)]);
if((state_val_23447 === (7))){
var inst_23428 = (state_23446[(2)]);
var state_23446__$1 = state_23446;
var statearr_23448_23470 = state_23446__$1;
(statearr_23448_23470[(2)] = inst_23428);

(statearr_23448_23470[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (1))){
var inst_23422 = cljs.core.seq(coll);
var inst_23423 = inst_23422;
var state_23446__$1 = (function (){var statearr_23449 = state_23446;
(statearr_23449[(7)] = inst_23423);

return statearr_23449;
})();
var statearr_23450_23471 = state_23446__$1;
(statearr_23450_23471[(2)] = null);

(statearr_23450_23471[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (4))){
var inst_23423 = (state_23446[(7)]);
var inst_23426 = cljs.core.first(inst_23423);
var state_23446__$1 = state_23446;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23446__$1,(7),ch,inst_23426);
} else {
if((state_val_23447 === (13))){
var inst_23440 = (state_23446[(2)]);
var state_23446__$1 = state_23446;
var statearr_23451_23472 = state_23446__$1;
(statearr_23451_23472[(2)] = inst_23440);

(statearr_23451_23472[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (6))){
var inst_23431 = (state_23446[(2)]);
var state_23446__$1 = state_23446;
if(cljs.core.truth_(inst_23431)){
var statearr_23452_23473 = state_23446__$1;
(statearr_23452_23473[(1)] = (8));

} else {
var statearr_23453_23474 = state_23446__$1;
(statearr_23453_23474[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (3))){
var inst_23444 = (state_23446[(2)]);
var state_23446__$1 = state_23446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23446__$1,inst_23444);
} else {
if((state_val_23447 === (12))){
var state_23446__$1 = state_23446;
var statearr_23454_23475 = state_23446__$1;
(statearr_23454_23475[(2)] = null);

(statearr_23454_23475[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (2))){
var inst_23423 = (state_23446[(7)]);
var state_23446__$1 = state_23446;
if(cljs.core.truth_(inst_23423)){
var statearr_23455_23476 = state_23446__$1;
(statearr_23455_23476[(1)] = (4));

} else {
var statearr_23456_23477 = state_23446__$1;
(statearr_23456_23477[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (11))){
var inst_23437 = cljs.core.async.close_BANG_(ch);
var state_23446__$1 = state_23446;
var statearr_23457_23478 = state_23446__$1;
(statearr_23457_23478[(2)] = inst_23437);

(statearr_23457_23478[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (9))){
var state_23446__$1 = state_23446;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23458_23479 = state_23446__$1;
(statearr_23458_23479[(1)] = (11));

} else {
var statearr_23459_23480 = state_23446__$1;
(statearr_23459_23480[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (5))){
var inst_23423 = (state_23446[(7)]);
var state_23446__$1 = state_23446;
var statearr_23460_23481 = state_23446__$1;
(statearr_23460_23481[(2)] = inst_23423);

(statearr_23460_23481[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (10))){
var inst_23442 = (state_23446[(2)]);
var state_23446__$1 = state_23446;
var statearr_23461_23482 = state_23446__$1;
(statearr_23461_23482[(2)] = inst_23442);

(statearr_23461_23482[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23447 === (8))){
var inst_23423 = (state_23446[(7)]);
var inst_23433 = cljs.core.next(inst_23423);
var inst_23423__$1 = inst_23433;
var state_23446__$1 = (function (){var statearr_23462 = state_23446;
(statearr_23462[(7)] = inst_23423__$1);

return statearr_23462;
})();
var statearr_23463_23483 = state_23446__$1;
(statearr_23463_23483[(2)] = null);

(statearr_23463_23483[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_23464 = [null,null,null,null,null,null,null,null];
(statearr_23464[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_23464[(1)] = (1));

return statearr_23464;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_23446){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23446);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23465){var ex__20869__auto__ = e23465;
var statearr_23466_23484 = state_23446;
(statearr_23466_23484[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23446[(4)]))){
var statearr_23467_23485 = state_23446;
(statearr_23467_23485[(1)] = cljs.core.first((state_23446[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23486 = state_23446;
state_23446 = G__23486;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_23446){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_23446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23468 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23468[(6)] = c__20992__auto__);

return statearr_23468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));

return c__20992__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__23488 = arguments.length;
switch (G__23488) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_23490 = (function (_){
var x__4521__auto__ = (((_ == null))?null:_);
var m__4522__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4522__auto__.call(null,_));
} else {
var m__4519__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4519__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_23490(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_23491 = (function (m,ch,close_QMARK_){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4522__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4519__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_23491(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_23492 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_23492(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_23493 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_23493(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23494 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23494 = (function (ch,cs,meta23495){
this.ch = ch;
this.cs = cs;
this.meta23495 = meta23495;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23494.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23496,meta23495__$1){
var self__ = this;
var _23496__$1 = this;
return (new cljs.core.async.t_cljs$core$async23494(self__.ch,self__.cs,meta23495__$1));
}));

(cljs.core.async.t_cljs$core$async23494.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23496){
var self__ = this;
var _23496__$1 = this;
return self__.meta23495;
}));

(cljs.core.async.t_cljs$core$async23494.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23494.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async23494.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23494.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async23494.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async23494.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async23494.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta23495], null);
}));

(cljs.core.async.t_cljs$core$async23494.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23494.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23494");

(cljs.core.async.t_cljs$core$async23494.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23494");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23494.
 */
cljs.core.async.__GT_t_cljs$core$async23494 = (function cljs$core$async$mult_$___GT_t_cljs$core$async23494(ch__$1,cs__$1,meta23495){
return (new cljs.core.async.t_cljs$core$async23494(ch__$1,cs__$1,meta23495));
});

}

return (new cljs.core.async.t_cljs$core$async23494(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__20992__auto___23713 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_23629){
var state_val_23630 = (state_23629[(1)]);
if((state_val_23630 === (7))){
var inst_23625 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
var statearr_23631_23714 = state_23629__$1;
(statearr_23631_23714[(2)] = inst_23625);

(statearr_23631_23714[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (20))){
var inst_23530 = (state_23629[(7)]);
var inst_23542 = cljs.core.first(inst_23530);
var inst_23543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23542,(0),null);
var inst_23544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23542,(1),null);
var state_23629__$1 = (function (){var statearr_23632 = state_23629;
(statearr_23632[(8)] = inst_23543);

return statearr_23632;
})();
if(cljs.core.truth_(inst_23544)){
var statearr_23633_23715 = state_23629__$1;
(statearr_23633_23715[(1)] = (22));

} else {
var statearr_23634_23716 = state_23629__$1;
(statearr_23634_23716[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (27))){
var inst_23499 = (state_23629[(9)]);
var inst_23579 = (state_23629[(10)]);
var inst_23574 = (state_23629[(11)]);
var inst_23572 = (state_23629[(12)]);
var inst_23579__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_23572,inst_23574);
var inst_23580 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_23579__$1,inst_23499,done);
var state_23629__$1 = (function (){var statearr_23635 = state_23629;
(statearr_23635[(10)] = inst_23579__$1);

return statearr_23635;
})();
if(cljs.core.truth_(inst_23580)){
var statearr_23636_23717 = state_23629__$1;
(statearr_23636_23717[(1)] = (30));

} else {
var statearr_23637_23718 = state_23629__$1;
(statearr_23637_23718[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (1))){
var state_23629__$1 = state_23629;
var statearr_23638_23719 = state_23629__$1;
(statearr_23638_23719[(2)] = null);

(statearr_23638_23719[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (24))){
var inst_23530 = (state_23629[(7)]);
var inst_23549 = (state_23629[(2)]);
var inst_23550 = cljs.core.next(inst_23530);
var inst_23508 = inst_23550;
var inst_23509 = null;
var inst_23510 = (0);
var inst_23511 = (0);
var state_23629__$1 = (function (){var statearr_23639 = state_23629;
(statearr_23639[(13)] = inst_23511);

(statearr_23639[(14)] = inst_23509);

(statearr_23639[(15)] = inst_23549);

(statearr_23639[(16)] = inst_23510);

(statearr_23639[(17)] = inst_23508);

return statearr_23639;
})();
var statearr_23640_23720 = state_23629__$1;
(statearr_23640_23720[(2)] = null);

(statearr_23640_23720[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (39))){
var state_23629__$1 = state_23629;
var statearr_23644_23721 = state_23629__$1;
(statearr_23644_23721[(2)] = null);

(statearr_23644_23721[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (4))){
var inst_23499 = (state_23629[(9)]);
var inst_23499__$1 = (state_23629[(2)]);
var inst_23500 = (inst_23499__$1 == null);
var state_23629__$1 = (function (){var statearr_23645 = state_23629;
(statearr_23645[(9)] = inst_23499__$1);

return statearr_23645;
})();
if(cljs.core.truth_(inst_23500)){
var statearr_23646_23722 = state_23629__$1;
(statearr_23646_23722[(1)] = (5));

} else {
var statearr_23647_23723 = state_23629__$1;
(statearr_23647_23723[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (15))){
var inst_23511 = (state_23629[(13)]);
var inst_23509 = (state_23629[(14)]);
var inst_23510 = (state_23629[(16)]);
var inst_23508 = (state_23629[(17)]);
var inst_23526 = (state_23629[(2)]);
var inst_23527 = (inst_23511 + (1));
var tmp23641 = inst_23509;
var tmp23642 = inst_23510;
var tmp23643 = inst_23508;
var inst_23508__$1 = tmp23643;
var inst_23509__$1 = tmp23641;
var inst_23510__$1 = tmp23642;
var inst_23511__$1 = inst_23527;
var state_23629__$1 = (function (){var statearr_23648 = state_23629;
(statearr_23648[(13)] = inst_23511__$1);

(statearr_23648[(14)] = inst_23509__$1);

(statearr_23648[(16)] = inst_23510__$1);

(statearr_23648[(17)] = inst_23508__$1);

(statearr_23648[(18)] = inst_23526);

return statearr_23648;
})();
var statearr_23649_23724 = state_23629__$1;
(statearr_23649_23724[(2)] = null);

(statearr_23649_23724[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (21))){
var inst_23553 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
var statearr_23653_23725 = state_23629__$1;
(statearr_23653_23725[(2)] = inst_23553);

(statearr_23653_23725[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (31))){
var inst_23579 = (state_23629[(10)]);
var inst_23583 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_23579);
var state_23629__$1 = state_23629;
var statearr_23654_23726 = state_23629__$1;
(statearr_23654_23726[(2)] = inst_23583);

(statearr_23654_23726[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (32))){
var inst_23571 = (state_23629[(19)]);
var inst_23573 = (state_23629[(20)]);
var inst_23574 = (state_23629[(11)]);
var inst_23572 = (state_23629[(12)]);
var inst_23585 = (state_23629[(2)]);
var inst_23586 = (inst_23574 + (1));
var tmp23650 = inst_23571;
var tmp23651 = inst_23573;
var tmp23652 = inst_23572;
var inst_23571__$1 = tmp23650;
var inst_23572__$1 = tmp23652;
var inst_23573__$1 = tmp23651;
var inst_23574__$1 = inst_23586;
var state_23629__$1 = (function (){var statearr_23655 = state_23629;
(statearr_23655[(19)] = inst_23571__$1);

(statearr_23655[(20)] = inst_23573__$1);

(statearr_23655[(11)] = inst_23574__$1);

(statearr_23655[(21)] = inst_23585);

(statearr_23655[(12)] = inst_23572__$1);

return statearr_23655;
})();
var statearr_23656_23727 = state_23629__$1;
(statearr_23656_23727[(2)] = null);

(statearr_23656_23727[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (40))){
var inst_23598 = (state_23629[(22)]);
var inst_23602 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_23598);
var state_23629__$1 = state_23629;
var statearr_23657_23728 = state_23629__$1;
(statearr_23657_23728[(2)] = inst_23602);

(statearr_23657_23728[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (33))){
var inst_23589 = (state_23629[(23)]);
var inst_23591 = cljs.core.chunked_seq_QMARK_(inst_23589);
var state_23629__$1 = state_23629;
if(inst_23591){
var statearr_23658_23729 = state_23629__$1;
(statearr_23658_23729[(1)] = (36));

} else {
var statearr_23659_23730 = state_23629__$1;
(statearr_23659_23730[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (13))){
var inst_23520 = (state_23629[(24)]);
var inst_23523 = cljs.core.async.close_BANG_(inst_23520);
var state_23629__$1 = state_23629;
var statearr_23660_23731 = state_23629__$1;
(statearr_23660_23731[(2)] = inst_23523);

(statearr_23660_23731[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (22))){
var inst_23543 = (state_23629[(8)]);
var inst_23546 = cljs.core.async.close_BANG_(inst_23543);
var state_23629__$1 = state_23629;
var statearr_23661_23732 = state_23629__$1;
(statearr_23661_23732[(2)] = inst_23546);

(statearr_23661_23732[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (36))){
var inst_23589 = (state_23629[(23)]);
var inst_23593 = cljs.core.chunk_first(inst_23589);
var inst_23594 = cljs.core.chunk_rest(inst_23589);
var inst_23595 = cljs.core.count(inst_23593);
var inst_23571 = inst_23594;
var inst_23572 = inst_23593;
var inst_23573 = inst_23595;
var inst_23574 = (0);
var state_23629__$1 = (function (){var statearr_23662 = state_23629;
(statearr_23662[(19)] = inst_23571);

(statearr_23662[(20)] = inst_23573);

(statearr_23662[(11)] = inst_23574);

(statearr_23662[(12)] = inst_23572);

return statearr_23662;
})();
var statearr_23663_23733 = state_23629__$1;
(statearr_23663_23733[(2)] = null);

(statearr_23663_23733[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (41))){
var inst_23589 = (state_23629[(23)]);
var inst_23604 = (state_23629[(2)]);
var inst_23605 = cljs.core.next(inst_23589);
var inst_23571 = inst_23605;
var inst_23572 = null;
var inst_23573 = (0);
var inst_23574 = (0);
var state_23629__$1 = (function (){var statearr_23664 = state_23629;
(statearr_23664[(19)] = inst_23571);

(statearr_23664[(25)] = inst_23604);

(statearr_23664[(20)] = inst_23573);

(statearr_23664[(11)] = inst_23574);

(statearr_23664[(12)] = inst_23572);

return statearr_23664;
})();
var statearr_23665_23734 = state_23629__$1;
(statearr_23665_23734[(2)] = null);

(statearr_23665_23734[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (43))){
var state_23629__$1 = state_23629;
var statearr_23666_23735 = state_23629__$1;
(statearr_23666_23735[(2)] = null);

(statearr_23666_23735[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (29))){
var inst_23613 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
var statearr_23667_23736 = state_23629__$1;
(statearr_23667_23736[(2)] = inst_23613);

(statearr_23667_23736[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (44))){
var inst_23622 = (state_23629[(2)]);
var state_23629__$1 = (function (){var statearr_23668 = state_23629;
(statearr_23668[(26)] = inst_23622);

return statearr_23668;
})();
var statearr_23669_23737 = state_23629__$1;
(statearr_23669_23737[(2)] = null);

(statearr_23669_23737[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (6))){
var inst_23563 = (state_23629[(27)]);
var inst_23562 = cljs.core.deref(cs);
var inst_23563__$1 = cljs.core.keys(inst_23562);
var inst_23564 = cljs.core.count(inst_23563__$1);
var inst_23565 = cljs.core.reset_BANG_(dctr,inst_23564);
var inst_23570 = cljs.core.seq(inst_23563__$1);
var inst_23571 = inst_23570;
var inst_23572 = null;
var inst_23573 = (0);
var inst_23574 = (0);
var state_23629__$1 = (function (){var statearr_23670 = state_23629;
(statearr_23670[(19)] = inst_23571);

(statearr_23670[(27)] = inst_23563__$1);

(statearr_23670[(20)] = inst_23573);

(statearr_23670[(11)] = inst_23574);

(statearr_23670[(28)] = inst_23565);

(statearr_23670[(12)] = inst_23572);

return statearr_23670;
})();
var statearr_23671_23738 = state_23629__$1;
(statearr_23671_23738[(2)] = null);

(statearr_23671_23738[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (28))){
var inst_23571 = (state_23629[(19)]);
var inst_23589 = (state_23629[(23)]);
var inst_23589__$1 = cljs.core.seq(inst_23571);
var state_23629__$1 = (function (){var statearr_23672 = state_23629;
(statearr_23672[(23)] = inst_23589__$1);

return statearr_23672;
})();
if(inst_23589__$1){
var statearr_23673_23739 = state_23629__$1;
(statearr_23673_23739[(1)] = (33));

} else {
var statearr_23674_23740 = state_23629__$1;
(statearr_23674_23740[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (25))){
var inst_23573 = (state_23629[(20)]);
var inst_23574 = (state_23629[(11)]);
var inst_23576 = (inst_23574 < inst_23573);
var inst_23577 = inst_23576;
var state_23629__$1 = state_23629;
if(cljs.core.truth_(inst_23577)){
var statearr_23675_23741 = state_23629__$1;
(statearr_23675_23741[(1)] = (27));

} else {
var statearr_23676_23742 = state_23629__$1;
(statearr_23676_23742[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (34))){
var state_23629__$1 = state_23629;
var statearr_23677_23743 = state_23629__$1;
(statearr_23677_23743[(2)] = null);

(statearr_23677_23743[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (17))){
var state_23629__$1 = state_23629;
var statearr_23678_23744 = state_23629__$1;
(statearr_23678_23744[(2)] = null);

(statearr_23678_23744[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (3))){
var inst_23627 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23629__$1,inst_23627);
} else {
if((state_val_23630 === (12))){
var inst_23558 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
var statearr_23679_23745 = state_23629__$1;
(statearr_23679_23745[(2)] = inst_23558);

(statearr_23679_23745[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (2))){
var state_23629__$1 = state_23629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23629__$1,(4),ch);
} else {
if((state_val_23630 === (23))){
var state_23629__$1 = state_23629;
var statearr_23680_23746 = state_23629__$1;
(statearr_23680_23746[(2)] = null);

(statearr_23680_23746[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (35))){
var inst_23611 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
var statearr_23681_23747 = state_23629__$1;
(statearr_23681_23747[(2)] = inst_23611);

(statearr_23681_23747[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (19))){
var inst_23530 = (state_23629[(7)]);
var inst_23534 = cljs.core.chunk_first(inst_23530);
var inst_23535 = cljs.core.chunk_rest(inst_23530);
var inst_23536 = cljs.core.count(inst_23534);
var inst_23508 = inst_23535;
var inst_23509 = inst_23534;
var inst_23510 = inst_23536;
var inst_23511 = (0);
var state_23629__$1 = (function (){var statearr_23682 = state_23629;
(statearr_23682[(13)] = inst_23511);

(statearr_23682[(14)] = inst_23509);

(statearr_23682[(16)] = inst_23510);

(statearr_23682[(17)] = inst_23508);

return statearr_23682;
})();
var statearr_23683_23748 = state_23629__$1;
(statearr_23683_23748[(2)] = null);

(statearr_23683_23748[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (11))){
var inst_23530 = (state_23629[(7)]);
var inst_23508 = (state_23629[(17)]);
var inst_23530__$1 = cljs.core.seq(inst_23508);
var state_23629__$1 = (function (){var statearr_23684 = state_23629;
(statearr_23684[(7)] = inst_23530__$1);

return statearr_23684;
})();
if(inst_23530__$1){
var statearr_23685_23749 = state_23629__$1;
(statearr_23685_23749[(1)] = (16));

} else {
var statearr_23686_23750 = state_23629__$1;
(statearr_23686_23750[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (9))){
var inst_23560 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
var statearr_23687_23751 = state_23629__$1;
(statearr_23687_23751[(2)] = inst_23560);

(statearr_23687_23751[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (5))){
var inst_23506 = cljs.core.deref(cs);
var inst_23507 = cljs.core.seq(inst_23506);
var inst_23508 = inst_23507;
var inst_23509 = null;
var inst_23510 = (0);
var inst_23511 = (0);
var state_23629__$1 = (function (){var statearr_23688 = state_23629;
(statearr_23688[(13)] = inst_23511);

(statearr_23688[(14)] = inst_23509);

(statearr_23688[(16)] = inst_23510);

(statearr_23688[(17)] = inst_23508);

return statearr_23688;
})();
var statearr_23689_23752 = state_23629__$1;
(statearr_23689_23752[(2)] = null);

(statearr_23689_23752[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (14))){
var state_23629__$1 = state_23629;
var statearr_23690_23753 = state_23629__$1;
(statearr_23690_23753[(2)] = null);

(statearr_23690_23753[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (45))){
var inst_23619 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
var statearr_23691_23754 = state_23629__$1;
(statearr_23691_23754[(2)] = inst_23619);

(statearr_23691_23754[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (26))){
var inst_23563 = (state_23629[(27)]);
var inst_23615 = (state_23629[(2)]);
var inst_23616 = cljs.core.seq(inst_23563);
var state_23629__$1 = (function (){var statearr_23692 = state_23629;
(statearr_23692[(29)] = inst_23615);

return statearr_23692;
})();
if(inst_23616){
var statearr_23693_23755 = state_23629__$1;
(statearr_23693_23755[(1)] = (42));

} else {
var statearr_23694_23756 = state_23629__$1;
(statearr_23694_23756[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (16))){
var inst_23530 = (state_23629[(7)]);
var inst_23532 = cljs.core.chunked_seq_QMARK_(inst_23530);
var state_23629__$1 = state_23629;
if(inst_23532){
var statearr_23695_23757 = state_23629__$1;
(statearr_23695_23757[(1)] = (19));

} else {
var statearr_23696_23758 = state_23629__$1;
(statearr_23696_23758[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (38))){
var inst_23608 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
var statearr_23697_23759 = state_23629__$1;
(statearr_23697_23759[(2)] = inst_23608);

(statearr_23697_23759[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (30))){
var state_23629__$1 = state_23629;
var statearr_23698_23760 = state_23629__$1;
(statearr_23698_23760[(2)] = null);

(statearr_23698_23760[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (10))){
var inst_23511 = (state_23629[(13)]);
var inst_23509 = (state_23629[(14)]);
var inst_23519 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_23509,inst_23511);
var inst_23520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23519,(0),null);
var inst_23521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23519,(1),null);
var state_23629__$1 = (function (){var statearr_23699 = state_23629;
(statearr_23699[(24)] = inst_23520);

return statearr_23699;
})();
if(cljs.core.truth_(inst_23521)){
var statearr_23700_23761 = state_23629__$1;
(statearr_23700_23761[(1)] = (13));

} else {
var statearr_23701_23762 = state_23629__$1;
(statearr_23701_23762[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (18))){
var inst_23556 = (state_23629[(2)]);
var state_23629__$1 = state_23629;
var statearr_23702_23763 = state_23629__$1;
(statearr_23702_23763[(2)] = inst_23556);

(statearr_23702_23763[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (42))){
var state_23629__$1 = state_23629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23629__$1,(45),dchan);
} else {
if((state_val_23630 === (37))){
var inst_23598 = (state_23629[(22)]);
var inst_23499 = (state_23629[(9)]);
var inst_23589 = (state_23629[(23)]);
var inst_23598__$1 = cljs.core.first(inst_23589);
var inst_23599 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_23598__$1,inst_23499,done);
var state_23629__$1 = (function (){var statearr_23703 = state_23629;
(statearr_23703[(22)] = inst_23598__$1);

return statearr_23703;
})();
if(cljs.core.truth_(inst_23599)){
var statearr_23704_23764 = state_23629__$1;
(statearr_23704_23764[(1)] = (39));

} else {
var statearr_23705_23765 = state_23629__$1;
(statearr_23705_23765[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23630 === (8))){
var inst_23511 = (state_23629[(13)]);
var inst_23510 = (state_23629[(16)]);
var inst_23513 = (inst_23511 < inst_23510);
var inst_23514 = inst_23513;
var state_23629__$1 = state_23629;
if(cljs.core.truth_(inst_23514)){
var statearr_23706_23766 = state_23629__$1;
(statearr_23706_23766[(1)] = (10));

} else {
var statearr_23707_23767 = state_23629__$1;
(statearr_23707_23767[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__20866__auto__ = null;
var cljs$core$async$mult_$_state_machine__20866__auto____0 = (function (){
var statearr_23708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23708[(0)] = cljs$core$async$mult_$_state_machine__20866__auto__);

(statearr_23708[(1)] = (1));

return statearr_23708;
});
var cljs$core$async$mult_$_state_machine__20866__auto____1 = (function (state_23629){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23629);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23709){var ex__20869__auto__ = e23709;
var statearr_23710_23768 = state_23629;
(statearr_23710_23768[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23629[(4)]))){
var statearr_23711_23769 = state_23629;
(statearr_23711_23769[(1)] = cljs.core.first((state_23629[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23770 = state_23629;
state_23629 = G__23770;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20866__auto__ = function(state_23629){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20866__auto____1.call(this,state_23629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20866__auto____0;
cljs$core$async$mult_$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20866__auto____1;
return cljs$core$async$mult_$_state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23712 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23712[(6)] = c__20992__auto___23713);

return statearr_23712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__23772 = arguments.length;
switch (G__23772) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_23774 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_23774(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_23775 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_23775(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_23776 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_23776(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_23777 = (function (m,state_map){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4522__auto__.call(null,m,state_map));
} else {
var m__4519__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4519__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_23777(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_23778 = (function (m,mode){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4522__auto__.call(null,m,mode));
} else {
var m__4519__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4519__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_23778(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___23788 = arguments.length;
var i__4830__auto___23789 = (0);
while(true){
if((i__4830__auto___23789 < len__4829__auto___23788)){
args__4835__auto__.push((arguments[i__4830__auto___23789]));

var G__23790 = (i__4830__auto___23789 + (1));
i__4830__auto___23789 = G__23790;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((3) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4836__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__23783){
var map__23784 = p__23783;
var map__23784__$1 = cljs.core.__destructure_map(map__23784);
var opts = map__23784__$1;
var statearr_23785_23791 = state;
(statearr_23785_23791[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_23786_23792 = state;
(statearr_23786_23792[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_23787_23793 = state;
(statearr_23787_23793[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq23779){
var G__23780 = cljs.core.first(seq23779);
var seq23779__$1 = cljs.core.next(seq23779);
var G__23781 = cljs.core.first(seq23779__$1);
var seq23779__$2 = cljs.core.next(seq23779__$1);
var G__23782 = cljs.core.first(seq23779__$2);
var seq23779__$3 = cljs.core.next(seq23779__$2);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23780,G__23781,G__23782,seq23779__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23794 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23794 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta23795){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta23795 = meta23795;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23796,meta23795__$1){
var self__ = this;
var _23796__$1 = this;
return (new cljs.core.async.t_cljs$core$async23794(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta23795__$1));
}));

(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23796){
var self__ = this;
var _23796__$1 = this;
return self__.meta23795;
}));

(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23794.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23794.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta23795], null);
}));

(cljs.core.async.t_cljs$core$async23794.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23794.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23794");

(cljs.core.async.t_cljs$core$async23794.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23794");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23794.
 */
cljs.core.async.__GT_t_cljs$core$async23794 = (function cljs$core$async$mix_$___GT_t_cljs$core$async23794(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta23795){
return (new cljs.core.async.t_cljs$core$async23794(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta23795));
});

}

return (new cljs.core.async.t_cljs$core$async23794(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20992__auto___23909 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_23864){
var state_val_23865 = (state_23864[(1)]);
if((state_val_23865 === (7))){
var inst_23824 = (state_23864[(2)]);
var state_23864__$1 = state_23864;
if(cljs.core.truth_(inst_23824)){
var statearr_23866_23910 = state_23864__$1;
(statearr_23866_23910[(1)] = (8));

} else {
var statearr_23867_23911 = state_23864__$1;
(statearr_23867_23911[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (20))){
var inst_23817 = (state_23864[(7)]);
var state_23864__$1 = state_23864;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23864__$1,(23),out,inst_23817);
} else {
if((state_val_23865 === (1))){
var inst_23800 = calc_state();
var inst_23801 = cljs.core.__destructure_map(inst_23800);
var inst_23802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23801,cljs.core.cst$kw$solos);
var inst_23803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23801,cljs.core.cst$kw$mutes);
var inst_23804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23801,cljs.core.cst$kw$reads);
var inst_23805 = inst_23800;
var state_23864__$1 = (function (){var statearr_23868 = state_23864;
(statearr_23868[(8)] = inst_23802);

(statearr_23868[(9)] = inst_23805);

(statearr_23868[(10)] = inst_23803);

(statearr_23868[(11)] = inst_23804);

return statearr_23868;
})();
var statearr_23869_23912 = state_23864__$1;
(statearr_23869_23912[(2)] = null);

(statearr_23869_23912[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (24))){
var inst_23808 = (state_23864[(12)]);
var inst_23805 = inst_23808;
var state_23864__$1 = (function (){var statearr_23870 = state_23864;
(statearr_23870[(9)] = inst_23805);

return statearr_23870;
})();
var statearr_23871_23913 = state_23864__$1;
(statearr_23871_23913[(2)] = null);

(statearr_23871_23913[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (4))){
var inst_23819 = (state_23864[(13)]);
var inst_23817 = (state_23864[(7)]);
var inst_23816 = (state_23864[(2)]);
var inst_23817__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23816,(0),null);
var inst_23818 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23816,(1),null);
var inst_23819__$1 = (inst_23817__$1 == null);
var state_23864__$1 = (function (){var statearr_23872 = state_23864;
(statearr_23872[(13)] = inst_23819__$1);

(statearr_23872[(14)] = inst_23818);

(statearr_23872[(7)] = inst_23817__$1);

return statearr_23872;
})();
if(cljs.core.truth_(inst_23819__$1)){
var statearr_23873_23914 = state_23864__$1;
(statearr_23873_23914[(1)] = (5));

} else {
var statearr_23874_23915 = state_23864__$1;
(statearr_23874_23915[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (15))){
var inst_23838 = (state_23864[(15)]);
var inst_23809 = (state_23864[(16)]);
var inst_23838__$1 = cljs.core.empty_QMARK_(inst_23809);
var state_23864__$1 = (function (){var statearr_23875 = state_23864;
(statearr_23875[(15)] = inst_23838__$1);

return statearr_23875;
})();
if(inst_23838__$1){
var statearr_23876_23916 = state_23864__$1;
(statearr_23876_23916[(1)] = (17));

} else {
var statearr_23877_23917 = state_23864__$1;
(statearr_23877_23917[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (21))){
var inst_23808 = (state_23864[(12)]);
var inst_23805 = inst_23808;
var state_23864__$1 = (function (){var statearr_23878 = state_23864;
(statearr_23878[(9)] = inst_23805);

return statearr_23878;
})();
var statearr_23879_23918 = state_23864__$1;
(statearr_23879_23918[(2)] = null);

(statearr_23879_23918[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (13))){
var inst_23831 = (state_23864[(2)]);
var inst_23832 = calc_state();
var inst_23805 = inst_23832;
var state_23864__$1 = (function (){var statearr_23880 = state_23864;
(statearr_23880[(9)] = inst_23805);

(statearr_23880[(17)] = inst_23831);

return statearr_23880;
})();
var statearr_23881_23919 = state_23864__$1;
(statearr_23881_23919[(2)] = null);

(statearr_23881_23919[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (22))){
var inst_23858 = (state_23864[(2)]);
var state_23864__$1 = state_23864;
var statearr_23882_23920 = state_23864__$1;
(statearr_23882_23920[(2)] = inst_23858);

(statearr_23882_23920[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (6))){
var inst_23818 = (state_23864[(14)]);
var inst_23822 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_23818,change);
var state_23864__$1 = state_23864;
var statearr_23883_23921 = state_23864__$1;
(statearr_23883_23921[(2)] = inst_23822);

(statearr_23883_23921[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (25))){
var state_23864__$1 = state_23864;
var statearr_23884_23922 = state_23864__$1;
(statearr_23884_23922[(2)] = null);

(statearr_23884_23922[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (17))){
var inst_23810 = (state_23864[(18)]);
var inst_23818 = (state_23864[(14)]);
var inst_23840 = (inst_23810.cljs$core$IFn$_invoke$arity$1 ? inst_23810.cljs$core$IFn$_invoke$arity$1(inst_23818) : inst_23810.call(null,inst_23818));
var inst_23841 = cljs.core.not(inst_23840);
var state_23864__$1 = state_23864;
var statearr_23885_23923 = state_23864__$1;
(statearr_23885_23923[(2)] = inst_23841);

(statearr_23885_23923[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (3))){
var inst_23862 = (state_23864[(2)]);
var state_23864__$1 = state_23864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23864__$1,inst_23862);
} else {
if((state_val_23865 === (12))){
var state_23864__$1 = state_23864;
var statearr_23886_23924 = state_23864__$1;
(statearr_23886_23924[(2)] = null);

(statearr_23886_23924[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (2))){
var inst_23808 = (state_23864[(12)]);
var inst_23805 = (state_23864[(9)]);
var inst_23808__$1 = cljs.core.__destructure_map(inst_23805);
var inst_23809 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23808__$1,cljs.core.cst$kw$solos);
var inst_23810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23808__$1,cljs.core.cst$kw$mutes);
var inst_23811 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23808__$1,cljs.core.cst$kw$reads);
var state_23864__$1 = (function (){var statearr_23887 = state_23864;
(statearr_23887[(12)] = inst_23808__$1);

(statearr_23887[(18)] = inst_23810);

(statearr_23887[(16)] = inst_23809);

return statearr_23887;
})();
return cljs.core.async.ioc_alts_BANG_(state_23864__$1,(4),inst_23811);
} else {
if((state_val_23865 === (23))){
var inst_23849 = (state_23864[(2)]);
var state_23864__$1 = state_23864;
if(cljs.core.truth_(inst_23849)){
var statearr_23888_23925 = state_23864__$1;
(statearr_23888_23925[(1)] = (24));

} else {
var statearr_23889_23926 = state_23864__$1;
(statearr_23889_23926[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (19))){
var inst_23844 = (state_23864[(2)]);
var state_23864__$1 = state_23864;
var statearr_23890_23927 = state_23864__$1;
(statearr_23890_23927[(2)] = inst_23844);

(statearr_23890_23927[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (11))){
var inst_23818 = (state_23864[(14)]);
var inst_23828 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_23818);
var state_23864__$1 = state_23864;
var statearr_23891_23928 = state_23864__$1;
(statearr_23891_23928[(2)] = inst_23828);

(statearr_23891_23928[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (9))){
var inst_23818 = (state_23864[(14)]);
var inst_23809 = (state_23864[(16)]);
var inst_23835 = (state_23864[(19)]);
var inst_23835__$1 = (inst_23809.cljs$core$IFn$_invoke$arity$1 ? inst_23809.cljs$core$IFn$_invoke$arity$1(inst_23818) : inst_23809.call(null,inst_23818));
var state_23864__$1 = (function (){var statearr_23892 = state_23864;
(statearr_23892[(19)] = inst_23835__$1);

return statearr_23892;
})();
if(cljs.core.truth_(inst_23835__$1)){
var statearr_23893_23929 = state_23864__$1;
(statearr_23893_23929[(1)] = (14));

} else {
var statearr_23894_23930 = state_23864__$1;
(statearr_23894_23930[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (5))){
var inst_23819 = (state_23864[(13)]);
var state_23864__$1 = state_23864;
var statearr_23895_23931 = state_23864__$1;
(statearr_23895_23931[(2)] = inst_23819);

(statearr_23895_23931[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (14))){
var inst_23835 = (state_23864[(19)]);
var state_23864__$1 = state_23864;
var statearr_23896_23932 = state_23864__$1;
(statearr_23896_23932[(2)] = inst_23835);

(statearr_23896_23932[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (26))){
var inst_23854 = (state_23864[(2)]);
var state_23864__$1 = state_23864;
var statearr_23897_23933 = state_23864__$1;
(statearr_23897_23933[(2)] = inst_23854);

(statearr_23897_23933[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (16))){
var inst_23846 = (state_23864[(2)]);
var state_23864__$1 = state_23864;
if(cljs.core.truth_(inst_23846)){
var statearr_23898_23934 = state_23864__$1;
(statearr_23898_23934[(1)] = (20));

} else {
var statearr_23899_23935 = state_23864__$1;
(statearr_23899_23935[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (10))){
var inst_23860 = (state_23864[(2)]);
var state_23864__$1 = state_23864;
var statearr_23900_23936 = state_23864__$1;
(statearr_23900_23936[(2)] = inst_23860);

(statearr_23900_23936[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (18))){
var inst_23838 = (state_23864[(15)]);
var state_23864__$1 = state_23864;
var statearr_23901_23937 = state_23864__$1;
(statearr_23901_23937[(2)] = inst_23838);

(statearr_23901_23937[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23865 === (8))){
var inst_23817 = (state_23864[(7)]);
var inst_23826 = (inst_23817 == null);
var state_23864__$1 = state_23864;
if(cljs.core.truth_(inst_23826)){
var statearr_23902_23938 = state_23864__$1;
(statearr_23902_23938[(1)] = (11));

} else {
var statearr_23903_23939 = state_23864__$1;
(statearr_23903_23939[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__20866__auto__ = null;
var cljs$core$async$mix_$_state_machine__20866__auto____0 = (function (){
var statearr_23904 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23904[(0)] = cljs$core$async$mix_$_state_machine__20866__auto__);

(statearr_23904[(1)] = (1));

return statearr_23904;
});
var cljs$core$async$mix_$_state_machine__20866__auto____1 = (function (state_23864){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_23864);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e23905){var ex__20869__auto__ = e23905;
var statearr_23906_23940 = state_23864;
(statearr_23906_23940[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_23864[(4)]))){
var statearr_23907_23941 = state_23864;
(statearr_23907_23941[(1)] = cljs.core.first((state_23864[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__23942 = state_23864;
state_23864 = G__23942;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20866__auto__ = function(state_23864){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20866__auto____1.call(this,state_23864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20866__auto____0;
cljs$core$async$mix_$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20866__auto____1;
return cljs$core$async$mix_$_state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_23908 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_23908[(6)] = c__20992__auto___23909);

return statearr_23908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_23945 = (function (p,v,ch,close_QMARK_){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4522__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4519__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_23945(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_23946 = (function (p,v,ch){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4522__auto__.call(null,p,v,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4519__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_23946(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_23947 = (function() {
var G__23948 = null;
var G__23948__1 = (function (p){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4522__auto__.call(null,p));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4519__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__23948__2 = (function (p,v){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4522__auto__.call(null,p,v));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4519__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__23948 = function(p,v){
switch(arguments.length){
case 1:
return G__23948__1.call(this,p);
case 2:
return G__23948__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23948.cljs$core$IFn$_invoke$arity$1 = G__23948__1;
G__23948.cljs$core$IFn$_invoke$arity$2 = G__23948__2;
return G__23948;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__23944 = arguments.length;
switch (G__23944) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_23947.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_23947.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__23952 = arguments.length;
switch (G__23952) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__23950_SHARP_){
if(cljs.core.truth_((p1__23950_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23950_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__23950_SHARP_.call(null,topic)))){
return p1__23950_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__23950_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23953 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23953 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta23954){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta23954 = meta23954;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23953.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23955,meta23954__$1){
var self__ = this;
var _23955__$1 = this;
return (new cljs.core.async.t_cljs$core$async23953(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta23954__$1));
}));

(cljs.core.async.t_cljs$core$async23953.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23955){
var self__ = this;
var _23955__$1 = this;
return self__.meta23954;
}));

(cljs.core.async.t_cljs$core$async23953.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23953.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async23953.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23953.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async23953.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async23953.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async23953.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async23953.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta23954], null);
}));

(cljs.core.async.t_cljs$core$async23953.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23953.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23953");

(cljs.core.async.t_cljs$core$async23953.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23953");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23953.
 */
cljs.core.async.__GT_t_cljs$core$async23953 = (function cljs$core$async$__GT_t_cljs$core$async23953(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23954){
return (new cljs.core.async.t_cljs$core$async23953(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23954));
});

}

return (new cljs.core.async.t_cljs$core$async23953(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20992__auto___24074 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_24027){
var state_val_24028 = (state_24027[(1)]);
if((state_val_24028 === (7))){
var inst_24023 = (state_24027[(2)]);
var state_24027__$1 = state_24027;
var statearr_24029_24075 = state_24027__$1;
(statearr_24029_24075[(2)] = inst_24023);

(statearr_24029_24075[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (20))){
var state_24027__$1 = state_24027;
var statearr_24030_24076 = state_24027__$1;
(statearr_24030_24076[(2)] = null);

(statearr_24030_24076[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (1))){
var state_24027__$1 = state_24027;
var statearr_24031_24077 = state_24027__$1;
(statearr_24031_24077[(2)] = null);

(statearr_24031_24077[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (24))){
var inst_24006 = (state_24027[(7)]);
var inst_24015 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_24006);
var state_24027__$1 = state_24027;
var statearr_24032_24078 = state_24027__$1;
(statearr_24032_24078[(2)] = inst_24015);

(statearr_24032_24078[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (4))){
var inst_23958 = (state_24027[(8)]);
var inst_23958__$1 = (state_24027[(2)]);
var inst_23959 = (inst_23958__$1 == null);
var state_24027__$1 = (function (){var statearr_24033 = state_24027;
(statearr_24033[(8)] = inst_23958__$1);

return statearr_24033;
})();
if(cljs.core.truth_(inst_23959)){
var statearr_24034_24079 = state_24027__$1;
(statearr_24034_24079[(1)] = (5));

} else {
var statearr_24035_24080 = state_24027__$1;
(statearr_24035_24080[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (15))){
var inst_24000 = (state_24027[(2)]);
var state_24027__$1 = state_24027;
var statearr_24036_24081 = state_24027__$1;
(statearr_24036_24081[(2)] = inst_24000);

(statearr_24036_24081[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (21))){
var inst_24020 = (state_24027[(2)]);
var state_24027__$1 = (function (){var statearr_24037 = state_24027;
(statearr_24037[(9)] = inst_24020);

return statearr_24037;
})();
var statearr_24038_24082 = state_24027__$1;
(statearr_24038_24082[(2)] = null);

(statearr_24038_24082[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (13))){
var inst_23982 = (state_24027[(10)]);
var inst_23984 = cljs.core.chunked_seq_QMARK_(inst_23982);
var state_24027__$1 = state_24027;
if(inst_23984){
var statearr_24039_24083 = state_24027__$1;
(statearr_24039_24083[(1)] = (16));

} else {
var statearr_24040_24084 = state_24027__$1;
(statearr_24040_24084[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (22))){
var inst_24012 = (state_24027[(2)]);
var state_24027__$1 = state_24027;
if(cljs.core.truth_(inst_24012)){
var statearr_24041_24085 = state_24027__$1;
(statearr_24041_24085[(1)] = (23));

} else {
var statearr_24042_24086 = state_24027__$1;
(statearr_24042_24086[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (6))){
var inst_24008 = (state_24027[(11)]);
var inst_23958 = (state_24027[(8)]);
var inst_24006 = (state_24027[(7)]);
var inst_24006__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_23958) : topic_fn.call(null,inst_23958));
var inst_24007 = cljs.core.deref(mults);
var inst_24008__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24007,inst_24006__$1);
var state_24027__$1 = (function (){var statearr_24043 = state_24027;
(statearr_24043[(11)] = inst_24008__$1);

(statearr_24043[(7)] = inst_24006__$1);

return statearr_24043;
})();
if(cljs.core.truth_(inst_24008__$1)){
var statearr_24044_24087 = state_24027__$1;
(statearr_24044_24087[(1)] = (19));

} else {
var statearr_24045_24088 = state_24027__$1;
(statearr_24045_24088[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (25))){
var inst_24017 = (state_24027[(2)]);
var state_24027__$1 = state_24027;
var statearr_24046_24089 = state_24027__$1;
(statearr_24046_24089[(2)] = inst_24017);

(statearr_24046_24089[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (17))){
var inst_23982 = (state_24027[(10)]);
var inst_23991 = cljs.core.first(inst_23982);
var inst_23992 = cljs.core.async.muxch_STAR_(inst_23991);
var inst_23993 = cljs.core.async.close_BANG_(inst_23992);
var inst_23994 = cljs.core.next(inst_23982);
var inst_23968 = inst_23994;
var inst_23969 = null;
var inst_23970 = (0);
var inst_23971 = (0);
var state_24027__$1 = (function (){var statearr_24047 = state_24027;
(statearr_24047[(12)] = inst_23970);

(statearr_24047[(13)] = inst_23969);

(statearr_24047[(14)] = inst_23993);

(statearr_24047[(15)] = inst_23971);

(statearr_24047[(16)] = inst_23968);

return statearr_24047;
})();
var statearr_24048_24090 = state_24027__$1;
(statearr_24048_24090[(2)] = null);

(statearr_24048_24090[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (3))){
var inst_24025 = (state_24027[(2)]);
var state_24027__$1 = state_24027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24027__$1,inst_24025);
} else {
if((state_val_24028 === (12))){
var inst_24002 = (state_24027[(2)]);
var state_24027__$1 = state_24027;
var statearr_24049_24091 = state_24027__$1;
(statearr_24049_24091[(2)] = inst_24002);

(statearr_24049_24091[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (2))){
var state_24027__$1 = state_24027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24027__$1,(4),ch);
} else {
if((state_val_24028 === (23))){
var state_24027__$1 = state_24027;
var statearr_24050_24092 = state_24027__$1;
(statearr_24050_24092[(2)] = null);

(statearr_24050_24092[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (19))){
var inst_24008 = (state_24027[(11)]);
var inst_23958 = (state_24027[(8)]);
var inst_24010 = cljs.core.async.muxch_STAR_(inst_24008);
var state_24027__$1 = state_24027;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24027__$1,(22),inst_24010,inst_23958);
} else {
if((state_val_24028 === (11))){
var inst_23982 = (state_24027[(10)]);
var inst_23968 = (state_24027[(16)]);
var inst_23982__$1 = cljs.core.seq(inst_23968);
var state_24027__$1 = (function (){var statearr_24051 = state_24027;
(statearr_24051[(10)] = inst_23982__$1);

return statearr_24051;
})();
if(inst_23982__$1){
var statearr_24052_24093 = state_24027__$1;
(statearr_24052_24093[(1)] = (13));

} else {
var statearr_24053_24094 = state_24027__$1;
(statearr_24053_24094[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (9))){
var inst_24004 = (state_24027[(2)]);
var state_24027__$1 = state_24027;
var statearr_24054_24095 = state_24027__$1;
(statearr_24054_24095[(2)] = inst_24004);

(statearr_24054_24095[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (5))){
var inst_23965 = cljs.core.deref(mults);
var inst_23966 = cljs.core.vals(inst_23965);
var inst_23967 = cljs.core.seq(inst_23966);
var inst_23968 = inst_23967;
var inst_23969 = null;
var inst_23970 = (0);
var inst_23971 = (0);
var state_24027__$1 = (function (){var statearr_24055 = state_24027;
(statearr_24055[(12)] = inst_23970);

(statearr_24055[(13)] = inst_23969);

(statearr_24055[(15)] = inst_23971);

(statearr_24055[(16)] = inst_23968);

return statearr_24055;
})();
var statearr_24056_24096 = state_24027__$1;
(statearr_24056_24096[(2)] = null);

(statearr_24056_24096[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (14))){
var state_24027__$1 = state_24027;
var statearr_24060_24097 = state_24027__$1;
(statearr_24060_24097[(2)] = null);

(statearr_24060_24097[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (16))){
var inst_23982 = (state_24027[(10)]);
var inst_23986 = cljs.core.chunk_first(inst_23982);
var inst_23987 = cljs.core.chunk_rest(inst_23982);
var inst_23988 = cljs.core.count(inst_23986);
var inst_23968 = inst_23987;
var inst_23969 = inst_23986;
var inst_23970 = inst_23988;
var inst_23971 = (0);
var state_24027__$1 = (function (){var statearr_24061 = state_24027;
(statearr_24061[(12)] = inst_23970);

(statearr_24061[(13)] = inst_23969);

(statearr_24061[(15)] = inst_23971);

(statearr_24061[(16)] = inst_23968);

return statearr_24061;
})();
var statearr_24062_24098 = state_24027__$1;
(statearr_24062_24098[(2)] = null);

(statearr_24062_24098[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (10))){
var inst_23970 = (state_24027[(12)]);
var inst_23969 = (state_24027[(13)]);
var inst_23971 = (state_24027[(15)]);
var inst_23968 = (state_24027[(16)]);
var inst_23976 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_23969,inst_23971);
var inst_23977 = cljs.core.async.muxch_STAR_(inst_23976);
var inst_23978 = cljs.core.async.close_BANG_(inst_23977);
var inst_23979 = (inst_23971 + (1));
var tmp24057 = inst_23970;
var tmp24058 = inst_23969;
var tmp24059 = inst_23968;
var inst_23968__$1 = tmp24059;
var inst_23969__$1 = tmp24058;
var inst_23970__$1 = tmp24057;
var inst_23971__$1 = inst_23979;
var state_24027__$1 = (function (){var statearr_24063 = state_24027;
(statearr_24063[(12)] = inst_23970__$1);

(statearr_24063[(13)] = inst_23969__$1);

(statearr_24063[(17)] = inst_23978);

(statearr_24063[(15)] = inst_23971__$1);

(statearr_24063[(16)] = inst_23968__$1);

return statearr_24063;
})();
var statearr_24064_24099 = state_24027__$1;
(statearr_24064_24099[(2)] = null);

(statearr_24064_24099[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (18))){
var inst_23997 = (state_24027[(2)]);
var state_24027__$1 = state_24027;
var statearr_24065_24100 = state_24027__$1;
(statearr_24065_24100[(2)] = inst_23997);

(statearr_24065_24100[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24028 === (8))){
var inst_23970 = (state_24027[(12)]);
var inst_23971 = (state_24027[(15)]);
var inst_23973 = (inst_23971 < inst_23970);
var inst_23974 = inst_23973;
var state_24027__$1 = state_24027;
if(cljs.core.truth_(inst_23974)){
var statearr_24066_24101 = state_24027__$1;
(statearr_24066_24101[(1)] = (10));

} else {
var statearr_24067_24102 = state_24027__$1;
(statearr_24067_24102[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_24068 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24068[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_24068[(1)] = (1));

return statearr_24068;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_24027){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_24027);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e24069){var ex__20869__auto__ = e24069;
var statearr_24070_24103 = state_24027;
(statearr_24070_24103[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_24027[(4)]))){
var statearr_24071_24104 = state_24027;
(statearr_24071_24104[(1)] = cljs.core.first((state_24027[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__24105 = state_24027;
state_24027 = G__24105;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_24027){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_24027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_24072 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_24072[(6)] = c__20992__auto___24074);

return statearr_24072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__24107 = arguments.length;
switch (G__24107) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__24110 = arguments.length;
switch (G__24110) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__24113 = arguments.length;
switch (G__24113) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__20992__auto___24191 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_24156){
var state_val_24157 = (state_24156[(1)]);
if((state_val_24157 === (7))){
var state_24156__$1 = state_24156;
var statearr_24158_24192 = state_24156__$1;
(statearr_24158_24192[(2)] = null);

(statearr_24158_24192[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (1))){
var state_24156__$1 = state_24156;
var statearr_24159_24193 = state_24156__$1;
(statearr_24159_24193[(2)] = null);

(statearr_24159_24193[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (4))){
var inst_24117 = (state_24156[(7)]);
var inst_24116 = (state_24156[(8)]);
var inst_24119 = (inst_24117 < inst_24116);
var state_24156__$1 = state_24156;
if(cljs.core.truth_(inst_24119)){
var statearr_24160_24194 = state_24156__$1;
(statearr_24160_24194[(1)] = (6));

} else {
var statearr_24161_24195 = state_24156__$1;
(statearr_24161_24195[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (15))){
var inst_24142 = (state_24156[(9)]);
var inst_24147 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_24142);
var state_24156__$1 = state_24156;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24156__$1,(17),out,inst_24147);
} else {
if((state_val_24157 === (13))){
var inst_24142 = (state_24156[(9)]);
var inst_24142__$1 = (state_24156[(2)]);
var inst_24143 = cljs.core.some(cljs.core.nil_QMARK_,inst_24142__$1);
var state_24156__$1 = (function (){var statearr_24162 = state_24156;
(statearr_24162[(9)] = inst_24142__$1);

return statearr_24162;
})();
if(cljs.core.truth_(inst_24143)){
var statearr_24163_24196 = state_24156__$1;
(statearr_24163_24196[(1)] = (14));

} else {
var statearr_24164_24197 = state_24156__$1;
(statearr_24164_24197[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (6))){
var state_24156__$1 = state_24156;
var statearr_24165_24198 = state_24156__$1;
(statearr_24165_24198[(2)] = null);

(statearr_24165_24198[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (17))){
var inst_24149 = (state_24156[(2)]);
var state_24156__$1 = (function (){var statearr_24167 = state_24156;
(statearr_24167[(10)] = inst_24149);

return statearr_24167;
})();
var statearr_24168_24199 = state_24156__$1;
(statearr_24168_24199[(2)] = null);

(statearr_24168_24199[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (3))){
var inst_24154 = (state_24156[(2)]);
var state_24156__$1 = state_24156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24156__$1,inst_24154);
} else {
if((state_val_24157 === (12))){
var _ = (function (){var statearr_24169 = state_24156;
(statearr_24169[(4)] = cljs.core.rest((state_24156[(4)])));

return statearr_24169;
})();
var state_24156__$1 = state_24156;
var ex24166 = (state_24156__$1[(2)]);
var statearr_24170_24200 = state_24156__$1;
(statearr_24170_24200[(5)] = ex24166);


if((ex24166 instanceof Object)){
var statearr_24171_24201 = state_24156__$1;
(statearr_24171_24201[(1)] = (11));

(statearr_24171_24201[(5)] = null);

} else {
throw ex24166;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (2))){
var inst_24115 = cljs.core.reset_BANG_(dctr,cnt);
var inst_24116 = cnt;
var inst_24117 = (0);
var state_24156__$1 = (function (){var statearr_24172 = state_24156;
(statearr_24172[(7)] = inst_24117);

(statearr_24172[(11)] = inst_24115);

(statearr_24172[(8)] = inst_24116);

return statearr_24172;
})();
var statearr_24173_24202 = state_24156__$1;
(statearr_24173_24202[(2)] = null);

(statearr_24173_24202[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (11))){
var inst_24121 = (state_24156[(2)]);
var inst_24122 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_24156__$1 = (function (){var statearr_24174 = state_24156;
(statearr_24174[(12)] = inst_24121);

return statearr_24174;
})();
var statearr_24175_24203 = state_24156__$1;
(statearr_24175_24203[(2)] = inst_24122);

(statearr_24175_24203[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (9))){
var inst_24117 = (state_24156[(7)]);
var _ = (function (){var statearr_24176 = state_24156;
(statearr_24176[(4)] = cljs.core.cons((12),(state_24156[(4)])));

return statearr_24176;
})();
var inst_24128 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_24117) : chs__$1.call(null,inst_24117));
var inst_24129 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_24117) : done.call(null,inst_24117));
var inst_24130 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24128,inst_24129);
var ___$1 = (function (){var statearr_24177 = state_24156;
(statearr_24177[(4)] = cljs.core.rest((state_24156[(4)])));

return statearr_24177;
})();
var state_24156__$1 = state_24156;
var statearr_24178_24204 = state_24156__$1;
(statearr_24178_24204[(2)] = inst_24130);

(statearr_24178_24204[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (5))){
var inst_24140 = (state_24156[(2)]);
var state_24156__$1 = (function (){var statearr_24179 = state_24156;
(statearr_24179[(13)] = inst_24140);

return statearr_24179;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24156__$1,(13),dchan);
} else {
if((state_val_24157 === (14))){
var inst_24145 = cljs.core.async.close_BANG_(out);
var state_24156__$1 = state_24156;
var statearr_24180_24205 = state_24156__$1;
(statearr_24180_24205[(2)] = inst_24145);

(statearr_24180_24205[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (16))){
var inst_24152 = (state_24156[(2)]);
var state_24156__$1 = state_24156;
var statearr_24181_24206 = state_24156__$1;
(statearr_24181_24206[(2)] = inst_24152);

(statearr_24181_24206[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (10))){
var inst_24117 = (state_24156[(7)]);
var inst_24133 = (state_24156[(2)]);
var inst_24134 = (inst_24117 + (1));
var inst_24117__$1 = inst_24134;
var state_24156__$1 = (function (){var statearr_24182 = state_24156;
(statearr_24182[(14)] = inst_24133);

(statearr_24182[(7)] = inst_24117__$1);

return statearr_24182;
})();
var statearr_24183_24207 = state_24156__$1;
(statearr_24183_24207[(2)] = null);

(statearr_24183_24207[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24157 === (8))){
var inst_24138 = (state_24156[(2)]);
var state_24156__$1 = state_24156;
var statearr_24184_24208 = state_24156__$1;
(statearr_24184_24208[(2)] = inst_24138);

(statearr_24184_24208[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_24185 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24185[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_24185[(1)] = (1));

return statearr_24185;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_24156){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_24156);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e24186){var ex__20869__auto__ = e24186;
var statearr_24187_24209 = state_24156;
(statearr_24187_24209[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_24156[(4)]))){
var statearr_24188_24210 = state_24156;
(statearr_24188_24210[(1)] = cljs.core.first((state_24156[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__24211 = state_24156;
state_24156 = G__24211;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_24156){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_24156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_24189 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_24189[(6)] = c__20992__auto___24191);

return statearr_24189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__24214 = arguments.length;
switch (G__24214) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20992__auto___24269 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_24246){
var state_val_24247 = (state_24246[(1)]);
if((state_val_24247 === (7))){
var inst_24226 = (state_24246[(7)]);
var inst_24225 = (state_24246[(8)]);
var inst_24225__$1 = (state_24246[(2)]);
var inst_24226__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24225__$1,(0),null);
var inst_24227 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24225__$1,(1),null);
var inst_24228 = (inst_24226__$1 == null);
var state_24246__$1 = (function (){var statearr_24248 = state_24246;
(statearr_24248[(7)] = inst_24226__$1);

(statearr_24248[(9)] = inst_24227);

(statearr_24248[(8)] = inst_24225__$1);

return statearr_24248;
})();
if(cljs.core.truth_(inst_24228)){
var statearr_24249_24270 = state_24246__$1;
(statearr_24249_24270[(1)] = (8));

} else {
var statearr_24250_24271 = state_24246__$1;
(statearr_24250_24271[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24247 === (1))){
var inst_24215 = cljs.core.vec(chs);
var inst_24216 = inst_24215;
var state_24246__$1 = (function (){var statearr_24251 = state_24246;
(statearr_24251[(10)] = inst_24216);

return statearr_24251;
})();
var statearr_24252_24272 = state_24246__$1;
(statearr_24252_24272[(2)] = null);

(statearr_24252_24272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24247 === (4))){
var inst_24216 = (state_24246[(10)]);
var state_24246__$1 = state_24246;
return cljs.core.async.ioc_alts_BANG_(state_24246__$1,(7),inst_24216);
} else {
if((state_val_24247 === (6))){
var inst_24242 = (state_24246[(2)]);
var state_24246__$1 = state_24246;
var statearr_24253_24273 = state_24246__$1;
(statearr_24253_24273[(2)] = inst_24242);

(statearr_24253_24273[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24247 === (3))){
var inst_24244 = (state_24246[(2)]);
var state_24246__$1 = state_24246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24246__$1,inst_24244);
} else {
if((state_val_24247 === (2))){
var inst_24216 = (state_24246[(10)]);
var inst_24218 = cljs.core.count(inst_24216);
var inst_24219 = (inst_24218 > (0));
var state_24246__$1 = state_24246;
if(cljs.core.truth_(inst_24219)){
var statearr_24255_24274 = state_24246__$1;
(statearr_24255_24274[(1)] = (4));

} else {
var statearr_24256_24275 = state_24246__$1;
(statearr_24256_24275[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24247 === (11))){
var inst_24216 = (state_24246[(10)]);
var inst_24235 = (state_24246[(2)]);
var tmp24254 = inst_24216;
var inst_24216__$1 = tmp24254;
var state_24246__$1 = (function (){var statearr_24257 = state_24246;
(statearr_24257[(10)] = inst_24216__$1);

(statearr_24257[(11)] = inst_24235);

return statearr_24257;
})();
var statearr_24258_24276 = state_24246__$1;
(statearr_24258_24276[(2)] = null);

(statearr_24258_24276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24247 === (9))){
var inst_24226 = (state_24246[(7)]);
var state_24246__$1 = state_24246;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24246__$1,(11),out,inst_24226);
} else {
if((state_val_24247 === (5))){
var inst_24240 = cljs.core.async.close_BANG_(out);
var state_24246__$1 = state_24246;
var statearr_24259_24277 = state_24246__$1;
(statearr_24259_24277[(2)] = inst_24240);

(statearr_24259_24277[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24247 === (10))){
var inst_24238 = (state_24246[(2)]);
var state_24246__$1 = state_24246;
var statearr_24260_24278 = state_24246__$1;
(statearr_24260_24278[(2)] = inst_24238);

(statearr_24260_24278[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24247 === (8))){
var inst_24226 = (state_24246[(7)]);
var inst_24216 = (state_24246[(10)]);
var inst_24227 = (state_24246[(9)]);
var inst_24225 = (state_24246[(8)]);
var inst_24230 = (function (){var cs = inst_24216;
var vec__24221 = inst_24225;
var v = inst_24226;
var c = inst_24227;
return (function (p1__24212_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__24212_SHARP_);
});
})();
var inst_24231 = cljs.core.filterv(inst_24230,inst_24216);
var inst_24216__$1 = inst_24231;
var state_24246__$1 = (function (){var statearr_24261 = state_24246;
(statearr_24261[(10)] = inst_24216__$1);

return statearr_24261;
})();
var statearr_24262_24279 = state_24246__$1;
(statearr_24262_24279[(2)] = null);

(statearr_24262_24279[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_24263 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24263[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_24263[(1)] = (1));

return statearr_24263;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_24246){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_24246);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e24264){var ex__20869__auto__ = e24264;
var statearr_24265_24280 = state_24246;
(statearr_24265_24280[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_24246[(4)]))){
var statearr_24266_24281 = state_24246;
(statearr_24266_24281[(1)] = cljs.core.first((state_24246[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__24282 = state_24246;
state_24246 = G__24282;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_24246){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_24246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_24267 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_24267[(6)] = c__20992__auto___24269);

return statearr_24267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__24284 = arguments.length;
switch (G__24284) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20992__auto___24330 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_24308){
var state_val_24309 = (state_24308[(1)]);
if((state_val_24309 === (7))){
var inst_24290 = (state_24308[(7)]);
var inst_24290__$1 = (state_24308[(2)]);
var inst_24291 = (inst_24290__$1 == null);
var inst_24292 = cljs.core.not(inst_24291);
var state_24308__$1 = (function (){var statearr_24310 = state_24308;
(statearr_24310[(7)] = inst_24290__$1);

return statearr_24310;
})();
if(inst_24292){
var statearr_24311_24331 = state_24308__$1;
(statearr_24311_24331[(1)] = (8));

} else {
var statearr_24312_24332 = state_24308__$1;
(statearr_24312_24332[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24309 === (1))){
var inst_24285 = (0);
var state_24308__$1 = (function (){var statearr_24313 = state_24308;
(statearr_24313[(8)] = inst_24285);

return statearr_24313;
})();
var statearr_24314_24333 = state_24308__$1;
(statearr_24314_24333[(2)] = null);

(statearr_24314_24333[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24309 === (4))){
var state_24308__$1 = state_24308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24308__$1,(7),ch);
} else {
if((state_val_24309 === (6))){
var inst_24303 = (state_24308[(2)]);
var state_24308__$1 = state_24308;
var statearr_24315_24334 = state_24308__$1;
(statearr_24315_24334[(2)] = inst_24303);

(statearr_24315_24334[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24309 === (3))){
var inst_24305 = (state_24308[(2)]);
var inst_24306 = cljs.core.async.close_BANG_(out);
var state_24308__$1 = (function (){var statearr_24316 = state_24308;
(statearr_24316[(9)] = inst_24305);

return statearr_24316;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24308__$1,inst_24306);
} else {
if((state_val_24309 === (2))){
var inst_24285 = (state_24308[(8)]);
var inst_24287 = (inst_24285 < n);
var state_24308__$1 = state_24308;
if(cljs.core.truth_(inst_24287)){
var statearr_24317_24335 = state_24308__$1;
(statearr_24317_24335[(1)] = (4));

} else {
var statearr_24318_24336 = state_24308__$1;
(statearr_24318_24336[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24309 === (11))){
var inst_24285 = (state_24308[(8)]);
var inst_24295 = (state_24308[(2)]);
var inst_24296 = (inst_24285 + (1));
var inst_24285__$1 = inst_24296;
var state_24308__$1 = (function (){var statearr_24319 = state_24308;
(statearr_24319[(8)] = inst_24285__$1);

(statearr_24319[(10)] = inst_24295);

return statearr_24319;
})();
var statearr_24320_24337 = state_24308__$1;
(statearr_24320_24337[(2)] = null);

(statearr_24320_24337[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24309 === (9))){
var state_24308__$1 = state_24308;
var statearr_24321_24338 = state_24308__$1;
(statearr_24321_24338[(2)] = null);

(statearr_24321_24338[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24309 === (5))){
var state_24308__$1 = state_24308;
var statearr_24322_24339 = state_24308__$1;
(statearr_24322_24339[(2)] = null);

(statearr_24322_24339[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24309 === (10))){
var inst_24300 = (state_24308[(2)]);
var state_24308__$1 = state_24308;
var statearr_24323_24340 = state_24308__$1;
(statearr_24323_24340[(2)] = inst_24300);

(statearr_24323_24340[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24309 === (8))){
var inst_24290 = (state_24308[(7)]);
var state_24308__$1 = state_24308;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24308__$1,(11),out,inst_24290);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_24324 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24324[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_24324[(1)] = (1));

return statearr_24324;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_24308){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_24308);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e24325){var ex__20869__auto__ = e24325;
var statearr_24326_24341 = state_24308;
(statearr_24326_24341[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_24308[(4)]))){
var statearr_24327_24342 = state_24308;
(statearr_24327_24342[(1)] = cljs.core.first((state_24308[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__24343 = state_24308;
state_24308 = G__24343;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_24308){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_24308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_24328 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_24328[(6)] = c__20992__auto___24330);

return statearr_24328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24345 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24345 = (function (f,ch,meta24346){
this.f = f;
this.ch = ch;
this.meta24346 = meta24346;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24345.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24347,meta24346__$1){
var self__ = this;
var _24347__$1 = this;
return (new cljs.core.async.t_cljs$core$async24345(self__.f,self__.ch,meta24346__$1));
}));

(cljs.core.async.t_cljs$core$async24345.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24347){
var self__ = this;
var _24347__$1 = this;
return self__.meta24346;
}));

(cljs.core.async.t_cljs$core$async24345.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24345.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async24345.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async24345.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24345.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24348 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24348 = (function (f,ch,meta24346,_,fn1,meta24349){
this.f = f;
this.ch = ch;
this.meta24346 = meta24346;
this._ = _;
this.fn1 = fn1;
this.meta24349 = meta24349;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24348.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24350,meta24349__$1){
var self__ = this;
var _24350__$1 = this;
return (new cljs.core.async.t_cljs$core$async24348(self__.f,self__.ch,self__.meta24346,self__._,self__.fn1,meta24349__$1));
}));

(cljs.core.async.t_cljs$core$async24348.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24350){
var self__ = this;
var _24350__$1 = this;
return self__.meta24349;
}));

(cljs.core.async.t_cljs$core$async24348.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24348.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async24348.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async24348.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__24344_SHARP_){
var G__24351 = (((p1__24344_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__24344_SHARP_) : self__.f.call(null,p1__24344_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__24351) : f1.call(null,G__24351));
});
}));

(cljs.core.async.t_cljs$core$async24348.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta24346,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async24345], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta24349], null);
}));

(cljs.core.async.t_cljs$core$async24348.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24348.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24348");

(cljs.core.async.t_cljs$core$async24348.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async24348");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24348.
 */
cljs.core.async.__GT_t_cljs$core$async24348 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24348(f__$1,ch__$1,meta24346__$1,___$2,fn1__$1,meta24349){
return (new cljs.core.async.t_cljs$core$async24348(f__$1,ch__$1,meta24346__$1,___$2,fn1__$1,meta24349));
});

}

return (new cljs.core.async.t_cljs$core$async24348(self__.f,self__.ch,self__.meta24346,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4221__auto__ = ret;
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4221__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__24352 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__24352) : self__.f.call(null,G__24352));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async24345.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24345.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async24345.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta24346], null);
}));

(cljs.core.async.t_cljs$core$async24345.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24345.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24345");

(cljs.core.async.t_cljs$core$async24345.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async24345");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24345.
 */
cljs.core.async.__GT_t_cljs$core$async24345 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24345(f__$1,ch__$1,meta24346){
return (new cljs.core.async.t_cljs$core$async24345(f__$1,ch__$1,meta24346));
});

}

return (new cljs.core.async.t_cljs$core$async24345(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24353 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24353 = (function (f,ch,meta24354){
this.f = f;
this.ch = ch;
this.meta24354 = meta24354;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24355,meta24354__$1){
var self__ = this;
var _24355__$1 = this;
return (new cljs.core.async.t_cljs$core$async24353(self__.f,self__.ch,meta24354__$1));
}));

(cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24355){
var self__ = this;
var _24355__$1 = this;
return self__.meta24354;
}));

(cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async24353.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta24354], null);
}));

(cljs.core.async.t_cljs$core$async24353.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24353.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24353");

(cljs.core.async.t_cljs$core$async24353.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async24353");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24353.
 */
cljs.core.async.__GT_t_cljs$core$async24353 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async24353(f__$1,ch__$1,meta24354){
return (new cljs.core.async.t_cljs$core$async24353(f__$1,ch__$1,meta24354));
});

}

return (new cljs.core.async.t_cljs$core$async24353(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24356 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24356 = (function (p,ch,meta24357){
this.p = p;
this.ch = ch;
this.meta24357 = meta24357;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24358,meta24357__$1){
var self__ = this;
var _24358__$1 = this;
return (new cljs.core.async.t_cljs$core$async24356(self__.p,self__.ch,meta24357__$1));
}));

(cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24358){
var self__ = this;
var _24358__$1 = this;
return self__.meta24357;
}));

(cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async24356.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta24357], null);
}));

(cljs.core.async.t_cljs$core$async24356.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24356.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24356");

(cljs.core.async.t_cljs$core$async24356.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async24356");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24356.
 */
cljs.core.async.__GT_t_cljs$core$async24356 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async24356(p__$1,ch__$1,meta24357){
return (new cljs.core.async.t_cljs$core$async24356(p__$1,ch__$1,meta24357));
});

}

return (new cljs.core.async.t_cljs$core$async24356(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__24360 = arguments.length;
switch (G__24360) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20992__auto___24401 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_24381){
var state_val_24382 = (state_24381[(1)]);
if((state_val_24382 === (7))){
var inst_24377 = (state_24381[(2)]);
var state_24381__$1 = state_24381;
var statearr_24383_24402 = state_24381__$1;
(statearr_24383_24402[(2)] = inst_24377);

(statearr_24383_24402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24382 === (1))){
var state_24381__$1 = state_24381;
var statearr_24384_24403 = state_24381__$1;
(statearr_24384_24403[(2)] = null);

(statearr_24384_24403[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24382 === (4))){
var inst_24363 = (state_24381[(7)]);
var inst_24363__$1 = (state_24381[(2)]);
var inst_24364 = (inst_24363__$1 == null);
var state_24381__$1 = (function (){var statearr_24385 = state_24381;
(statearr_24385[(7)] = inst_24363__$1);

return statearr_24385;
})();
if(cljs.core.truth_(inst_24364)){
var statearr_24386_24404 = state_24381__$1;
(statearr_24386_24404[(1)] = (5));

} else {
var statearr_24387_24405 = state_24381__$1;
(statearr_24387_24405[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24382 === (6))){
var inst_24363 = (state_24381[(7)]);
var inst_24368 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_24363) : p.call(null,inst_24363));
var state_24381__$1 = state_24381;
if(cljs.core.truth_(inst_24368)){
var statearr_24388_24406 = state_24381__$1;
(statearr_24388_24406[(1)] = (8));

} else {
var statearr_24389_24407 = state_24381__$1;
(statearr_24389_24407[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24382 === (3))){
var inst_24379 = (state_24381[(2)]);
var state_24381__$1 = state_24381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24381__$1,inst_24379);
} else {
if((state_val_24382 === (2))){
var state_24381__$1 = state_24381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24381__$1,(4),ch);
} else {
if((state_val_24382 === (11))){
var inst_24371 = (state_24381[(2)]);
var state_24381__$1 = state_24381;
var statearr_24390_24408 = state_24381__$1;
(statearr_24390_24408[(2)] = inst_24371);

(statearr_24390_24408[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24382 === (9))){
var state_24381__$1 = state_24381;
var statearr_24391_24409 = state_24381__$1;
(statearr_24391_24409[(2)] = null);

(statearr_24391_24409[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24382 === (5))){
var inst_24366 = cljs.core.async.close_BANG_(out);
var state_24381__$1 = state_24381;
var statearr_24392_24410 = state_24381__$1;
(statearr_24392_24410[(2)] = inst_24366);

(statearr_24392_24410[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24382 === (10))){
var inst_24374 = (state_24381[(2)]);
var state_24381__$1 = (function (){var statearr_24393 = state_24381;
(statearr_24393[(8)] = inst_24374);

return statearr_24393;
})();
var statearr_24394_24411 = state_24381__$1;
(statearr_24394_24411[(2)] = null);

(statearr_24394_24411[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24382 === (8))){
var inst_24363 = (state_24381[(7)]);
var state_24381__$1 = state_24381;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24381__$1,(11),out,inst_24363);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_24395 = [null,null,null,null,null,null,null,null,null];
(statearr_24395[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_24395[(1)] = (1));

return statearr_24395;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_24381){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_24381);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e24396){var ex__20869__auto__ = e24396;
var statearr_24397_24412 = state_24381;
(statearr_24397_24412[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_24381[(4)]))){
var statearr_24398_24413 = state_24381;
(statearr_24398_24413[(1)] = cljs.core.first((state_24381[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__24414 = state_24381;
state_24381 = G__24414;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_24381){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_24381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_24399 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_24399[(6)] = c__20992__auto___24401);

return statearr_24399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__24416 = arguments.length;
switch (G__24416) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20992__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_24479){
var state_val_24480 = (state_24479[(1)]);
if((state_val_24480 === (7))){
var inst_24475 = (state_24479[(2)]);
var state_24479__$1 = state_24479;
var statearr_24481_24520 = state_24479__$1;
(statearr_24481_24520[(2)] = inst_24475);

(statearr_24481_24520[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (20))){
var inst_24445 = (state_24479[(7)]);
var inst_24456 = (state_24479[(2)]);
var inst_24457 = cljs.core.next(inst_24445);
var inst_24431 = inst_24457;
var inst_24432 = null;
var inst_24433 = (0);
var inst_24434 = (0);
var state_24479__$1 = (function (){var statearr_24482 = state_24479;
(statearr_24482[(8)] = inst_24432);

(statearr_24482[(9)] = inst_24456);

(statearr_24482[(10)] = inst_24431);

(statearr_24482[(11)] = inst_24433);

(statearr_24482[(12)] = inst_24434);

return statearr_24482;
})();
var statearr_24483_24521 = state_24479__$1;
(statearr_24483_24521[(2)] = null);

(statearr_24483_24521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (1))){
var state_24479__$1 = state_24479;
var statearr_24484_24522 = state_24479__$1;
(statearr_24484_24522[(2)] = null);

(statearr_24484_24522[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (4))){
var inst_24420 = (state_24479[(13)]);
var inst_24420__$1 = (state_24479[(2)]);
var inst_24421 = (inst_24420__$1 == null);
var state_24479__$1 = (function (){var statearr_24485 = state_24479;
(statearr_24485[(13)] = inst_24420__$1);

return statearr_24485;
})();
if(cljs.core.truth_(inst_24421)){
var statearr_24486_24523 = state_24479__$1;
(statearr_24486_24523[(1)] = (5));

} else {
var statearr_24487_24524 = state_24479__$1;
(statearr_24487_24524[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (15))){
var state_24479__$1 = state_24479;
var statearr_24491_24525 = state_24479__$1;
(statearr_24491_24525[(2)] = null);

(statearr_24491_24525[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (21))){
var state_24479__$1 = state_24479;
var statearr_24492_24526 = state_24479__$1;
(statearr_24492_24526[(2)] = null);

(statearr_24492_24526[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (13))){
var inst_24432 = (state_24479[(8)]);
var inst_24431 = (state_24479[(10)]);
var inst_24433 = (state_24479[(11)]);
var inst_24434 = (state_24479[(12)]);
var inst_24441 = (state_24479[(2)]);
var inst_24442 = (inst_24434 + (1));
var tmp24488 = inst_24432;
var tmp24489 = inst_24431;
var tmp24490 = inst_24433;
var inst_24431__$1 = tmp24489;
var inst_24432__$1 = tmp24488;
var inst_24433__$1 = tmp24490;
var inst_24434__$1 = inst_24442;
var state_24479__$1 = (function (){var statearr_24493 = state_24479;
(statearr_24493[(14)] = inst_24441);

(statearr_24493[(8)] = inst_24432__$1);

(statearr_24493[(10)] = inst_24431__$1);

(statearr_24493[(11)] = inst_24433__$1);

(statearr_24493[(12)] = inst_24434__$1);

return statearr_24493;
})();
var statearr_24494_24527 = state_24479__$1;
(statearr_24494_24527[(2)] = null);

(statearr_24494_24527[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (22))){
var state_24479__$1 = state_24479;
var statearr_24495_24528 = state_24479__$1;
(statearr_24495_24528[(2)] = null);

(statearr_24495_24528[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (6))){
var inst_24420 = (state_24479[(13)]);
var inst_24429 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_24420) : f.call(null,inst_24420));
var inst_24430 = cljs.core.seq(inst_24429);
var inst_24431 = inst_24430;
var inst_24432 = null;
var inst_24433 = (0);
var inst_24434 = (0);
var state_24479__$1 = (function (){var statearr_24496 = state_24479;
(statearr_24496[(8)] = inst_24432);

(statearr_24496[(10)] = inst_24431);

(statearr_24496[(11)] = inst_24433);

(statearr_24496[(12)] = inst_24434);

return statearr_24496;
})();
var statearr_24497_24529 = state_24479__$1;
(statearr_24497_24529[(2)] = null);

(statearr_24497_24529[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (17))){
var inst_24445 = (state_24479[(7)]);
var inst_24449 = cljs.core.chunk_first(inst_24445);
var inst_24450 = cljs.core.chunk_rest(inst_24445);
var inst_24451 = cljs.core.count(inst_24449);
var inst_24431 = inst_24450;
var inst_24432 = inst_24449;
var inst_24433 = inst_24451;
var inst_24434 = (0);
var state_24479__$1 = (function (){var statearr_24498 = state_24479;
(statearr_24498[(8)] = inst_24432);

(statearr_24498[(10)] = inst_24431);

(statearr_24498[(11)] = inst_24433);

(statearr_24498[(12)] = inst_24434);

return statearr_24498;
})();
var statearr_24499_24530 = state_24479__$1;
(statearr_24499_24530[(2)] = null);

(statearr_24499_24530[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (3))){
var inst_24477 = (state_24479[(2)]);
var state_24479__$1 = state_24479;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24479__$1,inst_24477);
} else {
if((state_val_24480 === (12))){
var inst_24465 = (state_24479[(2)]);
var state_24479__$1 = state_24479;
var statearr_24500_24531 = state_24479__$1;
(statearr_24500_24531[(2)] = inst_24465);

(statearr_24500_24531[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (2))){
var state_24479__$1 = state_24479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24479__$1,(4),in$);
} else {
if((state_val_24480 === (23))){
var inst_24473 = (state_24479[(2)]);
var state_24479__$1 = state_24479;
var statearr_24501_24532 = state_24479__$1;
(statearr_24501_24532[(2)] = inst_24473);

(statearr_24501_24532[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (19))){
var inst_24460 = (state_24479[(2)]);
var state_24479__$1 = state_24479;
var statearr_24502_24533 = state_24479__$1;
(statearr_24502_24533[(2)] = inst_24460);

(statearr_24502_24533[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (11))){
var inst_24445 = (state_24479[(7)]);
var inst_24431 = (state_24479[(10)]);
var inst_24445__$1 = cljs.core.seq(inst_24431);
var state_24479__$1 = (function (){var statearr_24503 = state_24479;
(statearr_24503[(7)] = inst_24445__$1);

return statearr_24503;
})();
if(inst_24445__$1){
var statearr_24504_24534 = state_24479__$1;
(statearr_24504_24534[(1)] = (14));

} else {
var statearr_24505_24535 = state_24479__$1;
(statearr_24505_24535[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (9))){
var inst_24467 = (state_24479[(2)]);
var inst_24468 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_24479__$1 = (function (){var statearr_24506 = state_24479;
(statearr_24506[(15)] = inst_24467);

return statearr_24506;
})();
if(cljs.core.truth_(inst_24468)){
var statearr_24507_24536 = state_24479__$1;
(statearr_24507_24536[(1)] = (21));

} else {
var statearr_24508_24537 = state_24479__$1;
(statearr_24508_24537[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (5))){
var inst_24423 = cljs.core.async.close_BANG_(out);
var state_24479__$1 = state_24479;
var statearr_24509_24538 = state_24479__$1;
(statearr_24509_24538[(2)] = inst_24423);

(statearr_24509_24538[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (14))){
var inst_24445 = (state_24479[(7)]);
var inst_24447 = cljs.core.chunked_seq_QMARK_(inst_24445);
var state_24479__$1 = state_24479;
if(inst_24447){
var statearr_24510_24539 = state_24479__$1;
(statearr_24510_24539[(1)] = (17));

} else {
var statearr_24511_24540 = state_24479__$1;
(statearr_24511_24540[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (16))){
var inst_24463 = (state_24479[(2)]);
var state_24479__$1 = state_24479;
var statearr_24512_24541 = state_24479__$1;
(statearr_24512_24541[(2)] = inst_24463);

(statearr_24512_24541[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24480 === (10))){
var inst_24432 = (state_24479[(8)]);
var inst_24434 = (state_24479[(12)]);
var inst_24439 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_24432,inst_24434);
var state_24479__$1 = state_24479;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24479__$1,(13),out,inst_24439);
} else {
if((state_val_24480 === (18))){
var inst_24445 = (state_24479[(7)]);
var inst_24454 = cljs.core.first(inst_24445);
var state_24479__$1 = state_24479;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24479__$1,(20),out,inst_24454);
} else {
if((state_val_24480 === (8))){
var inst_24433 = (state_24479[(11)]);
var inst_24434 = (state_24479[(12)]);
var inst_24436 = (inst_24434 < inst_24433);
var inst_24437 = inst_24436;
var state_24479__$1 = state_24479;
if(cljs.core.truth_(inst_24437)){
var statearr_24513_24542 = state_24479__$1;
(statearr_24513_24542[(1)] = (10));

} else {
var statearr_24514_24543 = state_24479__$1;
(statearr_24514_24543[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20866__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20866__auto____0 = (function (){
var statearr_24515 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24515[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20866__auto__);

(statearr_24515[(1)] = (1));

return statearr_24515;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20866__auto____1 = (function (state_24479){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_24479);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e24516){var ex__20869__auto__ = e24516;
var statearr_24517_24544 = state_24479;
(statearr_24517_24544[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_24479[(4)]))){
var statearr_24518_24545 = state_24479;
(statearr_24518_24545[(1)] = cljs.core.first((state_24479[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__24546 = state_24479;
state_24479 = G__24546;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20866__auto__ = function(state_24479){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20866__auto____1.call(this,state_24479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20866__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20866__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_24519 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_24519[(6)] = c__20992__auto__);

return statearr_24519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));

return c__20992__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__24548 = arguments.length;
switch (G__24548) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__24551 = arguments.length;
switch (G__24551) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__24554 = arguments.length;
switch (G__24554) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20992__auto___24602 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_24578){
var state_val_24579 = (state_24578[(1)]);
if((state_val_24579 === (7))){
var inst_24573 = (state_24578[(2)]);
var state_24578__$1 = state_24578;
var statearr_24580_24603 = state_24578__$1;
(statearr_24580_24603[(2)] = inst_24573);

(statearr_24580_24603[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24579 === (1))){
var inst_24555 = null;
var state_24578__$1 = (function (){var statearr_24581 = state_24578;
(statearr_24581[(7)] = inst_24555);

return statearr_24581;
})();
var statearr_24582_24604 = state_24578__$1;
(statearr_24582_24604[(2)] = null);

(statearr_24582_24604[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24579 === (4))){
var inst_24558 = (state_24578[(8)]);
var inst_24558__$1 = (state_24578[(2)]);
var inst_24559 = (inst_24558__$1 == null);
var inst_24560 = cljs.core.not(inst_24559);
var state_24578__$1 = (function (){var statearr_24583 = state_24578;
(statearr_24583[(8)] = inst_24558__$1);

return statearr_24583;
})();
if(inst_24560){
var statearr_24584_24605 = state_24578__$1;
(statearr_24584_24605[(1)] = (5));

} else {
var statearr_24585_24606 = state_24578__$1;
(statearr_24585_24606[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24579 === (6))){
var state_24578__$1 = state_24578;
var statearr_24586_24607 = state_24578__$1;
(statearr_24586_24607[(2)] = null);

(statearr_24586_24607[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24579 === (3))){
var inst_24575 = (state_24578[(2)]);
var inst_24576 = cljs.core.async.close_BANG_(out);
var state_24578__$1 = (function (){var statearr_24587 = state_24578;
(statearr_24587[(9)] = inst_24575);

return statearr_24587;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24578__$1,inst_24576);
} else {
if((state_val_24579 === (2))){
var state_24578__$1 = state_24578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24578__$1,(4),ch);
} else {
if((state_val_24579 === (11))){
var inst_24558 = (state_24578[(8)]);
var inst_24567 = (state_24578[(2)]);
var inst_24555 = inst_24558;
var state_24578__$1 = (function (){var statearr_24588 = state_24578;
(statearr_24588[(10)] = inst_24567);

(statearr_24588[(7)] = inst_24555);

return statearr_24588;
})();
var statearr_24589_24608 = state_24578__$1;
(statearr_24589_24608[(2)] = null);

(statearr_24589_24608[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24579 === (9))){
var inst_24558 = (state_24578[(8)]);
var state_24578__$1 = state_24578;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24578__$1,(11),out,inst_24558);
} else {
if((state_val_24579 === (5))){
var inst_24558 = (state_24578[(8)]);
var inst_24555 = (state_24578[(7)]);
var inst_24562 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24558,inst_24555);
var state_24578__$1 = state_24578;
if(inst_24562){
var statearr_24591_24609 = state_24578__$1;
(statearr_24591_24609[(1)] = (8));

} else {
var statearr_24592_24610 = state_24578__$1;
(statearr_24592_24610[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24579 === (10))){
var inst_24570 = (state_24578[(2)]);
var state_24578__$1 = state_24578;
var statearr_24593_24611 = state_24578__$1;
(statearr_24593_24611[(2)] = inst_24570);

(statearr_24593_24611[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24579 === (8))){
var inst_24555 = (state_24578[(7)]);
var tmp24590 = inst_24555;
var inst_24555__$1 = tmp24590;
var state_24578__$1 = (function (){var statearr_24594 = state_24578;
(statearr_24594[(7)] = inst_24555__$1);

return statearr_24594;
})();
var statearr_24595_24612 = state_24578__$1;
(statearr_24595_24612[(2)] = null);

(statearr_24595_24612[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_24596 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24596[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_24596[(1)] = (1));

return statearr_24596;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_24578){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_24578);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e24597){var ex__20869__auto__ = e24597;
var statearr_24598_24613 = state_24578;
(statearr_24598_24613[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_24578[(4)]))){
var statearr_24599_24614 = state_24578;
(statearr_24599_24614[(1)] = cljs.core.first((state_24578[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__24615 = state_24578;
state_24578 = G__24615;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_24578){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_24578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_24600 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_24600[(6)] = c__20992__auto___24602);

return statearr_24600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__24617 = arguments.length;
switch (G__24617) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20992__auto___24684 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_24655){
var state_val_24656 = (state_24655[(1)]);
if((state_val_24656 === (7))){
var inst_24651 = (state_24655[(2)]);
var state_24655__$1 = state_24655;
var statearr_24657_24685 = state_24655__$1;
(statearr_24657_24685[(2)] = inst_24651);

(statearr_24657_24685[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (1))){
var inst_24618 = (new Array(n));
var inst_24619 = inst_24618;
var inst_24620 = (0);
var state_24655__$1 = (function (){var statearr_24658 = state_24655;
(statearr_24658[(7)] = inst_24619);

(statearr_24658[(8)] = inst_24620);

return statearr_24658;
})();
var statearr_24659_24686 = state_24655__$1;
(statearr_24659_24686[(2)] = null);

(statearr_24659_24686[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (4))){
var inst_24623 = (state_24655[(9)]);
var inst_24623__$1 = (state_24655[(2)]);
var inst_24624 = (inst_24623__$1 == null);
var inst_24625 = cljs.core.not(inst_24624);
var state_24655__$1 = (function (){var statearr_24660 = state_24655;
(statearr_24660[(9)] = inst_24623__$1);

return statearr_24660;
})();
if(inst_24625){
var statearr_24661_24687 = state_24655__$1;
(statearr_24661_24687[(1)] = (5));

} else {
var statearr_24662_24688 = state_24655__$1;
(statearr_24662_24688[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (15))){
var inst_24645 = (state_24655[(2)]);
var state_24655__$1 = state_24655;
var statearr_24663_24689 = state_24655__$1;
(statearr_24663_24689[(2)] = inst_24645);

(statearr_24663_24689[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (13))){
var state_24655__$1 = state_24655;
var statearr_24664_24690 = state_24655__$1;
(statearr_24664_24690[(2)] = null);

(statearr_24664_24690[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (6))){
var inst_24620 = (state_24655[(8)]);
var inst_24641 = (inst_24620 > (0));
var state_24655__$1 = state_24655;
if(cljs.core.truth_(inst_24641)){
var statearr_24665_24691 = state_24655__$1;
(statearr_24665_24691[(1)] = (12));

} else {
var statearr_24666_24692 = state_24655__$1;
(statearr_24666_24692[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (3))){
var inst_24653 = (state_24655[(2)]);
var state_24655__$1 = state_24655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24655__$1,inst_24653);
} else {
if((state_val_24656 === (12))){
var inst_24619 = (state_24655[(7)]);
var inst_24643 = cljs.core.vec(inst_24619);
var state_24655__$1 = state_24655;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24655__$1,(15),out,inst_24643);
} else {
if((state_val_24656 === (2))){
var state_24655__$1 = state_24655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24655__$1,(4),ch);
} else {
if((state_val_24656 === (11))){
var inst_24635 = (state_24655[(2)]);
var inst_24636 = (new Array(n));
var inst_24619 = inst_24636;
var inst_24620 = (0);
var state_24655__$1 = (function (){var statearr_24667 = state_24655;
(statearr_24667[(7)] = inst_24619);

(statearr_24667[(10)] = inst_24635);

(statearr_24667[(8)] = inst_24620);

return statearr_24667;
})();
var statearr_24668_24693 = state_24655__$1;
(statearr_24668_24693[(2)] = null);

(statearr_24668_24693[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (9))){
var inst_24619 = (state_24655[(7)]);
var inst_24633 = cljs.core.vec(inst_24619);
var state_24655__$1 = state_24655;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24655__$1,(11),out,inst_24633);
} else {
if((state_val_24656 === (5))){
var inst_24628 = (state_24655[(11)]);
var inst_24619 = (state_24655[(7)]);
var inst_24623 = (state_24655[(9)]);
var inst_24620 = (state_24655[(8)]);
var inst_24627 = (inst_24619[inst_24620] = inst_24623);
var inst_24628__$1 = (inst_24620 + (1));
var inst_24629 = (inst_24628__$1 < n);
var state_24655__$1 = (function (){var statearr_24669 = state_24655;
(statearr_24669[(11)] = inst_24628__$1);

(statearr_24669[(12)] = inst_24627);

return statearr_24669;
})();
if(cljs.core.truth_(inst_24629)){
var statearr_24670_24694 = state_24655__$1;
(statearr_24670_24694[(1)] = (8));

} else {
var statearr_24671_24695 = state_24655__$1;
(statearr_24671_24695[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (14))){
var inst_24648 = (state_24655[(2)]);
var inst_24649 = cljs.core.async.close_BANG_(out);
var state_24655__$1 = (function (){var statearr_24673 = state_24655;
(statearr_24673[(13)] = inst_24648);

return statearr_24673;
})();
var statearr_24674_24696 = state_24655__$1;
(statearr_24674_24696[(2)] = inst_24649);

(statearr_24674_24696[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (10))){
var inst_24639 = (state_24655[(2)]);
var state_24655__$1 = state_24655;
var statearr_24675_24697 = state_24655__$1;
(statearr_24675_24697[(2)] = inst_24639);

(statearr_24675_24697[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24656 === (8))){
var inst_24628 = (state_24655[(11)]);
var inst_24619 = (state_24655[(7)]);
var tmp24672 = inst_24619;
var inst_24619__$1 = tmp24672;
var inst_24620 = inst_24628;
var state_24655__$1 = (function (){var statearr_24676 = state_24655;
(statearr_24676[(7)] = inst_24619__$1);

(statearr_24676[(8)] = inst_24620);

return statearr_24676;
})();
var statearr_24677_24698 = state_24655__$1;
(statearr_24677_24698[(2)] = null);

(statearr_24677_24698[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_24678 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24678[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_24678[(1)] = (1));

return statearr_24678;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_24655){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_24655);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e24679){var ex__20869__auto__ = e24679;
var statearr_24680_24699 = state_24655;
(statearr_24680_24699[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_24655[(4)]))){
var statearr_24681_24700 = state_24655;
(statearr_24681_24700[(1)] = cljs.core.first((state_24655[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__24701 = state_24655;
state_24655 = G__24701;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_24655){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_24655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_24682 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_24682[(6)] = c__20992__auto___24684);

return statearr_24682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__24703 = arguments.length;
switch (G__24703) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20992__auto___24781 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20993__auto__ = (function (){var switch__20865__auto__ = (function (state_24748){
var state_val_24749 = (state_24748[(1)]);
if((state_val_24749 === (7))){
var inst_24744 = (state_24748[(2)]);
var state_24748__$1 = state_24748;
var statearr_24750_24782 = state_24748__$1;
(statearr_24750_24782[(2)] = inst_24744);

(statearr_24750_24782[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (1))){
var inst_24704 = [];
var inst_24705 = inst_24704;
var inst_24706 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_24748__$1 = (function (){var statearr_24751 = state_24748;
(statearr_24751[(7)] = inst_24706);

(statearr_24751[(8)] = inst_24705);

return statearr_24751;
})();
var statearr_24752_24783 = state_24748__$1;
(statearr_24752_24783[(2)] = null);

(statearr_24752_24783[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (4))){
var inst_24709 = (state_24748[(9)]);
var inst_24709__$1 = (state_24748[(2)]);
var inst_24710 = (inst_24709__$1 == null);
var inst_24711 = cljs.core.not(inst_24710);
var state_24748__$1 = (function (){var statearr_24753 = state_24748;
(statearr_24753[(9)] = inst_24709__$1);

return statearr_24753;
})();
if(inst_24711){
var statearr_24754_24784 = state_24748__$1;
(statearr_24754_24784[(1)] = (5));

} else {
var statearr_24755_24785 = state_24748__$1;
(statearr_24755_24785[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (15))){
var inst_24705 = (state_24748[(8)]);
var inst_24736 = cljs.core.vec(inst_24705);
var state_24748__$1 = state_24748;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24748__$1,(18),out,inst_24736);
} else {
if((state_val_24749 === (13))){
var inst_24731 = (state_24748[(2)]);
var state_24748__$1 = state_24748;
var statearr_24756_24786 = state_24748__$1;
(statearr_24756_24786[(2)] = inst_24731);

(statearr_24756_24786[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (6))){
var inst_24705 = (state_24748[(8)]);
var inst_24733 = inst_24705.length;
var inst_24734 = (inst_24733 > (0));
var state_24748__$1 = state_24748;
if(cljs.core.truth_(inst_24734)){
var statearr_24757_24787 = state_24748__$1;
(statearr_24757_24787[(1)] = (15));

} else {
var statearr_24758_24788 = state_24748__$1;
(statearr_24758_24788[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (17))){
var inst_24741 = (state_24748[(2)]);
var inst_24742 = cljs.core.async.close_BANG_(out);
var state_24748__$1 = (function (){var statearr_24759 = state_24748;
(statearr_24759[(10)] = inst_24741);

return statearr_24759;
})();
var statearr_24760_24789 = state_24748__$1;
(statearr_24760_24789[(2)] = inst_24742);

(statearr_24760_24789[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (3))){
var inst_24746 = (state_24748[(2)]);
var state_24748__$1 = state_24748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24748__$1,inst_24746);
} else {
if((state_val_24749 === (12))){
var inst_24705 = (state_24748[(8)]);
var inst_24724 = cljs.core.vec(inst_24705);
var state_24748__$1 = state_24748;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24748__$1,(14),out,inst_24724);
} else {
if((state_val_24749 === (2))){
var state_24748__$1 = state_24748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24748__$1,(4),ch);
} else {
if((state_val_24749 === (11))){
var inst_24713 = (state_24748[(11)]);
var inst_24705 = (state_24748[(8)]);
var inst_24709 = (state_24748[(9)]);
var inst_24721 = inst_24705.push(inst_24709);
var tmp24761 = inst_24705;
var inst_24705__$1 = tmp24761;
var inst_24706 = inst_24713;
var state_24748__$1 = (function (){var statearr_24762 = state_24748;
(statearr_24762[(7)] = inst_24706);

(statearr_24762[(8)] = inst_24705__$1);

(statearr_24762[(12)] = inst_24721);

return statearr_24762;
})();
var statearr_24763_24790 = state_24748__$1;
(statearr_24763_24790[(2)] = null);

(statearr_24763_24790[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (9))){
var inst_24706 = (state_24748[(7)]);
var inst_24717 = cljs.core.keyword_identical_QMARK_(inst_24706,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_24748__$1 = state_24748;
var statearr_24764_24791 = state_24748__$1;
(statearr_24764_24791[(2)] = inst_24717);

(statearr_24764_24791[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (5))){
var inst_24706 = (state_24748[(7)]);
var inst_24713 = (state_24748[(11)]);
var inst_24714 = (state_24748[(13)]);
var inst_24709 = (state_24748[(9)]);
var inst_24713__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_24709) : f.call(null,inst_24709));
var inst_24714__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24713__$1,inst_24706);
var state_24748__$1 = (function (){var statearr_24765 = state_24748;
(statearr_24765[(11)] = inst_24713__$1);

(statearr_24765[(13)] = inst_24714__$1);

return statearr_24765;
})();
if(inst_24714__$1){
var statearr_24766_24792 = state_24748__$1;
(statearr_24766_24792[(1)] = (8));

} else {
var statearr_24767_24793 = state_24748__$1;
(statearr_24767_24793[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (14))){
var inst_24713 = (state_24748[(11)]);
var inst_24709 = (state_24748[(9)]);
var inst_24726 = (state_24748[(2)]);
var inst_24727 = [];
var inst_24728 = inst_24727.push(inst_24709);
var inst_24705 = inst_24727;
var inst_24706 = inst_24713;
var state_24748__$1 = (function (){var statearr_24768 = state_24748;
(statearr_24768[(7)] = inst_24706);

(statearr_24768[(8)] = inst_24705);

(statearr_24768[(14)] = inst_24726);

(statearr_24768[(15)] = inst_24728);

return statearr_24768;
})();
var statearr_24769_24794 = state_24748__$1;
(statearr_24769_24794[(2)] = null);

(statearr_24769_24794[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (16))){
var state_24748__$1 = state_24748;
var statearr_24770_24795 = state_24748__$1;
(statearr_24770_24795[(2)] = null);

(statearr_24770_24795[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (10))){
var inst_24719 = (state_24748[(2)]);
var state_24748__$1 = state_24748;
if(cljs.core.truth_(inst_24719)){
var statearr_24771_24796 = state_24748__$1;
(statearr_24771_24796[(1)] = (11));

} else {
var statearr_24772_24797 = state_24748__$1;
(statearr_24772_24797[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (18))){
var inst_24738 = (state_24748[(2)]);
var state_24748__$1 = state_24748;
var statearr_24773_24798 = state_24748__$1;
(statearr_24773_24798[(2)] = inst_24738);

(statearr_24773_24798[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24749 === (8))){
var inst_24714 = (state_24748[(13)]);
var state_24748__$1 = state_24748;
var statearr_24774_24799 = state_24748__$1;
(statearr_24774_24799[(2)] = inst_24714);

(statearr_24774_24799[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20866__auto__ = null;
var cljs$core$async$state_machine__20866__auto____0 = (function (){
var statearr_24775 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24775[(0)] = cljs$core$async$state_machine__20866__auto__);

(statearr_24775[(1)] = (1));

return statearr_24775;
});
var cljs$core$async$state_machine__20866__auto____1 = (function (state_24748){
while(true){
var ret_value__20867__auto__ = (function (){try{while(true){
var result__20868__auto__ = switch__20865__auto__(state_24748);
if(cljs.core.keyword_identical_QMARK_(result__20868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20868__auto__;
}
break;
}
}catch (e24776){var ex__20869__auto__ = e24776;
var statearr_24777_24800 = state_24748;
(statearr_24777_24800[(2)] = ex__20869__auto__);


if(cljs.core.seq((state_24748[(4)]))){
var statearr_24778_24801 = state_24748;
(statearr_24778_24801[(1)] = cljs.core.first((state_24748[(4)])));

} else {
throw ex__20869__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20867__auto__,cljs.core.cst$kw$recur)){
var G__24802 = state_24748;
state_24748 = G__24802;
continue;
} else {
return ret_value__20867__auto__;
}
break;
}
});
cljs$core$async$state_machine__20866__auto__ = function(state_24748){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20866__auto____1.call(this,state_24748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20866__auto____0;
cljs$core$async$state_machine__20866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20866__auto____1;
return cljs$core$async$state_machine__20866__auto__;
})()
})();
var state__20994__auto__ = (function (){var statearr_24779 = (f__20993__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20993__auto__.cljs$core$IFn$_invoke$arity$0() : f__20993__auto__.call(null));
(statearr_24779[(6)] = c__20992__auto___24781);

return statearr_24779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20994__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

