// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__6089(s__6090){
return (new cljs.core.LazySeq(null,(function (){
var s__6090__$1 = s__6090;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__6090__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__6095 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6095,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6095,(1),null);
var iterys__4618__auto__ = ((function (s__6090__$1,vec__6095,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__6089_$_iter__6091(s__6092){
return (new cljs.core.LazySeq(null,((function (s__6090__$1,vec__6095,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__6092__$1 = s__6092;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__6092__$1);
if(temp__5753__auto____$1){
var s__6092__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__6092__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__6092__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__6094 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__6093 = (0);
while(true){
if((i__6093 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__6093);
cljs.core.chunk_append(b__6094,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__6147 = (i__6093 + (1));
i__6093 = G__6147;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__6094),tailrecursion$priority_map$iter__6089_$_iter__6091(cljs.core.chunk_rest(s__6092__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__6094),null);
}
} else {
var item = cljs.core.first(s__6092__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__6089_$_iter__6091(cljs.core.rest(s__6092__$2)));
}
} else {
return null;
}
break;
}
});})(s__6090__$1,vec__6095,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__6090__$1,vec__6095,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__6089(cljs.core.rest(s__6090__$1)));
} else {
var G__6148 = cljs.core.rest(s__6090__$1);
s__6090__$1 = G__6148;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__6098(s__6099){
return (new cljs.core.LazySeq(null,(function (){
var s__6099__$1 = s__6099;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__6099__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__6104 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6104,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6104,(1),null);
var iterys__4618__auto__ = ((function (s__6099__$1,vec__6104,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__6098_$_iter__6100(s__6101){
return (new cljs.core.LazySeq(null,((function (s__6099__$1,vec__6104,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__6101__$1 = s__6101;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__6101__$1);
if(temp__5753__auto____$1){
var s__6101__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__6101__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__6101__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__6103 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__6102 = (0);
while(true){
if((i__6102 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__6102);
cljs.core.chunk_append(b__6103,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__6149 = (i__6102 + (1));
i__6102 = G__6149;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__6103),tailrecursion$priority_map$iter__6098_$_iter__6100(cljs.core.chunk_rest(s__6101__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__6103),null);
}
} else {
var item = cljs.core.first(s__6101__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__6098_$_iter__6100(cljs.core.rest(s__6101__$2)));
}
} else {
return null;
}
break;
}
});})(s__6099__$1,vec__6104,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__6099__$1,vec__6104,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__6098(cljs.core.rest(s__6099__$1)));
} else {
var G__6150 = cljs.core.rest(s__6099__$1);
s__6099__$1 = G__6150;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__6107 = item;
var G__6108 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__6107,G__6108) : self__.item__GT_priority.call(null,G__6107,G__6108));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__6109(s__6110){
return (new cljs.core.LazySeq(null,(function (){
var s__6110__$1 = s__6110;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__6110__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__6115 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6115,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6115,(1),null);
var iterys__4618__auto__ = ((function (s__6110__$1,vec__6115,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__6109_$_iter__6111(s__6112){
return (new cljs.core.LazySeq(null,((function (s__6110__$1,vec__6115,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__6112__$1 = s__6112;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__6112__$1);
if(temp__5753__auto____$1){
var s__6112__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__6112__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__6112__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__6114 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__6113 = (0);
while(true){
if((i__6113 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__6113);
cljs.core.chunk_append(b__6114,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__6151 = (i__6113 + (1));
i__6113 = G__6151;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__6114),tailrecursion$priority_map$iter__6109_$_iter__6111(cljs.core.chunk_rest(s__6112__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__6114),null);
}
} else {
var item = cljs.core.first(s__6112__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__6109_$_iter__6111(cljs.core.rest(s__6112__$2)));
}
} else {
return null;
}
break;
}
});})(s__6110__$1,vec__6115,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__6110__$1,vec__6115,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__6109(cljs.core.rest(s__6110__$1)));
} else {
var G__6152 = cljs.core.rest(s__6110__$1);
s__6110__$1 = G__6152;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__6118(s__6119){
return (new cljs.core.LazySeq(null,(function (){
var s__6119__$1 = s__6119;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__6119__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__6124 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6124,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6124,(1),null);
var iterys__4618__auto__ = ((function (s__6119__$1,vec__6124,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__6118_$_iter__6120(s__6121){
return (new cljs.core.LazySeq(null,((function (s__6119__$1,vec__6124,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__6121__$1 = s__6121;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__6121__$1);
if(temp__5753__auto____$1){
var s__6121__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__6121__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__6121__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__6123 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__6122 = (0);
while(true){
if((i__6122 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__6122);
cljs.core.chunk_append(b__6123,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__6153 = (i__6122 + (1));
i__6122 = G__6153;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__6123),tailrecursion$priority_map$iter__6118_$_iter__6120(cljs.core.chunk_rest(s__6121__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__6123),null);
}
} else {
var item = cljs.core.first(s__6121__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__6118_$_iter__6120(cljs.core.rest(s__6121__$2)));
}
} else {
return null;
}
break;
}
});})(s__6119__$1,vec__6124,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__6119__$1,vec__6124,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__6118(cljs.core.rest(s__6119__$1)));
} else {
var G__6154 = cljs.core.rest(s__6119__$1);
s__6119__$1 = G__6154;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__6155 = null;
var G__6155__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__6155__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__6155 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__6155__2.call(this,self__,item);
case 3:
return G__6155__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__6155.cljs$core$IFn$_invoke$arity$2 = G__6155__2;
G__6155.cljs$core$IFn$_invoke$arity$3 = G__6155__3;
return G__6155;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args6088){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6088)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__6127 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__6127.cljs$core$IFn$_invoke$arity$1 ? fexpr__6127.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__6127.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__6128(s__6129){
return (new cljs.core.LazySeq(null,(function (){
var s__6129__$1 = s__6129;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__6129__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__6134 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6134,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6134,(1),null);
var iterys__4618__auto__ = ((function (s__6129__$1,vec__6134,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__6128_$_iter__6130(s__6131){
return (new cljs.core.LazySeq(null,((function (s__6129__$1,vec__6134,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__6131__$1 = s__6131;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__6131__$1);
if(temp__5753__auto____$1){
var s__6131__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__6131__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__6131__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__6133 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__6132 = (0);
while(true){
if((i__6132 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__6132);
cljs.core.chunk_append(b__6133,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__6156 = (i__6132 + (1));
i__6132 = G__6156;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__6133),tailrecursion$priority_map$iter__6128_$_iter__6130(cljs.core.chunk_rest(s__6131__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__6133),null);
}
} else {
var item = cljs.core.first(s__6131__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__6128_$_iter__6130(cljs.core.rest(s__6131__$2)));
}
} else {
return null;
}
break;
}
});})(s__6129__$1,vec__6134,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__6129__$1,vec__6134,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__6128(cljs.core.rest(s__6129__$1)));
} else {
var G__6157 = cljs.core.rest(s__6129__$1);
s__6129__$1 = G__6157;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__6137(s__6138){
return (new cljs.core.LazySeq(null,(function (){
var s__6138__$1 = s__6138;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__6138__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__6143 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6143,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6143,(1),null);
var iterys__4618__auto__ = ((function (s__6138__$1,vec__6143,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__6137_$_iter__6139(s__6140){
return (new cljs.core.LazySeq(null,((function (s__6138__$1,vec__6143,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__6140__$1 = s__6140;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__6140__$1);
if(temp__5753__auto____$1){
var s__6140__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__6140__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__6140__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__6142 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__6141 = (0);
while(true){
if((i__6141 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__6141);
cljs.core.chunk_append(b__6142,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__6158 = (i__6141 + (1));
i__6141 = G__6158;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__6142),tailrecursion$priority_map$iter__6137_$_iter__6139(cljs.core.chunk_rest(s__6140__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__6142),null);
}
} else {
var item = cljs.core.first(s__6140__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__6137_$_iter__6139(cljs.core.rest(s__6140__$2)));
}
} else {
return null;
}
break;
}
});})(s__6138__$1,vec__6143,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__6138__$1,vec__6143,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__6137(cljs.core.rest(s__6138__$1)));
} else {
var G__6159 = cljs.core.rest(s__6138__$1);
s__6138__$1 = G__6159;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__6146 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__6146) : self__.keyfn.call(null,G__6146));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__6161 = arguments.length;
switch (G__6161) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4835__auto__ = [];
var len__4829__auto___6164 = arguments.length;
var i__4830__auto___6165 = (0);
while(true){
if((i__4830__auto___6165 < len__4829__auto___6164)){
args__4835__auto__.push((arguments[i__4830__auto___6165]));

var G__6166 = (i__4830__auto___6165 + (1));
i__4830__auto___6165 = G__6166;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__6167 = cljs.core.nnext(in$);
var G__6168 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__6167;
out = G__6168;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq6163){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq6163));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___6171 = arguments.length;
var i__4830__auto___6172 = (0);
while(true){
if((i__4830__auto___6172 < len__4829__auto___6171)){
args__4835__auto__.push((arguments[i__4830__auto___6172]));

var G__6173 = (i__4830__auto___6172 + (1));
i__4830__auto___6172 = G__6173;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__6174 = cljs.core.nnext(in$);
var G__6175 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__6174;
out = G__6175;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq6169){
var G__6170 = cljs.core.first(seq6169);
var seq6169__$1 = cljs.core.next(seq6169);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6170,seq6169__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4835__auto__ = [];
var len__4829__auto___6178 = arguments.length;
var i__4830__auto___6179 = (0);
while(true){
if((i__4830__auto___6179 < len__4829__auto___6178)){
args__4835__auto__.push((arguments[i__4830__auto___6179]));

var G__6180 = (i__4830__auto___6179 + (1));
i__4830__auto___6179 = G__6180;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__6181 = cljs.core.nnext(in$);
var G__6182 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__6181;
out = G__6182;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq6176){
var G__6177 = cljs.core.first(seq6176);
var seq6176__$1 = cljs.core.next(seq6176);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6177,seq6176__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___6186 = arguments.length;
var i__4830__auto___6187 = (0);
while(true){
if((i__4830__auto___6187 < len__4829__auto___6186)){
args__4835__auto__.push((arguments[i__4830__auto___6187]));

var G__6188 = (i__4830__auto___6187 + (1));
i__4830__auto___6187 = G__6188;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__6189 = cljs.core.nnext(in$);
var G__6190 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__6189;
out = G__6190;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq6183){
var G__6184 = cljs.core.first(seq6183);
var seq6183__$1 = cljs.core.next(seq6183);
var G__6185 = cljs.core.first(seq6183__$1);
var seq6183__$2 = cljs.core.next(seq6183__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6184,G__6185,seq6183__$2);
}));

