// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__88376 = (line + (1));
var G__88377 = (1);
var G__88378 = (counter + (1));
line = G__88376;
col = G__88377;
counter = G__88378;
continue;
} else {
var G__88379 = line;
var G__88380 = (col + (1));
var G__88381 = (counter + (1));
line = G__88379;
col = G__88380;
counter = G__88381;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__88382 = cljs.core.next(chars);
var G__88383 = (n__$1 - (1));
chars = G__88382;
n__$1 = G__88383;
continue;
} else {
var G__88384 = cljs.core.next(chars);
var G__88385 = n__$1;
chars = G__88384;
n__$1 = G__88385;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__88386){
var map__88387 = p__88386;
var map__88387__$1 = cljs.core.__destructure_map(map__88387);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88387__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88387__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88387__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88387__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__88388_88396 = cljs.core.seq(full_reasons);
var chunk__88389_88397 = null;
var count__88390_88398 = (0);
var i__88391_88399 = (0);
while(true){
if((i__88391_88399 < count__88390_88398)){
var r_88400 = chunk__88389_88397.cljs$core$IIndexed$_nth$arity$2(null,i__88391_88399);
instaparse.failure.print_reason(r_88400);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__88401 = seq__88388_88396;
var G__88402 = chunk__88389_88397;
var G__88403 = count__88390_88398;
var G__88404 = (i__88391_88399 + (1));
seq__88388_88396 = G__88401;
chunk__88389_88397 = G__88402;
count__88390_88398 = G__88403;
i__88391_88399 = G__88404;
continue;
} else {
var temp__5753__auto___88405 = cljs.core.seq(seq__88388_88396);
if(temp__5753__auto___88405){
var seq__88388_88406__$1 = temp__5753__auto___88405;
if(cljs.core.chunked_seq_QMARK_(seq__88388_88406__$1)){
var c__4649__auto___88407 = cljs.core.chunk_first(seq__88388_88406__$1);
var G__88408 = cljs.core.chunk_rest(seq__88388_88406__$1);
var G__88409 = c__4649__auto___88407;
var G__88410 = cljs.core.count(c__4649__auto___88407);
var G__88411 = (0);
seq__88388_88396 = G__88408;
chunk__88389_88397 = G__88409;
count__88390_88398 = G__88410;
i__88391_88399 = G__88411;
continue;
} else {
var r_88412 = cljs.core.first(seq__88388_88406__$1);
instaparse.failure.print_reason(r_88412);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__88413 = cljs.core.next(seq__88388_88406__$1);
var G__88414 = null;
var G__88415 = (0);
var G__88416 = (0);
seq__88388_88396 = G__88413;
chunk__88389_88397 = G__88414;
count__88390_88398 = G__88415;
i__88391_88399 = G__88416;
continue;
}
} else {
}
}
break;
}

var seq__88392 = cljs.core.seq(partial_reasons);
var chunk__88393 = null;
var count__88394 = (0);
var i__88395 = (0);
while(true){
if((i__88395 < count__88394)){
var r = chunk__88393.cljs$core$IIndexed$_nth$arity$2(null,i__88395);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__88417 = seq__88392;
var G__88418 = chunk__88393;
var G__88419 = count__88394;
var G__88420 = (i__88395 + (1));
seq__88392 = G__88417;
chunk__88393 = G__88418;
count__88394 = G__88419;
i__88395 = G__88420;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__88392);
if(temp__5753__auto__){
var seq__88392__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__88392__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__88392__$1);
var G__88421 = cljs.core.chunk_rest(seq__88392__$1);
var G__88422 = c__4649__auto__;
var G__88423 = cljs.core.count(c__4649__auto__);
var G__88424 = (0);
seq__88392 = G__88421;
chunk__88393 = G__88422;
count__88394 = G__88423;
i__88395 = G__88424;
continue;
} else {
var r = cljs.core.first(seq__88392__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__88425 = cljs.core.next(seq__88392__$1);
var G__88426 = null;
var G__88427 = (0);
var G__88428 = (0);
seq__88392 = G__88425;
chunk__88393 = G__88426;
count__88394 = G__88427;
i__88395 = G__88428;
continue;
}
} else {
return null;
}
}
break;
}
});
