// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__34340 = cljs.core._EQ_;
var expr__34341 = e.getLastErrorCode();
if(cljs.core.truth_((pred__34340.cljs$core$IFn$_invoke$arity$2 ? pred__34340.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__34341) : pred__34340.call(null,goog.net.ErrorCode.NO_ERROR,expr__34341)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__34340.cljs$core$IFn$_invoke$arity$2 ? pred__34340.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__34341) : pred__34340.call(null,goog.net.ErrorCode.EXCEPTION,expr__34341)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__34340.cljs$core$IFn$_invoke$arity$2 ? pred__34340.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__34341) : pred__34340.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__34341)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__34340.cljs$core$IFn$_invoke$arity$2 ? pred__34340.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__34341) : pred__34340.call(null,goog.net.ErrorCode.ABORT,expr__34341)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__34340.cljs$core$IFn$_invoke$arity$2 ? pred__34340.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__34341) : pred__34340.call(null,goog.net.ErrorCode.TIMEOUT,expr__34341)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4221__auto__ = status;
if(cljs.core.truth_(and__4221__auto__)){
return (status > (0));
} else {
return and__4221__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__34343 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34343,cljs.core.cst$kw$status,status);
} else {
return G__34343;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__34344 = opts;
var map__34344__$1 = cljs.core.__destructure_map(map__34344);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34344__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34344__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34344__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__34345 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__34345__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__34345,headers], 0)):G__34345);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34345__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__34345__$1;
}
})();
try{var G__34347_34353 = url;
var G__34348_34354 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__34349_34355 = "POST";
var G__34350_34356 = fluree.db.util.json.stringify(message);
var G__34351_34357 = cljs.core.clj__GT_js(headers__$1);
var G__34352_34358 = request_timeout;
goog.net.XhrIo.send(G__34347_34353,G__34348_34354,G__34349_34355,G__34350_34356,G__34351_34357,G__34352_34358);
}catch (e34346){var e_34359 = e34346;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_34359);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__34360 = opts;
var map__34360__$1 = cljs.core.__destructure_map(map__34360);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34360__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34360__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34360__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34360__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34360__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__34361 = cljs.core.PersistentArrayMap.EMPTY;
var G__34361__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__34361,headers], 0)):G__34361);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34361__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__34361__$1;
}
})();
try{var G__34363_34370 = url;
var G__34364_34371 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__34369 = output_format;
var G__34369__$1 = (((G__34369 instanceof cljs.core.Keyword))?G__34369.fqn:null);
switch (G__34369__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__34365_34372 = "GET";
var G__34366_34373 = body;
var G__34367_34374 = cljs.core.clj__GT_js(headers__$1);
var G__34368_34375 = request_timeout;
goog.net.XhrIo.send(G__34363_34370,G__34364_34371,G__34365_34372,G__34366_34373,G__34367_34374,G__34368_34375);
}catch (e34362){var e_34377 = e34362;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_34377);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__34378 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34378,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__34378;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__15891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15892__auto__ = (function (){var switch__15853__auto__ = (function (state_34411){
var state_val_34412 = (state_34411[(1)]);
if((state_val_34412 === (7))){
var inst_34407 = (state_34411[(2)]);
var state_34411__$1 = state_34411;
var statearr_34413_34438 = state_34411__$1;
(statearr_34413_34438[(2)] = inst_34407);

(statearr_34413_34438[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34412 === (1))){
var state_34411__$1 = state_34411;
var statearr_34414_34439 = state_34411__$1;
(statearr_34414_34439[(2)] = null);

(statearr_34414_34439[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34412 === (4))){
var inst_34382 = (state_34411[(7)]);
var inst_34382__$1 = (state_34411[(2)]);
var inst_34383 = (inst_34382__$1 == null);
var state_34411__$1 = (function (){var statearr_34415 = state_34411;
(statearr_34415[(7)] = inst_34382__$1);

return statearr_34415;
})();
if(cljs.core.truth_(inst_34383)){
var statearr_34416_34440 = state_34411__$1;
(statearr_34416_34440[(1)] = (5));

} else {
var statearr_34417_34441 = state_34411__$1;
(statearr_34417_34441[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34412 === (6))){
var inst_34382 = (state_34411[(7)]);
var inst_34390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34382,(0),null);
var inst_34391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34382,(1),null);
var state_34411__$1 = (function (){var statearr_34418 = state_34411;
(statearr_34418[(8)] = inst_34391);

(statearr_34418[(9)] = inst_34390);

return statearr_34418;
})();
var statearr_34419_34442 = state_34411__$1;
(statearr_34419_34442[(2)] = null);

(statearr_34419_34442[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34412 === (3))){
var inst_34409 = (state_34411[(2)]);
var state_34411__$1 = state_34411;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34411__$1,inst_34409);
} else {
if((state_val_34412 === (2))){
var state_34411__$1 = state_34411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34411__$1,(4),pub_chan);
} else {
if((state_val_34412 === (11))){
var _ = (function (){var statearr_34421 = state_34411;
(statearr_34421[(4)] = cljs.core.rest((state_34411[(4)])));

return statearr_34421;
})();
var state_34411__$1 = state_34411;
var ex34420 = (state_34411__$1[(2)]);
var statearr_34422_34443 = state_34411__$1;
(statearr_34422_34443[(5)] = ex34420);


if((ex34420 instanceof Error)){
var statearr_34423_34444 = state_34411__$1;
(statearr_34423_34444[(1)] = (10));

(statearr_34423_34444[(5)] = null);

} else {
throw ex34420;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34412 === (9))){
var inst_34404 = (state_34411[(2)]);
var state_34411__$1 = (function (){var statearr_34424 = state_34411;
(statearr_34424[(10)] = inst_34404);

return statearr_34424;
})();
var statearr_34425_34445 = state_34411__$1;
(statearr_34425_34445[(2)] = null);

(statearr_34425_34445[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34412 === (5))){
var inst_34385 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_34411__$1 = state_34411;
var statearr_34426_34446 = state_34411__$1;
(statearr_34426_34446[(2)] = inst_34385);

(statearr_34426_34446[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34412 === (10))){
var inst_34391 = (state_34411[(8)]);
var inst_34392 = (state_34411[(2)]);
var inst_34393 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_34392,"Websocket send message error:",inst_34392], 0));
var inst_34394 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34391,false);
var state_34411__$1 = (function (){var statearr_34427 = state_34411;
(statearr_34427[(11)] = inst_34393);

return statearr_34427;
})();
var statearr_34428_34447 = state_34411__$1;
(statearr_34428_34447[(2)] = inst_34394);

(statearr_34428_34447[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34412 === (8))){
var inst_34391 = (state_34411[(8)]);
var inst_34390 = (state_34411[(9)]);
var _ = (function (){var statearr_34429 = state_34411;
(statearr_34429[(4)] = cljs.core.cons((11),(state_34411[(4)])));

return statearr_34429;
})();
var inst_34400 = ws.send(inst_34390);
var inst_34401 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34391,true);
var ___$1 = (function (){var statearr_34430 = state_34411;
(statearr_34430[(4)] = cljs.core.rest((state_34411[(4)])));

return statearr_34430;
})();
var state_34411__$1 = (function (){var statearr_34431 = state_34411;
(statearr_34431[(12)] = inst_34400);

return statearr_34431;
})();
var statearr_34432_34448 = state_34411__$1;
(statearr_34432_34448[(2)] = inst_34401);

(statearr_34432_34448[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto____0 = (function (){
var statearr_34433 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34433[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto__);

(statearr_34433[(1)] = (1));

return statearr_34433;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto____1 = (function (state_34411){
while(true){
var ret_value__15855__auto__ = (function (){try{while(true){
var result__15856__auto__ = switch__15853__auto__(state_34411);
if(cljs.core.keyword_identical_QMARK_(result__15856__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15856__auto__;
}
break;
}
}catch (e34434){var ex__15857__auto__ = e34434;
var statearr_34435_34449 = state_34411;
(statearr_34435_34449[(2)] = ex__15857__auto__);


if(cljs.core.seq((state_34411[(4)]))){
var statearr_34436_34450 = state_34411;
(statearr_34436_34450[(1)] = cljs.core.first((state_34411[(4)])));

} else {
throw ex__15857__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15855__auto__,cljs.core.cst$kw$recur)){
var G__34451 = state_34411;
state_34411 = G__34451;
continue;
} else {
return ret_value__15855__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto__ = function(state_34411){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto____1.call(this,state_34411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15854__auto__;
})()
})();
var state__15893__auto__ = (function (){var statearr_34437 = (f__15892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15892__auto__.cljs$core$IFn$_invoke$arity$0() : f__15892__auto__.call(null));
(statearr_34437[(6)] = c__15891__auto__);

return statearr_34437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15893__auto__);
}));

return c__15891__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__15891__auto___34490 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15892__auto__ = (function (){var switch__15853__auto__ = (function (state_34477){
var state_val_34478 = (state_34477[(1)]);
if((state_val_34478 === (1))){
var inst_34456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34457 = [open_QMARK_,timeout_chan];
var inst_34458 = (new cljs.core.PersistentVector(null,2,(5),inst_34456,inst_34457,null));
var state_34477__$1 = state_34477;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_34477__$1,(2),inst_34458,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_34478 === (2))){
var inst_34460 = (state_34477[(2)]);
var inst_34461 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34460,(0),null);
var inst_34462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34460,(1),null);
var inst_34463 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34462,timeout_chan);
var state_34477__$1 = (function (){var statearr_34479 = state_34477;
(statearr_34479[(7)] = inst_34461);

return statearr_34479;
})();
if(inst_34463){
var statearr_34480_34491 = state_34477__$1;
(statearr_34480_34491[(1)] = (3));

} else {
var statearr_34481_34492 = state_34477__$1;
(statearr_34481_34492[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34478 === (3))){
var inst_34465 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_34466 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34467 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_34468 = cljs.core.PersistentHashMap.fromArrays(inst_34466,inst_34467);
var inst_34469 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34465,inst_34468);
var inst_34470 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_34469);
var inst_34471 = fluree.db.util.xhttp.close_websocket(ws);
var state_34477__$1 = (function (){var statearr_34482 = state_34477;
(statearr_34482[(8)] = inst_34470);

return statearr_34482;
})();
var statearr_34483_34493 = state_34477__$1;
(statearr_34483_34493[(2)] = inst_34471);

(statearr_34483_34493[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34478 === (4))){
var inst_34473 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_34477__$1 = state_34477;
var statearr_34484_34494 = state_34477__$1;
(statearr_34484_34494[(2)] = inst_34473);

(statearr_34484_34494[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34478 === (5))){
var inst_34475 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34477__$1,inst_34475);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto____0 = (function (){
var statearr_34485 = [null,null,null,null,null,null,null,null,null];
(statearr_34485[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto__);

(statearr_34485[(1)] = (1));

return statearr_34485;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto____1 = (function (state_34477){
while(true){
var ret_value__15855__auto__ = (function (){try{while(true){
var result__15856__auto__ = switch__15853__auto__(state_34477);
if(cljs.core.keyword_identical_QMARK_(result__15856__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15856__auto__;
}
break;
}
}catch (e34486){var ex__15857__auto__ = e34486;
var statearr_34487_34495 = state_34477;
(statearr_34487_34495[(2)] = ex__15857__auto__);


if(cljs.core.seq((state_34477[(4)]))){
var statearr_34488_34496 = state_34477;
(statearr_34488_34496[(1)] = cljs.core.first((state_34477[(4)])));

} else {
throw ex__15857__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15855__auto__,cljs.core.cst$kw$recur)){
var G__34497 = state_34477;
state_34477 = G__34497;
continue;
} else {
return ret_value__15855__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto__ = function(state_34477){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto____1.call(this,state_34477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__15854__auto__;
})()
})();
var state__15893__auto__ = (function (){var statearr_34489 = (f__15892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15892__auto__.cljs$core$IFn$_invoke$arity$0() : f__15892__auto__.call(null));
(statearr_34489[(6)] = c__15891__auto___34490);

return statearr_34489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15893__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
