// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__28210 = arguments.length;
switch (G__28210) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keyword_DASH_fn,fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__28211 = options;
var map__28211__$1 = cljs.core.__destructure_map(map__28211);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28211__$1,cljs.core.cst$kw$keyword_DASH_fn);
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__28238_28259 = cljs.core.seq(x__$1);
var chunk__28239_28260 = null;
var count__28240_28261 = (0);
var i__28241_28262 = (0);
while(true){
if((i__28241_28262 < count__28240_28261)){
var vec__28248_28263 = chunk__28239_28260.cljs$core$IIndexed$_nth$arity$2(null,i__28241_28262);
var k_28264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28248_28263,(0),null);
var v_28265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28248_28263,(1),null);
goog.object.set(m,keyfn(k_28264),fluree$db$util$json$thisfn(v_28265));


var G__28266 = seq__28238_28259;
var G__28267 = chunk__28239_28260;
var G__28268 = count__28240_28261;
var G__28269 = (i__28241_28262 + (1));
seq__28238_28259 = G__28266;
chunk__28239_28260 = G__28267;
count__28240_28261 = G__28268;
i__28241_28262 = G__28269;
continue;
} else {
var temp__5753__auto___28270 = cljs.core.seq(seq__28238_28259);
if(temp__5753__auto___28270){
var seq__28238_28271__$1 = temp__5753__auto___28270;
if(cljs.core.chunked_seq_QMARK_(seq__28238_28271__$1)){
var c__4649__auto___28272 = cljs.core.chunk_first(seq__28238_28271__$1);
var G__28273 = cljs.core.chunk_rest(seq__28238_28271__$1);
var G__28274 = c__4649__auto___28272;
var G__28275 = cljs.core.count(c__4649__auto___28272);
var G__28276 = (0);
seq__28238_28259 = G__28273;
chunk__28239_28260 = G__28274;
count__28240_28261 = G__28275;
i__28241_28262 = G__28276;
continue;
} else {
var vec__28251_28277 = cljs.core.first(seq__28238_28271__$1);
var k_28278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28251_28277,(0),null);
var v_28279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28251_28277,(1),null);
goog.object.set(m,keyfn(k_28278),fluree$db$util$json$thisfn(v_28279));


var G__28280 = cljs.core.next(seq__28238_28271__$1);
var G__28281 = null;
var G__28282 = (0);
var G__28283 = (0);
seq__28238_28259 = G__28280;
chunk__28239_28260 = G__28281;
count__28240_28261 = G__28282;
i__28241_28262 = G__28283;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__28254_28284 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__28255_28285 = null;
var count__28256_28286 = (0);
var i__28257_28287 = (0);
while(true){
if((i__28257_28287 < count__28256_28286)){
var x_28288__$2 = chunk__28255_28285.cljs$core$IIndexed$_nth$arity$2(null,i__28257_28287);
arr.push(x_28288__$2);


var G__28289 = seq__28254_28284;
var G__28290 = chunk__28255_28285;
var G__28291 = count__28256_28286;
var G__28292 = (i__28257_28287 + (1));
seq__28254_28284 = G__28289;
chunk__28255_28285 = G__28290;
count__28256_28286 = G__28291;
i__28257_28287 = G__28292;
continue;
} else {
var temp__5753__auto___28293 = cljs.core.seq(seq__28254_28284);
if(temp__5753__auto___28293){
var seq__28254_28294__$1 = temp__5753__auto___28293;
if(cljs.core.chunked_seq_QMARK_(seq__28254_28294__$1)){
var c__4649__auto___28295 = cljs.core.chunk_first(seq__28254_28294__$1);
var G__28296 = cljs.core.chunk_rest(seq__28254_28294__$1);
var G__28297 = c__4649__auto___28295;
var G__28298 = cljs.core.count(c__4649__auto___28295);
var G__28299 = (0);
seq__28254_28284 = G__28296;
chunk__28255_28285 = G__28297;
count__28256_28286 = G__28298;
i__28257_28287 = G__28299;
continue;
} else {
var x_28300__$2 = cljs.core.first(seq__28254_28294__$1);
arr.push(x_28300__$2);


var G__28301 = cljs.core.next(seq__28254_28294__$1);
var G__28302 = null;
var G__28303 = (0);
var G__28304 = (0);
seq__28254_28284 = G__28301;
chunk__28255_28285 = G__28302;
count__28256_28286 = G__28303;
i__28257_28287 = G__28304;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn(x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__28305_SHARP_){
var G__28306 = (depth - (1));
var G__28307 = p1__28305_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__28306,G__28307) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__28306,G__28307));
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__28308 = cljs.core.get_global_hierarchy;
return (fexpr__28308.cljs$core$IFn$_invoke$arity$0 ? fexpr__28308.cljs$core$IFn$_invoke$arity$0() : fexpr__28308.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),cljs.core.cst$kw$type,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__4221__auto__ = (function (){var or__4223__auto__ = (function (){var G__28309 = cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__28309) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__28309));
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4221__auto__)){
return ((cljs.core.map_QMARK_(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry))) || ((cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4221__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__28310_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__28310_SHARP_);
}),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (geometry){
return false;
}));
