// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4223__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__15891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15892__auto__ = (function (){var switch__15853__auto__ = (function (state_25891){
var state_val_25892 = (state_25891[(1)]);
if((state_val_25892 === (7))){
var inst_25886 = (state_25891[(2)]);
var _ = (function (){var statearr_25893 = state_25891;
(statearr_25893[(4)] = cljs.core.rest((state_25891[(4)])));

return statearr_25893;
})();
var state_25891__$1 = state_25891;
var statearr_25894_25916 = state_25891__$1;
(statearr_25894_25916[(2)] = inst_25886);

(statearr_25894_25916[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25892 === (1))){
var state_25891__$1 = state_25891;
var statearr_25895_25917 = state_25891__$1;
(statearr_25895_25917[(2)] = null);

(statearr_25895_25917[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25892 === (4))){
var inst_25848 = (state_25891[(2)]);
var state_25891__$1 = state_25891;
var statearr_25896_25918 = state_25891__$1;
(statearr_25896_25918[(2)] = inst_25848);

(statearr_25896_25918[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25892 === (6))){
var inst_25866 = (state_25891[(7)]);
var inst_25873 = (state_25891[(8)]);
var inst_25872 = cljs.core.seq(inst_25866);
var inst_25873__$1 = cljs.core.first(inst_25872);
var inst_25874 = cljs.core.next(inst_25872);
var inst_25875 = cljs.core.not(inst_25873__$1);
var state_25891__$1 = (function (){var statearr_25897 = state_25891;
(statearr_25897[(9)] = inst_25874);

(statearr_25897[(8)] = inst_25873__$1);

return statearr_25897;
})();
if(inst_25875){
var statearr_25898_25919 = state_25891__$1;
(statearr_25898_25919[(1)] = (8));

} else {
var statearr_25899_25920 = state_25891__$1;
(statearr_25899_25920[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25892 === (3))){
var inst_25889 = (state_25891[(2)]);
var state_25891__$1 = state_25891;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25891__$1,inst_25889);
} else {
if((state_val_25892 === (2))){
var _ = (function (){var statearr_25900 = state_25891;
(statearr_25900[(4)] = cljs.core.cons((5),(state_25891[(4)])));

return statearr_25900;
})();
var inst_25861 = chs;
var inst_25862 = cljs.core.seq(inst_25861);
var inst_25863 = cljs.core.first(inst_25862);
var inst_25864 = cljs.core.next(inst_25862);
var inst_25865 = coll;
var inst_25866 = inst_25861;
var inst_25867 = inst_25865;
var state_25891__$1 = (function (){var statearr_25901 = state_25891;
(statearr_25901[(10)] = inst_25867);

(statearr_25901[(7)] = inst_25866);

(statearr_25901[(11)] = inst_25863);

(statearr_25901[(12)] = inst_25864);

return statearr_25901;
})();
var statearr_25902_25921 = state_25891__$1;
(statearr_25902_25921[(2)] = null);

(statearr_25902_25921[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25892 === (11))){
var inst_25874 = (state_25891[(9)]);
var inst_25867 = (state_25891[(10)]);
var inst_25879 = (state_25891[(2)]);
var inst_25880 = fluree.db.util.async.throw_err(inst_25879);
var inst_25881 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25867,inst_25880);
var inst_25866 = inst_25874;
var inst_25867__$1 = inst_25881;
var state_25891__$1 = (function (){var statearr_25904 = state_25891;
(statearr_25904[(10)] = inst_25867__$1);

(statearr_25904[(7)] = inst_25866);

return statearr_25904;
})();
var statearr_25905_25922 = state_25891__$1;
(statearr_25905_25922[(2)] = null);

(statearr_25905_25922[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25892 === (9))){
var inst_25873 = (state_25891[(8)]);
var state_25891__$1 = state_25891;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25891__$1,(11),inst_25873);
} else {
if((state_val_25892 === (5))){
var _ = (function (){var statearr_25906 = state_25891;
(statearr_25906[(4)] = cljs.core.rest((state_25891[(4)])));

return statearr_25906;
})();
var state_25891__$1 = state_25891;
var ex25903 = (state_25891__$1[(2)]);
var statearr_25907_25923 = state_25891__$1;
(statearr_25907_25923[(5)] = ex25903);


var statearr_25908_25924 = state_25891__$1;
(statearr_25908_25924[(1)] = (4));

(statearr_25908_25924[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_25892 === (10))){
var inst_25884 = (state_25891[(2)]);
var state_25891__$1 = state_25891;
var statearr_25909_25925 = state_25891__$1;
(statearr_25909_25925[(2)] = inst_25884);

(statearr_25909_25925[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25892 === (8))){
var inst_25867 = (state_25891[(10)]);
var state_25891__$1 = state_25891;
var statearr_25910_25926 = state_25891__$1;
(statearr_25910_25926[(2)] = inst_25867);

(statearr_25910_25926[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto____0 = (function (){
var statearr_25911 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25911[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto__);

(statearr_25911[(1)] = (1));

return statearr_25911;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto____1 = (function (state_25891){
while(true){
var ret_value__15855__auto__ = (function (){try{while(true){
var result__15856__auto__ = switch__15853__auto__(state_25891);
if(cljs.core.keyword_identical_QMARK_(result__15856__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15856__auto__;
}
break;
}
}catch (e25912){var ex__15857__auto__ = e25912;
var statearr_25913_25927 = state_25891;
(statearr_25913_25927[(2)] = ex__15857__auto__);


if(cljs.core.seq((state_25891[(4)]))){
var statearr_25914_25928 = state_25891;
(statearr_25914_25928[(1)] = cljs.core.first((state_25891[(4)])));

} else {
throw ex__15857__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15855__auto__,cljs.core.cst$kw$recur)){
var G__25929 = state_25891;
state_25891 = G__25929;
continue;
} else {
return ret_value__15855__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto__ = function(state_25891){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto____1.call(this,state_25891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__15854__auto__;
})()
})();
var state__15893__auto__ = (function (){var statearr_25915 = (f__15892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15892__auto__.cljs$core$IFn$_invoke$arity$0() : f__15892__auto__.call(null));
(statearr_25915[(6)] = c__15891__auto__);

return statearr_25915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15893__auto__);
}));

return c__15891__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__15891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15892__auto__ = (function (){var switch__15853__auto__ = (function (state_25955){
var state_val_25956 = (state_25955[(1)]);
if((state_val_25956 === (7))){
var inst_25950 = (state_25955[(2)]);
var _ = (function (){var statearr_25957 = state_25955;
(statearr_25957[(4)] = cljs.core.rest((state_25955[(4)])));

return statearr_25957;
})();
var state_25955__$1 = state_25955;
var statearr_25958_25980 = state_25955__$1;
(statearr_25958_25980[(2)] = inst_25950);

(statearr_25958_25980[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25956 === (1))){
var state_25955__$1 = state_25955;
var statearr_25959_25981 = state_25955__$1;
(statearr_25959_25981[(2)] = null);

(statearr_25959_25981[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25956 === (4))){
var inst_25930 = (state_25955[(2)]);
var state_25955__$1 = state_25955;
var statearr_25960_25982 = state_25955__$1;
(statearr_25960_25982[(2)] = inst_25930);

(statearr_25960_25982[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25956 === (6))){
var state_25955__$1 = state_25955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25955__$1,(8),chan);
} else {
if((state_val_25956 === (3))){
var inst_25953 = (state_25955[(2)]);
var state_25955__$1 = state_25955;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25955__$1,inst_25953);
} else {
if((state_val_25956 === (2))){
var _ = (function (){var statearr_25961 = state_25955;
(statearr_25961[(4)] = cljs.core.cons((5),(state_25955[(4)])));

return statearr_25961;
})();
var inst_25936 = coll;
var inst_25937 = inst_25936;
var state_25955__$1 = (function (){var statearr_25962 = state_25955;
(statearr_25962[(7)] = inst_25937);

return statearr_25962;
})();
var statearr_25963_25983 = state_25955__$1;
(statearr_25963_25983[(2)] = null);

(statearr_25963_25983[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25956 === (11))){
var inst_25948 = (state_25955[(2)]);
var state_25955__$1 = state_25955;
var statearr_25965_25984 = state_25955__$1;
(statearr_25965_25984[(2)] = inst_25948);

(statearr_25965_25984[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25956 === (9))){
var inst_25937 = (state_25955[(7)]);
var state_25955__$1 = state_25955;
var statearr_25966_25985 = state_25955__$1;
(statearr_25966_25985[(2)] = inst_25937);

(statearr_25966_25985[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25956 === (5))){
var _ = (function (){var statearr_25967 = state_25955;
(statearr_25967[(4)] = cljs.core.rest((state_25955[(4)])));

return statearr_25967;
})();
var state_25955__$1 = state_25955;
var ex25964 = (state_25955__$1[(2)]);
var statearr_25968_25986 = state_25955__$1;
(statearr_25968_25986[(5)] = ex25964);


var statearr_25969_25987 = state_25955__$1;
(statearr_25969_25987[(1)] = (4));

(statearr_25969_25987[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_25956 === (10))){
var inst_25941 = (state_25955[(8)]);
var inst_25937 = (state_25955[(7)]);
var inst_25945 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25937,inst_25941);
var inst_25937__$1 = inst_25945;
var state_25955__$1 = (function (){var statearr_25970 = state_25955;
(statearr_25970[(7)] = inst_25937__$1);

return statearr_25970;
})();
var statearr_25971_25988 = state_25955__$1;
(statearr_25971_25988[(2)] = null);

(statearr_25971_25988[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25956 === (8))){
var inst_25941 = (state_25955[(8)]);
var inst_25940 = (state_25955[(2)]);
var inst_25941__$1 = fluree.db.util.async.throw_err(inst_25940);
var inst_25942 = (inst_25941__$1 == null);
var state_25955__$1 = (function (){var statearr_25972 = state_25955;
(statearr_25972[(8)] = inst_25941__$1);

return statearr_25972;
})();
if(cljs.core.truth_(inst_25942)){
var statearr_25973_25989 = state_25955__$1;
(statearr_25973_25989[(1)] = (9));

} else {
var statearr_25974_25990 = state_25955__$1;
(statearr_25974_25990[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__15854__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__15854__auto____0 = (function (){
var statearr_25975 = [null,null,null,null,null,null,null,null,null];
(statearr_25975[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__15854__auto__);

(statearr_25975[(1)] = (1));

return statearr_25975;
});
var fluree$db$util$async$into_QMARK__$_state_machine__15854__auto____1 = (function (state_25955){
while(true){
var ret_value__15855__auto__ = (function (){try{while(true){
var result__15856__auto__ = switch__15853__auto__(state_25955);
if(cljs.core.keyword_identical_QMARK_(result__15856__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15856__auto__;
}
break;
}
}catch (e25976){var ex__15857__auto__ = e25976;
var statearr_25977_25991 = state_25955;
(statearr_25977_25991[(2)] = ex__15857__auto__);


if(cljs.core.seq((state_25955[(4)]))){
var statearr_25978_25992 = state_25955;
(statearr_25978_25992[(1)] = cljs.core.first((state_25955[(4)])));

} else {
throw ex__15857__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15855__auto__,cljs.core.cst$kw$recur)){
var G__25993 = state_25955;
state_25955 = G__25993;
continue;
} else {
return ret_value__15855__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__15854__auto__ = function(state_25955){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__15854__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__15854__auto____1.call(this,state_25955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__15854__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__15854__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__15854__auto__;
})()
})();
var state__15893__auto__ = (function (){var statearr_25979 = (f__15892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15892__auto__.cljs$core$IFn$_invoke$arity$0() : f__15892__auto__.call(null));
(statearr_25979[(6)] = c__15891__auto__);

return statearr_25979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15893__auto__);
}));

return c__15891__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
