// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k36579,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__36583 = k36579;
var G__36583__$1 = (((G__36583 instanceof cljs.core.Keyword))?G__36583.fqn:null);
switch (G__36583__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k36579,else__4475__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__36584){
var vec__36585 = p__36584;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36585,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36585,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36578){
var self__ = this;
var G__36578__$1 = this;
return (new cljs.core.RecordIter((0),G__36578__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__36588 = (function (coll__4469__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__36588(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this36580,other36581){
var self__ = this;
var this36580__$1 = this;
return (((!((other36581 == null)))) && ((((this36580__$1.constructor === other36581.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.conn,other36581.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.network,other36581.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.dbid,other36581.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.db_name,other36581.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.update_chan,other36581.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.transact_chan,other36581.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.state,other36581.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.schema_cache,other36581.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.blank_db,other36581.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.close,other36581.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.id,other36581.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36580__$1.__extmap,other36581.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k36579){
var self__ = this;
var this__4479__auto____$1 = this;
var G__36589 = k36579;
var G__36589__$1 = (((G__36589 instanceof cljs.core.Keyword))?G__36589.fqn:null);
switch (G__36589__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k36579);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__36578){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__36590 = cljs.core.keyword_identical_QMARK_;
var expr__36591 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__36593 = cljs.core.cst$kw$conn;
var G__36594 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36593,G__36594) : pred__36590.call(null,G__36593,G__36594));
})())){
return (new fluree.db.session.DbSession(G__36578,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36595 = cljs.core.cst$kw$network;
var G__36596 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36595,G__36596) : pred__36590.call(null,G__36595,G__36596));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__36578,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36597 = cljs.core.cst$kw$dbid;
var G__36598 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36597,G__36598) : pred__36590.call(null,G__36597,G__36598));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__36578,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36599 = cljs.core.cst$kw$db_DASH_name;
var G__36600 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36599,G__36600) : pred__36590.call(null,G__36599,G__36600));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__36578,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36601 = cljs.core.cst$kw$update_DASH_chan;
var G__36602 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36601,G__36602) : pred__36590.call(null,G__36601,G__36602));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__36578,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36603 = cljs.core.cst$kw$transact_DASH_chan;
var G__36604 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36603,G__36604) : pred__36590.call(null,G__36603,G__36604));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__36578,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36605 = cljs.core.cst$kw$state;
var G__36606 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36605,G__36606) : pred__36590.call(null,G__36605,G__36606));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__36578,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36607 = cljs.core.cst$kw$schema_DASH_cache;
var G__36608 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36607,G__36608) : pred__36590.call(null,G__36607,G__36608));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__36578,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36609 = cljs.core.cst$kw$blank_DASH_db;
var G__36610 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36609,G__36610) : pred__36590.call(null,G__36609,G__36610));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__36578,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36611 = cljs.core.cst$kw$close;
var G__36612 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36611,G__36612) : pred__36590.call(null,G__36611,G__36612));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__36578,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36613 = cljs.core.cst$kw$id;
var G__36614 = expr__36591;
return (pred__36590.cljs$core$IFn$_invoke$arity$2 ? pred__36590.cljs$core$IFn$_invoke$arity$2(G__36613,G__36614) : pred__36590.call(null,G__36613,G__36614));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__36578,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__36578),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__36578){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__36578,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__36582){
var extmap__4512__auto__ = (function (){var G__36615 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__36582,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__36582)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__36615);
} else {
return G__36615;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__36582),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__36582),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__36618 = session;
var map__36618__$1 = cljs.core.__destructure_map(map__36618);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36618__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36618__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10835__auto___36770 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36722){
var state_val_36723 = (state_36722[(1)]);
if((state_val_36723 === (7))){
var inst_36639 = (state_36722[(7)]);
var inst_36644 = cljs.core.empty_QMARK_(inst_36639);
var state_36722__$1 = state_36722;
if(inst_36644){
var statearr_36724_36771 = state_36722__$1;
(statearr_36724_36771[(1)] = (10));

} else {
var statearr_36725_36772 = state_36722__$1;
(statearr_36725_36772[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (20))){
var inst_36632 = (state_36722[(8)]);
var inst_36631 = (state_36722[(9)]);
var inst_36630 = (state_36722[(10)]);
var inst_36670 = (state_36722[(11)]);
var inst_36675 = fluree.db.storage.core.read_block(inst_36630,inst_36631,inst_36632,inst_36670);
var state_36722__$1 = state_36722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36722__$1,(22),inst_36675);
} else {
if((state_val_36723 === (27))){
var inst_36706 = (state_36722[(12)]);
var inst_36711 = (state_36722[(13)]);
var inst_36709 = (state_36722[(2)]);
var inst_36710 = fluree.db.util.async.throw_err(inst_36709);
var inst_36711__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36706,cljs.core.cst$kw$schema,inst_36710);
var inst_36712 = fluree.db.query.schema.setting_map(inst_36711__$1);
var state_36722__$1 = (function (){var statearr_36726 = state_36722;
(statearr_36726[(13)] = inst_36711__$1);

return statearr_36726;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36722__$1,(28),inst_36712);
} else {
if((state_val_36723 === (1))){
var state_36722__$1 = state_36722;
var statearr_36727_36773 = state_36722__$1;
(statearr_36727_36773[(2)] = null);

(statearr_36727_36773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (24))){
var inst_36632 = (state_36722[(8)]);
var inst_36631 = (state_36722[(9)]);
var inst_36670 = (state_36722[(11)]);
var inst_36692 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36670)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36631),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36632),"."].join('');
var inst_36693 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36694 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_36695 = cljs.core.PersistentHashMap.fromArrays(inst_36693,inst_36694);
var inst_36696 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36692,inst_36695);
var inst_36697 = (function(){throw inst_36696})();
var state_36722__$1 = state_36722;
var statearr_36728_36774 = state_36722__$1;
(statearr_36728_36774[(2)] = inst_36697);

(statearr_36728_36774[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (4))){
var inst_36619 = (state_36722[(2)]);
var inst_36620 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_36619);
var state_36722__$1 = state_36722;
var statearr_36729_36775 = state_36722__$1;
(statearr_36729_36775[(2)] = inst_36620);

(statearr_36729_36775[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (15))){
var state_36722__$1 = state_36722;
var statearr_36730_36776 = state_36722__$1;
(statearr_36730_36776[(2)] = null);

(statearr_36730_36776[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (21))){
var inst_36701 = (state_36722[(2)]);
var state_36722__$1 = state_36722;
var statearr_36731_36777 = state_36722__$1;
(statearr_36731_36777[(2)] = inst_36701);

(statearr_36731_36777[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (13))){
var inst_36639 = (state_36722[(7)]);
var inst_36664 = (state_36722[(14)]);
var inst_36663 = (state_36722[(2)]);
var inst_36664__$1 = fluree.db.util.async.throw_err(inst_36663);
var inst_36665 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_36639);
var state_36722__$1 = (function (){var statearr_36732 = state_36722;
(statearr_36732[(14)] = inst_36664__$1);

(statearr_36732[(15)] = inst_36665);

return statearr_36732;
})();
if(cljs.core.truth_(inst_36664__$1)){
var statearr_36733_36778 = state_36722__$1;
(statearr_36733_36778[(1)] = (14));

} else {
var statearr_36734_36779 = state_36722__$1;
(statearr_36734_36779[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (22))){
var inst_36678 = (state_36722[(16)]);
var inst_36677 = (state_36722[(2)]);
var inst_36678__$1 = fluree.db.util.async.throw_err(inst_36677);
var state_36722__$1 = (function (){var statearr_36735 = state_36722;
(statearr_36735[(16)] = inst_36678__$1);

return statearr_36735;
})();
if(cljs.core.truth_(inst_36678__$1)){
var statearr_36736_36780 = state_36722__$1;
(statearr_36736_36780[(1)] = (23));

} else {
var statearr_36737_36781 = state_36722__$1;
(statearr_36737_36781[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (6))){
var inst_36639 = (state_36722[(7)]);
var inst_36638 = (state_36722[(2)]);
var inst_36639__$1 = fluree.db.util.async.throw_err(inst_36638);
var inst_36640 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_36639__$1);
var inst_36641 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_36640);
var inst_36642 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_36641);
var state_36722__$1 = (function (){var statearr_36738 = state_36722;
(statearr_36738[(7)] = inst_36639__$1);

return statearr_36738;
})();
if(inst_36642){
var statearr_36739_36782 = state_36722__$1;
(statearr_36739_36782[(1)] = (7));

} else {
var statearr_36740_36783 = state_36722__$1;
(statearr_36740_36783[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (28))){
var inst_36711 = (state_36722[(13)]);
var inst_36714 = (state_36722[(2)]);
var inst_36715 = fluree.db.util.async.throw_err(inst_36714);
var inst_36716 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36711,cljs.core.cst$kw$settings,inst_36715);
var inst_36717 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_36716);
var _ = (function (){var statearr_36741 = state_36722;
(statearr_36741[(4)] = cljs.core.rest((state_36722[(4)])));

return statearr_36741;
})();
var state_36722__$1 = state_36722;
var statearr_36742_36784 = state_36722__$1;
(statearr_36742_36784[(2)] = inst_36717);

(statearr_36742_36784[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (25))){
var inst_36699 = (state_36722[(2)]);
var state_36722__$1 = state_36722;
var statearr_36743_36785 = state_36722__$1;
(statearr_36743_36785[(2)] = inst_36699);

(statearr_36743_36785[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (17))){
var inst_36665 = (state_36722[(15)]);
var inst_36670 = (state_36722[(11)]);
var inst_36672 = (inst_36670 > inst_36665);
var state_36722__$1 = state_36722;
if(cljs.core.truth_(inst_36672)){
var statearr_36744_36786 = state_36722__$1;
(statearr_36744_36786[(1)] = (19));

} else {
var statearr_36745_36787 = state_36722__$1;
(statearr_36745_36787[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (3))){
var inst_36720 = (state_36722[(2)]);
var state_36722__$1 = state_36722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36722__$1,inst_36720);
} else {
if((state_val_36723 === (12))){
var inst_36651 = (state_36722[(2)]);
var inst_36652 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36653 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_36654 = cljs.core.PersistentHashMap.fromArrays(inst_36652,inst_36653);
var inst_36655 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36651,inst_36654);
var inst_36656 = (function(){throw inst_36655})();
var state_36722__$1 = state_36722;
var statearr_36746_36788 = state_36722__$1;
(statearr_36746_36788[(2)] = inst_36656);

(statearr_36746_36788[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (2))){
var inst_36632 = (state_36722[(8)]);
var inst_36631 = (state_36722[(9)]);
var inst_36630 = (state_36722[(10)]);
var _ = (function (){var statearr_36747 = state_36722;
(statearr_36747[(4)] = cljs.core.cons((5),(state_36722[(4)])));

return statearr_36747;
})();
var inst_36627 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_36628 = session;
var inst_36629 = cljs.core.__destructure_map(inst_36628);
var inst_36630__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36629,cljs.core.cst$kw$conn);
var inst_36631__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36629,cljs.core.cst$kw$network);
var inst_36632__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36629,cljs.core.cst$kw$dbid);
var inst_36633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36634 = [inst_36631__$1,inst_36632__$1];
var inst_36635 = (new cljs.core.PersistentVector(null,2,(5),inst_36633,inst_36634,null));
var inst_36636 = fluree.db.operations.ledger_info_async(inst_36630__$1,inst_36635);
var state_36722__$1 = (function (){var statearr_36748 = state_36722;
(statearr_36748[(8)] = inst_36632__$1);

(statearr_36748[(9)] = inst_36631__$1);

(statearr_36748[(10)] = inst_36630__$1);

(statearr_36748[(17)] = inst_36627);

return statearr_36748;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36722__$1,(6),inst_36636);
} else {
if((state_val_36723 === (23))){
var inst_36669 = (state_36722[(18)]);
var inst_36678 = (state_36722[(16)]);
var inst_36681 = cljs.core.__destructure_map(inst_36678);
var inst_36682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36681,cljs.core.cst$kw$flakes);
var inst_36683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36681,cljs.core.cst$kw$block);
var inst_36684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36681,cljs.core.cst$kw$t);
var inst_36685 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_36669,inst_36683,inst_36682);
var state_36722__$1 = (function (){var statearr_36749 = state_36722;
(statearr_36749[(19)] = inst_36684);

return statearr_36749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36722__$1,(26),inst_36685);
} else {
if((state_val_36723 === (19))){
var inst_36669 = (state_36722[(18)]);
var state_36722__$1 = state_36722;
var statearr_36750_36789 = state_36722__$1;
(statearr_36750_36789[(2)] = inst_36669);

(statearr_36750_36789[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (11))){
var inst_36639 = (state_36722[(7)]);
var inst_36632 = (state_36722[(8)]);
var inst_36631 = (state_36722[(9)]);
var inst_36648 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_36639);
var inst_36649 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36631),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36632)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36648),"."].join('');
var state_36722__$1 = state_36722;
var statearr_36752_36790 = state_36722__$1;
(statearr_36752_36790[(2)] = inst_36649);

(statearr_36752_36790[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (9))){
var inst_36639 = (state_36722[(7)]);
var inst_36632 = (state_36722[(8)]);
var inst_36631 = (state_36722[(9)]);
var inst_36630 = (state_36722[(10)]);
var inst_36627 = (state_36722[(17)]);
var inst_36659 = (state_36722[(2)]);
var inst_36660 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_36639);
var inst_36661 = fluree.db.storage.core.reify_db(inst_36630,inst_36631,inst_36632,inst_36627,inst_36660);
var state_36722__$1 = (function (){var statearr_36753 = state_36722;
(statearr_36753[(20)] = inst_36659);

return statearr_36753;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36722__$1,(13),inst_36661);
} else {
if((state_val_36723 === (5))){
var _ = (function (){var statearr_36754 = state_36722;
(statearr_36754[(4)] = cljs.core.rest((state_36722[(4)])));

return statearr_36754;
})();
var state_36722__$1 = state_36722;
var ex36751 = (state_36722__$1[(2)]);
var statearr_36755_36791 = state_36722__$1;
(statearr_36755_36791[(5)] = ex36751);


var statearr_36756_36792 = state_36722__$1;
(statearr_36756_36792[(1)] = (4));

(statearr_36756_36792[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (14))){
var inst_36664 = (state_36722[(14)]);
var inst_36667 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_36664);
var inst_36668 = (inst_36667 + (1));
var inst_36669 = inst_36664;
var inst_36670 = inst_36668;
var state_36722__$1 = (function (){var statearr_36757 = state_36722;
(statearr_36757[(18)] = inst_36669);

(statearr_36757[(11)] = inst_36670);

return statearr_36757;
})();
var statearr_36758_36793 = state_36722__$1;
(statearr_36758_36793[(2)] = null);

(statearr_36758_36793[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (26))){
var inst_36670 = (state_36722[(11)]);
var inst_36687 = (state_36722[(2)]);
var inst_36688 = fluree.db.util.async.throw_err(inst_36687);
var inst_36689 = (inst_36670 + (1));
var inst_36669 = inst_36688;
var inst_36670__$1 = inst_36689;
var state_36722__$1 = (function (){var statearr_36759 = state_36722;
(statearr_36759[(18)] = inst_36669);

(statearr_36759[(11)] = inst_36670__$1);

return statearr_36759;
})();
var statearr_36760_36794 = state_36722__$1;
(statearr_36760_36794[(2)] = null);

(statearr_36760_36794[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (16))){
var inst_36706 = (state_36722[(12)]);
var inst_36706__$1 = (state_36722[(2)]);
var inst_36707 = fluree.db.query.schema.schema_map(inst_36706__$1);
var state_36722__$1 = (function (){var statearr_36761 = state_36722;
(statearr_36761[(12)] = inst_36706__$1);

return statearr_36761;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36722__$1,(27),inst_36707);
} else {
if((state_val_36723 === (10))){
var inst_36632 = (state_36722[(8)]);
var inst_36631 = (state_36722[(9)]);
var inst_36646 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36631),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36632)," is not found on this ledger group."].join('');
var state_36722__$1 = state_36722;
var statearr_36762_36795 = state_36722__$1;
(statearr_36762_36795[(2)] = inst_36646);

(statearr_36762_36795[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (18))){
var inst_36703 = (state_36722[(2)]);
var state_36722__$1 = state_36722;
var statearr_36763_36796 = state_36722__$1;
(statearr_36763_36796[(2)] = inst_36703);

(statearr_36763_36796[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36723 === (8))){
var state_36722__$1 = state_36722;
var statearr_36764_36797 = state_36722__$1;
(statearr_36764_36797[(2)] = null);

(statearr_36764_36797[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__10798__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__10798__auto____0 = (function (){
var statearr_36765 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36765[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__10798__auto__);

(statearr_36765[(1)] = (1));

return statearr_36765;
});
var fluree$db$session$full_load_existing_db_$_state_machine__10798__auto____1 = (function (state_36722){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36722);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36766){var ex__10801__auto__ = e36766;
var statearr_36767_36798 = state_36722;
(statearr_36767_36798[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36722[(4)]))){
var statearr_36768_36799 = state_36722;
(statearr_36768_36799[(1)] = cljs.core.first((state_36722[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36800 = state_36722;
state_36722 = G__36800;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__10798__auto__ = function(state_36722){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__10798__auto____1.call(this,state_36722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__10798__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__10798__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36769 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36769[(6)] = c__10835__auto___36770);

return statearr_36769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__36801 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__36801,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__36801;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__36802 = cljs.core.get_global_hierarchy;
return (fexpr__36802.cljs$core$IFn$_invoke$arity$0 ? fexpr__36802.cljs$core$IFn$_invoke$arity$0() : fexpr__36802.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36804){
var state_val_36805 = (state_36804[(1)]);
if((state_val_36805 === (1))){
var state_36804__$1 = state_36804;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36804__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10798__auto__ = null;
var fluree$db$session$state_machine__10798__auto____0 = (function (){
var statearr_36806 = [null,null,null,null,null,null,null];
(statearr_36806[(0)] = fluree$db$session$state_machine__10798__auto__);

(statearr_36806[(1)] = (1));

return statearr_36806;
});
var fluree$db$session$state_machine__10798__auto____1 = (function (state_36804){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36804);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36807){var ex__10801__auto__ = e36807;
var statearr_36808_36811 = state_36804;
(statearr_36808_36811[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36804[(4)]))){
var statearr_36809_36812 = state_36804;
(statearr_36809_36812[(1)] = cljs.core.first((state_36804[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36813 = state_36804;
state_36804 = G__36813;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$session$state_machine__10798__auto__ = function(state_36804){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10798__auto____1.call(this,state_36804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10798__auto____0;
fluree$db$session$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10798__auto____1;
return fluree$db$session$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36810 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36810[(6)] = c__10835__auto__);

return statearr_36810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__36815){
var map__36816 = p__36815;
var map__36816__$1 = cljs.core.__destructure_map(map__36816);
var data = map__36816__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36816__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36816__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36816__$1,cljs.core.cst$kw$flakes);
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36875){
var state_val_36876 = (state_36875[(1)]);
if((state_val_36876 === (7))){
var inst_36830 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_36831 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_36832 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36830),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36831),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_36833 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36832], 0));
var state_36875__$1 = state_36875;
var statearr_36877_36915 = state_36875__$1;
(statearr_36877_36915[(2)] = inst_36833);

(statearr_36877_36915[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (1))){
var state_36875__$1 = state_36875;
var statearr_36878_36916 = state_36875__$1;
(statearr_36878_36916[(2)] = null);

(statearr_36878_36916[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (4))){
var inst_36817 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
var statearr_36879_36917 = state_36875__$1;
(statearr_36879_36917[(2)] = inst_36817);

(statearr_36879_36917[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (15))){
var inst_36856 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
var statearr_36880_36918 = state_36875__$1;
(statearr_36880_36918[(2)] = inst_36856);

(statearr_36880_36918[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (13))){
var inst_36847 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_36848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36849 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_36850 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_36851 = [inst_36849,inst_36850];
var inst_36852 = (new cljs.core.PersistentVector(null,2,(5),inst_36848,inst_36851,null));
var inst_36853 = (function (){var G__36881 = inst_36847;
var G__36882 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__36883 = inst_36852;
var G__36884 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__36881,G__36882,G__36883,G__36884) : fluree.db.conn_events.process_event.call(null,G__36881,G__36882,G__36883,G__36884));
})();
var state_36875__$1 = state_36875;
var statearr_36885_36919 = state_36875__$1;
(statearr_36885_36919[(2)] = inst_36853);

(statearr_36885_36919[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (6))){
var inst_36827 = (state_36875[(7)]);
var inst_36826 = (state_36875[(8)]);
var inst_36825 = (state_36875[(2)]);
var inst_36826__$1 = fluree.db.util.async.throw_err(inst_36825);
var inst_36827__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_36826__$1);
var inst_36828 = (block <= inst_36827__$1);
var state_36875__$1 = (function (){var statearr_36886 = state_36875;
(statearr_36886[(7)] = inst_36827__$1);

(statearr_36886[(8)] = inst_36826__$1);

return statearr_36886;
})();
if(cljs.core.truth_(inst_36828)){
var statearr_36887_36920 = state_36875__$1;
(statearr_36887_36920[(1)] = (7));

} else {
var statearr_36888_36921 = state_36875__$1;
(statearr_36888_36921[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (17))){
var state_36875__$1 = state_36875;
var statearr_36889_36922 = state_36875__$1;
(statearr_36889_36922[(2)] = null);

(statearr_36889_36922[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (3))){
var inst_36873 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36875__$1,inst_36873);
} else {
if((state_val_36876 === (12))){
var inst_36868 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
var statearr_36890_36923 = state_36875__$1;
(statearr_36890_36923[(2)] = inst_36868);

(statearr_36890_36923[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (2))){
var inst_36823 = (state_36875[(9)]);
var _ = (function (){var statearr_36891 = state_36875;
(statearr_36891[(4)] = cljs.core.cons((5),(state_36875[(4)])));

return statearr_36891;
})();
var inst_36823__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_36875__$1 = (function (){var statearr_36892 = state_36875;
(statearr_36892[(9)] = inst_36823__$1);

return statearr_36892;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36875__$1,(6),inst_36823__$1);
} else {
if((state_val_36876 === (11))){
var state_36875__$1 = state_36875;
var statearr_36894_36924 = state_36875__$1;
(statearr_36894_36924[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (9))){
var inst_36870 = (state_36875[(2)]);
var _ = (function (){var statearr_36896 = state_36875;
(statearr_36896[(4)] = cljs.core.rest((state_36875[(4)])));

return statearr_36896;
})();
var state_36875__$1 = state_36875;
var statearr_36897_36925 = state_36875__$1;
(statearr_36897_36925[(2)] = inst_36870);

(statearr_36897_36925[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (5))){
var _ = (function (){var statearr_36898 = state_36875;
(statearr_36898[(4)] = cljs.core.rest((state_36875[(4)])));

return statearr_36898;
})();
var state_36875__$1 = state_36875;
var ex36893 = (state_36875__$1[(2)]);
var statearr_36899_36926 = state_36875__$1;
(statearr_36899_36926[(5)] = ex36893);


if((ex36893 instanceof Error)){
var statearr_36900_36927 = state_36875__$1;
(statearr_36900_36927[(1)] = (4));

(statearr_36900_36927[(5)] = null);

} else {
throw ex36893;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (14))){
var state_36875__$1 = state_36875;
var statearr_36901_36928 = state_36875__$1;
(statearr_36901_36928[(2)] = null);

(statearr_36901_36928[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (16))){
var inst_36827 = (state_36875[(7)]);
var inst_36859 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_36860 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_36861 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36859),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36860),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36827),". Forcing a db reload."].join('');
var inst_36862 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36861], 0));
var inst_36863 = fluree.db.session.reload_db_BANG_(session);
var state_36875__$1 = (function (){var statearr_36902 = state_36875;
(statearr_36902[(10)] = inst_36862);

return statearr_36902;
})();
var statearr_36903_36929 = state_36875__$1;
(statearr_36903_36929[(2)] = inst_36863);

(statearr_36903_36929[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (10))){
var inst_36827 = (state_36875[(7)]);
var inst_36826 = (state_36875[(8)]);
var inst_36823 = (state_36875[(9)]);
var inst_36838 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_36839 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_36840 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36838),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36839),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_36841 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36840], 0));
var inst_36842 = (function (){var current_db_ch = inst_36823;
var current_db = inst_36826;
var current_block = inst_36827;
return (function (p1__36814_SHARP_){
if((p1__36814_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__36814_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__36814_SHARP_);
}
});
})();
var inst_36843 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36842,flakes);
var inst_36844 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_36826,block,inst_36843);
var inst_36845 = fluree.db.session.cas_db_BANG_(session,inst_36823,inst_36844);
var state_36875__$1 = (function (){var statearr_36904 = state_36875;
(statearr_36904[(11)] = inst_36841);

return statearr_36904;
})();
if(inst_36845){
var statearr_36905_36930 = state_36875__$1;
(statearr_36905_36930[(1)] = (13));

} else {
var statearr_36906_36931 = state_36875__$1;
(statearr_36906_36931[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (18))){
var inst_36866 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
var statearr_36907_36932 = state_36875__$1;
(statearr_36907_36932[(2)] = inst_36866);

(statearr_36907_36932[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (8))){
var inst_36827 = (state_36875[(7)]);
var inst_36835 = ((1) + inst_36827);
var inst_36836 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_36835);
var state_36875__$1 = state_36875;
if(inst_36836){
var statearr_36908_36933 = state_36875__$1;
(statearr_36908_36933[(1)] = (10));

} else {
var statearr_36909_36934 = state_36875__$1;
(statearr_36909_36934[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10798__auto__ = null;
var fluree$db$session$state_machine__10798__auto____0 = (function (){
var statearr_36910 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36910[(0)] = fluree$db$session$state_machine__10798__auto__);

(statearr_36910[(1)] = (1));

return statearr_36910;
});
var fluree$db$session$state_machine__10798__auto____1 = (function (state_36875){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36875);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36911){var ex__10801__auto__ = e36911;
var statearr_36912_36935 = state_36875;
(statearr_36912_36935[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36875[(4)]))){
var statearr_36913_36936 = state_36875;
(statearr_36913_36936[(1)] = cljs.core.first((state_36875[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36937 = state_36875;
state_36875 = G__36937;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$session$state_machine__10798__auto__ = function(state_36875){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10798__auto____1.call(this,state_36875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10798__auto____0;
fluree$db$session$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10798__auto____1;
return fluree$db$session$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36914 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36914[(6)] = c__10835__auto__);

return statearr_36914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36944){
var state_val_36945 = (state_36944[(1)]);
if((state_val_36945 === (1))){
var inst_36938 = fluree.db.session.clear_db_BANG_(session);
var inst_36939 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_36940 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_36941 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36939),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36940)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_36942 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36941], 0));
var state_36944__$1 = (function (){var statearr_36946 = state_36944;
(statearr_36946[(7)] = inst_36938);

(statearr_36946[(8)] = inst_36942);

return statearr_36946;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36944__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10798__auto__ = null;
var fluree$db$session$state_machine__10798__auto____0 = (function (){
var statearr_36947 = [null,null,null,null,null,null,null,null,null];
(statearr_36947[(0)] = fluree$db$session$state_machine__10798__auto__);

(statearr_36947[(1)] = (1));

return statearr_36947;
});
var fluree$db$session$state_machine__10798__auto____1 = (function (state_36944){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36944);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36948){var ex__10801__auto__ = e36948;
var statearr_36949_36952 = state_36944;
(statearr_36949_36952[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36944[(4)]))){
var statearr_36950_36953 = state_36944;
(statearr_36950_36953[(1)] = cljs.core.first((state_36944[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36954 = state_36944;
state_36944 = G__36954;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$session$state_machine__10798__auto__ = function(state_36944){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10798__auto____1.call(this,state_36944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10798__auto____0;
fluree$db$session$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10798__auto____1;
return fluree$db$session$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36951 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36951[(6)] = c__10835__auto__);

return statearr_36951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__36956 = arguments.length;
switch (G__36956) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__36957 = session;
var map__36957__$1 = cljs.core.__destructure_map(map__36957);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36957__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36957__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36957__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36957__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36957__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36957__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36957__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__36958_36961 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__36958_36961.cljs$core$IFn$_invoke$arity$3 ? fexpr__36958_36961.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__36958_36961.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__36959_36962 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__36959_36962.cljs$core$IFn$_invoke$arity$0 ? fexpr__36959_36962.cljs$core$IFn$_invoke$arity$0() : fexpr__36959_36962.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_37015){
var state_val_37016 = (state_37015[(1)]);
if((state_val_37016 === (7))){
var inst_37011 = (state_37015[(2)]);
var state_37015__$1 = state_37015;
var statearr_37017_37048 = state_37015__$1;
(statearr_37017_37048[(2)] = inst_37011);

(statearr_37017_37048[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (1))){
var state_37015__$1 = state_37015;
var statearr_37018_37049 = state_37015__$1;
(statearr_37018_37049[(2)] = null);

(statearr_37018_37049[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (4))){
var inst_36966 = (state_37015[(7)]);
var inst_36965 = (state_37015[(2)]);
var inst_36966__$1 = fluree.db.util.async.throw_err(inst_36965);
var inst_36967 = fluree.db.session.from_cache(network,ledger_id);
var inst_36968 = (inst_36966__$1 == null);
var state_37015__$1 = (function (){var statearr_37019 = state_37015;
(statearr_37019[(7)] = inst_36966__$1);

(statearr_37019[(8)] = inst_36967);

return statearr_37019;
})();
if(cljs.core.truth_(inst_36968)){
var statearr_37020_37050 = state_37015__$1;
(statearr_37020_37050[(1)] = (5));

} else {
var statearr_37021_37051 = state_37015__$1;
(statearr_37021_37051[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (15))){
var inst_37003 = (state_37015[(2)]);
var state_37015__$1 = (function (){var statearr_37022 = state_37015;
(statearr_37022[(9)] = inst_37003);

return statearr_37022;
})();
var statearr_37023_37052 = state_37015__$1;
(statearr_37023_37052[(2)] = null);

(statearr_37023_37052[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (13))){
var inst_37007 = (state_37015[(2)]);
var state_37015__$1 = state_37015;
var statearr_37025_37053 = state_37015__$1;
(statearr_37025_37053[(2)] = inst_37007);

(statearr_37025_37053[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (6))){
var inst_36967 = (state_37015[(8)]);
var inst_36973 = (inst_36967 == null);
var state_37015__$1 = state_37015;
if(cljs.core.truth_(inst_36973)){
var statearr_37026_37054 = state_37015__$1;
(statearr_37026_37054[(1)] = (8));

} else {
var statearr_37027_37055 = state_37015__$1;
(statearr_37027_37055[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (17))){
var _ = (function (){var statearr_37028 = state_37015;
(statearr_37028[(4)] = cljs.core.rest((state_37015[(4)])));

return statearr_37028;
})();
var state_37015__$1 = state_37015;
var ex37024 = (state_37015__$1[(2)]);
var statearr_37029_37056 = state_37015__$1;
(statearr_37029_37056[(5)] = ex37024);


var statearr_37030_37057 = state_37015__$1;
(statearr_37030_37057[(1)] = (16));

(statearr_37030_37057[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (3))){
var inst_37013 = (state_37015[(2)]);
var state_37015__$1 = state_37015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37015__$1,inst_37013);
} else {
if((state_val_37016 === (12))){
var state_37015__$1 = state_37015;
var statearr_37031_37058 = state_37015__$1;
(statearr_37031_37058[(2)] = null);

(statearr_37031_37058[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (2))){
var state_37015__$1 = state_37015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37015__$1,(4),update_chan);
} else {
if((state_val_37016 === (11))){
var state_37015__$1 = state_37015;
var statearr_37032_37059 = state_37015__$1;
(statearr_37032_37059[(2)] = null);

(statearr_37032_37059[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (9))){
var state_37015__$1 = state_37015;
var statearr_37033_37060 = state_37015__$1;
(statearr_37033_37060[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (5))){
var inst_36970 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_36971 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36970], 0));
var state_37015__$1 = state_37015;
var statearr_37035_37061 = state_37015__$1;
(statearr_37035_37061[(2)] = inst_36971);

(statearr_37035_37061[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (14))){
var inst_36966 = (state_37015[(7)]);
var inst_36967 = (state_37015[(8)]);
var _ = (function (){var statearr_37036 = state_37015;
(statearr_37036[(4)] = cljs.core.cons((17),(state_37015[(4)])));

return statearr_37036;
})();
var inst_36991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36966,(0),null);
var inst_36992 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36966,(1),null);
var inst_36993 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_36994 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36966], 0));
var inst_36995 = fluree.db.util.core.trunc(inst_36994,(200));
var inst_36996 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36993,inst_36995], 0));
var inst_36997 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_36967,inst_36991,inst_36992) : fluree.db.session.process_ledger_update.call(null,inst_36967,inst_36991,inst_36992));
var state_37015__$1 = (function (){var statearr_37037 = state_37015;
(statearr_37037[(10)] = inst_36996);

return statearr_37037;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37015__$1,(18),inst_36997);
} else {
if((state_val_37016 === (16))){
var inst_36966 = (state_37015[(7)]);
var inst_36981 = (state_37015[(2)]);
var inst_36982 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36981,"Exception processing ledger updates for message: ",inst_36966], 0));
var state_37015__$1 = state_37015;
var statearr_37038_37062 = state_37015__$1;
(statearr_37038_37062[(2)] = inst_36982);

(statearr_37038_37062[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (10))){
var inst_37009 = (state_37015[(2)]);
var state_37015__$1 = state_37015;
var statearr_37039_37063 = state_37015__$1;
(statearr_37039_37063[(2)] = inst_37009);

(statearr_37039_37063[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (18))){
var inst_36999 = (state_37015[(2)]);
var inst_37000 = fluree.db.util.async.throw_err(inst_36999);
var _ = (function (){var statearr_37040 = state_37015;
(statearr_37040[(4)] = cljs.core.rest((state_37015[(4)])));

return statearr_37040;
})();
var state_37015__$1 = state_37015;
var statearr_37041_37064 = state_37015__$1;
(statearr_37041_37064[(2)] = inst_37000);

(statearr_37041_37064[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37016 === (8))){
var inst_36966 = (state_37015[(7)]);
var inst_36975 = cljs.core.first(inst_36966);
var inst_36976 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36975], 0));
var inst_36977 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_36976].join('');
var inst_36978 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36977], 0));
var state_37015__$1 = state_37015;
var statearr_37042_37065 = state_37015__$1;
(statearr_37042_37065[(2)] = inst_36978);

(statearr_37042_37065[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__10798__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__10798__auto____0 = (function (){
var statearr_37043 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37043[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__10798__auto__);

(statearr_37043[(1)] = (1));

return statearr_37043;
});
var fluree$db$session$process_ledger_updates_$_state_machine__10798__auto____1 = (function (state_37015){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_37015);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e37044){var ex__10801__auto__ = e37044;
var statearr_37045_37066 = state_37015;
(statearr_37045_37066[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_37015[(4)]))){
var statearr_37046_37067 = state_37015;
(statearr_37046_37067[(1)] = cljs.core.first((state_37015[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__37068 = state_37015;
state_37015 = G__37068;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__10798__auto__ = function(state_37015){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__10798__auto____1.call(this,state_37015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__10798__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__10798__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_37047 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_37047[(6)] = c__10835__auto__);

return statearr_37047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__37069){
var map__37070 = p__37069;
var map__37070__$1 = cljs.core.__destructure_map(map__37070);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37070__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37070__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37070__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37070__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37070__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37070__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37070__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37070__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37070__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__37074 = block_result;
var map__37074__$1 = cljs.core.__destructure_map(map__37074);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37074__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37074__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37074__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37074__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37074__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__37075 = tx_result;
var map__37075__$1 = cljs.core.__destructure_map(map__37075);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37075__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37075__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__37071_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__37071_SHARP_.t);
}):(function (p1__37072_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__37072_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__37073_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__37073_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__37073_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__37076 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37076,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37076,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37076,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37076,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__37080 = arguments.length;
switch (G__37080) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__37081){
var map__37082 = p__37081;
var map__37082__$1 = cljs.core.__destructure_map(map__37082);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37082__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37082__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37082__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37082__$1,cljs.core.cst$kw$jwt);
var vec__37083 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37083,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37083,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37083,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4223__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4223__auto____$1 = state;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__37087_37207 = network;
var G__37088_37208 = ledger_id;
var G__37089_37209 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__37090_37210 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__37091 = cljs.core.seq(tids);
var chunk__37092 = null;
var count__37093 = (0);
var i__37094 = (0);
while(true){
if((i__37094 < count__37093)){
var tid = chunk__37092.cljs$core$IIndexed$_nth$arity$2(null,i__37094);
var temp__5753__auto___37212__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___37212__$1)){
var keyed_callbacks_37213 = temp__5753__auto___37212__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_37214 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__37135_37215 = cljs.core.seq(keyed_callbacks_37213);
var chunk__37136_37216 = null;
var count__37137_37217 = (0);
var i__37138_37218 = (0);
while(true){
if((i__37138_37218 < count__37137_37217)){
var vec__37147_37219 = chunk__37136_37216.cljs$core$IIndexed$_nth$arity$2(null,i__37138_37218);
var k_37220 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37147_37219,(0),null);
var f_37221 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37147_37219,(1),null);
try{(f_37221.cljs$core$IFn$_invoke$arity$1 ? f_37221.cljs$core$IFn$_invoke$arity$1(tx_response_37214) : f_37221.call(null,tx_response_37214));
}catch (e37150){var e_37222 = e37150;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_37222,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__37223 = seq__37135_37215;
var G__37224 = chunk__37136_37216;
var G__37225 = count__37137_37217;
var G__37226 = (i__37138_37218 + (1));
seq__37135_37215 = G__37223;
chunk__37136_37216 = G__37224;
count__37137_37217 = G__37225;
i__37138_37218 = G__37226;
continue;
} else {
var temp__5753__auto___37227__$2 = cljs.core.seq(seq__37135_37215);
if(temp__5753__auto___37227__$2){
var seq__37135_37228__$1 = temp__5753__auto___37227__$2;
if(cljs.core.chunked_seq_QMARK_(seq__37135_37228__$1)){
var c__4649__auto___37229 = cljs.core.chunk_first(seq__37135_37228__$1);
var G__37230 = cljs.core.chunk_rest(seq__37135_37228__$1);
var G__37231 = c__4649__auto___37229;
var G__37232 = cljs.core.count(c__4649__auto___37229);
var G__37233 = (0);
seq__37135_37215 = G__37230;
chunk__37136_37216 = G__37231;
count__37137_37217 = G__37232;
i__37138_37218 = G__37233;
continue;
} else {
var vec__37151_37234 = cljs.core.first(seq__37135_37228__$1);
var k_37235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37151_37234,(0),null);
var f_37236 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37151_37234,(1),null);
try{(f_37236.cljs$core$IFn$_invoke$arity$1 ? f_37236.cljs$core$IFn$_invoke$arity$1(tx_response_37214) : f_37236.call(null,tx_response_37214));
}catch (e37154){var e_37237 = e37154;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_37237,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__37238 = cljs.core.next(seq__37135_37228__$1);
var G__37239 = null;
var G__37240 = (0);
var G__37241 = (0);
seq__37135_37215 = G__37238;
chunk__37136_37216 = G__37239;
count__37137_37217 = G__37240;
i__37138_37218 = G__37241;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__37242 = seq__37091;
var G__37243 = chunk__37092;
var G__37244 = count__37093;
var G__37245 = (i__37094 + (1));
seq__37091 = G__37242;
chunk__37092 = G__37243;
count__37093 = G__37244;
i__37094 = G__37245;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__37091);
if(temp__5753__auto____$1){
var seq__37091__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__37091__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__37091__$1);
var G__37246 = cljs.core.chunk_rest(seq__37091__$1);
var G__37247 = c__4649__auto__;
var G__37248 = cljs.core.count(c__4649__auto__);
var G__37249 = (0);
seq__37091 = G__37246;
chunk__37092 = G__37247;
count__37093 = G__37248;
i__37094 = G__37249;
continue;
} else {
var tid = cljs.core.first(seq__37091__$1);
var temp__5753__auto___37250__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___37250__$2)){
var keyed_callbacks_37251 = temp__5753__auto___37250__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_37252 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__37155_37253 = cljs.core.seq(keyed_callbacks_37251);
var chunk__37156_37254 = null;
var count__37157_37255 = (0);
var i__37158_37256 = (0);
while(true){
if((i__37158_37256 < count__37157_37255)){
var vec__37167_37257 = chunk__37156_37254.cljs$core$IIndexed$_nth$arity$2(null,i__37158_37256);
var k_37258 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37167_37257,(0),null);
var f_37259 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37167_37257,(1),null);
try{(f_37259.cljs$core$IFn$_invoke$arity$1 ? f_37259.cljs$core$IFn$_invoke$arity$1(tx_response_37252) : f_37259.call(null,tx_response_37252));
}catch (e37170){var e_37260 = e37170;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_37260,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__37261 = seq__37155_37253;
var G__37262 = chunk__37156_37254;
var G__37263 = count__37157_37255;
var G__37264 = (i__37158_37256 + (1));
seq__37155_37253 = G__37261;
chunk__37156_37254 = G__37262;
count__37157_37255 = G__37263;
i__37158_37256 = G__37264;
continue;
} else {
var temp__5753__auto___37265__$3 = cljs.core.seq(seq__37155_37253);
if(temp__5753__auto___37265__$3){
var seq__37155_37266__$1 = temp__5753__auto___37265__$3;
if(cljs.core.chunked_seq_QMARK_(seq__37155_37266__$1)){
var c__4649__auto___37267 = cljs.core.chunk_first(seq__37155_37266__$1);
var G__37268 = cljs.core.chunk_rest(seq__37155_37266__$1);
var G__37269 = c__4649__auto___37267;
var G__37270 = cljs.core.count(c__4649__auto___37267);
var G__37271 = (0);
seq__37155_37253 = G__37268;
chunk__37156_37254 = G__37269;
count__37157_37255 = G__37270;
i__37158_37256 = G__37271;
continue;
} else {
var vec__37171_37272 = cljs.core.first(seq__37155_37266__$1);
var k_37273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37171_37272,(0),null);
var f_37274 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37171_37272,(1),null);
try{(f_37274.cljs$core$IFn$_invoke$arity$1 ? f_37274.cljs$core$IFn$_invoke$arity$1(tx_response_37252) : f_37274.call(null,tx_response_37252));
}catch (e37174){var e_37275 = e37174;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_37275,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__37276 = cljs.core.next(seq__37155_37266__$1);
var G__37277 = null;
var G__37278 = (0);
var G__37279 = (0);
seq__37155_37253 = G__37276;
chunk__37156_37254 = G__37277;
count__37157_37255 = G__37278;
i__37158_37256 = G__37279;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__37280 = cljs.core.next(seq__37091__$1);
var G__37281 = null;
var G__37282 = (0);
var G__37283 = (0);
seq__37091 = G__37280;
chunk__37092 = G__37281;
count__37093 = G__37282;
i__37094 = G__37283;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__37086_37211 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__37086_37211.cljs$core$IFn$_invoke$arity$4 ? fexpr__37086_37211.cljs$core$IFn$_invoke$arity$4(G__37087_37207,G__37088_37208,G__37089_37209,G__37090_37210) : fexpr__37086_37211.call(null,G__37087_37207,G__37088_37208,G__37089_37209,G__37090_37210));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_37284 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__10835__auto___37285 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_37191){
var state_val_37192 = (state_37191[(1)]);
if((state_val_37192 === (1))){
var state_37191__$1 = state_37191;
var statearr_37193_37286 = state_37191__$1;
(statearr_37193_37286[(2)] = null);

(statearr_37193_37286[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37192 === (2))){
var inst_37176 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_37191__$1 = state_37191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37191__$1,(4),inst_37176);
} else {
if((state_val_37192 === (3))){
var inst_37189 = (state_37191[(2)]);
var state_37191__$1 = state_37191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37191__$1,inst_37189);
} else {
if((state_val_37192 === (4))){
var inst_37178 = (state_37191[(7)]);
var inst_37178__$1 = (state_37191[(2)]);
var inst_37179 = (inst_37178__$1 == null);
var state_37191__$1 = (function (){var statearr_37194 = state_37191;
(statearr_37194[(7)] = inst_37178__$1);

return statearr_37194;
})();
if(cljs.core.truth_(inst_37179)){
var statearr_37195_37287 = state_37191__$1;
(statearr_37195_37287[(1)] = (5));

} else {
var statearr_37196_37288 = state_37191__$1;
(statearr_37196_37288[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37192 === (5))){
var inst_37181 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_37182 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37181], 0));
var state_37191__$1 = state_37191;
var statearr_37197_37289 = state_37191__$1;
(statearr_37197_37289[(2)] = inst_37182);

(statearr_37197_37289[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37192 === (6))){
var inst_37178 = (state_37191[(7)]);
var inst_37184 = (transact_handler_37284.cljs$core$IFn$_invoke$arity$2 ? transact_handler_37284.cljs$core$IFn$_invoke$arity$2(conn,inst_37178) : transact_handler_37284.call(null,conn,inst_37178));
var state_37191__$1 = (function (){var statearr_37198 = state_37191;
(statearr_37198[(8)] = inst_37184);

return statearr_37198;
})();
var statearr_37199_37290 = state_37191__$1;
(statearr_37199_37290[(2)] = null);

(statearr_37199_37290[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37192 === (7))){
var inst_37187 = (state_37191[(2)]);
var state_37191__$1 = state_37191;
var statearr_37200_37291 = state_37191__$1;
(statearr_37200_37291[(2)] = inst_37187);

(statearr_37200_37291[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10798__auto__ = null;
var fluree$db$session$state_machine__10798__auto____0 = (function (){
var statearr_37201 = [null,null,null,null,null,null,null,null,null];
(statearr_37201[(0)] = fluree$db$session$state_machine__10798__auto__);

(statearr_37201[(1)] = (1));

return statearr_37201;
});
var fluree$db$session$state_machine__10798__auto____1 = (function (state_37191){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_37191);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e37202){var ex__10801__auto__ = e37202;
var statearr_37203_37292 = state_37191;
(statearr_37203_37292[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_37191[(4)]))){
var statearr_37204_37293 = state_37191;
(statearr_37204_37293[(1)] = cljs.core.first((state_37191[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__37294 = state_37191;
state_37191 = G__37294;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$session$state_machine__10798__auto__ = function(state_37191){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10798__auto____1.call(this,state_37191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10798__auto____0;
fluree$db$session$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10798__auto____1;
return fluree$db$session$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_37205 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_37205[(6)] = c__10835__auto___37285);

return statearr_37205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__37295_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__37295_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__37295_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__37296_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__37296_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__37299 = arguments.length;
switch (G__37299) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__37300 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__37297_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__37297_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__37300);
} else {
return G__37300;
}
})();
var seq__37301 = cljs.core.seq(sessions);
var chunk__37302 = null;
var count__37303 = (0);
var i__37304 = (0);
while(true){
if((i__37304 < count__37303)){
var session = chunk__37302.cljs$core$IIndexed$_nth$arity$2(null,i__37304);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__37306 = seq__37301;
var G__37307 = chunk__37302;
var G__37308 = count__37303;
var G__37309 = (i__37304 + (1));
seq__37301 = G__37306;
chunk__37302 = G__37307;
count__37303 = G__37308;
i__37304 = G__37309;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__37301);
if(temp__5753__auto__){
var seq__37301__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__37301__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__37301__$1);
var G__37310 = cljs.core.chunk_rest(seq__37301__$1);
var G__37311 = c__4649__auto__;
var G__37312 = cljs.core.count(c__4649__auto__);
var G__37313 = (0);
seq__37301 = G__37310;
chunk__37302 = G__37311;
count__37303 = G__37312;
i__37304 = G__37313;
continue;
} else {
var session = cljs.core.first(seq__37301__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__37314 = cljs.core.next(seq__37301__$1);
var G__37315 = null;
var G__37316 = (0);
var G__37317 = (0);
seq__37301 = G__37314;
chunk__37302 = G__37315;
count__37303 = G__37316;
i__37304 = G__37317;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
