// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__23137 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23137,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23137,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23137,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23137,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23137,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23137,(5),null);
var G__23140 = idx;
var G__23140__$1 = (((G__23140 instanceof cljs.core.Keyword))?G__23140.fqn:null);
switch (G__23140__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23140__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__23142 = idx;
var G__23142__$1 = (((G__23142 instanceof cljs.core.Keyword))?G__23142.fqn:null);
switch (G__23142__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23142__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__23144 = idx;
var G__23144__$1 = (((G__23144 instanceof cljs.core.Keyword))?G__23144.fqn:null);
switch (G__23144__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23144__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__23147 = arguments.length;
switch (G__23147) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__23148 = (function (){var pred__23151 = cljs.core.identical_QMARK_;
var expr__23152 = test;
if(cljs.core.truth_((pred__23151.cljs$core$IFn$_invoke$arity$2 ? pred__23151.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__23152) : pred__23151.call(null,cljs.core._EQ_,expr__23152)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__23151.cljs$core$IFn$_invoke$arity$2 ? pred__23151.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__23152) : pred__23151.call(null,cljs.core._LT_,expr__23152)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__23151.cljs$core$IFn$_invoke$arity$2 ? pred__23151.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__23152) : pred__23151.call(null,cljs.core._LT__EQ_,expr__23152)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__23151.cljs$core$IFn$_invoke$arity$2 ? pred__23151.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__23152) : pred__23151.call(null,cljs.core._GT_,expr__23152)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__23151.cljs$core$IFn$_invoke$arity$2 ? pred__23151.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__23152) : pred__23151.call(null,cljs.core._GT__EQ_,expr__23152)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__23152)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23148,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23148,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23148,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23148,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_23391){
var state_val_23392 = (state_23391[(1)]);
if((state_val_23392 === (65))){
var inst_23306 = (state_23391[(7)]);
var inst_23362 = (state_23391[(8)]);
var inst_23362__$1 = (state_23391[(2)]);
var inst_23363 = cljs.core.count(inst_23362__$1);
var state_23391__$1 = (function (){var statearr_23393 = state_23391;
(statearr_23393[(9)] = inst_23363);

(statearr_23393[(8)] = inst_23362__$1);

return statearr_23393;
})();
if(cljs.core.truth_(inst_23306)){
var statearr_23394_23531 = state_23391__$1;
(statearr_23394_23531[(1)] = (81));

} else {
var statearr_23395_23532 = state_23391__$1;
(statearr_23395_23532[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (70))){
var inst_23337 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
if(cljs.core.truth_(inst_23337)){
var statearr_23396_23533 = state_23391__$1;
(statearr_23396_23533[(1)] = (71));

} else {
var statearr_23397_23534 = state_23391__$1;
(statearr_23397_23534[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (62))){
var inst_23276 = (state_23391[(10)]);
var inst_23290 = (state_23391[(11)]);
var inst_23305 = (state_23391[(2)]);
var inst_23306 = fluree.db.dbproto._rhs(inst_23290);
var state_23391__$1 = (function (){var statearr_23398 = state_23391;
(statearr_23398[(7)] = inst_23306);

(statearr_23398[(12)] = inst_23305);

return statearr_23398;
})();
if(cljs.core.truth_(inst_23276)){
var statearr_23399_23535 = state_23391__$1;
(statearr_23399_23535[(1)] = (63));

} else {
var statearr_23400_23536 = state_23391__$1;
(statearr_23400_23536[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (74))){
var inst_23330 = (state_23391[(13)]);
var inst_23344 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_23330);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23391__$1,(77),inst_23344);
} else {
if((state_val_23392 === (7))){
var inst_23167 = (state_23391[(14)]);
var state_23391__$1 = state_23391;
var statearr_23401_23537 = state_23391__$1;
(statearr_23401_23537[(2)] = inst_23167);

(statearr_23401_23537[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (59))){
var inst_23252 = (state_23391[(15)]);
var inst_23297 = (state_23391[(16)]);
var inst_23253 = (state_23391[(17)]);
var inst_23296 = (state_23391[(2)]);
var inst_23297__$1 = fluree.db.util.async.throw_err(inst_23296);
var inst_23298 = fluree.db.flake.subrange(inst_23297__$1,start_test,inst_23252,end_test,inst_23253);
var inst_23299 = fluree.db.query.range.value_with_nil_pred(idx,inst_23252,inst_23253);
var state_23391__$1 = (function (){var statearr_23402 = state_23391;
(statearr_23402[(18)] = inst_23298);

(statearr_23402[(16)] = inst_23297__$1);

return statearr_23402;
})();
if(inst_23299){
var statearr_23403_23538 = state_23391__$1;
(statearr_23403_23538[(1)] = (60));

} else {
var statearr_23404_23539 = state_23391__$1;
(statearr_23404_23539[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (86))){
var inst_23371 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
var statearr_23405_23540 = state_23391__$1;
(statearr_23405_23540[(2)] = inst_23371);

(statearr_23405_23540[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (20))){
var inst_23216 = (state_23391[(19)]);
var inst_23168 = (state_23391[(20)]);
var inst_23215 = (state_23391[(2)]);
var inst_23216__$1 = (inst_23168 == null);
var state_23391__$1 = (function (){var statearr_23406 = state_23391;
(statearr_23406[(19)] = inst_23216__$1);

(statearr_23406[(21)] = inst_23215);

return statearr_23406;
})();
if(cljs.core.truth_(inst_23216__$1)){
var statearr_23407_23541 = state_23391__$1;
(statearr_23407_23541[(1)] = (22));

} else {
var statearr_23408_23542 = state_23391__$1;
(statearr_23408_23542[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (72))){
var inst_23323 = (state_23391[(22)]);
var inst_23341 = (inst_23323 + (1));
var inst_23342 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_23391__$1 = (function (){var statearr_23409 = state_23391;
(statearr_23409[(23)] = inst_23341);

return statearr_23409;
})();
if(cljs.core.truth_(inst_23342)){
var statearr_23410_23543 = state_23391__$1;
(statearr_23410_23543[(1)] = (74));

} else {
var statearr_23411_23544 = state_23391__$1;
(statearr_23411_23544[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (58))){
var inst_23386 = (state_23391[(2)]);
var _ = (function (){var statearr_23412 = state_23391;
(statearr_23412[(4)] = cljs.core.rest((state_23391[(4)])));

return statearr_23412;
})();
var state_23391__$1 = state_23391;
var statearr_23413_23545 = state_23391__$1;
(statearr_23413_23545[(2)] = inst_23386);

(statearr_23413_23545[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (60))){
var inst_23298 = (state_23391[(18)]);
var inst_23224 = (state_23391[(24)]);
var inst_23263 = (state_23391[(25)]);
var inst_23177 = (state_23391[(26)]);
var inst_23292 = (state_23391[(27)]);
var inst_23197 = (state_23391[(28)]);
var inst_23285 = (state_23391[(29)]);
var inst_23171 = (state_23391[(30)]);
var inst_23270 = (state_23391[(31)]);
var inst_23258 = (state_23391[(32)]);
var inst_23259 = (state_23391[(33)]);
var inst_23269 = (state_23391[(34)]);
var inst_23252 = (state_23391[(15)]);
var inst_23297 = (state_23391[(16)]);
var inst_23178 = (state_23391[(35)]);
var inst_23291 = (state_23391[(36)]);
var inst_23276 = (state_23391[(10)]);
var inst_23166 = (state_23391[(37)]);
var inst_23173 = (state_23391[(38)]);
var inst_23290 = (state_23391[(11)]);
var inst_23215 = (state_23391[(21)]);
var inst_23280 = (state_23391[(39)]);
var inst_23170 = (state_23391[(40)]);
var inst_23206 = (state_23391[(41)]);
var inst_23253 = (state_23391[(17)]);
var inst_23251 = (state_23391[(42)]);
var inst_23233 = (state_23391[(43)]);
var inst_23242 = (state_23391[(44)]);
var inst_23188 = (state_23391[(45)]);
var inst_23301 = (function (){var no_filter_QMARK_ = inst_23276;
var next_node = inst_23290;
var flakes = inst_23297;
var s1 = inst_23188;
var o2 = inst_23215;
var t1 = inst_23170;
var i = inst_23291;
var m1 = inst_23242;
var root_node = inst_23285;
var to_t = inst_23270;
var s2 = inst_23197;
var vec__23163 = inst_23173;
var p2 = inst_23233;
var permissions = inst_23259;
var limit = inst_23258;
var start_flake = inst_23252;
var acc = inst_23292;
var t2 = inst_23177;
var op1 = inst_23171;
var o1 = inst_23206;
var end_flake = inst_23253;
var base_result = inst_23298;
var p1 = inst_23224;
var vec__23160 = inst_23166;
var idx_compare = inst_23263;
var op2 = inst_23178;
var from_t = inst_23269;
var m2 = inst_23251;
var novelty = inst_23280;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_23302 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23301,inst_23298,inst_23298);
var state_23391__$1 = state_23391;
var statearr_23414_23546 = state_23391__$1;
(statearr_23414_23546[(2)] = inst_23302);

(statearr_23414_23546[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (27))){
var inst_23225 = (state_23391[(46)]);
var inst_23175 = (state_23391[(47)]);
var inst_23224 = (state_23391[(2)]);
var inst_23225__$1 = (inst_23175 == null);
var state_23391__$1 = (function (){var statearr_23415 = state_23391;
(statearr_23415[(24)] = inst_23224);

(statearr_23415[(46)] = inst_23225__$1);

return statearr_23415;
})();
if(cljs.core.truth_(inst_23225__$1)){
var statearr_23416_23547 = state_23391__$1;
(statearr_23416_23547[(1)] = (28));

} else {
var statearr_23417_23548 = state_23391__$1;
(statearr_23417_23548[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (1))){
var state_23391__$1 = state_23391;
var statearr_23418_23549 = state_23391__$1;
(statearr_23418_23549[(2)] = null);

(statearr_23418_23549[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (69))){
var inst_23258 = (state_23391[(32)]);
var inst_23323 = (state_23391[(22)]);
var inst_23335 = (inst_23323 > inst_23258);
var state_23391__$1 = state_23391;
var statearr_23419_23550 = state_23391__$1;
(statearr_23419_23550[(2)] = inst_23335);

(statearr_23419_23550[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (24))){
var inst_23220 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
if(cljs.core.truth_(inst_23220)){
var statearr_23420_23551 = state_23391__$1;
(statearr_23420_23551[(1)] = (25));

} else {
var statearr_23421_23552 = state_23391__$1;
(statearr_23421_23552[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (55))){
var inst_23285 = (state_23391[(29)]);
var inst_23252 = (state_23391[(15)]);
var inst_23284 = (state_23391[(2)]);
var inst_23285__$1 = fluree.db.util.async.throw_err(inst_23284);
var inst_23286 = fluree.db.dbproto._lookup_leaf(inst_23285__$1,inst_23252);
var state_23391__$1 = (function (){var statearr_23422 = state_23391;
(statearr_23422[(29)] = inst_23285__$1);

return statearr_23422;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23391__$1,(56),inst_23286);
} else {
if((state_val_23392 === (85))){
var inst_23366 = (state_23391[(48)]);
var state_23391__$1 = state_23391;
var statearr_23423_23553 = state_23391__$1;
(statearr_23423_23553[(2)] = inst_23366);

(statearr_23423_23553[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (39))){
var inst_23240 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
var statearr_23424_23554 = state_23391__$1;
(statearr_23424_23554[(2)] = inst_23240);

(statearr_23424_23554[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (88))){
var inst_23285 = (state_23391[(29)]);
var inst_23306 = (state_23391[(7)]);
var inst_23378 = fluree.db.dbproto._lookup_leaf(inst_23285,inst_23306);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23391__$1,(90),inst_23378);
} else {
if((state_val_23392 === (46))){
var inst_23254 = (state_23391[(49)]);
var state_23391__$1 = state_23391;
var statearr_23425_23555 = state_23391__$1;
(statearr_23425_23555[(2)] = inst_23254);

(statearr_23425_23555[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (4))){
var inst_23154 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
var statearr_23426_23556 = state_23391__$1;
(statearr_23426_23556[(2)] = inst_23154);

(statearr_23426_23556[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (77))){
var inst_23346 = (state_23391[(2)]);
var inst_23347 = fluree.db.util.async.throw_err(inst_23346);
var state_23391__$1 = state_23391;
if(cljs.core.truth_(inst_23347)){
var statearr_23427_23557 = state_23391__$1;
(statearr_23427_23557[(1)] = (78));

} else {
var statearr_23428_23558 = state_23391__$1;
(statearr_23428_23558[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (54))){
var inst_23276 = (state_23391[(2)]);
var inst_23277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23278 = [cljs.core.cst$kw$novelty,idx];
var inst_23279 = (new cljs.core.PersistentVector(null,2,(5),inst_23277,inst_23278,null));
var inst_23280 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_23279);
var inst_23281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_23282 = fluree.db.dbproto._resolve(inst_23281);
var state_23391__$1 = (function (){var statearr_23429 = state_23391;
(statearr_23429[(10)] = inst_23276);

(statearr_23429[(39)] = inst_23280);

return statearr_23429;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23391__$1,(55),inst_23282);
} else {
if((state_val_23392 === (15))){
var inst_23169 = (state_23391[(50)]);
var state_23391__$1 = state_23391;
var statearr_23430_23559 = state_23391__$1;
(statearr_23430_23559[(2)] = inst_23169);

(statearr_23430_23559[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (48))){
var inst_23264 = (state_23391[(51)]);
var inst_23258 = (state_23391[(2)]);
var inst_23259 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_23260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23261 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_23262 = (new cljs.core.PersistentVector(null,3,(5),inst_23260,inst_23261,null));
var inst_23263 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_23262);
var inst_23264__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_23391__$1 = (function (){var statearr_23431 = state_23391;
(statearr_23431[(25)] = inst_23263);

(statearr_23431[(32)] = inst_23258);

(statearr_23431[(33)] = inst_23259);

(statearr_23431[(51)] = inst_23264__$1);

return statearr_23431;
})();
if(cljs.core.truth_(inst_23264__$1)){
var statearr_23432_23560 = state_23391__$1;
(statearr_23432_23560[(1)] = (49));

} else {
var statearr_23433_23561 = state_23391__$1;
(statearr_23433_23561[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (50))){
var inst_23267 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_23391__$1 = state_23391;
var statearr_23434_23562 = state_23391__$1;
(statearr_23434_23562[(2)] = inst_23267);

(statearr_23434_23562[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (75))){
var inst_23324 = (state_23391[(52)]);
var state_23391__$1 = state_23391;
var statearr_23435_23563 = state_23391__$1;
(statearr_23435_23563[(2)] = inst_23324);

(statearr_23435_23563[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (21))){
var inst_23211 = (state_23391[(2)]);
var inst_23212 = fluree.db.util.async.throw_err(inst_23211);
var state_23391__$1 = state_23391;
var statearr_23436_23564 = state_23391__$1;
(statearr_23436_23564[(2)] = inst_23212);

(statearr_23436_23564[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (31))){
var state_23391__$1 = state_23391;
var statearr_23437_23565 = state_23391__$1;
(statearr_23437_23565[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_23437_23565[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (32))){
var inst_23175 = (state_23391[(47)]);
var state_23391__$1 = state_23391;
var statearr_23438_23566 = state_23391__$1;
(statearr_23438_23566[(2)] = inst_23175);

(statearr_23438_23566[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (40))){
var inst_23179 = (state_23391[(53)]);
var state_23391__$1 = state_23391;
var statearr_23439_23567 = state_23391__$1;
(statearr_23439_23567[(2)] = inst_23179);

(statearr_23439_23567[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (56))){
var inst_23288 = (state_23391[(2)]);
var inst_23289 = fluree.db.util.async.throw_err(inst_23288);
var inst_23290 = inst_23289;
var inst_23291 = (0);
var inst_23292 = null;
var state_23391__$1 = (function (){var statearr_23440 = state_23391;
(statearr_23440[(27)] = inst_23292);

(statearr_23440[(36)] = inst_23291);

(statearr_23440[(11)] = inst_23290);

return statearr_23440;
})();
var statearr_23441_23568 = state_23391__$1;
(statearr_23441_23568[(2)] = null);

(statearr_23441_23568[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (33))){
var inst_23172 = (state_23391[(54)]);
var inst_23233 = (state_23391[(2)]);
var state_23391__$1 = (function (){var statearr_23442 = state_23391;
(statearr_23442[(43)] = inst_23233);

return statearr_23442;
})();
if(cljs.core.truth_(inst_23172)){
var statearr_23443_23569 = state_23391__$1;
(statearr_23443_23569[(1)] = (34));

} else {
var statearr_23444_23570 = state_23391__$1;
(statearr_23444_23570[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (13))){
var inst_23193 = (state_23391[(2)]);
var inst_23194 = fluree.db.util.async.throw_err(inst_23193);
var state_23391__$1 = state_23391;
var statearr_23445_23571 = state_23391__$1;
(statearr_23445_23571[(2)] = inst_23194);

(statearr_23445_23571[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (22))){
var inst_23206 = (state_23391[(41)]);
var state_23391__$1 = state_23391;
var statearr_23446_23572 = state_23391__$1;
(statearr_23446_23572[(2)] = inst_23206);

(statearr_23446_23572[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (90))){
var inst_23363 = (state_23391[(9)]);
var inst_23362 = (state_23391[(8)]);
var inst_23380 = (state_23391[(2)]);
var inst_23381 = fluree.db.util.async.throw_err(inst_23380);
var inst_23290 = inst_23381;
var inst_23291 = inst_23363;
var inst_23292 = inst_23362;
var state_23391__$1 = (function (){var statearr_23447 = state_23391;
(statearr_23447[(27)] = inst_23292);

(statearr_23447[(36)] = inst_23291);

(statearr_23447[(11)] = inst_23290);

return statearr_23447;
})();
var statearr_23448_23573 = state_23391__$1;
(statearr_23448_23573[(2)] = null);

(statearr_23448_23573[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (36))){
var inst_23179 = (state_23391[(53)]);
var inst_23242 = (state_23391[(2)]);
var state_23391__$1 = (function (){var statearr_23449 = state_23391;
(statearr_23449[(44)] = inst_23242);

return statearr_23449;
})();
if(cljs.core.truth_(inst_23179)){
var statearr_23450_23574 = state_23391__$1;
(statearr_23450_23574[(1)] = (40));

} else {
var statearr_23451_23575 = state_23391__$1;
(statearr_23451_23575[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (41))){
var inst_23245 = (cljs.core._LT__EQ_ === end_test);
var state_23391__$1 = state_23391;
if(cljs.core.truth_(inst_23245)){
var statearr_23452_23576 = state_23391__$1;
(statearr_23452_23576[(1)] = (43));

} else {
var statearr_23453_23577 = state_23391__$1;
(statearr_23453_23577[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (89))){
var inst_23384 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
var statearr_23454_23578 = state_23391__$1;
(statearr_23454_23578[(2)] = inst_23384);

(statearr_23454_23578[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (43))){
var state_23391__$1 = state_23391;
var statearr_23455_23579 = state_23391__$1;
(statearr_23455_23579[(2)] = (2147483647));

(statearr_23455_23579[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (61))){
var inst_23298 = (state_23391[(18)]);
var state_23391__$1 = state_23391;
var statearr_23456_23580 = state_23391__$1;
(statearr_23456_23580[(2)] = inst_23298);

(statearr_23456_23580[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (29))){
var inst_23225 = (state_23391[(46)]);
var state_23391__$1 = state_23391;
var statearr_23457_23581 = state_23391__$1;
(statearr_23457_23581[(2)] = inst_23225);

(statearr_23457_23581[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (44))){
var state_23391__$1 = state_23391;
var statearr_23458_23582 = state_23391__$1;
(statearr_23458_23582[(2)] = fluree.db.util.core.min_integer);

(statearr_23458_23582[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (6))){
var inst_23167 = (state_23391[(14)]);
var inst_23182 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23167);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23391__$1,(9),inst_23182);
} else {
if((state_val_23392 === (28))){
var inst_23215 = (state_23391[(21)]);
var state_23391__$1 = state_23391;
var statearr_23459_23583 = state_23391__$1;
(statearr_23459_23583[(2)] = inst_23215);

(statearr_23459_23583[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (64))){
var inst_23291 = (state_23391[(36)]);
var inst_23305 = (state_23391[(12)]);
var inst_23319 = cljs.core.seq(inst_23305);
var inst_23320 = cljs.core.first(inst_23319);
var inst_23321 = cljs.core.next(inst_23319);
var inst_23322 = inst_23305;
var inst_23323 = inst_23291;
var inst_23324 = inst_23305;
var state_23391__$1 = (function (){var statearr_23460 = state_23391;
(statearr_23460[(55)] = inst_23320);

(statearr_23460[(56)] = inst_23322);

(statearr_23460[(57)] = inst_23321);

(statearr_23460[(52)] = inst_23324);

(statearr_23460[(22)] = inst_23323);

return statearr_23460;
})();
var statearr_23461_23584 = state_23391__$1;
(statearr_23461_23584[(2)] = null);

(statearr_23461_23584[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (51))){
var inst_23269 = (state_23391[(2)]);
var inst_23270 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_23271 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_23391__$1 = (function (){var statearr_23462 = state_23391;
(statearr_23462[(31)] = inst_23270);

(statearr_23462[(34)] = inst_23269);

return statearr_23462;
})();
if(cljs.core.truth_(inst_23271)){
var statearr_23463_23585 = state_23391__$1;
(statearr_23463_23585[(1)] = (52));

} else {
var statearr_23464_23586 = state_23391__$1;
(statearr_23464_23586[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (25))){
var state_23391__$1 = state_23391;
var statearr_23465_23587 = state_23391__$1;
(statearr_23465_23587[(2)] = (-1));

(statearr_23465_23587[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (34))){
var inst_23172 = (state_23391[(54)]);
var state_23391__$1 = state_23391;
var statearr_23466_23588 = state_23391__$1;
(statearr_23466_23588[(2)] = inst_23172);

(statearr_23466_23588[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (17))){
var inst_23202 = (state_23391[(2)]);
var inst_23203 = fluree.db.util.async.throw_err(inst_23202);
var state_23391__$1 = state_23391;
var statearr_23467_23589 = state_23391__$1;
(statearr_23467_23589[(2)] = inst_23203);

(statearr_23467_23589[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (3))){
var inst_23389 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23391__$1,inst_23389);
} else {
if((state_val_23392 === (12))){
var inst_23169 = (state_23391[(50)]);
var inst_23197 = (state_23391[(2)]);
var inst_23198 = fluree.db.util.core.pred_ident_QMARK_(inst_23169);
var state_23391__$1 = (function (){var statearr_23468 = state_23391;
(statearr_23468[(28)] = inst_23197);

return statearr_23468;
})();
if(inst_23198){
var statearr_23469_23590 = state_23391__$1;
(statearr_23469_23590[(1)] = (14));

} else {
var statearr_23470_23591 = state_23391__$1;
(statearr_23470_23591[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (2))){
var inst_23166 = (state_23391[(37)]);
var inst_23173 = (state_23391[(38)]);
var inst_23167 = (state_23391[(14)]);
var _ = (function (){var statearr_23471 = state_23391;
(statearr_23471[(4)] = cljs.core.cons((5),(state_23391[(4)])));

return statearr_23471;
})();
var inst_23166__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_23167__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23166__$1,(0),null);
var inst_23168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23166__$1,(1),null);
var inst_23169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23166__$1,(2),null);
var inst_23170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23166__$1,(3),null);
var inst_23171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23166__$1,(4),null);
var inst_23172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23166__$1,(5),null);
var inst_23173__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_23174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23173__$1,(0),null);
var inst_23175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23173__$1,(1),null);
var inst_23176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23173__$1,(2),null);
var inst_23177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23173__$1,(3),null);
var inst_23178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23173__$1,(4),null);
var inst_23179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23173__$1,(5),null);
var inst_23180 = fluree.db.util.core.pred_ident_QMARK_(inst_23167__$1);
var state_23391__$1 = (function (){var statearr_23472 = state_23391;
(statearr_23472[(26)] = inst_23177);

(statearr_23472[(30)] = inst_23171);

(statearr_23472[(47)] = inst_23175);

(statearr_23472[(20)] = inst_23168);

(statearr_23472[(58)] = inst_23176);

(statearr_23472[(35)] = inst_23178);

(statearr_23472[(50)] = inst_23169);

(statearr_23472[(54)] = inst_23172);

(statearr_23472[(37)] = inst_23166__$1);

(statearr_23472[(38)] = inst_23173__$1);

(statearr_23472[(59)] = inst_23174);

(statearr_23472[(40)] = inst_23170);

(statearr_23472[(53)] = inst_23179);

(statearr_23472[(14)] = inst_23167__$1);

return statearr_23472;
})();
if(inst_23180){
var statearr_23473_23592 = state_23391__$1;
(statearr_23473_23592[(1)] = (6));

} else {
var statearr_23474_23593 = state_23391__$1;
(statearr_23474_23593[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (66))){
var inst_23322 = (state_23391[(56)]);
var inst_23330 = (state_23391[(13)]);
var inst_23332 = (state_23391[(60)]);
var inst_23329 = cljs.core.seq(inst_23322);
var inst_23330__$1 = cljs.core.first(inst_23329);
var inst_23331 = cljs.core.next(inst_23329);
var inst_23332__$1 = (inst_23330__$1 == null);
var state_23391__$1 = (function (){var statearr_23475 = state_23391;
(statearr_23475[(13)] = inst_23330__$1);

(statearr_23475[(60)] = inst_23332__$1);

(statearr_23475[(61)] = inst_23331);

return statearr_23475;
})();
if(cljs.core.truth_(inst_23332__$1)){
var statearr_23476_23594 = state_23391__$1;
(statearr_23476_23594[(1)] = (68));

} else {
var statearr_23477_23595 = state_23391__$1;
(statearr_23477_23595[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (23))){
var inst_23216 = (state_23391[(19)]);
var state_23391__$1 = state_23391;
var statearr_23478_23596 = state_23391__$1;
(statearr_23478_23596[(2)] = inst_23216);

(statearr_23478_23596[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (47))){
var state_23391__$1 = state_23391;
var statearr_23479_23597 = state_23391__$1;
(statearr_23479_23597[(2)] = fluree.db.util.core.max_long);

(statearr_23479_23597[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (35))){
var inst_23236 = (cljs.core._GT__EQ_ === start_test);
var state_23391__$1 = state_23391;
if(cljs.core.truth_(inst_23236)){
var statearr_23480_23598 = state_23391__$1;
(statearr_23480_23598[(1)] = (37));

} else {
var statearr_23481_23599 = state_23391__$1;
(statearr_23481_23599[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (82))){
var inst_23306 = (state_23391[(7)]);
var state_23391__$1 = state_23391;
var statearr_23482_23600 = state_23391__$1;
(statearr_23482_23600[(2)] = inst_23306);

(statearr_23482_23600[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (76))){
var inst_23331 = (state_23391[(61)]);
var inst_23341 = (state_23391[(23)]);
var inst_23355 = (state_23391[(2)]);
var inst_23322 = inst_23331;
var inst_23323 = inst_23341;
var inst_23324 = inst_23355;
var state_23391__$1 = (function (){var statearr_23483 = state_23391;
(statearr_23483[(56)] = inst_23322);

(statearr_23483[(52)] = inst_23324);

(statearr_23483[(22)] = inst_23323);

return statearr_23483;
})();
var statearr_23484_23601 = state_23391__$1;
(statearr_23484_23601[(2)] = null);

(statearr_23484_23601[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (19))){
var inst_23176 = (state_23391[(58)]);
var state_23391__$1 = state_23391;
var statearr_23485_23602 = state_23391__$1;
(statearr_23485_23602[(2)] = inst_23176);

(statearr_23485_23602[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (57))){
var inst_23270 = (state_23391[(31)]);
var inst_23269 = (state_23391[(34)]);
var inst_23290 = (state_23391[(11)]);
var inst_23280 = (state_23391[(39)]);
var inst_23294 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_23290,inst_23269,inst_23270,inst_23280);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23391__$1,(59),inst_23294);
} else {
if((state_val_23392 === (68))){
var inst_23332 = (state_23391[(60)]);
var state_23391__$1 = state_23391;
var statearr_23486_23603 = state_23391__$1;
(statearr_23486_23603[(2)] = inst_23332);

(statearr_23486_23603[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (11))){
var inst_23174 = (state_23391[(59)]);
var state_23391__$1 = state_23391;
var statearr_23488_23604 = state_23391__$1;
(statearr_23488_23604[(2)] = inst_23174);

(statearr_23488_23604[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (9))){
var inst_23184 = (state_23391[(2)]);
var inst_23185 = fluree.db.util.async.throw_err(inst_23184);
var state_23391__$1 = state_23391;
var statearr_23489_23605 = state_23391__$1;
(statearr_23489_23605[(2)] = inst_23185);

(statearr_23489_23605[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (5))){
var _ = (function (){var statearr_23490 = state_23391;
(statearr_23490[(4)] = cljs.core.rest((state_23391[(4)])));

return statearr_23490;
})();
var state_23391__$1 = state_23391;
var ex23487 = (state_23391__$1[(2)]);
var statearr_23491_23606 = state_23391__$1;
(statearr_23491_23606[(5)] = ex23487);


if((ex23487 instanceof Error)){
var statearr_23492_23607 = state_23391__$1;
(statearr_23492_23607[(1)] = (4));

(statearr_23492_23607[(5)] = null);

} else {
throw ex23487;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (83))){
var inst_23374 = (state_23391[(2)]);
var inst_23375 = cljs.core.not(inst_23374);
var state_23391__$1 = state_23391;
if(inst_23375){
var statearr_23493_23608 = state_23391__$1;
(statearr_23493_23608[(1)] = (87));

} else {
var statearr_23494_23609 = state_23391__$1;
(statearr_23494_23609[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (14))){
var inst_23169 = (state_23391[(50)]);
var inst_23200 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23169);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23391__$1,(17),inst_23200);
} else {
if((state_val_23392 === (45))){
var inst_23249 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
var statearr_23495_23610 = state_23391__$1;
(statearr_23495_23610[(2)] = inst_23249);

(statearr_23495_23610[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (53))){
var state_23391__$1 = state_23391;
var statearr_23496_23611 = state_23391__$1;
(statearr_23496_23611[(2)] = true);

(statearr_23496_23611[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (78))){
var inst_23324 = (state_23391[(52)]);
var state_23391__$1 = state_23391;
var statearr_23497_23612 = state_23391__$1;
(statearr_23497_23612[(2)] = inst_23324);

(statearr_23497_23612[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (26))){
var inst_23168 = (state_23391[(20)]);
var state_23391__$1 = state_23391;
var statearr_23498_23613 = state_23391__$1;
(statearr_23498_23613[(2)] = inst_23168);

(statearr_23498_23613[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (16))){
var inst_23176 = (state_23391[(58)]);
var inst_23206 = (state_23391[(2)]);
var inst_23207 = fluree.db.util.core.pred_ident_QMARK_(inst_23176);
var state_23391__$1 = (function (){var statearr_23499 = state_23391;
(statearr_23499[(41)] = inst_23206);

return statearr_23499;
})();
if(inst_23207){
var statearr_23500_23614 = state_23391__$1;
(statearr_23500_23614[(1)] = (18));

} else {
var statearr_23501_23615 = state_23391__$1;
(statearr_23501_23615[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (81))){
var inst_23263 = (state_23391[(25)]);
var inst_23306 = (state_23391[(7)]);
var inst_23366 = (state_23391[(48)]);
var inst_23253 = (state_23391[(17)]);
var inst_23365 = (inst_23263.cljs$core$IFn$_invoke$arity$2 ? inst_23263.cljs$core$IFn$_invoke$arity$2(inst_23306,inst_23253) : inst_23263.call(null,inst_23306,inst_23253));
var inst_23366__$1 = (inst_23365 < (0));
var state_23391__$1 = (function (){var statearr_23502 = state_23391;
(statearr_23502[(48)] = inst_23366__$1);

return statearr_23502;
})();
if(cljs.core.truth_(inst_23366__$1)){
var statearr_23503_23616 = state_23391__$1;
(statearr_23503_23616[(1)] = (84));

} else {
var statearr_23504_23617 = state_23391__$1;
(statearr_23504_23617[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (79))){
var inst_23324 = (state_23391[(52)]);
var inst_23330 = (state_23391[(13)]);
var inst_23350 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_23324,inst_23330);
var state_23391__$1 = state_23391;
var statearr_23505_23618 = state_23391__$1;
(statearr_23505_23618[(2)] = inst_23350);

(statearr_23505_23618[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (38))){
var state_23391__$1 = state_23391;
var statearr_23506_23619 = state_23391__$1;
(statearr_23506_23619[(2)] = (2147483647));

(statearr_23506_23619[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (87))){
var inst_23362 = (state_23391[(8)]);
var state_23391__$1 = state_23391;
var statearr_23507_23620 = state_23391__$1;
(statearr_23507_23620[(2)] = inst_23362);

(statearr_23507_23620[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (30))){
var inst_23229 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
if(cljs.core.truth_(inst_23229)){
var statearr_23508_23621 = state_23391__$1;
(statearr_23508_23621[(1)] = (31));

} else {
var statearr_23509_23622 = state_23391__$1;
(statearr_23509_23622[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (73))){
var inst_23358 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
var statearr_23510_23623 = state_23391__$1;
(statearr_23510_23623[(2)] = inst_23358);

(statearr_23510_23623[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (10))){
var inst_23174 = (state_23391[(59)]);
var inst_23191 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23174);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23391__$1,(13),inst_23191);
} else {
if((state_val_23392 === (18))){
var inst_23176 = (state_23391[(58)]);
var inst_23209 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23176);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23391__$1,(21),inst_23209);
} else {
if((state_val_23392 === (52))){
var inst_23224 = (state_23391[(24)]);
var inst_23197 = (state_23391[(28)]);
var inst_23259 = (state_23391[(33)]);
var inst_23233 = (state_23391[(43)]);
var inst_23188 = (state_23391[(45)]);
var inst_23273 = fluree.db.permissions_validate.no_filter_QMARK_(inst_23259,inst_23188,inst_23197,inst_23224,inst_23233);
var state_23391__$1 = state_23391;
var statearr_23511_23624 = state_23391__$1;
(statearr_23511_23624[(2)] = inst_23273);

(statearr_23511_23624[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (67))){
var inst_23360 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
var statearr_23512_23625 = state_23391__$1;
(statearr_23512_23625[(2)] = inst_23360);

(statearr_23512_23625[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (71))){
var inst_23292 = (state_23391[(27)]);
var inst_23324 = (state_23391[(52)]);
var inst_23339 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23324,inst_23292);
var state_23391__$1 = state_23391;
var statearr_23513_23626 = state_23391__$1;
(statearr_23513_23626[(2)] = inst_23339);

(statearr_23513_23626[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (42))){
var inst_23224 = (state_23391[(24)]);
var inst_23177 = (state_23391[(26)]);
var inst_23197 = (state_23391[(28)]);
var inst_23171 = (state_23391[(30)]);
var inst_23178 = (state_23391[(35)]);
var inst_23215 = (state_23391[(21)]);
var inst_23254 = (state_23391[(49)]);
var inst_23170 = (state_23391[(40)]);
var inst_23206 = (state_23391[(41)]);
var inst_23251 = (state_23391[(42)]);
var inst_23233 = (state_23391[(43)]);
var inst_23242 = (state_23391[(44)]);
var inst_23188 = (state_23391[(45)]);
var inst_23251__$1 = (state_23391[(2)]);
var inst_23252 = fluree.db.flake.__GT_Flake(inst_23188,inst_23224,inst_23206,inst_23170,inst_23171,inst_23242);
var inst_23253 = fluree.db.flake.__GT_Flake(inst_23197,inst_23233,inst_23215,inst_23177,inst_23178,inst_23251__$1);
var inst_23254__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_23391__$1 = (function (){var statearr_23514 = state_23391;
(statearr_23514[(15)] = inst_23252);

(statearr_23514[(49)] = inst_23254__$1);

(statearr_23514[(17)] = inst_23253);

(statearr_23514[(42)] = inst_23251__$1);

return statearr_23514;
})();
if(cljs.core.truth_(inst_23254__$1)){
var statearr_23515_23627 = state_23391__$1;
(statearr_23515_23627[(1)] = (46));

} else {
var statearr_23516_23628 = state_23391__$1;
(statearr_23516_23628[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (80))){
var inst_23352 = (state_23391[(2)]);
var state_23391__$1 = state_23391;
var statearr_23517_23629 = state_23391__$1;
(statearr_23517_23629[(2)] = inst_23352);

(statearr_23517_23629[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (37))){
var state_23391__$1 = state_23391;
var statearr_23518_23630 = state_23391__$1;
(statearr_23518_23630[(2)] = fluree.db.util.core.min_integer);

(statearr_23518_23630[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (63))){
var inst_23292 = (state_23391[(27)]);
var inst_23258 = (state_23391[(32)]);
var inst_23291 = (state_23391[(36)]);
var inst_23305 = (state_23391[(12)]);
var inst_23308 = (inst_23258 - inst_23291);
var inst_23309 = fluree.db.flake.take(inst_23308,inst_23305);
var inst_23310 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23309,inst_23292);
var state_23391__$1 = state_23391;
var statearr_23519_23631 = state_23391__$1;
(statearr_23519_23631[(2)] = inst_23310);

(statearr_23519_23631[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (8))){
var inst_23174 = (state_23391[(59)]);
var inst_23188 = (state_23391[(2)]);
var inst_23189 = fluree.db.util.core.pred_ident_QMARK_(inst_23174);
var state_23391__$1 = (function (){var statearr_23520 = state_23391;
(statearr_23520[(45)] = inst_23188);

return statearr_23520;
})();
if(inst_23189){
var statearr_23521_23632 = state_23391__$1;
(statearr_23521_23632[(1)] = (10));

} else {
var statearr_23522_23633 = state_23391__$1;
(statearr_23522_23633[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (49))){
var inst_23264 = (state_23391[(51)]);
var state_23391__$1 = state_23391;
var statearr_23523_23634 = state_23391__$1;
(statearr_23523_23634[(2)] = inst_23264);

(statearr_23523_23634[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23392 === (84))){
var inst_23258 = (state_23391[(32)]);
var inst_23363 = (state_23391[(9)]);
var inst_23368 = (inst_23363 < inst_23258);
var state_23391__$1 = state_23391;
var statearr_23524_23635 = state_23391__$1;
(statearr_23524_23635[(2)] = inst_23368);

(statearr_23524_23635[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10798__auto__ = null;
var fluree$db$query$range$state_machine__10798__auto____0 = (function (){
var statearr_23525 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23525[(0)] = fluree$db$query$range$state_machine__10798__auto__);

(statearr_23525[(1)] = (1));

return statearr_23525;
});
var fluree$db$query$range$state_machine__10798__auto____1 = (function (state_23391){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_23391);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e23526){var ex__10801__auto__ = e23526;
var statearr_23527_23636 = state_23391;
(statearr_23527_23636[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_23391[(4)]))){
var statearr_23528_23637 = state_23391;
(statearr_23528_23637[(1)] = cljs.core.first((state_23391[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__23638 = state_23391;
state_23391 = G__23638;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10798__auto__ = function(state_23391){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10798__auto____1.call(this,state_23391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10798__auto____0;
fluree$db$query$range$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10798__auto____1;
return fluree$db$query$range$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_23529 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_23529[(6)] = c__10835__auto__);

return statearr_23529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_23713){
var state_val_23714 = (state_23713[(1)]);
if((state_val_23714 === (7))){
var inst_23708 = (state_23713[(2)]);
var _ = (function (){var statearr_23715 = state_23713;
(statearr_23715[(4)] = cljs.core.rest((state_23713[(4)])));

return statearr_23715;
})();
var state_23713__$1 = state_23713;
var statearr_23716_23756 = state_23713__$1;
(statearr_23716_23756[(2)] = inst_23708);

(statearr_23716_23756[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (20))){
var inst_23690 = (state_23713[(2)]);
var inst_23691 = fluree.db.util.async.throw_err(inst_23690);
var state_23713__$1 = state_23713;
var statearr_23717_23757 = state_23713__$1;
(statearr_23717_23757[(2)] = inst_23691);

(statearr_23717_23757[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (1))){
var state_23713__$1 = state_23713;
var statearr_23718_23758 = state_23713__$1;
(statearr_23718_23758[(2)] = null);

(statearr_23718_23758[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (4))){
var inst_23639 = (state_23713[(2)]);
var state_23713__$1 = state_23713;
var statearr_23719_23759 = state_23713__$1;
(statearr_23719_23759[(2)] = inst_23639);

(statearr_23719_23759[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (15))){
var inst_23686 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_23713__$1 = state_23713;
if(cljs.core.truth_(inst_23686)){
var statearr_23720_23760 = state_23713__$1;
(statearr_23720_23760[(1)] = (17));

} else {
var statearr_23721_23761 = state_23713__$1;
(statearr_23721_23761[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (21))){
var state_23713__$1 = state_23713;
var statearr_23722_23762 = state_23713__$1;
(statearr_23722_23762[(2)] = (0));

(statearr_23722_23762[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (13))){
var inst_23678 = (state_23713[(2)]);
var state_23713__$1 = state_23713;
var statearr_23723_23763 = state_23713__$1;
(statearr_23723_23763[(2)] = inst_23678);

(statearr_23723_23763[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (22))){
var state_23713__$1 = state_23713;
var statearr_23724_23764 = state_23713__$1;
(statearr_23724_23764[(2)] = (1));

(statearr_23724_23764[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (6))){
var inst_23670 = (state_23713[(7)]);
var inst_23659 = (state_23713[(8)]);
var inst_23668 = (state_23713[(9)]);
var inst_23667 = cljs.core.seq(inst_23659);
var inst_23668__$1 = cljs.core.first(inst_23667);
var inst_23669 = cljs.core.next(inst_23667);
var inst_23670__$1 = (inst_23668__$1 == null);
var state_23713__$1 = (function (){var statearr_23725 = state_23713;
(statearr_23725[(10)] = inst_23669);

(statearr_23725[(7)] = inst_23670__$1);

(statearr_23725[(9)] = inst_23668__$1);

return statearr_23725;
})();
if(cljs.core.truth_(inst_23670__$1)){
var statearr_23726_23765 = state_23713__$1;
(statearr_23726_23765[(1)] = (8));

} else {
var statearr_23727_23766 = state_23713__$1;
(statearr_23727_23766[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (17))){
var inst_23668 = (state_23713[(9)]);
var inst_23688 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_23668);
var state_23713__$1 = state_23713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23713__$1,(20),inst_23688);
} else {
if((state_val_23714 === (3))){
var inst_23711 = (state_23713[(2)]);
var state_23713__$1 = state_23713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23713__$1,inst_23711);
} else {
if((state_val_23714 === (12))){
var inst_23661 = (state_23713[(11)]);
var inst_23676 = (inst_23661 >= subject_limit);
var state_23713__$1 = state_23713;
var statearr_23728_23767 = state_23713__$1;
(statearr_23728_23767[(2)] = inst_23676);

(statearr_23728_23767[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (2))){
var _ = (function (){var statearr_23729 = state_23713;
(statearr_23729[(4)] = cljs.core.cons((5),(state_23713[(4)])));

return statearr_23729;
})();
var inst_23652 = subject_groups;
var inst_23653 = cljs.core.seq(inst_23652);
var inst_23654 = cljs.core.first(inst_23653);
var inst_23655 = cljs.core.next(inst_23653);
var inst_23656 = flake_start;
var inst_23657 = subject_start;
var inst_23658 = cljs.core.PersistentVector.EMPTY;
var inst_23659 = inst_23652;
var inst_23660 = inst_23656;
var inst_23661 = inst_23657;
var inst_23662 = inst_23658;
var state_23713__$1 = (function (){var statearr_23730 = state_23713;
(statearr_23730[(12)] = inst_23662);

(statearr_23730[(13)] = inst_23655);

(statearr_23730[(11)] = inst_23661);

(statearr_23730[(8)] = inst_23659);

(statearr_23730[(14)] = inst_23654);

(statearr_23730[(15)] = inst_23660);

return statearr_23730;
})();
var statearr_23731_23768 = state_23713__$1;
(statearr_23731_23768[(2)] = null);

(statearr_23731_23768[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (23))){
var inst_23662 = (state_23713[(12)]);
var inst_23669 = (state_23713[(10)]);
var inst_23661 = (state_23713[(11)]);
var inst_23695 = (state_23713[(16)]);
var inst_23694 = (state_23713[(17)]);
var inst_23660 = (state_23713[(15)]);
var inst_23700 = (state_23713[(2)]);
var inst_23701 = (inst_23660 + inst_23695);
var inst_23702 = (inst_23661 + inst_23700);
var inst_23703 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23662,inst_23694);
var inst_23659 = inst_23669;
var inst_23660__$1 = inst_23701;
var inst_23661__$1 = inst_23702;
var inst_23662__$1 = inst_23703;
var state_23713__$1 = (function (){var statearr_23732 = state_23713;
(statearr_23732[(12)] = inst_23662__$1);

(statearr_23732[(11)] = inst_23661__$1);

(statearr_23732[(8)] = inst_23659);

(statearr_23732[(15)] = inst_23660__$1);

return statearr_23732;
})();
var statearr_23733_23769 = state_23713__$1;
(statearr_23733_23769[(2)] = null);

(statearr_23733_23769[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (19))){
var inst_23695 = (state_23713[(16)]);
var inst_23694 = (state_23713[(17)]);
var inst_23694__$1 = (state_23713[(2)]);
var inst_23695__$1 = cljs.core.count(inst_23694__$1);
var inst_23696 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_23695__$1);
var state_23713__$1 = (function (){var statearr_23734 = state_23713;
(statearr_23734[(16)] = inst_23695__$1);

(statearr_23734[(17)] = inst_23694__$1);

return statearr_23734;
})();
if(inst_23696){
var statearr_23735_23770 = state_23713__$1;
(statearr_23735_23770[(1)] = (21));

} else {
var statearr_23736_23771 = state_23713__$1;
(statearr_23736_23771[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (11))){
var inst_23673 = (state_23713[(18)]);
var state_23713__$1 = state_23713;
var statearr_23738_23772 = state_23713__$1;
(statearr_23738_23772[(2)] = inst_23673);

(statearr_23738_23772[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (9))){
var inst_23673 = (state_23713[(18)]);
var inst_23660 = (state_23713[(15)]);
var inst_23673__$1 = (inst_23660 >= flake_limit);
var state_23713__$1 = (function (){var statearr_23739 = state_23713;
(statearr_23739[(18)] = inst_23673__$1);

return statearr_23739;
})();
if(cljs.core.truth_(inst_23673__$1)){
var statearr_23740_23773 = state_23713__$1;
(statearr_23740_23773[(1)] = (11));

} else {
var statearr_23741_23774 = state_23713__$1;
(statearr_23741_23774[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (5))){
var _ = (function (){var statearr_23742 = state_23713;
(statearr_23742[(4)] = cljs.core.rest((state_23713[(4)])));

return statearr_23742;
})();
var state_23713__$1 = state_23713;
var ex23737 = (state_23713__$1[(2)]);
var statearr_23743_23775 = state_23713__$1;
(statearr_23743_23775[(5)] = ex23737);


if((ex23737 instanceof Error)){
var statearr_23744_23776 = state_23713__$1;
(statearr_23744_23776[(1)] = (4));

(statearr_23744_23776[(5)] = null);

} else {
throw ex23737;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (14))){
var inst_23662 = (state_23713[(12)]);
var inst_23661 = (state_23713[(11)]);
var inst_23660 = (state_23713[(15)]);
var inst_23682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23683 = [inst_23660,inst_23661,inst_23662];
var inst_23684 = (new cljs.core.PersistentVector(null,3,(5),inst_23682,inst_23683,null));
var state_23713__$1 = state_23713;
var statearr_23745_23777 = state_23713__$1;
(statearr_23745_23777[(2)] = inst_23684);

(statearr_23745_23777[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (16))){
var inst_23706 = (state_23713[(2)]);
var state_23713__$1 = state_23713;
var statearr_23746_23778 = state_23713__$1;
(statearr_23746_23778[(2)] = inst_23706);

(statearr_23746_23778[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (10))){
var inst_23680 = (state_23713[(2)]);
var state_23713__$1 = state_23713;
if(cljs.core.truth_(inst_23680)){
var statearr_23747_23779 = state_23713__$1;
(statearr_23747_23779[(1)] = (14));

} else {
var statearr_23748_23780 = state_23713__$1;
(statearr_23748_23780[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (18))){
var inst_23668 = (state_23713[(9)]);
var state_23713__$1 = state_23713;
var statearr_23749_23781 = state_23713__$1;
(statearr_23749_23781[(2)] = inst_23668);

(statearr_23749_23781[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23714 === (8))){
var inst_23670 = (state_23713[(7)]);
var state_23713__$1 = state_23713;
var statearr_23750_23782 = state_23713__$1;
(statearr_23750_23782[(2)] = inst_23670);

(statearr_23750_23782[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto____0 = (function (){
var statearr_23751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23751[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto__);

(statearr_23751[(1)] = (1));

return statearr_23751;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto____1 = (function (state_23713){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_23713);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e23752){var ex__10801__auto__ = e23752;
var statearr_23753_23783 = state_23713;
(statearr_23753_23783[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_23713[(4)]))){
var statearr_23754_23784 = state_23713;
(statearr_23754_23784[(1)] = cljs.core.first((state_23713[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__23785 = state_23713;
state_23713 = G__23785;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto__ = function(state_23713){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto____1.call(this,state_23713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_23755 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_23755[(6)] = c__10835__auto__);

return statearr_23755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_23831){
var state_val_23832 = (state_23831[(1)]);
if((state_val_23832 === (7))){
var state_23831__$1 = state_23831;
var statearr_23833_23871 = state_23831__$1;
(statearr_23833_23871[(2)] = null);

(statearr_23833_23871[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (20))){
var inst_23817 = (state_23831[(2)]);
var inst_23818 = fluree.db.util.async.throw_err(inst_23817);
var inst_23796 = inst_23818;
var state_23831__$1 = (function (){var statearr_23834 = state_23831;
(statearr_23834[(7)] = inst_23796);

return statearr_23834;
})();
var statearr_23835_23872 = state_23831__$1;
(statearr_23835_23872[(2)] = null);

(statearr_23835_23872[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (1))){
var state_23831__$1 = state_23831;
var statearr_23836_23873 = state_23831__$1;
(statearr_23836_23873[(2)] = null);

(statearr_23836_23873[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (4))){
var inst_23786 = (state_23831[(2)]);
var state_23831__$1 = state_23831;
var statearr_23837_23874 = state_23831__$1;
(statearr_23837_23874[(2)] = inst_23786);

(statearr_23837_23874[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (15))){
var inst_23813 = (state_23831[(8)]);
var inst_23796 = (state_23831[(7)]);
var inst_23813__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_23796);
var state_23831__$1 = (function (){var statearr_23838 = state_23831;
(statearr_23838[(8)] = inst_23813__$1);

return statearr_23838;
})();
if(cljs.core.truth_(inst_23813__$1)){
var statearr_23839_23875 = state_23831__$1;
(statearr_23839_23875[(1)] = (17));

} else {
var statearr_23840_23876 = state_23831__$1;
(statearr_23840_23876[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (13))){
var inst_23806 = (state_23831[(2)]);
var inst_23807 = fluree.db.util.async.throw_err(inst_23806);
var _ = (function (){var statearr_23841 = state_23831;
(statearr_23841[(4)] = cljs.core.rest((state_23831[(4)])));

return statearr_23841;
})();
var state_23831__$1 = state_23831;
var statearr_23842_23877 = state_23831__$1;
(statearr_23842_23877[(2)] = inst_23807);

(statearr_23842_23877[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (6))){
var inst_23794 = (state_23831[(2)]);
var inst_23795 = fluree.db.util.async.throw_err(inst_23794);
var inst_23796 = inst_23795;
var state_23831__$1 = (function (){var statearr_23843 = state_23831;
(statearr_23843[(7)] = inst_23796);

return statearr_23843;
})();
var statearr_23844_23878 = state_23831__$1;
(statearr_23844_23878[(2)] = null);

(statearr_23844_23878[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (17))){
var inst_23813 = (state_23831[(8)]);
var inst_23815 = fluree.db.dbproto._lookup_leaf(root_node,inst_23813);
var state_23831__$1 = state_23831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23831__$1,(20),inst_23815);
} else {
if((state_val_23832 === (3))){
var inst_23829 = (state_23831[(2)]);
var state_23831__$1 = state_23831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23831__$1,inst_23829);
} else {
if((state_val_23832 === (12))){
var _ = (function (){var statearr_23846 = state_23831;
(statearr_23846[(4)] = cljs.core.rest((state_23831[(4)])));

return statearr_23846;
})();
var state_23831__$1 = state_23831;
var ex23845 = (state_23831__$1[(2)]);
var statearr_23847_23879 = state_23831__$1;
(statearr_23847_23879[(5)] = ex23845);


var statearr_23848_23880 = state_23831__$1;
(statearr_23848_23880[(1)] = (11));

(statearr_23848_23880[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (2))){
var _ = (function (){var statearr_23849 = state_23831;
(statearr_23849[(4)] = cljs.core.cons((5),(state_23831[(4)])));

return statearr_23849;
})();
var inst_23792 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_23831__$1 = state_23831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23831__$1,(6),inst_23792);
} else {
if((state_val_23832 === (19))){
var inst_23822 = (state_23831[(2)]);
var state_23831__$1 = state_23831;
var statearr_23850_23881 = state_23831__$1;
(statearr_23850_23881[(2)] = inst_23822);

(statearr_23850_23881[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (11))){
var inst_23798 = (state_23831[(2)]);
var state_23831__$1 = (function (){var statearr_23852 = state_23831;
(statearr_23852[(9)] = inst_23798);

return statearr_23852;
})();
var statearr_23853_23882 = state_23831__$1;
(statearr_23853_23882[(2)] = null);

(statearr_23853_23882[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (9))){
var inst_23796 = (state_23831[(7)]);
var _ = (function (){var statearr_23854 = state_23831;
(statearr_23854[(4)] = cljs.core.cons((12),(state_23831[(4)])));

return statearr_23854;
})();
var inst_23804 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_23796,t,novelty,fast_forward_db_QMARK_);
var state_23831__$1 = state_23831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23831__$1,(13),inst_23804);
} else {
if((state_val_23832 === (5))){
var _ = (function (){var statearr_23855 = state_23831;
(statearr_23855[(4)] = cljs.core.rest((state_23831[(4)])));

return statearr_23855;
})();
var state_23831__$1 = state_23831;
var ex23851 = (state_23831__$1[(2)]);
var statearr_23856_23883 = state_23831__$1;
(statearr_23856_23883[(5)] = ex23851);


if((ex23851 instanceof Error)){
var statearr_23857_23884 = state_23831__$1;
(statearr_23857_23884[(1)] = (4));

(statearr_23857_23884[(5)] = null);

} else {
throw ex23851;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (14))){
var inst_23810 = (state_23831[(10)]);
var state_23831__$1 = state_23831;
var statearr_23858_23885 = state_23831__$1;
(statearr_23858_23885[(2)] = inst_23810);

(statearr_23858_23885[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (16))){
var inst_23824 = (state_23831[(2)]);
var state_23831__$1 = state_23831;
var statearr_23859_23886 = state_23831__$1;
(statearr_23859_23886[(2)] = inst_23824);

(statearr_23859_23886[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (10))){
var inst_23810 = (state_23831[(10)]);
var inst_23810__$1 = (state_23831[(2)]);
var state_23831__$1 = (function (){var statearr_23860 = state_23831;
(statearr_23860[(10)] = inst_23810__$1);

return statearr_23860;
})();
if(cljs.core.truth_(inst_23810__$1)){
var statearr_23861_23887 = state_23831__$1;
(statearr_23861_23887[(1)] = (14));

} else {
var statearr_23862_23888 = state_23831__$1;
(statearr_23862_23888[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (18))){
var state_23831__$1 = state_23831;
var statearr_23863_23889 = state_23831__$1;
(statearr_23863_23889[(2)] = null);

(statearr_23863_23889[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23832 === (8))){
var inst_23826 = (state_23831[(2)]);
var _ = (function (){var statearr_23864 = state_23831;
(statearr_23864[(4)] = cljs.core.rest((state_23831[(4)])));

return statearr_23864;
})();
var state_23831__$1 = state_23831;
var statearr_23865_23890 = state_23831__$1;
(statearr_23865_23890[(2)] = inst_23826);

(statearr_23865_23890[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto____0 = (function (){
var statearr_23866 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23866[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto__);

(statearr_23866[(1)] = (1));

return statearr_23866;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto____1 = (function (state_23831){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_23831);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e23867){var ex__10801__auto__ = e23867;
var statearr_23868_23891 = state_23831;
(statearr_23868_23891[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_23831[(4)]))){
var statearr_23869_23892 = state_23831;
(statearr_23869_23892[(1)] = cljs.core.first((state_23831[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__23893 = state_23831;
state_23831 = G__23893;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto__ = function(state_23831){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto____1.call(this,state_23831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_23870 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_23870[(6)] = c__10835__auto__);

return statearr_23870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__23900 = arguments.length;
switch (G__23900) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__23901 = (function (){var pred__23904 = cljs.core.identical_QMARK_;
var expr__23905 = test;
if(cljs.core.truth_((pred__23904.cljs$core$IFn$_invoke$arity$2 ? pred__23904.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__23905) : pred__23904.call(null,cljs.core._EQ_,expr__23905)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__23904.cljs$core$IFn$_invoke$arity$2 ? pred__23904.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__23905) : pred__23904.call(null,cljs.core._LT_,expr__23905)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__23904.cljs$core$IFn$_invoke$arity$2 ? pred__23904.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__23905) : pred__23904.call(null,cljs.core._LT__EQ_,expr__23905)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__23904.cljs$core$IFn$_invoke$arity$2 ? pred__23904.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__23905) : pred__23904.call(null,cljs.core._GT_,expr__23905)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__23904.cljs$core$IFn$_invoke$arity$2 ? pred__23904.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__23905) : pred__23904.call(null,cljs.core._GT__EQ_,expr__23905)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__23905)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23901,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23901,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23901,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23901,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_24277){
var state_val_24278 = (state_24277[(1)]);
if((state_val_24278 === (121))){
var inst_24233 = (state_24277[(7)]);
var state_24277__$1 = state_24277;
var statearr_24279_24475 = state_24277__$1;
(statearr_24279_24475[(2)] = inst_24233);

(statearr_24279_24475[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (65))){
var inst_24085 = (state_24277[(8)]);
var inst_24091 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24280 = state_24277;
(statearr_24280[(9)] = inst_24091);

return statearr_24280;
})();
if(cljs.core.truth_(inst_24085)){
var statearr_24281_24476 = state_24277__$1;
(statearr_24281_24476[(1)] = (66));

} else {
var statearr_24282_24477 = state_24277__$1;
(statearr_24282_24477[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (70))){
var inst_24269 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24283_24478 = state_24277__$1;
(statearr_24283_24478[(2)] = inst_24269);

(statearr_24283_24478[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (62))){
var inst_24084 = (state_24277[(2)]);
var inst_24085 = fluree.db.util.async.throw_err(inst_24084);
var inst_24086 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_24277__$1 = (function (){var statearr_24284 = state_24277;
(statearr_24284[(8)] = inst_24085);

return statearr_24284;
})();
if(cljs.core.truth_(inst_24086)){
var statearr_24285_24479 = state_24277__$1;
(statearr_24285_24479[(1)] = (63));

} else {
var statearr_24286_24480 = state_24277__$1;
(statearr_24286_24480[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (74))){
var inst_23943 = (state_24277[(10)]);
var inst_24058 = (state_24277[(11)]);
var inst_24017 = (state_24277[(12)]);
var inst_24026 = (state_24277[(13)]);
var inst_24057 = (state_24277[(14)]);
var inst_24095 = (state_24277[(15)]);
var inst_24071 = (state_24277[(16)]);
var inst_24094 = (state_24277[(17)]);
var inst_23954 = (state_24277[(18)]);
var inst_24096 = (state_24277[(19)]);
var inst_24008 = (state_24277[(20)]);
var inst_23963 = (state_24277[(21)]);
var inst_24076 = (state_24277[(22)]);
var inst_23938 = (state_24277[(23)]);
var inst_24081 = (state_24277[(24)]);
var inst_24044 = (state_24277[(25)]);
var inst_24064 = (state_24277[(26)]);
var inst_24097 = (state_24277[(27)]);
var inst_24065 = (state_24277[(28)]);
var inst_23934 = (state_24277[(29)]);
var inst_24085 = (state_24277[(8)]);
var inst_23942 = (state_24277[(30)]);
var inst_23939 = (state_24277[(31)]);
var inst_24091 = (state_24277[(9)]);
var inst_23931 = (state_24277[(32)]);
var inst_24035 = (state_24277[(33)]);
var inst_23932 = (state_24277[(34)]);
var inst_23996 = (state_24277[(35)]);
var inst_24066 = (state_24277[(36)]);
var inst_23927 = (state_24277[(37)]);
var inst_24075 = (state_24277[(38)]);
var inst_24055 = (state_24277[(39)]);
var inst_24098 = (state_24277[(40)]);
var inst_24070 = (state_24277[(41)]);
var inst_24104 = (state_24277[(42)]);
var inst_23999 = (state_24277[(43)]);
var inst_24053 = (state_24277[(44)]);
var inst_24054 = (state_24277[(45)]);
var inst_23944 = (state_24277[(46)]);
var inst_23995 = (state_24277[(47)]);
var inst_24112 = (state_24277[(48)]);
var inst_24114 = (function (){var map__23919 = inst_23942;
var no_filter_QMARK_ = inst_24091;
var t = inst_24071;
var max_limit_QMARK_ = inst_24065;
var vec__23920 = inst_23995;
var next_node = inst_24094;
var map__23926 = inst_24057;
var fast_forward_db_QMARK_ = inst_24076;
var s1 = inst_23954;
var o2 = inst_24017;
var t1 = inst_23931;
var predicate_fn = inst_23944;
var i = inst_24096;
var m1 = inst_24044;
var root_node = inst_24081;
var s2 = inst_23963;
var p2 = inst_24035;
var permissions = inst_24066;
var limit = inst_24064;
var start_flake = inst_24054;
var flake_limit = inst_24058;
var offset = inst_24095;
var acc = inst_24098;
var t2 = inst_23938;
var op1 = inst_23932;
var o1 = inst_24008;
var end_flake = inst_24055;
var base_result = inst_24104;
var s = inst_24097;
var node_start = inst_24085;
var p1 = inst_24026;
var subject_fn = inst_23943;
var vec__23916 = inst_23934;
var vec__23923 = inst_23996;
var object_fn = inst_23999;
var idx_compare = inst_24070;
var G__24105 = inst_24112;
var op2 = inst_23939;
var m2 = inst_24053;
var vec__23913 = inst_23927;
var novelty = inst_24075;
return (function (p1__23895_SHARP_){
var G__24287 = p1__23895_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__24287) : subject_fn.call(null,G__24287));
});
})();
var inst_24115 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_24114,inst_24112);
var state_24277__$1 = state_24277;
var statearr_24288_24481 = state_24277__$1;
(statearr_24288_24481[(2)] = inst_24115);

(statearr_24288_24481[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (110))){
var inst_24246 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24289_24482 = state_24277__$1;
(statearr_24289_24482[(2)] = inst_24246);

(statearr_24289_24482[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (7))){
var inst_23928 = (state_24277[(49)]);
var state_24277__$1 = state_24277;
var statearr_24290_24483 = state_24277__$1;
(statearr_24290_24483[(2)] = inst_23928);

(statearr_24290_24483[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (59))){
var state_24277__$1 = state_24277;
var statearr_24291_24484 = state_24277__$1;
(statearr_24291_24484[(2)] = fluree.db.util.core.max_long);

(statearr_24291_24484[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (86))){
var inst_24091 = (state_24277[(9)]);
var state_24277__$1 = state_24277;
var statearr_24292_24485 = state_24277__$1;
(statearr_24292_24485[(2)] = inst_24091);

(statearr_24292_24485[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (20))){
var state_24277__$1 = state_24277;
var statearr_24293_24486 = state_24277__$1;
(statearr_24293_24486[(2)] = null);

(statearr_24293_24486[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (72))){
var inst_24104 = (state_24277[(42)]);
var state_24277__$1 = state_24277;
var statearr_24294_24487 = state_24277__$1;
(statearr_24294_24487[(2)] = inst_24104);

(statearr_24294_24487[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (58))){
var inst_24059 = (state_24277[(50)]);
var state_24277__$1 = state_24277;
var statearr_24295_24488 = state_24277__$1;
(statearr_24295_24488[(2)] = inst_24059);

(statearr_24295_24488[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (60))){
var inst_24064 = (state_24277[(26)]);
var inst_24064__$1 = (state_24277[(2)]);
var inst_24065 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24064__$1,fluree.db.util.core.max_long);
var inst_24066 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_24067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24068 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_24069 = (new cljs.core.PersistentVector(null,3,(5),inst_24067,inst_24068,null));
var inst_24070 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_24069);
var inst_24071 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_24072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24073 = [cljs.core.cst$kw$novelty,idx];
var inst_24074 = (new cljs.core.PersistentVector(null,2,(5),inst_24072,inst_24073,null));
var inst_24075 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_24074);
var inst_24076 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_24077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_24078 = fluree.db.dbproto._resolve(inst_24077);
var state_24277__$1 = (function (){var statearr_24296 = state_24277;
(statearr_24296[(16)] = inst_24071);

(statearr_24296[(22)] = inst_24076);

(statearr_24296[(26)] = inst_24064__$1);

(statearr_24296[(28)] = inst_24065);

(statearr_24296[(36)] = inst_24066);

(statearr_24296[(38)] = inst_24075);

(statearr_24296[(41)] = inst_24070);

return statearr_24296;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24277__$1,(61),inst_24078);
} else {
if((state_val_24278 === (27))){
var inst_23997 = (state_24277[(51)]);
var state_24277__$1 = state_24277;
var statearr_24297_24489 = state_24277__$1;
(statearr_24297_24489[(2)] = inst_23997);

(statearr_24297_24489[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (1))){
var state_24277__$1 = state_24277;
var statearr_24298_24490 = state_24277__$1;
(statearr_24298_24490[(2)] = null);

(statearr_24298_24490[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (69))){
var inst_24094 = (state_24277[(17)]);
var inst_24055 = (state_24277[(39)]);
var inst_24054 = (state_24277[(45)]);
var inst_24103 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_24094);
var inst_24104 = fluree.db.flake.subrange(inst_24103,start_test,inst_24054,end_test,inst_24055);
var inst_24106 = fluree.db.query.range.value_with_nil_pred(idx,inst_24054,inst_24055);
var state_24277__$1 = (function (){var statearr_24299 = state_24277;
(statearr_24299[(42)] = inst_24104);

return statearr_24299;
})();
if(inst_24106){
var statearr_24300_24491 = state_24277__$1;
(statearr_24300_24491[(1)] = (71));

} else {
var statearr_24301_24492 = state_24277__$1;
(statearr_24301_24492[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (101))){
var inst_24058 = (state_24277[(11)]);
var inst_24190 = (state_24277[(52)]);
var inst_24192 = (state_24277[(53)]);
var inst_24191 = (state_24277[(54)]);
var inst_24195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24196 = (inst_24192 - inst_24058);
var inst_24197 = (inst_24191 - inst_24196);
var inst_24198 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_24197,inst_24190);
var inst_24199 = [inst_24058,inst_24198];
var inst_24200 = (new cljs.core.PersistentVector(null,2,(5),inst_24195,inst_24199,null));
var state_24277__$1 = state_24277;
var statearr_24302_24493 = state_24277__$1;
(statearr_24302_24493[(2)] = inst_24200);

(statearr_24302_24493[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (24))){
var inst_23943 = (state_24277[(10)]);
var inst_23936 = (state_24277[(55)]);
var inst_23954 = (state_24277[(18)]);
var inst_23963 = (state_24277[(21)]);
var inst_23933 = (state_24277[(56)]);
var inst_23938 = (state_24277[(23)]);
var inst_23930 = (state_24277[(57)]);
var inst_23934 = (state_24277[(29)]);
var inst_23945 = (state_24277[(58)]);
var inst_23977 = (state_24277[(59)]);
var inst_23942 = (state_24277[(30)]);
var inst_23939 = (state_24277[(31)]);
var inst_23931 = (state_24277[(32)]);
var inst_23932 = (state_24277[(34)]);
var inst_23937 = (state_24277[(60)]);
var inst_23927 = (state_24277[(37)]);
var inst_23929 = (state_24277[(61)]);
var inst_23940 = (state_24277[(62)]);
var inst_23944 = (state_24277[(46)]);
var inst_23987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23989 = [null,null];
var inst_23990 = (new cljs.core.PersistentVector(null,2,(5),inst_23988,inst_23989,null));
var inst_23991 = (function (){var map__23919 = inst_23942;
var bool = inst_23977;
var s1 = inst_23954;
var o2 = inst_23937;
var t1 = inst_23931;
var predicate_fn = inst_23944;
var m1 = inst_23933;
var s2 = inst_23963;
var p2 = inst_23936;
var t2 = inst_23938;
var op1 = inst_23932;
var o1 = inst_23930;
var p1 = inst_23929;
var subject_fn = inst_23943;
var vec__23916 = inst_23934;
var object_fn = inst_23945;
var op2 = inst_23939;
var m2 = inst_23940;
var vec__23913 = inst_23927;
var temp__5755__auto__ = inst_23977;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_23992 = [inst_23990,inst_23991];
var inst_23993 = (new cljs.core.PersistentVector(null,2,(5),inst_23987,inst_23992,null));
var state_24277__$1 = state_24277;
var statearr_24303_24494 = state_24277__$1;
(statearr_24303_24494[(2)] = inst_23993);

(statearr_24303_24494[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (102))){
var inst_24190 = (state_24277[(52)]);
var inst_24192 = (state_24277[(53)]);
var inst_24202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24203 = [inst_24192,inst_24190];
var inst_24204 = (new cljs.core.PersistentVector(null,2,(5),inst_24202,inst_24203,null));
var state_24277__$1 = state_24277;
var statearr_24304_24495 = state_24277__$1;
(statearr_24304_24495[(2)] = inst_24204);

(statearr_24304_24495[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (55))){
var state_24277__$1 = state_24277;
var statearr_24305_24496 = state_24277__$1;
(statearr_24305_24496[(2)] = (2147483647));

(statearr_24305_24496[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (85))){
var inst_24140 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24140)){
var statearr_24306_24497 = state_24277__$1;
(statearr_24306_24497[(1)] = (89));

} else {
var statearr_24307_24498 = state_24277__$1;
(statearr_24307_24498[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (39))){
var inst_23936 = (state_24277[(55)]);
var inst_24027 = (state_24277[(63)]);
var inst_24026 = (state_24277[(2)]);
var inst_24027__$1 = (inst_23936 == null);
var state_24277__$1 = (function (){var statearr_24308 = state_24277;
(statearr_24308[(63)] = inst_24027__$1);

(statearr_24308[(13)] = inst_24026);

return statearr_24308;
})();
if(cljs.core.truth_(inst_24027__$1)){
var statearr_24309_24499 = state_24277__$1;
(statearr_24309_24499[(1)] = (40));

} else {
var statearr_24310_24500 = state_24277__$1;
(statearr_24310_24500[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (88))){
var inst_24137 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24311_24501 = state_24277__$1;
(statearr_24311_24501[(2)] = inst_24137);

(statearr_24311_24501[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (46))){
var inst_23933 = (state_24277[(56)]);
var state_24277__$1 = state_24277;
var statearr_24312_24502 = state_24277__$1;
(statearr_24312_24502[(2)] = inst_23933);

(statearr_24312_24502[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (4))){
var inst_23907 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24313_24503 = state_24277__$1;
(statearr_24313_24503[(2)] = inst_23907);

(statearr_24313_24503[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (77))){
var inst_23943 = (state_24277[(10)]);
var inst_24058 = (state_24277[(11)]);
var inst_24017 = (state_24277[(12)]);
var inst_24026 = (state_24277[(13)]);
var inst_24057 = (state_24277[(14)]);
var inst_24095 = (state_24277[(15)]);
var inst_24071 = (state_24277[(16)]);
var inst_24094 = (state_24277[(17)]);
var inst_23954 = (state_24277[(18)]);
var inst_24096 = (state_24277[(19)]);
var inst_24008 = (state_24277[(20)]);
var inst_23963 = (state_24277[(21)]);
var inst_24076 = (state_24277[(22)]);
var inst_23938 = (state_24277[(23)]);
var inst_24081 = (state_24277[(24)]);
var inst_24044 = (state_24277[(25)]);
var inst_24064 = (state_24277[(26)]);
var inst_24097 = (state_24277[(27)]);
var inst_24065 = (state_24277[(28)]);
var inst_23934 = (state_24277[(29)]);
var inst_24085 = (state_24277[(8)]);
var inst_23942 = (state_24277[(30)]);
var inst_23939 = (state_24277[(31)]);
var inst_24091 = (state_24277[(9)]);
var inst_23931 = (state_24277[(32)]);
var inst_24035 = (state_24277[(33)]);
var inst_23932 = (state_24277[(34)]);
var inst_23996 = (state_24277[(35)]);
var inst_24066 = (state_24277[(36)]);
var inst_23927 = (state_24277[(37)]);
var inst_24075 = (state_24277[(38)]);
var inst_24055 = (state_24277[(39)]);
var inst_24098 = (state_24277[(40)]);
var inst_24070 = (state_24277[(41)]);
var inst_24104 = (state_24277[(42)]);
var inst_23999 = (state_24277[(43)]);
var inst_24053 = (state_24277[(44)]);
var inst_24118 = (state_24277[(64)]);
var inst_24054 = (state_24277[(45)]);
var inst_23944 = (state_24277[(46)]);
var inst_23995 = (state_24277[(47)]);
var inst_24120 = (function (){var map__23919 = inst_23942;
var no_filter_QMARK_ = inst_24091;
var t = inst_24071;
var max_limit_QMARK_ = inst_24065;
var vec__23920 = inst_23995;
var next_node = inst_24094;
var map__23926 = inst_24057;
var fast_forward_db_QMARK_ = inst_24076;
var s1 = inst_23954;
var o2 = inst_24017;
var t1 = inst_23931;
var predicate_fn = inst_23944;
var i = inst_24096;
var m1 = inst_24044;
var root_node = inst_24081;
var s2 = inst_23963;
var p2 = inst_24035;
var permissions = inst_24066;
var limit = inst_24064;
var start_flake = inst_24054;
var flake_limit = inst_24058;
var offset = inst_24095;
var acc = inst_24098;
var t2 = inst_23938;
var op1 = inst_23932;
var o1 = inst_24008;
var end_flake = inst_24055;
var base_result = inst_24104;
var s = inst_24097;
var node_start = inst_24085;
var p1 = inst_24026;
var subject_fn = inst_23943;
var vec__23916 = inst_23934;
var vec__23923 = inst_23996;
var object_fn = inst_23999;
var idx_compare = inst_24070;
var G__24105 = inst_24118;
var op2 = inst_23939;
var m2 = inst_24053;
var vec__23913 = inst_23927;
var novelty = inst_24075;
return (function (p1__23896_SHARP_){
var G__24314 = p1__23896_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__24314) : predicate_fn.call(null,G__24314));
});
})();
var inst_24121 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_24120,inst_24118);
var state_24277__$1 = state_24277;
var statearr_24315_24504 = state_24277__$1;
(statearr_24315_24504[(2)] = inst_24121);

(statearr_24315_24504[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (106))){
var inst_24131 = (state_24277[(65)]);
var state_24277__$1 = state_24277;
var statearr_24316_24505 = state_24277__$1;
(statearr_24316_24505[(2)] = inst_24131);

(statearr_24316_24505[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (119))){
var inst_24249 = (state_24277[(66)]);
var state_24277__$1 = state_24277;
var statearr_24317_24506 = state_24277__$1;
(statearr_24317_24506[(2)] = inst_24249);

(statearr_24317_24506[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (95))){
var inst_24174 = (state_24277[(67)]);
var inst_24164 = (state_24277[(68)]);
var inst_24173 = (state_24277[(69)]);
var inst_24064 = (state_24277[(26)]);
var inst_24097 = (state_24277[(27)]);
var inst_24172 = (state_24277[(70)]);
var inst_24172__$1 = cljs.core.count(inst_24164);
var inst_24173__$1 = (inst_24097 + inst_24172__$1);
var inst_24174__$1 = (inst_24173__$1 - inst_24064);
var inst_24175 = cljs.core.pos_int_QMARK_(inst_24174__$1);
var state_24277__$1 = (function (){var statearr_24318 = state_24277;
(statearr_24318[(67)] = inst_24174__$1);

(statearr_24318[(69)] = inst_24173__$1);

(statearr_24318[(70)] = inst_24172__$1);

return statearr_24318;
})();
if(inst_24175){
var statearr_24319_24507 = state_24277__$1;
(statearr_24319_24507[(1)] = (98));

} else {
var statearr_24320_24508 = state_24277__$1;
(statearr_24320_24508[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (54))){
var inst_24017 = (state_24277[(12)]);
var inst_24026 = (state_24277[(13)]);
var inst_24057 = (state_24277[(14)]);
var inst_23954 = (state_24277[(18)]);
var inst_24008 = (state_24277[(20)]);
var inst_23963 = (state_24277[(21)]);
var inst_23938 = (state_24277[(23)]);
var inst_24044 = (state_24277[(25)]);
var inst_23939 = (state_24277[(31)]);
var inst_24059 = (state_24277[(50)]);
var inst_23931 = (state_24277[(32)]);
var inst_24035 = (state_24277[(33)]);
var inst_23932 = (state_24277[(34)]);
var inst_24053 = (state_24277[(44)]);
var inst_24053__$1 = (state_24277[(2)]);
var inst_24054 = fluree.db.flake.__GT_Flake(inst_23954,inst_24026,inst_24008,inst_23931,inst_23932,inst_24044);
var inst_24055 = fluree.db.flake.__GT_Flake(inst_23963,inst_24035,inst_24017,inst_23938,inst_23939,inst_24053__$1);
var inst_24056 = opts;
var inst_24057__$1 = cljs.core.__destructure_map(inst_24056);
var inst_24058 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_24057__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_24059__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24057__$1,cljs.core.cst$kw$limit);
var inst_24060 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_24057__$1,cljs.core.cst$kw$offset,(0));
var state_24277__$1 = (function (){var statearr_24321 = state_24277;
(statearr_24321[(11)] = inst_24058);

(statearr_24321[(14)] = inst_24057__$1);

(statearr_24321[(71)] = inst_24060);

(statearr_24321[(50)] = inst_24059__$1);

(statearr_24321[(39)] = inst_24055);

(statearr_24321[(44)] = inst_24053__$1);

(statearr_24321[(45)] = inst_24054);

return statearr_24321;
})();
if(cljs.core.truth_(inst_24059__$1)){
var statearr_24322_24509 = state_24277__$1;
(statearr_24322_24509[(1)] = (58));

} else {
var statearr_24323_24510 = state_24277__$1;
(statearr_24323_24510[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (92))){
var inst_24095 = (state_24277[(15)]);
var inst_24096 = (state_24277[(19)]);
var inst_24153 = (state_24277[(72)]);
var inst_24097 = (state_24277[(27)]);
var inst_24098 = (state_24277[(40)]);
var inst_24156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24157 = (inst_24095 - inst_24153);
var inst_24158 = [inst_24157,inst_24096,inst_24097,inst_24098];
var inst_24159 = (new cljs.core.PersistentVector(null,4,(5),inst_24156,inst_24158,null));
var state_24277__$1 = state_24277;
var statearr_24324_24511 = state_24277__$1;
(statearr_24324_24511[(2)] = inst_24159);

(statearr_24324_24511[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (104))){
var inst_24215 = (state_24277[(2)]);
var inst_24216 = fluree.db.util.async.throw_err(inst_24215);
var state_24277__$1 = state_24277;
var statearr_24325_24512 = state_24277__$1;
(statearr_24325_24512[(2)] = inst_24216);

(statearr_24325_24512[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (15))){
var inst_23937 = (state_24277[(60)]);
var inst_23967 = cljs.core.boolean_QMARK_(inst_23937);
var state_24277__$1 = state_24277;
if(inst_23967){
var statearr_24326_24513 = state_24277__$1;
(statearr_24326_24513[(1)] = (17));

} else {
var statearr_24327_24514 = state_24277__$1;
(statearr_24327_24514[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (48))){
var inst_23940 = (state_24277[(62)]);
var inst_24044 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24328 = state_24277;
(statearr_24328[(25)] = inst_24044);

return statearr_24328;
})();
if(cljs.core.truth_(inst_23940)){
var statearr_24329_24515 = state_24277__$1;
(statearr_24329_24515[(1)] = (52));

} else {
var statearr_24330_24516 = state_24277__$1;
(statearr_24330_24516[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (50))){
var state_24277__$1 = state_24277;
var statearr_24331_24517 = state_24277__$1;
(statearr_24331_24517[(2)] = (2147483647));

(statearr_24331_24517[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (116))){
var inst_24249 = (state_24277[(66)]);
var inst_24257 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24332 = state_24277;
(statearr_24332[(73)] = inst_24257);

return statearr_24332;
})();
if(cljs.core.truth_(inst_24249)){
var statearr_24333_24518 = state_24277__$1;
(statearr_24333_24518[(1)] = (118));

} else {
var statearr_24334_24519 = state_24277__$1;
(statearr_24334_24519[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (75))){
var inst_24112 = (state_24277[(48)]);
var state_24277__$1 = state_24277;
var statearr_24335_24520 = state_24277__$1;
(statearr_24335_24520[(2)] = inst_24112);

(statearr_24335_24520[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (99))){
var inst_24173 = (state_24277[(69)]);
var inst_24182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24183 = [inst_24173,inst_24173];
var inst_24184 = (new cljs.core.PersistentVector(null,2,(5),inst_24182,inst_24183,null));
var state_24277__$1 = state_24277;
var statearr_24336_24521 = state_24277__$1;
(statearr_24336_24521[(2)] = inst_24184);

(statearr_24336_24521[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (21))){
var state_24277__$1 = state_24277;
var statearr_24337_24522 = state_24277__$1;
(statearr_24337_24522[(2)] = null);

(statearr_24337_24522[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (31))){
var inst_23998 = (state_24277[(74)]);
var state_24277__$1 = state_24277;
var statearr_24338_24523 = state_24277__$1;
(statearr_24338_24523[(2)] = inst_23998);

(statearr_24338_24523[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (113))){
var inst_24243 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24339_24524 = state_24277__$1;
(statearr_24339_24524[(2)] = inst_24243);

(statearr_24339_24524[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (32))){
var inst_24018 = (state_24277[(75)]);
var inst_23929 = (state_24277[(61)]);
var inst_24017 = (state_24277[(2)]);
var inst_24018__$1 = (inst_23929 == null);
var state_24277__$1 = (function (){var statearr_24340 = state_24277;
(statearr_24340[(12)] = inst_24017);

(statearr_24340[(75)] = inst_24018__$1);

return statearr_24340;
})();
if(cljs.core.truth_(inst_24018__$1)){
var statearr_24341_24525 = state_24277__$1;
(statearr_24341_24525[(1)] = (34));

} else {
var statearr_24342_24526 = state_24277__$1;
(statearr_24342_24526[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (40))){
var inst_24017 = (state_24277[(12)]);
var state_24277__$1 = state_24277;
var statearr_24343_24527 = state_24277__$1;
(statearr_24343_24527[(2)] = inst_24017);

(statearr_24343_24527[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (91))){
var inst_24131 = (state_24277[(65)]);
var inst_24229 = (state_24277[(2)]);
var inst_24230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24229,(0),null);
var inst_24231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24229,(1),null);
var inst_24232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24229,(2),null);
var inst_24233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24229,(3),null);
var state_24277__$1 = (function (){var statearr_24344 = state_24277;
(statearr_24344[(76)] = inst_24232);

(statearr_24344[(7)] = inst_24233);

(statearr_24344[(77)] = inst_24230);

(statearr_24344[(78)] = inst_24231);

return statearr_24344;
})();
if(cljs.core.truth_(inst_24131)){
var statearr_24345_24528 = state_24277__$1;
(statearr_24345_24528[(1)] = (105));

} else {
var statearr_24346_24529 = state_24277__$1;
(statearr_24346_24529[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (117))){
var inst_24253 = (state_24277[(2)]);
var inst_24254 = fluree.db.util.async.throw_err(inst_24253);
var state_24277__$1 = state_24277;
var statearr_24347_24530 = state_24277__$1;
(statearr_24347_24530[(2)] = inst_24254);

(statearr_24347_24530[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (108))){
var inst_24058 = (state_24277[(11)]);
var inst_24238 = (state_24277[(79)]);
var inst_24231 = (state_24277[(78)]);
var inst_24238__$1 = (inst_24231 < inst_24058);
var state_24277__$1 = (function (){var statearr_24348 = state_24277;
(statearr_24348[(79)] = inst_24238__$1);

return statearr_24348;
})();
if(cljs.core.truth_(inst_24238__$1)){
var statearr_24349_24531 = state_24277__$1;
(statearr_24349_24531[(1)] = (111));

} else {
var statearr_24350_24532 = state_24277__$1;
(statearr_24350_24532[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (56))){
var state_24277__$1 = state_24277;
var statearr_24351_24533 = state_24277__$1;
(statearr_24351_24533[(2)] = fluree.db.util.core.min_integer);

(statearr_24351_24533[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (33))){
var inst_24013 = (state_24277[(2)]);
var inst_24014 = fluree.db.util.async.throw_err(inst_24013);
var state_24277__$1 = state_24277;
var statearr_24352_24534 = state_24277__$1;
(statearr_24352_24534[(2)] = inst_24014);

(statearr_24352_24534[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (13))){
var inst_23959 = (state_24277[(2)]);
var inst_23960 = fluree.db.util.async.throw_err(inst_23959);
var state_24277__$1 = state_24277;
var statearr_24353_24535 = state_24277__$1;
(statearr_24353_24535[(2)] = inst_23960);

(statearr_24353_24535[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (22))){
var inst_23973 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24354_24536 = state_24277__$1;
(statearr_24354_24536[(2)] = inst_23973);

(statearr_24354_24536[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (90))){
var inst_23943 = (state_24277[(10)]);
var inst_24058 = (state_24277[(11)]);
var inst_24017 = (state_24277[(12)]);
var inst_24026 = (state_24277[(13)]);
var inst_24057 = (state_24277[(14)]);
var inst_24095 = (state_24277[(15)]);
var inst_24071 = (state_24277[(16)]);
var inst_24152 = (state_24277[(80)]);
var inst_24094 = (state_24277[(17)]);
var inst_23954 = (state_24277[(18)]);
var inst_24096 = (state_24277[(19)]);
var inst_24008 = (state_24277[(20)]);
var inst_23963 = (state_24277[(21)]);
var inst_24076 = (state_24277[(22)]);
var inst_23938 = (state_24277[(23)]);
var inst_24081 = (state_24277[(24)]);
var inst_24153 = (state_24277[(72)]);
var inst_24044 = (state_24277[(25)]);
var inst_24064 = (state_24277[(26)]);
var inst_24097 = (state_24277[(27)]);
var inst_24065 = (state_24277[(28)]);
var inst_24131 = (state_24277[(65)]);
var inst_23934 = (state_24277[(29)]);
var inst_24085 = (state_24277[(8)]);
var inst_23942 = (state_24277[(30)]);
var inst_23939 = (state_24277[(31)]);
var inst_24091 = (state_24277[(9)]);
var inst_23931 = (state_24277[(32)]);
var inst_24035 = (state_24277[(33)]);
var inst_23932 = (state_24277[(34)]);
var inst_23996 = (state_24277[(35)]);
var inst_24066 = (state_24277[(36)]);
var inst_23927 = (state_24277[(37)]);
var inst_24075 = (state_24277[(38)]);
var inst_24055 = (state_24277[(39)]);
var inst_24098 = (state_24277[(40)]);
var inst_24130 = (state_24277[(81)]);
var inst_24070 = (state_24277[(41)]);
var inst_24104 = (state_24277[(42)]);
var inst_23999 = (state_24277[(43)]);
var inst_24053 = (state_24277[(44)]);
var inst_24054 = (state_24277[(45)]);
var inst_23944 = (state_24277[(46)]);
var inst_23995 = (state_24277[(47)]);
var inst_24151 = (function (){var map__23919 = inst_23942;
var no_filter_QMARK_ = inst_24091;
var base_result_SINGLEQUOTE_ = inst_24130;
var t = inst_24071;
var max_limit_QMARK_ = inst_24065;
var vec__23920 = inst_23995;
var next_node = inst_24094;
var map__23926 = inst_24057;
var fast_forward_db_QMARK_ = inst_24076;
var s1 = inst_23954;
var o2 = inst_24017;
var t1 = inst_23931;
var predicate_fn = inst_23944;
var i = inst_24096;
var rhs = inst_24131;
var m1 = inst_24044;
var root_node = inst_24081;
var s2 = inst_23963;
var p2 = inst_24035;
var permissions = inst_24066;
var limit = inst_24064;
var start_flake = inst_24054;
var flake_limit = inst_24058;
var offset = inst_24095;
var acc = inst_24098;
var t2 = inst_23938;
var op1 = inst_23932;
var o1 = inst_24008;
var end_flake = inst_24055;
var base_result = inst_24104;
var s = inst_24097;
var node_start = inst_24085;
var p1 = inst_24026;
var subject_fn = inst_23943;
var vec__23916 = inst_23934;
var vec__23923 = inst_23996;
var object_fn = inst_23999;
var idx_compare = inst_24070;
var op2 = inst_23939;
var m2 = inst_24053;
var vec__23913 = inst_23927;
var novelty = inst_24075;
return (function (p1__23898_SHARP_){
return p1__23898_SHARP_.s;
});
})();
var inst_24152__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_24151,inst_24130);
var inst_24153__$1 = cljs.core.count(inst_24152__$1);
var inst_24154 = (inst_24095 > inst_24153__$1);
var state_24277__$1 = (function (){var statearr_24355 = state_24277;
(statearr_24355[(80)] = inst_24152__$1);

(statearr_24355[(72)] = inst_24153__$1);

return statearr_24355;
})();
if(cljs.core.truth_(inst_24154)){
var statearr_24356_24537 = state_24277__$1;
(statearr_24356_24537[(1)] = (92));

} else {
var statearr_24357_24538 = state_24277__$1;
(statearr_24357_24538[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (109))){
var inst_24236 = (state_24277[(82)]);
var state_24277__$1 = state_24277;
var statearr_24358_24539 = state_24277__$1;
(statearr_24358_24539[(2)] = inst_24236);

(statearr_24358_24539[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (36))){
var inst_24022 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24022)){
var statearr_24359_24540 = state_24277__$1;
(statearr_24359_24540[(1)] = (37));

} else {
var statearr_24360_24541 = state_24277__$1;
(statearr_24360_24541[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (41))){
var inst_24027 = (state_24277[(63)]);
var state_24277__$1 = state_24277;
var statearr_24361_24542 = state_24277__$1;
(statearr_24361_24542[(2)] = inst_24027);

(statearr_24361_24542[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (118))){
var inst_24257 = (state_24277[(73)]);
var state_24277__$1 = state_24277;
var statearr_24362_24543 = state_24277__$1;
(statearr_24362_24543[(2)] = inst_24257);

(statearr_24362_24543[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (89))){
var inst_24058 = (state_24277[(11)]);
var inst_24096 = (state_24277[(19)]);
var inst_24097 = (state_24277[(27)]);
var inst_24098 = (state_24277[(40)]);
var inst_24130 = (state_24277[(81)]);
var inst_24142 = cljs.core.count(inst_24130);
var inst_24143 = (inst_24058 - inst_24096);
var inst_24144 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_24143,inst_24130);
var inst_24145 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24098,inst_24144);
var inst_24146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24147 = (inst_24096 + inst_24142);
var inst_24148 = [(0),inst_24147,inst_24097,inst_24145];
var inst_24149 = (new cljs.core.PersistentVector(null,4,(5),inst_24146,inst_24148,null));
var state_24277__$1 = state_24277;
var statearr_24363_24544 = state_24277__$1;
(statearr_24363_24544[(2)] = inst_24149);

(statearr_24363_24544[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (100))){
var inst_24058 = (state_24277[(11)]);
var inst_24190 = (state_24277[(52)]);
var inst_24096 = (state_24277[(19)]);
var inst_24164 = (state_24277[(68)]);
var inst_24192 = (state_24277[(53)]);
var inst_24191 = (state_24277[(54)]);
var inst_24186 = (state_24277[(2)]);
var inst_24187 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24186,(0),null);
var inst_24188 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24186,(1),null);
var inst_24189 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_24188,inst_24164);
var inst_24190__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_24189);
var inst_24191__$1 = cljs.core.count(inst_24190__$1);
var inst_24192__$1 = (inst_24096 + inst_24191__$1);
var inst_24193 = (inst_24192__$1 > inst_24058);
var state_24277__$1 = (function (){var statearr_24364 = state_24277;
(statearr_24364[(52)] = inst_24190__$1);

(statearr_24364[(53)] = inst_24192__$1);

(statearr_24364[(54)] = inst_24191__$1);

(statearr_24364[(83)] = inst_24187);

return statearr_24364;
})();
if(cljs.core.truth_(inst_24193)){
var statearr_24365_24545 = state_24277__$1;
(statearr_24365_24545[(1)] = (101));

} else {
var statearr_24366_24546 = state_24277__$1;
(statearr_24366_24546[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (122))){
var inst_24232 = (state_24277[(76)]);
var inst_24233 = (state_24277[(7)]);
var inst_24257 = (state_24277[(73)]);
var inst_24230 = (state_24277[(77)]);
var inst_24231 = (state_24277[(78)]);
var inst_24094 = inst_24257;
var inst_24095 = inst_24230;
var inst_24096 = inst_24231;
var inst_24097 = inst_24232;
var inst_24098 = inst_24233;
var state_24277__$1 = (function (){var statearr_24367 = state_24277;
(statearr_24367[(15)] = inst_24095);

(statearr_24367[(17)] = inst_24094);

(statearr_24367[(19)] = inst_24096);

(statearr_24367[(27)] = inst_24097);

(statearr_24367[(40)] = inst_24098);

return statearr_24367;
})();
var statearr_24368_24547 = state_24277__$1;
(statearr_24368_24547[(2)] = null);

(statearr_24368_24547[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (43))){
var state_24277__$1 = state_24277;
var statearr_24369_24548 = state_24277__$1;
(statearr_24369_24548[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_24369_24548[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (61))){
var inst_24071 = (state_24277[(16)]);
var inst_24076 = (state_24277[(22)]);
var inst_24081 = (state_24277[(24)]);
var inst_24075 = (state_24277[(38)]);
var inst_24054 = (state_24277[(45)]);
var inst_24080 = (state_24277[(2)]);
var inst_24081__$1 = fluree.db.util.async.throw_err(inst_24080);
var inst_24082 = fluree.db.query.range.find_next_valid_node(inst_24081__$1,inst_24054,inst_24071,inst_24075,inst_24076);
var state_24277__$1 = (function (){var statearr_24370 = state_24277;
(statearr_24370[(24)] = inst_24081__$1);

return statearr_24370;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24277__$1,(62),inst_24082);
} else {
if((state_val_24278 === (29))){
var inst_24004 = (state_24277[(2)]);
var inst_24005 = fluree.db.util.async.throw_err(inst_24004);
var state_24277__$1 = state_24277;
var statearr_24371_24549 = state_24277__$1;
(statearr_24371_24549[(2)] = inst_24005);

(statearr_24371_24549[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (44))){
var inst_23936 = (state_24277[(55)]);
var state_24277__$1 = state_24277;
var statearr_24372_24550 = state_24277__$1;
(statearr_24372_24550[(2)] = inst_23936);

(statearr_24372_24550[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (93))){
var inst_24095 = (state_24277[(15)]);
var inst_24152 = (state_24277[(80)]);
var inst_24091 = (state_24277[(9)]);
var inst_24164 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_24095,inst_24152);
var state_24277__$1 = (function (){var statearr_24373 = state_24277;
(statearr_24373[(68)] = inst_24164);

return statearr_24373;
})();
if(cljs.core.truth_(inst_24091)){
var statearr_24374_24551 = state_24277__$1;
(statearr_24374_24551[(1)] = (95));

} else {
var statearr_24375_24552 = state_24277__$1;
(statearr_24375_24552[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (6))){
var inst_23928 = (state_24277[(49)]);
var inst_23948 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23928);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24277__$1,(9),inst_23948);
} else {
if((state_val_24278 === (111))){
var inst_24232 = (state_24277[(76)]);
var inst_24064 = (state_24277[(26)]);
var inst_24240 = (inst_24232 < inst_24064);
var state_24277__$1 = state_24277;
var statearr_24376_24553 = state_24277__$1;
(statearr_24376_24553[(2)] = inst_24240);

(statearr_24376_24553[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (28))){
var inst_23998 = (state_24277[(74)]);
var inst_24008 = (state_24277[(2)]);
var inst_24009 = fluree.db.util.core.pred_ident_QMARK_(inst_23998);
var state_24277__$1 = (function (){var statearr_24377 = state_24277;
(statearr_24377[(20)] = inst_24008);

return statearr_24377;
})();
if(inst_24009){
var statearr_24378_24554 = state_24277__$1;
(statearr_24378_24554[(1)] = (30));

} else {
var statearr_24379_24555 = state_24277__$1;
(statearr_24379_24555[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (64))){
var state_24277__$1 = state_24277;
var statearr_24380_24556 = state_24277__$1;
(statearr_24380_24556[(2)] = true);

(statearr_24380_24556[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (103))){
var inst_24187 = (state_24277[(83)]);
var inst_24206 = (state_24277[(2)]);
var inst_24207 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24206,(0),null);
var inst_24208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24206,(1),null);
var inst_24209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24210 = [inst_24207,inst_24187,inst_24208];
var inst_24211 = (new cljs.core.PersistentVector(null,3,(5),inst_24209,inst_24210,null));
var state_24277__$1 = state_24277;
var statearr_24381_24557 = state_24277__$1;
(statearr_24381_24557[(2)] = inst_24211);

(statearr_24381_24557[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (51))){
var inst_24042 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24382_24558 = state_24277__$1;
(statearr_24382_24558[(2)] = inst_24042);

(statearr_24382_24558[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (25))){
var inst_23997 = (state_24277[(51)]);
var inst_23996 = (state_24277[(35)]);
var inst_23995 = (state_24277[(47)]);
var inst_23995__$1 = (state_24277[(2)]);
var inst_23996__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23995__$1,(0),null);
var inst_23997__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23996__$1,(0),null);
var inst_23998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23996__$1,(1),null);
var inst_23999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23995__$1,(1),null);
var inst_24000 = fluree.db.util.core.pred_ident_QMARK_(inst_23997__$1);
var state_24277__$1 = (function (){var statearr_24383 = state_24277;
(statearr_24383[(74)] = inst_23998);

(statearr_24383[(51)] = inst_23997__$1);

(statearr_24383[(35)] = inst_23996__$1);

(statearr_24383[(43)] = inst_23999);

(statearr_24383[(47)] = inst_23995__$1);

return statearr_24383;
})();
if(inst_24000){
var statearr_24384_24559 = state_24277__$1;
(statearr_24384_24559[(1)] = (26));

} else {
var statearr_24385_24560 = state_24277__$1;
(statearr_24385_24560[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (34))){
var inst_24008 = (state_24277[(20)]);
var state_24277__$1 = state_24277;
var statearr_24386_24561 = state_24277__$1;
(statearr_24386_24561[(2)] = inst_24008);

(statearr_24386_24561[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (17))){
var inst_23937 = (state_24277[(60)]);
var state_24277__$1 = state_24277;
var statearr_24387_24562 = state_24277__$1;
(statearr_24387_24562[(2)] = inst_23937);

(statearr_24387_24562[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (3))){
var inst_24275 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24277__$1,inst_24275);
} else {
if((state_val_24278 === (12))){
var inst_23930 = (state_24277[(57)]);
var inst_23963 = (state_24277[(2)]);
var inst_23964 = cljs.core.boolean_QMARK_(inst_23930);
var state_24277__$1 = (function (){var statearr_24388 = state_24277;
(statearr_24388[(21)] = inst_23963);

return statearr_24388;
})();
if(inst_23964){
var statearr_24389_24563 = state_24277__$1;
(statearr_24389_24563[(1)] = (14));

} else {
var statearr_24390_24564 = state_24277__$1;
(statearr_24390_24564[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (2))){
var inst_23934 = (state_24277[(29)]);
var inst_23942 = (state_24277[(30)]);
var inst_23927 = (state_24277[(37)]);
var inst_23928 = (state_24277[(49)]);
var _ = (function (){var statearr_24391 = state_24277;
(statearr_24391[(4)] = cljs.core.cons((5),(state_24277[(4)])));

return statearr_24391;
})();
var inst_23927__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_23928__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23927__$1,(0),null);
var inst_23929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23927__$1,(1),null);
var inst_23930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23927__$1,(2),null);
var inst_23931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23927__$1,(3),null);
var inst_23932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23927__$1,(4),null);
var inst_23933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23927__$1,(5),null);
var inst_23934__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_23935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23934__$1,(0),null);
var inst_23936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23934__$1,(1),null);
var inst_23937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23934__$1,(2),null);
var inst_23938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23934__$1,(3),null);
var inst_23939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23934__$1,(4),null);
var inst_23940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23934__$1,(5),null);
var inst_23941 = opts;
var inst_23942__$1 = cljs.core.__destructure_map(inst_23941);
var inst_23943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23942__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_23944 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23942__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_23945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23942__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_23946 = fluree.db.util.core.pred_ident_QMARK_(inst_23928__$1);
var state_24277__$1 = (function (){var statearr_24392 = state_24277;
(statearr_24392[(10)] = inst_23943);

(statearr_24392[(55)] = inst_23936);

(statearr_24392[(56)] = inst_23933);

(statearr_24392[(23)] = inst_23938);

(statearr_24392[(57)] = inst_23930);

(statearr_24392[(29)] = inst_23934__$1);

(statearr_24392[(58)] = inst_23945);

(statearr_24392[(30)] = inst_23942__$1);

(statearr_24392[(31)] = inst_23939);

(statearr_24392[(84)] = inst_23935);

(statearr_24392[(32)] = inst_23931);

(statearr_24392[(34)] = inst_23932);

(statearr_24392[(60)] = inst_23937);

(statearr_24392[(37)] = inst_23927__$1);

(statearr_24392[(61)] = inst_23929);

(statearr_24392[(62)] = inst_23940);

(statearr_24392[(49)] = inst_23928__$1);

(statearr_24392[(46)] = inst_23944);

return statearr_24392;
})();
if(inst_23946){
var statearr_24393_24565 = state_24277__$1;
(statearr_24393_24565[(1)] = (6));

} else {
var statearr_24394_24566 = state_24277__$1;
(statearr_24394_24566[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (66))){
var inst_24060 = (state_24277[(71)]);
var inst_24085 = (state_24277[(8)]);
var inst_24093 = cljs.core.PersistentVector.EMPTY;
var inst_24094 = inst_24085;
var inst_24095 = inst_24060;
var inst_24096 = (0);
var inst_24097 = (0);
var inst_24098 = inst_24093;
var state_24277__$1 = (function (){var statearr_24395 = state_24277;
(statearr_24395[(15)] = inst_24095);

(statearr_24395[(17)] = inst_24094);

(statearr_24395[(19)] = inst_24096);

(statearr_24395[(27)] = inst_24097);

(statearr_24395[(40)] = inst_24098);

return statearr_24395;
})();
var statearr_24396_24567 = state_24277__$1;
(statearr_24396_24567[(2)] = null);

(statearr_24396_24567[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (107))){
var inst_24249 = (state_24277[(66)]);
var inst_24249__$1 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24397 = state_24277;
(statearr_24397[(66)] = inst_24249__$1);

return statearr_24397;
})();
if(cljs.core.truth_(inst_24249__$1)){
var statearr_24398_24568 = state_24277__$1;
(statearr_24398_24568[(1)] = (114));

} else {
var statearr_24399_24569 = state_24277__$1;
(statearr_24399_24569[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (23))){
var inst_23930 = (state_24277[(57)]);
var inst_23945 = (state_24277[(58)]);
var inst_23937 = (state_24277[(60)]);
var inst_23980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23982 = [inst_23930,inst_23937];
var inst_23983 = (new cljs.core.PersistentVector(null,2,(5),inst_23981,inst_23982,null));
var inst_23984 = [inst_23983,inst_23945];
var inst_23985 = (new cljs.core.PersistentVector(null,2,(5),inst_23980,inst_23984,null));
var state_24277__$1 = state_24277;
var statearr_24400_24570 = state_24277__$1;
(statearr_24400_24570[(2)] = inst_23985);

(statearr_24400_24570[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (47))){
var inst_24038 = (cljs.core._GT__EQ_ === start_test);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24038)){
var statearr_24401_24571 = state_24277__$1;
(statearr_24401_24571[(1)] = (49));

} else {
var statearr_24402_24572 = state_24277__$1;
(statearr_24402_24572[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (35))){
var inst_24018 = (state_24277[(75)]);
var state_24277__$1 = state_24277;
var statearr_24403_24573 = state_24277__$1;
(statearr_24403_24573[(2)] = inst_24018);

(statearr_24403_24573[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (82))){
var inst_24094 = (state_24277[(17)]);
var inst_24065 = (state_24277[(28)]);
var inst_24130 = (state_24277[(2)]);
var inst_24131 = fluree.db.dbproto._rhs(inst_24094);
var state_24277__$1 = (function (){var statearr_24404 = state_24277;
(statearr_24404[(65)] = inst_24131);

(statearr_24404[(81)] = inst_24130);

return statearr_24404;
})();
if(cljs.core.truth_(inst_24065)){
var statearr_24405_24574 = state_24277__$1;
(statearr_24405_24574[(1)] = (83));

} else {
var statearr_24406_24575 = state_24277__$1;
(statearr_24406_24575[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (76))){
var inst_23944 = (state_24277[(46)]);
var inst_24118 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24407 = state_24277;
(statearr_24407[(64)] = inst_24118);

return statearr_24407;
})();
if(cljs.core.truth_(inst_23944)){
var statearr_24408_24576 = state_24277__$1;
(statearr_24408_24576[(1)] = (77));

} else {
var statearr_24409_24577 = state_24277__$1;
(statearr_24409_24577[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (97))){
var inst_24098 = (state_24277[(40)]);
var inst_24218 = (state_24277[(2)]);
var inst_24219 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24218,(0),null);
var inst_24220 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24218,(1),null);
var inst_24221 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24218,(2),null);
var inst_24222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24223 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24098,inst_24221);
var inst_24224 = [(0),inst_24219,inst_24220,inst_24223];
var inst_24225 = (new cljs.core.PersistentVector(null,4,(5),inst_24222,inst_24224,null));
var state_24277__$1 = state_24277;
var statearr_24410_24578 = state_24277__$1;
(statearr_24410_24578[(2)] = inst_24225);

(statearr_24410_24578[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (19))){
var inst_23975 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24411_24579 = state_24277__$1;
(statearr_24411_24579[(2)] = inst_23975);

(statearr_24411_24579[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (57))){
var inst_24051 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24412_24580 = state_24277__$1;
(statearr_24412_24580[(2)] = inst_24051);

(statearr_24412_24580[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (68))){
var inst_24272 = (state_24277[(2)]);
var _ = (function (){var statearr_24413 = state_24277;
(statearr_24413[(4)] = cljs.core.rest((state_24277[(4)])));

return statearr_24413;
})();
var state_24277__$1 = state_24277;
var statearr_24414_24581 = state_24277__$1;
(statearr_24414_24581[(2)] = inst_24272);

(statearr_24414_24581[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (11))){
var inst_23935 = (state_24277[(84)]);
var state_24277__$1 = state_24277;
var statearr_24415_24582 = state_24277__$1;
(statearr_24415_24582[(2)] = inst_23935);

(statearr_24415_24582[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (115))){
var state_24277__$1 = state_24277;
var statearr_24417_24583 = state_24277__$1;
(statearr_24417_24583[(2)] = null);

(statearr_24417_24583[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (9))){
var inst_23950 = (state_24277[(2)]);
var inst_23951 = fluree.db.util.async.throw_err(inst_23950);
var state_24277__$1 = state_24277;
var statearr_24418_24584 = state_24277__$1;
(statearr_24418_24584[(2)] = inst_23951);

(statearr_24418_24584[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (5))){
var _ = (function (){var statearr_24419 = state_24277;
(statearr_24419[(4)] = cljs.core.rest((state_24277[(4)])));

return statearr_24419;
})();
var state_24277__$1 = state_24277;
var ex24416 = (state_24277__$1[(2)]);
var statearr_24420_24585 = state_24277__$1;
(statearr_24420_24585[(5)] = ex24416);


if((ex24416 instanceof Error)){
var statearr_24421_24586 = state_24277__$1;
(statearr_24421_24586[(1)] = (4));

(statearr_24421_24586[(5)] = null);

} else {
throw ex24416;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (112))){
var inst_24238 = (state_24277[(79)]);
var state_24277__$1 = state_24277;
var statearr_24422_24587 = state_24277__$1;
(statearr_24422_24587[(2)] = inst_24238);

(statearr_24422_24587[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (83))){
var inst_24095 = (state_24277[(15)]);
var inst_24133 = (state_24277[(85)]);
var inst_24133__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_24095);
var state_24277__$1 = (function (){var statearr_24423 = state_24277;
(statearr_24423[(85)] = inst_24133__$1);

return statearr_24423;
})();
if(inst_24133__$1){
var statearr_24424_24588 = state_24277__$1;
(statearr_24424_24588[(1)] = (86));

} else {
var statearr_24425_24589 = state_24277__$1;
(statearr_24425_24589[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (14))){
var inst_23930 = (state_24277[(57)]);
var state_24277__$1 = state_24277;
var statearr_24426_24590 = state_24277__$1;
(statearr_24426_24590[(2)] = inst_23930);

(statearr_24426_24590[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (45))){
var inst_23933 = (state_24277[(56)]);
var inst_24035 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24427 = state_24277;
(statearr_24427[(33)] = inst_24035);

return statearr_24427;
})();
if(cljs.core.truth_(inst_23933)){
var statearr_24428_24591 = state_24277__$1;
(statearr_24428_24591[(1)] = (46));

} else {
var statearr_24429_24592 = state_24277__$1;
(statearr_24429_24592[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (53))){
var inst_24047 = (cljs.core._LT__EQ_ === end_test);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24047)){
var statearr_24430_24593 = state_24277__$1;
(statearr_24430_24593[(1)] = (55));

} else {
var statearr_24431_24594 = state_24277__$1;
(statearr_24431_24594[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (78))){
var inst_24118 = (state_24277[(64)]);
var state_24277__$1 = state_24277;
var statearr_24432_24595 = state_24277__$1;
(statearr_24432_24595[(2)] = inst_24118);

(statearr_24432_24595[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (26))){
var inst_23997 = (state_24277[(51)]);
var inst_24002 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23997);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24277__$1,(29),inst_24002);
} else {
if((state_val_24278 === (123))){
var inst_24267 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24433_24596 = state_24277__$1;
(statearr_24433_24596[(2)] = inst_24267);

(statearr_24433_24596[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (16))){
var inst_23977 = (state_24277[(59)]);
var inst_23977__$1 = (state_24277[(2)]);
var inst_23978 = (inst_23977__$1 == null);
var state_24277__$1 = (function (){var statearr_24434 = state_24277;
(statearr_24434[(59)] = inst_23977__$1);

return statearr_24434;
})();
if(cljs.core.truth_(inst_23978)){
var statearr_24435_24597 = state_24277__$1;
(statearr_24435_24597[(1)] = (23));

} else {
var statearr_24436_24598 = state_24277__$1;
(statearr_24436_24598[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (81))){
var inst_24124 = (state_24277[(86)]);
var state_24277__$1 = state_24277;
var statearr_24437_24599 = state_24277__$1;
(statearr_24437_24599[(2)] = inst_24124);

(statearr_24437_24599[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (120))){
var inst_24261 = (state_24277[(2)]);
var inst_24262 = cljs.core.not(inst_24261);
var state_24277__$1 = state_24277;
if(inst_24262){
var statearr_24438_24600 = state_24277__$1;
(statearr_24438_24600[(1)] = (121));

} else {
var statearr_24439_24601 = state_24277__$1;
(statearr_24439_24601[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (79))){
var inst_23999 = (state_24277[(43)]);
var inst_24124 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24440 = state_24277;
(statearr_24440[(86)] = inst_24124);

return statearr_24440;
})();
if(cljs.core.truth_(inst_23999)){
var statearr_24441_24602 = state_24277__$1;
(statearr_24441_24602[(1)] = (80));

} else {
var statearr_24442_24603 = state_24277__$1;
(statearr_24442_24603[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (38))){
var inst_23929 = (state_24277[(61)]);
var state_24277__$1 = state_24277;
var statearr_24443_24604 = state_24277__$1;
(statearr_24443_24604[(2)] = inst_23929);

(statearr_24443_24604[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (98))){
var inst_24174 = (state_24277[(67)]);
var inst_24064 = (state_24277[(26)]);
var inst_24172 = (state_24277[(70)]);
var inst_24177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24178 = (inst_24172 - inst_24174);
var inst_24179 = [inst_24064,inst_24178];
var inst_24180 = (new cljs.core.PersistentVector(null,2,(5),inst_24177,inst_24179,null));
var state_24277__$1 = state_24277;
var statearr_24444_24605 = state_24277__$1;
(statearr_24444_24605[(2)] = inst_24180);

(statearr_24444_24605[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (87))){
var inst_24133 = (state_24277[(85)]);
var state_24277__$1 = state_24277;
var statearr_24445_24606 = state_24277__$1;
(statearr_24445_24606[(2)] = inst_24133);

(statearr_24445_24606[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (30))){
var inst_23998 = (state_24277[(74)]);
var inst_24011 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23998);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24277__$1,(33),inst_24011);
} else {
if((state_val_24278 === (73))){
var inst_23943 = (state_24277[(10)]);
var inst_24112 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24446 = state_24277;
(statearr_24446[(48)] = inst_24112);

return statearr_24446;
})();
if(cljs.core.truth_(inst_23943)){
var statearr_24447_24607 = state_24277__$1;
(statearr_24447_24607[(1)] = (74));

} else {
var statearr_24448_24608 = state_24277__$1;
(statearr_24448_24608[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (96))){
var inst_24058 = (state_24277[(11)]);
var inst_24096 = (state_24277[(19)]);
var inst_24164 = (state_24277[(68)]);
var inst_24064 = (state_24277[(26)]);
var inst_24097 = (state_24277[(27)]);
var inst_24213 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_24164,inst_24096,inst_24097,inst_24058,inst_24064);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24277__$1,(104),inst_24213);
} else {
if((state_val_24278 === (10))){
var inst_23935 = (state_24277[(84)]);
var inst_23957 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23935);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24277__$1,(13),inst_23957);
} else {
if((state_val_24278 === (18))){
var state_24277__$1 = state_24277;
var statearr_24449_24609 = state_24277__$1;
(statearr_24449_24609[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (105))){
var inst_24236 = (state_24277[(82)]);
var inst_24131 = (state_24277[(65)]);
var inst_24055 = (state_24277[(39)]);
var inst_24070 = (state_24277[(41)]);
var inst_24235 = (inst_24070.cljs$core$IFn$_invoke$arity$2 ? inst_24070.cljs$core$IFn$_invoke$arity$2(inst_24131,inst_24055) : inst_24070.call(null,inst_24131,inst_24055));
var inst_24236__$1 = (inst_24235 < (0));
var state_24277__$1 = (function (){var statearr_24451 = state_24277;
(statearr_24451[(82)] = inst_24236__$1);

return statearr_24451;
})();
if(cljs.core.truth_(inst_24236__$1)){
var statearr_24452_24610 = state_24277__$1;
(statearr_24452_24610[(1)] = (108));

} else {
var statearr_24453_24611 = state_24277__$1;
(statearr_24453_24611[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (52))){
var inst_23940 = (state_24277[(62)]);
var state_24277__$1 = state_24277;
var statearr_24454_24612 = state_24277__$1;
(statearr_24454_24612[(2)] = inst_23940);

(statearr_24454_24612[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (114))){
var inst_24071 = (state_24277[(16)]);
var inst_24076 = (state_24277[(22)]);
var inst_24081 = (state_24277[(24)]);
var inst_24131 = (state_24277[(65)]);
var inst_24075 = (state_24277[(38)]);
var inst_24251 = fluree.db.query.range.find_next_valid_node(inst_24081,inst_24131,inst_24071,inst_24075,inst_24076);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24277__$1,(117),inst_24251);
} else {
if((state_val_24278 === (67))){
var state_24277__$1 = state_24277;
var statearr_24455_24613 = state_24277__$1;
(statearr_24455_24613[(2)] = null);

(statearr_24455_24613[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (71))){
var inst_23943 = (state_24277[(10)]);
var inst_24058 = (state_24277[(11)]);
var inst_24017 = (state_24277[(12)]);
var inst_24026 = (state_24277[(13)]);
var inst_24057 = (state_24277[(14)]);
var inst_24095 = (state_24277[(15)]);
var inst_24071 = (state_24277[(16)]);
var inst_24094 = (state_24277[(17)]);
var inst_23954 = (state_24277[(18)]);
var inst_24096 = (state_24277[(19)]);
var inst_24008 = (state_24277[(20)]);
var inst_23963 = (state_24277[(21)]);
var inst_24076 = (state_24277[(22)]);
var inst_23938 = (state_24277[(23)]);
var inst_24081 = (state_24277[(24)]);
var inst_24044 = (state_24277[(25)]);
var inst_24064 = (state_24277[(26)]);
var inst_24097 = (state_24277[(27)]);
var inst_24065 = (state_24277[(28)]);
var inst_23934 = (state_24277[(29)]);
var inst_24085 = (state_24277[(8)]);
var inst_23942 = (state_24277[(30)]);
var inst_23939 = (state_24277[(31)]);
var inst_24091 = (state_24277[(9)]);
var inst_23931 = (state_24277[(32)]);
var inst_24035 = (state_24277[(33)]);
var inst_23932 = (state_24277[(34)]);
var inst_23996 = (state_24277[(35)]);
var inst_24066 = (state_24277[(36)]);
var inst_23927 = (state_24277[(37)]);
var inst_24075 = (state_24277[(38)]);
var inst_24055 = (state_24277[(39)]);
var inst_24098 = (state_24277[(40)]);
var inst_24070 = (state_24277[(41)]);
var inst_24104 = (state_24277[(42)]);
var inst_23999 = (state_24277[(43)]);
var inst_24053 = (state_24277[(44)]);
var inst_24054 = (state_24277[(45)]);
var inst_23944 = (state_24277[(46)]);
var inst_23995 = (state_24277[(47)]);
var inst_24108 = (function (){var map__23919 = inst_23942;
var no_filter_QMARK_ = inst_24091;
var t = inst_24071;
var max_limit_QMARK_ = inst_24065;
var vec__23920 = inst_23995;
var next_node = inst_24094;
var map__23926 = inst_24057;
var fast_forward_db_QMARK_ = inst_24076;
var s1 = inst_23954;
var o2 = inst_24017;
var t1 = inst_23931;
var predicate_fn = inst_23944;
var i = inst_24096;
var m1 = inst_24044;
var root_node = inst_24081;
var s2 = inst_23963;
var p2 = inst_24035;
var permissions = inst_24066;
var limit = inst_24064;
var start_flake = inst_24054;
var flake_limit = inst_24058;
var offset = inst_24095;
var acc = inst_24098;
var t2 = inst_23938;
var op1 = inst_23932;
var o1 = inst_24008;
var end_flake = inst_24055;
var base_result = inst_24104;
var s = inst_24097;
var node_start = inst_24085;
var p1 = inst_24026;
var subject_fn = inst_23943;
var vec__23916 = inst_23934;
var vec__23923 = inst_23996;
var object_fn = inst_23999;
var idx_compare = inst_24070;
var G__24105 = inst_24104;
var op2 = inst_23939;
var m2 = inst_24053;
var vec__23913 = inst_23927;
var novelty = inst_24075;
return (function (p1__23894_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__23894_SHARP_.o,start_flake.o);
});
})();
var inst_24109 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_24108,inst_24104);
var state_24277__$1 = state_24277;
var statearr_24456_24614 = state_24277__$1;
(statearr_24456_24614[(2)] = inst_24109);

(statearr_24456_24614[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (42))){
var inst_24031 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24031)){
var statearr_24457_24615 = state_24277__$1;
(statearr_24457_24615[(1)] = (43));

} else {
var statearr_24458_24616 = state_24277__$1;
(statearr_24458_24616[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (80))){
var inst_23943 = (state_24277[(10)]);
var inst_24058 = (state_24277[(11)]);
var inst_24017 = (state_24277[(12)]);
var inst_24026 = (state_24277[(13)]);
var inst_24057 = (state_24277[(14)]);
var inst_24095 = (state_24277[(15)]);
var inst_24071 = (state_24277[(16)]);
var inst_24124 = (state_24277[(86)]);
var inst_24094 = (state_24277[(17)]);
var inst_23954 = (state_24277[(18)]);
var inst_24096 = (state_24277[(19)]);
var inst_24008 = (state_24277[(20)]);
var inst_23963 = (state_24277[(21)]);
var inst_24076 = (state_24277[(22)]);
var inst_23938 = (state_24277[(23)]);
var inst_24081 = (state_24277[(24)]);
var inst_24044 = (state_24277[(25)]);
var inst_24064 = (state_24277[(26)]);
var inst_24097 = (state_24277[(27)]);
var inst_24065 = (state_24277[(28)]);
var inst_23934 = (state_24277[(29)]);
var inst_24085 = (state_24277[(8)]);
var inst_23942 = (state_24277[(30)]);
var inst_23939 = (state_24277[(31)]);
var inst_24091 = (state_24277[(9)]);
var inst_23931 = (state_24277[(32)]);
var inst_24035 = (state_24277[(33)]);
var inst_23932 = (state_24277[(34)]);
var inst_23996 = (state_24277[(35)]);
var inst_24066 = (state_24277[(36)]);
var inst_23927 = (state_24277[(37)]);
var inst_24075 = (state_24277[(38)]);
var inst_24055 = (state_24277[(39)]);
var inst_24098 = (state_24277[(40)]);
var inst_24070 = (state_24277[(41)]);
var inst_24104 = (state_24277[(42)]);
var inst_23999 = (state_24277[(43)]);
var inst_24053 = (state_24277[(44)]);
var inst_24054 = (state_24277[(45)]);
var inst_23944 = (state_24277[(46)]);
var inst_23995 = (state_24277[(47)]);
var inst_24126 = (function (){var map__23919 = inst_23942;
var no_filter_QMARK_ = inst_24091;
var t = inst_24071;
var max_limit_QMARK_ = inst_24065;
var vec__23920 = inst_23995;
var next_node = inst_24094;
var map__23926 = inst_24057;
var fast_forward_db_QMARK_ = inst_24076;
var s1 = inst_23954;
var o2 = inst_24017;
var t1 = inst_23931;
var predicate_fn = inst_23944;
var i = inst_24096;
var m1 = inst_24044;
var root_node = inst_24081;
var s2 = inst_23963;
var p2 = inst_24035;
var permissions = inst_24066;
var limit = inst_24064;
var start_flake = inst_24054;
var flake_limit = inst_24058;
var offset = inst_24095;
var acc = inst_24098;
var t2 = inst_23938;
var op1 = inst_23932;
var o1 = inst_24008;
var end_flake = inst_24055;
var base_result = inst_24104;
var s = inst_24097;
var node_start = inst_24085;
var p1 = inst_24026;
var subject_fn = inst_23943;
var vec__23916 = inst_23934;
var vec__23923 = inst_23996;
var object_fn = inst_23999;
var idx_compare = inst_24070;
var G__24105 = inst_24124;
var op2 = inst_23939;
var m2 = inst_24053;
var vec__23913 = inst_23927;
var novelty = inst_24075;
return (function (p1__23897_SHARP_){
var G__24459 = p1__23897_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__24459) : object_fn.call(null,G__24459));
});
})();
var inst_24127 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_24126,inst_24124);
var state_24277__$1 = state_24277;
var statearr_24460_24617 = state_24277__$1;
(statearr_24460_24617[(2)] = inst_24127);

(statearr_24460_24617[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (37))){
var state_24277__$1 = state_24277;
var statearr_24461_24618 = state_24277__$1;
(statearr_24461_24618[(2)] = (-1));

(statearr_24461_24618[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (63))){
var inst_24026 = (state_24277[(13)]);
var inst_23954 = (state_24277[(18)]);
var inst_23963 = (state_24277[(21)]);
var inst_24035 = (state_24277[(33)]);
var inst_24066 = (state_24277[(36)]);
var inst_24088 = fluree.db.permissions_validate.no_filter_QMARK_(inst_24066,inst_23954,inst_23963,inst_24026,inst_24035);
var state_24277__$1 = state_24277;
var statearr_24462_24619 = state_24277__$1;
(statearr_24462_24619[(2)] = inst_24088);

(statearr_24462_24619[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (94))){
var inst_24227 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24463_24620 = state_24277__$1;
(statearr_24463_24620[(2)] = inst_24227);

(statearr_24463_24620[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (8))){
var inst_23935 = (state_24277[(84)]);
var inst_23954 = (state_24277[(2)]);
var inst_23955 = fluree.db.util.core.pred_ident_QMARK_(inst_23935);
var state_24277__$1 = (function (){var statearr_24464 = state_24277;
(statearr_24464[(18)] = inst_23954);

return statearr_24464;
})();
if(inst_23955){
var statearr_24465_24621 = state_24277__$1;
(statearr_24465_24621[(1)] = (10));

} else {
var statearr_24466_24622 = state_24277__$1;
(statearr_24466_24622[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (49))){
var state_24277__$1 = state_24277;
var statearr_24467_24623 = state_24277__$1;
(statearr_24467_24623[(2)] = fluree.db.util.core.min_integer);

(statearr_24467_24623[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24278 === (84))){
var inst_24065 = (state_24277[(28)]);
var state_24277__$1 = state_24277;
var statearr_24468_24624 = state_24277__$1;
(statearr_24468_24624[(2)] = inst_24065);

(statearr_24468_24624[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10798__auto__ = null;
var fluree$db$query$range$state_machine__10798__auto____0 = (function (){
var statearr_24469 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24469[(0)] = fluree$db$query$range$state_machine__10798__auto__);

(statearr_24469[(1)] = (1));

return statearr_24469;
});
var fluree$db$query$range$state_machine__10798__auto____1 = (function (state_24277){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_24277);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e24470){var ex__10801__auto__ = e24470;
var statearr_24471_24625 = state_24277;
(statearr_24471_24625[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_24277[(4)]))){
var statearr_24472_24626 = state_24277;
(statearr_24472_24626[(1)] = cljs.core.first((state_24277[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__24627 = state_24277;
state_24277 = G__24627;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10798__auto__ = function(state_24277){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10798__auto____1.call(this,state_24277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10798__auto____0;
fluree$db$query$range$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10798__auto____1;
return fluree$db$query$range$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_24473 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_24473[(6)] = c__10835__auto__);

return statearr_24473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_24683){
var state_val_24684 = (state_24683[(1)]);
if((state_val_24684 === (7))){
var inst_24657 = (state_24683[(7)]);
var inst_24647 = (state_24683[(8)]);
var inst_24655 = fluree.db.flake.Flake__GT_parts(inst_24647);
var inst_24656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24655,(0),null);
var inst_24657__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24655,(1),null);
var inst_24658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24655,(2),null);
var inst_24659 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24655,(3),null);
var inst_24660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24655,(4),null);
var inst_24661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24655,(5),null);
var inst_24662 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_24658,inst_24657__$1);
var state_24683__$1 = (function (){var statearr_24685 = state_24683;
(statearr_24685[(9)] = inst_24656);

(statearr_24685[(7)] = inst_24657__$1);

(statearr_24685[(10)] = inst_24659);

(statearr_24685[(11)] = inst_24660);

(statearr_24685[(12)] = inst_24661);

return statearr_24685;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24683__$1,(10),inst_24662);
} else {
if((state_val_24684 === (1))){
var inst_24635 = flakes;
var inst_24636 = cljs.core.seq(inst_24635);
var inst_24637 = cljs.core.first(inst_24636);
var inst_24638 = cljs.core.next(inst_24636);
var inst_24639 = cljs.core.PersistentVector.EMPTY;
var inst_24640 = inst_24635;
var inst_24641 = inst_24639;
var state_24683__$1 = (function (){var statearr_24686 = state_24683;
(statearr_24686[(13)] = inst_24641);

(statearr_24686[(14)] = inst_24640);

(statearr_24686[(15)] = inst_24637);

(statearr_24686[(16)] = inst_24638);

return statearr_24686;
})();
var statearr_24687_24705 = state_24683__$1;
(statearr_24687_24705[(2)] = null);

(statearr_24687_24705[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24684 === (4))){
var inst_24647 = (state_24683[(8)]);
var inst_24650 = fluree.db.query.range.is_tag_flake_QMARK_(inst_24647);
var state_24683__$1 = state_24683;
if(inst_24650){
var statearr_24688_24706 = state_24683__$1;
(statearr_24688_24706[(1)] = (7));

} else {
var statearr_24689_24707 = state_24683__$1;
(statearr_24689_24707[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24684 === (6))){
var inst_24679 = (state_24683[(2)]);
var state_24683__$1 = state_24683;
var statearr_24690_24708 = state_24683__$1;
(statearr_24690_24708[(2)] = inst_24679);

(statearr_24690_24708[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24684 === (3))){
var inst_24681 = (state_24683[(2)]);
var state_24683__$1 = state_24683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24683__$1,inst_24681);
} else {
if((state_val_24684 === (2))){
var inst_24647 = (state_24683[(8)]);
var inst_24640 = (state_24683[(14)]);
var inst_24646 = cljs.core.seq(inst_24640);
var inst_24647__$1 = cljs.core.first(inst_24646);
var inst_24648 = cljs.core.next(inst_24646);
var state_24683__$1 = (function (){var statearr_24691 = state_24683;
(statearr_24691[(8)] = inst_24647__$1);

(statearr_24691[(17)] = inst_24648);

return statearr_24691;
})();
if(cljs.core.truth_(inst_24647__$1)){
var statearr_24692_24709 = state_24683__$1;
(statearr_24692_24709[(1)] = (4));

} else {
var statearr_24693_24710 = state_24683__$1;
(statearr_24693_24710[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24684 === (9))){
var inst_24676 = (state_24683[(2)]);
var state_24683__$1 = state_24683;
var statearr_24694_24711 = state_24683__$1;
(statearr_24694_24711[(2)] = inst_24676);

(statearr_24694_24711[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24684 === (5))){
var inst_24641 = (state_24683[(13)]);
var state_24683__$1 = state_24683;
var statearr_24695_24712 = state_24683__$1;
(statearr_24695_24712[(2)] = inst_24641);

(statearr_24695_24712[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24684 === (10))){
var inst_24656 = (state_24683[(9)]);
var inst_24641 = (state_24683[(13)]);
var inst_24657 = (state_24683[(7)]);
var inst_24659 = (state_24683[(10)]);
var inst_24660 = (state_24683[(11)]);
var inst_24648 = (state_24683[(17)]);
var inst_24661 = (state_24683[(12)]);
var inst_24664 = (state_24683[(2)]);
var inst_24665 = fluree.db.util.async.throw_err(inst_24664);
var inst_24666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24667 = [inst_24656,inst_24657,inst_24665,inst_24659,inst_24660,inst_24661];
var inst_24668 = (new cljs.core.PersistentVector(null,6,(5),inst_24666,inst_24667,null));
var inst_24669 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_24668);
var inst_24670 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24641,inst_24669);
var inst_24640 = inst_24648;
var inst_24641__$1 = inst_24670;
var state_24683__$1 = (function (){var statearr_24696 = state_24683;
(statearr_24696[(13)] = inst_24641__$1);

(statearr_24696[(14)] = inst_24640);

return statearr_24696;
})();
var statearr_24697_24713 = state_24683__$1;
(statearr_24697_24713[(2)] = null);

(statearr_24697_24713[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24684 === (8))){
var inst_24641 = (state_24683[(13)]);
var inst_24647 = (state_24683[(8)]);
var inst_24648 = (state_24683[(17)]);
var inst_24673 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24641,inst_24647);
var inst_24640 = inst_24648;
var inst_24641__$1 = inst_24673;
var state_24683__$1 = (function (){var statearr_24698 = state_24683;
(statearr_24698[(13)] = inst_24641__$1);

(statearr_24698[(14)] = inst_24640);

return statearr_24698;
})();
var statearr_24699_24714 = state_24683__$1;
(statearr_24699_24714[(2)] = null);

(statearr_24699_24714[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto____0 = (function (){
var statearr_24700 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24700[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto__);

(statearr_24700[(1)] = (1));

return statearr_24700;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto____1 = (function (state_24683){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_24683);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e24701){var ex__10801__auto__ = e24701;
var statearr_24702_24715 = state_24683;
(statearr_24702_24715[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_24683[(4)]))){
var statearr_24703_24716 = state_24683;
(statearr_24703_24716[(1)] = cljs.core.first((state_24683[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__24717 = state_24683;
state_24683 = G__24717;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto__ = function(state_24683){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto____1.call(this,state_24683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_24704 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_24704[(6)] = c__10835__auto__);

return statearr_24704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__24719 = arguments.length;
switch (G__24719) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_24889){
var state_val_24890 = (state_24889[(1)]);
if((state_val_24890 === (65))){
var state_24889__$1 = state_24889;
var statearr_24891_24991 = state_24889__$1;
(statearr_24891_24991[(2)] = null);

(statearr_24891_24991[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (70))){
var inst_24884 = (state_24889[(2)]);
var _ = (function (){var statearr_24892 = state_24889;
(statearr_24892[(4)] = cljs.core.rest((state_24889[(4)])));

return statearr_24892;
})();
var state_24889__$1 = state_24889;
var statearr_24893_24992 = state_24889__$1;
(statearr_24893_24992[(2)] = inst_24884);

(statearr_24893_24992[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (62))){
var inst_24870 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24894_24993 = state_24889__$1;
(statearr_24894_24993[(2)] = inst_24870);

(statearr_24894_24993[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (7))){
var state_24889__$1 = state_24889;
var statearr_24895_24994 = state_24889__$1;
(statearr_24895_24994[(2)] = false);

(statearr_24895_24994[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (59))){
var inst_24844 = (state_24889[(2)]);
var inst_24845 = fluree.db.util.async.throw_err(inst_24844);
var state_24889__$1 = state_24889;
var statearr_24896_24995 = state_24889__$1;
(statearr_24896_24995[(2)] = inst_24845);

(statearr_24896_24995[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (20))){
var state_24889__$1 = state_24889;
var statearr_24897_24996 = state_24889__$1;
(statearr_24897_24996[(2)] = null);

(statearr_24897_24996[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (58))){
var inst_24834 = (state_24889[(2)]);
var inst_24835 = fluree.db.util.async.throw_err(inst_24834);
var inst_24836 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_24835);
var state_24889__$1 = state_24889;
var statearr_24898_24997 = state_24889__$1;
(statearr_24898_24997[(2)] = inst_24836);

(statearr_24898_24997[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (60))){
var inst_24731 = (state_24889[(7)]);
var inst_24733 = (state_24889[(8)]);
var inst_24770 = (state_24889[(9)]);
var inst_24730 = (state_24889[(10)]);
var inst_24850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24851 = [inst_24731,inst_24730,inst_24770,inst_24733];
var inst_24852 = (new cljs.core.PersistentVector(null,4,(5),inst_24850,inst_24851,null));
var inst_24853 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_24852,opts);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24889__$1,(63),inst_24853);
} else {
if((state_val_24890 === (27))){
var inst_24781 = (state_24889[(11)]);
var inst_24770 = (state_24889[(9)]);
var inst_24781__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_24770);
var state_24889__$1 = (function (){var statearr_24899 = state_24889;
(statearr_24899[(11)] = inst_24781__$1);

return statearr_24899;
})();
if(inst_24781__$1){
var statearr_24900_24998 = state_24889__$1;
(statearr_24900_24998[(1)] = (30));

} else {
var statearr_24901_24999 = state_24889__$1;
(statearr_24901_24999[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (1))){
var state_24889__$1 = state_24889;
var statearr_24902_25000 = state_24889__$1;
(statearr_24902_25000[(2)] = null);

(statearr_24902_25000[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (69))){
var inst_24876 = (state_24889[(12)]);
var state_24889__$1 = state_24889;
var statearr_24903_25001 = state_24889__$1;
(statearr_24903_25001[(2)] = inst_24876);

(statearr_24903_25001[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (24))){
var inst_24731 = (state_24889[(7)]);
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24731)){
var statearr_24904_25002 = state_24889__$1;
(statearr_24904_25002[(1)] = (27));

} else {
var statearr_24905_25003 = state_24889__$1;
(statearr_24905_25003[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (55))){
var inst_24770 = (state_24889[(9)]);
var inst_24828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24829 = [inst_24770];
var inst_24830 = (new cljs.core.PersistentVector(null,1,(5),inst_24828,inst_24829,null));
var inst_24831 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$limit,(1));
var inst_24832 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_24830,inst_24831);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24889__$1,(58),inst_24832);
} else {
if((state_val_24890 === (39))){
var inst_24801 = (state_24889[(2)]);
var inst_24802 = fluree.db.util.async.throw_err(inst_24801);
var state_24889__$1 = state_24889;
var statearr_24906_25004 = state_24889__$1;
(statearr_24906_25004[(2)] = inst_24802);

(statearr_24906_25004[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (46))){
var inst_24814 = (state_24889[(13)]);
var inst_24814__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_24889__$1 = (function (){var statearr_24907 = state_24889;
(statearr_24907[(13)] = inst_24814__$1);

return statearr_24907;
})();
if(cljs.core.truth_(inst_24814__$1)){
var statearr_24908_25005 = state_24889__$1;
(statearr_24908_25005[(1)] = (49));

} else {
var statearr_24909_25006 = state_24889__$1;
(statearr_24909_25006[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (4))){
var inst_24720 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24910_25007 = state_24889__$1;
(statearr_24910_25007[(2)] = inst_24720);

(statearr_24910_25007[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (54))){
var inst_24826 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24826)){
var statearr_24911_25008 = state_24889__$1;
(statearr_24911_25008[(1)] = (55));

} else {
var statearr_24912_25009 = state_24889__$1;
(statearr_24912_25009[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (15))){
var inst_24732 = (state_24889[(14)]);
var inst_24751 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_24732);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24889__$1,(18),inst_24751);
} else {
if((state_val_24890 === (48))){
var inst_24872 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24913_25010 = state_24889__$1;
(statearr_24913_25010[(2)] = inst_24872);

(statearr_24913_25010[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (50))){
var inst_24745 = (state_24889[(15)]);
var inst_24814 = (state_24889[(13)]);
var inst_24731 = (state_24889[(7)]);
var inst_24733 = (state_24889[(8)]);
var inst_24734 = (state_24889[(16)]);
var inst_24770 = (state_24889[(9)]);
var inst_24730 = (state_24889[(10)]);
var inst_24729 = (state_24889[(17)]);
var inst_24740 = (state_24889[(18)]);
var inst_24818 = (function (){var t = inst_24733;
var p = inst_24731;
var idx_predicate_QMARK_ = inst_24734;
var o = inst_24770;
var tag_predicate_QMARK_ = inst_24740;
var temp__5751__auto__ = inst_24814;
var s = inst_24730;
var o_coerce_QMARK_ = inst_24745;
var vec__24726 = inst_24729;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_24889__$1 = state_24889;
var statearr_24914_25011 = state_24889__$1;
(statearr_24914_25011[(2)] = inst_24818);

(statearr_24914_25011[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (21))){
var inst_24766 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24915_25012 = state_24889__$1;
(statearr_24915_25012[(2)] = inst_24766);

(statearr_24915_25012[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (31))){
var inst_24781 = (state_24889[(11)]);
var state_24889__$1 = state_24889;
var statearr_24916_25013 = state_24889__$1;
(statearr_24916_25013[(2)] = inst_24781);

(statearr_24916_25013[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (32))){
var inst_24791 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24917_25014 = state_24889__$1;
(statearr_24917_25014[(2)] = inst_24791);

(statearr_24917_25014[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (40))){
var inst_24805 = (state_24889[(19)]);
var inst_24734 = (state_24889[(16)]);
var inst_24805__$1 = cljs.core.not(inst_24734);
var state_24889__$1 = (function (){var statearr_24918 = state_24889;
(statearr_24918[(19)] = inst_24805__$1);

return statearr_24918;
})();
if(inst_24805__$1){
var statearr_24919_25015 = state_24889__$1;
(statearr_24919_25015[(1)] = (43));

} else {
var statearr_24920_25016 = state_24889__$1;
(statearr_24920_25016[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (56))){
var inst_24731 = (state_24889[(7)]);
var inst_24733 = (state_24889[(8)]);
var inst_24820 = (state_24889[(20)]);
var inst_24730 = (state_24889[(10)]);
var inst_24838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24839 = [inst_24731,inst_24730,null,inst_24733];
var inst_24840 = (new cljs.core.PersistentVector(null,4,(5),inst_24838,inst_24839,null));
var inst_24841 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_24820);
var inst_24842 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_24840,inst_24841);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24889__$1,(59),inst_24842);
} else {
if((state_val_24890 === (33))){
var inst_24770 = (state_24889[(9)]);
var inst_24784 = cljs.core.fn_QMARK_(inst_24770);
var inst_24785 = (!(inst_24784));
var state_24889__$1 = state_24889;
var statearr_24921_25017 = state_24889__$1;
(statearr_24921_25017[(2)] = inst_24785);

(statearr_24921_25017[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (13))){
var inst_24732 = (state_24889[(14)]);
var inst_24749 = fluree.db.query.range.tag_string_QMARK_(inst_24732);
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24749)){
var statearr_24922_25018 = state_24889__$1;
(statearr_24922_25018[(1)] = (15));

} else {
var statearr_24923_25019 = state_24889__$1;
(statearr_24923_25019[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (22))){
var inst_24762 = (state_24889[(2)]);
var inst_24763 = fluree.db.util.async.throw_err(inst_24762);
var state_24889__$1 = state_24889;
var statearr_24924_25020 = state_24889__$1;
(statearr_24924_25020[(2)] = inst_24763);

(statearr_24924_25020[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (36))){
var inst_24731 = (state_24889[(7)]);
var inst_24733 = (state_24889[(8)]);
var inst_24770 = (state_24889[(9)]);
var inst_24730 = (state_24889[(10)]);
var inst_24796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24797 = [inst_24731,inst_24770,inst_24730,inst_24733];
var inst_24798 = (new cljs.core.PersistentVector(null,4,(5),inst_24796,inst_24797,null));
var inst_24799 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_24798,opts);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24889__$1,(39),inst_24799);
} else {
if((state_val_24890 === (41))){
var inst_24731 = (state_24889[(7)]);
var state_24889__$1 = state_24889;
var statearr_24925_25021 = state_24889__$1;
(statearr_24925_25021[(2)] = inst_24731);

(statearr_24925_25021[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (43))){
var inst_24770 = (state_24889[(9)]);
var state_24889__$1 = state_24889;
var statearr_24926_25022 = state_24889__$1;
(statearr_24926_25022[(2)] = inst_24770);

(statearr_24926_25022[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (61))){
var inst_24770 = (state_24889[(9)]);
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24770)){
var statearr_24927_25023 = state_24889__$1;
(statearr_24927_25023[(1)] = (64));

} else {
var statearr_24928_25024 = state_24889__$1;
(statearr_24928_25024[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (29))){
var inst_24794 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24794)){
var statearr_24929_25025 = state_24889__$1;
(statearr_24929_25025[(1)] = (36));

} else {
var statearr_24930_25026 = state_24889__$1;
(statearr_24930_25026[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (44))){
var inst_24805 = (state_24889[(19)]);
var state_24889__$1 = state_24889;
var statearr_24931_25027 = state_24889__$1;
(statearr_24931_25027[(2)] = inst_24805);

(statearr_24931_25027[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (6))){
var inst_24731 = (state_24889[(7)]);
var inst_24736 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_24731);
var inst_24737 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_24736);
var state_24889__$1 = state_24889;
var statearr_24932_25028 = state_24889__$1;
(statearr_24932_25028[(2)] = inst_24737);

(statearr_24932_25028[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (28))){
var inst_24731 = (state_24889[(7)]);
var state_24889__$1 = state_24889;
var statearr_24933_25029 = state_24889__$1;
(statearr_24933_25029[(2)] = inst_24731);

(statearr_24933_25029[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (64))){
var inst_24731 = (state_24889[(7)]);
var inst_24733 = (state_24889[(8)]);
var inst_24770 = (state_24889[(9)]);
var inst_24730 = (state_24889[(10)]);
var inst_24859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24860 = [inst_24770,inst_24731,inst_24730,inst_24733];
var inst_24861 = (new cljs.core.PersistentVector(null,4,(5),inst_24859,inst_24860,null));
var inst_24862 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_24861,opts);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24889__$1,(67),inst_24862);
} else {
if((state_val_24890 === (51))){
var inst_24731 = (state_24889[(7)]);
var inst_24821 = (state_24889[(21)]);
var inst_24820 = (state_24889[(2)]);
var inst_24821__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_24731);
var state_24889__$1 = (function (){var statearr_24934 = state_24889;
(statearr_24934[(21)] = inst_24821__$1);

(statearr_24934[(20)] = inst_24820);

return statearr_24934;
})();
if(inst_24821__$1){
var statearr_24935_25030 = state_24889__$1;
(statearr_24935_25030[(1)] = (52));

} else {
var statearr_24936_25031 = state_24889__$1;
(statearr_24936_25031[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (25))){
var inst_24740 = (state_24889[(18)]);
var inst_24876 = (state_24889[(2)]);
var state_24889__$1 = (function (){var statearr_24937 = state_24889;
(statearr_24937[(12)] = inst_24876);

return statearr_24937;
})();
if(cljs.core.truth_(inst_24740)){
var statearr_24938_25032 = state_24889__$1;
(statearr_24938_25032[(1)] = (68));

} else {
var statearr_24939_25033 = state_24889__$1;
(statearr_24939_25033[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (34))){
var inst_24734 = (state_24889[(16)]);
var state_24889__$1 = state_24889;
var statearr_24940_25034 = state_24889__$1;
(statearr_24940_25034[(2)] = inst_24734);

(statearr_24940_25034[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (17))){
var inst_24768 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24941_25035 = state_24889__$1;
(statearr_24941_25035[(2)] = inst_24768);

(statearr_24941_25035[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (3))){
var inst_24887 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24889__$1,inst_24887);
} else {
if((state_val_24890 === (12))){
var inst_24732 = (state_24889[(14)]);
var state_24889__$1 = state_24889;
var statearr_24942_25036 = state_24889__$1;
(statearr_24942_25036[(2)] = inst_24732);

(statearr_24942_25036[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (2))){
var inst_24731 = (state_24889[(7)]);
var inst_24729 = (state_24889[(17)]);
var _ = (function (){var statearr_24943 = state_24889;
(statearr_24943[(4)] = cljs.core.cons((5),(state_24889[(4)])));

return statearr_24943;
})();
var inst_24729__$1 = fparts;
var inst_24730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24729__$1,(0),null);
var inst_24731__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24729__$1,(1),null);
var inst_24732 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24729__$1,(2),null);
var inst_24733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24729__$1,(3),null);
var inst_24734 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_24731__$1);
var state_24889__$1 = (function (){var statearr_24944 = state_24889;
(statearr_24944[(7)] = inst_24731__$1);

(statearr_24944[(8)] = inst_24733);

(statearr_24944[(14)] = inst_24732);

(statearr_24944[(16)] = inst_24734);

(statearr_24944[(10)] = inst_24730);

(statearr_24944[(17)] = inst_24729__$1);

return statearr_24944;
})();
if(cljs.core.truth_(inst_24731__$1)){
var statearr_24945_25037 = state_24889__$1;
(statearr_24945_25037[(1)] = (6));

} else {
var statearr_24946_25038 = state_24889__$1;
(statearr_24946_25038[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (66))){
var inst_24868 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24947_25039 = state_24889__$1;
(statearr_24947_25039[(2)] = inst_24868);

(statearr_24947_25039[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (23))){
var inst_24731 = (state_24889[(7)]);
var inst_24733 = (state_24889[(8)]);
var inst_24770 = (state_24889[(9)]);
var inst_24730 = (state_24889[(10)]);
var inst_24772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24773 = [inst_24730,inst_24731,inst_24770,inst_24733];
var inst_24774 = (new cljs.core.PersistentVector(null,4,(5),inst_24772,inst_24773,null));
var inst_24775 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_24774,opts);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24889__$1,(26),inst_24775);
} else {
if((state_val_24890 === (47))){
var inst_24731 = (state_24889[(7)]);
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24731)){
var statearr_24948_25040 = state_24889__$1;
(statearr_24948_25040[(1)] = (60));

} else {
var statearr_24949_25041 = state_24889__$1;
(statearr_24949_25041[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (35))){
var inst_24788 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24950_25042 = state_24889__$1;
(statearr_24950_25042[(2)] = inst_24788);

(statearr_24950_25042[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (19))){
var inst_24731 = (state_24889[(7)]);
var inst_24732 = (state_24889[(14)]);
var inst_24758 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_24731);
var inst_24759 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24758),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24732)].join('');
var inst_24760 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_24759);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24889__$1,(22),inst_24760);
} else {
if((state_val_24890 === (57))){
var inst_24847 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24951_25043 = state_24889__$1;
(statearr_24951_25043[(2)] = inst_24847);

(statearr_24951_25043[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (68))){
var inst_24876 = (state_24889[(12)]);
var inst_24878 = fluree.db.query.range.coerce_tag_flakes(db,inst_24876);
var state_24889__$1 = state_24889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24889__$1,(71),inst_24878);
} else {
if((state_val_24890 === (11))){
var inst_24745 = (state_24889[(15)]);
var inst_24745__$1 = (state_24889[(2)]);
var inst_24746 = cljs.core.not(inst_24745__$1);
var state_24889__$1 = (function (){var statearr_24953 = state_24889;
(statearr_24953[(15)] = inst_24745__$1);

return statearr_24953;
})();
if(inst_24746){
var statearr_24954_25044 = state_24889__$1;
(statearr_24954_25044[(1)] = (12));

} else {
var statearr_24955_25045 = state_24889__$1;
(statearr_24955_25045[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (9))){
var inst_24732 = (state_24889[(14)]);
var inst_24742 = typeof inst_24732 === 'string';
var state_24889__$1 = state_24889;
var statearr_24956_25046 = state_24889__$1;
(statearr_24956_25046[(2)] = inst_24742);

(statearr_24956_25046[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (5))){
var _ = (function (){var statearr_24957 = state_24889;
(statearr_24957[(4)] = cljs.core.rest((state_24889[(4)])));

return statearr_24957;
})();
var state_24889__$1 = state_24889;
var ex24952 = (state_24889__$1[(2)]);
var statearr_24958_25047 = state_24889__$1;
(statearr_24958_25047[(5)] = ex24952);


if((ex24952 instanceof Error)){
var statearr_24959_25048 = state_24889__$1;
(statearr_24959_25048[(1)] = (4));

(statearr_24959_25048[(5)] = null);

} else {
throw ex24952;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (14))){
var inst_24730 = (state_24889[(10)]);
var inst_24770 = (state_24889[(2)]);
var state_24889__$1 = (function (){var statearr_24960 = state_24889;
(statearr_24960[(9)] = inst_24770);

return statearr_24960;
})();
if(cljs.core.truth_(inst_24730)){
var statearr_24961_25049 = state_24889__$1;
(statearr_24961_25049[(1)] = (23));

} else {
var statearr_24962_25050 = state_24889__$1;
(statearr_24962_25050[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (45))){
var inst_24809 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24963_25051 = state_24889__$1;
(statearr_24963_25051[(2)] = inst_24809);

(statearr_24963_25051[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (53))){
var inst_24821 = (state_24889[(21)]);
var state_24889__$1 = state_24889;
var statearr_24964_25052 = state_24889__$1;
(statearr_24964_25052[(2)] = inst_24821);

(statearr_24964_25052[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (26))){
var inst_24777 = (state_24889[(2)]);
var inst_24778 = fluree.db.util.async.throw_err(inst_24777);
var state_24889__$1 = state_24889;
var statearr_24965_25053 = state_24889__$1;
(statearr_24965_25053[(2)] = inst_24778);

(statearr_24965_25053[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (16))){
var inst_24732 = (state_24889[(14)]);
var inst_24756 = typeof inst_24732 === 'string';
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24756)){
var statearr_24966_25054 = state_24889__$1;
(statearr_24966_25054[(1)] = (19));

} else {
var statearr_24967_25055 = state_24889__$1;
(statearr_24967_25055[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (38))){
var inst_24874 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
var statearr_24968_25056 = state_24889__$1;
(statearr_24968_25056[(2)] = inst_24874);

(statearr_24968_25056[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (30))){
var inst_24734 = (state_24889[(16)]);
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24734)){
var statearr_24969_25057 = state_24889__$1;
(statearr_24969_25057[(1)] = (33));

} else {
var statearr_24970_25058 = state_24889__$1;
(statearr_24970_25058[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (10))){
var inst_24740 = (state_24889[(18)]);
var state_24889__$1 = state_24889;
var statearr_24971_25059 = state_24889__$1;
(statearr_24971_25059[(2)] = inst_24740);

(statearr_24971_25059[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (18))){
var inst_24753 = (state_24889[(2)]);
var inst_24754 = fluree.db.util.async.throw_err(inst_24753);
var state_24889__$1 = state_24889;
var statearr_24972_25060 = state_24889__$1;
(statearr_24972_25060[(2)] = inst_24754);

(statearr_24972_25060[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (52))){
var inst_24770 = (state_24889[(9)]);
var inst_24823 = cljs.core.int_QMARK_(inst_24770);
var state_24889__$1 = state_24889;
var statearr_24973_25061 = state_24889__$1;
(statearr_24973_25061[(2)] = inst_24823);

(statearr_24973_25061[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (67))){
var inst_24864 = (state_24889[(2)]);
var inst_24865 = fluree.db.util.async.throw_err(inst_24864);
var state_24889__$1 = state_24889;
var statearr_24974_25062 = state_24889__$1;
(statearr_24974_25062[(2)] = inst_24865);

(statearr_24974_25062[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (71))){
var inst_24880 = (state_24889[(2)]);
var inst_24881 = fluree.db.util.async.throw_err(inst_24880);
var state_24889__$1 = state_24889;
var statearr_24975_25063 = state_24889__$1;
(statearr_24975_25063[(2)] = inst_24881);

(statearr_24975_25063[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (42))){
var inst_24812 = (state_24889[(2)]);
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24812)){
var statearr_24976_25064 = state_24889__$1;
(statearr_24976_25064[(1)] = (46));

} else {
var statearr_24977_25065 = state_24889__$1;
(statearr_24977_25065[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (37))){
var inst_24731 = (state_24889[(7)]);
var state_24889__$1 = state_24889;
if(cljs.core.truth_(inst_24731)){
var statearr_24978_25066 = state_24889__$1;
(statearr_24978_25066[(1)] = (40));

} else {
var statearr_24979_25067 = state_24889__$1;
(statearr_24979_25067[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (63))){
var inst_24855 = (state_24889[(2)]);
var inst_24856 = fluree.db.util.async.throw_err(inst_24855);
var state_24889__$1 = state_24889;
var statearr_24980_25068 = state_24889__$1;
(statearr_24980_25068[(2)] = inst_24856);

(statearr_24980_25068[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (8))){
var inst_24740 = (state_24889[(18)]);
var inst_24740__$1 = (state_24889[(2)]);
var state_24889__$1 = (function (){var statearr_24981 = state_24889;
(statearr_24981[(18)] = inst_24740__$1);

return statearr_24981;
})();
if(cljs.core.truth_(inst_24740__$1)){
var statearr_24982_25069 = state_24889__$1;
(statearr_24982_25069[(1)] = (9));

} else {
var statearr_24983_25070 = state_24889__$1;
(statearr_24983_25070[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24890 === (49))){
var inst_24745 = (state_24889[(15)]);
var inst_24814 = (state_24889[(13)]);
var inst_24731 = (state_24889[(7)]);
var inst_24733 = (state_24889[(8)]);
var inst_24734 = (state_24889[(16)]);
var inst_24770 = (state_24889[(9)]);
var inst_24730 = (state_24889[(10)]);
var inst_24729 = (state_24889[(17)]);
var inst_24740 = (state_24889[(18)]);
var inst_24816 = (function (){var obj_fn = inst_24814;
var t = inst_24733;
var p = inst_24731;
var idx_predicate_QMARK_ = inst_24734;
var o = inst_24770;
var tag_predicate_QMARK_ = inst_24740;
var temp__5751__auto__ = inst_24814;
var s = inst_24730;
var o_coerce_QMARK_ = inst_24745;
var vec__24726 = inst_24729;
return (function (x){
var and__4221__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4221__auto__;
}
});
})();
var state_24889__$1 = state_24889;
var statearr_24984_25071 = state_24889__$1;
(statearr_24984_25071[(2)] = inst_24816);

(statearr_24984_25071[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10798__auto__ = null;
var fluree$db$query$range$state_machine__10798__auto____0 = (function (){
var statearr_24985 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24985[(0)] = fluree$db$query$range$state_machine__10798__auto__);

(statearr_24985[(1)] = (1));

return statearr_24985;
});
var fluree$db$query$range$state_machine__10798__auto____1 = (function (state_24889){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_24889);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e24986){var ex__10801__auto__ = e24986;
var statearr_24987_25072 = state_24889;
(statearr_24987_25072[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_24889[(4)]))){
var statearr_24988_25073 = state_24889;
(statearr_24988_25073[(1)] = cljs.core.first((state_24889[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__25074 = state_24889;
state_24889 = G__25074;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10798__auto__ = function(state_24889){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10798__auto____1.call(this,state_24889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10798__auto____0;
fluree$db$query$range$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10798__auto____1;
return fluree$db$query$range$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_24989 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_24989[(6)] = c__10835__auto__);

return statearr_24989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__25076 = arguments.length;
switch (G__25076) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_25111){
var state_val_25112 = (state_25111[(1)]);
if((state_val_25112 === (7))){
var inst_25098 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_25099 = ["Invalid collection name: ",inst_25098].join('');
var inst_25100 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_25101 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_25102 = cljs.core.PersistentHashMap.fromArrays(inst_25100,inst_25101);
var inst_25103 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25099,inst_25102);
var inst_25104 = (function(){throw inst_25103})();
var state_25111__$1 = state_25111;
var statearr_25113_25133 = state_25111__$1;
(statearr_25113_25133[(2)] = inst_25104);

(statearr_25113_25133[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25112 === (1))){
var state_25111__$1 = state_25111;
var statearr_25114_25134 = state_25111__$1;
(statearr_25114_25134[(2)] = null);

(statearr_25114_25134[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25112 === (4))){
var inst_25077 = (state_25111[(2)]);
var state_25111__$1 = state_25111;
var statearr_25115_25135 = state_25111__$1;
(statearr_25115_25135[(2)] = inst_25077);

(statearr_25115_25135[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25112 === (6))){
var inst_25083 = (state_25111[(7)]);
var inst_25085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25086 = fluree.db.flake.max_subject_id(inst_25083);
var inst_25087 = [inst_25086];
var inst_25088 = (new cljs.core.PersistentVector(null,1,(5),inst_25085,inst_25087,null));
var inst_25089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25090 = fluree.db.flake.min_subject_id(inst_25083);
var inst_25091 = [inst_25090];
var inst_25092 = (new cljs.core.PersistentVector(null,1,(5),inst_25089,inst_25091,null));
var inst_25093 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_25088,cljs.core._LT__EQ_,inst_25092,opts);
var state_25111__$1 = state_25111;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25111__$1,(9),inst_25093);
} else {
if((state_val_25112 === (3))){
var inst_25109 = (state_25111[(2)]);
var state_25111__$1 = state_25111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25111__$1,inst_25109);
} else {
if((state_val_25112 === (2))){
var inst_25083 = (state_25111[(7)]);
var _ = (function (){var statearr_25117 = state_25111;
(statearr_25117[(4)] = cljs.core.cons((5),(state_25111[(4)])));

return statearr_25117;
})();
var inst_25083__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_25111__$1 = (function (){var statearr_25118 = state_25111;
(statearr_25118[(7)] = inst_25083__$1);

return statearr_25118;
})();
if(cljs.core.truth_(inst_25083__$1)){
var statearr_25119_25136 = state_25111__$1;
(statearr_25119_25136[(1)] = (6));

} else {
var statearr_25120_25137 = state_25111__$1;
(statearr_25120_25137[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25112 === (9))){
var inst_25095 = (state_25111[(2)]);
var inst_25096 = fluree.db.util.async.throw_err(inst_25095);
var state_25111__$1 = state_25111;
var statearr_25121_25138 = state_25111__$1;
(statearr_25121_25138[(2)] = inst_25096);

(statearr_25121_25138[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25112 === (5))){
var _ = (function (){var statearr_25122 = state_25111;
(statearr_25122[(4)] = cljs.core.rest((state_25111[(4)])));

return statearr_25122;
})();
var state_25111__$1 = state_25111;
var ex25116 = (state_25111__$1[(2)]);
var statearr_25123_25139 = state_25111__$1;
(statearr_25123_25139[(5)] = ex25116);


var statearr_25124_25140 = state_25111__$1;
(statearr_25124_25140[(1)] = (4));

(statearr_25124_25140[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_25112 === (8))){
var inst_25106 = (state_25111[(2)]);
var _ = (function (){var statearr_25125 = state_25111;
(statearr_25125[(4)] = cljs.core.rest((state_25111[(4)])));

return statearr_25125;
})();
var state_25111__$1 = state_25111;
var statearr_25126_25141 = state_25111__$1;
(statearr_25126_25141[(2)] = inst_25106);

(statearr_25126_25141[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10798__auto__ = null;
var fluree$db$query$range$state_machine__10798__auto____0 = (function (){
var statearr_25127 = [null,null,null,null,null,null,null,null];
(statearr_25127[(0)] = fluree$db$query$range$state_machine__10798__auto__);

(statearr_25127[(1)] = (1));

return statearr_25127;
});
var fluree$db$query$range$state_machine__10798__auto____1 = (function (state_25111){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_25111);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e25128){var ex__10801__auto__ = e25128;
var statearr_25129_25142 = state_25111;
(statearr_25129_25142[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_25111[(4)]))){
var statearr_25130_25143 = state_25111;
(statearr_25130_25143[(1)] = cljs.core.first((state_25111[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__25144 = state_25111;
state_25111 = G__25144;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10798__auto__ = function(state_25111){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10798__auto____1.call(this,state_25111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10798__auto____0;
fluree$db$query$range$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10798__auto____1;
return fluree$db$query$range$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_25131 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_25131[(6)] = c__10835__auto__);

return statearr_25131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__25148 = flakes;
var vec__25149 = G__25148;
var seq__25150 = cljs.core.seq(vec__25149);
var first__25151 = cljs.core.first(seq__25150);
var seq__25150__$1 = cljs.core.next(seq__25150);
var flake_SINGLEQUOTE_ = first__25151;
var r = seq__25150__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__25148__$1 = G__25148;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__25157 = G__25148__$1;
var seq__25158 = cljs.core.seq(vec__25157);
var first__25159 = cljs.core.first(seq__25158);
var seq__25158__$1 = cljs.core.next(seq__25158);
var flake_SINGLEQUOTE___$1 = first__25159;
var r__$1 = seq__25158__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e25161){var e = e25161;
return null;
}})();
var map__25160 = cmd_map;
var map__25160__$1 = cljs.core.__destructure_map(map__25160);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25160__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25160__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25160__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25160__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25160__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25160__$1,cljs.core.cst$kw$expire);
var G__25162 = r__$1;
var G__25163 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__25148__$1 = G__25162;
result_STAR___$1 = G__25163;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__25172 = blocks;
var vec__25173 = G__25172;
var seq__25174 = cljs.core.seq(vec__25173);
var first__25175 = cljs.core.first(seq__25174);
var seq__25174__$1 = cljs.core.next(seq__25174);
var block_SINGLEQUOTE_ = first__25175;
var r = seq__25174__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__25172__$1 = G__25172;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__25180 = G__25172__$1;
var seq__25181 = cljs.core.seq(vec__25180);
var first__25182 = cljs.core.first(seq__25181);
var seq__25181__$1 = cljs.core.next(seq__25181);
var block_SINGLEQUOTE___$1 = first__25182;
var r__$1 = seq__25181__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__25183 = block_SINGLEQUOTE___$1;
var map__25183__$1 = cljs.core.__destructure_map(map__25183);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25183__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25183__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25183__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25164_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__25164_SHARP_.p,(2))){
return p1__25164_SHARP_.o;
} else {
return null;
}
});})(G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,prev_hash,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25165_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__25165_SHARP_.p,(1))){
return p1__25165_SHARP_.o;
} else {
return null;
}
});})(G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,prev_hash,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,prev_hash,hash,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25166_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__25166_SHARP_.p,(5))){
return p1__25166_SHARP_.o;
} else {
return null;
}
});})(G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,prev_hash,hash,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,prev_hash,hash,instant,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25167_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__25167_SHARP_.p,(7))){
return p1__25167_SHARP_.o;
} else {
return null;
}
});})(G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,prev_hash,hash,instant,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25168_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__25168_SHARP_.p,(106));
});})(G__25172__$1,result_STAR___$1,map__25183,map__25183__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__25180,seq__25181,first__25182,seq__25181__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25172,vec__25173,seq__25174,first__25175,seq__25174__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__25184 = r__$1;
var G__25185 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__25172__$1 = G__25184;
result_STAR___$1 = G__25185;
continue;
}
break;
}
});
