// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__31329 = arguments.length;
switch (G__31329) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__31331 = null;
var G__31331__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__31331__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__31331__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + fuel_per));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__31331 = function(result,flake){
switch(arguments.length){
case 0:
return G__31331__0.call(this);
case 1:
return G__31331__1.call(this,result);
case 2:
return G__31331__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31331.cljs$core$IFn$_invoke$arity$0 = G__31331__0;
G__31331.cljs$core$IFn$_invoke$arity$1 = G__31331__1;
G__31331.cljs$core$IFn$_invoke$arity$2 = G__31331__2;
return G__31331;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__31332 = null;
var G__31332__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__31332__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__31332__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__31332 = function(result,flakes){
switch(arguments.length){
case 0:
return G__31332__0.call(this);
case 1:
return G__31332__1.call(this,result);
case 2:
return G__31332__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31332.cljs$core$IFn$_invoke$arity$0 = G__31332__0;
G__31332.cljs$core$IFn$_invoke$arity$1 = G__31332__1;
G__31332.cljs$core$IFn$_invoke$arity$2 = G__31332__2;
return G__31332;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__31334 = res;
var G__31334__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__31333_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__31333_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__31334):G__31334);
var G__31334__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__31334__$1):G__31334__$1);
var G__31334__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__31334__$2):G__31334__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__31334__$3);
} else {
return G__31334__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__31336 = arguments.length;
switch (G__31336) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_31635){
var state_val_31636 = (state_31635[(1)]);
if((state_val_31636 === (65))){
var inst_31376 = (state_31635[(7)]);
var inst_31493 = (state_31635[(8)]);
var inst_31486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31487 = cljs.core.deref(cache);
var inst_31488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31489 = flake.o;
var inst_31490 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_31376);
var inst_31491 = [inst_31489,inst_31490];
var inst_31492 = (new cljs.core.PersistentVector(null,2,(5),inst_31488,inst_31491,null));
var inst_31493__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31487,inst_31492);
var state_31635__$1 = (function (){var statearr_31637 = state_31635;
(statearr_31637[(9)] = inst_31486);

(statearr_31637[(8)] = inst_31493__$1);

return statearr_31637;
})();
if(cljs.core.truth_(inst_31493__$1)){
var statearr_31638_31807 = state_31635__$1;
(statearr_31638_31807[(1)] = (68));

} else {
var statearr_31639_31808 = state_31635__$1;
(statearr_31639_31808[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (70))){
var inst_31486 = (state_31635[(9)]);
var inst_31511 = (state_31635[(2)]);
var inst_31512 = [inst_31511,offset_map];
var inst_31513 = (new cljs.core.PersistentVector(null,2,(5),inst_31486,inst_31512,null));
var state_31635__$1 = state_31635;
var statearr_31640_31809 = state_31635__$1;
(statearr_31640_31809[(2)] = inst_31513);

(statearr_31640_31809[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (62))){
var inst_31394 = (state_31635[(10)]);
var inst_31392 = (state_31635[(11)]);
var inst_31387 = (state_31635[(12)]);
var inst_31393 = (state_31635[(13)]);
var inst_31390 = (state_31635[(14)]);
var inst_31347 = (state_31635[(15)]);
var inst_31391 = (state_31635[(16)]);
var inst_31388 = (state_31635[(17)]);
var inst_31389 = (state_31635[(18)]);
var inst_31376 = (state_31635[(7)]);
var inst_31361 = (state_31635[(19)]);
var inst_31471 = (state_31635[(20)]);
var inst_31455 = (state_31635[(21)]);
var inst_31473 = (function (){var p = inst_31394;
var pred_spec__$1 = inst_31361;
var orderBy = inst_31392;
var nested_select_spec = inst_31455;
var G__31457 = inst_31471;
var multi_QMARK_ = inst_31389;
var limit = inst_31391;
var offset = inst_31393;
var k = inst_31387;
var map__31343 = inst_31388;
var compact_QMARK_ = inst_31347;
var pred_spec_SINGLEQUOTE_ = inst_31376;
var ref_QMARK_ = inst_31390;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_31474 = (inst_31473.cljs$core$IFn$_invoke$arity$1 ? inst_31473.cljs$core$IFn$_invoke$arity$1(inst_31471) : inst_31473.call(null,inst_31471));
var state_31635__$1 = state_31635;
var statearr_31641_31810 = state_31635__$1;
(statearr_31641_31810[(2)] = inst_31474);

(statearr_31641_31810[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (74))){
var inst_31520 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31520)){
var statearr_31642_31811 = state_31635__$1;
(statearr_31642_31811[(1)] = (75));

} else {
var statearr_31643_31812 = state_31635__$1;
(statearr_31643_31812[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (7))){
var inst_31348 = (state_31635[(22)]);
var state_31635__$1 = state_31635;
var statearr_31644_31813 = state_31635__$1;
(statearr_31644_31813[(2)] = inst_31348);

(statearr_31644_31813[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (59))){
var inst_31465 = (state_31635[(23)]);
var inst_31467 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_31468 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_31467,inst_31465);
var state_31635__$1 = state_31635;
var statearr_31645_31814 = state_31635__$1;
(statearr_31645_31814[(2)] = inst_31468);

(statearr_31645_31814[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (86))){
var inst_31551 = (state_31635[(24)]);
var inst_31533 = (state_31635[(25)]);
var inst_31394 = (state_31635[(10)]);
var inst_31392 = (state_31635[(11)]);
var inst_31387 = (state_31635[(12)]);
var inst_31393 = (state_31635[(13)]);
var inst_31390 = (state_31635[(14)]);
var inst_31347 = (state_31635[(15)]);
var inst_31391 = (state_31635[(16)]);
var inst_31388 = (state_31635[(17)]);
var inst_31389 = (state_31635[(18)]);
var inst_31376 = (state_31635[(7)]);
var inst_31361 = (state_31635[(19)]);
var inst_31553 = (function (){var G__31545 = inst_31551;
var p = inst_31394;
var pred_spec__$1 = inst_31361;
var orderBy = inst_31392;
var children = inst_31533;
var multi_QMARK_ = inst_31389;
var limit = inst_31391;
var offset = inst_31393;
var k = inst_31387;
var map__31343 = inst_31388;
var compact_QMARK_ = inst_31347;
var pred_spec_SINGLEQUOTE_ = inst_31376;
var ref_QMARK_ = inst_31390;
return (function (n){
var G__31646 = db;
var G__31647 = cache;
var G__31648 = fuel;
var G__31649 = max_fuel;
var G__31650 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$wildcard_QMARK_,true,cljs.core.cst$kw$compact_QMARK_,compact_QMARK_], null);
var G__31651 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__31646,G__31647,G__31648,G__31649,G__31650,G__31651) : fluree.db.query.fql.flakes__GT_res.call(null,G__31646,G__31647,G__31648,G__31649,G__31650,G__31651));
});
})();
var inst_31554 = (inst_31553.cljs$core$IFn$_invoke$arity$1 ? inst_31553.cljs$core$IFn$_invoke$arity$1(inst_31551) : inst_31553.call(null,inst_31551));
var state_31635__$1 = state_31635;
var statearr_31652_31815 = state_31635__$1;
(statearr_31652_31815[(2)] = inst_31554);

(statearr_31652_31815[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (20))){
var inst_31388 = (state_31635[(17)]);
var inst_31389 = (state_31635[(18)]);
var inst_31376 = (state_31635[(7)]);
var inst_31387 = (state_31635[(2)]);
var inst_31388__$1 = cljs.core.__destructure_map(inst_31376);
var inst_31389__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31388__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_31390 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31388__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_31391 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31388__$1,cljs.core.cst$kw$limit);
var inst_31392 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31388__$1,cljs.core.cst$kw$orderBy);
var inst_31393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31388__$1,cljs.core.cst$kw$offset);
var inst_31394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31388__$1,cljs.core.cst$kw$p);
var state_31635__$1 = (function (){var statearr_31653 = state_31635;
(statearr_31653[(10)] = inst_31394);

(statearr_31653[(11)] = inst_31392);

(statearr_31653[(12)] = inst_31387);

(statearr_31653[(13)] = inst_31393);

(statearr_31653[(14)] = inst_31390);

(statearr_31653[(16)] = inst_31391);

(statearr_31653[(17)] = inst_31388__$1);

(statearr_31653[(18)] = inst_31389__$1);

return statearr_31653;
})();
if(cljs.core.truth_(inst_31389__$1)){
var statearr_31654_31816 = state_31635__$1;
(statearr_31654_31816[(1)] = (24));

} else {
var statearr_31655_31817 = state_31635__$1;
(statearr_31655_31817[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (72))){
var inst_31376 = (state_31635[(7)]);
var inst_31517 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31376);
var state_31635__$1 = state_31635;
var statearr_31656_31818 = state_31635__$1;
(statearr_31656_31818[(2)] = inst_31517);

(statearr_31656_31818[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (58))){
var inst_31464 = (state_31635[(2)]);
var inst_31465 = fluree.db.util.async.throw_err(inst_31464);
var state_31635__$1 = (function (){var statearr_31657 = state_31635;
(statearr_31657[(23)] = inst_31465);

return statearr_31657;
})();
if(cljs.core.truth_(fuel)){
var statearr_31658_31819 = state_31635__$1;
(statearr_31658_31819[(1)] = (59));

} else {
var statearr_31659_31820 = state_31635__$1;
(statearr_31659_31820[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (60))){
var inst_31465 = (state_31635[(23)]);
var state_31635__$1 = state_31635;
var statearr_31660_31821 = state_31635__$1;
(statearr_31660_31821[(2)] = inst_31465);

(statearr_31660_31821[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (27))){
var inst_31393 = (state_31635[(13)]);
var inst_31397 = (state_31635[(26)]);
var inst_31397__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_31393);
var state_31635__$1 = (function (){var statearr_31661 = state_31635;
(statearr_31661[(26)] = inst_31397__$1);

return statearr_31661;
})();
if(inst_31397__$1){
var statearr_31662_31822 = state_31635__$1;
(statearr_31662_31822[(1)] = (30));

} else {
var statearr_31663_31823 = state_31635__$1;
(statearr_31663_31823[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (1))){
var state_31635__$1 = state_31635;
var statearr_31664_31824 = state_31635__$1;
(statearr_31664_31824[(2)] = null);

(statearr_31664_31824[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (69))){
var inst_31376 = (state_31635[(7)]);
var inst_31496 = flake.o;
var inst_31497 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_31376);
var inst_31498 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_31496,inst_31497);
var state_31635__$1 = state_31635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31635__$1,(71),inst_31498);
} else {
if((state_val_31636 === (101))){
var inst_31387 = (state_31635[(12)]);
var inst_31595 = (state_31635[(27)]);
var inst_31596 = (state_31635[(28)]);
var inst_31615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31616 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_31387,inst_31595);
var inst_31617 = [inst_31616,inst_31596];
var inst_31618 = (new cljs.core.PersistentVector(null,2,(5),inst_31615,inst_31617,null));
var state_31635__$1 = state_31635;
var statearr_31665_31825 = state_31635__$1;
(statearr_31665_31825[(2)] = inst_31618);

(statearr_31665_31825[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (24))){
var inst_31393 = (state_31635[(13)]);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31393)){
var statearr_31666_31826 = state_31635__$1;
(statearr_31666_31826[(1)] = (27));

} else {
var statearr_31667_31827 = state_31635__$1;
(statearr_31667_31827[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (102))){
var state_31635__$1 = state_31635;
var statearr_31668_31828 = state_31635__$1;
(statearr_31668_31828[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (55))){
var inst_31376 = (state_31635[(7)]);
var inst_31484 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31376);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31484)){
var statearr_31670_31829 = state_31635__$1;
(statearr_31670_31829[(1)] = (65));

} else {
var statearr_31671_31830 = state_31635__$1;
(statearr_31671_31830[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (85))){
var inst_31551 = (state_31635[(2)]);
var state_31635__$1 = (function (){var statearr_31672 = state_31635;
(statearr_31672[(24)] = inst_31551);

return statearr_31672;
})();
var statearr_31673_31831 = state_31635__$1;
(statearr_31673_31831[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (39))){
var inst_31392 = (state_31635[(11)]);
var inst_31424 = (state_31635[(29)]);
var inst_31424__$1 = cljs.core.not(inst_31392);
var state_31635__$1 = (function (){var statearr_31675 = state_31635;
(statearr_31675[(29)] = inst_31424__$1);

return statearr_31675;
})();
if(inst_31424__$1){
var statearr_31676_31832 = state_31635__$1;
(statearr_31676_31832[(1)] = (42));

} else {
var statearr_31677_31833 = state_31635__$1;
(statearr_31677_31833[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (88))){
var inst_31557 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31635__$1,(82),inst_31557);
} else {
if((state_val_31636 === (46))){
var inst_31440 = (state_31635[(30)]);
var inst_31440__$1 = cljs.core.not(recur_QMARK_);
var state_31635__$1 = (function (){var statearr_31678 = state_31635;
(statearr_31678[(30)] = inst_31440__$1);

return statearr_31678;
})();
if(inst_31440__$1){
var statearr_31679_31834 = state_31635__$1;
(statearr_31679_31834[(1)] = (48));

} else {
var statearr_31680_31835 = state_31635__$1;
(statearr_31680_31835[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (4))){
var inst_31337 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31681_31836 = state_31635__$1;
(statearr_31681_31836[(2)] = inst_31337);

(statearr_31681_31836[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (77))){
var inst_31586 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31682_31837 = state_31635__$1;
(statearr_31682_31837[(2)] = inst_31586);

(statearr_31682_31837[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (106))){
var inst_31626 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31683_31838 = state_31635__$1;
(statearr_31683_31838[(2)] = inst_31626);

(statearr_31683_31838[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (95))){
var inst_31389 = (state_31635[(18)]);
var state_31635__$1 = state_31635;
var statearr_31684_31839 = state_31635__$1;
(statearr_31684_31839[(2)] = inst_31389);

(statearr_31684_31839[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (54))){
var inst_31376 = (state_31635[(7)]);
var inst_31452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31453 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_31454 = (new cljs.core.PersistentVector(null,3,(5),inst_31452,inst_31453,null));
var inst_31455 = cljs.core.select_keys(inst_31376,inst_31454);
var inst_31456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31459 = flake.o;
var inst_31460 = [inst_31459];
var inst_31461 = (new cljs.core.PersistentVector(null,1,(5),inst_31458,inst_31460,null));
var inst_31462 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31461);
var state_31635__$1 = (function (){var statearr_31685 = state_31635;
(statearr_31685[(31)] = inst_31456);

(statearr_31685[(21)] = inst_31455);

return statearr_31685;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31635__$1,(58),inst_31462);
} else {
if((state_val_31636 === (92))){
var inst_31576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31577 = flake.o;
var inst_31578 = [inst_31577,offset_map];
var inst_31579 = (new cljs.core.PersistentVector(null,2,(5),inst_31576,inst_31578,null));
var state_31635__$1 = state_31635;
var statearr_31686_31840 = state_31635__$1;
(statearr_31686_31840[(2)] = inst_31579);

(statearr_31686_31840[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (104))){
var inst_31596 = (state_31635[(28)]);
var inst_31621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31622 = [acc,inst_31596];
var inst_31623 = (new cljs.core.PersistentVector(null,2,(5),inst_31621,inst_31622,null));
var state_31635__$1 = state_31635;
var statearr_31687_31841 = state_31635__$1;
(statearr_31687_31841[(2)] = inst_31623);

(statearr_31687_31841[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (15))){
var inst_31347 = (state_31635[(15)]);
var inst_31369 = (state_31635[(32)]);
var inst_31373 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31369,cljs.core.cst$kw$compact_QMARK_,inst_31347);
var state_31635__$1 = state_31635;
var statearr_31688_31842 = state_31635__$1;
(statearr_31688_31842[(2)] = inst_31373);

(statearr_31688_31842[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (48))){
var inst_31442 = (state_31635[(33)]);
var inst_31376 = (state_31635[(7)]);
var inst_31442__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_31376);
var state_31635__$1 = (function (){var statearr_31689 = state_31635;
(statearr_31689[(33)] = inst_31442__$1);

return statearr_31689;
})();
if(cljs.core.truth_(inst_31442__$1)){
var statearr_31690_31843 = state_31635__$1;
(statearr_31690_31843[(1)] = (51));

} else {
var statearr_31691_31844 = state_31635__$1;
(statearr_31691_31844[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (50))){
var inst_31450 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31450)){
var statearr_31692_31845 = state_31635__$1;
(statearr_31692_31845[(1)] = (54));

} else {
var statearr_31693_31846 = state_31635__$1;
(statearr_31693_31846[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (75))){
var inst_31376 = (state_31635[(7)]);
var inst_31522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31523 = flake.o;
var inst_31524 = [inst_31523];
var inst_31525 = (new cljs.core.PersistentVector(null,1,(5),inst_31522,inst_31524,null));
var inst_31526 = [cljs.core.cst$kw$limit];
var inst_31527 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_31376);
var inst_31528 = [inst_31527];
var inst_31529 = cljs.core.PersistentHashMap.fromArrays(inst_31526,inst_31528);
var inst_31530 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31525,inst_31529);
var state_31635__$1 = state_31635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31635__$1,(78),inst_31530);
} else {
if((state_val_31636 === (99))){
var inst_31595 = (state_31635[(27)]);
var inst_31612 = (inst_31595 == null);
var inst_31613 = cljs.core.not(inst_31612);
var state_31635__$1 = state_31635;
if(inst_31613){
var statearr_31694_31847 = state_31635__$1;
(statearr_31694_31847[(1)] = (101));

} else {
var statearr_31695_31848 = state_31635__$1;
(statearr_31695_31848[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (21))){
var inst_31380 = (state_31635[(34)]);
var state_31635__$1 = state_31635;
var statearr_31696_31849 = state_31635__$1;
(statearr_31696_31849[(2)] = inst_31380);

(statearr_31696_31849[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (31))){
var inst_31397 = (state_31635[(26)]);
var state_31635__$1 = state_31635;
var statearr_31697_31850 = state_31635__$1;
(statearr_31697_31850[(2)] = inst_31397);

(statearr_31697_31850[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (32))){
var inst_31403 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31698_31851 = state_31635__$1;
(statearr_31698_31851[(2)] = inst_31403);

(statearr_31698_31851[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (40))){
var inst_31389 = (state_31635[(18)]);
var state_31635__$1 = state_31635;
var statearr_31699_31852 = state_31635__$1;
(statearr_31699_31852[(2)] = inst_31389);

(statearr_31699_31852[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (91))){
var inst_31584 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31700_31853 = state_31635__$1;
(statearr_31700_31853[(2)] = inst_31584);

(statearr_31700_31853[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (56))){
var inst_31590 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31701_31854 = state_31635__$1;
(statearr_31701_31854[(2)] = inst_31590);

(statearr_31701_31854[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (33))){
var inst_31394 = (state_31635[(10)]);
var inst_31411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_31394);
var state_31635__$1 = (function (){var statearr_31702 = state_31635;
(statearr_31702[(35)] = inst_31411);

return statearr_31702;
})();
if(cljs.core.truth_(inst_31412)){
var statearr_31703_31855 = state_31635__$1;
(statearr_31703_31855[(1)] = (36));

} else {
var statearr_31704_31856 = state_31635__$1;
(statearr_31704_31856[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (13))){
var inst_31361 = (state_31635[(19)]);
var state_31635__$1 = state_31635;
var statearr_31705_31857 = state_31635__$1;
(statearr_31705_31857[(2)] = inst_31361);

(statearr_31705_31857[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (22))){
var inst_31376 = (state_31635[(7)]);
var inst_31383 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_31376);
var state_31635__$1 = state_31635;
var statearr_31706_31858 = state_31635__$1;
(statearr_31706_31858[(2)] = inst_31383);

(statearr_31706_31858[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (90))){
var state_31635__$1 = state_31635;
var statearr_31707_31859 = state_31635__$1;
(statearr_31707_31859[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (36))){
var inst_31394 = (state_31635[(10)]);
var inst_31414 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_31394,cljs.core.dec);
var state_31635__$1 = state_31635;
var statearr_31709_31860 = state_31635__$1;
(statearr_31709_31860[(2)] = inst_31414);

(statearr_31709_31860[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (41))){
var inst_31434 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31434)){
var statearr_31710_31861 = state_31635__$1;
(statearr_31710_31861[(1)] = (45));

} else {
var statearr_31711_31862 = state_31635__$1;
(statearr_31711_31862[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (89))){
var inst_31567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31568 = [cljs.core.cst$kw$_id];
var inst_31569 = flake.o;
var inst_31570 = [inst_31569];
var inst_31571 = cljs.core.PersistentHashMap.fromArrays(inst_31568,inst_31570);
var inst_31572 = [inst_31571,offset_map];
var inst_31573 = (new cljs.core.PersistentVector(null,2,(5),inst_31567,inst_31572,null));
var state_31635__$1 = state_31635;
var statearr_31712_31863 = state_31635__$1;
(statearr_31712_31863[(2)] = inst_31573);

(statearr_31712_31863[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (100))){
var inst_31630 = (state_31635[(2)]);
var _ = (function (){var statearr_31713 = state_31635;
(statearr_31713[(4)] = cljs.core.rest((state_31635[(4)])));

return statearr_31713;
})();
var state_31635__$1 = state_31635;
var statearr_31714_31864 = state_31635__$1;
(statearr_31714_31864[(2)] = inst_31630);

(statearr_31714_31864[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (43))){
var inst_31424 = (state_31635[(29)]);
var state_31635__$1 = state_31635;
var statearr_31715_31865 = state_31635__$1;
(statearr_31715_31865[(2)] = inst_31424);

(statearr_31715_31865[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (61))){
var inst_31471 = (state_31635[(2)]);
var state_31635__$1 = (function (){var statearr_31716 = state_31635;
(statearr_31716[(20)] = inst_31471);

return statearr_31716;
})();
var statearr_31717_31866 = state_31635__$1;
(statearr_31717_31866[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (29))){
var inst_31406 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31719_31867 = state_31635__$1;
(statearr_31719_31867[(2)] = inst_31406);

(statearr_31719_31867[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (44))){
var inst_31431 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31720_31868 = state_31635__$1;
(statearr_31720_31868[(2)] = inst_31431);

(statearr_31720_31868[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (93))){
var state_31635__$1 = state_31635;
var statearr_31721_31869 = state_31635__$1;
(statearr_31721_31869[(2)] = null);

(statearr_31721_31869[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (6))){
var inst_31350 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_31351 = (inst_31350 == null);
var state_31635__$1 = state_31635;
var statearr_31722_31870 = state_31635__$1;
(statearr_31722_31870[(2)] = inst_31351);

(statearr_31722_31870[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (28))){
var inst_31393 = (state_31635[(13)]);
var state_31635__$1 = state_31635;
var statearr_31723_31871 = state_31635__$1;
(statearr_31723_31871[(2)] = inst_31393);

(statearr_31723_31871[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (64))){
var inst_31477 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31635__$1,(57),inst_31477);
} else {
if((state_val_31636 === (103))){
var inst_31628 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31724_31872 = state_31635__$1;
(statearr_31724_31872[(2)] = inst_31628);

(statearr_31724_31872[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (51))){
var inst_31442 = (state_31635[(33)]);
var state_31635__$1 = state_31635;
var statearr_31725_31873 = state_31635__$1;
(statearr_31725_31873[(2)] = inst_31442);

(statearr_31725_31873[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (25))){
var inst_31389 = (state_31635[(18)]);
var state_31635__$1 = state_31635;
var statearr_31726_31874 = state_31635__$1;
(statearr_31726_31874[(2)] = inst_31389);

(statearr_31726_31874[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (34))){
var inst_31389 = (state_31635[(18)]);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31389)){
var statearr_31727_31875 = state_31635__$1;
(statearr_31727_31875[(1)] = (39));

} else {
var statearr_31728_31876 = state_31635__$1;
(statearr_31728_31876[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (17))){
var inst_31376 = (state_31635[(7)]);
var inst_31377 = (state_31635[(36)]);
var inst_31376__$1 = (state_31635[(2)]);
var inst_31377__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_31376__$1);
var state_31635__$1 = (function (){var statearr_31729 = state_31635;
(statearr_31729[(7)] = inst_31376__$1);

(statearr_31729[(36)] = inst_31377__$1);

return statearr_31729;
})();
if(cljs.core.truth_(inst_31377__$1)){
var statearr_31730_31877 = state_31635__$1;
(statearr_31730_31877[(1)] = (18));

} else {
var statearr_31731_31878 = state_31635__$1;
(statearr_31731_31878[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (3))){
var inst_31633 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31635__$1,inst_31633);
} else {
if((state_val_31636 === (12))){
var inst_31361 = (state_31635[(19)]);
var inst_31366 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31361,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_31635__$1 = state_31635;
var statearr_31732_31879 = state_31635__$1;
(statearr_31732_31879[(2)] = inst_31366);

(statearr_31732_31879[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (2))){
var inst_31348 = (state_31635[(22)]);
var _ = (function (){var statearr_31733 = state_31635;
(statearr_31733[(4)] = cljs.core.cons((5),(state_31635[(4)])));

return statearr_31733;
})();
var inst_31347 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_31348__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_31635__$1 = (function (){var statearr_31734 = state_31635;
(statearr_31734[(15)] = inst_31347);

(statearr_31734[(22)] = inst_31348__$1);

return statearr_31734;
})();
if(cljs.core.truth_(inst_31348__$1)){
var statearr_31735_31880 = state_31635__$1;
(statearr_31735_31880[(1)] = (6));

} else {
var statearr_31736_31881 = state_31635__$1;
(statearr_31736_31881[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (66))){
var inst_31515 = (state_31635[(37)]);
var inst_31515__$1 = componentFollow_QMARK_;
var state_31635__$1 = (function (){var statearr_31737 = state_31635;
(statearr_31737[(37)] = inst_31515__$1);

return statearr_31737;
})();
if(cljs.core.truth_(inst_31515__$1)){
var statearr_31738_31882 = state_31635__$1;
(statearr_31738_31882[(1)] = (72));

} else {
var statearr_31739_31883 = state_31635__$1;
(statearr_31739_31883[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (23))){
var inst_31385 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31740_31884 = state_31635__$1;
(statearr_31740_31884[(2)] = inst_31385);

(statearr_31740_31884[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (47))){
var inst_31592 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31741_31885 = state_31635__$1;
(statearr_31741_31885[(2)] = inst_31592);

(statearr_31741_31885[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (35))){
var inst_31595 = (state_31635[(27)]);
var inst_31598 = (state_31635[(38)]);
var inst_31594 = (state_31635[(2)]);
var inst_31595__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31594,(0),null);
var inst_31596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31594,(1),null);
var inst_31597 = (inst_31595__$1 == null);
var inst_31598__$1 = cljs.core.not(inst_31597);
var state_31635__$1 = (function (){var statearr_31742 = state_31635;
(statearr_31742[(27)] = inst_31595__$1);

(statearr_31742[(38)] = inst_31598__$1);

(statearr_31742[(28)] = inst_31596);

return statearr_31742;
})();
if(inst_31598__$1){
var statearr_31743_31886 = state_31635__$1;
(statearr_31743_31886[(1)] = (95));

} else {
var statearr_31744_31887 = state_31635__$1;
(statearr_31744_31887[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (82))){
var inst_31544 = (state_31635[(39)]);
var inst_31559 = (state_31635[(2)]);
var inst_31560 = fluree.db.util.async.throw_err(inst_31559);
var inst_31561 = [inst_31560,offset_map];
var inst_31562 = (new cljs.core.PersistentVector(null,2,(5),inst_31544,inst_31561,null));
var state_31635__$1 = state_31635;
var statearr_31745_31888 = state_31635__$1;
(statearr_31745_31888[(2)] = inst_31562);

(statearr_31745_31888[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (76))){
var inst_31390 = (state_31635[(14)]);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31390)){
var statearr_31746_31889 = state_31635__$1;
(statearr_31746_31889[(1)] = (89));

} else {
var statearr_31747_31890 = state_31635__$1;
(statearr_31747_31890[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (97))){
var inst_31602 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31602)){
var statearr_31748_31891 = state_31635__$1;
(statearr_31748_31891[(1)] = (98));

} else {
var statearr_31749_31892 = state_31635__$1;
(statearr_31749_31892[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (19))){
var inst_31380 = (state_31635[(34)]);
var inst_31376 = (state_31635[(7)]);
var inst_31380__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_31376);
var state_31635__$1 = (function (){var statearr_31750 = state_31635;
(statearr_31750[(34)] = inst_31380__$1);

return statearr_31750;
})();
if(cljs.core.truth_(inst_31380__$1)){
var statearr_31751_31893 = state_31635__$1;
(statearr_31751_31893[(1)] = (21));

} else {
var statearr_31752_31894 = state_31635__$1;
(statearr_31752_31894[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (57))){
var inst_31456 = (state_31635[(31)]);
var inst_31479 = (state_31635[(2)]);
var inst_31480 = fluree.db.util.async.throw_err(inst_31479);
var inst_31481 = [inst_31480,offset_map];
var inst_31482 = (new cljs.core.PersistentVector(null,2,(5),inst_31456,inst_31481,null));
var state_31635__$1 = state_31635;
var statearr_31753_31895 = state_31635__$1;
(statearr_31753_31895[(2)] = inst_31482);

(statearr_31753_31895[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (68))){
var inst_31493 = (state_31635[(8)]);
var state_31635__$1 = state_31635;
var statearr_31754_31896 = state_31635__$1;
(statearr_31754_31896[(2)] = inst_31493);

(statearr_31754_31896[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (11))){
var inst_31361 = (state_31635[(19)]);
var inst_31361__$1 = (state_31635[(2)]);
var inst_31363 = cljs.core.contains_QMARK_(inst_31361__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_31364 = (!(inst_31363));
var state_31635__$1 = (function (){var statearr_31756 = state_31635;
(statearr_31756[(19)] = inst_31361__$1);

return statearr_31756;
})();
if(inst_31364){
var statearr_31757_31897 = state_31635__$1;
(statearr_31757_31897[(1)] = (12));

} else {
var statearr_31758_31898 = state_31635__$1;
(statearr_31758_31898[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (9))){
var inst_31356 = flake.p;
var inst_31357 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_31358 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_31356,inst_31357);
var state_31635__$1 = state_31635;
var statearr_31759_31899 = state_31635__$1;
(statearr_31759_31899[(2)] = inst_31358);

(statearr_31759_31899[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (5))){
var _ = (function (){var statearr_31760 = state_31635;
(statearr_31760[(4)] = cljs.core.rest((state_31635[(4)])));

return statearr_31760;
})();
var state_31635__$1 = state_31635;
var ex31755 = (state_31635__$1[(2)]);
var statearr_31761_31900 = state_31635__$1;
(statearr_31761_31900[(5)] = ex31755);


if((ex31755 instanceof Error)){
var statearr_31762_31901 = state_31635__$1;
(statearr_31762_31901[(1)] = (4));

(statearr_31762_31901[(5)] = null);

} else {
throw ex31755;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (83))){
var inst_31533 = (state_31635[(25)]);
var inst_31547 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_31548 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_31547,inst_31533);
var state_31635__$1 = state_31635;
var statearr_31763_31902 = state_31635__$1;
(statearr_31763_31902[(2)] = inst_31548);

(statearr_31763_31902[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (14))){
var inst_31361 = (state_31635[(19)]);
var inst_31369 = (state_31635[(2)]);
var inst_31370 = cljs.core.contains_QMARK_(inst_31361,cljs.core.cst$kw$compact_QMARK_);
var inst_31371 = (!(inst_31370));
var state_31635__$1 = (function (){var statearr_31764 = state_31635;
(statearr_31764[(32)] = inst_31369);

return statearr_31764;
})();
if(inst_31371){
var statearr_31765_31903 = state_31635__$1;
(statearr_31765_31903[(1)] = (15));

} else {
var statearr_31766_31904 = state_31635__$1;
(statearr_31766_31904[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (45))){
var inst_31436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31437 = [null,offset_map];
var inst_31438 = (new cljs.core.PersistentVector(null,2,(5),inst_31436,inst_31437,null));
var state_31635__$1 = state_31635;
var statearr_31767_31905 = state_31635__$1;
(statearr_31767_31905[(2)] = inst_31438);

(statearr_31767_31905[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (53))){
var inst_31447 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31768_31906 = state_31635__$1;
(statearr_31768_31906[(2)] = inst_31447);

(statearr_31768_31906[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (78))){
var inst_31533 = (state_31635[(25)]);
var inst_31532 = (state_31635[(2)]);
var inst_31533__$1 = fluree.db.util.async.throw_err(inst_31532);
var inst_31534 = cljs.core.empty_QMARK_(inst_31533__$1);
var state_31635__$1 = (function (){var statearr_31769 = state_31635;
(statearr_31769[(25)] = inst_31533__$1);

return statearr_31769;
})();
if(inst_31534){
var statearr_31770_31907 = state_31635__$1;
(statearr_31770_31907[(1)] = (79));

} else {
var statearr_31771_31908 = state_31635__$1;
(statearr_31771_31908[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (26))){
var inst_31409 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31409)){
var statearr_31772_31909 = state_31635__$1;
(statearr_31772_31909[(1)] = (33));

} else {
var statearr_31773_31910 = state_31635__$1;
(statearr_31773_31910[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (16))){
var inst_31369 = (state_31635[(32)]);
var state_31635__$1 = state_31635;
var statearr_31774_31911 = state_31635__$1;
(statearr_31774_31911[(2)] = inst_31369);

(statearr_31774_31911[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (81))){
var inst_31564 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31775_31912 = state_31635__$1;
(statearr_31775_31912[(2)] = inst_31564);

(statearr_31775_31912[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (79))){
var inst_31536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31537 = [cljs.core.cst$kw$_id];
var inst_31538 = flake.o;
var inst_31539 = [inst_31538];
var inst_31540 = cljs.core.PersistentHashMap.fromArrays(inst_31537,inst_31539);
var inst_31541 = [inst_31540,offset_map];
var inst_31542 = (new cljs.core.PersistentVector(null,2,(5),inst_31536,inst_31541,null));
var state_31635__$1 = state_31635;
var statearr_31776_31913 = state_31635__$1;
(statearr_31776_31913[(2)] = inst_31542);

(statearr_31776_31913[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (38))){
var inst_31411 = (state_31635[(35)]);
var inst_31419 = (state_31635[(2)]);
var inst_31420 = [null,inst_31419];
var inst_31421 = (new cljs.core.PersistentVector(null,2,(5),inst_31411,inst_31420,null));
var state_31635__$1 = state_31635;
var statearr_31777_31914 = state_31635__$1;
(statearr_31777_31914[(2)] = inst_31421);

(statearr_31777_31914[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (98))){
var inst_31387 = (state_31635[(12)]);
var inst_31595 = (state_31635[(27)]);
var inst_31596 = (state_31635[(28)]);
var inst_31604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31605 = cljs.core.PersistentVector.EMPTY;
var inst_31606 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_31387,inst_31605);
var inst_31607 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_31606,inst_31595);
var inst_31608 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_31387,inst_31607);
var inst_31609 = [inst_31608,inst_31596];
var inst_31610 = (new cljs.core.PersistentVector(null,2,(5),inst_31604,inst_31609,null));
var state_31635__$1 = state_31635;
var statearr_31778_31915 = state_31635__$1;
(statearr_31778_31915[(2)] = inst_31610);

(statearr_31778_31915[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (87))){
var inst_31551 = (state_31635[(24)]);
var state_31635__$1 = state_31635;
var statearr_31779_31916 = state_31635__$1;
(statearr_31779_31916[(2)] = inst_31551);

(statearr_31779_31916[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (30))){
var inst_31394 = (state_31635[(10)]);
var inst_31399 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_31394);
var inst_31400 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_31399);
var state_31635__$1 = state_31635;
var statearr_31780_31917 = state_31635__$1;
(statearr_31780_31917[(2)] = inst_31400);

(statearr_31780_31917[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (73))){
var inst_31515 = (state_31635[(37)]);
var state_31635__$1 = state_31635;
var statearr_31781_31918 = state_31635__$1;
(statearr_31781_31918[(2)] = inst_31515);

(statearr_31781_31918[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (96))){
var inst_31598 = (state_31635[(38)]);
var state_31635__$1 = state_31635;
var statearr_31782_31919 = state_31635__$1;
(statearr_31782_31919[(2)] = inst_31598);

(statearr_31782_31919[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (10))){
var state_31635__$1 = state_31635;
var statearr_31783_31920 = state_31635__$1;
(statearr_31783_31920[(2)] = pred_spec);

(statearr_31783_31920[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (18))){
var inst_31377 = (state_31635[(36)]);
var state_31635__$1 = state_31635;
var statearr_31784_31921 = state_31635__$1;
(statearr_31784_31921[(2)] = inst_31377);

(statearr_31784_31921[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (105))){
var state_31635__$1 = state_31635;
var statearr_31785_31922 = state_31635__$1;
(statearr_31785_31922[(2)] = null);

(statearr_31785_31922[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (52))){
var inst_31376 = (state_31635[(7)]);
var inst_31445 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31376);
var state_31635__$1 = state_31635;
var statearr_31786_31923 = state_31635__$1;
(statearr_31786_31923[(2)] = inst_31445);

(statearr_31786_31923[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (67))){
var inst_31588 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31787_31924 = state_31635__$1;
(statearr_31787_31924[(2)] = inst_31588);

(statearr_31787_31924[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (71))){
var inst_31376 = (state_31635[(7)]);
var inst_31500 = (state_31635[(2)]);
var inst_31501 = fluree.db.util.async.throw_err(inst_31500);
var inst_31502 = cljs.core._deref(cache);
var inst_31503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31504 = flake.o;
var inst_31505 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_31376);
var inst_31506 = [inst_31504,inst_31505];
var inst_31507 = (new cljs.core.PersistentVector(null,2,(5),inst_31503,inst_31506,null));
var inst_31508 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31502,inst_31507,inst_31501);
var inst_31509 = cljs.core._vreset_BANG_(cache,inst_31508);
var state_31635__$1 = (function (){var statearr_31788 = state_31635;
(statearr_31788[(40)] = inst_31509);

return statearr_31788;
})();
var statearr_31789_31925 = state_31635__$1;
(statearr_31789_31925[(2)] = inst_31501);

(statearr_31789_31925[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (42))){
var inst_31387 = (state_31635[(12)]);
var inst_31391 = (state_31635[(16)]);
var inst_31426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_31387);
var inst_31427 = cljs.core.count(inst_31426);
var inst_31428 = (inst_31427 >= inst_31391);
var state_31635__$1 = state_31635;
var statearr_31790_31926 = state_31635__$1;
(statearr_31790_31926[(2)] = inst_31428);

(statearr_31790_31926[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (80))){
var inst_31544 = cljs.core.PersistentVector.EMPTY_NODE;
var state_31635__$1 = (function (){var statearr_31791 = state_31635;
(statearr_31791[(39)] = inst_31544);

return statearr_31791;
})();
if(cljs.core.truth_(fuel)){
var statearr_31792_31927 = state_31635__$1;
(statearr_31792_31927[(1)] = (83));

} else {
var statearr_31793_31928 = state_31635__$1;
(statearr_31793_31928[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (37))){
var inst_31394 = (state_31635[(10)]);
var inst_31393 = (state_31635[(13)]);
var inst_31416 = (inst_31393 - (1));
var inst_31417 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_31394,inst_31416);
var state_31635__$1 = state_31635;
var statearr_31794_31929 = state_31635__$1;
(statearr_31794_31929[(2)] = inst_31417);

(statearr_31794_31929[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (63))){
var inst_31471 = (state_31635[(20)]);
var state_31635__$1 = state_31635;
var statearr_31795_31930 = state_31635__$1;
(statearr_31795_31930[(2)] = inst_31471);

(statearr_31795_31930[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (94))){
var inst_31582 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
var statearr_31796_31931 = state_31635__$1;
(statearr_31796_31931[(2)] = inst_31582);

(statearr_31796_31931[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (8))){
var inst_31354 = (state_31635[(2)]);
var state_31635__$1 = state_31635;
if(cljs.core.truth_(inst_31354)){
var statearr_31797_31932 = state_31635__$1;
(statearr_31797_31932[(1)] = (9));

} else {
var statearr_31798_31933 = state_31635__$1;
(statearr_31798_31933[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (49))){
var inst_31440 = (state_31635[(30)]);
var state_31635__$1 = state_31635;
var statearr_31799_31934 = state_31635__$1;
(statearr_31799_31934[(2)] = inst_31440);

(statearr_31799_31934[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31636 === (84))){
var inst_31533 = (state_31635[(25)]);
var state_31635__$1 = state_31635;
var statearr_31800_31935 = state_31635__$1;
(statearr_31800_31935[(2)] = inst_31533);

(statearr_31800_31935[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10798__auto__ = null;
var fluree$db$query$fql$state_machine__10798__auto____0 = (function (){
var statearr_31801 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31801[(0)] = fluree$db$query$fql$state_machine__10798__auto__);

(statearr_31801[(1)] = (1));

return statearr_31801;
});
var fluree$db$query$fql$state_machine__10798__auto____1 = (function (state_31635){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_31635);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e31802){var ex__10801__auto__ = e31802;
var statearr_31803_31936 = state_31635;
(statearr_31803_31936[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_31635[(4)]))){
var statearr_31804_31937 = state_31635;
(statearr_31804_31937[(1)] = cljs.core.first((state_31635[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__31938 = state_31635;
state_31635 = G__31938;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10798__auto__ = function(state_31635){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10798__auto____1.call(this,state_31635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10798__auto____0;
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10798__auto____1;
return fluree$db$query$fql$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_31805 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_31805[(6)] = c__10835__auto__);

return statearr_31805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_32098){
var state_val_32099 = (state_32098[(1)]);
if((state_val_32099 === (7))){
var inst_32093 = (state_32098[(2)]);
var _ = (function (){var statearr_32100 = state_32098;
(statearr_32100[(4)] = cljs.core.rest((state_32098[(4)])));

return statearr_32100;
})();
var state_32098__$1 = state_32098;
var statearr_32101_32183 = state_32098__$1;
(statearr_32101_32183[(2)] = inst_32093);

(statearr_32101_32183[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (20))){
var inst_32020 = (state_32098[(7)]);
var state_32098__$1 = state_32098;
var statearr_32102_32184 = state_32098__$1;
(statearr_32102_32184[(2)] = inst_32020);

(statearr_32102_32184[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (27))){
var inst_31975 = (state_32098[(8)]);
var state_32098__$1 = state_32098;
if(cljs.core.truth_(inst_31975)){
var statearr_32103_32185 = state_32098__$1;
(statearr_32103_32185[(1)] = (29));

} else {
var statearr_32104_32186 = state_32098__$1;
(statearr_32104_32186[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (1))){
var state_32098__$1 = state_32098;
var statearr_32105_32187 = state_32098__$1;
(statearr_32105_32187[(2)] = null);

(statearr_32105_32187[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (24))){
var inst_31976 = (state_32098[(9)]);
var state_32098__$1 = state_32098;
var statearr_32106_32188 = state_32098__$1;
(statearr_32106_32188[(2)] = inst_31976);

(statearr_32106_32188[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (39))){
var inst_32012 = (state_32098[(10)]);
var state_32098__$1 = state_32098;
var statearr_32107_32189 = state_32098__$1;
(statearr_32107_32189[(2)] = inst_32012);

(statearr_32107_32189[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (46))){
var inst_31977 = (state_32098[(11)]);
var state_32098__$1 = state_32098;
var statearr_32108_32190 = state_32098__$1;
(statearr_32108_32190[(2)] = inst_31977);

(statearr_32108_32190[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (4))){
var inst_31939 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
var statearr_32109_32191 = state_32098__$1;
(statearr_32109_32191[(2)] = inst_31939);

(statearr_32109_32191[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (15))){
var inst_31988 = (state_32098[(12)]);
var inst_31994 = cljs.core.count(inst_31988);
var inst_31995 = fluree.db.query.fql.add_fuel(fuel,inst_31994,max_fuel);
var state_32098__$1 = state_32098;
var statearr_32110_32192 = state_32098__$1;
(statearr_32110_32192[(2)] = inst_31995);

(statearr_32110_32192[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (48))){
var inst_32079 = (state_32098[(13)]);
var inst_31964 = (state_32098[(14)]);
var inst_31957 = (state_32098[(15)]);
var inst_32087 = (state_32098[(2)]);
var inst_32088 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31957,inst_32087,inst_32079);
var inst_31956 = inst_31964;
var inst_31957__$1 = inst_32088;
var state_32098__$1 = (function (){var statearr_32111 = state_32098;
(statearr_32111[(16)] = inst_31956);

(statearr_32111[(15)] = inst_31957__$1);

return statearr_32111;
})();
var statearr_32112_32193 = state_32098__$1;
(statearr_32112_32193[(2)] = null);

(statearr_32112_32193[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (50))){
var inst_31979 = (state_32098[(17)]);
var state_32098__$1 = state_32098;
var statearr_32113_32194 = state_32098__$1;
(statearr_32113_32194[(2)] = inst_31979);

(statearr_32113_32194[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (21))){
var inst_31976 = (state_32098[(9)]);
var state_32098__$1 = state_32098;
if(cljs.core.truth_(inst_31976)){
var statearr_32115_32195 = state_32098__$1;
(statearr_32115_32195[(1)] = (23));

} else {
var statearr_32116_32196 = state_32098__$1;
(statearr_32116_32196[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (31))){
var inst_32036 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
if(cljs.core.truth_(inst_32036)){
var statearr_32117_32197 = state_32098__$1;
(statearr_32117_32197[(1)] = (32));

} else {
var statearr_32118_32198 = state_32098__$1;
(statearr_32118_32198[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (32))){
var inst_32011 = (state_32098[(18)]);
var inst_32012 = (state_32098[(10)]);
var inst_32019 = (state_32098[(19)]);
var inst_32038 = (inst_32011 + (1));
var tmp32114 = inst_32012;
var inst_32010 = inst_32019;
var inst_32011__$1 = inst_32038;
var inst_32012__$1 = tmp32114;
var state_32098__$1 = (function (){var statearr_32119 = state_32098;
(statearr_32119[(18)] = inst_32011__$1);

(statearr_32119[(10)] = inst_32012__$1);

(statearr_32119[(20)] = inst_32010);

return statearr_32119;
})();
var statearr_32120_32199 = state_32098__$1;
(statearr_32120_32199[(2)] = null);

(statearr_32120_32199[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (40))){
var state_32098__$1 = state_32098;
if(cljs.core.truth_(fuel)){
var statearr_32121_32200 = state_32098__$1;
(statearr_32121_32200[(1)] = (42));

} else {
var statearr_32122_32201 = state_32098__$1;
(statearr_32122_32201[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (33))){
var state_32098__$1 = state_32098;
var statearr_32123_32202 = state_32098__$1;
(statearr_32123_32202[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (13))){
var inst_31988 = (state_32098[(12)]);
var state_32098__$1 = state_32098;
var statearr_32125_32203 = state_32098__$1;
(statearr_32125_32203[(2)] = inst_31988);

(statearr_32125_32203[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (22))){
var inst_32029 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
if(cljs.core.truth_(inst_32029)){
var statearr_32126_32204 = state_32098__$1;
(statearr_32126_32204[(1)] = (26));

} else {
var statearr_32127_32205 = state_32098__$1;
(statearr_32127_32205[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (36))){
var state_32098__$1 = state_32098;
var statearr_32128_32206 = state_32098__$1;
(statearr_32128_32206[(2)] = null);

(statearr_32128_32206[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (41))){
var inst_32011 = (state_32098[(18)]);
var inst_32019 = (state_32098[(19)]);
var inst_32068 = (state_32098[(2)]);
var inst_32069 = (inst_32011 + (1));
var inst_32010 = inst_32019;
var inst_32011__$1 = inst_32069;
var inst_32012 = inst_32068;
var state_32098__$1 = (function (){var statearr_32129 = state_32098;
(statearr_32129[(18)] = inst_32011__$1);

(statearr_32129[(10)] = inst_32012);

(statearr_32129[(20)] = inst_32010);

return statearr_32129;
})();
var statearr_32130_32207 = state_32098__$1;
(statearr_32130_32207[(2)] = null);

(statearr_32130_32207[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (43))){
var state_32098__$1 = state_32098;
var statearr_32131_32208 = state_32098__$1;
(statearr_32131_32208[(2)] = null);

(statearr_32131_32208[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (29))){
var inst_31975 = (state_32098[(8)]);
var inst_32011 = (state_32098[(18)]);
var inst_32033 = (inst_32011 < inst_31975);
var state_32098__$1 = state_32098;
var statearr_32132_32209 = state_32098__$1;
(statearr_32132_32209[(2)] = inst_32033);

(statearr_32132_32209[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (44))){
var inst_32052 = (state_32098[(21)]);
var inst_32048 = (state_32098[(22)]);
var inst_32061 = (state_32098[(2)]);
var inst_32062 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_32052,inst_32048) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_32052,inst_32048));
var state_32098__$1 = (function (){var statearr_32133 = state_32098;
(statearr_32133[(23)] = inst_32061);

return statearr_32133;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32098__$1,(45),inst_32062);
} else {
if((state_val_32099 === (6))){
var inst_31963 = (state_32098[(24)]);
var inst_31956 = (state_32098[(16)]);
var inst_31962 = cljs.core.seq(inst_31956);
var inst_31963__$1 = cljs.core.first(inst_31962);
var inst_31964 = cljs.core.next(inst_31962);
var inst_31965 = cljs.core.not(inst_31963__$1);
var state_32098__$1 = (function (){var statearr_32134 = state_32098;
(statearr_32134[(24)] = inst_31963__$1);

(statearr_32134[(14)] = inst_31964);

return statearr_32134;
})();
if(inst_31965){
var statearr_32135_32210 = state_32098__$1;
(statearr_32135_32210[(1)] = (8));

} else {
var statearr_32136_32211 = state_32098__$1;
(statearr_32136_32211[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (28))){
var inst_32077 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
var statearr_32137_32212 = state_32098__$1;
(statearr_32137_32212[(2)] = inst_32077);

(statearr_32137_32212[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (51))){
var inst_32085 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
var statearr_32138_32213 = state_32098__$1;
(statearr_32138_32213[(2)] = inst_32085);

(statearr_32138_32213[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (25))){
var inst_32027 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
var statearr_32139_32214 = state_32098__$1;
(statearr_32139_32214[(2)] = inst_32027);

(statearr_32139_32214[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (34))){
var inst_32075 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
var statearr_32140_32215 = state_32098__$1;
(statearr_32140_32215[(2)] = inst_32075);

(statearr_32140_32215[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (17))){
var inst_31988 = (state_32098[(12)]);
var inst_31998 = (state_32098[(2)]);
var inst_32006 = cljs.core.seq(inst_31988);
var inst_32007 = cljs.core.first(inst_32006);
var inst_32008 = cljs.core.next(inst_32006);
var inst_32009 = cljs.core.PersistentVector.EMPTY;
var inst_32010 = inst_31988;
var inst_32011 = (0);
var inst_32012 = inst_32009;
var state_32098__$1 = (function (){var statearr_32141 = state_32098;
(statearr_32141[(18)] = inst_32011);

(statearr_32141[(10)] = inst_32012);

(statearr_32141[(25)] = inst_32007);

(statearr_32141[(26)] = inst_32008);

(statearr_32141[(27)] = inst_31998);

(statearr_32141[(20)] = inst_32010);

return statearr_32141;
})();
var statearr_32142_32216 = state_32098__$1;
(statearr_32142_32216[(2)] = null);

(statearr_32142_32216[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (3))){
var inst_32096 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32098__$1,inst_32096);
} else {
if((state_val_32099 === (12))){
var state_32098__$1 = state_32098;
var statearr_32143_32217 = state_32098__$1;
(statearr_32143_32217[(2)] = fuel);

(statearr_32143_32217[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (2))){
var _ = (function (){var statearr_32144 = state_32098;
(statearr_32144[(4)] = cljs.core.cons((5),(state_32098[(4)])));

return statearr_32144;
})();
var inst_31952 = reverse_refs_specs;
var inst_31953 = cljs.core.seq(inst_31952);
var inst_31954 = cljs.core.first(inst_31953);
var inst_31955 = cljs.core.next(inst_31953);
var inst_31956 = inst_31952;
var inst_31957 = null;
var state_32098__$1 = (function (){var statearr_32145 = state_32098;
(statearr_32145[(28)] = inst_31954);

(statearr_32145[(29)] = inst_31955);

(statearr_32145[(16)] = inst_31956);

(statearr_32145[(15)] = inst_31957);

return statearr_32145;
})();
var statearr_32146_32218 = state_32098__$1;
(statearr_32146_32218[(2)] = null);

(statearr_32146_32218[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (23))){
var inst_31976 = (state_32098[(9)]);
var inst_32011 = (state_32098[(18)]);
var inst_32024 = (inst_32011 >= inst_31976);
var state_32098__$1 = state_32098;
var statearr_32147_32219 = state_32098__$1;
(statearr_32147_32219[(2)] = inst_32024);

(statearr_32147_32219[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (47))){
var inst_31978 = (state_32098[(30)]);
var state_32098__$1 = state_32098;
if(cljs.core.truth_(inst_31978)){
var statearr_32148_32220 = state_32098__$1;
(statearr_32148_32220[(1)] = (49));

} else {
var statearr_32149_32221 = state_32098__$1;
(statearr_32149_32221[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (35))){
var inst_32018 = (state_32098[(31)]);
var inst_32042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32043 = [inst_32018];
var inst_32044 = (new cljs.core.PersistentVector(null,1,(5),inst_32042,inst_32043,null));
var inst_32045 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32044);
var state_32098__$1 = state_32098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32098__$1,(38),inst_32045);
} else {
if((state_val_32099 === (19))){
var inst_31977 = (state_32098[(11)]);
var inst_32079 = (state_32098[(2)]);
var state_32098__$1 = (function (){var statearr_32150 = state_32098;
(statearr_32150[(13)] = inst_32079);

return statearr_32150;
})();
if(cljs.core.truth_(inst_31977)){
var statearr_32151_32222 = state_32098__$1;
(statearr_32151_32222[(1)] = (46));

} else {
var statearr_32152_32223 = state_32098__$1;
(statearr_32152_32223[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (11))){
var inst_31988 = (state_32098[(12)]);
var inst_31985 = (state_32098[(2)]);
var inst_31986 = fluree.db.util.async.throw_err(inst_31985);
var inst_31987 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_31986);
var inst_31988__$1 = cljs.core.not_empty(inst_31987);
var state_32098__$1 = (function (){var statearr_32154 = state_32098;
(statearr_32154[(12)] = inst_31988__$1);

return statearr_32154;
})();
if(cljs.core.truth_(inst_31988__$1)){
var statearr_32155_32224 = state_32098__$1;
(statearr_32155_32224[(1)] = (12));

} else {
var statearr_32156_32225 = state_32098__$1;
(statearr_32156_32225[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (9))){
var inst_31963 = (state_32098[(24)]);
var inst_31973 = (state_32098[(32)]);
var inst_31972 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31963,(0),null);
var inst_31973__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31963,(1),null);
var inst_31974 = cljs.core.__destructure_map(inst_31973__$1);
var inst_31975 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31974,cljs.core.cst$kw$offset);
var inst_31976 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31974,cljs.core.cst$kw$limit);
var inst_31977 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31974,cljs.core.cst$kw$as);
var inst_31978 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31974,cljs.core.cst$kw$name);
var inst_31979 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31974,cljs.core.cst$kw$p);
var inst_31980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31981 = [subject_id,inst_31972];
var inst_31982 = (new cljs.core.PersistentVector(null,2,(5),inst_31980,inst_31981,null));
var inst_31983 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_31982);
var state_32098__$1 = (function (){var statearr_32157 = state_32098;
(statearr_32157[(8)] = inst_31975);

(statearr_32157[(9)] = inst_31976);

(statearr_32157[(11)] = inst_31977);

(statearr_32157[(17)] = inst_31979);

(statearr_32157[(30)] = inst_31978);

(statearr_32157[(32)] = inst_31973__$1);

return statearr_32157;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32098__$1,(11),inst_31983);
} else {
if((state_val_32099 === (5))){
var _ = (function (){var statearr_32158 = state_32098;
(statearr_32158[(4)] = cljs.core.rest((state_32098[(4)])));

return statearr_32158;
})();
var state_32098__$1 = state_32098;
var ex32153 = (state_32098__$1[(2)]);
var statearr_32159_32226 = state_32098__$1;
(statearr_32159_32226[(5)] = ex32153);


if((ex32153 instanceof Error)){
var statearr_32160_32227 = state_32098__$1;
(statearr_32160_32227[(1)] = (4));

(statearr_32160_32227[(5)] = null);

} else {
throw ex32153;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (14))){
var inst_31992 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
if(cljs.core.truth_(inst_31992)){
var statearr_32161_32228 = state_32098__$1;
(statearr_32161_32228[(1)] = (15));

} else {
var statearr_32162_32229 = state_32098__$1;
(statearr_32162_32229[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (45))){
var inst_32012 = (state_32098[(10)]);
var inst_32064 = (state_32098[(2)]);
var inst_32065 = fluree.db.util.async.throw_err(inst_32064);
var inst_32066 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32012,inst_32065);
var state_32098__$1 = state_32098;
var statearr_32163_32230 = state_32098__$1;
(statearr_32163_32230[(2)] = inst_32066);

(statearr_32163_32230[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (26))){
var inst_32012 = (state_32098[(10)]);
var state_32098__$1 = state_32098;
var statearr_32164_32231 = state_32098__$1;
(statearr_32164_32231[(2)] = inst_32012);

(statearr_32164_32231[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (16))){
var state_32098__$1 = state_32098;
var statearr_32165_32232 = state_32098__$1;
(statearr_32165_32232[(2)] = null);

(statearr_32165_32232[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (38))){
var inst_32048 = (state_32098[(22)]);
var inst_31973 = (state_32098[(32)]);
var inst_32047 = (state_32098[(2)]);
var inst_32048__$1 = fluree.db.util.async.throw_err(inst_32047);
var inst_32049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32050 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_32051 = (new cljs.core.PersistentVector(null,4,(5),inst_32049,inst_32050,null));
var inst_32052 = cljs.core.select_keys(inst_31973,inst_32051);
var inst_32053 = cljs.core.empty_QMARK_(inst_32048__$1);
var state_32098__$1 = (function (){var statearr_32166 = state_32098;
(statearr_32166[(21)] = inst_32052);

(statearr_32166[(22)] = inst_32048__$1);

return statearr_32166;
})();
if(inst_32053){
var statearr_32167_32233 = state_32098__$1;
(statearr_32167_32233[(1)] = (39));

} else {
var statearr_32168_32234 = state_32098__$1;
(statearr_32168_32234[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (30))){
var inst_31975 = (state_32098[(8)]);
var state_32098__$1 = state_32098;
var statearr_32169_32235 = state_32098__$1;
(statearr_32169_32235[(2)] = inst_31975);

(statearr_32169_32235[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (10))){
var inst_32091 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
var statearr_32170_32236 = state_32098__$1;
(statearr_32170_32236[(2)] = inst_32091);

(statearr_32170_32236[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (18))){
var inst_32018 = (state_32098[(31)]);
var inst_32020 = (state_32098[(7)]);
var inst_32010 = (state_32098[(20)]);
var inst_32017 = cljs.core.seq(inst_32010);
var inst_32018__$1 = cljs.core.first(inst_32017);
var inst_32019 = cljs.core.next(inst_32017);
var inst_32020__$1 = cljs.core.not(inst_32018__$1);
var state_32098__$1 = (function (){var statearr_32171 = state_32098;
(statearr_32171[(31)] = inst_32018__$1);

(statearr_32171[(7)] = inst_32020__$1);

(statearr_32171[(19)] = inst_32019);

return statearr_32171;
})();
if(inst_32020__$1){
var statearr_32172_32237 = state_32098__$1;
(statearr_32172_32237[(1)] = (20));

} else {
var statearr_32173_32238 = state_32098__$1;
(statearr_32173_32238[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (42))){
var inst_32048 = (state_32098[(22)]);
var inst_32057 = cljs.core.count(inst_32048);
var inst_32058 = fluree.db.query.fql.add_fuel(fuel,inst_32057,max_fuel);
var state_32098__$1 = state_32098;
var statearr_32174_32239 = state_32098__$1;
(statearr_32174_32239[(2)] = inst_32058);

(statearr_32174_32239[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (37))){
var inst_32073 = (state_32098[(2)]);
var state_32098__$1 = state_32098;
var statearr_32175_32240 = state_32098__$1;
(statearr_32175_32240[(2)] = inst_32073);

(statearr_32175_32240[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (8))){
var inst_31957 = (state_32098[(15)]);
var state_32098__$1 = state_32098;
var statearr_32176_32241 = state_32098__$1;
(statearr_32176_32241[(2)] = inst_31957);

(statearr_32176_32241[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32099 === (49))){
var inst_31978 = (state_32098[(30)]);
var state_32098__$1 = state_32098;
var statearr_32177_32242 = state_32098__$1;
(statearr_32177_32242[(2)] = inst_31978);

(statearr_32177_32242[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto____0 = (function (){
var statearr_32178 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32178[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto__);

(statearr_32178[(1)] = (1));

return statearr_32178;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto____1 = (function (state_32098){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_32098);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e32179){var ex__10801__auto__ = e32179;
var statearr_32180_32243 = state_32098;
(statearr_32180_32243[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_32098[(4)]))){
var statearr_32181_32244 = state_32098;
(statearr_32181_32244[(1)] = cljs.core.first((state_32098[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__32245 = state_32098;
state_32098 = G__32245;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto__ = function(state_32098){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto____1.call(this,state_32098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_32182 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_32182[(6)] = c__10835__auto__);

return statearr_32182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__32246 = select_spec;
var map__32246__$1 = cljs.core.__destructure_map(map__32246);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32246__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32246__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_32308){
var state_val_32309 = (state_32308[(1)]);
if((state_val_32309 === (7))){
var inst_32272 = (state_32308[(7)]);
var inst_32274 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_32275 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_32274,inst_32272);
var state_32308__$1 = state_32308;
var statearr_32310_32349 = state_32308__$1;
(statearr_32310_32349[(2)] = inst_32275);

(statearr_32310_32349[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (20))){
var inst_32278 = (state_32308[(8)]);
var inst_32296 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_32297 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_32296,inst_32278) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_32296,inst_32278));
var state_32308__$1 = state_32308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32308__$1,(22),inst_32297);
} else {
if((state_val_32309 === (1))){
var state_32308__$1 = state_32308;
var statearr_32311_32350 = state_32308__$1;
(statearr_32311_32350[(2)] = null);

(statearr_32311_32350[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (4))){
var inst_32247 = (state_32308[(2)]);
var state_32308__$1 = state_32308;
var statearr_32312_32351 = state_32308__$1;
(statearr_32312_32351[(2)] = inst_32247);

(statearr_32312_32351[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (15))){
var inst_32285 = (state_32308[(2)]);
var state_32308__$1 = state_32308;
var statearr_32313_32352 = state_32308__$1;
(statearr_32313_32352[(2)] = inst_32285);

(statearr_32313_32352[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (21))){
var inst_32303 = (state_32308[(2)]);
var _ = (function (){var statearr_32314 = state_32308;
(statearr_32314[(4)] = cljs.core.rest((state_32308[(4)])));

return statearr_32314;
})();
var state_32308__$1 = state_32308;
var statearr_32315_32353 = state_32308__$1;
(statearr_32315_32353[(2)] = inst_32303);

(statearr_32315_32353[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (13))){
var inst_32264 = (state_32308[(9)]);
var state_32308__$1 = state_32308;
var statearr_32316_32354 = state_32308__$1;
(statearr_32316_32354[(2)] = inst_32264);

(statearr_32316_32354[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (22))){
var inst_32258 = (state_32308[(10)]);
var inst_32293 = (state_32308[(11)]);
var inst_32299 = (state_32308[(2)]);
var inst_32300 = fluree.db.util.async.throw_err(inst_32299);
var inst_32301 = (inst_32293.cljs$core$IFn$_invoke$arity$3 ? inst_32293.cljs$core$IFn$_invoke$arity$3(acc,inst_32258,inst_32300) : inst_32293.call(null,acc,inst_32258,inst_32300));
var state_32308__$1 = state_32308;
var statearr_32317_32355 = state_32308__$1;
(statearr_32317_32355[(2)] = inst_32301);

(statearr_32317_32355[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (6))){
var inst_32271 = (state_32308[(2)]);
var inst_32272 = fluree.db.util.async.throw_err(inst_32271);
var state_32308__$1 = (function (){var statearr_32318 = state_32308;
(statearr_32318[(7)] = inst_32272);

return statearr_32318;
})();
if(cljs.core.truth_(fuel)){
var statearr_32319_32356 = state_32308__$1;
(statearr_32319_32356[(1)] = (7));

} else {
var statearr_32320_32357 = state_32308__$1;
(statearr_32320_32357[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (17))){
var inst_32262 = (state_32308[(12)]);
var inst_32258 = (state_32308[(10)]);
var inst_32263 = (state_32308[(13)]);
var inst_32260 = (state_32308[(14)]);
var inst_32287 = (state_32308[(15)]);
var inst_32259 = (state_32308[(16)]);
var inst_32256 = (state_32308[(17)]);
var inst_32254 = (state_32308[(18)]);
var inst_32278 = (state_32308[(8)]);
var inst_32261 = (state_32308[(19)]);
var inst_32264 = (state_32308[(9)]);
var inst_32257 = (state_32308[(20)]);
var inst_32291 = (function (){var recur_seen = inst_32260;
var recur_subject = inst_32254;
var sub_flakes = inst_32278;
var seen_QMARK_ = inst_32263;
var multi_QMARK_ = inst_32257;
var limit = inst_32262;
var recur_depth = inst_32261;
var as = inst_32258;
var map__32253 = inst_32256;
var max_depth_QMARK_ = inst_32264;
var recur = inst_32259;
var stop_QMARK_ = inst_32287;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_32308__$1 = state_32308;
var statearr_32321_32358 = state_32308__$1;
(statearr_32321_32358[(2)] = inst_32291);

(statearr_32321_32358[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (3))){
var inst_32306 = (state_32308[(2)]);
var state_32308__$1 = state_32308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32308__$1,inst_32306);
} else {
if((state_val_32309 === (12))){
var inst_32257 = (state_32308[(20)]);
var inst_32287 = (state_32308[(2)]);
var state_32308__$1 = (function (){var statearr_32322 = state_32308;
(statearr_32322[(15)] = inst_32287);

return statearr_32322;
})();
if(cljs.core.truth_(inst_32257)){
var statearr_32323_32359 = state_32308__$1;
(statearr_32323_32359[(1)] = (16));

} else {
var statearr_32324_32360 = state_32308__$1;
(statearr_32324_32360[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (2))){
var inst_32260 = (state_32308[(14)]);
var inst_32259 = (state_32308[(16)]);
var inst_32256 = (state_32308[(17)]);
var inst_32254 = (state_32308[(18)]);
var inst_32261 = (state_32308[(19)]);
var _ = (function (){var statearr_32325 = state_32308;
(statearr_32325[(4)] = cljs.core.cons((5),(state_32308[(4)])));

return statearr_32325;
})();
var inst_32254__$1 = flake.o;
var inst_32255 = select_spec;
var inst_32256__$1 = cljs.core.__destructure_map(inst_32255);
var inst_32257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32256__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_32258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32256__$1,cljs.core.cst$kw$as);
var inst_32259__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32256__$1,cljs.core.cst$kw$recur);
var inst_32260__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32256__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_32261__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32256__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_32262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32256__$1,cljs.core.cst$kw$limit);
var inst_32263 = cljs.core.contains_QMARK_(inst_32260__$1,inst_32254__$1);
var inst_32264 = (inst_32261__$1 > inst_32259__$1);
var inst_32266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32267 = [inst_32254__$1];
var inst_32268 = (new cljs.core.PersistentVector(null,1,(5),inst_32266,inst_32267,null));
var inst_32269 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32268);
var state_32308__$1 = (function (){var statearr_32326 = state_32308;
(statearr_32326[(12)] = inst_32262);

(statearr_32326[(10)] = inst_32258);

(statearr_32326[(13)] = inst_32263);

(statearr_32326[(14)] = inst_32260__$1);

(statearr_32326[(16)] = inst_32259__$1);

(statearr_32326[(17)] = inst_32256__$1);

(statearr_32326[(18)] = inst_32254__$1);

(statearr_32326[(19)] = inst_32261__$1);

(statearr_32326[(9)] = inst_32264);

(statearr_32326[(20)] = inst_32257);

return statearr_32326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32308__$1,(6),inst_32269);
} else {
if((state_val_32309 === (19))){
var state_32308__$1 = state_32308;
var statearr_32327_32361 = state_32308__$1;
(statearr_32327_32361[(2)] = acc);

(statearr_32327_32361[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (11))){
var inst_32264 = (state_32308[(9)]);
var state_32308__$1 = state_32308;
if(cljs.core.truth_(inst_32264)){
var statearr_32329_32362 = state_32308__$1;
(statearr_32329_32362[(1)] = (13));

} else {
var statearr_32330_32363 = state_32308__$1;
(statearr_32330_32363[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (9))){
var inst_32263 = (state_32308[(13)]);
var inst_32278 = (state_32308[(2)]);
var state_32308__$1 = (function (){var statearr_32331 = state_32308;
(statearr_32331[(8)] = inst_32278);

return statearr_32331;
})();
if(cljs.core.truth_(inst_32263)){
var statearr_32332_32364 = state_32308__$1;
(statearr_32332_32364[(1)] = (10));

} else {
var statearr_32333_32365 = state_32308__$1;
(statearr_32333_32365[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (5))){
var _ = (function (){var statearr_32334 = state_32308;
(statearr_32334[(4)] = cljs.core.rest((state_32308[(4)])));

return statearr_32334;
})();
var state_32308__$1 = state_32308;
var ex32328 = (state_32308__$1[(2)]);
var statearr_32335_32366 = state_32308__$1;
(statearr_32335_32366[(5)] = ex32328);


if((ex32328 instanceof Error)){
var statearr_32336_32367 = state_32308__$1;
(statearr_32336_32367[(1)] = (4));

(statearr_32336_32367[(5)] = null);

} else {
throw ex32328;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (14))){
var inst_32278 = (state_32308[(8)]);
var inst_32283 = cljs.core.empty_QMARK_(inst_32278);
var state_32308__$1 = state_32308;
var statearr_32337_32368 = state_32308__$1;
(statearr_32337_32368[(2)] = inst_32283);

(statearr_32337_32368[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (16))){
var inst_32262 = (state_32308[(12)]);
var inst_32258 = (state_32308[(10)]);
var inst_32263 = (state_32308[(13)]);
var inst_32260 = (state_32308[(14)]);
var inst_32287 = (state_32308[(15)]);
var inst_32259 = (state_32308[(16)]);
var inst_32256 = (state_32308[(17)]);
var inst_32254 = (state_32308[(18)]);
var inst_32278 = (state_32308[(8)]);
var inst_32261 = (state_32308[(19)]);
var inst_32264 = (state_32308[(9)]);
var inst_32257 = (state_32308[(20)]);
var inst_32289 = (function (){var recur_seen = inst_32260;
var recur_subject = inst_32254;
var sub_flakes = inst_32278;
var seen_QMARK_ = inst_32263;
var multi_QMARK_ = inst_32257;
var limit = inst_32262;
var recur_depth = inst_32261;
var as = inst_32258;
var map__32253 = inst_32256;
var max_depth_QMARK_ = inst_32264;
var recur = inst_32259;
var stop_QMARK_ = inst_32287;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_32308__$1 = state_32308;
var statearr_32338_32369 = state_32308__$1;
(statearr_32338_32369[(2)] = inst_32289);

(statearr_32338_32369[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (10))){
var inst_32263 = (state_32308[(13)]);
var state_32308__$1 = state_32308;
var statearr_32339_32370 = state_32308__$1;
(statearr_32339_32370[(2)] = inst_32263);

(statearr_32339_32370[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (18))){
var inst_32287 = (state_32308[(15)]);
var inst_32293 = (state_32308[(2)]);
var state_32308__$1 = (function (){var statearr_32340 = state_32308;
(statearr_32340[(11)] = inst_32293);

return statearr_32340;
})();
if(cljs.core.truth_(inst_32287)){
var statearr_32341_32371 = state_32308__$1;
(statearr_32341_32371[(1)] = (19));

} else {
var statearr_32342_32372 = state_32308__$1;
(statearr_32342_32372[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32309 === (8))){
var inst_32272 = (state_32308[(7)]);
var state_32308__$1 = state_32308;
var statearr_32343_32373 = state_32308__$1;
(statearr_32343_32373[(2)] = inst_32272);

(statearr_32343_32373[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto____0 = (function (){
var statearr_32344 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32344[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto__);

(statearr_32344[(1)] = (1));

return statearr_32344;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto____1 = (function (state_32308){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_32308);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e32345){var ex__10801__auto__ = e32345;
var statearr_32346_32374 = state_32308;
(statearr_32346_32374[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_32308[(4)]))){
var statearr_32347_32375 = state_32308;
(statearr_32347_32375[(1)] = cljs.core.first((state_32308[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__32376 = state_32308;
state_32308 = G__32376;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto__ = function(state_32308){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto____1.call(this,state_32308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_32348 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_32348[(6)] = c__10835__auto__);

return statearr_32348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_32554){
var state_val_32555 = (state_32554[(1)]);
if((state_val_32555 === (7))){
var state_32554__$1 = state_32554;
var statearr_32556_32642 = state_32554__$1;
(statearr_32556_32642[(2)] = null);

(statearr_32556_32642[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (20))){
var inst_32415 = cljs.core.PersistentHashMap.EMPTY;
var state_32554__$1 = state_32554;
var statearr_32557_32643 = state_32554__$1;
(statearr_32557_32643[(2)] = inst_32415);

(statearr_32557_32643[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (27))){
var inst_32397 = (state_32554[(7)]);
var inst_32417 = (state_32554[(8)]);
var inst_32433 = (state_32554[(9)]);
var inst_32403 = (state_32554[(10)]);
var inst_32533 = (state_32554[(2)]);
var inst_32534 = (function (){var top_level_subject = inst_32397;
var select_spec = inst_32403;
var base_acc = inst_32417;
var acc_PLUS_refs = inst_32433;
var result = inst_32533;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_32535 = cljs.core.PersistentVector.EMPTY;
var inst_32536 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_32403);
var inst_32537 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_32536);
var inst_32538 = cljs.core.vals(inst_32537);
var inst_32539 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_32403);
var inst_32540 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_32539);
var inst_32541 = cljs.core.vals(inst_32540);
var inst_32542 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_32538,inst_32541);
var inst_32543 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32534,inst_32535,inst_32542);
var inst_32545 = (function (){var top_level_subject = inst_32397;
var select_spec = inst_32403;
var base_acc = inst_32417;
var acc_PLUS_refs = inst_32433;
var result = inst_32533;
var sort_preds = inst_32543;
return (function (acc,p__32544){
var vec__32558 = p__32544;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32558,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32558,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32558,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32558,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_32546 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32545,inst_32533,inst_32543);
var state_32554__$1 = state_32554;
var statearr_32561_32644 = state_32554__$1;
(statearr_32561_32644[(2)] = inst_32546);

(statearr_32561_32644[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (1))){
var state_32554__$1 = state_32554;
var statearr_32562_32645 = state_32554__$1;
(statearr_32562_32645[(2)] = null);

(statearr_32562_32645[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (24))){
var inst_32433 = (state_32554[(9)]);
var inst_32433__$1 = (state_32554[(2)]);
var inst_32434 = flakes;
var inst_32435 = cljs.core.PersistentHashMap.EMPTY;
var inst_32436 = inst_32434;
var inst_32437 = inst_32433__$1;
var inst_32438 = inst_32435;
var state_32554__$1 = (function (){var statearr_32563 = state_32554;
(statearr_32563[(11)] = inst_32436);

(statearr_32563[(9)] = inst_32433__$1);

(statearr_32563[(12)] = inst_32437);

(statearr_32563[(13)] = inst_32438);

return statearr_32563;
})();
var statearr_32564_32646 = state_32554__$1;
(statearr_32564_32646[(2)] = null);

(statearr_32564_32646[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (39))){
var inst_32446 = (state_32554[(14)]);
var inst_32437 = (state_32554[(12)]);
var inst_32452 = (state_32554[(15)]);
var inst_32403 = (state_32554[(10)]);
var inst_32481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32482 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_32437,inst_32403,inst_32446,inst_32452,false);
var state_32554__$1 = (function (){var statearr_32565 = state_32554;
(statearr_32565[(16)] = inst_32481);

return statearr_32565;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32554__$1,(42),inst_32482);
} else {
if((state_val_32555 === (46))){
var inst_32436 = (state_32554[(11)]);
var inst_32446 = (state_32554[(14)]);
var inst_32438 = (state_32554[(13)]);
var inst_32499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32500 = [cljs.core.cst$kw$_id];
var inst_32501 = inst_32446.s;
var inst_32502 = [inst_32501];
var inst_32503 = cljs.core.PersistentHashMap.fromArrays(inst_32500,inst_32502);
var inst_32504 = cljs.core.rest(inst_32436);
var inst_32505 = [inst_32503,inst_32504,inst_32438];
var inst_32506 = (new cljs.core.PersistentVector(null,3,(5),inst_32499,inst_32505,null));
var state_32554__$1 = state_32554;
var statearr_32566_32647 = state_32554__$1;
(statearr_32566_32647[(2)] = inst_32506);

(statearr_32566_32647[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (4))){
var inst_32377 = (state_32554[(2)]);
var state_32554__$1 = state_32554;
var statearr_32567_32648 = state_32554__$1;
(statearr_32567_32648[(2)] = inst_32377);

(statearr_32567_32648[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (15))){
var inst_32404 = (state_32554[(17)]);
var inst_32403 = (state_32554[(10)]);
var inst_32403__$1 = (state_32554[(2)]);
var inst_32404__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_32403__$1);
var state_32554__$1 = (function (){var statearr_32568 = state_32554;
(statearr_32568[(17)] = inst_32404__$1);

(statearr_32568[(10)] = inst_32403__$1);

return statearr_32568;
})();
if(cljs.core.truth_(inst_32404__$1)){
var statearr_32569_32649 = state_32554__$1;
(statearr_32569_32649[(1)] = (16));

} else {
var statearr_32570_32650 = state_32554__$1;
(statearr_32570_32650[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (48))){
var inst_32517 = (state_32554[(2)]);
var state_32554__$1 = state_32554;
var statearr_32571_32651 = state_32554__$1;
(statearr_32571_32651[(2)] = inst_32517);

(statearr_32571_32651[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (50))){
var state_32554__$1 = state_32554;
var statearr_32572_32652 = state_32554__$1;
(statearr_32572_32652[(2)] = null);

(statearr_32572_32652[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (21))){
var inst_32403 = (state_32554[(10)]);
var inst_32417 = (state_32554[(2)]);
var inst_32418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32419 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_32420 = (new cljs.core.PersistentVector(null,2,(5),inst_32418,inst_32419,null));
var inst_32421 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_32403,inst_32420);
var state_32554__$1 = (function (){var statearr_32573 = state_32554;
(statearr_32573[(8)] = inst_32417);

return statearr_32573;
})();
if(cljs.core.truth_(inst_32421)){
var statearr_32574_32653 = state_32554__$1;
(statearr_32574_32653[(1)] = (22));

} else {
var statearr_32575_32654 = state_32554__$1;
(statearr_32575_32654[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (31))){
var inst_32446 = (state_32554[(14)]);
var inst_32437 = (state_32554[(12)]);
var inst_32451 = (state_32554[(18)]);
var inst_32455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32456 = fluree.db.query.fql.flake__GT_recur(db,inst_32446,inst_32451,inst_32437,fuel,max_fuel,cache);
var state_32554__$1 = (function (){var statearr_32576 = state_32554;
(statearr_32576[(19)] = inst_32455);

return statearr_32576;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32554__$1,(34),inst_32456);
} else {
if((state_val_32555 === (32))){
var inst_32451 = (state_32554[(18)]);
var state_32554__$1 = state_32554;
if(cljs.core.truth_(inst_32451)){
var statearr_32577_32655 = state_32554__$1;
(statearr_32577_32655[(1)] = (35));

} else {
var statearr_32578_32656 = state_32554__$1;
(statearr_32578_32656[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (40))){
var inst_32492 = (state_32554[(20)]);
var inst_32403 = (state_32554[(10)]);
var inst_32491 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_32403);
var inst_32492__$1 = cljs.core.empty_QMARK_(inst_32491);
var state_32554__$1 = (function (){var statearr_32579 = state_32554;
(statearr_32579[(20)] = inst_32492__$1);

return statearr_32579;
})();
if(inst_32492__$1){
var statearr_32580_32657 = state_32554__$1;
(statearr_32580_32657[(1)] = (43));

} else {
var statearr_32581_32658 = state_32554__$1;
(statearr_32581_32658[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (33))){
var inst_32446 = (state_32554[(14)]);
var inst_32523 = (state_32554[(2)]);
var inst_32524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32523,(0),null);
var inst_32525 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32523,(1),null);
var inst_32526 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32523,(2),null);
var inst_32527 = inst_32446.s;
var inst_32528 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32524,cljs.core.cst$kw$_id,inst_32527);
var inst_32436 = inst_32525;
var inst_32437 = inst_32528;
var inst_32438 = inst_32526;
var state_32554__$1 = (function (){var statearr_32582 = state_32554;
(statearr_32582[(11)] = inst_32436);

(statearr_32582[(12)] = inst_32437);

(statearr_32582[(13)] = inst_32438);

return statearr_32582;
})();
var statearr_32583_32659 = state_32554__$1;
(statearr_32583_32659[(2)] = null);

(statearr_32583_32659[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (13))){
var inst_32397 = (state_32554[(7)]);
var inst_32400 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_32397);
var state_32554__$1 = state_32554;
var statearr_32584_32660 = state_32554__$1;
(statearr_32584_32660[(2)] = inst_32400);

(statearr_32584_32660[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (22))){
var inst_32403 = (state_32554[(10)]);
var inst_32423 = cljs.core.first(flakes);
var inst_32424 = fluree.db.query.fql.s(inst_32423);
var inst_32425 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_32403);
var inst_32426 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_32424,inst_32425);
var state_32554__$1 = state_32554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32554__$1,(25),inst_32426);
} else {
if((state_val_32555 === (36))){
var inst_32403 = (state_32554[(10)]);
var inst_32479 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_32403);
var state_32554__$1 = state_32554;
if(cljs.core.truth_(inst_32479)){
var statearr_32585_32661 = state_32554__$1;
(statearr_32585_32661[(1)] = (39));

} else {
var statearr_32586_32662 = state_32554__$1;
(statearr_32586_32662[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (41))){
var inst_32519 = (state_32554[(2)]);
var state_32554__$1 = state_32554;
var statearr_32587_32663 = state_32554__$1;
(statearr_32587_32663[(2)] = inst_32519);

(statearr_32587_32663[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (43))){
var inst_32403 = (state_32554[(10)]);
var inst_32494 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_32403);
var state_32554__$1 = state_32554;
var statearr_32588_32664 = state_32554__$1;
(statearr_32588_32664[(2)] = inst_32494);

(statearr_32588_32664[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (29))){
var inst_32436 = (state_32554[(11)]);
var inst_32446 = (state_32554[(14)]);
var inst_32451 = (state_32554[(18)]);
var inst_32403 = (state_32554[(10)]);
var inst_32446__$1 = cljs.core.first(inst_32436);
var inst_32447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32448 = inst_32446__$1.p;
var inst_32449 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_32448];
var inst_32450 = (new cljs.core.PersistentVector(null,3,(5),inst_32447,inst_32449,null));
var inst_32451__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_32403,inst_32450);
var inst_32452 = fluree.db.query.fql.component_follow_QMARK_(inst_32451__$1,inst_32403);
var inst_32453 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_32451__$1);
var state_32554__$1 = (function (){var statearr_32589 = state_32554;
(statearr_32589[(14)] = inst_32446__$1);

(statearr_32589[(18)] = inst_32451__$1);

(statearr_32589[(15)] = inst_32452);

return statearr_32589;
})();
if(cljs.core.truth_(inst_32453)){
var statearr_32590_32665 = state_32554__$1;
(statearr_32590_32665[(1)] = (31));

} else {
var statearr_32591_32666 = state_32554__$1;
(statearr_32591_32666[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (44))){
var inst_32492 = (state_32554[(20)]);
var state_32554__$1 = state_32554;
var statearr_32592_32667 = state_32554__$1;
(statearr_32592_32667[(2)] = inst_32492);

(statearr_32592_32667[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (6))){
var state_32554__$1 = state_32554;
var statearr_32593_32668 = state_32554__$1;
(statearr_32593_32668[(2)] = null);

(statearr_32593_32668[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (28))){
var inst_32437 = (state_32554[(12)]);
var state_32554__$1 = state_32554;
var statearr_32594_32669 = state_32554__$1;
(statearr_32594_32669[(2)] = inst_32437);

(statearr_32594_32669[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (51))){
var inst_32515 = (state_32554[(2)]);
var state_32554__$1 = state_32554;
var statearr_32595_32670 = state_32554__$1;
(statearr_32595_32670[(2)] = inst_32515);

(statearr_32595_32670[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (25))){
var inst_32417 = (state_32554[(8)]);
var inst_32428 = (state_32554[(2)]);
var inst_32429 = fluree.db.util.async.throw_err(inst_32428);
var inst_32430 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_32417,inst_32429], 0));
var state_32554__$1 = state_32554;
var statearr_32596_32671 = state_32554__$1;
(statearr_32596_32671[(2)] = inst_32430);

(statearr_32596_32671[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (34))){
var inst_32436 = (state_32554[(11)]);
var inst_32455 = (state_32554[(19)]);
var inst_32438 = (state_32554[(13)]);
var inst_32458 = (state_32554[(2)]);
var inst_32459 = fluree.db.util.async.throw_err(inst_32458);
var inst_32460 = cljs.core.rest(inst_32436);
var inst_32461 = [inst_32459,inst_32460,inst_32438];
var inst_32462 = (new cljs.core.PersistentVector(null,3,(5),inst_32455,inst_32461,null));
var state_32554__$1 = state_32554;
var statearr_32597_32672 = state_32554__$1;
(statearr_32597_32672[(2)] = inst_32462);

(statearr_32597_32672[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (17))){
var inst_32403 = (state_32554[(10)]);
var inst_32407 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_32403);
var state_32554__$1 = state_32554;
var statearr_32599_32673 = state_32554__$1;
(statearr_32599_32673[(2)] = inst_32407);

(statearr_32599_32673[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (3))){
var inst_32552 = (state_32554[(2)]);
var state_32554__$1 = state_32554;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32554__$1,inst_32552);
} else {
if((state_val_32555 === (12))){
var _ = (function (){var statearr_32600 = state_32554;
(statearr_32600[(4)] = cljs.core.rest((state_32554[(4)])));

return statearr_32600;
})();
var state_32554__$1 = state_32554;
var ex32598 = (state_32554__$1[(2)]);
var statearr_32601_32674 = state_32554__$1;
(statearr_32601_32674[(5)] = ex32598);


var statearr_32602_32675 = state_32554__$1;
(statearr_32602_32675[(1)] = (11));

(statearr_32602_32675[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (2))){
var _ = (function (){var statearr_32603 = state_32554;
(statearr_32603[(4)] = cljs.core.cons((5),(state_32554[(4)])));

return statearr_32603;
})();
var inst_32383 = cljs.core.not_empty(flakes);
var state_32554__$1 = state_32554;
if(cljs.core.truth_(inst_32383)){
var statearr_32604_32676 = state_32554__$1;
(statearr_32604_32676[(1)] = (6));

} else {
var statearr_32605_32677 = state_32554__$1;
(statearr_32605_32677[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (23))){
var inst_32417 = (state_32554[(8)]);
var state_32554__$1 = state_32554;
var statearr_32606_32678 = state_32554__$1;
(statearr_32606_32678[(2)] = inst_32417);

(statearr_32606_32678[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (47))){
var state_32554__$1 = state_32554;
var statearr_32607_32679 = state_32554__$1;
(statearr_32607_32679[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (35))){
var inst_32446 = (state_32554[(14)]);
var inst_32437 = (state_32554[(12)]);
var inst_32451 = (state_32554[(18)]);
var inst_32452 = (state_32554[(15)]);
var inst_32438 = (state_32554[(13)]);
var inst_32468 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_32437,inst_32451,inst_32446,inst_32452,false,inst_32438);
var state_32554__$1 = state_32554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32554__$1,(38),inst_32468);
} else {
if((state_val_32555 === (19))){
var inst_32397 = (state_32554[(7)]);
var inst_32411 = [cljs.core.cst$kw$_id];
var inst_32412 = [inst_32397];
var inst_32413 = cljs.core.PersistentHashMap.fromArrays(inst_32411,inst_32412);
var state_32554__$1 = state_32554;
var statearr_32609_32680 = state_32554__$1;
(statearr_32609_32680[(2)] = inst_32413);

(statearr_32609_32680[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (11))){
var inst_32385 = (state_32554[(2)]);
var inst_32386 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_32385], 0));
var inst_32387 = (function(){throw inst_32385})();
var state_32554__$1 = (function (){var statearr_32611 = state_32554;
(statearr_32611[(21)] = inst_32386);

return statearr_32611;
})();
var statearr_32612_32681 = state_32554__$1;
(statearr_32612_32681[(2)] = inst_32387);

(statearr_32612_32681[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (9))){
var _ = (function (){var statearr_32613 = state_32554;
(statearr_32613[(4)] = cljs.core.cons((12),(state_32554[(4)])));

return statearr_32613;
})();
var inst_32393 = cljs.core.first(flakes);
var inst_32394 = fluree.db.query.fql.s(inst_32393);
var ___$1 = (function (){var statearr_32614 = state_32554;
(statearr_32614[(4)] = cljs.core.rest((state_32554[(4)])));

return statearr_32614;
})();
var state_32554__$1 = state_32554;
var statearr_32615_32682 = state_32554__$1;
(statearr_32615_32682[(2)] = inst_32394);

(statearr_32615_32682[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (5))){
var _ = (function (){var statearr_32616 = state_32554;
(statearr_32616[(4)] = cljs.core.rest((state_32554[(4)])));

return statearr_32616;
})();
var state_32554__$1 = state_32554;
var ex32610 = (state_32554__$1[(2)]);
var statearr_32617_32683 = state_32554__$1;
(statearr_32617_32683[(5)] = ex32610);


if((ex32610 instanceof Error)){
var statearr_32618_32684 = state_32554__$1;
(statearr_32618_32684[(1)] = (4));

(statearr_32618_32684[(5)] = null);

} else {
throw ex32610;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (14))){
var state_32554__$1 = state_32554;
var statearr_32619_32685 = state_32554__$1;
(statearr_32619_32685[(2)] = base_select_spec);

(statearr_32619_32685[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (45))){
var inst_32497 = (state_32554[(2)]);
var state_32554__$1 = state_32554;
if(cljs.core.truth_(inst_32497)){
var statearr_32620_32686 = state_32554__$1;
(statearr_32620_32686[(1)] = (46));

} else {
var statearr_32621_32687 = state_32554__$1;
(statearr_32621_32687[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (26))){
var inst_32436 = (state_32554[(11)]);
var inst_32440 = cljs.core.empty_QMARK_(inst_32436);
var state_32554__$1 = state_32554;
if(inst_32440){
var statearr_32622_32688 = state_32554__$1;
(statearr_32622_32688[(1)] = (28));

} else {
var statearr_32623_32689 = state_32554__$1;
(statearr_32623_32689[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (16))){
var inst_32404 = (state_32554[(17)]);
var state_32554__$1 = state_32554;
var statearr_32624_32690 = state_32554__$1;
(statearr_32624_32690[(2)] = inst_32404);

(statearr_32624_32690[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (38))){
var inst_32436 = (state_32554[(11)]);
var inst_32470 = (state_32554[(2)]);
var inst_32471 = fluree.db.util.async.throw_err(inst_32470);
var inst_32472 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32471,(0),null);
var inst_32473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32471,(1),null);
var inst_32474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32475 = cljs.core.rest(inst_32436);
var inst_32476 = [inst_32472,inst_32475,inst_32473];
var inst_32477 = (new cljs.core.PersistentVector(null,3,(5),inst_32474,inst_32476,null));
var state_32554__$1 = state_32554;
var statearr_32625_32691 = state_32554__$1;
(statearr_32625_32691[(2)] = inst_32477);

(statearr_32625_32691[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (30))){
var inst_32531 = (state_32554[(2)]);
var state_32554__$1 = state_32554;
var statearr_32626_32692 = state_32554__$1;
(statearr_32626_32692[(2)] = inst_32531);

(statearr_32626_32692[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (10))){
var inst_32397 = (state_32554[(2)]);
var inst_32398 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_32554__$1 = (function (){var statearr_32627 = state_32554;
(statearr_32627[(7)] = inst_32397);

return statearr_32627;
})();
if(cljs.core.truth_(inst_32398)){
var statearr_32628_32693 = state_32554__$1;
(statearr_32628_32693[(1)] = (13));

} else {
var statearr_32629_32694 = state_32554__$1;
(statearr_32629_32694[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (18))){
var inst_32409 = (state_32554[(2)]);
var state_32554__$1 = state_32554;
if(cljs.core.truth_(inst_32409)){
var statearr_32630_32695 = state_32554__$1;
(statearr_32630_32695[(1)] = (19));

} else {
var statearr_32631_32696 = state_32554__$1;
(statearr_32631_32696[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (42))){
var inst_32436 = (state_32554[(11)]);
var inst_32481 = (state_32554[(16)]);
var inst_32438 = (state_32554[(13)]);
var inst_32484 = (state_32554[(2)]);
var inst_32485 = fluree.db.util.async.throw_err(inst_32484);
var inst_32486 = cljs.core.first(inst_32485);
var inst_32487 = cljs.core.rest(inst_32436);
var inst_32488 = [inst_32486,inst_32487,inst_32438];
var inst_32489 = (new cljs.core.PersistentVector(null,3,(5),inst_32481,inst_32488,null));
var state_32554__$1 = state_32554;
var statearr_32632_32697 = state_32554__$1;
(statearr_32632_32697[(2)] = inst_32489);

(statearr_32632_32697[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (37))){
var inst_32521 = (state_32554[(2)]);
var state_32554__$1 = state_32554;
var statearr_32633_32698 = state_32554__$1;
(statearr_32633_32698[(2)] = inst_32521);

(statearr_32633_32698[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (8))){
var inst_32549 = (state_32554[(2)]);
var _ = (function (){var statearr_32634 = state_32554;
(statearr_32634[(4)] = cljs.core.rest((state_32554[(4)])));

return statearr_32634;
})();
var state_32554__$1 = state_32554;
var statearr_32635_32699 = state_32554__$1;
(statearr_32635_32699[(2)] = inst_32549);

(statearr_32635_32699[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32555 === (49))){
var inst_32436 = (state_32554[(11)]);
var inst_32437 = (state_32554[(12)]);
var inst_32438 = (state_32554[(13)]);
var inst_32509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32510 = cljs.core.rest(inst_32436);
var inst_32511 = [inst_32437,inst_32510,inst_32438];
var inst_32512 = (new cljs.core.PersistentVector(null,3,(5),inst_32509,inst_32511,null));
var state_32554__$1 = state_32554;
var statearr_32636_32700 = state_32554__$1;
(statearr_32636_32700[(2)] = inst_32512);

(statearr_32636_32700[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto____0 = (function (){
var statearr_32637 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32637[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto__);

(statearr_32637[(1)] = (1));

return statearr_32637;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto____1 = (function (state_32554){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_32554);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e32638){var ex__10801__auto__ = e32638;
var statearr_32639_32701 = state_32554;
(statearr_32639_32701[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_32554[(4)]))){
var statearr_32640_32702 = state_32554;
(statearr_32640_32702[(1)] = cljs.core.first((state_32554[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__32703 = state_32554;
state_32554 = G__32703;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto__ = function(state_32554){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto____1.call(this,state_32554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_32641 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_32641[(6)] = c__10835__auto__);

return statearr_32641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__32706 = arguments.length;
switch (G__32706) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_32748){
var state_val_32749 = (state_32748[(1)]);
if((state_val_32749 === (7))){
var inst_32714 = (state_32748[(7)]);
var state_32748__$1 = state_32748;
var statearr_32750_32780 = state_32748__$1;
(statearr_32750_32780[(2)] = inst_32714);

(statearr_32750_32780[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (1))){
var state_32748__$1 = state_32748;
var statearr_32751_32781 = state_32748__$1;
(statearr_32751_32781[(2)] = null);

(statearr_32751_32781[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (4))){
var inst_32707 = (state_32748[(2)]);
var state_32748__$1 = state_32748;
var statearr_32752_32782 = state_32748__$1;
(statearr_32752_32782[(2)] = inst_32707);

(statearr_32752_32782[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (15))){
var inst_32742 = (state_32748[(2)]);
var inst_32743 = fluree.db.util.async.throw_err(inst_32742);
var _ = (function (){var statearr_32753 = state_32748;
(statearr_32753[(4)] = cljs.core.rest((state_32748[(4)])));

return statearr_32753;
})();
var state_32748__$1 = state_32748;
var statearr_32754_32783 = state_32748__$1;
(statearr_32754_32783[(2)] = inst_32743);

(statearr_32754_32783[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (13))){
var inst_32726 = (state_32748[(8)]);
var state_32748__$1 = state_32748;
var statearr_32755_32784 = state_32748__$1;
(statearr_32755_32784[(2)] = inst_32726);

(statearr_32755_32784[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (6))){
var inst_32714 = (state_32748[(7)]);
var inst_32716 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_32717 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_32714,inst_32716);
var state_32748__$1 = state_32748;
var statearr_32756_32785 = state_32748__$1;
(statearr_32756_32785[(2)] = inst_32717);

(statearr_32756_32785[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (3))){
var inst_32746 = (state_32748[(2)]);
var state_32748__$1 = state_32748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32748__$1,inst_32746);
} else {
if((state_val_32749 === (12))){
var inst_32726 = (state_32748[(8)]);
var inst_32728 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_32729 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_32726,inst_32728);
var state_32748__$1 = state_32748;
var statearr_32757_32786 = state_32748__$1;
(statearr_32757_32786[(2)] = inst_32729);

(statearr_32757_32786[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (2))){
var _ = (function (){var statearr_32758 = state_32748;
(statearr_32758[(4)] = cljs.core.cons((5),(state_32748[(4)])));

return statearr_32758;
})();
var inst_32714 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_32748__$1 = (function (){var statearr_32759 = state_32748;
(statearr_32759[(7)] = inst_32714);

return statearr_32759;
})();
if(cljs.core.truth_(fuel)){
var statearr_32760_32787 = state_32748__$1;
(statearr_32760_32787[(1)] = (6));

} else {
var statearr_32761_32788 = state_32748__$1;
(statearr_32761_32788[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (11))){
var inst_32726 = (state_32748[(2)]);
var state_32748__$1 = (function (){var statearr_32763 = state_32748;
(statearr_32763[(8)] = inst_32726);

return statearr_32763;
})();
if(cljs.core.truth_(limit)){
var statearr_32764_32789 = state_32748__$1;
(statearr_32764_32789[(1)] = (12));

} else {
var statearr_32765_32790 = state_32748__$1;
(statearr_32765_32790[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (9))){
var inst_32720 = (state_32748[(9)]);
var inst_32722 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_32723 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_32720,inst_32722);
var state_32748__$1 = state_32748;
var statearr_32766_32791 = state_32748__$1;
(statearr_32766_32791[(2)] = inst_32723);

(statearr_32766_32791[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (5))){
var _ = (function (){var statearr_32767 = state_32748;
(statearr_32767[(4)] = cljs.core.rest((state_32748[(4)])));

return statearr_32767;
})();
var state_32748__$1 = state_32748;
var ex32762 = (state_32748__$1[(2)]);
var statearr_32768_32792 = state_32748__$1;
(statearr_32768_32792[(5)] = ex32762);


if((ex32762 instanceof Error)){
var statearr_32769_32793 = state_32748__$1;
(statearr_32769_32793[(1)] = (4));

(statearr_32769_32793[(5)] = null);

} else {
throw ex32762;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (14))){
var inst_32732 = (state_32748[(2)]);
var inst_32733 = (function (){return (function (x){
var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4221__auto__;
}
});
})();
var inst_32734 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_32733);
var inst_32735 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_32732,inst_32734);
var inst_32736 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_32735,flakes);
var inst_32737 = cljs.core.PersistentVector.EMPTY;
var inst_32738 = (function (){var xf = inst_32735;
var flakes_by_sub = inst_32736;
return (function (p1__32704_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__32704_SHARP_);
});
})();
var inst_32739 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32738,inst_32736);
var inst_32740 = fluree.db.util.async.merge_into_QMARK_(inst_32737,inst_32739);
var state_32748__$1 = state_32748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32748__$1,(15),inst_32740);
} else {
if((state_val_32749 === (10))){
var inst_32720 = (state_32748[(9)]);
var state_32748__$1 = state_32748;
var statearr_32770_32794 = state_32748__$1;
(statearr_32770_32794[(2)] = inst_32720);

(statearr_32770_32794[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32749 === (8))){
var inst_32720 = (state_32748[(2)]);
var state_32748__$1 = (function (){var statearr_32771 = state_32748;
(statearr_32771[(9)] = inst_32720);

return statearr_32771;
})();
if(cljs.core.truth_(offset)){
var statearr_32772_32795 = state_32748__$1;
(statearr_32772_32795[(1)] = (9));

} else {
var statearr_32773_32796 = state_32748__$1;
(statearr_32773_32796[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10798__auto__ = null;
var fluree$db$query$fql$state_machine__10798__auto____0 = (function (){
var statearr_32774 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32774[(0)] = fluree$db$query$fql$state_machine__10798__auto__);

(statearr_32774[(1)] = (1));

return statearr_32774;
});
var fluree$db$query$fql$state_machine__10798__auto____1 = (function (state_32748){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_32748);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e32775){var ex__10801__auto__ = e32775;
var statearr_32776_32797 = state_32748;
(statearr_32776_32797[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_32748[(4)]))){
var statearr_32777_32798 = state_32748;
(statearr_32777_32798[(1)] = cljs.core.first((state_32748[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__32799 = state_32748;
state_32748 = G__32799;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10798__auto__ = function(state_32748){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10798__auto____1.call(this,state_32748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10798__auto____0;
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10798__auto____1;
return fluree$db$query$fql$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_32778 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_32778[(6)] = c__10835__auto__);

return statearr_32778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__32801 = arguments.length;
switch (G__32801) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_32882){
var state_val_32883 = (state_32882[(1)]);
if((state_val_32883 === (7))){
var inst_32877 = (state_32882[(2)]);
var _ = (function (){var statearr_32885 = state_32882;
(statearr_32885[(4)] = cljs.core.rest((state_32882[(4)])));

return statearr_32885;
})();
var state_32882__$1 = state_32882;
var statearr_32886_32933 = state_32882__$1;
(statearr_32886_32933[(2)] = inst_32877);

(statearr_32886_32933[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (20))){
var inst_32821 = (state_32882[(7)]);
var inst_32829 = (state_32882[(8)]);
var inst_32822 = (state_32882[(9)]);
var inst_32850 = (inst_32821 + (1));
var tmp32884 = inst_32822;
var inst_32820 = inst_32829;
var inst_32821__$1 = inst_32850;
var inst_32822__$1 = tmp32884;
var state_32882__$1 = (function (){var statearr_32887 = state_32882;
(statearr_32887[(7)] = inst_32821__$1);

(statearr_32887[(10)] = inst_32820);

(statearr_32887[(9)] = inst_32822__$1);

return statearr_32887;
})();
var statearr_32888_32934 = state_32882__$1;
(statearr_32888_32934[(2)] = null);

(statearr_32888_32934[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (27))){
var inst_32855 = (state_32882[(11)]);
var inst_32861 = (state_32882[(2)]);
var inst_32862 = fluree.db.util.async.throw_err(inst_32861);
var inst_32863 = (inst_32855.cljs$core$IFn$_invoke$arity$1 ? inst_32855.cljs$core$IFn$_invoke$arity$1(inst_32862) : inst_32855.call(null,inst_32862));
var state_32882__$1 = state_32882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32882__$1,(26),inst_32863);
} else {
if((state_val_32883 === (1))){
var state_32882__$1 = state_32882;
var statearr_32889_32935 = state_32882__$1;
(statearr_32889_32935[(2)] = null);

(statearr_32889_32935[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (24))){
var state_32882__$1 = state_32882;
var statearr_32890_32936 = state_32882__$1;
(statearr_32890_32936[(2)] = null);

(statearr_32890_32936[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (4))){
var inst_32802 = (state_32882[(2)]);
var state_32882__$1 = state_32882;
var statearr_32891_32937 = state_32882__$1;
(statearr_32891_32937[(2)] = inst_32802);

(statearr_32891_32937[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (15))){
var inst_32843 = (state_32882[(12)]);
var inst_32843__$1 = offset;
var state_32882__$1 = (function (){var statearr_32892 = state_32882;
(statearr_32892[(12)] = inst_32843__$1);

return statearr_32892;
})();
if(cljs.core.truth_(inst_32843__$1)){
var statearr_32893_32938 = state_32882__$1;
(statearr_32893_32938[(1)] = (17));

} else {
var statearr_32894_32939 = state_32882__$1;
(statearr_32894_32939[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (21))){
var state_32882__$1 = state_32882;
var statearr_32895_32940 = state_32882__$1;
(statearr_32895_32940[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (13))){
var inst_32838 = (state_32882[(2)]);
var state_32882__$1 = state_32882;
var statearr_32897_32941 = state_32882__$1;
(statearr_32897_32941[(2)] = inst_32838);

(statearr_32897_32941[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (22))){
var inst_32873 = (state_32882[(2)]);
var state_32882__$1 = state_32882;
var statearr_32898_32942 = state_32882__$1;
(statearr_32898_32942[(2)] = inst_32873);

(statearr_32898_32942[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (6))){
var inst_32830 = (state_32882[(13)]);
var inst_32820 = (state_32882[(10)]);
var inst_32828 = (state_32882[(14)]);
var inst_32827 = cljs.core.seq(inst_32820);
var inst_32828__$1 = cljs.core.first(inst_32827);
var inst_32829 = cljs.core.next(inst_32827);
var inst_32830__$1 = (inst_32828__$1 == null);
var state_32882__$1 = (function (){var statearr_32899 = state_32882;
(statearr_32899[(13)] = inst_32830__$1);

(statearr_32899[(14)] = inst_32828__$1);

(statearr_32899[(8)] = inst_32829);

return statearr_32899;
})();
if(cljs.core.truth_(inst_32830__$1)){
var statearr_32900_32943 = state_32882__$1;
(statearr_32900_32943[(1)] = (8));

} else {
var statearr_32901_32944 = state_32882__$1;
(statearr_32901_32944[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (25))){
var inst_32871 = (state_32882[(2)]);
var state_32882__$1 = state_32882;
var statearr_32902_32945 = state_32882__$1;
(statearr_32902_32945[(2)] = inst_32871);

(statearr_32902_32945[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (17))){
var inst_32821 = (state_32882[(7)]);
var inst_32845 = (inst_32821 < offset);
var state_32882__$1 = state_32882;
var statearr_32903_32946 = state_32882__$1;
(statearr_32903_32946[(2)] = inst_32845);

(statearr_32903_32946[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (3))){
var inst_32880 = (state_32882[(2)]);
var state_32882__$1 = state_32882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32882__$1,inst_32880);
} else {
if((state_val_32883 === (12))){
var inst_32833 = (state_32882[(15)]);
var state_32882__$1 = state_32882;
var statearr_32904_32947 = state_32882__$1;
(statearr_32904_32947[(2)] = inst_32833);

(statearr_32904_32947[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (2))){
var inst_32815 = (state_32882[(16)]);
var _ = (function (){var statearr_32905 = state_32882;
(statearr_32905[(4)] = cljs.core.cons((5),(state_32882[(4)])));

return statearr_32905;
})();
var inst_32815__$1 = subjects;
var inst_32816 = cljs.core.seq(inst_32815__$1);
var inst_32817 = cljs.core.first(inst_32816);
var inst_32818 = cljs.core.next(inst_32816);
var inst_32819 = cljs.core.PersistentVector.EMPTY;
var inst_32820 = inst_32815__$1;
var inst_32821 = (0);
var inst_32822 = inst_32819;
var state_32882__$1 = (function (){var statearr_32906 = state_32882;
(statearr_32906[(7)] = inst_32821);

(statearr_32906[(17)] = inst_32817);

(statearr_32906[(18)] = inst_32818);

(statearr_32906[(10)] = inst_32820);

(statearr_32906[(16)] = inst_32815__$1);

(statearr_32906[(9)] = inst_32822);

return statearr_32906;
})();
var statearr_32907_32948 = state_32882__$1;
(statearr_32907_32948[(2)] = null);

(statearr_32907_32948[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (23))){
var inst_32821 = (state_32882[(7)]);
var inst_32817 = (state_32882[(17)]);
var inst_32818 = (state_32882[(18)]);
var inst_32820 = (state_32882[(10)]);
var inst_32815 = (state_32882[(16)]);
var inst_32828 = (state_32882[(14)]);
var inst_32829 = (state_32882[(8)]);
var inst_32822 = (state_32882[(9)]);
var inst_32854 = (inst_32821 + (1));
var inst_32855 = (function (){var seq__32813 = inst_32818;
var vec__32812 = inst_32815;
var first__32814 = inst_32817;
var r = inst_32829;
var seq__32825 = inst_32829;
var G__32811 = inst_32820;
var acc = inst_32822;
var first__32826 = inst_32828;
var n = inst_32821;
var vec__32824 = inst_32820;
var s = inst_32828;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_32856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32857 = [inst_32828];
var inst_32858 = (new cljs.core.PersistentVector(null,1,(5),inst_32856,inst_32857,null));
var inst_32859 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32858);
var state_32882__$1 = (function (){var statearr_32908 = state_32882;
(statearr_32908[(19)] = inst_32854);

(statearr_32908[(11)] = inst_32855);

return statearr_32908;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32882__$1,(27),inst_32859);
} else {
if((state_val_32883 === (19))){
var inst_32848 = (state_32882[(2)]);
var state_32882__$1 = state_32882;
if(cljs.core.truth_(inst_32848)){
var statearr_32909_32949 = state_32882__$1;
(statearr_32909_32949[(1)] = (20));

} else {
var statearr_32910_32950 = state_32882__$1;
(statearr_32910_32950[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (11))){
var inst_32821 = (state_32882[(7)]);
var inst_32835 = (inst_32821 > limit);
var state_32882__$1 = state_32882;
var statearr_32912_32951 = state_32882__$1;
(statearr_32912_32951[(2)] = inst_32835);

(statearr_32912_32951[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (9))){
var inst_32833 = (state_32882[(15)]);
var inst_32833__$1 = limit;
var state_32882__$1 = (function (){var statearr_32913 = state_32882;
(statearr_32913[(15)] = inst_32833__$1);

return statearr_32913;
})();
if(cljs.core.truth_(inst_32833__$1)){
var statearr_32914_32952 = state_32882__$1;
(statearr_32914_32952[(1)] = (11));

} else {
var statearr_32915_32953 = state_32882__$1;
(statearr_32915_32953[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (5))){
var _ = (function (){var statearr_32916 = state_32882;
(statearr_32916[(4)] = cljs.core.rest((state_32882[(4)])));

return statearr_32916;
})();
var state_32882__$1 = state_32882;
var ex32911 = (state_32882__$1[(2)]);
var statearr_32917_32954 = state_32882__$1;
(statearr_32917_32954[(5)] = ex32911);


if((ex32911 instanceof Error)){
var statearr_32918_32955 = state_32882__$1;
(statearr_32918_32955[(1)] = (4));

(statearr_32918_32955[(5)] = null);

} else {
throw ex32911;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (14))){
var inst_32822 = (state_32882[(9)]);
var state_32882__$1 = state_32882;
var statearr_32919_32956 = state_32882__$1;
(statearr_32919_32956[(2)] = inst_32822);

(statearr_32919_32956[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (26))){
var inst_32854 = (state_32882[(19)]);
var inst_32829 = (state_32882[(8)]);
var inst_32822 = (state_32882[(9)]);
var inst_32865 = (state_32882[(2)]);
var inst_32866 = fluree.db.util.async.throw_err(inst_32865);
var inst_32867 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32822,inst_32866);
var inst_32820 = inst_32829;
var inst_32821 = inst_32854;
var inst_32822__$1 = inst_32867;
var state_32882__$1 = (function (){var statearr_32920 = state_32882;
(statearr_32920[(7)] = inst_32821);

(statearr_32920[(10)] = inst_32820);

(statearr_32920[(9)] = inst_32822__$1);

return statearr_32920;
})();
var statearr_32921_32957 = state_32882__$1;
(statearr_32921_32957[(2)] = null);

(statearr_32921_32957[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (16))){
var inst_32875 = (state_32882[(2)]);
var state_32882__$1 = state_32882;
var statearr_32922_32958 = state_32882__$1;
(statearr_32922_32958[(2)] = inst_32875);

(statearr_32922_32958[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (10))){
var inst_32840 = (state_32882[(2)]);
var state_32882__$1 = state_32882;
if(cljs.core.truth_(inst_32840)){
var statearr_32923_32959 = state_32882__$1;
(statearr_32923_32959[(1)] = (14));

} else {
var statearr_32924_32960 = state_32882__$1;
(statearr_32924_32960[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (18))){
var inst_32843 = (state_32882[(12)]);
var state_32882__$1 = state_32882;
var statearr_32925_32961 = state_32882__$1;
(statearr_32925_32961[(2)] = inst_32843);

(statearr_32925_32961[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32883 === (8))){
var inst_32830 = (state_32882[(13)]);
var state_32882__$1 = state_32882;
var statearr_32926_32962 = state_32882__$1;
(statearr_32926_32962[(2)] = inst_32830);

(statearr_32926_32962[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10798__auto__ = null;
var fluree$db$query$fql$state_machine__10798__auto____0 = (function (){
var statearr_32927 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32927[(0)] = fluree$db$query$fql$state_machine__10798__auto__);

(statearr_32927[(1)] = (1));

return statearr_32927;
});
var fluree$db$query$fql$state_machine__10798__auto____1 = (function (state_32882){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_32882);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e32928){var ex__10801__auto__ = e32928;
var statearr_32929_32963 = state_32882;
(statearr_32929_32963[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_32882[(4)]))){
var statearr_32930_32964 = state_32882;
(statearr_32930_32964[(1)] = cljs.core.first((state_32882[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__32965 = state_32882;
state_32882 = G__32965;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10798__auto__ = function(state_32882){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10798__auto____1.call(this,state_32882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10798__auto____0;
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10798__auto____1;
return fluree$db$query$fql$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_32931 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_32931[(6)] = c__10835__auto__);

return statearr_32931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__32967 = arguments.length;
switch (G__32967) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_33158){
var state_val_33159 = (state_33158[(1)]);
if((state_val_33159 === (7))){
var state_33158__$1 = state_33158;
var statearr_33160_33235 = state_33158__$1;
(statearr_33160_33235[(2)] = null);

(statearr_33160_33235[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (20))){
var inst_33008 = (state_33158[(7)]);
var inst_33010 = (state_33158[(8)]);
var inst_33038 = (state_33158[(2)]);
var inst_33039 = fluree.db.util.async.throw_err(inst_33038);
var inst_33040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33041 = [inst_33008];
var inst_33042 = (new cljs.core.PersistentVector(null,1,(5),inst_33040,inst_33041,null));
var inst_33043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33044 = [inst_33008,inst_33010];
var inst_33045 = (new cljs.core.PersistentVector(null,2,(5),inst_33043,inst_33044,null));
var inst_33046 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_33042,cljs.core._LT_,inst_33045);
var state_33158__$1 = (function (){var statearr_33161 = state_33158;
(statearr_33161[(9)] = inst_33039);

return statearr_33161;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33158__$1,(21),inst_33046);
} else {
if((state_val_33159 === (27))){
var inst_33009 = (state_33158[(10)]);
var inst_33027 = (state_33158[(11)]);
var inst_33075 = (inst_33027.cljs$core$IFn$_invoke$arity$2 ? inst_33027.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_33009) : inst_33027.call(null,cljs.core._GT__EQ_,inst_33009));
var state_33158__$1 = state_33158;
if(cljs.core.truth_(inst_33075)){
var statearr_33162_33236 = state_33158__$1;
(statearr_33162_33236[(1)] = (30));

} else {
var statearr_33163_33237 = state_33158__$1;
(statearr_33163_33237[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (1))){
var state_33158__$1 = state_33158;
var statearr_33164_33238 = state_33158__$1;
(statearr_33164_33238[(2)] = null);

(statearr_33164_33238[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (24))){
var inst_33124 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
var statearr_33165_33239 = state_33158__$1;
(statearr_33165_33239[(2)] = inst_33124);

(statearr_33165_33239[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (39))){
var inst_33114 = null;
var state_33158__$1 = state_33158;
var statearr_33166_33240 = state_33158__$1;
(statearr_33166_33240[(2)] = inst_33114);

(statearr_33166_33240[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (46))){
var inst_33136 = (state_33158[(12)]);
var state_33158__$1 = state_33158;
var statearr_33167_33241 = state_33158__$1;
(statearr_33167_33241[(2)] = inst_33136);

(statearr_33167_33241[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (4))){
var inst_32968 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
var statearr_33168_33242 = state_33158__$1;
(statearr_33168_33242[(2)] = inst_32968);

(statearr_33168_33242[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (15))){
var state_33158__$1 = state_33158;
var statearr_33169_33243 = state_33158__$1;
(statearr_33169_33243[(2)] = null);

(statearr_33169_33243[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (48))){
var inst_33135 = (state_33158[(13)]);
var state_33158__$1 = state_33158;
var statearr_33170_33244 = state_33158__$1;
(statearr_33170_33244[(2)] = inst_33135);

(statearr_33170_33244[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (50))){
var inst_33146 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
var statearr_33171_33245 = state_33158__$1;
(statearr_33171_33245[(2)] = inst_33146);

(statearr_33171_33245[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (21))){
var inst_33039 = (state_33158[(9)]);
var inst_33048 = (state_33158[(2)]);
var inst_33049 = fluree.db.util.async.throw_err(inst_33048);
var inst_33050 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_33039,inst_33049);
var state_33158__$1 = state_33158;
var statearr_33172_33246 = state_33158__$1;
(statearr_33172_33246[(2)] = inst_33050);

(statearr_33172_33246[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (31))){
var inst_33009 = (state_33158[(10)]);
var inst_33027 = (state_33158[(11)]);
var inst_33088 = (inst_33027.cljs$core$IFn$_invoke$arity$2 ? inst_33027.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_33009) : inst_33027.call(null,cljs.core._LT_,inst_33009));
var state_33158__$1 = state_33158;
if(cljs.core.truth_(inst_33088)){
var statearr_33173_33247 = state_33158__$1;
(statearr_33173_33247[(1)] = (34));

} else {
var statearr_33174_33248 = state_33158__$1;
(statearr_33174_33248[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (32))){
var inst_33120 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
var statearr_33175_33249 = state_33158__$1;
(statearr_33175_33249[(2)] = inst_33120);

(statearr_33175_33249[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (40))){
var inst_33116 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
var statearr_33176_33250 = state_33158__$1;
(statearr_33176_33250[(2)] = inst_33116);

(statearr_33176_33250[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (33))){
var inst_33085 = (state_33158[(2)]);
var inst_33086 = fluree.db.util.async.throw_err(inst_33085);
var state_33158__$1 = state_33158;
var statearr_33177_33251 = state_33158__$1;
(statearr_33177_33251[(2)] = inst_33086);

(statearr_33177_33251[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (13))){
var inst_33148 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
var statearr_33178_33252 = state_33158__$1;
(statearr_33178_33252[(2)] = inst_33148);

(statearr_33178_33252[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (22))){
var inst_33008 = (state_33158[(7)]);
var inst_33010 = (state_33158[(8)]);
var inst_33054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33055 = [inst_33008,inst_33010];
var inst_33056 = (new cljs.core.PersistentVector(null,2,(5),inst_33054,inst_33055,null));
var inst_33057 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_33056);
var state_33158__$1 = state_33158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33158__$1,(25),inst_33057);
} else {
if((state_val_33159 === (36))){
var inst_33118 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
var statearr_33179_33253 = state_33158__$1;
(statearr_33179_33253[(2)] = inst_33118);

(statearr_33179_33253[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (41))){
var inst_33111 = (state_33158[(2)]);
var inst_33112 = fluree.db.util.async.throw_err(inst_33111);
var state_33158__$1 = state_33158;
var statearr_33180_33254 = state_33158__$1;
(statearr_33180_33254[(2)] = inst_33112);

(statearr_33180_33254[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (43))){
var inst_32994 = (state_33158[(14)]);
var inst_33127 = (state_33158[(15)]);
var inst_33128 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32994,inst_33127);
var state_33158__$1 = state_33158;
var statearr_33181_33255 = state_33158__$1;
(statearr_33181_33255[(2)] = inst_33128);

(statearr_33181_33255[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (29))){
var inst_33072 = (state_33158[(2)]);
var inst_33073 = fluree.db.util.async.throw_err(inst_33072);
var state_33158__$1 = state_33158;
var statearr_33182_33256 = state_33158__$1;
(statearr_33182_33256[(2)] = inst_33073);

(statearr_33182_33256[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (44))){
var inst_32994 = (state_33158[(14)]);
var inst_33127 = (state_33158[(15)]);
var inst_33130 = cljs.core.PersistentHashSet.EMPTY;
var inst_33131 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33130,inst_33127);
var inst_33132 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_32994,inst_33131);
var state_33158__$1 = state_33158;
var statearr_33183_33257 = state_33158__$1;
(statearr_33183_33257[(2)] = inst_33132);

(statearr_33183_33257[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (6))){
var inst_32979 = (state_33158[(16)]);
var inst_32989 = cljs.core.seq(inst_32979);
var inst_32990 = cljs.core.first(inst_32989);
var inst_32991 = cljs.core.next(inst_32989);
var inst_32992 = cljs.core.PersistentHashSet.EMPTY;
var inst_32993 = inst_32979;
var inst_32994 = inst_32992;
var state_33158__$1 = (function (){var statearr_33184 = state_33158;
(statearr_33184[(17)] = inst_32993);

(statearr_33184[(18)] = inst_32991);

(statearr_33184[(14)] = inst_32994);

(statearr_33184[(19)] = inst_32990);

return statearr_33184;
})();
var statearr_33185_33258 = state_33158__$1;
(statearr_33185_33258[(2)] = null);

(statearr_33185_33258[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (28))){
var inst_33122 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
var statearr_33186_33259 = state_33158__$1;
(statearr_33186_33259[(2)] = inst_33122);

(statearr_33186_33259[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (25))){
var inst_33059 = (state_33158[(2)]);
var inst_33060 = fluree.db.util.async.throw_err(inst_33059);
var state_33158__$1 = state_33158;
var statearr_33187_33260 = state_33158__$1;
(statearr_33187_33260[(2)] = inst_33060);

(statearr_33187_33260[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (34))){
var inst_33008 = (state_33158[(7)]);
var inst_33010 = (state_33158[(8)]);
var inst_33090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33091 = [inst_33008];
var inst_33092 = (new cljs.core.PersistentVector(null,1,(5),inst_33090,inst_33091,null));
var inst_33093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33094 = [inst_33008,inst_33010];
var inst_33095 = (new cljs.core.PersistentVector(null,2,(5),inst_33093,inst_33094,null));
var inst_33096 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_33092,cljs.core._LT_,inst_33095);
var state_33158__$1 = state_33158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33158__$1,(37),inst_33096);
} else {
if((state_val_33159 === (17))){
var inst_33008 = (state_33158[(7)]);
var inst_33010 = (state_33158[(8)]);
var inst_33030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33031 = [inst_33008,inst_33010];
var inst_33032 = (new cljs.core.PersistentVector(null,2,(5),inst_33030,inst_33031,null));
var inst_33033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33034 = [inst_33008];
var inst_33035 = (new cljs.core.PersistentVector(null,1,(5),inst_33033,inst_33034,null));
var inst_33036 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_33032,cljs.core._LT__EQ_,inst_33035);
var state_33158__$1 = state_33158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33158__$1,(20),inst_33036);
} else {
if((state_val_33159 === (3))){
var inst_33156 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33158__$1,inst_33156);
} else {
if((state_val_33159 === (12))){
var inst_33008 = (state_33158[(7)]);
var inst_33000 = (state_33158[(20)]);
var inst_33008__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33000,(0),null);
var inst_33009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33000,(1),null);
var inst_33010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33000,(2),null);
var inst_33011 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_33008__$1);
var inst_33012 = cljs.core.not(inst_33011);
var state_33158__$1 = (function (){var statearr_33188 = state_33158;
(statearr_33188[(7)] = inst_33008__$1);

(statearr_33188[(10)] = inst_33009);

(statearr_33188[(8)] = inst_33010);

return statearr_33188;
})();
if(inst_33012){
var statearr_33189_33261 = state_33158__$1;
(statearr_33189_33261[(1)] = (14));

} else {
var statearr_33190_33262 = state_33158__$1;
(statearr_33190_33262[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (2))){
var inst_32979 = (state_33158[(16)]);
var _ = (function (){var statearr_33191 = state_33158;
(statearr_33191[(4)] = cljs.core.cons((5),(state_33158[(4)])));

return statearr_33191;
})();
var inst_32977 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_32978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32977,(0),null);
var inst_32979__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32977,(1),null);
var inst_32980 = cljs.core.not_empty(inst_32979__$1);
var state_33158__$1 = (function (){var statearr_33192 = state_33158;
(statearr_33192[(21)] = inst_32978);

(statearr_33192[(16)] = inst_32979__$1);

return statearr_33192;
})();
if(cljs.core.truth_(inst_32980)){
var statearr_33193_33263 = state_33158__$1;
(statearr_33193_33263[(1)] = (6));

} else {
var statearr_33194_33264 = state_33158__$1;
(statearr_33194_33264[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (23))){
var inst_33009 = (state_33158[(10)]);
var inst_33027 = (state_33158[(11)]);
var inst_33062 = (inst_33027.cljs$core$IFn$_invoke$arity$2 ? inst_33027.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_33009) : inst_33027.call(null,cljs.core._GT_,inst_33009));
var state_33158__$1 = state_33158;
if(cljs.core.truth_(inst_33062)){
var statearr_33195_33265 = state_33158__$1;
(statearr_33195_33265[(1)] = (26));

} else {
var statearr_33196_33266 = state_33158__$1;
(statearr_33196_33266[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (47))){
var inst_33141 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
if(cljs.core.truth_(inst_33141)){
var statearr_33197_33267 = state_33158__$1;
(statearr_33197_33267[(1)] = (48));

} else {
var statearr_33198_33268 = state_33158__$1;
(statearr_33198_33268[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (35))){
var inst_33009 = (state_33158[(10)]);
var inst_33027 = (state_33158[(11)]);
var inst_33101 = (inst_33027.cljs$core$IFn$_invoke$arity$2 ? inst_33027.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_33009) : inst_33027.call(null,cljs.core._LT__EQ_,inst_33009));
var state_33158__$1 = state_33158;
if(cljs.core.truth_(inst_33101)){
var statearr_33199_33269 = state_33158__$1;
(statearr_33199_33269[(1)] = (38));

} else {
var statearr_33200_33270 = state_33158__$1;
(statearr_33200_33270[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (19))){
var inst_32978 = (state_33158[(21)]);
var inst_33126 = (state_33158[(2)]);
var inst_33127 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_33126);
var state_33158__$1 = (function (){var statearr_33201 = state_33158;
(statearr_33201[(15)] = inst_33127);

return statearr_33201;
})();
var G__33202_33271 = inst_32978;
var G__33202_33272__$1 = (((G__33202_33271 instanceof cljs.core.Keyword))?G__33202_33271.fqn:null);
switch (G__33202_33272__$1) {
case "or":
var statearr_33203_33274 = state_33158__$1;
(statearr_33203_33274[(1)] = (43));


break;
case "and":
var statearr_33204_33275 = state_33158__$1;
(statearr_33204_33275[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33202_33272__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (11))){
var inst_32994 = (state_33158[(14)]);
var state_33158__$1 = state_33158;
var statearr_33206_33276 = state_33158__$1;
(statearr_33206_33276[(2)] = inst_32994);

(statearr_33206_33276[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (9))){
var inst_32993 = (state_33158[(17)]);
var inst_33000 = (state_33158[(20)]);
var inst_32999 = cljs.core.seq(inst_32993);
var inst_33000__$1 = cljs.core.first(inst_32999);
var inst_33001 = cljs.core.next(inst_32999);
var inst_33002 = cljs.core.not(inst_33000__$1);
var state_33158__$1 = (function (){var statearr_33207 = state_33158;
(statearr_33207[(22)] = inst_33001);

(statearr_33207[(20)] = inst_33000__$1);

return statearr_33207;
})();
if(inst_33002){
var statearr_33208_33277 = state_33158__$1;
(statearr_33208_33277[(1)] = (11));

} else {
var statearr_33209_33278 = state_33158__$1;
(statearr_33209_33278[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (5))){
var _ = (function (){var statearr_33210 = state_33158;
(statearr_33210[(4)] = cljs.core.rest((state_33158[(4)])));

return statearr_33210;
})();
var state_33158__$1 = state_33158;
var ex33205 = (state_33158__$1[(2)]);
var statearr_33211_33279 = state_33158__$1;
(statearr_33211_33279[(5)] = ex33205);


if((ex33205 instanceof Error)){
var statearr_33212_33280 = state_33158__$1;
(statearr_33212_33280[(1)] = (4));

(statearr_33212_33280[(5)] = null);

} else {
throw ex33205;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (14))){
var inst_33008 = (state_33158[(7)]);
var inst_33014 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_33008);
var inst_33015 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33014)].join('');
var inst_33016 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33017 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33018 = cljs.core.PersistentHashMap.fromArrays(inst_33016,inst_33017);
var inst_33019 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33015,inst_33018);
var inst_33020 = (function(){throw inst_33019})();
var state_33158__$1 = state_33158;
var statearr_33213_33281 = state_33158__$1;
(statearr_33213_33281[(2)] = inst_33020);

(statearr_33213_33281[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (45))){
var inst_33135 = (state_33158[(13)]);
var inst_33138 = cljs.core.empty_QMARK_(inst_33135);
var state_33158__$1 = state_33158;
var statearr_33214_33282 = state_33158__$1;
(statearr_33214_33282[(2)] = inst_33138);

(statearr_33214_33282[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (26))){
var inst_33008 = (state_33158[(7)]);
var inst_33010 = (state_33158[(8)]);
var inst_33064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33065 = [inst_33008,inst_33010];
var inst_33066 = (new cljs.core.PersistentVector(null,2,(5),inst_33064,inst_33065,null));
var inst_33067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33068 = [inst_33008];
var inst_33069 = (new cljs.core.PersistentVector(null,1,(5),inst_33067,inst_33068,null));
var inst_33070 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_33066,cljs.core._LT__EQ_,inst_33069);
var state_33158__$1 = state_33158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33158__$1,(29),inst_33070);
} else {
if((state_val_33159 === (16))){
var inst_33009 = (state_33158[(10)]);
var inst_33027 = (state_33158[(11)]);
var inst_33023 = (state_33158[(2)]);
var inst_33027__$1 = cljs.core.identical_QMARK_;
var inst_33028 = (inst_33027__$1.cljs$core$IFn$_invoke$arity$2 ? inst_33027__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_33009) : inst_33027__$1.call(null,cljs.core.not_EQ_,inst_33009));
var state_33158__$1 = (function (){var statearr_33215 = state_33158;
(statearr_33215[(23)] = inst_33023);

(statearr_33215[(11)] = inst_33027__$1);

return statearr_33215;
})();
if(cljs.core.truth_(inst_33028)){
var statearr_33216_33283 = state_33158__$1;
(statearr_33216_33283[(1)] = (17));

} else {
var statearr_33217_33284 = state_33158__$1;
(statearr_33217_33284[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (38))){
var inst_33008 = (state_33158[(7)]);
var inst_33010 = (state_33158[(8)]);
var inst_33103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33104 = [inst_33008];
var inst_33105 = (new cljs.core.PersistentVector(null,1,(5),inst_33103,inst_33104,null));
var inst_33106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33107 = [inst_33008,inst_33010];
var inst_33108 = (new cljs.core.PersistentVector(null,2,(5),inst_33106,inst_33107,null));
var inst_33109 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_33105,cljs.core._LT__EQ_,inst_33108);
var state_33158__$1 = state_33158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33158__$1,(41),inst_33109);
} else {
if((state_val_33159 === (30))){
var inst_33008 = (state_33158[(7)]);
var inst_33010 = (state_33158[(8)]);
var inst_33077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33078 = [inst_33008,inst_33010];
var inst_33079 = (new cljs.core.PersistentVector(null,2,(5),inst_33077,inst_33078,null));
var inst_33080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33081 = [inst_33008];
var inst_33082 = (new cljs.core.PersistentVector(null,1,(5),inst_33080,inst_33081,null));
var inst_33083 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_33079,cljs.core._LT__EQ_,inst_33082);
var state_33158__$1 = state_33158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33158__$1,(33),inst_33083);
} else {
if((state_val_33159 === (10))){
var inst_33150 = (state_33158[(2)]);
var state_33158__$1 = state_33158;
var statearr_33218_33285 = state_33158__$1;
(statearr_33218_33285[(2)] = inst_33150);

(statearr_33218_33285[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (18))){
var inst_33009 = (state_33158[(10)]);
var inst_33027 = (state_33158[(11)]);
var inst_33052 = (inst_33027.cljs$core$IFn$_invoke$arity$2 ? inst_33027.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_33009) : inst_33027.call(null,cljs.core._EQ_,inst_33009));
var state_33158__$1 = state_33158;
if(cljs.core.truth_(inst_33052)){
var statearr_33219_33286 = state_33158__$1;
(statearr_33219_33286[(1)] = (22));

} else {
var statearr_33220_33287 = state_33158__$1;
(statearr_33220_33287[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (42))){
var inst_33136 = (state_33158[(12)]);
var inst_32978 = (state_33158[(21)]);
var inst_33135 = (state_33158[(2)]);
var inst_33136__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_32978);
var state_33158__$1 = (function (){var statearr_33221 = state_33158;
(statearr_33221[(12)] = inst_33136__$1);

(statearr_33221[(13)] = inst_33135);

return statearr_33221;
})();
if(inst_33136__$1){
var statearr_33222_33288 = state_33158__$1;
(statearr_33222_33288[(1)] = (45));

} else {
var statearr_33223_33289 = state_33158__$1;
(statearr_33223_33289[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (37))){
var inst_33098 = (state_33158[(2)]);
var inst_33099 = fluree.db.util.async.throw_err(inst_33098);
var state_33158__$1 = state_33158;
var statearr_33224_33290 = state_33158__$1;
(statearr_33224_33290[(2)] = inst_33099);

(statearr_33224_33290[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (8))){
var inst_33153 = (state_33158[(2)]);
var _ = (function (){var statearr_33225 = state_33158;
(statearr_33225[(4)] = cljs.core.rest((state_33158[(4)])));

return statearr_33225;
})();
var state_33158__$1 = state_33158;
var statearr_33226_33291 = state_33158__$1;
(statearr_33226_33291[(2)] = inst_33153);

(statearr_33226_33291[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33159 === (49))){
var inst_33001 = (state_33158[(22)]);
var inst_33135 = (state_33158[(13)]);
var inst_32993 = inst_33001;
var inst_32994 = inst_33135;
var state_33158__$1 = (function (){var statearr_33227 = state_33158;
(statearr_33227[(17)] = inst_32993);

(statearr_33227[(14)] = inst_32994);

return statearr_33227;
})();
var statearr_33228_33292 = state_33158__$1;
(statearr_33228_33292[(2)] = null);

(statearr_33228_33292[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10798__auto__ = null;
var fluree$db$query$fql$state_machine__10798__auto____0 = (function (){
var statearr_33229 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33229[(0)] = fluree$db$query$fql$state_machine__10798__auto__);

(statearr_33229[(1)] = (1));

return statearr_33229;
});
var fluree$db$query$fql$state_machine__10798__auto____1 = (function (state_33158){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_33158);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e33230){var ex__10801__auto__ = e33230;
var statearr_33231_33293 = state_33158;
(statearr_33231_33293[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_33158[(4)]))){
var statearr_33232_33294 = state_33158;
(statearr_33232_33294[(1)] = cljs.core.first((state_33158[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__33295 = state_33158;
state_33158 = G__33295;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10798__auto__ = function(state_33158){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10798__auto____1.call(this,state_33158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10798__auto____0;
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10798__auto____1;
return fluree$db$query$fql$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_33233 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_33233[(6)] = c__10835__auto__);

return statearr_33233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4223__auto__ = cljs.core.every_QMARK_((function (p1__33296_SHARP_){
return ((typeof p1__33296_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__33296_SHARP_)));
}),select_smt);
if(or__4223__auto__){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__33297_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__33297_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__33301 = vars;
var vec__33302 = G__33301;
var seq__33303 = cljs.core.seq(vec__33302);
var first__33304 = cljs.core.first(seq__33303);
var seq__33303__$1 = cljs.core.next(seq__33303);
var var$ = first__33304;
var r = seq__33303__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__33301__$1 = G__33301;
var all_vars__$1 = all_vars;
while(true){
var vec__33309 = G__33301__$1;
var seq__33310 = cljs.core.seq(vec__33309);
var first__33311 = cljs.core.first(seq__33310);
var seq__33310__$1 = cljs.core.next(seq__33310);
var var$__$1 = first__33311;
var r__$1 = seq__33310__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__33312 = cljs.core.set(all_vars__$2);
return (fexpr__33312.cljs$core$IFn$_invoke$arity$1 ? fexpr__33312.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__33312.call(null,var$__$1));
})())){
var G__33313 = r__$1;
var G__33314 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__33301__$1 = G__33313;
all_vars__$1 = G__33314;
continue;
} else {
var G__33315 = r__$1;
var G__33316 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__33301__$1 = G__33315;
all_vars__$1 = G__33316;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_33351){
var state_val_33352 = (state_33351[(1)]);
if((state_val_33352 === (1))){
var inst_33324 = functionArray;
var inst_33325 = cljs.core.seq(inst_33324);
var inst_33326 = cljs.core.first(inst_33325);
var inst_33327 = cljs.core.next(inst_33325);
var inst_33328 = cljs.core.PersistentVector.EMPTY;
var inst_33329 = inst_33324;
var inst_33330 = inst_33328;
var state_33351__$1 = (function (){var statearr_33353 = state_33351;
(statearr_33353[(7)] = inst_33327);

(statearr_33353[(8)] = inst_33330);

(statearr_33353[(9)] = inst_33326);

(statearr_33353[(10)] = inst_33329);

return statearr_33353;
})();
var statearr_33354_33367 = state_33351__$1;
(statearr_33354_33367[(2)] = null);

(statearr_33354_33367[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33352 === (2))){
var inst_33336 = (state_33351[(11)]);
var inst_33329 = (state_33351[(10)]);
var inst_33335 = cljs.core.seq(inst_33329);
var inst_33336__$1 = cljs.core.first(inst_33335);
var inst_33337 = cljs.core.next(inst_33335);
var state_33351__$1 = (function (){var statearr_33355 = state_33351;
(statearr_33355[(12)] = inst_33337);

(statearr_33355[(11)] = inst_33336__$1);

return statearr_33355;
})();
if(cljs.core.truth_(inst_33336__$1)){
var statearr_33356_33368 = state_33351__$1;
(statearr_33356_33368[(1)] = (4));

} else {
var statearr_33357_33369 = state_33351__$1;
(statearr_33357_33369[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33352 === (3))){
var inst_33349 = (state_33351[(2)]);
var state_33351__$1 = state_33351;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33351__$1,inst_33349);
} else {
if((state_val_33352 === (4))){
var inst_33336 = (state_33351[(11)]);
var inst_33339 = (inst_33336.cljs$core$IFn$_invoke$arity$1 ? inst_33336.cljs$core$IFn$_invoke$arity$1(tuple) : inst_33336.call(null,tuple));
var state_33351__$1 = state_33351;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33351__$1,(7),inst_33339);
} else {
if((state_val_33352 === (5))){
var inst_33330 = (state_33351[(8)]);
var state_33351__$1 = state_33351;
var statearr_33358_33370 = state_33351__$1;
(statearr_33358_33370[(2)] = inst_33330);

(statearr_33358_33370[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33352 === (6))){
var inst_33347 = (state_33351[(2)]);
var state_33351__$1 = state_33351;
var statearr_33359_33371 = state_33351__$1;
(statearr_33359_33371[(2)] = inst_33347);

(statearr_33359_33371[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33352 === (7))){
var inst_33337 = (state_33351[(12)]);
var inst_33330 = (state_33351[(8)]);
var inst_33341 = (state_33351[(2)]);
var inst_33342 = fluree.db.util.async.throw_err(inst_33341);
var inst_33343 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33330,inst_33342);
var inst_33329 = inst_33337;
var inst_33330__$1 = inst_33343;
var state_33351__$1 = (function (){var statearr_33360 = state_33351;
(statearr_33360[(8)] = inst_33330__$1);

(statearr_33360[(10)] = inst_33329);

return statearr_33360;
})();
var statearr_33361_33372 = state_33351__$1;
(statearr_33361_33372[(2)] = null);

(statearr_33361_33372[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__10798__auto____0 = (function (){
var statearr_33362 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33362[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__10798__auto__);

(statearr_33362[(1)] = (1));

return statearr_33362;
});
var fluree$db$query$fql$format_tuple_$_state_machine__10798__auto____1 = (function (state_33351){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_33351);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e33363){var ex__10801__auto__ = e33363;
var statearr_33364_33373 = state_33351;
(statearr_33364_33373[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_33351[(4)]))){
var statearr_33365_33374 = state_33351;
(statearr_33365_33374[(1)] = cljs.core.first((state_33351[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__33375 = state_33351;
state_33351 = G__33375;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__10798__auto__ = function(state_33351){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__10798__auto____1.call(this,state_33351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__10798__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__10798__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_33366 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_33366[(6)] = c__10835__auto__);

return statearr_33366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__33376){
var vec__33377 = p__33376;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33377,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33377,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_33391){
var state_val_33392 = (state_33391[(1)]);
if((state_val_33392 === (1))){
var inst_33380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33381 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_33382 = [query_map,_id,query_opts];
var inst_33383 = cljs.core.PersistentHashMap.fromArrays(inst_33381,inst_33382);
var inst_33384 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_33383) : fluree.db.query.fql.query.call(null,db,inst_33383));
var state_33391__$1 = (function (){var statearr_33393 = state_33391;
(statearr_33393[(7)] = inst_33380);

return statearr_33393;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33391__$1,(2),inst_33384);
} else {
if((state_val_33392 === (2))){
var inst_33380 = (state_33391[(7)]);
var inst_33386 = (state_33391[(2)]);
var inst_33387 = fluree.db.util.async.throw_err(inst_33386);
var inst_33388 = [tuple_index,inst_33387];
var inst_33389 = (new cljs.core.PersistentVector(null,2,(5),inst_33380,inst_33388,null));
var state_33391__$1 = state_33391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33391__$1,inst_33389);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__10798__auto____0 = (function (){
var statearr_33394 = [null,null,null,null,null,null,null,null];
(statearr_33394[(0)] = fluree$db$query$fql$expand_map_$_state_machine__10798__auto__);

(statearr_33394[(1)] = (1));

return statearr_33394;
});
var fluree$db$query$fql$expand_map_$_state_machine__10798__auto____1 = (function (state_33391){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_33391);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e33395){var ex__10801__auto__ = e33395;
var statearr_33396_33399 = state_33391;
(statearr_33396_33399[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_33391[(4)]))){
var statearr_33397_33400 = state_33391;
(statearr_33397_33400[(1)] = cljs.core.first((state_33391[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__33401 = state_33391;
state_33391 = G__33401;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__10798__auto__ = function(state_33391){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__10798__auto____1.call(this,state_33391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__10798__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__10798__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_33398 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_33398[(6)] = c__10835__auto__);

return statearr_33398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__33402 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33402,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33402,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_33467){
var state_val_33468 = (state_33467[(1)]);
if((state_val_33468 === (7))){
var inst_33462 = (state_33467[(2)]);
var _ = (function (){var statearr_33469 = state_33467;
(statearr_33469[(4)] = cljs.core.rest((state_33467[(4)])));

return statearr_33469;
})();
var state_33467__$1 = state_33467;
var statearr_33470_33561 = state_33467__$1;
(statearr_33470_33561[(2)] = inst_33462);

(statearr_33470_33561[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (20))){
var inst_33453 = (state_33467[(2)]);
var state_33467__$1 = state_33467;
var statearr_33471_33562 = state_33467__$1;
(statearr_33471_33562[(2)] = inst_33453);

(statearr_33471_33562[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (1))){
var state_33467__$1 = state_33467;
var statearr_33472_33563 = state_33467__$1;
(statearr_33472_33563[(2)] = null);

(statearr_33472_33563[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (4))){
var inst_33407 = (state_33467[(2)]);
var state_33467__$1 = state_33467;
var statearr_33473_33564 = state_33467__$1;
(statearr_33473_33564[(2)] = inst_33407);

(statearr_33473_33564[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (15))){
var inst_33427 = (state_33467[(7)]);
var inst_33436 = cljs.core._deref(fuel);
var inst_33437 = cljs.core.second(inst_33427);
var inst_33438 = (inst_33436 + inst_33437);
var inst_33439 = cljs.core._vreset_BANG_(fuel,inst_33438);
var inst_33440 = (inst_33439 > max_fuel);
var state_33467__$1 = state_33467;
if(cljs.core.truth_(inst_33440)){
var statearr_33474_33565 = state_33467__$1;
(statearr_33474_33565[(1)] = (18));

} else {
var statearr_33475_33566 = state_33467__$1;
(statearr_33475_33566[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (13))){
var state_33467__$1 = state_33467;
var statearr_33476_33567 = state_33467__$1;
(statearr_33476_33567[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (6))){
var inst_33415 = (state_33467[(8)]);
var state_33467__$1 = state_33467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33467__$1,(8),inst_33415);
} else {
if((state_val_33468 === (17))){
var inst_33456 = (state_33467[(2)]);
var state_33467__$1 = state_33467;
var statearr_33478_33568 = state_33467__$1;
(statearr_33478_33568[(2)] = inst_33456);

(statearr_33478_33568[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (3))){
var inst_33465 = (state_33467[(2)]);
var state_33467__$1 = state_33467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33467__$1,inst_33465);
} else {
if((state_val_33468 === (12))){
var inst_33427 = (state_33467[(7)]);
var inst_33416 = (state_33467[(9)]);
var inst_33433 = (inst_33416.cljs$core$IFn$_invoke$arity$0 ? inst_33416.cljs$core$IFn$_invoke$arity$0() : inst_33416.call(null));
var state_33467__$1 = (function (){var statearr_33479 = state_33467;
(statearr_33479[(10)] = inst_33433);

return statearr_33479;
})();
var statearr_33480_33569 = state_33467__$1;
(statearr_33480_33569[(2)] = inst_33427);

(statearr_33480_33569[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (2))){
var inst_33416 = (state_33467[(9)]);
var inst_33415 = (state_33467[(8)]);
var _ = (function (){var statearr_33481 = state_33467;
(statearr_33481[(4)] = cljs.core.cons((5),(state_33467[(4)])));

return statearr_33481;
})();
var inst_33413 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_33414 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_33415__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_33416__$1 = (function (){var expandMaps = inst_33413;
var queue_ch = inst_33414;
var res_ch = inst_33415__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_33417 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_33418 = cljs.core.volatile_BANG_((0));
var inst_33419 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33417,cljs.core.cst$kw$fuel,inst_33418);
var inst_33420 = (function (){var expandMaps = inst_33413;
var queue_ch = inst_33414;
var res_ch = inst_33415__$1;
var stop_BANG_ = inst_33416__$1;
var opts_STAR_ = inst_33419;
return (function (tuple_res,port){
var c__10835__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_33514){
var state_val_33515 = (state_33514[(1)]);
if((state_val_33515 === (7))){
var state_33514__$1 = state_33514;
var statearr_33516_33570 = state_33514__$1;
(statearr_33516_33570[(2)] = tuple_res);

(statearr_33516_33570[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33515 === (1))){
var state_33514__$1 = state_33514;
var statearr_33517_33571 = state_33514__$1;
(statearr_33517_33571[(2)] = null);

(statearr_33517_33571[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33515 === (4))){
var inst_33482 = (state_33514[(2)]);
var inst_33483 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_33482);
var inst_33484 = cljs.core.async.close_BANG_(port);
var state_33514__$1 = (function (){var statearr_33518 = state_33514;
(statearr_33518[(7)] = inst_33483);

return statearr_33518;
})();
var statearr_33519_33572 = state_33514__$1;
(statearr_33519_33572[(2)] = inst_33484);

(statearr_33519_33572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33515 === (6))){
var inst_33491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33492 = [tuple_res];
var inst_33493 = (new cljs.core.PersistentVector(null,1,(5),inst_33491,inst_33492,null));
var state_33514__$1 = state_33514;
var statearr_33520_33573 = state_33514__$1;
(statearr_33520_33573[(2)] = inst_33493);

(statearr_33520_33573[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33515 === (3))){
var inst_33512 = (state_33514[(2)]);
var state_33514__$1 = state_33514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33514__$1,inst_33512);
} else {
if((state_val_33515 === (2))){
var ___$1 = (function (){var statearr_33522 = state_33514;
(statearr_33522[(4)] = cljs.core.cons((5),(state_33514[(4)])));

return statearr_33522;
})();
var state_33514__$1 = state_33514;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_33523_33574 = state_33514__$1;
(statearr_33523_33574[(1)] = (6));

} else {
var statearr_33524_33575 = state_33514__$1;
(statearr_33524_33575[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33515 === (9))){
var inst_33496 = (state_33514[(8)]);
var inst_33498 = (state_33514[(9)]);
var inst_33505 = (state_33514[(2)]);
var inst_33506 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_33496,inst_33505);
var inst_33507 = (inst_33498.cljs$core$IFn$_invoke$arity$1 ? inst_33498.cljs$core$IFn$_invoke$arity$1(inst_33506) : inst_33498.call(null,inst_33506));
var inst_33508 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_33507);
var inst_33509 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_33525 = state_33514;
(statearr_33525[(4)] = cljs.core.rest((state_33514[(4)])));

return statearr_33525;
})();
var state_33514__$1 = (function (){var statearr_33526 = state_33514;
(statearr_33526[(10)] = inst_33508);

return statearr_33526;
})();
var statearr_33527_33576 = state_33514__$1;
(statearr_33527_33576[(2)] = inst_33509);

(statearr_33527_33576[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33515 === (5))){
var ___$1 = (function (){var statearr_33528 = state_33514;
(statearr_33528[(4)] = cljs.core.rest((state_33514[(4)])));

return statearr_33528;
})();
var state_33514__$1 = state_33514;
var ex33521 = (state_33514__$1[(2)]);
var statearr_33529_33577 = state_33514__$1;
(statearr_33529_33577[(5)] = ex33521);


var statearr_33530_33578 = state_33514__$1;
(statearr_33530_33578[(1)] = (4));

(statearr_33530_33578[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33515 === (8))){
var inst_33496 = (state_33514[(8)]);
var inst_33496__$1 = (state_33514[(2)]);
var inst_33497 = cljs.core.volatile_BANG_((0));
var inst_33498 = (function (){var tuple_res_SINGLEQUOTE_ = inst_33496__$1;
var query_fuel = inst_33497;
return (function (p1__33406_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__33406_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33406_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_33499 = cljs.core.PersistentVector.EMPTY;
var inst_33500 = (function (){var tuple_res_SINGLEQUOTE_ = inst_33496__$1;
var query_fuel = inst_33497;
return (function (p1__33405_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__33405_SHARP_);
});
})();
var inst_33501 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_33500,expandMaps);
var inst_33502 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_33501);
var inst_33503 = cljs.core.async.into(inst_33499,inst_33502);
var state_33514__$1 = (function (){var statearr_33531 = state_33514;
(statearr_33531[(8)] = inst_33496__$1);

(statearr_33531[(9)] = inst_33498);

return statearr_33531;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33514__$1,(9),inst_33503);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____0 = (function (){
var statearr_33532 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33532[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__);

(statearr_33532[(1)] = (1));

return statearr_33532;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____1 = (function (state_33514){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_33514);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e33533){var ex__10801__auto__ = e33533;
var statearr_33534_33579 = state_33514;
(statearr_33534_33579[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_33514[(4)]))){
var statearr_33535_33580 = state_33514;
(statearr_33535_33580[(1)] = cljs.core.first((state_33514[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__33581 = state_33514;
state_33514 = G__33581;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__ = function(state_33514){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____1.call(this,state_33514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_33536 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_33536[(6)] = c__10835__auto____$1);

return statearr_33536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto____$1;
});
})();
var inst_33421 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33414,tuples_res);
var inst_33422 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_33415__$1,inst_33420,inst_33414);
var inst_33423 = cljs.core.PersistentVector.EMPTY;
var inst_33424 = inst_33423;
var state_33467__$1 = (function (){var statearr_33537 = state_33467;
(statearr_33537[(11)] = inst_33422);

(statearr_33537[(12)] = inst_33421);

(statearr_33537[(13)] = inst_33424);

(statearr_33537[(9)] = inst_33416__$1);

(statearr_33537[(8)] = inst_33415__$1);

return statearr_33537;
})();
var statearr_33538_33582 = state_33467__$1;
(statearr_33538_33582[(2)] = null);

(statearr_33538_33582[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (19))){
var inst_33427 = (state_33467[(7)]);
var inst_33424 = (state_33467[(13)]);
var inst_33449 = cljs.core.first(inst_33427);
var inst_33450 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33424,inst_33449);
var inst_33424__$1 = inst_33450;
var state_33467__$1 = (function (){var statearr_33539 = state_33467;
(statearr_33539[(13)] = inst_33424__$1);

return statearr_33539;
})();
var statearr_33540_33583 = state_33467__$1;
(statearr_33540_33583[(2)] = null);

(statearr_33540_33583[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (11))){
var inst_33460 = (state_33467[(2)]);
var state_33467__$1 = state_33467;
var statearr_33542_33584 = state_33467__$1;
(statearr_33542_33584[(2)] = inst_33460);

(statearr_33542_33584[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (9))){
var inst_33424 = (state_33467[(13)]);
var state_33467__$1 = state_33467;
var statearr_33543_33585 = state_33467__$1;
(statearr_33543_33585[(2)] = inst_33424);

(statearr_33543_33585[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (5))){
var _ = (function (){var statearr_33544 = state_33467;
(statearr_33544[(4)] = cljs.core.rest((state_33467[(4)])));

return statearr_33544;
})();
var state_33467__$1 = state_33467;
var ex33541 = (state_33467__$1[(2)]);
var statearr_33545_33586 = state_33467__$1;
(statearr_33545_33586[(5)] = ex33541);


if((ex33541 instanceof Error)){
var statearr_33546_33587 = state_33467__$1;
(statearr_33546_33587[(1)] = (4));

(statearr_33546_33587[(5)] = null);

} else {
throw ex33541;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (14))){
var inst_33458 = (state_33467[(2)]);
var state_33467__$1 = state_33467;
var statearr_33547_33588 = state_33467__$1;
(statearr_33547_33588[(2)] = inst_33458);

(statearr_33547_33588[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (16))){
var state_33467__$1 = state_33467;
var statearr_33548_33589 = state_33467__$1;
(statearr_33548_33589[(2)] = null);

(statearr_33548_33589[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (10))){
var inst_33427 = (state_33467[(7)]);
var inst_33431 = fluree.db.util.core.exception_QMARK_(inst_33427);
var state_33467__$1 = state_33467;
if(inst_33431){
var statearr_33549_33590 = state_33467__$1;
(statearr_33549_33590[(1)] = (12));

} else {
var statearr_33550_33591 = state_33467__$1;
(statearr_33550_33591[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (18))){
var inst_33416 = (state_33467[(9)]);
var inst_33442 = (inst_33416.cljs$core$IFn$_invoke$arity$0 ? inst_33416.cljs$core$IFn$_invoke$arity$0() : inst_33416.call(null));
var inst_33443 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_33444 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_33445 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_33446 = cljs.core.PersistentHashMap.fromArrays(inst_33444,inst_33445);
var inst_33447 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33443,inst_33446);
var state_33467__$1 = (function (){var statearr_33551 = state_33467;
(statearr_33551[(14)] = inst_33442);

return statearr_33551;
})();
var statearr_33552_33592 = state_33467__$1;
(statearr_33552_33592[(2)] = inst_33447);

(statearr_33552_33592[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33468 === (8))){
var inst_33427 = (state_33467[(7)]);
var inst_33427__$1 = (state_33467[(2)]);
var inst_33428 = (inst_33427__$1 == null);
var state_33467__$1 = (function (){var statearr_33553 = state_33467;
(statearr_33553[(7)] = inst_33427__$1);

return statearr_33553;
})();
if(cljs.core.truth_(inst_33428)){
var statearr_33554_33593 = state_33467__$1;
(statearr_33554_33593[(1)] = (9));

} else {
var statearr_33555_33594 = state_33467__$1;
(statearr_33555_33594[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____0 = (function (){
var statearr_33556 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33556[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__);

(statearr_33556[(1)] = (1));

return statearr_33556;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____1 = (function (state_33467){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_33467);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e33557){var ex__10801__auto__ = e33557;
var statearr_33558_33595 = state_33467;
(statearr_33558_33595[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_33467[(4)]))){
var statearr_33559_33596 = state_33467;
(statearr_33559_33596[(1)] = cljs.core.first((state_33467[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__33597 = state_33467;
state_33467 = G__33597;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__ = function(state_33467){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____1.call(this,state_33467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_33560 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_33560[(6)] = c__10835__auto__);

return statearr_33560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__33598 = select;
var map__33598__$1 = cljs.core.__destructure_map(map__33598);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33598__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33598__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33598__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4223__auto__ = as;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__33601 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33601,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33601,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33601,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__33599_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__33599_SHARP_,compare_idx));
}):(function (p1__33600_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__33600_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples))));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__33606 = arguments.length;
switch (G__33606) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__33607,p__33608,group_limit,opts){
var map__33609 = p__33607;
var map__33609__$1 = cljs.core.__destructure_map(map__33609);
var res = map__33609__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33609__$1,cljs.core.cst$kw$vars);
var map__33610 = p__33608;
var map__33610__$1 = cljs.core.__destructure_map(map__33610);
var select_spec = map__33610__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33610__$1,cljs.core.cst$kw$groupBy);
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_33747){
var state_val_33748 = (state_33747[(1)]);
if((state_val_33748 === (7))){
var inst_33617 = (state_33747[(7)]);
var state_33747__$1 = state_33747;
var statearr_33749_33851 = state_33747__$1;
(statearr_33749_33851[(2)] = inst_33617);

(statearr_33749_33851[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (59))){
var inst_33740 = (state_33747[(2)]);
var state_33747__$1 = state_33747;
var statearr_33750_33852 = state_33747__$1;
(statearr_33750_33852[(2)] = inst_33740);

(statearr_33750_33852[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (20))){
var inst_33656 = (state_33747[(8)]);
var inst_33653 = (state_33747[(9)]);
var inst_33652 = (state_33747[(2)]);
var inst_33653__$1 = cljs.core.__destructure_map(inst_33652);
var inst_33654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33653__$1,cljs.core.cst$kw$headers);
var inst_33655 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33653__$1,cljs.core.cst$kw$tuples);
var inst_33656__$1 = offset;
var state_33747__$1 = (function (){var statearr_33751 = state_33747;
(statearr_33751[(8)] = inst_33656__$1);

(statearr_33751[(10)] = inst_33655);

(statearr_33751[(11)] = inst_33654);

(statearr_33751[(9)] = inst_33653__$1);

return statearr_33751;
})();
if(cljs.core.truth_(inst_33656__$1)){
var statearr_33752_33853 = state_33747__$1;
(statearr_33752_33853[(1)] = (21));

} else {
var statearr_33753_33854 = state_33747__$1;
(statearr_33753_33854[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (58))){
var inst_33732 = (state_33747[(12)]);
var state_33747__$1 = state_33747;
var statearr_33754_33855 = state_33747__$1;
(statearr_33754_33855[(2)] = inst_33732);

(statearr_33754_33855[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (60))){
var inst_33736 = (state_33747[(2)]);
var inst_33737 = fluree.db.util.async.throw_err(inst_33736);
var state_33747__$1 = state_33747;
var statearr_33755_33856 = state_33747__$1;
(statearr_33755_33856[(2)] = inst_33737);

(statearr_33755_33856[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (27))){
var inst_33668 = cljs.core.not(inVector_QMARK_);
var state_33747__$1 = state_33747;
var statearr_33756_33857 = state_33747__$1;
(statearr_33756_33857[(2)] = inst_33668);

(statearr_33756_33857[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (1))){
var state_33747__$1 = state_33747;
var statearr_33757_33858 = state_33747__$1;
(statearr_33757_33858[(2)] = null);

(statearr_33757_33858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (24))){
var state_33747__$1 = state_33747;
var statearr_33758_33859 = state_33747__$1;
(statearr_33758_33859[(2)] = offset);

(statearr_33758_33859[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (55))){
var inst_33726 = (state_33747[(13)]);
var state_33747__$1 = state_33747;
var statearr_33759_33860 = state_33747__$1;
(statearr_33759_33860[(2)] = inst_33726);

(statearr_33759_33860[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (39))){
var inst_33694 = (state_33747[(14)]);
var inst_33696 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_33697 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33694,inst_33696);
var state_33747__$1 = state_33747;
var statearr_33760_33861 = state_33747__$1;
(statearr_33760_33861[(2)] = inst_33697);

(statearr_33760_33861[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (46))){
var inst_33706 = (state_33747[(15)]);
var state_33747__$1 = state_33747;
var statearr_33761_33862 = state_33747__$1;
(statearr_33761_33862[(2)] = inst_33706);

(statearr_33761_33862[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (4))){
var inst_33611 = (state_33747[(2)]);
var state_33747__$1 = state_33747;
var statearr_33762_33863 = state_33747__$1;
(statearr_33762_33863[(2)] = inst_33611);

(statearr_33762_33863[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (54))){
var inst_33726 = (state_33747[(13)]);
var inst_33720 = (state_33747[(16)]);
var inst_33728 = cljs.core.PersistentVector.EMPTY;
var inst_33729 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_33728,inst_33720,inst_33726);
var state_33747__$1 = state_33747;
var statearr_33763_33864 = state_33747__$1;
(statearr_33763_33864[(2)] = inst_33729);

(statearr_33763_33864[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (15))){
var inst_33638 = (state_33747[(17)]);
var inst_33640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33641 = [inst_33638];
var inst_33642 = (new cljs.core.PersistentVector(null,1,(5),inst_33640,inst_33641,null));
var state_33747__$1 = state_33747;
var statearr_33764_33865 = state_33747__$1;
(statearr_33764_33865[(2)] = inst_33642);

(statearr_33764_33865[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (48))){
var inst_33655 = (state_33747[(10)]);
var inst_33676 = (state_33747[(18)]);
var inst_33665 = (state_33747[(19)]);
var inst_33671 = (state_33747[(20)]);
var inst_33654 = (state_33747[(11)]);
var inst_33653 = (state_33747[(9)]);
var inst_33712 = (state_33747[(21)]);
var inst_33714 = (function (){var map__33647 = inst_33653;
var headers = inst_33654;
var tuples = inst_33655;
var offset_SINGLEQUOTE_ = inst_33665;
var single_result_QMARK_ = inst_33671;
var pp_keys = inst_33676;
var G__33677 = inst_33712;
return (function (p1__33604_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__33604_SHARP_);
});
})();
var inst_33715 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_33714);
var inst_33716 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33712,inst_33715);
var state_33747__$1 = state_33747;
var statearr_33765_33866 = state_33747__$1;
(statearr_33765_33866[(2)] = inst_33716);

(statearr_33765_33866[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (50))){
var inst_33719 = (state_33747[(2)]);
var inst_33720 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_33719);
var state_33747__$1 = (function (){var statearr_33766 = state_33747;
(statearr_33766[(16)] = inst_33720);

return statearr_33766;
})();
if(cljs.core.truth_(orderBy)){
var statearr_33767_33867 = state_33747__$1;
(statearr_33767_33867[(1)] = (51));

} else {
var statearr_33768_33868 = state_33747__$1;
(statearr_33768_33868[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (21))){
var inst_33658 = cljs.core.not(groupBy);
var state_33747__$1 = state_33747;
var statearr_33769_33869 = state_33747__$1;
(statearr_33769_33869[(2)] = inst_33658);

(statearr_33769_33869[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (31))){
var state_33747__$1 = state_33747;
var statearr_33770_33870 = state_33747__$1;
(statearr_33770_33870[(2)] = null);

(statearr_33770_33870[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (32))){
var inst_33671 = (state_33747[(20)]);
var inst_33654 = (state_33747[(11)]);
var inst_33676 = (state_33747[(2)]);
var inst_33678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33679 = fluree.db.query.fql.select_tuples_fn(inst_33654,vars,select);
var inst_33680 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_33679);
var inst_33681 = [inst_33680];
var inst_33682 = (new cljs.core.PersistentVector(null,1,(5),inst_33678,inst_33681,null));
var state_33747__$1 = (function (){var statearr_33771 = state_33747;
(statearr_33771[(18)] = inst_33676);

(statearr_33771[(22)] = inst_33682);

return statearr_33771;
})();
if(cljs.core.truth_(inst_33671)){
var statearr_33772_33871 = state_33747__$1;
(statearr_33772_33871[(1)] = (33));

} else {
var statearr_33773_33872 = state_33747__$1;
(statearr_33773_33872[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (40))){
var inst_33694 = (state_33747[(14)]);
var state_33747__$1 = state_33747;
var statearr_33774_33873 = state_33747__$1;
(statearr_33774_33873[(2)] = inst_33694);

(statearr_33774_33873[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (56))){
var inst_33732 = (state_33747[(2)]);
var state_33747__$1 = (function (){var statearr_33775 = state_33747;
(statearr_33775[(12)] = inst_33732);

return statearr_33775;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_33776_33874 = state_33747__$1;
(statearr_33776_33874[(1)] = (57));

} else {
var statearr_33777_33875 = state_33747__$1;
(statearr_33777_33875[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (33))){
var inst_33682 = (state_33747[(22)]);
var inst_33684 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_33685 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33682,inst_33684);
var state_33747__$1 = state_33747;
var statearr_33778_33876 = state_33747__$1;
(statearr_33778_33876[(2)] = inst_33685);

(statearr_33778_33876[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (13))){
var inst_33627 = (state_33747[(23)]);
var state_33747__$1 = state_33747;
var statearr_33779_33877 = state_33747__$1;
(statearr_33779_33877[(2)] = inst_33627);

(statearr_33779_33877[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (22))){
var inst_33656 = (state_33747[(8)]);
var state_33747__$1 = state_33747;
var statearr_33780_33878 = state_33747__$1;
(statearr_33780_33878[(2)] = inst_33656);

(statearr_33780_33878[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (36))){
var inst_33688 = (state_33747[(24)]);
var inst_33690 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_33691 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33688,inst_33690);
var state_33747__$1 = state_33747;
var statearr_33781_33879 = state_33747__$1;
(statearr_33781_33879[(2)] = inst_33691);

(statearr_33781_33879[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (41))){
var inst_33665 = (state_33747[(19)]);
var inst_33700 = (state_33747[(2)]);
var state_33747__$1 = (function (){var statearr_33782 = state_33747;
(statearr_33782[(25)] = inst_33700);

return statearr_33782;
})();
if(cljs.core.truth_(inst_33665)){
var statearr_33783_33880 = state_33747__$1;
(statearr_33783_33880[(1)] = (42));

} else {
var statearr_33784_33881 = state_33747__$1;
(statearr_33784_33881[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (43))){
var inst_33700 = (state_33747[(25)]);
var state_33747__$1 = state_33747;
var statearr_33785_33882 = state_33747__$1;
(statearr_33785_33882[(2)] = inst_33700);

(statearr_33785_33882[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (29))){
var inst_33671 = (state_33747[(2)]);
var state_33747__$1 = (function (){var statearr_33786 = state_33747;
(statearr_33786[(20)] = inst_33671);

return statearr_33786;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_33787_33883 = state_33747__$1;
(statearr_33787_33883[(1)] = (30));

} else {
var statearr_33788_33884 = state_33747__$1;
(statearr_33788_33884[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (44))){
var inst_33706 = (state_33747[(2)]);
var state_33747__$1 = (function (){var statearr_33789 = state_33747;
(statearr_33789[(15)] = inst_33706);

return statearr_33789;
})();
if(cljs.core.truth_(group_limit)){
var statearr_33790_33885 = state_33747__$1;
(statearr_33790_33885[(1)] = (45));

} else {
var statearr_33791_33886 = state_33747__$1;
(statearr_33791_33886[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (6))){
var inst_33619 = cljs.core.count(select);
var inst_33620 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_33619);
var state_33747__$1 = state_33747;
var statearr_33792_33887 = state_33747__$1;
(statearr_33792_33887[(2)] = inst_33620);

(statearr_33792_33887[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (28))){
var inst_33666 = (state_33747[(26)]);
var state_33747__$1 = state_33747;
var statearr_33793_33888 = state_33747__$1;
(statearr_33793_33888[(2)] = inst_33666);

(statearr_33793_33888[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (51))){
var inst_33655 = (state_33747[(10)]);
var inst_33654 = (state_33747[(11)]);
var inst_33723 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_33654,orderBy,inst_33655);
var state_33747__$1 = state_33747;
var statearr_33794_33889 = state_33747__$1;
(statearr_33794_33889[(2)] = inst_33723);

(statearr_33794_33889[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (25))){
var state_33747__$1 = state_33747;
var statearr_33795_33890 = state_33747__$1;
(statearr_33795_33890[(2)] = null);

(statearr_33795_33890[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (34))){
var inst_33682 = (state_33747[(22)]);
var state_33747__$1 = state_33747;
var statearr_33796_33891 = state_33747__$1;
(statearr_33796_33891[(2)] = inst_33682);

(statearr_33796_33891[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (17))){
var inst_33645 = (state_33747[(2)]);
var state_33747__$1 = state_33747;
var statearr_33797_33892 = state_33747__$1;
(statearr_33797_33892[(2)] = inst_33645);

(statearr_33797_33892[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (3))){
var inst_33745 = (state_33747[(2)]);
var state_33747__$1 = state_33747;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33747__$1,inst_33745);
} else {
if((state_val_33748 === (12))){
var inst_33627 = (state_33747[(23)]);
var inst_33629 = cljs.core.first(select);
var inst_33630 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_33629);
var inst_33631 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33630);
var inst_33632 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_33631,(1));
var inst_33633 = [inst_33632];
var inst_33634 = [inst_33627];
var inst_33635 = cljs.core.PersistentHashMap.fromArrays(inst_33633,inst_33634);
var state_33747__$1 = state_33747;
var statearr_33798_33893 = state_33747__$1;
(statearr_33798_33893[(2)] = inst_33635);

(statearr_33798_33893[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (2))){
var inst_33617 = (state_33747[(7)]);
var _ = (function (){var statearr_33799 = state_33747;
(statearr_33799[(4)] = cljs.core.cons((5),(state_33747[(4)])));

return statearr_33799;
})();
var inst_33617__$1 = aggregates;
var state_33747__$1 = (function (){var statearr_33800 = state_33747;
(statearr_33800[(7)] = inst_33617__$1);

return statearr_33800;
})();
if(cljs.core.truth_(inst_33617__$1)){
var statearr_33801_33894 = state_33747__$1;
(statearr_33801_33894[(1)] = (6));

} else {
var statearr_33802_33895 = state_33747__$1;
(statearr_33802_33895[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (23))){
var inst_33661 = (state_33747[(2)]);
var state_33747__$1 = state_33747;
if(cljs.core.truth_(inst_33661)){
var statearr_33803_33896 = state_33747__$1;
(statearr_33803_33896[(1)] = (24));

} else {
var statearr_33804_33897 = state_33747__$1;
(statearr_33804_33897[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (47))){
var inst_33712 = (state_33747[(2)]);
var state_33747__$1 = (function (){var statearr_33805 = state_33747;
(statearr_33805[(21)] = inst_33712);

return statearr_33805;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_33806_33898 = state_33747__$1;
(statearr_33806_33898[(1)] = (48));

} else {
var statearr_33807_33899 = state_33747__$1;
(statearr_33807_33899[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (35))){
var inst_33688 = (state_33747[(2)]);
var state_33747__$1 = (function (){var statearr_33808 = state_33747;
(statearr_33808[(24)] = inst_33688);

return statearr_33808;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_33809_33900 = state_33747__$1;
(statearr_33809_33900[(1)] = (36));

} else {
var statearr_33810_33901 = state_33747__$1;
(statearr_33810_33901[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (19))){
var state_33747__$1 = state_33747;
var statearr_33811_33902 = state_33747__$1;
(statearr_33811_33902[(2)] = res);

(statearr_33811_33902[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (57))){
var inst_33676 = (state_33747[(18)]);
var inst_33671 = (state_33747[(20)]);
var inst_33732 = (state_33747[(12)]);
var inst_33734 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_33676,inst_33671,db,fuel,max_fuel,opts,(8),inst_33732);
var state_33747__$1 = state_33747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33747__$1,(60),inst_33734);
} else {
if((state_val_33748 === (11))){
var inst_33742 = (state_33747[(2)]);
var _ = (function (){var statearr_33813 = state_33747;
(statearr_33813[(4)] = cljs.core.rest((state_33747[(4)])));

return statearr_33813;
})();
var state_33747__$1 = state_33747;
var statearr_33814_33903 = state_33747__$1;
(statearr_33814_33903[(2)] = inst_33742);

(statearr_33814_33903[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (9))){
var inst_33625 = cljs.core.first(aggregates);
var inst_33626 = fluree.db.query.analytical.calculate_aggregate(res,inst_33625);
var inst_33627 = cljs.core.second(inst_33626);
var state_33747__$1 = (function (){var statearr_33815 = state_33747;
(statearr_33815[(23)] = inst_33627);

return statearr_33815;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_33816_33904 = state_33747__$1;
(statearr_33816_33904[(1)] = (12));

} else {
var statearr_33817_33905 = state_33747__$1;
(statearr_33817_33905[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (5))){
var _ = (function (){var statearr_33818 = state_33747;
(statearr_33818[(4)] = cljs.core.rest((state_33747[(4)])));

return statearr_33818;
})();
var state_33747__$1 = state_33747;
var ex33812 = (state_33747__$1[(2)]);
var statearr_33819_33906 = state_33747__$1;
(statearr_33819_33906[(5)] = ex33812);


if((ex33812 instanceof Error)){
var statearr_33820_33907 = state_33747__$1;
(statearr_33820_33907[(1)] = (4));

(statearr_33820_33907[(5)] = null);

} else {
throw ex33812;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (14))){
var inst_33638 = (state_33747[(2)]);
var state_33747__$1 = (function (){var statearr_33821 = state_33747;
(statearr_33821[(17)] = inst_33638);

return statearr_33821;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_33822_33908 = state_33747__$1;
(statearr_33822_33908[(1)] = (15));

} else {
var statearr_33823_33909 = state_33747__$1;
(statearr_33823_33909[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (45))){
var inst_33706 = (state_33747[(15)]);
var inst_33708 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_33709 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33706,inst_33708);
var state_33747__$1 = state_33747;
var statearr_33824_33910 = state_33747__$1;
(statearr_33824_33910[(2)] = inst_33709);

(statearr_33824_33910[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (53))){
var inst_33726 = (state_33747[(2)]);
var state_33747__$1 = (function (){var statearr_33825 = state_33747;
(statearr_33825[(13)] = inst_33726);

return statearr_33825;
})();
var statearr_33826_33911 = state_33747__$1;
(statearr_33826_33911[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (26))){
var inst_33666 = (state_33747[(26)]);
var inst_33665 = (state_33747[(2)]);
var inst_33666__$1 = cljs.core.not(prettyPrint);
var state_33747__$1 = (function (){var statearr_33828 = state_33747;
(statearr_33828[(19)] = inst_33665);

(statearr_33828[(26)] = inst_33666__$1);

return statearr_33828;
})();
if(inst_33666__$1){
var statearr_33829_33912 = state_33747__$1;
(statearr_33829_33912[(1)] = (27));

} else {
var statearr_33830_33913 = state_33747__$1;
(statearr_33830_33913[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (16))){
var inst_33638 = (state_33747[(17)]);
var state_33747__$1 = state_33747;
var statearr_33831_33914 = state_33747__$1;
(statearr_33831_33914[(2)] = inst_33638);

(statearr_33831_33914[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (38))){
var inst_33694 = (state_33747[(2)]);
var state_33747__$1 = (function (){var statearr_33832 = state_33747;
(statearr_33832[(14)] = inst_33694);

return statearr_33832;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_33833_33915 = state_33747__$1;
(statearr_33833_33915[(1)] = (39));

} else {
var statearr_33834_33916 = state_33747__$1;
(statearr_33834_33916[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (30))){
var inst_33673 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_33747__$1 = state_33747;
var statearr_33835_33917 = state_33747__$1;
(statearr_33835_33917[(2)] = inst_33673);

(statearr_33835_33917[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (10))){
var state_33747__$1 = state_33747;
if(cljs.core.truth_(aggregates)){
var statearr_33836_33918 = state_33747__$1;
(statearr_33836_33918[(1)] = (18));

} else {
var statearr_33837_33919 = state_33747__$1;
(statearr_33837_33919[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (18))){
var inst_33649 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_33747__$1 = state_33747;
var statearr_33838_33920 = state_33747__$1;
(statearr_33838_33920[(2)] = inst_33649);

(statearr_33838_33920[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (52))){
var inst_33655 = (state_33747[(10)]);
var state_33747__$1 = state_33747;
var statearr_33839_33921 = state_33747__$1;
(statearr_33839_33921[(2)] = inst_33655);

(statearr_33839_33921[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (42))){
var inst_33665 = (state_33747[(19)]);
var inst_33700 = (state_33747[(25)]);
var inst_33702 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_33665);
var inst_33703 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33700,inst_33702);
var state_33747__$1 = state_33747;
var statearr_33840_33922 = state_33747__$1;
(statearr_33840_33922[(2)] = inst_33703);

(statearr_33840_33922[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (37))){
var inst_33688 = (state_33747[(24)]);
var state_33747__$1 = state_33747;
var statearr_33841_33923 = state_33747__$1;
(statearr_33841_33923[(2)] = inst_33688);

(statearr_33841_33923[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (8))){
var inst_33623 = (state_33747[(2)]);
var state_33747__$1 = state_33747;
if(cljs.core.truth_(inst_33623)){
var statearr_33842_33924 = state_33747__$1;
(statearr_33842_33924[(1)] = (9));

} else {
var statearr_33843_33925 = state_33747__$1;
(statearr_33843_33925[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33748 === (49))){
var inst_33712 = (state_33747[(21)]);
var state_33747__$1 = state_33747;
var statearr_33844_33926 = state_33747__$1;
(statearr_33844_33926[(2)] = inst_33712);

(statearr_33844_33926[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10798__auto__ = null;
var fluree$db$query$fql$state_machine__10798__auto____0 = (function (){
var statearr_33845 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33845[(0)] = fluree$db$query$fql$state_machine__10798__auto__);

(statearr_33845[(1)] = (1));

return statearr_33845;
});
var fluree$db$query$fql$state_machine__10798__auto____1 = (function (state_33747){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_33747);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e33846){var ex__10801__auto__ = e33846;
var statearr_33847_33927 = state_33747;
(statearr_33847_33927[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_33747[(4)]))){
var statearr_33848_33928 = state_33747;
(statearr_33848_33928[(1)] = cljs.core.first((state_33747[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__33929 = state_33747;
state_33747 = G__33929;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10798__auto__ = function(state_33747){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10798__auto____1.call(this,state_33747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10798__auto____0;
fluree$db$query$fql$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10798__auto____1;
return fluree$db$query$fql$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_33849 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_33849[(6)] = c__10835__auto__);

return statearr_33849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__33932,groupBy){
var map__33933 = p__33932;
var map__33933__$1 = cljs.core.__destructure_map(map__33933);
var res = map__33933__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33933__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33933__$1,cljs.core.cst$kw$tuples);
var vec__33934 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33934,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33934,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33930_SHARP_){
return fluree.db.util.core.index_of(headers,p1__33930_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33931_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__33931_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__33937 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33937,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33937,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__33940,p__33941,opts){
var map__33942 = p__33940;
var map__33942__$1 = cljs.core.__destructure_map(map__33942);
var res = map__33942__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33942__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33942__$1,cljs.core.cst$kw$vars);
var map__33943 = p__33941;
var map__33943__$1 = cljs.core.__destructure_map(map__33943);
var select_spec = map__33943__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33943__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33943__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33943__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33943__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33943__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33943__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33943__$1,cljs.core.cst$kw$offset);
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_34161){
var state_val_34162 = (state_34161[(1)]);
if((state_val_34162 === (65))){
var inst_34074 = (state_34161[(7)]);
var inst_34102 = cljs.core.empty_QMARK_(inst_34074);
var state_34161__$1 = state_34161;
var statearr_34163_34296 = state_34161__$1;
(statearr_34163_34296[(2)] = inst_34102);

(statearr_34163_34296[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (70))){
var state_34161__$1 = state_34161;
var statearr_34164_34297 = state_34161__$1;
(statearr_34164_34297[(2)] = (1));

(statearr_34164_34297[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (62))){
var state_34161__$1 = state_34161;
var statearr_34165_34298 = state_34161__$1;
(statearr_34165_34298[(2)] = null);

(statearr_34165_34298[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (74))){
var state_34161__$1 = state_34161;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_34166_34299 = state_34161__$1;
(statearr_34166_34299[(1)] = (77));

} else {
var statearr_34167_34300 = state_34161__$1;
(statearr_34167_34300[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (7))){
var state_34161__$1 = state_34161;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_34168_34301 = state_34161__$1;
(statearr_34168_34301[(1)] = (70));

} else {
var statearr_34169_34302 = state_34161__$1;
(statearr_34169_34302[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (59))){
var state_34161__$1 = state_34161;
var statearr_34170_34303 = state_34161__$1;
(statearr_34170_34303[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (20))){
var state_34161__$1 = state_34161;
var statearr_34172_34304 = state_34161__$1;
(statearr_34172_34304[(2)] = (0));

(statearr_34172_34304[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (72))){
var inst_34128 = (state_34161[(2)]);
var inst_34129 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_34128,opts);
var state_34161__$1 = state_34161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34161__$1,(73),inst_34129);
} else {
if((state_val_34162 === (58))){
var inst_34012 = (state_34161[(8)]);
var inst_34086 = (inst_34012 - (1));
var state_34161__$1 = state_34161;
var statearr_34173_34305 = state_34161__$1;
(statearr_34173_34305[(2)] = inst_34086);

(statearr_34173_34305[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (60))){
var inst_34096 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34174_34306 = state_34161__$1;
(statearr_34174_34306[(2)] = inst_34096);

(statearr_34174_34306[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (27))){
var inst_34011 = (state_34161[(9)]);
var inst_34035 = (inst_34011 < (1));
var state_34161__$1 = state_34161;
var statearr_34175_34307 = state_34161__$1;
(statearr_34175_34307[(2)] = inst_34035);

(statearr_34175_34307[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (1))){
var state_34161__$1 = state_34161;
var statearr_34176_34308 = state_34161__$1;
(statearr_34176_34308[(2)] = null);

(statearr_34176_34308[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (69))){
var inst_34081 = (state_34161[(10)]);
var inst_34098 = (state_34161[(11)]);
var inst_34023 = (state_34161[(12)]);
var inst_34026 = (state_34161[(13)]);
var inst_34109 = (state_34161[(2)]);
var inst_34009 = inst_34023;
var inst_34010 = inst_34026;
var inst_34011 = inst_34081;
var inst_34012 = inst_34098;
var inst_34013 = inst_34109;
var state_34161__$1 = (function (){var statearr_34177 = state_34161;
(statearr_34177[(8)] = inst_34012);

(statearr_34177[(14)] = inst_34010);

(statearr_34177[(9)] = inst_34011);

(statearr_34177[(15)] = inst_34013);

(statearr_34177[(16)] = inst_34009);

return statearr_34177;
})();
var statearr_34178_34309 = state_34161__$1;
(statearr_34178_34309[(2)] = null);

(statearr_34178_34309[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (24))){
var inst_34013 = (state_34161[(15)]);
var state_34161__$1 = state_34161;
var statearr_34179_34310 = state_34161__$1;
(statearr_34179_34310[(2)] = inst_34013);

(statearr_34179_34310[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (55))){
var state_34161__$1 = state_34161;
var statearr_34180_34311 = state_34161__$1;
(statearr_34180_34311[(2)] = (0));

(statearr_34180_34311[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (85))){
var inst_34150 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34181_34312 = state_34161__$1;
(statearr_34181_34312[(2)] = inst_34150);

(statearr_34181_34312[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (39))){
var inst_34030 = (state_34161[(17)]);
var inst_34053 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_34054 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_34055 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_34030,inst_34053,inst_34054);
var state_34161__$1 = state_34161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34161__$1,(42),inst_34055);
} else {
if((state_val_34162 === (46))){
var inst_34011 = (state_34161[(9)]);
var inst_34066 = ((0) < inst_34011);
var state_34161__$1 = state_34161;
var statearr_34182_34313 = state_34161__$1;
(statearr_34182_34313[(2)] = inst_34066);

(statearr_34182_34313[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (4))){
var inst_33944 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34183_34314 = state_34161__$1;
(statearr_34183_34314[(2)] = inst_33944);

(statearr_34183_34314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (77))){
var inst_34132 = (state_34161[(18)]);
var inst_34137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34138 = [inst_34132];
var inst_34139 = (new cljs.core.PersistentVector(null,1,(5),inst_34137,inst_34138,null));
var state_34161__$1 = state_34161;
var statearr_34184_34315 = state_34161__$1;
(statearr_34184_34315[(2)] = inst_34139);

(statearr_34184_34315[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (54))){
var inst_34012 = (state_34161[(8)]);
var inst_34081 = (state_34161[(2)]);
var inst_34082 = (inst_34012 <= (0));
var state_34161__$1 = (function (){var statearr_34185 = state_34161;
(statearr_34185[(10)] = inst_34081);

return statearr_34185;
})();
if(cljs.core.truth_(inst_34082)){
var statearr_34186_34316 = state_34161__$1;
(statearr_34186_34316[(1)] = (55));

} else {
var statearr_34187_34317 = state_34161__$1;
(statearr_34187_34317[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (15))){
var inst_33962 = (state_34161[(19)]);
var inst_33970 = (state_34161[(2)]);
var inst_33971 = fluree.db.util.async.throw_err(inst_33970);
var inst_33972 = [inst_33962];
var inst_33973 = [inst_33971];
var inst_33974 = cljs.core.PersistentHashMap.fromArrays(inst_33972,inst_33973);
var state_34161__$1 = state_34161;
var statearr_34188_34318 = state_34161__$1;
(statearr_34188_34318[(2)] = inst_33974);

(statearr_34188_34318[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (48))){
var inst_34069 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
if(cljs.core.truth_(inst_34069)){
var statearr_34189_34319 = state_34161__$1;
(statearr_34189_34319[(1)] = (49));

} else {
var statearr_34190_34320 = state_34161__$1;
(statearr_34190_34320[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (50))){
var inst_34064 = (state_34161[(20)]);
var state_34161__$1 = state_34161;
var statearr_34191_34321 = state_34161__$1;
(statearr_34191_34321[(2)] = inst_34064);

(statearr_34191_34321[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (75))){
var state_34161__$1 = state_34161;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_34192_34322 = state_34161__$1;
(statearr_34192_34322[(1)] = (80));

} else {
var statearr_34193_34323 = state_34161__$1;
(statearr_34193_34323[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (21))){
var inst_33990 = (state_34161[(21)]);
var inst_34002 = (state_34161[(22)]);
var inst_33994 = (state_34161[(23)]);
var inst_34007 = (state_34161[(2)]);
var inst_34008 = cljs.core.PersistentHashMap.EMPTY;
var inst_34009 = inst_33990;
var inst_34010 = inst_33994;
var inst_34011 = inst_34002;
var inst_34012 = inst_34007;
var inst_34013 = inst_34008;
var state_34161__$1 = (function (){var statearr_34194 = state_34161;
(statearr_34194[(8)] = inst_34012);

(statearr_34194[(14)] = inst_34010);

(statearr_34194[(9)] = inst_34011);

(statearr_34194[(15)] = inst_34013);

(statearr_34194[(16)] = inst_34009);

return statearr_34194;
})();
var statearr_34195_34324 = state_34161__$1;
(statearr_34195_34324[(2)] = null);

(statearr_34195_34324[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (31))){
var inst_34012 = (state_34161[(8)]);
var inst_34027 = (state_34161[(24)]);
var inst_34041 = (inst_34012 >= inst_34027);
var state_34161__$1 = state_34161;
if(cljs.core.truth_(inst_34041)){
var statearr_34196_34325 = state_34161__$1;
(statearr_34196_34325[(1)] = (33));

} else {
var statearr_34197_34326 = state_34161__$1;
(statearr_34197_34326[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (32))){
var inst_34117 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34198_34327 = state_34161__$1;
(statearr_34198_34327[(2)] = inst_34117);

(statearr_34198_34327[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (40))){
var state_34161__$1 = state_34161;
var statearr_34199_34328 = state_34161__$1;
(statearr_34199_34328[(2)] = null);

(statearr_34199_34328[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (56))){
var state_34161__$1 = state_34161;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_34200_34329 = state_34161__$1;
(statearr_34200_34329[(1)] = (58));

} else {
var statearr_34201_34330 = state_34161__$1;
(statearr_34201_34330[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (33))){
var state_34161__$1 = state_34161;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_34202_34331 = state_34161__$1;
(statearr_34202_34331[(1)] = (36));

} else {
var statearr_34203_34332 = state_34161__$1;
(statearr_34203_34332[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (13))){
var inst_33990 = (state_34161[(21)]);
var inst_33959 = (state_34161[(25)]);
var inst_33994 = (state_34161[(23)]);
var inst_33990__$1 = cljs.core.keys(inst_33959);
var inst_33991 = cljs.core.seq(inst_33990__$1);
var inst_33992 = cljs.core.first(inst_33991);
var inst_33993 = cljs.core.next(inst_33991);
var inst_33994__$1 = cljs.core.vals(inst_33959);
var inst_33995 = cljs.core.seq(inst_33994__$1);
var inst_33996 = cljs.core.first(inst_33995);
var inst_33997 = cljs.core.next(inst_33995);
var inst_33998 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_34161__$1 = (function (){var statearr_34204 = state_34161;
(statearr_34204[(26)] = inst_33996);

(statearr_34204[(21)] = inst_33990__$1);

(statearr_34204[(27)] = inst_33993);

(statearr_34204[(28)] = inst_33997);

(statearr_34204[(23)] = inst_33994__$1);

(statearr_34204[(29)] = inst_33992);

return statearr_34204;
})();
if(inst_33998){
var statearr_34205_34333 = state_34161__$1;
(statearr_34205_34333[(1)] = (16));

} else {
var statearr_34206_34334 = state_34161__$1;
(statearr_34206_34334[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (22))){
var inst_34010 = (state_34161[(14)]);
var inst_34009 = (state_34161[(16)]);
var inst_34021 = cljs.core.seq(inst_34009);
var inst_34022 = cljs.core.first(inst_34021);
var inst_34023 = cljs.core.next(inst_34021);
var inst_34024 = cljs.core.seq(inst_34010);
var inst_34025 = cljs.core.first(inst_34024);
var inst_34026 = cljs.core.next(inst_34024);
var inst_34027 = cljs.core.count(inst_34025);
var inst_34028 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_34029 = [headers,vars,inst_34025];
var inst_34030 = cljs.core.PersistentHashMap.fromArrays(inst_34028,inst_34029);
var inst_34031 = (inst_34025 == null);
var state_34161__$1 = (function (){var statearr_34207 = state_34161;
(statearr_34207[(24)] = inst_34027);

(statearr_34207[(30)] = inst_34022);

(statearr_34207[(17)] = inst_34030);

(statearr_34207[(12)] = inst_34023);

(statearr_34207[(13)] = inst_34026);

return statearr_34207;
})();
if(cljs.core.truth_(inst_34031)){
var statearr_34208_34335 = state_34161__$1;
(statearr_34208_34335[(1)] = (24));

} else {
var statearr_34209_34336 = state_34161__$1;
(statearr_34209_34336[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (36))){
var inst_34012 = (state_34161[(8)]);
var inst_34044 = (inst_34012 - (1));
var state_34161__$1 = state_34161;
var statearr_34210_34337 = state_34161__$1;
(statearr_34210_34337[(2)] = inst_34044);

(statearr_34210_34337[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (41))){
var inst_34113 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34211_34338 = state_34161__$1;
(statearr_34211_34338[(2)] = inst_34113);

(statearr_34211_34338[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (43))){
var inst_34012 = (state_34161[(8)]);
var inst_34058 = (state_34161[(31)]);
var inst_34061 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_34012,inst_34058);
var state_34161__$1 = state_34161;
var statearr_34212_34339 = state_34161__$1;
(statearr_34212_34339[(2)] = inst_34061);

(statearr_34212_34339[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (61))){
var inst_34012 = (state_34161[(8)]);
var inst_34074 = (state_34161[(7)]);
var inst_34027 = (state_34161[(24)]);
var inst_34089 = cljs.core.count(inst_34074);
var inst_34090 = (inst_34027 - inst_34089);
var inst_34091 = (inst_34012 - inst_34090);
var state_34161__$1 = state_34161;
var statearr_34213_34340 = state_34161__$1;
(statearr_34213_34340[(2)] = inst_34091);

(statearr_34213_34340[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (29))){
var inst_34038 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
if(cljs.core.truth_(inst_34038)){
var statearr_34214_34341 = state_34161__$1;
(statearr_34214_34341[(1)] = (30));

} else {
var statearr_34215_34342 = state_34161__$1;
(statearr_34215_34342[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (44))){
var inst_34058 = (state_34161[(31)]);
var state_34161__$1 = state_34161;
var statearr_34216_34343 = state_34161__$1;
(statearr_34216_34343[(2)] = inst_34058);

(statearr_34216_34343[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (6))){
var inst_33951 = (state_34161[(32)]);
var inst_33951__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_33953 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_34161__$1 = (function (){var statearr_34217 = state_34161;
(statearr_34217[(32)] = inst_33951__$1);

(statearr_34217[(33)] = inst_33953);

return statearr_34217;
})();
if(cljs.core.truth_(inst_33951__$1)){
var statearr_34218_34344 = state_34161__$1;
(statearr_34218_34344[(1)] = (9));

} else {
var statearr_34219_34345 = state_34161__$1;
(statearr_34219_34345[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (28))){
var inst_34011 = (state_34161[(9)]);
var state_34161__$1 = state_34161;
var statearr_34220_34346 = state_34161__$1;
(statearr_34220_34346[(2)] = inst_34011);

(statearr_34220_34346[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (64))){
var inst_34099 = (state_34161[(34)]);
var state_34161__$1 = state_34161;
var statearr_34221_34347 = state_34161__$1;
(statearr_34221_34347[(2)] = inst_34099);

(statearr_34221_34347[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (51))){
var inst_34011 = (state_34161[(9)]);
var inst_34074 = (state_34161[(2)]);
var inst_34075 = (inst_34011 == null);
var state_34161__$1 = (function (){var statearr_34222 = state_34161;
(statearr_34222[(7)] = inst_34074);

return statearr_34222;
})();
if(cljs.core.truth_(inst_34075)){
var statearr_34223_34348 = state_34161__$1;
(statearr_34223_34348[(1)] = (52));

} else {
var statearr_34224_34349 = state_34161__$1;
(statearr_34224_34349[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (25))){
var inst_34011 = (state_34161[(9)]);
var state_34161__$1 = state_34161;
if(cljs.core.truth_(inst_34011)){
var statearr_34225_34350 = state_34161__$1;
(statearr_34225_34350[(1)] = (27));

} else {
var statearr_34226_34351 = state_34161__$1;
(statearr_34226_34351[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (34))){
var state_34161__$1 = state_34161;
var statearr_34227_34352 = state_34161__$1;
(statearr_34227_34352[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (17))){
var state_34161__$1 = state_34161;
var statearr_34229_34353 = state_34161__$1;
(statearr_34229_34353[(2)] = limit);

(statearr_34229_34353[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (3))){
var inst_34159 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34161__$1,inst_34159);
} else {
if((state_val_34162 === (12))){
var inst_33959 = (state_34161[(25)]);
var inst_33961 = cljs.core.keys(inst_33959);
var inst_33962 = cljs.core.first(inst_33961);
var inst_33963 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_33964 = cljs.core.vals(inst_33959);
var inst_33965 = cljs.core.first(inst_33964);
var inst_33966 = [headers,vars,inst_33965];
var inst_33967 = cljs.core.PersistentHashMap.fromArrays(inst_33963,inst_33966);
var inst_33968 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_33967,select_spec,limit,opts);
var state_34161__$1 = (function (){var statearr_34230 = state_34161;
(statearr_34230[(19)] = inst_33962);

return statearr_34230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34161__$1,(15),inst_33968);
} else {
if((state_val_34162 === (2))){
var _ = (function (){var statearr_34231 = state_34161;
(statearr_34231[(4)] = cljs.core.cons((5),(state_34161[(4)])));

return statearr_34231;
})();
var state_34161__$1 = state_34161;
if(cljs.core.truth_(groupBy)){
var statearr_34232_34354 = state_34161__$1;
(statearr_34232_34354[(1)] = (6));

} else {
var statearr_34233_34355 = state_34161__$1;
(statearr_34233_34355[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (66))){
var inst_34104 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
if(cljs.core.truth_(inst_34104)){
var statearr_34234_34356 = state_34161__$1;
(statearr_34234_34356[(1)] = (67));

} else {
var statearr_34235_34357 = state_34161__$1;
(statearr_34235_34357[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (23))){
var inst_34121 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34236_34358 = state_34161__$1;
(statearr_34236_34358[(2)] = inst_34121);

(statearr_34236_34358[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (47))){
var inst_34011 = (state_34161[(9)]);
var state_34161__$1 = state_34161;
var statearr_34237_34359 = state_34161__$1;
(statearr_34237_34359[(2)] = inst_34011);

(statearr_34237_34359[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (35))){
var inst_34115 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34238_34360 = state_34161__$1;
(statearr_34238_34360[(2)] = inst_34115);

(statearr_34238_34360[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (82))){
var inst_34152 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34239_34361 = state_34161__$1;
(statearr_34239_34361[(2)] = inst_34152);

(statearr_34239_34361[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (76))){
var inst_34154 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34240_34362 = state_34161__$1;
(statearr_34240_34362[(2)] = inst_34154);

(statearr_34240_34362[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (19))){
var inst_34003 = (state_34161[(35)]);
var state_34161__$1 = state_34161;
var statearr_34241_34363 = state_34161__$1;
(statearr_34241_34363[(2)] = inst_34003);

(statearr_34241_34363[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (57))){
var inst_34074 = (state_34161[(7)]);
var inst_34099 = (state_34161[(34)]);
var inst_34098 = (state_34161[(2)]);
var inst_34099__$1 = (inst_34074 == null);
var state_34161__$1 = (function (){var statearr_34242 = state_34161;
(statearr_34242[(11)] = inst_34098);

(statearr_34242[(34)] = inst_34099__$1);

return statearr_34242;
})();
if(cljs.core.truth_(inst_34099__$1)){
var statearr_34243_34364 = state_34161__$1;
(statearr_34243_34364[(1)] = (64));

} else {
var statearr_34244_34365 = state_34161__$1;
(statearr_34244_34365[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (68))){
var inst_34074 = (state_34161[(7)]);
var inst_34022 = (state_34161[(30)]);
var inst_34013 = (state_34161[(15)]);
var inst_34107 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34013,inst_34022,inst_34074);
var state_34161__$1 = state_34161;
var statearr_34245_34366 = state_34161__$1;
(statearr_34245_34366[(2)] = inst_34107);

(statearr_34245_34366[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (11))){
var inst_33959 = (state_34161[(2)]);
var state_34161__$1 = (function (){var statearr_34247 = state_34161;
(statearr_34247[(25)] = inst_33959);

return statearr_34247;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_34248_34367 = state_34161__$1;
(statearr_34248_34367[(1)] = (12));

} else {
var statearr_34249_34368 = state_34161__$1;
(statearr_34249_34368[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (9))){
var inst_33951 = (state_34161[(32)]);
var inst_33953 = (state_34161[(33)]);
var inst_33955 = cljs.core.sorted_map_by(inst_33951);
var inst_33956 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33955,inst_33953);
var state_34161__$1 = state_34161;
var statearr_34250_34369 = state_34161__$1;
(statearr_34250_34369[(2)] = inst_33956);

(statearr_34250_34369[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (5))){
var _ = (function (){var statearr_34251 = state_34161;
(statearr_34251[(4)] = cljs.core.rest((state_34161[(4)])));

return statearr_34251;
})();
var state_34161__$1 = state_34161;
var ex34246 = (state_34161__$1[(2)]);
var statearr_34252_34370 = state_34161__$1;
(statearr_34252_34370[(5)] = ex34246);


if((ex34246 instanceof Error)){
var statearr_34253_34371 = state_34161__$1;
(statearr_34253_34371[(1)] = (4));

(statearr_34253_34371[(5)] = null);

} else {
throw ex34246;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (83))){
var inst_34132 = (state_34161[(18)]);
var state_34161__$1 = state_34161;
var statearr_34254_34372 = state_34161__$1;
(statearr_34254_34372[(2)] = inst_34132);

(statearr_34254_34372[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (14))){
var inst_34123 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34255_34373 = state_34161__$1;
(statearr_34255_34373[(2)] = inst_34123);

(statearr_34255_34373[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (45))){
var inst_34011 = (state_34161[(9)]);
var inst_34064 = (state_34161[(2)]);
var state_34161__$1 = (function (){var statearr_34256 = state_34161;
(statearr_34256[(20)] = inst_34064);

return statearr_34256;
})();
if(cljs.core.truth_(inst_34011)){
var statearr_34257_34374 = state_34161__$1;
(statearr_34257_34374[(1)] = (46));

} else {
var statearr_34258_34375 = state_34161__$1;
(statearr_34258_34375[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (53))){
var inst_34074 = (state_34161[(7)]);
var inst_34011 = (state_34161[(9)]);
var inst_34078 = cljs.core.count(inst_34074);
var inst_34079 = (inst_34011 - inst_34078);
var state_34161__$1 = state_34161;
var statearr_34259_34376 = state_34161__$1;
(statearr_34259_34376[(2)] = inst_34079);

(statearr_34259_34376[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (78))){
var inst_34132 = (state_34161[(18)]);
var state_34161__$1 = state_34161;
var statearr_34260_34377 = state_34161__$1;
(statearr_34260_34377[(2)] = inst_34132);

(statearr_34260_34377[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (26))){
var inst_34119 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34261_34378 = state_34161__$1;
(statearr_34261_34378[(2)] = inst_34119);

(statearr_34261_34378[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (16))){
var state_34161__$1 = state_34161;
var statearr_34262_34379 = state_34161__$1;
(statearr_34262_34379[(2)] = null);

(statearr_34262_34379[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (81))){
var state_34161__$1 = state_34161;
var statearr_34265_34380 = state_34161__$1;
(statearr_34265_34380[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (79))){
var inst_34142 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34267_34381 = state_34161__$1;
(statearr_34267_34381[(2)] = inst_34142);

(statearr_34267_34381[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (38))){
var inst_34023 = (state_34161[(12)]);
var inst_34026 = (state_34161[(13)]);
var inst_34011 = (state_34161[(9)]);
var inst_34013 = (state_34161[(15)]);
var inst_34048 = (state_34161[(2)]);
var tmp34263 = inst_34011;
var tmp34264 = inst_34013;
var inst_34009 = inst_34023;
var inst_34010 = inst_34026;
var inst_34011__$1 = tmp34263;
var inst_34012 = inst_34048;
var inst_34013__$1 = tmp34264;
var state_34161__$1 = (function (){var statearr_34268 = state_34161;
(statearr_34268[(8)] = inst_34012);

(statearr_34268[(14)] = inst_34010);

(statearr_34268[(9)] = inst_34011__$1);

(statearr_34268[(15)] = inst_34013__$1);

(statearr_34268[(16)] = inst_34009);

return statearr_34268;
})();
var statearr_34269_34382 = state_34161__$1;
(statearr_34269_34382[(2)] = null);

(statearr_34269_34382[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (30))){
var inst_34013 = (state_34161[(15)]);
var state_34161__$1 = state_34161;
var statearr_34270_34383 = state_34161__$1;
(statearr_34270_34383[(2)] = inst_34013);

(statearr_34270_34383[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (73))){
var inst_34132 = (state_34161[(18)]);
var inst_34131 = (state_34161[(2)]);
var inst_34132__$1 = fluree.db.util.async.throw_err(inst_34131);
var inst_34133 = cljs.core.coll_QMARK_(inst_34132__$1);
var inst_34134 = (!(inst_34133));
var state_34161__$1 = (function (){var statearr_34271 = state_34161;
(statearr_34271[(18)] = inst_34132__$1);

return statearr_34271;
})();
if(inst_34134){
var statearr_34272_34384 = state_34161__$1;
(statearr_34272_34384[(1)] = (74));

} else {
var statearr_34273_34385 = state_34161__$1;
(statearr_34273_34385[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (10))){
var inst_33953 = (state_34161[(33)]);
var state_34161__$1 = state_34161;
var statearr_34274_34386 = state_34161__$1;
(statearr_34274_34386[(2)] = inst_33953);

(statearr_34274_34386[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (18))){
var inst_34003 = (state_34161[(35)]);
var inst_34002 = (state_34161[(2)]);
var inst_34003__$1 = offset;
var state_34161__$1 = (function (){var statearr_34275 = state_34161;
(statearr_34275[(35)] = inst_34003__$1);

(statearr_34275[(22)] = inst_34002);

return statearr_34275;
})();
if(cljs.core.truth_(inst_34003__$1)){
var statearr_34276_34387 = state_34161__$1;
(statearr_34276_34387[(1)] = (19));

} else {
var statearr_34277_34388 = state_34161__$1;
(statearr_34277_34388[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (52))){
var state_34161__$1 = state_34161;
var statearr_34278_34389 = state_34161__$1;
(statearr_34278_34389[(2)] = null);

(statearr_34278_34389[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (67))){
var inst_34013 = (state_34161[(15)]);
var state_34161__$1 = state_34161;
var statearr_34279_34390 = state_34161__$1;
(statearr_34279_34390[(2)] = inst_34013);

(statearr_34279_34390[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (71))){
var state_34161__$1 = state_34161;
var statearr_34280_34391 = state_34161__$1;
(statearr_34280_34391[(2)] = limit);

(statearr_34280_34391[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (42))){
var inst_34012 = (state_34161[(8)]);
var inst_34057 = (state_34161[(2)]);
var inst_34058 = fluree.db.util.async.throw_err(inst_34057);
var inst_34059 = ((0) < inst_34012);
var state_34161__$1 = (function (){var statearr_34281 = state_34161;
(statearr_34281[(31)] = inst_34058);

return statearr_34281;
})();
if(cljs.core.truth_(inst_34059)){
var statearr_34282_34392 = state_34161__$1;
(statearr_34282_34392[(1)] = (43));

} else {
var statearr_34283_34393 = state_34161__$1;
(statearr_34283_34393[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (80))){
var inst_34132 = (state_34161[(18)]);
var inst_34145 = cljs.core.first(inst_34132);
var state_34161__$1 = state_34161;
var statearr_34284_34394 = state_34161__$1;
(statearr_34284_34394[(2)] = inst_34145);

(statearr_34284_34394[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (37))){
var inst_34012 = (state_34161[(8)]);
var inst_34027 = (state_34161[(24)]);
var inst_34046 = (inst_34012 - inst_34027);
var state_34161__$1 = state_34161;
var statearr_34285_34395 = state_34161__$1;
(statearr_34285_34395[(2)] = inst_34046);

(statearr_34285_34395[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (63))){
var inst_34094 = (state_34161[(2)]);
var state_34161__$1 = state_34161;
var statearr_34286_34396 = state_34161__$1;
(statearr_34286_34396[(2)] = inst_34094);

(statearr_34286_34396[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (8))){
var inst_34156 = (state_34161[(2)]);
var _ = (function (){var statearr_34287 = state_34161;
(statearr_34287[(4)] = cljs.core.rest((state_34161[(4)])));

return statearr_34287;
})();
var state_34161__$1 = state_34161;
var statearr_34288_34397 = state_34161__$1;
(statearr_34288_34397[(2)] = inst_34156);

(statearr_34288_34397[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (49))){
var inst_34064 = (state_34161[(20)]);
var inst_34011 = (state_34161[(9)]);
var inst_34071 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_34011,inst_34064);
var state_34161__$1 = state_34161;
var statearr_34289_34398 = state_34161__$1;
(statearr_34289_34398[(2)] = inst_34071);

(statearr_34289_34398[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34162 === (84))){
var state_34161__$1 = state_34161;
var statearr_34290_34399 = state_34161__$1;
(statearr_34290_34399[(2)] = null);

(statearr_34290_34399[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto____0 = (function (){
var statearr_34291 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34291[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto__);

(statearr_34291[(1)] = (1));

return statearr_34291;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto____1 = (function (state_34161){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_34161);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e34292){var ex__10801__auto__ = e34292;
var statearr_34293_34400 = state_34161;
(statearr_34293_34400[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_34161[(4)]))){
var statearr_34294_34401 = state_34161;
(statearr_34294_34401[(1)] = cljs.core.first((state_34161[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__34402 = state_34161;
state_34161 = G__34402;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto__ = function(state_34161){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto____1.call(this,state_34161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_34295 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_34295[(6)] = c__10835__auto__);

return statearr_34295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__34405,opts){
var map__34406 = p__34405;
var map__34406__$1 = cljs.core.__destructure_map(map__34406);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34406__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34406__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34406__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34406__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4223__auto__ = selectOne;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = select;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
var or__4223__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4223__auto____$2)){
return or__4223__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__34403_SHARP_){
return cljs.core.contains_QMARK_(p1__34403_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__34404_SHARP_){
return cljs.core.contains_QMARK_(p1__34404_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4223__auto__ = typeof orderBy === 'string';
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4221__auto__){
var G__34408 = cljs.core.first(orderBy);
var fexpr__34407 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__34407.cljs$core$IFn$_invoke$arity$1 ? fexpr__34407.cljs$core$IFn$_invoke$arity$1(G__34408) : fexpr__34407.call(null,G__34408));
} else {
return and__4221__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4223__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})(),(function (){var or__4223__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4223__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4223__auto__ = selectDistinct;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__34409,p__34410){
var map__34411 = p__34409;
var map__34411__$1 = cljs.core.__destructure_map(map__34411);
var query_map = map__34411__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34411__$1,cljs.core.cst$kw$construct);
var map__34412 = p__34410;
var map__34412__$1 = cljs.core.__destructure_map(map__34412);
var where_result = map__34412__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34412__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34412__$1,cljs.core.cst$kw$tuples);
var vec__34413 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34413,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34413,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34413,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_34446){
var state_val_34447 = (state_34446[(1)]);
if((state_val_34447 === (7))){
var inst_34425 = (state_34446[(7)]);
var state_34446__$1 = state_34446;
var statearr_34448_34471 = state_34446__$1;
(statearr_34448_34471[(2)] = inst_34425);

(statearr_34448_34471[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34447 === (1))){
var state_34446__$1 = state_34446;
var statearr_34449_34472 = state_34446__$1;
(statearr_34449_34472[(2)] = null);

(statearr_34449_34472[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34447 === (4))){
var inst_34416 = (state_34446[(2)]);
var state_34446__$1 = state_34446;
var statearr_34450_34473 = state_34446__$1;
(statearr_34450_34473[(2)] = inst_34416);

(statearr_34450_34473[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34447 === (13))){
var inst_34435 = (state_34446[(2)]);
var inst_34436 = fluree.db.util.async.throw_err(inst_34435);
var state_34446__$1 = state_34446;
var statearr_34451_34474 = state_34446__$1;
(statearr_34451_34474[(2)] = inst_34436);

(statearr_34451_34474[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34447 === (6))){
var inst_34425 = (state_34446[(7)]);
var inst_34424 = (state_34446[(2)]);
var inst_34425__$1 = fluree.db.util.async.throw_err(inst_34424);
var inst_34426 = fluree.db.util.core.exception_QMARK_(inst_34425__$1);
var state_34446__$1 = (function (){var statearr_34452 = state_34446;
(statearr_34452[(7)] = inst_34425__$1);

return statearr_34452;
})();
if(inst_34426){
var statearr_34453_34475 = state_34446__$1;
(statearr_34453_34475[(1)] = (7));

} else {
var statearr_34454_34476 = state_34446__$1;
(statearr_34454_34476[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34447 === (3))){
var inst_34444 = (state_34446[(2)]);
var state_34446__$1 = state_34446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34446__$1,inst_34444);
} else {
if((state_val_34447 === (12))){
var inst_34439 = (state_34446[(2)]);
var state_34446__$1 = state_34446;
var statearr_34455_34477 = state_34446__$1;
(statearr_34455_34477[(2)] = inst_34439);

(statearr_34455_34477[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34447 === (2))){
var _ = (function (){var statearr_34456 = state_34446;
(statearr_34456[(4)] = cljs.core.cons((5),(state_34446[(4)])));

return statearr_34456;
})();
var inst_34422 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_34446__$1 = state_34446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34446__$1,(6),inst_34422);
} else {
if((state_val_34447 === (11))){
var state_34446__$1 = state_34446;
var statearr_34458_34478 = state_34446__$1;
(statearr_34458_34478[(2)] = null);

(statearr_34458_34478[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34447 === (9))){
var inst_34441 = (state_34446[(2)]);
var _ = (function (){var statearr_34459 = state_34446;
(statearr_34459[(4)] = cljs.core.rest((state_34446[(4)])));

return statearr_34459;
})();
var state_34446__$1 = state_34446;
var statearr_34460_34479 = state_34446__$1;
(statearr_34460_34479[(2)] = inst_34441);

(statearr_34460_34479[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34447 === (5))){
var _ = (function (){var statearr_34461 = state_34446;
(statearr_34461[(4)] = cljs.core.rest((state_34446[(4)])));

return statearr_34461;
})();
var state_34446__$1 = state_34446;
var ex34457 = (state_34446__$1[(2)]);
var statearr_34462_34480 = state_34446__$1;
(statearr_34462_34480[(5)] = ex34457);


if((ex34457 instanceof Error)){
var statearr_34463_34481 = state_34446__$1;
(statearr_34463_34481[(1)] = (4));

(statearr_34463_34481[(5)] = null);

} else {
throw ex34457;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34447 === (10))){
var inst_34425 = (state_34446[(7)]);
var inst_34430 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_34425);
var inst_34431 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_34425);
var inst_34432 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_34430,inst_34431,query_map,opts);
var inst_34433 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_34425,inst_34432,opts);
var state_34446__$1 = state_34446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34446__$1,(13),inst_34433);
} else {
if((state_val_34447 === (8))){
var state_34446__$1 = state_34446;
var statearr_34464_34482 = state_34446__$1;
(statearr_34464_34482[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto____0 = (function (){
var statearr_34466 = [null,null,null,null,null,null,null,null];
(statearr_34466[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto__);

(statearr_34466[(1)] = (1));

return statearr_34466;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto____1 = (function (state_34446){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_34446);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e34467){var ex__10801__auto__ = e34467;
var statearr_34468_34483 = state_34446;
(statearr_34468_34483[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_34446[(4)]))){
var statearr_34469_34484 = state_34446;
(statearr_34469_34484[(1)] = cljs.core.first((state_34446[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__34485 = state_34446;
state_34446 = G__34485;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto__ = function(state_34446){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto____1.call(this,state_34446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_34470 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_34470[(6)] = c__10835__auto__);

return statearr_34470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__34486 = query_map;
var map__34486__$1 = cljs.core.__destructure_map(map__34486);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34486__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__34487 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4223__auto__ = offset;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34487,cljs.core.cst$kw$limit,(1));
} else {
return G__34487;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4223__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.truth_((function (){var or__4223__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_34846){
var state_val_34847 = (state_34846[(1)]);
if((state_val_34847 === (121))){
var inst_34807 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34848_35043 = state_34846__$1;
(statearr_34848_35043[(2)] = inst_34807);

(statearr_34848_35043[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (65))){
var inst_34680 = typeof from === 'string';
var state_34846__$1 = state_34846;
if(cljs.core.truth_(inst_34680)){
var statearr_34849_35044 = state_34846__$1;
(statearr_34849_35044[(1)] = (72));

} else {
var statearr_34850_35045 = state_34846__$1;
(statearr_34850_35045[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (70))){
var inst_34551 = (state_34846[(7)]);
var inst_34549 = (state_34846[(8)]);
var inst_34673 = (state_34846[(2)]);
var inst_34674 = fluree.db.util.async.throw_err(inst_34673);
var inst_34675 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_34551,fuel,max_fuel,inst_34549,inst_34674);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(71),inst_34675);
} else {
if((state_val_34847 === (62))){
var inst_34653 = (state_34846[(9)]);
var state_34846__$1 = state_34846;
var statearr_34851_35046 = state_34846__$1;
(statearr_34851_35046[(2)] = inst_34653);

(statearr_34851_35046[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (74))){
var inst_34813 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34852_35047 = state_34846__$1;
(statearr_34852_35047[(2)] = inst_34813);

(statearr_34852_35047[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (110))){
var inst_34746 = (state_34846[(10)]);
var state_34846__$1 = state_34846;
var statearr_34853_35048 = state_34846__$1;
(statearr_34853_35048[(2)] = inst_34746);

(statearr_34853_35048[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (130))){
var inst_34833 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34854_35049 = state_34846__$1;
(statearr_34854_35049[(2)] = inst_34833);

(statearr_34854_35049[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (128))){
var inst_34824 = (state_34846[(11)]);
var inst_34829 = fluree.db.util.core.exception_QMARK_(inst_34824);
var inst_34830 = (!(inst_34829));
var state_34846__$1 = state_34846;
var statearr_34855_35050 = state_34846__$1;
(statearr_34855_35050[(2)] = inst_34830);

(statearr_34855_35050[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (7))){
var inst_34519 = (state_34846[(12)]);
var inst_34519__$1 = selectOne;
var state_34846__$1 = (function (){var statearr_34856 = state_34846;
(statearr_34856[(12)] = inst_34519__$1);

return statearr_34856;
})();
if(cljs.core.truth_(inst_34519__$1)){
var statearr_34857_35051 = state_34846__$1;
(statearr_34857_35051[(1)] = (9));

} else {
var statearr_34858_35052 = state_34846__$1;
(statearr_34858_35052[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (59))){
var inst_34631 = (state_34846[(13)]);
var inst_34551 = (state_34846[(7)]);
var inst_34549 = (state_34846[(8)]);
var inst_34539 = (state_34846[(14)]);
var inst_34645 = (state_34846[(2)]);
var inst_34646 = fluree.db.util.async.throw_err(inst_34645);
var inst_34647 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_34631,inst_34646);
var inst_34648 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_34551,fuel,max_fuel,inst_34549,inst_34647,inst_34539);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(60),inst_34648);
} else {
if((state_val_34847 === (86))){
var inst_34541 = (state_34846[(15)]);
var inst_34551 = (state_34846[(7)]);
var inst_34549 = (state_34846[(8)]);
var inst_34539 = (state_34846[(14)]);
var inst_34713 = (state_34846[(2)]);
var inst_34714 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_34551,fuel,max_fuel,inst_34549,inst_34713,inst_34539,inst_34541);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(87),inst_34714);
} else {
if((state_val_34847 === (20))){
var inst_34583 = (state_34846[(2)]);
var inst_34584 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34583,(0),null);
var inst_34585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34583,(1),null);
var inst_34586 = typeof where === 'string';
var state_34846__$1 = (function (){var statearr_34859 = state_34846;
(statearr_34859[(16)] = inst_34584);

(statearr_34859[(17)] = inst_34585);

return statearr_34859;
})();
if(cljs.core.truth_(inst_34586)){
var statearr_34860_35053 = state_34846__$1;
(statearr_34860_35053[(1)] = (30));

} else {
var statearr_34861_35054 = state_34846__$1;
(statearr_34861_35054[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (72))){
var inst_34538 = (state_34846[(18)]);
var state_34846__$1 = state_34846;
if(cljs.core.truth_(inst_34538)){
var statearr_34862_35055 = state_34846__$1;
(statearr_34862_35055[(1)] = (75));

} else {
var statearr_34863_35056 = state_34846__$1;
(statearr_34863_35056[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (58))){
var inst_34639 = (state_34846[(2)]);
var inst_34640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34641 = [from];
var inst_34642 = (new cljs.core.PersistentVector(null,1,(5),inst_34640,inst_34641,null));
var inst_34643 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_34642,inst_34639);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(59),inst_34643);
} else {
if((state_val_34847 === (60))){
var inst_34650 = (state_34846[(2)]);
var inst_34651 = fluree.db.util.async.throw_err(inst_34650);
var state_34846__$1 = state_34846;
var statearr_34864_35057 = state_34846__$1;
(statearr_34864_35057[(2)] = inst_34651);

(statearr_34864_35057[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (27))){
var inst_34568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34569 = [null,null];
var inst_34570 = (new cljs.core.PersistentVector(null,2,(5),inst_34568,inst_34569,null));
var state_34846__$1 = state_34846;
var statearr_34865_35058 = state_34846__$1;
(statearr_34865_35058[(2)] = inst_34570);

(statearr_34865_35058[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (1))){
var state_34846__$1 = state_34846;
var statearr_34866_35059 = state_34846__$1;
(statearr_34866_35059[(2)] = null);

(statearr_34866_35059[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (69))){
var inst_34670 = (state_34846[(2)]);
var inst_34671 = fluree.db.query.range._block_or_tx_collection(db,inst_34670);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(70),inst_34671);
} else {
if((state_val_34847 === (101))){
var inst_34780 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34867_35060 = state_34846__$1;
(statearr_34867_35060[(2)] = inst_34780);

(statearr_34867_35060[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (24))){
var inst_34538 = (state_34846[(18)]);
var inst_34563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34564 = [inst_34538,"ASC"];
var inst_34565 = (new cljs.core.PersistentVector(null,2,(5),inst_34563,inst_34564,null));
var state_34846__$1 = state_34846;
var statearr_34868_35061 = state_34846__$1;
(statearr_34868_35061[(2)] = inst_34565);

(statearr_34868_35061[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (102))){
var inst_34752 = (state_34846[(19)]);
var state_34846__$1 = state_34846;
var statearr_34869_35062 = state_34846__$1;
(statearr_34869_35062[(2)] = inst_34752);

(statearr_34869_35062[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (55))){
var inst_34538 = (state_34846[(18)]);
var inst_34631 = (state_34846[(2)]);
var state_34846__$1 = (function (){var statearr_34870 = state_34846;
(statearr_34870[(13)] = inst_34631);

return statearr_34870;
})();
if(cljs.core.truth_(inst_34538)){
var statearr_34871_35063 = state_34846__$1;
(statearr_34871_35063[(1)] = (56));

} else {
var statearr_34872_35064 = state_34846__$1;
(statearr_34872_35064[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (85))){
var inst_34705 = (state_34846[(20)]);
var inst_34709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34710 = [inst_34705];
var inst_34711 = (new cljs.core.PersistentVector(null,1,(5),inst_34709,inst_34710,null));
var state_34846__$1 = state_34846;
var statearr_34873_35065 = state_34846__$1;
(statearr_34873_35065[(2)] = inst_34711);

(statearr_34873_35065[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (39))){
var inst_34539 = (state_34846[(14)]);
var state_34846__$1 = state_34846;
var statearr_34874_35066 = state_34846__$1;
(statearr_34874_35066[(2)] = inst_34539);

(statearr_34874_35066[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (88))){
var inst_34719 = cljs.core._deref(fuel);
var inst_34720 = (inst_34719 + (1));
var inst_34721 = cljs.core._vreset_BANG_(fuel,inst_34720);
var state_34846__$1 = state_34846;
var statearr_34875_35067 = state_34846__$1;
(statearr_34875_35067[(2)] = inst_34721);

(statearr_34875_35067[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (46))){
var inst_34616 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
if(cljs.core.truth_(inst_34616)){
var statearr_34876_35068 = state_34846__$1;
(statearr_34876_35068[(1)] = (47));

} else {
var statearr_34877_35069 = state_34846__$1;
(statearr_34877_35069[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (4))){
var inst_34506 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34878_35070 = state_34846__$1;
(statearr_34878_35070[(2)] = inst_34506);

(statearr_34878_35070[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (77))){
var inst_34689 = (state_34846[(2)]);
var inst_34690 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_34689);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(78),inst_34690);
} else {
if((state_val_34847 === (106))){
var state_34846__$1 = state_34846;
var statearr_34879_35071 = state_34846__$1;
(statearr_34879_35071[(2)] = null);

(statearr_34879_35071[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (119))){
var inst_34799 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_34800 = ["Invalid 'from' in query:",inst_34799].join('');
var inst_34801 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34802 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34803 = cljs.core.PersistentHashMap.fromArrays(inst_34801,inst_34802);
var inst_34804 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34800,inst_34803);
var state_34846__$1 = state_34846;
var statearr_34880_35072 = state_34846__$1;
(statearr_34880_35072[(2)] = inst_34804);

(statearr_34880_35072[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (95))){
var state_34846__$1 = state_34846;
var statearr_34881_35073 = state_34846__$1;
(statearr_34881_35073[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (54))){
var inst_34625 = (state_34846[(21)]);
var state_34846__$1 = state_34846;
var statearr_34883_35074 = state_34846__$1;
(statearr_34883_35074[(2)] = inst_34625);

(statearr_34883_35074[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (92))){
var inst_34726 = (state_34846[(22)]);
var state_34846__$1 = state_34846;
var statearr_34884_35075 = state_34846__$1;
(statearr_34884_35075[(2)] = inst_34726);

(statearr_34884_35075[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (104))){
var inst_34772 = (state_34846[(23)]);
var inst_34772__$1 = (state_34846[(2)]);
var state_34846__$1 = (function (){var statearr_34885 = state_34846;
(statearr_34885[(23)] = inst_34772__$1);

return statearr_34885;
})();
if(cljs.core.truth_(inst_34772__$1)){
var statearr_34886_35076 = state_34846__$1;
(statearr_34886_35076[(1)] = (109));

} else {
var statearr_34887_35077 = state_34846__$1;
(statearr_34887_35077[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (15))){
var inst_34542 = (state_34846[(24)]);
var inst_34540 = (state_34846[(25)]);
var inst_34546 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34542,cljs.core.cst$kw$componentFollow_QMARK_,inst_34540);
var state_34846__$1 = state_34846;
var statearr_34888_35078 = state_34846__$1;
(statearr_34888_35078[(2)] = inst_34546);

(statearr_34888_35078[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (48))){
var inst_34653 = (state_34846[(9)]);
var inst_34653__$1 = typeof from === 'string';
var state_34846__$1 = (function (){var statearr_34889 = state_34846;
(statearr_34889[(9)] = inst_34653__$1);

return statearr_34889;
})();
if(cljs.core.truth_(inst_34653__$1)){
var statearr_34890_35079 = state_34846__$1;
(statearr_34890_35079[(1)] = (61));

} else {
var statearr_34891_35080 = state_34846__$1;
(statearr_34891_35080[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (50))){
var inst_34619 = (state_34846[(26)]);
var inst_34621 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_34622 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34619,inst_34621);
var state_34846__$1 = state_34846;
var statearr_34892_35081 = state_34846__$1;
(statearr_34892_35081[(2)] = inst_34622);

(statearr_34892_35081[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (116))){
var state_34846__$1 = state_34846;
var statearr_34893_35082 = state_34846__$1;
(statearr_34893_35082[(2)] = null);

(statearr_34893_35082[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (75))){
var inst_34683 = cljs.core.PersistentHashMap.EMPTY;
var state_34846__$1 = state_34846;
var statearr_34894_35083 = state_34846__$1;
(statearr_34894_35083[(2)] = inst_34683);

(statearr_34894_35083[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (99))){
var inst_34746 = (state_34846[(10)]);
var state_34846__$1 = state_34846;
var statearr_34895_35084 = state_34846__$1;
(statearr_34895_35084[(2)] = inst_34746);

(statearr_34895_35084[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (21))){
var inst_34538 = (state_34846[(18)]);
var inst_34555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34556 = cljs.core.second(inst_34538);
var inst_34557 = cljs.core.first(inst_34538);
var inst_34558 = [inst_34556,inst_34557];
var inst_34559 = (new cljs.core.PersistentVector(null,2,(5),inst_34555,inst_34558,null));
var state_34846__$1 = state_34846;
var statearr_34896_35085 = state_34846__$1;
(statearr_34896_35085[(2)] = inst_34559);

(statearr_34896_35085[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (31))){
var inst_34610 = (state_34846[(27)]);
var inst_34610__$1 = typeof from === 'string';
var state_34846__$1 = (function (){var statearr_34897 = state_34846;
(statearr_34897[(27)] = inst_34610__$1);

return statearr_34897;
})();
if(cljs.core.truth_(inst_34610__$1)){
var statearr_34898_35086 = state_34846__$1;
(statearr_34898_35086[(1)] = (44));

} else {
var statearr_34899_35087 = state_34846__$1;
(statearr_34899_35087[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (113))){
var state_34846__$1 = state_34846;
var statearr_34900_35088 = state_34846__$1;
(statearr_34900_35088[(2)] = null);

(statearr_34900_35088[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (32))){
var inst_34584 = (state_34846[(16)]);
var inst_34819 = (state_34846[(2)]);
var state_34846__$1 = (function (){var statearr_34901 = state_34846;
(statearr_34901[(28)] = inst_34819);

return statearr_34901;
})();
if(cljs.core.truth_(inst_34584)){
var statearr_34902_35089 = state_34846__$1;
(statearr_34902_35089[(1)] = (122));

} else {
var statearr_34903_35090 = state_34846__$1;
(statearr_34903_35090[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (40))){
var inst_34538 = (state_34846[(18)]);
var inst_34600 = (state_34846[(2)]);
var state_34846__$1 = (function (){var statearr_34904 = state_34846;
(statearr_34904[(29)] = inst_34600);

return statearr_34904;
})();
if(cljs.core.truth_(inst_34538)){
var statearr_34905_35091 = state_34846__$1;
(statearr_34905_35091[(1)] = (41));

} else {
var statearr_34906_35092 = state_34846__$1;
(statearr_34906_35092[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (129))){
var inst_34827 = (state_34846[(30)]);
var state_34846__$1 = state_34846;
var statearr_34907_35093 = state_34846__$1;
(statearr_34907_35093[(2)] = inst_34827);

(statearr_34907_35093[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (91))){
var inst_34728 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_34846__$1 = state_34846;
var statearr_34908_35094 = state_34846__$1;
(statearr_34908_35094[(2)] = inst_34728);

(statearr_34908_35094[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (117))){
var inst_34541 = (state_34846[(15)]);
var state_34846__$1 = state_34846;
var statearr_34909_35095 = state_34846__$1;
(statearr_34909_35095[(2)] = inst_34541);

(statearr_34909_35095[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (108))){
var inst_34769 = (state_34846[(2)]);
var inst_34770 = fluree.db.util.async.throw_err(inst_34769);
var state_34846__$1 = state_34846;
var statearr_34910_35096 = state_34846__$1;
(statearr_34910_35096[(2)] = inst_34770);

(statearr_34910_35096[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (56))){
var inst_34633 = cljs.core.PersistentHashMap.EMPTY;
var state_34846__$1 = state_34846;
var statearr_34911_35097 = state_34846__$1;
(statearr_34911_35097[(2)] = inst_34633);

(statearr_34911_35097[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (33))){
var state_34846__$1 = state_34846;
var statearr_34912_35098 = state_34846__$1;
(statearr_34912_35098[(2)] = from);

(statearr_34912_35098[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (13))){
var inst_34525 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34526 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34527 = cljs.core.PersistentHashMap.fromArrays(inst_34525,inst_34526);
var inst_34528 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_34527);
var inst_34529 = (function(){throw inst_34528})();
var state_34846__$1 = state_34846;
var statearr_34913_35099 = state_34846__$1;
(statearr_34913_35099[(2)] = inst_34529);

(statearr_34913_35099[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (22))){
var inst_34538 = (state_34846[(18)]);
var inst_34561 = typeof inst_34538 === 'string';
var state_34846__$1 = state_34846;
if(cljs.core.truth_(inst_34561)){
var statearr_34914_35100 = state_34846__$1;
(statearr_34914_35100[(1)] = (24));

} else {
var statearr_34915_35101 = state_34846__$1;
(statearr_34915_35101[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (90))){
var inst_34717 = (state_34846[(31)]);
var inst_34724 = (state_34846[(2)]);
var state_34846__$1 = (function (){var statearr_34916 = state_34846;
(statearr_34916[(32)] = inst_34724);

return statearr_34916;
})();
var statearr_34917_35102 = state_34846__$1;
(statearr_34917_35102[(2)] = inst_34717);

(statearr_34917_35102[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (109))){
var inst_34772 = (state_34846[(23)]);
var inst_34746 = (state_34846[(10)]);
var inst_34774 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34746,inst_34772);
var state_34846__$1 = state_34846;
var statearr_34918_35103 = state_34846__$1;
(statearr_34918_35103[(2)] = inst_34774);

(statearr_34918_35103[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (36))){
var inst_34538 = (state_34846[(18)]);
var inst_34595 = (state_34846[(2)]);
var inst_34596 = fluree.db.util.async.throw_err(inst_34595);
var state_34846__$1 = (function (){var statearr_34919 = state_34846;
(statearr_34919[(33)] = inst_34596);

return statearr_34919;
})();
if(cljs.core.truth_(inst_34538)){
var statearr_34920_35104 = state_34846__$1;
(statearr_34920_35104[(1)] = (38));

} else {
var statearr_34921_35105 = state_34846__$1;
(statearr_34921_35105[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (41))){
var state_34846__$1 = state_34846;
var statearr_34922_35106 = state_34846__$1;
(statearr_34922_35106[(2)] = null);

(statearr_34922_35106[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (118))){
var inst_34784 = (state_34846[(34)]);
var inst_34551 = (state_34846[(7)]);
var inst_34788 = (state_34846[(35)]);
var inst_34549 = (state_34846[(8)]);
var inst_34792 = (state_34846[(2)]);
var inst_34793 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_34551,fuel,max_fuel,inst_34549,inst_34784,inst_34788,inst_34792);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(112),inst_34793);
} else {
if((state_val_34847 === (89))){
var state_34846__$1 = state_34846;
var statearr_34923_35107 = state_34846__$1;
(statearr_34923_35107[(2)] = null);

(statearr_34923_35107[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (100))){
var inst_34752 = (state_34846[(19)]);
var inst_34757 = cljs.core.int_QMARK_(inst_34752);
var state_34846__$1 = state_34846;
if(inst_34757){
var statearr_34924_35108 = state_34846__$1;
(statearr_34924_35108[(1)] = (102));

} else {
var statearr_34925_35109 = state_34846__$1;
(statearr_34925_35109[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (131))){
var inst_34824 = (state_34846[(11)]);
var inst_34838 = cljs.core.first(inst_34824);
var state_34846__$1 = state_34846;
var statearr_34926_35110 = state_34846__$1;
(statearr_34926_35110[(2)] = inst_34838);

(statearr_34926_35110[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (122))){
var inst_34584 = (state_34846[(16)]);
var inst_34819 = (state_34846[(28)]);
var inst_34585 = (state_34846[(17)]);
var inst_34541 = (state_34846[(15)]);
var inst_34539 = (state_34846[(14)]);
var inst_34821 = fluree.db.query.fql.sort_offset_and_limit_res(inst_34584,inst_34585,inst_34541,inst_34539,inst_34819);
var state_34846__$1 = state_34846;
var statearr_34927_35111 = state_34846__$1;
(statearr_34927_35111[(2)] = inst_34821);

(statearr_34927_35111[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (43))){
var inst_34596 = (state_34846[(33)]);
var inst_34551 = (state_34846[(7)]);
var inst_34600 = (state_34846[(29)]);
var inst_34549 = (state_34846[(8)]);
var inst_34604 = (state_34846[(2)]);
var inst_34605 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_34551,fuel,max_fuel,inst_34549,inst_34596,inst_34600,inst_34604);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(37),inst_34605);
} else {
if((state_val_34847 === (61))){
var inst_34655 = ["_tx",null,"_block",null];
var inst_34656 = (new cljs.core.PersistentArrayMap(null,2,inst_34655,null));
var inst_34657 = (new cljs.core.PersistentHashSet(null,inst_34656,null));
var inst_34658 = (inst_34657.cljs$core$IFn$_invoke$arity$1 ? inst_34657.cljs$core$IFn$_invoke$arity$1(from) : inst_34657.call(null,from));
var state_34846__$1 = state_34846;
var statearr_34928_35112 = state_34846__$1;
(statearr_34928_35112[(2)] = inst_34658);

(statearr_34928_35112[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (29))){
var inst_34573 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34929_35113 = state_34846__$1;
(statearr_34929_35113[(2)] = inst_34573);

(statearr_34929_35113[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (44))){
var inst_34612 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_34613 = clojure.string.includes_QMARK_(inst_34612,"/");
var state_34846__$1 = state_34846;
var statearr_34930_35114 = state_34846__$1;
(statearr_34930_35114[(2)] = inst_34613);

(statearr_34930_35114[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (93))){
var inst_34731 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
if(cljs.core.truth_(inst_34731)){
var statearr_34931_35115 = state_34846__$1;
(statearr_34931_35115[(1)] = (94));

} else {
var statearr_34932_35116 = state_34846__$1;
(statearr_34932_35116[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (6))){
var inst_34516 = (state_34846[(36)]);
var state_34846__$1 = state_34846;
var statearr_34933_35117 = state_34846__$1;
(statearr_34933_35117[(2)] = inst_34516);

(statearr_34933_35117[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (111))){
var inst_34753 = (state_34846[(37)]);
var inst_34777 = (state_34846[(2)]);
var inst_34745 = inst_34753;
var inst_34746 = inst_34777;
var state_34846__$1 = (function (){var statearr_34934 = state_34846;
(statearr_34934[(10)] = inst_34746);

(statearr_34934[(38)] = inst_34745);

return statearr_34934;
})();
var statearr_34935_35118 = state_34846__$1;
(statearr_34935_35118[(2)] = null);

(statearr_34935_35118[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (28))){
var state_34846__$1 = state_34846;
var statearr_34936_35119 = state_34846__$1;
(statearr_34936_35119[(2)] = null);

(statearr_34936_35119[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (64))){
var inst_34538 = (state_34846[(18)]);
var state_34846__$1 = state_34846;
if(cljs.core.truth_(inst_34538)){
var statearr_34937_35120 = state_34846__$1;
(statearr_34937_35120[(1)] = (67));

} else {
var statearr_34938_35121 = state_34846__$1;
(statearr_34938_35121[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (103))){
var state_34846__$1 = state_34846;
if(cljs.core.truth_(fuel)){
var statearr_34939_35122 = state_34846__$1;
(statearr_34939_35122[(1)] = (105));

} else {
var statearr_34940_35123 = state_34846__$1;
(statearr_34940_35123[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (51))){
var inst_34619 = (state_34846[(26)]);
var state_34846__$1 = state_34846;
var statearr_34941_35124 = state_34846__$1;
(statearr_34941_35124[(2)] = inst_34619);

(statearr_34941_35124[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (25))){
var state_34846__$1 = state_34846;
var statearr_34942_35125 = state_34846__$1;
(statearr_34942_35125[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (34))){
var state_34846__$1 = state_34846;
var statearr_34944_35126 = state_34846__$1;
(statearr_34944_35126[(2)] = null);

(statearr_34944_35126[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (125))){
var inst_34824 = (state_34846[(11)]);
var inst_34827 = (state_34846[(30)]);
var inst_34827__$1 = cljs.core.coll_QMARK_(inst_34824);
var state_34846__$1 = (function (){var statearr_34945 = state_34846;
(statearr_34945[(30)] = inst_34827__$1);

return statearr_34945;
})();
if(inst_34827__$1){
var statearr_34946_35127 = state_34846__$1;
(statearr_34946_35127[(1)] = (128));

} else {
var statearr_34947_35128 = state_34846__$1;
(statearr_34947_35128[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (17))){
var inst_34538 = (state_34846[(18)]);
var inst_34549 = (state_34846[(2)]);
var inst_34550 = cljs.core.PersistentHashMap.EMPTY;
var inst_34551 = cljs.core.volatile_BANG_(inst_34550);
var state_34846__$1 = (function (){var statearr_34948 = state_34846;
(statearr_34948[(7)] = inst_34551);

(statearr_34948[(8)] = inst_34549);

return statearr_34948;
})();
if(cljs.core.truth_(inst_34538)){
var statearr_34949_35129 = state_34846__$1;
(statearr_34949_35129[(1)] = (18));

} else {
var statearr_34950_35130 = state_34846__$1;
(statearr_34950_35130[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (3))){
var inst_34844 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34846__$1,inst_34844);
} else {
if((state_val_34847 === (12))){
var inst_34522 = (state_34846[(39)]);
var state_34846__$1 = state_34846;
var statearr_34951_35131 = state_34846__$1;
(statearr_34951_35131[(2)] = inst_34522);

(statearr_34951_35131[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (2))){
var inst_34516 = (state_34846[(36)]);
var _ = (function (){var statearr_34952 = state_34846;
(statearr_34952[(4)] = cljs.core.cons((5),(state_34846[(4)])));

return statearr_34952;
})();
var inst_34516__$1 = select;
var state_34846__$1 = (function (){var statearr_34953 = state_34846;
(statearr_34953[(36)] = inst_34516__$1);

return statearr_34953;
})();
if(cljs.core.truth_(inst_34516__$1)){
var statearr_34954_35132 = state_34846__$1;
(statearr_34954_35132[(1)] = (6));

} else {
var statearr_34955_35133 = state_34846__$1;
(statearr_34955_35133[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (66))){
var inst_34815 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34956_35134 = state_34846__$1;
(statearr_34956_35134[(2)] = inst_34815);

(statearr_34956_35134[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (107))){
var inst_34752 = (state_34846[(19)]);
var inst_34766 = (state_34846[(2)]);
var inst_34767 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_34752,false);
var state_34846__$1 = (function (){var statearr_34957 = state_34846;
(statearr_34957[(40)] = inst_34766);

return statearr_34957;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(108),inst_34767);
} else {
if((state_val_34847 === (23))){
var inst_34577 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34958_35135 = state_34846__$1;
(statearr_34958_35135[(2)] = inst_34577);

(statearr_34958_35135[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (47))){
var inst_34619 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_34846__$1 = (function (){var statearr_34959 = state_34846;
(statearr_34959[(26)] = inst_34619);

return statearr_34959;
})();
if(cljs.core.truth_(fuel)){
var statearr_34960_35136 = state_34846__$1;
(statearr_34960_35136[(1)] = (50));

} else {
var statearr_34961_35137 = state_34846__$1;
(statearr_34961_35137[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (35))){
var inst_34592 = (state_34846[(2)]);
var inst_34593 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_34592);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(36),inst_34593);
} else {
if((state_val_34847 === (127))){
var inst_34836 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
if(cljs.core.truth_(inst_34836)){
var statearr_34962_35138 = state_34846__$1;
(statearr_34962_35138[(1)] = (131));

} else {
var statearr_34963_35139 = state_34846__$1;
(statearr_34963_35139[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (82))){
var inst_34811 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34964_35140 = state_34846__$1;
(statearr_34964_35140[(2)] = inst_34811);

(statearr_34964_35140[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (76))){
var inst_34541 = (state_34846[(15)]);
var inst_34539 = (state_34846[(14)]);
var inst_34685 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_34686 = [inst_34539,inst_34541];
var inst_34687 = cljs.core.PersistentHashMap.fromArrays(inst_34685,inst_34686);
var state_34846__$1 = state_34846;
var statearr_34965_35141 = state_34846__$1;
(statearr_34965_35141[(2)] = inst_34687);

(statearr_34965_35141[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (97))){
var inst_34752 = (state_34846[(19)]);
var inst_34745 = (state_34846[(38)]);
var inst_34751 = cljs.core.seq(inst_34745);
var inst_34752__$1 = cljs.core.first(inst_34751);
var inst_34753 = cljs.core.next(inst_34751);
var inst_34754 = cljs.core.not(inst_34752__$1);
var state_34846__$1 = (function (){var statearr_34966 = state_34846;
(statearr_34966[(37)] = inst_34753);

(statearr_34966[(19)] = inst_34752__$1);

return statearr_34966;
})();
if(inst_34754){
var statearr_34967_35142 = state_34846__$1;
(statearr_34967_35142[(1)] = (99));

} else {
var statearr_34968_35143 = state_34846__$1;
(statearr_34968_35143[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (19))){
var inst_34579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34580 = [null,null];
var inst_34581 = (new cljs.core.PersistentVector(null,2,(5),inst_34579,inst_34580,null));
var state_34846__$1 = state_34846;
var statearr_34969_35144 = state_34846__$1;
(statearr_34969_35144[(2)] = inst_34581);

(statearr_34969_35144[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (57))){
var inst_34541 = (state_34846[(15)]);
var inst_34539 = (state_34846[(14)]);
var inst_34635 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_34636 = [inst_34539,inst_34541];
var inst_34637 = cljs.core.PersistentHashMap.fromArrays(inst_34635,inst_34636);
var state_34846__$1 = state_34846;
var statearr_34970_35145 = state_34846__$1;
(statearr_34970_35145[(2)] = inst_34637);

(statearr_34970_35145[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (68))){
var inst_34541 = (state_34846[(15)]);
var inst_34539 = (state_34846[(14)]);
var inst_34666 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_34667 = [inst_34539,inst_34541];
var inst_34668 = cljs.core.PersistentHashMap.fromArrays(inst_34666,inst_34667);
var state_34846__$1 = state_34846;
var statearr_34971_35146 = state_34846__$1;
(statearr_34971_35146[(2)] = inst_34668);

(statearr_34971_35146[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (11))){
var inst_34533 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34972_35147 = state_34846__$1;
(statearr_34972_35147[(2)] = inst_34533);

(statearr_34972_35147[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (115))){
var inst_34538 = (state_34846[(18)]);
var inst_34788 = (state_34846[(2)]);
var state_34846__$1 = (function (){var statearr_34974 = state_34846;
(statearr_34974[(35)] = inst_34788);

return statearr_34974;
})();
if(cljs.core.truth_(inst_34538)){
var statearr_34975_35148 = state_34846__$1;
(statearr_34975_35148[(1)] = (116));

} else {
var statearr_34976_35149 = state_34846__$1;
(statearr_34976_35149[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (9))){
var inst_34519 = (state_34846[(12)]);
var state_34846__$1 = state_34846;
var statearr_34977_35150 = state_34846__$1;
(statearr_34977_35150[(2)] = inst_34519);

(statearr_34977_35150[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (5))){
var _ = (function (){var statearr_34978 = state_34846;
(statearr_34978[(4)] = cljs.core.rest((state_34846[(4)])));

return statearr_34978;
})();
var state_34846__$1 = state_34846;
var ex34973 = (state_34846__$1[(2)]);
var statearr_34979_35151 = state_34846__$1;
(statearr_34979_35151[(5)] = ex34973);


if((ex34973 instanceof Error)){
var statearr_34980_35152 = state_34846__$1;
(statearr_34980_35152[(1)] = (4));

(statearr_34980_35152[(5)] = null);

} else {
throw ex34973;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (112))){
var inst_34795 = (state_34846[(2)]);
var inst_34796 = fluree.db.util.async.throw_err(inst_34795);
var state_34846__$1 = state_34846;
var statearr_34981_35153 = state_34846__$1;
(statearr_34981_35153[(2)] = inst_34796);

(statearr_34981_35153[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (83))){
var inst_34705 = (state_34846[(20)]);
var inst_34704 = (state_34846[(2)]);
var inst_34705__$1 = fluree.db.util.async.throw_err(inst_34704);
var inst_34706 = (inst_34705__$1 == null);
var state_34846__$1 = (function (){var statearr_34982 = state_34846;
(statearr_34982[(20)] = inst_34705__$1);

return statearr_34982;
})();
if(cljs.core.truth_(inst_34706)){
var statearr_34983_35154 = state_34846__$1;
(statearr_34983_35154[(1)] = (84));

} else {
var statearr_34984_35155 = state_34846__$1;
(statearr_34984_35155[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (14))){
var inst_34531 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34985_35156 = state_34846__$1;
(statearr_34985_35156[(2)] = inst_34531);

(statearr_34985_35156[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (45))){
var inst_34610 = (state_34846[(27)]);
var state_34846__$1 = state_34846;
var statearr_34986_35157 = state_34846__$1;
(statearr_34986_35157[(2)] = inst_34610);

(statearr_34986_35157[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (53))){
var inst_34625 = (state_34846[(21)]);
var inst_34627 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_34628 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34625,inst_34627);
var state_34846__$1 = state_34846;
var statearr_34987_35158 = state_34846__$1;
(statearr_34987_35158[(2)] = inst_34628);

(statearr_34987_35158[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (78))){
var inst_34551 = (state_34846[(7)]);
var inst_34549 = (state_34846[(8)]);
var inst_34692 = (state_34846[(2)]);
var inst_34693 = fluree.db.util.async.throw_err(inst_34692);
var inst_34694 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_34551,fuel,max_fuel,inst_34549,inst_34693);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(79),inst_34694);
} else {
if((state_val_34847 === (132))){
var inst_34824 = (state_34846[(11)]);
var state_34846__$1 = state_34846;
var statearr_34988_35159 = state_34846__$1;
(statearr_34988_35159[(2)] = inst_34824);

(statearr_34988_35159[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (26))){
var inst_34575 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_34989_35160 = state_34846__$1;
(statearr_34989_35160[(2)] = inst_34575);

(statearr_34989_35160[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (123))){
var inst_34819 = (state_34846[(28)]);
var state_34846__$1 = state_34846;
var statearr_34990_35161 = state_34846__$1;
(statearr_34990_35161[(2)] = inst_34819);

(statearr_34990_35161[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (16))){
var inst_34542 = (state_34846[(24)]);
var state_34846__$1 = state_34846;
var statearr_34991_35162 = state_34846__$1;
(statearr_34991_35162[(2)] = inst_34542);

(statearr_34991_35162[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (133))){
var inst_34841 = (state_34846[(2)]);
var _ = (function (){var statearr_34992 = state_34846;
(statearr_34992[(4)] = cljs.core.rest((state_34846[(4)])));

return statearr_34992;
})();
var state_34846__$1 = state_34846;
var statearr_34993_35163 = state_34846__$1;
(statearr_34993_35163[(2)] = inst_34841);

(statearr_34993_35163[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (81))){
var inst_34726 = (state_34846[(22)]);
var inst_34726__$1 = cljs.core.sequential_QMARK_(from);
var state_34846__$1 = (function (){var statearr_34994 = state_34846;
(statearr_34994[(22)] = inst_34726__$1);

return statearr_34994;
})();
if(inst_34726__$1){
var statearr_34995_35164 = state_34846__$1;
(statearr_34995_35164[(1)] = (91));

} else {
var statearr_34996_35165 = state_34846__$1;
(statearr_34996_35165[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (120))){
var state_34846__$1 = state_34846;
var statearr_34997_35166 = state_34846__$1;
(statearr_34997_35166[(2)] = null);

(statearr_34997_35166[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (79))){
var inst_34696 = (state_34846[(2)]);
var inst_34697 = fluree.db.util.async.throw_err(inst_34696);
var state_34846__$1 = state_34846;
var statearr_34998_35167 = state_34846__$1;
(statearr_34998_35167[(2)] = inst_34697);

(statearr_34998_35167[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (38))){
var state_34846__$1 = state_34846;
var statearr_34999_35168 = state_34846__$1;
(statearr_34999_35168[(2)] = null);

(statearr_34999_35168[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (126))){
var inst_34825 = (state_34846[(41)]);
var state_34846__$1 = state_34846;
var statearr_35000_35169 = state_34846__$1;
(statearr_35000_35169[(2)] = inst_34825);

(statearr_35000_35169[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (98))){
var inst_34538 = (state_34846[(18)]);
var inst_34782 = (state_34846[(2)]);
var inst_34783 = cljs.core.PersistentVector.EMPTY;
var inst_34784 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34783,inst_34782);
var state_34846__$1 = (function (){var statearr_35001 = state_34846;
(statearr_35001[(34)] = inst_34784);

return statearr_35001;
})();
if(cljs.core.truth_(inst_34538)){
var statearr_35002_35170 = state_34846__$1;
(statearr_35002_35170[(1)] = (113));

} else {
var statearr_35003_35171 = state_34846__$1;
(statearr_35003_35171[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (124))){
var inst_34825 = (state_34846[(41)]);
var inst_34824 = (state_34846[(2)]);
var inst_34825__$1 = selectOne;
var state_34846__$1 = (function (){var statearr_35004 = state_34846;
(statearr_35004[(11)] = inst_34824);

(statearr_35004[(41)] = inst_34825__$1);

return statearr_35004;
})();
if(cljs.core.truth_(inst_34825__$1)){
var statearr_35005_35172 = state_34846__$1;
(statearr_35005_35172[(1)] = (125));

} else {
var statearr_35006_35173 = state_34846__$1;
(statearr_35006_35173[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (87))){
var inst_34716 = (state_34846[(2)]);
var inst_34717 = fluree.db.util.async.throw_err(inst_34716);
var state_34846__$1 = (function (){var statearr_35007 = state_34846;
(statearr_35007[(31)] = inst_34717);

return statearr_35007;
})();
if(cljs.core.truth_(fuel)){
var statearr_35008_35174 = state_34846__$1;
(statearr_35008_35174[(1)] = (88));

} else {
var statearr_35009_35175 = state_34846__$1;
(statearr_35009_35175[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (30))){
var inst_34588 = typeof from === 'string';
var state_34846__$1 = state_34846;
if(cljs.core.truth_(inst_34588)){
var statearr_35010_35176 = state_34846__$1;
(statearr_35010_35176[(1)] = (33));

} else {
var statearr_35011_35177 = state_34846__$1;
(statearr_35011_35177[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (73))){
var inst_34699 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_34846__$1 = state_34846;
if(inst_34699){
var statearr_35012_35178 = state_34846__$1;
(statearr_35012_35178[(1)] = (80));

} else {
var statearr_35013_35179 = state_34846__$1;
(statearr_35013_35179[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (96))){
var inst_34809 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_35014_35180 = state_34846__$1;
(statearr_35014_35180[(2)] = inst_34809);

(statearr_35014_35180[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (10))){
var inst_34522 = (state_34846[(39)]);
var inst_34522__$1 = selectDistinct;
var state_34846__$1 = (function (){var statearr_35015 = state_34846;
(statearr_35015[(39)] = inst_34522__$1);

return statearr_35015;
})();
if(cljs.core.truth_(inst_34522__$1)){
var statearr_35016_35181 = state_34846__$1;
(statearr_35016_35181[(1)] = (12));

} else {
var statearr_35017_35182 = state_34846__$1;
(statearr_35017_35182[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (18))){
var inst_34538 = (state_34846[(18)]);
var inst_34553 = cljs.core.vector_QMARK_(inst_34538);
var state_34846__$1 = state_34846;
if(inst_34553){
var statearr_35018_35183 = state_34846__$1;
(statearr_35018_35183[(1)] = (21));

} else {
var statearr_35019_35184 = state_34846__$1;
(statearr_35019_35184[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (105))){
var inst_34761 = cljs.core._deref(fuel);
var inst_34762 = (inst_34761 + (1));
var inst_34763 = cljs.core._vreset_BANG_(fuel,inst_34762);
var state_34846__$1 = state_34846;
var statearr_35020_35185 = state_34846__$1;
(statearr_35020_35185[(2)] = inst_34763);

(statearr_35020_35185[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (52))){
var inst_34625 = (state_34846[(2)]);
var state_34846__$1 = (function (){var statearr_35021 = state_34846;
(statearr_35021[(21)] = inst_34625);

return statearr_35021;
})();
var statearr_35022_35186 = state_34846__$1;
(statearr_35022_35186[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (114))){
var inst_34539 = (state_34846[(14)]);
var state_34846__$1 = state_34846;
var statearr_35024_35187 = state_34846__$1;
(statearr_35024_35187[(2)] = inst_34539);

(statearr_35024_35187[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (67))){
var inst_34664 = cljs.core.PersistentHashMap.EMPTY;
var state_34846__$1 = state_34846;
var statearr_35025_35188 = state_34846__$1;
(statearr_35025_35188[(2)] = inst_34664);

(statearr_35025_35188[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (71))){
var inst_34677 = (state_34846[(2)]);
var inst_34678 = fluree.db.util.async.throw_err(inst_34677);
var state_34846__$1 = state_34846;
var statearr_35026_35189 = state_34846__$1;
(statearr_35026_35189[(2)] = inst_34678);

(statearr_35026_35189[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (42))){
var inst_34541 = (state_34846[(15)]);
var state_34846__$1 = state_34846;
var statearr_35027_35190 = state_34846__$1;
(statearr_35027_35190[(2)] = inst_34541);

(statearr_35027_35190[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (80))){
var inst_34702 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_34846__$1 = state_34846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34846__$1,(83),inst_34702);
} else {
if((state_val_34847 === (37))){
var inst_34607 = (state_34846[(2)]);
var inst_34608 = fluree.db.util.async.throw_err(inst_34607);
var state_34846__$1 = state_34846;
var statearr_35028_35191 = state_34846__$1;
(statearr_35028_35191[(2)] = inst_34608);

(statearr_35028_35191[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (63))){
var inst_34661 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
if(cljs.core.truth_(inst_34661)){
var statearr_35029_35192 = state_34846__$1;
(statearr_35029_35192[(1)] = (64));

} else {
var statearr_35030_35193 = state_34846__$1;
(statearr_35030_35193[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (94))){
var inst_34740 = from;
var inst_34741 = cljs.core.seq(inst_34740);
var inst_34742 = cljs.core.first(inst_34741);
var inst_34743 = cljs.core.next(inst_34741);
var inst_34744 = cljs.core.PersistentVector.EMPTY;
var inst_34745 = inst_34740;
var inst_34746 = inst_34744;
var state_34846__$1 = (function (){var statearr_35031 = state_34846;
(statearr_35031[(42)] = inst_34742);

(statearr_35031[(43)] = inst_34743);

(statearr_35031[(10)] = inst_34746);

(statearr_35031[(38)] = inst_34745);

return statearr_35031;
})();
var statearr_35032_35194 = state_34846__$1;
(statearr_35032_35194[(2)] = null);

(statearr_35032_35194[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (8))){
var inst_34540 = (state_34846[(25)]);
var inst_34535 = (state_34846[(2)]);
var inst_34536 = opts_SINGLEQUOTE_;
var inst_34537 = cljs.core.__destructure_map(inst_34536);
var inst_34538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34537,cljs.core.cst$kw$orderBy);
var inst_34539 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34537,cljs.core.cst$kw$limit);
var inst_34540__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34537,cljs.core.cst$kw$component);
var inst_34541 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34537,cljs.core.cst$kw$offset);
var inst_34542 = fluree.db.query.fql_parser.parse_db(db,inst_34535,opts_SINGLEQUOTE_);
var inst_34543 = (inst_34540__$1 == null);
var inst_34544 = cljs.core.not(inst_34543);
var state_34846__$1 = (function (){var statearr_35033 = state_34846;
(statearr_35033[(24)] = inst_34542);

(statearr_35033[(25)] = inst_34540__$1);

(statearr_35033[(18)] = inst_34538);

(statearr_35033[(15)] = inst_34541);

(statearr_35033[(14)] = inst_34539);

return statearr_35033;
})();
if(inst_34544){
var statearr_35034_35195 = state_34846__$1;
(statearr_35034_35195[(1)] = (15));

} else {
var statearr_35035_35196 = state_34846__$1;
(statearr_35035_35196[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (49))){
var inst_34817 = (state_34846[(2)]);
var state_34846__$1 = state_34846;
var statearr_35036_35197 = state_34846__$1;
(statearr_35036_35197[(2)] = inst_34817);

(statearr_35036_35197[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34847 === (84))){
var state_34846__$1 = state_34846;
var statearr_35037_35198 = state_34846__$1;
(statearr_35037_35198[(2)] = null);

(statearr_35037_35198[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__10798__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__10798__auto____0 = (function (){
var statearr_35038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35038[(0)] = fluree$db$query$fql$query_$_state_machine__10798__auto__);

(statearr_35038[(1)] = (1));

return statearr_35038;
});
var fluree$db$query$fql$query_$_state_machine__10798__auto____1 = (function (state_34846){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_34846);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e35039){var ex__10801__auto__ = e35039;
var statearr_35040_35199 = state_34846;
(statearr_35040_35199[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_34846[(4)]))){
var statearr_35041_35200 = state_34846;
(statearr_35041_35200[(1)] = cljs.core.first((state_34846[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__35201 = state_34846;
state_34846 = G__35201;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__10798__auto__ = function(state_34846){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__10798__auto____1.call(this,state_34846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__10798__auto____0;
fluree$db$query$fql$query_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__10798__auto____1;
return fluree$db$query$fql$query_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_35042 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_35042[(6)] = c__10835__auto__);

return statearr_35042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}

});
