// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34500_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34500_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__34504 = coll;
var vec__34505 = G__34504;
var seq__34506 = cljs.core.seq(vec__34505);
var first__34507 = cljs.core.first(seq__34506);
var seq__34506__$1 = cljs.core.next(seq__34506);
var clause = first__34507;
var r = seq__34506__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__34504__$1 = G__34504;
var res__$1 = res;
while(true){
var vec__34511 = G__34504__$1;
var seq__34512 = cljs.core.seq(vec__34511);
var first__34513 = cljs.core.first(seq__34512);
var seq__34512__$1 = cljs.core.next(seq__34512);
var clause__$1 = first__34513;
var r__$1 = seq__34512__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__34514 = r__$1;
var G__34515 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__34504__$1 = G__34514;
res__$1 = G__34515;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__34516){
var map__34517 = p__34516;
var map__34517__$1 = cljs.core.__destructure_map(map__34517);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34517__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__34521 = coll;
var vec__34522 = G__34521;
var seq__34523 = cljs.core.seq(vec__34522);
var first__34524 = cljs.core.first(seq__34523);
var seq__34523__$1 = cljs.core.next(seq__34523);
var clause = first__34524;
var r = seq__34523__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__34521__$1 = G__34521;
var res__$1 = res;
while(true){
var vec__34528 = G__34521__$1;
var seq__34529 = cljs.core.seq(vec__34528);
var first__34530 = cljs.core.first(seq__34529);
var seq__34529__$1 = cljs.core.next(seq__34529);
var clause__$1 = first__34530;
var r__$1 = seq__34529__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__34531 = r__$1;
var G__34532 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__34521__$1 = G__34531;
res__$1 = G__34532;
continue;
} else {
var G__34533 = r__$1;
var G__34534 = res__$2;
G__34521__$1 = G__34533;
res__$1 = G__34534;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__34538 = coll;
var vec__34539 = G__34538;
var seq__34540 = cljs.core.seq(vec__34539);
var first__34541 = cljs.core.first(seq__34540);
var seq__34540__$1 = cljs.core.next(seq__34540);
var clause = first__34541;
var r = seq__34540__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__34538__$1 = G__34538;
var res__$1 = res;
while(true){
var vec__34545 = G__34538__$1;
var seq__34546 = cljs.core.seq(vec__34545);
var first__34547 = cljs.core.first(seq__34546);
var seq__34546__$1 = cljs.core.next(seq__34546);
var clause__$1 = first__34547;
var r__$1 = seq__34546__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__34548 = r__$1;
var G__34549 = res__$2;
G__34538__$1 = G__34548;
res__$1 = G__34549;
continue;
} else {
var G__34550 = r__$1;
var G__34551 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__34538__$1 = G__34550;
res__$1 = G__34551;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4221__auto__ = typeof string === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4221__auto__;
}
})())){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__34552 = clause;
var G__34552__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__34552):G__34552);
var G__34552__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__34552__$1)
;
var G__34552__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__34552__$2)
;
var G__34552__$4 = goog.string.format("%s .",G__34552__$3)
;
if(cljs.core.truth_(optional_QMARK_)){
return goog.string.format("OPTIONAL {%s}",G__34552__$4);
} else {
return G__34552__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__34556 = opts;
var map__34556__$1 = cljs.core.__destructure_map(map__34556);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34556__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34556__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34556__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34556__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34556__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34553_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34553_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__34554_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__34554_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__34555_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__34555_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4223__auto__ = language;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__15891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15892__auto__ = (function (){var switch__15853__auto__ = (function (state_34570){
var state_val_34571 = (state_34570[(1)]);
if((state_val_34571 === (1))){
var inst_34557 = fluree.db.util.core.url_encode(query);
var inst_34558 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34557)].join('');
var inst_34559 = ["User-Agent","Accept"];
var inst_34560 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_34561 = cljs.core.PersistentHashMap.fromArrays(inst_34559,inst_34560);
var inst_34562 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_34563 = [inst_34561,(30000),cljs.core.cst$kw$wikidata];
var inst_34564 = cljs.core.PersistentHashMap.fromArrays(inst_34562,inst_34563);
var inst_34565 = fluree.db.util.xhttp.get(inst_34558,inst_34564);
var state_34570__$1 = state_34570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34570__$1,(2),inst_34565);
} else {
if((state_val_34571 === (2))){
var inst_34567 = (state_34570[(2)]);
var inst_34568 = fluree.db.util.async.throw_err(inst_34567);
var state_34570__$1 = state_34570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34570__$1,inst_34568);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto____0 = (function (){
var statearr_34572 = [null,null,null,null,null,null,null];
(statearr_34572[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto__);

(statearr_34572[(1)] = (1));

return statearr_34572;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto____1 = (function (state_34570){
while(true){
var ret_value__15855__auto__ = (function (){try{while(true){
var result__15856__auto__ = switch__15853__auto__(state_34570);
if(cljs.core.keyword_identical_QMARK_(result__15856__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15856__auto__;
}
break;
}
}catch (e34573){var ex__15857__auto__ = e34573;
var statearr_34574_34577 = state_34570;
(statearr_34574_34577[(2)] = ex__15857__auto__);


if(cljs.core.seq((state_34570[(4)]))){
var statearr_34575_34578 = state_34570;
(statearr_34575_34578[(1)] = cljs.core.first((state_34570[(4)])));

} else {
throw ex__15857__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15855__auto__,cljs.core.cst$kw$recur)){
var G__34579 = state_34570;
state_34570 = G__34579;
continue;
} else {
return ret_value__15855__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto__ = function(state_34570){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto____1.call(this,state_34570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15854__auto__;
})()
})();
var state__15893__auto__ = (function (){var statearr_34576 = (f__15892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15892__auto__.cljs$core$IFn$_invoke$arity$0() : f__15892__auto__.call(null));
(statearr_34576[(6)] = c__15891__auto__);

return statearr_34576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15893__auto__);
}));

return c__15891__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__15891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15892__auto__ = (function (){var switch__15853__auto__ = (function (state_34597){
var state_val_34598 = (state_34597[(1)]);
if((state_val_34598 === (1))){
var inst_34580 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_34597__$1 = state_34597;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34597__$1,(2),inst_34580);
} else {
if((state_val_34598 === (2))){
var inst_34583 = (state_34597[(7)]);
var inst_34582 = (state_34597[(2)]);
var inst_34583__$1 = fluree.db.util.async.throw_err(inst_34582);
var inst_34584 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_34583__$1);
var inst_34585 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_34584);
var state_34597__$1 = (function (){var statearr_34599 = state_34597;
(statearr_34599[(7)] = inst_34583__$1);

return statearr_34599;
})();
if(inst_34585){
var statearr_34600_34609 = state_34597__$1;
(statearr_34600_34609[(1)] = (3));

} else {
var statearr_34601_34610 = state_34597__$1;
(statearr_34601_34610[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34598 === (3))){
var inst_34583 = (state_34597[(7)]);
var state_34597__$1 = state_34597;
var statearr_34602_34611 = state_34597__$1;
(statearr_34602_34611[(2)] = inst_34583);

(statearr_34602_34611[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34598 === (4))){
var inst_34583 = (state_34597[(7)]);
var inst_34588 = (function (){var body = inst_34583;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_34589 = cljs.core.second(inst_34583);
var inst_34590 = cljs.core.second(inst_34589);
var inst_34591 = cljs.core.first(inst_34590);
var inst_34592 = cljs.core.second(inst_34591);
var inst_34593 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_34588,inst_34592);
var state_34597__$1 = state_34597;
var statearr_34603_34612 = state_34597__$1;
(statearr_34603_34612[(2)] = inst_34593);

(statearr_34603_34612[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34598 === (5))){
var inst_34595 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34597__$1,inst_34595);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto____0 = (function (){
var statearr_34604 = [null,null,null,null,null,null,null,null];
(statearr_34604[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto__);

(statearr_34604[(1)] = (1));

return statearr_34604;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto____1 = (function (state_34597){
while(true){
var ret_value__15855__auto__ = (function (){try{while(true){
var result__15856__auto__ = switch__15853__auto__(state_34597);
if(cljs.core.keyword_identical_QMARK_(result__15856__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15856__auto__;
}
break;
}
}catch (e34605){var ex__15857__auto__ = e34605;
var statearr_34606_34613 = state_34597;
(statearr_34606_34613[(2)] = ex__15857__auto__);


if(cljs.core.seq((state_34597[(4)]))){
var statearr_34607_34614 = state_34597;
(statearr_34607_34614[(1)] = cljs.core.first((state_34597[(4)])));

} else {
throw ex__15857__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15855__auto__,cljs.core.cst$kw$recur)){
var G__34615 = state_34597;
state_34597 = G__34615;
continue;
} else {
return ret_value__15855__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto__ = function(state_34597){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto____1.call(this,state_34597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15854__auto__;
})()
})();
var state__15893__auto__ = (function (){var statearr_34608 = (f__15892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15892__auto__.cljs$core$IFn$_invoke$arity$0() : f__15892__auto__.call(null));
(statearr_34608[(6)] = c__15891__auto__);

return statearr_34608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15893__auto__);
}));

return c__15891__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34616_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34616_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34617_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34617_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34618_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__34618_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34618_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__34618_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__15891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15892__auto__ = (function (){var switch__15853__auto__ = (function (state_34664){
var state_val_34665 = (state_34664[(1)]);
if((state_val_34665 === (7))){
var inst_34629 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_34664__$1 = state_34664;
var statearr_34666_34694 = state_34664__$1;
(statearr_34666_34694[(2)] = inst_34629);

(statearr_34666_34694[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (1))){
var state_34664__$1 = state_34664;
var statearr_34667_34695 = state_34664__$1;
(statearr_34667_34695[(2)] = null);

(statearr_34667_34695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (4))){
var inst_34619 = (state_34664[(2)]);
var state_34664__$1 = state_34664;
var statearr_34668_34696 = state_34664__$1;
(statearr_34668_34696[(2)] = inst_34619);

(statearr_34668_34696[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (15))){
var inst_34643 = (state_34664[(7)]);
var inst_34638 = (state_34664[(8)]);
var inst_34637 = (state_34664[(9)]);
var inst_34648 = (state_34664[(2)]);
var inst_34649 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_34643,(0),inst_34648);
var inst_34650 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34651 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_34637);
var inst_34652 = [inst_34638,inst_34651];
var inst_34653 = cljs.core.PersistentHashMap.fromArrays(inst_34650,inst_34652);
var inst_34654 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34649,inst_34653);
var inst_34655 = (function(){throw inst_34654})();
var state_34664__$1 = state_34664;
var statearr_34669_34697 = state_34664__$1;
(statearr_34669_34697[(2)] = inst_34655);

(statearr_34669_34697[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (13))){
var inst_34642 = (state_34664[(10)]);
var state_34664__$1 = state_34664;
var statearr_34670_34698 = state_34664__$1;
(statearr_34670_34698[(2)] = inst_34642);

(statearr_34670_34698[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (6))){
var state_34664__$1 = state_34664;
var statearr_34671_34699 = state_34664__$1;
(statearr_34671_34699[(2)] = null);

(statearr_34671_34699[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (3))){
var inst_34662 = (state_34664[(2)]);
var state_34664__$1 = state_34664;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34664__$1,inst_34662);
} else {
if((state_val_34665 === (12))){
var inst_34659 = (state_34664[(2)]);
var _ = (function (){var statearr_34672 = state_34664;
(statearr_34672[(4)] = cljs.core.rest((state_34664[(4)])));

return statearr_34672;
})();
var state_34664__$1 = state_34664;
var statearr_34673_34700 = state_34664__$1;
(statearr_34673_34700[(2)] = inst_34659);

(statearr_34673_34700[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (2))){
var _ = (function (){var statearr_34674 = state_34664;
(statearr_34674[(4)] = cljs.core.cons((5),(state_34664[(4)])));

return statearr_34674;
})();
var inst_34626 = cljs.core.empty_QMARK_(matching_vars);
var state_34664__$1 = state_34664;
if(inst_34626){
var statearr_34675_34701 = state_34664__$1;
(statearr_34675_34701[(1)] = (6));

} else {
var statearr_34676_34702 = state_34664__$1;
(statearr_34676_34702[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (11))){
var inst_34637 = (state_34664[(9)]);
var inst_34657 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_34637,all_vars);
var state_34664__$1 = state_34664;
var statearr_34678_34703 = state_34664__$1;
(statearr_34678_34703[(2)] = inst_34657);

(statearr_34678_34703[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (9))){
var inst_34638 = (state_34664[(8)]);
var inst_34637 = (state_34664[(9)]);
var inst_34635 = (state_34664[(2)]);
var inst_34636 = fluree.db.util.async.throw_err(inst_34635);
var inst_34637__$1 = cljs.core.__destructure_map(inst_34636);
var inst_34638__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34637__$1,cljs.core.cst$kw$status);
var inst_34639 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34637__$1,cljs.core.cst$kw$message);
var inst_34640 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_34638__$1);
var state_34664__$1 = (function (){var statearr_34679 = state_34664;
(statearr_34679[(11)] = inst_34639);

(statearr_34679[(8)] = inst_34638__$1);

(statearr_34679[(9)] = inst_34637__$1);

return statearr_34679;
})();
if(inst_34640){
var statearr_34680_34704 = state_34664__$1;
(statearr_34680_34704[(1)] = (10));

} else {
var statearr_34681_34705 = state_34664__$1;
(statearr_34681_34705[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (5))){
var _ = (function (){var statearr_34682 = state_34664;
(statearr_34682[(4)] = cljs.core.rest((state_34664[(4)])));

return statearr_34682;
})();
var state_34664__$1 = state_34664;
var ex34677 = (state_34664__$1[(2)]);
var statearr_34683_34706 = state_34664__$1;
(statearr_34683_34706[(5)] = ex34677);


if((ex34677 instanceof Error)){
var statearr_34684_34707 = state_34664__$1;
(statearr_34684_34707[(1)] = (4));

(statearr_34684_34707[(5)] = null);

} else {
throw ex34677;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (14))){
var state_34664__$1 = state_34664;
var statearr_34685_34708 = state_34664__$1;
(statearr_34685_34708[(2)] = (1000));

(statearr_34685_34708[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (10))){
var inst_34639 = (state_34664[(11)]);
var inst_34642 = (state_34664[(10)]);
var inst_34637 = (state_34664[(9)]);
var inst_34642__$1 = cljs.core.count(inst_34639);
var inst_34643 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_34637);
var inst_34644 = (inst_34642__$1 < (1000));
var state_34664__$1 = (function (){var statearr_34686 = state_34664;
(statearr_34686[(7)] = inst_34643);

(statearr_34686[(10)] = inst_34642__$1);

return statearr_34686;
})();
if(cljs.core.truth_(inst_34644)){
var statearr_34687_34709 = state_34664__$1;
(statearr_34687_34709[(1)] = (13));

} else {
var statearr_34688_34710 = state_34664__$1;
(statearr_34688_34710[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34665 === (8))){
var inst_34631 = (state_34664[(2)]);
var inst_34632 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_34631,optional_clauses);
var inst_34633 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_34632);
var state_34664__$1 = state_34664;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34664__$1,(9),inst_34633);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto____0 = (function (){
var statearr_34689 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34689[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto__);

(statearr_34689[(1)] = (1));

return statearr_34689;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto____1 = (function (state_34664){
while(true){
var ret_value__15855__auto__ = (function (){try{while(true){
var result__15856__auto__ = switch__15853__auto__(state_34664);
if(cljs.core.keyword_identical_QMARK_(result__15856__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15856__auto__;
}
break;
}
}catch (e34690){var ex__15857__auto__ = e34690;
var statearr_34691_34711 = state_34664;
(statearr_34691_34711[(2)] = ex__15857__auto__);


if(cljs.core.seq((state_34664[(4)]))){
var statearr_34692_34712 = state_34664;
(statearr_34692_34712[(1)] = cljs.core.first((state_34664[(4)])));

} else {
throw ex__15857__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15855__auto__,cljs.core.cst$kw$recur)){
var G__34713 = state_34664;
state_34664 = G__34713;
continue;
} else {
return ret_value__15855__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto__ = function(state_34664){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto____1.call(this,state_34664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15854__auto__;
})()
})();
var state__15893__auto__ = (function (){var statearr_34693 = (f__15892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15892__auto__.cljs$core$IFn$_invoke$arity$0() : f__15892__auto__.call(null));
(statearr_34693[(6)] = c__15891__auto__);

return statearr_34693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15893__auto__);
}));

return c__15891__auto__;
});
