// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__33352 = arguments.length;
switch (G__33352) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__33355 = arguments.length;
switch (G__33355) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__15891__auto___33408 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15892__auto__ = (function (){var switch__15853__auto__ = (function (state_33386){
var state_val_33387 = (state_33386[(1)]);
if((state_val_33387 === (1))){
var state_33386__$1 = state_33386;
var statearr_33388_33409 = state_33386__$1;
(statearr_33388_33409[(2)] = null);

(statearr_33388_33409[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33387 === (2))){
var _ = (function (){var statearr_33389 = state_33386;
(statearr_33389[(4)] = cljs.core.cons((5),(state_33386[(4)])));

return statearr_33389;
})();
var inst_33363 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_33386__$1 = state_33386;
if(cljs.core.truth_(inst_33363)){
var statearr_33390_33410 = state_33386__$1;
(statearr_33390_33410[(1)] = (6));

} else {
var statearr_33391_33411 = state_33386__$1;
(statearr_33391_33411[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33387 === (3))){
var inst_33384 = (state_33386[(2)]);
var state_33386__$1 = state_33386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33386__$1,inst_33384);
} else {
if((state_val_33387 === (4))){
var inst_33356 = (state_33386[(2)]);
var inst_33357 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_33356);
var state_33386__$1 = state_33386;
var statearr_33393_33412 = state_33386__$1;
(statearr_33393_33412[(2)] = inst_33357);

(statearr_33393_33412[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33387 === (5))){
var _ = (function (){var statearr_33394 = state_33386;
(statearr_33394[(4)] = cljs.core.rest((state_33386[(4)])));

return statearr_33394;
})();
var state_33386__$1 = state_33386;
var ex33392 = (state_33386__$1[(2)]);
var statearr_33395_33413 = state_33386__$1;
(statearr_33395_33413[(5)] = ex33392);


var statearr_33396_33414 = state_33386__$1;
(statearr_33396_33414[(1)] = (4));

(statearr_33396_33414[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33387 === (6))){
var inst_33365 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33366 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_33367 = cljs.core.PersistentHashMap.fromArrays(inst_33365,inst_33366);
var inst_33368 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_33367);
var inst_33369 = (function(){throw inst_33368})();
var state_33386__$1 = state_33386;
var statearr_33397_33415 = state_33386__$1;
(statearr_33397_33415[(2)] = inst_33369);

(statearr_33397_33415[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33387 === (7))){
var inst_33371 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_33372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33373 = [operation,data,pc,opts];
var inst_33374 = (new cljs.core.PersistentVector(null,4,(5),inst_33372,inst_33373,null));
var inst_33375 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33371,inst_33374);
var inst_33376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33377 = [operation,data,pc,opts];
var inst_33378 = (new cljs.core.PersistentVector(null,4,(5),inst_33376,inst_33377,null));
var inst_33379 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_33378], 0));
var state_33386__$1 = (function (){var statearr_33398 = state_33386;
(statearr_33398[(7)] = inst_33375);

return statearr_33398;
})();
var statearr_33399_33416 = state_33386__$1;
(statearr_33399_33416[(2)] = inst_33379);

(statearr_33399_33416[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33387 === (8))){
var inst_33381 = (state_33386[(2)]);
var _ = (function (){var statearr_33400 = state_33386;
(statearr_33400[(4)] = cljs.core.rest((state_33386[(4)])));

return statearr_33400;
})();
var state_33386__$1 = state_33386;
var statearr_33401_33417 = state_33386__$1;
(statearr_33401_33417[(2)] = inst_33381);

(statearr_33401_33417[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__15854__auto__ = null;
var fluree$db$operations$state_machine__15854__auto____0 = (function (){
var statearr_33402 = [null,null,null,null,null,null,null,null];
(statearr_33402[(0)] = fluree$db$operations$state_machine__15854__auto__);

(statearr_33402[(1)] = (1));

return statearr_33402;
});
var fluree$db$operations$state_machine__15854__auto____1 = (function (state_33386){
while(true){
var ret_value__15855__auto__ = (function (){try{while(true){
var result__15856__auto__ = switch__15853__auto__(state_33386);
if(cljs.core.keyword_identical_QMARK_(result__15856__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15856__auto__;
}
break;
}
}catch (e33403){var ex__15857__auto__ = e33403;
var statearr_33404_33418 = state_33386;
(statearr_33404_33418[(2)] = ex__15857__auto__);


if(cljs.core.seq((state_33386[(4)]))){
var statearr_33405_33419 = state_33386;
(statearr_33405_33419[(1)] = cljs.core.first((state_33386[(4)])));

} else {
throw ex__15857__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15855__auto__,cljs.core.cst$kw$recur)){
var G__33420 = state_33386;
state_33386 = G__33420;
continue;
} else {
return ret_value__15855__auto__;
}
break;
}
});
fluree$db$operations$state_machine__15854__auto__ = function(state_33386){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__15854__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__15854__auto____1.call(this,state_33386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__15854__auto____0;
fluree$db$operations$state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__15854__auto____1;
return fluree$db$operations$state_machine__15854__auto__;
})()
})();
var state__15893__auto__ = (function (){var statearr_33406 = (f__15892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15892__auto__.cljs$core$IFn$_invoke$arity$0() : f__15892__auto__.call(null));
(statearr_33406[(6)] = c__15891__auto___33408);

return statearr_33406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15893__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__33422 = arguments.length;
switch (G__33422) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__33423){
var map__33424 = p__33423;
var map__33424__$1 = cljs.core.__destructure_map(map__33424);
var opts = map__33424__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33424__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__33425 = session;
var map__33425__$1 = cljs.core.__destructure_map(map__33425);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33425__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33425__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33425__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4835__auto__ = [];
var len__4829__auto___33452 = arguments.length;
var i__4830__auto___33453 = (0);
while(true){
if((i__4830__auto___33453 < len__4829__auto___33452)){
args__4835__auto__.push((arguments[i__4830__auto___33453]));

var G__33454 = (i__4830__auto___33453 + (1));
i__4830__auto___33453 = G__33454;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__33429){
var vec__33430 = p__33429;
var map__33433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33430,(0),null);
var map__33433__$1 = cljs.core.__destructure_map(map__33433);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33433__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33433__$1,cljs.core.cst$kw$toTime);
var opts = vec__33430;
var c__15891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15892__auto__ = (function (){var switch__15853__auto__ = (function (state_33445){
var state_val_33446 = (state_33445[(1)]);
if((state_val_33446 === (1))){
var inst_33435 = session;
var inst_33436 = cljs.core.__destructure_map(inst_33435);
var inst_33437 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33436,cljs.core.cst$kw$network);
var inst_33438 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33436,cljs.core.cst$kw$dbid);
var inst_33439 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33436,cljs.core.cst$kw$conn);
var inst_33440 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_33441 = [inst_33437,inst_33438,toBlock,toTime];
var inst_33442 = cljs.core.PersistentHashMap.fromArrays(inst_33440,inst_33441);
var inst_33443 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_33439,cljs.core.cst$kw$garbage,inst_33442);
var state_33445__$1 = state_33445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33445__$1,inst_33443);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__15854__auto__ = null;
var fluree$db$operations$state_machine__15854__auto____0 = (function (){
var statearr_33447 = [null,null,null,null,null,null,null];
(statearr_33447[(0)] = fluree$db$operations$state_machine__15854__auto__);

(statearr_33447[(1)] = (1));

return statearr_33447;
});
var fluree$db$operations$state_machine__15854__auto____1 = (function (state_33445){
while(true){
var ret_value__15855__auto__ = (function (){try{while(true){
var result__15856__auto__ = switch__15853__auto__(state_33445);
if(cljs.core.keyword_identical_QMARK_(result__15856__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15856__auto__;
}
break;
}
}catch (e33448){var ex__15857__auto__ = e33448;
var statearr_33449_33455 = state_33445;
(statearr_33449_33455[(2)] = ex__15857__auto__);


if(cljs.core.seq((state_33445[(4)]))){
var statearr_33450_33456 = state_33445;
(statearr_33450_33456[(1)] = cljs.core.first((state_33445[(4)])));

} else {
throw ex__15857__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15855__auto__,cljs.core.cst$kw$recur)){
var G__33457 = state_33445;
state_33445 = G__33457;
continue;
} else {
return ret_value__15855__auto__;
}
break;
}
});
fluree$db$operations$state_machine__15854__auto__ = function(state_33445){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__15854__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__15854__auto____1.call(this,state_33445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__15854__auto____0;
fluree$db$operations$state_machine__15854__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__15854__auto____1;
return fluree$db$operations$state_machine__15854__auto__;
})()
})();
var state__15893__auto__ = (function (){var statearr_33451 = (f__15892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15892__auto__.cljs$core$IFn$_invoke$arity$0() : f__15892__auto__.call(null));
(statearr_33451[(6)] = c__15891__auto__);

return statearr_33451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15893__auto__);
}));

return c__15891__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq33427){
var G__33428 = cljs.core.first(seq33427);
var seq33427__$1 = cljs.core.next(seq33427);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33428,seq33427__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__33458 = session;
var map__33458__$1 = cljs.core.__destructure_map(map__33458);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33458__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33458__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33458__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__33460 = arguments.length;
switch (G__33460) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__33461 = opts;
var map__33461__$1 = cljs.core.__destructure_map(map__33461);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33461__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33461__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4223__auto__ = auth;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
