// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__35204 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35204,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35204,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35204,(2),null);
if(cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__35207){
var map__35208 = p__35207;
var map__35208__$1 = cljs.core.__destructure_map(map__35208);
var opts = map__35208__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35208__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_35268){
var state_val_35269 = (state_35268[(1)]);
if((state_val_35269 === (7))){
var inst_35239 = cljs.core.not(reindex_QMARK_);
var state_35268__$1 = state_35268;
var statearr_35270_35294 = state_35268__$1;
(statearr_35270_35294[(2)] = inst_35239);

(statearr_35270_35294[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35269 === (1))){
var state_35268__$1 = state_35268;
var statearr_35271_35295 = state_35268__$1;
(statearr_35271_35295[(2)] = null);

(statearr_35271_35295[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35269 === (4))){
var inst_35209 = (state_35268[(2)]);
var state_35268__$1 = state_35268;
var statearr_35272_35296 = state_35268__$1;
(statearr_35272_35296[(2)] = inst_35209);

(statearr_35272_35296[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35269 === (6))){
var inst_35237 = (state_35268[(7)]);
var inst_35223 = (state_35268[(8)]);
var inst_35229 = (state_35268[(9)]);
var inst_35222 = (state_35268[(2)]);
var inst_35223__$1 = fluree.db.util.async.throw_err(inst_35222);
var inst_35224 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_35225 = cljs.core.__destructure_map(inst_35224);
var inst_35226 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35225,cljs.core.cst$kw$post);
var inst_35227 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35225,cljs.core.cst$kw$size);
var inst_35228 = fluree.db.flake.size_bytes(inst_35223__$1);
var inst_35229__$1 = (inst_35227 + inst_35228);
var inst_35230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35231 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_35232 = (new cljs.core.PersistentVector(null,2,(5),inst_35230,inst_35231,null));
var inst_35233 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_35232);
var inst_35234 = cljs.core.__destructure_map(inst_35233);
var inst_35235 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35234,cljs.core.cst$kw$novelty_DASH_min);
var inst_35236 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35234,cljs.core.cst$kw$novelty_DASH_max);
var inst_35237__$1 = (inst_35229__$1 > inst_35236);
var state_35268__$1 = (function (){var statearr_35273 = state_35268;
(statearr_35273[(10)] = inst_35235);

(statearr_35273[(7)] = inst_35237__$1);

(statearr_35273[(11)] = inst_35226);

(statearr_35273[(8)] = inst_35223__$1);

(statearr_35273[(9)] = inst_35229__$1);

return statearr_35273;
})();
if(cljs.core.truth_(inst_35237__$1)){
var statearr_35274_35297 = state_35268__$1;
(statearr_35274_35297[(1)] = (7));

} else {
var statearr_35275_35298 = state_35268__$1;
(statearr_35275_35298[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35269 === (3))){
var inst_35266 = (state_35268[(2)]);
var state_35268__$1 = state_35268;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35268__$1,inst_35266);
} else {
if((state_val_35269 === (12))){
var inst_35226 = (state_35268[(11)]);
var inst_35223 = (state_35268[(8)]);
var inst_35229 = (state_35268[(9)]);
var inst_35252 = (state_35268[(2)]);
var inst_35253 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35226,inst_35223);
var inst_35254 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_35255 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35254,cljs.core.empty);
var inst_35256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35257 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_35258 = (new cljs.core.PersistentVector(null,2,(5),inst_35256,inst_35257,null));
var inst_35259 = cljs.core.assoc_in(db,inst_35258,inst_35253);
var inst_35260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35261 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_35262 = (new cljs.core.PersistentVector(null,2,(5),inst_35260,inst_35261,null));
var inst_35263 = cljs.core.assoc_in(inst_35259,inst_35262,inst_35229);
var _ = (function (){var statearr_35276 = state_35268;
(statearr_35276[(4)] = cljs.core.rest((state_35268[(4)])));

return statearr_35276;
})();
var state_35268__$1 = (function (){var statearr_35277 = state_35268;
(statearr_35277[(12)] = inst_35252);

(statearr_35277[(13)] = inst_35255);

return statearr_35277;
})();
var statearr_35278_35299 = state_35268__$1;
(statearr_35278_35299[(2)] = inst_35263);

(statearr_35278_35299[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35269 === (2))){
var _ = (function (){var statearr_35279 = state_35268;
(statearr_35279[(4)] = cljs.core.cons((5),(state_35268[(4)])));

return statearr_35279;
})();
var inst_35217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35218 = [pred_id];
var inst_35219 = (new cljs.core.PersistentVector(null,1,(5),inst_35217,inst_35218,null));
var inst_35220 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_35219);
var state_35268__$1 = state_35268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35268__$1,(6),inst_35220);
} else {
if((state_val_35269 === (11))){
var state_35268__$1 = state_35268;
var statearr_35281_35300 = state_35268__$1;
(statearr_35281_35300[(2)] = null);

(statearr_35281_35300[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35269 === (9))){
var inst_35242 = (state_35268[(2)]);
var state_35268__$1 = state_35268;
if(cljs.core.truth_(inst_35242)){
var statearr_35282_35301 = state_35268__$1;
(statearr_35282_35301[(1)] = (10));

} else {
var statearr_35283_35302 = state_35268__$1;
(statearr_35283_35302[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35269 === (5))){
var _ = (function (){var statearr_35284 = state_35268;
(statearr_35284[(4)] = cljs.core.rest((state_35268[(4)])));

return statearr_35284;
})();
var state_35268__$1 = state_35268;
var ex35280 = (state_35268__$1[(2)]);
var statearr_35285_35303 = state_35268__$1;
(statearr_35285_35303[(5)] = ex35280);


if((ex35280 instanceof Error)){
var statearr_35286_35304 = state_35268__$1;
(statearr_35286_35304[(1)] = (4));

(statearr_35286_35304[(5)] = null);

} else {
throw ex35280;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35269 === (10))){
var inst_35244 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_35245 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_35246 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_35247 = cljs.core.PersistentHashMap.fromArrays(inst_35245,inst_35246);
var inst_35248 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35244,inst_35247);
var inst_35249 = (function(){throw inst_35248})();
var state_35268__$1 = state_35268;
var statearr_35287_35305 = state_35268__$1;
(statearr_35287_35305[(2)] = inst_35249);

(statearr_35287_35305[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35269 === (8))){
var inst_35237 = (state_35268[(7)]);
var state_35268__$1 = state_35268;
var statearr_35288_35306 = state_35268__$1;
(statearr_35288_35306[(2)] = inst_35237);

(statearr_35288_35306[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto____0 = (function (){
var statearr_35289 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35289[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto__);

(statearr_35289[(1)] = (1));

return statearr_35289;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto____1 = (function (state_35268){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_35268);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e35290){var ex__10801__auto__ = e35290;
var statearr_35291_35307 = state_35268;
(statearr_35291_35307[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_35268[(4)]))){
var statearr_35292_35308 = state_35268;
(statearr_35292_35308[(1)] = cljs.core.first((state_35268[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__35309 = state_35268;
state_35268 = G__35309;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto__ = function(state_35268){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto____1.call(this,state_35268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_35293 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_35293[(6)] = c__10835__auto__);

return statearr_35293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__35314 = arguments.length;
switch (G__35314) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_35510){
var state_val_35511 = (state_35510[(1)]);
if((state_val_35511 === (7))){
var state_35510__$1 = state_35510;
var statearr_35512_35580 = state_35510__$1;
(statearr_35512_35580[(2)] = null);

(statearr_35512_35580[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (20))){
var inst_35436 = (state_35510[(7)]);
var inst_35352 = (state_35510[(8)]);
var inst_35403 = (state_35510[(9)]);
var inst_35434 = (state_35510[(10)]);
var inst_35353 = (state_35510[(11)]);
var inst_35432 = (state_35510[(12)]);
var inst_35435 = (state_35510[(13)]);
var inst_35433 = (state_35510[(14)]);
var inst_35446 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_35447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35448 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_35449 = (new cljs.core.PersistentVector(null,2,(5),inst_35447,inst_35448,null));
var inst_35450 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35403,inst_35449);
var inst_35451 = (inst_35352 + inst_35450);
var inst_35452 = [inst_35432,inst_35433,inst_35434,inst_35435,inst_35451];
var inst_35453 = cljs.core.PersistentHashMap.fromArrays(inst_35446,inst_35452);
var inst_35454 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_35403,cljs.core.cst$kw$ecount,inst_35436,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_35453], 0));
var state_35510__$1 = (function (){var statearr_35513 = state_35510;
(statearr_35513[(15)] = inst_35454);

return statearr_35513;
})();
if(cljs.core.truth_(inst_35353)){
var statearr_35514_35581 = state_35510__$1;
(statearr_35514_35581[(1)] = (23));

} else {
var statearr_35515_35582 = state_35510__$1;
(statearr_35515_35582[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (27))){
var inst_35454 = (state_35510[(15)]);
var state_35510__$1 = state_35510;
var statearr_35516_35583 = state_35510__$1;
(statearr_35516_35583[(2)] = inst_35454);

(statearr_35516_35583[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (1))){
var state_35510__$1 = state_35510;
var statearr_35517_35584 = state_35510__$1;
(statearr_35517_35584[(2)] = null);

(statearr_35517_35584[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (24))){
var inst_35454 = (state_35510[(15)]);
var inst_35457 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_35454);
var inst_35458 = (inst_35457 == null);
var state_35510__$1 = state_35510;
var statearr_35518_35585 = state_35510__$1;
(statearr_35518_35585[(2)] = inst_35458);

(statearr_35518_35585[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (39))){
var inst_35486 = (state_35510[(16)]);
var inst_35484 = (state_35510[(17)]);
var inst_35493 = (state_35510[(18)]);
var inst_35485 = (state_35510[(19)]);
var inst_35443 = (state_35510[(20)]);
var inst_35500 = (state_35510[(2)]);
var inst_35431 = inst_35443;
var inst_35432 = inst_35485;
var inst_35433 = inst_35486;
var inst_35434 = inst_35493;
var inst_35435 = inst_35500;
var inst_35436 = inst_35484;
var state_35510__$1 = (function (){var statearr_35519 = state_35510;
(statearr_35519[(7)] = inst_35436);

(statearr_35519[(10)] = inst_35434);

(statearr_35519[(21)] = inst_35431);

(statearr_35519[(12)] = inst_35432);

(statearr_35519[(13)] = inst_35435);

(statearr_35519[(14)] = inst_35433);

return statearr_35519;
})();
var statearr_35520_35586 = state_35510__$1;
(statearr_35520_35586[(2)] = null);

(statearr_35520_35586[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (4))){
var inst_35315 = (state_35510[(2)]);
var state_35510__$1 = state_35510;
var statearr_35521_35587 = state_35510__$1;
(statearr_35521_35587[(2)] = inst_35315);

(statearr_35521_35587[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (15))){
var inst_35375 = (state_35510[(22)]);
var state_35510__$1 = state_35510;
var statearr_35522_35588 = state_35510__$1;
(statearr_35522_35588[(2)] = inst_35375);

(statearr_35522_35588[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (21))){
var inst_35343 = (state_35510[(23)]);
var inst_35354 = (state_35510[(24)]);
var inst_35436 = (state_35510[(7)]);
var inst_35352 = (state_35510[(8)]);
var inst_35347 = (state_35510[(25)]);
var inst_35413 = (state_35510[(26)]);
var inst_35403 = (state_35510[(9)]);
var inst_35434 = (state_35510[(10)]);
var inst_35442 = (state_35510[(27)]);
var inst_35431 = (state_35510[(21)]);
var inst_35353 = (state_35510[(11)]);
var inst_35356 = (state_35510[(28)]);
var inst_35362 = (state_35510[(29)]);
var inst_35412 = (state_35510[(30)]);
var inst_35432 = (state_35510[(12)]);
var inst_35337 = (state_35510[(31)]);
var inst_35435 = (state_35510[(13)]);
var inst_35339 = (state_35510[(32)]);
var inst_35351 = (state_35510[(33)]);
var inst_35443 = (state_35510[(20)]);
var inst_35433 = (state_35510[(14)]);
var inst_35322 = (state_35510[(34)]);
var inst_35481 = inst_35442.s;
var inst_35482 = fluree.db.flake.sid__GT_cid(inst_35481);
var inst_35483 = (function (){var flakes_bytes = inst_35352;
var t = inst_35322;
var spot = inst_35432;
var add_flakes = inst_35339;
var root_setting_change_QMARK_ = inst_35354;
var vec__35438 = inst_35431;
var ref_QMARK__map = inst_35351;
var r = inst_35443;
var psot = inst_35433;
var add_pred_to_idx_QMARK_ = inst_35362;
var _ = inst_35337;
var G__35407 = inst_35431;
var cid = inst_35482;
var ecount = inst_35436;
var pred_ecount = inst_35356;
var first__35440 = inst_35442;
var vec__35408 = inst_35339;
var db_STAR_ = inst_35403;
var schema_change_QMARK_ = inst_35353;
var seq__35439 = inst_35443;
var add_preds = inst_35343;
var first__35410 = inst_35412;
var opst = inst_35435;
var seq__35409 = inst_35413;
var idx_QMARK__map = inst_35347;
var post = inst_35434;
var f = inst_35442;
return (function (p1__35312_SHARP_){
if(cljs.core.truth_(p1__35312_SHARP_)){
var x__4306__auto__ = p1__35312_SHARP_;
var y__4307__auto__ = f.s;
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
} else {
return f.s;
}
});
})();
var inst_35484 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_35436,inst_35482,inst_35483);
var inst_35485 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35432,inst_35442);
var inst_35486 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35433,inst_35442);
var inst_35487 = inst_35442.p;
var inst_35488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35347,inst_35487);
var state_35510__$1 = (function (){var statearr_35523 = state_35510;
(statearr_35523[(16)] = inst_35486);

(statearr_35523[(17)] = inst_35484);

(statearr_35523[(19)] = inst_35485);

return statearr_35523;
})();
if(cljs.core.truth_(inst_35488)){
var statearr_35524_35589 = state_35510__$1;
(statearr_35524_35589[(1)] = (34));

} else {
var statearr_35525_35590 = state_35510__$1;
(statearr_35525_35590[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (31))){
var inst_35469 = (state_35510[(35)]);
var state_35510__$1 = state_35510;
var statearr_35526_35591 = state_35510__$1;
(statearr_35526_35591[(2)] = inst_35469);

(statearr_35526_35591[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (32))){
var inst_35479 = (state_35510[(2)]);
var state_35510__$1 = state_35510;
var statearr_35527_35592 = state_35510__$1;
(statearr_35527_35592[(2)] = inst_35479);

(statearr_35527_35592[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (33))){
var inst_35469 = (state_35510[(35)]);
var inst_35474 = (state_35510[(2)]);
var inst_35475 = fluree.db.util.async.throw_err(inst_35474);
var inst_35476 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35469,cljs.core.cst$kw$settings,inst_35475);
var state_35510__$1 = state_35510;
var statearr_35528_35593 = state_35510__$1;
(statearr_35528_35593[(2)] = inst_35476);

(statearr_35528_35593[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (13))){
var inst_35352 = (state_35510[(8)]);
var inst_35403 = (state_35510[(9)]);
var inst_35339 = (state_35510[(32)]);
var inst_35322 = (state_35510[(34)]);
var inst_35393 = (state_35510[(2)]);
var inst_35394 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35393,cljs.core.cst$kw$t,inst_35322);
var inst_35395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35396 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_35397 = (new cljs.core.PersistentVector(null,2,(5),inst_35395,inst_35396,null));
var inst_35398 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_35394,inst_35397,cljs.core._PLUS_,inst_35352);
var inst_35399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35400 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_35401 = (new cljs.core.PersistentVector(null,2,(5),inst_35399,inst_35400,null));
var inst_35402 = cljs.core.count(inst_35339);
var inst_35403__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_35398,inst_35401,cljs.core._PLUS_,inst_35402);
var inst_35411 = cljs.core.seq(inst_35339);
var inst_35412 = cljs.core.first(inst_35411);
var inst_35413 = cljs.core.next(inst_35411);
var inst_35414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35415 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_35416 = (new cljs.core.PersistentVector(null,2,(5),inst_35414,inst_35415,null));
var inst_35417 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35403__$1,inst_35416);
var inst_35418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35419 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_35420 = (new cljs.core.PersistentVector(null,2,(5),inst_35418,inst_35419,null));
var inst_35421 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35403__$1,inst_35420);
var inst_35422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35423 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_35424 = (new cljs.core.PersistentVector(null,2,(5),inst_35422,inst_35423,null));
var inst_35425 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35403__$1,inst_35424);
var inst_35426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35427 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_35428 = (new cljs.core.PersistentVector(null,2,(5),inst_35426,inst_35427,null));
var inst_35429 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35403__$1,inst_35428);
var inst_35430 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_35431 = inst_35339;
var inst_35432 = inst_35417;
var inst_35433 = inst_35421;
var inst_35434 = inst_35425;
var inst_35435 = inst_35429;
var inst_35436 = inst_35430;
var state_35510__$1 = (function (){var statearr_35529 = state_35510;
(statearr_35529[(7)] = inst_35436);

(statearr_35529[(26)] = inst_35413);

(statearr_35529[(9)] = inst_35403__$1);

(statearr_35529[(10)] = inst_35434);

(statearr_35529[(21)] = inst_35431);

(statearr_35529[(30)] = inst_35412);

(statearr_35529[(12)] = inst_35432);

(statearr_35529[(13)] = inst_35435);

(statearr_35529[(14)] = inst_35433);

return statearr_35529;
})();
var statearr_35530_35594 = state_35510__$1;
(statearr_35530_35594[(2)] = null);

(statearr_35530_35594[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (22))){
var inst_35503 = (state_35510[(2)]);
var state_35510__$1 = state_35510;
var statearr_35531_35595 = state_35510__$1;
(statearr_35531_35595[(2)] = inst_35503);

(statearr_35531_35595[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (36))){
var inst_35442 = (state_35510[(27)]);
var inst_35351 = (state_35510[(33)]);
var inst_35493 = (state_35510[(2)]);
var inst_35494 = inst_35442.p;
var inst_35495 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35351,inst_35494);
var state_35510__$1 = (function (){var statearr_35532 = state_35510;
(statearr_35532[(18)] = inst_35493);

return statearr_35532;
})();
if(cljs.core.truth_(inst_35495)){
var statearr_35533_35596 = state_35510__$1;
(statearr_35533_35596[(1)] = (37));

} else {
var statearr_35534_35597 = state_35510__$1;
(statearr_35534_35597[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (29))){
var inst_35454 = (state_35510[(15)]);
var inst_35464 = (state_35510[(2)]);
var inst_35465 = fluree.db.util.async.throw_err(inst_35464);
var inst_35466 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35454,cljs.core.cst$kw$schema,inst_35465);
var state_35510__$1 = state_35510;
var statearr_35535_35598 = state_35510__$1;
(statearr_35535_35598[(2)] = inst_35466);

(statearr_35535_35598[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (6))){
var inst_35322 = (state_35510[(34)]);
var inst_35327 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_35328 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_35329 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35327)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35328)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35322),"."].join('');
var inst_35330 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35331 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_35332 = cljs.core.PersistentHashMap.fromArrays(inst_35330,inst_35331);
var inst_35333 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35329,inst_35332);
var inst_35334 = (function(){throw inst_35333})();
var state_35510__$1 = state_35510;
var statearr_35536_35599 = state_35510__$1;
(statearr_35536_35599[(2)] = inst_35334);

(statearr_35536_35599[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (28))){
var inst_35354 = (state_35510[(24)]);
var inst_35469 = (state_35510[(2)]);
var state_35510__$1 = (function (){var statearr_35537 = state_35510;
(statearr_35537[(35)] = inst_35469);

return statearr_35537;
})();
if(cljs.core.truth_(inst_35354)){
var statearr_35538_35600 = state_35510__$1;
(statearr_35538_35600[(1)] = (30));

} else {
var statearr_35539_35601 = state_35510__$1;
(statearr_35539_35601[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (25))){
var inst_35460 = (state_35510[(2)]);
var state_35510__$1 = state_35510;
if(cljs.core.truth_(inst_35460)){
var statearr_35540_35602 = state_35510__$1;
(statearr_35540_35602[(1)] = (26));

} else {
var statearr_35541_35603 = state_35510__$1;
(statearr_35541_35603[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (34))){
var inst_35434 = (state_35510[(10)]);
var inst_35442 = (state_35510[(27)]);
var inst_35490 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35434,inst_35442);
var state_35510__$1 = state_35510;
var statearr_35542_35604 = state_35510__$1;
(statearr_35542_35604[(2)] = inst_35490);

(statearr_35542_35604[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (17))){
var inst_35382 = (state_35510[(36)]);
var inst_35386 = (state_35510[(2)]);
var inst_35387 = fluree.db.util.async.throw_err(inst_35386);
var inst_35374 = inst_35382;
var inst_35375 = inst_35387;
var state_35510__$1 = (function (){var statearr_35543 = state_35510;
(statearr_35543[(22)] = inst_35375);

(statearr_35543[(37)] = inst_35374);

return statearr_35543;
})();
var statearr_35544_35605 = state_35510__$1;
(statearr_35544_35605[(2)] = null);

(statearr_35544_35605[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (3))){
var inst_35508 = (state_35510[(2)]);
var state_35510__$1 = state_35510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35510__$1,inst_35508);
} else {
if((state_val_35511 === (12))){
var inst_35381 = (state_35510[(38)]);
var inst_35374 = (state_35510[(37)]);
var inst_35380 = cljs.core.seq(inst_35374);
var inst_35381__$1 = cljs.core.first(inst_35380);
var inst_35382 = cljs.core.next(inst_35380);
var state_35510__$1 = (function (){var statearr_35545 = state_35510;
(statearr_35545[(38)] = inst_35381__$1);

(statearr_35545[(36)] = inst_35382);

return statearr_35545;
})();
if(cljs.core.truth_(inst_35381__$1)){
var statearr_35546_35606 = state_35510__$1;
(statearr_35546_35606[(1)] = (14));

} else {
var statearr_35547_35607 = state_35510__$1;
(statearr_35547_35607[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (2))){
var inst_35322 = (state_35510[(34)]);
var _ = (function (){var statearr_35548 = state_35510;
(statearr_35548[(4)] = cljs.core.cons((5),(state_35510[(4)])));

return statearr_35548;
})();
var inst_35321 = cljs.core.first(flakes);
var inst_35322__$1 = inst_35321.t;
var inst_35323 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_35324 = (inst_35323 - (1));
var inst_35325 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_35322__$1,inst_35324);
var state_35510__$1 = (function (){var statearr_35549 = state_35510;
(statearr_35549[(34)] = inst_35322__$1);

return statearr_35549;
})();
if(inst_35325){
var statearr_35550_35608 = state_35510__$1;
(statearr_35550_35608[(1)] = (6));

} else {
var statearr_35551_35609 = state_35510__$1;
(statearr_35551_35609[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (23))){
var inst_35353 = (state_35510[(11)]);
var state_35510__$1 = state_35510;
var statearr_35552_35610 = state_35510__$1;
(statearr_35552_35610[(2)] = inst_35353);

(statearr_35552_35610[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (35))){
var inst_35434 = (state_35510[(10)]);
var state_35510__$1 = state_35510;
var statearr_35553_35611 = state_35510__$1;
(statearr_35553_35611[(2)] = inst_35434);

(statearr_35553_35611[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (19))){
var inst_35505 = (state_35510[(2)]);
var _ = (function (){var statearr_35554 = state_35510;
(statearr_35554[(4)] = cljs.core.rest((state_35510[(4)])));

return statearr_35554;
})();
var state_35510__$1 = state_35510;
var statearr_35555_35612 = state_35510__$1;
(statearr_35555_35612[(2)] = inst_35505);

(statearr_35555_35612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (11))){
var inst_35362 = (state_35510[(29)]);
var inst_35362__$1 = (state_35510[(2)]);
var inst_35370 = cljs.core.seq(inst_35362__$1);
var inst_35371 = cljs.core.first(inst_35370);
var inst_35372 = cljs.core.next(inst_35370);
var inst_35373 = db;
var inst_35374 = inst_35362__$1;
var inst_35375 = inst_35373;
var state_35510__$1 = (function (){var statearr_35557 = state_35510;
(statearr_35557[(22)] = inst_35375);

(statearr_35557[(29)] = inst_35362__$1);

(statearr_35557[(39)] = inst_35371);

(statearr_35557[(37)] = inst_35374);

(statearr_35557[(40)] = inst_35372);

return statearr_35557;
})();
var statearr_35558_35613 = state_35510__$1;
(statearr_35558_35613[(2)] = null);

(statearr_35558_35613[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (9))){
var inst_35356 = (state_35510[(28)]);
var inst_35339 = (state_35510[(32)]);
var inst_35358 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_35339,inst_35356);
var state_35510__$1 = state_35510;
var statearr_35559_35614 = state_35510__$1;
(statearr_35559_35614[(2)] = inst_35358);

(statearr_35559_35614[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (5))){
var _ = (function (){var statearr_35560 = state_35510;
(statearr_35560[(4)] = cljs.core.rest((state_35510[(4)])));

return statearr_35560;
})();
var state_35510__$1 = state_35510;
var ex35556 = (state_35510__$1[(2)]);
var statearr_35561_35615 = state_35510__$1;
(statearr_35561_35615[(5)] = ex35556);


if((ex35556 instanceof Error)){
var statearr_35562_35616 = state_35510__$1;
(statearr_35562_35616[(1)] = (4));

(statearr_35562_35616[(5)] = null);

} else {
throw ex35556;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (14))){
var inst_35375 = (state_35510[(22)]);
var inst_35381 = (state_35510[(38)]);
var inst_35384 = fluree.db.graphdb.add_predicate_to_idx(inst_35375,inst_35381,opts);
var state_35510__$1 = state_35510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35510__$1,(17),inst_35384);
} else {
if((state_val_35511 === (26))){
var inst_35454 = (state_35510[(15)]);
var inst_35462 = fluree.db.query.schema.schema_map(inst_35454);
var state_35510__$1 = state_35510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35510__$1,(29),inst_35462);
} else {
if((state_val_35511 === (16))){
var inst_35391 = (state_35510[(2)]);
var state_35510__$1 = state_35510;
var statearr_35563_35617 = state_35510__$1;
(statearr_35563_35617[(2)] = inst_35391);

(statearr_35563_35617[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (38))){
var inst_35435 = (state_35510[(13)]);
var state_35510__$1 = state_35510;
var statearr_35564_35618 = state_35510__$1;
(statearr_35564_35618[(2)] = inst_35435);

(statearr_35564_35618[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (30))){
var inst_35469 = (state_35510[(35)]);
var inst_35472 = fluree.db.query.schema.setting_map(inst_35469);
var state_35510__$1 = state_35510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35510__$1,(33),inst_35472);
} else {
if((state_val_35511 === (10))){
var inst_35360 = cljs.core.PersistentVector.EMPTY;
var state_35510__$1 = state_35510;
var statearr_35565_35619 = state_35510__$1;
(statearr_35565_35619[(2)] = inst_35360);

(statearr_35565_35619[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (18))){
var inst_35442 = (state_35510[(27)]);
var inst_35431 = (state_35510[(21)]);
var inst_35441 = cljs.core.seq(inst_35431);
var inst_35442__$1 = cljs.core.first(inst_35441);
var inst_35443 = cljs.core.next(inst_35441);
var inst_35444 = cljs.core.not(inst_35442__$1);
var state_35510__$1 = (function (){var statearr_35566 = state_35510;
(statearr_35566[(27)] = inst_35442__$1);

(statearr_35566[(20)] = inst_35443);

return statearr_35566;
})();
if(inst_35444){
var statearr_35567_35620 = state_35510__$1;
(statearr_35567_35620[(1)] = (20));

} else {
var statearr_35568_35621 = state_35510__$1;
(statearr_35568_35621[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (37))){
var inst_35442 = (state_35510[(27)]);
var inst_35435 = (state_35510[(13)]);
var inst_35497 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35435,inst_35442);
var state_35510__$1 = state_35510;
var statearr_35569_35622 = state_35510__$1;
(statearr_35569_35622[(2)] = inst_35497);

(statearr_35569_35622[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35511 === (8))){
var inst_35343 = (state_35510[(23)]);
var inst_35347 = (state_35510[(25)]);
var inst_35353 = (state_35510[(11)]);
var inst_35337 = (state_35510[(31)]);
var inst_35339 = (state_35510[(32)]);
var inst_35322 = (state_35510[(34)]);
var inst_35337__$1 = (state_35510[(2)]);
var inst_35338 = (function (){var t = inst_35322;
var _ = inst_35337__$1;
return (function (p1__35310_SHARP_){
return cljs.core.not((function (){var G__35570 = p1__35310_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__35570) : fluree.db.graphdb.exclude_predicates.call(null,G__35570));
})());
});
})();
var inst_35339__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_35338,flakes);
var inst_35340 = cljs.core.PersistentHashSet.EMPTY;
var inst_35341 = (function (){var t = inst_35322;
var _ = inst_35337__$1;
var add_flakes = inst_35339__$1;
return (function (p1__35311_SHARP_){
return p1__35311_SHARP_.p;
});
})();
var inst_35342 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35341,inst_35339__$1);
var inst_35343__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35340,inst_35342);
var inst_35344 = cljs.core.PersistentHashMap.EMPTY;
var inst_35345 = (function (){var t = inst_35322;
var _ = inst_35337__$1;
var add_flakes = inst_35339__$1;
var add_preds = inst_35343__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_35346 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35345,inst_35343__$1);
var inst_35347__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35344,inst_35346);
var inst_35348 = cljs.core.PersistentHashMap.EMPTY;
var inst_35349 = (function (){var t = inst_35322;
var _ = inst_35337__$1;
var add_flakes = inst_35339__$1;
var add_preds = inst_35343__$1;
var idx_QMARK__map = inst_35347__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_35350 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35349,inst_35343__$1);
var inst_35351 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35348,inst_35350);
var inst_35352 = fluree.db.flake.size_bytes(inst_35339__$1);
var inst_35353__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_35339__$1);
var inst_35354 = fluree.db.util.schema.setting_change_QMARK_(inst_35339__$1);
var inst_35355 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_35356 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35355,(0));
var state_35510__$1 = (function (){var statearr_35571 = state_35510;
(statearr_35571[(23)] = inst_35343__$1);

(statearr_35571[(24)] = inst_35354);

(statearr_35571[(8)] = inst_35352);

(statearr_35571[(25)] = inst_35347__$1);

(statearr_35571[(11)] = inst_35353__$1);

(statearr_35571[(28)] = inst_35356);

(statearr_35571[(31)] = inst_35337__$1);

(statearr_35571[(32)] = inst_35339__$1);

(statearr_35571[(33)] = inst_35351);

return statearr_35571;
})();
if(cljs.core.truth_(inst_35353__$1)){
var statearr_35572_35623 = state_35510__$1;
(statearr_35572_35623[(1)] = (9));

} else {
var statearr_35573_35624 = state_35510__$1;
(statearr_35573_35624[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10798__auto__ = null;
var fluree$db$graphdb$state_machine__10798__auto____0 = (function (){
var statearr_35574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35574[(0)] = fluree$db$graphdb$state_machine__10798__auto__);

(statearr_35574[(1)] = (1));

return statearr_35574;
});
var fluree$db$graphdb$state_machine__10798__auto____1 = (function (state_35510){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_35510);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e35575){var ex__10801__auto__ = e35575;
var statearr_35576_35625 = state_35510;
(statearr_35576_35625[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_35510[(4)]))){
var statearr_35577_35626 = state_35510;
(statearr_35577_35626[(1)] = cljs.core.first((state_35510[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__35627 = state_35510;
state_35510 = G__35627;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10798__auto__ = function(state_35510){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10798__auto____1.call(this,state_35510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10798__auto____0;
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10798__auto____1;
return fluree$db$graphdb$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_35578 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_35578[(6)] = c__10835__auto__);

return statearr_35578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__35629 = arguments.length;
switch (G__35629) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10835__auto___35776 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_35725){
var state_val_35726 = (state_35725[(1)]);
if((state_val_35726 === (7))){
var state_35725__$1 = state_35725;
var statearr_35727_35777 = state_35725__$1;
(statearr_35727_35777[(2)] = null);

(statearr_35727_35777[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (20))){
var inst_35673 = (state_35725[(7)]);
var inst_35674 = (state_35725[(8)]);
var inst_35675 = (state_35725[(9)]);
var inst_35694 = (inst_35673 + (1));
var inst_35695 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35675,cljs.core.cst$kw$t,inst_35694);
var inst_35696 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_35695,inst_35674,opts);
var state_35725__$1 = state_35725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35725__$1,(23),inst_35696);
} else {
if((state_val_35726 === (1))){
var state_35725__$1 = state_35725;
var statearr_35728_35778 = state_35725__$1;
(statearr_35728_35778[(2)] = null);

(statearr_35728_35778[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (24))){
var inst_35699 = (state_35725[(10)]);
var inst_35702 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35699,cljs.core.cst$kw$block,block);
var state_35725__$1 = state_35725;
var statearr_35729_35779 = state_35725__$1;
(statearr_35729_35779[(2)] = inst_35702);

(statearr_35729_35779[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (4))){
var inst_35630 = (state_35725[(2)]);
var inst_35631 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_35630);
var state_35725__$1 = state_35725;
var statearr_35730_35780 = state_35725__$1;
(statearr_35730_35780[(2)] = inst_35631);

(statearr_35730_35780[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (15))){
var inst_35681 = (state_35725[(11)]);
var state_35725__$1 = state_35725;
var statearr_35731_35781 = state_35725__$1;
(statearr_35731_35781[(2)] = inst_35681);

(statearr_35731_35781[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (21))){
var state_35725__$1 = state_35725;
var statearr_35732_35782 = state_35725__$1;
(statearr_35732_35782[(2)] = null);

(statearr_35732_35782[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (13))){
var inst_35717 = (state_35725[(2)]);
var inst_35718 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_35717);
var state_35725__$1 = state_35725;
var statearr_35733_35783 = state_35725__$1;
(statearr_35733_35783[(2)] = inst_35718);

(statearr_35733_35783[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (22))){
var inst_35713 = (state_35725[(2)]);
var state_35725__$1 = state_35725;
var statearr_35734_35784 = state_35725__$1;
(statearr_35734_35784[(2)] = inst_35713);

(statearr_35734_35784[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (6))){
var inst_35641 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_35642 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_35643 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35641)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35642)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_35644 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35645 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_35646 = cljs.core.PersistentHashMap.fromArrays(inst_35644,inst_35645);
var inst_35647 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35643,inst_35646);
var inst_35648 = (function(){throw inst_35647})();
var state_35725__$1 = state_35725;
var statearr_35737_35785 = state_35725__$1;
(statearr_35737_35785[(2)] = inst_35648);

(statearr_35737_35785[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (25))){
var inst_35699 = (state_35725[(10)]);
var inst_35682 = (state_35725[(12)]);
var inst_35681 = (state_35725[(11)]);
var inst_35704 = inst_35681.t;
var inst_35705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35706 = [inst_35681];
var inst_35707 = (new cljs.core.PersistentVector(null,1,(5),inst_35705,inst_35706,null));
var inst_35672 = inst_35682;
var inst_35673 = inst_35704;
var inst_35674 = inst_35707;
var inst_35675 = inst_35699;
var state_35725__$1 = (function (){var statearr_35738 = state_35725;
(statearr_35738[(7)] = inst_35673);

(statearr_35738[(8)] = inst_35674);

(statearr_35738[(9)] = inst_35675);

(statearr_35738[(13)] = inst_35672);

return statearr_35738;
})();
var statearr_35739_35786 = state_35725__$1;
(statearr_35739_35786[(2)] = null);

(statearr_35739_35786[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (17))){
var inst_35673 = (state_35725[(7)]);
var inst_35682 = (state_35725[(12)]);
var inst_35674 = (state_35725[(8)]);
var inst_35675 = (state_35725[(9)]);
var inst_35681 = (state_35725[(11)]);
var inst_35690 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35674,inst_35681);
var tmp35735 = inst_35673;
var tmp35736 = inst_35675;
var inst_35672 = inst_35682;
var inst_35673__$1 = tmp35735;
var inst_35674__$1 = inst_35690;
var inst_35675__$1 = tmp35736;
var state_35725__$1 = (function (){var statearr_35740 = state_35725;
(statearr_35740[(7)] = inst_35673__$1);

(statearr_35740[(8)] = inst_35674__$1);

(statearr_35740[(9)] = inst_35675__$1);

(statearr_35740[(13)] = inst_35672);

return statearr_35740;
})();
var statearr_35741_35787 = state_35725__$1;
(statearr_35741_35787[(2)] = null);

(statearr_35741_35787[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (3))){
var inst_35723 = (state_35725[(2)]);
var state_35725__$1 = state_35725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35725__$1,inst_35723);
} else {
if((state_val_35726 === (12))){
var inst_35672 = (state_35725[(13)]);
var inst_35681 = (state_35725[(11)]);
var inst_35680 = cljs.core.seq(inst_35672);
var inst_35681__$1 = cljs.core.first(inst_35680);
var inst_35682 = cljs.core.next(inst_35680);
var state_35725__$1 = (function (){var statearr_35742 = state_35725;
(statearr_35742[(12)] = inst_35682);

(statearr_35742[(11)] = inst_35681__$1);

return statearr_35742;
})();
if(cljs.core.truth_(inst_35681__$1)){
var statearr_35743_35788 = state_35725__$1;
(statearr_35743_35788[(1)] = (14));

} else {
var statearr_35744_35789 = state_35725__$1;
(statearr_35744_35789[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (2))){
var _ = (function (){var statearr_35745 = state_35725;
(statearr_35745[(4)] = cljs.core.cons((5),(state_35725[(4)])));

return statearr_35745;
})();
var inst_35637 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_35638 = (inst_35637 + (1));
var inst_35639 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_35638);
var state_35725__$1 = state_35725;
if(inst_35639){
var statearr_35746_35790 = state_35725__$1;
(statearr_35746_35790[(1)] = (6));

} else {
var statearr_35747_35791 = state_35725__$1;
(statearr_35747_35791[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (23))){
var inst_35681 = (state_35725[(11)]);
var inst_35698 = (state_35725[(2)]);
var inst_35699 = fluree.db.util.async.throw_err(inst_35698);
var inst_35700 = (inst_35681 == null);
var state_35725__$1 = (function (){var statearr_35748 = state_35725;
(statearr_35748[(10)] = inst_35699);

return statearr_35748;
})();
if(cljs.core.truth_(inst_35700)){
var statearr_35749_35792 = state_35725__$1;
(statearr_35749_35792[(1)] = (24));

} else {
var statearr_35750_35793 = state_35725__$1;
(statearr_35750_35793[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (19))){
var inst_35715 = (state_35725[(2)]);
var state_35725__$1 = state_35725;
var statearr_35751_35794 = state_35725__$1;
(statearr_35751_35794[(2)] = inst_35715);

(statearr_35751_35794[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (11))){
var inst_35720 = (state_35725[(2)]);
var _ = (function (){var statearr_35753 = state_35725;
(statearr_35753[(4)] = cljs.core.rest((state_35725[(4)])));

return statearr_35753;
})();
var state_35725__$1 = state_35725;
var statearr_35754_35795 = state_35725__$1;
(statearr_35754_35795[(2)] = inst_35720);

(statearr_35754_35795[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (9))){
var inst_35654 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_35655 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_35654);
var state_35725__$1 = state_35725;
var statearr_35755_35796 = state_35725__$1;
(statearr_35755_35796[(2)] = inst_35655);

(statearr_35755_35796[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (5))){
var _ = (function (){var statearr_35756 = state_35725;
(statearr_35756[(4)] = cljs.core.rest((state_35725[(4)])));

return statearr_35756;
})();
var state_35725__$1 = state_35725;
var ex35752 = (state_35725__$1[(2)]);
var statearr_35757_35797 = state_35725__$1;
(statearr_35757_35797[(5)] = ex35752);


var statearr_35758_35798 = state_35725__$1;
(statearr_35758_35798[(1)] = (4));

(statearr_35758_35798[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (14))){
var inst_35673 = (state_35725[(7)]);
var inst_35681 = (state_35725[(11)]);
var inst_35684 = inst_35681.t;
var inst_35685 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35673,inst_35684);
var state_35725__$1 = state_35725;
var statearr_35759_35799 = state_35725__$1;
(statearr_35759_35799[(2)] = inst_35685);

(statearr_35759_35799[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (26))){
var inst_35710 = (state_35725[(2)]);
var state_35725__$1 = state_35725;
var statearr_35760_35800 = state_35725__$1;
(statearr_35760_35800[(2)] = inst_35710);

(statearr_35760_35800[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (16))){
var inst_35688 = (state_35725[(2)]);
var state_35725__$1 = state_35725;
if(cljs.core.truth_(inst_35688)){
var statearr_35761_35801 = state_35725__$1;
(statearr_35761_35801[(1)] = (17));

} else {
var statearr_35762_35802 = state_35725__$1;
(statearr_35762_35802[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (10))){
var inst_35657 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_35665 = cljs.core.seq(inst_35657);
var inst_35666 = cljs.core.first(inst_35665);
var inst_35667 = cljs.core.next(inst_35665);
var inst_35668 = cljs.core.first(inst_35657);
var inst_35669 = inst_35668.t;
var inst_35670 = cljs.core.PersistentVector.EMPTY;
var inst_35671 = db;
var inst_35672 = inst_35657;
var inst_35673 = inst_35669;
var inst_35674 = inst_35670;
var inst_35675 = inst_35671;
var state_35725__$1 = (function (){var statearr_35763 = state_35725;
(statearr_35763[(7)] = inst_35673);

(statearr_35763[(14)] = inst_35667);

(statearr_35763[(15)] = inst_35666);

(statearr_35763[(8)] = inst_35674);

(statearr_35763[(9)] = inst_35675);

(statearr_35763[(13)] = inst_35672);

return statearr_35763;
})();
var statearr_35764_35803 = state_35725__$1;
(statearr_35764_35803[(2)] = null);

(statearr_35764_35803[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (18))){
var state_35725__$1 = state_35725;
var statearr_35765_35804 = state_35725__$1;
(statearr_35765_35804[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35726 === (8))){
var inst_35651 = (state_35725[(2)]);
var inst_35652 = cljs.core.empty_QMARK_(flakes);
var state_35725__$1 = (function (){var statearr_35767 = state_35725;
(statearr_35767[(16)] = inst_35651);

return statearr_35767;
})();
if(inst_35652){
var statearr_35768_35805 = state_35725__$1;
(statearr_35768_35805[(1)] = (9));

} else {
var statearr_35769_35806 = state_35725__$1;
(statearr_35769_35806[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10798__auto__ = null;
var fluree$db$graphdb$state_machine__10798__auto____0 = (function (){
var statearr_35770 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35770[(0)] = fluree$db$graphdb$state_machine__10798__auto__);

(statearr_35770[(1)] = (1));

return statearr_35770;
});
var fluree$db$graphdb$state_machine__10798__auto____1 = (function (state_35725){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_35725);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e35771){var ex__10801__auto__ = e35771;
var statearr_35772_35807 = state_35725;
(statearr_35772_35807[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_35725[(4)]))){
var statearr_35773_35808 = state_35725;
(statearr_35773_35808[(1)] = cljs.core.first((state_35725[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__35809 = state_35725;
state_35725 = G__35809;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10798__auto__ = function(state_35725){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10798__auto____1.call(this,state_35725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10798__auto____0;
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10798__auto____1;
return fluree$db$graphdb$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_35774 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_35774[(6)] = c__10835__auto___35776);

return statearr_35774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_35865){
var state_val_35866 = (state_35865[(1)]);
if((state_val_35866 === (7))){
var state_35865__$1 = state_35865;
var statearr_35867_35894 = state_35865__$1;
(statearr_35867_35894[(2)] = tt_id);

(statearr_35867_35894[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (1))){
var state_35865__$1 = state_35865;
var statearr_35868_35895 = state_35865__$1;
(statearr_35868_35895[(2)] = null);

(statearr_35868_35895[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (4))){
var inst_35810 = (state_35865[(2)]);
var state_35865__$1 = state_35865;
var statearr_35869_35896 = state_35865__$1;
(statearr_35869_35896[(2)] = inst_35810);

(statearr_35869_35896[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (13))){
var inst_35858 = (state_35865[(2)]);
var state_35865__$1 = state_35865;
var statearr_35870_35897 = state_35865__$1;
(statearr_35870_35897[(2)] = inst_35858);

(statearr_35870_35897[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (6))){
var inst_35818 = fluree.db.util.core.random_uuid();
var state_35865__$1 = state_35865;
var statearr_35871_35898 = state_35865__$1;
(statearr_35871_35898[(2)] = inst_35818);

(statearr_35871_35898[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (3))){
var inst_35863 = (state_35865[(2)]);
var state_35865__$1 = state_35865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35865__$1,inst_35863);
} else {
if((state_val_35866 === (12))){
var inst_35841 = (state_35865[(7)]);
var state_35865__$1 = state_35865;
var statearr_35872_35899 = state_35865__$1;
(statearr_35872_35899[(2)] = inst_35841);

(statearr_35872_35899[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (2))){
var _ = (function (){var statearr_35873 = state_35865;
(statearr_35873[(4)] = cljs.core.cons((5),(state_35865[(4)])));

return statearr_35873;
})();
var inst_35816 = (tt_id == null);
var state_35865__$1 = state_35865;
if(cljs.core.truth_(inst_35816)){
var statearr_35874_35900 = state_35865__$1;
(statearr_35874_35900[(1)] = (6));

} else {
var statearr_35875_35901 = state_35865__$1;
(statearr_35875_35901[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (11))){
var inst_35841 = (state_35865[(7)]);
var inst_35848 = (state_35865[(8)]);
var inst_35851 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_35841,inst_35848);
var state_35865__$1 = state_35865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35865__$1,(14),inst_35851);
} else {
if((state_val_35866 === (9))){
var inst_35842 = (state_35865[(9)]);
var inst_35848 = (state_35865[(8)]);
var inst_35847 = cljs.core.seq(inst_35842);
var inst_35848__$1 = cljs.core.first(inst_35847);
var inst_35849 = cljs.core.next(inst_35847);
var state_35865__$1 = (function (){var statearr_35877 = state_35865;
(statearr_35877[(10)] = inst_35849);

(statearr_35877[(8)] = inst_35848__$1);

return statearr_35877;
})();
if(cljs.core.truth_(inst_35848__$1)){
var statearr_35878_35902 = state_35865__$1;
(statearr_35878_35902[(1)] = (11));

} else {
var statearr_35879_35903 = state_35865__$1;
(statearr_35879_35903[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (5))){
var _ = (function (){var statearr_35880 = state_35865;
(statearr_35880[(4)] = cljs.core.rest((state_35865[(4)])));

return statearr_35880;
})();
var state_35865__$1 = state_35865;
var ex35876 = (state_35865__$1[(2)]);
var statearr_35881_35904 = state_35865__$1;
(statearr_35881_35904[(5)] = ex35876);


if((ex35876 instanceof Error)){
var statearr_35882_35905 = state_35865__$1;
(statearr_35882_35905[(1)] = (4));

(statearr_35882_35905[(5)] = null);

} else {
throw ex35876;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (14))){
var inst_35849 = (state_35865[(10)]);
var inst_35853 = (state_35865[(2)]);
var inst_35854 = fluree.db.util.async.throw_err(inst_35853);
var inst_35841 = inst_35854;
var inst_35842 = inst_35849;
var state_35865__$1 = (function (){var statearr_35883 = state_35865;
(statearr_35883[(9)] = inst_35842);

(statearr_35883[(7)] = inst_35841);

return statearr_35883;
})();
var statearr_35884_35906 = state_35865__$1;
(statearr_35884_35906[(2)] = null);

(statearr_35884_35906[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (10))){
var inst_35860 = (state_35865[(2)]);
var _ = (function (){var statearr_35885 = state_35865;
(statearr_35885[(4)] = cljs.core.rest((state_35865[(4)])));

return statearr_35885;
})();
var state_35865__$1 = state_35865;
var statearr_35886_35907 = state_35865__$1;
(statearr_35886_35907[(2)] = inst_35860);

(statearr_35886_35907[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35866 === (8))){
var inst_35821 = (state_35865[(2)]);
var inst_35822 = (function (){var tt_id_SINGLEQUOTE_ = inst_35821;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_35823 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_35821);
var inst_35824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35825 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_35826 = (new cljs.core.PersistentVector(null,4,(5),inst_35824,inst_35825,null));
var inst_35827 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35822,inst_35823,inst_35826);
var inst_35828 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_35829 = cljs.core.reverse(inst_35828);
var inst_35830 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_35829);
var inst_35838 = cljs.core.seq(inst_35830);
var inst_35839 = cljs.core.first(inst_35838);
var inst_35840 = cljs.core.next(inst_35838);
var inst_35841 = inst_35827;
var inst_35842 = inst_35830;
var state_35865__$1 = (function (){var statearr_35887 = state_35865;
(statearr_35887[(11)] = inst_35839);

(statearr_35887[(9)] = inst_35842);

(statearr_35887[(7)] = inst_35841);

(statearr_35887[(12)] = inst_35840);

return statearr_35887;
})();
var statearr_35888_35908 = state_35865__$1;
(statearr_35888_35908[(2)] = null);

(statearr_35888_35908[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto____0 = (function (){
var statearr_35889 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35889[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto__);

(statearr_35889[(1)] = (1));

return statearr_35889;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto____1 = (function (state_35865){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_35865);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e35890){var ex__10801__auto__ = e35890;
var statearr_35891_35909 = state_35865;
(statearr_35891_35909[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_35865[(4)]))){
var statearr_35892_35910 = state_35865;
(statearr_35892_35910[(1)] = cljs.core.first((state_35865[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__35911 = state_35865;
state_35865 = G__35911;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto__ = function(state_35865){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto____1.call(this,state_35865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_35893 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_35893[(6)] = c__10835__auto__);

return statearr_35893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10835__auto___36098 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36029){
var state_val_36030 = (state_36029[(1)]);
if((state_val_36030 === (7))){
var inst_35939 = (state_36029[(7)]);
var inst_35939__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_36029__$1 = (function (){var statearr_36031 = state_36029;
(statearr_36031[(7)] = inst_35939__$1);

return statearr_36031;
})();
if(inst_35939__$1){
var statearr_36032_36099 = state_36029__$1;
(statearr_36032_36099[(1)] = (13));

} else {
var statearr_36033_36100 = state_36029__$1;
(statearr_36033_36100[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (20))){
var state_36029__$1 = state_36029;
var statearr_36034_36101 = state_36029__$1;
(statearr_36034_36101[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (27))){
var inst_35975 = (state_36029[(8)]);
var inst_35979 = inst_35975.s;
var state_36029__$1 = state_36029;
var statearr_36036_36102 = state_36029__$1;
(statearr_36036_36102[(2)] = inst_35979);

(statearr_36036_36102[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (1))){
var state_36029__$1 = state_36029;
var statearr_36037_36103 = state_36029__$1;
(statearr_36037_36103[(2)] = null);

(statearr_36037_36103[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (24))){
var inst_35969 = (state_36029[(9)]);
var inst_35973 = cljs.core.first(inst_35969);
var state_36029__$1 = state_36029;
var statearr_36038_36104 = state_36029__$1;
(statearr_36038_36104[(2)] = inst_35973);

(statearr_36038_36104[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (39))){
var state_36029__$1 = state_36029;
var statearr_36039_36105 = state_36029__$1;
(statearr_36039_36105[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (4))){
var inst_35912 = (state_36029[(2)]);
var inst_35913 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_35914 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35915 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_35916 = cljs.core.PersistentHashMap.fromArrays(inst_35914,inst_35915);
var inst_35917 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_35913,inst_35916,inst_35912);
var inst_35918 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_35917);
var state_36029__$1 = state_36029;
var statearr_36041_36106 = state_36029__$1;
(statearr_36041_36106[(2)] = inst_35918);

(statearr_36041_36106[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (15))){
var inst_35946 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
if(cljs.core.truth_(inst_35946)){
var statearr_36042_36107 = state_36029__$1;
(statearr_36042_36107[(1)] = (16));

} else {
var statearr_36043_36108 = state_36029__$1;
(statearr_36043_36108[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (21))){
var inst_35995 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
var statearr_36044_36109 = state_36029__$1;
(statearr_36044_36109[(2)] = inst_35995);

(statearr_36044_36109[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (31))){
var inst_35993 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
var statearr_36045_36110 = state_36029__$1;
(statearr_36045_36110[(2)] = inst_35993);

(statearr_36045_36110[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (32))){
var inst_35999 = (state_36029[(10)]);
var inst_36001 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_35999);
var state_36029__$1 = state_36029;
var statearr_36046_36111 = state_36029__$1;
(statearr_36046_36111[(2)] = inst_36001);

(statearr_36046_36111[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (40))){
var inst_36022 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
var statearr_36047_36112 = state_36029__$1;
(statearr_36047_36112[(2)] = inst_36022);

(statearr_36047_36112[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (33))){
var inst_36003 = (state_36029[(11)]);
var inst_35999 = (state_36029[(10)]);
var inst_36003__$1 = (inst_35999 == null);
var state_36029__$1 = (function (){var statearr_36048 = state_36029;
(statearr_36048[(11)] = inst_36003__$1);

return statearr_36048;
})();
if(cljs.core.truth_(inst_36003__$1)){
var statearr_36049_36113 = state_36029__$1;
(statearr_36049_36113[(1)] = (35));

} else {
var statearr_36050_36114 = state_36029__$1;
(statearr_36050_36114[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (13))){
var inst_35941 = cljs.core.first(ident);
var inst_35942 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_35941);
var inst_35943 = (inst_35942 == null);
var state_36029__$1 = state_36029;
var statearr_36051_36115 = state_36029__$1;
(statearr_36051_36115[(2)] = inst_35943);

(statearr_36051_36115[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (22))){
var inst_35969 = (state_36029[(9)]);
var inst_35968 = (state_36029[(2)]);
var inst_35969__$1 = fluree.db.util.async.throw_err(inst_35968);
var inst_35970 = (inst_35969__$1 == null);
var state_36029__$1 = (function (){var statearr_36052 = state_36029;
(statearr_36052[(9)] = inst_35969__$1);

return statearr_36052;
})();
if(cljs.core.truth_(inst_35970)){
var statearr_36053_36116 = state_36029__$1;
(statearr_36053_36116[(1)] = (23));

} else {
var statearr_36054_36117 = state_36029__$1;
(statearr_36054_36117[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (36))){
var inst_36003 = (state_36029[(11)]);
var state_36029__$1 = state_36029;
var statearr_36055_36118 = state_36029__$1;
(statearr_36055_36118[(2)] = inst_36003);

(statearr_36055_36118[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (41))){
var inst_36017 = cljs.core.async.close_BANG_(return_chan);
var state_36029__$1 = state_36029;
var statearr_36056_36119 = state_36029__$1;
(statearr_36056_36119[(2)] = inst_36017);

(statearr_36056_36119[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (43))){
var inst_36020 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
var statearr_36057_36120 = state_36029__$1;
(statearr_36057_36120[(2)] = inst_36020);

(statearr_36057_36120[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (29))){
var inst_35984 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_35985 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_35984].join('');
var inst_35986 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35987 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_35988 = cljs.core.PersistentHashMap.fromArrays(inst_35986,inst_35987);
var inst_35989 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35985,inst_35988);
var inst_35990 = (function(){throw inst_35989})();
var state_36029__$1 = state_36029;
var statearr_36058_36121 = state_36029__$1;
(statearr_36058_36121[(2)] = inst_35990);

(statearr_36058_36121[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (6))){
var inst_35926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35927 = [ident];
var inst_35928 = (new cljs.core.PersistentVector(null,1,(5),inst_35926,inst_35927,null));
var inst_35929 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35928);
var state_36029__$1 = state_36029;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36029__$1,(9),inst_35929);
} else {
if((state_val_36030 === (28))){
var inst_35981 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
var statearr_36059_36122 = state_36029__$1;
(statearr_36059_36122[(2)] = inst_35981);

(statearr_36059_36122[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (25))){
var inst_35975 = (state_36029[(8)]);
var inst_35975__$1 = (state_36029[(2)]);
var inst_35976 = (inst_35975__$1 == null);
var state_36029__$1 = (function (){var statearr_36060 = state_36029;
(statearr_36060[(8)] = inst_35975__$1);

return statearr_36060;
})();
if(cljs.core.truth_(inst_35976)){
var statearr_36061_36123 = state_36029__$1;
(statearr_36061_36123[(1)] = (26));

} else {
var statearr_36062_36124 = state_36029__$1;
(statearr_36062_36124[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (34))){
var inst_36024 = (state_36029[(2)]);
var _ = (function (){var statearr_36063 = state_36029;
(statearr_36063[(4)] = cljs.core.rest((state_36029[(4)])));

return statearr_36063;
})();
var state_36029__$1 = state_36029;
var statearr_36064_36125 = state_36029__$1;
(statearr_36064_36125[(2)] = inst_36024);

(statearr_36064_36125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (17))){
var inst_35957 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_36029__$1 = state_36029;
if(inst_35957){
var statearr_36065_36126 = state_36029__$1;
(statearr_36065_36126[(1)] = (19));

} else {
var statearr_36066_36127 = state_36029__$1;
(statearr_36066_36127[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (3))){
var inst_36027 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36029__$1,inst_36027);
} else {
if((state_val_36030 === (12))){
var inst_35937 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
var statearr_36067_36128 = state_36029__$1;
(statearr_36067_36128[(2)] = inst_35937);

(statearr_36067_36128[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (2))){
var _ = (function (){var statearr_36068 = state_36029;
(statearr_36068[(4)] = cljs.core.cons((5),(state_36029[(4)])));

return statearr_36068;
})();
var inst_35924 = typeof ident === 'number';
var state_36029__$1 = state_36029;
if(cljs.core.truth_(inst_35924)){
var statearr_36069_36129 = state_36029__$1;
(statearr_36069_36129[(1)] = (6));

} else {
var statearr_36070_36130 = state_36029__$1;
(statearr_36070_36130[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (23))){
var state_36029__$1 = state_36029;
var statearr_36071_36131 = state_36029__$1;
(statearr_36071_36131[(2)] = null);

(statearr_36071_36131[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (35))){
var state_36029__$1 = state_36029;
var statearr_36072_36132 = state_36029__$1;
(statearr_36072_36132[(2)] = strict_QMARK_);

(statearr_36072_36132[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (19))){
var inst_35960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35961 = cljs.core.first(ident);
var inst_35962 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_35961);
var inst_35963 = cljs.core.second(ident);
var inst_35964 = [inst_35962,inst_35963];
var inst_35965 = (new cljs.core.PersistentVector(null,2,(5),inst_35960,inst_35964,null));
var inst_35966 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_35965);
var state_36029__$1 = state_36029;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36029__$1,(22),inst_35966);
} else {
if((state_val_36030 === (11))){
var state_36029__$1 = state_36029;
var statearr_36074_36133 = state_36029__$1;
(statearr_36074_36133[(2)] = null);

(statearr_36074_36133[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (9))){
var inst_35931 = (state_36029[(2)]);
var inst_35932 = fluree.db.util.async.throw_err(inst_35931);
var inst_35933 = cljs.core.not_empty(inst_35932);
var state_36029__$1 = state_36029;
if(cljs.core.truth_(inst_35933)){
var statearr_36075_36134 = state_36029__$1;
(statearr_36075_36134[(1)] = (10));

} else {
var statearr_36076_36135 = state_36029__$1;
(statearr_36076_36135[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (5))){
var _ = (function (){var statearr_36077 = state_36029;
(statearr_36077[(4)] = cljs.core.rest((state_36029[(4)])));

return statearr_36077;
})();
var state_36029__$1 = state_36029;
var ex36073 = (state_36029__$1[(2)]);
var statearr_36078_36136 = state_36029__$1;
(statearr_36078_36136[(5)] = ex36073);


var statearr_36079_36137 = state_36029__$1;
(statearr_36079_36137[(1)] = (4));

(statearr_36079_36137[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (14))){
var inst_35939 = (state_36029[(7)]);
var state_36029__$1 = state_36029;
var statearr_36080_36138 = state_36029__$1;
(statearr_36080_36138[(2)] = inst_35939);

(statearr_36080_36138[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (26))){
var state_36029__$1 = state_36029;
var statearr_36081_36139 = state_36029__$1;
(statearr_36081_36139[(2)] = null);

(statearr_36081_36139[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (16))){
var inst_35948 = cljs.core.first(ident);
var inst_35949 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35948], 0));
var inst_35950 = ["Subject ID lookup failed. The predicate ",inst_35949," does not exist."].join('');
var inst_35951 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35952 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_35953 = cljs.core.PersistentHashMap.fromArrays(inst_35951,inst_35952);
var inst_35954 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35950,inst_35953);
var inst_35955 = (function(){throw inst_35954})();
var state_36029__$1 = state_36029;
var statearr_36082_36140 = state_36029__$1;
(statearr_36082_36140[(2)] = inst_35955);

(statearr_36082_36140[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (38))){
var inst_36009 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_36010 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36011 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_36012 = cljs.core.PersistentHashMap.fromArrays(inst_36010,inst_36011);
var inst_36013 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36009,inst_36012);
var inst_36014 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_36013);
var state_36029__$1 = state_36029;
var statearr_36083_36141 = state_36029__$1;
(statearr_36083_36141[(2)] = inst_36014);

(statearr_36083_36141[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (30))){
var state_36029__$1 = state_36029;
var statearr_36084_36142 = state_36029__$1;
(statearr_36084_36142[(2)] = null);

(statearr_36084_36142[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (10))){
var state_36029__$1 = state_36029;
var statearr_36085_36143 = state_36029__$1;
(statearr_36085_36143[(2)] = ident);

(statearr_36085_36143[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (18))){
var inst_35997 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
var statearr_36086_36144 = state_36029__$1;
(statearr_36086_36144[(2)] = inst_35997);

(statearr_36086_36144[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (42))){
var state_36029__$1 = state_36029;
var statearr_36087_36145 = state_36029__$1;
(statearr_36087_36145[(2)] = null);

(statearr_36087_36145[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (37))){
var inst_36007 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
if(cljs.core.truth_(inst_36007)){
var statearr_36088_36146 = state_36029__$1;
(statearr_36088_36146[(1)] = (38));

} else {
var statearr_36089_36147 = state_36029__$1;
(statearr_36089_36147[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (8))){
var inst_35999 = (state_36029[(10)]);
var inst_35999__$1 = (state_36029[(2)]);
var state_36029__$1 = (function (){var statearr_36090 = state_36029;
(statearr_36090[(10)] = inst_35999__$1);

return statearr_36090;
})();
if(cljs.core.truth_(inst_35999__$1)){
var statearr_36091_36148 = state_36029__$1;
(statearr_36091_36148[(1)] = (32));

} else {
var statearr_36092_36149 = state_36029__$1;
(statearr_36092_36149[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__10798__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__10798__auto____0 = (function (){
var statearr_36093 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36093[(0)] = fluree$db$graphdb$subid_$_state_machine__10798__auto__);

(statearr_36093[(1)] = (1));

return statearr_36093;
});
var fluree$db$graphdb$subid_$_state_machine__10798__auto____1 = (function (state_36029){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36029);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36094){var ex__10801__auto__ = e36094;
var statearr_36095_36150 = state_36029;
(statearr_36095_36150[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36029[(4)]))){
var statearr_36096_36151 = state_36029;
(statearr_36096_36151[(1)] = cljs.core.first((state_36029[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36152 = state_36029;
state_36029 = G__36152;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__10798__auto__ = function(state_36029){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__10798__auto____1.call(this,state_36029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__10798__auto____0;
fluree$db$graphdb$subid_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__10798__auto____1;
return fluree$db$graphdb$subid_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36097 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36097[(6)] = c__10835__auto___36098);

return statearr_36097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k36154,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__36158 = k36154;
var G__36158__$1 = (((G__36158 instanceof cljs.core.Keyword))?G__36158.fqn:null);
switch (G__36158__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k36154,else__4475__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__36159){
var vec__36160 = p__36159;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36160,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36160,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36153){
var self__ = this;
var G__36153__$1 = this;
return (new cljs.core.RecordIter((0),G__36153__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__36163 = (function (coll__4469__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__36163(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this36155,other36156){
var self__ = this;
var this36155__$1 = this;
return (((!((other36156 == null)))) && ((((this36155__$1.constructor === other36156.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.conn,other36156.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.network,other36156.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.dbid,other36156.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.block,other36156.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.t,other36156.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.tt_id,other36156.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.stats,other36156.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.spot,other36156.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.psot,other36156.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.post,other36156.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.opst,other36156.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.schema,other36156.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.settings,other36156.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.index_configs,other36156.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.schema_cache,other36156.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.novelty,other36156.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.permissions,other36156.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.fork,other36156.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.fork_block,other36156.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.current_db_fn,other36156.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this36155__$1.__extmap,other36156.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k36154){
var self__ = this;
var this__4479__auto____$1 = this;
var G__36164 = k36154;
var G__36164__$1 = (((G__36164 instanceof cljs.core.Keyword))?G__36164.fqn:null);
switch (G__36164__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k36154);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__36153){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__36165 = cljs.core.keyword_identical_QMARK_;
var expr__36166 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__36168 = cljs.core.cst$kw$conn;
var G__36169 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36168,G__36169) : pred__36165.call(null,G__36168,G__36169));
})())){
return (new fluree.db.graphdb.GraphDb(G__36153,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36170 = cljs.core.cst$kw$network;
var G__36171 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36170,G__36171) : pred__36165.call(null,G__36170,G__36171));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__36153,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36172 = cljs.core.cst$kw$dbid;
var G__36173 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36172,G__36173) : pred__36165.call(null,G__36172,G__36173));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__36153,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36174 = cljs.core.cst$kw$block;
var G__36175 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36174,G__36175) : pred__36165.call(null,G__36174,G__36175));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__36153,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36176 = cljs.core.cst$kw$t;
var G__36177 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36176,G__36177) : pred__36165.call(null,G__36176,G__36177));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__36153,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36178 = cljs.core.cst$kw$tt_DASH_id;
var G__36179 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36178,G__36179) : pred__36165.call(null,G__36178,G__36179));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__36153,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36180 = cljs.core.cst$kw$stats;
var G__36181 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36180,G__36181) : pred__36165.call(null,G__36180,G__36181));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__36153,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36182 = cljs.core.cst$kw$spot;
var G__36183 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36182,G__36183) : pred__36165.call(null,G__36182,G__36183));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__36153,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36184 = cljs.core.cst$kw$psot;
var G__36185 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36184,G__36185) : pred__36165.call(null,G__36184,G__36185));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__36153,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36186 = cljs.core.cst$kw$post;
var G__36187 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36186,G__36187) : pred__36165.call(null,G__36186,G__36187));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__36153,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36188 = cljs.core.cst$kw$opst;
var G__36189 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36188,G__36189) : pred__36165.call(null,G__36188,G__36189));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__36153,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36190 = cljs.core.cst$kw$schema;
var G__36191 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36190,G__36191) : pred__36165.call(null,G__36190,G__36191));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__36153,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36192 = cljs.core.cst$kw$settings;
var G__36193 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36192,G__36193) : pred__36165.call(null,G__36192,G__36193));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__36153,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36194 = cljs.core.cst$kw$index_DASH_configs;
var G__36195 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36194,G__36195) : pred__36165.call(null,G__36194,G__36195));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__36153,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36196 = cljs.core.cst$kw$schema_DASH_cache;
var G__36197 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36196,G__36197) : pred__36165.call(null,G__36196,G__36197));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__36153,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36198 = cljs.core.cst$kw$novelty;
var G__36199 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36198,G__36199) : pred__36165.call(null,G__36198,G__36199));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__36153,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36200 = cljs.core.cst$kw$permissions;
var G__36201 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36200,G__36201) : pred__36165.call(null,G__36200,G__36201));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__36153,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36202 = cljs.core.cst$kw$fork;
var G__36203 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36202,G__36203) : pred__36165.call(null,G__36202,G__36203));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__36153,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36204 = cljs.core.cst$kw$fork_DASH_block;
var G__36205 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36204,G__36205) : pred__36165.call(null,G__36204,G__36205));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__36153,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__36206 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__36207 = expr__36166;
return (pred__36165.cljs$core$IFn$_invoke$arity$2 ? pred__36165.cljs$core$IFn$_invoke$arity$2(G__36206,G__36207) : pred__36165.call(null,G__36206,G__36207));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__36153,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__36153),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__36153){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__36153,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36223){
var state_val_36224 = (state_36223[(1)]);
if((state_val_36224 === (1))){
var state_36223__$1 = state_36223;
var statearr_36225_36492 = state_36223__$1;
(statearr_36225_36492[(2)] = null);

(statearr_36225_36492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36224 === (2))){
var _ = (function (){var statearr_36226 = state_36223;
(statearr_36226[(4)] = cljs.core.cons((5),(state_36223[(4)])));

return statearr_36226;
})();
var inst_36214 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_36223__$1 = state_36223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36223__$1,(6),inst_36214);
} else {
if((state_val_36224 === (3))){
var inst_36221 = (state_36223[(2)]);
var state_36223__$1 = state_36223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36223__$1,inst_36221);
} else {
if((state_val_36224 === (4))){
var inst_36208 = (state_36223[(2)]);
var state_36223__$1 = state_36223;
var statearr_36228_36493 = state_36223__$1;
(statearr_36228_36493[(2)] = inst_36208);

(statearr_36228_36493[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36224 === (5))){
var _ = (function (){var statearr_36229 = state_36223;
(statearr_36229[(4)] = cljs.core.rest((state_36223[(4)])));

return statearr_36229;
})();
var state_36223__$1 = state_36223;
var ex36227 = (state_36223__$1[(2)]);
var statearr_36230_36494 = state_36223__$1;
(statearr_36230_36494[(5)] = ex36227);


if((ex36227 instanceof Error)){
var statearr_36231_36495 = state_36223__$1;
(statearr_36231_36495[(1)] = (4));

(statearr_36231_36495[(5)] = null);

} else {
throw ex36227;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36224 === (6))){
var inst_36216 = (state_36223[(2)]);
var inst_36217 = fluree.db.util.async.throw_err(inst_36216);
var inst_36218 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36217,cljs.core.cst$kw$permissions,self__.permissions);
var _ = (function (){var statearr_36232 = state_36223;
(statearr_36232[(4)] = cljs.core.rest((state_36223[(4)])));

return statearr_36232;
})();
var state_36223__$1 = state_36223;
var statearr_36233_36496 = state_36223__$1;
(statearr_36233_36496[(2)] = inst_36218);

(statearr_36233_36496[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10798__auto__ = null;
var fluree$db$graphdb$state_machine__10798__auto____0 = (function (){
var statearr_36234 = [null,null,null,null,null,null,null];
(statearr_36234[(0)] = fluree$db$graphdb$state_machine__10798__auto__);

(statearr_36234[(1)] = (1));

return statearr_36234;
});
var fluree$db$graphdb$state_machine__10798__auto____1 = (function (state_36223){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36223);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36235){var ex__10801__auto__ = e36235;
var statearr_36236_36497 = state_36223;
(statearr_36236_36497[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36223[(4)]))){
var statearr_36237_36498 = state_36223;
(statearr_36237_36498[(1)] = cljs.core.first((state_36223[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36499 = state_36223;
state_36223 = G__36499;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10798__auto__ = function(state_36223){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10798__auto____1.call(this,state_36223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10798__auto____0;
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10798__auto____1;
return fluree$db$graphdb$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36238 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36238[(6)] = c__10835__auto__);

return statearr_36238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__36239 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__36239.cljs$core$IFn$_invoke$arity$1 ? fexpr__36239.cljs$core$IFn$_invoke$arity$1(property) : fexpr__36239.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__36240 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__36240.cljs$core$IFn$_invoke$arity$1 ? fexpr__36240.cljs$core$IFn$_invoke$arity$1(property) : fexpr__36240.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__36241 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$partition,G__36241);
} else {
return G__36241;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36273){
var state_val_36274 = (state_36273[(1)]);
if((state_val_36274 === (7))){
var state_36273__$1 = state_36273;
var statearr_36275_36500 = state_36273__$1;
(statearr_36275_36500[(2)] = null);

(statearr_36275_36500[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36274 === (1))){
var state_36273__$1 = state_36273;
var statearr_36276_36501 = state_36273__$1;
(statearr_36276_36501[(2)] = null);

(statearr_36276_36501[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36274 === (4))){
var inst_36242 = (state_36273[(2)]);
var state_36273__$1 = state_36273;
var statearr_36277_36502 = state_36273__$1;
(statearr_36277_36502[(2)] = inst_36242);

(statearr_36277_36502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36274 === (6))){
var inst_36256 = (state_36273[(7)]);
var inst_36255 = (state_36273[(2)]);
var inst_36256__$1 = fluree.db.util.async.throw_err(inst_36255);
var inst_36257 = (inst_36256__$1 == null);
var state_36273__$1 = (function (){var statearr_36278 = state_36273;
(statearr_36278[(7)] = inst_36256__$1);

return statearr_36278;
})();
if(cljs.core.truth_(inst_36257)){
var statearr_36279_36503 = state_36273__$1;
(statearr_36279_36503[(1)] = (7));

} else {
var statearr_36280_36504 = state_36273__$1;
(statearr_36280_36504[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36274 === (3))){
var inst_36271 = (state_36273[(2)]);
var state_36273__$1 = state_36273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36273__$1,inst_36271);
} else {
if((state_val_36274 === (12))){
var inst_36268 = (state_36273[(2)]);
var _ = (function (){var statearr_36281 = state_36273;
(statearr_36281[(4)] = cljs.core.rest((state_36273[(4)])));

return statearr_36281;
})();
var state_36273__$1 = state_36273;
var statearr_36282_36505 = state_36273__$1;
(statearr_36282_36505[(2)] = inst_36268);

(statearr_36282_36505[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36274 === (2))){
var _ = (function (){var statearr_36283 = state_36273;
(statearr_36283[(4)] = cljs.core.cons((5),(state_36273[(4)])));

return statearr_36283;
})();
var inst_36249 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_36250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36251 = [tag_id,(30)];
var inst_36252 = (new cljs.core.PersistentVector(null,2,(5),inst_36250,inst_36251,null));
var inst_36253 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_36249,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36252);
var state_36273__$1 = state_36273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36273__$1,(6),inst_36253);
} else {
if((state_val_36274 === (11))){
var inst_36262 = (state_36273[(8)]);
var inst_36266 = inst_36262.o;
var state_36273__$1 = state_36273;
var statearr_36285_36506 = state_36273__$1;
(statearr_36285_36506[(2)] = inst_36266);

(statearr_36285_36506[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36274 === (9))){
var inst_36262 = (state_36273[(8)]);
var inst_36262__$1 = (state_36273[(2)]);
var inst_36263 = (inst_36262__$1 == null);
var state_36273__$1 = (function (){var statearr_36286 = state_36273;
(statearr_36286[(8)] = inst_36262__$1);

return statearr_36286;
})();
if(cljs.core.truth_(inst_36263)){
var statearr_36287_36507 = state_36273__$1;
(statearr_36287_36507[(1)] = (10));

} else {
var statearr_36288_36508 = state_36273__$1;
(statearr_36288_36508[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36274 === (5))){
var _ = (function (){var statearr_36289 = state_36273;
(statearr_36289[(4)] = cljs.core.rest((state_36273[(4)])));

return statearr_36289;
})();
var state_36273__$1 = state_36273;
var ex36284 = (state_36273__$1[(2)]);
var statearr_36290_36509 = state_36273__$1;
(statearr_36290_36509[(5)] = ex36284);


if((ex36284 instanceof Error)){
var statearr_36291_36510 = state_36273__$1;
(statearr_36291_36510[(1)] = (4));

(statearr_36291_36510[(5)] = null);

} else {
throw ex36284;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36274 === (10))){
var state_36273__$1 = state_36273;
var statearr_36292_36511 = state_36273__$1;
(statearr_36292_36511[(2)] = null);

(statearr_36292_36511[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36274 === (8))){
var inst_36256 = (state_36273[(7)]);
var inst_36260 = cljs.core.first(inst_36256);
var state_36273__$1 = state_36273;
var statearr_36293_36512 = state_36273__$1;
(statearr_36293_36512[(2)] = inst_36260);

(statearr_36293_36512[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10798__auto__ = null;
var fluree$db$graphdb$state_machine__10798__auto____0 = (function (){
var statearr_36294 = [null,null,null,null,null,null,null,null,null];
(statearr_36294[(0)] = fluree$db$graphdb$state_machine__10798__auto__);

(statearr_36294[(1)] = (1));

return statearr_36294;
});
var fluree$db$graphdb$state_machine__10798__auto____1 = (function (state_36273){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36273);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36295){var ex__10801__auto__ = e36295;
var statearr_36296_36513 = state_36273;
(statearr_36296_36513[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36273[(4)]))){
var statearr_36297_36514 = state_36273;
(statearr_36297_36514[(1)] = cljs.core.first((state_36273[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36515 = state_36273;
state_36273 = G__36515;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10798__auto__ = function(state_36273){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10798__auto____1.call(this,state_36273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10798__auto____0;
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10798__auto____1;
return fluree$db$graphdb$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36298 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36298[(6)] = c__10835__auto__);

return statearr_36298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36334){
var state_val_36335 = (state_36334[(1)]);
if((state_val_36335 === (7))){
var inst_36308 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_36334__$1 = state_36334;
var statearr_36336_36516 = state_36334__$1;
(statearr_36336_36516[(2)] = inst_36308);

(statearr_36336_36516[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (1))){
var state_36334__$1 = state_36334;
var statearr_36337_36517 = state_36334__$1;
(statearr_36337_36517[(2)] = null);

(statearr_36337_36517[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (4))){
var inst_36299 = (state_36334[(2)]);
var state_36334__$1 = state_36334;
var statearr_36338_36518 = state_36334__$1;
(statearr_36338_36518[(2)] = inst_36299);

(statearr_36338_36518[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (15))){
var inst_36329 = (state_36334[(2)]);
var _ = (function (){var statearr_36339 = state_36334;
(statearr_36339[(4)] = cljs.core.rest((state_36334[(4)])));

return statearr_36339;
})();
var state_36334__$1 = state_36334;
var statearr_36340_36519 = state_36334__$1;
(statearr_36340_36519[(2)] = inst_36329);

(statearr_36340_36519[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (13))){
var inst_36314 = (state_36334[(7)]);
var inst_36320 = clojure.string.includes_QMARK_(inst_36314,":");
var state_36334__$1 = state_36334;
if(inst_36320){
var statearr_36341_36520 = state_36334__$1;
(statearr_36341_36520[(1)] = (16));

} else {
var statearr_36342_36521 = state_36334__$1;
(statearr_36342_36521[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (6))){
var state_36334__$1 = state_36334;
var statearr_36343_36522 = state_36334__$1;
(statearr_36343_36522[(2)] = pred);

(statearr_36343_36522[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (17))){
var inst_36314 = (state_36334[(7)]);
var state_36334__$1 = state_36334;
var statearr_36344_36523 = state_36334__$1;
(statearr_36344_36523[(2)] = inst_36314);

(statearr_36344_36523[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (3))){
var inst_36332 = (state_36334[(2)]);
var state_36334__$1 = state_36334;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36334__$1,inst_36332);
} else {
if((state_val_36335 === (12))){
var inst_36318 = (state_36334[(2)]);
var state_36334__$1 = state_36334;
if(cljs.core.truth_(inst_36318)){
var statearr_36345_36524 = state_36334__$1;
(statearr_36345_36524[(1)] = (13));

} else {
var statearr_36346_36525 = state_36334__$1;
(statearr_36346_36525[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (2))){
var _ = (function (){var statearr_36347 = state_36334;
(statearr_36347[(4)] = cljs.core.cons((5),(state_36334[(4)])));

return statearr_36347;
})();
var inst_36305 = typeof pred === 'string';
var state_36334__$1 = state_36334;
if(cljs.core.truth_(inst_36305)){
var statearr_36348_36526 = state_36334__$1;
(statearr_36348_36526[(1)] = (6));

} else {
var statearr_36349_36527 = state_36334__$1;
(statearr_36349_36527[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (11))){
var inst_36310 = (state_36334[(8)]);
var state_36334__$1 = state_36334;
var statearr_36351_36528 = state_36334__$1;
(statearr_36351_36528[(2)] = inst_36310);

(statearr_36351_36528[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (9))){
var inst_36310 = (state_36334[(8)]);
var inst_36313 = (state_36334[(2)]);
var inst_36314 = fluree.db.util.async.throw_err(inst_36313);
var state_36334__$1 = (function (){var statearr_36352 = state_36334;
(statearr_36352[(7)] = inst_36314);

return statearr_36352;
})();
if(cljs.core.truth_(inst_36310)){
var statearr_36353_36529 = state_36334__$1;
(statearr_36353_36529[(1)] = (10));

} else {
var statearr_36354_36530 = state_36334__$1;
(statearr_36354_36530[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (5))){
var _ = (function (){var statearr_36355 = state_36334;
(statearr_36355[(4)] = cljs.core.rest((state_36334[(4)])));

return statearr_36355;
})();
var state_36334__$1 = state_36334;
var ex36350 = (state_36334__$1[(2)]);
var statearr_36356_36531 = state_36334__$1;
(statearr_36356_36531[(5)] = ex36350);


if((ex36350 instanceof Error)){
var statearr_36357_36532 = state_36334__$1;
(statearr_36357_36532[(1)] = (4));

(statearr_36357_36532[(5)] = null);

} else {
throw ex36350;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (14))){
var state_36334__$1 = state_36334;
var statearr_36358_36533 = state_36334__$1;
(statearr_36358_36533[(2)] = null);

(statearr_36358_36533[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (16))){
var inst_36314 = (state_36334[(7)]);
var inst_36322 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_36314,/:/);
var inst_36323 = cljs.core.second(inst_36322);
var state_36334__$1 = state_36334;
var statearr_36359_36534 = state_36334__$1;
(statearr_36359_36534[(2)] = inst_36323);

(statearr_36359_36534[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (10))){
var inst_36314 = (state_36334[(7)]);
var state_36334__$1 = state_36334;
var statearr_36360_36535 = state_36334__$1;
(statearr_36360_36535[(2)] = inst_36314);

(statearr_36360_36535[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (18))){
var inst_36326 = (state_36334[(2)]);
var state_36334__$1 = state_36334;
var statearr_36361_36536 = state_36334__$1;
(statearr_36361_36536[(2)] = inst_36326);

(statearr_36361_36536[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36335 === (8))){
var inst_36310 = (state_36334[(2)]);
var inst_36311 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_36334__$1 = (function (){var statearr_36362 = state_36334;
(statearr_36362[(8)] = inst_36310);

return statearr_36362;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36334__$1,(9),inst_36311);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10798__auto__ = null;
var fluree$db$graphdb$state_machine__10798__auto____0 = (function (){
var statearr_36363 = [null,null,null,null,null,null,null,null,null];
(statearr_36363[(0)] = fluree$db$graphdb$state_machine__10798__auto__);

(statearr_36363[(1)] = (1));

return statearr_36363;
});
var fluree$db$graphdb$state_machine__10798__auto____1 = (function (state_36334){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36334);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36364){var ex__10801__auto__ = e36364;
var statearr_36365_36537 = state_36334;
(statearr_36365_36537[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36334[(4)]))){
var statearr_36366_36538 = state_36334;
(statearr_36366_36538[(1)] = cljs.core.first((state_36334[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36539 = state_36334;
state_36334 = G__36539;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10798__auto__ = function(state_36334){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10798__auto____1.call(this,state_36334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10798__auto____0;
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10798__auto____1;
return fluree$db$graphdb$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36367 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36367[(6)] = c__10835__auto__);

return statearr_36367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36400){
var state_val_36401 = (state_36400[(1)]);
if((state_val_36401 === (7))){
var state_36400__$1 = state_36400;
var statearr_36402_36540 = state_36400__$1;
(statearr_36402_36540[(2)] = null);

(statearr_36402_36540[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (1))){
var state_36400__$1 = state_36400;
var statearr_36403_36541 = state_36400__$1;
(statearr_36403_36541[(2)] = null);

(statearr_36403_36541[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (4))){
var inst_36368 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36404_36542 = state_36400__$1;
(statearr_36404_36542[(2)] = inst_36368);

(statearr_36404_36542[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (6))){
var inst_36383 = (state_36400[(7)]);
var inst_36382 = (state_36400[(2)]);
var inst_36383__$1 = fluree.db.util.async.throw_err(inst_36382);
var inst_36384 = (inst_36383__$1 == null);
var state_36400__$1 = (function (){var statearr_36405 = state_36400;
(statearr_36405[(7)] = inst_36383__$1);

return statearr_36405;
})();
if(cljs.core.truth_(inst_36384)){
var statearr_36406_36543 = state_36400__$1;
(statearr_36406_36543[(1)] = (7));

} else {
var statearr_36407_36544 = state_36400__$1;
(statearr_36407_36544[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (3))){
var inst_36398 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36400__$1,inst_36398);
} else {
if((state_val_36401 === (12))){
var inst_36395 = (state_36400[(2)]);
var _ = (function (){var statearr_36408 = state_36400;
(statearr_36408[(4)] = cljs.core.rest((state_36400[(4)])));

return statearr_36408;
})();
var state_36400__$1 = state_36400;
var statearr_36409_36545 = state_36400__$1;
(statearr_36409_36545[(2)] = inst_36395);

(statearr_36409_36545[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (2))){
var _ = (function (){var statearr_36410 = state_36400;
(statearr_36410[(4)] = cljs.core.cons((5),(state_36400[(4)])));

return statearr_36410;
})();
var inst_36374 = (30);
var inst_36376 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_36377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36378 = [inst_36374,tag_name];
var inst_36379 = (new cljs.core.PersistentVector(null,2,(5),inst_36377,inst_36378,null));
var inst_36380 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_36376,cljs.core.cst$kw$post,cljs.core._EQ_,inst_36379);
var state_36400__$1 = state_36400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36400__$1,(6),inst_36380);
} else {
if((state_val_36401 === (11))){
var inst_36389 = (state_36400[(8)]);
var inst_36393 = inst_36389.s;
var state_36400__$1 = state_36400;
var statearr_36412_36546 = state_36400__$1;
(statearr_36412_36546[(2)] = inst_36393);

(statearr_36412_36546[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (9))){
var inst_36389 = (state_36400[(8)]);
var inst_36389__$1 = (state_36400[(2)]);
var inst_36390 = (inst_36389__$1 == null);
var state_36400__$1 = (function (){var statearr_36413 = state_36400;
(statearr_36413[(8)] = inst_36389__$1);

return statearr_36413;
})();
if(cljs.core.truth_(inst_36390)){
var statearr_36414_36547 = state_36400__$1;
(statearr_36414_36547[(1)] = (10));

} else {
var statearr_36415_36548 = state_36400__$1;
(statearr_36415_36548[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (5))){
var _ = (function (){var statearr_36416 = state_36400;
(statearr_36416[(4)] = cljs.core.rest((state_36400[(4)])));

return statearr_36416;
})();
var state_36400__$1 = state_36400;
var ex36411 = (state_36400__$1[(2)]);
var statearr_36417_36549 = state_36400__$1;
(statearr_36417_36549[(5)] = ex36411);


if((ex36411 instanceof Error)){
var statearr_36418_36550 = state_36400__$1;
(statearr_36418_36550[(1)] = (4));

(statearr_36418_36550[(5)] = null);

} else {
throw ex36411;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (10))){
var state_36400__$1 = state_36400;
var statearr_36419_36551 = state_36400__$1;
(statearr_36419_36551[(2)] = null);

(statearr_36419_36551[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (8))){
var inst_36383 = (state_36400[(7)]);
var inst_36387 = cljs.core.first(inst_36383);
var state_36400__$1 = state_36400;
var statearr_36420_36552 = state_36400__$1;
(statearr_36420_36552[(2)] = inst_36387);

(statearr_36420_36552[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10798__auto__ = null;
var fluree$db$graphdb$state_machine__10798__auto____0 = (function (){
var statearr_36421 = [null,null,null,null,null,null,null,null,null];
(statearr_36421[(0)] = fluree$db$graphdb$state_machine__10798__auto__);

(statearr_36421[(1)] = (1));

return statearr_36421;
});
var fluree$db$graphdb$state_machine__10798__auto____1 = (function (state_36400){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36400);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36422){var ex__10801__auto__ = e36422;
var statearr_36423_36553 = state_36400;
(statearr_36423_36553[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36400[(4)]))){
var statearr_36424_36554 = state_36400;
(statearr_36424_36554[(1)] = cljs.core.first((state_36400[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36555 = state_36400;
state_36400 = G__36555;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10798__auto__ = function(state_36400){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10798__auto____1.call(this,state_36400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10798__auto____0;
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10798__auto____1;
return fluree$db$graphdb$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36425 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36425[(6)] = c__10835__auto__);

return statearr_36425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_36460){
var state_val_36461 = (state_36460[(1)]);
if((state_val_36461 === (7))){
var inst_36439 = typeof pred === 'string';
var state_36460__$1 = state_36460;
if(cljs.core.truth_(inst_36439)){
var statearr_36462_36556 = state_36460__$1;
(statearr_36462_36556[(1)] = (10));

} else {
var statearr_36463_36557 = state_36460__$1;
(statearr_36463_36557[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (1))){
var state_36460__$1 = state_36460;
var statearr_36464_36558 = state_36460__$1;
(statearr_36464_36558[(2)] = null);

(statearr_36464_36558[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (4))){
var inst_36426 = (state_36460[(2)]);
var state_36460__$1 = state_36460;
var statearr_36465_36559 = state_36460__$1;
(statearr_36465_36559[(2)] = inst_36426);

(statearr_36465_36559[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (15))){
var inst_36453 = (state_36460[(2)]);
var state_36460__$1 = state_36460;
var statearr_36466_36560 = state_36460__$1;
(statearr_36466_36560[(2)] = inst_36453);

(statearr_36466_36560[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (13))){
var inst_36444 = (state_36460[(7)]);
var inst_36446 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36444),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_36447 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_36446);
var state_36460__$1 = state_36460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36460__$1,(16),inst_36447);
} else {
if((state_val_36461 === (6))){
var inst_36434 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_36460__$1 = state_36460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36460__$1,(9),inst_36434);
} else {
if((state_val_36461 === (3))){
var inst_36458 = (state_36460[(2)]);
var state_36460__$1 = state_36460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36460__$1,inst_36458);
} else {
if((state_val_36461 === (12))){
var inst_36444 = (state_36460[(7)]);
var inst_36444__$1 = (state_36460[(2)]);
var state_36460__$1 = (function (){var statearr_36467 = state_36460;
(statearr_36467[(7)] = inst_36444__$1);

return statearr_36467;
})();
if(cljs.core.truth_(inst_36444__$1)){
var statearr_36468_36561 = state_36460__$1;
(statearr_36468_36561[(1)] = (13));

} else {
var statearr_36469_36562 = state_36460__$1;
(statearr_36469_36562[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (2))){
var _ = (function (){var statearr_36470 = state_36460;
(statearr_36470[(4)] = cljs.core.cons((5),(state_36460[(4)])));

return statearr_36470;
})();
var inst_36432 = clojure.string.includes_QMARK_(tag_name,"/");
var state_36460__$1 = state_36460;
if(inst_36432){
var statearr_36471_36563 = state_36460__$1;
(statearr_36471_36563[(1)] = (6));

} else {
var statearr_36472_36564 = state_36460__$1;
(statearr_36472_36564[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (11))){
var inst_36442 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_36460__$1 = state_36460;
var statearr_36474_36565 = state_36460__$1;
(statearr_36474_36565[(2)] = inst_36442);

(statearr_36474_36565[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (9))){
var inst_36436 = (state_36460[(2)]);
var inst_36437 = fluree.db.util.async.throw_err(inst_36436);
var state_36460__$1 = state_36460;
var statearr_36475_36566 = state_36460__$1;
(statearr_36475_36566[(2)] = inst_36437);

(statearr_36475_36566[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (5))){
var _ = (function (){var statearr_36476 = state_36460;
(statearr_36476[(4)] = cljs.core.rest((state_36460[(4)])));

return statearr_36476;
})();
var state_36460__$1 = state_36460;
var ex36473 = (state_36460__$1[(2)]);
var statearr_36477_36567 = state_36460__$1;
(statearr_36477_36567[(5)] = ex36473);


if((ex36473 instanceof Error)){
var statearr_36478_36568 = state_36460__$1;
(statearr_36478_36568[(1)] = (4));

(statearr_36478_36568[(5)] = null);

} else {
throw ex36473;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (14))){
var state_36460__$1 = state_36460;
var statearr_36479_36569 = state_36460__$1;
(statearr_36479_36569[(2)] = null);

(statearr_36479_36569[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (16))){
var inst_36449 = (state_36460[(2)]);
var inst_36450 = fluree.db.util.async.throw_err(inst_36449);
var state_36460__$1 = state_36460;
var statearr_36480_36570 = state_36460__$1;
(statearr_36480_36570[(2)] = inst_36450);

(statearr_36480_36570[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (10))){
var state_36460__$1 = state_36460;
var statearr_36481_36571 = state_36460__$1;
(statearr_36481_36571[(2)] = pred);

(statearr_36481_36571[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36461 === (8))){
var inst_36455 = (state_36460[(2)]);
var _ = (function (){var statearr_36482 = state_36460;
(statearr_36482[(4)] = cljs.core.rest((state_36460[(4)])));

return statearr_36482;
})();
var state_36460__$1 = state_36460;
var statearr_36483_36572 = state_36460__$1;
(statearr_36483_36572[(2)] = inst_36455);

(statearr_36483_36572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10798__auto__ = null;
var fluree$db$graphdb$state_machine__10798__auto____0 = (function (){
var statearr_36484 = [null,null,null,null,null,null,null,null];
(statearr_36484[(0)] = fluree$db$graphdb$state_machine__10798__auto__);

(statearr_36484[(1)] = (1));

return statearr_36484;
});
var fluree$db$graphdb$state_machine__10798__auto____1 = (function (state_36460){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_36460);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e36485){var ex__10801__auto__ = e36485;
var statearr_36486_36573 = state_36460;
(statearr_36486_36573[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_36460[(4)]))){
var statearr_36487_36574 = state_36460;
(statearr_36487_36574[(1)] = cljs.core.first((state_36460[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__36575 = state_36460;
state_36460 = G__36575;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10798__auto__ = function(state_36460){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10798__auto____1.call(this,state_36460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10798__auto____0;
fluree$db$graphdb$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10798__auto____1;
return fluree$db$graphdb$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_36488 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_36488[(6)] = c__10835__auto__);

return statearr_36488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__36157){
var extmap__4512__auto__ = (function (){var G__36489 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__36157,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__36157)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__36489);
} else {
return G__36489;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__36157),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__36157),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
