// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39089 = arguments.length;
var i__4830__auto___39090 = (0);
while(true){
if((i__4830__auto___39090 < len__4829__auto___39089)){
args__4835__auto__.push((arguments[i__4830__auto___39090]));

var G__39091 = (i__4830__auto___39090 + (1));
i__4830__auto___39090 = G__39091;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq39086){
var G__39087 = cljs.core.first(seq39086);
var seq39086__$1 = cljs.core.next(seq39086);
var G__39088 = cljs.core.first(seq39086__$1);
var seq39086__$2 = cljs.core.next(seq39086__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39087,G__39088,seq39086__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e39092){var e = e39092;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e39093){var e = e39093;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e39094){var e = e39094;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e39095){var e = e39095;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e39096){var e = e39096;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39099 = arguments.length;
var i__4830__auto___39100 = (0);
while(true){
if((i__4830__auto___39100 < len__4829__auto___39099)){
args__4835__auto__.push((arguments[i__4830__auto___39100]));

var G__39101 = (i__4830__auto___39100 + (1));
i__4830__auto___39100 = G__39101;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e39098){var e = e39098;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq39097){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39097));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39104 = arguments.length;
var i__4830__auto___39105 = (0);
while(true){
if((i__4830__auto___39105 < len__4829__auto___39104)){
args__4835__auto__.push((arguments[i__4830__auto___39105]));

var G__39106 = (i__4830__auto___39105 + (1));
i__4830__auto___39105 = G__39106;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e39103){var e = e39103;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq39102){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39102));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e39107){var e = e39107;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39110 = arguments.length;
var i__4830__auto___39111 = (0);
while(true){
if((i__4830__auto___39111 < len__4829__auto___39110)){
args__4835__auto__.push((arguments[i__4830__auto___39111]));

var G__39112 = (i__4830__auto___39111 + (1));
i__4830__auto___39111 = G__39112;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e39109){var e = e39109;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq39108){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39108));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39115 = arguments.length;
var i__4830__auto___39116 = (0);
while(true){
if((i__4830__auto___39116 < len__4829__auto___39115)){
args__4835__auto__.push((arguments[i__4830__auto___39116]));

var G__39117 = (i__4830__auto___39116 + (1));
i__4830__auto___39116 = G__39117;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e39114){var e = e39114;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq39113){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39113));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e39118){var e = e39118;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e39119){var e = e39119;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39122 = arguments.length;
var i__4830__auto___39123 = (0);
while(true){
if((i__4830__auto___39123 < len__4829__auto___39122)){
args__4835__auto__.push((arguments[i__4830__auto___39123]));

var G__39124 = (i__4830__auto___39123 + (1));
i__4830__auto___39123 = G__39124;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e39121){var e = e39121;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq39120){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39120));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39127 = arguments.length;
var i__4830__auto___39128 = (0);
while(true){
if((i__4830__auto___39128 < len__4829__auto___39127)){
args__4835__auto__.push((arguments[i__4830__auto___39128]));

var G__39129 = (i__4830__auto___39128 + (1));
i__4830__auto___39128 = G__39129;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e39126){var e = e39126;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq39125){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39125));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39132 = arguments.length;
var i__4830__auto___39133 = (0);
while(true){
if((i__4830__auto___39133 < len__4829__auto___39132)){
args__4835__auto__.push((arguments[i__4830__auto___39133]));

var G__39134 = (i__4830__auto___39133 + (1));
i__4830__auto___39133 = G__39134;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e39131){var e = e39131;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq39130){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39130));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39137 = arguments.length;
var i__4830__auto___39138 = (0);
while(true){
if((i__4830__auto___39138 < len__4829__auto___39137)){
args__4835__auto__.push((arguments[i__4830__auto___39138]));

var G__39139 = (i__4830__auto___39138 + (1));
i__4830__auto___39138 = G__39139;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e39136){var e = e39136;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq39135){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39135));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39142 = arguments.length;
var i__4830__auto___39143 = (0);
while(true){
if((i__4830__auto___39143 < len__4829__auto___39142)){
args__4835__auto__.push((arguments[i__4830__auto___39143]));

var G__39144 = (i__4830__auto___39143 + (1));
i__4830__auto___39143 = G__39144;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e39141){var e = e39141;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq39140){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39140));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39147 = arguments.length;
var i__4830__auto___39148 = (0);
while(true){
if((i__4830__auto___39148 < len__4829__auto___39147)){
args__4835__auto__.push((arguments[i__4830__auto___39148]));

var G__39149 = (i__4830__auto___39148 + (1));
i__4830__auto___39148 = G__39149;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e39146){var e = e39146;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq39145){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39145));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39152 = arguments.length;
var i__4830__auto___39153 = (0);
while(true){
if((i__4830__auto___39153 < len__4829__auto___39152)){
args__4835__auto__.push((arguments[i__4830__auto___39153]));

var G__39154 = (i__4830__auto___39153 + (1));
i__4830__auto___39153 = G__39154;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e39151){var e = e39151;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq39150){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39150));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__39156 = arguments.length;
switch (G__39156) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_39184){
var state_val_39185 = (state_39184[(1)]);
if((state_val_39185 === (7))){
var inst_39169 = (state_39184[(7)]);
var inst_39172 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39169,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_39184__$1 = state_39184;
var statearr_39186_39272 = state_39184__$1;
(statearr_39186_39272[(2)] = inst_39172);

(statearr_39186_39272[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (1))){
var state_39184__$1 = state_39184;
var statearr_39187_39273 = state_39184__$1;
(statearr_39187_39273[(2)] = null);

(statearr_39187_39273[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (4))){
var inst_39157 = (state_39184[(2)]);
var state_39184__$1 = state_39184;
var statearr_39188_39274 = state_39184__$1;
(statearr_39188_39274[(2)] = inst_39157);

(statearr_39188_39274[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (6))){
var inst_39169 = (state_39184[(7)]);
var inst_39169__$1 = (state_39184[(2)]);
var inst_39170 = fluree.db.util.core.exception_QMARK_(inst_39169__$1);
var state_39184__$1 = (function (){var statearr_39189 = state_39184;
(statearr_39189[(7)] = inst_39169__$1);

return statearr_39189;
})();
if(inst_39170){
var statearr_39190_39275 = state_39184__$1;
(statearr_39190_39275[(1)] = (7));

} else {
var statearr_39191_39276 = state_39184__$1;
(statearr_39191_39276[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (3))){
var inst_39182 = (state_39184[(2)]);
var state_39184__$1 = state_39184;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39184__$1,inst_39182);
} else {
if((state_val_39185 === (2))){
var inst_39163 = (state_39184[(8)]);
var _ = (function (){var statearr_39193 = state_39184;
(statearr_39193[(4)] = cljs.core.cons((5),(state_39184[(4)])));

return statearr_39193;
})();
var inst_39163__$1 = cljs.core.volatile_BANG_((0));
var inst_39164 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_39165 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_39164,cljs.core.cst$kw$fuel,inst_39163__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_39166 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_39165);
var inst_39167 = fluree.db.query.fql.query(db,inst_39166);
var state_39184__$1 = (function (){var statearr_39194 = state_39184;
(statearr_39194[(8)] = inst_39163__$1);

return statearr_39194;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39184__$1,(6),inst_39167);
} else {
if((state_val_39185 === (9))){
var inst_39179 = (state_39184[(2)]);
var _ = (function (){var statearr_39195 = state_39184;
(statearr_39195[(4)] = cljs.core.rest((state_39184[(4)])));

return statearr_39195;
})();
var state_39184__$1 = state_39184;
var statearr_39196_39277 = state_39184__$1;
(statearr_39196_39277[(2)] = inst_39179);

(statearr_39196_39277[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (5))){
var _ = (function (){var statearr_39197 = state_39184;
(statearr_39197[(4)] = cljs.core.rest((state_39184[(4)])));

return statearr_39197;
})();
var state_39184__$1 = state_39184;
var ex39192 = (state_39184__$1[(2)]);
var statearr_39198_39278 = state_39184__$1;
(statearr_39198_39278[(5)] = ex39192);


if((ex39192 instanceof Error)){
var statearr_39199_39279 = state_39184__$1;
(statearr_39199_39279[(1)] = (4));

(statearr_39199_39279[(5)] = null);

} else {
throw ex39192;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (8))){
var inst_39169 = (state_39184[(7)]);
var inst_39163 = (state_39184[(8)]);
var inst_39174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39175 = cljs.core.deref(inst_39163);
var inst_39176 = [inst_39169,inst_39175];
var inst_39177 = (new cljs.core.PersistentVector(null,2,(5),inst_39174,inst_39176,null));
var state_39184__$1 = state_39184;
var statearr_39200_39280 = state_39184__$1;
(statearr_39200_39280[(2)] = inst_39177);

(statearr_39200_39280[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10798__auto____0 = (function (){
var statearr_39201 = [null,null,null,null,null,null,null,null,null];
(statearr_39201[(0)] = fluree$db$dbfunctions$internal$state_machine__10798__auto__);

(statearr_39201[(1)] = (1));

return statearr_39201;
});
var fluree$db$dbfunctions$internal$state_machine__10798__auto____1 = (function (state_39184){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_39184);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e39202){var ex__10801__auto__ = e39202;
var statearr_39203_39281 = state_39184;
(statearr_39203_39281[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_39184[(4)]))){
var statearr_39204_39282 = state_39184;
(statearr_39204_39282[(1)] = cljs.core.first((state_39184[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__39283 = state_39184;
state_39184 = G__39283;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10798__auto__ = function(state_39184){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10798__auto____1.call(this,state_39184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_39205 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_39205[(6)] = c__10835__auto__);

return statearr_39205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_39250){
var state_val_39251 = (state_39250[(1)]);
if((state_val_39251 === (7))){
var inst_39236 = (state_39250[(2)]);
var inst_39237 = fluree.db.query.fql.query(db,inst_39236);
var state_39250__$1 = state_39250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39250__$1,(8),inst_39237);
} else {
if((state_val_39251 === (1))){
var inst_39206 = typeof select === 'string';
var state_39250__$1 = state_39250;
if(cljs.core.truth_(inst_39206)){
var statearr_39252_39284 = state_39250__$1;
(statearr_39252_39284[(1)] = (2));

} else {
var statearr_39253_39285 = state_39250__$1;
(statearr_39253_39285[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39251 === (4))){
var inst_39219 = (state_39250[(7)]);
var inst_39212 = (state_39250[(8)]);
var inst_39211 = (state_39250[(2)]);
var inst_39212__$1 = cljs.core.volatile_BANG_((0));
var inst_39213 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_39214 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_39215 = [inst_39212__$1,(100000)];
var inst_39216 = cljs.core.PersistentHashMap.fromArrays(inst_39214,inst_39215);
var inst_39217 = [inst_39211,from,where,block,limit,inst_39216];
var inst_39218 = cljs.core.PersistentHashMap.fromArrays(inst_39213,inst_39217);
var inst_39219__$1 = fluree.db.util.core.without_nils(inst_39218);
var inst_39220 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_39219__$1);
var inst_39221 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_39219__$1);
var inst_39222 = cljs.core.first(inst_39221);
var inst_39223 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39222], 0));
var inst_39224 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_39223);
var inst_39225 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_39219__$1);
var inst_39226 = cljs.core.last(inst_39225);
var inst_39227 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39226], 0));
var inst_39228 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_39227);
var inst_39229 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39220,inst_39224,inst_39228], 0));
var state_39250__$1 = (function (){var statearr_39254 = state_39250;
(statearr_39254[(7)] = inst_39219__$1);

(statearr_39254[(8)] = inst_39212__$1);

return statearr_39254;
})();
if(cljs.core.truth_(inst_39229)){
var statearr_39255_39286 = state_39250__$1;
(statearr_39255_39286[(1)] = (5));

} else {
var statearr_39256_39287 = state_39250__$1;
(statearr_39256_39287[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39251 === (6))){
var inst_39219 = (state_39250[(7)]);
var state_39250__$1 = state_39250;
var statearr_39257_39288 = state_39250__$1;
(statearr_39257_39288[(2)] = inst_39219);

(statearr_39257_39288[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39251 === (3))){
var state_39250__$1 = state_39250;
var statearr_39258_39289 = state_39250__$1;
(statearr_39258_39289[(2)] = select);

(statearr_39258_39289[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39251 === (2))){
var inst_39208 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_39250__$1 = state_39250;
var statearr_39259_39290 = state_39250__$1;
(statearr_39259_39290[(2)] = inst_39208);

(statearr_39259_39290[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39251 === (11))){
var inst_39248 = (state_39250[(2)]);
var state_39250__$1 = state_39250;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39250__$1,inst_39248);
} else {
if((state_val_39251 === (9))){
var inst_39239 = (state_39250[(9)]);
var state_39250__$1 = state_39250;
var statearr_39260_39291 = state_39250__$1;
(statearr_39260_39291[(2)] = inst_39239);

(statearr_39260_39291[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39251 === (5))){
var inst_39219 = (state_39250[(7)]);
var inst_39231 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_39219);
var inst_39232 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_39231);
var inst_39233 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39219,cljs.core.cst$kw$where,inst_39232);
var state_39250__$1 = state_39250;
var statearr_39261_39292 = state_39250__$1;
(statearr_39261_39292[(2)] = inst_39233);

(statearr_39261_39292[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39251 === (10))){
var inst_39212 = (state_39250[(8)]);
var inst_39239 = (state_39250[(9)]);
var inst_39243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39244 = cljs.core.deref(inst_39212);
var inst_39245 = [inst_39239,inst_39244];
var inst_39246 = (new cljs.core.PersistentVector(null,2,(5),inst_39243,inst_39245,null));
var state_39250__$1 = state_39250;
var statearr_39262_39293 = state_39250__$1;
(statearr_39262_39293[(2)] = inst_39246);

(statearr_39262_39293[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39251 === (8))){
var inst_39239 = (state_39250[(9)]);
var inst_39239__$1 = (state_39250[(2)]);
var inst_39240 = fluree.db.util.core.exception_QMARK_(inst_39239__$1);
var state_39250__$1 = (function (){var statearr_39263 = state_39250;
(statearr_39263[(9)] = inst_39239__$1);

return statearr_39263;
})();
if(inst_39240){
var statearr_39264_39294 = state_39250__$1;
(statearr_39264_39294[(1)] = (9));

} else {
var statearr_39265_39295 = state_39250__$1;
(statearr_39265_39295[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10798__auto____0 = (function (){
var statearr_39266 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39266[(0)] = fluree$db$dbfunctions$internal$state_machine__10798__auto__);

(statearr_39266[(1)] = (1));

return statearr_39266;
});
var fluree$db$dbfunctions$internal$state_machine__10798__auto____1 = (function (state_39250){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_39250);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e39267){var ex__10801__auto__ = e39267;
var statearr_39268_39296 = state_39250;
(statearr_39268_39296[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_39250[(4)]))){
var statearr_39269_39297 = state_39250;
(statearr_39269_39297[(1)] = cljs.core.first((state_39250[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__39298 = state_39250;
state_39250 = G__39298;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10798__auto__ = function(state_39250){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10798__auto____1.call(this,state_39250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_39270 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_39270[(6)] = c__10835__auto__);

return statearr_39270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__39302 = path;
var vec__39303 = G__39302;
var seq__39304 = cljs.core.seq(vec__39303);
var first__39305 = cljs.core.first(seq__39304);
var seq__39304__$1 = cljs.core.next(seq__39304);
var var$ = first__39305;
var r = seq__39304__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__39302__$1 = G__39302;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__39309 = G__39302__$1;
var seq__39310 = cljs.core.seq(vec__39309);
var first__39311 = cljs.core.first(seq__39310);
var seq__39310__$1 = cljs.core.next(seq__39310);
var var$__$1 = first__39311;
var r__$1 = seq__39310__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__39312 = r__$1;
var G__39313 = n__$2;
var G__39314 = next_clauses;
G__39302__$1 = G__39312;
n__$1 = G__39313;
where_clauses__$1 = G__39314;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__39315 = r__$1;
var G__39316 = next_n;
var G__39317 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__39302__$1 = G__39315;
n__$1 = G__39316;
where_clauses__$1 = G__39317;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_39354){
var state_val_39355 = (state_39354[(1)]);
if((state_val_39355 === (7))){
var inst_39327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39328 = [path];
var inst_39329 = (new cljs.core.PersistentVector(null,1,(5),inst_39327,inst_39328,null));
var state_39354__$1 = state_39354;
var statearr_39356_39384 = state_39354__$1;
(statearr_39356_39384[(2)] = inst_39329);

(statearr_39356_39384[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (1))){
var state_39354__$1 = state_39354;
var statearr_39357_39385 = state_39354__$1;
(statearr_39357_39385[(2)] = null);

(statearr_39357_39385[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (4))){
var inst_39318 = (state_39354[(2)]);
var state_39354__$1 = state_39354;
var statearr_39358_39386 = state_39354__$1;
(statearr_39358_39386[(2)] = inst_39318);

(statearr_39358_39386[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (13))){
var inst_39345 = (state_39354[(2)]);
var inst_39346 = fluree.db.util.async.throw_err(inst_39345);
var _ = (function (){var statearr_39359 = state_39354;
(statearr_39359[(4)] = cljs.core.rest((state_39354[(4)])));

return statearr_39359;
})();
var state_39354__$1 = state_39354;
var statearr_39360_39387 = state_39354__$1;
(statearr_39360_39387[(2)] = inst_39346);

(statearr_39360_39387[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (6))){
var state_39354__$1 = state_39354;
var statearr_39362_39388 = state_39354__$1;
(statearr_39362_39388[(2)] = path);

(statearr_39362_39388[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (3))){
var inst_39352 = (state_39354[(2)]);
var state_39354__$1 = state_39354;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39354__$1,inst_39352);
} else {
if((state_val_39355 === (12))){
var _ = (function (){var statearr_39363 = state_39354;
(statearr_39363[(4)] = cljs.core.rest((state_39354[(4)])));

return statearr_39363;
})();
var state_39354__$1 = state_39354;
var ex39361 = (state_39354__$1[(2)]);
var statearr_39364_39389 = state_39354__$1;
(statearr_39364_39389[(5)] = ex39361);


var statearr_39365_39390 = state_39354__$1;
(statearr_39365_39390[(1)] = (11));

(statearr_39365_39390[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (2))){
var _ = (function (){var statearr_39366 = state_39354;
(statearr_39366[(4)] = cljs.core.cons((5),(state_39354[(4)])));

return statearr_39366;
})();
var inst_39324 = cljs.core.vector_QMARK_(path);
var state_39354__$1 = state_39354;
if(inst_39324){
var statearr_39367_39391 = state_39354__$1;
(statearr_39367_39391[(1)] = (6));

} else {
var statearr_39368_39392 = state_39354__$1;
(statearr_39368_39392[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (11))){
var inst_39331 = (state_39354[(7)]);
var inst_39336 = (state_39354[(2)]);
var inst_39337 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39336,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_39331,endSubject], 0));
var state_39354__$1 = state_39354;
var statearr_39370_39393 = state_39354__$1;
(statearr_39370_39393[(2)] = inst_39337);

(statearr_39370_39393[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (9))){
var inst_39335 = (state_39354[(8)]);
var _ = (function (){var statearr_39371 = state_39354;
(statearr_39371[(4)] = cljs.core.cons((12),(state_39354[(4)])));

return statearr_39371;
})();
var inst_39343 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_39335);
var state_39354__$1 = state_39354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39354__$1,(13),inst_39343);
} else {
if((state_val_39355 === (5))){
var _ = (function (){var statearr_39372 = state_39354;
(statearr_39372[(4)] = cljs.core.rest((state_39354[(4)])));

return statearr_39372;
})();
var state_39354__$1 = state_39354;
var ex39369 = (state_39354__$1[(2)]);
var statearr_39373_39394 = state_39354__$1;
(statearr_39373_39394[(5)] = ex39369);


if((ex39369 instanceof Error)){
var statearr_39374_39395 = state_39354__$1;
(statearr_39374_39395[(1)] = (4));

(statearr_39374_39395[(5)] = null);

} else {
throw ex39369;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (10))){
var inst_39349 = (state_39354[(2)]);
var _ = (function (){var statearr_39375 = state_39354;
(statearr_39375[(4)] = cljs.core.rest((state_39354[(4)])));

return statearr_39375;
})();
var state_39354__$1 = state_39354;
var statearr_39376_39396 = state_39354__$1;
(statearr_39376_39396[(2)] = inst_39349);

(statearr_39376_39396[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (8))){
var inst_39331 = (state_39354[(7)]);
var inst_39331__$1 = (state_39354[(2)]);
var inst_39332 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_39331__$1,endSubject);
var inst_39333 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_39334 = ["?var1",inst_39332];
var inst_39335 = cljs.core.PersistentHashMap.fromArrays(inst_39333,inst_39334);
var state_39354__$1 = (function (){var statearr_39377 = state_39354;
(statearr_39377[(7)] = inst_39331__$1);

(statearr_39377[(8)] = inst_39335);

return statearr_39377;
})();
var statearr_39378_39397 = state_39354__$1;
(statearr_39378_39397[(2)] = null);

(statearr_39378_39397[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto____0 = (function (){
var statearr_39379 = [null,null,null,null,null,null,null,null,null];
(statearr_39379[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto__);

(statearr_39379[(1)] = (1));

return statearr_39379;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto____1 = (function (state_39354){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_39354);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e39380){var ex__10801__auto__ = e39380;
var statearr_39381_39398 = state_39354;
(statearr_39381_39398[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_39354[(4)]))){
var statearr_39382_39399 = state_39354;
(statearr_39382_39399[(1)] = cljs.core.first((state_39354[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__39400 = state_39354;
state_39354 = G__39400;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto__ = function(state_39354){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto____1.call(this,state_39354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_39383 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_39383[(6)] = c__10835__auto__);

return statearr_39383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e39401){var e = e39401;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e39402){var e = e39402;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e39403){var e = e39403;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e39404){var e = e39404;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39407 = arguments.length;
var i__4830__auto___39408 = (0);
while(true){
if((i__4830__auto___39408 < len__4829__auto___39407)){
args__4835__auto__.push((arguments[i__4830__auto___39408]));

var G__39409 = (i__4830__auto___39408 + (1));
i__4830__auto___39408 = G__39409;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e39406){var e = e39406;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq39405){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39405));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39412 = arguments.length;
var i__4830__auto___39413 = (0);
while(true){
if((i__4830__auto___39413 < len__4829__auto___39412)){
args__4835__auto__.push((arguments[i__4830__auto___39413]));

var G__39414 = (i__4830__auto___39413 + (1));
i__4830__auto___39413 = G__39414;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e39411){var e = e39411;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq39410){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39410));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39417 = arguments.length;
var i__4830__auto___39418 = (0);
while(true){
if((i__4830__auto___39418 < len__4829__auto___39417)){
args__4835__auto__.push((arguments[i__4830__auto___39418]));

var G__39419 = (i__4830__auto___39418 + (1));
i__4830__auto___39418 = G__39419;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4223__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e39416){var e = e39416;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq39415){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39415));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39422 = arguments.length;
var i__4830__auto___39423 = (0);
while(true){
if((i__4830__auto___39423 < len__4829__auto___39422)){
args__4835__auto__.push((arguments[i__4830__auto___39423]));

var G__39424 = (i__4830__auto___39423 + (1));
i__4830__auto___39423 = G__39424;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e39421){var e = e39421;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq39420){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39420));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e39425){var e = e39425;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e39426){var e = e39426;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e39427){var e = e39427;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e39428){var e = e39428;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e39429){var e = e39429;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__39435 = path;
var vec__39436 = G__39435;
var seq__39437 = cljs.core.seq(vec__39436);
var first__39438 = cljs.core.first(seq__39437);
var seq__39437__$1 = cljs.core.next(seq__39437);
var pred = first__39438;
var r = seq__39437__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__39435__$1 = G__39435;
var subjects__$1 = subjects;
while(true){
var vec__39442 = G__39435__$1;
var seq__39443 = cljs.core.seq(vec__39442);
var first__39444 = cljs.core.first(seq__39443);
var seq__39443__$1 = cljs.core.next(seq__39443);
var pred__$1 = first__39444;
var r__$1 = seq__39443__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__39435__$1,subjects__$1,vec__39442,seq__39443,first__39444,seq__39443__$1,pred__$1,r__$1,subjects__$2,G__39435,vec__39436,seq__39437,first__39438,seq__39437__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__39435__$1,subjects__$1,vec__39442,seq__39443,first__39444,seq__39443__$1,pred__$1,r__$1,subjects__$2,G__39435,vec__39436,seq__39437,first__39438,seq__39437__$1,pred,r,subjects){
return (function (p1__39430_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__39430_SHARP_,pred__$1);
});})(G__39435__$1,subjects__$1,vec__39442,seq__39443,first__39444,seq__39443__$1,pred__$1,r__$1,subjects__$2,G__39435,vec__39436,seq__39437,first__39438,seq__39437__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__39435__$1,subjects__$1,vec__39442,seq__39443,first__39444,seq__39443__$1,pred__$1,r__$1,subjects__$2,G__39435,vec__39436,seq__39437,first__39438,seq__39437__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4221__auto__ = r__$1;
if(and__4221__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4221__auto__;
}
})())){
var G__39445 = r__$1;
var G__39446 = next_subjects;
G__39435__$1 = G__39445;
subjects__$1 = G__39446;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e39431){var e = e39431;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e39447){var e = e39447;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e39448){var e = e39448;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39451 = arguments.length;
var i__4830__auto___39452 = (0);
while(true){
if((i__4830__auto___39452 < len__4829__auto___39451)){
args__4835__auto__.push((arguments[i__4830__auto___39452]));

var G__39453 = (i__4830__auto___39452 + (1));
i__4830__auto___39452 = G__39453;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e39450){var e = e39450;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq39449){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39449));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e39454){var e = e39454;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___39457 = arguments.length;
var i__4830__auto___39458 = (0);
while(true){
if((i__4830__auto___39458 < len__4829__auto___39457)){
args__4835__auto__.push((arguments[i__4830__auto___39458]));

var G__39459 = (i__4830__auto___39458 + (1));
i__4830__auto___39458 = G__39459;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e39456){var e = e39456;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq39455){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39455));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e39460){var e = e39460;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_39515){
var state_val_39516 = (state_39515[(1)]);
if((state_val_39516 === (7))){
var inst_39462 = (state_39515[(2)]);
var state_39515__$1 = state_39515;
var statearr_39517_39550 = state_39515__$1;
(statearr_39517_39550[(2)] = inst_39462);

(statearr_39517_39550[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (1))){
var state_39515__$1 = state_39515;
var statearr_39518_39551 = state_39515__$1;
(statearr_39518_39551[(2)] = null);

(statearr_39518_39551[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (4))){
var inst_39461 = (state_39515[(2)]);
var state_39515__$1 = (function (){var statearr_39519 = state_39515;
(statearr_39519[(7)] = inst_39461);

return statearr_39519;
})();
var statearr_39520_39552 = state_39515__$1;
(statearr_39520_39552[(2)] = null);

(statearr_39520_39552[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (15))){
var inst_39499 = (state_39515[(8)]);
var inst_39503 = inst_39499.o;
var state_39515__$1 = state_39515;
var statearr_39521_39553 = state_39515__$1;
(statearr_39521_39553[(2)] = inst_39503);

(statearr_39521_39553[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (13))){
var inst_39499 = (state_39515[(8)]);
var inst_39495 = (state_39515[(2)]);
var inst_39496 = fluree.db.util.async.throw_err(inst_39495);
var inst_39497 = fluree.db.dbfunctions.internal.count(inst_39496);
var inst_39499__$1 = cljs.core.first(inst_39496);
var inst_39500 = (inst_39499__$1 == null);
var state_39515__$1 = (function (){var statearr_39522 = state_39515;
(statearr_39522[(8)] = inst_39499__$1);

(statearr_39522[(9)] = inst_39497);

return statearr_39522;
})();
if(cljs.core.truth_(inst_39500)){
var statearr_39523_39554 = state_39515__$1;
(statearr_39523_39554[(1)] = (14));

} else {
var statearr_39524_39555 = state_39515__$1;
(statearr_39524_39555[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (6))){
var inst_39471 = (state_39515[(2)]);
var state_39515__$1 = state_39515;
var statearr_39525_39556 = state_39515__$1;
(statearr_39525_39556[(2)] = inst_39471);

(statearr_39525_39556[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (3))){
var inst_39513 = (state_39515[(2)]);
var state_39515__$1 = state_39515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39515__$1,inst_39513);
} else {
if((state_val_39516 === (12))){
var inst_39510 = (state_39515[(2)]);
var _ = (function (){var statearr_39526 = state_39515;
(statearr_39526[(4)] = cljs.core.rest((state_39515[(4)])));

return statearr_39526;
})();
var state_39515__$1 = state_39515;
var statearr_39527_39557 = state_39515__$1;
(statearr_39527_39557[(2)] = inst_39510);

(statearr_39527_39557[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (2))){
var _ = (function (){var statearr_39529 = state_39515;
(statearr_39529[(4)] = cljs.core.cons((9),(state_39515[(4)])));

return statearr_39529;
})();
var inst_39477 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39478 = typeof inst_39477 === 'string';
var state_39515__$1 = state_39515;
if(cljs.core.truth_(inst_39478)){
var statearr_39530_39558 = state_39515__$1;
(statearr_39530_39558[(1)] = (10));

} else {
var statearr_39531_39559 = state_39515__$1;
(statearr_39531_39559[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (11))){
var inst_39484 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39485 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_39484);
var inst_39486 = fluree.db.dbfunctions.internal.inc(inst_39485);
var inst_39487 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39484,cljs.core.cst$kw$t,inst_39486);
var inst_39488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39489 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39490 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39491 = [inst_39489,inst_39490];
var inst_39492 = (new cljs.core.PersistentVector(null,2,(5),inst_39488,inst_39491,null));
var inst_39493 = fluree.db.dbproto._search(inst_39487,inst_39492);
var state_39515__$1 = state_39515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39515__$1,(13),inst_39493);
} else {
if((state_val_39516 === (9))){
var _ = (function (){var statearr_39532 = state_39515;
(statearr_39532[(4)] = cljs.core.rest((state_39515[(4)])));

return statearr_39532;
})();
var state_39515__$1 = state_39515;
var ex39528 = (state_39515__$1[(2)]);
var statearr_39533_39560 = state_39515__$1;
(statearr_39533_39560[(5)] = ex39528);


var statearr_39534_39561 = state_39515__$1;
(statearr_39534_39561[(1)] = (4));

(statearr_39534_39561[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (5))){
var inst_39461 = (state_39515[(7)]);
var _ = (function (){var statearr_39535 = state_39515;
(statearr_39535[(4)] = cljs.core.cons((8),(state_39515[(4)])));

return statearr_39535;
})();
var inst_39468 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39461,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_39536 = state_39515;
(statearr_39536[(4)] = cljs.core.rest((state_39515[(4)])));

return statearr_39536;
})();
var state_39515__$1 = state_39515;
var statearr_39537_39562 = state_39515__$1;
(statearr_39537_39562[(2)] = inst_39468);

(statearr_39537_39562[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (14))){
var state_39515__$1 = state_39515;
var statearr_39538_39563 = state_39515__$1;
(statearr_39538_39563[(2)] = null);

(statearr_39538_39563[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (16))){
var inst_39497 = (state_39515[(9)]);
var inst_39505 = (state_39515[(2)]);
var inst_39506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39507 = [inst_39505,inst_39497];
var inst_39508 = (new cljs.core.PersistentVector(null,2,(5),inst_39506,inst_39507,null));
var state_39515__$1 = state_39515;
var statearr_39540_39564 = state_39515__$1;
(statearr_39540_39564[(2)] = inst_39508);

(statearr_39540_39564[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (10))){
var inst_39480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39481 = [null,(0)];
var inst_39482 = (new cljs.core.PersistentVector(null,2,(5),inst_39480,inst_39481,null));
var state_39515__$1 = state_39515;
var statearr_39541_39565 = state_39515__$1;
(statearr_39541_39565[(2)] = inst_39482);

(statearr_39541_39565[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39516 === (8))){
var _ = (function (){var statearr_39542 = state_39515;
(statearr_39542[(4)] = cljs.core.rest((state_39515[(4)])));

return statearr_39542;
})();
var state_39515__$1 = state_39515;
var ex39539 = (state_39515__$1[(2)]);
var statearr_39543_39566 = state_39515__$1;
(statearr_39543_39566[(5)] = ex39539);


var statearr_39544_39567 = state_39515__$1;
(statearr_39544_39567[(1)] = (7));

(statearr_39544_39567[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto____0 = (function (){
var statearr_39545 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39545[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto__);

(statearr_39545[(1)] = (1));

return statearr_39545;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto____1 = (function (state_39515){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_39515);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e39546){var ex__10801__auto__ = e39546;
var statearr_39547_39568 = state_39515;
(statearr_39547_39568[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_39515[(4)]))){
var statearr_39548_39569 = state_39515;
(statearr_39548_39569[(1)] = cljs.core.first((state_39515[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__39570 = state_39515;
state_39515 = G__39570;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto__ = function(state_39515){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto____1.call(this,state_39515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_39549 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_39549[(6)] = c__10835__auto__);

return statearr_39549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_39622){
var state_val_39623 = (state_39622[(1)]);
if((state_val_39623 === (7))){
var inst_39572 = (state_39622[(2)]);
var state_39622__$1 = state_39622;
var statearr_39624_39653 = state_39622__$1;
(statearr_39624_39653[(2)] = inst_39572);

(statearr_39624_39653[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (1))){
var state_39622__$1 = state_39622;
var statearr_39625_39654 = state_39622__$1;
(statearr_39625_39654[(2)] = null);

(statearr_39625_39654[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (4))){
var inst_39571 = (state_39622[(2)]);
var state_39622__$1 = (function (){var statearr_39626 = state_39622;
(statearr_39626[(7)] = inst_39571);

return statearr_39626;
})();
var statearr_39627_39655 = state_39622__$1;
(statearr_39627_39655[(2)] = null);

(statearr_39627_39655[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (13))){
var inst_39617 = (state_39622[(2)]);
var _ = (function (){var statearr_39628 = state_39622;
(statearr_39628[(4)] = cljs.core.rest((state_39622[(4)])));

return statearr_39628;
})();
var state_39622__$1 = state_39622;
var statearr_39629_39656 = state_39622__$1;
(statearr_39629_39656[(2)] = inst_39617);

(statearr_39629_39656[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (6))){
var inst_39581 = (state_39622[(2)]);
var state_39622__$1 = state_39622;
var statearr_39630_39657 = state_39622__$1;
(statearr_39630_39657[(2)] = inst_39581);

(statearr_39630_39657[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (3))){
var inst_39620 = (state_39622[(2)]);
var state_39622__$1 = state_39622;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39622__$1,inst_39620);
} else {
if((state_val_39623 === (12))){
var inst_39604 = (state_39622[(8)]);
var inst_39613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39614 = [null,inst_39604];
var inst_39615 = (new cljs.core.PersistentVector(null,2,(5),inst_39613,inst_39614,null));
var state_39622__$1 = state_39622;
var statearr_39631_39658 = state_39622__$1;
(statearr_39631_39658[(2)] = inst_39615);

(statearr_39631_39658[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (2))){
var _ = (function (){var statearr_39633 = state_39622;
(statearr_39633[(4)] = cljs.core.cons((9),(state_39622[(4)])));

return statearr_39633;
})();
var inst_39590 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_39591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39593 = [null,pred_name,"?o"];
var inst_39594 = (new cljs.core.PersistentVector(null,3,(5),inst_39592,inst_39593,null));
var inst_39595 = [inst_39594];
var inst_39596 = (new cljs.core.PersistentVector(null,1,(5),inst_39591,inst_39595,null));
var inst_39597 = ["?o",inst_39596,opts];
var inst_39598 = cljs.core.PersistentHashMap.fromArrays(inst_39590,inst_39597);
var inst_39599 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_39598);
var state_39622__$1 = state_39622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39622__$1,(10),inst_39599);
} else {
if((state_val_39623 === (11))){
var inst_39603 = (state_39622[(9)]);
var inst_39604 = (state_39622[(8)]);
var inst_39608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39609 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_39603);
var inst_39610 = [inst_39609,inst_39604];
var inst_39611 = (new cljs.core.PersistentVector(null,2,(5),inst_39608,inst_39610,null));
var state_39622__$1 = state_39622;
var statearr_39634_39659 = state_39622__$1;
(statearr_39634_39659[(2)] = inst_39611);

(statearr_39634_39659[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (9))){
var _ = (function (){var statearr_39635 = state_39622;
(statearr_39635[(4)] = cljs.core.rest((state_39622[(4)])));

return statearr_39635;
})();
var state_39622__$1 = state_39622;
var ex39632 = (state_39622__$1[(2)]);
var statearr_39636_39660 = state_39622__$1;
(statearr_39636_39660[(5)] = ex39632);


var statearr_39637_39661 = state_39622__$1;
(statearr_39637_39661[(1)] = (4));

(statearr_39637_39661[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (5))){
var inst_39571 = (state_39622[(7)]);
var _ = (function (){var statearr_39639 = state_39622;
(statearr_39639[(4)] = cljs.core.cons((8),(state_39622[(4)])));

return statearr_39639;
})();
var inst_39578 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39571,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_39640 = state_39622;
(statearr_39640[(4)] = cljs.core.rest((state_39622[(4)])));

return statearr_39640;
})();
var state_39622__$1 = state_39622;
var statearr_39641_39662 = state_39622__$1;
(statearr_39641_39662[(2)] = inst_39578);

(statearr_39641_39662[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (10))){
var inst_39603 = (state_39622[(9)]);
var inst_39601 = (state_39622[(2)]);
var inst_39602 = fluree.db.util.async.throw_err(inst_39601);
var inst_39603__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39602,(0),null);
var inst_39604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39602,(1),null);
var inst_39605 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_39603__$1);
var inst_39606 = cljs.core.not(inst_39605);
var state_39622__$1 = (function (){var statearr_39642 = state_39622;
(statearr_39642[(9)] = inst_39603__$1);

(statearr_39642[(8)] = inst_39604);

return statearr_39642;
})();
if(inst_39606){
var statearr_39643_39663 = state_39622__$1;
(statearr_39643_39663[(1)] = (11));

} else {
var statearr_39644_39664 = state_39622__$1;
(statearr_39644_39664[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39623 === (8))){
var _ = (function (){var statearr_39645 = state_39622;
(statearr_39645[(4)] = cljs.core.rest((state_39622[(4)])));

return statearr_39645;
})();
var state_39622__$1 = state_39622;
var ex39638 = (state_39622__$1[(2)]);
var statearr_39646_39665 = state_39622__$1;
(statearr_39646_39665[(5)] = ex39638);


var statearr_39647_39666 = state_39622__$1;
(statearr_39647_39666[(1)] = (7));

(statearr_39647_39666[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto____0 = (function (){
var statearr_39648 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39648[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto__);

(statearr_39648[(1)] = (1));

return statearr_39648;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto____1 = (function (state_39622){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_39622);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e39649){var ex__10801__auto__ = e39649;
var statearr_39650_39667 = state_39622;
(statearr_39650_39667[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_39622[(4)]))){
var statearr_39651_39668 = state_39622;
(statearr_39651_39668[(1)] = cljs.core.first((state_39622[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__39669 = state_39622;
state_39622 = G__39669;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto__ = function(state_39622){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto____1.call(this,state_39622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_39652 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_39652[(6)] = c__10835__auto__);

return statearr_39652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4221__auto__ = typeof email === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4221__auto__;
}
})());
}catch (e39670){var e = e39670;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__39672 = arguments.length;
switch (G__39672) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_39742){
var state_val_39743 = (state_39742[(1)]);
if((state_val_39743 === (7))){
var inst_39674 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
var statearr_39744_39788 = state_39742__$1;
(statearr_39744_39788[(2)] = inst_39674);

(statearr_39744_39788[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (20))){
var inst_39718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39719 = ["*"];
var inst_39720 = (new cljs.core.PersistentVector(null,1,(5),inst_39718,inst_39719,null));
var state_39742__$1 = state_39742;
var statearr_39745_39789 = state_39742__$1;
(statearr_39745_39789[(2)] = inst_39720);

(statearr_39745_39789[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (1))){
var state_39742__$1 = state_39742;
var statearr_39746_39790 = state_39742__$1;
(statearr_39746_39790[(2)] = null);

(statearr_39746_39790[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (4))){
var inst_39673 = (state_39742[(2)]);
var state_39742__$1 = (function (){var statearr_39747 = state_39742;
(statearr_39747[(7)] = inst_39673);

return statearr_39747;
})();
var statearr_39748_39791 = state_39742__$1;
(statearr_39748_39791[(2)] = null);

(statearr_39748_39791[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (15))){
var inst_39737 = (state_39742[(2)]);
var _ = (function (){var statearr_39749 = state_39742;
(statearr_39749[(4)] = cljs.core.rest((state_39742[(4)])));

return statearr_39749;
})();
var state_39742__$1 = state_39742;
var statearr_39750_39792 = state_39742__$1;
(statearr_39750_39792[(2)] = inst_39737);

(statearr_39750_39792[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (21))){
var inst_39708 = (state_39742[(8)]);
var inst_39701 = (state_39742[(9)]);
var inst_39722 = (state_39742[(2)]);
var inst_39723 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_39724 = cljs.core.PersistentHashMap.EMPTY;
var inst_39725 = [inst_39722,inst_39708,inst_39724];
var inst_39726 = cljs.core.PersistentHashMap.fromArrays(inst_39723,inst_39725);
var inst_39727 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_39701,inst_39726);
var state_39742__$1 = state_39742;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39742__$1,(22),inst_39727);
} else {
if((state_val_39743 === (13))){
var inst_39696 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39742__$1 = state_39742;
var statearr_39751_39793 = state_39742__$1;
(statearr_39751_39793[(2)] = inst_39696);

(statearr_39751_39793[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (22))){
var inst_39729 = (state_39742[(2)]);
var inst_39730 = fluree.db.util.async.throw_err(inst_39729);
var inst_39731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39730,(0),null);
var inst_39732 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39730,(1),null);
var inst_39733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39734 = [inst_39731,inst_39732];
var inst_39735 = (new cljs.core.PersistentVector(null,2,(5),inst_39733,inst_39734,null));
var state_39742__$1 = state_39742;
var statearr_39752_39794 = state_39742__$1;
(statearr_39752_39794[(2)] = inst_39735);

(statearr_39752_39794[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (6))){
var inst_39683 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
var statearr_39753_39795 = state_39742__$1;
(statearr_39753_39795[(2)] = inst_39683);

(statearr_39753_39795[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (17))){
var inst_39705 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39706 = fluree.db.dbfunctions.internal.get(inst_39705,cljs.core.cst$kw$_id);
var state_39742__$1 = state_39742;
var statearr_39754_39796 = state_39742__$1;
(statearr_39754_39796[(2)] = inst_39706);

(statearr_39754_39796[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (3))){
var inst_39740 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39742__$1,inst_39740);
} else {
if((state_val_39743 === (12))){
var inst_39694 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
if(cljs.core.truth_(inst_39694)){
var statearr_39755_39797 = state_39742__$1;
(statearr_39755_39797[(1)] = (13));

} else {
var statearr_39756_39798 = state_39742__$1;
(statearr_39756_39798[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (2))){
var inst_39689 = (state_39742[(10)]);
var _ = (function (){var statearr_39757 = state_39742;
(statearr_39757[(4)] = cljs.core.cons((9),(state_39742[(4)])));

return statearr_39757;
})();
var inst_39689__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39742__$1 = (function (){var statearr_39758 = state_39742;
(statearr_39758[(10)] = inst_39689__$1);

return statearr_39758;
})();
if(cljs.core.truth_(inst_39689__$1)){
var statearr_39759_39799 = state_39742__$1;
(statearr_39759_39799[(1)] = (10));

} else {
var statearr_39760_39800 = state_39742__$1;
(statearr_39760_39800[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (19))){
var inst_39710 = cljs.core.PersistentVector.EMPTY;
var inst_39711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39712 = ["*"];
var inst_39713 = (new cljs.core.PersistentVector(null,1,(5),inst_39711,inst_39712,null));
var inst_39714 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_39715 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39713,inst_39714);
var inst_39716 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39710,inst_39715);
var state_39742__$1 = state_39742;
var statearr_39762_39801 = state_39742__$1;
(statearr_39762_39801[(2)] = inst_39716);

(statearr_39762_39801[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (11))){
var inst_39689 = (state_39742[(10)]);
var state_39742__$1 = state_39742;
var statearr_39763_39802 = state_39742__$1;
(statearr_39763_39802[(2)] = inst_39689);

(statearr_39763_39802[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (9))){
var _ = (function (){var statearr_39764 = state_39742;
(statearr_39764[(4)] = cljs.core.rest((state_39742[(4)])));

return statearr_39764;
})();
var state_39742__$1 = state_39742;
var ex39761 = (state_39742__$1[(2)]);
var statearr_39765_39803 = state_39742__$1;
(statearr_39765_39803[(5)] = ex39761);


var statearr_39766_39804 = state_39742__$1;
(statearr_39766_39804[(1)] = (4));

(statearr_39766_39804[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (5))){
var inst_39673 = (state_39742[(7)]);
var _ = (function (){var statearr_39767 = state_39742;
(statearr_39767[(4)] = cljs.core.cons((8),(state_39742[(4)])));

return statearr_39767;
})();
var inst_39680 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39673,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_39768 = state_39742;
(statearr_39768[(4)] = cljs.core.rest((state_39742[(4)])));

return statearr_39768;
})();
var state_39742__$1 = state_39742;
var statearr_39769_39805 = state_39742__$1;
(statearr_39769_39805[(2)] = inst_39680);

(statearr_39769_39805[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (14))){
var inst_39702 = (state_39742[(11)]);
var inst_39701 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39702__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39742__$1 = (function (){var statearr_39770 = state_39742;
(statearr_39770[(9)] = inst_39701);

(statearr_39770[(11)] = inst_39702__$1);

return statearr_39770;
})();
if(cljs.core.truth_(inst_39702__$1)){
var statearr_39771_39806 = state_39742__$1;
(statearr_39771_39806[(1)] = (16));

} else {
var statearr_39772_39807 = state_39742__$1;
(statearr_39772_39807[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (16))){
var inst_39702 = (state_39742[(11)]);
var state_39742__$1 = state_39742;
var statearr_39773_39808 = state_39742__$1;
(statearr_39773_39808[(2)] = inst_39702);

(statearr_39773_39808[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (10))){
var inst_39691 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_39742__$1 = state_39742;
var statearr_39775_39809 = state_39742__$1;
(statearr_39775_39809[(2)] = inst_39691);

(statearr_39775_39809[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (18))){
var inst_39708 = (state_39742[(2)]);
var state_39742__$1 = (function (){var statearr_39776 = state_39742;
(statearr_39776[(8)] = inst_39708);

return statearr_39776;
})();
if(cljs.core.truth_(additional_params)){
var statearr_39777_39810 = state_39742__$1;
(statearr_39777_39810[(1)] = (19));

} else {
var statearr_39778_39811 = state_39742__$1;
(statearr_39778_39811[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39743 === (8))){
var _ = (function (){var statearr_39779 = state_39742;
(statearr_39779[(4)] = cljs.core.rest((state_39742[(4)])));

return statearr_39779;
})();
var state_39742__$1 = state_39742;
var ex39774 = (state_39742__$1[(2)]);
var statearr_39780_39812 = state_39742__$1;
(statearr_39780_39812[(5)] = ex39774);


var statearr_39781_39813 = state_39742__$1;
(statearr_39781_39813[(1)] = (7));

(statearr_39781_39813[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10798__auto____0 = (function (){
var statearr_39782 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39782[(0)] = fluree$db$dbfunctions$internal$state_machine__10798__auto__);

(statearr_39782[(1)] = (1));

return statearr_39782;
});
var fluree$db$dbfunctions$internal$state_machine__10798__auto____1 = (function (state_39742){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_39742);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e39783){var ex__10801__auto__ = e39783;
var statearr_39784_39814 = state_39742;
(statearr_39784_39814[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_39742[(4)]))){
var statearr_39785_39815 = state_39742;
(statearr_39785_39815[(1)] = cljs.core.first((state_39742[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__39816 = state_39742;
state_39742 = G__39816;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10798__auto__ = function(state_39742){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10798__auto____1.call(this,state_39742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_39786 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_39786[(6)] = c__10835__auto__);

return statearr_39786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__39818 = arguments.length;
switch (G__39818) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_39862){
var state_val_39863 = (state_39862[(1)]);
if((state_val_39863 === (7))){
var inst_39840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39841 = ["*"];
var inst_39842 = (new cljs.core.PersistentVector(null,1,(5),inst_39840,inst_39841,null));
var state_39862__$1 = state_39862;
var statearr_39864_39884 = state_39862__$1;
(statearr_39864_39884[(2)] = inst_39842);

(statearr_39864_39884[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39863 === (1))){
var state_39862__$1 = state_39862;
var statearr_39865_39885 = state_39862__$1;
(statearr_39865_39885[(2)] = null);

(statearr_39865_39885[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39863 === (4))){
var inst_39819 = (state_39862[(2)]);
var inst_39820 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39819,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_39862__$1 = state_39862;
var statearr_39866_39886 = state_39862__$1;
(statearr_39866_39886[(2)] = inst_39820);

(statearr_39866_39886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39863 === (6))){
var inst_39832 = cljs.core.PersistentVector.EMPTY;
var inst_39833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39834 = ["*"];
var inst_39835 = (new cljs.core.PersistentVector(null,1,(5),inst_39833,inst_39834,null));
var inst_39836 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_39837 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39835,inst_39836);
var inst_39838 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39832,inst_39837);
var state_39862__$1 = state_39862;
var statearr_39867_39887 = state_39862__$1;
(statearr_39867_39887[(2)] = inst_39838);

(statearr_39867_39887[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39863 === (3))){
var inst_39860 = (state_39862[(2)]);
var state_39862__$1 = state_39862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39862__$1,inst_39860);
} else {
if((state_val_39863 === (2))){
var _ = (function (){var statearr_39869 = state_39862;
(statearr_39869[(4)] = cljs.core.cons((5),(state_39862[(4)])));

return statearr_39869;
})();
var inst_39829 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39830 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39862__$1 = (function (){var statearr_39870 = state_39862;
(statearr_39870[(7)] = inst_39830);

(statearr_39870[(8)] = inst_39829);

return statearr_39870;
})();
if(cljs.core.truth_(additional_params)){
var statearr_39871_39888 = state_39862__$1;
(statearr_39871_39888[(1)] = (6));

} else {
var statearr_39872_39889 = state_39862__$1;
(statearr_39872_39889[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39863 === (9))){
var inst_39851 = (state_39862[(2)]);
var inst_39852 = fluree.db.util.async.throw_err(inst_39851);
var inst_39853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39852,(0),null);
var inst_39854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39852,(1),null);
var inst_39855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39856 = [inst_39853,inst_39854];
var inst_39857 = (new cljs.core.PersistentVector(null,2,(5),inst_39855,inst_39856,null));
var _ = (function (){var statearr_39873 = state_39862;
(statearr_39873[(4)] = cljs.core.rest((state_39862[(4)])));

return statearr_39873;
})();
var state_39862__$1 = state_39862;
var statearr_39874_39890 = state_39862__$1;
(statearr_39874_39890[(2)] = inst_39857);

(statearr_39874_39890[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39863 === (5))){
var _ = (function (){var statearr_39875 = state_39862;
(statearr_39875[(4)] = cljs.core.rest((state_39862[(4)])));

return statearr_39875;
})();
var state_39862__$1 = state_39862;
var ex39868 = (state_39862__$1[(2)]);
var statearr_39876_39891 = state_39862__$1;
(statearr_39876_39891[(5)] = ex39868);


var statearr_39877_39892 = state_39862__$1;
(statearr_39877_39892[(1)] = (4));

(statearr_39877_39892[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39863 === (8))){
var inst_39830 = (state_39862[(7)]);
var inst_39829 = (state_39862[(8)]);
var inst_39844 = (state_39862[(2)]);
var inst_39845 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_39846 = cljs.core.PersistentHashMap.EMPTY;
var inst_39847 = [inst_39844,inst_39830,inst_39846];
var inst_39848 = cljs.core.PersistentHashMap.fromArrays(inst_39845,inst_39847);
var inst_39849 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_39829,inst_39848);
var state_39862__$1 = state_39862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39862__$1,(9),inst_39849);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10798__auto____0 = (function (){
var statearr_39878 = [null,null,null,null,null,null,null,null,null];
(statearr_39878[(0)] = fluree$db$dbfunctions$internal$state_machine__10798__auto__);

(statearr_39878[(1)] = (1));

return statearr_39878;
});
var fluree$db$dbfunctions$internal$state_machine__10798__auto____1 = (function (state_39862){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_39862);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e39879){var ex__10801__auto__ = e39879;
var statearr_39880_39893 = state_39862;
(statearr_39880_39893[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_39862[(4)]))){
var statearr_39881_39894 = state_39862;
(statearr_39881_39894[(1)] = cljs.core.first((state_39862[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__39895 = state_39862;
state_39862 = G__39895;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10798__auto__ = function(state_39862){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10798__auto____1.call(this,state_39862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_39882 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_39882[(6)] = c__10835__auto__);

return statearr_39882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_39939){
var state_val_39940 = (state_39939[(1)]);
if((state_val_39940 === (1))){
var state_39939__$1 = state_39939;
var statearr_39941_39955 = state_39939__$1;
(statearr_39941_39955[(2)] = null);

(statearr_39941_39955[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39940 === (2))){
var _ = (function (){var statearr_39942 = state_39939;
(statearr_39942[(4)] = cljs.core.cons((5),(state_39939[(4)])));

return statearr_39942;
})();
var inst_39906 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_39907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39908 = ["_user/_auth"];
var inst_39909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39910 = ["*"];
var inst_39911 = (new cljs.core.PersistentVector(null,1,(5),inst_39909,inst_39910,null));
var inst_39912 = [inst_39911];
var inst_39913 = cljs.core.PersistentHashMap.fromArrays(inst_39908,inst_39912);
var inst_39914 = [inst_39913];
var inst_39915 = (new cljs.core.PersistentVector(null,1,(5),inst_39907,inst_39914,null));
var inst_39916 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39917 = cljs.core.PersistentHashMap.EMPTY;
var inst_39918 = [inst_39915,inst_39916,inst_39917];
var inst_39919 = cljs.core.PersistentHashMap.fromArrays(inst_39906,inst_39918);
var inst_39920 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39921 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_39920,inst_39919);
var state_39939__$1 = state_39939;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39939__$1,(6),inst_39921);
} else {
if((state_val_39940 === (3))){
var inst_39937 = (state_39939[(2)]);
var state_39939__$1 = state_39939;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39939__$1,inst_39937);
} else {
if((state_val_39940 === (4))){
var inst_39896 = (state_39939[(2)]);
var inst_39897 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39896,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_39939__$1 = state_39939;
var statearr_39944_39956 = state_39939__$1;
(statearr_39944_39956[(2)] = inst_39897);

(statearr_39944_39956[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39940 === (5))){
var _ = (function (){var statearr_39945 = state_39939;
(statearr_39945[(4)] = cljs.core.rest((state_39939[(4)])));

return statearr_39945;
})();
var state_39939__$1 = state_39939;
var ex39943 = (state_39939__$1[(2)]);
var statearr_39946_39957 = state_39939__$1;
(statearr_39946_39957[(5)] = ex39943);


var statearr_39947_39958 = state_39939__$1;
(statearr_39947_39958[(1)] = (4));

(statearr_39947_39958[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39940 === (6))){
var inst_39923 = (state_39939[(2)]);
var inst_39924 = fluree.db.util.async.throw_err(inst_39923);
var inst_39925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39924,(0),null);
var inst_39926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39924,(1),null);
var inst_39927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39928 = ["_user/_auth","_id"];
var inst_39929 = (new cljs.core.PersistentVector(null,2,(5),inst_39927,inst_39928,null));
var inst_39930 = fluree.db.dbfunctions.internal.get_in(inst_39925,inst_39929);
var inst_39931 = cljs.core.first(inst_39930);
var inst_39932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39933 = [inst_39931,inst_39926];
var inst_39934 = (new cljs.core.PersistentVector(null,2,(5),inst_39932,inst_39933,null));
var _ = (function (){var statearr_39948 = state_39939;
(statearr_39948[(4)] = cljs.core.rest((state_39939[(4)])));

return statearr_39948;
})();
var state_39939__$1 = state_39939;
var statearr_39949_39959 = state_39939__$1;
(statearr_39949_39959[(2)] = inst_39934);

(statearr_39949_39959[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto____0 = (function (){
var statearr_39950 = [null,null,null,null,null,null,null];
(statearr_39950[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto__);

(statearr_39950[(1)] = (1));

return statearr_39950;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto____1 = (function (state_39939){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_39939);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e39951){var ex__10801__auto__ = e39951;
var statearr_39952_39960 = state_39939;
(statearr_39952_39960[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_39939[(4)]))){
var statearr_39953_39961 = state_39939;
(statearr_39953_39961[(1)] = cljs.core.first((state_39939[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__39962 = state_39939;
state_39939 = G__39962;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto__ = function(state_39939){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto____1.call(this,state_39939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_39954 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_39954[(6)] = c__10835__auto__);

return statearr_39954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_39979){
var state_val_39980 = (state_39979[(1)]);
if((state_val_39980 === (1))){
var state_39979__$1 = state_39979;
var statearr_39981_39995 = state_39979__$1;
(statearr_39981_39995[(2)] = null);

(statearr_39981_39995[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (2))){
var _ = (function (){var statearr_39982 = state_39979;
(statearr_39982[(4)] = cljs.core.cons((5),(state_39979[(4)])));

return statearr_39982;
})();
var inst_39969 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39970 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39971 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_39970,inst_39969);
var state_39979__$1 = state_39979;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39979__$1,(6),inst_39971);
} else {
if((state_val_39980 === (3))){
var inst_39977 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39979__$1,inst_39977);
} else {
if((state_val_39980 === (4))){
var inst_39963 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
var statearr_39984_39996 = state_39979__$1;
(statearr_39984_39996[(2)] = inst_39963);

(statearr_39984_39996[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (5))){
var _ = (function (){var statearr_39985 = state_39979;
(statearr_39985[(4)] = cljs.core.rest((state_39979[(4)])));

return statearr_39985;
})();
var state_39979__$1 = state_39979;
var ex39983 = (state_39979__$1[(2)]);
var statearr_39986_39997 = state_39979__$1;
(statearr_39986_39997[(5)] = ex39983);


if((ex39983 instanceof Error)){
var statearr_39987_39998 = state_39979__$1;
(statearr_39987_39998[(1)] = (4));

(statearr_39987_39998[(5)] = null);

} else {
throw ex39983;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (6))){
var inst_39973 = (state_39979[(2)]);
var inst_39974 = fluree.db.util.async.throw_err(inst_39973);
var _ = (function (){var statearr_39988 = state_39979;
(statearr_39988[(4)] = cljs.core.rest((state_39979[(4)])));

return statearr_39988;
})();
var state_39979__$1 = state_39979;
var statearr_39989_39999 = state_39979__$1;
(statearr_39989_39999[(2)] = inst_39974);

(statearr_39989_39999[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto____0 = (function (){
var statearr_39990 = [null,null,null,null,null,null,null];
(statearr_39990[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto__);

(statearr_39990[(1)] = (1));

return statearr_39990;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto____1 = (function (state_39979){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_39979);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e39991){var ex__10801__auto__ = e39991;
var statearr_39992_40000 = state_39979;
(statearr_39992_40000[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_39979[(4)]))){
var statearr_39993_40001 = state_39979;
(statearr_39993_40001[(1)] = cljs.core.first((state_39979[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__40002 = state_39979;
state_39979 = G__40002;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto__ = function(state_39979){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto____1.call(this,state_39979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_39994 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_39994[(6)] = c__10835__auto__);

return statearr_39994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__40003_SHARP_){
return p1__40003_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40004_SHARP_){
return p1__40004_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e40005){var e = e40005;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__40006_SHARP_){
return p1__40006_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40007_SHARP_){
return p1__40007_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e40008){var e = e40008;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__40010 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__40010);
})() | (0));
return num;
}catch (e40009){var e = e40009;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_40090){
var state_val_40091 = (state_40090[(1)]);
if((state_val_40091 === (7))){
var inst_40029 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_40030 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40031 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_40032 = cljs.core.PersistentHashMap.fromArrays(inst_40030,inst_40031);
var inst_40033 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40029,inst_40032);
var inst_40034 = (function(){throw inst_40033})();
var state_40090__$1 = state_40090;
var statearr_40092_40127 = state_40090__$1;
(statearr_40092_40127[(2)] = inst_40034);

(statearr_40092_40127[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (1))){
var state_40090__$1 = state_40090;
var statearr_40093_40128 = state_40090__$1;
(statearr_40093_40128[(2)] = null);

(statearr_40093_40128[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (4))){
var inst_40011 = (state_40090[(2)]);
var state_40090__$1 = state_40090;
var statearr_40094_40129 = state_40090__$1;
(statearr_40094_40129[(2)] = inst_40011);

(statearr_40094_40129[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (15))){
var inst_40074 = (state_40090[(7)]);
var inst_40070 = (state_40090[(2)]);
var inst_40071 = fluree.db.util.async.throw_err(inst_40070);
var inst_40072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40071,(0),null);
var inst_40073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40071,(1),null);
var inst_40074__$1 = cljs.core.first(inst_40072);
var inst_40075 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40074__$1,compare_val);
var state_40090__$1 = (function (){var statearr_40095 = state_40090;
(statearr_40095[(8)] = inst_40073);

(statearr_40095[(7)] = inst_40074__$1);

return statearr_40095;
})();
if(inst_40075){
var statearr_40096_40130 = state_40090__$1;
(statearr_40096_40130[(1)] = (16));

} else {
var statearr_40097_40131 = state_40090__$1;
(statearr_40097_40131[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (13))){
var state_40090__$1 = state_40090;
var statearr_40098_40132 = state_40090__$1;
(statearr_40098_40132[(2)] = null);

(statearr_40098_40132[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (6))){
var state_40090__$1 = state_40090;
var statearr_40099_40133 = state_40090__$1;
(statearr_40099_40133[(2)] = null);

(statearr_40099_40133[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (17))){
var inst_40074 = (state_40090[(7)]);
var inst_40078 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40074)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_40079 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40080 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_40081 = cljs.core.PersistentHashMap.fromArrays(inst_40079,inst_40080);
var inst_40082 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40078,inst_40081);
var inst_40083 = (function(){throw inst_40082})();
var state_40090__$1 = state_40090;
var statearr_40100_40134 = state_40090__$1;
(statearr_40100_40134[(2)] = inst_40083);

(statearr_40100_40134[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (3))){
var inst_40088 = (state_40090[(2)]);
var state_40090__$1 = state_40090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40090__$1,inst_40088);
} else {
if((state_val_40091 === (12))){
var inst_40026 = (state_40090[(9)]);
var inst_40049 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_40026], 0));
var inst_40050 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40051 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_40052 = cljs.core.PersistentHashMap.fromArrays(inst_40050,inst_40051);
var inst_40053 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40049,inst_40052);
var inst_40054 = (function(){throw inst_40053})();
var state_40090__$1 = state_40090;
var statearr_40101_40135 = state_40090__$1;
(statearr_40101_40135[(2)] = inst_40054);

(statearr_40101_40135[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (2))){
var inst_40025 = (state_40090[(10)]);
var inst_40024 = (state_40090[(11)]);
var inst_40023 = (state_40090[(12)]);
var _ = (function (){var statearr_40102 = state_40090;
(statearr_40102[(4)] = cljs.core.cons((5),(state_40090[(4)])));

return statearr_40102;
})();
var inst_40021 = _QMARK_ctx;
var inst_40022 = cljs.core.__destructure_map(inst_40021);
var inst_40023__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40022,cljs.core.cst$kw$sid);
var inst_40024__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40022,cljs.core.cst$kw$pid);
var inst_40025__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40022,cljs.core.cst$kw$db);
var inst_40026 = fluree.db.dbproto._p_prop(inst_40025__$1,cljs.core.cst$kw$name,inst_40024__$1);
var state_40090__$1 = (function (){var statearr_40103 = state_40090;
(statearr_40103[(10)] = inst_40025__$1);

(statearr_40103[(11)] = inst_40024__$1);

(statearr_40103[(12)] = inst_40023__$1);

(statearr_40103[(9)] = inst_40026);

return statearr_40103;
})();
if(cljs.core.truth_(inst_40023__$1)){
var statearr_40104_40136 = state_40090__$1;
(statearr_40104_40136[(1)] = (6));

} else {
var statearr_40105_40137 = state_40090__$1;
(statearr_40105_40137[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (11))){
var inst_40025 = (state_40090[(10)]);
var inst_40024 = (state_40090[(11)]);
var inst_40046 = (state_40090[(2)]);
var inst_40047 = fluree.db.dbproto._p_prop(inst_40025,cljs.core.cst$kw$multi,inst_40024);
var state_40090__$1 = (function (){var statearr_40107 = state_40090;
(statearr_40107[(13)] = inst_40046);

return statearr_40107;
})();
if(cljs.core.truth_(inst_40047)){
var statearr_40108_40138 = state_40090__$1;
(statearr_40108_40138[(1)] = (12));

} else {
var statearr_40109_40139 = state_40090__$1;
(statearr_40109_40139[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (9))){
var state_40090__$1 = state_40090;
var statearr_40110_40140 = state_40090__$1;
(statearr_40110_40140[(2)] = null);

(statearr_40110_40140[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (5))){
var _ = (function (){var statearr_40111 = state_40090;
(statearr_40111[(4)] = cljs.core.rest((state_40090[(4)])));

return statearr_40111;
})();
var state_40090__$1 = state_40090;
var ex40106 = (state_40090__$1[(2)]);
var statearr_40112_40141 = state_40090__$1;
(statearr_40112_40141[(5)] = ex40106);


if((ex40106 instanceof Error)){
var statearr_40113_40142 = state_40090__$1;
(statearr_40113_40142[(1)] = (4));

(statearr_40113_40142[(5)] = null);

} else {
throw ex40106;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (14))){
var inst_40025 = (state_40090[(10)]);
var inst_40023 = (state_40090[(12)]);
var inst_40026 = (state_40090[(9)]);
var inst_40057 = (state_40090[(2)]);
var inst_40058 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_40059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40061 = [inst_40023,inst_40026,"?current-val"];
var inst_40062 = (new cljs.core.PersistentVector(null,3,(5),inst_40060,inst_40061,null));
var inst_40063 = [inst_40062];
var inst_40064 = (new cljs.core.PersistentVector(null,1,(5),inst_40059,inst_40063,null));
var inst_40065 = cljs.core.PersistentHashMap.EMPTY;
var inst_40066 = ["?current-val",inst_40064,inst_40065];
var inst_40067 = cljs.core.PersistentHashMap.fromArrays(inst_40058,inst_40066);
var inst_40068 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_40025,inst_40067);
var state_40090__$1 = (function (){var statearr_40114 = state_40090;
(statearr_40114[(14)] = inst_40057);

return statearr_40114;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40090__$1,(15),inst_40068);
} else {
if((state_val_40091 === (16))){
var state_40090__$1 = state_40090;
var statearr_40115_40143 = state_40090__$1;
(statearr_40115_40143[(2)] = new_val);

(statearr_40115_40143[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (10))){
var inst_40039 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_40040 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40041 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_40042 = cljs.core.PersistentHashMap.fromArrays(inst_40040,inst_40041);
var inst_40043 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40039,inst_40042);
var inst_40044 = (function(){throw inst_40043})();
var state_40090__$1 = state_40090;
var statearr_40116_40144 = state_40090__$1;
(statearr_40116_40144[(2)] = inst_40044);

(statearr_40116_40144[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (18))){
var inst_40085 = (state_40090[(2)]);
var _ = (function (){var statearr_40117 = state_40090;
(statearr_40117[(4)] = cljs.core.rest((state_40090[(4)])));

return statearr_40117;
})();
var state_40090__$1 = state_40090;
var statearr_40118_40145 = state_40090__$1;
(statearr_40118_40145[(2)] = inst_40085);

(statearr_40118_40145[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40091 === (8))){
var inst_40026 = (state_40090[(9)]);
var inst_40036 = (state_40090[(2)]);
var state_40090__$1 = (function (){var statearr_40119 = state_40090;
(statearr_40119[(15)] = inst_40036);

return statearr_40119;
})();
if(cljs.core.truth_(inst_40026)){
var statearr_40120_40146 = state_40090__$1;
(statearr_40120_40146[(1)] = (9));

} else {
var statearr_40121_40147 = state_40090__$1;
(statearr_40121_40147[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto____0 = (function (){
var statearr_40122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40122[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto__);

(statearr_40122[(1)] = (1));

return statearr_40122;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto____1 = (function (state_40090){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_40090);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e40123){var ex__10801__auto__ = e40123;
var statearr_40124_40148 = state_40090;
(statearr_40124_40148[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_40090[(4)]))){
var statearr_40125_40149 = state_40090;
(statearr_40125_40149[(1)] = cljs.core.first((state_40090[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__40150 = state_40090;
state_40090 = G__40150;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto__ = function(state_40090){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto____1.call(this,state_40090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_40126 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_40126[(6)] = c__10835__auto__);

return statearr_40126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
