// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__10864 = s;
var map__10864__$1 = cljs.core.__destructure_map(map__10864);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10864__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10864__$1,cljs.core.cst$kw$info);
var d = (0);
var G__10866 = info;
var map__10867 = G__10866;
var map__10867__$1 = cljs.core.__destructure_map(map__10867);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10867__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__10866__$1 = G__10866;
while(true){
var d__$2 = d__$1;
var map__10869 = G__10866__$1;
var map__10869__$1 = cljs.core.__destructure_map(map__10869);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10869__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__10870 = (d__$2 + (1));
var G__10871 = shadow__$1;
d__$1 = G__10870;
G__10866__$1 = G__10871;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__10872){
var map__10873 = p__10872;
var map__10873__$1 = cljs.core.__destructure_map(map__10873);
var name_var = map__10873__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10873__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10873__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__10874 = info;
var map__10874__$1 = cljs.core.__destructure_map(map__10874);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10874__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10874__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__10875 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__10875) : cljs.compiler.munge.call(null,G__10875));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__10877 = arguments.length;
switch (G__10877) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__10878 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11639,11639,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__10878.cljs$core$IFn$_invoke$arity$1 ? fexpr__10878.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__10878.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__10880 = cp;
switch (G__10880) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__10882_10886 = cljs.core.seq(s);
var chunk__10883_10887 = null;
var count__10884_10888 = (0);
var i__10885_10889 = (0);
while(true){
if((i__10885_10889 < count__10884_10888)){
var c_10890 = chunk__10883_10887.cljs$core$IIndexed$_nth$arity$2(null,i__10885_10889);
sb.append(cljs.compiler.escape_char(c_10890));


var G__10891 = seq__10882_10886;
var G__10892 = chunk__10883_10887;
var G__10893 = count__10884_10888;
var G__10894 = (i__10885_10889 + (1));
seq__10882_10886 = G__10891;
chunk__10883_10887 = G__10892;
count__10884_10888 = G__10893;
i__10885_10889 = G__10894;
continue;
} else {
var temp__5753__auto___10895 = cljs.core.seq(seq__10882_10886);
if(temp__5753__auto___10895){
var seq__10882_10896__$1 = temp__5753__auto___10895;
if(cljs.core.chunked_seq_QMARK_(seq__10882_10896__$1)){
var c__4649__auto___10897 = cljs.core.chunk_first(seq__10882_10896__$1);
var G__10898 = cljs.core.chunk_rest(seq__10882_10896__$1);
var G__10899 = c__4649__auto___10897;
var G__10900 = cljs.core.count(c__4649__auto___10897);
var G__10901 = (0);
seq__10882_10886 = G__10898;
chunk__10883_10887 = G__10899;
count__10884_10888 = G__10900;
i__10885_10889 = G__10901;
continue;
} else {
var c_10902 = cljs.core.first(seq__10882_10896__$1);
sb.append(cljs.compiler.escape_char(c_10902));


var G__10903 = cljs.core.next(seq__10882_10896__$1);
var G__10904 = null;
var G__10905 = (0);
var G__10906 = (0);
seq__10882_10886 = G__10903;
chunk__10883_10887 = G__10904;
count__10884_10888 = G__10905;
i__10885_10889 = G__10906;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__10907 = cljs.core.get_global_hierarchy;
return (fexpr__10907.cljs$core$IFn$_invoke$arity$0 ? fexpr__10907.cljs$core$IFn$_invoke$arity$0() : fexpr__10907.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__10908_10913 = ast;
var map__10908_10914__$1 = cljs.core.__destructure_map(map__10908_10913);
var env_10915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10908_10914__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_10915))){
var map__10909_10916 = env_10915;
var map__10909_10917__$1 = cljs.core.__destructure_map(map__10909_10916);
var line_10918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10909_10917__$1,cljs.core.cst$kw$line);
var column_10919 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10909_10917__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__10910 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__10912 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__10911 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__10911.cljs$core$IFn$_invoke$arity$1 ? fexpr__10911.cljs$core$IFn$_invoke$arity$1(G__10912) : fexpr__10911.call(null,G__10912));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__10910,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__10910;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_10918 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_10919)?(column_10919 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__10928 = arguments.length;
switch (G__10928) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___10935 = arguments.length;
var i__4830__auto___10936 = (0);
while(true){
if((i__4830__auto___10936 < len__4829__auto___10935)){
args_arr__4850__auto__.push((arguments[i__4830__auto___10936]));

var G__10937 = (i__4830__auto___10936 + (1));
i__4830__auto___10936 = G__10937;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_10938 = (function (){var G__10929 = a;
if((!(typeof a === 'string'))){
return G__10929.toString();
} else {
return G__10929;
}
})();
var temp__5757__auto___10939 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___10939 == null)){
} else {
var sm_data_10940 = temp__5757__auto___10939;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_10940,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__10920_SHARP_){
return (p1__10920_SHARP_ + s_10938.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_10938], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__10930 = cljs.core.seq(xs);
var chunk__10931 = null;
var count__10932 = (0);
var i__10933 = (0);
while(true){
if((i__10933 < count__10932)){
var x = chunk__10931.cljs$core$IIndexed$_nth$arity$2(null,i__10933);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__10941 = seq__10930;
var G__10942 = chunk__10931;
var G__10943 = count__10932;
var G__10944 = (i__10933 + (1));
seq__10930 = G__10941;
chunk__10931 = G__10942;
count__10932 = G__10943;
i__10933 = G__10944;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10930);
if(temp__5753__auto__){
var seq__10930__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10930__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__10930__$1);
var G__10945 = cljs.core.chunk_rest(seq__10930__$1);
var G__10946 = c__4649__auto__;
var G__10947 = cljs.core.count(c__4649__auto__);
var G__10948 = (0);
seq__10930 = G__10945;
chunk__10931 = G__10946;
count__10932 = G__10947;
i__10933 = G__10948;
continue;
} else {
var x = cljs.core.first(seq__10930__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__10949 = cljs.core.next(seq__10930__$1);
var G__10950 = null;
var G__10951 = (0);
var G__10952 = (0);
seq__10930 = G__10949;
chunk__10931 = G__10950;
count__10932 = G__10951;
i__10933 = G__10952;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq10922){
var G__10923 = cljs.core.first(seq10922);
var seq10922__$1 = cljs.core.next(seq10922);
var G__10924 = cljs.core.first(seq10922__$1);
var seq10922__$2 = cljs.core.next(seq10922__$1);
var G__10925 = cljs.core.first(seq10922__$2);
var seq10922__$3 = cljs.core.next(seq10922__$2);
var G__10926 = cljs.core.first(seq10922__$3);
var seq10922__$4 = cljs.core.next(seq10922__$3);
var G__10927 = cljs.core.first(seq10922__$4);
var seq10922__$5 = cljs.core.next(seq10922__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__10923,G__10924,G__10925,G__10926,G__10927,seq10922__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__10953){
var map__10954 = p__10953;
var map__10954__$1 = cljs.core.__destructure_map(map__10954);
var m = map__10954__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10954__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__10962 = arguments.length;
switch (G__10962) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___10968 = arguments.length;
var i__4830__auto___10969 = (0);
while(true){
if((i__4830__auto___10969 < len__4829__auto___10968)){
args_arr__4850__auto__.push((arguments[i__4830__auto___10969]));

var G__10970 = (i__4830__auto___10969 + (1));
i__4830__auto___10969 = G__10970;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__10963_10971 = cljs.core.seq(xs);
var chunk__10964_10972 = null;
var count__10965_10973 = (0);
var i__10966_10974 = (0);
while(true){
if((i__10966_10974 < count__10965_10973)){
var x_10975 = chunk__10964_10972.cljs$core$IIndexed$_nth$arity$2(null,i__10966_10974);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_10975);


var G__10976 = seq__10963_10971;
var G__10977 = chunk__10964_10972;
var G__10978 = count__10965_10973;
var G__10979 = (i__10966_10974 + (1));
seq__10963_10971 = G__10976;
chunk__10964_10972 = G__10977;
count__10965_10973 = G__10978;
i__10966_10974 = G__10979;
continue;
} else {
var temp__5753__auto___10980 = cljs.core.seq(seq__10963_10971);
if(temp__5753__auto___10980){
var seq__10963_10981__$1 = temp__5753__auto___10980;
if(cljs.core.chunked_seq_QMARK_(seq__10963_10981__$1)){
var c__4649__auto___10982 = cljs.core.chunk_first(seq__10963_10981__$1);
var G__10983 = cljs.core.chunk_rest(seq__10963_10981__$1);
var G__10984 = c__4649__auto___10982;
var G__10985 = cljs.core.count(c__4649__auto___10982);
var G__10986 = (0);
seq__10963_10971 = G__10983;
chunk__10964_10972 = G__10984;
count__10965_10973 = G__10985;
i__10966_10974 = G__10986;
continue;
} else {
var x_10987 = cljs.core.first(seq__10963_10981__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_10987);


var G__10988 = cljs.core.next(seq__10963_10981__$1);
var G__10989 = null;
var G__10990 = (0);
var G__10991 = (0);
seq__10963_10971 = G__10988;
chunk__10964_10972 = G__10989;
count__10965_10973 = G__10990;
i__10966_10974 = G__10991;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq10956){
var G__10957 = cljs.core.first(seq10956);
var seq10956__$1 = cljs.core.next(seq10956);
var G__10958 = cljs.core.first(seq10956__$1);
var seq10956__$2 = cljs.core.next(seq10956__$1);
var G__10959 = cljs.core.first(seq10956__$2);
var seq10956__$3 = cljs.core.next(seq10956__$2);
var G__10960 = cljs.core.first(seq10956__$3);
var seq10956__$4 = cljs.core.next(seq10956__$3);
var G__10961 = cljs.core.first(seq10956__$4);
var seq10956__$5 = cljs.core.next(seq10956__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__10957,G__10958,G__10959,G__10960,G__10961,seq10956__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4760__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__10992_10996 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__10993_10997 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__10994_10998 = true;
var _STAR_print_fn_STAR__temp_val__10995_10999 = (function (x__4761__auto__){
return sb__4760__auto__.append(x__4761__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__10994_10998);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__10995_10999);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__10993_10997);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__10992_10996);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4760__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__11000 = cljs.core.get_global_hierarchy;
return (fexpr__11000.cljs$core$IFn$_invoke$arity$0 ? fexpr__11000.cljs$core$IFn$_invoke$arity$0() : fexpr__11000.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__11001 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11001,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11001,(1),null);
var G__11004 = ns;
var G__11005 = name;
var G__11006 = (function (){
var G__11007 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__11007) : cljs.compiler.emit_constant.call(null,G__11007));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__11004,G__11005,G__11006) : cljs.compiler.emit_record_value.call(null,G__11004,G__11005,G__11006));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__11008 = cljs.core.keys(x);
var G__11009 = cljs.core.vals(x);
var G__11010 = cljs.compiler.emit_constants_comma_sep;
var G__11011 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__11008,G__11009,G__11010,G__11011) : cljs.compiler.emit_map.call(null,G__11008,G__11009,G__11010,G__11011));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__11012 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__11013 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__11012,G__11013) : cljs.compiler.emit_with_meta.call(null,G__11012,G__11013));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__11014 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11014,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11014,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11014,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__11017 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11017) : x.call(null,G__11017));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__11018 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11018) : x.call(null,G__11018));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__11020 = items;
var G__11021 = (function (p1__11019_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__11019_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__11020,G__11021) : cljs.compiler.emit_js_object.call(null,G__11020,G__11021));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__11023){
var map__11024 = p__11023;
var map__11024__$1 = cljs.core.__destructure_map(map__11024);
var ast = map__11024__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11024__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11024__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11024__$1,cljs.core.cst$kw$form);
var temp__5751__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__11025 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__11025__$1 = cljs.core.__destructure_map(map__11025);
var cenv = map__11025__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11025__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4223__auto__ = js_module_name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__11026 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4221__auto__ = (function (){var G__11027 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__11027) : cljs.compiler.es5_GT__EQ_.call(null,G__11027));
})();
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4221__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__11026,cljs.analyzer.es5_allowed);
} else {
return G__11026;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4223__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__11028 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__11028,reserved);
} else {
return G__11028;
}
})();
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__11029_11030 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__11029_11031__$1 = (((G__11029_11030 instanceof cljs.core.Keyword))?G__11029_11030.fqn:null);
switch (G__11029_11031__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4221__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__11033){
var map__11034 = p__11033;
var map__11034__$1 = cljs.core.__destructure_map(map__11034);
var arg = map__11034__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11034__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11034__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11034__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11034__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__11035 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__11035__$1 = cljs.core.__destructure_map(map__11035);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11035__$1,cljs.core.cst$kw$name);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__11036){
var map__11037 = p__11036;
var map__11037__$1 = cljs.core.__destructure_map(map__11037);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11037__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11037__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11037__$1,cljs.core.cst$kw$env);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__11038_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__11038_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__11039 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11039) : comma_sep.call(null,G__11039));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__11040 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11040) : comma_sep.call(null,G__11040));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__11041){
var map__11042 = p__11041;
var map__11042__$1 = cljs.core.__destructure_map(map__11042);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11042__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11042__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11042__$1,cljs.core.cst$kw$vals);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__11043){
var map__11044 = p__11043;
var map__11044__$1 = cljs.core.__destructure_map(map__11044);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11044__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11044__$1,cljs.core.cst$kw$env);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__11045_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__11045_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__11046 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11046) : comma_sep.call(null,G__11046));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__11047){
var map__11048 = p__11047;
var map__11048__$1 = cljs.core.__destructure_map(map__11048);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11048__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11048__$1,cljs.core.cst$kw$env);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___11071 = cljs.core.seq(items);
if(temp__5753__auto___11071){
var items_11072__$1 = temp__5753__auto___11071;
var vec__11049_11073 = items_11072__$1;
var seq__11050_11074 = cljs.core.seq(vec__11049_11073);
var first__11051_11075 = cljs.core.first(seq__11050_11074);
var seq__11050_11076__$1 = cljs.core.next(seq__11050_11074);
var vec__11052_11077 = first__11051_11075;
var k_11078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11052_11077,(0),null);
var v_11079 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11052_11077,(1),null);
var r_11080 = seq__11050_11076__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_11078),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11079) : emit_js_object_val.call(null,v_11079)));

var seq__11055_11081 = cljs.core.seq(r_11080);
var chunk__11056_11082 = null;
var count__11057_11083 = (0);
var i__11058_11084 = (0);
while(true){
if((i__11058_11084 < count__11057_11083)){
var vec__11065_11085 = chunk__11056_11082.cljs$core$IIndexed$_nth$arity$2(null,i__11058_11084);
var k_11086__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11065_11085,(0),null);
var v_11087__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11065_11085,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11086__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11087__$1) : emit_js_object_val.call(null,v_11087__$1)));


var G__11088 = seq__11055_11081;
var G__11089 = chunk__11056_11082;
var G__11090 = count__11057_11083;
var G__11091 = (i__11058_11084 + (1));
seq__11055_11081 = G__11088;
chunk__11056_11082 = G__11089;
count__11057_11083 = G__11090;
i__11058_11084 = G__11091;
continue;
} else {
var temp__5753__auto___11092__$1 = cljs.core.seq(seq__11055_11081);
if(temp__5753__auto___11092__$1){
var seq__11055_11093__$1 = temp__5753__auto___11092__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11055_11093__$1)){
var c__4649__auto___11094 = cljs.core.chunk_first(seq__11055_11093__$1);
var G__11095 = cljs.core.chunk_rest(seq__11055_11093__$1);
var G__11096 = c__4649__auto___11094;
var G__11097 = cljs.core.count(c__4649__auto___11094);
var G__11098 = (0);
seq__11055_11081 = G__11095;
chunk__11056_11082 = G__11096;
count__11057_11083 = G__11097;
i__11058_11084 = G__11098;
continue;
} else {
var vec__11068_11099 = cljs.core.first(seq__11055_11093__$1);
var k_11100__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11068_11099,(0),null);
var v_11101__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11068_11099,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11100__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11101__$1) : emit_js_object_val.call(null,v_11101__$1)));


var G__11102 = cljs.core.next(seq__11055_11093__$1);
var G__11103 = null;
var G__11104 = (0);
var G__11105 = (0);
seq__11055_11081 = G__11102;
chunk__11056_11082 = G__11103;
count__11057_11083 = G__11104;
i__11058_11084 = G__11105;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__11106){
var map__11107 = p__11106;
var map__11107__$1 = cljs.core.__destructure_map(map__11107);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11107__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11107__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11107__$1,cljs.core.cst$kw$env);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__11108){
var map__11109 = p__11108;
var map__11109__$1 = cljs.core.__destructure_map(map__11109);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11109__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11109__$1,cljs.core.cst$kw$env);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__11110){
var map__11111 = p__11110;
var map__11111__$1 = cljs.core.__destructure_map(map__11111);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11111__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__11112){
var map__11113 = p__11112;
var map__11113__$1 = cljs.core.__destructure_map(map__11113);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11113__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11113__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__11114 = cljs.analyzer.unwrap_quote(expr);
var map__11114__$1 = cljs.core.__destructure_map(map__11114);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11114__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11114__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11114__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const);
if(and__4221__auto__){
var and__4221__auto____$1 = form;
if(cljs.core.truth_(and__4221__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__11115 = cljs.analyzer.unwrap_quote(expr);
var map__11115__$1 = cljs.core.__destructure_map(map__11115);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11115__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11115__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11115__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4223__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4223__auto__ = (function (){var fexpr__11116 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__11116.cljs$core$IFn$_invoke$arity$1 ? fexpr__11116.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__11116.call(null,tag));
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__11117){
var map__11118 = p__11117;
var map__11118__$1 = cljs.core.__destructure_map(map__11118);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11118__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11118__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11118__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11118__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11118__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4223__auto__ = unchecked;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__11119){
var map__11120 = p__11119;
var map__11120__$1 = cljs.core.__destructure_map(map__11120);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11120__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11120__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11120__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11120__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__11121_11149 = cljs.core.seq(nodes);
var chunk__11122_11150 = null;
var count__11123_11151 = (0);
var i__11124_11152 = (0);
while(true){
if((i__11124_11152 < count__11123_11151)){
var map__11137_11153 = chunk__11122_11150.cljs$core$IIndexed$_nth$arity$2(null,i__11124_11152);
var map__11137_11154__$1 = cljs.core.__destructure_map(map__11137_11153);
var ts_11155 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11137_11154__$1,cljs.core.cst$kw$tests);
var map__11138_11156 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11137_11154__$1,cljs.core.cst$kw$then);
var map__11138_11157__$1 = cljs.core.__destructure_map(map__11138_11156);
var then_11158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11138_11157__$1,cljs.core.cst$kw$then);
var seq__11139_11159 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_11155));
var chunk__11140_11160 = null;
var count__11141_11161 = (0);
var i__11142_11162 = (0);
while(true){
if((i__11142_11162 < count__11141_11161)){
var test_11163 = chunk__11140_11160.cljs$core$IIndexed$_nth$arity$2(null,i__11142_11162);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11163,":");


var G__11164 = seq__11139_11159;
var G__11165 = chunk__11140_11160;
var G__11166 = count__11141_11161;
var G__11167 = (i__11142_11162 + (1));
seq__11139_11159 = G__11164;
chunk__11140_11160 = G__11165;
count__11141_11161 = G__11166;
i__11142_11162 = G__11167;
continue;
} else {
var temp__5753__auto___11168 = cljs.core.seq(seq__11139_11159);
if(temp__5753__auto___11168){
var seq__11139_11169__$1 = temp__5753__auto___11168;
if(cljs.core.chunked_seq_QMARK_(seq__11139_11169__$1)){
var c__4649__auto___11170 = cljs.core.chunk_first(seq__11139_11169__$1);
var G__11171 = cljs.core.chunk_rest(seq__11139_11169__$1);
var G__11172 = c__4649__auto___11170;
var G__11173 = cljs.core.count(c__4649__auto___11170);
var G__11174 = (0);
seq__11139_11159 = G__11171;
chunk__11140_11160 = G__11172;
count__11141_11161 = G__11173;
i__11142_11162 = G__11174;
continue;
} else {
var test_11175 = cljs.core.first(seq__11139_11169__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11175,":");


var G__11176 = cljs.core.next(seq__11139_11169__$1);
var G__11177 = null;
var G__11178 = (0);
var G__11179 = (0);
seq__11139_11159 = G__11176;
chunk__11140_11160 = G__11177;
count__11141_11161 = G__11178;
i__11142_11162 = G__11179;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11158);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11158);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11180 = seq__11121_11149;
var G__11181 = chunk__11122_11150;
var G__11182 = count__11123_11151;
var G__11183 = (i__11124_11152 + (1));
seq__11121_11149 = G__11180;
chunk__11122_11150 = G__11181;
count__11123_11151 = G__11182;
i__11124_11152 = G__11183;
continue;
} else {
var temp__5753__auto___11184 = cljs.core.seq(seq__11121_11149);
if(temp__5753__auto___11184){
var seq__11121_11185__$1 = temp__5753__auto___11184;
if(cljs.core.chunked_seq_QMARK_(seq__11121_11185__$1)){
var c__4649__auto___11186 = cljs.core.chunk_first(seq__11121_11185__$1);
var G__11187 = cljs.core.chunk_rest(seq__11121_11185__$1);
var G__11188 = c__4649__auto___11186;
var G__11189 = cljs.core.count(c__4649__auto___11186);
var G__11190 = (0);
seq__11121_11149 = G__11187;
chunk__11122_11150 = G__11188;
count__11123_11151 = G__11189;
i__11124_11152 = G__11190;
continue;
} else {
var map__11143_11191 = cljs.core.first(seq__11121_11185__$1);
var map__11143_11192__$1 = cljs.core.__destructure_map(map__11143_11191);
var ts_11193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11143_11192__$1,cljs.core.cst$kw$tests);
var map__11144_11194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11143_11192__$1,cljs.core.cst$kw$then);
var map__11144_11195__$1 = cljs.core.__destructure_map(map__11144_11194);
var then_11196 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11144_11195__$1,cljs.core.cst$kw$then);
var seq__11145_11197 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_11193));
var chunk__11146_11198 = null;
var count__11147_11199 = (0);
var i__11148_11200 = (0);
while(true){
if((i__11148_11200 < count__11147_11199)){
var test_11201 = chunk__11146_11198.cljs$core$IIndexed$_nth$arity$2(null,i__11148_11200);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11201,":");


var G__11202 = seq__11145_11197;
var G__11203 = chunk__11146_11198;
var G__11204 = count__11147_11199;
var G__11205 = (i__11148_11200 + (1));
seq__11145_11197 = G__11202;
chunk__11146_11198 = G__11203;
count__11147_11199 = G__11204;
i__11148_11200 = G__11205;
continue;
} else {
var temp__5753__auto___11206__$1 = cljs.core.seq(seq__11145_11197);
if(temp__5753__auto___11206__$1){
var seq__11145_11207__$1 = temp__5753__auto___11206__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11145_11207__$1)){
var c__4649__auto___11208 = cljs.core.chunk_first(seq__11145_11207__$1);
var G__11209 = cljs.core.chunk_rest(seq__11145_11207__$1);
var G__11210 = c__4649__auto___11208;
var G__11211 = cljs.core.count(c__4649__auto___11208);
var G__11212 = (0);
seq__11145_11197 = G__11209;
chunk__11146_11198 = G__11210;
count__11147_11199 = G__11211;
i__11148_11200 = G__11212;
continue;
} else {
var test_11213 = cljs.core.first(seq__11145_11207__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11213,":");


var G__11214 = cljs.core.next(seq__11145_11207__$1);
var G__11215 = null;
var G__11216 = (0);
var G__11217 = (0);
seq__11145_11197 = G__11214;
chunk__11146_11198 = G__11215;
count__11147_11199 = G__11216;
i__11148_11200 = G__11217;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11196);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11196);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11218 = cljs.core.next(seq__11121_11185__$1);
var G__11219 = null;
var G__11220 = (0);
var G__11221 = (0);
seq__11121_11149 = G__11218;
chunk__11122_11150 = G__11219;
count__11123_11151 = G__11220;
i__11124_11152 = G__11221;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__11222){
var map__11223 = p__11222;
var map__11223__$1 = cljs.core.__destructure_map(map__11223);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11223__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11223__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11227 = env;
var G__11228 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11227,G__11228) : cljs.compiler.resolve_type.call(null,G__11227,G__11228));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__11229 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11229,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11229,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__11224_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__11224_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__11224_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__11232 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__11232,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__11232;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11235 = env;
var G__11236 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11235,G__11236) : cljs.compiler.resolve_type.call(null,G__11235,G__11236));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11237_SHARP_){
return cljs.compiler.resolve_type(env,p1__11237_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__11238 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11239 = cljs.core.seq(vec__11238);
var first__11240 = cljs.core.first(seq__11239);
var seq__11239__$1 = cljs.core.next(seq__11239);
var p = first__11240;
var first__11240__$1 = cljs.core.first(seq__11239__$1);
var seq__11239__$2 = cljs.core.next(seq__11239__$1);
var ts = first__11240__$1;
var first__11240__$2 = cljs.core.first(seq__11239__$2);
var seq__11239__$3 = cljs.core.next(seq__11239__$2);
var n = first__11240__$2;
var xs = seq__11239__$3;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__11241 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11242 = cljs.core.seq(vec__11241);
var first__11243 = cljs.core.first(seq__11242);
var seq__11242__$1 = cljs.core.next(seq__11242);
var p = first__11243;
var first__11243__$1 = cljs.core.first(seq__11242__$1);
var seq__11242__$2 = cljs.core.next(seq__11242__$1);
var ts = first__11243__$1;
var xs = seq__11242__$2;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__11245 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__11244 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__11244.cljs$core$IFn$_invoke$arity$1 ? fexpr__11244.cljs$core$IFn$_invoke$arity$1(G__11245) : fexpr__11244.call(null,G__11245));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__11248 = arguments.length;
switch (G__11248) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__11256 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11246_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__11246_SHARP_);
} else {
return p1__11246_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__11257 = cljs.core.seq(vec__11256);
var first__11258 = cljs.core.first(seq__11257);
var seq__11257__$1 = cljs.core.next(seq__11257);
var x = first__11258;
var ys = seq__11257__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__11259 = cljs.core.seq(ys);
var chunk__11260 = null;
var count__11261 = (0);
var i__11262 = (0);
while(true){
if((i__11262 < count__11261)){
var next_line = chunk__11260.cljs$core$IIndexed$_nth$arity$2(null,i__11262);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11268 = seq__11259;
var G__11269 = chunk__11260;
var G__11270 = count__11261;
var G__11271 = (i__11262 + (1));
seq__11259 = G__11268;
chunk__11260 = G__11269;
count__11261 = G__11270;
i__11262 = G__11271;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11259);
if(temp__5753__auto__){
var seq__11259__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11259__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__11259__$1);
var G__11272 = cljs.core.chunk_rest(seq__11259__$1);
var G__11273 = c__4649__auto__;
var G__11274 = cljs.core.count(c__4649__auto__);
var G__11275 = (0);
seq__11259 = G__11272;
chunk__11260 = G__11273;
count__11261 = G__11274;
i__11262 = G__11275;
continue;
} else {
var next_line = cljs.core.first(seq__11259__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11276 = cljs.core.next(seq__11259__$1);
var G__11277 = null;
var G__11278 = (0);
var G__11279 = (0);
seq__11259 = G__11276;
chunk__11260 = G__11277;
count__11261 = G__11278;
i__11262 = G__11279;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__11263_11280 = cljs.core.seq(docs__$2);
var chunk__11264_11281 = null;
var count__11265_11282 = (0);
var i__11266_11283 = (0);
while(true){
if((i__11266_11283 < count__11265_11282)){
var e_11284 = chunk__11264_11281.cljs$core$IIndexed$_nth$arity$2(null,i__11266_11283);
if(cljs.core.truth_(e_11284)){
print_comment_lines(e_11284);
} else {
}


var G__11285 = seq__11263_11280;
var G__11286 = chunk__11264_11281;
var G__11287 = count__11265_11282;
var G__11288 = (i__11266_11283 + (1));
seq__11263_11280 = G__11285;
chunk__11264_11281 = G__11286;
count__11265_11282 = G__11287;
i__11266_11283 = G__11288;
continue;
} else {
var temp__5753__auto___11289 = cljs.core.seq(seq__11263_11280);
if(temp__5753__auto___11289){
var seq__11263_11290__$1 = temp__5753__auto___11289;
if(cljs.core.chunked_seq_QMARK_(seq__11263_11290__$1)){
var c__4649__auto___11291 = cljs.core.chunk_first(seq__11263_11290__$1);
var G__11292 = cljs.core.chunk_rest(seq__11263_11290__$1);
var G__11293 = c__4649__auto___11291;
var G__11294 = cljs.core.count(c__4649__auto___11291);
var G__11295 = (0);
seq__11263_11280 = G__11292;
chunk__11264_11281 = G__11293;
count__11265_11282 = G__11294;
i__11266_11283 = G__11295;
continue;
} else {
var e_11296 = cljs.core.first(seq__11263_11290__$1);
if(cljs.core.truth_(e_11296)){
print_comment_lines(e_11296);
} else {
}


var G__11297 = cljs.core.next(seq__11263_11290__$1);
var G__11298 = null;
var G__11299 = (0);
var G__11300 = (0);
seq__11263_11280 = G__11297;
chunk__11264_11281 = G__11298;
count__11265_11282 = G__11299;
i__11266_11283 = G__11300;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4221__auto__ = cljs.core.some((function (p1__11302_SHARP_){
return goog.string.startsWith(p1__11302_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = opts;
if(cljs.core.truth_(and__4221__auto____$1)){
var and__4221__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none);
if(and__4221__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4221__auto____$2;
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__11303){
var map__11304 = p__11303;
var map__11304__$1 = cljs.core.__destructure_map(map__11304);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11304__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4223__auto__ = init;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
return test;
} else {
return and__4221__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__11305){
var map__11306 = p__11305;
var map__11306__$1 = cljs.core.__destructure_map(map__11306);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11306__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11306__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11306__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__11307_11331 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__11308_11332 = null;
var count__11309_11333 = (0);
var i__11310_11334 = (0);
while(true){
if((i__11310_11334 < count__11309_11333)){
var vec__11317_11335 = chunk__11308_11332.cljs$core$IIndexed$_nth$arity$2(null,i__11310_11334);
var i_11336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11317_11335,(0),null);
var param_11337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11317_11335,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_11337);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__11338 = seq__11307_11331;
var G__11339 = chunk__11308_11332;
var G__11340 = count__11309_11333;
var G__11341 = (i__11310_11334 + (1));
seq__11307_11331 = G__11338;
chunk__11308_11332 = G__11339;
count__11309_11333 = G__11340;
i__11310_11334 = G__11341;
continue;
} else {
var temp__5753__auto___11342 = cljs.core.seq(seq__11307_11331);
if(temp__5753__auto___11342){
var seq__11307_11343__$1 = temp__5753__auto___11342;
if(cljs.core.chunked_seq_QMARK_(seq__11307_11343__$1)){
var c__4649__auto___11344 = cljs.core.chunk_first(seq__11307_11343__$1);
var G__11345 = cljs.core.chunk_rest(seq__11307_11343__$1);
var G__11346 = c__4649__auto___11344;
var G__11347 = cljs.core.count(c__4649__auto___11344);
var G__11348 = (0);
seq__11307_11331 = G__11345;
chunk__11308_11332 = G__11346;
count__11309_11333 = G__11347;
i__11310_11334 = G__11348;
continue;
} else {
var vec__11320_11349 = cljs.core.first(seq__11307_11343__$1);
var i_11350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11320_11349,(0),null);
var param_11351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11320_11349,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_11351);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__11352 = cljs.core.next(seq__11307_11343__$1);
var G__11353 = null;
var G__11354 = (0);
var G__11355 = (0);
seq__11307_11331 = G__11352;
chunk__11308_11332 = G__11353;
count__11309_11333 = G__11354;
i__11310_11334 = G__11355;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11323_11356 = cljs.core.seq(params);
var chunk__11324_11357 = null;
var count__11325_11358 = (0);
var i__11326_11359 = (0);
while(true){
if((i__11326_11359 < count__11325_11358)){
var param_11360 = chunk__11324_11357.cljs$core$IIndexed$_nth$arity$2(null,i__11326_11359);
cljs.compiler.emit(param_11360);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11360,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11361 = seq__11323_11356;
var G__11362 = chunk__11324_11357;
var G__11363 = count__11325_11358;
var G__11364 = (i__11326_11359 + (1));
seq__11323_11356 = G__11361;
chunk__11324_11357 = G__11362;
count__11325_11358 = G__11363;
i__11326_11359 = G__11364;
continue;
} else {
var temp__5753__auto___11365 = cljs.core.seq(seq__11323_11356);
if(temp__5753__auto___11365){
var seq__11323_11366__$1 = temp__5753__auto___11365;
if(cljs.core.chunked_seq_QMARK_(seq__11323_11366__$1)){
var c__4649__auto___11367 = cljs.core.chunk_first(seq__11323_11366__$1);
var G__11368 = cljs.core.chunk_rest(seq__11323_11366__$1);
var G__11369 = c__4649__auto___11367;
var G__11370 = cljs.core.count(c__4649__auto___11367);
var G__11371 = (0);
seq__11323_11356 = G__11368;
chunk__11324_11357 = G__11369;
count__11325_11358 = G__11370;
i__11326_11359 = G__11371;
continue;
} else {
var param_11372 = cljs.core.first(seq__11323_11366__$1);
cljs.compiler.emit(param_11372);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11372,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11373 = cljs.core.next(seq__11323_11366__$1);
var G__11374 = null;
var G__11375 = (0);
var G__11376 = (0);
seq__11323_11356 = G__11373;
chunk__11324_11357 = G__11374;
count__11325_11358 = G__11375;
i__11326_11359 = G__11376;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11327_11377 = cljs.core.seq(params);
var chunk__11328_11378 = null;
var count__11329_11379 = (0);
var i__11330_11380 = (0);
while(true){
if((i__11330_11380 < count__11329_11379)){
var param_11381 = chunk__11328_11378.cljs$core$IIndexed$_nth$arity$2(null,i__11330_11380);
cljs.compiler.emit(param_11381);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11381,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11382 = seq__11327_11377;
var G__11383 = chunk__11328_11378;
var G__11384 = count__11329_11379;
var G__11385 = (i__11330_11380 + (1));
seq__11327_11377 = G__11382;
chunk__11328_11378 = G__11383;
count__11329_11379 = G__11384;
i__11330_11380 = G__11385;
continue;
} else {
var temp__5753__auto___11386 = cljs.core.seq(seq__11327_11377);
if(temp__5753__auto___11386){
var seq__11327_11387__$1 = temp__5753__auto___11386;
if(cljs.core.chunked_seq_QMARK_(seq__11327_11387__$1)){
var c__4649__auto___11388 = cljs.core.chunk_first(seq__11327_11387__$1);
var G__11389 = cljs.core.chunk_rest(seq__11327_11387__$1);
var G__11390 = c__4649__auto___11388;
var G__11391 = cljs.core.count(c__4649__auto___11388);
var G__11392 = (0);
seq__11327_11377 = G__11389;
chunk__11328_11378 = G__11390;
count__11329_11379 = G__11391;
i__11330_11380 = G__11392;
continue;
} else {
var param_11393 = cljs.core.first(seq__11327_11387__$1);
cljs.compiler.emit(param_11393);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11393,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11394 = cljs.core.next(seq__11327_11387__$1);
var G__11395 = null;
var G__11396 = (0);
var G__11397 = (0);
seq__11327_11377 = G__11394;
chunk__11328_11378 = G__11395;
count__11329_11379 = G__11396;
i__11330_11380 = G__11397;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__11398 = cljs.core.seq(params);
var chunk__11399 = null;
var count__11400 = (0);
var i__11401 = (0);
while(true){
if((i__11401 < count__11400)){
var param = chunk__11399.cljs$core$IIndexed$_nth$arity$2(null,i__11401);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11402 = seq__11398;
var G__11403 = chunk__11399;
var G__11404 = count__11400;
var G__11405 = (i__11401 + (1));
seq__11398 = G__11402;
chunk__11399 = G__11403;
count__11400 = G__11404;
i__11401 = G__11405;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11398);
if(temp__5753__auto__){
var seq__11398__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11398__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__11398__$1);
var G__11406 = cljs.core.chunk_rest(seq__11398__$1);
var G__11407 = c__4649__auto__;
var G__11408 = cljs.core.count(c__4649__auto__);
var G__11409 = (0);
seq__11398 = G__11406;
chunk__11399 = G__11407;
count__11400 = G__11408;
i__11401 = G__11409;
continue;
} else {
var param = cljs.core.first(seq__11398__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11410 = cljs.core.next(seq__11398__$1);
var G__11411 = null;
var G__11412 = (0);
var G__11413 = (0);
seq__11398 = G__11410;
chunk__11399 = G__11411;
count__11400 = G__11412;
i__11401 = G__11413;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__11414){
var map__11415 = p__11414;
var map__11415__$1 = cljs.core.__destructure_map(map__11415);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11415__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11415__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11415__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11415__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11415__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11415__$1,cljs.core.cst$kw$recurs);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__11416){
var map__11417 = p__11416;
var map__11417__$1 = cljs.core.__destructure_map(map__11417);
var f = map__11417__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11417__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11417__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11417__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11417__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11417__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11417__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11417__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11417__$1,cljs.core.cst$kw$recurs);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_11426__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_11427 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_11426__$1);
var delegate_name_11428 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_11427),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_11428," = function (");

var seq__11418_11429 = cljs.core.seq(params);
var chunk__11419_11430 = null;
var count__11420_11431 = (0);
var i__11421_11432 = (0);
while(true){
if((i__11421_11432 < count__11420_11431)){
var param_11433 = chunk__11419_11430.cljs$core$IIndexed$_nth$arity$2(null,i__11421_11432);
cljs.compiler.emit(param_11433);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11433,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11434 = seq__11418_11429;
var G__11435 = chunk__11419_11430;
var G__11436 = count__11420_11431;
var G__11437 = (i__11421_11432 + (1));
seq__11418_11429 = G__11434;
chunk__11419_11430 = G__11435;
count__11420_11431 = G__11436;
i__11421_11432 = G__11437;
continue;
} else {
var temp__5753__auto___11438 = cljs.core.seq(seq__11418_11429);
if(temp__5753__auto___11438){
var seq__11418_11439__$1 = temp__5753__auto___11438;
if(cljs.core.chunked_seq_QMARK_(seq__11418_11439__$1)){
var c__4649__auto___11440 = cljs.core.chunk_first(seq__11418_11439__$1);
var G__11441 = cljs.core.chunk_rest(seq__11418_11439__$1);
var G__11442 = c__4649__auto___11440;
var G__11443 = cljs.core.count(c__4649__auto___11440);
var G__11444 = (0);
seq__11418_11429 = G__11441;
chunk__11419_11430 = G__11442;
count__11420_11431 = G__11443;
i__11421_11432 = G__11444;
continue;
} else {
var param_11445 = cljs.core.first(seq__11418_11439__$1);
cljs.compiler.emit(param_11445);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11445,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11446 = cljs.core.next(seq__11418_11439__$1);
var G__11447 = null;
var G__11448 = (0);
var G__11449 = (0);
seq__11418_11429 = G__11446;
chunk__11419_11430 = G__11447;
count__11420_11431 = G__11448;
i__11421_11432 = G__11449;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_11427," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_11450 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_11450,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_11428,".call(this,");

var seq__11422_11451 = cljs.core.seq(params);
var chunk__11423_11452 = null;
var count__11424_11453 = (0);
var i__11425_11454 = (0);
while(true){
if((i__11425_11454 < count__11424_11453)){
var param_11455 = chunk__11423_11452.cljs$core$IIndexed$_nth$arity$2(null,i__11425_11454);
cljs.compiler.emit(param_11455);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11455,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11456 = seq__11422_11451;
var G__11457 = chunk__11423_11452;
var G__11458 = count__11424_11453;
var G__11459 = (i__11425_11454 + (1));
seq__11422_11451 = G__11456;
chunk__11423_11452 = G__11457;
count__11424_11453 = G__11458;
i__11425_11454 = G__11459;
continue;
} else {
var temp__5753__auto___11460 = cljs.core.seq(seq__11422_11451);
if(temp__5753__auto___11460){
var seq__11422_11461__$1 = temp__5753__auto___11460;
if(cljs.core.chunked_seq_QMARK_(seq__11422_11461__$1)){
var c__4649__auto___11462 = cljs.core.chunk_first(seq__11422_11461__$1);
var G__11463 = cljs.core.chunk_rest(seq__11422_11461__$1);
var G__11464 = c__4649__auto___11462;
var G__11465 = cljs.core.count(c__4649__auto___11462);
var G__11466 = (0);
seq__11422_11451 = G__11463;
chunk__11423_11452 = G__11464;
count__11424_11453 = G__11465;
i__11425_11454 = G__11466;
continue;
} else {
var param_11467 = cljs.core.first(seq__11422_11461__$1);
cljs.compiler.emit(param_11467);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11467,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11468 = cljs.core.next(seq__11422_11461__$1);
var G__11469 = null;
var G__11470 = (0);
var G__11471 = (0);
seq__11422_11451 = G__11468;
chunk__11423_11452 = G__11469;
count__11424_11453 = G__11470;
i__11425_11454 = G__11471;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11427,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_11427,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_11426__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11427,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_11428,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_11427,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__11475){
var map__11476 = p__11475;
var map__11476__$1 = cljs.core.__destructure_map(map__11476);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11476__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11476__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11476__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11476__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11476__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11476__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11476__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11476__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__11472_SHARP_){
var and__4221__auto__ = p1__11472_SHARP_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__11472_SHARP_));
} else {
return and__4221__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4223__auto__ = in_loop;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_11528__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_11529 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_11528__$1);
var maxparams_11530 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_11531 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_11529),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_11532 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__11473_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__11473_SHARP_)));
}),cljs.core.seq(mmap_11531));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_11529," = null;");

var seq__11477_11533 = cljs.core.seq(ms_11532);
var chunk__11478_11534 = null;
var count__11479_11535 = (0);
var i__11480_11536 = (0);
while(true){
if((i__11480_11536 < count__11479_11535)){
var vec__11487_11537 = chunk__11478_11534.cljs$core$IIndexed$_nth$arity$2(null,i__11480_11536);
var n_11538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11487_11537,(0),null);
var meth_11539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11487_11537,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_11538," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11539))){
cljs.compiler.emit_variadic_fn_method(meth_11539);
} else {
cljs.compiler.emit_fn_method(meth_11539);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__11540 = seq__11477_11533;
var G__11541 = chunk__11478_11534;
var G__11542 = count__11479_11535;
var G__11543 = (i__11480_11536 + (1));
seq__11477_11533 = G__11540;
chunk__11478_11534 = G__11541;
count__11479_11535 = G__11542;
i__11480_11536 = G__11543;
continue;
} else {
var temp__5753__auto___11544 = cljs.core.seq(seq__11477_11533);
if(temp__5753__auto___11544){
var seq__11477_11545__$1 = temp__5753__auto___11544;
if(cljs.core.chunked_seq_QMARK_(seq__11477_11545__$1)){
var c__4649__auto___11546 = cljs.core.chunk_first(seq__11477_11545__$1);
var G__11547 = cljs.core.chunk_rest(seq__11477_11545__$1);
var G__11548 = c__4649__auto___11546;
var G__11549 = cljs.core.count(c__4649__auto___11546);
var G__11550 = (0);
seq__11477_11533 = G__11547;
chunk__11478_11534 = G__11548;
count__11479_11535 = G__11549;
i__11480_11536 = G__11550;
continue;
} else {
var vec__11490_11551 = cljs.core.first(seq__11477_11545__$1);
var n_11552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11490_11551,(0),null);
var meth_11553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11490_11551,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_11552," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11553))){
cljs.compiler.emit_variadic_fn_method(meth_11553);
} else {
cljs.compiler.emit_fn_method(meth_11553);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__11554 = cljs.core.next(seq__11477_11545__$1);
var G__11555 = null;
var G__11556 = (0);
var G__11557 = (0);
seq__11477_11533 = G__11554;
chunk__11478_11534 = G__11555;
count__11479_11535 = G__11556;
i__11480_11536 = G__11557;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11529," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_11530),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_11530)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_11530));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__11493_11558 = cljs.core.seq(ms_11532);
var chunk__11494_11559 = null;
var count__11495_11560 = (0);
var i__11496_11561 = (0);
while(true){
if((i__11496_11561 < count__11495_11560)){
var vec__11503_11562 = chunk__11494_11559.cljs$core$IIndexed$_nth$arity$2(null,i__11496_11561);
var n_11563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11503_11562,(0),null);
var meth_11564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11503_11562,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11564))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_11565 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_11565," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_11566 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_11565," = new cljs.core.IndexedSeq(",a_11566,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_11563,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_11530)),(((cljs.core.count(maxparams_11530) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_11565,");"], 0));
} else {
var pcnt_11567 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_11564));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_11567,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_11563,".call(this",(((pcnt_11567 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_11567,maxparams_11530)),null,(1),null)),(2),null))),");");
}


var G__11568 = seq__11493_11558;
var G__11569 = chunk__11494_11559;
var G__11570 = count__11495_11560;
var G__11571 = (i__11496_11561 + (1));
seq__11493_11558 = G__11568;
chunk__11494_11559 = G__11569;
count__11495_11560 = G__11570;
i__11496_11561 = G__11571;
continue;
} else {
var temp__5753__auto___11572 = cljs.core.seq(seq__11493_11558);
if(temp__5753__auto___11572){
var seq__11493_11573__$1 = temp__5753__auto___11572;
if(cljs.core.chunked_seq_QMARK_(seq__11493_11573__$1)){
var c__4649__auto___11574 = cljs.core.chunk_first(seq__11493_11573__$1);
var G__11575 = cljs.core.chunk_rest(seq__11493_11573__$1);
var G__11576 = c__4649__auto___11574;
var G__11577 = cljs.core.count(c__4649__auto___11574);
var G__11578 = (0);
seq__11493_11558 = G__11575;
chunk__11494_11559 = G__11576;
count__11495_11560 = G__11577;
i__11496_11561 = G__11578;
continue;
} else {
var vec__11506_11579 = cljs.core.first(seq__11493_11573__$1);
var n_11580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11506_11579,(0),null);
var meth_11581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11506_11579,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11581))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_11582 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_11582," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_11583 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_11582," = new cljs.core.IndexedSeq(",a_11583,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_11580,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_11530)),(((cljs.core.count(maxparams_11530) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_11582,");"], 0));
} else {
var pcnt_11584 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_11581));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_11584,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_11580,".call(this",(((pcnt_11584 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_11584,maxparams_11530)),null,(1),null)),(2),null))),");");
}


var G__11585 = cljs.core.next(seq__11493_11573__$1);
var G__11586 = null;
var G__11587 = (0);
var G__11588 = (0);
seq__11493_11558 = G__11585;
chunk__11494_11559 = G__11586;
count__11495_11560 = G__11587;
i__11496_11561 = G__11588;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_11589 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_11532)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_11589,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11529,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11529,".cljs$lang$applyTo = ",cljs.core.some((function (p1__11474_SHARP_){
var vec__11509 = p1__11474_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11509,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11509,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_11532),".cljs$lang$applyTo;");
} else {
}

var seq__11512_11590 = cljs.core.seq(ms_11532);
var chunk__11513_11591 = null;
var count__11514_11592 = (0);
var i__11515_11593 = (0);
while(true){
if((i__11515_11593 < count__11514_11592)){
var vec__11522_11594 = chunk__11513_11591.cljs$core$IIndexed$_nth$arity$2(null,i__11515_11593);
var n_11595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11522_11594,(0),null);
var meth_11596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11522_11594,(1),null);
var c_11597 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_11596));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11596))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11529,".cljs$core$IFn$_invoke$arity$variadic = ",n_11595,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_11529,".cljs$core$IFn$_invoke$arity$",c_11597," = ",n_11595,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__11598 = seq__11512_11590;
var G__11599 = chunk__11513_11591;
var G__11600 = count__11514_11592;
var G__11601 = (i__11515_11593 + (1));
seq__11512_11590 = G__11598;
chunk__11513_11591 = G__11599;
count__11514_11592 = G__11600;
i__11515_11593 = G__11601;
continue;
} else {
var temp__5753__auto___11602 = cljs.core.seq(seq__11512_11590);
if(temp__5753__auto___11602){
var seq__11512_11603__$1 = temp__5753__auto___11602;
if(cljs.core.chunked_seq_QMARK_(seq__11512_11603__$1)){
var c__4649__auto___11604 = cljs.core.chunk_first(seq__11512_11603__$1);
var G__11605 = cljs.core.chunk_rest(seq__11512_11603__$1);
var G__11606 = c__4649__auto___11604;
var G__11607 = cljs.core.count(c__4649__auto___11604);
var G__11608 = (0);
seq__11512_11590 = G__11605;
chunk__11513_11591 = G__11606;
count__11514_11592 = G__11607;
i__11515_11593 = G__11608;
continue;
} else {
var vec__11525_11609 = cljs.core.first(seq__11512_11603__$1);
var n_11610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11525_11609,(0),null);
var meth_11611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11525_11609,(1),null);
var c_11612 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_11611));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11611))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11529,".cljs$core$IFn$_invoke$arity$variadic = ",n_11610,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_11529,".cljs$core$IFn$_invoke$arity$",c_11612," = ",n_11610,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__11613 = cljs.core.next(seq__11512_11603__$1);
var G__11614 = null;
var G__11615 = (0);
var G__11616 = (0);
seq__11512_11590 = G__11613;
chunk__11513_11591 = G__11614;
count__11514_11592 = G__11615;
i__11515_11593 = G__11616;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_11529,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__11617){
var map__11618 = p__11617;
var map__11618__$1 = cljs.core.__destructure_map(map__11618);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11618__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11618__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11618__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__11619_11623 = cljs.core.seq(statements);
var chunk__11620_11624 = null;
var count__11621_11625 = (0);
var i__11622_11626 = (0);
while(true){
if((i__11622_11626 < count__11621_11625)){
var s_11627 = chunk__11620_11624.cljs$core$IIndexed$_nth$arity$2(null,i__11622_11626);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_11627);


var G__11628 = seq__11619_11623;
var G__11629 = chunk__11620_11624;
var G__11630 = count__11621_11625;
var G__11631 = (i__11622_11626 + (1));
seq__11619_11623 = G__11628;
chunk__11620_11624 = G__11629;
count__11621_11625 = G__11630;
i__11622_11626 = G__11631;
continue;
} else {
var temp__5753__auto___11632 = cljs.core.seq(seq__11619_11623);
if(temp__5753__auto___11632){
var seq__11619_11633__$1 = temp__5753__auto___11632;
if(cljs.core.chunked_seq_QMARK_(seq__11619_11633__$1)){
var c__4649__auto___11634 = cljs.core.chunk_first(seq__11619_11633__$1);
var G__11635 = cljs.core.chunk_rest(seq__11619_11633__$1);
var G__11636 = c__4649__auto___11634;
var G__11637 = cljs.core.count(c__4649__auto___11634);
var G__11638 = (0);
seq__11619_11623 = G__11635;
chunk__11620_11624 = G__11636;
count__11621_11625 = G__11637;
i__11622_11626 = G__11638;
continue;
} else {
var s_11639 = cljs.core.first(seq__11619_11633__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_11639);


var G__11640 = cljs.core.next(seq__11619_11633__$1);
var G__11641 = null;
var G__11642 = (0);
var G__11643 = (0);
seq__11619_11623 = G__11640;
chunk__11620_11624 = G__11641;
count__11621_11625 = G__11642;
i__11622_11626 = G__11643;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__11644){
var map__11645 = p__11644;
var map__11645__$1 = cljs.core.__destructure_map(map__11645);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11645__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11645__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11645__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11645__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11645__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__11646,is_loop){
var map__11647 = p__11646;
var map__11647__$1 = cljs.core.__destructure_map(map__11647);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11647__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11647__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11647__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__11648_11658 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__11649_11659 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__11649_11659);

try{var seq__11650_11660 = cljs.core.seq(bindings);
var chunk__11651_11661 = null;
var count__11652_11662 = (0);
var i__11653_11663 = (0);
while(true){
if((i__11653_11663 < count__11652_11662)){
var map__11656_11664 = chunk__11651_11661.cljs$core$IIndexed$_nth$arity$2(null,i__11653_11663);
var map__11656_11665__$1 = cljs.core.__destructure_map(map__11656_11664);
var binding_11666 = map__11656_11665__$1;
var init_11667 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11656_11665__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_11666);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_11667,";");


var G__11668 = seq__11650_11660;
var G__11669 = chunk__11651_11661;
var G__11670 = count__11652_11662;
var G__11671 = (i__11653_11663 + (1));
seq__11650_11660 = G__11668;
chunk__11651_11661 = G__11669;
count__11652_11662 = G__11670;
i__11653_11663 = G__11671;
continue;
} else {
var temp__5753__auto___11672 = cljs.core.seq(seq__11650_11660);
if(temp__5753__auto___11672){
var seq__11650_11673__$1 = temp__5753__auto___11672;
if(cljs.core.chunked_seq_QMARK_(seq__11650_11673__$1)){
var c__4649__auto___11674 = cljs.core.chunk_first(seq__11650_11673__$1);
var G__11675 = cljs.core.chunk_rest(seq__11650_11673__$1);
var G__11676 = c__4649__auto___11674;
var G__11677 = cljs.core.count(c__4649__auto___11674);
var G__11678 = (0);
seq__11650_11660 = G__11675;
chunk__11651_11661 = G__11676;
count__11652_11662 = G__11677;
i__11653_11663 = G__11678;
continue;
} else {
var map__11657_11679 = cljs.core.first(seq__11650_11673__$1);
var map__11657_11680__$1 = cljs.core.__destructure_map(map__11657_11679);
var binding_11681 = map__11657_11680__$1;
var init_11682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11657_11680__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_11681);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_11682,";");


var G__11683 = cljs.core.next(seq__11650_11673__$1);
var G__11684 = null;
var G__11685 = (0);
var G__11686 = (0);
seq__11650_11660 = G__11683;
chunk__11651_11661 = G__11684;
count__11652_11662 = G__11685;
i__11653_11663 = G__11686;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__11648_11658);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__11687){
var map__11688 = p__11687;
var map__11688__$1 = cljs.core.__destructure_map(map__11688);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11688__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11688__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11688__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4706__auto___11689 = cljs.core.count(exprs);
var i_11690 = (0);
while(true){
if((i_11690 < n__4706__auto___11689)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_11690) : temps.call(null,i_11690))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_11690) : exprs.call(null,i_11690)),";");

var G__11691 = (i_11690 + (1));
i_11690 = G__11691;
continue;
} else {
}
break;
}

var n__4706__auto___11692 = cljs.core.count(exprs);
var i_11693 = (0);
while(true){
if((i_11693 < n__4706__auto___11692)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_11693) : params.call(null,i_11693)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_11693) : temps.call(null,i_11693)),";");

var G__11694 = (i_11693 + (1));
i_11693 = G__11694;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__11695){
var map__11696 = p__11695;
var map__11696__$1 = cljs.core.__destructure_map(map__11696);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11696__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11696__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11696__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__11697_11705 = cljs.core.seq(bindings);
var chunk__11698_11706 = null;
var count__11699_11707 = (0);
var i__11700_11708 = (0);
while(true){
if((i__11700_11708 < count__11699_11707)){
var map__11703_11709 = chunk__11698_11706.cljs$core$IIndexed$_nth$arity$2(null,i__11700_11708);
var map__11703_11710__$1 = cljs.core.__destructure_map(map__11703_11709);
var binding_11711 = map__11703_11710__$1;
var init_11712 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11703_11710__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_11711)," = ",init_11712,";");


var G__11713 = seq__11697_11705;
var G__11714 = chunk__11698_11706;
var G__11715 = count__11699_11707;
var G__11716 = (i__11700_11708 + (1));
seq__11697_11705 = G__11713;
chunk__11698_11706 = G__11714;
count__11699_11707 = G__11715;
i__11700_11708 = G__11716;
continue;
} else {
var temp__5753__auto___11717 = cljs.core.seq(seq__11697_11705);
if(temp__5753__auto___11717){
var seq__11697_11718__$1 = temp__5753__auto___11717;
if(cljs.core.chunked_seq_QMARK_(seq__11697_11718__$1)){
var c__4649__auto___11719 = cljs.core.chunk_first(seq__11697_11718__$1);
var G__11720 = cljs.core.chunk_rest(seq__11697_11718__$1);
var G__11721 = c__4649__auto___11719;
var G__11722 = cljs.core.count(c__4649__auto___11719);
var G__11723 = (0);
seq__11697_11705 = G__11720;
chunk__11698_11706 = G__11721;
count__11699_11707 = G__11722;
i__11700_11708 = G__11723;
continue;
} else {
var map__11704_11724 = cljs.core.first(seq__11697_11718__$1);
var map__11704_11725__$1 = cljs.core.__destructure_map(map__11704_11724);
var binding_11726 = map__11704_11725__$1;
var init_11727 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11704_11725__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_11726)," = ",init_11727,";");


var G__11728 = cljs.core.next(seq__11697_11718__$1);
var G__11729 = null;
var G__11730 = (0);
var G__11731 = (0);
seq__11697_11705 = G__11728;
chunk__11698_11706 = G__11729;
count__11699_11707 = G__11730;
i__11700_11708 = G__11731;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__11734){
var map__11735 = p__11734;
var map__11735__$1 = cljs.core.__destructure_map(map__11735);
var expr = map__11735__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11735__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11735__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11735__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info));
if(and__4221__auto____$1){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4221__auto__ = protocol;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = tag;
if(cljs.core.truth_(and__4221__auto____$1)){
var or__4223__auto__ = (function (){var and__4221__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto____$2)){
var and__4221__auto____$3 = protocol;
if(cljs.core.truth_(and__4221__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4221__auto____$3;
}
} else {
return and__4221__auto____$2;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto____$2 = (function (){var or__4223__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4221__auto____$2)){
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
var and__4221__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4221__auto____$3){
var and__4221__auto____$4 = cljs.core.not((function (){var fexpr__11739 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__11739.cljs$core$IFn$_invoke$arity$1 ? fexpr__11739.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__11739.call(null,tag));
})());
if(and__4221__auto____$4){
var temp__5753__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4221__auto____$4;
}
} else {
return and__4221__auto____$3;
}
}
} else {
return and__4221__auto____$2;
}
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__11740 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__11740.cljs$core$IFn$_invoke$arity$1 ? fexpr__11740.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__11740.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__11736 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (arity > mfa);
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__11732_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__11732_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__11733_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__11733_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11736,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11736,(1),null);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_11743 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_11743,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_11744 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_11744,args)),(((mfa_11744 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_11744,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var G__11742 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__11741 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__11741.cljs$core$IFn$_invoke$arity$1 ? fexpr__11741.cljs$core$IFn$_invoke$arity$1(G__11742) : fexpr__11741.call(null,G__11742));
} else {
return and__4221__auto__;
}
})())){
var fprop_11745 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_11745," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_11745,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_11745," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_11745,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__11746){
var map__11747 = p__11746;
var map__11747__$1 = cljs.core.__destructure_map(map__11747);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11747__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11747__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11747__$1,cljs.core.cst$kw$env);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__11748){
var map__11749 = p__11748;
var map__11749__$1 = cljs.core.__destructure_map(map__11749);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11749__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11749__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11749__$1,cljs.core.cst$kw$env);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11750_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__11750_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__11751 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11751,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11751,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__11754 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__11754__$1 = cljs.core.__destructure_map(map__11754);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11754__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11754__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__11755 = options;
var map__11755__$1 = cljs.core.__destructure_map(map__11755);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11755__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11755__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11755__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__11756 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__11759 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__11759__$1 = cljs.core.__destructure_map(map__11759);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11759__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11759__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11756,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11756,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__11760_11788 = cljs.core.seq(libs_to_load);
var chunk__11761_11789 = null;
var count__11762_11790 = (0);
var i__11763_11791 = (0);
while(true){
if((i__11763_11791 < count__11762_11790)){
var lib_11792 = chunk__11761_11789.cljs$core$IIndexed$_nth$arity$2(null,i__11763_11791);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_11792)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11792),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11792),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11792),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11792),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_11792,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11792),"');");
}

}
}
}


var G__11793 = seq__11760_11788;
var G__11794 = chunk__11761_11789;
var G__11795 = count__11762_11790;
var G__11796 = (i__11763_11791 + (1));
seq__11760_11788 = G__11793;
chunk__11761_11789 = G__11794;
count__11762_11790 = G__11795;
i__11763_11791 = G__11796;
continue;
} else {
var temp__5753__auto___11797 = cljs.core.seq(seq__11760_11788);
if(temp__5753__auto___11797){
var seq__11760_11798__$1 = temp__5753__auto___11797;
if(cljs.core.chunked_seq_QMARK_(seq__11760_11798__$1)){
var c__4649__auto___11799 = cljs.core.chunk_first(seq__11760_11798__$1);
var G__11800 = cljs.core.chunk_rest(seq__11760_11798__$1);
var G__11801 = c__4649__auto___11799;
var G__11802 = cljs.core.count(c__4649__auto___11799);
var G__11803 = (0);
seq__11760_11788 = G__11800;
chunk__11761_11789 = G__11801;
count__11762_11790 = G__11802;
i__11763_11791 = G__11803;
continue;
} else {
var lib_11804 = cljs.core.first(seq__11760_11798__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_11804)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11804),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11804),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11804),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11804),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_11804,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11804),"');");
}

}
}
}


var G__11805 = cljs.core.next(seq__11760_11798__$1);
var G__11806 = null;
var G__11807 = (0);
var G__11808 = (0);
seq__11760_11788 = G__11805;
chunk__11761_11789 = G__11806;
count__11762_11790 = G__11807;
i__11763_11791 = G__11808;
continue;
}
} else {
}
}
break;
}

var seq__11764_11809 = cljs.core.seq(node_libs);
var chunk__11765_11810 = null;
var count__11766_11811 = (0);
var i__11767_11812 = (0);
while(true){
if((i__11767_11812 < count__11766_11811)){
var lib_11813 = chunk__11765_11810.cljs$core$IIndexed$_nth$arity$2(null,i__11767_11812);
var vec__11774_11814 = cljs.analyzer.lib_AMPERSAND_sublib(lib_11813);
var lib_SINGLEQUOTE__11815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11774_11814,(0),null);
var sublib_11816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11774_11814,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_11813)," = require('",lib_SINGLEQUOTE__11815,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_11816),";"], 0));


var G__11817 = seq__11764_11809;
var G__11818 = chunk__11765_11810;
var G__11819 = count__11766_11811;
var G__11820 = (i__11767_11812 + (1));
seq__11764_11809 = G__11817;
chunk__11765_11810 = G__11818;
count__11766_11811 = G__11819;
i__11767_11812 = G__11820;
continue;
} else {
var temp__5753__auto___11821 = cljs.core.seq(seq__11764_11809);
if(temp__5753__auto___11821){
var seq__11764_11822__$1 = temp__5753__auto___11821;
if(cljs.core.chunked_seq_QMARK_(seq__11764_11822__$1)){
var c__4649__auto___11823 = cljs.core.chunk_first(seq__11764_11822__$1);
var G__11824 = cljs.core.chunk_rest(seq__11764_11822__$1);
var G__11825 = c__4649__auto___11823;
var G__11826 = cljs.core.count(c__4649__auto___11823);
var G__11827 = (0);
seq__11764_11809 = G__11824;
chunk__11765_11810 = G__11825;
count__11766_11811 = G__11826;
i__11767_11812 = G__11827;
continue;
} else {
var lib_11828 = cljs.core.first(seq__11764_11822__$1);
var vec__11777_11829 = cljs.analyzer.lib_AMPERSAND_sublib(lib_11828);
var lib_SINGLEQUOTE__11830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11777_11829,(0),null);
var sublib_11831 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11777_11829,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_11828)," = require('",lib_SINGLEQUOTE__11830,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_11831),";"], 0));


var G__11832 = cljs.core.next(seq__11764_11822__$1);
var G__11833 = null;
var G__11834 = (0);
var G__11835 = (0);
seq__11764_11809 = G__11832;
chunk__11765_11810 = G__11833;
count__11766_11811 = G__11834;
i__11767_11812 = G__11835;
continue;
}
} else {
}
}
break;
}

var seq__11780_11836 = cljs.core.seq(global_exports_libs);
var chunk__11781_11837 = null;
var count__11782_11838 = (0);
var i__11783_11839 = (0);
while(true){
if((i__11783_11839 < count__11782_11838)){
var lib_11840 = chunk__11781_11837.cljs$core$IIndexed$_nth$arity$2(null,i__11783_11839);
var map__11786_11841 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_11840))));
var map__11786_11842__$1 = cljs.core.__destructure_map(map__11786_11841);
var global_exports_11843 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11786_11842__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_11843,lib_11840);


var G__11844 = seq__11780_11836;
var G__11845 = chunk__11781_11837;
var G__11846 = count__11782_11838;
var G__11847 = (i__11783_11839 + (1));
seq__11780_11836 = G__11844;
chunk__11781_11837 = G__11845;
count__11782_11838 = G__11846;
i__11783_11839 = G__11847;
continue;
} else {
var temp__5753__auto___11848 = cljs.core.seq(seq__11780_11836);
if(temp__5753__auto___11848){
var seq__11780_11849__$1 = temp__5753__auto___11848;
if(cljs.core.chunked_seq_QMARK_(seq__11780_11849__$1)){
var c__4649__auto___11850 = cljs.core.chunk_first(seq__11780_11849__$1);
var G__11851 = cljs.core.chunk_rest(seq__11780_11849__$1);
var G__11852 = c__4649__auto___11850;
var G__11853 = cljs.core.count(c__4649__auto___11850);
var G__11854 = (0);
seq__11780_11836 = G__11851;
chunk__11781_11837 = G__11852;
count__11782_11838 = G__11853;
i__11783_11839 = G__11854;
continue;
} else {
var lib_11855 = cljs.core.first(seq__11780_11849__$1);
var map__11787_11856 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_11855))));
var map__11787_11857__$1 = cljs.core.__destructure_map(map__11787_11856);
var global_exports_11858 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11787_11857__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_11858,lib_11855);


var G__11859 = cljs.core.next(seq__11780_11849__$1);
var G__11860 = null;
var G__11861 = (0);
var G__11862 = (0);
seq__11780_11836 = G__11859;
chunk__11781_11837 = G__11860;
count__11782_11838 = G__11861;
i__11783_11839 = G__11862;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__11863){
var map__11864 = p__11863;
var map__11864__$1 = cljs.core.__destructure_map(map__11864);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11864__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11864__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11864__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11864__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11864__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11864__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11864__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__11865){
var map__11866 = p__11865;
var map__11866__$1 = cljs.core.__destructure_map(map__11866);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11866__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11866__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11866__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11866__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11866__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11866__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11866__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__11867){
var map__11868 = p__11867;
var map__11868__$1 = cljs.core.__destructure_map(map__11868);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11868__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11868__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11868__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11868__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11868__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__11869_11893 = cljs.core.seq(protocols);
var chunk__11870_11894 = null;
var count__11871_11895 = (0);
var i__11872_11896 = (0);
while(true){
if((i__11872_11896 < count__11871_11895)){
var protocol_11897 = chunk__11870_11894.cljs$core$IIndexed$_nth$arity$2(null,i__11872_11896);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11897)),"}");


var G__11898 = seq__11869_11893;
var G__11899 = chunk__11870_11894;
var G__11900 = count__11871_11895;
var G__11901 = (i__11872_11896 + (1));
seq__11869_11893 = G__11898;
chunk__11870_11894 = G__11899;
count__11871_11895 = G__11900;
i__11872_11896 = G__11901;
continue;
} else {
var temp__5753__auto___11902 = cljs.core.seq(seq__11869_11893);
if(temp__5753__auto___11902){
var seq__11869_11903__$1 = temp__5753__auto___11902;
if(cljs.core.chunked_seq_QMARK_(seq__11869_11903__$1)){
var c__4649__auto___11904 = cljs.core.chunk_first(seq__11869_11903__$1);
var G__11905 = cljs.core.chunk_rest(seq__11869_11903__$1);
var G__11906 = c__4649__auto___11904;
var G__11907 = cljs.core.count(c__4649__auto___11904);
var G__11908 = (0);
seq__11869_11893 = G__11905;
chunk__11870_11894 = G__11906;
count__11871_11895 = G__11907;
i__11872_11896 = G__11908;
continue;
} else {
var protocol_11909 = cljs.core.first(seq__11869_11903__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11909)),"}");


var G__11910 = cljs.core.next(seq__11869_11903__$1);
var G__11911 = null;
var G__11912 = (0);
var G__11913 = (0);
seq__11869_11893 = G__11910;
chunk__11870_11894 = G__11911;
count__11871_11895 = G__11912;
i__11872_11896 = G__11913;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__11873_11914 = cljs.core.seq(fields__$1);
var chunk__11874_11915 = null;
var count__11875_11916 = (0);
var i__11876_11917 = (0);
while(true){
if((i__11876_11917 < count__11875_11916)){
var fld_11918 = chunk__11874_11915.cljs$core$IIndexed$_nth$arity$2(null,i__11876_11917);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_11918," = ",fld_11918,";");


var G__11919 = seq__11873_11914;
var G__11920 = chunk__11874_11915;
var G__11921 = count__11875_11916;
var G__11922 = (i__11876_11917 + (1));
seq__11873_11914 = G__11919;
chunk__11874_11915 = G__11920;
count__11875_11916 = G__11921;
i__11876_11917 = G__11922;
continue;
} else {
var temp__5753__auto___11923 = cljs.core.seq(seq__11873_11914);
if(temp__5753__auto___11923){
var seq__11873_11924__$1 = temp__5753__auto___11923;
if(cljs.core.chunked_seq_QMARK_(seq__11873_11924__$1)){
var c__4649__auto___11925 = cljs.core.chunk_first(seq__11873_11924__$1);
var G__11926 = cljs.core.chunk_rest(seq__11873_11924__$1);
var G__11927 = c__4649__auto___11925;
var G__11928 = cljs.core.count(c__4649__auto___11925);
var G__11929 = (0);
seq__11873_11914 = G__11926;
chunk__11874_11915 = G__11927;
count__11875_11916 = G__11928;
i__11876_11917 = G__11929;
continue;
} else {
var fld_11930 = cljs.core.first(seq__11873_11924__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_11930," = ",fld_11930,";");


var G__11931 = cljs.core.next(seq__11873_11924__$1);
var G__11932 = null;
var G__11933 = (0);
var G__11934 = (0);
seq__11873_11914 = G__11931;
chunk__11874_11915 = G__11932;
count__11875_11916 = G__11933;
i__11876_11917 = G__11934;
continue;
}
} else {
}
}
break;
}

var seq__11877_11935 = cljs.core.seq(pmasks);
var chunk__11878_11936 = null;
var count__11879_11937 = (0);
var i__11880_11938 = (0);
while(true){
if((i__11880_11938 < count__11879_11937)){
var vec__11887_11939 = chunk__11878_11936.cljs$core$IIndexed$_nth$arity$2(null,i__11880_11938);
var pno_11940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11887_11939,(0),null);
var pmask_11941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11887_11939,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_11940,"$ = ",pmask_11941,";");


var G__11942 = seq__11877_11935;
var G__11943 = chunk__11878_11936;
var G__11944 = count__11879_11937;
var G__11945 = (i__11880_11938 + (1));
seq__11877_11935 = G__11942;
chunk__11878_11936 = G__11943;
count__11879_11937 = G__11944;
i__11880_11938 = G__11945;
continue;
} else {
var temp__5753__auto___11946 = cljs.core.seq(seq__11877_11935);
if(temp__5753__auto___11946){
var seq__11877_11947__$1 = temp__5753__auto___11946;
if(cljs.core.chunked_seq_QMARK_(seq__11877_11947__$1)){
var c__4649__auto___11948 = cljs.core.chunk_first(seq__11877_11947__$1);
var G__11949 = cljs.core.chunk_rest(seq__11877_11947__$1);
var G__11950 = c__4649__auto___11948;
var G__11951 = cljs.core.count(c__4649__auto___11948);
var G__11952 = (0);
seq__11877_11935 = G__11949;
chunk__11878_11936 = G__11950;
count__11879_11937 = G__11951;
i__11880_11938 = G__11952;
continue;
} else {
var vec__11890_11953 = cljs.core.first(seq__11877_11947__$1);
var pno_11954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11890_11953,(0),null);
var pmask_11955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11890_11953,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_11954,"$ = ",pmask_11955,";");


var G__11956 = cljs.core.next(seq__11877_11947__$1);
var G__11957 = null;
var G__11958 = (0);
var G__11959 = (0);
seq__11877_11935 = G__11956;
chunk__11878_11936 = G__11957;
count__11879_11937 = G__11958;
i__11880_11938 = G__11959;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__11960){
var map__11961 = p__11960;
var map__11961__$1 = cljs.core.__destructure_map(map__11961);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11961__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11961__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11961__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11961__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11961__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__11962_11986 = cljs.core.seq(protocols);
var chunk__11963_11987 = null;
var count__11964_11988 = (0);
var i__11965_11989 = (0);
while(true){
if((i__11965_11989 < count__11964_11988)){
var protocol_11990 = chunk__11963_11987.cljs$core$IIndexed$_nth$arity$2(null,i__11965_11989);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11990)),"}");


var G__11991 = seq__11962_11986;
var G__11992 = chunk__11963_11987;
var G__11993 = count__11964_11988;
var G__11994 = (i__11965_11989 + (1));
seq__11962_11986 = G__11991;
chunk__11963_11987 = G__11992;
count__11964_11988 = G__11993;
i__11965_11989 = G__11994;
continue;
} else {
var temp__5753__auto___11995 = cljs.core.seq(seq__11962_11986);
if(temp__5753__auto___11995){
var seq__11962_11996__$1 = temp__5753__auto___11995;
if(cljs.core.chunked_seq_QMARK_(seq__11962_11996__$1)){
var c__4649__auto___11997 = cljs.core.chunk_first(seq__11962_11996__$1);
var G__11998 = cljs.core.chunk_rest(seq__11962_11996__$1);
var G__11999 = c__4649__auto___11997;
var G__12000 = cljs.core.count(c__4649__auto___11997);
var G__12001 = (0);
seq__11962_11986 = G__11998;
chunk__11963_11987 = G__11999;
count__11964_11988 = G__12000;
i__11965_11989 = G__12001;
continue;
} else {
var protocol_12002 = cljs.core.first(seq__11962_11996__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12002)),"}");


var G__12003 = cljs.core.next(seq__11962_11996__$1);
var G__12004 = null;
var G__12005 = (0);
var G__12006 = (0);
seq__11962_11986 = G__12003;
chunk__11963_11987 = G__12004;
count__11964_11988 = G__12005;
i__11965_11989 = G__12006;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__11966_12007 = cljs.core.seq(fields__$1);
var chunk__11967_12008 = null;
var count__11968_12009 = (0);
var i__11969_12010 = (0);
while(true){
if((i__11969_12010 < count__11968_12009)){
var fld_12011 = chunk__11967_12008.cljs$core$IIndexed$_nth$arity$2(null,i__11969_12010);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12011," = ",fld_12011,";");


var G__12012 = seq__11966_12007;
var G__12013 = chunk__11967_12008;
var G__12014 = count__11968_12009;
var G__12015 = (i__11969_12010 + (1));
seq__11966_12007 = G__12012;
chunk__11967_12008 = G__12013;
count__11968_12009 = G__12014;
i__11969_12010 = G__12015;
continue;
} else {
var temp__5753__auto___12016 = cljs.core.seq(seq__11966_12007);
if(temp__5753__auto___12016){
var seq__11966_12017__$1 = temp__5753__auto___12016;
if(cljs.core.chunked_seq_QMARK_(seq__11966_12017__$1)){
var c__4649__auto___12018 = cljs.core.chunk_first(seq__11966_12017__$1);
var G__12019 = cljs.core.chunk_rest(seq__11966_12017__$1);
var G__12020 = c__4649__auto___12018;
var G__12021 = cljs.core.count(c__4649__auto___12018);
var G__12022 = (0);
seq__11966_12007 = G__12019;
chunk__11967_12008 = G__12020;
count__11968_12009 = G__12021;
i__11969_12010 = G__12022;
continue;
} else {
var fld_12023 = cljs.core.first(seq__11966_12017__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12023," = ",fld_12023,";");


var G__12024 = cljs.core.next(seq__11966_12017__$1);
var G__12025 = null;
var G__12026 = (0);
var G__12027 = (0);
seq__11966_12007 = G__12024;
chunk__11967_12008 = G__12025;
count__11968_12009 = G__12026;
i__11969_12010 = G__12027;
continue;
}
} else {
}
}
break;
}

var seq__11970_12028 = cljs.core.seq(pmasks);
var chunk__11971_12029 = null;
var count__11972_12030 = (0);
var i__11973_12031 = (0);
while(true){
if((i__11973_12031 < count__11972_12030)){
var vec__11980_12032 = chunk__11971_12029.cljs$core$IIndexed$_nth$arity$2(null,i__11973_12031);
var pno_12033 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11980_12032,(0),null);
var pmask_12034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11980_12032,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12033,"$ = ",pmask_12034,";");


var G__12035 = seq__11970_12028;
var G__12036 = chunk__11971_12029;
var G__12037 = count__11972_12030;
var G__12038 = (i__11973_12031 + (1));
seq__11970_12028 = G__12035;
chunk__11971_12029 = G__12036;
count__11972_12030 = G__12037;
i__11973_12031 = G__12038;
continue;
} else {
var temp__5753__auto___12039 = cljs.core.seq(seq__11970_12028);
if(temp__5753__auto___12039){
var seq__11970_12040__$1 = temp__5753__auto___12039;
if(cljs.core.chunked_seq_QMARK_(seq__11970_12040__$1)){
var c__4649__auto___12041 = cljs.core.chunk_first(seq__11970_12040__$1);
var G__12042 = cljs.core.chunk_rest(seq__11970_12040__$1);
var G__12043 = c__4649__auto___12041;
var G__12044 = cljs.core.count(c__4649__auto___12041);
var G__12045 = (0);
seq__11970_12028 = G__12042;
chunk__11971_12029 = G__12043;
count__11972_12030 = G__12044;
i__11973_12031 = G__12045;
continue;
} else {
var vec__11983_12046 = cljs.core.first(seq__11970_12040__$1);
var pno_12047 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11983_12046,(0),null);
var pmask_12048 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11983_12046,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12047,"$ = ",pmask_12048,";");


var G__12049 = cljs.core.next(seq__11970_12040__$1);
var G__12050 = null;
var G__12051 = (0);
var G__12052 = (0);
seq__11970_12028 = G__12049;
chunk__11971_12029 = G__12050;
count__11972_12030 = G__12051;
i__11973_12031 = G__12052;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__12053){
var map__12054 = p__12053;
var map__12054__$1 = cljs.core.__destructure_map(map__12054);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12054__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12054__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12054__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12054__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12054__$1,cljs.core.cst$kw$env);
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__12055){
var map__12056 = p__12055;
var map__12056__$1 = cljs.core.__destructure_map(map__12056);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12056__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12056__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12056__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12056__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12056__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4221__auto__ = code;
if(cljs.core.truth_(and__4221__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4221__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__9613__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9613__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__12061 = cljs.core.seq(table);
var chunk__12062 = null;
var count__12063 = (0);
var i__12064 = (0);
while(true){
if((i__12064 < count__12063)){
var vec__12071 = chunk__12062.cljs$core$IIndexed$_nth$arity$2(null,i__12064);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12071,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12071,(1),null);
var ns_12077 = cljs.core.namespace(sym);
var name_12078 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12079 = seq__12061;
var G__12080 = chunk__12062;
var G__12081 = count__12063;
var G__12082 = (i__12064 + (1));
seq__12061 = G__12079;
chunk__12062 = G__12080;
count__12063 = G__12081;
i__12064 = G__12082;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__12061);
if(temp__5753__auto__){
var seq__12061__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12061__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__12061__$1);
var G__12083 = cljs.core.chunk_rest(seq__12061__$1);
var G__12084 = c__4649__auto__;
var G__12085 = cljs.core.count(c__4649__auto__);
var G__12086 = (0);
seq__12061 = G__12083;
chunk__12062 = G__12084;
count__12063 = G__12085;
i__12064 = G__12086;
continue;
} else {
var vec__12074 = cljs.core.first(seq__12061__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12074,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12074,(1),null);
var ns_12087 = cljs.core.namespace(sym);
var name_12088 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12089 = cljs.core.next(seq__12061__$1);
var G__12090 = null;
var G__12091 = (0);
var G__12092 = (0);
seq__12061 = G__12089;
chunk__12062 = G__12090;
count__12063 = G__12091;
i__12064 = G__12092;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__12094 = arguments.length;
switch (G__12094) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_12099 = cljs.core.first(ks);
var vec__12095_12100 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_12099);
var top_12101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12095_12100,(0),null);
var prefix_SINGLEQUOTE__12102 = vec__12095_12100;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_12099)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__12102) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_12101)) || (cljs.core.contains_QMARK_(known_externs,top_12101)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12102)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_12101);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12102)),";");
}
} else {
}

var m_12103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_12099);
if(cljs.core.empty_QMARK_(m_12103)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__12102,m_12103,top_level,known_externs);
}

var G__12104 = cljs.core.next(ks);
ks = G__12104;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

