// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k27620,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__27624 = k27620;
var G__27624__$1 = (((G__27624 instanceof cljs.core.Keyword))?G__27624.fqn:null);
switch (G__27624__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27620,else__4475__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__27625){
var vec__27626 = p__27625;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27626,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27626,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27619){
var self__ = this;
var G__27619__$1 = this;
return (new cljs.core.RecordIter((0),G__27619__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__27629 = (function (coll__4469__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__27629(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27621,other27622){
var self__ = this;
var this27621__$1 = this;
return (((!((other27622 == null)))) && ((((this27621__$1.constructor === other27622.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.conn,other27622.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.network,other27622.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.dbid,other27622.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.db_name,other27622.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.update_chan,other27622.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.transact_chan,other27622.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.state,other27622.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.schema_cache,other27622.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.blank_db,other27622.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.close,other27622.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.id,other27622.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27621__$1.__extmap,other27622.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k27620){
var self__ = this;
var this__4479__auto____$1 = this;
var G__27630 = k27620;
var G__27630__$1 = (((G__27630 instanceof cljs.core.Keyword))?G__27630.fqn:null);
switch (G__27630__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27620);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__27619){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__27631 = cljs.core.keyword_identical_QMARK_;
var expr__27632 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__27634 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27635 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27634,G__27635) : pred__27631.call(null,G__27634,G__27635));
})())){
return (new fluree.db.session.DbSession(G__27619,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27636 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27637 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27636,G__27637) : pred__27631.call(null,G__27636,G__27637));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27619,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27638 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27639 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27638,G__27639) : pred__27631.call(null,G__27638,G__27639));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27619,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27640 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__27641 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27640,G__27641) : pred__27631.call(null,G__27640,G__27641));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27619,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27642 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__27643 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27642,G__27643) : pred__27631.call(null,G__27642,G__27643));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27619,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27644 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__27645 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27644,G__27645) : pred__27631.call(null,G__27644,G__27645));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27619,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27646 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__27647 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27646,G__27647) : pred__27631.call(null,G__27646,G__27647));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27619,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27648 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27649 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27648,G__27649) : pred__27631.call(null,G__27648,G__27649));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27619,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27650 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__27651 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27650,G__27651) : pred__27631.call(null,G__27650,G__27651));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27619,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27652 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__27653 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27652,G__27653) : pred__27631.call(null,G__27652,G__27653));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27619,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27654 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__27655 = expr__27632;
return (pred__27631.cljs$core$IFn$_invoke$arity$2 ? pred__27631.cljs$core$IFn$_invoke$arity$2(G__27654,G__27655) : pred__27631.call(null,G__27654,G__27655));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27619,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__27619),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__27619){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27619,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27623){
var extmap__4512__auto__ = (function (){var G__27656 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27623,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27623)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27656);
} else {
return G__27656;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27623),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27623),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27659 = session;
var map__27659__$1 = cljs.core.__destructure_map(map__27659);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27659__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27659__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___27811 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27763){
var state_val_27764 = (state_27763[(1)]);
if((state_val_27764 === (7))){
var inst_27680 = (state_27763[(7)]);
var inst_27685 = cljs.core.empty_QMARK_(inst_27680);
var state_27763__$1 = state_27763;
if(inst_27685){
var statearr_27765_27812 = state_27763__$1;
(statearr_27765_27812[(1)] = (10));

} else {
var statearr_27766_27813 = state_27763__$1;
(statearr_27766_27813[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (20))){
var inst_27673 = (state_27763[(8)]);
var inst_27711 = (state_27763[(9)]);
var inst_27672 = (state_27763[(10)]);
var inst_27671 = (state_27763[(11)]);
var inst_27716 = fluree.db.storage.core.read_block(inst_27671,inst_27672,inst_27673,inst_27711);
var state_27763__$1 = state_27763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27763__$1,(22),inst_27716);
} else {
if((state_val_27764 === (27))){
var inst_27747 = (state_27763[(12)]);
var inst_27752 = (state_27763[(13)]);
var inst_27750 = (state_27763[(2)]);
var inst_27751 = fluree.db.util.async.throw_err(inst_27750);
var inst_27752__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27747,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27751);
var inst_27753 = fluree.db.query.schema.setting_map(inst_27752__$1);
var state_27763__$1 = (function (){var statearr_27767 = state_27763;
(statearr_27767[(13)] = inst_27752__$1);

return statearr_27767;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27763__$1,(28),inst_27753);
} else {
if((state_val_27764 === (1))){
var state_27763__$1 = state_27763;
var statearr_27768_27814 = state_27763__$1;
(statearr_27768_27814[(2)] = null);

(statearr_27768_27814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (24))){
var inst_27673 = (state_27763[(8)]);
var inst_27711 = (state_27763[(9)]);
var inst_27672 = (state_27763[(10)]);
var inst_27733 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27711)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27672),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27673),"."].join('');
var inst_27734 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27735 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27736 = cljs.core.PersistentHashMap.fromArrays(inst_27734,inst_27735);
var inst_27737 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27733,inst_27736);
var inst_27738 = (function(){throw inst_27737})();
var state_27763__$1 = state_27763;
var statearr_27769_27815 = state_27763__$1;
(statearr_27769_27815[(2)] = inst_27738);

(statearr_27769_27815[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (4))){
var inst_27660 = (state_27763[(2)]);
var inst_27661 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27660);
var state_27763__$1 = state_27763;
var statearr_27770_27816 = state_27763__$1;
(statearr_27770_27816[(2)] = inst_27661);

(statearr_27770_27816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (15))){
var state_27763__$1 = state_27763;
var statearr_27771_27817 = state_27763__$1;
(statearr_27771_27817[(2)] = null);

(statearr_27771_27817[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (21))){
var inst_27742 = (state_27763[(2)]);
var state_27763__$1 = state_27763;
var statearr_27772_27818 = state_27763__$1;
(statearr_27772_27818[(2)] = inst_27742);

(statearr_27772_27818[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (13))){
var inst_27680 = (state_27763[(7)]);
var inst_27705 = (state_27763[(14)]);
var inst_27704 = (state_27763[(2)]);
var inst_27705__$1 = fluree.db.util.async.throw_err(inst_27704);
var inst_27706 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27680);
var state_27763__$1 = (function (){var statearr_27773 = state_27763;
(statearr_27773[(15)] = inst_27706);

(statearr_27773[(14)] = inst_27705__$1);

return statearr_27773;
})();
if(cljs.core.truth_(inst_27705__$1)){
var statearr_27774_27819 = state_27763__$1;
(statearr_27774_27819[(1)] = (14));

} else {
var statearr_27775_27820 = state_27763__$1;
(statearr_27775_27820[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (22))){
var inst_27719 = (state_27763[(16)]);
var inst_27718 = (state_27763[(2)]);
var inst_27719__$1 = fluree.db.util.async.throw_err(inst_27718);
var state_27763__$1 = (function (){var statearr_27776 = state_27763;
(statearr_27776[(16)] = inst_27719__$1);

return statearr_27776;
})();
if(cljs.core.truth_(inst_27719__$1)){
var statearr_27777_27821 = state_27763__$1;
(statearr_27777_27821[(1)] = (23));

} else {
var statearr_27778_27822 = state_27763__$1;
(statearr_27778_27822[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (6))){
var inst_27680 = (state_27763[(7)]);
var inst_27679 = (state_27763[(2)]);
var inst_27680__$1 = fluree.db.util.async.throw_err(inst_27679);
var inst_27681 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27680__$1);
var inst_27682 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_27681);
var inst_27683 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27682);
var state_27763__$1 = (function (){var statearr_27779 = state_27763;
(statearr_27779[(7)] = inst_27680__$1);

return statearr_27779;
})();
if(inst_27683){
var statearr_27780_27823 = state_27763__$1;
(statearr_27780_27823[(1)] = (7));

} else {
var statearr_27781_27824 = state_27763__$1;
(statearr_27781_27824[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (28))){
var inst_27752 = (state_27763[(13)]);
var inst_27755 = (state_27763[(2)]);
var inst_27756 = fluree.db.util.async.throw_err(inst_27755);
var inst_27757 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27752,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27756);
var inst_27758 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27757);
var _ = (function (){var statearr_27782 = state_27763;
(statearr_27782[(4)] = cljs.core.rest((state_27763[(4)])));

return statearr_27782;
})();
var state_27763__$1 = state_27763;
var statearr_27783_27825 = state_27763__$1;
(statearr_27783_27825[(2)] = inst_27758);

(statearr_27783_27825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (25))){
var inst_27740 = (state_27763[(2)]);
var state_27763__$1 = state_27763;
var statearr_27784_27826 = state_27763__$1;
(statearr_27784_27826[(2)] = inst_27740);

(statearr_27784_27826[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (17))){
var inst_27706 = (state_27763[(15)]);
var inst_27711 = (state_27763[(9)]);
var inst_27713 = (inst_27711 > inst_27706);
var state_27763__$1 = state_27763;
if(cljs.core.truth_(inst_27713)){
var statearr_27785_27827 = state_27763__$1;
(statearr_27785_27827[(1)] = (19));

} else {
var statearr_27786_27828 = state_27763__$1;
(statearr_27786_27828[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (3))){
var inst_27761 = (state_27763[(2)]);
var state_27763__$1 = state_27763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27763__$1,inst_27761);
} else {
if((state_val_27764 === (12))){
var inst_27692 = (state_27763[(2)]);
var inst_27693 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27694 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27695 = cljs.core.PersistentHashMap.fromArrays(inst_27693,inst_27694);
var inst_27696 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27692,inst_27695);
var inst_27697 = (function(){throw inst_27696})();
var state_27763__$1 = state_27763;
var statearr_27787_27829 = state_27763__$1;
(statearr_27787_27829[(2)] = inst_27697);

(statearr_27787_27829[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (2))){
var inst_27673 = (state_27763[(8)]);
var inst_27672 = (state_27763[(10)]);
var inst_27671 = (state_27763[(11)]);
var _ = (function (){var statearr_27788 = state_27763;
(statearr_27788[(4)] = cljs.core.cons((5),(state_27763[(4)])));

return statearr_27788;
})();
var inst_27668 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27669 = session;
var inst_27670 = cljs.core.__destructure_map(inst_27669);
var inst_27671__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27670,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27672__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27670,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27673__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27670,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27675 = [inst_27672__$1,inst_27673__$1];
var inst_27676 = (new cljs.core.PersistentVector(null,2,(5),inst_27674,inst_27675,null));
var inst_27677 = fluree.db.operations.ledger_info_async(inst_27671__$1,inst_27676);
var state_27763__$1 = (function (){var statearr_27789 = state_27763;
(statearr_27789[(8)] = inst_27673__$1);

(statearr_27789[(17)] = inst_27668);

(statearr_27789[(10)] = inst_27672__$1);

(statearr_27789[(11)] = inst_27671__$1);

return statearr_27789;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27763__$1,(6),inst_27677);
} else {
if((state_val_27764 === (23))){
var inst_27719 = (state_27763[(16)]);
var inst_27710 = (state_27763[(18)]);
var inst_27722 = cljs.core.__destructure_map(inst_27719);
var inst_27723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27722,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27722,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27725 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27722,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27726 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27710,inst_27724,inst_27723);
var state_27763__$1 = (function (){var statearr_27790 = state_27763;
(statearr_27790[(19)] = inst_27725);

return statearr_27790;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27763__$1,(26),inst_27726);
} else {
if((state_val_27764 === (19))){
var inst_27710 = (state_27763[(18)]);
var state_27763__$1 = state_27763;
var statearr_27791_27830 = state_27763__$1;
(statearr_27791_27830[(2)] = inst_27710);

(statearr_27791_27830[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (11))){
var inst_27673 = (state_27763[(8)]);
var inst_27680 = (state_27763[(7)]);
var inst_27672 = (state_27763[(10)]);
var inst_27689 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27680);
var inst_27690 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27672),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27673)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27689),"."].join('');
var state_27763__$1 = state_27763;
var statearr_27793_27831 = state_27763__$1;
(statearr_27793_27831[(2)] = inst_27690);

(statearr_27793_27831[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (9))){
var inst_27673 = (state_27763[(8)]);
var inst_27680 = (state_27763[(7)]);
var inst_27668 = (state_27763[(17)]);
var inst_27672 = (state_27763[(10)]);
var inst_27671 = (state_27763[(11)]);
var inst_27700 = (state_27763[(2)]);
var inst_27701 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27680);
var inst_27702 = fluree.db.storage.core.reify_db(inst_27671,inst_27672,inst_27673,inst_27668,inst_27701);
var state_27763__$1 = (function (){var statearr_27794 = state_27763;
(statearr_27794[(20)] = inst_27700);

return statearr_27794;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27763__$1,(13),inst_27702);
} else {
if((state_val_27764 === (5))){
var _ = (function (){var statearr_27795 = state_27763;
(statearr_27795[(4)] = cljs.core.rest((state_27763[(4)])));

return statearr_27795;
})();
var state_27763__$1 = state_27763;
var ex27792 = (state_27763__$1[(2)]);
var statearr_27796_27832 = state_27763__$1;
(statearr_27796_27832[(5)] = ex27792);


var statearr_27797_27833 = state_27763__$1;
(statearr_27797_27833[(1)] = (4));

(statearr_27797_27833[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (14))){
var inst_27705 = (state_27763[(14)]);
var inst_27708 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27705);
var inst_27709 = (inst_27708 + (1));
var inst_27710 = inst_27705;
var inst_27711 = inst_27709;
var state_27763__$1 = (function (){var statearr_27798 = state_27763;
(statearr_27798[(9)] = inst_27711);

(statearr_27798[(18)] = inst_27710);

return statearr_27798;
})();
var statearr_27799_27834 = state_27763__$1;
(statearr_27799_27834[(2)] = null);

(statearr_27799_27834[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (26))){
var inst_27711 = (state_27763[(9)]);
var inst_27728 = (state_27763[(2)]);
var inst_27729 = fluree.db.util.async.throw_err(inst_27728);
var inst_27730 = (inst_27711 + (1));
var inst_27710 = inst_27729;
var inst_27711__$1 = inst_27730;
var state_27763__$1 = (function (){var statearr_27800 = state_27763;
(statearr_27800[(9)] = inst_27711__$1);

(statearr_27800[(18)] = inst_27710);

return statearr_27800;
})();
var statearr_27801_27835 = state_27763__$1;
(statearr_27801_27835[(2)] = null);

(statearr_27801_27835[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (16))){
var inst_27747 = (state_27763[(12)]);
var inst_27747__$1 = (state_27763[(2)]);
var inst_27748 = fluree.db.query.schema.schema_map(inst_27747__$1);
var state_27763__$1 = (function (){var statearr_27802 = state_27763;
(statearr_27802[(12)] = inst_27747__$1);

return statearr_27802;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27763__$1,(27),inst_27748);
} else {
if((state_val_27764 === (10))){
var inst_27673 = (state_27763[(8)]);
var inst_27672 = (state_27763[(10)]);
var inst_27687 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27672),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27673)," is not found on this ledger group."].join('');
var state_27763__$1 = state_27763;
var statearr_27803_27836 = state_27763__$1;
(statearr_27803_27836[(2)] = inst_27687);

(statearr_27803_27836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (18))){
var inst_27744 = (state_27763[(2)]);
var state_27763__$1 = state_27763;
var statearr_27804_27837 = state_27763__$1;
(statearr_27804_27837[(2)] = inst_27744);

(statearr_27804_27837[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27764 === (8))){
var state_27763__$1 = state_27763;
var statearr_27805_27838 = state_27763__$1;
(statearr_27805_27838[(2)] = null);

(statearr_27805_27838[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____0 = (function (){
var statearr_27806 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27806[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__);

(statearr_27806[(1)] = (1));

return statearr_27806;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____1 = (function (state_27763){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27763);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27807){var ex__2736__auto__ = e27807;
var statearr_27808_27839 = state_27763;
(statearr_27808_27839[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27763[(4)]))){
var statearr_27809_27840 = state_27763;
(statearr_27809_27840[(1)] = cljs.core.first((state_27763[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27841 = state_27763;
state_27763 = G__27841;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__ = function(state_27763){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____1.call(this,state_27763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2733__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27810 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27810[(6)] = c__2755__auto___27811);

return statearr_27810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__27842 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__27842,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__27842;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__27843 = cljs.core.get_global_hierarchy;
return (fexpr__27843.cljs$core$IFn$_invoke$arity$0 ? fexpr__27843.cljs$core$IFn$_invoke$arity$0() : fexpr__27843.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27845){
var state_val_27846 = (state_27845[(1)]);
if((state_val_27846 === (1))){
var state_27845__$1 = state_27845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27845__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2733__auto__ = null;
var fluree$db$session$state_machine__2733__auto____0 = (function (){
var statearr_27847 = [null,null,null,null,null,null,null];
(statearr_27847[(0)] = fluree$db$session$state_machine__2733__auto__);

(statearr_27847[(1)] = (1));

return statearr_27847;
});
var fluree$db$session$state_machine__2733__auto____1 = (function (state_27845){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27845);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27848){var ex__2736__auto__ = e27848;
var statearr_27849_27852 = state_27845;
(statearr_27849_27852[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27845[(4)]))){
var statearr_27850_27853 = state_27845;
(statearr_27850_27853[(1)] = cljs.core.first((state_27845[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27854 = state_27845;
state_27845 = G__27854;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$state_machine__2733__auto__ = function(state_27845){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2733__auto____1.call(this,state_27845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2733__auto____0;
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2733__auto____1;
return fluree$db$session$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27851 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27851[(6)] = c__2755__auto__);

return statearr_27851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27856){
var map__27857 = p__27856;
var map__27857__$1 = cljs.core.__destructure_map(map__27857);
var data = map__27857__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27857__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27857__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27857__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27916){
var state_val_27917 = (state_27916[(1)]);
if((state_val_27917 === (7))){
var inst_27871 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27872 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27873 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27871),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27872),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_27874 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27873], 0));
var state_27916__$1 = state_27916;
var statearr_27918_27956 = state_27916__$1;
(statearr_27918_27956[(2)] = inst_27874);

(statearr_27918_27956[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (1))){
var state_27916__$1 = state_27916;
var statearr_27919_27957 = state_27916__$1;
(statearr_27919_27957[(2)] = null);

(statearr_27919_27957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (4))){
var inst_27858 = (state_27916[(2)]);
var state_27916__$1 = state_27916;
var statearr_27920_27958 = state_27916__$1;
(statearr_27920_27958[(2)] = inst_27858);

(statearr_27920_27958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (15))){
var inst_27897 = (state_27916[(2)]);
var state_27916__$1 = state_27916;
var statearr_27921_27959 = state_27916__$1;
(statearr_27921_27959[(2)] = inst_27897);

(statearr_27921_27959[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (13))){
var inst_27888 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27890 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27891 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27892 = [inst_27890,inst_27891];
var inst_27893 = (new cljs.core.PersistentVector(null,2,(5),inst_27889,inst_27892,null));
var inst_27894 = (function (){var G__27922 = inst_27888;
var G__27923 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__27924 = inst_27893;
var G__27925 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__27922,G__27923,G__27924,G__27925) : fluree.db.conn_events.process_event.call(null,G__27922,G__27923,G__27924,G__27925));
})();
var state_27916__$1 = state_27916;
var statearr_27926_27960 = state_27916__$1;
(statearr_27926_27960[(2)] = inst_27894);

(statearr_27926_27960[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (6))){
var inst_27867 = (state_27916[(7)]);
var inst_27868 = (state_27916[(8)]);
var inst_27866 = (state_27916[(2)]);
var inst_27867__$1 = fluree.db.util.async.throw_err(inst_27866);
var inst_27868__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27867__$1);
var inst_27869 = (block <= inst_27868__$1);
var state_27916__$1 = (function (){var statearr_27927 = state_27916;
(statearr_27927[(7)] = inst_27867__$1);

(statearr_27927[(8)] = inst_27868__$1);

return statearr_27927;
})();
if(cljs.core.truth_(inst_27869)){
var statearr_27928_27961 = state_27916__$1;
(statearr_27928_27961[(1)] = (7));

} else {
var statearr_27929_27962 = state_27916__$1;
(statearr_27929_27962[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (17))){
var state_27916__$1 = state_27916;
var statearr_27930_27963 = state_27916__$1;
(statearr_27930_27963[(2)] = null);

(statearr_27930_27963[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (3))){
var inst_27914 = (state_27916[(2)]);
var state_27916__$1 = state_27916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27916__$1,inst_27914);
} else {
if((state_val_27917 === (12))){
var inst_27909 = (state_27916[(2)]);
var state_27916__$1 = state_27916;
var statearr_27931_27964 = state_27916__$1;
(statearr_27931_27964[(2)] = inst_27909);

(statearr_27931_27964[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (2))){
var inst_27864 = (state_27916[(9)]);
var _ = (function (){var statearr_27932 = state_27916;
(statearr_27932[(4)] = cljs.core.cons((5),(state_27916[(4)])));

return statearr_27932;
})();
var inst_27864__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_27916__$1 = (function (){var statearr_27933 = state_27916;
(statearr_27933[(9)] = inst_27864__$1);

return statearr_27933;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27916__$1,(6),inst_27864__$1);
} else {
if((state_val_27917 === (11))){
var state_27916__$1 = state_27916;
var statearr_27935_27965 = state_27916__$1;
(statearr_27935_27965[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (9))){
var inst_27911 = (state_27916[(2)]);
var _ = (function (){var statearr_27937 = state_27916;
(statearr_27937[(4)] = cljs.core.rest((state_27916[(4)])));

return statearr_27937;
})();
var state_27916__$1 = state_27916;
var statearr_27938_27966 = state_27916__$1;
(statearr_27938_27966[(2)] = inst_27911);

(statearr_27938_27966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (5))){
var _ = (function (){var statearr_27939 = state_27916;
(statearr_27939[(4)] = cljs.core.rest((state_27916[(4)])));

return statearr_27939;
})();
var state_27916__$1 = state_27916;
var ex27934 = (state_27916__$1[(2)]);
var statearr_27940_27967 = state_27916__$1;
(statearr_27940_27967[(5)] = ex27934);


if((ex27934 instanceof Error)){
var statearr_27941_27968 = state_27916__$1;
(statearr_27941_27968[(1)] = (4));

(statearr_27941_27968[(5)] = null);

} else {
throw ex27934;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (14))){
var state_27916__$1 = state_27916;
var statearr_27942_27969 = state_27916__$1;
(statearr_27942_27969[(2)] = null);

(statearr_27942_27969[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (16))){
var inst_27868 = (state_27916[(8)]);
var inst_27900 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27901 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27902 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27900),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27901),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27868),". Forcing a db reload."].join('');
var inst_27903 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27902], 0));
var inst_27904 = fluree.db.session.reload_db_BANG_(session);
var state_27916__$1 = (function (){var statearr_27943 = state_27916;
(statearr_27943[(10)] = inst_27903);

return statearr_27943;
})();
var statearr_27944_27970 = state_27916__$1;
(statearr_27944_27970[(2)] = inst_27904);

(statearr_27944_27970[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (10))){
var inst_27867 = (state_27916[(7)]);
var inst_27868 = (state_27916[(8)]);
var inst_27864 = (state_27916[(9)]);
var inst_27879 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27880 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27881 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27879),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27880),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27882 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27881], 0));
var inst_27883 = (function (){var current_db_ch = inst_27864;
var current_db = inst_27867;
var current_block = inst_27868;
return (function (p1__27855_SHARP_){
if((p1__27855_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__27855_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__27855_SHARP_);
}
});
})();
var inst_27884 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27883,flakes);
var inst_27885 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27867,block,inst_27884);
var inst_27886 = fluree.db.session.cas_db_BANG_(session,inst_27864,inst_27885);
var state_27916__$1 = (function (){var statearr_27945 = state_27916;
(statearr_27945[(11)] = inst_27882);

return statearr_27945;
})();
if(inst_27886){
var statearr_27946_27971 = state_27916__$1;
(statearr_27946_27971[(1)] = (13));

} else {
var statearr_27947_27972 = state_27916__$1;
(statearr_27947_27972[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (18))){
var inst_27907 = (state_27916[(2)]);
var state_27916__$1 = state_27916;
var statearr_27948_27973 = state_27916__$1;
(statearr_27948_27973[(2)] = inst_27907);

(statearr_27948_27973[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27917 === (8))){
var inst_27868 = (state_27916[(8)]);
var inst_27876 = ((1) + inst_27868);
var inst_27877 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27876);
var state_27916__$1 = state_27916;
if(inst_27877){
var statearr_27949_27974 = state_27916__$1;
(statearr_27949_27974[(1)] = (10));

} else {
var statearr_27950_27975 = state_27916__$1;
(statearr_27950_27975[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2733__auto__ = null;
var fluree$db$session$state_machine__2733__auto____0 = (function (){
var statearr_27951 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27951[(0)] = fluree$db$session$state_machine__2733__auto__);

(statearr_27951[(1)] = (1));

return statearr_27951;
});
var fluree$db$session$state_machine__2733__auto____1 = (function (state_27916){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27916);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27952){var ex__2736__auto__ = e27952;
var statearr_27953_27976 = state_27916;
(statearr_27953_27976[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27916[(4)]))){
var statearr_27954_27977 = state_27916;
(statearr_27954_27977[(1)] = cljs.core.first((state_27916[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27978 = state_27916;
state_27916 = G__27978;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$state_machine__2733__auto__ = function(state_27916){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2733__auto____1.call(this,state_27916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2733__auto____0;
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2733__auto____1;
return fluree$db$session$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27955 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27955[(6)] = c__2755__auto__);

return statearr_27955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27985){
var state_val_27986 = (state_27985[(1)]);
if((state_val_27986 === (1))){
var inst_27979 = fluree.db.session.clear_db_BANG_(session);
var inst_27980 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27981 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27982 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27980),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27981)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27983 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27982], 0));
var state_27985__$1 = (function (){var statearr_27987 = state_27985;
(statearr_27987[(7)] = inst_27979);

(statearr_27987[(8)] = inst_27983);

return statearr_27987;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27985__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2733__auto__ = null;
var fluree$db$session$state_machine__2733__auto____0 = (function (){
var statearr_27988 = [null,null,null,null,null,null,null,null,null];
(statearr_27988[(0)] = fluree$db$session$state_machine__2733__auto__);

(statearr_27988[(1)] = (1));

return statearr_27988;
});
var fluree$db$session$state_machine__2733__auto____1 = (function (state_27985){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27985);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27989){var ex__2736__auto__ = e27989;
var statearr_27990_27993 = state_27985;
(statearr_27990_27993[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27985[(4)]))){
var statearr_27991_27994 = state_27985;
(statearr_27991_27994[(1)] = cljs.core.first((state_27985[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27995 = state_27985;
state_27985 = G__27995;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$state_machine__2733__auto__ = function(state_27985){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2733__auto____1.call(this,state_27985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2733__auto____0;
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2733__auto____1;
return fluree$db$session$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27992 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27992[(6)] = c__2755__auto__);

return statearr_27992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27997 = arguments.length;
switch (G__27997) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__27998 = session;
var map__27998__$1 = cljs.core.__destructure_map(map__27998);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27998__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27998__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27998__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27998__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27998__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27998__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27998__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__27999_28002 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27999_28002.cljs$core$IFn$_invoke$arity$3 ? fexpr__27999_28002.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__27999_28002.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__28000_28003 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__28000_28003.cljs$core$IFn$_invoke$arity$0 ? fexpr__28000_28003.cljs$core$IFn$_invoke$arity$0() : fexpr__28000_28003.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28056){
var state_val_28057 = (state_28056[(1)]);
if((state_val_28057 === (7))){
var inst_28052 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28058_28089 = state_28056__$1;
(statearr_28058_28089[(2)] = inst_28052);

(statearr_28058_28089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (1))){
var state_28056__$1 = state_28056;
var statearr_28059_28090 = state_28056__$1;
(statearr_28059_28090[(2)] = null);

(statearr_28059_28090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (4))){
var inst_28007 = (state_28056[(7)]);
var inst_28006 = (state_28056[(2)]);
var inst_28007__$1 = fluree.db.util.async.throw_err(inst_28006);
var inst_28008 = fluree.db.session.from_cache(network,ledger_id);
var inst_28009 = (inst_28007__$1 == null);
var state_28056__$1 = (function (){var statearr_28060 = state_28056;
(statearr_28060[(7)] = inst_28007__$1);

(statearr_28060[(8)] = inst_28008);

return statearr_28060;
})();
if(cljs.core.truth_(inst_28009)){
var statearr_28061_28091 = state_28056__$1;
(statearr_28061_28091[(1)] = (5));

} else {
var statearr_28062_28092 = state_28056__$1;
(statearr_28062_28092[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (15))){
var inst_28044 = (state_28056[(2)]);
var state_28056__$1 = (function (){var statearr_28063 = state_28056;
(statearr_28063[(9)] = inst_28044);

return statearr_28063;
})();
var statearr_28064_28093 = state_28056__$1;
(statearr_28064_28093[(2)] = null);

(statearr_28064_28093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (13))){
var inst_28048 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28066_28094 = state_28056__$1;
(statearr_28066_28094[(2)] = inst_28048);

(statearr_28066_28094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (6))){
var inst_28008 = (state_28056[(8)]);
var inst_28014 = (inst_28008 == null);
var state_28056__$1 = state_28056;
if(cljs.core.truth_(inst_28014)){
var statearr_28067_28095 = state_28056__$1;
(statearr_28067_28095[(1)] = (8));

} else {
var statearr_28068_28096 = state_28056__$1;
(statearr_28068_28096[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (17))){
var _ = (function (){var statearr_28069 = state_28056;
(statearr_28069[(4)] = cljs.core.rest((state_28056[(4)])));

return statearr_28069;
})();
var state_28056__$1 = state_28056;
var ex28065 = (state_28056__$1[(2)]);
var statearr_28070_28097 = state_28056__$1;
(statearr_28070_28097[(5)] = ex28065);


var statearr_28071_28098 = state_28056__$1;
(statearr_28071_28098[(1)] = (16));

(statearr_28071_28098[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (3))){
var inst_28054 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28056__$1,inst_28054);
} else {
if((state_val_28057 === (12))){
var state_28056__$1 = state_28056;
var statearr_28072_28099 = state_28056__$1;
(statearr_28072_28099[(2)] = null);

(statearr_28072_28099[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (2))){
var state_28056__$1 = state_28056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28056__$1,(4),update_chan);
} else {
if((state_val_28057 === (11))){
var state_28056__$1 = state_28056;
var statearr_28073_28100 = state_28056__$1;
(statearr_28073_28100[(2)] = null);

(statearr_28073_28100[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (9))){
var state_28056__$1 = state_28056;
var statearr_28074_28101 = state_28056__$1;
(statearr_28074_28101[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (5))){
var inst_28011 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_28012 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28011], 0));
var state_28056__$1 = state_28056;
var statearr_28076_28102 = state_28056__$1;
(statearr_28076_28102[(2)] = inst_28012);

(statearr_28076_28102[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (14))){
var inst_28007 = (state_28056[(7)]);
var inst_28008 = (state_28056[(8)]);
var _ = (function (){var statearr_28077 = state_28056;
(statearr_28077[(4)] = cljs.core.cons((17),(state_28056[(4)])));

return statearr_28077;
})();
var inst_28032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28007,(0),null);
var inst_28033 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28007,(1),null);
var inst_28034 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_28035 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28007], 0));
var inst_28036 = fluree.db.util.core.trunc(inst_28035,(200));
var inst_28037 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28034,inst_28036], 0));
var inst_28038 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_28008,inst_28032,inst_28033) : fluree.db.session.process_ledger_update.call(null,inst_28008,inst_28032,inst_28033));
var state_28056__$1 = (function (){var statearr_28078 = state_28056;
(statearr_28078[(10)] = inst_28037);

return statearr_28078;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28056__$1,(18),inst_28038);
} else {
if((state_val_28057 === (16))){
var inst_28007 = (state_28056[(7)]);
var inst_28022 = (state_28056[(2)]);
var inst_28023 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28022,"Exception processing ledger updates for message: ",inst_28007], 0));
var state_28056__$1 = state_28056;
var statearr_28079_28103 = state_28056__$1;
(statearr_28079_28103[(2)] = inst_28023);

(statearr_28079_28103[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (10))){
var inst_28050 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28080_28104 = state_28056__$1;
(statearr_28080_28104[(2)] = inst_28050);

(statearr_28080_28104[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (18))){
var inst_28040 = (state_28056[(2)]);
var inst_28041 = fluree.db.util.async.throw_err(inst_28040);
var _ = (function (){var statearr_28081 = state_28056;
(statearr_28081[(4)] = cljs.core.rest((state_28056[(4)])));

return statearr_28081;
})();
var state_28056__$1 = state_28056;
var statearr_28082_28105 = state_28056__$1;
(statearr_28082_28105[(2)] = inst_28041);

(statearr_28082_28105[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (8))){
var inst_28007 = (state_28056[(7)]);
var inst_28016 = cljs.core.first(inst_28007);
var inst_28017 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28016], 0));
var inst_28018 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_28017].join('');
var inst_28019 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28018], 0));
var state_28056__$1 = state_28056;
var statearr_28083_28106 = state_28056__$1;
(statearr_28083_28106[(2)] = inst_28019);

(statearr_28083_28106[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____0 = (function (){
var statearr_28084 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28084[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__);

(statearr_28084[(1)] = (1));

return statearr_28084;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____1 = (function (state_28056){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28056);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28085){var ex__2736__auto__ = e28085;
var statearr_28086_28107 = state_28056;
(statearr_28086_28107[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28056[(4)]))){
var statearr_28087_28108 = state_28056;
(statearr_28087_28108[(1)] = cljs.core.first((state_28056[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28109 = state_28056;
state_28056 = G__28109;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__ = function(state_28056){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____1.call(this,state_28056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2733__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28088 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28088[(6)] = c__2755__auto__);

return statearr_28088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__28110){
var map__28111 = p__28110;
var map__28111__$1 = cljs.core.__destructure_map(map__28111);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28111__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28111__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28111__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28111__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28111__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28111__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28111__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28111__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28111__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__28115 = block_result;
var map__28115__$1 = cljs.core.__destructure_map(map__28115);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28115__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28115__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28115__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28115__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28115__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__28116 = tx_result;
var map__28116__$1 = cljs.core.__destructure_map(map__28116);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28116__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28116__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__28112_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__28112_SHARP_.t);
}):(function (p1__28113_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28113_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__28114_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__28114_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28114_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__28117 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28117,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28117,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28117,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28117,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__28121 = arguments.length;
switch (G__28121) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28122){
var map__28123 = p__28122;
var map__28123__$1 = cljs.core.__destructure_map(map__28123);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28123__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28123__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28123__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28123__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28124 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28124,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28124,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28124,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4223__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4223__auto____$1 = state;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__28128_28248 = network;
var G__28129_28249 = ledger_id;
var G__28130_28250 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__28131_28251 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28132 = cljs.core.seq(tids);
var chunk__28133 = null;
var count__28134 = (0);
var i__28135 = (0);
while(true){
if((i__28135 < count__28134)){
var tid = chunk__28133.cljs$core$IIndexed$_nth$arity$2(null,i__28135);
var temp__5753__auto___28253__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28253__$1)){
var keyed_callbacks_28254 = temp__5753__auto___28253__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28255 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28176_28256 = cljs.core.seq(keyed_callbacks_28254);
var chunk__28177_28257 = null;
var count__28178_28258 = (0);
var i__28179_28259 = (0);
while(true){
if((i__28179_28259 < count__28178_28258)){
var vec__28188_28260 = chunk__28177_28257.cljs$core$IIndexed$_nth$arity$2(null,i__28179_28259);
var k_28261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28188_28260,(0),null);
var f_28262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28188_28260,(1),null);
try{(f_28262.cljs$core$IFn$_invoke$arity$1 ? f_28262.cljs$core$IFn$_invoke$arity$1(tx_response_28255) : f_28262.call(null,tx_response_28255));
}catch (e28191){var e_28263 = e28191;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28263,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28264 = seq__28176_28256;
var G__28265 = chunk__28177_28257;
var G__28266 = count__28178_28258;
var G__28267 = (i__28179_28259 + (1));
seq__28176_28256 = G__28264;
chunk__28177_28257 = G__28265;
count__28178_28258 = G__28266;
i__28179_28259 = G__28267;
continue;
} else {
var temp__5753__auto___28268__$2 = cljs.core.seq(seq__28176_28256);
if(temp__5753__auto___28268__$2){
var seq__28176_28269__$1 = temp__5753__auto___28268__$2;
if(cljs.core.chunked_seq_QMARK_(seq__28176_28269__$1)){
var c__4649__auto___28270 = cljs.core.chunk_first(seq__28176_28269__$1);
var G__28271 = cljs.core.chunk_rest(seq__28176_28269__$1);
var G__28272 = c__4649__auto___28270;
var G__28273 = cljs.core.count(c__4649__auto___28270);
var G__28274 = (0);
seq__28176_28256 = G__28271;
chunk__28177_28257 = G__28272;
count__28178_28258 = G__28273;
i__28179_28259 = G__28274;
continue;
} else {
var vec__28192_28275 = cljs.core.first(seq__28176_28269__$1);
var k_28276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28192_28275,(0),null);
var f_28277 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28192_28275,(1),null);
try{(f_28277.cljs$core$IFn$_invoke$arity$1 ? f_28277.cljs$core$IFn$_invoke$arity$1(tx_response_28255) : f_28277.call(null,tx_response_28255));
}catch (e28195){var e_28278 = e28195;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28278,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28279 = cljs.core.next(seq__28176_28269__$1);
var G__28280 = null;
var G__28281 = (0);
var G__28282 = (0);
seq__28176_28256 = G__28279;
chunk__28177_28257 = G__28280;
count__28178_28258 = G__28281;
i__28179_28259 = G__28282;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28283 = seq__28132;
var G__28284 = chunk__28133;
var G__28285 = count__28134;
var G__28286 = (i__28135 + (1));
seq__28132 = G__28283;
chunk__28133 = G__28284;
count__28134 = G__28285;
i__28135 = G__28286;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__28132);
if(temp__5753__auto____$1){
var seq__28132__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__28132__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__28132__$1);
var G__28287 = cljs.core.chunk_rest(seq__28132__$1);
var G__28288 = c__4649__auto__;
var G__28289 = cljs.core.count(c__4649__auto__);
var G__28290 = (0);
seq__28132 = G__28287;
chunk__28133 = G__28288;
count__28134 = G__28289;
i__28135 = G__28290;
continue;
} else {
var tid = cljs.core.first(seq__28132__$1);
var temp__5753__auto___28291__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28291__$2)){
var keyed_callbacks_28292 = temp__5753__auto___28291__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28293 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28196_28294 = cljs.core.seq(keyed_callbacks_28292);
var chunk__28197_28295 = null;
var count__28198_28296 = (0);
var i__28199_28297 = (0);
while(true){
if((i__28199_28297 < count__28198_28296)){
var vec__28208_28298 = chunk__28197_28295.cljs$core$IIndexed$_nth$arity$2(null,i__28199_28297);
var k_28299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28208_28298,(0),null);
var f_28300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28208_28298,(1),null);
try{(f_28300.cljs$core$IFn$_invoke$arity$1 ? f_28300.cljs$core$IFn$_invoke$arity$1(tx_response_28293) : f_28300.call(null,tx_response_28293));
}catch (e28211){var e_28301 = e28211;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28301,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28302 = seq__28196_28294;
var G__28303 = chunk__28197_28295;
var G__28304 = count__28198_28296;
var G__28305 = (i__28199_28297 + (1));
seq__28196_28294 = G__28302;
chunk__28197_28295 = G__28303;
count__28198_28296 = G__28304;
i__28199_28297 = G__28305;
continue;
} else {
var temp__5753__auto___28306__$3 = cljs.core.seq(seq__28196_28294);
if(temp__5753__auto___28306__$3){
var seq__28196_28307__$1 = temp__5753__auto___28306__$3;
if(cljs.core.chunked_seq_QMARK_(seq__28196_28307__$1)){
var c__4649__auto___28308 = cljs.core.chunk_first(seq__28196_28307__$1);
var G__28309 = cljs.core.chunk_rest(seq__28196_28307__$1);
var G__28310 = c__4649__auto___28308;
var G__28311 = cljs.core.count(c__4649__auto___28308);
var G__28312 = (0);
seq__28196_28294 = G__28309;
chunk__28197_28295 = G__28310;
count__28198_28296 = G__28311;
i__28199_28297 = G__28312;
continue;
} else {
var vec__28212_28313 = cljs.core.first(seq__28196_28307__$1);
var k_28314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28212_28313,(0),null);
var f_28315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28212_28313,(1),null);
try{(f_28315.cljs$core$IFn$_invoke$arity$1 ? f_28315.cljs$core$IFn$_invoke$arity$1(tx_response_28293) : f_28315.call(null,tx_response_28293));
}catch (e28215){var e_28316 = e28215;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28316,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28317 = cljs.core.next(seq__28196_28307__$1);
var G__28318 = null;
var G__28319 = (0);
var G__28320 = (0);
seq__28196_28294 = G__28317;
chunk__28197_28295 = G__28318;
count__28198_28296 = G__28319;
i__28199_28297 = G__28320;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28321 = cljs.core.next(seq__28132__$1);
var G__28322 = null;
var G__28323 = (0);
var G__28324 = (0);
seq__28132 = G__28321;
chunk__28133 = G__28322;
count__28134 = G__28323;
i__28135 = G__28324;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__28127_28252 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28127_28252.cljs$core$IFn$_invoke$arity$4 ? fexpr__28127_28252.cljs$core$IFn$_invoke$arity$4(G__28128_28248,G__28129_28249,G__28130_28250,G__28131_28251) : fexpr__28127_28252.call(null,G__28128_28248,G__28129_28249,G__28130_28250,G__28131_28251));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28325 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2755__auto___28326 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28232){
var state_val_28233 = (state_28232[(1)]);
if((state_val_28233 === (1))){
var state_28232__$1 = state_28232;
var statearr_28234_28327 = state_28232__$1;
(statearr_28234_28327[(2)] = null);

(statearr_28234_28327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28233 === (2))){
var inst_28217 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28232__$1 = state_28232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28232__$1,(4),inst_28217);
} else {
if((state_val_28233 === (3))){
var inst_28230 = (state_28232[(2)]);
var state_28232__$1 = state_28232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28232__$1,inst_28230);
} else {
if((state_val_28233 === (4))){
var inst_28219 = (state_28232[(7)]);
var inst_28219__$1 = (state_28232[(2)]);
var inst_28220 = (inst_28219__$1 == null);
var state_28232__$1 = (function (){var statearr_28235 = state_28232;
(statearr_28235[(7)] = inst_28219__$1);

return statearr_28235;
})();
if(cljs.core.truth_(inst_28220)){
var statearr_28236_28328 = state_28232__$1;
(statearr_28236_28328[(1)] = (5));

} else {
var statearr_28237_28329 = state_28232__$1;
(statearr_28237_28329[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28233 === (5))){
var inst_28222 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28223 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28222], 0));
var state_28232__$1 = state_28232;
var statearr_28238_28330 = state_28232__$1;
(statearr_28238_28330[(2)] = inst_28223);

(statearr_28238_28330[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28233 === (6))){
var inst_28219 = (state_28232[(7)]);
var inst_28225 = (transact_handler_28325.cljs$core$IFn$_invoke$arity$2 ? transact_handler_28325.cljs$core$IFn$_invoke$arity$2(conn,inst_28219) : transact_handler_28325.call(null,conn,inst_28219));
var state_28232__$1 = (function (){var statearr_28239 = state_28232;
(statearr_28239[(8)] = inst_28225);

return statearr_28239;
})();
var statearr_28240_28331 = state_28232__$1;
(statearr_28240_28331[(2)] = null);

(statearr_28240_28331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28233 === (7))){
var inst_28228 = (state_28232[(2)]);
var state_28232__$1 = state_28232;
var statearr_28241_28332 = state_28232__$1;
(statearr_28241_28332[(2)] = inst_28228);

(statearr_28241_28332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2733__auto__ = null;
var fluree$db$session$state_machine__2733__auto____0 = (function (){
var statearr_28242 = [null,null,null,null,null,null,null,null,null];
(statearr_28242[(0)] = fluree$db$session$state_machine__2733__auto__);

(statearr_28242[(1)] = (1));

return statearr_28242;
});
var fluree$db$session$state_machine__2733__auto____1 = (function (state_28232){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28232);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28243){var ex__2736__auto__ = e28243;
var statearr_28244_28333 = state_28232;
(statearr_28244_28333[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28232[(4)]))){
var statearr_28245_28334 = state_28232;
(statearr_28245_28334[(1)] = cljs.core.first((state_28232[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28335 = state_28232;
state_28232 = G__28335;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$session$state_machine__2733__auto__ = function(state_28232){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2733__auto____1.call(this,state_28232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2733__auto____0;
fluree$db$session$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2733__auto____1;
return fluree$db$session$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28246 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28246[(6)] = c__2755__auto___28326);

return statearr_28246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28336_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__28336_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28336_SHARP_) + (1))], 0));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28337_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__28337_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28340 = arguments.length;
switch (G__28340) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28341 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28338_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__28338_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28341);
} else {
return G__28341;
}
})();
var seq__28342 = cljs.core.seq(sessions);
var chunk__28343 = null;
var count__28344 = (0);
var i__28345 = (0);
while(true){
if((i__28345 < count__28344)){
var session = chunk__28343.cljs$core$IIndexed$_nth$arity$2(null,i__28345);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28347 = seq__28342;
var G__28348 = chunk__28343;
var G__28349 = count__28344;
var G__28350 = (i__28345 + (1));
seq__28342 = G__28347;
chunk__28343 = G__28348;
count__28344 = G__28349;
i__28345 = G__28350;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__28342);
if(temp__5753__auto__){
var seq__28342__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28342__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__28342__$1);
var G__28351 = cljs.core.chunk_rest(seq__28342__$1);
var G__28352 = c__4649__auto__;
var G__28353 = cljs.core.count(c__4649__auto__);
var G__28354 = (0);
seq__28342 = G__28351;
chunk__28343 = G__28352;
count__28344 = G__28353;
i__28345 = G__28354;
continue;
} else {
var session = cljs.core.first(seq__28342__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28355 = cljs.core.next(seq__28342__$1);
var G__28356 = null;
var G__28357 = (0);
var G__28358 = (0);
seq__28342 = G__28355;
chunk__28343 = G__28356;
count__28344 = G__28357;
i__28345 = G__28358;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
