// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26219 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26219,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26219,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26219,(2),null);
if(cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__26222){
var map__26223 = p__26222;
var map__26223__$1 = cljs.core.__destructure_map(map__26223);
var opts = map__26223__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26223__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_26283){
var state_val_26284 = (state_26283[(1)]);
if((state_val_26284 === (7))){
var inst_26254 = cljs.core.not(reindex_QMARK_);
var state_26283__$1 = state_26283;
var statearr_26285_26309 = state_26283__$1;
(statearr_26285_26309[(2)] = inst_26254);

(statearr_26285_26309[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26284 === (1))){
var state_26283__$1 = state_26283;
var statearr_26286_26310 = state_26283__$1;
(statearr_26286_26310[(2)] = null);

(statearr_26286_26310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26284 === (4))){
var inst_26224 = (state_26283[(2)]);
var state_26283__$1 = state_26283;
var statearr_26287_26311 = state_26283__$1;
(statearr_26287_26311[(2)] = inst_26224);

(statearr_26287_26311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26284 === (6))){
var inst_26238 = (state_26283[(7)]);
var inst_26252 = (state_26283[(8)]);
var inst_26244 = (state_26283[(9)]);
var inst_26237 = (state_26283[(2)]);
var inst_26238__$1 = fluree.db.util.async.throw_err(inst_26237);
var inst_26239 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26240 = cljs.core.__destructure_map(inst_26239);
var inst_26241 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26240,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26242 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26240,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26243 = fluree.db.flake.size_bytes(inst_26238__$1);
var inst_26244__$1 = (inst_26242 + inst_26243);
var inst_26245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26246 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26247 = (new cljs.core.PersistentVector(null,2,(5),inst_26245,inst_26246,null));
var inst_26248 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26247);
var inst_26249 = cljs.core.__destructure_map(inst_26248);
var inst_26250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26249,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26249,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26252__$1 = (inst_26244__$1 > inst_26251);
var state_26283__$1 = (function (){var statearr_26288 = state_26283;
(statearr_26288[(10)] = inst_26250);

(statearr_26288[(7)] = inst_26238__$1);

(statearr_26288[(8)] = inst_26252__$1);

(statearr_26288[(9)] = inst_26244__$1);

(statearr_26288[(11)] = inst_26241);

return statearr_26288;
})();
if(cljs.core.truth_(inst_26252__$1)){
var statearr_26289_26312 = state_26283__$1;
(statearr_26289_26312[(1)] = (7));

} else {
var statearr_26290_26313 = state_26283__$1;
(statearr_26290_26313[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26284 === (3))){
var inst_26281 = (state_26283[(2)]);
var state_26283__$1 = state_26283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26283__$1,inst_26281);
} else {
if((state_val_26284 === (12))){
var inst_26238 = (state_26283[(7)]);
var inst_26244 = (state_26283[(9)]);
var inst_26241 = (state_26283[(11)]);
var inst_26267 = (state_26283[(2)]);
var inst_26268 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26241,inst_26238);
var inst_26269 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26270 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_26269,cljs.core.empty);
var inst_26271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26272 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26273 = (new cljs.core.PersistentVector(null,2,(5),inst_26271,inst_26272,null));
var inst_26274 = cljs.core.assoc_in(db,inst_26273,inst_26268);
var inst_26275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26276 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26277 = (new cljs.core.PersistentVector(null,2,(5),inst_26275,inst_26276,null));
var inst_26278 = cljs.core.assoc_in(inst_26274,inst_26277,inst_26244);
var _ = (function (){var statearr_26291 = state_26283;
(statearr_26291[(4)] = cljs.core.rest((state_26283[(4)])));

return statearr_26291;
})();
var state_26283__$1 = (function (){var statearr_26292 = state_26283;
(statearr_26292[(12)] = inst_26270);

(statearr_26292[(13)] = inst_26267);

return statearr_26292;
})();
var statearr_26293_26314 = state_26283__$1;
(statearr_26293_26314[(2)] = inst_26278);

(statearr_26293_26314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26284 === (2))){
var _ = (function (){var statearr_26294 = state_26283;
(statearr_26294[(4)] = cljs.core.cons((5),(state_26283[(4)])));

return statearr_26294;
})();
var inst_26232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26233 = [pred_id];
var inst_26234 = (new cljs.core.PersistentVector(null,1,(5),inst_26232,inst_26233,null));
var inst_26235 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26234);
var state_26283__$1 = state_26283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26283__$1,(6),inst_26235);
} else {
if((state_val_26284 === (11))){
var state_26283__$1 = state_26283;
var statearr_26296_26315 = state_26283__$1;
(statearr_26296_26315[(2)] = null);

(statearr_26296_26315[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26284 === (9))){
var inst_26257 = (state_26283[(2)]);
var state_26283__$1 = state_26283;
if(cljs.core.truth_(inst_26257)){
var statearr_26297_26316 = state_26283__$1;
(statearr_26297_26316[(1)] = (10));

} else {
var statearr_26298_26317 = state_26283__$1;
(statearr_26298_26317[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26284 === (5))){
var _ = (function (){var statearr_26299 = state_26283;
(statearr_26299[(4)] = cljs.core.rest((state_26283[(4)])));

return statearr_26299;
})();
var state_26283__$1 = state_26283;
var ex26295 = (state_26283__$1[(2)]);
var statearr_26300_26318 = state_26283__$1;
(statearr_26300_26318[(5)] = ex26295);


if((ex26295 instanceof Error)){
var statearr_26301_26319 = state_26283__$1;
(statearr_26301_26319[(1)] = (4));

(statearr_26301_26319[(5)] = null);

} else {
throw ex26295;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26284 === (10))){
var inst_26259 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26260 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26261 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26262 = cljs.core.PersistentHashMap.fromArrays(inst_26260,inst_26261);
var inst_26263 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26259,inst_26262);
var inst_26264 = (function(){throw inst_26263})();
var state_26283__$1 = state_26283;
var statearr_26302_26320 = state_26283__$1;
(statearr_26302_26320[(2)] = inst_26264);

(statearr_26302_26320[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26284 === (8))){
var inst_26252 = (state_26283[(8)]);
var state_26283__$1 = state_26283;
var statearr_26303_26321 = state_26283__$1;
(statearr_26303_26321[(2)] = inst_26252);

(statearr_26303_26321[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____0 = (function (){
var statearr_26304 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26304[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__);

(statearr_26304[(1)] = (1));

return statearr_26304;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____1 = (function (state_26283){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_26283);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e26305){var ex__2736__auto__ = e26305;
var statearr_26306_26322 = state_26283;
(statearr_26306_26322[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_26283[(4)]))){
var statearr_26307_26323 = state_26283;
(statearr_26307_26323[(1)] = cljs.core.first((state_26283[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26324 = state_26283;
state_26283 = G__26324;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__ = function(state_26283){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____1.call(this,state_26283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_26308 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_26308[(6)] = c__2755__auto__);

return statearr_26308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__26329 = arguments.length;
switch (G__26329) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_26525){
var state_val_26526 = (state_26525[(1)]);
if((state_val_26526 === (7))){
var state_26525__$1 = state_26525;
var statearr_26527_26595 = state_26525__$1;
(statearr_26527_26595[(2)] = null);

(statearr_26527_26595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (20))){
var inst_26447 = (state_26525[(7)]);
var inst_26367 = (state_26525[(8)]);
var inst_26450 = (state_26525[(9)]);
var inst_26368 = (state_26525[(10)]);
var inst_26418 = (state_26525[(11)]);
var inst_26451 = (state_26525[(12)]);
var inst_26449 = (state_26525[(13)]);
var inst_26448 = (state_26525[(14)]);
var inst_26461 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26463 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26464 = (new cljs.core.PersistentVector(null,2,(5),inst_26462,inst_26463,null));
var inst_26465 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26418,inst_26464);
var inst_26466 = (inst_26367 + inst_26465);
var inst_26467 = [inst_26447,inst_26448,inst_26449,inst_26450,inst_26466];
var inst_26468 = cljs.core.PersistentHashMap.fromArrays(inst_26461,inst_26467);
var inst_26469 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26418,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26451,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26468], 0));
var state_26525__$1 = (function (){var statearr_26528 = state_26525;
(statearr_26528[(15)] = inst_26469);

return statearr_26528;
})();
if(cljs.core.truth_(inst_26368)){
var statearr_26529_26596 = state_26525__$1;
(statearr_26529_26596[(1)] = (23));

} else {
var statearr_26530_26597 = state_26525__$1;
(statearr_26530_26597[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (27))){
var inst_26469 = (state_26525[(15)]);
var state_26525__$1 = state_26525;
var statearr_26531_26598 = state_26525__$1;
(statearr_26531_26598[(2)] = inst_26469);

(statearr_26531_26598[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (1))){
var state_26525__$1 = state_26525;
var statearr_26532_26599 = state_26525__$1;
(statearr_26532_26599[(2)] = null);

(statearr_26532_26599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (24))){
var inst_26469 = (state_26525[(15)]);
var inst_26472 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26469);
var inst_26473 = (inst_26472 == null);
var state_26525__$1 = state_26525;
var statearr_26533_26600 = state_26525__$1;
(statearr_26533_26600[(2)] = inst_26473);

(statearr_26533_26600[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (39))){
var inst_26499 = (state_26525[(16)]);
var inst_26501 = (state_26525[(17)]);
var inst_26500 = (state_26525[(18)]);
var inst_26458 = (state_26525[(19)]);
var inst_26508 = (state_26525[(20)]);
var inst_26515 = (state_26525[(2)]);
var inst_26446 = inst_26458;
var inst_26447 = inst_26500;
var inst_26448 = inst_26501;
var inst_26449 = inst_26508;
var inst_26450 = inst_26515;
var inst_26451 = inst_26499;
var state_26525__$1 = (function (){var statearr_26534 = state_26525;
(statearr_26534[(7)] = inst_26447);

(statearr_26534[(9)] = inst_26450);

(statearr_26534[(12)] = inst_26451);

(statearr_26534[(13)] = inst_26449);

(statearr_26534[(21)] = inst_26446);

(statearr_26534[(14)] = inst_26448);

return statearr_26534;
})();
var statearr_26535_26601 = state_26525__$1;
(statearr_26535_26601[(2)] = null);

(statearr_26535_26601[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (4))){
var inst_26330 = (state_26525[(2)]);
var state_26525__$1 = state_26525;
var statearr_26536_26602 = state_26525__$1;
(statearr_26536_26602[(2)] = inst_26330);

(statearr_26536_26602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (15))){
var inst_26390 = (state_26525[(22)]);
var state_26525__$1 = state_26525;
var statearr_26537_26603 = state_26525__$1;
(statearr_26537_26603[(2)] = inst_26390);

(statearr_26537_26603[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (21))){
var inst_26447 = (state_26525[(7)]);
var inst_26367 = (state_26525[(8)]);
var inst_26358 = (state_26525[(23)]);
var inst_26366 = (state_26525[(24)]);
var inst_26450 = (state_26525[(9)]);
var inst_26368 = (state_26525[(10)]);
var inst_26428 = (state_26525[(25)]);
var inst_26418 = (state_26525[(11)]);
var inst_26354 = (state_26525[(26)]);
var inst_26352 = (state_26525[(27)]);
var inst_26362 = (state_26525[(28)]);
var inst_26371 = (state_26525[(29)]);
var inst_26457 = (state_26525[(30)]);
var inst_26451 = (state_26525[(12)]);
var inst_26369 = (state_26525[(31)]);
var inst_26427 = (state_26525[(32)]);
var inst_26449 = (state_26525[(13)]);
var inst_26458 = (state_26525[(19)]);
var inst_26377 = (state_26525[(33)]);
var inst_26337 = (state_26525[(34)]);
var inst_26446 = (state_26525[(21)]);
var inst_26448 = (state_26525[(14)]);
var inst_26496 = inst_26457.s;
var inst_26497 = fluree.db.flake.sid__GT_cid(inst_26496);
var inst_26498 = (function (){var flakes_bytes = inst_26367;
var t = inst_26337;
var spot = inst_26447;
var add_flakes = inst_26354;
var root_setting_change_QMARK_ = inst_26369;
var seq__26454 = inst_26458;
var ref_QMARK__map = inst_26366;
var r = inst_26458;
var first__26455 = inst_26457;
var psot = inst_26448;
var add_pred_to_idx_QMARK_ = inst_26377;
var _ = inst_26352;
var vec__26453 = inst_26446;
var cid = inst_26497;
var ecount = inst_26451;
var pred_ecount = inst_26371;
var db_STAR_ = inst_26418;
var schema_change_QMARK_ = inst_26368;
var add_preds = inst_26358;
var first__26425 = inst_26427;
var opst = inst_26450;
var vec__26423 = inst_26354;
var seq__26424 = inst_26428;
var G__26422 = inst_26446;
var idx_QMARK__map = inst_26362;
var post = inst_26449;
var f = inst_26457;
return (function (p1__26327_SHARP_){
if(cljs.core.truth_(p1__26327_SHARP_)){
var x__4306__auto__ = p1__26327_SHARP_;
var y__4307__auto__ = f.s;
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
} else {
return f.s;
}
});
})();
var inst_26499 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_26451,inst_26497,inst_26498);
var inst_26500 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26447,inst_26457);
var inst_26501 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26448,inst_26457);
var inst_26502 = inst_26457.p;
var inst_26503 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26362,inst_26502);
var state_26525__$1 = (function (){var statearr_26538 = state_26525;
(statearr_26538[(16)] = inst_26499);

(statearr_26538[(17)] = inst_26501);

(statearr_26538[(18)] = inst_26500);

return statearr_26538;
})();
if(cljs.core.truth_(inst_26503)){
var statearr_26539_26604 = state_26525__$1;
(statearr_26539_26604[(1)] = (34));

} else {
var statearr_26540_26605 = state_26525__$1;
(statearr_26540_26605[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (31))){
var inst_26484 = (state_26525[(35)]);
var state_26525__$1 = state_26525;
var statearr_26541_26606 = state_26525__$1;
(statearr_26541_26606[(2)] = inst_26484);

(statearr_26541_26606[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (32))){
var inst_26494 = (state_26525[(2)]);
var state_26525__$1 = state_26525;
var statearr_26542_26607 = state_26525__$1;
(statearr_26542_26607[(2)] = inst_26494);

(statearr_26542_26607[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (33))){
var inst_26484 = (state_26525[(35)]);
var inst_26489 = (state_26525[(2)]);
var inst_26490 = fluree.db.util.async.throw_err(inst_26489);
var inst_26491 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26484,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26490);
var state_26525__$1 = state_26525;
var statearr_26543_26608 = state_26525__$1;
(statearr_26543_26608[(2)] = inst_26491);

(statearr_26543_26608[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (13))){
var inst_26367 = (state_26525[(8)]);
var inst_26418 = (state_26525[(11)]);
var inst_26354 = (state_26525[(26)]);
var inst_26337 = (state_26525[(34)]);
var inst_26408 = (state_26525[(2)]);
var inst_26409 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26408,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26337);
var inst_26410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26411 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26412 = (new cljs.core.PersistentVector(null,2,(5),inst_26410,inst_26411,null));
var inst_26413 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26409,inst_26412,cljs.core._PLUS_,inst_26367);
var inst_26414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26415 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26416 = (new cljs.core.PersistentVector(null,2,(5),inst_26414,inst_26415,null));
var inst_26417 = cljs.core.count(inst_26354);
var inst_26418__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26413,inst_26416,cljs.core._PLUS_,inst_26417);
var inst_26426 = cljs.core.seq(inst_26354);
var inst_26427 = cljs.core.first(inst_26426);
var inst_26428 = cljs.core.next(inst_26426);
var inst_26429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26430 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26431 = (new cljs.core.PersistentVector(null,2,(5),inst_26429,inst_26430,null));
var inst_26432 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26418__$1,inst_26431);
var inst_26433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26434 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26435 = (new cljs.core.PersistentVector(null,2,(5),inst_26433,inst_26434,null));
var inst_26436 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26418__$1,inst_26435);
var inst_26437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26438 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26439 = (new cljs.core.PersistentVector(null,2,(5),inst_26437,inst_26438,null));
var inst_26440 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26418__$1,inst_26439);
var inst_26441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26442 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26443 = (new cljs.core.PersistentVector(null,2,(5),inst_26441,inst_26442,null));
var inst_26444 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26418__$1,inst_26443);
var inst_26445 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26446 = inst_26354;
var inst_26447 = inst_26432;
var inst_26448 = inst_26436;
var inst_26449 = inst_26440;
var inst_26450 = inst_26444;
var inst_26451 = inst_26445;
var state_26525__$1 = (function (){var statearr_26544 = state_26525;
(statearr_26544[(7)] = inst_26447);

(statearr_26544[(9)] = inst_26450);

(statearr_26544[(25)] = inst_26428);

(statearr_26544[(11)] = inst_26418__$1);

(statearr_26544[(12)] = inst_26451);

(statearr_26544[(32)] = inst_26427);

(statearr_26544[(13)] = inst_26449);

(statearr_26544[(21)] = inst_26446);

(statearr_26544[(14)] = inst_26448);

return statearr_26544;
})();
var statearr_26545_26609 = state_26525__$1;
(statearr_26545_26609[(2)] = null);

(statearr_26545_26609[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (22))){
var inst_26518 = (state_26525[(2)]);
var state_26525__$1 = state_26525;
var statearr_26546_26610 = state_26525__$1;
(statearr_26546_26610[(2)] = inst_26518);

(statearr_26546_26610[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (36))){
var inst_26366 = (state_26525[(24)]);
var inst_26457 = (state_26525[(30)]);
var inst_26508 = (state_26525[(2)]);
var inst_26509 = inst_26457.p;
var inst_26510 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26366,inst_26509);
var state_26525__$1 = (function (){var statearr_26547 = state_26525;
(statearr_26547[(20)] = inst_26508);

return statearr_26547;
})();
if(cljs.core.truth_(inst_26510)){
var statearr_26548_26611 = state_26525__$1;
(statearr_26548_26611[(1)] = (37));

} else {
var statearr_26549_26612 = state_26525__$1;
(statearr_26549_26612[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (29))){
var inst_26469 = (state_26525[(15)]);
var inst_26479 = (state_26525[(2)]);
var inst_26480 = fluree.db.util.async.throw_err(inst_26479);
var inst_26481 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26469,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26480);
var state_26525__$1 = state_26525;
var statearr_26550_26613 = state_26525__$1;
(statearr_26550_26613[(2)] = inst_26481);

(statearr_26550_26613[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (6))){
var inst_26337 = (state_26525[(34)]);
var inst_26342 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26343 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26344 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26342)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26343)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26337),"."].join('');
var inst_26345 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26346 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26347 = cljs.core.PersistentHashMap.fromArrays(inst_26345,inst_26346);
var inst_26348 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26344,inst_26347);
var inst_26349 = (function(){throw inst_26348})();
var state_26525__$1 = state_26525;
var statearr_26551_26614 = state_26525__$1;
(statearr_26551_26614[(2)] = inst_26349);

(statearr_26551_26614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (28))){
var inst_26369 = (state_26525[(31)]);
var inst_26484 = (state_26525[(2)]);
var state_26525__$1 = (function (){var statearr_26552 = state_26525;
(statearr_26552[(35)] = inst_26484);

return statearr_26552;
})();
if(cljs.core.truth_(inst_26369)){
var statearr_26553_26615 = state_26525__$1;
(statearr_26553_26615[(1)] = (30));

} else {
var statearr_26554_26616 = state_26525__$1;
(statearr_26554_26616[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (25))){
var inst_26475 = (state_26525[(2)]);
var state_26525__$1 = state_26525;
if(cljs.core.truth_(inst_26475)){
var statearr_26555_26617 = state_26525__$1;
(statearr_26555_26617[(1)] = (26));

} else {
var statearr_26556_26618 = state_26525__$1;
(statearr_26556_26618[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (34))){
var inst_26457 = (state_26525[(30)]);
var inst_26449 = (state_26525[(13)]);
var inst_26505 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26449,inst_26457);
var state_26525__$1 = state_26525;
var statearr_26557_26619 = state_26525__$1;
(statearr_26557_26619[(2)] = inst_26505);

(statearr_26557_26619[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (17))){
var inst_26397 = (state_26525[(36)]);
var inst_26401 = (state_26525[(2)]);
var inst_26402 = fluree.db.util.async.throw_err(inst_26401);
var inst_26389 = inst_26397;
var inst_26390 = inst_26402;
var state_26525__$1 = (function (){var statearr_26558 = state_26525;
(statearr_26558[(22)] = inst_26390);

(statearr_26558[(37)] = inst_26389);

return statearr_26558;
})();
var statearr_26559_26620 = state_26525__$1;
(statearr_26559_26620[(2)] = null);

(statearr_26559_26620[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (3))){
var inst_26523 = (state_26525[(2)]);
var state_26525__$1 = state_26525;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26525__$1,inst_26523);
} else {
if((state_val_26526 === (12))){
var inst_26396 = (state_26525[(38)]);
var inst_26389 = (state_26525[(37)]);
var inst_26395 = cljs.core.seq(inst_26389);
var inst_26396__$1 = cljs.core.first(inst_26395);
var inst_26397 = cljs.core.next(inst_26395);
var state_26525__$1 = (function (){var statearr_26560 = state_26525;
(statearr_26560[(36)] = inst_26397);

(statearr_26560[(38)] = inst_26396__$1);

return statearr_26560;
})();
if(cljs.core.truth_(inst_26396__$1)){
var statearr_26561_26621 = state_26525__$1;
(statearr_26561_26621[(1)] = (14));

} else {
var statearr_26562_26622 = state_26525__$1;
(statearr_26562_26622[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (2))){
var inst_26337 = (state_26525[(34)]);
var _ = (function (){var statearr_26563 = state_26525;
(statearr_26563[(4)] = cljs.core.cons((5),(state_26525[(4)])));

return statearr_26563;
})();
var inst_26336 = cljs.core.first(flakes);
var inst_26337__$1 = inst_26336.t;
var inst_26338 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26339 = (inst_26338 - (1));
var inst_26340 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_26337__$1,inst_26339);
var state_26525__$1 = (function (){var statearr_26564 = state_26525;
(statearr_26564[(34)] = inst_26337__$1);

return statearr_26564;
})();
if(inst_26340){
var statearr_26565_26623 = state_26525__$1;
(statearr_26565_26623[(1)] = (6));

} else {
var statearr_26566_26624 = state_26525__$1;
(statearr_26566_26624[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (23))){
var inst_26368 = (state_26525[(10)]);
var state_26525__$1 = state_26525;
var statearr_26567_26625 = state_26525__$1;
(statearr_26567_26625[(2)] = inst_26368);

(statearr_26567_26625[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (35))){
var inst_26449 = (state_26525[(13)]);
var state_26525__$1 = state_26525;
var statearr_26568_26626 = state_26525__$1;
(statearr_26568_26626[(2)] = inst_26449);

(statearr_26568_26626[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (19))){
var inst_26520 = (state_26525[(2)]);
var _ = (function (){var statearr_26569 = state_26525;
(statearr_26569[(4)] = cljs.core.rest((state_26525[(4)])));

return statearr_26569;
})();
var state_26525__$1 = state_26525;
var statearr_26570_26627 = state_26525__$1;
(statearr_26570_26627[(2)] = inst_26520);

(statearr_26570_26627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (11))){
var inst_26377 = (state_26525[(33)]);
var inst_26377__$1 = (state_26525[(2)]);
var inst_26385 = cljs.core.seq(inst_26377__$1);
var inst_26386 = cljs.core.first(inst_26385);
var inst_26387 = cljs.core.next(inst_26385);
var inst_26388 = db;
var inst_26389 = inst_26377__$1;
var inst_26390 = inst_26388;
var state_26525__$1 = (function (){var statearr_26572 = state_26525;
(statearr_26572[(22)] = inst_26390);

(statearr_26572[(39)] = inst_26386);

(statearr_26572[(40)] = inst_26387);

(statearr_26572[(33)] = inst_26377__$1);

(statearr_26572[(37)] = inst_26389);

return statearr_26572;
})();
var statearr_26573_26628 = state_26525__$1;
(statearr_26573_26628[(2)] = null);

(statearr_26573_26628[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (9))){
var inst_26354 = (state_26525[(26)]);
var inst_26371 = (state_26525[(29)]);
var inst_26373 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_26354,inst_26371);
var state_26525__$1 = state_26525;
var statearr_26574_26629 = state_26525__$1;
(statearr_26574_26629[(2)] = inst_26373);

(statearr_26574_26629[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (5))){
var _ = (function (){var statearr_26575 = state_26525;
(statearr_26575[(4)] = cljs.core.rest((state_26525[(4)])));

return statearr_26575;
})();
var state_26525__$1 = state_26525;
var ex26571 = (state_26525__$1[(2)]);
var statearr_26576_26630 = state_26525__$1;
(statearr_26576_26630[(5)] = ex26571);


if((ex26571 instanceof Error)){
var statearr_26577_26631 = state_26525__$1;
(statearr_26577_26631[(1)] = (4));

(statearr_26577_26631[(5)] = null);

} else {
throw ex26571;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (14))){
var inst_26390 = (state_26525[(22)]);
var inst_26396 = (state_26525[(38)]);
var inst_26399 = fluree.db.graphdb.add_predicate_to_idx(inst_26390,inst_26396,opts);
var state_26525__$1 = state_26525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26525__$1,(17),inst_26399);
} else {
if((state_val_26526 === (26))){
var inst_26469 = (state_26525[(15)]);
var inst_26477 = fluree.db.query.schema.schema_map(inst_26469);
var state_26525__$1 = state_26525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26525__$1,(29),inst_26477);
} else {
if((state_val_26526 === (16))){
var inst_26406 = (state_26525[(2)]);
var state_26525__$1 = state_26525;
var statearr_26578_26632 = state_26525__$1;
(statearr_26578_26632[(2)] = inst_26406);

(statearr_26578_26632[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (38))){
var inst_26450 = (state_26525[(9)]);
var state_26525__$1 = state_26525;
var statearr_26579_26633 = state_26525__$1;
(statearr_26579_26633[(2)] = inst_26450);

(statearr_26579_26633[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (30))){
var inst_26484 = (state_26525[(35)]);
var inst_26487 = fluree.db.query.schema.setting_map(inst_26484);
var state_26525__$1 = state_26525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26525__$1,(33),inst_26487);
} else {
if((state_val_26526 === (10))){
var inst_26375 = cljs.core.PersistentVector.EMPTY;
var state_26525__$1 = state_26525;
var statearr_26580_26634 = state_26525__$1;
(statearr_26580_26634[(2)] = inst_26375);

(statearr_26580_26634[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (18))){
var inst_26457 = (state_26525[(30)]);
var inst_26446 = (state_26525[(21)]);
var inst_26456 = cljs.core.seq(inst_26446);
var inst_26457__$1 = cljs.core.first(inst_26456);
var inst_26458 = cljs.core.next(inst_26456);
var inst_26459 = cljs.core.not(inst_26457__$1);
var state_26525__$1 = (function (){var statearr_26581 = state_26525;
(statearr_26581[(30)] = inst_26457__$1);

(statearr_26581[(19)] = inst_26458);

return statearr_26581;
})();
if(inst_26459){
var statearr_26582_26635 = state_26525__$1;
(statearr_26582_26635[(1)] = (20));

} else {
var statearr_26583_26636 = state_26525__$1;
(statearr_26583_26636[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (37))){
var inst_26450 = (state_26525[(9)]);
var inst_26457 = (state_26525[(30)]);
var inst_26512 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26450,inst_26457);
var state_26525__$1 = state_26525;
var statearr_26584_26637 = state_26525__$1;
(statearr_26584_26637[(2)] = inst_26512);

(statearr_26584_26637[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26526 === (8))){
var inst_26358 = (state_26525[(23)]);
var inst_26368 = (state_26525[(10)]);
var inst_26354 = (state_26525[(26)]);
var inst_26352 = (state_26525[(27)]);
var inst_26362 = (state_26525[(28)]);
var inst_26337 = (state_26525[(34)]);
var inst_26352__$1 = (state_26525[(2)]);
var inst_26353 = (function (){var t = inst_26337;
var _ = inst_26352__$1;
return (function (p1__26325_SHARP_){
return cljs.core.not((function (){var G__26585 = p1__26325_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__26585) : fluree.db.graphdb.exclude_predicates.call(null,G__26585));
})());
});
})();
var inst_26354__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26353,flakes);
var inst_26355 = cljs.core.PersistentHashSet.EMPTY;
var inst_26356 = (function (){var t = inst_26337;
var _ = inst_26352__$1;
var add_flakes = inst_26354__$1;
return (function (p1__26326_SHARP_){
return p1__26326_SHARP_.p;
});
})();
var inst_26357 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26356,inst_26354__$1);
var inst_26358__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26355,inst_26357);
var inst_26359 = cljs.core.PersistentHashMap.EMPTY;
var inst_26360 = (function (){var t = inst_26337;
var _ = inst_26352__$1;
var add_flakes = inst_26354__$1;
var add_preds = inst_26358__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26361 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26360,inst_26358__$1);
var inst_26362__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26359,inst_26361);
var inst_26363 = cljs.core.PersistentHashMap.EMPTY;
var inst_26364 = (function (){var t = inst_26337;
var _ = inst_26352__$1;
var add_flakes = inst_26354__$1;
var add_preds = inst_26358__$1;
var idx_QMARK__map = inst_26362__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26365 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26364,inst_26358__$1);
var inst_26366 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26363,inst_26365);
var inst_26367 = fluree.db.flake.size_bytes(inst_26354__$1);
var inst_26368__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_26354__$1);
var inst_26369 = fluree.db.util.schema.setting_change_QMARK_(inst_26354__$1);
var inst_26370 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26371 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26370,(0));
var state_26525__$1 = (function (){var statearr_26586 = state_26525;
(statearr_26586[(8)] = inst_26367);

(statearr_26586[(23)] = inst_26358__$1);

(statearr_26586[(24)] = inst_26366);

(statearr_26586[(10)] = inst_26368__$1);

(statearr_26586[(26)] = inst_26354__$1);

(statearr_26586[(27)] = inst_26352__$1);

(statearr_26586[(28)] = inst_26362__$1);

(statearr_26586[(29)] = inst_26371);

(statearr_26586[(31)] = inst_26369);

return statearr_26586;
})();
if(cljs.core.truth_(inst_26368__$1)){
var statearr_26587_26638 = state_26525__$1;
(statearr_26587_26638[(1)] = (9));

} else {
var statearr_26588_26639 = state_26525__$1;
(statearr_26588_26639[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_26589 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26589[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_26589[(1)] = (1));

return statearr_26589;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_26525){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_26525);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e26590){var ex__2736__auto__ = e26590;
var statearr_26591_26640 = state_26525;
(statearr_26591_26640[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_26525[(4)]))){
var statearr_26592_26641 = state_26525;
(statearr_26592_26641[(1)] = cljs.core.first((state_26525[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26642 = state_26525;
state_26525 = G__26642;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_26525){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_26525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_26593 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_26593[(6)] = c__2755__auto__);

return statearr_26593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26644 = arguments.length;
switch (G__26644) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___26791 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_26740){
var state_val_26741 = (state_26740[(1)]);
if((state_val_26741 === (7))){
var state_26740__$1 = state_26740;
var statearr_26742_26792 = state_26740__$1;
(statearr_26742_26792[(2)] = null);

(statearr_26742_26792[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (20))){
var inst_26690 = (state_26740[(7)]);
var inst_26689 = (state_26740[(8)]);
var inst_26688 = (state_26740[(9)]);
var inst_26709 = (inst_26688 + (1));
var inst_26710 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26690,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26709);
var inst_26711 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_26710,inst_26689,opts);
var state_26740__$1 = state_26740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26740__$1,(23),inst_26711);
} else {
if((state_val_26741 === (1))){
var state_26740__$1 = state_26740;
var statearr_26743_26793 = state_26740__$1;
(statearr_26743_26793[(2)] = null);

(statearr_26743_26793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (24))){
var inst_26714 = (state_26740[(10)]);
var inst_26717 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26714,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26740__$1 = state_26740;
var statearr_26744_26794 = state_26740__$1;
(statearr_26744_26794[(2)] = inst_26717);

(statearr_26744_26794[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (4))){
var inst_26645 = (state_26740[(2)]);
var inst_26646 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26645);
var state_26740__$1 = state_26740;
var statearr_26745_26795 = state_26740__$1;
(statearr_26745_26795[(2)] = inst_26646);

(statearr_26745_26795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (15))){
var inst_26696 = (state_26740[(11)]);
var state_26740__$1 = state_26740;
var statearr_26746_26796 = state_26740__$1;
(statearr_26746_26796[(2)] = inst_26696);

(statearr_26746_26796[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (21))){
var state_26740__$1 = state_26740;
var statearr_26747_26797 = state_26740__$1;
(statearr_26747_26797[(2)] = null);

(statearr_26747_26797[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (13))){
var inst_26732 = (state_26740[(2)]);
var inst_26733 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26732);
var state_26740__$1 = state_26740;
var statearr_26748_26798 = state_26740__$1;
(statearr_26748_26798[(2)] = inst_26733);

(statearr_26748_26798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (22))){
var inst_26728 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
var statearr_26749_26799 = state_26740__$1;
(statearr_26749_26799[(2)] = inst_26728);

(statearr_26749_26799[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (6))){
var inst_26656 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26657 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26658 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26656)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26657)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26659 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26660 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26661 = cljs.core.PersistentHashMap.fromArrays(inst_26659,inst_26660);
var inst_26662 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26658,inst_26661);
var inst_26663 = (function(){throw inst_26662})();
var state_26740__$1 = state_26740;
var statearr_26752_26800 = state_26740__$1;
(statearr_26752_26800[(2)] = inst_26663);

(statearr_26752_26800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (25))){
var inst_26714 = (state_26740[(10)]);
var inst_26696 = (state_26740[(11)]);
var inst_26697 = (state_26740[(12)]);
var inst_26719 = inst_26696.t;
var inst_26720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26721 = [inst_26696];
var inst_26722 = (new cljs.core.PersistentVector(null,1,(5),inst_26720,inst_26721,null));
var inst_26687 = inst_26697;
var inst_26688 = inst_26719;
var inst_26689 = inst_26722;
var inst_26690 = inst_26714;
var state_26740__$1 = (function (){var statearr_26753 = state_26740;
(statearr_26753[(7)] = inst_26690);

(statearr_26753[(13)] = inst_26687);

(statearr_26753[(8)] = inst_26689);

(statearr_26753[(9)] = inst_26688);

return statearr_26753;
})();
var statearr_26754_26801 = state_26740__$1;
(statearr_26754_26801[(2)] = null);

(statearr_26754_26801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (17))){
var inst_26690 = (state_26740[(7)]);
var inst_26696 = (state_26740[(11)]);
var inst_26697 = (state_26740[(12)]);
var inst_26689 = (state_26740[(8)]);
var inst_26688 = (state_26740[(9)]);
var inst_26705 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26689,inst_26696);
var tmp26750 = inst_26690;
var tmp26751 = inst_26688;
var inst_26687 = inst_26697;
var inst_26688__$1 = tmp26751;
var inst_26689__$1 = inst_26705;
var inst_26690__$1 = tmp26750;
var state_26740__$1 = (function (){var statearr_26755 = state_26740;
(statearr_26755[(7)] = inst_26690__$1);

(statearr_26755[(13)] = inst_26687);

(statearr_26755[(8)] = inst_26689__$1);

(statearr_26755[(9)] = inst_26688__$1);

return statearr_26755;
})();
var statearr_26756_26802 = state_26740__$1;
(statearr_26756_26802[(2)] = null);

(statearr_26756_26802[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (3))){
var inst_26738 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26740__$1,inst_26738);
} else {
if((state_val_26741 === (12))){
var inst_26696 = (state_26740[(11)]);
var inst_26687 = (state_26740[(13)]);
var inst_26695 = cljs.core.seq(inst_26687);
var inst_26696__$1 = cljs.core.first(inst_26695);
var inst_26697 = cljs.core.next(inst_26695);
var state_26740__$1 = (function (){var statearr_26757 = state_26740;
(statearr_26757[(11)] = inst_26696__$1);

(statearr_26757[(12)] = inst_26697);

return statearr_26757;
})();
if(cljs.core.truth_(inst_26696__$1)){
var statearr_26758_26803 = state_26740__$1;
(statearr_26758_26803[(1)] = (14));

} else {
var statearr_26759_26804 = state_26740__$1;
(statearr_26759_26804[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (2))){
var _ = (function (){var statearr_26760 = state_26740;
(statearr_26760[(4)] = cljs.core.cons((5),(state_26740[(4)])));

return statearr_26760;
})();
var inst_26652 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26653 = (inst_26652 + (1));
var inst_26654 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26653);
var state_26740__$1 = state_26740;
if(inst_26654){
var statearr_26761_26805 = state_26740__$1;
(statearr_26761_26805[(1)] = (6));

} else {
var statearr_26762_26806 = state_26740__$1;
(statearr_26762_26806[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (23))){
var inst_26696 = (state_26740[(11)]);
var inst_26713 = (state_26740[(2)]);
var inst_26714 = fluree.db.util.async.throw_err(inst_26713);
var inst_26715 = (inst_26696 == null);
var state_26740__$1 = (function (){var statearr_26763 = state_26740;
(statearr_26763[(10)] = inst_26714);

return statearr_26763;
})();
if(cljs.core.truth_(inst_26715)){
var statearr_26764_26807 = state_26740__$1;
(statearr_26764_26807[(1)] = (24));

} else {
var statearr_26765_26808 = state_26740__$1;
(statearr_26765_26808[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (19))){
var inst_26730 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
var statearr_26766_26809 = state_26740__$1;
(statearr_26766_26809[(2)] = inst_26730);

(statearr_26766_26809[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (11))){
var inst_26735 = (state_26740[(2)]);
var _ = (function (){var statearr_26768 = state_26740;
(statearr_26768[(4)] = cljs.core.rest((state_26740[(4)])));

return statearr_26768;
})();
var state_26740__$1 = state_26740;
var statearr_26769_26810 = state_26740__$1;
(statearr_26769_26810[(2)] = inst_26735);

(statearr_26769_26810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (9))){
var inst_26669 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26670 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26669);
var state_26740__$1 = state_26740;
var statearr_26770_26811 = state_26740__$1;
(statearr_26770_26811[(2)] = inst_26670);

(statearr_26770_26811[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (5))){
var _ = (function (){var statearr_26771 = state_26740;
(statearr_26771[(4)] = cljs.core.rest((state_26740[(4)])));

return statearr_26771;
})();
var state_26740__$1 = state_26740;
var ex26767 = (state_26740__$1[(2)]);
var statearr_26772_26812 = state_26740__$1;
(statearr_26772_26812[(5)] = ex26767);


var statearr_26773_26813 = state_26740__$1;
(statearr_26773_26813[(1)] = (4));

(statearr_26773_26813[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (14))){
var inst_26696 = (state_26740[(11)]);
var inst_26688 = (state_26740[(9)]);
var inst_26699 = inst_26696.t;
var inst_26700 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26688,inst_26699);
var state_26740__$1 = state_26740;
var statearr_26774_26814 = state_26740__$1;
(statearr_26774_26814[(2)] = inst_26700);

(statearr_26774_26814[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (26))){
var inst_26725 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
var statearr_26775_26815 = state_26740__$1;
(statearr_26775_26815[(2)] = inst_26725);

(statearr_26775_26815[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (16))){
var inst_26703 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
if(cljs.core.truth_(inst_26703)){
var statearr_26776_26816 = state_26740__$1;
(statearr_26776_26816[(1)] = (17));

} else {
var statearr_26777_26817 = state_26740__$1;
(statearr_26777_26817[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (10))){
var inst_26672 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_26680 = cljs.core.seq(inst_26672);
var inst_26681 = cljs.core.first(inst_26680);
var inst_26682 = cljs.core.next(inst_26680);
var inst_26683 = cljs.core.first(inst_26672);
var inst_26684 = inst_26683.t;
var inst_26685 = cljs.core.PersistentVector.EMPTY;
var inst_26686 = db;
var inst_26687 = inst_26672;
var inst_26688 = inst_26684;
var inst_26689 = inst_26685;
var inst_26690 = inst_26686;
var state_26740__$1 = (function (){var statearr_26778 = state_26740;
(statearr_26778[(14)] = inst_26682);

(statearr_26778[(7)] = inst_26690);

(statearr_26778[(15)] = inst_26681);

(statearr_26778[(13)] = inst_26687);

(statearr_26778[(8)] = inst_26689);

(statearr_26778[(9)] = inst_26688);

return statearr_26778;
})();
var statearr_26779_26818 = state_26740__$1;
(statearr_26779_26818[(2)] = null);

(statearr_26779_26818[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (18))){
var state_26740__$1 = state_26740;
var statearr_26780_26819 = state_26740__$1;
(statearr_26780_26819[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (8))){
var inst_26666 = (state_26740[(2)]);
var inst_26667 = cljs.core.empty_QMARK_(flakes);
var state_26740__$1 = (function (){var statearr_26782 = state_26740;
(statearr_26782[(16)] = inst_26666);

return statearr_26782;
})();
if(inst_26667){
var statearr_26783_26820 = state_26740__$1;
(statearr_26783_26820[(1)] = (9));

} else {
var statearr_26784_26821 = state_26740__$1;
(statearr_26784_26821[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_26785 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26785[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_26785[(1)] = (1));

return statearr_26785;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_26740){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_26740);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e26786){var ex__2736__auto__ = e26786;
var statearr_26787_26822 = state_26740;
(statearr_26787_26822[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_26740[(4)]))){
var statearr_26788_26823 = state_26740;
(statearr_26788_26823[(1)] = cljs.core.first((state_26740[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26824 = state_26740;
state_26740 = G__26824;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_26740){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_26740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_26789 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_26789[(6)] = c__2755__auto___26791);

return statearr_26789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_26880){
var state_val_26881 = (state_26880[(1)]);
if((state_val_26881 === (7))){
var state_26880__$1 = state_26880;
var statearr_26882_26909 = state_26880__$1;
(statearr_26882_26909[(2)] = tt_id);

(statearr_26882_26909[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (1))){
var state_26880__$1 = state_26880;
var statearr_26883_26910 = state_26880__$1;
(statearr_26883_26910[(2)] = null);

(statearr_26883_26910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (4))){
var inst_26825 = (state_26880[(2)]);
var state_26880__$1 = state_26880;
var statearr_26884_26911 = state_26880__$1;
(statearr_26884_26911[(2)] = inst_26825);

(statearr_26884_26911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (13))){
var inst_26873 = (state_26880[(2)]);
var state_26880__$1 = state_26880;
var statearr_26885_26912 = state_26880__$1;
(statearr_26885_26912[(2)] = inst_26873);

(statearr_26885_26912[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (6))){
var inst_26833 = fluree.db.util.core.random_uuid();
var state_26880__$1 = state_26880;
var statearr_26886_26913 = state_26880__$1;
(statearr_26886_26913[(2)] = inst_26833);

(statearr_26886_26913[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (3))){
var inst_26878 = (state_26880[(2)]);
var state_26880__$1 = state_26880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26880__$1,inst_26878);
} else {
if((state_val_26881 === (12))){
var inst_26856 = (state_26880[(7)]);
var state_26880__$1 = state_26880;
var statearr_26887_26914 = state_26880__$1;
(statearr_26887_26914[(2)] = inst_26856);

(statearr_26887_26914[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (2))){
var _ = (function (){var statearr_26888 = state_26880;
(statearr_26888[(4)] = cljs.core.cons((5),(state_26880[(4)])));

return statearr_26888;
})();
var inst_26831 = (tt_id == null);
var state_26880__$1 = state_26880;
if(cljs.core.truth_(inst_26831)){
var statearr_26889_26915 = state_26880__$1;
(statearr_26889_26915[(1)] = (6));

} else {
var statearr_26890_26916 = state_26880__$1;
(statearr_26890_26916[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (11))){
var inst_26863 = (state_26880[(8)]);
var inst_26856 = (state_26880[(7)]);
var inst_26866 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_26856,inst_26863);
var state_26880__$1 = state_26880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26880__$1,(14),inst_26866);
} else {
if((state_val_26881 === (9))){
var inst_26863 = (state_26880[(8)]);
var inst_26857 = (state_26880[(9)]);
var inst_26862 = cljs.core.seq(inst_26857);
var inst_26863__$1 = cljs.core.first(inst_26862);
var inst_26864 = cljs.core.next(inst_26862);
var state_26880__$1 = (function (){var statearr_26892 = state_26880;
(statearr_26892[(8)] = inst_26863__$1);

(statearr_26892[(10)] = inst_26864);

return statearr_26892;
})();
if(cljs.core.truth_(inst_26863__$1)){
var statearr_26893_26917 = state_26880__$1;
(statearr_26893_26917[(1)] = (11));

} else {
var statearr_26894_26918 = state_26880__$1;
(statearr_26894_26918[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (5))){
var _ = (function (){var statearr_26895 = state_26880;
(statearr_26895[(4)] = cljs.core.rest((state_26880[(4)])));

return statearr_26895;
})();
var state_26880__$1 = state_26880;
var ex26891 = (state_26880__$1[(2)]);
var statearr_26896_26919 = state_26880__$1;
(statearr_26896_26919[(5)] = ex26891);


if((ex26891 instanceof Error)){
var statearr_26897_26920 = state_26880__$1;
(statearr_26897_26920[(1)] = (4));

(statearr_26897_26920[(5)] = null);

} else {
throw ex26891;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (14))){
var inst_26864 = (state_26880[(10)]);
var inst_26868 = (state_26880[(2)]);
var inst_26869 = fluree.db.util.async.throw_err(inst_26868);
var inst_26856 = inst_26869;
var inst_26857 = inst_26864;
var state_26880__$1 = (function (){var statearr_26898 = state_26880;
(statearr_26898[(7)] = inst_26856);

(statearr_26898[(9)] = inst_26857);

return statearr_26898;
})();
var statearr_26899_26921 = state_26880__$1;
(statearr_26899_26921[(2)] = null);

(statearr_26899_26921[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (10))){
var inst_26875 = (state_26880[(2)]);
var _ = (function (){var statearr_26900 = state_26880;
(statearr_26900[(4)] = cljs.core.rest((state_26880[(4)])));

return statearr_26900;
})();
var state_26880__$1 = state_26880;
var statearr_26901_26922 = state_26880__$1;
(statearr_26901_26922[(2)] = inst_26875);

(statearr_26901_26922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26881 === (8))){
var inst_26836 = (state_26880[(2)]);
var inst_26837 = (function (){var tt_id_SINGLEQUOTE_ = inst_26836;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_26838 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26836);
var inst_26839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26840 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26841 = (new cljs.core.PersistentVector(null,4,(5),inst_26839,inst_26840,null));
var inst_26842 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26837,inst_26838,inst_26841);
var inst_26843 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_26844 = cljs.core.reverse(inst_26843);
var inst_26845 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_26844);
var inst_26853 = cljs.core.seq(inst_26845);
var inst_26854 = cljs.core.first(inst_26853);
var inst_26855 = cljs.core.next(inst_26853);
var inst_26856 = inst_26842;
var inst_26857 = inst_26845;
var state_26880__$1 = (function (){var statearr_26902 = state_26880;
(statearr_26902[(11)] = inst_26855);

(statearr_26902[(12)] = inst_26854);

(statearr_26902[(7)] = inst_26856);

(statearr_26902[(9)] = inst_26857);

return statearr_26902;
})();
var statearr_26903_26923 = state_26880__$1;
(statearr_26903_26923[(2)] = null);

(statearr_26903_26923[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____0 = (function (){
var statearr_26904 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26904[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__);

(statearr_26904[(1)] = (1));

return statearr_26904;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____1 = (function (state_26880){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_26880);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e26905){var ex__2736__auto__ = e26905;
var statearr_26906_26924 = state_26880;
(statearr_26906_26924[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_26880[(4)]))){
var statearr_26907_26925 = state_26880;
(statearr_26907_26925[(1)] = cljs.core.first((state_26880[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26926 = state_26880;
state_26880 = G__26926;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__ = function(state_26880){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____1.call(this,state_26880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_26908 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_26908[(6)] = c__2755__auto__);

return statearr_26908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___27113 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27044){
var state_val_27045 = (state_27044[(1)]);
if((state_val_27045 === (7))){
var inst_26954 = (state_27044[(7)]);
var inst_26954__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27044__$1 = (function (){var statearr_27046 = state_27044;
(statearr_27046[(7)] = inst_26954__$1);

return statearr_27046;
})();
if(inst_26954__$1){
var statearr_27047_27114 = state_27044__$1;
(statearr_27047_27114[(1)] = (13));

} else {
var statearr_27048_27115 = state_27044__$1;
(statearr_27048_27115[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (20))){
var state_27044__$1 = state_27044;
var statearr_27049_27116 = state_27044__$1;
(statearr_27049_27116[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (27))){
var inst_26990 = (state_27044[(8)]);
var inst_26994 = inst_26990.s;
var state_27044__$1 = state_27044;
var statearr_27051_27117 = state_27044__$1;
(statearr_27051_27117[(2)] = inst_26994);

(statearr_27051_27117[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (1))){
var state_27044__$1 = state_27044;
var statearr_27052_27118 = state_27044__$1;
(statearr_27052_27118[(2)] = null);

(statearr_27052_27118[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (24))){
var inst_26984 = (state_27044[(9)]);
var inst_26988 = cljs.core.first(inst_26984);
var state_27044__$1 = state_27044;
var statearr_27053_27119 = state_27044__$1;
(statearr_27053_27119[(2)] = inst_26988);

(statearr_27053_27119[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (39))){
var state_27044__$1 = state_27044;
var statearr_27054_27120 = state_27044__$1;
(statearr_27054_27120[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (4))){
var inst_26927 = (state_27044[(2)]);
var inst_26928 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26929 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26930 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26931 = cljs.core.PersistentHashMap.fromArrays(inst_26929,inst_26930);
var inst_26932 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_26928,inst_26931,inst_26927);
var inst_26933 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26932);
var state_27044__$1 = state_27044;
var statearr_27056_27121 = state_27044__$1;
(statearr_27056_27121[(2)] = inst_26933);

(statearr_27056_27121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (15))){
var inst_26961 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
if(cljs.core.truth_(inst_26961)){
var statearr_27057_27122 = state_27044__$1;
(statearr_27057_27122[(1)] = (16));

} else {
var statearr_27058_27123 = state_27044__$1;
(statearr_27058_27123[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (21))){
var inst_27010 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
var statearr_27059_27124 = state_27044__$1;
(statearr_27059_27124[(2)] = inst_27010);

(statearr_27059_27124[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (31))){
var inst_27008 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
var statearr_27060_27125 = state_27044__$1;
(statearr_27060_27125[(2)] = inst_27008);

(statearr_27060_27125[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (32))){
var inst_27014 = (state_27044[(10)]);
var inst_27016 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27014);
var state_27044__$1 = state_27044;
var statearr_27061_27126 = state_27044__$1;
(statearr_27061_27126[(2)] = inst_27016);

(statearr_27061_27126[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (40))){
var inst_27037 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
var statearr_27062_27127 = state_27044__$1;
(statearr_27062_27127[(2)] = inst_27037);

(statearr_27062_27127[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (33))){
var inst_27018 = (state_27044[(11)]);
var inst_27014 = (state_27044[(10)]);
var inst_27018__$1 = (inst_27014 == null);
var state_27044__$1 = (function (){var statearr_27063 = state_27044;
(statearr_27063[(11)] = inst_27018__$1);

return statearr_27063;
})();
if(cljs.core.truth_(inst_27018__$1)){
var statearr_27064_27128 = state_27044__$1;
(statearr_27064_27128[(1)] = (35));

} else {
var statearr_27065_27129 = state_27044__$1;
(statearr_27065_27129[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (13))){
var inst_26956 = cljs.core.first(ident);
var inst_26957 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26956);
var inst_26958 = (inst_26957 == null);
var state_27044__$1 = state_27044;
var statearr_27066_27130 = state_27044__$1;
(statearr_27066_27130[(2)] = inst_26958);

(statearr_27066_27130[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (22))){
var inst_26984 = (state_27044[(9)]);
var inst_26983 = (state_27044[(2)]);
var inst_26984__$1 = fluree.db.util.async.throw_err(inst_26983);
var inst_26985 = (inst_26984__$1 == null);
var state_27044__$1 = (function (){var statearr_27067 = state_27044;
(statearr_27067[(9)] = inst_26984__$1);

return statearr_27067;
})();
if(cljs.core.truth_(inst_26985)){
var statearr_27068_27131 = state_27044__$1;
(statearr_27068_27131[(1)] = (23));

} else {
var statearr_27069_27132 = state_27044__$1;
(statearr_27069_27132[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (36))){
var inst_27018 = (state_27044[(11)]);
var state_27044__$1 = state_27044;
var statearr_27070_27133 = state_27044__$1;
(statearr_27070_27133[(2)] = inst_27018);

(statearr_27070_27133[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (41))){
var inst_27032 = cljs.core.async.close_BANG_(return_chan);
var state_27044__$1 = state_27044;
var statearr_27071_27134 = state_27044__$1;
(statearr_27071_27134[(2)] = inst_27032);

(statearr_27071_27134[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (43))){
var inst_27035 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
var statearr_27072_27135 = state_27044__$1;
(statearr_27072_27135[(2)] = inst_27035);

(statearr_27072_27135[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (29))){
var inst_26999 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_27000 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26999].join('');
var inst_27001 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27002 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27003 = cljs.core.PersistentHashMap.fromArrays(inst_27001,inst_27002);
var inst_27004 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27000,inst_27003);
var inst_27005 = (function(){throw inst_27004})();
var state_27044__$1 = state_27044;
var statearr_27073_27136 = state_27044__$1;
(statearr_27073_27136[(2)] = inst_27005);

(statearr_27073_27136[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (6))){
var inst_26941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26942 = [ident];
var inst_26943 = (new cljs.core.PersistentVector(null,1,(5),inst_26941,inst_26942,null));
var inst_26944 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26943);
var state_27044__$1 = state_27044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27044__$1,(9),inst_26944);
} else {
if((state_val_27045 === (28))){
var inst_26996 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
var statearr_27074_27137 = state_27044__$1;
(statearr_27074_27137[(2)] = inst_26996);

(statearr_27074_27137[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (25))){
var inst_26990 = (state_27044[(8)]);
var inst_26990__$1 = (state_27044[(2)]);
var inst_26991 = (inst_26990__$1 == null);
var state_27044__$1 = (function (){var statearr_27075 = state_27044;
(statearr_27075[(8)] = inst_26990__$1);

return statearr_27075;
})();
if(cljs.core.truth_(inst_26991)){
var statearr_27076_27138 = state_27044__$1;
(statearr_27076_27138[(1)] = (26));

} else {
var statearr_27077_27139 = state_27044__$1;
(statearr_27077_27139[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (34))){
var inst_27039 = (state_27044[(2)]);
var _ = (function (){var statearr_27078 = state_27044;
(statearr_27078[(4)] = cljs.core.rest((state_27044[(4)])));

return statearr_27078;
})();
var state_27044__$1 = state_27044;
var statearr_27079_27140 = state_27044__$1;
(statearr_27079_27140[(2)] = inst_27039);

(statearr_27079_27140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (17))){
var inst_26972 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27044__$1 = state_27044;
if(inst_26972){
var statearr_27080_27141 = state_27044__$1;
(statearr_27080_27141[(1)] = (19));

} else {
var statearr_27081_27142 = state_27044__$1;
(statearr_27081_27142[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (3))){
var inst_27042 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27044__$1,inst_27042);
} else {
if((state_val_27045 === (12))){
var inst_26952 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
var statearr_27082_27143 = state_27044__$1;
(statearr_27082_27143[(2)] = inst_26952);

(statearr_27082_27143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (2))){
var _ = (function (){var statearr_27083 = state_27044;
(statearr_27083[(4)] = cljs.core.cons((5),(state_27044[(4)])));

return statearr_27083;
})();
var inst_26939 = typeof ident === 'number';
var state_27044__$1 = state_27044;
if(cljs.core.truth_(inst_26939)){
var statearr_27084_27144 = state_27044__$1;
(statearr_27084_27144[(1)] = (6));

} else {
var statearr_27085_27145 = state_27044__$1;
(statearr_27085_27145[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (23))){
var state_27044__$1 = state_27044;
var statearr_27086_27146 = state_27044__$1;
(statearr_27086_27146[(2)] = null);

(statearr_27086_27146[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (35))){
var state_27044__$1 = state_27044;
var statearr_27087_27147 = state_27044__$1;
(statearr_27087_27147[(2)] = strict_QMARK_);

(statearr_27087_27147[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (19))){
var inst_26975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26976 = cljs.core.first(ident);
var inst_26977 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26976);
var inst_26978 = cljs.core.second(ident);
var inst_26979 = [inst_26977,inst_26978];
var inst_26980 = (new cljs.core.PersistentVector(null,2,(5),inst_26975,inst_26979,null));
var inst_26981 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26980);
var state_27044__$1 = state_27044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27044__$1,(22),inst_26981);
} else {
if((state_val_27045 === (11))){
var state_27044__$1 = state_27044;
var statearr_27089_27148 = state_27044__$1;
(statearr_27089_27148[(2)] = null);

(statearr_27089_27148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (9))){
var inst_26946 = (state_27044[(2)]);
var inst_26947 = fluree.db.util.async.throw_err(inst_26946);
var inst_26948 = cljs.core.not_empty(inst_26947);
var state_27044__$1 = state_27044;
if(cljs.core.truth_(inst_26948)){
var statearr_27090_27149 = state_27044__$1;
(statearr_27090_27149[(1)] = (10));

} else {
var statearr_27091_27150 = state_27044__$1;
(statearr_27091_27150[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (5))){
var _ = (function (){var statearr_27092 = state_27044;
(statearr_27092[(4)] = cljs.core.rest((state_27044[(4)])));

return statearr_27092;
})();
var state_27044__$1 = state_27044;
var ex27088 = (state_27044__$1[(2)]);
var statearr_27093_27151 = state_27044__$1;
(statearr_27093_27151[(5)] = ex27088);


var statearr_27094_27152 = state_27044__$1;
(statearr_27094_27152[(1)] = (4));

(statearr_27094_27152[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (14))){
var inst_26954 = (state_27044[(7)]);
var state_27044__$1 = state_27044;
var statearr_27095_27153 = state_27044__$1;
(statearr_27095_27153[(2)] = inst_26954);

(statearr_27095_27153[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (26))){
var state_27044__$1 = state_27044;
var statearr_27096_27154 = state_27044__$1;
(statearr_27096_27154[(2)] = null);

(statearr_27096_27154[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (16))){
var inst_26963 = cljs.core.first(ident);
var inst_26964 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_26963], 0));
var inst_26965 = ["Subject ID lookup failed. The predicate ",inst_26964," does not exist."].join('');
var inst_26966 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26967 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26968 = cljs.core.PersistentHashMap.fromArrays(inst_26966,inst_26967);
var inst_26969 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26965,inst_26968);
var inst_26970 = (function(){throw inst_26969})();
var state_27044__$1 = state_27044;
var statearr_27097_27155 = state_27044__$1;
(statearr_27097_27155[(2)] = inst_26970);

(statearr_27097_27155[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (38))){
var inst_27024 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27025 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27026 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27027 = cljs.core.PersistentHashMap.fromArrays(inst_27025,inst_27026);
var inst_27028 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27024,inst_27027);
var inst_27029 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27028);
var state_27044__$1 = state_27044;
var statearr_27098_27156 = state_27044__$1;
(statearr_27098_27156[(2)] = inst_27029);

(statearr_27098_27156[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (30))){
var state_27044__$1 = state_27044;
var statearr_27099_27157 = state_27044__$1;
(statearr_27099_27157[(2)] = null);

(statearr_27099_27157[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (10))){
var state_27044__$1 = state_27044;
var statearr_27100_27158 = state_27044__$1;
(statearr_27100_27158[(2)] = ident);

(statearr_27100_27158[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (18))){
var inst_27012 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
var statearr_27101_27159 = state_27044__$1;
(statearr_27101_27159[(2)] = inst_27012);

(statearr_27101_27159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (42))){
var state_27044__$1 = state_27044;
var statearr_27102_27160 = state_27044__$1;
(statearr_27102_27160[(2)] = null);

(statearr_27102_27160[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (37))){
var inst_27022 = (state_27044[(2)]);
var state_27044__$1 = state_27044;
if(cljs.core.truth_(inst_27022)){
var statearr_27103_27161 = state_27044__$1;
(statearr_27103_27161[(1)] = (38));

} else {
var statearr_27104_27162 = state_27044__$1;
(statearr_27104_27162[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27045 === (8))){
var inst_27014 = (state_27044[(10)]);
var inst_27014__$1 = (state_27044[(2)]);
var state_27044__$1 = (function (){var statearr_27105 = state_27044;
(statearr_27105[(10)] = inst_27014__$1);

return statearr_27105;
})();
if(cljs.core.truth_(inst_27014__$1)){
var statearr_27106_27163 = state_27044__$1;
(statearr_27106_27163[(1)] = (32));

} else {
var statearr_27107_27164 = state_27044__$1;
(statearr_27107_27164[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2733__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2733__auto____0 = (function (){
var statearr_27108 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27108[(0)] = fluree$db$graphdb$subid_$_state_machine__2733__auto__);

(statearr_27108[(1)] = (1));

return statearr_27108;
});
var fluree$db$graphdb$subid_$_state_machine__2733__auto____1 = (function (state_27044){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27044);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27109){var ex__2736__auto__ = e27109;
var statearr_27110_27165 = state_27044;
(statearr_27110_27165[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27044[(4)]))){
var statearr_27111_27166 = state_27044;
(statearr_27111_27166[(1)] = cljs.core.first((state_27044[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27167 = state_27044;
state_27044 = G__27167;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2733__auto__ = function(state_27044){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2733__auto____1.call(this,state_27044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2733__auto____0;
fluree$db$graphdb$subid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2733__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27112 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27112[(6)] = c__2755__auto___27113);

return statearr_27112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k27169,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__27173 = k27169;
var G__27173__$1 = (((G__27173 instanceof cljs.core.Keyword))?G__27173.fqn:null);
switch (G__27173__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27169,else__4475__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__27174){
var vec__27175 = p__27174;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27175,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27175,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27168){
var self__ = this;
var G__27168__$1 = this;
return (new cljs.core.RecordIter((0),G__27168__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__27178 = (function (coll__4469__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__27178(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27170,other27171){
var self__ = this;
var this27170__$1 = this;
return (((!((other27171 == null)))) && ((((this27170__$1.constructor === other27171.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.conn,other27171.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.network,other27171.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.dbid,other27171.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.block,other27171.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.t,other27171.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.tt_id,other27171.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.stats,other27171.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.spot,other27171.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.psot,other27171.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.post,other27171.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.opst,other27171.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.schema,other27171.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.settings,other27171.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.index_configs,other27171.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.schema_cache,other27171.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.novelty,other27171.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.permissions,other27171.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.fork,other27171.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.fork_block,other27171.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.current_db_fn,other27171.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27170__$1.__extmap,other27171.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k27169){
var self__ = this;
var this__4479__auto____$1 = this;
var G__27179 = k27169;
var G__27179__$1 = (((G__27179 instanceof cljs.core.Keyword))?G__27179.fqn:null);
switch (G__27179__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27169);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__27168){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__27180 = cljs.core.keyword_identical_QMARK_;
var expr__27181 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__27183 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27184 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27183,G__27184) : pred__27180.call(null,G__27183,G__27184));
})())){
return (new fluree.db.graphdb.GraphDb(G__27168,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27185 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27186 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27185,G__27186) : pred__27180.call(null,G__27185,G__27186));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27168,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27187 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27188 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27187,G__27188) : pred__27180.call(null,G__27187,G__27188));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27168,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27189 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27190 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27189,G__27190) : pred__27180.call(null,G__27189,G__27190));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27168,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27191 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27192 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27191,G__27192) : pred__27180.call(null,G__27191,G__27192));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27168,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27193 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27194 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27193,G__27194) : pred__27180.call(null,G__27193,G__27194));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27168,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27195 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27196 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27195,G__27196) : pred__27180.call(null,G__27195,G__27196));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27168,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27197 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27198 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27197,G__27198) : pred__27180.call(null,G__27197,G__27198));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27168,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27199 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27200 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27199,G__27200) : pred__27180.call(null,G__27199,G__27200));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27168,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27201 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27202 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27201,G__27202) : pred__27180.call(null,G__27201,G__27202));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27168,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27203 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27204 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27203,G__27204) : pred__27180.call(null,G__27203,G__27204));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27168,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27205 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27206 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27205,G__27206) : pred__27180.call(null,G__27205,G__27206));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27168,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27207 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27208 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27207,G__27208) : pred__27180.call(null,G__27207,G__27208));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27168,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27209 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__27210 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27209,G__27210) : pred__27180.call(null,G__27209,G__27210));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27168,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27211 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27212 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27211,G__27212) : pred__27180.call(null,G__27211,G__27212));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27168,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27213 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27214 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27213,G__27214) : pred__27180.call(null,G__27213,G__27214));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27168,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27215 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27216 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27215,G__27216) : pred__27180.call(null,G__27215,G__27216));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27168,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27217 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27218 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27217,G__27218) : pred__27180.call(null,G__27217,G__27218));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27168,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27219 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27220 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27219,G__27220) : pred__27180.call(null,G__27219,G__27220));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27168,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27221 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27222 = expr__27181;
return (pred__27180.cljs$core$IFn$_invoke$arity$2 ? pred__27180.cljs$core$IFn$_invoke$arity$2(G__27221,G__27222) : pred__27180.call(null,G__27221,G__27222));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27168,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__27168),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__27168){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27168,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27238){
var state_val_27239 = (state_27238[(1)]);
if((state_val_27239 === (1))){
var state_27238__$1 = state_27238;
var statearr_27240_27507 = state_27238__$1;
(statearr_27240_27507[(2)] = null);

(statearr_27240_27507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (2))){
var _ = (function (){var statearr_27241 = state_27238;
(statearr_27241[(4)] = cljs.core.cons((5),(state_27238[(4)])));

return statearr_27241;
})();
var inst_27229 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_27238__$1 = state_27238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27238__$1,(6),inst_27229);
} else {
if((state_val_27239 === (3))){
var inst_27236 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27238__$1,inst_27236);
} else {
if((state_val_27239 === (4))){
var inst_27223 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
var statearr_27243_27508 = state_27238__$1;
(statearr_27243_27508[(2)] = inst_27223);

(statearr_27243_27508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (5))){
var _ = (function (){var statearr_27244 = state_27238;
(statearr_27244[(4)] = cljs.core.rest((state_27238[(4)])));

return statearr_27244;
})();
var state_27238__$1 = state_27238;
var ex27242 = (state_27238__$1[(2)]);
var statearr_27245_27509 = state_27238__$1;
(statearr_27245_27509[(5)] = ex27242);


if((ex27242 instanceof Error)){
var statearr_27246_27510 = state_27238__$1;
(statearr_27246_27510[(1)] = (4));

(statearr_27246_27510[(5)] = null);

} else {
throw ex27242;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (6))){
var inst_27231 = (state_27238[(2)]);
var inst_27232 = fluree.db.util.async.throw_err(inst_27231);
var inst_27233 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27232,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_27247 = state_27238;
(statearr_27247[(4)] = cljs.core.rest((state_27238[(4)])));

return statearr_27247;
})();
var state_27238__$1 = state_27238;
var statearr_27248_27511 = state_27238__$1;
(statearr_27248_27511[(2)] = inst_27233);

(statearr_27248_27511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27249 = [null,null,null,null,null,null,null];
(statearr_27249[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27249[(1)] = (1));

return statearr_27249;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27238){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27238);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27250){var ex__2736__auto__ = e27250;
var statearr_27251_27512 = state_27238;
(statearr_27251_27512[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27238[(4)]))){
var statearr_27252_27513 = state_27238;
(statearr_27252_27513[(1)] = cljs.core.first((state_27238[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27514 = state_27238;
state_27238 = G__27514;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27238){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27253 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27253[(6)] = c__2755__auto__);

return statearr_27253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__27254 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__27254.cljs$core$IFn$_invoke$arity$1 ? fexpr__27254.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27254.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__27255 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__27255.cljs$core$IFn$_invoke$arity$1 ? fexpr__27255.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27255.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__27256 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"partition","partition",1174740751),G__27256);
} else {
return G__27256;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27288){
var state_val_27289 = (state_27288[(1)]);
if((state_val_27289 === (7))){
var state_27288__$1 = state_27288;
var statearr_27290_27515 = state_27288__$1;
(statearr_27290_27515[(2)] = null);

(statearr_27290_27515[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27289 === (1))){
var state_27288__$1 = state_27288;
var statearr_27291_27516 = state_27288__$1;
(statearr_27291_27516[(2)] = null);

(statearr_27291_27516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27289 === (4))){
var inst_27257 = (state_27288[(2)]);
var state_27288__$1 = state_27288;
var statearr_27292_27517 = state_27288__$1;
(statearr_27292_27517[(2)] = inst_27257);

(statearr_27292_27517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27289 === (6))){
var inst_27271 = (state_27288[(7)]);
var inst_27270 = (state_27288[(2)]);
var inst_27271__$1 = fluree.db.util.async.throw_err(inst_27270);
var inst_27272 = (inst_27271__$1 == null);
var state_27288__$1 = (function (){var statearr_27293 = state_27288;
(statearr_27293[(7)] = inst_27271__$1);

return statearr_27293;
})();
if(cljs.core.truth_(inst_27272)){
var statearr_27294_27518 = state_27288__$1;
(statearr_27294_27518[(1)] = (7));

} else {
var statearr_27295_27519 = state_27288__$1;
(statearr_27295_27519[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27289 === (3))){
var inst_27286 = (state_27288[(2)]);
var state_27288__$1 = state_27288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27288__$1,inst_27286);
} else {
if((state_val_27289 === (12))){
var inst_27283 = (state_27288[(2)]);
var _ = (function (){var statearr_27296 = state_27288;
(statearr_27296[(4)] = cljs.core.rest((state_27288[(4)])));

return statearr_27296;
})();
var state_27288__$1 = state_27288;
var statearr_27297_27520 = state_27288__$1;
(statearr_27297_27520[(2)] = inst_27283);

(statearr_27297_27520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27289 === (2))){
var _ = (function (){var statearr_27298 = state_27288;
(statearr_27298[(4)] = cljs.core.cons((5),(state_27288[(4)])));

return statearr_27298;
})();
var inst_27264 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_27265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27266 = [tag_id,(30)];
var inst_27267 = (new cljs.core.PersistentVector(null,2,(5),inst_27265,inst_27266,null));
var inst_27268 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27264,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27267);
var state_27288__$1 = state_27288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27288__$1,(6),inst_27268);
} else {
if((state_val_27289 === (11))){
var inst_27277 = (state_27288[(8)]);
var inst_27281 = inst_27277.o;
var state_27288__$1 = state_27288;
var statearr_27300_27521 = state_27288__$1;
(statearr_27300_27521[(2)] = inst_27281);

(statearr_27300_27521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27289 === (9))){
var inst_27277 = (state_27288[(8)]);
var inst_27277__$1 = (state_27288[(2)]);
var inst_27278 = (inst_27277__$1 == null);
var state_27288__$1 = (function (){var statearr_27301 = state_27288;
(statearr_27301[(8)] = inst_27277__$1);

return statearr_27301;
})();
if(cljs.core.truth_(inst_27278)){
var statearr_27302_27522 = state_27288__$1;
(statearr_27302_27522[(1)] = (10));

} else {
var statearr_27303_27523 = state_27288__$1;
(statearr_27303_27523[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27289 === (5))){
var _ = (function (){var statearr_27304 = state_27288;
(statearr_27304[(4)] = cljs.core.rest((state_27288[(4)])));

return statearr_27304;
})();
var state_27288__$1 = state_27288;
var ex27299 = (state_27288__$1[(2)]);
var statearr_27305_27524 = state_27288__$1;
(statearr_27305_27524[(5)] = ex27299);


if((ex27299 instanceof Error)){
var statearr_27306_27525 = state_27288__$1;
(statearr_27306_27525[(1)] = (4));

(statearr_27306_27525[(5)] = null);

} else {
throw ex27299;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27289 === (10))){
var state_27288__$1 = state_27288;
var statearr_27307_27526 = state_27288__$1;
(statearr_27307_27526[(2)] = null);

(statearr_27307_27526[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27289 === (8))){
var inst_27271 = (state_27288[(7)]);
var inst_27275 = cljs.core.first(inst_27271);
var state_27288__$1 = state_27288;
var statearr_27308_27527 = state_27288__$1;
(statearr_27308_27527[(2)] = inst_27275);

(statearr_27308_27527[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27309 = [null,null,null,null,null,null,null,null,null];
(statearr_27309[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27309[(1)] = (1));

return statearr_27309;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27288){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27288);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27310){var ex__2736__auto__ = e27310;
var statearr_27311_27528 = state_27288;
(statearr_27311_27528[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27288[(4)]))){
var statearr_27312_27529 = state_27288;
(statearr_27312_27529[(1)] = cljs.core.first((state_27288[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27530 = state_27288;
state_27288 = G__27530;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27288){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27313 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27313[(6)] = c__2755__auto__);

return statearr_27313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27349){
var state_val_27350 = (state_27349[(1)]);
if((state_val_27350 === (7))){
var inst_27323 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27349__$1 = state_27349;
var statearr_27351_27531 = state_27349__$1;
(statearr_27351_27531[(2)] = inst_27323);

(statearr_27351_27531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (1))){
var state_27349__$1 = state_27349;
var statearr_27352_27532 = state_27349__$1;
(statearr_27352_27532[(2)] = null);

(statearr_27352_27532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (4))){
var inst_27314 = (state_27349[(2)]);
var state_27349__$1 = state_27349;
var statearr_27353_27533 = state_27349__$1;
(statearr_27353_27533[(2)] = inst_27314);

(statearr_27353_27533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (15))){
var inst_27344 = (state_27349[(2)]);
var _ = (function (){var statearr_27354 = state_27349;
(statearr_27354[(4)] = cljs.core.rest((state_27349[(4)])));

return statearr_27354;
})();
var state_27349__$1 = state_27349;
var statearr_27355_27534 = state_27349__$1;
(statearr_27355_27534[(2)] = inst_27344);

(statearr_27355_27534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (13))){
var inst_27329 = (state_27349[(7)]);
var inst_27335 = clojure.string.includes_QMARK_(inst_27329,":");
var state_27349__$1 = state_27349;
if(inst_27335){
var statearr_27356_27535 = state_27349__$1;
(statearr_27356_27535[(1)] = (16));

} else {
var statearr_27357_27536 = state_27349__$1;
(statearr_27357_27536[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (6))){
var state_27349__$1 = state_27349;
var statearr_27358_27537 = state_27349__$1;
(statearr_27358_27537[(2)] = pred);

(statearr_27358_27537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (17))){
var inst_27329 = (state_27349[(7)]);
var state_27349__$1 = state_27349;
var statearr_27359_27538 = state_27349__$1;
(statearr_27359_27538[(2)] = inst_27329);

(statearr_27359_27538[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (3))){
var inst_27347 = (state_27349[(2)]);
var state_27349__$1 = state_27349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27349__$1,inst_27347);
} else {
if((state_val_27350 === (12))){
var inst_27333 = (state_27349[(2)]);
var state_27349__$1 = state_27349;
if(cljs.core.truth_(inst_27333)){
var statearr_27360_27539 = state_27349__$1;
(statearr_27360_27539[(1)] = (13));

} else {
var statearr_27361_27540 = state_27349__$1;
(statearr_27361_27540[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (2))){
var _ = (function (){var statearr_27362 = state_27349;
(statearr_27362[(4)] = cljs.core.cons((5),(state_27349[(4)])));

return statearr_27362;
})();
var inst_27320 = typeof pred === 'string';
var state_27349__$1 = state_27349;
if(cljs.core.truth_(inst_27320)){
var statearr_27363_27541 = state_27349__$1;
(statearr_27363_27541[(1)] = (6));

} else {
var statearr_27364_27542 = state_27349__$1;
(statearr_27364_27542[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (11))){
var inst_27325 = (state_27349[(8)]);
var state_27349__$1 = state_27349;
var statearr_27366_27543 = state_27349__$1;
(statearr_27366_27543[(2)] = inst_27325);

(statearr_27366_27543[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (9))){
var inst_27325 = (state_27349[(8)]);
var inst_27328 = (state_27349[(2)]);
var inst_27329 = fluree.db.util.async.throw_err(inst_27328);
var state_27349__$1 = (function (){var statearr_27367 = state_27349;
(statearr_27367[(7)] = inst_27329);

return statearr_27367;
})();
if(cljs.core.truth_(inst_27325)){
var statearr_27368_27544 = state_27349__$1;
(statearr_27368_27544[(1)] = (10));

} else {
var statearr_27369_27545 = state_27349__$1;
(statearr_27369_27545[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (5))){
var _ = (function (){var statearr_27370 = state_27349;
(statearr_27370[(4)] = cljs.core.rest((state_27349[(4)])));

return statearr_27370;
})();
var state_27349__$1 = state_27349;
var ex27365 = (state_27349__$1[(2)]);
var statearr_27371_27546 = state_27349__$1;
(statearr_27371_27546[(5)] = ex27365);


if((ex27365 instanceof Error)){
var statearr_27372_27547 = state_27349__$1;
(statearr_27372_27547[(1)] = (4));

(statearr_27372_27547[(5)] = null);

} else {
throw ex27365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (14))){
var state_27349__$1 = state_27349;
var statearr_27373_27548 = state_27349__$1;
(statearr_27373_27548[(2)] = null);

(statearr_27373_27548[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (16))){
var inst_27329 = (state_27349[(7)]);
var inst_27337 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_27329,/:/);
var inst_27338 = cljs.core.second(inst_27337);
var state_27349__$1 = state_27349;
var statearr_27374_27549 = state_27349__$1;
(statearr_27374_27549[(2)] = inst_27338);

(statearr_27374_27549[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (10))){
var inst_27329 = (state_27349[(7)]);
var state_27349__$1 = state_27349;
var statearr_27375_27550 = state_27349__$1;
(statearr_27375_27550[(2)] = inst_27329);

(statearr_27375_27550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (18))){
var inst_27341 = (state_27349[(2)]);
var state_27349__$1 = state_27349;
var statearr_27376_27551 = state_27349__$1;
(statearr_27376_27551[(2)] = inst_27341);

(statearr_27376_27551[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27350 === (8))){
var inst_27325 = (state_27349[(2)]);
var inst_27326 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_27349__$1 = (function (){var statearr_27377 = state_27349;
(statearr_27377[(8)] = inst_27325);

return statearr_27377;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27349__$1,(9),inst_27326);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27378 = [null,null,null,null,null,null,null,null,null];
(statearr_27378[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27378[(1)] = (1));

return statearr_27378;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27349){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27349);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27379){var ex__2736__auto__ = e27379;
var statearr_27380_27552 = state_27349;
(statearr_27380_27552[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27349[(4)]))){
var statearr_27381_27553 = state_27349;
(statearr_27381_27553[(1)] = cljs.core.first((state_27349[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27554 = state_27349;
state_27349 = G__27554;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27349){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27382 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27382[(6)] = c__2755__auto__);

return statearr_27382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27415){
var state_val_27416 = (state_27415[(1)]);
if((state_val_27416 === (7))){
var state_27415__$1 = state_27415;
var statearr_27417_27555 = state_27415__$1;
(statearr_27417_27555[(2)] = null);

(statearr_27417_27555[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (1))){
var state_27415__$1 = state_27415;
var statearr_27418_27556 = state_27415__$1;
(statearr_27418_27556[(2)] = null);

(statearr_27418_27556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (4))){
var inst_27383 = (state_27415[(2)]);
var state_27415__$1 = state_27415;
var statearr_27419_27557 = state_27415__$1;
(statearr_27419_27557[(2)] = inst_27383);

(statearr_27419_27557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (6))){
var inst_27398 = (state_27415[(7)]);
var inst_27397 = (state_27415[(2)]);
var inst_27398__$1 = fluree.db.util.async.throw_err(inst_27397);
var inst_27399 = (inst_27398__$1 == null);
var state_27415__$1 = (function (){var statearr_27420 = state_27415;
(statearr_27420[(7)] = inst_27398__$1);

return statearr_27420;
})();
if(cljs.core.truth_(inst_27399)){
var statearr_27421_27558 = state_27415__$1;
(statearr_27421_27558[(1)] = (7));

} else {
var statearr_27422_27559 = state_27415__$1;
(statearr_27422_27559[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (3))){
var inst_27413 = (state_27415[(2)]);
var state_27415__$1 = state_27415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27415__$1,inst_27413);
} else {
if((state_val_27416 === (12))){
var inst_27410 = (state_27415[(2)]);
var _ = (function (){var statearr_27423 = state_27415;
(statearr_27423[(4)] = cljs.core.rest((state_27415[(4)])));

return statearr_27423;
})();
var state_27415__$1 = state_27415;
var statearr_27424_27560 = state_27415__$1;
(statearr_27424_27560[(2)] = inst_27410);

(statearr_27424_27560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (2))){
var _ = (function (){var statearr_27425 = state_27415;
(statearr_27425[(4)] = cljs.core.cons((5),(state_27415[(4)])));

return statearr_27425;
})();
var inst_27389 = (30);
var inst_27391 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_27392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27393 = [inst_27389,tag_name];
var inst_27394 = (new cljs.core.PersistentVector(null,2,(5),inst_27392,inst_27393,null));
var inst_27395 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27391,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27394);
var state_27415__$1 = state_27415;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27415__$1,(6),inst_27395);
} else {
if((state_val_27416 === (11))){
var inst_27404 = (state_27415[(8)]);
var inst_27408 = inst_27404.s;
var state_27415__$1 = state_27415;
var statearr_27427_27561 = state_27415__$1;
(statearr_27427_27561[(2)] = inst_27408);

(statearr_27427_27561[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (9))){
var inst_27404 = (state_27415[(8)]);
var inst_27404__$1 = (state_27415[(2)]);
var inst_27405 = (inst_27404__$1 == null);
var state_27415__$1 = (function (){var statearr_27428 = state_27415;
(statearr_27428[(8)] = inst_27404__$1);

return statearr_27428;
})();
if(cljs.core.truth_(inst_27405)){
var statearr_27429_27562 = state_27415__$1;
(statearr_27429_27562[(1)] = (10));

} else {
var statearr_27430_27563 = state_27415__$1;
(statearr_27430_27563[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (5))){
var _ = (function (){var statearr_27431 = state_27415;
(statearr_27431[(4)] = cljs.core.rest((state_27415[(4)])));

return statearr_27431;
})();
var state_27415__$1 = state_27415;
var ex27426 = (state_27415__$1[(2)]);
var statearr_27432_27564 = state_27415__$1;
(statearr_27432_27564[(5)] = ex27426);


if((ex27426 instanceof Error)){
var statearr_27433_27565 = state_27415__$1;
(statearr_27433_27565[(1)] = (4));

(statearr_27433_27565[(5)] = null);

} else {
throw ex27426;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (10))){
var state_27415__$1 = state_27415;
var statearr_27434_27566 = state_27415__$1;
(statearr_27434_27566[(2)] = null);

(statearr_27434_27566[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (8))){
var inst_27398 = (state_27415[(7)]);
var inst_27402 = cljs.core.first(inst_27398);
var state_27415__$1 = state_27415;
var statearr_27435_27567 = state_27415__$1;
(statearr_27435_27567[(2)] = inst_27402);

(statearr_27435_27567[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27436 = [null,null,null,null,null,null,null,null,null];
(statearr_27436[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27436[(1)] = (1));

return statearr_27436;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27415){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27415);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27437){var ex__2736__auto__ = e27437;
var statearr_27438_27568 = state_27415;
(statearr_27438_27568[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27415[(4)]))){
var statearr_27439_27569 = state_27415;
(statearr_27439_27569[(1)] = cljs.core.first((state_27415[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27570 = state_27415;
state_27415 = G__27570;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27415){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27440 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27440[(6)] = c__2755__auto__);

return statearr_27440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27475){
var state_val_27476 = (state_27475[(1)]);
if((state_val_27476 === (7))){
var inst_27454 = typeof pred === 'string';
var state_27475__$1 = state_27475;
if(cljs.core.truth_(inst_27454)){
var statearr_27477_27571 = state_27475__$1;
(statearr_27477_27571[(1)] = (10));

} else {
var statearr_27478_27572 = state_27475__$1;
(statearr_27478_27572[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (1))){
var state_27475__$1 = state_27475;
var statearr_27479_27573 = state_27475__$1;
(statearr_27479_27573[(2)] = null);

(statearr_27479_27573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (4))){
var inst_27441 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
var statearr_27480_27574 = state_27475__$1;
(statearr_27480_27574[(2)] = inst_27441);

(statearr_27480_27574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (15))){
var inst_27468 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
var statearr_27481_27575 = state_27475__$1;
(statearr_27481_27575[(2)] = inst_27468);

(statearr_27481_27575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (13))){
var inst_27459 = (state_27475[(7)]);
var inst_27461 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27459),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27462 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_27461);
var state_27475__$1 = state_27475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27475__$1,(16),inst_27462);
} else {
if((state_val_27476 === (6))){
var inst_27449 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_27475__$1 = state_27475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27475__$1,(9),inst_27449);
} else {
if((state_val_27476 === (3))){
var inst_27473 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27475__$1,inst_27473);
} else {
if((state_val_27476 === (12))){
var inst_27459 = (state_27475[(7)]);
var inst_27459__$1 = (state_27475[(2)]);
var state_27475__$1 = (function (){var statearr_27482 = state_27475;
(statearr_27482[(7)] = inst_27459__$1);

return statearr_27482;
})();
if(cljs.core.truth_(inst_27459__$1)){
var statearr_27483_27576 = state_27475__$1;
(statearr_27483_27576[(1)] = (13));

} else {
var statearr_27484_27577 = state_27475__$1;
(statearr_27484_27577[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (2))){
var _ = (function (){var statearr_27485 = state_27475;
(statearr_27485[(4)] = cljs.core.cons((5),(state_27475[(4)])));

return statearr_27485;
})();
var inst_27447 = clojure.string.includes_QMARK_(tag_name,"/");
var state_27475__$1 = state_27475;
if(inst_27447){
var statearr_27486_27578 = state_27475__$1;
(statearr_27486_27578[(1)] = (6));

} else {
var statearr_27487_27579 = state_27475__$1;
(statearr_27487_27579[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (11))){
var inst_27457 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27475__$1 = state_27475;
var statearr_27489_27580 = state_27475__$1;
(statearr_27489_27580[(2)] = inst_27457);

(statearr_27489_27580[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (9))){
var inst_27451 = (state_27475[(2)]);
var inst_27452 = fluree.db.util.async.throw_err(inst_27451);
var state_27475__$1 = state_27475;
var statearr_27490_27581 = state_27475__$1;
(statearr_27490_27581[(2)] = inst_27452);

(statearr_27490_27581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (5))){
var _ = (function (){var statearr_27491 = state_27475;
(statearr_27491[(4)] = cljs.core.rest((state_27475[(4)])));

return statearr_27491;
})();
var state_27475__$1 = state_27475;
var ex27488 = (state_27475__$1[(2)]);
var statearr_27492_27582 = state_27475__$1;
(statearr_27492_27582[(5)] = ex27488);


if((ex27488 instanceof Error)){
var statearr_27493_27583 = state_27475__$1;
(statearr_27493_27583[(1)] = (4));

(statearr_27493_27583[(5)] = null);

} else {
throw ex27488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (14))){
var state_27475__$1 = state_27475;
var statearr_27494_27584 = state_27475__$1;
(statearr_27494_27584[(2)] = null);

(statearr_27494_27584[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (16))){
var inst_27464 = (state_27475[(2)]);
var inst_27465 = fluree.db.util.async.throw_err(inst_27464);
var state_27475__$1 = state_27475;
var statearr_27495_27585 = state_27475__$1;
(statearr_27495_27585[(2)] = inst_27465);

(statearr_27495_27585[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (10))){
var state_27475__$1 = state_27475;
var statearr_27496_27586 = state_27475__$1;
(statearr_27496_27586[(2)] = pred);

(statearr_27496_27586[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (8))){
var inst_27470 = (state_27475[(2)]);
var _ = (function (){var statearr_27497 = state_27475;
(statearr_27497[(4)] = cljs.core.rest((state_27475[(4)])));

return statearr_27497;
})();
var state_27475__$1 = state_27475;
var statearr_27498_27587 = state_27475__$1;
(statearr_27498_27587[(2)] = inst_27470);

(statearr_27498_27587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27499 = [null,null,null,null,null,null,null,null];
(statearr_27499[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27499[(1)] = (1));

return statearr_27499;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27475){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27475);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27500){var ex__2736__auto__ = e27500;
var statearr_27501_27588 = state_27475;
(statearr_27501_27588[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27475[(4)]))){
var statearr_27502_27589 = state_27475;
(statearr_27502_27589[(1)] = cljs.core.first((state_27475[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27590 = state_27475;
state_27475 = G__27590;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27475){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27503 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27503[(6)] = c__2755__auto__);

return statearr_27503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27172){
var extmap__4512__auto__ = (function (){var G__27504 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27172,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__27172)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27504);
} else {
return G__27504;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27172),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27172),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
