// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__63378 = arguments.length;
switch (G__63378) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63420){
var state_val_63421 = (state_63420[(1)]);
if((state_val_63421 === (7))){
var inst_63390 = typeof user === 'string';
var state_63420__$1 = state_63420;
if(cljs.core.truth_(inst_63390)){
var statearr_63422_63451 = state_63420__$1;
(statearr_63422_63451[(1)] = (9));

} else {
var statearr_63423_63452 = state_63420__$1;
(statearr_63423_63452[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (1))){
var state_63420__$1 = state_63420;
var statearr_63424_63453 = state_63420__$1;
(statearr_63424_63453[(2)] = null);

(statearr_63424_63453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (4))){
var inst_63379 = (state_63420[(2)]);
var inst_63380 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63379], 0));
var inst_63381 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63379) : reject.call(null,inst_63379));
var state_63420__$1 = (function (){var statearr_63425 = state_63420;
(statearr_63425[(7)] = inst_63380);

return statearr_63425;
})();
var statearr_63426_63454 = state_63420__$1;
(statearr_63426_63454[(2)] = inst_63381);

(statearr_63426_63454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (15))){
var inst_63409 = (state_63420[(2)]);
var inst_63410 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_63409);
var inst_63411 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63412 = cljs.core.constantly(inst_63410);
var inst_63413 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63411,inst_63412);
var inst_63414 = fluree.db.connection.add_token(conn,inst_63410);
var inst_63415 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_63409) : resolve.call(null,inst_63409));
var _ = (function (){var statearr_63427 = state_63420;
(statearr_63427[(4)] = cljs.core.rest((state_63420[(4)])));

return statearr_63427;
})();
var state_63420__$1 = (function (){var statearr_63428 = state_63420;
(statearr_63428[(8)] = inst_63413);

(statearr_63428[(9)] = inst_63414);

return statearr_63428;
})();
var statearr_63429_63455 = state_63420__$1;
(statearr_63429_63455[(2)] = inst_63415);

(statearr_63429_63455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (13))){
var state_63420__$1 = state_63420;
var statearr_63430_63456 = state_63420__$1;
(statearr_63430_63456[(2)] = null);

(statearr_63430_63456[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (6))){
var state_63420__$1 = state_63420;
var statearr_63431_63457 = state_63420__$1;
(statearr_63431_63457[(2)] = user);

(statearr_63431_63457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (3))){
var inst_63418 = (state_63420[(2)]);
var state_63420__$1 = state_63420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63420__$1,inst_63418);
} else {
if((state_val_63421 === (12))){
var state_63420__$1 = state_63420;
var statearr_63432_63458 = state_63420__$1;
(statearr_63432_63458[(2)] = user);

(statearr_63432_63458[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (2))){
var _ = (function (){var statearr_63433 = state_63420;
(statearr_63433[(4)] = cljs.core.cons((5),(state_63420[(4)])));

return statearr_63433;
})();
var inst_63387 = typeof user === 'number';
var state_63420__$1 = state_63420;
if(cljs.core.truth_(inst_63387)){
var statearr_63434_63459 = state_63420__$1;
(statearr_63434_63459[(1)] = (6));

} else {
var statearr_63435_63460 = state_63420__$1;
(statearr_63435_63460[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (11))){
var inst_63401 = (state_63420[(2)]);
var state_63420__$1 = state_63420;
var statearr_63437_63461 = state_63420__$1;
(statearr_63437_63461[(2)] = inst_63401);

(statearr_63437_63461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (9))){
var inst_63392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63393 = ["_user/username",user];
var inst_63394 = (new cljs.core.PersistentVector(null,2,(5),inst_63392,inst_63393,null));
var state_63420__$1 = state_63420;
var statearr_63438_63462 = state_63420__$1;
(statearr_63438_63462[(2)] = inst_63394);

(statearr_63438_63462[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (5))){
var _ = (function (){var statearr_63439 = state_63420;
(statearr_63439[(4)] = cljs.core.rest((state_63420[(4)])));

return statearr_63439;
})();
var state_63420__$1 = state_63420;
var ex63436 = (state_63420__$1[(2)]);
var statearr_63440_63463 = state_63420__$1;
(statearr_63440_63463[(5)] = ex63436);


var statearr_63441_63464 = state_63420__$1;
(statearr_63441_63464[(1)] = (4));

(statearr_63441_63464[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (14))){
var inst_63399 = (state_63420[(2)]);
var state_63420__$1 = state_63420;
var statearr_63442_63465 = state_63420__$1;
(statearr_63442_63465[(2)] = inst_63399);

(statearr_63442_63465[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (10))){
var state_63420__$1 = state_63420;
var statearr_63443_63466 = state_63420__$1;
(statearr_63443_63466[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63421 === (8))){
var inst_63403 = (state_63420[(2)]);
var inst_63404 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_63405 = [account,inst_63403,password,expireSeconds,syncTo];
var inst_63406 = cljs.core.PersistentHashMap.fromArrays(inst_63404,inst_63405);
var inst_63407 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_63406);
var state_63420__$1 = state_63420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63420__$1,(15),inst_63407);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63445 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63445[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63445[(1)] = (1));

return statearr_63445;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63420){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63420);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63446){var ex__2736__auto__ = e63446;
var statearr_63447_63467 = state_63420;
(statearr_63447_63467[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63420[(4)]))){
var statearr_63448_63468 = state_63420;
(statearr_63448_63468[(1)] = cljs.core.first((state_63420[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63469 = state_63420;
state_63420 = G__63469;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63420){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63449 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63449[(6)] = c__2755__auto__);

return statearr_63449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__63471 = arguments.length;
switch (G__63471) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63480){
var state_val_63481 = (state_63480[(1)]);
if((state_val_63481 === (1))){
var inst_63472 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63474 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_63475 = (new cljs.core.PersistentVector(null,4,(5),inst_63473,inst_63474,null));
var inst_63476 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63472,inst_63475);
var inst_63477 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__63482 = cljs.core.seq(cljs.core.keys(x));
var chunk__63483 = null;
var count__63484 = (0);
var i__63485 = (0);
while(true){
if((i__63485 < count__63484)){
var k = chunk__63483.cljs$core$IIndexed$_nth$arity$2(null,i__63485);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63493 = seq__63482;
var G__63494 = chunk__63483;
var G__63495 = count__63484;
var G__63496 = (i__63485 + (1));
seq__63482 = G__63493;
chunk__63483 = G__63494;
count__63484 = G__63495;
i__63485 = G__63496;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__63482);
if(temp__5753__auto__){
var seq__63482__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63482__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__63482__$1);
var G__63497 = cljs.core.chunk_rest(seq__63482__$1);
var G__63498 = c__4649__auto__;
var G__63499 = cljs.core.count(c__4649__auto__);
var G__63500 = (0);
seq__63482 = G__63497;
chunk__63483 = G__63498;
count__63484 = G__63499;
i__63485 = G__63500;
continue;
} else {
var k = cljs.core.first(seq__63482__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63501 = cljs.core.next(seq__63482__$1);
var G__63502 = null;
var G__63503 = (0);
var G__63504 = (0);
seq__63482 = G__63501;
chunk__63483 = G__63502;
count__63484 = G__63503;
i__63485 = G__63504;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_63478 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63477);
var state_63480__$1 = (function (){var statearr_63486 = state_63480;
(statearr_63486[(7)] = inst_63476);

return statearr_63486;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63480__$1,inst_63478);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63487 = [null,null,null,null,null,null,null,null];
(statearr_63487[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63487[(1)] = (1));

return statearr_63487;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63480){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63480);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63488){var ex__2736__auto__ = e63488;
var statearr_63489_63505 = state_63480;
(statearr_63489_63505[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63480[(4)]))){
var statearr_63490_63506 = state_63480;
(statearr_63490_63506[(1)] = cljs.core.first((state_63480[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63507 = state_63480;
state_63480 = G__63507;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63480){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63491 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63491[(6)] = c__2755__auto__);

return statearr_63491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__63509 = arguments.length;
switch (G__63509) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63543){
var state_val_63544 = (state_63543[(1)]);
if((state_val_63544 === (1))){
var state_63543__$1 = state_63543;
var statearr_63545_63566 = state_63543__$1;
(statearr_63545_63566[(2)] = null);

(statearr_63545_63566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63544 === (2))){
var _ = (function (){var statearr_63546 = state_63543;
(statearr_63546[(4)] = cljs.core.cons((5),(state_63543[(4)])));

return statearr_63546;
})();
var inst_63518 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_63519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63520 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_63521 = (new cljs.core.PersistentVector(null,1,(5),inst_63519,inst_63520,null));
var inst_63522 = cljs.core.PersistentHashMap.EMPTY;
var inst_63523 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63522);
var inst_63524 = cljs.core.assoc_in(inst_63518,inst_63521,inst_63523);
var inst_63525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63526 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63527 = (new cljs.core.PersistentVector(null,1,(5),inst_63525,inst_63526,null));
var inst_63528 = cljs.core.PersistentHashMap.EMPTY;
var inst_63529 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63528);
var inst_63530 = cljs.core.assoc_in(inst_63524,inst_63527,inst_63529);
var inst_63531 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63532 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_63530);
var inst_63533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63534 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_63531,null];
var inst_63535 = (new cljs.core.PersistentVector(null,4,(5),inst_63533,inst_63534,null));
var inst_63536 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63532,inst_63535);
var inst_63537 = (function (){var conn = inst_63530;
var pc = inst_63531;
return (function (x){
if((x == null)){
} else {
var seq__63547_63567 = cljs.core.seq(cljs.core.keys(x));
var chunk__63548_63568 = null;
var count__63549_63569 = (0);
var i__63550_63570 = (0);
while(true){
if((i__63550_63570 < count__63549_63569)){
var k_63571 = chunk__63548_63568.cljs$core$IIndexed$_nth$arity$2(null,i__63550_63570);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63571], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63571,null));


var G__63572 = seq__63547_63567;
var G__63573 = chunk__63548_63568;
var G__63574 = count__63549_63569;
var G__63575 = (i__63550_63570 + (1));
seq__63547_63567 = G__63572;
chunk__63548_63568 = G__63573;
count__63549_63569 = G__63574;
i__63550_63570 = G__63575;
continue;
} else {
var temp__5753__auto___63576 = cljs.core.seq(seq__63547_63567);
if(temp__5753__auto___63576){
var seq__63547_63577__$1 = temp__5753__auto___63576;
if(cljs.core.chunked_seq_QMARK_(seq__63547_63577__$1)){
var c__4649__auto___63578 = cljs.core.chunk_first(seq__63547_63577__$1);
var G__63579 = cljs.core.chunk_rest(seq__63547_63577__$1);
var G__63580 = c__4649__auto___63578;
var G__63581 = cljs.core.count(c__4649__auto___63578);
var G__63582 = (0);
seq__63547_63567 = G__63579;
chunk__63548_63568 = G__63580;
count__63549_63569 = G__63581;
i__63550_63570 = G__63582;
continue;
} else {
var k_63583 = cljs.core.first(seq__63547_63577__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63583], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63583,null));


var G__63584 = cljs.core.next(seq__63547_63577__$1);
var G__63585 = null;
var G__63586 = (0);
var G__63587 = (0);
seq__63547_63567 = G__63584;
chunk__63548_63568 = G__63585;
count__63549_63569 = G__63586;
i__63550_63570 = G__63587;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_63538 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63531,inst_63537);
var ___$1 = (function (){var statearr_63551 = state_63543;
(statearr_63551[(4)] = cljs.core.rest((state_63543[(4)])));

return statearr_63551;
})();
var state_63543__$1 = (function (){var statearr_63552 = state_63543;
(statearr_63552[(7)] = inst_63536);

return statearr_63552;
})();
var statearr_63553_63588 = state_63543__$1;
(statearr_63553_63588[(2)] = inst_63538);

(statearr_63553_63588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63544 === (3))){
var inst_63541 = (state_63543[(2)]);
var state_63543__$1 = state_63543;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63543__$1,inst_63541);
} else {
if((state_val_63544 === (4))){
var inst_63510 = (state_63543[(2)]);
var inst_63511 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63510], 0));
var inst_63512 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63510) : reject.call(null,inst_63510));
var state_63543__$1 = (function (){var statearr_63555 = state_63543;
(statearr_63555[(8)] = inst_63511);

return statearr_63555;
})();
var statearr_63556_63589 = state_63543__$1;
(statearr_63556_63589[(2)] = inst_63512);

(statearr_63556_63589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63544 === (5))){
var _ = (function (){var statearr_63557 = state_63543;
(statearr_63557[(4)] = cljs.core.rest((state_63543[(4)])));

return statearr_63557;
})();
var state_63543__$1 = state_63543;
var ex63554 = (state_63543__$1[(2)]);
var statearr_63558_63590 = state_63543__$1;
(statearr_63558_63590[(5)] = ex63554);


var statearr_63559_63591 = state_63543__$1;
(statearr_63559_63591[(1)] = (4));

(statearr_63559_63591[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63560 = [null,null,null,null,null,null,null,null,null];
(statearr_63560[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63560[(1)] = (1));

return statearr_63560;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63543){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63543);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63561){var ex__2736__auto__ = e63561;
var statearr_63562_63592 = state_63543;
(statearr_63562_63592[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63543[(4)]))){
var statearr_63563_63593 = state_63543;
(statearr_63563_63593[(1)] = cljs.core.first((state_63543[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63594 = state_63543;
state_63543 = G__63594;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63543){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63564 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63564[(6)] = c__2755__auto__);

return statearr_63564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__63596 = arguments.length;
switch (G__63596) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__63598 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63598,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63598,(1),null);
var cb_STAR_ = (function (header,data){
var G__63601 = cljs.core.clj__GT_js(header);
var G__63602 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__63601,G__63602) : callback.call(null,G__63601,G__63602));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__63603 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63603,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63603,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63656){
var state_val_63657 = (state_63656[(1)]);
if((state_val_63657 === (7))){
var inst_63617 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63618 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63619 = cljs.core.PersistentHashMap.fromArrays(inst_63617,inst_63618);
var inst_63620 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63619);
var inst_63621 = (function(){throw inst_63620})();
var state_63656__$1 = state_63656;
var statearr_63658_63690 = state_63656__$1;
(statearr_63658_63690[(2)] = inst_63621);

(statearr_63658_63690[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (1))){
var state_63656__$1 = state_63656;
var statearr_63659_63691 = state_63656__$1;
(statearr_63659_63691[(2)] = null);

(statearr_63659_63691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (4))){
var inst_63606 = (state_63656[(2)]);
var inst_63607 = cljs.core.clj__GT_js(inst_63606);
var inst_63608 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63607) : reject.call(null,inst_63607));
var state_63656__$1 = state_63656;
var statearr_63660_63692 = state_63656__$1;
(statearr_63660_63692[(2)] = inst_63608);

(statearr_63660_63692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (13))){
var inst_63635 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63636 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63637 = cljs.core.PersistentHashMap.fromArrays(inst_63635,inst_63636);
var inst_63638 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_63637);
var inst_63639 = (function(){throw inst_63638})();
var state_63656__$1 = state_63656;
var statearr_63661_63693 = state_63656__$1;
(statearr_63661_63693[(2)] = inst_63639);

(statearr_63661_63693[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (6))){
var state_63656__$1 = state_63656;
var statearr_63662_63694 = state_63656__$1;
(statearr_63662_63694[(2)] = null);

(statearr_63662_63694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (3))){
var inst_63654 = (state_63656[(2)]);
var state_63656__$1 = state_63656;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63656__$1,inst_63654);
} else {
if((state_val_63657 === (12))){
var state_63656__$1 = state_63656;
var statearr_63663_63695 = state_63656__$1;
(statearr_63663_63695[(2)] = null);

(statearr_63663_63695[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (2))){
var _ = (function (){var statearr_63664 = state_63656;
(statearr_63664[(4)] = cljs.core.cons((5),(state_63656[(4)])));

return statearr_63664;
})();
var inst_63614 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63656__$1 = state_63656;
if(cljs.core.truth_(inst_63614)){
var statearr_63665_63696 = state_63656__$1;
(statearr_63665_63696[(1)] = (6));

} else {
var statearr_63666_63697 = state_63656__$1;
(statearr_63666_63697[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (11))){
var inst_63632 = (state_63656[(2)]);
var state_63656__$1 = (function (){var statearr_63668 = state_63656;
(statearr_63668[(7)] = inst_63632);

return statearr_63668;
})();
if(cljs.core.truth_(password)){
var statearr_63669_63698 = state_63656__$1;
(statearr_63669_63698[(1)] = (12));

} else {
var statearr_63670_63699 = state_63656__$1;
(statearr_63670_63699[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (9))){
var state_63656__$1 = state_63656;
var statearr_63671_63700 = state_63656__$1;
(statearr_63671_63700[(2)] = null);

(statearr_63671_63700[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (5))){
var _ = (function (){var statearr_63672 = state_63656;
(statearr_63672[(4)] = cljs.core.rest((state_63656[(4)])));

return statearr_63672;
})();
var state_63656__$1 = state_63656;
var ex63667 = (state_63656__$1[(2)]);
var statearr_63673_63701 = state_63656__$1;
(statearr_63673_63701[(5)] = ex63667);


var statearr_63674_63702 = state_63656__$1;
(statearr_63674_63702[(1)] = (4));

(statearr_63674_63702[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (14))){
var inst_63641 = (state_63656[(2)]);
var inst_63642 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_63643 = fluree.db.util.core.without_nils(inst_63642);
var inst_63644 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63645 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63647 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_63643,inst_63644,null];
var inst_63648 = (new cljs.core.PersistentVector(null,4,(5),inst_63646,inst_63647,null));
var inst_63649 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63645,inst_63648);
var inst_63650 = (function (){var _ = inst_63641;
var data = inst_63643;
var pc = inst_63644;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63675 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63675) : reject.call(null,G__63675));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63676 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63676) : reject.call(null,G__63676));
} else {
var G__63677 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63677) : resolve.call(null,G__63677));

}
}
});
})();
var inst_63651 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63644,inst_63650);
var _ = (function (){var statearr_63678 = state_63656;
(statearr_63678[(4)] = cljs.core.rest((state_63656[(4)])));

return statearr_63678;
})();
var state_63656__$1 = (function (){var statearr_63679 = state_63656;
(statearr_63679[(8)] = inst_63649);

return statearr_63679;
})();
var statearr_63680_63703 = state_63656__$1;
(statearr_63680_63703[(2)] = inst_63651);

(statearr_63680_63703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (10))){
var inst_63626 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63627 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63628 = cljs.core.PersistentHashMap.fromArrays(inst_63626,inst_63627);
var inst_63629 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_63628);
var inst_63630 = (function(){throw inst_63629})();
var state_63656__$1 = state_63656;
var statearr_63681_63704 = state_63656__$1;
(statearr_63681_63704[(2)] = inst_63630);

(statearr_63681_63704[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63657 === (8))){
var inst_63623 = (state_63656[(2)]);
var state_63656__$1 = (function (){var statearr_63682 = state_63656;
(statearr_63682[(9)] = inst_63623);

return statearr_63682;
})();
if(cljs.core.truth_(ledger)){
var statearr_63683_63705 = state_63656__$1;
(statearr_63683_63705[(1)] = (9));

} else {
var statearr_63684_63706 = state_63656__$1;
(statearr_63684_63706[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2733__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2733__auto____0 = (function (){
var statearr_63685 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63685[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2733__auto__);

(statearr_63685[(1)] = (1));

return statearr_63685;
});
var fluree$db$connection_js$password_generate_$_state_machine__2733__auto____1 = (function (state_63656){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63656);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63686){var ex__2736__auto__ = e63686;
var statearr_63687_63707 = state_63656;
(statearr_63687_63707[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63656[(4)]))){
var statearr_63688_63708 = state_63656;
(statearr_63688_63708[(1)] = cljs.core.first((state_63656[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63709 = state_63656;
state_63656 = G__63709;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2733__auto__ = function(state_63656){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2733__auto____1.call(this,state_63656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2733__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2733__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63689 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63689[(6)] = c__2755__auto__);

return statearr_63689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__63711 = arguments.length;
switch (G__63711) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63778){
var state_val_63779 = (state_63778[(1)]);
if((state_val_63779 === (7))){
var inst_63723 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63724 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63725 = cljs.core.PersistentHashMap.fromArrays(inst_63723,inst_63724);
var inst_63726 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63725);
var inst_63727 = (function(){throw inst_63726})();
var state_63778__$1 = state_63778;
var statearr_63780_63822 = state_63778__$1;
(statearr_63780_63822[(2)] = inst_63727);

(statearr_63780_63822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (20))){
var inst_63761 = (state_63778[(2)]);
var inst_63762 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63763 = [ledger,password,user,auth,expire];
var inst_63764 = cljs.core.PersistentHashMap.fromArrays(inst_63762,inst_63763);
var inst_63765 = fluree.db.util.core.without_nils(inst_63764);
var inst_63766 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63767 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63769 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_63765,inst_63766,null];
var inst_63770 = (new cljs.core.PersistentVector(null,4,(5),inst_63768,inst_63769,null));
var inst_63771 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63767,inst_63770);
var inst_63772 = (function (){var _ = inst_63761;
var data = inst_63765;
var pc = inst_63766;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63781 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63781) : reject.call(null,G__63781));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63782 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63782) : reject.call(null,G__63782));
} else {
fluree.db.connection.add_token(conn,result);

var G__63783 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63783) : resolve.call(null,G__63783));

}
}
});
})();
var inst_63773 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63766,inst_63772);
var _ = (function (){var statearr_63784 = state_63778;
(statearr_63784[(4)] = cljs.core.rest((state_63778[(4)])));

return statearr_63784;
})();
var state_63778__$1 = (function (){var statearr_63785 = state_63778;
(statearr_63785[(7)] = inst_63771);

return statearr_63785;
})();
var statearr_63786_63823 = state_63778__$1;
(statearr_63786_63823[(2)] = inst_63773);

(statearr_63786_63823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (1))){
var state_63778__$1 = state_63778;
var statearr_63787_63824 = state_63778__$1;
(statearr_63787_63824[(2)] = null);

(statearr_63787_63824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (4))){
var inst_63712 = (state_63778[(2)]);
var inst_63713 = cljs.core.clj__GT_js(inst_63712);
var inst_63714 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63713) : reject.call(null,inst_63713));
var state_63778__$1 = state_63778;
var statearr_63788_63825 = state_63778__$1;
(statearr_63788_63825[(2)] = inst_63714);

(statearr_63788_63825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (15))){
var inst_63748 = (state_63778[(8)]);
var state_63778__$1 = state_63778;
var statearr_63789_63826 = state_63778__$1;
(statearr_63789_63826[(2)] = inst_63748);

(statearr_63789_63826[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (13))){
var inst_63741 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63742 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63743 = cljs.core.PersistentHashMap.fromArrays(inst_63741,inst_63742);
var inst_63744 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_63743);
var inst_63745 = (function(){throw inst_63744})();
var state_63778__$1 = state_63778;
var statearr_63790_63827 = state_63778__$1;
(statearr_63790_63827[(2)] = inst_63745);

(statearr_63790_63827[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (6))){
var state_63778__$1 = state_63778;
var statearr_63791_63828 = state_63778__$1;
(statearr_63791_63828[(2)] = null);

(statearr_63791_63828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (17))){
var inst_63752 = (state_63778[(2)]);
var state_63778__$1 = state_63778;
if(cljs.core.truth_(inst_63752)){
var statearr_63792_63829 = state_63778__$1;
(statearr_63792_63829[(1)] = (18));

} else {
var statearr_63793_63830 = state_63778__$1;
(statearr_63793_63830[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (3))){
var inst_63776 = (state_63778[(2)]);
var state_63778__$1 = state_63778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63778__$1,inst_63776);
} else {
if((state_val_63779 === (12))){
var state_63778__$1 = state_63778;
var statearr_63794_63831 = state_63778__$1;
(statearr_63794_63831[(2)] = null);

(statearr_63794_63831[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (2))){
var _ = (function (){var statearr_63795 = state_63778;
(statearr_63795[(4)] = cljs.core.cons((5),(state_63778[(4)])));

return statearr_63795;
})();
var inst_63720 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63778__$1 = state_63778;
if(cljs.core.truth_(inst_63720)){
var statearr_63796_63832 = state_63778__$1;
(statearr_63796_63832[(1)] = (6));

} else {
var statearr_63797_63833 = state_63778__$1;
(statearr_63797_63833[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (19))){
var inst_63755 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63756 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63757 = cljs.core.PersistentHashMap.fromArrays(inst_63755,inst_63756);
var inst_63758 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_63757);
var inst_63759 = (function(){throw inst_63758})();
var state_63778__$1 = state_63778;
var statearr_63798_63834 = state_63778__$1;
(statearr_63798_63834[(2)] = inst_63759);

(statearr_63798_63834[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (11))){
var inst_63738 = (state_63778[(2)]);
var state_63778__$1 = (function (){var statearr_63800 = state_63778;
(statearr_63800[(9)] = inst_63738);

return statearr_63800;
})();
if(cljs.core.truth_(password)){
var statearr_63801_63835 = state_63778__$1;
(statearr_63801_63835[(1)] = (12));

} else {
var statearr_63802_63836 = state_63778__$1;
(statearr_63802_63836[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (9))){
var state_63778__$1 = state_63778;
var statearr_63803_63837 = state_63778__$1;
(statearr_63803_63837[(2)] = null);

(statearr_63803_63837[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (5))){
var _ = (function (){var statearr_63804 = state_63778;
(statearr_63804[(4)] = cljs.core.rest((state_63778[(4)])));

return statearr_63804;
})();
var state_63778__$1 = state_63778;
var ex63799 = (state_63778__$1[(2)]);
var statearr_63805_63838 = state_63778__$1;
(statearr_63805_63838[(5)] = ex63799);


var statearr_63806_63839 = state_63778__$1;
(statearr_63806_63839[(1)] = (4));

(statearr_63806_63839[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (14))){
var inst_63748 = (state_63778[(8)]);
var inst_63747 = (state_63778[(2)]);
var inst_63748__$1 = user;
var state_63778__$1 = (function (){var statearr_63807 = state_63778;
(statearr_63807[(8)] = inst_63748__$1);

(statearr_63807[(10)] = inst_63747);

return statearr_63807;
})();
if(cljs.core.truth_(inst_63748__$1)){
var statearr_63808_63840 = state_63778__$1;
(statearr_63808_63840[(1)] = (15));

} else {
var statearr_63809_63841 = state_63778__$1;
(statearr_63809_63841[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (16))){
var state_63778__$1 = state_63778;
var statearr_63810_63842 = state_63778__$1;
(statearr_63810_63842[(2)] = auth);

(statearr_63810_63842[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (10))){
var inst_63732 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63733 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63734 = cljs.core.PersistentHashMap.fromArrays(inst_63732,inst_63733);
var inst_63735 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_63734);
var inst_63736 = (function(){throw inst_63735})();
var state_63778__$1 = state_63778;
var statearr_63811_63843 = state_63778__$1;
(statearr_63811_63843[(2)] = inst_63736);

(statearr_63811_63843[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (18))){
var state_63778__$1 = state_63778;
var statearr_63812_63844 = state_63778__$1;
(statearr_63812_63844[(2)] = null);

(statearr_63812_63844[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63779 === (8))){
var inst_63729 = (state_63778[(2)]);
var state_63778__$1 = (function (){var statearr_63813 = state_63778;
(statearr_63813[(11)] = inst_63729);

return statearr_63813;
})();
if(cljs.core.truth_(ledger)){
var statearr_63814_63845 = state_63778__$1;
(statearr_63814_63845[(1)] = (9));

} else {
var statearr_63815_63846 = state_63778__$1;
(statearr_63815_63846[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63816 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63816[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63816[(1)] = (1));

return statearr_63816;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63778){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63778);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63817){var ex__2736__auto__ = e63817;
var statearr_63818_63847 = state_63778;
(statearr_63818_63847[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63778[(4)]))){
var statearr_63819_63848 = state_63778;
(statearr_63819_63848[(1)] = cljs.core.first((state_63778[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63849 = state_63778;
state_63778 = G__63849;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63778){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63820 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63820[(6)] = c__2755__auto__);

return statearr_63820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63851 = arguments.length;
switch (G__63851) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63886){
var state_val_63887 = (state_63886[(1)]);
if((state_val_63887 === (1))){
var state_63886__$1 = state_63886;
var statearr_63888_63910 = state_63886__$1;
(statearr_63888_63910[(2)] = null);

(statearr_63888_63910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63887 === (2))){
var _ = (function (){var statearr_63889 = state_63886;
(statearr_63889[(4)] = cljs.core.cons((5),(state_63886[(4)])));

return statearr_63889;
})();
var inst_63860 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63886__$1 = state_63886;
if(cljs.core.truth_(inst_63860)){
var statearr_63890_63911 = state_63886__$1;
(statearr_63890_63911[(1)] = (6));

} else {
var statearr_63891_63912 = state_63886__$1;
(statearr_63891_63912[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63887 === (3))){
var inst_63884 = (state_63886[(2)]);
var state_63886__$1 = state_63886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63886__$1,inst_63884);
} else {
if((state_val_63887 === (4))){
var inst_63852 = (state_63886[(2)]);
var inst_63853 = cljs.core.clj__GT_js(inst_63852);
var inst_63854 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63853) : reject.call(null,inst_63853));
var state_63886__$1 = state_63886;
var statearr_63893_63913 = state_63886__$1;
(statearr_63893_63913[(2)] = inst_63854);

(statearr_63893_63913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63887 === (5))){
var _ = (function (){var statearr_63894 = state_63886;
(statearr_63894[(4)] = cljs.core.rest((state_63886[(4)])));

return statearr_63894;
})();
var state_63886__$1 = state_63886;
var ex63892 = (state_63886__$1[(2)]);
var statearr_63895_63914 = state_63886__$1;
(statearr_63895_63914[(5)] = ex63892);


var statearr_63896_63915 = state_63886__$1;
(statearr_63896_63915[(1)] = (4));

(statearr_63896_63915[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63887 === (6))){
var state_63886__$1 = state_63886;
var statearr_63897_63916 = state_63886__$1;
(statearr_63897_63916[(2)] = null);

(statearr_63897_63916[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63887 === (7))){
var inst_63863 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63864 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63865 = cljs.core.PersistentHashMap.fromArrays(inst_63863,inst_63864);
var inst_63866 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63865);
var inst_63867 = (function(){throw inst_63866})();
var state_63886__$1 = state_63886;
var statearr_63898_63917 = state_63886__$1;
(statearr_63898_63917[(2)] = inst_63867);

(statearr_63898_63917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63887 === (8))){
var inst_63869 = (state_63886[(2)]);
var inst_63870 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63871 = [jwt,expire];
var inst_63872 = cljs.core.PersistentHashMap.fromArrays(inst_63870,inst_63871);
var inst_63873 = fluree.db.util.core.without_nils(inst_63872);
var inst_63874 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63875 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63877 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63873,inst_63874,null];
var inst_63878 = (new cljs.core.PersistentVector(null,4,(5),inst_63876,inst_63877,null));
var inst_63879 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63875,inst_63878);
var inst_63880 = (function (){var _ = inst_63869;
var data = inst_63873;
var pc = inst_63874;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63899 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63899) : reject.call(null,G__63899));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__63900 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63900) : resolve.call(null,G__63900));

}
});
})();
var inst_63881 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63874,inst_63880);
var _ = (function (){var statearr_63901 = state_63886;
(statearr_63901[(4)] = cljs.core.rest((state_63886[(4)])));

return statearr_63901;
})();
var state_63886__$1 = (function (){var statearr_63902 = state_63886;
(statearr_63902[(7)] = inst_63879);

return statearr_63902;
})();
var statearr_63903_63918 = state_63886__$1;
(statearr_63903_63918[(2)] = inst_63881);

(statearr_63903_63918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63904 = [null,null,null,null,null,null,null,null];
(statearr_63904[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63904[(1)] = (1));

return statearr_63904;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63886){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63886);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63905){var ex__2736__auto__ = e63905;
var statearr_63906_63919 = state_63886;
(statearr_63906_63919[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63886[(4)]))){
var statearr_63907_63920 = state_63886;
(statearr_63907_63920[(1)] = cljs.core.first((state_63886[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63921 = state_63886;
state_63886 = G__63921;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63886){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63908 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63908[(6)] = c__2755__auto__);

return statearr_63908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

