// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__19012 = cljs.core.get_global_hierarchy;
return (fexpr__19012.cljs$core$IFn$_invoke$arity$0 ? fexpr__19012.cljs$core$IFn$_invoke$arity$0() : fexpr__19012.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__19013 = cljs.core.seq(callbacks);
var chunk__19014 = null;
var count__19015 = (0);
var i__19016 = (0);
while(true){
if((i__19016 < count__19015)){
var vec__19025 = chunk__19014.cljs$core$IIndexed$_nth$arity$2(null,i__19016);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19025,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19025,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e19028){var e_19033 = e19028;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_19033,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__19034 = seq__19013;
var G__19035 = chunk__19014;
var G__19036 = count__19015;
var G__19037 = (i__19016 + (1));
seq__19013 = G__19034;
chunk__19014 = G__19035;
count__19015 = G__19036;
i__19016 = G__19037;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__19013);
if(temp__5753__auto__){
var seq__19013__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__19013__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__19013__$1);
var G__19038 = cljs.core.chunk_rest(seq__19013__$1);
var G__19039 = c__4649__auto__;
var G__19040 = cljs.core.count(c__4649__auto__);
var G__19041 = (0);
seq__19013 = G__19038;
chunk__19014 = G__19039;
count__19015 = G__19040;
i__19016 = G__19041;
continue;
} else {
var vec__19029 = cljs.core.first(seq__19013__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19029,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19029,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e19032){var e_19042 = e19032;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_19042,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__19043 = cljs.core.next(seq__19013__$1);
var G__19044 = null;
var G__19045 = (0);
var G__19046 = (0);
seq__19013 = G__19043;
chunk__19014 = G__19044;
count__19015 = G__19045;
i__19016 = G__19046;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Process events: ",msg], 0));
var vec__19049 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19049,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19049,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19049,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19049,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__19052 = conn;
var map__19052__$1 = cljs.core.__destructure_map(map__19052);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19052__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__19053 = event_type__$1;
var G__19053__$1 = (((G__19053 instanceof cljs.core.Keyword))?G__19053.fqn:null);
switch (G__19053__$1) {
case "response":
var temp__5753__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5753__auto__)){
var res_chan = temp__5753__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__19047_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__19047_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__19054 = error_data;
var map__19054__$1 = cljs.core.__destructure_map(map__19054);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19054__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e19048){var e = e19048;
return fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
