// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__60165 = arguments.length;
switch (G__60165) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___60313 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_60252){
var state_val_60253 = (state_60252[(1)]);
if((state_val_60253 === (7))){
var inst_60183 = (state_60252[(7)]);
var inst_60186 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_60183);
var state_60252__$1 = state_60252;
var statearr_60254_60314 = state_60252__$1;
(statearr_60254_60314[(2)] = inst_60186);

(statearr_60254_60314[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (20))){
var inst_60207 = (state_60252[(8)]);
var inst_60178 = (state_60252[(9)]);
var inst_60211 = fluree.db.auth.roles(inst_60178,inst_60207);
var state_60252__$1 = state_60252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60252__$1,(23),inst_60211);
} else {
if((state_val_60253 === (27))){
var inst_60178 = (state_60252[(9)]);
var inst_60226 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60227 = fluree.db.time_travel.as_of_block(inst_60178,inst_60226);
var state_60252__$1 = state_60252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60252__$1,(30),inst_60227);
} else {
if((state_val_60253 === (1))){
var state_60252__$1 = state_60252;
var statearr_60255_60315 = state_60252__$1;
(statearr_60255_60315[(2)] = null);

(statearr_60255_60315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (24))){
var inst_60178 = (state_60252[(9)]);
var inst_60219 = (state_60252[(10)]);
var inst_60221 = fluree.db.permissions.permission_map(inst_60178,inst_60219,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_60252__$1 = state_60252;
var statearr_60256_60316 = state_60252__$1;
(statearr_60256_60316[(2)] = inst_60221);

(statearr_60256_60316[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (4))){
var inst_60166 = (state_60252[(2)]);
var inst_60167 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60166);
var inst_60168 = cljs.core.async.close_BANG_(pc);
var state_60252__$1 = (function (){var statearr_60257 = state_60252;
(statearr_60257[(11)] = inst_60167);

return statearr_60257;
})();
var statearr_60258_60317 = state_60252__$1;
(statearr_60258_60317[(2)] = inst_60168);

(statearr_60258_60317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (15))){
var inst_60183 = (state_60252[(7)]);
var inst_60197 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_60183)," unknown."].join('');
var inst_60198 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60199 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_60200 = cljs.core.PersistentHashMap.fromArrays(inst_60198,inst_60199);
var inst_60201 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60197,inst_60200);
var inst_60202 = (function(){throw inst_60201})();
var state_60252__$1 = state_60252;
var statearr_60259_60318 = state_60252__$1;
(statearr_60259_60318[(2)] = inst_60202);

(statearr_60259_60318[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (21))){
var state_60252__$1 = state_60252;
var statearr_60260_60319 = state_60252__$1;
(statearr_60260_60319[(2)] = null);

(statearr_60260_60319[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (31))){
var inst_60233 = (state_60252[(12)]);
var inst_60183 = (state_60252[(7)]);
var inst_60235 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60233,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_60183);
var state_60252__$1 = state_60252;
var statearr_60261_60320 = state_60252__$1;
(statearr_60261_60320[(2)] = inst_60235);

(statearr_60261_60320[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (32))){
var inst_60233 = (state_60252[(12)]);
var state_60252__$1 = state_60252;
var statearr_60262_60321 = state_60252__$1;
(statearr_60262_60321[(2)] = inst_60233);

(statearr_60262_60321[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (33))){
var inst_60219 = (state_60252[(10)]);
var inst_60238 = (state_60252[(2)]);
var state_60252__$1 = (function (){var statearr_60263 = state_60252;
(statearr_60263[(13)] = inst_60238);

return statearr_60263;
})();
if(cljs.core.truth_(inst_60219)){
var statearr_60264_60322 = state_60252__$1;
(statearr_60264_60322[(1)] = (34));

} else {
var statearr_60265_60323 = state_60252__$1;
(statearr_60265_60323[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (13))){
var inst_60194 = (state_60252[(14)]);
var inst_60193 = (state_60252[(2)]);
var inst_60194__$1 = fluree.db.util.async.throw_err(inst_60193);
var state_60252__$1 = (function (){var statearr_60266 = state_60252;
(statearr_60266[(14)] = inst_60194__$1);

return statearr_60266;
})();
if(cljs.core.truth_(inst_60194__$1)){
var statearr_60267_60324 = state_60252__$1;
(statearr_60267_60324[(1)] = (14));

} else {
var statearr_60268_60325 = state_60252__$1;
(statearr_60268_60325[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (22))){
var inst_60217 = (state_60252[(2)]);
var state_60252__$1 = state_60252;
var statearr_60269_60326 = state_60252__$1;
(statearr_60269_60326[(2)] = inst_60217);

(statearr_60269_60326[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (36))){
var inst_60246 = (state_60252[(2)]);
var inst_60247 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60246);
var _ = (function (){var statearr_60270 = state_60252;
(statearr_60270[(4)] = cljs.core.rest((state_60252[(4)])));

return statearr_60270;
})();
var state_60252__$1 = state_60252;
var statearr_60271_60327 = state_60252__$1;
(statearr_60271_60327[(2)] = inst_60247);

(statearr_60271_60327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (29))){
var inst_60183 = (state_60252[(7)]);
var inst_60233 = (state_60252[(2)]);
var state_60252__$1 = (function (){var statearr_60272 = state_60252;
(statearr_60272[(12)] = inst_60233);

return statearr_60272;
})();
if(cljs.core.truth_(inst_60183)){
var statearr_60273_60328 = state_60252__$1;
(statearr_60273_60328[(1)] = (31));

} else {
var statearr_60274_60329 = state_60252__$1;
(statearr_60274_60329[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (6))){
var inst_60183 = (state_60252[(7)]);
var inst_60177 = (state_60252[(2)]);
var inst_60178 = fluree.db.util.async.throw_err(inst_60177);
var inst_60179 = opts;
var inst_60180 = cljs.core.__destructure_map(inst_60179);
var inst_60181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60180,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_60182 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60180,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_60183__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60180,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60180,new cljs.core.Keyword(null,"block","block",664686210));
var state_60252__$1 = (function (){var statearr_60275 = state_60252;
(statearr_60275[(15)] = inst_60182);

(statearr_60275[(16)] = inst_60184);

(statearr_60275[(17)] = inst_60181);

(statearr_60275[(9)] = inst_60178);

(statearr_60275[(7)] = inst_60183__$1);

return statearr_60275;
})();
if(cljs.core.truth_(inst_60183__$1)){
var statearr_60276_60330 = state_60252__$1;
(statearr_60276_60330[(1)] = (7));

} else {
var statearr_60277_60331 = state_60252__$1;
(statearr_60277_60331[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (28))){
var inst_60178 = (state_60252[(9)]);
var state_60252__$1 = state_60252;
var statearr_60278_60332 = state_60252__$1;
(statearr_60278_60332[(2)] = inst_60178);

(statearr_60278_60332[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (25))){
var state_60252__$1 = state_60252;
var statearr_60279_60333 = state_60252__$1;
(statearr_60279_60333[(2)] = null);

(statearr_60279_60333[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (34))){
var inst_60224 = (state_60252[(18)]);
var state_60252__$1 = state_60252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60252__$1,(37),inst_60224);
} else {
if((state_val_60253 === (17))){
var inst_60181 = (state_60252[(17)]);
var state_60252__$1 = state_60252;
var statearr_60280_60334 = state_60252__$1;
(statearr_60280_60334[(2)] = inst_60181);

(statearr_60280_60334[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (3))){
var inst_60250 = (state_60252[(2)]);
var state_60252__$1 = state_60252;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60252__$1,inst_60250);
} else {
if((state_val_60253 === (12))){
var inst_60181 = (state_60252[(17)]);
var inst_60207 = (state_60252[(2)]);
var state_60252__$1 = (function (){var statearr_60281 = state_60252;
(statearr_60281[(8)] = inst_60207);

return statearr_60281;
})();
if(cljs.core.truth_(inst_60181)){
var statearr_60282_60335 = state_60252__$1;
(statearr_60282_60335[(1)] = (17));

} else {
var statearr_60283_60336 = state_60252__$1;
(statearr_60283_60336[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (2))){
var _ = (function (){var statearr_60284 = state_60252;
(statearr_60284[(4)] = cljs.core.cons((5),(state_60252[(4)])));

return statearr_60284;
})();
var inst_60175 = fluree.db.session.db(conn,ledger,null);
var state_60252__$1 = state_60252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60252__$1,(6),inst_60175);
} else {
if((state_val_60253 === (23))){
var inst_60213 = (state_60252[(2)]);
var inst_60214 = fluree.db.util.async.throw_err(inst_60213);
var state_60252__$1 = state_60252;
var statearr_60285_60337 = state_60252__$1;
(statearr_60285_60337[(2)] = inst_60214);

(statearr_60285_60337[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (35))){
var inst_60238 = (state_60252[(13)]);
var state_60252__$1 = state_60252;
var statearr_60286_60338 = state_60252__$1;
(statearr_60286_60338[(2)] = inst_60238);

(statearr_60286_60338[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (19))){
var inst_60219 = (state_60252[(10)]);
var inst_60219__$1 = (state_60252[(2)]);
var state_60252__$1 = (function (){var statearr_60287 = state_60252;
(statearr_60287[(10)] = inst_60219__$1);

return statearr_60287;
})();
if(cljs.core.truth_(inst_60219__$1)){
var statearr_60288_60339 = state_60252__$1;
(statearr_60288_60339[(1)] = (24));

} else {
var statearr_60289_60340 = state_60252__$1;
(statearr_60289_60340[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (11))){
var state_60252__$1 = state_60252;
var statearr_60291_60341 = state_60252__$1;
(statearr_60291_60341[(2)] = null);

(statearr_60291_60341[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (9))){
var inst_60189 = (state_60252[(2)]);
var state_60252__$1 = state_60252;
if(cljs.core.truth_(inst_60189)){
var statearr_60292_60342 = state_60252__$1;
(statearr_60292_60342[(1)] = (10));

} else {
var statearr_60293_60343 = state_60252__$1;
(statearr_60293_60343[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (5))){
var _ = (function (){var statearr_60294 = state_60252;
(statearr_60294[(4)] = cljs.core.rest((state_60252[(4)])));

return statearr_60294;
})();
var state_60252__$1 = state_60252;
var ex60290 = (state_60252__$1[(2)]);
var statearr_60295_60344 = state_60252__$1;
(statearr_60295_60344[(5)] = ex60290);


var statearr_60296_60345 = state_60252__$1;
(statearr_60296_60345[(1)] = (4));

(statearr_60296_60345[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (14))){
var inst_60194 = (state_60252[(14)]);
var state_60252__$1 = state_60252;
var statearr_60297_60346 = state_60252__$1;
(statearr_60297_60346[(2)] = inst_60194);

(statearr_60297_60346[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (26))){
var inst_60184 = (state_60252[(16)]);
var inst_60224 = (state_60252[(2)]);
var state_60252__$1 = (function (){var statearr_60298 = state_60252;
(statearr_60298[(18)] = inst_60224);

return statearr_60298;
})();
if(cljs.core.truth_(inst_60184)){
var statearr_60299_60347 = state_60252__$1;
(statearr_60299_60347[(1)] = (27));

} else {
var statearr_60300_60348 = state_60252__$1;
(statearr_60300_60348[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (16))){
var inst_60204 = (state_60252[(2)]);
var state_60252__$1 = state_60252;
var statearr_60301_60349 = state_60252__$1;
(statearr_60301_60349[(2)] = inst_60204);

(statearr_60301_60349[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (30))){
var inst_60229 = (state_60252[(2)]);
var inst_60230 = fluree.db.util.async.throw_err(inst_60229);
var state_60252__$1 = state_60252;
var statearr_60302_60350 = state_60252__$1;
(statearr_60302_60350[(2)] = inst_60230);

(statearr_60302_60350[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (10))){
var inst_60178 = (state_60252[(9)]);
var inst_60183 = (state_60252[(7)]);
var inst_60191 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_60178,inst_60183);
var state_60252__$1 = state_60252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60252__$1,(13),inst_60191);
} else {
if((state_val_60253 === (18))){
var inst_60207 = (state_60252[(8)]);
var state_60252__$1 = state_60252;
if(cljs.core.truth_(inst_60207)){
var statearr_60303_60351 = state_60252__$1;
(statearr_60303_60351[(1)] = (20));

} else {
var statearr_60304_60352 = state_60252__$1;
(statearr_60304_60352[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (37))){
var inst_60238 = (state_60252[(13)]);
var inst_60241 = (state_60252[(2)]);
var inst_60242 = fluree.db.util.async.throw_err(inst_60241);
var inst_60243 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60238,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_60242);
var state_60252__$1 = state_60252;
var statearr_60305_60353 = state_60252__$1;
(statearr_60305_60353[(2)] = inst_60243);

(statearr_60305_60353[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60253 === (8))){
var inst_60183 = (state_60252[(7)]);
var state_60252__$1 = state_60252;
var statearr_60306_60354 = state_60252__$1;
(statearr_60306_60354[(2)] = inst_60183);

(statearr_60306_60354[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2733__auto__ = null;
var fluree$db$api$query$state_machine__2733__auto____0 = (function (){
var statearr_60307 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60307[(0)] = fluree$db$api$query$state_machine__2733__auto__);

(statearr_60307[(1)] = (1));

return statearr_60307;
});
var fluree$db$api$query$state_machine__2733__auto____1 = (function (state_60252){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_60252);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e60308){var ex__2736__auto__ = e60308;
var statearr_60309_60355 = state_60252;
(statearr_60309_60355[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_60252[(4)]))){
var statearr_60310_60356 = state_60252;
(statearr_60310_60356[(1)] = cljs.core.first((state_60252[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60357 = state_60252;
state_60252 = G__60357;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2733__auto__ = function(state_60252){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2733__auto____1.call(this,state_60252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2733__auto____0;
fluree$db$api$query$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2733__auto____1;
return fluree$db$api$query$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_60311 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_60311[(6)] = c__2755__auto___60313);

return statearr_60311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_60498){
var state_val_60499 = (state_60498[(1)]);
if((state_val_60499 === (7))){
var inst_60378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60379 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60380 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60381 = [inst_60379,inst_60380];
var inst_60382 = (new cljs.core.PersistentVector(null,2,(5),inst_60378,inst_60381,null));
var state_60498__$1 = state_60498;
var statearr_60500_60570 = state_60498__$1;
(statearr_60500_60570[(2)] = inst_60382);

(statearr_60500_60570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (20))){
var inst_60408 = (state_60498[(7)]);
var state_60498__$1 = state_60498;
var statearr_60501_60571 = state_60498__$1;
(statearr_60501_60571[(2)] = inst_60408);

(statearr_60501_60571[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (27))){
var state_60498__$1 = state_60498;
var statearr_60502_60572 = state_60498__$1;
(statearr_60502_60572[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (1))){
var state_60498__$1 = state_60498;
var statearr_60504_60573 = state_60498__$1;
(statearr_60504_60573[(2)] = null);

(statearr_60504_60573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (24))){
var inst_60407 = (state_60498[(8)]);
var state_60498__$1 = state_60498;
if(cljs.core.truth_(inst_60407)){
var statearr_60505_60574 = state_60498__$1;
(statearr_60505_60574[(1)] = (26));

} else {
var statearr_60506_60575 = state_60498__$1;
(statearr_60506_60575[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (39))){
var inst_60453 = (state_60498[(9)]);
var inst_60454 = (state_60498[(10)]);
var inst_60479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60480 = [inst_60453,inst_60454];
var inst_60481 = (new cljs.core.PersistentVector(null,2,(5),inst_60479,inst_60480,null));
var state_60498__$1 = state_60498;
var statearr_60507_60576 = state_60498__$1;
(statearr_60507_60576[(2)] = inst_60481);

(statearr_60507_60576[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (4))){
var inst_60358 = (state_60498[(2)]);
var state_60498__$1 = state_60498;
var statearr_60508_60577 = state_60498__$1;
(statearr_60508_60577[(2)] = inst_60358);

(statearr_60508_60577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (15))){
var inst_60392 = (state_60498[(11)]);
var inst_60387 = (state_60498[(12)]);
var inst_60401 = (state_60498[(2)]);
var inst_60402 = [inst_60392,inst_60401];
var inst_60403 = (new cljs.core.PersistentVector(null,2,(5),inst_60387,inst_60402,null));
var state_60498__$1 = state_60498;
var statearr_60509_60578 = state_60498__$1;
(statearr_60509_60578[(2)] = inst_60403);

(statearr_60509_60578[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (21))){
var inst_60407 = (state_60498[(8)]);
var state_60498__$1 = state_60498;
var statearr_60510_60579 = state_60498__$1;
(statearr_60510_60579[(2)] = inst_60407);

(statearr_60510_60579[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (31))){
var inst_60448 = (state_60498[(2)]);
var state_60498__$1 = state_60498;
var statearr_60511_60580 = state_60498__$1;
(statearr_60511_60580[(2)] = inst_60448);

(statearr_60511_60580[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (32))){
var inst_60454 = (state_60498[(10)]);
var inst_60457 = cljs.core.pos_int_QMARK_(inst_60454);
var state_60498__$1 = state_60498;
var statearr_60512_60581 = state_60498__$1;
(statearr_60512_60581[(2)] = inst_60457);

(statearr_60512_60581[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (40))){
var inst_60485 = (state_60498[(13)]);
var inst_60409 = (state_60498[(14)]);
var inst_60483 = (state_60498[(2)]);
var inst_60484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60483,(0),null);
var inst_60485__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60483,(1),null);
var inst_60486 = (inst_60485__$1 > inst_60409);
var state_60498__$1 = (function (){var statearr_60513 = state_60498;
(statearr_60513[(13)] = inst_60485__$1);

(statearr_60513[(15)] = inst_60484);

return statearr_60513;
})();
if(cljs.core.truth_(inst_60486)){
var statearr_60514_60582 = state_60498__$1;
(statearr_60514_60582[(1)] = (41));

} else {
var statearr_60515_60583 = state_60498__$1;
(statearr_60515_60583[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (33))){
var inst_60455 = (state_60498[(16)]);
var state_60498__$1 = state_60498;
var statearr_60516_60584 = state_60498__$1;
(statearr_60516_60584[(2)] = inst_60455);

(statearr_60516_60584[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (13))){
var inst_60393 = (state_60498[(17)]);
var inst_60395 = fluree.db.time_travel.block_to_int_format(db,inst_60393);
var state_60498__$1 = state_60498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60498__$1,(16),inst_60395);
} else {
if((state_val_60499 === (22))){
var inst_60426 = (state_60498[(2)]);
var state_60498__$1 = state_60498;
if(cljs.core.truth_(inst_60426)){
var statearr_60517_60585 = state_60498__$1;
(statearr_60517_60585[(1)] = (23));

} else {
var statearr_60518_60586 = state_60498__$1;
(statearr_60518_60586[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (36))){
var state_60498__$1 = state_60498;
var statearr_60519_60587 = state_60498__$1;
(statearr_60519_60587[(2)] = null);

(statearr_60519_60587[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (41))){
var inst_60409 = (state_60498[(14)]);
var state_60498__$1 = state_60498;
var statearr_60520_60588 = state_60498__$1;
(statearr_60520_60588[(2)] = inst_60409);

(statearr_60520_60588[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (43))){
var inst_60484 = (state_60498[(15)]);
var inst_60490 = (state_60498[(2)]);
var inst_60491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60492 = [inst_60484,inst_60490];
var inst_60493 = (new cljs.core.PersistentVector(null,2,(5),inst_60491,inst_60492,null));
var _ = (function (){var statearr_60521 = state_60498;
(statearr_60521[(4)] = cljs.core.rest((state_60498[(4)])));

return statearr_60521;
})();
var state_60498__$1 = state_60498;
var statearr_60522_60589 = state_60498__$1;
(statearr_60522_60589[(2)] = inst_60493);

(statearr_60522_60589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (29))){
var inst_60384 = (state_60498[(18)]);
var inst_60439 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60384], 0));
var inst_60440 = ["Invalid block range provided: ",inst_60439].join('');
var inst_60441 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60442 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60443 = cljs.core.PersistentHashMap.fromArrays(inst_60441,inst_60442);
var inst_60444 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60440,inst_60443);
var inst_60445 = (function(){throw inst_60444})();
var state_60498__$1 = state_60498;
var statearr_60523_60590 = state_60498__$1;
(statearr_60523_60590[(2)] = inst_60445);

(statearr_60523_60590[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (6))){
var inst_60376 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60498__$1 = state_60498;
var statearr_60524_60591 = state_60498__$1;
(statearr_60524_60591[(2)] = inst_60376);

(statearr_60524_60591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (28))){
var inst_60450 = (state_60498[(2)]);
var state_60498__$1 = state_60498;
var statearr_60525_60592 = state_60498__$1;
(statearr_60525_60592[(2)] = inst_60450);

(statearr_60525_60592[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (25))){
var inst_60455 = (state_60498[(16)]);
var inst_60453 = (state_60498[(9)]);
var inst_60452 = (state_60498[(2)]);
var inst_60453__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60452,(0),null);
var inst_60454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60452,(1),null);
var inst_60455__$1 = cljs.core.pos_int_QMARK_(inst_60453__$1);
var state_60498__$1 = (function (){var statearr_60526 = state_60498;
(statearr_60526[(16)] = inst_60455__$1);

(statearr_60526[(9)] = inst_60453__$1);

(statearr_60526[(10)] = inst_60454);

return statearr_60526;
})();
if(inst_60455__$1){
var statearr_60527_60593 = state_60498__$1;
(statearr_60527_60593[(1)] = (32));

} else {
var statearr_60528_60594 = state_60498__$1;
(statearr_60528_60594[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (34))){
var inst_60460 = (state_60498[(2)]);
var inst_60461 = cljs.core.not(inst_60460);
var state_60498__$1 = state_60498;
if(inst_60461){
var statearr_60529_60595 = state_60498__$1;
(statearr_60529_60595[(1)] = (35));

} else {
var statearr_60530_60596 = state_60498__$1;
(statearr_60530_60596[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (17))){
var inst_60409 = (state_60498[(14)]);
var inst_60407 = (state_60498[(8)]);
var inst_60412 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60407], 0));
var inst_60413 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60409], 0));
var inst_60414 = ["Start block is out of range for this ledger. Start block provided: ",inst_60412,". Database block: ",inst_60413].join('');
var inst_60415 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60416 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60417 = cljs.core.PersistentHashMap.fromArrays(inst_60415,inst_60416);
var inst_60418 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60414,inst_60417);
var inst_60419 = (function(){throw inst_60418})();
var state_60498__$1 = state_60498;
var statearr_60531_60597 = state_60498__$1;
(statearr_60531_60597[(2)] = inst_60419);

(statearr_60531_60597[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (3))){
var inst_60496 = (state_60498[(2)]);
var state_60498__$1 = state_60498;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60498__$1,inst_60496);
} else {
if((state_val_60499 === (12))){
var inst_60393 = (state_60498[(17)]);
var inst_60384 = (state_60498[(18)]);
var inst_60391 = (state_60498[(2)]);
var inst_60392 = fluree.db.util.async.throw_err(inst_60391);
var inst_60393__$1 = cljs.core.second(inst_60384);
var state_60498__$1 = (function (){var statearr_60532 = state_60498;
(statearr_60532[(17)] = inst_60393__$1);

(statearr_60532[(11)] = inst_60392);

return statearr_60532;
})();
if(cljs.core.truth_(inst_60393__$1)){
var statearr_60533_60598 = state_60498__$1;
(statearr_60533_60598[(1)] = (13));

} else {
var statearr_60534_60599 = state_60498__$1;
(statearr_60534_60599[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (2))){
var _ = (function (){var statearr_60535 = state_60498;
(statearr_60535[(4)] = cljs.core.cons((5),(state_60498[(4)])));

return statearr_60535;
})();
var inst_60373 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60374 = cljs.core.sequential_QMARK_(inst_60373);
var state_60498__$1 = state_60498;
if(inst_60374){
var statearr_60536_60600 = state_60498__$1;
(statearr_60536_60600[(1)] = (6));

} else {
var statearr_60537_60601 = state_60498__$1;
(statearr_60537_60601[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (23))){
var inst_60407 = (state_60498[(8)]);
var inst_60408 = (state_60498[(7)]);
var inst_60428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60429 = [inst_60407,inst_60408];
var inst_60430 = (new cljs.core.PersistentVector(null,2,(5),inst_60428,inst_60429,null));
var state_60498__$1 = state_60498;
var statearr_60538_60602 = state_60498__$1;
(statearr_60538_60602[(2)] = inst_60430);

(statearr_60538_60602[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (35))){
var inst_60384 = (state_60498[(18)]);
var inst_60463 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60384], 0));
var inst_60464 = ["Invalid block range provided: ",inst_60463].join('');
var inst_60465 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60466 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60467 = cljs.core.PersistentHashMap.fromArrays(inst_60465,inst_60466);
var inst_60468 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60464,inst_60467);
var inst_60469 = (function(){throw inst_60468})();
var state_60498__$1 = state_60498;
var statearr_60539_60603 = state_60498__$1;
(statearr_60539_60603[(2)] = inst_60469);

(statearr_60539_60603[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (19))){
var inst_60407 = (state_60498[(8)]);
var inst_60422 = (state_60498[(2)]);
var state_60498__$1 = (function (){var statearr_60540 = state_60498;
(statearr_60540[(19)] = inst_60422);

return statearr_60540;
})();
if(cljs.core.truth_(inst_60407)){
var statearr_60541_60604 = state_60498__$1;
(statearr_60541_60604[(1)] = (20));

} else {
var statearr_60542_60605 = state_60498__$1;
(statearr_60542_60605[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (11))){
var inst_60409 = (state_60498[(14)]);
var inst_60407 = (state_60498[(8)]);
var inst_60406 = (state_60498[(2)]);
var inst_60407__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60406,(0),null);
var inst_60408 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60406,(1),null);
var inst_60409__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60410 = (inst_60407__$1 > inst_60409__$1);
var state_60498__$1 = (function (){var statearr_60544 = state_60498;
(statearr_60544[(14)] = inst_60409__$1);

(statearr_60544[(8)] = inst_60407__$1);

(statearr_60544[(7)] = inst_60408);

return statearr_60544;
})();
if(cljs.core.truth_(inst_60410)){
var statearr_60545_60606 = state_60498__$1;
(statearr_60545_60606[(1)] = (17));

} else {
var statearr_60546_60607 = state_60498__$1;
(statearr_60546_60607[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (9))){
var inst_60384 = (state_60498[(18)]);
var inst_60387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60388 = cljs.core.first(inst_60384);
var inst_60389 = fluree.db.time_travel.block_to_int_format(db,inst_60388);
var state_60498__$1 = (function (){var statearr_60547 = state_60498;
(statearr_60547[(12)] = inst_60387);

return statearr_60547;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60498__$1,(12),inst_60389);
} else {
if((state_val_60499 === (5))){
var _ = (function (){var statearr_60548 = state_60498;
(statearr_60548[(4)] = cljs.core.rest((state_60498[(4)])));

return statearr_60548;
})();
var state_60498__$1 = state_60498;
var ex60543 = (state_60498__$1[(2)]);
var statearr_60549_60608 = state_60498__$1;
(statearr_60549_60608[(5)] = ex60543);


if((ex60543 instanceof Error)){
var statearr_60550_60609 = state_60498__$1;
(statearr_60550_60609[(1)] = (4));

(statearr_60550_60609[(5)] = null);

} else {
throw ex60543;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (14))){
var state_60498__$1 = state_60498;
var statearr_60551_60610 = state_60498__$1;
(statearr_60551_60610[(2)] = null);

(statearr_60551_60610[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (26))){
var inst_60407 = (state_60498[(8)]);
var inst_60433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60434 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60435 = [inst_60407,inst_60434];
var inst_60436 = (new cljs.core.PersistentVector(null,2,(5),inst_60433,inst_60435,null));
var state_60498__$1 = state_60498;
var statearr_60552_60611 = state_60498__$1;
(statearr_60552_60611[(2)] = inst_60436);

(statearr_60552_60611[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (16))){
var inst_60397 = (state_60498[(2)]);
var inst_60398 = fluree.db.util.async.throw_err(inst_60397);
var state_60498__$1 = state_60498;
var statearr_60553_60612 = state_60498__$1;
(statearr_60553_60612[(2)] = inst_60398);

(statearr_60553_60612[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (38))){
var inst_60453 = (state_60498[(9)]);
var inst_60454 = (state_60498[(10)]);
var inst_60475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60476 = [inst_60454,inst_60453];
var inst_60477 = (new cljs.core.PersistentVector(null,2,(5),inst_60475,inst_60476,null));
var state_60498__$1 = state_60498;
var statearr_60554_60613 = state_60498__$1;
(statearr_60554_60613[(2)] = inst_60477);

(statearr_60554_60613[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (30))){
var state_60498__$1 = state_60498;
var statearr_60555_60614 = state_60498__$1;
(statearr_60555_60614[(2)] = null);

(statearr_60555_60614[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (10))){
var inst_60384 = (state_60498[(18)]);
var state_60498__$1 = state_60498;
var statearr_60556_60615 = state_60498__$1;
(statearr_60556_60615[(2)] = inst_60384);

(statearr_60556_60615[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (18))){
var state_60498__$1 = state_60498;
var statearr_60557_60616 = state_60498__$1;
(statearr_60557_60616[(2)] = null);

(statearr_60557_60616[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (42))){
var inst_60485 = (state_60498[(13)]);
var state_60498__$1 = state_60498;
var statearr_60558_60617 = state_60498__$1;
(statearr_60558_60617[(2)] = inst_60485);

(statearr_60558_60617[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (37))){
var inst_60453 = (state_60498[(9)]);
var inst_60454 = (state_60498[(10)]);
var inst_60472 = (state_60498[(2)]);
var inst_60473 = (inst_60454 < inst_60453);
var state_60498__$1 = (function (){var statearr_60559 = state_60498;
(statearr_60559[(20)] = inst_60472);

return statearr_60559;
})();
if(cljs.core.truth_(inst_60473)){
var statearr_60560_60618 = state_60498__$1;
(statearr_60560_60618[(1)] = (38));

} else {
var statearr_60561_60619 = state_60498__$1;
(statearr_60561_60619[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60499 === (8))){
var inst_60384 = (state_60498[(18)]);
var inst_60384__$1 = (state_60498[(2)]);
var inst_60385 = cljs.core.some(cljs.core.string_QMARK_,inst_60384__$1);
var state_60498__$1 = (function (){var statearr_60562 = state_60498;
(statearr_60562[(18)] = inst_60384__$1);

return statearr_60562;
})();
if(cljs.core.truth_(inst_60385)){
var statearr_60563_60620 = state_60498__$1;
(statearr_60563_60620[(1)] = (9));

} else {
var statearr_60564_60621 = state_60498__$1;
(statearr_60564_60621[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____0 = (function (){
var statearr_60565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60565[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__);

(statearr_60565[(1)] = (1));

return statearr_60565;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____1 = (function (state_60498){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_60498);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e60566){var ex__2736__auto__ = e60566;
var statearr_60567_60622 = state_60498;
(statearr_60567_60622[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_60498[(4)]))){
var statearr_60568_60623 = state_60498;
(statearr_60568_60623[(1)] = cljs.core.first((state_60498[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60624 = state_60498;
state_60498 = G__60624;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__ = function(state_60498){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____1.call(this,state_60498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_60569 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_60569[(6)] = c__2755__auto__);

return statearr_60569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_60774){
var state_val_60775 = (state_60774[(1)]);
if((state_val_60775 === (7))){
var inst_60686 = (state_60774[(2)]);
var inst_60687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60686,(0),null);
var inst_60688 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60686,(1),null);
var inst_60696 = cljs.core.vals(inst_60688);
var inst_60697 = cljs.core.seq(inst_60696);
var inst_60698 = cljs.core.first(inst_60697);
var inst_60699 = cljs.core.next(inst_60697);
var inst_60700 = cljs.core.PersistentVector.EMPTY;
var inst_60701 = inst_60696;
var inst_60702 = inst_60700;
var state_60774__$1 = (function (){var statearr_60776 = state_60774;
(statearr_60776[(7)] = inst_60701);

(statearr_60776[(8)] = inst_60698);

(statearr_60776[(9)] = inst_60699);

(statearr_60776[(10)] = inst_60687);

(statearr_60776[(11)] = inst_60702);

return statearr_60776;
})();
var statearr_60777_60830 = state_60774__$1;
(statearr_60777_60830[(2)] = null);

(statearr_60777_60830[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (20))){
var inst_60708 = (state_60774[(12)]);
var inst_60713 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60714 = cljs.core.PersistentHashMap.EMPTY;
var inst_60715 = [true,inst_60714];
var inst_60716 = cljs.core.PersistentHashMap.fromArrays(inst_60713,inst_60715);
var inst_60717 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60716,inst_60708);
var state_60774__$1 = state_60774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60774__$1,(22),inst_60717);
} else {
if((state_val_60775 === (27))){
var inst_60762 = (state_60774[(2)]);
var state_60774__$1 = state_60774;
var statearr_60778_60831 = state_60774__$1;
(statearr_60778_60831[(2)] = inst_60762);

(statearr_60778_60831[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (1))){
var state_60774__$1 = state_60774;
var statearr_60779_60832 = state_60774__$1;
(statearr_60779_60832[(2)] = null);

(statearr_60779_60832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (24))){
var inst_60726 = (state_60774[(13)]);
var inst_60764 = (state_60774[(2)]);
var inst_60765 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60766 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60767 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60768 = [inst_60766,inst_60767,inst_60726,inst_60764];
var inst_60769 = cljs.core.PersistentHashMap.fromArrays(inst_60765,inst_60768);
var _ = (function (){var statearr_60781 = state_60774;
(statearr_60781[(4)] = cljs.core.rest((state_60774[(4)])));

return statearr_60781;
})();
var state_60774__$1 = state_60774;
var statearr_60782_60833 = state_60774__$1;
(statearr_60782_60833[(2)] = inst_60769);

(statearr_60782_60833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (4))){
var inst_60627 = (state_60774[(2)]);
var state_60774__$1 = state_60774;
var statearr_60783_60834 = state_60774__$1;
(statearr_60783_60834[(2)] = inst_60627);

(statearr_60783_60834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (15))){
var inst_60657 = (state_60774[(14)]);
var inst_60672 = (state_60774[(15)]);
var inst_60667 = (state_60774[(16)]);
var inst_60651 = (state_60774[(17)]);
var inst_60658 = (state_60774[(18)]);
var inst_60665 = (state_60774[(19)]);
var inst_60649 = (state_60774[(20)]);
var inst_60646 = (state_60774[(21)]);
var inst_60650 = (state_60774[(22)]);
var inst_60645 = (state_60774[(23)]);
var inst_60643 = (state_60774[(24)]);
var inst_60678 = (function (){var subject = inst_60665;
var flake = inst_60657;
var vec__60653 = inst_60649;
var seq__60641 = inst_60646;
var r = inst_60658;
var vec__60640 = inst_60643;
var asserted_subjects = inst_60650;
var first__60642 = inst_60645;
var flake_SINGLEQUOTE_ = inst_60672;
var retracted_subjects = inst_60651;
var asserted_QMARK_ = inst_60667;
var first__60655 = inst_60657;
var seq__60654 = inst_60658;
var G__60639 = inst_60649;
return (function (p1__60626_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60626_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60679 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60651,inst_60665,inst_60678);
var tmp60780 = inst_60650;
var inst_60649__$1 = inst_60658;
var inst_60650__$1 = tmp60780;
var inst_60651__$1 = inst_60679;
var state_60774__$1 = (function (){var statearr_60784 = state_60774;
(statearr_60784[(17)] = inst_60651__$1);

(statearr_60784[(20)] = inst_60649__$1);

(statearr_60784[(22)] = inst_60650__$1);

return statearr_60784;
})();
var statearr_60785_60835 = state_60774__$1;
(statearr_60785_60835[(2)] = null);

(statearr_60785_60835[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (21))){
var inst_60724 = (state_60774[(2)]);
var state_60774__$1 = state_60774;
var statearr_60786_60836 = state_60774__$1;
(statearr_60786_60836[(2)] = inst_60724);

(statearr_60786_60836[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (13))){
var inst_60667 = (state_60774[(16)]);
var inst_60672 = (state_60774[(2)]);
var state_60774__$1 = (function (){var statearr_60787 = state_60774;
(statearr_60787[(15)] = inst_60672);

return statearr_60787;
})();
if(cljs.core.truth_(inst_60667)){
var statearr_60788_60837 = state_60774__$1;
(statearr_60788_60837[(1)] = (14));

} else {
var statearr_60789_60838 = state_60774__$1;
(statearr_60789_60838[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (22))){
var inst_60702 = (state_60774[(11)]);
var inst_60709 = (state_60774[(25)]);
var inst_60719 = (state_60774[(2)]);
var inst_60720 = fluree.db.util.async.throw_err(inst_60719);
var inst_60721 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60702,inst_60720);
var inst_60701 = inst_60709;
var inst_60702__$1 = inst_60721;
var state_60774__$1 = (function (){var statearr_60790 = state_60774;
(statearr_60790[(7)] = inst_60701);

(statearr_60790[(11)] = inst_60702__$1);

return statearr_60790;
})();
var statearr_60791_60839 = state_60774__$1;
(statearr_60791_60839[(2)] = null);

(statearr_60791_60839[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (6))){
var inst_60657 = (state_60774[(14)]);
var inst_60649 = (state_60774[(20)]);
var inst_60656 = cljs.core.seq(inst_60649);
var inst_60657__$1 = cljs.core.first(inst_60656);
var inst_60658 = cljs.core.next(inst_60656);
var inst_60659 = cljs.core.not(inst_60657__$1);
var state_60774__$1 = (function (){var statearr_60792 = state_60774;
(statearr_60792[(14)] = inst_60657__$1);

(statearr_60792[(18)] = inst_60658);

return statearr_60792;
})();
if(inst_60659){
var statearr_60793_60840 = state_60774__$1;
(statearr_60793_60840[(1)] = (8));

} else {
var statearr_60794_60841 = state_60774__$1;
(statearr_60794_60841[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (28))){
var inst_60740 = (state_60774[(26)]);
var inst_60747 = (state_60774[(27)]);
var inst_60757 = (state_60774[(2)]);
var inst_60758 = fluree.db.util.async.throw_err(inst_60757);
var inst_60759 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60740,inst_60758);
var inst_60739 = inst_60747;
var inst_60740__$1 = inst_60759;
var state_60774__$1 = (function (){var statearr_60795 = state_60774;
(statearr_60795[(28)] = inst_60739);

(statearr_60795[(26)] = inst_60740__$1);

return statearr_60795;
})();
var statearr_60796_60842 = state_60774__$1;
(statearr_60796_60842[(2)] = null);

(statearr_60796_60842[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (25))){
var inst_60740 = (state_60774[(26)]);
var state_60774__$1 = state_60774;
var statearr_60797_60843 = state_60774__$1;
(statearr_60797_60843[(2)] = inst_60740);

(statearr_60797_60843[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (17))){
var inst_60701 = (state_60774[(7)]);
var inst_60708 = (state_60774[(12)]);
var inst_60707 = cljs.core.seq(inst_60701);
var inst_60708__$1 = cljs.core.first(inst_60707);
var inst_60709 = cljs.core.next(inst_60707);
var inst_60710 = cljs.core.not(inst_60708__$1);
var state_60774__$1 = (function (){var statearr_60798 = state_60774;
(statearr_60798[(12)] = inst_60708__$1);

(statearr_60798[(25)] = inst_60709);

return statearr_60798;
})();
if(inst_60710){
var statearr_60799_60844 = state_60774__$1;
(statearr_60799_60844[(1)] = (19));

} else {
var statearr_60800_60845 = state_60774__$1;
(statearr_60800_60845[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (3))){
var inst_60772 = (state_60774[(2)]);
var state_60774__$1 = state_60774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60774__$1,inst_60772);
} else {
if((state_val_60775 === (12))){
var inst_60657 = (state_60774[(14)]);
var inst_60670 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_60657);
var state_60774__$1 = state_60774;
var statearr_60801_60846 = state_60774__$1;
(statearr_60801_60846[(2)] = inst_60670);

(statearr_60801_60846[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (2))){
var inst_60643 = (state_60774[(24)]);
var _ = (function (){var statearr_60802 = state_60774;
(statearr_60802[(4)] = cljs.core.cons((5),(state_60774[(4)])));

return statearr_60802;
})();
var inst_60643__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60644 = cljs.core.seq(inst_60643__$1);
var inst_60645 = cljs.core.first(inst_60644);
var inst_60646 = cljs.core.next(inst_60644);
var inst_60647 = cljs.core.PersistentHashMap.EMPTY;
var inst_60648 = cljs.core.PersistentHashMap.EMPTY;
var inst_60649 = inst_60643__$1;
var inst_60650 = inst_60647;
var inst_60651 = inst_60648;
var state_60774__$1 = (function (){var statearr_60803 = state_60774;
(statearr_60803[(17)] = inst_60651);

(statearr_60803[(20)] = inst_60649);

(statearr_60803[(21)] = inst_60646);

(statearr_60803[(22)] = inst_60650);

(statearr_60803[(23)] = inst_60645);

(statearr_60803[(24)] = inst_60643__$1);

return statearr_60803;
})();
var statearr_60804_60847 = state_60774__$1;
(statearr_60804_60847[(2)] = null);

(statearr_60804_60847[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (23))){
var inst_60739 = (state_60774[(28)]);
var inst_60746 = (state_60774[(29)]);
var inst_60745 = cljs.core.seq(inst_60739);
var inst_60746__$1 = cljs.core.first(inst_60745);
var inst_60747 = cljs.core.next(inst_60745);
var inst_60748 = cljs.core.not(inst_60746__$1);
var state_60774__$1 = (function (){var statearr_60805 = state_60774;
(statearr_60805[(29)] = inst_60746__$1);

(statearr_60805[(27)] = inst_60747);

return statearr_60805;
})();
if(inst_60748){
var statearr_60806_60848 = state_60774__$1;
(statearr_60806_60848[(1)] = (25));

} else {
var statearr_60807_60849 = state_60774__$1;
(statearr_60807_60849[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (19))){
var inst_60702 = (state_60774[(11)]);
var state_60774__$1 = state_60774;
var statearr_60808_60850 = state_60774__$1;
(statearr_60808_60850[(2)] = inst_60702);

(statearr_60808_60850[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (11))){
var inst_60657 = (state_60774[(14)]);
var state_60774__$1 = state_60774;
var statearr_60810_60851 = state_60774__$1;
(statearr_60810_60851[(2)] = inst_60657);

(statearr_60810_60851[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (9))){
var inst_60657 = (state_60774[(14)]);
var inst_60667 = (state_60774[(16)]);
var inst_60665 = inst_60657.s;
var inst_60666 = inst_60657.op;
var inst_60667__$1 = inst_60666 === true;
var state_60774__$1 = (function (){var statearr_60812 = state_60774;
(statearr_60812[(16)] = inst_60667__$1);

(statearr_60812[(19)] = inst_60665);

return statearr_60812;
})();
if(cljs.core.truth_(inst_60667__$1)){
var statearr_60813_60852 = state_60774__$1;
(statearr_60813_60852[(1)] = (11));

} else {
var statearr_60814_60853 = state_60774__$1;
(statearr_60814_60853[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (5))){
var _ = (function (){var statearr_60815 = state_60774;
(statearr_60815[(4)] = cljs.core.rest((state_60774[(4)])));

return statearr_60815;
})();
var state_60774__$1 = state_60774;
var ex60809 = (state_60774__$1[(2)]);
var statearr_60816_60854 = state_60774__$1;
(statearr_60816_60854[(5)] = ex60809);


if((ex60809 instanceof Error)){
var statearr_60817_60855 = state_60774__$1;
(statearr_60817_60855[(1)] = (4));

(statearr_60817_60855[(5)] = null);

} else {
throw ex60809;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (14))){
var inst_60657 = (state_60774[(14)]);
var inst_60672 = (state_60774[(15)]);
var inst_60667 = (state_60774[(16)]);
var inst_60651 = (state_60774[(17)]);
var inst_60658 = (state_60774[(18)]);
var inst_60665 = (state_60774[(19)]);
var inst_60649 = (state_60774[(20)]);
var inst_60646 = (state_60774[(21)]);
var inst_60650 = (state_60774[(22)]);
var inst_60645 = (state_60774[(23)]);
var inst_60643 = (state_60774[(24)]);
var inst_60674 = (function (){var subject = inst_60665;
var flake = inst_60657;
var vec__60653 = inst_60649;
var seq__60641 = inst_60646;
var r = inst_60658;
var vec__60640 = inst_60643;
var asserted_subjects = inst_60650;
var first__60642 = inst_60645;
var flake_SINGLEQUOTE_ = inst_60672;
var retracted_subjects = inst_60651;
var asserted_QMARK_ = inst_60667;
var first__60655 = inst_60657;
var seq__60654 = inst_60658;
var G__60639 = inst_60649;
return (function (p1__60625_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60625_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60675 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60650,inst_60665,inst_60674);
var tmp60811 = inst_60651;
var inst_60649__$1 = inst_60658;
var inst_60650__$1 = inst_60675;
var inst_60651__$1 = tmp60811;
var state_60774__$1 = (function (){var statearr_60818 = state_60774;
(statearr_60818[(17)] = inst_60651__$1);

(statearr_60818[(20)] = inst_60649__$1);

(statearr_60818[(22)] = inst_60650__$1);

return statearr_60818;
})();
var statearr_60819_60856 = state_60774__$1;
(statearr_60819_60856[(2)] = null);

(statearr_60819_60856[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (26))){
var inst_60746 = (state_60774[(29)]);
var inst_60751 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60752 = cljs.core.PersistentHashMap.EMPTY;
var inst_60753 = [true,inst_60752];
var inst_60754 = cljs.core.PersistentHashMap.fromArrays(inst_60751,inst_60753);
var inst_60755 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60754,inst_60746);
var state_60774__$1 = state_60774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60774__$1,(28),inst_60755);
} else {
if((state_val_60775 === (16))){
var inst_60682 = (state_60774[(2)]);
var state_60774__$1 = state_60774;
var statearr_60820_60857 = state_60774__$1;
(statearr_60820_60857[(2)] = inst_60682);

(statearr_60820_60857[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (10))){
var inst_60684 = (state_60774[(2)]);
var state_60774__$1 = state_60774;
var statearr_60821_60858 = state_60774__$1;
(statearr_60821_60858[(2)] = inst_60684);

(statearr_60821_60858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (18))){
var inst_60687 = (state_60774[(10)]);
var inst_60726 = (state_60774[(2)]);
var inst_60734 = cljs.core.vals(inst_60687);
var inst_60735 = cljs.core.seq(inst_60734);
var inst_60736 = cljs.core.first(inst_60735);
var inst_60737 = cljs.core.next(inst_60735);
var inst_60738 = cljs.core.PersistentVector.EMPTY;
var inst_60739 = inst_60734;
var inst_60740 = inst_60738;
var state_60774__$1 = (function (){var statearr_60822 = state_60774;
(statearr_60822[(13)] = inst_60726);

(statearr_60822[(28)] = inst_60739);

(statearr_60822[(30)] = inst_60737);

(statearr_60822[(26)] = inst_60740);

(statearr_60822[(31)] = inst_60736);

return statearr_60822;
})();
var statearr_60823_60859 = state_60774__$1;
(statearr_60823_60859[(2)] = null);

(statearr_60823_60859[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60775 === (8))){
var inst_60651 = (state_60774[(17)]);
var inst_60650 = (state_60774[(22)]);
var inst_60661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60662 = [inst_60650,inst_60651];
var inst_60663 = (new cljs.core.PersistentVector(null,2,(5),inst_60661,inst_60662,null));
var state_60774__$1 = state_60774;
var statearr_60824_60860 = state_60774__$1;
(statearr_60824_60860[(2)] = inst_60663);

(statearr_60824_60860[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____0 = (function (){
var statearr_60825 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60825[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__);

(statearr_60825[(1)] = (1));

return statearr_60825;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____1 = (function (state_60774){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_60774);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e60826){var ex__2736__auto__ = e60826;
var statearr_60827_60861 = state_60774;
(statearr_60827_60861[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_60774[(4)]))){
var statearr_60828_60862 = state_60774;
(statearr_60828_60862[(1)] = cljs.core.first((state_60774[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60863 = state_60774;
state_60774 = G__60863;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__ = function(state_60774){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____1.call(this,state_60774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_60829 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_60829[(6)] = c__2755__auto__);

return statearr_60829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_60895){
var state_val_60896 = (state_60895[(1)]);
if((state_val_60896 === (1))){
var inst_60864 = cljs.core.volatile_BANG_((0));
var inst_60865 = cljs.core.PersistentHashMap.EMPTY;
var inst_60866 = cljs.core.volatile_BANG_(inst_60865);
var inst_60867 = cljs.core.first(resp);
var inst_60868 = cljs.core.rest(resp);
var inst_60869 = cljs.core.PersistentVector.EMPTY;
var inst_60870 = inst_60864;
var inst_60871 = inst_60866;
var inst_60872 = inst_60867;
var inst_60873 = inst_60868;
var inst_60874 = inst_60869;
var state_60895__$1 = (function (){var statearr_60897 = state_60895;
(statearr_60897[(7)] = inst_60872);

(statearr_60897[(8)] = inst_60870);

(statearr_60897[(9)] = inst_60873);

(statearr_60897[(10)] = inst_60871);

(statearr_60897[(11)] = inst_60874);

return statearr_60897;
})();
var statearr_60898_60913 = state_60895__$1;
(statearr_60898_60913[(2)] = null);

(statearr_60898_60913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60896 === (2))){
var inst_60872 = (state_60895[(7)]);
var inst_60870 = (state_60895[(8)]);
var inst_60871 = (state_60895[(10)]);
var inst_60876 = fluree.db.api.query.format_block_resp_pretty(db,inst_60872,inst_60871,inst_60870);
var state_60895__$1 = state_60895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60895__$1,(4),inst_60876);
} else {
if((state_val_60896 === (3))){
var inst_60893 = (state_60895[(2)]);
var state_60895__$1 = state_60895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60895__$1,inst_60893);
} else {
if((state_val_60896 === (4))){
var inst_60873 = (state_60895[(9)]);
var inst_60874 = (state_60895[(11)]);
var inst_60878 = (state_60895[(2)]);
var inst_60879 = fluree.db.util.async.throw_err(inst_60878);
var inst_60880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60881 = [inst_60879];
var inst_60882 = (new cljs.core.PersistentVector(null,1,(5),inst_60880,inst_60881,null));
var inst_60883 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_60874,inst_60882);
var inst_60884 = cljs.core.first(inst_60873);
var state_60895__$1 = (function (){var statearr_60901 = state_60895;
(statearr_60901[(12)] = inst_60883);

return statearr_60901;
})();
if(cljs.core.truth_(inst_60884)){
var statearr_60902_60914 = state_60895__$1;
(statearr_60902_60914[(1)] = (5));

} else {
var statearr_60903_60915 = state_60895__$1;
(statearr_60903_60915[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60896 === (5))){
var inst_60870 = (state_60895[(8)]);
var inst_60873 = (state_60895[(9)]);
var inst_60871 = (state_60895[(10)]);
var inst_60883 = (state_60895[(12)]);
var inst_60886 = cljs.core.first(inst_60873);
var inst_60887 = cljs.core.rest(inst_60873);
var tmp60899 = inst_60870;
var tmp60900 = inst_60871;
var inst_60870__$1 = tmp60899;
var inst_60871__$1 = tmp60900;
var inst_60872 = inst_60886;
var inst_60873__$1 = inst_60887;
var inst_60874 = inst_60883;
var state_60895__$1 = (function (){var statearr_60904 = state_60895;
(statearr_60904[(7)] = inst_60872);

(statearr_60904[(8)] = inst_60870__$1);

(statearr_60904[(9)] = inst_60873__$1);

(statearr_60904[(10)] = inst_60871__$1);

(statearr_60904[(11)] = inst_60874);

return statearr_60904;
})();
var statearr_60905_60916 = state_60895__$1;
(statearr_60905_60916[(2)] = null);

(statearr_60905_60916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60896 === (6))){
var inst_60883 = (state_60895[(12)]);
var state_60895__$1 = state_60895;
var statearr_60906_60917 = state_60895__$1;
(statearr_60906_60917[(2)] = inst_60883);

(statearr_60906_60917[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60896 === (7))){
var inst_60891 = (state_60895[(2)]);
var state_60895__$1 = state_60895;
var statearr_60907_60918 = state_60895__$1;
(statearr_60907_60918[(2)] = inst_60891);

(statearr_60907_60918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____0 = (function (){
var statearr_60908 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60908[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__);

(statearr_60908[(1)] = (1));

return statearr_60908;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____1 = (function (state_60895){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_60895);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e60909){var ex__2736__auto__ = e60909;
var statearr_60910_60919 = state_60895;
(statearr_60910_60919[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_60895[(4)]))){
var statearr_60911_60920 = state_60895;
(statearr_60911_60920[(1)] = cljs.core.first((state_60895[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60921 = state_60895;
state_60895 = G__60921;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__ = function(state_60895){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____1.call(this,state_60895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_60912 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_60912[(6)] = c__2755__auto__);

return statearr_60912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis() - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60924 = arguments.length;
switch (G__60924) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__60926){
var map__60927 = p__60926;
var map__60927__$1 = cljs.core.__destructure_map(map__60927);
var query = map__60927__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60927__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61012){
var state_val_61013 = (state_61012[(1)]);
if((state_val_61013 === (7))){
var inst_60938 = (state_61012[(7)]);
var inst_60942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60943 = ["_auth/id",inst_60938];
var inst_60944 = (new cljs.core.PersistentVector(null,2,(5),inst_60942,inst_60943,null));
var state_61012__$1 = state_61012;
var statearr_61014_61058 = state_61012__$1;
(statearr_61014_61058[(2)] = inst_60944);

(statearr_61014_61058[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (20))){
var inst_60992 = (state_61012[(2)]);
var inst_60993 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_61012__$1 = (function (){var statearr_61015 = state_61012;
(statearr_61015[(8)] = inst_60992);

return statearr_61015;
})();
if(cljs.core.truth_(inst_60993)){
var statearr_61016_61059 = state_61012__$1;
(statearr_61016_61059[(1)] = (22));

} else {
var statearr_61017_61060 = state_61012__$1;
(statearr_61017_61060[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (27))){
var inst_60939 = (state_61012[(9)]);
var inst_60995 = (state_61012[(10)]);
var inst_61001 = (state_61012[(2)]);
var inst_61002 = fluree.db.api.query.response_time_formatted(inst_60939);
var inst_61003 = [(200),inst_61001,(100),inst_61002];
var inst_61004 = cljs.core.PersistentHashMap.fromArrays(inst_60995,inst_61003);
var state_61012__$1 = state_61012;
var statearr_61018_61061 = state_61012__$1;
(statearr_61018_61061[(2)] = inst_61004);

(statearr_61018_61061[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (1))){
var state_61012__$1 = state_61012;
var statearr_61019_61062 = state_61012__$1;
(statearr_61019_61062[(2)] = null);

(statearr_61019_61062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (24))){
var inst_61007 = (state_61012[(2)]);
var _ = (function (){var statearr_61020 = state_61012;
(statearr_61020[(4)] = cljs.core.rest((state_61012[(4)])));

return statearr_61020;
})();
var state_61012__$1 = state_61012;
var statearr_61021_61063 = state_61012__$1;
(statearr_61021_61063[(2)] = inst_61007);

(statearr_61021_61063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (4))){
var inst_60928 = (state_61012[(2)]);
var state_61012__$1 = state_61012;
var statearr_61022_61064 = state_61012__$1;
(statearr_61022_61064[(2)] = inst_60928);

(statearr_61022_61064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (15))){
var inst_60979 = (state_61012[(11)]);
var state_61012__$1 = state_61012;
var statearr_61023_61065 = state_61012__$1;
(statearr_61023_61065[(2)] = inst_60979);

(statearr_61023_61065[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (21))){
var inst_60988 = (state_61012[(2)]);
var inst_60989 = fluree.db.util.async.throw_err(inst_60988);
var state_61012__$1 = state_61012;
var statearr_61024_61066 = state_61012__$1;
(statearr_61024_61066[(2)] = inst_60989);

(statearr_61024_61066[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (13))){
var inst_60979 = (state_61012[(11)]);
var inst_60937 = (state_61012[(12)]);
var inst_60978 = (state_61012[(2)]);
var inst_60979__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_60937);
var state_61012__$1 = (function (){var statearr_61025 = state_61012;
(statearr_61025[(11)] = inst_60979__$1);

(statearr_61025[(13)] = inst_60978);

return statearr_61025;
})();
if(cljs.core.truth_(inst_60979__$1)){
var statearr_61026_61067 = state_61012__$1;
(statearr_61026_61067[(1)] = (15));

} else {
var statearr_61027_61068 = state_61012__$1;
(statearr_61027_61068[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (22))){
var inst_60992 = (state_61012[(8)]);
var inst_60995 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60996 = cljs.core.sequential_QMARK_(inst_60992);
var state_61012__$1 = (function (){var statearr_61028 = state_61012;
(statearr_61028[(10)] = inst_60995);

return statearr_61028;
})();
if(inst_60996){
var statearr_61029_61069 = state_61012__$1;
(statearr_61029_61069[(1)] = (25));

} else {
var statearr_61030_61070 = state_61012__$1;
(statearr_61030_61070[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (6))){
var inst_60953 = (state_61012[(14)]);
var inst_60937 = (state_61012[(12)]);
var inst_60952 = (state_61012[(2)]);
var inst_60953__$1 = fluree.db.util.async.throw_err(inst_60952);
var inst_60954 = fluree.db.api.query.resolve_block_range(inst_60953__$1,inst_60937);
var state_61012__$1 = (function (){var statearr_61031 = state_61012;
(statearr_61031[(14)] = inst_60953__$1);

return statearr_61031;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61012__$1,(10),inst_60954);
} else {
if((state_val_61013 === (25))){
var inst_60992 = (state_61012[(8)]);
var inst_60998 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_60992);
var state_61012__$1 = state_61012;
var statearr_61032_61071 = state_61012__$1;
(statearr_61032_61071[(2)] = inst_60998);

(statearr_61032_61071[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (17))){
var inst_60984 = (state_61012[(2)]);
var state_61012__$1 = state_61012;
if(cljs.core.truth_(inst_60984)){
var statearr_61033_61072 = state_61012__$1;
(statearr_61033_61072[(1)] = (18));

} else {
var statearr_61034_61073 = state_61012__$1;
(statearr_61034_61073[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (3))){
var inst_61010 = (state_61012[(2)]);
var state_61012__$1 = state_61012;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61012__$1,inst_61010);
} else {
if((state_val_61013 === (12))){
var inst_60937 = (state_61012[(12)]);
var inst_60970 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60937], 0));
var inst_60971 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_60970].join('');
var inst_60972 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60973 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60974 = cljs.core.PersistentHashMap.fromArrays(inst_60972,inst_60973);
var inst_60975 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60971,inst_60974);
var inst_60976 = (function(){throw inst_60975})();
var state_61012__$1 = state_61012;
var statearr_61035_61074 = state_61012__$1;
(statearr_61035_61074[(2)] = inst_60976);

(statearr_61035_61074[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (2))){
var inst_60938 = (state_61012[(7)]);
var _ = (function (){var statearr_61036 = state_61012;
(statearr_61036[(4)] = cljs.core.cons((5),(state_61012[(4)])));

return statearr_61036;
})();
var inst_60937 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60938__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60939 = fluree.db.util.core.current_time_millis();
var inst_60940 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_61012__$1 = (function (){var statearr_61037 = state_61012;
(statearr_61037[(7)] = inst_60938__$1);

(statearr_61037[(12)] = inst_60937);

(statearr_61037[(9)] = inst_60939);

(statearr_61037[(15)] = inst_60940);

return statearr_61037;
})();
if(cljs.core.truth_(inst_60938__$1)){
var statearr_61038_61075 = state_61012__$1;
(statearr_61038_61075[(1)] = (7));

} else {
var statearr_61039_61076 = state_61012__$1;
(statearr_61039_61076[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (23))){
var inst_60992 = (state_61012[(8)]);
var state_61012__$1 = state_61012;
var statearr_61040_61077 = state_61012__$1;
(statearr_61040_61077[(2)] = inst_60992);

(statearr_61040_61077[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (19))){
var inst_60978 = (state_61012[(13)]);
var state_61012__$1 = state_61012;
var statearr_61041_61078 = state_61012__$1;
(statearr_61041_61078[(2)] = inst_60978);

(statearr_61041_61078[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (11))){
var inst_60959 = (state_61012[(16)]);
var inst_60953 = (state_61012[(14)]);
var inst_60958 = (state_61012[(17)]);
var inst_60965 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_60953,inst_60958,inst_60959,opts);
var state_61012__$1 = state_61012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61012__$1,(14),inst_60965);
} else {
if((state_val_61013 === (9))){
var inst_60940 = (state_61012[(15)]);
var inst_60947 = (state_61012[(2)]);
var inst_60948 = [inst_60947];
var inst_60949 = cljs.core.PersistentHashMap.fromArrays(inst_60940,inst_60948);
var inst_60950 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_60949);
var state_61012__$1 = state_61012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61012__$1,(6),inst_60950);
} else {
if((state_val_61013 === (5))){
var _ = (function (){var statearr_61043 = state_61012;
(statearr_61043[(4)] = cljs.core.rest((state_61012[(4)])));

return statearr_61043;
})();
var state_61012__$1 = state_61012;
var ex61042 = (state_61012__$1[(2)]);
var statearr_61044_61079 = state_61012__$1;
(statearr_61044_61079[(5)] = ex61042);


if((ex61042 instanceof Error)){
var statearr_61045_61080 = state_61012__$1;
(statearr_61045_61080[(1)] = (4));

(statearr_61045_61080[(5)] = null);

} else {
throw ex61042;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (14))){
var inst_60967 = (state_61012[(2)]);
var inst_60968 = fluree.db.util.async.throw_err(inst_60967);
var state_61012__$1 = state_61012;
var statearr_61046_61081 = state_61012__$1;
(statearr_61046_61081[(2)] = inst_60968);

(statearr_61046_61081[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (26))){
var inst_60992 = (state_61012[(8)]);
var state_61012__$1 = state_61012;
var statearr_61047_61082 = state_61012__$1;
(statearr_61047_61082[(2)] = inst_60992);

(statearr_61047_61082[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (16))){
var inst_60937 = (state_61012[(12)]);
var inst_60982 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_60937);
var state_61012__$1 = state_61012;
var statearr_61048_61083 = state_61012__$1;
(statearr_61048_61083[(2)] = inst_60982);

(statearr_61048_61083[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (10))){
var inst_60937 = (state_61012[(12)]);
var inst_60956 = (state_61012[(2)]);
var inst_60957 = fluree.db.util.async.throw_err(inst_60956);
var inst_60958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60957,(0),null);
var inst_60959 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60957,(1),null);
var inst_60960 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_60961 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_60937,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_60962 = cljs.core.keys(inst_60961);
var inst_60963 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60960,inst_60962);
var state_61012__$1 = (function (){var statearr_61049 = state_61012;
(statearr_61049[(16)] = inst_60959);

(statearr_61049[(17)] = inst_60958);

return statearr_61049;
})();
if(inst_60963){
var statearr_61050_61084 = state_61012__$1;
(statearr_61050_61084[(1)] = (11));

} else {
var statearr_61051_61085 = state_61012__$1;
(statearr_61051_61085[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61013 === (18))){
var inst_60953 = (state_61012[(14)]);
var inst_60978 = (state_61012[(13)]);
var inst_60986 = fluree.db.api.query.format_blocks_resp_pretty(inst_60953,inst_60978);
var state_61012__$1 = state_61012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61012__$1,(21),inst_60986);
} else {
if((state_val_61013 === (8))){
var state_61012__$1 = state_61012;
var statearr_61052_61086 = state_61012__$1;
(statearr_61052_61086[(2)] = null);

(statearr_61052_61086[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2733__auto____0 = (function (){
var statearr_61053 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61053[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2733__auto__);

(statearr_61053[(1)] = (1));

return statearr_61053;
});
var fluree$db$api$query$block_query_async_$_state_machine__2733__auto____1 = (function (state_61012){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61012);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61054){var ex__2736__auto__ = e61054;
var statearr_61055_61087 = state_61012;
(statearr_61055_61087[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61012[(4)]))){
var statearr_61056_61088 = state_61012;
(statearr_61056_61088[(1)] = cljs.core.first((state_61012[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61089 = state_61012;
state_61012 = G__61089;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2733__auto__ = function(state_61012){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2733__auto____1.call(this,state_61012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2733__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2733__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61057 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61057[(6)] = c__2755__auto__);

return statearr_61057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__61090 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61090,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61090,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61090,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61090,(3),null);
var vec__61093 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61093,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61093,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__61096 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61096,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61096,(1),null);
var or__4223__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4835__auto__ = [];
var len__4829__auto___61100 = arguments.length;
var i__4830__auto___61101 = (0);
while(true){
if((i__4830__auto___61101 < len__4829__auto___61100)){
args__4835__auto__.push((arguments[i__4830__auto___61101]));

var G__61102 = (i__4830__auto___61101 + (1));
i__4830__auto___61101 = G__61102;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq61099){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq61099));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61298){
var state_val_61299 = (state_61298[(1)]);
if((state_val_61299 === (7))){
var inst_61225 = (state_61298[(7)]);
var inst_61218 = (state_61298[(8)]);
var inst_61224 = cljs.core.seq(inst_61218);
var inst_61225__$1 = cljs.core.first(inst_61224);
var inst_61226 = cljs.core.next(inst_61224);
var state_61298__$1 = (function (){var statearr_61300 = state_61298;
(statearr_61300[(7)] = inst_61225__$1);

(statearr_61300[(9)] = inst_61226);

return statearr_61300;
})();
if(cljs.core.truth_(inst_61225__$1)){
var statearr_61301_61401 = state_61298__$1;
(statearr_61301_61401[(1)] = (9));

} else {
var statearr_61302_61402 = state_61298__$1;
(statearr_61302_61402[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (20))){
var inst_61288 = (state_61298[(2)]);
var state_61298__$1 = state_61298;
var statearr_61303_61403 = state_61298__$1;
(statearr_61303_61403[(2)] = inst_61288);

(statearr_61303_61403[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (27))){
var inst_61243 = (state_61298[(10)]);
var inst_61264 = (state_61298[(11)]);
var inst_61246 = (state_61298[(12)]);
var inst_61266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61267 = [inst_61246,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_61268 = (new cljs.core.PersistentVector(null,2,(5),inst_61266,inst_61267,null));
var inst_61269 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61264,inst_61268,fluree.db.api.query.min_safe,inst_61243);
var state_61298__$1 = state_61298;
var statearr_61304_61404 = state_61298__$1;
(statearr_61304_61404[(2)] = inst_61269);

(statearr_61304_61404[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (1))){
var state_61298__$1 = state_61298;
var statearr_61305_61405 = state_61298__$1;
(statearr_61305_61405[(2)] = null);

(statearr_61305_61405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (24))){
var inst_61225 = (state_61298[(7)]);
var inst_61256 = (state_61298[(13)]);
var inst_61246 = (state_61298[(12)]);
var inst_61258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61259 = [inst_61246,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_61260 = (new cljs.core.PersistentVector(null,2,(5),inst_61258,inst_61259,null));
var inst_61261 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61256,inst_61260,cljs.core.conj,inst_61225);
var state_61298__$1 = state_61298;
var statearr_61307_61406 = state_61298__$1;
(statearr_61307_61406[(2)] = inst_61261);

(statearr_61307_61406[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (4))){
var inst_61104 = (state_61298[(2)]);
var state_61298__$1 = state_61298;
var statearr_61308_61407 = state_61298__$1;
(statearr_61308_61407[(2)] = inst_61104);

(statearr_61308_61407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (15))){
var inst_61226 = (state_61298[(9)]);
var inst_61219 = (state_61298[(14)]);
var tmp61306 = inst_61219;
var inst_61218 = inst_61226;
var inst_61219__$1 = tmp61306;
var state_61298__$1 = (function (){var statearr_61309 = state_61298;
(statearr_61309[(8)] = inst_61218);

(statearr_61309[(14)] = inst_61219__$1);

return statearr_61309;
})();
var statearr_61310_61408 = state_61298__$1;
(statearr_61310_61408[(2)] = null);

(statearr_61310_61408[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (21))){
var inst_61219 = (state_61298[(14)]);
var inst_61246 = (state_61298[(12)]);
var inst_61250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61251 = [inst_61246,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61252 = (new cljs.core.PersistentVector(null,2,(5),inst_61250,inst_61251,null));
var inst_61253 = cljs.core.assoc_in(inst_61219,inst_61252,inst_61246);
var state_61298__$1 = state_61298;
var statearr_61311_61409 = state_61298__$1;
(statearr_61311_61409[(2)] = inst_61253);

(statearr_61311_61409[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (31))){
var inst_61272 = (state_61298[(15)]);
var state_61298__$1 = state_61298;
var statearr_61312_61410 = state_61298__$1;
(statearr_61312_61410[(2)] = inst_61272);

(statearr_61312_61410[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (32))){
var inst_61226 = (state_61298[(9)]);
var inst_61280 = (state_61298[(2)]);
var inst_61218 = inst_61226;
var inst_61219 = inst_61280;
var state_61298__$1 = (function (){var statearr_61313 = state_61298;
(statearr_61313[(8)] = inst_61218);

(statearr_61313[(14)] = inst_61219);

return statearr_61313;
})();
var statearr_61314_61411 = state_61298__$1;
(statearr_61314_61411[(2)] = null);

(statearr_61314_61411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (33))){
var inst_61219 = (state_61298[(14)]);
var state_61298__$1 = state_61298;
var statearr_61315_61412 = state_61298__$1;
(statearr_61315_61412[(2)] = inst_61219);

(statearr_61315_61412[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (13))){
var inst_61228 = (state_61298[(16)]);
var state_61298__$1 = state_61298;
var statearr_61316_61413 = state_61298__$1;
(statearr_61316_61413[(2)] = inst_61228);

(statearr_61316_61413[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (22))){
var inst_61219 = (state_61298[(14)]);
var state_61298__$1 = state_61298;
var statearr_61317_61414 = state_61298__$1;
(statearr_61317_61414[(2)] = inst_61219);

(statearr_61317_61414[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (29))){
var inst_61272 = (state_61298[(2)]);
var state_61298__$1 = (function (){var statearr_61318 = state_61298;
(statearr_61318[(15)] = inst_61272);

return statearr_61318;
})();
if(cljs.core.truth_(show_auth)){
var statearr_61319_61415 = state_61298__$1;
(statearr_61319_61415[(1)] = (30));

} else {
var statearr_61320_61416 = state_61298__$1;
(statearr_61320_61416[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (6))){
var inst_61204 = (state_61298[(2)]);
var inst_61205 = fluree.db.util.async.throw_err(inst_61204);
var inst_61213 = resp;
var inst_61214 = cljs.core.seq(inst_61213);
var inst_61215 = cljs.core.first(inst_61214);
var inst_61216 = cljs.core.next(inst_61214);
var inst_61217 = cljs.core.PersistentHashMap.EMPTY;
var inst_61218 = inst_61213;
var inst_61219 = inst_61217;
var state_61298__$1 = (function (){var statearr_61321 = state_61298;
(statearr_61321[(17)] = inst_61205);

(statearr_61321[(18)] = inst_61215);

(statearr_61321[(8)] = inst_61218);

(statearr_61321[(14)] = inst_61219);

(statearr_61321[(19)] = inst_61216);

return statearr_61321;
})();
var statearr_61322_61417 = state_61298__$1;
(statearr_61322_61417[(2)] = null);

(statearr_61322_61417[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (28))){
var inst_61264 = (state_61298[(11)]);
var state_61298__$1 = state_61298;
var statearr_61323_61418 = state_61298__$1;
(statearr_61323_61418[(2)] = inst_61264);

(statearr_61323_61418[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (25))){
var inst_61256 = (state_61298[(13)]);
var state_61298__$1 = state_61298;
var statearr_61324_61419 = state_61298__$1;
(statearr_61324_61419[(2)] = inst_61256);

(statearr_61324_61419[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (34))){
var state_61298__$1 = state_61298;
var statearr_61325_61420 = state_61298__$1;
(statearr_61325_61420[(2)] = null);

(statearr_61325_61420[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (17))){
var inst_61290 = (state_61298[(2)]);
var state_61298__$1 = state_61298;
var statearr_61326_61421 = state_61298__$1;
(statearr_61326_61421[(2)] = inst_61290);

(statearr_61326_61421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (3))){
var inst_61296 = (state_61298[(2)]);
var state_61298__$1 = state_61298;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61298__$1,inst_61296);
} else {
if((state_val_61299 === (12))){
var inst_61205 = (state_61298[(17)]);
var inst_61225 = (state_61298[(7)]);
var inst_61230 = fluree.db.api.query.auth_match(auth,inst_61205,inst_61225);
var inst_61231 = cljs.core.not(inst_61230);
var state_61298__$1 = state_61298;
var statearr_61327_61422 = state_61298__$1;
(statearr_61327_61422[(2)] = inst_61231);

(statearr_61327_61422[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (2))){
var _ = (function (){var statearr_61328 = state_61298;
(statearr_61328[(4)] = cljs.core.cons((5),(state_61298[(4)])));

return statearr_61328;
})();
var inst_61110 = (function (){return (function (p1__61103_SHARP_){
return p1__61103_SHARP_.t;
});
})();
var inst_61111 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61110,resp);
var inst_61112 = cljs.core.set(inst_61111);
var inst_61200 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61201 = (function (){var ts = inst_61112;
var c__2755__auto____$1 = inst_61200;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61198){
var state_val_61199 = (state_61198[(1)]);
if((state_val_61199 === (7))){
var inst_61126 = (state_61198[(7)]);
var inst_61144 = (state_61198[(8)]);
var inst_61138 = (state_61198[(9)]);
var inst_61132 = (state_61198[(10)]);
var inst_61137 = (state_61198[(2)]);
var inst_61138__$1 = fluree.db.util.async.throw_err(inst_61137);
var inst_61140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61141 = [inst_61132,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61142 = (new cljs.core.PersistentVector(null,2,(5),inst_61140,inst_61141,null));
var inst_61143 = cljs.core.assoc_in(inst_61126,inst_61142,inst_61138__$1);
var inst_61144__$1 = auth;
var state_61198__$1 = (function (){var statearr_61329 = state_61198;
(statearr_61329[(8)] = inst_61144__$1);

(statearr_61329[(9)] = inst_61138__$1);

(statearr_61329[(11)] = inst_61143);

return statearr_61329;
})();
if(cljs.core.truth_(inst_61144__$1)){
var statearr_61330_61423 = state_61198__$1;
(statearr_61330_61423[(1)] = (8));

} else {
var statearr_61331_61424 = state_61198__$1;
(statearr_61331_61424[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (1))){
var inst_61120 = (state_61198[(12)]);
var inst_61120__$1 = ts;
var inst_61121 = cljs.core.seq(inst_61120__$1);
var inst_61122 = cljs.core.first(inst_61121);
var inst_61123 = cljs.core.next(inst_61121);
var inst_61124 = cljs.core.PersistentHashMap.EMPTY;
var inst_61125 = inst_61120__$1;
var inst_61126 = inst_61124;
var state_61198__$1 = (function (){var statearr_61332 = state_61198;
(statearr_61332[(12)] = inst_61120__$1);

(statearr_61332[(7)] = inst_61126);

(statearr_61332[(13)] = inst_61125);

(statearr_61332[(14)] = inst_61123);

(statearr_61332[(15)] = inst_61122);

return statearr_61332;
})();
var statearr_61333_61425 = state_61198__$1;
(statearr_61333_61425[(2)] = null);

(statearr_61333_61425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (4))){
var inst_61132 = (state_61198[(10)]);
var inst_61135 = fluree.db.time_travel.non_border_t_to_block(db,inst_61132);
var state_61198__$1 = state_61198;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61198__$1,(7),inst_61135);
} else {
if((state_val_61199 === (13))){
var inst_61133 = (state_61198[(16)]);
var inst_61190 = (state_61198[(2)]);
var inst_61125 = inst_61133;
var inst_61126 = inst_61190;
var state_61198__$1 = (function (){var statearr_61334 = state_61198;
(statearr_61334[(7)] = inst_61126);

(statearr_61334[(13)] = inst_61125);

return statearr_61334;
})();
var statearr_61335_61426 = state_61198__$1;
(statearr_61335_61426[(2)] = null);

(statearr_61335_61426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (6))){
var inst_61194 = (state_61198[(2)]);
var state_61198__$1 = state_61198;
var statearr_61336_61427 = state_61198__$1;
(statearr_61336_61427[(2)] = inst_61194);

(statearr_61336_61427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (3))){
var inst_61196 = (state_61198[(2)]);
var state_61198__$1 = state_61198;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61198__$1,inst_61196);
} else {
if((state_val_61199 === (12))){
var inst_61143 = (state_61198[(11)]);
var state_61198__$1 = state_61198;
var statearr_61337_61428 = state_61198__$1;
(statearr_61337_61428[(2)] = inst_61143);

(statearr_61337_61428[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (2))){
var inst_61125 = (state_61198[(13)]);
var inst_61132 = (state_61198[(10)]);
var inst_61131 = cljs.core.seq(inst_61125);
var inst_61132__$1 = cljs.core.first(inst_61131);
var inst_61133 = cljs.core.next(inst_61131);
var state_61198__$1 = (function (){var statearr_61338 = state_61198;
(statearr_61338[(16)] = inst_61133);

(statearr_61338[(10)] = inst_61132__$1);

return statearr_61338;
})();
if(cljs.core.truth_(inst_61132__$1)){
var statearr_61339_61429 = state_61198__$1;
(statearr_61339_61429[(1)] = (4));

} else {
var statearr_61340_61430 = state_61198__$1;
(statearr_61340_61430[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (11))){
var inst_61120 = (state_61198[(12)]);
var inst_61126 = (state_61198[(7)]);
var inst_61133 = (state_61198[(16)]);
var inst_61125 = (state_61198[(13)]);
var inst_61123 = (state_61198[(14)]);
var inst_61138 = (state_61198[(9)]);
var inst_61143 = (state_61198[(11)]);
var inst_61132 = (state_61198[(10)]);
var inst_61122 = (state_61198[(15)]);
var inst_61150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61151 = [inst_61132,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61152 = (new cljs.core.PersistentVector(null,2,(5),inst_61150,inst_61151,null));
var inst_61165 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61166 = (function (){var t = inst_61132;
var first__61130 = inst_61132;
var G__61139 = inst_61143;
var block = inst_61138;
var vec__61128 = inst_61125;
var r = inst_61133;
var c__2755__auto____$2 = inst_61165;
var acc = inst_61126;
var vec__61117 = inst_61120;
var seq__61129 = inst_61133;
var seq__61118 = inst_61123;
var G__61116 = inst_61125;
var first__61119 = inst_61122;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61163){
var state_val_61164 = (state_61163[(1)]);
if((state_val_61164 === (1))){
var state_61163__$1 = state_61163;
var statearr_61341_61431 = state_61163__$1;
(statearr_61341_61431[(2)] = null);

(statearr_61341_61431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61164 === (2))){
var ___$1 = (function (){var statearr_61342 = state_61163;
(statearr_61342[(4)] = cljs.core.cons((5),(state_61163[(4)])));

return statearr_61342;
})();
var ___$2 = (function (){var statearr_61343 = state_61163;
(statearr_61343[(4)] = cljs.core.rest((state_61163[(4)])));

return statearr_61343;
})();
var state_61163__$1 = state_61163;
var statearr_61344_61432 = state_61163__$1;
(statearr_61344_61432[(2)] = db);

(statearr_61344_61432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61164 === (3))){
var inst_61161 = (state_61163[(2)]);
var state_61163__$1 = state_61163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61163__$1,inst_61161);
} else {
if((state_val_61164 === (4))){
var inst_61153 = (state_61163[(2)]);
var state_61163__$1 = state_61163;
var statearr_61346_61433 = state_61163__$1;
(statearr_61346_61433[(2)] = inst_61153);

(statearr_61346_61433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61164 === (5))){
var ___$1 = (function (){var statearr_61347 = state_61163;
(statearr_61347[(4)] = cljs.core.rest((state_61163[(4)])));

return statearr_61347;
})();
var state_61163__$1 = state_61163;
var ex61345 = (state_61163__$1[(2)]);
var statearr_61348_61434 = state_61163__$1;
(statearr_61348_61434[(5)] = ex61345);


if((ex61345 instanceof Error)){
var statearr_61349_61435 = state_61163__$1;
(statearr_61349_61435[(1)] = (4));

(statearr_61349_61435[(5)] = null);

} else {
throw ex61345;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_61350 = [null,null,null,null,null,null,null];
(statearr_61350[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__);

(statearr_61350[(1)] = (1));

return statearr_61350;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1 = (function (state_61163){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61163);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61351){var ex__2736__auto__ = e61351;
var statearr_61352_61436 = state_61163;
(statearr_61352_61436[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61163[(4)]))){
var statearr_61353_61437 = state_61163;
(statearr_61353_61437[(1)] = cljs.core.first((state_61163[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61438 = state_61163;
state_61163 = G__61438;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = function(state_61163){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1.call(this,state_61163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61354 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61354[(6)] = c__2755__auto____$2);

return statearr_61354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_61167 = cljs.core.async.impl.dispatch.run(inst_61166);
var inst_61168 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_61169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61170 = ["?auth","?id"];
var inst_61171 = (new cljs.core.PersistentVector(null,2,(5),inst_61169,inst_61170,null));
var inst_61172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61174 = [inst_61132,"_tx/auth","?auth"];
var inst_61175 = (new cljs.core.PersistentVector(null,3,(5),inst_61173,inst_61174,null));
var inst_61176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61177 = ["?auth","_auth/id","?id"];
var inst_61178 = (new cljs.core.PersistentVector(null,3,(5),inst_61176,inst_61177,null));
var inst_61179 = [inst_61175,inst_61178];
var inst_61180 = (new cljs.core.PersistentVector(null,2,(5),inst_61172,inst_61179,null));
var inst_61181 = [inst_61171,inst_61180];
var inst_61182 = cljs.core.PersistentHashMap.fromArrays(inst_61168,inst_61181);
var inst_61183 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_61165,inst_61182) : fluree.db.api.query.query_async.call(null,inst_61165,inst_61182));
var state_61198__$1 = (function (){var statearr_61355 = state_61198;
(statearr_61355[(17)] = inst_61152);

(statearr_61355[(18)] = inst_61167);

return statearr_61355;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61198__$1,(14),inst_61183);
} else {
if((state_val_61199 === (9))){
var state_61198__$1 = state_61198;
var statearr_61356_61439 = state_61198__$1;
(statearr_61356_61439[(2)] = show_auth);

(statearr_61356_61439[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (5))){
var inst_61126 = (state_61198[(7)]);
var state_61198__$1 = state_61198;
var statearr_61357_61440 = state_61198__$1;
(statearr_61357_61440[(2)] = inst_61126);

(statearr_61357_61440[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (14))){
var inst_61152 = (state_61198[(17)]);
var inst_61143 = (state_61198[(11)]);
var inst_61185 = (state_61198[(2)]);
var inst_61186 = fluree.db.util.async.throw_err(inst_61185);
var inst_61187 = cljs.core.assoc_in(inst_61143,inst_61152,inst_61186);
var state_61198__$1 = state_61198;
var statearr_61358_61441 = state_61198__$1;
(statearr_61358_61441[(2)] = inst_61187);

(statearr_61358_61441[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (10))){
var inst_61148 = (state_61198[(2)]);
var state_61198__$1 = state_61198;
if(cljs.core.truth_(inst_61148)){
var statearr_61359_61442 = state_61198__$1;
(statearr_61359_61442[(1)] = (11));

} else {
var statearr_61360_61443 = state_61198__$1;
(statearr_61360_61443[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61199 === (8))){
var inst_61144 = (state_61198[(8)]);
var state_61198__$1 = state_61198;
var statearr_61361_61444 = state_61198__$1;
(statearr_61361_61444[(2)] = inst_61144);

(statearr_61361_61444[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_61362 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61362[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__);

(statearr_61362[(1)] = (1));

return statearr_61362;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1 = (function (state_61198){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61198);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61363){var ex__2736__auto__ = e61363;
var statearr_61364_61445 = state_61198;
(statearr_61364_61445[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61198[(4)]))){
var statearr_61365_61446 = state_61198;
(statearr_61365_61446[(1)] = cljs.core.first((state_61198[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61447 = state_61198;
state_61198 = G__61447;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = function(state_61198){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1.call(this,state_61198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61366 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61366[(6)] = c__2755__auto____$1);

return statearr_61366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_61202 = cljs.core.async.impl.dispatch.run(inst_61201);
var state_61298__$1 = (function (){var statearr_61367 = state_61298;
(statearr_61367[(20)] = inst_61202);

return statearr_61367;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61298__$1,(6),inst_61200);
} else {
if((state_val_61299 === (23))){
var inst_61256 = (state_61298[(2)]);
var state_61298__$1 = (function (){var statearr_61368 = state_61298;
(statearr_61368[(13)] = inst_61256);

return statearr_61368;
})();
var statearr_61369_61448 = state_61298__$1;
(statearr_61369_61448[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (35))){
var inst_61286 = (state_61298[(2)]);
var state_61298__$1 = state_61298;
var statearr_61371_61449 = state_61298__$1;
(statearr_61371_61449[(2)] = inst_61286);

(statearr_61371_61449[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (19))){
var state_61298__$1 = state_61298;
var statearr_61372_61450 = state_61298__$1;
(statearr_61372_61450[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (11))){
var inst_61237 = (state_61298[(2)]);
var state_61298__$1 = state_61298;
if(cljs.core.truth_(inst_61237)){
var statearr_61375_61451 = state_61298__$1;
(statearr_61375_61451[(1)] = (15));

} else {
var statearr_61376_61452 = state_61298__$1;
(statearr_61376_61452[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (9))){
var inst_61228 = (state_61298[(16)]);
var inst_61228__$1 = auth;
var state_61298__$1 = (function (){var statearr_61377 = state_61298;
(statearr_61377[(16)] = inst_61228__$1);

return statearr_61377;
})();
if(cljs.core.truth_(inst_61228__$1)){
var statearr_61378_61453 = state_61298__$1;
(statearr_61378_61453[(1)] = (12));

} else {
var statearr_61379_61454 = state_61298__$1;
(statearr_61379_61454[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (5))){
var _ = (function (){var statearr_61380 = state_61298;
(statearr_61380[(4)] = cljs.core.rest((state_61298[(4)])));

return statearr_61380;
})();
var state_61298__$1 = state_61298;
var ex61374 = (state_61298__$1[(2)]);
var statearr_61381_61455 = state_61298__$1;
(statearr_61381_61455[(5)] = ex61374);


if((ex61374 instanceof Error)){
var statearr_61382_61456 = state_61298__$1;
(statearr_61382_61456[(1)] = (4));

(statearr_61382_61456[(5)] = null);

} else {
throw ex61374;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (14))){
var inst_61234 = (state_61298[(2)]);
var state_61298__$1 = state_61298;
var statearr_61383_61457 = state_61298__$1;
(statearr_61383_61457[(2)] = inst_61234);

(statearr_61383_61457[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (26))){
var inst_61264 = (state_61298[(2)]);
var state_61298__$1 = (function (){var statearr_61384 = state_61298;
(statearr_61384[(11)] = inst_61264);

return statearr_61384;
})();
var statearr_61385_61458 = state_61298__$1;
(statearr_61385_61458[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (16))){
var inst_61225 = (state_61298[(7)]);
var state_61298__$1 = state_61298;
if(cljs.core.truth_(inst_61225)){
var statearr_61387_61459 = state_61298__$1;
(statearr_61387_61459[(1)] = (18));

} else {
var statearr_61388_61460 = state_61298__$1;
(statearr_61388_61460[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (30))){
var inst_61247 = (state_61298[(21)]);
var inst_61272 = (state_61298[(15)]);
var inst_61246 = (state_61298[(12)]);
var inst_61274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61275 = [inst_61246,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61276 = (new cljs.core.PersistentVector(null,2,(5),inst_61274,inst_61275,null));
var inst_61277 = cljs.core.assoc_in(inst_61272,inst_61276,inst_61247);
var state_61298__$1 = state_61298;
var statearr_61389_61461 = state_61298__$1;
(statearr_61389_61461[(2)] = inst_61277);

(statearr_61389_61461[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (10))){
var inst_61225 = (state_61298[(7)]);
var state_61298__$1 = state_61298;
var statearr_61390_61462 = state_61298__$1;
(statearr_61390_61462[(2)] = inst_61225);

(statearr_61390_61462[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (18))){
var inst_61205 = (state_61298[(17)]);
var inst_61225 = (state_61298[(7)]);
var inst_61243 = (state_61298[(10)]);
var inst_61243__$1 = inst_61225.t;
var inst_61244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61205,inst_61243__$1);
var inst_61245 = cljs.core.__destructure_map(inst_61244);
var inst_61246 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61245,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61247 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61245,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_61298__$1 = (function (){var statearr_61391 = state_61298;
(statearr_61391[(21)] = inst_61247);

(statearr_61391[(10)] = inst_61243__$1);

(statearr_61391[(12)] = inst_61246);

return statearr_61391;
})();
var statearr_61392_61463 = state_61298__$1;
(statearr_61392_61463[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61299 === (8))){
var inst_61292 = (state_61298[(2)]);
var inst_61293 = cljs.core.vals(inst_61292);
var _ = (function (){var statearr_61394 = state_61298;
(statearr_61394[(4)] = cljs.core.rest((state_61298[(4)])));

return statearr_61394;
})();
var state_61298__$1 = state_61298;
var statearr_61395_61464 = state_61298__$1;
(statearr_61395_61464[(2)] = inst_61293);

(statearr_61395_61464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_61396 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61396[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__);

(statearr_61396[(1)] = (1));

return statearr_61396;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1 = (function (state_61298){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61298);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61397){var ex__2736__auto__ = e61397;
var statearr_61398_61465 = state_61298;
(statearr_61398_61465[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61298[(4)]))){
var statearr_61399_61466 = state_61298;
(statearr_61399_61466[(1)] = cljs.core.first((state_61298[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61467 = state_61298;
state_61298 = G__61467;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = function(state_61298){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1.call(this,state_61298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61400 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61400[(6)] = c__2755__auto__);

return statearr_61400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61594){
var state_val_61595 = (state_61594[(1)]);
if((state_val_61595 === (7))){
var inst_61490 = (state_61594[(7)]);
var inst_61492 = fluree.db.api.query.resolve_block_range(inst_61490,query_map);
var state_61594__$1 = state_61594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61594__$1,(10),inst_61492);
} else {
if((state_val_61595 === (20))){
var inst_61519 = (state_61594[(2)]);
var inst_61520 = fluree.db.util.async.throw_err(inst_61519);
var inst_61521 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61520);
var inst_61522 = (inst_61521 - (1));
var state_61594__$1 = state_61594;
var statearr_61596_61659 = state_61594__$1;
(statearr_61596_61659[(2)] = inst_61522);

(statearr_61596_61659[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (27))){
var state_61594__$1 = state_61594;
var statearr_61597_61660 = state_61594__$1;
(statearr_61597_61660[(2)] = null);

(statearr_61597_61660[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (1))){
var state_61594__$1 = state_61594;
var statearr_61598_61661 = state_61594__$1;
(statearr_61598_61661[(2)] = null);

(statearr_61598_61661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (24))){
var inst_61529 = (state_61594[(2)]);
var inst_61530 = fluree.db.util.async.throw_err(inst_61529);
var inst_61531 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61530);
var state_61594__$1 = state_61594;
var statearr_61599_61662 = state_61594__$1;
(statearr_61599_61662[(2)] = inst_61531);

(statearr_61599_61662[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (39))){
var inst_61566 = (state_61594[(2)]);
var inst_61567 = fluree.db.util.async.throw_err(inst_61566);
var state_61594__$1 = state_61594;
var statearr_61600_61663 = state_61594__$1;
(statearr_61600_61663[(2)] = inst_61567);

(statearr_61600_61663[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (4))){
var inst_61468 = (state_61594[(2)]);
var state_61594__$1 = state_61594;
var statearr_61601_61664 = state_61594__$1;
(statearr_61601_61664[(2)] = inst_61468);

(statearr_61601_61664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (15))){
var inst_61499 = (state_61594[(8)]);
var state_61594__$1 = state_61594;
var statearr_61602_61665 = state_61594__$1;
(statearr_61602_61665[(2)] = inst_61499);

(statearr_61602_61665[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (21))){
var inst_61500 = (state_61594[(9)]);
var inst_61490 = (state_61594[(7)]);
var inst_61527 = fluree.db.time_travel.as_of_block(inst_61490,inst_61500);
var state_61594__$1 = state_61594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61594__$1,(24),inst_61527);
} else {
if((state_val_61595 === (31))){
var inst_61484 = (state_61594[(10)]);
var state_61594__$1 = state_61594;
var statearr_61603_61666 = state_61594__$1;
(statearr_61603_61666[(2)] = inst_61484);

(statearr_61603_61666[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (32))){
var inst_61550 = (state_61594[(11)]);
var inst_61545 = (state_61594[(12)]);
var inst_61490 = (state_61594[(7)]);
var inst_61554 = (state_61594[(2)]);
var inst_61555 = fluree.db.api.query.format_history_resp(inst_61490,inst_61545,inst_61550,inst_61554);
var state_61594__$1 = state_61594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61594__$1,(29),inst_61555);
} else {
if((state_val_61595 === (40))){
var inst_61571 = (state_61594[(13)]);
var inst_61545 = (state_61594[(12)]);
var inst_61573 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_61574 = cljs.core.count(inst_61545);
var inst_61575 = [inst_61571,inst_61574,(200)];
var inst_61576 = cljs.core.PersistentHashMap.fromArrays(inst_61573,inst_61575);
var state_61594__$1 = state_61594;
var statearr_61604_61667 = state_61594__$1;
(statearr_61604_61667[(2)] = inst_61576);

(statearr_61604_61667[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (33))){
var inst_61483 = (state_61594[(14)]);
var state_61594__$1 = state_61594;
var statearr_61605_61668 = state_61594__$1;
(statearr_61605_61668[(2)] = inst_61483);

(statearr_61605_61668[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (13))){
var inst_61589 = (state_61594[(2)]);
var _ = (function (){var statearr_61606 = state_61594;
(statearr_61606[(4)] = cljs.core.rest((state_61594[(4)])));

return statearr_61606;
})();
var state_61594__$1 = state_61594;
var statearr_61607_61669 = state_61594__$1;
(statearr_61607_61669[(2)] = inst_61589);

(statearr_61607_61669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (22))){
var inst_61490 = (state_61594[(7)]);
var inst_61533 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61490);
var state_61594__$1 = state_61594;
var statearr_61608_61670 = state_61594__$1;
(statearr_61608_61670[(2)] = inst_61533);

(statearr_61608_61670[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (36))){
var inst_61558 = (state_61594[(15)]);
var inst_61490 = (state_61594[(7)]);
var inst_61564 = fluree.db.api.query.format_blocks_resp_pretty(inst_61490,inst_61558);
var state_61594__$1 = state_61594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61594__$1,(39),inst_61564);
} else {
if((state_val_61595 === (41))){
var inst_61571 = (state_61594[(13)]);
var state_61594__$1 = state_61594;
var statearr_61609_61671 = state_61594__$1;
(statearr_61609_61671[(2)] = inst_61571);

(statearr_61609_61671[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (29))){
var inst_61483 = (state_61594[(14)]);
var inst_61557 = (state_61594[(2)]);
var inst_61558 = fluree.db.util.async.throw_err(inst_61557);
var state_61594__$1 = (function (){var statearr_61610 = state_61594;
(statearr_61610[(15)] = inst_61558);

return statearr_61610;
})();
if(cljs.core.truth_(inst_61483)){
var statearr_61611_61672 = state_61594__$1;
(statearr_61611_61672[(1)] = (33));

} else {
var statearr_61612_61673 = state_61594__$1;
(statearr_61612_61673[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (6))){
var inst_61480 = (state_61594[(16)]);
var inst_61489 = (state_61594[(2)]);
var inst_61490 = fluree.db.util.async.throw_err(inst_61489);
var state_61594__$1 = (function (){var statearr_61613 = state_61594;
(statearr_61613[(7)] = inst_61490);

return statearr_61613;
})();
if(cljs.core.truth_(inst_61480)){
var statearr_61614_61674 = state_61594__$1;
(statearr_61614_61674[(1)] = (7));

} else {
var statearr_61615_61675 = state_61594__$1;
(statearr_61615_61675[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (28))){
var inst_61485 = (state_61594[(17)]);
var inst_61550 = (state_61594[(2)]);
var state_61594__$1 = (function (){var statearr_61616 = state_61594;
(statearr_61616[(11)] = inst_61550);

return statearr_61616;
})();
if(cljs.core.truth_(inst_61485)){
var statearr_61617_61676 = state_61594__$1;
(statearr_61617_61676[(1)] = (30));

} else {
var statearr_61618_61677 = state_61594__$1;
(statearr_61618_61677[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (25))){
var inst_61486 = (state_61594[(18)]);
var inst_61544 = (state_61594[(2)]);
var inst_61545 = fluree.db.util.async.throw_err(inst_61544);
var state_61594__$1 = (function (){var statearr_61619 = state_61594;
(statearr_61619[(12)] = inst_61545);

return statearr_61619;
})();
if(cljs.core.truth_(inst_61486)){
var statearr_61620_61678 = state_61594__$1;
(statearr_61620_61678[(1)] = (26));

} else {
var statearr_61621_61679 = state_61594__$1;
(statearr_61621_61679[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (34))){
var inst_61482 = (state_61594[(19)]);
var state_61594__$1 = state_61594;
var statearr_61622_61680 = state_61594__$1;
(statearr_61622_61680[(2)] = inst_61482);

(statearr_61622_61680[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (17))){
var inst_61499 = (state_61594[(8)]);
var inst_61490 = (state_61594[(7)]);
var inst_61516 = (inst_61499 - (1));
var inst_61517 = fluree.db.time_travel.as_of_block(inst_61490,inst_61516);
var state_61594__$1 = state_61594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61594__$1,(20),inst_61517);
} else {
if((state_val_61595 === (3))){
var inst_61592 = (state_61594[(2)]);
var state_61594__$1 = state_61594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61594__$1,inst_61592);
} else {
if((state_val_61595 === (12))){
var inst_61581 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_61582 = ["History query not properly formatted. Provided ",inst_61581].join('');
var inst_61583 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61584 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61585 = cljs.core.PersistentHashMap.fromArrays(inst_61583,inst_61584);
var inst_61586 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61582,inst_61585);
var inst_61587 = (function(){throw inst_61586})();
var state_61594__$1 = state_61594;
var statearr_61623_61681 = state_61594__$1;
(statearr_61623_61681[(2)] = inst_61587);

(statearr_61623_61681[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (2))){
var _ = (function (){var statearr_61624 = state_61594;
(statearr_61624[(4)] = cljs.core.cons((5),(state_61594[(4)])));

return statearr_61624;
})();
var inst_61478 = query_map;
var inst_61479 = cljs.core.__destructure_map(inst_61478);
var inst_61480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61479,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61481 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61479,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61482 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61479,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_61483 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61479,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_61484 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61479,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_61485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61479,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_61486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61479,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_61487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61479,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61594__$1 = (function (){var statearr_61625 = state_61594;
(statearr_61625[(19)] = inst_61482);

(statearr_61625[(10)] = inst_61484);

(statearr_61625[(16)] = inst_61480);

(statearr_61625[(17)] = inst_61485);

(statearr_61625[(14)] = inst_61483);

(statearr_61625[(20)] = inst_61481);

(statearr_61625[(18)] = inst_61486);

(statearr_61625[(21)] = inst_61487);

return statearr_61625;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61594__$1,(6),sources);
} else {
if((state_val_61595 === (23))){
var inst_61525 = (state_61594[(22)]);
var inst_61481 = (state_61594[(20)]);
var inst_61490 = (state_61594[(7)]);
var inst_61535 = (state_61594[(2)]);
var inst_61536 = fluree.db.api.query.get_history_pattern(inst_61481);
var inst_61537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61536,(0),null);
var inst_61538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61536,(1),null);
var inst_61539 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_61540 = [inst_61525,inst_61535];
var inst_61541 = cljs.core.PersistentHashMap.fromArrays(inst_61539,inst_61540);
var inst_61542 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_61490,inst_61538,cljs.core._EQ_,inst_61537,inst_61541);
var state_61594__$1 = state_61594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61594__$1,(25),inst_61542);
} else {
if((state_val_61595 === (35))){
var inst_61562 = (state_61594[(2)]);
var state_61594__$1 = state_61594;
if(cljs.core.truth_(inst_61562)){
var statearr_61626_61682 = state_61594__$1;
(statearr_61626_61682[(1)] = (36));

} else {
var statearr_61627_61683 = state_61594__$1;
(statearr_61627_61683[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (19))){
var inst_61500 = (state_61594[(9)]);
var inst_61525 = (state_61594[(2)]);
var state_61594__$1 = (function (){var statearr_61628 = state_61594;
(statearr_61628[(22)] = inst_61525);

return statearr_61628;
})();
if(cljs.core.truth_(inst_61500)){
var statearr_61629_61684 = state_61594__$1;
(statearr_61629_61684[(1)] = (21));

} else {
var statearr_61630_61685 = state_61594__$1;
(statearr_61630_61685[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (11))){
var inst_61499 = (state_61594[(8)]);
var inst_61487 = (state_61594[(21)]);
var inst_61509 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61487);
var state_61594__$1 = (function (){var statearr_61632 = state_61594;
(statearr_61632[(23)] = inst_61509);

return statearr_61632;
})();
if(cljs.core.truth_(inst_61499)){
var statearr_61633_61686 = state_61594__$1;
(statearr_61633_61686[(1)] = (14));

} else {
var statearr_61634_61687 = state_61594__$1;
(statearr_61634_61687[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (9))){
var inst_61498 = (state_61594[(2)]);
var inst_61499 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61498,(0),null);
var inst_61500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61498,(1),null);
var inst_61501 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61502 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_61503 = cljs.core.keys(inst_61502);
var inst_61504 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61501,inst_61503);
var state_61594__$1 = (function (){var statearr_61635 = state_61594;
(statearr_61635[(9)] = inst_61500);

(statearr_61635[(8)] = inst_61499);

return statearr_61635;
})();
if(inst_61504){
var statearr_61636_61688 = state_61594__$1;
(statearr_61636_61688[(1)] = (11));

} else {
var statearr_61637_61689 = state_61594__$1;
(statearr_61637_61689[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (5))){
var _ = (function (){var statearr_61638 = state_61594;
(statearr_61638[(4)] = cljs.core.rest((state_61594[(4)])));

return statearr_61638;
})();
var state_61594__$1 = state_61594;
var ex61631 = (state_61594__$1[(2)]);
var statearr_61639_61690 = state_61594__$1;
(statearr_61639_61690[(5)] = ex61631);


if((ex61631 instanceof Error)){
var statearr_61640_61691 = state_61594__$1;
(statearr_61640_61691[(1)] = (4));

(statearr_61640_61691[(5)] = null);

} else {
throw ex61631;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (14))){
var inst_61499 = (state_61594[(8)]);
var inst_61511 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_61499);
var state_61594__$1 = state_61594;
var statearr_61641_61692 = state_61594__$1;
(statearr_61641_61692[(2)] = inst_61511);

(statearr_61641_61692[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (26))){
var inst_61486 = (state_61594[(18)]);
var inst_61547 = cljs.core.set(inst_61486);
var state_61594__$1 = state_61594;
var statearr_61642_61693 = state_61594__$1;
(statearr_61642_61693[(2)] = inst_61547);

(statearr_61642_61693[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (16))){
var inst_61514 = (state_61594[(2)]);
var state_61594__$1 = state_61594;
if(cljs.core.truth_(inst_61514)){
var statearr_61643_61694 = state_61594__$1;
(statearr_61643_61694[(1)] = (17));

} else {
var statearr_61644_61695 = state_61594__$1;
(statearr_61644_61695[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (38))){
var inst_61509 = (state_61594[(23)]);
var inst_61571 = (state_61594[(2)]);
var state_61594__$1 = (function (){var statearr_61645 = state_61594;
(statearr_61645[(13)] = inst_61571);

return statearr_61645;
})();
if(cljs.core.truth_(inst_61509)){
var statearr_61646_61696 = state_61594__$1;
(statearr_61646_61696[(1)] = (40));

} else {
var statearr_61647_61697 = state_61594__$1;
(statearr_61647_61697[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (30))){
var inst_61485 = (state_61594[(17)]);
var state_61594__$1 = state_61594;
var statearr_61648_61698 = state_61594__$1;
(statearr_61648_61698[(2)] = inst_61485);

(statearr_61648_61698[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (10))){
var inst_61494 = (state_61594[(2)]);
var inst_61495 = fluree.db.util.async.throw_err(inst_61494);
var state_61594__$1 = state_61594;
var statearr_61649_61699 = state_61594__$1;
(statearr_61649_61699[(2)] = inst_61495);

(statearr_61649_61699[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (18))){
var state_61594__$1 = state_61594;
var statearr_61650_61700 = state_61594__$1;
(statearr_61650_61700[(2)] = (-1));

(statearr_61650_61700[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (42))){
var inst_61579 = (state_61594[(2)]);
var state_61594__$1 = state_61594;
var statearr_61651_61701 = state_61594__$1;
(statearr_61651_61701[(2)] = inst_61579);

(statearr_61651_61701[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (37))){
var inst_61558 = (state_61594[(15)]);
var inst_61569 = fluree.db.api.query.block_Flakes__GT_vector(inst_61558);
var state_61594__$1 = state_61594;
var statearr_61652_61702 = state_61594__$1;
(statearr_61652_61702[(2)] = inst_61569);

(statearr_61652_61702[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61595 === (8))){
var state_61594__$1 = state_61594;
var statearr_61653_61703 = state_61594__$1;
(statearr_61653_61703[(2)] = null);

(statearr_61653_61703[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2733__auto____0 = (function (){
var statearr_61654 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61654[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2733__auto__);

(statearr_61654[(1)] = (1));

return statearr_61654;
});
var fluree$db$api$query$history_query_async_$_state_machine__2733__auto____1 = (function (state_61594){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61594);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61655){var ex__2736__auto__ = e61655;
var statearr_61656_61704 = state_61594;
(statearr_61656_61704[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61594[(4)]))){
var statearr_61657_61705 = state_61594;
(statearr_61657_61705[(1)] = cljs.core.first((state_61594[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61706 = state_61594;
state_61594 = G__61706;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2733__auto__ = function(state_61594){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2733__auto____1.call(this,state_61594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2733__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2733__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61658 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61658[(6)] = c__2755__auto__);

return statearr_61658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_61839){
var state_val_61840 = (state_61839[(1)]);
if((state_val_61840 === (7))){
var inst_61736 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_61737 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_61736].join('');
var inst_61738 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61739 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61740 = cljs.core.PersistentHashMap.fromArrays(inst_61738,inst_61739);
var inst_61741 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61737,inst_61740);
var inst_61742 = (function(){throw inst_61741})();
var state_61839__$1 = state_61839;
var statearr_61841_61920 = state_61839__$1;
(statearr_61841_61920[(2)] = inst_61742);

(statearr_61841_61920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (20))){
var inst_61774 = (state_61839[(2)]);
var state_61839__$1 = state_61839;
if(cljs.core.truth_(inst_61774)){
var statearr_61842_61921 = state_61839__$1;
(statearr_61842_61921[(1)] = (21));

} else {
var statearr_61843_61922 = state_61839__$1;
(statearr_61843_61922[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (27))){
var inst_61718 = (state_61839[(7)]);
var state_61839__$1 = state_61839;
var statearr_61844_61923 = state_61839__$1;
(statearr_61844_61923[(2)] = inst_61718);

(statearr_61844_61923[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (1))){
var state_61839__$1 = state_61839;
var statearr_61845_61924 = state_61839__$1;
(statearr_61845_61924[(2)] = null);

(statearr_61845_61924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (24))){
var inst_61780 = (state_61839[(8)]);
var state_61839__$1 = state_61839;
var statearr_61846_61925 = state_61839__$1;
(statearr_61846_61925[(2)] = inst_61780);

(statearr_61846_61925[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (39))){
var inst_61724 = (state_61839[(9)]);
var state_61839__$1 = state_61839;
if(cljs.core.truth_(inst_61724)){
var statearr_61847_61926 = state_61839__$1;
(statearr_61847_61926[(1)] = (42));

} else {
var statearr_61848_61927 = state_61839__$1;
(statearr_61848_61927[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (46))){
var inst_61812 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61813 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61814 = cljs.core.PersistentHashMap.fromArrays(inst_61812,inst_61813);
var inst_61815 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_61814);
var inst_61816 = (function(){throw inst_61815})();
var state_61839__$1 = state_61839;
var statearr_61849_61928 = state_61839__$1;
(statearr_61849_61928[(2)] = inst_61816);

(statearr_61849_61928[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (4))){
var inst_61708 = (state_61839[(2)]);
var state_61839__$1 = state_61839;
var statearr_61850_61929 = state_61839__$1;
(statearr_61850_61929[(2)] = inst_61708);

(statearr_61850_61929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (15))){
var inst_61759 = (state_61839[(10)]);
var inst_61721 = (state_61839[(11)]);
var inst_61761 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_61759);
var inst_61762 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_61759);
var inst_61763 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_61759);
var inst_61764 = fluree.db.api.query.get_sources(inst_61761,inst_61762,inst_61763,inst_61721);
var state_61839__$1 = state_61839;
var statearr_61851_61930 = state_61839__$1;
(statearr_61851_61930[(2)] = inst_61764);

(statearr_61851_61930[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (48))){
var inst_61769 = (state_61839[(12)]);
var inst_61823 = (state_61839[(2)]);
var inst_61824 = fluree.db.util.async.throw_err(inst_61823);
var state_61839__$1 = (function (){var statearr_61852 = state_61839;
(statearr_61852[(13)] = inst_61824);

return statearr_61852;
})();
if(cljs.core.truth_(inst_61769)){
var statearr_61853_61931 = state_61839__$1;
(statearr_61853_61931[(1)] = (49));

} else {
var statearr_61854_61932 = state_61839__$1;
(statearr_61854_61932[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (50))){
var inst_61824 = (state_61839[(13)]);
var state_61839__$1 = state_61839;
var statearr_61855_61933 = state_61839__$1;
(statearr_61855_61933[(2)] = inst_61824);

(statearr_61855_61933[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (21))){
var inst_61776 = cljs.core.volatile_BANG_((0));
var state_61839__$1 = state_61839;
var statearr_61856_61934 = state_61839__$1;
(statearr_61856_61934[(2)] = inst_61776);

(statearr_61856_61934[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (31))){
var inst_61722 = (state_61839[(14)]);
var state_61839__$1 = state_61839;
if(cljs.core.truth_(inst_61722)){
var statearr_61857_61935 = state_61839__$1;
(statearr_61857_61935[(1)] = (33));

} else {
var statearr_61858_61936 = state_61839__$1;
(statearr_61858_61936[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (32))){
var inst_61799 = (state_61839[(2)]);
var state_61839__$1 = state_61839;
var statearr_61859_61937 = state_61839__$1;
(statearr_61859_61937[(2)] = inst_61799);

(statearr_61859_61937[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (40))){
var inst_61801 = (state_61839[(15)]);
var state_61839__$1 = state_61839;
var statearr_61860_61938 = state_61839__$1;
(statearr_61860_61938[(2)] = inst_61801);

(statearr_61860_61938[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (33))){
var inst_61722 = (state_61839[(14)]);
var state_61839__$1 = state_61839;
var statearr_61861_61939 = state_61839__$1;
(statearr_61861_61939[(2)] = inst_61722);

(statearr_61861_61939[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (13))){
var inst_61719 = (state_61839[(16)]);
var inst_61748 = (state_61839[(2)]);
var inst_61749 = fluree.db.util.async.throw_err(inst_61748);
var inst_61750 = fluree.db.time_travel.as_of_block(inst_61749,inst_61719);
var state_61839__$1 = state_61839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61839__$1,(12),inst_61750);
} else {
if((state_val_61840 === (22))){
var state_61839__$1 = state_61839;
var statearr_61862_61940 = state_61839__$1;
(statearr_61862_61940[(2)] = null);

(statearr_61862_61940[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (36))){
var inst_61726 = (state_61839[(17)]);
var state_61839__$1 = state_61839;
var statearr_61863_61941 = state_61839__$1;
(statearr_61863_61941[(2)] = inst_61726);

(statearr_61863_61941[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (41))){
var inst_61809 = (state_61839[(2)]);
var state_61839__$1 = state_61839;
if(cljs.core.truth_(inst_61809)){
var statearr_61864_61942 = state_61839__$1;
(statearr_61864_61942[(1)] = (45));

} else {
var statearr_61865_61943 = state_61839__$1;
(statearr_61865_61943[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (43))){
var inst_61720 = (state_61839[(18)]);
var state_61839__$1 = state_61839;
var statearr_61866_61944 = state_61839__$1;
(statearr_61866_61944[(2)] = inst_61720);

(statearr_61866_61944[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (29))){
var inst_61801 = (state_61839[(15)]);
var inst_61801__$1 = (state_61839[(2)]);
var state_61839__$1 = (function (){var statearr_61867 = state_61839;
(statearr_61867[(15)] = inst_61801__$1);

return statearr_61867;
})();
if(cljs.core.truth_(inst_61801__$1)){
var statearr_61868_61945 = state_61839__$1;
(statearr_61868_61945[(1)] = (39));

} else {
var statearr_61869_61946 = state_61839__$1;
(statearr_61869_61946[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (44))){
var inst_61806 = (state_61839[(2)]);
var state_61839__$1 = state_61839;
var statearr_61870_61947 = state_61839__$1;
(statearr_61870_61947[(2)] = inst_61806);

(statearr_61870_61947[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (6))){
var state_61839__$1 = state_61839;
var statearr_61871_61948 = state_61839__$1;
(statearr_61871_61948[(2)] = null);

(statearr_61871_61948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (28))){
var inst_61723 = (state_61839[(19)]);
var state_61839__$1 = state_61839;
if(cljs.core.truth_(inst_61723)){
var statearr_61872_61949 = state_61839__$1;
(statearr_61872_61949[(1)] = (30));

} else {
var statearr_61873_61950 = state_61839__$1;
(statearr_61873_61950[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (51))){
var inst_61834 = (state_61839[(2)]);
var _ = (function (){var statearr_61874 = state_61839;
(statearr_61874[(4)] = cljs.core.rest((state_61839[(4)])));

return statearr_61874;
})();
var state_61839__$1 = state_61839;
var statearr_61875_61951 = state_61839__$1;
(statearr_61875_61951[(2)] = inst_61834);

(statearr_61875_61951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (25))){
var state_61839__$1 = state_61839;
var statearr_61876_61952 = state_61839__$1;
(statearr_61876_61952[(2)] = (1000000));

(statearr_61876_61952[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (34))){
var inst_61726 = (state_61839[(17)]);
var state_61839__$1 = state_61839;
if(cljs.core.truth_(inst_61726)){
var statearr_61877_61953 = state_61839__$1;
(statearr_61877_61953[(1)] = (36));

} else {
var statearr_61878_61954 = state_61839__$1;
(statearr_61878_61954[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (17))){
var inst_61770 = (state_61839[(20)]);
var inst_61725 = (state_61839[(21)]);
var inst_61768 = (state_61839[(2)]);
var inst_61769 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61725);
var inst_61770__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61725);
var state_61839__$1 = (function (){var statearr_61879 = state_61839;
(statearr_61879[(20)] = inst_61770__$1);

(statearr_61879[(22)] = inst_61768);

(statearr_61879[(12)] = inst_61769);

return statearr_61879;
})();
if(cljs.core.truth_(inst_61770__$1)){
var statearr_61880_61955 = state_61839__$1;
(statearr_61880_61955[(1)] = (18));

} else {
var statearr_61881_61956 = state_61839__$1;
(statearr_61881_61956[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (3))){
var inst_61837 = (state_61839[(2)]);
var state_61839__$1 = state_61839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61839__$1,inst_61837);
} else {
if((state_val_61840 === (12))){
var inst_61752 = (state_61839[(2)]);
var inst_61753 = fluree.db.util.async.throw_err(inst_61752);
var state_61839__$1 = state_61839;
var statearr_61882_61957 = state_61839__$1;
(statearr_61882_61957[(2)] = inst_61753);

(statearr_61882_61957[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (2))){
var inst_61718 = (state_61839[(7)]);
var inst_61719 = (state_61839[(16)]);
var inst_61721 = (state_61839[(11)]);
var inst_61717 = (state_61839[(23)]);
var inst_61724 = (state_61839[(9)]);
var inst_61723 = (state_61839[(19)]);
var inst_61725 = (state_61839[(21)]);
var inst_61722 = (state_61839[(14)]);
var inst_61720 = (state_61839[(18)]);
var inst_61726 = (state_61839[(17)]);
var _ = (function (){var statearr_61883 = state_61839;
(statearr_61883[(4)] = cljs.core.cons((5),(state_61839[(4)])));

return statearr_61883;
})();
var inst_61715 = flureeQL;
var inst_61716 = cljs.core.__destructure_map(inst_61715);
var inst_61717__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_61718__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_61719__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61720__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_61721__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_61722__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_61723__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_61724__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_61725__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61726__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61716,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_61727 = (function (){var construct = inst_61717__$1;
var select = inst_61718__$1;
var block = inst_61719__$1;
var map__61714 = inst_61716;
var where = inst_61720__$1;
var prefixes = inst_61721__$1;
var selectDistinct = inst_61722__$1;
var selectOne = inst_61723__$1;
var from = inst_61724__$1;
var opts = inst_61725__$1;
var selectReduced = inst_61726__$1;
return (function (p1__61707_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__61707_SHARP_);
});
})();
var inst_61728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61729 = [inst_61718__$1,inst_61723__$1,inst_61722__$1,inst_61726__$1];
var inst_61730 = (new cljs.core.PersistentVector(null,4,(5),inst_61728,inst_61729,null));
var inst_61731 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_61730);
var inst_61732 = cljs.core.count(inst_61731);
var inst_61733 = (inst_61727.cljs$core$IFn$_invoke$arity$1 ? inst_61727.cljs$core$IFn$_invoke$arity$1(inst_61732) : inst_61727.call(null,inst_61732));
var state_61839__$1 = (function (){var statearr_61884 = state_61839;
(statearr_61884[(7)] = inst_61718__$1);

(statearr_61884[(16)] = inst_61719__$1);

(statearr_61884[(11)] = inst_61721__$1);

(statearr_61884[(23)] = inst_61717__$1);

(statearr_61884[(9)] = inst_61724__$1);

(statearr_61884[(19)] = inst_61723__$1);

(statearr_61884[(21)] = inst_61725__$1);

(statearr_61884[(14)] = inst_61722__$1);

(statearr_61884[(18)] = inst_61720__$1);

(statearr_61884[(17)] = inst_61726__$1);

return statearr_61884;
})();
if(cljs.core.truth_(inst_61733)){
var statearr_61885_61958 = state_61839__$1;
(statearr_61885_61958[(1)] = (6));

} else {
var statearr_61886_61959 = state_61839__$1;
(statearr_61886_61959[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (23))){
var inst_61780 = (state_61839[(8)]);
var inst_61725 = (state_61839[(21)]);
var inst_61779 = (state_61839[(2)]);
var inst_61780__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61725);
var state_61839__$1 = (function (){var statearr_61887 = state_61839;
(statearr_61887[(8)] = inst_61780__$1);

(statearr_61887[(24)] = inst_61779);

return statearr_61887;
})();
if(cljs.core.truth_(inst_61780__$1)){
var statearr_61888_61960 = state_61839__$1;
(statearr_61888_61960[(1)] = (24));

} else {
var statearr_61889_61961 = state_61839__$1;
(statearr_61889_61961[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (47))){
var inst_61759 = (state_61839[(10)]);
var inst_61785 = (state_61839[(25)]);
var inst_61818 = (state_61839[(2)]);
var inst_61819 = fluree.db.util.core.current_time_millis();
var inst_61820 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_61785);
var inst_61821 = fluree.db.query.fql.query(inst_61759,inst_61820);
var state_61839__$1 = (function (){var statearr_61890 = state_61839;
(statearr_61890[(26)] = inst_61819);

(statearr_61890[(27)] = inst_61818);

return statearr_61890;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61839__$1,(48),inst_61821);
} else {
if((state_val_61840 === (35))){
var inst_61797 = (state_61839[(2)]);
var state_61839__$1 = state_61839;
var statearr_61891_61962 = state_61839__$1;
(statearr_61891_61962[(2)] = inst_61797);

(statearr_61891_61962[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (19))){
var inst_61769 = (state_61839[(12)]);
var state_61839__$1 = state_61839;
var statearr_61892_61963 = state_61839__$1;
(statearr_61892_61963[(2)] = inst_61769);

(statearr_61892_61963[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (11))){
var inst_61721 = (state_61839[(11)]);
var inst_61759 = (state_61839[(2)]);
var state_61839__$1 = (function (){var statearr_61894 = state_61839;
(statearr_61894[(10)] = inst_61759);

return statearr_61894;
})();
if(cljs.core.truth_(inst_61721)){
var statearr_61895_61964 = state_61839__$1;
(statearr_61895_61964[(1)] = (15));

} else {
var statearr_61896_61965 = state_61839__$1;
(statearr_61896_61965[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (9))){
var inst_61745 = (state_61839[(28)]);
var state_61839__$1 = state_61839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61839__$1,(13),inst_61745);
} else {
if((state_val_61840 === (5))){
var _ = (function (){var statearr_61897 = state_61839;
(statearr_61897[(4)] = cljs.core.rest((state_61839[(4)])));

return statearr_61897;
})();
var state_61839__$1 = state_61839;
var ex61893 = (state_61839__$1[(2)]);
var statearr_61898_61966 = state_61839__$1;
(statearr_61898_61966[(5)] = ex61893);


if((ex61893 instanceof Error)){
var statearr_61899_61967 = state_61839__$1;
(statearr_61899_61967[(1)] = (4));

(statearr_61899_61967[(5)] = null);

} else {
throw ex61893;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (14))){
var inst_61756 = (state_61839[(2)]);
var inst_61757 = fluree.db.util.async.throw_err(inst_61756);
var state_61839__$1 = state_61839;
var statearr_61900_61968 = state_61839__$1;
(statearr_61900_61968[(2)] = inst_61757);

(statearr_61900_61968[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (45))){
var state_61839__$1 = state_61839;
var statearr_61901_61969 = state_61839__$1;
(statearr_61901_61969[(2)] = null);

(statearr_61901_61969[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (26))){
var inst_61718 = (state_61839[(7)]);
var inst_61768 = (state_61839[(22)]);
var inst_61725 = (state_61839[(21)]);
var inst_61779 = (state_61839[(24)]);
var inst_61784 = (state_61839[(2)]);
var inst_61785 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_61725,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_61768,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_61784,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_61779], 0));
var state_61839__$1 = (function (){var statearr_61902 = state_61839;
(statearr_61902[(25)] = inst_61785);

return statearr_61902;
})();
if(cljs.core.truth_(inst_61718)){
var statearr_61903_61970 = state_61839__$1;
(statearr_61903_61970[(1)] = (27));

} else {
var statearr_61904_61971 = state_61839__$1;
(statearr_61904_61971[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (16))){
var inst_61766 = cljs.core.PersistentHashMap.EMPTY;
var state_61839__$1 = state_61839;
var statearr_61905_61972 = state_61839__$1;
(statearr_61905_61972[(2)] = inst_61766);

(statearr_61905_61972[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (38))){
var inst_61795 = (state_61839[(2)]);
var state_61839__$1 = state_61839;
var statearr_61906_61973 = state_61839__$1;
(statearr_61906_61973[(2)] = inst_61795);

(statearr_61906_61973[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (30))){
var inst_61723 = (state_61839[(19)]);
var state_61839__$1 = state_61839;
var statearr_61907_61974 = state_61839__$1;
(statearr_61907_61974[(2)] = inst_61723);

(statearr_61907_61974[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (10))){
var inst_61745 = (state_61839[(28)]);
var state_61839__$1 = state_61839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61839__$1,(14),inst_61745);
} else {
if((state_val_61840 === (18))){
var inst_61770 = (state_61839[(20)]);
var state_61839__$1 = state_61839;
var statearr_61908_61975 = state_61839__$1;
(statearr_61908_61975[(2)] = inst_61770);

(statearr_61908_61975[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (42))){
var inst_61724 = (state_61839[(9)]);
var state_61839__$1 = state_61839;
var statearr_61909_61976 = state_61839__$1;
(statearr_61909_61976[(2)] = inst_61724);

(statearr_61909_61976[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (37))){
var inst_61717 = (state_61839[(23)]);
var state_61839__$1 = state_61839;
var statearr_61910_61977 = state_61839__$1;
(statearr_61910_61977[(2)] = inst_61717);

(statearr_61910_61977[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (8))){
var inst_61719 = (state_61839[(16)]);
var inst_61744 = (state_61839[(2)]);
var inst_61745 = sources;
var state_61839__$1 = (function (){var statearr_61911 = state_61839;
(statearr_61911[(29)] = inst_61744);

(statearr_61911[(28)] = inst_61745);

return statearr_61911;
})();
if(cljs.core.truth_(inst_61719)){
var statearr_61912_61978 = state_61839__$1;
(statearr_61912_61978[(1)] = (9));

} else {
var statearr_61913_61979 = state_61839__$1;
(statearr_61913_61979[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61840 === (49))){
var inst_61759 = (state_61839[(10)]);
var inst_61824 = (state_61839[(13)]);
var inst_61819 = (state_61839[(26)]);
var inst_61779 = (state_61839[(24)]);
var inst_61826 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61827 = cljs.core.deref(inst_61779);
var inst_61828 = fluree.db.api.query.response_time_formatted(inst_61819);
var inst_61829 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_61759);
var inst_61830 = [(200),inst_61824,inst_61827,inst_61828,inst_61829];
var inst_61831 = cljs.core.PersistentHashMap.fromArrays(inst_61826,inst_61830);
var state_61839__$1 = state_61839;
var statearr_61914_61980 = state_61839__$1;
(statearr_61914_61980[(2)] = inst_61831);

(statearr_61914_61980[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2733__auto____0 = (function (){
var statearr_61915 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61915[(0)] = fluree$db$api$query$query_async_$_state_machine__2733__auto__);

(statearr_61915[(1)] = (1));

return statearr_61915;
});
var fluree$db$api$query$query_async_$_state_machine__2733__auto____1 = (function (state_61839){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_61839);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e61916){var ex__2736__auto__ = e61916;
var statearr_61917_61981 = state_61839;
(statearr_61917_61981[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_61839[(4)]))){
var statearr_61918_61982 = state_61839;
(statearr_61918_61982[(1)] = cljs.core.first((state_61839[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61983 = state_61839;
state_61839 = G__61983;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2733__auto__ = function(state_61839){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2733__auto____1.call(this,state_61839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2733__auto____0;
fluree$db$api$query$query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2733__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_61919 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_61919[(6)] = c__2755__auto__);

return statearr_61919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62124){
var state_val_62125 = (state_62124[(1)]);
if((state_val_62125 === (7))){
var inst_62119 = (state_62124[(2)]);
var _ = (function (){var statearr_62126 = state_62124;
(statearr_62126[(4)] = cljs.core.rest((state_62124[(4)])));

return statearr_62126;
})();
var state_62124__$1 = state_62124;
var statearr_62127_62203 = state_62124__$1;
(statearr_62127_62203[(2)] = inst_62119);

(statearr_62127_62203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (20))){
var inst_62091 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
var statearr_62128_62204 = state_62124__$1;
(statearr_62128_62204[(2)] = inst_62091);

(statearr_62128_62204[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (27))){
var inst_62071 = (state_62124[(7)]);
var state_62124__$1 = state_62124;
var statearr_62129_62205 = state_62124__$1;
(statearr_62129_62205[(2)] = inst_62071);

(statearr_62129_62205[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (1))){
var state_62124__$1 = state_62124;
var statearr_62130_62206 = state_62124__$1;
(statearr_62130_62206[(2)] = null);

(statearr_62130_62206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (24))){
var inst_62068 = (state_62124[(8)]);
var state_62124__$1 = state_62124;
var statearr_62131_62207 = state_62124__$1;
(statearr_62131_62207[(2)] = inst_62068);

(statearr_62131_62207[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (39))){
var inst_62025 = (state_62124[(9)]);
var inst_62036 = (state_62124[(10)]);
var inst_62058 = (state_62124[(11)]);
var inst_62102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62103 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_62036];
var inst_62104 = (new cljs.core.PersistentVector(null,2,(5),inst_62102,inst_62103,null));
var inst_62105 = cljs.core.assoc_in(inst_62025,inst_62104,inst_62058);
var state_62124__$1 = state_62124;
var statearr_62132_62208 = state_62124__$1;
(statearr_62132_62208[(2)] = inst_62105);

(statearr_62132_62208[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (4))){
var inst_61984 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
var statearr_62133_62209 = state_62124__$1;
(statearr_62133_62209[(2)] = inst_61984);

(statearr_62133_62209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (15))){
var inst_62023 = (state_62124[(12)]);
var inst_62058 = (state_62124[(11)]);
var inst_62061 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_62058);
var inst_62062 = (inst_62023 == null);
var state_62124__$1 = (function (){var statearr_62134 = state_62124;
(statearr_62134[(13)] = inst_62061);

return statearr_62134;
})();
if(cljs.core.truth_(inst_62062)){
var statearr_62135_62210 = state_62124__$1;
(statearr_62135_62210[(1)] = (18));

} else {
var statearr_62136_62211 = state_62124__$1;
(statearr_62136_62211[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (21))){
var inst_62061 = (state_62124[(13)]);
var state_62124__$1 = state_62124;
var statearr_62137_62212 = state_62124__$1;
(statearr_62137_62212[(2)] = inst_62061);

(statearr_62137_62212[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (31))){
var state_62124__$1 = state_62124;
var statearr_62138_62213 = state_62124__$1;
(statearr_62138_62213[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (32))){
var inst_62087 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
var statearr_62140_62214 = state_62124__$1;
(statearr_62140_62214[(2)] = inst_62087);

(statearr_62140_62214[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (40))){
var inst_62056 = (state_62124[(14)]);
var state_62124__$1 = state_62124;
if(cljs.core.truth_(inst_62056)){
var statearr_62141_62215 = state_62124__$1;
(statearr_62141_62215[(1)] = (42));

} else {
var statearr_62142_62216 = state_62124__$1;
(statearr_62142_62216[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (33))){
var inst_62061 = (state_62124[(13)]);
var inst_62023 = (state_62124[(12)]);
var inst_62082 = ((inst_62061 > inst_62023) ? inst_62061 : inst_62023);
var state_62124__$1 = state_62124;
var statearr_62143_62217 = state_62124__$1;
(statearr_62143_62217[(2)] = inst_62082);

(statearr_62143_62217[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (13))){
var inst_62047 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
var statearr_62144_62218 = state_62124__$1;
(statearr_62144_62218[(2)] = inst_62047);

(statearr_62144_62218[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (22))){
var inst_62061 = (state_62124[(13)]);
var inst_62068 = (state_62124[(8)]);
var inst_62068__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62061);
var state_62124__$1 = (function (){var statearr_62145 = state_62124;
(statearr_62145[(8)] = inst_62068__$1);

return statearr_62145;
})();
if(inst_62068__$1){
var statearr_62146_62219 = state_62124__$1;
(statearr_62146_62219[(1)] = (24));

} else {
var statearr_62147_62220 = state_62124__$1;
(statearr_62147_62220[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (36))){
var inst_62058 = (state_62124[(11)]);
var inst_62024 = (state_62124[(15)]);
var inst_62096 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62058,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_62097 = (inst_62024 + inst_62096);
var state_62124__$1 = state_62124;
var statearr_62148_62221 = state_62124__$1;
(statearr_62148_62221[(2)] = inst_62097);

(statearr_62148_62221[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (41))){
var inst_62035 = (state_62124[(16)]);
var inst_62094 = (state_62124[(17)]);
var inst_62100 = (state_62124[(18)]);
var inst_62114 = (state_62124[(2)]);
var inst_62022 = inst_62035;
var inst_62023 = inst_62094;
var inst_62024 = inst_62100;
var inst_62025 = inst_62114;
var state_62124__$1 = (function (){var statearr_62149 = state_62124;
(statearr_62149[(9)] = inst_62025);

(statearr_62149[(19)] = inst_62022);

(statearr_62149[(12)] = inst_62023);

(statearr_62149[(15)] = inst_62024);

return statearr_62149;
})();
var statearr_62150_62222 = state_62124__$1;
(statearr_62150_62222[(2)] = null);

(statearr_62150_62222[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (43))){
var inst_62058 = (state_62124[(11)]);
var state_62124__$1 = state_62124;
var statearr_62151_62223 = state_62124__$1;
(statearr_62151_62223[(2)] = inst_62058);

(statearr_62151_62223[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (29))){
var inst_62076 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
var statearr_62152_62224 = state_62124__$1;
(statearr_62152_62224[(2)] = inst_62076);

(statearr_62152_62224[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (44))){
var inst_62025 = (state_62124[(9)]);
var inst_62036 = (state_62124[(10)]);
var inst_62111 = (state_62124[(2)]);
var inst_62112 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62025,inst_62036,inst_62111);
var state_62124__$1 = state_62124;
var statearr_62153_62225 = state_62124__$1;
(statearr_62153_62225[(2)] = inst_62112);

(statearr_62153_62225[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (6))){
var inst_62022 = (state_62124[(19)]);
var inst_62037 = (state_62124[(20)]);
var inst_62033 = cljs.core.seq(inst_62022);
var inst_62034 = cljs.core.first(inst_62033);
var inst_62035 = cljs.core.next(inst_62033);
var inst_62036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62034,(0),null);
var inst_62037__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62034,(1),null);
var inst_62038 = (inst_62037__$1 == null);
var state_62124__$1 = (function (){var statearr_62154 = state_62124;
(statearr_62154[(16)] = inst_62035);

(statearr_62154[(10)] = inst_62036);

(statearr_62154[(20)] = inst_62037__$1);

return statearr_62154;
})();
if(cljs.core.truth_(inst_62038)){
var statearr_62155_62226 = state_62124__$1;
(statearr_62155_62226[(1)] = (8));

} else {
var statearr_62156_62227 = state_62124__$1;
(statearr_62156_62227[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (28))){
var inst_62023 = (state_62124[(12)]);
var inst_62074 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_62023);
var state_62124__$1 = state_62124;
var statearr_62157_62228 = state_62124__$1;
(statearr_62157_62228[(2)] = inst_62074);

(statearr_62157_62228[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (25))){
var inst_62071 = (state_62124[(7)]);
var inst_62023 = (state_62124[(12)]);
var inst_62071__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62023);
var state_62124__$1 = (function (){var statearr_62158 = state_62124;
(statearr_62158[(7)] = inst_62071__$1);

return statearr_62158;
})();
if(inst_62071__$1){
var statearr_62159_62229 = state_62124__$1;
(statearr_62159_62229[(1)] = (27));

} else {
var statearr_62160_62230 = state_62124__$1;
(statearr_62160_62230[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (34))){
var state_62124__$1 = state_62124;
var statearr_62161_62231 = state_62124__$1;
(statearr_62161_62231[(2)] = null);

(statearr_62161_62231[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (17))){
var inst_62055 = (state_62124[(21)]);
var inst_62094 = (state_62124[(2)]);
var state_62124__$1 = (function (){var statearr_62162 = state_62124;
(statearr_62162[(17)] = inst_62094);

return statearr_62162;
})();
if(cljs.core.truth_(inst_62055)){
var statearr_62163_62232 = state_62124__$1;
(statearr_62163_62232[(1)] = (36));

} else {
var statearr_62164_62233 = state_62124__$1;
(statearr_62164_62233[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (3))){
var inst_62122 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62124__$1,inst_62122);
} else {
if((state_val_62125 === (12))){
var inst_62025 = (state_62124[(9)]);
var state_62124__$1 = state_62124;
var statearr_62165_62234 = state_62124__$1;
(statearr_62165_62234[(2)] = inst_62025);

(statearr_62165_62234[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (2))){
var inst_61994 = (state_62124[(22)]);
var inst_61998 = (state_62124[(23)]);
var inst_61999 = (state_62124[(24)]);
var _ = (function (){var statearr_62166 = state_62124;
(statearr_62166[(4)] = cljs.core.cons((5),(state_62124[(4)])));

return statearr_62166;
})();
var inst_61990 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_61991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61992 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_61993 = (new cljs.core.PersistentVector(null,2,(5),inst_61991,inst_61992,null));
var inst_61994__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_61993);
var inst_61995 = (function (){var global_block = inst_61990;
var global_meta_QMARK_ = inst_61994__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4223__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4221__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4221__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_61996 = cljs.core.PersistentHashMap.EMPTY;
var inst_61997 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_61998__$1 = cljs.core.reduce_kv(inst_61995,inst_61996,inst_61997);
var inst_61999__$1 = fluree.db.util.core.current_time_millis();
var inst_62001 = (function (){var global_block = inst_61990;
var global_meta_QMARK_ = inst_61994__$1;
var queries = inst_61998__$1;
var start_time = inst_61999__$1;
return (function (p__62000){
var vec__62167 = p__62000;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62167,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62167,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_62002 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_62001,inst_61998__$1);
var inst_62016 = cljs.core.seq(inst_62002);
var inst_62017 = cljs.core.first(inst_62016);
var inst_62018 = cljs.core.next(inst_62016);
var inst_62019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62017,(0),null);
var inst_62020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62017,(1),null);
var inst_62021 = cljs.core.PersistentHashMap.EMPTY;
var inst_62022 = inst_62002;
var inst_62023 = null;
var inst_62024 = (0);
var inst_62025 = inst_62021;
var state_62124__$1 = (function (){var statearr_62170 = state_62124;
(statearr_62170[(9)] = inst_62025);

(statearr_62170[(19)] = inst_62022);

(statearr_62170[(25)] = inst_62020);

(statearr_62170[(22)] = inst_61994__$1);

(statearr_62170[(23)] = inst_61998__$1);

(statearr_62170[(24)] = inst_61999__$1);

(statearr_62170[(12)] = inst_62023);

(statearr_62170[(26)] = inst_62018);

(statearr_62170[(27)] = inst_62019);

(statearr_62170[(15)] = inst_62024);

return statearr_62170;
})();
var statearr_62171_62235 = state_62124__$1;
(statearr_62171_62235[(2)] = null);

(statearr_62171_62235[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (23))){
var inst_62089 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
var statearr_62172_62236 = state_62124__$1;
(statearr_62172_62236[(2)] = inst_62089);

(statearr_62172_62236[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (35))){
var inst_62085 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
var statearr_62173_62237 = state_62124__$1;
(statearr_62173_62237[(2)] = inst_62085);

(statearr_62173_62237[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (19))){
var inst_62061 = (state_62124[(13)]);
var inst_62023 = (state_62124[(12)]);
var inst_62065 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62023,inst_62061);
var state_62124__$1 = state_62124;
if(inst_62065){
var statearr_62174_62238 = state_62124__$1;
(statearr_62174_62238[(1)] = (21));

} else {
var statearr_62175_62239 = state_62124__$1;
(statearr_62175_62239[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (11))){
var inst_62025 = (state_62124[(9)]);
var inst_61999 = (state_62124[(24)]);
var inst_62023 = (state_62124[(12)]);
var inst_62024 = (state_62124[(15)]);
var inst_62041 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_62042 = fluree.db.api.query.response_time_formatted(inst_61999);
var inst_62043 = [inst_62025,inst_62024,inst_62023,inst_62042];
var inst_62044 = cljs.core.PersistentHashMap.fromArrays(inst_62041,inst_62043);
var state_62124__$1 = state_62124;
var statearr_62177_62240 = state_62124__$1;
(statearr_62177_62240[(2)] = inst_62044);

(statearr_62177_62240[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (9))){
var inst_61998 = (state_62124[(23)]);
var inst_62036 = (state_62124[(10)]);
var inst_62037 = (state_62124[(20)]);
var inst_62050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62051 = [inst_62036,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_62052 = (new cljs.core.PersistentVector(null,2,(5),inst_62050,inst_62051,null));
var inst_62053 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61998,inst_62052);
var inst_62054 = cljs.core.__destructure_map(inst_62053);
var inst_62055 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62054,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_62056 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62054,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_62124__$1 = (function (){var statearr_62178 = state_62124;
(statearr_62178[(14)] = inst_62056);

(statearr_62178[(21)] = inst_62055);

return statearr_62178;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62124__$1,(14),inst_62037);
} else {
if((state_val_62125 === (5))){
var _ = (function (){var statearr_62179 = state_62124;
(statearr_62179[(4)] = cljs.core.rest((state_62124[(4)])));

return statearr_62179;
})();
var state_62124__$1 = state_62124;
var ex62176 = (state_62124__$1[(2)]);
var statearr_62180_62241 = state_62124__$1;
(statearr_62180_62241[(5)] = ex62176);


var statearr_62181_62242 = state_62124__$1;
(statearr_62181_62242[(1)] = (4));

(statearr_62181_62242[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (14))){
var inst_62055 = (state_62124[(21)]);
var inst_62058 = (state_62124[(11)]);
var inst_62058__$1 = (state_62124[(2)]);
var inst_62059 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_62058__$1);
var state_62124__$1 = (function (){var statearr_62182 = state_62124;
(statearr_62182[(11)] = inst_62058__$1);

(statearr_62182[(28)] = inst_62059);

return statearr_62182;
})();
if(cljs.core.truth_(inst_62055)){
var statearr_62183_62243 = state_62124__$1;
(statearr_62183_62243[(1)] = (15));

} else {
var statearr_62184_62244 = state_62124__$1;
(statearr_62184_62244[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (26))){
var inst_62078 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
if(cljs.core.truth_(inst_62078)){
var statearr_62185_62245 = state_62124__$1;
(statearr_62185_62245[(1)] = (30));

} else {
var statearr_62186_62246 = state_62124__$1;
(statearr_62186_62246[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (16))){
var state_62124__$1 = state_62124;
var statearr_62187_62247 = state_62124__$1;
(statearr_62187_62247[(2)] = null);

(statearr_62187_62247[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (38))){
var inst_62059 = (state_62124[(28)]);
var inst_62100 = (state_62124[(2)]);
var state_62124__$1 = (function (){var statearr_62188 = state_62124;
(statearr_62188[(18)] = inst_62100);

return statearr_62188;
})();
if(cljs.core.truth_(inst_62059)){
var statearr_62189_62248 = state_62124__$1;
(statearr_62189_62248[(1)] = (39));

} else {
var statearr_62190_62249 = state_62124__$1;
(statearr_62190_62249[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (30))){
var state_62124__$1 = state_62124;
var statearr_62191_62250 = state_62124__$1;
(statearr_62191_62250[(2)] = (207));

(statearr_62191_62250[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (10))){
var inst_62117 = (state_62124[(2)]);
var state_62124__$1 = state_62124;
var statearr_62192_62251 = state_62124__$1;
(statearr_62192_62251[(2)] = inst_62117);

(statearr_62192_62251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (18))){
var inst_62061 = (state_62124[(13)]);
var state_62124__$1 = state_62124;
var statearr_62193_62252 = state_62124__$1;
(statearr_62193_62252[(2)] = inst_62061);

(statearr_62193_62252[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (42))){
var inst_62058 = (state_62124[(11)]);
var inst_62108 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_62058);
var state_62124__$1 = state_62124;
var statearr_62194_62253 = state_62124__$1;
(statearr_62194_62253[(2)] = inst_62108);

(statearr_62194_62253[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (37))){
var state_62124__$1 = state_62124;
var statearr_62195_62254 = state_62124__$1;
(statearr_62195_62254[(2)] = null);

(statearr_62195_62254[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62125 === (8))){
var inst_61994 = (state_62124[(22)]);
var state_62124__$1 = state_62124;
if(cljs.core.truth_(inst_61994)){
var statearr_62196_62255 = state_62124__$1;
(statearr_62196_62255[(1)] = (11));

} else {
var statearr_62197_62256 = state_62124__$1;
(statearr_62197_62256[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____0 = (function (){
var statearr_62198 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62198[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__);

(statearr_62198[(1)] = (1));

return statearr_62198;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____1 = (function (state_62124){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62124);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62199){var ex__2736__auto__ = e62199;
var statearr_62200_62257 = state_62124;
(statearr_62200_62257[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62124[(4)]))){
var statearr_62201_62258 = state_62124;
(statearr_62201_62258[(1)] = cljs.core.first((state_62124[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62259 = state_62124;
state_62124 = G__62259;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__ = function(state_62124){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____1.call(this,state_62124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62202 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62202[(6)] = c__2755__auto__);

return statearr_62202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__62260 = query_type;
var G__62260__$1 = (((G__62260 instanceof cljs.core.Keyword))?G__62260.fqn:null);
switch (G__62260__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62260__$1)].join('')));

}
});
