// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11409 = arguments.length;
switch (G__11409) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11410 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11410 = (function (f,blockable,meta11411){
this.f = f;
this.blockable = blockable;
this.meta11411 = meta11411;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11410.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11412,meta11411__$1){
var self__ = this;
var _11412__$1 = this;
return (new cljs.core.async.t_cljs$core$async11410(self__.f,self__.blockable,meta11411__$1));
}));

(cljs.core.async.t_cljs$core$async11410.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11412){
var self__ = this;
var _11412__$1 = this;
return self__.meta11411;
}));

(cljs.core.async.t_cljs$core$async11410.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11410.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11410.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11410.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11410.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11411","meta11411",1911370695,null)], null);
}));

(cljs.core.async.t_cljs$core$async11410.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11410.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11410");

(cljs.core.async.t_cljs$core$async11410.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async11410");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11410.
 */
cljs.core.async.__GT_t_cljs$core$async11410 = (function cljs$core$async$__GT_t_cljs$core$async11410(f__$1,blockable__$1,meta11411){
return (new cljs.core.async.t_cljs$core$async11410(f__$1,blockable__$1,meta11411));
});

}

return (new cljs.core.async.t_cljs$core$async11410(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11416 = arguments.length;
switch (G__11416) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11419 = arguments.length;
switch (G__11419) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11422 = arguments.length;
switch (G__11422) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_11424 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11424) : fn1.call(null,val_11424));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11424) : fn1.call(null,val_11424));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11426 = arguments.length;
switch (G__11426) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4706__auto___11428 = n;
var x_11429 = (0);
while(true){
if((x_11429 < n__4706__auto___11428)){
(a[x_11429] = x_11429);

var G__11430 = (x_11429 + (1));
x_11429 = G__11430;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11431 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11431 = (function (flag,meta11432){
this.flag = flag;
this.meta11432 = meta11432;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11431.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11433,meta11432__$1){
var self__ = this;
var _11433__$1 = this;
return (new cljs.core.async.t_cljs$core$async11431(self__.flag,meta11432__$1));
}));

(cljs.core.async.t_cljs$core$async11431.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11433){
var self__ = this;
var _11433__$1 = this;
return self__.meta11432;
}));

(cljs.core.async.t_cljs$core$async11431.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11431.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11431.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11431.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11431.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11432","meta11432",140135887,null)], null);
}));

(cljs.core.async.t_cljs$core$async11431.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11431.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11431");

(cljs.core.async.t_cljs$core$async11431.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async11431");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11431.
 */
cljs.core.async.__GT_t_cljs$core$async11431 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11431(flag__$1,meta11432){
return (new cljs.core.async.t_cljs$core$async11431(flag__$1,meta11432));
});

}

return (new cljs.core.async.t_cljs$core$async11431(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11434 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11434 = (function (flag,cb,meta11435){
this.flag = flag;
this.cb = cb;
this.meta11435 = meta11435;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11434.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11436,meta11435__$1){
var self__ = this;
var _11436__$1 = this;
return (new cljs.core.async.t_cljs$core$async11434(self__.flag,self__.cb,meta11435__$1));
}));

(cljs.core.async.t_cljs$core$async11434.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11436){
var self__ = this;
var _11436__$1 = this;
return self__.meta11435;
}));

(cljs.core.async.t_cljs$core$async11434.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11434.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11434.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11434.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11434.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11435","meta11435",1744338359,null)], null);
}));

(cljs.core.async.t_cljs$core$async11434.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11434.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11434");

(cljs.core.async.t_cljs$core$async11434.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async11434");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11434.
 */
cljs.core.async.__GT_t_cljs$core$async11434 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11434(flag__$1,cb__$1,meta11435){
return (new cljs.core.async.t_cljs$core$async11434(flag__$1,cb__$1,meta11435));
});

}

return (new cljs.core.async.t_cljs$core$async11434(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11437_SHARP_){
var G__11439 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11437_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11439) : fret.call(null,G__11439));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11438_SHARP_){
var G__11440 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11438_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11440) : fret.call(null,G__11440));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4223__auto__ = wport;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11441 = (i + (1));
i = G__11441;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4223__auto__ = ret;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4221__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4221__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___11446 = arguments.length;
var i__4830__auto___11447 = (0);
while(true){
if((i__4830__auto___11447 < len__4829__auto___11446)){
args__4835__auto__.push((arguments[i__4830__auto___11447]));

var G__11448 = (i__4830__auto___11447 + (1));
i__4830__auto___11447 = G__11448;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11444){
var map__11445 = p__11444;
var map__11445__$1 = cljs.core.__destructure_map(map__11445);
var opts = map__11445__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11442){
var G__11443 = cljs.core.first(seq11442);
var seq11442__$1 = cljs.core.next(seq11442);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11443,seq11442__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11450 = arguments.length;
switch (G__11450) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11349__auto___11497 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_11474){
var state_val_11475 = (state_11474[(1)]);
if((state_val_11475 === (7))){
var inst_11470 = (state_11474[(2)]);
var state_11474__$1 = state_11474;
var statearr_11476_11498 = state_11474__$1;
(statearr_11476_11498[(2)] = inst_11470);

(statearr_11476_11498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (1))){
var state_11474__$1 = state_11474;
var statearr_11477_11499 = state_11474__$1;
(statearr_11477_11499[(2)] = null);

(statearr_11477_11499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (4))){
var inst_11453 = (state_11474[(7)]);
var inst_11453__$1 = (state_11474[(2)]);
var inst_11454 = (inst_11453__$1 == null);
var state_11474__$1 = (function (){var statearr_11478 = state_11474;
(statearr_11478[(7)] = inst_11453__$1);

return statearr_11478;
})();
if(cljs.core.truth_(inst_11454)){
var statearr_11479_11500 = state_11474__$1;
(statearr_11479_11500[(1)] = (5));

} else {
var statearr_11480_11501 = state_11474__$1;
(statearr_11480_11501[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (13))){
var state_11474__$1 = state_11474;
var statearr_11481_11502 = state_11474__$1;
(statearr_11481_11502[(2)] = null);

(statearr_11481_11502[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (6))){
var inst_11453 = (state_11474[(7)]);
var state_11474__$1 = state_11474;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11474__$1,(11),to,inst_11453);
} else {
if((state_val_11475 === (3))){
var inst_11472 = (state_11474[(2)]);
var state_11474__$1 = state_11474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11474__$1,inst_11472);
} else {
if((state_val_11475 === (12))){
var state_11474__$1 = state_11474;
var statearr_11482_11503 = state_11474__$1;
(statearr_11482_11503[(2)] = null);

(statearr_11482_11503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (2))){
var state_11474__$1 = state_11474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11474__$1,(4),from);
} else {
if((state_val_11475 === (11))){
var inst_11463 = (state_11474[(2)]);
var state_11474__$1 = state_11474;
if(cljs.core.truth_(inst_11463)){
var statearr_11483_11504 = state_11474__$1;
(statearr_11483_11504[(1)] = (12));

} else {
var statearr_11484_11505 = state_11474__$1;
(statearr_11484_11505[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (9))){
var state_11474__$1 = state_11474;
var statearr_11485_11506 = state_11474__$1;
(statearr_11485_11506[(2)] = null);

(statearr_11485_11506[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (5))){
var state_11474__$1 = state_11474;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11486_11507 = state_11474__$1;
(statearr_11486_11507[(1)] = (8));

} else {
var statearr_11487_11508 = state_11474__$1;
(statearr_11487_11508[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (14))){
var inst_11468 = (state_11474[(2)]);
var state_11474__$1 = state_11474;
var statearr_11488_11509 = state_11474__$1;
(statearr_11488_11509[(2)] = inst_11468);

(statearr_11488_11509[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (10))){
var inst_11460 = (state_11474[(2)]);
var state_11474__$1 = state_11474;
var statearr_11489_11510 = state_11474__$1;
(statearr_11489_11510[(2)] = inst_11460);

(statearr_11489_11510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (8))){
var inst_11457 = cljs.core.async.close_BANG_(to);
var state_11474__$1 = state_11474;
var statearr_11490_11511 = state_11474__$1;
(statearr_11490_11511[(2)] = inst_11457);

(statearr_11490_11511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_11491 = [null,null,null,null,null,null,null,null];
(statearr_11491[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_11491[(1)] = (1));

return statearr_11491;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_11474){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11474);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11492){var ex__11278__auto__ = e11492;
var statearr_11493_11512 = state_11474;
(statearr_11493_11512[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11474[(4)]))){
var statearr_11494_11513 = state_11474;
(statearr_11494_11513[(1)] = cljs.core.first((state_11474[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11514 = state_11474;
state_11474 = G__11514;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_11474){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_11474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_11495 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11495[(6)] = c__11349__auto___11497);

return statearr_11495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__11515){
var vec__11516 = p__11515;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11516,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11516,(1),null);
var job = vec__11516;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11349__auto___11692 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_11523){
var state_val_11524 = (state_11523[(1)]);
if((state_val_11524 === (1))){
var state_11523__$1 = state_11523;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11523__$1,(2),res,v);
} else {
if((state_val_11524 === (2))){
var inst_11520 = (state_11523[(2)]);
var inst_11521 = cljs.core.async.close_BANG_(res);
var state_11523__$1 = (function (){var statearr_11525 = state_11523;
(statearr_11525[(7)] = inst_11520);

return statearr_11525;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_11523__$1,inst_11521);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0 = (function (){
var statearr_11526 = [null,null,null,null,null,null,null,null];
(statearr_11526[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__);

(statearr_11526[(1)] = (1));

return statearr_11526;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1 = (function (state_11523){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11523);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11527){var ex__11278__auto__ = e11527;
var statearr_11528_11693 = state_11523;
(statearr_11528_11693[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11523[(4)]))){
var statearr_11529_11694 = state_11523;
(statearr_11529_11694[(1)] = cljs.core.first((state_11523[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11695 = state_11523;
state_11523 = G__11695;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = function(state_11523){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1.call(this,state_11523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_11530 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11530[(6)] = c__11349__auto___11692);

return statearr_11530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__11531){
var vec__11532 = p__11531;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11532,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11532,(1),null);
var job = vec__11532;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4706__auto___11696 = n;
var __11697 = (0);
while(true){
if((__11697 < n__4706__auto___11696)){
var G__11535_11698 = type;
var G__11535_11699__$1 = (((G__11535_11698 instanceof cljs.core.Keyword))?G__11535_11698.fqn:null);
switch (G__11535_11699__$1) {
case "compute":
var c__11349__auto___11701 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11697,c__11349__auto___11701,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async){
return (function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = ((function (__11697,c__11349__auto___11701,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async){
return (function (state_11548){
var state_val_11549 = (state_11548[(1)]);
if((state_val_11549 === (1))){
var state_11548__$1 = state_11548;
var statearr_11550_11702 = state_11548__$1;
(statearr_11550_11702[(2)] = null);

(statearr_11550_11702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11549 === (2))){
var state_11548__$1 = state_11548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11548__$1,(4),jobs);
} else {
if((state_val_11549 === (3))){
var inst_11546 = (state_11548[(2)]);
var state_11548__$1 = state_11548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11548__$1,inst_11546);
} else {
if((state_val_11549 === (4))){
var inst_11538 = (state_11548[(2)]);
var inst_11539 = process(inst_11538);
var state_11548__$1 = state_11548;
if(cljs.core.truth_(inst_11539)){
var statearr_11551_11703 = state_11548__$1;
(statearr_11551_11703[(1)] = (5));

} else {
var statearr_11552_11704 = state_11548__$1;
(statearr_11552_11704[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11549 === (5))){
var state_11548__$1 = state_11548;
var statearr_11553_11705 = state_11548__$1;
(statearr_11553_11705[(2)] = null);

(statearr_11553_11705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11549 === (6))){
var state_11548__$1 = state_11548;
var statearr_11554_11706 = state_11548__$1;
(statearr_11554_11706[(2)] = null);

(statearr_11554_11706[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11549 === (7))){
var inst_11544 = (state_11548[(2)]);
var state_11548__$1 = state_11548;
var statearr_11555_11707 = state_11548__$1;
(statearr_11555_11707[(2)] = inst_11544);

(statearr_11555_11707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11697,c__11349__auto___11701,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async))
;
return ((function (__11697,switch__11274__auto__,c__11349__auto___11701,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0 = (function (){
var statearr_11556 = [null,null,null,null,null,null,null];
(statearr_11556[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__);

(statearr_11556[(1)] = (1));

return statearr_11556;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1 = (function (state_11548){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11548);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11557){var ex__11278__auto__ = e11557;
var statearr_11558_11708 = state_11548;
(statearr_11558_11708[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11548[(4)]))){
var statearr_11559_11709 = state_11548;
(statearr_11559_11709[(1)] = cljs.core.first((state_11548[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11710 = state_11548;
state_11548 = G__11710;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = function(state_11548){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1.call(this,state_11548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__;
})()
;})(__11697,switch__11274__auto__,c__11349__auto___11701,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async))
})();
var state__11351__auto__ = (function (){var statearr_11560 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11560[(6)] = c__11349__auto___11701);

return statearr_11560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
});})(__11697,c__11349__auto___11701,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async))
);


break;
case "async":
var c__11349__auto___11711 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11697,c__11349__auto___11711,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async){
return (function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = ((function (__11697,c__11349__auto___11711,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async){
return (function (state_11573){
var state_val_11574 = (state_11573[(1)]);
if((state_val_11574 === (1))){
var state_11573__$1 = state_11573;
var statearr_11575_11712 = state_11573__$1;
(statearr_11575_11712[(2)] = null);

(statearr_11575_11712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (2))){
var state_11573__$1 = state_11573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11573__$1,(4),jobs);
} else {
if((state_val_11574 === (3))){
var inst_11571 = (state_11573[(2)]);
var state_11573__$1 = state_11573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11573__$1,inst_11571);
} else {
if((state_val_11574 === (4))){
var inst_11563 = (state_11573[(2)]);
var inst_11564 = async(inst_11563);
var state_11573__$1 = state_11573;
if(cljs.core.truth_(inst_11564)){
var statearr_11576_11713 = state_11573__$1;
(statearr_11576_11713[(1)] = (5));

} else {
var statearr_11577_11714 = state_11573__$1;
(statearr_11577_11714[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (5))){
var state_11573__$1 = state_11573;
var statearr_11578_11715 = state_11573__$1;
(statearr_11578_11715[(2)] = null);

(statearr_11578_11715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (6))){
var state_11573__$1 = state_11573;
var statearr_11579_11716 = state_11573__$1;
(statearr_11579_11716[(2)] = null);

(statearr_11579_11716[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (7))){
var inst_11569 = (state_11573[(2)]);
var state_11573__$1 = state_11573;
var statearr_11580_11717 = state_11573__$1;
(statearr_11580_11717[(2)] = inst_11569);

(statearr_11580_11717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11697,c__11349__auto___11711,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async))
;
return ((function (__11697,switch__11274__auto__,c__11349__auto___11711,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0 = (function (){
var statearr_11581 = [null,null,null,null,null,null,null];
(statearr_11581[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__);

(statearr_11581[(1)] = (1));

return statearr_11581;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1 = (function (state_11573){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11573);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11582){var ex__11278__auto__ = e11582;
var statearr_11583_11718 = state_11573;
(statearr_11583_11718[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11573[(4)]))){
var statearr_11584_11719 = state_11573;
(statearr_11584_11719[(1)] = cljs.core.first((state_11573[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11720 = state_11573;
state_11573 = G__11720;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = function(state_11573){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1.call(this,state_11573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__;
})()
;})(__11697,switch__11274__auto__,c__11349__auto___11711,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async))
})();
var state__11351__auto__ = (function (){var statearr_11585 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11585[(6)] = c__11349__auto___11711);

return statearr_11585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
});})(__11697,c__11349__auto___11711,G__11535_11698,G__11535_11699__$1,n__4706__auto___11696,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11535_11699__$1)].join('')));

}

var G__11721 = (__11697 + (1));
__11697 = G__11721;
continue;
} else {
}
break;
}

var c__11349__auto___11722 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_11607){
var state_val_11608 = (state_11607[(1)]);
if((state_val_11608 === (7))){
var inst_11603 = (state_11607[(2)]);
var state_11607__$1 = state_11607;
var statearr_11609_11723 = state_11607__$1;
(statearr_11609_11723[(2)] = inst_11603);

(statearr_11609_11723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11608 === (1))){
var state_11607__$1 = state_11607;
var statearr_11610_11724 = state_11607__$1;
(statearr_11610_11724[(2)] = null);

(statearr_11610_11724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11608 === (4))){
var inst_11588 = (state_11607[(7)]);
var inst_11588__$1 = (state_11607[(2)]);
var inst_11589 = (inst_11588__$1 == null);
var state_11607__$1 = (function (){var statearr_11611 = state_11607;
(statearr_11611[(7)] = inst_11588__$1);

return statearr_11611;
})();
if(cljs.core.truth_(inst_11589)){
var statearr_11612_11725 = state_11607__$1;
(statearr_11612_11725[(1)] = (5));

} else {
var statearr_11613_11726 = state_11607__$1;
(statearr_11613_11726[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11608 === (6))){
var inst_11593 = (state_11607[(8)]);
var inst_11588 = (state_11607[(7)]);
var inst_11593__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_11594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11595 = [inst_11588,inst_11593__$1];
var inst_11596 = (new cljs.core.PersistentVector(null,2,(5),inst_11594,inst_11595,null));
var state_11607__$1 = (function (){var statearr_11614 = state_11607;
(statearr_11614[(8)] = inst_11593__$1);

return statearr_11614;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11607__$1,(8),jobs,inst_11596);
} else {
if((state_val_11608 === (3))){
var inst_11605 = (state_11607[(2)]);
var state_11607__$1 = state_11607;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11607__$1,inst_11605);
} else {
if((state_val_11608 === (2))){
var state_11607__$1 = state_11607;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11607__$1,(4),from);
} else {
if((state_val_11608 === (9))){
var inst_11600 = (state_11607[(2)]);
var state_11607__$1 = (function (){var statearr_11615 = state_11607;
(statearr_11615[(9)] = inst_11600);

return statearr_11615;
})();
var statearr_11616_11727 = state_11607__$1;
(statearr_11616_11727[(2)] = null);

(statearr_11616_11727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11608 === (5))){
var inst_11591 = cljs.core.async.close_BANG_(jobs);
var state_11607__$1 = state_11607;
var statearr_11617_11728 = state_11607__$1;
(statearr_11617_11728[(2)] = inst_11591);

(statearr_11617_11728[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11608 === (8))){
var inst_11593 = (state_11607[(8)]);
var inst_11598 = (state_11607[(2)]);
var state_11607__$1 = (function (){var statearr_11618 = state_11607;
(statearr_11618[(10)] = inst_11598);

return statearr_11618;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11607__$1,(9),results,inst_11593);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0 = (function (){
var statearr_11619 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11619[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__);

(statearr_11619[(1)] = (1));

return statearr_11619;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1 = (function (state_11607){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11607);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11620){var ex__11278__auto__ = e11620;
var statearr_11621_11729 = state_11607;
(statearr_11621_11729[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11607[(4)]))){
var statearr_11622_11730 = state_11607;
(statearr_11622_11730[(1)] = cljs.core.first((state_11607[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11731 = state_11607;
state_11607 = G__11731;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = function(state_11607){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1.call(this,state_11607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_11623 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11623[(6)] = c__11349__auto___11722);

return statearr_11623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


var c__11349__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_11661){
var state_val_11662 = (state_11661[(1)]);
if((state_val_11662 === (7))){
var inst_11657 = (state_11661[(2)]);
var state_11661__$1 = state_11661;
var statearr_11663_11732 = state_11661__$1;
(statearr_11663_11732[(2)] = inst_11657);

(statearr_11663_11732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (20))){
var state_11661__$1 = state_11661;
var statearr_11664_11733 = state_11661__$1;
(statearr_11664_11733[(2)] = null);

(statearr_11664_11733[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (1))){
var state_11661__$1 = state_11661;
var statearr_11665_11734 = state_11661__$1;
(statearr_11665_11734[(2)] = null);

(statearr_11665_11734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (4))){
var inst_11626 = (state_11661[(7)]);
var inst_11626__$1 = (state_11661[(2)]);
var inst_11627 = (inst_11626__$1 == null);
var state_11661__$1 = (function (){var statearr_11666 = state_11661;
(statearr_11666[(7)] = inst_11626__$1);

return statearr_11666;
})();
if(cljs.core.truth_(inst_11627)){
var statearr_11667_11735 = state_11661__$1;
(statearr_11667_11735[(1)] = (5));

} else {
var statearr_11668_11736 = state_11661__$1;
(statearr_11668_11736[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (15))){
var inst_11639 = (state_11661[(8)]);
var state_11661__$1 = state_11661;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11661__$1,(18),to,inst_11639);
} else {
if((state_val_11662 === (21))){
var inst_11652 = (state_11661[(2)]);
var state_11661__$1 = state_11661;
var statearr_11669_11737 = state_11661__$1;
(statearr_11669_11737[(2)] = inst_11652);

(statearr_11669_11737[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (13))){
var inst_11654 = (state_11661[(2)]);
var state_11661__$1 = (function (){var statearr_11670 = state_11661;
(statearr_11670[(9)] = inst_11654);

return statearr_11670;
})();
var statearr_11671_11738 = state_11661__$1;
(statearr_11671_11738[(2)] = null);

(statearr_11671_11738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (6))){
var inst_11626 = (state_11661[(7)]);
var state_11661__$1 = state_11661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11661__$1,(11),inst_11626);
} else {
if((state_val_11662 === (17))){
var inst_11647 = (state_11661[(2)]);
var state_11661__$1 = state_11661;
if(cljs.core.truth_(inst_11647)){
var statearr_11672_11739 = state_11661__$1;
(statearr_11672_11739[(1)] = (19));

} else {
var statearr_11673_11740 = state_11661__$1;
(statearr_11673_11740[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (3))){
var inst_11659 = (state_11661[(2)]);
var state_11661__$1 = state_11661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11661__$1,inst_11659);
} else {
if((state_val_11662 === (12))){
var inst_11636 = (state_11661[(10)]);
var state_11661__$1 = state_11661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11661__$1,(14),inst_11636);
} else {
if((state_val_11662 === (2))){
var state_11661__$1 = state_11661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11661__$1,(4),results);
} else {
if((state_val_11662 === (19))){
var state_11661__$1 = state_11661;
var statearr_11674_11741 = state_11661__$1;
(statearr_11674_11741[(2)] = null);

(statearr_11674_11741[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (11))){
var inst_11636 = (state_11661[(2)]);
var state_11661__$1 = (function (){var statearr_11675 = state_11661;
(statearr_11675[(10)] = inst_11636);

return statearr_11675;
})();
var statearr_11676_11742 = state_11661__$1;
(statearr_11676_11742[(2)] = null);

(statearr_11676_11742[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (9))){
var state_11661__$1 = state_11661;
var statearr_11677_11743 = state_11661__$1;
(statearr_11677_11743[(2)] = null);

(statearr_11677_11743[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (5))){
var state_11661__$1 = state_11661;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11678_11744 = state_11661__$1;
(statearr_11678_11744[(1)] = (8));

} else {
var statearr_11679_11745 = state_11661__$1;
(statearr_11679_11745[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (14))){
var inst_11641 = (state_11661[(11)]);
var inst_11639 = (state_11661[(8)]);
var inst_11639__$1 = (state_11661[(2)]);
var inst_11640 = (inst_11639__$1 == null);
var inst_11641__$1 = cljs.core.not(inst_11640);
var state_11661__$1 = (function (){var statearr_11680 = state_11661;
(statearr_11680[(11)] = inst_11641__$1);

(statearr_11680[(8)] = inst_11639__$1);

return statearr_11680;
})();
if(inst_11641__$1){
var statearr_11681_11746 = state_11661__$1;
(statearr_11681_11746[(1)] = (15));

} else {
var statearr_11682_11747 = state_11661__$1;
(statearr_11682_11747[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (16))){
var inst_11641 = (state_11661[(11)]);
var state_11661__$1 = state_11661;
var statearr_11683_11748 = state_11661__$1;
(statearr_11683_11748[(2)] = inst_11641);

(statearr_11683_11748[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (10))){
var inst_11633 = (state_11661[(2)]);
var state_11661__$1 = state_11661;
var statearr_11684_11749 = state_11661__$1;
(statearr_11684_11749[(2)] = inst_11633);

(statearr_11684_11749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (18))){
var inst_11644 = (state_11661[(2)]);
var state_11661__$1 = state_11661;
var statearr_11685_11750 = state_11661__$1;
(statearr_11685_11750[(2)] = inst_11644);

(statearr_11685_11750[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11662 === (8))){
var inst_11630 = cljs.core.async.close_BANG_(to);
var state_11661__$1 = state_11661;
var statearr_11686_11751 = state_11661__$1;
(statearr_11686_11751[(2)] = inst_11630);

(statearr_11686_11751[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0 = (function (){
var statearr_11687 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11687[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__);

(statearr_11687[(1)] = (1));

return statearr_11687;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1 = (function (state_11661){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11661);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11688){var ex__11278__auto__ = e11688;
var statearr_11689_11752 = state_11661;
(statearr_11689_11752[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11661[(4)]))){
var statearr_11690_11753 = state_11661;
(statearr_11690_11753[(1)] = cljs.core.first((state_11661[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11754 = state_11661;
state_11661 = G__11754;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__ = function(state_11661){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1.call(this,state_11661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11275__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_11691 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11691[(6)] = c__11349__auto__);

return statearr_11691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));

return c__11349__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11756 = arguments.length;
switch (G__11756) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11759 = arguments.length;
switch (G__11759) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11762 = arguments.length;
switch (G__11762) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11349__auto___11812 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_11788){
var state_val_11789 = (state_11788[(1)]);
if((state_val_11789 === (7))){
var inst_11784 = (state_11788[(2)]);
var state_11788__$1 = state_11788;
var statearr_11790_11813 = state_11788__$1;
(statearr_11790_11813[(2)] = inst_11784);

(statearr_11790_11813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (1))){
var state_11788__$1 = state_11788;
var statearr_11791_11814 = state_11788__$1;
(statearr_11791_11814[(2)] = null);

(statearr_11791_11814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (4))){
var inst_11765 = (state_11788[(7)]);
var inst_11765__$1 = (state_11788[(2)]);
var inst_11766 = (inst_11765__$1 == null);
var state_11788__$1 = (function (){var statearr_11792 = state_11788;
(statearr_11792[(7)] = inst_11765__$1);

return statearr_11792;
})();
if(cljs.core.truth_(inst_11766)){
var statearr_11793_11815 = state_11788__$1;
(statearr_11793_11815[(1)] = (5));

} else {
var statearr_11794_11816 = state_11788__$1;
(statearr_11794_11816[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (13))){
var state_11788__$1 = state_11788;
var statearr_11795_11817 = state_11788__$1;
(statearr_11795_11817[(2)] = null);

(statearr_11795_11817[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (6))){
var inst_11765 = (state_11788[(7)]);
var inst_11771 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_11765) : p.call(null,inst_11765));
var state_11788__$1 = state_11788;
if(cljs.core.truth_(inst_11771)){
var statearr_11796_11818 = state_11788__$1;
(statearr_11796_11818[(1)] = (9));

} else {
var statearr_11797_11819 = state_11788__$1;
(statearr_11797_11819[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (3))){
var inst_11786 = (state_11788[(2)]);
var state_11788__$1 = state_11788;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11788__$1,inst_11786);
} else {
if((state_val_11789 === (12))){
var state_11788__$1 = state_11788;
var statearr_11798_11820 = state_11788__$1;
(statearr_11798_11820[(2)] = null);

(statearr_11798_11820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (2))){
var state_11788__$1 = state_11788;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11788__$1,(4),ch);
} else {
if((state_val_11789 === (11))){
var inst_11765 = (state_11788[(7)]);
var inst_11775 = (state_11788[(2)]);
var state_11788__$1 = state_11788;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11788__$1,(8),inst_11775,inst_11765);
} else {
if((state_val_11789 === (9))){
var state_11788__$1 = state_11788;
var statearr_11799_11821 = state_11788__$1;
(statearr_11799_11821[(2)] = tc);

(statearr_11799_11821[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (5))){
var inst_11768 = cljs.core.async.close_BANG_(tc);
var inst_11769 = cljs.core.async.close_BANG_(fc);
var state_11788__$1 = (function (){var statearr_11800 = state_11788;
(statearr_11800[(8)] = inst_11768);

return statearr_11800;
})();
var statearr_11801_11822 = state_11788__$1;
(statearr_11801_11822[(2)] = inst_11769);

(statearr_11801_11822[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (14))){
var inst_11782 = (state_11788[(2)]);
var state_11788__$1 = state_11788;
var statearr_11802_11823 = state_11788__$1;
(statearr_11802_11823[(2)] = inst_11782);

(statearr_11802_11823[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (10))){
var state_11788__$1 = state_11788;
var statearr_11803_11824 = state_11788__$1;
(statearr_11803_11824[(2)] = fc);

(statearr_11803_11824[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11789 === (8))){
var inst_11777 = (state_11788[(2)]);
var state_11788__$1 = state_11788;
if(cljs.core.truth_(inst_11777)){
var statearr_11804_11825 = state_11788__$1;
(statearr_11804_11825[(1)] = (12));

} else {
var statearr_11805_11826 = state_11788__$1;
(statearr_11805_11826[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_11806 = [null,null,null,null,null,null,null,null,null];
(statearr_11806[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_11806[(1)] = (1));

return statearr_11806;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_11788){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11788);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11807){var ex__11278__auto__ = e11807;
var statearr_11808_11827 = state_11788;
(statearr_11808_11827[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11788[(4)]))){
var statearr_11809_11828 = state_11788;
(statearr_11809_11828[(1)] = cljs.core.first((state_11788[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11829 = state_11788;
state_11788 = G__11829;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_11788){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_11788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_11810 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11810[(6)] = c__11349__auto___11812);

return statearr_11810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11349__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_11851){
var state_val_11852 = (state_11851[(1)]);
if((state_val_11852 === (7))){
var inst_11847 = (state_11851[(2)]);
var state_11851__$1 = state_11851;
var statearr_11853_11872 = state_11851__$1;
(statearr_11853_11872[(2)] = inst_11847);

(statearr_11853_11872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11852 === (1))){
var inst_11830 = init;
var inst_11831 = inst_11830;
var state_11851__$1 = (function (){var statearr_11854 = state_11851;
(statearr_11854[(7)] = inst_11831);

return statearr_11854;
})();
var statearr_11855_11873 = state_11851__$1;
(statearr_11855_11873[(2)] = null);

(statearr_11855_11873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11852 === (4))){
var inst_11834 = (state_11851[(8)]);
var inst_11834__$1 = (state_11851[(2)]);
var inst_11835 = (inst_11834__$1 == null);
var state_11851__$1 = (function (){var statearr_11856 = state_11851;
(statearr_11856[(8)] = inst_11834__$1);

return statearr_11856;
})();
if(cljs.core.truth_(inst_11835)){
var statearr_11857_11874 = state_11851__$1;
(statearr_11857_11874[(1)] = (5));

} else {
var statearr_11858_11875 = state_11851__$1;
(statearr_11858_11875[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11852 === (6))){
var inst_11834 = (state_11851[(8)]);
var inst_11831 = (state_11851[(7)]);
var inst_11838 = (state_11851[(9)]);
var inst_11838__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_11831,inst_11834) : f.call(null,inst_11831,inst_11834));
var inst_11839 = cljs.core.reduced_QMARK_(inst_11838__$1);
var state_11851__$1 = (function (){var statearr_11859 = state_11851;
(statearr_11859[(9)] = inst_11838__$1);

return statearr_11859;
})();
if(inst_11839){
var statearr_11860_11876 = state_11851__$1;
(statearr_11860_11876[(1)] = (8));

} else {
var statearr_11861_11877 = state_11851__$1;
(statearr_11861_11877[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11852 === (3))){
var inst_11849 = (state_11851[(2)]);
var state_11851__$1 = state_11851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11851__$1,inst_11849);
} else {
if((state_val_11852 === (2))){
var state_11851__$1 = state_11851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11851__$1,(4),ch);
} else {
if((state_val_11852 === (9))){
var inst_11838 = (state_11851[(9)]);
var inst_11831 = inst_11838;
var state_11851__$1 = (function (){var statearr_11862 = state_11851;
(statearr_11862[(7)] = inst_11831);

return statearr_11862;
})();
var statearr_11863_11878 = state_11851__$1;
(statearr_11863_11878[(2)] = null);

(statearr_11863_11878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11852 === (5))){
var inst_11831 = (state_11851[(7)]);
var state_11851__$1 = state_11851;
var statearr_11864_11879 = state_11851__$1;
(statearr_11864_11879[(2)] = inst_11831);

(statearr_11864_11879[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11852 === (10))){
var inst_11845 = (state_11851[(2)]);
var state_11851__$1 = state_11851;
var statearr_11865_11880 = state_11851__$1;
(statearr_11865_11880[(2)] = inst_11845);

(statearr_11865_11880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11852 === (8))){
var inst_11838 = (state_11851[(9)]);
var inst_11841 = cljs.core.deref(inst_11838);
var state_11851__$1 = state_11851;
var statearr_11866_11881 = state_11851__$1;
(statearr_11866_11881[(2)] = inst_11841);

(statearr_11866_11881[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__11275__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11275__auto____0 = (function (){
var statearr_11867 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11867[(0)] = cljs$core$async$reduce_$_state_machine__11275__auto__);

(statearr_11867[(1)] = (1));

return statearr_11867;
});
var cljs$core$async$reduce_$_state_machine__11275__auto____1 = (function (state_11851){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11851);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11868){var ex__11278__auto__ = e11868;
var statearr_11869_11882 = state_11851;
(statearr_11869_11882[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11851[(4)]))){
var statearr_11870_11883 = state_11851;
(statearr_11870_11883[(1)] = cljs.core.first((state_11851[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11884 = state_11851;
state_11851 = G__11884;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11275__auto__ = function(state_11851){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11275__auto____1.call(this,state_11851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11275__auto____0;
cljs$core$async$reduce_$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11275__auto____1;
return cljs$core$async$reduce_$_state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_11871 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11871[(6)] = c__11349__auto__);

return statearr_11871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));

return c__11349__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__11349__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_11890){
var state_val_11891 = (state_11890[(1)]);
if((state_val_11891 === (1))){
var inst_11885 = cljs.core.async.reduce(f__$1,init,ch);
var state_11890__$1 = state_11890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11890__$1,(2),inst_11885);
} else {
if((state_val_11891 === (2))){
var inst_11887 = (state_11890[(2)]);
var inst_11888 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_11887) : f__$1.call(null,inst_11887));
var state_11890__$1 = state_11890;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11890__$1,inst_11888);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__11275__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11275__auto____0 = (function (){
var statearr_11892 = [null,null,null,null,null,null,null];
(statearr_11892[(0)] = cljs$core$async$transduce_$_state_machine__11275__auto__);

(statearr_11892[(1)] = (1));

return statearr_11892;
});
var cljs$core$async$transduce_$_state_machine__11275__auto____1 = (function (state_11890){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11890);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11893){var ex__11278__auto__ = e11893;
var statearr_11894_11897 = state_11890;
(statearr_11894_11897[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11890[(4)]))){
var statearr_11895_11898 = state_11890;
(statearr_11895_11898[(1)] = cljs.core.first((state_11890[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11899 = state_11890;
state_11890 = G__11899;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11275__auto__ = function(state_11890){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11275__auto____1.call(this,state_11890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11275__auto____0;
cljs$core$async$transduce_$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11275__auto____1;
return cljs$core$async$transduce_$_state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_11896 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11896[(6)] = c__11349__auto__);

return statearr_11896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));

return c__11349__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__11901 = arguments.length;
switch (G__11901) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11349__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_11926){
var state_val_11927 = (state_11926[(1)]);
if((state_val_11927 === (7))){
var inst_11908 = (state_11926[(2)]);
var state_11926__$1 = state_11926;
var statearr_11928_11950 = state_11926__$1;
(statearr_11928_11950[(2)] = inst_11908);

(statearr_11928_11950[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (1))){
var inst_11902 = cljs.core.seq(coll);
var inst_11903 = inst_11902;
var state_11926__$1 = (function (){var statearr_11929 = state_11926;
(statearr_11929[(7)] = inst_11903);

return statearr_11929;
})();
var statearr_11930_11951 = state_11926__$1;
(statearr_11930_11951[(2)] = null);

(statearr_11930_11951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (4))){
var inst_11903 = (state_11926[(7)]);
var inst_11906 = cljs.core.first(inst_11903);
var state_11926__$1 = state_11926;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11926__$1,(7),ch,inst_11906);
} else {
if((state_val_11927 === (13))){
var inst_11920 = (state_11926[(2)]);
var state_11926__$1 = state_11926;
var statearr_11931_11952 = state_11926__$1;
(statearr_11931_11952[(2)] = inst_11920);

(statearr_11931_11952[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (6))){
var inst_11911 = (state_11926[(2)]);
var state_11926__$1 = state_11926;
if(cljs.core.truth_(inst_11911)){
var statearr_11932_11953 = state_11926__$1;
(statearr_11932_11953[(1)] = (8));

} else {
var statearr_11933_11954 = state_11926__$1;
(statearr_11933_11954[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (3))){
var inst_11924 = (state_11926[(2)]);
var state_11926__$1 = state_11926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11926__$1,inst_11924);
} else {
if((state_val_11927 === (12))){
var state_11926__$1 = state_11926;
var statearr_11934_11955 = state_11926__$1;
(statearr_11934_11955[(2)] = null);

(statearr_11934_11955[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (2))){
var inst_11903 = (state_11926[(7)]);
var state_11926__$1 = state_11926;
if(cljs.core.truth_(inst_11903)){
var statearr_11935_11956 = state_11926__$1;
(statearr_11935_11956[(1)] = (4));

} else {
var statearr_11936_11957 = state_11926__$1;
(statearr_11936_11957[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (11))){
var inst_11917 = cljs.core.async.close_BANG_(ch);
var state_11926__$1 = state_11926;
var statearr_11937_11958 = state_11926__$1;
(statearr_11937_11958[(2)] = inst_11917);

(statearr_11937_11958[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (9))){
var state_11926__$1 = state_11926;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11938_11959 = state_11926__$1;
(statearr_11938_11959[(1)] = (11));

} else {
var statearr_11939_11960 = state_11926__$1;
(statearr_11939_11960[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (5))){
var inst_11903 = (state_11926[(7)]);
var state_11926__$1 = state_11926;
var statearr_11940_11961 = state_11926__$1;
(statearr_11940_11961[(2)] = inst_11903);

(statearr_11940_11961[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (10))){
var inst_11922 = (state_11926[(2)]);
var state_11926__$1 = state_11926;
var statearr_11941_11962 = state_11926__$1;
(statearr_11941_11962[(2)] = inst_11922);

(statearr_11941_11962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11927 === (8))){
var inst_11903 = (state_11926[(7)]);
var inst_11913 = cljs.core.next(inst_11903);
var inst_11903__$1 = inst_11913;
var state_11926__$1 = (function (){var statearr_11942 = state_11926;
(statearr_11942[(7)] = inst_11903__$1);

return statearr_11942;
})();
var statearr_11943_11963 = state_11926__$1;
(statearr_11943_11963[(2)] = null);

(statearr_11943_11963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_11944 = [null,null,null,null,null,null,null,null];
(statearr_11944[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_11944[(1)] = (1));

return statearr_11944;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_11926){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_11926);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e11945){var ex__11278__auto__ = e11945;
var statearr_11946_11964 = state_11926;
(statearr_11946_11964[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_11926[(4)]))){
var statearr_11947_11965 = state_11926;
(statearr_11947_11965[(1)] = cljs.core.first((state_11926[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11966 = state_11926;
state_11926 = G__11966;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_11926){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_11926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_11948 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_11948[(6)] = c__11349__auto__);

return statearr_11948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));

return c__11349__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__11968 = arguments.length;
switch (G__11968) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_11970 = (function (_){
var x__4521__auto__ = (((_ == null))?null:_);
var m__4522__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4522__auto__.call(null,_));
} else {
var m__4519__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4519__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_11970(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_11971 = (function (m,ch,close_QMARK_){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4522__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4519__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_11971(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_11972 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_11972(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_11973 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_11973(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11974 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11974 = (function (ch,cs,meta11975){
this.ch = ch;
this.cs = cs;
this.meta11975 = meta11975;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11974.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11976,meta11975__$1){
var self__ = this;
var _11976__$1 = this;
return (new cljs.core.async.t_cljs$core$async11974(self__.ch,self__.cs,meta11975__$1));
}));

(cljs.core.async.t_cljs$core$async11974.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11976){
var self__ = this;
var _11976__$1 = this;
return self__.meta11975;
}));

(cljs.core.async.t_cljs$core$async11974.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11974.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async11974.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11974.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async11974.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async11974.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async11974.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11975","meta11975",-831782704,null)], null);
}));

(cljs.core.async.t_cljs$core$async11974.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11974.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11974");

(cljs.core.async.t_cljs$core$async11974.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async11974");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11974.
 */
cljs.core.async.__GT_t_cljs$core$async11974 = (function cljs$core$async$mult_$___GT_t_cljs$core$async11974(ch__$1,cs__$1,meta11975){
return (new cljs.core.async.t_cljs$core$async11974(ch__$1,cs__$1,meta11975));
});

}

return (new cljs.core.async.t_cljs$core$async11974(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__11349__auto___12193 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_12109){
var state_val_12110 = (state_12109[(1)]);
if((state_val_12110 === (7))){
var inst_12105 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
var statearr_12111_12194 = state_12109__$1;
(statearr_12111_12194[(2)] = inst_12105);

(statearr_12111_12194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (20))){
var inst_12010 = (state_12109[(7)]);
var inst_12022 = cljs.core.first(inst_12010);
var inst_12023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12022,(0),null);
var inst_12024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12022,(1),null);
var state_12109__$1 = (function (){var statearr_12112 = state_12109;
(statearr_12112[(8)] = inst_12023);

return statearr_12112;
})();
if(cljs.core.truth_(inst_12024)){
var statearr_12113_12195 = state_12109__$1;
(statearr_12113_12195[(1)] = (22));

} else {
var statearr_12114_12196 = state_12109__$1;
(statearr_12114_12196[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (27))){
var inst_11979 = (state_12109[(9)]);
var inst_12054 = (state_12109[(10)]);
var inst_12059 = (state_12109[(11)]);
var inst_12052 = (state_12109[(12)]);
var inst_12059__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12052,inst_12054);
var inst_12060 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12059__$1,inst_11979,done);
var state_12109__$1 = (function (){var statearr_12115 = state_12109;
(statearr_12115[(11)] = inst_12059__$1);

return statearr_12115;
})();
if(cljs.core.truth_(inst_12060)){
var statearr_12116_12197 = state_12109__$1;
(statearr_12116_12197[(1)] = (30));

} else {
var statearr_12117_12198 = state_12109__$1;
(statearr_12117_12198[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (1))){
var state_12109__$1 = state_12109;
var statearr_12118_12199 = state_12109__$1;
(statearr_12118_12199[(2)] = null);

(statearr_12118_12199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (24))){
var inst_12010 = (state_12109[(7)]);
var inst_12029 = (state_12109[(2)]);
var inst_12030 = cljs.core.next(inst_12010);
var inst_11988 = inst_12030;
var inst_11989 = null;
var inst_11990 = (0);
var inst_11991 = (0);
var state_12109__$1 = (function (){var statearr_12119 = state_12109;
(statearr_12119[(13)] = inst_11991);

(statearr_12119[(14)] = inst_11989);

(statearr_12119[(15)] = inst_11990);

(statearr_12119[(16)] = inst_11988);

(statearr_12119[(17)] = inst_12029);

return statearr_12119;
})();
var statearr_12120_12200 = state_12109__$1;
(statearr_12120_12200[(2)] = null);

(statearr_12120_12200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (39))){
var state_12109__$1 = state_12109;
var statearr_12124_12201 = state_12109__$1;
(statearr_12124_12201[(2)] = null);

(statearr_12124_12201[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (4))){
var inst_11979 = (state_12109[(9)]);
var inst_11979__$1 = (state_12109[(2)]);
var inst_11980 = (inst_11979__$1 == null);
var state_12109__$1 = (function (){var statearr_12125 = state_12109;
(statearr_12125[(9)] = inst_11979__$1);

return statearr_12125;
})();
if(cljs.core.truth_(inst_11980)){
var statearr_12126_12202 = state_12109__$1;
(statearr_12126_12202[(1)] = (5));

} else {
var statearr_12127_12203 = state_12109__$1;
(statearr_12127_12203[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (15))){
var inst_11991 = (state_12109[(13)]);
var inst_11989 = (state_12109[(14)]);
var inst_11990 = (state_12109[(15)]);
var inst_11988 = (state_12109[(16)]);
var inst_12006 = (state_12109[(2)]);
var inst_12007 = (inst_11991 + (1));
var tmp12121 = inst_11989;
var tmp12122 = inst_11990;
var tmp12123 = inst_11988;
var inst_11988__$1 = tmp12123;
var inst_11989__$1 = tmp12121;
var inst_11990__$1 = tmp12122;
var inst_11991__$1 = inst_12007;
var state_12109__$1 = (function (){var statearr_12128 = state_12109;
(statearr_12128[(13)] = inst_11991__$1);

(statearr_12128[(18)] = inst_12006);

(statearr_12128[(14)] = inst_11989__$1);

(statearr_12128[(15)] = inst_11990__$1);

(statearr_12128[(16)] = inst_11988__$1);

return statearr_12128;
})();
var statearr_12129_12204 = state_12109__$1;
(statearr_12129_12204[(2)] = null);

(statearr_12129_12204[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (21))){
var inst_12033 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
var statearr_12133_12205 = state_12109__$1;
(statearr_12133_12205[(2)] = inst_12033);

(statearr_12133_12205[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (31))){
var inst_12059 = (state_12109[(11)]);
var inst_12063 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12059);
var state_12109__$1 = state_12109;
var statearr_12134_12206 = state_12109__$1;
(statearr_12134_12206[(2)] = inst_12063);

(statearr_12134_12206[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (32))){
var inst_12053 = (state_12109[(19)]);
var inst_12054 = (state_12109[(10)]);
var inst_12052 = (state_12109[(12)]);
var inst_12051 = (state_12109[(20)]);
var inst_12065 = (state_12109[(2)]);
var inst_12066 = (inst_12054 + (1));
var tmp12130 = inst_12053;
var tmp12131 = inst_12052;
var tmp12132 = inst_12051;
var inst_12051__$1 = tmp12132;
var inst_12052__$1 = tmp12131;
var inst_12053__$1 = tmp12130;
var inst_12054__$1 = inst_12066;
var state_12109__$1 = (function (){var statearr_12135 = state_12109;
(statearr_12135[(19)] = inst_12053__$1);

(statearr_12135[(10)] = inst_12054__$1);

(statearr_12135[(21)] = inst_12065);

(statearr_12135[(12)] = inst_12052__$1);

(statearr_12135[(20)] = inst_12051__$1);

return statearr_12135;
})();
var statearr_12136_12207 = state_12109__$1;
(statearr_12136_12207[(2)] = null);

(statearr_12136_12207[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (40))){
var inst_12078 = (state_12109[(22)]);
var inst_12082 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12078);
var state_12109__$1 = state_12109;
var statearr_12137_12208 = state_12109__$1;
(statearr_12137_12208[(2)] = inst_12082);

(statearr_12137_12208[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (33))){
var inst_12069 = (state_12109[(23)]);
var inst_12071 = cljs.core.chunked_seq_QMARK_(inst_12069);
var state_12109__$1 = state_12109;
if(inst_12071){
var statearr_12138_12209 = state_12109__$1;
(statearr_12138_12209[(1)] = (36));

} else {
var statearr_12139_12210 = state_12109__$1;
(statearr_12139_12210[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (13))){
var inst_12000 = (state_12109[(24)]);
var inst_12003 = cljs.core.async.close_BANG_(inst_12000);
var state_12109__$1 = state_12109;
var statearr_12140_12211 = state_12109__$1;
(statearr_12140_12211[(2)] = inst_12003);

(statearr_12140_12211[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (22))){
var inst_12023 = (state_12109[(8)]);
var inst_12026 = cljs.core.async.close_BANG_(inst_12023);
var state_12109__$1 = state_12109;
var statearr_12141_12212 = state_12109__$1;
(statearr_12141_12212[(2)] = inst_12026);

(statearr_12141_12212[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (36))){
var inst_12069 = (state_12109[(23)]);
var inst_12073 = cljs.core.chunk_first(inst_12069);
var inst_12074 = cljs.core.chunk_rest(inst_12069);
var inst_12075 = cljs.core.count(inst_12073);
var inst_12051 = inst_12074;
var inst_12052 = inst_12073;
var inst_12053 = inst_12075;
var inst_12054 = (0);
var state_12109__$1 = (function (){var statearr_12142 = state_12109;
(statearr_12142[(19)] = inst_12053);

(statearr_12142[(10)] = inst_12054);

(statearr_12142[(12)] = inst_12052);

(statearr_12142[(20)] = inst_12051);

return statearr_12142;
})();
var statearr_12143_12213 = state_12109__$1;
(statearr_12143_12213[(2)] = null);

(statearr_12143_12213[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (41))){
var inst_12069 = (state_12109[(23)]);
var inst_12084 = (state_12109[(2)]);
var inst_12085 = cljs.core.next(inst_12069);
var inst_12051 = inst_12085;
var inst_12052 = null;
var inst_12053 = (0);
var inst_12054 = (0);
var state_12109__$1 = (function (){var statearr_12144 = state_12109;
(statearr_12144[(19)] = inst_12053);

(statearr_12144[(10)] = inst_12054);

(statearr_12144[(25)] = inst_12084);

(statearr_12144[(12)] = inst_12052);

(statearr_12144[(20)] = inst_12051);

return statearr_12144;
})();
var statearr_12145_12214 = state_12109__$1;
(statearr_12145_12214[(2)] = null);

(statearr_12145_12214[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (43))){
var state_12109__$1 = state_12109;
var statearr_12146_12215 = state_12109__$1;
(statearr_12146_12215[(2)] = null);

(statearr_12146_12215[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (29))){
var inst_12093 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
var statearr_12147_12216 = state_12109__$1;
(statearr_12147_12216[(2)] = inst_12093);

(statearr_12147_12216[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (44))){
var inst_12102 = (state_12109[(2)]);
var state_12109__$1 = (function (){var statearr_12148 = state_12109;
(statearr_12148[(26)] = inst_12102);

return statearr_12148;
})();
var statearr_12149_12217 = state_12109__$1;
(statearr_12149_12217[(2)] = null);

(statearr_12149_12217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (6))){
var inst_12043 = (state_12109[(27)]);
var inst_12042 = cljs.core.deref(cs);
var inst_12043__$1 = cljs.core.keys(inst_12042);
var inst_12044 = cljs.core.count(inst_12043__$1);
var inst_12045 = cljs.core.reset_BANG_(dctr,inst_12044);
var inst_12050 = cljs.core.seq(inst_12043__$1);
var inst_12051 = inst_12050;
var inst_12052 = null;
var inst_12053 = (0);
var inst_12054 = (0);
var state_12109__$1 = (function (){var statearr_12150 = state_12109;
(statearr_12150[(27)] = inst_12043__$1);

(statearr_12150[(19)] = inst_12053);

(statearr_12150[(10)] = inst_12054);

(statearr_12150[(12)] = inst_12052);

(statearr_12150[(20)] = inst_12051);

(statearr_12150[(28)] = inst_12045);

return statearr_12150;
})();
var statearr_12151_12218 = state_12109__$1;
(statearr_12151_12218[(2)] = null);

(statearr_12151_12218[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (28))){
var inst_12051 = (state_12109[(20)]);
var inst_12069 = (state_12109[(23)]);
var inst_12069__$1 = cljs.core.seq(inst_12051);
var state_12109__$1 = (function (){var statearr_12152 = state_12109;
(statearr_12152[(23)] = inst_12069__$1);

return statearr_12152;
})();
if(inst_12069__$1){
var statearr_12153_12219 = state_12109__$1;
(statearr_12153_12219[(1)] = (33));

} else {
var statearr_12154_12220 = state_12109__$1;
(statearr_12154_12220[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (25))){
var inst_12053 = (state_12109[(19)]);
var inst_12054 = (state_12109[(10)]);
var inst_12056 = (inst_12054 < inst_12053);
var inst_12057 = inst_12056;
var state_12109__$1 = state_12109;
if(cljs.core.truth_(inst_12057)){
var statearr_12155_12221 = state_12109__$1;
(statearr_12155_12221[(1)] = (27));

} else {
var statearr_12156_12222 = state_12109__$1;
(statearr_12156_12222[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (34))){
var state_12109__$1 = state_12109;
var statearr_12157_12223 = state_12109__$1;
(statearr_12157_12223[(2)] = null);

(statearr_12157_12223[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (17))){
var state_12109__$1 = state_12109;
var statearr_12158_12224 = state_12109__$1;
(statearr_12158_12224[(2)] = null);

(statearr_12158_12224[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (3))){
var inst_12107 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12109__$1,inst_12107);
} else {
if((state_val_12110 === (12))){
var inst_12038 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
var statearr_12159_12225 = state_12109__$1;
(statearr_12159_12225[(2)] = inst_12038);

(statearr_12159_12225[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (2))){
var state_12109__$1 = state_12109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12109__$1,(4),ch);
} else {
if((state_val_12110 === (23))){
var state_12109__$1 = state_12109;
var statearr_12160_12226 = state_12109__$1;
(statearr_12160_12226[(2)] = null);

(statearr_12160_12226[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (35))){
var inst_12091 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
var statearr_12161_12227 = state_12109__$1;
(statearr_12161_12227[(2)] = inst_12091);

(statearr_12161_12227[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (19))){
var inst_12010 = (state_12109[(7)]);
var inst_12014 = cljs.core.chunk_first(inst_12010);
var inst_12015 = cljs.core.chunk_rest(inst_12010);
var inst_12016 = cljs.core.count(inst_12014);
var inst_11988 = inst_12015;
var inst_11989 = inst_12014;
var inst_11990 = inst_12016;
var inst_11991 = (0);
var state_12109__$1 = (function (){var statearr_12162 = state_12109;
(statearr_12162[(13)] = inst_11991);

(statearr_12162[(14)] = inst_11989);

(statearr_12162[(15)] = inst_11990);

(statearr_12162[(16)] = inst_11988);

return statearr_12162;
})();
var statearr_12163_12228 = state_12109__$1;
(statearr_12163_12228[(2)] = null);

(statearr_12163_12228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (11))){
var inst_12010 = (state_12109[(7)]);
var inst_11988 = (state_12109[(16)]);
var inst_12010__$1 = cljs.core.seq(inst_11988);
var state_12109__$1 = (function (){var statearr_12164 = state_12109;
(statearr_12164[(7)] = inst_12010__$1);

return statearr_12164;
})();
if(inst_12010__$1){
var statearr_12165_12229 = state_12109__$1;
(statearr_12165_12229[(1)] = (16));

} else {
var statearr_12166_12230 = state_12109__$1;
(statearr_12166_12230[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (9))){
var inst_12040 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
var statearr_12167_12231 = state_12109__$1;
(statearr_12167_12231[(2)] = inst_12040);

(statearr_12167_12231[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (5))){
var inst_11986 = cljs.core.deref(cs);
var inst_11987 = cljs.core.seq(inst_11986);
var inst_11988 = inst_11987;
var inst_11989 = null;
var inst_11990 = (0);
var inst_11991 = (0);
var state_12109__$1 = (function (){var statearr_12168 = state_12109;
(statearr_12168[(13)] = inst_11991);

(statearr_12168[(14)] = inst_11989);

(statearr_12168[(15)] = inst_11990);

(statearr_12168[(16)] = inst_11988);

return statearr_12168;
})();
var statearr_12169_12232 = state_12109__$1;
(statearr_12169_12232[(2)] = null);

(statearr_12169_12232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (14))){
var state_12109__$1 = state_12109;
var statearr_12170_12233 = state_12109__$1;
(statearr_12170_12233[(2)] = null);

(statearr_12170_12233[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (45))){
var inst_12099 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
var statearr_12171_12234 = state_12109__$1;
(statearr_12171_12234[(2)] = inst_12099);

(statearr_12171_12234[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (26))){
var inst_12043 = (state_12109[(27)]);
var inst_12095 = (state_12109[(2)]);
var inst_12096 = cljs.core.seq(inst_12043);
var state_12109__$1 = (function (){var statearr_12172 = state_12109;
(statearr_12172[(29)] = inst_12095);

return statearr_12172;
})();
if(inst_12096){
var statearr_12173_12235 = state_12109__$1;
(statearr_12173_12235[(1)] = (42));

} else {
var statearr_12174_12236 = state_12109__$1;
(statearr_12174_12236[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (16))){
var inst_12010 = (state_12109[(7)]);
var inst_12012 = cljs.core.chunked_seq_QMARK_(inst_12010);
var state_12109__$1 = state_12109;
if(inst_12012){
var statearr_12175_12237 = state_12109__$1;
(statearr_12175_12237[(1)] = (19));

} else {
var statearr_12176_12238 = state_12109__$1;
(statearr_12176_12238[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (38))){
var inst_12088 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
var statearr_12177_12239 = state_12109__$1;
(statearr_12177_12239[(2)] = inst_12088);

(statearr_12177_12239[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (30))){
var state_12109__$1 = state_12109;
var statearr_12178_12240 = state_12109__$1;
(statearr_12178_12240[(2)] = null);

(statearr_12178_12240[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (10))){
var inst_11991 = (state_12109[(13)]);
var inst_11989 = (state_12109[(14)]);
var inst_11999 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_11989,inst_11991);
var inst_12000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_11999,(0),null);
var inst_12001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_11999,(1),null);
var state_12109__$1 = (function (){var statearr_12179 = state_12109;
(statearr_12179[(24)] = inst_12000);

return statearr_12179;
})();
if(cljs.core.truth_(inst_12001)){
var statearr_12180_12241 = state_12109__$1;
(statearr_12180_12241[(1)] = (13));

} else {
var statearr_12181_12242 = state_12109__$1;
(statearr_12181_12242[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (18))){
var inst_12036 = (state_12109[(2)]);
var state_12109__$1 = state_12109;
var statearr_12182_12243 = state_12109__$1;
(statearr_12182_12243[(2)] = inst_12036);

(statearr_12182_12243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (42))){
var state_12109__$1 = state_12109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12109__$1,(45),dchan);
} else {
if((state_val_12110 === (37))){
var inst_11979 = (state_12109[(9)]);
var inst_12069 = (state_12109[(23)]);
var inst_12078 = (state_12109[(22)]);
var inst_12078__$1 = cljs.core.first(inst_12069);
var inst_12079 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12078__$1,inst_11979,done);
var state_12109__$1 = (function (){var statearr_12183 = state_12109;
(statearr_12183[(22)] = inst_12078__$1);

return statearr_12183;
})();
if(cljs.core.truth_(inst_12079)){
var statearr_12184_12244 = state_12109__$1;
(statearr_12184_12244[(1)] = (39));

} else {
var statearr_12185_12245 = state_12109__$1;
(statearr_12185_12245[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12110 === (8))){
var inst_11991 = (state_12109[(13)]);
var inst_11990 = (state_12109[(15)]);
var inst_11993 = (inst_11991 < inst_11990);
var inst_11994 = inst_11993;
var state_12109__$1 = state_12109;
if(cljs.core.truth_(inst_11994)){
var statearr_12186_12246 = state_12109__$1;
(statearr_12186_12246[(1)] = (10));

} else {
var statearr_12187_12247 = state_12109__$1;
(statearr_12187_12247[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__11275__auto__ = null;
var cljs$core$async$mult_$_state_machine__11275__auto____0 = (function (){
var statearr_12188 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12188[(0)] = cljs$core$async$mult_$_state_machine__11275__auto__);

(statearr_12188[(1)] = (1));

return statearr_12188;
});
var cljs$core$async$mult_$_state_machine__11275__auto____1 = (function (state_12109){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_12109);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e12189){var ex__11278__auto__ = e12189;
var statearr_12190_12248 = state_12109;
(statearr_12190_12248[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_12109[(4)]))){
var statearr_12191_12249 = state_12109;
(statearr_12191_12249[(1)] = cljs.core.first((state_12109[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12250 = state_12109;
state_12109 = G__12250;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11275__auto__ = function(state_12109){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11275__auto____1.call(this,state_12109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11275__auto____0;
cljs$core$async$mult_$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11275__auto____1;
return cljs$core$async$mult_$_state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_12192 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_12192[(6)] = c__11349__auto___12193);

return statearr_12192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__12252 = arguments.length;
switch (G__12252) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_12254 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_12254(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_12255 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_12255(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_12256 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_12256(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_12257 = (function (m,state_map){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4522__auto__.call(null,m,state_map));
} else {
var m__4519__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4519__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_12257(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_12258 = (function (m,mode){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4522__auto__.call(null,m,mode));
} else {
var m__4519__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4519__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_12258(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___12268 = arguments.length;
var i__4830__auto___12269 = (0);
while(true){
if((i__4830__auto___12269 < len__4829__auto___12268)){
args__4835__auto__.push((arguments[i__4830__auto___12269]));

var G__12270 = (i__4830__auto___12269 + (1));
i__4830__auto___12269 = G__12270;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((3) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4836__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12263){
var map__12264 = p__12263;
var map__12264__$1 = cljs.core.__destructure_map(map__12264);
var opts = map__12264__$1;
var statearr_12265_12271 = state;
(statearr_12265_12271[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_12266_12272 = state;
(statearr_12266_12272[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_12267_12273 = state;
(statearr_12267_12273[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12259){
var G__12260 = cljs.core.first(seq12259);
var seq12259__$1 = cljs.core.next(seq12259);
var G__12261 = cljs.core.first(seq12259__$1);
var seq12259__$2 = cljs.core.next(seq12259__$1);
var G__12262 = cljs.core.first(seq12259__$2);
var seq12259__$3 = cljs.core.next(seq12259__$2);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12260,G__12261,G__12262,seq12259__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12274 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12274 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12275){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12275 = meta12275;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12276,meta12275__$1){
var self__ = this;
var _12276__$1 = this;
return (new cljs.core.async.t_cljs$core$async12274(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12275__$1));
}));

(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12276){
var self__ = this;
var _12276__$1 = this;
return self__.meta12275;
}));

(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12274.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12274.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12275","meta12275",1156800299,null)], null);
}));

(cljs.core.async.t_cljs$core$async12274.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12274.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12274");

(cljs.core.async.t_cljs$core$async12274.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async12274");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12274.
 */
cljs.core.async.__GT_t_cljs$core$async12274 = (function cljs$core$async$mix_$___GT_t_cljs$core$async12274(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12275){
return (new cljs.core.async.t_cljs$core$async12274(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12275));
});

}

return (new cljs.core.async.t_cljs$core$async12274(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11349__auto___12389 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_12344){
var state_val_12345 = (state_12344[(1)]);
if((state_val_12345 === (7))){
var inst_12304 = (state_12344[(2)]);
var state_12344__$1 = state_12344;
if(cljs.core.truth_(inst_12304)){
var statearr_12346_12390 = state_12344__$1;
(statearr_12346_12390[(1)] = (8));

} else {
var statearr_12347_12391 = state_12344__$1;
(statearr_12347_12391[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (20))){
var inst_12297 = (state_12344[(7)]);
var state_12344__$1 = state_12344;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12344__$1,(23),out,inst_12297);
} else {
if((state_val_12345 === (1))){
var inst_12280 = calc_state();
var inst_12281 = cljs.core.__destructure_map(inst_12280);
var inst_12282 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12281,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12283 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12281,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12284 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12281,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12285 = inst_12280;
var state_12344__$1 = (function (){var statearr_12348 = state_12344;
(statearr_12348[(8)] = inst_12285);

(statearr_12348[(9)] = inst_12282);

(statearr_12348[(10)] = inst_12283);

(statearr_12348[(11)] = inst_12284);

return statearr_12348;
})();
var statearr_12349_12392 = state_12344__$1;
(statearr_12349_12392[(2)] = null);

(statearr_12349_12392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (24))){
var inst_12288 = (state_12344[(12)]);
var inst_12285 = inst_12288;
var state_12344__$1 = (function (){var statearr_12350 = state_12344;
(statearr_12350[(8)] = inst_12285);

return statearr_12350;
})();
var statearr_12351_12393 = state_12344__$1;
(statearr_12351_12393[(2)] = null);

(statearr_12351_12393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (4))){
var inst_12299 = (state_12344[(13)]);
var inst_12297 = (state_12344[(7)]);
var inst_12296 = (state_12344[(2)]);
var inst_12297__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12296,(0),null);
var inst_12298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12296,(1),null);
var inst_12299__$1 = (inst_12297__$1 == null);
var state_12344__$1 = (function (){var statearr_12352 = state_12344;
(statearr_12352[(13)] = inst_12299__$1);

(statearr_12352[(14)] = inst_12298);

(statearr_12352[(7)] = inst_12297__$1);

return statearr_12352;
})();
if(cljs.core.truth_(inst_12299__$1)){
var statearr_12353_12394 = state_12344__$1;
(statearr_12353_12394[(1)] = (5));

} else {
var statearr_12354_12395 = state_12344__$1;
(statearr_12354_12395[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (15))){
var inst_12289 = (state_12344[(15)]);
var inst_12318 = (state_12344[(16)]);
var inst_12318__$1 = cljs.core.empty_QMARK_(inst_12289);
var state_12344__$1 = (function (){var statearr_12355 = state_12344;
(statearr_12355[(16)] = inst_12318__$1);

return statearr_12355;
})();
if(inst_12318__$1){
var statearr_12356_12396 = state_12344__$1;
(statearr_12356_12396[(1)] = (17));

} else {
var statearr_12357_12397 = state_12344__$1;
(statearr_12357_12397[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (21))){
var inst_12288 = (state_12344[(12)]);
var inst_12285 = inst_12288;
var state_12344__$1 = (function (){var statearr_12358 = state_12344;
(statearr_12358[(8)] = inst_12285);

return statearr_12358;
})();
var statearr_12359_12398 = state_12344__$1;
(statearr_12359_12398[(2)] = null);

(statearr_12359_12398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (13))){
var inst_12311 = (state_12344[(2)]);
var inst_12312 = calc_state();
var inst_12285 = inst_12312;
var state_12344__$1 = (function (){var statearr_12360 = state_12344;
(statearr_12360[(17)] = inst_12311);

(statearr_12360[(8)] = inst_12285);

return statearr_12360;
})();
var statearr_12361_12399 = state_12344__$1;
(statearr_12361_12399[(2)] = null);

(statearr_12361_12399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (22))){
var inst_12338 = (state_12344[(2)]);
var state_12344__$1 = state_12344;
var statearr_12362_12400 = state_12344__$1;
(statearr_12362_12400[(2)] = inst_12338);

(statearr_12362_12400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (6))){
var inst_12298 = (state_12344[(14)]);
var inst_12302 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_12298,change);
var state_12344__$1 = state_12344;
var statearr_12363_12401 = state_12344__$1;
(statearr_12363_12401[(2)] = inst_12302);

(statearr_12363_12401[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (25))){
var state_12344__$1 = state_12344;
var statearr_12364_12402 = state_12344__$1;
(statearr_12364_12402[(2)] = null);

(statearr_12364_12402[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (17))){
var inst_12290 = (state_12344[(18)]);
var inst_12298 = (state_12344[(14)]);
var inst_12320 = (inst_12290.cljs$core$IFn$_invoke$arity$1 ? inst_12290.cljs$core$IFn$_invoke$arity$1(inst_12298) : inst_12290.call(null,inst_12298));
var inst_12321 = cljs.core.not(inst_12320);
var state_12344__$1 = state_12344;
var statearr_12365_12403 = state_12344__$1;
(statearr_12365_12403[(2)] = inst_12321);

(statearr_12365_12403[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (3))){
var inst_12342 = (state_12344[(2)]);
var state_12344__$1 = state_12344;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12344__$1,inst_12342);
} else {
if((state_val_12345 === (12))){
var state_12344__$1 = state_12344;
var statearr_12366_12404 = state_12344__$1;
(statearr_12366_12404[(2)] = null);

(statearr_12366_12404[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (2))){
var inst_12288 = (state_12344[(12)]);
var inst_12285 = (state_12344[(8)]);
var inst_12288__$1 = cljs.core.__destructure_map(inst_12285);
var inst_12289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12288__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12290 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12288__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12291 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12288__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12344__$1 = (function (){var statearr_12367 = state_12344;
(statearr_12367[(12)] = inst_12288__$1);

(statearr_12367[(15)] = inst_12289);

(statearr_12367[(18)] = inst_12290);

return statearr_12367;
})();
return cljs.core.async.ioc_alts_BANG_(state_12344__$1,(4),inst_12291);
} else {
if((state_val_12345 === (23))){
var inst_12329 = (state_12344[(2)]);
var state_12344__$1 = state_12344;
if(cljs.core.truth_(inst_12329)){
var statearr_12368_12405 = state_12344__$1;
(statearr_12368_12405[(1)] = (24));

} else {
var statearr_12369_12406 = state_12344__$1;
(statearr_12369_12406[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (19))){
var inst_12324 = (state_12344[(2)]);
var state_12344__$1 = state_12344;
var statearr_12370_12407 = state_12344__$1;
(statearr_12370_12407[(2)] = inst_12324);

(statearr_12370_12407[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (11))){
var inst_12298 = (state_12344[(14)]);
var inst_12308 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_12298);
var state_12344__$1 = state_12344;
var statearr_12371_12408 = state_12344__$1;
(statearr_12371_12408[(2)] = inst_12308);

(statearr_12371_12408[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (9))){
var inst_12289 = (state_12344[(15)]);
var inst_12298 = (state_12344[(14)]);
var inst_12315 = (state_12344[(19)]);
var inst_12315__$1 = (inst_12289.cljs$core$IFn$_invoke$arity$1 ? inst_12289.cljs$core$IFn$_invoke$arity$1(inst_12298) : inst_12289.call(null,inst_12298));
var state_12344__$1 = (function (){var statearr_12372 = state_12344;
(statearr_12372[(19)] = inst_12315__$1);

return statearr_12372;
})();
if(cljs.core.truth_(inst_12315__$1)){
var statearr_12373_12409 = state_12344__$1;
(statearr_12373_12409[(1)] = (14));

} else {
var statearr_12374_12410 = state_12344__$1;
(statearr_12374_12410[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (5))){
var inst_12299 = (state_12344[(13)]);
var state_12344__$1 = state_12344;
var statearr_12375_12411 = state_12344__$1;
(statearr_12375_12411[(2)] = inst_12299);

(statearr_12375_12411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (14))){
var inst_12315 = (state_12344[(19)]);
var state_12344__$1 = state_12344;
var statearr_12376_12412 = state_12344__$1;
(statearr_12376_12412[(2)] = inst_12315);

(statearr_12376_12412[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (26))){
var inst_12334 = (state_12344[(2)]);
var state_12344__$1 = state_12344;
var statearr_12377_12413 = state_12344__$1;
(statearr_12377_12413[(2)] = inst_12334);

(statearr_12377_12413[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (16))){
var inst_12326 = (state_12344[(2)]);
var state_12344__$1 = state_12344;
if(cljs.core.truth_(inst_12326)){
var statearr_12378_12414 = state_12344__$1;
(statearr_12378_12414[(1)] = (20));

} else {
var statearr_12379_12415 = state_12344__$1;
(statearr_12379_12415[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (10))){
var inst_12340 = (state_12344[(2)]);
var state_12344__$1 = state_12344;
var statearr_12380_12416 = state_12344__$1;
(statearr_12380_12416[(2)] = inst_12340);

(statearr_12380_12416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (18))){
var inst_12318 = (state_12344[(16)]);
var state_12344__$1 = state_12344;
var statearr_12381_12417 = state_12344__$1;
(statearr_12381_12417[(2)] = inst_12318);

(statearr_12381_12417[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12345 === (8))){
var inst_12297 = (state_12344[(7)]);
var inst_12306 = (inst_12297 == null);
var state_12344__$1 = state_12344;
if(cljs.core.truth_(inst_12306)){
var statearr_12382_12418 = state_12344__$1;
(statearr_12382_12418[(1)] = (11));

} else {
var statearr_12383_12419 = state_12344__$1;
(statearr_12383_12419[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__11275__auto__ = null;
var cljs$core$async$mix_$_state_machine__11275__auto____0 = (function (){
var statearr_12384 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12384[(0)] = cljs$core$async$mix_$_state_machine__11275__auto__);

(statearr_12384[(1)] = (1));

return statearr_12384;
});
var cljs$core$async$mix_$_state_machine__11275__auto____1 = (function (state_12344){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_12344);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e12385){var ex__11278__auto__ = e12385;
var statearr_12386_12420 = state_12344;
(statearr_12386_12420[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_12344[(4)]))){
var statearr_12387_12421 = state_12344;
(statearr_12387_12421[(1)] = cljs.core.first((state_12344[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12422 = state_12344;
state_12344 = G__12422;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11275__auto__ = function(state_12344){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11275__auto____1.call(this,state_12344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11275__auto____0;
cljs$core$async$mix_$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11275__auto____1;
return cljs$core$async$mix_$_state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_12388 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_12388[(6)] = c__11349__auto___12389);

return statearr_12388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12425 = (function (p,v,ch,close_QMARK_){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4522__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4519__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12425(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12426 = (function (p,v,ch){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4522__auto__.call(null,p,v,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4519__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12426(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12427 = (function() {
var G__12428 = null;
var G__12428__1 = (function (p){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4522__auto__.call(null,p));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4519__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__12428__2 = (function (p,v){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4522__auto__.call(null,p,v));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4519__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__12428 = function(p,v){
switch(arguments.length){
case 1:
return G__12428__1.call(this,p);
case 2:
return G__12428__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12428.cljs$core$IFn$_invoke$arity$1 = G__12428__1;
G__12428.cljs$core$IFn$_invoke$arity$2 = G__12428__2;
return G__12428;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12424 = arguments.length;
switch (G__12424) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12427.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12427.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12432 = arguments.length;
switch (G__12432) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__12430_SHARP_){
if(cljs.core.truth_((p1__12430_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__12430_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__12430_SHARP_.call(null,topic)))){
return p1__12430_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__12430_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12433 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12433 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12434){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12434 = meta12434;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12433.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12435,meta12434__$1){
var self__ = this;
var _12435__$1 = this;
return (new cljs.core.async.t_cljs$core$async12433(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12434__$1));
}));

(cljs.core.async.t_cljs$core$async12433.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12435){
var self__ = this;
var _12435__$1 = this;
return self__.meta12434;
}));

(cljs.core.async.t_cljs$core$async12433.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12433.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12433.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12433.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12433.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12433.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12433.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12433.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12434","meta12434",-1781382906,null)], null);
}));

(cljs.core.async.t_cljs$core$async12433.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12433.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12433");

(cljs.core.async.t_cljs$core$async12433.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async12433");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12433.
 */
cljs.core.async.__GT_t_cljs$core$async12433 = (function cljs$core$async$__GT_t_cljs$core$async12433(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12434){
return (new cljs.core.async.t_cljs$core$async12433(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12434));
});

}

return (new cljs.core.async.t_cljs$core$async12433(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11349__auto___12554 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_12507){
var state_val_12508 = (state_12507[(1)]);
if((state_val_12508 === (7))){
var inst_12503 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12509_12555 = state_12507__$1;
(statearr_12509_12555[(2)] = inst_12503);

(statearr_12509_12555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (20))){
var state_12507__$1 = state_12507;
var statearr_12510_12556 = state_12507__$1;
(statearr_12510_12556[(2)] = null);

(statearr_12510_12556[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (1))){
var state_12507__$1 = state_12507;
var statearr_12511_12557 = state_12507__$1;
(statearr_12511_12557[(2)] = null);

(statearr_12511_12557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (24))){
var inst_12486 = (state_12507[(7)]);
var inst_12495 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_12486);
var state_12507__$1 = state_12507;
var statearr_12512_12558 = state_12507__$1;
(statearr_12512_12558[(2)] = inst_12495);

(statearr_12512_12558[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (4))){
var inst_12438 = (state_12507[(8)]);
var inst_12438__$1 = (state_12507[(2)]);
var inst_12439 = (inst_12438__$1 == null);
var state_12507__$1 = (function (){var statearr_12513 = state_12507;
(statearr_12513[(8)] = inst_12438__$1);

return statearr_12513;
})();
if(cljs.core.truth_(inst_12439)){
var statearr_12514_12559 = state_12507__$1;
(statearr_12514_12559[(1)] = (5));

} else {
var statearr_12515_12560 = state_12507__$1;
(statearr_12515_12560[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (15))){
var inst_12480 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12516_12561 = state_12507__$1;
(statearr_12516_12561[(2)] = inst_12480);

(statearr_12516_12561[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (21))){
var inst_12500 = (state_12507[(2)]);
var state_12507__$1 = (function (){var statearr_12517 = state_12507;
(statearr_12517[(9)] = inst_12500);

return statearr_12517;
})();
var statearr_12518_12562 = state_12507__$1;
(statearr_12518_12562[(2)] = null);

(statearr_12518_12562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (13))){
var inst_12462 = (state_12507[(10)]);
var inst_12464 = cljs.core.chunked_seq_QMARK_(inst_12462);
var state_12507__$1 = state_12507;
if(inst_12464){
var statearr_12519_12563 = state_12507__$1;
(statearr_12519_12563[(1)] = (16));

} else {
var statearr_12520_12564 = state_12507__$1;
(statearr_12520_12564[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (22))){
var inst_12492 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
if(cljs.core.truth_(inst_12492)){
var statearr_12521_12565 = state_12507__$1;
(statearr_12521_12565[(1)] = (23));

} else {
var statearr_12522_12566 = state_12507__$1;
(statearr_12522_12566[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (6))){
var inst_12488 = (state_12507[(11)]);
var inst_12438 = (state_12507[(8)]);
var inst_12486 = (state_12507[(7)]);
var inst_12486__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_12438) : topic_fn.call(null,inst_12438));
var inst_12487 = cljs.core.deref(mults);
var inst_12488__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12487,inst_12486__$1);
var state_12507__$1 = (function (){var statearr_12523 = state_12507;
(statearr_12523[(11)] = inst_12488__$1);

(statearr_12523[(7)] = inst_12486__$1);

return statearr_12523;
})();
if(cljs.core.truth_(inst_12488__$1)){
var statearr_12524_12567 = state_12507__$1;
(statearr_12524_12567[(1)] = (19));

} else {
var statearr_12525_12568 = state_12507__$1;
(statearr_12525_12568[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (25))){
var inst_12497 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12526_12569 = state_12507__$1;
(statearr_12526_12569[(2)] = inst_12497);

(statearr_12526_12569[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (17))){
var inst_12462 = (state_12507[(10)]);
var inst_12471 = cljs.core.first(inst_12462);
var inst_12472 = cljs.core.async.muxch_STAR_(inst_12471);
var inst_12473 = cljs.core.async.close_BANG_(inst_12472);
var inst_12474 = cljs.core.next(inst_12462);
var inst_12448 = inst_12474;
var inst_12449 = null;
var inst_12450 = (0);
var inst_12451 = (0);
var state_12507__$1 = (function (){var statearr_12527 = state_12507;
(statearr_12527[(12)] = inst_12451);

(statearr_12527[(13)] = inst_12449);

(statearr_12527[(14)] = inst_12450);

(statearr_12527[(15)] = inst_12473);

(statearr_12527[(16)] = inst_12448);

return statearr_12527;
})();
var statearr_12528_12570 = state_12507__$1;
(statearr_12528_12570[(2)] = null);

(statearr_12528_12570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (3))){
var inst_12505 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12507__$1,inst_12505);
} else {
if((state_val_12508 === (12))){
var inst_12482 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12529_12571 = state_12507__$1;
(statearr_12529_12571[(2)] = inst_12482);

(statearr_12529_12571[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (2))){
var state_12507__$1 = state_12507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12507__$1,(4),ch);
} else {
if((state_val_12508 === (23))){
var state_12507__$1 = state_12507;
var statearr_12530_12572 = state_12507__$1;
(statearr_12530_12572[(2)] = null);

(statearr_12530_12572[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (19))){
var inst_12488 = (state_12507[(11)]);
var inst_12438 = (state_12507[(8)]);
var inst_12490 = cljs.core.async.muxch_STAR_(inst_12488);
var state_12507__$1 = state_12507;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12507__$1,(22),inst_12490,inst_12438);
} else {
if((state_val_12508 === (11))){
var inst_12462 = (state_12507[(10)]);
var inst_12448 = (state_12507[(16)]);
var inst_12462__$1 = cljs.core.seq(inst_12448);
var state_12507__$1 = (function (){var statearr_12531 = state_12507;
(statearr_12531[(10)] = inst_12462__$1);

return statearr_12531;
})();
if(inst_12462__$1){
var statearr_12532_12573 = state_12507__$1;
(statearr_12532_12573[(1)] = (13));

} else {
var statearr_12533_12574 = state_12507__$1;
(statearr_12533_12574[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (9))){
var inst_12484 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12534_12575 = state_12507__$1;
(statearr_12534_12575[(2)] = inst_12484);

(statearr_12534_12575[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (5))){
var inst_12445 = cljs.core.deref(mults);
var inst_12446 = cljs.core.vals(inst_12445);
var inst_12447 = cljs.core.seq(inst_12446);
var inst_12448 = inst_12447;
var inst_12449 = null;
var inst_12450 = (0);
var inst_12451 = (0);
var state_12507__$1 = (function (){var statearr_12535 = state_12507;
(statearr_12535[(12)] = inst_12451);

(statearr_12535[(13)] = inst_12449);

(statearr_12535[(14)] = inst_12450);

(statearr_12535[(16)] = inst_12448);

return statearr_12535;
})();
var statearr_12536_12576 = state_12507__$1;
(statearr_12536_12576[(2)] = null);

(statearr_12536_12576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (14))){
var state_12507__$1 = state_12507;
var statearr_12540_12577 = state_12507__$1;
(statearr_12540_12577[(2)] = null);

(statearr_12540_12577[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (16))){
var inst_12462 = (state_12507[(10)]);
var inst_12466 = cljs.core.chunk_first(inst_12462);
var inst_12467 = cljs.core.chunk_rest(inst_12462);
var inst_12468 = cljs.core.count(inst_12466);
var inst_12448 = inst_12467;
var inst_12449 = inst_12466;
var inst_12450 = inst_12468;
var inst_12451 = (0);
var state_12507__$1 = (function (){var statearr_12541 = state_12507;
(statearr_12541[(12)] = inst_12451);

(statearr_12541[(13)] = inst_12449);

(statearr_12541[(14)] = inst_12450);

(statearr_12541[(16)] = inst_12448);

return statearr_12541;
})();
var statearr_12542_12578 = state_12507__$1;
(statearr_12542_12578[(2)] = null);

(statearr_12542_12578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (10))){
var inst_12451 = (state_12507[(12)]);
var inst_12449 = (state_12507[(13)]);
var inst_12450 = (state_12507[(14)]);
var inst_12448 = (state_12507[(16)]);
var inst_12456 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12449,inst_12451);
var inst_12457 = cljs.core.async.muxch_STAR_(inst_12456);
var inst_12458 = cljs.core.async.close_BANG_(inst_12457);
var inst_12459 = (inst_12451 + (1));
var tmp12537 = inst_12449;
var tmp12538 = inst_12450;
var tmp12539 = inst_12448;
var inst_12448__$1 = tmp12539;
var inst_12449__$1 = tmp12537;
var inst_12450__$1 = tmp12538;
var inst_12451__$1 = inst_12459;
var state_12507__$1 = (function (){var statearr_12543 = state_12507;
(statearr_12543[(12)] = inst_12451__$1);

(statearr_12543[(13)] = inst_12449__$1);

(statearr_12543[(14)] = inst_12450__$1);

(statearr_12543[(17)] = inst_12458);

(statearr_12543[(16)] = inst_12448__$1);

return statearr_12543;
})();
var statearr_12544_12579 = state_12507__$1;
(statearr_12544_12579[(2)] = null);

(statearr_12544_12579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (18))){
var inst_12477 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12545_12580 = state_12507__$1;
(statearr_12545_12580[(2)] = inst_12477);

(statearr_12545_12580[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (8))){
var inst_12451 = (state_12507[(12)]);
var inst_12450 = (state_12507[(14)]);
var inst_12453 = (inst_12451 < inst_12450);
var inst_12454 = inst_12453;
var state_12507__$1 = state_12507;
if(cljs.core.truth_(inst_12454)){
var statearr_12546_12581 = state_12507__$1;
(statearr_12546_12581[(1)] = (10));

} else {
var statearr_12547_12582 = state_12507__$1;
(statearr_12547_12582[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_12548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12548[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_12548[(1)] = (1));

return statearr_12548;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_12507){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_12507);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e12549){var ex__11278__auto__ = e12549;
var statearr_12550_12583 = state_12507;
(statearr_12550_12583[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_12507[(4)]))){
var statearr_12551_12584 = state_12507;
(statearr_12551_12584[(1)] = cljs.core.first((state_12507[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12585 = state_12507;
state_12507 = G__12585;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_12507){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_12507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_12552 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_12552[(6)] = c__11349__auto___12554);

return statearr_12552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12587 = arguments.length;
switch (G__12587) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12590 = arguments.length;
switch (G__12590) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12593 = arguments.length;
switch (G__12593) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__11349__auto___12671 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_12636){
var state_val_12637 = (state_12636[(1)]);
if((state_val_12637 === (7))){
var state_12636__$1 = state_12636;
var statearr_12638_12672 = state_12636__$1;
(statearr_12638_12672[(2)] = null);

(statearr_12638_12672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (1))){
var state_12636__$1 = state_12636;
var statearr_12639_12673 = state_12636__$1;
(statearr_12639_12673[(2)] = null);

(statearr_12639_12673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (4))){
var inst_12597 = (state_12636[(7)]);
var inst_12596 = (state_12636[(8)]);
var inst_12599 = (inst_12597 < inst_12596);
var state_12636__$1 = state_12636;
if(cljs.core.truth_(inst_12599)){
var statearr_12640_12674 = state_12636__$1;
(statearr_12640_12674[(1)] = (6));

} else {
var statearr_12641_12675 = state_12636__$1;
(statearr_12641_12675[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (15))){
var inst_12622 = (state_12636[(9)]);
var inst_12627 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_12622);
var state_12636__$1 = state_12636;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12636__$1,(17),out,inst_12627);
} else {
if((state_val_12637 === (13))){
var inst_12622 = (state_12636[(9)]);
var inst_12622__$1 = (state_12636[(2)]);
var inst_12623 = cljs.core.some(cljs.core.nil_QMARK_,inst_12622__$1);
var state_12636__$1 = (function (){var statearr_12642 = state_12636;
(statearr_12642[(9)] = inst_12622__$1);

return statearr_12642;
})();
if(cljs.core.truth_(inst_12623)){
var statearr_12643_12676 = state_12636__$1;
(statearr_12643_12676[(1)] = (14));

} else {
var statearr_12644_12677 = state_12636__$1;
(statearr_12644_12677[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (6))){
var state_12636__$1 = state_12636;
var statearr_12645_12678 = state_12636__$1;
(statearr_12645_12678[(2)] = null);

(statearr_12645_12678[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (17))){
var inst_12629 = (state_12636[(2)]);
var state_12636__$1 = (function (){var statearr_12647 = state_12636;
(statearr_12647[(10)] = inst_12629);

return statearr_12647;
})();
var statearr_12648_12679 = state_12636__$1;
(statearr_12648_12679[(2)] = null);

(statearr_12648_12679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (3))){
var inst_12634 = (state_12636[(2)]);
var state_12636__$1 = state_12636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12636__$1,inst_12634);
} else {
if((state_val_12637 === (12))){
var _ = (function (){var statearr_12649 = state_12636;
(statearr_12649[(4)] = cljs.core.rest((state_12636[(4)])));

return statearr_12649;
})();
var state_12636__$1 = state_12636;
var ex12646 = (state_12636__$1[(2)]);
var statearr_12650_12680 = state_12636__$1;
(statearr_12650_12680[(5)] = ex12646);


if((ex12646 instanceof Object)){
var statearr_12651_12681 = state_12636__$1;
(statearr_12651_12681[(1)] = (11));

(statearr_12651_12681[(5)] = null);

} else {
throw ex12646;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (2))){
var inst_12595 = cljs.core.reset_BANG_(dctr,cnt);
var inst_12596 = cnt;
var inst_12597 = (0);
var state_12636__$1 = (function (){var statearr_12652 = state_12636;
(statearr_12652[(7)] = inst_12597);

(statearr_12652[(11)] = inst_12595);

(statearr_12652[(8)] = inst_12596);

return statearr_12652;
})();
var statearr_12653_12682 = state_12636__$1;
(statearr_12653_12682[(2)] = null);

(statearr_12653_12682[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (11))){
var inst_12601 = (state_12636[(2)]);
var inst_12602 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_12636__$1 = (function (){var statearr_12654 = state_12636;
(statearr_12654[(12)] = inst_12601);

return statearr_12654;
})();
var statearr_12655_12683 = state_12636__$1;
(statearr_12655_12683[(2)] = inst_12602);

(statearr_12655_12683[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (9))){
var inst_12597 = (state_12636[(7)]);
var _ = (function (){var statearr_12656 = state_12636;
(statearr_12656[(4)] = cljs.core.cons((12),(state_12636[(4)])));

return statearr_12656;
})();
var inst_12608 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_12597) : chs__$1.call(null,inst_12597));
var inst_12609 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_12597) : done.call(null,inst_12597));
var inst_12610 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_12608,inst_12609);
var ___$1 = (function (){var statearr_12657 = state_12636;
(statearr_12657[(4)] = cljs.core.rest((state_12636[(4)])));

return statearr_12657;
})();
var state_12636__$1 = state_12636;
var statearr_12658_12684 = state_12636__$1;
(statearr_12658_12684[(2)] = inst_12610);

(statearr_12658_12684[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (5))){
var inst_12620 = (state_12636[(2)]);
var state_12636__$1 = (function (){var statearr_12659 = state_12636;
(statearr_12659[(13)] = inst_12620);

return statearr_12659;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12636__$1,(13),dchan);
} else {
if((state_val_12637 === (14))){
var inst_12625 = cljs.core.async.close_BANG_(out);
var state_12636__$1 = state_12636;
var statearr_12660_12685 = state_12636__$1;
(statearr_12660_12685[(2)] = inst_12625);

(statearr_12660_12685[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (16))){
var inst_12632 = (state_12636[(2)]);
var state_12636__$1 = state_12636;
var statearr_12661_12686 = state_12636__$1;
(statearr_12661_12686[(2)] = inst_12632);

(statearr_12661_12686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (10))){
var inst_12597 = (state_12636[(7)]);
var inst_12613 = (state_12636[(2)]);
var inst_12614 = (inst_12597 + (1));
var inst_12597__$1 = inst_12614;
var state_12636__$1 = (function (){var statearr_12662 = state_12636;
(statearr_12662[(14)] = inst_12613);

(statearr_12662[(7)] = inst_12597__$1);

return statearr_12662;
})();
var statearr_12663_12687 = state_12636__$1;
(statearr_12663_12687[(2)] = null);

(statearr_12663_12687[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12637 === (8))){
var inst_12618 = (state_12636[(2)]);
var state_12636__$1 = state_12636;
var statearr_12664_12688 = state_12636__$1;
(statearr_12664_12688[(2)] = inst_12618);

(statearr_12664_12688[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_12665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12665[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_12665[(1)] = (1));

return statearr_12665;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_12636){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_12636);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e12666){var ex__11278__auto__ = e12666;
var statearr_12667_12689 = state_12636;
(statearr_12667_12689[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_12636[(4)]))){
var statearr_12668_12690 = state_12636;
(statearr_12668_12690[(1)] = cljs.core.first((state_12636[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12691 = state_12636;
state_12636 = G__12691;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_12636){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_12636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_12669 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_12669[(6)] = c__11349__auto___12671);

return statearr_12669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12694 = arguments.length;
switch (G__12694) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11349__auto___12749 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_12726){
var state_val_12727 = (state_12726[(1)]);
if((state_val_12727 === (7))){
var inst_12705 = (state_12726[(7)]);
var inst_12706 = (state_12726[(8)]);
var inst_12705__$1 = (state_12726[(2)]);
var inst_12706__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12705__$1,(0),null);
var inst_12707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12705__$1,(1),null);
var inst_12708 = (inst_12706__$1 == null);
var state_12726__$1 = (function (){var statearr_12728 = state_12726;
(statearr_12728[(9)] = inst_12707);

(statearr_12728[(7)] = inst_12705__$1);

(statearr_12728[(8)] = inst_12706__$1);

return statearr_12728;
})();
if(cljs.core.truth_(inst_12708)){
var statearr_12729_12750 = state_12726__$1;
(statearr_12729_12750[(1)] = (8));

} else {
var statearr_12730_12751 = state_12726__$1;
(statearr_12730_12751[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12727 === (1))){
var inst_12695 = cljs.core.vec(chs);
var inst_12696 = inst_12695;
var state_12726__$1 = (function (){var statearr_12731 = state_12726;
(statearr_12731[(10)] = inst_12696);

return statearr_12731;
})();
var statearr_12732_12752 = state_12726__$1;
(statearr_12732_12752[(2)] = null);

(statearr_12732_12752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12727 === (4))){
var inst_12696 = (state_12726[(10)]);
var state_12726__$1 = state_12726;
return cljs.core.async.ioc_alts_BANG_(state_12726__$1,(7),inst_12696);
} else {
if((state_val_12727 === (6))){
var inst_12722 = (state_12726[(2)]);
var state_12726__$1 = state_12726;
var statearr_12733_12753 = state_12726__$1;
(statearr_12733_12753[(2)] = inst_12722);

(statearr_12733_12753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12727 === (3))){
var inst_12724 = (state_12726[(2)]);
var state_12726__$1 = state_12726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12726__$1,inst_12724);
} else {
if((state_val_12727 === (2))){
var inst_12696 = (state_12726[(10)]);
var inst_12698 = cljs.core.count(inst_12696);
var inst_12699 = (inst_12698 > (0));
var state_12726__$1 = state_12726;
if(cljs.core.truth_(inst_12699)){
var statearr_12735_12754 = state_12726__$1;
(statearr_12735_12754[(1)] = (4));

} else {
var statearr_12736_12755 = state_12726__$1;
(statearr_12736_12755[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12727 === (11))){
var inst_12696 = (state_12726[(10)]);
var inst_12715 = (state_12726[(2)]);
var tmp12734 = inst_12696;
var inst_12696__$1 = tmp12734;
var state_12726__$1 = (function (){var statearr_12737 = state_12726;
(statearr_12737[(11)] = inst_12715);

(statearr_12737[(10)] = inst_12696__$1);

return statearr_12737;
})();
var statearr_12738_12756 = state_12726__$1;
(statearr_12738_12756[(2)] = null);

(statearr_12738_12756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12727 === (9))){
var inst_12706 = (state_12726[(8)]);
var state_12726__$1 = state_12726;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12726__$1,(11),out,inst_12706);
} else {
if((state_val_12727 === (5))){
var inst_12720 = cljs.core.async.close_BANG_(out);
var state_12726__$1 = state_12726;
var statearr_12739_12757 = state_12726__$1;
(statearr_12739_12757[(2)] = inst_12720);

(statearr_12739_12757[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12727 === (10))){
var inst_12718 = (state_12726[(2)]);
var state_12726__$1 = state_12726;
var statearr_12740_12758 = state_12726__$1;
(statearr_12740_12758[(2)] = inst_12718);

(statearr_12740_12758[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12727 === (8))){
var inst_12707 = (state_12726[(9)]);
var inst_12705 = (state_12726[(7)]);
var inst_12696 = (state_12726[(10)]);
var inst_12706 = (state_12726[(8)]);
var inst_12710 = (function (){var cs = inst_12696;
var vec__12701 = inst_12705;
var v = inst_12706;
var c = inst_12707;
return (function (p1__12692_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__12692_SHARP_);
});
})();
var inst_12711 = cljs.core.filterv(inst_12710,inst_12696);
var inst_12696__$1 = inst_12711;
var state_12726__$1 = (function (){var statearr_12741 = state_12726;
(statearr_12741[(10)] = inst_12696__$1);

return statearr_12741;
})();
var statearr_12742_12759 = state_12726__$1;
(statearr_12742_12759[(2)] = null);

(statearr_12742_12759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_12743 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12743[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_12743[(1)] = (1));

return statearr_12743;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_12726){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_12726);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e12744){var ex__11278__auto__ = e12744;
var statearr_12745_12760 = state_12726;
(statearr_12745_12760[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_12726[(4)]))){
var statearr_12746_12761 = state_12726;
(statearr_12746_12761[(1)] = cljs.core.first((state_12726[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12762 = state_12726;
state_12726 = G__12762;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_12726){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_12726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_12747 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_12747[(6)] = c__11349__auto___12749);

return statearr_12747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12764 = arguments.length;
switch (G__12764) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11349__auto___12810 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_12788){
var state_val_12789 = (state_12788[(1)]);
if((state_val_12789 === (7))){
var inst_12770 = (state_12788[(7)]);
var inst_12770__$1 = (state_12788[(2)]);
var inst_12771 = (inst_12770__$1 == null);
var inst_12772 = cljs.core.not(inst_12771);
var state_12788__$1 = (function (){var statearr_12790 = state_12788;
(statearr_12790[(7)] = inst_12770__$1);

return statearr_12790;
})();
if(inst_12772){
var statearr_12791_12811 = state_12788__$1;
(statearr_12791_12811[(1)] = (8));

} else {
var statearr_12792_12812 = state_12788__$1;
(statearr_12792_12812[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12789 === (1))){
var inst_12765 = (0);
var state_12788__$1 = (function (){var statearr_12793 = state_12788;
(statearr_12793[(8)] = inst_12765);

return statearr_12793;
})();
var statearr_12794_12813 = state_12788__$1;
(statearr_12794_12813[(2)] = null);

(statearr_12794_12813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12789 === (4))){
var state_12788__$1 = state_12788;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12788__$1,(7),ch);
} else {
if((state_val_12789 === (6))){
var inst_12783 = (state_12788[(2)]);
var state_12788__$1 = state_12788;
var statearr_12795_12814 = state_12788__$1;
(statearr_12795_12814[(2)] = inst_12783);

(statearr_12795_12814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12789 === (3))){
var inst_12785 = (state_12788[(2)]);
var inst_12786 = cljs.core.async.close_BANG_(out);
var state_12788__$1 = (function (){var statearr_12796 = state_12788;
(statearr_12796[(9)] = inst_12785);

return statearr_12796;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_12788__$1,inst_12786);
} else {
if((state_val_12789 === (2))){
var inst_12765 = (state_12788[(8)]);
var inst_12767 = (inst_12765 < n);
var state_12788__$1 = state_12788;
if(cljs.core.truth_(inst_12767)){
var statearr_12797_12815 = state_12788__$1;
(statearr_12797_12815[(1)] = (4));

} else {
var statearr_12798_12816 = state_12788__$1;
(statearr_12798_12816[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12789 === (11))){
var inst_12765 = (state_12788[(8)]);
var inst_12775 = (state_12788[(2)]);
var inst_12776 = (inst_12765 + (1));
var inst_12765__$1 = inst_12776;
var state_12788__$1 = (function (){var statearr_12799 = state_12788;
(statearr_12799[(8)] = inst_12765__$1);

(statearr_12799[(10)] = inst_12775);

return statearr_12799;
})();
var statearr_12800_12817 = state_12788__$1;
(statearr_12800_12817[(2)] = null);

(statearr_12800_12817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12789 === (9))){
var state_12788__$1 = state_12788;
var statearr_12801_12818 = state_12788__$1;
(statearr_12801_12818[(2)] = null);

(statearr_12801_12818[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12789 === (5))){
var state_12788__$1 = state_12788;
var statearr_12802_12819 = state_12788__$1;
(statearr_12802_12819[(2)] = null);

(statearr_12802_12819[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12789 === (10))){
var inst_12780 = (state_12788[(2)]);
var state_12788__$1 = state_12788;
var statearr_12803_12820 = state_12788__$1;
(statearr_12803_12820[(2)] = inst_12780);

(statearr_12803_12820[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12789 === (8))){
var inst_12770 = (state_12788[(7)]);
var state_12788__$1 = state_12788;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12788__$1,(11),out,inst_12770);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_12804 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12804[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_12804[(1)] = (1));

return statearr_12804;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_12788){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_12788);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e12805){var ex__11278__auto__ = e12805;
var statearr_12806_12821 = state_12788;
(statearr_12806_12821[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_12788[(4)]))){
var statearr_12807_12822 = state_12788;
(statearr_12807_12822[(1)] = cljs.core.first((state_12788[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12823 = state_12788;
state_12788 = G__12823;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_12788){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_12788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_12808 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_12808[(6)] = c__11349__auto___12810);

return statearr_12808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12825 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12825 = (function (f,ch,meta12826){
this.f = f;
this.ch = ch;
this.meta12826 = meta12826;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12825.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12827,meta12826__$1){
var self__ = this;
var _12827__$1 = this;
return (new cljs.core.async.t_cljs$core$async12825(self__.f,self__.ch,meta12826__$1));
}));

(cljs.core.async.t_cljs$core$async12825.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12827){
var self__ = this;
var _12827__$1 = this;
return self__.meta12826;
}));

(cljs.core.async.t_cljs$core$async12825.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12825.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12825.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12825.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12825.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12828 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12828 = (function (f,ch,meta12826,_,fn1,meta12829){
this.f = f;
this.ch = ch;
this.meta12826 = meta12826;
this._ = _;
this.fn1 = fn1;
this.meta12829 = meta12829;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12828.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12830,meta12829__$1){
var self__ = this;
var _12830__$1 = this;
return (new cljs.core.async.t_cljs$core$async12828(self__.f,self__.ch,self__.meta12826,self__._,self__.fn1,meta12829__$1));
}));

(cljs.core.async.t_cljs$core$async12828.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12830){
var self__ = this;
var _12830__$1 = this;
return self__.meta12829;
}));

(cljs.core.async.t_cljs$core$async12828.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12828.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async12828.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12828.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__12824_SHARP_){
var G__12831 = (((p1__12824_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__12824_SHARP_) : self__.f.call(null,p1__12824_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__12831) : f1.call(null,G__12831));
});
}));

(cljs.core.async.t_cljs$core$async12828.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12826","meta12826",-1215130290,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12825","cljs.core.async/t_cljs$core$async12825",-336882968,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12829","meta12829",-465074392,null)], null);
}));

(cljs.core.async.t_cljs$core$async12828.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12828.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12828");

(cljs.core.async.t_cljs$core$async12828.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async12828");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12828.
 */
cljs.core.async.__GT_t_cljs$core$async12828 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12828(f__$1,ch__$1,meta12826__$1,___$2,fn1__$1,meta12829){
return (new cljs.core.async.t_cljs$core$async12828(f__$1,ch__$1,meta12826__$1,___$2,fn1__$1,meta12829));
});

}

return (new cljs.core.async.t_cljs$core$async12828(self__.f,self__.ch,self__.meta12826,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4221__auto__ = ret;
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4221__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__12832 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__12832) : self__.f.call(null,G__12832));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async12825.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12825.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async12825.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12826","meta12826",-1215130290,null)], null);
}));

(cljs.core.async.t_cljs$core$async12825.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12825.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12825");

(cljs.core.async.t_cljs$core$async12825.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async12825");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12825.
 */
cljs.core.async.__GT_t_cljs$core$async12825 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12825(f__$1,ch__$1,meta12826){
return (new cljs.core.async.t_cljs$core$async12825(f__$1,ch__$1,meta12826));
});

}

return (new cljs.core.async.t_cljs$core$async12825(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12833 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12833 = (function (f,ch,meta12834){
this.f = f;
this.ch = ch;
this.meta12834 = meta12834;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12833.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12835,meta12834__$1){
var self__ = this;
var _12835__$1 = this;
return (new cljs.core.async.t_cljs$core$async12833(self__.f,self__.ch,meta12834__$1));
}));

(cljs.core.async.t_cljs$core$async12833.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12835){
var self__ = this;
var _12835__$1 = this;
return self__.meta12834;
}));

(cljs.core.async.t_cljs$core$async12833.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12833.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12833.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12833.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12833.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12833.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async12833.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12834","meta12834",451756111,null)], null);
}));

(cljs.core.async.t_cljs$core$async12833.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12833.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12833");

(cljs.core.async.t_cljs$core$async12833.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async12833");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12833.
 */
cljs.core.async.__GT_t_cljs$core$async12833 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12833(f__$1,ch__$1,meta12834){
return (new cljs.core.async.t_cljs$core$async12833(f__$1,ch__$1,meta12834));
});

}

return (new cljs.core.async.t_cljs$core$async12833(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12836 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12836 = (function (p,ch,meta12837){
this.p = p;
this.ch = ch;
this.meta12837 = meta12837;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12836.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12838,meta12837__$1){
var self__ = this;
var _12838__$1 = this;
return (new cljs.core.async.t_cljs$core$async12836(self__.p,self__.ch,meta12837__$1));
}));

(cljs.core.async.t_cljs$core$async12836.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12838){
var self__ = this;
var _12838__$1 = this;
return self__.meta12837;
}));

(cljs.core.async.t_cljs$core$async12836.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12836.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12836.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12836.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12836.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12836.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12836.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async12836.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12837","meta12837",1321934475,null)], null);
}));

(cljs.core.async.t_cljs$core$async12836.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12836.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12836");

(cljs.core.async.t_cljs$core$async12836.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async12836");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12836.
 */
cljs.core.async.__GT_t_cljs$core$async12836 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12836(p__$1,ch__$1,meta12837){
return (new cljs.core.async.t_cljs$core$async12836(p__$1,ch__$1,meta12837));
});

}

return (new cljs.core.async.t_cljs$core$async12836(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12840 = arguments.length;
switch (G__12840) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11349__auto___12881 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_12861){
var state_val_12862 = (state_12861[(1)]);
if((state_val_12862 === (7))){
var inst_12857 = (state_12861[(2)]);
var state_12861__$1 = state_12861;
var statearr_12863_12882 = state_12861__$1;
(statearr_12863_12882[(2)] = inst_12857);

(statearr_12863_12882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (1))){
var state_12861__$1 = state_12861;
var statearr_12864_12883 = state_12861__$1;
(statearr_12864_12883[(2)] = null);

(statearr_12864_12883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (4))){
var inst_12843 = (state_12861[(7)]);
var inst_12843__$1 = (state_12861[(2)]);
var inst_12844 = (inst_12843__$1 == null);
var state_12861__$1 = (function (){var statearr_12865 = state_12861;
(statearr_12865[(7)] = inst_12843__$1);

return statearr_12865;
})();
if(cljs.core.truth_(inst_12844)){
var statearr_12866_12884 = state_12861__$1;
(statearr_12866_12884[(1)] = (5));

} else {
var statearr_12867_12885 = state_12861__$1;
(statearr_12867_12885[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (6))){
var inst_12843 = (state_12861[(7)]);
var inst_12848 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_12843) : p.call(null,inst_12843));
var state_12861__$1 = state_12861;
if(cljs.core.truth_(inst_12848)){
var statearr_12868_12886 = state_12861__$1;
(statearr_12868_12886[(1)] = (8));

} else {
var statearr_12869_12887 = state_12861__$1;
(statearr_12869_12887[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (3))){
var inst_12859 = (state_12861[(2)]);
var state_12861__$1 = state_12861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12861__$1,inst_12859);
} else {
if((state_val_12862 === (2))){
var state_12861__$1 = state_12861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12861__$1,(4),ch);
} else {
if((state_val_12862 === (11))){
var inst_12851 = (state_12861[(2)]);
var state_12861__$1 = state_12861;
var statearr_12870_12888 = state_12861__$1;
(statearr_12870_12888[(2)] = inst_12851);

(statearr_12870_12888[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (9))){
var state_12861__$1 = state_12861;
var statearr_12871_12889 = state_12861__$1;
(statearr_12871_12889[(2)] = null);

(statearr_12871_12889[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (5))){
var inst_12846 = cljs.core.async.close_BANG_(out);
var state_12861__$1 = state_12861;
var statearr_12872_12890 = state_12861__$1;
(statearr_12872_12890[(2)] = inst_12846);

(statearr_12872_12890[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (10))){
var inst_12854 = (state_12861[(2)]);
var state_12861__$1 = (function (){var statearr_12873 = state_12861;
(statearr_12873[(8)] = inst_12854);

return statearr_12873;
})();
var statearr_12874_12891 = state_12861__$1;
(statearr_12874_12891[(2)] = null);

(statearr_12874_12891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (8))){
var inst_12843 = (state_12861[(7)]);
var state_12861__$1 = state_12861;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12861__$1,(11),out,inst_12843);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_12875 = [null,null,null,null,null,null,null,null,null];
(statearr_12875[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_12875[(1)] = (1));

return statearr_12875;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_12861){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_12861);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e12876){var ex__11278__auto__ = e12876;
var statearr_12877_12892 = state_12861;
(statearr_12877_12892[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_12861[(4)]))){
var statearr_12878_12893 = state_12861;
(statearr_12878_12893[(1)] = cljs.core.first((state_12861[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12894 = state_12861;
state_12861 = G__12894;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_12861){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_12861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_12879 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_12879[(6)] = c__11349__auto___12881);

return statearr_12879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__12896 = arguments.length;
switch (G__12896) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11349__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_12959){
var state_val_12960 = (state_12959[(1)]);
if((state_val_12960 === (7))){
var inst_12955 = (state_12959[(2)]);
var state_12959__$1 = state_12959;
var statearr_12961_13000 = state_12959__$1;
(statearr_12961_13000[(2)] = inst_12955);

(statearr_12961_13000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (20))){
var inst_12925 = (state_12959[(7)]);
var inst_12936 = (state_12959[(2)]);
var inst_12937 = cljs.core.next(inst_12925);
var inst_12911 = inst_12937;
var inst_12912 = null;
var inst_12913 = (0);
var inst_12914 = (0);
var state_12959__$1 = (function (){var statearr_12962 = state_12959;
(statearr_12962[(8)] = inst_12911);

(statearr_12962[(9)] = inst_12913);

(statearr_12962[(10)] = inst_12936);

(statearr_12962[(11)] = inst_12912);

(statearr_12962[(12)] = inst_12914);

return statearr_12962;
})();
var statearr_12963_13001 = state_12959__$1;
(statearr_12963_13001[(2)] = null);

(statearr_12963_13001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (1))){
var state_12959__$1 = state_12959;
var statearr_12964_13002 = state_12959__$1;
(statearr_12964_13002[(2)] = null);

(statearr_12964_13002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (4))){
var inst_12900 = (state_12959[(13)]);
var inst_12900__$1 = (state_12959[(2)]);
var inst_12901 = (inst_12900__$1 == null);
var state_12959__$1 = (function (){var statearr_12965 = state_12959;
(statearr_12965[(13)] = inst_12900__$1);

return statearr_12965;
})();
if(cljs.core.truth_(inst_12901)){
var statearr_12966_13003 = state_12959__$1;
(statearr_12966_13003[(1)] = (5));

} else {
var statearr_12967_13004 = state_12959__$1;
(statearr_12967_13004[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (15))){
var state_12959__$1 = state_12959;
var statearr_12971_13005 = state_12959__$1;
(statearr_12971_13005[(2)] = null);

(statearr_12971_13005[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (21))){
var state_12959__$1 = state_12959;
var statearr_12972_13006 = state_12959__$1;
(statearr_12972_13006[(2)] = null);

(statearr_12972_13006[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (13))){
var inst_12911 = (state_12959[(8)]);
var inst_12913 = (state_12959[(9)]);
var inst_12912 = (state_12959[(11)]);
var inst_12914 = (state_12959[(12)]);
var inst_12921 = (state_12959[(2)]);
var inst_12922 = (inst_12914 + (1));
var tmp12968 = inst_12911;
var tmp12969 = inst_12913;
var tmp12970 = inst_12912;
var inst_12911__$1 = tmp12968;
var inst_12912__$1 = tmp12970;
var inst_12913__$1 = tmp12969;
var inst_12914__$1 = inst_12922;
var state_12959__$1 = (function (){var statearr_12973 = state_12959;
(statearr_12973[(8)] = inst_12911__$1);

(statearr_12973[(9)] = inst_12913__$1);

(statearr_12973[(11)] = inst_12912__$1);

(statearr_12973[(14)] = inst_12921);

(statearr_12973[(12)] = inst_12914__$1);

return statearr_12973;
})();
var statearr_12974_13007 = state_12959__$1;
(statearr_12974_13007[(2)] = null);

(statearr_12974_13007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (22))){
var state_12959__$1 = state_12959;
var statearr_12975_13008 = state_12959__$1;
(statearr_12975_13008[(2)] = null);

(statearr_12975_13008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (6))){
var inst_12900 = (state_12959[(13)]);
var inst_12909 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_12900) : f.call(null,inst_12900));
var inst_12910 = cljs.core.seq(inst_12909);
var inst_12911 = inst_12910;
var inst_12912 = null;
var inst_12913 = (0);
var inst_12914 = (0);
var state_12959__$1 = (function (){var statearr_12976 = state_12959;
(statearr_12976[(8)] = inst_12911);

(statearr_12976[(9)] = inst_12913);

(statearr_12976[(11)] = inst_12912);

(statearr_12976[(12)] = inst_12914);

return statearr_12976;
})();
var statearr_12977_13009 = state_12959__$1;
(statearr_12977_13009[(2)] = null);

(statearr_12977_13009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (17))){
var inst_12925 = (state_12959[(7)]);
var inst_12929 = cljs.core.chunk_first(inst_12925);
var inst_12930 = cljs.core.chunk_rest(inst_12925);
var inst_12931 = cljs.core.count(inst_12929);
var inst_12911 = inst_12930;
var inst_12912 = inst_12929;
var inst_12913 = inst_12931;
var inst_12914 = (0);
var state_12959__$1 = (function (){var statearr_12978 = state_12959;
(statearr_12978[(8)] = inst_12911);

(statearr_12978[(9)] = inst_12913);

(statearr_12978[(11)] = inst_12912);

(statearr_12978[(12)] = inst_12914);

return statearr_12978;
})();
var statearr_12979_13010 = state_12959__$1;
(statearr_12979_13010[(2)] = null);

(statearr_12979_13010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (3))){
var inst_12957 = (state_12959[(2)]);
var state_12959__$1 = state_12959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12959__$1,inst_12957);
} else {
if((state_val_12960 === (12))){
var inst_12945 = (state_12959[(2)]);
var state_12959__$1 = state_12959;
var statearr_12980_13011 = state_12959__$1;
(statearr_12980_13011[(2)] = inst_12945);

(statearr_12980_13011[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (2))){
var state_12959__$1 = state_12959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12959__$1,(4),in$);
} else {
if((state_val_12960 === (23))){
var inst_12953 = (state_12959[(2)]);
var state_12959__$1 = state_12959;
var statearr_12981_13012 = state_12959__$1;
(statearr_12981_13012[(2)] = inst_12953);

(statearr_12981_13012[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (19))){
var inst_12940 = (state_12959[(2)]);
var state_12959__$1 = state_12959;
var statearr_12982_13013 = state_12959__$1;
(statearr_12982_13013[(2)] = inst_12940);

(statearr_12982_13013[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (11))){
var inst_12911 = (state_12959[(8)]);
var inst_12925 = (state_12959[(7)]);
var inst_12925__$1 = cljs.core.seq(inst_12911);
var state_12959__$1 = (function (){var statearr_12983 = state_12959;
(statearr_12983[(7)] = inst_12925__$1);

return statearr_12983;
})();
if(inst_12925__$1){
var statearr_12984_13014 = state_12959__$1;
(statearr_12984_13014[(1)] = (14));

} else {
var statearr_12985_13015 = state_12959__$1;
(statearr_12985_13015[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (9))){
var inst_12947 = (state_12959[(2)]);
var inst_12948 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_12959__$1 = (function (){var statearr_12986 = state_12959;
(statearr_12986[(15)] = inst_12947);

return statearr_12986;
})();
if(cljs.core.truth_(inst_12948)){
var statearr_12987_13016 = state_12959__$1;
(statearr_12987_13016[(1)] = (21));

} else {
var statearr_12988_13017 = state_12959__$1;
(statearr_12988_13017[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (5))){
var inst_12903 = cljs.core.async.close_BANG_(out);
var state_12959__$1 = state_12959;
var statearr_12989_13018 = state_12959__$1;
(statearr_12989_13018[(2)] = inst_12903);

(statearr_12989_13018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (14))){
var inst_12925 = (state_12959[(7)]);
var inst_12927 = cljs.core.chunked_seq_QMARK_(inst_12925);
var state_12959__$1 = state_12959;
if(inst_12927){
var statearr_12990_13019 = state_12959__$1;
(statearr_12990_13019[(1)] = (17));

} else {
var statearr_12991_13020 = state_12959__$1;
(statearr_12991_13020[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (16))){
var inst_12943 = (state_12959[(2)]);
var state_12959__$1 = state_12959;
var statearr_12992_13021 = state_12959__$1;
(statearr_12992_13021[(2)] = inst_12943);

(statearr_12992_13021[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12960 === (10))){
var inst_12912 = (state_12959[(11)]);
var inst_12914 = (state_12959[(12)]);
var inst_12919 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12912,inst_12914);
var state_12959__$1 = state_12959;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12959__$1,(13),out,inst_12919);
} else {
if((state_val_12960 === (18))){
var inst_12925 = (state_12959[(7)]);
var inst_12934 = cljs.core.first(inst_12925);
var state_12959__$1 = state_12959;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12959__$1,(20),out,inst_12934);
} else {
if((state_val_12960 === (8))){
var inst_12913 = (state_12959[(9)]);
var inst_12914 = (state_12959[(12)]);
var inst_12916 = (inst_12914 < inst_12913);
var inst_12917 = inst_12916;
var state_12959__$1 = state_12959;
if(cljs.core.truth_(inst_12917)){
var statearr_12993_13022 = state_12959__$1;
(statearr_12993_13022[(1)] = (10));

} else {
var statearr_12994_13023 = state_12959__$1;
(statearr_12994_13023[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11275__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11275__auto____0 = (function (){
var statearr_12995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12995[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11275__auto__);

(statearr_12995[(1)] = (1));

return statearr_12995;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11275__auto____1 = (function (state_12959){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_12959);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e12996){var ex__11278__auto__ = e12996;
var statearr_12997_13024 = state_12959;
(statearr_12997_13024[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_12959[(4)]))){
var statearr_12998_13025 = state_12959;
(statearr_12998_13025[(1)] = cljs.core.first((state_12959[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13026 = state_12959;
state_12959 = G__13026;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11275__auto__ = function(state_12959){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11275__auto____1.call(this,state_12959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11275__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11275__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_12999 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_12999[(6)] = c__11349__auto__);

return statearr_12999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));

return c__11349__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__13028 = arguments.length;
switch (G__13028) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__13031 = arguments.length;
switch (G__13031) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__13034 = arguments.length;
switch (G__13034) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11349__auto___13082 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_13058){
var state_val_13059 = (state_13058[(1)]);
if((state_val_13059 === (7))){
var inst_13053 = (state_13058[(2)]);
var state_13058__$1 = state_13058;
var statearr_13060_13083 = state_13058__$1;
(statearr_13060_13083[(2)] = inst_13053);

(statearr_13060_13083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (1))){
var inst_13035 = null;
var state_13058__$1 = (function (){var statearr_13061 = state_13058;
(statearr_13061[(7)] = inst_13035);

return statearr_13061;
})();
var statearr_13062_13084 = state_13058__$1;
(statearr_13062_13084[(2)] = null);

(statearr_13062_13084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (4))){
var inst_13038 = (state_13058[(8)]);
var inst_13038__$1 = (state_13058[(2)]);
var inst_13039 = (inst_13038__$1 == null);
var inst_13040 = cljs.core.not(inst_13039);
var state_13058__$1 = (function (){var statearr_13063 = state_13058;
(statearr_13063[(8)] = inst_13038__$1);

return statearr_13063;
})();
if(inst_13040){
var statearr_13064_13085 = state_13058__$1;
(statearr_13064_13085[(1)] = (5));

} else {
var statearr_13065_13086 = state_13058__$1;
(statearr_13065_13086[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (6))){
var state_13058__$1 = state_13058;
var statearr_13066_13087 = state_13058__$1;
(statearr_13066_13087[(2)] = null);

(statearr_13066_13087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (3))){
var inst_13055 = (state_13058[(2)]);
var inst_13056 = cljs.core.async.close_BANG_(out);
var state_13058__$1 = (function (){var statearr_13067 = state_13058;
(statearr_13067[(9)] = inst_13055);

return statearr_13067;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13058__$1,inst_13056);
} else {
if((state_val_13059 === (2))){
var state_13058__$1 = state_13058;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13058__$1,(4),ch);
} else {
if((state_val_13059 === (11))){
var inst_13038 = (state_13058[(8)]);
var inst_13047 = (state_13058[(2)]);
var inst_13035 = inst_13038;
var state_13058__$1 = (function (){var statearr_13068 = state_13058;
(statearr_13068[(10)] = inst_13047);

(statearr_13068[(7)] = inst_13035);

return statearr_13068;
})();
var statearr_13069_13088 = state_13058__$1;
(statearr_13069_13088[(2)] = null);

(statearr_13069_13088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (9))){
var inst_13038 = (state_13058[(8)]);
var state_13058__$1 = state_13058;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13058__$1,(11),out,inst_13038);
} else {
if((state_val_13059 === (5))){
var inst_13038 = (state_13058[(8)]);
var inst_13035 = (state_13058[(7)]);
var inst_13042 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13038,inst_13035);
var state_13058__$1 = state_13058;
if(inst_13042){
var statearr_13071_13089 = state_13058__$1;
(statearr_13071_13089[(1)] = (8));

} else {
var statearr_13072_13090 = state_13058__$1;
(statearr_13072_13090[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (10))){
var inst_13050 = (state_13058[(2)]);
var state_13058__$1 = state_13058;
var statearr_13073_13091 = state_13058__$1;
(statearr_13073_13091[(2)] = inst_13050);

(statearr_13073_13091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (8))){
var inst_13035 = (state_13058[(7)]);
var tmp13070 = inst_13035;
var inst_13035__$1 = tmp13070;
var state_13058__$1 = (function (){var statearr_13074 = state_13058;
(statearr_13074[(7)] = inst_13035__$1);

return statearr_13074;
})();
var statearr_13075_13092 = state_13058__$1;
(statearr_13075_13092[(2)] = null);

(statearr_13075_13092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_13076 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13076[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_13076[(1)] = (1));

return statearr_13076;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_13058){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_13058);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e13077){var ex__11278__auto__ = e13077;
var statearr_13078_13093 = state_13058;
(statearr_13078_13093[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_13058[(4)]))){
var statearr_13079_13094 = state_13058;
(statearr_13079_13094[(1)] = cljs.core.first((state_13058[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13095 = state_13058;
state_13058 = G__13095;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_13058){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_13058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_13080 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_13080[(6)] = c__11349__auto___13082);

return statearr_13080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__13097 = arguments.length;
switch (G__13097) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11349__auto___13164 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_13135){
var state_val_13136 = (state_13135[(1)]);
if((state_val_13136 === (7))){
var inst_13131 = (state_13135[(2)]);
var state_13135__$1 = state_13135;
var statearr_13137_13165 = state_13135__$1;
(statearr_13137_13165[(2)] = inst_13131);

(statearr_13137_13165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (1))){
var inst_13098 = (new Array(n));
var inst_13099 = inst_13098;
var inst_13100 = (0);
var state_13135__$1 = (function (){var statearr_13138 = state_13135;
(statearr_13138[(7)] = inst_13099);

(statearr_13138[(8)] = inst_13100);

return statearr_13138;
})();
var statearr_13139_13166 = state_13135__$1;
(statearr_13139_13166[(2)] = null);

(statearr_13139_13166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (4))){
var inst_13103 = (state_13135[(9)]);
var inst_13103__$1 = (state_13135[(2)]);
var inst_13104 = (inst_13103__$1 == null);
var inst_13105 = cljs.core.not(inst_13104);
var state_13135__$1 = (function (){var statearr_13140 = state_13135;
(statearr_13140[(9)] = inst_13103__$1);

return statearr_13140;
})();
if(inst_13105){
var statearr_13141_13167 = state_13135__$1;
(statearr_13141_13167[(1)] = (5));

} else {
var statearr_13142_13168 = state_13135__$1;
(statearr_13142_13168[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (15))){
var inst_13125 = (state_13135[(2)]);
var state_13135__$1 = state_13135;
var statearr_13143_13169 = state_13135__$1;
(statearr_13143_13169[(2)] = inst_13125);

(statearr_13143_13169[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (13))){
var state_13135__$1 = state_13135;
var statearr_13144_13170 = state_13135__$1;
(statearr_13144_13170[(2)] = null);

(statearr_13144_13170[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (6))){
var inst_13100 = (state_13135[(8)]);
var inst_13121 = (inst_13100 > (0));
var state_13135__$1 = state_13135;
if(cljs.core.truth_(inst_13121)){
var statearr_13145_13171 = state_13135__$1;
(statearr_13145_13171[(1)] = (12));

} else {
var statearr_13146_13172 = state_13135__$1;
(statearr_13146_13172[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (3))){
var inst_13133 = (state_13135[(2)]);
var state_13135__$1 = state_13135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13135__$1,inst_13133);
} else {
if((state_val_13136 === (12))){
var inst_13099 = (state_13135[(7)]);
var inst_13123 = cljs.core.vec(inst_13099);
var state_13135__$1 = state_13135;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13135__$1,(15),out,inst_13123);
} else {
if((state_val_13136 === (2))){
var state_13135__$1 = state_13135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13135__$1,(4),ch);
} else {
if((state_val_13136 === (11))){
var inst_13115 = (state_13135[(2)]);
var inst_13116 = (new Array(n));
var inst_13099 = inst_13116;
var inst_13100 = (0);
var state_13135__$1 = (function (){var statearr_13147 = state_13135;
(statearr_13147[(10)] = inst_13115);

(statearr_13147[(7)] = inst_13099);

(statearr_13147[(8)] = inst_13100);

return statearr_13147;
})();
var statearr_13148_13173 = state_13135__$1;
(statearr_13148_13173[(2)] = null);

(statearr_13148_13173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (9))){
var inst_13099 = (state_13135[(7)]);
var inst_13113 = cljs.core.vec(inst_13099);
var state_13135__$1 = state_13135;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13135__$1,(11),out,inst_13113);
} else {
if((state_val_13136 === (5))){
var inst_13108 = (state_13135[(11)]);
var inst_13103 = (state_13135[(9)]);
var inst_13099 = (state_13135[(7)]);
var inst_13100 = (state_13135[(8)]);
var inst_13107 = (inst_13099[inst_13100] = inst_13103);
var inst_13108__$1 = (inst_13100 + (1));
var inst_13109 = (inst_13108__$1 < n);
var state_13135__$1 = (function (){var statearr_13149 = state_13135;
(statearr_13149[(11)] = inst_13108__$1);

(statearr_13149[(12)] = inst_13107);

return statearr_13149;
})();
if(cljs.core.truth_(inst_13109)){
var statearr_13150_13174 = state_13135__$1;
(statearr_13150_13174[(1)] = (8));

} else {
var statearr_13151_13175 = state_13135__$1;
(statearr_13151_13175[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (14))){
var inst_13128 = (state_13135[(2)]);
var inst_13129 = cljs.core.async.close_BANG_(out);
var state_13135__$1 = (function (){var statearr_13153 = state_13135;
(statearr_13153[(13)] = inst_13128);

return statearr_13153;
})();
var statearr_13154_13176 = state_13135__$1;
(statearr_13154_13176[(2)] = inst_13129);

(statearr_13154_13176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (10))){
var inst_13119 = (state_13135[(2)]);
var state_13135__$1 = state_13135;
var statearr_13155_13177 = state_13135__$1;
(statearr_13155_13177[(2)] = inst_13119);

(statearr_13155_13177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13136 === (8))){
var inst_13108 = (state_13135[(11)]);
var inst_13099 = (state_13135[(7)]);
var tmp13152 = inst_13099;
var inst_13099__$1 = tmp13152;
var inst_13100 = inst_13108;
var state_13135__$1 = (function (){var statearr_13156 = state_13135;
(statearr_13156[(7)] = inst_13099__$1);

(statearr_13156[(8)] = inst_13100);

return statearr_13156;
})();
var statearr_13157_13178 = state_13135__$1;
(statearr_13157_13178[(2)] = null);

(statearr_13157_13178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_13158 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13158[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_13158[(1)] = (1));

return statearr_13158;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_13135){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_13135);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e13159){var ex__11278__auto__ = e13159;
var statearr_13160_13179 = state_13135;
(statearr_13160_13179[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_13135[(4)]))){
var statearr_13161_13180 = state_13135;
(statearr_13161_13180[(1)] = cljs.core.first((state_13135[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13181 = state_13135;
state_13135 = G__13181;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_13135){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_13135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_13162 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_13162[(6)] = c__11349__auto___13164);

return statearr_13162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__13183 = arguments.length;
switch (G__13183) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11349__auto___13261 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11350__auto__ = (function (){var switch__11274__auto__ = (function (state_13228){
var state_val_13229 = (state_13228[(1)]);
if((state_val_13229 === (7))){
var inst_13224 = (state_13228[(2)]);
var state_13228__$1 = state_13228;
var statearr_13230_13262 = state_13228__$1;
(statearr_13230_13262[(2)] = inst_13224);

(statearr_13230_13262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (1))){
var inst_13184 = [];
var inst_13185 = inst_13184;
var inst_13186 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13228__$1 = (function (){var statearr_13231 = state_13228;
(statearr_13231[(7)] = inst_13185);

(statearr_13231[(8)] = inst_13186);

return statearr_13231;
})();
var statearr_13232_13263 = state_13228__$1;
(statearr_13232_13263[(2)] = null);

(statearr_13232_13263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (4))){
var inst_13189 = (state_13228[(9)]);
var inst_13189__$1 = (state_13228[(2)]);
var inst_13190 = (inst_13189__$1 == null);
var inst_13191 = cljs.core.not(inst_13190);
var state_13228__$1 = (function (){var statearr_13233 = state_13228;
(statearr_13233[(9)] = inst_13189__$1);

return statearr_13233;
})();
if(inst_13191){
var statearr_13234_13264 = state_13228__$1;
(statearr_13234_13264[(1)] = (5));

} else {
var statearr_13235_13265 = state_13228__$1;
(statearr_13235_13265[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (15))){
var inst_13185 = (state_13228[(7)]);
var inst_13216 = cljs.core.vec(inst_13185);
var state_13228__$1 = state_13228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13228__$1,(18),out,inst_13216);
} else {
if((state_val_13229 === (13))){
var inst_13211 = (state_13228[(2)]);
var state_13228__$1 = state_13228;
var statearr_13236_13266 = state_13228__$1;
(statearr_13236_13266[(2)] = inst_13211);

(statearr_13236_13266[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (6))){
var inst_13185 = (state_13228[(7)]);
var inst_13213 = inst_13185.length;
var inst_13214 = (inst_13213 > (0));
var state_13228__$1 = state_13228;
if(cljs.core.truth_(inst_13214)){
var statearr_13237_13267 = state_13228__$1;
(statearr_13237_13267[(1)] = (15));

} else {
var statearr_13238_13268 = state_13228__$1;
(statearr_13238_13268[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (17))){
var inst_13221 = (state_13228[(2)]);
var inst_13222 = cljs.core.async.close_BANG_(out);
var state_13228__$1 = (function (){var statearr_13239 = state_13228;
(statearr_13239[(10)] = inst_13221);

return statearr_13239;
})();
var statearr_13240_13269 = state_13228__$1;
(statearr_13240_13269[(2)] = inst_13222);

(statearr_13240_13269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (3))){
var inst_13226 = (state_13228[(2)]);
var state_13228__$1 = state_13228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13228__$1,inst_13226);
} else {
if((state_val_13229 === (12))){
var inst_13185 = (state_13228[(7)]);
var inst_13204 = cljs.core.vec(inst_13185);
var state_13228__$1 = state_13228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13228__$1,(14),out,inst_13204);
} else {
if((state_val_13229 === (2))){
var state_13228__$1 = state_13228;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13228__$1,(4),ch);
} else {
if((state_val_13229 === (11))){
var inst_13185 = (state_13228[(7)]);
var inst_13189 = (state_13228[(9)]);
var inst_13193 = (state_13228[(11)]);
var inst_13201 = inst_13185.push(inst_13189);
var tmp13241 = inst_13185;
var inst_13185__$1 = tmp13241;
var inst_13186 = inst_13193;
var state_13228__$1 = (function (){var statearr_13242 = state_13228;
(statearr_13242[(7)] = inst_13185__$1);

(statearr_13242[(8)] = inst_13186);

(statearr_13242[(12)] = inst_13201);

return statearr_13242;
})();
var statearr_13243_13270 = state_13228__$1;
(statearr_13243_13270[(2)] = null);

(statearr_13243_13270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (9))){
var inst_13186 = (state_13228[(8)]);
var inst_13197 = cljs.core.keyword_identical_QMARK_(inst_13186,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_13228__$1 = state_13228;
var statearr_13244_13271 = state_13228__$1;
(statearr_13244_13271[(2)] = inst_13197);

(statearr_13244_13271[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (5))){
var inst_13189 = (state_13228[(9)]);
var inst_13186 = (state_13228[(8)]);
var inst_13194 = (state_13228[(13)]);
var inst_13193 = (state_13228[(11)]);
var inst_13193__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13189) : f.call(null,inst_13189));
var inst_13194__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13193__$1,inst_13186);
var state_13228__$1 = (function (){var statearr_13245 = state_13228;
(statearr_13245[(13)] = inst_13194__$1);

(statearr_13245[(11)] = inst_13193__$1);

return statearr_13245;
})();
if(inst_13194__$1){
var statearr_13246_13272 = state_13228__$1;
(statearr_13246_13272[(1)] = (8));

} else {
var statearr_13247_13273 = state_13228__$1;
(statearr_13247_13273[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (14))){
var inst_13189 = (state_13228[(9)]);
var inst_13193 = (state_13228[(11)]);
var inst_13206 = (state_13228[(2)]);
var inst_13207 = [];
var inst_13208 = inst_13207.push(inst_13189);
var inst_13185 = inst_13207;
var inst_13186 = inst_13193;
var state_13228__$1 = (function (){var statearr_13248 = state_13228;
(statearr_13248[(7)] = inst_13185);

(statearr_13248[(14)] = inst_13208);

(statearr_13248[(8)] = inst_13186);

(statearr_13248[(15)] = inst_13206);

return statearr_13248;
})();
var statearr_13249_13274 = state_13228__$1;
(statearr_13249_13274[(2)] = null);

(statearr_13249_13274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (16))){
var state_13228__$1 = state_13228;
var statearr_13250_13275 = state_13228__$1;
(statearr_13250_13275[(2)] = null);

(statearr_13250_13275[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (10))){
var inst_13199 = (state_13228[(2)]);
var state_13228__$1 = state_13228;
if(cljs.core.truth_(inst_13199)){
var statearr_13251_13276 = state_13228__$1;
(statearr_13251_13276[(1)] = (11));

} else {
var statearr_13252_13277 = state_13228__$1;
(statearr_13252_13277[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (18))){
var inst_13218 = (state_13228[(2)]);
var state_13228__$1 = state_13228;
var statearr_13253_13278 = state_13228__$1;
(statearr_13253_13278[(2)] = inst_13218);

(statearr_13253_13278[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13229 === (8))){
var inst_13194 = (state_13228[(13)]);
var state_13228__$1 = state_13228;
var statearr_13254_13279 = state_13228__$1;
(statearr_13254_13279[(2)] = inst_13194);

(statearr_13254_13279[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11275__auto__ = null;
var cljs$core$async$state_machine__11275__auto____0 = (function (){
var statearr_13255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13255[(0)] = cljs$core$async$state_machine__11275__auto__);

(statearr_13255[(1)] = (1));

return statearr_13255;
});
var cljs$core$async$state_machine__11275__auto____1 = (function (state_13228){
while(true){
var ret_value__11276__auto__ = (function (){try{while(true){
var result__11277__auto__ = switch__11274__auto__(state_13228);
if(cljs.core.keyword_identical_QMARK_(result__11277__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11277__auto__;
}
break;
}
}catch (e13256){var ex__11278__auto__ = e13256;
var statearr_13257_13280 = state_13228;
(statearr_13257_13280[(2)] = ex__11278__auto__);


if(cljs.core.seq((state_13228[(4)]))){
var statearr_13258_13281 = state_13228;
(statearr_13258_13281[(1)] = cljs.core.first((state_13228[(4)])));

} else {
throw ex__11278__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13282 = state_13228;
state_13228 = G__13282;
continue;
} else {
return ret_value__11276__auto__;
}
break;
}
});
cljs$core$async$state_machine__11275__auto__ = function(state_13228){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11275__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11275__auto____1.call(this,state_13228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11275__auto____0;
cljs$core$async$state_machine__11275__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11275__auto____1;
return cljs$core$async$state_machine__11275__auto__;
})()
})();
var state__11351__auto__ = (function (){var statearr_13259 = (f__11350__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11350__auto__.cljs$core$IFn$_invoke$arity$0() : f__11350__auto__.call(null));
(statearr_13259[(6)] = c__11349__auto___13261);

return statearr_13259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11351__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

