// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('alphabase.codec');
goog.require('cljs.core');
goog.require('alphabase.bytes');
/**
 * Pure implementation of radix division to calculate a sequence of
 *   tokens from a byte array.
 */
alphabase.codec.pure_divide = (function alphabase$codec$pure_divide(alphabet,data){
var base = cljs.core.count(alphabet);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.nth,alphabet),cljs.core.reverse(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function alphabase$codec$pure_divide_$_add_byte(digits,value){
var digits__$1 = digits;
var carry = value;
var i = (0);
while(true){
if((i < cljs.core.count(digits__$1))){
var carry_SINGLEQUOTE_ = (carry + (cljs.core.nth.cljs$core$IFn$_invoke$arity$2(digits__$1,i) << (8)));
var G__32739 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(digits__$1,i,cljs.core.mod(carry_SINGLEQUOTE_,base));
var G__32740 = ((carry_SINGLEQUOTE_ / base) | (0));
var G__32741 = (i + (1));
digits__$1 = G__32739;
carry = G__32740;
i = G__32741;
continue;
} else {
if((carry > (0))){
var G__32742 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(digits__$1,cljs.core.mod(carry,base));
var G__32743 = ((carry / base) | (0));
var G__32744 = (i + (1));
digits__$1 = G__32742;
carry = G__32743;
i = G__32744;
continue;
} else {
return digits__$1;
}
}
break;
}
}),cljs.core.transient$(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null)),alphabase.bytes.byte_seq(data)))));
});
/**
 * Encodes binary data using the given alphabet. Returns the encoded string, or
 *   nil if the input is nil or empty.
 */
alphabase.codec.encode = (function alphabase$codec$encode(alphabet,data){
if(typeof alphabet === 'string'){
} else {
throw (new Error("Assert failed: (string? alphabet)"));
}

if(((1) < cljs.core.count(alphabet))){
} else {
throw (new Error("Assert failed: (< 1 (count alphabet))"));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = data;
if(cljs.core.truth_(and__4221__auto__)){
return (!((data.length === (0))));
} else {
return and__4221__auto__;
}
})())){
var zeroes = cljs.core.count(cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.zero_QMARK_,alphabase.bytes.byte_seq(data)));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(zeroes,cljs.core.first(alphabet)),(((zeroes < data.length))?alphabase.codec.pure_divide(alphabet,data):null)));
} else {
return null;
}
});
/**
 * Pure implementation of radix multiplication to calculate a sequence of byte
 *   values from a string of tokens.
 */
alphabase.codec.pure_multiply = (function alphabase$codec$pure_multiply(alphabet,tokens){
var base = cljs.core.count(alphabet);
return cljs.core.reverse(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function alphabase$codec$pure_multiply_$_add_token(bytev,token){
var value = alphabet.indexOf(cljs.core.str.cljs$core$IFn$_invoke$arity$1(token));
if((value < (0))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid token ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([token], 0))," is not in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._STAR_ns_STAR_)," (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base),") alphabet"].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),alphabet,new cljs.core.Keyword(null,"token","token",-1211463215),token], null));
} else {
}

var bytev__$1 = bytev;
var carry = value;
var i = (0);
while(true){
if((i < cljs.core.count(bytev__$1))){
var carry_SINGLEQUOTE_ = (carry + (base * cljs.core.nth.cljs$core$IFn$_invoke$arity$2(bytev__$1,i)));
var G__32745 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(bytev__$1,i,(carry_SINGLEQUOTE_ & (255)));
var G__32746 = (carry_SINGLEQUOTE_ >> (8));
var G__32747 = (i + (1));
bytev__$1 = G__32745;
carry = G__32746;
i = G__32747;
continue;
} else {
if((carry > (0))){
var G__32748 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(bytev__$1,(carry & (255)));
var G__32749 = (carry >> (8));
var G__32750 = (i + (1));
bytev__$1 = G__32748;
carry = G__32749;
i = G__32750;
continue;
} else {
return bytev__$1;
}
}
break;
}
}),cljs.core.transient$(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null)),cljs.core.seq(tokens))));
});
/**
 * Decodes a string of alphabet tokens. Returns the decoded binary array, or nil
 *   if the input is nil or empty.
 */
alphabase.codec.decode = (function alphabase$codec$decode(alphabet,tokens){
if(typeof alphabet === 'string'){
} else {
throw (new Error("Assert failed: (string? alphabet)"));
}

if((!(cljs.core.empty_QMARK_(alphabet)))){
} else {
throw (new Error("Assert failed: (not (empty? alphabet))"));
}

if(cljs.core.empty_QMARK_(tokens)){
return null;
} else {
var zeroes = cljs.core.count(cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.first(alphabet)]),tokens));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(zeroes,cljs.core.count(tokens))){
return alphabase.bytes.byte_array(zeroes);
} else {
var byte_seq = alphabase.codec.pure_multiply(alphabet,tokens);
var data = alphabase.bytes.byte_array((zeroes + cljs.core.count(byte_seq)));
var n__4706__auto___32751 = cljs.core.count(byte_seq);
var i_32752 = (0);
while(true){
if((i_32752 < n__4706__auto___32751)){
alphabase.bytes.set_byte(data,(zeroes + i_32752),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(byte_seq,i_32752));

var G__32753 = (i_32752 + (1));
i_32752 = G__32753;
continue;
} else {
}
break;
}

return data;
}
}
});
