// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__30952 = cljs.core._EQ_;
var expr__30953 = e.getLastErrorCode();
if(cljs.core.truth_((pred__30952.cljs$core$IFn$_invoke$arity$2 ? pred__30952.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__30953) : pred__30952.call(null,goog.net.ErrorCode.NO_ERROR,expr__30953)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__30952.cljs$core$IFn$_invoke$arity$2 ? pred__30952.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__30953) : pred__30952.call(null,goog.net.ErrorCode.EXCEPTION,expr__30953)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__30952.cljs$core$IFn$_invoke$arity$2 ? pred__30952.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__30953) : pred__30952.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__30953)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__30952.cljs$core$IFn$_invoke$arity$2 ? pred__30952.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__30953) : pred__30952.call(null,goog.net.ErrorCode.ABORT,expr__30953)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__30952.cljs$core$IFn$_invoke$arity$2 ? pred__30952.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__30953) : pred__30952.call(null,goog.net.ErrorCode.TIMEOUT,expr__30953)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4221__auto__ = status;
if(cljs.core.truth_(and__4221__auto__)){
return (status > (0));
} else {
return and__4221__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__30955 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30955,cljs.core.cst$kw$status,status);
} else {
return G__30955;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__30956 = opts;
var map__30956__$1 = cljs.core.__destructure_map(map__30956);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30956__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30956__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30956__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__30957 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__30957__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__30957,headers], 0)):G__30957);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30957__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__30957__$1;
}
})();
try{var G__30959_30965 = url;
var G__30960_30966 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__30961_30967 = "POST";
var G__30962_30968 = fluree.db.util.json.stringify(message);
var G__30963_30969 = cljs.core.clj__GT_js(headers__$1);
var G__30964_30970 = request_timeout;
goog.net.XhrIo.send(G__30959_30965,G__30960_30966,G__30961_30967,G__30962_30968,G__30963_30969,G__30964_30970);
}catch (e30958){var e_30971 = e30958;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_30971);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__30972 = opts;
var map__30972__$1 = cljs.core.__destructure_map(map__30972);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30972__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30972__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30972__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30972__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30972__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__30973 = cljs.core.PersistentArrayMap.EMPTY;
var G__30973__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__30973,headers], 0)):G__30973);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30973__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__30973__$1;
}
})();
try{var G__30975_30982 = url;
var G__30976_30983 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__30981 = output_format;
var G__30981__$1 = (((G__30981 instanceof cljs.core.Keyword))?G__30981.fqn:null);
switch (G__30981__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__30977_30984 = "GET";
var G__30978_30985 = body;
var G__30979_30986 = cljs.core.clj__GT_js(headers__$1);
var G__30980_30987 = request_timeout;
goog.net.XhrIo.send(G__30975_30982,G__30976_30983,G__30977_30984,G__30978_30985,G__30979_30986,G__30980_30987);
}catch (e30974){var e_30989 = e30974;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_30989);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__30990 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30990,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__30990;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_31023){
var state_val_31024 = (state_31023[(1)]);
if((state_val_31024 === (7))){
var inst_31019 = (state_31023[(2)]);
var state_31023__$1 = state_31023;
var statearr_31025_31050 = state_31023__$1;
(statearr_31025_31050[(2)] = inst_31019);

(statearr_31025_31050[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31024 === (1))){
var state_31023__$1 = state_31023;
var statearr_31026_31051 = state_31023__$1;
(statearr_31026_31051[(2)] = null);

(statearr_31026_31051[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31024 === (4))){
var inst_30994 = (state_31023[(7)]);
var inst_30994__$1 = (state_31023[(2)]);
var inst_30995 = (inst_30994__$1 == null);
var state_31023__$1 = (function (){var statearr_31027 = state_31023;
(statearr_31027[(7)] = inst_30994__$1);

return statearr_31027;
})();
if(cljs.core.truth_(inst_30995)){
var statearr_31028_31052 = state_31023__$1;
(statearr_31028_31052[(1)] = (5));

} else {
var statearr_31029_31053 = state_31023__$1;
(statearr_31029_31053[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31024 === (6))){
var inst_30994 = (state_31023[(7)]);
var inst_31002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30994,(0),null);
var inst_31003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30994,(1),null);
var state_31023__$1 = (function (){var statearr_31030 = state_31023;
(statearr_31030[(8)] = inst_31002);

(statearr_31030[(9)] = inst_31003);

return statearr_31030;
})();
var statearr_31031_31054 = state_31023__$1;
(statearr_31031_31054[(2)] = null);

(statearr_31031_31054[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31024 === (3))){
var inst_31021 = (state_31023[(2)]);
var state_31023__$1 = state_31023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31023__$1,inst_31021);
} else {
if((state_val_31024 === (2))){
var state_31023__$1 = state_31023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31023__$1,(4),pub_chan);
} else {
if((state_val_31024 === (11))){
var _ = (function (){var statearr_31033 = state_31023;
(statearr_31033[(4)] = cljs.core.rest((state_31023[(4)])));

return statearr_31033;
})();
var state_31023__$1 = state_31023;
var ex31032 = (state_31023__$1[(2)]);
var statearr_31034_31055 = state_31023__$1;
(statearr_31034_31055[(5)] = ex31032);


if((ex31032 instanceof Error)){
var statearr_31035_31056 = state_31023__$1;
(statearr_31035_31056[(1)] = (10));

(statearr_31035_31056[(5)] = null);

} else {
throw ex31032;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31024 === (9))){
var inst_31016 = (state_31023[(2)]);
var state_31023__$1 = (function (){var statearr_31036 = state_31023;
(statearr_31036[(10)] = inst_31016);

return statearr_31036;
})();
var statearr_31037_31057 = state_31023__$1;
(statearr_31037_31057[(2)] = null);

(statearr_31037_31057[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31024 === (5))){
var inst_30997 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_31023__$1 = state_31023;
var statearr_31038_31058 = state_31023__$1;
(statearr_31038_31058[(2)] = inst_30997);

(statearr_31038_31058[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31024 === (10))){
var inst_31003 = (state_31023[(9)]);
var inst_31004 = (state_31023[(2)]);
var inst_31005 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_31004,"Websocket send message error:",inst_31004], 0));
var inst_31006 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31003,false);
var state_31023__$1 = (function (){var statearr_31039 = state_31023;
(statearr_31039[(11)] = inst_31005);

return statearr_31039;
})();
var statearr_31040_31059 = state_31023__$1;
(statearr_31040_31059[(2)] = inst_31006);

(statearr_31040_31059[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31024 === (8))){
var inst_31002 = (state_31023[(8)]);
var inst_31003 = (state_31023[(9)]);
var _ = (function (){var statearr_31041 = state_31023;
(statearr_31041[(4)] = cljs.core.cons((11),(state_31023[(4)])));

return statearr_31041;
})();
var inst_31012 = ws.send(inst_31002);
var inst_31013 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31003,true);
var ___$1 = (function (){var statearr_31042 = state_31023;
(statearr_31042[(4)] = cljs.core.rest((state_31023[(4)])));

return statearr_31042;
})();
var state_31023__$1 = (function (){var statearr_31043 = state_31023;
(statearr_31043[(12)] = inst_31012);

return statearr_31043;
})();
var statearr_31044_31060 = state_31023__$1;
(statearr_31044_31060[(2)] = inst_31013);

(statearr_31044_31060[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto____0 = (function (){
var statearr_31045 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31045[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto__);

(statearr_31045[(1)] = (1));

return statearr_31045;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto____1 = (function (state_31023){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_31023);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e31046){var ex__14781__auto__ = e31046;
var statearr_31047_31061 = state_31023;
(statearr_31047_31061[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_31023[(4)]))){
var statearr_31048_31062 = state_31023;
(statearr_31048_31062[(1)] = cljs.core.first((state_31023[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__31063 = state_31023;
state_31023 = G__31063;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto__ = function(state_31023){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto____1.call(this,state_31023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_31049 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_31049[(6)] = c__14852__auto__);

return statearr_31049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__14852__auto___31102 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_31089){
var state_val_31090 = (state_31089[(1)]);
if((state_val_31090 === (1))){
var inst_31068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31069 = [open_QMARK_,timeout_chan];
var inst_31070 = (new cljs.core.PersistentVector(null,2,(5),inst_31068,inst_31069,null));
var state_31089__$1 = state_31089;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_31089__$1,(2),inst_31070,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_31090 === (2))){
var inst_31072 = (state_31089[(2)]);
var inst_31073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31072,(0),null);
var inst_31074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31072,(1),null);
var inst_31075 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31074,timeout_chan);
var state_31089__$1 = (function (){var statearr_31091 = state_31089;
(statearr_31091[(7)] = inst_31073);

return statearr_31091;
})();
if(inst_31075){
var statearr_31092_31103 = state_31089__$1;
(statearr_31092_31103[(1)] = (3));

} else {
var statearr_31093_31104 = state_31089__$1;
(statearr_31093_31104[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (3))){
var inst_31077 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_31078 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31079 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_31080 = cljs.core.PersistentHashMap.fromArrays(inst_31078,inst_31079);
var inst_31081 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31077,inst_31080);
var inst_31082 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_31081);
var inst_31083 = fluree.db.util.xhttp.close_websocket(ws);
var state_31089__$1 = (function (){var statearr_31094 = state_31089;
(statearr_31094[(8)] = inst_31082);

return statearr_31094;
})();
var statearr_31095_31105 = state_31089__$1;
(statearr_31095_31105[(2)] = inst_31083);

(statearr_31095_31105[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (4))){
var inst_31085 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_31089__$1 = state_31089;
var statearr_31096_31106 = state_31089__$1;
(statearr_31096_31106[(2)] = inst_31085);

(statearr_31096_31106[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (5))){
var inst_31087 = (state_31089[(2)]);
var state_31089__$1 = state_31089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31089__$1,inst_31087);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto____0 = (function (){
var statearr_31097 = [null,null,null,null,null,null,null,null,null];
(statearr_31097[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto__);

(statearr_31097[(1)] = (1));

return statearr_31097;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto____1 = (function (state_31089){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_31089);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e31098){var ex__14781__auto__ = e31098;
var statearr_31099_31107 = state_31089;
(statearr_31099_31107[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_31089[(4)]))){
var statearr_31100_31108 = state_31089;
(statearr_31100_31108[(1)] = cljs.core.first((state_31089[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__31109 = state_31089;
state_31089 = G__31109;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto__ = function(state_31089){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto____1.call(this,state_31089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_31101 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_31101[(6)] = c__14852__auto___31102);

return statearr_31101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
