// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.time_travel');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.range');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
/**
 * Given a duration, returns a ISO-8601 formatted time string of now minus duration
 */
fluree.db.time_travel.duration_parse = (function fluree$db$time_travel$duration_parse(time_str){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Duration timeframes not yet supported in javascript.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_platform_DASH_support], null));
});
fluree.db.time_travel.time_to_t = (function fluree$db$time_travel$time_to_t(db,time_str){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_30187){
var state_val_30188 = (state_30187[(1)]);
if((state_val_30188 === (7))){
var state_30187__$1 = state_30187;
var statearr_30189_30231 = state_30187__$1;
(statearr_30189_30231[(2)] = time_str);

(statearr_30189_30231[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (20))){
var inst_30172 = (state_30187[(7)]);
var state_30187__$1 = state_30187;
if(cljs.core.truth_(inst_30172)){
var statearr_30190_30232 = state_30187__$1;
(statearr_30190_30232[(1)] = (22));

} else {
var statearr_30191_30233 = state_30187__$1;
(statearr_30191_30233[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (1))){
var state_30187__$1 = state_30187;
var statearr_30192_30234 = state_30187__$1;
(statearr_30192_30234[(2)] = null);

(statearr_30192_30234[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (24))){
var inst_30180 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
var statearr_30193_30235 = state_30187__$1;
(statearr_30193_30235[(2)] = inst_30180);

(statearr_30193_30235[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (4))){
var inst_30126 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
var statearr_30194_30236 = state_30187__$1;
(statearr_30194_30236[(2)] = inst_30126);

(statearr_30194_30236[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (15))){
var inst_30156 = (state_30187[(2)]);
var inst_30157 = fluree.db.util.async.throw_err(inst_30156);
var state_30187__$1 = state_30187;
var statearr_30195_30237 = state_30187__$1;
(statearr_30195_30237[(2)] = inst_30157);

(statearr_30195_30237[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (21))){
var inst_30182 = (state_30187[(2)]);
var _ = (function (){var statearr_30196 = state_30187;
(statearr_30196[(4)] = cljs.core.rest((state_30187[(4)])));

return statearr_30196;
})();
var state_30187__$1 = state_30187;
var statearr_30197_30238 = state_30187__$1;
(statearr_30197_30238[(2)] = inst_30182);

(statearr_30197_30238[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (13))){
var inst_30151 = (state_30187[(8)]);
var state_30187__$1 = state_30187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30187__$1,(15),inst_30151);
} else {
if((state_val_30188 === (22))){
var inst_30172 = (state_30187[(7)]);
var state_30187__$1 = state_30187;
var statearr_30198_30239 = state_30187__$1;
(statearr_30198_30239[(2)] = inst_30172);

(statearr_30198_30239[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (6))){
var inst_30134 = fluree.db.util.core.str__GT_epoch_ms(time_str);
var state_30187__$1 = state_30187;
var statearr_30199_30240 = state_30187__$1;
(statearr_30199_30240[(2)] = inst_30134);

(statearr_30199_30240[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (17))){
var state_30187__$1 = state_30187;
var statearr_30200_30241 = state_30187__$1;
(statearr_30200_30241[(2)] = null);

(statearr_30200_30241[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (3))){
var inst_30185 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30187__$1,inst_30185);
} else {
if((state_val_30188 === (12))){
var state_30187__$1 = state_30187;
var statearr_30201_30242 = state_30187__$1;
(statearr_30201_30242[(2)] = null);

(statearr_30201_30242[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (2))){
var _ = (function (){var statearr_30202 = state_30187;
(statearr_30202[(4)] = cljs.core.cons((5),(state_30187[(4)])));

return statearr_30202;
})();
var inst_30132 = typeof time_str === 'string';
var state_30187__$1 = state_30187;
if(cljs.core.truth_(inst_30132)){
var statearr_30203_30243 = state_30187__$1;
(statearr_30203_30243[(1)] = (6));

} else {
var statearr_30204_30244 = state_30187__$1;
(statearr_30204_30244[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (23))){
var inst_30178 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_30187__$1 = state_30187;
var statearr_30205_30245 = state_30187__$1;
(statearr_30205_30245[(2)] = inst_30178);

(statearr_30205_30245[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (19))){
var inst_30173 = (state_30187[(9)]);
var state_30187__$1 = state_30187;
var statearr_30206_30246 = state_30187__$1;
(statearr_30206_30246[(2)] = inst_30173);

(statearr_30206_30246[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (11))){
var inst_30151 = (state_30187[(8)]);
var inst_30151__$1 = (state_30187[(2)]);
var inst_30152 = (inst_30151__$1 == null);
var state_30187__$1 = (function (){var statearr_30208 = state_30187;
(statearr_30208[(8)] = inst_30151__$1);

return statearr_30208;
})();
if(cljs.core.truth_(inst_30152)){
var statearr_30209_30247 = state_30187__$1;
(statearr_30209_30247[(1)] = (12));

} else {
var statearr_30210_30248 = state_30187__$1;
(statearr_30210_30248[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (9))){
var state_30187__$1 = state_30187;
var statearr_30211_30249 = state_30187__$1;
(statearr_30211_30249[(2)] = null);

(statearr_30211_30249[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (5))){
var _ = (function (){var statearr_30212 = state_30187;
(statearr_30212[(4)] = cljs.core.rest((state_30187[(4)])));

return statearr_30212;
})();
var state_30187__$1 = state_30187;
var ex30207 = (state_30187__$1[(2)]);
var statearr_30213_30250 = state_30187__$1;
(statearr_30213_30250[(5)] = ex30207);


if((ex30207 instanceof Error)){
var statearr_30214_30251 = state_30187__$1;
(statearr_30214_30251[(1)] = (4));

(statearr_30214_30251[(5)] = null);

} else {
throw ex30207;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (14))){
var inst_30159 = (state_30187[(10)]);
var inst_30159__$1 = (state_30187[(2)]);
var inst_30160 = cljs.core.empty_QMARK_(inst_30159__$1);
var state_30187__$1 = (function (){var statearr_30215 = state_30187;
(statearr_30215[(10)] = inst_30159__$1);

return statearr_30215;
})();
if(inst_30160){
var statearr_30216_30252 = state_30187__$1;
(statearr_30216_30252[(1)] = (16));

} else {
var statearr_30217_30253 = state_30187__$1;
(statearr_30217_30253[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (16))){
var inst_30137 = (state_30187[(11)]);
var inst_30162 = ["There is no data as of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30137)].join('');
var inst_30163 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30164 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_block];
var inst_30165 = cljs.core.PersistentHashMap.fromArrays(inst_30163,inst_30164);
var inst_30166 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30162,inst_30165);
var inst_30167 = (function(){throw inst_30166})();
var state_30187__$1 = state_30187;
var statearr_30218_30254 = state_30187__$1;
(statearr_30218_30254[(2)] = inst_30167);

(statearr_30218_30254[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (10))){
var inst_30137 = (state_30187[(11)]);
var inst_30139 = (state_30187[(12)]);
var inst_30143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30144 = ["_block/instant",(0)];
var inst_30145 = (new cljs.core.PersistentVector(null,2,(5),inst_30143,inst_30144,null));
var inst_30146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30147 = ["_block/instant",inst_30137];
var inst_30148 = (new cljs.core.PersistentVector(null,2,(5),inst_30146,inst_30147,null));
var inst_30149 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(inst_30139,cljs.core.cst$kw$post,cljs.core._GT_,inst_30145,cljs.core._LT_,inst_30148);
var state_30187__$1 = state_30187;
var statearr_30219_30255 = state_30187__$1;
(statearr_30219_30255[(2)] = inst_30149);

(statearr_30219_30255[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (18))){
var inst_30159 = (state_30187[(10)]);
var inst_30173 = (state_30187[(9)]);
var inst_30172 = (state_30187[(7)]);
var inst_30137 = (state_30187[(11)]);
var inst_30170 = (state_30187[(2)]);
var inst_30171 = (function (){var epoch_as_of = inst_30137;
var ts = inst_30159;
var _ = inst_30170;
return (function (p1__30125_SHARP_){
return p1__30125_SHARP_.s;
});
})();
var inst_30172__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.min_key,inst_30171,inst_30159);
var inst_30173__$1 = inst_30172__$1.s;
var state_30187__$1 = (function (){var statearr_30220 = state_30187;
(statearr_30220[(9)] = inst_30173__$1);

(statearr_30220[(7)] = inst_30172__$1);

return statearr_30220;
})();
if(cljs.core.truth_(inst_30173__$1)){
var statearr_30221_30256 = state_30187__$1;
(statearr_30221_30256[(1)] = (19));

} else {
var statearr_30222_30257 = state_30187__$1;
(statearr_30222_30257[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30188 === (8))){
var inst_30139 = (state_30187[(12)]);
var inst_30137 = (state_30187[(2)]);
var inst_30139__$1 = fluree.db.dbproto._rootdb(db);
var inst_30140 = (inst_30139__$1 == null);
var state_30187__$1 = (function (){var statearr_30223 = state_30187;
(statearr_30223[(11)] = inst_30137);

(statearr_30223[(12)] = inst_30139__$1);

return statearr_30223;
})();
if(cljs.core.truth_(inst_30140)){
var statearr_30224_30258 = state_30187__$1;
(statearr_30224_30258[(1)] = (9));

} else {
var statearr_30225_30259 = state_30187__$1;
(statearr_30225_30259[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$time_to_t_$_state_machine__14778__auto__ = null;
var fluree$db$time_travel$time_to_t_$_state_machine__14778__auto____0 = (function (){
var statearr_30226 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30226[(0)] = fluree$db$time_travel$time_to_t_$_state_machine__14778__auto__);

(statearr_30226[(1)] = (1));

return statearr_30226;
});
var fluree$db$time_travel$time_to_t_$_state_machine__14778__auto____1 = (function (state_30187){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_30187);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e30227){var ex__14781__auto__ = e30227;
var statearr_30228_30260 = state_30187;
(statearr_30228_30260[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_30187[(4)]))){
var statearr_30229_30261 = state_30187;
(statearr_30229_30261[(1)] = cljs.core.first((state_30187[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__30262 = state_30187;
state_30187 = G__30262;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$time_travel$time_to_t_$_state_machine__14778__auto__ = function(state_30187){
switch(arguments.length){
case 0:
return fluree$db$time_travel$time_to_t_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$time_travel$time_to_t_$_state_machine__14778__auto____1.call(this,state_30187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$time_to_t_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$time_to_t_$_state_machine__14778__auto____0;
fluree$db$time_travel$time_to_t_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$time_to_t_$_state_machine__14778__auto____1;
return fluree$db$time_travel$time_to_t_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_30230 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_30230[(6)] = c__14852__auto__);

return statearr_30230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.time_travel.t_to_block = (function fluree$db$time_travel$t_to_block(db,t){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_30315){
var state_val_30316 = (state_30315[(1)]);
if((state_val_30316 === (7))){
var inst_30270 = (state_30315[(7)]);
var inst_30274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30275 = ["_block/number",t];
var inst_30276 = (new cljs.core.PersistentVector(null,2,(5),inst_30274,inst_30275,null));
var inst_30277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30278 = ["_block/number"];
var inst_30279 = (new cljs.core.PersistentVector(null,1,(5),inst_30277,inst_30278,null));
var inst_30280 = [cljs.core.cst$kw$limit];
var inst_30281 = [(1)];
var inst_30282 = cljs.core.PersistentHashMap.fromArrays(inst_30280,inst_30281);
var inst_30283 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(inst_30270,cljs.core.cst$kw$psot,cljs.core._GT__EQ_,inst_30276,cljs.core._LT__EQ_,inst_30279,inst_30282);
var state_30315__$1 = state_30315;
var statearr_30317_30356 = state_30315__$1;
(statearr_30317_30356[(2)] = inst_30283);

(statearr_30317_30356[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (20))){
var state_30315__$1 = state_30315;
var statearr_30318_30357 = state_30315__$1;
(statearr_30318_30357[(2)] = (1));

(statearr_30318_30357[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (1))){
var state_30315__$1 = state_30315;
var statearr_30319_30358 = state_30315__$1;
(statearr_30319_30358[(2)] = null);

(statearr_30319_30358[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (4))){
var inst_30263 = (state_30315[(2)]);
var state_30315__$1 = state_30315;
var statearr_30320_30359 = state_30315__$1;
(statearr_30320_30359[(2)] = inst_30263);

(statearr_30320_30359[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (15))){
var inst_30299 = (state_30315[(8)]);
var inst_30299__$1 = (state_30315[(2)]);
var inst_30300 = (inst_30299__$1 == null);
var state_30315__$1 = (function (){var statearr_30321 = state_30315;
(statearr_30321[(8)] = inst_30299__$1);

return statearr_30321;
})();
if(cljs.core.truth_(inst_30300)){
var statearr_30322_30360 = state_30315__$1;
(statearr_30322_30360[(1)] = (16));

} else {
var statearr_30323_30361 = state_30315__$1;
(statearr_30323_30361[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (21))){
var inst_30310 = (state_30315[(2)]);
var _ = (function (){var statearr_30324 = state_30315;
(statearr_30324[(4)] = cljs.core.rest((state_30315[(4)])));

return statearr_30324;
})();
var state_30315__$1 = state_30315;
var statearr_30325_30362 = state_30315__$1;
(statearr_30325_30362[(2)] = inst_30310);

(statearr_30325_30362[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (13))){
var state_30315__$1 = state_30315;
var statearr_30326_30363 = state_30315__$1;
(statearr_30326_30363[(2)] = null);

(statearr_30326_30363[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (6))){
var state_30315__$1 = state_30315;
var statearr_30327_30364 = state_30315__$1;
(statearr_30327_30364[(2)] = null);

(statearr_30327_30364[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (17))){
var inst_30299 = (state_30315[(8)]);
var inst_30303 = inst_30299.o;
var state_30315__$1 = state_30315;
var statearr_30328_30365 = state_30315__$1;
(statearr_30328_30365[(2)] = inst_30303);

(statearr_30328_30365[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (3))){
var inst_30313 = (state_30315[(2)]);
var state_30315__$1 = state_30315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30315__$1,inst_30313);
} else {
if((state_val_30316 === (12))){
var inst_30290 = (state_30315[(2)]);
var inst_30291 = fluree.db.util.async.throw_err(inst_30290);
var state_30315__$1 = state_30315;
var statearr_30329_30366 = state_30315__$1;
(statearr_30329_30366[(2)] = inst_30291);

(statearr_30329_30366[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (2))){
var inst_30270 = (state_30315[(7)]);
var _ = (function (){var statearr_30330 = state_30315;
(statearr_30330[(4)] = cljs.core.cons((5),(state_30315[(4)])));

return statearr_30330;
})();
var inst_30270__$1 = fluree.db.dbproto._rootdb(db);
var inst_30271 = (inst_30270__$1 == null);
var state_30315__$1 = (function (){var statearr_30331 = state_30315;
(statearr_30331[(7)] = inst_30270__$1);

return statearr_30331;
})();
if(cljs.core.truth_(inst_30271)){
var statearr_30332_30367 = state_30315__$1;
(statearr_30332_30367[(1)] = (6));

} else {
var statearr_30333_30368 = state_30315__$1;
(statearr_30333_30368[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (19))){
var inst_30305 = (state_30315[(9)]);
var state_30315__$1 = state_30315;
var statearr_30334_30369 = state_30315__$1;
(statearr_30334_30369[(2)] = inst_30305);

(statearr_30334_30369[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (11))){
var inst_30293 = (state_30315[(10)]);
var inst_30293__$1 = (state_30315[(2)]);
var inst_30294 = (inst_30293__$1 == null);
var state_30315__$1 = (function (){var statearr_30336 = state_30315;
(statearr_30336[(10)] = inst_30293__$1);

return statearr_30336;
})();
if(cljs.core.truth_(inst_30294)){
var statearr_30337_30370 = state_30315__$1;
(statearr_30337_30370[(1)] = (13));

} else {
var statearr_30338_30371 = state_30315__$1;
(statearr_30338_30371[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (9))){
var state_30315__$1 = state_30315;
var statearr_30339_30372 = state_30315__$1;
(statearr_30339_30372[(2)] = null);

(statearr_30339_30372[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (5))){
var _ = (function (){var statearr_30340 = state_30315;
(statearr_30340[(4)] = cljs.core.rest((state_30315[(4)])));

return statearr_30340;
})();
var state_30315__$1 = state_30315;
var ex30335 = (state_30315__$1[(2)]);
var statearr_30341_30373 = state_30315__$1;
(statearr_30341_30373[(5)] = ex30335);


if((ex30335 instanceof Error)){
var statearr_30342_30374 = state_30315__$1;
(statearr_30342_30374[(1)] = (4));

(statearr_30342_30374[(5)] = null);

} else {
throw ex30335;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (14))){
var inst_30293 = (state_30315[(10)]);
var inst_30297 = cljs.core.first(inst_30293);
var state_30315__$1 = state_30315;
var statearr_30343_30375 = state_30315__$1;
(statearr_30343_30375[(2)] = inst_30297);

(statearr_30343_30375[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (16))){
var state_30315__$1 = state_30315;
var statearr_30344_30376 = state_30315__$1;
(statearr_30344_30376[(2)] = null);

(statearr_30344_30376[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (10))){
var inst_30285 = (state_30315[(11)]);
var state_30315__$1 = state_30315;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30315__$1,(12),inst_30285);
} else {
if((state_val_30316 === (18))){
var inst_30305 = (state_30315[(9)]);
var inst_30305__$1 = (state_30315[(2)]);
var inst_30306 = (inst_30305__$1 > (1));
var state_30315__$1 = (function (){var statearr_30345 = state_30315;
(statearr_30345[(9)] = inst_30305__$1);

return statearr_30345;
})();
if(cljs.core.truth_(inst_30306)){
var statearr_30346_30377 = state_30315__$1;
(statearr_30346_30377[(1)] = (19));

} else {
var statearr_30347_30378 = state_30315__$1;
(statearr_30347_30378[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30316 === (8))){
var inst_30285 = (state_30315[(11)]);
var inst_30285__$1 = (state_30315[(2)]);
var inst_30286 = (inst_30285__$1 == null);
var state_30315__$1 = (function (){var statearr_30348 = state_30315;
(statearr_30348[(11)] = inst_30285__$1);

return statearr_30348;
})();
if(cljs.core.truth_(inst_30286)){
var statearr_30349_30379 = state_30315__$1;
(statearr_30349_30379[(1)] = (9));

} else {
var statearr_30350_30380 = state_30315__$1;
(statearr_30350_30380[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$t_to_block_$_state_machine__14778__auto__ = null;
var fluree$db$time_travel$t_to_block_$_state_machine__14778__auto____0 = (function (){
var statearr_30351 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30351[(0)] = fluree$db$time_travel$t_to_block_$_state_machine__14778__auto__);

(statearr_30351[(1)] = (1));

return statearr_30351;
});
var fluree$db$time_travel$t_to_block_$_state_machine__14778__auto____1 = (function (state_30315){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_30315);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e30352){var ex__14781__auto__ = e30352;
var statearr_30353_30381 = state_30315;
(statearr_30353_30381[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_30315[(4)]))){
var statearr_30354_30382 = state_30315;
(statearr_30354_30382[(1)] = cljs.core.first((state_30315[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__30383 = state_30315;
state_30315 = G__30383;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$time_travel$t_to_block_$_state_machine__14778__auto__ = function(state_30315){
switch(arguments.length){
case 0:
return fluree$db$time_travel$t_to_block_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$time_travel$t_to_block_$_state_machine__14778__auto____1.call(this,state_30315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$t_to_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$t_to_block_$_state_machine__14778__auto____0;
fluree$db$time_travel$t_to_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$t_to_block_$_state_machine__14778__auto____1;
return fluree$db$time_travel$t_to_block_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_30355 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_30355[(6)] = c__14852__auto__);

return statearr_30355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns the block that any given 't' is contained within.
 */
fluree.db.time_travel.non_border_t_to_block = (function fluree$db$time_travel$non_border_t_to_block(db,t){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_30434){
var state_val_30435 = (state_30434[(1)]);
if((state_val_30435 === (7))){
var inst_30391 = (state_30434[(7)]);
var inst_30395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30396 = [t,"_block/transactions"];
var inst_30397 = (new cljs.core.PersistentVector(null,2,(5),inst_30395,inst_30396,null));
var inst_30398 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_30391,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_30397);
var state_30434__$1 = state_30434;
var statearr_30436_30475 = state_30434__$1;
(statearr_30436_30475[(2)] = inst_30398);

(statearr_30436_30475[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (20))){
var inst_30424 = (state_30434[(8)]);
var state_30434__$1 = state_30434;
var statearr_30437_30476 = state_30434__$1;
(statearr_30437_30476[(2)] = inst_30424);

(statearr_30437_30476[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (1))){
var state_30434__$1 = state_30434;
var statearr_30438_30477 = state_30434__$1;
(statearr_30438_30477[(2)] = null);

(statearr_30438_30477[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (4))){
var inst_30384 = (state_30434[(2)]);
var state_30434__$1 = state_30434;
var statearr_30439_30478 = state_30434__$1;
(statearr_30439_30478[(2)] = inst_30384);

(statearr_30439_30478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (15))){
var inst_30414 = (state_30434[(9)]);
var inst_30414__$1 = (state_30434[(2)]);
var inst_30415 = (inst_30414__$1 == null);
var state_30434__$1 = (function (){var statearr_30440 = state_30434;
(statearr_30440[(9)] = inst_30414__$1);

return statearr_30440;
})();
if(cljs.core.truth_(inst_30415)){
var statearr_30441_30479 = state_30434__$1;
(statearr_30441_30479[(1)] = (16));

} else {
var statearr_30442_30480 = state_30434__$1;
(statearr_30442_30480[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (21))){
var state_30434__$1 = state_30434;
var statearr_30443_30481 = state_30434__$1;
(statearr_30443_30481[(2)] = (1));

(statearr_30443_30481[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (13))){
var state_30434__$1 = state_30434;
var statearr_30444_30482 = state_30434__$1;
(statearr_30444_30482[(2)] = null);

(statearr_30444_30482[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (22))){
var inst_30429 = (state_30434[(2)]);
var _ = (function (){var statearr_30445 = state_30434;
(statearr_30445[(4)] = cljs.core.rest((state_30434[(4)])));

return statearr_30445;
})();
var state_30434__$1 = state_30434;
var statearr_30446_30483 = state_30434__$1;
(statearr_30446_30483[(2)] = inst_30429);

(statearr_30446_30483[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (6))){
var state_30434__$1 = state_30434;
var statearr_30447_30484 = state_30434__$1;
(statearr_30447_30484[(2)] = null);

(statearr_30447_30484[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (17))){
var inst_30414 = (state_30434[(9)]);
var inst_30418 = inst_30414.s;
var state_30434__$1 = state_30434;
var statearr_30448_30485 = state_30434__$1;
(statearr_30448_30485[(2)] = inst_30418);

(statearr_30448_30485[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (3))){
var inst_30432 = (state_30434[(2)]);
var state_30434__$1 = state_30434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30434__$1,inst_30432);
} else {
if((state_val_30435 === (12))){
var inst_30405 = (state_30434[(2)]);
var inst_30406 = fluree.db.util.async.throw_err(inst_30405);
var state_30434__$1 = state_30434;
var statearr_30449_30486 = state_30434__$1;
(statearr_30449_30486[(2)] = inst_30406);

(statearr_30449_30486[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (2))){
var inst_30391 = (state_30434[(7)]);
var _ = (function (){var statearr_30450 = state_30434;
(statearr_30450[(4)] = cljs.core.cons((5),(state_30434[(4)])));

return statearr_30450;
})();
var inst_30391__$1 = fluree.db.dbproto._rootdb(db);
var inst_30392 = (inst_30391__$1 == null);
var state_30434__$1 = (function (){var statearr_30451 = state_30434;
(statearr_30451[(7)] = inst_30391__$1);

return statearr_30451;
})();
if(cljs.core.truth_(inst_30392)){
var statearr_30452_30487 = state_30434__$1;
(statearr_30452_30487[(1)] = (6));

} else {
var statearr_30453_30488 = state_30434__$1;
(statearr_30453_30488[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (19))){
var inst_30424 = (state_30434[(8)]);
var inst_30423 = (state_30434[(2)]);
var inst_30424__$1 = fluree.db.util.async.throw_err(inst_30423);
var inst_30425 = (inst_30424__$1 > (1));
var state_30434__$1 = (function (){var statearr_30454 = state_30434;
(statearr_30454[(8)] = inst_30424__$1);

return statearr_30454;
})();
if(cljs.core.truth_(inst_30425)){
var statearr_30455_30489 = state_30434__$1;
(statearr_30455_30489[(1)] = (20));

} else {
var statearr_30456_30490 = state_30434__$1;
(statearr_30456_30490[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (11))){
var inst_30408 = (state_30434[(10)]);
var inst_30408__$1 = (state_30434[(2)]);
var inst_30409 = (inst_30408__$1 == null);
var state_30434__$1 = (function (){var statearr_30458 = state_30434;
(statearr_30458[(10)] = inst_30408__$1);

return statearr_30458;
})();
if(cljs.core.truth_(inst_30409)){
var statearr_30459_30491 = state_30434__$1;
(statearr_30459_30491[(1)] = (13));

} else {
var statearr_30460_30492 = state_30434__$1;
(statearr_30460_30492[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (9))){
var state_30434__$1 = state_30434;
var statearr_30461_30493 = state_30434__$1;
(statearr_30461_30493[(2)] = null);

(statearr_30461_30493[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (5))){
var _ = (function (){var statearr_30462 = state_30434;
(statearr_30462[(4)] = cljs.core.rest((state_30434[(4)])));

return statearr_30462;
})();
var state_30434__$1 = state_30434;
var ex30457 = (state_30434__$1[(2)]);
var statearr_30463_30494 = state_30434__$1;
(statearr_30463_30494[(5)] = ex30457);


if((ex30457 instanceof Error)){
var statearr_30464_30495 = state_30434__$1;
(statearr_30464_30495[(1)] = (4));

(statearr_30464_30495[(5)] = null);

} else {
throw ex30457;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (14))){
var inst_30408 = (state_30434[(10)]);
var inst_30412 = cljs.core.first(inst_30408);
var state_30434__$1 = state_30434;
var statearr_30465_30496 = state_30434__$1;
(statearr_30465_30496[(2)] = inst_30412);

(statearr_30465_30496[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (16))){
var state_30434__$1 = state_30434;
var statearr_30466_30497 = state_30434__$1;
(statearr_30466_30497[(2)] = null);

(statearr_30466_30497[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30435 === (10))){
var inst_30400 = (state_30434[(11)]);
var state_30434__$1 = state_30434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30434__$1,(12),inst_30400);
} else {
if((state_val_30435 === (18))){
var inst_30420 = (state_30434[(2)]);
var inst_30421 = fluree.db.time_travel.t_to_block(db,inst_30420);
var state_30434__$1 = state_30434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30434__$1,(19),inst_30421);
} else {
if((state_val_30435 === (8))){
var inst_30400 = (state_30434[(11)]);
var inst_30400__$1 = (state_30434[(2)]);
var inst_30401 = (inst_30400__$1 == null);
var state_30434__$1 = (function (){var statearr_30467 = state_30434;
(statearr_30467[(11)] = inst_30400__$1);

return statearr_30467;
})();
if(cljs.core.truth_(inst_30401)){
var statearr_30468_30498 = state_30434__$1;
(statearr_30468_30498[(1)] = (9));

} else {
var statearr_30469_30499 = state_30434__$1;
(statearr_30469_30499[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto__ = null;
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto____0 = (function (){
var statearr_30470 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30470[(0)] = fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto__);

(statearr_30470[(1)] = (1));

return statearr_30470;
});
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto____1 = (function (state_30434){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_30434);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e30471){var ex__14781__auto__ = e30471;
var statearr_30472_30500 = state_30434;
(statearr_30472_30500[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_30434[(4)]))){
var statearr_30473_30501 = state_30434;
(statearr_30473_30501[(1)] = cljs.core.first((state_30434[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__30502 = state_30434;
state_30434 = G__30502;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto__ = function(state_30434){
switch(arguments.length){
case 0:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto____1.call(this,state_30434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto____0;
fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto____1;
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_30474 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_30474[(6)] = c__14852__auto__);

return statearr_30474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns the block for a given time as a string (ISO-8601 formatted time or a duration).
 *   If a block (positive integer) is provided, returns it unmodified.
 */
fluree.db.time_travel.block_to_int_format = (function fluree$db$time_travel$block_to_int_format(db,time_str){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_30563){
var state_val_30564 = (state_30563[(1)]);
if((state_val_30564 === (7))){
var inst_30512 = (state_30563[(7)]);
var inst_30512__$1 = typeof time_str === 'string';
var state_30563__$1 = (function (){var statearr_30565 = state_30563;
(statearr_30565[(7)] = inst_30512__$1);

return statearr_30565;
})();
if(cljs.core.truth_(inst_30512__$1)){
var statearr_30566_30600 = state_30563__$1;
(statearr_30566_30600[(1)] = (9));

} else {
var statearr_30567_30601 = state_30563__$1;
(statearr_30567_30601[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (20))){
var inst_30535 = (state_30563[(2)]);
var inst_30536 = fluree.db.util.async.throw_err(inst_30535);
var inst_30537 = fluree.db.time_travel.t_to_block(db,inst_30536);
var state_30563__$1 = state_30563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30563__$1,(21),inst_30537);
} else {
if((state_val_30564 === (1))){
var state_30563__$1 = state_30563;
var statearr_30568_30602 = state_30563__$1;
(statearr_30568_30602[(2)] = null);

(statearr_30568_30602[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (24))){
var inst_30552 = (state_30563[(2)]);
var state_30563__$1 = state_30563;
var statearr_30569_30603 = state_30563__$1;
(statearr_30569_30603[(2)] = inst_30552);

(statearr_30569_30603[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (4))){
var inst_30503 = (state_30563[(2)]);
var state_30563__$1 = state_30563;
var statearr_30570_30604 = state_30563__$1;
(statearr_30570_30604[(2)] = inst_30503);

(statearr_30570_30604[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (15))){
var inst_30524 = (state_30563[(2)]);
var inst_30525 = fluree.db.util.async.throw_err(inst_30524);
var inst_30526 = fluree.db.time_travel.t_to_block(db,inst_30525);
var state_30563__$1 = state_30563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30563__$1,(16),inst_30526);
} else {
if((state_val_30564 === (21))){
var inst_30539 = (state_30563[(2)]);
var inst_30540 = fluree.db.util.async.throw_err(inst_30539);
var state_30563__$1 = state_30563;
var statearr_30571_30605 = state_30563__$1;
(statearr_30571_30605[(2)] = inst_30540);

(statearr_30571_30605[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (13))){
var inst_30531 = typeof time_str === 'string';
var state_30563__$1 = state_30563;
if(cljs.core.truth_(inst_30531)){
var statearr_30572_30606 = state_30563__$1;
(statearr_30572_30606[(1)] = (17));

} else {
var statearr_30573_30607 = state_30563__$1;
(statearr_30573_30607[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (22))){
var inst_30543 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([time_str], 0));
var inst_30544 = ["Invalid block key provided: ",inst_30543].join('');
var inst_30545 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30546 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_30547 = cljs.core.PersistentHashMap.fromArrays(inst_30545,inst_30546);
var inst_30548 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30544,inst_30547);
var inst_30549 = (function(){throw inst_30548})();
var state_30563__$1 = state_30563;
var statearr_30574_30608 = state_30563__$1;
(statearr_30574_30608[(2)] = inst_30549);

(statearr_30574_30608[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (6))){
var state_30563__$1 = state_30563;
var statearr_30575_30609 = state_30563__$1;
(statearr_30575_30609[(2)] = time_str);

(statearr_30575_30609[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (17))){
var inst_30533 = fluree.db.time_travel.time_to_t(db,time_str);
var state_30563__$1 = state_30563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30563__$1,(20),inst_30533);
} else {
if((state_val_30564 === (3))){
var inst_30561 = (state_30563[(2)]);
var state_30563__$1 = state_30563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30563__$1,inst_30561);
} else {
if((state_val_30564 === (12))){
var inst_30521 = fluree.db.time_travel.duration_parse(time_str);
var inst_30522 = fluree.db.time_travel.time_to_t(db,inst_30521);
var state_30563__$1 = state_30563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30563__$1,(15),inst_30522);
} else {
if((state_val_30564 === (2))){
var _ = (function (){var statearr_30576 = state_30563;
(statearr_30576[(4)] = cljs.core.cons((5),(state_30563[(4)])));

return statearr_30576;
})();
var inst_30509 = cljs.core.pos_int_QMARK_(time_str);
var state_30563__$1 = state_30563;
if(inst_30509){
var statearr_30577_30610 = state_30563__$1;
(statearr_30577_30610[(1)] = (6));

} else {
var statearr_30578_30611 = state_30563__$1;
(statearr_30578_30611[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (23))){
var state_30563__$1 = state_30563;
var statearr_30579_30612 = state_30563__$1;
(statearr_30579_30612[(2)] = null);

(statearr_30579_30612[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (19))){
var inst_30554 = (state_30563[(2)]);
var state_30563__$1 = state_30563;
var statearr_30580_30613 = state_30563__$1;
(statearr_30580_30613[(2)] = inst_30554);

(statearr_30580_30613[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (11))){
var inst_30519 = (state_30563[(2)]);
var state_30563__$1 = state_30563;
if(cljs.core.truth_(inst_30519)){
var statearr_30582_30614 = state_30563__$1;
(statearr_30582_30614[(1)] = (12));

} else {
var statearr_30583_30615 = state_30563__$1;
(statearr_30583_30615[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (9))){
var inst_30514 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(time_str,(0));
var inst_30515 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30514);
var inst_30516 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_30515);
var state_30563__$1 = state_30563;
var statearr_30584_30616 = state_30563__$1;
(statearr_30584_30616[(2)] = inst_30516);

(statearr_30584_30616[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (5))){
var _ = (function (){var statearr_30585 = state_30563;
(statearr_30585[(4)] = cljs.core.rest((state_30563[(4)])));

return statearr_30585;
})();
var state_30563__$1 = state_30563;
var ex30581 = (state_30563__$1[(2)]);
var statearr_30586_30617 = state_30563__$1;
(statearr_30586_30617[(5)] = ex30581);


if((ex30581 instanceof Error)){
var statearr_30587_30618 = state_30563__$1;
(statearr_30587_30618[(1)] = (4));

(statearr_30587_30618[(5)] = null);

} else {
throw ex30581;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (14))){
var inst_30556 = (state_30563[(2)]);
var state_30563__$1 = state_30563;
var statearr_30588_30619 = state_30563__$1;
(statearr_30588_30619[(2)] = inst_30556);

(statearr_30588_30619[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (16))){
var inst_30528 = (state_30563[(2)]);
var inst_30529 = fluree.db.util.async.throw_err(inst_30528);
var state_30563__$1 = state_30563;
var statearr_30589_30620 = state_30563__$1;
(statearr_30589_30620[(2)] = inst_30529);

(statearr_30589_30620[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (10))){
var inst_30512 = (state_30563[(7)]);
var state_30563__$1 = state_30563;
var statearr_30590_30621 = state_30563__$1;
(statearr_30590_30621[(2)] = inst_30512);

(statearr_30590_30621[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (18))){
var state_30563__$1 = state_30563;
var statearr_30591_30622 = state_30563__$1;
(statearr_30591_30622[(1)] = (22));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30564 === (8))){
var inst_30558 = (state_30563[(2)]);
var _ = (function (){var statearr_30593 = state_30563;
(statearr_30593[(4)] = cljs.core.rest((state_30563[(4)])));

return statearr_30593;
})();
var state_30563__$1 = state_30563;
var statearr_30594_30623 = state_30563__$1;
(statearr_30594_30623[(2)] = inst_30558);

(statearr_30594_30623[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto__ = null;
var fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto____0 = (function (){
var statearr_30595 = [null,null,null,null,null,null,null,null];
(statearr_30595[(0)] = fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto__);

(statearr_30595[(1)] = (1));

return statearr_30595;
});
var fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto____1 = (function (state_30563){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_30563);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e30596){var ex__14781__auto__ = e30596;
var statearr_30597_30624 = state_30563;
(statearr_30597_30624[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_30563[(4)]))){
var statearr_30598_30625 = state_30563;
(statearr_30598_30625[(1)] = cljs.core.first((state_30563[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__30626 = state_30563;
state_30563 = G__30626;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto__ = function(state_30563){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto____1.call(this,state_30563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto____0;
fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto____1;
return fluree$db$time_travel$block_to_int_format_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_30599 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_30599[(6)] = c__14852__auto__);

return statearr_30599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Given a positive integer block, returns the t (negative integer) associated.
 *   If block does not exist, throws.
 */
fluree.db.time_travel.block_to_t = (function fluree$db$time_travel$block_to_t(db,block){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_30679){
var state_val_30680 = (state_30679[(1)]);
if((state_val_30680 === (7))){
var inst_30634 = (state_30679[(7)]);
var inst_30638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30639 = ["_block/number",block];
var inst_30640 = (new cljs.core.PersistentVector(null,2,(5),inst_30638,inst_30639,null));
var inst_30641 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_30634,cljs.core.cst$kw$post,cljs.core._EQ_,inst_30640);
var state_30679__$1 = state_30679;
var statearr_30681_30721 = state_30679__$1;
(statearr_30681_30721[(2)] = inst_30641);

(statearr_30681_30721[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (20))){
var inst_30666 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block], 0));
var inst_30667 = ["Invalid block key provided: ",inst_30666].join('');
var inst_30668 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30669 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_30670 = cljs.core.PersistentHashMap.fromArrays(inst_30668,inst_30669);
var inst_30671 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30667,inst_30670);
var inst_30672 = (function(){throw inst_30671})();
var state_30679__$1 = state_30679;
var statearr_30682_30722 = state_30679__$1;
(statearr_30682_30722[(2)] = inst_30672);

(statearr_30682_30722[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (1))){
var state_30679__$1 = state_30679;
var statearr_30683_30723 = state_30679__$1;
(statearr_30683_30723[(2)] = null);

(statearr_30683_30723[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (4))){
var inst_30627 = (state_30679[(2)]);
var state_30679__$1 = state_30679;
var statearr_30684_30724 = state_30679__$1;
(statearr_30684_30724[(2)] = inst_30627);

(statearr_30684_30724[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (15))){
var inst_30657 = (state_30679[(8)]);
var inst_30657__$1 = (state_30679[(2)]);
var inst_30658 = (inst_30657__$1 == null);
var state_30679__$1 = (function (){var statearr_30685 = state_30679;
(statearr_30685[(8)] = inst_30657__$1);

return statearr_30685;
})();
if(cljs.core.truth_(inst_30658)){
var statearr_30686_30725 = state_30679__$1;
(statearr_30686_30725[(1)] = (16));

} else {
var statearr_30687_30726 = state_30679__$1;
(statearr_30687_30726[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (21))){
var inst_30663 = (state_30679[(9)]);
var inst_30674 = (state_30679[(2)]);
var _ = (function (){var statearr_30688 = state_30679;
(statearr_30688[(4)] = cljs.core.rest((state_30679[(4)])));

return statearr_30688;
})();
var state_30679__$1 = (function (){var statearr_30689 = state_30679;
(statearr_30689[(10)] = inst_30674);

return statearr_30689;
})();
var statearr_30690_30727 = state_30679__$1;
(statearr_30690_30727[(2)] = inst_30663);

(statearr_30690_30727[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (13))){
var state_30679__$1 = state_30679;
var statearr_30691_30728 = state_30679__$1;
(statearr_30691_30728[(2)] = null);

(statearr_30691_30728[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (6))){
var state_30679__$1 = state_30679;
var statearr_30692_30729 = state_30679__$1;
(statearr_30692_30729[(2)] = null);

(statearr_30692_30729[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (17))){
var inst_30657 = (state_30679[(8)]);
var inst_30661 = inst_30657.t;
var state_30679__$1 = state_30679;
var statearr_30693_30730 = state_30679__$1;
(statearr_30693_30730[(2)] = inst_30661);

(statearr_30693_30730[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (3))){
var inst_30677 = (state_30679[(2)]);
var state_30679__$1 = state_30679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30679__$1,inst_30677);
} else {
if((state_val_30680 === (12))){
var inst_30648 = (state_30679[(2)]);
var inst_30649 = fluree.db.util.async.throw_err(inst_30648);
var state_30679__$1 = state_30679;
var statearr_30694_30731 = state_30679__$1;
(statearr_30694_30731[(2)] = inst_30649);

(statearr_30694_30731[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (2))){
var inst_30634 = (state_30679[(7)]);
var _ = (function (){var statearr_30695 = state_30679;
(statearr_30695[(4)] = cljs.core.cons((5),(state_30679[(4)])));

return statearr_30695;
})();
var inst_30634__$1 = fluree.db.dbproto._rootdb(db);
var inst_30635 = (inst_30634__$1 == null);
var state_30679__$1 = (function (){var statearr_30696 = state_30679;
(statearr_30696[(7)] = inst_30634__$1);

return statearr_30696;
})();
if(cljs.core.truth_(inst_30635)){
var statearr_30697_30732 = state_30679__$1;
(statearr_30697_30732[(1)] = (6));

} else {
var statearr_30698_30733 = state_30679__$1;
(statearr_30698_30733[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (19))){
var state_30679__$1 = state_30679;
var statearr_30699_30734 = state_30679__$1;
(statearr_30699_30734[(2)] = null);

(statearr_30699_30734[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (11))){
var inst_30651 = (state_30679[(11)]);
var inst_30651__$1 = (state_30679[(2)]);
var inst_30652 = (inst_30651__$1 == null);
var state_30679__$1 = (function (){var statearr_30701 = state_30679;
(statearr_30701[(11)] = inst_30651__$1);

return statearr_30701;
})();
if(cljs.core.truth_(inst_30652)){
var statearr_30702_30735 = state_30679__$1;
(statearr_30702_30735[(1)] = (13));

} else {
var statearr_30703_30736 = state_30679__$1;
(statearr_30703_30736[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (9))){
var state_30679__$1 = state_30679;
var statearr_30704_30737 = state_30679__$1;
(statearr_30704_30737[(2)] = null);

(statearr_30704_30737[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (5))){
var _ = (function (){var statearr_30705 = state_30679;
(statearr_30705[(4)] = cljs.core.rest((state_30679[(4)])));

return statearr_30705;
})();
var state_30679__$1 = state_30679;
var ex30700 = (state_30679__$1[(2)]);
var statearr_30706_30738 = state_30679__$1;
(statearr_30706_30738[(5)] = ex30700);


if((ex30700 instanceof Error)){
var statearr_30707_30739 = state_30679__$1;
(statearr_30707_30739[(1)] = (4));

(statearr_30707_30739[(5)] = null);

} else {
throw ex30700;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (14))){
var inst_30651 = (state_30679[(11)]);
var inst_30655 = cljs.core.first(inst_30651);
var state_30679__$1 = state_30679;
var statearr_30708_30740 = state_30679__$1;
(statearr_30708_30740[(2)] = inst_30655);

(statearr_30708_30740[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (16))){
var state_30679__$1 = state_30679;
var statearr_30709_30741 = state_30679__$1;
(statearr_30709_30741[(2)] = null);

(statearr_30709_30741[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (10))){
var inst_30643 = (state_30679[(12)]);
var state_30679__$1 = state_30679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30679__$1,(12),inst_30643);
} else {
if((state_val_30680 === (18))){
var inst_30663 = (state_30679[(9)]);
var inst_30663__$1 = (state_30679[(2)]);
var state_30679__$1 = (function (){var statearr_30710 = state_30679;
(statearr_30710[(9)] = inst_30663__$1);

return statearr_30710;
})();
if(cljs.core.truth_(inst_30663__$1)){
var statearr_30711_30742 = state_30679__$1;
(statearr_30711_30742[(1)] = (19));

} else {
var statearr_30712_30743 = state_30679__$1;
(statearr_30712_30743[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30680 === (8))){
var inst_30643 = (state_30679[(12)]);
var inst_30643__$1 = (state_30679[(2)]);
var inst_30644 = (inst_30643__$1 == null);
var state_30679__$1 = (function (){var statearr_30713 = state_30679;
(statearr_30713[(12)] = inst_30643__$1);

return statearr_30713;
})();
if(cljs.core.truth_(inst_30644)){
var statearr_30714_30744 = state_30679__$1;
(statearr_30714_30744[(1)] = (9));

} else {
var statearr_30715_30745 = state_30679__$1;
(statearr_30715_30745[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$block_to_t_$_state_machine__14778__auto__ = null;
var fluree$db$time_travel$block_to_t_$_state_machine__14778__auto____0 = (function (){
var statearr_30716 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30716[(0)] = fluree$db$time_travel$block_to_t_$_state_machine__14778__auto__);

(statearr_30716[(1)] = (1));

return statearr_30716;
});
var fluree$db$time_travel$block_to_t_$_state_machine__14778__auto____1 = (function (state_30679){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_30679);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e30717){var ex__14781__auto__ = e30717;
var statearr_30718_30746 = state_30679;
(statearr_30718_30746[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_30679[(4)]))){
var statearr_30719_30747 = state_30679;
(statearr_30719_30747[(1)] = cljs.core.first((state_30679[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__30748 = state_30679;
state_30679 = G__30748;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_t_$_state_machine__14778__auto__ = function(state_30679){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_t_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_t_$_state_machine__14778__auto____1.call(this,state_30679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_t_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_t_$_state_machine__14778__auto____0;
fluree$db$time_travel$block_to_t_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_t_$_state_machine__14778__auto____1;
return fluree$db$time_travel$block_to_t_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_30720 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_30720[(6)] = c__14852__auto__);

return statearr_30720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Takes any time value: block, ISO-8601 time or duration string, or t
 *   and returns the exact 't' as of that value into a core async channel.
 */
fluree.db.time_travel.to_t = (function fluree$db$time_travel$to_t(db,block_or_t_or_time){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_30819){
var state_val_30820 = (state_30819[(1)]);
if((state_val_30820 === (7))){
var state_30819__$1 = state_30819;
var statearr_30821_30866 = state_30819__$1;
(statearr_30821_30866[(2)] = null);

(statearr_30821_30866[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (20))){
var inst_30810 = (state_30819[(2)]);
var state_30819__$1 = state_30819;
var statearr_30822_30867 = state_30819__$1;
(statearr_30822_30867[(2)] = inst_30810);

(statearr_30822_30867[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (27))){
var state_30819__$1 = state_30819;
var statearr_30823_30868 = state_30819__$1;
(statearr_30823_30868[(2)] = null);

(statearr_30823_30868[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (1))){
var state_30819__$1 = state_30819;
var statearr_30824_30869 = state_30819__$1;
(statearr_30824_30869[(2)] = null);

(statearr_30824_30869[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (24))){
var inst_30788 = (state_30819[(2)]);
var inst_30789 = fluree.db.util.async.throw_err(inst_30788);
var state_30819__$1 = state_30819;
var statearr_30825_30870 = state_30819__$1;
(statearr_30825_30870[(2)] = inst_30789);

(statearr_30825_30870[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (4))){
var inst_30749 = (state_30819[(2)]);
var state_30819__$1 = state_30819;
var statearr_30826_30871 = state_30819__$1;
(statearr_30826_30871[(2)] = inst_30749);

(statearr_30826_30871[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (15))){
var state_30819__$1 = state_30819;
var statearr_30828_30872 = state_30819__$1;
(statearr_30828_30872[(2)] = block_or_t_or_time);

(statearr_30828_30872[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (21))){
var inst_30758 = (state_30819[(7)]);
var inst_30785 = fluree.db.time_travel.duration_parse(block_or_t_or_time);
var inst_30786 = fluree.db.time_travel.time_to_t(inst_30758,inst_30785);
var state_30819__$1 = state_30819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30819__$1,(24),inst_30786);
} else {
if((state_val_30820 === (13))){
var _ = (function (){var statearr_30829 = state_30819;
(statearr_30829[(4)] = cljs.core.rest((state_30819[(4)])));

return statearr_30829;
})();
var state_30819__$1 = state_30819;
var ex30827 = (state_30819__$1[(2)]);
var statearr_30830_30873 = state_30819__$1;
(statearr_30830_30873[(5)] = ex30827);


var statearr_30831_30874 = state_30819__$1;
(statearr_30831_30874[(1)] = (12));

(statearr_30831_30874[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (22))){
var inst_30758 = (state_30819[(7)]);
var inst_30791 = fluree.db.time_travel.time_to_t(inst_30758,block_or_t_or_time);
var state_30819__$1 = state_30819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30819__$1,(25),inst_30791);
} else {
if((state_val_30820 === (6))){
var inst_30757 = (state_30819[(2)]);
var inst_30758 = fluree.db.util.async.throw_err(inst_30757);
var inst_30759 = cljs.core.pos_int_QMARK_(block_or_t_or_time);
var state_30819__$1 = (function (){var statearr_30832 = state_30819;
(statearr_30832[(7)] = inst_30758);

return statearr_30832;
})();
if(inst_30759){
var statearr_30833_30875 = state_30819__$1;
(statearr_30833_30875[(1)] = (7));

} else {
var statearr_30834_30876 = state_30819__$1;
(statearr_30834_30876[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (28))){
var inst_30808 = (state_30819[(2)]);
var state_30819__$1 = state_30819;
var statearr_30835_30877 = state_30819__$1;
(statearr_30835_30877[(2)] = inst_30808);

(statearr_30835_30877[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (25))){
var inst_30793 = (state_30819[(2)]);
var inst_30794 = fluree.db.util.async.throw_err(inst_30793);
var state_30819__$1 = state_30819;
var statearr_30836_30878 = state_30819__$1;
(statearr_30836_30878[(2)] = inst_30794);

(statearr_30836_30878[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (17))){
var inst_30812 = (state_30819[(2)]);
var state_30819__$1 = state_30819;
var statearr_30837_30879 = state_30819__$1;
(statearr_30837_30879[(2)] = inst_30812);

(statearr_30837_30879[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (3))){
var inst_30817 = (state_30819[(2)]);
var state_30819__$1 = state_30819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30819__$1,inst_30817);
} else {
if((state_val_30820 === (12))){
var inst_30758 = (state_30819[(7)]);
var inst_30761 = (state_30819[(2)]);
var inst_30762 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_30758);
var state_30819__$1 = (function (){var statearr_30838 = state_30819;
(statearr_30838[(8)] = inst_30761);

return statearr_30838;
})();
var statearr_30839_30880 = state_30819__$1;
(statearr_30839_30880[(2)] = inst_30762);

(statearr_30839_30880[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (2))){
var _ = (function (){var statearr_30840 = state_30819;
(statearr_30840[(4)] = cljs.core.cons((5),(state_30819[(4)])));

return statearr_30840;
})();
var inst_30755 = fluree.db.dbproto._latest_db(db);
var state_30819__$1 = state_30819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30819__$1,(6),inst_30755);
} else {
if((state_val_30820 === (23))){
var inst_30796 = (state_30819[(2)]);
var state_30819__$1 = state_30819;
var statearr_30841_30881 = state_30819__$1;
(statearr_30841_30881[(2)] = inst_30796);

(statearr_30841_30881[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (19))){
var state_30819__$1 = state_30819;
var statearr_30842_30882 = state_30819__$1;
(statearr_30842_30882[(1)] = (26));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (11))){
var inst_30774 = (state_30819[(2)]);
var state_30819__$1 = state_30819;
var statearr_30845_30883 = state_30819__$1;
(statearr_30845_30883[(2)] = inst_30774);

(statearr_30845_30883[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (9))){
var inst_30814 = (state_30819[(2)]);
var _ = (function (){var statearr_30846 = state_30819;
(statearr_30846[(4)] = cljs.core.rest((state_30819[(4)])));

return statearr_30846;
})();
var state_30819__$1 = state_30819;
var statearr_30847_30884 = state_30819__$1;
(statearr_30847_30884[(2)] = inst_30814);

(statearr_30847_30884[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (5))){
var _ = (function (){var statearr_30848 = state_30819;
(statearr_30848[(4)] = cljs.core.rest((state_30819[(4)])));

return statearr_30848;
})();
var state_30819__$1 = state_30819;
var ex30844 = (state_30819__$1[(2)]);
var statearr_30849_30885 = state_30819__$1;
(statearr_30849_30885[(5)] = ex30844);


if((ex30844 instanceof Error)){
var statearr_30850_30886 = state_30819__$1;
(statearr_30850_30886[(1)] = (4));

(statearr_30850_30886[(5)] = null);

} else {
throw ex30844;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (14))){
var inst_30770 = (state_30819[(2)]);
var inst_30771 = fluree.db.util.async.throw_err(inst_30770);
var _ = (function (){var statearr_30851 = state_30819;
(statearr_30851[(4)] = cljs.core.rest((state_30819[(4)])));

return statearr_30851;
})();
var state_30819__$1 = state_30819;
var statearr_30852_30887 = state_30819__$1;
(statearr_30852_30887[(2)] = inst_30771);

(statearr_30852_30887[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (26))){
var inst_30799 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_or_t_or_time], 0));
var inst_30800 = ["Invalid time value provided: ",inst_30799].join('');
var inst_30801 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30802 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_30803 = cljs.core.PersistentHashMap.fromArrays(inst_30801,inst_30802);
var inst_30804 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30800,inst_30803);
var inst_30805 = (function(){throw inst_30804})();
var state_30819__$1 = state_30819;
var statearr_30853_30888 = state_30819__$1;
(statearr_30853_30888[(2)] = inst_30805);

(statearr_30853_30888[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (16))){
var inst_30779 = typeof block_or_t_or_time === 'string';
var state_30819__$1 = state_30819;
if(cljs.core.truth_(inst_30779)){
var statearr_30854_30889 = state_30819__$1;
(statearr_30854_30889[(1)] = (18));

} else {
var statearr_30855_30890 = state_30819__$1;
(statearr_30855_30890[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (10))){
var inst_30758 = (state_30819[(7)]);
var _ = (function (){var statearr_30856 = state_30819;
(statearr_30856[(4)] = cljs.core.cons((13),(state_30819[(4)])));

return statearr_30856;
})();
var inst_30768 = fluree.db.time_travel.block_to_t(inst_30758,block_or_t_or_time);
var state_30819__$1 = state_30819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30819__$1,(14),inst_30768);
} else {
if((state_val_30820 === (18))){
var inst_30781 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(block_or_t_or_time,(0));
var inst_30782 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30781);
var inst_30783 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_30782);
var state_30819__$1 = state_30819;
if(inst_30783){
var statearr_30857_30891 = state_30819__$1;
(statearr_30857_30891[(1)] = (21));

} else {
var statearr_30858_30892 = state_30819__$1;
(statearr_30858_30892[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30820 === (8))){
var inst_30776 = cljs.core.neg_int_QMARK_(block_or_t_or_time);
var state_30819__$1 = state_30819;
if(inst_30776){
var statearr_30859_30893 = state_30819__$1;
(statearr_30859_30893[(1)] = (15));

} else {
var statearr_30860_30894 = state_30819__$1;
(statearr_30860_30894[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$to_t_$_state_machine__14778__auto__ = null;
var fluree$db$time_travel$to_t_$_state_machine__14778__auto____0 = (function (){
var statearr_30861 = [null,null,null,null,null,null,null,null,null];
(statearr_30861[(0)] = fluree$db$time_travel$to_t_$_state_machine__14778__auto__);

(statearr_30861[(1)] = (1));

return statearr_30861;
});
var fluree$db$time_travel$to_t_$_state_machine__14778__auto____1 = (function (state_30819){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_30819);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e30862){var ex__14781__auto__ = e30862;
var statearr_30863_30895 = state_30819;
(statearr_30863_30895[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_30819[(4)]))){
var statearr_30864_30896 = state_30819;
(statearr_30864_30896[(1)] = cljs.core.first((state_30819[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__30897 = state_30819;
state_30819 = G__30897;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$time_travel$to_t_$_state_machine__14778__auto__ = function(state_30819){
switch(arguments.length){
case 0:
return fluree$db$time_travel$to_t_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$time_travel$to_t_$_state_machine__14778__auto____1.call(this,state_30819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$to_t_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$to_t_$_state_machine__14778__auto____0;
fluree$db$time_travel$to_t_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$to_t_$_state_machine__14778__auto____1;
return fluree$db$time_travel$to_t_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_30865 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_30865[(6)] = c__14852__auto__);

return statearr_30865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Gets the database as-of a specified block. Either block number or a time string in ISO-8601 format.
 *   Returns db as a promise channel
 */
fluree.db.time_travel.as_of_block = (function fluree$db$time_travel$as_of_block(db,block_or_t_or_time){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__14852__auto___30941 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_30923){
var state_val_30924 = (state_30923[(1)]);
if((state_val_30924 === (1))){
var state_30923__$1 = state_30923;
var statearr_30925_30942 = state_30923__$1;
(statearr_30925_30942[(2)] = null);

(statearr_30925_30942[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30924 === (2))){
var _ = (function (){var statearr_30926 = state_30923;
(statearr_30926[(4)] = cljs.core.cons((5),(state_30923[(4)])));

return statearr_30926;
})();
var inst_30905 = fluree.db.dbproto._latest_db(db);
var state_30923__$1 = state_30923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30923__$1,(6),inst_30905);
} else {
if((state_val_30924 === (3))){
var inst_30921 = (state_30923[(2)]);
var state_30923__$1 = state_30923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30923__$1,inst_30921);
} else {
if((state_val_30924 === (4))){
var inst_30898 = (state_30923[(2)]);
var inst_30899 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_30898);
var state_30923__$1 = state_30923;
var statearr_30928_30943 = state_30923__$1;
(statearr_30928_30943[(2)] = inst_30899);

(statearr_30928_30943[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30924 === (5))){
var _ = (function (){var statearr_30929 = state_30923;
(statearr_30929[(4)] = cljs.core.rest((state_30923[(4)])));

return statearr_30929;
})();
var state_30923__$1 = state_30923;
var ex30927 = (state_30923__$1[(2)]);
var statearr_30930_30944 = state_30923__$1;
(statearr_30930_30944[(5)] = ex30927);


var statearr_30931_30945 = state_30923__$1;
(statearr_30931_30945[(1)] = (4));

(statearr_30931_30945[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30924 === (6))){
var inst_30908 = (state_30923[(7)]);
var inst_30907 = (state_30923[(2)]);
var inst_30908__$1 = fluree.db.util.async.throw_err(inst_30907);
var inst_30909 = fluree.db.time_travel.to_t(inst_30908__$1,block_or_t_or_time);
var state_30923__$1 = (function (){var statearr_30932 = state_30923;
(statearr_30932[(7)] = inst_30908__$1);

return statearr_30932;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30923__$1,(7),inst_30909);
} else {
if((state_val_30924 === (7))){
var inst_30908 = (state_30923[(7)]);
var inst_30912 = (state_30923[(8)]);
var inst_30911 = (state_30923[(2)]);
var inst_30912__$1 = fluree.db.util.async.throw_err(inst_30911);
var inst_30913 = fluree.db.time_travel.t_to_block(inst_30908,inst_30912__$1);
var state_30923__$1 = (function (){var statearr_30933 = state_30923;
(statearr_30933[(8)] = inst_30912__$1);

return statearr_30933;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30923__$1,(8),inst_30913);
} else {
if((state_val_30924 === (8))){
var inst_30912 = (state_30923[(8)]);
var inst_30915 = (state_30923[(2)]);
var inst_30916 = fluree.db.util.async.throw_err(inst_30915);
var inst_30917 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,cljs.core.cst$kw$t,inst_30912,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$block,inst_30916], 0));
var inst_30918 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_30917);
var _ = (function (){var statearr_30934 = state_30923;
(statearr_30934[(4)] = cljs.core.rest((state_30923[(4)])));

return statearr_30934;
})();
var state_30923__$1 = state_30923;
var statearr_30935_30946 = state_30923__$1;
(statearr_30935_30946[(2)] = inst_30918);

(statearr_30935_30946[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$as_of_block_$_state_machine__14778__auto__ = null;
var fluree$db$time_travel$as_of_block_$_state_machine__14778__auto____0 = (function (){
var statearr_30936 = [null,null,null,null,null,null,null,null,null];
(statearr_30936[(0)] = fluree$db$time_travel$as_of_block_$_state_machine__14778__auto__);

(statearr_30936[(1)] = (1));

return statearr_30936;
});
var fluree$db$time_travel$as_of_block_$_state_machine__14778__auto____1 = (function (state_30923){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_30923);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e30937){var ex__14781__auto__ = e30937;
var statearr_30938_30947 = state_30923;
(statearr_30938_30947[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_30923[(4)]))){
var statearr_30939_30948 = state_30923;
(statearr_30939_30948[(1)] = cljs.core.first((state_30923[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__30949 = state_30923;
state_30923 = G__30949;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$time_travel$as_of_block_$_state_machine__14778__auto__ = function(state_30923){
switch(arguments.length){
case 0:
return fluree$db$time_travel$as_of_block_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$time_travel$as_of_block_$_state_machine__14778__auto____1.call(this,state_30923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$as_of_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$as_of_block_$_state_machine__14778__auto____0;
fluree$db$time_travel$as_of_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$as_of_block_$_state_machine__14778__auto____1;
return fluree$db$time_travel$as_of_block_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_30940 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_30940[(6)] = c__14852__auto___30941);

return statearr_30940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return pc;
});
