// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38642){
var state_val_38643 = (state_38642[(1)]);
if((state_val_38643 === (7))){
var inst_38631 = (state_38642[(7)]);
var inst_38633 = fluree.db.storage.core.serde(conn);
var inst_38634 = fluree.db.serde.protocol._deserialize_block(inst_38633,inst_38631);
var state_38642__$1 = state_38642;
var statearr_38644_38663 = state_38642__$1;
(statearr_38644_38663[(2)] = inst_38634);

(statearr_38644_38663[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38643 === (1))){
var state_38642__$1 = state_38642;
var statearr_38645_38664 = state_38642__$1;
(statearr_38645_38664[(2)] = null);

(statearr_38645_38664[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38643 === (4))){
var inst_38621 = (state_38642[(2)]);
var state_38642__$1 = state_38642;
var statearr_38646_38665 = state_38642__$1;
(statearr_38646_38665[(2)] = inst_38621);

(statearr_38646_38665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38643 === (6))){
var inst_38631 = (state_38642[(7)]);
var inst_38630 = (state_38642[(2)]);
var inst_38631__$1 = fluree.db.util.async.throw_err(inst_38630);
var state_38642__$1 = (function (){var statearr_38647 = state_38642;
(statearr_38647[(7)] = inst_38631__$1);

return statearr_38647;
})();
if(cljs.core.truth_(inst_38631__$1)){
var statearr_38648_38666 = state_38642__$1;
(statearr_38648_38666[(1)] = (7));

} else {
var statearr_38649_38667 = state_38642__$1;
(statearr_38649_38667[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38643 === (3))){
var inst_38640 = (state_38642[(2)]);
var state_38642__$1 = state_38642;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38642__$1,inst_38640);
} else {
if((state_val_38643 === (2))){
var _ = (function (){var statearr_38651 = state_38642;
(statearr_38651[(4)] = cljs.core.cons((5),(state_38642[(4)])));

return statearr_38651;
})();
var inst_38627 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_38628 = fluree.db.storage.core.storage_read(conn,inst_38627);
var state_38642__$1 = state_38642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38642__$1,(6),inst_38628);
} else {
if((state_val_38643 === (9))){
var inst_38637 = (state_38642[(2)]);
var _ = (function (){var statearr_38652 = state_38642;
(statearr_38652[(4)] = cljs.core.rest((state_38642[(4)])));

return statearr_38652;
})();
var state_38642__$1 = state_38642;
var statearr_38653_38668 = state_38642__$1;
(statearr_38653_38668[(2)] = inst_38637);

(statearr_38653_38668[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38643 === (5))){
var _ = (function (){var statearr_38654 = state_38642;
(statearr_38654[(4)] = cljs.core.rest((state_38642[(4)])));

return statearr_38654;
})();
var state_38642__$1 = state_38642;
var ex38650 = (state_38642__$1[(2)]);
var statearr_38655_38669 = state_38642__$1;
(statearr_38655_38669[(5)] = ex38650);


if((ex38650 instanceof Error)){
var statearr_38656_38670 = state_38642__$1;
(statearr_38656_38670[(1)] = (4));

(statearr_38656_38670[(5)] = null);

} else {
throw ex38650;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38643 === (8))){
var state_38642__$1 = state_38642;
var statearr_38657_38671 = state_38642__$1;
(statearr_38657_38671[(2)] = null);

(statearr_38657_38671[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__14778__auto____0 = (function (){
var statearr_38658 = [null,null,null,null,null,null,null,null];
(statearr_38658[(0)] = fluree$db$storage$core$read_block_$_state_machine__14778__auto__);

(statearr_38658[(1)] = (1));

return statearr_38658;
});
var fluree$db$storage$core$read_block_$_state_machine__14778__auto____1 = (function (state_38642){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38642);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38659){var ex__14781__auto__ = e38659;
var statearr_38660_38672 = state_38642;
(statearr_38660_38672[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38642[(4)]))){
var statearr_38661_38673 = state_38642;
(statearr_38661_38673[(1)] = cljs.core.first((state_38642[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38674 = state_38642;
state_38642 = G__38674;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__14778__auto__ = function(state_38642){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__14778__auto____1.call(this,state_38642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__14778__auto____0;
fluree$db$storage$core$read_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__14778__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38662 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38662[(6)] = c__14852__auto__);

return statearr_38662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38697){
var state_val_38698 = (state_38697[(1)]);
if((state_val_38698 === (7))){
var inst_38686 = (state_38697[(7)]);
var inst_38688 = fluree.db.storage.core.serde(conn);
var inst_38689 = fluree.db.serde.protocol._deserialize_block(inst_38688,inst_38686);
var state_38697__$1 = state_38697;
var statearr_38699_38718 = state_38697__$1;
(statearr_38699_38718[(2)] = inst_38689);

(statearr_38699_38718[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38698 === (1))){
var state_38697__$1 = state_38697;
var statearr_38700_38719 = state_38697__$1;
(statearr_38700_38719[(2)] = null);

(statearr_38700_38719[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38698 === (4))){
var inst_38675 = (state_38697[(2)]);
var state_38697__$1 = state_38697;
var statearr_38701_38720 = state_38697__$1;
(statearr_38701_38720[(2)] = inst_38675);

(statearr_38701_38720[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38698 === (6))){
var inst_38686 = (state_38697[(7)]);
var inst_38685 = (state_38697[(2)]);
var inst_38686__$1 = fluree.db.util.async.throw_err(inst_38685);
var state_38697__$1 = (function (){var statearr_38702 = state_38697;
(statearr_38702[(7)] = inst_38686__$1);

return statearr_38702;
})();
if(cljs.core.truth_(inst_38686__$1)){
var statearr_38703_38721 = state_38697__$1;
(statearr_38703_38721[(1)] = (7));

} else {
var statearr_38704_38722 = state_38697__$1;
(statearr_38704_38722[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38698 === (3))){
var inst_38695 = (state_38697[(2)]);
var state_38697__$1 = state_38697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38697__$1,inst_38695);
} else {
if((state_val_38698 === (2))){
var _ = (function (){var statearr_38706 = state_38697;
(statearr_38706[(4)] = cljs.core.cons((5),(state_38697[(4)])));

return statearr_38706;
})();
var inst_38681 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_38682 = [inst_38681,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_38683 = fluree.db.storage.core.storage_read(conn,inst_38682);
var state_38697__$1 = state_38697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38697__$1,(6),inst_38683);
} else {
if((state_val_38698 === (9))){
var inst_38692 = (state_38697[(2)]);
var _ = (function (){var statearr_38707 = state_38697;
(statearr_38707[(4)] = cljs.core.rest((state_38697[(4)])));

return statearr_38707;
})();
var state_38697__$1 = state_38697;
var statearr_38708_38723 = state_38697__$1;
(statearr_38708_38723[(2)] = inst_38692);

(statearr_38708_38723[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38698 === (5))){
var _ = (function (){var statearr_38709 = state_38697;
(statearr_38709[(4)] = cljs.core.rest((state_38697[(4)])));

return statearr_38709;
})();
var state_38697__$1 = state_38697;
var ex38705 = (state_38697__$1[(2)]);
var statearr_38710_38724 = state_38697__$1;
(statearr_38710_38724[(5)] = ex38705);


if((ex38705 instanceof Error)){
var statearr_38711_38725 = state_38697__$1;
(statearr_38711_38725[(1)] = (4));

(statearr_38711_38725[(5)] = null);

} else {
throw ex38705;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38698 === (8))){
var state_38697__$1 = state_38697;
var statearr_38712_38726 = state_38697__$1;
(statearr_38712_38726[(2)] = null);

(statearr_38712_38726[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__14778__auto____0 = (function (){
var statearr_38713 = [null,null,null,null,null,null,null,null];
(statearr_38713[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__14778__auto__);

(statearr_38713[(1)] = (1));

return statearr_38713;
});
var fluree$db$storage$core$read_block_version_$_state_machine__14778__auto____1 = (function (state_38697){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38697);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38714){var ex__14781__auto__ = e38714;
var statearr_38715_38727 = state_38697;
(statearr_38715_38727[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38697[(4)]))){
var statearr_38716_38728 = state_38697;
(statearr_38716_38728[(1)] = cljs.core.first((state_38697[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38729 = state_38697;
state_38697 = G__38729;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__14778__auto__ = function(state_38697){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__14778__auto____1.call(this,state_38697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__14778__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__14778__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38717 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38717[(6)] = c__14852__auto__);

return statearr_38717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38753){
var state_val_38754 = (state_38753[(1)]);
if((state_val_38754 === (1))){
var state_38753__$1 = state_38753;
var statearr_38755_38769 = state_38753__$1;
(statearr_38755_38769[(2)] = null);

(statearr_38755_38769[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (2))){
var _ = (function (){var statearr_38756 = state_38753;
(statearr_38756[(4)] = cljs.core.cons((5),(state_38753[(4)])));

return statearr_38756;
})();
var inst_38736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38737 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_38738 = (new cljs.core.PersistentVector(null,3,(5),inst_38736,inst_38737,null));
var inst_38739 = cljs.core.select_keys(block_data,inst_38738);
var inst_38740 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_38739);
var inst_38741 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_38740);
var inst_38742 = [inst_38741,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_38743 = fluree.db.storage.core.serde(conn);
var inst_38744 = fluree.db.serde.protocol._serialize_block(inst_38743,inst_38739);
var inst_38745 = fluree.db.storage.core.storage_write(conn,inst_38742,inst_38744);
var state_38753__$1 = state_38753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38753__$1,(6),inst_38745);
} else {
if((state_val_38754 === (3))){
var inst_38751 = (state_38753[(2)]);
var state_38753__$1 = state_38753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38753__$1,inst_38751);
} else {
if((state_val_38754 === (4))){
var inst_38730 = (state_38753[(2)]);
var state_38753__$1 = state_38753;
var statearr_38758_38770 = state_38753__$1;
(statearr_38758_38770[(2)] = inst_38730);

(statearr_38758_38770[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (5))){
var _ = (function (){var statearr_38759 = state_38753;
(statearr_38759[(4)] = cljs.core.rest((state_38753[(4)])));

return statearr_38759;
})();
var state_38753__$1 = state_38753;
var ex38757 = (state_38753__$1[(2)]);
var statearr_38760_38771 = state_38753__$1;
(statearr_38760_38771[(5)] = ex38757);


if((ex38757 instanceof Error)){
var statearr_38761_38772 = state_38753__$1;
(statearr_38761_38772[(1)] = (4));

(statearr_38761_38772[(5)] = null);

} else {
throw ex38757;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (6))){
var inst_38747 = (state_38753[(2)]);
var inst_38748 = fluree.db.util.async.throw_err(inst_38747);
var _ = (function (){var statearr_38762 = state_38753;
(statearr_38762[(4)] = cljs.core.rest((state_38753[(4)])));

return statearr_38762;
})();
var state_38753__$1 = state_38753;
var statearr_38763_38773 = state_38753__$1;
(statearr_38763_38773[(2)] = inst_38748);

(statearr_38763_38773[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__14778__auto____0 = (function (){
var statearr_38764 = [null,null,null,null,null,null,null];
(statearr_38764[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__14778__auto__);

(statearr_38764[(1)] = (1));

return statearr_38764;
});
var fluree$db$storage$core$write_block_version_$_state_machine__14778__auto____1 = (function (state_38753){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38753);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38765){var ex__14781__auto__ = e38765;
var statearr_38766_38774 = state_38753;
(statearr_38766_38774[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38753[(4)]))){
var statearr_38767_38775 = state_38753;
(statearr_38767_38775[(1)] = cljs.core.first((state_38753[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38776 = state_38753;
state_38753 = G__38776;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__14778__auto__ = function(state_38753){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__14778__auto____1.call(this,state_38753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__14778__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__14778__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38768 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38768[(6)] = c__14852__auto__);

return statearr_38768;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38799){
var state_val_38800 = (state_38799[(1)]);
if((state_val_38800 === (1))){
var state_38799__$1 = state_38799;
var statearr_38801_38815 = state_38799__$1;
(statearr_38801_38815[(2)] = null);

(statearr_38801_38815[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38800 === (2))){
var _ = (function (){var statearr_38802 = state_38799;
(statearr_38802[(4)] = cljs.core.cons((5),(state_38799[(4)])));

return statearr_38802;
})();
var inst_38783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38784 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_38785 = (new cljs.core.PersistentVector(null,3,(5),inst_38783,inst_38784,null));
var inst_38786 = cljs.core.select_keys(block_data,inst_38785);
var inst_38787 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_38786);
var inst_38788 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_38787);
var inst_38789 = fluree.db.storage.core.serde(conn);
var inst_38790 = fluree.db.serde.protocol._serialize_block(inst_38789,inst_38786);
var inst_38791 = fluree.db.storage.core.storage_write(conn,inst_38788,inst_38790);
var state_38799__$1 = state_38799;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38799__$1,(6),inst_38791);
} else {
if((state_val_38800 === (3))){
var inst_38797 = (state_38799[(2)]);
var state_38799__$1 = state_38799;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38799__$1,inst_38797);
} else {
if((state_val_38800 === (4))){
var inst_38777 = (state_38799[(2)]);
var state_38799__$1 = state_38799;
var statearr_38804_38816 = state_38799__$1;
(statearr_38804_38816[(2)] = inst_38777);

(statearr_38804_38816[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38800 === (5))){
var _ = (function (){var statearr_38805 = state_38799;
(statearr_38805[(4)] = cljs.core.rest((state_38799[(4)])));

return statearr_38805;
})();
var state_38799__$1 = state_38799;
var ex38803 = (state_38799__$1[(2)]);
var statearr_38806_38817 = state_38799__$1;
(statearr_38806_38817[(5)] = ex38803);


if((ex38803 instanceof Error)){
var statearr_38807_38818 = state_38799__$1;
(statearr_38807_38818[(1)] = (4));

(statearr_38807_38818[(5)] = null);

} else {
throw ex38803;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38800 === (6))){
var inst_38793 = (state_38799[(2)]);
var inst_38794 = fluree.db.util.async.throw_err(inst_38793);
var _ = (function (){var statearr_38808 = state_38799;
(statearr_38808[(4)] = cljs.core.rest((state_38799[(4)])));

return statearr_38808;
})();
var state_38799__$1 = state_38799;
var statearr_38809_38819 = state_38799__$1;
(statearr_38809_38819[(2)] = inst_38794);

(statearr_38809_38819[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__14778__auto____0 = (function (){
var statearr_38810 = [null,null,null,null,null,null,null];
(statearr_38810[(0)] = fluree$db$storage$core$write_block_$_state_machine__14778__auto__);

(statearr_38810[(1)] = (1));

return statearr_38810;
});
var fluree$db$storage$core$write_block_$_state_machine__14778__auto____1 = (function (state_38799){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38799);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38811){var ex__14781__auto__ = e38811;
var statearr_38812_38820 = state_38799;
(statearr_38812_38820[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38799[(4)]))){
var statearr_38813_38821 = state_38799;
(statearr_38813_38821[(1)] = cljs.core.first((state_38799[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38822 = state_38799;
state_38799 = G__38822;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__14778__auto__ = function(state_38799){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__14778__auto____1.call(this,state_38799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__14778__auto____0;
fluree$db$storage$core$write_block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__14778__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38814 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38814[(6)] = c__14852__auto__);

return statearr_38814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38842){
var state_val_38843 = (state_38842[(1)]);
if((state_val_38843 === (1))){
var state_38842__$1 = state_38842;
var statearr_38844_38858 = state_38842__$1;
(statearr_38844_38858[(2)] = null);

(statearr_38844_38858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38843 === (2))){
var _ = (function (){var statearr_38845 = state_38842;
(statearr_38845[(4)] = cljs.core.cons((5),(state_38842[(4)])));

return statearr_38845;
})();
var inst_38829 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_38830 = [history,next_his_key];
var inst_38831 = cljs.core.PersistentHashMap.fromArrays(inst_38829,inst_38830);
var inst_38832 = fluree.db.storage.core.serde(conn);
var inst_38833 = fluree.db.serde.protocol._serialize_leaf(inst_38832,inst_38831);
var inst_38834 = fluree.db.storage.core.storage_write(conn,his_key,inst_38833);
var state_38842__$1 = state_38842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38842__$1,(6),inst_38834);
} else {
if((state_val_38843 === (3))){
var inst_38840 = (state_38842[(2)]);
var state_38842__$1 = state_38842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38842__$1,inst_38840);
} else {
if((state_val_38843 === (4))){
var inst_38823 = (state_38842[(2)]);
var state_38842__$1 = state_38842;
var statearr_38847_38859 = state_38842__$1;
(statearr_38847_38859[(2)] = inst_38823);

(statearr_38847_38859[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38843 === (5))){
var _ = (function (){var statearr_38848 = state_38842;
(statearr_38848[(4)] = cljs.core.rest((state_38842[(4)])));

return statearr_38848;
})();
var state_38842__$1 = state_38842;
var ex38846 = (state_38842__$1[(2)]);
var statearr_38849_38860 = state_38842__$1;
(statearr_38849_38860[(5)] = ex38846);


if((ex38846 instanceof Error)){
var statearr_38850_38861 = state_38842__$1;
(statearr_38850_38861[(1)] = (4));

(statearr_38850_38861[(5)] = null);

} else {
throw ex38846;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38843 === (6))){
var inst_38836 = (state_38842[(2)]);
var inst_38837 = fluree.db.util.async.throw_err(inst_38836);
var _ = (function (){var statearr_38851 = state_38842;
(statearr_38851[(4)] = cljs.core.rest((state_38842[(4)])));

return statearr_38851;
})();
var state_38842__$1 = state_38842;
var statearr_38852_38862 = state_38842__$1;
(statearr_38852_38862[(2)] = inst_38837);

(statearr_38852_38862[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__14778__auto____0 = (function (){
var statearr_38853 = [null,null,null,null,null,null,null];
(statearr_38853[(0)] = fluree$db$storage$core$write_history_$_state_machine__14778__auto__);

(statearr_38853[(1)] = (1));

return statearr_38853;
});
var fluree$db$storage$core$write_history_$_state_machine__14778__auto____1 = (function (state_38842){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38842);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38854){var ex__14781__auto__ = e38854;
var statearr_38855_38863 = state_38842;
(statearr_38855_38863[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38842[(4)]))){
var statearr_38856_38864 = state_38842;
(statearr_38856_38864[(1)] = cljs.core.first((state_38842[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38865 = state_38842;
state_38842 = G__38865;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__14778__auto__ = function(state_38842){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__14778__auto____1.call(this,state_38842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__14778__auto____0;
fluree$db$storage$core$write_history_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__14778__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38857 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38857[(6)] = c__14852__auto__);

return statearr_38857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38891){
var state_val_38892 = (state_38891[(1)]);
if((state_val_38892 === (1))){
var state_38891__$1 = state_38891;
var statearr_38893_38910 = state_38891__$1;
(statearr_38893_38910[(2)] = null);

(statearr_38893_38910[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38892 === (2))){
var inst_38872 = (state_38891[(7)]);
var _ = (function (){var statearr_38894 = state_38891;
(statearr_38894[(4)] = cljs.core.cons((5),(state_38891[(4)])));

return statearr_38894;
})();
var inst_38872__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_38873 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38872__$1),"-his"].join('');
var inst_38874 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_38875 = [flakes,inst_38873];
var inst_38876 = cljs.core.PersistentHashMap.fromArrays(inst_38874,inst_38875);
var inst_38877 = fluree.db.storage.core.serde(conn);
var inst_38878 = fluree.db.serde.protocol._serialize_leaf(inst_38877,inst_38876);
var inst_38879 = fluree.db.storage.core.write_history(conn,history,inst_38873,null);
var inst_38880 = fluree.db.storage.core.storage_write(conn,inst_38872__$1,inst_38878);
var state_38891__$1 = (function (){var statearr_38895 = state_38891;
(statearr_38895[(8)] = inst_38880);

(statearr_38895[(7)] = inst_38872__$1);

return statearr_38895;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38891__$1,(6),inst_38879);
} else {
if((state_val_38892 === (3))){
var inst_38889 = (state_38891[(2)]);
var state_38891__$1 = state_38891;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38891__$1,inst_38889);
} else {
if((state_val_38892 === (4))){
var inst_38866 = (state_38891[(2)]);
var state_38891__$1 = state_38891;
var statearr_38897_38911 = state_38891__$1;
(statearr_38897_38911[(2)] = inst_38866);

(statearr_38897_38911[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38892 === (5))){
var _ = (function (){var statearr_38898 = state_38891;
(statearr_38898[(4)] = cljs.core.rest((state_38891[(4)])));

return statearr_38898;
})();
var state_38891__$1 = state_38891;
var ex38896 = (state_38891__$1[(2)]);
var statearr_38899_38912 = state_38891__$1;
(statearr_38899_38912[(5)] = ex38896);


if((ex38896 instanceof Error)){
var statearr_38900_38913 = state_38891__$1;
(statearr_38900_38913[(1)] = (4));

(statearr_38900_38913[(5)] = null);

} else {
throw ex38896;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38892 === (6))){
var inst_38880 = (state_38891[(8)]);
var inst_38882 = (state_38891[(2)]);
var inst_38883 = fluree.db.util.async.throw_err(inst_38882);
var state_38891__$1 = (function (){var statearr_38901 = state_38891;
(statearr_38901[(9)] = inst_38883);

return statearr_38901;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38891__$1,(7),inst_38880);
} else {
if((state_val_38892 === (7))){
var inst_38872 = (state_38891[(7)]);
var inst_38885 = (state_38891[(2)]);
var inst_38886 = fluree.db.util.async.throw_err(inst_38885);
var _ = (function (){var statearr_38902 = state_38891;
(statearr_38902[(4)] = cljs.core.rest((state_38891[(4)])));

return statearr_38902;
})();
var state_38891__$1 = (function (){var statearr_38903 = state_38891;
(statearr_38903[(10)] = inst_38886);

return statearr_38903;
})();
var statearr_38904_38914 = state_38891__$1;
(statearr_38904_38914[(2)] = inst_38872);

(statearr_38904_38914[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__14778__auto____0 = (function (){
var statearr_38905 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38905[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__14778__auto__);

(statearr_38905[(1)] = (1));

return statearr_38905;
});
var fluree$db$storage$core$write_leaf_$_state_machine__14778__auto____1 = (function (state_38891){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38891);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38906){var ex__14781__auto__ = e38906;
var statearr_38907_38915 = state_38891;
(statearr_38907_38915[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38891[(4)]))){
var statearr_38908_38916 = state_38891;
(statearr_38908_38916[(1)] = cljs.core.first((state_38891[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38917 = state_38891;
state_38891 = G__38917;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__14778__auto__ = function(state_38891){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__14778__auto____1.call(this,state_38891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__14778__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__14778__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38909 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38909[(6)] = c__14852__auto__);

return statearr_38909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38934){
var state_val_38935 = (state_38934[(1)]);
if((state_val_38935 === (1))){
var state_38934__$1 = state_38934;
var statearr_38936_38951 = state_38934__$1;
(statearr_38936_38951[(2)] = null);

(statearr_38936_38951[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38935 === (2))){
var _ = (function (){var statearr_38937 = state_38934;
(statearr_38937[(4)] = cljs.core.cons((5),(state_38934[(4)])));

return statearr_38937;
})();
var inst_38924 = fluree.db.storage.core.serde(conn);
var inst_38925 = fluree.db.serde.protocol._serialize_branch(inst_38924,data);
var inst_38926 = fluree.db.storage.core.storage_write(conn,key,inst_38925);
var state_38934__$1 = state_38934;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38934__$1,(6),inst_38926);
} else {
if((state_val_38935 === (3))){
var inst_38932 = (state_38934[(2)]);
var state_38934__$1 = state_38934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38934__$1,inst_38932);
} else {
if((state_val_38935 === (4))){
var inst_38918 = (state_38934[(2)]);
var state_38934__$1 = state_38934;
var statearr_38939_38952 = state_38934__$1;
(statearr_38939_38952[(2)] = inst_38918);

(statearr_38939_38952[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38935 === (5))){
var _ = (function (){var statearr_38940 = state_38934;
(statearr_38940[(4)] = cljs.core.rest((state_38934[(4)])));

return statearr_38940;
})();
var state_38934__$1 = state_38934;
var ex38938 = (state_38934__$1[(2)]);
var statearr_38941_38953 = state_38934__$1;
(statearr_38941_38953[(5)] = ex38938);


if((ex38938 instanceof Error)){
var statearr_38942_38954 = state_38934__$1;
(statearr_38942_38954[(1)] = (4));

(statearr_38942_38954[(5)] = null);

} else {
throw ex38938;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38935 === (6))){
var inst_38928 = (state_38934[(2)]);
var inst_38929 = fluree.db.util.async.throw_err(inst_38928);
var _ = (function (){var statearr_38943 = state_38934;
(statearr_38943[(4)] = cljs.core.rest((state_38934[(4)])));

return statearr_38943;
})();
var state_38934__$1 = (function (){var statearr_38944 = state_38934;
(statearr_38944[(7)] = inst_38929);

return statearr_38944;
})();
var statearr_38945_38955 = state_38934__$1;
(statearr_38945_38955[(2)] = key);

(statearr_38945_38955[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto____0 = (function (){
var statearr_38946 = [null,null,null,null,null,null,null,null];
(statearr_38946[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto__);

(statearr_38946[(1)] = (1));

return statearr_38946;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto____1 = (function (state_38934){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38934);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38947){var ex__14781__auto__ = e38947;
var statearr_38948_38956 = state_38934;
(statearr_38948_38956[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38934[(4)]))){
var statearr_38949_38957 = state_38934;
(statearr_38949_38957[(1)] = cljs.core.first((state_38934[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38958 = state_38934;
state_38934 = G__38958;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto__ = function(state_38934){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto____1.call(this,state_38934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38950 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38950[(6)] = c__14852__auto__);

return statearr_38950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__38959_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__38959_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__38960){
var map__38961 = p__38960;
var map__38961__$1 = cljs.core.__destructure_map(map__38961);
var progress = map__38961__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38961__$1,cljs.core.cst$kw$garbage);
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38989){
var state_val_38990 = (state_38989[(1)]);
if((state_val_38990 === (1))){
var state_38989__$1 = state_38989;
var statearr_38991_39007 = state_38989__$1;
(statearr_38991_39007[(2)] = null);

(statearr_38991_39007[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38990 === (2))){
var inst_38975 = (state_38989[(7)]);
var _ = (function (){var statearr_38992 = state_38989;
(statearr_38992[(4)] = cljs.core.cons((5),(state_38989[(4)])));

return statearr_38992;
})();
var inst_38969 = db;
var inst_38970 = cljs.core.__destructure_map(inst_38969);
var inst_38971 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38970,cljs.core.cst$kw$conn);
var inst_38972 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38970,cljs.core.cst$kw$network);
var inst_38973 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38970,cljs.core.cst$kw$dbid);
var inst_38974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38970,cljs.core.cst$kw$block);
var inst_38975__$1 = fluree.db.storage.core.ledger_garbage_key(inst_38972,inst_38973,inst_38974);
var inst_38976 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_38977 = [inst_38973,inst_38974,garbage];
var inst_38978 = cljs.core.PersistentHashMap.fromArrays(inst_38976,inst_38977);
var inst_38979 = fluree.db.storage.core.serde(inst_38971);
var inst_38980 = fluree.db.serde.protocol._serialize_garbage(inst_38979,inst_38978);
var inst_38981 = fluree.db.storage.core.storage_write(inst_38971,inst_38975__$1,inst_38980);
var state_38989__$1 = (function (){var statearr_38993 = state_38989;
(statearr_38993[(7)] = inst_38975__$1);

return statearr_38993;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38989__$1,(6),inst_38981);
} else {
if((state_val_38990 === (3))){
var inst_38987 = (state_38989[(2)]);
var state_38989__$1 = state_38989;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38989__$1,inst_38987);
} else {
if((state_val_38990 === (4))){
var inst_38962 = (state_38989[(2)]);
var state_38989__$1 = state_38989;
var statearr_38995_39008 = state_38989__$1;
(statearr_38995_39008[(2)] = inst_38962);

(statearr_38995_39008[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38990 === (5))){
var _ = (function (){var statearr_38996 = state_38989;
(statearr_38996[(4)] = cljs.core.rest((state_38989[(4)])));

return statearr_38996;
})();
var state_38989__$1 = state_38989;
var ex38994 = (state_38989__$1[(2)]);
var statearr_38997_39009 = state_38989__$1;
(statearr_38997_39009[(5)] = ex38994);


if((ex38994 instanceof Error)){
var statearr_38998_39010 = state_38989__$1;
(statearr_38998_39010[(1)] = (4));

(statearr_38998_39010[(5)] = null);

} else {
throw ex38994;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38990 === (6))){
var inst_38975 = (state_38989[(7)]);
var inst_38983 = (state_38989[(2)]);
var inst_38984 = fluree.db.util.async.throw_err(inst_38983);
var _ = (function (){var statearr_38999 = state_38989;
(statearr_38999[(4)] = cljs.core.rest((state_38989[(4)])));

return statearr_38999;
})();
var state_38989__$1 = (function (){var statearr_39000 = state_38989;
(statearr_39000[(8)] = inst_38984);

return statearr_39000;
})();
var statearr_39001_39011 = state_38989__$1;
(statearr_39001_39011[(2)] = inst_38975);

(statearr_39001_39011[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__14778__auto____0 = (function (){
var statearr_39002 = [null,null,null,null,null,null,null,null,null];
(statearr_39002[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__14778__auto__);

(statearr_39002[(1)] = (1));

return statearr_39002;
});
var fluree$db$storage$core$write_garbage_$_state_machine__14778__auto____1 = (function (state_38989){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38989);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39003){var ex__14781__auto__ = e39003;
var statearr_39004_39012 = state_38989;
(statearr_39004_39012[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38989[(4)]))){
var statearr_39005_39013 = state_38989;
(statearr_39005_39013[(1)] = cljs.core.first((state_38989[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39014 = state_38989;
state_38989 = G__39014;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__14778__auto__ = function(state_38989){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__14778__auto____1.call(this,state_38989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__14778__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__14778__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39006 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39006[(6)] = c__14852__auto__);

return statearr_39006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__39016 = arguments.length;
switch (G__39016) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39072){
var state_val_39073 = (state_39072[(1)]);
if((state_val_39073 === (7))){
var state_39072__$1 = state_39072;
var statearr_39074_39100 = state_39072__$1;
(statearr_39074_39100[(2)] = (0));

(statearr_39074_39100[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39073 === (1))){
var state_39072__$1 = state_39072;
var statearr_39075_39101 = state_39072__$1;
(statearr_39075_39101[(2)] = null);

(statearr_39075_39101[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39073 === (4))){
var inst_39017 = (state_39072[(2)]);
var state_39072__$1 = state_39072;
var statearr_39076_39102 = state_39072__$1;
(statearr_39076_39102[(2)] = inst_39017);

(statearr_39076_39102[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39073 === (6))){
var inst_39042 = (state_39072[(7)]);
var state_39072__$1 = state_39072;
var statearr_39077_39103 = state_39072__$1;
(statearr_39077_39103[(2)] = inst_39042);

(statearr_39077_39103[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39073 === (3))){
var inst_39070 = (state_39072[(2)]);
var state_39072__$1 = state_39072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39072__$1,inst_39070);
} else {
if((state_val_39073 === (12))){
var inst_39039 = (state_39072[(8)]);
var inst_39066 = (state_39072[(2)]);
var inst_39067 = fluree.db.util.async.throw_err(inst_39066);
var _ = (function (){var statearr_39078 = state_39072;
(statearr_39078[(4)] = cljs.core.rest((state_39072[(4)])));

return statearr_39078;
})();
var state_39072__$1 = (function (){var statearr_39079 = state_39072;
(statearr_39079[(9)] = inst_39067);

return statearr_39079;
})();
var statearr_39080_39104 = state_39072__$1;
(statearr_39080_39104[(2)] = inst_39039);

(statearr_39080_39104[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39073 === (2))){
var inst_39034 = (state_39072[(10)]);
var inst_39032 = (state_39072[(11)]);
var inst_39030 = (state_39072[(12)]);
var inst_39042 = (state_39072[(7)]);
var _ = (function (){var statearr_39081 = state_39072;
(statearr_39081[(4)] = cljs.core.cons((5),(state_39072[(4)])));

return statearr_39081;
})();
var inst_39024 = db;
var inst_39025 = cljs.core.__destructure_map(inst_39024);
var inst_39026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$network);
var inst_39027 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$t);
var inst_39028 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$fork);
var inst_39029 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$spot);
var inst_39030__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$stats);
var inst_39031 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$conn);
var inst_39032__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$block);
var inst_39033 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$psot);
var inst_39034__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$dbid);
var inst_39035 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$ecount);
var inst_39036 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$opst);
var inst_39037 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$fork_DASH_block);
var inst_39038 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39025,cljs.core.cst$kw$post);
var inst_39039 = fluree.db.storage.core.ledger_root_key(inst_39026,inst_39034__$1,inst_39032__$1);
var inst_39040 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_39041 = fluree.db.storage.core.child_data(inst_39033);
var inst_39042__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_39030__$1);
var state_39072__$1 = (function (){var statearr_39082 = state_39072;
(statearr_39082[(13)] = inst_39028);

(statearr_39082[(10)] = inst_39034__$1);

(statearr_39082[(14)] = inst_39041);

(statearr_39082[(15)] = inst_39027);

(statearr_39082[(16)] = inst_39031);

(statearr_39082[(11)] = inst_39032__$1);

(statearr_39082[(12)] = inst_39030__$1);

(statearr_39082[(17)] = inst_39035);

(statearr_39082[(18)] = inst_39029);

(statearr_39082[(19)] = inst_39040);

(statearr_39082[(20)] = inst_39038);

(statearr_39082[(21)] = inst_39037);

(statearr_39082[(8)] = inst_39039);

(statearr_39082[(22)] = inst_39036);

(statearr_39082[(7)] = inst_39042__$1);

return statearr_39082;
})();
if(cljs.core.truth_(inst_39042__$1)){
var statearr_39083_39105 = state_39072__$1;
(statearr_39083_39105[(1)] = (6));

} else {
var statearr_39084_39106 = state_39072__$1;
(statearr_39084_39106[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39073 === (11))){
var inst_39028 = (state_39072[(13)]);
var inst_39034 = (state_39072[(10)]);
var inst_39041 = (state_39072[(14)]);
var inst_39027 = (state_39072[(15)]);
var inst_39031 = (state_39072[(16)]);
var inst_39032 = (state_39072[(11)]);
var inst_39030 = (state_39072[(12)]);
var inst_39029 = (state_39072[(18)]);
var inst_39040 = (state_39072[(19)]);
var inst_39038 = (state_39072[(20)]);
var inst_39037 = (state_39072[(21)]);
var inst_39046 = (state_39072[(23)]);
var inst_39039 = (state_39072[(8)]);
var inst_39036 = (state_39072[(22)]);
var inst_39051 = (state_39072[(2)]);
var inst_39052 = fluree.db.storage.core.child_data(inst_39036);
var inst_39053 = fluree.db.storage.core.child_data(inst_39038);
var inst_39054 = fluree.db.util.core.current_time_millis();
var inst_39055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39056 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_39057 = (new cljs.core.PersistentVector(null,2,(5),inst_39055,inst_39056,null));
var inst_39058 = cljs.core.select_keys(inst_39030,inst_39057);
var inst_39059 = fluree.db.storage.core.child_data(inst_39029);
var inst_39060 = [inst_39032,inst_39041,inst_39034,inst_39046,inst_39051,inst_39052,inst_39053,inst_39027,inst_39054,inst_39028,inst_39037,inst_39058,inst_39059];
var inst_39061 = cljs.core.PersistentHashMap.fromArrays(inst_39040,inst_39060);
var inst_39062 = fluree.db.storage.core.serde(inst_39031);
var inst_39063 = fluree.db.serde.protocol._serialize_db_root(inst_39062,inst_39061);
var inst_39064 = fluree.db.storage.core.storage_write(inst_39031,inst_39039,inst_39063);
var state_39072__$1 = state_39072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39072__$1,(12),inst_39064);
} else {
if((state_val_39073 === (9))){
var inst_39047 = (state_39072[(24)]);
var state_39072__$1 = state_39072;
var statearr_39086_39107 = state_39072__$1;
(statearr_39086_39107[(2)] = inst_39047);

(statearr_39086_39107[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39073 === (5))){
var _ = (function (){var statearr_39087 = state_39072;
(statearr_39087[(4)] = cljs.core.rest((state_39072[(4)])));

return statearr_39087;
})();
var state_39072__$1 = state_39072;
var ex39085 = (state_39072__$1[(2)]);
var statearr_39088_39108 = state_39072__$1;
(statearr_39088_39108[(5)] = ex39085);


if((ex39085 instanceof Error)){
var statearr_39089_39109 = state_39072__$1;
(statearr_39089_39109[(1)] = (4));

(statearr_39089_39109[(5)] = null);

} else {
throw ex39085;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39073 === (10))){
var inst_39035 = (state_39072[(17)]);
var state_39072__$1 = state_39072;
var statearr_39090_39110 = state_39072__$1;
(statearr_39090_39110[(2)] = inst_39035);

(statearr_39090_39110[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39073 === (8))){
var inst_39047 = (state_39072[(24)]);
var inst_39046 = (state_39072[(2)]);
var inst_39047__$1 = custom_ecount;
var state_39072__$1 = (function (){var statearr_39091 = state_39072;
(statearr_39091[(23)] = inst_39046);

(statearr_39091[(24)] = inst_39047__$1);

return statearr_39091;
})();
if(cljs.core.truth_(inst_39047__$1)){
var statearr_39092_39111 = state_39072__$1;
(statearr_39092_39111[(1)] = (9));

} else {
var statearr_39093_39112 = state_39072__$1;
(statearr_39093_39112[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__14778__auto__ = null;
var fluree$db$storage$core$state_machine__14778__auto____0 = (function (){
var statearr_39094 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39094[(0)] = fluree$db$storage$core$state_machine__14778__auto__);

(statearr_39094[(1)] = (1));

return statearr_39094;
});
var fluree$db$storage$core$state_machine__14778__auto____1 = (function (state_39072){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39072);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39095){var ex__14781__auto__ = e39095;
var statearr_39096_39113 = state_39072;
(statearr_39096_39113[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39072[(4)]))){
var statearr_39097_39114 = state_39072;
(statearr_39097_39114[(1)] = cljs.core.first((state_39072[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39115 = state_39072;
state_39072 = G__39115;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__14778__auto__ = function(state_39072){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__14778__auto____1.call(this,state_39072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__14778__auto____0;
fluree$db$storage$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__14778__auto____1;
return fluree$db$storage$core$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39098 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39098[(6)] = c__14852__auto__);

return statearr_39098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__14852__auto___39174 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39148){
var state_val_39149 = (state_39148[(1)]);
if((state_val_39149 === (7))){
var inst_39128 = (state_39148[(7)]);
var state_39148__$1 = state_39148;
var statearr_39150_39175 = state_39148__$1;
(statearr_39150_39175[(2)] = inst_39128);

(statearr_39150_39175[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39149 === (1))){
var state_39148__$1 = state_39148;
var statearr_39151_39176 = state_39148__$1;
(statearr_39151_39176[(2)] = null);

(statearr_39151_39176[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39149 === (4))){
var inst_39116 = (state_39148[(2)]);
var inst_39117 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_39118 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_39116);
var inst_39119 = cljs.core.async.close_BANG_(return_ch);
var state_39148__$1 = (function (){var statearr_39152 = state_39148;
(statearr_39152[(8)] = inst_39117);

(statearr_39152[(9)] = inst_39118);

return statearr_39152;
})();
var statearr_39153_39177 = state_39148__$1;
(statearr_39153_39177[(2)] = inst_39119);

(statearr_39153_39177[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39149 === (6))){
var inst_39128 = (state_39148[(7)]);
var inst_39127 = (state_39148[(10)]);
var inst_39127__$1 = (state_39148[(2)]);
var inst_39128__$1 = (inst_39127__$1 == null);
var state_39148__$1 = (function (){var statearr_39154 = state_39148;
(statearr_39154[(7)] = inst_39128__$1);

(statearr_39154[(10)] = inst_39127__$1);

return statearr_39154;
})();
if(cljs.core.truth_(inst_39128__$1)){
var statearr_39155_39178 = state_39148__$1;
(statearr_39155_39178[(1)] = (7));

} else {
var statearr_39156_39179 = state_39148__$1;
(statearr_39156_39179[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39149 === (3))){
var inst_39146 = (state_39148[(2)]);
var state_39148__$1 = state_39148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39148__$1,inst_39146);
} else {
if((state_val_39149 === (12))){
var inst_39143 = (state_39148[(2)]);
var _ = (function (){var statearr_39157 = state_39148;
(statearr_39157[(4)] = cljs.core.rest((state_39148[(4)])));

return statearr_39157;
})();
var state_39148__$1 = state_39148;
var statearr_39158_39180 = state_39148__$1;
(statearr_39158_39180[(2)] = inst_39143);

(statearr_39158_39180[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39149 === (2))){
var _ = (function (){var statearr_39159 = state_39148;
(statearr_39159[(4)] = cljs.core.cons((5),(state_39148[(4)])));

return statearr_39159;
})();
var inst_39125 = fluree.db.storage.core.storage_read(conn,key);
var state_39148__$1 = state_39148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39148__$1,(6),inst_39125);
} else {
if((state_val_39149 === (11))){
var inst_39127 = (state_39148[(10)]);
var inst_39137 = fluree.db.storage.core.serde(conn);
var inst_39138 = fluree.db.serde.protocol._deserialize_leaf(inst_39137,inst_39127);
var inst_39139 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_39138);
var inst_39140 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_39139);
var inst_39141 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_39140);
var state_39148__$1 = state_39148;
var statearr_39161_39181 = state_39148__$1;
(statearr_39161_39181[(2)] = inst_39141);

(statearr_39161_39181[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39149 === (9))){
var inst_39133 = (state_39148[(2)]);
var state_39148__$1 = state_39148;
if(cljs.core.truth_(inst_39133)){
var statearr_39162_39182 = state_39148__$1;
(statearr_39162_39182[(1)] = (10));

} else {
var statearr_39163_39183 = state_39148__$1;
(statearr_39163_39183[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39149 === (5))){
var _ = (function (){var statearr_39164 = state_39148;
(statearr_39164[(4)] = cljs.core.rest((state_39148[(4)])));

return statearr_39164;
})();
var state_39148__$1 = state_39148;
var ex39160 = (state_39148__$1[(2)]);
var statearr_39165_39184 = state_39148__$1;
(statearr_39165_39184[(5)] = ex39160);


var statearr_39166_39185 = state_39148__$1;
(statearr_39166_39185[(1)] = (4));

(statearr_39166_39185[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39149 === (10))){
var inst_39135 = cljs.core.async.close_BANG_(return_ch);
var state_39148__$1 = state_39148;
var statearr_39167_39186 = state_39148__$1;
(statearr_39167_39186[(2)] = inst_39135);

(statearr_39167_39186[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39149 === (8))){
var inst_39127 = (state_39148[(10)]);
var inst_39131 = (inst_39127 instanceof Error);
var state_39148__$1 = state_39148;
var statearr_39168_39187 = state_39148__$1;
(statearr_39168_39187[(2)] = inst_39131);

(statearr_39168_39187[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__14778__auto____0 = (function (){
var statearr_39169 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39169[(0)] = fluree$db$storage$core$reify_history_$_state_machine__14778__auto__);

(statearr_39169[(1)] = (1));

return statearr_39169;
});
var fluree$db$storage$core$reify_history_$_state_machine__14778__auto____1 = (function (state_39148){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39148);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39170){var ex__14781__auto__ = e39170;
var statearr_39171_39188 = state_39148;
(statearr_39171_39188[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39148[(4)]))){
var statearr_39172_39189 = state_39148;
(statearr_39172_39189[(1)] = cljs.core.first((state_39148[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39190 = state_39148;
state_39148 = G__39190;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__14778__auto__ = function(state_39148){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__14778__auto____1.call(this,state_39148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__14778__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__14778__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39173 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39173[(6)] = c__14852__auto___39174);

return statearr_39173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__39192 = arguments.length;
switch (G__39192) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4221__auto__ = (rhs == null);
if(and__4221__auto__){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__14852__auto___39304 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39255){
var state_val_39256 = (state_39255[(1)]);
if((state_val_39256 === (7))){
var state_39255__$1 = state_39255;
var statearr_39257_39305 = state_39255__$1;
(statearr_39257_39305[(2)] = cljs.core.cst$kw$novelty);

(statearr_39257_39305[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (20))){
var inst_39234 = cljs.core.PersistentVector.EMPTY;
var state_39255__$1 = state_39255;
var statearr_39258_39306 = state_39255__$1;
(statearr_39258_39306[(2)] = inst_39234);

(statearr_39258_39306[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (1))){
var state_39255__$1 = state_39255;
var statearr_39259_39307 = state_39255__$1;
(statearr_39259_39307[(2)] = null);

(statearr_39259_39307[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (24))){
var state_39255__$1 = state_39255;
var statearr_39260_39308 = state_39255__$1;
(statearr_39260_39308[(2)] = null);

(statearr_39260_39308[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (4))){
var inst_39195 = (state_39255[(2)]);
var inst_39196 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_39197 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_39195);
var inst_39198 = cljs.core.async.close_BANG_(result_ch);
var state_39255__$1 = (function (){var statearr_39261 = state_39255;
(statearr_39261[(7)] = inst_39197);

(statearr_39261[(8)] = inst_39196);

return statearr_39261;
})();
var statearr_39262_39309 = state_39255__$1;
(statearr_39262_39309[(2)] = inst_39198);

(statearr_39262_39309[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (15))){
var inst_39220 = (state_39255[(2)]);
var state_39255__$1 = state_39255;
var statearr_39263_39310 = state_39255__$1;
(statearr_39263_39310[(2)] = inst_39220);

(statearr_39263_39310[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (21))){
var inst_39237 = (state_39255[(9)]);
var inst_39208 = (state_39255[(10)]);
var inst_39209 = (state_39255[(11)]);
var inst_39207 = (state_39255[(12)]);
var inst_39224 = (state_39255[(13)]);
var inst_39244 = (state_39255[(2)]);
var inst_39245 = (function (){var base_node = inst_39207;
var first_flake = inst_39208;
var node_t = inst_39209;
var source = inst_39224;
var coll = inst_39237;
var conj_QMARK_ = inst_39244;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__39265 = f.p;
var fexpr__39264 = (function (){var or__4223__auto__ = remove_preds;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__39264.cljs$core$IFn$_invoke$arity$1 ? fexpr__39264.cljs$core$IFn$_invoke$arity$1(G__39265) : fexpr__39264.call(null,G__39265));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_39246 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_39207);
var inst_39247 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39245,inst_39246,inst_39237);
var inst_39248 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_39247);
var inst_39249 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39207,cljs.core.cst$kw$flakes,inst_39248);
var inst_39250 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_39249);
var _ = (function (){var statearr_39266 = state_39255;
(statearr_39266[(4)] = cljs.core.rest((state_39255[(4)])));

return statearr_39266;
})();
var state_39255__$1 = state_39255;
var statearr_39267_39311 = state_39255__$1;
(statearr_39267_39311[(2)] = inst_39250);

(statearr_39267_39311[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (13))){
var state_39255__$1 = state_39255;
var statearr_39268_39312 = state_39255__$1;
(statearr_39268_39312[(2)] = cljs.core.cst$kw$none);

(statearr_39268_39312[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (22))){
var inst_39237 = (state_39255[(9)]);
var inst_39208 = (state_39255[(10)]);
var inst_39209 = (state_39255[(11)]);
var inst_39207 = (state_39255[(12)]);
var inst_39224 = (state_39255[(13)]);
var inst_39238 = (function (){var base_node = inst_39207;
var first_flake = inst_39208;
var node_t = inst_39209;
var source = inst_39224;
var coll = inst_39237;
return (function (f){
return f.op === true;
});
})();
var state_39255__$1 = state_39255;
var statearr_39269_39313 = state_39255__$1;
(statearr_39269_39313[(2)] = inst_39238);

(statearr_39269_39313[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (6))){
var inst_39209 = (state_39255[(11)]);
var inst_39207 = (state_39255[(12)]);
var inst_39206 = (state_39255[(2)]);
var inst_39207__$1 = fluree.db.util.async.throw_err(inst_39206);
var inst_39208 = fluree.db.dbproto._first_flake(inst_39207__$1);
var inst_39209__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_39207__$1);
var inst_39210 = (inst_39209__$1 > t);
var state_39255__$1 = (function (){var statearr_39270 = state_39255;
(statearr_39270[(10)] = inst_39208);

(statearr_39270[(11)] = inst_39209__$1);

(statearr_39270[(12)] = inst_39207__$1);

return statearr_39270;
})();
if(cljs.core.truth_(inst_39210)){
var statearr_39271_39314 = state_39255__$1;
(statearr_39271_39314[(1)] = (7));

} else {
var statearr_39272_39315 = state_39255__$1;
(statearr_39272_39315[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (17))){
var inst_39208 = (state_39255[(10)]);
var inst_39225 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_39208,rhs,leftmost_QMARK_,t);
var state_39255__$1 = state_39255;
var statearr_39273_39316 = state_39255__$1;
(statearr_39273_39316[(2)] = inst_39225);

(statearr_39273_39316[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (3))){
var inst_39253 = (state_39255[(2)]);
var state_39255__$1 = state_39255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39255__$1,inst_39253);
} else {
if((state_val_39256 === (12))){
var inst_39222 = (state_39255[(2)]);
var state_39255__$1 = state_39255;
var statearr_39274_39317 = state_39255__$1;
(statearr_39274_39317[(2)] = inst_39222);

(statearr_39274_39317[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (2))){
var _ = (function (){var statearr_39275 = state_39255;
(statearr_39275[(4)] = cljs.core.cons((5),(state_39255[(4)])));

return statearr_39275;
})();
var inst_39204 = fluree.db.dbproto._resolve(node);
var state_39255__$1 = state_39255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39255__$1,(6),inst_39204);
} else {
if((state_val_39256 === (23))){
var inst_39237 = (state_39255[(9)]);
var inst_39208 = (state_39255[(10)]);
var inst_39209 = (state_39255[(11)]);
var inst_39207 = (state_39255[(12)]);
var inst_39224 = (state_39255[(13)]);
var inst_39240 = (function (){var base_node = inst_39207;
var first_flake = inst_39208;
var node_t = inst_39209;
var source = inst_39224;
var coll = inst_39237;
return (function (f){
return f.op === false;
});
})();
var state_39255__$1 = state_39255;
var statearr_39276_39318 = state_39255__$1;
(statearr_39276_39318[(2)] = inst_39240);

(statearr_39276_39318[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (19))){
var inst_39227 = (state_39255[(14)]);
var inst_39230 = (state_39255[(2)]);
var inst_39231 = fluree.db.util.async.throw_err(inst_39230);
var inst_39232 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_39227,inst_39231);
var state_39255__$1 = state_39255;
var statearr_39277_39319 = state_39255__$1;
(statearr_39277_39319[(2)] = inst_39232);

(statearr_39277_39319[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (11))){
var inst_39209 = (state_39255[(11)]);
var inst_39216 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39209,t);
var state_39255__$1 = state_39255;
if(inst_39216){
var statearr_39279_39320 = state_39255__$1;
(statearr_39279_39320[(1)] = (13));

} else {
var statearr_39280_39321 = state_39255__$1;
(statearr_39280_39321[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (9))){
var inst_39224 = (state_39255[(13)]);
var inst_39224__$1 = (state_39255[(2)]);
var state_39255__$1 = (function (){var statearr_39281 = state_39255;
(statearr_39281[(13)] = inst_39224__$1);

return statearr_39281;
})();
var G__39282_39322 = inst_39224__$1;
var G__39282_39323__$1 = (((G__39282_39322 instanceof cljs.core.Keyword))?G__39282_39322.fqn:null);
switch (G__39282_39323__$1) {
case "novelty":
var statearr_39283_39325 = state_39255__$1;
(statearr_39283_39325[(1)] = (17));


break;
case "history":
var statearr_39284_39326 = state_39255__$1;
(statearr_39284_39326[(1)] = (18));


break;
case "none":
var statearr_39285_39327 = state_39255__$1;
(statearr_39285_39327[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39282_39323__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (5))){
var _ = (function (){var statearr_39286 = state_39255;
(statearr_39286[(4)] = cljs.core.rest((state_39255[(4)])));

return statearr_39286;
})();
var state_39255__$1 = state_39255;
var ex39278 = (state_39255__$1[(2)]);
var statearr_39287_39328 = state_39255__$1;
(statearr_39287_39328[(5)] = ex39278);


var statearr_39288_39329 = state_39255__$1;
(statearr_39288_39329[(1)] = (4));

(statearr_39288_39329[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (14))){
var state_39255__$1 = state_39255;
var statearr_39289_39330 = state_39255__$1;
(statearr_39289_39330[(2)] = null);

(statearr_39289_39330[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (16))){
var inst_39224 = (state_39255[(13)]);
var inst_39237 = (state_39255[(2)]);
var state_39255__$1 = (function (){var statearr_39290 = state_39255;
(statearr_39290[(9)] = inst_39237);

return statearr_39290;
})();
var G__39291_39331 = inst_39224;
var G__39291_39332__$1 = (((G__39291_39331 instanceof cljs.core.Keyword))?G__39291_39331.fqn:null);
switch (G__39291_39332__$1) {
case "novelty":
var statearr_39292_39334 = state_39255__$1;
(statearr_39292_39334[(1)] = (22));


break;
case "history":
var statearr_39293_39335 = state_39255__$1;
(statearr_39293_39335[(1)] = (23));


break;
case "none":
var statearr_39294_39336 = state_39255__$1;
(statearr_39294_39336[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39291_39332__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (10))){
var state_39255__$1 = state_39255;
var statearr_39295_39337 = state_39255__$1;
(statearr_39295_39337[(2)] = cljs.core.cst$kw$history);

(statearr_39295_39337[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39256 === (18))){
var inst_39208 = (state_39255[(10)]);
var inst_39209 = (state_39255[(11)]);
var inst_39207 = (state_39255[(12)]);
var inst_39224 = (state_39255[(13)]);
var inst_39227 = (function (){var base_node = inst_39207;
var first_flake = inst_39208;
var node_t = inst_39209;
var source = inst_39224;
return (function (p1__39194_SHARP_){
return (p1__39194_SHARP_.t <= t);
});
})();
var inst_39228 = fluree.db.dbproto._resolve_history(node);
var state_39255__$1 = (function (){var statearr_39296 = state_39255;
(statearr_39296[(14)] = inst_39227);

return statearr_39296;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39255__$1,(19),inst_39228);
} else {
if((state_val_39256 === (8))){
var inst_39209 = (state_39255[(11)]);
var inst_39213 = (inst_39209 < t);
var state_39255__$1 = state_39255;
if(cljs.core.truth_(inst_39213)){
var statearr_39297_39338 = state_39255__$1;
(statearr_39297_39338[(1)] = (10));

} else {
var statearr_39298_39339 = state_39255__$1;
(statearr_39298_39339[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__14778__auto____0 = (function (){
var statearr_39299 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39299[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__14778__auto__);

(statearr_39299[(1)] = (1));

return statearr_39299;
});
var fluree$db$storage$core$resolve_t_$_state_machine__14778__auto____1 = (function (state_39255){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39255);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39300){var ex__14781__auto__ = e39300;
var statearr_39301_39340 = state_39255;
(statearr_39301_39340[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39255[(4)]))){
var statearr_39302_39341 = state_39255;
(statearr_39302_39341[(1)] = cljs.core.first((state_39255[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39342 = state_39255;
state_39255 = G__39342;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__14778__auto__ = function(state_39255){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__14778__auto____1.call(this,state_39255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__14778__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__14778__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39303 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39303[(6)] = c__14852__auto___39304);

return statearr_39303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39402){
var state_val_39403 = (state_39402[(1)]);
if((state_val_39403 === (7))){
var inst_39353 = (state_39402[(7)]);
var inst_39357 = (inst_39353 <= from_t);
var state_39402__$1 = state_39402;
var statearr_39404_39444 = state_39402__$1;
(statearr_39404_39444[(2)] = inst_39357);

(statearr_39404_39444[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (20))){
var inst_39387 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_39388 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39387)].join('');
var inst_39389 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39390 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_39391 = cljs.core.PersistentHashMap.fromArrays(inst_39389,inst_39390);
var inst_39392 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39388,inst_39391);
var inst_39393 = (function(){throw inst_39392})();
var state_39402__$1 = state_39402;
var statearr_39405_39445 = state_39402__$1;
(statearr_39405_39445[(2)] = inst_39393);

(statearr_39405_39445[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (1))){
var state_39402__$1 = state_39402;
var statearr_39406_39446 = state_39402__$1;
(statearr_39406_39446[(2)] = null);

(statearr_39406_39446[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (4))){
var inst_39345 = (state_39402[(2)]);
var inst_39346 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39345], 0));
var inst_39347 = (function(){throw inst_39345})();
var state_39402__$1 = (function (){var statearr_39407 = state_39402;
(statearr_39407[(8)] = inst_39346);

return statearr_39407;
})();
var statearr_39408_39447 = state_39402__$1;
(statearr_39408_39447[(2)] = inst_39347);

(statearr_39408_39447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (15))){
var inst_39372 = (state_39402[(2)]);
var state_39402__$1 = (function (){var statearr_39409 = state_39402;
(statearr_39409[(9)] = inst_39372);

return statearr_39409;
})();
if(cljs.core.truth_(from_t)){
var statearr_39410_39448 = state_39402__$1;
(statearr_39410_39448[(1)] = (16));

} else {
var statearr_39411_39449 = state_39402__$1;
(statearr_39411_39449[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (21))){
var inst_39383 = (state_39402[(10)]);
var inst_39381 = (state_39402[(11)]);
var inst_39382 = (state_39402[(12)]);
var inst_39395 = (state_39402[(2)]);
var inst_39396 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_39382,inst_39383,leftmost_QMARK_,to_t);
var inst_39397 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39396,inst_39381);
var _ = (function (){var statearr_39412 = state_39402;
(statearr_39412[(4)] = cljs.core.rest((state_39402[(4)])));

return statearr_39412;
})();
var state_39402__$1 = (function (){var statearr_39413 = state_39402;
(statearr_39413[(13)] = inst_39395);

return statearr_39413;
})();
var statearr_39414_39450 = state_39402__$1;
(statearr_39414_39450[(2)] = inst_39397);

(statearr_39414_39450[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (13))){
var inst_39365 = (state_39402[(14)]);
var inst_39353 = (state_39402[(7)]);
var inst_39368 = (function (){var node_t = inst_39353;
var G__39361 = inst_39365;
return (function (p1__39343_SHARP_){
return (p1__39343_SHARP_.t < to_t);
});
})();
var inst_39369 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_39368,inst_39365);
var state_39402__$1 = state_39402;
var statearr_39415_39451 = state_39402__$1;
(statearr_39415_39451[(2)] = inst_39369);

(statearr_39415_39451[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (6))){
var inst_39354 = (state_39402[(15)]);
var state_39402__$1 = state_39402;
var statearr_39416_39452 = state_39402__$1;
(statearr_39416_39452[(2)] = inst_39354);

(statearr_39416_39452[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (17))){
var inst_39372 = (state_39402[(9)]);
var state_39402__$1 = state_39402;
var statearr_39417_39453 = state_39402__$1;
(statearr_39417_39453[(2)] = inst_39372);

(statearr_39417_39453[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (3))){
var inst_39400 = (state_39402[(2)]);
var state_39402__$1 = state_39402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39402__$1,inst_39400);
} else {
if((state_val_39403 === (12))){
var inst_39353 = (state_39402[(7)]);
var inst_39364 = (state_39402[(2)]);
var inst_39365 = fluree.db.util.async.throw_err(inst_39364);
var inst_39366 = (to_t > inst_39353);
var state_39402__$1 = (function (){var statearr_39418 = state_39402;
(statearr_39418[(14)] = inst_39365);

return statearr_39418;
})();
if(cljs.core.truth_(inst_39366)){
var statearr_39419_39454 = state_39402__$1;
(statearr_39419_39454[(1)] = (13));

} else {
var statearr_39420_39455 = state_39402__$1;
(statearr_39420_39455[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (2))){
var inst_39354 = (state_39402[(15)]);
var _ = (function (){var statearr_39421 = state_39402;
(statearr_39421[(4)] = cljs.core.cons((5),(state_39402[(4)])));

return statearr_39421;
})();
var inst_39353 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_39354__$1 = (from_t == null);
var state_39402__$1 = (function (){var statearr_39422 = state_39402;
(statearr_39422[(15)] = inst_39354__$1);

(statearr_39422[(7)] = inst_39353);

return statearr_39422;
})();
if(cljs.core.truth_(inst_39354__$1)){
var statearr_39423_39456 = state_39402__$1;
(statearr_39423_39456[(1)] = (6));

} else {
var statearr_39424_39457 = state_39402__$1;
(statearr_39424_39457[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (19))){
var state_39402__$1 = state_39402;
var statearr_39425_39458 = state_39402__$1;
(statearr_39425_39458[(2)] = null);

(statearr_39425_39458[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (11))){
var inst_39381 = (state_39402[(2)]);
var inst_39382 = fluree.db.dbproto._first_flake(node);
var inst_39383 = fluree.db.dbproto._rhs(node);
var inst_39384 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_39402__$1 = (function (){var statearr_39427 = state_39402;
(statearr_39427[(10)] = inst_39383);

(statearr_39427[(11)] = inst_39381);

(statearr_39427[(12)] = inst_39382);

return statearr_39427;
})();
if(cljs.core.truth_(inst_39384)){
var statearr_39428_39459 = state_39402__$1;
(statearr_39428_39459[(1)] = (19));

} else {
var statearr_39429_39460 = state_39402__$1;
(statearr_39429_39460[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (9))){
var inst_39362 = fluree.db.dbproto._resolve_history(node);
var state_39402__$1 = state_39402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39402__$1,(12),inst_39362);
} else {
if((state_val_39403 === (5))){
var _ = (function (){var statearr_39430 = state_39402;
(statearr_39430[(4)] = cljs.core.rest((state_39402[(4)])));

return statearr_39430;
})();
var state_39402__$1 = state_39402;
var ex39426 = (state_39402__$1[(2)]);
var statearr_39431_39461 = state_39402__$1;
(statearr_39431_39461[(5)] = ex39426);


var statearr_39432_39462 = state_39402__$1;
(statearr_39432_39462[(1)] = (4));

(statearr_39432_39462[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (14))){
var inst_39365 = (state_39402[(14)]);
var state_39402__$1 = state_39402;
var statearr_39433_39463 = state_39402__$1;
(statearr_39433_39463[(2)] = inst_39365);

(statearr_39433_39463[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (16))){
var inst_39372 = (state_39402[(9)]);
var inst_39353 = (state_39402[(7)]);
var inst_39374 = (function (){var node_t = inst_39353;
var G__39361 = inst_39372;
return (function (p1__39344_SHARP_){
return (p1__39344_SHARP_.t <= from_t);
});
})();
var inst_39375 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_39374,inst_39372);
var state_39402__$1 = state_39402;
var statearr_39434_39464 = state_39402__$1;
(statearr_39434_39464[(2)] = inst_39375);

(statearr_39434_39464[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (10))){
var state_39402__$1 = state_39402;
var statearr_39435_39465 = state_39402__$1;
(statearr_39435_39465[(2)] = null);

(statearr_39435_39465[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (18))){
var inst_39378 = (state_39402[(2)]);
var state_39402__$1 = state_39402;
var statearr_39436_39466 = state_39402__$1;
(statearr_39436_39466[(2)] = inst_39378);

(statearr_39436_39466[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39403 === (8))){
var inst_39359 = (state_39402[(2)]);
var state_39402__$1 = state_39402;
if(cljs.core.truth_(inst_39359)){
var statearr_39437_39467 = state_39402__$1;
(statearr_39437_39467[(1)] = (9));

} else {
var statearr_39438_39468 = state_39402__$1;
(statearr_39438_39468[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto____0 = (function (){
var statearr_39439 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39439[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto__);

(statearr_39439[(1)] = (1));

return statearr_39439;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto____1 = (function (state_39402){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39402);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39440){var ex__14781__auto__ = e39440;
var statearr_39441_39469 = state_39402;
(statearr_39441_39469[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39402[(4)]))){
var statearr_39442_39470 = state_39402;
(statearr_39442_39470[(1)] = cljs.core.first((state_39402[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39471 = state_39402;
state_39402 = G__39471;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto__ = function(state_39402){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto____1.call(this,state_39402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39443 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39443[(6)] = c__14852__auto__);

return statearr_39443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4223__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__39472_39482 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__39473_39483 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__39472_39482,G__39473_39483) : object_cache.call(null,G__39472_39482,G__39473_39483));

var G__39474 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__39475 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__39476 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__39477 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__39476,G__39477) : object_cache.call(null,G__39476,G__39477));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__39474,G__39475) : object_cache.call(null,G__39474,G__39475));
} else {
var G__39478 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__39479 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__39480 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__39481 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__39480,G__39481) : object_cache.call(null,G__39480,G__39481));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__39478,G__39479) : object_cache.call(null,G__39478,G__39479));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39504){
var state_val_39505 = (state_39504[(1)]);
if((state_val_39505 === (7))){
var state_39504__$1 = state_39504;
var statearr_39506_39526 = state_39504__$1;
(statearr_39506_39526[(2)] = null);

(statearr_39506_39526[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39505 === (1))){
var state_39504__$1 = state_39504;
var statearr_39507_39527 = state_39504__$1;
(statearr_39507_39527[(2)] = null);

(statearr_39507_39527[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39505 === (4))){
var inst_39484 = (state_39504[(2)]);
var state_39504__$1 = state_39504;
var statearr_39508_39528 = state_39504__$1;
(statearr_39508_39528[(2)] = inst_39484);

(statearr_39508_39528[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39505 === (6))){
var inst_39490 = (state_39504[(7)]);
var inst_39492 = fluree.db.storage.core.serde(conn);
var state_39504__$1 = (function (){var statearr_39509 = state_39504;
(statearr_39509[(8)] = inst_39492);

return statearr_39509;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39504__$1,(9),inst_39490);
} else {
if((state_val_39505 === (3))){
var inst_39502 = (state_39504[(2)]);
var state_39504__$1 = state_39504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39504__$1,inst_39502);
} else {
if((state_val_39505 === (2))){
var inst_39490 = (state_39504[(7)]);
var _ = (function (){var statearr_39511 = state_39504;
(statearr_39511[(4)] = cljs.core.cons((5),(state_39504[(4)])));

return statearr_39511;
})();
var inst_39490__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_39504__$1 = (function (){var statearr_39512 = state_39504;
(statearr_39512[(7)] = inst_39490__$1);

return statearr_39512;
})();
if(cljs.core.truth_(inst_39490__$1)){
var statearr_39513_39529 = state_39504__$1;
(statearr_39513_39529[(1)] = (6));

} else {
var statearr_39514_39530 = state_39504__$1;
(statearr_39514_39530[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39505 === (9))){
var inst_39492 = (state_39504[(8)]);
var inst_39494 = (state_39504[(2)]);
var inst_39495 = fluree.db.util.async.throw_err(inst_39494);
var inst_39496 = fluree.db.serde.protocol._deserialize_branch(inst_39492,inst_39495);
var state_39504__$1 = state_39504;
var statearr_39515_39531 = state_39504__$1;
(statearr_39515_39531[(2)] = inst_39496);

(statearr_39515_39531[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39505 === (5))){
var _ = (function (){var statearr_39516 = state_39504;
(statearr_39516[(4)] = cljs.core.rest((state_39504[(4)])));

return statearr_39516;
})();
var state_39504__$1 = state_39504;
var ex39510 = (state_39504__$1[(2)]);
var statearr_39517_39532 = state_39504__$1;
(statearr_39517_39532[(5)] = ex39510);


if((ex39510 instanceof Error)){
var statearr_39518_39533 = state_39504__$1;
(statearr_39518_39533[(1)] = (4));

(statearr_39518_39533[(5)] = null);

} else {
throw ex39510;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39505 === (8))){
var inst_39499 = (state_39504[(2)]);
var _ = (function (){var statearr_39519 = state_39504;
(statearr_39519[(4)] = cljs.core.rest((state_39504[(4)])));

return statearr_39519;
})();
var state_39504__$1 = state_39504;
var statearr_39520_39534 = state_39504__$1;
(statearr_39520_39534[(2)] = inst_39499);

(statearr_39520_39534[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__14778__auto____0 = (function (){
var statearr_39521 = [null,null,null,null,null,null,null,null,null];
(statearr_39521[(0)] = fluree$db$storage$core$read_branch_$_state_machine__14778__auto__);

(statearr_39521[(1)] = (1));

return statearr_39521;
});
var fluree$db$storage$core$read_branch_$_state_machine__14778__auto____1 = (function (state_39504){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39504);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39522){var ex__14781__auto__ = e39522;
var statearr_39523_39535 = state_39504;
(statearr_39523_39535[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39504[(4)]))){
var statearr_39524_39536 = state_39504;
(statearr_39524_39536[(1)] = cljs.core.first((state_39504[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39537 = state_39504;
state_39504 = G__39537;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__14778__auto__ = function(state_39504){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__14778__auto____1.call(this,state_39504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__14778__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__14778__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39525 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39525[(6)] = c__14852__auto__);

return statearr_39525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__14852__auto___39616 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39588){
var state_val_39589 = (state_39588[(1)]);
if((state_val_39589 === (7))){
var inst_39555 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_39556 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39557 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_39558 = cljs.core.PersistentHashMap.fromArrays(inst_39556,inst_39557);
var inst_39559 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39555,inst_39558);
var inst_39560 = (function(){throw inst_39559})();
var state_39588__$1 = state_39588;
var statearr_39590_39617 = state_39588__$1;
(statearr_39590_39617[(2)] = inst_39560);

(statearr_39590_39617[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (1))){
var state_39588__$1 = state_39588;
var statearr_39591_39618 = state_39588__$1;
(statearr_39591_39618[(2)] = null);

(statearr_39591_39618[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (4))){
var inst_39538 = (state_39588[(2)]);
var inst_39539 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_39540 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_39538);
var inst_39541 = cljs.core.async.close_BANG_(return_ch);
var state_39588__$1 = (function (){var statearr_39592 = state_39588;
(statearr_39592[(7)] = inst_39540);

(statearr_39592[(8)] = inst_39539);

return statearr_39592;
})();
var statearr_39593_39619 = state_39588__$1;
(statearr_39593_39619[(2)] = inst_39541);

(statearr_39593_39619[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (6))){
var inst_39552 = (state_39588[(9)]);
var inst_39551 = (state_39588[(2)]);
var inst_39552__$1 = fluree.db.util.async.throw_err(inst_39551);
var inst_39553 = (inst_39552__$1 == null);
var state_39588__$1 = (function (){var statearr_39594 = state_39588;
(statearr_39594[(9)] = inst_39552__$1);

return statearr_39594;
})();
if(cljs.core.truth_(inst_39553)){
var statearr_39595_39620 = state_39588__$1;
(statearr_39595_39620[(1)] = (7));

} else {
var statearr_39596_39621 = state_39588__$1;
(statearr_39596_39621[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (3))){
var inst_39586 = (state_39588[(2)]);
var state_39588__$1 = state_39588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39588__$1,inst_39586);
} else {
if((state_val_39589 === (12))){
var inst_39552 = (state_39588[(9)]);
var inst_39569 = (state_39588[(2)]);
var inst_39570 = cljs.core.__destructure_map(inst_39552);
var inst_39571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39570,cljs.core.cst$kw$children);
var inst_39572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39570,cljs.core.cst$kw$rhs);
var inst_39573 = config;
var inst_39574 = cljs.core.__destructure_map(inst_39573);
var inst_39575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39574,cljs.core.cst$kw$comparator);
var inst_39577 = (function (){var data = inst_39552;
var _ = inst_39569;
var map__39547 = inst_39570;
var children = inst_39571;
var rhs = inst_39572;
var map__39548 = inst_39574;
var comparator = inst_39575;
return (function (idx,p__39576){
var map__39597 = p__39576;
var map__39597__$1 = cljs.core.__destructure_map(map__39597);
var child = map__39597__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39597__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39597__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39597__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39597__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39597__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4221__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (idx === (0));
} else {
return and__4221__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_39578 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_39577,inst_39571);
var inst_39579 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_39578);
var inst_39580 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_39579,inst_39578);
var inst_39581 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_39575,inst_39580);
var inst_39582 = fluree.db.index.__GT_IndexNode(block,t,inst_39572,inst_39581,config,leftmost_QMARK_);
var inst_39583 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_39582);
var _ = (function (){var statearr_39598 = state_39588;
(statearr_39598[(4)] = cljs.core.rest((state_39588[(4)])));

return statearr_39598;
})();
var state_39588__$1 = state_39588;
var statearr_39599_39622 = state_39588__$1;
(statearr_39599_39622[(2)] = inst_39583);

(statearr_39599_39622[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (2))){
var _ = (function (){var statearr_39600 = state_39588;
(statearr_39600[(4)] = cljs.core.cons((5),(state_39588[(4)])));

return statearr_39600;
})();
var inst_39549 = fluree.db.storage.core.read_branch(conn,key);
var state_39588__$1 = state_39588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39588__$1,(6),inst_39549);
} else {
if((state_val_39589 === (11))){
var state_39588__$1 = state_39588;
var statearr_39602_39623 = state_39588__$1;
(statearr_39602_39623[(2)] = null);

(statearr_39602_39623[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (9))){
var inst_39552 = (state_39588[(9)]);
var inst_39563 = (state_39588[(2)]);
var inst_39564 = fluree.db.util.core.exception_QMARK_(inst_39552);
var state_39588__$1 = (function (){var statearr_39603 = state_39588;
(statearr_39603[(10)] = inst_39563);

return statearr_39603;
})();
if(inst_39564){
var statearr_39604_39624 = state_39588__$1;
(statearr_39604_39624[(1)] = (10));

} else {
var statearr_39605_39625 = state_39588__$1;
(statearr_39605_39625[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (5))){
var _ = (function (){var statearr_39606 = state_39588;
(statearr_39606[(4)] = cljs.core.rest((state_39588[(4)])));

return statearr_39606;
})();
var state_39588__$1 = state_39588;
var ex39601 = (state_39588__$1[(2)]);
var statearr_39607_39626 = state_39588__$1;
(statearr_39607_39626[(5)] = ex39601);


var statearr_39608_39627 = state_39588__$1;
(statearr_39608_39627[(1)] = (4));

(statearr_39608_39627[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (10))){
var inst_39552 = (state_39588[(9)]);
var inst_39566 = (function(){throw inst_39552})();
var state_39588__$1 = state_39588;
var statearr_39609_39628 = state_39588__$1;
(statearr_39609_39628[(2)] = inst_39566);

(statearr_39609_39628[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (8))){
var state_39588__$1 = state_39588;
var statearr_39610_39629 = state_39588__$1;
(statearr_39610_39629[(2)] = null);

(statearr_39610_39629[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__14778__auto____0 = (function (){
var statearr_39611 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39611[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__14778__auto__);

(statearr_39611[(1)] = (1));

return statearr_39611;
});
var fluree$db$storage$core$reify_branch_$_state_machine__14778__auto____1 = (function (state_39588){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39588);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39612){var ex__14781__auto__ = e39612;
var statearr_39613_39630 = state_39588;
(statearr_39613_39630[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39588[(4)]))){
var statearr_39614_39631 = state_39588;
(statearr_39614_39631[(1)] = cljs.core.first((state_39588[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39632 = state_39588;
state_39588 = G__39632;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__14778__auto__ = function(state_39588){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__14778__auto____1.call(this,state_39588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__14778__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__14778__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39615 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39615[(6)] = c__14852__auto___39616);

return statearr_39615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39653){
var state_val_39654 = (state_39653[(1)]);
if((state_val_39654 === (7))){
var state_39653__$1 = state_39653;
var statearr_39655_39675 = state_39653__$1;
(statearr_39655_39675[(2)] = null);

(statearr_39655_39675[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39654 === (1))){
var state_39653__$1 = state_39653;
var statearr_39656_39676 = state_39653__$1;
(statearr_39656_39676[(2)] = null);

(statearr_39656_39676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39654 === (4))){
var inst_39633 = (state_39653[(2)]);
var state_39653__$1 = state_39653;
var statearr_39657_39677 = state_39653__$1;
(statearr_39657_39677[(2)] = inst_39633);

(statearr_39657_39677[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39654 === (6))){
var inst_39639 = (state_39653[(7)]);
var inst_39641 = fluree.db.storage.core.serde(conn);
var state_39653__$1 = (function (){var statearr_39658 = state_39653;
(statearr_39658[(8)] = inst_39641);

return statearr_39658;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39653__$1,(9),inst_39639);
} else {
if((state_val_39654 === (3))){
var inst_39651 = (state_39653[(2)]);
var state_39653__$1 = state_39653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39653__$1,inst_39651);
} else {
if((state_val_39654 === (2))){
var inst_39639 = (state_39653[(7)]);
var _ = (function (){var statearr_39660 = state_39653;
(statearr_39660[(4)] = cljs.core.cons((5),(state_39653[(4)])));

return statearr_39660;
})();
var inst_39639__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_39653__$1 = (function (){var statearr_39661 = state_39653;
(statearr_39661[(7)] = inst_39639__$1);

return statearr_39661;
})();
if(cljs.core.truth_(inst_39639__$1)){
var statearr_39662_39678 = state_39653__$1;
(statearr_39662_39678[(1)] = (6));

} else {
var statearr_39663_39679 = state_39653__$1;
(statearr_39663_39679[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39654 === (9))){
var inst_39641 = (state_39653[(8)]);
var inst_39643 = (state_39653[(2)]);
var inst_39644 = fluree.db.util.async.throw_err(inst_39643);
var inst_39645 = fluree.db.serde.protocol._deserialize_leaf(inst_39641,inst_39644);
var state_39653__$1 = state_39653;
var statearr_39664_39680 = state_39653__$1;
(statearr_39664_39680[(2)] = inst_39645);

(statearr_39664_39680[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39654 === (5))){
var _ = (function (){var statearr_39665 = state_39653;
(statearr_39665[(4)] = cljs.core.rest((state_39653[(4)])));

return statearr_39665;
})();
var state_39653__$1 = state_39653;
var ex39659 = (state_39653__$1[(2)]);
var statearr_39666_39681 = state_39653__$1;
(statearr_39666_39681[(5)] = ex39659);


if((ex39659 instanceof Error)){
var statearr_39667_39682 = state_39653__$1;
(statearr_39667_39682[(1)] = (4));

(statearr_39667_39682[(5)] = null);

} else {
throw ex39659;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39654 === (8))){
var inst_39648 = (state_39653[(2)]);
var _ = (function (){var statearr_39668 = state_39653;
(statearr_39668[(4)] = cljs.core.rest((state_39653[(4)])));

return statearr_39668;
})();
var state_39653__$1 = state_39653;
var statearr_39669_39683 = state_39653__$1;
(statearr_39669_39683[(2)] = inst_39648);

(statearr_39669_39683[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__14778__auto____0 = (function (){
var statearr_39670 = [null,null,null,null,null,null,null,null,null];
(statearr_39670[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__14778__auto__);

(statearr_39670[(1)] = (1));

return statearr_39670;
});
var fluree$db$storage$core$read_leaf_$_state_machine__14778__auto____1 = (function (state_39653){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39653);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39671){var ex__14781__auto__ = e39671;
var statearr_39672_39684 = state_39653;
(statearr_39672_39684[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39653[(4)]))){
var statearr_39673_39685 = state_39653;
(statearr_39673_39685[(1)] = cljs.core.first((state_39653[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39686 = state_39653;
state_39653 = G__39686;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__14778__auto__ = function(state_39653){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__14778__auto____1.call(this,state_39653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__14778__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__14778__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39674 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39674[(6)] = c__14852__auto__);

return statearr_39674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__14852__auto___39759 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39731){
var state_val_39732 = (state_39731[(1)]);
if((state_val_39732 === (7))){
var inst_39703 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_39704 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39705 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_39706 = cljs.core.PersistentHashMap.fromArrays(inst_39704,inst_39705);
var inst_39707 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39703,inst_39706);
var inst_39708 = (function(){throw inst_39707})();
var state_39731__$1 = state_39731;
var statearr_39733_39760 = state_39731__$1;
(statearr_39733_39760[(2)] = inst_39708);

(statearr_39733_39760[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39732 === (1))){
var state_39731__$1 = state_39731;
var statearr_39734_39761 = state_39731__$1;
(statearr_39734_39761[(2)] = null);

(statearr_39734_39761[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39732 === (4))){
var inst_39687 = (state_39731[(2)]);
var inst_39688 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_39689 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_39687);
var inst_39690 = cljs.core.async.close_BANG_(return_ch);
var state_39731__$1 = (function (){var statearr_39735 = state_39731;
(statearr_39735[(7)] = inst_39688);

(statearr_39735[(8)] = inst_39689);

return statearr_39735;
})();
var statearr_39736_39762 = state_39731__$1;
(statearr_39736_39762[(2)] = inst_39690);

(statearr_39736_39762[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39732 === (6))){
var inst_39700 = (state_39731[(9)]);
var inst_39700__$1 = (state_39731[(2)]);
var inst_39701 = (inst_39700__$1 == null);
var state_39731__$1 = (function (){var statearr_39737 = state_39731;
(statearr_39737[(9)] = inst_39700__$1);

return statearr_39737;
})();
if(cljs.core.truth_(inst_39701)){
var statearr_39738_39763 = state_39731__$1;
(statearr_39738_39763[(1)] = (7));

} else {
var statearr_39739_39764 = state_39731__$1;
(statearr_39739_39764[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39732 === (3))){
var inst_39729 = (state_39731[(2)]);
var state_39731__$1 = state_39731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39731__$1,inst_39729);
} else {
if((state_val_39732 === (12))){
var inst_39700 = (state_39731[(9)]);
var inst_39717 = (state_39731[(2)]);
var inst_39718 = cljs.core.__destructure_map(inst_39700);
var inst_39719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39718,cljs.core.cst$kw$flakes);
var inst_39720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39718,cljs.core.cst$kw$his);
var inst_39721 = config;
var inst_39722 = cljs.core.__destructure_map(inst_39721);
var inst_39723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39722,cljs.core.cst$kw$comparator);
var inst_39724 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_39723,inst_39719);
var inst_39725 = fluree.db.index.data_node(block,t,inst_39724,rhs,config);
var inst_39726 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_39725);
var _ = (function (){var statearr_39740 = state_39731;
(statearr_39740[(4)] = cljs.core.rest((state_39731[(4)])));

return statearr_39740;
})();
var state_39731__$1 = (function (){var statearr_39741 = state_39731;
(statearr_39741[(10)] = inst_39720);

(statearr_39741[(11)] = inst_39717);

return statearr_39741;
})();
var statearr_39742_39765 = state_39731__$1;
(statearr_39742_39765[(2)] = inst_39726);

(statearr_39742_39765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39732 === (2))){
var _ = (function (){var statearr_39743 = state_39731;
(statearr_39743[(4)] = cljs.core.cons((5),(state_39731[(4)])));

return statearr_39743;
})();
var inst_39698 = fluree.db.storage.core.read_leaf(conn,key);
var state_39731__$1 = state_39731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39731__$1,(6),inst_39698);
} else {
if((state_val_39732 === (11))){
var state_39731__$1 = state_39731;
var statearr_39745_39766 = state_39731__$1;
(statearr_39745_39766[(2)] = null);

(statearr_39745_39766[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39732 === (9))){
var inst_39700 = (state_39731[(9)]);
var inst_39711 = (state_39731[(2)]);
var inst_39712 = fluree.db.util.core.exception_QMARK_(inst_39700);
var state_39731__$1 = (function (){var statearr_39746 = state_39731;
(statearr_39746[(12)] = inst_39711);

return statearr_39746;
})();
if(inst_39712){
var statearr_39747_39767 = state_39731__$1;
(statearr_39747_39767[(1)] = (10));

} else {
var statearr_39748_39768 = state_39731__$1;
(statearr_39748_39768[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39732 === (5))){
var _ = (function (){var statearr_39749 = state_39731;
(statearr_39749[(4)] = cljs.core.rest((state_39731[(4)])));

return statearr_39749;
})();
var state_39731__$1 = state_39731;
var ex39744 = (state_39731__$1[(2)]);
var statearr_39750_39769 = state_39731__$1;
(statearr_39750_39769[(5)] = ex39744);


var statearr_39751_39770 = state_39731__$1;
(statearr_39751_39770[(1)] = (4));

(statearr_39751_39770[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39732 === (10))){
var inst_39700 = (state_39731[(9)]);
var inst_39714 = (function(){throw inst_39700})();
var state_39731__$1 = state_39731;
var statearr_39752_39771 = state_39731__$1;
(statearr_39752_39771[(2)] = inst_39714);

(statearr_39752_39771[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39732 === (8))){
var state_39731__$1 = state_39731;
var statearr_39753_39772 = state_39731__$1;
(statearr_39753_39772[(2)] = null);

(statearr_39753_39772[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto____0 = (function (){
var statearr_39754 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39754[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto__);

(statearr_39754[(1)] = (1));

return statearr_39754;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto____1 = (function (state_39731){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39731);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39755){var ex__14781__auto__ = e39755;
var statearr_39756_39773 = state_39731;
(statearr_39756_39773[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39731[(4)]))){
var statearr_39757_39774 = state_39731;
(statearr_39757_39774[(1)] = cljs.core.first((state_39731[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39775 = state_39731;
state_39731 = G__39775;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto__ = function(state_39731){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto____1.call(this,state_39731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39758 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39758[(6)] = c__14852__auto___39759);

return statearr_39758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k39777,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__39781 = k39777;
var G__39781__$1 = (((G__39781 instanceof cljs.core.Keyword))?G__39781.fqn:null);
switch (G__39781__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39777,else__4475__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__39782){
var vec__39783 = p__39782;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39783,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39783,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39776){
var self__ = this;
var G__39776__$1 = this;
return (new cljs.core.RecordIter((0),G__39776__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__39786 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__39787 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__39788 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__39789 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__39788,G__39789) : object_cache.call(null,G__39788,G__39789));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__39790 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__39791 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__39790,G__39791) : object_cache.call(null,G__39790,G__39791));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__39786,G__39787) : object_cache.call(null,G__39786,G__39787));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__39792 = history_id;
var G__39793 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__39792,G__39793) : object_cache.call(null,G__39792,G__39793));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__39794 = (function (coll__4469__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__39794(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39778,other39779){
var self__ = this;
var this39778__$1 = this;
return (((!((other39779 == null)))) && ((((this39778__$1.constructor === other39779.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.conn,other39779.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.config,other39779.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.network,other39779.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.dbid,other39779.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.id,other39779.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.leaf,other39779.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.first,other39779.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.rhs,other39779.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.size,other39779.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.block,other39779.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.t,other39779.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.tt_id,other39779.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.leftmost_QMARK_,other39779.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.tempid,other39779.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39778__$1.__extmap,other39779.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k39777){
var self__ = this;
var this__4479__auto____$1 = this;
var G__39795 = k39777;
var G__39795__$1 = (((G__39795 instanceof cljs.core.Keyword))?G__39795.fqn:null);
switch (G__39795__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k39777);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__39776){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__39796 = cljs.core.keyword_identical_QMARK_;
var expr__39797 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__39799 = cljs.core.cst$kw$conn;
var G__39800 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39799,G__39800) : pred__39796.call(null,G__39799,G__39800));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__39776,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39801 = cljs.core.cst$kw$config;
var G__39802 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39801,G__39802) : pred__39796.call(null,G__39801,G__39802));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__39776,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39803 = cljs.core.cst$kw$network;
var G__39804 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39803,G__39804) : pred__39796.call(null,G__39803,G__39804));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__39776,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39805 = cljs.core.cst$kw$dbid;
var G__39806 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39805,G__39806) : pred__39796.call(null,G__39805,G__39806));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__39776,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39807 = cljs.core.cst$kw$id;
var G__39808 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39807,G__39808) : pred__39796.call(null,G__39807,G__39808));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__39776,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39809 = cljs.core.cst$kw$leaf;
var G__39810 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39809,G__39810) : pred__39796.call(null,G__39809,G__39810));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__39776,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39811 = cljs.core.cst$kw$first;
var G__39812 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39811,G__39812) : pred__39796.call(null,G__39811,G__39812));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__39776,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39813 = cljs.core.cst$kw$rhs;
var G__39814 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39813,G__39814) : pred__39796.call(null,G__39813,G__39814));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__39776,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39815 = cljs.core.cst$kw$size;
var G__39816 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39815,G__39816) : pred__39796.call(null,G__39815,G__39816));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__39776,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39817 = cljs.core.cst$kw$block;
var G__39818 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39817,G__39818) : pred__39796.call(null,G__39817,G__39818));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__39776,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39819 = cljs.core.cst$kw$t;
var G__39820 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39819,G__39820) : pred__39796.call(null,G__39819,G__39820));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__39776,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39821 = cljs.core.cst$kw$tt_DASH_id;
var G__39822 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39821,G__39822) : pred__39796.call(null,G__39821,G__39822));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__39776,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39823 = cljs.core.cst$kw$leftmost_QMARK_;
var G__39824 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39823,G__39824) : pred__39796.call(null,G__39823,G__39824));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__39776,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39825 = cljs.core.cst$kw$tempid;
var G__39826 = expr__39797;
return (pred__39796.cljs$core$IFn$_invoke$arity$2 ? pred__39796.cljs$core$IFn$_invoke$arity$2(G__39825,G__39826) : pred__39796.call(null,G__39825,G__39826));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__39776,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__39776),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__39776){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__39776,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__39780){
var extmap__4512__auto__ = (function (){var G__39827 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39780,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__39780)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39827);
} else {
return G__39827;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__39780),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__39780),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__39830 = blank_db;
var map__39830__$1 = cljs.core.__destructure_map(map__39830);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39830__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39830__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39830__$1,cljs.core.cst$kw$index_DASH_configs);
var map__39831 = root_data;
var map__39831__$1 = cljs.core.__destructure_map(map__39831);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39831__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39831__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39831__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39831__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39853){
var state_val_39854 = (state_39853[(1)]);
if((state_val_39854 === (7))){
var state_39853__$1 = state_39853;
var statearr_39855_39875 = state_39853__$1;
(statearr_39855_39875[(2)] = null);

(statearr_39855_39875[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39854 === (1))){
var state_39853__$1 = state_39853;
var statearr_39856_39876 = state_39853__$1;
(statearr_39856_39876[(2)] = null);

(statearr_39856_39876[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39854 === (4))){
var inst_39832 = (state_39853[(2)]);
var state_39853__$1 = state_39853;
var statearr_39857_39877 = state_39853__$1;
(statearr_39857_39877[(2)] = inst_39832);

(statearr_39857_39877[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39854 === (6))){
var inst_39839 = (state_39853[(7)]);
var inst_39841 = fluree.db.storage.core.serde(conn);
var state_39853__$1 = (function (){var statearr_39858 = state_39853;
(statearr_39858[(8)] = inst_39841);

return statearr_39858;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39853__$1,(9),inst_39839);
} else {
if((state_val_39854 === (3))){
var inst_39851 = (state_39853[(2)]);
var state_39853__$1 = state_39853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39853__$1,inst_39851);
} else {
if((state_val_39854 === (2))){
var inst_39839 = (state_39853[(7)]);
var _ = (function (){var statearr_39860 = state_39853;
(statearr_39860[(4)] = cljs.core.cons((5),(state_39853[(4)])));

return statearr_39860;
})();
var inst_39838 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_39839__$1 = fluree.db.storage.core.storage_read(conn,inst_39838);
var state_39853__$1 = (function (){var statearr_39861 = state_39853;
(statearr_39861[(7)] = inst_39839__$1);

return statearr_39861;
})();
if(cljs.core.truth_(inst_39839__$1)){
var statearr_39862_39878 = state_39853__$1;
(statearr_39862_39878[(1)] = (6));

} else {
var statearr_39863_39879 = state_39853__$1;
(statearr_39863_39879[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39854 === (9))){
var inst_39841 = (state_39853[(8)]);
var inst_39843 = (state_39853[(2)]);
var inst_39844 = fluree.db.util.async.throw_err(inst_39843);
var inst_39845 = fluree.db.serde.protocol._deserialize_garbage(inst_39841,inst_39844);
var state_39853__$1 = state_39853;
var statearr_39864_39880 = state_39853__$1;
(statearr_39864_39880[(2)] = inst_39845);

(statearr_39864_39880[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39854 === (5))){
var _ = (function (){var statearr_39865 = state_39853;
(statearr_39865[(4)] = cljs.core.rest((state_39853[(4)])));

return statearr_39865;
})();
var state_39853__$1 = state_39853;
var ex39859 = (state_39853__$1[(2)]);
var statearr_39866_39881 = state_39853__$1;
(statearr_39866_39881[(5)] = ex39859);


if((ex39859 instanceof Error)){
var statearr_39867_39882 = state_39853__$1;
(statearr_39867_39882[(1)] = (4));

(statearr_39867_39882[(5)] = null);

} else {
throw ex39859;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39854 === (8))){
var inst_39848 = (state_39853[(2)]);
var _ = (function (){var statearr_39868 = state_39853;
(statearr_39868[(4)] = cljs.core.rest((state_39853[(4)])));

return statearr_39868;
})();
var state_39853__$1 = state_39853;
var statearr_39869_39883 = state_39853__$1;
(statearr_39869_39883[(2)] = inst_39848);

(statearr_39869_39883[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__14778__auto____0 = (function (){
var statearr_39870 = [null,null,null,null,null,null,null,null,null];
(statearr_39870[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__14778__auto__);

(statearr_39870[(1)] = (1));

return statearr_39870;
});
var fluree$db$storage$core$read_garbage_$_state_machine__14778__auto____1 = (function (state_39853){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39853);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39871){var ex__14781__auto__ = e39871;
var statearr_39872_39884 = state_39853;
(statearr_39872_39884[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39853[(4)]))){
var statearr_39873_39885 = state_39853;
(statearr_39873_39885[(1)] = cljs.core.first((state_39853[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39886 = state_39853;
state_39853 = G__39886;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__14778__auto__ = function(state_39853){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__14778__auto____1.call(this,state_39853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__14778__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__14778__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39874 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39874[(6)] = c__14852__auto__);

return statearr_39874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39908){
var state_val_39909 = (state_39908[(1)]);
if((state_val_39909 === (7))){
var state_39908__$1 = state_39908;
var statearr_39910_39930 = state_39908__$1;
(statearr_39910_39930[(2)] = null);

(statearr_39910_39930[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39909 === (1))){
var state_39908__$1 = state_39908;
var statearr_39911_39931 = state_39908__$1;
(statearr_39911_39931[(2)] = null);

(statearr_39911_39931[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39909 === (4))){
var inst_39887 = (state_39908[(2)]);
var state_39908__$1 = state_39908;
var statearr_39912_39932 = state_39908__$1;
(statearr_39912_39932[(2)] = inst_39887);

(statearr_39912_39932[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39909 === (6))){
var inst_39894 = (state_39908[(7)]);
var inst_39896 = fluree.db.storage.core.serde(conn);
var state_39908__$1 = (function (){var statearr_39913 = state_39908;
(statearr_39913[(8)] = inst_39896);

return statearr_39913;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39908__$1,(9),inst_39894);
} else {
if((state_val_39909 === (3))){
var inst_39906 = (state_39908[(2)]);
var state_39908__$1 = state_39908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39908__$1,inst_39906);
} else {
if((state_val_39909 === (2))){
var inst_39894 = (state_39908[(7)]);
var _ = (function (){var statearr_39915 = state_39908;
(statearr_39915[(4)] = cljs.core.cons((5),(state_39908[(4)])));

return statearr_39915;
})();
var inst_39893 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_39894__$1 = fluree.db.storage.core.storage_read(conn,inst_39893);
var state_39908__$1 = (function (){var statearr_39916 = state_39908;
(statearr_39916[(7)] = inst_39894__$1);

return statearr_39916;
})();
if(cljs.core.truth_(inst_39894__$1)){
var statearr_39917_39933 = state_39908__$1;
(statearr_39917_39933[(1)] = (6));

} else {
var statearr_39918_39934 = state_39908__$1;
(statearr_39918_39934[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39909 === (9))){
var inst_39896 = (state_39908[(8)]);
var inst_39898 = (state_39908[(2)]);
var inst_39899 = fluree.db.util.async.throw_err(inst_39898);
var inst_39900 = fluree.db.serde.protocol._deserialize_db_root(inst_39896,inst_39899);
var state_39908__$1 = state_39908;
var statearr_39919_39935 = state_39908__$1;
(statearr_39919_39935[(2)] = inst_39900);

(statearr_39919_39935[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39909 === (5))){
var _ = (function (){var statearr_39920 = state_39908;
(statearr_39920[(4)] = cljs.core.rest((state_39908[(4)])));

return statearr_39920;
})();
var state_39908__$1 = state_39908;
var ex39914 = (state_39908__$1[(2)]);
var statearr_39921_39936 = state_39908__$1;
(statearr_39921_39936[(5)] = ex39914);


if((ex39914 instanceof Error)){
var statearr_39922_39937 = state_39908__$1;
(statearr_39922_39937[(1)] = (4));

(statearr_39922_39937[(5)] = null);

} else {
throw ex39914;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39909 === (8))){
var inst_39903 = (state_39908[(2)]);
var _ = (function (){var statearr_39923 = state_39908;
(statearr_39923[(4)] = cljs.core.rest((state_39908[(4)])));

return statearr_39923;
})();
var state_39908__$1 = state_39908;
var statearr_39924_39938 = state_39908__$1;
(statearr_39924_39938[(2)] = inst_39903);

(statearr_39924_39938[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__14778__auto____0 = (function (){
var statearr_39925 = [null,null,null,null,null,null,null,null,null];
(statearr_39925[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__14778__auto__);

(statearr_39925[(1)] = (1));

return statearr_39925;
});
var fluree$db$storage$core$read_db_root_$_state_machine__14778__auto____1 = (function (state_39908){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39908);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39926){var ex__14781__auto__ = e39926;
var statearr_39927_39939 = state_39908;
(statearr_39927_39939[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39908[(4)]))){
var statearr_39928_39940 = state_39908;
(statearr_39928_39940[(1)] = cljs.core.first((state_39908[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__39941 = state_39908;
state_39908 = G__39941;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__14778__auto__ = function(state_39908){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__14778__auto____1.call(this,state_39908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__14778__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__14778__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_39929 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_39929[(6)] = c__14852__auto__);

return statearr_39929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_39977){
var state_val_39978 = (state_39977[(1)]);
if((state_val_39978 === (7))){
var inst_39951 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_39952 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39953 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_39954 = cljs.core.PersistentHashMap.fromArrays(inst_39952,inst_39953);
var inst_39955 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39951,inst_39954);
var inst_39956 = (function(){throw inst_39955})();
var state_39977__$1 = state_39977;
var statearr_39979_40001 = state_39977__$1;
(statearr_39979_40001[(2)] = inst_39956);

(statearr_39979_40001[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (1))){
var state_39977__$1 = state_39977;
var statearr_39980_40002 = state_39977__$1;
(statearr_39980_40002[(2)] = null);

(statearr_39980_40002[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (4))){
var inst_39942 = (state_39977[(2)]);
var state_39977__$1 = state_39977;
var statearr_39981_40003 = state_39977__$1;
(statearr_39981_40003[(2)] = inst_39942);

(statearr_39981_40003[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (6))){
var state_39977__$1 = state_39977;
var statearr_39982_40004 = state_39977__$1;
(statearr_39982_40004[(2)] = null);

(statearr_39982_40004[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (3))){
var inst_39975 = (state_39977[(2)]);
var state_39977__$1 = state_39977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39977__$1,inst_39975);
} else {
if((state_val_39978 === (2))){
var inst_39948 = (state_39977[(7)]);
var _ = (function (){var statearr_39983 = state_39977;
(statearr_39983[(4)] = cljs.core.cons((5),(state_39977[(4)])));

return statearr_39983;
})();
var inst_39948__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_39977__$1 = (function (){var statearr_39984 = state_39977;
(statearr_39984[(7)] = inst_39948__$1);

return statearr_39984;
})();
if(cljs.core.truth_(inst_39948__$1)){
var statearr_39985_40005 = state_39977__$1;
(statearr_39985_40005[(1)] = (6));

} else {
var statearr_39986_40006 = state_39977__$1;
(statearr_39986_40006[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (11))){
var inst_39967 = (state_39977[(8)]);
var inst_39970 = (state_39977[(2)]);
var inst_39971 = fluree.db.util.async.throw_err(inst_39970);
var inst_39972 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39967,cljs.core.cst$kw$settings,inst_39971);
var _ = (function (){var statearr_39988 = state_39977;
(statearr_39988[(4)] = cljs.core.rest((state_39977[(4)])));

return statearr_39988;
})();
var state_39977__$1 = state_39977;
var statearr_39989_40007 = state_39977__$1;
(statearr_39989_40007[(2)] = inst_39972);

(statearr_39989_40007[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (9))){
var inst_39962 = (state_39977[(9)]);
var inst_39960 = (state_39977[(2)]);
var inst_39961 = fluree.db.util.async.throw_err(inst_39960);
var inst_39962__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_39961);
var inst_39963 = fluree.db.query.schema.schema_map(inst_39962__$1);
var state_39977__$1 = (function (){var statearr_39990 = state_39977;
(statearr_39990[(9)] = inst_39962__$1);

return statearr_39990;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39977__$1,(10),inst_39963);
} else {
if((state_val_39978 === (5))){
var _ = (function (){var statearr_39991 = state_39977;
(statearr_39991[(4)] = cljs.core.rest((state_39977[(4)])));

return statearr_39991;
})();
var state_39977__$1 = state_39977;
var ex39987 = (state_39977__$1[(2)]);
var statearr_39992_40008 = state_39977__$1;
(statearr_39992_40008[(5)] = ex39987);


if((ex39987 instanceof Error)){
var statearr_39993_40009 = state_39977__$1;
(statearr_39993_40009[(1)] = (4));

(statearr_39993_40009[(5)] = null);

} else {
throw ex39987;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (10))){
var inst_39962 = (state_39977[(9)]);
var inst_39967 = (state_39977[(8)]);
var inst_39965 = (state_39977[(2)]);
var inst_39966 = fluree.db.util.async.throw_err(inst_39965);
var inst_39967__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39962,cljs.core.cst$kw$schema,inst_39966);
var inst_39968 = fluree.db.query.schema.setting_map(inst_39967__$1);
var state_39977__$1 = (function (){var statearr_39994 = state_39977;
(statearr_39994[(8)] = inst_39967__$1);

return statearr_39994;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39977__$1,(11),inst_39968);
} else {
if((state_val_39978 === (8))){
var inst_39948 = (state_39977[(7)]);
var inst_39958 = (state_39977[(2)]);
var state_39977__$1 = (function (){var statearr_39995 = state_39977;
(statearr_39995[(10)] = inst_39958);

return statearr_39995;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39977__$1,(9),inst_39948);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__14778__auto____0 = (function (){
var statearr_39996 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39996[(0)] = fluree$db$storage$core$reify_db_$_state_machine__14778__auto__);

(statearr_39996[(1)] = (1));

return statearr_39996;
});
var fluree$db$storage$core$reify_db_$_state_machine__14778__auto____1 = (function (state_39977){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_39977);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e39997){var ex__14781__auto__ = e39997;
var statearr_39998_40010 = state_39977;
(statearr_39998_40010[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_39977[(4)]))){
var statearr_39999_40011 = state_39977;
(statearr_39999_40011[(1)] = cljs.core.first((state_39977[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__40012 = state_39977;
state_39977 = G__40012;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__14778__auto__ = function(state_39977){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__14778__auto____1.call(this,state_39977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__14778__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__14778__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_40000 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_40000[(6)] = c__14852__auto__);

return statearr_40000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__40014 = arguments.length;
switch (G__40014) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_40067){
var state_val_40068 = (state_40067[(1)]);
if((state_val_40068 === (7))){
var inst_40024 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_40025 = (new Error(inst_40024));
var inst_40026 = (function(){throw inst_40025})();
var state_40067__$1 = state_40067;
var statearr_40069_40109 = state_40067__$1;
(statearr_40069_40109[(2)] = inst_40026);

(statearr_40069_40109[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (20))){
var inst_40058 = (state_40067[(2)]);
var state_40067__$1 = state_40067;
var statearr_40070_40110 = state_40067__$1;
(statearr_40070_40110[(2)] = inst_40058);

(statearr_40070_40110[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (1))){
var state_40067__$1 = state_40067;
var statearr_40071_40111 = state_40067__$1;
(statearr_40071_40111[(2)] = null);

(statearr_40071_40111[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (4))){
var inst_40015 = (state_40067[(2)]);
var state_40067__$1 = state_40067;
var statearr_40072_40112 = state_40067__$1;
(statearr_40072_40112[(2)] = inst_40015);

(statearr_40072_40112[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (15))){
var inst_40033 = (state_40067[(7)]);
var state_40067__$1 = state_40067;
var statearr_40073_40113 = state_40067__$1;
(statearr_40073_40113[(2)] = inst_40033);

(statearr_40073_40113[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (21))){
var inst_40032 = (state_40067[(8)]);
var inst_40033 = (state_40067[(7)]);
var inst_40037 = (state_40067[(9)]);
var inst_40051 = (inst_40032 + (1));
var inst_40052 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40033,inst_40037);
var inst_40032__$1 = inst_40051;
var inst_40033__$1 = inst_40052;
var state_40067__$1 = (function (){var statearr_40074 = state_40067;
(statearr_40074[(8)] = inst_40032__$1);

(statearr_40074[(7)] = inst_40033__$1);

return statearr_40074;
})();
var statearr_40075_40114 = state_40067__$1;
(statearr_40075_40114[(2)] = null);

(statearr_40075_40114[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (13))){
var inst_40037 = (state_40067[(9)]);
var inst_40041 = (inst_40037 instanceof Error);
var state_40067__$1 = state_40067;
var statearr_40076_40115 = state_40067__$1;
(statearr_40076_40115[(2)] = inst_40041);

(statearr_40076_40115[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (22))){
var state_40067__$1 = state_40067;
var statearr_40077_40116 = state_40067__$1;
(statearr_40077_40116[(2)] = null);

(statearr_40077_40116[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (6))){
var state_40067__$1 = state_40067;
var statearr_40078_40117 = state_40067__$1;
(statearr_40078_40117[(2)] = null);

(statearr_40078_40117[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (17))){
var inst_40060 = (state_40067[(2)]);
var state_40067__$1 = state_40067;
var statearr_40079_40118 = state_40067__$1;
(statearr_40079_40118[(2)] = inst_40060);

(statearr_40079_40118[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (3))){
var inst_40065 = (state_40067[(2)]);
var state_40067__$1 = state_40067;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40067__$1,inst_40065);
} else {
if((state_val_40068 === (12))){
var inst_40038 = (state_40067[(10)]);
var state_40067__$1 = state_40067;
var statearr_40080_40119 = state_40067__$1;
(statearr_40080_40119[(2)] = inst_40038);

(statearr_40080_40119[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (2))){
var _ = (function (){var statearr_40081 = state_40067;
(statearr_40081[(4)] = cljs.core.cons((5),(state_40067[(4)])));

return statearr_40081;
})();
var inst_40021 = (end >= start);
var state_40067__$1 = state_40067;
if(cljs.core.truth_(inst_40021)){
var statearr_40082_40120 = state_40067__$1;
(statearr_40082_40120[(1)] = (6));

} else {
var statearr_40083_40121 = state_40067__$1;
(statearr_40083_40121[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (23))){
var inst_40056 = (state_40067[(2)]);
var state_40067__$1 = state_40067;
var statearr_40084_40122 = state_40067__$1;
(statearr_40084_40122[(2)] = inst_40056);

(statearr_40084_40122[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (19))){
var state_40067__$1 = state_40067;
var statearr_40085_40123 = state_40067__$1;
(statearr_40085_40123[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (11))){
var inst_40037 = (state_40067[(9)]);
var inst_40038 = (state_40067[(10)]);
var inst_40037__$1 = (state_40067[(2)]);
var inst_40038__$1 = (inst_40037__$1 == null);
var state_40067__$1 = (function (){var statearr_40088 = state_40067;
(statearr_40088[(9)] = inst_40037__$1);

(statearr_40088[(10)] = inst_40038__$1);

return statearr_40088;
})();
if(cljs.core.truth_(inst_40038__$1)){
var statearr_40089_40124 = state_40067__$1;
(statearr_40089_40124[(1)] = (12));

} else {
var statearr_40090_40125 = state_40067__$1;
(statearr_40090_40125[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (9))){
var inst_40032 = (state_40067[(8)]);
var inst_40035 = fluree.db.storage.core.read_block(conn,network,dbid,inst_40032);
var state_40067__$1 = state_40067;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40067__$1,(11),inst_40035);
} else {
if((state_val_40068 === (5))){
var _ = (function (){var statearr_40091 = state_40067;
(statearr_40091[(4)] = cljs.core.rest((state_40067[(4)])));

return statearr_40091;
})();
var state_40067__$1 = state_40067;
var ex40087 = (state_40067__$1[(2)]);
var statearr_40092_40126 = state_40067__$1;
(statearr_40092_40126[(5)] = ex40087);


if((ex40087 instanceof Error)){
var statearr_40093_40127 = state_40067__$1;
(statearr_40093_40127[(1)] = (4));

(statearr_40093_40127[(5)] = null);

} else {
throw ex40087;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (14))){
var inst_40043 = (state_40067[(2)]);
var state_40067__$1 = state_40067;
if(cljs.core.truth_(inst_40043)){
var statearr_40094_40128 = state_40067__$1;
(statearr_40094_40128[(1)] = (15));

} else {
var statearr_40095_40129 = state_40067__$1;
(statearr_40095_40129[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (16))){
var inst_40032 = (state_40067[(8)]);
var inst_40046 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40032,end);
var state_40067__$1 = state_40067;
if(inst_40046){
var statearr_40096_40130 = state_40067__$1;
(statearr_40096_40130[(1)] = (18));

} else {
var statearr_40097_40131 = state_40067__$1;
(statearr_40097_40131[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (10))){
var inst_40062 = (state_40067[(2)]);
var _ = (function (){var statearr_40098 = state_40067;
(statearr_40098[(4)] = cljs.core.rest((state_40067[(4)])));

return statearr_40098;
})();
var state_40067__$1 = state_40067;
var statearr_40099_40132 = state_40067__$1;
(statearr_40099_40132[(2)] = inst_40062);

(statearr_40099_40132[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (18))){
var inst_40033 = (state_40067[(7)]);
var inst_40037 = (state_40067[(9)]);
var inst_40048 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40033,inst_40037);
var state_40067__$1 = state_40067;
var statearr_40100_40133 = state_40067__$1;
(statearr_40100_40133[(2)] = inst_40048);

(statearr_40100_40133[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40068 === (8))){
var inst_40028 = (state_40067[(2)]);
var inst_40029 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_40030 = start;
var inst_40031 = cljs.core.PersistentVector.EMPTY;
var inst_40032 = inst_40030;
var inst_40033 = inst_40031;
var state_40067__$1 = (function (){var statearr_40101 = state_40067;
(statearr_40101[(8)] = inst_40032);

(statearr_40101[(7)] = inst_40033);

(statearr_40101[(11)] = inst_40029);

(statearr_40101[(12)] = inst_40028);

return statearr_40101;
})();
var statearr_40102_40134 = state_40067__$1;
(statearr_40102_40134[(2)] = null);

(statearr_40102_40134[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__14778__auto__ = null;
var fluree$db$storage$core$state_machine__14778__auto____0 = (function (){
var statearr_40103 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40103[(0)] = fluree$db$storage$core$state_machine__14778__auto__);

(statearr_40103[(1)] = (1));

return statearr_40103;
});
var fluree$db$storage$core$state_machine__14778__auto____1 = (function (state_40067){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_40067);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e40104){var ex__14781__auto__ = e40104;
var statearr_40105_40135 = state_40067;
(statearr_40105_40135[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_40067[(4)]))){
var statearr_40106_40136 = state_40067;
(statearr_40106_40136[(1)] = cljs.core.first((state_40067[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__40137 = state_40067;
state_40067 = G__40137;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__14778__auto__ = function(state_40067){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__14778__auto____1.call(this,state_40067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__14778__auto____0;
fluree$db$storage$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__14778__auto____1;
return fluree$db$storage$core$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_40107 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_40107[(6)] = c__14852__auto__);

return statearr_40107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_40153){
var state_val_40154 = (state_40153[(1)]);
if((state_val_40154 === (1))){
var state_40153__$1 = state_40153;
var statearr_40155_40169 = state_40153__$1;
(statearr_40155_40169[(2)] = null);

(statearr_40155_40169[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40154 === (2))){
var _ = (function (){var statearr_40156 = state_40153;
(statearr_40156[(4)] = cljs.core.cons((5),(state_40153[(4)])));

return statearr_40156;
})();
var inst_40144 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_40153__$1 = state_40153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40153__$1,(6),inst_40144);
} else {
if((state_val_40154 === (3))){
var inst_40151 = (state_40153[(2)]);
var state_40153__$1 = state_40153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40153__$1,inst_40151);
} else {
if((state_val_40154 === (4))){
var inst_40138 = (state_40153[(2)]);
var state_40153__$1 = state_40153;
var statearr_40158_40170 = state_40153__$1;
(statearr_40158_40170[(2)] = inst_40138);

(statearr_40158_40170[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40154 === (5))){
var _ = (function (){var statearr_40159 = state_40153;
(statearr_40159[(4)] = cljs.core.rest((state_40153[(4)])));

return statearr_40159;
})();
var state_40153__$1 = state_40153;
var ex40157 = (state_40153__$1[(2)]);
var statearr_40160_40171 = state_40153__$1;
(statearr_40160_40171[(5)] = ex40157);


if((ex40157 instanceof Error)){
var statearr_40161_40172 = state_40153__$1;
(statearr_40161_40172[(1)] = (4));

(statearr_40161_40172[(5)] = null);

} else {
throw ex40157;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40154 === (6))){
var inst_40146 = (state_40153[(2)]);
var inst_40147 = fluree.db.util.async.throw_err(inst_40146);
var inst_40148 = cljs.core.first(inst_40147);
var _ = (function (){var statearr_40162 = state_40153;
(statearr_40162[(4)] = cljs.core.rest((state_40153[(4)])));

return statearr_40162;
})();
var state_40153__$1 = state_40153;
var statearr_40163_40173 = state_40153__$1;
(statearr_40163_40173[(2)] = inst_40148);

(statearr_40163_40173[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__14778__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__14778__auto____0 = (function (){
var statearr_40164 = [null,null,null,null,null,null,null];
(statearr_40164[(0)] = fluree$db$storage$core$block_$_state_machine__14778__auto__);

(statearr_40164[(1)] = (1));

return statearr_40164;
});
var fluree$db$storage$core$block_$_state_machine__14778__auto____1 = (function (state_40153){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_40153);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e40165){var ex__14781__auto__ = e40165;
var statearr_40166_40174 = state_40153;
(statearr_40166_40174[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_40153[(4)]))){
var statearr_40167_40175 = state_40153;
(statearr_40167_40175[(1)] = cljs.core.first((state_40153[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__40176 = state_40153;
state_40153 = G__40176;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__14778__auto__ = function(state_40153){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__14778__auto____1.call(this,state_40153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__14778__auto____0;
fluree$db$storage$core$block_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__14778__auto____1;
return fluree$db$storage$core$block_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_40168 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_40168[(6)] = c__14852__auto__);

return statearr_40168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
