// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k41925,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__41929 = k41925;
var G__41929__$1 = (((G__41929 instanceof cljs.core.Keyword))?G__41929.fqn:null);
switch (G__41929__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k41925,else__4475__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__41930){
var vec__41931 = p__41930;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41931,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41931,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__41924){
var self__ = this;
var G__41924__$1 = this;
return (new cljs.core.RecordIter((0),G__41924__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__41934 = (function (coll__4469__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__41934(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this41926,other41927){
var self__ = this;
var this41926__$1 = this;
return (((!((other41927 == null)))) && ((((this41926__$1.constructor === other41927.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.conn,other41927.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.network,other41927.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.dbid,other41927.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.db_name,other41927.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.update_chan,other41927.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.transact_chan,other41927.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.state,other41927.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.schema_cache,other41927.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.blank_db,other41927.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.close,other41927.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.id,other41927.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41926__$1.__extmap,other41927.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k41925){
var self__ = this;
var this__4479__auto____$1 = this;
var G__41935 = k41925;
var G__41935__$1 = (((G__41935 instanceof cljs.core.Keyword))?G__41935.fqn:null);
switch (G__41935__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k41925);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__41924){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__41936 = cljs.core.keyword_identical_QMARK_;
var expr__41937 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__41939 = cljs.core.cst$kw$conn;
var G__41940 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41939,G__41940) : pred__41936.call(null,G__41939,G__41940));
})())){
return (new fluree.db.session.DbSession(G__41924,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41941 = cljs.core.cst$kw$network;
var G__41942 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41941,G__41942) : pred__41936.call(null,G__41941,G__41942));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__41924,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41943 = cljs.core.cst$kw$dbid;
var G__41944 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41943,G__41944) : pred__41936.call(null,G__41943,G__41944));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__41924,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41945 = cljs.core.cst$kw$db_DASH_name;
var G__41946 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41945,G__41946) : pred__41936.call(null,G__41945,G__41946));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__41924,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41947 = cljs.core.cst$kw$update_DASH_chan;
var G__41948 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41947,G__41948) : pred__41936.call(null,G__41947,G__41948));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__41924,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41949 = cljs.core.cst$kw$transact_DASH_chan;
var G__41950 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41949,G__41950) : pred__41936.call(null,G__41949,G__41950));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__41924,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41951 = cljs.core.cst$kw$state;
var G__41952 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41951,G__41952) : pred__41936.call(null,G__41951,G__41952));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__41924,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41953 = cljs.core.cst$kw$schema_DASH_cache;
var G__41954 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41953,G__41954) : pred__41936.call(null,G__41953,G__41954));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__41924,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41955 = cljs.core.cst$kw$blank_DASH_db;
var G__41956 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41955,G__41956) : pred__41936.call(null,G__41955,G__41956));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__41924,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41957 = cljs.core.cst$kw$close;
var G__41958 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41957,G__41958) : pred__41936.call(null,G__41957,G__41958));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__41924,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41959 = cljs.core.cst$kw$id;
var G__41960 = expr__41937;
return (pred__41936.cljs$core$IFn$_invoke$arity$2 ? pred__41936.cljs$core$IFn$_invoke$arity$2(G__41959,G__41960) : pred__41936.call(null,G__41959,G__41960));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__41924,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__41924),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__41924){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__41924,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__41928){
var extmap__4512__auto__ = (function (){var G__41961 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__41928,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__41928)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__41961);
} else {
return G__41961;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__41928),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__41928),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__41964 = session;
var map__41964__$1 = cljs.core.__destructure_map(map__41964);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41964__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41964__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__14852__auto___42116 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_42068){
var state_val_42069 = (state_42068[(1)]);
if((state_val_42069 === (7))){
var inst_41985 = (state_42068[(7)]);
var inst_41990 = cljs.core.empty_QMARK_(inst_41985);
var state_42068__$1 = state_42068;
if(inst_41990){
var statearr_42070_42117 = state_42068__$1;
(statearr_42070_42117[(1)] = (10));

} else {
var statearr_42071_42118 = state_42068__$1;
(statearr_42071_42118[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (20))){
var inst_41977 = (state_42068[(8)]);
var inst_42016 = (state_42068[(9)]);
var inst_41976 = (state_42068[(10)]);
var inst_41978 = (state_42068[(11)]);
var inst_42021 = fluree.db.storage.core.read_block(inst_41976,inst_41977,inst_41978,inst_42016);
var state_42068__$1 = state_42068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42068__$1,(22),inst_42021);
} else {
if((state_val_42069 === (27))){
var inst_42052 = (state_42068[(12)]);
var inst_42057 = (state_42068[(13)]);
var inst_42055 = (state_42068[(2)]);
var inst_42056 = fluree.db.util.async.throw_err(inst_42055);
var inst_42057__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42052,cljs.core.cst$kw$schema,inst_42056);
var inst_42058 = fluree.db.query.schema.setting_map(inst_42057__$1);
var state_42068__$1 = (function (){var statearr_42072 = state_42068;
(statearr_42072[(13)] = inst_42057__$1);

return statearr_42072;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42068__$1,(28),inst_42058);
} else {
if((state_val_42069 === (1))){
var state_42068__$1 = state_42068;
var statearr_42073_42119 = state_42068__$1;
(statearr_42073_42119[(2)] = null);

(statearr_42073_42119[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (24))){
var inst_41977 = (state_42068[(8)]);
var inst_42016 = (state_42068[(9)]);
var inst_41978 = (state_42068[(11)]);
var inst_42038 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42016)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41977),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41978),"."].join('');
var inst_42039 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42040 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_42041 = cljs.core.PersistentHashMap.fromArrays(inst_42039,inst_42040);
var inst_42042 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42038,inst_42041);
var inst_42043 = (function(){throw inst_42042})();
var state_42068__$1 = state_42068;
var statearr_42074_42120 = state_42068__$1;
(statearr_42074_42120[(2)] = inst_42043);

(statearr_42074_42120[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (4))){
var inst_41965 = (state_42068[(2)]);
var inst_41966 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_41965);
var state_42068__$1 = state_42068;
var statearr_42075_42121 = state_42068__$1;
(statearr_42075_42121[(2)] = inst_41966);

(statearr_42075_42121[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (15))){
var state_42068__$1 = state_42068;
var statearr_42076_42122 = state_42068__$1;
(statearr_42076_42122[(2)] = null);

(statearr_42076_42122[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (21))){
var inst_42047 = (state_42068[(2)]);
var state_42068__$1 = state_42068;
var statearr_42077_42123 = state_42068__$1;
(statearr_42077_42123[(2)] = inst_42047);

(statearr_42077_42123[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (13))){
var inst_41985 = (state_42068[(7)]);
var inst_42010 = (state_42068[(14)]);
var inst_42009 = (state_42068[(2)]);
var inst_42010__$1 = fluree.db.util.async.throw_err(inst_42009);
var inst_42011 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_41985);
var state_42068__$1 = (function (){var statearr_42078 = state_42068;
(statearr_42078[(15)] = inst_42011);

(statearr_42078[(14)] = inst_42010__$1);

return statearr_42078;
})();
if(cljs.core.truth_(inst_42010__$1)){
var statearr_42079_42124 = state_42068__$1;
(statearr_42079_42124[(1)] = (14));

} else {
var statearr_42080_42125 = state_42068__$1;
(statearr_42080_42125[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (22))){
var inst_42024 = (state_42068[(16)]);
var inst_42023 = (state_42068[(2)]);
var inst_42024__$1 = fluree.db.util.async.throw_err(inst_42023);
var state_42068__$1 = (function (){var statearr_42081 = state_42068;
(statearr_42081[(16)] = inst_42024__$1);

return statearr_42081;
})();
if(cljs.core.truth_(inst_42024__$1)){
var statearr_42082_42126 = state_42068__$1;
(statearr_42082_42126[(1)] = (23));

} else {
var statearr_42083_42127 = state_42068__$1;
(statearr_42083_42127[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (6))){
var inst_41985 = (state_42068[(7)]);
var inst_41984 = (state_42068[(2)]);
var inst_41985__$1 = fluree.db.util.async.throw_err(inst_41984);
var inst_41986 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_41985__$1);
var inst_41987 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_41986);
var inst_41988 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_41987);
var state_42068__$1 = (function (){var statearr_42084 = state_42068;
(statearr_42084[(7)] = inst_41985__$1);

return statearr_42084;
})();
if(inst_41988){
var statearr_42085_42128 = state_42068__$1;
(statearr_42085_42128[(1)] = (7));

} else {
var statearr_42086_42129 = state_42068__$1;
(statearr_42086_42129[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (28))){
var inst_42057 = (state_42068[(13)]);
var inst_42060 = (state_42068[(2)]);
var inst_42061 = fluree.db.util.async.throw_err(inst_42060);
var inst_42062 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42057,cljs.core.cst$kw$settings,inst_42061);
var inst_42063 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_42062);
var _ = (function (){var statearr_42087 = state_42068;
(statearr_42087[(4)] = cljs.core.rest((state_42068[(4)])));

return statearr_42087;
})();
var state_42068__$1 = state_42068;
var statearr_42088_42130 = state_42068__$1;
(statearr_42088_42130[(2)] = inst_42063);

(statearr_42088_42130[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (25))){
var inst_42045 = (state_42068[(2)]);
var state_42068__$1 = state_42068;
var statearr_42089_42131 = state_42068__$1;
(statearr_42089_42131[(2)] = inst_42045);

(statearr_42089_42131[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (17))){
var inst_42016 = (state_42068[(9)]);
var inst_42011 = (state_42068[(15)]);
var inst_42018 = (inst_42016 > inst_42011);
var state_42068__$1 = state_42068;
if(cljs.core.truth_(inst_42018)){
var statearr_42090_42132 = state_42068__$1;
(statearr_42090_42132[(1)] = (19));

} else {
var statearr_42091_42133 = state_42068__$1;
(statearr_42091_42133[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (3))){
var inst_42066 = (state_42068[(2)]);
var state_42068__$1 = state_42068;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42068__$1,inst_42066);
} else {
if((state_val_42069 === (12))){
var inst_41997 = (state_42068[(2)]);
var inst_41998 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41999 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_42000 = cljs.core.PersistentHashMap.fromArrays(inst_41998,inst_41999);
var inst_42001 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41997,inst_42000);
var inst_42002 = (function(){throw inst_42001})();
var state_42068__$1 = state_42068;
var statearr_42092_42134 = state_42068__$1;
(statearr_42092_42134[(2)] = inst_42002);

(statearr_42092_42134[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (2))){
var inst_41977 = (state_42068[(8)]);
var inst_41976 = (state_42068[(10)]);
var inst_41978 = (state_42068[(11)]);
var _ = (function (){var statearr_42093 = state_42068;
(statearr_42093[(4)] = cljs.core.cons((5),(state_42068[(4)])));

return statearr_42093;
})();
var inst_41973 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_41974 = session;
var inst_41975 = cljs.core.__destructure_map(inst_41974);
var inst_41976__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41975,cljs.core.cst$kw$conn);
var inst_41977__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41975,cljs.core.cst$kw$network);
var inst_41978__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41975,cljs.core.cst$kw$dbid);
var inst_41979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41980 = [inst_41977__$1,inst_41978__$1];
var inst_41981 = (new cljs.core.PersistentVector(null,2,(5),inst_41979,inst_41980,null));
var inst_41982 = fluree.db.operations.ledger_info_async(inst_41976__$1,inst_41981);
var state_42068__$1 = (function (){var statearr_42094 = state_42068;
(statearr_42094[(8)] = inst_41977__$1);

(statearr_42094[(10)] = inst_41976__$1);

(statearr_42094[(17)] = inst_41973);

(statearr_42094[(11)] = inst_41978__$1);

return statearr_42094;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42068__$1,(6),inst_41982);
} else {
if((state_val_42069 === (23))){
var inst_42024 = (state_42068[(16)]);
var inst_42015 = (state_42068[(18)]);
var inst_42027 = cljs.core.__destructure_map(inst_42024);
var inst_42028 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42027,cljs.core.cst$kw$flakes);
var inst_42029 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42027,cljs.core.cst$kw$block);
var inst_42030 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42027,cljs.core.cst$kw$t);
var inst_42031 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_42015,inst_42029,inst_42028);
var state_42068__$1 = (function (){var statearr_42095 = state_42068;
(statearr_42095[(19)] = inst_42030);

return statearr_42095;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42068__$1,(26),inst_42031);
} else {
if((state_val_42069 === (19))){
var inst_42015 = (state_42068[(18)]);
var state_42068__$1 = state_42068;
var statearr_42096_42135 = state_42068__$1;
(statearr_42096_42135[(2)] = inst_42015);

(statearr_42096_42135[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (11))){
var inst_41977 = (state_42068[(8)]);
var inst_41985 = (state_42068[(7)]);
var inst_41978 = (state_42068[(11)]);
var inst_41994 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_41985);
var inst_41995 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41977),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41978)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41994),"."].join('');
var state_42068__$1 = state_42068;
var statearr_42098_42136 = state_42068__$1;
(statearr_42098_42136[(2)] = inst_41995);

(statearr_42098_42136[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (9))){
var inst_41977 = (state_42068[(8)]);
var inst_41976 = (state_42068[(10)]);
var inst_41985 = (state_42068[(7)]);
var inst_41973 = (state_42068[(17)]);
var inst_41978 = (state_42068[(11)]);
var inst_42005 = (state_42068[(2)]);
var inst_42006 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_41985);
var inst_42007 = fluree.db.storage.core.reify_db(inst_41976,inst_41977,inst_41978,inst_41973,inst_42006);
var state_42068__$1 = (function (){var statearr_42099 = state_42068;
(statearr_42099[(20)] = inst_42005);

return statearr_42099;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42068__$1,(13),inst_42007);
} else {
if((state_val_42069 === (5))){
var _ = (function (){var statearr_42100 = state_42068;
(statearr_42100[(4)] = cljs.core.rest((state_42068[(4)])));

return statearr_42100;
})();
var state_42068__$1 = state_42068;
var ex42097 = (state_42068__$1[(2)]);
var statearr_42101_42137 = state_42068__$1;
(statearr_42101_42137[(5)] = ex42097);


var statearr_42102_42138 = state_42068__$1;
(statearr_42102_42138[(1)] = (4));

(statearr_42102_42138[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (14))){
var inst_42010 = (state_42068[(14)]);
var inst_42013 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_42010);
var inst_42014 = (inst_42013 + (1));
var inst_42015 = inst_42010;
var inst_42016 = inst_42014;
var state_42068__$1 = (function (){var statearr_42103 = state_42068;
(statearr_42103[(9)] = inst_42016);

(statearr_42103[(18)] = inst_42015);

return statearr_42103;
})();
var statearr_42104_42139 = state_42068__$1;
(statearr_42104_42139[(2)] = null);

(statearr_42104_42139[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (26))){
var inst_42016 = (state_42068[(9)]);
var inst_42033 = (state_42068[(2)]);
var inst_42034 = fluree.db.util.async.throw_err(inst_42033);
var inst_42035 = (inst_42016 + (1));
var inst_42015 = inst_42034;
var inst_42016__$1 = inst_42035;
var state_42068__$1 = (function (){var statearr_42105 = state_42068;
(statearr_42105[(9)] = inst_42016__$1);

(statearr_42105[(18)] = inst_42015);

return statearr_42105;
})();
var statearr_42106_42140 = state_42068__$1;
(statearr_42106_42140[(2)] = null);

(statearr_42106_42140[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (16))){
var inst_42052 = (state_42068[(12)]);
var inst_42052__$1 = (state_42068[(2)]);
var inst_42053 = fluree.db.query.schema.schema_map(inst_42052__$1);
var state_42068__$1 = (function (){var statearr_42107 = state_42068;
(statearr_42107[(12)] = inst_42052__$1);

return statearr_42107;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42068__$1,(27),inst_42053);
} else {
if((state_val_42069 === (10))){
var inst_41977 = (state_42068[(8)]);
var inst_41978 = (state_42068[(11)]);
var inst_41992 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41977),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41978)," is not found on this ledger group."].join('');
var state_42068__$1 = state_42068;
var statearr_42108_42141 = state_42068__$1;
(statearr_42108_42141[(2)] = inst_41992);

(statearr_42108_42141[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (18))){
var inst_42049 = (state_42068[(2)]);
var state_42068__$1 = state_42068;
var statearr_42109_42142 = state_42068__$1;
(statearr_42109_42142[(2)] = inst_42049);

(statearr_42109_42142[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42069 === (8))){
var state_42068__$1 = state_42068;
var statearr_42110_42143 = state_42068__$1;
(statearr_42110_42143[(2)] = null);

(statearr_42110_42143[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__14778__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__14778__auto____0 = (function (){
var statearr_42111 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42111[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__14778__auto__);

(statearr_42111[(1)] = (1));

return statearr_42111;
});
var fluree$db$session$full_load_existing_db_$_state_machine__14778__auto____1 = (function (state_42068){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_42068);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e42112){var ex__14781__auto__ = e42112;
var statearr_42113_42144 = state_42068;
(statearr_42113_42144[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_42068[(4)]))){
var statearr_42114_42145 = state_42068;
(statearr_42114_42145[(1)] = cljs.core.first((state_42068[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__42146 = state_42068;
state_42068 = G__42146;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__14778__auto__ = function(state_42068){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__14778__auto____1.call(this,state_42068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__14778__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__14778__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_42115 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_42115[(6)] = c__14852__auto___42116);

return statearr_42115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__42147 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__42147,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__42147;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__42148 = cljs.core.get_global_hierarchy;
return (fexpr__42148.cljs$core$IFn$_invoke$arity$0 ? fexpr__42148.cljs$core$IFn$_invoke$arity$0() : fexpr__42148.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_42150){
var state_val_42151 = (state_42150[(1)]);
if((state_val_42151 === (1))){
var state_42150__$1 = state_42150;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42150__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__14778__auto__ = null;
var fluree$db$session$state_machine__14778__auto____0 = (function (){
var statearr_42152 = [null,null,null,null,null,null,null];
(statearr_42152[(0)] = fluree$db$session$state_machine__14778__auto__);

(statearr_42152[(1)] = (1));

return statearr_42152;
});
var fluree$db$session$state_machine__14778__auto____1 = (function (state_42150){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_42150);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e42153){var ex__14781__auto__ = e42153;
var statearr_42154_42157 = state_42150;
(statearr_42154_42157[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_42150[(4)]))){
var statearr_42155_42158 = state_42150;
(statearr_42155_42158[(1)] = cljs.core.first((state_42150[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__42159 = state_42150;
state_42150 = G__42159;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$session$state_machine__14778__auto__ = function(state_42150){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__14778__auto____1.call(this,state_42150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__14778__auto____0;
fluree$db$session$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__14778__auto____1;
return fluree$db$session$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_42156 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_42156[(6)] = c__14852__auto__);

return statearr_42156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__42161){
var map__42162 = p__42161;
var map__42162__$1 = cljs.core.__destructure_map(map__42162);
var data = map__42162__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42162__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42162__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42162__$1,cljs.core.cst$kw$flakes);
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_42221){
var state_val_42222 = (state_42221[(1)]);
if((state_val_42222 === (7))){
var inst_42176 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_42177 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_42178 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42176),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42177),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_42179 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42178], 0));
var state_42221__$1 = state_42221;
var statearr_42223_42261 = state_42221__$1;
(statearr_42223_42261[(2)] = inst_42179);

(statearr_42223_42261[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (1))){
var state_42221__$1 = state_42221;
var statearr_42224_42262 = state_42221__$1;
(statearr_42224_42262[(2)] = null);

(statearr_42224_42262[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (4))){
var inst_42163 = (state_42221[(2)]);
var state_42221__$1 = state_42221;
var statearr_42225_42263 = state_42221__$1;
(statearr_42225_42263[(2)] = inst_42163);

(statearr_42225_42263[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (15))){
var inst_42202 = (state_42221[(2)]);
var state_42221__$1 = state_42221;
var statearr_42226_42264 = state_42221__$1;
(statearr_42226_42264[(2)] = inst_42202);

(statearr_42226_42264[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (13))){
var inst_42193 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_42194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42195 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_42196 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_42197 = [inst_42195,inst_42196];
var inst_42198 = (new cljs.core.PersistentVector(null,2,(5),inst_42194,inst_42197,null));
var inst_42199 = (function (){var G__42227 = inst_42193;
var G__42228 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__42229 = inst_42198;
var G__42230 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__42227,G__42228,G__42229,G__42230) : fluree.db.conn_events.process_event.call(null,G__42227,G__42228,G__42229,G__42230));
})();
var state_42221__$1 = state_42221;
var statearr_42231_42265 = state_42221__$1;
(statearr_42231_42265[(2)] = inst_42199);

(statearr_42231_42265[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (6))){
var inst_42173 = (state_42221[(7)]);
var inst_42172 = (state_42221[(8)]);
var inst_42171 = (state_42221[(2)]);
var inst_42172__$1 = fluree.db.util.async.throw_err(inst_42171);
var inst_42173__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_42172__$1);
var inst_42174 = (block <= inst_42173__$1);
var state_42221__$1 = (function (){var statearr_42232 = state_42221;
(statearr_42232[(7)] = inst_42173__$1);

(statearr_42232[(8)] = inst_42172__$1);

return statearr_42232;
})();
if(cljs.core.truth_(inst_42174)){
var statearr_42233_42266 = state_42221__$1;
(statearr_42233_42266[(1)] = (7));

} else {
var statearr_42234_42267 = state_42221__$1;
(statearr_42234_42267[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (17))){
var state_42221__$1 = state_42221;
var statearr_42235_42268 = state_42221__$1;
(statearr_42235_42268[(2)] = null);

(statearr_42235_42268[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (3))){
var inst_42219 = (state_42221[(2)]);
var state_42221__$1 = state_42221;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42221__$1,inst_42219);
} else {
if((state_val_42222 === (12))){
var inst_42214 = (state_42221[(2)]);
var state_42221__$1 = state_42221;
var statearr_42236_42269 = state_42221__$1;
(statearr_42236_42269[(2)] = inst_42214);

(statearr_42236_42269[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (2))){
var inst_42169 = (state_42221[(9)]);
var _ = (function (){var statearr_42237 = state_42221;
(statearr_42237[(4)] = cljs.core.cons((5),(state_42221[(4)])));

return statearr_42237;
})();
var inst_42169__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_42221__$1 = (function (){var statearr_42238 = state_42221;
(statearr_42238[(9)] = inst_42169__$1);

return statearr_42238;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42221__$1,(6),inst_42169__$1);
} else {
if((state_val_42222 === (11))){
var state_42221__$1 = state_42221;
var statearr_42240_42270 = state_42221__$1;
(statearr_42240_42270[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (9))){
var inst_42216 = (state_42221[(2)]);
var _ = (function (){var statearr_42242 = state_42221;
(statearr_42242[(4)] = cljs.core.rest((state_42221[(4)])));

return statearr_42242;
})();
var state_42221__$1 = state_42221;
var statearr_42243_42271 = state_42221__$1;
(statearr_42243_42271[(2)] = inst_42216);

(statearr_42243_42271[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (5))){
var _ = (function (){var statearr_42244 = state_42221;
(statearr_42244[(4)] = cljs.core.rest((state_42221[(4)])));

return statearr_42244;
})();
var state_42221__$1 = state_42221;
var ex42239 = (state_42221__$1[(2)]);
var statearr_42245_42272 = state_42221__$1;
(statearr_42245_42272[(5)] = ex42239);


if((ex42239 instanceof Error)){
var statearr_42246_42273 = state_42221__$1;
(statearr_42246_42273[(1)] = (4));

(statearr_42246_42273[(5)] = null);

} else {
throw ex42239;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (14))){
var state_42221__$1 = state_42221;
var statearr_42247_42274 = state_42221__$1;
(statearr_42247_42274[(2)] = null);

(statearr_42247_42274[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (16))){
var inst_42173 = (state_42221[(7)]);
var inst_42205 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_42206 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_42207 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42205),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42206),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42173),". Forcing a db reload."].join('');
var inst_42208 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42207], 0));
var inst_42209 = fluree.db.session.reload_db_BANG_(session);
var state_42221__$1 = (function (){var statearr_42248 = state_42221;
(statearr_42248[(10)] = inst_42208);

return statearr_42248;
})();
var statearr_42249_42275 = state_42221__$1;
(statearr_42249_42275[(2)] = inst_42209);

(statearr_42249_42275[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (10))){
var inst_42173 = (state_42221[(7)]);
var inst_42169 = (state_42221[(9)]);
var inst_42172 = (state_42221[(8)]);
var inst_42184 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_42185 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_42186 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42184),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42185),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_42187 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42186], 0));
var inst_42188 = (function (){var current_db_ch = inst_42169;
var current_db = inst_42172;
var current_block = inst_42173;
return (function (p1__42160_SHARP_){
if((p1__42160_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__42160_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__42160_SHARP_);
}
});
})();
var inst_42189 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_42188,flakes);
var inst_42190 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_42172,block,inst_42189);
var inst_42191 = fluree.db.session.cas_db_BANG_(session,inst_42169,inst_42190);
var state_42221__$1 = (function (){var statearr_42250 = state_42221;
(statearr_42250[(11)] = inst_42187);

return statearr_42250;
})();
if(inst_42191){
var statearr_42251_42276 = state_42221__$1;
(statearr_42251_42276[(1)] = (13));

} else {
var statearr_42252_42277 = state_42221__$1;
(statearr_42252_42277[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (18))){
var inst_42212 = (state_42221[(2)]);
var state_42221__$1 = state_42221;
var statearr_42253_42278 = state_42221__$1;
(statearr_42253_42278[(2)] = inst_42212);

(statearr_42253_42278[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42222 === (8))){
var inst_42173 = (state_42221[(7)]);
var inst_42181 = ((1) + inst_42173);
var inst_42182 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_42181);
var state_42221__$1 = state_42221;
if(inst_42182){
var statearr_42254_42279 = state_42221__$1;
(statearr_42254_42279[(1)] = (10));

} else {
var statearr_42255_42280 = state_42221__$1;
(statearr_42255_42280[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__14778__auto__ = null;
var fluree$db$session$state_machine__14778__auto____0 = (function (){
var statearr_42256 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42256[(0)] = fluree$db$session$state_machine__14778__auto__);

(statearr_42256[(1)] = (1));

return statearr_42256;
});
var fluree$db$session$state_machine__14778__auto____1 = (function (state_42221){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_42221);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e42257){var ex__14781__auto__ = e42257;
var statearr_42258_42281 = state_42221;
(statearr_42258_42281[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_42221[(4)]))){
var statearr_42259_42282 = state_42221;
(statearr_42259_42282[(1)] = cljs.core.first((state_42221[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__42283 = state_42221;
state_42221 = G__42283;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$session$state_machine__14778__auto__ = function(state_42221){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__14778__auto____1.call(this,state_42221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__14778__auto____0;
fluree$db$session$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__14778__auto____1;
return fluree$db$session$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_42260 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_42260[(6)] = c__14852__auto__);

return statearr_42260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_42290){
var state_val_42291 = (state_42290[(1)]);
if((state_val_42291 === (1))){
var inst_42284 = fluree.db.session.clear_db_BANG_(session);
var inst_42285 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_42286 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_42287 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42285),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42286)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_42288 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42287], 0));
var state_42290__$1 = (function (){var statearr_42292 = state_42290;
(statearr_42292[(7)] = inst_42288);

(statearr_42292[(8)] = inst_42284);

return statearr_42292;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_42290__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__14778__auto__ = null;
var fluree$db$session$state_machine__14778__auto____0 = (function (){
var statearr_42293 = [null,null,null,null,null,null,null,null,null];
(statearr_42293[(0)] = fluree$db$session$state_machine__14778__auto__);

(statearr_42293[(1)] = (1));

return statearr_42293;
});
var fluree$db$session$state_machine__14778__auto____1 = (function (state_42290){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_42290);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e42294){var ex__14781__auto__ = e42294;
var statearr_42295_42298 = state_42290;
(statearr_42295_42298[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_42290[(4)]))){
var statearr_42296_42299 = state_42290;
(statearr_42296_42299[(1)] = cljs.core.first((state_42290[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__42300 = state_42290;
state_42290 = G__42300;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$session$state_machine__14778__auto__ = function(state_42290){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__14778__auto____1.call(this,state_42290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__14778__auto____0;
fluree$db$session$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__14778__auto____1;
return fluree$db$session$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_42297 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_42297[(6)] = c__14852__auto__);

return statearr_42297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__42302 = arguments.length;
switch (G__42302) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__42303 = session;
var map__42303__$1 = cljs.core.__destructure_map(map__42303);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42303__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42303__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42303__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42303__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42303__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42303__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42303__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__42304_42307 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__42304_42307.cljs$core$IFn$_invoke$arity$3 ? fexpr__42304_42307.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__42304_42307.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__42305_42308 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__42305_42308.cljs$core$IFn$_invoke$arity$0 ? fexpr__42305_42308.cljs$core$IFn$_invoke$arity$0() : fexpr__42305_42308.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_42361){
var state_val_42362 = (state_42361[(1)]);
if((state_val_42362 === (7))){
var inst_42357 = (state_42361[(2)]);
var state_42361__$1 = state_42361;
var statearr_42363_42394 = state_42361__$1;
(statearr_42363_42394[(2)] = inst_42357);

(statearr_42363_42394[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (1))){
var state_42361__$1 = state_42361;
var statearr_42364_42395 = state_42361__$1;
(statearr_42364_42395[(2)] = null);

(statearr_42364_42395[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (4))){
var inst_42312 = (state_42361[(7)]);
var inst_42311 = (state_42361[(2)]);
var inst_42312__$1 = fluree.db.util.async.throw_err(inst_42311);
var inst_42313 = fluree.db.session.from_cache(network,ledger_id);
var inst_42314 = (inst_42312__$1 == null);
var state_42361__$1 = (function (){var statearr_42365 = state_42361;
(statearr_42365[(8)] = inst_42313);

(statearr_42365[(7)] = inst_42312__$1);

return statearr_42365;
})();
if(cljs.core.truth_(inst_42314)){
var statearr_42366_42396 = state_42361__$1;
(statearr_42366_42396[(1)] = (5));

} else {
var statearr_42367_42397 = state_42361__$1;
(statearr_42367_42397[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (15))){
var inst_42349 = (state_42361[(2)]);
var state_42361__$1 = (function (){var statearr_42368 = state_42361;
(statearr_42368[(9)] = inst_42349);

return statearr_42368;
})();
var statearr_42369_42398 = state_42361__$1;
(statearr_42369_42398[(2)] = null);

(statearr_42369_42398[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (13))){
var inst_42353 = (state_42361[(2)]);
var state_42361__$1 = state_42361;
var statearr_42371_42399 = state_42361__$1;
(statearr_42371_42399[(2)] = inst_42353);

(statearr_42371_42399[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (6))){
var inst_42313 = (state_42361[(8)]);
var inst_42319 = (inst_42313 == null);
var state_42361__$1 = state_42361;
if(cljs.core.truth_(inst_42319)){
var statearr_42372_42400 = state_42361__$1;
(statearr_42372_42400[(1)] = (8));

} else {
var statearr_42373_42401 = state_42361__$1;
(statearr_42373_42401[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (17))){
var _ = (function (){var statearr_42374 = state_42361;
(statearr_42374[(4)] = cljs.core.rest((state_42361[(4)])));

return statearr_42374;
})();
var state_42361__$1 = state_42361;
var ex42370 = (state_42361__$1[(2)]);
var statearr_42375_42402 = state_42361__$1;
(statearr_42375_42402[(5)] = ex42370);


var statearr_42376_42403 = state_42361__$1;
(statearr_42376_42403[(1)] = (16));

(statearr_42376_42403[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (3))){
var inst_42359 = (state_42361[(2)]);
var state_42361__$1 = state_42361;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42361__$1,inst_42359);
} else {
if((state_val_42362 === (12))){
var state_42361__$1 = state_42361;
var statearr_42377_42404 = state_42361__$1;
(statearr_42377_42404[(2)] = null);

(statearr_42377_42404[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (2))){
var state_42361__$1 = state_42361;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42361__$1,(4),update_chan);
} else {
if((state_val_42362 === (11))){
var state_42361__$1 = state_42361;
var statearr_42378_42405 = state_42361__$1;
(statearr_42378_42405[(2)] = null);

(statearr_42378_42405[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (9))){
var state_42361__$1 = state_42361;
var statearr_42379_42406 = state_42361__$1;
(statearr_42379_42406[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (5))){
var inst_42316 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_42317 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42316], 0));
var state_42361__$1 = state_42361;
var statearr_42381_42407 = state_42361__$1;
(statearr_42381_42407[(2)] = inst_42317);

(statearr_42381_42407[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (14))){
var inst_42313 = (state_42361[(8)]);
var inst_42312 = (state_42361[(7)]);
var _ = (function (){var statearr_42382 = state_42361;
(statearr_42382[(4)] = cljs.core.cons((17),(state_42361[(4)])));

return statearr_42382;
})();
var inst_42337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42312,(0),null);
var inst_42338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42312,(1),null);
var inst_42339 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_42340 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42312], 0));
var inst_42341 = fluree.db.util.core.trunc(inst_42340,(200));
var inst_42342 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42339,inst_42341], 0));
var inst_42343 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_42313,inst_42337,inst_42338) : fluree.db.session.process_ledger_update.call(null,inst_42313,inst_42337,inst_42338));
var state_42361__$1 = (function (){var statearr_42383 = state_42361;
(statearr_42383[(10)] = inst_42342);

return statearr_42383;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42361__$1,(18),inst_42343);
} else {
if((state_val_42362 === (16))){
var inst_42312 = (state_42361[(7)]);
var inst_42327 = (state_42361[(2)]);
var inst_42328 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42327,"Exception processing ledger updates for message: ",inst_42312], 0));
var state_42361__$1 = state_42361;
var statearr_42384_42408 = state_42361__$1;
(statearr_42384_42408[(2)] = inst_42328);

(statearr_42384_42408[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (10))){
var inst_42355 = (state_42361[(2)]);
var state_42361__$1 = state_42361;
var statearr_42385_42409 = state_42361__$1;
(statearr_42385_42409[(2)] = inst_42355);

(statearr_42385_42409[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (18))){
var inst_42345 = (state_42361[(2)]);
var inst_42346 = fluree.db.util.async.throw_err(inst_42345);
var _ = (function (){var statearr_42386 = state_42361;
(statearr_42386[(4)] = cljs.core.rest((state_42361[(4)])));

return statearr_42386;
})();
var state_42361__$1 = state_42361;
var statearr_42387_42410 = state_42361__$1;
(statearr_42387_42410[(2)] = inst_42346);

(statearr_42387_42410[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42362 === (8))){
var inst_42312 = (state_42361[(7)]);
var inst_42321 = cljs.core.first(inst_42312);
var inst_42322 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42321], 0));
var inst_42323 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_42322].join('');
var inst_42324 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42323], 0));
var state_42361__$1 = state_42361;
var statearr_42388_42411 = state_42361__$1;
(statearr_42388_42411[(2)] = inst_42324);

(statearr_42388_42411[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__14778__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__14778__auto____0 = (function (){
var statearr_42389 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42389[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__14778__auto__);

(statearr_42389[(1)] = (1));

return statearr_42389;
});
var fluree$db$session$process_ledger_updates_$_state_machine__14778__auto____1 = (function (state_42361){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_42361);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e42390){var ex__14781__auto__ = e42390;
var statearr_42391_42412 = state_42361;
(statearr_42391_42412[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_42361[(4)]))){
var statearr_42392_42413 = state_42361;
(statearr_42392_42413[(1)] = cljs.core.first((state_42361[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__42414 = state_42361;
state_42361 = G__42414;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__14778__auto__ = function(state_42361){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__14778__auto____1.call(this,state_42361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__14778__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__14778__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_42393 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_42393[(6)] = c__14852__auto__);

return statearr_42393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__42415){
var map__42416 = p__42415;
var map__42416__$1 = cljs.core.__destructure_map(map__42416);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42416__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42416__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42416__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42416__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42416__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42416__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42416__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42416__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42416__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__42420 = block_result;
var map__42420__$1 = cljs.core.__destructure_map(map__42420);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42420__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42420__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42420__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42420__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42420__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__42421 = tx_result;
var map__42421__$1 = cljs.core.__destructure_map(map__42421);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42421__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42421__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__42417_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__42417_SHARP_.t);
}):(function (p1__42418_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__42418_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__42419_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__42419_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__42419_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__42422 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42422,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42422,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42422,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42422,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__42426 = arguments.length;
switch (G__42426) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__42427){
var map__42428 = p__42427;
var map__42428__$1 = cljs.core.__destructure_map(map__42428);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42428__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42428__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42428__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42428__$1,cljs.core.cst$kw$jwt);
var vec__42429 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42429,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42429,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42429,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4223__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4223__auto____$1 = state;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__42433_42553 = network;
var G__42434_42554 = ledger_id;
var G__42435_42555 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__42436_42556 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__42437 = cljs.core.seq(tids);
var chunk__42438 = null;
var count__42439 = (0);
var i__42440 = (0);
while(true){
if((i__42440 < count__42439)){
var tid = chunk__42438.cljs$core$IIndexed$_nth$arity$2(null,i__42440);
var temp__5753__auto___42558__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___42558__$1)){
var keyed_callbacks_42559 = temp__5753__auto___42558__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_42560 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__42481_42561 = cljs.core.seq(keyed_callbacks_42559);
var chunk__42482_42562 = null;
var count__42483_42563 = (0);
var i__42484_42564 = (0);
while(true){
if((i__42484_42564 < count__42483_42563)){
var vec__42493_42565 = chunk__42482_42562.cljs$core$IIndexed$_nth$arity$2(null,i__42484_42564);
var k_42566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42493_42565,(0),null);
var f_42567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42493_42565,(1),null);
try{(f_42567.cljs$core$IFn$_invoke$arity$1 ? f_42567.cljs$core$IFn$_invoke$arity$1(tx_response_42560) : f_42567.call(null,tx_response_42560));
}catch (e42496){var e_42568 = e42496;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_42568,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__42569 = seq__42481_42561;
var G__42570 = chunk__42482_42562;
var G__42571 = count__42483_42563;
var G__42572 = (i__42484_42564 + (1));
seq__42481_42561 = G__42569;
chunk__42482_42562 = G__42570;
count__42483_42563 = G__42571;
i__42484_42564 = G__42572;
continue;
} else {
var temp__5753__auto___42573__$2 = cljs.core.seq(seq__42481_42561);
if(temp__5753__auto___42573__$2){
var seq__42481_42574__$1 = temp__5753__auto___42573__$2;
if(cljs.core.chunked_seq_QMARK_(seq__42481_42574__$1)){
var c__4649__auto___42575 = cljs.core.chunk_first(seq__42481_42574__$1);
var G__42576 = cljs.core.chunk_rest(seq__42481_42574__$1);
var G__42577 = c__4649__auto___42575;
var G__42578 = cljs.core.count(c__4649__auto___42575);
var G__42579 = (0);
seq__42481_42561 = G__42576;
chunk__42482_42562 = G__42577;
count__42483_42563 = G__42578;
i__42484_42564 = G__42579;
continue;
} else {
var vec__42497_42580 = cljs.core.first(seq__42481_42574__$1);
var k_42581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42497_42580,(0),null);
var f_42582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42497_42580,(1),null);
try{(f_42582.cljs$core$IFn$_invoke$arity$1 ? f_42582.cljs$core$IFn$_invoke$arity$1(tx_response_42560) : f_42582.call(null,tx_response_42560));
}catch (e42500){var e_42583 = e42500;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_42583,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__42584 = cljs.core.next(seq__42481_42574__$1);
var G__42585 = null;
var G__42586 = (0);
var G__42587 = (0);
seq__42481_42561 = G__42584;
chunk__42482_42562 = G__42585;
count__42483_42563 = G__42586;
i__42484_42564 = G__42587;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__42588 = seq__42437;
var G__42589 = chunk__42438;
var G__42590 = count__42439;
var G__42591 = (i__42440 + (1));
seq__42437 = G__42588;
chunk__42438 = G__42589;
count__42439 = G__42590;
i__42440 = G__42591;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__42437);
if(temp__5753__auto____$1){
var seq__42437__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__42437__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__42437__$1);
var G__42592 = cljs.core.chunk_rest(seq__42437__$1);
var G__42593 = c__4649__auto__;
var G__42594 = cljs.core.count(c__4649__auto__);
var G__42595 = (0);
seq__42437 = G__42592;
chunk__42438 = G__42593;
count__42439 = G__42594;
i__42440 = G__42595;
continue;
} else {
var tid = cljs.core.first(seq__42437__$1);
var temp__5753__auto___42596__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___42596__$2)){
var keyed_callbacks_42597 = temp__5753__auto___42596__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_42598 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__42501_42599 = cljs.core.seq(keyed_callbacks_42597);
var chunk__42502_42600 = null;
var count__42503_42601 = (0);
var i__42504_42602 = (0);
while(true){
if((i__42504_42602 < count__42503_42601)){
var vec__42513_42603 = chunk__42502_42600.cljs$core$IIndexed$_nth$arity$2(null,i__42504_42602);
var k_42604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42513_42603,(0),null);
var f_42605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42513_42603,(1),null);
try{(f_42605.cljs$core$IFn$_invoke$arity$1 ? f_42605.cljs$core$IFn$_invoke$arity$1(tx_response_42598) : f_42605.call(null,tx_response_42598));
}catch (e42516){var e_42606 = e42516;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_42606,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__42607 = seq__42501_42599;
var G__42608 = chunk__42502_42600;
var G__42609 = count__42503_42601;
var G__42610 = (i__42504_42602 + (1));
seq__42501_42599 = G__42607;
chunk__42502_42600 = G__42608;
count__42503_42601 = G__42609;
i__42504_42602 = G__42610;
continue;
} else {
var temp__5753__auto___42611__$3 = cljs.core.seq(seq__42501_42599);
if(temp__5753__auto___42611__$3){
var seq__42501_42612__$1 = temp__5753__auto___42611__$3;
if(cljs.core.chunked_seq_QMARK_(seq__42501_42612__$1)){
var c__4649__auto___42613 = cljs.core.chunk_first(seq__42501_42612__$1);
var G__42614 = cljs.core.chunk_rest(seq__42501_42612__$1);
var G__42615 = c__4649__auto___42613;
var G__42616 = cljs.core.count(c__4649__auto___42613);
var G__42617 = (0);
seq__42501_42599 = G__42614;
chunk__42502_42600 = G__42615;
count__42503_42601 = G__42616;
i__42504_42602 = G__42617;
continue;
} else {
var vec__42517_42618 = cljs.core.first(seq__42501_42612__$1);
var k_42619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42517_42618,(0),null);
var f_42620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42517_42618,(1),null);
try{(f_42620.cljs$core$IFn$_invoke$arity$1 ? f_42620.cljs$core$IFn$_invoke$arity$1(tx_response_42598) : f_42620.call(null,tx_response_42598));
}catch (e42520){var e_42621 = e42520;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_42621,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__42622 = cljs.core.next(seq__42501_42612__$1);
var G__42623 = null;
var G__42624 = (0);
var G__42625 = (0);
seq__42501_42599 = G__42622;
chunk__42502_42600 = G__42623;
count__42503_42601 = G__42624;
i__42504_42602 = G__42625;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__42626 = cljs.core.next(seq__42437__$1);
var G__42627 = null;
var G__42628 = (0);
var G__42629 = (0);
seq__42437 = G__42626;
chunk__42438 = G__42627;
count__42439 = G__42628;
i__42440 = G__42629;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__42432_42557 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__42432_42557.cljs$core$IFn$_invoke$arity$4 ? fexpr__42432_42557.cljs$core$IFn$_invoke$arity$4(G__42433_42553,G__42434_42554,G__42435_42555,G__42436_42556) : fexpr__42432_42557.call(null,G__42433_42553,G__42434_42554,G__42435_42555,G__42436_42556));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_42630 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__14852__auto___42631 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_42537){
var state_val_42538 = (state_42537[(1)]);
if((state_val_42538 === (1))){
var state_42537__$1 = state_42537;
var statearr_42539_42632 = state_42537__$1;
(statearr_42539_42632[(2)] = null);

(statearr_42539_42632[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42538 === (2))){
var inst_42522 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_42537__$1 = state_42537;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42537__$1,(4),inst_42522);
} else {
if((state_val_42538 === (3))){
var inst_42535 = (state_42537[(2)]);
var state_42537__$1 = state_42537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42537__$1,inst_42535);
} else {
if((state_val_42538 === (4))){
var inst_42524 = (state_42537[(7)]);
var inst_42524__$1 = (state_42537[(2)]);
var inst_42525 = (inst_42524__$1 == null);
var state_42537__$1 = (function (){var statearr_42540 = state_42537;
(statearr_42540[(7)] = inst_42524__$1);

return statearr_42540;
})();
if(cljs.core.truth_(inst_42525)){
var statearr_42541_42633 = state_42537__$1;
(statearr_42541_42633[(1)] = (5));

} else {
var statearr_42542_42634 = state_42537__$1;
(statearr_42542_42634[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42538 === (5))){
var inst_42527 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_42528 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42527], 0));
var state_42537__$1 = state_42537;
var statearr_42543_42635 = state_42537__$1;
(statearr_42543_42635[(2)] = inst_42528);

(statearr_42543_42635[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42538 === (6))){
var inst_42524 = (state_42537[(7)]);
var inst_42530 = (transact_handler_42630.cljs$core$IFn$_invoke$arity$2 ? transact_handler_42630.cljs$core$IFn$_invoke$arity$2(conn,inst_42524) : transact_handler_42630.call(null,conn,inst_42524));
var state_42537__$1 = (function (){var statearr_42544 = state_42537;
(statearr_42544[(8)] = inst_42530);

return statearr_42544;
})();
var statearr_42545_42636 = state_42537__$1;
(statearr_42545_42636[(2)] = null);

(statearr_42545_42636[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42538 === (7))){
var inst_42533 = (state_42537[(2)]);
var state_42537__$1 = state_42537;
var statearr_42546_42637 = state_42537__$1;
(statearr_42546_42637[(2)] = inst_42533);

(statearr_42546_42637[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__14778__auto__ = null;
var fluree$db$session$state_machine__14778__auto____0 = (function (){
var statearr_42547 = [null,null,null,null,null,null,null,null,null];
(statearr_42547[(0)] = fluree$db$session$state_machine__14778__auto__);

(statearr_42547[(1)] = (1));

return statearr_42547;
});
var fluree$db$session$state_machine__14778__auto____1 = (function (state_42537){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_42537);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e42548){var ex__14781__auto__ = e42548;
var statearr_42549_42638 = state_42537;
(statearr_42549_42638[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_42537[(4)]))){
var statearr_42550_42639 = state_42537;
(statearr_42550_42639[(1)] = cljs.core.first((state_42537[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__42640 = state_42537;
state_42537 = G__42640;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$session$state_machine__14778__auto__ = function(state_42537){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__14778__auto____1.call(this,state_42537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__14778__auto____0;
fluree$db$session$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__14778__auto____1;
return fluree$db$session$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_42551 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_42551[(6)] = c__14852__auto___42631);

return statearr_42551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__42641_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__42641_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__42641_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__42642_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__42642_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__42645 = arguments.length;
switch (G__42645) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__42646 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__42643_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__42643_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__42646);
} else {
return G__42646;
}
})();
var seq__42647 = cljs.core.seq(sessions);
var chunk__42648 = null;
var count__42649 = (0);
var i__42650 = (0);
while(true){
if((i__42650 < count__42649)){
var session = chunk__42648.cljs$core$IIndexed$_nth$arity$2(null,i__42650);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__42652 = seq__42647;
var G__42653 = chunk__42648;
var G__42654 = count__42649;
var G__42655 = (i__42650 + (1));
seq__42647 = G__42652;
chunk__42648 = G__42653;
count__42649 = G__42654;
i__42650 = G__42655;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__42647);
if(temp__5753__auto__){
var seq__42647__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__42647__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__42647__$1);
var G__42656 = cljs.core.chunk_rest(seq__42647__$1);
var G__42657 = c__4649__auto__;
var G__42658 = cljs.core.count(c__4649__auto__);
var G__42659 = (0);
seq__42647 = G__42656;
chunk__42648 = G__42657;
count__42649 = G__42658;
i__42650 = G__42659;
continue;
} else {
var session = cljs.core.first(seq__42647__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__42660 = cljs.core.next(seq__42647__$1);
var G__42661 = null;
var G__42662 = (0);
var G__42663 = (0);
seq__42647 = G__42660;
chunk__42648 = G__42661;
count__42649 = G__42662;
i__42650 = G__42663;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
