// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_33165){
var state_val_33166 = (state_33165[(1)]);
if((state_val_33166 === (1))){
var state_33165__$1 = state_33165;
var statearr_33167_33181 = state_33165__$1;
(statearr_33167_33181[(2)] = null);

(statearr_33167_33181[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33166 === (2))){
var _ = (function (){var statearr_33168 = state_33165;
(statearr_33168[(4)] = cljs.core.cons((5),(state_33165[(4)])));

return statearr_33168;
})();
var inst_33156 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_33165__$1 = state_33165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33165__$1,(6),inst_33156);
} else {
if((state_val_33166 === (3))){
var inst_33163 = (state_33165[(2)]);
var state_33165__$1 = state_33165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33165__$1,inst_33163);
} else {
if((state_val_33166 === (4))){
var inst_33150 = (state_33165[(2)]);
var state_33165__$1 = state_33165;
var statearr_33170_33182 = state_33165__$1;
(statearr_33170_33182[(2)] = inst_33150);

(statearr_33170_33182[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33166 === (5))){
var _ = (function (){var statearr_33171 = state_33165;
(statearr_33171[(4)] = cljs.core.rest((state_33165[(4)])));

return statearr_33171;
})();
var state_33165__$1 = state_33165;
var ex33169 = (state_33165__$1[(2)]);
var statearr_33172_33183 = state_33165__$1;
(statearr_33172_33183[(5)] = ex33169);


if((ex33169 instanceof Error)){
var statearr_33173_33184 = state_33165__$1;
(statearr_33173_33184[(1)] = (4));

(statearr_33173_33184[(5)] = null);

} else {
throw ex33169;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33166 === (6))){
var inst_33158 = (state_33165[(2)]);
var inst_33159 = fluree.db.util.async.throw_err(inst_33158);
var inst_33160 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_33159);
var _ = (function (){var statearr_33174 = state_33165;
(statearr_33174[(4)] = cljs.core.rest((state_33165[(4)])));

return statearr_33174;
})();
var state_33165__$1 = state_33165;
var statearr_33175_33185 = state_33165__$1;
(statearr_33175_33185[(2)] = inst_33160);

(statearr_33175_33185[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto____0 = (function (){
var statearr_33176 = [null,null,null,null,null,null,null];
(statearr_33176[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto__);

(statearr_33176[(1)] = (1));

return statearr_33176;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto____1 = (function (state_33165){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_33165);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e33177){var ex__14781__auto__ = e33177;
var statearr_33178_33186 = state_33165;
(statearr_33178_33186[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_33165[(4)]))){
var statearr_33179_33187 = state_33165;
(statearr_33179_33187[(1)] = cljs.core.first((state_33165[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__33188 = state_33165;
state_33165 = G__33188;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto__ = function(state_33165){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto____1.call(this,state_33165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_33180 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_33180[(6)] = c__14852__auto__);

return statearr_33180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_33220){
var state_val_33221 = (state_33220[(1)]);
if((state_val_33221 === (7))){
var inst_33204 = (state_33220[(7)]);
var inst_33206 = cljs.core.empty_QMARK_(inst_33204);
var inst_33207 = (!(inst_33206));
var state_33220__$1 = state_33220;
var statearr_33222_33246 = state_33220__$1;
(statearr_33222_33246[(2)] = inst_33207);

(statearr_33222_33246[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33221 === (1))){
var state_33220__$1 = state_33220;
var statearr_33223_33247 = state_33220__$1;
(statearr_33223_33247[(2)] = null);

(statearr_33223_33247[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33221 === (4))){
var inst_33190 = (state_33220[(2)]);
var state_33220__$1 = state_33220;
var statearr_33224_33248 = state_33220__$1;
(statearr_33224_33248[(2)] = inst_33190);

(statearr_33224_33248[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33221 === (6))){
var inst_33196 = (state_33220[(8)]);
var inst_33204 = (state_33220[(7)]);
var inst_33202 = (state_33220[(2)]);
var inst_33203 = fluree.db.util.async.throw_err(inst_33202);
var inst_33204__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33196,inst_33203);
var state_33220__$1 = (function (){var statearr_33225 = state_33220;
(statearr_33225[(7)] = inst_33204__$1);

return statearr_33225;
})();
if(cljs.core.truth_(inst_33204__$1)){
var statearr_33226_33249 = state_33220__$1;
(statearr_33226_33249[(1)] = (7));

} else {
var statearr_33227_33250 = state_33220__$1;
(statearr_33227_33250[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33221 === (3))){
var inst_33218 = (state_33220[(2)]);
var state_33220__$1 = state_33220;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33220__$1,inst_33218);
} else {
if((state_val_33221 === (12))){
var inst_33215 = (state_33220[(2)]);
var _ = (function (){var statearr_33228 = state_33220;
(statearr_33228[(4)] = cljs.core.rest((state_33220[(4)])));

return statearr_33228;
})();
var state_33220__$1 = state_33220;
var statearr_33229_33251 = state_33220__$1;
(statearr_33229_33251[(2)] = inst_33215);

(statearr_33229_33251[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33221 === (2))){
var _ = (function (){var statearr_33230 = state_33220;
(statearr_33230[(4)] = cljs.core.cons((5),(state_33220[(4)])));

return statearr_33230;
})();
var inst_33196 = (function (){return (function (p1__33189_SHARP_){
return p1__33189_SHARP_.o;
});
})();
var inst_33197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33198 = [pred_id];
var inst_33199 = (new cljs.core.PersistentVector(null,1,(5),inst_33197,inst_33198,null));
var inst_33200 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_33199);
var state_33220__$1 = (function (){var statearr_33231 = state_33220;
(statearr_33231[(8)] = inst_33196);

return statearr_33231;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33220__$1,(6),inst_33200);
} else {
if((state_val_33221 === (11))){
var state_33220__$1 = state_33220;
var statearr_33233_33252 = state_33220__$1;
(statearr_33233_33252[(2)] = true);

(statearr_33233_33252[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33221 === (9))){
var inst_33210 = (state_33220[(2)]);
var state_33220__$1 = state_33220;
if(cljs.core.truth_(inst_33210)){
var statearr_33234_33253 = state_33220__$1;
(statearr_33234_33253[(1)] = (10));

} else {
var statearr_33235_33254 = state_33220__$1;
(statearr_33235_33254[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33221 === (5))){
var _ = (function (){var statearr_33236 = state_33220;
(statearr_33236[(4)] = cljs.core.rest((state_33220[(4)])));

return statearr_33236;
})();
var state_33220__$1 = state_33220;
var ex33232 = (state_33220__$1[(2)]);
var statearr_33237_33255 = state_33220__$1;
(statearr_33237_33255[(5)] = ex33232);


if((ex33232 instanceof Error)){
var statearr_33238_33256 = state_33220__$1;
(statearr_33238_33256[(1)] = (4));

(statearr_33238_33256[(5)] = null);

} else {
throw ex33232;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33221 === (10))){
var inst_33204 = (state_33220[(7)]);
var inst_33212 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_33204);
var state_33220__$1 = state_33220;
var statearr_33239_33257 = state_33220__$1;
(statearr_33239_33257[(2)] = inst_33212);

(statearr_33239_33257[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33221 === (8))){
var inst_33204 = (state_33220[(7)]);
var state_33220__$1 = state_33220;
var statearr_33240_33258 = state_33220__$1;
(statearr_33240_33258[(2)] = inst_33204);

(statearr_33240_33258[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto____0 = (function (){
var statearr_33241 = [null,null,null,null,null,null,null,null,null];
(statearr_33241[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto__);

(statearr_33241[(1)] = (1));

return statearr_33241;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto____1 = (function (state_33220){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_33220);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e33242){var ex__14781__auto__ = e33242;
var statearr_33243_33259 = state_33220;
(statearr_33243_33259[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_33220[(4)]))){
var statearr_33244_33260 = state_33220;
(statearr_33244_33260[(1)] = cljs.core.first((state_33220[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__33261 = state_33220;
state_33220 = G__33261;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto__ = function(state_33220){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto____1.call(this,state_33220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_33245 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_33245[(6)] = c__14852__auto__);

return statearr_33245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_33342){
var state_val_33343 = (state_33342[(1)]);
if((state_val_33343 === (7))){
var state_33342__$1 = state_33342;
var statearr_33344_33382 = state_33342__$1;
(statearr_33344_33382[(2)] = flakes);

(statearr_33344_33382[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (20))){
var inst_33299 = (state_33342[(7)]);
var inst_33332 = (state_33342[(2)]);
var inst_33291 = inst_33299;
var inst_33292 = inst_33332;
var state_33342__$1 = (function (){var statearr_33345 = state_33342;
(statearr_33345[(8)] = inst_33292);

(statearr_33345[(9)] = inst_33291);

return statearr_33345;
})();
var statearr_33346_33383 = state_33342__$1;
(statearr_33346_33383[(2)] = null);

(statearr_33346_33383[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (1))){
var state_33342__$1 = state_33342;
var statearr_33347_33384 = state_33342__$1;
(statearr_33347_33384[(2)] = null);

(statearr_33347_33384[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (4))){
var inst_33264 = (state_33342[(2)]);
var state_33342__$1 = state_33342;
var statearr_33348_33385 = state_33342__$1;
(statearr_33348_33385[(2)] = inst_33264);

(statearr_33348_33385[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (15))){
var inst_33298 = (state_33342[(10)]);
var inst_33316 = inst_33298.o;
var state_33342__$1 = state_33342;
var statearr_33349_33386 = state_33342__$1;
(statearr_33349_33386[(2)] = inst_33316);

(statearr_33349_33386[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (13))){
var inst_33335 = (state_33342[(2)]);
var state_33342__$1 = state_33342;
var statearr_33350_33387 = state_33342__$1;
(statearr_33350_33387[(2)] = inst_33335);

(statearr_33350_33387[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (6))){
var inst_33271 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_33342__$1 = state_33342;
var statearr_33351_33388 = state_33342__$1;
(statearr_33351_33388[(2)] = inst_33271);

(statearr_33351_33388[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (17))){
var inst_33313 = (state_33342[(2)]);
var inst_33314 = fluree.db.util.async.throw_err(inst_33313);
var state_33342__$1 = state_33342;
var statearr_33352_33389 = state_33342__$1;
(statearr_33352_33389[(2)] = inst_33314);

(statearr_33352_33389[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (3))){
var inst_33340 = (state_33342[(2)]);
var state_33342__$1 = state_33342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33342__$1,inst_33340);
} else {
if((state_val_33343 === (12))){
var inst_33298 = (state_33342[(10)]);
var inst_33305 = (state_33342[(11)]);
var inst_33303 = inst_33298.p;
var inst_33304 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_33303);
var inst_33305__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_33304);
var inst_33306 = inst_33298.op;
var inst_33307 = inst_33306 === false;
var inst_33308 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_33305__$1);
var state_33342__$1 = (function (){var statearr_33353 = state_33342;
(statearr_33353[(12)] = inst_33307);

(statearr_33353[(11)] = inst_33305__$1);

return statearr_33353;
})();
if(inst_33308){
var statearr_33354_33390 = state_33342__$1;
(statearr_33354_33390[(1)] = (14));

} else {
var statearr_33355_33391 = state_33342__$1;
(statearr_33355_33391[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (2))){
var _ = (function (){var statearr_33356 = state_33342;
(statearr_33356[(4)] = cljs.core.cons((5),(state_33342[(4)])));

return statearr_33356;
})();
var state_33342__$1 = state_33342;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_33357_33392 = state_33342__$1;
(statearr_33357_33392[(1)] = (6));

} else {
var statearr_33358_33393 = state_33342__$1;
(statearr_33358_33393[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (19))){
var inst_33298 = (state_33342[(10)]);
var inst_33292 = (state_33342[(8)]);
var inst_33318 = (state_33342[(13)]);
var inst_33305 = (state_33342[(11)]);
var inst_33326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33327 = inst_33298.s;
var inst_33328 = [inst_33327,inst_33305,cljs.core.cst$kw$new];
var inst_33329 = (new cljs.core.PersistentVector(null,3,(5),inst_33326,inst_33328,null));
var inst_33330 = cljs.core.assoc_in(inst_33292,inst_33329,inst_33318);
var state_33342__$1 = state_33342;
var statearr_33359_33394 = state_33342__$1;
(statearr_33359_33394[(2)] = inst_33330);

(statearr_33359_33394[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (11))){
var inst_33292 = (state_33342[(8)]);
var state_33342__$1 = state_33342;
var statearr_33361_33395 = state_33342__$1;
(statearr_33361_33395[(2)] = inst_33292);

(statearr_33361_33395[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (9))){
var inst_33298 = (state_33342[(10)]);
var inst_33291 = (state_33342[(9)]);
var inst_33297 = cljs.core.seq(inst_33291);
var inst_33298__$1 = cljs.core.first(inst_33297);
var inst_33299 = cljs.core.next(inst_33297);
var inst_33300 = cljs.core.not(inst_33298__$1);
var state_33342__$1 = (function (){var statearr_33362 = state_33342;
(statearr_33362[(10)] = inst_33298__$1);

(statearr_33362[(7)] = inst_33299);

return statearr_33362;
})();
if(inst_33300){
var statearr_33363_33396 = state_33342__$1;
(statearr_33363_33396[(1)] = (11));

} else {
var statearr_33364_33397 = state_33342__$1;
(statearr_33364_33397[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (5))){
var _ = (function (){var statearr_33365 = state_33342;
(statearr_33365[(4)] = cljs.core.rest((state_33342[(4)])));

return statearr_33365;
})();
var state_33342__$1 = state_33342;
var ex33360 = (state_33342__$1[(2)]);
var statearr_33366_33398 = state_33342__$1;
(statearr_33366_33398[(5)] = ex33360);


if((ex33360 instanceof Error)){
var statearr_33367_33399 = state_33342__$1;
(statearr_33367_33399[(1)] = (4));

(statearr_33367_33399[(5)] = null);

} else {
throw ex33360;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (14))){
var inst_33298 = (state_33342[(10)]);
var inst_33310 = inst_33298.o;
var inst_33311 = fluree.db.query.schema.convert_type_to_kw(inst_33310,db);
var state_33342__$1 = state_33342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33342__$1,(17),inst_33311);
} else {
if((state_val_33343 === (16))){
var inst_33307 = (state_33342[(12)]);
var inst_33318 = (state_33342[(2)]);
var state_33342__$1 = (function (){var statearr_33368 = state_33342;
(statearr_33368[(13)] = inst_33318);

return statearr_33368;
})();
if(cljs.core.truth_(inst_33307)){
var statearr_33369_33400 = state_33342__$1;
(statearr_33369_33400[(1)] = (18));

} else {
var statearr_33370_33401 = state_33342__$1;
(statearr_33370_33401[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (10))){
var inst_33337 = (state_33342[(2)]);
var _ = (function (){var statearr_33371 = state_33342;
(statearr_33371[(4)] = cljs.core.rest((state_33342[(4)])));

return statearr_33371;
})();
var state_33342__$1 = state_33342;
var statearr_33372_33402 = state_33342__$1;
(statearr_33372_33402[(2)] = inst_33337);

(statearr_33372_33402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (18))){
var inst_33298 = (state_33342[(10)]);
var inst_33292 = (state_33342[(8)]);
var inst_33318 = (state_33342[(13)]);
var inst_33305 = (state_33342[(11)]);
var inst_33320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33321 = inst_33298.s;
var inst_33322 = [inst_33321,inst_33305,cljs.core.cst$kw$old];
var inst_33323 = (new cljs.core.PersistentVector(null,3,(5),inst_33320,inst_33322,null));
var inst_33324 = cljs.core.assoc_in(inst_33292,inst_33323,inst_33318);
var state_33342__$1 = state_33342;
var statearr_33373_33403 = state_33342__$1;
(statearr_33373_33403[(2)] = inst_33324);

(statearr_33373_33403[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33343 === (8))){
var inst_33274 = (state_33342[(2)]);
var inst_33275 = cljs.core.PersistentHashSet.EMPTY;
var inst_33276 = cljs.core.vals(tempids);
var inst_33277 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33275,inst_33276);
var inst_33278 = (function (){var pred_flakes = inst_33274;
var is_new_QMARK_ = inst_33277;
return (function (p1__33262_SHARP_,p2__33263_SHARP_){
return cljs.core.assoc_in(p1__33262_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__33263_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__33374 = p2__33263_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__33374) : is_new_QMARK_.call(null,G__33374));
})()));
});
})();
var inst_33279 = cljs.core.PersistentHashMap.EMPTY;
var inst_33280 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_33278,inst_33279,inst_33274);
var inst_33288 = cljs.core.seq(inst_33274);
var inst_33289 = cljs.core.first(inst_33288);
var inst_33290 = cljs.core.next(inst_33288);
var inst_33291 = inst_33274;
var inst_33292 = inst_33280;
var state_33342__$1 = (function (){var statearr_33375 = state_33342;
(statearr_33375[(8)] = inst_33292);

(statearr_33375[(9)] = inst_33291);

(statearr_33375[(14)] = inst_33290);

(statearr_33375[(15)] = inst_33289);

return statearr_33375;
})();
var statearr_33376_33404 = state_33342__$1;
(statearr_33376_33404[(2)] = null);

(statearr_33376_33404[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto____0 = (function (){
var statearr_33377 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33377[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto__);

(statearr_33377[(1)] = (1));

return statearr_33377;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto____1 = (function (state_33342){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_33342);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e33378){var ex__14781__auto__ = e33378;
var statearr_33379_33405 = state_33342;
(statearr_33379_33405[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_33342[(4)]))){
var statearr_33380_33406 = state_33342;
(statearr_33380_33406[(1)] = cljs.core.first((state_33342[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__33407 = state_33342;
state_33342 = G__33407;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto__ = function(state_33342){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto____1.call(this,state_33342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_33381 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_33381[(6)] = c__14852__auto__);

return statearr_33381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__33409 = arguments.length;
switch (G__33409) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__33412 = arguments.length;
switch (G__33412) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_33724){
var state_val_33725 = (state_33724[(1)]);
if((state_val_33725 === (121))){
var inst_33679 = (state_33724[(7)]);
var state_33724__$1 = state_33724;
var statearr_33726_33919 = state_33724__$1;
(statearr_33726_33919[(2)] = inst_33679);

(statearr_33726_33919[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (65))){
var inst_33578 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33578)){
var statearr_33727_33920 = state_33724__$1;
(statearr_33727_33920[(1)] = (66));

} else {
var statearr_33728_33921 = state_33724__$1;
(statearr_33728_33921[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (70))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33588 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_33589 = (inst_33584.cljs$core$IFn$_invoke$arity$5 ? inst_33584.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_33588,null) : inst_33584.call(null,cljs.core.PersistentArrayMap,null,3,inst_33588,null));
var inst_33590 = (inst_33584.cljs$core$IFn$_invoke$arity$4 ? inst_33584.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_33589,null) : inst_33584.call(null,cljs.core.PersistentHashSet,null,inst_33589,null));
var inst_33591 = (inst_33590.cljs$core$IFn$_invoke$arity$1 ? inst_33590.cljs$core$IFn$_invoke$arity$1(inst_33583) : inst_33590.call(null,inst_33583));
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33591)){
var statearr_33729_33922 = state_33724__$1;
(statearr_33729_33922[(1)] = (72));

} else {
var statearr_33730_33923 = state_33724__$1;
(statearr_33730_33923[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (62))){
var inst_33568 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33731_33924 = state_33724__$1;
(statearr_33731_33924[(2)] = inst_33568);

(statearr_33731_33924[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (74))){
var inst_33674 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33732_33925 = state_33724__$1;
(statearr_33732_33925[(2)] = inst_33674);

(statearr_33732_33925[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (110))){
var inst_33701 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33701)){
var statearr_33733_33926 = state_33724__$1;
(statearr_33733_33926[(1)] = (117));

} else {
var statearr_33734_33927 = state_33724__$1;
(statearr_33734_33927[(1)] = (118));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (7))){
var inst_33719 = (state_33724[(2)]);
var _ = (function (){var statearr_33735 = state_33724;
(statearr_33735[(4)] = cljs.core.rest((state_33724[(4)])));

return statearr_33735;
})();
var state_33724__$1 = state_33724;
var statearr_33736_33928 = state_33724__$1;
(statearr_33736_33928[(2)] = inst_33719);

(statearr_33736_33928[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (59))){
var inst_33572 = (state_33724[(10)]);
var inst_33452 = (state_33724[(11)]);
var inst_33571 = (state_33724[(2)]);
var inst_33572__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_33452);
var state_33724__$1 = (function (){var statearr_33737 = state_33724;
(statearr_33737[(12)] = inst_33571);

(statearr_33737[(10)] = inst_33572__$1);

return statearr_33737;
})();
if(cljs.core.truth_(inst_33572__$1)){
var statearr_33738_33929 = state_33724__$1;
(statearr_33738_33929[(1)] = (63));

} else {
var statearr_33739_33930 = state_33724__$1;
(statearr_33739_33930[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (86))){
var inst_33614 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33740_33931 = state_33724__$1;
(statearr_33740_33931[(2)] = inst_33614);

(statearr_33740_33931[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (20))){
var inst_33478 = (state_33724[(13)]);
var inst_33452 = (state_33724[(11)]);
var inst_33478__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_33452);
var state_33724__$1 = (function (){var statearr_33741 = state_33724;
(statearr_33741[(13)] = inst_33478__$1);

return statearr_33741;
})();
if(cljs.core.truth_(inst_33478__$1)){
var statearr_33742_33932 = state_33724__$1;
(statearr_33742_33932[(1)] = (23));

} else {
var statearr_33743_33933 = state_33724__$1;
(statearr_33743_33933[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (72))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33593 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_33583,inst_33584,throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33744_33934 = state_33724__$1;
(statearr_33744_33934[(2)] = inst_33593);

(statearr_33744_33934[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (58))){
var inst_33533 = (state_33724[(14)]);
var state_33724__$1 = state_33724;
var statearr_33745_33935 = state_33724__$1;
(statearr_33745_33935[(2)] = inst_33533);

(statearr_33745_33935[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (60))){
var inst_33451 = (state_33724[(15)]);
var inst_33440 = (state_33724[(16)]);
var inst_33559 = fluree.db.dbproto._p_prop(inst_33440,cljs.core.cst$kw$name,inst_33451);
var inst_33560 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33559)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_33561 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33562 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_33563 = cljs.core.PersistentHashMap.fromArrays(inst_33561,inst_33562);
var inst_33564 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33560,inst_33563);
var inst_33565 = (function(){throw inst_33564})();
var state_33724__$1 = state_33724;
var statearr_33746_33936 = state_33724__$1;
(statearr_33746_33936[(2)] = inst_33565);

(statearr_33746_33936[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (27))){
var inst_33481 = (state_33724[(17)]);
var state_33724__$1 = state_33724;
var statearr_33747_33937 = state_33724__$1;
(statearr_33747_33937[(2)] = inst_33481);

(statearr_33747_33937[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (1))){
var state_33724__$1 = state_33724;
var statearr_33748_33938 = state_33724__$1;
(statearr_33748_33938[(2)] = null);

(statearr_33748_33938[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (69))){
var inst_33571 = (state_33724[(12)]);
var state_33724__$1 = state_33724;
var statearr_33749_33939 = state_33724__$1;
(statearr_33749_33939[(2)] = inst_33571);

(statearr_33749_33939[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (101))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33652 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_33583,inst_33584,throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33750_33940 = state_33724__$1;
(statearr_33750_33940[(2)] = inst_33652);

(statearr_33750_33940[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (24))){
var inst_33478 = (state_33724[(13)]);
var state_33724__$1 = state_33724;
var statearr_33751_33941 = state_33724__$1;
(statearr_33751_33941[(2)] = inst_33478);

(statearr_33751_33941[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (102))){
var inst_33654 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33752_33942 = state_33724__$1;
(statearr_33752_33942[(2)] = inst_33654);

(statearr_33752_33942[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (55))){
var inst_33550 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33753_33943 = state_33724__$1;
(statearr_33753_33943[(2)] = inst_33550);

(statearr_33753_33943[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (85))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33612 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_33583,inst_33584,throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33754_33944 = state_33724__$1;
(statearr_33754_33944[(2)] = inst_33612);

(statearr_33754_33944[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (39))){
var inst_33515 = (state_33724[(18)]);
var state_33724__$1 = state_33724;
var statearr_33755_33945 = state_33724__$1;
(statearr_33755_33945[(2)] = inst_33515);

(statearr_33755_33945[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (88))){
var inst_33571 = (state_33724[(12)]);
var state_33724__$1 = state_33724;
var statearr_33756_33946 = state_33724__$1;
(statearr_33756_33946[(2)] = inst_33571);

(statearr_33756_33946[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (46))){
var inst_33534 = (state_33724[(19)]);
var inst_33452 = (state_33724[(11)]);
var inst_33533 = (state_33724[(2)]);
var inst_33534__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_33452);
var state_33724__$1 = (function (){var statearr_33757 = state_33724;
(statearr_33757[(14)] = inst_33533);

(statearr_33757[(19)] = inst_33534__$1);

return statearr_33757;
})();
if(cljs.core.truth_(inst_33534__$1)){
var statearr_33758_33947 = state_33724__$1;
(statearr_33758_33947[(1)] = (47));

} else {
var statearr_33759_33948 = state_33724__$1;
(statearr_33759_33948[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (4))){
var inst_33413 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33760_33949 = state_33724__$1;
(statearr_33760_33949[(2)] = inst_33413);

(statearr_33760_33949[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (77))){
var inst_33672 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33761_33950 = state_33724__$1;
(statearr_33761_33950[(2)] = inst_33672);

(statearr_33761_33950[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (106))){
var inst_33664 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33762_33951 = state_33724__$1;
(statearr_33762_33951[(2)] = inst_33664);

(statearr_33762_33951[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (119))){
var inst_33450 = (state_33724[(20)]);
var inst_33714 = (state_33724[(2)]);
var inst_33439 = inst_33450;
var inst_33440 = inst_33714;
var state_33724__$1 = (function (){var statearr_33763 = state_33724;
(statearr_33763[(21)] = inst_33439);

(statearr_33763[(16)] = inst_33440);

return statearr_33763;
})();
var statearr_33764_33952 = state_33724__$1;
(statearr_33764_33952[(2)] = null);

(statearr_33764_33952[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (95))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33636 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_33637 = (inst_33584.cljs$core$IFn$_invoke$arity$5 ? inst_33584.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_33636,null) : inst_33584.call(null,cljs.core.PersistentArrayMap,null,5,inst_33636,null));
var inst_33638 = (inst_33584.cljs$core$IFn$_invoke$arity$4 ? inst_33584.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_33637,null) : inst_33584.call(null,cljs.core.PersistentHashSet,null,inst_33637,null));
var inst_33639 = (inst_33638.cljs$core$IFn$_invoke$arity$1 ? inst_33638.cljs$core$IFn$_invoke$arity$1(inst_33583) : inst_33638.call(null,inst_33583));
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33639)){
var statearr_33765_33953 = state_33724__$1;
(statearr_33765_33953[(1)] = (96));

} else {
var statearr_33766_33954 = state_33724__$1;
(statearr_33766_33954[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (54))){
var inst_33541 = (state_33724[(22)]);
var state_33724__$1 = state_33724;
var statearr_33767_33955 = state_33724__$1;
(statearr_33767_33955[(2)] = inst_33541);

(statearr_33767_33955[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (92))){
var inst_33571 = (state_33724[(12)]);
var state_33724__$1 = state_33724;
var statearr_33768_33956 = state_33724__$1;
(statearr_33768_33956[(2)] = inst_33571);

(statearr_33768_33956[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (104))){
var inst_33571 = (state_33724[(12)]);
var state_33724__$1 = state_33724;
var statearr_33769_33957 = state_33724__$1;
(statearr_33769_33957[(2)] = inst_33571);

(statearr_33769_33957[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (15))){
var inst_33460 = (state_33724[(23)]);
var state_33724__$1 = state_33724;
var statearr_33770_33958 = state_33724__$1;
(statearr_33770_33958[(2)] = inst_33460);

(statearr_33770_33958[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (48))){
var inst_33534 = (state_33724[(19)]);
var state_33724__$1 = state_33724;
var statearr_33771_33959 = state_33724__$1;
(statearr_33771_33959[(2)] = inst_33534);

(statearr_33771_33959[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (50))){
var inst_33541 = (state_33724[(22)]);
var inst_33452 = (state_33724[(11)]);
var inst_33539 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33540 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_33539);
var inst_33541__$1 = inst_33540 === true;
var state_33724__$1 = (function (){var statearr_33772 = state_33724;
(statearr_33772[(22)] = inst_33541__$1);

return statearr_33772;
})();
if(cljs.core.truth_(inst_33541__$1)){
var statearr_33773_33960 = state_33724__$1;
(statearr_33773_33960[(1)] = (53));

} else {
var statearr_33774_33961 = state_33724__$1;
(statearr_33774_33961[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (116))){
var inst_33695 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33775_33962 = state_33724__$1;
(statearr_33775_33962[(2)] = inst_33695);

(statearr_33775_33962[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (75))){
var inst_33584 = (state_33724[(9)]);
var state_33724__$1 = state_33724;
var G__33776_33963 = inst_33584;
var G__33776_33964__$1 = (((G__33776_33963 instanceof cljs.core.Keyword))?G__33776_33963.fqn:null);
switch (G__33776_33964__$1) {
case "long":
var statearr_33777_33966 = state_33724__$1;
(statearr_33777_33966[(1)] = (79));


break;
case "bigint":
var statearr_33778_33967 = state_33724__$1;
(statearr_33778_33967[(1)] = (83));


break;
case "double":
var statearr_33779_33968 = state_33724__$1;
(statearr_33779_33968[(1)] = (87));


break;
case "float":
var statearr_33780_33969 = state_33724__$1;
(statearr_33780_33969[(1)] = (91));


break;
case "bigdec":
var statearr_33781_33970 = state_33724__$1;
(statearr_33781_33970[(1)] = (95));


break;
case "string":
var statearr_33782_33971 = state_33724__$1;
(statearr_33782_33971[(1)] = (99));


break;
case "instant":
var statearr_33783_33972 = state_33724__$1;
(statearr_33783_33972[(1)] = (103));


break;
default:
var statearr_33784_33973 = state_33724__$1;
(statearr_33784_33973[(1)] = (107));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (99))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33646 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_33647 = (inst_33584.cljs$core$IFn$_invoke$arity$5 ? inst_33584.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_33646,null) : inst_33584.call(null,cljs.core.PersistentArrayMap,null,5,inst_33646,null));
var inst_33648 = (inst_33584.cljs$core$IFn$_invoke$arity$4 ? inst_33584.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_33647,null) : inst_33584.call(null,cljs.core.PersistentHashSet,null,inst_33647,null));
var inst_33649 = (inst_33648.cljs$core$IFn$_invoke$arity$1 ? inst_33648.cljs$core$IFn$_invoke$arity$1(inst_33583) : inst_33648.call(null,inst_33583));
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33649)){
var statearr_33785_33974 = state_33724__$1;
(statearr_33785_33974[(1)] = (100));

} else {
var statearr_33786_33975 = state_33724__$1;
(statearr_33786_33975[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (21))){
var inst_33476 = (state_33724[(24)]);
var state_33724__$1 = state_33724;
var statearr_33787_33976 = state_33724__$1;
(statearr_33787_33976[(2)] = inst_33476);

(statearr_33787_33976[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (31))){
var inst_33492 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33788_33977 = state_33724__$1;
(statearr_33788_33977[(2)] = inst_33492);

(statearr_33788_33977[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (113))){
var inst_33698 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33789_33978 = state_33724__$1;
(statearr_33789_33978[(2)] = inst_33698);

(statearr_33789_33978[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (32))){
var state_33724__$1 = state_33724;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_33790_33979 = state_33724__$1;
(statearr_33790_33979[(1)] = (35));

} else {
var statearr_33791_33980 = state_33724__$1;
(statearr_33791_33980[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (40))){
var inst_33528 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33528)){
var statearr_33792_33981 = state_33724__$1;
(statearr_33792_33981[(1)] = (44));

} else {
var statearr_33793_33982 = state_33724__$1;
(statearr_33793_33982[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (91))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33626 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_33627 = (inst_33584.cljs$core$IFn$_invoke$arity$5 ? inst_33584.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_33626,null) : inst_33584.call(null,cljs.core.PersistentArrayMap,null,3,inst_33626,null));
var inst_33628 = (inst_33584.cljs$core$IFn$_invoke$arity$4 ? inst_33584.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_33627,null) : inst_33584.call(null,cljs.core.PersistentHashSet,null,inst_33627,null));
var inst_33629 = (inst_33628.cljs$core$IFn$_invoke$arity$1 ? inst_33628.cljs$core$IFn$_invoke$arity$1(inst_33583) : inst_33628.call(null,inst_33583));
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33629)){
var statearr_33794_33983 = state_33724__$1;
(statearr_33794_33983[(1)] = (92));

} else {
var statearr_33795_33984 = state_33724__$1;
(statearr_33795_33984[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (117))){
var state_33724__$1 = state_33724;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_33796_33985 = state_33724__$1;
(statearr_33796_33985[(1)] = (120));

} else {
var statearr_33797_33986 = state_33724__$1;
(statearr_33797_33986[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (108))){
var inst_33452 = (state_33724[(11)]);
var inst_33683 = (state_33724[(25)]);
var inst_33683__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_33452);
var state_33724__$1 = (function (){var statearr_33798 = state_33724;
(statearr_33798[(25)] = inst_33683__$1);

return statearr_33798;
})();
if(cljs.core.truth_(inst_33683__$1)){
var statearr_33799_33987 = state_33724__$1;
(statearr_33799_33987[(1)] = (111));

} else {
var statearr_33800_33988 = state_33724__$1;
(statearr_33800_33988[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (56))){
var inst_33545 = (state_33724[(2)]);
var inst_33546 = fluree.db.util.async.throw_err(inst_33545);
var inst_33547 = cljs.core.not(inst_33546);
var state_33724__$1 = state_33724;
var statearr_33801_33989 = state_33724__$1;
(statearr_33801_33989[(2)] = inst_33547);

(statearr_33801_33989[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (33))){
var inst_33475 = (state_33724[(26)]);
var state_33724__$1 = state_33724;
var statearr_33802_33990 = state_33724__$1;
(statearr_33802_33990[(2)] = inst_33475);

(statearr_33802_33990[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (13))){
var inst_33470 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33470)){
var statearr_33803_33991 = state_33724__$1;
(statearr_33803_33991[(1)] = (17));

} else {
var statearr_33804_33992 = state_33724__$1;
(statearr_33804_33992[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (22))){
var inst_33501 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33501)){
var statearr_33805_33993 = state_33724__$1;
(statearr_33805_33993[(1)] = (32));

} else {
var statearr_33806_33994 = state_33724__$1;
(statearr_33806_33994[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (90))){
var inst_33624 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33807_33995 = state_33724__$1;
(statearr_33807_33995[(2)] = inst_33624);

(statearr_33807_33995[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (109))){
var inst_33681 = (state_33724[(27)]);
var state_33724__$1 = state_33724;
var statearr_33808_33996 = state_33724__$1;
(statearr_33808_33996[(2)] = inst_33681);

(statearr_33808_33996[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (36))){
var inst_33475 = (state_33724[(26)]);
var state_33724__$1 = state_33724;
var statearr_33809_33997 = state_33724__$1;
(statearr_33809_33997[(2)] = inst_33475);

(statearr_33809_33997[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (41))){
var inst_33452 = (state_33724[(11)]);
var inst_33520 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33521 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_33520);
var inst_33522 = inst_33521 === true;
var state_33724__$1 = state_33724;
var statearr_33810_33998 = state_33724__$1;
(statearr_33810_33998[(2)] = inst_33522);

(statearr_33810_33998[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (118))){
var inst_33679 = (state_33724[(7)]);
var state_33724__$1 = state_33724;
var statearr_33811_33999 = state_33724__$1;
(statearr_33811_33999[(2)] = inst_33679);

(statearr_33811_33999[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (89))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33622 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_33583,inst_33584,throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33812_34000 = state_33724__$1;
(statearr_33812_34000[(2)] = inst_33622);

(statearr_33812_34000[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (100))){
var inst_33571 = (state_33724[(12)]);
var state_33724__$1 = state_33724;
var statearr_33813_34001 = state_33724__$1;
(statearr_33813_34001[(2)] = inst_33571);

(statearr_33813_34001[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (122))){
var inst_33711 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33814_34002 = state_33724__$1;
(statearr_33814_34002[(2)] = inst_33711);

(statearr_33814_34002[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (43))){
var inst_33525 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33815_34003 = state_33724__$1;
(statearr_33815_34003[(2)] = inst_33525);

(statearr_33815_34003[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (61))){
var inst_33533 = (state_33724[(14)]);
var state_33724__$1 = state_33724;
var statearr_33816_34004 = state_33724__$1;
(statearr_33816_34004[(2)] = inst_33533);

(statearr_33816_34004[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (29))){
var inst_33452 = (state_33724[(11)]);
var inst_33487 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33488 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_33487);
var inst_33489 = inst_33488 === true;
var state_33724__$1 = state_33724;
var statearr_33817_34005 = state_33724__$1;
(statearr_33817_34005[(2)] = inst_33489);

(statearr_33817_34005[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (44))){
var inst_33514 = (state_33724[(28)]);
var inst_33530 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_33514,"a component","a non-component",throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33818_34006 = state_33724__$1;
(statearr_33818_34006[(2)] = inst_33530);

(statearr_33818_34006[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (93))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33632 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_33583,inst_33584,throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33819_34007 = state_33724__$1;
(statearr_33819_34007[(2)] = inst_33632);

(statearr_33819_34007[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (6))){
var inst_33451 = (state_33724[(15)]);
var inst_33439 = (state_33724[(21)]);
var inst_33448 = cljs.core.seq(inst_33439);
var inst_33449 = cljs.core.first(inst_33448);
var inst_33450 = cljs.core.next(inst_33448);
var inst_33451__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33449,(0),null);
var inst_33452 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33449,(1),null);
var inst_33453 = cljs.core.not(inst_33451__$1);
var state_33724__$1 = (function (){var statearr_33820 = state_33724;
(statearr_33820[(15)] = inst_33451__$1);

(statearr_33820[(20)] = inst_33450);

(statearr_33820[(11)] = inst_33452);

return statearr_33820;
})();
if(inst_33453){
var statearr_33821_34008 = state_33724__$1;
(statearr_33821_34008[(1)] = (8));

} else {
var statearr_33822_34009 = state_33724__$1;
(statearr_33822_34009[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (111))){
var inst_33687 = (state_33724[(29)]);
var inst_33452 = (state_33724[(11)]);
var inst_33685 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33686 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_33685);
var inst_33687__$1 = inst_33686 === true;
var state_33724__$1 = (function (){var statearr_33823 = state_33724;
(statearr_33823[(29)] = inst_33687__$1);

return statearr_33823;
})();
if(cljs.core.truth_(inst_33687__$1)){
var statearr_33824_34010 = state_33724__$1;
(statearr_33824_34010[(1)] = (114));

} else {
var statearr_33825_34011 = state_33724__$1;
(statearr_33825_34011[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (28))){
var inst_33495 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33826_34012 = state_33724__$1;
(statearr_33826_34012[(2)] = inst_33495);

(statearr_33826_34012[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (64))){
var inst_33572 = (state_33724[(10)]);
var state_33724__$1 = state_33724;
var statearr_33827_34013 = state_33724__$1;
(statearr_33827_34013[(2)] = inst_33572);

(statearr_33827_34013[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (103))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33656 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_33657 = (inst_33584.cljs$core$IFn$_invoke$arity$5 ? inst_33584.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_33656,null) : inst_33584.call(null,cljs.core.PersistentArrayMap,null,2,inst_33656,null));
var inst_33658 = (inst_33584.cljs$core$IFn$_invoke$arity$4 ? inst_33584.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_33657,null) : inst_33584.call(null,cljs.core.PersistentHashSet,null,inst_33657,null));
var inst_33659 = (inst_33658.cljs$core$IFn$_invoke$arity$1 ? inst_33658.cljs$core$IFn$_invoke$arity$1(inst_33583) : inst_33658.call(null,inst_33583));
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33659)){
var statearr_33828_34014 = state_33724__$1;
(statearr_33828_34014[(1)] = (104));

} else {
var statearr_33829_34015 = state_33724__$1;
(statearr_33829_34015[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (51))){
var inst_33537 = (state_33724[(30)]);
var state_33724__$1 = state_33724;
var statearr_33830_34016 = state_33724__$1;
(statearr_33830_34016[(2)] = inst_33537);

(statearr_33830_34016[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (25))){
var inst_33498 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33831_34017 = state_33724__$1;
(statearr_33831_34017[(2)] = inst_33498);

(statearr_33831_34017[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (34))){
var inst_33515 = (state_33724[(18)]);
var inst_33452 = (state_33724[(11)]);
var inst_33514 = (state_33724[(2)]);
var inst_33515__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_33452);
var state_33724__$1 = (function (){var statearr_33832 = state_33724;
(statearr_33832[(28)] = inst_33514);

(statearr_33832[(18)] = inst_33515__$1);

return statearr_33832;
})();
if(cljs.core.truth_(inst_33515__$1)){
var statearr_33833_34018 = state_33724__$1;
(statearr_33833_34018[(1)] = (38));

} else {
var statearr_33834_34019 = state_33724__$1;
(statearr_33834_34019[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (17))){
var inst_33440 = (state_33724[(16)]);
var inst_33472 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_33440,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33835_34020 = state_33724__$1;
(statearr_33835_34020[(2)] = inst_33472);

(statearr_33835_34020[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (3))){
var inst_33722 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33724__$1,inst_33722);
} else {
if((state_val_33725 === (12))){
var inst_33456 = (state_33724[(31)]);
var state_33724__$1 = state_33724;
var statearr_33836_34021 = state_33724__$1;
(statearr_33836_34021[(2)] = inst_33456);

(statearr_33836_34021[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (2))){
var _ = (function (){var statearr_33837 = state_33724;
(statearr_33837[(4)] = cljs.core.cons((5),(state_33724[(4)])));

return statearr_33837;
})();
var inst_33432 = pred_changes;
var inst_33433 = cljs.core.seq(inst_33432);
var inst_33434 = cljs.core.first(inst_33433);
var inst_33435 = cljs.core.next(inst_33433);
var inst_33436 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33434,(0),null);
var inst_33437 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33434,(1),null);
var inst_33438 = db;
var inst_33439 = inst_33432;
var inst_33440 = inst_33438;
var state_33724__$1 = (function (){var statearr_33838 = state_33724;
(statearr_33838[(32)] = inst_33436);

(statearr_33838[(21)] = inst_33439);

(statearr_33838[(33)] = inst_33437);

(statearr_33838[(16)] = inst_33440);

(statearr_33838[(34)] = inst_33435);

return statearr_33838;
})();
var statearr_33839_34022 = state_33724__$1;
(statearr_33839_34022[(2)] = null);

(statearr_33839_34022[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (66))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33452 = (state_33724[(11)]);
var inst_33581 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33582 = cljs.core.__destructure_map(inst_33581);
var inst_33583__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33582,cljs.core.cst$kw$old);
var inst_33584__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33582,cljs.core.cst$kw$new);
var inst_33585 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33584__$1,inst_33583__$1);
var state_33724__$1 = (function (){var statearr_33840 = state_33724;
(statearr_33840[(8)] = inst_33583__$1);

(statearr_33840[(9)] = inst_33584__$1);

return statearr_33840;
})();
if(inst_33585){
var statearr_33841_34023 = state_33724__$1;
(statearr_33841_34023[(1)] = (69));

} else {
var statearr_33842_34024 = state_33724__$1;
(statearr_33842_34024[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (107))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33666 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_33583,inst_33584,throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33843_34025 = state_33724__$1;
(statearr_33843_34025[(2)] = inst_33666);

(statearr_33843_34025[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (23))){
var inst_33481 = (state_33724[(17)]);
var inst_33452 = (state_33724[(11)]);
var inst_33480 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33481__$1 = inst_33480 === true;
var state_33724__$1 = (function (){var statearr_33844 = state_33724;
(statearr_33844[(17)] = inst_33481__$1);

return statearr_33844;
})();
if(cljs.core.truth_(inst_33481__$1)){
var statearr_33845_34026 = state_33724__$1;
(statearr_33845_34026[(1)] = (26));

} else {
var statearr_33846_34027 = state_33724__$1;
(statearr_33846_34027[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (47))){
var inst_33537 = (state_33724[(30)]);
var inst_33452 = (state_33724[(11)]);
var inst_33536 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33537__$1 = cljs.core.not(inst_33536);
var state_33724__$1 = (function (){var statearr_33847 = state_33724;
(statearr_33847[(30)] = inst_33537__$1);

return statearr_33847;
})();
if(inst_33537__$1){
var statearr_33848_34028 = state_33724__$1;
(statearr_33848_34028[(1)] = (50));

} else {
var statearr_33849_34029 = state_33724__$1;
(statearr_33849_34029[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (35))){
var inst_33504 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33505 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_33506 = cljs.core.PersistentHashMap.fromArrays(inst_33504,inst_33505);
var inst_33507 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_33506);
var inst_33508 = (function(){throw inst_33507})();
var state_33724__$1 = state_33724;
var statearr_33850_34030 = state_33724__$1;
(statearr_33850_34030[(2)] = inst_33508);

(statearr_33850_34030[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (82))){
var inst_33604 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33851_34031 = state_33724__$1;
(statearr_33851_34031[(2)] = inst_33604);

(statearr_33851_34031[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (76))){
var state_33724__$1 = state_33724;
var statearr_33852_34032 = state_33724__$1;
(statearr_33852_34032[(2)] = null);

(statearr_33852_34032[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (97))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33642 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_33583,inst_33584,throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33853_34033 = state_33724__$1;
(statearr_33853_34033[(2)] = inst_33642);

(statearr_33853_34033[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (19))){
var inst_33476 = (state_33724[(24)]);
var inst_33452 = (state_33724[(11)]);
var inst_33475 = (state_33724[(2)]);
var inst_33476__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_33452);
var state_33724__$1 = (function (){var statearr_33854 = state_33724;
(statearr_33854[(26)] = inst_33475);

(statearr_33854[(24)] = inst_33476__$1);

return statearr_33854;
})();
if(cljs.core.truth_(inst_33476__$1)){
var statearr_33855_34034 = state_33724__$1;
(statearr_33855_34034[(1)] = (20));

} else {
var statearr_33856_34035 = state_33724__$1;
(statearr_33856_34035[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (57))){
var state_33724__$1 = state_33724;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_33857_34036 = state_33724__$1;
(statearr_33857_34036[(1)] = (60));

} else {
var statearr_33858_34037 = state_33724__$1;
(statearr_33858_34037[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (68))){
var inst_33681 = (state_33724[(27)]);
var inst_33452 = (state_33724[(11)]);
var inst_33679 = (state_33724[(2)]);
var inst_33680 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33681__$1 = inst_33680 === true;
var state_33724__$1 = (function (){var statearr_33859 = state_33724;
(statearr_33859[(27)] = inst_33681__$1);

(statearr_33859[(7)] = inst_33679);

return statearr_33859;
})();
if(cljs.core.truth_(inst_33681__$1)){
var statearr_33860_34038 = state_33724__$1;
(statearr_33860_34038[(1)] = (108));

} else {
var statearr_33861_34039 = state_33724__$1;
(statearr_33861_34039[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (11))){
var inst_33460 = (state_33724[(23)]);
var inst_33452 = (state_33724[(11)]);
var inst_33458 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33459 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_33458);
var inst_33460__$1 = inst_33459 === false;
var state_33724__$1 = (function (){var statearr_33862 = state_33724;
(statearr_33862[(23)] = inst_33460__$1);

return statearr_33862;
})();
if(cljs.core.truth_(inst_33460__$1)){
var statearr_33863_34040 = state_33724__$1;
(statearr_33863_34040[(1)] = (14));

} else {
var statearr_33864_34041 = state_33724__$1;
(statearr_33864_34041[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (115))){
var inst_33687 = (state_33724[(29)]);
var state_33724__$1 = state_33724;
var statearr_33866_34042 = state_33724__$1;
(statearr_33866_34042[(2)] = inst_33687);

(statearr_33866_34042[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (9))){
var inst_33456 = (state_33724[(31)]);
var inst_33452 = (state_33724[(11)]);
var inst_33456__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_33452);
var state_33724__$1 = (function (){var statearr_33867 = state_33724;
(statearr_33867[(31)] = inst_33456__$1);

return statearr_33867;
})();
if(cljs.core.truth_(inst_33456__$1)){
var statearr_33868_34043 = state_33724__$1;
(statearr_33868_34043[(1)] = (11));

} else {
var statearr_33869_34044 = state_33724__$1;
(statearr_33869_34044[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (5))){
var _ = (function (){var statearr_33870 = state_33724;
(statearr_33870[(4)] = cljs.core.rest((state_33724[(4)])));

return statearr_33870;
})();
var state_33724__$1 = state_33724;
var ex33865 = (state_33724__$1[(2)]);
var statearr_33871_34045 = state_33724__$1;
(statearr_33871_34045[(5)] = ex33865);


if((ex33865 instanceof Error)){
var statearr_33872_34046 = state_33724__$1;
(statearr_33872_34046[(1)] = (4));

(statearr_33872_34046[(5)] = null);

} else {
throw ex33865;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (112))){
var inst_33683 = (state_33724[(25)]);
var state_33724__$1 = state_33724;
var statearr_33873_34047 = state_33724__$1;
(statearr_33873_34047[(2)] = inst_33683);

(statearr_33873_34047[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (83))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33606 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_33607 = (inst_33584.cljs$core$IFn$_invoke$arity$5 ? inst_33584.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_33606,null) : inst_33584.call(null,cljs.core.PersistentArrayMap,null,3,inst_33606,null));
var inst_33608 = (inst_33584.cljs$core$IFn$_invoke$arity$4 ? inst_33584.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_33607,null) : inst_33584.call(null,cljs.core.PersistentHashSet,null,inst_33607,null));
var inst_33609 = (inst_33608.cljs$core$IFn$_invoke$arity$1 ? inst_33608.cljs$core$IFn$_invoke$arity$1(inst_33583) : inst_33608.call(null,inst_33583));
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33609)){
var statearr_33874_34048 = state_33724__$1;
(statearr_33874_34048[(1)] = (84));

} else {
var statearr_33875_34049 = state_33724__$1;
(statearr_33875_34049[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (14))){
var inst_33452 = (state_33724[(11)]);
var inst_33462 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33463 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_33462);
var inst_33464 = inst_33463 === true;
var state_33724__$1 = state_33724;
var statearr_33876_34050 = state_33724__$1;
(statearr_33876_34050[(2)] = inst_33464);

(statearr_33876_34050[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (45))){
var inst_33514 = (state_33724[(28)]);
var state_33724__$1 = state_33724;
var statearr_33877_34051 = state_33724__$1;
(statearr_33877_34051[(2)] = inst_33514);

(statearr_33877_34051[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (53))){
var inst_33451 = (state_33724[(15)]);
var inst_33440 = (state_33724[(16)]);
var inst_33543 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_33440,inst_33451);
var state_33724__$1 = state_33724;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33724__$1,(56),inst_33543);
} else {
if((state_val_33725 === (78))){
var inst_33669 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33878_34052 = state_33724__$1;
(statearr_33878_34052[(2)] = inst_33669);

(statearr_33878_34052[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (26))){
var inst_33485 = (state_33724[(35)]);
var inst_33452 = (state_33724[(11)]);
var inst_33483 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33484 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_33483);
var inst_33485__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_33484);
var state_33724__$1 = (function (){var statearr_33879 = state_33724;
(statearr_33879[(35)] = inst_33485__$1);

return statearr_33879;
})();
if(inst_33485__$1){
var statearr_33880_34053 = state_33724__$1;
(statearr_33880_34053[(1)] = (29));

} else {
var statearr_33881_34054 = state_33724__$1;
(statearr_33881_34054[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (16))){
var inst_33467 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33882_34055 = state_33724__$1;
(statearr_33882_34055[(2)] = inst_33467);

(statearr_33882_34055[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (81))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33602 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_33583,inst_33584,throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33883_34056 = state_33724__$1;
(statearr_33883_34056[(2)] = inst_33602);

(statearr_33883_34056[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (120))){
var inst_33704 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33705 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_33706 = cljs.core.PersistentHashMap.fromArrays(inst_33704,inst_33705);
var inst_33707 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_33706);
var inst_33708 = (function(){throw inst_33707})();
var state_33724__$1 = state_33724;
var statearr_33884_34057 = state_33724__$1;
(statearr_33884_34057[(2)] = inst_33708);

(statearr_33884_34057[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (79))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33596 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_33597 = (inst_33584.cljs$core$IFn$_invoke$arity$5 ? inst_33584.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_33596,null) : inst_33584.call(null,cljs.core.PersistentArrayMap,null,2,inst_33596,null));
var inst_33598 = (inst_33584.cljs$core$IFn$_invoke$arity$4 ? inst_33584.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_33597,null) : inst_33584.call(null,cljs.core.PersistentHashSet,null,inst_33597,null));
var inst_33599 = (inst_33598.cljs$core$IFn$_invoke$arity$1 ? inst_33598.cljs$core$IFn$_invoke$arity$1(inst_33583) : inst_33598.call(null,inst_33583));
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33599)){
var statearr_33885_34058 = state_33724__$1;
(statearr_33885_34058[(1)] = (80));

} else {
var statearr_33886_34059 = state_33724__$1;
(statearr_33886_34059[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (38))){
var inst_33518 = (state_33724[(36)]);
var inst_33452 = (state_33724[(11)]);
var inst_33517 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33518__$1 = cljs.core.not(inst_33517);
var state_33724__$1 = (function (){var statearr_33887 = state_33724;
(statearr_33887[(36)] = inst_33518__$1);

return statearr_33887;
})();
if(inst_33518__$1){
var statearr_33888_34060 = state_33724__$1;
(statearr_33888_34060[(1)] = (41));

} else {
var statearr_33889_34061 = state_33724__$1;
(statearr_33889_34061[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (98))){
var inst_33644 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33890_34062 = state_33724__$1;
(statearr_33890_34062[(2)] = inst_33644);

(statearr_33890_34062[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (87))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33616 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_33617 = (inst_33584.cljs$core$IFn$_invoke$arity$5 ? inst_33584.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_33616,null) : inst_33584.call(null,cljs.core.PersistentArrayMap,null,3,inst_33616,null));
var inst_33618 = (inst_33584.cljs$core$IFn$_invoke$arity$4 ? inst_33584.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_33617,null) : inst_33584.call(null,cljs.core.PersistentHashSet,null,inst_33617,null));
var inst_33619 = (inst_33618.cljs$core$IFn$_invoke$arity$1 ? inst_33618.cljs$core$IFn$_invoke$arity$1(inst_33583) : inst_33618.call(null,inst_33583));
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33619)){
var statearr_33891_34063 = state_33724__$1;
(statearr_33891_34063[(1)] = (88));

} else {
var statearr_33892_34064 = state_33724__$1;
(statearr_33892_34064[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (30))){
var inst_33485 = (state_33724[(35)]);
var state_33724__$1 = state_33724;
var statearr_33893_34065 = state_33724__$1;
(statearr_33893_34065[(2)] = inst_33485);

(statearr_33893_34065[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (73))){
var state_33724__$1 = state_33724;
var statearr_33894_34066 = state_33724__$1;
(statearr_33894_34066[(1)] = (75));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (96))){
var inst_33571 = (state_33724[(12)]);
var state_33724__$1 = state_33724;
var statearr_33896_34067 = state_33724__$1;
(statearr_33896_34067[(2)] = inst_33571);

(statearr_33896_34067[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (10))){
var inst_33717 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33897_34068 = state_33724__$1;
(statearr_33897_34068[(2)] = inst_33717);

(statearr_33897_34068[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (18))){
var inst_33440 = (state_33724[(16)]);
var state_33724__$1 = state_33724;
var statearr_33898_34069 = state_33724__$1;
(statearr_33898_34069[(2)] = inst_33440);

(statearr_33898_34069[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (105))){
var inst_33583 = (state_33724[(8)]);
var inst_33584 = (state_33724[(9)]);
var inst_33662 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_33583,inst_33584,throw_QMARK_);
var state_33724__$1 = state_33724;
var statearr_33899_34070 = state_33724__$1;
(statearr_33899_34070[(2)] = inst_33662);

(statearr_33899_34070[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (52))){
var inst_33553 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33900_34071 = state_33724__$1;
(statearr_33900_34071[(2)] = inst_33553);

(statearr_33900_34071[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (114))){
var inst_33452 = (state_33724[(11)]);
var inst_33689 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33690 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_33689);
var inst_33691 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_33690);
var inst_33692 = (!(inst_33691));
var state_33724__$1 = state_33724;
var statearr_33901_34072 = state_33724__$1;
(statearr_33901_34072[(2)] = inst_33692);

(statearr_33901_34072[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (67))){
var inst_33571 = (state_33724[(12)]);
var state_33724__$1 = state_33724;
var statearr_33902_34073 = state_33724__$1;
(statearr_33902_34073[(2)] = inst_33571);

(statearr_33902_34073[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (71))){
var inst_33676 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33903_34074 = state_33724__$1;
(statearr_33903_34074[(2)] = inst_33676);

(statearr_33903_34074[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (42))){
var inst_33518 = (state_33724[(36)]);
var state_33724__$1 = state_33724;
var statearr_33904_34075 = state_33724__$1;
(statearr_33904_34075[(2)] = inst_33518);

(statearr_33904_34075[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (80))){
var inst_33571 = (state_33724[(12)]);
var state_33724__$1 = state_33724;
var statearr_33905_34076 = state_33724__$1;
(statearr_33905_34076[(2)] = inst_33571);

(statearr_33905_34076[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (37))){
var inst_33511 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33906_34077 = state_33724__$1;
(statearr_33906_34077[(2)] = inst_33511);

(statearr_33906_34077[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (63))){
var inst_33452 = (state_33724[(11)]);
var inst_33574 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_33452);
var inst_33575 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_33574);
var state_33724__$1 = state_33724;
var statearr_33907_34078 = state_33724__$1;
(statearr_33907_34078[(2)] = inst_33575);

(statearr_33907_34078[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (94))){
var inst_33634 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
var statearr_33908_34079 = state_33724__$1;
(statearr_33908_34079[(2)] = inst_33634);

(statearr_33908_34079[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (8))){
var inst_33440 = (state_33724[(16)]);
var state_33724__$1 = state_33724;
var statearr_33909_34080 = state_33724__$1;
(statearr_33909_34080[(2)] = inst_33440);

(statearr_33909_34080[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (49))){
var inst_33556 = (state_33724[(2)]);
var state_33724__$1 = state_33724;
if(cljs.core.truth_(inst_33556)){
var statearr_33910_34081 = state_33724__$1;
(statearr_33910_34081[(1)] = (57));

} else {
var statearr_33911_34082 = state_33724__$1;
(statearr_33911_34082[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33725 === (84))){
var inst_33571 = (state_33724[(12)]);
var state_33724__$1 = state_33724;
var statearr_33912_34083 = state_33724__$1;
(statearr_33912_34083[(2)] = inst_33571);

(statearr_33912_34083[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__14778__auto__ = null;
var fluree$db$query$schema$state_machine__14778__auto____0 = (function (){
var statearr_33913 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33913[(0)] = fluree$db$query$schema$state_machine__14778__auto__);

(statearr_33913[(1)] = (1));

return statearr_33913;
});
var fluree$db$query$schema$state_machine__14778__auto____1 = (function (state_33724){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_33724);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e33914){var ex__14781__auto__ = e33914;
var statearr_33915_34084 = state_33724;
(statearr_33915_34084[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_33724[(4)]))){
var statearr_33916_34085 = state_33724;
(statearr_33916_34085[(1)] = cljs.core.first((state_33724[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__34086 = state_33724;
state_33724 = G__34086;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__14778__auto__ = function(state_33724){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__14778__auto____1.call(this,state_33724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__14778__auto____0;
fluree$db$query$schema$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__14778__auto____1;
return fluree$db$query$schema$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_33917 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_33917[(6)] = c__14852__auto__);

return statearr_33917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__34088 = arguments.length;
switch (G__34088) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_34112){
var state_val_34113 = (state_34112[(1)]);
if((state_val_34113 === (7))){
var state_34112__$1 = state_34112;
var statearr_34114_34134 = state_34112__$1;
(statearr_34114_34134[(2)] = db);

(statearr_34114_34134[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34113 === (1))){
var state_34112__$1 = state_34112;
var statearr_34115_34135 = state_34112__$1;
(statearr_34115_34135[(2)] = null);

(statearr_34115_34135[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34113 === (4))){
var inst_34089 = (state_34112[(2)]);
var state_34112__$1 = state_34112;
var statearr_34116_34136 = state_34112__$1;
(statearr_34116_34136[(2)] = inst_34089);

(statearr_34116_34136[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34113 === (6))){
var inst_34098 = (state_34112[(7)]);
var inst_34097 = (state_34112[(2)]);
var inst_34098__$1 = fluree.db.util.async.throw_err(inst_34097);
var inst_34099 = cljs.core.empty_QMARK_(inst_34098__$1);
var state_34112__$1 = (function (){var statearr_34117 = state_34112;
(statearr_34117[(7)] = inst_34098__$1);

return statearr_34117;
})();
if(inst_34099){
var statearr_34118_34137 = state_34112__$1;
(statearr_34118_34137[(1)] = (7));

} else {
var statearr_34119_34138 = state_34112__$1;
(statearr_34119_34138[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34113 === (3))){
var inst_34110 = (state_34112[(2)]);
var state_34112__$1 = state_34112;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34112__$1,inst_34110);
} else {
if((state_val_34113 === (2))){
var _ = (function (){var statearr_34121 = state_34112;
(statearr_34121[(4)] = cljs.core.cons((5),(state_34112[(4)])));

return statearr_34121;
})();
var inst_34095 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_34112__$1 = state_34112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34112__$1,(6),inst_34095);
} else {
if((state_val_34113 === (9))){
var inst_34107 = (state_34112[(2)]);
var _ = (function (){var statearr_34122 = state_34112;
(statearr_34122[(4)] = cljs.core.rest((state_34112[(4)])));

return statearr_34122;
})();
var state_34112__$1 = state_34112;
var statearr_34123_34139 = state_34112__$1;
(statearr_34123_34139[(2)] = inst_34107);

(statearr_34123_34139[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34113 === (5))){
var _ = (function (){var statearr_34124 = state_34112;
(statearr_34124[(4)] = cljs.core.rest((state_34112[(4)])));

return statearr_34124;
})();
var state_34112__$1 = state_34112;
var ex34120 = (state_34112__$1[(2)]);
var statearr_34125_34140 = state_34112__$1;
(statearr_34125_34140[(5)] = ex34120);


if((ex34120 instanceof Error)){
var statearr_34126_34141 = state_34112__$1;
(statearr_34126_34141[(1)] = (4));

(statearr_34126_34141[(5)] = null);

} else {
throw ex34120;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34113 === (10))){
var inst_34104 = (state_34112[(2)]);
var inst_34105 = fluree.db.util.async.throw_err(inst_34104);
var state_34112__$1 = state_34112;
var statearr_34127_34142 = state_34112__$1;
(statearr_34127_34142[(2)] = inst_34105);

(statearr_34127_34142[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34113 === (8))){
var inst_34098 = (state_34112[(7)]);
var inst_34102 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_34098,db,true);
var state_34112__$1 = state_34112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34112__$1,(10),inst_34102);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__14778__auto__ = null;
var fluree$db$query$schema$state_machine__14778__auto____0 = (function (){
var statearr_34128 = [null,null,null,null,null,null,null,null];
(statearr_34128[(0)] = fluree$db$query$schema$state_machine__14778__auto__);

(statearr_34128[(1)] = (1));

return statearr_34128;
});
var fluree$db$query$schema$state_machine__14778__auto____1 = (function (state_34112){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_34112);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e34129){var ex__14781__auto__ = e34129;
var statearr_34130_34143 = state_34112;
(statearr_34130_34143[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_34112[(4)]))){
var statearr_34131_34144 = state_34112;
(statearr_34131_34144[(1)] = cljs.core.first((state_34112[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__34145 = state_34112;
state_34112 = G__34145;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__14778__auto__ = function(state_34112){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__14778__auto____1.call(this,state_34112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__14778__auto____0;
fluree$db$query$schema$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__14778__auto____1;
return fluree$db$query$schema$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_34132 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_34132[(6)] = c__14852__auto__);

return statearr_34132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__34147 = arguments.length;
switch (G__34147) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__34149 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34149,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34149,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34149,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4221__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4221__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__34152_SHARP_,p2__34153_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34152_SHARP_,p2__34153_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__34154_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,p1__34154_SHARP_.p)){
return p1__34154_SHARP_.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_34220){
var state_val_34221 = (state_34220[(1)]);
if((state_val_34221 === (1))){
var state_34220__$1 = state_34220;
var statearr_34222_34240 = state_34220__$1;
(statearr_34222_34240[(2)] = null);

(statearr_34222_34240[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34221 === (2))){
var _ = (function (){var statearr_34223 = state_34220;
(statearr_34223[(4)] = cljs.core.cons((5),(state_34220[(4)])));

return statearr_34223;
})();
var inst_34172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34173 = fluree.db.flake.max_subject_id((1));
var inst_34174 = [inst_34173];
var inst_34175 = (new cljs.core.PersistentVector(null,1,(5),inst_34172,inst_34174,null));
var inst_34176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34177 = [(0)];
var inst_34178 = (new cljs.core.PersistentVector(null,1,(5),inst_34176,inst_34177,null));
var inst_34179 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_34175,cljs.core._LT__EQ_,inst_34178);
var state_34220__$1 = state_34220;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34220__$1,(6),inst_34179);
} else {
if((state_val_34221 === (3))){
var inst_34218 = (state_34220[(2)]);
var state_34220__$1 = state_34220;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34220__$1,inst_34218);
} else {
if((state_val_34221 === (4))){
var inst_34160 = (state_34220[(2)]);
var state_34220__$1 = state_34220;
var statearr_34225_34241 = state_34220__$1;
(statearr_34225_34241[(2)] = inst_34160);

(statearr_34225_34241[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34221 === (5))){
var _ = (function (){var statearr_34226 = state_34220;
(statearr_34226[(4)] = cljs.core.rest((state_34220[(4)])));

return statearr_34226;
})();
var state_34220__$1 = state_34220;
var ex34224 = (state_34220__$1[(2)]);
var statearr_34227_34242 = state_34220__$1;
(statearr_34227_34242[(5)] = ex34224);


if((ex34224 instanceof Error)){
var statearr_34228_34243 = state_34220__$1;
(statearr_34228_34243[(1)] = (4));

(statearr_34228_34243[(5)] = null);

} else {
throw ex34224;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34221 === (6))){
var inst_34181 = (state_34220[(2)]);
var inst_34182 = fluree.db.util.async.throw_err(inst_34181);
var inst_34183 = (function (){var schema_flakes = inst_34182;
return (function (p1__34155_SHARP_){
return (p1__34155_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_34184 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_34183,inst_34182);
var inst_34185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34184,(0),null);
var inst_34186 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34184,(1),null);
var inst_34187 = (function (){var schema_flakes = inst_34182;
var vec__34166 = inst_34184;
var collection_flakes = inst_34185;
var predicate_flakes = inst_34186;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__34157_SHARP_,p2__34158_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__34157_SHARP_,p2__34158_SHARP_.p,p2__34158_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_34188 = [(-1),"_tx"];
var inst_34189 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_34190 = ["_tx",(-1),(-1)];
var inst_34191 = cljs.core.PersistentHashMap.fromArrays(inst_34189,inst_34190);
var inst_34192 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_34193 = ["_tx",(-1),(-1)];
var inst_34194 = cljs.core.PersistentHashMap.fromArrays(inst_34192,inst_34193);
var inst_34195 = [inst_34191,inst_34194];
var inst_34196 = cljs.core.PersistentHashMap.fromArrays(inst_34188,inst_34195);
var inst_34197 = (function (){var schema_flakes = inst_34182;
var vec__34166 = inst_34184;
var collection_flakes = inst_34185;
var predicate_flakes = inst_34186;
return (function (p1__34156_SHARP_){
return p1__34156_SHARP_.s;
});
})();
var inst_34198 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_34197,inst_34185);
var inst_34199 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34187,inst_34196,inst_34198);
var inst_34201 = (function (){var schema_flakes = inst_34182;
var vec__34166 = inst_34184;
var collection_flakes = inst_34185;
var predicate_flakes = inst_34186;
var coll = inst_34199;
return (function (p__34200,pred_flakes){
var vec__34229 = p__34200;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34229,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34229,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__34232 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__34232.cljs$core$IFn$_invoke$arity$1 ? fexpr__34232.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__34232.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4223__auto__ = ref_QMARK_;
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_34202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34203 = cljs.core.PersistentHashMap.EMPTY;
var inst_34204 = cljs.core.PersistentHashSet.EMPTY;
var inst_34205 = [inst_34203,inst_34204];
var inst_34206 = (new cljs.core.PersistentVector(null,2,(5),inst_34202,inst_34205,null));
var inst_34207 = (function (){var schema_flakes = inst_34182;
var vec__34166 = inst_34184;
var collection_flakes = inst_34185;
var predicate_flakes = inst_34186;
var coll = inst_34199;
return (function (p1__34159_SHARP_){
return p1__34159_SHARP_.s;
});
})();
var inst_34208 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_34207,inst_34186);
var inst_34209 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34201,inst_34206,inst_34208);
var inst_34210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34209,(0),null);
var inst_34211 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34209,(1),null);
var inst_34212 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_34213 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_34214 = [inst_34213,inst_34199,inst_34210,inst_34211];
var inst_34215 = cljs.core.PersistentHashMap.fromArrays(inst_34212,inst_34214);
var _ = (function (){var statearr_34233 = state_34220;
(statearr_34233[(4)] = cljs.core.rest((state_34220[(4)])));

return statearr_34233;
})();
var state_34220__$1 = state_34220;
var statearr_34234_34244 = state_34220__$1;
(statearr_34234_34244[(2)] = inst_34215);

(statearr_34234_34244[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__14778__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__14778__auto____0 = (function (){
var statearr_34235 = [null,null,null,null,null,null,null];
(statearr_34235[(0)] = fluree$db$query$schema$schema_map_$_state_machine__14778__auto__);

(statearr_34235[(1)] = (1));

return statearr_34235;
});
var fluree$db$query$schema$schema_map_$_state_machine__14778__auto____1 = (function (state_34220){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_34220);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e34236){var ex__14781__auto__ = e34236;
var statearr_34237_34245 = state_34220;
(statearr_34237_34245[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_34220[(4)]))){
var statearr_34238_34246 = state_34220;
(statearr_34238_34246[(1)] = cljs.core.first((state_34220[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__34247 = state_34220;
state_34220 = G__34247;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__14778__auto__ = function(state_34220){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__14778__auto____1.call(this,state_34220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__14778__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__14778__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_34239 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_34239[(6)] = c__14852__auto__);

return statearr_34239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_34289){
var state_val_34290 = (state_34289[(1)]);
if((state_val_34290 === (7))){
var inst_34272 = (state_34289[(2)]);
var inst_34273 = fluree.db.query.schema.flake__GT_pred_map(inst_34272);
var inst_34274 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_34275 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34273,(114));
var inst_34276 = cljs.core.boolean$(inst_34275);
var inst_34277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34273,(110));
var inst_34278 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34273,(117));
var inst_34279 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_34278);
var inst_34280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34273,(111));
var inst_34281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34273,(115));
var inst_34282 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34273,(112));
var inst_34283 = [inst_34276,inst_34277,inst_34279,inst_34280,inst_34281,inst_34282];
var inst_34284 = cljs.core.PersistentHashMap.fromArrays(inst_34274,inst_34283);
var _ = (function (){var statearr_34291 = state_34289;
(statearr_34291[(4)] = cljs.core.rest((state_34289[(4)])));

return statearr_34291;
})();
var state_34289__$1 = state_34289;
var statearr_34292_34315 = state_34289__$1;
(statearr_34292_34315[(2)] = inst_34284);

(statearr_34292_34315[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (1))){
var state_34289__$1 = state_34289;
var statearr_34293_34316 = state_34289__$1;
(statearr_34293_34316[(2)] = null);

(statearr_34293_34316[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (4))){
var inst_34248 = (state_34289[(2)]);
var state_34289__$1 = state_34289;
var statearr_34294_34317 = state_34289__$1;
(statearr_34294_34317[(2)] = inst_34248);

(statearr_34294_34317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (6))){
var _ = (function (){var statearr_34295 = state_34289;
(statearr_34295[(4)] = cljs.core.cons((9),(state_34289[(4)])));

return statearr_34295;
})();
var inst_34260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34262 = ["_setting/id","root"];
var inst_34263 = (new cljs.core.PersistentVector(null,2,(5),inst_34261,inst_34262,null));
var inst_34264 = [inst_34263];
var inst_34265 = (new cljs.core.PersistentVector(null,1,(5),inst_34260,inst_34264,null));
var inst_34266 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34265);
var state_34289__$1 = state_34289;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34289__$1,(10),inst_34266);
} else {
if((state_val_34290 === (3))){
var inst_34287 = (state_34289[(2)]);
var state_34289__$1 = state_34289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34289__$1,inst_34287);
} else {
if((state_val_34290 === (2))){
var _ = (function (){var statearr_34298 = state_34289;
(statearr_34298[(4)] = cljs.core.cons((5),(state_34289[(4)])));

return statearr_34298;
})();
var state_34289__$1 = state_34289;
var statearr_34299_34318 = state_34289__$1;
(statearr_34299_34318[(2)] = null);

(statearr_34299_34318[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (9))){
var _ = (function (){var statearr_34300 = state_34289;
(statearr_34300[(4)] = cljs.core.rest((state_34289[(4)])));

return statearr_34300;
})();
var state_34289__$1 = state_34289;
var ex34296 = (state_34289__$1[(2)]);
var statearr_34301_34319 = state_34289__$1;
(statearr_34301_34319[(5)] = ex34296);


var statearr_34302_34320 = state_34289__$1;
(statearr_34302_34320[(1)] = (8));

(statearr_34302_34320[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (5))){
var _ = (function (){var statearr_34303 = state_34289;
(statearr_34303[(4)] = cljs.core.rest((state_34289[(4)])));

return statearr_34303;
})();
var state_34289__$1 = state_34289;
var ex34297 = (state_34289__$1[(2)]);
var statearr_34304_34321 = state_34289__$1;
(statearr_34304_34321[(5)] = ex34297);


if((ex34297 instanceof Error)){
var statearr_34305_34322 = state_34289__$1;
(statearr_34305_34322[(1)] = (4));

(statearr_34305_34322[(5)] = null);

} else {
throw ex34297;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (10))){
var inst_34268 = (state_34289[(2)]);
var inst_34269 = fluree.db.util.async.throw_err(inst_34268);
var _ = (function (){var statearr_34306 = state_34289;
(statearr_34306[(4)] = cljs.core.rest((state_34289[(4)])));

return statearr_34306;
})();
var state_34289__$1 = state_34289;
var statearr_34307_34323 = state_34289__$1;
(statearr_34307_34323[(2)] = inst_34269);

(statearr_34307_34323[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (8))){
var inst_34254 = (state_34289[(2)]);
var state_34289__$1 = (function (){var statearr_34308 = state_34289;
(statearr_34308[(7)] = inst_34254);

return statearr_34308;
})();
var statearr_34309_34324 = state_34289__$1;
(statearr_34309_34324[(2)] = null);

(statearr_34309_34324[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__14778__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__14778__auto____0 = (function (){
var statearr_34310 = [null,null,null,null,null,null,null,null];
(statearr_34310[(0)] = fluree$db$query$schema$setting_map_$_state_machine__14778__auto__);

(statearr_34310[(1)] = (1));

return statearr_34310;
});
var fluree$db$query$schema$setting_map_$_state_machine__14778__auto____1 = (function (state_34289){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_34289);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e34311){var ex__14781__auto__ = e34311;
var statearr_34312_34325 = state_34289;
(statearr_34312_34325[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_34289[(4)]))){
var statearr_34313_34326 = state_34289;
(statearr_34313_34326[(1)] = cljs.core.first((state_34289[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__34327 = state_34289;
state_34289 = G__34327;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__14778__auto__ = function(state_34289){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__14778__auto____1.call(this,state_34289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__14778__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__14778__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_34314 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_34314[(6)] = c__14852__auto__);

return statearr_34314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
