// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__41617 = arguments.length;
switch (G__41617) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__41620 = arguments.length;
switch (G__41620) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__14852__auto___41673 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_41651){
var state_val_41652 = (state_41651[(1)]);
if((state_val_41652 === (1))){
var state_41651__$1 = state_41651;
var statearr_41653_41674 = state_41651__$1;
(statearr_41653_41674[(2)] = null);

(statearr_41653_41674[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41652 === (2))){
var _ = (function (){var statearr_41654 = state_41651;
(statearr_41654[(4)] = cljs.core.cons((5),(state_41651[(4)])));

return statearr_41654;
})();
var inst_41628 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_41651__$1 = state_41651;
if(cljs.core.truth_(inst_41628)){
var statearr_41655_41675 = state_41651__$1;
(statearr_41655_41675[(1)] = (6));

} else {
var statearr_41656_41676 = state_41651__$1;
(statearr_41656_41676[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41652 === (3))){
var inst_41649 = (state_41651[(2)]);
var state_41651__$1 = state_41651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41651__$1,inst_41649);
} else {
if((state_val_41652 === (4))){
var inst_41621 = (state_41651[(2)]);
var inst_41622 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_41621);
var state_41651__$1 = state_41651;
var statearr_41658_41677 = state_41651__$1;
(statearr_41658_41677[(2)] = inst_41622);

(statearr_41658_41677[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41652 === (5))){
var _ = (function (){var statearr_41659 = state_41651;
(statearr_41659[(4)] = cljs.core.rest((state_41651[(4)])));

return statearr_41659;
})();
var state_41651__$1 = state_41651;
var ex41657 = (state_41651__$1[(2)]);
var statearr_41660_41678 = state_41651__$1;
(statearr_41660_41678[(5)] = ex41657);


var statearr_41661_41679 = state_41651__$1;
(statearr_41661_41679[(1)] = (4));

(statearr_41661_41679[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41652 === (6))){
var inst_41630 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41631 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_41632 = cljs.core.PersistentHashMap.fromArrays(inst_41630,inst_41631);
var inst_41633 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_41632);
var inst_41634 = (function(){throw inst_41633})();
var state_41651__$1 = state_41651;
var statearr_41662_41680 = state_41651__$1;
(statearr_41662_41680[(2)] = inst_41634);

(statearr_41662_41680[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41652 === (7))){
var inst_41636 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_41637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41638 = [operation,data,pc,opts];
var inst_41639 = (new cljs.core.PersistentVector(null,4,(5),inst_41637,inst_41638,null));
var inst_41640 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_41636,inst_41639);
var inst_41641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41642 = [operation,data,pc,opts];
var inst_41643 = (new cljs.core.PersistentVector(null,4,(5),inst_41641,inst_41642,null));
var inst_41644 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_41643], 0));
var state_41651__$1 = (function (){var statearr_41663 = state_41651;
(statearr_41663[(7)] = inst_41640);

return statearr_41663;
})();
var statearr_41664_41681 = state_41651__$1;
(statearr_41664_41681[(2)] = inst_41644);

(statearr_41664_41681[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41652 === (8))){
var inst_41646 = (state_41651[(2)]);
var _ = (function (){var statearr_41665 = state_41651;
(statearr_41665[(4)] = cljs.core.rest((state_41651[(4)])));

return statearr_41665;
})();
var state_41651__$1 = state_41651;
var statearr_41666_41682 = state_41651__$1;
(statearr_41666_41682[(2)] = inst_41646);

(statearr_41666_41682[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__14778__auto__ = null;
var fluree$db$operations$state_machine__14778__auto____0 = (function (){
var statearr_41667 = [null,null,null,null,null,null,null,null];
(statearr_41667[(0)] = fluree$db$operations$state_machine__14778__auto__);

(statearr_41667[(1)] = (1));

return statearr_41667;
});
var fluree$db$operations$state_machine__14778__auto____1 = (function (state_41651){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_41651);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e41668){var ex__14781__auto__ = e41668;
var statearr_41669_41683 = state_41651;
(statearr_41669_41683[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_41651[(4)]))){
var statearr_41670_41684 = state_41651;
(statearr_41670_41684[(1)] = cljs.core.first((state_41651[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__41685 = state_41651;
state_41651 = G__41685;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$operations$state_machine__14778__auto__ = function(state_41651){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__14778__auto____1.call(this,state_41651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__14778__auto____0;
fluree$db$operations$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__14778__auto____1;
return fluree$db$operations$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_41671 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_41671[(6)] = c__14852__auto___41673);

return statearr_41671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__41687 = arguments.length;
switch (G__41687) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__41688){
var map__41689 = p__41688;
var map__41689__$1 = cljs.core.__destructure_map(map__41689);
var opts = map__41689__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41689__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__41690 = session;
var map__41690__$1 = cljs.core.__destructure_map(map__41690);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41690__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41690__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41690__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4835__auto__ = [];
var len__4829__auto___41717 = arguments.length;
var i__4830__auto___41718 = (0);
while(true){
if((i__4830__auto___41718 < len__4829__auto___41717)){
args__4835__auto__.push((arguments[i__4830__auto___41718]));

var G__41719 = (i__4830__auto___41718 + (1));
i__4830__auto___41718 = G__41719;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__41694){
var vec__41695 = p__41694;
var map__41698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41695,(0),null);
var map__41698__$1 = cljs.core.__destructure_map(map__41698);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41698__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41698__$1,cljs.core.cst$kw$toTime);
var opts = vec__41695;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_41710){
var state_val_41711 = (state_41710[(1)]);
if((state_val_41711 === (1))){
var inst_41700 = session;
var inst_41701 = cljs.core.__destructure_map(inst_41700);
var inst_41702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41701,cljs.core.cst$kw$network);
var inst_41703 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41701,cljs.core.cst$kw$dbid);
var inst_41704 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41701,cljs.core.cst$kw$conn);
var inst_41705 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_41706 = [inst_41702,inst_41703,toBlock,toTime];
var inst_41707 = cljs.core.PersistentHashMap.fromArrays(inst_41705,inst_41706);
var inst_41708 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_41704,cljs.core.cst$kw$garbage,inst_41707);
var state_41710__$1 = state_41710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41710__$1,inst_41708);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__14778__auto__ = null;
var fluree$db$operations$state_machine__14778__auto____0 = (function (){
var statearr_41712 = [null,null,null,null,null,null,null];
(statearr_41712[(0)] = fluree$db$operations$state_machine__14778__auto__);

(statearr_41712[(1)] = (1));

return statearr_41712;
});
var fluree$db$operations$state_machine__14778__auto____1 = (function (state_41710){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_41710);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e41713){var ex__14781__auto__ = e41713;
var statearr_41714_41720 = state_41710;
(statearr_41714_41720[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_41710[(4)]))){
var statearr_41715_41721 = state_41710;
(statearr_41715_41721[(1)] = cljs.core.first((state_41710[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__41722 = state_41710;
state_41710 = G__41722;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$operations$state_machine__14778__auto__ = function(state_41710){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__14778__auto____1.call(this,state_41710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__14778__auto____0;
fluree$db$operations$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__14778__auto____1;
return fluree$db$operations$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_41716 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_41716[(6)] = c__14852__auto__);

return statearr_41716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq41692){
var G__41693 = cljs.core.first(seq41692);
var seq41692__$1 = cljs.core.next(seq41692);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41693,seq41692__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__41723 = session;
var map__41723__$1 = cljs.core.__destructure_map(map__41723);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41723__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41723__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41723__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__41725 = arguments.length;
switch (G__41725) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__41726 = opts;
var map__41726__$1 = cljs.core.__destructure_map(map__41726);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41726__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41726__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4223__auto__ = auth;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
