// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45387 = arguments.length;
var i__4830__auto___45388 = (0);
while(true){
if((i__4830__auto___45388 < len__4829__auto___45387)){
args__4835__auto__.push((arguments[i__4830__auto___45388]));

var G__45389 = (i__4830__auto___45388 + (1));
i__4830__auto___45388 = G__45389;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq45384){
var G__45385 = cljs.core.first(seq45384);
var seq45384__$1 = cljs.core.next(seq45384);
var G__45386 = cljs.core.first(seq45384__$1);
var seq45384__$2 = cljs.core.next(seq45384__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45385,G__45386,seq45384__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e45390){var e = e45390;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e45391){var e = e45391;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e45392){var e = e45392;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e45393){var e = e45393;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e45394){var e = e45394;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45397 = arguments.length;
var i__4830__auto___45398 = (0);
while(true){
if((i__4830__auto___45398 < len__4829__auto___45397)){
args__4835__auto__.push((arguments[i__4830__auto___45398]));

var G__45399 = (i__4830__auto___45398 + (1));
i__4830__auto___45398 = G__45399;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e45396){var e = e45396;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq45395){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45395));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45402 = arguments.length;
var i__4830__auto___45403 = (0);
while(true){
if((i__4830__auto___45403 < len__4829__auto___45402)){
args__4835__auto__.push((arguments[i__4830__auto___45403]));

var G__45404 = (i__4830__auto___45403 + (1));
i__4830__auto___45403 = G__45404;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e45401){var e = e45401;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq45400){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45400));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e45405){var e = e45405;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45408 = arguments.length;
var i__4830__auto___45409 = (0);
while(true){
if((i__4830__auto___45409 < len__4829__auto___45408)){
args__4835__auto__.push((arguments[i__4830__auto___45409]));

var G__45410 = (i__4830__auto___45409 + (1));
i__4830__auto___45409 = G__45410;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e45407){var e = e45407;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq45406){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45406));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45413 = arguments.length;
var i__4830__auto___45414 = (0);
while(true){
if((i__4830__auto___45414 < len__4829__auto___45413)){
args__4835__auto__.push((arguments[i__4830__auto___45414]));

var G__45415 = (i__4830__auto___45414 + (1));
i__4830__auto___45414 = G__45415;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e45412){var e = e45412;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq45411){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45411));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e45416){var e = e45416;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e45417){var e = e45417;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45420 = arguments.length;
var i__4830__auto___45421 = (0);
while(true){
if((i__4830__auto___45421 < len__4829__auto___45420)){
args__4835__auto__.push((arguments[i__4830__auto___45421]));

var G__45422 = (i__4830__auto___45421 + (1));
i__4830__auto___45421 = G__45422;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e45419){var e = e45419;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq45418){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45418));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45425 = arguments.length;
var i__4830__auto___45426 = (0);
while(true){
if((i__4830__auto___45426 < len__4829__auto___45425)){
args__4835__auto__.push((arguments[i__4830__auto___45426]));

var G__45427 = (i__4830__auto___45426 + (1));
i__4830__auto___45426 = G__45427;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e45424){var e = e45424;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq45423){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45423));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45430 = arguments.length;
var i__4830__auto___45431 = (0);
while(true){
if((i__4830__auto___45431 < len__4829__auto___45430)){
args__4835__auto__.push((arguments[i__4830__auto___45431]));

var G__45432 = (i__4830__auto___45431 + (1));
i__4830__auto___45431 = G__45432;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e45429){var e = e45429;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq45428){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45428));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45435 = arguments.length;
var i__4830__auto___45436 = (0);
while(true){
if((i__4830__auto___45436 < len__4829__auto___45435)){
args__4835__auto__.push((arguments[i__4830__auto___45436]));

var G__45437 = (i__4830__auto___45436 + (1));
i__4830__auto___45436 = G__45437;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e45434){var e = e45434;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq45433){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45433));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45440 = arguments.length;
var i__4830__auto___45441 = (0);
while(true){
if((i__4830__auto___45441 < len__4829__auto___45440)){
args__4835__auto__.push((arguments[i__4830__auto___45441]));

var G__45442 = (i__4830__auto___45441 + (1));
i__4830__auto___45441 = G__45442;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e45439){var e = e45439;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq45438){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45438));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45445 = arguments.length;
var i__4830__auto___45446 = (0);
while(true){
if((i__4830__auto___45446 < len__4829__auto___45445)){
args__4835__auto__.push((arguments[i__4830__auto___45446]));

var G__45447 = (i__4830__auto___45446 + (1));
i__4830__auto___45446 = G__45447;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e45444){var e = e45444;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq45443){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45443));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45450 = arguments.length;
var i__4830__auto___45451 = (0);
while(true){
if((i__4830__auto___45451 < len__4829__auto___45450)){
args__4835__auto__.push((arguments[i__4830__auto___45451]));

var G__45452 = (i__4830__auto___45451 + (1));
i__4830__auto___45451 = G__45452;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e45449){var e = e45449;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq45448){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45448));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__45454 = arguments.length;
switch (G__45454) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_45482){
var state_val_45483 = (state_45482[(1)]);
if((state_val_45483 === (7))){
var inst_45467 = (state_45482[(7)]);
var inst_45470 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45467,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_45482__$1 = state_45482;
var statearr_45484_45570 = state_45482__$1;
(statearr_45484_45570[(2)] = inst_45470);

(statearr_45484_45570[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45483 === (1))){
var state_45482__$1 = state_45482;
var statearr_45485_45571 = state_45482__$1;
(statearr_45485_45571[(2)] = null);

(statearr_45485_45571[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45483 === (4))){
var inst_45455 = (state_45482[(2)]);
var state_45482__$1 = state_45482;
var statearr_45486_45572 = state_45482__$1;
(statearr_45486_45572[(2)] = inst_45455);

(statearr_45486_45572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45483 === (6))){
var inst_45467 = (state_45482[(7)]);
var inst_45467__$1 = (state_45482[(2)]);
var inst_45468 = fluree.db.util.core.exception_QMARK_(inst_45467__$1);
var state_45482__$1 = (function (){var statearr_45487 = state_45482;
(statearr_45487[(7)] = inst_45467__$1);

return statearr_45487;
})();
if(inst_45468){
var statearr_45488_45573 = state_45482__$1;
(statearr_45488_45573[(1)] = (7));

} else {
var statearr_45489_45574 = state_45482__$1;
(statearr_45489_45574[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45483 === (3))){
var inst_45480 = (state_45482[(2)]);
var state_45482__$1 = state_45482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45482__$1,inst_45480);
} else {
if((state_val_45483 === (2))){
var inst_45461 = (state_45482[(8)]);
var _ = (function (){var statearr_45491 = state_45482;
(statearr_45491[(4)] = cljs.core.cons((5),(state_45482[(4)])));

return statearr_45491;
})();
var inst_45461__$1 = cljs.core.volatile_BANG_((0));
var inst_45462 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_45463 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_45462,cljs.core.cst$kw$fuel,inst_45461__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_45464 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_45463);
var inst_45465 = fluree.db.query.fql.query(db,inst_45464);
var state_45482__$1 = (function (){var statearr_45492 = state_45482;
(statearr_45492[(8)] = inst_45461__$1);

return statearr_45492;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45482__$1,(6),inst_45465);
} else {
if((state_val_45483 === (9))){
var inst_45477 = (state_45482[(2)]);
var _ = (function (){var statearr_45493 = state_45482;
(statearr_45493[(4)] = cljs.core.rest((state_45482[(4)])));

return statearr_45493;
})();
var state_45482__$1 = state_45482;
var statearr_45494_45575 = state_45482__$1;
(statearr_45494_45575[(2)] = inst_45477);

(statearr_45494_45575[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45483 === (5))){
var _ = (function (){var statearr_45495 = state_45482;
(statearr_45495[(4)] = cljs.core.rest((state_45482[(4)])));

return statearr_45495;
})();
var state_45482__$1 = state_45482;
var ex45490 = (state_45482__$1[(2)]);
var statearr_45496_45576 = state_45482__$1;
(statearr_45496_45576[(5)] = ex45490);


if((ex45490 instanceof Error)){
var statearr_45497_45577 = state_45482__$1;
(statearr_45497_45577[(1)] = (4));

(statearr_45497_45577[(5)] = null);

} else {
throw ex45490;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45483 === (8))){
var inst_45467 = (state_45482[(7)]);
var inst_45461 = (state_45482[(8)]);
var inst_45472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45473 = cljs.core.deref(inst_45461);
var inst_45474 = [inst_45467,inst_45473];
var inst_45475 = (new cljs.core.PersistentVector(null,2,(5),inst_45472,inst_45474,null));
var state_45482__$1 = state_45482;
var statearr_45498_45578 = state_45482__$1;
(statearr_45498_45578[(2)] = inst_45475);

(statearr_45498_45578[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__14778__auto____0 = (function (){
var statearr_45499 = [null,null,null,null,null,null,null,null,null];
(statearr_45499[(0)] = fluree$db$dbfunctions$internal$state_machine__14778__auto__);

(statearr_45499[(1)] = (1));

return statearr_45499;
});
var fluree$db$dbfunctions$internal$state_machine__14778__auto____1 = (function (state_45482){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_45482);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e45500){var ex__14781__auto__ = e45500;
var statearr_45501_45579 = state_45482;
(statearr_45501_45579[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_45482[(4)]))){
var statearr_45502_45580 = state_45482;
(statearr_45502_45580[(1)] = cljs.core.first((state_45482[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__45581 = state_45482;
state_45482 = G__45581;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__14778__auto__ = function(state_45482){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__14778__auto____1.call(this,state_45482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_45503 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_45503[(6)] = c__14852__auto__);

return statearr_45503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_45548){
var state_val_45549 = (state_45548[(1)]);
if((state_val_45549 === (7))){
var inst_45534 = (state_45548[(2)]);
var inst_45535 = fluree.db.query.fql.query(db,inst_45534);
var state_45548__$1 = state_45548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45548__$1,(8),inst_45535);
} else {
if((state_val_45549 === (1))){
var inst_45504 = typeof select === 'string';
var state_45548__$1 = state_45548;
if(cljs.core.truth_(inst_45504)){
var statearr_45550_45582 = state_45548__$1;
(statearr_45550_45582[(1)] = (2));

} else {
var statearr_45551_45583 = state_45548__$1;
(statearr_45551_45583[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45549 === (4))){
var inst_45510 = (state_45548[(7)]);
var inst_45517 = (state_45548[(8)]);
var inst_45509 = (state_45548[(2)]);
var inst_45510__$1 = cljs.core.volatile_BANG_((0));
var inst_45511 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_45512 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_45513 = [inst_45510__$1,(100000)];
var inst_45514 = cljs.core.PersistentHashMap.fromArrays(inst_45512,inst_45513);
var inst_45515 = [inst_45509,from,where,block,limit,inst_45514];
var inst_45516 = cljs.core.PersistentHashMap.fromArrays(inst_45511,inst_45515);
var inst_45517__$1 = fluree.db.util.core.without_nils(inst_45516);
var inst_45518 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_45517__$1);
var inst_45519 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_45517__$1);
var inst_45520 = cljs.core.first(inst_45519);
var inst_45521 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_45520], 0));
var inst_45522 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_45521);
var inst_45523 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_45517__$1);
var inst_45524 = cljs.core.last(inst_45523);
var inst_45525 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_45524], 0));
var inst_45526 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_45525);
var inst_45527 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_45518,inst_45522,inst_45526], 0));
var state_45548__$1 = (function (){var statearr_45552 = state_45548;
(statearr_45552[(7)] = inst_45510__$1);

(statearr_45552[(8)] = inst_45517__$1);

return statearr_45552;
})();
if(cljs.core.truth_(inst_45527)){
var statearr_45553_45584 = state_45548__$1;
(statearr_45553_45584[(1)] = (5));

} else {
var statearr_45554_45585 = state_45548__$1;
(statearr_45554_45585[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45549 === (6))){
var inst_45517 = (state_45548[(8)]);
var state_45548__$1 = state_45548;
var statearr_45555_45586 = state_45548__$1;
(statearr_45555_45586[(2)] = inst_45517);

(statearr_45555_45586[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45549 === (3))){
var state_45548__$1 = state_45548;
var statearr_45556_45587 = state_45548__$1;
(statearr_45556_45587[(2)] = select);

(statearr_45556_45587[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45549 === (2))){
var inst_45506 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_45548__$1 = state_45548;
var statearr_45557_45588 = state_45548__$1;
(statearr_45557_45588[(2)] = inst_45506);

(statearr_45557_45588[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45549 === (11))){
var inst_45546 = (state_45548[(2)]);
var state_45548__$1 = state_45548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45548__$1,inst_45546);
} else {
if((state_val_45549 === (9))){
var inst_45537 = (state_45548[(9)]);
var state_45548__$1 = state_45548;
var statearr_45558_45589 = state_45548__$1;
(statearr_45558_45589[(2)] = inst_45537);

(statearr_45558_45589[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45549 === (5))){
var inst_45517 = (state_45548[(8)]);
var inst_45529 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_45517);
var inst_45530 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_45529);
var inst_45531 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45517,cljs.core.cst$kw$where,inst_45530);
var state_45548__$1 = state_45548;
var statearr_45559_45590 = state_45548__$1;
(statearr_45559_45590[(2)] = inst_45531);

(statearr_45559_45590[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45549 === (10))){
var inst_45510 = (state_45548[(7)]);
var inst_45537 = (state_45548[(9)]);
var inst_45541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45542 = cljs.core.deref(inst_45510);
var inst_45543 = [inst_45537,inst_45542];
var inst_45544 = (new cljs.core.PersistentVector(null,2,(5),inst_45541,inst_45543,null));
var state_45548__$1 = state_45548;
var statearr_45560_45591 = state_45548__$1;
(statearr_45560_45591[(2)] = inst_45544);

(statearr_45560_45591[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45549 === (8))){
var inst_45537 = (state_45548[(9)]);
var inst_45537__$1 = (state_45548[(2)]);
var inst_45538 = fluree.db.util.core.exception_QMARK_(inst_45537__$1);
var state_45548__$1 = (function (){var statearr_45561 = state_45548;
(statearr_45561[(9)] = inst_45537__$1);

return statearr_45561;
})();
if(inst_45538){
var statearr_45562_45592 = state_45548__$1;
(statearr_45562_45592[(1)] = (9));

} else {
var statearr_45563_45593 = state_45548__$1;
(statearr_45563_45593[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__14778__auto____0 = (function (){
var statearr_45564 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45564[(0)] = fluree$db$dbfunctions$internal$state_machine__14778__auto__);

(statearr_45564[(1)] = (1));

return statearr_45564;
});
var fluree$db$dbfunctions$internal$state_machine__14778__auto____1 = (function (state_45548){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_45548);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e45565){var ex__14781__auto__ = e45565;
var statearr_45566_45594 = state_45548;
(statearr_45566_45594[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_45548[(4)]))){
var statearr_45567_45595 = state_45548;
(statearr_45567_45595[(1)] = cljs.core.first((state_45548[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__45596 = state_45548;
state_45548 = G__45596;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__14778__auto__ = function(state_45548){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__14778__auto____1.call(this,state_45548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_45568 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_45568[(6)] = c__14852__auto__);

return statearr_45568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__45600 = path;
var vec__45601 = G__45600;
var seq__45602 = cljs.core.seq(vec__45601);
var first__45603 = cljs.core.first(seq__45602);
var seq__45602__$1 = cljs.core.next(seq__45602);
var var$ = first__45603;
var r = seq__45602__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__45600__$1 = G__45600;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__45607 = G__45600__$1;
var seq__45608 = cljs.core.seq(vec__45607);
var first__45609 = cljs.core.first(seq__45608);
var seq__45608__$1 = cljs.core.next(seq__45608);
var var$__$1 = first__45609;
var r__$1 = seq__45608__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__45610 = r__$1;
var G__45611 = n__$2;
var G__45612 = next_clauses;
G__45600__$1 = G__45610;
n__$1 = G__45611;
where_clauses__$1 = G__45612;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__45613 = r__$1;
var G__45614 = next_n;
var G__45615 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__45600__$1 = G__45613;
n__$1 = G__45614;
where_clauses__$1 = G__45615;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_45652){
var state_val_45653 = (state_45652[(1)]);
if((state_val_45653 === (7))){
var inst_45625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45626 = [path];
var inst_45627 = (new cljs.core.PersistentVector(null,1,(5),inst_45625,inst_45626,null));
var state_45652__$1 = state_45652;
var statearr_45654_45682 = state_45652__$1;
(statearr_45654_45682[(2)] = inst_45627);

(statearr_45654_45682[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (1))){
var state_45652__$1 = state_45652;
var statearr_45655_45683 = state_45652__$1;
(statearr_45655_45683[(2)] = null);

(statearr_45655_45683[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (4))){
var inst_45616 = (state_45652[(2)]);
var state_45652__$1 = state_45652;
var statearr_45656_45684 = state_45652__$1;
(statearr_45656_45684[(2)] = inst_45616);

(statearr_45656_45684[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (13))){
var inst_45643 = (state_45652[(2)]);
var inst_45644 = fluree.db.util.async.throw_err(inst_45643);
var _ = (function (){var statearr_45657 = state_45652;
(statearr_45657[(4)] = cljs.core.rest((state_45652[(4)])));

return statearr_45657;
})();
var state_45652__$1 = state_45652;
var statearr_45658_45685 = state_45652__$1;
(statearr_45658_45685[(2)] = inst_45644);

(statearr_45658_45685[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (6))){
var state_45652__$1 = state_45652;
var statearr_45660_45686 = state_45652__$1;
(statearr_45660_45686[(2)] = path);

(statearr_45660_45686[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (3))){
var inst_45650 = (state_45652[(2)]);
var state_45652__$1 = state_45652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45652__$1,inst_45650);
} else {
if((state_val_45653 === (12))){
var _ = (function (){var statearr_45661 = state_45652;
(statearr_45661[(4)] = cljs.core.rest((state_45652[(4)])));

return statearr_45661;
})();
var state_45652__$1 = state_45652;
var ex45659 = (state_45652__$1[(2)]);
var statearr_45662_45687 = state_45652__$1;
(statearr_45662_45687[(5)] = ex45659);


var statearr_45663_45688 = state_45652__$1;
(statearr_45663_45688[(1)] = (11));

(statearr_45663_45688[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (2))){
var _ = (function (){var statearr_45664 = state_45652;
(statearr_45664[(4)] = cljs.core.cons((5),(state_45652[(4)])));

return statearr_45664;
})();
var inst_45622 = cljs.core.vector_QMARK_(path);
var state_45652__$1 = state_45652;
if(inst_45622){
var statearr_45665_45689 = state_45652__$1;
(statearr_45665_45689[(1)] = (6));

} else {
var statearr_45666_45690 = state_45652__$1;
(statearr_45666_45690[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (11))){
var inst_45629 = (state_45652[(7)]);
var inst_45634 = (state_45652[(2)]);
var inst_45635 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45634,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_45629,endSubject], 0));
var state_45652__$1 = state_45652;
var statearr_45668_45691 = state_45652__$1;
(statearr_45668_45691[(2)] = inst_45635);

(statearr_45668_45691[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (9))){
var inst_45633 = (state_45652[(8)]);
var _ = (function (){var statearr_45669 = state_45652;
(statearr_45669[(4)] = cljs.core.cons((12),(state_45652[(4)])));

return statearr_45669;
})();
var inst_45641 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_45633);
var state_45652__$1 = state_45652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45652__$1,(13),inst_45641);
} else {
if((state_val_45653 === (5))){
var _ = (function (){var statearr_45670 = state_45652;
(statearr_45670[(4)] = cljs.core.rest((state_45652[(4)])));

return statearr_45670;
})();
var state_45652__$1 = state_45652;
var ex45667 = (state_45652__$1[(2)]);
var statearr_45671_45692 = state_45652__$1;
(statearr_45671_45692[(5)] = ex45667);


if((ex45667 instanceof Error)){
var statearr_45672_45693 = state_45652__$1;
(statearr_45672_45693[(1)] = (4));

(statearr_45672_45693[(5)] = null);

} else {
throw ex45667;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (10))){
var inst_45647 = (state_45652[(2)]);
var _ = (function (){var statearr_45673 = state_45652;
(statearr_45673[(4)] = cljs.core.rest((state_45652[(4)])));

return statearr_45673;
})();
var state_45652__$1 = state_45652;
var statearr_45674_45694 = state_45652__$1;
(statearr_45674_45694[(2)] = inst_45647);

(statearr_45674_45694[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45653 === (8))){
var inst_45629 = (state_45652[(7)]);
var inst_45629__$1 = (state_45652[(2)]);
var inst_45630 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_45629__$1,endSubject);
var inst_45631 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_45632 = ["?var1",inst_45630];
var inst_45633 = cljs.core.PersistentHashMap.fromArrays(inst_45631,inst_45632);
var state_45652__$1 = (function (){var statearr_45675 = state_45652;
(statearr_45675[(7)] = inst_45629__$1);

(statearr_45675[(8)] = inst_45633);

return statearr_45675;
})();
var statearr_45676_45695 = state_45652__$1;
(statearr_45676_45695[(2)] = null);

(statearr_45676_45695[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto____0 = (function (){
var statearr_45677 = [null,null,null,null,null,null,null,null,null];
(statearr_45677[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto__);

(statearr_45677[(1)] = (1));

return statearr_45677;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto____1 = (function (state_45652){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_45652);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e45678){var ex__14781__auto__ = e45678;
var statearr_45679_45696 = state_45652;
(statearr_45679_45696[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_45652[(4)]))){
var statearr_45680_45697 = state_45652;
(statearr_45680_45697[(1)] = cljs.core.first((state_45652[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__45698 = state_45652;
state_45652 = G__45698;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto__ = function(state_45652){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto____1.call(this,state_45652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_45681 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_45681[(6)] = c__14852__auto__);

return statearr_45681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e45699){var e = e45699;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e45700){var e = e45700;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e45701){var e = e45701;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e45702){var e = e45702;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45705 = arguments.length;
var i__4830__auto___45706 = (0);
while(true){
if((i__4830__auto___45706 < len__4829__auto___45705)){
args__4835__auto__.push((arguments[i__4830__auto___45706]));

var G__45707 = (i__4830__auto___45706 + (1));
i__4830__auto___45706 = G__45707;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e45704){var e = e45704;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq45703){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45703));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45710 = arguments.length;
var i__4830__auto___45711 = (0);
while(true){
if((i__4830__auto___45711 < len__4829__auto___45710)){
args__4835__auto__.push((arguments[i__4830__auto___45711]));

var G__45712 = (i__4830__auto___45711 + (1));
i__4830__auto___45711 = G__45712;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e45709){var e = e45709;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq45708){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45708));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45715 = arguments.length;
var i__4830__auto___45716 = (0);
while(true){
if((i__4830__auto___45716 < len__4829__auto___45715)){
args__4835__auto__.push((arguments[i__4830__auto___45716]));

var G__45717 = (i__4830__auto___45716 + (1));
i__4830__auto___45716 = G__45717;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4223__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e45714){var e = e45714;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq45713){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45713));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45720 = arguments.length;
var i__4830__auto___45721 = (0);
while(true){
if((i__4830__auto___45721 < len__4829__auto___45720)){
args__4835__auto__.push((arguments[i__4830__auto___45721]));

var G__45722 = (i__4830__auto___45721 + (1));
i__4830__auto___45721 = G__45722;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e45719){var e = e45719;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq45718){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45718));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e45723){var e = e45723;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e45724){var e = e45724;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e45725){var e = e45725;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e45726){var e = e45726;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e45727){var e = e45727;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__45733 = path;
var vec__45734 = G__45733;
var seq__45735 = cljs.core.seq(vec__45734);
var first__45736 = cljs.core.first(seq__45735);
var seq__45735__$1 = cljs.core.next(seq__45735);
var pred = first__45736;
var r = seq__45735__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__45733__$1 = G__45733;
var subjects__$1 = subjects;
while(true){
var vec__45740 = G__45733__$1;
var seq__45741 = cljs.core.seq(vec__45740);
var first__45742 = cljs.core.first(seq__45741);
var seq__45741__$1 = cljs.core.next(seq__45741);
var pred__$1 = first__45742;
var r__$1 = seq__45741__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__45733__$1,subjects__$1,vec__45740,seq__45741,first__45742,seq__45741__$1,pred__$1,r__$1,subjects__$2,G__45733,vec__45734,seq__45735,first__45736,seq__45735__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__45733__$1,subjects__$1,vec__45740,seq__45741,first__45742,seq__45741__$1,pred__$1,r__$1,subjects__$2,G__45733,vec__45734,seq__45735,first__45736,seq__45735__$1,pred,r,subjects){
return (function (p1__45728_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__45728_SHARP_,pred__$1);
});})(G__45733__$1,subjects__$1,vec__45740,seq__45741,first__45742,seq__45741__$1,pred__$1,r__$1,subjects__$2,G__45733,vec__45734,seq__45735,first__45736,seq__45735__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__45733__$1,subjects__$1,vec__45740,seq__45741,first__45742,seq__45741__$1,pred__$1,r__$1,subjects__$2,G__45733,vec__45734,seq__45735,first__45736,seq__45735__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4221__auto__ = r__$1;
if(and__4221__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4221__auto__;
}
})())){
var G__45743 = r__$1;
var G__45744 = next_subjects;
G__45733__$1 = G__45743;
subjects__$1 = G__45744;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e45729){var e = e45729;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e45745){var e = e45745;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e45746){var e = e45746;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45749 = arguments.length;
var i__4830__auto___45750 = (0);
while(true){
if((i__4830__auto___45750 < len__4829__auto___45749)){
args__4835__auto__.push((arguments[i__4830__auto___45750]));

var G__45751 = (i__4830__auto___45750 + (1));
i__4830__auto___45750 = G__45751;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e45748){var e = e45748;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq45747){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45747));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e45752){var e = e45752;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___45755 = arguments.length;
var i__4830__auto___45756 = (0);
while(true){
if((i__4830__auto___45756 < len__4829__auto___45755)){
args__4835__auto__.push((arguments[i__4830__auto___45756]));

var G__45757 = (i__4830__auto___45756 + (1));
i__4830__auto___45756 = G__45757;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e45754){var e = e45754;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq45753){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45753));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e45758){var e = e45758;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_45813){
var state_val_45814 = (state_45813[(1)]);
if((state_val_45814 === (7))){
var inst_45760 = (state_45813[(2)]);
var state_45813__$1 = state_45813;
var statearr_45815_45848 = state_45813__$1;
(statearr_45815_45848[(2)] = inst_45760);

(statearr_45815_45848[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (1))){
var state_45813__$1 = state_45813;
var statearr_45816_45849 = state_45813__$1;
(statearr_45816_45849[(2)] = null);

(statearr_45816_45849[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (4))){
var inst_45759 = (state_45813[(2)]);
var state_45813__$1 = (function (){var statearr_45817 = state_45813;
(statearr_45817[(7)] = inst_45759);

return statearr_45817;
})();
var statearr_45818_45850 = state_45813__$1;
(statearr_45818_45850[(2)] = null);

(statearr_45818_45850[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (15))){
var inst_45797 = (state_45813[(8)]);
var inst_45801 = inst_45797.o;
var state_45813__$1 = state_45813;
var statearr_45819_45851 = state_45813__$1;
(statearr_45819_45851[(2)] = inst_45801);

(statearr_45819_45851[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (13))){
var inst_45797 = (state_45813[(8)]);
var inst_45793 = (state_45813[(2)]);
var inst_45794 = fluree.db.util.async.throw_err(inst_45793);
var inst_45795 = fluree.db.dbfunctions.internal.count(inst_45794);
var inst_45797__$1 = cljs.core.first(inst_45794);
var inst_45798 = (inst_45797__$1 == null);
var state_45813__$1 = (function (){var statearr_45820 = state_45813;
(statearr_45820[(8)] = inst_45797__$1);

(statearr_45820[(9)] = inst_45795);

return statearr_45820;
})();
if(cljs.core.truth_(inst_45798)){
var statearr_45821_45852 = state_45813__$1;
(statearr_45821_45852[(1)] = (14));

} else {
var statearr_45822_45853 = state_45813__$1;
(statearr_45822_45853[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (6))){
var inst_45769 = (state_45813[(2)]);
var state_45813__$1 = state_45813;
var statearr_45823_45854 = state_45813__$1;
(statearr_45823_45854[(2)] = inst_45769);

(statearr_45823_45854[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (3))){
var inst_45811 = (state_45813[(2)]);
var state_45813__$1 = state_45813;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45813__$1,inst_45811);
} else {
if((state_val_45814 === (12))){
var inst_45808 = (state_45813[(2)]);
var _ = (function (){var statearr_45824 = state_45813;
(statearr_45824[(4)] = cljs.core.rest((state_45813[(4)])));

return statearr_45824;
})();
var state_45813__$1 = state_45813;
var statearr_45825_45855 = state_45813__$1;
(statearr_45825_45855[(2)] = inst_45808);

(statearr_45825_45855[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (2))){
var _ = (function (){var statearr_45827 = state_45813;
(statearr_45827[(4)] = cljs.core.cons((9),(state_45813[(4)])));

return statearr_45827;
})();
var inst_45775 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45776 = typeof inst_45775 === 'string';
var state_45813__$1 = state_45813;
if(cljs.core.truth_(inst_45776)){
var statearr_45828_45856 = state_45813__$1;
(statearr_45828_45856[(1)] = (10));

} else {
var statearr_45829_45857 = state_45813__$1;
(statearr_45829_45857[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (11))){
var inst_45782 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45783 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_45782);
var inst_45784 = fluree.db.dbfunctions.internal.inc(inst_45783);
var inst_45785 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45782,cljs.core.cst$kw$t,inst_45784);
var inst_45786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45787 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45788 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45789 = [inst_45787,inst_45788];
var inst_45790 = (new cljs.core.PersistentVector(null,2,(5),inst_45786,inst_45789,null));
var inst_45791 = fluree.db.dbproto._search(inst_45785,inst_45790);
var state_45813__$1 = state_45813;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45813__$1,(13),inst_45791);
} else {
if((state_val_45814 === (9))){
var _ = (function (){var statearr_45830 = state_45813;
(statearr_45830[(4)] = cljs.core.rest((state_45813[(4)])));

return statearr_45830;
})();
var state_45813__$1 = state_45813;
var ex45826 = (state_45813__$1[(2)]);
var statearr_45831_45858 = state_45813__$1;
(statearr_45831_45858[(5)] = ex45826);


var statearr_45832_45859 = state_45813__$1;
(statearr_45832_45859[(1)] = (4));

(statearr_45832_45859[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (5))){
var inst_45759 = (state_45813[(7)]);
var _ = (function (){var statearr_45833 = state_45813;
(statearr_45833[(4)] = cljs.core.cons((8),(state_45813[(4)])));

return statearr_45833;
})();
var inst_45766 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45759,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_45834 = state_45813;
(statearr_45834[(4)] = cljs.core.rest((state_45813[(4)])));

return statearr_45834;
})();
var state_45813__$1 = state_45813;
var statearr_45835_45860 = state_45813__$1;
(statearr_45835_45860[(2)] = inst_45766);

(statearr_45835_45860[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (14))){
var state_45813__$1 = state_45813;
var statearr_45836_45861 = state_45813__$1;
(statearr_45836_45861[(2)] = null);

(statearr_45836_45861[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (16))){
var inst_45795 = (state_45813[(9)]);
var inst_45803 = (state_45813[(2)]);
var inst_45804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45805 = [inst_45803,inst_45795];
var inst_45806 = (new cljs.core.PersistentVector(null,2,(5),inst_45804,inst_45805,null));
var state_45813__$1 = state_45813;
var statearr_45838_45862 = state_45813__$1;
(statearr_45838_45862[(2)] = inst_45806);

(statearr_45838_45862[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (10))){
var inst_45778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45779 = [null,(0)];
var inst_45780 = (new cljs.core.PersistentVector(null,2,(5),inst_45778,inst_45779,null));
var state_45813__$1 = state_45813;
var statearr_45839_45863 = state_45813__$1;
(statearr_45839_45863[(2)] = inst_45780);

(statearr_45839_45863[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45814 === (8))){
var _ = (function (){var statearr_45840 = state_45813;
(statearr_45840[(4)] = cljs.core.rest((state_45813[(4)])));

return statearr_45840;
})();
var state_45813__$1 = state_45813;
var ex45837 = (state_45813__$1[(2)]);
var statearr_45841_45864 = state_45813__$1;
(statearr_45841_45864[(5)] = ex45837);


var statearr_45842_45865 = state_45813__$1;
(statearr_45842_45865[(1)] = (7));

(statearr_45842_45865[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto____0 = (function (){
var statearr_45843 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45843[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto__);

(statearr_45843[(1)] = (1));

return statearr_45843;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto____1 = (function (state_45813){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_45813);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e45844){var ex__14781__auto__ = e45844;
var statearr_45845_45866 = state_45813;
(statearr_45845_45866[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_45813[(4)]))){
var statearr_45846_45867 = state_45813;
(statearr_45846_45867[(1)] = cljs.core.first((state_45813[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__45868 = state_45813;
state_45813 = G__45868;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto__ = function(state_45813){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto____1.call(this,state_45813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_45847 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_45847[(6)] = c__14852__auto__);

return statearr_45847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_45920){
var state_val_45921 = (state_45920[(1)]);
if((state_val_45921 === (7))){
var inst_45870 = (state_45920[(2)]);
var state_45920__$1 = state_45920;
var statearr_45922_45951 = state_45920__$1;
(statearr_45922_45951[(2)] = inst_45870);

(statearr_45922_45951[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (1))){
var state_45920__$1 = state_45920;
var statearr_45923_45952 = state_45920__$1;
(statearr_45923_45952[(2)] = null);

(statearr_45923_45952[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (4))){
var inst_45869 = (state_45920[(2)]);
var state_45920__$1 = (function (){var statearr_45924 = state_45920;
(statearr_45924[(7)] = inst_45869);

return statearr_45924;
})();
var statearr_45925_45953 = state_45920__$1;
(statearr_45925_45953[(2)] = null);

(statearr_45925_45953[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (13))){
var inst_45915 = (state_45920[(2)]);
var _ = (function (){var statearr_45926 = state_45920;
(statearr_45926[(4)] = cljs.core.rest((state_45920[(4)])));

return statearr_45926;
})();
var state_45920__$1 = state_45920;
var statearr_45927_45954 = state_45920__$1;
(statearr_45927_45954[(2)] = inst_45915);

(statearr_45927_45954[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (6))){
var inst_45879 = (state_45920[(2)]);
var state_45920__$1 = state_45920;
var statearr_45928_45955 = state_45920__$1;
(statearr_45928_45955[(2)] = inst_45879);

(statearr_45928_45955[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (3))){
var inst_45918 = (state_45920[(2)]);
var state_45920__$1 = state_45920;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45920__$1,inst_45918);
} else {
if((state_val_45921 === (12))){
var inst_45902 = (state_45920[(8)]);
var inst_45911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45912 = [null,inst_45902];
var inst_45913 = (new cljs.core.PersistentVector(null,2,(5),inst_45911,inst_45912,null));
var state_45920__$1 = state_45920;
var statearr_45929_45956 = state_45920__$1;
(statearr_45929_45956[(2)] = inst_45913);

(statearr_45929_45956[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (2))){
var _ = (function (){var statearr_45931 = state_45920;
(statearr_45931[(4)] = cljs.core.cons((9),(state_45920[(4)])));

return statearr_45931;
})();
var inst_45888 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_45889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45891 = [null,pred_name,"?o"];
var inst_45892 = (new cljs.core.PersistentVector(null,3,(5),inst_45890,inst_45891,null));
var inst_45893 = [inst_45892];
var inst_45894 = (new cljs.core.PersistentVector(null,1,(5),inst_45889,inst_45893,null));
var inst_45895 = ["?o",inst_45894,opts];
var inst_45896 = cljs.core.PersistentHashMap.fromArrays(inst_45888,inst_45895);
var inst_45897 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_45896);
var state_45920__$1 = state_45920;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45920__$1,(10),inst_45897);
} else {
if((state_val_45921 === (11))){
var inst_45902 = (state_45920[(8)]);
var inst_45901 = (state_45920[(9)]);
var inst_45906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45907 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_45901);
var inst_45908 = [inst_45907,inst_45902];
var inst_45909 = (new cljs.core.PersistentVector(null,2,(5),inst_45906,inst_45908,null));
var state_45920__$1 = state_45920;
var statearr_45932_45957 = state_45920__$1;
(statearr_45932_45957[(2)] = inst_45909);

(statearr_45932_45957[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (9))){
var _ = (function (){var statearr_45933 = state_45920;
(statearr_45933[(4)] = cljs.core.rest((state_45920[(4)])));

return statearr_45933;
})();
var state_45920__$1 = state_45920;
var ex45930 = (state_45920__$1[(2)]);
var statearr_45934_45958 = state_45920__$1;
(statearr_45934_45958[(5)] = ex45930);


var statearr_45935_45959 = state_45920__$1;
(statearr_45935_45959[(1)] = (4));

(statearr_45935_45959[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (5))){
var inst_45869 = (state_45920[(7)]);
var _ = (function (){var statearr_45937 = state_45920;
(statearr_45937[(4)] = cljs.core.cons((8),(state_45920[(4)])));

return statearr_45937;
})();
var inst_45876 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45869,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_45938 = state_45920;
(statearr_45938[(4)] = cljs.core.rest((state_45920[(4)])));

return statearr_45938;
})();
var state_45920__$1 = state_45920;
var statearr_45939_45960 = state_45920__$1;
(statearr_45939_45960[(2)] = inst_45876);

(statearr_45939_45960[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (10))){
var inst_45901 = (state_45920[(9)]);
var inst_45899 = (state_45920[(2)]);
var inst_45900 = fluree.db.util.async.throw_err(inst_45899);
var inst_45901__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45900,(0),null);
var inst_45902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45900,(1),null);
var inst_45903 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_45901__$1);
var inst_45904 = cljs.core.not(inst_45903);
var state_45920__$1 = (function (){var statearr_45940 = state_45920;
(statearr_45940[(8)] = inst_45902);

(statearr_45940[(9)] = inst_45901__$1);

return statearr_45940;
})();
if(inst_45904){
var statearr_45941_45961 = state_45920__$1;
(statearr_45941_45961[(1)] = (11));

} else {
var statearr_45942_45962 = state_45920__$1;
(statearr_45942_45962[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45921 === (8))){
var _ = (function (){var statearr_45943 = state_45920;
(statearr_45943[(4)] = cljs.core.rest((state_45920[(4)])));

return statearr_45943;
})();
var state_45920__$1 = state_45920;
var ex45936 = (state_45920__$1[(2)]);
var statearr_45944_45963 = state_45920__$1;
(statearr_45944_45963[(5)] = ex45936);


var statearr_45945_45964 = state_45920__$1;
(statearr_45945_45964[(1)] = (7));

(statearr_45945_45964[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto____0 = (function (){
var statearr_45946 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45946[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto__);

(statearr_45946[(1)] = (1));

return statearr_45946;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto____1 = (function (state_45920){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_45920);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e45947){var ex__14781__auto__ = e45947;
var statearr_45948_45965 = state_45920;
(statearr_45948_45965[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_45920[(4)]))){
var statearr_45949_45966 = state_45920;
(statearr_45949_45966[(1)] = cljs.core.first((state_45920[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__45967 = state_45920;
state_45920 = G__45967;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto__ = function(state_45920){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto____1.call(this,state_45920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_45950 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_45950[(6)] = c__14852__auto__);

return statearr_45950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4221__auto__ = typeof email === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4221__auto__;
}
})());
}catch (e45968){var e = e45968;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__45970 = arguments.length;
switch (G__45970) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_46040){
var state_val_46041 = (state_46040[(1)]);
if((state_val_46041 === (7))){
var inst_45972 = (state_46040[(2)]);
var state_46040__$1 = state_46040;
var statearr_46042_46086 = state_46040__$1;
(statearr_46042_46086[(2)] = inst_45972);

(statearr_46042_46086[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (20))){
var inst_46016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46017 = ["*"];
var inst_46018 = (new cljs.core.PersistentVector(null,1,(5),inst_46016,inst_46017,null));
var state_46040__$1 = state_46040;
var statearr_46043_46087 = state_46040__$1;
(statearr_46043_46087[(2)] = inst_46018);

(statearr_46043_46087[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (1))){
var state_46040__$1 = state_46040;
var statearr_46044_46088 = state_46040__$1;
(statearr_46044_46088[(2)] = null);

(statearr_46044_46088[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (4))){
var inst_45971 = (state_46040[(2)]);
var state_46040__$1 = (function (){var statearr_46045 = state_46040;
(statearr_46045[(7)] = inst_45971);

return statearr_46045;
})();
var statearr_46046_46089 = state_46040__$1;
(statearr_46046_46089[(2)] = null);

(statearr_46046_46089[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (15))){
var inst_46035 = (state_46040[(2)]);
var _ = (function (){var statearr_46047 = state_46040;
(statearr_46047[(4)] = cljs.core.rest((state_46040[(4)])));

return statearr_46047;
})();
var state_46040__$1 = state_46040;
var statearr_46048_46090 = state_46040__$1;
(statearr_46048_46090[(2)] = inst_46035);

(statearr_46048_46090[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (21))){
var inst_46006 = (state_46040[(8)]);
var inst_45999 = (state_46040[(9)]);
var inst_46020 = (state_46040[(2)]);
var inst_46021 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_46022 = cljs.core.PersistentHashMap.EMPTY;
var inst_46023 = [inst_46020,inst_46006,inst_46022];
var inst_46024 = cljs.core.PersistentHashMap.fromArrays(inst_46021,inst_46023);
var inst_46025 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45999,inst_46024);
var state_46040__$1 = state_46040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46040__$1,(22),inst_46025);
} else {
if((state_val_46041 === (13))){
var inst_45994 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_46040__$1 = state_46040;
var statearr_46049_46091 = state_46040__$1;
(statearr_46049_46091[(2)] = inst_45994);

(statearr_46049_46091[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (22))){
var inst_46027 = (state_46040[(2)]);
var inst_46028 = fluree.db.util.async.throw_err(inst_46027);
var inst_46029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46028,(0),null);
var inst_46030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46028,(1),null);
var inst_46031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46032 = [inst_46029,inst_46030];
var inst_46033 = (new cljs.core.PersistentVector(null,2,(5),inst_46031,inst_46032,null));
var state_46040__$1 = state_46040;
var statearr_46050_46092 = state_46040__$1;
(statearr_46050_46092[(2)] = inst_46033);

(statearr_46050_46092[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (6))){
var inst_45981 = (state_46040[(2)]);
var state_46040__$1 = state_46040;
var statearr_46051_46093 = state_46040__$1;
(statearr_46051_46093[(2)] = inst_45981);

(statearr_46051_46093[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (17))){
var inst_46003 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46004 = fluree.db.dbfunctions.internal.get(inst_46003,cljs.core.cst$kw$_id);
var state_46040__$1 = state_46040;
var statearr_46052_46094 = state_46040__$1;
(statearr_46052_46094[(2)] = inst_46004);

(statearr_46052_46094[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (3))){
var inst_46038 = (state_46040[(2)]);
var state_46040__$1 = state_46040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46040__$1,inst_46038);
} else {
if((state_val_46041 === (12))){
var inst_45992 = (state_46040[(2)]);
var state_46040__$1 = state_46040;
if(cljs.core.truth_(inst_45992)){
var statearr_46053_46095 = state_46040__$1;
(statearr_46053_46095[(1)] = (13));

} else {
var statearr_46054_46096 = state_46040__$1;
(statearr_46054_46096[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (2))){
var inst_45987 = (state_46040[(10)]);
var _ = (function (){var statearr_46055 = state_46040;
(statearr_46055[(4)] = cljs.core.cons((9),(state_46040[(4)])));

return statearr_46055;
})();
var inst_45987__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_46040__$1 = (function (){var statearr_46056 = state_46040;
(statearr_46056[(10)] = inst_45987__$1);

return statearr_46056;
})();
if(cljs.core.truth_(inst_45987__$1)){
var statearr_46057_46097 = state_46040__$1;
(statearr_46057_46097[(1)] = (10));

} else {
var statearr_46058_46098 = state_46040__$1;
(statearr_46058_46098[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (19))){
var inst_46008 = cljs.core.PersistentVector.EMPTY;
var inst_46009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46010 = ["*"];
var inst_46011 = (new cljs.core.PersistentVector(null,1,(5),inst_46009,inst_46010,null));
var inst_46012 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_46013 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_46011,inst_46012);
var inst_46014 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_46008,inst_46013);
var state_46040__$1 = state_46040;
var statearr_46060_46099 = state_46040__$1;
(statearr_46060_46099[(2)] = inst_46014);

(statearr_46060_46099[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (11))){
var inst_45987 = (state_46040[(10)]);
var state_46040__$1 = state_46040;
var statearr_46061_46100 = state_46040__$1;
(statearr_46061_46100[(2)] = inst_45987);

(statearr_46061_46100[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (9))){
var _ = (function (){var statearr_46062 = state_46040;
(statearr_46062[(4)] = cljs.core.rest((state_46040[(4)])));

return statearr_46062;
})();
var state_46040__$1 = state_46040;
var ex46059 = (state_46040__$1[(2)]);
var statearr_46063_46101 = state_46040__$1;
(statearr_46063_46101[(5)] = ex46059);


var statearr_46064_46102 = state_46040__$1;
(statearr_46064_46102[(1)] = (4));

(statearr_46064_46102[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (5))){
var inst_45971 = (state_46040[(7)]);
var _ = (function (){var statearr_46065 = state_46040;
(statearr_46065[(4)] = cljs.core.cons((8),(state_46040[(4)])));

return statearr_46065;
})();
var inst_45978 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45971,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_46066 = state_46040;
(statearr_46066[(4)] = cljs.core.rest((state_46040[(4)])));

return statearr_46066;
})();
var state_46040__$1 = state_46040;
var statearr_46067_46103 = state_46040__$1;
(statearr_46067_46103[(2)] = inst_45978);

(statearr_46067_46103[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (14))){
var inst_46000 = (state_46040[(11)]);
var inst_45999 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46000__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_46040__$1 = (function (){var statearr_46068 = state_46040;
(statearr_46068[(11)] = inst_46000__$1);

(statearr_46068[(9)] = inst_45999);

return statearr_46068;
})();
if(cljs.core.truth_(inst_46000__$1)){
var statearr_46069_46104 = state_46040__$1;
(statearr_46069_46104[(1)] = (16));

} else {
var statearr_46070_46105 = state_46040__$1;
(statearr_46070_46105[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (16))){
var inst_46000 = (state_46040[(11)]);
var state_46040__$1 = state_46040;
var statearr_46071_46106 = state_46040__$1;
(statearr_46071_46106[(2)] = inst_46000);

(statearr_46071_46106[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (10))){
var inst_45989 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_46040__$1 = state_46040;
var statearr_46073_46107 = state_46040__$1;
(statearr_46073_46107[(2)] = inst_45989);

(statearr_46073_46107[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (18))){
var inst_46006 = (state_46040[(2)]);
var state_46040__$1 = (function (){var statearr_46074 = state_46040;
(statearr_46074[(8)] = inst_46006);

return statearr_46074;
})();
if(cljs.core.truth_(additional_params)){
var statearr_46075_46108 = state_46040__$1;
(statearr_46075_46108[(1)] = (19));

} else {
var statearr_46076_46109 = state_46040__$1;
(statearr_46076_46109[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46041 === (8))){
var _ = (function (){var statearr_46077 = state_46040;
(statearr_46077[(4)] = cljs.core.rest((state_46040[(4)])));

return statearr_46077;
})();
var state_46040__$1 = state_46040;
var ex46072 = (state_46040__$1[(2)]);
var statearr_46078_46110 = state_46040__$1;
(statearr_46078_46110[(5)] = ex46072);


var statearr_46079_46111 = state_46040__$1;
(statearr_46079_46111[(1)] = (7));

(statearr_46079_46111[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__14778__auto____0 = (function (){
var statearr_46080 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46080[(0)] = fluree$db$dbfunctions$internal$state_machine__14778__auto__);

(statearr_46080[(1)] = (1));

return statearr_46080;
});
var fluree$db$dbfunctions$internal$state_machine__14778__auto____1 = (function (state_46040){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_46040);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e46081){var ex__14781__auto__ = e46081;
var statearr_46082_46112 = state_46040;
(statearr_46082_46112[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_46040[(4)]))){
var statearr_46083_46113 = state_46040;
(statearr_46083_46113[(1)] = cljs.core.first((state_46040[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__46114 = state_46040;
state_46040 = G__46114;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__14778__auto__ = function(state_46040){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__14778__auto____1.call(this,state_46040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_46084 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_46084[(6)] = c__14852__auto__);

return statearr_46084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__46116 = arguments.length;
switch (G__46116) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_46160){
var state_val_46161 = (state_46160[(1)]);
if((state_val_46161 === (7))){
var inst_46138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46139 = ["*"];
var inst_46140 = (new cljs.core.PersistentVector(null,1,(5),inst_46138,inst_46139,null));
var state_46160__$1 = state_46160;
var statearr_46162_46182 = state_46160__$1;
(statearr_46162_46182[(2)] = inst_46140);

(statearr_46162_46182[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46161 === (1))){
var state_46160__$1 = state_46160;
var statearr_46163_46183 = state_46160__$1;
(statearr_46163_46183[(2)] = null);

(statearr_46163_46183[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46161 === (4))){
var inst_46117 = (state_46160[(2)]);
var inst_46118 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_46117,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_46160__$1 = state_46160;
var statearr_46164_46184 = state_46160__$1;
(statearr_46164_46184[(2)] = inst_46118);

(statearr_46164_46184[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46161 === (6))){
var inst_46130 = cljs.core.PersistentVector.EMPTY;
var inst_46131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46132 = ["*"];
var inst_46133 = (new cljs.core.PersistentVector(null,1,(5),inst_46131,inst_46132,null));
var inst_46134 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_46135 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_46133,inst_46134);
var inst_46136 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_46130,inst_46135);
var state_46160__$1 = state_46160;
var statearr_46165_46185 = state_46160__$1;
(statearr_46165_46185[(2)] = inst_46136);

(statearr_46165_46185[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46161 === (3))){
var inst_46158 = (state_46160[(2)]);
var state_46160__$1 = state_46160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46160__$1,inst_46158);
} else {
if((state_val_46161 === (2))){
var _ = (function (){var statearr_46167 = state_46160;
(statearr_46167[(4)] = cljs.core.cons((5),(state_46160[(4)])));

return statearr_46167;
})();
var inst_46127 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46128 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_46160__$1 = (function (){var statearr_46168 = state_46160;
(statearr_46168[(7)] = inst_46128);

(statearr_46168[(8)] = inst_46127);

return statearr_46168;
})();
if(cljs.core.truth_(additional_params)){
var statearr_46169_46186 = state_46160__$1;
(statearr_46169_46186[(1)] = (6));

} else {
var statearr_46170_46187 = state_46160__$1;
(statearr_46170_46187[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46161 === (9))){
var inst_46149 = (state_46160[(2)]);
var inst_46150 = fluree.db.util.async.throw_err(inst_46149);
var inst_46151 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46150,(0),null);
var inst_46152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46150,(1),null);
var inst_46153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46154 = [inst_46151,inst_46152];
var inst_46155 = (new cljs.core.PersistentVector(null,2,(5),inst_46153,inst_46154,null));
var _ = (function (){var statearr_46171 = state_46160;
(statearr_46171[(4)] = cljs.core.rest((state_46160[(4)])));

return statearr_46171;
})();
var state_46160__$1 = state_46160;
var statearr_46172_46188 = state_46160__$1;
(statearr_46172_46188[(2)] = inst_46155);

(statearr_46172_46188[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46161 === (5))){
var _ = (function (){var statearr_46173 = state_46160;
(statearr_46173[(4)] = cljs.core.rest((state_46160[(4)])));

return statearr_46173;
})();
var state_46160__$1 = state_46160;
var ex46166 = (state_46160__$1[(2)]);
var statearr_46174_46189 = state_46160__$1;
(statearr_46174_46189[(5)] = ex46166);


var statearr_46175_46190 = state_46160__$1;
(statearr_46175_46190[(1)] = (4));

(statearr_46175_46190[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_46161 === (8))){
var inst_46128 = (state_46160[(7)]);
var inst_46127 = (state_46160[(8)]);
var inst_46142 = (state_46160[(2)]);
var inst_46143 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_46144 = cljs.core.PersistentHashMap.EMPTY;
var inst_46145 = [inst_46142,inst_46128,inst_46144];
var inst_46146 = cljs.core.PersistentHashMap.fromArrays(inst_46143,inst_46145);
var inst_46147 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_46127,inst_46146);
var state_46160__$1 = state_46160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46160__$1,(9),inst_46147);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__14778__auto____0 = (function (){
var statearr_46176 = [null,null,null,null,null,null,null,null,null];
(statearr_46176[(0)] = fluree$db$dbfunctions$internal$state_machine__14778__auto__);

(statearr_46176[(1)] = (1));

return statearr_46176;
});
var fluree$db$dbfunctions$internal$state_machine__14778__auto____1 = (function (state_46160){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_46160);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e46177){var ex__14781__auto__ = e46177;
var statearr_46178_46191 = state_46160;
(statearr_46178_46191[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_46160[(4)]))){
var statearr_46179_46192 = state_46160;
(statearr_46179_46192[(1)] = cljs.core.first((state_46160[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__46193 = state_46160;
state_46160 = G__46193;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__14778__auto__ = function(state_46160){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__14778__auto____1.call(this,state_46160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_46180 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_46180[(6)] = c__14852__auto__);

return statearr_46180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_46237){
var state_val_46238 = (state_46237[(1)]);
if((state_val_46238 === (1))){
var state_46237__$1 = state_46237;
var statearr_46239_46253 = state_46237__$1;
(statearr_46239_46253[(2)] = null);

(statearr_46239_46253[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46238 === (2))){
var _ = (function (){var statearr_46240 = state_46237;
(statearr_46240[(4)] = cljs.core.cons((5),(state_46237[(4)])));

return statearr_46240;
})();
var inst_46204 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_46205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46206 = ["_user/_auth"];
var inst_46207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46208 = ["*"];
var inst_46209 = (new cljs.core.PersistentVector(null,1,(5),inst_46207,inst_46208,null));
var inst_46210 = [inst_46209];
var inst_46211 = cljs.core.PersistentHashMap.fromArrays(inst_46206,inst_46210);
var inst_46212 = [inst_46211];
var inst_46213 = (new cljs.core.PersistentVector(null,1,(5),inst_46205,inst_46212,null));
var inst_46214 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46215 = cljs.core.PersistentHashMap.EMPTY;
var inst_46216 = [inst_46213,inst_46214,inst_46215];
var inst_46217 = cljs.core.PersistentHashMap.fromArrays(inst_46204,inst_46216);
var inst_46218 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46219 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_46218,inst_46217);
var state_46237__$1 = state_46237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46237__$1,(6),inst_46219);
} else {
if((state_val_46238 === (3))){
var inst_46235 = (state_46237[(2)]);
var state_46237__$1 = state_46237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46237__$1,inst_46235);
} else {
if((state_val_46238 === (4))){
var inst_46194 = (state_46237[(2)]);
var inst_46195 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_46194,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_46237__$1 = state_46237;
var statearr_46242_46254 = state_46237__$1;
(statearr_46242_46254[(2)] = inst_46195);

(statearr_46242_46254[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46238 === (5))){
var _ = (function (){var statearr_46243 = state_46237;
(statearr_46243[(4)] = cljs.core.rest((state_46237[(4)])));

return statearr_46243;
})();
var state_46237__$1 = state_46237;
var ex46241 = (state_46237__$1[(2)]);
var statearr_46244_46255 = state_46237__$1;
(statearr_46244_46255[(5)] = ex46241);


var statearr_46245_46256 = state_46237__$1;
(statearr_46245_46256[(1)] = (4));

(statearr_46245_46256[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_46238 === (6))){
var inst_46221 = (state_46237[(2)]);
var inst_46222 = fluree.db.util.async.throw_err(inst_46221);
var inst_46223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46222,(0),null);
var inst_46224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46222,(1),null);
var inst_46225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46226 = ["_user/_auth","_id"];
var inst_46227 = (new cljs.core.PersistentVector(null,2,(5),inst_46225,inst_46226,null));
var inst_46228 = fluree.db.dbfunctions.internal.get_in(inst_46223,inst_46227);
var inst_46229 = cljs.core.first(inst_46228);
var inst_46230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46231 = [inst_46229,inst_46224];
var inst_46232 = (new cljs.core.PersistentVector(null,2,(5),inst_46230,inst_46231,null));
var _ = (function (){var statearr_46246 = state_46237;
(statearr_46246[(4)] = cljs.core.rest((state_46237[(4)])));

return statearr_46246;
})();
var state_46237__$1 = state_46237;
var statearr_46247_46257 = state_46237__$1;
(statearr_46247_46257[(2)] = inst_46232);

(statearr_46247_46257[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto____0 = (function (){
var statearr_46248 = [null,null,null,null,null,null,null];
(statearr_46248[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto__);

(statearr_46248[(1)] = (1));

return statearr_46248;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto____1 = (function (state_46237){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_46237);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e46249){var ex__14781__auto__ = e46249;
var statearr_46250_46258 = state_46237;
(statearr_46250_46258[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_46237[(4)]))){
var statearr_46251_46259 = state_46237;
(statearr_46251_46259[(1)] = cljs.core.first((state_46237[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__46260 = state_46237;
state_46237 = G__46260;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto__ = function(state_46237){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto____1.call(this,state_46237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_46252 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_46252[(6)] = c__14852__auto__);

return statearr_46252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_46277){
var state_val_46278 = (state_46277[(1)]);
if((state_val_46278 === (1))){
var state_46277__$1 = state_46277;
var statearr_46279_46293 = state_46277__$1;
(statearr_46279_46293[(2)] = null);

(statearr_46279_46293[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46278 === (2))){
var _ = (function (){var statearr_46280 = state_46277;
(statearr_46280[(4)] = cljs.core.cons((5),(state_46277[(4)])));

return statearr_46280;
})();
var inst_46267 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46268 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46269 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_46268,inst_46267);
var state_46277__$1 = state_46277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46277__$1,(6),inst_46269);
} else {
if((state_val_46278 === (3))){
var inst_46275 = (state_46277[(2)]);
var state_46277__$1 = state_46277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46277__$1,inst_46275);
} else {
if((state_val_46278 === (4))){
var inst_46261 = (state_46277[(2)]);
var state_46277__$1 = state_46277;
var statearr_46282_46294 = state_46277__$1;
(statearr_46282_46294[(2)] = inst_46261);

(statearr_46282_46294[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46278 === (5))){
var _ = (function (){var statearr_46283 = state_46277;
(statearr_46283[(4)] = cljs.core.rest((state_46277[(4)])));

return statearr_46283;
})();
var state_46277__$1 = state_46277;
var ex46281 = (state_46277__$1[(2)]);
var statearr_46284_46295 = state_46277__$1;
(statearr_46284_46295[(5)] = ex46281);


if((ex46281 instanceof Error)){
var statearr_46285_46296 = state_46277__$1;
(statearr_46285_46296[(1)] = (4));

(statearr_46285_46296[(5)] = null);

} else {
throw ex46281;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46278 === (6))){
var inst_46271 = (state_46277[(2)]);
var inst_46272 = fluree.db.util.async.throw_err(inst_46271);
var _ = (function (){var statearr_46286 = state_46277;
(statearr_46286[(4)] = cljs.core.rest((state_46277[(4)])));

return statearr_46286;
})();
var state_46277__$1 = state_46277;
var statearr_46287_46297 = state_46277__$1;
(statearr_46287_46297[(2)] = inst_46272);

(statearr_46287_46297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto____0 = (function (){
var statearr_46288 = [null,null,null,null,null,null,null];
(statearr_46288[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto__);

(statearr_46288[(1)] = (1));

return statearr_46288;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto____1 = (function (state_46277){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_46277);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e46289){var ex__14781__auto__ = e46289;
var statearr_46290_46298 = state_46277;
(statearr_46290_46298[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_46277[(4)]))){
var statearr_46291_46299 = state_46277;
(statearr_46291_46299[(1)] = cljs.core.first((state_46277[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__46300 = state_46277;
state_46277 = G__46300;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto__ = function(state_46277){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto____1.call(this,state_46277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_46292 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_46292[(6)] = c__14852__auto__);

return statearr_46292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__46301_SHARP_){
return p1__46301_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46302_SHARP_){
return p1__46302_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e46303){var e = e46303;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__46304_SHARP_){
return p1__46304_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46305_SHARP_){
return p1__46305_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e46306){var e = e46306;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__46308 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__46308);
})() | (0));
return num;
}catch (e46307){var e = e46307;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_46388){
var state_val_46389 = (state_46388[(1)]);
if((state_val_46389 === (7))){
var inst_46327 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_46328 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_46329 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_46330 = cljs.core.PersistentHashMap.fromArrays(inst_46328,inst_46329);
var inst_46331 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_46327,inst_46330);
var inst_46332 = (function(){throw inst_46331})();
var state_46388__$1 = state_46388;
var statearr_46390_46425 = state_46388__$1;
(statearr_46390_46425[(2)] = inst_46332);

(statearr_46390_46425[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (1))){
var state_46388__$1 = state_46388;
var statearr_46391_46426 = state_46388__$1;
(statearr_46391_46426[(2)] = null);

(statearr_46391_46426[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (4))){
var inst_46309 = (state_46388[(2)]);
var state_46388__$1 = state_46388;
var statearr_46392_46427 = state_46388__$1;
(statearr_46392_46427[(2)] = inst_46309);

(statearr_46392_46427[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (15))){
var inst_46372 = (state_46388[(7)]);
var inst_46368 = (state_46388[(2)]);
var inst_46369 = fluree.db.util.async.throw_err(inst_46368);
var inst_46370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46369,(0),null);
var inst_46371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46369,(1),null);
var inst_46372__$1 = cljs.core.first(inst_46370);
var inst_46373 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46372__$1,compare_val);
var state_46388__$1 = (function (){var statearr_46393 = state_46388;
(statearr_46393[(8)] = inst_46371);

(statearr_46393[(7)] = inst_46372__$1);

return statearr_46393;
})();
if(inst_46373){
var statearr_46394_46428 = state_46388__$1;
(statearr_46394_46428[(1)] = (16));

} else {
var statearr_46395_46429 = state_46388__$1;
(statearr_46395_46429[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (13))){
var state_46388__$1 = state_46388;
var statearr_46396_46430 = state_46388__$1;
(statearr_46396_46430[(2)] = null);

(statearr_46396_46430[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (6))){
var state_46388__$1 = state_46388;
var statearr_46397_46431 = state_46388__$1;
(statearr_46397_46431[(2)] = null);

(statearr_46397_46431[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (17))){
var inst_46372 = (state_46388[(7)]);
var inst_46376 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46372)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_46377 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_46378 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_46379 = cljs.core.PersistentHashMap.fromArrays(inst_46377,inst_46378);
var inst_46380 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_46376,inst_46379);
var inst_46381 = (function(){throw inst_46380})();
var state_46388__$1 = state_46388;
var statearr_46398_46432 = state_46388__$1;
(statearr_46398_46432[(2)] = inst_46381);

(statearr_46398_46432[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (3))){
var inst_46386 = (state_46388[(2)]);
var state_46388__$1 = state_46388;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46388__$1,inst_46386);
} else {
if((state_val_46389 === (12))){
var inst_46324 = (state_46388[(9)]);
var inst_46347 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_46324], 0));
var inst_46348 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_46349 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_46350 = cljs.core.PersistentHashMap.fromArrays(inst_46348,inst_46349);
var inst_46351 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_46347,inst_46350);
var inst_46352 = (function(){throw inst_46351})();
var state_46388__$1 = state_46388;
var statearr_46399_46433 = state_46388__$1;
(statearr_46399_46433[(2)] = inst_46352);

(statearr_46399_46433[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (2))){
var inst_46321 = (state_46388[(10)]);
var inst_46323 = (state_46388[(11)]);
var inst_46322 = (state_46388[(12)]);
var _ = (function (){var statearr_46400 = state_46388;
(statearr_46400[(4)] = cljs.core.cons((5),(state_46388[(4)])));

return statearr_46400;
})();
var inst_46319 = _QMARK_ctx;
var inst_46320 = cljs.core.__destructure_map(inst_46319);
var inst_46321__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46320,cljs.core.cst$kw$sid);
var inst_46322__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46320,cljs.core.cst$kw$pid);
var inst_46323__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46320,cljs.core.cst$kw$db);
var inst_46324 = fluree.db.dbproto._p_prop(inst_46323__$1,cljs.core.cst$kw$name,inst_46322__$1);
var state_46388__$1 = (function (){var statearr_46401 = state_46388;
(statearr_46401[(10)] = inst_46321__$1);

(statearr_46401[(11)] = inst_46323__$1);

(statearr_46401[(9)] = inst_46324);

(statearr_46401[(12)] = inst_46322__$1);

return statearr_46401;
})();
if(cljs.core.truth_(inst_46321__$1)){
var statearr_46402_46434 = state_46388__$1;
(statearr_46402_46434[(1)] = (6));

} else {
var statearr_46403_46435 = state_46388__$1;
(statearr_46403_46435[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (11))){
var inst_46323 = (state_46388[(11)]);
var inst_46322 = (state_46388[(12)]);
var inst_46344 = (state_46388[(2)]);
var inst_46345 = fluree.db.dbproto._p_prop(inst_46323,cljs.core.cst$kw$multi,inst_46322);
var state_46388__$1 = (function (){var statearr_46405 = state_46388;
(statearr_46405[(13)] = inst_46344);

return statearr_46405;
})();
if(cljs.core.truth_(inst_46345)){
var statearr_46406_46436 = state_46388__$1;
(statearr_46406_46436[(1)] = (12));

} else {
var statearr_46407_46437 = state_46388__$1;
(statearr_46407_46437[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (9))){
var state_46388__$1 = state_46388;
var statearr_46408_46438 = state_46388__$1;
(statearr_46408_46438[(2)] = null);

(statearr_46408_46438[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (5))){
var _ = (function (){var statearr_46409 = state_46388;
(statearr_46409[(4)] = cljs.core.rest((state_46388[(4)])));

return statearr_46409;
})();
var state_46388__$1 = state_46388;
var ex46404 = (state_46388__$1[(2)]);
var statearr_46410_46439 = state_46388__$1;
(statearr_46410_46439[(5)] = ex46404);


if((ex46404 instanceof Error)){
var statearr_46411_46440 = state_46388__$1;
(statearr_46411_46440[(1)] = (4));

(statearr_46411_46440[(5)] = null);

} else {
throw ex46404;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (14))){
var inst_46321 = (state_46388[(10)]);
var inst_46323 = (state_46388[(11)]);
var inst_46324 = (state_46388[(9)]);
var inst_46355 = (state_46388[(2)]);
var inst_46356 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_46357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46359 = [inst_46321,inst_46324,"?current-val"];
var inst_46360 = (new cljs.core.PersistentVector(null,3,(5),inst_46358,inst_46359,null));
var inst_46361 = [inst_46360];
var inst_46362 = (new cljs.core.PersistentVector(null,1,(5),inst_46357,inst_46361,null));
var inst_46363 = cljs.core.PersistentHashMap.EMPTY;
var inst_46364 = ["?current-val",inst_46362,inst_46363];
var inst_46365 = cljs.core.PersistentHashMap.fromArrays(inst_46356,inst_46364);
var inst_46366 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_46323,inst_46365);
var state_46388__$1 = (function (){var statearr_46412 = state_46388;
(statearr_46412[(14)] = inst_46355);

return statearr_46412;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46388__$1,(15),inst_46366);
} else {
if((state_val_46389 === (16))){
var state_46388__$1 = state_46388;
var statearr_46413_46441 = state_46388__$1;
(statearr_46413_46441[(2)] = new_val);

(statearr_46413_46441[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (10))){
var inst_46337 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_46338 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_46339 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_46340 = cljs.core.PersistentHashMap.fromArrays(inst_46338,inst_46339);
var inst_46341 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_46337,inst_46340);
var inst_46342 = (function(){throw inst_46341})();
var state_46388__$1 = state_46388;
var statearr_46414_46442 = state_46388__$1;
(statearr_46414_46442[(2)] = inst_46342);

(statearr_46414_46442[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (18))){
var inst_46383 = (state_46388[(2)]);
var _ = (function (){var statearr_46415 = state_46388;
(statearr_46415[(4)] = cljs.core.rest((state_46388[(4)])));

return statearr_46415;
})();
var state_46388__$1 = state_46388;
var statearr_46416_46443 = state_46388__$1;
(statearr_46416_46443[(2)] = inst_46383);

(statearr_46416_46443[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46389 === (8))){
var inst_46324 = (state_46388[(9)]);
var inst_46334 = (state_46388[(2)]);
var state_46388__$1 = (function (){var statearr_46417 = state_46388;
(statearr_46417[(15)] = inst_46334);

return statearr_46417;
})();
if(cljs.core.truth_(inst_46324)){
var statearr_46418_46444 = state_46388__$1;
(statearr_46418_46444[(1)] = (9));

} else {
var statearr_46419_46445 = state_46388__$1;
(statearr_46419_46445[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto____0 = (function (){
var statearr_46420 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46420[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto__);

(statearr_46420[(1)] = (1));

return statearr_46420;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto____1 = (function (state_46388){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_46388);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e46421){var ex__14781__auto__ = e46421;
var statearr_46422_46446 = state_46388;
(statearr_46422_46446[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_46388[(4)]))){
var statearr_46423_46447 = state_46388;
(statearr_46423_46447[(1)] = cljs.core.first((state_46388[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__46448 = state_46388;
state_46388 = G__46448;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto__ = function(state_46388){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto____1.call(this,state_46388);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_46424 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_46424[(6)] = c__14852__auto__);

return statearr_46424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
