// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4878__auto___71026 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71077){
var state_val_71078 = (state_71077[(1)]);
if((state_val_71078 === (7))){
var inst_71072 = (state_71077[(2)]);
var _ = (function (){var statearr_71079 = state_71077;
(statearr_71079[(4)] = cljs.core.rest((state_71077[(4)])));

return statearr_71079;
})();
var state_71077__$1 = state_71077;
var statearr_71080_71107 = state_71077__$1;
(statearr_71080_71107[(2)] = inst_71072);

(statearr_71080_71107[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (1))){
var state_71077__$1 = state_71077;
var statearr_71081_71108 = state_71077__$1;
(statearr_71081_71108[(2)] = null);

(statearr_71081_71108[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (4))){
var inst_71027 = (state_71077[(2)]);
var state_71077__$1 = state_71077;
var statearr_71082_71109 = state_71077__$1;
(statearr_71082_71109[(2)] = inst_71027);

(statearr_71082_71109[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (13))){
var inst_71068 = (state_71077[(2)]);
var state_71077__$1 = state_71077;
var statearr_71083_71110 = state_71077__$1;
(statearr_71083_71110[(2)] = inst_71068);

(statearr_71083_71110[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (6))){
var inst_71045 = (state_71077[(7)]);
var inst_71052 = (state_71077[(8)]);
var inst_71051 = cljs.core.seq(inst_71045);
var inst_71052__$1 = cljs.core.first(inst_71051);
var inst_71053 = cljs.core.next(inst_71051);
var inst_71054 = cljs.core.not(inst_71052__$1);
var state_71077__$1 = (function (){var statearr_71084 = state_71077;
(statearr_71084[(8)] = inst_71052__$1);

(statearr_71084[(9)] = inst_71053);

return statearr_71084;
})();
if(inst_71054){
var statearr_71085_71111 = state_71077__$1;
(statearr_71085_71111[(1)] = (8));

} else {
var statearr_71086_71112 = state_71077__$1;
(statearr_71086_71112[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (3))){
var inst_71075 = (state_71077[(2)]);
var state_71077__$1 = state_71077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71077__$1,inst_71075);
} else {
if((state_val_71078 === (12))){
var inst_71046 = (state_71077[(10)]);
var inst_71052 = (state_71077[(8)]);
var inst_71053 = (state_71077[(9)]);
var inst_71065 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_71046,inst_71052);
var inst_71045 = inst_71053;
var inst_71046__$1 = inst_71065;
var state_71077__$1 = (function (){var statearr_71087 = state_71077;
(statearr_71087[(10)] = inst_71046__$1);

(statearr_71087[(7)] = inst_71045);

return statearr_71087;
})();
var statearr_71088_71113 = state_71077__$1;
(statearr_71088_71113[(2)] = null);

(statearr_71088_71113[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (2))){
var _ = (function (){var statearr_71089 = state_71077;
(statearr_71089[(4)] = cljs.core.cons((5),(state_71077[(4)])));

return statearr_71089;
})();
var inst_71040 = args;
var inst_71041 = cljs.core.seq(inst_71040);
var inst_71042 = cljs.core.first(inst_71041);
var inst_71043 = cljs.core.next(inst_71041);
var inst_71044 = cljs.core.PersistentVector.EMPTY;
var inst_71045 = inst_71040;
var inst_71046 = inst_71044;
var state_71077__$1 = (function (){var statearr_71090 = state_71077;
(statearr_71090[(11)] = inst_71043);

(statearr_71090[(12)] = inst_71042);

(statearr_71090[(10)] = inst_71046);

(statearr_71090[(7)] = inst_71045);

return statearr_71090;
})();
var statearr_71091_71114 = state_71077__$1;
(statearr_71091_71114[(2)] = null);

(statearr_71091_71114[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (11))){
var inst_71052 = (state_71077[(8)]);
var state_71077__$1 = state_71077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71077__$1,(14),inst_71052);
} else {
if((state_val_71078 === (9))){
var inst_71052 = (state_71077[(8)]);
var inst_71057 = fluree.db.util.async.channel_QMARK_(inst_71052);
var state_71077__$1 = state_71077;
if(inst_71057){
var statearr_71093_71115 = state_71077__$1;
(statearr_71093_71115[(1)] = (11));

} else {
var statearr_71094_71116 = state_71077__$1;
(statearr_71094_71116[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (5))){
var _ = (function (){var statearr_71095 = state_71077;
(statearr_71095[(4)] = cljs.core.rest((state_71077[(4)])));

return statearr_71095;
})();
var state_71077__$1 = state_71077;
var ex71092 = (state_71077__$1[(2)]);
var statearr_71096_71117 = state_71077__$1;
(statearr_71096_71117[(5)] = ex71092);


if((ex71092 instanceof Error)){
var statearr_71097_71118 = state_71077__$1;
(statearr_71097_71118[(1)] = (4));

(statearr_71097_71118[(5)] = null);

} else {
throw ex71092;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (14))){
var inst_71046 = (state_71077[(10)]);
var inst_71053 = (state_71077[(9)]);
var inst_71060 = (state_71077[(2)]);
var inst_71061 = fluree.db.util.async.throw_err(inst_71060);
var inst_71062 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_71046,inst_71061);
var inst_71045 = inst_71053;
var inst_71046__$1 = inst_71062;
var state_71077__$1 = (function (){var statearr_71098 = state_71077;
(statearr_71098[(10)] = inst_71046__$1);

(statearr_71098[(7)] = inst_71045);

return statearr_71098;
})();
var statearr_71099_71119 = state_71077__$1;
(statearr_71099_71119[(2)] = null);

(statearr_71099_71119[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (10))){
var inst_71070 = (state_71077[(2)]);
var state_71077__$1 = state_71077;
var statearr_71100_71120 = state_71077__$1;
(statearr_71100_71120[(2)] = inst_71070);

(statearr_71100_71120[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (8))){
var inst_71046 = (state_71077[(10)]);
var state_71077__$1 = state_71077;
var statearr_71101_71121 = state_71077__$1;
(statearr_71101_71121[(2)] = inst_71046);

(statearr_71101_71121[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto____0 = (function (){
var statearr_71102 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71102[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto__);

(statearr_71102[(1)] = (1));

return statearr_71102;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto____1 = (function (state_71077){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71077);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71103){var ex__14781__auto__ = e71103;
var statearr_71104_71122 = state_71077;
(statearr_71104_71122[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71077[(4)]))){
var statearr_71105_71123 = state_71077;
(statearr_71105_71123[(1)] = cljs.core.first((state_71077[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71124 = state_71077;
state_71077 = G__71124;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto__ = function(state_71077){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto____1.call(this,state_71077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71106 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71106[(6)] = c__14852__auto__);

return statearr_71106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__71125 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71125,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71125,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71173){
var state_val_71174 = (state_71173[(1)]);
if((state_val_71174 === (7))){
var state_71173__$1 = state_71173;
var statearr_71175_71204 = state_71173__$1;
(statearr_71175_71204[(2)] = coll);

(statearr_71175_71204[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (1))){
var state_71173__$1 = state_71173;
var statearr_71176_71205 = state_71173__$1;
(statearr_71176_71205[(2)] = null);

(statearr_71176_71205[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (4))){
var inst_71128 = (state_71173[(2)]);
var state_71173__$1 = state_71173;
var statearr_71177_71206 = state_71173__$1;
(statearr_71177_71206[(2)] = inst_71128);

(statearr_71177_71206[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (15))){
var inst_71147 = (state_71173[(7)]);
var inst_71155 = (state_71173[(2)]);
var inst_71156 = fluree.db.dbfunctions.internal.nth(inst_71147,inst_71155);
var inst_71157 = cljs.core.count(inst_71147);
var inst_71158 = ((9) + inst_71157);
var inst_71159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71160 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71162 = [inst_71147,inst_71155];
var inst_71163 = (new cljs.core.PersistentVector(null,2,(5),inst_71161,inst_71162,null));
var inst_71164 = ["nth",inst_71163,inst_71156];
var inst_71165 = cljs.core.PersistentHashMap.fromArrays(inst_71160,inst_71164);
var inst_71166 = [inst_71165,inst_71158];
var inst_71167 = (new cljs.core.PersistentVector(null,2,(5),inst_71159,inst_71166,null));
var inst_71168 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71167);
var _ = (function (){var statearr_71178 = state_71173;
(statearr_71178[(4)] = cljs.core.rest((state_71173[(4)])));

return statearr_71178;
})();
var state_71173__$1 = (function (){var statearr_71179 = state_71173;
(statearr_71179[(8)] = inst_71168);

return statearr_71179;
})();
var statearr_71180_71207 = state_71173__$1;
(statearr_71180_71207[(2)] = inst_71156);

(statearr_71180_71207[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (13))){
var state_71173__$1 = state_71173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71173__$1,(16),key);
} else {
if((state_val_71174 === (6))){
var state_71173__$1 = state_71173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71173__$1,(9),coll);
} else {
if((state_val_71174 === (3))){
var inst_71171 = (state_71173[(2)]);
var state_71173__$1 = state_71173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71173__$1,inst_71171);
} else {
if((state_val_71174 === (12))){
var inst_71147 = (state_71173[(2)]);
var inst_71148 = fluree.db.util.async.channel_QMARK_(key);
var state_71173__$1 = (function (){var statearr_71181 = state_71173;
(statearr_71181[(7)] = inst_71147);

return statearr_71181;
})();
if(inst_71148){
var statearr_71182_71208 = state_71173__$1;
(statearr_71182_71208[(1)] = (13));

} else {
var statearr_71183_71209 = state_71173__$1;
(statearr_71183_71209[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (2))){
var _ = (function (){var statearr_71184 = state_71173;
(statearr_71184[(4)] = cljs.core.cons((5),(state_71173[(4)])));

return statearr_71184;
})();
var inst_71134 = fluree.db.util.async.channel_QMARK_(coll);
var state_71173__$1 = state_71173;
if(inst_71134){
var statearr_71185_71210 = state_71173__$1;
(statearr_71185_71210[(1)] = (6));

} else {
var statearr_71186_71211 = state_71173__$1;
(statearr_71186_71211[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (11))){
var inst_71141 = (state_71173[(9)]);
var state_71173__$1 = state_71173;
var statearr_71188_71212 = state_71173__$1;
(statearr_71188_71212[(2)] = inst_71141);

(statearr_71188_71212[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (9))){
var inst_71137 = (state_71173[(2)]);
var inst_71138 = fluree.db.util.async.throw_err(inst_71137);
var state_71173__$1 = state_71173;
var statearr_71189_71213 = state_71173__$1;
(statearr_71189_71213[(2)] = inst_71138);

(statearr_71189_71213[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (5))){
var _ = (function (){var statearr_71190 = state_71173;
(statearr_71190[(4)] = cljs.core.rest((state_71173[(4)])));

return statearr_71190;
})();
var state_71173__$1 = state_71173;
var ex71187 = (state_71173__$1[(2)]);
var statearr_71191_71214 = state_71173__$1;
(statearr_71191_71214[(5)] = ex71187);


if((ex71187 instanceof Error)){
var statearr_71192_71215 = state_71173__$1;
(statearr_71192_71215[(1)] = (4));

(statearr_71192_71215[(5)] = null);

} else {
throw ex71187;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (14))){
var state_71173__$1 = state_71173;
var statearr_71193_71216 = state_71173__$1;
(statearr_71193_71216[(2)] = key);

(statearr_71193_71216[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (16))){
var inst_71151 = (state_71173[(2)]);
var inst_71152 = fluree.db.util.async.throw_err(inst_71151);
var state_71173__$1 = state_71173;
var statearr_71194_71217 = state_71173__$1;
(statearr_71194_71217[(2)] = inst_71152);

(statearr_71194_71217[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (10))){
var inst_71141 = (state_71173[(9)]);
var inst_71144 = cljs.core.vec(inst_71141);
var state_71173__$1 = state_71173;
var statearr_71195_71218 = state_71173__$1;
(statearr_71195_71218[(2)] = inst_71144);

(statearr_71195_71218[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71174 === (8))){
var inst_71141 = (state_71173[(9)]);
var inst_71141__$1 = (state_71173[(2)]);
var inst_71142 = cljs.core.set_QMARK_(inst_71141__$1);
var state_71173__$1 = (function (){var statearr_71196 = state_71173;
(statearr_71196[(9)] = inst_71141__$1);

return statearr_71196;
})();
if(inst_71142){
var statearr_71197_71219 = state_71173__$1;
(statearr_71197_71219[(1)] = (10));

} else {
var statearr_71198_71220 = state_71173__$1;
(statearr_71198_71220[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto____0 = (function (){
var statearr_71199 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71199[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto__);

(statearr_71199[(1)] = (1));

return statearr_71199;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto____1 = (function (state_71173){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71173);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71200){var ex__14781__auto__ = e71200;
var statearr_71201_71221 = state_71173;
(statearr_71201_71221[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71173[(4)]))){
var statearr_71202_71222 = state_71173;
(statearr_71202_71222[(1)] = cljs.core.first((state_71173[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71223 = state_71173;
state_71173 = G__71223;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto__ = function(state_71173){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto____1.call(this,state_71173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71203 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71203[(6)] = c__14852__auto__);

return statearr_71203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71284){
var state_val_71285 = (state_71284[(1)]);
if((state_val_71285 === (7))){
var state_71284__$1 = state_71284;
var statearr_71286_71320 = state_71284__$1;
(statearr_71286_71320[(2)] = test);

(statearr_71286_71320[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (20))){
var inst_71258 = (state_71284[(2)]);
var inst_71259 = fluree.db.util.async.throw_err(inst_71258);
var state_71284__$1 = state_71284;
var statearr_71287_71321 = state_71284__$1;
(statearr_71287_71321[(2)] = inst_71259);

(statearr_71287_71321[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (1))){
var state_71284__$1 = state_71284;
var statearr_71288_71322 = state_71284__$1;
(statearr_71288_71322[(2)] = null);

(statearr_71288_71322[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (4))){
var inst_71224 = (state_71284[(2)]);
var state_71284__$1 = state_71284;
var statearr_71289_71323 = state_71284__$1;
(statearr_71289_71323[(2)] = inst_71224);

(statearr_71289_71323[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (15))){
var inst_71242 = (state_71284[(7)]);
var inst_71250 = (state_71284[(2)]);
var inst_71251 = [inst_71250,f];
var inst_71252 = (new cljs.core.PersistentVector(null,2,(5),inst_71242,inst_71251,null));
var state_71284__$1 = state_71284;
var statearr_71290_71324 = state_71284__$1;
(statearr_71290_71324[(2)] = inst_71252);

(statearr_71290_71324[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (13))){
var state_71284__$1 = state_71284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71284__$1,(16),t);
} else {
if((state_val_71285 === (6))){
var state_71284__$1 = state_71284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71284__$1,(9),test);
} else {
if((state_val_71285 === (17))){
var state_71284__$1 = state_71284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71284__$1,(20),f);
} else {
if((state_val_71285 === (3))){
var inst_71282 = (state_71284[(2)]);
var state_71284__$1 = state_71284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71284__$1,inst_71282);
} else {
if((state_val_71285 === (12))){
var inst_71240 = (state_71284[(8)]);
var inst_71266 = (state_71284[(2)]);
var inst_71267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71266,(0),null);
var inst_71268 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71266,(1),null);
var inst_71269 = fluree.db.dbfunctions.internal.if_else(inst_71240,inst_71267,inst_71268);
var inst_71270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71271 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71273 = [inst_71240,inst_71267,inst_71268];
var inst_71274 = (new cljs.core.PersistentVector(null,3,(5),inst_71272,inst_71273,null));
var inst_71275 = ["if-else",inst_71274,inst_71269];
var inst_71276 = cljs.core.PersistentHashMap.fromArrays(inst_71271,inst_71275);
var inst_71277 = [inst_71276,(10)];
var inst_71278 = (new cljs.core.PersistentVector(null,2,(5),inst_71270,inst_71277,null));
var inst_71279 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71278);
var _ = (function (){var statearr_71291 = state_71284;
(statearr_71291[(4)] = cljs.core.rest((state_71284[(4)])));

return statearr_71291;
})();
var state_71284__$1 = (function (){var statearr_71292 = state_71284;
(statearr_71292[(9)] = inst_71279);

return statearr_71292;
})();
var statearr_71293_71325 = state_71284__$1;
(statearr_71293_71325[(2)] = inst_71269);

(statearr_71293_71325[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (2))){
var _ = (function (){var statearr_71294 = state_71284;
(statearr_71294[(4)] = cljs.core.cons((5),(state_71284[(4)])));

return statearr_71294;
})();
var inst_71233 = fluree.db.util.async.channel_QMARK_(test);
var state_71284__$1 = state_71284;
if(inst_71233){
var statearr_71295_71326 = state_71284__$1;
(statearr_71295_71326[(1)] = (6));

} else {
var statearr_71296_71327 = state_71284__$1;
(statearr_71296_71327[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (19))){
var inst_71254 = (state_71284[(10)]);
var inst_71262 = (state_71284[(2)]);
var inst_71263 = [f,inst_71262];
var inst_71264 = (new cljs.core.PersistentVector(null,2,(5),inst_71254,inst_71263,null));
var state_71284__$1 = state_71284;
var statearr_71297_71328 = state_71284__$1;
(statearr_71297_71328[(2)] = inst_71264);

(statearr_71297_71328[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (11))){
var inst_71254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71255 = fluree.db.util.async.channel_QMARK_(f);
var state_71284__$1 = (function (){var statearr_71299 = state_71284;
(statearr_71299[(10)] = inst_71254);

return statearr_71299;
})();
if(inst_71255){
var statearr_71300_71329 = state_71284__$1;
(statearr_71300_71329[(1)] = (17));

} else {
var statearr_71301_71330 = state_71284__$1;
(statearr_71301_71330[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (9))){
var inst_71236 = (state_71284[(2)]);
var inst_71237 = fluree.db.util.async.throw_err(inst_71236);
var state_71284__$1 = state_71284;
var statearr_71302_71331 = state_71284__$1;
(statearr_71302_71331[(2)] = inst_71237);

(statearr_71302_71331[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (5))){
var _ = (function (){var statearr_71303 = state_71284;
(statearr_71303[(4)] = cljs.core.rest((state_71284[(4)])));

return statearr_71303;
})();
var state_71284__$1 = state_71284;
var ex71298 = (state_71284__$1[(2)]);
var statearr_71304_71332 = state_71284__$1;
(statearr_71304_71332[(5)] = ex71298);


if((ex71298 instanceof Error)){
var statearr_71305_71333 = state_71284__$1;
(statearr_71305_71333[(1)] = (4));

(statearr_71305_71333[(5)] = null);

} else {
throw ex71298;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (14))){
var state_71284__$1 = state_71284;
var statearr_71306_71334 = state_71284__$1;
(statearr_71306_71334[(2)] = t);

(statearr_71306_71334[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (16))){
var inst_71246 = (state_71284[(2)]);
var inst_71247 = fluree.db.util.async.throw_err(inst_71246);
var state_71284__$1 = state_71284;
var statearr_71307_71335 = state_71284__$1;
(statearr_71307_71335[(2)] = inst_71247);

(statearr_71307_71335[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (10))){
var inst_71242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71243 = fluree.db.util.async.channel_QMARK_(t);
var state_71284__$1 = (function (){var statearr_71308 = state_71284;
(statearr_71308[(7)] = inst_71242);

return statearr_71308;
})();
if(inst_71243){
var statearr_71309_71336 = state_71284__$1;
(statearr_71309_71336[(1)] = (13));

} else {
var statearr_71310_71337 = state_71284__$1;
(statearr_71310_71337[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (18))){
var state_71284__$1 = state_71284;
var statearr_71311_71338 = state_71284__$1;
(statearr_71311_71338[(2)] = f);

(statearr_71311_71338[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71285 === (8))){
var inst_71240 = (state_71284[(8)]);
var inst_71240__$1 = (state_71284[(2)]);
var state_71284__$1 = (function (){var statearr_71312 = state_71284;
(statearr_71312[(8)] = inst_71240__$1);

return statearr_71312;
})();
if(cljs.core.truth_(inst_71240__$1)){
var statearr_71313_71339 = state_71284__$1;
(statearr_71313_71339[(1)] = (10));

} else {
var statearr_71314_71340 = state_71284__$1;
(statearr_71314_71340[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto____0 = (function (){
var statearr_71315 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71315[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto__);

(statearr_71315[(1)] = (1));

return statearr_71315;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto____1 = (function (state_71284){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71284);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71316){var ex__14781__auto__ = e71316;
var statearr_71317_71341 = state_71284;
(statearr_71317_71341[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71284[(4)]))){
var statearr_71318_71342 = state_71284;
(statearr_71318_71342[(1)] = cljs.core.first((state_71284[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71343 = state_71284;
state_71284 = G__71343;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto__ = function(state_71284){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto____1.call(this,state_71284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71319 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71319[(6)] = c__14852__auto__);

return statearr_71319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71373){
var state_val_71374 = (state_71373[(1)]);
if((state_val_71374 === (7))){
var state_71373__$1 = state_71373;
var statearr_71375_71394 = state_71373__$1;
(statearr_71375_71394[(2)] = arg);

(statearr_71375_71394[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71374 === (1))){
var state_71373__$1 = state_71373;
var statearr_71376_71395 = state_71373__$1;
(statearr_71376_71395[(2)] = null);

(statearr_71376_71395[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71374 === (4))){
var inst_71344 = (state_71373[(2)]);
var state_71373__$1 = state_71373;
var statearr_71377_71396 = state_71373__$1;
(statearr_71377_71396[(2)] = inst_71344);

(statearr_71377_71396[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71374 === (6))){
var state_71373__$1 = state_71373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71373__$1,(9),arg);
} else {
if((state_val_71374 === (3))){
var inst_71371 = (state_71373[(2)]);
var state_71373__$1 = state_71373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71373__$1,inst_71371);
} else {
if((state_val_71374 === (2))){
var _ = (function (){var statearr_71379 = state_71373;
(statearr_71379[(4)] = cljs.core.cons((5),(state_71373[(4)])));

return statearr_71379;
})();
var inst_71350 = fluree.db.util.async.channel_QMARK_(arg);
var state_71373__$1 = state_71373;
if(inst_71350){
var statearr_71380_71397 = state_71373__$1;
(statearr_71380_71397[(1)] = (6));

} else {
var statearr_71381_71398 = state_71373__$1;
(statearr_71381_71398[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71374 === (9))){
var inst_71353 = (state_71373[(2)]);
var inst_71354 = fluree.db.util.async.throw_err(inst_71353);
var state_71373__$1 = state_71373;
var statearr_71382_71399 = state_71373__$1;
(statearr_71382_71399[(2)] = inst_71354);

(statearr_71382_71399[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71374 === (5))){
var _ = (function (){var statearr_71383 = state_71373;
(statearr_71383[(4)] = cljs.core.rest((state_71373[(4)])));

return statearr_71383;
})();
var state_71373__$1 = state_71373;
var ex71378 = (state_71373__$1[(2)]);
var statearr_71384_71400 = state_71373__$1;
(statearr_71384_71400[(5)] = ex71378);


if((ex71378 instanceof Error)){
var statearr_71385_71401 = state_71373__$1;
(statearr_71385_71401[(1)] = (4));

(statearr_71385_71401[(5)] = null);

} else {
throw ex71378;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71374 === (8))){
var inst_71357 = (state_71373[(2)]);
var inst_71358 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_71357);
var inst_71359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71360 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71362 = [inst_71357];
var inst_71363 = (new cljs.core.PersistentVector(null,1,(5),inst_71361,inst_71362,null));
var inst_71364 = ["nil?",inst_71363,inst_71358];
var inst_71365 = cljs.core.PersistentHashMap.fromArrays(inst_71360,inst_71364);
var inst_71366 = [inst_71365,(10)];
var inst_71367 = (new cljs.core.PersistentVector(null,2,(5),inst_71359,inst_71366,null));
var inst_71368 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71367);
var _ = (function (){var statearr_71386 = state_71373;
(statearr_71386[(4)] = cljs.core.rest((state_71373[(4)])));

return statearr_71386;
})();
var state_71373__$1 = (function (){var statearr_71387 = state_71373;
(statearr_71387[(7)] = inst_71368);

return statearr_71387;
})();
var statearr_71388_71402 = state_71373__$1;
(statearr_71388_71402[(2)] = inst_71358);

(statearr_71388_71402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto____0 = (function (){
var statearr_71389 = [null,null,null,null,null,null,null,null];
(statearr_71389[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto__);

(statearr_71389[(1)] = (1));

return statearr_71389;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto____1 = (function (state_71373){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71373);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71390){var ex__14781__auto__ = e71390;
var statearr_71391_71403 = state_71373;
(statearr_71391_71403[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71373[(4)]))){
var statearr_71392_71404 = state_71373;
(statearr_71392_71404[(1)] = cljs.core.first((state_71373[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71405 = state_71373;
state_71373 = G__71405;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto__ = function(state_71373){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto____1.call(this,state_71373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71393 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71393[(6)] = c__14852__auto__);

return statearr_71393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71435){
var state_val_71436 = (state_71435[(1)]);
if((state_val_71436 === (7))){
var state_71435__$1 = state_71435;
var statearr_71437_71456 = state_71435__$1;
(statearr_71437_71456[(2)] = arg);

(statearr_71437_71456[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71436 === (1))){
var state_71435__$1 = state_71435;
var statearr_71438_71457 = state_71435__$1;
(statearr_71438_71457[(2)] = null);

(statearr_71438_71457[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71436 === (4))){
var inst_71406 = (state_71435[(2)]);
var state_71435__$1 = state_71435;
var statearr_71439_71458 = state_71435__$1;
(statearr_71439_71458[(2)] = inst_71406);

(statearr_71439_71458[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71436 === (6))){
var state_71435__$1 = state_71435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71435__$1,(9),arg);
} else {
if((state_val_71436 === (3))){
var inst_71433 = (state_71435[(2)]);
var state_71435__$1 = state_71435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71435__$1,inst_71433);
} else {
if((state_val_71436 === (2))){
var _ = (function (){var statearr_71441 = state_71435;
(statearr_71441[(4)] = cljs.core.cons((5),(state_71435[(4)])));

return statearr_71441;
})();
var inst_71412 = fluree.db.util.async.channel_QMARK_(arg);
var state_71435__$1 = state_71435;
if(inst_71412){
var statearr_71442_71459 = state_71435__$1;
(statearr_71442_71459[(1)] = (6));

} else {
var statearr_71443_71460 = state_71435__$1;
(statearr_71443_71460[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71436 === (9))){
var inst_71415 = (state_71435[(2)]);
var inst_71416 = fluree.db.util.async.throw_err(inst_71415);
var state_71435__$1 = state_71435;
var statearr_71444_71461 = state_71435__$1;
(statearr_71444_71461[(2)] = inst_71416);

(statearr_71444_71461[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71436 === (5))){
var _ = (function (){var statearr_71445 = state_71435;
(statearr_71445[(4)] = cljs.core.rest((state_71435[(4)])));

return statearr_71445;
})();
var state_71435__$1 = state_71435;
var ex71440 = (state_71435__$1[(2)]);
var statearr_71446_71462 = state_71435__$1;
(statearr_71446_71462[(5)] = ex71440);


if((ex71440 instanceof Error)){
var statearr_71447_71463 = state_71435__$1;
(statearr_71447_71463[(1)] = (4));

(statearr_71447_71463[(5)] = null);

} else {
throw ex71440;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71436 === (8))){
var inst_71419 = (state_71435[(2)]);
var inst_71420 = fluree.db.dbfunctions.internal.not(inst_71419);
var inst_71421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71422 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71424 = [inst_71419];
var inst_71425 = (new cljs.core.PersistentVector(null,1,(5),inst_71423,inst_71424,null));
var inst_71426 = ["not?",inst_71425,inst_71420];
var inst_71427 = cljs.core.PersistentHashMap.fromArrays(inst_71422,inst_71426);
var inst_71428 = [inst_71427,(10)];
var inst_71429 = (new cljs.core.PersistentVector(null,2,(5),inst_71421,inst_71428,null));
var inst_71430 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71429);
var _ = (function (){var statearr_71448 = state_71435;
(statearr_71448[(4)] = cljs.core.rest((state_71435[(4)])));

return statearr_71448;
})();
var state_71435__$1 = (function (){var statearr_71449 = state_71435;
(statearr_71449[(7)] = inst_71430);

return statearr_71449;
})();
var statearr_71450_71464 = state_71435__$1;
(statearr_71450_71464[(2)] = inst_71420);

(statearr_71450_71464[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto____0 = (function (){
var statearr_71451 = [null,null,null,null,null,null,null,null];
(statearr_71451[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto__);

(statearr_71451[(1)] = (1));

return statearr_71451;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto____1 = (function (state_71435){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71435);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71452){var ex__14781__auto__ = e71452;
var statearr_71453_71465 = state_71435;
(statearr_71453_71465[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71435[(4)]))){
var statearr_71454_71466 = state_71435;
(statearr_71454_71466[(1)] = cljs.core.first((state_71435[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71467 = state_71435;
state_71435 = G__71467;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto__ = function(state_71435){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto____1.call(this,state_71435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71455 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71455[(6)] = c__14852__auto__);

return statearr_71455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71497){
var state_val_71498 = (state_71497[(1)]);
if((state_val_71498 === (7))){
var state_71497__$1 = state_71497;
var statearr_71499_71518 = state_71497__$1;
(statearr_71499_71518[(2)] = arg);

(statearr_71499_71518[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71498 === (1))){
var state_71497__$1 = state_71497;
var statearr_71500_71519 = state_71497__$1;
(statearr_71500_71519[(2)] = null);

(statearr_71500_71519[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71498 === (4))){
var inst_71468 = (state_71497[(2)]);
var state_71497__$1 = state_71497;
var statearr_71501_71520 = state_71497__$1;
(statearr_71501_71520[(2)] = inst_71468);

(statearr_71501_71520[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71498 === (6))){
var state_71497__$1 = state_71497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71497__$1,(9),arg);
} else {
if((state_val_71498 === (3))){
var inst_71495 = (state_71497[(2)]);
var state_71497__$1 = state_71497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71497__$1,inst_71495);
} else {
if((state_val_71498 === (2))){
var _ = (function (){var statearr_71503 = state_71497;
(statearr_71503[(4)] = cljs.core.cons((5),(state_71497[(4)])));

return statearr_71503;
})();
var inst_71474 = fluree.db.util.async.channel_QMARK_(arg);
var state_71497__$1 = state_71497;
if(inst_71474){
var statearr_71504_71521 = state_71497__$1;
(statearr_71504_71521[(1)] = (6));

} else {
var statearr_71505_71522 = state_71497__$1;
(statearr_71505_71522[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71498 === (9))){
var inst_71477 = (state_71497[(2)]);
var inst_71478 = fluree.db.util.async.throw_err(inst_71477);
var state_71497__$1 = state_71497;
var statearr_71506_71523 = state_71497__$1;
(statearr_71506_71523[(2)] = inst_71478);

(statearr_71506_71523[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71498 === (5))){
var _ = (function (){var statearr_71507 = state_71497;
(statearr_71507[(4)] = cljs.core.rest((state_71497[(4)])));

return statearr_71507;
})();
var state_71497__$1 = state_71497;
var ex71502 = (state_71497__$1[(2)]);
var statearr_71508_71524 = state_71497__$1;
(statearr_71508_71524[(5)] = ex71502);


if((ex71502 instanceof Error)){
var statearr_71509_71525 = state_71497__$1;
(statearr_71509_71525[(1)] = (4));

(statearr_71509_71525[(5)] = null);

} else {
throw ex71502;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71498 === (8))){
var inst_71481 = (state_71497[(2)]);
var inst_71482 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_71481);
var inst_71483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71484 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71486 = [inst_71481];
var inst_71487 = (new cljs.core.PersistentVector(null,1,(5),inst_71485,inst_71486,null));
var inst_71488 = ["empty?",inst_71487,inst_71482];
var inst_71489 = cljs.core.PersistentHashMap.fromArrays(inst_71484,inst_71488);
var inst_71490 = [inst_71489,(10)];
var inst_71491 = (new cljs.core.PersistentVector(null,2,(5),inst_71483,inst_71490,null));
var inst_71492 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71491);
var _ = (function (){var statearr_71510 = state_71497;
(statearr_71510[(4)] = cljs.core.rest((state_71497[(4)])));

return statearr_71510;
})();
var state_71497__$1 = (function (){var statearr_71511 = state_71497;
(statearr_71511[(7)] = inst_71492);

return statearr_71511;
})();
var statearr_71512_71526 = state_71497__$1;
(statearr_71512_71526[(2)] = inst_71482);

(statearr_71512_71526[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto____0 = (function (){
var statearr_71513 = [null,null,null,null,null,null,null,null];
(statearr_71513[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto__);

(statearr_71513[(1)] = (1));

return statearr_71513;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto____1 = (function (state_71497){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71497);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71514){var ex__14781__auto__ = e71514;
var statearr_71515_71527 = state_71497;
(statearr_71515_71527[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71497[(4)]))){
var statearr_71516_71528 = state_71497;
(statearr_71516_71528[(1)] = cljs.core.first((state_71497[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71529 = state_71497;
state_71497 = G__71529;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto__ = function(state_71497){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto____1.call(this,state_71497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71517 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71517[(6)] = c__14852__auto__);

return statearr_71517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___71574 = arguments.length;
var i__4830__auto___71575 = (0);
while(true){
if((i__4830__auto___71575 < len__4829__auto___71574)){
args__4835__auto__.push((arguments[i__4830__auto___71575]));

var G__71576 = (i__4830__auto___71575 + (1));
i__4830__auto___71575 = G__71576;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71557){
var state_val_71558 = (state_71557[(1)]);
if((state_val_71558 === (1))){
var state_71557__$1 = state_71557;
var statearr_71559_71577 = state_71557__$1;
(statearr_71559_71577[(2)] = null);

(statearr_71559_71577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71558 === (2))){
var _ = (function (){var statearr_71560 = state_71557;
(statearr_71560[(4)] = cljs.core.cons((5),(state_71557[(4)])));

return statearr_71560;
})();
var inst_71538 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71557__$1 = state_71557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71557__$1,(6),inst_71538);
} else {
if((state_val_71558 === (3))){
var inst_71555 = (state_71557[(2)]);
var state_71557__$1 = state_71557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71557__$1,inst_71555);
} else {
if((state_val_71558 === (4))){
var inst_71532 = (state_71557[(2)]);
var state_71557__$1 = state_71557;
var statearr_71562_71578 = state_71557__$1;
(statearr_71562_71578[(2)] = inst_71532);

(statearr_71562_71578[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71558 === (5))){
var _ = (function (){var statearr_71563 = state_71557;
(statearr_71563[(4)] = cljs.core.rest((state_71557[(4)])));

return statearr_71563;
})();
var state_71557__$1 = state_71557;
var ex71561 = (state_71557__$1[(2)]);
var statearr_71564_71579 = state_71557__$1;
(statearr_71564_71579[(5)] = ex71561);


if((ex71561 instanceof Error)){
var statearr_71565_71580 = state_71557__$1;
(statearr_71565_71580[(1)] = (4));

(statearr_71565_71580[(5)] = null);

} else {
throw ex71561;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71558 === (6))){
var inst_71540 = (state_71557[(2)]);
var inst_71541 = fluree.db.util.async.throw_err(inst_71540);
var inst_71542 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_71541);
var inst_71543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71544 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71546 = [inst_71541];
var inst_71547 = (new cljs.core.PersistentVector(null,1,(5),inst_71545,inst_71546,null));
var inst_71548 = ["str",inst_71547,inst_71542];
var inst_71549 = cljs.core.PersistentHashMap.fromArrays(inst_71544,inst_71548);
var inst_71550 = [inst_71549,(10)];
var inst_71551 = (new cljs.core.PersistentVector(null,2,(5),inst_71543,inst_71550,null));
var inst_71552 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71551);
var _ = (function (){var statearr_71566 = state_71557;
(statearr_71566[(4)] = cljs.core.rest((state_71557[(4)])));

return statearr_71566;
})();
var state_71557__$1 = (function (){var statearr_71567 = state_71557;
(statearr_71567[(7)] = inst_71552);

return statearr_71567;
})();
var statearr_71568_71581 = state_71557__$1;
(statearr_71568_71581[(2)] = inst_71542);

(statearr_71568_71581[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_71569 = [null,null,null,null,null,null,null,null];
(statearr_71569[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_71569[(1)] = (1));

return statearr_71569;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_71557){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71557);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71570){var ex__14781__auto__ = e71570;
var statearr_71571_71582 = state_71557;
(statearr_71571_71582[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71557[(4)]))){
var statearr_71572_71583 = state_71557;
(statearr_71572_71583[(1)] = cljs.core.first((state_71557[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71584 = state_71557;
state_71557 = G__71584;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_71557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_71557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71573 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71573[(6)] = c__14852__auto__);

return statearr_71573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq71530){
var G__71531 = cljs.core.first(seq71530);
var seq71530__$1 = cljs.core.next(seq71530);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71531,seq71530__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71610){
var state_val_71611 = (state_71610[(1)]);
if((state_val_71611 === (1))){
var state_71610__$1 = state_71610;
var statearr_71612_71627 = state_71610__$1;
(statearr_71612_71627[(2)] = null);

(statearr_71612_71627[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71611 === (2))){
var _ = (function (){var statearr_71613 = state_71610;
(statearr_71613[(4)] = cljs.core.cons((5),(state_71610[(4)])));

return statearr_71613;
})();
var inst_71591 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71610__$1 = state_71610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71610__$1,(6),inst_71591);
} else {
if((state_val_71611 === (3))){
var inst_71608 = (state_71610[(2)]);
var state_71610__$1 = state_71610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71610__$1,inst_71608);
} else {
if((state_val_71611 === (4))){
var inst_71585 = (state_71610[(2)]);
var state_71610__$1 = state_71610;
var statearr_71615_71628 = state_71610__$1;
(statearr_71615_71628[(2)] = inst_71585);

(statearr_71615_71628[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71611 === (5))){
var _ = (function (){var statearr_71616 = state_71610;
(statearr_71616[(4)] = cljs.core.rest((state_71610[(4)])));

return statearr_71616;
})();
var state_71610__$1 = state_71610;
var ex71614 = (state_71610__$1[(2)]);
var statearr_71617_71629 = state_71610__$1;
(statearr_71617_71629[(5)] = ex71614);


if((ex71614 instanceof Error)){
var statearr_71618_71630 = state_71610__$1;
(statearr_71618_71630[(1)] = (4));

(statearr_71618_71630[(5)] = null);

} else {
throw ex71614;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71611 === (6))){
var inst_71593 = (state_71610[(2)]);
var inst_71594 = fluree.db.util.async.throw_err(inst_71593);
var inst_71595 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_71594);
var inst_71596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71597 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71599 = [inst_71594];
var inst_71600 = (new cljs.core.PersistentVector(null,1,(5),inst_71598,inst_71599,null));
var inst_71601 = ["subs",inst_71600,inst_71595];
var inst_71602 = cljs.core.PersistentHashMap.fromArrays(inst_71597,inst_71601);
var inst_71603 = [inst_71602,(30)];
var inst_71604 = (new cljs.core.PersistentVector(null,2,(5),inst_71596,inst_71603,null));
var inst_71605 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71604);
var _ = (function (){var statearr_71619 = state_71610;
(statearr_71619[(4)] = cljs.core.rest((state_71610[(4)])));

return statearr_71619;
})();
var state_71610__$1 = (function (){var statearr_71620 = state_71610;
(statearr_71620[(7)] = inst_71605);

return statearr_71620;
})();
var statearr_71621_71631 = state_71610__$1;
(statearr_71621_71631[(2)] = inst_71595);

(statearr_71621_71631[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto____0 = (function (){
var statearr_71622 = [null,null,null,null,null,null,null,null];
(statearr_71622[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto__);

(statearr_71622[(1)] = (1));

return statearr_71622;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto____1 = (function (state_71610){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71610);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71623){var ex__14781__auto__ = e71623;
var statearr_71624_71632 = state_71610;
(statearr_71624_71632[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71610[(4)]))){
var statearr_71625_71633 = state_71610;
(statearr_71625_71633[(1)] = cljs.core.first((state_71610[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71634 = state_71610;
state_71610 = G__71634;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto__ = function(state_71610){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto____1.call(this,state_71610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71626 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71626[(6)] = c__14852__auto__);

return statearr_71626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71664){
var state_val_71665 = (state_71664[(1)]);
if((state_val_71665 === (7))){
var state_71664__$1 = state_71664;
var statearr_71666_71685 = state_71664__$1;
(statearr_71666_71685[(2)] = str);

(statearr_71666_71685[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71665 === (1))){
var state_71664__$1 = state_71664;
var statearr_71667_71686 = state_71664__$1;
(statearr_71667_71686[(2)] = null);

(statearr_71667_71686[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71665 === (4))){
var inst_71635 = (state_71664[(2)]);
var state_71664__$1 = state_71664;
var statearr_71668_71687 = state_71664__$1;
(statearr_71668_71687[(2)] = inst_71635);

(statearr_71668_71687[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71665 === (6))){
var state_71664__$1 = state_71664;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71664__$1,(9),str);
} else {
if((state_val_71665 === (3))){
var inst_71662 = (state_71664[(2)]);
var state_71664__$1 = state_71664;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71664__$1,inst_71662);
} else {
if((state_val_71665 === (2))){
var _ = (function (){var statearr_71670 = state_71664;
(statearr_71670[(4)] = cljs.core.cons((5),(state_71664[(4)])));

return statearr_71670;
})();
var inst_71641 = fluree.db.util.async.channel_QMARK_(str);
var state_71664__$1 = state_71664;
if(inst_71641){
var statearr_71671_71688 = state_71664__$1;
(statearr_71671_71688[(1)] = (6));

} else {
var statearr_71672_71689 = state_71664__$1;
(statearr_71672_71689[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71665 === (9))){
var inst_71644 = (state_71664[(2)]);
var inst_71645 = fluree.db.util.async.throw_err(inst_71644);
var state_71664__$1 = state_71664;
var statearr_71673_71690 = state_71664__$1;
(statearr_71673_71690[(2)] = inst_71645);

(statearr_71673_71690[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71665 === (5))){
var _ = (function (){var statearr_71674 = state_71664;
(statearr_71674[(4)] = cljs.core.rest((state_71664[(4)])));

return statearr_71674;
})();
var state_71664__$1 = state_71664;
var ex71669 = (state_71664__$1[(2)]);
var statearr_71675_71691 = state_71664__$1;
(statearr_71675_71691[(5)] = ex71669);


if((ex71669 instanceof Error)){
var statearr_71676_71692 = state_71664__$1;
(statearr_71676_71692[(1)] = (4));

(statearr_71676_71692[(5)] = null);

} else {
throw ex71669;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71665 === (8))){
var inst_71648 = (state_71664[(2)]);
var inst_71649 = fluree.db.dbfunctions.internal.lower_case(inst_71648);
var inst_71650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71651 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71653 = [inst_71648];
var inst_71654 = (new cljs.core.PersistentVector(null,1,(5),inst_71652,inst_71653,null));
var inst_71655 = ["lower-case",inst_71654,inst_71649];
var inst_71656 = cljs.core.PersistentHashMap.fromArrays(inst_71651,inst_71655);
var inst_71657 = [inst_71656,(10)];
var inst_71658 = (new cljs.core.PersistentVector(null,2,(5),inst_71650,inst_71657,null));
var inst_71659 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71658);
var _ = (function (){var statearr_71677 = state_71664;
(statearr_71677[(4)] = cljs.core.rest((state_71664[(4)])));

return statearr_71677;
})();
var state_71664__$1 = (function (){var statearr_71678 = state_71664;
(statearr_71678[(7)] = inst_71659);

return statearr_71678;
})();
var statearr_71679_71693 = state_71664__$1;
(statearr_71679_71693[(2)] = inst_71649);

(statearr_71679_71693[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto____0 = (function (){
var statearr_71680 = [null,null,null,null,null,null,null,null];
(statearr_71680[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto__);

(statearr_71680[(1)] = (1));

return statearr_71680;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto____1 = (function (state_71664){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71664);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71681){var ex__14781__auto__ = e71681;
var statearr_71682_71694 = state_71664;
(statearr_71682_71694[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71664[(4)]))){
var statearr_71683_71695 = state_71664;
(statearr_71683_71695[(1)] = cljs.core.first((state_71664[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71696 = state_71664;
state_71664 = G__71696;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto__ = function(state_71664){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto____1.call(this,state_71664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71684 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71684[(6)] = c__14852__auto__);

return statearr_71684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71726){
var state_val_71727 = (state_71726[(1)]);
if((state_val_71727 === (7))){
var state_71726__$1 = state_71726;
var statearr_71728_71747 = state_71726__$1;
(statearr_71728_71747[(2)] = str);

(statearr_71728_71747[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (1))){
var state_71726__$1 = state_71726;
var statearr_71729_71748 = state_71726__$1;
(statearr_71729_71748[(2)] = null);

(statearr_71729_71748[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (4))){
var inst_71697 = (state_71726[(2)]);
var state_71726__$1 = state_71726;
var statearr_71730_71749 = state_71726__$1;
(statearr_71730_71749[(2)] = inst_71697);

(statearr_71730_71749[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (6))){
var state_71726__$1 = state_71726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71726__$1,(9),str);
} else {
if((state_val_71727 === (3))){
var inst_71724 = (state_71726[(2)]);
var state_71726__$1 = state_71726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71726__$1,inst_71724);
} else {
if((state_val_71727 === (2))){
var _ = (function (){var statearr_71732 = state_71726;
(statearr_71732[(4)] = cljs.core.cons((5),(state_71726[(4)])));

return statearr_71732;
})();
var inst_71703 = fluree.db.util.async.channel_QMARK_(str);
var state_71726__$1 = state_71726;
if(inst_71703){
var statearr_71733_71750 = state_71726__$1;
(statearr_71733_71750[(1)] = (6));

} else {
var statearr_71734_71751 = state_71726__$1;
(statearr_71734_71751[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (9))){
var inst_71706 = (state_71726[(2)]);
var inst_71707 = fluree.db.util.async.throw_err(inst_71706);
var state_71726__$1 = state_71726;
var statearr_71735_71752 = state_71726__$1;
(statearr_71735_71752[(2)] = inst_71707);

(statearr_71735_71752[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (5))){
var _ = (function (){var statearr_71736 = state_71726;
(statearr_71736[(4)] = cljs.core.rest((state_71726[(4)])));

return statearr_71736;
})();
var state_71726__$1 = state_71726;
var ex71731 = (state_71726__$1[(2)]);
var statearr_71737_71753 = state_71726__$1;
(statearr_71737_71753[(5)] = ex71731);


if((ex71731 instanceof Error)){
var statearr_71738_71754 = state_71726__$1;
(statearr_71738_71754[(1)] = (4));

(statearr_71738_71754[(5)] = null);

} else {
throw ex71731;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (8))){
var inst_71710 = (state_71726[(2)]);
var inst_71711 = fluree.db.dbfunctions.internal.upper_case(inst_71710);
var inst_71712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71713 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71715 = [inst_71710];
var inst_71716 = (new cljs.core.PersistentVector(null,1,(5),inst_71714,inst_71715,null));
var inst_71717 = ["upper-case",inst_71716,inst_71711];
var inst_71718 = cljs.core.PersistentHashMap.fromArrays(inst_71713,inst_71717);
var inst_71719 = [inst_71718,(10)];
var inst_71720 = (new cljs.core.PersistentVector(null,2,(5),inst_71712,inst_71719,null));
var inst_71721 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71720);
var _ = (function (){var statearr_71739 = state_71726;
(statearr_71739[(4)] = cljs.core.rest((state_71726[(4)])));

return statearr_71739;
})();
var state_71726__$1 = (function (){var statearr_71740 = state_71726;
(statearr_71740[(7)] = inst_71721);

return statearr_71740;
})();
var statearr_71741_71755 = state_71726__$1;
(statearr_71741_71755[(2)] = inst_71711);

(statearr_71741_71755[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto____0 = (function (){
var statearr_71742 = [null,null,null,null,null,null,null,null];
(statearr_71742[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto__);

(statearr_71742[(1)] = (1));

return statearr_71742;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto____1 = (function (state_71726){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71726);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71743){var ex__14781__auto__ = e71743;
var statearr_71744_71756 = state_71726;
(statearr_71744_71756[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71726[(4)]))){
var statearr_71745_71757 = state_71726;
(statearr_71745_71757[(1)] = cljs.core.first((state_71726[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71758 = state_71726;
state_71726 = G__71758;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto__ = function(state_71726){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto____1.call(this,state_71726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71746 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71746[(6)] = c__14852__auto__);

return statearr_71746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4221__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4221__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__71760 = arguments.length;
switch (G__71760) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71788){
var state_val_71789 = (state_71788[(1)]);
if((state_val_71789 === (1))){
var state_71788__$1 = state_71788;
var statearr_71790_71806 = state_71788__$1;
(statearr_71790_71806[(2)] = null);

(statearr_71790_71806[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71789 === (2))){
var _ = (function (){var statearr_71791 = state_71788;
(statearr_71791[(4)] = cljs.core.cons((5),(state_71788[(4)])));

return statearr_71791;
})();
var inst_71770 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_71788__$1 = state_71788;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71788__$1,(6),inst_71770);
} else {
if((state_val_71789 === (3))){
var inst_71786 = (state_71788[(2)]);
var state_71788__$1 = state_71788;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71788__$1,inst_71786);
} else {
if((state_val_71789 === (4))){
var inst_71761 = (state_71788[(2)]);
var state_71788__$1 = state_71788;
var statearr_71793_71807 = state_71788__$1;
(statearr_71793_71807[(2)] = inst_71761);

(statearr_71793_71807[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71789 === (5))){
var _ = (function (){var statearr_71794 = state_71788;
(statearr_71794[(4)] = cljs.core.rest((state_71788[(4)])));

return statearr_71794;
})();
var state_71788__$1 = state_71788;
var ex71792 = (state_71788__$1[(2)]);
var statearr_71795_71808 = state_71788__$1;
(statearr_71795_71808[(5)] = ex71792);


if((ex71792 instanceof Error)){
var statearr_71796_71809 = state_71788__$1;
(statearr_71796_71809[(1)] = (4));

(statearr_71796_71809[(5)] = null);

} else {
throw ex71792;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71789 === (6))){
var inst_71772 = (state_71788[(2)]);
var inst_71773 = fluree.db.util.async.throw_err(inst_71772);
var inst_71774 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71773,(0),null);
var inst_71775 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71773,(1),null);
var inst_71776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71777 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71778 = ["?s","?ctx",inst_71774];
var inst_71779 = cljs.core.PersistentHashMap.fromArrays(inst_71777,inst_71778);
var inst_71780 = ((10) + inst_71775);
var inst_71781 = [inst_71779,inst_71780];
var inst_71782 = (new cljs.core.PersistentVector(null,2,(5),inst_71776,inst_71781,null));
var inst_71783 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71782);
var _ = (function (){var statearr_71797 = state_71788;
(statearr_71797[(4)] = cljs.core.rest((state_71788[(4)])));

return statearr_71797;
})();
var state_71788__$1 = (function (){var statearr_71798 = state_71788;
(statearr_71798[(7)] = inst_71783);

return statearr_71798;
})();
var statearr_71799_71810 = state_71788__$1;
(statearr_71799_71810[(2)] = inst_71774);

(statearr_71799_71810[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_71800 = [null,null,null,null,null,null,null,null];
(statearr_71800[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_71800[(1)] = (1));

return statearr_71800;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_71788){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71788);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71801){var ex__14781__auto__ = e71801;
var statearr_71802_71811 = state_71788;
(statearr_71802_71811[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71788[(4)]))){
var statearr_71803_71812 = state_71788;
(statearr_71803_71812[(1)] = cljs.core.first((state_71788[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71813 = state_71788;
state_71788 = G__71813;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_71788){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_71788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71804 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71804[(6)] = c__14852__auto__);

return statearr_71804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__71815 = arguments.length;
switch (G__71815) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71853){
var state_val_71854 = (state_71853[(1)]);
if((state_val_71854 === (7))){
var inst_71846 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_71853__$1 = state_71853;
var statearr_71855_71875 = state_71853__$1;
(statearr_71855_71875[(2)] = inst_71846);

(statearr_71855_71875[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71854 === (1))){
var state_71853__$1 = state_71853;
var statearr_71856_71876 = state_71853__$1;
(statearr_71856_71876[(2)] = null);

(statearr_71856_71876[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71854 === (4))){
var inst_71816 = (state_71853[(2)]);
var state_71853__$1 = state_71853;
var statearr_71857_71877 = state_71853__$1;
(statearr_71857_71877[(2)] = inst_71816);

(statearr_71857_71877[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71854 === (6))){
var inst_71827 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_71853__$1 = state_71853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71853__$1,(10),inst_71827);
} else {
if((state_val_71854 === (3))){
var inst_71851 = (state_71853[(2)]);
var state_71853__$1 = state_71853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71853__$1,inst_71851);
} else {
if((state_val_71854 === (2))){
var _ = (function (){var statearr_71859 = state_71853;
(statearr_71859[(4)] = cljs.core.cons((5),(state_71853[(4)])));

return statearr_71859;
})();
var inst_71822 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71853__$1 = state_71853;
if(cljs.core.truth_(inst_71822)){
var statearr_71860_71878 = state_71853__$1;
(statearr_71860_71878[(1)] = (6));

} else {
var statearr_71861_71879 = state_71853__$1;
(statearr_71861_71879[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71854 === (9))){
var inst_71833 = (state_71853[(2)]);
var inst_71834 = fluree.db.util.async.throw_err(inst_71833);
var inst_71835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71834,(0),null);
var inst_71836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71834,(1),null);
var inst_71837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71838 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71839 = ["?p","?ctx",inst_71835];
var inst_71840 = cljs.core.PersistentHashMap.fromArrays(inst_71838,inst_71839);
var inst_71841 = ((10) + inst_71836);
var inst_71842 = [inst_71840,inst_71841];
var inst_71843 = (new cljs.core.PersistentVector(null,2,(5),inst_71837,inst_71842,null));
var inst_71844 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71843);
var state_71853__$1 = (function (){var statearr_71862 = state_71853;
(statearr_71862[(7)] = inst_71844);

return statearr_71862;
})();
var statearr_71863_71880 = state_71853__$1;
(statearr_71863_71880[(2)] = inst_71835);

(statearr_71863_71880[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71854 === (5))){
var _ = (function (){var statearr_71864 = state_71853;
(statearr_71864[(4)] = cljs.core.rest((state_71853[(4)])));

return statearr_71864;
})();
var state_71853__$1 = state_71853;
var ex71858 = (state_71853__$1[(2)]);
var statearr_71865_71881 = state_71853__$1;
(statearr_71865_71881[(5)] = ex71858);


if((ex71858 instanceof Error)){
var statearr_71866_71882 = state_71853__$1;
(statearr_71866_71882[(1)] = (4));

(statearr_71866_71882[(5)] = null);

} else {
throw ex71858;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71854 === (10))){
var inst_71829 = (state_71853[(2)]);
var inst_71830 = fluree.db.util.async.throw_err(inst_71829);
var inst_71831 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_71830);
var state_71853__$1 = state_71853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71853__$1,(9),inst_71831);
} else {
if((state_val_71854 === (8))){
var inst_71848 = (state_71853[(2)]);
var _ = (function (){var statearr_71867 = state_71853;
(statearr_71867[(4)] = cljs.core.rest((state_71853[(4)])));

return statearr_71867;
})();
var state_71853__$1 = state_71853;
var statearr_71868_71883 = state_71853__$1;
(statearr_71868_71883[(2)] = inst_71848);

(statearr_71868_71883[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_71869 = [null,null,null,null,null,null,null,null];
(statearr_71869[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_71869[(1)] = (1));

return statearr_71869;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_71853){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71853);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71870){var ex__14781__auto__ = e71870;
var statearr_71871_71884 = state_71853;
(statearr_71871_71884[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71853[(4)]))){
var statearr_71872_71885 = state_71853;
(statearr_71872_71885[(1)] = cljs.core.first((state_71853[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71886 = state_71853;
state_71853 = G__71886;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_71853){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_71853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71873 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71873[(6)] = c__14852__auto__);

return statearr_71873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___71935 = arguments.length;
var i__4830__auto___71936 = (0);
while(true){
if((i__4830__auto___71936 < len__4829__auto___71935)){
args__4835__auto__.push((arguments[i__4830__auto___71936]));

var G__71937 = (i__4830__auto___71936 + (1));
i__4830__auto___71936 = G__71937;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71918){
var state_val_71919 = (state_71918[(1)]);
if((state_val_71919 === (1))){
var state_71918__$1 = state_71918;
var statearr_71920_71938 = state_71918__$1;
(statearr_71920_71938[(2)] = null);

(statearr_71920_71938[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71919 === (2))){
var _ = (function (){var statearr_71921 = state_71918;
(statearr_71921[(4)] = cljs.core.cons((5),(state_71918[(4)])));

return statearr_71921;
})();
var inst_71895 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71918__$1 = state_71918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71918__$1,(6),inst_71895);
} else {
if((state_val_71919 === (3))){
var inst_71916 = (state_71918[(2)]);
var state_71918__$1 = state_71918;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71918__$1,inst_71916);
} else {
if((state_val_71919 === (4))){
var inst_71889 = (state_71918[(2)]);
var state_71918__$1 = state_71918;
var statearr_71923_71939 = state_71918__$1;
(statearr_71923_71939[(2)] = inst_71889);

(statearr_71923_71939[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71919 === (5))){
var _ = (function (){var statearr_71924 = state_71918;
(statearr_71924[(4)] = cljs.core.rest((state_71918[(4)])));

return statearr_71924;
})();
var state_71918__$1 = state_71918;
var ex71922 = (state_71918__$1[(2)]);
var statearr_71925_71940 = state_71918__$1;
(statearr_71925_71940[(5)] = ex71922);


if((ex71922 instanceof Error)){
var statearr_71926_71941 = state_71918__$1;
(statearr_71926_71941[(1)] = (4));

(statearr_71926_71941[(5)] = null);

} else {
throw ex71922;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71919 === (6))){
var inst_71897 = (state_71918[(2)]);
var inst_71898 = fluree.db.util.async.throw_err(inst_71897);
var inst_71899 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_71898);
var inst_71900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71901 = [inst_71898];
var inst_71902 = (new cljs.core.PersistentVector(null,1,(5),inst_71900,inst_71901,null));
var inst_71903 = cljs.core.count(inst_71902);
var inst_71904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71905 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71907 = [inst_71898];
var inst_71908 = (new cljs.core.PersistentVector(null,1,(5),inst_71906,inst_71907,null));
var inst_71909 = ["and",inst_71908,inst_71899];
var inst_71910 = cljs.core.PersistentHashMap.fromArrays(inst_71905,inst_71909);
var inst_71911 = [inst_71910,inst_71903];
var inst_71912 = (new cljs.core.PersistentVector(null,2,(5),inst_71904,inst_71911,null));
var inst_71913 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71912);
var _ = (function (){var statearr_71927 = state_71918;
(statearr_71927[(4)] = cljs.core.rest((state_71918[(4)])));

return statearr_71927;
})();
var state_71918__$1 = (function (){var statearr_71928 = state_71918;
(statearr_71928[(7)] = inst_71913);

return statearr_71928;
})();
var statearr_71929_71942 = state_71918__$1;
(statearr_71929_71942[(2)] = inst_71899);

(statearr_71929_71942[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_71930 = [null,null,null,null,null,null,null,null];
(statearr_71930[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_71930[(1)] = (1));

return statearr_71930;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_71918){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71918);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71931){var ex__14781__auto__ = e71931;
var statearr_71932_71943 = state_71918;
(statearr_71932_71943[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71918[(4)]))){
var statearr_71933_71944 = state_71918;
(statearr_71933_71944[(1)] = cljs.core.first((state_71918[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__71945 = state_71918;
state_71918 = G__71945;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_71918){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_71918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71934 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71934[(6)] = c__14852__auto__);

return statearr_71934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq71887){
var G__71888 = cljs.core.first(seq71887);
var seq71887__$1 = cljs.core.next(seq71887);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71888,seq71887__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___71994 = arguments.length;
var i__4830__auto___71995 = (0);
while(true){
if((i__4830__auto___71995 < len__4829__auto___71994)){
args__4835__auto__.push((arguments[i__4830__auto___71995]));

var G__71996 = (i__4830__auto___71995 + (1));
i__4830__auto___71995 = G__71996;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_71977){
var state_val_71978 = (state_71977[(1)]);
if((state_val_71978 === (1))){
var state_71977__$1 = state_71977;
var statearr_71979_71997 = state_71977__$1;
(statearr_71979_71997[(2)] = null);

(statearr_71979_71997[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71978 === (2))){
var _ = (function (){var statearr_71980 = state_71977;
(statearr_71980[(4)] = cljs.core.cons((5),(state_71977[(4)])));

return statearr_71980;
})();
var inst_71954 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71977__$1 = state_71977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71977__$1,(6),inst_71954);
} else {
if((state_val_71978 === (3))){
var inst_71975 = (state_71977[(2)]);
var state_71977__$1 = state_71977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71977__$1,inst_71975);
} else {
if((state_val_71978 === (4))){
var inst_71948 = (state_71977[(2)]);
var state_71977__$1 = state_71977;
var statearr_71982_71998 = state_71977__$1;
(statearr_71982_71998[(2)] = inst_71948);

(statearr_71982_71998[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71978 === (5))){
var _ = (function (){var statearr_71983 = state_71977;
(statearr_71983[(4)] = cljs.core.rest((state_71977[(4)])));

return statearr_71983;
})();
var state_71977__$1 = state_71977;
var ex71981 = (state_71977__$1[(2)]);
var statearr_71984_71999 = state_71977__$1;
(statearr_71984_71999[(5)] = ex71981);


if((ex71981 instanceof Error)){
var statearr_71985_72000 = state_71977__$1;
(statearr_71985_72000[(1)] = (4));

(statearr_71985_72000[(5)] = null);

} else {
throw ex71981;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71978 === (6))){
var inst_71956 = (state_71977[(2)]);
var inst_71957 = fluree.db.util.async.throw_err(inst_71956);
var inst_71958 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_71957);
var inst_71959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71960 = [inst_71957];
var inst_71961 = (new cljs.core.PersistentVector(null,1,(5),inst_71959,inst_71960,null));
var inst_71962 = cljs.core.count(inst_71961);
var inst_71963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71964 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71966 = [inst_71957];
var inst_71967 = (new cljs.core.PersistentVector(null,1,(5),inst_71965,inst_71966,null));
var inst_71968 = ["or",inst_71967,inst_71958];
var inst_71969 = cljs.core.PersistentHashMap.fromArrays(inst_71964,inst_71968);
var inst_71970 = [inst_71969,inst_71962];
var inst_71971 = (new cljs.core.PersistentVector(null,2,(5),inst_71963,inst_71970,null));
var inst_71972 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71971);
var _ = (function (){var statearr_71986 = state_71977;
(statearr_71986[(4)] = cljs.core.rest((state_71977[(4)])));

return statearr_71986;
})();
var state_71977__$1 = (function (){var statearr_71987 = state_71977;
(statearr_71987[(7)] = inst_71972);

return statearr_71987;
})();
var statearr_71988_72001 = state_71977__$1;
(statearr_71988_72001[(2)] = inst_71958);

(statearr_71988_72001[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_71989 = [null,null,null,null,null,null,null,null];
(statearr_71989[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_71989[(1)] = (1));

return statearr_71989;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_71977){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_71977);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e71990){var ex__14781__auto__ = e71990;
var statearr_71991_72002 = state_71977;
(statearr_71991_72002[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_71977[(4)]))){
var statearr_71992_72003 = state_71977;
(statearr_71992_72003[(1)] = cljs.core.first((state_71977[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72004 = state_71977;
state_71977 = G__72004;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_71977){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_71977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_71993 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_71993[(6)] = c__14852__auto__);

return statearr_71993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq71946){
var G__71947 = cljs.core.first(seq71946);
var seq71946__$1 = cljs.core.next(seq71946);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71947,seq71946__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72042){
var state_val_72043 = (state_72042[(1)]);
if((state_val_72043 === (7))){
var inst_72018 = fluree.db.util.async.channel_QMARK_(coll);
var state_72042__$1 = state_72042;
if(inst_72018){
var statearr_72044_72067 = state_72042__$1;
(statearr_72044_72067[(1)] = (10));

} else {
var statearr_72045_72068 = state_72042__$1;
(statearr_72045_72068[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72043 === (1))){
var state_72042__$1 = state_72042;
var statearr_72046_72069 = state_72042__$1;
(statearr_72046_72069[(2)] = null);

(statearr_72046_72069[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72043 === (4))){
var inst_72005 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
var statearr_72047_72070 = state_72042__$1;
(statearr_72047_72070[(2)] = inst_72005);

(statearr_72047_72070[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72043 === (13))){
var inst_72021 = (state_72042[(2)]);
var inst_72022 = fluree.db.util.async.throw_err(inst_72021);
var state_72042__$1 = state_72042;
var statearr_72048_72071 = state_72042__$1;
(statearr_72048_72071[(2)] = inst_72022);

(statearr_72048_72071[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72043 === (6))){
var inst_72013 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_72042__$1 = state_72042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72042__$1,(9),inst_72013);
} else {
if((state_val_72043 === (3))){
var inst_72040 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72042__$1,inst_72040);
} else {
if((state_val_72043 === (12))){
var inst_72025 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
var statearr_72049_72072 = state_72042__$1;
(statearr_72049_72072[(2)] = inst_72025);

(statearr_72049_72072[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72043 === (2))){
var _ = (function (){var statearr_72050 = state_72042;
(statearr_72050[(4)] = cljs.core.cons((5),(state_72042[(4)])));

return statearr_72050;
})();
var inst_72011 = cljs.core.vector_QMARK_(coll);
var state_72042__$1 = state_72042;
if(inst_72011){
var statearr_72051_72073 = state_72042__$1;
(statearr_72051_72073[(1)] = (6));

} else {
var statearr_72052_72074 = state_72042__$1;
(statearr_72052_72074[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72043 === (11))){
var state_72042__$1 = state_72042;
var statearr_72054_72075 = state_72042__$1;
(statearr_72054_72075[(2)] = coll);

(statearr_72054_72075[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72043 === (9))){
var inst_72015 = (state_72042[(2)]);
var inst_72016 = fluree.db.util.async.throw_err(inst_72015);
var state_72042__$1 = state_72042;
var statearr_72055_72076 = state_72042__$1;
(statearr_72055_72076[(2)] = inst_72016);

(statearr_72055_72076[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72043 === (5))){
var _ = (function (){var statearr_72056 = state_72042;
(statearr_72056[(4)] = cljs.core.rest((state_72042[(4)])));

return statearr_72056;
})();
var state_72042__$1 = state_72042;
var ex72053 = (state_72042__$1[(2)]);
var statearr_72057_72077 = state_72042__$1;
(statearr_72057_72077[(5)] = ex72053);


if((ex72053 instanceof Error)){
var statearr_72058_72078 = state_72042__$1;
(statearr_72058_72078[(1)] = (4));

(statearr_72058_72078[(5)] = null);

} else {
throw ex72053;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72043 === (10))){
var state_72042__$1 = state_72042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72042__$1,(13),coll);
} else {
if((state_val_72043 === (8))){
var inst_72027 = (state_72042[(2)]);
var inst_72028 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_72027);
var inst_72029 = cljs.core.count(inst_72028);
var inst_72030 = ((9) + inst_72029);
var inst_72031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72032 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72033 = ["count",inst_72027,inst_72029];
var inst_72034 = cljs.core.PersistentHashMap.fromArrays(inst_72032,inst_72033);
var inst_72035 = [inst_72034,inst_72030];
var inst_72036 = (new cljs.core.PersistentVector(null,2,(5),inst_72031,inst_72035,null));
var inst_72037 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72036);
var _ = (function (){var statearr_72059 = state_72042;
(statearr_72059[(4)] = cljs.core.rest((state_72042[(4)])));

return statearr_72059;
})();
var state_72042__$1 = (function (){var statearr_72060 = state_72042;
(statearr_72060[(7)] = inst_72037);

return statearr_72060;
})();
var statearr_72061_72079 = state_72042__$1;
(statearr_72061_72079[(2)] = inst_72029);

(statearr_72061_72079[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto____0 = (function (){
var statearr_72062 = [null,null,null,null,null,null,null,null];
(statearr_72062[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto__);

(statearr_72062[(1)] = (1));

return statearr_72062;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto____1 = (function (state_72042){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72042);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72063){var ex__14781__auto__ = e72063;
var statearr_72064_72080 = state_72042;
(statearr_72064_72080[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72042[(4)]))){
var statearr_72065_72081 = state_72042;
(statearr_72065_72081[(1)] = cljs.core.first((state_72042[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72082 = state_72042;
state_72042 = G__72082;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto__ = function(state_72042){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto____1.call(this,state_72042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72066 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72066[(6)] = c__14852__auto__);

return statearr_72066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72132){
var state_val_72133 = (state_72132[(1)]);
if((state_val_72133 === (7))){
var state_72132__$1 = state_72132;
var statearr_72134_72167 = state_72132__$1;
(statearr_72134_72167[(2)] = subject);

(statearr_72134_72167[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (1))){
var state_72132__$1 = state_72132;
var statearr_72135_72168 = state_72132__$1;
(statearr_72135_72168[(2)] = null);

(statearr_72135_72168[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (4))){
var inst_72083 = (state_72132[(2)]);
var state_72132__$1 = state_72132;
var statearr_72136_72169 = state_72132__$1;
(statearr_72136_72169[(2)] = inst_72083);

(statearr_72136_72169[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (15))){
var inst_72096 = (state_72132[(7)]);
var state_72132__$1 = state_72132;
var statearr_72137_72170 = state_72132__$1;
(statearr_72137_72170[(2)] = inst_72096);

(statearr_72137_72170[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (13))){
var inst_72100 = (state_72132[(2)]);
var inst_72101 = fluree.db.util.async.throw_err(inst_72100);
var state_72132__$1 = state_72132;
var statearr_72138_72171 = state_72132__$1;
(statearr_72138_72171[(2)] = inst_72101);

(statearr_72138_72171[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (6))){
var state_72132__$1 = state_72132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72132__$1,(9),subject);
} else {
if((state_val_72133 === (17))){
var inst_72096 = (state_72132[(7)]);
var inst_72110 = cljs.core.first(inst_72096);
var state_72132__$1 = state_72132;
var statearr_72139_72172 = state_72132__$1;
(statearr_72139_72172[(2)] = inst_72110);

(statearr_72139_72172[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (3))){
var inst_72130 = (state_72132[(2)]);
var state_72132__$1 = state_72132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72132__$1,inst_72130);
} else {
if((state_val_72133 === (12))){
var inst_72096 = (state_72132[(7)]);
var inst_72104 = (state_72132[(2)]);
var inst_72105 = cljs.core.vector_QMARK_(inst_72096);
var state_72132__$1 = (function (){var statearr_72140 = state_72132;
(statearr_72140[(8)] = inst_72104);

return statearr_72140;
})();
if(inst_72105){
var statearr_72141_72173 = state_72132__$1;
(statearr_72141_72173[(1)] = (14));

} else {
var statearr_72142_72174 = state_72132__$1;
(statearr_72142_72174[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (2))){
var _ = (function (){var statearr_72143 = state_72132;
(statearr_72143[(4)] = cljs.core.cons((5),(state_72132[(4)])));

return statearr_72143;
})();
var inst_72089 = fluree.db.util.async.channel_QMARK_(subject);
var state_72132__$1 = state_72132;
if(inst_72089){
var statearr_72144_72175 = state_72132__$1;
(statearr_72144_72175[(1)] = (6));

} else {
var statearr_72145_72176 = state_72132__$1;
(statearr_72145_72176[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (19))){
var inst_72113 = (state_72132[(2)]);
var state_72132__$1 = state_72132;
var statearr_72146_72177 = state_72132__$1;
(statearr_72146_72177[(2)] = inst_72113);

(statearr_72146_72177[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (11))){
var state_72132__$1 = state_72132;
var statearr_72148_72178 = state_72132__$1;
(statearr_72148_72178[(2)] = pred);

(statearr_72148_72178[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (9))){
var inst_72092 = (state_72132[(2)]);
var inst_72093 = fluree.db.util.async.throw_err(inst_72092);
var state_72132__$1 = state_72132;
var statearr_72149_72179 = state_72132__$1;
(statearr_72149_72179[(2)] = inst_72093);

(statearr_72149_72179[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (5))){
var _ = (function (){var statearr_72150 = state_72132;
(statearr_72150[(4)] = cljs.core.rest((state_72132[(4)])));

return statearr_72150;
})();
var state_72132__$1 = state_72132;
var ex72147 = (state_72132__$1[(2)]);
var statearr_72151_72180 = state_72132__$1;
(statearr_72151_72180[(5)] = ex72147);


if((ex72147 instanceof Error)){
var statearr_72152_72181 = state_72132__$1;
(statearr_72152_72181[(1)] = (4));

(statearr_72152_72181[(5)] = null);

} else {
throw ex72147;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (14))){
var inst_72096 = (state_72132[(7)]);
var inst_72107 = cljs.core.count(inst_72096);
var inst_72108 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_72107);
var state_72132__$1 = state_72132;
if(inst_72108){
var statearr_72153_72182 = state_72132__$1;
(statearr_72153_72182[(1)] = (17));

} else {
var statearr_72154_72183 = state_72132__$1;
(statearr_72154_72183[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (16))){
var inst_72104 = (state_72132[(8)]);
var inst_72096 = (state_72132[(7)]);
var inst_72116 = (state_72132[(2)]);
var inst_72117 = fluree.db.dbfunctions.internal.get(inst_72116,inst_72104);
var inst_72118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72119 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72121 = [inst_72096,inst_72104];
var inst_72122 = (new cljs.core.PersistentVector(null,2,(5),inst_72120,inst_72121,null));
var inst_72123 = ["get",inst_72122,inst_72117];
var inst_72124 = cljs.core.PersistentHashMap.fromArrays(inst_72119,inst_72123);
var inst_72125 = [inst_72124,(10)];
var inst_72126 = (new cljs.core.PersistentVector(null,2,(5),inst_72118,inst_72125,null));
var inst_72127 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72126);
var _ = (function (){var statearr_72155 = state_72132;
(statearr_72155[(4)] = cljs.core.rest((state_72132[(4)])));

return statearr_72155;
})();
var state_72132__$1 = (function (){var statearr_72156 = state_72132;
(statearr_72156[(9)] = inst_72127);

return statearr_72156;
})();
var statearr_72157_72184 = state_72132__$1;
(statearr_72157_72184[(2)] = inst_72117);

(statearr_72157_72184[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (10))){
var state_72132__$1 = state_72132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72132__$1,(13),pred);
} else {
if((state_val_72133 === (18))){
var inst_72096 = (state_72132[(7)]);
var state_72132__$1 = state_72132;
var statearr_72158_72185 = state_72132__$1;
(statearr_72158_72185[(2)] = inst_72096);

(statearr_72158_72185[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72133 === (8))){
var inst_72096 = (state_72132[(2)]);
var inst_72097 = fluree.db.util.async.channel_QMARK_(pred);
var state_72132__$1 = (function (){var statearr_72159 = state_72132;
(statearr_72159[(7)] = inst_72096);

return statearr_72159;
})();
if(inst_72097){
var statearr_72160_72186 = state_72132__$1;
(statearr_72160_72186[(1)] = (10));

} else {
var statearr_72161_72187 = state_72132__$1;
(statearr_72161_72187[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto____0 = (function (){
var statearr_72162 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72162[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto__);

(statearr_72162[(1)] = (1));

return statearr_72162;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto____1 = (function (state_72132){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72132);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72163){var ex__14781__auto__ = e72163;
var statearr_72164_72188 = state_72132;
(statearr_72164_72188[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72132[(4)]))){
var statearr_72165_72189 = state_72132;
(statearr_72165_72189[(1)] = cljs.core.first((state_72132[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72190 = state_72132;
state_72132 = G__72190;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto__ = function(state_72132){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto____1.call(this,state_72132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72166 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72166[(6)] = c__14852__auto__);

return statearr_72166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72229){
var state_val_72230 = (state_72229[(1)]);
if((state_val_72230 === (7))){
var inst_72197 = (state_72229[(7)]);
var state_72229__$1 = state_72229;
var statearr_72231_72255 = state_72229__$1;
(statearr_72231_72255[(2)] = inst_72197);

(statearr_72231_72255[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72230 === (1))){
var state_72229__$1 = state_72229;
var statearr_72232_72256 = state_72229__$1;
(statearr_72232_72256[(2)] = null);

(statearr_72232_72256[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72230 === (4))){
var inst_72191 = (state_72229[(2)]);
var state_72229__$1 = state_72229;
var statearr_72233_72257 = state_72229__$1;
(statearr_72233_72257[(2)] = inst_72191);

(statearr_72233_72257[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72230 === (6))){
var inst_72199 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72229__$1 = state_72229;
var statearr_72234_72258 = state_72229__$1;
(statearr_72234_72258[(2)] = inst_72199);

(statearr_72234_72258[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72230 === (3))){
var inst_72227 = (state_72229[(2)]);
var state_72229__$1 = state_72229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72229__$1,inst_72227);
} else {
if((state_val_72230 === (12))){
var inst_72209 = (state_72229[(2)]);
var inst_72210 = fluree.db.util.async.throw_err(inst_72209);
var inst_72211 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72210,(0),null);
var inst_72212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72210,(1),null);
var inst_72213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72214 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72215 = ["?pO","?ctx",inst_72211];
var inst_72216 = cljs.core.PersistentHashMap.fromArrays(inst_72214,inst_72215);
var inst_72217 = ((10) + inst_72212);
var inst_72218 = [inst_72216,inst_72217];
var inst_72219 = (new cljs.core.PersistentVector(null,2,(5),inst_72213,inst_72218,null));
var inst_72220 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72219);
var state_72229__$1 = (function (){var statearr_72235 = state_72229;
(statearr_72235[(8)] = inst_72220);

return statearr_72235;
})();
var statearr_72236_72259 = state_72229__$1;
(statearr_72236_72259[(2)] = inst_72211);

(statearr_72236_72259[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72230 === (2))){
var inst_72197 = (state_72229[(7)]);
var _ = (function (){var statearr_72237 = state_72229;
(statearr_72237[(4)] = cljs.core.cons((5),(state_72229[(4)])));

return statearr_72237;
})();
var inst_72197__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72229__$1 = (function (){var statearr_72238 = state_72229;
(statearr_72238[(7)] = inst_72197__$1);

return statearr_72238;
})();
if(cljs.core.truth_(inst_72197__$1)){
var statearr_72239_72260 = state_72229__$1;
(statearr_72239_72260[(1)] = (6));

} else {
var statearr_72240_72261 = state_72229__$1;
(statearr_72240_72261[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72230 === (11))){
var inst_72224 = (state_72229[(2)]);
var _ = (function (){var statearr_72242 = state_72229;
(statearr_72242[(4)] = cljs.core.rest((state_72229[(4)])));

return statearr_72242;
})();
var state_72229__$1 = state_72229;
var statearr_72243_72262 = state_72229__$1;
(statearr_72243_72262[(2)] = inst_72224);

(statearr_72243_72262[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72230 === (9))){
var inst_72207 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_72229__$1 = state_72229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72229__$1,(12),inst_72207);
} else {
if((state_val_72230 === (5))){
var _ = (function (){var statearr_72244 = state_72229;
(statearr_72244[(4)] = cljs.core.rest((state_72229[(4)])));

return statearr_72244;
})();
var state_72229__$1 = state_72229;
var ex72241 = (state_72229__$1[(2)]);
var statearr_72245_72263 = state_72229__$1;
(statearr_72245_72263[(5)] = ex72241);


if((ex72241 instanceof Error)){
var statearr_72246_72264 = state_72229__$1;
(statearr_72246_72264[(1)] = (4));

(statearr_72246_72264[(5)] = null);

} else {
throw ex72241;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72230 === (10))){
var inst_72222 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_72229__$1 = state_72229;
var statearr_72247_72265 = state_72229__$1;
(statearr_72247_72265[(2)] = inst_72222);

(statearr_72247_72265[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72230 === (8))){
var inst_72202 = (state_72229[(2)]);
var state_72229__$1 = state_72229;
if(cljs.core.truth_(inst_72202)){
var statearr_72248_72266 = state_72229__$1;
(statearr_72248_72266[(1)] = (9));

} else {
var statearr_72249_72267 = state_72229__$1;
(statearr_72249_72267[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto____0 = (function (){
var statearr_72250 = [null,null,null,null,null,null,null,null,null];
(statearr_72250[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto__);

(statearr_72250[(1)] = (1));

return statearr_72250;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto____1 = (function (state_72229){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72229);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72251){var ex__14781__auto__ = e72251;
var statearr_72252_72268 = state_72229;
(statearr_72252_72268[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72229[(4)]))){
var statearr_72253_72269 = state_72229;
(statearr_72253_72269[(1)] = cljs.core.first((state_72229[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72270 = state_72229;
state_72229 = G__72270;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto__ = function(state_72229){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto____1.call(this,state_72229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72254 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72254[(6)] = c__14852__auto__);

return statearr_72254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72322){
var state_val_72323 = (state_72322[(1)]);
if((state_val_72323 === (7))){
var state_72322__$1 = state_72322;
var statearr_72324_72357 = state_72322__$1;
(statearr_72324_72357[(2)] = subject);

(statearr_72324_72357[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (1))){
var state_72322__$1 = state_72322;
var statearr_72325_72358 = state_72322__$1;
(statearr_72325_72358[(2)] = null);

(statearr_72325_72358[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (4))){
var inst_72271 = (state_72322[(2)]);
var state_72322__$1 = state_72322;
var statearr_72326_72359 = state_72322__$1;
(statearr_72326_72359[(2)] = inst_72271);

(statearr_72326_72359[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (15))){
var inst_72284 = (state_72322[(7)]);
var state_72322__$1 = state_72322;
var statearr_72327_72360 = state_72322__$1;
(statearr_72327_72360[(2)] = inst_72284);

(statearr_72327_72360[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (13))){
var inst_72288 = (state_72322[(2)]);
var inst_72289 = fluree.db.util.async.throw_err(inst_72288);
var state_72322__$1 = state_72322;
var statearr_72328_72361 = state_72322__$1;
(statearr_72328_72361[(2)] = inst_72289);

(statearr_72328_72361[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (6))){
var state_72322__$1 = state_72322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72322__$1,(9),subject);
} else {
if((state_val_72323 === (17))){
var inst_72284 = (state_72322[(7)]);
var inst_72298 = cljs.core.first(inst_72284);
var state_72322__$1 = state_72322;
var statearr_72329_72362 = state_72322__$1;
(statearr_72329_72362[(2)] = inst_72298);

(statearr_72329_72362[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (3))){
var inst_72320 = (state_72322[(2)]);
var state_72322__$1 = state_72322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72322__$1,inst_72320);
} else {
if((state_val_72323 === (12))){
var inst_72284 = (state_72322[(7)]);
var inst_72292 = (state_72322[(2)]);
var inst_72293 = cljs.core.vector_QMARK_(inst_72284);
var state_72322__$1 = (function (){var statearr_72330 = state_72322;
(statearr_72330[(8)] = inst_72292);

return statearr_72330;
})();
if(inst_72293){
var statearr_72331_72363 = state_72322__$1;
(statearr_72331_72363[(1)] = (14));

} else {
var statearr_72332_72364 = state_72322__$1;
(statearr_72332_72364[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (2))){
var _ = (function (){var statearr_72333 = state_72322;
(statearr_72333[(4)] = cljs.core.cons((5),(state_72322[(4)])));

return statearr_72333;
})();
var inst_72277 = fluree.db.util.async.channel_QMARK_(subject);
var state_72322__$1 = state_72322;
if(inst_72277){
var statearr_72334_72365 = state_72322__$1;
(statearr_72334_72365[(1)] = (6));

} else {
var statearr_72335_72366 = state_72322__$1;
(statearr_72335_72366[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (19))){
var inst_72301 = (state_72322[(2)]);
var state_72322__$1 = state_72322;
var statearr_72336_72367 = state_72322__$1;
(statearr_72336_72367[(2)] = inst_72301);

(statearr_72336_72367[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (11))){
var state_72322__$1 = state_72322;
var statearr_72338_72368 = state_72322__$1;
(statearr_72338_72368[(2)] = path);

(statearr_72338_72368[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (9))){
var inst_72280 = (state_72322[(2)]);
var inst_72281 = fluree.db.util.async.throw_err(inst_72280);
var state_72322__$1 = state_72322;
var statearr_72339_72369 = state_72322__$1;
(statearr_72339_72369[(2)] = inst_72281);

(statearr_72339_72369[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (5))){
var _ = (function (){var statearr_72340 = state_72322;
(statearr_72340[(4)] = cljs.core.rest((state_72322[(4)])));

return statearr_72340;
})();
var state_72322__$1 = state_72322;
var ex72337 = (state_72322__$1[(2)]);
var statearr_72341_72370 = state_72322__$1;
(statearr_72341_72370[(5)] = ex72337);


if((ex72337 instanceof Error)){
var statearr_72342_72371 = state_72322__$1;
(statearr_72342_72371[(1)] = (4));

(statearr_72342_72371[(5)] = null);

} else {
throw ex72337;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (14))){
var inst_72284 = (state_72322[(7)]);
var inst_72295 = cljs.core.count(inst_72284);
var inst_72296 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_72295);
var state_72322__$1 = state_72322;
if(inst_72296){
var statearr_72343_72372 = state_72322__$1;
(statearr_72343_72372[(1)] = (17));

} else {
var statearr_72344_72373 = state_72322__$1;
(statearr_72344_72373[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (16))){
var inst_72292 = (state_72322[(8)]);
var inst_72284 = (state_72322[(7)]);
var inst_72304 = (state_72322[(2)]);
var inst_72305 = fluree.db.dbfunctions.internal.get_all(inst_72304,inst_72292);
var inst_72306 = cljs.core.count(inst_72292);
var inst_72307 = ((9) + inst_72306);
var inst_72308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72309 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72311 = [inst_72284,inst_72292];
var inst_72312 = (new cljs.core.PersistentVector(null,2,(5),inst_72310,inst_72311,null));
var inst_72313 = ["get-all",inst_72312,inst_72305];
var inst_72314 = cljs.core.PersistentHashMap.fromArrays(inst_72309,inst_72313);
var inst_72315 = [inst_72314,inst_72307];
var inst_72316 = (new cljs.core.PersistentVector(null,2,(5),inst_72308,inst_72315,null));
var inst_72317 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72316);
var _ = (function (){var statearr_72345 = state_72322;
(statearr_72345[(4)] = cljs.core.rest((state_72322[(4)])));

return statearr_72345;
})();
var state_72322__$1 = (function (){var statearr_72346 = state_72322;
(statearr_72346[(9)] = inst_72317);

return statearr_72346;
})();
var statearr_72347_72374 = state_72322__$1;
(statearr_72347_72374[(2)] = inst_72305);

(statearr_72347_72374[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (10))){
var state_72322__$1 = state_72322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72322__$1,(13),path);
} else {
if((state_val_72323 === (18))){
var inst_72284 = (state_72322[(7)]);
var state_72322__$1 = state_72322;
var statearr_72348_72375 = state_72322__$1;
(statearr_72348_72375[(2)] = inst_72284);

(statearr_72348_72375[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72323 === (8))){
var inst_72284 = (state_72322[(2)]);
var inst_72285 = fluree.db.util.async.channel_QMARK_(path);
var state_72322__$1 = (function (){var statearr_72349 = state_72322;
(statearr_72349[(7)] = inst_72284);

return statearr_72349;
})();
if(inst_72285){
var statearr_72350_72376 = state_72322__$1;
(statearr_72350_72376[(1)] = (10));

} else {
var statearr_72351_72377 = state_72322__$1;
(statearr_72351_72377[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto____0 = (function (){
var statearr_72352 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72352[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto__);

(statearr_72352[(1)] = (1));

return statearr_72352;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto____1 = (function (state_72322){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72322);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72353){var ex__14781__auto__ = e72353;
var statearr_72354_72378 = state_72322;
(statearr_72354_72378[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72322[(4)]))){
var statearr_72355_72379 = state_72322;
(statearr_72355_72379[(1)] = cljs.core.first((state_72322[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72380 = state_72322;
state_72322 = G__72380;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto__ = function(state_72322){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto____1.call(this,state_72322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72356 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72356[(6)] = c__14852__auto__);

return statearr_72356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72419){
var state_val_72420 = (state_72419[(1)]);
if((state_val_72420 === (7))){
var state_72419__$1 = state_72419;
var statearr_72421_72445 = state_72419__$1;
(statearr_72421_72445[(2)] = subject);

(statearr_72421_72445[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72420 === (1))){
var state_72419__$1 = state_72419;
var statearr_72422_72446 = state_72419__$1;
(statearr_72422_72446[(2)] = null);

(statearr_72422_72446[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72420 === (4))){
var inst_72381 = (state_72419[(2)]);
var state_72419__$1 = state_72419;
var statearr_72423_72447 = state_72419__$1;
(statearr_72423_72447[(2)] = inst_72381);

(statearr_72423_72447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72420 === (13))){
var inst_72398 = (state_72419[(2)]);
var inst_72399 = fluree.db.util.async.throw_err(inst_72398);
var state_72419__$1 = state_72419;
var statearr_72424_72448 = state_72419__$1;
(statearr_72424_72448[(2)] = inst_72399);

(statearr_72424_72448[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72420 === (6))){
var state_72419__$1 = state_72419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72419__$1,(9),subject);
} else {
if((state_val_72420 === (3))){
var inst_72417 = (state_72419[(2)]);
var state_72419__$1 = state_72419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72419__$1,inst_72417);
} else {
if((state_val_72420 === (12))){
var inst_72394 = (state_72419[(7)]);
var inst_72402 = (state_72419[(2)]);
var inst_72403 = fluree.db.dbfunctions.internal.get_in(inst_72394,inst_72402);
var inst_72404 = cljs.core.count(inst_72402);
var inst_72405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72406 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72408 = [inst_72394,inst_72402];
var inst_72409 = (new cljs.core.PersistentVector(null,2,(5),inst_72407,inst_72408,null));
var inst_72410 = ["get-in",inst_72409,inst_72403];
var inst_72411 = cljs.core.PersistentHashMap.fromArrays(inst_72406,inst_72410);
var inst_72412 = [inst_72411,inst_72404];
var inst_72413 = (new cljs.core.PersistentVector(null,2,(5),inst_72405,inst_72412,null));
var inst_72414 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72413);
var _ = (function (){var statearr_72425 = state_72419;
(statearr_72425[(4)] = cljs.core.rest((state_72419[(4)])));

return statearr_72425;
})();
var state_72419__$1 = (function (){var statearr_72426 = state_72419;
(statearr_72426[(8)] = inst_72414);

return statearr_72426;
})();
var statearr_72427_72449 = state_72419__$1;
(statearr_72427_72449[(2)] = inst_72403);

(statearr_72427_72449[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72420 === (2))){
var _ = (function (){var statearr_72428 = state_72419;
(statearr_72428[(4)] = cljs.core.cons((5),(state_72419[(4)])));

return statearr_72428;
})();
var inst_72387 = fluree.db.util.async.channel_QMARK_(subject);
var state_72419__$1 = state_72419;
if(inst_72387){
var statearr_72429_72450 = state_72419__$1;
(statearr_72429_72450[(1)] = (6));

} else {
var statearr_72430_72451 = state_72419__$1;
(statearr_72430_72451[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72420 === (11))){
var state_72419__$1 = state_72419;
var statearr_72432_72452 = state_72419__$1;
(statearr_72432_72452[(2)] = path);

(statearr_72432_72452[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72420 === (9))){
var inst_72390 = (state_72419[(2)]);
var inst_72391 = fluree.db.util.async.throw_err(inst_72390);
var state_72419__$1 = state_72419;
var statearr_72433_72453 = state_72419__$1;
(statearr_72433_72453[(2)] = inst_72391);

(statearr_72433_72453[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72420 === (5))){
var _ = (function (){var statearr_72434 = state_72419;
(statearr_72434[(4)] = cljs.core.rest((state_72419[(4)])));

return statearr_72434;
})();
var state_72419__$1 = state_72419;
var ex72431 = (state_72419__$1[(2)]);
var statearr_72435_72454 = state_72419__$1;
(statearr_72435_72454[(5)] = ex72431);


if((ex72431 instanceof Error)){
var statearr_72436_72455 = state_72419__$1;
(statearr_72436_72455[(1)] = (4));

(statearr_72436_72455[(5)] = null);

} else {
throw ex72431;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72420 === (10))){
var state_72419__$1 = state_72419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72419__$1,(13),path);
} else {
if((state_val_72420 === (8))){
var inst_72394 = (state_72419[(2)]);
var inst_72395 = fluree.db.util.async.channel_QMARK_(path);
var state_72419__$1 = (function (){var statearr_72437 = state_72419;
(statearr_72437[(7)] = inst_72394);

return statearr_72437;
})();
if(inst_72395){
var statearr_72438_72456 = state_72419__$1;
(statearr_72438_72456[(1)] = (10));

} else {
var statearr_72439_72457 = state_72419__$1;
(statearr_72439_72457[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto____0 = (function (){
var statearr_72440 = [null,null,null,null,null,null,null,null,null];
(statearr_72440[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto__);

(statearr_72440[(1)] = (1));

return statearr_72440;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto____1 = (function (state_72419){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72419);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72441){var ex__14781__auto__ = e72441;
var statearr_72442_72458 = state_72419;
(statearr_72442_72458[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72419[(4)]))){
var statearr_72443_72459 = state_72419;
(statearr_72443_72459[(1)] = cljs.core.first((state_72419[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72460 = state_72419;
state_72419 = G__72460;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto__ = function(state_72419){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto____1.call(this,state_72419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72444 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72444[(6)] = c__14852__auto__);

return statearr_72444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72505){
var state_val_72506 = (state_72505[(1)]);
if((state_val_72506 === (7))){
var state_72505__$1 = state_72505;
var statearr_72507_72536 = state_72505__$1;
(statearr_72507_72536[(2)] = coll);

(statearr_72507_72536[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (1))){
var state_72505__$1 = state_72505;
var statearr_72508_72537 = state_72505__$1;
(statearr_72508_72537[(2)] = null);

(statearr_72508_72537[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (4))){
var inst_72461 = (state_72505[(2)]);
var state_72505__$1 = state_72505;
var statearr_72509_72538 = state_72505__$1;
(statearr_72509_72538[(2)] = inst_72461);

(statearr_72509_72538[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (15))){
var inst_72481 = (state_72505[(7)]);
var inst_72489 = (state_72505[(2)]);
var inst_72490 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_72481,inst_72489);
var inst_72491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72492 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72494 = [inst_72481,inst_72489];
var inst_72495 = (new cljs.core.PersistentVector(null,2,(5),inst_72493,inst_72494,null));
var inst_72496 = ["contains?",inst_72495,inst_72490];
var inst_72497 = cljs.core.PersistentHashMap.fromArrays(inst_72492,inst_72496);
var inst_72498 = [inst_72497,(10)];
var inst_72499 = (new cljs.core.PersistentVector(null,2,(5),inst_72491,inst_72498,null));
var inst_72500 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72499);
var _ = (function (){var statearr_72510 = state_72505;
(statearr_72510[(4)] = cljs.core.rest((state_72505[(4)])));

return statearr_72510;
})();
var state_72505__$1 = (function (){var statearr_72511 = state_72505;
(statearr_72511[(8)] = inst_72500);

return statearr_72511;
})();
var statearr_72512_72539 = state_72505__$1;
(statearr_72512_72539[(2)] = inst_72490);

(statearr_72512_72539[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (13))){
var state_72505__$1 = state_72505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72505__$1,(16),key);
} else {
if((state_val_72506 === (6))){
var state_72505__$1 = state_72505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72505__$1,(9),coll);
} else {
if((state_val_72506 === (3))){
var inst_72503 = (state_72505[(2)]);
var state_72505__$1 = state_72505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72505__$1,inst_72503);
} else {
if((state_val_72506 === (12))){
var inst_72481 = (state_72505[(2)]);
var inst_72482 = fluree.db.util.async.channel_QMARK_(key);
var state_72505__$1 = (function (){var statearr_72513 = state_72505;
(statearr_72513[(7)] = inst_72481);

return statearr_72513;
})();
if(inst_72482){
var statearr_72514_72540 = state_72505__$1;
(statearr_72514_72540[(1)] = (13));

} else {
var statearr_72515_72541 = state_72505__$1;
(statearr_72515_72541[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (2))){
var _ = (function (){var statearr_72516 = state_72505;
(statearr_72516[(4)] = cljs.core.cons((5),(state_72505[(4)])));

return statearr_72516;
})();
var inst_72467 = fluree.db.util.async.channel_QMARK_(coll);
var state_72505__$1 = state_72505;
if(inst_72467){
var statearr_72517_72542 = state_72505__$1;
(statearr_72517_72542[(1)] = (6));

} else {
var statearr_72518_72543 = state_72505__$1;
(statearr_72518_72543[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (11))){
var inst_72474 = (state_72505[(9)]);
var inst_72478 = cljs.core.flatten(inst_72474);
var inst_72479 = cljs.core.set(inst_72478);
var state_72505__$1 = state_72505;
var statearr_72520_72544 = state_72505__$1;
(statearr_72520_72544[(2)] = inst_72479);

(statearr_72520_72544[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (9))){
var inst_72470 = (state_72505[(2)]);
var inst_72471 = fluree.db.util.async.throw_err(inst_72470);
var state_72505__$1 = state_72505;
var statearr_72521_72545 = state_72505__$1;
(statearr_72521_72545[(2)] = inst_72471);

(statearr_72521_72545[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (5))){
var _ = (function (){var statearr_72522 = state_72505;
(statearr_72522[(4)] = cljs.core.rest((state_72505[(4)])));

return statearr_72522;
})();
var state_72505__$1 = state_72505;
var ex72519 = (state_72505__$1[(2)]);
var statearr_72523_72546 = state_72505__$1;
(statearr_72523_72546[(5)] = ex72519);


if((ex72519 instanceof Error)){
var statearr_72524_72547 = state_72505__$1;
(statearr_72524_72547[(1)] = (4));

(statearr_72524_72547[(5)] = null);

} else {
throw ex72519;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (14))){
var state_72505__$1 = state_72505;
var statearr_72525_72548 = state_72505__$1;
(statearr_72525_72548[(2)] = key);

(statearr_72525_72548[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (16))){
var inst_72485 = (state_72505[(2)]);
var inst_72486 = fluree.db.util.async.throw_err(inst_72485);
var state_72505__$1 = state_72505;
var statearr_72526_72549 = state_72505__$1;
(statearr_72526_72549[(2)] = inst_72486);

(statearr_72526_72549[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (10))){
var inst_72474 = (state_72505[(9)]);
var state_72505__$1 = state_72505;
var statearr_72527_72550 = state_72505__$1;
(statearr_72527_72550[(2)] = inst_72474);

(statearr_72527_72550[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72506 === (8))){
var inst_72474 = (state_72505[(9)]);
var inst_72474__$1 = (state_72505[(2)]);
var inst_72475 = cljs.core.set_QMARK_(inst_72474__$1);
var state_72505__$1 = (function (){var statearr_72528 = state_72505;
(statearr_72528[(9)] = inst_72474__$1);

return statearr_72528;
})();
if(inst_72475){
var statearr_72529_72551 = state_72505__$1;
(statearr_72529_72551[(1)] = (10));

} else {
var statearr_72530_72552 = state_72505__$1;
(statearr_72530_72552[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto____0 = (function (){
var statearr_72531 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72531[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto__);

(statearr_72531[(1)] = (1));

return statearr_72531;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto____1 = (function (state_72505){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72505);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72532){var ex__14781__auto__ = e72532;
var statearr_72533_72553 = state_72505;
(statearr_72533_72553[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72505[(4)]))){
var statearr_72534_72554 = state_72505;
(statearr_72534_72554[(1)] = cljs.core.first((state_72505[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72555 = state_72505;
state_72505 = G__72555;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto__ = function(state_72505){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto____1.call(this,state_72505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72535 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72535[(6)] = c__14852__auto__);

return statearr_72535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72627 = arguments.length;
var i__4830__auto___72628 = (0);
while(true){
if((i__4830__auto___72628 < len__4829__auto___72627)){
args__4835__auto__.push((arguments[i__4830__auto___72628]));

var G__72629 = (i__4830__auto___72628 + (1));
i__4830__auto___72628 = G__72629;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72601){
var state_val_72602 = (state_72601[(1)]);
if((state_val_72602 === (7))){
var inst_72567 = (state_72601[(7)]);
var inst_72571 = cljs.core.first(inst_72567);
var inst_72572 = cljs.core.coll_QMARK_(inst_72571);
var state_72601__$1 = state_72601;
var statearr_72603_72630 = state_72601__$1;
(statearr_72603_72630[(2)] = inst_72572);

(statearr_72603_72630[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72602 === (1))){
var state_72601__$1 = state_72601;
var statearr_72604_72631 = state_72601__$1;
(statearr_72604_72631[(2)] = null);

(statearr_72604_72631[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72602 === (4))){
var inst_72558 = (state_72601[(2)]);
var state_72601__$1 = state_72601;
var statearr_72605_72632 = state_72601__$1;
(statearr_72605_72632[(2)] = inst_72558);

(statearr_72605_72632[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72602 === (6))){
var inst_72569 = (state_72601[(8)]);
var inst_72567 = (state_72601[(7)]);
var inst_72566 = (state_72601[(2)]);
var inst_72567__$1 = fluree.db.util.async.throw_err(inst_72566);
var inst_72568 = cljs.core.count(inst_72567__$1);
var inst_72569__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_72568);
var state_72601__$1 = (function (){var statearr_72606 = state_72601;
(statearr_72606[(8)] = inst_72569__$1);

(statearr_72606[(7)] = inst_72567__$1);

return statearr_72606;
})();
if(inst_72569__$1){
var statearr_72607_72633 = state_72601__$1;
(statearr_72607_72633[(1)] = (7));

} else {
var statearr_72608_72634 = state_72601__$1;
(statearr_72608_72634[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72602 === (3))){
var inst_72599 = (state_72601[(2)]);
var state_72601__$1 = state_72601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72601__$1,inst_72599);
} else {
if((state_val_72602 === (12))){
var inst_72580 = (state_72601[(2)]);
var inst_72581 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_72580);
var inst_72582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72583 = [inst_72580];
var inst_72584 = (new cljs.core.PersistentVector(null,1,(5),inst_72582,inst_72583,null));
var inst_72585 = cljs.core.count(inst_72584);
var inst_72586 = ((9) + inst_72585);
var inst_72587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72588 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72590 = [inst_72580];
var inst_72591 = (new cljs.core.PersistentVector(null,1,(5),inst_72589,inst_72590,null));
var inst_72592 = ["hash-set",inst_72591,inst_72581];
var inst_72593 = cljs.core.PersistentHashMap.fromArrays(inst_72588,inst_72592);
var inst_72594 = [inst_72593,inst_72586];
var inst_72595 = (new cljs.core.PersistentVector(null,2,(5),inst_72587,inst_72594,null));
var inst_72596 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72595);
var _ = (function (){var statearr_72609 = state_72601;
(statearr_72609[(4)] = cljs.core.rest((state_72601[(4)])));

return statearr_72609;
})();
var state_72601__$1 = (function (){var statearr_72610 = state_72601;
(statearr_72610[(9)] = inst_72596);

return statearr_72610;
})();
var statearr_72611_72635 = state_72601__$1;
(statearr_72611_72635[(2)] = inst_72581);

(statearr_72611_72635[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72602 === (2))){
var _ = (function (){var statearr_72612 = state_72601;
(statearr_72612[(4)] = cljs.core.cons((5),(state_72601[(4)])));

return statearr_72612;
})();
var inst_72564 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72601__$1 = state_72601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72601__$1,(6),inst_72564);
} else {
if((state_val_72602 === (11))){
var inst_72567 = (state_72601[(7)]);
var state_72601__$1 = state_72601;
var statearr_72614_72636 = state_72601__$1;
(statearr_72614_72636[(2)] = inst_72567);

(statearr_72614_72636[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72602 === (9))){
var inst_72575 = (state_72601[(2)]);
var state_72601__$1 = state_72601;
if(cljs.core.truth_(inst_72575)){
var statearr_72615_72637 = state_72601__$1;
(statearr_72615_72637[(1)] = (10));

} else {
var statearr_72616_72638 = state_72601__$1;
(statearr_72616_72638[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72602 === (5))){
var _ = (function (){var statearr_72617 = state_72601;
(statearr_72617[(4)] = cljs.core.rest((state_72601[(4)])));

return statearr_72617;
})();
var state_72601__$1 = state_72601;
var ex72613 = (state_72601__$1[(2)]);
var statearr_72618_72639 = state_72601__$1;
(statearr_72618_72639[(5)] = ex72613);


if((ex72613 instanceof Error)){
var statearr_72619_72640 = state_72601__$1;
(statearr_72619_72640[(1)] = (4));

(statearr_72619_72640[(5)] = null);

} else {
throw ex72613;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72602 === (10))){
var inst_72567 = (state_72601[(7)]);
var inst_72577 = cljs.core.first(inst_72567);
var state_72601__$1 = state_72601;
var statearr_72620_72641 = state_72601__$1;
(statearr_72620_72641[(2)] = inst_72577);

(statearr_72620_72641[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72602 === (8))){
var inst_72569 = (state_72601[(8)]);
var state_72601__$1 = state_72601;
var statearr_72621_72642 = state_72601__$1;
(statearr_72621_72642[(2)] = inst_72569);

(statearr_72621_72642[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_72622 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72622[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_72622[(1)] = (1));

return statearr_72622;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_72601){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72601);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72623){var ex__14781__auto__ = e72623;
var statearr_72624_72643 = state_72601;
(statearr_72624_72643[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72601[(4)]))){
var statearr_72625_72644 = state_72601;
(statearr_72625_72644[(1)] = cljs.core.first((state_72601[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72645 = state_72601;
state_72601 = G__72645;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_72601){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_72601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72626 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72626[(6)] = c__14852__auto__);

return statearr_72626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq72556){
var G__72557 = cljs.core.first(seq72556);
var seq72556__$1 = cljs.core.next(seq72556);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72557,seq72556__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72695 = arguments.length;
var i__4830__auto___72696 = (0);
while(true){
if((i__4830__auto___72696 < len__4829__auto___72695)){
args__4835__auto__.push((arguments[i__4830__auto___72696]));

var G__72697 = (i__4830__auto___72696 + (1));
i__4830__auto___72696 = G__72697;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72678){
var state_val_72679 = (state_72678[(1)]);
if((state_val_72679 === (1))){
var state_72678__$1 = state_72678;
var statearr_72680_72698 = state_72678__$1;
(statearr_72680_72698[(2)] = null);

(statearr_72680_72698[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72679 === (2))){
var _ = (function (){var statearr_72681 = state_72678;
(statearr_72681[(4)] = cljs.core.cons((5),(state_72678[(4)])));

return statearr_72681;
})();
var inst_72654 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72678__$1 = state_72678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72678__$1,(6),inst_72654);
} else {
if((state_val_72679 === (3))){
var inst_72676 = (state_72678[(2)]);
var state_72678__$1 = state_72678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72678__$1,inst_72676);
} else {
if((state_val_72679 === (4))){
var inst_72648 = (state_72678[(2)]);
var state_72678__$1 = state_72678;
var statearr_72683_72699 = state_72678__$1;
(statearr_72683_72699[(2)] = inst_72648);

(statearr_72683_72699[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72679 === (5))){
var _ = (function (){var statearr_72684 = state_72678;
(statearr_72684[(4)] = cljs.core.rest((state_72678[(4)])));

return statearr_72684;
})();
var state_72678__$1 = state_72678;
var ex72682 = (state_72678__$1[(2)]);
var statearr_72685_72700 = state_72678__$1;
(statearr_72685_72700[(5)] = ex72682);


if((ex72682 instanceof Error)){
var statearr_72686_72701 = state_72678__$1;
(statearr_72686_72701[(1)] = (4));

(statearr_72686_72701[(5)] = null);

} else {
throw ex72682;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72679 === (6))){
var inst_72656 = (state_72678[(2)]);
var inst_72657 = fluree.db.util.async.throw_err(inst_72656);
var inst_72658 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_72657);
var inst_72659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72660 = [inst_72657];
var inst_72661 = (new cljs.core.PersistentVector(null,1,(5),inst_72659,inst_72660,null));
var inst_72662 = cljs.core.count(inst_72661);
var inst_72663 = ((9) + inst_72662);
var inst_72664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72665 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72667 = [inst_72657];
var inst_72668 = (new cljs.core.PersistentVector(null,1,(5),inst_72666,inst_72667,null));
var inst_72669 = ["==",inst_72668,inst_72658];
var inst_72670 = cljs.core.PersistentHashMap.fromArrays(inst_72665,inst_72669);
var inst_72671 = [inst_72670,inst_72663];
var inst_72672 = (new cljs.core.PersistentVector(null,2,(5),inst_72664,inst_72671,null));
var inst_72673 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72672);
var _ = (function (){var statearr_72687 = state_72678;
(statearr_72687[(4)] = cljs.core.rest((state_72678[(4)])));

return statearr_72687;
})();
var state_72678__$1 = (function (){var statearr_72688 = state_72678;
(statearr_72688[(7)] = inst_72673);

return statearr_72688;
})();
var statearr_72689_72702 = state_72678__$1;
(statearr_72689_72702[(2)] = inst_72658);

(statearr_72689_72702[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_72690 = [null,null,null,null,null,null,null,null];
(statearr_72690[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_72690[(1)] = (1));

return statearr_72690;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_72678){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72678);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72691){var ex__14781__auto__ = e72691;
var statearr_72692_72703 = state_72678;
(statearr_72692_72703[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72678[(4)]))){
var statearr_72693_72704 = state_72678;
(statearr_72693_72704[(1)] = cljs.core.first((state_72678[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72705 = state_72678;
state_72678 = G__72705;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_72678){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_72678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72694 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72694[(6)] = c__14852__auto__);

return statearr_72694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq72646){
var G__72647 = cljs.core.first(seq72646);
var seq72646__$1 = cljs.core.next(seq72646);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72647,seq72646__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72755 = arguments.length;
var i__4830__auto___72756 = (0);
while(true){
if((i__4830__auto___72756 < len__4829__auto___72755)){
args__4835__auto__.push((arguments[i__4830__auto___72756]));

var G__72757 = (i__4830__auto___72756 + (1));
i__4830__auto___72756 = G__72757;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72738){
var state_val_72739 = (state_72738[(1)]);
if((state_val_72739 === (1))){
var state_72738__$1 = state_72738;
var statearr_72740_72758 = state_72738__$1;
(statearr_72740_72758[(2)] = null);

(statearr_72740_72758[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72739 === (2))){
var _ = (function (){var statearr_72741 = state_72738;
(statearr_72741[(4)] = cljs.core.cons((5),(state_72738[(4)])));

return statearr_72741;
})();
var inst_72714 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72738__$1 = state_72738;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72738__$1,(6),inst_72714);
} else {
if((state_val_72739 === (3))){
var inst_72736 = (state_72738[(2)]);
var state_72738__$1 = state_72738;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72738__$1,inst_72736);
} else {
if((state_val_72739 === (4))){
var inst_72708 = (state_72738[(2)]);
var state_72738__$1 = state_72738;
var statearr_72743_72759 = state_72738__$1;
(statearr_72743_72759[(2)] = inst_72708);

(statearr_72743_72759[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72739 === (5))){
var _ = (function (){var statearr_72744 = state_72738;
(statearr_72744[(4)] = cljs.core.rest((state_72738[(4)])));

return statearr_72744;
})();
var state_72738__$1 = state_72738;
var ex72742 = (state_72738__$1[(2)]);
var statearr_72745_72760 = state_72738__$1;
(statearr_72745_72760[(5)] = ex72742);


if((ex72742 instanceof Error)){
var statearr_72746_72761 = state_72738__$1;
(statearr_72746_72761[(1)] = (4));

(statearr_72746_72761[(5)] = null);

} else {
throw ex72742;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72739 === (6))){
var inst_72716 = (state_72738[(2)]);
var inst_72717 = fluree.db.util.async.throw_err(inst_72716);
var inst_72718 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_72717);
var inst_72719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72720 = [inst_72717];
var inst_72721 = (new cljs.core.PersistentVector(null,1,(5),inst_72719,inst_72720,null));
var inst_72722 = cljs.core.count(inst_72721);
var inst_72723 = ((9) + inst_72722);
var inst_72724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72725 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72727 = [inst_72717];
var inst_72728 = (new cljs.core.PersistentVector(null,1,(5),inst_72726,inst_72727,null));
var inst_72729 = [">",inst_72728,inst_72718];
var inst_72730 = cljs.core.PersistentHashMap.fromArrays(inst_72725,inst_72729);
var inst_72731 = [inst_72730,inst_72723];
var inst_72732 = (new cljs.core.PersistentVector(null,2,(5),inst_72724,inst_72731,null));
var inst_72733 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72732);
var _ = (function (){var statearr_72747 = state_72738;
(statearr_72747[(4)] = cljs.core.rest((state_72738[(4)])));

return statearr_72747;
})();
var state_72738__$1 = (function (){var statearr_72748 = state_72738;
(statearr_72748[(7)] = inst_72733);

return statearr_72748;
})();
var statearr_72749_72762 = state_72738__$1;
(statearr_72749_72762[(2)] = inst_72718);

(statearr_72749_72762[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_72750 = [null,null,null,null,null,null,null,null];
(statearr_72750[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_72750[(1)] = (1));

return statearr_72750;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_72738){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72738);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72751){var ex__14781__auto__ = e72751;
var statearr_72752_72763 = state_72738;
(statearr_72752_72763[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72738[(4)]))){
var statearr_72753_72764 = state_72738;
(statearr_72753_72764[(1)] = cljs.core.first((state_72738[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72765 = state_72738;
state_72738 = G__72765;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_72738){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_72738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72754 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72754[(6)] = c__14852__auto__);

return statearr_72754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq72706){
var G__72707 = cljs.core.first(seq72706);
var seq72706__$1 = cljs.core.next(seq72706);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72707,seq72706__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72815 = arguments.length;
var i__4830__auto___72816 = (0);
while(true){
if((i__4830__auto___72816 < len__4829__auto___72815)){
args__4835__auto__.push((arguments[i__4830__auto___72816]));

var G__72817 = (i__4830__auto___72816 + (1));
i__4830__auto___72816 = G__72817;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72798){
var state_val_72799 = (state_72798[(1)]);
if((state_val_72799 === (1))){
var state_72798__$1 = state_72798;
var statearr_72800_72818 = state_72798__$1;
(statearr_72800_72818[(2)] = null);

(statearr_72800_72818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72799 === (2))){
var _ = (function (){var statearr_72801 = state_72798;
(statearr_72801[(4)] = cljs.core.cons((5),(state_72798[(4)])));

return statearr_72801;
})();
var inst_72774 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72798__$1 = state_72798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72798__$1,(6),inst_72774);
} else {
if((state_val_72799 === (3))){
var inst_72796 = (state_72798[(2)]);
var state_72798__$1 = state_72798;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72798__$1,inst_72796);
} else {
if((state_val_72799 === (4))){
var inst_72768 = (state_72798[(2)]);
var state_72798__$1 = state_72798;
var statearr_72803_72819 = state_72798__$1;
(statearr_72803_72819[(2)] = inst_72768);

(statearr_72803_72819[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72799 === (5))){
var _ = (function (){var statearr_72804 = state_72798;
(statearr_72804[(4)] = cljs.core.rest((state_72798[(4)])));

return statearr_72804;
})();
var state_72798__$1 = state_72798;
var ex72802 = (state_72798__$1[(2)]);
var statearr_72805_72820 = state_72798__$1;
(statearr_72805_72820[(5)] = ex72802);


if((ex72802 instanceof Error)){
var statearr_72806_72821 = state_72798__$1;
(statearr_72806_72821[(1)] = (4));

(statearr_72806_72821[(5)] = null);

} else {
throw ex72802;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72799 === (6))){
var inst_72776 = (state_72798[(2)]);
var inst_72777 = fluree.db.util.async.throw_err(inst_72776);
var inst_72778 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_72777);
var inst_72779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72780 = [inst_72777];
var inst_72781 = (new cljs.core.PersistentVector(null,1,(5),inst_72779,inst_72780,null));
var inst_72782 = cljs.core.count(inst_72781);
var inst_72783 = ((9) + inst_72782);
var inst_72784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72785 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72787 = [inst_72777];
var inst_72788 = (new cljs.core.PersistentVector(null,1,(5),inst_72786,inst_72787,null));
var inst_72789 = ["<",inst_72788,inst_72778];
var inst_72790 = cljs.core.PersistentHashMap.fromArrays(inst_72785,inst_72789);
var inst_72791 = [inst_72790,inst_72783];
var inst_72792 = (new cljs.core.PersistentVector(null,2,(5),inst_72784,inst_72791,null));
var inst_72793 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72792);
var _ = (function (){var statearr_72807 = state_72798;
(statearr_72807[(4)] = cljs.core.rest((state_72798[(4)])));

return statearr_72807;
})();
var state_72798__$1 = (function (){var statearr_72808 = state_72798;
(statearr_72808[(7)] = inst_72793);

return statearr_72808;
})();
var statearr_72809_72822 = state_72798__$1;
(statearr_72809_72822[(2)] = inst_72778);

(statearr_72809_72822[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_72810 = [null,null,null,null,null,null,null,null];
(statearr_72810[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_72810[(1)] = (1));

return statearr_72810;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_72798){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72798);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72811){var ex__14781__auto__ = e72811;
var statearr_72812_72823 = state_72798;
(statearr_72812_72823[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72798[(4)]))){
var statearr_72813_72824 = state_72798;
(statearr_72813_72824[(1)] = cljs.core.first((state_72798[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72825 = state_72798;
state_72798 = G__72825;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_72798){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_72798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72814 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72814[(6)] = c__14852__auto__);

return statearr_72814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq72766){
var G__72767 = cljs.core.first(seq72766);
var seq72766__$1 = cljs.core.next(seq72766);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72767,seq72766__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72875 = arguments.length;
var i__4830__auto___72876 = (0);
while(true){
if((i__4830__auto___72876 < len__4829__auto___72875)){
args__4835__auto__.push((arguments[i__4830__auto___72876]));

var G__72877 = (i__4830__auto___72876 + (1));
i__4830__auto___72876 = G__72877;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72858){
var state_val_72859 = (state_72858[(1)]);
if((state_val_72859 === (1))){
var state_72858__$1 = state_72858;
var statearr_72860_72878 = state_72858__$1;
(statearr_72860_72878[(2)] = null);

(statearr_72860_72878[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72859 === (2))){
var _ = (function (){var statearr_72861 = state_72858;
(statearr_72861[(4)] = cljs.core.cons((5),(state_72858[(4)])));

return statearr_72861;
})();
var inst_72834 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72858__$1 = state_72858;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72858__$1,(6),inst_72834);
} else {
if((state_val_72859 === (3))){
var inst_72856 = (state_72858[(2)]);
var state_72858__$1 = state_72858;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72858__$1,inst_72856);
} else {
if((state_val_72859 === (4))){
var inst_72828 = (state_72858[(2)]);
var state_72858__$1 = state_72858;
var statearr_72863_72879 = state_72858__$1;
(statearr_72863_72879[(2)] = inst_72828);

(statearr_72863_72879[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72859 === (5))){
var _ = (function (){var statearr_72864 = state_72858;
(statearr_72864[(4)] = cljs.core.rest((state_72858[(4)])));

return statearr_72864;
})();
var state_72858__$1 = state_72858;
var ex72862 = (state_72858__$1[(2)]);
var statearr_72865_72880 = state_72858__$1;
(statearr_72865_72880[(5)] = ex72862);


if((ex72862 instanceof Error)){
var statearr_72866_72881 = state_72858__$1;
(statearr_72866_72881[(1)] = (4));

(statearr_72866_72881[(5)] = null);

} else {
throw ex72862;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72859 === (6))){
var inst_72836 = (state_72858[(2)]);
var inst_72837 = fluree.db.util.async.throw_err(inst_72836);
var inst_72838 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_72837);
var inst_72839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72840 = [inst_72837];
var inst_72841 = (new cljs.core.PersistentVector(null,1,(5),inst_72839,inst_72840,null));
var inst_72842 = cljs.core.count(inst_72841);
var inst_72843 = ((9) + inst_72842);
var inst_72844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72845 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72847 = [inst_72837];
var inst_72848 = (new cljs.core.PersistentVector(null,1,(5),inst_72846,inst_72847,null));
var inst_72849 = ["<=",inst_72848,inst_72838];
var inst_72850 = cljs.core.PersistentHashMap.fromArrays(inst_72845,inst_72849);
var inst_72851 = [inst_72850,inst_72843];
var inst_72852 = (new cljs.core.PersistentVector(null,2,(5),inst_72844,inst_72851,null));
var inst_72853 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72852);
var _ = (function (){var statearr_72867 = state_72858;
(statearr_72867[(4)] = cljs.core.rest((state_72858[(4)])));

return statearr_72867;
})();
var state_72858__$1 = (function (){var statearr_72868 = state_72858;
(statearr_72868[(7)] = inst_72853);

return statearr_72868;
})();
var statearr_72869_72882 = state_72858__$1;
(statearr_72869_72882[(2)] = inst_72838);

(statearr_72869_72882[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_72870 = [null,null,null,null,null,null,null,null];
(statearr_72870[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_72870[(1)] = (1));

return statearr_72870;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_72858){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72858);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72871){var ex__14781__auto__ = e72871;
var statearr_72872_72883 = state_72858;
(statearr_72872_72883[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72858[(4)]))){
var statearr_72873_72884 = state_72858;
(statearr_72873_72884[(1)] = cljs.core.first((state_72858[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72885 = state_72858;
state_72858 = G__72885;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_72858){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_72858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72874 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72874[(6)] = c__14852__auto__);

return statearr_72874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq72826){
var G__72827 = cljs.core.first(seq72826);
var seq72826__$1 = cljs.core.next(seq72826);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72827,seq72826__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72935 = arguments.length;
var i__4830__auto___72936 = (0);
while(true){
if((i__4830__auto___72936 < len__4829__auto___72935)){
args__4835__auto__.push((arguments[i__4830__auto___72936]));

var G__72937 = (i__4830__auto___72936 + (1));
i__4830__auto___72936 = G__72937;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72918){
var state_val_72919 = (state_72918[(1)]);
if((state_val_72919 === (1))){
var state_72918__$1 = state_72918;
var statearr_72920_72938 = state_72918__$1;
(statearr_72920_72938[(2)] = null);

(statearr_72920_72938[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72919 === (2))){
var _ = (function (){var statearr_72921 = state_72918;
(statearr_72921[(4)] = cljs.core.cons((5),(state_72918[(4)])));

return statearr_72921;
})();
var inst_72894 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72918__$1 = state_72918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72918__$1,(6),inst_72894);
} else {
if((state_val_72919 === (3))){
var inst_72916 = (state_72918[(2)]);
var state_72918__$1 = state_72918;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72918__$1,inst_72916);
} else {
if((state_val_72919 === (4))){
var inst_72888 = (state_72918[(2)]);
var state_72918__$1 = state_72918;
var statearr_72923_72939 = state_72918__$1;
(statearr_72923_72939[(2)] = inst_72888);

(statearr_72923_72939[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72919 === (5))){
var _ = (function (){var statearr_72924 = state_72918;
(statearr_72924[(4)] = cljs.core.rest((state_72918[(4)])));

return statearr_72924;
})();
var state_72918__$1 = state_72918;
var ex72922 = (state_72918__$1[(2)]);
var statearr_72925_72940 = state_72918__$1;
(statearr_72925_72940[(5)] = ex72922);


if((ex72922 instanceof Error)){
var statearr_72926_72941 = state_72918__$1;
(statearr_72926_72941[(1)] = (4));

(statearr_72926_72941[(5)] = null);

} else {
throw ex72922;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72919 === (6))){
var inst_72896 = (state_72918[(2)]);
var inst_72897 = fluree.db.util.async.throw_err(inst_72896);
var inst_72898 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_72897);
var inst_72899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72900 = [inst_72897];
var inst_72901 = (new cljs.core.PersistentVector(null,1,(5),inst_72899,inst_72900,null));
var inst_72902 = cljs.core.count(inst_72901);
var inst_72903 = ((9) + inst_72902);
var inst_72904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72905 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72907 = [inst_72897];
var inst_72908 = (new cljs.core.PersistentVector(null,1,(5),inst_72906,inst_72907,null));
var inst_72909 = [">=",inst_72908,inst_72898];
var inst_72910 = cljs.core.PersistentHashMap.fromArrays(inst_72905,inst_72909);
var inst_72911 = [inst_72910,inst_72903];
var inst_72912 = (new cljs.core.PersistentVector(null,2,(5),inst_72904,inst_72911,null));
var inst_72913 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72912);
var _ = (function (){var statearr_72927 = state_72918;
(statearr_72927[(4)] = cljs.core.rest((state_72918[(4)])));

return statearr_72927;
})();
var state_72918__$1 = (function (){var statearr_72928 = state_72918;
(statearr_72928[(7)] = inst_72913);

return statearr_72928;
})();
var statearr_72929_72942 = state_72918__$1;
(statearr_72929_72942[(2)] = inst_72898);

(statearr_72929_72942[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_72930 = [null,null,null,null,null,null,null,null];
(statearr_72930[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_72930[(1)] = (1));

return statearr_72930;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_72918){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72918);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72931){var ex__14781__auto__ = e72931;
var statearr_72932_72943 = state_72918;
(statearr_72932_72943[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72918[(4)]))){
var statearr_72933_72944 = state_72918;
(statearr_72933_72944[(1)] = cljs.core.first((state_72918[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__72945 = state_72918;
state_72918 = G__72945;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_72918){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_72918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72934 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72934[(6)] = c__14852__auto__);

return statearr_72934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq72886){
var G__72887 = cljs.core.first(seq72886);
var seq72886__$1 = cljs.core.next(seq72886);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72887,seq72886__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72995 = arguments.length;
var i__4830__auto___72996 = (0);
while(true){
if((i__4830__auto___72996 < len__4829__auto___72995)){
args__4835__auto__.push((arguments[i__4830__auto___72996]));

var G__72997 = (i__4830__auto___72996 + (1));
i__4830__auto___72996 = G__72997;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_72978){
var state_val_72979 = (state_72978[(1)]);
if((state_val_72979 === (1))){
var state_72978__$1 = state_72978;
var statearr_72980_72998 = state_72978__$1;
(statearr_72980_72998[(2)] = null);

(statearr_72980_72998[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72979 === (2))){
var _ = (function (){var statearr_72981 = state_72978;
(statearr_72981[(4)] = cljs.core.cons((5),(state_72978[(4)])));

return statearr_72981;
})();
var inst_72954 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72978__$1 = state_72978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72978__$1,(6),inst_72954);
} else {
if((state_val_72979 === (3))){
var inst_72976 = (state_72978[(2)]);
var state_72978__$1 = state_72978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72978__$1,inst_72976);
} else {
if((state_val_72979 === (4))){
var inst_72948 = (state_72978[(2)]);
var state_72978__$1 = state_72978;
var statearr_72983_72999 = state_72978__$1;
(statearr_72983_72999[(2)] = inst_72948);

(statearr_72983_72999[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72979 === (5))){
var _ = (function (){var statearr_72984 = state_72978;
(statearr_72984[(4)] = cljs.core.rest((state_72978[(4)])));

return statearr_72984;
})();
var state_72978__$1 = state_72978;
var ex72982 = (state_72978__$1[(2)]);
var statearr_72985_73000 = state_72978__$1;
(statearr_72985_73000[(5)] = ex72982);


if((ex72982 instanceof Error)){
var statearr_72986_73001 = state_72978__$1;
(statearr_72986_73001[(1)] = (4));

(statearr_72986_73001[(5)] = null);

} else {
throw ex72982;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72979 === (6))){
var inst_72956 = (state_72978[(2)]);
var inst_72957 = fluree.db.util.async.throw_err(inst_72956);
var inst_72958 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_72957);
var inst_72959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72960 = [inst_72957];
var inst_72961 = (new cljs.core.PersistentVector(null,1,(5),inst_72959,inst_72960,null));
var inst_72962 = cljs.core.count(inst_72961);
var inst_72963 = ((9) + inst_72962);
var inst_72964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72965 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72967 = [inst_72957];
var inst_72968 = (new cljs.core.PersistentVector(null,1,(5),inst_72966,inst_72967,null));
var inst_72969 = ["not=",inst_72968,inst_72958];
var inst_72970 = cljs.core.PersistentHashMap.fromArrays(inst_72965,inst_72969);
var inst_72971 = [inst_72970,inst_72963];
var inst_72972 = (new cljs.core.PersistentVector(null,2,(5),inst_72964,inst_72971,null));
var inst_72973 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72972);
var _ = (function (){var statearr_72987 = state_72978;
(statearr_72987[(4)] = cljs.core.rest((state_72978[(4)])));

return statearr_72987;
})();
var state_72978__$1 = (function (){var statearr_72988 = state_72978;
(statearr_72988[(7)] = inst_72973);

return statearr_72988;
})();
var statearr_72989_73002 = state_72978__$1;
(statearr_72989_73002[(2)] = inst_72958);

(statearr_72989_73002[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_72990 = [null,null,null,null,null,null,null,null];
(statearr_72990[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_72990[(1)] = (1));

return statearr_72990;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_72978){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_72978);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e72991){var ex__14781__auto__ = e72991;
var statearr_72992_73003 = state_72978;
(statearr_72992_73003[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_72978[(4)]))){
var statearr_72993_73004 = state_72978;
(statearr_72993_73004[(1)] = cljs.core.first((state_72978[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73005 = state_72978;
state_72978 = G__73005;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_72978){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_72978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_72994 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_72994[(6)] = c__14852__auto__);

return statearr_72994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq72946){
var G__72947 = cljs.core.first(seq72946);
var seq72946__$1 = cljs.core.next(seq72946);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72947,seq72946__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73055 = arguments.length;
var i__4830__auto___73056 = (0);
while(true){
if((i__4830__auto___73056 < len__4829__auto___73055)){
args__4835__auto__.push((arguments[i__4830__auto___73056]));

var G__73057 = (i__4830__auto___73056 + (1));
i__4830__auto___73056 = G__73057;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73038){
var state_val_73039 = (state_73038[(1)]);
if((state_val_73039 === (1))){
var state_73038__$1 = state_73038;
var statearr_73040_73058 = state_73038__$1;
(statearr_73040_73058[(2)] = null);

(statearr_73040_73058[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73039 === (2))){
var _ = (function (){var statearr_73041 = state_73038;
(statearr_73041[(4)] = cljs.core.cons((5),(state_73038[(4)])));

return statearr_73041;
})();
var inst_73014 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73038__$1 = state_73038;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73038__$1,(6),inst_73014);
} else {
if((state_val_73039 === (3))){
var inst_73036 = (state_73038[(2)]);
var state_73038__$1 = state_73038;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73038__$1,inst_73036);
} else {
if((state_val_73039 === (4))){
var inst_73008 = (state_73038[(2)]);
var state_73038__$1 = state_73038;
var statearr_73043_73059 = state_73038__$1;
(statearr_73043_73059[(2)] = inst_73008);

(statearr_73043_73059[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73039 === (5))){
var _ = (function (){var statearr_73044 = state_73038;
(statearr_73044[(4)] = cljs.core.rest((state_73038[(4)])));

return statearr_73044;
})();
var state_73038__$1 = state_73038;
var ex73042 = (state_73038__$1[(2)]);
var statearr_73045_73060 = state_73038__$1;
(statearr_73045_73060[(5)] = ex73042);


if((ex73042 instanceof Error)){
var statearr_73046_73061 = state_73038__$1;
(statearr_73046_73061[(1)] = (4));

(statearr_73046_73061[(5)] = null);

} else {
throw ex73042;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73039 === (6))){
var inst_73016 = (state_73038[(2)]);
var inst_73017 = fluree.db.util.async.throw_err(inst_73016);
var inst_73018 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_73017);
var inst_73019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73020 = [inst_73017];
var inst_73021 = (new cljs.core.PersistentVector(null,1,(5),inst_73019,inst_73020,null));
var inst_73022 = cljs.core.count(inst_73021);
var inst_73023 = ((9) + inst_73022);
var inst_73024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73025 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73027 = [inst_73017];
var inst_73028 = (new cljs.core.PersistentVector(null,1,(5),inst_73026,inst_73027,null));
var inst_73029 = ["max",inst_73028,inst_73018];
var inst_73030 = cljs.core.PersistentHashMap.fromArrays(inst_73025,inst_73029);
var inst_73031 = [inst_73030,inst_73023];
var inst_73032 = (new cljs.core.PersistentVector(null,2,(5),inst_73024,inst_73031,null));
var inst_73033 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73032);
var _ = (function (){var statearr_73047 = state_73038;
(statearr_73047[(4)] = cljs.core.rest((state_73038[(4)])));

return statearr_73047;
})();
var state_73038__$1 = (function (){var statearr_73048 = state_73038;
(statearr_73048[(7)] = inst_73033);

return statearr_73048;
})();
var statearr_73049_73062 = state_73038__$1;
(statearr_73049_73062[(2)] = inst_73018);

(statearr_73049_73062[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_73050 = [null,null,null,null,null,null,null,null];
(statearr_73050[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_73050[(1)] = (1));

return statearr_73050;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_73038){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73038);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73051){var ex__14781__auto__ = e73051;
var statearr_73052_73063 = state_73038;
(statearr_73052_73063[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73038[(4)]))){
var statearr_73053_73064 = state_73038;
(statearr_73053_73064[(1)] = cljs.core.first((state_73038[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73065 = state_73038;
state_73038 = G__73065;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_73038){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_73038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73054 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73054[(6)] = c__14852__auto__);

return statearr_73054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq73006){
var G__73007 = cljs.core.first(seq73006);
var seq73006__$1 = cljs.core.next(seq73006);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73007,seq73006__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73115 = arguments.length;
var i__4830__auto___73116 = (0);
while(true){
if((i__4830__auto___73116 < len__4829__auto___73115)){
args__4835__auto__.push((arguments[i__4830__auto___73116]));

var G__73117 = (i__4830__auto___73116 + (1));
i__4830__auto___73116 = G__73117;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73098){
var state_val_73099 = (state_73098[(1)]);
if((state_val_73099 === (1))){
var state_73098__$1 = state_73098;
var statearr_73100_73118 = state_73098__$1;
(statearr_73100_73118[(2)] = null);

(statearr_73100_73118[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73099 === (2))){
var _ = (function (){var statearr_73101 = state_73098;
(statearr_73101[(4)] = cljs.core.cons((5),(state_73098[(4)])));

return statearr_73101;
})();
var inst_73074 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73098__$1 = state_73098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73098__$1,(6),inst_73074);
} else {
if((state_val_73099 === (3))){
var inst_73096 = (state_73098[(2)]);
var state_73098__$1 = state_73098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73098__$1,inst_73096);
} else {
if((state_val_73099 === (4))){
var inst_73068 = (state_73098[(2)]);
var state_73098__$1 = state_73098;
var statearr_73103_73119 = state_73098__$1;
(statearr_73103_73119[(2)] = inst_73068);

(statearr_73103_73119[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73099 === (5))){
var _ = (function (){var statearr_73104 = state_73098;
(statearr_73104[(4)] = cljs.core.rest((state_73098[(4)])));

return statearr_73104;
})();
var state_73098__$1 = state_73098;
var ex73102 = (state_73098__$1[(2)]);
var statearr_73105_73120 = state_73098__$1;
(statearr_73105_73120[(5)] = ex73102);


if((ex73102 instanceof Error)){
var statearr_73106_73121 = state_73098__$1;
(statearr_73106_73121[(1)] = (4));

(statearr_73106_73121[(5)] = null);

} else {
throw ex73102;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73099 === (6))){
var inst_73076 = (state_73098[(2)]);
var inst_73077 = fluree.db.util.async.throw_err(inst_73076);
var inst_73078 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_73077);
var inst_73079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73080 = [inst_73077];
var inst_73081 = (new cljs.core.PersistentVector(null,1,(5),inst_73079,inst_73080,null));
var inst_73082 = cljs.core.count(inst_73081);
var inst_73083 = ((9) + inst_73082);
var inst_73084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73085 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73087 = [inst_73077];
var inst_73088 = (new cljs.core.PersistentVector(null,1,(5),inst_73086,inst_73087,null));
var inst_73089 = ["min",inst_73088,inst_73078];
var inst_73090 = cljs.core.PersistentHashMap.fromArrays(inst_73085,inst_73089);
var inst_73091 = [inst_73090,inst_73083];
var inst_73092 = (new cljs.core.PersistentVector(null,2,(5),inst_73084,inst_73091,null));
var inst_73093 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73092);
var _ = (function (){var statearr_73107 = state_73098;
(statearr_73107[(4)] = cljs.core.rest((state_73098[(4)])));

return statearr_73107;
})();
var state_73098__$1 = (function (){var statearr_73108 = state_73098;
(statearr_73108[(7)] = inst_73093);

return statearr_73108;
})();
var statearr_73109_73122 = state_73098__$1;
(statearr_73109_73122[(2)] = inst_73078);

(statearr_73109_73122[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_73110 = [null,null,null,null,null,null,null,null];
(statearr_73110[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_73110[(1)] = (1));

return statearr_73110;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_73098){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73098);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73111){var ex__14781__auto__ = e73111;
var statearr_73112_73123 = state_73098;
(statearr_73112_73123[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73098[(4)]))){
var statearr_73113_73124 = state_73098;
(statearr_73113_73124[(1)] = cljs.core.first((state_73098[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73125 = state_73098;
state_73098 = G__73125;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_73098){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_73098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73114 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73114[(6)] = c__14852__auto__);

return statearr_73114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq73066){
var G__73067 = cljs.core.first(seq73066);
var seq73066__$1 = cljs.core.next(seq73066);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73067,seq73066__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__73127 = arguments.length;
switch (G__73127) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73172){
var state_val_73173 = (state_73172[(1)]);
if((state_val_73173 === (7))){
var state_73172__$1 = state_73172;
var statearr_73174_73311 = state_73172__$1;
(statearr_73174_73311[(2)] = query_map);

(statearr_73174_73311[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73173 === (1))){
var state_73172__$1 = state_73172;
var statearr_73175_73312 = state_73172__$1;
(statearr_73175_73312[(2)] = null);

(statearr_73175_73312[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73173 === (4))){
var inst_73128 = (state_73172[(2)]);
var state_73172__$1 = state_73172;
var statearr_73176_73313 = state_73172__$1;
(statearr_73176_73313[(2)] = inst_73128);

(statearr_73176_73313[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73173 === (13))){
var inst_73150 = (state_73172[(7)]);
var inst_73154 = (state_73172[(2)]);
var inst_73155 = fluree.db.util.async.throw_err(inst_73154);
var inst_73156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73155,(0),null);
var inst_73157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73155,(1),null);
var inst_73158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73159 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73161 = [inst_73150];
var inst_73162 = (new cljs.core.PersistentVector(null,1,(5),inst_73160,inst_73161,null));
var inst_73163 = ["query",inst_73162,inst_73156];
var inst_73164 = cljs.core.PersistentHashMap.fromArrays(inst_73159,inst_73163);
var inst_73165 = [inst_73164,inst_73157];
var inst_73166 = (new cljs.core.PersistentVector(null,2,(5),inst_73158,inst_73165,null));
var inst_73167 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73166);
var _ = (function (){var statearr_73177 = state_73172;
(statearr_73177[(4)] = cljs.core.rest((state_73172[(4)])));

return statearr_73177;
})();
var state_73172__$1 = (function (){var statearr_73178 = state_73172;
(statearr_73178[(8)] = inst_73167);

return statearr_73178;
})();
var statearr_73179_73314 = state_73172__$1;
(statearr_73179_73314[(2)] = inst_73156);

(statearr_73179_73314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73173 === (6))){
var state_73172__$1 = state_73172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73172__$1,(9),query_map);
} else {
if((state_val_73173 === (3))){
var inst_73170 = (state_73172[(2)]);
var state_73172__$1 = state_73172;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73172__$1,inst_73170);
} else {
if((state_val_73173 === (12))){
var inst_73150 = (state_73172[(7)]);
var inst_73150__$1 = (state_73172[(2)]);
var inst_73151 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73152 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_73151,inst_73150__$1);
var state_73172__$1 = (function (){var statearr_73180 = state_73172;
(statearr_73180[(7)] = inst_73150__$1);

return statearr_73180;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73172__$1,(13),inst_73152);
} else {
if((state_val_73173 === (2))){
var _ = (function (){var statearr_73181 = state_73172;
(statearr_73181[(4)] = cljs.core.cons((5),(state_73172[(4)])));

return statearr_73181;
})();
var inst_73137 = fluree.db.util.async.channel_QMARK_(query_map);
var state_73172__$1 = state_73172;
if(inst_73137){
var statearr_73182_73315 = state_73172__$1;
(statearr_73182_73315[(1)] = (6));

} else {
var statearr_73183_73316 = state_73172__$1;
(statearr_73183_73316[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73173 === (11))){
var inst_73144 = (state_73172[(9)]);
var state_73172__$1 = state_73172;
var statearr_73185_73317 = state_73172__$1;
(statearr_73185_73317[(2)] = inst_73144);

(statearr_73185_73317[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73173 === (9))){
var inst_73140 = (state_73172[(2)]);
var inst_73141 = fluree.db.util.async.throw_err(inst_73140);
var state_73172__$1 = state_73172;
var statearr_73186_73318 = state_73172__$1;
(statearr_73186_73318[(2)] = inst_73141);

(statearr_73186_73318[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73173 === (5))){
var _ = (function (){var statearr_73187 = state_73172;
(statearr_73187[(4)] = cljs.core.rest((state_73172[(4)])));

return statearr_73187;
})();
var state_73172__$1 = state_73172;
var ex73184 = (state_73172__$1[(2)]);
var statearr_73188_73319 = state_73172__$1;
(statearr_73188_73319[(5)] = ex73184);


if((ex73184 instanceof Error)){
var statearr_73189_73320 = state_73172__$1;
(statearr_73189_73320[(1)] = (4));

(statearr_73189_73320[(5)] = null);

} else {
throw ex73184;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73173 === (10))){
var inst_73144 = (state_73172[(9)]);
var inst_73147 = fluree.db.util.json.parse(inst_73144);
var state_73172__$1 = state_73172;
var statearr_73190_73321 = state_73172__$1;
(statearr_73190_73321[(2)] = inst_73147);

(statearr_73190_73321[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73173 === (8))){
var inst_73144 = (state_73172[(9)]);
var inst_73144__$1 = (state_73172[(2)]);
var inst_73145 = typeof inst_73144__$1 === 'string';
var state_73172__$1 = (function (){var statearr_73191 = state_73172;
(statearr_73191[(9)] = inst_73144__$1);

return statearr_73191;
})();
if(cljs.core.truth_(inst_73145)){
var statearr_73192_73322 = state_73172__$1;
(statearr_73192_73322[(1)] = (10));

} else {
var statearr_73193_73323 = state_73172__$1;
(statearr_73193_73323[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_73194 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73194[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_73194[(1)] = (1));

return statearr_73194;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_73172){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73172);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73195){var ex__14781__auto__ = e73195;
var statearr_73196_73324 = state_73172;
(statearr_73196_73324[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73172[(4)]))){
var statearr_73197_73325 = state_73172;
(statearr_73197_73325[(1)] = cljs.core.first((state_73172[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73326 = state_73172;
state_73172 = G__73326;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_73172){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_73172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73198 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73198[(6)] = c__14852__auto__);

return statearr_73198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73269){
var state_val_73270 = (state_73269[(1)]);
if((state_val_73270 === (7))){
var state_73269__$1 = state_73269;
var statearr_73271_73327 = state_73269__$1;
(statearr_73271_73327[(2)] = select);

(statearr_73271_73327[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (20))){
var inst_73239 = (state_73269[(2)]);
var inst_73240 = fluree.db.util.async.channel_QMARK_(limit);
var state_73269__$1 = (function (){var statearr_73272 = state_73269;
(statearr_73272[(7)] = inst_73239);

return statearr_73272;
})();
if(inst_73240){
var statearr_73273_73328 = state_73269__$1;
(statearr_73273_73328[(1)] = (22));

} else {
var statearr_73274_73329 = state_73269__$1;
(statearr_73274_73329[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (1))){
var state_73269__$1 = state_73269;
var statearr_73275_73330 = state_73269__$1;
(statearr_73275_73330[(2)] = null);

(statearr_73275_73330[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (24))){
var inst_73215 = (state_73269[(8)]);
var inst_73231 = (state_73269[(9)]);
var inst_73223 = (state_73269[(10)]);
var inst_73239 = (state_73269[(7)]);
var inst_73247 = (state_73269[(2)]);
var inst_73248 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73249 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_73248,inst_73215,inst_73223,inst_73231,inst_73239,inst_73247);
var state_73269__$1 = state_73269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73269__$1,(26),inst_73249);
} else {
if((state_val_73270 === (4))){
var inst_73199 = (state_73269[(2)]);
var state_73269__$1 = state_73269;
var statearr_73276_73331 = state_73269__$1;
(statearr_73276_73331[(2)] = inst_73199);

(statearr_73276_73331[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (15))){
var state_73269__$1 = state_73269;
var statearr_73277_73332 = state_73269__$1;
(statearr_73277_73332[(2)] = where);

(statearr_73277_73332[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (21))){
var inst_73235 = (state_73269[(2)]);
var inst_73236 = fluree.db.util.async.throw_err(inst_73235);
var state_73269__$1 = state_73269;
var statearr_73278_73333 = state_73269__$1;
(statearr_73278_73333[(2)] = inst_73236);

(statearr_73278_73333[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (13))){
var inst_73219 = (state_73269[(2)]);
var inst_73220 = fluree.db.util.async.throw_err(inst_73219);
var state_73269__$1 = state_73269;
var statearr_73279_73334 = state_73269__$1;
(statearr_73279_73334[(2)] = inst_73220);

(statearr_73279_73334[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (22))){
var state_73269__$1 = state_73269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73269__$1,(25),limit);
} else {
if((state_val_73270 === (6))){
var state_73269__$1 = state_73269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73269__$1,(9),select);
} else {
if((state_val_73270 === (25))){
var inst_73243 = (state_73269[(2)]);
var inst_73244 = fluree.db.util.async.throw_err(inst_73243);
var state_73269__$1 = state_73269;
var statearr_73280_73335 = state_73269__$1;
(statearr_73280_73335[(2)] = inst_73244);

(statearr_73280_73335[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (17))){
var inst_73227 = (state_73269[(2)]);
var inst_73228 = fluree.db.util.async.throw_err(inst_73227);
var state_73269__$1 = state_73269;
var statearr_73281_73336 = state_73269__$1;
(statearr_73281_73336[(2)] = inst_73228);

(statearr_73281_73336[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (3))){
var inst_73267 = (state_73269[(2)]);
var state_73269__$1 = state_73269;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73269__$1,inst_73267);
} else {
if((state_val_73270 === (12))){
var inst_73223 = (state_73269[(2)]);
var inst_73224 = fluree.db.util.async.channel_QMARK_(where);
var state_73269__$1 = (function (){var statearr_73282 = state_73269;
(statearr_73282[(10)] = inst_73223);

return statearr_73282;
})();
if(inst_73224){
var statearr_73283_73337 = state_73269__$1;
(statearr_73283_73337[(1)] = (14));

} else {
var statearr_73284_73338 = state_73269__$1;
(statearr_73284_73338[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (2))){
var _ = (function (){var statearr_73285 = state_73269;
(statearr_73285[(4)] = cljs.core.cons((5),(state_73269[(4)])));

return statearr_73285;
})();
var inst_73208 = fluree.db.util.async.channel_QMARK_(select);
var state_73269__$1 = state_73269;
if(inst_73208){
var statearr_73286_73339 = state_73269__$1;
(statearr_73286_73339[(1)] = (6));

} else {
var statearr_73287_73340 = state_73269__$1;
(statearr_73287_73340[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (23))){
var state_73269__$1 = state_73269;
var statearr_73288_73341 = state_73269__$1;
(statearr_73288_73341[(2)] = limit);

(statearr_73288_73341[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (19))){
var state_73269__$1 = state_73269;
var statearr_73289_73342 = state_73269__$1;
(statearr_73289_73342[(2)] = block);

(statearr_73289_73342[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (11))){
var state_73269__$1 = state_73269;
var statearr_73291_73343 = state_73269__$1;
(statearr_73291_73343[(2)] = from);

(statearr_73291_73343[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (9))){
var inst_73211 = (state_73269[(2)]);
var inst_73212 = fluree.db.util.async.throw_err(inst_73211);
var state_73269__$1 = state_73269;
var statearr_73292_73344 = state_73269__$1;
(statearr_73292_73344[(2)] = inst_73212);

(statearr_73292_73344[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (5))){
var _ = (function (){var statearr_73293 = state_73269;
(statearr_73293[(4)] = cljs.core.rest((state_73269[(4)])));

return statearr_73293;
})();
var state_73269__$1 = state_73269;
var ex73290 = (state_73269__$1[(2)]);
var statearr_73294_73345 = state_73269__$1;
(statearr_73294_73345[(5)] = ex73290);


if((ex73290 instanceof Error)){
var statearr_73295_73346 = state_73269__$1;
(statearr_73295_73346[(1)] = (4));

(statearr_73295_73346[(5)] = null);

} else {
throw ex73290;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (14))){
var state_73269__$1 = state_73269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73269__$1,(17),where);
} else {
if((state_val_73270 === (26))){
var inst_73215 = (state_73269[(8)]);
var inst_73231 = (state_73269[(9)]);
var inst_73223 = (state_73269[(10)]);
var inst_73239 = (state_73269[(7)]);
var inst_73251 = (state_73269[(2)]);
var inst_73252 = fluree.db.util.async.throw_err(inst_73251);
var inst_73253 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73252,(0),null);
var inst_73254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73252,(1),null);
var inst_73255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73256 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73258 = [inst_73215,inst_73223,inst_73231,inst_73239];
var inst_73259 = (new cljs.core.PersistentVector(null,4,(5),inst_73257,inst_73258,null));
var inst_73260 = ["query",inst_73259,inst_73253];
var inst_73261 = cljs.core.PersistentHashMap.fromArrays(inst_73256,inst_73260);
var inst_73262 = [inst_73261,inst_73254];
var inst_73263 = (new cljs.core.PersistentVector(null,2,(5),inst_73255,inst_73262,null));
var inst_73264 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73263);
var _ = (function (){var statearr_73296 = state_73269;
(statearr_73296[(4)] = cljs.core.rest((state_73269[(4)])));

return statearr_73296;
})();
var state_73269__$1 = (function (){var statearr_73297 = state_73269;
(statearr_73297[(11)] = inst_73264);

return statearr_73297;
})();
var statearr_73298_73347 = state_73269__$1;
(statearr_73298_73347[(2)] = inst_73253);

(statearr_73298_73347[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (16))){
var inst_73231 = (state_73269[(2)]);
var inst_73232 = fluree.db.util.async.channel_QMARK_(block);
var state_73269__$1 = (function (){var statearr_73299 = state_73269;
(statearr_73299[(9)] = inst_73231);

return statearr_73299;
})();
if(inst_73232){
var statearr_73300_73348 = state_73269__$1;
(statearr_73300_73348[(1)] = (18));

} else {
var statearr_73301_73349 = state_73269__$1;
(statearr_73301_73349[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73270 === (10))){
var state_73269__$1 = state_73269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73269__$1,(13),from);
} else {
if((state_val_73270 === (18))){
var state_73269__$1 = state_73269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73269__$1,(21),block);
} else {
if((state_val_73270 === (8))){
var inst_73215 = (state_73269[(2)]);
var inst_73216 = fluree.db.util.async.channel_QMARK_(from);
var state_73269__$1 = (function (){var statearr_73302 = state_73269;
(statearr_73302[(8)] = inst_73215);

return statearr_73302;
})();
if(inst_73216){
var statearr_73303_73350 = state_73269__$1;
(statearr_73303_73350[(1)] = (10));

} else {
var statearr_73304_73351 = state_73269__$1;
(statearr_73304_73351[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_73305 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73305[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_73305[(1)] = (1));

return statearr_73305;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_73269){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73269);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73306){var ex__14781__auto__ = e73306;
var statearr_73307_73352 = state_73269;
(statearr_73307_73352[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73269[(4)]))){
var statearr_73308_73353 = state_73269;
(statearr_73308_73353[(1)] = cljs.core.first((state_73269[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73354 = state_73269;
state_73269 = G__73354;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_73269){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_73269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73309 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73309[(6)] = c__14852__auto__);

return statearr_73309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73410){
var state_val_73411 = (state_73410[(1)]);
if((state_val_73411 === (7))){
var state_73410__$1 = state_73410;
var statearr_73412_73443 = state_73410__$1;
(statearr_73412_73443[(2)] = startSubject);

(statearr_73412_73443[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (1))){
var state_73410__$1 = state_73410;
var statearr_73413_73444 = state_73410__$1;
(statearr_73413_73444[(2)] = null);

(statearr_73413_73444[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (4))){
var inst_73355 = (state_73410[(2)]);
var state_73410__$1 = state_73410;
var statearr_73414_73445 = state_73410__$1;
(statearr_73414_73445[(2)] = inst_73355);

(statearr_73414_73445[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (15))){
var inst_73387 = (state_73410[(2)]);
var inst_73388 = fluree.db.util.async.throw_err(inst_73387);
var inst_73389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73388,(0),null);
var inst_73390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73388,(1),null);
var inst_73391 = cljs.core.empty_QMARK_(inst_73389);
var state_73410__$1 = (function (){var statearr_73415 = state_73410;
(statearr_73415[(7)] = inst_73390);

return statearr_73415;
})();
if(inst_73391){
var statearr_73416_73446 = state_73410__$1;
(statearr_73416_73446[(1)] = (16));

} else {
var statearr_73417_73447 = state_73410__$1;
(statearr_73417_73447[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (13))){
var inst_73375 = (state_73410[(8)]);
var inst_73383 = (state_73410[(9)]);
var inst_73371 = (state_73410[(10)]);
var inst_73383__$1 = (state_73410[(2)]);
var inst_73384 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73385 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_73384,inst_73371,inst_73375,inst_73383__$1);
var state_73410__$1 = (function (){var statearr_73418 = state_73410;
(statearr_73418[(9)] = inst_73383__$1);

return statearr_73418;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73410__$1,(15),inst_73385);
} else {
if((state_val_73411 === (6))){
var state_73410__$1 = state_73410;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73410__$1,(9),startSubject);
} else {
if((state_val_73411 === (17))){
var state_73410__$1 = state_73410;
var statearr_73419_73448 = state_73410__$1;
(statearr_73419_73448[(2)] = true);

(statearr_73419_73448[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (3))){
var inst_73408 = (state_73410[(2)]);
var state_73410__$1 = state_73410;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73410__$1,inst_73408);
} else {
if((state_val_73411 === (12))){
var state_73410__$1 = state_73410;
var statearr_73420_73449 = state_73410__$1;
(statearr_73420_73449[(2)] = endSubject);

(statearr_73420_73449[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (2))){
var _ = (function (){var statearr_73421 = state_73410;
(statearr_73421[(4)] = cljs.core.cons((5),(state_73410[(4)])));

return statearr_73421;
})();
var inst_73364 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_73410__$1 = state_73410;
if(inst_73364){
var statearr_73422_73450 = state_73410__$1;
(statearr_73422_73450[(1)] = (6));

} else {
var statearr_73423_73451 = state_73410__$1;
(statearr_73423_73451[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (11))){
var state_73410__$1 = state_73410;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73410__$1,(14),endSubject);
} else {
if((state_val_73411 === (9))){
var inst_73367 = (state_73410[(2)]);
var inst_73368 = fluree.db.util.async.throw_err(inst_73367);
var state_73410__$1 = state_73410;
var statearr_73425_73452 = state_73410__$1;
(statearr_73425_73452[(2)] = inst_73368);

(statearr_73425_73452[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (5))){
var _ = (function (){var statearr_73426 = state_73410;
(statearr_73426[(4)] = cljs.core.rest((state_73410[(4)])));

return statearr_73426;
})();
var state_73410__$1 = state_73410;
var ex73424 = (state_73410__$1[(2)]);
var statearr_73427_73453 = state_73410__$1;
(statearr_73427_73453[(5)] = ex73424);


if((ex73424 instanceof Error)){
var statearr_73428_73454 = state_73410__$1;
(statearr_73428_73454[(1)] = (4));

(statearr_73428_73454[(5)] = null);

} else {
throw ex73424;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (14))){
var inst_73379 = (state_73410[(2)]);
var inst_73380 = fluree.db.util.async.throw_err(inst_73379);
var state_73410__$1 = state_73410;
var statearr_73429_73455 = state_73410__$1;
(statearr_73429_73455[(2)] = inst_73380);

(statearr_73429_73455[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (16))){
var state_73410__$1 = state_73410;
var statearr_73430_73456 = state_73410__$1;
(statearr_73430_73456[(2)] = false);

(statearr_73430_73456[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (10))){
var inst_73374 = (state_73410[(2)]);
var inst_73375 = fluree.db.util.async.throw_err(inst_73374);
var inst_73376 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_73410__$1 = (function (){var statearr_73431 = state_73410;
(statearr_73431[(8)] = inst_73375);

return statearr_73431;
})();
if(inst_73376){
var statearr_73432_73457 = state_73410__$1;
(statearr_73432_73457[(1)] = (11));

} else {
var statearr_73433_73458 = state_73410__$1;
(statearr_73433_73458[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (18))){
var inst_73375 = (state_73410[(8)]);
var inst_73383 = (state_73410[(9)]);
var inst_73390 = (state_73410[(7)]);
var inst_73371 = (state_73410[(10)]);
var inst_73395 = (state_73410[(2)]);
var inst_73396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73397 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73399 = [inst_73371,inst_73375,inst_73383];
var inst_73400 = (new cljs.core.PersistentVector(null,3,(5),inst_73398,inst_73399,null));
var inst_73401 = ["relationship?",inst_73400,inst_73395];
var inst_73402 = cljs.core.PersistentHashMap.fromArrays(inst_73397,inst_73401);
var inst_73403 = [inst_73402,inst_73390];
var inst_73404 = (new cljs.core.PersistentVector(null,2,(5),inst_73396,inst_73403,null));
var inst_73405 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73404);
var _ = (function (){var statearr_73434 = state_73410;
(statearr_73434[(4)] = cljs.core.rest((state_73410[(4)])));

return statearr_73434;
})();
var state_73410__$1 = (function (){var statearr_73435 = state_73410;
(statearr_73435[(11)] = inst_73405);

return statearr_73435;
})();
var statearr_73436_73459 = state_73410__$1;
(statearr_73436_73459[(2)] = inst_73395);

(statearr_73436_73459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73411 === (8))){
var inst_73371 = (state_73410[(2)]);
var inst_73372 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_73410__$1 = (function (){var statearr_73437 = state_73410;
(statearr_73437[(10)] = inst_73371);

return statearr_73437;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73410__$1,(10),inst_73372);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto____0 = (function (){
var statearr_73438 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73438[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto__);

(statearr_73438[(1)] = (1));

return statearr_73438;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto____1 = (function (state_73410){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73410);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73439){var ex__14781__auto__ = e73439;
var statearr_73440_73460 = state_73410;
(statearr_73440_73460[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73410[(4)]))){
var statearr_73441_73461 = state_73410;
(statearr_73441_73461[(1)] = cljs.core.first((state_73410[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73462 = state_73410;
state_73410 = G__73462;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto__ = function(state_73410){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto____1.call(this,state_73410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73442 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73442[(6)] = c__14852__auto__);

return statearr_73442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73499){
var state_val_73500 = (state_73499[(1)]);
if((state_val_73500 === (7))){
var state_73499__$1 = state_73499;
var statearr_73501_73521 = state_73499__$1;
(statearr_73501_73521[(2)] = pred_name);

(statearr_73501_73521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73500 === (1))){
var state_73499__$1 = state_73499;
var statearr_73502_73522 = state_73499__$1;
(statearr_73502_73522[(2)] = null);

(statearr_73502_73522[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73500 === (4))){
var inst_73463 = (state_73499[(2)]);
var state_73499__$1 = state_73499;
var statearr_73503_73523 = state_73499__$1;
(statearr_73503_73523[(2)] = inst_73463);

(statearr_73503_73523[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73500 === (6))){
var state_73499__$1 = state_73499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73499__$1,(9),pred_name);
} else {
if((state_val_73500 === (3))){
var inst_73497 = (state_73499[(2)]);
var state_73499__$1 = state_73499;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73499__$1,inst_73497);
} else {
if((state_val_73500 === (2))){
var _ = (function (){var statearr_73505 = state_73499;
(statearr_73505[(4)] = cljs.core.cons((5),(state_73499[(4)])));

return statearr_73505;
})();
var inst_73472 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_73499__$1 = state_73499;
if(inst_73472){
var statearr_73506_73524 = state_73499__$1;
(statearr_73506_73524[(1)] = (6));

} else {
var statearr_73507_73525 = state_73499__$1;
(statearr_73507_73525[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73500 === (9))){
var inst_73475 = (state_73499[(2)]);
var inst_73476 = fluree.db.util.async.throw_err(inst_73475);
var state_73499__$1 = state_73499;
var statearr_73508_73526 = state_73499__$1;
(statearr_73508_73526[(2)] = inst_73476);

(statearr_73508_73526[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73500 === (5))){
var _ = (function (){var statearr_73509 = state_73499;
(statearr_73509[(4)] = cljs.core.rest((state_73499[(4)])));

return statearr_73509;
})();
var state_73499__$1 = state_73499;
var ex73504 = (state_73499__$1[(2)]);
var statearr_73510_73527 = state_73499__$1;
(statearr_73510_73527[(5)] = ex73504);


if((ex73504 instanceof Error)){
var statearr_73511_73528 = state_73499__$1;
(statearr_73511_73528[(1)] = (4));

(statearr_73511_73528[(5)] = null);

} else {
throw ex73504;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73500 === (10))){
var inst_73479 = (state_73499[(7)]);
var inst_73483 = (state_73499[(2)]);
var inst_73484 = fluree.db.util.async.throw_err(inst_73483);
var inst_73485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73484,(0),null);
var inst_73486 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73484,(1),null);
var inst_73487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73488 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73489 = ["max-pred-val",inst_73479,inst_73485];
var inst_73490 = cljs.core.PersistentHashMap.fromArrays(inst_73488,inst_73489);
var inst_73491 = (inst_73486 + (10));
var inst_73492 = [inst_73490,inst_73491];
var inst_73493 = (new cljs.core.PersistentVector(null,2,(5),inst_73487,inst_73492,null));
var inst_73494 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73493);
var _ = (function (){var statearr_73512 = state_73499;
(statearr_73512[(4)] = cljs.core.rest((state_73499[(4)])));

return statearr_73512;
})();
var state_73499__$1 = (function (){var statearr_73513 = state_73499;
(statearr_73513[(8)] = inst_73494);

return statearr_73513;
})();
var statearr_73514_73529 = state_73499__$1;
(statearr_73514_73529[(2)] = inst_73485);

(statearr_73514_73529[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73500 === (8))){
var inst_73479 = (state_73499[(7)]);
var inst_73479__$1 = (state_73499[(2)]);
var inst_73480 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73481 = fluree.db.dbfunctions.internal.max_pred_val(inst_73480,inst_73479__$1,null);
var state_73499__$1 = (function (){var statearr_73515 = state_73499;
(statearr_73515[(7)] = inst_73479__$1);

return statearr_73515;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73499__$1,(10),inst_73481);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto____0 = (function (){
var statearr_73516 = [null,null,null,null,null,null,null,null,null];
(statearr_73516[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto__);

(statearr_73516[(1)] = (1));

return statearr_73516;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto____1 = (function (state_73499){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73499);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73517){var ex__14781__auto__ = e73517;
var statearr_73518_73530 = state_73499;
(statearr_73518_73530[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73499[(4)]))){
var statearr_73519_73531 = state_73499;
(statearr_73519_73531[(1)] = cljs.core.first((state_73499[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73532 = state_73499;
state_73499 = G__73532;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto__ = function(state_73499){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto____1.call(this,state_73499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73520 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73520[(6)] = c__14852__auto__);

return statearr_73520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73559){
var state_val_73560 = (state_73559[(1)]);
if((state_val_73560 === (7))){
var state_73559__$1 = state_73559;
var statearr_73561_73580 = state_73559__$1;
(statearr_73561_73580[(2)] = n);

(statearr_73561_73580[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73560 === (1))){
var state_73559__$1 = state_73559;
var statearr_73562_73581 = state_73559__$1;
(statearr_73562_73581[(2)] = null);

(statearr_73562_73581[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73560 === (4))){
var inst_73533 = (state_73559[(2)]);
var state_73559__$1 = state_73559;
var statearr_73563_73582 = state_73559__$1;
(statearr_73563_73582[(2)] = inst_73533);

(statearr_73563_73582[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73560 === (6))){
var state_73559__$1 = state_73559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73559__$1,(9),n);
} else {
if((state_val_73560 === (3))){
var inst_73557 = (state_73559[(2)]);
var state_73559__$1 = state_73559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73559__$1,inst_73557);
} else {
if((state_val_73560 === (2))){
var _ = (function (){var statearr_73565 = state_73559;
(statearr_73565[(4)] = cljs.core.cons((5),(state_73559[(4)])));

return statearr_73565;
})();
var inst_73539 = fluree.db.util.async.channel_QMARK_(n);
var state_73559__$1 = state_73559;
if(inst_73539){
var statearr_73566_73583 = state_73559__$1;
(statearr_73566_73583[(1)] = (6));

} else {
var statearr_73567_73584 = state_73559__$1;
(statearr_73567_73584[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73560 === (9))){
var inst_73542 = (state_73559[(2)]);
var inst_73543 = fluree.db.util.async.throw_err(inst_73542);
var state_73559__$1 = state_73559;
var statearr_73568_73585 = state_73559__$1;
(statearr_73568_73585[(2)] = inst_73543);

(statearr_73568_73585[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73560 === (5))){
var _ = (function (){var statearr_73569 = state_73559;
(statearr_73569[(4)] = cljs.core.rest((state_73559[(4)])));

return statearr_73569;
})();
var state_73559__$1 = state_73559;
var ex73564 = (state_73559__$1[(2)]);
var statearr_73570_73586 = state_73559__$1;
(statearr_73570_73586[(5)] = ex73564);


if((ex73564 instanceof Error)){
var statearr_73571_73587 = state_73559__$1;
(statearr_73571_73587[(1)] = (4));

(statearr_73571_73587[(5)] = null);

} else {
throw ex73564;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73560 === (8))){
var inst_73546 = (state_73559[(2)]);
var inst_73547 = fluree.db.dbfunctions.internal.inc(inst_73546);
var inst_73548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73549 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73550 = ["inc",inst_73546,inst_73547];
var inst_73551 = cljs.core.PersistentHashMap.fromArrays(inst_73549,inst_73550);
var inst_73552 = [inst_73551,(10)];
var inst_73553 = (new cljs.core.PersistentVector(null,2,(5),inst_73548,inst_73552,null));
var inst_73554 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73553);
var _ = (function (){var statearr_73572 = state_73559;
(statearr_73572[(4)] = cljs.core.rest((state_73559[(4)])));

return statearr_73572;
})();
var state_73559__$1 = (function (){var statearr_73573 = state_73559;
(statearr_73573[(7)] = inst_73554);

return statearr_73573;
})();
var statearr_73574_73588 = state_73559__$1;
(statearr_73574_73588[(2)] = inst_73547);

(statearr_73574_73588[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto____0 = (function (){
var statearr_73575 = [null,null,null,null,null,null,null,null];
(statearr_73575[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto__);

(statearr_73575[(1)] = (1));

return statearr_73575;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto____1 = (function (state_73559){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73559);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73576){var ex__14781__auto__ = e73576;
var statearr_73577_73589 = state_73559;
(statearr_73577_73589[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73559[(4)]))){
var statearr_73578_73590 = state_73559;
(statearr_73578_73590[(1)] = cljs.core.first((state_73559[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73591 = state_73559;
state_73559 = G__73591;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto__ = function(state_73559){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto____1.call(this,state_73559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73579 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73579[(6)] = c__14852__auto__);

return statearr_73579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73618){
var state_val_73619 = (state_73618[(1)]);
if((state_val_73619 === (7))){
var state_73618__$1 = state_73618;
var statearr_73620_73639 = state_73618__$1;
(statearr_73620_73639[(2)] = n);

(statearr_73620_73639[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73619 === (1))){
var state_73618__$1 = state_73618;
var statearr_73621_73640 = state_73618__$1;
(statearr_73621_73640[(2)] = null);

(statearr_73621_73640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73619 === (4))){
var inst_73592 = (state_73618[(2)]);
var state_73618__$1 = state_73618;
var statearr_73622_73641 = state_73618__$1;
(statearr_73622_73641[(2)] = inst_73592);

(statearr_73622_73641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73619 === (6))){
var state_73618__$1 = state_73618;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73618__$1,(9),n);
} else {
if((state_val_73619 === (3))){
var inst_73616 = (state_73618[(2)]);
var state_73618__$1 = state_73618;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73618__$1,inst_73616);
} else {
if((state_val_73619 === (2))){
var _ = (function (){var statearr_73624 = state_73618;
(statearr_73624[(4)] = cljs.core.cons((5),(state_73618[(4)])));

return statearr_73624;
})();
var inst_73598 = fluree.db.util.async.channel_QMARK_(n);
var state_73618__$1 = state_73618;
if(inst_73598){
var statearr_73625_73642 = state_73618__$1;
(statearr_73625_73642[(1)] = (6));

} else {
var statearr_73626_73643 = state_73618__$1;
(statearr_73626_73643[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73619 === (9))){
var inst_73601 = (state_73618[(2)]);
var inst_73602 = fluree.db.util.async.throw_err(inst_73601);
var state_73618__$1 = state_73618;
var statearr_73627_73644 = state_73618__$1;
(statearr_73627_73644[(2)] = inst_73602);

(statearr_73627_73644[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73619 === (5))){
var _ = (function (){var statearr_73628 = state_73618;
(statearr_73628[(4)] = cljs.core.rest((state_73618[(4)])));

return statearr_73628;
})();
var state_73618__$1 = state_73618;
var ex73623 = (state_73618__$1[(2)]);
var statearr_73629_73645 = state_73618__$1;
(statearr_73629_73645[(5)] = ex73623);


if((ex73623 instanceof Error)){
var statearr_73630_73646 = state_73618__$1;
(statearr_73630_73646[(1)] = (4));

(statearr_73630_73646[(5)] = null);

} else {
throw ex73623;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73619 === (8))){
var inst_73605 = (state_73618[(2)]);
var inst_73606 = fluree.db.dbfunctions.internal.dec(inst_73605);
var inst_73607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73608 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73609 = ["dec",inst_73605,inst_73606];
var inst_73610 = cljs.core.PersistentHashMap.fromArrays(inst_73608,inst_73609);
var inst_73611 = [inst_73610,(10)];
var inst_73612 = (new cljs.core.PersistentVector(null,2,(5),inst_73607,inst_73611,null));
var inst_73613 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73612);
var _ = (function (){var statearr_73631 = state_73618;
(statearr_73631[(4)] = cljs.core.rest((state_73618[(4)])));

return statearr_73631;
})();
var state_73618__$1 = (function (){var statearr_73632 = state_73618;
(statearr_73632[(7)] = inst_73613);

return statearr_73632;
})();
var statearr_73633_73647 = state_73618__$1;
(statearr_73633_73647[(2)] = inst_73606);

(statearr_73633_73647[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto____0 = (function (){
var statearr_73634 = [null,null,null,null,null,null,null,null];
(statearr_73634[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto__);

(statearr_73634[(1)] = (1));

return statearr_73634;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto____1 = (function (state_73618){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73618);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73635){var ex__14781__auto__ = e73635;
var statearr_73636_73648 = state_73618;
(statearr_73636_73648[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73618[(4)]))){
var statearr_73637_73649 = state_73618;
(statearr_73637_73649[(1)] = cljs.core.first((state_73618[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73650 = state_73618;
state_73618 = G__73650;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto__ = function(state_73618){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto____1.call(this,state_73618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73638 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73638[(6)] = c__14852__auto__);

return statearr_73638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73700 = arguments.length;
var i__4830__auto___73701 = (0);
while(true){
if((i__4830__auto___73701 < len__4829__auto___73700)){
args__4835__auto__.push((arguments[i__4830__auto___73701]));

var G__73702 = (i__4830__auto___73701 + (1));
i__4830__auto___73701 = G__73702;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73683){
var state_val_73684 = (state_73683[(1)]);
if((state_val_73684 === (1))){
var state_73683__$1 = state_73683;
var statearr_73685_73703 = state_73683__$1;
(statearr_73685_73703[(2)] = null);

(statearr_73685_73703[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73684 === (2))){
var _ = (function (){var statearr_73686 = state_73683;
(statearr_73686[(4)] = cljs.core.cons((5),(state_73683[(4)])));

return statearr_73686;
})();
var inst_73659 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73683__$1 = state_73683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73683__$1,(6),inst_73659);
} else {
if((state_val_73684 === (3))){
var inst_73681 = (state_73683[(2)]);
var state_73683__$1 = state_73683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73683__$1,inst_73681);
} else {
if((state_val_73684 === (4))){
var inst_73653 = (state_73683[(2)]);
var state_73683__$1 = state_73683;
var statearr_73688_73704 = state_73683__$1;
(statearr_73688_73704[(2)] = inst_73653);

(statearr_73688_73704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73684 === (5))){
var _ = (function (){var statearr_73689 = state_73683;
(statearr_73689[(4)] = cljs.core.rest((state_73683[(4)])));

return statearr_73689;
})();
var state_73683__$1 = state_73683;
var ex73687 = (state_73683__$1[(2)]);
var statearr_73690_73705 = state_73683__$1;
(statearr_73690_73705[(5)] = ex73687);


if((ex73687 instanceof Error)){
var statearr_73691_73706 = state_73683__$1;
(statearr_73691_73706[(1)] = (4));

(statearr_73691_73706[(5)] = null);

} else {
throw ex73687;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73684 === (6))){
var inst_73661 = (state_73683[(2)]);
var inst_73662 = fluree.db.util.async.throw_err(inst_73661);
var inst_73663 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_73662);
var inst_73664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73665 = [inst_73662];
var inst_73666 = (new cljs.core.PersistentVector(null,1,(5),inst_73664,inst_73665,null));
var inst_73667 = cljs.core.count(inst_73666);
var inst_73668 = ((9) + inst_73667);
var inst_73669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73670 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73672 = [inst_73662];
var inst_73673 = (new cljs.core.PersistentVector(null,1,(5),inst_73671,inst_73672,null));
var inst_73674 = ["+",inst_73673,inst_73663];
var inst_73675 = cljs.core.PersistentHashMap.fromArrays(inst_73670,inst_73674);
var inst_73676 = [inst_73675,inst_73668];
var inst_73677 = (new cljs.core.PersistentVector(null,2,(5),inst_73669,inst_73676,null));
var inst_73678 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73677);
var _ = (function (){var statearr_73692 = state_73683;
(statearr_73692[(4)] = cljs.core.rest((state_73683[(4)])));

return statearr_73692;
})();
var state_73683__$1 = (function (){var statearr_73693 = state_73683;
(statearr_73693[(7)] = inst_73678);

return statearr_73693;
})();
var statearr_73694_73707 = state_73683__$1;
(statearr_73694_73707[(2)] = inst_73663);

(statearr_73694_73707[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_73695 = [null,null,null,null,null,null,null,null];
(statearr_73695[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_73695[(1)] = (1));

return statearr_73695;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_73683){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73683);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73696){var ex__14781__auto__ = e73696;
var statearr_73697_73708 = state_73683;
(statearr_73697_73708[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73683[(4)]))){
var statearr_73698_73709 = state_73683;
(statearr_73698_73709[(1)] = cljs.core.first((state_73683[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73710 = state_73683;
state_73683 = G__73710;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_73683){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_73683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73699 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73699[(6)] = c__14852__auto__);

return statearr_73699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq73651){
var G__73652 = cljs.core.first(seq73651);
var seq73651__$1 = cljs.core.next(seq73651);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73652,seq73651__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73760 = arguments.length;
var i__4830__auto___73761 = (0);
while(true){
if((i__4830__auto___73761 < len__4829__auto___73760)){
args__4835__auto__.push((arguments[i__4830__auto___73761]));

var G__73762 = (i__4830__auto___73761 + (1));
i__4830__auto___73761 = G__73762;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73743){
var state_val_73744 = (state_73743[(1)]);
if((state_val_73744 === (1))){
var state_73743__$1 = state_73743;
var statearr_73745_73763 = state_73743__$1;
(statearr_73745_73763[(2)] = null);

(statearr_73745_73763[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73744 === (2))){
var _ = (function (){var statearr_73746 = state_73743;
(statearr_73746[(4)] = cljs.core.cons((5),(state_73743[(4)])));

return statearr_73746;
})();
var inst_73719 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73743__$1 = state_73743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73743__$1,(6),inst_73719);
} else {
if((state_val_73744 === (3))){
var inst_73741 = (state_73743[(2)]);
var state_73743__$1 = state_73743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73743__$1,inst_73741);
} else {
if((state_val_73744 === (4))){
var inst_73713 = (state_73743[(2)]);
var state_73743__$1 = state_73743;
var statearr_73748_73764 = state_73743__$1;
(statearr_73748_73764[(2)] = inst_73713);

(statearr_73748_73764[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73744 === (5))){
var _ = (function (){var statearr_73749 = state_73743;
(statearr_73749[(4)] = cljs.core.rest((state_73743[(4)])));

return statearr_73749;
})();
var state_73743__$1 = state_73743;
var ex73747 = (state_73743__$1[(2)]);
var statearr_73750_73765 = state_73743__$1;
(statearr_73750_73765[(5)] = ex73747);


if((ex73747 instanceof Error)){
var statearr_73751_73766 = state_73743__$1;
(statearr_73751_73766[(1)] = (4));

(statearr_73751_73766[(5)] = null);

} else {
throw ex73747;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73744 === (6))){
var inst_73721 = (state_73743[(2)]);
var inst_73722 = fluree.db.util.async.throw_err(inst_73721);
var inst_73723 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_73722);
var inst_73724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73725 = [inst_73722];
var inst_73726 = (new cljs.core.PersistentVector(null,1,(5),inst_73724,inst_73725,null));
var inst_73727 = cljs.core.count(inst_73726);
var inst_73728 = ((9) + inst_73727);
var inst_73729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73730 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73732 = [inst_73722];
var inst_73733 = (new cljs.core.PersistentVector(null,1,(5),inst_73731,inst_73732,null));
var inst_73734 = ["-",inst_73733,inst_73723];
var inst_73735 = cljs.core.PersistentHashMap.fromArrays(inst_73730,inst_73734);
var inst_73736 = [inst_73735,inst_73728];
var inst_73737 = (new cljs.core.PersistentVector(null,2,(5),inst_73729,inst_73736,null));
var inst_73738 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73737);
var _ = (function (){var statearr_73752 = state_73743;
(statearr_73752[(4)] = cljs.core.rest((state_73743[(4)])));

return statearr_73752;
})();
var state_73743__$1 = (function (){var statearr_73753 = state_73743;
(statearr_73753[(7)] = inst_73738);

return statearr_73753;
})();
var statearr_73754_73767 = state_73743__$1;
(statearr_73754_73767[(2)] = inst_73723);

(statearr_73754_73767[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_73755 = [null,null,null,null,null,null,null,null];
(statearr_73755[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_73755[(1)] = (1));

return statearr_73755;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_73743){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73743);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73756){var ex__14781__auto__ = e73756;
var statearr_73757_73768 = state_73743;
(statearr_73757_73768[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73743[(4)]))){
var statearr_73758_73769 = state_73743;
(statearr_73758_73769[(1)] = cljs.core.first((state_73743[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73770 = state_73743;
state_73743 = G__73770;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_73743){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_73743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73759 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73759[(6)] = c__14852__auto__);

return statearr_73759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq73711){
var G__73712 = cljs.core.first(seq73711);
var seq73711__$1 = cljs.core.next(seq73711);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73712,seq73711__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73820 = arguments.length;
var i__4830__auto___73821 = (0);
while(true){
if((i__4830__auto___73821 < len__4829__auto___73820)){
args__4835__auto__.push((arguments[i__4830__auto___73821]));

var G__73822 = (i__4830__auto___73821 + (1));
i__4830__auto___73821 = G__73822;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73803){
var state_val_73804 = (state_73803[(1)]);
if((state_val_73804 === (1))){
var state_73803__$1 = state_73803;
var statearr_73805_73823 = state_73803__$1;
(statearr_73805_73823[(2)] = null);

(statearr_73805_73823[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73804 === (2))){
var _ = (function (){var statearr_73806 = state_73803;
(statearr_73806[(4)] = cljs.core.cons((5),(state_73803[(4)])));

return statearr_73806;
})();
var inst_73779 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73803__$1 = state_73803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73803__$1,(6),inst_73779);
} else {
if((state_val_73804 === (3))){
var inst_73801 = (state_73803[(2)]);
var state_73803__$1 = state_73803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73803__$1,inst_73801);
} else {
if((state_val_73804 === (4))){
var inst_73773 = (state_73803[(2)]);
var state_73803__$1 = state_73803;
var statearr_73808_73824 = state_73803__$1;
(statearr_73808_73824[(2)] = inst_73773);

(statearr_73808_73824[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73804 === (5))){
var _ = (function (){var statearr_73809 = state_73803;
(statearr_73809[(4)] = cljs.core.rest((state_73803[(4)])));

return statearr_73809;
})();
var state_73803__$1 = state_73803;
var ex73807 = (state_73803__$1[(2)]);
var statearr_73810_73825 = state_73803__$1;
(statearr_73810_73825[(5)] = ex73807);


if((ex73807 instanceof Error)){
var statearr_73811_73826 = state_73803__$1;
(statearr_73811_73826[(1)] = (4));

(statearr_73811_73826[(5)] = null);

} else {
throw ex73807;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73804 === (6))){
var inst_73781 = (state_73803[(2)]);
var inst_73782 = fluree.db.util.async.throw_err(inst_73781);
var inst_73783 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_73782);
var inst_73784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73785 = [inst_73782];
var inst_73786 = (new cljs.core.PersistentVector(null,1,(5),inst_73784,inst_73785,null));
var inst_73787 = cljs.core.count(inst_73786);
var inst_73788 = ((9) + inst_73787);
var inst_73789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73790 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73792 = [inst_73782];
var inst_73793 = (new cljs.core.PersistentVector(null,1,(5),inst_73791,inst_73792,null));
var inst_73794 = ["*",inst_73793,inst_73783];
var inst_73795 = cljs.core.PersistentHashMap.fromArrays(inst_73790,inst_73794);
var inst_73796 = [inst_73795,inst_73788];
var inst_73797 = (new cljs.core.PersistentVector(null,2,(5),inst_73789,inst_73796,null));
var inst_73798 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73797);
var _ = (function (){var statearr_73812 = state_73803;
(statearr_73812[(4)] = cljs.core.rest((state_73803[(4)])));

return statearr_73812;
})();
var state_73803__$1 = (function (){var statearr_73813 = state_73803;
(statearr_73813[(7)] = inst_73798);

return statearr_73813;
})();
var statearr_73814_73827 = state_73803__$1;
(statearr_73814_73827[(2)] = inst_73783);

(statearr_73814_73827[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_73815 = [null,null,null,null,null,null,null,null];
(statearr_73815[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_73815[(1)] = (1));

return statearr_73815;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_73803){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73803);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73816){var ex__14781__auto__ = e73816;
var statearr_73817_73828 = state_73803;
(statearr_73817_73828[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73803[(4)]))){
var statearr_73818_73829 = state_73803;
(statearr_73818_73829[(1)] = cljs.core.first((state_73803[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73830 = state_73803;
state_73803 = G__73830;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_73803){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_73803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73819 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73819[(6)] = c__14852__auto__);

return statearr_73819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq73771){
var G__73772 = cljs.core.first(seq73771);
var seq73771__$1 = cljs.core.next(seq73771);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73772,seq73771__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73880 = arguments.length;
var i__4830__auto___73881 = (0);
while(true){
if((i__4830__auto___73881 < len__4829__auto___73880)){
args__4835__auto__.push((arguments[i__4830__auto___73881]));

var G__73882 = (i__4830__auto___73881 + (1));
i__4830__auto___73881 = G__73882;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73863){
var state_val_73864 = (state_73863[(1)]);
if((state_val_73864 === (1))){
var state_73863__$1 = state_73863;
var statearr_73865_73883 = state_73863__$1;
(statearr_73865_73883[(2)] = null);

(statearr_73865_73883[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73864 === (2))){
var _ = (function (){var statearr_73866 = state_73863;
(statearr_73866[(4)] = cljs.core.cons((5),(state_73863[(4)])));

return statearr_73866;
})();
var inst_73839 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73863__$1 = state_73863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73863__$1,(6),inst_73839);
} else {
if((state_val_73864 === (3))){
var inst_73861 = (state_73863[(2)]);
var state_73863__$1 = state_73863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73863__$1,inst_73861);
} else {
if((state_val_73864 === (4))){
var inst_73833 = (state_73863[(2)]);
var state_73863__$1 = state_73863;
var statearr_73868_73884 = state_73863__$1;
(statearr_73868_73884[(2)] = inst_73833);

(statearr_73868_73884[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73864 === (5))){
var _ = (function (){var statearr_73869 = state_73863;
(statearr_73869[(4)] = cljs.core.rest((state_73863[(4)])));

return statearr_73869;
})();
var state_73863__$1 = state_73863;
var ex73867 = (state_73863__$1[(2)]);
var statearr_73870_73885 = state_73863__$1;
(statearr_73870_73885[(5)] = ex73867);


if((ex73867 instanceof Error)){
var statearr_73871_73886 = state_73863__$1;
(statearr_73871_73886[(1)] = (4));

(statearr_73871_73886[(5)] = null);

} else {
throw ex73867;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73864 === (6))){
var inst_73841 = (state_73863[(2)]);
var inst_73842 = fluree.db.util.async.throw_err(inst_73841);
var inst_73843 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_73842);
var inst_73844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73845 = [inst_73842];
var inst_73846 = (new cljs.core.PersistentVector(null,1,(5),inst_73844,inst_73845,null));
var inst_73847 = cljs.core.count(inst_73846);
var inst_73848 = ((9) + inst_73847);
var inst_73849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73850 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73852 = [inst_73842];
var inst_73853 = (new cljs.core.PersistentVector(null,1,(5),inst_73851,inst_73852,null));
var inst_73854 = ["/",inst_73853,inst_73843];
var inst_73855 = cljs.core.PersistentHashMap.fromArrays(inst_73850,inst_73854);
var inst_73856 = [inst_73855,inst_73848];
var inst_73857 = (new cljs.core.PersistentVector(null,2,(5),inst_73849,inst_73856,null));
var inst_73858 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73857);
var _ = (function (){var statearr_73872 = state_73863;
(statearr_73872[(4)] = cljs.core.rest((state_73863[(4)])));

return statearr_73872;
})();
var state_73863__$1 = (function (){var statearr_73873 = state_73863;
(statearr_73873[(7)] = inst_73858);

return statearr_73873;
})();
var statearr_73874_73887 = state_73863__$1;
(statearr_73874_73887[(2)] = inst_73843);

(statearr_73874_73887[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_73875 = [null,null,null,null,null,null,null,null];
(statearr_73875[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_73875[(1)] = (1));

return statearr_73875;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_73863){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73863);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73876){var ex__14781__auto__ = e73876;
var statearr_73877_73888 = state_73863;
(statearr_73877_73888[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73863[(4)]))){
var statearr_73878_73889 = state_73863;
(statearr_73878_73889[(1)] = cljs.core.first((state_73863[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73890 = state_73863;
state_73863 = G__73890;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_73863){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_73863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73879 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73879[(6)] = c__14852__auto__);

return statearr_73879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq73831){
var G__73832 = cljs.core.first(seq73831);
var seq73831__$1 = cljs.core.next(seq73831);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73832,seq73831__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_73928){
var state_val_73929 = (state_73928[(1)]);
if((state_val_73929 === (7))){
var state_73928__$1 = state_73928;
var statearr_73930_73954 = state_73928__$1;
(statearr_73930_73954[(2)] = n);

(statearr_73930_73954[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73929 === (1))){
var state_73928__$1 = state_73928;
var statearr_73931_73955 = state_73928__$1;
(statearr_73931_73955[(2)] = null);

(statearr_73931_73955[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73929 === (4))){
var inst_73891 = (state_73928[(2)]);
var state_73928__$1 = state_73928;
var statearr_73932_73956 = state_73928__$1;
(statearr_73932_73956[(2)] = inst_73891);

(statearr_73932_73956[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73929 === (13))){
var inst_73908 = (state_73928[(2)]);
var inst_73909 = fluree.db.util.async.throw_err(inst_73908);
var state_73928__$1 = state_73928;
var statearr_73933_73957 = state_73928__$1;
(statearr_73933_73957[(2)] = inst_73909);

(statearr_73933_73957[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73929 === (6))){
var state_73928__$1 = state_73928;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73928__$1,(9),n);
} else {
if((state_val_73929 === (3))){
var inst_73926 = (state_73928[(2)]);
var state_73928__$1 = state_73928;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73928__$1,inst_73926);
} else {
if((state_val_73929 === (12))){
var inst_73904 = (state_73928[(7)]);
var inst_73912 = (state_73928[(2)]);
var inst_73913 = fluree.db.dbfunctions.internal.quot(inst_73904,inst_73912);
var inst_73914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73915 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73917 = [inst_73904,inst_73912];
var inst_73918 = (new cljs.core.PersistentVector(null,2,(5),inst_73916,inst_73917,null));
var inst_73919 = ["quot",inst_73918,inst_73913];
var inst_73920 = cljs.core.PersistentHashMap.fromArrays(inst_73915,inst_73919);
var inst_73921 = [inst_73920,(2)];
var inst_73922 = (new cljs.core.PersistentVector(null,2,(5),inst_73914,inst_73921,null));
var inst_73923 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73922);
var _ = (function (){var statearr_73934 = state_73928;
(statearr_73934[(4)] = cljs.core.rest((state_73928[(4)])));

return statearr_73934;
})();
var state_73928__$1 = (function (){var statearr_73935 = state_73928;
(statearr_73935[(8)] = inst_73923);

return statearr_73935;
})();
var statearr_73936_73958 = state_73928__$1;
(statearr_73936_73958[(2)] = inst_73913);

(statearr_73936_73958[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73929 === (2))){
var _ = (function (){var statearr_73937 = state_73928;
(statearr_73937[(4)] = cljs.core.cons((5),(state_73928[(4)])));

return statearr_73937;
})();
var inst_73897 = fluree.db.util.async.channel_QMARK_(n);
var state_73928__$1 = state_73928;
if(inst_73897){
var statearr_73938_73959 = state_73928__$1;
(statearr_73938_73959[(1)] = (6));

} else {
var statearr_73939_73960 = state_73928__$1;
(statearr_73939_73960[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73929 === (11))){
var state_73928__$1 = state_73928;
var statearr_73941_73961 = state_73928__$1;
(statearr_73941_73961[(2)] = d);

(statearr_73941_73961[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73929 === (9))){
var inst_73900 = (state_73928[(2)]);
var inst_73901 = fluree.db.util.async.throw_err(inst_73900);
var state_73928__$1 = state_73928;
var statearr_73942_73962 = state_73928__$1;
(statearr_73942_73962[(2)] = inst_73901);

(statearr_73942_73962[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73929 === (5))){
var _ = (function (){var statearr_73943 = state_73928;
(statearr_73943[(4)] = cljs.core.rest((state_73928[(4)])));

return statearr_73943;
})();
var state_73928__$1 = state_73928;
var ex73940 = (state_73928__$1[(2)]);
var statearr_73944_73963 = state_73928__$1;
(statearr_73944_73963[(5)] = ex73940);


if((ex73940 instanceof Error)){
var statearr_73945_73964 = state_73928__$1;
(statearr_73945_73964[(1)] = (4));

(statearr_73945_73964[(5)] = null);

} else {
throw ex73940;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73929 === (10))){
var state_73928__$1 = state_73928;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73928__$1,(13),d);
} else {
if((state_val_73929 === (8))){
var inst_73904 = (state_73928[(2)]);
var inst_73905 = fluree.db.util.async.channel_QMARK_(d);
var state_73928__$1 = (function (){var statearr_73946 = state_73928;
(statearr_73946[(7)] = inst_73904);

return statearr_73946;
})();
if(inst_73905){
var statearr_73947_73965 = state_73928__$1;
(statearr_73947_73965[(1)] = (10));

} else {
var statearr_73948_73966 = state_73928__$1;
(statearr_73948_73966[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto____0 = (function (){
var statearr_73949 = [null,null,null,null,null,null,null,null,null];
(statearr_73949[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto__);

(statearr_73949[(1)] = (1));

return statearr_73949;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto____1 = (function (state_73928){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_73928);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e73950){var ex__14781__auto__ = e73950;
var statearr_73951_73967 = state_73928;
(statearr_73951_73967[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_73928[(4)]))){
var statearr_73952_73968 = state_73928;
(statearr_73952_73968[(1)] = cljs.core.first((state_73928[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__73969 = state_73928;
state_73928 = G__73969;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto__ = function(state_73928){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto____1.call(this,state_73928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_73953 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_73953[(6)] = c__14852__auto__);

return statearr_73953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74007){
var state_val_74008 = (state_74007[(1)]);
if((state_val_74008 === (7))){
var state_74007__$1 = state_74007;
var statearr_74009_74033 = state_74007__$1;
(statearr_74009_74033[(2)] = n);

(statearr_74009_74033[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74008 === (1))){
var state_74007__$1 = state_74007;
var statearr_74010_74034 = state_74007__$1;
(statearr_74010_74034[(2)] = null);

(statearr_74010_74034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74008 === (4))){
var inst_73970 = (state_74007[(2)]);
var state_74007__$1 = state_74007;
var statearr_74011_74035 = state_74007__$1;
(statearr_74011_74035[(2)] = inst_73970);

(statearr_74011_74035[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74008 === (13))){
var inst_73987 = (state_74007[(2)]);
var inst_73988 = fluree.db.util.async.throw_err(inst_73987);
var state_74007__$1 = state_74007;
var statearr_74012_74036 = state_74007__$1;
(statearr_74012_74036[(2)] = inst_73988);

(statearr_74012_74036[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74008 === (6))){
var state_74007__$1 = state_74007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74007__$1,(9),n);
} else {
if((state_val_74008 === (3))){
var inst_74005 = (state_74007[(2)]);
var state_74007__$1 = state_74007;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74007__$1,inst_74005);
} else {
if((state_val_74008 === (12))){
var inst_73983 = (state_74007[(7)]);
var inst_73991 = (state_74007[(2)]);
var inst_73992 = fluree.db.dbfunctions.internal.mod(inst_73983,inst_73991);
var inst_73993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73994 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73996 = [inst_73983,inst_73991];
var inst_73997 = (new cljs.core.PersistentVector(null,2,(5),inst_73995,inst_73996,null));
var inst_73998 = ["mod",inst_73997,inst_73992];
var inst_73999 = cljs.core.PersistentHashMap.fromArrays(inst_73994,inst_73998);
var inst_74000 = [inst_73999,(2)];
var inst_74001 = (new cljs.core.PersistentVector(null,2,(5),inst_73993,inst_74000,null));
var inst_74002 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74001);
var _ = (function (){var statearr_74013 = state_74007;
(statearr_74013[(4)] = cljs.core.rest((state_74007[(4)])));

return statearr_74013;
})();
var state_74007__$1 = (function (){var statearr_74014 = state_74007;
(statearr_74014[(8)] = inst_74002);

return statearr_74014;
})();
var statearr_74015_74037 = state_74007__$1;
(statearr_74015_74037[(2)] = inst_73992);

(statearr_74015_74037[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74008 === (2))){
var _ = (function (){var statearr_74016 = state_74007;
(statearr_74016[(4)] = cljs.core.cons((5),(state_74007[(4)])));

return statearr_74016;
})();
var inst_73976 = fluree.db.util.async.channel_QMARK_(n);
var state_74007__$1 = state_74007;
if(inst_73976){
var statearr_74017_74038 = state_74007__$1;
(statearr_74017_74038[(1)] = (6));

} else {
var statearr_74018_74039 = state_74007__$1;
(statearr_74018_74039[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74008 === (11))){
var state_74007__$1 = state_74007;
var statearr_74020_74040 = state_74007__$1;
(statearr_74020_74040[(2)] = d);

(statearr_74020_74040[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74008 === (9))){
var inst_73979 = (state_74007[(2)]);
var inst_73980 = fluree.db.util.async.throw_err(inst_73979);
var state_74007__$1 = state_74007;
var statearr_74021_74041 = state_74007__$1;
(statearr_74021_74041[(2)] = inst_73980);

(statearr_74021_74041[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74008 === (5))){
var _ = (function (){var statearr_74022 = state_74007;
(statearr_74022[(4)] = cljs.core.rest((state_74007[(4)])));

return statearr_74022;
})();
var state_74007__$1 = state_74007;
var ex74019 = (state_74007__$1[(2)]);
var statearr_74023_74042 = state_74007__$1;
(statearr_74023_74042[(5)] = ex74019);


if((ex74019 instanceof Error)){
var statearr_74024_74043 = state_74007__$1;
(statearr_74024_74043[(1)] = (4));

(statearr_74024_74043[(5)] = null);

} else {
throw ex74019;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74008 === (10))){
var state_74007__$1 = state_74007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74007__$1,(13),d);
} else {
if((state_val_74008 === (8))){
var inst_73983 = (state_74007[(2)]);
var inst_73984 = fluree.db.util.async.channel_QMARK_(d);
var state_74007__$1 = (function (){var statearr_74025 = state_74007;
(statearr_74025[(7)] = inst_73983);

return statearr_74025;
})();
if(inst_73984){
var statearr_74026_74044 = state_74007__$1;
(statearr_74026_74044[(1)] = (10));

} else {
var statearr_74027_74045 = state_74007__$1;
(statearr_74027_74045[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto____0 = (function (){
var statearr_74028 = [null,null,null,null,null,null,null,null,null];
(statearr_74028[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto__);

(statearr_74028[(1)] = (1));

return statearr_74028;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto____1 = (function (state_74007){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74007);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74029){var ex__14781__auto__ = e74029;
var statearr_74030_74046 = state_74007;
(statearr_74030_74046[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74007[(4)]))){
var statearr_74031_74047 = state_74007;
(statearr_74031_74047[(1)] = cljs.core.first((state_74007[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74048 = state_74007;
state_74007 = G__74048;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto__ = function(state_74007){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto____1.call(this,state_74007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74032 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74032[(6)] = c__14852__auto__);

return statearr_74032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74086){
var state_val_74087 = (state_74086[(1)]);
if((state_val_74087 === (7))){
var state_74086__$1 = state_74086;
var statearr_74088_74112 = state_74086__$1;
(statearr_74088_74112[(2)] = n);

(statearr_74088_74112[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74087 === (1))){
var state_74086__$1 = state_74086;
var statearr_74089_74113 = state_74086__$1;
(statearr_74089_74113[(2)] = null);

(statearr_74089_74113[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74087 === (4))){
var inst_74049 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74090_74114 = state_74086__$1;
(statearr_74090_74114[(2)] = inst_74049);

(statearr_74090_74114[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74087 === (13))){
var inst_74066 = (state_74086[(2)]);
var inst_74067 = fluree.db.util.async.throw_err(inst_74066);
var state_74086__$1 = state_74086;
var statearr_74091_74115 = state_74086__$1;
(statearr_74091_74115[(2)] = inst_74067);

(statearr_74091_74115[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74087 === (6))){
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74086__$1,(9),n);
} else {
if((state_val_74087 === (3))){
var inst_74084 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74086__$1,inst_74084);
} else {
if((state_val_74087 === (12))){
var inst_74062 = (state_74086[(7)]);
var inst_74070 = (state_74086[(2)]);
var inst_74071 = fluree.db.dbfunctions.internal.rem(inst_74062,inst_74070);
var inst_74072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74073 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74075 = [inst_74062,inst_74070];
var inst_74076 = (new cljs.core.PersistentVector(null,2,(5),inst_74074,inst_74075,null));
var inst_74077 = ["rem",inst_74076,inst_74071];
var inst_74078 = cljs.core.PersistentHashMap.fromArrays(inst_74073,inst_74077);
var inst_74079 = [inst_74078,(2)];
var inst_74080 = (new cljs.core.PersistentVector(null,2,(5),inst_74072,inst_74079,null));
var inst_74081 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74080);
var _ = (function (){var statearr_74092 = state_74086;
(statearr_74092[(4)] = cljs.core.rest((state_74086[(4)])));

return statearr_74092;
})();
var state_74086__$1 = (function (){var statearr_74093 = state_74086;
(statearr_74093[(8)] = inst_74081);

return statearr_74093;
})();
var statearr_74094_74116 = state_74086__$1;
(statearr_74094_74116[(2)] = inst_74071);

(statearr_74094_74116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74087 === (2))){
var _ = (function (){var statearr_74095 = state_74086;
(statearr_74095[(4)] = cljs.core.cons((5),(state_74086[(4)])));

return statearr_74095;
})();
var inst_74055 = fluree.db.util.async.channel_QMARK_(n);
var state_74086__$1 = state_74086;
if(inst_74055){
var statearr_74096_74117 = state_74086__$1;
(statearr_74096_74117[(1)] = (6));

} else {
var statearr_74097_74118 = state_74086__$1;
(statearr_74097_74118[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74087 === (11))){
var state_74086__$1 = state_74086;
var statearr_74099_74119 = state_74086__$1;
(statearr_74099_74119[(2)] = d);

(statearr_74099_74119[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74087 === (9))){
var inst_74058 = (state_74086[(2)]);
var inst_74059 = fluree.db.util.async.throw_err(inst_74058);
var state_74086__$1 = state_74086;
var statearr_74100_74120 = state_74086__$1;
(statearr_74100_74120[(2)] = inst_74059);

(statearr_74100_74120[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74087 === (5))){
var _ = (function (){var statearr_74101 = state_74086;
(statearr_74101[(4)] = cljs.core.rest((state_74086[(4)])));

return statearr_74101;
})();
var state_74086__$1 = state_74086;
var ex74098 = (state_74086__$1[(2)]);
var statearr_74102_74121 = state_74086__$1;
(statearr_74102_74121[(5)] = ex74098);


if((ex74098 instanceof Error)){
var statearr_74103_74122 = state_74086__$1;
(statearr_74103_74122[(1)] = (4));

(statearr_74103_74122[(5)] = null);

} else {
throw ex74098;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74087 === (10))){
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74086__$1,(13),d);
} else {
if((state_val_74087 === (8))){
var inst_74062 = (state_74086[(2)]);
var inst_74063 = fluree.db.util.async.channel_QMARK_(d);
var state_74086__$1 = (function (){var statearr_74104 = state_74086;
(statearr_74104[(7)] = inst_74062);

return statearr_74104;
})();
if(inst_74063){
var statearr_74105_74123 = state_74086__$1;
(statearr_74105_74123[(1)] = (10));

} else {
var statearr_74106_74124 = state_74086__$1;
(statearr_74106_74124[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto____0 = (function (){
var statearr_74107 = [null,null,null,null,null,null,null,null,null];
(statearr_74107[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto__);

(statearr_74107[(1)] = (1));

return statearr_74107;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto____1 = (function (state_74086){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74086);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74108){var ex__14781__auto__ = e74108;
var statearr_74109_74125 = state_74086;
(statearr_74109_74125[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74086[(4)]))){
var statearr_74110_74126 = state_74086;
(statearr_74110_74126[(1)] = cljs.core.first((state_74086[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74127 = state_74086;
state_74086 = G__74127;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto__ = function(state_74086){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto____1.call(this,state_74086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74111 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74111[(6)] = c__14852__auto__);

return statearr_74111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74154){
var state_val_74155 = (state_74154[(1)]);
if((state_val_74155 === (7))){
var state_74154__$1 = state_74154;
var statearr_74156_74175 = state_74154__$1;
(statearr_74156_74175[(2)] = x);

(statearr_74156_74175[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74155 === (1))){
var state_74154__$1 = state_74154;
var statearr_74157_74176 = state_74154__$1;
(statearr_74157_74176[(2)] = null);

(statearr_74157_74176[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74155 === (4))){
var inst_74128 = (state_74154[(2)]);
var state_74154__$1 = state_74154;
var statearr_74158_74177 = state_74154__$1;
(statearr_74158_74177[(2)] = inst_74128);

(statearr_74158_74177[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74155 === (6))){
var state_74154__$1 = state_74154;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74154__$1,(9),x);
} else {
if((state_val_74155 === (3))){
var inst_74152 = (state_74154[(2)]);
var state_74154__$1 = state_74154;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74154__$1,inst_74152);
} else {
if((state_val_74155 === (2))){
var _ = (function (){var statearr_74160 = state_74154;
(statearr_74160[(4)] = cljs.core.cons((5),(state_74154[(4)])));

return statearr_74160;
})();
var inst_74134 = fluree.db.util.async.channel_QMARK_(x);
var state_74154__$1 = state_74154;
if(inst_74134){
var statearr_74161_74178 = state_74154__$1;
(statearr_74161_74178[(1)] = (6));

} else {
var statearr_74162_74179 = state_74154__$1;
(statearr_74162_74179[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74155 === (9))){
var inst_74137 = (state_74154[(2)]);
var inst_74138 = fluree.db.util.async.throw_err(inst_74137);
var state_74154__$1 = state_74154;
var statearr_74163_74180 = state_74154__$1;
(statearr_74163_74180[(2)] = inst_74138);

(statearr_74163_74180[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74155 === (5))){
var _ = (function (){var statearr_74164 = state_74154;
(statearr_74164[(4)] = cljs.core.rest((state_74154[(4)])));

return statearr_74164;
})();
var state_74154__$1 = state_74154;
var ex74159 = (state_74154__$1[(2)]);
var statearr_74165_74181 = state_74154__$1;
(statearr_74165_74181[(5)] = ex74159);


if((ex74159 instanceof Error)){
var statearr_74166_74182 = state_74154__$1;
(statearr_74166_74182[(1)] = (4));

(statearr_74166_74182[(5)] = null);

} else {
throw ex74159;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74155 === (8))){
var inst_74141 = (state_74154[(2)]);
var inst_74142 = fluree.db.dbfunctions.internal.boolean$(inst_74141);
var inst_74143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74144 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74145 = ["boolean",inst_74141,inst_74142];
var inst_74146 = cljs.core.PersistentHashMap.fromArrays(inst_74144,inst_74145);
var inst_74147 = [inst_74146,(10)];
var inst_74148 = (new cljs.core.PersistentVector(null,2,(5),inst_74143,inst_74147,null));
var inst_74149 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74148);
var _ = (function (){var statearr_74167 = state_74154;
(statearr_74167[(4)] = cljs.core.rest((state_74154[(4)])));

return statearr_74167;
})();
var state_74154__$1 = (function (){var statearr_74168 = state_74154;
(statearr_74168[(7)] = inst_74149);

return statearr_74168;
})();
var statearr_74169_74183 = state_74154__$1;
(statearr_74169_74183[(2)] = inst_74142);

(statearr_74169_74183[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto____0 = (function (){
var statearr_74170 = [null,null,null,null,null,null,null,null];
(statearr_74170[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto__);

(statearr_74170[(1)] = (1));

return statearr_74170;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto____1 = (function (state_74154){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74154);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74171){var ex__14781__auto__ = e74171;
var statearr_74172_74184 = state_74154;
(statearr_74172_74184[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74154[(4)]))){
var statearr_74173_74185 = state_74154;
(statearr_74173_74185[(1)] = cljs.core.first((state_74154[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74186 = state_74154;
state_74154 = G__74186;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto__ = function(state_74154){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto____1.call(this,state_74154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74174 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74174[(6)] = c__14852__auto__);

return statearr_74174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74224){
var state_val_74225 = (state_74224[(1)]);
if((state_val_74225 === (7))){
var state_74224__$1 = state_74224;
var statearr_74226_74250 = state_74224__$1;
(statearr_74226_74250[(2)] = pattern);

(statearr_74226_74250[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74225 === (1))){
var state_74224__$1 = state_74224;
var statearr_74227_74251 = state_74224__$1;
(statearr_74227_74251[(2)] = null);

(statearr_74227_74251[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74225 === (4))){
var inst_74187 = (state_74224[(2)]);
var state_74224__$1 = state_74224;
var statearr_74228_74252 = state_74224__$1;
(statearr_74228_74252[(2)] = inst_74187);

(statearr_74228_74252[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74225 === (13))){
var inst_74204 = (state_74224[(2)]);
var inst_74205 = fluree.db.util.async.throw_err(inst_74204);
var state_74224__$1 = state_74224;
var statearr_74229_74253 = state_74224__$1;
(statearr_74229_74253[(2)] = inst_74205);

(statearr_74229_74253[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74225 === (6))){
var state_74224__$1 = state_74224;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74224__$1,(9),pattern);
} else {
if((state_val_74225 === (3))){
var inst_74222 = (state_74224[(2)]);
var state_74224__$1 = state_74224;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74224__$1,inst_74222);
} else {
if((state_val_74225 === (12))){
var inst_74200 = (state_74224[(7)]);
var inst_74208 = (state_74224[(2)]);
var inst_74209 = fluree.db.dbfunctions.internal.re_find(inst_74200,inst_74208);
var inst_74210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74211 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74213 = [inst_74200,inst_74208];
var inst_74214 = (new cljs.core.PersistentVector(null,2,(5),inst_74212,inst_74213,null));
var inst_74215 = ["re-find",inst_74214,inst_74209];
var inst_74216 = cljs.core.PersistentHashMap.fromArrays(inst_74211,inst_74215);
var inst_74217 = [inst_74216,(10)];
var inst_74218 = (new cljs.core.PersistentVector(null,2,(5),inst_74210,inst_74217,null));
var inst_74219 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74218);
var _ = (function (){var statearr_74230 = state_74224;
(statearr_74230[(4)] = cljs.core.rest((state_74224[(4)])));

return statearr_74230;
})();
var state_74224__$1 = (function (){var statearr_74231 = state_74224;
(statearr_74231[(8)] = inst_74219);

return statearr_74231;
})();
var statearr_74232_74254 = state_74224__$1;
(statearr_74232_74254[(2)] = inst_74209);

(statearr_74232_74254[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74225 === (2))){
var _ = (function (){var statearr_74233 = state_74224;
(statearr_74233[(4)] = cljs.core.cons((5),(state_74224[(4)])));

return statearr_74233;
})();
var inst_74193 = fluree.db.util.async.channel_QMARK_(pattern);
var state_74224__$1 = state_74224;
if(inst_74193){
var statearr_74234_74255 = state_74224__$1;
(statearr_74234_74255[(1)] = (6));

} else {
var statearr_74235_74256 = state_74224__$1;
(statearr_74235_74256[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74225 === (11))){
var state_74224__$1 = state_74224;
var statearr_74237_74257 = state_74224__$1;
(statearr_74237_74257[(2)] = string);

(statearr_74237_74257[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74225 === (9))){
var inst_74196 = (state_74224[(2)]);
var inst_74197 = fluree.db.util.async.throw_err(inst_74196);
var state_74224__$1 = state_74224;
var statearr_74238_74258 = state_74224__$1;
(statearr_74238_74258[(2)] = inst_74197);

(statearr_74238_74258[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74225 === (5))){
var _ = (function (){var statearr_74239 = state_74224;
(statearr_74239[(4)] = cljs.core.rest((state_74224[(4)])));

return statearr_74239;
})();
var state_74224__$1 = state_74224;
var ex74236 = (state_74224__$1[(2)]);
var statearr_74240_74259 = state_74224__$1;
(statearr_74240_74259[(5)] = ex74236);


if((ex74236 instanceof Error)){
var statearr_74241_74260 = state_74224__$1;
(statearr_74241_74260[(1)] = (4));

(statearr_74241_74260[(5)] = null);

} else {
throw ex74236;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74225 === (10))){
var state_74224__$1 = state_74224;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74224__$1,(13),string);
} else {
if((state_val_74225 === (8))){
var inst_74200 = (state_74224[(2)]);
var inst_74201 = fluree.db.util.async.channel_QMARK_(string);
var state_74224__$1 = (function (){var statearr_74242 = state_74224;
(statearr_74242[(7)] = inst_74200);

return statearr_74242;
})();
if(inst_74201){
var statearr_74243_74261 = state_74224__$1;
(statearr_74243_74261[(1)] = (10));

} else {
var statearr_74244_74262 = state_74224__$1;
(statearr_74244_74262[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto____0 = (function (){
var statearr_74245 = [null,null,null,null,null,null,null,null,null];
(statearr_74245[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto__);

(statearr_74245[(1)] = (1));

return statearr_74245;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto____1 = (function (state_74224){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74224);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74246){var ex__14781__auto__ = e74246;
var statearr_74247_74263 = state_74224;
(statearr_74247_74263[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74224[(4)]))){
var statearr_74248_74264 = state_74224;
(statearr_74248_74264[(1)] = cljs.core.first((state_74224[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74265 = state_74224;
state_74224 = G__74265;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto__ = function(state_74224){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto____1.call(this,state_74224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74249 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74249[(6)] = c__14852__auto__);

return statearr_74249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74292){
var state_val_74293 = (state_74292[(1)]);
if((state_val_74293 === (7))){
var state_74292__$1 = state_74292;
var statearr_74294_74313 = state_74292__$1;
(statearr_74294_74313[(2)] = email);

(statearr_74294_74313[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74293 === (1))){
var state_74292__$1 = state_74292;
var statearr_74295_74314 = state_74292__$1;
(statearr_74295_74314[(2)] = null);

(statearr_74295_74314[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74293 === (4))){
var inst_74266 = (state_74292[(2)]);
var state_74292__$1 = state_74292;
var statearr_74296_74315 = state_74292__$1;
(statearr_74296_74315[(2)] = inst_74266);

(statearr_74296_74315[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74293 === (6))){
var state_74292__$1 = state_74292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74292__$1,(9),email);
} else {
if((state_val_74293 === (3))){
var inst_74290 = (state_74292[(2)]);
var state_74292__$1 = state_74292;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74292__$1,inst_74290);
} else {
if((state_val_74293 === (2))){
var _ = (function (){var statearr_74298 = state_74292;
(statearr_74298[(4)] = cljs.core.cons((5),(state_74292[(4)])));

return statearr_74298;
})();
var inst_74272 = fluree.db.util.async.channel_QMARK_(email);
var state_74292__$1 = state_74292;
if(inst_74272){
var statearr_74299_74316 = state_74292__$1;
(statearr_74299_74316[(1)] = (6));

} else {
var statearr_74300_74317 = state_74292__$1;
(statearr_74300_74317[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74293 === (9))){
var inst_74275 = (state_74292[(2)]);
var inst_74276 = fluree.db.util.async.throw_err(inst_74275);
var state_74292__$1 = state_74292;
var statearr_74301_74318 = state_74292__$1;
(statearr_74301_74318[(2)] = inst_74276);

(statearr_74301_74318[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74293 === (5))){
var _ = (function (){var statearr_74302 = state_74292;
(statearr_74302[(4)] = cljs.core.rest((state_74292[(4)])));

return statearr_74302;
})();
var state_74292__$1 = state_74292;
var ex74297 = (state_74292__$1[(2)]);
var statearr_74303_74319 = state_74292__$1;
(statearr_74303_74319[(5)] = ex74297);


if((ex74297 instanceof Error)){
var statearr_74304_74320 = state_74292__$1;
(statearr_74304_74320[(1)] = (4));

(statearr_74304_74320[(5)] = null);

} else {
throw ex74297;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74293 === (8))){
var inst_74279 = (state_74292[(2)]);
var inst_74280 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_74279);
var inst_74281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74282 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74283 = ["re-find",inst_74279,inst_74280];
var inst_74284 = cljs.core.PersistentHashMap.fromArrays(inst_74282,inst_74283);
var inst_74285 = [inst_74284,(10)];
var inst_74286 = (new cljs.core.PersistentVector(null,2,(5),inst_74281,inst_74285,null));
var inst_74287 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74286);
var _ = (function (){var statearr_74305 = state_74292;
(statearr_74305[(4)] = cljs.core.rest((state_74292[(4)])));

return statearr_74305;
})();
var state_74292__$1 = (function (){var statearr_74306 = state_74292;
(statearr_74306[(7)] = inst_74287);

return statearr_74306;
})();
var statearr_74307_74321 = state_74292__$1;
(statearr_74307_74321[(2)] = inst_74280);

(statearr_74307_74321[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto____0 = (function (){
var statearr_74308 = [null,null,null,null,null,null,null,null];
(statearr_74308[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto__);

(statearr_74308[(1)] = (1));

return statearr_74308;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto____1 = (function (state_74292){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74292);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74309){var ex__14781__auto__ = e74309;
var statearr_74310_74322 = state_74292;
(statearr_74310_74322[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74292[(4)]))){
var statearr_74311_74323 = state_74292;
(statearr_74311_74323[(1)] = cljs.core.first((state_74292[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74324 = state_74292;
state_74292 = G__74324;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto__ = function(state_74292){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto____1.call(this,state_74292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74312 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74312[(6)] = c__14852__auto__);

return statearr_74312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74371){
var state_val_74372 = (state_74371[(1)]);
if((state_val_74372 === (7))){
var inst_74341 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_74371__$1 = state_74371;
if(cljs.core.truth_(inst_74341)){
var statearr_74373_74400 = state_74371__$1;
(statearr_74373_74400[(1)] = (9));

} else {
var statearr_74374_74401 = state_74371__$1;
(statearr_74374_74401[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (1))){
var state_74371__$1 = state_74371;
var statearr_74375_74402 = state_74371__$1;
(statearr_74375_74402[(2)] = null);

(statearr_74375_74402[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (4))){
var inst_74325 = (state_74371[(2)]);
var state_74371__$1 = state_74371;
var statearr_74376_74403 = state_74371__$1;
(statearr_74376_74403[(2)] = inst_74325);

(statearr_74376_74403[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (15))){
var inst_74352 = (state_74371[(2)]);
var state_74371__$1 = state_74371;
var statearr_74377_74404 = state_74371__$1;
(statearr_74377_74404[(2)] = inst_74352);

(statearr_74377_74404[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (13))){
var inst_74349 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_74371__$1 = state_74371;
var statearr_74378_74405 = state_74371__$1;
(statearr_74378_74405[(2)] = inst_74349);

(statearr_74378_74405[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (6))){
var inst_74336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74337 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74338 = [inst_74337,(0)];
var inst_74339 = (new cljs.core.PersistentVector(null,2,(5),inst_74336,inst_74338,null));
var state_74371__$1 = state_74371;
var statearr_74379_74406 = state_74371__$1;
(statearr_74379_74406[(2)] = inst_74339);

(statearr_74379_74406[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (3))){
var inst_74369 = (state_74371[(2)]);
var state_74371__$1 = state_74371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74371__$1,inst_74369);
} else {
if((state_val_74372 === (12))){
var inst_74345 = (state_74371[(2)]);
var inst_74346 = fluree.db.util.async.throw_err(inst_74345);
var state_74371__$1 = state_74371;
var statearr_74380_74407 = state_74371__$1;
(statearr_74380_74407[(2)] = inst_74346);

(statearr_74380_74407[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (2))){
var _ = (function (){var statearr_74381 = state_74371;
(statearr_74381[(4)] = cljs.core.cons((5),(state_74371[(4)])));

return statearr_74381;
})();
var inst_74334 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_74371__$1 = state_74371;
if(cljs.core.truth_(inst_74334)){
var statearr_74382_74408 = state_74371__$1;
(statearr_74382_74408[(1)] = (6));

} else {
var statearr_74383_74409 = state_74371__$1;
(statearr_74383_74409[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (11))){
var inst_74354 = (state_74371[(2)]);
var state_74371__$1 = state_74371;
var statearr_74385_74410 = state_74371__$1;
(statearr_74385_74410[(2)] = inst_74354);

(statearr_74385_74410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (9))){
var inst_74343 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_74371__$1 = state_74371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74371__$1,(12),inst_74343);
} else {
if((state_val_74372 === (5))){
var _ = (function (){var statearr_74386 = state_74371;
(statearr_74386[(4)] = cljs.core.rest((state_74371[(4)])));

return statearr_74386;
})();
var state_74371__$1 = state_74371;
var ex74384 = (state_74371__$1[(2)]);
var statearr_74387_74411 = state_74371__$1;
(statearr_74387_74411[(5)] = ex74384);


if((ex74384 instanceof Error)){
var statearr_74388_74412 = state_74371__$1;
(statearr_74388_74412[(1)] = (4));

(statearr_74388_74412[(5)] = null);

} else {
throw ex74384;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (14))){
var state_74371__$1 = state_74371;
var statearr_74389_74413 = state_74371__$1;
(statearr_74389_74413[(2)] = null);

(statearr_74389_74413[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (10))){
var state_74371__$1 = state_74371;
var statearr_74390_74414 = state_74371__$1;
(statearr_74390_74414[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74372 === (8))){
var inst_74356 = (state_74371[(2)]);
var inst_74357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74356,(0),null);
var inst_74358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74356,(1),null);
var inst_74359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74360 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74361 = ["?user_id","?ctx",inst_74357];
var inst_74362 = cljs.core.PersistentHashMap.fromArrays(inst_74360,inst_74361);
var inst_74363 = ((10) + inst_74358);
var inst_74364 = [inst_74362,inst_74363];
var inst_74365 = (new cljs.core.PersistentVector(null,2,(5),inst_74359,inst_74364,null));
var inst_74366 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74365);
var _ = (function (){var statearr_74392 = state_74371;
(statearr_74392[(4)] = cljs.core.rest((state_74371[(4)])));

return statearr_74392;
})();
var state_74371__$1 = (function (){var statearr_74393 = state_74371;
(statearr_74393[(7)] = inst_74366);

return statearr_74393;
})();
var statearr_74394_74415 = state_74371__$1;
(statearr_74394_74415[(2)] = inst_74357);

(statearr_74394_74415[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto____0 = (function (){
var statearr_74395 = [null,null,null,null,null,null,null,null];
(statearr_74395[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto__);

(statearr_74395[(1)] = (1));

return statearr_74395;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto____1 = (function (state_74371){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74371);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74396){var ex__14781__auto__ = e74396;
var statearr_74397_74416 = state_74371;
(statearr_74397_74416[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74371[(4)]))){
var statearr_74398_74417 = state_74371;
(statearr_74398_74417[(1)] = cljs.core.first((state_74371[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74418 = state_74371;
state_74371 = G__74418;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto__ = function(state_74371){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto____1.call(this,state_74371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74399 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74399[(6)] = c__14852__auto__);

return statearr_74399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74446){
var state_val_74447 = (state_74446[(1)]);
if((state_val_74447 === (7))){
var inst_74439 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_74446__$1 = state_74446;
var statearr_74448_74467 = state_74446__$1;
(statearr_74448_74467[(2)] = inst_74439);

(statearr_74448_74467[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74447 === (1))){
var state_74446__$1 = state_74446;
var statearr_74449_74468 = state_74446__$1;
(statearr_74449_74468[(2)] = null);

(statearr_74449_74468[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74447 === (4))){
var inst_74419 = (state_74446[(2)]);
var state_74446__$1 = state_74446;
var statearr_74450_74469 = state_74446__$1;
(statearr_74450_74469[(2)] = inst_74419);

(statearr_74450_74469[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74447 === (6))){
var inst_74427 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_74446__$1 = state_74446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74446__$1,(9),inst_74427);
} else {
if((state_val_74447 === (3))){
var inst_74444 = (state_74446[(2)]);
var state_74446__$1 = state_74446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74446__$1,inst_74444);
} else {
if((state_val_74447 === (2))){
var _ = (function (){var statearr_74452 = state_74446;
(statearr_74452[(4)] = cljs.core.cons((5),(state_74446[(4)])));

return statearr_74452;
})();
var inst_74425 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_74446__$1 = state_74446;
if(cljs.core.truth_(inst_74425)){
var statearr_74453_74470 = state_74446__$1;
(statearr_74453_74470[(1)] = (6));

} else {
var statearr_74454_74471 = state_74446__$1;
(statearr_74454_74471[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74447 === (9))){
var inst_74429 = (state_74446[(2)]);
var inst_74430 = fluree.db.util.async.throw_err(inst_74429);
var inst_74431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74432 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74433 = ["?auth_id","?ctx",inst_74430];
var inst_74434 = cljs.core.PersistentHashMap.fromArrays(inst_74432,inst_74433);
var inst_74435 = [inst_74434,(10)];
var inst_74436 = (new cljs.core.PersistentVector(null,2,(5),inst_74431,inst_74435,null));
var inst_74437 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74436);
var state_74446__$1 = (function (){var statearr_74455 = state_74446;
(statearr_74455[(7)] = inst_74437);

return statearr_74455;
})();
var statearr_74456_74472 = state_74446__$1;
(statearr_74456_74472[(2)] = inst_74430);

(statearr_74456_74472[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74447 === (5))){
var _ = (function (){var statearr_74457 = state_74446;
(statearr_74457[(4)] = cljs.core.rest((state_74446[(4)])));

return statearr_74457;
})();
var state_74446__$1 = state_74446;
var ex74451 = (state_74446__$1[(2)]);
var statearr_74458_74473 = state_74446__$1;
(statearr_74458_74473[(5)] = ex74451);


if((ex74451 instanceof Error)){
var statearr_74459_74474 = state_74446__$1;
(statearr_74459_74474[(1)] = (4));

(statearr_74459_74474[(5)] = null);

} else {
throw ex74451;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74447 === (8))){
var inst_74441 = (state_74446[(2)]);
var _ = (function (){var statearr_74460 = state_74446;
(statearr_74460[(4)] = cljs.core.rest((state_74446[(4)])));

return statearr_74460;
})();
var state_74446__$1 = state_74446;
var statearr_74461_74475 = state_74446__$1;
(statearr_74461_74475[(2)] = inst_74441);

(statearr_74461_74475[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto____0 = (function (){
var statearr_74462 = [null,null,null,null,null,null,null,null];
(statearr_74462[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto__);

(statearr_74462[(1)] = (1));

return statearr_74462;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto____1 = (function (state_74446){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74446);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74463){var ex__14781__auto__ = e74463;
var statearr_74464_74476 = state_74446;
(statearr_74464_74476[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74446[(4)]))){
var statearr_74465_74477 = state_74446;
(statearr_74465_74477[(1)] = cljs.core.first((state_74446[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74478 = state_74446;
state_74446 = G__74478;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto__ = function(state_74446){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto____1.call(this,state_74446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74466 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74466[(6)] = c__14852__auto__);

return statearr_74466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__74480 = arguments.length;
switch (G__74480) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74522){
var state_val_74523 = (state_74522[(1)]);
if((state_val_74523 === (7))){
var state_74522__$1 = state_74522;
var statearr_74524_74554 = state_74522__$1;
(statearr_74524_74554[(2)] = seed);

(statearr_74524_74554[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (1))){
var state_74522__$1 = state_74522;
var statearr_74525_74555 = state_74522__$1;
(statearr_74525_74555[(2)] = null);

(statearr_74525_74555[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (4))){
var inst_74481 = (state_74522[(2)]);
var state_74522__$1 = state_74522;
var statearr_74526_74556 = state_74522__$1;
(statearr_74526_74556[(2)] = inst_74481);

(statearr_74526_74556[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (15))){
var state_74522__$1 = state_74522;
var statearr_74527_74557 = state_74522__$1;
(statearr_74527_74557[(2)] = (10));

(statearr_74527_74557[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (13))){
var inst_74498 = (state_74522[(2)]);
var inst_74499 = fluree.db.util.async.throw_err(inst_74498);
var state_74522__$1 = state_74522;
var statearr_74528_74558 = state_74522__$1;
(statearr_74528_74558[(2)] = inst_74499);

(statearr_74528_74558[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (6))){
var state_74522__$1 = state_74522;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74522__$1,(9),seed);
} else {
if((state_val_74523 === (3))){
var inst_74520 = (state_74522[(2)]);
var state_74522__$1 = state_74522;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74522__$1,inst_74520);
} else {
if((state_val_74523 === (12))){
var inst_74502 = (state_74522[(7)]);
var inst_74502__$1 = (state_74522[(2)]);
var state_74522__$1 = (function (){var statearr_74529 = state_74522;
(statearr_74529[(7)] = inst_74502__$1);

return statearr_74529;
})();
if(cljs.core.truth_(inst_74502__$1)){
var statearr_74530_74559 = state_74522__$1;
(statearr_74530_74559[(1)] = (14));

} else {
var statearr_74531_74560 = state_74522__$1;
(statearr_74531_74560[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (2))){
var _ = (function (){var statearr_74532 = state_74522;
(statearr_74532[(4)] = cljs.core.cons((5),(state_74522[(4)])));

return statearr_74532;
})();
var inst_74487 = fluree.db.util.async.channel_QMARK_(seed);
var state_74522__$1 = state_74522;
if(inst_74487){
var statearr_74533_74561 = state_74522__$1;
(statearr_74533_74561[(1)] = (6));

} else {
var statearr_74534_74562 = state_74522__$1;
(statearr_74534_74562[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (11))){
var state_74522__$1 = state_74522;
var statearr_74536_74563 = state_74522__$1;
(statearr_74536_74563[(2)] = max);

(statearr_74536_74563[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (9))){
var inst_74490 = (state_74522[(2)]);
var inst_74491 = fluree.db.util.async.throw_err(inst_74490);
var state_74522__$1 = state_74522;
var statearr_74537_74564 = state_74522__$1;
(statearr_74537_74564[(2)] = inst_74491);

(statearr_74537_74564[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (5))){
var _ = (function (){var statearr_74538 = state_74522;
(statearr_74538[(4)] = cljs.core.rest((state_74522[(4)])));

return statearr_74538;
})();
var state_74522__$1 = state_74522;
var ex74535 = (state_74522__$1[(2)]);
var statearr_74539_74565 = state_74522__$1;
(statearr_74539_74565[(5)] = ex74535);


if((ex74535 instanceof Error)){
var statearr_74540_74566 = state_74522__$1;
(statearr_74540_74566[(1)] = (4));

(statearr_74540_74566[(5)] = null);

} else {
throw ex74535;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (14))){
var inst_74502 = (state_74522[(7)]);
var state_74522__$1 = state_74522;
var statearr_74541_74567 = state_74522__$1;
(statearr_74541_74567[(2)] = inst_74502);

(statearr_74541_74567[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (16))){
var inst_74494 = (state_74522[(8)]);
var inst_74506 = (state_74522[(2)]);
var inst_74507 = fluree.db.dbfunctions.internal.rand(inst_74494,inst_74506);
var inst_74508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74509 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74511 = [max,seed];
var inst_74512 = (new cljs.core.PersistentVector(null,2,(5),inst_74510,inst_74511,null));
var inst_74513 = ["rand",inst_74512,inst_74507];
var inst_74514 = cljs.core.PersistentHashMap.fromArrays(inst_74509,inst_74513);
var inst_74515 = [inst_74514,(10)];
var inst_74516 = (new cljs.core.PersistentVector(null,2,(5),inst_74508,inst_74515,null));
var inst_74517 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74516);
var _ = (function (){var statearr_74542 = state_74522;
(statearr_74542[(4)] = cljs.core.rest((state_74522[(4)])));

return statearr_74542;
})();
var state_74522__$1 = (function (){var statearr_74543 = state_74522;
(statearr_74543[(9)] = inst_74517);

return statearr_74543;
})();
var statearr_74544_74568 = state_74522__$1;
(statearr_74544_74568[(2)] = inst_74507);

(statearr_74544_74568[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74523 === (10))){
var state_74522__$1 = state_74522;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74522__$1,(13),max);
} else {
if((state_val_74523 === (8))){
var inst_74494 = (state_74522[(2)]);
var inst_74495 = fluree.db.util.async.channel_QMARK_(max);
var state_74522__$1 = (function (){var statearr_74545 = state_74522;
(statearr_74545[(8)] = inst_74494);

return statearr_74545;
})();
if(inst_74495){
var statearr_74546_74569 = state_74522__$1;
(statearr_74546_74569[(1)] = (10));

} else {
var statearr_74547_74570 = state_74522__$1;
(statearr_74547_74570[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__14778__auto____0 = (function (){
var statearr_74548 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74548[(0)] = fluree$db$dbfunctions$fns$state_machine__14778__auto__);

(statearr_74548[(1)] = (1));

return statearr_74548;
});
var fluree$db$dbfunctions$fns$state_machine__14778__auto____1 = (function (state_74522){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74522);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74549){var ex__14781__auto__ = e74549;
var statearr_74550_74571 = state_74522;
(statearr_74550_74571[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74522[(4)]))){
var statearr_74551_74572 = state_74522;
(statearr_74551_74572[(1)] = cljs.core.first((state_74522[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74573 = state_74522;
state_74522 = G__74573;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__14778__auto__ = function(state_74522){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__14778__auto____1.call(this,state_74522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74552 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74552[(6)] = c__14852__auto__);

return statearr_74552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74594){
var state_val_74595 = (state_74594[(1)]);
if((state_val_74595 === (1))){
var state_74594__$1 = state_74594;
var statearr_74596_74611 = state_74594__$1;
(statearr_74596_74611[(2)] = null);

(statearr_74596_74611[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74595 === (2))){
var _ = (function (){var statearr_74597 = state_74594;
(statearr_74597[(4)] = cljs.core.cons((5),(state_74594[(4)])));

return statearr_74597;
})();
var inst_74580 = fluree.db.util.core.random_uuid();
var inst_74581 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74580);
var inst_74582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74583 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74584 = cljs.core.PersistentVector.EMPTY;
var inst_74585 = ["uuid",inst_74584,inst_74581];
var inst_74586 = cljs.core.PersistentHashMap.fromArrays(inst_74583,inst_74585);
var inst_74587 = [inst_74586,(10)];
var inst_74588 = (new cljs.core.PersistentVector(null,2,(5),inst_74582,inst_74587,null));
var inst_74589 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74588);
var ___$1 = (function (){var statearr_74598 = state_74594;
(statearr_74598[(4)] = cljs.core.rest((state_74594[(4)])));

return statearr_74598;
})();
var state_74594__$1 = (function (){var statearr_74599 = state_74594;
(statearr_74599[(7)] = inst_74589);

return statearr_74599;
})();
var statearr_74600_74612 = state_74594__$1;
(statearr_74600_74612[(2)] = inst_74581);

(statearr_74600_74612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74595 === (3))){
var inst_74592 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74594__$1,inst_74592);
} else {
if((state_val_74595 === (4))){
var inst_74574 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
var statearr_74602_74613 = state_74594__$1;
(statearr_74602_74613[(2)] = inst_74574);

(statearr_74602_74613[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74595 === (5))){
var _ = (function (){var statearr_74603 = state_74594;
(statearr_74603[(4)] = cljs.core.rest((state_74594[(4)])));

return statearr_74603;
})();
var state_74594__$1 = state_74594;
var ex74601 = (state_74594__$1[(2)]);
var statearr_74604_74614 = state_74594__$1;
(statearr_74604_74614[(5)] = ex74601);


if((ex74601 instanceof Error)){
var statearr_74605_74615 = state_74594__$1;
(statearr_74605_74615[(1)] = (4));

(statearr_74605_74615[(5)] = null);

} else {
throw ex74601;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto____0 = (function (){
var statearr_74606 = [null,null,null,null,null,null,null,null];
(statearr_74606[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto__);

(statearr_74606[(1)] = (1));

return statearr_74606;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto____1 = (function (state_74594){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74594);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74607){var ex__14781__auto__ = e74607;
var statearr_74608_74616 = state_74594;
(statearr_74608_74616[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74594[(4)]))){
var statearr_74609_74617 = state_74594;
(statearr_74609_74617[(1)] = cljs.core.first((state_74594[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74618 = state_74594;
state_74594 = G__74618;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto__ = function(state_74594){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto____1.call(this,state_74594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74610 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74610[(6)] = c__14852__auto__);

return statearr_74610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74648){
var state_val_74649 = (state_74648[(1)]);
if((state_val_74649 === (7))){
var state_74648__$1 = state_74648;
var statearr_74650_74669 = state_74648__$1;
(statearr_74650_74669[(2)] = num);

(statearr_74650_74669[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74649 === (1))){
var state_74648__$1 = state_74648;
var statearr_74651_74670 = state_74648__$1;
(statearr_74651_74670[(2)] = null);

(statearr_74651_74670[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74649 === (4))){
var inst_74619 = (state_74648[(2)]);
var state_74648__$1 = state_74648;
var statearr_74652_74671 = state_74648__$1;
(statearr_74652_74671[(2)] = inst_74619);

(statearr_74652_74671[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74649 === (6))){
var state_74648__$1 = state_74648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74648__$1,(9),num);
} else {
if((state_val_74649 === (3))){
var inst_74646 = (state_74648[(2)]);
var state_74648__$1 = state_74648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74648__$1,inst_74646);
} else {
if((state_val_74649 === (2))){
var _ = (function (){var statearr_74654 = state_74648;
(statearr_74654[(4)] = cljs.core.cons((5),(state_74648[(4)])));

return statearr_74654;
})();
var inst_74625 = fluree.db.util.async.channel_QMARK_(num);
var state_74648__$1 = state_74648;
if(inst_74625){
var statearr_74655_74672 = state_74648__$1;
(statearr_74655_74672[(1)] = (6));

} else {
var statearr_74656_74673 = state_74648__$1;
(statearr_74656_74673[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74649 === (9))){
var inst_74628 = (state_74648[(2)]);
var inst_74629 = fluree.db.util.async.throw_err(inst_74628);
var state_74648__$1 = state_74648;
var statearr_74657_74674 = state_74648__$1;
(statearr_74657_74674[(2)] = inst_74629);

(statearr_74657_74674[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74649 === (5))){
var _ = (function (){var statearr_74658 = state_74648;
(statearr_74658[(4)] = cljs.core.rest((state_74648[(4)])));

return statearr_74658;
})();
var state_74648__$1 = state_74648;
var ex74653 = (state_74648__$1[(2)]);
var statearr_74659_74675 = state_74648__$1;
(statearr_74659_74675[(5)] = ex74653);


if((ex74653 instanceof Error)){
var statearr_74660_74676 = state_74648__$1;
(statearr_74660_74676[(1)] = (4));

(statearr_74660_74676[(5)] = null);

} else {
throw ex74653;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74649 === (8))){
var inst_74632 = (state_74648[(2)]);
var inst_74633 = fluree.db.dbfunctions.internal.ceil(inst_74632);
var inst_74634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74635 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74637 = [fluree.db.dbfunctions.fns.ceil];
var inst_74638 = (new cljs.core.PersistentVector(null,1,(5),inst_74636,inst_74637,null));
var inst_74639 = ["",inst_74638,inst_74633];
var inst_74640 = cljs.core.PersistentHashMap.fromArrays(inst_74635,inst_74639);
var inst_74641 = [inst_74640,(10)];
var inst_74642 = (new cljs.core.PersistentVector(null,2,(5),inst_74634,inst_74641,null));
var inst_74643 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74642);
var _ = (function (){var statearr_74661 = state_74648;
(statearr_74661[(4)] = cljs.core.rest((state_74648[(4)])));

return statearr_74661;
})();
var state_74648__$1 = (function (){var statearr_74662 = state_74648;
(statearr_74662[(7)] = inst_74643);

return statearr_74662;
})();
var statearr_74663_74677 = state_74648__$1;
(statearr_74663_74677[(2)] = inst_74633);

(statearr_74663_74677[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto____0 = (function (){
var statearr_74664 = [null,null,null,null,null,null,null,null];
(statearr_74664[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto__);

(statearr_74664[(1)] = (1));

return statearr_74664;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto____1 = (function (state_74648){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74648);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74665){var ex__14781__auto__ = e74665;
var statearr_74666_74678 = state_74648;
(statearr_74666_74678[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74648[(4)]))){
var statearr_74667_74679 = state_74648;
(statearr_74667_74679[(1)] = cljs.core.first((state_74648[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74680 = state_74648;
state_74648 = G__74680;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto__ = function(state_74648){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto____1.call(this,state_74648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74668 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74668[(6)] = c__14852__auto__);

return statearr_74668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74710){
var state_val_74711 = (state_74710[(1)]);
if((state_val_74711 === (7))){
var state_74710__$1 = state_74710;
var statearr_74712_74731 = state_74710__$1;
(statearr_74712_74731[(2)] = num);

(statearr_74712_74731[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74711 === (1))){
var state_74710__$1 = state_74710;
var statearr_74713_74732 = state_74710__$1;
(statearr_74713_74732[(2)] = null);

(statearr_74713_74732[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74711 === (4))){
var inst_74681 = (state_74710[(2)]);
var state_74710__$1 = state_74710;
var statearr_74714_74733 = state_74710__$1;
(statearr_74714_74733[(2)] = inst_74681);

(statearr_74714_74733[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74711 === (6))){
var state_74710__$1 = state_74710;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74710__$1,(9),num);
} else {
if((state_val_74711 === (3))){
var inst_74708 = (state_74710[(2)]);
var state_74710__$1 = state_74710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74710__$1,inst_74708);
} else {
if((state_val_74711 === (2))){
var _ = (function (){var statearr_74716 = state_74710;
(statearr_74716[(4)] = cljs.core.cons((5),(state_74710[(4)])));

return statearr_74716;
})();
var inst_74687 = fluree.db.util.async.channel_QMARK_(num);
var state_74710__$1 = state_74710;
if(inst_74687){
var statearr_74717_74734 = state_74710__$1;
(statearr_74717_74734[(1)] = (6));

} else {
var statearr_74718_74735 = state_74710__$1;
(statearr_74718_74735[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74711 === (9))){
var inst_74690 = (state_74710[(2)]);
var inst_74691 = fluree.db.util.async.throw_err(inst_74690);
var state_74710__$1 = state_74710;
var statearr_74719_74736 = state_74710__$1;
(statearr_74719_74736[(2)] = inst_74691);

(statearr_74719_74736[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74711 === (5))){
var _ = (function (){var statearr_74720 = state_74710;
(statearr_74720[(4)] = cljs.core.rest((state_74710[(4)])));

return statearr_74720;
})();
var state_74710__$1 = state_74710;
var ex74715 = (state_74710__$1[(2)]);
var statearr_74721_74737 = state_74710__$1;
(statearr_74721_74737[(5)] = ex74715);


if((ex74715 instanceof Error)){
var statearr_74722_74738 = state_74710__$1;
(statearr_74722_74738[(1)] = (4));

(statearr_74722_74738[(5)] = null);

} else {
throw ex74715;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74711 === (8))){
var inst_74694 = (state_74710[(2)]);
var inst_74695 = fluree.db.dbfunctions.internal.floor(inst_74694);
var inst_74696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74697 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74699 = [fluree.db.dbfunctions.fns.floor];
var inst_74700 = (new cljs.core.PersistentVector(null,1,(5),inst_74698,inst_74699,null));
var inst_74701 = ["",inst_74700,inst_74695];
var inst_74702 = cljs.core.PersistentHashMap.fromArrays(inst_74697,inst_74701);
var inst_74703 = [inst_74702,(10)];
var inst_74704 = (new cljs.core.PersistentVector(null,2,(5),inst_74696,inst_74703,null));
var inst_74705 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74704);
var _ = (function (){var statearr_74723 = state_74710;
(statearr_74723[(4)] = cljs.core.rest((state_74710[(4)])));

return statearr_74723;
})();
var state_74710__$1 = (function (){var statearr_74724 = state_74710;
(statearr_74724[(7)] = inst_74705);

return statearr_74724;
})();
var statearr_74725_74739 = state_74710__$1;
(statearr_74725_74739[(2)] = inst_74695);

(statearr_74725_74739[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto____0 = (function (){
var statearr_74726 = [null,null,null,null,null,null,null,null];
(statearr_74726[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto__);

(statearr_74726[(1)] = (1));

return statearr_74726;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto____1 = (function (state_74710){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74710);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74727){var ex__14781__auto__ = e74727;
var statearr_74728_74740 = state_74710;
(statearr_74728_74740[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74710[(4)]))){
var statearr_74729_74741 = state_74710;
(statearr_74729_74741[(1)] = cljs.core.first((state_74710[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74742 = state_74710;
state_74710 = G__74742;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto__ = function(state_74710){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto____1.call(this,state_74710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74730 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74730[(6)] = c__14852__auto__);

return statearr_74730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74767){
var state_val_74768 = (state_74767[(1)]);
if((state_val_74768 === (1))){
var state_74767__$1 = state_74767;
var statearr_74769_74784 = state_74767__$1;
(statearr_74769_74784[(2)] = null);

(statearr_74769_74784[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74768 === (2))){
var _ = (function (){var statearr_74770 = state_74767;
(statearr_74770[(4)] = cljs.core.cons((5),(state_74767[(4)])));

return statearr_74770;
})();
var inst_74749 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_74767__$1 = state_74767;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74767__$1,(6),inst_74749);
} else {
if((state_val_74768 === (3))){
var inst_74765 = (state_74767[(2)]);
var state_74767__$1 = state_74767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74767__$1,inst_74765);
} else {
if((state_val_74768 === (4))){
var inst_74743 = (state_74767[(2)]);
var state_74767__$1 = state_74767;
var statearr_74772_74785 = state_74767__$1;
(statearr_74772_74785[(2)] = inst_74743);

(statearr_74772_74785[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74768 === (5))){
var _ = (function (){var statearr_74773 = state_74767;
(statearr_74773[(4)] = cljs.core.rest((state_74767[(4)])));

return statearr_74773;
})();
var state_74767__$1 = state_74767;
var ex74771 = (state_74767__$1[(2)]);
var statearr_74774_74786 = state_74767__$1;
(statearr_74774_74786[(5)] = ex74771);


if((ex74771 instanceof Error)){
var statearr_74775_74787 = state_74767__$1;
(statearr_74775_74787[(1)] = (4));

(statearr_74775_74787[(5)] = null);

} else {
throw ex74771;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74768 === (6))){
var inst_74751 = (state_74767[(2)]);
var inst_74752 = fluree.db.util.async.throw_err(inst_74751);
var inst_74753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74754 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74756 = [compare_val,new_val];
var inst_74757 = (new cljs.core.PersistentVector(null,2,(5),inst_74755,inst_74756,null));
var inst_74758 = ["",inst_74757,inst_74752];
var inst_74759 = cljs.core.PersistentHashMap.fromArrays(inst_74754,inst_74758);
var inst_74760 = [inst_74759,(10)];
var inst_74761 = (new cljs.core.PersistentVector(null,2,(5),inst_74753,inst_74760,null));
var inst_74762 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74761);
var _ = (function (){var statearr_74776 = state_74767;
(statearr_74776[(4)] = cljs.core.rest((state_74767[(4)])));

return statearr_74776;
})();
var state_74767__$1 = (function (){var statearr_74777 = state_74767;
(statearr_74777[(7)] = inst_74762);

return statearr_74777;
})();
var statearr_74778_74788 = state_74767__$1;
(statearr_74778_74788[(2)] = inst_74752);

(statearr_74778_74788[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto____0 = (function (){
var statearr_74779 = [null,null,null,null,null,null,null,null];
(statearr_74779[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto__);

(statearr_74779[(1)] = (1));

return statearr_74779;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto____1 = (function (state_74767){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74767);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74780){var ex__14781__auto__ = e74780;
var statearr_74781_74789 = state_74767;
(statearr_74781_74789[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74767[(4)]))){
var statearr_74782_74790 = state_74767;
(statearr_74782_74790[(1)] = cljs.core.first((state_74767[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74791 = state_74767;
state_74767 = G__74791;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto__ = function(state_74767){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto____1.call(this,state_74767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74783 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74783[(6)] = c__14852__auto__);

return statearr_74783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
