// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__8847){
var vec__8848 = p__8847;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8848,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8848,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__8851 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8851,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8851,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8851,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8851,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8851,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5753__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__8854 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8854,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8854,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8854,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8854,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8854,(4),null);
var vec__8857 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8857,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8857,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8857,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8857,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8857,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4223__auto__ = source;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4223__auto__ = line;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4223__auto__ = col;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__8860 = segmap;
var map__8860__$1 = cljs.core.__destructure_map(map__8860);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8860__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8860__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8860__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8860__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8860__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__8862 = arguments.length;
switch (G__8862) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__8866 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__8870 = cljs.core.next(segs__$1);
var G__8871 = nrelseg;
var G__8872 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__8870;
relseg__$1 = G__8871;
result__$1 = G__8872;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8866,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8866,(1),null);
var G__8873 = (gline + (1));
var G__8874 = cljs.core.next(lines__$1);
var G__8875 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__8876 = result__$1;
gline = G__8873;
lines__$1 = G__8874;
relseg = G__8875;
result = G__8876;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__8878 = segmap;
var map__8878__$1 = cljs.core.__destructure_map(map__8878);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8878__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8878__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8878__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8878__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8878__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__8877_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__8877_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__8880 = arguments.length;
switch (G__8880) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__8884 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__8888 = cljs.core.next(segs__$1);
var G__8889 = nrelseg;
var G__8890 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__8888;
relseg__$1 = G__8889;
result__$1 = G__8890;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8884,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8884,(1),null);
var G__8891 = (gline + (1));
var G__8892 = cljs.core.next(lines__$1);
var G__8893 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__8894 = result__$1;
gline = G__8891;
lines__$1 = G__8892;
relseg = G__8893;
result = G__8894;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__8895){
var vec__8896 = p__8895;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8896,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8896,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8896,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8896,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8896,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__8899){
var vec__8900 = p__8899;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8900,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8900,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8900,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8900,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8900,(4),null);
var seg = vec__8900;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__8903){
var vec__8904 = p__8903;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8904,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8904,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8904,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8904,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8904,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__8910 = cljs.core.seq(infos);
var chunk__8911 = null;
var count__8912 = (0);
var i__8913 = (0);
while(true){
if((i__8913 < count__8912)){
var info = chunk__8911.cljs$core$IIndexed$_nth$arity$2(null,i__8913);
var segv_9264 = info__GT_segv(info,source_idx,line,col);
var gline_9265 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_9266 = cljs.core.count(cljs.core.deref(lines));
if((gline_9265 > (lc_9266 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8910,chunk__8911,count__8912,i__8913,segv_9264,gline_9265,lc_9266,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_9265 - (lc_9266 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_9264], null));
});})(seq__8910,chunk__8911,count__8912,i__8913,segv_9264,gline_9265,lc_9266,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8910,chunk__8911,count__8912,i__8913,segv_9264,gline_9265,lc_9266,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9265], null),cljs.core.conj,segv_9264);
});})(seq__8910,chunk__8911,count__8912,i__8913,segv_9264,gline_9265,lc_9266,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__9267 = seq__8910;
var G__9268 = chunk__8911;
var G__9269 = count__8912;
var G__9270 = (i__8913 + (1));
seq__8910 = G__9267;
chunk__8911 = G__9268;
count__8912 = G__9269;
i__8913 = G__9270;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__8910);
if(temp__5753__auto__){
var seq__8910__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__8910__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__8910__$1);
var G__9271 = cljs.core.chunk_rest(seq__8910__$1);
var G__9272 = c__4649__auto__;
var G__9273 = cljs.core.count(c__4649__auto__);
var G__9274 = (0);
seq__8910 = G__9271;
chunk__8911 = G__9272;
count__8912 = G__9273;
i__8913 = G__9274;
continue;
} else {
var info = cljs.core.first(seq__8910__$1);
var segv_9275 = info__GT_segv(info,source_idx,line,col);
var gline_9276 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_9277 = cljs.core.count(cljs.core.deref(lines));
if((gline_9276 > (lc_9277 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8910,chunk__8911,count__8912,i__8913,segv_9275,gline_9276,lc_9277,info,seq__8910__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_9276 - (lc_9277 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_9275], null));
});})(seq__8910,chunk__8911,count__8912,i__8913,segv_9275,gline_9276,lc_9277,info,seq__8910__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8910,chunk__8911,count__8912,i__8913,segv_9275,gline_9276,lc_9277,info,seq__8910__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9276], null),cljs.core.conj,segv_9275);
});})(seq__8910,chunk__8911,count__8912,i__8913,segv_9275,gline_9276,lc_9277,info,seq__8910__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__9278 = cljs.core.next(seq__8910__$1);
var G__9279 = null;
var G__9280 = (0);
var G__9281 = (0);
seq__8910 = G__9278;
chunk__8911 = G__9279;
count__8912 = G__9280;
i__8913 = G__9281;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__8914_9282 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__8915_9283 = null;
var count__8916_9284 = (0);
var i__8917_9285 = (0);
while(true){
if((i__8917_9285 < count__8916_9284)){
var vec__9090_9286 = chunk__8915_9283.cljs$core$IIndexed$_nth$arity$2(null,i__8917_9285);
var source_idx_9287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9090_9286,(0),null);
var vec__9093_9288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9090_9286,(1),null);
var __9289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9093_9288,(0),null);
var lines_9290__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9093_9288,(1),null);
var seq__9096_9291 = cljs.core.seq(lines_9290__$1);
var chunk__9097_9292 = null;
var count__9098_9293 = (0);
var i__9099_9294 = (0);
while(true){
if((i__9099_9294 < count__9098_9293)){
var vec__9138_9295 = chunk__9097_9292.cljs$core$IIndexed$_nth$arity$2(null,i__9099_9294);
var line_9296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9138_9295,(0),null);
var cols_9297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9138_9295,(1),null);
var seq__9141_9298 = cljs.core.seq(cols_9297);
var chunk__9142_9299 = null;
var count__9143_9300 = (0);
var i__9144_9301 = (0);
while(true){
if((i__9144_9301 < count__9143_9300)){
var vec__9151_9302 = chunk__9142_9299.cljs$core$IIndexed$_nth$arity$2(null,i__9144_9301);
var col_9303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9151_9302,(0),null);
var infos_9304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9151_9302,(1),null);
encode_cols(infos_9304,source_idx_9287,line_9296,col_9303);


var G__9305 = seq__9141_9298;
var G__9306 = chunk__9142_9299;
var G__9307 = count__9143_9300;
var G__9308 = (i__9144_9301 + (1));
seq__9141_9298 = G__9305;
chunk__9142_9299 = G__9306;
count__9143_9300 = G__9307;
i__9144_9301 = G__9308;
continue;
} else {
var temp__5753__auto___9309 = cljs.core.seq(seq__9141_9298);
if(temp__5753__auto___9309){
var seq__9141_9310__$1 = temp__5753__auto___9309;
if(cljs.core.chunked_seq_QMARK_(seq__9141_9310__$1)){
var c__4649__auto___9311 = cljs.core.chunk_first(seq__9141_9310__$1);
var G__9312 = cljs.core.chunk_rest(seq__9141_9310__$1);
var G__9313 = c__4649__auto___9311;
var G__9314 = cljs.core.count(c__4649__auto___9311);
var G__9315 = (0);
seq__9141_9298 = G__9312;
chunk__9142_9299 = G__9313;
count__9143_9300 = G__9314;
i__9144_9301 = G__9315;
continue;
} else {
var vec__9154_9316 = cljs.core.first(seq__9141_9310__$1);
var col_9317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9154_9316,(0),null);
var infos_9318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9154_9316,(1),null);
encode_cols(infos_9318,source_idx_9287,line_9296,col_9317);


var G__9319 = cljs.core.next(seq__9141_9310__$1);
var G__9320 = null;
var G__9321 = (0);
var G__9322 = (0);
seq__9141_9298 = G__9319;
chunk__9142_9299 = G__9320;
count__9143_9300 = G__9321;
i__9144_9301 = G__9322;
continue;
}
} else {
}
}
break;
}


var G__9323 = seq__9096_9291;
var G__9324 = chunk__9097_9292;
var G__9325 = count__9098_9293;
var G__9326 = (i__9099_9294 + (1));
seq__9096_9291 = G__9323;
chunk__9097_9292 = G__9324;
count__9098_9293 = G__9325;
i__9099_9294 = G__9326;
continue;
} else {
var temp__5753__auto___9327 = cljs.core.seq(seq__9096_9291);
if(temp__5753__auto___9327){
var seq__9096_9328__$1 = temp__5753__auto___9327;
if(cljs.core.chunked_seq_QMARK_(seq__9096_9328__$1)){
var c__4649__auto___9329 = cljs.core.chunk_first(seq__9096_9328__$1);
var G__9330 = cljs.core.chunk_rest(seq__9096_9328__$1);
var G__9331 = c__4649__auto___9329;
var G__9332 = cljs.core.count(c__4649__auto___9329);
var G__9333 = (0);
seq__9096_9291 = G__9330;
chunk__9097_9292 = G__9331;
count__9098_9293 = G__9332;
i__9099_9294 = G__9333;
continue;
} else {
var vec__9157_9334 = cljs.core.first(seq__9096_9328__$1);
var line_9335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9157_9334,(0),null);
var cols_9336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9157_9334,(1),null);
var seq__9160_9337 = cljs.core.seq(cols_9336);
var chunk__9161_9338 = null;
var count__9162_9339 = (0);
var i__9163_9340 = (0);
while(true){
if((i__9163_9340 < count__9162_9339)){
var vec__9170_9341 = chunk__9161_9338.cljs$core$IIndexed$_nth$arity$2(null,i__9163_9340);
var col_9342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9170_9341,(0),null);
var infos_9343 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9170_9341,(1),null);
encode_cols(infos_9343,source_idx_9287,line_9335,col_9342);


var G__9344 = seq__9160_9337;
var G__9345 = chunk__9161_9338;
var G__9346 = count__9162_9339;
var G__9347 = (i__9163_9340 + (1));
seq__9160_9337 = G__9344;
chunk__9161_9338 = G__9345;
count__9162_9339 = G__9346;
i__9163_9340 = G__9347;
continue;
} else {
var temp__5753__auto___9348__$1 = cljs.core.seq(seq__9160_9337);
if(temp__5753__auto___9348__$1){
var seq__9160_9349__$1 = temp__5753__auto___9348__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9160_9349__$1)){
var c__4649__auto___9350 = cljs.core.chunk_first(seq__9160_9349__$1);
var G__9351 = cljs.core.chunk_rest(seq__9160_9349__$1);
var G__9352 = c__4649__auto___9350;
var G__9353 = cljs.core.count(c__4649__auto___9350);
var G__9354 = (0);
seq__9160_9337 = G__9351;
chunk__9161_9338 = G__9352;
count__9162_9339 = G__9353;
i__9163_9340 = G__9354;
continue;
} else {
var vec__9173_9355 = cljs.core.first(seq__9160_9349__$1);
var col_9356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9173_9355,(0),null);
var infos_9357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9173_9355,(1),null);
encode_cols(infos_9357,source_idx_9287,line_9335,col_9356);


var G__9358 = cljs.core.next(seq__9160_9349__$1);
var G__9359 = null;
var G__9360 = (0);
var G__9361 = (0);
seq__9160_9337 = G__9358;
chunk__9161_9338 = G__9359;
count__9162_9339 = G__9360;
i__9163_9340 = G__9361;
continue;
}
} else {
}
}
break;
}


var G__9362 = cljs.core.next(seq__9096_9328__$1);
var G__9363 = null;
var G__9364 = (0);
var G__9365 = (0);
seq__9096_9291 = G__9362;
chunk__9097_9292 = G__9363;
count__9098_9293 = G__9364;
i__9099_9294 = G__9365;
continue;
}
} else {
}
}
break;
}


var G__9366 = seq__8914_9282;
var G__9367 = chunk__8915_9283;
var G__9368 = count__8916_9284;
var G__9369 = (i__8917_9285 + (1));
seq__8914_9282 = G__9366;
chunk__8915_9283 = G__9367;
count__8916_9284 = G__9368;
i__8917_9285 = G__9369;
continue;
} else {
var temp__5753__auto___9370 = cljs.core.seq(seq__8914_9282);
if(temp__5753__auto___9370){
var seq__8914_9371__$1 = temp__5753__auto___9370;
if(cljs.core.chunked_seq_QMARK_(seq__8914_9371__$1)){
var c__4649__auto___9372 = cljs.core.chunk_first(seq__8914_9371__$1);
var G__9373 = cljs.core.chunk_rest(seq__8914_9371__$1);
var G__9374 = c__4649__auto___9372;
var G__9375 = cljs.core.count(c__4649__auto___9372);
var G__9376 = (0);
seq__8914_9282 = G__9373;
chunk__8915_9283 = G__9374;
count__8916_9284 = G__9375;
i__8917_9285 = G__9376;
continue;
} else {
var vec__9176_9377 = cljs.core.first(seq__8914_9371__$1);
var source_idx_9378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9176_9377,(0),null);
var vec__9179_9379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9176_9377,(1),null);
var __9380 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9179_9379,(0),null);
var lines_9381__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9179_9379,(1),null);
var seq__9182_9382 = cljs.core.seq(lines_9381__$1);
var chunk__9183_9383 = null;
var count__9184_9384 = (0);
var i__9185_9385 = (0);
while(true){
if((i__9185_9385 < count__9184_9384)){
var vec__9224_9386 = chunk__9183_9383.cljs$core$IIndexed$_nth$arity$2(null,i__9185_9385);
var line_9387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9224_9386,(0),null);
var cols_9388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9224_9386,(1),null);
var seq__9227_9389 = cljs.core.seq(cols_9388);
var chunk__9228_9390 = null;
var count__9229_9391 = (0);
var i__9230_9392 = (0);
while(true){
if((i__9230_9392 < count__9229_9391)){
var vec__9237_9393 = chunk__9228_9390.cljs$core$IIndexed$_nth$arity$2(null,i__9230_9392);
var col_9394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9237_9393,(0),null);
var infos_9395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9237_9393,(1),null);
encode_cols(infos_9395,source_idx_9378,line_9387,col_9394);


var G__9396 = seq__9227_9389;
var G__9397 = chunk__9228_9390;
var G__9398 = count__9229_9391;
var G__9399 = (i__9230_9392 + (1));
seq__9227_9389 = G__9396;
chunk__9228_9390 = G__9397;
count__9229_9391 = G__9398;
i__9230_9392 = G__9399;
continue;
} else {
var temp__5753__auto___9400__$1 = cljs.core.seq(seq__9227_9389);
if(temp__5753__auto___9400__$1){
var seq__9227_9401__$1 = temp__5753__auto___9400__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9227_9401__$1)){
var c__4649__auto___9402 = cljs.core.chunk_first(seq__9227_9401__$1);
var G__9403 = cljs.core.chunk_rest(seq__9227_9401__$1);
var G__9404 = c__4649__auto___9402;
var G__9405 = cljs.core.count(c__4649__auto___9402);
var G__9406 = (0);
seq__9227_9389 = G__9403;
chunk__9228_9390 = G__9404;
count__9229_9391 = G__9405;
i__9230_9392 = G__9406;
continue;
} else {
var vec__9240_9407 = cljs.core.first(seq__9227_9401__$1);
var col_9408 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9240_9407,(0),null);
var infos_9409 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9240_9407,(1),null);
encode_cols(infos_9409,source_idx_9378,line_9387,col_9408);


var G__9410 = cljs.core.next(seq__9227_9401__$1);
var G__9411 = null;
var G__9412 = (0);
var G__9413 = (0);
seq__9227_9389 = G__9410;
chunk__9228_9390 = G__9411;
count__9229_9391 = G__9412;
i__9230_9392 = G__9413;
continue;
}
} else {
}
}
break;
}


var G__9414 = seq__9182_9382;
var G__9415 = chunk__9183_9383;
var G__9416 = count__9184_9384;
var G__9417 = (i__9185_9385 + (1));
seq__9182_9382 = G__9414;
chunk__9183_9383 = G__9415;
count__9184_9384 = G__9416;
i__9185_9385 = G__9417;
continue;
} else {
var temp__5753__auto___9418__$1 = cljs.core.seq(seq__9182_9382);
if(temp__5753__auto___9418__$1){
var seq__9182_9419__$1 = temp__5753__auto___9418__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9182_9419__$1)){
var c__4649__auto___9420 = cljs.core.chunk_first(seq__9182_9419__$1);
var G__9421 = cljs.core.chunk_rest(seq__9182_9419__$1);
var G__9422 = c__4649__auto___9420;
var G__9423 = cljs.core.count(c__4649__auto___9420);
var G__9424 = (0);
seq__9182_9382 = G__9421;
chunk__9183_9383 = G__9422;
count__9184_9384 = G__9423;
i__9185_9385 = G__9424;
continue;
} else {
var vec__9243_9425 = cljs.core.first(seq__9182_9419__$1);
var line_9426 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9243_9425,(0),null);
var cols_9427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9243_9425,(1),null);
var seq__9246_9428 = cljs.core.seq(cols_9427);
var chunk__9247_9429 = null;
var count__9248_9430 = (0);
var i__9249_9431 = (0);
while(true){
if((i__9249_9431 < count__9248_9430)){
var vec__9256_9432 = chunk__9247_9429.cljs$core$IIndexed$_nth$arity$2(null,i__9249_9431);
var col_9433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9256_9432,(0),null);
var infos_9434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9256_9432,(1),null);
encode_cols(infos_9434,source_idx_9378,line_9426,col_9433);


var G__9435 = seq__9246_9428;
var G__9436 = chunk__9247_9429;
var G__9437 = count__9248_9430;
var G__9438 = (i__9249_9431 + (1));
seq__9246_9428 = G__9435;
chunk__9247_9429 = G__9436;
count__9248_9430 = G__9437;
i__9249_9431 = G__9438;
continue;
} else {
var temp__5753__auto___9439__$2 = cljs.core.seq(seq__9246_9428);
if(temp__5753__auto___9439__$2){
var seq__9246_9440__$1 = temp__5753__auto___9439__$2;
if(cljs.core.chunked_seq_QMARK_(seq__9246_9440__$1)){
var c__4649__auto___9441 = cljs.core.chunk_first(seq__9246_9440__$1);
var G__9442 = cljs.core.chunk_rest(seq__9246_9440__$1);
var G__9443 = c__4649__auto___9441;
var G__9444 = cljs.core.count(c__4649__auto___9441);
var G__9445 = (0);
seq__9246_9428 = G__9442;
chunk__9247_9429 = G__9443;
count__9248_9430 = G__9444;
i__9249_9431 = G__9445;
continue;
} else {
var vec__9259_9446 = cljs.core.first(seq__9246_9440__$1);
var col_9447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9259_9446,(0),null);
var infos_9448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9259_9446,(1),null);
encode_cols(infos_9448,source_idx_9378,line_9426,col_9447);


var G__9449 = cljs.core.next(seq__9246_9440__$1);
var G__9450 = null;
var G__9451 = (0);
var G__9452 = (0);
seq__9246_9428 = G__9449;
chunk__9247_9429 = G__9450;
count__9248_9430 = G__9451;
i__9249_9431 = G__9452;
continue;
}
} else {
}
}
break;
}


var G__9453 = cljs.core.next(seq__9182_9419__$1);
var G__9454 = null;
var G__9455 = (0);
var G__9456 = (0);
seq__9182_9382 = G__9453;
chunk__9183_9383 = G__9454;
count__9184_9384 = G__9455;
i__9185_9385 = G__9456;
continue;
}
} else {
}
}
break;
}


var G__9457 = cljs.core.next(seq__8914_9371__$1);
var G__9458 = null;
var G__9459 = (0);
var G__9460 = (0);
seq__8914_9282 = G__9457;
chunk__8915_9283 = G__9458;
count__8916_9284 = G__9459;
i__8917_9285 = G__9460;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__9262 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__8907_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__8907_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__8908_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__8908_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__8909_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__8909_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__9263 = G__9262;
goog.object.set(G__9263,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__9263;
} else {
return G__9262;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__9461 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9461,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9461,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__9464 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9464,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9464,(1),null);
var G__9469 = cljs.core.next(col_map_seq);
var G__9470 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__9464,col,infos,vec__9461,line,col_map){
return (function (v,p__9467){
var map__9468 = p__9467;
var map__9468__$1 = cljs.core.__destructure_map(map__9468);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9468__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9468__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__9464,col,infos,vec__9461,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__9469;
new_cols = G__9470;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__9471 = cljs.core.next(line_map_seq);
var G__9472 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__9471;
new_lines = G__9472;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__9473_9681 = cljs.core.seq(reverse_map);
var chunk__9474_9682 = null;
var count__9475_9683 = (0);
var i__9476_9684 = (0);
while(true){
if((i__9476_9684 < count__9475_9683)){
var vec__9579_9685 = chunk__9474_9682.cljs$core$IIndexed$_nth$arity$2(null,i__9476_9684);
var line_9686 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9579_9685,(0),null);
var columns_9687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9579_9685,(1),null);
var seq__9582_9688 = cljs.core.seq(columns_9687);
var chunk__9583_9689 = null;
var count__9584_9690 = (0);
var i__9585_9691 = (0);
while(true){
if((i__9585_9691 < count__9584_9690)){
var vec__9608_9692 = chunk__9583_9689.cljs$core$IIndexed$_nth$arity$2(null,i__9585_9691);
var column_9693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9608_9692,(0),null);
var column_info_9694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9608_9692,(1),null);
var seq__9611_9695 = cljs.core.seq(column_info_9694);
var chunk__9612_9696 = null;
var count__9613_9697 = (0);
var i__9614_9698 = (0);
while(true){
if((i__9614_9698 < count__9613_9697)){
var map__9617_9699 = chunk__9612_9696.cljs$core$IIndexed$_nth$arity$2(null,i__9614_9698);
var map__9617_9700__$1 = cljs.core.__destructure_map(map__9617_9699);
var gline_9701 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9617_9700__$1,cljs.core.cst$kw$gline);
var gcol_9702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9617_9700__$1,cljs.core.cst$kw$gcol);
var name_9703 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9617_9700__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9701], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9611_9695,chunk__9612_9696,count__9613_9697,i__9614_9698,seq__9582_9688,chunk__9583_9689,count__9584_9690,i__9585_9691,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9617_9699,map__9617_9700__$1,gline_9701,gcol_9702,name_9703,vec__9608_9692,column_9693,column_info_9694,vec__9579_9685,line_9686,columns_9687,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9702], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9686,cljs.core.cst$kw$col,column_9693,cljs.core.cst$kw$name,name_9703], null));
});})(seq__9611_9695,chunk__9612_9696,count__9613_9697,i__9614_9698,seq__9582_9688,chunk__9583_9689,count__9584_9690,i__9585_9691,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9617_9699,map__9617_9700__$1,gline_9701,gcol_9702,name_9703,vec__9608_9692,column_9693,column_info_9694,vec__9579_9685,line_9686,columns_9687,inverted))
,cljs.core.sorted_map()));


var G__9704 = seq__9611_9695;
var G__9705 = chunk__9612_9696;
var G__9706 = count__9613_9697;
var G__9707 = (i__9614_9698 + (1));
seq__9611_9695 = G__9704;
chunk__9612_9696 = G__9705;
count__9613_9697 = G__9706;
i__9614_9698 = G__9707;
continue;
} else {
var temp__5753__auto___9708 = cljs.core.seq(seq__9611_9695);
if(temp__5753__auto___9708){
var seq__9611_9709__$1 = temp__5753__auto___9708;
if(cljs.core.chunked_seq_QMARK_(seq__9611_9709__$1)){
var c__4649__auto___9710 = cljs.core.chunk_first(seq__9611_9709__$1);
var G__9711 = cljs.core.chunk_rest(seq__9611_9709__$1);
var G__9712 = c__4649__auto___9710;
var G__9713 = cljs.core.count(c__4649__auto___9710);
var G__9714 = (0);
seq__9611_9695 = G__9711;
chunk__9612_9696 = G__9712;
count__9613_9697 = G__9713;
i__9614_9698 = G__9714;
continue;
} else {
var map__9618_9715 = cljs.core.first(seq__9611_9709__$1);
var map__9618_9716__$1 = cljs.core.__destructure_map(map__9618_9715);
var gline_9717 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9618_9716__$1,cljs.core.cst$kw$gline);
var gcol_9718 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9618_9716__$1,cljs.core.cst$kw$gcol);
var name_9719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9618_9716__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9717], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9611_9695,chunk__9612_9696,count__9613_9697,i__9614_9698,seq__9582_9688,chunk__9583_9689,count__9584_9690,i__9585_9691,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9618_9715,map__9618_9716__$1,gline_9717,gcol_9718,name_9719,seq__9611_9709__$1,temp__5753__auto___9708,vec__9608_9692,column_9693,column_info_9694,vec__9579_9685,line_9686,columns_9687,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9718], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9686,cljs.core.cst$kw$col,column_9693,cljs.core.cst$kw$name,name_9719], null));
});})(seq__9611_9695,chunk__9612_9696,count__9613_9697,i__9614_9698,seq__9582_9688,chunk__9583_9689,count__9584_9690,i__9585_9691,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9618_9715,map__9618_9716__$1,gline_9717,gcol_9718,name_9719,seq__9611_9709__$1,temp__5753__auto___9708,vec__9608_9692,column_9693,column_info_9694,vec__9579_9685,line_9686,columns_9687,inverted))
,cljs.core.sorted_map()));


var G__9720 = cljs.core.next(seq__9611_9709__$1);
var G__9721 = null;
var G__9722 = (0);
var G__9723 = (0);
seq__9611_9695 = G__9720;
chunk__9612_9696 = G__9721;
count__9613_9697 = G__9722;
i__9614_9698 = G__9723;
continue;
}
} else {
}
}
break;
}


var G__9724 = seq__9582_9688;
var G__9725 = chunk__9583_9689;
var G__9726 = count__9584_9690;
var G__9727 = (i__9585_9691 + (1));
seq__9582_9688 = G__9724;
chunk__9583_9689 = G__9725;
count__9584_9690 = G__9726;
i__9585_9691 = G__9727;
continue;
} else {
var temp__5753__auto___9728 = cljs.core.seq(seq__9582_9688);
if(temp__5753__auto___9728){
var seq__9582_9729__$1 = temp__5753__auto___9728;
if(cljs.core.chunked_seq_QMARK_(seq__9582_9729__$1)){
var c__4649__auto___9730 = cljs.core.chunk_first(seq__9582_9729__$1);
var G__9731 = cljs.core.chunk_rest(seq__9582_9729__$1);
var G__9732 = c__4649__auto___9730;
var G__9733 = cljs.core.count(c__4649__auto___9730);
var G__9734 = (0);
seq__9582_9688 = G__9731;
chunk__9583_9689 = G__9732;
count__9584_9690 = G__9733;
i__9585_9691 = G__9734;
continue;
} else {
var vec__9619_9735 = cljs.core.first(seq__9582_9729__$1);
var column_9736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9619_9735,(0),null);
var column_info_9737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9619_9735,(1),null);
var seq__9622_9738 = cljs.core.seq(column_info_9737);
var chunk__9623_9739 = null;
var count__9624_9740 = (0);
var i__9625_9741 = (0);
while(true){
if((i__9625_9741 < count__9624_9740)){
var map__9628_9742 = chunk__9623_9739.cljs$core$IIndexed$_nth$arity$2(null,i__9625_9741);
var map__9628_9743__$1 = cljs.core.__destructure_map(map__9628_9742);
var gline_9744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9628_9743__$1,cljs.core.cst$kw$gline);
var gcol_9745 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9628_9743__$1,cljs.core.cst$kw$gcol);
var name_9746 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9628_9743__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9744], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9622_9738,chunk__9623_9739,count__9624_9740,i__9625_9741,seq__9582_9688,chunk__9583_9689,count__9584_9690,i__9585_9691,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9628_9742,map__9628_9743__$1,gline_9744,gcol_9745,name_9746,vec__9619_9735,column_9736,column_info_9737,seq__9582_9729__$1,temp__5753__auto___9728,vec__9579_9685,line_9686,columns_9687,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9745], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9686,cljs.core.cst$kw$col,column_9736,cljs.core.cst$kw$name,name_9746], null));
});})(seq__9622_9738,chunk__9623_9739,count__9624_9740,i__9625_9741,seq__9582_9688,chunk__9583_9689,count__9584_9690,i__9585_9691,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9628_9742,map__9628_9743__$1,gline_9744,gcol_9745,name_9746,vec__9619_9735,column_9736,column_info_9737,seq__9582_9729__$1,temp__5753__auto___9728,vec__9579_9685,line_9686,columns_9687,inverted))
,cljs.core.sorted_map()));


var G__9747 = seq__9622_9738;
var G__9748 = chunk__9623_9739;
var G__9749 = count__9624_9740;
var G__9750 = (i__9625_9741 + (1));
seq__9622_9738 = G__9747;
chunk__9623_9739 = G__9748;
count__9624_9740 = G__9749;
i__9625_9741 = G__9750;
continue;
} else {
var temp__5753__auto___9751__$1 = cljs.core.seq(seq__9622_9738);
if(temp__5753__auto___9751__$1){
var seq__9622_9752__$1 = temp__5753__auto___9751__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9622_9752__$1)){
var c__4649__auto___9753 = cljs.core.chunk_first(seq__9622_9752__$1);
var G__9754 = cljs.core.chunk_rest(seq__9622_9752__$1);
var G__9755 = c__4649__auto___9753;
var G__9756 = cljs.core.count(c__4649__auto___9753);
var G__9757 = (0);
seq__9622_9738 = G__9754;
chunk__9623_9739 = G__9755;
count__9624_9740 = G__9756;
i__9625_9741 = G__9757;
continue;
} else {
var map__9629_9758 = cljs.core.first(seq__9622_9752__$1);
var map__9629_9759__$1 = cljs.core.__destructure_map(map__9629_9758);
var gline_9760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9629_9759__$1,cljs.core.cst$kw$gline);
var gcol_9761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9629_9759__$1,cljs.core.cst$kw$gcol);
var name_9762 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9629_9759__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9760], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9622_9738,chunk__9623_9739,count__9624_9740,i__9625_9741,seq__9582_9688,chunk__9583_9689,count__9584_9690,i__9585_9691,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9629_9758,map__9629_9759__$1,gline_9760,gcol_9761,name_9762,seq__9622_9752__$1,temp__5753__auto___9751__$1,vec__9619_9735,column_9736,column_info_9737,seq__9582_9729__$1,temp__5753__auto___9728,vec__9579_9685,line_9686,columns_9687,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9761], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9686,cljs.core.cst$kw$col,column_9736,cljs.core.cst$kw$name,name_9762], null));
});})(seq__9622_9738,chunk__9623_9739,count__9624_9740,i__9625_9741,seq__9582_9688,chunk__9583_9689,count__9584_9690,i__9585_9691,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9629_9758,map__9629_9759__$1,gline_9760,gcol_9761,name_9762,seq__9622_9752__$1,temp__5753__auto___9751__$1,vec__9619_9735,column_9736,column_info_9737,seq__9582_9729__$1,temp__5753__auto___9728,vec__9579_9685,line_9686,columns_9687,inverted))
,cljs.core.sorted_map()));


var G__9763 = cljs.core.next(seq__9622_9752__$1);
var G__9764 = null;
var G__9765 = (0);
var G__9766 = (0);
seq__9622_9738 = G__9763;
chunk__9623_9739 = G__9764;
count__9624_9740 = G__9765;
i__9625_9741 = G__9766;
continue;
}
} else {
}
}
break;
}


var G__9767 = cljs.core.next(seq__9582_9729__$1);
var G__9768 = null;
var G__9769 = (0);
var G__9770 = (0);
seq__9582_9688 = G__9767;
chunk__9583_9689 = G__9768;
count__9584_9690 = G__9769;
i__9585_9691 = G__9770;
continue;
}
} else {
}
}
break;
}


var G__9771 = seq__9473_9681;
var G__9772 = chunk__9474_9682;
var G__9773 = count__9475_9683;
var G__9774 = (i__9476_9684 + (1));
seq__9473_9681 = G__9771;
chunk__9474_9682 = G__9772;
count__9475_9683 = G__9773;
i__9476_9684 = G__9774;
continue;
} else {
var temp__5753__auto___9775 = cljs.core.seq(seq__9473_9681);
if(temp__5753__auto___9775){
var seq__9473_9776__$1 = temp__5753__auto___9775;
if(cljs.core.chunked_seq_QMARK_(seq__9473_9776__$1)){
var c__4649__auto___9777 = cljs.core.chunk_first(seq__9473_9776__$1);
var G__9778 = cljs.core.chunk_rest(seq__9473_9776__$1);
var G__9779 = c__4649__auto___9777;
var G__9780 = cljs.core.count(c__4649__auto___9777);
var G__9781 = (0);
seq__9473_9681 = G__9778;
chunk__9474_9682 = G__9779;
count__9475_9683 = G__9780;
i__9476_9684 = G__9781;
continue;
} else {
var vec__9630_9782 = cljs.core.first(seq__9473_9776__$1);
var line_9783 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9630_9782,(0),null);
var columns_9784 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9630_9782,(1),null);
var seq__9633_9785 = cljs.core.seq(columns_9784);
var chunk__9634_9786 = null;
var count__9635_9787 = (0);
var i__9636_9788 = (0);
while(true){
if((i__9636_9788 < count__9635_9787)){
var vec__9659_9789 = chunk__9634_9786.cljs$core$IIndexed$_nth$arity$2(null,i__9636_9788);
var column_9790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9659_9789,(0),null);
var column_info_9791 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9659_9789,(1),null);
var seq__9662_9792 = cljs.core.seq(column_info_9791);
var chunk__9663_9793 = null;
var count__9664_9794 = (0);
var i__9665_9795 = (0);
while(true){
if((i__9665_9795 < count__9664_9794)){
var map__9668_9796 = chunk__9663_9793.cljs$core$IIndexed$_nth$arity$2(null,i__9665_9795);
var map__9668_9797__$1 = cljs.core.__destructure_map(map__9668_9796);
var gline_9798 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9668_9797__$1,cljs.core.cst$kw$gline);
var gcol_9799 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9668_9797__$1,cljs.core.cst$kw$gcol);
var name_9800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9668_9797__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9798], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9662_9792,chunk__9663_9793,count__9664_9794,i__9665_9795,seq__9633_9785,chunk__9634_9786,count__9635_9787,i__9636_9788,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9668_9796,map__9668_9797__$1,gline_9798,gcol_9799,name_9800,vec__9659_9789,column_9790,column_info_9791,vec__9630_9782,line_9783,columns_9784,seq__9473_9776__$1,temp__5753__auto___9775,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9799], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9783,cljs.core.cst$kw$col,column_9790,cljs.core.cst$kw$name,name_9800], null));
});})(seq__9662_9792,chunk__9663_9793,count__9664_9794,i__9665_9795,seq__9633_9785,chunk__9634_9786,count__9635_9787,i__9636_9788,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9668_9796,map__9668_9797__$1,gline_9798,gcol_9799,name_9800,vec__9659_9789,column_9790,column_info_9791,vec__9630_9782,line_9783,columns_9784,seq__9473_9776__$1,temp__5753__auto___9775,inverted))
,cljs.core.sorted_map()));


var G__9801 = seq__9662_9792;
var G__9802 = chunk__9663_9793;
var G__9803 = count__9664_9794;
var G__9804 = (i__9665_9795 + (1));
seq__9662_9792 = G__9801;
chunk__9663_9793 = G__9802;
count__9664_9794 = G__9803;
i__9665_9795 = G__9804;
continue;
} else {
var temp__5753__auto___9805__$1 = cljs.core.seq(seq__9662_9792);
if(temp__5753__auto___9805__$1){
var seq__9662_9806__$1 = temp__5753__auto___9805__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9662_9806__$1)){
var c__4649__auto___9807 = cljs.core.chunk_first(seq__9662_9806__$1);
var G__9808 = cljs.core.chunk_rest(seq__9662_9806__$1);
var G__9809 = c__4649__auto___9807;
var G__9810 = cljs.core.count(c__4649__auto___9807);
var G__9811 = (0);
seq__9662_9792 = G__9808;
chunk__9663_9793 = G__9809;
count__9664_9794 = G__9810;
i__9665_9795 = G__9811;
continue;
} else {
var map__9669_9812 = cljs.core.first(seq__9662_9806__$1);
var map__9669_9813__$1 = cljs.core.__destructure_map(map__9669_9812);
var gline_9814 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9669_9813__$1,cljs.core.cst$kw$gline);
var gcol_9815 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9669_9813__$1,cljs.core.cst$kw$gcol);
var name_9816 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9669_9813__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9814], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9662_9792,chunk__9663_9793,count__9664_9794,i__9665_9795,seq__9633_9785,chunk__9634_9786,count__9635_9787,i__9636_9788,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9669_9812,map__9669_9813__$1,gline_9814,gcol_9815,name_9816,seq__9662_9806__$1,temp__5753__auto___9805__$1,vec__9659_9789,column_9790,column_info_9791,vec__9630_9782,line_9783,columns_9784,seq__9473_9776__$1,temp__5753__auto___9775,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9815], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9783,cljs.core.cst$kw$col,column_9790,cljs.core.cst$kw$name,name_9816], null));
});})(seq__9662_9792,chunk__9663_9793,count__9664_9794,i__9665_9795,seq__9633_9785,chunk__9634_9786,count__9635_9787,i__9636_9788,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9669_9812,map__9669_9813__$1,gline_9814,gcol_9815,name_9816,seq__9662_9806__$1,temp__5753__auto___9805__$1,vec__9659_9789,column_9790,column_info_9791,vec__9630_9782,line_9783,columns_9784,seq__9473_9776__$1,temp__5753__auto___9775,inverted))
,cljs.core.sorted_map()));


var G__9817 = cljs.core.next(seq__9662_9806__$1);
var G__9818 = null;
var G__9819 = (0);
var G__9820 = (0);
seq__9662_9792 = G__9817;
chunk__9663_9793 = G__9818;
count__9664_9794 = G__9819;
i__9665_9795 = G__9820;
continue;
}
} else {
}
}
break;
}


var G__9821 = seq__9633_9785;
var G__9822 = chunk__9634_9786;
var G__9823 = count__9635_9787;
var G__9824 = (i__9636_9788 + (1));
seq__9633_9785 = G__9821;
chunk__9634_9786 = G__9822;
count__9635_9787 = G__9823;
i__9636_9788 = G__9824;
continue;
} else {
var temp__5753__auto___9825__$1 = cljs.core.seq(seq__9633_9785);
if(temp__5753__auto___9825__$1){
var seq__9633_9826__$1 = temp__5753__auto___9825__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9633_9826__$1)){
var c__4649__auto___9827 = cljs.core.chunk_first(seq__9633_9826__$1);
var G__9828 = cljs.core.chunk_rest(seq__9633_9826__$1);
var G__9829 = c__4649__auto___9827;
var G__9830 = cljs.core.count(c__4649__auto___9827);
var G__9831 = (0);
seq__9633_9785 = G__9828;
chunk__9634_9786 = G__9829;
count__9635_9787 = G__9830;
i__9636_9788 = G__9831;
continue;
} else {
var vec__9670_9832 = cljs.core.first(seq__9633_9826__$1);
var column_9833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9670_9832,(0),null);
var column_info_9834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9670_9832,(1),null);
var seq__9673_9835 = cljs.core.seq(column_info_9834);
var chunk__9674_9836 = null;
var count__9675_9837 = (0);
var i__9676_9838 = (0);
while(true){
if((i__9676_9838 < count__9675_9837)){
var map__9679_9839 = chunk__9674_9836.cljs$core$IIndexed$_nth$arity$2(null,i__9676_9838);
var map__9679_9840__$1 = cljs.core.__destructure_map(map__9679_9839);
var gline_9841 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9679_9840__$1,cljs.core.cst$kw$gline);
var gcol_9842 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9679_9840__$1,cljs.core.cst$kw$gcol);
var name_9843 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9679_9840__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9841], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9673_9835,chunk__9674_9836,count__9675_9837,i__9676_9838,seq__9633_9785,chunk__9634_9786,count__9635_9787,i__9636_9788,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9679_9839,map__9679_9840__$1,gline_9841,gcol_9842,name_9843,vec__9670_9832,column_9833,column_info_9834,seq__9633_9826__$1,temp__5753__auto___9825__$1,vec__9630_9782,line_9783,columns_9784,seq__9473_9776__$1,temp__5753__auto___9775,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9842], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9783,cljs.core.cst$kw$col,column_9833,cljs.core.cst$kw$name,name_9843], null));
});})(seq__9673_9835,chunk__9674_9836,count__9675_9837,i__9676_9838,seq__9633_9785,chunk__9634_9786,count__9635_9787,i__9636_9788,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9679_9839,map__9679_9840__$1,gline_9841,gcol_9842,name_9843,vec__9670_9832,column_9833,column_info_9834,seq__9633_9826__$1,temp__5753__auto___9825__$1,vec__9630_9782,line_9783,columns_9784,seq__9473_9776__$1,temp__5753__auto___9775,inverted))
,cljs.core.sorted_map()));


var G__9844 = seq__9673_9835;
var G__9845 = chunk__9674_9836;
var G__9846 = count__9675_9837;
var G__9847 = (i__9676_9838 + (1));
seq__9673_9835 = G__9844;
chunk__9674_9836 = G__9845;
count__9675_9837 = G__9846;
i__9676_9838 = G__9847;
continue;
} else {
var temp__5753__auto___9848__$2 = cljs.core.seq(seq__9673_9835);
if(temp__5753__auto___9848__$2){
var seq__9673_9849__$1 = temp__5753__auto___9848__$2;
if(cljs.core.chunked_seq_QMARK_(seq__9673_9849__$1)){
var c__4649__auto___9850 = cljs.core.chunk_first(seq__9673_9849__$1);
var G__9851 = cljs.core.chunk_rest(seq__9673_9849__$1);
var G__9852 = c__4649__auto___9850;
var G__9853 = cljs.core.count(c__4649__auto___9850);
var G__9854 = (0);
seq__9673_9835 = G__9851;
chunk__9674_9836 = G__9852;
count__9675_9837 = G__9853;
i__9676_9838 = G__9854;
continue;
} else {
var map__9680_9855 = cljs.core.first(seq__9673_9849__$1);
var map__9680_9856__$1 = cljs.core.__destructure_map(map__9680_9855);
var gline_9857 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9680_9856__$1,cljs.core.cst$kw$gline);
var gcol_9858 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9680_9856__$1,cljs.core.cst$kw$gcol);
var name_9859 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9680_9856__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9857], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9673_9835,chunk__9674_9836,count__9675_9837,i__9676_9838,seq__9633_9785,chunk__9634_9786,count__9635_9787,i__9636_9788,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9680_9855,map__9680_9856__$1,gline_9857,gcol_9858,name_9859,seq__9673_9849__$1,temp__5753__auto___9848__$2,vec__9670_9832,column_9833,column_info_9834,seq__9633_9826__$1,temp__5753__auto___9825__$1,vec__9630_9782,line_9783,columns_9784,seq__9473_9776__$1,temp__5753__auto___9775,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9858], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9783,cljs.core.cst$kw$col,column_9833,cljs.core.cst$kw$name,name_9859], null));
});})(seq__9673_9835,chunk__9674_9836,count__9675_9837,i__9676_9838,seq__9633_9785,chunk__9634_9786,count__9635_9787,i__9636_9788,seq__9473_9681,chunk__9474_9682,count__9475_9683,i__9476_9684,map__9680_9855,map__9680_9856__$1,gline_9857,gcol_9858,name_9859,seq__9673_9849__$1,temp__5753__auto___9848__$2,vec__9670_9832,column_9833,column_info_9834,seq__9633_9826__$1,temp__5753__auto___9825__$1,vec__9630_9782,line_9783,columns_9784,seq__9473_9776__$1,temp__5753__auto___9775,inverted))
,cljs.core.sorted_map()));


var G__9860 = cljs.core.next(seq__9673_9849__$1);
var G__9861 = null;
var G__9862 = (0);
var G__9863 = (0);
seq__9673_9835 = G__9860;
chunk__9674_9836 = G__9861;
count__9675_9837 = G__9862;
i__9676_9838 = G__9863;
continue;
}
} else {
}
}
break;
}


var G__9864 = cljs.core.next(seq__9633_9826__$1);
var G__9865 = null;
var G__9866 = (0);
var G__9867 = (0);
seq__9633_9785 = G__9864;
chunk__9634_9786 = G__9865;
count__9635_9787 = G__9866;
i__9636_9788 = G__9867;
continue;
}
} else {
}
}
break;
}


var G__9868 = cljs.core.next(seq__9473_9776__$1);
var G__9869 = null;
var G__9870 = (0);
var G__9871 = (0);
seq__9473_9681 = G__9868;
chunk__9474_9682 = G__9869;
count__9475_9683 = G__9870;
i__9476_9684 = G__9871;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
