// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer.call(null,writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count.call(null,self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item = cljs.core.first.call(null,cljs.core.val.call(null,f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key.call(null,f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item_set = cljs.core.val.call(null,f);
var item = cljs.core.first.call(null,item_set);
var priority_key = cljs.core.key.call(null,f);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__37418(s__37419){
return (new cljs.core.LazySeq(null,(function (){
var s__37419__$1 = s__37419;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__37419__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37424 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__37424,(0),null);
var item_set = cljs.core.nth.call(null,vec__37424,(1),null);
var iterys__4618__auto__ = ((function (s__37419__$1,vec__37424,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__37418_$_iter__37420(s__37421){
return (new cljs.core.LazySeq(null,((function (s__37419__$1,vec__37424,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__37421__$1 = s__37421;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__37421__$1);
if(temp__5753__auto____$1){
var s__37421__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37421__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__37421__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__37423 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__37422 = (0);
while(true){
if((i__37422 < size__4621__auto__)){
var item = cljs.core._nth.call(null,c__4620__auto__,i__37422);
cljs.core.chunk_append.call(null,b__37423,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__37472 = (i__37422 + (1));
i__37422 = G__37472;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37423),tailrecursion$priority_map$iter__37418_$_iter__37420.call(null,cljs.core.chunk_rest.call(null,s__37421__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37423),null);
}
} else {
var item = cljs.core.first.call(null,s__37421__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__37418_$_iter__37420.call(null,cljs.core.rest.call(null,s__37421__$2)));
}
} else {
return null;
}
break;
}
});})(s__37419__$1,vec__37424,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__37419__$1,vec__37424,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq.call(null,iterys__4618__auto__.call(null,item_set));
if(fs__4619__auto__){
return cljs.core.concat.call(null,fs__4619__auto__,tailrecursion$priority_map$iter__37418.call(null,cljs.core.rest.call(null,s__37419__$1)));
} else {
var G__37473 = cljs.core.rest.call(null,s__37419__$1);
s__37419__$1 = G__37473;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__37427(s__37428){
return (new cljs.core.LazySeq(null,(function (){
var s__37428__$1 = s__37428;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__37428__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37433 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__37433,(0),null);
var item_set = cljs.core.nth.call(null,vec__37433,(1),null);
var iterys__4618__auto__ = ((function (s__37428__$1,vec__37433,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__37427_$_iter__37429(s__37430){
return (new cljs.core.LazySeq(null,((function (s__37428__$1,vec__37433,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__37430__$1 = s__37430;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__37430__$1);
if(temp__5753__auto____$1){
var s__37430__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37430__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__37430__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__37432 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__37431 = (0);
while(true){
if((i__37431 < size__4621__auto__)){
var item = cljs.core._nth.call(null,c__4620__auto__,i__37431);
cljs.core.chunk_append.call(null,b__37432,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__37474 = (i__37431 + (1));
i__37431 = G__37474;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37432),tailrecursion$priority_map$iter__37427_$_iter__37429.call(null,cljs.core.chunk_rest.call(null,s__37430__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37432),null);
}
} else {
var item = cljs.core.first.call(null,s__37430__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__37427_$_iter__37429.call(null,cljs.core.rest.call(null,s__37430__$2)));
}
} else {
return null;
}
break;
}
});})(s__37428__$1,vec__37433,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__37428__$1,vec__37433,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq.call(null,iterys__4618__auto__.call(null,item_set));
if(fs__4619__auto__){
return cljs.core.concat.call(null,fs__4619__auto__,tailrecursion$priority_map$iter__37427.call(null,cljs.core.rest.call(null,s__37428__$1)));
} else {
var G__37475 = cljs.core.rest.call(null,s__37428__$1);
s__37428__$1 = G__37475;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = cljs.core.hash_unordered_coll.call(null,this$__$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv.call(null,self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = self__.item__GT_priority.call(null,item,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517));
if(cljs.core._EQ_.call(null,priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var item_set = self__.priority__GT_set_of_items.call(null,priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.call(null,self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.call(null,current_priority,priority)){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var current_priority_key = self__.keyfn.call(null,current_priority);
var item_set = cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key),item),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = self__.keyfn.call(null,priority);
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__37436(s__37437){
return (new cljs.core.LazySeq(null,(function (){
var s__37437__$1 = s__37437;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__37437__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37442 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__37442,(0),null);
var item_set = cljs.core.nth.call(null,vec__37442,(1),null);
var iterys__4618__auto__ = ((function (s__37437__$1,vec__37442,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__37436_$_iter__37438(s__37439){
return (new cljs.core.LazySeq(null,((function (s__37437__$1,vec__37442,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__37439__$1 = s__37439;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__37439__$1);
if(temp__5753__auto____$1){
var s__37439__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37439__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__37439__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__37441 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__37440 = (0);
while(true){
if((i__37440 < size__4621__auto__)){
var item = cljs.core._nth.call(null,c__4620__auto__,i__37440);
cljs.core.chunk_append.call(null,b__37441,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__37476 = (i__37440 + (1));
i__37440 = G__37476;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37441),tailrecursion$priority_map$iter__37436_$_iter__37438.call(null,cljs.core.chunk_rest.call(null,s__37439__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37441),null);
}
} else {
var item = cljs.core.first.call(null,s__37439__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__37436_$_iter__37438.call(null,cljs.core.rest.call(null,s__37439__$2)));
}
} else {
return null;
}
break;
}
});})(s__37437__$1,vec__37442,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__37437__$1,vec__37442,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq.call(null,iterys__4618__auto__.call(null,item_set));
if(fs__4619__auto__){
return cljs.core.concat.call(null,fs__4619__auto__,tailrecursion$priority_map$iter__37436.call(null,cljs.core.rest.call(null,s__37437__$1)));
} else {
var G__37477 = cljs.core.rest.call(null,s__37437__$1);
s__37437__$1 = G__37477;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__37445(s__37446){
return (new cljs.core.LazySeq(null,(function (){
var s__37446__$1 = s__37446;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__37446__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37451 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__37451,(0),null);
var item_set = cljs.core.nth.call(null,vec__37451,(1),null);
var iterys__4618__auto__ = ((function (s__37446__$1,vec__37451,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__37445_$_iter__37447(s__37448){
return (new cljs.core.LazySeq(null,((function (s__37446__$1,vec__37451,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__37448__$1 = s__37448;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__37448__$1);
if(temp__5753__auto____$1){
var s__37448__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37448__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__37448__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__37450 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__37449 = (0);
while(true){
if((i__37449 < size__4621__auto__)){
var item = cljs.core._nth.call(null,c__4620__auto__,i__37449);
cljs.core.chunk_append.call(null,b__37450,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__37478 = (i__37449 + (1));
i__37449 = G__37478;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37450),tailrecursion$priority_map$iter__37445_$_iter__37447.call(null,cljs.core.chunk_rest.call(null,s__37448__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37450),null);
}
} else {
var item = cljs.core.first.call(null,s__37448__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__37445_$_iter__37447.call(null,cljs.core.rest.call(null,s__37448__$2)));
}
} else {
return null;
}
break;
}
});})(s__37446__$1,vec__37451,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__37446__$1,vec__37451,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq.call(null,iterys__4618__auto__.call(null,item_set));
if(fs__4619__auto__){
return cljs.core.concat.call(null,fs__4619__auto__,tailrecursion$priority_map$iter__37445.call(null,cljs.core.rest.call(null,s__37446__$1)));
} else {
var G__37479 = cljs.core.rest.call(null,s__37446__$1);
s__37446__$1 = G__37479;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,this$__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__37480 = null;
var G__37480__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item);
});
var G__37480__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item,not_found);
});
G__37480 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__37480__2.call(this,self__,item);
case 3:
return G__37480__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__37480.cljs$core$IFn$_invoke$arity$2 = G__37480__2;
G__37480.cljs$core$IFn$_invoke$arity$3 = G__37480__3;
return G__37480;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args37417){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args37417)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
return (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq).call(null,this$__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.call(null,self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.call(null,self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__37454(s__37455){
return (new cljs.core.LazySeq(null,(function (){
var s__37455__$1 = s__37455;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__37455__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37460 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__37460,(0),null);
var item_set = cljs.core.nth.call(null,vec__37460,(1),null);
var iterys__4618__auto__ = ((function (s__37455__$1,vec__37460,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__37454_$_iter__37456(s__37457){
return (new cljs.core.LazySeq(null,((function (s__37455__$1,vec__37460,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__37457__$1 = s__37457;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__37457__$1);
if(temp__5753__auto____$1){
var s__37457__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37457__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__37457__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__37459 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__37458 = (0);
while(true){
if((i__37458 < size__4621__auto__)){
var item = cljs.core._nth.call(null,c__4620__auto__,i__37458);
cljs.core.chunk_append.call(null,b__37459,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__37481 = (i__37458 + (1));
i__37458 = G__37481;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37459),tailrecursion$priority_map$iter__37454_$_iter__37456.call(null,cljs.core.chunk_rest.call(null,s__37457__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37459),null);
}
} else {
var item = cljs.core.first.call(null,s__37457__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__37454_$_iter__37456.call(null,cljs.core.rest.call(null,s__37457__$2)));
}
} else {
return null;
}
break;
}
});})(s__37455__$1,vec__37460,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__37455__$1,vec__37460,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq.call(null,iterys__4618__auto__.call(null,item_set));
if(fs__4619__auto__){
return cljs.core.concat.call(null,fs__4619__auto__,tailrecursion$priority_map$iter__37454.call(null,cljs.core.rest.call(null,s__37455__$1)));
} else {
var G__37482 = cljs.core.rest.call(null,s__37455__$1);
s__37455__$1 = G__37482;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,sets);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__37463(s__37464){
return (new cljs.core.LazySeq(null,(function (){
var s__37464__$1 = s__37464;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__37464__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37469 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__37469,(0),null);
var item_set = cljs.core.nth.call(null,vec__37469,(1),null);
var iterys__4618__auto__ = ((function (s__37464__$1,vec__37469,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__37463_$_iter__37465(s__37466){
return (new cljs.core.LazySeq(null,((function (s__37464__$1,vec__37469,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__37466__$1 = s__37466;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__37466__$1);
if(temp__5753__auto____$1){
var s__37466__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37466__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__37466__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__37468 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__37467 = (0);
while(true){
if((i__37467 < size__4621__auto__)){
var item = cljs.core._nth.call(null,c__4620__auto__,i__37467);
cljs.core.chunk_append.call(null,b__37468,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__37483 = (i__37467 + (1));
i__37467 = G__37483;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37468),tailrecursion$priority_map$iter__37463_$_iter__37465.call(null,cljs.core.chunk_rest.call(null,s__37466__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37468),null);
}
} else {
var item = cljs.core.first.call(null,s__37466__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__37463_$_iter__37465.call(null,cljs.core.rest.call(null,s__37466__$2)));
}
} else {
return null;
}
break;
}
});})(s__37464__$1,vec__37469,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__37464__$1,vec__37469,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq.call(null,iterys__4618__auto__.call(null,item_set));
if(fs__4619__auto__){
return cljs.core.concat.call(null,fs__4619__auto__,tailrecursion$priority_map$iter__37463.call(null,cljs.core.rest.call(null,s__37464__$1)));
} else {
var G__37484 = cljs.core.rest.call(null,s__37464__$1);
s__37464__$1 = G__37484;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
return self__.keyfn.call(null,cljs.core.val.call(null,entry));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__37486 = arguments.length;
switch (G__37486) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_.call(null,elems)){
return cljs.core.into.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_.call(null,"tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37489 = arguments.length;
var i__4830__auto___37490 = (0);
while(true){
if((i__4830__auto___37490 < len__4829__auto___37489)){
args__4835__auto__.push((arguments[i__4830__auto___37490]));

var G__37491 = (i__4830__auto___37490 + (1));
i__4830__auto___37490 = G__37491;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__37492 = cljs.core.nnext.call(null,in$);
var G__37493 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__37492;
out = G__37493;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq37488){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37488));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37496 = arguments.length;
var i__4830__auto___37497 = (0);
while(true){
if((i__4830__auto___37497 < len__4829__auto___37496)){
args__4835__auto__.push((arguments[i__4830__auto___37497]));

var G__37498 = (i__4830__auto___37497 + (1));
i__4830__auto___37497 = G__37498;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_by.call(null,comparator);
while(true){
if(in$){
var G__37499 = cljs.core.nnext.call(null,in$);
var G__37500 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__37499;
out = G__37500;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq37494){
var G__37495 = cljs.core.first.call(null,seq37494);
var seq37494__$1 = cljs.core.next.call(null,seq37494);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37495,seq37494__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37503 = arguments.length;
var i__4830__auto___37504 = (0);
while(true){
if((i__4830__auto___37504 < len__4829__auto___37503)){
args__4835__auto__.push((arguments[i__4830__auto___37504]));

var G__37505 = (i__4830__auto___37504 + (1));
i__4830__auto___37504 = G__37505;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn);
while(true){
if(in$){
var G__37506 = cljs.core.nnext.call(null,in$);
var G__37507 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__37506;
out = G__37507;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq37501){
var G__37502 = cljs.core.first.call(null,seq37501);
var seq37501__$1 = cljs.core.next.call(null,seq37501);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37502,seq37501__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37511 = arguments.length;
var i__4830__auto___37512 = (0);
while(true){
if((i__4830__auto___37512 < len__4829__auto___37511)){
args__4835__auto__.push((arguments[i__4830__auto___37512]));

var G__37513 = (i__4830__auto___37512 + (1));
i__4830__auto___37512 = G__37513;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn,comparator);
while(true){
if(in$){
var G__37514 = cljs.core.nnext.call(null,in$);
var G__37515 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__37514;
out = G__37515;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq37508){
var G__37509 = cljs.core.first.call(null,seq37508);
var seq37508__$1 = cljs.core.next.call(null,seq37508);
var G__37510 = cljs.core.first.call(null,seq37508__$1);
var seq37508__$2 = cljs.core.next.call(null,seq37508__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37509,G__37510,seq37508__$2);
}));

