// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__78291 = (line + (1));
var G__78292 = (1);
var G__78293 = (counter + (1));
line = G__78291;
col = G__78292;
counter = G__78293;
continue;
} else {
var G__78294 = line;
var G__78295 = (col + (1));
var G__78296 = (counter + (1));
line = G__78294;
col = G__78295;
counter = G__78296;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__78297 = cljs.core.next.call(null,chars);
var G__78298 = (n__$1 - (1));
chars = G__78297;
n__$1 = G__78298;
continue;
} else {
var G__78299 = cljs.core.next.call(null,chars);
var G__78300 = n__$1;
chars = G__78299;
n__$1 = G__78300;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_.call(null,n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.call(null,cljs.core.str,cljs.core.concat.call(null,cljs.core.repeat.call(null,(n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__78301){
var map__78302 = p__78301;
var map__78302__$1 = cljs.core.__destructure_map.call(null,map__78302);
var line = cljs.core.get.call(null,map__78302__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__78302__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__78302__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__78302__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__78303_78311 = cljs.core.seq.call(null,full_reasons);
var chunk__78304_78312 = null;
var count__78305_78313 = (0);
var i__78306_78314 = (0);
while(true){
if((i__78306_78314 < count__78305_78313)){
var r_78315 = cljs.core._nth.call(null,chunk__78304_78312,i__78306_78314);
instaparse.failure.print_reason.call(null,r_78315);

cljs.core.println.call(null," (followed by end-of-string)");


var G__78316 = seq__78303_78311;
var G__78317 = chunk__78304_78312;
var G__78318 = count__78305_78313;
var G__78319 = (i__78306_78314 + (1));
seq__78303_78311 = G__78316;
chunk__78304_78312 = G__78317;
count__78305_78313 = G__78318;
i__78306_78314 = G__78319;
continue;
} else {
var temp__5753__auto___78320 = cljs.core.seq.call(null,seq__78303_78311);
if(temp__5753__auto___78320){
var seq__78303_78321__$1 = temp__5753__auto___78320;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__78303_78321__$1)){
var c__4649__auto___78322 = cljs.core.chunk_first.call(null,seq__78303_78321__$1);
var G__78323 = cljs.core.chunk_rest.call(null,seq__78303_78321__$1);
var G__78324 = c__4649__auto___78322;
var G__78325 = cljs.core.count.call(null,c__4649__auto___78322);
var G__78326 = (0);
seq__78303_78311 = G__78323;
chunk__78304_78312 = G__78324;
count__78305_78313 = G__78325;
i__78306_78314 = G__78326;
continue;
} else {
var r_78327 = cljs.core.first.call(null,seq__78303_78321__$1);
instaparse.failure.print_reason.call(null,r_78327);

cljs.core.println.call(null," (followed by end-of-string)");


var G__78328 = cljs.core.next.call(null,seq__78303_78321__$1);
var G__78329 = null;
var G__78330 = (0);
var G__78331 = (0);
seq__78303_78311 = G__78328;
chunk__78304_78312 = G__78329;
count__78305_78313 = G__78330;
i__78306_78314 = G__78331;
continue;
}
} else {
}
}
break;
}

var seq__78307 = cljs.core.seq.call(null,partial_reasons);
var chunk__78308 = null;
var count__78309 = (0);
var i__78310 = (0);
while(true){
if((i__78310 < count__78309)){
var r = cljs.core._nth.call(null,chunk__78308,i__78310);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__78332 = seq__78307;
var G__78333 = chunk__78308;
var G__78334 = count__78309;
var G__78335 = (i__78310 + (1));
seq__78307 = G__78332;
chunk__78308 = G__78333;
count__78309 = G__78334;
i__78310 = G__78335;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__78307);
if(temp__5753__auto__){
var seq__78307__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__78307__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__78307__$1);
var G__78336 = cljs.core.chunk_rest.call(null,seq__78307__$1);
var G__78337 = c__4649__auto__;
var G__78338 = cljs.core.count.call(null,c__4649__auto__);
var G__78339 = (0);
seq__78307 = G__78336;
chunk__78308 = G__78337;
count__78309 = G__78338;
i__78310 = G__78339;
continue;
} else {
var r = cljs.core.first.call(null,seq__78307__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__78340 = cljs.core.next.call(null,seq__78307__$1);
var G__78341 = null;
var G__78342 = (0);
var G__78343 = (0);
seq__78307 = G__78340;
chunk__78308 = G__78341;
count__78309 = G__78342;
i__78310 = G__78343;
continue;
}
} else {
return null;
}
}
break;
}
});
